# Adam Grenier - 双语对照

# Lenny's Podcast: Adam Grenier (Bilingual Transcript)

---

### (00:00:00) Adam Grenier

**English:**
One of the biggest pieces of advice I'm giving to people that are like, "How should we adjust our marketing with the economic changes and things like that?" I was like, "Start by assuming you no longer have product market fit, because you had product market fit in a different market." It's a different market now, so you have to start over. And hopefully you do, or it's pretty close to it and you just have to adjust a couple things, and you could be right back on track. But if you just assume you need to launch a new channel to fix this problem, you're going to be wrong, because your entire customer base changed, not just the next 10% of customers that you're looking for.

**中文翻译:**
我给那些询问“面对经济变化我们该如何调整营销”的人最大的建议之一就是：“首先假设你已经不再拥有‘产品市场契合度’（Product Market Fit, PMF）了，因为你之前的 PMF 是在另一个不同的市场环境中实现的。”现在的市场已经变了，所以你必须重新开始。运气好的话，你可能依然拥有 PMF，或者非常接近，只需要调整几件事就能重回正轨。但如果你只是想当然地认为通过开辟一个新渠道就能解决问题，那你就错了，因为改变的是你的整个客户群，而不仅仅是你正在寻找的下 10% 的新客户。

---

### (00:00:34) Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny and my goal here is to help you get better at the craft of building and growing products. I interview world class product leaders and growth experts to learn from their hard won experiences building and scaling today's most successful companies. Today, my guest is Adam Grenier. Adam was head of Growth Marketing and Innovation at Uber where he basically built their growth marketing infrastructure and the team from the ground up. Then he went on to VP of Product and Marketing at Lambda School, and most recently he was VP of Marketing at Masterclass. These days, Adam advises companies, large and small, on growth and marketing strategy.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助大家提升构建和增长产品的能力。我会采访世界级的产品领导者和增长专家，从他们构建和扩展当今最成功公司的宝贵经验中学习。今天的嘉宾是 Adam Grenier。Adam 曾任 Uber 的增长营销与创新负责人，在那里他基本上从零开始建立了增长营销基础设施和团队。随后，他担任了 Lambda School 的产品与营销副总裁，最近的一份职务是 Masterclass 的营销副总裁。如今，Adam 为大大小小的公司提供增长和营销策略方面的咨询。

---

### (00:01:10) Lenny

**English:**
In our conversation, we cover how to decide when to try new and emerging acquisition channels like TikTok, VR, newsletter ads, and how to go about testing them out. We get into the growth CMO role, which is an emerging role that Adam has helped pioneer, and we get into some real talk about burnout and depression and mental health issues that often come with working in tech. This was a really powerful and insightful conversation and I learned a lot from Adam both as an operator and as a human. I can't wait for you to hear this episode. And so with that, I bring you Adam Grenier.

**中文翻译:**
在我们的对话中，我们讨论了如何决定何时尝试新兴的获客渠道（如 TikTok、VR、新闻通讯广告），以及如何进行测试。我们深入探讨了“增长型 CMO”（Growth CMO）这一角色，这是 Adam 协助开创的一个新兴职位。此外，我们还真诚地聊到了在科技行业工作常伴随的职业倦怠、抑郁和心理健康问题。这是一次非常有力量且深刻的对话，无论作为一名运营者还是作为一个普通人，我都从 Adam 身上学到了很多。我迫不及待想让你们听到这一集。那么，让我们欢迎 Adam Grenier。

---

### (00:01:48) Lenny

**English:**
This episode is brought to you by Whimsical. When I ask product managers and designers on Twitter what software they use most, Whimsical is always one of the most mentioned products, and the users are fanatical. Whimsical is built for collaborative thinking combining visual, text and data canvases into one fluid medium. Distributed teams use Whimsical for workshops, white boarding, wire frames, user flows, and even feature specs, and that includes thousands of built-in icons and a rich library of templates. See why product teams at leading companies call Whimsical a game changer. Visit whimsical.com/lenny to have my own templates added to your account when you sign up. That's whimsical.com/lenny.

**中文翻译:**
本集节目由 Whimsical 赞助。当我在 Twitter 上询问产品经理和设计师他们最常使用什么软件时，Whimsical 总是被提及最多的产品之一，其用户群体非常狂热。Whimsical 专为协作思考而设计，将视觉、文本和数据画布整合到一个流畅的介质中。分布式团队使用 Whimsical 进行研讨会、白板演示、线框图制作、用户流程设计，甚至是功能规格说明，它还包含数千个内置图标和丰富的模板库。快来看看为什么领先公司的产品团队称 Whimsical 为“游戏规则改变者”。访问 whimsical.com/lenny，注册时即可将我的个人模板添加到您的账户。网址是 whimsical.com/lenny。

---

### (00:02:34) Lenny

**English:**
This episode is brought to you by Coda. Coda's an all-in-one doc that combines the best of documents, spreadsheets, and apps in one place. I actually use Coda every single day. It's my home base for organizing my newsletter writing, it's where I plan my content calendar, capture my research, and write the first drafts of each and every post. It's also where I curate my private knowledge repository for paid newsletter subscribers, and it's also how I manage the workflow for this very podcast. Over the years I've seen Coda evolve from being a tool that makes teams more productive, to one that also helps bring the best practices across the tech industry to life, with an incredibly rich collection of templates and guides in the Coda Dock Gallery, including resources from many guests on this podcast, including Shreyas, Gokul, and Shishir, the CEO of Coda.

**中文翻译:**
本集节目由 Coda 赞助。Coda 是一款全能文档工具，它将文档、电子表格和应用程序的优点集于一身。实际上我每天都在使用 Coda。它是我撰写新闻通讯的大本营，我在这里规划内容日历、记录研究资料，并撰写每一篇文章的初稿。它也是我为付费订阅者整理私人知识库的地方，我甚至用它来管理这个播客的工作流。多年来，我见证了 Coda 从一个提高团队生产力的工具，进化为一个将科技行业最佳实践变为现实的平台。Coda 文档库中有极其丰富的模板和指南，包括来自本播客许多嘉宾的资源，如 Shreyas、Gokul 以及 Coda 的 CEO Shishir。

---

### (00:03:23) Lenny

**English:**
Some of the best teams out there like Pinterest, Spotify, Square, and Uber use Coda to run effectively, and have published their templates for anyone to use. If you're ping ponging between lots of documents and spreadsheets, make your life better and start using Coda. You can take advantage of a special limited time offer just for startups. Head over to coda.io/lenny to sign up and get a $1,000 credit on your first statement. That's C-O-D-A.I-O/lenny to sign up and get a $1,000 in credit on your account.

**中文翻译:**
Pinterest、Spotify、Square 和 Uber 等顶尖团队都在使用 Coda 高效运作，并发布了供所有人使用的模板。如果你正忙于在大量的文档和表格之间切换，请使用 Coda 让生活变得更轻松。现在你可以享受专门针对初创公司的限时优惠。前往 coda.io/lenny 注册，即可在第一张账单中获得 1000 美元的抵扣额度。注册地址是 C-O-D-A.I-O/lenny。

---

### (00:04:02) Lenny

**English:**
Adam, welcome to the podcast.

**中文翻译:**
Adam，欢迎来到播客。

---

### (00:04:04) Adam Grenier

**English:**
Thank you. Thanks for having me.

**中文翻译:**
谢谢，感谢邀请。

---

### (00:04:06) Lenny

**English:**
It's my pleasure. I'm really excited to chat. So, I'm going to give a very brief overview of your very impressive career, and just let me know if I missed anything.

**中文翻译:**
这是我的荣幸。我很期待这次聊天。我会简单介绍一下你那令人印象深刻的职业生涯，如果我漏掉了什么，请告诉我。

---

### (00:04:15) Adam Grenier

**English:**
All right.

**中文翻译:**
好的。

---

### (00:04:15) Lenny

**English:**
Sound good?

**中文翻译:**
没问题吧？

---

### (00:04:15) Adam Grenier

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:04:17) Lenny

**English:**
Okay, so you were most recently VP of Marketing at Masterclass, which I'm actually a happy subscriber of and I've watched many a video. Before that, you were VP of Product and Marketing at Lambda School. I don't know if that's right before, but that was something you did. Also, you were head of Growth Marketing and Innovation at Uber, which is a really cool title. And I think you spent four years there and you basically built their growth marketing infrastructure and the team. And currently you're doing a bunch of advising and exploring to see what you want to do next. Is that about right?

**中文翻译:**
好，你最近的职位是 Masterclass 的营销副总裁，我本人就是 Masterclass 的忠实订阅者，看过很多视频。在那之前，你是 Lambda School 的产品与营销副总裁。我不确定这是否是紧接着的前一份工作，但确实是你做过的事情。此外，你还担任过 Uber 的增长营销与创新负责人，这个头衔非常酷。你在那里待了四年，基本上建立了他们的增长营销基础设施和团队。目前，你正在做大量的咨询工作，并探索下一步想做什么。我说的对吗？

---

### (00:04:50) Adam Grenier

**English:**
Yeah, you hit most of the key points. I think pre-Uber, the first chunk of my career was on the advertising side, so worked in agency world. So, I kind of think of this as phase three of my life. Ads world was phase one, startup and growth world phase two, and now really just spending time helping entrepreneurs and founders and built companies and that type of stuff.

**中文翻译:**
是的，你抓住了大部分重点。在加入 Uber 之前，我职业生涯的第一阶段是在广告领域，在代理公司工作。所以我把现在看作是我人生的第三阶段。广告世界是第一阶段，初创公司和增长领域是第二阶段，现在我主要花时间帮助企业家和创始人建立公司之类的。

---

### (00:05:16) Lenny

**English:**
What's been your favorite phase so far?

**中文翻译:**
到目前为止，你最喜欢哪个阶段？

---

### (00:05:18) Adam Grenier

**English:**
I mean all of them. I just embrace what gets thrown at me and allow it to organically happen. So, each phase has had its pros and cons and ups and downs, and so I think they've all fit pretty well into where I was in my career.

**中文翻译:**
我觉得都喜欢。我只是拥抱摆在面前的一切，让它自然发生。每个阶段都有其优缺点和起伏，我认为它们都非常契合我当时职业生涯所处的阶段。

---

### (00:05:34) Lenny

**English:**
Speaking of moving and adjusting and iterating, I know you're big into improv. How serious are you about improv?

**中文翻译:**
说到移动、调整和迭代，我知道你非常喜欢即兴表演（Improv）。你对即兴表演有多认真？

---

### (00:05:44) Adam Grenier

**English:**
Good question. Serious in the sense that I've done it for a very long time and I still do it and I try to do it regularly. Serious as in am I aiming to make money off of it and have a career out of it? Unfortunately not. There was a point in my life that that is what I wanted to do. I lived in Chicago, did Second City ImprovOlympic, a variety of different places, did quite a bit of performing, but also got into corporate paychecks early as well.

**中文翻译:**
好问题。说认真，是因为我已经做了很长时间，现在依然在做，并尝试定期练习。但要说认真到是否想靠它赚钱或以此为职业？遗憾的是，并没有。我生命中确实有过一段时期想以此为业。我曾住在芝加哥，在 Second City 和 ImprovOlympic 等很多地方学习和表演过，但我很早就开始拿公司的薪水了。

---

### (00:06:12) Adam Grenier

**English:**
And so kind of built a lifestyle that made doing improv full time probably not the best path for me at the time. And so made a pretty conscious choice early on that it was more of a hobby and if something ever came of it, cool, but if not, that's okay. It's something I keep coming back to, because it's very grounding and fulfilling in ways that work and family life and things like that don't quite hit for me.

**中文翻译:**
所以我建立了一种生活方式，这使得当时全职做即兴表演可能并不是我的最佳路径。因此，我很早就做出了一个清醒的选择，把它当作一种爱好。如果以后能有什么发展，那很好；如果没有，也没关系。这是我一直坚持做的事情，因为它非常接地气，能带给我工作和家庭生活无法提供的成就感。

---

### (00:06:34) Lenny

**English:**
Actually at Airbnb we had an improv teacher come and work with the PM team. It was for months. We did improv games once a week.

**中文翻译:**
实际上在 Airbnb 时，我们曾请过一位即兴表演老师来指导产品经理团队。持续了好几个月，我们每周玩一次即兴表演游戏。

---

### (00:06:42) Adam Grenier

**English:**
Nice.

**中文翻译:**
太棒了。

---

### (00:06:43) Lenny

**English:**
And played all these fun things. And I'm curious what you've taken away from improv that has helped you become better at your work?

**中文翻译:**
玩了很多有趣的游戏。我很好奇，你从即兴表演中学到了什么能帮助你在工作中表现得更好？

---

### (00:06:51) Adam Grenier

**English:**
So, I think generally the whole suite of skills that you develop in improv are pretty applicable, right? Because you are getting comfortable on your feet with change, with teamwork, building off of each other, experimenting, trying new things, a little bit of everything. I think a couple of the key rules or themes of improv that I really try to hammer home with people are obviously the "Yes, and..." side of improv, which everyone's probably heard, which is in a scene the worst thing you could do is deny somebody, because you're actually just stopping progress and you're not building off of anything.

**中文翻译:**
我认为你在即兴表演中培养的全套技能都非常适用。因为你在表演中会逐渐习惯应对变化、团队合作、相互借力、实验和尝试新事物。我认为即兴表演中有几个关键规则或主题是我一直向人们强调的，首先显然是“是的，而且……”（Yes, and...），大家可能都听说过。在场景中，你最不该做的就是否定别人，因为那会停止进度，让你无法在任何基础上继续构建。

---

### (00:07:27) Adam Grenier

**English:**
So, the appropriate approach is to say, "Yes, that is true, and..." and add to it. So, if someone's like, "Hey, you have a chicken on your head," not saying, "No, I don't." Just kind of ruins that scene. Versus saying, "Yes, I do, and it's name is Sally. What's your chicken's name?" Builds on that and gives it more opportunity. And so I think that in growth in business is super important to be able to say, "Yes, I do see your idea," or "Yes, we did accomplish this and this is what we want to do next and this is how it's going to build on it," I think is super important.

**中文翻译:**
所以，正确的做法是说：“是的，没错，而且……”然后补充内容。比如有人说：“嘿，你头上有一只鸡。”如果你说：“不，我没有。”这戏就演不下去了。但如果你说：“是的，我有，它叫 Sally。你的鸡叫什么名字？”这就在原有的基础上进行了构建，创造了更多可能性。我认为在业务增长中，能够说“是的，我理解你的想法”或者“是的，我们确实完成了这个目标，接下来我们想做这个，它是这样基于之前成果的”，这一点至关重要。

---

### (00:07:59) Adam Grenier

**English:**
The other one that I think is less known or talked about is the gift of details. So, in a scene, if you give somebody really specific details about something, it gives so much more meat to be able to work off of in terms of what's coming next. So, if someone's starting a scene and they're clearly watching television and clicking through the channels and I walk up and just say like, "Oh, you're watching TV, cool." That's a yes statement. I'm not denying what they did. But if I come up and say like, "Oh cool, you're watching TV. Is that an Alf episode? I haven't seen Alf since I was a kid. It reminds me this one time I actually ate my own cat."

**中文翻译:**
另一个我觉得较少被人提及的是“细节的馈赠”。在场景中，如果你给对方非常具体的细节，就会为接下来的发展提供更多的素材。比如，如果有人开始演戏，显然是在看电视并切换频道，我走过去只说：“噢，你在看电视，酷。”这是一个肯定的陈述，我没有否定对方。但如果我走过去说：“噢酷，你在看电视。那是《外星人阿尔夫》（Alf）吗？我从小时候起就没看过《阿尔夫》了。这让我想起有一次我竟然吃了我自己的猫。”

---

### (00:08:39) Adam Grenier

**English:**
Just giving those specific details of Alf and me as a kid and I had a cat, which if people don't know Alf, he ate cats.

**中文翻译:**
给出这些具体的细节——《阿尔夫》、我小时候、我有一只猫（如果人们不知道《阿尔夫》，他其实是吃猫的）。

---

### (00:08:48) Lenny

**English:**
I don't remember that. I remember Alf, but I don't remember he ate cats.

**中文翻译:**
我不记得那个了。我记得《阿尔夫》，但不记得他吃猫。

---

### (00:08:51) Adam Grenier

**English:**
He was always trying to get the family cat. So, those kinds of details add a ton of value and you take that into the business world, to use Masterclass for instance, if I say, "Yeah, Masterclass, we've got this way to build content that is both entertainment and education," that's interesting. But if I say, "We create content that is both education and entertainment to solve people's deep curiosities in the way that maybe a biography would." That just opens up the exact problem that you're trying to solve. What are other alternatives to that problem? How are people consuming that? So, I think the gift of details in good improv and learning those skills is something that I really value and look for in every aspect of my business life as well.

**中文翻译:**
他总是想抓那家的猫。所以，这类细节能增加巨大的价值。把这应用到商业世界，以 Masterclass 为例，如果我说：“是的，Masterclass，我们有一种构建内容的方式，既有娱乐性又有教育性。”这很有趣。但如果我说：“我们创造既具教育意义又具娱乐性的内容，以类似于传记的方式解决人们深层的好奇心。”这一下子就揭示了你试图解决的具体问题。那个问题的其他替代方案是什么？人们是如何消费这些内容的？所以我认为，优秀即兴表演中的“细节馈赠”以及学习这些技能，是我在商业生活的方方面面都非常看重并追求的东西。

---

### (00:09:41) Lenny

**English:**
It sounds like it's really helpful, one, in marketing, creativity and positioning, and things like that you just described. Have you found it also to be helpful in collaboration like this "Yes, and..." piece? I'm curious, is there an example or story where you like "Yes, and..." someone? Do you actually say "Yes, and..." in a meeting? How do you actually find that you use it?

**中文翻译:**
听起来这在营销、创意和定位等方面非常有帮助，就像你刚才描述的那样。你是否发现它在协作中也很有用，比如“是的，而且……”这一部分？我很好奇，有没有什么例子或故事是你对某人用了“是的，而且……”？你真的会在会议上说“是的，而且……”吗？你实际上是怎么运用它的？

---

### (00:09:58) Adam Grenier

**English:**
I hear it every now and then. I don't usually literally say it. I think one of the areas that I've found it to be valuable is when you've got cross-functional work. So, obviously at Uber we dealt with city teams a lot, and so a lot of the times the way that the central team would scope a problem versus a local team would scope a problem, would almost feel at odds with each other. And if you approach it with that "Yes, and...", it's often still true.

**中文翻译:**
我偶尔会听到别人这么说，但我通常不会逐字说出来。我觉得它非常有价值的一个领域是跨职能协作。显然，在 Uber 我们经常要和城市团队打交道，很多时候总部团队界定问题的方式与地方团队界定问题的方式几乎是冲突的。如果你用“是的，而且……”的方式去处理，通常两者都是成立的。

---

### (00:10:24) Adam Grenier

**English:**
It's like, oh, both of these things can be true at once. You could have a different goal than I have, or you have a system problem local to you that is important to you and it's not important to me. That's okay, both things can exist. So, now that we accept both and can work off of each other, we're more likely to build both a better rapport and energy among ourselves because we're not just saying, "No, no, no, no, you're wrong. That's not true, that's not important to the business. Why are you doing that?" That type of energy when cross-functional work, it just kills the scene, it kills that progress. And then you don't build relationships, you don't build the right solutions, all that type of stuff.

**中文翻译:**
就像是，噢，这两件事可以同时成立。你的目标可能和我的不同，或者你当地有一个对你很重要但对我来说不重要的系统性问题。没关系，两者可以共存。既然我们接受了双方的观点并能相互借力，我们就更有可能建立更好的关系和氛围，因为我们不是在说：“不不不，你错了。那不对，那对业务不重要。你为什么要那样做？”在跨职能工作中，那种负能量会毁掉整个局面，阻碍进度。结果就是你无法建立关系，也无法找到正确的解决方案。

---

### (00:11:06) Lenny

**English:**
It sounds really good. Everyone in theory wants to be really good at this. And I imagine just doing a bunch of improv is a really good way to get better at not getting defensive and being like, "Yes. And how do we make this idea better?" Is there something you can advise folks to work on this skill, or is it just do a bunch of improv classes and it'll kind of help build that skill?

**中文翻译:**
听起来很棒。理论上每个人都想擅长这个。我猜多做即兴表演是学会不设防、并学会说“是的，我们如何让这个想法更好”的好方法。关于如何锻炼这项技能，你有什么建议吗？还是说只要去上即兴表演课就能培养出这项技能？

---

### (00:11:25) Adam Grenier

**English:**
That's one. I would say that I'll say that all the time to people, "Do some improv classes." And I get a lot of people like, "No, I'm not funny," or, "I don't want to do improv." And I think it's still a really great class to take, even if you have zero interest in doing improv, or public speaking, or any of that kind of stuff. Because, again, improv 101 is taught everywhere. Every city has it somewhere, and it's rarely ever people that are trying to do improv professionally. It's all games, like you said. The classes that you all did at Airbnb is what improv 101 is, right?

**中文翻译:**
那是方法之一。我会一直对人们说：“去上几节即兴表演课吧。”很多人会回答：“不，我不幽默”或者“我不想做即兴表演”。但我认为这仍然是一门非常棒的课程，即使你对即兴表演、公开演讲或类似的事情毫无兴趣。因为即兴表演入门课（Improv 101）到处都有。每个城市都有这样的地方，而且去上课的人很少是想成为专业演员的。就像你说的，全是游戏。你们在 Airbnb 上的那些课就是即兴表演入门课的内容，对吧？

---

### (00:12:00) Adam Grenier

**English:**
It's just like, "Hey, let's just have fun. Let's just get out of our skin," and things like that. So, I do think everybody should take improv classes. I think it's also something with a lot of goals or skills that you want to develop, I think being really public and open about you wanting to develop that. So, if you are managing a team and you want to sharpen the skills, make it a team goal, or have accountability and just say, "Hey guys, I know that I've been pushing back on things lately. I want to really try to embrace and grow off of ideas better, hold me accountable, call me out and be like, 'Adam, "Yes, and..." this please."

**中文翻译:**
它就像是，“嘿，让我们找点乐子，让我们跳出舒适圈”之类的。所以我确实认为每个人都应该上即兴表演课。此外，对于你想培养的许多目标或技能，我认为公开、坦诚地表达你想发展的意愿也很重要。所以，如果你正在管理一个团队并想磨练这些技能，可以把它设为团队目标，或者建立问责机制，直接说：“嘿伙计们，我知道我最近一直在否定一些事情。我想尝试更好地接纳并完善想法，请监督我，提醒我，比如对我说：‘Adam，请对这件事用“是的，而且……”’。”

---

### (00:12:32) Adam Grenier

**English:**
Or giving people permission to push back on that when it doesn't happen, I think also just opens the door for more productive conversations with people and the ability to hold yourself accountable and keep trying it.

**中文翻译:**
或者允许别人在你没做到时提出异议，我认为这也能为更高效的沟通打开大门，让你能够自我约束并不断尝试。

---

### (00:12:47) Lenny

**English:**
I love that. And such a good team bonding activity. There's like all these reasons to do this as a team. My wife actually, she's a designer, artist, writer, illustrator kind of person, and she's been taking a lot of these sorts of classes to help inspire her creativity. She never wants to be an improv person, she did stand up classes.

**中文翻译:**
我喜欢这个主意。而且这真是一个很好的团队建设活动。作为一个团队去做这件事有很多理由。我妻子其实是一个设计师、艺术家、作家和插画家，她一直在上很多这类课程来激发创意。她从不想成为即兴表演者，但她上过脱口秀（Stand-up）课程。

---

### (00:13:03) Adam Grenier

**English:**
That's awesome.

**中文翻译:**
那太棒了。

---

### (00:13:05) Lenny

**English:**
As you said, it just helps you get the juices flowing along these lines. Okay, so we're not going to talk about improv the whole time.

**中文翻译:**
正如你所说，这有助于激发灵感。好了，我们不会整场都聊即兴表演。

---

### (00:13:13) Adam Grenier

**English:**
We could if you want to.

**中文翻译:**
如果你想聊，我们也可以聊。

---

### (00:13:15) Lenny

**English:**
We could. Throw me word, let's go. No, we don't want to do that. So, there's basically three things I really wanted to chat about with you. One is how to decide when to invest in an emerging acquisition channel like TikTok, VR, Clubhouse was a big thing. You have some really interesting thoughts on how to decide and approach this thing. To the growth CMR role, which is kind of this, I think emerging role, something you're really good at, and I just want to get your thoughts on what's happening there. And then, three, some real talk on burnout and depression that often comes with working in tech and stuff that we go through. Does that sound good?

**中文翻译:**
我们可以。给我个词，我们开始吧。不，我们不想那样。基本上有三件事我非常想和你聊聊。第一，如何决定何时投资新兴的获客渠道，比如 TikTok、VR，还有曾经很火的 Clubhouse。关于如何决策和处理这些渠道，你有一些非常有趣的见解。第二，增长型 CMO（Growth CMO）的角色，我认为这是一个新兴职位，也是你非常擅长的，我想听听你对这个职位的看法。第三，关于在科技行业工作常遇到的职业倦怠和抑郁的真心话。听起来可以吗？

---

### (00:13:51) Adam Grenier

**English:**
Yeah.

**中文翻译:**
可以。

---

### (00:13:51) Lenny

**English:**
Okay, great. So, to start with in the first topic, if you think about it just every company essentially goes through this kind of S-curve of growth. They start slow, they find something that's working, then hopefully it works out and things start to grow, grow, grow, and then eventually it flattens out and you see this S-curve that happens. And every company is always trying to find the next S-curve to add this layer on the cake that keeps overall growth up while this first growth channel slows.

**中文翻译:**
太好了。首先是第一个话题。如果你仔细想想，基本上每家公司都会经历这种增长的 S 型曲线。开始很慢，然后找到了行之有效的方法，接着一切顺利，开始爆发式增长，最后趋于平缓，这就是 S 型曲线。每家公司都在寻找下一个 S 型曲线，以便在第一个增长渠道放缓时，增加一层“蛋糕”来维持整体增长。

---

### (00:14:18) Lenny

**English:**
And so people are always looking for what's the next thing? "Oh man, Clubhouse is coming out. We should get on Clubhouse." "Oh, TikTok is so hot, we've got to run some TikTok ads." And there's always something new, like newsletter ads, I don't know, podcast ads, if that's new. And you have a really interesting framework for how to think about this and make decisions and experiment. So, I'd love to hear insights there.

**中文翻译:**
所以人们总是在寻找下一个热点：“噢天哪，Clubhouse 出来了，我们应该加入。”“噢，TikTok 太火了，我们得投点 TikTok 广告。”总会有新东西出现，比如新闻通讯广告，或者播客广告（如果那算新颖的话）。关于如何思考、决策和实验，你有一个非常有趣的框架。我很想听听你的见解。

---

### (00:14:38) Adam Grenier

**English:**
So, the exploring emerging channels framework that I'll take, either my teams or companies that I'm advising through, has three core ingredients that I like to spend time with. So, the first is really understanding if there is an overlap between what the customers need is, what your company's goals are, and what the channel actually does really well. So, the example I've used in the past is Spotify in the moment of things like Clubhouse and Paparazzi and stuff like that becoming really popular.

**中文翻译:**
我会带着我的团队或我咨询的公司使用这个“探索新兴渠道框架”，它包含三个我喜欢深入研究的核心要素。第一，是真正理解客户需求、公司目标以及该渠道擅长的事情之间是否存在交集。我过去用过的一个例子是，当 Clubhouse 和 Paparazzi 之类的应用变得非常流行时的 Spotify。

---

### (00:15:14) Adam Grenier

**English:**
Well, for Spotify, they're trying to get more people to consume music and be entertained by music and things like that. And it's all audio driven. And so their growth goals are probably around new customers or deeper engagement with audio. The customer's needs are discovery and more ways to maybe have deeper relationships with their music. If you're a jazz fan, can you learn new jazz artists or more about the artists that you love? Things like that. And then take those two channels. If you take something like Clubhouse, it's audio first, it's almost like live podcast radio type feel to it.

**中文翻译:**
对于 Spotify 来说，他们试图让更多人消费音乐、享受音乐娱乐等等。这完全是音频驱动的。所以他们的增长目标可能是获取新客户或加深音频互动。客户的需求是发现音乐，以及可能与音乐建立更深层次联系的方式。如果你是爵士乐迷，你能否了解新的爵士艺术家或更多关于你喜爱的艺术家的信息？诸如此类。然后看这两个渠道。如果你看 Clubhouse，它是音频优先的，感觉就像是直播播客或广播。

---

### (00:15:57) Adam Grenier

**English:**
You can get into these rooms with just people with really amazing esoteric knowledge about something. And so its strengths have a really clean overlap to me with the goals of Spotify, the needs of the customer and the strengths of that. And so that to me is great. That is probably a green light in terms of is it even worth our time? Versus Paparazzi is very photo driven and nothing really to do with music or anything like that. And so it's like even though Paparazzi might have become the best biggest channel ever, is that the thing you should be putting your time into? It would be a yellow light for me at best.

**中文翻译:**
你可以进入这些房间，里面的人对某些事物有着惊人的、深奥的知识。所以对我来说，它的优势与 Spotify 的目标、客户需求以及渠道本身的强项有着非常清晰的交集。因此，这对我来说很棒。在“是否值得投入时间”方面，这可能是一个绿灯。相比之下，Paparazzi 是以照片驱动的，与音乐基本无关。所以，即使 Paparazzi 可能会成为有史以来最大最好的渠道，那是你应该投入时间的地方吗？对我来说，那充其量是个黄灯。

---

### (00:16:36) Lenny

**English:**
And how did you describe that again? It's the medium matches?

**中文翻译:**
你刚才怎么描述的？是媒介匹配吗？

---

### (00:16:40) Adam Grenier

**English:**
Yeah, the strengths of the medium. So, let's take influencer right now. Actually two of the channels that a lot of people are talking about right now are streaming TV or OTT and influencer marketing. And so to me, one of the strengths of influencer marketing is hyper targeted contextual marketing. And so I can go find the five influencers that are hardcore Alf fans, and if I'm marketing Alf something, great, I can go find that specific thing. Whereas OTTs a lot harder to get that specific.

**中文翻译:**
是的，媒介的优势。以现在的网红营销（Influencer Marketing）为例。实际上，现在很多人在谈论的两个渠道是流媒体电视（OTT）和网红营销。对我来说，网红营销的优势之一是超精准的情境营销。我可以找到五个《外星人阿尔夫》的铁杆粉丝网红，如果我要推销阿尔夫的相关产品，太棒了，我可以找到那个特定的群体。而 OTT 则很难做到那么精准。

---

### (00:17:16) Adam Grenier

**English:**
OTT strength is broad reach and video storytelling and that type of stuff. So, it's like, okay, well maybe my medium is if I'm Masterclass and I have a ton of video content and storytelling and things like that, that channel actually makes a ton of sense probably. So, it's like what are the strengths of that channel is something that... that is actually probably the piece I see people ignore the most, which is they just want to know if a channel is hot or not. And this gets especially hairy in this world of a lot of B2B doing more consumer-esque marketing. There's so many B2B companies that just don't apply to emerging consumer channels.

**中文翻译:**
OTT 的优势在于广泛的覆盖面和视频叙事能力。所以，如果我是 Masterclass，我有大量的视频内容和故事讲述，那么这个渠道可能非常有意义。所以，“该渠道的优势是什么”是人们最容易忽略的一点，他们往往只想知道一个渠道火不火。在当今许多 B2B 公司都在做更趋向 C 端营销的世界里，这变得尤为棘手。有很多 B2B 公司根本不适用于新兴的 C 端渠道。

---

### (00:18:00) Adam Grenier

**English:**
And it's just like, please just stop. I don't need a Notion Clubhouse channel this week. And maybe there's a world to do that. But I think that's kind of number one, is making sure that there's even a reason that you should be there to put it on your radar right now.

**中文翻译:**
就像是，拜托停下来吧。我这周不需要一个 Notion 的 Clubhouse 频道。也许在某种情况下可以做，但我认为首要任务是确保你确实有理由出现在那里，然后才把它列入你的考虑范围。

---

### (00:18:19) Lenny

**English:**
Awesome. What does the OTT stand for by the way?

**中文翻译:**
太棒了。顺便问一下，OTT 代表什么？

---

### (00:18:22) Adam Grenier

**English:**
Oh my gosh, you're putting it on the spot.

**中文翻译:**
噢天哪，你把我问住了。

---

### (00:18:24) Lenny

**English:**
It's all good.

**中文翻译:**
没事。

---

### (00:18:25) Adam Grenier

**English:**
I'm drawing a blank on it.

**中文翻译:**
我脑子里一片空白。

---

### (00:18:26) Lenny

**English:**
But essentially it's a streaming platform?

**中文翻译:**
但本质上它是一个流媒体平台？

---

### (00:18:28) Adam Grenier

**English:**
Over the top. Over the top. So, instead of it being cable TV, it's coming from a box. So, it's primarily if you think of ads on Amazon or Hulu or even if you go to cnn.com and you start streaming and you get an ad first. it's basically video ads, but a lot of them now are happening on televisions and on streaming services rather than just on websites.

**中文翻译:**
Over the top（过顶内容服务）。所以，它不是有线电视，而是通过机顶盒传输的。如果你想到 Amazon 或 Hulu 上的广告，或者你去 cnn.com 开始播放视频时先看到的广告，那基本上就是视频广告，但现在很多都出现在电视和流媒体服务上，而不仅仅是在网站上。

---

### (00:18:55) Lenny

**English:**
Got it. Okay, cool. So, the first is the strength of the channel. You should look at that.

**中文翻译:**
明白了。好，酷。所以第一点是渠道的优势，应该关注这一点。

---

### (00:18:59) Adam Grenier

**English:**
Yep. And how that overlaps with your customer and your business needs. The second is the channel DNA. And so this is looking at things like where are they in their trajectory? So, Clubhouse is actually a perfect example, because in a weird way, so Clubhouse got hot before Facebook got cold. And I was pretty amazed how many more people were trying to crack Clubhouse than TikTok, because TikTok hadn't really released their ads solution yet, but neither had Clubhouse. But everybody was talking about Clubhouse, and TikTok is very clearly not going away anytime soon, where Clubhouse hopefully won't. Like this is an amazing product.

**中文翻译:**
是的，以及它如何与你的客户和业务需求重叠。第二点是“渠道基因”（Channel DNA）。这包括观察它们处于什么样的发展轨迹。Clubhouse 实际上是一个完美的例子，因为说来也怪，Clubhouse 是在 Facebook 变冷清之前火起来的。我很惊讶竟然有那么多人试图攻克 Clubhouse 而不是 TikTok，因为当时 TikTok 还没真正发布广告解决方案，Clubhouse 也没有。但每个人都在谈论 Clubhouse，而 TikTok 显然不会很快消失，Clubhouse 希望也不会。这是一款很棒的产品。

---

### (00:19:41) Adam Grenier

**English:**
I really enjoyed it and loved it, but it was clearly very early, very quickly at that point of hotness where everyone was just kind of, "That's the reason I should be there." And part of this reason is to accept the risks of going into that channel. So, if I go and dedicate two quarters of work to Clubhouse, I need to accept that they are so early in this curve that there's a good chance this is a once in a lifetime opportunity and it'll be over. It's not a repeatable action. It also is important because if you get something to work on a channel that's earlier in their growth curve, the likelihood that they will change is very high.

**中文翻译:**
我真的很喜欢它，但它显然处于非常早期的阶段，在那个火爆的节点上，每个人都觉得“这就是我应该在那里的理由”。部分原因是要接受进入该渠道的风险。如果我投入两个季度的时间在 Clubhouse 上，我必须接受它们处于增长曲线的极早期，很有可能这只是昙花一现的机会，很快就会结束。这不是一个可重复的行为。这也很重要，因为如果你在一个处于增长曲线早期的渠道上做成了某件事，它们发生剧烈变化的可能性非常高。

---

### (00:20:23) Adam Grenier

**English:**
You're going to need to commit a lot of cycles to keep it going, because it's like, "Okay, well, their product is going to evolve drastically very quickly over the next two years." And so a really great example is Facebook early... I was at Zoosk. And so Zoozk and companies like Zynga got tons of their early growth because of notifications on Facebook, which was one of their early features, which allowed basically anybody that took any action on Zynga, it would post on everybody else's page that you got 10 carrots, and that was a huge growth lever.

**中文翻译:**
你需要投入大量的精力来维持它，因为在接下来的两年里，它们的产品会发生翻天覆地的变化。一个很好的例子是早期的 Facebook……我当时在 Zoosk。Zoosk 和 Zynga 这样的公司通过 Facebook 的通知功能获得了大量的早期增长。那是 Facebook 早期的功能之一，基本上任何人在 Zynga 上做了什么动作，都会在其他所有人的页面上发布你得到了 10 根胡萝卜，那是一个巨大的增长杠杆。

---

### (00:20:59) Adam Grenier

**English:**
But then Facebook just pulled the plug on that. And so it's like, well, if you put all of your energy into that and that's it, it was pretty clear that that was still an area that's like this may not last forever. The last thing on the channel DNA that I like to look at that's a little bit more, I don't know if odd or unusual is the right term, is I like to spend a lot of time thinking about how they monetize. What is the monetization strategy of the channel? And the reason is because if you, as a business, can match or support their monetization strategy, it actually gives you a really interesting leg up with that channel.

**中文翻译:**
但后来 Facebook 直接停掉了那个功能。所以，如果你把所有的精力都放在那上面，结果就很明显了——那是一个可能无法持久的领域。关于渠道基因，我喜欢看的最后一点可能有点奇怪或不寻常，那就是我喜欢花很多时间思考它们是如何变现的。该渠道的变现策略是什么？原因是，如果你作为一家企业能够匹配或支持它们的变现策略，实际上会让你在该渠道中获得非常有趣的优势。

---

### (00:21:37) Adam Grenier

**English:**
Because the likelihood of you being able to call them up and go do custom stuff with them, or partner with them, or that your solutions will actually stick around for a while, it'd go up pretty drastically. And so my key example of this was with when Facebook started exploring mobile ads, Hotel Tonight, we were one of the alpha testers of mobile ads, because I'd been sitting here buying ad inventory on networks for the last five or six years and just waiting for Facebook to work, because it just wasn't really working for mobile installs.

**中文翻译:**
因为这样一来，你给他们打电话进行定制化合作、建立伙伴关系，或者让你的方案长期存在的可能性就会大幅增加。我最核心的例子是当 Facebook 开始探索移动广告时，我们在 Hotel Tonight 成了移动广告的首批内测用户之一。因为在那之前的五六年里，我一直在各种网络上购买广告位，一直在等 Facebook 发力，因为当时它在移动端安装方面的效果并不理想。

---

### (00:22:13) Adam Grenier

**English:**
And it's like, I know this is a huge channel because I can use it on my online marketing, my web marketing, but as a mobile acquisition it's nowhere near as efficient as a lot of these other networks. And so as soon as they were doing that, I was able to basically position and say, "Look it, you want to work with us. Let me into your alpha, because I have five years of experience already buying mobile ads. I know the space. I know it'll work. And if you get us to work, we're a killer case study, because we are a non-game and a lot of money is spent on gaming, but there's these whole other major categories that you're going to need other than gaming examples within that group. So, you're going to be able to use me as a case study and a lot of different scenarios than the gaming players."

**中文翻译:**
当时的情况是，我知道这是一个巨大的渠道，因为我可以用它做网页端营销，但作为移动端获客渠道，它的效率远不如其他网络。所以一旦他们开始尝试，我就能定位自己并说：“看，你们想和我们合作。让我加入内测吧，因为我已经有五年的移动广告购买经验了。我了解这个领域，我知道它会奏效。如果我们成功了，我们就是一个极佳的案例研究，因为我们不是游戏公司。虽然游戏行业投入了很多钱，但除了游戏之外，你们还需要其他主要类别的案例。所以，相比游戏玩家，你们可以在更多不同的场景中把我当作案例研究。”

---

### (00:22:59) Adam Grenier

**English:**
And so I was spending a lot less than the gaming players, but because of that understanding that your goal at Facebook is to make ads work for all of travel and for all of leisure and those kinds of things, that's the value of working with me. So, that's another piece of the channel DNA I like people to focus on.

**中文翻译:**
虽然我的花费比游戏玩家少得多，但基于这种理解——即 Facebook 的目标是让广告在旅游、休闲等所有领域都奏效——这就是与我合作的价值。所以，这是我希望人们关注的渠道基因的另一个方面。

---

### (00:23:18) Lenny

**English:**
Awesome. That's such a good one, because to your point, if your goals are aligned, they're going to be like, "Yes, let's make this happen." And it always feels like it's this behemoth that doesn't want to talk to any new startups, but if you can make the case of this is going to help you and the way you laid out is so clear, it's such a good idea.

**中文翻译:**
太棒了。这主意真好，因为正如你所说，如果目标一致，他们会说：“好，让我们促成这件事。”人们总觉得这些巨头不想理会初创公司，但如果你能证明这能帮到他们，而且陈述得如此清晰，那真的是个好主意。

---

### (00:23:35) Adam Grenier

**English:**
And especially with emerging channels, right? Because their whole thing is that make this work for a long time. It's part of the challenge you see with some new channels flipping to the other side of growing an ads business, will gravitate towards like, "I want to get Disney on here," but Disney is very campaign driven, or they have been traditionally, where it's like you may get one big paycheck from them, but that doesn't... The way that UA driven gaming works is you get that to work, that's a gift that keeps on giving forever, right? Because there's not one of those companies, there's thousands of them and they all do the same thing. So, being able to drive that conversation is really helpful.

**中文翻译:**
尤其是对于新兴渠道，对吧？因为他们的核心目标是让这个业务长期运转。你会看到一些新渠道在发展广告业务时面临的挑战：他们倾向于“我想把迪士尼拉进来”，但迪士尼是非常受活动（Campaign）驱动的，或者传统上是这样，你可能从他们那里拿到一张大支票，但那不可持续。而以用户获取（UA）驱动的游戏行业，一旦你跑通了，那就是一份源源不断的礼物，对吧？因为这类公司不只一家，而是有成千上万家，他们都在做同样的事情。所以，能够引导这种对话非常有帮助。

---

### (00:24:18) Lenny

**English:**
Cool.

**中文翻译:**
酷。

---

### (00:24:18) Adam Grenier

**English:**
And then the third main ingredient is just your own company DNA. And so I think risk profile is a big one. Do you actually have comfort in being a first mover, a true first mover? Nobody knows anything, tracking's not going work, it's not going be programmatic. You're probably going show up on content that's offensive. You're probably going ask for refunds that won't happen. It's going be really painful to be a true first mover. Do you have that appetite? Do you have the staff to actually be able to put someone on that and it not distract from everything else?

**中文翻译:**
第三个主要要素是你自己公司的基因。我认为风险偏好是一个重点。你是否真的愿意成为先行者，真正的先行者？没人知道任何信息，追踪可能失效，不会是程序化的。你可能会出现在令人反感的内容旁边。你可能会要求退款但拿不到。成为真正的先行者会非常痛苦。你有这个胃口吗？你有足够的人手专门负责这件事而不分散其他工作的精力吗？

---

### (00:24:53) Adam Grenier

**English:**
And then the other piece on the company side is just your current channel mix. There's very few companies that I recommend saying, "Yes, go put energy on this brand new channel that you don't know how to scale yet before you've figured out some type of volume on Google and Facebook." Every now and then there may be a perfect fit where it's like, absolutely, you should be the person doing this. But if you're not at least getting something out of the basic channels that everybody else is using, it's probably not the thing you should be putting your first energy into. It should be like, "Great, I've got a good foundation." Like you said, now we're at that stage of trying to add things, tends to be a better stage to do more risky exploration into new channels.

**中文翻译:**
公司方面的另一部分是你当前的渠道组合。我很少建议公司在还没搞定 Google 和 Facebook 的基本流量之前，就去把精力花在一个还不知道如何扩展的新渠道上。偶尔会有完美契合的情况，让你觉得“绝对应该去做”。但如果你还没从大家都在用的基础渠道中获得收益，那可能不该是你首要投入精力的地方。应该像你说的，“太好了，我有了一个好的基础”，现在处于尝试增加新东西的阶段，这往往是进行高风险新渠道探索的更好时机。

---

### (00:25:40) Lenny

**English:**
What advice do you have or can you give to founders teams that are trying to test one of these in terms of just how to run these tests? How much time should they spend, would you say? What do they look for? I know that this is a hard question and super dependent on the situation, but any advice there?

**中文翻译:**
对于那些想要测试这些新渠道的创始人和团队，你在如何运行这些测试方面有什么建议？你认为他们应该花多少时间？他们应该寻找什么信号？我知道这是一个很难回答的问题，而且非常取决于具体情况，但有什么建议吗？

---

### (00:25:55) Adam Grenier

**English:**
So, I think going through those three ingredients should help shape that answer, right? Because if you're like, "Okay, well, the first one is super strong, the channel DNA is maybe really early and I've got a small to mid-size team and maybe only one channel working," then it may be like, "Great. Put half of one person into this, because it's maybe interesting. But don't put any more than that into it." Versus if it's like, "Man, this is a killer fit the channel's a little further along and I have a 20 person team, so I'm going to put three dedicated people to this, because we are in prime position to be the leaders in this new channel and really push it."

**中文翻译:**
我认为梳理那三个要素有助于得出答案。如果你觉得：“好吧，第一个要素非常强，渠道基因可能还很早期，而我有一个中小型团队，可能只有一个渠道在运作”，那么结论可能是：“太好了，投入半个人的精力去做这件事，因为它可能很有趣，但不要投入更多了。”相比之下，如果是：“天哪，这简直是绝配，渠道已经稍微成熟了一些，而且我有一个 20 人的团队，那么我会投入 3 个专职人员，因为我们处于成为这个新渠道领导者的绝佳位置，要全力推进。”

---

### (00:26:36) Adam Grenier

**English:**
So, I think it's figuring those pieces out, because it is a very it depends answer, but rarely ever is it like, "Hey, this should be your entire team's focus for the next three sprints or five sprints." I think that if you've got that half person working on it for a while and there starts to be some magic happening, sure, put a sprint or two against it as a whole team. But generally speaking, I think keeping it minimum at first is my typical recommendation.

**中文翻译:**
所以关键是理清这些环节。虽然答案通常是“视情况而定”，但很少会出现“嘿，这应该是你整个团队未来三到五个冲刺（Sprint）的焦点”这种情况。我认为，如果你让那半个人研究了一段时间，并且开始出现一些奇妙的效果，那么当然可以让整个团队投入一两个冲刺。但总的来说，我通常的建议是最初保持最小化投入。

---

### (00:27:06) Lenny

**English:**
I had another guest, Yuri, who I think from former Grammarly, and he made a really good point that it's often better not to try something than to do it badly and then take away the wrong lessons. I guess, in your experience, what's a timeframe you think people should put into this stuff? You said two sprints, maybe a couple weeks. I don't know, what's the range of just maybe don't spend more than X months on something new if it's not clearly working, just based on your experience.

**中文翻译:**
我还有另一位嘉宾 Yuri，他以前在 Grammarly 工作，他提出了一个很好的观点：与其把一件事做得很烂并得出错误的教训，往往不如根本不去尝试。根据你的经验，你认为人们应该投入多长的时间框架？你提到了两个冲刺，大概几周。根据你的经验，如果一件新事物没有明显效果，不应该超过几个月？

---

### (00:27:33) Adam Grenier

**English:**
Generally I wouldn't let anything bleed past a quarter. You can probably get some good signal in a month or less, what I would call fishing. It wouldn't be like you're just putting bait in the water to figure out where the fish are, not necessarily getting statistically significant repeatable solutions. The big variables that can change that timing, so if I'm exploring a new video channel, the content I need to create is if I'm going to have to create something that takes three weeks to produce and $20,000 to make, I may want to give it a little more time, because I gave it more of an upfront investment.

**中文翻译:**
通常我不会让任何测试超过一个季度。你可能在一个月或更短的时间内就能得到一些好的信号，我称之为“钓鱼”。这就像是把饵撒进水里看看鱼在哪，不一定能得到统计学上显著的可重复方案。改变这个时长的主要变量是，如果我正在探索一个新的视频渠道，而我需要创作的内容需要三周时间制作并花费 2 万美元，我可能会想多给它一点时间，因为我投入了更多的前期成本。

---

### (00:28:16) Adam Grenier

**English:**
Versus if it's like I want to put text ads in podcasts listings or something like that. It's like, great, I can do that by myself at midnight and it's not distracting anybody or anything. And if it doesn't work in three weeks, let's move on. But generally ideally what you're working through, and we'll touch a little bit more on this with the Growth CMO, is that this should all be part of a roadmap. It shouldn't just be randomly chosen and thrown at. This should be part of your sprint process and you should have a backlog of other things that you want to try. And so you're actually weighing that decision of how long based on what other opportunities you're missing out on by investing in that.

**中文翻译:**
相比之下，如果只是想在播客列表中投放文字广告之类的，那太棒了，我可以在半夜一个人搞定，不会干扰任何人。如果三周没效果，那就换下一个。但理想情况下，你正在处理的事情（我们稍后在讨论增长型 CMO 时会进一步涉及）应该是路线图的一部分。它不应该是随机选择并扔进去的。这应该是你冲刺过程的一部分，你应该有一个想要尝试的其他事情的待办列表（Backlog）。所以你实际上是在根据投资该项目而错过的其他机会来权衡决策时长。

---

### (00:28:57) Adam Grenier

**English:**
But I would say most channels, especially new ones, are going to take more than a couple cycles to kind of suss out. Because there's no rules, there's no playbooks yet on how to do them well. So, give it a little bit of time, but if you're going over a quarter and you don't feel like directionally it's getting better or it's interesting, I would put it back on ice for a while.

**中文翻译:**
但我会说，大多数渠道，尤其是新渠道，需要超过几个周期才能摸清门道。因为还没有规则，也没有关于如何做好的现成剧本。所以，给它一点时间，但如果超过一个季度，你觉得方向上没有变好或者没意思，我会把它先搁置一段时间。

---

### (00:29:18) Lenny

**English:**
Cool. And to your point, you're not going to see any statistically significant answers. Is the thing you look for just like you know it when you see it? Oh wow, qualitatively feels like it's working kind of thing? Is that what you kind of look for?

**中文翻译:**
酷。正如你所说，你不会看到任何统计学上显著的答案。你寻找的是那种“一看到就知道”的感觉吗？比如“噢哇，从定性上看感觉它奏效了”这种？这就是你寻找的东西吗？

---

### (00:29:30) Adam Grenier

**English:**
Yeah, and I think define that going into it. What am I looking for, for this? So, something like Clubhouse I'm probably not going to see clicks. It's more about are we able to start a room and increase the size of that room by 10% every time that we run it? Okay great, that means that we're at least getting better at this and there's more reach available to us. But if we're getting 20 people every time we start a room and then it goes down to 15, then we're either not doing this well, the channel's not doing well, or there's just not enough reach for us to actually expand. Versus TikTok you might be able to say, "Great, I can actually track clicks and conversion, so let's look at it the way we would any other channel."

**中文翻译:**
是的，我认为在开始之前就要定义好。我在这件事上寻找什么？比如像 Clubhouse，我可能看不到点击量。更多的是关于我们能否开设一个房间，并且每次运行都能让房间规模增加 10%？如果是，那太好了，这意味着我们至少在进步，而且我们有更多的覆盖面。但如果我们每次开房间只有 20 个人，然后降到 15 个，那么要么是我们做得不好，要么是渠道不行，或者就是没有足够的覆盖面供我们扩展。相比之下，在 TikTok 上你可能会说：“太好了，我实际上可以追踪点击和转化，所以让我们像对待其他渠道一样对待它。”

---

### (00:30:11) Lenny

**English:**
Got it. So, kind of look for momentum and that you're getting better and that it's moving somewhere. Awesome.

**中文翻译:**
明白了。所以就是寻找势头，看你是否在进步，看它是否在向某个方向发展。太棒了。

---

### (00:30:16) Adam Grenier

**English:**
Yeah. Yep.

**中文翻译:**
是的，没错。

---

### (00:30:17) Lenny

**English:**
Cool. So, a question that I'm sure is on many people's minds that they would want to ask is, Adam, what are emerging platforms that are interesting right now that we should experiment with? What do you feel?

**中文翻译:**
酷。我确信很多人脑子里都有一个想问的问题：Adam，现在有哪些有趣的新兴平台值得我们去尝试？你感觉如何？

---

### (00:30:28) Adam Grenier

**English:**
So, I mean I mentioned OTT, or basically the key thing with OTT is that it's way more trackable than traditional television, but it has similar value that traditional TV does in terms of the ability to do more long form storytelling type content, and a lot of it's not skippable if you buy it. And so those are reasons to be exploring that right now. It's hard for me to call that emerging channel, because it's been around forever. It's there's more of it and the tools and services around it are way better now than they were four years ago. And so I think the sophistication and ability to scale OTT is much higher now than ever before. Influencers probably the one that I'm most intrigued by, because similar to OTT, the scale and services and the ability to go do it is still there.

**中文翻译:**
我提到了 OTT。OTT 的关键在于它比传统电视更具可追踪性，但在长篇故事类内容方面具有与传统电视类似的价值，而且如果你购买了广告位，很多广告是不可跳过的。这些都是现在探索它的理由。我很难称其为新兴渠道，因为它已经存在很久了。只是现在的量更大了，而且围绕它的工具和服务比四年前好得多。所以我认为现在扩展 OTT 的成熟度和能力比以往任何时候都高。网红营销可能是我最感兴趣的，因为和 OTT 类似，其规模、服务和执行能力依然存在。

---

### (00:31:19) Adam Grenier

**English:**
It's also got that hyper granularity that when I get into influencer tools, it feels to me like early Facebook when I used to go be able to target Lenny, or 10 people that have exactly the same likes as Lenny. And that type of stuff where it's like you can get so specific and find exactly who you need. It's incredibly tedious and manual and it's a lot of relationship management. So, I'm also keeping an eye on the technology being built around influencer, because I think that's a huge area of opportunity for entrepreneurs right now.

**中文翻译:**
它还具有超强的细分颗粒度。当我使用网红工具时，感觉就像早期的 Facebook，我可以精准定位到 Lenny，或者 10 个和 Lenny 爱好完全相同的人。你可以变得非常具体，找到你确切需要的人。这非常繁琐且需要人工操作，涉及大量的关系管理。所以我也在关注围绕网红营销开发的各种技术，因为我认为这对现在的创业者来说是一个巨大的机会领域。

---

### (00:31:57) Adam Grenier

**English:**
But generally speaking, the scope and opportunity there is huge and it's not going away, but it feels very new and different right now. And it supplements the ability to do some hyper level targeting that you've not been able to do, that Facebook and Google are getting less open about at the same time. I think VR is really interesting in the way that mobile was interesting before iPhone Three, where it was if you've got a VR app, it's a really interesting space, but if you don't, it's not that interesting to me yet. Any that have come up for you that you're like... what are your thoughts on this?

**中文翻译:**
但总的来说，那里的范围和机会是巨大的，而且不会消失，只是现在感觉非常新颖和不同。它补充了进行超高水平定向的能力，而这种能力正是 Facebook 和 Google 逐渐变得不再开放的。我认为 VR 非常有趣，就像 iPhone 3 之前的移动端一样有趣：如果你有一个 VR 应用，那是一个非常有趣的空间；但如果你没有，它对我来说还没那么有趣。你有什么想到的吗？你对这有什么看法？

---

### (00:32:35) Lenny

**English:**
No, these are great. All I think of is TikTok.

**中文翻译:**
不，这些都很棒。我能想到的只有 TikTok。

---

### (00:32:38) Adam Grenier

**English:**
I feel like TikTok's crossed a chasm, whereas they actually have a formalized ad platform now, people are finding scale. There's still a ton to do there and influencers is also weird, because it crosses all of these other worlds as well. But I think TikTok is actually hyper interesting and everyone should be doing that. But I think of that less as you should be doing it as should I do it, should I not? And it's more I need to figure out how to do Facebook if I'm at least mildly appropriately should be there.

**中文翻译:**
我觉得 TikTok 已经跨越了鸿沟，因为他们现在有了正式的广告平台，人们正在那里找到规模。那里还有很多事情可以做，网红营销也很奇特，因为它跨越了所有这些不同的领域。但我认为 TikTok 实际上非常有趣，每个人都应该尝试。但我认为这不应该是“我该不该做”的问题，而更像是“如果我应该出现在那里，我需要像研究 Facebook 一样研究它”。

---

### (00:33:05) Adam Grenier

**English:**
The podcast ads I think are great. I think that I bought podcast ads 15 years ago, so it doesn't feel like an emerging channel to me. I think there's way more volume now than there's ever been before. One of the guys that was on my team at Uber has a company that's doing programmatic buying and that type of stuff. And so I think there's more opportunities on podcast. I think people want to treat it like Facebook ads or direct response ads, immediate response ads. And actually what I keep seeing as the effective strategy with podcast ads is treating them more like radio where it's more about getting on the right program, making it personal and feel like it should be part of that program, and then repeating over and over and over again.

**中文翻译:**
我认为播客广告很棒。我在 15 年前就买过播客广告，所以对我来说它不像是新兴渠道。我认为现在的量比以往任何时候都大。我以前在 Uber 团队的一个成员开了一家做程序化购买之类的公司。所以我认为播客上有更多机会。我觉得人们想把它当作 Facebook 广告或直接响应广告（即时响应广告）来对待。但实际上，我一直看到的播客广告有效策略是把它更像广播一样对待：关键是进入正确的节目，使其个性化，感觉像是节目的一部分，然后一遍又一遍地重复。

---

### (00:33:53) Adam Grenier

**English:**
So, I think podcast is super interesting. I think it's just hard to scale. It's likely not going to get people the same volumes as the Googles and Facebooks of the world.

**中文翻译:**
所以我认为播客非常有趣。只是很难扩展规模。它可能无法像 Google 和 Facebook 那样带来巨大的流量。

---

### (00:34:01) Lenny

**English:**
Cue our mid-roll ad. I'm excited to chat with my friend John Cutler from Podcast sponsor, Amplitude. Hey John.

**中文翻译:**
插播一段广告。很高兴能与来自播客赞助商 Amplitude 的朋友 John Cutler 聊天。嘿，John。

---

### (00:34:08) John Cutler

**English:**
Hey, Lenny. Excited to be here.

**中文翻译:**
嘿，Lenny。很高兴来到这里。

---

### (00:34:10) Lenny

**English:**
John, give us a behind the scenes at Amplitude. When most people think of Amplitude, they think of product analytics, but now you're getting into experimentation and even just launched a CDP. What's the thought process there?

**中文翻译:**
John，给我们介绍一下 Amplitude 的幕后情况吧。大多数人想到 Amplitude 时，都会想到产品分析，但现在你们开始涉足实验领域，甚至刚刚推出了 CDP（客户数据平台）。这背后的思考过程是怎样的？

---

### (00:34:21) John Cutler

**English:**
Well, we've always thought of Amplitude as being about supporting the full product loop. Think collect data, inform bets, ship experiments and learn. That's the heart of growth to us. So, the big aha was seen how many customers were using Amplitude to analyze experiments, use segments for outreach and send data to other destinations. Experiment and CDP came out of listening to and observing our customers.

**中文翻译:**
嗯，我们一直认为 Amplitude 是为了支持完整的产品闭环。想想看：收集数据、为决策提供依据、发布实验并学习。对我们来说，这就是增长的核心。所以，我们发现有很多客户在使用 Amplitude 分析实验、使用细分进行外联，并将数据发送到其他目的地。实验功能和 CDP 的诞生源于对客户的倾听和观察。

---

### (00:34:42) Lenny

**English:**
And supporting growth and learning has always been Amplitude's core focus, right?

**中文翻译:**
支持增长和学习一直是 Amplitude 的核心焦点，对吧？

---

### (00:34:46) John Cutler

**English:**
Yeah. So, Amplitude tries to meet customers where they are. We just launched starter templates and have a great scholarship program for startups. There's never been a more important time for growth.

**中文翻译:**
是的。所以 Amplitude 努力满足客户的需求。我们刚刚推出了入门模板，并为初创公司提供了一项很棒的奖学金计划。对于增长来说，现在是前所未有的重要时刻。

---

### (00:34:55) Lenny

**English:**
Absolutely agree. Thanks for joining us, John, and head to amplitude.com to get started.

**中文翻译:**
完全同意。谢谢你的加入，John。请前往 amplitude.com 开始体验。

---

### (00:35:01) Adam Grenier

**English:**
I also come from a very consumer perspective. I'm actually stronger on B2B companies using podcasting, because it has that exact same value I just described, but each one of their customers is substantially more valuable. So, they don't need the scale that a consumer application or product would need.

**中文翻译:**
我也从 C 端消费者的角度来看。实际上，我更看好 B2B 公司使用播客，因为它具有我刚才描述的完全相同的价值，而且他们的每个客户价值都高得多。所以，他们不需要像 C 端应用或产品那样的规模。

---

### (00:35:20) Lenny

**English:**
Yep. That's exactly who I work with usually. One last question on this topic. What percentage of the time do you find that an emerging channel works? Is it like 20% of the time, 10%, 5%? What should people estimate, it's probably not going to work but when it does it's going to be game changing?

**中文翻译:**
是的，那正是我通常合作的对象。关于这个话题最后一个问题。你发现新兴渠道奏效的概率是多少？是 20%、10% 还是 5%？人们应该如何预估？是不是大概率不会奏效，但一旦奏效就会改变游戏规则？

---

### (00:35:34) Adam Grenier

**English:**
Like 5% of the time. There's new things popping up all the time. I think the area that I think of as emerging that I've found more success in is taking things that exist already and make them... so the two slices of it are either it's existed for a long... like podcasting. So, it existed for a long time and now we're finally getting to a spot where it feels scalable. The other is existing channels that introduce something brand new.

**中文翻译:**
大概 5% 的时间。总有新东西冒出来。我认为我发现的更成功的新兴领域是，把已经存在的东西变得……它有两个切面：要么是它已经存在很久了，比如播客，它存在了很久，现在我们终于到了一个感觉可以扩展的阶段；另一种是现有渠道引入了全新的东西。

---

### (00:36:04) Adam Grenier

**English:**
So, at the mobile ads I described on Facebook, pre mobile install ads and post. Those first 18 months of mobile install felt like an emerging channel, right? Because they were changing the product every week and tracking didn't work, and there were all these funky problems with it even though Facebook had been around forever. But brand spanking new channels, I don't know, they rarely work or are worth the effort early that you hope that they will be.

**中文翻译:**
比如我描述的 Facebook 移动广告，在移动安装广告出现之前和之后。移动安装广告最初的 18 个月感觉就像一个新兴渠道，对吧？因为他们每周都在更改产品，追踪功能失效，尽管 Facebook 已经存在很久了，但当时有很多古怪的问题。至于全新的渠道，我不知道，它们很少能在早期就产生你所期望的效果或值得你投入的精力。

---

### (00:36:35) Lenny

**English:**
Cool. But when they work, it's game changing I imagine. Reminds me Apples coming out with Apple TV, I think it was, and they're just like, "Hey Airbnb, you should make it app for Apple TV. It'll be huge." And there's a team put on it. I don't know. They spent a month building this app and did a bunch of nothing as far as I understand, but it felt good. It felt good to be part of the launch. One question I wanted to come back to, are there tools that you recommend for influencer marketing that you want to plug, or point out?

**中文翻译:**
酷。但我可以想象，一旦它们奏效，那就是颠覆性的。这让我想起苹果推出 Apple TV 时（我记得是那时候），他们说：“嘿 Airbnb，你们应该为 Apple TV 做个应用，它会火的。”于是我们派了一个团队去做。据我所知，他们花了一个月时间开发这个应用，结果什么也没发生，但感觉很好，能参与发布感觉很棒。我想回到一个问题，关于网红营销，你有什么推荐的工具想宣传或指出的吗？

---

### (00:37:01) Adam Grenier

**English:**
We were using Grin at Masterclass, we onboarded them. So, there's probably half a dozen companies in that same zone where they're building tools that allow you to do the discovery of influencers, the CRM of those influencers, and also often the measurement and payments and all that kind of stuff. So, it's an all in one type of management platform. That being said though, like I said, it's still super manual. It's nice to be able to go and find this list of 50 influencers that are the exact right influencer for this class launch, or whatever it might be.

**中文翻译:**
我们在 Masterclass 使用的是 Grin，我们引入了他们。在那个领域大概有六家公司在做类似的工具，让你能够发现网红、对网红进行 CRM（客户关系管理），通常还包括衡量、支付等所有事情。所以它是一个全能型的管理平台。话虽如此，正如我所说，它仍然非常依赖人工。能找到 50 个完全适合这次课程发布或类似活动的网红名单是很棒的。

---

### (00:37:34) Adam Grenier

**English:**
But it's still then I have to wait till they all respond to me and there's still a lot of manual back and forth. So, that's probably one of them. I'm trying to think of... There's a few other in that same category that are competitive with Grin that they all seem equally pretty good. I can't even remember the reason we chose Grin over some of the other ones.

**中文翻译:**
但之后我还是得等他们全部回复我，仍然有很多手动沟通的过程。所以 Grin 可能是其中之一。我在想……同类产品中还有几个和 Grin 竞争的，看起来都差不多好。我甚至不记得我们为什么选择 Grin 而不是其他的了。

---

### (00:37:53) Lenny

**English:**
It's a good name.

**中文翻译:**
名字取得好。

---

### (00:37:53) Adam Grenier

**English:**
It was all pretty close.

**中文翻译:**
其实都差不多。

---

### (00:37:55) Lenny

**English:**
Sweet. Okay. If any other comes to mind, we'll throw it in the show notes. Before we get to the growth CMO discussion, there's kind of this tangential area that I wanted to spend a little time on, which is this idea of as a startup you initially should and often do start with a very narrow audience, your early adopters. I read this post about calling them your super specific who, and eventually you want to cross the chasm and go broader. And you have some interesting insights on how to think about that, and when to do that. Can you talk about that?

**中文翻译:**
太好了。如果有其他的想起来，我们会放在节目笔记里。在讨论增长型 CMO 之前，我想花点时间聊一个相关的领域，即初创公司最初应该（也通常确实）从非常窄的受众开始，也就是你的早期采用者。我读过一篇文章，称他们为你的“超级特定受众”（super specific who），最终你想跨越鸿沟并走向更广泛的市场。关于如何思考以及何时去做这件事，你有一些有趣的见解。你能聊聊吗？

---

### (00:38:26) Adam Grenier

**English:**
Yeah. So, I think the book, Crossing the Chasm, is a great place to start in terms of thinking about the broader topic of that. What I see missed a lot of the time that I like to spend time with people on is to really understand that those early adopters are often just drastically different than the broad audience. And spending time to actually figure that out and map out what you need to see with those early adopters to have confidence that the product is actually going to have product market fit beyond them.

**中文翻译:**
是的。我认为《跨越鸿沟》（Crossing the Chasm）这本书是思考这个宏大话题的一个很好的起点。我经常看到人们忽略的一点（也是我喜欢花时间与人探讨的）是：要真正理解早期采用者通常与大众受众有着巨大的差异。你需要花时间去弄清楚这一点，并规划出你需要从早期采用者身上看到什么，才能有信心相信该产品在他们之外的市场也能拥有 PMF。

---

### (00:39:07) Adam Grenier

**English:**
So, I don't have anything hyper specific to add to that necessarily, or happy to dig in deeper to it, but it's probably the biggest challenge that I've seen with a lot of companies that I've worked with. And then as I do more investing and things like that, it's probably the biggest flag that I see with a lot of companies that claim to have product market fit, which is your TAM and your product market fit are not using the same definition. And that problem I think is often just a red flag for a lot of companies that I meet.

**中文翻译:**
关于这一点，我没有特别具体的补充，但我很乐意深入探讨。这可能是我在合作过的许多公司中看到的最大挑战。随着我做更多的投资，我发现许多声称拥有 PMF 的公司存在一个最大的隐患：即你的 TAM（总可寻址市场）和你的 PMF 使用的不是同一个定义。我认为这个问题对于我遇到的很多公司来说都是一个危险信号。

---

### (00:39:40) Lenny

**English:**
Got it. So, essentially you often underestimate how challenging it'll be to grow from your initial early adopter crowd. Is there an example of that happening where a company just got screwed because they didn't think about that enough? Or is there something someone can do early on? Is it test a little bit more broadly early? What do you recommend there?

**中文翻译:**
明白了。所以，本质上人们经常低估了从最初的早期采用者群体向外扩展的难度。有没有这样的例子，某家公司因为没考虑周全而陷入困境？或者在早期可以做些什么？是应该在早期就进行更广泛的测试吗？你有什么建议？

---

### (00:39:59) Adam Grenier

**English:**
I mean Clubhouse might be a good example in the sense that they leaned into the broader audience maybe quicker than they should have. Their product market fit seemed to fit the moment in time and could they have built some experiments, or tools, or features that maybe stress tested will this work in an ongoing fashion? If they were on such tear, that's a pretty hard decision to make, I'm sure.

**中文翻译:**
我的意思是，Clubhouse 可能是一个很好的例子，从某种意义上说，他们转向大众受众的速度可能比应有的速度快了。他们的 PMF 似乎契合了那个特定的时间点，但他们是否本可以建立一些实验、工具或功能来压力测试这是否能持续运作？如果他们当时正处于爆发期，我确信那是一个很难做出的决定。

---

### (00:40:29) Lenny

**English:**
So hard, it's easy in hindsight.

**中文翻译:**
太难了，事后诸葛亮总是容易的。

---

### (00:40:33) Adam Grenier

**English:**
I think that's another piece of it is that the audience changes aren't always just literal people. Even right now, one of the biggest pieces of advice I'm giving to people that are like, "How should we adjust our marketing with the economic changes and things like that?" I was like, "Start by assuming you no longer have product market fit, because you had product market fit in a different market. It's a different market now, so you have to start over."

**中文翻译:**
我认为另一部分原因是，受众的变化并不总是字面意义上的人群变化。即使是现在，我给那些询问“面对经济变化我们该如何调整营销”的人最大的建议之一就是：“首先假设你已经不再拥有 PMF 了，因为你之前的 PMF 是在另一个不同的市场环境中实现的。现在的市场已经变了，所以你必须重新开始。”

---

### (00:40:57) Adam Grenier

**English:**
And hopefully you do, or it's pretty close to it and you just have to adjust a couple things and you can be right back on track. But if you just assume you need to launch a new channel to fix this problem, you're going to be wrong, because your entire customer base changed, not just the next 10% of customers that you're looking for.

**中文翻译:**
运气好的话，你可能依然拥有 PMF，或者非常接近，只需要调整几件事就能重回正轨。但如果你只是想当然地认为通过开辟一个新渠道就能解决问题，那你就错了，因为改变的是你的整个客户群，而不仅仅是你正在寻找的下 10% 的新客户。

---

### (00:41:14) Lenny

**English:**
It's just a reminder of how freaking hard startups are. Man, we have product market fit. Okay, we're done. Let's move on.

**中文翻译:**
这再次提醒了我们创业到底有多难。天哪，我们有了 PMF。好，搞定了，继续下一步。

---

### (00:41:21) Adam Grenier

**English:**
Not anymore.

**中文翻译:**
现在没了。

---

### (00:41:21) Lenny

**English:**
Not anymore. Oh man. Okay, sweet. So, onto this next topic around the Growth CMO. So, you're this really interesting combination of marketing brain and also very analytical growth person, and I think you refer to this as Growth CMO, which I don't actually hear the term much. So, I'm curious, what is a Growth CMO? How do you define it? And why is it important?

**中文翻译:**
现在没了。噢天哪。好，太棒了。那么，进入下一个关于增长型 CMO 的话题。你是一个非常有趣的组合：既有营销头脑，又是非常注重分析的增长专家。我想你把这称为“增长型 CMO”，我其实没怎么听过这个词。所以我很好奇，什么是增长型 CMO？你如何定义它？为什么它很重要？

---

### (00:41:43) Adam Grenier

**English:**
Yeah, so it's something I've just spent a lot of the last few years thinking about, specifically because now I've been at a handful of companies where we've brought in CMOs that in all ways are absolute world class CMOs, and they don't last, they don't fit and they don't succeed. And so I've spent a lot of time and figuring, well, why not? Some of it coming because of spending time with those people being like, "Why are you doing it this way? That's not how a company at our stage operates."

**中文翻译:**
是的，这是我过去几年一直在思考的问题。特别是因为我待过几家公司，我们引入了各方面都绝对是世界级的 CMO，但他们待不长，不适应，也没能成功。所以我花了很多时间思考，为什么不行？部分原因是我和这些人相处时会想：“你为什么要这样做？我们这个阶段的公司不是这样运作的。”

---

### (00:42:18) Adam Grenier

**English:**
Trying to do it the way that a traditional CMO would've done marketing for a company, et cetera. One of the key examples I like to use is brand, in that everybody when they think about brand they think of it as an action, not as a consistent ongoing investment, or they think about it as campaigns and things like that. And from planning to execution to learnings, a traditional CMO will drive learnings and identify learnings. In my mind, I think a Growth CMO is looking at each brand investment as how do you then immediately follow that up with the next one? How do you shift to this fast product iteration mindset with even things like brand?

**中文翻译:**
他们试图用传统 CMO 为公司做营销的方式来做事。我喜欢用的一个关键例子是“品牌”。每个人想到品牌时，都把它看作一个动作，而不是一种持续不断的投资；或者他们把它看作是一次次的活动（Campaigns）。从规划到执行再到总结，传统 CMO 会推动并识别经验教训。而在我看来，增长型 CMO 会审视每一次品牌投资，思考如何立即跟进下一次投资？如何将这种快速产品迭代的思维应用到品牌建设上？

---

### (00:42:58) Adam Grenier

**English:**
It's very possible, but it's so counter to a lot of traditional marketing DNA. That, to me, means that we have a lot of mismatch marketing leadership, and that quickly eliminates trust with the marketing organization. It means that we rename everything marketing to product led growth, or growth, or referral programs. To me, it actually dilutes the value of marketing should be playing in the company. And it doesn't mean that the traditional marketing CMO isn't a good fit for some companies.

**中文翻译:**
这是完全可能的，但它与许多传统营销基因背道而驰。对我来说，这意味着我们有很多错位的营销领导层，这会迅速消除营销组织的信任。这意味着我们将所有营销活动重新命名为产品驱动增长（PLG）、增长或推荐计划。在我看来，这实际上稀释了营销在公司中应发挥的价值。这并不意味着传统营销 CMO 不适合某些公司。

---

### (00:43:37) Adam Grenier

**English:**
I think the direct to consumer products are still very well suited to have a more traditional CMO. But I think product driven companies, product led companies, if you are CMO and your product leader aren't married at the hip, you're just missing out on just tons of opportunity, and the likelihood of things actually working very well consistently and compounding on each other.

**中文翻译:**
我认为 D2C（直接面向消费者）产品仍然非常适合由更传统的 CMO 领导。但我认为对于产品驱动型公司、产品主导型公司，如果你的 CMO 和产品负责人没有紧密结合，你就会错失大量的机会，也无法让事情持续高效运作并产生复利效应。

---

### (00:44:05) Lenny

**English:**
So, what are the attributes of this person of what you call a Growth CMO? Sounds like partly it's being much more performance driven. Sounds like a big part of it is understanding product and not creating these silos. We're going to market the thing, you guys go build this thing. But also as a person, that's a great CMO. What else do you look for?

**中文翻译:**
那么，你所说的增长型 CMO 具备哪些特质？听起来部分原因是更加注重绩效（Performance-driven）。听起来很大一部分是理解产品，而不是制造孤岛——即“我们负责营销，你们负责构建”。但作为一个优秀的 CMO，你还会寻找什么特质？

---

### (00:44:22) Adam Grenier

**English:**
So, I would say so data driven generally. To me performance is a very loaded word in our world, because people think, especially in marketing, think that means not brand. But they're very data driven. And so when we take things like retention and even brand and the consideration funnel and, yes, you can't measure those exactly like you can measure landing page clicks and sales, but you absolutely can measure them. And making that part of the DNA of everything that's happening, data being part of that, I think is pretty quintessential of being a growth driven CMO.

**中文翻译:**
我会说通常是数据驱动。对我来说，“绩效”在我们的世界里是一个含义丰富的词，因为人们（尤其是营销人员）认为它意味着“非品牌”。但他们是非常数据驱动的。当我们考虑留存、甚至品牌和考虑漏斗（Consideration Funnel）时，是的，你不能像衡量落地页点击和销售额那样精确地衡量它们，但你绝对可以衡量它们。将数据作为正在发生的一切的基因，我认为这是增长驱动型 CMO 的核心特质。

---

### (00:45:00) Adam Grenier

**English:**
The second, I think, is the iteration process is not thinking about things and, "Hey, we need to plan for the next 24 months," but you can still do that and you can still have a vision and everything. But having that more of a agile type approach to everything. And again, this could be the storytelling that your sales people are doing, to what are your landing pages look like, to what is the design of your logo, to the brand itself. All of those things, like being more open to everything being possibly iterated on, on a regular basis using data to validate that and challenge what has worked for you.

**中文翻译:**
第二点，我认为是迭代过程，而不是想着“嘿，我们需要规划未来 24 个月”。你仍然可以做规划，仍然可以有愿景，但要对一切采取更敏捷（Agile）的方式。这可以是你销售人员讲的故事，可以是落地页的样子，可以是 Logo 的设计，也可以是品牌本身。所有这些事情，都要更开放地接受定期迭代的可能性，并使用数据来验证和挑战那些曾经行之有效的方法。

---

### (00:45:38) Adam Grenier

**English:**
We live in such a real time world now, especially with product driven companies. The things change so quickly. If you as a marketing leader aren't being iterative and thoughtful about things with it, you'll get eaten alive. And then I think experimentation is just a huge piece of it. And something that I see a lot of more traditional marketing leaders, the idea of experimentation is try a new channel. It's not like how do we experiment with our brand? How do we experiment with the funnel? The whole picture, not just the top of the funnel or the external elements of it.

**中文翻译:**
我们现在生活在一个实时互联的世界，尤其是对于产品驱动型公司。事情变化得太快了。如果你作为营销领导者不能进行迭代和深思熟虑，你会被生吞活剥。然后我认为“实验”是其中巨大的一部分。我看到很多传统营销领导者认为实验就是尝试一个新渠道。而不是“我们如何对品牌进行实验？”“我们如何对漏斗进行实验？”是全局性的实验，而不仅仅是漏斗顶部或外部元素。

---

### (00:46:17) Adam Grenier

**English:**
One of the things that I haven't quite figured out the right language to put against this, but the traditional model of marketing is the four P's, product, placement, promotion, pricing. And in my mind, the world that we live in now, product is no longer a part of marketing, but it's actually they're married at the hip. They're one and the same, and most companies aren't operating that way. They're still operating as if they're two wildly different things. Even if they say they're working together, it's still, there's not. And to me it's just like, no, no, the product, it is the company now.

**中文翻译:**
有一件事我还没想好用什么准确的语言来表达，但传统的营销模型是 4P：产品（Product）、渠道（Placement）、促销（Promotion）、定价（Pricing）。在我看来，在我们现在的世界里，产品不再仅仅是营销的一部分，它们实际上是紧密结合的。它们是一体的，但大多数公司并不是这样运作的。他们仍然把两者当作截然不同的东西。即使他们说在合作，实际上也没有。对我来说，产品现在就是公司本身。

---

### (00:46:59) Adam Grenier

**English:**
And the marketing is integrated with literally every single piece of it. A lot of traditional marketing got established in the 1920s and the 1950s around products that took years to develop or try, or a product team was a science group trying new flavors of cereal. And so the marketing team owned the box, where it went on the shelf and what the price was and all of those kinds of things was marketing, because product was such a wildly different part of the organization. And I think still there's just a lot of fundamental things that marketers think about that are stuck in that world, because most haven't had to grow through the true growth of a business that's just being established today.

**中文翻译:**
营销已经融入了产品的每一个环节。许多传统营销理论建立于 20 世纪 20 年代和 50 年代，围绕着那些需要数年时间开发或测试的产品，或者当时的产品团队只是一个尝试新口味麦片的科学小组。因此，营销团队负责包装盒、上架位置、价格等等，因为当时产品是组织中一个完全不同的部分。我认为现在仍有很多营销人员的基本思维停留在那个世界，因为大多数人还没有经历过当今这种初创企业的真实增长过程。

---

### (00:47:53) Lenny

**English:**
And the assumption is every software company should be hiring a CMO that is of this sort, of a Growth CMO, right?

**中文翻译:**
所以你的假设是，每家软件公司都应该聘请这种类型的 CMO，即增长型 CMO，对吧？

---

### (00:48:01) Adam Grenier

**English:**
Yeah. And I would say that my sense is that there's very few marketing leaders that can't be a Growth CMO. So, I don't think you have to have come up as a performance driven experimentation. It's more about adapting and growing. And again, the fundamentals are all the same. One of my pet projects that I haven't done anything with yet, is that every time something new comes out in the growth world, I go back in history as far as I can to try to find the earliest example of that. Just to be able to say, "Look, this isn't new, but we can learn from the way that Coca-Cola invented the coupon."

**中文翻译:**
是的。而且我觉得很少有营销领导者是不能成为增长型 CMO 的。所以我不认为你必须出身于绩效驱动的实验背景。这更多是关于适应和成长。再说一次，基本原理都是一样的。我有一个还没开始做的个人项目：每当增长领域出现新事物时，我都会尽可能追溯历史，寻找最早的例子。只是为了能说：“看，这并不新鲜，我们可以从可口可乐发明优惠券的方式中学习。”

---

### (00:48:37) Adam Grenier

**English:**
The first known coupon was Coca-Cola giving away Coke for free, but it was actually a marketplace, because what they would do is they would go to a town and they would go to the soda fountain and they would give a free Coke syrup to that side of the market and they would give coupons to the other side of the market to spark it, to get it going. And then it's like, well, now all the customers want Coke, now you need to supply it, you'll pay for it. And learning that and understanding that is really cool. And it's just interesting to me, because I'm a huge nerd.

**中文翻译:**
已知的第一张优惠券是可口可乐免费赠送可乐，但它实际上是一个市场策略。他们会去一个城镇，去冷饮柜台，给那一端的市场提供免费的可乐糖浆，然后给另一端的市场发放优惠券来激发需求，让它运转起来。然后，所有的客户都想要可乐，你就必须供应它，并为此付费。学习并理解这些真的很酷。这对我来说很有趣，因为我是一个超级极客。

---

### (00:49:09) Adam Grenier

**English:**
But that to me is all of the things that great marketing leaders have learned are right, it's the operating aspect of those insights and those skills and understanding your customer and their psychology. All of those things have stayed the same. It's the operating of it in the way a growth organization, like a product driven growth organization operates, is very fundamentally different than the way a traditional marketing run organization had run.

**中文翻译:**
但对我来说，优秀营销领导者学到的所有东西都是正确的，关键在于这些洞察、技能以及对客户及其心理理解的运营层面。所有这些东西都没有变。只是以增长型组织（如产品驱动的增长组织）的运作方式来运营，与传统营销驱动组织的运作方式有着本质的不同。

---

### (00:49:37) Lenny

**English:**
I was going to ask you what a marketing leader can do to evolve into this where you think things are going, and your point about you're capable of it, you can iterate and adapt is really great and empowering. Is there anything specific they can do to learn how to do this better, other than is it like mentorship? Is there classes, courses? Just do the job, figure it out? Do you have anything you can suggest there to folks listening and they're like, "Oh, shit. I'm in trouble?"

**中文翻译:**
我正想问你，营销领导者可以做些什么来进化成这种角色。你关于“你有能力做到、你可以迭代和适应”的观点非常棒，很能给人力量。除了导师指导，还有什么具体的事情可以让他们学得更好吗？有课程吗？还是直接在工作中摸索？对于那些听了之后觉得“噢糟糕，我有麻烦了”的听众，你有什么建议吗？

---

### (00:50:02) Adam Grenier

**English:**
Honestly, I think learn product development. Go learn agile product development. And there's actually a book called Hacking Marketing, I think. I'll confirm. But it's essentially how to run a marketing team on Agile. That to me is just, again, any great marketing leader should be able to go and consume how to do product development, how to run a product like sprints and those types of things. And their mind, if they're great marketing CMO or a CMO, will be like, "Oh my gosh, I could do this with this big event that we want to host. I could do this with everything."

**中文翻译:**
老实说，我认为应该学习产品开发。去学习敏捷产品开发。实际上有一本书叫《黑客营销》（Hacking Marketing），我想是的，我会确认一下。它本质上是关于如何用敏捷方法运行营销团队。对我来说，任何优秀的营销领导者都应该能够去吸收如何做产品开发、如何像运行产品一样运行冲刺等知识。如果他们是优秀的营销 CMO，他们的脑子里会想：“噢我的天，我可以把这套方法用在我们想举办的大型活动上。我可以把它用在任何事情上。”

---

### (00:50:43) Adam Grenier

**English:**
There's nothing off the table when you actually learn those fundamentals. But as well as I know smart people can learn that stuff. There's lots of resources out there. Reforge has some classes on it, there's a bunch of new product led growth classes out in the wild, like Maven I think has a couple. And there's a variety of those types of things that just going and doing it, you don't have to go and operate it yourself. You don't have to go become a product manager. But understanding those skills and those systems will, one, I think make you think differently about how to run your marketing team and, two, make you exponentially better at working with your product organization.

**中文翻译:**
当你真正掌握了这些基本原理，就没有什么是不可能的。我知道聪明人能学会这些。现在有很多资源，Reforge 有相关课程，市面上也有一堆新的产品驱动增长课程，比如 Maven 好像就有几个。有很多这类事情，只要去尝试就行，你不需要亲自去操作，也不需要变成产品经理。但理解这些技能和系统，第一，会让你对如何运行营销团队有不同的思考；第二，会让你在与产品部门协作时变得极其出色。

---

### (00:51:21) Lenny

**English:**
Awesome. I'm actually hearing from folks listening to this podcast not live right now, but broadly, that this is a good way to learn how product works and how product leaders think. So, that's interesting. So, if you're listening to this, good job. You also mentioned that a lot of marketing leaders don't work out at a company, they join, they leave, things go wrong. As a hiring founder or leader, what do you look for to tell you this person's probably not what we need and not what you'd call a Growth CMO? What are flags that are like they're probably not going to adapt and evolve to the way we want to operate?

**中文翻译:**
太棒了。我确实听一些听众说，听这个播客是了解产品运作方式和产品领导者思维的好方法。这很有趣。所以，如果你正在听，干得好。你还提到很多营销领导者在公司里干不长，他们加入、离开，然后出问题。作为招聘的创始人或领导者，你如何判断一个人可能不是我们需要的人，也不是你所说的增长型 CMO？有哪些信号表明他们可能无法适应并进化到我们想要的运作方式？

---

### (00:51:53) Adam Grenier

**English:**
So, I think first and foremost, it obviously depends on the stage. Anything let's say C or below, comfortable with chaos and willingness to go do something they have not done for probably 15 years are two huge signals for me, because every company I've been part of at every scale now, which is all of them basically, that's the thing that a lot of people coming from more traditional marketing environments into startup worlds, it's a pace and just the unpredictability and change and those kinds of things are just at such a higher rate than they've seen for a long time that it can be really jarring for people.

**中文翻译:**
我认为首先，这显然取决于阶段。对于 C 轮或更早期的公司，对混乱的适应能力以及愿意去做可能已经 15 年没亲手做过的事情，对我来说是两个巨大的信号。因为在我待过的各种规模的公司里，从传统营销环境进入初创世界的人，最难适应的就是节奏。那种不可预测性和变化的频率远高于他们长期以来的认知，这会让人们感到非常不适。

---

### (00:52:49) Adam Grenier

**English:**
And I think it's totally reasonable. It's crazy, right? If anybody that's had the exposure on both sides. And then the willingness to go do the work. People are churning constantly and the challenges are different every week and those types of things. And so it's like every now and then you've got to go write an email or you've got to go open up Facebook and get into the weeds with it with your team, into the data of it and that type of stuff. And that's stuff that I don't want to do, personally, me. I'm past the point where I should be in Facebook.

**中文翻译:**
我认为这完全可以理解。这很疯狂，对吧？如果你两边都接触过的话。然后是亲自动手做工作的意愿。人员在不断流失，每周的挑战都不一样。所以偶尔你得亲自去写封邮件，或者亲自打开 Facebook 广告后台，和团队一起深入研究数据之类的。老实说，我个人并不想做这些。我已经过了那个应该亲自操作 Facebook 的阶段了。

---

### (00:53:17) Adam Grenier

**English:**
But man, when I need to, I'm willing to, and I'll go get in the weeds with it and I'll use my time to just be like, "Look, we have to figure this out now." And I'm going to go do the things that I thought I was done with in my career. So, those are pretty big ones. I think then generally speaking, one of the exercises I like to take founders through when they're hiring a marketing leader is every marketer is going to have a T-shaped career.

**中文翻译:**
但是，伙计，当需要的时候，我愿意去做。我会深入细节，花时间说：“看，我们现在必须解决这个问题。”我会去做那些我以为职业生涯中已经不再需要做的事情。所以这些是很重要的信号。我认为总的来说，在创始人招聘营销领导者时，我喜欢带他们做的一个练习是：每个营销人员都有一个“T 型”职业生涯。

---

### (00:53:41) Adam Grenier

**English:**
Everybody came from something they probably became awesome at and then over time just expanded their purview. So, for me it was mobile. I got into mobile. My first client ever was on Sun Microsystems early 2000s, getting Java developers to make apps for flip phones. So, I just knew digital mobile world really, really well before a lot of people did. But then eventually I'm like, "Great, now I'm running an entire digital marketing team. Now I'm running an entire marketing team. Now I'm getting into growth. Now I want to learn product," and I've expanded. And so typically it's going through that exercise of find out their T, find out their strength, and then spend time figuring out how they make up for those other things.

**中文翻译:**
每个人都出身于某个他们非常擅长的领域，然后随着时间的推移扩大了视野。对我来说，那是移动端。我进入了移动领域。我的第一个客户是 21 世纪初的 Sun Microsystems，让 Java 开发人员为翻盖手机开发应用。所以我比很多人都更早、更深入地了解数字移动世界。但最终我想：“太好了，现在我管理整个数字营销团队。现在我管理整个营销团队。现在我进入增长领域。现在我想学习产品。”我一直在扩展。所以通常的做法是找出他们的“T”型结构，找出他们的强项，然后花时间弄清楚他们如何弥补其他方面的不足。

---

### (00:54:24) Adam Grenier

**English:**
So, for me, at Lambda school I ran our PR team for a while. I am not a PR person, but I make it a goal in my life to get to the valley of despair of the Dunning-Kruger effect, to be like, "Great, I just need to know how bad I am at PR," because if I still think I'm good at it, that's not a good place for me to be. But once I know how bad it is, I now know I need to go hire the right person to come in and I'm going to listen to them. I'm not going to assume that I'm smarter than them, and those types of things. And so I think the same thing with product questions and data questions and experimentation questions for this concept of a Growth CMO is like, well, somebody's coming from a world where they've not had to work really closely with the product team, spend time with them to figure out how they plan on adapting to that.

**中文翻译:**
比如在 Lambda School，我管理过一段时间的公关（PR）团队。我不是公关专家，但我把达到“达克效应”（Dunning-Kruger effect）的“绝望之谷”作为人生目标，即：“太好了，我只需要知道我在公关方面有多烂。”因为如果我还觉得自己很擅长，那对我来说不是好事。一旦我知道自己有多烂，我就知道我需要雇佣正确的人，并且我会听取他们的意见。我不会假设自己比他们聪明。对于增长型 CMO 这一概念中的产品问题、数据问题和实验问题也是一样：如果某人来自一个不需要与产品团队紧密合作的环境，那就花时间弄清楚他们计划如何适应这种变化。

---

### (00:55:12) Adam Grenier

**English:**
My guess is most won't have thought of that. The good ones will be able to figure it out together with you in that interview, or afterwards, or whatever it might be.

**中文翻译:**
我猜大多数人还没想到这一点。优秀的人会在面试中、或者面试后，与你一起想出办法。

---

### (00:55:22) Lenny

**English:**
Awesome. Maybe one day we'll do a follow-up chat just to dive into hiring a marketing person. I know that's a whole deep topic.

**中文翻译:**
太棒了。也许有一天我们会做一个后续访谈，专门深入探讨如何招聘营销人员。我知道那是一个非常深刻的话题。

---

### (00:55:31) Adam Grenier

**English:**
Lots of thoughts.

**中文翻译:**
有很多想法。

---

### (00:55:31) Lenny

**English:**
Okay. Oh man. Okay. We've got to book that. But, okay. So, you mentioned the valley of despair, and that's a good segue to our next topic. So, I found this old tweet of yours where you talk about burnout and depression, and you kind of make this point that a lot of times you feel like it's burnout and it's actually depression. And just broadly mental health is just this topic that's not really spoken a lot about in tech and in business. And so I'd love to just spend a little time on this. I know you're a big proponent of talking about these sorts of things, so I'm curious, I know you've been through both these things and I'm curious just to hear your journey, what that's been like, and what you've learned about how to get through it?

**中文翻译:**
好，天哪。我们得约一下。不过，你提到了“绝望之谷”，这正好引出了我们的下一个话题。我找到了你以前发的一条推文，你在里面谈到了职业倦怠（Burnout）和抑郁（Depression），你提出一个观点：很多时候你觉得是职业倦怠，其实是抑郁。广义上说，心理健康在科技界和商界并不是一个经常被谈论的话题。所以我想花点时间聊聊这个。我知道你非常支持谈论这类事情，我也知道你经历过这两者，我很想听听你的心路历程，那是怎样的体验，以及你学到了哪些应对方法？

---

### (00:56:08) Adam Grenier

**English:**
So, the two biggest inputs for me in terms of really taking the time to understand my mental health, one is my wife, who's been a very strong proponent of mental health resources for everybody since I met her. And so just being able to learn from her and get exposure to, well, why is this important? What are the values of it? And seeing it pretty regularly of family members, or coworkers. Or it's like, oh man, I bet there's something deeper here that maybe is important for them to figure out.

**中文翻译:**
对我真正花时间去理解心理健康来说，有两个最大的影响因素。一个是我的妻子，自从我认识她以来，她就一直非常支持每个人都去利用心理健康资源。所以我能从她那里学习，了解到为什么这很重要，它的价值是什么。我也经常在家人或同事身上看到这些问题，我会想：“噢天哪，我敢打赌这背后有更深层的东西，也许对他们来说弄清楚这一点很重要。”

---

### (00:56:46) Lenny

**English:**
Is that just something she's good at, or is she trained in this stuff?

**中文翻译:**
那是她擅长的事情，还是她接受过这方面的训练？

---

### (00:56:49) Adam Grenier

**English:**
No, she's good at it and she's in therapy and stuff like that. She's one of the most empathetic, passionate people I've ever met in my life. And so she just feels like poor people so much that I think it's something really important to her. And then at Uber, I got to a spot where I was incredibly exhausted and tired and just down, not excited about work and things like that, and so I started going to therapy and with this assumption that I was just working too hard.

**中文翻译:**
不，她只是很擅长，而且她也在接受心理咨询之类的。她是我这辈子见过的最有同理心、最热情的人之一。她非常同情那些处境不好的人，我觉得这对她来说非常重要。后来在 Uber，我到了一个极其疲惫、劳累且消沉的状态，对工作提不起劲，于是我开始接受心理咨询，当时我假设自己只是工作太努力了。

---

### (00:57:20) Adam Grenier

**English:**
That was kind of my like, "Man, I need to go to therapy to figure out the tools that I need to deal with me working too hard." And I just uncovered so many interesting things that I wouldn't have expected. So, one was that I'm the youngest child in my family and I did something pretty different than a lot of my relatives and things like that. So, recognition is something I long for, and it turns out I get that at work and I just hadn't gotten that in other parts of my life. And so this thing that I'm like, "This is my problem," was actually a solution to my real problem.

**中文翻译:**
我当时想的是：“伙计，我得去咨询一下，找点工具来应对我工作过度的问题。”结果我发现了很多意想不到的有趣事情。比如，我是家里最小的孩子，我做的事情和我的亲戚们大不相同。所以我渴望获得认可，事实证明我在工作中得到了认可，但在生活的其他部分却没有。所以这个我觉得是“问题”的东西，实际上是我真正问题的“解决方案”。

---

### (00:57:58) Adam Grenier

**English:**
And knowing that just helped me totally just change my perspective of how hard I work. I was getting judgemental about myself around, "Man, I'm working too hard. I shouldn't be doing this, but I have to." And then I got in the spot where I'm like, "Oh, I'm working hard because I love it, because I like it, I'm having an impact and I'm working with people I like and people respect the work that I do." And that helped me identify that I can work just as hard, but I can work smarter. I can work more on the things I have impact on.

**中文翻译:**
意识到这一点后，完全改变了我对自己工作强度的看法。我以前总是自我评判：“伙计，我工作太努力了，我不该这样，但我不得不做。”后来我意识到：“噢，我努力工作是因为我热爱它，因为我喜欢它，我正在产生影响力，我在和喜欢的人一起工作，而且人们尊重我的工作。”这帮助我明确了：我可以同样努力地工作，但我可以工作得更聪明。我可以更多地去做那些我有影响力的事情。

---

### (00:58:30) Adam Grenier

**English:**
I can work more with people that actually respected the type of work that I'm doing. And that actually just started to relax me and get me to the spot of, "Oh, okay," I still some burnout in there, and that's part of the innovation. Part of my title was that I got to a spot where I'm like, I was traveling constantly, I had teams all over the world and the structure of Uber was working where every city had a GM and I was the person they called when their spend was too high. And so 500 GMs-

**中文翻译:**
我可以更多地与那些真正尊重我工作类型的人合作。这实际上让我开始放松，并意识到：“噢，好吧。”我当时确实还有一些职业倦怠，那是创新工作的一部分。我当时的状态是：我不断地出差，团队遍布全球，Uber 的架构是每个城市都有一个总经理（GM），而当他们的支出过高时，我就是那个被叫去问责的人。当时有 500 个 GM——

---

### (00:59:05) Lenny

**English:**
Uber GMs especially.

**中文翻译:**
尤其是 Uber 的 GM 们。

---

### (00:59:06) Adam Grenier

**English:**
Yeah, exactly. And so I was working in a world where I was dealing with a lot of politics. I love mentoring people, and I had this massive team of 150 people that I barely know any of them. And so I'm not mentoring people either anymore. And I just felt like I'm working so hard on things that I actually don't enjoy. And so I'm like, I'm going to go work on flying cars, which is a whole other podcast too. So, that was my, okay, there was burnout in there.

**中文翻译:**
是的，没错。所以我当时处在一个要处理大量政治斗争的环境中。我喜欢指导别人，但我当时管理着一个 150 人的庞大团队，我几乎不认识他们中的任何一个。所以我也不再指导别人了。我觉得我为了那些我并不享受的事情拼命工作。于是我想，我要去研究飞行汽车了（那是另一个播客的话题了）。所以，那是我的状态，确实有职业倦怠。

---

### (00:59:33) Adam Grenier

**English:**
I know that was a fact, but some of those feelings or things that I felt my entire life that I uncovered that I thought was just burnt out, I was like, "Oh, actually at this point in my life, this point in my life and this point in my life, I felt this way too. And at those points I wasn't burnt out. And so I actually have deeper work to do here and deeper understanding of myself so that I can actually maximize my life and enjoy it." And because I'm going to keep working to some degree this hard. And I want to just make the most of that.

**中文翻译:**
我知道那是事实，但我发现我一生中感受到的某些情绪，我原以为只是职业倦怠，其实不然。我想：“噢，实际上在我人生的这个点、那个点，我也曾有过这种感觉。而那时我并没有职业倦怠。”所以我实际上有更深层的工作要做，需要更深层地了解自己，这样我才能真正最大化我的生活并享受它。因为我还会继续保持某种程度的努力工作，我想充分利用这一点。

---

### (01:00:03) Lenny

**English:**
I don't know if you mentioned this, but I imagine parts of those points were depression, not burnout. What have you found to be that line of just like, "Oh wow, this is a lot more serious than I'm just working way too hard?"

**中文翻译:**
我不确定你是否提到了这一点，但我猜那些时刻中有一部分是抑郁，而不是职业倦怠。你发现的界限在哪里？就是那种“噢哇，这比‘我只是工作太努力了’要严重得多”的感觉？

---

### (01:00:14) Adam Grenier

**English:**
For me, it's hard to describe, but I personally now can pretty cleanly tell the difference between exhaustion and depression. And it tends to tie to my broader motivations, not just my motivation to work. So, when I'm exhausted, I'll still show up to work, I'll still execute, I'll still do those types of things, but I'm going to go and if I can take an improv class, it's going to be a blast. I'm going to enjoy it and I'm going to love it. If I'm depressed, I won't go to that improv class. I'll just cancel it. I won't go to it. Or if I go to it, I'll go home immediately. One of the things I love about actual improv classes, is the community. Is, "Hey, let's all go grab a drink now." And this is a totally different group of people. It's not my family, it's not my work people, it's just me.

**中文翻译:**
对我来说，这很难描述，但我现在个人可以非常清楚地分辨疲惫（Exhaustion）和抑郁（Depression）。它往往与我更广泛的动力有关，而不仅仅是工作的动力。当我疲惫时，我仍然会去上班，仍然会执行任务，仍然会做那些事，但我会去上即兴表演课，那会非常开心，我会享受并热爱它。但如果我抑郁了，我就不会去上那节课。我会直接取消，或者即使去了，我也会立刻回家。我喜欢即兴表演课的一个原因是社区感，大家会说：“嘿，我们去喝一杯吧。”那是一群完全不同的人，不是家人，不是同事，只是我自己。

---

### (01:01:17) Adam Grenier

**English:**
And I wouldn't do that. And so it's kind of noticing where else is this impacting and to what degree and why, can help me understand what's going on in my life. Because more often than not, I can then take those feelings and it'll be like, "Oh, I've felt this way for three weeks now. I should think about this and dissect it a little bit." And so again, I'll spend time with my therapist. One of the tools that my therapist has given me is to open up with my friends and have these conversations with my friends. And so now I went from five, six years ago really just having my therapist or my wife to talk about this kind of stuff to, I don't know, I have five or six different friends that we're massively transparent with each other about this stuff, because the second I shared any of this with them, they shared it with me.

**中文翻译:**
如果是抑郁，我就不会去参加聚会。所以，观察这种情绪还在哪些方面产生影响、程度如何以及为什么，可以帮助我理解生活中发生了什么。因为通常情况下，我可以审视这些感受并意识到：“噢，我已经这种感觉三周了，我应该思考一下并剖析它。”于是，我会再次去找心理咨询师。咨询师给我的一个工具是向朋友敞开心扉，与朋友进行这些对话。所以，从五六年前只能和咨询师或妻子聊这些，到现在我有五六个可以完全透明地聊这些话题的朋友，因为只要我一分享，他们也会向我分享。

---

### (01:02:06) Adam Grenier

**English:**
And now we've become safe places to have those conversations where I can be like, "Hey, there's this thing going on." My dad has ALS and so he's been really sick and I've got three kids and I've got jobs and work and money and the market crash. And there's so many different things. It's like, okay, let me actually figure out which one of these things is causing this energy right now. And having many years of therapy now and those resources can help me get to that solution to get to that answer so that I can figure out, okay, what do I need to do right now? Do I need to actually take time for myself and dig deeper into these personal things? Do I actually need to change something with the shape of my career? Those types of things.

**中文翻译:**
现在我们成了彼此的避风港，可以进行这样的对话，我可以直说：“嘿，最近发生了这些事。”我父亲患有渐冻症（ALS），病得很重，我有三个孩子，我有工作、金钱压力，还有市场崩盘。有这么多不同的事情。我会想，好吧，让我弄清楚到底是哪件事导致了现在的这种负能量。经过多年的心理咨询和利用这些资源，我可以找到答案，弄清楚我现在需要做什么。我是需要为自己留点时间深入挖掘这些个人问题？还是我真的需要改变职业生涯的形态？诸如此类。

---

### (01:02:47) Lenny

**English:**
Awesome. And it sounds like the things that have been most helpful, and I'm curious what else you'd recommend to folks that are maybe feeling some of this. So, it sounds like therapy is really powerful, your partner and being open to your partner, finding a group of friends where you could be transparent about these sorts of things. Is there anything else you suggest folks look into?

**中文翻译:**
太棒了。听起来这些是最有帮助的事情。我很好奇你还会向那些可能有类似感受的人推荐什么。听起来心理咨询非常强大，还有你的伴侣以及对伴侣敞开心扉，还有找一群可以坦诚相待的朋友。你还建议人们关注其他什么吗？

---

### (01:03:04) Adam Grenier

**English:**
Yeah. So, I think meditation's a good one. The startup people love to talk about meditation, and so you can find lots of ways to do that. It's kind of evolved for me. So, it's in that tweet thread and I can't remember it now. There was a meditation thing that was the first, it almost felt like Noom for me for meditation where it wasn't just-

**中文翻译:**
是的。我认为冥想（Meditation）是个好方法。初创公司的人都喜欢谈论冥想，所以你可以找到很多方法。对我来说，它也在进化。在那条推特线索里提到过，我现在记不清了。有一个冥想应用是我的首选，它对我来说感觉就像冥想界的 Noom（一款健康管理应用），它不仅仅是——

---

### (01:03:24) Lenny

**English:**
Waking Up, Sam Harris's-

**中文翻译:**
是 Sam Harris 的《Waking Up》吗？

---

### (01:03:25) Adam Grenier

**English:**
Yeah, Waking Up where it's like I'm actually learning about meditation, not just learning how to meditate. And that's how my brain likes to do things. I'm a lifetime learner, I love digging into things. I learned breathing techniques and things like that, but going through that program of Waking Up was the first time I actually really appreciated when and how and where to do it. I'm still not a everyday meditate person.

**中文翻译:**
是的，《Waking Up》。在里面我实际上是在学习关于冥想的知识，而不仅仅是学习如何冥想。我的大脑就喜欢这样运作。我是一个终身学习者，喜欢钻研事物。我学过呼吸技巧之类的，但通过《Waking Up》这个项目，我第一次真正领悟了何时、如何以及在哪里进行冥想。我仍然不是一个每天都冥想的人。

---

### (01:03:50) Adam Grenier

**English:**
I now use, I'm an investor, so I'm biased, but Aura, A-U-R-A, which is a marketplace app. It's some of the other meditation apps, but it's a marketplace, so it's actually coaches and stuff adding content. So, I use that now as needed, which I really enjoy. The exercise and diet and those types of things definitely tie to it. It's like eating is a pretty clean signal for me, or snacking is a really clean signal, at least for me of like, okay, I'm snacking more than I should be, and eating healthy can both help me identify that I'm in those spots, but also just make me feel better.

**中文翻译:**
我现在用的是 Aura（我是投资者，所以我有偏见），它是一个平台型应用。它类似于其他冥想应用，但它是一个市场，有很多教练在上面添加内容。我现在根据需要使用它，非常喜欢。运动和饮食之类的事情肯定也与之相关。对我来说，饮食是一个非常清晰的信号，或者说吃零食是一个很清晰的信号：好吧，我零食吃得比平时多了。健康饮食既能帮我识别出我处于那种状态，也能让我感觉更好。

---

### (01:04:29) Adam Grenier

**English:**
One thing I would say is that the therapist that I found, I found through a service that we had at Uber, and I think I was surprised how much stuff is covered by companies in terms of the ability to find a therapist, pay for a therapist or other tools. And so that is one thing I would suggest, go look through your benefits. Your healthcare provider offers a lot of that stuff too. So, those are a handful of. Listen to Lenny's podcast?

**中文翻译:**
我想说的一点是，我找的咨询师是通过 Uber 提供的一项服务找到的。我很惊讶公司在寻找咨询师、支付咨询费或其他工具方面涵盖了这么多内容。所以我建议大家去查看一下自己的员工福利。你的医疗保险提供商通常也提供很多这类服务。以上就是一些建议。还有，听 Lenny 的播客？

---

### (01:04:58) Lenny

**English:**
I hope that to be true. I don't know if that's anywhere near as powerful as these other things. One thing I'll mention is on the meditation front, there's this amazing book that kind of does exactly what you also describe where it teaches you why this works. It's called, it's kind of like a bad title, it's called Why Buddhism is True. And it's not trying to convince you to be a Buddhist, but it has a lot of incredible insights on why meditation is so powerful and how to think about it. So, I'll put that in the show notes too.

**中文翻译:**
我希望那是真的。我不知道这是否能像其他那些方法一样强大。关于冥想，我想提一下，有一本很棒的书，它做的正是你描述的事情——教你为什么这有效。书名可能不太讨喜，叫《为什么佛学是真的》（Why Buddhism is True）。它并不是要说服你成为佛教徒，但它对于冥想为什么如此强大以及如何思考冥想有很多不可思议的见解。我也会把它放在节目笔记里。

---

### (01:05:24) Adam Grenier

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### (01:05:24) Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### (01:05:24) Adam Grenier

**English:**
I'm going to check that out.

**中文翻译:**
我会去看看的。

---

### (01:05:25) Lenny

**English:**
I wanted to come back to the burnout piece. I imagine some folks are listening to this and they're like, "Am I burnt out? I don't know." What are signs that you're burnt out versus just working a lot and tired?

**中文翻译:**
我想回到职业倦怠的话题。我猜有些听众在听的时候会想：“我职业倦怠了吗？我不知道。”职业倦怠和“只是工作很多且感到疲劳”之间有什么区别信号？

---

### (01:05:37) Adam Grenier

**English:**
The one that I see the most is adaptability goes down really fast. And this is more me noticing I've managed a lot of people and coached a lot of people, so when I see that from people that I'm working with, I usually immediately bring up, I'm like, "Look, your openness to change in the business, or trying new things, or going back and trying things that maybe we tried before and didn't work has shifted from, 'Oh, here are the flags that we should be aware of, but let's give it a shot' to 'Why are we wasting our time? Let's not do this.'"

**中文翻译:**
我看到最多的一点是适应能力迅速下降。这是我通过管理和指导很多人观察到的。当我从合作的人身上看到这一点时，我通常会立即提出来，我会说：“看，你对业务变化的开放程度、尝试新事物的意愿，或者重新尝试以前失败过的事情的态度，已经从‘噢，虽然有这些风险，但让我们试试吧’变成了‘我们为什么要浪费时间？别做这个了’。”

---

### (01:06:12) Adam Grenier

**English:**
This energy around, let's just do the thing we're supposed to do. And I think that's maybe specifically applicable to our environment, to high growth and marketing and product where it's just, that's just a key ingredient to doing this job well, is adaptability and flexibility and exploration. And if you're losing that, it's probably not because you've gotten bad at it, right? It's probably because you're just over it, right? Where you're like, "I just don't want to deal with the BS around this. I want to go do the thing that makes my job easier."

**中文翻译:**
这种能量变成了“我们就做该做的事吧”。我认为这在我们的环境（高增长、营销和产品）中尤为适用，因为适应性、灵活性和探索精神是做好这份工作的关键要素。如果你失去了这些，可能不是因为你变差了，而是因为你已经厌倦了，对吧？你会觉得：“我不想处理这些破事了，我只想做点让工作更轻松的事。”

---

### (01:06:46) Adam Grenier

**English:**
Which again, most of the people that have chosen this career path want their jobs to be harder, because it's more fun, it's more interesting, it's more rewarding. And so when you're looking for ways to minimize the challenge or the opportunity, I think that's a pretty good signal that they may be more burnt out than just exhaustion. Because if anything, I see the opposite for people that are exhausted, where they get re-motivated by new stuff, by opportunities to go do something different and that kind of stuff.

**中文翻译:**
再说一次，大多数选择这条职业道路的人其实希望工作更有挑战性，因为那样更有趣、更刺激、更有成就感。所以当你开始寻找减少挑战或机会的方法时，我认为这是一个很好的信号，表明你可能已经职业倦怠了，而不仅仅是疲劳。因为对于疲劳的人，我看到的往往相反——他们会被新事物、做不同事情的机会重新激发动力。

---

### (01:07:15) Lenny

**English:**
Wow. Really good insight. Second to last question, I know you have to run, where are you on this journey today and then just what's next for Adam Grenier?

**中文翻译:**
哇，非常有见地。倒数第二个问题，我知道你得赶时间。你现在的状态如何？Adam Grenier 的下一步计划是什么？

---

### (01:07:24) Adam Grenier

**English:**
Yeah, thank you. Good question. I'm constantly optimizing this matrix of what am I good at versus what do I love doing? And so what I've found is that I really love entrepreneurs and working really closely with entrepreneurs and helping them figure out all of these funky things that I've been able to see over the last 20 years and maneuver. And I've worked at a lot of places and so I'm really good at context changing and helping connect the dots for people.

**中文翻译:**
谢谢，好问题。我一直在优化“我擅长什么”与“我热爱做什么”的矩阵。我发现我真的很喜欢企业家，喜欢与他们紧密合作，帮助他们解决我过去 20 年里见识过并处理过的各种古怪问题。我在很多地方工作过，所以我非常擅长切换背景并帮助人们串联起各个环节。

---

### (01:07:52) Adam Grenier

**English:**
And so a couple ways I've found to be able to do that is advising companies, so working with founders and growth leaders and things like that and investing. And so I'm actually right now, I've been investing now for six, seven years. I've recently joined Andreessen's Scout fund, so I'm doing a bit more volume now. But I would say if I had to make a bet right now, I think a full-time or closer to full-time investing world is what I'd like to lean more towards. But I'm very much a let's just open up opportunities, and once the right one is in front of me, I'm going to tackle it.

**中文翻译:**
我发现实现这一目标的几种方式是：为公司提供咨询（与创始人、增长领导者合作）以及投资。实际上，我已经做了六七年的投资了。最近我加入了 Andreessen 的 Scout 基金，所以现在的投资量更大了。但如果要我现在的打算，我想我会更倾向于全职或接近全职的投资领域。但我非常随缘，就是开放各种机会，一旦合适的机会出现，我就会抓住它。

---

### (01:08:23) Adam Grenier

**English:**
And so who knows, I may go back full time somewhere or whatnot. But right now the advising, investing, coaching kind of hybrid is the term, I think it was Behzod at Reforge used, was me as a service is my current world. But I'd be shocked if I eventually don't gravitate towards some kind of foundation, because I thrive when I've got a little bit of an anchor.

**中文翻译:**
谁知道呢，我也可能回到某家公司全职工作。但目前这种咨询、投资、教练的混合模式（我想 Reforge 的 Behzod 用过一个词叫“个人即服务”，MaaS），就是我现在的状态。但如果我最终没有倾向于某种更稳固的基础，我会很惊讶，因为当我有了一点“锚点”时，我会表现得更好。

---

### (01:08:46) Lenny

**English:**
Amazing. A mass, me as a service.

**中文翻译:**
太棒了。MaaS，个人即服务。

---

### (01:08:49) Adam Grenier

**English:**
Yeah.

**中文翻译:**
是的。

---

### (01:08:49) Lenny

**English:**
Okay. For folks that may want to reach out to you about taking your money in their startup, or asking whatever questions, maybe advising questions, where can folks reach you and learn more?

**中文翻译:**
好。对于那些想找你投资、或者想问你问题（比如咨询问题）的人，他们可以在哪里联系你并了解更多信息？

---

### (01:09:00) Adam Grenier

**English:**
Just Twitter, AKGrenier and LinkedIn as well, it's AKGrier. So, look me up, connect. I'm always open to connecting and chatting with people and I just love digging into problems. So, happy to abide.

**中文翻译:**
Twitter 搜 AKGrenier，LinkedIn 搜 AKGrier。来找我吧，建立联系。我一直很乐意与人交流，我喜欢钻研问题。很乐意效劳。

---

### (01:09:13) Lenny

**English:**
Amazing. Adam, this was such an action packed chat, so many levels and layers. I can't wait for folks to listen to this. Thank you so much for joining me and being here.

**中文翻译:**
太棒了。Adam，这是一次干货满满的聊天，涵盖了这么多层面。我迫不及待想让大家听到这些。非常感谢你加入我们。

---

### (01:09:21) Adam Grenier

**English:**
Yeah, thanks for having me.

**中文翻译:**
谢谢，感谢邀请。

---

### (01:09:22) Lenny

**English:**
My pleasure. Thanks man.

**中文翻译:**
我的荣幸。谢谢，伙计。

---

### (01:09:24) Adam Grenier

**English:**
Good stuff. Take care.

**中文翻译:**
很棒的内容。保重。

---

### (01:09:26) Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得内容有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。