# Albert Cheng - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Albert Cheng.

---

### [00:00:00] [Albert Cheng]

**English:**
Growth as the job is to connect users to the value of your product. Growth sometimes gets this reputation that it's just pure metrics hacking.

**中文翻译:**
增长工作的本质是将用户与产品的价值连接起来。增长有时会被误解为纯粹的指标操纵（Metrics Hacking）。

---

### [00:00:08] [Lenny Rachitsky]

**English:**
You've worked at three of the most successful consumer subscription products in the world. What do you think is the biggest missing piece that people don't get about building a successful consumer subscription product?

**中文翻译:**
你曾在全球三款最成功的消费级订阅产品中工作过。你认为在构建成功的消费级订阅产品时，人们最容易忽略或不理解的关键点是什么？

---

### [00:00:18] [Albert Cheng]

**English:**
User retention is gold for consumer subscription companies. If you don't retain your users, then a lot of the onus is on getting them to pay on day one.

**中文翻译:**
对于消费级订阅公司来说，用户留存（User Retention）就是金子。如果你留不住用户，那么所有的压力都会集中在如何让他们在第一天就付费上。

---

### [00:00:26] [Lenny Rachitsky]

**English:**
Noam Levinsky, he said that I need to ask you about the biggest monetization win that you found at Grammarly.

**中文翻译:**
Noam Levinsky 说我一定要问问你在 Grammarly 发现的最大变现（Monetization）突破。

---

### [00:00:31] [Albert Cheng]

**English:**
The lived product experience for most of the free users was that Grammarly was just a product to fix your spelling and grammar because those were the free suggestions. What if we actually sampled a number of different paid suggestions and interspersed them to free users across their writing? All of a sudden, people were seeing Grammarly as a much more powerful tool than they were before.

**中文翻译:**
对于大多数免费用户来说，实际的产品体验是 Grammarly 只是一个纠正拼写和语法的工具，因为这些是免费提供的建议。如果我们抽取一些付费建议，并将它们穿插在免费用户的写作过程中会怎样？突然之间，人们发现 Grammarly 比他们以前认为的要强大得多。

---

### [00:00:50] [Lenny Rachitsky]

**English:**
What's the most counterintuitive lesson you've learned about building teams?

**中文翻译:**
关于团队建设，你学到的最反直觉的教训是什么？

---

### [00:00:54] [Albert Cheng]

**English:**
I saw some of the highest performers just being people that had very high agency, had that clock speed, had that energy, but they didn't necessarily need to have deep experience on that matter. Sometimes experience could be a crutch, especially in this world where the grounds are shifting so fast with AI. A lot of your learned habits actually need to be intentionally discarded.

**中文翻译:**
我发现一些表现最出色的人往往是那些具有极高自主性（High Agency）、反应速度快且充满活力的人，但他们并不一定需要具备该领域的资深经验。有时经验反而会成为一种阻碍，尤其是在 AI 飞速发展的今天。你学到的很多习惯实际上需要被刻意丢弃。

---

### [00:01:13] [Lenny Rachitsky]

**English:**
Today my guest is Albert Cheng. Albert is known as one of the top consumer growth minds in the world. He led growth and monetization at three of the most successful and beloved consumer products in the world, Duolingo, Grammarly, and now Chess.com. Earlier in his career at YouTube, he worked on streaming and gaming features used by over 20 million people.
(00:01:32):
His unique approach to growth blends marketing, data, strategy, and product management, and in our conversation, we cover a lot of ground, including his explore and exploit framework to find growth opportunities. His biggest and most interesting growth wins at Duolingo, Grammarly and Chess.com, how he uses AI to accelerate his growth work, what he's come to realize about the power of brand and community in your growth work, his top experimentation, best practices, why his goal at every company is to run 1,000 experiments a year and so much more.
(00:02:02):
A huge thank you to Erik Allebest, Noam Levinsky, and Jorge Mazal for suggesting topics for this conversation. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube, it helps tremendously. Also, if you become an annual subscriber of my newsletter, you get 15 incredible products for free for an entire year, including Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD and Mobbin.
(00:02:33):
Head on over to lennysnewsletter.com and click Product Pass. With that, I bring you Albert Chain, my podcast guest tonight love talking about craft and taste and agency and product market fit. You know what we don't love talking about? SOC 2. That's where Vanta comes in. Vanta helps companies of all sizes get complying fast and stay that way with industry-leading AI automation and continuous monitoring. Whether you're a startup, your first SOC 2 or ISO 27001 or an enterprise managing vendor risk, Vanta's trust management platform makes it quicker, easier, and more scalable.
(00:03:08):
Vanta also helps you complete security questionnaires up to five times faster so that you could win bigger deals sooner. The result, according to a recent IDC study, Vanta customers slashed over $500,000 a year and are three times more productive. Establishing trust isn't optional. Vanta makes it automatic. Get $1,000 off at Vanta.com/lenny. This episode is brought to you by Jira Product Discovery. The hardest part of building products isn't actually building products, it's everything else.
(00:03:41):
It's proving that the work matters, managing stakeholders trying to plan ahead. Most teams spend more time reacting than learning, chasing updates, justifying roadmaps, and constantly unblocking work to keep things moving. Jira Product Discovery puts you back in control. With Jira Product Discovery, you can capture insights and prioritize high impact ideas.
(00:04:01):
It's flexible so it adapts to the way your team works and helps you build a roadmap that drives alignment, not questions. And because it's built on Jira, you can track ideas from strategy to delivery all in one place, less chasing, more time to think, learn and build the right thing. Get Jira Product Discovery for free at Atlassian.com/lenny, that's Atlassian.com/lenny. Albert, thank you so much for being here and welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Albert Cheng。Albert 被公认为全球顶尖的消费级增长专家之一。他曾在全球三款最成功且备受喜爱的消费级产品——Duolingo（多邻国）、Grammarly 和现在的 Chess.com 领导增长和变现工作。在他职业生涯的早期，他在 YouTube 负责流媒体和游戏功能，用户量超过 2000 万。
(00:01:32):
他独特的增长方法融合了营销、数据、策略和产品管理。在我们的对话中，我们涵盖了广泛的内容，包括他寻找增长机会的“探索与利用”（Explore and Exploit）框架；他在 Duolingo、Grammarly 和 Chess.com 取得的最大且最有趣的增长突破；他如何利用 AI 加速增长工作；他如何意识到品牌和社区在增长工作中的力量；他的顶级实验最佳实践；为什么他在每家公司的目标都是每年运行 1000 个实验，以及更多内容。
(00:02:02):
非常感谢 Erik Allebest、Noam Levinsky 和 Jorge Mazal 为本次对话建议的话题。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注，这对我们帮助很大。此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你将免费获得 15 款不可思议的产品一整年的使用权，包括 Lovable、Replit、Bolt、n8n、Linear、Superhuman、Descript、Wispr Flow、Gamma、Perplexity、Warp、Granola、Magic Patterns、Raycast、ChatPRD 和 Mobbin。
(00:02:33):
请访问 lennysnewsletter.com 并点击 Product Pass。接下来，我为您请出 Albert Cheng。我今晚的播客嘉宾喜欢谈论工艺、品味、自主性和产品市场匹配（Product Market Fit）。你知道我们不喜欢谈论什么吗？SOC 2。这就是 Vanta 大显身手的地方。Vanta 帮助各种规模的公司快速获得合规认证，并通过行业领先的 AI 自动化和持续监控保持合规。无论你是正在进行首次 SOC 2 或 ISO 27001 认证的初创公司，还是管理供应商风险的企业，Vanta 的信任管理平台都能让过程更快速、更简单、更具扩展性。
(00:03:08):
Vanta 还能帮助你以最高五倍的速度完成安全调查问卷，从而更快地赢得大单。根据最近的一项 IDC 研究，Vanta 的客户每年削减了超过 50 万美元的成本，生产力提高了三倍。建立信任不是可选的，Vanta 让它变得自动化。在 Vanta.com/lenny 获取 1000 美元的优惠。本集节目由 Jira Product Discovery 为您呈现。开发产品最难的部分其实不是开发本身，而是其他所有事情。
(00:03:41):
是证明工作的价值，管理利益相关者，尝试提前计划。大多数团队花在应对突发状况上的时间多于学习，忙于追逐更新、解释路线图，并不断为工作排障以保持进度。Jira Product Discovery 让你重获掌控权。通过 Jira Product Discovery，你可以捕捉洞察并优先处理高影响力的想法。
(00:04:01):
它非常灵活，能适应你团队的工作方式，并帮助你构建一个能达成共识而非引发质疑的路线图。因为它建立在 Jira 之上，你可以在一个地方跟踪从策略到交付的所有想法。减少追赶，留出更多时间思考、学习和构建正确的产品。在 Atlassian.com/lenny 免费获取 Jira Product Discovery。Albert，非常感谢你能来到这里，欢迎来到播客。

---

### [00:04:33] [Albert Cheng]

**English:**
Thanks for having me, Lenny. Excited to be here.

**中文翻译:**
谢谢邀请，Lenny。很高兴来到这里。

---

### [00:04:35] [Lenny Rachitsky]

**English:**
I'm even more excited to have you here. So as I do for every podcast conversation, I reached out to a bunch of people that you've worked with that know you well to find out what to ask you about and what topics to spend time on. Jorge Mazal, who is famous in my world for writing, what was for the longest time, the most popular newsletter post on my newsletter, it's actually people have usurped it now, but it was stuck there for a long time. So here's what he wrote. "It is a mystery to me how Albert is able to do what he does. I am actually eager to listen to this episode and learn from him."

**中文翻译:**
我更兴奋能请到你。正如我在每期播客中所做的那样，我联系了一群曾与你共事、非常了解你的人，想看看该问你什么，以及在哪些话题上多花时间。Jorge Mazal 在我的圈子里很有名，他写过一篇在我时事通讯中长期占据榜首的文章（虽然现在被别人超越了，但它在那儿待了很久）。他是这么写的：“对我来说，Albert 是如何做到他所做的一切一直是个谜。我非常渴望听这一集并向他学习。”

---

### [00:05:10] [Albert Cheng]

**English:**
That is super nice. Thank you, Jorge. I've learned so much from him. I'm the type of weird person that likes to wake up before their kids and pull up a bunch of browser tabs and look at experiments. So it was perfect that Jorge brought me into the growth world at Duolingo, learned a ton of best practices, and he's just a great guy. Thanks, Jorge.

**中文翻译:**
那太客气了，谢谢 Jorge。我从他身上学到了很多。我是那种怪人，喜欢在孩子起床前醒来，打开一堆浏览器标签页看实验数据。所以 Jorge 把我带进 Duolingo 的增长世界真是太完美了，我学到了大量的最佳实践，他是个很棒的人。谢谢，Jorge。

---

### [00:05:27] [Lenny Rachitsky]

**English:**
We're already getting into these tactics. I love it. Let me just give a little framing on what I want to do with this conversation. What I want to try to do is to help people learn tools and mental models for finding growth opportunities for their own products and essentially learn the growth mentality that you bring into the companies and products that you work on.
(00:05:48):
What I want to start with is to give us a little insight into how you became what you became. There's an interesting pattern I found across a bunch of recent guests, which is many people were very good at piano when they were younger and were very serious piano players. For example, Head of ChatGPT, Nick Turley was almost going to become professional jazz pianist. You were very serious as a piano player earlier in your career. How did you go from pianist to one of the top growth minds in the world briefly?

**中文翻译:**
我们已经开始进入这些战术环节了。我喜欢。让我先做一点铺垫，说明我想通过这次对话达成什么。我希望帮助人们学习寻找产品增长机会的工具和思维模型，并学习你带入所服务的公司和产品中的那种“增长心态”。
(00:05:48):
我想先请你分享一下你是如何成长为今天的自己的。我在最近的几位嘉宾身上发现了一个有趣的模式：很多人年轻时钢琴弹得非常好，而且是非常认真的琴手。例如，ChatGPT 的负责人 Nick Turley 差点成了职业爵士钢琴家。你在职业生涯早期也是一名非常认真的钢琴手。你是如何从一名钢琴手转变为全球顶尖的增长专家的？请简要分享一下。

---

### [00:06:18] [Albert Cheng]

**English:**
Well, that's very flattering, but I appreciate it. Yeah, I grew up playing a lot of piano. My parents were immigrants from Taiwan and I was the oldest kid that they had, and so I definitely felt that strong encouragement, if you will, to learn a bunch of things, take them seriously, study hard, and so I did. And my parents, even though they weren't musically proficient, they had a deep love for classical music.
(00:06:45):
So I was the stereotypical baby that would listen to Mozart, I guess when I was sleeping type of thing. And I still vividly remember we had this upright Yamaha piano, and at the very top of the piano we had this countdown clock from 90 minutes. Literally every single day of my childhood, just practice really, really consistently.
(00:07:04):
At first, I really was irritated by that thing, but as I grew older, I started to appreciate music quite a bit more. But anyway, I think what really accelerated my interest and abilities in piano was I feel like I hit the lottery. I had perfect pitch, and so I was able to quickly understand whether I was playing the right stuff or the wrong stuff and just pick up music pretty rapidly.

**中文翻译:**
这非常过奖，但我很感激。是的，我从小弹很多钢琴。我的父母是来自台湾的移民，我是家里的老大，所以我确实感受到了那种“强烈的鼓励”，去学习很多东西，认真对待，努力学习，我也确实这么做了。我的父母虽然不精通音乐，但他们对古典音乐有着深厚的热爱。
(00:06:45):
所以我就是那种典型的听着莫扎特睡觉的婴儿。我还清晰地记得家里有一台雅马哈立式钢琴，钢琴顶部放着一个 90 分钟的倒计时钟。我童年的每一天都在非常、非常一致地练习。
(00:07:04):
起初，我真的很讨厌那个东西，但随着年龄增长，我开始更加欣赏音乐。无论如何，我认为真正加速我对钢琴的兴趣和能力的是，我觉得自己中了彩票——我有“绝对音感”（Perfect Pitch），所以我能很快判断自己弹得对不对，学习音乐的速度非常快。

---

### [00:07:29] [Lenny Rachitsky]

**English:**
What does perfect pitch even mean? Does that mean which note is playing?

**中文翻译:**
绝对音感到底是什么意思？是指能听出正在播放哪个音符吗？

---

### [00:07:29] [Albert Cheng]

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:07:29] [Lenny Rachitsky]

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:07:34] [Albert Cheng]

**English:**
Exactly.

**中文翻译:**
正是如此。

---

### [00:07:34] [Lenny Rachitsky]

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:07:35] [Albert Cheng]

**English:**
So I could listen to a song and then just a very, very clear understanding of which note I'm supposed to start with and if I'm playing something wrong. So it's very helpful.

**中文翻译:**
所以我听一首歌，就能非常清晰地知道应该从哪个音符开始，以及我是否弹错了。所以这非常有帮助。

---

### [00:07:35] [Lenny Rachitsky]

**English:**
Unfair.

**中文翻译:**
这太不公平了（天赋异禀）。

---

### [00:07:44] [Albert Cheng]

**English:**
It's unfair. Definitely. So anyway, yeah, I got quite good as a teenager in high school and even considered studying at a music conservatory. My intrinsic motivation for music wasn't necessarily as strong at that point, and so I decided to go to engineering school instead, but that would've been an incredibly different career. And to your original point around the relationship between music and growth, I didn't really reflect on this until recently.
(00:08:12):
I have a four-year-old and I'm starting to teach him how to bang on the keys a little bit, but a couple things stand out. One is that I think music and growth, they both rely on this just consistent repetition. You're constantly making mistakes. You have this super tight feedback loop. You have to get really resilient to just making mistakes all the time. And you know that the way of learning is through those mistakes. So that's a thing that I learned very early, and the second thing that occurred to me is that they both have this structural underpinning to them.
(00:08:45):
With growth, you have a growth model, you have metrics, you have experiments, you have channels, things like that. But you also need on a day-to-day basis to have creativity, you got to come up with interesting solutions or hypotheses to test. And the same is true on the music side. You have music theory of scales and stuff, but to create beautiful music, you need that passion, that emotion, that flow. So I think that's the beautiful combination between the two.

**中文翻译:**
确实不公平。总之，我在高中青少年时期弹得相当好，甚至考虑过读音乐学院。但那时我对音乐的内在动力没那么强了，所以我决定去读工程学院，否则那将是完全不同的职业生涯。回到你最初关于音乐与增长之间关系的观点，我直到最近才开始反思这一点。
(00:08:12):
我有一个四岁的孩子，我正开始教他敲琴键，有几点非常突出。第一，我认为音乐和增长都依赖于这种持续的重复。你不断犯错，你有一个极其紧密的反馈回路。你必须变得非常有韧性，去面对不断的错误。你知道学习的方式就是通过这些错误。这是我很早就学到的。第二点是，它们都有结构性的基础。
(00:08:45):
在增长方面，你有增长模型、指标、实验、渠道等等。但你每天也需要创造力，去构思有趣的解决方案或假设来测试。音乐也是如此。你有音阶等音乐理论，但要创造优美的音乐，你需要激情、情感和心流（Flow）。所以我认为这是两者之间美妙的结合。

---

### [00:09:09] [Lenny Rachitsky]

**English:**
Fun fact, my wife bought me piano/singing lessons for Father's Day recently, and I've gotten really into this stuff. So I'm learning how to play very basic piano now and learning to identify notes and hit notes with my voice.

**中文翻译:**
有趣的是，我妻子最近在父亲节给我买了钢琴/声乐课，我真的很投入。我现在正在学习弹奏非常基础的钢琴，并学习识别音符以及用嗓音准确定位音符。

---

### [00:09:24] [Albert Cheng]

**English:**
Nice.

**中文翻译:**
太棒了。

---

### [00:09:25] [Lenny Rachitsky]

**English:**
What a weird new thing.

**中文翻译:**
真是个奇妙的新体验。

---

### [00:09:25] [Albert Cheng]

**English:**
Could be your next act.

**中文翻译:**
这可能是你的下一份事业。

---

### [00:09:26] [Lenny Rachitsky]

**English:**
It could be. I could go the reverse, I could become a professional piano player. Oh man. No, it's so fun, so hard though. I'm just like, my fingers are like, how do you do four freaking keys at once? I'm just like "What is going on here?" Okay, so let's get into the meat of it. I want to talk about growth.
(00:09:42):
There's a very specific framework that as we were chatting that I think would be really helpful for people to hear and learn from you. You call it explore and exploit. I think there's a bunch of different ways to think about this. Talk about this framework and how that informs the way you think about growth.

**中文翻译:**
有可能。我可以反过来走，成为一名职业钢琴家。天哪。不，这很有趣，但也太难了。我的手指就像在说：“你怎么能同时按四个键？”我心想：“这到底是怎么回事？”好了，让我们进入正题。我想谈谈增长。
(00:09:42):
我们在聊天时提到一个非常具体的框架，我认为让大家听听并向你学习会非常有帮助。你称之为“探索与利用”（Explore and Exploit）。关于这一点有很多不同的思考方式。请谈谈这个框架，以及它是如何影响你对增长的思考的。

---

### [00:09:56] [Albert Cheng]

**English:**
Yeah, I initially came up or heard with, heard about explore and exploit through my engineering partner at Grammarly, Nermal, and I think he actually had taken some reforged classes. So maybe the original inventor of it might be Brian Balfour, who I know has been on your pod. But anyway, it's a great concept.
(00:10:13):
The gist of it is that when you're in exploratory mode, think of it as finding the right mountain to climb. And then when you're in exploitation mode, it's like focusing your resources on climbing that mountain effectively. And certain companies, I think the warning is to basically spend too much of your time on one end of the spectrum. If you do too much exploration, you can have your team feel a little bit too scattershot, just trying a hundred different random ideas.
(00:10:40):
What's the through line? What's the strategy? How do you pattern match successes across them? And if you do too much in exploitation, which is often the MO of growth teams, it can lead to this saturation and stagnation where you're just locally maximizing a thing. And even though this principle of explore and exploit, it's typically thought of as a macro thing. I like to work with my teams more on the insight level. So I'll give you a concrete example.
(00:11:07):
So I work at chess.com and one of our priorities is to encourage chess players to improve, to learn and improve. So one of the PMs that we have, Dylan, he works on all the learning features. The most used learning feature in our product is called game review. So you play a game of chess, after the game is over, we have this virtual coach that teaches you about your worst moves, best moves, et cetera. And his job is to improve user engagement and retention.
(00:11:34):
And so he's in this exploratory phase trying to figure out how do I drive more of that type of activity? And what he observes is that 80% of people that review their games actually do so after a win. And that's really counterintuitive to when we initially built the feature. We thought that people would want to use it after losses or to see their mistakes such them could work on their mistakes. That turned out not to be the truth when it came to the human psychology and the actual data of it. And so we made some changes in the product experience.
(00:12:04):
When you lose a game now as opposed to surfacing your blunders and your horrible stuff that you did, we flip it on its head and so we show you your brilliant moves, your best moves, and we have coach say something encouraging, "Losing, just part of learning, keep it up." That type of thing. That change alone was pretty dramatic for us.
(00:12:22):
It grew game reviews by 25%, subscriptions by 20%, user retention by a lot as well. So that was fantastic, but the point is that it doesn't just stop there. You have to take that insight, share it broadly across the company. Now, adjacent product managers like the PM working on puzzles can now think about, "Okay, how do I audit these cold patterns in my product and think about making them more positive?"
(00:12:48):
I can change the success rating, I could tweak some copy, change the color of some buttons, and so you now can take this experiment win and expand it out 10X across your organization and that's the kind of exploitation phase of it. So when done right, you can oscillate between the two until you saturate out of exploitation mode and then you encourage the teams to brainstorm and get more creative again.

**中文翻译:**
是的，我最初是从我在 Grammarly 的工程合伙人 Nermal 那里听到“探索与利用”这个概念的，我想他可能上过 Reforge 的课程。所以最初的发明者可能是 Brian Balfour，我知道他上过你的播客。总之，这是一个很棒的概念。
(00:10:13):
其核心是：当你处于“探索”模式时，可以把它看作是寻找正确的那座山去攀登。而当你处于“利用”模式时，就像是集中资源有效地攀登那座山。对于某些公司，我认为警告是不要在光谱的任何一端花费过多时间。如果你做太多的探索，你的团队会感到太分散，只是在尝试一百个不同的随机想法。
(00:10:40):
主线是什么？策略是什么？你如何跨想法进行成功模式的匹配？如果你在“利用”上做得太多（这通常是增长团队的运作模式），可能会导致饱和和停滞，你只是在局部最大化某件事。尽管“探索与利用”原则通常被视为宏观层面的东西，但我更喜欢和我的团队在“洞察”层面进行探讨。我给你举个具体的例子。
(00:11:07):
我在 Chess.com 工作，我们的重点之一是鼓励棋手进步，去学习和提高。我们的一位产品经理 Dylan 负责所有的学习功能。我们产品中最常用的学习功能叫做“对局回顾”（Game Review）。你下完一盘棋后，会有一个虚拟教练教你哪些是臭棋，哪些是妙手等等。他的工作是提高用户参与度和留存率。
(00:11:34):
他处于探索阶段，试图弄清楚如何推动更多此类活动。他观察到，80% 回顾对局的人实际上是在赢球后才这么做的。这与我们最初构建该功能时的直觉完全相反。我们以为人们会想在输球后使用它，查看错误以便改进。但从人类心理和实际数据来看，事实并非如此。于是我们改变了产品体验。
(00:12:04):
现在当你输掉比赛时，我们不再只展示你的失误和你做的糟糕决定，而是反其道而行之——我们向你展示你的“妙手”和最佳走法，教练会说一些鼓励的话，比如“输棋只是学习的一部分，继续加油”。仅这一项改变对我们来说就非常显著。
(00:12:22):
它让对局回顾增长了 25%，订阅增长了 20%，用户留存也大幅提升。这太棒了，但重点是它并没有止步于此。你必须提取这个洞察，在全公司范围内广泛分享。现在，相邻的产品经理（比如负责谜题 PM）可以思考：“好吧，我如何审计产品中的这些冷冰冰的模式，并思考如何让它们变得更积极？”
(00:12:48):
我可以更改成功评级，调整文案，改变按钮颜色。现在你可以把这个实验的胜利在整个组织中放大 10 倍，这就是“利用”阶段。如果做得好，你可以在两者之间来回切换，直到“利用”模式饱和，然后你再鼓励团队进行头脑风暴，重新变得更有创意。

---

### [00:13:11] [Lenny Rachitsky]

**English:**
Amazing. Okay, so there's a lot here to follow up on. One is the core piece of advice when you find something that works really well, find ways to build on that learning. One is here's an insight, it can apply to other parts of the product. "Hey teams, here's something we learned unexpected. Maybe this can help you. Also, just keep find more, run more experiments in the same zone." I imagine is a part of that.

**中文翻译:**
太棒了。这里有很多值得跟进的地方。其中一个核心建议是，当你发现某些非常有效的方法时，要找到基于该学习成果继续构建的方法。一是分享洞察，它可以应用于产品的其他部分。“嘿，团队，这是我们学到的意外收获，也许能帮到你们。”另外，就是在同一领域继续寻找更多机会，运行更多实验。我猜这也是其中的一部分。

---

### [00:13:34] [Albert Cheng]

**English:**
Yeah, exactly right. In my experience, the typical win rate, and I hate to use that term for experiments, is often something like 30 to 50%. Usually you're trying a bunch of things, a lot of hypotheses turn out not to be true, consumer products are very unpredictable like that, but when you do find a thing that breaks through the noise, and it could actually be a hugely losing experiment too, those are also super valuable.
(00:13:58):
Surfacing those across the company, the original PM running that experiment doesn't necessarily need to be the person that figures out what you should do for all the other parts of your product experience, but the onus is on them to clearly articulate what their hypothesis is, what they found such that then as a growth leader, I can encourage people to swarm around that and try a bunch of different ideas such that the success rate is up and the impact is up. So it's just oscillating back and forth between the two. That is the magic bullet.

**中文翻译:**
没错。根据我的经验，典型的胜率（我讨厌在实验中使用这个词）通常在 30% 到 50% 左右。通常你会尝试很多事情，很多假设最终被证明是错误的，消费级产品就是这么不可预测。但当你真的发现了一个能突破噪音的东西——它甚至可能是一个惨败的实验，那也超级有价值。
(00:13:58):
在全公司范围内展示这些结果，运行该实验的原 PM 不一定非得是那个想出产品其他部分该怎么做的人，但他们有责任清晰地阐述他们的假设是什么，他们发现了什么。这样作为增长领导者，我就可以鼓励大家围绕这一点展开行动，尝试各种不同的想法，从而提高成功率和影响力。所以就是在两者之间来回切换。这就是“银弹”。

---

### [00:14:30] [Lenny Rachitsky]

**English:**
I think another takeaway here/something that I think about when I hear what you're saying is there's often a lot more wins in an area than people expect that you can continue to find wins and growth in something for a long time.

**中文翻译:**
我认为这里的另一个启发是，一个领域内往往存在比人们预期更多的增长点，你可以在很长一段时间内持续在某件事上发现胜利和增长。

---

### [00:15:19] [Albert Cheng]

**English:**
Exactly right. Yes. At the end of the day, users, I think within a company sometimes you can have this siloed approach where you break apart the product experience in 50 different ways and distribute them across different teams, and you assume that users interact with each of the different features with a different mentality, but oftentimes that's actually not necessarily the case. And so sometimes, you can surface an insight that's more human psychology based that can resonate across the entire product experience. And so I think when you can find that, you can double down.

**中文翻译:**
完全正确。是的。归根结底，我认为在公司内部，有时你会采用这种“孤岛式”的方法，将产品体验拆分成 50 个不同的部分并分配给不同的团队，你假设用户以不同的心态与每个不同的功能互动，但事实往往并非如此。所以有时，你可以挖掘出一个更基于人类心理的洞察，它能在整个产品体验中产生共鸣。当你找到这种洞察时，你就可以加倍投入。

---

### [00:15:19] [Lenny Rachitsky]

**English:**
People hearing this might feel like, "Okay, yes, find big wins and then find more." Is there something you find that helps you figure out when to explore versus when to exploit when you've exploited too far? Just like any heuristics or I don't know, ways of helping people guide them along this process of exploring and exploiting?

**中文翻译:**
听到这些的人可能会觉得：“好吧，找到大赢点，然后找更多。”有没有什么方法能帮你判断何时该探索，何时该利用，或者何时你已经“利用”过度了？有没有什么启发式方法，或者能引导人们完成这个探索与利用过程的方法？

---

### [00:15:41] [Albert Cheng]

**English:**
One thing that I try to focus on at a company of our scale of a chess.com, right? We're running roughly 250 experiments a year. So we're not the highest in the industry, but we run a decent volume. And so when that happens, I invest in these experiment explorer tools and we can talk about AI as well as another way to uncover and pick out these nuggets of wisdom, but basically, these explorer tools can allow me to look across the spectrum of experiments that are going on.
(00:16:08):
Try to figure out if there are patterns between the hypotheses and the learnings that are happening. And if I'm starting to see more and more experiments that are not statistically significant, that may be a signal to me to say, "Okay, we might've tried to exploit a little bit too far. There might not be as much juice to squeeze. Hey guys, let's get back to the table and brainstorm and be a little bit more divergent with our thinking."

**中文翻译:**
在像 Chess.com 这样规模的公司，我尝试关注的一件事是：我们每年运行大约 250 个实验。虽然不是行业最高，但数量也不少。因此，我会投资于这些“实验探索工具”（Experiment Explorer Tools），我们也可以谈谈 AI 作为发现和挑选这些智慧结晶的另一种方式。基本上，这些探索工具可以让我查看正在进行的所有实验。
(00:16:08):
尝试弄清楚假设和正在发生的学习之间是否存在模式。如果我开始看到越来越多不具备统计显著性（Statistically Significant）的实验，这可能是在向我发出信号：“好吧，我们可能‘利用’得有点过头了，已经榨不出多少汁水了。嘿，伙计们，让我们回到桌前进行头脑风暴，让思维更发散一些。”

---

### [00:16:34] [Lenny Rachitsky]

**English:**
Well, let me follow this thread on AI and how you're using AI to help you figure this out. That is very cool. Talk about that.

**中文翻译:**
那让我顺着 AI 这个话题聊聊，看看你是如何利用 AI 来帮你弄清楚这些的。这非常酷。请讲讲。

---

### [00:16:40] [Albert Cheng]

**English:**
I think one of the latest things that we've been tinkering around with is this text to SQL capability. It's actually pretty powerful. We have this data request Slack channel where for the longest time, and this is still true today, people will toss in all sorts of just one-off questions. How many subscribers do we have in South Africa? Or how long did somebody play puzzles last month or something?
(00:17:07):
And these ad hoc questions, they often take a lot of human time to just go in and a data analyst needs to prioritize it and find time to go run the query. And yes, you can invest in self-serve tooling to improve at this, but also I found that AI is quite good at doing that first pass answer as well. And so we're working on training some of these Slack bots to essentially be the first party provider of a lot of these answers, which makes the company as a whole lot more data informed, I guess.
(00:17:39):
And I think what's also kind of interesting is that just human nature is that if you have a question that you feel like you might be a bit embarrassed to ask or you don't want to bother someone, you just don't ask the question. And so by the nature of having these tools, you get actually a pretty large explosion of questions being asked. And I think you see this in ChatGPT too, right? It's like just having a thing that you can converse with that you feel comfortable in makes a huge difference.

**中文翻译:**
我想我们最近一直在琢磨的一件事就是这种“文本转 SQL”（Text to SQL）的能力。它其实非常强大。我们有一个数据请求的 Slack 频道，长期以来（直到今天也是如此），人们会抛出各种一次性的问题。比如：我们在南非有多少订阅者？或者上个月某人玩谜题玩了多久？
(00:17:07):
这些即时（Ad hoc）问题通常需要耗费大量人力，数据分析师需要排优先级并找时间运行查询。是的，你可以投资于自助服务工具来改善这一点，但我发现 AI 在提供初步答案方面也非常出色。所以我们正在训练一些 Slack 机器人，让它们基本上成为许多此类答案的第一提供者，这让整个公司变得更加数据驱动。
(00:17:39):
我觉得有趣的一点是，人类的天性是：如果你有一个觉得问出来会尴尬或者不想麻烦别人的问题，你干脆就不问了。而有了这些工具，提问的数量实际上会出现爆炸式增长。我想你在 ChatGPT 中也能看到这一点，对吧？拥有一个可以交流且让你感到舒适的东西，会产生巨大的差异。

---

### [00:18:03] [Lenny Rachitsky]

**English:**
Okay, this is extremely cool. So is this something you build basically it's a Slack bot that gives you the SQL query or does it actually do the analysis for you?

**中文翻译:**
这太酷了。所以这是你们开发的吗？基本上是一个给你 SQL 查询语句的 Slack 机器人，还是它真的为你做分析？

---

### [00:18:12] [Albert Cheng]

**English:**
No, it does the analysis. Yeah.

**中文翻译:**
不，它直接做分析。是的。

---

### [00:18:13] [Lenny Rachitsky]

**English:**
Whoa, so cool. Okay. Is this something you guys are going to release or is this just like somebody, you guys should just build this at every company?

**中文翻译:**
哇，太酷了。这是你们打算发布的东西吗？还是说每家公司都应该自己造一个？

---

### [00:18:20] [Albert Cheng]

**English:**
We should. It's a good idea.

**中文翻译:**
我们应该发布。这是个好主意。

---

### [00:18:21] [Lenny Rachitsky]

**English:**
Okay. Okay. Well, there's an episode where everyone in the comments is like, "Open source this." So we'll see if that happens again. That is very cool. Are there other examples of that kind of stuff that you've done or seen?

**中文翻译:**
好吧，以前有一集播客，评论区全是“开源这个吧”。看看这次会不会再次发生。这非常酷。还有其他你做过或见过的类似例子吗？

---

### [00:18:32] [Albert Cheng]

**English:**
An adjacent example is a lot of the product managers, we're tinkering around with all sorts of different prototyping tools right now. It's just like go from an idea to a representative solution. Today, there's a lot of humans involved in taking an idea, writing up a spec, doing a review, doing design, et cetera. I'm sure you've interviewed plenty of people that have talked about this specific problem.
(00:18:52):
And so for us, we've invested a bit in at least carving out the main screens of our product experience, things like our onboarding flow, our home screen, our chessboard as an example, and building essentially AI prototypes of those using tools like a V0 or a Lovable. And when you have those foundational pieces, you can then share them with the rest of the company and they can use that as a starting point and then they can try to put their ideas on top of that and then they become a lot more discussable and hopefully testable relatively soon.

**中文翻译:**
另一个相关的例子是，很多产品经理现在正在琢磨各种不同的原型设计工具。就是如何从一个想法变成一个具象的解决方案。目前，从想法到写文档、评审、设计等过程需要大量人力。我相信你采访过很多人都谈到过这个具体问题。
(00:18:52):
所以对我们来说，我们投入了一些精力，至少勾勒出了产品体验的主要屏幕，比如我们的新手引导流程、主屏幕、棋盘等等，并使用 V0 或 Lovable 之类的工具构建这些部分的 AI 原型。当你有了这些基础组件，你就可以把它们分享给公司的其他人，他们可以以此为起点，尝试把自己的想法加在上面，这样想法就变得更具讨论性，并且有望很快变得可测试。

---

### [00:19:25] [Lenny Rachitsky]

**English:**
What's in your AI stack along those lines?

**中文翻译:**
你们的 AI 工具栈（Stack）里都有什么？

---

### [00:19:27] [Albert Cheng]

**English:**
The PMs are mostly using V0. The designers love Figmas, they're using Figma Make. The engineers are using a combination of tools right now. So Cursor, Cloud Code, GitHub, Copilot. Marketing teams use all sorts of tools for translation, subtitles, content adaptations, et cetera. Customers support uses Intercom then. So there's quite a lot of tools that are used across the company.
(00:19:50):
I would say though that something that is annoying to me is that we haven't yet figured out the bridging from the tinkering to the workflow quite as seamlessly as I would like. And so each sub-function, even though the common I guess wisdom now is that AI is going to strip away these functional titles. It is true that based on your experience, you may gravitate to using a type of tool more. And if that tool isn't as interoperable with some of the other tools that you need to pass down the chain to actually ship it into production, at least at our scale.
(00:20:24):
I think for smaller startups, sure, PMs should just go ship it, but for us, we are still doing some handoffs between functions. I expect that to change over time and we are investing in some of design system components and MCPs and stuff to make it a little bit easier. But yeah, it's an investment and it takes time to smooth things out.

**中文翻译:**
产品经理主要使用 V0。设计师喜欢 Figma，他们在使用 Figma Make。工程师目前使用多种工具的组合，比如 Cursor、Cloud Code、GitHub Copilot。营销团队使用各种工具进行翻译、字幕制作、内容适配等。客户支持则使用 Intercom。所以全公司使用的工具非常多。
(00:19:50):
不过，让我感到困扰的是，我们还没有像我希望的那样，无缝地实现从“琢磨”到“实际工作流”的衔接。每个子职能部门，尽管现在的普遍看法是 AI 将消除这些职能头衔，但事实是，根据你的经验，你可能会更倾向于使用某种类型的工具。如果该工具与链条下游实际将其投入生产所需的其他工具不具备互操作性，至少在我们这种规模的公司是这样。
(00:20:24):
我认为对于较小的初创公司，当然，PM 应该直接去发布产品，但对于我们来说，职能之间仍然存在一些交接。我预计这会随着时间而改变，我们正在投资一些设计系统组件和 MCP（模型上下文协议）等，让这一切变得更容易。但没错，这是一项投资，需要时间来磨合。

---

### [00:20:42] [Lenny Rachitsky]

**English:**
I want to come back to this topic of how things have changed and how you work as a product person, as a growth person across the companies you've been at. But first of all, I want to talk about another example of finding growth wins and monetization wins. Noam Levinsky, who is Chief Product Officer at Grammarly, you worked with him for a while while you were at Grammarly. He said that I need to ask you about the biggest monetization win that you found at Grammarly and how you discovered the opportunity.

**中文翻译:**
我想回到这个话题：作为一名产品人、一名增长人，在你待过的这些公司里，情况发生了怎样的变化。但首先，我想谈谈另一个寻找增长和变现突破的例子。Noam Levinsky 是 Grammarly 的首席产品官，你在 Grammarly 时曾与他共事。他说我一定要问问你在 Grammarly 发现的最大变现突破，以及你是如何发现这个机会的。

---

### [00:21:10] [Albert Cheng]

**English:**
I had the pleasure of working with Noam and his product team at Grammarly. Some context first for those that don't use Grammarly. So Grammarly is an AI-powered writing assistant. And so typically, people will use it as a Chrome extension or a downloadable desktop client. And basically what it does is it overlays your writing with a bunch of different-

**中文翻译:**
我很荣幸曾与 Noam 及其在 Grammarly 的产品团队共事。首先为那些不使用 Grammarly 的人提供一些背景。Grammarly 是一款 AI 驱动的写作助手。通常，人们会将其作为 Chrome 扩展程序或可下载的桌面客户端使用。基本上，它的作用是在你的写作内容上覆盖一系列不同的——

---

### [00:21:28] [Lenny Rachitsky]

**English:**
I use it. I'm a big fan. I use it-

**中文翻译:**
我在用。我是它的忠实粉丝。我用它——

---

### [00:21:30] [Albert Cheng]

**English:**
Correction, so you're a big fan.

**中文翻译:**
纠正一下，你是忠实粉丝。

---

### [00:21:30] [Lenny Rachitsky]

**English:**
... And it saves my life.

**中文翻译:**
……它救了我的命。

---

### [00:21:32] [Albert Cheng]

**English:**
Fantastic. Glad to hear that. Grammarly is a freemium business model, which means that over 90% of our users are on the free service and the rest of it pay for subscriptions essentially, right? And so one of the teams, they work on subscriber conversion, PM there is Kayla, that team is great and their job is to figure out the free to paid subscription path.
(00:21:54):
And so one of the realizations, one, is that we weren't actually tracking the events that well for the types of essentially suggestions that people were getting and how often were users seeing paywalls and stuff like that. That's kind of step number one. We have to put that instrumentation in. Step number two is that, "Hey, we noticed, actually first let me explain some of the logic."
(00:22:18):
So as a free user, you basically get these underlines across your writing and if you accept all of them, then you see the paywall and that encourages you to subscribe for more nuanced features. As a free user, the main things you get are spelling, grammar, they're basically correctness things. And as a paid user you get that, how do you improve your tone to be more empathetic? How do you improve your writing to be more clear?
(00:22:40):
How can you rewrite entire sentences, that type of thing. And so the observed behavior from all that tracking and data was that actually a very small percentage of our free users was deciding to accept all of their suggestions. They were more picking and choosing as they go, and I wonder if your experience is kind of similar too.

**中文翻译:**
太棒了，很高兴听到这个。Grammarly 采用的是免费增值（Freemium）商业模式，这意味着超过 90% 的用户使用免费服务，其余用户支付订阅费用。其中一个团队负责订阅转化，那里的 PM 是 Kayla，那个团队很棒，他们的工作是弄清楚从免费到付费订阅的路径。
(00:21:54):
我们意识到的第一点是，我们实际上并没有很好地跟踪用户获得的建议类型，以及用户看到付费墙（Paywall）的频率等事件。这是第一步，我们必须加入埋点。第二步是，我们注意到——实际上，让我先解释一下逻辑。
(00:22:18):
作为免费用户，你的写作内容中会出现下划线，如果你接受了所有建议，就会看到付费墙，鼓励你订阅以获得更细致的功能。作为免费用户，你主要获得的是拼写、语法等纠错功能。作为付费用户，你会获得如何让语气更具同理心、如何让写作更清晰、如何重写整个句子等功能。
(00:22:40):
通过所有的跟踪和数据观察到的行为是，实际上只有很小比例的免费用户会选择接受所有建议。他们更多是在写作过程中挑挑拣拣。我想知道你的体验是否也类似。

---

### [00:22:59] [Lenny Rachitsky]

**English:**
Definitely, yeah. I'm always like, "Wait, stop rewriting everything." Just like this part is wrong. I will fix it. Yeah, I'm very much a pick and choose.

**中文翻译:**
绝对是这样。我总是会想：“等一下，别重写所有内容。”只是这部分错了，我会修复它。是的，我非常属于那种“挑挑拣拣”的人。

---

### [00:23:07] [Albert Cheng]

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:23:07] [Lenny Rachitsky]

**English:**
Correction person.

**中文翻译:**
纠错型人格。

---

### [00:23:08] [Albert Cheng]

**English:**
And then the second thing, which is I think equally if not more interesting is that I was at this company during this generative AI transformation, which is obviously still going on. And quite frankly, both the company brand as well as the lived product experience for most of the free users was that Grammarly was just a product to fix your spelling and grammar because those were the free suggestions we were showing people.
(00:23:34):
And so we decided to flip that on its head entirely and we said, "Okay, what if we actually sampled a number of different paid suggestions and interspersed them to free users across their writing?" Such that they were intermingled and we would provide a limited taste of what the paid offering had to provide. And on the surface, even though it's rational, the concern is that if we give too much of this away, then will people want to subscribe?
(00:23:58):
And we found completely that was not the case all of a sudden, people were seeing Grammarly as a much more powerful tool than they were before and our upgrade rates nearly doubled just through this change. And so I think this is interesting, just modernization learning that especially if you work on a freemium product, try to have your free product be a reflection of everything that your product can offer you. Obviously to an extent there's some costs involved with some of the paid features and things like that, but it generally will pay for itself if you're able to put your best foot forward and go do that. So that really worked well for us there.

**中文翻译:**
没错。然后第二点，我认为同样有趣甚至更有趣的是，我在这家公司经历了生成式 AI 的转型（目前仍在继续）。坦率地说，无论是公司品牌还是大多数免费用户的实际产品体验，都认为 Grammarly 只是一个纠正拼写和语法的工具，因为那是我们向人们展示的免费建议。
(00:23:34):
于是我们决定彻底改变这种做法。我们说：“好吧，如果我们抽取一些付费建议，并将它们穿插在免费用户的写作过程中会怎样？”让它们混在一起，提供付费功能的有限体验。表面上看，虽然这很合理，但担心的是：如果我们给得太多，人们还会想订阅吗？
(00:23:58):
我们发现情况完全不是那样。突然之间，人们发现 Grammarly 比以前强大得多，仅通过这一改变，我们的升级率几乎翻了一番。我认为这是一个有趣的变现学习：特别是如果你开发免费增值产品，尝试让你的免费产品反映出你产品所能提供的一切。显然，某些付费功能会涉及成本，但如果你能展示出最好的一面，通常这笔投入是值得的。这在当时对我们非常有效。

---

### [00:24:36] [Lenny Rachitsky]

**English:**
I think this is what converted me to being a paid Grammarly subscriber. Wow, what a genius move. So essentially, it's here's a bunch of improvements, but you get three, I think max, and then it's like, "Okay, now you get upgrade."

**中文翻译:**
我想这就是让我转化为 Grammarly 付费订阅用户的原因。哇，真是天才之举。所以本质上是：这里有一堆改进建议，但你最多只能用三个，然后它会提示：“好了，现在你需要升级了。”

---

### [00:24:51] [Albert Cheng]

**English:**
It's basically a reverse free trial but in real time while you're writing as opposed to a time-based one. So we adopted some patterns that are in the industry, but molded it to Grammarly's specific use case.

**中文翻译:**
这基本上是一种“反向免费试用”（Reverse Free Trial），但是是在你写作时实时进行的，而不是基于时间的试用。我们采用了行业内的一些模式，但将其塑造成了适合 Grammarly 具体用例的形式。

---

### [00:25:04] [Lenny Rachitsky]

**English:**
Right. I was going to ask, so it's not like a full trial, it's like a capped trial where you get a certain number of things and then you run out and then they get refreshed. I think once a day or something like that is what I found.

**中文翻译:**
没错。我正想问，所以它不像完整的试用，而是一个有上限的试用，你可以获得一定数量的功能，然后用完，之后会刷新。我发现好像是每天刷新一次。

---

### [00:25:16] [Albert Cheng]

**English:**
Yeah, you got it.

**中文翻译:**
是的，你猜对了。

---

### [00:25:18] [Lenny Rachitsky]

**English:**
Yeah. Grammarly is the best/most devious at their upsells. I'm always just like, "God damn it, I'm so close to seeing an improvement, I just have to upgrade." And it's right there, it's right there where my mouse is.

**中文翻译:**
是的。Grammarly 在追加销售（Upsell）方面是最棒也是最“狡猾”的。我总是会想：“该死，我离看到改进就差那么一点点，我必须升级。”它就在那儿，就在我鼠标指的地方。

---

### [00:25:32] [Albert Cheng]

**English:**
Yeah, well, I'm not proud of being devious, but.

**中文翻译:**
好吧，我并不以“狡猾”为荣，但是……

---

### [00:25:33] [Lenny Rachitsky]

**English:**
In really getting me to buy the thing. Good job. What was it? Kayla? Okay, nice job Kayla. It's very effective. I love that. Okay, so in terms of the free trial, I don't know, is there anything there of just, there's always this question of freemium, give things away and then there's pro account, there's like trial versus time. Some features are limited. I don't know, do you have for consumer subscription products like here's the way to go?

**中文翻译:**
……在让我买单方面确实做得好。是谁做的？Kayla？干得好，Kayla。这非常有效。我喜欢。关于免费试用，总会有这样的问题：免费增值、赠送功能、专业账户、试用期 vs 试用次数、功能限制。对于消费级订阅产品，你有没有一种“这就是正确道路”的见解？

---

### [00:26:00] [Albert Cheng]

**English:**
Yeah, I think first of all, why do freemium subscription in the first place is a common question that I've joined all these companies that are freemium subscription. What do I like about it I guess? Well one, I think it ties really nicely to mission orientation of a lot of these companies. It's often like you want to spread the product as wide as possible because that's why the founders built the thing, right?
(00:26:22):
You're trying to improve education with Duolingo or Grammarly or Chess.com, these are meant to be widespread products with a really wide value proposition that fits globally. And so obviously, the lowest friction to that is going to be a free product. So that alone is part of it. Another part of it is that a lot of these products primarily grow through word of mouth and especially if you can build network effects in the product, like Duolingo has a bunch of social features or with Grammarly, they have a bit of a B2C2B play as well.
(00:26:54):
So you see Grammarly being used by teams and by companies and whatnot, and even if users are on the free plan, they still provide quite a lot of value in making sure that Grammarly can be purchased by a coworker or by a team member or whatever. So I think these things are usually why I lean toward make sure that the core value proposition that you're providing users is free and is permanently free and then you layer on a sampling or a taste of some of the premium features that are on top of it. That's usually the sweet spot that I've seen.
(00:27:26):
As to the trials, reverse trials type of thing, I think it largely depends. I think if you have especially a B2B feature where you may have some lock-in, reverse trials can be super powerful. You just want to get people in there. You don't need to ask for their credit card because they're using your CRM or they're investing quite a lot of time in building out material and content. And so by the time that window drops, you actually feel, "Oh man, I probably should keep this and start paying." I think for a lot of consumer products it's a little bit harder for that to work. And so I've typically seen more just normal free trials be the norm.

**中文翻译:**
是的，首先，为什么要采用免费增值订阅模式？这是一个常见的问题，我加入的所有公司都是这种模式。我喜欢它什么呢？第一，我认为它与很多公司的使命导向契合得很好。通常是因为你想尽可能广泛地传播产品，这也是创始人构建它的初衷，对吧？
(00:26:22):
无论是 Duolingo、Grammarly 还是 Chess.com，你都在尝试改善教育或技能，这些产品旨在拥有广泛的价值主张并适配全球。显然，实现这一目标阻力最小的方式就是提供免费产品。仅这一点就是原因之一。另一个原因是，很多这类产品主要通过口碑增长，特别是如果你能在产品中构建网络效应，比如 Duolingo 有很多社交功能，或者 Grammarly 有一点 B2C2B 的玩法。
(00:26:54):
你会看到团队和公司在使用 Grammarly。即使某些用户使用的是免费计划，他们仍然提供了巨大的价值，确保 Grammarly 能够被同事或团队成员购买。所以我通常倾向于确保你提供给用户的核心价值主张是免费的，并且是永久免费的，然后在此基础上增加一些高级功能的采样或体验。这是我见过的最佳平衡点。
(00:27:26):
至于试用和反向试用，我认为很大程度上取决于情况。如果你有一个特别是 B2B 的功能，可能会产生锁定效应（Lock-in），那么反向试用会非常强大。你只想让人们进来使用。你不需要要他们的信用卡，因为他们正在使用你的 CRM，或者投入了大量时间构建材料和内容。当试用窗口关闭时，你会觉得：“噢，天哪，我可能应该保留这个并开始付费。”我认为对于很多消费级产品来说，这很难奏效。所以我通常看到正常的免费试用才是常态。

---

### [00:28:03] [Lenny Rachitsky]

**English:**
Let me follow this thread of just consumer subscription products. I feel like this is the category that every indie developer dreams of building a product in because it's easy to build. Cool, I'll build an app, I add a paywall, and then they realize this is a lot harder than I thought. From a perspective of distribution and CAx and growth like that, is that the biggest missing piece that people don't get about building a successful consumer subscription product?

**中文翻译:**
让我顺着消费级订阅产品这个话题聊下去。我觉得这是每个独立开发者梦寐以求的领域，因为开发起来相对容易。太酷了，我开发个 App，加个付费墙，然后他们才发现这比想象中难得多。从分发、获客成本（CAC）和增长的角度来看，这是不是人们在构建成功的消费级订阅产品时最容易忽略的关键点？

---

### [00:28:31] [Albert Cheng]

**English:**
Yeah, user retention is gold for consumer subscription companies. If you don't retain your users, then a lot of the onus is on getting them to pay on day one, that's super hard. Then you're dealing with totally different business models where you're paying for users, you're trying to aggressively upsell them before they hit any habitual usage patterns with your product.
(00:28:53):
A lot of apps naturally do that because that's how they break the mold and get their first users to do it, but I don't know, I've been fortunate to join companies after that initial phase, but especially take Duolingo and Chess.com, these are organic word of mouth driven businesses and in both ways, they grew the market from a much smaller market and as opposed to it being a very competitive space where you're competing and taking market share from others and bidding for higher terms and stuff like that. So I don't know, there's something to that.

**中文翻译:**
是的，对于消费级订阅公司来说，用户留存就是金子。如果你留不住用户，那么所有的压力都会集中在如何让他们在第一天就付费上，这超级难。那样你就得处理完全不同的商业模式：你花钱买用户，尝试在他们养成任何习惯性使用模式之前激进地向他们追加销售。
(00:28:53):
很多 App 自然会这么做，因为那是他们打破僵局并获得首批用户的方式。但我很幸运能在初始阶段之后加入这些公司。特别是 Duolingo 和 Chess.com，这些都是有机的口碑驱动型业务。它们都是从一个很小的市场把蛋糕做大的，而不是在一个竞争极其激烈的空间里与他人争夺市场份额、竞标更高的条款等等。所以，这其中确实有些门道。

---

### [00:29:42] [Lenny Rachitsky]

**English:**
So what I'm hearing here is you need to find a way to grow through word of mouth for this to have any chance of success and also retention needs to be very high. Do you have a heuristic of what retention needs to be for you to have a chance building a successful consumer subscription business?

**中文翻译:**
所以我听到的是，你需要找到一种通过口碑增长的方法，这样才有成功的机会，而且留存率必须非常高。你有没有一个启发式指标，即留存率需要达到多少，才有机会建立一个成功的消费级订阅业务？

---

### [00:29:42] [Albert Cheng]

**English:**
I think consumer companies tend to track essentially two main types of user retention. There's more of the new user, one, D1, D7, et cetera. I think when you have your D one retention somewhere around the 30 or 40% mark, that's quite solid I think for a consumer app. If it's much lower than that, then sometimes I might question the intent of the user or the ability for that, you to I guess acquire just mathematically acquire enough users such that you can grow a big enough daily active user base.

**中文翻译:**
我认为消费级公司通常主要跟踪两种类型的用户留存。一种是新用户留存，比如次日留存（D1）、七日留存（D7）等。我认为当你的次日留存达到 30% 或 40% 左右时，对于消费级 App 来说是非常稳固的。如果远低于这个水平，有时我会质疑用户的意图，或者你是否能从数学上获取足够的用户，从而建立起足够大的日活跃用户（DAU）基础。

---

### [00:30:14] [Lenny Rachitsky]

**English:**
That is surprisingly low.

**中文翻译:**
这低得令人惊讶。

---

### [00:30:16] [Albert Cheng]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:30:17] [Lenny Rachitsky]

**English:**
So it feels achievable in theory.

**中文翻译:**
所以理论上感觉是可以实现的。

---

### [00:30:18] [Albert Cheng]

**English:**
It's achievable. It's achievable in theory, but there are so many options out there in the market and people are feeling a lot of app and product bloat.

**中文翻译:**
是可以实现的。理论上可以，但市场上有很多选择，人们正感到应用和产品过载。

---

### [00:30:26] [Lenny Rachitsky]

**English:**
And so just to be clear, you're saying 20 to 30% of people come back the next day?

**中文翻译:**
所以明确一下，你是说 20% 到 30% 的人第二天会回来？

---

### [00:30:30] [Albert Cheng]

**English:**
Yeah, 30 to 40.

**中文翻译:**
是 30% 到 40%。

---

### [00:30:30] [Lenny Rachitsky]

**English:**
30 to 40.

**中文翻译:**
30% 到 40%。

---

### [00:30:32] [Albert Cheng]

**English:**
40%. I think you're an okay place. I think even more importantly, and you mentioned Jorge to kick this off, but he wrote that very, very popular article about the growth model and how current user retention rate was the biggest thing for them. And I think especially if you have a product that has daily frequency, that's actually the retention that matters the most is that of your existing user base that has developed a habitual pattern, how sticky is your product? And it's that retention rate that really compounds and builds that daily habit.
(00:31:04):
So over time, especially when companies mature a little bit, you actually focus most of your energy on the existing user retention mechanics. You find that that's a much, much bigger lever. One exception is that Grammarly was a different type of product and that you install it and you don't proactively open it every day. So that was interesting to me because I assumed that you should always just focus on existing user retention, but for a product like Grammarly, it's actually the activation installation aha moment that's really, really critical and will carry the user for a very, very long time.

**中文翻译:**
40%。我认为这是一个不错的水平。更重要的是，正如你开头提到的 Jorge，他写过那篇非常受欢迎的关于增长模型的文章，提到“当前用户留存率”对他们来说是最重要的。我认为特别是如果你有一个日频产品，真正最重要的是已经养成习惯模式的现有用户群的留存——你的产品有多粘？正是这种留存率真正产生了复利并建立了日常习惯。
(00:31:04):
所以随着时间推移，特别是当公司成熟一点后，你实际上会将大部分精力放在现有用户留存机制上。你会发现这是一个大得多的杠杆。一个例外是 Grammarly，它是不同类型的产品，你安装了它，但不会每天主动打开它。这对我来说很有趣，因为我曾假设应该始终只关注现有用户留存，但对于像 Grammarly 这样的产品，实际上激活、安装和“Aha Moment”（惊喜时刻）才是至关重要的，它能让用户持续使用很长时间。

---

### [00:31:37] [Lenny Rachitsky]

**English:**
That makes sense. Yeah, the stats would show someone's a daily active user because they're typing things and that's not an accurate step for Grammarly. The other interesting trend I've noticed across successful consumer subscription products is they always start very scrappy and very cost-efficient and spend efficient because I think it's because it takes them a long time to find something that's working and they're surviving on that margin of retention to growth cost essentially.

**中文翻译:**
有道理。是的，统计数据会显示某人是日活用户，因为他们正在打字，但这对于 Grammarly 来说并不是一个准确的衡量标准。我在成功的消费级订阅产品中注意到的另一个有趣趋势是，它们起步时总是非常简陋、非常注重成本和支出效率。我认为这是因为它们需要很长时间才能找到行之有效的方法，它们基本上是靠留存率与增长成本之间的利润空间生存的。

---

### [00:31:37] [Albert Cheng]

**English:**
Yeah, that's right.

**中文翻译:**
是的，没错。

---

### [00:32:06] [Lenny Rachitsky]

**English:**
Yeah, and the retention piece, that's such a good point. My newsletter is very much along these lines. It's just like how many people are joining every day, how many people are leaving? And it's a difficult treadmill to be on because people, they want to save money, they want to spend on Netflix and things like that. So as amazing as you are, people are always going to leave. So the trick is how do you find more people coming than going?

**中文翻译:**
是的，留存这一点说得太好了。我的时事通讯也非常符合这一点。就是每天有多少人加入，有多少人离开。这是一个很难停下来的跑步机，因为人们想省钱，他们想把钱花在 Netflix 之类的事情上。所以无论你多么出色，总会有人离开。诀窍在于你如何让进来的人比离开的人多？

---

### [00:32:26] [Albert Cheng]

**English:**
Yeah, and I think just to take Chess.com example, I think probably 80% of our daily or weekly active users, I'll check the numbers, but something like that would be a current user or an existing user and then a new and a reactivated or resurrected user. Those are actually about similar size for a company of our sale. So even though there's a lot of attention on that new user experience, it's actually pretty interesting that the components of your active user base are actually not heavily weighed in the new user set after you mature to a certain degree.

**中文翻译:**
是的。以 Chess.com 为例，我想大概 80% 的日活或周活用户（我会再核实一下数字）是当前用户或现有用户，然后是新用户和重新激活或“复活”（Resurrected）的用户。对于我们这种规模的公司，这两部分的规模其实差不多。所以尽管大家对新用户体验关注很多，但有趣的是，当你成熟到一定程度后，活跃用户群的构成中，新用户的权重其实并不大。

---

### [00:33:00] [Lenny Rachitsky]

**English:**
Can you explain that a little bit more?

**中文翻译:**
你能再详细解释一下吗？

---

### [00:33:01] [Albert Cheng]

**English:**
Yes. So after some period of time, you stack up a lot of inactive users in your product and you also stack up sporadic users, people that may not have a daily habit, but they will use it once or twice a week or once or twice a month type of thing. And eventually that math adds up where you have, let's say hundreds of millions of dormant users that are coming back and it's actually worth spending some time making sure that that resurrected, for lack of a better word, experience inside the product is really excellent and that you find novel ways to try to bring them back.
(00:33:38):
Duolingo as an example, they did a good job of using social notifications. And so if people would use contact sync or something, you might get a push notification that one of your best friends just started using Duolingo and that might encourage you to come back and resurrect into the product. And whether you resurrected in the product, it might be the case that your proficiency of the language you were learning, you were learning French three years ago, but now you for forgot most of it. And so when you open the app again, it encourages you to essentially replace yourself, do another placement test and put you in the right spot. And so some of these types of mechanics for a more mature company can lead to pretty good ROI guess is what I'm trying to say.

**中文翻译:**
好的。经过一段时间后，你的产品中会积累大量不活跃用户，也会积累大量零星用户——那些没有养成日常习惯，但每周或每月使用一两次的人。最终，数学上的累积效应显现：比如你有数亿休眠用户正在回归。这时，花时间确保这种“复活”体验（找不到更好的词了）非常出色，并寻找新颖的方法带回他们，是非常值得的。
(00:33:38):
以 Duolingo 为例，他们在利用社交通知方面做得很好。如果人们使用通讯录同步，你可能会收到一条推送，说你最好的朋友之一刚开始使用 Duolingo，这可能会鼓励你回来并“复活”。当你回到产品中时，可能会发现你三年前学的法语已经忘得差不多了。所以当你再次打开 App 时，它会鼓励你重新定位，做一次水平测试并把你放在合适的位置。我想说的是，对于一家更成熟的公司，这类机制可以带来相当不错的投资回报率（ROI）。

---

### [00:34:19] [Lenny Rachitsky]

**English:**
Got it. Essentially, so many people have already tried in the past that to grow, you need to resurrect people that have been there. And so thinking through, it's almost like a user experience for resurrected users.

**中文翻译:**
明白了。本质上，过去已经有太多人尝试过你的产品，为了增长，你需要复活那些曾经的用户。所以要深入思考，这几乎就像是为复活用户专门设计的用户体验。

---

### [00:34:34] [Albert Cheng]

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:34:35] [Lenny Rachitsky]

**English:**
Okay. Let's zoom out a little bit. You've worked at three of the most successful consumer subscription products in the world. What is the difference between how these three operate? I think there's many ways to be successful. It feels like these companies are very different. What's the gist of each of these, how they operate?

**中文翻译:**
好的。让我们把视角放大一点。你曾在全球三款最成功的消费级订阅产品中工作过。这三家公司的运作方式有什么不同？我认为通往成功的道路有很多条。感觉这些公司非常不同。它们各自运作的核心是什么？

---

### [00:34:53] [Albert Cheng]

**English:**
Well, first of all, there's obviously a lot of similarities, but I'll just focus my answer on the differences. So I think Duolingo, what struck me most working there is they're very particular, they have an approach of product development that is infused across everyone in the company. And they actually wrote a playbook about this. It's called the Green Machine if you look it up. That was one of my most successful tweets ever really.

**中文翻译:**
首先，它们显然有很多相似之处，但我将重点回答不同点。在 Duolingo 工作最让我震撼的是，他们非常讲究，他们有一套贯穿全公司每个人的产品开发方法。他们还为此写了一本手册，如果你去查的话，叫《绿色机器》（The Green Machine）。那真是我最成功的推文之一。

---

### [00:35:15] [Lenny Rachitsky]

**English:**
I just tweeted something about Duolingo just released their playbook and I screenshotted the owl's butt and screened like a page and it was like 5,000 likes.

**中文翻译:**
我刚发了一条关于 Duolingo 发布手册的推文，我截了一张猫头鹰屁股的图和一页内容，获得了大约 5000 个赞。

---

### [00:35:26] [Albert Cheng]

**English:**
That's hilarious.

**中文翻译:**
太好笑了。

---

### [00:35:26] [Lenny Rachitsky]

**English:**
Yeah. So yeah, keep going. Sorry.

**中文翻译:**
是的。所以，请继续，抱歉打断。

---

### [00:35:29] [Albert Cheng]

**English:**
But yeah, the ethos of the company. They hire a lot of intelligent, energetic people out of college basically, and they give them a lot of amazing experimentation, tooling, and they care a lot about the clock speed of the company. So it's a lot of creativity, a lot of ideation.
(00:35:46):
The product experience of dual legal actually changes multiple times per day for each user, which is pretty shocking. And so I'd never worked in a place like that before, but it really struck me about how consistently the company operated and they had specs and processes for doing each of those steps in their product development cycle and they were really, really tight about it.

**中文翻译:**
是的，这就是公司的精神。他们基本上从大学招聘大量聪明、有活力的人，并给他们提供惊人的实验工具，他们非常在意公司的“时钟频率”（Clock Speed）。所以那里有很多创意和构思。
(00:35:46):
Duolingo 的产品体验实际上每天会为每个用户改变多次，这相当令人震惊。我以前从未在这样的地方工作过，但公司运作的一致性真的让我印象深刻。他们在产品开发周期的每一步都有规范和流程，而且执行得非常严密。

---

### [00:36:08] [Lenny Rachitsky]

**English:**
Okay, so that's still lingo.

**中文翻译:**
好的，那是多邻国。

---

### [00:36:09] [Albert Cheng]

**English:**
Yeah, that's still lingo. Grammarly. This is an interesting company because they started as a paid product oriented at students. Then they expanded into more of a freemium model tailored to everyone gradually focusing more on the professional base. And then as they accumulate a lot more professionals, they realize, "Hey, there's patterns." We're seeing that a bunch of marketing teams or a bunch of sales teams or a bunch of customer support teams or whatever, particular functions within particular companies were really adopting Grammarly at scale.
(00:36:41):
And so they were able to then layer on much more of a managed enterprisey motion. And while I was there, I was focused on the consumer self-serve motion, but they weren't siloed. They were intermixed with each other. And so a big part of my job was not just to grow the self-serve revenue and self-serve active users, but it was also how do you uncover the right teams, the right functions, the right companies for demand gen and sales to go reach out to?
(00:37:12):
So that was a very interesting, it's a product-led sales work, and it's really fascinating thing for me to learn. And then on top of that, with all the transformation going on with generative AI, and even recently with them acquiring CODA and Superhuman and becoming more of a productivity suite, the company is just evolving pretty rapidly. It's a really exciting thing for me to be a part of and to see from the sidelines, but that just made it at its core of a different growth job than Duolingo for sure.

**中文翻译:**
是的，那是多邻国。接下来是 Grammarly。这是一家很有趣的公司，因为他们最初是面向学生的付费产品。然后他们扩展到面向所有人的免费增值模式，并逐渐更多地关注专业人士群体。随着积累了更多专业人士，他们意识到：“嘿，这里有模式。”我们看到很多营销团队、销售团队或客户支持团队——即特定公司内的特定职能部门——正在大规模采用 Grammarly。
(00:36:41):
因此，他们能够在此基础上增加更多受控的企业级运作。我在那里时，主要负责消费级自助服务（Self-serve）运作，但各部门并不是孤立的，而是交织在一起。所以我工作的一大部分不仅是增长自助服务收入和活跃用户，还包括如何为需求生成（Demand Gen）和销售团队挖掘合适的团队、职能和公司，以便他们去联系。
(00:37:12):
所以这是一种非常有趣的“产品驱动销售”（Product-led Sales）工作，对我来说是非常迷人的学习经历。除此之外，随着生成式 AI 带来的转型，以及最近他们收购了 CODA 和 Superhuman 并向生产力套件演进，公司正在飞速发展。能参与其中并从旁观察是一件非常令人兴奋的事情，但这确实让它的核心增长工作与 Duolingo 完全不同。

---

### [00:37:40] [Lenny Rachitsky]

**English:**
Essentially a B2B business versus a very consumer business?

**中文翻译:**
本质上是 B2B 业务与纯消费级业务的区别？

---

### [00:37:43] [Albert Cheng]

**English:**
Yeah, and a lot more meaningful strategic decisions as well.

**中文翻译:**
是的，而且涉及更多有意义的战略决策。

---

### [00:37:44] [Lenny Rachitsky]

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### [00:37:47] [Albert Cheng]

**English:**
And then the core product team also, I'm used to in growth, laying out the entire user journey that a user go through acquisition, activation, engagement, so on and so forth. And typically, growth teams, if they're well-resourced, they can do enough to move each one of these various levers. And it's just a matter of the sequencing of them and what you want to prioritize first. But Grammarly was unique in that the core product experience itself was what drove repeated activity.
(00:38:18):
It's that I previously mentioned that current user retention thing, what most drives that is the frequency and the quality of the suggestions that you get every day. And so it was an interesting learning in that I staffed up a growth team, tried to work on this metric, and then I realized actually I'm just getting in the way. This is really a thing that the core product team most influences. Let me have a conversation with the core product leader and then shift that over to them. So yeah, just a super interesting experience.

**中文翻译:**
还有核心产品团队。在增长工作中，我习惯于规划用户经历的整个旅程：获取、激活、参与等等。通常，如果增长团队资源充足，他们可以做足够多的工作来触动每一个杠杆。这只是一个排序和优先级的问题。但 Grammarly 的独特之处在于，核心产品体验本身就是驱动重复活动的动力。
(00:38:18):
正如我之前提到的“当前用户留存”，驱动它的主要是你每天获得的建议的频率和质量。所以这是一个有趣的教训：我组建了一个增长团队，尝试优化这个指标，然后我意识到我其实是在碍事。这实际上是核心产品团队影响最大的事情。于是我与核心产品负责人进行了沟通，并将这部分工作移交给了他们。所以，这真是一次超级有趣的经历。

---

### [00:38:45] [Lenny Rachitsky]

**English:**
And then Chess.com.

**中文翻译:**
然后是 Chess.com。

---

### [00:38:47] [Albert Cheng]

**English:**
The thing that's most unique about chess.com is that they're super fanatical about chess.

**中文翻译:**
Chess.com 最独特的地方在于他们对国际象棋超级狂热。

---

### [00:38:54] [Lenny Rachitsky]

**English:**
Makes sense.

**中文翻译:**
这很合理。

---

### [00:38:55] [Albert Cheng]

**English:**
Crazy. You shouldn't be surprised. Obviously the name of the company is like this, but they've always hired people from around the world. The company's always been globally remote. They just hire people that love chess. They play all day, they watch the streams. Our Slack is always blowing up with people's chess moves and games and whatnot. I think I want to say this a little bit delicately, like Duolingo, even though the product they're providing is around language learning, I think the original ethos of how to start the company was really around motivation.
(00:39:29):
The hardest thing to its habits, it's how do you build that daily habit? And I actually in many ways see language learning as their first vehicle. And what they have a superpower in is that, again, the motivation, the habits, et cetera. So that's Duolingo, and Grammarly actually similarly. People know them for the spelling and grammar corrections, but what's really unique about them is they're integrated across tons and tons and tons of applications.
(00:39:55):
There's not many products that work like that, that's really unique. And so now if you hear Shishir, their new CEO talk about the AI super highway and all that type of stuff, they can now use that technology to provide a lot more than just grammar writing. And so my point is just that Chess is about chess 100%. It's in the ethos. People are crazy passionate. That just means we're always dogfooding the product. There's just an amazing energy in the company to just use the product all the time, come up with ideas, and I love that environment. I think that's fun for me.

**中文翻译:**
简直疯了。你不应该感到惊讶。显然公司的名字就是这样，但他们一直从世界各地招聘人才。公司一直是全球远程办公。他们只雇佣热爱国际象棋的人。他们整天都在下棋，看直播。我们的 Slack 频道总是被人们的棋步、对局之类的东西刷屏。我想委婉一点说，像 Duolingo，虽然他们提供的产品是关于语言学习的，但我认为公司成立之初的原始精神其实是关于“动力”（Motivation）。
(00:39:29):
最难的是习惯，即你如何建立日常习惯？在很多方面，我实际上把语言学习看作是他们的第一个载体。他们的超级力量在于动力、习惯等等。那是 Duolingo。Grammarly 也类似，人们因拼写和语法纠错而认识他们，但他们真正独特的地方在于他们集成了成千上万个应用程序。
(00:39:55):
没有多少产品能像那样运作，这非常独特。所以现在如果你听他们的 CEO Shishir 谈论 AI 超级高速公路之类的话题，他们现在可以利用这项技术提供远超语法写作的服务。我的观点是，Chess.com 100% 是关于国际象棋的。这是融入骨子里的精神。人们疯狂地热爱它。这意味着我们一直在“吃自己的狗粮”（Dogfooding，指内部试用自己的产品）。公司里有一种惊人的能量，大家一直在使用产品，提出想法，我喜欢这种环境。我觉得这很有趣。

---

### [00:40:28] [Lenny Rachitsky]

**English:**
That is so cool. What I love about what you're saying is there's no right or wrong answer. All of these companies are killing it. I think Duolingo is worth like $10 billion, something like that, and keeps growing. I'll look it up in a second. And Grammarly is worth a ton, and then Chess.com is doing super well. So I think that's a really interesting takeaway here is you can succeed in a lot of different ways.

**中文翻译:**
太酷了。我喜欢你所说的，因为这里没有对错之分。所有这些公司都做得非常出色。我想 Duolingo 的市值大约是 100 亿美元左右，而且还在增长。我待会儿查一下。Grammarly 估值极高，Chess.com 也表现优异。所以我觉得这是一个非常有趣的启发：你可以通过很多不同的方式获得成功。

---

### [00:40:51] [Albert Cheng]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:40:52] [Lenny Rachitsky]

**English:**
What's really cool about Duolingo, I was just thinking as you were talking, is yeah, it's just interesting that this very structured, methodical way of building is working so well because you could listen to that and be like, "Oh, I don't want to work." This is rigid way. But the fact that it is killing, it tells us this actually works really well. If you find something that works, lead into it.

**中文翻译:**
关于 Duolingo，我刚才听你说话时在想，这种非常有条理、系统化的构建方式运作得如此之好，这很有趣。因为你听了可能会觉得：“噢，我不想在那儿工作，这太死板了。”但事实是它表现极其出色，这告诉我们这种方式确实非常有效。如果你发现某些方法奏效，就深入去做。

---

### [00:41:11] [Albert Cheng]

**English:**
Yeah, that's right. Yeah, the structure is rigid, but the ideas are the farthest away from rigid as possible. You have seen their, I don't know, Superbowl commercials, they're memes, gamification, tactics. It's a super fun creative environment. So rigid is the farthest possible word to use, but what I just mean is they're consistent. They have for everything, and their product reviews are 10 or 15 minutes. It's just people go in and out. So it's just this kind of a surreal environment about how rapidly and consistently they work.

**中文翻译:**
是的，没错。结构是严谨的，但想法却离严谨最远。你可能看过他们的超级碗广告、他们的梗图、游戏化策略。这是一个超级有趣的创意环境。所以“死板”是离它最远的词。我的意思是他们非常“一致”。他们对每件事都有流程，他们的产品评审只有 10 或 15 分钟。人们进进出出。所以这是一种关于他们工作有多迅速和一致的超现实环境。

---

### [00:41:42] [Lenny Rachitsky]

**English:**
Awesome. They're worth $12 billion, and they were much higher actually, not too long ago. They're coming down a little bit. So speaking of Duolingo, when people think Duolingo, they think of the brand and the owl and the success they had on TikTok and things like that. I'm curious to get your take on as a very growth-oriented person watching that work and your take on growth, experimentation data versus marketing, viral TikTok videos, mascots, things like that.

**中文翻译:**
太棒了。他们的市值是 120 亿美元，不久前其实更高。现在稍微回落了一点。说到 Duolingo，当人们想到它时，会想到品牌、那只猫头鹰，以及他们在 TikTok 上取得的成功。我很想听听你作为一个非常注重增长的人对这些工作的看法，以及你对增长、实验数据与营销、病毒式 TikTok 视频、吉祥物等之间关系的看法。

---

### [00:42:09] [Albert Cheng]

**English:**
Yeah, I used to think it was versus, but now I realize that they combine really well. It could be rocket fuel for your growth. Yeah, being a product person. I joined a lot of these companies literally on the home screen on my phone, and I like using them. And I consider myself someone that's not easily swayed by ads or TV commercials telling me what to buy.
(00:42:28):
So I always had an element of skepticism on the marketing side for much of my career. But then, yeah, you join a place like Duolingo and you see how Duo the owl has developed a personality through the push notifications and the product experience, and then seeing the marketing team leverage that personality in their TikTok and in their YouTube and all throughout social media and just feed into those memes. And then we would track back in the product experience, how did you hear about us?
(00:42:58):
And put all those channels in there. And some days, it would be like, holy, it's bringing in 20, 30% of our new users and any given day. So those two things really go hand in hand, and that feeling has only been reinforced by Chess.com over the last five years. The first 15-ish years of this company was really under the radar. 800 million people play chess around the world, but most of that is over the board.
(00:43:25):
Until recently, there wasn't actually that much online, but five years ago, everything changed. You had the pandemic, you had Queen's Gambit, you had a lot of YouTube and Twitch streamers, you had a bunch of kids playing it in school, et cetera. And so it's really the combination of those two things that make it take off. And it's like the growth experimentation is more the slow and steady or fast and steady, I should say, approach where you're just continually iterating, you're making the product experience better, but then every so often, there's a big wave that comes in. You can quadruple your registrations overnight and you'd be a fool not to take advantage of that.

**中文翻译:**
是的，我以前认为它们是对立的，但现在我意识到它们结合得非常好。它可以成为你增长的火箭燃料。作为一个产品人，我加入的很多公司其实就在我手机的主屏幕上，我喜欢使用它们。我认为自己是一个不容易被广告或电视商业片左右购买决策的人。
(00:42:28):
所以在职业生涯的大部分时间里，我对营销端总是持怀疑态度。但是，当你加入像 Duolingo 这样的地方，看到猫头鹰 Duo 如何通过推送通知和产品体验形成个性，然后看到营销团队在 TikTok、YouTube 和整个社交媒体上利用这种个性并融入那些梗图。然后我们会在产品体验中回溯：你是如何听说我们的？
(00:42:58):
把所有这些渠道都放进去。有些日子，天哪，它在任何一天都能带来 20% 到 30% 的新用户。所以这两件事真的是相辅相成的。在过去的五年里，Chess.com 更加强化了我的这种感觉。这家公司的前 15 年左右其实一直默默无闻。全球有 8 亿人下棋，但大部分是在线下。
(00:43:25):
直到最近，线上的比例其实并不大，但五年前，一切都变了。有了疫情，有了《后翼弃兵》（Queen's Gambit），有了大量的 YouTube 和 Twitch 主播，还有一群在学校玩棋的孩子等等。所以正是这两者的结合让它腾飞。增长实验更像是那种稳扎稳打（或者说快速稳健）的方法，你不断迭代，改善产品体验；但每隔一段时间，就会有一股巨浪袭来。你的注册量可能在一夜之间翻四倍，如果不利用这一点，那就是傻瓜。

---

### [00:44:03] [Lenny Rachitsky]

**English:**
I was actually speaking at Chess.com and playing chess. I was at a coffee shop this weekend. There's a family, a dad and mom and a daughter ordering, and the dad's sitting at the table and he's just on his phone, just opened up Chess.com secretly and just plain while he is waiting. Oh man.

**中文翻译:**
我最近在 Chess.com 演讲，也在玩象棋。这周末我在一家咖啡馆，有一家人，爸爸妈妈和女儿在点餐，爸爸坐在桌边，拿着手机，偷偷打开 Chess.com，在等待的时候下棋。噢，天哪。

---

### [00:44:18] [Albert Cheng]

**English:**
I will not admit or deny that I've done that before.

**中文翻译:**
我既不承认也不否认我以前也这么干过。

---

### [00:44:22] [Lenny Rachitsky]

**English:**
But if I can think of anything more wholesome, I can't. That's an amazing thing to be doing while you're just sitting.

**中文翻译:**
如果让我去想还有什么比这更健康的事，我想不出来。坐在那儿的时候做这件事真的很棒。

---

### [00:44:32] [Albert Cheng]

**English:**
My 4-year-old can actually set up the pieces, which is pretty great. So he enjoys the game quite a bit.

**中文翻译:**
我四岁的孩子其实已经会摆棋子了，这很棒。他非常喜欢这个游戏。

---

### [00:44:36] [Lenny Rachitsky]

**English:**
Oh man, this 4-year-old already a pianist, playing chess.

**中文翻译:**
天哪，这个四岁孩子已经是钢琴家了，还在下象棋。

---

### [00:44:39] [Albert Cheng]

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:44:40] [Lenny Rachitsky]

**English:**
What a stud. This episode is brought to you by Miro. Every day, new headlines are scaring us about all the ways that AI is coming for our jobs, creating a lot of anxiety and fear, but a recent survey for Miro tells a different story. 76% of people believe that AI can benefit their role, but over 50% of people struggle to know when to use it. Enter Miro's Innovation Workspace, an intelligent platform that brings people and AI together in a shared space to get great work done.
(00:45:08):
Miro has been empowering teams to transform bold ideas into the next big thing for over a decade. Today, they're at the forefront of bringing products to market even faster by unleashing the combined power of AI and human potential. Just of this podcast often share Miro templates. I use it all the time to brainstorm ideas with my team. Teams especially can work with Miro AI to turn to unstructured data, like sticky notes or screenshots into usable diagrams, product briefs, data tables, and prototypes in minutes.
(00:45:37):
You don't have to be an AI master or to toggle yet another tool. The work you're already doing in Miro's canvas is the prompt. Help your teams get great work done with Miro. Check it out at miro.com/lenny, that's M-I-R-O.com/lenny. Okay, you talked about AI a little bit here and there.
(00:45:55):
I want to follow that thread. As a growth person, imagine AI informs chess.com in a lot of ways, so there's kind of two buckets here. How is AI changing the product, say chess and other places you've worked? And then how is AI impacting your work as a growth person? So pick one or both buckets and share there.

**中文翻译:**
真是个厉害的孩子。本集节目由 Miro 为您呈现。每天，新的头条新闻都在用 AI 将取代我们工作的各种方式吓唬我们，制造了大量的焦虑和恐惧。但 Miro 最近的一项调查显示了不同的情况：76% 的人相信 AI 可以使他们的角色受益，但超过 50% 的人不知道何时使用它。欢迎使用 Miro 的创新工作空间（Innovation Workspace），这是一个智能平台，将人和 AI 聚集在一个共享空间中，共同完成伟大的工作。
(00:45:08):
十多年来，Miro 一直在赋能团队将大胆的想法转化为下一个大事件。今天，他们通过释放 AI 和人类潜力的结合力量，走在让产品更快推向市场的最前沿。本播客的嘉宾经常分享 Miro 模板。我一直用它和我的团队进行头脑风暴。团队特别可以利用 Miro AI 将非结构化数据（如便签或截图）在几分钟内转化为可用的图表、产品简报、数据表和原型。
(00:45:37):
你不需要成为 AI 大师，也不需要切换到另一个工具。你在 Miro 画布上已经在做的工作就是提示词（Prompt）。帮助你的团队通过 Miro 完成伟大的工作。请访问 miro.com/lenny。好了，你刚才零星谈到了 AI。
(00:45:55):
我想顺着这个话题聊聊。作为一个增长人，我想 AI 在很多方面影响着 Chess.com。这里有两个范畴：AI 如何改变产品（比如国际象棋和你工作过的其他地方）？以及 AI 如何影响你作为增长人的工作？请选择其中一个或两个范畴分享一下。

---

### [00:46:13] [Albert Cheng]

**English:**
Yeah, I'll tackle them in sequence. I'll start with the chess one just because I have maybe a slightly unique take on that one. So chess and AI, they've been intertwined for almost a century. Some of the early computing pioneers, they just figured, "Yeah, chess is an interesting game. We can test machine intelligence and write some algorithms or not." And then fast-forward to 1997, and you had IBM, they had their DeepBlue application who actually beat the world champion back then, which was Garry Kasparov.
(00:46:43):
And that was a huge moment of shock and reckoning of like, "Oh man, is AI going to take over? Humans are, we're going to have jobs and all this stuff." And this is 30 years ago, and thankfully we're all still here and more people are playing chess than ever. And so the game of chess and chess.com specifically have learned how to augment, I guess the human playing experience with the power of chess engines, which are definitely a powerful form of AI. It's not LLMs to be clear, but there's engines like Stockfish these days that are just dramatically better than the top grand masters in the world.

**中文翻译:**
好的，我会按顺序回答。我先从国际象棋开始，因为我对这个话题可能有一个稍微独特的视角。国际象棋和 AI 已经交织了近一个世纪。一些早期的计算机先驱认为：“是的，国际象棋是一个有趣的游戏，我们可以测试机器智能并编写一些算法。”快进到 1997 年，IBM 的“深蓝”（DeepBlue）击败了当时的世界冠军加里·卡斯帕罗夫（Garry Kasparov）。
(00:46:43):
那是一个巨大的震惊和反思时刻：“噢，天哪，AI 要接管了吗？人类还会有工作吗？”那是 30 年前的事了，谢天谢地我们现在都还在这里，而且下棋的人比以往任何时候都多。所以国际象棋和 Chess.com 特别学会了如何利用象棋引擎的力量来增强人类的对弈体验。象棋引擎绝对是 AI 的一种强大形式。明确地说，它不是大语言模型（LLM），但现在的 Stockfish 等引擎比世界上顶尖的大师都要强得多。

---

### [00:47:22] [Lenny Rachitsky]

**English:**
Is that where we're at? I remember when it beat humans and now it's just dramatically better.

**中文翻译:**
我们已经到这个地步了吗？我记得它击败人类的时候，现在竟然已经强出这么多了。

---

### [00:47:26] [Albert Cheng]

**English:**
It's dramatically better.

**中文翻译:**
强出非常多。

---

### [00:47:28] [Lenny Rachitsky]

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:47:28] [Albert Cheng]

**English:**
Yeah, I think there's a rating system that compares relative skill level and an average chess player somewhere like a thousand, maybe 1,500 on the high end, a top grandmaster like Magnus Carlsen, it's like a 2,800 and then Stockfish and similar engines are like 3,600.

**中文翻译:**
是的，有一个评分系统来比较相对技能水平。普通棋手大约在 1000 左右，高手可能到 1500。像马格努斯·卡尔森（Magnus Carlsen）这样的顶级大宗师大约是 2800，而 Stockfish 和类似的引擎大约是 3600。

---

### [00:47:45] [Lenny Rachitsky]

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:47:45] [Albert Cheng]

**English:**
And so to put that in comparison, yeah.

**中文翻译:**
所以对比一下，是的。

---

### [00:47:48] [Lenny Rachitsky]

**English:**
At least it's not 10,000 or a million. I don't even know if that's possible.

**中文翻译:**
至少不是一万或一百万。我甚至不知道那是否可能。

---

### [00:47:51] [Albert Cheng]

**English:**
No, it's not 10,000. But it's similar to if the chess engine was playing without a major piece like a rook or something, they would still be competitive against the best players.

**中文翻译:**
不，不是一万。但这类似于如果象棋引擎在少一个大子（比如少一个车）的情况下对弈，它们仍然能与最顶尖的棋手抗衡。

---

### [00:47:59] [Lenny Rachitsky]

**English:**
And this is the Elo score? Is that the term?

**中文翻译:**
这就是 Elo 等级分？是这个术语吗？

---

### [00:48:00] [Albert Cheng]

**English:**
Yeah, the Elo score, Elo rating.

**中文翻译:**
是的，Elo 分数，Elo 等级。

---

### [00:48:01] [Lenny Rachitsky]

**English:**
Magnus is what you said about 2,800, and then the Stockfish is would you say 3,600?

**中文翻译:**
你刚才说马格努斯大约是 2800，Stockfish 大约是 3600？

---

### [00:48:04] [Albert Cheng]

**English:**
Yeah, and really it's because computing power is so amazing and there's so many techniques for how to do deep evaluation on specific chess lines. They can calculate tens of millions per second. So it's not realistic for a human to compete against that. But yet, watching some of these chess engines played has opened up a lot of creativity, new strategies, new lines, new appreciation for the game. And our chess.com approach is that we can bring this technology for every user.
(00:48:36):
Even people that have never moved a piece before. I talked earlier about that game review product, that's exactly what this does. So behind the scenes, we're running chess engines to basically spit out evaluations for every move that you make. And then we translate that and make that approachable to the user using their native language and plain approachable style, and even with audio and things like that as well. And that part of it, the personality, the speech back to the user, that part is LLMs.
(00:49:07):
And so I guess my point is that, again, chess and AI have been intertwined forever, but for us, what's most important is that we keep the customer at the North Star of it. We're not just applying LLMs just because the new hot thing, you've got to apply the right technology for the right feature to provide value to the user. And so we try not to ever lose sight of that and let hype get us too carried away.

**中文翻译:**
是的，这主要是因为计算能力太惊人了，而且有很多技术可以对特定的棋路进行深度评估。它们每秒可以计算数千万次。所以人类与之竞争是不现实的。然而，观看这些象棋引擎的对弈开启了很多创造力、新策略、新棋路和对游戏的新理解。Chess.com 的方法是，我们可以为每个用户带来这项技术。
(00:48:36):
甚至是那些从未动过棋子的人。我之前提到的“对局回顾”产品正是这样做的。在后台，我们运行象棋引擎，为你走的每一步棋提供评估。然后我们将其翻译成用户的母语，用通俗易懂的风格呈现给用户，甚至还配有音频等。而那部分——个性化的表达、对用户的语音反馈——那部分使用的是大语言模型（LLM）。
(00:49:07):
所以我的观点是，国际象棋和 AI 永远交织在一起，但对我们来说，最重要的是始终以客户为“北极星”。我们不会仅仅因为 LLM 是热门新事物就去应用它，你必须为正确的功能应用正确的技术，从而为用户提供价值。我们努力不迷失方向，不让炒作带偏我们。

---

### [00:49:31] [Lenny Rachitsky]

**English:**
It's just really surprising. I think people would not have expected AI and cannot beat every human alive ever. And chess is at an all-time high. People want to keep playing and are playing more and more than ever played, not unexpected.

**中文翻译:**
这真的很令人惊讶。我想人们可能没预料到 AI 能够击败世界上每一个活生生的人。而国际象棋现在正处于历史巅峰。人们想继续玩，而且玩的人比以往任何时候都多，这并不意外。

---

### [00:49:46] [Albert Cheng]

**English:**
Interestingly, LLMs themselves are quite bad at playing chess. They hallucinate moves, they look at patterns. They're very good at pattern recognition, but not so good at going super, super, super deep on a specific chest thing. And if you've even tried to create or look at chessboard images on ChatGPT, a lot of them have the wrong number of squares. They're not set up properly, and so I don't want to be too dismissive.
(00:50:09):
I'm sure it's going to get much stronger at reasoning. And actually, Google recently sponsored a tournament where all the top LLMs played a tournament against each other. So that was pretty fun to watch. They're improving, but chess is specifically a game that having a trained deep, deep computing engine is just going to be much, much, much more powerful than LLMs.

**中文翻译:**
有趣的是，LLM 本身下棋其实很烂。它们会产生“幻觉”走法，它们看的是模式。它们非常擅长模式识别，但不擅长在特定的棋局上进行极深、极深、极深的推演。如果你尝试在 ChatGPT 上生成或查看棋盘图像，很多图像的格子数量都是错的，摆放也不正确。我不想太轻视它。
(00:50:09):
我相信它的推理能力会变得更强。实际上，谷歌最近赞助了一场比赛，让所有顶尖的 LLM 互相博弈。那看起来很有趣。它们在进步，但国际象棋这种游戏，经过训练的深度计算引擎就是要比 LLM 强大得多。

---

### [00:50:30] [Lenny Rachitsky]

**English:**
And not to go down this track too far, but AlphaZero famous for beating the Top Go player. Was that trained specifically for Go? Obviously not in LLM, but that was a Go specific model.

**中文翻译:**
不想在这个话题上扯太远，但 AlphaZero 因击败顶级围棋选手而闻名。那是专门为围棋训练的吗？显然不是 LLM，但那是一个围棋专用模型。

---

### [00:50:42] [Albert Cheng]

**English:**
Yeah. My understanding is that the one, that documentary is incredible, by the way. I don't know if you've watched AlphaGo, it's amazing how they took something so technically deep and made it so emotional and human. But I think that's the crux of how we feel, I guess, about AIs and the products that we build, actually. But to your point, my understanding is that the way AlphaZero is primarily trained is that it just plays a bunch of games against itself. And so through the neural network, it just gets smarter every time. And because it can have that repetition times a billion or a trillion, I don't know exactly what number, but it's going to get pretty damn good.

**中文翻译:**
是的。顺便说一下，那部纪录片非常精彩。不知道你有没有看过《AlphaGo》，他们把如此深奥的技术变得如此感性、如此人性化，这太神奇了。我认为这正是我们对 AI 以及我们所构建的产品的感觉的核心。回到你的问题，我的理解是 AlphaZero 的主要训练方式是让它自己和自己对弈。通过神经网络，它每次都会变得更聪明。因为它能进行数十亿次甚至数万亿次的重复（我不知道具体数字），它肯定会变得非常厉害。

---

### [00:51:19] [Lenny Rachitsky]

**English:**
Okay. Let's go back on track to where we were going. So this was how AI is impacting chess.com. How is AI changing just the work of a growth person?

**中文翻译:**
好了，让我们回到正轨。刚才说的是 AI 如何影响 Chess.com。那么 AI 如何改变增长人员的工作呢？

---

### [00:51:30] [Albert Cheng]

**English:**
I like to describe growth as the job is to connect users to the value of your product. And in order to do that, what I like to do is think about that user journey again, and essentially, staff teams that are oriented around each element of that user journey. And those teams have specific metric goals, they have roadmaps, et cetera. And then they go run against them.
(00:51:52):
So that's how it's structured. AI, I think can be applied to speed up some elements of that essentially experiment cycle that you get through. So one example is in product discovery. As opposed to core product, which tends to have longer timeframes, and you might do thorough user research or market research. It's more foundational, more for first principles, et cetera. Growth is a little bit less like that.
(00:52:18):
It's like you're running a lot of experiments and the output of any given experiment is the input to your next idea. And so historically, I don't even mean historically, but just a few months ago, we were operating in a, that's history, I suppose, but there would be a lot of manual writing of these analysis docs. You'd have to read them, you'd have to understand what insight you want to grab from them and then write another spec to translate that idea. That's still happening to some degree, but I think that's a spot where even tools like ChatGPT are super helpful.
(00:52:56):
You can just plug in like an analysis that another person wrote and just have it summarized for you and give you advice on ideas to go try. And so that ideation, that research cycle was much, much faster. I talked a little bit about prototyping also just becoming much, much faster than before. We have not yet gotten to the point where product managers themselves are actually shipping the code into production, but it's dramatically shortened the amount of time it takes to conceive of especially a bolder idea that you might have.
(00:53:27):
And so when I talked earlier about explore and exploit, a lot of the explore was harder to do, but now it's a little bit easier to do. You can take a broader concept and visualize it, and when you can visualize it, send it around the team, get people to click around it, that makes a world of difference. So those are just a couple examples that come to mind.

**中文翻译:**
我喜欢将增长描述为：其工作是将用户与产品的价值连接起来。为了做到这一点，我喜欢再次思考用户旅程，并基本上围绕该旅程的每个元素组建团队。这些团队有具体的指标目标、路线图等等，然后他们去执行。
(00:51:52):
这就是它的结构。我认为 AI 可以用来加速实验周期的某些环节。一个例子是产品发现（Product Discovery）。核心产品往往有更长的时间跨度，你可能会做彻底的用户研究或市场研究，它更偏基础，更偏第一性原理。增长则不太一样。
(00:52:18):
增长就像是你运行大量的实验，任何一个实验的输出都是下一个想法的输入。在过去（我指的不是很久以前，而是几个月前），我们需要手动编写大量的分析文档。你必须阅读它们，理解你想从中获取什么洞察，然后编写另一个规范（Spec）来转化这个想法。这种情况在某种程度上仍在发生，但我认为像 ChatGPT 这样的工具在这一环节超级有帮助。
(00:52:56):
你可以直接把别人写的分析报告塞进去，让它为你总结，并就下一步可以尝试的想法给你建议。所以构思和研究周期变得快得多了。我也谈到了原型设计，它也比以前快得多。虽然我们还没有达到产品经理自己直接将代码发布到生产环境的程度，但它极大地缩短了构思一个想法（特别是大胆的想法）所需的时间。
(00:53:27):
所以当我之前谈到“探索与利用”时，很多“探索”以前很难做，但现在容易了一些。你可以把一个宽泛的概念可视化，当你能把它可视化并发送给团队，让大家点击体验时，那会产生天壤之别。这些就是我能想到的一些例子。

---

### [00:53:47] [Lenny Rachitsky]

**English:**
Awesome. I want to go back to this phrase right at the beginning of this answer that you shared that I think is really helpful that you see growth as simply your job is to connect users to the value of your product.

**中文翻译:**
太棒了。我想回到你刚才回答开头分享的那句话，我认为那非常有帮助：你将增长简单地看作是将用户与产品的价值连接起来。

---

### [00:53:58] [Albert Cheng]

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:53:59] [Lenny Rachitsky]

**English:**
Can you speak more to that? Because I think that's such a nice way clarifying what is growth's role?

**中文翻译:**
你能再多谈谈这一点吗？因为我认为这是一种非常好的方式来澄清增长的角色到底是什么。

---

### [00:54:03] [Albert Cheng]

**English:**
Yeah, it resonates deeply with me because I feel like growth sometimes gets this reputation I guess that it's just pure metrics hacking, like we're cold people that just are trying to move a particular metric up and we're going to do whatever it can to throw walls and pay walls and add friction in all these spots. And even though that could theoretically work at a micro level on a specific feature or a specific metric, I think what's most healthy for a company, and I want to work at durable companies is to think about the user holistically.
(00:54:42):
And when you take that framing of connecting users to the value of your product, that value can change for a user over time, and that also lines up really nicely to the journey. What someone that's not even a user yet needs to understand about the value proposition is super different than what a habitual user of three plus years might need. And so the teams working on them should think from that perspective and then from there, then ladder into specific problems to solve hypotheses, et cetera.

**中文翻译:**
是的，这让我产生深切共鸣，因为我觉得增长有时会被认为只是纯粹的指标操纵——好像我们是一群冷酷的人，只想着把某个指标拉上去，不择手段地设置障碍、付费墙，在各个地方增加摩擦。虽然这在微观层面（针对特定功能或指标）理论上可能奏效，但我认为对一家公司最健康的方式（我也想在长青的公司工作）是整体地思考用户。
(00:54:42):
当你采用“将用户与产品价值连接”这个框架时，这种价值对用户来说是会随时间变化的，这也很好地契合了用户旅程。一个还不是用户的人需要理解的价值主张，与一个使用了三年以上的习惯性用户所需要的完全不同。因此，负责这些工作的团队应该从这个角度思考，然后由此延伸到具体要解决的问题、假设等等。

---

### [00:55:15] [Lenny Rachitsky]

**English:**
Following that thread a little bit more, people listening to this are imagining, "How do I get better at experimentation? How do I run more experiments? How do we do this better?" What are two or three tips and best practices that you think people need to hear maybe are not totally aware of when they think about getting better at experimentation on our teams?

**中文翻译:**
顺着这个思路再聊聊。听众们可能在想：“我该如何变得更擅长实验？我该如何运行更多实验？我们该如何做得更好？”你认为有哪些两三个提示或最佳实践是人们在考虑提高团队实验能力时需要听到、或者可能还没完全意识到的？

---

### [00:55:36] [Albert Cheng]

**English:**
I think the first thing is just start somewhere. I just read this Atlassian state of product report and it was like 40% of product teams basically don't run experimentation at all. And there may be some good reasons for it. It could be philosophical or maybe you're more B2B oriented or whatever. So I get it, but I think for a lot of, especially if you work on a consumer product that has some degree of scale, some degree of frequency with your product, you can collect enough data.
(00:56:05):
And also I have found I can pattern match all day long. I've worked a lot of companies, right? But I'm wrong all the time. And I think consumer behavior can be very fickle and especially when you work at a company, you become a power user naturally. So sometimes you may forget what the actual user experience is for a brand new user, and so you leave a lot of opportunities on the table if you don't even try to experiment.
(00:56:27):
So I just encourage taking that first step, just run an A/B test, find a third-party tool or something that you can integrate quickly or even just work with your engineers to spin something up. Just get in the practice of crawl then walk then run type of thing.

**中文翻译:**
我认为第一件事就是“先从某处开始”。我刚读了 Atlassian 的产品现状报告，大约 40% 的产品团队基本上根本不进行实验。这可能有一些正当理由，比如哲学理念不同，或者更偏向 B2B 等等。我理解，但我认为对于很多公司，特别是如果你开发的是具有一定规模和使用频率的消费级产品，你是可以收集到足够数据的。
(00:56:05):
而且我发现，我可以整天进行模式匹配（凭经验判断），我待过很多公司，对吧？但我经常出错。我认为消费者行为可能非常反复无常，特别是当你在一家公司工作时，你会自然而然地变成“超级用户”。有时你可能会忘记一个全新用户的真实体验。如果你甚至不去尝试实验，你就会错失很多机会。
(00:56:27):
所以我鼓励迈出第一步，运行一个 A/B 测试，找一个可以快速集成的第三方工具，或者干脆和工程师一起搭一个简单的东西。先学会爬，再学会走，最后再跑。

---

### [00:56:40] [Lenny Rachitsky]

**English:**
Do you have a favorite tool, by the way? Just to throw out? Is there a go-to tool for you?

**中文翻译:**
顺便问一下，你有最喜欢的工具吗？有没有什么推荐的？

---

### [00:56:44] [Albert Cheng]

**English:**
We used Statsig at Grammarly and I saw that they recently got acquired, so that was exciting news. Duolingo and Chess.com both have an in-house experimentation approach.

**中文翻译:**
我们在 Grammarly 使用 Statsig，我看到他们最近被收购了，那是条令人兴奋的消息。Duolingo 和 Chess.com 都有自己内部开发的实验方案。

---

### [00:56:54] [Lenny Rachitsky]

**English:**
Sweet.

**中文翻译:**
太棒了。

---

### [00:56:55] [Albert Cheng]

**English:**
Pros and cons to either. Obviously Duolingo is an experimentation machine, and so it's been a huge accelerant to have our own thing specifically tailored to be excellent at that. But no, I typically don't encourage companies to build experimentation in-house from day one. At a certain scale it can make sense. And some of these companies, they were started 15 years ago when these tools weren't out. So it was just something they had to do.

**中文翻译:**
两者各有优缺点。显然 Duolingo 是一个实验机器，拥有专门定制的内部工具极大地加速了这一进程。但是，我通常不鼓励公司从第一天起就内部构建实验系统。到了一定规模后这才有意义。而且这些公司中有些是 15 年前成立的，当时这些第三方工具还没出现，所以那是他们不得不做的事情。

---

### [00:57:22] [Lenny Rachitsky]

**English:**
Something that you mentioned to me at Chess.com, your goal is to run a thousand experiments a year. You said you were at 250. Talk about just that as a North Star.

**中文翻译:**
你在 Chess.com 提到过，你的目标是每年运行 1000 个实验。你说目前是 250 个。谈谈这个“北极星指标”吧。

---

### [00:57:32] [Albert Cheng]

**English:**
Yeah, so part of having team members that are fanatical about Chess is that the company can get pretty far just building for themselves, building for the community, and not actually being very experimentation and data oriented. The problem with that is that you can have relatively lumpy growth. And so part of the excitement of me joining the company was to help smooth that out and bring in that experimentation mindset.
(00:57:56):
So prior to 2023, the company practically didn't experiment at all. Last year they did about 50, this year they're on pace for about 250. And then next year we have that ambitious target of a thousand. Did I make it up? Yes, absolutely, I made it up, but it's still a target and a thing for the teams to think about and a thousand experiments by itself. If you just did that but you didn't learn, you didn't make an impact, that's kind of a waste of time.
(00:58:25):
The whole point of setting a goal is that you can have conversations about what would need to be true to actually hit that goal, and so that leads to insights. Actually we need not just product management or engineering to be running these experiments. We can experiment with lifecycle marketing, changing copy of push notifications and emails. We can experiment with app store screenshots and keywords and stuff like that. We have all sorts of content marketing teams, et cetera. We could have engineering enable no code for specific screens.
(00:58:58):
Think about our home screen or our pricing screen where we might want to do a lot of just tests that are configurable without engineering support. We might want to just track our progress and look at it from time to time and make sure that we have the right observability around this. So anyway, that's the stuff that really matters as opposed to the hitting that goal itself. So don't tell the team, but I don't actually care that much if we actually hit a thousand, but I think if we get pretty close and we accomplish some of these things, we'll be in really good shape.

**中文翻译:**
是的。拥有一群对比萨（国际象棋）狂热的团队成员，意味着公司仅靠为自己和社区构建产品就能走得很远，而不需要非常注重实验和数据。问题在于，这会导致增长相对不稳定。所以我加入公司的兴奋点之一就是帮助平滑这种增长，并引入实验思维。
(00:57:56):
在 2023 年之前，公司几乎完全不做实验。去年他们做了大约 50 个，今年有望达到 250 个。明年我们有一个宏大的目标：1000 个。这是我编出来的吗？是的，绝对是我编的。但它仍然是一个目标，是团队需要思考的事情。单纯追求 1000 个实验，如果没有学到东西，没有产生影响，那就是浪费时间。
(00:58:25):
设定目标的全部意义在于，你可以围绕“要实现这个目标需要满足什么条件”展开对话，从而产生洞察。实际上，我们不仅需要产品管理或工程部门运行实验。我们可以对生命周期营销（Lifecycle Marketing）进行实验，更改推送通知和电子邮件的文案。我们可以对应用商店截图和关键词进行实验。我们有各种内容营销团队。我们可以让工程部门在特定屏幕上启用“无代码”配置。
(00:58:58):
想想我们的主屏幕或定价屏幕，我们可能想在不需要工程支持的情况下进行大量可配置的测试。我们可能想跟踪进度并时常查看，确保我们对此有正确的观测能力。总之，这些才是真正重要的事情，而不是达成目标本身。所以别告诉团队，但我其实并不那么在乎我们是否真的达到 1000 个，但如果我们能接近这个数字并完成这些事情，我们就会处于非常好的状态。

---

### [00:59:27] [Lenny Rachitsky]

**English:**
Okay, we'll make sure none of them watch this. I think chess.com is in, this is just such a cool example of a culture shifting dramatically from zero experiments to sounds like two years later, a thousand, which is three a day. There's many teams running experiments in parallel, but that's a lot. What has helped you most shift that culture? Is it just the CEO being like, "This is the way we're going to go." What have you learned about helping shift to culture from No, we're not doing experiments to a thousand experiments a year.

**中文翻译:**
好的，我们会确保他们都不看这一段。我认为 Chess.com 是一个非常酷的例子，展示了文化如何发生剧变——从零实验到两年后可能的 1000 个，也就是平均每天三个。虽然有很多团队在并行运行实验，但这依然很多。是什么最能帮助你转变这种文化？是 CEO 直接说“这就是我们要走的路”吗？关于如何将文化从“我们不做实验”转变为“每年 1000 个实验”，你学到了什么？

---

### [00:59:58] [Albert Cheng]

**English:**
Yeah, definitely a lot of credit to the CEO and co-founders like Erik and Danny, they're amazing. It's not their intuitive way of thinking about growing companies, but their mental flexibility and encouragement to evolve and add this as a tool for the company has been awesome, and they've been on the front lines preaching product-led growth and experimentation just as much as I have.
(01:00:20):
So I'm glad that you brought that up because I think that is critically important for me, joining a company to not be at odds with the co-founders and the existing approach of the company. I think that's absolutely, absolutely critical. I think I started this podcast with the example of the game review and the positivity and how that was shared. I think those types of things are really what motivate people. They need to see this working in practice.

**中文翻译:**
是的，这很大程度上要归功于 CEO 和联合创始人 Erik 和 Danny，他们太棒了。这并不是他们直觉上的公司增长思维方式，但他们的思维灵活性以及对公司进化、引入实验工具的鼓励是非常了不起的。他们和我一样，都在前线宣扬产品驱动增长（PLG）和实验。
(01:00:20):
我很高兴你提到这一点，因为我认为这对我来说至关重要：加入一家公司，不能与联合创始人以及公司现有的方法论背道而驰。我认为这绝对、绝对关键。我在这期播客开头举了“对局回顾”和积极反馈的例子，以及它是如何被分享的。我认为这类事情才是真正激励人们的。他们需要看到这在实践中奏效。

---

### [01:00:45] [Lenny Rachitsky]

**English:**
Wins.

**中文翻译:**
胜利。

---

### [01:00:46] [Albert Cheng]

**English:**
Yeah, you need wins, you got to celebrate them. People feel good about the learning. It's applied across the board. Who's not going to be energized by that, I think, right? So you can't just set goals in a vacuum and create it from top, right? People have to see it working and when it works, the metrics move and you learn faster and you ship faster, and that's a great environment to be part of.

**中文翻译:**
是的，你需要胜利，你得庆祝它们。人们会因为学到了东西而感觉良好。这些学习成果被应用到各个方面。谁不会为此感到振奋呢？所以你不能在真空中设定目标并自上而下地强推。人们必须看到它奏效，当它奏效时，指标会变动，你学得更快，发布也更快，这是一个非常棒的环境。

---

### [01:01:07] [Lenny Rachitsky]

**English:**
What was the first experiment you guys ran? Do you remember?

**中文翻译:**
你们运行的第一个实验是什么？你还记得吗？

---

### [01:01:10] [Albert Cheng]

**English:**
I don't know, before my time actually.

**中文翻译:**
我不知道，其实是在我加入之前。

---

### [01:01:13] [Lenny Rachitsky]

**English:**
Okay. Okay. Got it. So they're already going down this track before they brought you in?

**中文翻译:**
好的，明白了。所以他们在请你加入之前就已经开始走这条路了？

---

### [01:01:17] [Albert Cheng]

**English:**
They had run some.

**中文翻译:**
他们已经运行过一些了。

---

### [01:01:19] [Lenny Rachitsky]

**English:**
Okay, sweet. Are there any other key lessons that you think people need to know to be successful running experiments at scale?

**中文翻译:**
好的，太棒了。你认为要成功地大规模运行实验，人们还需要了解哪些关键教训？

---

### [01:01:30] [Albert Cheng]

**English:**
The system matters just as much as any given experiment, probably even more, right? I think starting with a growth model, so you have an understanding of how your company grows in the first place and which channels you're going to leverage is critical. You need to make sure that you are instrumenting your product in and out. Otherwise, you're going to run experiments and have wonky results.
(01:01:53):
I won't name which company, but I was part of a company that had an in-house experimentation tool. It's about three months into the company, we're running some experiments and we realized that user retention was actually configured backwards. So all positive results were negative results.

**中文翻译:**
系统的重要性不亚于任何单个实验，甚至可能更重要。我认为，首先要有一个增长模型，这样你就能从根本上理解公司是如何增长的，以及你要利用哪些渠道，这至关重要。你需要确保对产品进行了全方位的埋点。否则，你运行实验得到的结果会很离谱。
(01:01:53):
我不点名是哪家公司，但我曾待过一家拥有内部实验工具的公司。加入大约三个月后，我们运行了一些实验，结果发现用户留存的配置居然是反的。所以所有的正面结果其实都是负面结果。

---

### [01:02:09] [Lenny Rachitsky]

**English:**
Geez.

**中文翻译:**
天哪。

---

### [01:02:10] [Albert Cheng]

**English:**
So all positive results were negative results.

**中文翻译:**
所以所有的正面结果其实都是负面结果。

---

### [01:02:13] [Lenny Rachitsky]

**English:**
You just go through and undo all those experiments and just drive up retention.

**中文翻译:**
那你只需要把那些实验全部撤销，就能提高留存率了。

---

### [01:02:17] [Albert Cheng]

**English:**
It's kind of weird. We're seeing people use the features a lot more. Why is user retention going negative? So I have plenty of horror stories around that type of stuff, but yeah.

**中文翻译:**
当时感觉很奇怪。我们看到人们使用功能的频率增加了，为什么用户留存反而变负了？所以我有很多关于这类事情的恐怖故事。

---

### [01:02:25] [Lenny Rachitsky]

**English:**
Oh my God. On the flip side of horror stories, you've shared a bunch of cool examples of experiment wins. Is there another that comes to mind of one you're really proud of or that was really trajectory changing either at Duolingo or Grammarly or Chess?

**中文翻译:**
天哪。除了恐怖故事，你也分享了很多酷炫的实验胜利案例。你还能想到另一个让你非常自豪，或者真正改变了发展轨迹的例子吗？无论是在 Duolingo、Grammarly 还是 Chess.com。

---

### [01:02:38] [Albert Cheng]

**English:**
So I already shared one of Chess.com and one of Grammarly. I could talk a bit about Duolingo as well. Duolingo and you had Jackson on the podcast, right? Where you talked about the streaks.

**中文翻译:**
我已经分享了一个 Chess.com 的例子和一个 Grammarly 的例子。我也可以谈谈多邻国。你之前请 Jackson 上过播客，对吧？你们聊到了“连胜”（Streaks）。

---

### [01:02:38] [Lenny Rachitsky]

**English:**
Yes, talked about the streaks.

**中文翻译:**
是的，聊到了连胜。

---

### [01:02:52] [Albert Cheng]

**English:**
So I also don't want to steal his thunder because I was going to think about that, but the amount of learning through commitment and putting streaks on a calendar and just getting people started as opposed to achieving some large milestone, that was huge. I think we did something interesting. We spun up a virality team and virality is this really amorphous thing to me.
(01:03:16):
I think it's really hard to generate virality in your product, but Duolingo is a product that is shared quite a bit. And so we invested actually in some time to essentially add screenshot tracking for a brief period of time in the app just so we could find out the hotspots of where users were doing screenshots. And you see this in other apps too, it's not necessarily some horrible thing, but we did this for some period of time and we were able to basically articulate and say, "Okay, streak milestones is the obvious one."
(01:03:46):
Really funny challenges that you get in the Duolingo experience is also super highly shared. Advancing in the top three of a leaderboard is another thing. Anyway, so you can find these different moments where that's the case. And then we staffed those moments with illustrators and animators and created these really delightful experiences around them, and that worked amazingly well.
(01:04:06):
So as opposed to going against I guess human intuition and trying to get them to share stuff that they otherwise wouldn't on the margins want to share, lean into it more, actually grab the moments where users are already organically screenshotting and make those much, much, much better. And you can 5X or 10X and drive a lot of growth that way too. So that's not so much an experiment, it's more a core product thing, but it just resonated with me that that was interesting.

**中文翻译:**
我也不想抢他的风头，因为我也在想那个。但通过承诺、在日历上标记连胜，以及让人们开始行动（而不是追求某个宏大里程碑）所带来的学习效果是巨大的。我认为我们做了一件有趣的事：我们组建了一个“病毒式传播”（Virality）团队。对我来说，病毒式传播是一个非常模糊的概念。
(01:03:16):
我认为在产品中产生病毒式传播非常难，但 Duolingo 是一个被分享得相当多的产品。所以我们投入了一些时间，在 App 中短时间加入了截图跟踪，以便找出用户截图的热点区域。你在其他 App 中也能看到这种做法，这不一定是坏事。我们做了一段时间，基本上可以明确地说：“连胜里程碑显然是一个热点。”
(01:03:46):
你在 Duolingo 体验中遇到的非常有趣的挑战也被高度分享。进入排行榜前三名是另一个热点。总之，你可以找到这些时刻。然后我们为这些时刻配备了插画师和动画师，围绕它们创造了非常愉悦的体验，效果出奇地好。
(01:04:06):
所以，与其违背人类直觉去强迫他们分享那些他们本来不想分享的东西，不如顺势而为——抓住用户已经在有机截图的时刻，并让这些时刻变得更好、更好、更好。你可以借此获得 5 倍或 10 倍的增长。这与其说是一个实验，不如说是一个核心产品改进，但它让我产生共鸣，觉得非常有趣。

---

### [01:04:33] [Lenny Rachitsky]

**English:**
Well, it connects to your explore and exploit methodology. Just find or explore where things are happening and then try to exploit in a nice positive way.

**中文翻译:**
这与你的“探索与利用”方法论相契合。就是去寻找或探索事情正在发生的地方，然后尝试以一种积极的方式去“利用”它。

---

### [01:04:41] [Albert Cheng]

**English:**
You got it.

**中文翻译:**
你理解了。

---

### [01:04:42] [Lenny Rachitsky]

**English:**
Speaking of that, you mentioned this with Duolingo is just very good at habit formation and motivation behavior. It feels like chess is good at this too. You've worked at both these companies. What have you learned about how to motivate people? How to create habits?

**中文翻译:**
说到这个，你提到多邻国非常擅长习惯养成和动力行为。感觉国际象棋在这方面也很擅长。你在这两家公司都工作过。关于如何激励人们、如何建立习惯，你学到了什么？

---

### [01:04:57] [Albert Cheng]

**English:**
Again, Duolingo would not have started without this insight from day one. They aim to focus on motivation and build a lot of these tactics. Jorge actually had this model of gamification patterns having essentially three pillars to it. You have the core loop, you have the metagame, and then you have the profile. And so we actually thought about it that way too, where your core loop is your lesson that you go through. You do a lesson, you get some rewards, you extend your streak, and then the next day you get a push notification.
(01:05:29):
It's the core loop of the product and making that really tight is super important because people need a habit to stick to. Then you need a metagame, which for Duolingo is the path, but it's also the leaderboard achievements. It's long-term things that you're going to strive to such that you have long-term, I guess, motivation to continue doing the thing. And then the profile is also critical because you build up a profile over time.
(01:05:51):
It's a reflection of your investment inside the product experience. And so when you nail those three things, you can end up with a long-term learning journey that can be quite successful. And then to flip over to the Chess.com side, what we see is that over 75% of our new users, they classify themselves as like, "I'm completely new to chess." Or, "I'm a beginner." And unfortunately, if you're new to chess and you're a beginner, you're not going to have that fun of a time playing live games, and we see this in the data. It's like less than a third of those users actually win their first game. And when you lose a game, user retention is 10% worse than when you win a game.

**中文翻译:**
同样，如果没有从第一天起就有的这种洞察，Duolingo 就不会诞生。他们的目标是专注于动力并构建大量的策略。Jorge 实际上有一个游戏化模式的模型，它基本上有三个支柱：核心循环（Core Loop）、元游戏（Metagame）和个人档案（Profile）。我们也确实是这样思考的。你的核心循环就是你完成的课程：上一课，获得奖励，延长连胜，第二天收到推送。
(01:05:29):
这是产品的核心循环，让它变得非常紧凑至关重要，因为人们需要一个可以坚持的习惯。然后你需要元游戏，对于 Duolingo 来说就是学习路径，也包括排行榜成就。这些是你努力追求的长期目标，让你有长期动力继续做这件事。最后，个人档案也至关重要，因为你会随着时间积累档案。
(01:05:51):
它是你在产品体验中投入的反映。当你搞定这三件事，你就能拥有一个相当成功的长期学习旅程。转到 Chess.com 这边，我们看到超过 75% 的新用户将自己归类为“完全不会下棋”或“初学者”。不幸的是，如果你是初学者，玩实时对战并不会感到很有趣。我们在数据中看到了这一点：不到三分之一的用户能赢下他们的第一局。当你输掉比赛时，用户留存率比赢球时低 10%。

---

### [01:06:29] [Lenny Rachitsky]

**English:**
That's not so bad, but at scale, that's bad.

**中文翻译:**
那还不算太糟，但在大规模情况下，这就很糟糕了。

---

### [01:06:31] [Albert Cheng]

**English:**
Yeah, and it could be worse. That's true. And so typically what a lot of mobile games will do is they'll just create a super simplified version of the game. It's harder for us to do at chess, and so without changing the rules of that, I think that's, I don't know, it's just very eye-opening to me when you're trying to learn something, whether that be language learning or chess or whatever, usually those first steps are fraught with a lot of self-doubt and reinforcement that you're not good at the thing. And so it pays to be very intentional to craft experiences that guide the user around that.

**中文翻译:**
是的，而且情况可能会更糟。通常很多手游会创建一个超级简化版的游戏。这在国际象棋中很难做到。在不改变规则的情况下，我认为——我不知道该怎么说——这对我来说非常具有启发性：当你尝试学习某样东西时，无论是语言还是象棋，最初的几步总是充满了自我怀疑，并且不断强化“我不擅长这件事”的认知。因此，非常有意识地设计引导用户度过这一阶段的体验是非常值得的。

---

### [01:07:09] [Lenny Rachitsky]

**English:**
Well, I can't help but ask, is there anything that helped that along?

**中文翻译:**
我忍不住想问，有什么方法能帮助缓解这一点吗？

---

### [01:07:12] [Albert Cheng]

**English:**
Yeah, so something we're experimenting right now is just like purely if you say that you're new to chess, we're going to craft a more delightful learn how to play experience as opposed to dropping into a live game, that's an example. Another is hiding your ratings for the first five times such that you're not seeing your rating plummet. So there's a lot of tips and tricks you can do.

**中文翻译:**
是的，我们现在正在实验的一件事是：如果你说你是国际象棋新手，我们会设计一个更愉悦的“学习如何玩”的体验，而不是直接把你扔进实时对局。这是一个例子。另一个是前五次隐藏你的等级分，这样你就不会看到自己的分数暴跌。所以有很多小技巧可以做。

---

### [01:07:29] [Lenny Rachitsky]

**English:**
I'm just imagining a little guide that's like, "Here's how you win."

**中文翻译:**
我正在想象一个小指南，上面写着：“这就是你赢球的方法。”

---

### [01:07:32] [Albert Cheng]

**English:**
Yeah, or play against a coach, play against a friend, play against a bot. There's a bunch of different avenues you could take.

**中文翻译:**
是的，或者和教练对弈，和朋友对弈，和机器人对弈。你可以采取很多不同的途径。

---

### [01:07:38] [Lenny Rachitsky]

**English:**
Well, what I'd love is play against someone real and here's where you should move. Just like, "Hey, here's we're going to help you win."

**中文翻译:**
我想要的是和真人对弈，然后系统提示：“你应该走这里。”就像是：“嘿，我们要帮你赢。”

---

### [01:07:45] [Albert Cheng]

**English:**
Like a hint in real-time?

**中文翻译:**
就像实时提示？

---

### [01:07:46] [Lenny Rachitsky]

**English:**
Yeah, yeah, yeah.

**中文翻译:**
对，对，对。

---

### [01:07:47] [Albert Cheng]

**English:**
I don't want to be playing with you then.

**中文翻译:**
那我可不想和你下棋。

---

### [01:07:50] [Lenny Rachitsky]

**English:**
Okay. Let me ask you a couple more questions. One is just zooming out a little bit, what's the most counterintuitive lesson you've learned about building products or building teams across the many companies you've worked at?

**中文翻译:**
好的。让我再问你几个问题。一个是稍微放大一点视角：在你工作过的这么多家公司里，关于构建产品或组建团队，你学到的最反直觉的教训是什么？

---

### [01:08:03] [Albert Cheng]

**English:**
Yeah, I've talked a lot about products. So maybe I'll flip to the team side for a bit. I think the standard way to hire and build a team is you fill out a JD, it's got a whole bunch of different characteristics that you're looking for. You typically will find a short list of companies that are kind of similar to yours, and then you try to hire for that, right? I think that's the typical default path that a lot of companies take.
(01:08:27):
And I was really struck by my experience working at some smaller startups or take Duolingo as an example, where over and over and over, I saw some of the highest performers just being people that had very high agency, had that clock speed, had that energy. Yes, they cared about the mission, but they didn't necessarily need to have deep experience on that matter. And in fact, sometimes that experience could be a crutch in certain ways, especially in this world where the grounds are shifting so fast with AI, a lot of your learned habits actually need to be intentionally discarded.
(01:09:01):
You need to have a beginner's mind on this type of stuff. So I think this is more true than ever, looking for people that respond and move quickly and think just faster and move faster. I think the fastest speed of learning, those types of companies are the ones that I want to bet on. I think those will end up surviving and thriving.

**中文翻译:**
是的，我谈了很多关于产品的内容。所以也许我转到团队方面聊聊。我认为招聘和组建团队的标准方式是填写一份职位描述（JD），列出一大堆你寻找的特征。你通常会找一堆和你公司类似的公司名单，然后尝试从那里挖人，对吧？我认为这是很多公司采取的典型默认路径。
(01:08:27):
但在一些小型初创公司或以 Duolingo 为例的工作经历让我深受触动。我一次又一次地看到，一些表现最出色的人往往是那些具有极高自主性（High Agency）、反应速度快且充满活力的人。是的，他们关心使命，但他们并不一定需要具备该领域的资深经验。事实上，有时经验在某些方面会成为一种阻碍，尤其是在 AI 飞速发展的今天。你学到的很多习惯实际上需要被刻意丢弃。
(01:09:01):
你需要对这类事物保持“初学者心态”。所以我认为现在比以往任何时候都更需要寻找那些反应迅速、行动迅速、思考更快、移动更快的人。我认为学习速度最快的公司才是我想下注的公司。我认为这些公司最终会生存并蓬勃发展。

---

### [01:09:25] [Lenny Rachitsky]

**English:**
So just to double click on this idea of high agency is very trending these days of just higher high agency people. To unpack that a little bit, you mentioned a few of these traits, so let's just help people see what you see. So one is clock speed, just they think fast, they move fast, they learn fast. What else? What else do you look for that helps you see that there are high agency people?

**中文翻译:**
所以，深入探讨一下“高自主性”（High Agency）这个概念，现在招聘高自主性的人非常流行。为了进一步拆解，你提到了其中的一些特质，让我们帮大家看看你所看到的。一是“时钟频率”，即他们思考快、行动快、学习快。还有什么？你还会寻找哪些特质来帮你识别高自主性的人？

---

### [01:09:49] [Albert Cheng]

**English:**
Yeah, a lot of it actually happens outside of the interview process interestingly. So a lot of it is the types of questions they asked, "Have they actually tried your product and gone deep into it?" A lot of it is, it's the references, it's the communication that they have to even set up your interview, it's the energy they bring into the conversation.
(01:10:09):
You can actually pick up a lot of soft signals on some of these traits over time. You've got to pick up on some of these patterns. I don't know that I'm perfect at it, but I've learned to balance those things quite a bit more than I did in the past when I would just purely read from my questions and my rubric and not care about anything else.

**中文翻译:**
有趣的是，很多其实发生在面试过程之外。很大程度上取决于他们问的问题类型：“他们真的试用过你的产品并深入研究过吗？”很大程度上取决于背景调查、他们安排面试时的沟通方式，以及他们带入对话中的能量。
(01:10:09):
随着时间推移，你实际上可以从这些特质中捕捉到很多软信号。你必须捕捉这些模式。我不敢说我做得完美，但我学会了比过去更多地去平衡这些因素，而不是像以前那样纯粹照着问题和评分表念，而不关心其他任何事情。

---

### [01:10:27] [Lenny Rachitsky]

**English:**
Yeah, there's like a vibes component to it. This is also support for the work trial way of interviewing versus just a talk interview where you have them actually work with you for a week or whatever.

**中文翻译:**
是的，这其中有一种“氛围感”的成分。这也支持了“试岗”（Work Trial）面试法，而不是仅仅通过谈话面试，即让他们实际和你一起工作一周左右。

---

### [01:10:36] [Albert Cheng]

**English:**
That's a great point.

**中文翻译:**
说得好。

---

### [01:10:38] [Lenny Rachitsky]

**English:**
Okay. One other question I wanted to ask you. You've worked at a bunch of different sizes of companies from startup to Grammarly, I don't know, you call it a big company, bigger company. Duolingo, I don't know how big is Duolingo?

**中文翻译:**
好的。我还想问你一个问题。你曾在各种规模的公司工作过，从初创公司到 Grammarly（我不知道你会称它为大公司还是较大的公司）。Duolingo，我不知道 Duolingo 有多大？

---

### [01:10:50] [Albert Cheng]

**English:**
There are about a thousand people.

**中文翻译:**
大约有一千人。

---

### [01:10:50] [Lenny Rachitsky]

**English:**
Okay, cool.

**中文翻译:**
好的，酷。

---

### [01:10:53] [Albert Cheng]

**English:**
But I worked at Google too to start my career.

**中文翻译:**
但我职业生涯开始时也在谷歌工作过。

---

### [01:10:55] [Lenny Rachitsky]

**English:**
Oh, right, okay. What have you learned about just the size of company that makes you happy? What have you learned about just helping other people that you talk to decide what size of company is good for them?

**中文翻译:**
噢，对，好的。关于什么样的公司规模能让你感到快乐，你学到了什么？关于帮助你交谈的人决定什么样的公司规模适合他们，你又学到了什么？

---

### [01:11:05] [Albert Cheng]

**English:**
I definitely believe that everyone has a company stage that they shine best at. I've personally gone through this journey of big tech to tiny, tiny, tiny startup, then landed in the middle, which I consider my own goal lock zone. I talked earlier about what actually gives me personally a lot of energy is seeing across a company's efforts, but also the company being small enough that I can get into the details, I can work with the specific teams.
(01:11:33):
I can read experiment results, I can look at the pixels. And so I find that the balance of those two things tends to fit best with medium-sized companies, but that's me, right? I think at big companies like a Google, you're dealing with immense scale, which is interesting by itself. You learn a lot of best practices from your peers. They have all the tools and functions that you would possibly want to go learn from, but they can tend to move slower and it's harder to ship things and get them out the door, which eventually drove me nuts a little bit.
(01:12:06):
On the flip end of the spectrum, these tiny startups, they move incredibly fast, but I grew all my gray hair from those tiny startups because no one knows about your company, and so you're recruiting people one by one. You're trying to get users one by one. So yeah, you can learn fast and ship a lot of things, but if you're trying to make a big impact on the world, it can be actually pretty grueling to do so at really, really, really small startups.
(01:12:29):
Now, some of them do hyperscale and make it out, and obviously, I am not one to trash that because the path that I tried for quite a while. But for me, I really like the zone where I can contribute at scale, but also execute at a pace that's more on the daily and weekly scale as opposed to monthly and quarterly.

**中文翻译:**
我绝对相信每个人都有一个最能让自己发光发热的公司阶段。我个人经历过从大厂到极小初创公司，最后落在了中间地带，我认为那是我的“金发姑娘区”（Goldilocks Zone，指最适宜的区域）。我之前提到过，真正能给我个人带来能量的是既能看到公司的整体努力，同时公司又足够小，让我能深入细节，与具体团队合作。
(01:11:33):
我可以阅读实验结果，可以查看像素细节。我发现这两者的平衡往往最适合中型公司，但这只是我的看法。我认为在像谷歌这样的大公司，你处理的是巨大的规模，这本身很有趣。你可以从同事那里学到很多最佳实践，他们拥有你可能想学习的所有工具和职能。但他们往往行动较慢，发布产品并推向市场更难，这最终让我有点抓狂。
(01:12:06):
在光谱的另一端，那些微型初创公司行动极快，但我的白头发都是在那些微型初创公司里长出来的，因为没人知道你的公司，你得一个一个地招人，一个一个地获取用户。所以，是的，你可以学得很快，发布很多东西，但如果你想对世界产生重大影响，在极小极小的初创公司里做这件事实际上是非常折磨人的。
(01:12:29):
当然，其中一些公司实现了超大规模增长并脱颖而出，显然我不是在贬低那条路，因为那是我尝试了很久的路径。但对我来说，我真的很喜欢那个既能在大规模上做出贡献，又能以日或周为单位（而不是月或季度）执行任务的区域。

---

### [01:12:50] [Lenny Rachitsky]

**English:**
And when you say medium, what size of company is that roughly?

**中文翻译:**
当你说明中型公司时，大约是什么规模？

---

### [01:12:53] [Albert Cheng]

**English:**
Yeah, so these companies that we've talked about in the podcast are about 500 to a thousand people. Typically, these companies who have been around let's say 10 to 20 years. They're durable, ideally profitable, have a good leadership team, but there's still a lot of dimensions to go figure out. A lot of them are in key inflection points, so they're certainly not stagnant. You need to find a place that's dynamic too.

**中文翻译:**
是的，我们在播客中谈到的这些公司大约有 500 到 1000 人。通常这些公司已经存在了 10 到 20 年。它们是长青的，理想情况下是盈利的，拥有优秀的领导团队，但仍有很多维度需要去探索。它们中的许多正处于关键的转折点，所以它们绝不是停滞不前的。你也需要找一个充满活力的地方。

---

### [01:13:17] [Lenny Rachitsky]

**English:**
Interesting, 10 to 20 years old, I don't know if that's a, not many people would feel like that's where I want to be. I love that you found a number of companies like that that you enjoyed working at. The last question, and this is going to be taking us to a recurring segment on the podcast that I call Failed Corner.
(01:13:35):
People hear all these stories of all these experiments and all these companies that worked at, they're all killing it up into the right. In reality, you've touched on this, a lot of things don't work out great. So can you share a story when something went wrong, when you failed and what that taught you?

**中文翻译:**
有趣，10 到 20 年历史，我不知道这是否——可能没多少人会觉得那是他们想去的地方。我很高兴你找到了几家这样的公司并乐在其中。最后一个问题，这将带我们进入播客的一个固定环节，我称之为“失败角落”（Failed Corner）。
(01:13:35):
人们听到了所有这些实验的故事，以及你工作过的所有这些公司，它们都在蓬勃发展。但现实中，你也提到过，很多事情并不顺利。你能分享一个出问题、失败的故事，以及它教会了你什么吗？

---

### [01:13:50] [Albert Cheng]

**English:**
First of all, in the growth world, you're failing all the time. So I'm not going to pick a specific growth story because those don't actually hit my ego too much. But earlier in my career I did a lot of core product work. I worked for this startup called Chariot. I don't know if you ever lived in San Francisco, but.

**中文翻译:**
首先，在增长的世界里，你无时无刻不在失败。所以我不会选一个具体的增长故事，因为那些其实不太伤我的自尊。但在职业生涯早期，我做了很多核心产品工作。我曾在一家名为 Chariot 的初创公司工作。不知道你是否在旧金山住过，但是……

---

### [01:14:05] [Lenny Rachitsky]

**English:**
Yes, it was like the bus super thing.

**中文翻译:**
是的，就是那个类似超级巴士的东西。

---

### [01:14:06] [Albert Cheng]

**English:**
The blue commuter shuttles, like 15-person shuttles, they would essentially drive from various neighborhoods into downtown San Francisco. It's a commuting use case across between the public bus system and an Uber and Lyft. So I was there for some time. I led product there and the core service was really loved by its users. It was reliable and fast and affordable enough, but we got pretty interested in this idea that maybe we can improve utilization, maybe we can make the service a little bit more innovative if we offer dynamic routes more similar to Uber and Lyft.
(01:14:46):
How could the drivers are driving these fixed routes? But if they have spare time, they can go out of their way, go pick up somebody at their house or something and keep going. So we tried this, we called the chair direct, really interesting attempt, but I learned a lot of lessons there because ultimately it didn't work out. One lesson is like this was kind of a solution searching for a problem. You never just purely want to chase A, it wouldn't it be nice if we did this as opposed to this is our user and this is the problem that we're solving, this is why it's going to delight them, et cetera, that's one.
(01:15:20):
Second is you got to consider, especially in these more marketplace type businesses, there's more than just one end user and we focus so much of our attention on the writer app without realizing, oh yeah, the drivers are carrying a lot of the brunt of this experience and our operations team is as well. And so when the drivers are confused or disgruntled, that can lead to a challenging overall experience for the product. So that's definitely another one.
(01:15:50):
And the third one is we did a lot of actually PR, prior to the service going out just to get the word out. And PR has its time in place, but I think doing it before you have validation that customers definitely want, the thing is quite risky and it can lead to a lot of sun cost once you get it out because you need to see it through, you want to see it succeed. So yeah, this is a decade ago, honestly, I had a great time at that company, but I still remember that vividly because it contained three or more key lessons that carried forward as I have built many products since then.

**中文翻译:**
那些蓝色的通勤班车，大约 15 人的小巴，它们基本上从各个社区开往旧金山市中心。这是一种介于公共巴士系统和 Uber/Lyft 之间的通勤场景。我在那里待了一段时间，负责产品。核心服务深受用户喜爱，它可靠、快速且价格合理。但我们对一个想法产生了兴趣：如果我们提供更类似于 Uber 和 Lyft 的动态路线，也许可以提高利用率，让服务更具创新性。
(01:14:46):
司机原本是跑固定路线的，但如果他们有空余时间，是否可以绕道去某人家门口接人，然后继续行驶？我们尝试了这一点，称之为 Chariot Direct。这是一个非常有趣的尝试，但我从中吸取了很多教训，因为最终它失败了。教训之一是：这有点像是在“拿着锤子找钉子”（Solution searching for a problem）。你永远不应该纯粹为了追求“如果我们做这个不是很好吗”而去做，而应该思考“这是我们的用户，这是我们要解决的问题，这是为什么它会让他们感到愉悦”。
(01:15:20):
第二点是，你必须考虑到，特别是在这种平台型业务中，终端用户不止一个。我们把太多的精力放在了乘客端 App 上，而没有意识到司机承担了这种体验的大部分压力，我们的运营团队也是如此。当司机感到困惑或不满时，会导致整个产品的体验变得极具挑战性。这绝对是另一个教训。
(01:15:50):
第三点是，我们在服务上线前做了大量的公关（PR）宣传。公关有其作用，但我认为在确认客户确实需要该产品之前就大肆宣传是非常冒险的。一旦发布，它会产生大量的沉没成本，因为你需要坚持下去，你想看到它成功。是的，那是十年前的事了，老实说我在那家公司过得很愉快，但我仍然记忆犹新，因为它包含了三个或更多关键教训，这些教训在我后来构建许多产品时一直受用。

---

### [01:16:28] [Lenny Rachitsky]

**English:**
Yeah, it feels like you went to the complete other end run experiments of everything before you tell anyone about it.

**中文翻译:**
是的，感觉你现在走到了另一个极端——在告诉任何人之前，先对所有事情进行实验。

---

### [01:16:33] [Albert Cheng]

**English:**
That's right.

**中文翻译:**
没错。

---

### [01:16:34] [Lenny Rachitsky]

**English:**
I remember the chariot bus showing up at the Airbnb office and people getting, I'm like, "What the hell is this?"

**中文翻译:**
我记得 Chariot 班车出现在 Airbnb 办公室门口，人们上车的情景，我当时想：“这到底是什么鬼？”

---

### [01:16:39] [Albert Cheng]

**English:**
That's right.

**中文翻译:**
没错。

---

### [01:16:40] [Lenny Rachitsky]

**English:**
Very cool. I didn't know you worked there. Albert, we've covered so much ground everything I was hoping we'd cover. Is there anything else that you wanted to cover, anything else you want to leave listeners with before we get to a very exciting lightning round?

**中文翻译:**
非常酷。我不知道你在那儿工作过。Albert，我们涵盖了这么多内容，所有我希望能聊到的都聊到了。在进入非常精彩的闪电轮之前，还有什么你想涵盖的内容，或者想留给听众的话吗？

---

### [01:16:56] [Albert Cheng]

**English:**
No, this is great. I hope it was useful for your listeners. I will say over the last few days, as I was prepping for this, I was honestly a little bit anxious about do I have enough deep independent frameworks that I need to come up with? But just being authentic to my actual experience at these companies, a lot of my lessons learned have been off of the backs of other people that have tried similar things and have succeeded or failed.
(01:17:21):
And I think what's important is that you have that your mental sponge. You can try a bunch of different things, you can absorb them and then put them in practice right away, discard the things that don't work and evolve them for yourself and for the company's needs. And so I don't know, I think that was just a realization that I had as I was thinking through this podcast, and I think that's partly why I haven't done too much public speaking.

**中文翻译:**
没有了，这很好。我希望这对你的听众有用。我想说，在过去的几天里，当我为此做准备时，老实说我有点焦虑：我是否有足够的深度独立框架可以分享？但忠于我在这些公司的实际经历，我学到的很多教训都是站在前人的肩膀上的，他们尝试过类似的事情，有的成功了，有的失败了。
(01:17:21):
我认为重要的是你要保持“心理海绵”的状态。你可以尝试很多不同的事情，吸收它们，然后立即付诸实践，丢弃那些无效的东西，并根据你自己和公司的需求进行演进。我不知道该怎么说，这只是我在思考这期播客时的一个感悟，我想这也是为什么我以前没做过太多公开演讲的部分原因。

---

### [01:17:45] [Lenny Rachitsky]

**English:**
I know exactly what you mean. When I left Airbnb, I was just like, and that was the first time I ever took a break in my career of 30 years of just working straight in school. I was just like, what have I actually learned? I've never just sat down and thought about, here's the thing I've learned. And that led me to writing this medium post that did really well what I learned at Airbnb, and then that basically led to what I do now. So there's a lot of power and I love that this is the excuse to make you think through what have I learned concretely that I can share.

**中文翻译:**
我完全明白你的意思。当我离开 Airbnb 时，那是我 30 年职业生涯（包括上学）中第一次休息。我当时想：我到底学到了什么？我从未坐下来思考过“这就是我学到的东西”。这促使我写了那篇在 Medium 上反响很好的文章《我在 Airbnb 学到了什么》，那基本上开启了我现在的事业。所以这其中有很大的力量，我很高兴这成为了一个借口，让你思考自己具体学到了什么可以分享的东西。

---

### [01:18:17] [Albert Cheng]

**English:**
That's right. Thank you for that.

**中文翻译:**
没错。谢谢你。

---

### [01:18:18] [Lenny Rachitsky]

**English:**
Yeah, and so at the beginning of this podcast, before I started recording, I always like to ask guests, what is your goal? What do you want to get out of this conversation? And usually, it's like we're hiring. We want to make sure people know about our company or we want to get the users. And your answer is just, I just want to give back things I've learned, which I love.

**中文翻译:**
是的。在这期播客开始录制之前，我总是喜欢问嘉宾：你的目标是什么？你想从这次对话中得到什么？通常答案是“我们在招聘”、“我们想让人们了解我们的公司”或者“我们想获取用户”。而你的回答只是“我只想回馈我学到的东西”，我非常喜欢这个回答。

---

### [01:18:36] [Albert Cheng]

**English:**
That's it.

**中文翻译:**
就是这样。

---

### [01:18:37] [Lenny Rachitsky]

**English:**
And you've done that. With that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
你已经做到了。至此，我们进入了非常精彩的闪电轮。我有五个问题要问你。准备好了吗？

---

### [01:18:44] [Albert Cheng]

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [01:18:45] [Lenny Rachitsky]

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
有哪些两三本书是你最常向别人推荐的？

---

### [01:18:51] [Albert Cheng]

**English:**
Yeah, so the truth of it is I have a, not just the four-year-old, but I also have a one-year-old. So most of the books that I'm reading these days are kids' books, trying to make them laugh in all.

**中文翻译:**
是的，事实是，我不仅有一个四岁的孩子，还有一个一岁的孩子。所以我最近读的大部分书都是童书，想方设法逗他们笑。

---

### [01:19:00] [Lenny Rachitsky]

**English:**
Wait, any favorite kids books? Because I have three or two year olds already.

**中文翻译:**
等等，有什么推荐的童书吗？因为我也有三岁和两岁的孩子。

---

### [01:19:03] [Albert Cheng]

**English:**
Well, you said that you started singing. There's a book called Snuggle Puppy that has a song in it that just makes my daughter crack up.

**中文翻译:**
既然你说你开始学唱歌了，有一本书叫《Snuggle Puppy》，里面有一首歌，每次都能让我女儿大笑。

---

### [01:19:11] [Lenny Rachitsky]

**English:**
Oh my God.

**中文翻译:**
噢，天哪。

---

### [01:19:11] [Albert Cheng]

**English:**
That is heartwarming for me. But no, a book that I recommended recently at work is Ogilvy on Advertising. Do you know this book?

**中文翻译:**
那对我来说很温馨。不过，我最近在工作中推荐的一本书是《奥格威谈广告》（Ogilvy on Advertising）。你知道这本书吗？

---

### [01:19:21] [Lenny Rachitsky]

**English:**
I don't know the book. I've seen these tenants of marketing or whatever.

**中文翻译:**
我不了解这本书。但我见过那些营销准则之类的。

---

### [01:19:23] [Albert Cheng]

**English:**
Yeah, it's interesting. So it's 40 years old, but it's just packed with a bunch of different practical examples about copy and creative that work in, these are old school ads, but he took a very experimentation-oriented approach to just try a lot of things.
(01:19:38):
I think in the book, it makes a good reminder that what ultimately matters is to compel your users to some action for him as buying a product, right? It's not about just creating clever ads or sexy creatives, it's to do things that compel that action. I think that's very true for many of our product and life cycle teams. And so I shared that around as an interesting recommendation.

**中文翻译:**
是的，很有趣。虽然它已经有 40 年历史了，但里面充满了关于文案和创意的各种实际案例。虽然那是老派广告，但他采取了一种非常注重实验的方法，尝试了很多东西。
(01:19:38):
我认为书里有一个很好的提醒：最终重要的是促使用户采取某种行动（对他来说就是购买产品）。这不仅仅是创造聪明的广告或性感的创意，而是要做那些能促成行动的事情。我认为这对我们的许多产品和生命周期团队来说非常适用。所以我把它作为一个有趣的推荐分享了出去。

---

### [01:20:02] [Lenny Rachitsky]

**English:**
Is there a movie or TV show? Sorry, were you going to share another book?

**中文翻译:**
有没有什么电影或电视节目？抱歉，你还要分享另一本书吗？

---

### [01:20:08] [Albert Cheng]

**English:**
Yeah, actually.

**中文翻译:**
是的，确实有。

---

### [01:20:10] [Lenny Rachitsky]

**English:**
Oh yes, please.

**中文翻译:**
噢，好的，请讲。

---

### [01:20:11] [Albert Cheng]

**English:**
Our co-founder at Chess.com, his name's Danny Rensch, and he is quite well known in the chess circles. He's releasing a memoir called Dark Squares, and it is super fascinating. He grew up in an abusive cult and was a chess prodigy. And so it is just this unbelievable story and I'm about halfway through it, it's a reminder that sometimes the people that you work with, you don't realize how deep their pasts go, but this is something else, and I think it should be out by the time this podcast releases.

**中文翻译:**
我们在 Chess.com 的联合创始人 Danny Rensch，他在国际象棋圈很有名。他要出一本回忆录叫《黑格》（Dark Squares），非常引人入胜。他在一个虐待性的邪教中长大，同时又是一个象棋神童。这是一个令人难以置信的故事，我读了一半。它提醒我们，有时你共事的人，你并不知道他们的过去有多深沉。这真的很特别，我想这本播客发布时，书应该已经出版了。

---

### [01:20:45] [Lenny Rachitsky]

**English:**
And it's called Dark Squares?

**中文翻译:**
叫《黑格》？

---

### [01:20:46] [Albert Cheng]

**English:**
Dark Squares.

**中文翻译:**
《Dark Squares》。

---

### [01:20:47] [Lenny Rachitsky]

**English:**
Which is a reference to the chess board and also I imagine the difficult past.

**中文翻译:**
这既是指棋盘上的黑格，我想也是指那段艰难的过去。

---

### [01:20:52] [Albert Cheng]

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:20:53] [Lenny Rachitsky]

**English:**
Wow. How cool. Okay. Are there movie or TV shows you really enjoyed that you've recently watched?

**中文翻译:**
哇，太酷了。好的。最近有没有什么你非常喜欢的电影或电视节目？

---

### [01:21:00] [Albert Cheng]

**English:**
These days it's football season, so I'm consumed by all the hot takes of my favorite teams that I love and the teams I love to hate as well, so.

**中文翻译:**
最近是橄榄球赛季，所以我沉迷于我热爱的球队以及我“爱恨交加”的球队的各种热门评论。

---

### [01:21:11] [Lenny Rachitsky]

**English:**
Who's your team?

**中文翻译:**
你的主队是谁？

---

### [01:21:13] [Albert Cheng]

**English:**
The 49ers. I have season tickets and I go all the time. We had a rough season last year, so hoping to turn around.

**中文翻译:**
旧金山 49 人队。我有季票，经常去现场。我们去年赛季很艰难，希望能扭转局面。

---

### [01:21:20] [Lenny Rachitsky]

**English:**
Okay, very cool. Okay. Is there a product you've recently discovered that you really love?

**中文翻译:**
好的，非常酷。有没有什么你最近发现并非常喜欢的产品？

---

### [01:21:25] [Albert Cheng]

**English:**
Yeah, so last 20 years of my life roughly, I've moved around a lot, but I've always been within walking distance of a coffee shop. It's just like a ritual that I go and get coffee and it starts my day, right? Two years ago, I bought a house and for the first time ever in my life I'm like not buy a coffee shop, and I was so depressed about this for a little while.
(01:21:45):
So my favorite product is the bread bowl barista, and it just starts my day off. I like making horrible latte art with it, and I think it's just a reminder. I don't know. The products that most impact me, I guess are the ones that I use all the time, and it's a daily habit-

**中文翻译:**
有的。在我过去大约 20 年的生活里，我搬过很多次家，但我总是住在步行即可到达咖啡馆的地方。去买咖啡是我开启一天的仪式。两年前，我买了一套房子，这是我人生中第一次没住在咖啡馆旁边，我为此郁闷了好一阵子。
(01:21:45):
所以我最喜欢的产品是 Breville Barista 咖啡机，它开启了我的每一天。我喜欢用它拉出很难看的花。我想这只是一个提醒。我不知道该怎么说，对我影响最大的产品往往是我一直使用的、成为日常习惯的产品。

---

### [01:22:05] [Lenny Rachitsky]

**English:**
And have the most caffeine.

**中文翻译:**
而且咖啡因含量最高。

---

### [01:22:06] [Albert Cheng]

**English:**
Then the most caffeine. You got it.

**中文翻译:**
没错，咖啡因最高。你懂的。

---

### [01:22:08] [Lenny Rachitsky]

**English:**
Amazing. Do you have a favorite life motto that you find yourself using in work or in life?

**中文翻译:**
太棒了。你有没有什么最喜欢的座右铭，是你经常在工作或生活中使用的？

---

### [01:22:14] [Albert Cheng]

**English:**
As I was thinking about my piano stories, I also remember that my mom used to have a quote. She just said, "Nothing is more important than your reputation." And she used to say this, and I think the charitable understanding of this is that a lot of the small decisions that you make each day, how do you treat people? How do you show up? What's your character, et cetera. They can compound and they open doors for you in many surprising and amazing ways.
(01:22:41):
A lot of these companies that have actually joined have come through relatively light connections. And even just being on this podcast, I think I've seen a number of folks that I've worked with before beyond the show. And so I think doing the right thing, building a good reputation, they can carry you a long way. And the flip side of that is reputations are fragile too, right? So if you do the wrong thing, take a long time to repair that. So I don't know, it just stuck with me my entire life. I thought that was an interesting life motto.

**中文翻译:**
当我在思考我的钢琴故事时，我也想起了我妈妈常说的一句话。她只是说：“没有什么比你的声誉更重要。”她以前常这么说。我认为对此最正面的理解是：你每天做的很多微小决定——你如何对待他人？你如何表现？你的性格如何等等——它们会产生复利，并以许多令人惊讶和奇妙的方式为你打开大门。
(01:22:41):
我加入的很多公司实际上都是通过相对较浅的人脉联系上的。甚至能上这个播客，也是因为我看到很多以前共事过的人也上过这个节目。所以我认为做正确的事，建立良好的声誉，能带你走很远。反过来说，声誉也是脆弱的，对吧？如果你做了错事，需要很长时间才能修复。我不知道该怎么说，这伴随了我一生。我认为这是一个很有趣的人生座右铭。

---

### [01:23:13] [Lenny Rachitsky]

**English:**
Last question. You work at Chess.com, how's your chess?

**中文翻译:**
最后一个问题。你在 Chess.com 工作，你的棋艺如何？

---

### [01:23:16] [Albert Cheng]

**English:**
Terrible compared to serious, serious players, but quite compared to the casual ones, yeah. My yellow rating is about 1,800 for a rabbit games.

**中文翻译:**
与严肃的专业棋手相比很糟糕，但与业余棋手相比还不错。我的 Elo 等级分在“快速对局”（Rapid）中大约是 1800 分。

---

### [01:23:25] [Lenny Rachitsky]

**English:**
It sounds really-

**中文翻译:**
那听起来真的——

---

### [01:23:27] [Albert Cheng]

**English:**
And about 1,500 for blitz. Yeah, but I play many times every day.

**中文翻译:**
在“超快棋”（Blitz）中大约是 1500 分。是的，但我每天都会下很多盘。

---

### [01:23:31] [Lenny Rachitsky]

**English:**
Blitz is like fast chess?

**中文翻译:**
Blitz 就是那种快棋？

---

### [01:23:32] [Albert Cheng]

**English:**
Blitz is like faster chess, three minute games. Rapid is more like a 10-minute game, which is still pretty fast.

**中文翻译:**
Blitz 是更快的棋，三分钟一局。Rapid 更像是十分钟一局，但也挺快的。

---

### [01:23:38] [Lenny Rachitsky]

**English:**
And you say you play multiple times a day? Do they make time? Is this like-

**中文翻译:**
你说你每天玩好几次？公司会给时间吗？这就像是——

---

### [01:23:42] [Albert Cheng]

**English:**
They do.

**中文翻译:**
他们确实给。

---

### [01:23:44] [Lenny Rachitsky]

**English:**
Okay. At Patagonia, there's a famous book, the founder wrote called Let My People Go Surfing, and the rule at Patagonia is you can go surfing if the waves are great. Is that how it works at Chess.com?

**中文翻译:**
好的。在 Patagonia，创始人写过一本著名的书叫《员工去冲浪》（Let My People Go Surfing），那里的规则是如果浪好，你就可以去冲浪。Chess.com 也是这样运作的吗？

---

### [01:23:53] [Albert Cheng]

**English:**
Absolutely.

**中文翻译:**
绝对是。

---

### [01:23:54] [Lenny Rachitsky]

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:23:55] [Albert Cheng]

**English:**
Chess is always fun. So we play all the time and they even have chess coaches on staff.

**中文翻译:**
下棋总是很有趣。所以我们一直在玩，公司甚至雇佣了全职的象棋教练。

---

### [01:23:59] [Lenny Rachitsky]

**English:**
Staff, just like you can book to do?

**中文翻译:**
全职员工？就像你可以预约的那种？

---

### [01:24:01] [Albert Cheng]

**English:**
You can book. So I get bi-weekly lessons and it's helping me improve.

**中文翻译:**
你可以预约。所以我每两周上一次课，这在帮我进步。

---

### [01:24:04] [Lenny Rachitsky]

**English:**
Wow. Okay. This is going to drive a lot of hiring for you guys. Saved it for the end. Albert, this was awesome. Thank you so much for doing this. Thanks so much for giving back and sharing all these stories. Two final questions, work and folks find you if they want to follow up on some of this stuff, and how can listeners be useful to you?

**中文翻译:**
哇。好的。这会吸引很多人想去你们那儿工作。留到最后才说。Albert，这太棒了。非常感谢你参加节目。非常感谢你的回馈和分享这些故事。最后两个问题：如果大家想跟进这些内容，可以在哪里找到你？听众能为你提供什么帮助？

---

### [01:24:22] [Albert Cheng]

**English:**
Yeah, thanks for having me. This was great. You can find me on LinkedIn or Twitter. Not a super active poster, but I read it all the time. If there's something that I said today that resonates with you and you just want to get in touch, trade notes, feel free to reach out.

**中文翻译:**
是的，谢谢邀请。这很棒。你可以在 LinkedIn 或 Twitter 上找到我。我不是一个超级活跃的发帖者，但我一直在看。如果我今天说的某些内容让你产生了共鸣，而你只是想联系一下、交流心得，欢迎随时联系。

---

### [01:24:36] [Lenny Rachitsky]

**English:**
And can they play with you on, can they find you on Chess.com to play?

**中文翻译:**
他们可以在 Chess.com 上找你下棋吗？

---

### [01:24:39] [Albert Cheng]

**English:**
They can.

**中文翻译:**
可以。

---

### [01:24:40] [Lenny Rachitsky]

**English:**
Okay. Do you want to share your username or you don't want that?

**中文翻译:**
好的。你想分享你的用户名吗？还是不想？

---

### [01:24:44] [Albert Cheng]

**English:**
I am happy to.

**中文翻译:**
我很乐意分享。

---

### [01:24:45] [Lenny Rachitsky]

**English:**
No. Okay.

**中文翻译:**
不，好的。

---

### [01:24:45] [Albert Cheng]

**English:**
I just mentioned that I'm a 49ers fan, so my username is Go9ers, so.

**中文翻译:**
我刚才提到我是 49 人队的粉丝，所以我的用户名是 Go9ers。

---

### [01:24:49] [Lenny Rachitsky]

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:24:50] [Albert Cheng]

**English:**
I'm sure I'll get a lot of game requests now.

**中文翻译:**
我敢肯定我现在会收到大量的对局请求。

---

### [01:24:52] [Lenny Rachitsky]

**English:**
Here we go. Here we go. 1,800. Okay. Albert, thank you so much for being here.

**中文翻译:**
开始了，开始了。1800 分。好的。Albert，非常感谢你能来。

---

### [01:24:56] [Albert Cheng]

**English:**
Yeah, thank you so much.

**中文翻译:**
是的，非常感谢。

---

### [01:24:58] [Lenny Rachitsky]

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这些内容有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这能真正帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。