# Alex Hardimen - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Alex Hardiman, Chief Product Officer at The New York Times.

---

### [00:00:00] Alex Hardiman

**English:**
One thing that's really interesting is that our impact and our business goals are in service of our mission, which is to seek the truth and help people understand the world, not the other way around. What it means is that the way that we think about impact is growing a giant subscription business. That business exists to strengthen an informed democracy at a time when people are struggling to understand basic facts and struggling to understand each other. That means that impact for us is growing subscribers, but it's also when a deeply reported story triggers an important policy change or a new law.

**中文翻译:**
非常有趣的一点是，我们的影响力（Impact）和业务目标都是为我们的使命服务的，即“寻求真理并帮助人们理解世界”，而不是反过来。这意味着，我们思考影响力的方式是建立一个庞大的订阅业务。而这项业务的存在，是为了在人们难以理解基本事实、难以相互理解的时代，加强一个信息通达的民主社会。这意味着，对我们来说，影响力不仅是增加订阅用户，还包括当一篇深度报道触发了重要的政策变革或新法律的诞生。

---

### [00:00:40] Alex Hardiman

**English:**
When you're a product manager, you're involved again in driving specific metrics like engagement or subscribers, but you're also trying to help stories find their real audience in ways that trigger just this whole different side of mission and purpose driven impact. I didn't feel that when I was at a place like Facebook.

**中文翻译:**
当你是一名产品经理时，你同样需要负责推动特定的指标，比如参与度或订阅数，但你也在努力帮助报道找到真正的受众，从而触发这种完全不同的、由使命和目标驱动的影响力。我在 Facebook 这样的地方工作时，并没有这种感觉。

---

### [00:01:00] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny and my goal here is to help you get better at the craft of building and growing products. Today, my guest is Alex Hardiman. Alex is Chief Product Officer at the New York Times where she leads teams that build the company's news, cooking, games, audio, and advertising products. Prior to this role, she was Chief Product Officer at The Atlantic, and before that, she spent two years at Facebook where she led their news product amongst other things. As you'll hear in our conversation, Alex has been at the center of the storm so many times, including at Facebook right after the 2016 election.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的能力。今天，我的嘉宾是 Alex Hardiman。Alex 是《纽约时报》（The New York Times）的首席产品官，她领导的团队负责构建公司的策划、烹饪、游戏、音频和广告产品。在此之前，她曾担任《大西洋月刊》（The Atlantic）的首席产品官，再之前她在 Facebook 工作了两年，负责新闻产品等业务。正如你在我们的对话中将听到的，Alex 曾多次处于风暴中心，包括 2016 年大选后的 Facebook。

---

### [00:01:33] Lenny

**English:**
Then, at the New York Times right as COVID hit. She hears so many stories and insights about how the New York Times builds product, what it's like for product teams to work with journalists, what's good and bad about working at a company like the New York Times versus FAANG tech type company, and also how they went about acquiring and integrating world. I had such a blast doing this interview and I hope that you enjoy it as much as I did. With that, I bring you Alex Hardiman. Today's episode is brought to you by Miro. Creating a product, especially one that your users can't live without is damn hard, but it's made easier by working closely with your colleagues to capture ideas, get feedback, and being able to iterate quickly.

**中文翻译:**
后来，她在新冠疫情爆发时回到了《纽约时报》。她分享了许多关于《纽约时报》如何构建产品的故事和见解，包括产品团队与记者合作的感受，在《纽约时报》这样的公司工作与在 FAANG（科技巨头）类公司工作的优劣，以及他们如何收购和整合 Wordle。这次采访非常愉快，我希望你们也能像我一样享受其中。下面，让我们欢迎 Alex Hardiman。本期节目由 Miro 赞助。创造一个产品，尤其是让用户离不开的产品，是非常困难的，但通过与同事紧密合作捕捉创意、获取反馈并快速迭代，会让这件事变得容易一些。

---

### [00:02:19] Lenny

**English:**
That's where Miro comes in. Miro is an online visual whiteboard that's designed specifically for teams like yours. I actually use Miro to come up with a plan for this very ad. With Miro, you can build out your product strategy by brainstorming with sticky notes, comments, slide reactions, voting tools, even a timer to keep your team on track. You can also bring your whole distributed team together around wire frames where anyone can draw their own ideas with pen tool or put their own images or mockups right into the Miro board. With one of Miro's ready made templates, you can go from discovery and research, to product roadmaps, to customer journey flows, to final mocks.

**中文翻译:**
这就是 Miro 的用武之地。Miro 是一个在线视觉白板，专为像你们这样的团队设计。实际上，我就是用 Miro 来策划这段广告的。通过 Miro，你可以利用便签、评论、幻灯片反应、投票工具，甚至计时器来进行头脑风暴，从而制定产品策略，让团队保持进度。你还可以让分散在各地的团队成员围绕原型图（Wireframes）聚集在一起，任何人都可以用画笔工具勾勒创意，或者直接将图片和模型放入 Miro 板中。利用 Miro 现成的模板，你可以完成从发现和研究、产品路线图、用户旅程图到最终模型的全过程。

---

### [00:02:57] Lenny

**English:**
Want to see how I use Miro? Head on over to my Miro board at miro.com/lenny to see my most popular podcast episodes, my favorite Miro templates. You can also leave feedback on this podcast episode and more. That's M-I-R-O.com/lenny. This episode is brought to you by Athletic Greens. I've been hearing about AG1 on basically every podcast that I listened to, like Tim Ferriss and Lex Fridman. I finally gave it a shot earlier this year and it has quickly become a core part of my morning routine, especially on days that I need to go deep on writing or record a podcast like this. Here's three things that I love about AG1. One, with a small scoop that dissolves in water, you are absorbing 75 vitamins, minerals, probiotics, and adaptogens.

**中文翻译:**
想看看我是如何使用 Miro 的吗？请访问我的 Miro 板块 miro.com/lenny，查看我最受欢迎的播客集数和我最喜欢的 Miro 模板。你还可以在那里留下对本期节目的反馈。网址是 M-I-R-O.com/lenny。本期节目由 Athletic Greens 赞助。我几乎在听过的每一个播客中都听说过 AG1，比如 Tim Ferriss 和 Lex Fridman 的节目。今年早些时候我终于尝试了一下，它迅速成为了我早晨例行活动的核心部分，尤其是在我需要深度写作或录制像这样的播客的日子里。关于 AG1，我有三点非常喜欢：第一，只需一小勺溶解在水中，你就能吸收 75 种维生素、矿物质、益生菌和适应原（Adaptogens）。

---

### [00:03:48] Lenny

**English:**
I like to think of it as a little safety net for my nutrition in case I've missed something in my diet. Two, they treat AG1 like a software product. Apparently, they're on their 52nd iteration and they're constantly evolving it based on the latest science, research studies, and internal testing that they do. Three, it's just one easy thing that I can do every single day to take care of myself. Right now, it's time to reclaim your health and arm your immune system with convenient daily nutrition. It's just one scoop and a cup of water every day, and that's it. There's no need for a million different pills and supplements to look out for your health.

**中文翻译:**
我把它看作是我营养摄入的一个小小安全网，以防我在饮食中遗漏了什么。第二，他们像对待软件产品一样对待 AG1。显然，他们已经进行了第 52 次迭代，并且不断根据最新的科学研究和内部测试进行演进。第三，这是我每天都能做的、非常简单的一件照顾自己的事。现在是时候重获健康，用便捷的每日营养武装你的免疫系统了。每天只需一勺粉末和一杯水，就这么简单。不需要为了健康去吃无数种不同的药丸和补充剂。

---

### [00:04:25] Lenny

**English:**
To make it easy, Athletic Greens is going to give you a free one-year supply of immune supporting Vitamin D and five free travel packs with your first purchase. All you have to do is visit athleticgreens.com/lenny. Again, that's athleticgreens.com/lenny. Take ownership over your health and pick up the ultimate daily nutritional insurance. Alex, thank you for being here. Welcome to the podcast.

**中文翻译:**
为了方便起见，Athletic Greens 将在你首次购买时免费赠送一年的免疫支持维生素 D 和五个旅行装。你只需访问 athleticgreens.com/lenny。重复一遍，网址是 athleticgreens.com/lenny。掌控你的健康，领取这份终极每日营养保险。Alex，感谢你的到来。欢迎来到本播客。

---

### [00:04:52] Alex Hardiman

**English:**
Thanks so much, Lenny. It's really awesome to be here with you.

**中文翻译:**
非常感谢，Lenny。很高兴能来到这里。

---

### [00:04:55] Lenny

**English:**
What's interesting is I think you may be the first product leader on this podcast who doesn't work at a big tech FAANG startup, and so I'm really excited to just dig into see what it's like to build product at a company like the New York Times.

**中文翻译:**
有趣的是，我想你可能是本播客中第一位不在大型科技巨头（FAANG）或初创公司工作的产品领导者，所以我非常兴奋能深入探讨在《纽约时报》这样的公司构建产品是什么感觉。

---

### [00:05:08] Alex Hardiman

**English:**
Thank you. No, no, that sounds awesome. Let's dive right in.

**中文翻译:**
谢谢。不，这听起来很棒。让我们直接开始吧。

---

### [00:05:12] Lenny

**English:**
Okay, before we dive in, I'd love to get a little bit of background on just your career. I'm curious, what was your career path to becoming the chief product officer at the New York Times?

**中文翻译:**
好的，在深入探讨之前，我想先了解一下你的职业背景。我很好奇，你是如何一步步成为《纽约时报》首席产品官的？

---

### [00:05:23] Alex Hardiman

**English:**
Thanks for asking. I've definitely spent most of my career right at the intersection of journalism and tech. I think in hindsight, if you were to ask my family, they probably wouldn't be that surprised, even though for me I was just rolling with it and following what felt like a really interesting set of problems to solve. But when I just look at my family, there is a ton of journalism in our DNA. My grandfather was a news anchor on the West Coast and I really revered him. My great-grandmother, she was pretty amazing. She actually started one of the first TV stations in the Midwest back in the '50s when it was still pioneering territory.

**中文翻译:**
谢谢你的提问。我职业生涯的大部分时间确实都花在了新闻和科技的交汇点上。回想起来，如果你问我的家人，他们可能不会感到惊讶，尽管对我来说，我只是顺其自然，去解决那些我觉得非常有趣的问题。但看看我的家庭，我们的基因里充满了新闻。我的祖父是西海岸的一名新闻主播，我非常崇敬他。我的曾祖母也非常了不起，她在 50 年代那个还是开拓性领域的时期，在美中地区创办了首批电视台之一。

---

### [00:06:01] Alex Hardiman

**English:**
For me, one of my first, the dream for me was to try to find a way to build things in the new space. That's how I first ended up at The New York Times. I've had two stints at The New York Times. My first stint was for a decade, from 2000 to 2016, and it was during a really interesting time of pretty big transformation. There's so much to talk about within that decade, but I would say there are two really big things that happened in that moment. The first was really trying to work with the company to shift from being a print first product into a mobile first product. If you go back to 2006 and you think about it, the Times had no mobile presence whatsoever.

**中文翻译:**
对我来说，最初的梦想之一就是尝试在新闻领域构建产品。这就是我最初进入《纽约时报》的原因。我在《纽约时报》工作过两个阶段。第一阶段长达十年，从 2000 年到 2016 年，那是一个非常有趣的转型期。那十年里有很多值得聊的，但我认为当时发生了两件大事。第一件是努力推动公司从“印刷优先”的产品转变为“移动优先”的产品。如果你回到 2006 年想想，当时《时报》根本没有任何移动端的业务。

---

### [00:06:40] Alex Hardiman

**English:**
Even the iPhone 2G and the App Store didn't come out I think until like 2008. We just really started investing in small mobile use cases, first on the margins and then more and more aggressively until we were just leading with mobile in everything that we did. New journalism formats, new product features, new revenue opportunities, that type of thing. Then, the second big thing that marked my journey at The New York Times was the shift to a direct to consumer subscription model. This was back in 2011, and there was just a lot of skepticism, including from people at The New York Times, about whether or not people would pay for quality journalism.

**中文翻译:**
我记得 iPhone 2G 和 App Store 直到 2008 年左右才出现。我们最初只是在边缘领域投资一些小的移动端用例，然后越来越激进，直到我们在所有工作中都以移动端为先。包括新的新闻格式、新的产品功能、新的收入机会等等。标记我在《纽约时报》历程的第二件大事是转向“直接面向消费者”（DTC）的订阅模式。那是 2011 年，当时有很多质疑声，包括来自《纽约时报》内部的人，大家都在怀疑人们是否会为高质量的新闻付费。

---

### [00:07:17] Alex Hardiman

**English:**
We brought in consultants and they said, "Maybe over the course of history it'll get to one million subscribers, if you're lucky." It felt like a really big nervous [inaudible 00:07:27] at the time. But thank goodness it helped make a market for paid journalism, that has really helped a lot of news organizations find new ways to support quality coverage. But after a decade I did what I think a lot of people did, was you look around and you say, "I love what I do, but I would love to go learn how to do product in the context of a product led digital first company." That's when I went to Facebook and I left in 2016.

**中文翻译:**
我们请来了顾问，他们说：“也许在整个历史进程中，如果你运气好，能达到 100 万订阅用户。”当时感觉压力非常大。但谢天谢地，它帮助开辟了付费新闻市场，这确实帮助了许多新闻机构找到了支持高质量报道的新途径。但在十年之后，我做了很多人的选择：环顾四周，心想：“我热爱我的工作，但我很想去学习在一个以产品驱动、数字化优先的公司里如何做产品。”于是我在 2016 年离开，去了 Facebook。

---

### [00:07:52] Alex Hardiman

**English:**
The timing is actually pretty important in terms of my experience at Facebook, because when I first joined Facebook, I totally left the media space. I was focused on building out a team that was really trying to help micro sellers in markets like India and other parts of APAC, who were coming online for the first time in really low bandwidth areas, and just wanted to sell their goods through social commerce. Really looking at what WhatsApp and Line and other regional competitors were doing. We were focused on business messaging and the interoperability of the Facebook apps from more of a small business perspective. It was really awesome work.

**中文翻译:**
就我在 Facebook 的经历而言，时机其实非常重要。因为当我刚加入 Facebook 时，我完全离开了媒体领域。我当时专注于组建一个团队，旨在帮助印度和亚太地区其他市场的微型卖家。这些人是在带宽非常低的地区第一次上网，只想通过社交电商销售商品。我们当时在研究 WhatsApp、Line 和其他区域竞争对手的做法。我们专注于商业消息传递以及 Facebook 旗下应用从小型企业角度出发的互操作性。那是一项非常棒的工作。

---

### [00:08:28] Alex Hardiman

**English:**
Then, the 2016 presidential election happened. I had only been there for a couple of months and as has been discussed very widely and reported widely, it was a wild time where there was just so much reckoning around misinformation, disinformation, election integrity, platform responsibility. I went over very quickly to help out on the news front where I led the product and engineering teams and it was really hard, really interesting work. I did that for a couple of years, decided-

**中文翻译:**
接着，2016 年总统大选发生了。我当时才去几个月，正如后来被广泛讨论和报道的那样，那是一个疯狂的时期，人们对错误信息、虚假信息、选举诚信和平台责任进行了大量的反思。我很快被调去协助新闻方面的工作，领导产品和工程团队。那是一项非常艰巨但也非常有趣的工作。我做了几年，然后决定——

---

### [00:08:58] Lenny

**English:**
Before we move on.

**中文翻译:**
在我们继续之前。

---

### [00:09:00] Alex Hardiman

**English:**
Yeah.

**中文翻译:**
好的。

---

### [00:09:00] Lenny

**English:**
I'm curious. Okay. Wait, you were leading the news product at Facebook during the election?

**中文翻译:**
我很好奇。等等，你在大选期间负责 Facebook 的新闻产品？

---

### [00:09:03] Alex Hardiman

**English:**
Right after the election.

**中文翻译:**
是在大选紧接着之后。

---

### [00:09:05] Lenny

**English:**
Right after the election, after everyone was coming after Facebook trying to tear it down?

**中文翻译:**
就在大选之后，在所有人都开始攻击 Facebook、试图拆解它的时候？

---

### [00:09:09] Alex Hardiman

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:09:09] Lenny

**English:**
Wow. What year was that?

**中文翻译:**
哇。那是哪一年？

---

### [00:09:13] Alex Hardiman

**English:**
I joined in early 2017 on that effort. The election was November, 2016.

**中文翻译:**
我是 2017 年初加入那个项目的。大选是在 2016 年 11 月。

---

### [00:09:19] Lenny

**English:**
Oh, my God. Before you move on, just what was that like? I don't know how one can describe that experience, but what do you think about when you think back to that time?

**中文翻译:**
天哪。在你继续之前，那是什么感觉？我不知道该如何描述那种经历，但当你回想起那段时光，你会想到什么？

---

### [00:09:28] Alex Hardiman

**English:**
I think about wartime product management, right? You're coming in, and I think there was ... What I appreciated about that time inside of Facebook was that there was just this incredible humility that was needed to really understand and first diagnose what was actually happening on the platform, and the approach to content on Facebook historically it was very binary. You basically had content from friends and family and then you had public contents. Public content could come from anywhere. It could come from a reputable news organization or it could come from my younger brother posting something and declaring it to be true.

**中文翻译:**
我想到了“战时产品管理”，对吧？你临危受命，我当时非常欣赏 Facebook 内部的一点是，我们需要一种极大的谦逊感去真正理解并首先诊断平台上到底发生了什么。历史上，Facebook 处理内容的方式是非常二元化的：基本上要么是来自亲友的内容，要么是公共内容。公共内容可能来自任何地方，可能来自信誉良好的新闻机构，也可能来自我弟弟发布的某条动态并声称它是真的。

---

### [00:10:06] Alex Hardiman

**English:**
What we really tried to do very quickly was try to unpack the categories of public content to say that there actually is something that is factually accurate information, and that requires a certain craft from the journalistic trade. There are ways to really look at what is trusted information, how you make that a little bit more essential and visible to people on the platform, while then reducing things that are at best dubious or at worse truly misleading propaganda. It was really fascinating and really hard just because the platform hadn't been built to think about classification of coverage in that way.

**中文翻译:**
我们当时努力在做的是迅速拆解公共内容的类别，明确指出确实存在“事实准确的信息”，而这需要新闻行业的专业技能。我们需要找到方法去识别什么是可信信息，如何让这些信息在平台上对用户更重要、更可见，同时减少那些充其量是可疑的、最坏情况是误导性宣传的内容。这非常迷人但也非常困难，因为这个平台在构建之初并没有考虑过以这种方式对报道进行分类。

---

### [00:10:44] Alex Hardiman

**English:**
Let alone to have the right goals and responsibilities and incentives. There was just a ton of work to figure out how to make the platform far safer and far more informative after, I would say, a pretty intense election cycle.

**中文翻译:**
更不用说还要建立正确的目标、责任和激励机制了。在经历了一个非常激烈的选举周期后，为了让平台变得更安全、更具信息量，我们做了大量的工作。

---

### [00:10:58] Lenny

**English:**
Yeah. I was going to ask you about this later, but I feel like you're drawn towards just crazy, wild and crazy center of the storm roles. I guess that one you didn't expect necessarily to become that. I imagine The New York Times has a lot of that, but maybe a quick question there. What have you learned about just living in a world of just constant chaos and stress and urgency, endless urgency?

**中文翻译:**
是的。我本来打算稍后再问这个，但我感觉你总是被那些疯狂的、处于风暴中心的角色所吸引。我猜那个职位你未必预料到会变成那样。我能想象《纽约时报》也有很多这样的时刻，但我想先问一个简短的问题：在这样一个充满持续混乱、压力和紧迫感（无止境的紧迫感）的世界里生活，你学到了什么？

---

### [00:11:21] Alex Hardiman

**English:**
I would say, if you did ask my family and my husband, he would say that I'm always attracted to the more chaotic problems. I just actually think that that's where product people thrive. The idea of being able to take all of these crazy inputs, trying to create a very structured model to figure out, "Okay, what is true? Where do we have conviction? Where do we have questions? What are the most important problems to solve? How do you prioritize? How do you get a team rallied around a shared context in one single goal? These are actually the conditions where product manager, I think, thrive.

**中文翻译:**
我想说，如果你问我的家人和丈夫，他会说我总是被那些更混乱的问题所吸引。我其实认为，这正是产品人茁壮成长的地方。能够接收所有这些疯狂的输入，尝试建立一个非常有条理的模型来弄清楚：“好吧，什么是真实的？我们在哪里有信心？我们在哪里有疑问？最需要解决的问题是什么？如何确定优先级？如何让团队围绕共同的背景和一个单一的目标团结起来？”我认为，这些正是产品经理大显身手的条件。

---

### [00:11:55] Alex Hardiman

**English:**
For me, just having been in the journalism space for about two decades now, it's just been or the tech space around news, it's just been a constant set of upheaval and transformation. Some things within our control, some things entirely outside of our control, and so I love it. For me, there's nothing else I'd rather be doing than trying to solve these problems in the world at scale. But it does take a certain amount of just grit and resilience, and the ability to really focus on the most important problems in a given moment. Also, the ability to let other things slide when you have to.

**中文翻译:**
对我来说，在新闻领域（或者说围绕新闻的科技领域）工作了大约二十年，这期间充满了不断的动荡和变革。有些事情在我们的控制之内，有些则完全在控制之外，但我热爱这一切。对我来说，没有什么比尝试在大规模范围内解决这些世界性问题更让我向往的了。但这确实需要一定的毅力和韧性，以及在特定时刻专注于最重要问题的能力。同时，在必要时也要有放手其他事情的能力。

---

### [00:12:32] Alex Hardiman

**English:**
But again, I feel like these are core product skills that we look for in terms of leadership and grit, and the ability to drive through really, really tough problems that there's no playbook for, nobody has ever really done before.

**中文翻译:**
但话说回来，我觉得这些正是我们所寻找的核心产品技能：领导力、毅力，以及在没有剧本、前无古人的情况下解决极其棘手问题的能力。

---

### [00:12:43] Lenny

**English:**
Yeah. You said PMs thrive in this. I think some do. Some are like, "No, leave me out of that."

**中文翻译:**
是的。你说产品经理在这种环境下茁壮成长。我想有些确实是，但有些可能会说：“不，别把我扯进去。”

---

### [00:12:48] Alex Hardiman

**English:**
I guess that's true.

**中文翻译:**
我想确实如此。

---

### [00:12:50] Lenny

**English:**
There's a metaphor I like to use when I give PM's advice on where to work within a company, which is there's like the Eye of Sauron, which is the number one most important thing to the CEO at that time. My advice is often don't avoid that thing, usually, but work maybe to the side of that because you don't want to work on something that doesn't matter, that's like over in the shire land. You want to be something that matters but not maybe the most important thing. I feel like you're the opposite. You're like, "Where's the Eye of Sauron focused? I'm going to go there and build stuff." That's pretty awesome.

**中文翻译:**
当我给产品经理关于在公司内部选择岗位的建议时，我喜欢用一个比喻：那里有“索伦之眼”（Eye of Sauron），也就是当时对 CEO 来说最重要的事情。我的建议通常是不要完全避开它，但也许可以选在它旁边工作。因为你不想做一些无关紧要的事情，就像待在“夏尔”（Shire，指偏远安逸之地）一样。你想做重要的事，但未必是那个最受关注的事。我觉得你恰恰相反，你会说：“索伦之眼盯着哪儿？我就去哪儿搞建设。”这真的很酷。

---

### [00:13:20] Alex Hardiman

**English:**
Awesome, sometimes, I'm sure there are moments too where it would be nice to chill, but I am drawn to those types of problems for sure. This feels like therapy, Lenny. I'm into it.

**中文翻译:**
有时候确实很酷，当然肯定也有想放松一下的时刻，但我确实被这类问题所吸引。Lenny，这感觉像是在做心理咨询，我很喜欢。

---

### [00:13:31] Lenny

**English:**
Tell me about your mother.

**中文翻译:**
跟我聊聊你母亲吧。

---

### [00:13:34] Alex Hardiman

**English:**
She's wonderful.

**中文翻译:**
她很棒。

---

### [00:13:37] Lenny

**English:**
Okay, great. That's the end of that one. I'll let you finish your career overview and then-

**中文翻译:**
好的，太棒了。这个话题到此为止。我让你继续讲完你的职业生涯概述，然后——

---

### [00:13:42] Alex Hardiman

**English:**
I feel like we're almost at present, which is I found that there was so much incredible experience that I was able to soak up and lean at a place like Facebook. For me, I really wanted to figure out how to apply that back into organizations that just had more of a classic journalistic mission and purpose, so I went to the Atlantic for a year. They had just been purchased by the Emerson Collective, so it was a really fun moment of just investment and expansion and ambition. We launched their consumer business. Then, I came back to The New York Times in late 2019, right before the pandemic, and I've been there ever since.

**中文翻译:**
我觉得快讲到现阶段了。我发现在 Facebook 这样的地方，我吸收并学习到了很多不可思议的经验。对我来说，我非常想弄清楚如何将这些经验应用回那些具有更经典新闻使命和目标的机构中，所以我去了《大西洋月刊》工作了一年。当时他们刚被 Emerson Collective 收购，那是一个充满投资、扩张和雄心的有趣时刻。我们启动了他们的消费者业务。然后，我在 2019 年底、就在疫情爆发前，回到了《纽约时报》，并一直留任至今。

---

### [00:14:19] Lenny

**English:**
Oh my, just your timing is impeccable every time.

**中文翻译:**
天哪，你每次的时机都选得无懈可击。

---

### [00:14:22] Alex Hardiman

**English:**
It really is.

**中文翻译:**
确实是。

---

### [00:14:24] Lenny

**English:**
I was doing some research on you before this chat and when you came back to The New York Times, there's all these stories about how big of a deal it was. Returns to The New York Times. That must have been something coming back, because you're there for 10 years initially, and then you came back. What was that experience like just coming back to something like that after being away?

**中文翻译:**
在这次聊天前我做了一些关于你的研究，当你回到《纽约时报》时，有很多关于这件事意义重大的报道。重返《纽约时报》。那一定很有感触，因为你最初在那里待了 10 年，然后又回来了。在离开一段时间后重新回到那样的地方，是什么样的体验？

---

### [00:14:43] Alex Hardiman

**English:**
I felt really lucky. When I left The New York Times back in 2016, it was on really, really good terms. It almost felt as like, I'm going on an externship and I really hope that one day I'll be able to come back and just do my job better. Because I do think there's real value in being able to do product in a bunch of different contexts. You're just so much better at pattern recognition, learning how to solve a diversity of problems, learning to work through things. I had a lot of great support when I left, which was really important. I don't think everyone necessarily has the privilege of that support when they exit a company. When I came back, it was just a real moment of excitement. My interview process, I joked with my boss at the time. But it did actually feel more like therapy.

**中文翻译:**
我感到非常幸运。2016 年我离开《纽约时报》时，双方的关系非常融洽。那感觉就像是我去参加一次“外派实习”，我真心希望有一天能回来，把工作做得更好。因为我确实认为，在不同的背景下做产品具有真正的价值。你会变得更擅长模式识别，学习如何解决多样化的问题，学习如何克服困难。我离开时得到了很多支持，这非常重要。我认为并不是每个人在离开公司时都能享有这种支持。当我回来时，那是一个真正令人兴奋的时刻。我的面试过程——我当时还跟老板开玩笑——其实感觉更像是一场心理咨询。

---

### [00:15:30] Alex Hardiman

**English:**
When you've worked with people for a decade before and you go in, the conversation isn't the normal list of interview questions. It's like, "Okay, here's what type of leader you were a couple of years ago. Here are the conditions on the ground now, how do you feel about X? How do you feel about Y? Are you still passionate about solving this? What else have you learned that's going to make you better?" It was wonderful. It was one of the best interview processes because you're talking to a bunch of people who knew what you were like when you were leading as a person at a different point in your career and they're pushing you to be better. I felt like I got the best chance of a lifetime to come back and try to do my job better than I had been able to do it before, and that's pretty cool.

**中文翻译:**
当你之前和这些人共事了十年，再次走进去时，对话不再是普通的面试问题清单。而是像：“好吧，这是几年前你作为领导者的样子。这是现在的实际情况，你对 X 怎么看？对 Y 怎么看？你对解决这个问题还有热情吗？你还学到了什么能让你变得更强的东西？”那感觉太棒了。那是我经历过的最好的面试过程之一，因为你在和一群了解你职业生涯不同阶段领导风格的人交谈，他们在推动你变得更好。我觉得我得到了人生中最好的机会，能够回来尝试把工作做得比以前更好，这真的很酷。

---

### [00:16:12] Lenny

**English:**
You've been there three years at this point?

**中文翻译:**
到目前为止你已经回去三年了？

---

### [00:16:14] Alex Hardiman

**English:**
Yeah, three years on Halloween, so coming up very soon.

**中文翻译:**
是的，到万圣节就满三年了，马上就到了。

---

### [00:16:18] Lenny

**English:**
Oh, wow. That's three days from now when we're recording. I wonder when this comes out. I'm curious, at a company like New York Times, which is, I imagine people think when they think product, they think it's the newspaper. At Airbnb we have this challenge where when we talk to hosts, "Here's the product." You're like, "What is your product? Is it our homes?" You have to help people understand, "Okay, when we talk product, we mean the website and app." What do you think of the product at The New York Times? Then, is it a challenge to help people understand, here's what the product team does?

**中文翻译:**
噢，哇。我们录音的时候离那天还有三天。我想知道这期节目什么时候播出。我很好奇，在像《纽约时报》这样的公司，我猜人们想到“产品”时，会觉得就是那份报纸。在 Airbnb，我们也面临这种挑战，当我们和房东谈论“这就是产品”时，他们会问：“你们的产品是什么？是我们的房子吗？”你必须帮助人们理解：“好吧，当我们谈论产品时，我们指的是网站和 App。”你如何定义《纽约时报》的产品？帮助人们理解产品团队的工作内容是否具有挑战性？

---

### [00:16:46] Alex Hardiman

**English:**
It's a really good question. At the most basic level, I would say that our product is our journalism, which we then marry with a really compelling and useful user experience, in a way that helps people really act on our journalism so that they can understand and engage with the world around them. For about 150 years, our product was pretty simple. It was a printed newspaper, which is still very beloved today, but the UX of the newspaper was, it was a predictable structure. It was a very finite amount of news. It was time bound, which I think is a really lovely thing in terms of setting expectation. It also has the packaging of the newspaper just such serendipity, where you can move across news, opinion, culture, games.

**中文翻译:**
这是一个非常好的问题。在最基础的层面上，我会说我们的产品就是我们的“新闻报道”，然后我们将其与极具吸引力且实用的用户体验相结合，从而帮助人们真正根据我们的报道采取行动，让他们能够理解并参与到周围的世界中。在大约 150 年的时间里，我们的产品非常简单：就是一份印刷报纸，直到今天它依然深受喜爱。但报纸的用户体验（UX）是可预测的结构，新闻量是有限的，且有时间限制，我认为在设定预期方面这非常棒。报纸的包装还带有一种“不期而遇”的惊喜感，你可以穿梭于新闻、观点、文化和游戏之间。

---

### [00:17:31] Alex Hardiman

**English:**
It's a really great bounded product in and of itself. But about 25 years ago, when we started shifting over to digital, the web, and mobile, the world just fully opened up in a way. We just saw this really tremendous disaggregation and distribution of our journalism. We really tried to meet the moment by building a wide array of products in the news space to extend our reach. Our products then, our digital products were our website, our apps, newsletters, we dabbled with a lot in the VR/AR space early on. That was, I would say, the first big extension of our products. When we then pivoted though to a subscription model, it was a really interesting moment where we actually had to take more of a destination first approach.

**中文翻译:**
它本身就是一个非常棒的有界产品。但大约 25 年前，当我们开始转向数字化、网页端和移动端时，世界在某种程度上完全敞开了。我们看到了新闻报道巨大的解构和分发。我们努力顺应时势，在新闻领域构建了广泛的产品以扩大触达范围。当时的数字化产品包括网站、App、时事通讯（Newsletters），早期我们还涉足了大量的 VR/AR 领域。我认为那是我们产品的第一次大扩张。然而，当我们转向订阅模式时，那是一个非常有趣的时刻，我们实际上必须采取一种“目的地优先”的方法。

---

### [00:18:15] Alex Hardiman

**English:**
It was almost like the beginning of us rebundling all of what we did, but on our own destination again, in digital destination. Because in order to build a really thriving subscription business, you really need a direct relationship with your customer as opposed to just relying on platforms to really distribute your coverage. That's where, again, we really started rebundling the breadth and depth of value that people once found in the Sunday newspaper at digital scale. Now, today, our product bundle includes even so much more than news, which I hope we'll talk about a little bit more later. We've really scaled our products in a bunch of different categories where we feel like we can really help people understand and engage with the world.

**中文翻译:**
这几乎就像是我们开始重新捆绑（Rebundling）我们所做的一切，但这次是在我们自己的数字化“目的地”上。因为要建立一个真正繁荣的订阅业务，你确实需要与客户建立直接关系，而不是仅仅依靠平台来分发你的报道。于是，我们开始在数字化规模上，重新捆绑人们曾经在《周日周报》中发现的价值广度和深度。如今，我们的产品捆绑包包含的内容远不止新闻，我希望稍后能多聊聊这个。我们在许多不同的类别中扩展了产品，我们觉得在这些领域可以真正帮助人们理解和参与世界。

---

### [00:18:57] Alex Hardiman

**English:**
We have cooking, we have games, we have sports, we have Wirecutter, which is a great innovation surface. We're playing with a new audio app all around audio journalism. We have now six fully fledged different product destinations. The next thing for us to do is to really figure out how to put those together into a bundle that really becomes the essential subscription for any curious English speaking person around the world, who really wants to know what's happening and wants to be able to, again, act and engage and make great decisions based on the products that we build.

**中文翻译:**
我们有烹饪、游戏、体育，还有 Wirecutter（产品评测网站），这是一个很棒的创新阵地。我们正在尝试一款全新的、围绕音频新闻的音频 App。我们现在拥有六个成熟的、不同的产品目的地。我们接下来的任务是弄清楚如何将这些产品组合成一个捆绑包，使其成为全球任何好奇的英语使用者“必不可少的订阅服务”——只要他们想了解时事，并希望根据我们构建的产品采取行动、参与其中并做出明智的决定。

---

### [00:19:36] Lenny

**English:**
Got it. It sounds like the strategy is a subscription bundle where you just keep bundling awesome stuff into this bundle. It's an obvious thing everyone has, whether you want cooking or games or The New York Times online.

**中文翻译:**
明白了。听起来策略就是一个订阅捆绑包，你们不断把很棒的东西塞进这个包里。这成了一个显而易见的选择，无论你是想要烹饪、游戏还是《纽约时报》在线版。

---

### [00:19:48] Alex Hardiman

**English:**
I think that's right. We did this pretty great exercise and strategy projects over the last year. We took a look and we said, "What is the largest addressable market where The New York Times can be truly valuable every single day to a group of people?" What we found was that there are about 135 million people around the world we believe are willing to pay for the type of high quality journalism based products that the New York Times produces, in the categories of news, gameplay, cooking and recipes, sports, which is why we acquired the athletic shopping recommendations and audio. In order for us to really capture as much of that audience and really serve them well, there are really three things that we need to do to make that essential subscription work.

**中文翻译:**
我想没错。去年我们做了一个非常棒的战略项目。我们审视并思考：“《纽约时报》每天能为一群人提供真正价值的最大潜在市场（TAM）是什么？”我们发现，全球大约有 1.35 亿人愿意为《纽约时报》生产的高质量新闻类产品付费，涵盖新闻、游戏、烹饪食谱、体育（这也是我们收购 The Athletic 的原因）、购物推荐和音频。为了真正吸引尽可能多的受众并服务好他们，要让这个“必不可少”的订阅服务奏效，我们确实需要做三件事。

---

### [00:20:37] Alex Hardiman

**English:**
The first is we absolutely need to have the best news destination in the world. When you think about the New York Times, we actually have the solar system metaphor where for us news is the sun in the sense that it's why we exist. It is what gives us our brand heritage and reputation. It's what instills trust. It's also where we just have the largest audience when you think about a funnel for our portfolio, and it's also where we just have the most amount of high quality coverage. But then that sun helps you give birth to other satellite planets or products that have a lot of the same DNA. Again, like great trusted journalism, great journalists who just have real expertise.

**中文翻译:**
第一，我们绝对需要拥有世界上最好的新闻目的地。当你想到《纽约时报》时，我们实际上有一个“太阳系”的比喻：对我们来说，新闻就是太阳，它是我们存在的意义。它赋予了我们品牌传承和声誉，建立了信任。从我们产品组合的漏斗来看，它也是受众最广的地方，也是我们高质量报道最集中的地方。然后，这颗“太阳”帮助孕育了其他“卫星行星”或产品，它们拥有许多相同的基因。比如，同样是值得信赖的优秀新闻，同样是拥有真正专业知识的优秀记者。

---

### [00:21:16] Alex Hardiman

**English:**
A great product experience that allows you to really unlock that value distribution reach, and the other ingredients that you would need for successful products to work. We're really focused on building out beyond news products that really help people engage with their passions and life needs that go beyond news. Then, the third thing is what you're describing as the bundle, how do we create a connected family of products that puts all of those things together so that wherever you come into the New York Times, to news or maybe through Wordle, you know that you're having the best experience within that category.

**中文翻译:**
优秀的产品体验能让你真正释放价值分发的触达力，以及成功产品所需的其他要素。我们正专注于构建新闻之外的产品，帮助人们投入到超越新闻的激情和生活需求中。第三件事就是你所说的“捆绑包”：我们如何创建一个相互连接的产品家族，将所有这些东西整合在一起，这样无论你是通过新闻还是通过 Wordle 进入《纽约时报》，你都知道自己在该类别中获得了最佳体验。

---

### [00:21:49] Alex Hardiman

**English:**
But then you also can quickly experience and discover everything else that we offer. That's the strategy and the vision, and it's a huge ambition. We want to get to 15 million subscribers by 2027. We're just over 9 million today, and I really think we can do it.

**中文翻译:**
同时，你也可以快速体验和发现我们提供的其他所有内容。这就是我们的战略和愿景，这是一个巨大的雄心。我们希望到 2027 年达到 1500 万订阅用户。今天我们刚刚超过 900 万，我真的认为我们可以做到。

---

### [00:22:06] Lenny

**English:**
Awesome. I actually wanted to chat about goals and how you think about success as a product team. I imagine the north star metric is what you just said, which is subscribers. If that's true, what other goals do you have across teams? Maybe even further, I'm packing a lot of questions into one question, but I'm curious just how your product team looks. How many PMs do you have? Roughly, how do you structure the teams? Then, roughly, what kind of goals do they all have to try and imagine the product team at New York Times?

**中文翻译:**
太棒了。我其实想聊聊目标，以及你如何衡量产品团队的成功。我猜“北极星指标”就是你刚才说的订阅用户数。如果真是这样，不同团队还有哪些其他目标？甚至更进一步——我把很多问题塞进了一个问题里——我很好奇你们的产品团队是什么样的。你们有多少名产品经理（PM）？团队结构大致如何？然后，他们各自的目标大致是什么，以便我能想象出《纽约时报》产品团队的样子？

---

### [00:22:34] Alex Hardiman

**English:**
Let's start with structure. First, I love this question talking about my team because I love hyping them. They're amazing, and our success is truly only as good as our people. Yeah, it is so true. For us, when we think about our org structure, the way to set that up so that our people can really do their best work is that we have two axis. We have functions and then we have missions. I oversee two functions, which is the functions of product and design. The functions themselves, it's normal of what you would find in terms of functional responsibilities. We focus on standards of craft and excellence, career growth, career frameworks, equitable promotion processes, community of practices, skill development, all of that.

**中文翻译:**
让我们从结构开始。首先，我非常喜欢关于我团队的问题，因为我喜欢夸奖他们。他们太棒了，我们的成功确实取决于我们的员工。是的，千真万确。对我们来说，在考虑组织结构时，为了让员工能发挥出最佳水平，我们设定了两个轴：职能（Functions）和使命（Missions）。我监管两个职能部门，即产品和设计。职能部门本身就是你通常能见到的那些职责：我们专注于专业技能和卓越标准、职业成长、职业框架、公平的晋升流程、实践社区、技能开发等等。

---

### [00:23:21] Alex Hardiman

**English:**
But missions is where a lot of the work happens. These are cross-functional teams, very similar to what we had at a place like Facebook. These cross-functional teams are led by usually a general manager, a product leader, or an engineering leader. They're all pursuing the same high level goals and objectives. Cross-functional missions at the Times, it can include a lot of the same skill sets that you would find at a tech company, PMs, engineers, designers, data scientists, researchers, product marketers. But the big difference is we also have editors, if it's a product space that directly shapes our journalism. I can talk more about that because it's a pretty interesting differentiating factor.

**中文翻译:**
但“使命”才是大部分工作发生的地方。这些是跨职能团队，非常类似于我们在 Facebook 看到的那种。这些跨职能团队通常由一名总经理、一名产品领导者或一名工程领导者领导。他们都追求相同的高层目标和指标。在《时报》，跨职能使命团队包含你在科技公司能看到的许多相同技能组合：PM、工程师、设计师、数据科学家、研究员、产品营销人员。但最大的区别是，如果该产品领域直接塑造我们的新闻报道，我们还会有“编辑”加入。我可以多聊聊这个，因为这是一个非常有趣的差异化因素。

---

### [00:24:02] Lenny

**English:**
Yeah, that's super interesting. There's a journalist within cross-functional product teams?

**中文翻译:**
是的，这超级有趣。跨职能产品团队里居然有记者？

---

### [00:24:05] Alex Hardiman

**English:**
Exactly. But we have three different types of missions. We have consumer missions, we have monetization missions, and we have platform missions. Editors are embedded within consumer missions. Those are the missions that I oversee, where we're focused on creating really great products, again, in categories like news, cooking, games, audio, et cetera. That is where having editors involved, particularly like editors who are very product minded, it brings in the best of their expertise and marries it with a lot of the normal signal that you look for in terms of data research and other insights. When you're trying to make sure that you understand a consumer problem and that you're really finding the best creative solution for it.

**中文翻译:**
没错。我们有三种不同类型的使命：消费者使命、商业化使命和平台使命。编辑被嵌入在消费者使命团队中。这些是我监管的使命，我们专注于在新闻、烹饪、游戏、音频等类别中创造出色的产品。在这些领域，让编辑参与进来——尤其是那些非常有产品思维的编辑——可以将他们的专业知识与你在数据研究和其他洞察中寻找的常规信号结合起来。当你试图确保自己理解消费者问题并寻找最佳创意解决方案时，这非常有用。

---

### [00:24:48] Lenny

**English:**
Cool.

**中文翻译:**
酷。

---

### [00:24:49] Alex Hardiman

**English:**
It is really cool. It's one of the, I think, most gratifying parts of working at a news organization like the Times. But if you work on a different mission, like a monetization mission, we have two really big ones. One is subscriber growth, the other one that's also really important is digital advertising. They build centralized commercial products that we can then scale across all of the products in our bundle. The subscriber growth team, for instance, they look at making sure that we have really great account ID management for subscribers. If you're buying a subscription through games or through news. Or, if you're on the digital advertising team, you're trying to make sure that we have a first party data program that's really privacy safe, that works as well in cooking as it does in the news space.

**中文翻译:**
确实很酷。我认为这是在《时报》这样新闻机构工作的最令人满足的部分之一。但如果你在不同的使命团队工作，比如商业化使命，我们有两个非常大的团队：一个是订阅增长，另一个同样非常重要的是数字广告。他们构建集中的商业产品，然后我们可以将其扩展到捆绑包中的所有产品。例如，订阅增长团队负责确保我们为订阅者提供出色的账户 ID 管理，无论你是通过游戏还是新闻购买订阅。或者，如果你在数字广告团队，你要确保我们有一个真正保护隐私的第一方数据计划，它在烹饪领域和在新闻领域同样有效。

---

### [00:25:33] Alex Hardiman

**English:**
Then, there's a totally different third bucket of mission that we have, which is all of our platform teams. This is everything from monetization platforms like our commerce engine, which is so important, because we're a subscription business, to data platforms where you might have our ML platform or experimentation tooling, to just basic infrastructure. Those are shared across the bundle, which just really helps make it so much easier, more efficient for really engineers to ship code and do their best work. A lot of this actually, I think, probably is pretty familiar to how you might organize at a tech company minus the editors.

**中文翻译:**
然后，我们还有完全不同的第三类使命，即所有的平台团队。这包括从商业化平台（如我们的电商引擎，这对订阅业务至关重要），到数据平台（如机器学习平台或实验工具），再到基础架构。这些是整个捆绑包共享的，这确实有助于让工程师更轻松、更高效地发布代码并发挥最佳水平。实际上，我觉得除了没有编辑之外，这其中的大部分内容与科技公司的组织方式非常相似。

---

### [00:26:14] Lenny

**English:**
Awesome. On that info piece, that reminds me of something I definitely wanted to talk about, which is something New York Times is really known for is the visualizations and these immersive stories that you all put out. I'm so curious just how that gets done. I feel like if I was on a product team at a regular, like a big tech FAANG company, I'd be like, "Shit, all these ad hoc things I got to do for all these stories, such a pain in the butt." That's so important to the New York Times and the online experience. I'm curious just like what is it like to build these things, say the election widgets, and all of that stuff?

**中文翻译:**
太棒了。关于信息这一块，这让我想起了一件我非常想聊的事，那就是《纽约时报》非常出名的可视化和沉浸式报道。我很好奇这些是怎么做出来的。我觉得如果我在一家普通的科技巨头公司做产品，我可能会想：“该死，为了这些报道我得做这么多临时性的（ad hoc）开发，真是麻烦透了。”但这对《纽约时报》和在线体验来说至关重要。我很想知道，构建这些东西——比如大选的小组件之类的——是什么感觉？

---

### [00:26:47] Lenny

**English:**
Then, I don't know, I was just reading a story about climate change and it's this really beautiful immersive story of just what is happening with the world. There's a bunch of questions there, but I guess roughly just how does that get done, something like that?

**中文翻译:**
还有，我刚才读了一篇关于气候变化的报道，那是一个非常精美的沉浸式故事，展示了世界正在发生的变化。这里有很多问题，但我猜大致想问的是，像这样的东西是如何完成的？

---

### [00:27:01] Alex Hardiman

**English:**
Well, first, thanks for saying that. I really appreciate it. I do think there's something really special about some of the ways that we marry the journalism and the presentation. I want to start just by giving credit where credit's due, which is I think some of the most interesting and inventive and compelling formats, they actually do start off as one-off experiments that are spun up in the newsroom by embedded teams that we have within graphics, visual journalism, interactive news teams. This is where we have editors, journalists, engineers, data scientists, designers, literally all hunkered down together focusing on how to make one story come to life in the best possible way.

**中文翻译:**
首先，谢谢你这么说，我很感激。我确实认为，我们将新闻报道与呈现方式结合的一些做法非常特别。我想先归功于那些该得荣誉的人：我认为一些最有趣、最具创意和吸引力的格式，最初其实是作为“一次性实验”开始的。这些实验是由我们嵌入在编辑部内部的图形、视觉新闻和互动新闻团队发起的。在这些团队里，编辑、记者、工程师、数据科学家、设计师真的会聚在一起，专注于如何以最佳方式让一个故事鲜活起来。

---

### [00:27:37] Lenny

**English:**
Who has the idea usually? Is it like the journalists working on that, they're like, "Hey, I think we should make something really great."

**中文翻译:**
通常是谁出的主意？是负责那篇报道的记者吗？他们会说：“嘿，我觉得我们应该做点非常棒的东西。”

---

### [00:27:42] Alex Hardiman

**English:**
Exactly. Yeah, one of the things ... We have a newsroom of over 2000 people. You basically have people who've been experts on certain beats like climate, for instance, for decades. They have the nugget of the idea. They start to do reporting and then they really pull in others from visuals, from interactive just to say, "How can I really make sure that I can tell this story with as much impact and weight as possible?" That's where the magic starts to happen, when you pull in all of those other skill sets together to help dream up how that story might be told.

**中文翻译:**
没错。我们有一个超过 2000 人的编辑部。你会有在某些领域（比如气候）深耕了几十年的专家。他们有了创意的火花，开始进行报道，然后他们会拉来视觉和互动团队的人，说：“我该如何确保这个故事讲得尽可能有影响力和分量？”当所有这些不同的技能组合在一起，共同构思如何讲述这个故事时，奇迹就开始发生了。

---

### [00:28:18] Lenny

**English:**
They're like, "Alex, we need one of these for our story. Can you get us on the list?" How does that process go?

**中文翻译:**
他们会说：“Alex，我们的报道需要一个这样的东西。你能把我们排进名单吗？”那个流程是怎么走的？

---

### [00:28:26] Alex Hardiman

**English:**
No, no, no. These are teams that are really autonomous in the newsroom. For one-off, truly special features, I'll give you an example of one that I found to be particularly powerful. I don't know if you read Jodi Kantor, who is one of our ... a really incredible investigative reporter. You might know for some of her work that she did around MeToo and Harvey Weinstein, in that investigation.

**中文翻译:**
不，不，不。这些团队在编辑部里是非常自主的。对于那些一次性的、真正特别的功能，我给你举一个我觉得特别震撼的例子。不知道你有没有读过 Jodi Kantor 的报道，她是我们的……一位非常了不起的调查记者。你可能知道她关于 MeToo 运动和哈维·韦恩斯坦（Harvey Weinstein）调查的一些工作。

---

### [00:28:46] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:28:47] Alex Hardiman

**English:**
She recently did a piece on how employers are tracking and monitoring remote workers with tools like productivity scores. The story itself was designed to show a person's own productivity score in the moment as they read the article.

**中文翻译:**
她最近写了一篇关于雇主如何利用“生产力评分”等工具跟踪和监控远程员工的文章。这篇报道本身的设计是，当读者阅读文章时，会实时显示读者自己的生产力评分。

---

### [00:29:02] Lenny

**English:**
Oh, shit.

**中文翻译:**
噢，天哪。

---

### [00:29:02] Alex Hardiman

**English:**
It was super visceral, really creepy in the most effective way. In my mind, that's the type of magical experience that only happens when you actually have dedicated designers, engineers, and others who can really sit down with a reporter to say, "Let's figure out how to shape that story in the most magical way." The speed of news is so fast that you don't have time to mess with roadmaps. We really have teams who are freed up from some of the normal processes around that, so they can really just focus on storytelling for really big stories and pieces. But on top of that, what we do have is a storytelling product team. What they do is they really take notice of things that are starting to work in more of the experimental phase, some of these one-offs.

**中文翻译:**
那感觉非常直观，甚至以一种最有效的方式让人感到毛骨悚然。在我看来，这种神奇的体验只有当你拥有专门的设计师、工程师和其他人员，能真正和记者坐下来讨论“让我们想办法以最神奇的方式塑造这个故事”时才会发生。新闻的速度太快了，你没时间去纠结产品路线图（Roadmaps）。我们确实有一些团队从常规流程中解放出来，这样他们就能专注于重大报道和文章的叙事。但除此之外，我们还有一个“叙事产品团队”。他们的工作是关注那些在实验阶段开始奏效的东西，也就是那些一次性的尝试。

---

### [00:29:50] Alex Hardiman

**English:**
Then, they work closely with editors to test and find product market fit for new formats that can actually scale across many parts of the report, so that over time when you open the app, the app is more accessible, more engaging, because we still have the traditional story based article, but we're also shifting more of the distribution of stories into video, into visuals, into live. If you even look at live, we've broken out of the tyranny of the article in many ways, where you have live reporter updates that are the size of length of tweets. People filing from the ground in Ukraine, trying to give you a sense of what's happening in a very immediate and real way.

**中文翻译:**
然后，他们与编辑紧密合作，测试并为新格式寻找“产品市场契合点”（PMF），使其能够扩展到报道的许多部分。这样随着时间的推移，当你打开 App 时，它会更易用、更吸引人。因为虽然我们仍有传统的基于文字的文章，但我们也正将更多的报道分发转向视频、视觉效果和直播。如果你看看直播，我们在很多方面打破了“文章”的束缚，你会看到记者的实时更新，长度就像推文一样。人们从乌克兰前线发回报道，试图以一种非常即时和真实的方式让你感受正在发生的事情。

---

### [00:30:31] Alex Hardiman

**English:**
That's where we do have teams, product teams who have to think in two modes. First, they have to be able to think in the moment with editors, where you might not always have all the right data at your fingertips and you just have to make a call, like, "What is the best experience to tell this story in a really truthful, accurate, accessible way?" Then, the other mode is when they're not shipping at the speed of news, they're trying to build end to end systems so that we're building the tooling to actually create the stories at the same time as the consumer experience, which is a totally different mode of system level thinking.

**中文翻译:**
这就是我们的产品团队必须以两种模式思考的地方。首先，他们必须能够与编辑一起进行即时思考，那时你手头可能并不总是有完整的数据，你必须做出决策，比如：“以真实、准确、易获取的方式讲述这个故事的最佳体验是什么？”另一种模式是，当他们不是以新闻的速度发布内容时，他们会努力构建端到端的系统，这样我们在构建消费者体验的同时，也在构建实际创作故事的工具。这是一种完全不同的系统级思维模式。

---

### [00:31:04] Alex Hardiman

**English:**
It's a very cool space. That product team is, they're pulling off some pretty incredible work because they can operate in those two modes. It's like, in the moment, in the moment of the story, but also trying to build the systems that allow you to reshape the composition of storytelling formats that we have across our products over time.

**中文翻译:**
这是一个非常酷的领域。那个产品团队正在完成一些相当不可思议的工作，因为他们能在这两种模式下运作。既能立足当下、服务于具体的故事，又能努力构建系统，让你随着时间的推移重新塑造我们产品中叙事格式的构成。

---

### [00:31:23] Lenny

**English:**
That is super cool. What percentage of these fancy stories are using that platform and building on something that already exists versus a one-off experiment would you say roughly?

**中文翻译:**
这超级酷。你会说这些精美的报道中，大约有多少比例是使用那个平台并在现有基础上构建的，而有多少是纯粹的一次性实验？

---

### [00:31:32] Alex Hardiman

**English:**
The majority are on our platforms hands down. Yeah. Yeah.

**中文翻译:**
绝大多数毫无疑问都是在我们的平台上构建的。是的。

---

### [00:31:36] Lenny

**English:**
Okay. That makes sense. Then, just so I understand, so you said Jodi was the journalist?

**中文翻译:**
好的，这说得通。那么，为了确认我理解正确，你提到的 Jodi 是那位记者？

---

### [00:31:41] Alex Hardiman

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:31:41] Lenny

**English:**
You mentioned. Does she has a product team dedicated to her work?

**中文翻译:**
你提到的。她有专门为她的工作服务的产品团队吗？

---

### [00:31:45] Alex Hardiman

**English:**
No, what we have is we have a centralized interactive news team, graphics team, data journalism team. Those editors partner with different journalists when they have really big stories to help bring their story to life.

**中文翻译:**
没有，我们拥有的是集中的互动新闻团队、图形团队和数据新闻团队。当记者有重大报道时，这些编辑会与不同的记者合作，帮助他们将故事生动地呈现出来。

---

### [00:32:00] Lenny

**English:**
I see. Do they have to come to this team and be like, "Hey, I'd love your time." How does that prioritization ... Because I imagine a lot of journalists are coming to them like, "Hey, my story is going to be awesome. We need you."

**中文翻译:**
明白了。他们是不是得去找这个团队说：“嘿，我需要你们的时间。”那个优先级是怎么定的？因为我能想象很多记者都会去找他们说：“嘿，我的报道会很棒，我们需要你们。”

---

### [00:32:10] Alex Hardiman

**English:**
You know what? To be totally honest, I'm not involved. Somehow it works.

**中文翻译:**
你知道吗？说实话，我并不参与其中。但不知怎么的，它运行得很好。

---

### [00:32:19] Lenny

**English:**
That a great leadership sign. It just works and you set it up and it's working, so that's great.

**中文翻译:**
这是一个伟大的领导力标志。它就是能运行，你搭建好了它，它就在运转，这太棒了。

---

### [00:32:25] Alex Hardiman

**English:**
Well, and the newsroom has set it up and something that is just, again, very interesting about the way that we are set up is that we have our newsroom and then we have our business side. The business side is where you have all of the product teams and there is intense collaboration between the two, but they do have different leadership structures because that's how we maintain the independence of our coverage. Our product teams sit within the newsroom if they're focused on storytelling, live, anything related to the coverage.

**中文翻译:**
嗯，编辑部也参与了搭建。关于我们的组织方式，还有一点非常有趣，那就是我们有编辑部，也有业务端（Business side）。业务端是所有产品团队所在地，两者之间有紧密的协作，但他们拥有不同的领导结构，因为这是我们保持报道独立性的方式。如果产品团队专注于叙事、直播或任何与报道相关的内容，他们会驻扎在编辑部内部。

---

### [00:32:54] Alex Hardiman

**English:**
The only distinction really that I think I'm trying to make is that product teams really help stories find their widest audience and be as engaging and as impactful as can be. But product teams don't have any influence over the selection of the stories. That is what the newsroom retains as editorial.

**中文翻译:**
我想强调的唯一区别是，产品团队真正帮助报道找到最广泛的受众，并使其尽可能具有吸引力和影响力。但产品团队对报道的选择没有任何影响力。那是编辑部保留的编辑自主权。

---

### [00:33:14] Lenny

**English:**
Okay. You mentioned Wordle and you all acquired Wordle recently. I'm just curious what that was all like. I imagine it's still being integrated. Were you involved in the exploration and purchase process and what went on there?

**中文翻译:**
好的。你提到了 Wordle，你们最近收购了它。我很想知道那是怎么一回事。我猜它还在整合中。你参与了考察和购买过程吗？当时发生了什么？

---

### [00:33:28] Alex Hardiman

**English:**
Wordle has been such a fun ride. Maybe I'll first just bring you behind the scenes on how the deal came to be, and then we can talk a little bit more about what the integration process has been like.

**中文翻译:**
Wordle 的历程非常有趣。也许我先带你看看这笔交易是如何达成的幕后故事，然后我们可以再多聊聊整合过程是怎样的。

---

### [00:33:37] Alex Hardiman

**English:**
I first heard about Wordle in early January because a New York Times reporter, Daniel Victor, actually wrote a piece about Josh Wardle, who's a software engineer in Brooklyn, and how he had created the game. It really is this gesture of love for his partner, and I certainly wasn't the only person to read through that column. Everyone inside the New York Times perked up. I remember reaching out to Jonathan Knight, who's the general manager of games, he's on my team. He had already taken notice well before the piece was published, and he had already reached out to Josh to see if he would be interested in having games join our portfolio.

**中文翻译:**
我第一次听说 Wordle 是在 1 月初，因为《纽约时报》的记者 Daniel Victor 写了一篇关于 Josh Wardle 的文章。Josh 是布鲁克林的一名软件工程师，文章讲述了他如何创造了这款游戏。这真的是他送给伴侣的一份爱意表达。我当然不是唯一读过那篇专栏的人。整个《纽约时报》内部的人都振奋起来了。我记得当时联系了游戏业务的总经理 Jonathan Knight，他在我的团队里。其实在文章发表前他就已经注意到了，并且已经联系了 Josh，询问他是否有兴趣让这款游戏加入我们的产品组合。

---

### [00:34:16] Alex Hardiman

**English:**
We just all loved Wordle immediately because if you've played it, it shares a lot of the DNA of other really successful word games that we have at the New York Times, like Spelling Bee or the Crossword Mini. If anything, Josh was really forthright that he created it because he was inspired by those games. Then, in the context of just our subscription strategy, games is such an important category for us. We really see games and demand for games as this, basically, it's a counterpoint to the news. It gives people a chance to actually take a break. It's fun. It doesn't feel like empty calories. It's really time well spent.

**中文翻译:**
我们立刻就爱上了 Wordle，因为如果你玩过它，你会发现它与《纽约时报》其他非常成功的文字游戏（如 Spelling Bee 或 Crossword Mini）有很多共同的基因。事实上，Josh 非常坦率地表示，他创造这款游戏就是受到了这些游戏的启发。此外，在我们的订阅战略背景下，游戏对我们来说是一个非常重要的类别。我们认为游戏和对游戏的需求基本上是新闻的一个“对位点”。它给人们一个休息的机会。它很有趣，而且感觉不像是在消耗“空热量”（指无意义的消遣），而是真正有意义的时间投入。

---

### [00:34:54] Alex Hardiman

**English:**
We were just thinking of Wordle as such a wonderful addition to our games franchise to really give people more reasons to feel like they had a relationship with the New York Times every day. The whole thesis of the acquisition just made so much sense. Our team just very quickly engaged with Josh and the acquisition talks were incredibly fast. The whole thing took place in a matter of weeks, which is way faster than any other acquisition I've been a part of. It was a very amicable process. We were just super delighted to bring Wordle on board, but it happened in record speed.

**中文翻译:**
我们当时觉得 Wordle 是我们游戏业务的一个绝佳补充，能让人们有更多理由感到每天都与《纽约时报》保持着联系。整个收购的逻辑非常通顺。我们的团队很快与 Josh 进行了接触，收购谈判的速度惊人地快。整个过程只用了几周时间，这比我参与过的任何其他收购都要快。过程非常友好。我们非常高兴能把 Wordle 纳入麾下，但它的发生速度确实创了纪录。

---

### [00:35:27] Lenny

**English:**
Well, yeah, it felt fast from the outside too. It became a huge deal. Then, "Okay, New York Times buys them." Yeah, it's impressive. You said you acquired Athletic. How often are you acquiring companies?

**中文翻译:**
嗯，是的，从外部看也觉得很快。它先是变得非常火爆，然后紧接着就是“好的，《纽约时报》买下了他们”。确实令人印象深刻。你提到你们还收购了 The Athletic。你们收购公司的频率有多高？

---

### [00:35:37] Alex Hardiman

**English:**
We also acquired The Athletic, and that was back in around the same time. I think for now we feel like we actually ... we have all of the major categories to make the essential subscription work. For us to get to 15 million subscribers we really feel like news, sports, games, cooking, audio and shopping, those are the categories, and we just have to make them the best possible versions of themselves, those products, so that we can really provide just tremendous value every day to people. That doesn't mean that we won't make some other acquisitions. The next Wordle would absolutely love to hear about it.

**中文翻译:**
我们还收购了 The Athletic，大约是在同一时间。我想目前我们觉得，为了让这个“必不可少”的订阅服务奏效，我们已经涵盖了所有主要类别。为了达到 1500 万订阅用户的目标，我们认为新闻、体育、游戏、烹饪、音频和购物就是核心类别。我们只需要让这些产品成为各自领域最好的版本，这样我们就能每天为人们提供巨大的价值。这并不意味着我们不会进行其他收购。如果有下一个 Wordle，我们绝对想了解一下。

---

### [00:36:14] Alex Hardiman

**English:**
But I do think there's also a real lesson for a lot of companies, not only about when you acquire what's the opportunity, but also are you ready to actually integrate an acquisition? We learned a lot just around Wordle in terms of what that process is like. I just want to say I'm really proud of how thoughtful and considerate our games team was about the integration process, because Wordle players feel such connection to the game. We really wanted to make sure not to interfere with the core magic of the experience. If you are an eight-year old kid or an 88-year old adult, there's real resonance with Wordle and people just have such a connection to it. We really wanted to make sure we didn't mess it up. Do you want to go a little bit deeper, just almost what that looks like?

**中文翻译:**
但我认为，对于很多公司来说，这其中也有一个真正的教训：不仅在于你收购时看到了什么机会，还在于你是否准备好真正整合一项收购？在 Wordle 的整合过程中，我们学到了很多。我想说，我为我们的游戏团队在整合过程中的周全考虑感到自豪，因为 Wordle 玩家对这款游戏有着深厚的情感连接。我们真的想确保不干扰体验的核心魔力。无论你是 8 岁的孩子还是 88 岁的老人，Wordle 都能引起共鸣，人们与它有着紧密的联系。我们真的想确保不把它搞砸。你想深入了解一下那具体是什么样的吗？

---

### [00:37:00] Lenny

**English:**
Yeah, absolutely.

**中文翻译:**
是的，当然。

---

### [00:37:01] Alex Hardiman

**English:**
Because we definitely learned a lot. When we acquired Wordle, it was a simple web game with no backend. That meant that people's stats and streaks, which was that was the value in terms of social currency that people were sharing after playing, those stats and streaks were stored in local browsers. It was really important for us to make sure that the game board experience in the core loop of the game remained unchanged. But we also found that because everything was stored locally and people care so much about their stats and streaks, if they got a new iPhone, if they switched browsers, all of a sudden they lost all of that history that they had with the game.

**中文翻译:**
因为我们确实学到了很多。当我们收购 Wordle 时，它只是一个没有后端的简单网页游戏。这意味着人们的统计数据（Stats）和连胜纪录（Streaks）——也就是人们玩完后分享的那种具有“社交货币”价值的东西——都存储在本地浏览器中。对我们来说，确保游戏面板体验和核心循环保持不变非常重要。但我们也发现，由于所有内容都存储在本地，而人们又非常在意自己的数据，如果他们换了新 iPhone 或更换了浏览器，突然之间他们就会失去所有的游戏历史。

---

### [00:37:39] Alex Hardiman

**English:**
What we decided to do was undertake a project to connect Wordle to a New York Times account, which was free, because Wordle is a free game, just so that it knows who you are and so that your stats and streaks can be protected. Then, we could also bring Wordle to more surfaces because we wanted ... if you go to the homepage of the news app or if you go to the games app, we wanted to make it easier to find because people would come for Spelling Bee or Crosswords and they also wanted their Wordle. It was a pretty big effort to rewrite Wordle in our tech stack, give people the ability to store their stats and streaks, bring games to all of our major surfaces.

**中文翻译:**
于是我们决定启动一个项目，将 Wordle 与《纽约时报》账户连接起来。这个账户是免费的，因为 Wordle 是一款免费游戏。这样做是为了让系统知道你是谁，从而保护你的统计数据和连胜纪录。然后，我们还可以将 Wordle 带到更多的界面上，因为我们希望……如果你去新闻 App 的首页或游戏 App，我们想让它更容易被找到，因为人们为了 Spelling Bee 或 Crosswords 而来时，也想要玩 Wordle。在我们的技术栈中重写 Wordle、让用户能够存储数据、并将游戏带到我们所有的主要界面，这是一项相当大的工程。

---

### [00:38:16] Alex Hardiman

**English:**
We just tried to do it in a thoughtful way, where we didn't break anything. The experience was hopefully seamless, and that the only thing you would notice that's changed is that the New York Times knows enough about who you are so that your stats carry over and you can play anywhere. But that doesn't mean that there aren't some surprises along the way, especially when you're doing backend work. We had this pretty crazy moment a couple months ago, right when the Supreme Court's draft ruling on Roe v. Wade leaked. An engineer on the games team happened to notice that the Wordle solution the next day was fetus. Which is just an extraordinarily bad coincidence, because the word had been loaded into the game by the game founder months beforehand.

**中文翻译:**
我们努力以一种周全的方式来做这件事，确保不破坏任何东西。我们希望体验是无缝的，你唯一能注意到的变化是《纽约时报》知道了你是谁，这样你的数据就能同步，你可以在任何地方玩。但这并不意味着过程中没有意外，尤其是在做后端工作时。几个月前我们遇到了一个非常疯狂的时刻，就在最高法院关于“罗诉韦德案”（Roe v. Wade）的裁决草案泄露时。游戏团队的一名工程师偶然发现，第二天的 Wordle 答案竟然是“胎儿”（fetus）。这真是一个极其糟糕的巧合，因为这个词是游戏创始人几个月前就加载进游戏里的。

---

### [00:39:02] Alex Hardiman

**English:**
It was so important for us that we didn't have ... this lovely diversion from the news feel almost like it was commentary on a very contentious story that was happening. I don't know if you caught wind of that, but you'd think that you could easily change the word on the backend, but because we were midstream on the migration process and some users were on the original Wordle game, others had migrated to the new version. It meant that we actually couldn't change the word on the backend for everyone, only for some people. This was a moment where we just had to come out and really tell the world, "We're mid integration. We're really not trying to communicate more than Wordle being a fun diversion from the news. Here's what happened, and why."

**中文翻译:**
对我们来说，确保这个原本用来从新闻中解脱出来的“可爱消遣”不要看起来像是在评论当时发生的极具争议的事件，这一点至关重要。我不知道你有没有听说这件事，你可能会觉得在后端改个词很容易，但因为我们当时正处于迁移过程的中期，一些用户还在原版 Wordle 上，另一些已经迁移到了新版本。这意味着我们实际上无法为所有人更改后端的词，只能为部分人更改。在那一刻，我们不得不站出来告诉全世界：“我们正处于整合中期。我们真的没想表达什么，Wordle 只是一个有趣的新闻消遣。这是发生的事情及其原因。”

---

### [00:39:50] Alex Hardiman

**English:**
Everyone understood. This is where coming out being really transparent about the facts and in some cases just exposing more about the product development process really helps demystify some of the rumors that people might otherwise think. It was one of those like, "Oh, man, I couldn't have imagined that that type of terrible coincidence would happen." But you just have to be prepared for everything, even when you're integrating what should just be a fun game.

**中文翻译:**
大家都理解了。这就是站出来对事实保持透明的意义，在某些情况下，仅仅是披露更多关于产品开发过程的信息，就能真正帮助消除人们可能产生的谣言。那是那种“天哪，我无法想象会发生这种糟糕的巧合”的时刻之一。但你必须为一切做好准备，即使你只是在整合一款本该很有趣的游戏。

---

### [00:40:16] Lenny

**English:**
Imagine, no matter what you tell people, some folks are just not going to believe a very simple explanation of what was going on.

**中文翻译:**
想象一下，无论你告诉人们什么，总有些人就是不相信对所发生事情的简单解释。

---

### [00:40:23] Alex Hardiman

**English:**
It's true. All you can do is be as honest and transparent. What I will say is a lot of people still think we try to make Wordle harder, we don't, I promise. It's not a thing.

**中文翻译:**
确实如此。你所能做的就是尽可能诚实和透明。我想说的是，很多人仍然认为我们试图让 Wordle 变得更难，我保证，我们没有。没这回事。

---

### [00:40:33] Lenny

**English:**
Yeah, it's not like the crossword puzzle where it gets harder every day of the week.

**中文翻译:**
是的，它不像填字游戏那样，一周里的每一天都会变得越来越难。

---

### [00:40:38] Alex Hardiman

**English:**
No, no. It's not, it's not.

**中文翻译:**
不，不。它不是那样的。

---

### [00:40:43] Lenny

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold.

**中文翻译:**
本期节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。如果你的企业在云端存储任何数据，那么你很可能已经被问到或将被问到关于 SOC 2 合规性的问题。SOC 2 是一种证明你的公司采取了适当安全措施来保护客户数据的方式，它能建立客户和合作伙伴的信任，尤其是那些有严格安全要求的客户。此外，如果你想向企业销售产品，证明安全性至关重要。SOC 2 既可以为你打开更大、更好交易的大门，也可能让你的业务停滞不前。

---

### [00:41:17] Lenny

**English:**
If you don't have a SOC 2, there's a good chance you won't even get a seat at the table. Beginning a SOC 2 report can be a huge burden, especially for startups. It's time consuming, tedious, and expensive. Enter Vanta, over 3000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time, Lenny's Podcast listeners get $1,000 off of Vanta.

**中文翻译:**
如果你没有 SOC 2，你很有可能连谈判桌都上不了。启动 SOC 2 报告可能是一个巨大的负担，尤其是对于初创公司。它耗时、乏味且昂贵。Vanta 出现了，超过 3000 家快速增长的公司使用 Vanta 来自动完成高达 90% 的 SOC 2 相关工作。Vanta 可以在几周内而不是几个月内让你做好安全审计准备，时间不到通常所需的三分之一。在限定时间内，Lenny 播客的听众可以享受 Vanta 1000 美元的折扣。

---

### [00:41:49] Lenny

**English:**
Just go to vanta.com/lenny. That's V-A-N-T-A.com/lenny to learn more and to claim your discount. Get started today. Are there any other stories that come to mind that reflect just how interesting/wild it is to work at the New York Times as a product leader?

**中文翻译:**
只需访问 vanta.com/lenny。即 V-A-N-T-A.com/lenny 了解更多信息并领取折扣。今天就开始吧。还有其他让你想到的故事，能反映出作为产品领导者在《纽约时报》工作是多么有趣或疯狂吗？

---

### [00:42:12] Alex Hardiman

**English:**
If we could of go back to when I started at the New York Times, because I started in late 2019, it was just right before the pandemic. It was pretty wild to come back to the company and to get shifted into this moment of needing to build products that really were trying to help people through the moment. At a time when our journalists were covering the story and all of New York Times' employees were trying to live through it. It was COVID 24/7 in terms of work and life. For me, I remember in the earliest days when we were first really reporting on COVID and learning about it, we had reporters on the ground in Wuhan even before we knew how COVID was transmitted.

**中文翻译:**
如果我们能回到我刚加入《纽约时报》的时候，因为我是 2019 年底加入的，正好在疫情爆发前。回到公司并立即进入那个需要构建产品来真正帮助人们度过难关的时刻，这非常疯狂。当时我们的记者在报道这个故事，而所有《纽约时报》的员工都在努力挺过去。无论是工作还是生活，都是 24 小时全天候的 COVID。对我来说，我记得在最早的日子里，当我们第一次真正报道 COVID 并了解它时，甚至在我们知道 COVID 如何传播之前，我们就已经有记者在武汉现场了。

---

### [00:42:52] Alex Hardiman

**English:**
Then, when the world shut down, for the Times, we went fully remote in March, 2020, and I remember the day so well because it was the beginning of spring break, of course, all plans were canceled. My kids, I had no idea what to do with them. My husband and I panic packed, put them in a car, drove to go see some friends in Vermont, and we decided we were going to do a kid daycare pool share just to figure out how to keep working with someone overseeing the kids. We got there late at night and I literally just went into a laundry closet and I didn't emerge for two weeks because my Slack was blowing up about all of the work that we needed to do to make our products as useful as possible.

**中文翻译:**
然后，当世界停摆时，对于《时报》来说，我们在 2020 年 3 月进入了全面远程办公。我非常清楚地记得那天，因为那是春假的开始，当然，所有计划都取消了。我完全不知道该拿我的孩子们怎么办。我和丈夫惊慌失措地收拾行李，把他们塞进车里，开车去佛蒙特州看望一些朋友，我们决定搞一个“拼凑式托儿所”，以便在有人照看孩子的情况下继续工作。我们深夜到达那里，我直接钻进了一个洗衣房的壁橱里，整整两周没出来，因为我的 Slack 消息爆炸了，全是关于我们需要做哪些工作来让我们的产品尽可能发挥作用。

---

### [00:43:32] Alex Hardiman

**English:**
The kids were being crazy and we just had to get to work. What was really stunning about this moment in time was that as people were getting sick and we were reporting about all of the trends that we were seeing, we saw that other institutions, especially the government, were not actually stepping up to help people understand the basic facts about what was happening. This is a product leader, it's a real wartime moment where you just need to blow up roadmaps, share context with everyone and say, "Okay, everyone, we have a totally different mandate than what we did a couple weeks ago." Given the needs in the world and the mission of the New York Times and our purpose, which is to help people access information to make informed decision about their lives, we're going to do a whole bunch of these things.

**中文翻译:**
孩子们闹翻了天，而我们必须投入工作。那个时刻真正令人震惊的是，随着人们纷纷生病，我们在报道所看到的趋势时，发现其他机构，尤其是政府，实际上并没有站出来帮助人们了解正在发生的事情的基本事实。作为一名产品领导者，这是一个真正的“战时时刻”，你只需要炸掉原有的路线图，向所有人分享背景信息并说：“好了，各位，我们的任务与几周前完全不同了。”鉴于世界的需要以及《纽约时报》的使命和宗旨——即帮助人们获取信息以对生活做出明智决定——我们将要做一系列这样的事情。

---

### [00:44:17] Alex Hardiman

**English:**
We're going to build a comprehensive public data set of COVID cases. Nobody else is doing it. We really just started scraping and pulling this together, and what was a single spreadsheet at the time. We pulled a bunch of engineers from other teams to go help build out that database. We launched entirely new formats and data tools to make our journalism a lot more easier to follow. Things like tools to be able to look up infection rates and eventually vaccination rates down at your local zip code level. We made our most important COVID coverage free to everybody. It was really important that if it was something related to public safety, we didn't put it behind a paywall.

**中文翻译:**
我们要建立一个全面的 COVID 病例公共数据集。没有人在做这件事。我们真的就开始抓取并汇总这些数据，当时只是一个简单的电子表格。我们从其他团队抽调了一群工程师来协助构建那个数据库。我们推出了全新的格式和数据工具，让我们的新闻报道更容易理解。比如可以查询你所在邮政编码级别的感染率，以及后来的疫苗接种率的工具。我们将最重要的 COVID 报道对所有人免费开放。这一点非常重要：如果是关乎公共安全的内容，我们不会将其置于付费墙之后。

---

### [00:44:53] Alex Hardiman

**English:**
Our mission is to do better than that. We really made sure that we had that information available to everyone. We also just found that for journalists who hadn't actually been in Wuhan, they just needed tips to an internal safety guidance for reporting, and so we made that publicly available. It was just one of those really interesting moments where everything felt so crazy in this moment of crisis. But building purposeful products that made a really difficult moment feel not only possible but promising, was one of the most unifying moments, I would say, for our teams.

**中文翻译:**
我们的使命要求我们做得更好。我们确实确保了每个人都能获得这些信息。我们还发现，对于那些没去过武汉的记者，他们需要内部安全报道指南的建议，于是我们也将其公开了。在那个危机时刻，一切都感觉如此疯狂，那真的是一段非常有趣的时光。但构建那些有目标感的产品，让一个极其艰难的时刻不仅变得可行，甚至充满希望，我认为那是我们团队最团结的时刻之一。

---

### [00:45:29] Alex Hardiman

**English:**
Because even though people were working so hard and balancing work life and personal life, no one doubted for a second that the work they were doing was of greater good for the world. There's real privilege in being able to spend your time doing those things. But it's one of the biggest news stories of our lifetime and to be at the forefront of that, I think for all of us, was a pretty incredible and humbling experience.

**中文翻译:**
因为尽管人们工作得非常辛苦，还要平衡工作和个人生活，但没有一个人怀疑过他们所做的工作是为了世界的更大利益。能够花时间做这些事情是一种真正的荣幸。这是我们一生中最大的新闻事件之一，能够站在报道的最前沿，我认为对我们所有人来说，都是一段非常不可思议且令人谦卑的经历。

---

### [00:45:55] Lenny

**English:**
Wow. People talk about having impact and driving impact and it's usually like, move this metric some percentage, but that is some incredible impact. Helping people avoid COVID, avoid dying, keeping their families safe. It's got to be some of the most fulfilling work that you and your team has done and ideally it wouldn't have happened, but it was also probably incredibly fulfilling.

**中文翻译:**
哇。人们常说要有影响力、推动影响力，通常是指将某个指标移动几个百分点，但那才是真正惊人的影响力。帮助人们躲避 COVID，避免死亡，保护家人的安全。这一定是你和你的团队做过的最有成就感的工作之一。理想情况下，这种事最好不要发生，但它确实可能带来了极大的成就感。

---

### [00:46:20] Alex Hardiman

**English:**
Thank you for saying that. One of the most validating tricks that we did look at was we realized that at the height of the pandemic, when there was just so much confusion about literally what to do, how to live each day in March, 2020, we saw that half of the country came to the New York Times. There is something again that is just so powerful about very straightforward data journalism, deep reporting, service guidance on how to make a mask if you don't have one. Just like all of these basics. Just seeing the whole organization pivot from their normal job into this mode and was pretty incredible, and the world responded, which was really validating too.

**中文翻译:**
谢谢你这么说。我们看到的一个最能证明价值的现象是，我们意识到在疫情最严重的时候，当 2020 年 3 月人们对该做什么、每天该怎么生活感到极度困惑时，我们看到全美有一半的人来到了《纽约时报》。非常直观的数据新闻、深度报道、关于如果没有口罩该如何自制的实用指南，这些东西再次展现了巨大的力量。看到整个组织从日常工作转向这种模式，真是不可思议，而世界的反馈也确实证明了我们的价值。

---

### [00:47:00] Lenny

**English:**
I imagine there's also a bit of burnout that happens working, where it goes on and on and on. You're like, "Oh, my God, when is this going to slow down?" How do you help people avoid burnout? How do you catch burnout as a leader on a product team?

**中文翻译:**
我能想象在工作中也会出现一些倦怠（Burnout），因为事情没完没了。你会想：“天哪，这什么时候才能慢下来？”你如何帮助人们避免倦怠？作为产品团队的领导者，你如何察觉到倦怠？

---

### [00:47:15] Alex Hardiman

**English:**
This is one of the most honestly, hard and important topics that I think we're always still grappling with. As a company, we really did try to lead originally with giving people more time off, more support, like financial support and other assistance with daycare, health benefits, all of the basics. I think now what we're really trying to do beyond that is be so much more focused on the things that we need to do and all of the things that we're really happy to stop doing. Because part of, I think, context switching is one of the things that is really, really difficult. It's hard to context switch in your job.

**中文翻译:**
老实说，这是我认为我们一直在努力应对的最困难也最重要的课题之一。作为一家公司，我们最初确实尝试通过给员工更多假期、更多支持（如经济支持、托儿协助、健康福利等基础保障）来引导。我想现在除了这些，我们真正努力在做的是更加专注于我们需要做的事情，以及所有我们乐于停止去做的事情。因为我认为，“上下文切换”（Context switching）是真正困难的事情之一。在工作中频繁切换关注点很难。

---

### [00:47:53] Alex Hardiman

**English:**
It's really hard to context switch across your job and your life. There are a lot of things that we as a company can't necessarily control in people's lives, but within the job, the places where we can be so much more focused and thoughtful about the small number of important things that we must do at a given point in time, that's really the place where we're really trying to come in and be as empathetic and as honest about what we need to do and what we don't need to do. A lot of it really comes down to, I think, making hard calls. We're not always perfect at it. I'm sure that there are things that we could be more diligent about.

**中文翻译:**
在工作和生活之间进行上下文切换也非常难。作为一家公司，我们未必能控制人们生活中的很多事情，但在工作范围内，我们可以更加专注和周全地考虑在特定时间点必须做的少数几件重要事情。这正是我们努力切入的地方，对我们需要做和不需要做的事情保持共情和诚实。我认为，这在很大程度上归结为做出艰难的抉择。我们并不总是完美的，我相信有些事情我们可以做得更细致。

---

### [00:48:27] Alex Hardiman

**English:**
But I would say over on balance, we've seen a lot of people stay at the company because they're figuring out they work remotely, maybe they come back to the office. They're figuring out how to live their life in a very different way from a couple of years ago. We're really here to try to meet them and make that as possible as possible. We need incredible people across a bunch of different skill sets, a bunch of different backgrounds. The only way to do that is to really be very flexible and accommodating in terms of trying to meet people where they are in their lives, but it's tricky.

**中文翻译:**
但总的来说，我们看到很多人留在了公司，因为他们正在摸索远程办公，或者偶尔回到办公室。他们正在摸索如何以一种与几年前完全不同的方式生活。我们在这里努力配合他们，让这种生活方式尽可能成为可能。我们需要拥有各种技能组合、各种背景的优秀人才。做到这一点的唯一方法就是在尝试满足人们生活现状方面保持极大的灵活性和包容性，但这很微妙。

---

### [00:49:03] Alex Hardiman

**English:**
There is no perfect answer for this, but we're really trying because the success of the company only works when we have people who feel valued and they can do their best work and live really rich lives on top of that. I think we're all still figuring out what that looks like now that we're starting to come out of the official pandemic and really just learning how to live with COVID.

**中文翻译:**
这件事没有完美的答案，但我们一直在努力，因为只有当员工感到被重视、能发挥最佳水平并过上丰富的生活时，公司的成功才有意义。我想我们所有人仍在摸索这到底意味着什么，尤其是现在我们开始走出官方定义的疫情期，真正学习如何与 COVID 共存。

---

### [00:49:23] Lenny

**English:**
Right, absolutely. You mentioned that you're all remote now. Is that the policy going forward?

**中文翻译:**
对，没错。你提到你们现在全是远程办公。这是未来的政策吗？

---

### [00:49:29] Alex Hardiman

**English:**
We actually just started going back into the office a couple of days per week, which is very encouraged. We're still finding our groove. We do have a good number of people though who are fully remote as well. It's more of an evolution in terms of trying to find the right balance of taking advantage of in-person work, because there are some moments where it really does make such a difference when you have people together working through hard problems in real life. That camaraderie, those relationships really, really do matter. Also, being realistic about the fact that there are a lot of people who would love to work at the New York Times, but might not be able to live in the New York City area.

**中文翻译:**
实际上我们刚刚开始每周回办公室几天，这是非常受鼓励的。我们仍在寻找节奏。不过，我们确实也有相当一部分人是完全远程的。这更像是一个演变过程，旨在寻找利用面对面工作的最佳平衡点。因为在某些时刻，当大家聚在一起在现实生活中解决难题时，确实会产生很大的不同。那种同僚情谊和人际关系真的非常重要。同时，我们也要面对现实：有很多人非常想在《纽约时报》工作，但可能无法住在纽约市地区。

---

### [00:50:11] Alex Hardiman

**English:**
So, how do we make sure that we can be a remote friendly company for them too? Yeah, so we're very hybrid, we're still testing our way through it. But by and large, we're shipping so much tremendous work, which I think is a reflection of us being able to do the hybrid thing and just try to get better and better at it each day, each week.

**中文翻译:**
那么，我们如何确保对他们来说也是一家远程友好的公司呢？所以，我们现在是非常混合（Hybrid）的模式，仍在不断测试。但总的来说，我们发布了这么多出色的工作，我认为这反映了我们能够处理好混合办公，并努力让它每天、每周都变得越来越好。

---

### [00:50:30] Lenny

**English:**
Yeah, it's hard. As an outsider, I can't imagine a New York Times being all remote. It feels like that kind of company just, it's all happening in a building somewhere probably. I'm also a big fan of in-person, it feels like as a company, it feels like you have an advantage if you're working in-person generally.

**中文翻译:**
是的，这很难。作为一个局外人，我无法想象《纽约时报》完全远程办公。感觉那样的公司，所有事情大概都发生在一栋大楼里的某个地方。我也是面对面办公的忠实粉丝，感觉作为一家公司，通常如果你面对面工作，会拥有一种优势。

---

### [00:50:46] Alex Hardiman

**English:**
We certainly see that, and so the center of gravity is in New York and is in the office, but again, with a lot of flexibility for people's lives. We're really trying to figure out that balance.

**中文翻译:**
我们确实看到了这一点，所以重心依然在纽约，在办公室里，但同时也为人们的生活提供了很大的灵活性。我们正努力寻找那个平衡点。

---

### [00:50:58] Lenny

**English:**
Just a couple more questions before we get to our very exciting lightning round. Where's the New York Times in the next five, 10 years as a product specifically different from other folks? Then, broadly, I don't know, if you have any insights or opinions on just what is the future of news, do share.

**中文翻译:**
在进入非常令人兴奋的闪电问答环节之前，还有最后几个问题。在未来 5 到 10 年里，《纽约时报》作为一个产品，与其他人相比会有什么特别之处？另外，从广义上讲，如果你对新闻的未来有什么见解或看法，请分享一下。

---

### [00:51:13] Alex Hardiman

**English:**
I think the New York Times is in a pretty unique spot compared to other news organizations right now. I have tremendous respect for other high quality organizations like The Journal and The Post and The FT and The Guardian. They're just doing such incredible work. But when I go back to what differentiates us, it's this idea of becoming an essential subscription that really helps people. It meets their most important news and life needs across all of the categories that we've been talking about, like news, games, audio, cooking, et cetera.

**中文翻译:**
我认为与目前其他新闻机构相比，《纽约时报》处于一个非常独特的位置。我对其他高质量机构如《华尔街日报》、《华盛顿邮报》、《金融时报》和《卫报》怀有巨大的敬意，他们正在做着不可思议的工作。但回到我们的差异化点，那就是成为一个真正能帮助人们的“必不可少”的订阅服务。它满足了人们在所有我们讨论过的类别中最重要的新闻和生活需求，如新闻、游戏、音频、烹饪等。

---

### [00:51:44] Alex Hardiman

**English:**
Up until, I would say, this year we were more of a news brand with a collection of adjacent lifestyle products, but with the acquisition of Wordle and the Athletic, along with just the continued growth of cooking and Wirecutter and some of our other offerings, I really do think that has transformed us into a brand capable of really being that essential subscription that helps every single day people with news and life needs in a way that doesn't just associate the New York Times with [inaudible 00:52:12] categories. Imagine that you open the New York Times app and you are starting with a great breaking news story. Then, you skip over to the latest coverage in China.

**中文翻译:**
我想说，直到今年之前，我们更多是一个带有一系列相邻生活方式产品的新闻品牌。但随着对 Wordle 和 The Athletic 的收购，加上烹饪、Wirecutter 和我们其他产品的持续增长，我真的认为这已经将我们转变为一个能够真正成为“必不可少订阅”的品牌。它每天在新闻和生活需求方面帮助人们，而不仅仅让人们把《纽约时报》与单一类别联系起来。想象一下，你打开《纽约时报》App，先读了一篇精彩的突发新闻，然后跳转到关于中国的最新报道。

---

### [00:52:25] Alex Hardiman

**English:**
Then, you decide that you want to take a small break to play Spelling Bee, and then you want to plan a Korean dinner party with Eric Kim, who I don't know if you know has some of the best Korean recipes. He's amazing. Then, you're like, "Wow, I need a rice cooker to be able to make that recipe, so I need to go get the best recommendation from Wirecutter."

**中文翻译:**
接着，你决定休息一下玩玩 Spelling Bee，然后你想和 Eric Kim 一起策划一场韩式晚宴——我不知道你是否认识他，他有一些最棒的韩餐食谱，他太出色了。然后你会想：“哇，我需要一个电饭煲来做那个菜，所以我得去 Wirecutter 看看最好的推荐。”

---

### [00:52:43] Lenny

**English:**
I just did exactly that, actually.

**中文翻译:**
实际上，我刚才真的就是这么做的。

---

### [00:52:45] Alex Hardiman

**English:**
Did you?

**中文翻译:**
是吗？

---

### [00:52:45] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:52:47] Alex Hardiman

**English:**
Then, I would love to go watch the Britney Spears documentary, which is also part of the New York Times franchise, which is amazing. Or, I want to go listen to Kevin Roose and Casey Newton's Hard Fork podcast, which is wildly fun and just launched a couple weeks ago, if you haven't heard that. This is, I think, the future for us of being a connected family of products, where we can meet so many different needs that are first anchored in news, but then stretched into other facets of your lives. I don't really see other news organizations really operating at that scale and that ambition, and that's the future for us.

**中文翻译:**
然后，我还想去看布兰妮·斯皮尔斯的纪录片，那也是《纽约时报》系列的一部分，非常精彩。或者，我想去听 Kevin Roose 和 Casey Newton 的《Hard Fork》播客，那非常有趣，几周前刚上线，如果你还没听过的话。我认为这就是我们的未来：成为一个相互连接的产品家族，我们可以满足许多不同的需求，这些需求首先锚定在新闻上，然后延伸到你生活的其他方面。我还没看到其他新闻机构真正以这种规模和雄心在运作，这就是我们的未来。

---

### [00:53:24] Alex Hardiman

**English:**
We really just think that the New York Times can mean so much more to so many more people. We're a journalism company, but we're building just tremendous software, and so the product ambitions are only getting bigger and bigger, and that's why I feel like I've got the luckiest job in the world right now.

**中文翻译:**
我们真的认为《纽约时报》可以对更多的人产生更深远的意义。我们是一家新闻公司，但我们正在构建极其出色的软件，因此产品的雄心只会越来越大。这就是为什么我觉得我现在拥有世界上最幸运的工作。

---

### [00:53:42] Lenny

**English:**
That is a compelling vision. I feel like you can build your own metaverse in the New York Times where you just spend all of your days inside the New York Times' suite of products.

**中文翻译:**
这是一个非常引人入胜的愿景。我觉得你可以在《纽约时报》里建立自己的元宇宙（Metaverse），让人们整天都待在《纽约时报》的产品套件里。

---

### [00:53:52] Alex Hardiman

**English:**
Can I say though, there is a big difference. I think that for us our software actually helps people with real world outcomes in a very different way. We basically help you get access to information, decide how you're going to go to the ballot box. We give you information to go cook. Actually, there's something that I think is even more of a connection to the physical world, and it is very different from what the Metaverse is doing, but that's where we feel like we can drive as much impact as possible.

**中文翻译:**
但我得说，这其中有很大的不同。我认为对我们来说，我们的软件实际上以一种非常不同的方式帮助人们获得现实世界的结果。我们基本上是帮助你获取信息，决定如何去投票。我们为你提供烹饪信息。实际上，我认为这与物理世界的联系更加紧密，这与元宇宙所做的非常不同，但那正是我们觉得可以产生最大影响力的地方。

---

### [00:54:20] Lenny

**English:**
You can have your own competing metaverse. Here's a quick Wirecutter suggest idea for you, while we're chatting. I feel like Wirecutter, I use it all the time, everything I buy is based on Wirecutter recommendations, but I feel like there's an opportunity for design oriented version of Wirecutter. I don't know if anyone's thinking about that.

**中文翻译:**
你可以拥有一个与之竞争的元宇宙。趁我们聊天，我给你提一个关于 Wirecutter 的小建议。我一直在用 Wirecutter，我买的所有东西都是基于它的推荐，但我觉得有一个“设计导向型”Wirecutter 的机会。不知道有没有人在考虑这个。

---

### [00:54:37] Alex Hardiman

**English:**
Tell me more.

**中文翻译:**
展开讲讲。

---

### [00:54:38] Lenny

**English:**
Just Wirecutter's functional stuff. It's like, "Here's the best, I don't know, rice cooker." But like, what's the cutest but also the best? What's the cross section of looks good in my house and is the best. I'll be okay not the best best if it looks nicer, so a design lens to Wirecutter.

**中文翻译:**
Wirecutter 现在主要是功能性的。比如：“这是最好的，我不知道，电饭煲。”但是，什么是“最可爱且最好”的呢？什么是“放在我家里好看且性能最好”的交集？如果它看起来更漂亮，我甚至可以接受它不是性能最顶尖的。所以，给 Wirecutter 加一个设计的视角。

---

### [00:54:54] Alex Hardiman

**English:**
If it's Wirecutter meets high taste, basically. I like that. I like that. Okay.

**中文翻译:**
基本上就是 Wirecutter 遇见“高级品味”。我喜欢这个主意。好的。

---

### [00:55:02] Lenny

**English:**
I think there's a market there.

**中文翻译:**
我认为那里有市场。

---

### [00:55:04] Alex Hardiman

**English:**
I'll definitely bring that back to the team. That's a good one.

**中文翻译:**
我一定会把这个建议带回给团队。这是个好主意。

---

### [00:55:06] Lenny

**English:**
There you go. Well, we've reached our very exciting lightning round where I'm just going to ask you, I have six questions, I'll get through them pretty quick. Whatever comes to mind, fire off. We'll go through it fast and fun. Sound good?

**中文翻译:**
这就对了。好了，我们进入了非常令人兴奋的闪电问答环节。我会问你六个问题，我会很快过一遍。想到什么就说什么。我们会进行得又快又有趣。听起来怎么样？

---

### [00:55:21] Alex Hardiman

**English:**
Great.

**中文翻译:**
太棒了。

---

### [00:55:21] Lenny

**English:**
Okay. What are two or three books that you recommend most to other people?

**中文翻译:**
好的。你最推荐给别人的两三本书是什么？

---

### [00:55:27] Alex Hardiman

**English:**
I love Stripe Press, and so I think a lot of the books that they have are just such good references, like Elad Gill's High Growth Handbook, or Will Larson's An Elegant Puzzle. Then, some of the more topical ones like Revolt of the Public. I just find that they're evergreen in terms of their utility. Anyone can find value in them. I just loved the craft of the books themselves. They are amazing products in terms of the content and the form, so those are, in the product context and work context, those are hands down I would say the places where I go first.

**中文翻译:**
我非常喜欢 Stripe Press 出版的书，我觉得他们出的很多书都是非常好的参考资料，比如 Elad Gill 的《高增长手册》（High Growth Handbook），或者 Will Larson 的《优雅的谜题》（An Elegant Puzzle）。还有一些更具话题性的，比如《公众的反叛》（Revolt of the Public）。我发现它们在实用性方面是长青的，任何人都能从中发现价值。我非常喜欢这些书本身的工艺。无论从内容还是形式上看，它们都是惊人的产品。所以在产品和工作背景下，这些绝对是我首选的参考。

---

### [00:56:01] Alex Hardiman

**English:**
But I do think, and I know this is this humanities major in me, I also always try to balance books and my own reading time and recommendations with fiction. I just think it's actually like, sometimes some of the best ideas and inspiration come when you go one or two steps away from the core books that are related to your practice. Right now, I'm actually rereading Giovanni's Room by James Baldwin. It's just so beautiful and so lyrical and it gets at more components of the human soul that, I know it sounds crazy, but I find like those are little sparks of ideas that ultimately come back into making products, and particularly news products where they're so creative in the way that they tell stories.

**中文翻译:**
但我确实认为——我知道这是我内心人文专业的一面在起作用——我也总是尝试用虚构文学（小说）来平衡我的阅读时间和推荐。我认为，有时候一些最好的创意和灵感来自于你离开那些与专业相关的核心书籍一两步的时候。现在，我实际上正在重读詹姆斯·鲍德温（James Baldwin）的《乔瓦尼的房间》（Giovanni's Room）。它非常优美且富有抒情色彩，触及了人类灵魂的更多组成部分。我知道这听起来很疯狂，但我发现那些微小的思想火花最终会回到产品制作中，特别是在新闻产品中，讲故事的方式是非常需要创意的。

---

### [00:56:46] Alex Hardiman

**English:**
I always try to give people one pragmatic recommendation and then one slightly more field recommendation over in the world of fiction. If you haven't read Giovanni's Room, it is incredible and devastating, and I absolutely recommend it.

**中文翻译:**
我总是尝试给人们一个务实的建议，然后再给一个稍微跨界一点的小说建议。如果你还没读过《乔瓦尼的房间》，它既不可思议又令人心碎，我绝对推荐。

---

### [00:57:00] Lenny

**English:**
Wow. I feel like I just keep buying books after doing these podcasts. I have so many books I got to read. I'm also feeling like the combination of books you recommended is exactly what I would imagine someone leading product at New York Times would recommend, something product tactical and then just a beautiful piece of fiction.

**中文翻译:**
哇。我觉得做完这些播客后我一直在买书。我有太多书要读了。我也觉得你推荐的书籍组合，正是我能想象到的《纽约时报》产品领导者会推荐的：一些产品战术层面的东西，再加上一部优美的文学作品。

---

### [00:57:18] Alex Hardiman

**English:**
I'm the cliché. I love it.

**中文翻译:**
我就是那个典型的例子。我喜欢这个说法。

---

### [00:57:21] Lenny

**English:**
Great. No, no, no. I wouldn't put it that way. Okay. What's a favorite other podcast that you like to listen to? You mentioned one already, is that the one?

**中文翻译:**
太棒了。不，不，我不是那个意思。好的。你最喜欢的其他播客是什么？你已经提到一个了，是那个吗？

---

### [00:57:28] Alex Hardiman

**English:**
Everyone should listen to Hard Fork. It's great. But I just think The Daily continues to be, and again, I know it sounds self-serving, but being able to just listen to Michael Barbaro and Sabrina Tavernise once a day, just bring in journalists to talk and unpack a meaningful story, it's so visceral. I just find it to be one of the daily miracles that the New York Times is able to produce.

**中文翻译:**
每个人都应该听听《Hard Fork》，它很棒。但我认为《The Daily》依然是……我知道这听起来有点自卖自夸，但每天能听 Michael Barbaro 和 Sabrina Tavernise 邀请记者来谈论并拆解一个有意义的故事，那种感觉非常真实。我发现它是《纽约时报》能够创造的每日奇迹之一。

---

### [00:57:51] Lenny

**English:**
Yeah, that's wild. I can't imagine a daily thing like that doing that. Impressive. What's a recent favorite movie or TV show that you've seen that you've really enjoyed?

**中文翻译:**
是的，那太疯狂了。我无法想象一个日报类的节目能做到那样。令人印象深刻。你最近看过的、非常喜欢的电影或电视剧是什么？

---

### [00:58:01] Alex Hardiman

**English:**
I am pretty old school. I am actually rewatching The Wire for the third time.

**中文翻译:**
我比较怀旧。实际上我正在第三次重看《火线》（The Wire）。

---

### [00:58:06] Lenny

**English:**
Wow. That's a lot of time commitment.

**中文翻译:**
哇。那需要投入很多时间。

---

### [00:58:09] Alex Hardiman

**English:**
It is. I have very little time, but every five years my husband and I, we just can't get over the characters, the storylines. It's just one of the best made series for television ever. It's a work of art, and so I am that person, that is another cliché, who is rewatching The Wire right now.

**中文翻译:**
是的。我的时间很少，但每隔五年，我和丈夫就忍不住想重温那些角色和故事情节。它就是有史以来制作最精良的电视剧之一。它是一件艺术品。所以我就是那个——又是另一个典型——现在正在重看《火线》的人。

---

### [00:58:27] Lenny

**English:**
What's your favorite season?

**中文翻译:**
你最喜欢哪一季？

---

### [00:58:28] Alex Hardiman

**English:**
I would probably say it's season three, but when Stringer Bell passes away, it's the culmination of just so much. I probably shouldn't say that for anyone who hasn't seen The Wire. Oh, that's like the worst thing ever.

**中文翻译:**
我可能会说是第三季，但当 Stringer Bell 去世时，那是很多事情的顶点。我可能不该对还没看过《火线》的人说这个。噢，这简直是剧透大忌。

---

### [00:58:43] Lenny

**English:**
Spoiler alert in reverse.

**中文翻译:**
反向剧透警告。

---

### [00:58:45] Alex Hardiman

**English:**
Spoiler alert. I'm so sorry.

**中文翻译:**
剧透警告。非常抱歉。

---

### [00:58:46] Lenny

**English:**
But that's not the character name, that's the actor, right?

**中文翻译:**
但那不是角色名字，那是演员名字，对吧？

---

### [00:58:49] Alex Hardiman

**English:**
No, no, I really just totally spoiled that.

**中文翻译:**
不，不，我真的完全剧透了。

---

### [00:58:51] Lenny

**English:**
Okay, that's cool. If you haven't seen it at this point, it's over, your loss.

**中文翻译:**
没关系。如果到现在还没看过，那就算了，是你的损失。

---

### [00:58:56] Alex Hardiman

**English:**
Oh, boy. How awful. That's like a cardinals sin. But I do think season four, when it starts to get into the school system is also just, the actors are incredible. It's some of the best acting that I think has existed over the last couple of decades. Again, if you haven't seen it, please do yourself a favor and watch it. It's worth every episode.

**中文翻译:**
噢天哪。太糟糕了。这简直是不可饶恕的罪过。但我确实认为第四季，当它开始涉及学校系统时，演员的表现也非常惊人。我认为那是过去几十年里最顶尖的表演。再次强调，如果你还没看过，请务必去看。每一集都值得。

---

### [00:59:16] Lenny

**English:**
Would you agree season two is the worst?

**中文翻译:**
你同意第二季是最差的一季吗？

---

### [00:59:19] Alex Hardiman

**English:**
I thought that until I re-watched it.

**中文翻译:**
在我重看之前我是这么想的。

---

### [00:59:22] Lenny

**English:**
Interesting.

**中文翻译:**
有趣。

---

### [00:59:22] Alex Hardiman

**English:**
I actually came around and it's not at the top of my list, but there's more to it than I think I originally gave it credit for.

**中文翻译:**
我实际上改观了。虽然它不在我的榜首，但它包含的内容比我最初认为的要多。

---

### [00:59:30] Lenny

**English:**
Wow. I like this. Okay, great. What are four to five SaaS products that you or company uses most that you find really useful?

**中文翻译:**
哇。我喜欢这个。好的，太棒了。你或公司最常使用的、觉得非常有用的四到五个 SaaS 产品是什么？

---

### [00:59:39] Alex Hardiman

**English:**
Probably pretty classic, we use G-Suite, Slack, Figma, Mode, GitHub. Those are the ones that I think just get hands down the most amount of usage across our teams.

**中文翻译:**
可能非常经典：我们使用 G-Suite、Slack、Figma、Mode 和 GitHub。我认为这些绝对是我们团队中使用频率最高的产品。

---

### [00:59:51] Lenny

**English:**
The fourth one was Mode?

**中文翻译:**
第四个是 Mode？

---

### [00:59:52] Alex Hardiman

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:59:53] Lenny

**English:**
Is there any interesting new recent one that's like top of mind while we're on this topic?

**中文翻译:**
既然聊到这个话题，最近有没有什么让你印象深刻的新产品？

---

### [00:59:58] Alex Hardiman

**English:**
Not really. No.

**中文翻译:**
没怎么想到。没有。

---

### [01:00:02] Lenny

**English:**
Okay, great. The winners keep winning, huh? These products?

**中文翻译:**
好的，太棒了。赢家通吃，对吧？这些产品？

---

### [01:00:07] Alex Hardiman

**English:**
Yeah. If anything, it's like when you don't talk about the SaaS products you use, I feel like that's more of a success because it's just, it works behind the scenes, it blends in and it just makes everyone so much more productive.

**中文翻译:**
是的。如果说有什么的话，我觉得当你不再谈论你使用的 SaaS 产品时，那反而是一种成功。因为它就在后台默默运行，融入其中，让每个人的效率都变得更高。

---

### [01:00:19] Lenny

**English:**
Yeah. Imagine all these companies have the New York Times logo on their site of people using that.

**中文翻译:**
是的。想象一下所有这些公司的网站上都挂着《纽约时报》的 Logo，标明你们在使用它们。

---

### [01:00:24] Alex Hardiman

**English:**
Maybe.

**中文翻译:**
也许吧。

---

### [01:00:24] Lenny

**English:**
That would be a big deal when you guys adopt a product. Final question. Who else in the industry do you most respect as a thought leader and thinker?

**中文翻译:**
当你们采用某个产品时，那确实是一件大事。最后一个问题：在业界，你最尊敬的意见领袖和思想家是谁？

---

### [01:00:32] Alex Hardiman

**English:**
This is a hard question, but I would say one of the people who I find to just be a really tremendous product thinker, leader, and ally for women is Fidji Simo. I was lucky enough to work with her and for her when I was at Facebook and just watching the way that she ... what she did with Facebook, what she then is doing at Instacart and the way that she really just helps so many other women in the field figure out how to be better at their craft, how to have more opportunity. I don't know how she has these many hours in her day, but she's pretty incredible, so I would love to give a shout out to her.

**中文翻译:**
这是一个很难的问题，但我会说，我认为非常出色的产品思想家、领导者以及女性盟友之一是 Fidji Simo。我很幸运在 Facebook 时曾与她共事并受她领导。看着她在 Facebook 的成就，以及她现在在 Instacart 的作为，还有她如何帮助该领域这么多其他女性提升专业技能、获得更多机会。我不知道她一天怎么会有那么多时间，但她确实非常了不起，所以我想向她致敬。

---

### [01:01:10] Lenny

**English:**
Awesome. I will try to get her on this podcast.

**中文翻译:**
太棒了。我会试着邀请她来参加这个播客。

---

### [01:01:13] Alex Hardiman

**English:**
Oh, that would be amazing. All right. She's really-

**中文翻译:**
噢，那太好了。好的。她真的——

---

### [01:01:15] Lenny

**English:**
That's what I need to do. Awesome. Good recommendation. Alex, this was amazing. I learned so much. This is such a fun conversation. Thank you, again, for doing this. Two last questions, where can folks find you online if they want to reach out and learn more? Maybe think about working at the New York Times and otherwise, how can listeners be useful to you?

**中文翻译:**
那正是我要做的。太棒了。很好的推荐。Alex，这太精彩了。我学到了很多。这是一次非常有趣的对话。再次感谢你参加节目。最后两个问题：如果大家想联系你或了解更多信息，可以在哪里找到你？也许是考虑去《纽约时报》工作。另外，听众可以为你提供什么帮助？

---

### [01:01:32] Alex Hardiman

**English:**
Thanks. You can find me on Twitter, LinkedIn, all the usual channels. I would love to hear from anyone and would be delighted to also talk about what it's like to do product at the Times. Then, the thing that would be really useful is what is the one feature that would make the New York Times more essential and more valuable to you in your daily life? I would love to hear from people on that front.

**中文翻译:**
谢谢。你可以在 Twitter、LinkedIn 等所有常用渠道找到我。我很乐意听到任何人的声音，也很高兴能聊聊在《时报》做产品是什么感觉。至于对我有用的帮助，那就是：哪一个功能会让《纽约时报》在你的日常生活中变得更不可或缺、更有价值？我很想听听大家在这方面的想法。

---

### [01:01:53] Lenny

**English:**
All right. I shared mine, a design-oriented Wirecutter. I will be looking for that.

**中文翻译:**
好的。我已经分享了我的想法：一个设计导向型的 Wirecutter。我会期待它的出现。

---

### [01:01:59] Alex Hardiman

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:01:59] Lenny

**English:**
Awesome. Thank you, Alex.

**中文翻译:**
太棒了。谢谢你，Alex。

---

### [01:02:00] Alex Hardiman

**English:**
No, of course. There's just one other whole theme, and I don't know if you want to chat through it, which is, what are some of the similarities and differences between product management in news organization?

**中文翻译:**
不客气。还有一个完整的主题，不知道你想不想聊聊，那就是：新闻机构的产品管理与科技公司相比，有哪些异同？

---

### [01:02:14] Lenny

**English:**
Let's do it.

**中文翻译:**
来吧。

---

### [01:02:14] Alex Hardiman

**English:**
It's totally up to you. But if that's something that you'd be interested in talking through.

**中文翻译:**
完全取决于你。但如果你对讨论这个感兴趣的话。

---

### [01:02:20] Lenny

**English:**
Absolutely.

**中文翻译:**
当然感兴趣。

---

### [01:02:21] Alex Hardiman

**English:**
I'm going to just focus on two themes that I think are pretty interesting. The first is just how we work at the New York Times, and we talked a little bit about working with journalism, and there are some really interesting differences. The second is just on the idea of impact. I think how the definition and the understanding of impact can be pretty different. First, just on the idea of how we work, there are a lot of similarities. I would say that product managers at the Times and at tech companies, they have a lot of the same skills. Like, we look for a great product sense, great execution, great leadership and drive.

**中文翻译:**
我将重点关注两个我认为非常有趣的主题。第一个是我们在《纽约时报》的工作方式，我们聊了一点关于与新闻行业合作的内容，其中有一些非常有趣的差异。第二个是关于“影响力”的概念。我认为对影响力的定义和理解可能会有很大不同。首先，关于工作方式，有很多相似之处。我会说，《时报》的产品经理和科技公司的产品经理拥有很多相同的技能。比如，我们都寻找优秀的产品感、执行力、领导力和驱动力。

---

### [01:02:59] Alex Hardiman

**English:**
Any good PM needs to know their industry, their customers, their market, their business, et cetera. We actually do see a lot of crossover between product managers from tech companies who come to the New York Times or tech PMs at the Times who go over to tech companies. I think that that's wonderful, but a key difference of when you're a product manager working at the New York Times is that you work across the full stack of the product. Meaning, we own our journalism and our content. We own our distribution and we own our products. That's really different from working at a big tech platform. When I was at Facebook, we controlled the software and the distribution, but we didn't control the content.

**中文翻译:**
任何优秀的 PM 都需要了解他们的行业、客户、市场和业务等等。我们确实看到很多科技公司的产品经理来到《纽约时报》，或者《时报》的技术 PM 去往科技公司。我认为这很棒。但作为《纽约时报》的产品经理，一个关键区别在于你是在产品的“全栈”上工作。这意味着，我们拥有我们的新闻报道和内容，拥有我们的分发渠道，也拥有我们的产品。这与在大型科技平台工作非常不同。当我在 Facebook 时，我们控制软件和分发，但我们不控制内容。

---

### [01:03:39] Alex Hardiman

**English:**
We had real limitations on understanding what was passing through. Was it high quality content, low quality content? It just led to, again, a lot of challenges that we already talked about. At the Times, when I think about how our best products are born, it's when you bring journalism and product lovers together. That means that PMs at the Times really need to understand the blend of art and science. They really need to value expert editorial judgment as they're also looking at individual KPIs, customer research and insights, et cetera. An interesting example, as I was trying to think about what would feel really different doing product at the Times compared to say Facebook is like, let's say you're at the product team and you're working on the home screen.

**中文翻译:**
我们对于流经平台的内容理解非常有限。它是高质量内容还是低质量内容？这导致了我们之前讨论过的许多挑战。在《时报》，当我思考我们最好的产品是如何诞生时，那是当你把新闻爱好者和产品爱好者聚集在一起的时候。这意味着《时报》的 PM 真的需要理解艺术与科学的融合。他们在关注个人 KPI、客户研究和洞察的同时，也需要真正重视专家的编辑判断。一个有趣的例子——当我试图思考在《时报》做产品与在 Facebook 有什么不同时——假设你在产品团队负责首页。

---

### [01:04:25] Alex Hardiman

**English:**
We always start with expert editorial judgment to curate the most important and interesting stories. But on top of that, we're training algorithms on specific data sets, like editorial important scores that actually come from our journalists. What that allows us to do is actually scale editorial judgment to a large group of readers. Those algorithms, what I think is just really great is they're trained on editorial signal and then they can still work towards driving towards outcomes like reach, engagement, conversion, et cetera. That's just such a different way of thinking. When I was at Facebook and we were focused on news ranking and feed, all we could do was train pieces of in information based on an engagement outcome.

**中文翻译:**
我们总是从专家的编辑判断开始，挑选最重要、最有趣的故事。但在此基础上，我们在特定的数据集上训练算法，比如来自我们记者的“编辑重要性评分”。这让我们可以将编辑判断扩展到庞大的读者群。我认为非常棒的一点是，这些算法是基于编辑信号训练的，然后它们仍然可以致力于推动触达、参与、转化等结果。这是一种完全不同的思维方式。当我在 Facebook 负责新闻排名和信息流时，我们所能做的只是根据“参与度结果”来训练信息片段。

---

### [01:05:12] Alex Hardiman

**English:**
We couldn't actually train it based on the quality of that piece of information itself. At the Times you get all, you have 2000 plus journalists and you're actually trying to structure their expertise into things that can actually translate into really great algorithmic decisioning, and that's just so different. No one else is really doing something in that space. Product managers are becoming very editorially minded and we're also getting editors to become more product minded. I just think that how we work there is so different and so unique. It's just a pretty fascinating part of, I think, how the sausage is made, if that makes sense.

**中文翻译:**
我们实际上无法根据信息本身的质量来训练它。在《时报》，你拥有 2000 多名记者，你实际上是在尝试将他们的专业知识结构化，转化为可以转化为出色算法决策的东西，这太不一样了。没有人在那个领域做类似的事情。产品经理正变得非常有编辑头脑，我们也让编辑变得更有产品头脑。我认为我们在那里的工作方式非常不同且独特。我认为这是“香肠是如何制成的”（指幕后运作过程）中非常迷人的部分。

---

### [01:05:46] Lenny

**English:**
Yeah. Thanks for sharing that. I think that's really important topic of just how it's different and why it's worth considering trying something like the New York Times as a place to work. What's interesting about what you're talking about, this also reminds me ironically of Substack, where they also are anti-algorithms and are also very focused on people and people recommending other people and just like individuals. I don't know if we want to get into this, but I guess do you have a opinion of Substack as a medium? Because folks leave New York Times to work on Substack, they come back. My whole living is on Substack. Any thoughts on the world of Substack?

**中文翻译:**
是的。感谢分享。我认为这是一个非常重要的主题，即它有何不同，以及为什么值得考虑像《纽约时报》这样的工作场所。有趣的是，你所说的让我想起了 Substack（讽刺的是），他们也反对算法，也非常关注人、人与人之间的推荐以及个人。我不知道我们是否想深入探讨这个，但我猜想听听你对 Substack 这种媒介的看法？因为有人离开《纽约时报》去 Substack，也有人回来。我的生计全在 Substack 上。对 Substack 的世界有什么看法吗？

---

### [01:06:25] Alex Hardiman

**English:**
Well, a couple of things. First, it's not that we're anti-algorithm on the New York Times front, it's just that we want our algorithms to reflect editorial judgment. That's really different. When it comes to Substack, actually, I think a lot of what Substack is doing is great. The idea of writers being able to make a living individually off of their craft, I think, is fantastic. The thing that I get excited about for Substack, but also for a company like the New York Times is trust right now with institutions has been declining, with governments, with religious institutions, with news organizations.

**中文翻译:**
嗯，有几点。首先，在《纽约时报》这边，我们并不是反对算法，我们只是希望我们的算法能反映编辑判断。这有本质区别。至于 Substack，实际上我认为 Substack 做的很多事情都很棒。作家能够凭借自己的手艺独立谋生，我认为这太棒了。让我对 Substack 以及《纽约时报》这样的公司感到兴奋的是：目前人们对机构的信任一直在下降，无论是对政府、宗教机构还是新闻机构。

---

### [01:07:00] Alex Hardiman

**English:**
But trust with individual experts, where you have a real relationship, that really matters. That I think is one of the big unlocks in terms of helping the next generation of readers really start to create more of a relationship with high quality journalists and writers who have really important things to say about the world. I think whatever is happening in the world that helps great writers find their audiences, make a living, is wonderful. At the New York Times, a lot of what we're trying to do is, it's not the Substack model, but we have a lot more that we're doing to actually help get individual journalists out there.

**中文翻译:**
但对个人专家的信任——那种你与之建立真实关系的信任——非常重要。我认为这是帮助下一代读者真正开始与高质量记者和作家建立更多联系的关键所在，这些作家对世界有非常重要的见解。我认为，世界上发生的任何能帮助优秀作家找到受众、维持生计的事情都是美好的。在《纽约时报》，我们正在做的很多事情虽然不是 Substack 模式，但我们也做了很多工作来帮助个人记者脱颖而出。

---

### [01:07:39] Alex Hardiman

**English:**
They have their own subscribe only newsletters, podcasts. We're really trying to help them find a way to create a mini platform within the means and the scale of the New York Times. It's not quite the Substack model, but I do think that there's some interesting similarities, and the more that artists and creatives can help make a living, I think, it's just fantastic.

**中文翻译:**
他们有自己仅限订阅的时事通讯和播客。我们正努力帮助他们在《纽约时报》的资源和规模内，找到创建“微型平台”的方法。这不完全是 Substack 模式，但我确实认为其中有一些有趣的相似之处。艺术家和创意人员越能以此谋生，我觉得就越棒。

---

### [01:08:00] Lenny

**English:**
I'm here for it. I love this two-part encore bonus we just did. Anything else that you want to share before we wrap up?

**中文翻译:**
我完全赞同。我喜欢我们刚才做的这两部分“返场加餐”。在结束之前，你还有什么想分享的吗？

---

### [01:08:10] Alex Hardiman

**English:**
I think the only other thing that I have come to learn when you're doing product management at a news organization compared to a place like Facebook is just how different the definition of impact can be. When I was at Facebook, we were incredibly focused on scale, engagement, and revenue, which is very appropriate. At a company like the New York Times, we also have a huge ambition to grow our subscriber base. But one thing that's really interesting is that our impact and our business goals are in service of our mission, which is to seek the truth and help people understand the world, not the other way around.

**中文翻译:**
我想，与 Facebook 这样的地方相比，在新闻机构做产品管理让我学到的另一件事就是：影响力的定义可以有多么不同。当我在 Facebook 时，我们极其关注规模、参与度和收入，这非常合理。在《纽约时报》这样的公司，我们也有扩大订阅用户群的巨大雄心。但非常有趣的一点是，我们的影响力和业务目标是为我们的使命服务的，即寻求真理并帮助人们理解世界，而不是反过来。

---

### [01:08:51] Alex Hardiman

**English:**
What it means is that the way that we think about impact is growing a giant subscription business. That business exists to strengthen an informed democracy at a time when people are struggling to understand basic facts and struggling to understand each other. That means that impact for us is growing subscribers, but it's also when a deeply reported story triggers an important policy change or a new law. When you're a product manager you're involved, again, in driving specific metrics like engagement or subscribers.

**中文翻译:**
这意味着，我们思考影响力的方式是发展庞大的订阅业务。而这项业务的存在，是为了在人们难以理解基本事实、难以相互理解的时代，加强一个信息通达的民主社会。这意味着，对我们来说，影响力不仅是增加订阅用户，还包括当一篇深度报道触发了重要的政策变革或新法律的诞生。当你是一名产品经理时，你同样需要负责推动特定的指标，比如参与度或订阅数。

---

### [01:09:26] Alex Hardiman

**English:**
But you're also trying to help stories find their real audience in ways that trigger just this whole different side of mission and purpose driven impact. I didn't feel that when I was at a place like Facebook, but at the Times, I think it just gives product managers a bit of a broader aperture in the ways that they think about the relationship between business goals and mission impact goals, and it's pretty cool.

**中文翻译:**
但你也在努力帮助报道找到真正的受众，从而触发这种完全不同的、由使命和目标驱动的影响力。我在 Facebook 这样的地方工作时并没有这种感觉，但在《时报》，我认为这给了产品经理一个更广阔的视角，去思考业务目标与使命影响力目标之间的关系，这非常酷。

---

### [01:09:50] Lenny

**English:**
It does feel like it would be hard to find more meaningful, impactful work, and so that really resonates.

**中文翻译:**
确实感觉很难找到比这更有意义、更有影响力的工作了，这真的引起了共鸣。

---

### [01:09:57] Alex Hardiman

**English:**
Oh, thanks. There are so many other important purposeful products and problems out there to solve in the world. We've talked about this, Lenny, but I just think that product managers and product thinking in so many contexts inside and outside of tech has never been more important in the world than right now. We need product managers everywhere diagnosing key problems and issues, coming up with radically novel solutions. This is the moment. It's really great to have your podcast and so many other resources out there to help new and other PMs just do their best craft. Thank you for having all of us in here.

**中文翻译:**
噢，谢谢。世界上还有很多其他重要的、有目标感的产品和问题等待解决。Lenny，我们讨论过这个，但我认为，无论是在科技行业内部还是外部，产品经理和产品思维在当今世界的重要性从未像现在这样突出。我们需要各处的产品经理来诊断关键问题，提出彻底创新的解决方案。现在就是那个时刻。非常感谢有你的播客和这么多其他资源，来帮助新老 PM 提升专业技能。谢谢你邀请我们。

---

### [01:10:33] Lenny

**English:**
I love that as a closing thought. Alex, thank you again so much for doing this.

**中文翻译:**
我非常喜欢这个结语。Alex，再次感谢你参加节目。

---

### [01:10:37] Alex Hardiman

**English:**
Thank you so much, Lenny. This was really fun.

**中文翻译:**
非常感谢，Lenny。这真的很有趣。

---

### [01:10:40] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcast、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。