# Alex Komoroske - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Alex Komoroske.

---

### [00:00:00] Alex Komoroske

**English:**
So much of the way that we tackle problems and build products is this builder mindset. It's like I have a plan. I then manipulate things to match my plan and make it happen. And this is a way you can create tons of value. Part of the problem though is it can't possibly create more value than the effort that you put into it. What I look for instead are things that can be gardened, things that can grow on their own and that you can direct or maybe give a little bit of extra energy to or curate over, and is a totally different mindset for it. If you do this properly, it looks like magic. I've been told that this is completely against all the advice that people get, including products nowadays, but I think it's a very powerful approach that works in a lot of different contexts.

**中文翻译:**
我们解决问题和打造产品的方式，很大程度上源于这种“建设者心态”（builder mindset）。就像是：我有一个计划，然后我操纵各种事物来匹配我的计划并实现它。这确实是一种创造巨大价值的方式。但问题在于，它所创造的价值不可能超过你投入的精力。相反，我寻找的是那些可以像“园艺”一样去打理的事物（things that can be gardened），它们能够自我生长，而你只需引导它们，或者额外给予一点能量，亦或是进行微调。这是一种完全不同的心态。如果你做得对，它看起来就像魔法。有人告诉我，这完全违背了人们现在得到的关于产品的所有建议，但我认为这是一种非常强大的方法，适用于许多不同的场景。

---

### [00:00:40] Lenny Rachitsky

**English:**
Today, my guest is Alex Komoroske. Alex is one of the most original, articulate, and first principle thinkers on the future of product and tech that I've ever come across. This conversation will get your brain buzzing in all kinds of ways. Alex spent 13 years at Google where he worked on Search, DoubleClick. He led Chrome's Open Web Platform team for eight years, led augmented reality within Google Maps, and developed a new toolkit to align company-wide strategy from the bottom up. After a stint at Stripe as head of corporate strategy, he's currently founding a startup that aims to reimagine the web for the AI era.

**中文翻译:**
今天的嘉宾是 Alex Komoroske。Alex 是我见过的关于产品和技术未来最具有原创性、表达最清晰、且最坚持“第一性原理”（first principle）的思考者之一。这次对话会让你的大脑以各种方式兴奋起来。Alex 在 Google 工作了 13 年，曾参与 Search 和 DoubleClick 项目。他领导 Chrome 的开放 Web 平台团队长达八年，负责过 Google Maps 中的增强现实（AR）业务，并开发了一套全新的工具包，用于自下而上地统一全公司的战略。在 Stripe 担任企业战略负责人一段时间后，他目前正在创办一家初创公司，旨在为 AI 时代重新构想 Web。

---

### [00:01:13] Lenny Rachitsky

**English:**
In our wide-ranging conversation, we cover how LLMs and gen AI will impact how we build product in the coming years, what skills will matter most as AI becomes a bigger part of our lives, what companies can learn from slime mold, organizational kayfabe, the adjacent possible, strategy salons, why you should be thinking more like a gardener than a builder, plus a bunch of productivity tips, life advice, and so much more. This was such a fun episode, and I'm sure this is going to get your mind thinking in completely new ways. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that, I bring you Alex Komoroske. Alex, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
在我们这次广泛的对话中，我们讨论了：大语言模型（LLM）和生成式 AI 将如何影响未来几年的产品构建方式；随着 AI 深入生活，哪些技能将变得最重要；公司可以从“黏菌”（slime mold）中学到什么；组织性“凯法贝”（organizational kayfabe，指一种大家心照不宣的表演性共识）；“相邻可能”（the adjacent possible）；战略沙龙；为什么你应该像园丁而不是建设者一样思考；此外还有一系列生产力技巧、人生建议等等。这是一集非常有趣的节目，我相信它会启发你产生全新的思考方式。如果你喜欢这个播客，别忘了在应用或 YouTube 上订阅和关注。这是避免错过后续节目的最好方式，也对我们很有帮助。现在，让我们欢迎 Alex Komoroske。Alex，非常感谢你能来，欢迎来到本播客。

---

### [00:01:57] Alex Komoroske

**English:**
Thanks for having me.

**中文翻译:**
谢谢邀请。

---

### [00:02:02] Lenny Rachitsky

**English:**
I love the way your brain works. My brain immediately starts buzzing anytime I start reading some of your stuff. And one of the more interesting things that you write and do and a really interesting habit you have is you actually have this doc that you keep called Bits and Bobs that I love, and we're going to be touching on a lot of the things that you share in this doc, Bits and Bobs, and we'll link to it. First of all, can you just explain this doc, Bits and Bobs, what's it about?

**中文翻译:**
我非常喜欢你的思维方式。每当我读到你的文章，我的大脑就会立刻活跃起来。你写的东西里最有趣的一件，也是你一个非常有趣的习惯，就是你维护着一个叫《零碎想法》（Bits and Bobs）的文档。我很喜欢它，我们今天会聊到其中的很多内容，我们也会在介绍里附上链接。首先，你能解释一下这个文档吗？它到底是关于什么的？

---

### [00:02:27] Alex Komoroske

**English:**
Yeah. I think it's like 600 pages now. It's this one Google Doc. Every so often, almost every day, someone will accidentally add a suggestion like add a space or something because it takes so long to load that while they're waiting, they'll tap on the screen and then it'll turn into taps on adding a comment or something. And I take a lot of notes. And people, I tell people when I'm in meetings with them of like, "If you see me on my phone or typing, that means I think you said something very interesting and I'm writing it down. It's not that I'm just that I'm disengaged. I try to collect all these ideas." And then once a week, I go through, I take a few hours and I just reflect to myself and try to find patterns and unpack and find meaning and things. And I write those down and I started sometime in the past sharing those publicly, and it's now become a thing I literally can't stop doing.

**中文翻译:**
是的，我想现在大概有 600 页了。它就是一个 Google 文档。每隔一段时间，几乎每天，都会有人不小心在上面添加建议，比如加个空格之类的，因为文档太大了，加载时间很长，他们在等待时点击屏幕，结果就变成了添加评论。我记很多笔记。在开会时我会告诉别人：“如果你看到我在玩手机或打字，那意味着我觉得你说的内容非常有趣，我正在记下来。不是因为我开小差。我试图收集所有这些想法。”然后每周一次，我会花几个小时进行自我反思，尝试寻找模式、拆解并寻找事物的意义。我会把这些写下来。过去某个时候我开始公开分享这些内容，现在这已经成了我停不下来的一件事。

---

### [00:03:17] Alex Komoroske

**English:**
I just find someone who was like, "Oh, if you get more exposure for this, if you broke these up into tweets that you sent out once throughout the day," it's like, I did this for me. I'm happy to let other people see and peek into my weird mental process if they want, but this is 100% about my own self-reflection. And it's not designed. I don't want anyone to feel compelled to read it or... In fact, it's designed a little bit to be, I allow myself to be a little bit illegible. I want people to have to work a little bit with it. And it's not going to lay it out on a platter. It's going to jump between different things. I'll use terminology sometimes that is, what are you talking about? And I do that specifically. I don't want anyone to read and be like, "Oh, it sucks. It wasn't worth my time." It's like, "Cool." It's a 600-page Google Doc of my just unspooled insights. It's okay for you to not want to dive into that.

**中文翻译:**
有人曾对我说：“如果你想让它获得更多曝光，你应该把它拆成推文每天发布。”但我的态度是：这是我为自己做的。如果别人想窥视我怪异的思维过程，我很乐意分享，但这 100% 是关于我自己的反思。它没有经过刻意设计。我不希望任何人感到有压力去读它。事实上，它的设计初衷是带有一点“晦涩感”（illegible）。我希望读者必须花点心思去理解。它不会把东西直接喂到你嘴里，它会在不同事物之间跳跃。我有时会使用一些让人摸不着头脑的术语。我是故意这么做的。我不希望有人读完后说：“哦，太烂了，不值得我花时间。”我的反应会是：“没关系。”这是一个 600 页的、记录我原始见解的 Google 文档。如果你不想深入研究，那完全没问题。

---

### [00:04:09] Lenny Rachitsky

**English:**
[Ad break for Eppo and Vanta]

**中文翻译:**
[Eppo 和 Vanta 的广告环节]

---

### [00:06:21] Alex Komoroske

**English:**
I started it many years ago in the same conceptual thing, taking a bunch of notes. I have a thing called The Compendium, which is an open source tool. If you look at it currently, it looks like I haven't touched it in years, but that's actually incorrect. I built this about five years ago. I use it every day. And so I have, I think let's see, I currently have 17,248 unpublished working notes. And so what I do during the week is I'm taking notes very quickly in meetings, and then every day or two, I go through and I process them and put them in as working notes in The Compendium, and this is where I correct misspellings. I add just a little bit more context so that it will make sense to me if I were to read it in a year.

**中文翻译:**
很多年前我就开始做类似的事情，记很多笔记。我有一个叫《纲要》（The Compendium）的开源工具。如果你现在去看它，感觉好像我几年没碰过了，但事实并非如此。我大约五年前开发了它，现在每天都在用。我目前有 17,248 条未发布的草稿笔记。我这一周的做法是：在会议中快速记笔记，然后每一两天我会处理一遍，把它们存入《纲要》作为工作笔记。在这里我会纠正拼写错误，增加一点上下文，以便一年后我再读时还能看懂。

---

### [00:06:58] Alex Komoroske

**English:**
And also, I built a feature into it that uses embeddings to find similar cards. I find similar ideas from the past. And then what I do on Friday afternoons is I sit down and I go through all the notes I added that week and I just click and check the ones that still resonate with me, they still seem interesting in some way. And then I have a little export thing. I put it into a Google Doc, and while the kids are napping on the weekends, I just go through them and try to distill them a little bit more in a more long-term format. And then on Monday mornings, I publish them. And again, it's a deep... For me, it's like I can't imagine not doing this. It is the place where I find most of my most interesting insights is by reflecting on interesting conversations from the week before.

**中文翻译:**
此外，我还内置了一个功能，利用“嵌入”（embeddings，一种 AI 技术）来寻找相似的卡片，从而发现过去的类似想法。周五下午，我会坐下来浏览那一周添加的所有笔记，勾选出那些依然让我产生共鸣、依然有趣的内容。然后我有一个导出工具，把它们放入 Google 文档。周末趁孩子们午睡时，我会梳理它们，将它们提炼成更长期的格式。周一早上，我发布它们。对我来说，这已经深入骨髓，我无法想象不这么做。通过反思前一周有趣的对话，我能获得大部分最有趣的见解。

---

### [00:07:39] Lenny Rachitsky

**English:**
As we get into the conversation, people get to see how deeply you think about stuff. Part of the reason you're able to think so deeply about stuff is you have this practice where you take time to reflect and share and crystallize. There's so much power in just forcing yourself to write it out, I imagine versus, just not.

**中文翻译:**
随着对话的深入，大家会看到你对事物的思考有多深。你能思考得这么深，部分原因在于你这种反思、分享和结晶的习惯。比起不写，强迫自己写出来具有巨大的力量。

---

### [00:07:54] Alex Komoroske

**English:**
100%. I find that when you're busy, you're constantly just go, go, go, go. There's no time to do any deep thinking. Deep thinking takes time and space, and you got to create that space. The mundane, pointless bullshit will take every square inch you give it. So you got to make that space to sit back and reflect and luxuriate in these ideas. And when you do, you're often like, "Oh my God. Oh wow, that's one I'll keep."

**中文翻译:**
100% 同意。我发现当你忙碌时，你总是在不停地奔忙。根本没有时间进行深度思考。深度思考需要时间和空间，而你必须主动创造那个空间。平庸、无意义的琐事会占据你给它的每一寸空间。所以你必须腾出空间坐下来反思，沉浸在这些想法中。当你这样做时，你经常会惊叹：“天哪，这个想法太棒了，我要留着。”

---

### [00:08:18] Alex Komoroske

**English:**
And I told people, back at the very beginning of my career, I used to work from home on Fridays. And people gave me so much shit for this and they'd say, "Oh, you're working from home on Fridays." First of all, I will line up my output any day of the week. I'm very proud of the impact I've had. Second of all, Monday through Thursday, I'm in meetings from 8:00 to 6:00 or whatever. I'm just running between. I'm singing, pinging people and scheduling things and flinging action items. And the one day I don't take meetings is on Friday, and that's the day I read documents carefully that people had sent me or reflect. And I think to myself, what is the thing that if I had done it before the week started would've saved me tons of time and effort that week?

**中文翻译:**
在我职业生涯初期，我周五经常在家办公。人们因此嘲笑我：“哦，你周五在家偷懒啊。”首先，我一周中任何一天的产出都经得起考验，我为自己的影响力感到自豪。其次，周一到周四，我从早上 8 点到下午 6 点都在开会，忙着联系人、安排事情、分发任务。而周五是我唯一不开会的一天，那是我仔细阅读别人发来的文档或进行反思的日子。我会问自己：如果我在本周开始前做了哪件事，能为我这周节省大量的时间和精力？

---

### [00:08:58] Alex Komoroske

**English:**
So for example, maybe in 10 different one-on-ones with people on the team, I had to explain to them a strategic thing that we were doing or a change that we were making. And the idea and the way I framed it worked for everybody. Well, you know what? That should probably be a document, right? If the same idea worked for 10 different people and now in the future there's probably 10 other people that need to hear it, and now I'll write that document in 30 minutes and now I have it as a memorialized thing that other people can read on their own time without having to involve me.

**中文翻译:**
举个例子，也许在与团队成员的 10 次不同的一对一沟通中，我不得不向他们解释我们正在做的某项战略或变革。而我的构思和表达方式对每个人都奏效。那么，你知道吗？这应该写成一份文档。如果同一个想法对 10 个人有效，未来可能还有另外 10 个人需要听，我现在花 30 分钟写下来，它就成了一个永久性的记录，其他人可以在自己的时间阅读，而不需要我介入。

---

### [00:09:24] Alex Komoroske

**English:**
And you also find these interesting ideas sometimes where you look at this problem that you're banging your head against, you go, "Oh wait, if I will like that, that would've a wildly different dynamic." And you can only find those when you take a step back. And I find that people, I told someone, I mentored someone, I've mentored hundreds of PMs over the years and I told someone that at one point and they go, "Oh, I wish I had the time." And it's like, you got to make the time. All of us are busy and we will always be busy. And so this to me is not something I do to just for the enjoyment of all. I do deeply enjoy it intrinsically. It's something I do because I think it makes me more productive and effective.

**中文翻译:**
有时你也会发现一些有趣的灵感，当你面对一个苦思冥想的问题时，你会突然意识到：“等一下，如果我换个角度看，情况会完全不同。”只有当你退后一步时，你才能发现这些。我指导过数百名产品经理（PM），我曾告诉过某人这一点，他们说：“哦，我希望我有时间。”但事实是，你必须挤出时间。我们所有人都很忙，而且永远都会忙下去。所以对我来说，这不仅仅是为了乐趣（虽然我确实乐在其中），更是因为我认为这让我更高效、更有产出。

---

### [00:10:01] Lenny Rachitsky

**English:**
I'm very tempted to go down a whole direction of just how you structure your time and your productivity calendar and all this stuff, but I'm not going to do that. That could be another episode if I do.

**中文翻译:**
我很想深入探讨你是如何安排时间、管理生产力日历之类的，但我先不这么做，否则那得专门录一集。

---

### [00:10:09] Alex Komoroske

**English:**
I do for that for hours.

**中文翻译:**
那我可以聊上好几个小时。

---

### [00:10:10] Lenny Rachitsky

**English:**
What I want to do instead is pick on some of the Bits and Bobs that you've been focusing on noodling on that I think are going to be really helpful to listeners in how they think about product and the future of AI and all these things that I think are emerging. And the first one is actually that I want to get your thoughts on how AI and LLMs are likely to impact product development. A lot of the listeners of this podcast are PMs, engineers, founders, people building software, and you're spending a lot of time thinking about AI and product development. A lot of your Bits and Bobs have been just like, "Here's what's happening. Holy shit. This is how things are going to be." So let me just ask you this how do you anticipate LLMs and gen AI are going to change how products are built in the next three to five years?

**中文翻译:**
我想做的是挑出一些你在《零碎想法》里思考的内容，我认为这些对听众思考产品、AI 的未来以及各种新兴事物会非常有帮助。第一个我想请教的是：AI 和大语言模型（LLM）将如何影响产品开发？这个播客的很多听众是 PM、工程师、创始人，也就是构建软件的人。你花了很多时间思考 AI 和产品开发，你的很多笔记都在感叹：“天哪，这就是正在发生的事情，未来会变成这样。”所以我想问，你预计 LLM 和生成式 AI 在未来三到五年内将如何改变产品的构建方式？

---

### [00:10:56] Alex Komoroske

**English:**
I think they change a lot. I think LLMs are truly a disruptive technology. In fact, I would argue that what we're seeing in the industry is us trying to use mature playbooks from the end stage of the last tech era in one that doesn't really fit yet. To me, LLMs are magical duct tape. They're formed principally by the distilled intuition of all of society into a thing that operates between, a cost structure between human and plain old computing. So much of how the industry is built presupposes the idea that software is expensive to write and cheap to run, and LLMs undermine both of these. So it makes it LLMs allow writing shitty software to be significantly cheaper, not necessarily good software, but good enough in certain contexts. And also it means that there's certain software now that isn't plain old computing that can be run cheaply. It's relatively expensive marginal cost.

**中文翻译:**
我认为改变会非常大。LLM 确实是一种颠覆性技术。事实上，我认为目前行业内的情况是，我们正试图在不契合的新时代里，套用上一个技术时代末期的成熟玩法。对我来说，LLM 就像是“神奇的万能胶带”（magical duct tape）。它们本质上是全社会直觉的浓缩，运行在人类成本和传统计算成本之间的一种成本结构上。目前行业的构建基础是假设“软件编写昂贵，运行廉价”，而 LLM 颠覆了这两点。LLM 让编写“烂软件”变得极其便宜——不一定是好软件，但在某些场景下足够用了。同时，它也意味着某些非传统计算的软件现在可以运行，但边际成本相对较高。

---

### [00:11:49] Alex Komoroske

**English:**
And so if you're going to do a consumer startup, it can't be based on advertising. It's just too expensive. Advertising cannot clear the inference costs even with inference costs declining. So I think the way to me, a disruptive technology changes tons of stuff, all these assumptions you didn't even realize you were making because you didn't realize it could be any different. Imagine if you were locked in a room for your entire career, no windows, and you have all these experiences. You're going all this know how. You're getting this sense of how things work, what will happen. And then imagine that room tilts on its axis by five degrees. Everything looks roughly the same, and yet now the dynamics of the force of gravity is pulling in a different direction than it was before. You didn't even think about the force of gravity before because it was so omnipresent. It never changed that it's just a blank in your head. And now gravity has changed effectively for your perspective and all kinds of intuition is now wrong. I put this thing on the table, it's going to stay there, and then it slides off and falls into the wall. All kinds of weird stuff will happen.

**中文翻译:**
因此，如果你要做一家消费级初创公司，它不能基于广告模式。因为成本太高了，即使推理成本在下降，广告收入也覆盖不了推理成本。对我来说，颠覆性技术会改变无数事情，包括那些你甚至没意识到自己在做的假设，因为你以前觉得理所当然。想象一下，如果你整个职业生涯都被关在一个没有窗户的房间里，你积累了所有经验、知识和对事物运作方式的直觉。然后，想象这个房间绕轴倾斜了 5 度。一切看起来还是一样，但重力的方向变了。你以前从没想过重力，因为它无处不在且从未改变。现在，从你的视角来看，重力变了，你所有的直觉都错了。你把东西放在桌上以为它会待在那，结果它滑落撞到了墙上。各种奇怪的事情都会发生。

---

### [00:12:44] Alex Komoroske

**English:**
And I think LLMs to me feel like that. I can't tell you the number of people who are... At some point at a year or two, someone came to me, they're like, "I just built a prototype, product that would've taken me three months. And I can believe it's going to start up." I was like, "How differentiated do you think that is?" Everybody can do that now. It changes the basis of competition. I think today I see a lot of folks using LLMs, and LLMs are like a squishy computer. We're used to computers doing exactly what we told them to do, which is not necessarily what we meant. And only some people have learned the skill of programming, the arcane magical incantations to make computers do exactly what you meant.

**中文翻译:**
我觉得 LLM 给我就是这种感觉。我数不清有多少人跑来跟我说：“我刚做了一个原型，以前要花三个月，现在一下子就成了，我觉得这能成一家公司。”我的反应是：“你觉得这有多大的差异化？”现在每个人都能做到。它改变了竞争的基础。今天我看到很多人在使用 LLM，而 LLM 就像是一台“软绵绵的电脑”（squishy computer）。我们习惯了电脑执行我们“告诉”它做的事，而不一定是执行我们“想要”它做的事。只有少数人学会了编程这种神秘的咒语，让电脑准确执行他们的意图。

---

### [00:13:24] Alex Komoroske

**English:**
Now, LLMs can do all kinds of stuff. And they don't do exactly what you told them, but they do typically do roughly what you meant. I see all these places where people will build products and they'll say 80% of the time, 90% percent of the time, it's great. 5% of the time it punches the user in the face and they're like, "Oh, we're going to reduce the number of times it punches us in the face." It's like even if you get it down to 99% of the time, it's fine. If it punches in the face, that's not a viable product. And so how do you design your products assuming that this thing will be squishy and not fully accurate and fully work? People use these things a lot as oracles. "I'm going to have it. I'm going to formulate the answer and it's going to be a fully fledged answer." And of course, strawberry has been really stabbed at. Gotten a chance to play with it. They are getting better at some of these kinds of behaviors at great expense. But in a lot of cases, I instead would rather say, "How can you take LLMs for granted? How can you assume that you now have this magical duct tape? Don't assume it's going to solve all your problems. Don't assume it's going to do autonomously be able to give high quality results of every case. But what can you now build now that you have magical duct tape?"

**中文翻译:**
现在，LLM 可以做各种事情。它们不一定完全按照你说的做，但通常能大致符合你的意图。我看到很多产品，开发者说 80% 或 90% 的时间它表现很棒，但有 5% 的时间它会“给用户一记重拳”（指出现严重错误），然后他们说：“我们要减少它打脸的次数。”但问题是，即使你把它优化到 99% 的时间都没问题，只要它还会打脸，这就不是一个可行的产品。那么，在假设这个东西是“软绵绵的”、不完全准确的情况下，你该如何设计产品？很多人把这些东西当成“神谕”（oracles），觉得它能直接给出一个完美的答案。当然，像 OpenAI 的 Strawberry（o1）模型正在努力解决这个问题，它们在某些行为上确实变强了，但代价巨大。在很多情况下，我宁愿问：“既然你已经有了这种‘神奇胶带’，你现在能构建什么以前做不到的东西？不要指望它解决所有问题，也不要指望它在所有情况下都能自动给出高质量结果。”

---

### [00:14:24] Lenny Rachitsky

**English:**
You're a product manager for most of your career. Now, you're a founder. I'm curious what your advice would be to product managers and people building products in terms of what skills they should lean into, what you think is going to be matter most. There's hard skills. There's soft skills. There's getting more technical. There's getting more product business-oriented. Just what do you think people should work on more and becomes more valuable and what do you think becomes less valuable from a product builder perspective?

**中文翻译:**
你职业生涯的大部分时间都是 PM，现在是创始人。我很想知道你对 PM 和产品构建者的建议：他们应该加强哪些技能？你认为什么最重要？是硬技能、软技能、变得更懂技术，还是更偏向产品业务？从产品构建者的角度来看，你认为哪些东西变得更有价值，哪些变得不那么重要了？

---

### [00:14:52] Alex Komoroske

**English:**
I think in this early stage, we're in the community gardening phase, not the factory farming phase of this technology. And so I think what people need most is curiosity and play. You should be playing with these things and trying out different things and seeing what weird things are possible now. One of my favorite things, to be honest, right now, it's using AI is WebSim. WebSim is so weird. What a weird idea, like why? And then you play with it and you realize, "Oh, this is a thing that could only exist in a world where LLMs exist." And I think these kinds of odd, interesting, weird, provocative, generative things will be where a lot of the interesting patterns are found because right now we're so used to... If the playbook, if the cost structures have changed, the kinds of things are now possible, the playbook is wrong and we should throw it out or at least ignore it to some degree. So it will feel like we are navigating through a whole new industry that it has in the past.

**中文翻译:**
我认为在目前这个早期阶段，我们处于这项技术的“社区园艺”阶段，而不是“工厂化耕作”阶段。因此，我认为人们最需要的是好奇心和“玩”的心态。你应该去玩这些东西，尝试不同的可能性，看看现在能实现哪些奇怪的事情。老实说，我现在最喜欢的 AI 应用之一是 WebSim。WebSim 太奇怪了，这种想法简直莫名其妙。但当你玩过之后，你会意识到：“哦，这是一个只有在 LLM 存在的世界里才能存在的东西。”我认为，正是这些古怪、有趣、挑衅性的生成式事物，才是发现有趣模式的地方。因为如果成本结构变了，以前的玩法就错了，我们应该把它扔掉，或者至少在某种程度上忽略它。这感觉就像我们在一个全新的行业中航行。

---

### [00:15:47] Alex Komoroske

**English:**
Anytime that an industry gets really, really, really, really, really good at like vertical SaaS, we know how to execute the crap out of that. We know exactly what to do. It doesn't require that much. It requires consumption and execution velocity and all this. But vertical SaaS, I think, is not the right model of how you would attack a problem that is an AI native style problem. And I think that those are where all the interesting things will be. And again, I think a lot of the tactics that we're trying out at the beginning, they won't work. It'll turn out that they only work 95% of the time, and 5% of the time they punch you in the face or something. And that means that you have to be more adaptable and you have to assume that a scrappy thing will be more important.

**中文翻译:**
当一个行业在某些领域（比如垂直 SaaS）变得极其成熟时，我们知道如何完美地执行。我们确切地知道该做什么，这只需要执行速度。但我认为，垂直 SaaS 的模式并不适合解决“AI 原生”类的问题。我认为有趣的事情都将发生在那里。而且，我认为我们最初尝试的很多策略都不会奏效。结果会发现它们只有 95% 的时间有效，剩下的 5% 时间会出大丑。这意味着你必须更具适应性，并且要意识到“粗糙但快速”（scrappy）的东西会变得更重要。

---

### [00:16:28] Alex Komoroske

**English:**
One of the ways I put this is we've seen a vast reduction in the cost of distribution of information, and now we're seeing a reduction in the cost of information production. And most of it is slop. And so in this cacophony, how do you stand out? You stand out by having good taste. I think taste is the most important thing. You have a perspective that is different from the background noise, different from the average and that people find compelling. How do you find your own taste and how do you lean into that taste is, I think, much more important than just generically executing in the way that everybody else could do.

**中文翻译:**
我的一种说法是：我们已经看到了信息分发成本的大幅降低，现在我们正看到信息生产成本的降低。而其中大部分都是“垃圾内容”（slop）。在这一片嘈杂声中，你如何脱颖而出？答案是拥有“好品味”（good taste）。我认为品味是最重要的。你拥有一个不同于背景噪音、不同于平庸大众且让人信服的视角。我认为，发现并坚持自己的品味，比像其他人一样进行平庸的执行要重要得多。

---

### [00:17:01] Lenny Rachitsky

**English:**
There's so many threads I want to follow here, but maybe on just this last one, when you say taste, what do you mean by that? What should people think when they're like, "Okay, I got to work in my taste"?

**中文翻译:**
这里有很多我想深入探讨的话题，但先说这最后一个：当你提到“品味”时，你具体指什么？当人们想“提高品味”时，他们应该思考什么？

---

### [00:17:09] Alex Komoroske

**English:**
Taste, one way of looking at this is differentiate from what the LLM would've written if given the same prompt. How different, how distinctive is what you have to say. And I think so much in large industry, in large organizations is about fitting into the role. How can you be a better and more efficient cog in that particular kind of machine? And I think in this new world, what you want to do is how can I become the best version of myself? How can I lean into the things that I have an interesting perspective on that make me different? Those are the kinds of things. And now of course, if you lean into something and you're doing something out there and nobody resonates with it, then it doesn't count. Good taste is something that is individual and also compelling to others. And so find what things you say that resonate with other people and lean into that.

**中文翻译:**
品味的一种理解方式是：你的产出与 LLM 在相同提示词下写出的东西有多大的区别？你所说的话有多独特、多有辨识度？我认为在大公司、大组织里，很多时候是为了“适应角色”，即如何成为这台机器里更好、更高效的螺丝钉。但在新世界里，你应该思考的是：我如何成为最好的自己？我如何发挥那些让我与众不同的有趣视角？当然，如果你坚持的东西完全没人产生共鸣，那也不行。好品味既是个人的，也是能吸引他人的。所以，去寻找那些你能引起他人共鸣的东西，并坚持下去。

---

### [00:17:53] Lenny Rachitsky

**English:**
I love that. Back to the WebSim example, we'll link to this, but definitely play with WebSim. I was interviewing Dylan Field at Figma Config and this was his... Asked him like, "What's the number one thing you think people are going to get more excited about in the future that you're playing with now?" Because he's really good at identifying things that are going to be bigger in the future, and that was his choice. And it's very hard to understand exactly what it is if you just go there. But basically it's like you type a URL and it invents what that website is using just AI LLMs.

**中文翻译:**
太棒了。回到 WebSim 的例子，我们会附上链接，大家一定要去玩玩。我在 Figma Config 采访 Dylan Field 时，问他：“你现在正在玩的、你认为未来人们会最兴奋的东西是什么？”他非常擅长识别未来的大趋势，而这就是他的选择。如果你只是点进去，很难理解它到底是什么。但基本上，你输入一个 URL，它就会仅凭 AI LLM 凭空创造出那个网站的内容。

---

### [00:18:22] Alex Komoroske

**English:**
That's insane, as in. And you can get it to do, you realize as you play with it more, you can get it to do all kinds of specific things and you can steer it based on the way it uses the context of the last few pages. It creates a coherent world that's coherent with the things that you have recently seen, because you can steer it directly and you can watch fascinating people. They'll cover all kinds of wacky little techniques to get to generate, like generate a game for your kid that's on a specific type. You can do all kinds of stuff. And I'm not saying necessarily WebSim to me is a disruptive thing. Things that look alien and weird and yet are compelling, those are what we should be paying more attention to as opposed to take an existing playbook and slap something on it.

**中文翻译:**
这简直疯了。当你玩得越多，你会发现你可以让它做各种特定的事情，你可以根据前几页的上下文来引导它。它创造了一个连贯的世界，与你最近看到的东西保持一致，因为你可以直接引导它。你可以看到很多有趣的人用各种古怪的小技巧让它生成东西，比如为孩子生成一个特定类型的游戏。你可以做各种事。我并不是说 WebSim 本身就是颠覆性的，而是说那些看起来陌生、奇怪但又引人入胜的东西，才是我们应该关注的，而不是在现有的玩法上生搬硬套。

---

### [00:19:03] Lenny Rachitsky

**English:**
I love that. Another point that I saw you make about AI and the way it's different from other things we've done is most of the tools that we adopt in the workplace are collaborative where it helps your team be better, helps you collaborate better, and AI is the opposite. It makes you individually better. Can you talk about that insight?

**中文翻译:**
我喜欢这个观点。关于 AI，我还看到你提过一点：我们工作场所采用的大多数工具都是协作性的，旨在帮助团队变得更好、协作更顺畅，而 AI 恰恰相反，它让你个人变得更强。你能聊聊这个见解吗？

---

### [00:19:18] Alex Komoroske

**English:**
100%. I think this is one of the reasons is that the question right now of, okay, everyone's talking about AI and yet nobody's doing... There's no interesting breakout success obviously other than OpenAI and Anthropic obviously. So is there any value being created? I think it's entirely possible. And Ethan Mollick who's a good friend, who has an amazing blog who's absolutely worth reading, has pointed out, too, that this is a thing that make individuals better in a way they might not want to tell their manager about. I can now do my job twice as fast. And if the organization sees that, they might go, "Wait a second. We should pay you half this much." They're like, "What if we get rid of some extra people or something?"

**中文翻译:**
100% 同意。我认为这就是原因之一。现在大家都在谈论 AI，但除了 OpenAI 和 Anthropic，似乎还没有明显的爆发式成功。那么，AI 真的创造了价值吗？我认为完全有可能。我的好朋友 Ethan Mollick（他的博客非常值得一读）也指出，AI 让个人变得更强，但这种强大是他们可能不想告诉老板的。比如，“我现在做工作的速度快了一倍”，如果公司知道了，可能会想：“等一下，那我们是不是该少付你一半工资？”或者“我们是不是该裁员了？”

---

### [00:19:56] Alex Komoroske

**English:**
And so if this stuff is magical duct tape, it's very hard to make scaled, repeatable, large scale things out of it. It's very easy to do rig the shit out of anything. And so you'll see it being used in the small in a way that's almost entirely below the level of awareness of the seeing at the organization. The organization almost won't see it or sense it, and yet it could be adding significant value or just being used quite heavily. And I think this is one of the things that makes it if everything is happening in the long tail of usage, then you could conclude, "Oh, it's not being used for anything in the industry," but it's being used all over the place. I talked to Claude 20 times a day. I just have long conversations with it. I have tons of projects loaded up with all kinds of contexts on different topics, and I literally could not do the job I do now without having a conversation partner like Claude.

**中文翻译:**
所以，如果这些东西是“神奇胶带”，就很难用它做出规模化、可重复的大型项目，但却很容易用来搞定各种琐事。因此，你会看到它在微观层面被大量使用，而组织的高层几乎察觉不到。组织感知不到它，但它可能正在创造巨大价值，或者被频繁使用。如果所有的使用都发生在“长尾”部分，你可能会得出结论说“行业里没人用它”，但实际上它无处不在。我每天和 Claude 交流 20 次，进行长时间的对话。我有很多项目加载了各种主题的上下文，如果没有 Claude 这样的对话伙伴，我简直无法完成现在的工作。

---

### [00:20:48] Lenny Rachitsky

**English:**
Let me follow that thread real quick because a lot of people are like, "Okay," people keep telling me, "Play with AI. Use ChatGPT." Sometimes it's hard to see exactly what they can do with it. Can you give one example of how you found it really helpful or how you use Claude or another tool in your day-to-day?

**中文翻译:**
我想追问一下，因为很多人会说：“好吧，大家总让我玩 AI，用 ChatGPT。”但有时很难看清具体能用它做什么。你能举一个例子，说明你是如何在日常工作中发现它非常有用，或者你是如何使用 Claude 或其他工具的吗？

---

### [00:21:02] Alex Komoroske

**English:**
I use it to think through problems. And so like when I'm trying to name a concept or get a handle on a few different ways of looking at something, just saying, "Here's what's in my brain about this topic right now. Here's some relevant context." I have a number of projects that just stuff as much of the Bits and Bobs into the context as I can, which is very helpful. And I just say, "Just play with it. Just give me 10 examples of that thing," or then, "Critique these ones," or, "It feels like this one's the best one for me. What works about this? Why is this one the best?" Or, "I want to work at an angle now that has something about know Helen Nissenbaum's concept of contextual integrity. How would I layer that in?" It's just think of it as having a extremely well-read but slightly naive friend who is will never make you feel dumb and is willing to engage you in any particular topic you want to go down.

**中文翻译:**
我用它来思考问题。比如当我试图给一个概念命名，或者想从几个不同角度理解某件事时，我会说：“关于这个主题，我现在脑子里是这么想的，这是相关的背景信息。”我有好几个项目，尽可能多地把《零碎想法》塞进上下文里，这非常有帮助。我会说：“帮我发散一下，给我 10 个例子”，或者“评价一下这几个”，或者“我觉得这个对我来说最好，它好在哪里？为什么它是最好的？”或者“我想从 Helen Nissenbaum 的‘情境完整性’（contextual integrity）概念切入，该怎么结合？”把它想象成一个博学但略显天真的朋友，他永远不会让你觉得自己笨，并且愿意陪你深入探讨任何你想聊的话题。

---

### [00:21:49] Alex Komoroske

**English:**
So when you talk to an expert like a lawyer or a doctor or something, you know that that time is extremely valuable. You have a very small slice of time, and so there's tons of questions you don't even bother to ask. "That's a dumb question. I'm not going to spend $1,000 to answer that question." Whereas if you can have that conversation, now this is not saying use it for legal advice, but it can allow you to explore through a problem domain and then later check it with experts and say, "I believe this is a coherent outcome or a thing that should happen." And they can go, "Oh yeah, that works." So I use LLMs to help me. It's like getting a, it's like an electric bike for idea spaces. You can just cover so much more ground so much more quickly in them.

**中文翻译:**
当你咨询律师或医生等专家时，你知道他们的时间极其宝贵。你只有很短的时间，所以很多问题你根本不敢问，心想：“这是个蠢问题，我不想花 1000 美元去问这个。”而有了 AI，虽然不是说用它来替代法律建议，但它可以让你在某个领域进行探索，然后再去向专家核实：“我认为这是一个合理的方案。”专家可能会说：“没错，可行。”所以我用 LLM 来辅助我。这就像是为“思想空间”配备了一辆“电动自行车”，你可以更快地跨越更广阔的领域。

---

### [00:22:26] Lenny Rachitsky

**English:**
I love that metaphor because it builds on Steve Jobs's that computers are a bicycle for the mind. And that's really a beautiful way of thinking about it, that LLMs are like the electric bicycle for the mind.

**中文翻译:**
我喜欢这个比喻，因为它延伸了史蒂夫·乔布斯那句“电脑是人类大脑的自行车”。这是一个非常美妙的思考方式：LLM 就像是大脑的“电动自行车”。

---

### [00:22:37] Alex Komoroske

**English:**
I don't think if that's someone else's, the...

**中文翻译:**
我不确定这是不是别人先说的……

---

### [00:22:38] Lenny Rachitsky

**English:**
Oh, okay.

**中文翻译:**
噢，好吧。

---

### [00:22:39] Alex Komoroske

**English:**
I don't know where it came from. Part of my job is a collector of ideas, and so I try to put myself in the most interesting information streams with interesting people that I've found to have taste, have a perspective on something. Maybe I disagree with it, but they definitely have a coherent idea. And then I just allow myself to like, "Oh, that's a really good idea and let me build on that or let me..." I don't even know where that particular one came, but I'm 95% sure that somebody else said that.

**中文翻译:**
我不知道出处。我的部分工作就是收集想法，所以我努力让自己置身于最有趣的信息流中，接触那些有品味、有见解的人。也许我不同意他们的观点，但他们肯定有连贯的想法。然后我会想：“哦，这是个好主意，让我在此基础上继续发挥。”我真的不知道那个比喻是谁说的，但我 95% 确定是别人先说的。

---

### [00:23:05] Lenny Rachitsky

**English:**
I want to get to this idea of gardening versus building that is central to a lot of the way you think about it. But before we get there, I want to touch on another bit and bob that I love that you come back to occasionally, which is this idea of organizational kayfabe. Talk about what this idea of kayfabe is on its own and then how this applies to organizations in your experience.

**中文翻译:**
我想聊聊“园艺 vs. 建设”这个概念，这是你思维的核心。但在那之前，我想聊聊你在《零碎想法》里偶尔提到的另一个我非常喜欢的概念，即“组织性凯法贝”（organizational kayfabe）。请先解释一下什么是“凯法贝”，以及根据你的经验，它是如何应用在组织中的。

---

### [00:23:26] Alex Komoroske

**English:**
One thing I should flag before I dive into any this stuff, sometimes when people hear me talk about how organizations work and systems, they think I'm being cynical. And I want to be very clear, I'm hyper-optimistic and I also believe that one of the moral precepts is how do you maximize the agency of real humans as ends in and of themselves? And so sometimes when I get excited about this, people go, "Wow, that is so cynical." No, I'm just trying to describe the system as it actually exists. Once we know how it exists, we can figure out how to make it do great things and how we as members of this system can tweak and nudge it.

**中文翻译:**
在深入探讨之前，我得先声明一点：有时当人们听我谈论组织和系统如何运作时，会觉得我很愤世嫉俗。但我必须澄清，我是极度乐观的。我也相信一个道德准则：如何最大限度地发挥人类作为目的本身的自主性（agency）？所以当我兴奋地聊这些时，人们会说：“哇，太愤青了。”不，我只是在描述系统的真实面貌。一旦我们了解了它的现状，我们就能弄清楚如何让它成就伟业，以及作为系统成员的我们如何去调整和推动它。

---

### [00:23:56] Alex Komoroske

**English:**
So I just want to flag that before I dive into this. I have this slime mold deck which has gotten a ton of traction over the years, and part of the reason for that is because it feels like people tell me it feels like they think they're crazy and it feels like giving a big hug saying, "You are not crazy. Here's why this thing shows up." And once you acknowledge it, it feels like a bummer to acknowledge it, but once you do, now there's all kinds of options that pop up. "Oh, given that this thing is way more expensive than it looks, I can now do this instead. That one's 10 times cheaper. These two options, this one is way cheaper, way more likely to succeed." So once you see these forces, you see them more clearly.

**中文翻译:**
我那个关于“黏菌”（slime mold）的 PPT 这么多年来非常火，部分原因在于人们告诉我，这让他们觉得自己没疯。这就像给他们一个大大的拥抱，说：“你没疯，这就是为什么会出现这种情况。”一旦你承认了现实，虽然承认的过程可能让人沮丧，但之后就会出现各种选择。比如：“哦，既然这件事比看起来要昂贵得多，那我可以改做这件事，成本只有十分之一。在这两个选项中，这个更便宜且更有可能成功。”一旦你看清了这些力量，你就能看得更透彻。

---

### [00:24:28] Alex Komoroske

**English:**
So kayfabe is I think a lens that's useful to understand how organizations actually work. Kayfabe is a word that comes, I believe is a carny word that is used and applied to professional wrestling and it means a thing that everybody knows is fake and yet everybody acts like is real. And I think it's one of the defining forces within an organization, any organization. So kayfabe in the small is optimism, enthusiasm. When someone says, "We're going to do this thing," you say, "Yeah, we're going to do that," even if I think this isn't going to work. If you say, "I don't think this think is going to work," everyone loses hope and it definitely doesn't work. So having a little bit of this is extremely valuable. It's the lubricant that allows organizations to believe they can do something and to attempt to do it.

**中文翻译:**
“凯法贝”（Kayfabe）是一个非常有用的透镜，可以帮助理解组织的真实运作方式。这个词源于职业摔角，意思是“大家都知道是假的，但大家都演得跟真的一样”。我认为它是任何组织内部的核心力量之一。微观层面的“凯法贝”表现为乐观和热情。当有人说“我们要干这件事”时，你会说“好，我们一起干”，即使你心里觉得这行不通。如果你说“我觉得这行不通”，大家都会丧失信心，那这件事就真的彻底没戏了。所以，适度的“凯法贝”极具价值，它是让组织相信自己能成事并付诸行动的“润滑剂”。

---

### [00:25:09] Alex Komoroske

**English:**
The problem that you get is as organizations get larger, imagine you are five levels down or something and you have this project you're working on and you're trying to give a status update to be rolled up to leadership. And it's currently a yellow, and your manager asks it and you know it's not going to be presented to leadership and enrolled up until next week. "It's yellow, but I've got my arms around the problem. I know how to fix it. I'm going to go talk to Sarah. I think we have a solution. By the time this is reported up the chain, it's going to be green." So if I make it yellow, there's a non-trivial chance that someone's going to swoop down and say, "Well, what's going on? We have a review," and it will be way harder to fix, so I'm just going to... A little white lie.

**中文翻译:**
问题在于，随着组织变大，假设你在基层，正在做一个项目，需要向上级汇报进度。目前进度是“黄色”（有风险），你的经理来问你，而你知道这份报告下周才会送到领导层手里。你会想：“虽然现在是黄色，但我已经掌控局面了，我知道怎么修。我去跟 Sarah 聊聊，应该有方案。等到上报的时候，它肯定变绿了。”所以，如果我现在报“黄色”，很有可能会有人跑来干预说：“怎么回事？我们要开会审查”，这反而会让问题更难解决。所以，我就撒个小谎报“绿色”吧。

---

### [00:25:46] Alex Komoroske

**English:**
This is a totally reasonable thing to do. It's a self-defensive thing to do. And it's probably the right thing for the organization too. The problem is this happens up multiple layers and it compounds. So then your layer above you does the same, and the same, and the same, and levels up you can be many orders of magnitude off of the ground truth. And so the kayfabe, the thing that everyone pretends to believe is true, is obviously incorrect. And the dangerous part about this is it can lead you to make very bad decisions. And if you as someone who sees this can see that wait a second, the official strategy is definitely not going to work, you're like, "I got to tell somebody. We're doing work that's going in a bad direction. It's not going to work." And you go and say, "I think that it's actually not going to work for these reasons."

**中文翻译:**
这完全是合理的，是一种自我保护，甚至对组织来说可能也是正确的。问题是，这种情况会层层叠加。你上面那一层也这么做，再上面那一层也一样，到了高层，信息可能已经偏离真相好几个量级了。于是，这种“凯法贝”——即每个人都假装相信是真的东西——显然是错误的。危险之处在于，它会导致极其错误的决策。如果你看穿了这一点，意识到官方战略绝对行不通，你会想：“我得告诉别人，我们正朝着错误的方向努力，这成不了。”然后你去说：“我认为这行不通，理由如下。”

---

### [00:26:27] Alex Komoroske

**English:**
And what someone will say to you, this happens by the way, I'm not substituting any particular organization, this happens literally in all organizations to some degree, is the senior person will say, "Alex, I agree with you. It's not perfect, but if you hit the ground truth button, if you share that and everybody, the whole thing will shatter and we can't do anything. And so help me fix it. Don't say the ground truth. Just help nudge it and fix it." That's a good point. Okay, so you help working on it and then you realize a month later, wait a second, it's getting worse. We're doing things that's not good for the company. It's not creating user value. It's not good for the employees. They're burning out. It's just not good for anybody and it's getting worse. And so if you think you're going to go and hit the ground truth button, before you do, you'll be flying tackled to the ground by somebody and stabbed in the dark because you will destroy everything.

**中文翻译:**
这时，某人会告诉你（顺便说一下，这发生在所有组织中，不针对任何特定公司），某位高层会说：“Alex，我同意你的看法。它确实不完美，但如果你按下‘真相按钮’，如果你把实情公开，整个局面就会崩盘，我们就什么也做不成了。所以，帮我一起修补它吧。别说出真相，只要帮着微调和修复就行。”听起来有道理。于是你帮忙修补，但一个月后你发现情况更糟了。我们做的事对公司没好处，没创造用户价值，对员工也不好，大家都在倦怠。这对谁都没好处，而且还在恶化。如果你这时想去按下“真相按钮”，在你动手之前，就会有人把你扑倒在地，在暗处给你一刀，因为你会毁掉一切。

---

### [00:27:13] Alex Komoroske

**English:**
And so it becomes correct to hold onto this idea of if you acknowledge the kayfabe is false, then you are in danger of getting knocked out of the game. And so how do you do good things despite the fact that you're pulled in two different directions? And this increasingly in the limit, it can be good to a point where the easiest way is if I do, if I hold on this idea, we might create significant value for the company. If I let go of this idea, I die. So the easiest way to maintain this split-brain thing is to just turn this part off and just earnestly believe the kayfabe. This has been organizations become zombies, and anyone individually you talk to behind the scenes will agree yes, it could not possibly work. That turns out that these things work this way, and yet the entire organization lumbers on.

**中文翻译:**
因此，坚持“凯法贝”变成了正确的选择：如果你承认它是假的，你就有被踢出局的危险。那么，在被两种力量拉扯的情况下，你如何做正确的事？在极端情况下，最简单的方法就是：如果我坚持这个想法，我们可能为公司创造价值；如果我放弃，我就死定了。于是，维持这种“分裂大脑”状态的最简单方法就是关掉理性的那部分，转而真诚地相信“凯法贝”。这就是组织变成“僵尸”的过程：私下里你跟任何一个人聊，他们都会同意这绝对行不通，但整个组织依然在蹒跚前行。

---

### [00:27:56] Alex Komoroske

**English:**
And this is a death state for large organizations. It happens all over the place in any number of different conditions, and this is one of the reasons it shows up. And I think acknowledging that is an important way to help navigate and still make good grounded things happen. How can you allow disconfirming evidence to show up that doesn't kill you, that helps make you stronger? And if it all has to come in one massive moment that could ruin everything, then you aren't going to hear it. And then it will build up and build up and build up and build up into a super critical state that could shatter.

**中文翻译:**
这是大型组织的“死亡状态”。它在各种情况下随处可见，这就是原因之一。我认为承认这一点是寻找出路、让实事求是的事情发生的关键。你如何让“证伪性证据”（disconfirming evidence）出现，且不至于毁掉你，反而让你更强大？如果所有的真相必须在一个可能毁掉一切的巨大时刻爆发，那么你根本不会去听。于是问题会不断累积，直到进入一个随时可能崩塌的超临界状态。

---

### [00:28:27] Lenny Rachitsky

**English:**
I was just listening to a couple podcasts, and a thread that came up in a number of them is some of the most successful leaders, their instruction to their reports is, "As soon as there's bad news, I need to know as soon as possible. Do not shield me. I just want to know all the bad news as soon as possible." Feels like that's one solution to what you're describing.

**中文翻译:**
我最近听了几个播客，其中一个共同点是，一些最成功的领导者对下属的要求是：“一旦有坏消息，我需要尽快知道。不要替我遮掩，我只想尽快知道所有的坏消息。”这似乎是你所描述问题的一个解决方案。

---

### [00:28:44] Alex Komoroske

**English:**
Disconfirming evidence hurts, and so you won't realize it because it hurts at any given moment. It's like, "Ugh, it's a distraction. We're just trying to get this thing done." And so it comes from a good place to not get it, but if you're busy, that's one of the reason you need to take a step back. We take a step back, you're a little bit calmer. You can absorb this as confirming evidence. It doesn't feel like an existential threat. It's really easy to get surrounded. If you are very powerful, you will find all the confirming evidence you need. And if it doesn't exist, it will be created for you without your knowledge.

**中文翻译:**
“证伪性证据”是伤人的，你可能意识不到这一点，因为在任何时刻它都让人不爽。你会觉得：“呃，这太干扰了，我们只想把活干完。”所以不听坏消息往往源于一种“想把事办好”的初衷。但如果你太忙，这就是为什么你需要退后一步的原因。退后一步，你会更冷静，能把这些当成证据吸收，而不是觉得受到了生存威胁。如果你位高权重，很容易被包围：你会找到所有你需要的“证实性证据”；如果不存在，别人也会在你不经意间为你创造出来。

---

### [00:29:12] Alex Komoroske

**English:**
And so this is one of the reasons that large companies are radically different than smaller companies. And one of the traps that you can get into of not realizing this dynamic is happening, and you can make very bad decisions if you don't understand that it's inherently what's happening because they're all, "Oh, we'll have some bad actors." No, no, no. If people don't play this game, this game is emergent. It shows up even though everybody hates it. And if you don't play the game, you are knocked out of the game. The underlying dynamic that must be true in any organization on a fundamental basis is you can't make your boss look dumb because if you do, they're the person who decides, "Oh, this person's not performing," or whatever. And that one little asymmetry, that one little fact, in most cases it does not matter. That one little asymmetry is what leads to the systemic compounding thing where you get these really weird dysfunctional emergent things that everybody hates, nobody wants, and yet nobody is in the position to change per se.

**中文翻译:**
这就是大公司与小公司截然不同的原因之一。如果你没意识到这种动态正在发生，你就会掉进陷阱，做出非常错误的决策。这并不是因为有“坏人”，而是因为如果人们不玩这个游戏，他们就会出局。这种游戏是自发产生的，尽管大家都讨厌它。任何组织的一个基本底层逻辑是：你不能让你的老板看起来很蠢。因为如果你这么做了，他们就是那个决定你“表现不佳”的人。这种微小的不对称性，在大多数情况下看似无关紧要，但正是它导致了系统的复利效应，最终产生了那些怪异的、功能失调的、人人讨厌却又无人能改变的局面。

---

### [00:30:05] Lenny Rachitsky

**English:**
I love your caveat at the beginning that continues to resonate in my head as you say this. You're not cynical about, "This sucks." It's more, "Here's what I'm observing. We need to think about ways to get around this."

**中文翻译:**
我喜欢你开头的那个声明，它一直在我脑海中回响。你不是在愤世嫉俗地说“这太烂了”，而是说“这是我的观察，我们需要想办法解决它”。

---

### [00:30:16] Alex Komoroske

**English:**
Yeah. Because I think so much pain and misery is caused by us being not acknowledging these fundamental, inescapable things. It's almost impossible. Entropy is one of those things. Entropy emerges because there's more ways to go away from a point than towards a point. It fundamentally must be true in really any universe you can possibly imagine. And so if you're going to fight entropy, you're going to lose at a certain point. It's like if you are aware of these things, you can find subsets of ideas that do work despite these challenges. And that's some of the stuff, the tactics I advise are often things that look playful. They look unserious. They look like, "Oh, you're saying you don't know the answer?" No, I'm admitting I don't know the answer.

**中文翻译:**
是的。因为我认为很多痛苦和不幸都是因为我们不承认这些基本的、不可避免的事实。这几乎是不可能的。熵（Entropy）就是其中之一。熵之所以产生，是因为离开一个点的路径比走向一个点的路径多。在任何你能想象的宇宙中，这在根本上都是成立的。如果你要对抗熵，你注定会失败。但如果你意识到这些，你就能找到一些在这些挑战下依然奏效的想法。我建议的一些策略通常看起来很像在“玩”，看起来不严肃。人们会问：“哦，你是说你不知道答案？”不，我是在承认我不知道答案。

---

### [00:30:55] Alex Komoroske

**English:**
And I'm saying it doesn't matter if I don't know the answer because this thing, this very small seed I am planting is so cheap that yes, I can't tell you for sure this will work, but I could tell you there is a chance that it'll work. And the downside of this is basically the opportunity cost of planting the seed in this one moment, and the person who's planting it enjoys planting it so that an opportunity cost really isn't that much because they get energy from doing it. So who cares? Plant a bunch of these suckers. If one of these grows into an oak tree, that's great. Don't try to analyze beforehand which seed is going to turn into an oak tree. If it's super simple to plant the seeds, then plant the seeds. And if it starts growing, then keep watering it. That's it. That's the thing.

**中文翻译:**
我的意思是，我不知道答案也没关系，因为我种下的这颗小种子非常便宜。虽然我不能肯定它会成功，但我可以告诉你它有成功的机会。失败的代价仅仅是那一刻种下种子的机会成本，而种种子的人本身乐在其中，所以机会成本其实并不高，因为他们从中获得了能量。所以，管它呢，多撒点种子。如果其中一颗长成了橡树，那就太棒了。不要试图预先分析哪颗种子会长成橡树。如果播种很简单，那就去播种。如果它开始生长，那就继续浇水。就是这样。

---

### [00:31:30] Alex Komoroske

**English:**
And people sometimes will see this as like, I've been called in my list before because they said, "Well, you're saying that you don't know the answer to the thing." It's like no, I'm saying I don't have to know the answer to the thing. If on a systemic basis I let these ideas and then you respond to the ones that are working that are viable, it doesn't really matter if you didn't know ahead of time which ones were going to work.

**中文翻译:**
有时人们会因此质疑我，说：“你是在说你不知道问题的答案。”不，我是说我“不需要”预先知道答案。如果从系统层面，我允许这些想法产生，然后对那些行之有效的想法做出反应，那么预先知道哪个会成功就不重要了。

---

### [00:31:48] Lenny Rachitsky

**English:**
It's a great segue to talking about this core idea that again informs a lot of the way you think, which is this idea of building versus gardening, the magic of acorns. Talk about this general idea and then I want to follow some threads.

**中文翻译:**
这正好引出了你的核心观点，即“建设 vs. 园艺”，以及“橡子的魔力”。请聊聊这个大概念，然后我想深入探讨一些细节。

---

### [00:32:02] Alex Komoroske

**English:**
So much of the way that we tackle problems and build products is this builder mindset. It's like, "I have a plan, I then manipulate things to match my plan and make it happen." And this is a way you can create tons of value. Part of the problem though is it can't possibly create more value than the effort that you put into it. And so what I look for instead are things that can be gardened, things that can grow on their own and that you can direct or maybe give a little bit of extra energy to or curate over, and is a totally different mindset for it. So it's like a lead by gardening vibe. I don't try to pick the things in the system. I try to work with what I've actually got and I try to lean in on the ones that turn, I think are going in the direction that I believe is valuable based on constantly seeking disconfirming evidence.

**中文翻译:**
我们处理问题和构建产品的方式大多是“建设者心态”：我有计划，我操纵事物来匹配计划。这能创造价值，但问题是，它创造的价值上限就是你投入的精力。相反，我寻找的是可以被“园艺化”打理的东西，它们能自我生长，而你只需引导、给予额外能量或进行维护。这是一种完全不同的心态，一种“园艺式领导”的氛围。我不试图强行挑选系统中的事物，而是利用现有的资源，并倾向于那些我认为正朝着正确方向发展的苗头，同时不断寻找反面证据来修正。

---

### [00:32:44] Alex Komoroske

**English:**
And if you do this properly, it looks like magic. It looks like a thing. It looks like getting lucky because what you're doing is you're farming for miracles. And so on a systemic basis, I can't tell you which of these things will work, but I can tell you there's a very high likelihood that one of these will work in a way that is interesting and transformative. And so if you're looking and finding these seeds that have the compounding potential of if they work, they would start working at an accelerating rate, then you don't have to know ahead of time. To me this is, I've been told that this is completely against all the advice that people get building products nowadays, but I think it's a very powerful approach that works in a lot of different contexts.

**中文翻译:**
如果你做得对，它看起来就像魔法，像运气好，因为你是在“播种奇迹”（farming for miracles）。在系统层面上，我无法告诉你哪一个会成功，但我可以告诉你，极有可能其中一个会以一种有趣且具有变革性的方式奏效。如果你寻找并发现这些具有复利潜力的“种子”——即一旦成功就会加速发展——那么你就不需要预先知道结果。虽然这违背了当今主流的产品建议，但我认为这是一种非常强大的方法。

---

### [00:33:26] Lenny Rachitsky

**English:**
Is there an example that you can give from either from something you worked on or something someone worked on that came or true miss? Because I think people hearing this might be like, "But I got to ship stuff. I got to hit some goals. I don't have time to sit around and garden and plant seeds. I got to actually build."

**中文翻译:**
你能举个例子吗？无论是你参与的项目还是别人的。因为听众可能会想：“但我得发版啊，我得达成目标。我没时间坐那儿搞园艺、种种子，我得实实在在地去‘建设’。”

---

### [00:33:41] Alex Komoroske

**English:**
If there's an ecosystem approach, if there's something that if it works, it'll be self-accelerating. So okay, what you're going to do this thing, we aren't entirely sure what's going to work, but if a developer writes a thing and somebody uses it, it'll attract more developers, more users, and then this would grow on its own. Then and it's cheap to do the little example of the thing. It's cheap to build a little open source, tinker the little thing and just put it there. And if nobody uses it, it's fine. It was fun to build. It took you three hours. It's fine. If someone does use it, then you just invest in incremental bit of unit each time that you find a signal that somebody is finding it useful and then you stop if you ever cease getting that information.

**中文翻译:**
如果采用生态系统的方法，如果某件事一旦成功就会自我加速。比如，我们不确定什么会奏效，但如果一个开发者写了个东西，有人用了，它就会吸引更多开发者和用户，然后自我生长。做一个小原型是很便宜的，做一个开源小工具放在那儿也很便宜。如果没有人用，也没关系，开发过程很有趣，只花了你三小时。如果有人用，那么每当你发现有用的信号时，你就追加一点投入；如果信号消失了，你就停止。

---

### [00:34:16] Alex Komoroske

**English:**
So I would use this. Anything that is shaped like an ecosystem that has some kind of network effect, and many things have network effects, have some kind of compounding loop. Compounding loops are not rare. They are, "Look." It's like truffle hunting. You have to know what you're looking for and find the dynamics of a thing that if it worked would work at an accelerating rate. Lots and lots and lots of things intrinsically have this shape. Anything with a network effect, anything where the power goes up with a number of users, but it shows up in all kinds of problems that we don't normally apply it to.

**中文翻译:**
我会把这种方法用在任何具有生态系统特征、具有网络效应或某种复利循环的事物上。复利循环并不罕见。这就像寻找松露，你必须知道自己在找什么，找到那种一旦启动就会加速发展的动态。很多事情本质上都有这种形状：任何有网络效应的东西，任何效用随用户数增加而增加的东西。它也出现在很多我们通常不会联想到它的问题中。

---

### [00:34:47] Lenny Rachitsky

**English:**
Along the same lines, you also advise people to think more emergence-oriented versus top-down, kind of what you were just saying. But I think that's another really interesting way of thinking about the same idea, create opportunities for emergence, bottom-up versus top-down control. You just chat about that.

**中文翻译:**
顺着这个思路，你也建议人们更多地考虑“涌现”（emergence）导向，而不是自上而下，就像你刚才说的。我认为这是思考同一个想法的另一个有趣方式：创造涌现的机会，即自下而上 vs. 自上而下的控制。你能聊聊这个吗？

---

### [00:35:03] Alex Komoroske

**English:**
100%. I think the emergence is one of the most powerful forces if you know how to marshal it and you know how to work with it. And the only thing that's hard about it in my opinion is you're going to look like you aren't very serious. You're going to look like a weirdo. You're going to look like a cook. And one of the downsides, if you're working on something and you're doing the normal top-down approach where you make the plan, you execute the plan, even if the plan turns out to not be useful, you produce a thing and nothing interesting happens, no one can say you didn't work hard. But if you try doing this designing for emergence and something amazing happens, even once it happens, people go, "Ah, it's luck. Where was the miraculous moment, the heroic moment where you made that happen? So therefore you had nothing to do with it."

**中文翻译:**
100% 同意。我认为如果你知道如何引导和利用“涌现”，它就是最强大的力量之一。在我看来，唯一的难点在于你会看起来不那么“严肃”，像个怪人或疯子。如果你采用传统的自上而下方式，制定计划并执行，即使最后没用，也没人能说你没努力。但如果你为“涌现”而设计，结果发生了奇迹，人们反而会说：“啊，那是运气。哪里有什么你亲手创造奇迹的‘英雄时刻’？所以这事儿跟你没关系。”

---

### [00:35:42] Alex Komoroske

**English:**
And this was the biggest unlock in my career actually was when I stopped my guts. I was promoted to director at Google. I was like, "Cool, I never want to be promoted inside of a large organization ever again." And the freedom to now do the highest impact work, even if I can't make it legible to the organization, was so powerful and I was able to 10X my impact for the organization because I didn't have to worry about making it measurable specifically in a way that would show individual work effort. And I think that's the hardest part. And you have to have, typically what I would advise for PMs, my approach at Google was 70% of my effort and my team's effort should go on things that everybody acknowledges are important and useful and create value. Maybe it's boring, linear value, but some kind of value. You're trying to minimize the chance that any other person in a company will say, "What does that team do anyway?"

**中文翻译:**
这其实是我职业生涯中最大的突破。当我在 Google 被提升为总监（Director）时，我想：“太好了，我再也不想在大公司里晋升了。”这种不再追求晋升的自由，让我能去做影响力最大的工作，即使这些工作在组织看来并不那么“显眼”。我能将对组织的影响力提升 10 倍，因为我不再担心如何以一种显示个人努力的方式来量化工作。我认为这是最难的部分。我通常对 PM 的建议是（也是我在 Google 的做法）：将 70% 的精力放在大家都公认重要、有用且能创造价值的事情上。也许是枯燥的线性价值，但必须有价值。你要尽量避免公司里有人问：“那个团队到底是干嘛的？”

---

### [00:36:32] Alex Komoroske

**English:**
This, if someone says this about your team, your team is on the verge of death. And so you're trying to minimize the chance that anybody wants to say that or thinks that it's appropriate to say that by clearly and unambiguously adding value. You're not saying this is the best team in the entire world, but clearly they're doing something useful. They're executing well. They're working hard. And of course that team should exist. Think about it, of course they should. But now once you do this, you have 30% of your extra time that you can plant all these seeds.

**中文翻译:**
如果有人这么评价你的团队，那你的团队就离死不远了。所以你要通过清晰、明确地创造价值，来消除这种质疑。你不需要证明自己是世界上最好的团队，但要证明你们在做有用的事，执行力强，工作努力。这样，大家就会觉得这个团队理应存在。一旦做到了这一点，你就有 30% 的额外时间去播种。

---

### [00:36:55] Alex Komoroske

**English:**
You can find interesting little things where maybe a junior PM on the team has an idea you think it's kind of silly, but they're really into it. And the there is this thing, it could work out great actually. If you tweak it like this, there is a potential. I could see how that could work. If that PM is going to work on that anyway, they want to do it anyway. Instead of saying, "No, no, no, we don't have time for that. Be a little bit more productive over here," say, "Go for it. Here's my concerns. I imagine this part might not work, but this part is really cool right here." And then if it doesn't work, then they've stretched their agency. They've executed. They've exercised their agency. They've learned. They've gotten stronger. They've grown. It has the upside if it turns out to actually work. And worst case scenario, the opportunity cost to doing the thing that helped them grow and they learn and they liked. So I don't know. Don't try to force it. Don't try to stop it.

**中文翻译:**
你可以发现一些有趣的小事，比如团队里的初级 PM 有个你觉得有点傻但他们很投入的想法。你可以想：其实这事儿没准能成，如果这么改一下，就有潜力。既然那个 PM 无论如何都想做，与其说“不行，我们没时间，去干点正事”，不如说：“去做吧。这是我的顾虑，我觉得这部分可能不行，但那部分很酷。”如果失败了，他们也锻炼了自主性，学习了，成长了。如果成功了，那就是意外之喜。最坏的情况也不过是花了点时间让他们成长。所以，不要强求，也不要阻拦。

---

### [00:37:40] Lenny Rachitsky

**English:**
That's a really good example of actually how to go about doing that on your team. The way I've always thought about this is the visual I share with people is like, you want to create cover fire for your team where your team's just hitting goals, moving metrics, and then while with that cover fire, you're building the doomsday bomb inside, protected where no one's going to come and stop you.

**中文翻译:**
这是一个关于如何在团队中实施这一点的绝佳例子。我一直以来的想法是：你要为团队创造“掩护火力”（cover fire），让团队在前方达成目标、提升指标，而在掩护之下，你在内部秘密建造“终极武器”，受到保护，没人会来阻挠你。

---

### [00:37:58] Alex Komoroske

**English:**
Yeah, because one of the hardest parts about an acorn when you plant it is making sure a squirrel doesn't dig that fucker up. There's so many things that can destroy it, and just keeping it, allowing it some space and allowing it some time is the most important thing. And it's challenging to do, but that's why it's important as a leader to have enough credibility in the organization that people can see that you are doing useful work to give you the space, to give your team the space to do this truly great work. If you want to get your team to do good work, there's a million different paths to do that. If you want to get your team to do great work, there's no shortcut other than to have an extremely high-trust environment where people lean into their superpowers in a way that adds up to something greater than some of its parts. That takes time. It takes effort. It's very difficult to make legible up to the rest of the organization, but that is where great things come from.

**中文翻译:**
没错，因为种下橡子后最难的部分就是防止松鼠把它刨出来。有太多东西可以摧毁它，给它空间和时间是最重要的。这很有挑战性，所以作为领导者，在组织中拥有足够的信誉至关重要，这样人们才会因为看到你在做有用的工作而给你和你的团队空间，去完成真正伟大的事业。如果你只想让团队做“好”工作，有一万种方法；但如果你想让他们做“伟大”的工作，除了建立一个极度高信任的环境，让每个人发挥超能力并产生 1+1>2 的效果外，别无他法。这需要时间和精力，很难向组织解释清楚，但伟大的事物正是由此诞生的。

---

### [00:38:46] Lenny Rachitsky

**English:**
It reminds me of something Ed Catmull shared in Creativity, Inc., this idea of the ugly baby, that every new idea is an ugly baby and nobody wants this ugly baby. Everyone's just like, "Get this out of here," because every new idea is bad initially.

**中文翻译:**
这让我想起 Ed Catmull 在《创意公司》（Creativity, Inc.）中分享的观点：每个新创意都是一个“丑陋的婴儿”，没人想要它。大家都会说“把它弄走”，因为每个新创意最初都是不完美的。

---

### [00:39:00] Alex Komoroske

**English:**
Yeah, it sucks. They're just like this ugly thing that barely works or... But this is why what I try to do is I try to see the greatness, the seeds of greatness in everything. Everyone and everything around me, I look for, I try to find and see, man, what is the most compelling part of this? And let me lean into that. And so one of the things I try to do when I meet with people, when I mentor them, I try with it within the first session or two, whenever I can get a hypothesis, I say, "I think your superpower is..." And I describe to them what I think I can see them being truly exceptional at.

**中文翻译:**
是的，它很糟糕，就像一个勉强能运行的丑东西。但这就是为什么我努力在每件事中寻找“伟大的种子”。对于我周围的每个人和每件事，我都会寻找最吸引人的部分，并以此为基础。当我指导别人时，我通常会在前一两次交流中提出一个假设，我会说：“我认为你的超能力是……”然后描述我眼中他们真正卓越的地方。

---

### [00:39:31] Alex Komoroske

**English:**
And sometimes I get it wrong, especially if I try to do it earlier, but when people feel very seen and they feel acknowledged for that, they now are willing, they're going to stretch farther and they're going to respond to nudging feedback even better because they know that you're not trying to tell them be different. You're trying to tell them be more, and you now the nudges will feel less like a stop energy and more like someone who gets me and can help me grow even more. And you can get some amazing things out of people when you just treat them with the respect. I assume that everyone I talk to, everyone I talk to is interesting, has seeds of greatness in them, even if they don't recognize necessarily where they are.

**中文翻译:**
有时我会看走眼，尤其是太早下结论时。但当人们感到自己被“看见”并被认可时，他们会愿意付出更多，对反馈的接受度也会更高。因为他们知道你不是在要求他们“改变”，而是在鼓励他们“超越”。这样，你的建议就不再是阻力，而更像是知己在助其成长。当你尊重每个人，假设每个谈话对象都是有趣的、都有伟大的种子（即使他们自己还没意识到），你就能从他们身上挖掘出惊人的潜力。

---

### [00:40:08] Alex Komoroske

**English:**
Someone described to me actually this morning in one of my little dirt clubs I run about they help facilitate about treat everybody like the Buddha. I think is I'm messing this up, but this notion of imagine everyone you talk to is the Buddha, in a Buddhist mindset, and how do you see and find those seeds of greatness and treat everyone with respect intrinsically as an end of themselves. This is one of those things that you do to be a compassionate human. It's also, I believe, a way to maximize the amount of value, direct and indirect value, that's created. So it's one of those win-win-win-win-wins where just it's the right thing to do as a person and a member of society, and it's also the thing that can create a lot of business value and create real value in the world.

**中文翻译:**
今天早上在我运行的一个小俱乐部里，有人提到要“像对待佛陀一样对待每个人”。大意是想象你交谈的每个人都是佛陀，用佛教的心态去发现他们身上的伟大种子，并把每个人都作为目的本身来尊重。这不仅是做一个慈悲的人，也是最大化创造直接和间接价值的方式。这是一个多赢的选择：作为社会成员，这是正确的事；同时，它也能创造巨大的商业价值和现实价值。

---

### [00:40:49] Lenny Rachitsky

**English:**
[Ad break for Coda]

**中文翻译:**
[Coda 的广告环节]

---

### [00:41:57] Lenny Rachitsky

**English:**
Coming back to a phrase that you used earlier, slime molds, I want to spend a little time here. So interestingly enough, the first time I heard about you and what got me interested in your stuff is I did a newsletter post with the company Perplexity about how they build product. And as they were describing how they organized their team, the co-founders described they organized like slime mold, and he linked to your deck about slime molds and I was like, "What the heck is this?" Can you just briefly describe what you mean when you talk about slime molds and how slime molds are related to the way companies are organized and how they should think of the organization?

**中文翻译:**
回到你之前提到的一个词，“黏菌”（slime mold）。我第一次听说你，是因为我给 Perplexity 公司写了一篇关于他们如何打造产品的文章。在描述团队组织方式时，创始人说他们像“黏菌”一样组织，并链接到了你关于黏菌的 PPT。我当时想：“这到底是什么鬼？”你能简要描述一下你所说的“黏菌”是什么意思吗？它与公司的组织方式有什么关系？

---

### [00:42:32] Alex Komoroske

**English:**
Yeah. The main thesis of the slime mold deck is that the core dynamic that makes organizations hard to navigate as they get larger, even if you assume everyone is actively good at what they do, actively collaborative and actively hardworking, is this emergent force or coordination of finding the subset of projects to work on when everyone's super busy that everyone agrees and commits to and actually works on together. And finding this coordination cost grows with the square of the number of people who are working on that thing. And so what companies typically try to do is fight this or ignore that it exists.

**中文翻译:**
是的。那个 PPT 的核心论点是：随着组织变大，即使假设每个人都优秀、协作且努力，最难处理的动态依然是“协调”。即在大家都极度忙碌时，如何找到一个大家都认同、承诺并共同努力的项目子集。这种协调成本随着参与人数的平方而增长。通常，公司会试图对抗这种力量，或者假装它不存在。

---

### [00:43:06] Alex Komoroske

**English:**
If you're going to fight it, the one way to look at this is think of a company like a vehicle. When the company is very small, you can drive it, you can steer it like a sports car. As a founder, you are allowed to steer. Everyone acknowledges you are allowed to steer. They're never, "Why is he steering it that way?" So you, a founder, can help navigate an organization around an obstacle the organization cannot see or comprehend itself. The problem is as you steer, as you grow into the size, your organization goes from a sports car and you grow into the size of a big rig, if you drive a big rig like a sports car, you're going to be a danger to yourself and others on the road and you're going to grind the engine. And so you got to drive the car that you actually have.

**中文翻译:**
如果你想对抗它，可以把公司想象成一辆车。公司很小时，你可以像开跑车一样驾驶它。作为创始人，你有权转向，大家都认可这一点。你可以带领组织绕过它自身无法察觉的障碍。问题是，随着规模扩大，你的组织从跑车变成了重型卡车（big rig）。如果你像开跑车一样开重型卡车，你会对自己和他人造成危险，还会磨损引擎。你必须根据你拥有的车型来驾驶。

---

### [00:43:41] Alex Komoroske

**English:**
So what I see a lot of things happen in large organizations, that people are just trying to ignore this fact. And when you drive, by the way, a car, your vehicle, like a big rig, when it is a big rig, people go, "Oh, it means to go slow." No, no, no. It means pivot less. It means have a little bit more... Be more intentional about the times that you adjust the steering, invest more in program management, invest more in processes, give a little bit more slack in the planning process to absorb any kind of surprising things that you can still all reach the product launch at the same time.

**中文翻译:**
在大公司里，我看到很多人试图忽视这个事实。顺便说一下，当你像开重型卡车一样驾驶时，人们会觉得“这意味着要慢下来”。不，不，不。这意味着要“减少转向”。这意味着在调整方向时要更加慎重，投入更多精力在项目管理和流程上，在计划中留出更多余地来吸收意外，以确保大家能同时到达产品发布的终点。

---

### [00:44:13] Alex Komoroske

**English:**
The other option you can do is you can split your thing up into a series a swarm of sports cars, individual sports cars. And the downside of this, you'll get the autonomy and strengths of the bottom-up, the downside is other people will externally will look at it and go, "Well, that team and that team clearly didn't talk." You'll say, "Yep, yep." You have to decide how bad that is for you. Apple has chosen the former. It's very important to them to have the illusion of perfect coherence in their products. It worked very well for them. They executed marvelously. And if you also picked the exact opposite thing, everyone else is like, "Yeah. There are like 15 different ways of doing everything. They clearly don't talk to each other." But it allows the overall swarm of the AWS product suite to be very powerful and anti-fragile or whatever you want to say.

**中文翻译:**
另一种选择是将组织拆分成一群独立的跑车。这样做的好处是拥有自下而上的自主权，坏处是外界会看出来：“那个团队和这个团队显然没沟通过。”你会回答：“没错。”你得决定这对你来说有多糟。Apple 选择了前者，对他们来说，维持产品完美的连贯性错觉至关重要，他们执行得非常出色。而如果你选择相反的方式（比如 AWS），大家会觉得：“每件事都有 15 种不同的做法，他们显然互不理睬。”但这让 AWS 的产品套件像蜂群一样强大且具有“反脆弱性”。

---

### [00:44:52] Alex Komoroske

**English:**
And so slime molds, I think, is acknowledging that organizations are, especially ones that focus on autonomy and agency of their individual employees, which is a lot of tech companies, they are more like slime molds than we realize. And if you fight that fact, you're going to have a bad time. And if you embrace it, then you can start realizing slime molds are actually kind of amazing. They can find solutions to problems you didn't even know you were searching for.

**中文翻译:**
所以，“黏菌”理论就是承认组织（尤其是那些强调员工自主性的科技公司）比我们想象的更像黏菌。如果你对抗这个事实，你会很痛苦；如果你拥抱它，你会发现黏菌其实很神奇，它们能找到你甚至都没意识到自己在寻找的问题答案。

---

### [00:45:15] Lenny Rachitsky

**English:**
Alex, you have the best metaphors. I don't know how you do this, but they're so evocative and correct.

**中文翻译:**
Alex，你太擅长打比方了。我不知道你是怎么做到的，但它们非常形象且准确。

---

### [00:45:21] Alex Komoroske

**English:**
I can tell you that the process I do if you're into it.

**中文翻译:**
如果你感兴趣，我可以告诉你我的思考过程。

---

### [00:45:23] Lenny Rachitsky

**English:**
Please. That would be incredible.

**中文翻译:**
请讲，那太棒了。

---

### [00:45:25] Alex Komoroske

**English:**
I think by talking, I'm an external processor, I literally can't think if I'm not talking. And so I make sure I have as many interesting meetings as I can, and that's where I discover what I think, by talking to people. And the test is if I say a frame, something that the person goes, "Ooh," or like, "Ooh," they go, "Aha," that's a win. That's a mark that's a good one. You're just randomly casting about. I find one. And then if a different person also has a similar response, if a person in sales and a person in engineering both find the same idea interesting, that's a very good sign that lots of people will find it interesting, how diverse in terms of background skill sets, perspectives are the people who resonate with the thing you're saying.

**中文翻译:**
我是通过说话来思考的，我是一个“外部处理器”，如果不说话我简直没法思考。所以我尽可能多地参加有趣的会议，在与人交谈中发现自己的想法。测试标准是：如果我说了一个框架，对方发出“噢”或“啊哈”的感叹，那就是赢了，说明这个比喻很好。我只是在随机尝试。如果不同背景的人（比如销售和工程师）都觉得同一个想法有趣，那这就是一个非常好的信号，说明很多人都会感兴趣。产生共鸣的人背景越多样，这个想法的潜力就越大。

---

### [00:46:08] Alex Komoroske

**English:**
The intuition of this is if you find in a social network, you want to see what's going to go viral, if something is shared and it's shared within, so the people who are at the beginning are all highly densely interconnected in the social graph, then the implied ceiling is relatively small. You only know it works with that audience. But if it's people that are very different subclass and very little overlap, they both find it interesting, that implies a much larger max audience. So you're looking for ideas that resonate with the diversity of people. And then once you find them, each time you get something like that, you invest a little more time in it and you think a little bit more about framing it the next time.

**中文翻译:**
这背后的直觉是：在社交网络中，如果你想看什么东西会走红，如果它只在高度重合的圈子里传播，那它的上限很小。但如果两个完全不同、几乎没有交集的群体都觉得它有趣，那说明它有巨大的潜在受众。所以你要寻找能引起多样化人群共鸣的想法。一旦找到了，你就多花点时间打磨它，思考下次如何表达得更好。

---

### [00:46:42] Alex Komoroske

**English:**
I haven't done this during this chat, but in most conversations, you'll see me as I'm talking writing down stuff like, "Ooh, that was the best formulation of that one so far." And so you keep on coming back to it. You keep on tightening it and seeing how, watching how it's responding and referring with different people through like, "Where do you get these from?" It's like I got thousands and thousands and thousands of little examples or metaphors or whatever that's sick.

**中文翻译:**
虽然这次聊天我没这么做，但在大多数对话中，你会看到我一边说一边记：“噢，这是目前为止对那个观点最好的表述。”然后你会不断回顾它，不断精简它，观察不同人的反应。人们问：“你从哪儿搞来这些比喻的？”其实我有成千上万个这样的小例子或隐喻。

---

### [00:47:03] Alex Komoroske

**English:**
One of the benefits of metaphorical thinking is you connect nine of the 10 dots and you invite the listener to engage with the argument to connect that last dot. This allows you by the way to say very controversial things, because if you say connect all the 10 dots and it's like, "Oh, that's the official strategy," then you are instantly a dangerous thing. Whereas if you leave one dot unconnected, people can go connect the dot and go, "Oh my god, I think that applies to us." You're like, "Oh my god, what?" "Yes, that's why I picked that." But to counteract this because now it's less obvious to people that's correct, you have to make the metaphor evocative and interesting.

**中文翻译:**
隐喻思考的一个好处是：你连接了 10 个点中的 9 个，然后邀请听众参与进来连接最后一个点。顺便说一下，这能让你说出一些非常有争议的话。如果你把 10 个点全连上，直接说“这就是官方战略的弊端”，那你立刻就变得很危险。但如果你留一个点不连，人们会自己连上并惊呼：“天哪，我觉得这说的就是我们！”你会装作惊讶：“天哪，真的吗？”但为了弥补这种不确定性，你必须让隐喻足够形象和有趣。

---

### [00:47:39] Alex Komoroske

**English:**
One of the reasons that slime mold deck got so much traction is partially because slime is gross, it's bad, and yet it's talking about why slime is good. And so that has this instantly subversive thing. I only know this after the fact of trying to figure out why did that deck get so much attention of all the things I've written.

**中文翻译:**
那个“黏菌”PPT 走红的原因之一是，“黏液”通常让人觉得恶心、不好，但它却在讨论为什么黏菌是好的。这具有一种天然的颠覆性。我也是在事后分析为什么那篇东西比我写的其他东西都火时才意识到这一点的。

---

### [00:47:56] Lenny Rachitsky

**English:**
It also is all emojis basically, which is not how you often read a deck. It's very beautifully made. I love that you've been talking about the way you think and come up with ideas is by talking to people and having conversations. We also talked about how you write in this Bits and Bobs approach. I asked someone that you worked with at Stripe what to ask you, and she said to ask you about strategy salons, which feels like a good avenue for this sort of thing. Can you talk about what these are and how you set these up?

**中文翻译:**
而且那个 PPT 基本上全是表情符号，这很不寻常，做得非常漂亮。我喜欢你提到的通过交谈来思考和产生想法的方式。我们也聊了你的《零碎想法》写作法。我问过一位你在 Stripe 的前同事该问你什么，她说让我问问“战略沙龙”（strategy salons），这似乎是产生这类想法的好途径。你能聊聊那是什么以及你是如何组织的吗？

---

### [00:48:26] Alex Komoroske

**English:**
So these I also call now nerd clubs, and these are my secret weapon. And I have a blog post. I started writing right before my second kid was born, and then he was born three weeks early and I just lost the plot and now it's like a 40-page draft of a thing that I'll probably never finish. But I've used this tactic. I discovered it many years ago as they strengthen some of the techniques I'd used in open source community organizing.

**中文翻译:**
这些我现在也叫“书呆子俱乐部”（nerd clubs），它们是我的秘密武器。我曾想写篇博客介绍它，但在我第二个孩子出生前没写完，结果孩子早产了三周，我就把这事儿忘了，现在那只是一个 40 页的草稿，可能永远完不成了。但我一直在用这个策略。我是多年前在加强开源社区组织技巧时发现它的。

---

### [00:48:58] Alex Komoroske

**English:**
The situation was I was just joining a new team at Google. I've been there for many years, and there was at the time 12 different groups working in different aspects of this overall problem domain. And in classic Google fashion, they added up to significantly less than the sum of their parts, as in not like, "Oh, we'll see which one works," but, "These two things directly undermine each other. If you execute both of these strategies, neither can work." And I knew that if you try to do pairwise executive reviews on this very complex, ambiguous, open-ended problem, you would get really expensive pageantry that would obscure more than clarified.

**中文翻译:**
当时我刚加入 Google 的一个新团队。那时有 12 个不同的小组在处理同一个大问题的不同方面。按照 Google 的典型风格，他们的合力远小于各部分之和。不是那种“看哪个能成”，而是“这两个策略直接互相拆台，如果两个都执行，哪个都成不了”。我知道，如果针对这种复杂、模糊、开放式的问题进行一对一的高管审查，只会演变成一场昂贵的“政治表演”，反而会让问题更模糊。

---

### [00:49:17] Alex Komoroske

**English:**
So what I did was I created a secret group that I called Navel Gazers was the original one, and I wanted people when they hear about it, I want people to go, "That will be a club for nerds." They're like, "Yeah, do you want in?" And so this means that only people who intrinsically want to be in it for its own sake come in. So you get only a positive "yes, and" kind of energy. So then within these groups, you say, you set the norms very explicitly and say, "This is a collaborative debate environment. This is only 'yes, and'." If somebody says a thing in this group that is optional and secret and completely off the side of anything that matters, if they say something that you think is an actively dumb idea, you are free to not engage. Just leave it. That's fine. Because nothing's going to happen. We're deciding anything interesting or important here.

**中文翻译:**
所以我创建了一个秘密小组，最初叫“沉思者”（Navel Gazers，原意为盯着肚脐看的人，讽刺空谈）。我希望人们听到这个名字时会想：“那肯定是个书呆子俱乐部。”然后我会问：“对，你想加入吗？”这意味着只有那些纯粹感兴趣的人才会进来。这样你就得到了一种积极的、“是的，而且”（yes, and，即兴表演原则）的能量。在小组里，我会明确规定：这是一个协作辩论环境，只准说“是的，而且”。如果有人提出了一个你觉得很蠢的想法，你可以选择不理会，随它去。这没关系，因为我们在这里并不做任何正式决定。

---

### [00:49:57] Alex Komoroske

**English:**
And if you want to engage and you don't like it, a productive way of doing that is saying, "Oh, that's so interesting. I would never would've thought to apply that lens. I typically would apply this lens to that kind of problem. I wonder if that applies here." And by saying, "I wonder," you make it about you, not them. And so that person can choose if that's an interesting thing to build on or not. This sounds by the way very non-rigorous feel like, "Ah, how can you possibly get rigorous thinking in the 'yes, and'?" It turns out there's limited amounts of time and so people will choose to build on the things they find most interesting. This is interesting things are surprising and potentially valuable. And so if lots of different people in the group are building on the same idea, that's a good sign there is something very interesting going on.

**中文翻译:**
如果你想参与但不同意对方，一种高效的方式是说：“噢，太有趣了，我从没想过用那个视角。我通常会用这个视角看这类问题，我在想它是否也适用？”通过说“我在想”，你把问题引向了自己，而不是攻击对方。这样对方可以自行决定是否继续深入。这听起来可能不够严谨，但事实证明，由于时间有限，人们会自发选择在最有趣的想法上继续发挥。有趣的想法通常是令人惊讶且具有潜在价值的。如果小组里很多人都在讨论同一个想法，那就是一个信号，说明这里面大有文章。

---

### [00:50:35] Alex Komoroske

**English:**
The third thing you do is you dribble in new perspectives. Every one to three a week, if you put in lots of new perspectives, once the norms can all scramble, if you have one in five people who all have a very particular kind of personality can mess up the norms, and so you're trying to minimize the chance you add a jerk. It takes one person to poop a party and go, "What are we even doing here?" You want to minimize the chance that happens. But second or thirdly and more importantly, you want to have as people with as different perspective as possible added into the group. And so this is what Ken Stanley might call, for example, novelty search. You're novelty-searching through the different perspectives in the overall thing.

**中文翻译:**
第三件事是不断引入新视角。每周引入一到三个新成员。如果一次引入太多，原有的规范可能会乱掉。如果五个人里有一个性格古怪的人，就可能破坏氛围，所以要尽量避免招进“杠精”。只要一个人说“我们在这儿干嘛呢？”，就能毁掉整个派对。但更重要的是，你要引入视角尽可能多样化的人。这就是 Ken Stanley 所说的“新颖性搜索”（novelty search），你在通过不同的视角进行搜索。

---

### [00:51:10] Alex Komoroske

**English:**
When you do this properly, you get something magical. You get a group that people find intrinsically valuable for its own sake and just enjoy participating in and find meaning in, that also stochastically spins off changing insights for the surrounding context because you're searching through these ideas in a low stakes environment where the ideas that lots people build on, they go, "Oh, you should write that down." And this is like an idea lab, what everyone will call an idea lab. And this creates amazingly interesting insights. You just can't force it to do anything. It has to be a bottom-up and emergent, which means if you try to steer it towards an outcome, it won't go. But if you do these, they are amazing places to riff and to share ideas and half-formed ideas. And this is anywhere I go, I terraform the culture around me and create these, because I need it as a place to experiment and try out different half-formed ideas and build on them and be inspired by other people.

**中文翻译:**
如果你做得对，奇迹就会发生。你会得到一个让成员感到纯粹快乐和有意义的小组，同时它会随机产生一些能改变现状的见解。因为你在一个低风险的环境中搜索想法，当大家都在讨论某个点时，会有人说：“噢，你应该把这个写下来。”这就是所谓的“创意实验室”。它能产生惊人的见解，但你不能强迫它产出。它必须是自下而上、自发涌现的。如果你试图引导它达成某个特定结果，它就失效了。无论我走到哪里，我都会通过建立这种小组来“改造”周围的文化，因为我需要一个地方来实验那些不成熟的想法，并从他人那里获得灵感。

---

### [00:52:03] Alex Komoroske

**English:**
And that is one of my secrets, strategy secrets that I've been doing now for probably 10 years ago is when the first one started. And there's now I can count eight or nine of I've started over the years. Some of them emerged. So many of them are still at Google. And I think it's like they're just wondrous environments that I think create a lot of value.

**中文翻译:**
这是我的战略秘密之一，我已经做了大概 10 年了。我先后创办了八九个这样的小组，有些是自发形成的。很多小组现在依然在 Google 运行。我认为它们是创造巨大价值的神奇环境。

---

### [00:52:21] Lenny Rachitsky

**English:**
And I love it's a perfect example of your approach of emergent properties, letting things emerge versus a top-down, "Here's what we're doing and here's what we're talking about here." If someone wanted to set this up within their company or within friends, any advice? What are some constraints and ways of setting it up for success?

**中文翻译:**
我喜欢这个例子，它完美诠释了你让事物“自发涌现”的方法，而不是自上而下地规定“我们要聊什么”。如果有人想在公司或朋友间建立这样的小组，你有什么建议？有哪些约束条件或成功的窍门？

---

### [00:52:37] Alex Komoroske

**English:**
Communities are all about momentum. You want to have a space too small, a time too short. If you have a big cabinet space of a lot of people in it and no one's talking, people go, "I guess this is the place where we don't talk," for whatever reason. So what you're doing is you want the smallest seed of people that you know are going to be actively engaged. So maybe there's four of you that already talk over lunch and you talk about whatever topic and it's always really interesting and generative. Cool, get that group together and do a thing. And then incrementally add people who you think are going to like that already as it currently exists. And then you need to feed it so you want to make sure that it never dies.

**中文翻译:**
社区的核心在于“势头”（momentum）。空间要小，时间要短。如果你有一个很大的群组，里面有很多人但没人说话，大家就会觉得“这地方就是不说话的”。所以，你要从最小的“种子人群”开始，找那些肯定会积极参与的人。比如你们四个人经常在午餐时聊一些有趣的话题，那就把这四个人聚在一起。然后逐渐增加那些你认为会喜欢现有氛围的人。接着你需要“喂养”它，确保它不会枯竭。

---

### [00:53:09] Alex Komoroske

**English:**
And a community with no people talking is definitely dead. A community with one person talking is already dead. You don't realize it yet. And so you're trying to maximize the chance that there's an interesting conversation even when you as the facilitator are not there. This takes some active policing by the... Like a garden has a gardener, there's somebody pruning back and saying, "Hey Jeff, just so you know, I think that came out a little bit strong to Sarah's idea and maybe next time add 'I wonder' to the front of that statement," or whatever.

**中文翻译:**
一个没人说话的社区肯定是死的；一个只有一个人说话的社区其实也已经死了，只是你还没意识到。所以你要最大化“即使你不在场，也有有趣对话发生”的机会。这需要一些主动的维护。就像花园需要园丁，需要有人去修剪，比如私下对某人说：“嘿 Jeff，我觉得你刚才对 Sarah 的回应有点太冲了，下次试着在开头加个‘我在想’。”

---

### [00:53:35] Alex Komoroske

**English:**
The other thing that you do is when people reach out to you and ping you, they go, "Hey, let's think about this thing," and you go, "That's a really interesting idea. You should share that in the group." And then they do. And then you engage in the group and say, "That was really interesting," little emoji response. And people who didn't watch the interaction assume that Sarah just decided proactively to stick her neck out and share that and that it worked. And so this becomes a self-sustaining norm in the community. And it's not a secret. It's not if someone asks, "Yeah, I told Sarah to share that," but people watching don't realize that. And so it becomes a place that people do take risks and feel comfortable sharing.

**中文翻译:**
另一件事是，当有人私下找你聊一个好主意时，你会说：“这主意太棒了，你应该发到群里。”当他们发出来后，你立刻在群里互动，发个表情说“太有趣了”。其他没看到私下交流的人会以为 Sarah 是自发分享的，而且得到了好评。这就会变成社区里一种自我维持的规范。这并不是什么秘密，如果有人问，我会承认是我让 Sarah 发的，但旁观者通常意识不到这一点。于是，这里就变成了一个大家愿意冒险、乐于分享的地方。

---

### [00:54:07] Alex Komoroske

**English:**
The other thing you do is once a week or so, you want to make sure that you never propose something in the group that people go, "Eh." You always want to do a thing people go, "Yeah." So what you do is you see that if you're talking to other people, you say, "I wonder if we should have a live conversation every so often, right?" The chats were so fun, but it goes, "Would you come if I did one?" "Oh yeah, I would." "Okay, great." So now I say, "Hey, a few of us are talking. We're just going to do an experiment. We're going to have an hour-long conversation over lunch on Wednesday. Anyone in the group is free to come."

**中文翻译:**
还有，大约每周一次，你要确保你提议的事情大家都会响应。所以你会先私下问几个人：“我在想我们要不要偶尔搞个直播讨论？之前的聊天很有趣，如果我办一个，你会来吗？”如果他们说会，我才会公开说：“嘿，我们几个商量了一下，打算周三午餐时间搞个一小时的实验性讨论，欢迎大家参加。”

---

### [00:54:33] Alex Komoroske

**English:**
And then what you do is you make sure it always has quorum because if it doesn't have quorum, then the thing, it looks like the community's dead. And then what you do is you send FOMO stuff afterwards. So you say, "Here's my notes from the thing," or, "Thanks Sarah, Jeff," blah, blah, blah, blah, "or an amazing conversation. I thought the insight about," blah blah blah, "was so ridiculously amazing." So you want people who were in the group who didn't come to feel like they missed out and to come to the next one.

**中文翻译:**
然后你要确保每次活动都有足够的人参加，否则社区看起来就像死了一样。活动结束后，你要制造“错失恐惧感”（FOMO）。你会发一些笔记，或者说：“谢谢 Sarah 和 Jeff，刚才的对话太精彩了，那个关于某某的见解简直绝了。”这样，那些没参加的人就会觉得自己错过了好东西，下次就会想来。

---

### [00:54:57] Alex Komoroske

**English:**
And so you're constantly creating these kinds of vibes to how to do it. You can't do it if you don't have somebody with a lot of energy. I'm typically the seed crystal for a lot of the groups I'm in to start them off because I have a lot of energy, and I like, anything that people have to say that I think is open-minded or interesting, I like building on and "yes, and"-ing and that kind of gives the foundation that it can grow. But look for the people who already roughly want it. Don't try to convince somebody who doesn't want it to want it. They will not. They will ruin the whole thing.

**中文翻译:**
你就是在不断创造这种氛围。这需要一个精力充沛的人。我通常是这些小组的“晶种”（seed crystal），因为我精力旺盛，而且喜欢在别人的有趣想法上继续发挥。但要寻找那些本来就想要这种氛围的人，不要试图去说服那些不感兴趣的人，他们会毁了整个氛围。

---

### [00:55:30] Lenny Rachitsky

**English:**
I just love this playbook for starting to build a little bit of community within a company. Have you written about this by the way? And if not, you should write a whole post about this.

**中文翻译:**
我太喜欢这套在公司内部建立小社区的玩法了。顺便问一下，你写过相关的文章吗？如果没有，你应该专门写一篇。

---

### [00:55:37] Alex Komoroske

**English:**
I have. It's a long essay and it's just not, you can see it in Bits and Bobs. If you gave the Bits and Bobs to Claude and said, "Please write a thing about nerd clubs and essay and the style," it would do it because there's a lot of the pieces are in there, it's just not factored out.

**中文翻译:**
我写过，是一篇长文，就在《零碎想法》里。如果你把《零碎想法》喂给 Claude，让它写一篇关于“书呆子俱乐部”的文章，它能写出来，因为所有的素材都在里面，只是还没整理成文。

---

### [00:55:52] Lenny Rachitsky

**English:**
I see you writing something down right now, which tells me you just articulated something in a new way that you want to say.

**中文翻译:**
我看到你现在正在记东西，这说明你刚才又用一种新的方式表达了一些你想说的话。

---

### [00:55:52] Alex Komoroske

**English:**
Yeah, that's right. That's right.

**中文翻译:**
没错，正是如此。

---

### [00:55:59] Lenny Rachitsky

**English:**
You mentioned this idea of constraints of time, and it reminds me of something that you shared in one of your Bits and Bobs around productivity. You say that if you have two hours to do a five-minute task, the effort to do that is impossible and instead you should flip that. Can you talk about this insight and how to be a little more productive?

**中文翻译:**
你提到了时间约束的概念，这让我想起你在《零碎想法》里分享的一个关于生产力的观点。你说如果你有两个小时去做一个五分钟的任务，那几乎是不可能完成的，你应该反过来。你能聊聊这个见解以及如何变得更高效吗？

---

### [00:56:15] Alex Komoroske

**English:**
Yeah, I think a lot of the trick to productivity is to play yourself like a fiddle and figure out how you work and what gives you energy and set up your day to structure it that way. So I find every time you start a task, there's an activation energy, especially a task you don't really want to do. And then when you complete it, there's a boop. There's a little burst of energy. So if you do this properly, you can get small things that are extremely easy to knock out in 10 seconds of effort, and then you do one that takes 30 seconds of effort, and then you do one that takes a longer bit of effort. But if you give it too much space, it's harder to do.

**中文翻译:**
是的，我认为生产力的诀窍在于像摆弄乐器一样“摆弄”你自己，弄清楚你的工作方式和能量来源，并以此安排你的日程。我发现每开始一项任务都需要“活化能”（activation energy），尤其是那些你不想做的任务。而当你完成它时，会有一小股能量爆发。如果你安排得当，你可以先花 10 秒钟搞定一件小事，再花 30 秒搞定另一件，然后去做更难的事。但如果你给它太多时间，反而更难开始。

---

### [00:57:01] Alex Komoroske

**English:**
So you almost want to find, "Okay, listen, I got 10 minutes. I got to do this thing where I figure out how to add, do this thing in gusto that I've been putting off. Ten minutes should be enough time to do it and structure it. So okay, right now is the only time I have to do this, to do it." And another trick is I use one of my original media messages actually, one of the original public ones is about always rules are better than sometimes rules for self-control. And so if you're going to diet, "I'm going to skip lunch every day." Like holy, you haven't full thought on that at some point like a day with a big executive review, "I really need to make sure I'm well-fed before I go into this review," or something. And now you've broken the streak and now it's over.

**中文翻译:**
所以你最好告诉自己：“听着，我只有 10 分钟，我必须把那件拖了很久的事办了。10 分钟足够了，现在是我唯一能做这件事的时间。”另一个技巧是：在自我控制方面，“总是”规则优于“有时”规则。比如减肥，如果你说“我每天都不吃午饭”，这很难坚持，因为某天有个重要会议，你觉得自己必须吃饱。一旦你打破了连续记录，计划就泡汤了。

---

### [00:57:50] Alex Komoroske

**English:**
Whereas if you say a thing you know can do, "I will not have a dessert unless it would be socially awkward for me to not eat it. For example, in a small environment where somebody made homemade dessert and all of us are eating it, I'm going to..." So very clear black and white rule that you can hold on forever. So for example, since the pandemic started, I've done a Peloton workout every single day since the pandemic started.

**中文翻译:**
相反，如果你制定一个你能做到的规则，比如：“除非不吃会显得社交失礼（比如在小聚会上，主人亲手做了甜点），否则我不吃甜点。”这是一个非常明确的黑白分明的规则，可以永远坚持下去。举个例子，自疫情开始以来，我每天都会进行 Peloton 健身，从未间断。

---

### [00:57:56] Lenny Rachitsky

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:57:56] Alex Komoroske

**English:**
And now once I do start going back into the office, if I had to commute into the office, I would sometimes do a meditation to check the box for that. But if I'm not commuting and I'm not deathly sick, I've done a full workout since then. And the idea each day of is today the day of all the hundreds of days in this streak that is the worst or the hardest for me to do this thing? Is this the day? No, of course it's not. I will do it. And so that keeps you in this streak that makes it harder and harder to get out of it. And in some ways, of course you can torture yourself in an unproductive way like at a certain point maybe you should stop that streak, but I think those kinds of structuring help you get the things done you want to get done.

**中文翻译:**
现在如果我要回办公室，通勤路上我会做个冥想来完成当天的任务。但只要我不用通勤且没生重病，我都会完成完整的锻炼。每天我都会问自己：在已经坚持了几百天的记录里，今天真的是最难、最糟糕的一天吗？显然不是。所以我还是会去做。这种连续性让你越来越难放弃。当然，你不能盲目折磨自己，但在某种程度上，这种结构能帮你完成你想做的事。

---

### [00:58:38] Lenny Rachitsky

**English:**
It's like the Seinfeld trick of productivity where you just keep track of how many days in where you've done something essentially.

**中文翻译:**
这就像是 Jerry Seinfeld 的生产力秘诀：在日历上画叉，不要中断那个链条。

---

### [00:58:45] Alex Komoroske

**English:**
Yeah, exactly. And I think people don't give those kinds of tactics enough credit because there's lots of little social tricks to yourself and others. This is when you have other people who are depending on you for something and will know that you didn't do the thing, that were so much better. So just little tricks like this help you be wildly more productive.

**中文翻译:**
没错。我认为人们对这类技巧重视不够，因为对自己和他人使用一些“社交小手段”非常有效。尤其是当别人依赖你，且知道你没做某事时，效果会更好。这些小技巧能让你变得极其高效。

---

### [00:59:02] Lenny Rachitsky

**English:**
Actually, I want to go back a little bit. I'm curious what you wrote down when we were chatting earlier that you thought was a good articulation if you're able to share, if it's interesting,

**中文翻译:**
我想回到刚才那个话题。我很好奇你刚才记下了什么，如果你觉得方便且有趣的话，能分享一下吗？

---

### [00:59:11] Alex Komoroske

**English:**
I wrote down, and the reason I wrote it down is I've never... And by the way, I collect everything even once I think are maybe onto something. So I wrote down, "A community with zero people speaking is dead and a community with one person speaking doesn't yet realize it's dead," is what I wrote down.

**中文翻译:**
我记下来了，因为我以前从没这么表达过。顺便说一下，我会收集所有的灵感。我写的是：“一个没人说话的社区是死的，而一个只有一个人说话的社区还没意识到自己已经死了。”

---

### [00:59:24] Lenny Rachitsky

**English:**
So fun. I love this practice that you have.

**中文翻译:**
太有意思了。我喜欢你这个习惯。

---

### [00:59:28] Alex Komoroske

**English:**
By the way, the reason I can do it, I can type insanely quickly. And in undergrad, I wrote my thesis on the emergent power dynamics in Wikipedia's user community and I did 150 hours of interviews with different editors in Wikipedia, and I transcribed them myself. And so I got really, really, really good at I can just pipe an idea straight into my fingertips and still listen to other stuff. So that's another superpower is I've just constantly, I'm able to capture it very, very quickly. I've written notes that are at least good enough for me to clean up within the next day or two into something that's more stable.

**中文翻译:**
顺便说一下，我之所以能做到这一点，是因为我打字极快。大学时我的论文是关于维基百科用户社区的权力动态，我做了 150 小时的采访并亲自转录。所以我练就了一项本事：能一边听别人说话，一边把想法直接通过指尖打出来。这是我的另一项超能力，我能极快地捕捉灵感。我记下的笔记至少能保证我在一两天内能把它们整理成更正式的内容。

---

### [01:00:04] Lenny Rachitsky

**English:**
Is there a way you built this other than... Was it just you did it and you had to do it and you just figured out how to move fast?

**中文翻译:**
除了练习，还有别的秘诀吗？还是说你只是因为必须做，所以就学会了如何变快？

---

### [01:00:08] Alex Komoroske

**English:**
I just realized later that I could type really good, really fast. I could just pipe it straight through to my fingers and it worked. And, I don't know, I don't know if I hadn't written my thesis, would I have discovered that? I don't know.

**中文翻译:**
我后来才意识到我打字又好又快。我可以直接把想法传导到手指上。我不知道如果没写那篇论文，我还会不会发现这个能力。

---

### [01:00:22] Lenny Rachitsky

**English:**
I feel like everything you do is on super speed, the way you think, the write and get stuff done. There's a lot.

**中文翻译:**
我觉得你做的每件事都是超高速的：你的思考、写作和办事。这需要大量的……

---

### [01:00:30] Alex Komoroske

**English:**
... a lot of compute.

**中文翻译:**
……大量的算力。

---

### [01:00:32] Alex Komoroske

**English:**
... when you're feeling productive, you're unstoppable. And so just how can you be in your flow state as much as possible? And there's things that absolutely completely grind me to a halt, and I just make sure I invest my time in situations that don't have that characteristic. So when I work on something that I believe could work and have a big impact, I can't stop. Sometimes I'll wake up at 4:00 in the morning as I'm typically an early riser and I'm just like, "I'll write this thing." The meeting starts at 7:00 and I just think there's an idea that's really cool here and I let myself lean into those kinds of when I have the moment.

**中文翻译:**
当你感到高效时，你是势不可挡的。所以关键是如何尽可能多地处于“心流”状态。有些事会让我彻底停滞，我会尽量避开那些情况。当我做一件我认为可行且有重大影响的事时，我根本停不下来。有时我凌晨 4 点起床（我习惯早起），心想“我要把这个写下来”。即使 7 点就有会，只要我觉得有个很酷的想法，我就会全身心投入。

---

### [01:01:05] Alex Komoroske

**English:**
I also find that often if I have an idea and I just have itching to write it down, if I can write down 30 minutes and get a very rough of it in one place, now it's easier to clean it up later. But that first act of creation, I do it whenever the muse hits because it's 10 million times if it's like, "Oh, write that idea down later," you keep on delaying it, delaying it, now it's a month later. "What was the idea? How did that work again?" It's gone. And so I just try to capture the interesting insights. It's like a butterfly collector. The butterflies are going by, I try to collect them and put them in my collection as quickly as possible.

**中文翻译:**
我还发现，如果我有个想法并渴望写下来，只要花 30 分钟写个草稿，以后整理起来就容易多了。但最初的创作行为，我一定要在灵感降临时完成。因为如果说“以后再写”，你就会一直拖，一个月后你就忘了那个想法到底是什么了。所以我努力捕捉有趣的见解。这就像收集蝴蝶，当蝴蝶飞过时，我要尽快把它们收入标本盒。

---

### [01:01:38] Lenny Rachitsky

**English:**
Or garden as one might describe it.

**中文翻译:**
或者像你说的，“搞园艺”。

---

### [01:01:40] Alex Komoroske

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:01:43] Lenny Rachitsky

**English:**
This touches on a quote I wanted to talk to you about. I think you described it as your life philosophy. "Do things that give you energy that you are proud of." Talk about that.

**中文翻译:**
这涉及到了我想和你聊的一句话。你曾把它描述为你的生活哲学：“做那些能给你能量、且让你感到自豪的事。”聊聊这个吧。

---

### [01:01:54] Alex Komoroske

**English:**
So to me, it's the combination of when you're doing something you believe in and that gives you energy, you are 10 times more productive. And you also, the effort that you are doing is its own reward. And so you are indefatigable on that topic and you go for much longer. So finding the substance of things that align with you that give you energy, then just it's like infinite energy. It's like they give an opportunity cost because it energizes you more than the opportunity cost of the time to go spend to other things.

**中文翻译:**
对我来说，当你做一件你相信且能给你能量的事时，你的效率会提高 10 倍。而且，你付出的努力本身就是回报。你会变得不知疲倦，坚持得更久。所以，找到那些与你契合、能给你能量的事物，就像拥有了无限能源。它们带来的能量远超你花费时间的机会成本。

---

### [01:02:21] Alex Komoroske

**English:**
And two, there are ways to give yourself energy, like for example, playing a video game, or there's any kind of mind-altering substance that might give you that like, "This gives me energy." Those are not things that I'm not saying do those. I'm saying what are the things that you'll look back and say, "I'm glad I did that. I'm proud that I did that." And if you take the perspective of a 10 years on looking back on each decision and thing that you're doing, and imagine seeing this decision played in front of 1,000 people whose opinion you care about, your family, your friends, your role models, would you be proud is a good sign of life that you're taking a broad enough perspective.

**中文翻译:**
其次，有很多事能给你能量，比如玩游戏或某些物质，但我不是在说那些。我说的是那些你回头看时会说“我很高兴我做了那件事，我为此感到自豪”的事。如果你站在 10 年后的视角审视现在的决定，想象这个决定展示在 1000 个你关心的人（家人、朋友、榜样）面前，你是否依然感到自豪？这是一个判断你是否拥有足够宽广视角的良好信号。

---

### [01:02:55] Alex Komoroske

**English:**
When you're busy and in the moment, it's so easy to say, "I just got to do this one thing that's probably not great to get this thing done. And once I do it, it's going to suck. But once I do it, it'll be fine." And then you find yourself doing it again and again and again and again and before you know it, you've lost who you want to be and you're now a husk of yourself. And so I think those two pieces lean into where you find energy, where you specifically find energy, your superpower, the thing that you intrinsically enjoy doing, and just make sure it's something that you are actively proud of and that helped make sure you don't take a bunch of shortcuts.

**中文翻译:**
当你忙碌时，很容易妥协说：“我只需要做这件不太好的事来把活干完，虽然感觉很糟，但做完就好了。”然后你会一次又一次地这样做，不知不觉中，你失去了自我，变成了一个空壳。所以，要坚持那两点：投入到能给你能量、你真正喜欢的事情中，并确保那是让你感到自豪的事，这能防止你为了走捷径而迷失自我。

---

### [01:03:29] Lenny Rachitsky

**English:**
Along those same lines, I think a lot of people have heard a version of this quote, which is, "New things that give you energy." So one, I love the additional piece of it is, "and that you're proud of." Two, you have another quote that I love that makes you think deeply about stuff, which is, "The secrets of life is things you've heard a million times already, you just weren't ready to hear them." Talk about that insight.

**中文翻译:**
顺着这个思路，很多人听过“做给你能量的事”这个版本。首先，我喜欢你加的那句“且让你自豪”。其次，你还有另一句让我深思的话：“生活的秘密在于那些你已经听过一百万次的事，只是你之前还没准备好去听懂它们。”聊聊这个见解。

---

### [01:03:53] Alex Komoroske

**English:**
So this I call the Hallmark card fallacy, which is you discover at great effort some deep insight that resonates with you and makes you see the world differently, and you want to share it. Insights are naturally viral. You want to share them and you go tell someone, it's like, "Guys, guys, the point of life is the friends we made along the way." And people go, "That's from a Hallmark card, man." And to you, it is you now possess the knowledge, the emotional intelligence to understand why that phrase has been shared so many times. Before, you heard it when you weren't ready and now it becomes a trite, "Duh, everyone says that. That can't possibly be a meaningful statement."

**中文翻译:**
我称之为“贺卡谬论”（Hallmark card fallacy）。你费尽周折发现了一个深刻的见解，它让你看世界的方式都变了，你迫不及待想分享。见解具有天然的传播性。你跑去告诉别人：“伙计们，人生的意义在于一路上结交的朋友。”别人会说：“那是贺卡上的陈词滥调，老兄。”但对你来说，你现在拥有了理解那句话为何被传颂千万次的知识和情商。以前你听的时候还没准备好，所以觉得它平淡无奇：“切，大家都这么说，这肯定没意义。”

---

### [01:04:30] Alex Komoroske

**English:**
The reason people keep on saying it is because it's meaningful. And so I think that having that space of recognizing it, that when you have these epiphanies that come from different leaps in vertical development or the ability to, when you stare into the abyss and make it through the other side, you realize and learn a bunch of amazing things that you want to pass on others, and it's just really hard to get them to find it.

**中文翻译:**
人们之所以一直说它，是因为它真的有意义。当你经历了认知的飞跃，或者当你凝视深渊并成功走出来后，你会产生这些顿悟，学到很多想传授给别人的惊人道理，但很难让别人也立刻领悟。

---

### [01:04:53] Alex Komoroske

**English:**
I find that that's one of the reasons I try to write things that are or share ideas that are like little seeds that you can shoot into someone's brain even if the soil's not ready for it, it's rocky or craggy, at some point in the future, if something goes through there and opens up a crack, that's sitting there to grow into an idea. One of the things that makes me the happiest is when someone I've mentored years and the years in the past, they go search me out years later and say, "Alex, I just want to let you know, you probably don't even remember talking to me, but that Tuesday at the building, the no-name cafe or whatever, on Google campus, you said something I was frustrated to hear in the moment I didn't understand it. And I just want to tell you, thank you because I finally understand what you were trying to tell me. And I realized that that influenced me in the decisions." That to me is one of those meaningful things I can hear.

**中文翻译:**
这就是为什么我尝试写一些像“小种子”一样的想法，把它们射进别人的大脑。即使现在的土壤还没准备好，即使那里布满岩石，但在未来的某个时刻，如果出现了一道裂缝，那颗种子就会在那里生根发芽。让我最开心的事之一，就是多年前我指导过的人在很久以后找到我，说：“Alex，你可能不记得我了，但在 Google 园区的某个咖啡馆，你说的某句话当时让我很困惑甚至沮丧，但我现在终于明白了。我意识到那句话影响了我的决策。”对我来说，这是最动听的话。

---

### [01:05:41] Lenny Rachitsky

**English:**
Man, that must feel so good to hear those sorts of closing the loop on something long ago. The point you make about cliches that you've heard a million times actually finally feeling right and profound, I had this very experience. I did a psychedelic trip with some friends a while ago, and at the end of it I was just like, "Man, love is all you need. Love is all you need." I felt that so deeply through the experience and I was telling people, they're like, "Shut up."

**中文翻译:**
天哪，听到这种跨越时空的反馈一定感觉很棒。关于那些听了一百万次的陈词滥调最终让你感到深刻，我也有过类似的经历。不久前我和朋友尝试了一次迷幻体验，结束后我感叹道：“伙计，爱就是你所需要的一切。”我在那次体验中深刻地感受到了这一点，但当我告诉别人时，他们只会说：“闭嘴吧。”

---

### [01:06:16] Alex Komoroske

**English:**
You telling, oh, do you just do psychedelics? Yeah, it's funny.

**中文翻译:**
你是说，哦，你刚试过迷幻剂？哈哈，真有意思。

---

### [01:06:19] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:06:19] Alex Komoroske

**English:**
I have a lot of folks in my broader space who obviously have used it. So I never personally have myself, but I find there's various ways. The transcendent mindset is this feeling of being part of something much, much, much larger than yourself and losing your ego in this thing. There's different ways of doing it. Some people will find it in hiking and being out in the wilderness alone. Some people find it being at a concert and thousands of people perfectly in sync to this thing. Some people find it in religious experience. Some people find it using psychedelics and others to help get there. But a lot of it, it's that same just being willing to be in awe.

**中文翻译:**
我认识的很多人都用过。我个人没试过，但我发现有很多种方式可以达到那种境界。那种“超然的心态”是一种感觉自己是某个宏大事物的一部分、并忘却自我的感觉。有人通过独自徒步，有人通过在演唱会上与万人同步，有人通过宗教体验，也有人通过迷幻剂。但核心都是一样的：愿意去感受“敬畏”。

---

### [01:06:53] Alex Komoroske

**English:**
There's so many times that people feel the feeling of awe or wonder or curiosity is treated as a not very serious or childlike thing. And I just don't get that because that is how you are open to disconfirming evidence. It's how you see beyond the current limits of what you... Your ego gets hurt when you get disconfirming evidence. You don't want to hear it. And so you'll construct the world around yourself to not get that disconfirming evidence. But disconfirming evidence is what makes systems strong. It's what makes you strong. And so how do you put yourself in the situation to get that information and really receive it?

**中文翻译:**
很多时候，敬畏、好奇或惊叹被视为不严肃或幼稚的表现。我不理解这种看法，因为这正是你对“证伪性证据”保持开放的方式。它能让你看透当前的局限。当收到反面证据时，你的自尊会受挫，你不想听，于是你会构建一个屏蔽这些证据的世界。但反面证据正是让系统和个人变得强大的原因。所以，你如何让自己置身于能接收并真正吸收这些信息的境地？

---

### [01:07:28] Alex Komoroske

**English:**
And part of it is just coming in terms of the fact of early in my career, someone called me kooky a bit. Oh, man. I must be embarrassed. I'm like, "Okay, fine. Yeah, I'm kooky, whatever." I'm totally at peace with the idea that some people track me as kooky and not particularly serious. I think people who watch the work that I do and the indirect impact it has realize that I'm doing something that is working even if they don't fully understand how it works.

**中文翻译:**
部分原因在于接受现实。职业生涯早期，有人说我有点“古怪”（kooky）。我当时可能会觉得尴尬，但现在我会说：“好吧，我就是古怪，随你怎么说。”我完全接受有些人认为我不够严肃或古怪。我认为那些关注我的工作及其间接影响的人会意识到，我的方法是奏效的，即使他们不完全理解其运作原理。

---

### [01:07:53] Lenny Rachitsky

**English:**
To start to close our conversation, I want to throw out one more seed that might land with someone in the right time. You have this concept of the adjacent possible, which I think is a really powerful concept. And it's basically argues that a lot of people jump to big bold ideas, and instead the better approach is think about what's a constraint you have and lean into the constraints and use that as a guide. Can you just talk about this and how this might inform how people think about product and strategy?

**中文翻译:**
在结束对话前，我想再播下一颗种子。你有一个关于“相邻可能”（the adjacent possible）的概念，我认为它非常强大。它认为很多人倾向于追求宏大、大胆的想法，而更好的方法是思考你面临的约束，并利用这些约束作为引导。你能聊聊这个，以及它如何启发人们思考产品和战略吗？

---

### [01:08:20] Alex Komoroske

**English:**
Sure, yeah. The frame is the adjacent possible, which is I believe comes from design thinking. I've found it from designers in my life who are the ones who would just speak to it. And the adjacent possible is a set of actions that you do, that you can do. They are right in front of you that if you do them, they would work, almost certainly work. In the tech industry in particular, we default assume that the adjacent possible is like this and then flying leap to something. And in reality, the adjacent possible is quite small. It's within arm's reach.

**中文翻译:**
当然。这个框架叫“相邻可能”，我相信它源于设计思维。我是从我认识的设计师那里听到的。相邻可能是一系列你现在就能采取的行动，它们就在你面前，如果你去做，几乎肯定会成功。在科技行业，我们习惯于假设相邻可能是一个巨大的飞跃，但实际上，它非常小，就在触手可及的地方。

---

### [01:09:11] Alex Komoroske

**English:**
And people will say, "Oh, you're being nihilist. You're limiting your potential. You're saying don't do big things." But when you recognize that your adjacent possible is relatively small, you realize that you actually have full agency to pick within the subset that is within your reach, and your actions matter because you take an action and now the world reconfigures and now you get a next set of actions and it's based partially on the action you just took. And so if you slice this thing up and you have a coherent worldview and you have a principled approach, you can arc to wildly different outcomes than look like they were possible while at each point, each individual action is safe and reasonable.

**中文翻译:**
人们会说：“你太虚无主义了，你在限制潜力，你在说不要做大事。”但当你意识到相邻可能相对较小时，你会发现你其实拥有完全的自主权，可以在触手可及的范围内进行选择。你的行动至关重要，因为你每采取一个行动，世界就会重新配置，然后你会得到下一组行动机会，而这部分取决于你刚刚做的决定。如果你把事情拆解开，拥有连贯的世界观和原则，你就能通过一系列安全、合理的步骤，最终达成一个最初看起来根本不可能实现的宏大目标。

---

### [01:09:50] Alex Komoroske

**English:**
And this allows you to get rid of a lot of the risk and still be exposed to all the upside. And so the risk comes from trying to jump too far ahead in an unknown environment.

**中文翻译:**
这让你能规避大量风险，同时保留所有的上行空间。风险往往源于在未知环境中试图跳得太远。

---

### [01:10:02] Lenny Rachitsky

**English:**
Is the general advice if someone's working on trying to figure out the roadmap, trying to think about what products to build is the advice, don't be scared to go a little incremental versus what people are always pushed, to do bigger.

**中文翻译:**
所以你的建议是，当人们在制定路线图或思考构建什么产品时，不要害怕采取渐进式（incremental）的步骤，而不是像通常被要求的那样非要做大的？

---

### [01:10:13] Alex Komoroske

**English:**
You need both. So if you only do incremental, you will follow the shortest, the steepest gradient in front of you. So UXR says a user wants to do this and you'll do exactly that and you'll end up random walking through the thing. So you need coherence about where you're going and the way you get that is by creating a North Star for yourself. It should be in three to five years in the future, it should be very low resolution. It should describe a thing that every single person who reads it who has any kind of knowledge that might be useful or relevant agrees that it is plausible.

**中文翻译:**
你需要两者结合。如果你只做渐进式，你只会跟随眼前最陡峭的梯度。比如用户调研（UXR）说用户想要这个，你就照做，最后你会变成在随机游走。所以你需要对目标有连贯性，方法是为自己设定一个“北极星”（North Star）。它应该是三到五年后的愿景，不需要太清晰，但应该让每个读到它的人都觉得是“合理的”。

---

### [01:10:51] Alex Komoroske

**English:**
And that if you got to the end point, everyone would high five because if it's going to be a thing, they're like, "I guess that could work." At the end we'd be like, "Oh yeah, neat." That's not worth it. You want another story would be like, "Yeah, great. Wow, we kick off. We changed the way this entire industry works," or whatever. And now this is your North Star. North Star should update, but it's because it's far off in the distance. It will update. It will slide up across the sky a little bit. It won't be jerking around. You'll be arcing slightly differently. And then what you do is you look in your adjacent possible and you look for the thing that has the steepest gradient that pulls you towards your North Star.

**中文翻译:**
如果到达终点时大家只是淡淡地说一句“哦，还行”，那就不值得。你应该追求那种让大家击掌欢庆的目标：“太棒了，我们改变了整个行业的运作方式！”这就是你的北极星。北极星会随时间微调，但因为它很远，它只会像星星在天空中缓慢移动，而不是剧烈晃动。然后，你在你的“相邻可能”中寻找那个能把你引向北极星的最陡峭梯度。

---

### [01:11:31] Alex Komoroske

**English:**
And then they keep on repeating. That's it. But you need both. Because if you only do incremental, then you'll end up random walking into a corner. And if you only do the long-term, you end up dreaming big and designing castles in the sky that are impossible to actually manifest.

**中文翻译:**
然后不断重复。就是这样。但你两者都需要。因为如果只做渐进，你会走进死胡同；如果只看长期，你最终只会构建无法实现的空中楼阁。

---

### [01:11:45] Lenny Rachitsky

**English:**
To give you a metaphor from an experience I had, I did this silent meditation retreat once, and a big part of Buddhism is to not cling to a specific outcome and not have a plan in mind and be sad if it doesn't work out. And so I asked them just how do you achieve success and want to be successful while not doing that? And their metaphor is point your card in a specific direction that you want to go. Just point your card in that direction, essentially in your example of North Star, and just start walking. Don't figure out this is exactly the path I'm going to take to get to this end destination.

**中文翻译:**
分享一个我的经历作为比喻。我参加过一次禅修，佛教的一个核心观点是不执着于特定的结果，不要预设一个死板的计划，否则失败了会很痛苦。我问他们：如果不这样做，如何取得成功？他们的比喻是：把你的车头指向你想去的方向。就像你的北极星例子，指准方向，然后开始走。不要试图精确计算出到达终点的每一寸路径。

---

### [01:12:19] Alex Komoroske

**English:**
Yeah. And you'll know after the fact, you'll say, "Oh, I curved a little bit or I had this little jog than there." And you'll say, "Ah, it would've been more efficient." But we're so focused on efficiency of not wasting effort that we ended up doing nothing at all or doing very dangerous things that don't work. So I'm much sure that I have a path that's slightly inefficient because we're navigating unknowns and we couldn't know no point.

**中文翻译:**
没错。事后你会发现：“哦，我绕了一点路，或者在那里拐了个弯。”你会觉得“本来可以更高效”。但我们太执着于“不浪费精力”的高效，以至于最终什么都没做，或者做了非常危险且无效的事。我宁愿选择一条稍微低效的路径，因为我们在探索未知，不可能预知一切。

---

### [01:12:56] Alex Komoroske

**English:**
It doesn't matter, and we don't have to do that analysis if we believe that the order of magnitude is of that thing. It'd actually be we had spent all the time to get the illusion of precision, which at great expense, and then it's the people say, "Oh, I'm data-driven. I want to really run the analysis to ground." There's tons of stuff you can't know ahead of time. So if you're getting a false precision at the beginner, that's a comfort blanket. That's just helping you feel like there isn't uncertainty. There's uncertainty everywhere all the time. And trying to ignore it by trying to pin it down with fake numbers that you just made up for yourself at great expense is a really bad idea.

**中文翻译:**
如果我们相信数量级是对的，那具体的分析就不重要了。我们往往花大量精力去追求一种“精确的错觉”，人们说“我是数据驱动的，我要把分析做透”。但有很多事是你预先无法知道的。如果你在开始时追求虚假的精确，那只是一块“安慰毯”，让你觉得没有不确定性。但不确定性无处不在，试图用昂贵的代价编造虚假数字来掩盖它，是一个非常糟糕的主意。

---

### [01:13:48] Lenny Rachitsky

**English:**
That's really freeing. I noticed again, you were writing something. I'm again curious which you wrote down that you thought was insightful.

**中文翻译:**
这听起来很让人解脱。我注意到你又在写东西了，我很好奇你记下了什么。

---

### [01:13:54] Alex Komoroske

**English:**
I actually this time I was not writing did something down. I was checking a thing I thought you might say that was going to reference was Tim Urban's, "Happiness is the reality minus expectations." I always get that backwards, but have you heard this frame, that happiness-

**中文翻译:**
其实这次我没在记东西，我是在查一个我以为你会提到的引用，就是 Tim Urban 的那句：“幸福等于现实减去预期。”我总是记反，你听过这个说法吗？

---

### [01:14:07] Lenny Rachitsky

**English:**
Let's get into it. Yeah, we're not going to get this. This is great.

**中文翻译:**
聊聊这个吧，这很棒。

---

### [01:14:09] Alex Komoroske

**English:**
"Happiness is reality minus expectations," and this is Tim Urban. It was from Wait But Why. And I think it's a very simple distillation of it, of if you set your expectations super high and it comes in and it's amazing, but it's below it, then it's a net negative. So the easiest thing, reality is hard to change. It's not impossible. It's hard to change. Your expectations are super easy. So just change your expectations. Hold it lightly and don't say, "Oh my gosh, this is going to be my kid's birthday. She's going to remember it. It's going to be the best birthday that she ever had and we're all it's going to be perfect." Because then when it doesn't go perfect and it starts raining that day, you're like, "Gosh." You get all worked up. Just say, "No, I want spend this day in a way that I can look back on and remember fondly." And that will include, yeah, it changed.

**中文翻译:**
“幸福 = 现实 - 预期”，这是 Tim Urban 在 Wait But Why 博客里写的。这是一个非常简单的总结：如果你把预期定得极高，即使结果很棒但没达到预期，你的净感受也是负面的。现实很难改变，但预期非常容易改变。所以，只需改变你的预期。保持轻松的心态，不要说：“天哪，这是我女儿的生日，她一定要永远记住，这必须是她过得最完美的生日。”因为一旦下雨或者出了岔子，你就会崩溃。你应该说：“我想以一种以后回想起来觉得温馨的方式度过这一天。”即使计划变了也没关系。

---

### [01:14:54] Alex Komoroske

**English:**
One other piece of advice someone gave me that I really like is try to feel the emotion about the story that'll make you feel in 10 years. So if it's funny in 10 years, try to see the humor in it now. And this one in particular was a friend, their newborn would, every time you changed her diaper, would poop. That was only... And when they did it, it would often be projectile. And so it was like a trap. You change the diaper. And it was like, what are you going to do in that situation? And then they're just like, "It's going to be a funny story in a few years, so let's see the humor in it now."

**中文翻译:**
我非常喜欢的另一个建议是：试着用 10 年后的眼光来看待当下的情绪。如果这件事 10 年后听起来很有趣，那就现在试着发现它的幽默感。我有个朋友，他们的孩子每次换尿布都会拉屎，而且经常是喷射状的。这简直像个陷阱。在这种情况下你能怎么办？他们就想：“几年后这会是个有趣的故事，所以现在就让我们感受它的幽默吧。”

---

### [01:15:28] Lenny Rachitsky

**English:**
That's funny.

**中文翻译:**
真有意思。

---

### [01:15:29] Alex Komoroske

**English:**
... you're not spraying poop on her. And I think that that kind of perspective is really, people sometimes hear this as, "Oh, you're saying don't dream big. Don't set high expectations. Don't expect more and be okay with mediocrity." That is not what I'm saying. I'm saying hold those expectations lightly. Allow them to change. Be willing to be convinced by different things, and seek something great. Seek something that you can be truly proud of and that feel very authentic to yourself if you achieved.

**中文翻译:**
……只要没喷到她身上就行。我认为这种视角很重要。人们有时会误解为：“哦，你是说不要有远大梦想，不要有高期望，要安于平庸。”我不是那个意思。我是说要“轻装上阵”，允许预期改变，愿意被不同的事物说服，并追求伟大的目标。追求那些一旦实现能让你真正自豪、且让你感到真实自我的东西。

---

### [01:15:57] Lenny Rachitsky

**English:**
Alex, I feel like I could talk to you for hours. I can't believe it's already been almost an hour and a half. So just to wrap things up, is there anything else that you thought would be fun to share or maybe a piece of wisdom you want to leave listeners with before we get to a very exciting lightning round?

**中文翻译:**
Alex，我觉得我能跟你聊上好几个小时。不敢相信已经快一个半小时了。在进入激动人心的闪电轮问答之前，还有什么有趣的事或智慧想留给听众吗？

---

### [01:16:13] Alex Komoroske

**English:**
I think we covered it. I think we covered a lot of that. And again, we could go on for hours and hours and hours and hours. I could just do a random... I can feature The Compendium where I can pull up a random idea, and let's not do that.

**中文翻译:**
我想我们已经聊得差不多了。我们聊了很多。当然，我们可以一直聊下去。我甚至可以从《纲要》里随机抽一个想法出来聊，但我们还是别那样了。

---

### [01:16:24] Lenny Rachitsky

**English:**
Okay, amazing. Well, Alex, with that, we've reached the very exciting lightning round. Are you ready?

**中文翻译:**
太棒了。Alex，那我们进入闪电轮问答。准备好了吗？

---

### [01:16:28] Alex Komoroske

**English:**
I am ready.

**中文翻译:**
准备好了。

---

### [01:16:30] Lenny Rachitsky

**English:**
First question, what are two or three books you've recommended most to other people?

**中文翻译:**
第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:16:33] Alex Komoroske

**English:**
Origin of Wealth by Eric Beinhocker, which is great. It's about a complexity economics, why the traditional economic model doesn't work, and also why it takes an evolutionary lens on what kinds of business plans work and how companies execute them. That I found my entree into a lot of the systems thinking and I thought it was just absolutely brilliant. And the other one is The Elements of Thinking in Systems, which is short, easy to read, very approachable. In fact, if anything, people think of it as not serious enough because it's too easy to read. It's one of those books that when you read at the beginning you'll say, "This sounds right." And then later, years later, if you read it again you'll go, "Oh my God, that was so... I wasn't ready for that yet, but that is totally the way."

**中文翻译:**
一本是 Eric Beinhocker 的《财富的起源》（Origin of Wealth），非常棒。它讲的是复杂经济学，为什么传统经济模型行不通，并用进化的视角来看待什么样的商业计划能成功。这是我进入系统思维的敲门砖，我认为它非常精彩。另一本是《系统之美》（The Elements of Thinking in Systems），短小精悍，通俗易懂。事实上，有些人觉得它太好读了以至于不够严肃。但它是那种你初读觉得“有道理”，几年后再读会惊叹“天哪，我当时还没准备好领悟这些，但这才是真理”的书。

---

### [01:17:21] Lenny Rachitsky

**English:**
Next question. Do you have a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
下一个问题：最近有没有特别喜欢的电影或电视剧？

---

### [01:17:24] Alex Komoroske

**English:**
For me, I was thinking about this, it's The Green Knight, which I watched I think a few years old. It's about the Arthurian legend. It's a challenging movie. In fact, when I watched it, I was like, "I dislike this. I do not find this interesting." And then I couldn't stop thinking about it and it helped me. I think this is one of the reasons I like to write in parable is a parable is open-ended. It encourages and requires the listener to engage into the idea and play with it and see how it affects them and how they affect it. And so for me, The Green Knight, again, I'm not excited to watch it again, but I found it to be the most impactful movie I've seen in the last couple of years in terms of amount of thinking that it caused me to do afterwards.

**中文翻译:**
我想了想，是《绿衣骑士》（The Green Knight）。这是一部关于亚瑟王传说的电影，挺有挑战性的。事实上，我刚看的时候觉得“我不喜欢，这没意思”。但看完后我却无法停止思考它。我认为这就是我喜欢用寓言写作的原因：寓言是开放式的，它鼓励并要求听众参与进来。虽然我不想再看一遍《绿衣骑士》，但它是我这几年看过的最让我深思的电影。

---

### [01:18:04] Lenny Rachitsky

**English:**
Wow, that says a lot. Next question, do you have a favorite product you've recently discovered that you really like?

**中文翻译:**
哇，评价很高。下一个问题：最近有没有发现什么特别喜欢的产品？

---

### [01:18:10] Alex Komoroske

**English:**
To me, I think the answer for me is WebSim. It's the one that I like playing around with a lot. And I've said it before, I use Claude 20 times a day. I find that it's almost impossible for me to imagine doing work. I mean of course now I've got to use Strawberry and see how that feels, but yeah.

**中文翻译:**
对我来说，答案是 WebSim。我非常喜欢玩它。另外就是我之前提到的 Claude，我每天用 20 次，无法想象没有它怎么工作。当然，现在我也得试试 OpenAI 的 Strawberry（o1）模型了。

---

### [01:18:28] Lenny Rachitsky

**English:**
One use case of WebSim that I found really fun that I used with Dylan is if you do Gmail, if you give it gmail.com/someone's name, it just comes up with what their email looks like. And could do it for famous people, like for Patrick Allison or whoever, and it's like, "Wow, that's really good."

**中文翻译:**
我和 Dylan 发现 WebSim 有个很有趣的用法：如果你输入 gmail.com/某个人的名字，它就会生成那个人的邮箱界面。你可以试一些名人，比如 Patrick Collison 之类的，效果惊人地好。

---

### [01:18:45] Alex Komoroske

**English:**
The elements are really good. One of the things we played around with is having a thing that generates fake data of arbitrary schemas, and I just write a short backstory of a person and then have it generate data that fits in this fictional user person's world. And it's just amazing the kinds of stuff, the coherence it has with, it's weird and it's very specific to that story, but elements are just so, they're like these little holograms of all this information of humanity is interesting informational package, this little thing. And all kinds, it's like a mirror that different things reflect back out of it at you. And it's shocking sometimes to see humanity reflected back at you.

**中文翻译:**
它的元素做得非常好。我们尝试过让它生成任意模式的虚假数据，我只需写一个简短的人物背景，它就能生成符合那个虚构世界的数据。它的连贯性非常惊人，虽然很怪异且特定，但那些元素就像是人类信息的微缩全息图。它像一面镜子，反射出各种东西，有时看到人类的特质被反射回来，感觉挺震撼的。

---

### [01:19:29] Lenny Rachitsky

**English:**
It's like a zip file of all human knowledge.

**中文翻译:**
就像是全人类知识的压缩包。

---

### [01:19:31] Alex Komoroske

**English:**
Yeah, yeah.

**中文翻译:**
没错。

---

### [01:19:32] Lenny Rachitsky

**English:**
Amazing. And it's because it's trained on all the things we've written, right?

**中文翻译:**
太神奇了。这是因为它是在我们写过的所有东西上训练出来的，对吧？

---

### [01:19:35] Alex Komoroske

**English:**
Yep.

**中文翻译:**
是的。

---

### [01:19:36] Lenny Rachitsky

**English:**
All right, two more questions. You have a favorite life motto that you often come back to find useful in work or in life?

**中文翻译:**
好，最后两个问题。你有没有什么座右铭，是你在工作或生活中经常觉得有用的？

---

### [01:19:43] Alex Komoroske

**English:**
I guess I've said too, this is cheating, but I said too, the do things that give you energy that you're proud of, and the happiness is reality minus expectations I think are really simple clarifying words to look like.

**中文翻译:**
我已经说了两个了，虽然有点作弊，但就是那两句：“做那些能给你能量且让你自豪的事”，以及“幸福 = 现实 - 预期”。我认为这些话非常简练明了。

---

### [01:19:56] Lenny Rachitsky

**English:**
All right. Final question. You can go in one of two directions. One is what's something that you are going to add to this week's Bits and Bobs that you're thinking about right now that we haven't talked about? Or just go to your Compendium and pick a random thing and see what comes up and share.

**中文翻译:**
好。最后一个问题，你可以二选一：一是分享一件你打算加入本周《零碎想法》、但我们还没聊到的事；二是去你的《纲要》里随机挑一个想法分享。

---

### [01:20:11] Alex Komoroske

**English:**
Okay, so this is the... I'll just read this off. This is written a year ago. "We've forgotten a world without aggregators. Non-aggregator ecosystems make it so participants don't have to fear empowering their overlord, where that you have to worry about each bit of action you're doing, the aggregator is getting it more and more powerful. MySpace was the Wild West. Facebook made it so you can't change the CSS, which was better for users, containing some freedom. Aggregators make sense in the late stage of an era. At the beginning, they curtail too much exploration."

**中文翻译:**
好，我直接读一段一年前写的笔记：“我们已经忘记了一个没有‘聚合者’（aggregators）的世界。非聚合生态系统让参与者不必担心赋予‘霸主’权力，不必担心自己的每一个行动都在让聚合者变得更强大。MySpace 曾是荒野西部；Facebook 让你无法修改 CSS，这对用户更友好，但也限制了自由。聚合者在时代的后期是有意义的，但在初期，它们会限制太多的探索。”

---

### [01:20:42] Alex Komoroske

**English:**
That's just my random reflections. I don't even remember what conversation that came from originally, but of the power of... I am just so obsessed with the idea that we are in the late stage of this current technical paradigm that we're in and so many things we feel like we figured them all out and nothing can be any different, and I don't love this outcome that we're in, the idea of you're... Just one quick framing. To me, if you ask somebody on the street to tell you what the canonical piece of software is, the answer they'll give you is something like Instagram, which is to say an app, which I think is a shame because an app is monolithic. It's one size fits all. It's not decomposable. It doesn't meaningfully interact with anything else in the broader ecosystem. And it's also only allowed to exist if some of the largest companies in the world say it may exist, which is insane to me.

**中文翻译:**
这只是我的随机反思，我都不记得最初是跟谁聊出来的。我非常痴迷于一个想法：我们正处于当前技术范式的后期，很多事情我们觉得已经定型了，不可能有变化。我不喜欢现在的局面。举个例子：如果你问路人什么是典型的软件，他们可能会说是 Instagram 这样的“App”。我觉得这很遗憾，因为 App 是封闭的、单一的、不可分解的，它不与生态系统中的其他部分产生有意义的互动。而且，它的存在还取决于几家大公司的许可，这在我看来很疯狂。

---

### [01:21:26] Alex Komoroske

**English:**
To me, software is alchemy. It's the ability to extend human agency beyond ourselves to create something that can then combine with what others have created in unexpected and unforeseen ways to create this commentary of possibility of human agency. And somehow in the past decade, we've become convinced that all of this potential should be squeezed into about a dozen little boxes on your phone. And now with the power of AI, everyone just is default assuming that what's going to happen is we're all going to be locked inside of a box with a super God AI Clippy. And the only thing that people disagree about is which Clippy is it going to be? Whose Clippy is it going to be?

**中文翻译:**
对我来说，软件是“炼金术”。它是扩展人类自主性的能力，创造出能与他人创造物以意想不到的方式结合的东西。但在过去十年里，我们竟然相信所有的潜力都应该被挤进手机里的那十几个小方块里。现在有了 AI，大家默认的假设是我们会被锁在一个盒子里，面对一个超级 AI 版的“回形针助手”（Clippy）。大家唯一的争论点只是：那是谁家的“回形针”？

---

### [01:21:57] Alex Komoroske

**English:**
That to me is bonkers. I don't want that world at all. I want a world where we use this magical duct tape to escape the box, to allow software and humans using it to lean into their agency. And I think aggregators are amazing in an environment where you have a safe environment to have all kinds of interesting stuff that can't be fully open-ended because the aggregator can't allow it to escape the possibility of that ecosystem. And so for me, one of the reasons I'm excited about LLMs being a disruptive technology is I think that it allows us to get out of this monolithic sense of whatever. We're all just beholden to a decreasing number, very powerful organizations, and lean into everybody being able to be creative and collaborative and exercise their agency in a pro-social way.

**中文翻译:**
这在我看来太疯狂了。我一点也不想要那样的世界。我想要一个我们利用这种“神奇胶带”逃出盒子的世界，让软件和人类能发挥自主性。聚合者在某些环境下很棒，但它们不能允许事物超出其生态系统的可能性。所以我对 LLM 这种颠覆性技术感到兴奋的原因之一是，我认为它能让我们摆脱这种单一的束缚，不再受制于极少数强大的组织，而是让每个人都能以一种亲社会的方式发挥创造力、进行协作并行使自主权。

---

### [01:22:41] Lenny Rachitsky

**English:**
Wow. Well, you blew our mind as a final element of this conversation. Alex, thank you so much for being here. Two final questions. Where can folks find you online? Where do they find stuff you're working on if they want to read more and follow the stuff you're thinking about? And then how can listeners be useful to you?

**中文翻译:**
哇。在对话的最后，你又一次震撼了我们。Alex，非常感谢你能来。最后两个问题：大家可以在哪里找到你？如果想读更多你的文章、关注你的思考，该去哪里？以及，听众可以如何帮到你？

---

### [01:22:58] Alex Komoroske

**English:**
Komoroske.com is where. My husband gives me so much shit for it because it looks like it was designed in the early 2000s, which it was. I link to all the different posts there. If you click, there's a Google group, but now where you can subscribe to my updates whenever I post in the Bits and Bobs or any medium article, that's a good way of taking touch as I publish stuff.

**中文翻译:**
可以去 Komoroske.com。我丈夫经常吐槽那个网站，因为它看起来像是 2000 年代初设计的（事实也确实如此）。我在那里链接了所有的文章。你可以加入一个 Google 小组，订阅我的《零碎想法》或 Medium 文章的更新，这是保持联系的好方法。

---

### [01:23:16] Alex Komoroske

**English:**
And then the way that Google can be useful to me is I have office hours on my site that are open to anybody to join in. I am continually, they're booked off in a few weeks in advance, but if you find something that resonated with you or that didn't, or you think is interesting or, "Oh, here's a parallel. I don't know if you've thought of it before," just reach out to me. And I love, love, love talking to people, interesting people especially who have life experiences and backgrounds that are different from mine. At one point, a magician showed up in my office hours and described and said, "Hey, this tactic you're talking about in your Bits and Bobs, that's actually cold reading. That's what psychics use." And I would find all these crazy connections they'd never occurred to me before. And so people just reaching out and sharing ideas and I love.

**中文翻译:**
至于大家如何帮到我：我的网站上有“办公时间”（office hours），任何人都可以预约。虽然通常要提前几周预约，但如果你对某些内容有共鸣（或没共鸣），或者有有趣的类比，欢迎联系我。我非常喜欢与有趣的人交谈，尤其是那些背景和经历与我完全不同的人。有一次，一个魔术师来到我的办公时间，说：“嘿，你在《零碎想法》里说的那个策略，其实就是‘冷读术’（cold reading），灵媒就是用那个的。”我总能发现这些我从未想过的奇妙联系。所以，大家尽管联系我分享想法，我非常欢迎。

---

### [01:23:59] Lenny Rachitsky

**English:**
Alex, you're awesome. This conversation was exactly what I was hoping it'd be. My brain is buzzing as I expected. Thank you so much for being here. I'm excited for folks to listen to this and to learn from you.

**中文翻译:**
Alex，你太棒了。这次对话完全达到了我的预期，我的大脑正如预料般兴奋。非常感谢你能来，我很期待大家听到这集节目并向你学习。

---

### [01:24:10] Alex Komoroske

**English:**
Thank you so much for having me.

**中文翻译:**
非常感谢邀请我。

---

### [01:24:12] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这集节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期再见。