# Alisa Cohn - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast with Alisa Cohn.

---

### 00:00:00 Lenny Rachitsky

**English:**
I want to dive right into talking about your advice on having difficult conversations, where like in performance review season, what do you suggest when someone's being told they're not going to get the promotion?

**中文翻译:**
我想直接切入正题，聊聊你关于“艰难对话”的建议。比如在绩效评估季，当有人被告知他们不会获得晋升时，你有什么建议？

---

### 00:00:10 Alisa Cohn

**English:**
Hope for the future is so important. I know this is going to be challenging for you to hear, not going to promote you, but I want you to know this. It's really important to me that you're able to succeed in your career here, and so I want to continue to help you find opportunities to build your skills and to advance.

**中文翻译:**
对未来的希望非常重要。你可以这样说：“我知道这听起来可能让你很难受，我们这次不会提拔你，但我希望你知道这一点：对我来说，你能在这里获得职业成功非常重要，所以我希望继续帮助你寻找机会来提升技能并获得晋升。”

---

### 00:00:24 Lenny Rachitsky

**English:**
You're big on helping leaders understand that their job is not to make employees happy.

**中文翻译:**
你非常强调要让领导者明白，他们的工作并不是为了让员工开心。

---

### 00:00:29 Alisa Cohn

**English:**
They're trying now to be the leader who everyone loves, but what really needs to happen very often is, we need to drive towards results. This employee continuing to not really do a great job at their job, you don't want to push them because you don't want to upset them. You don't want to give them difficult feedback, so you're just going to keep hoping it works out. Ultimately, that leads to the demise of your company.

**中文翻译:**
现在的领导者都想成为那个被所有人爱戴的人，但通常真正需要做的是推动结果。如果某个员工一直表现平平，你因为不想让他们难过而不去督促他们，不想给他们严厉的反馈，于是你只是寄希望于事情会自然好转。最终，这会导致公司的灭亡。

---

### 00:00:50 Lenny Rachitsky

**English:**
You have some cool advice on just how to make meetings more effective and how to especially end the meeting.

**中文翻译:**
关于如何提高会议效率，尤其是如何结束会议，你有一些很棒的建议。

---

### 00:00:54 Alisa Cohn

**English:**
My three questions to end the meeting are...

**中文翻译:**
我结束会议的三个问题是……

---

### 00:01:00 Lenny Rachitsky

**English:**
Today my guest is Alisa Cohn. Alisa is an executive coach who has worked with C-suite execs at both startups like Etsy, Wirecutter, Venmo, and DraftKings, along with Fortune 500 companies like Microsoft, Google, Pfizer, and the New York Times. She was named one of the top 50 coaches in the world by Thinkers50 and the number one startup coach for the past four years by Global Gurus. What I love about Alisa is that she gives her clients very specific and actionable advice. In her conversation, Alisa shares specific language and phrases that you can use when having a difficult conversation with your reports to make these conversations go much smoother and be less difficult. Also, three questions you should ask at the end of every meeting to make the most possible forward progress after each meeting. Plus, why your job as a leader isn't to make people happy and what you should be focused on instead, and a set of questions that she calls the founder prenup that you should talk through with potential founders to make sure that these are the people that you want to be working with for a long, long time.

**中文翻译:**
今天的嘉宾是 Alisa Cohn。Alisa 是一位高管教练，曾为 Etsy、Wirecutter、Venmo 和 DraftKings 等初创公司，以及微软、谷歌、辉瑞和《纽约时报》等财富 500 强公司的 C 级高管提供咨询。她被 Thinkers50 评为全球 50 强教练之一，并连续四年被 Global Gurus 评为排名第一的初创公司教练。我最欣赏 Alisa 的一点是，她会给客户非常具体且可操作的建议。在对话中，Alisa 分享了在与下属进行艰难对话时可以使用的具体语言和短语，让这些对话更顺畅、更轻松。此外，她还分享了每个会议结束时你应该问的三个问题，以确保会后能取得最大的进展。另外，她还谈到了为什么领导者的工作不是让员工开心，以及你应该关注什么，还有一套她称之为“创始人婚前协议”的问题，你应该与潜在的合伙人深入探讨，以确保他们是你想要长期共事的人。

---

### 00:01:59 Lenny Rachitsky

**English:**
There's also so much more advice. If you're a leader of people or a founder, and especially if you dread hard conversations, this episode is for you. If enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. With that, I bring you Alisa Cohn. This episode is brought to you by Eppo. Eppo is a next generation A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams. Companies like Twitch, Miro, ClickUp and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and for understanding the performance of new features. And Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does. When I was at Airbnb, one of the things that I loved most was our experimentation platform where I could set up experiments, easily troubleshoot issues, and analyze all on my own.

**中文翻译:**
还有更多建议。如果你是团队领导或创始人，尤其是如果你害怕艰难的对话，那么这一集就是为你准备的。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对播客有巨大的帮助。现在，让我们欢迎 Alisa Cohn。本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依赖 Eppo 来支持他们的实验。实验对于推动增长和了解新功能的表现越来越重要。Eppo 能够帮助你提高实验速度，同时提供其他商业工具无法比拟的严谨深度分析。当我在 Airbnb 时，我最喜欢的东西之一就是我们的实验平台，在那里我可以自己设置实验、轻松排除故障并进行分析。

---

### 00:03:00 Lenny Rachitsky

**English:**
Eppo does all that and more with advanced statistical methods that can help you shave weeks off experiment time and accessible UI for diving deeper into performance and out-of-the-box reporting that helps you avoid annoying prolonged analytic cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the A/B testing flywheel. Eppo powers experimentation across every use case, including product, growth, machine learning, monetization, and email marketing. Check out Eppo at geteppo.com/lenny and 10X your experiment velocity. That's get E-P-P-O.com/lenny. This episode is brought to you by Rippling, a single platform to build and scale your startup on. Rippling handles all the, can't get it wrong admin work of payroll and benefits giving you back hours every week, but it does a lot more than that. Rippling is a game changer for the entire company with tools for HR, IT and spend, all built from the ground up and designed to work together seamlessly.

**中文翻译:**
Eppo 拥有先进的统计方法，可以帮你缩短数周的实验时间，还有易用的 UI 用于深入研究性能，以及开箱即用的报告，帮你避免烦人的漫长分析周期。Eppo 还能让你轻松与团队分享实验洞察，为 A/B 测试飞轮激发新灵感。Eppo 支持各种用例的实验，包括产品、增长、机器学习、变现和邮件营销。访问 geteppo.com/lenny 查看 Eppo，让你的实验速度提升 10 倍。网址是 get E-P-P-O.com/lenny。本集节目由 Rippling 赞助，这是一个用于建立和扩展初创公司的统一平台。Rippling 处理所有“不容出错”的行政工作，如工资发放和福利管理，每周为你节省数小时时间，但它的功能远不止于此。Rippling 是整个公司的游戏规则改变者，拥有人力资源、IT 和支出管理工具，全部从零开始构建，旨在无缝协作。

---

### 00:04:01 Lenny Rachitsky

**English:**
Just hired someone? Rippling makes onboarding easy. Whether your new hire is sitting next to you or halfway across the world, in just a few clicks, Rippling automatically generates an offer letter, ships a laptop with the necessary apps and permissions, and even delivers a corporate card. An employee needs to update their benefits contribution. When they do it in Rippling, the change automatically syncs to payroll. CTO forgot her laptop in an Uber? Lock it remotely with Rippling. Many startups I've invested in like Sprig, [inaudible 00:04:30] and ClassDojo, use Rippling because it's a force multiplier for lean teams, helping them eliminate major headaches and operate their business more efficiently. For a limited time, Rippling is giving Lenny's listeners three months off. To redeem, visit rippling.com/lenny. That's rippling.com/lenny. Alisa, thank you so much for being here and welcome to the podcast.

**中文翻译:**
刚招了新人？Rippling 让入职变得简单。无论新员工是在你身边还是在半个地球之外，只需点击几下，Rippling 就会自动生成录用信，寄送装有必要应用和权限的笔记本电脑，甚至发放公司卡。员工需要更新福利缴纳额？在 Rippling 中操作后，更改会自动同步到工资单。CTO 把电脑忘在 Uber 上了？用 Rippling 远程锁定。我投资的许多初创公司，如 Sprig 和 ClassDojo，都在使用 Rippling，因为它是精干团队的效能倍增器，能帮他们消除主要烦恼并更高效地运营业务。在限定时间内，Rippling 为 Lenny 的听众提供三个月的免费试用。访问 rippling.com/lenny 即可兑换。Alisa，非常感谢你能来，欢迎来到本播客。

---

### 00:04:54 Alisa Cohn

**English:**
Lenny, it's so great to be here and thanks for having me.

**中文翻译:**
Lenny，很高兴来到这里，谢谢你的邀请。

---

### 00:04:57 Lenny Rachitsky

**English:**
I want to dive right into talking about your advice on having difficult conversations. I personally dread difficult conversations. I feel like I practice ahead of these things. I'm like, "I'm going to say these things. It's going to go like this," and it never goes as well as I hope. I always say the wrong thing. I feel like this is very relatable. They're called difficult conversations for a reason.

**中文翻译:**
我想直接开始聊聊你关于艰难对话的建议。我个人非常害怕艰难的对话。我感觉我会在事前练习，心想：“我要说这些话，过程会是这样的”，但结果从来没有我预想的那么顺利。我总是说错话。我觉得这很容易引起共鸣，它们被称为“艰难对话”是有原因的。

---

### 00:05:18 Alisa Cohn

**English:**
Totally.

**中文翻译:**
完全正确。

---

### 00:05:19 Lenny Rachitsky

**English:**
I know you work with a lot of execs on this specifically, and what I love is you've actually come up with a bunch of scripts that help people make these conversations less difficult. So how about we talk through some of these scripts that people can actually start applying?

**中文翻译:**
我知道你专门针对这一点与很多高管合作过，我最喜欢的是你实际上总结出了一系列“话术脚本”，可以帮助人们降低这些对话的难度。那么，我们来聊聊其中一些人们可以立即应用的话术如何？

---

### 00:05:32 Alisa Cohn

**English:**
Let's do that. I love that idea. And also Lenny, as you just said, very relatable and also, so you're not alone. If I could ask you a question, if you're picturing a difficult conversation that you have had, should have, might have, and you're nervous about, it's hard for you, can you sum it up? What's hard about it? Because it's helpful to clarify what is hard about it?

**中文翻译:**
好啊，我喜欢这个主意。而且 Lenny，正如你刚才所说，这很有共鸣，你并不孤单。如果我问你一个问题：如果你想象一个你经历过的、应该进行或可能进行的艰难对话，你感到很紧张、觉得很难，你能总结一下吗？难点在哪里？因为弄清楚到底难在哪里是很有帮助的。

---

### 00:05:56 Lenny Rachitsky

**English:**
Great question. I just don't want to make people sad and upset, and I worry about their reaction, how to deal with that, and them just getting really upset and mad and just like, "Oh, man. This really made things worse." So I worry about the reaction, I guess.

**中文翻译:**
好问题。我只是不想让别人感到难过和沮丧，我担心他们的反应，担心如何应对，担心他们会变得非常生气和愤怒，然后觉得：“噢，天哪，这真的让事情变得更糟了。”所以我想，我担心的是对方的反应。

---

### 00:06:11 Alisa Cohn

**English:**
Okay, about making things worse or about their reaction?

**中文翻译:**
好，是担心让事情变糟，还是担心他们的反应？

---

### 00:06:13 Lenny Rachitsky

**English:**
The reaction, just making someone upset and sad. I don't want to do that.

**中文翻译:**
反应，就是让某人感到沮丧和难过。我不想那样做。

---

### 00:06:17 Alisa Cohn

**English:**
Making someone upset. Okay, good. And again, you're not alone about that. Just one more question on that. What's the problem if they're sad and upset? What does that mean to you?

**中文翻译:**
让某人难受。好。再说一次，你并不孤单。关于这一点我再问一个问题：如果他们感到难过和沮丧，会有什么问题？这对你意味着什么？

---

### 00:06:26 Lenny Rachitsky

**English:**
Oh, I love this life coaching we're doing. Yeah, so it's like what happens if they get sad and upset?

**中文翻译:**
噢，我喜欢我们正在进行的这种“人生教练”式的对话。是的，就像是如果他们变得难过和沮丧会发生什么？

---

### 00:06:33 Alisa Cohn

**English:**
Yeah.

**中文翻译:**
是的。

---

### 00:06:36 Lenny Rachitsky

**English:**
I feel like it's stuff that I'm going to have to deal with. It's like this drama all of a sudden, this new fire I have to think about. And yeah, it's like the additional work it creates and also just, I don't know. Yeah, it's a good question.

**中文翻译:**
我觉得那是我必须去处理的事情。就像突然出现的闹剧，我必须去考虑的新麻烦。是的，就像是它带来的额外工作，还有……我也不知道。嗯，这是个好问题。

---

### 00:06:48 Alisa Cohn

**English:**
You can think about it some more, right? I'm not going to put you on the spot right now, but just to say for all of us, the reason they're difficult, to your point, they're difficult. But we're putting meaning on things all the time, every day, all the time, and I think it's important, it's actually helpful in motivating you to have difficult conversations, but also in helping them go well. If you can get to the bottom of what you're putting on top of it, what you're weighting it with, because I can understand that again, you are not alone. I don't want to make people upset. Totally.

**中文翻译:**
你可以再思考一下。我现在不会让你难堪，但对我们所有人来说，艰难对话之所以艰难，正如你所说，是因为它们本身具有挑战性。但我们每天、每时每刻都在给事情赋予意义。我认为弄清楚你给这件事附加了什么负担，其实有助于激励你去进行艰难对话，也有助于对话顺利进行。因为我能理解，你并不孤单，我也不想让人难受。完全理解。

---

### 00:07:20 Alisa Cohn

**English:**
And also, I would just say on the other hand, when you're enlightening someone or you're working out a situation with someone and it's difficult, if you don't give them the opportunity to hear what you have to say, if you don't bring this up, then you're never going to have the opportunity to help them see something differently or help them improve or help you improve the relationship or whatever it is you're trying to do. And so, I can understand it's a natural thing. I don't want to make them upset.

**中文翻译:**
另一方面，我想说，当你试图启发某人或与某人共同解决困难局面时，如果你不给他们机会听听你的想法，如果你不提出来，那么你就永远没有机会帮助他们从不同的角度看问题，或者帮助他们改进，或者帮助你改善关系，无论你的目标是什么。所以，我理解这是一种天性——不想让人难受。

---

### 00:07:51 Alisa Cohn

**English:**
No one wants to make anybody upset, but through that upset on the other side of that, can often be a whole new possibility and a whole new revelation, and actually a lot of joy and freedom. I think that we forget about all the other possibilities that come out of difficult conversations and we just land on these really uncomfortable parts about like, "oh, it's going to be a lot of extra work" or like, "They're going to get uncomfortable or even maybe cry." And I think it's just really helpful to tap into what you make it mean and then also what other possibilities it could mean.

**中文翻译:**
没人想让别人难过，但在难过的另一面，往往隐藏着全新的可能性和启示，甚至会有很多快乐和解脱。我认为我们忘记了艰难对话可能带来的所有其他可能性，而只关注那些让人不舒服的部分，比如“噢，这会增加很多额外工作”或者“他们会感到尴尬甚至哭泣”。我认为深入挖掘你赋予它的意义，以及它可能意味着的其他可能性，是非常有帮助的。

---

### 00:08:23 Lenny Rachitsky

**English:**
I love that. And it's one thing to hear that and say that, it's another to actually feel that deeply and feel like I shouldn't be as worried as I am. I think part of it is doing these enough times where you're like, "Okay, it's actually not so hard." And the other is having some of this support. To make this even more real, let's give some examples of what we say when we say difficult conversations. There's like, "You're not getting a promotion that you thought you would, we're going to let you go." What other examples or common difficult conversations that you run across?

**中文翻译:**
我喜欢这个观点。听是一回事，说是一回事，但真正深刻体会到并觉得自己不该如此担心又是另一回事。我觉得部分原因在于经历得足够多，你会觉得“好吧，其实没那么难”。另一部分则是获得一些支持。为了让讨论更实际，我们举几个“艰难对话”的例子。比如：“你没能获得你预期的晋升”或者“我们要解雇你”。你还遇到过哪些其他例子或常见的艰难对话？

---

### 00:08:50 Alisa Cohn

**English:**
Those are two very common ones. And then of course, the most common one is just difficult performance feedback. Or [inaudible 00:08:56] what we say, quote unquote, "constructive performance feedback," which we never made positive. It only is the sort of things that you're not doing well. I think there are two flavors of that. One is, "You're screwing up" and the other is, "Developmentally, I'd like to see you add something or change something."

**中文翻译:**
那两个非常典型。当然，最常见的是困难的绩效反馈。或者我们所谓的“建设性绩效反馈”，其实我们从来没把它变积极过，它指的只是你做得不好的地方。我认为这有两种类型：一种是“你搞砸了”，另一种是“从发展的角度看，我希望看到你增加一些能力或改变一些做法”。

---

### 00:09:12 Lenny Rachitsky

**English:**
Yes. And as you say that, one of the other fears I have is them just disagreeing and me feeling like maybe it's not right, maybe I'm wrong and feeling shit maybe. I didn't see something and then just looking worse after the whole thing.

**中文翻译:**
是的。当你这么说时，我的另一个恐惧是他们会直接反对，然后我觉得也许我不对，也许我错了，感觉很糟糕。也许我漏掉了什么，结果整件事结束后我看起来更差劲了。

---

### 00:09:27 Alisa Cohn

**English:**
Yeah. And so then I think what's also really helpful to, and part of the process that we can talk about this for sure is getting a difficult conversation is number one, tapping into what's uncomfortable for it, for you, about it. And then number two, also getting your mindset right. So to say the obvious, are you doing this to hurt someone's feelings? No, never, right?

**中文翻译:**
是的。所以我认为非常有帮助的一点，也是我们可以讨论的过程的一部分，就是进行艰难对话的第一步：挖掘让你感到不舒服的原因。第二步：调整好心态。说句显而易见的，你这样做是为了伤害别人的感情吗？不，绝不是，对吧？

---

### 00:09:49 Lenny Rachitsky

**English:**
The opposite.

**中文翻译:**
恰恰相反。

---

### 00:09:50 Alisa Cohn

**English:**
That's not the reason that anyone's doing it. Sometimes people are giving the performance feedback or talking about something that's been bothering them in order to express themselves and vent. And actually, that is very helpful to identify for yourself, that's why I'm doing it. And then, maybe not do it then, until you can transform your reasoning. But at the end of the day, the hope is as a manager, the reason that you're giving someone this so-called constructive feedback is because you're helping them get better. You need them to change the behavior. They'll never get promoted if they keep doing that. They'll never be successful if they keep doing that. And so, it's your job as a leader and as a manager, to help them out of that problem and help them do something different.

**中文翻译:**
那不是任何人的初衷。有时人们给出绩效反馈或谈论困扰他们的事情是为了表达自己和发泄。实际上，识别出“我这样做是为了发泄”是很有帮助的。如果是这样，也许当时不该做，直到你能转变你的动机。但归根结底，作为一名经理，你给某人所谓的“建设性反馈”的初衷应该是帮助他们变得更好。你需要他们改变行为。如果他们一直那样做，就永远不会获得晋升，永远不会成功。所以，作为领导者和经理，你的职责是帮助他们摆脱困境，引导他们做出改变。

---

### 00:10:33 Lenny Rachitsky

**English:**
The best story I've heard to make that really real for me, I think it was Kim Scott when she came on the podcast. She told a story of, I think it was Bob, where everyone just knew he was terrible and it was like, everyone's was just like knew he was not good and eventually, the boss had a conversation with him eight months into it and told him, "It's not going to work out. You're just doing a bad job." And he's like, "Why didn't anyone tell me? I didn't realize that. If you told me, I would've changed." And everyone assumed he knew. And so I think to your point, this is to help the person. It's not not to hurt them.

**中文翻译:**
我听过最能让我感同身受的故事是 Kim Scott 来播客时讲的。她讲了一个关于 Bob 的故事，公司里所有人都知道他表现很差，大家都心知肚明。最终，老板在八个月后找他谈话，告诉他：“这样不行，你做得太差了。”他却说：“为什么没人告诉我？我没意识到这一点。如果你早告诉我，我会改的。”而每个人都以为他知道。所以我觉得正如你所说，这是为了帮助那个人，而不是为了伤害他。

---

### 00:11:05 Alisa Cohn

**English:**
Yeah, a hundred percent. One of my clients, he was running a division and one of his people was not doing it right, not doing it right, not getting the right kind of data, not having to do the right kind of analysis, whatever it was. We were talking about it and I said, "Well, how come you have another feedback with her?" And he said, "You know, she's just going to cry. She's just going to cry. She's older, whatever, she's just going to cry. It's going to be too uncomfortable, whatever." So we worked, we talked and talked and talked. I gave him a script. We really worked it out and he agreed that he would go in and have that conversation with her, which he did.

**中文翻译:**
是的，百分之百正确。我的一个客户，他管理着一个部门，他的一个下属总是做不对，拿不到正确的数据，做不出正确的分析，诸如此类。我们讨论这件事时，我问：“你为什么不找她谈谈反馈？”他说：“你知道的，她肯定会哭。她年纪比较大，无论如何她都会哭的。那场面会太尴尬了。”于是我们反复讨论，我给了他一个话术脚本。我们仔细推敲，他最终同意去找她谈谈，他也确实这么做了。

---

### 00:11:40 Alisa Cohn

**English:**
And he reported back to me and he was shaken. She cried. Of course she did. She cried. That's what he knew she was going to do. And so she was upset and she went home early and the whole thing. The next day she came in and she said, "Thank you so much for telling me that. I wish someone had told me that 15 years ago. I think I could have had a different career." And I think that is so meaningful for all leaders and people who are responsible for other people to understand that you're uncomfortable when they start crying, of course, or they have this difficult reaction or whatever. But honestly, the only way you're going to be able to help someone grow in their career and become the best person they can be is by leaning into these tough conversations.

**中文翻译:**
他后来向我反馈时，整个人都很震撼。她哭了，正如他预料的那样。她很难过，提前回家了，诸如此类。但第二天她回来对他说：“非常感谢你告诉我这些。我真希望 15 年前就有人告诉我，那样我的职业生涯可能会完全不同。”我认为这对所有领导者和管理者都非常有意义：当对方开始哭泣或有激烈反应时，你当然会感到不舒服。但坦白说，帮助某人在职业生涯中成长并成为最好的自己的唯一途径，就是勇敢地进行这些艰难的对话。

---

### 00:12:23 Lenny Rachitsky

**English:**
What I love about the scripts we're going to talk about, which we probably should transition to, is it's again, one thing to hear that and be like, "Yes, okay, I need to do this. I need to get better at typical conversations. I need to have that talk without someone that we should let go." It's another when it's like tomorrow is the meeting and you're like, "Oh, my God. I have to have this conversation now." And so, I love that you actually give people a really simple approach to how to lay this stuff out in various different contexts. So let's talk through some of these approaches and scripts you've come up with. What do you think would be a good one to start with?

**中文翻译:**
我非常喜欢我们即将讨论的话术脚本。再说一次，听道理并觉得“是的，我需要这样做，我需要擅长艰难对话”是一回事，但当明天就要开会，你心里想“天哪，我现在就得谈这个”时，又是另一回事。所以我很喜欢你给人们提供了一套非常简单的方法，教他们在不同情境下如何陈述。那么，我们来聊聊你总结的这些方法和脚本吧。你觉得从哪一个开始比较好？

---

### 00:12:55 Alisa Cohn

**English:**
Well, we can start with performance feedback and we can just sort of take a typical example. So first of all, once you've done your work to get your mindset right to kind of know what you're doing it, and then you just really want to really be able to wrap your mouth around the words. So what that looks like is practicing, and the script could be, "You know, Matilda, I want to chat with you about the way you're interacting with your peers. So what I'm hearing from them is that you're missing deadlines on a regular basis and not letting them know you're missing the deadlines, and that also you're not fully keeping your team up to speed.

**中文翻译:**
我们可以从绩效反馈开始，举一个典型的例子。首先，当你调整好心态，明确了目标后，你需要让这些话能顺畅地说出口。这需要练习，脚本可以是这样的：“Matilda，我想和你聊聊你与同事互动的方式。我从他们那里听到的是，你经常错过截止日期，而且没有提前告知，另外你也没有让团队充分了解进度。”

---

### 00:13:27 Alisa Cohn

**English:**
And so they're kind of confused running around. Now, we both know that the most important way you can be successful here and also achieve your goals is to make sure that you are working with your peers in a way that's consistent and that they can count on you and you can count on them. So I wanted to let you know about this. I want to certainly hear what you have to say, but the most important thing is that we leave this discussion knowing how you're going to make sure that you're keeping your peers in the loop and also your team in the loop."

**中文翻译:**
“所以他们感到很困惑，像无头苍蝇一样。我们都知道，你在这里获得成功并实现目标的最重要方式，就是确保你与同事的协作是一致的，让他们能依靠你，你也能依靠他们。所以我把这件事告诉你。我很想听听你的想法，但最重要的是，我们结束这次讨论时，要明确你将如何确保让同事和团队都随时了解情况。”

---

### 00:13:55 Lenny Rachitsky

**English:**
Yeah, there's so many elements there that are really interesting. Just focusing on what I'm hearing versus just coming from you or something you've done wrong. It's, here's what I'm hearing from multiple sources. I think that helps people. Okay, it's not just you and just like, "Oh, my manager hates me."

**中文翻译:**
是的，这里面有很多非常有趣的元素。比如关注“我听到的情况”，而不是仅仅说“我觉得”或者“你做错了”。你说“这是我从多个渠道听到的”，我觉得这很有帮助。对方会觉得，好吧，这不只是你个人的偏见，不是“噢，我的经理讨厌我”。

---

### 00:14:14 Lenny Rachitsky

**English:**
It's like, "Okay, other people are saying this." And then I love this phrase of, we both know where it's not just me telling you this. It's like, "You also know this. I know you're smart and you also know that this is, something is wrong here." And then this goal of, here's what we need to [inaudible 00:14:31]. You're like very clear call to action, almost action item, like leave this meeting with, "Let's just be aligned on this thing."

**中文翻译:**
对方会想：“好吧，其他人也这么说。”我非常喜欢“我们都知道”这个短语，这不只是我在教训你，而是“你也明白这一点，我知道你很聪明，你也知道这里出了问题”。然后是目标，你给出了非常明确的行动号召，几乎就是待办事项，比如“离开这个会议时，我们要在这件事上达成一致”。

---

### 00:14:36 Alisa Cohn

**English:**
Yeah, thanks for calling those out. I hope, and again, what I'm trying to convey in my tone is also, "You know what? It's Tuesday. We got to have this conversation. I'm sure it's going to end well. I'm not mad." The whole point about my manager hates me, right? "I'm not yelling at you." The more even keeled and even matter of fact you can be about something that's kind of just run-of-the-mill feedback, the better. And I think it's just also what I didn't say before, and I think it's also important is that, as you are recognizing that one of your jobs is to give this feedback, is that you have to build a relationship with people so they can hear you through the lens of, "Oh, Alisa wants to help me." Not, "Oh, Alisa hates me. It's always a problem."

**中文翻译:**
是的，谢谢你指出这些。我希望在语气中传达的是：“你看，今天是周二，我们得谈谈。我相信结果会很好，我没生气。”这就是为了避免“经理讨厌我”这种想法，对吧？“我没在吼你。”对于这种常规反馈，你表现得越平稳、越实事求是越好。还有一点我之前没说，但也很重要：当你意识到给反馈是你的职责之一时，你必须与员工建立关系，这样他们听你说话时会觉得“噢，Alisa 是想帮我”，而不是“噢，Alisa 讨厌我，总是找麻烦”。

---

### 00:15:21 Lenny Rachitsky

**English:**
How did you start that phrase again? Because the starting is always the hardest part for me. How do you kick off the conversation? What was the couple sentences used?

**中文翻译:**
你刚才那句话是怎么开头的？因为对我来说，开头总是最难的部分。你如何开启对话？那几句话是怎么说的？

---

### 00:15:28 Alisa Cohn

**English:**
I wanted to have a conversation with you about some things I've been hearing from your peers about the way that you all are interacting together.

**中文翻译:**
“我想和你聊聊，关于我从你的同事那里听到的一些关于你们互动方式的情况。”

---

### 00:15:35 Lenny Rachitsky

**English:**
Awesome. So there's an element of, don't make it feel like a huge deal. Just like, "I want to have this conversation with you about something." And it's just like, "Let's have this conversation and here's what we want to leave this conversation with."

**中文翻译:**
太棒了。所以这里有一个要素：不要让它看起来像件天大的事。就像是“我想就某件事和你谈谈”，然后是“我们来谈谈，并明确谈完后要达成什么结果”。

---

### 00:15:46 Alisa Cohn

**English:**
Yes. And I can't stress enough that it's actually really helpful to also have spent some time with Matilda or whoever saying, "Great job on the way that project landed." Or, "Hey, launches, when they happen on time and they're smooth, sometimes we don't notice anything. I want you to notice, we didn't notice anything. That's fantastic. You did a good job in that launch," or whatever it is. Because then, you've had the conversation with them to give them positive feedback and point out what's working, that builds the relationship so that you have the lens of, "Oh, yeah. When something's working, they tell me. When something's not working, they tell me, too." That's how you build trust as well.

**中文翻译:**
是的。我必须强调，平时花时间对 Matilda 或任何人说“那个项目落地得非常棒”或者“嘿，这次发布准时且顺畅，有时候顺畅到我们都没察觉到任何问题。我希望你注意到，我们没发现任何问题，这太棒了。你在这次发布中做得很好”之类的话，是非常有帮助的。因为如果你平时给过积极反馈并指出哪些地方做得好，就能建立起一种关系，让他们觉得：“噢，是的，做得好时他们会告诉我，做得不好时他们也会告诉我。”这就是建立信任的方式。

---

### 00:16:23 Lenny Rachitsky

**English:**
They want to be criticizing them [inaudible 00:16:25]. We need to have another conversation what we're hearing about, problems [inaudible 00:16:28].

**中文翻译:**
（大意）他们不想总是被批评。我们需要再谈谈听到的问题。

---

### 00:16:27 Alisa Cohn

**English:**
Yep.

**中文翻译:**
是的。

---

### 00:16:29 Lenny Rachitsky

**English:**
Obviously, if you say it the same way every single time, they're going to feel like this is weird. Do you recommend it's this kind of Mad Libs approach or is it make it your own as much as you can? What are kind of the key? Or is it like, here's actually how you want to say it every time?

**中文翻译:**
显然，如果你每次都用完全相同的方式说，他们会觉得很奇怪。你建议用这种“填字游戏”式的方法，还是尽可能地把它变成自己的语言？关键点是什么？还是说，你确实建议每次都这么说？

---

### 00:16:42 Alisa Cohn

**English:**
In my book and when I work with my clients, I give specific scripts and what I will regularly say when I'm working with my clients is, "Okay, so this is how I would do it," and then I'll land it for them. But they have to make it their own. You always have to make it your own and I don't think it's a problem of doing it the same way every time. It's not like people are going to notice you because you're talking about different topics, theoretically. If you have a formula that can work for you, that's going to motivate you to do it, that is what's important. And what's important is that it's neutral, not loading on or not venting on someone and not unloading on someone.

**中文翻译:**
在我的书里以及与客户合作时，我会提供具体的脚本。我经常会对客户说：“好吧，如果是我，我会这么做”，然后为他们演示。但他们必须把它变成自己的语言。你总是需要内化它。我不认为每次都用同样的方式有什么问题，人们不会因为你用了同样的开场白就觉得奇怪，因为理论上你们谈论的主题是不同的。如果你有一套行之有效的公式，能激励你去进行对话，那才是最重要的。关键在于保持中立，不要带个人情绪，不要向某人发泄或倾倒负能量。

---

### 00:17:19 Lenny Rachitsky

**English:**
I love that we started with this one because it feels like the most common one of just your employee is underperforming and you want to make sure they understand and adjust. What if you're not hearing something from a bunch of people? What if it's just your perception of their writing? You need to work on your writing skills or you're coming in late. Is there another way you phrase it where it's not, "I'm hearing it from other people?"

**中文翻译:**
我很喜欢我们从这个例子开始，因为这似乎是最常见的情况：员工表现不佳，你想确保他们理解并调整。但如果你不是从一群人那里听到的呢？如果只是你个人对他们写作能力的看法呢？比如“你需要提高写作技巧”或者“你迟到了”。有没有另一种表达方式，而不是说“我听别人说”？

---

### 00:17:43 Alisa Cohn

**English:**
Oh, absolutely. Absolutely. So I'll talk about writing. I think it would be something like, okay, "Matilda, part of your job is to be able to create these documents and I appreciate that you do them on time. What I've observed is that they can often be not as structured as I'd like them to be and they also lack a conclusion. So what I'd love you to do is look at these three or four examples of some folks who are doing them really well and see if you can model your writing on theirs. If you need to take additional classes or if you need help in any way, let me know. But ultimately, I want to get your writing to the level where everybody is appreciating what you bring to the table because the level of your writing really reflects the level of your thinking."

**中文翻译:**
噢，当然有。绝对有。以写作为例，可以这样说：“Matilda，你的部分工作是撰写这些文档，我很欣赏你能按时完成。我观察到的是，这些文档的结构往往不如我预期的那样清晰，而且缺乏结论。所以我希望你能看看这三四个写得非常好的例子，看看能否模仿他们的写作风格。如果你需要参加额外的课程或需要任何帮助，请告诉我。但最终，我希望你的写作水平能达到让每个人都欣赏你贡献的程度，因为写作水平真实地反映了你的思维水平。”

---

### 00:18:27 Lenny Rachitsky

**English:**
Mm-hmm. Wow, I like that. I'd want to follow your advice if I got that. So the way you started that is what I've observed, which also is not like, "Here's what I think" or "Here's what you just need to do." It's more like, "Here's what I've noticed, here's what I've seen, here's what I've observed about what you're doing." And then it reminds me of, what is it, nonviolent communication, that whole framework of just focus on what you see, not what is wrong with them, not what they've done. I guess, is there anything there you want to say of just the importance of focusing on what you've heard from people or what you've observed versus maybe what people often do instead?

**中文翻译:**
嗯，哇，我喜欢这个。如果我收到这样的反馈，我会很愿意听从建议。你开场用的是“我观察到的是”，这不像“我觉得”或者“你必须这样做”。它更像是“这是我注意到的，这是我看到的，这是我对你所做事情的观察”。这让我想起了非暴力沟通（NVC）的框架，即只关注你看到的，而不是对方哪里错了或他们做了什么。我想问，关于关注“听到的”或“观察到的”事实，而不是人们通常的做法，你有什么想补充的吗？

---

### 00:19:05 Alisa Cohn

**English:**
Yeah, I mean you just really said it and I think it's such an important point, observable facts. The idea that this is not a judgment. This is not... Sort of as less judgy as possible is also very helpful. It makes it neutral. It's observable facts and it's also sort of based on expectations, right? So the writing is, we expect it to be at a certain level and it's not that way. And here are the reasons it's not, the specific reasons, it's not.

**中文翻译:**
是的，你刚才说到了点子上，这是一个非常重要的观点：可观察的事实。关键在于这不是一种评判。尽可能减少评判色彩是非常有帮助的，这会让对话保持中立。它是基于事实的，也是基于预期的，对吧？比如写作，我们的预期是达到某个水平，但现在没达到。没达到的具体原因在这里。

---

### 00:19:35 Alisa Cohn

**English:**
The way you interact with your peers, it's important to be at a certain standard, and here's why. Because when we all work together, we're going to be able to execute and when we don't, unfortunately we won't be able to. So you staying in sync with them is important and the observation is that they don't feel fully in sync with you. And so every time we talk about this, it doesn't become this, "Oh, I don't know. I just feel..." By the way, some things you have to give feedback on and they are kind of a feeling and those are more difficult, but so many things if you do the work to really think about what is the observable data, I always ask my clients, what's my evidence that this is happening? And you have to spend some time thinking about it, but it's really worth it because it makes the feedback easier for you to give and easier for them to hear.

**中文翻译:**
你与同事互动的方式需要达到一定的标准，原因如下：因为当我们通力协作时，我们才能执行任务；如果我们不协作，遗憾的是我们就无法完成。所以你与他们保持同步很重要，而观察到的情况是，他们觉得没有完全与你同步。这样每次谈论时，就不会变成“噢，我不知道，我只是觉得……”。顺便说一下，有些反馈确实是基于某种感觉，那些更难处理。但对于大多数事情，如果你花心思去思考什么是“可观察的数据”——我总是问我的客户，证明这件事正在发生的证据是什么？你需要花时间思考，但这非常值得，因为它让你更容易给出反馈，也让对方更容易接受。

---

### 00:20:20 Alisa Cohn

**English:**
Is there anything else along the lines of this specific type of feedback that is worth sharing before we move on to a different type of feedback?

**中文翻译:**
在转向另一种反馈类型之前，关于这种特定类型的反馈，还有什么值得分享的吗？

---

### 00:20:29 Alisa Cohn

**English:**
Well, I think just that the reason, one of the many reasons that people have gone uncomfortable giving feedback is that somebody might get defensive or they might start crying as we talked about. And so I have a script also, which is if someone gets defensive, which is it's like I'm giving you this feedback and you're getting defensive and I say, "Well, let's pause for a second. First of all, I want you to know that I'm telling you this actually, just to make you better because I know how important your career is to you. I know how important the success is to you and it's important to me too as your leader. The second thing is, my observation is that you're getting a little bit emotional. I want to know if we can continue having this conversation now or if we need to kind of pause it. At the end of the day, we really have to have this conversation and I really want to see you make changes, but I understand you might need a few moments to digest it."

**中文翻译:**
我想说的是，人们之所以害怕给反馈，原因之一是对方可能会产生防御心理，或者像我们讨论过的那样开始哭泣。所以我也有一个应对防御心理的脚本。如果我给你反馈而你开始防御，我会说：“好，我们先停一下。首先，我希望你知道，我告诉你这些其实是为了让你变得更好，因为我知道你的职业生涯对你有多重要。我知道成功对你很重要，作为你的领导，这对我也很重要。第二，我观察到你现在情绪有点激动。我想知道我们现在是否可以继续谈下去，还是需要暂停一下。归根结底，我们必须进行这次谈话，我真心希望看到你做出改变，但我理解你可能需要一点时间来消化。”

---

### 00:21:18 Alisa Cohn

**English:**
The importance of that for you is not even what you say, but that you have prepared and you are prepared for if someone has that kind of reaction and that you don't have to, yourself, react to it. You know, "No, I'm not doing that. No, no, no, no, whatever." And you can say, "Yes, you are." Now we're in a fight and that is not cool for anybody. It's certainly not cool for you as a leader. So it gives you the opportunity to recognize that you have another tool in your toolkit rather than just react.

**中文翻译:**
这对你的重要性甚至不在于你说了什么，而在于你做好了准备，预见到了对方可能有这种反应，这样你就不用被动地做出反应。比如对方说“不，我没那样做”，你如果回“不，你有”，那你们就吵起来了，这对谁都没好处，对你这个领导者更是如此。所以这让你意识到你的工具箱里还有另一种工具，而不仅仅是本能反应。

---

### 00:21:48 Lenny Rachitsky

**English:**
So if you find yourself feeling defensive or they are just not hearing and just fighting back, the tool is just pause. Let's just pause for a moment and it feels like there's kind of two parts to which you just shared. One is, remind them why this is important to them and why you're talking about this. And then two is, if there's just emotions kind of taking over, give them a chance to like, "Let's just pause and maybe come back to this because maybe you're not in the right state right now to listen."

**中文翻译:**
所以，如果你发现自己感到对方在防御，或者他们根本不听、只是反击，工具就是“暂停”。让我们停一下。你刚才分享的内容似乎包含两个部分：一是提醒他们为什么这对他们很重要，以及你为什么要谈这个；二是如果情绪占据了上风，给他们一个机会，比如“我们先停一下，晚点再谈，因为也许你现在还没准备好听这些”。

---

### 00:22:18 Alisa Cohn

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### 00:22:20 Lenny Rachitsky

**English:**
Sometimes people get upset when you mention like, "You're getting emotional," or I don't know. Is that a thing that you deal with of just like, "How dare you say I'm feeling emotional?" I'm just...

**中文翻译:**
有时候当你提到“你情绪激动了”之类的话，人们会生气。我不确定，你会遇到这种情况吗？比如对方说“你怎么敢说我情绪激动？”我只是……

---

### 00:22:29 Alisa Cohn

**English:**
I'm not emotional. Why do you think [inaudible 00:22:31] emotional? Right, exactly. Yes, of course. Now, when someone's crying, they're obviously getting emotional. When they're defensive, it's possible that you might want to use a different word. I can see that this is really upsetting you or this is really triggering you, or I can see that the temperature between us has just changed. You could say something like that. I do think also it's helpful to know your people because sometimes you could realize that actually they can deal with that, but then sometimes you have to really [inaudible 00:23:00] the delicate words that you need to use to pause the conversation.

**中文翻译:**
“我没激动！你凭什么觉得我激动？”对，没错。当然会。当有人哭的时候，显然他们情绪激动了。但当他们处于防御状态时，你可能想换个词。比如“我能看出来这让你很不舒服”或者“这触动了你”，或者“我能感觉到我们之间的气氛变了”。你可以这样说。我认为了解你的员工也很有帮助，因为有时你会发现他们其实能应付这种直白的说法，但有时你确实需要使用一些委婉的词语来暂停对话。

---

### 00:23:05 Lenny Rachitsky

**English:**
Yeah. And I find, to your point, it's helpful to you too as the person giving it. And I feel like sometimes, you may be feeling like I should just pull back and maybe I'm wrong, maybe they're right, maybe I should stop and instead this gives you a chance to know I'm actually, I can't. I need to stay strong about what I believe because I... You put so much thought and effort into this already, it's unlikely you're just like, oh, totally wrong about what you're saying.

**中文翻译:**
是的。而且我发现，正如你所说，这对给出反馈的人也很有帮助。我觉得有时候你可能会觉得“我应该退缩，也许我错了，也许他们是对的，也许我该停止”，而这个工具给了你一个机会，让你知道“不，我不能退缩。我需要坚持我的看法”，因为你已经投入了这么多思考和精力，你不太可能完全说错。

---

### 00:23:30 Alisa Cohn

**English:**
Yeah, exactly. There's something going on. There's something going on. And then also, the whole point about it being a conversation is that actually it's a conversation. Actually, Lenny, if you have a different point of view, I would like to hear it. Let's talk about it, but we can't keep going on like this, where I don't feel I can count on you for whatever it is that we're talking about. So we need to have this conversation and recreate a set of expectations between ourselves. Ultimately, that kind of conversation has the potential to really build the relationship and build trust, and that's another reason I encourage everybody to get over their discomfort and to lean into having these conversations because on the other side of that, is a much better, stronger connection.

**中文翻译:**
是的，没错。肯定是有原因的。而且，对话的重点在于它确实是一场“对话”。事实上，Lenny，如果你有不同的看法，我很想听听。我们可以讨论，但我们不能再这样下去了——在某些事情上我觉得无法依靠你。所以我们需要谈谈，重新建立我们之间的预期。最终，这种对话有潜力真正建立关系和信任，这也是我鼓励大家克服不适、勇于进行这些对话的另一个原因，因为在不适的另一面，是更好、更牢固的连接。

---

### 00:24:09 Lenny Rachitsky

**English:**
And especially if you do them well.

**中文翻译:**
尤其是如果你处理得好的话。

---

### 00:24:11 Alisa Cohn

**English:**
Yes.

**中文翻译:**
是的。

---

### 00:24:12 Lenny Rachitsky

**English:**
Following this advice. So okay, so again, if somebody's feeling defensive, can you again say how you start that, if you notice that? And then I'll highlight the two elements again of the...

**中文翻译:**
遵循这些建议。好，那么再说一次，如果你注意到有人感到防御，你会如何开始那段话？然后我会再次强调那两个要素……

---

### 00:24:25 Alisa Cohn

**English:**
So the way to pause is to actually say, "Let's just pause for a second because I'm feeling the energy has changed and I can see that you're getting a little bit heated by what I'm saying and I want you to know that I have no intention of upsetting you. I just want to be able to talk to you about the things that are going to help you in your career."

**中文翻译:**
暂停的方式是直接说：“我们先停一下，因为我感觉到气氛变了，我能看出来我刚才说的话让你有点激动。我希望你知道，我绝没有要让你难受的意思。我只是想和你谈谈那些能帮助你职业发展的事情。”

---

### 00:24:45 Lenny Rachitsky

**English:**
Awesome. And I love, again, just the reminder of here's why this is important to you, here's the benefit to you and why this will help you. And then it's like, "Okay, let's just maybe take a pause and come back to this conversation if you're feeling like this isn't the best time." Awesome. Anything else along that line before we go to another type of a hard conversation?

**中文翻译:**
太棒了。我再次强调，我非常喜欢这种提醒：“这是为什么这对你很重要，这对你有什么好处，为什么这会帮助你。”然后是：“好吧，如果你觉得现在不是最好的时机，我们也许可以先暂停，晚点再谈。”太棒了。在进入另一种艰难对话之前，关于这一点还有什么要补充的吗？

---

### 00:25:02 Alisa Cohn

**English:**
I mean, I can talk all day about this [inaudible 00:25:06], but I'm happy to move on.

**中文翻译:**
关于这个我可以聊一整天，但我很乐意继续下一个话题。

---

### 00:25:07 Lenny Rachitsky

**English:**
Well, let's pick another topic. I know you have kind of five buckets and types of conversation. Maybe the promotion one. That feels like I think we're in performance review season. It feels like these are happening a bunch. What do you suggest when someone's being told they're not going to get the promotion they expected or wanted?

**中文翻译:**
那我们选另一个话题。我知道你有大约五类对话。也许可以聊聊晋升那个。现在正是绩效评估季，这种对话肯定很多。当有人被告知他们没有获得预期的晋升时，你有什么建议？

---

### 00:25:24 Alisa Cohn

**English:**
Of course that's challenging. So again, getting your mindset right, recognizing they're disappointed, they're going to be disappointed, recognizing how you felt, the time that when you didn't get a promotion or whatever. And so kind of coming to it with some compassion. And also, you have to get your reasoning right. So sometimes people think they should get a promotion because they were here for a year or whatever. Sometimes people think they should get a promotion because they're the only internal candidate who's qualified for this or they might have a sense of themselves succeeding or achieving that is more inflated maybe than you see them. So trying to think about where they're coming from.

**中文翻译:**
这当然很有挑战性。所以，再次强调，要调整好心态，意识到他们会感到失望。回想一下你自己没得到晋升时的感受，带着同理心去谈。此外，你的理由必须站得住脚。有时人们觉得干满一年就该晋升，或者觉得自己是唯一合格的内部候选人，或者他们对成功的自我感知比你看到的要高。所以要试着从他们的角度思考。

---

### 00:25:56 Alisa Cohn

**English:**
And then the conversation is just, "Matilda, I know this is going to be challenging for you to hear. I know you were hoping to get that promotion, but I want to let you know that we are going to actually be looking for an external candidate. I want to give you a few thoughts about why. First of all, in discussing this with my peers, I'm realizing that we need someone who has done this role multiple times in the past and has that experience. Number two, I think it's really important that they have an expertise in a specific realm that we've identified as really important. So for those reasons, we're going to bring someone in from the outside, not going to promote you, but I want you to know this. Number one, it's really important to me that you're able to succeed in your career here. And so I want to continue to help you find opportunities to build your skills and to advance. And then number two, when we bring this person in, I'm committed to finding someone who's a great people leader, who is going to help you build those skills."

**中文翻译:**
对话可以这样进行：“Matilda，我知道这听起来可能让你很难受。我知道你一直希望能获得那个晋升，但我必须告诉你，我们实际上打算寻找外部候选人。我想告诉你几点原因：首先，在与同事讨论后，我意识到我们需要一个过去多次担任过这个角色并拥有丰富经验的人。第二，我认为候选人在我们确定的某个非常重要的特定领域拥有专业知识是至关重要的。基于这些原因，我们会从外部招人，不会提拔你。但我希望你知道：第一，对我来说，你能在这里获得职业成功非常重要，我会继续帮你寻找提升技能和晋升的机会。第二，当我们引入这个人时，我承诺会找一个优秀的团队领导，他会帮助你培养这些技能。”

---

### 00:26:54 Lenny Rachitsky

**English:**
So a few elements there that stood out to me. One is just being very upfront and not bearing the lead. Telling them very early, "Here's what I've decided." As you said it, I could see my heart sinking immediately when I feel that. So at least that's over and then it, here's why. And that starts to help you feel like, "Okay, I get it. I understand at least how you thought about this." And then there's the hope for the future, your painting of, here's how I can get there eventually.

**中文翻译:**
这里有几个让我印象深刻的要素。一是开门见山，不绕弯子，很早就告诉他们：“这是我的决定。”当你这么说时，我能感觉到心猛地沉了一下，但至少悬念结束了。然后是“为什么”，这让人觉得：“好吧，我明白了，我至少理解了你的思考过程。”最后是对未来的希望，你描绘了“我最终如何能达到那个目标”。

---

### 00:27:21 Alisa Cohn

**English:**
Yes, that hope for the future is so important and I think sometimes we're such in a rush to kind of deliver the bad news that we forget there's a human being over there who needs hope for the future. And hopefully. If they're a good employee, hopefully they have hope for the future.

**中文翻译:**
是的，对未来的希望非常重要。我认为有时我们太急于传达坏消息，以至于忘记了对方是一个需要未来希望的人。如果他们是优秀的员工，希望他们能看到未来的希望。

---

### 00:27:35 Lenny Rachitsky

**English:**
I love that. Is there anything else to that script that you think is really highlighting or do you think I touched on the key elements?

**中文翻译:**
我喜欢这个。关于那个脚本，你觉得还有什么需要强调的吗？还是说我已经触及了核心要素？

---

### 00:27:41 Alisa Cohn

**English:**
I think you touched on the key elements.

**中文翻译:**
我觉得你已经触及了核心要素。

---

### 00:27:43 Lenny Rachitsky

**English:**
Okay. And again, the way you started is, I have some bad news for you or I have some disappointing news for you.

**中文翻译:**
好。再说一次，开场白是“我有一个坏消息要告诉你”或者“我有一些令人失望的消息要告诉你”。

---

### 00:27:48 Alisa Cohn

**English:**
Yes, because it's just [inaudible 00:27:50].

**中文翻译:**
是的，因为事实就是如此。

---

### 00:27:48 Lenny Rachitsky

**English:**
Just get right into it. Yeah.

**中文翻译:**
直接切入正题。是的。

---

### 00:27:51 Alisa Cohn

**English:**
Yeah, just get right into it. Yeah. By the way, the other piece on that might be, if it's appropriate, I'd love you to digest this information and then let's talk about it again next week to see what you've come up with or see how you feel about it because you want to send, this is not the script, this is for me to you. You want to send the, I care about you message because that's the other thing. In the workplace, people, they're going through all their feelings, all their emotions, disappointments. They're going to go home and tell their spouse, didn't get the promotion or whatever. It's going to loom large. It's going to be demoralizing.

**中文翻译:**
是的，直接切入。顺便说一下，另一部分可能是（如果合适的话）：“我希望你能消化一下这些信息，下周我们再谈谈，看看你有什么想法或感受。”因为你想传达——这不是脚本里的，是我对你说的——你想传达“我在乎你”的信息。在职场中，人们会经历各种情绪和失望。他们会回家告诉配偶没得到晋升，这会成为一件大事，会让人士气低落。

---

### 00:28:24 Alisa Cohn

**English:**
When you, as a leader signal a lot, I care about you, I care about your feelings, I care that you're disappointed, I care about your career, you are always going to be able to help people stay resilient in the face of setbacks and ultimately, do extra work, do the right work for you and be engaged in your company because you've spent the time and energy making sure they know that even when things are not going their way, they have an ally in you.

**中文翻译:**
当你作为领导者发出“我在乎你、在乎你的感受、在乎你的失望、在乎你的职业生涯”的信号时，你就能帮助员工在挫折面前保持韧性。最终，他们会愿意为你承担额外工作，做正确的工作，并对公司保持投入，因为你花了时间和精力让他们知道，即使事情不如意，你也是他们的盟友。

---

### 00:28:56 Lenny Rachitsky

**English:**
What do you do if they just disagree, if they're just like, "But I do have those skills and I don't think this is fair." Thoughts on responding to that sort of feedback? I guess, that's the defensiveness stuff.

**中文翻译:**
如果他们就是不同意呢？如果他们说：“但我确实具备那些技能，我觉得这不公平。”对于这种反馈，你有什么回应的想法？我想这属于防御心理的范畴。

---

### 00:29:06 Alisa Cohn

**English:**
Yeah, that's the defensiveness stuff. And again, I hope you've done your homework to identify that actually that person doesn't have those skills and if there is a [inaudible 00:29:16] for example, but I do have those skills or sometimes people, I think more, even more often, they don't respond to what you just said. They will instead explain to you that they've been here for a year or they're the only internal candidate or their peer got promoted.

**中文翻译:**
是的，那是防御心理。再次强调，我希望你已经做好了功课，确认那个人确实不具备那些技能。如果对方说“但我确实有那些技能”，或者更常见的情况是，他们不直接回应你刚才说的话，而是向你解释他们已经在这里干了一年，或者他们是唯一的内部候选人，或者他们的同事晋升了。

---

### 00:29:31 Alisa Cohn

**English:**
Right, they'll sort of explain to you things which are not part of your decision-making process and then it helpful for you to say something like, "Yeah, listen, Matilda, I really understand that you were thinking that after a year, you'd get promoted around here. And in the past, I do think because of the stage of our company, probably people have been promoted at that period. That's not the place we're at right now. As we scale, we really need to think about not just what we need for today and tomorrow, but for the future. And that's why I want these specialized skills in here. I think it's going to help the entire company."

**中文翻译:**
对，他们会解释一些与你的决策过程无关的事情。这时，你可以这样说：“Matilda，我非常理解你觉得干满一年就该晋升。在过去，考虑到公司的阶段，可能确实有人在那个时间点晋升了。但我们现在的情况不同了。随着规模扩大，我们不仅要考虑今天和明天的需求，还要考虑未来。这就是为什么我需要这些专业技能，我认为这对整个公司都有好处。”

---

### 00:30:02 Alisa Cohn

**English:**
So that's an example of a discussion that you could have. I do have the skills. That's kind of interesting. I'd love to hear what you see as those skills. And it's not a problem to have the conversation right there then, but if there's a "Yes, I do, no, I don't, yes, I do, no, you don't," that pushback is never productive. And so, that's where you want to probably again take a pause and say, "Listen, I totally hear you. You and I have a different point of view about this. I'm not sure if it's productive to continue to discussing right now. Let's talk about it again in a week. But I also want you to know this is a decision that I've made."

**中文翻译:**
这就是你可以进行的讨论示例。如果对方说“我有这些技能”，你可以回：“这很有趣，我很想听听你认为的这些技能是什么。”当场讨论没问题，但如果变成了“我有”、“你没有”、“我真的有”、“你真的没有”这种拉锯战，这种推诿是没有任何成效的。这时你应该再次暂停，说：“听着，我完全听到了你的想法。你我在这件事上有不同的看法。我不确定现在继续讨论是否有成效。我们一周后再谈。但我希望你知道，这是我已经做出的决定。”

---

### 00:30:39 Lenny Rachitsky

**English:**
I love though, when they come back to you and like, "But here's X, Y, Z." And you're like, "That's not what I was saying necessarily." I love that you basically mirror back. I hear what, I understand you believe, I understand you've been here for a year. I understand you're the only internal candidate," like making them feel very heard. That's a really powerful mechanic there. That is a good tool. Is there another script that you think might be helpful to talk through that is a common hard conversation people have?

**中文翻译:**
我非常喜欢这种处理方式：当他们反驳说“但是 X、Y、Z”时，你并不是说“我不是那个意思”，而是基本上把他们的话反射回去。比如“我听到了，我理解你认为……，我理解你已经在这里干了一年，我理解你是唯一的内部候选人”，这让他们感到被倾听了。这是一个非常强大的机制，一个很好的工具。还有其他你觉得值得讨论的常见艰难对话脚本吗？

---

### 00:31:05 Alisa Cohn

**English:**
Well, the hardest conversation is firing someone.

**中文翻译:**
嗯，最艰难的对话莫过于解雇某人。

---

### 00:31:09 Lenny Rachitsky

**English:**
Let's do it. Let's get into it.

**中文翻译:**
来吧，让我们深入聊聊这个。

---

### 00:31:13 Alisa Cohn

**English:**
[inaudible 00:31:13]. I'm willing to get into it. I just want to say two things about that. First of all, when you're firing someone, the hope is that it's not a surprise to them. You've had multiple conversations with them that they're not living up to your expectations. It's essential because the truth is, you want to create a culture where people are not surprised by being fired. And that's not even true for this one person you're dealing with. That's true for the entire company. So just kind of getting in the mindset of recognizing that if you shied away from those conversations, kind of like, "You're the problem here and you have some catch up to do."

**中文翻译:**
我愿意聊这个。关于解雇，我想说两点：首先，当你解雇某人时，理想情况是这不应该让他们感到意外。你应该已经和他们进行过多次谈话，告知他们没有达到预期。这至关重要，因为你想要建立一种文化，让人们不会因为被解雇而感到突如其来。这不仅是为了你正在处理的这个人，也是为了整个公司。所以要调整心态，意识到如果你回避了那些“你现在有问题，需要赶上来”的对话，那就是你的失职。

---

### 00:31:43 Alisa Cohn

**English:**
The second thing is that before you fire someone, I think it's helpful to have the conversation before the firing conversation because something you said Lenny is like, "Oh, but maybe I'm wrong. Maybe I'm not sure." And that bleeds into, "Maybe I haven't been clear with this person." Regularly with my clients, I'll say, "Okay, have you been crystal clear about what you need from this person?" And what they always do is the hand motion like well, sort of, but well, maybe. Which means no, which means no. You've not been crystal clear or you don't perceive even crystal clear. The way to make sure that you're crystal clear is by having the conversation before it comes to that.

**中文翻译:**
第二点是，在正式解雇谈话之前，先进行一次预警谈话是很有帮助的。因为 Lenny 你刚才说：“噢，也许我错了，也许我不确定。”这会导致“也许我还没跟这个人说清楚”。我经常问我的客户：“你是否已经非常明确地告诉过这个人你需要什么？”他们总是做手势说“嗯，差不多吧，但是，也许吧”。这意味着“没有”，意味着你没有说清楚，或者你觉得没说清楚。确保说清楚的方法就是在走到那一步之前先谈一次。

---

### 00:32:23 Alisa Cohn

**English:**
What that looks like is, "Listen, Matilda, we have to have a difficult conversation right now. I've talked to you multiple times about coordinating with your peers and not having them surprised about missed deadlines, and I've talked to you multiple times about keeping your team in the loop on different things. After six months of these conversations, I want you to know that the peers continue to feel like that you're operating on your own without coordinating with them. And I continue to hear from your team that they're not fully on the same page. I need you to know that this is very important. I need you to fix this within the next 30 days. Otherwise, I'm sorry to say, we're going to have to find a way to part ways because I can't keep this going with you. I know you have it in you to change. I value all you bring to the table, but if you don't fix these things, we're not going to have a future together."

**中文翻译:**
那次谈话应该是这样的：“听着，Matilda，我们现在必须进行一次艰难的对话。我已经多次和你谈过要与同事协调，不要让他们因为错过截止日期而感到意外；我也多次谈过要让团队了解各种事情的进度。在进行了六个月的此类谈话后，我希望你知道，同事们仍然觉得你在单打独斗，没有与他们协调。我也继续从你的团队那里听到他们没有完全掌握进度。我需要你知道这非常重要。我需要你在接下来的 30 天内解决这个问题。否则，我很遗憾地说，我们将不得不分道扬镳，因为我无法再这样继续下去了。我知道你有能力改变，我非常看重你的贡献，但如果你不解决这些问题，我们就没有共同的未来了。”

---

### 00:33:19 Lenny Rachitsky

**English:**
That is very crystal clear.

**中文翻译:**
这确实非常明确。

---

### 00:33:20 Alisa Cohn

**English:**
Yes, crystal clear.

**中文翻译:**
是的，非常明确。

---

### 00:33:22 Lenny Rachitsky

**English:**
Yeah. Okay.

**中文翻译:**
是的，好。

---

### 00:33:22 Alisa Cohn

**English:**
What do you think of that?

**中文翻译:**
你觉得怎么样？

---

### 00:33:24 Lenny Rachitsky

**English:**
Yeah, that was great. So it starts with being upfront. This is a difficult conversation, just to set expectations. They're like, "Oh, shit." And then it seems like you come back to, again, multiple times this happened, observing here's what's happening. It's happened multiple times. I keep hearing from multiple people, [inaudible 00:33:44] be a problem. And so it's just like, "I need you to know," and you're just very clear. "Here's what will happen if this doesn't change."

**中文翻译:**
是的，太棒了。首先是开门见山，说“这是一次艰难的对话”，以此设定预期。对方会想：“噢，糟了。”然后你回到事实：这件事已经发生过多次，观察到了什么情况。它发生了多次，我一直从多个人那里听到，这成了一个问题。所以就是“我需要你知道”，然后非常明确：“如果这不改变，会发生什么。”

---

### 00:33:52 Alisa Cohn

**English:**
Yes.

**中文翻译:**
是的。

---

### 00:33:52 Lenny Rachitsky

**English:**
Yeah. And I love that you also give them a little, there's always that hope for who they are and how you see them as. They're not worthless. It's just like, "You are great at a lot of things. You have these skills. You're great at blah, blah, blah, but still this is a big problem." And it's communicating how critical this is. [inaudible 00:34:08].

**中文翻译:**
是的。我喜欢你还给了他们一点希望，关于他们是谁以及你如何看待他们。他们并不是一无是处。就像是：“你在很多方面都很出色，你具备这些技能，你在某某方面做得很好，但这仍然是一个大问题。”这传达了这件事有多么关键。

---

### 00:34:08 Alisa Cohn

**English:**
Yeah, and it's a deal breaker. It's a deal breaker. Right?

**中文翻译:**
是的，这是“决定性障碍”（deal breaker）。这是底线，对吧？

---

### 00:34:10 Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### 00:34:12 Alisa Cohn

**English:**
If you have so many talents, but if you can't do these two things, then it's a deal breaker for all of us.

**中文翻译:**
如果你有这么多才华，但如果你做不到这两件事，那对我们所有人来说都是无法接受的。

---

### 00:34:16 Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### 00:34:16 Alisa Cohn

**English:**
And I think it's important to really sort of see that both. Sometimes people think, "Well, but I'm so talented." Yeah, but your talents are not going to make up for these two deal breakers.

**中文翻译:**
我认为看清这两点很重要。有时人们会想：“嗯，但我很有才华啊。”是的，但你的才华无法弥补这两个致命的缺陷。

---

### 00:34:25 Lenny Rachitsky

**English:**
Yeah. And I feel like I know we were going to talk about the firing conversation, but I think this is even more important than that because hopefully, this addresses the problem and you don't need to fire them, which is more valuable.

**中文翻译:**
是的。我觉得虽然我们本来要谈解雇谈话，但我觉得这个预警谈话甚至比那个更重要，因为希望这能解决问题，让你不需要解雇他们，这更有价值。

---

### 00:34:36 Alisa Cohn

**English:**
Yes. Yeah, hopefully. But even if you do, it's actually easier because you've already had the conversation. Right? They're not surprised. It's clear. We've had the discussion.

**中文翻译:**
是的，希望如此。但即使最终还是要解雇，也会变得更容易，因为你已经谈过了，对吧？他们不会感到意外。事情很明确，我们已经讨论过了。

---

### 00:34:46 Lenny Rachitsky

**English:**
Yeah. So basically the script is like, "There's going to be a difficult conversation. I've seen multiple times this thing and we've talked multiple times and it's still not fixed and here's what I just want to be very clear about." Is there also a script you have for just actually doing the firing or is that less scriptable?

**中文翻译:**
是的。所以脚本基本上是：“我们要进行一次艰难的对话。我多次看到这件事，我们也谈过多次，但还没解决，这是我想要明确说明的情况。”那么，对于“实际执行解雇”的谈话，你也有脚本吗？还是说那个不太好写脚本？

---

### 00:35:05 Alisa Cohn

**English:**
Well, the script for doing the firing is again, please everybody, talk to your HR professional. Talk to your lawyer. Okay, I'm not a lawyer, I'm afraid. So you have to make sure that you're all buttoned up on what you're going to do. But the conversation is actually very simple, which is just, "Matilda, we talked about this multiple times. The last time we had this conversation, I told you I needed you to make these changes. You haven't made these changes and we're going to part ways. So I have here, Sarah from HR or whatever, and we're going to talk through the logistics of that. I'm happy to have a longer conversation with you, but I want you to know we've made the decision to terminate you."

**中文翻译:**
关于解雇的脚本，再次提醒大家：请咨询你的 HR 专家和律师。我不是律师。所以你必须确保在行动前做好万全准备。但谈话本身其实很简单，就是：“Matilda，我们已经多次谈过这件事。上次谈话时，我告诉你我需要你做出这些改变。你没有做出这些改变，所以我们要分道扬镳了。HR 的 Sarah 也在场，我们将讨论后续的交接事宜。我很乐意和你进行更深入的交谈，但我希望你知道，我们已经做出了终止雇佣关系的决定。”

---

### 00:35:42 Lenny Rachitsky

**English:**
Feels very reasonable to me. Is there anything else along these lines?

**中文翻译:**
我觉得这非常合理。关于这方面还有什么吗？

---

### 00:35:42 Alisa Cohn

**English:**
I think what I want to say is that the conversations you need to have at work are not just difficult conversations. What I call them is sort of delicate conversations because what I think people also shy away from is just simple praise, specific praise. And I think it's really important to get in the habit of pointing out what your people are doing well as carefully as you need to prepare for pointing out what they need to improve. And sometimes leaders feel like, "Yeah, it's all working. It's all working. I don't have to tell you." Or if I do tell you, it's kind of like "Good job." Right? One time a leader or a manager I was doing in a training program, she said, "I don't like getting positive feedback. I only like getting negative feedback." And I said, "How come?" And she said, "Oh, positive feedback is just like, oh, good job. Negative feedback, you can learn something. You get something from it."

**中文翻译:**
我想说的是，你在工作中需要进行的对话不仅仅是“艰难对话”。我称之为“微妙对话”，因为我认为人们往往也会回避简单的表扬，尤其是具体的表扬。我认为养成指出员工做得好的地方的习惯非常重要，这和你准备指出他们需要改进的地方一样需要细心。有时领导者觉得：“一切都很顺利，我没必要告诉你。”或者即使说了，也只是随口一句“做得好”。有一次我在培训中遇到一位经理，她说：“我不喜欢收到积极反馈，我只喜欢消极反馈。”我问为什么，她说：“积极反馈就像是‘噢，做得好’，而消极反馈能让你学到东西，让你有所收获。”

---

### 00:36:40 Alisa Cohn

**English:**
So the positive feedback should have the same standard, which is, "I saw the way you ran that launch, it was fantastic. All these different benefits came from it. You're so organized, keep doing that." Or "The way you're keeping your peers in the loop, considering you've only been here three months is extraordinary. I've never seen someone so communicative. It's fantastic. Keep doing that. That's really working for you." If you do that often enough, you do get in the... First of all, it's positive, obviously. You become in the habit of getting better at positive feedback, which is extremely motivating to people at work. It helps them see their progress because that person I just mentioned, she's barely keeping her head above water and she's having trouble fitting in or whatever, but you come around and point out the things that are working. Again, it's very morale boosting. She knows where she stands, and then one day, if you have to give her these difficult messages, you've already sort of laid the reservoir of goodwill.

**中文翻译:**
所以积极反馈也应该有同样的标准，比如：“我看到了你组织那次发布的方式，非常出色。它带来了这么多好处。你非常有条理，请继续保持。”或者“考虑到你才来了三个月，你让同事了解进度的方式非常了不起。我从未见过沟通能力这么强的人。太棒了，请继续保持，这对你非常有帮助。”如果你经常这样做，首先这显然是积极的，你会养成擅长给积极反馈的习惯，这对职场人士极具激励作用。这能帮他们看到自己的进步。比如我刚才提到的那个人，她可能正勉强维持现状，难以融入，但你过来指出了她做得好的地方。这非常鼓舞士气，让她知道自己的定位。这样有一天如果你不得不给她传达艰难的信息，你已经建立了一定的“好感储备”。

---

### 00:37:37 Lenny Rachitsky

**English:**
I love giving positive feedback. It's obviously so much easier, but to your point, it's like you have to really think about how to do it well. It's not just a, it's not that easy if you do it well, which is a really good point. And [inaudible 00:37:49] needs scripts for how to give really good positive feedback and have great conversations.

**中文翻译:**
我喜欢给积极反馈。这显然容易得多，但正如你所说，你必须认真思考如何把它做好。如果想做得好，其实并没那么简单，这是一个很好的观点。也许人们也需要关于如何给出高质量积极反馈和进行愉快对话的脚本。

---

### 00:37:53 Alisa Cohn

**English:**
Yeah.

**中文翻译:**
是的。

---

### 00:37:53 Lenny Rachitsky

**English:**
That's interesting. There's less demand for that. How do I have better great conversations or compliments?

**中文翻译:**
这很有趣，这方面的需求比较少。比如“我如何进行更好的愉快对话或赞美？”

---

### 00:37:59 Alisa Cohn

**English:**
Right, right. True.

**中文翻译:**
对，对，确实如此。

---

### 00:37:59 Lenny Rachitsky

**English:**
No man. Today's episode is brought to you by Liveblocks, the platform that turns your product into a place that users want to be. With ready-made collaborative features, you can supercharge your product with experiences that only top tier companies have been able to perfect until now. Think AI copilots like Notion, multiplayer like Figma, comments and notifications like Linear and even collaborative editing like Google Docs, and all of that with minimal configuration or maintenance required.

**中文翻译:**
伙计们，今天的节目由 Liveblocks 赞助。Liveblocks 是一个能将你的产品变成用户向往之地的平台。通过现成的协作功能，你可以为你的产品注入顶级公司才能完善的体验。想想 Notion 的 AI 副驾驶、Figma 的多玩家模式、Linear 的评论和通知，甚至是 Google Docs 的协作编辑，所有这些都只需要极少的配置或维护。

---

### 00:38:31 Lenny Rachitsky

**English:**
Companies from all kinds of industries and stages count on Liveblocks to drive engagement and growth in their products. Join them today and give your users an experience that turns them into daily active users. Sign up for a free account today at liveblocks.io/lenny. I want to go on a little bit of a tangent, something that it's kind of touches on all the things we've been talking about, which is, you're big on helping leaders understand that their job is not to make employees happy. What is your job instead? Why do people think this is their job to make their employees happy and what should they be thinking instead is their job as a leader?

**中文翻译:**
各行各业、各个阶段的公司都依靠 Liveblocks 来推动产品的参与度和增长。今天就加入他们，为你的用户提供能让他们成为每日活跃用户的体验。立即在 liveblocks.io/lenny 注册免费账户。我想稍微岔开一下话题，这与我们一直在谈论的内容有关：你非常强调让领导者明白，他们的工作不是让员工开心。那么，你的工作到底是什么？为什么人们会认为让员工开心是他们的职责？作为领导者，他们应该认为自己的职责是什么？

---

### 00:39:09 Alisa Cohn

**English:**
[inaudible 00:39:09], I work with a lot of founders and so, don't forget that the entry-level position for a founder is leader, and they have it, they often not had a lot of other experiences being a leader or a manager, and so they're just doing the best they can. It makes sense, right? And they kind of get all this information from other people and their HR leader wants to have a happy engaged workforce and they don't want to upset people for all the reasons we talked about, why you don't want to upset people. Nobody wants to upset people.

**中文翻译:**
我与很多创始人合作，别忘了，创始人的入门职位就是“领导者”，而他们往往没有太多作为领导者或经理的其他经验，所以他们只是尽力而为。这很合理，对吧？他们从别人那里获得各种信息，他们的 HR 负责人想要一个快乐、投入的员工队伍，他们不想让人生气，原因就是我们之前讨论过的那些。没人想让人生气。

---

### 00:39:40 Alisa Cohn

**English:**
And so there's this idea of, they're trying to now be now be the leader who everyone loves and makes people happy. So they would often bend over backwards to make people happy, to keep people, their morale up. But what really needs to happen very often is, we need to drive towards results. And the way this system is working is not going to drive us towards results or this employee continuing to not really do a great job at their job and not really pushing themselves. And you don't want to push them because you don't want to upset them, you don't want to give them difficult feedback, so you're just going to keep hoping it works out.

**中文翻译:**
所以就有了这种想法：他们试图成为那个每个人都爱戴、能让每个人都开心的领导者。因此，他们往往会竭尽全力让员工开心，维持士气。但通常真正需要发生的是，我们需要朝着结果迈进。而目前的系统运作方式可能无法推动我们取得结果，或者某个员工一直表现平平，没有真正逼自己一把。你不想逼他们，因为你不想让他们难受，你不想给他们严厉的反馈，所以你只是继续寄希望于事情会好转。

---

### 00:40:23 Alisa Cohn

**English:**
Ultimately, that leads to the demise of your company. I mean, ultimately right, as you're a startup? If you're not in a startup and you're a large company, it still is very subpar performance, obviously. And you're dancing around hoping and praying they're going to get there and they don't really know there's a problem. And so, I think it's very misguided for leaders to have this notion that their most important role is to keep people happy, is to create this high engagement workforce. High engagement workforce is great.

**中文翻译:**
最终，这会导致公司的灭亡。我是说，如果你是初创公司，最终会是这样。如果你不是初创公司而是大公司，这显然会导致表现平庸。你小心翼翼地避开问题，祈祷他们能达到目标，而他们甚至不知道存在问题。因此，我认为领导者认为自己最重要的角色是让员工开心、创造高投入度的员工队伍，这种想法是非常误导人的。高投入度的员工队伍固然好。

---

### 00:40:56 Alisa Cohn

**English:**
I think what that comes from is winning culture, which means we're set up for success. We've got the structure for success, we have the culture for success, everyone understands their role, they know the impact of their role. So doing the work to figure out and help them figure out the impact of their role and that when they work together and achieve these milestones, they win and then we celebrate the wins and then we do it all over again. And when you create that kind of a workforce, I think it's much more dynamic, even though sometimes in doing that, you have to redirect people and ruffle their feathers.

**中文翻译:**
我认为高投入度源于“获胜文化”，这意味着我们为成功做好了准备。我们有成功的架构，有成功的文化，每个人都了解自己的角色，知道自己角色的影响力。所以，花精力去弄清楚并帮助他们弄清楚自己角色的影响力，让他们知道当大家齐心协力实现这些里程碑时，他们就赢了，然后我们庆祝胜利，接着周而复始。当你创造出这样一支员工队伍时，我认为它会更有活力，尽管在过程中你有时不得不重新引导员工，甚至会惹恼他们。

---

### 00:41:26 Lenny Rachitsky

**English:**
Essentially, the way I think about it is you think making people happy is not having hard conversations, not pushing them, when really, it's almost working backwards from, if we win and are killing it, people will be happy and what does it take to do that?

**中文翻译:**
本质上，我的理解是：你以为让员工开心就是不进行艰难对话、不逼迫他们，但实际上，这几乎是一个逆向推导的过程——如果我们赢了，表现极其出色，人们自然会开心。那么，为了达到那个目标需要做什么呢？

---

### 00:41:40 Alisa Cohn

**English:**
A hundred percent. And then the right people are going to want to join your team, people who like to win and like to get results.

**中文翻译:**
百分之百正确。然后，正确的人会想要加入你的团队，那些渴望胜利、渴望取得结果的人。

---

### 00:41:48 Lenny Rachitsky

**English:**
Is there a story, an example of a founder you worked with or that comes to mind of this kind of where they thought this was their approach and then they shifted? Or is there kind of a pattern you see often?

**中文翻译:**
有没有哪个你合作过的创始人，或者你脑海中出现的例子，他们最初是这种想法，后来转变了？或者你经常看到某种模式？

---

### 00:41:57 Alisa Cohn

**English:**
One company comes to mind. One leader I worked with. Sometimes I think to myself, if I'm writing a book, the book would start with, "It all started with the avocado toast," because he wants to do right by his workforce. And so they have avocado toast at 10 AM, like tea time kind of a thing. And it became this great ritual where people would kind of hang out together and that was great. And then that turned into other longer periods of just hanging out together. Again, these are good things. And that turned into evening socials and everybody was enjoying spending time together, but they continued to be not fully clear on what they were actually supposed to do. And there began to be kind of a cliquey, gossipy culture of who's in and who's out. And that would take up a lot of the socialization time discussions. So rather than talk about expectations about the work and about results, and again, the results were not showing. So it wasn't a lot to celebrate.

**中文翻译:**
我想起了一家公司，一位我合作过的领导者。有时我想，如果我要写本书，开头会是：“一切都始于牛油果吐司。”因为他想对员工好，所以他们每天上午 10 点会有牛油果吐司时间，就像下午茶一样。这成了一个很棒的仪式，大家聚在一起闲聊，这很好。然后这演变成了更长时间的闲聊。再说一次，这些本身是好事。接着又演变成了晚间社交活动，大家都很享受在一起的时光。但问题是，他们仍然不完全清楚自己到底该做什么。公司开始出现一种拉帮结派、爱传闲话的文化，讨论谁在圈子里，谁在圈子外。这占据了大量的社交讨论时间。大家不再讨论对工作的预期和结果，而且结果也确实没出来，所以也没什么好庆祝的。

---

### 00:43:05 Alisa Cohn

**English:**
They started at a culture committee. So they had a culture committee to talk about how we can make people happier around here. And you can imagine there's now layers and layers of things where we're trying to focus on engagement and we're trying to focus on the employees having a great experience. And the leader I'm working with is completely sincere. It actually want to have a great workplace. But I think the misguidedness was that he hadn't done a great job setting expectations. He had not done a great job of quote unquote "codifying their culture" because culture is not just avocado toast and working together and having socials, culture is things like, we go the extra mile or culture is we make sure, or it could be, we measure twice and cut once. Those are kinds of things that are really about the way we get work done around here. And certainly, a focus on results is like, are we following the process to then get the revenue and to then build a profitable company or are we just kind of hanging out together?

**中文翻译:**
他们成立了一个文化委员会，讨论如何让这里的人更开心。你可以想象，现在有了层层叠叠的东西，都在试图关注员工投入度和员工体验。我合作的那位领导者是非常真诚的，他真心想打造一个伟大的职场。但我认为误区在于他没有做好设定预期的工作。他没有做好所谓的“文化成文化”工作，因为文化不仅仅是牛油果吐司、一起工作和社交活动，文化是诸如“我们愿意多走一步”或者“我们确保万无一失”，或者是“三思而后行”。这些才是关于我们在这里如何完成工作的核心。当然，关注结果意味着：我们是否在遵循流程以获取收入并建立一家盈利的公司，还是我们只是聚在一起闲混？

---

### 00:44:07 Alisa Cohn

**English:**
So he had to come to terms with his own discomfort of addressing this with employees and his own discomfort in being a corporate drone of, "Oh, expectations and in the workplace and how we do things." And it turned out that's the whole thing with coaching and with working with people is that you kind of see what their underlying assumptions and beliefs are and there's a reason everyone does what they do. So there's a reason he's doing what he's doing. We had to come to terms with that and then he had to really courageously make some changes about the way he was operating. And ultimately, they had to part ways with one or two really toxic people who were creating this gossipy culture and making people feel not included and not focused on results. And then when they all got on the same page, they were able to gain a lot more traction.

**中文翻译:**
所以他必须克服与员工沟通这些问题的心理不适，以及他对自己成为一个满口“预期、职场、流程”的“公司机器”的抵触感。事实证明，教练工作和与人合作的核心就在于看清他们潜在的假设和信念，每个人做每件事都是有原因的。他那样做也是有原因的。我们必须正视这一点，然后他必须鼓起勇气改变自己的运营方式。最终，他们不得不辞退一两个制造闲话文化、让别人感到被排挤且不关注结果的毒瘤员工。当大家达成共识后，他们获得了更大的动力。

---

### 00:44:56 Lenny Rachitsky

**English:**
I feel like a lot of leaders and founders can relate to this, of wanting to create a great culture and keep it nice and friendly and everyone's a family and then things don't quite work out often in those cases. And there is a shift to, "Okay, we actually need to make a business that works."

**中文翻译:**
我觉得很多领导者和创始人都能感同身受：想要创造一种伟大的文化，保持友好，让每个人都像家人一样，但往往在这种情况下事情进展并不顺利。然后就会发生转变：“好吧，我们实际上需要建立一个能运转的业务。”

---

### 00:44:56 Alisa Cohn

**English:**
Right.

**中文翻译:**
没错。

---

### 00:45:12 Lenny Rachitsky

**English:**
It always reminds me, Sheryl Sandberg came to talk at Airbnb once and people are asking, "What do you do with all this...? We're just constantly in chaos. Things are always reorging or changing, just never... I'm on different teams every six months. Our goals are shifting. What do you do with all this... Our culture's changing as we grow." And she's like, "That is a sign of hyper growth and success. And the opposite is even worse when you are not growing and you don't want that. And so you should be happy this is the challenge you're running into."

**中文翻译:**
这总让我想起 Sheryl Sandberg 有次来 Airbnb 演讲，人们问她：“我们该如何应对这些……？我们一直处于混乱中。总是在重组或变动，我每六个月就在不同的团队。目标在变，随着我们的成长，文化也在变。”她说：“那是高速增长和成功的标志。相反的情况更糟，那就是你没有增长，而你肯定不想要那样。所以你应该感到高兴，因为这是你遇到的挑战。”

---

### 00:45:40 Alisa Cohn

**English:**
I love that. It's so true.

**中文翻译:**
我喜欢这个说法，太对了。

---

### 00:45:42 Lenny Rachitsky

**English:**
So along these lines, you talk about how a lot of founders have to come to terms, and it's not just founders, it's just execs and leaders you work with, have to come to terms with, "Here's what I thought leadership was going to be and how to be a great leader, and here's what it really is." Is there anything more there that you find is commonly what they're wrong about or what they miss and what they have to realize?

**中文翻译:**
沿着这个思路，你谈到很多创始人必须正视——不仅是创始人，还有你合作的高管和领导者——他们必须正视：“这是我原以为的领导力以及如何成为一名伟大的领导者，而这才是它的真面目。”关于他们通常误解了什么、遗漏了什么或者必须意识到什么，还有什么补充吗？

---

### 00:46:01 Alisa Cohn

**English:**
Yeah. And I think as we grow as leaders, we all have to realize our own blind spots and the difference between what we thought and what is actually going on. So I worked with a founder who she wanted to be was a visionary leader, which is fantastic. I would love that. And she was an incredibly visionary person, very inspirational. But what she didn't see is that what her company needed was somebody to structure and hold people accountable and help them create goals and achieve milestones and course correct when they got off course. And she'd be very frustrated when all those things happened. People got off course, people didn't have goals, people weren't structured to work together. But what she didn't realize was that was, in one way or the other, her job to make that happen.

**中文翻译:**
是的。我认为随着我们作为领导者的成长，我们都必须意识到自己的盲点，以及我们的设想与现实之间的差距。我曾与一位创始人合作，她想成为一名愿景型领导者，这很棒，我也很推崇。她确实是一个非常有远见、非常有感染力的人。但她没看到的是，她的公司需要的是有人来建立架构、进行问责、帮助员工设定目标、实现里程碑并在偏离轨道时进行纠偏。当这些问题发生时，她会非常沮丧：人们偏离了轨道，没有目标，没有协作架构。但她没意识到，无论以何种方式，让这些事情落地都是她的职责。

---

### 00:46:49 Alisa Cohn

**English:**
Now, maybe she needed to have, and I would talk to her a lot about this, a partner, like a COO or somebody else who could be the person who would be sort of managing the internal while she got to be more visionary, inspirational, but ultimately, it was her job to make sure that that was in place. And she didn't sort of see that and she did not adjust her style. And so there's a lot of wheel spinning that happens from that. Even though, by the way, she was an incredibly inspirational person and incredibly inspirational leader and she meant so well. There was nothing malicious about it. It's just that she didn't see the situation for what it was and then adjust.

**中文翻译:**
也许她需要一个合伙人，比如 COO 或其他人，来负责内部管理，而她则可以继续发挥愿景和感染力。我经常和她谈论这一点，但归根结底，确保这些机制到位是她的责任。她没有意识到这一点，也没有调整自己的风格。因此，尽管她是一个非常有感染力的领导者，初衷也非常好，没有任何恶意，但公司还是出现了很多无谓的内耗。只是因为她没有看清现状并做出调整。

---

### 00:47:30 Lenny Rachitsky

**English:**
It reminds me, we had this coach on the podcast, Joe Hudson, and he had this phrase that I think a lot of people use, but it just stuck with me. What you resist, persists. So if you hate confrontation, you're going to have much more confrontation. If you hate structure... Actually, this reminds me, Joe Gebbia at Airbnb. He was very anti-process at the beginning of Airbnb. He's like, "We're not going to have a process. I hate process. We're going to run... That's the big company stuff." And then it just chaos constantly. And then eventually it's like, "Okay, we need to have some process to how we build things."

**中文翻译:**
这让我想起我们播客请过的一位教练 Joe Hudson，他有一句话让我印象深刻：你所抗拒的，终将持续（What you resist, persists）。所以如果你讨厌冲突，你就会遇到更多的冲突。如果你讨厌架构……实际上，这让我想起 Airbnb 的 Joe Gebbia。在 Airbnb 早期，他非常反对流程。他说：“我们不需要流程，我讨厌流程，那是大公司才搞的东西。”结果就是持续不断的混乱。最终，他们意识到：“好吧，我们需要一些流程来规范我们的构建方式。”

---

### 00:48:02 Alisa Cohn

**English:**
Yeah.

**中文翻译:**
是的。

---

### 00:48:03 Lenny Rachitsky

**English:**
And so it's interesting. A lot of people have to realize the thing they think was bad is actually, I see why people do it this way.

**中文翻译:**
所以这很有趣。很多人必须意识到，他们认为不好的东西，其实是有其存在道理的。

---

### 00:48:10 Alisa Cohn

**English:**
Yeah, totally. Actually, I'd like to say something about that because so many... Founders are kind of mavericks and they come into a situation or they start at this company and they want to do things their own way and that's fantastic. Otherwise, they wouldn't be a founder. That's actually fantastic. And so many of the founders I've worked with want to reinvent leadership. Right? They want to have it with no process, they want to have no hierarchy, they want to have autonomy, whatever it is.

**中文翻译:**
是的，完全正确。实际上我想补充一点，因为很多创始人都是特立独行的人，他们进入一个领域或创办一家公司，想要按自己的方式行事，这太棒了，否则他们也不会成为创始人。但我合作过的很多创始人都想重新定义领导力。对吧？他们想要没有流程、没有层级、完全自主，诸如此类。

---

### 00:48:37 Alisa Cohn

**English:**
And my feeling is like, "God bless. You should absolutely try to do that." But at the end of the day, what happens is, they kind of invent for themselves the understanding that they need to have process, hierarchy, roles and responsibilities, goals, OKRs, whatever it is. And I think it's helpful sometimes to go through that fire of thinking we can do it a different way. But ultimately, I think that the ways to structure a group of people and get them organized so that they can win, are kind of well trod. And I would say that it's helpful to get through that stage quickly so that you don't have to constantly reinvent the wheels of leadership.

**中文翻译:**
我的感觉是：“上帝保佑，你绝对应该尝试那样做。”但最终发生的是，他们会自己慢慢意识到，他们确实需要流程、层级、角色与职责、目标、OKR 等等。我认为有时经历那种“以为可以另辟蹊径”的磨炼是有益的。但归根结底，组织一群人并让他们有条不紊地迈向胜利的方法，其实已经是前人走烂了的路。我想说，快速走过那个阶段是有好处的，这样你就不用不断地重新发明领导力的轮子。

---

### 00:49:19 Lenny Rachitsky

**English:**
Such an important context. Obviously, one of the... The most successful founders come up with, have first principles thinking into how to do stuff, and oftentimes they find something no one has ever thought about. So it's always this balance of try a bunch of stuff, a lot of it won't [inaudible 00:49:34]. Some of it was, what will help you win. And I think that's a really good point. I want to get into a couple more tactical things that you often work on with founders. One is, running meetings. Meetings come up a lot on this podcast. People hate them, people love them. There's some are great, some are bad, most are bad. You have some cool advice on just how to make meetings more effective and how to especially end a meeting to help you move forward. Talk about what your advice is there and just generally any advice for better meetings.

**中文翻译:**
这是一个非常重要的背景。显然，最成功的创始人会用第一性原理来思考如何做事，而且往往能发现别人从未想到的东西。所以这总是一种平衡：尝试很多东西，其中大部分可能行不通，但有些会帮助你获胜。我觉得这是一个很好的观点。我想进入几个你经常与创始人合作的更具战术性的环节。一个是开会。会议在这个播客中经常被提及。人们讨厌会议，也有人喜欢会议；有些会议很棒，有些很糟，大多数都很糟。关于如何提高会议效率，尤其是如何结束会议以推动进展，你有一些很酷的建议。聊聊你的建议，以及关于开好会的通用建议。

---

### 00:50:01 Alisa Cohn

**English:**
Yeah. I'm one of the few people that loves meetings. Or I should say I don't love meetings. I love the potential for meetings. We have all this smart people in the room. We have the potential to talk about these great things and make decisions. And unfortunately, they don't go that way. So what happens often, I mean there's so many downfalls with meetings, but one thing that happens is, we keep meeting. Either we make decisions or we don't make decisions, but then we come back to meet again and we don't have any continuity from the last. So then we re-meet, we re-decide, and that is a big problem. So my three questions to end the meeting are, what did we decide here? Who needs to do what by when? And who else needs to know? And if you can capture those, articulate those as deliverables, I promise you, you're going to have better meetings.

**中文翻译:**
是的。我是少数喜欢会议的人之一。或者我该说，我不喜欢会议本身，但我喜欢会议的潜力。房间里有这么多聪明人，我们有潜力讨论伟大的事情并做出决定。遗憾的是，现实往往并非如此。会议有很多弊端，其中之一就是我们不停地开会。无论是否做出了决定，下次开会时我们又回到了原点，与上次会议没有任何连贯性。于是我们重新开会，重新决定，这是一个大问题。所以我结束会议的三个问题是：1. 我们在这里决定了什么？2. 谁需要在什么时候完成什么？3. 还有谁需要知道？如果你能捕捉到这些，并将它们明确为交付成果，我保证你的会议会变得更好。

---

### 00:50:51 Lenny Rachitsky

**English:**
Okay, so it's, what did we decide here? Who's going to do what by when? So basically, action items with dates. And then, who needs to know about what we decided here? Is that how you put it?

**中文翻译:**
好，所以是：我们决定了什么？谁在什么时候做什么（基本上是带日期的行动项）？还有谁需要知道我们在这里决定的事情？是这样吗？

---

### 00:51:01 Alisa Cohn

**English:**
Yes. Who else needs to know? There's so many executive teams that I've worked with and at first, they go into their room, they have their meeting, they make their decisions and then they leave and they don't tell anyone. "I made this promise for my team that you guys need to kind of go do." Or, "We decided on a policy of some sort and we forgot to tell everybody." And again, no, absolutely no maliciousness, just that they forget or they're too busy and there's not part of the protocol and the process inside of the company that encourages and really insists that people share important information, so cascading that down.

**中文翻译:**
是的。还有谁需要知道？我合作过很多高管团队，起初他们进屋开会，做出决定，然后离开，却没告诉任何人。比如“我向我的团队承诺了你们需要去做的事情”，或者“我们决定了某种政策，却忘了告诉大家”。再说一次，这绝对没有恶意，只是他们忘了或者太忙了，而且公司内部缺乏一种鼓励并坚持让人们分享重要信息的协议和流程，也就是信息的向下传递（cascading）。

---

### 00:51:37 Alisa Cohn

**English:**
But even the first question, what did we decide here? If you really go around the room at the end of a meeting or six people in the meeting, let's say, and you say to everybody, "What did we decide here?" And they all write it down, you will get six different answers, even though we're in the same meeting. I love that it's so powerful, but also, so helpful to really raise that up, to surface that and then to figure out what to do about it.

**中文翻译:**
但即使是第一个问题，“我们在这里决定了什么？”，如果你在会议结束时真的问一圈（假设有六个人），让他们写下来，你会得到六个不同的答案，尽管你们是在同一个会议里。我喜欢这一点，它非常强大，而且对于揭示分歧并找出对策非常有帮助。

---

### 00:51:58 Lenny Rachitsky

**English:**
I love that you highlighted that. I was going to say exactly the same thing, that everyone in their head has the thought of, "Here, oh yeah. Here's what we decided." And to your point, it's often not the same. So is the advice here, is this like a template or something you fill out at the end of a meeting or is it someone's job to make sure these three things happen or how do you operationalize these three questions?

**中文翻译:**
我很高兴你强调了这一点。我正想说同样的话：每个人脑子里都觉得“噢，是的，这就是我们决定的”，但正如你所说，事实往往并非如此。那么这里的建议是，这像是一个模板或会议结束时要填写的表格吗？还是说这是某个人的职责，负责确保这三件事发生？你如何将这三个问题制度化？

---

### 00:52:19 Alisa Cohn

**English:**
I like it that it's someone's job, the person that I sort of think of as the meetings are. And typically, that's somebody who enjoys follow-up, who enjoys putting lists together and putting things into boxes and whatnot, and there's usually someone like that on the team. And so then it's kind of exciting for them to be the follower upper. But one way or the other, so you could use a template. I think that actually baking it in as a ritual to the meeting, because the other thing about meetings is that we never have enough time. We go right to the end and we don't leave the five or 10 minutes at the end to make sure that we ask these three questions and make sure that we have an understanding of what the follow through is on these meetings.

**中文翻译:**
我倾向于把它作为某个人的职责，我称之为“会议沙皇”。通常是那些喜欢跟进、喜欢列清单、喜欢把事情归类的人，团队里通常都有这样的人。对他们来说，担任跟进者是件挺兴奋的事。不管怎样，你可以使用模板。我认为实际上应该把它作为会议的一种仪式固定下来。因为会议的另一个问题是我们总觉得时间不够，总是开到最后一秒，而不留出最后 5 到 10 分钟来确保问这三个问题，并确保大家对会议的后续执行达成共识。

---

### 00:52:57 Lenny Rachitsky

**English:**
What I'm imagining is, say it's the product managers. Put this doc on the screen in the meeting as the meeting's ending and just have it filled out basically, and just confirm, "Does this look good to everyone?"

**中文翻译:**
我想象的场景是，比如产品经理，在会议快结束时把这个文档投到屏幕上，基本上填好，然后确认：“大家觉得这样可以吗？”

---

### 00:53:09 Alisa Cohn

**English:**
Love that. That's a great way to do it. By the way, with... Well, I just would say what's interesting about that is that if we ask people what did we decide here, I think there's value in just asking that question in particular because somebody might say, "We decided," I don't know, "Something." And other people would say, "No, we didn't. But that's actually a good idea. It sort of crystallizes what we did talk about in a more comprehensive way." I think there's value in raising the differences and I think there's value in stitching those together. So just putting it up on the board is good, especially if you're running short of time. I worry that somebody might not weigh in and say, "Actually, I have a very different point of view of what we decided here." So maybe it's also about building the culture to break in and say, "No, that's not what I see. Let's spend some time on that."

**中文翻译:**
太棒了，这是一个很好的方法。顺便说一下，有趣的是，如果我们问大家“我们决定了什么”，我认为问这个问题本身就有价值。因为有人可能会说“我们决定了某某事”，而其他人会说“不，我们没决定，但那确实是个好主意”。这能以更全面的方式使我们讨论的内容具体化。我认为揭示分歧是有价值的，将这些想法缝合在一起也是有价值的。所以把内容投到屏幕上很好，尤其是时间紧迫时。但我担心有人可能不会插话并说：“实际上，我对我们的决定有完全不同的看法。”所以，这可能也涉及到建立一种文化，鼓励人们打断并说：“不，我看到的不是这样，让我们花点时间讨论一下。”

---

### 00:54:03 Lenny Rachitsky

**English:**
Let's actually spend more time on this because this is really, I think, really this specific detail I think could be really powerful if you do it right. So say you're the PM in the meeting, who do you ask? Do you say to the room, "What did we decide here?" Or do you look at the most senior person? Otherwise, it feels like it could just lead to a whole discussion the last couple of minutes, which I guess could be valuable, but who do you point this question to?

**中文翻译:**
我们确实应该多花点时间讨论这个，因为我认为如果处理得当，这个细节会非常强大。假设你是会议中的 PM，你会问谁？你会对着全屋人问“我们决定了什么”吗？还是你会看着职位最高的人？否则，感觉最后几分钟可能会引发一整场讨论，虽然这可能有价值，但你这个问题的目标是谁？

---

### 00:54:24 Alisa Cohn

**English:**
Yeah. So I picture this for let's say, a six-person executive team meeting, which means everyone go around quickly and say, "What did we decide here?" Now, if you're in a meeting with a large executive team, which I do work with sometimes or non-executive team, like a group of some sort, then you probably want to get a few people just to... I would just even say as a facilitator, two or three people, "Okay, two or three people, what do we decide here?" And if you can kind of get common, great. That's fantastic.

**中文翻译:**
是的。我设想的是，比如一个六人的高管团队会议，这意味着大家快速轮流说一下：“我们在这里决定了什么？”如果你是在一个大型高管团队会议中（我有时也会遇到），或者是非高管团队，比如某种小组，那么你可能只想找几个人。作为主持人，我会说：“好，请两三个人说一下，我们在这里决定了什么？”如果你能得到共识，那就太棒了。

---

### 00:54:52 Lenny Rachitsky

**English:**
Got it. Okay. So if it's a small meeting, go around the room and everyone just shares, here's what we decided here. And they could just be like, "Yep, he's got it or she's got it." Awesome. Okay. This is great. So the advice here is, next time you have a meeting, especially an exec meeting, just at the end of the meeting, you, the listener of this podcast, just ask, "Okay, everyone. Let's just make sure we're on the same page. What did you decide here? Who needs to do what by when?" And then everyone chimes in and you're writing this in this doc, and then what else? Who needs to know about what we decided here?

**中文翻译:**
明白了。好。所以如果是小型会议，就轮流发言，每个人分享一下“我们在这里决定了什么”。他们也可以说：“是的，他/她说的没错。”太棒了。这建议很好：下次开会时，尤其是高管会议，在会议结束时，你（本播客的听众）只需问：“好，各位，让我们确保大家达成共识。我们在这里决定了什么？谁在什么时候做什么？”然后大家各抒己见，你把这些写进文档，接着问：“还有谁需要知道我们在这里决定的事情？”

---

### 00:55:22 Alisa Cohn

**English:**
Yeah. Lenny, I love that because also, do you have to be the leader of the meeting to do that? No. You could just be the person in the meeting and just chime in and just start it yourself. And if you do that and everyone kind of picks it up, it can become a ritual just by virtue of your own agency. So I love that you just encouraged everyone to do that.

**中文翻译:**
是的。Lenny，我喜欢这个建议，因为你并不一定要是会议的领导者才能这样做。你只需是参会者，就可以主动发起。如果你这样做，而大家都跟进，这就能凭借你个人的主观能动性变成一种仪式。所以我很高兴你鼓励大家这样做。

---

### 00:55:42 Lenny Rachitsky

**English:**
And this is how you become a leader, is you just start doing these things and people are like, "Oh, Alisa is so helpful. She's just on top of it. Every time she's in a meeting, the meetings go better. We get things done." So I think just doing the thing that is useful to everyone is how you move up.

**中文翻译:**
这就是你成为领导者的方式：你开始做这些事，人们会觉得：“噢，Alisa 太有帮助了，她总是能掌控全局。每次她在场，会议效率都更高，事情都能办成。”所以我认为，做对每个人都有用的事就是你晋升的方式。

---

### 00:55:56 Alisa Cohn

**English:**
Exactly.

**中文翻译:**
没错。

---

### 00:55:57 Lenny Rachitsky

**English:**
Amazing. Okay. Another topic that I know you spend a lot of time on is something you call the founder prenup. And what I love about this is, a lot of the problems that a company trickle down from the founders having their challenges with each other. And I started a company in the past and I don't think people realize how significant this decision is in your life. It's basically, you are marrying someone in a business context and you're stuck with this person for a long time and you basically came up with a prenup, which is a set of questions of just things you need to talk about to make sure you're aligned before you start this company. Is there any context around this thing before we talk through actually the questions that you recommend people talk through?

**中文翻译:**
太棒了。好，另一个我知道你花了很多时间研究的话题是你称之为“创始人婚前协议”（founder prenup）的东西。我喜欢这一点的原因是，公司的很多问题其实都源于创始人之间的矛盾。我以前创办过公司，我认为人们没有意识到这个决定对你的人生有多么重大。基本上，你是在商业语境下与某人“结婚”，并且要和这个人长期捆绑在一起。你总结了一套“婚前协议”，即一系列在创办公司前必须讨论的问题，以确保你们步调一致。在我们讨论具体问题之前，关于这个协议有什么背景信息吗？

---

### 00:56:41 Alisa Cohn

**English:**
Well, I just want to reiterate what you just said. Exactly right. And it turns out that according to Noam, Noam Wasserstein, 65% of startups fail because of conflict with founders or the founding team. So it's really essential to get this right, and I agree that people step into this relationship with a lot less care than they should. And bad things can happen because you haven't done the work of getting to know each other before you decide to co-found.

**中文翻译:**
我想重申你刚才说的话，完全正确。事实证明，根据 Noam Wasserstein 的研究，65% 的初创公司失败是因为创始人或创始团队之间的冲突。所以，处理好这一点至关重要。我同意人们在进入这种关系时往往不够谨慎。如果你在决定共同创业前没有做好互相了解的工作，糟糕的事情就会发生。

---

### 00:57:12 Lenny Rachitsky

**English:**
Yeah. It's so easy just to like, "Yeah, I'll start a company. We have this cool idea. Let's just do it. It's going to be so awesome." And then you don't realize how much you're committing to and how often things don't work out because of that quick decision. And oftentimes, it's like friends and then it becomes even more challenging because I want to be friends, but we're in business together. So yeah. Let's talk about what you recommend folks talk through as much as we can on this podcast.

**中文翻译:**
是的。人们很容易觉得：“好啊，我来开个公司。我们有个很酷的想法，干吧，肯定会很棒。”但你没意识到你投入了多少，也没意识到有多少事情会因为那个草率的决定而搞砸。而且通常合伙人是朋友，这会让事情更具挑战性，因为我想和你是朋友，但我们又是生意伙伴。所以，让我们尽可能多地聊聊你建议大家讨论的内容。

---

### 00:57:36 Alisa Cohn

**English:**
So I do have kind of an extensive questionnaire, so we just touch on a few things, but one thing I think first and foremost is, what are your values? And I think it's really essential to do some sort of values clarification exercise. You can find a ton of them online. You can find a list of values and just pull out your core values and just compare them with each other because when you are aligned, it's great. Or when you're adjacent, it's also great.

**中文翻译:**
我确实有一份很长的问卷，所以我们只挑几点来说。我认为首要的一点是：你的价值观是什么？我认为进行某种价值观澄清练习至关重要。你可以在网上找到很多这类练习。你可以找一份价值观清单，挑出你的核心价值观，然后互相比较。如果你们步调一致，那太好了；如果你们的价值观互补，那也很好。

---

### 00:58:01 Alisa Cohn

**English:**
I might care a lot about excellence, Lenny, you might care a lot about learning. Fantastic. Those are great values that we can kind of, go together. I might care about excellence and you might care about work-life balance. Wow, let's talk about that because I think it's going to be really important as we go through our startup journey that we understand both of us, what does work-life balance mean and what does excellence mean? Because those two things can at times be at odds with each other, just as kind of an example.

**中文翻译:**
Lenny，我可能非常看重“卓越”，而你可能非常看重“学习”。太棒了，这些价值观可以很好地融合。但如果我非常看重“卓越”，而你非常看重“工作与生活的平衡”，哇，那我们就得谈谈了。因为我认为在创业过程中，我们双方都理解“平衡”意味着什么、“卓越”意味着什么是非常重要的。因为这两件事有时会发生冲突，这只是个例子。

---

### 00:58:30 Alisa Cohn

**English:**
So talking through those core values in advance and updating them regularly, even as you go down the path together is so essential. Just so you know where the other person's coming from. Because the other problem is, someone acts in a certain way, you don't know them that well maybe, or maybe you've known them as an eighth grader. A lot of founders do know each other from their youth and they've matured into different kinds of people. And so you think they're acting strangely, but actually, they're acting in accordance with their values. And so getting a handle on that upfront can solve, I would just say, solve a lot of problems before they start.

**中文翻译:**
所以提前讨论这些核心价值观，并在共同前进的过程中定期更新，是至关重要的。这样你才能知道对方的出发点。另一个问题是，某人的行为方式可能让你觉得奇怪，也许是因为你不够了解他们，或者你对他们的印象还停留在初二时期。很多创始人从小就认识，但成年后变成了不同的人。你可能觉得他们行为怪异，但实际上他们只是在遵循自己的价值观。所以提前掌握这些可以解决——或者说在问题发生前就消除很多麻烦。

---

### 00:59:08 Lenny Rachitsky

**English:**
So signs that your values don't align. It's basically you both can't be true is almost the way I think about it as we talk. It's hard to be the excellent, focus on excellence and also not work long hours, which it's possible, but it's hard. Those are challenging and worth the conversation.

**中文翻译:**
所以价值观不一致的迹象，基本上就是“两者不可兼得”。就像我们刚才聊的，很难既追求极致的卓越，又不长时间工作。虽然有可能，但很难。这些都是具有挑战性且值得讨论的话题。

---

### 00:59:26 Alisa Cohn

**English:**
Yeah, worth the conversation because in fact, as you say that, I'm like, "Well, I guess you can do that. Right. You can do that." And so therefore, that's where the conversation has to figure out how you're going to marry these two values, which might be at odds or might be aligned, but let's talk through what work-life balance means to you and let's talk through what excellence means to me, and let's see if we can have a meeting of the minds about it or at least I know where you stand.

**中文翻译:**
是的，值得讨论。事实上，当你这么说时，我想：“嗯，我想是可以做到的。对，你可以做到。”因此，对话必须弄清楚如何结合这两个价值观，它们可能冲突，也可能一致。但让我们谈谈“平衡”对你意味着什么，“卓越”对我意味着什么，看看我们能否达成共识，或者至少让我知道你的立场。

---

### 00:59:50 Alisa Cohn

**English:**
One of the founders I worked with, he would text or Slack his co-founder on weekends and the co-founder wouldn't respond. And that was extremely frustrating to the person, to the co-founder I was talking to. And it turned out, after they finally addressed it, it really was about wanting to have some downtime and some, quote unquote, "Balance." Nothing wrong with that, but because they didn't talk about it, both sides made [inaudible 01:00:20] big assumption about it and then it caused this conflict that didn't have to happen if they'd had the conversation in advance.

**中文翻译:**
我合作过的一位创始人，他会在周末给合伙人发短信或 Slack，但对方不回。这让我正在交谈的那位创始人感到非常沮丧。结果发现，在他们最终谈开后，对方其实只是想要一些休息时间，也就是所谓的“平衡”。这本身没错，但因为他们没谈过，双方都做了很大的假设，从而导致了这场本可以避免的冲突。

---

### 01:00:25 Lenny Rachitsky

**English:**
Comes back to where we started of having these conversations is necessary and almost helps the other person because this small issue could become a huge issue over time, if you just start assuming and it keeps happening and it keeps scratching and scratching at you. And letting that person's [inaudible 01:00:45] is screwed up because you're, "I can't do this with you anymore." Right? So it's just another reminder of how it's good for the other person for you to engage in a difficult conversation.

**中文翻译:**
这又回到了我们开始时说的：进行这些对话是必要的，而且几乎是在帮助对方。因为如果你只是假设，而事情不断发生，不断地折磨你，这个小问题随着时间的推移会变成大问题。最后你可能会爆发：“我没法再和你共事了。”对吧？所以这再次提醒我们，参与艰难对话对对方也是有好处的。

---

### 01:00:54 Alisa Cohn

**English:**
Yes, very true.

**中文翻译:**
是的，非常正确。

---

### 01:00:55 Lenny Rachitsky

**English:**
Okay, what else? So values. By the way, is there a values framework you most love that you can point people to or there just a bunch and don't worry too much about which one you go [inaudible 01:01:05]?

**中文翻译:**
好，还有什么？价值观。顺便问一下，有没有你最推崇的价值观框架可以推荐给大家？还是说有很多种，不用太纠结选哪一个？

---

### 01:01:04 Alisa Cohn

**English:**
I mean, the one I use is super simple, which is on the thing called the internet. There's a lot of lists of values and I think when you see a list of values, you can pull out the ones that are most meaningful to you, and that's a very simple and helpful and free tool.

**中文翻译:**
我用的那个非常简单，就在互联网上。有很多价值观清单，当你看到清单时，你可以挑出对你最有意义的那些。这是一个非常简单、有用且免费的工具。

---

### 01:01:19 Lenny Rachitsky

**English:**
Got it. So you just Google list of values, there's a PDF, and just circle the ones that are most and pick whatever small number, don't... Half of [inaudible 01:01:27]-

**中文翻译:**
明白了。所以只需谷歌搜索“价值观清单”，找个 PDF，圈出最重要的几个，选一小部分，不要选太多……

---

### 01:01:26 Alisa Cohn

**English:**
Actually, well, just to give you the process, right? It's helpful to pick 20, for example. Great. And then you winnow them down to, let's say, 10. And then you do the difficult work of winnowing them down to three to five that you feel are core to you. And that's a good exercise for everyone to do actually, every year because things can change. It also forces you to make the difficult decisions about when it comes down to it, what are the things that really are important to me? The more you know your values, the more you can operate in the world with just more clarity for yourself.

**中文翻译:**
实际上，我告诉你这个过程：比如先选 20 个，很好。然后筛选到 10 个。接着进行最难的一步，筛选到 3 到 5 个你认为最核心的。实际上，这是每个人每年都该做的练习，因为情况会变。它也迫使你做出艰难的决定：归根结底，哪些东西对我真正重要？你越了解自己的价值观，你在世界上行事就会越清晰。

---

### 01:01:58 Lenny Rachitsky

**English:**
Awesome. All right. So values. What else?

**中文翻译:**
太棒了。好，价值观。还有什么？

---

### 01:02:01 Alisa Cohn

**English:**
Yeah. So another one is, vision of the company. So when this company is successful, what does that look like? And what that might look like is, we're in control of our destiny and we are able to operate this business independently and we have a lot of freedom. What that might look like is a big venture outcome that we all read about. And if you are both assuming that you both think the same thing but aren't talking about it explicitly or talking about the trade-offs you need to make inherent in that, then what often happens if you have differences is they come home to roost while it's too late or when it's too late.

**中文翻译:**
是的。另一个是公司的愿景。当这家公司成功时，它是什么样子的？可能的样子是：我们掌控自己的命运，能够独立运营业务，拥有很大的自由。也可能是：我们都读到过的那种巨大的风险投资回报。如果你俩都假设对方想的一样，却没有明确讨论过，或者没有讨论过其中固有的权衡，那么一旦存在分歧，往往会在为时已晚时爆发。

---

### 01:02:40 Alisa Cohn

**English:**
So an example is the two co-founders I worked with, one of them would said to me wistfully, this is like five or six years into the company, and the company was going well, but it was challenging and they had all their growing pains and like you mentioned about Sheryl said all the chaos. And he said to me, "Gosh, I don't see why we have to grow. I just wish we could actually have fewer employees. And I used to love it when I knew everybody's name and I would just much prefer an environment where we didn't have to grow." Well, unfortunately, they were already venture backed and also, the other co-founder had a very lofty ambition for a very big company. And since they hadn't talked about that, it was way too late to even have that conversation and it was a very painful reckoning for both of them to realize they were not on the same page.

**中文翻译:**
举个例子，我合作过的两位联合创始人，其中一位在公司成立五六年、发展良好但充满挑战（就像 Sheryl 说的那些混乱）时，惆怅地对我说：“天哪，我不明白我们为什么要扩张。我真希望员工能少一点。我以前喜欢能叫出每个人的名字，我更喜欢一个不需要扩张的环境。”不幸的是，他们已经拿了风投，而且另一位创始人对建立一家大公司有着极高的抱负。因为他们从未谈论过这一点，等到意识到步调不一致时已经太晚了，这对双方来说都是一次非常痛苦的清算。

---

### 01:03:33 Lenny Rachitsky

**English:**
Totally, see the value of this one. I could totally see how people would have different goals. I imagine it also changes over time, so there's probably an element of, if something has shifted for you, you should probably also have that conversation. I don't want to build an IPO venture scale business, I just want to build something chill. So basically, a line on what is... How would you phrase that? What does winning look like to you?

**中文翻译:**
完全理解这一点的价值。我完全能想象人们会有不同的目标。我猜这也会随时间而改变，所以如果你的想法发生了变化，可能也应该进行那次谈话。比如“我不想建立一个能上市的规模化企业，我只想做点轻松的事情”。所以基本上是关于……你会怎么表达？“对你来说，获胜是什么样子的？”

---

### 01:03:52 Alisa Cohn

**English:**
Yeah, what does success look like?

**中文翻译:**
是的，“成功是什么样子的？”

---

### 01:03:54 Lenny Rachitsky

**English:**
What does success look like to you?

**中文翻译:**
“对你来说，成功是什么样子的？”

---

### 01:03:54 Alisa Cohn

**English:**
Or what's the vision for the company when it reaches its full potential?

**中文翻译:**
或者是“当公司发挥出全部潜力时，它的愿景是什么？”

---

### 01:04:01 Lenny Rachitsky

**English:**
Okay. Great. What else?

**中文翻译:**
好，太棒了。还有吗？

---

### 01:04:01 Alisa Cohn

**English:**
Another one is, it's sort of a two part question. How do you handle conflict? So how do you handle conflict? But then, you might want to ask your spouse, someone close to you, "How do I handle conflict?" Because you might think, "Oh, I handle conflict with such an enlightened person. I'm so neutral about it. I'm so great at bringing things up." But the person who's close to you might say, "You seethe until you're ready to bring something up and it's really uncomfortable in the seething period." So it just gives you a little more self-awareness about how you actually handle conflict.

**中文翻译:**
另一个问题包含两个部分：你如何处理冲突？首先问自己，然后你可能想问问你的配偶或亲近的人：“我是如何处理冲突的？”因为你可能觉得自己处理冲突非常理智、中立，非常擅长提出问题。但亲近的人可能会说：“你在开口之前会一直生闷气，那段生闷气的时间让人非常难受。”这能让你对如何处理冲突有更多的自我意识。

---

### 01:04:42 Alisa Cohn

**English:**
And that's really important because I might be the kind of person who wants to bring up conflict and talk about it immediately. The other person might be a person who totally wants to talk about the conflict but wants to let it settle first and wants to also go through their own thinking process about what's important to them and might actually feel like they've resolved it themselves without having to have a conversation with you. And if you're the person who's like, "Let's talk about it, let's talk about it, let's talk about it." And they're like, "I'm working through it myself." Now you have conflict over the conflict and it just turns into dynamic that's not necessary.

**中文翻译:**
这非常重要，因为我可能是那种想立即提出并讨论冲突的人。而另一个人可能也想谈，但想先冷静一下，想先理清自己的思路，甚至可能觉得不需要和你谈就能自己解决。如果你一直催着“谈谈吧，谈谈吧”，而对方觉得“我正在自己消化”，那么你们就会因为“如何处理冲突”而产生新的冲突，这完全没必要。

---

### 01:05:22 Lenny Rachitsky

**English:**
As you go through these questions, it's absurd to imagine people don't do this when they find a co-founder and work through stuff, and I know nobody does. The percentage of people that do this sort of work ahead of time, it's very low. And so I love that we're helping this percentage go up, but it also reminds me of just how crazy it is people don't have these conversations and how it explains why so many founder relationships don't work out. So these are awesome. What else? I know you have a whole list and we'll link to it, right? There's a PDF we can link to?

**中文翻译:**
听你讲这些问题，觉得人们在找合伙人时不先讨论这些简直不可思议，但我知道确实没人这么做。提前做这些功课的人比例非常低。所以我很高兴我们正在帮助提高这个比例。这也提醒了我，人们不进行这些对话是多么疯狂，也解释了为什么这么多创始人关系最终破裂。这些建议太棒了。还有吗？我知道你有一份完整的清单，我们会提供链接，对吧？有一个 PDF 链接吗？

---

### 01:05:22 Alisa Cohn

**English:**
Yes.

**中文翻译:**
是的。

---

### 01:05:53 Lenny Rachitsky

**English:**
With the questions or-

**中文翻译:**
包含这些问题的清单，或者……

---

### 01:05:54 Alisa Cohn

**English:**
For sure.

**中文翻译:**
当然。

---

### 01:05:55 Lenny Rachitsky

**English:**
[inaudible 01:05:55] post. Awesome. Let's do a few more.

**中文翻译:**
太棒了，我们再多聊几个。

---

### 01:05:57 Alisa Cohn

**English:**
Another one is, how do we decide when we disagree? And that is a very good thing to explore because there's actually a lot of different ways to decide when you disagree and they're all good. And if you have it sort of upfront and it's just for an ongoing discussion, but if you have it up front like when we disagree, because that's definitely going to happen, let's assume that the person who cares the most can win that argument. That would be a great way to do it. It might be, the person who's got the best perspective and the most expertise can win that argument. It might be, we'll go back and forth when we really disagree. First you win and then I win, like that, back and forth.

**中文翻译:**
另一个是：当我们产生分歧时，如何做决定？这是一个非常值得探讨的问题，因为处理分歧有很多种方式，而且都行得通。如果你提前讨论好——因为分歧肯定会发生——比如我们可以约定：谁最在意这件事，谁就赢。这是一种很好的方式。或者：谁最有远见、最专业，谁就赢。或者是：当我们真的无法达成一致时，我们轮流做主，这次听你的，下次听我的。

---

### 01:06:41 Alisa Cohn

**English:**
There's so many different ways to handle it and if you talk about it upfront, you'll be much more likely to be able to actually put that into practice when you do disagree because you will definitely disagree. There's no way around that. And that's not even a bad thing. You're smart people. You have this dynamic tension in the relationship. You bring different things to the table. You've got different perspectives. Disagreeing is normal. Working through it and having a practice and a process of working through it, will help it be a good conversation rather than this sort of sulky difficult conversation.

**中文翻译:**
处理方式有很多种，如果你提前谈好，当你真的遇到分歧时，你就更有可能付诸实践。因为分歧是必然的，无法回避。这甚至不是件坏事。你们都是聪明人，关系中存在动态张力。你们各有所长，视角不同。产生分歧很正常。通过练习和流程来解决分歧，会使之成为一次良性的对话，而不是那种生闷气的艰难对话。

---

### 01:07:12 Lenny Rachitsky

**English:**
I love it. Maybe one more?

**中文翻译:**
我喜欢这个。再来一个？

---

### 01:07:14 Alisa Cohn

**English:**
Yeah. So another one is, what kind of company culture do I think is important? People definitely don't talk about this before they found the company and they assume they're on the same page. So one founder might be, "I want to have this great company where everyone loves it and we're all loving together and working hard together. And it feels like a..." To use your word before, "It feels like a family." By the way, that's great. That's fantastic. "I want to have a get it done, results-focused culture where we're just executing the hell out of everything and that we're just focused on winning."

**中文翻译:**
好。还有一个是：我认为什么样的公司文化是重要的？人们在创办公司前绝对不会谈论这个，他们假设彼此的想法一致。一位创始人可能想：“我想要一家伟大的公司，每个人都爱这里，大家互相关爱，共同努力。感觉就像……”用你之前的词，“感觉就像一个家庭”。顺便说一下，这很好，太棒了。而另一位可能想：“我想要一种‘搞定任务’、结果导向的文化，我们要拼命执行，只关注获胜。”

---

### 01:07:52 Alisa Cohn

**English:**
By the way, those two can actually exist together. But if you're pushing in one direction without the other and your co-founder is pushing the other direction without yours, it really can feel like two different companies. And that's... When I go into a situation at one of my client sites, often I will hear from the employees, "It feels like we have two different companies and two different cultures depending on whose team you're on." And that, of course, leads to lack of coherent working together and certainly even just lack of different standards and expectations.

**中文翻译:**
顺便说一下，这两者其实可以共存。但如果你只往一个方向推，而你的合伙人只往另一个方向推，那感觉就像是两家不同的公司。当我作为教练进入客户公司时，经常听到员工说：“感觉我们有两家公司，两种文化，取决于你在谁的团队里。”这当然会导致缺乏协作连贯性，甚至导致标准和预期的混乱。

---

### 01:08:24 Lenny Rachitsky

**English:**
Awesome. Okay. To kind of start to wrap our conversation, I want to take us to a recurring segment of this podcast that I call, Fail Corner. We've talked a lot about failure at this point and just all the ways people fail. I'm curious if, in your career or life, there's a story that might be helpful for folks to hear when things didn't go great and you've failed, and if you learn something from that experience. And the reason this is something I do is I feel like people listening to this podcast, everyone's like, "Sounds so amazing, everything's always going great. They're killing it." When in reality, that's not actually how things go. So these end up being really helpful for people like, "Oh, wow. Even Alisa had a really hard time sometime." Is there a story that you could share?

**中文翻译:**
太棒了。好，在结束我们的对话之前，我想进入本播客的一个固定环节，我称之为“失败角落”（Fail Corner）。到目前为止，我们已经聊了很多关于失败的话题。我很好奇，在你的职业生涯或生活中，是否有一个故事可以分享给大家——关于事情进展不顺、你失败了的经历，以及你从中学到了什么。我做这个环节的原因是，我觉得听众可能会觉得：“听起来太棒了，一切都很顺利，他们太牛了。”但现实并非如此。所以这些故事对人们很有帮助，让他们觉得：“噢，哇，原来连 Alisa 也有过艰难时刻。”你能分享一个故事吗？

---

### 01:09:04 Alisa Cohn

**English:**
Absolutely. I mean, so many examples. I'm going to give two quick examples. One is, when I first started my coaching practice, I just kind of started and so I just did everything I could to get clients, to build a business, to build a practice, to build my brand, all the things. And I was working so hard and I think I'd had this conversation with somebody that didn't go very well. And I just thought, in my mind's eye, I thought, "Well, what will become of me?" That was my voice in my head for quite a long time, "What will become of me?" And I was living in Boston at the time. I got onto the floor, my hardwood floors in my Brookline condo, and I just balled in the fetal position. I just balled and balled and balled for an hour. It wasn't 10 minutes, it was an hour.

**中文翻译:**
当然可以，例子太多了。我快速举两个例子。第一个是，当我刚开始教练生涯时，我竭尽全力去获取客户、建立业务、打造品牌。我工作非常努力，有一次我和某人的谈话进行得很不顺利。我当时就在想：“我会变成什么样？”那是我脑子里很长一段时间的声音，“我会变成什么样？”当时我住在波士顿。我躺在布鲁克莱恩公寓的硬木地板上，蜷缩成胎儿的姿势大哭。我哭了一个小时，不是 10 分钟，是整整一个小时。

---

### 01:09:50 Alisa Cohn

**English:**
And I was so frightened and just upset. Am I going to be able to make this work? And it was a while and I got into the couch and took a little stress nap. And then I got up from my stress nap and I just started making more calls and doing more things. And that was definitely a rock bottom moment for me. And I think what I learned is, you have to literally pick yourself up from the ground and pull yourself forward. And when you keep taking action, action, action, win or lose, win or lose, you'll get where you need to go. And that turned out to be true. But in those moments, I was not thinking that was going to turn out to be true.

**中文翻译:**
我当时非常害怕和沮丧。我能成功吗？过了一会儿，我爬上沙发睡了个“压力午觉”。醒来后，我开始打更多的电话，做更多的事。那绝对是我的谷底时刻。我想我学到的是：你必须真的从地上爬起来，推着自己前进。当你不断采取行动、行动、再行动，无论输赢，你最终都会到达你想去的地方。事实证明确实如此，但在那个时刻，我并不觉得这会成真。

---

### 01:10:32 Lenny Rachitsky

**English:**
Wow. Amazing story. I imagine many people feel those moments and it's empowering to hear that it can all turn out really well, even when you're lying in the floor crying for an hour. An hour is a long time to cry on the floor.

**中文翻译:**
哇，很棒的故事。我想很多人都有过那样的时刻，听到即使在地板上哭了一个小时，最后也能有好的结果，这很给人力量。在地板上哭一个小时确实挺久的。

---

### 01:10:45 Alisa Cohn

**English:**
It is a long time to cry. It really... I thought about it because most people just cry for 10 or 15 minutes. I was crying for an hour. I'm positive. Yeah.

**中文翻译:**
确实很久。我后来想过，大多数人只哭 10 到 15 分钟，但我肯定我哭了一个小时。是的。

---

### 01:10:52 Lenny Rachitsky

**English:**
Great story. You said you had another story.

**中文翻译:**
很棒的故事。你说你还有另一个故事。

---

### 01:10:56 Alisa Cohn

**English:**
Yeah. I'll tell you a second story, which is more focused on actually my work life. So one thing that I do is I do coaching of course and I do off sites. And this was early, early days of my coaching career and I was doing this off site and it wasn't going well. And I was debriefing with my client during the breaks and at one point she said something like, "I just think we should end this offsite. I just think we should just decide it's over and it's not working." And I felt horrible, obviously, humiliated, certainly, and just like that's a failure. That's like, "Oh, fail." And I know that what I took away from it was that I can improve my skills in every aspect of running an offsite.

**中文翻译:**
是的。第二个故事更侧重于我的职业生活。我做教练，也主持团建（offsite）。那是在我教练生涯的早期，我主持的一次团建进行得不顺利。休息期间我和客户沟通，她突然说：“我觉得我们应该结束这次团建。我觉得它没起作用，就到此为止吧。”我当时感觉糟透了，显然很羞愧，觉得这就是彻底的失败。但我从中意识到，我可以在主持团建的各个方面提升自己的技能。

---

### 01:11:40 Alisa Cohn

**English:**
So getting aligned with the client in advance, making sure that I had the right activities getting us to our goal, being very goal-oriented and focused, and making sure that I had kind of understood the rhythm of what it takes to bring people together. So I took some training on that. I worked my mentor on that, and I got so great at offsites after that experience. I'll tell you that was a real low because in the moment, in that moment, I'm not thinking, "I'm going to get great at offsites." In that moment I'm thinking, "Oh, my God. I'm going to get... What will become of me?" But I turned it into, in my mind's eye, or I should say, I turned it into the ability to build my skills. And I just want to tell everybody, even at your lowest moments, anything that you're learning from that, can then be turned into fuel to build your skills to get great at the thing that you're not great at.

**中文翻译:**
比如提前与客户达成一致，确保有合适的活动来达成目标，保持目标导向和专注，并确保我理解了凝聚人心所需的节奏。于是我参加了相关培训，向导师请教。在那次经历之后，我变得非常擅长主持团建。我得说那真的是个低谷，因为在那个时刻，我没想过“我会变得擅长这个”，我想的是“天哪，我会变成什么样？”但我把它转化成了提升技能的动力。我想告诉大家，即使在最低谷的时刻，你从中写到的任何东西都可以转化为动力，帮你提升技能，让你在原本不擅长的事情上变得出色。

---

### 01:12:31 Lenny Rachitsky

**English:**
What I also love about this is there's this feeling of imposter syndrome, is specifically this fear that I do something wrong and it'll all crumble and everyone will see I suck and I never... I don't know anything and everyone will see it. And I love both these stories are like, it doesn't go well and doesn't crumble. You build from there. And no one's like, "Oh, Alisa's terrible forever." No, it's like move on to the next thing. And then you use that as fuel to become really good at this thing that didn't go great.

**中文翻译:**
我也很喜欢这一点：有一种“冒充者综合征”的感觉，特别是那种担心自己做错事后一切都会崩塌、大家都会发现我很烂、我其实一窍不通的恐惧。我喜欢这两个故事的原因是，事情进展不顺，但并没有崩塌。你以此为基础继续构建。没人会觉得“噢，Alisa 永远都很差劲”。不，大家会继续前进。然后你把这作为动力，在你做得不好的事情上变得非常优秀。

---

### 01:12:57 Alisa Cohn

**English:**
Yeah, that's really well said.

**中文翻译:**
是的，说得太好了。

---

### 01:13:00 Lenny Rachitsky

**English:**
Amazing. Alisa, we covered a lot of stuff. Is there anything that you were hoping to cover or you think might be useful for folks to hear before we move to our very exciting lightning round?

**中文翻译:**
太棒了。Alisa，我们聊了很多内容。在进入令人兴奋的闪电问答环节之前，还有什么你希望讨论或者觉得对大家有用的吗？

---

### 01:13:10 Alisa Cohn

**English:**
The only last thing I want to talk about, just sort of circling back to your role as a leader, I was one time working with the CEO who was handling the fact that this launch was not going well, as in the launch wasn't happening. [inaudible 01:13:25] foot off, foot off, foot off. And his point of view was, you need to have patience with it as it goes. And my point of view is, because I've talked to a lot of the people around, was that there was a massive process problem going on that he was not kind of touching into and really investigating because the product manager wasn't experienced, was kind of hiding it because he knew he didn't have the skills, was fighting with engineering, it just wasn't working.

**中文翻译:**
最后我想聊的一点是，回到领导者的角色。我曾与一位 CEO 合作，他当时面临产品发布进展不顺的问题，实际上是发布根本没发生。他的观点是：“我们需要保持耐心，顺其自然。”而我的观点（因为我与周围很多人聊过）是，存在严重的流程问题，而他并没有深入调查。因为那个产品经理没有经验，因为知道自己能力不足而试图掩盖问题，还和工程部门吵架，事情根本行不通。

---

### 01:13:53 Alisa Cohn

**English:**
And when the CEO was telling me, and we really had a long discussion about this where I kind of enlightened him about some of the issues that he needed to get involved and fix, he kept thinking, "I need to have patience." So what I want to say to everybody is, sometimes you need to have patience and sometimes you need to look at the process. And I think you, as the leader, need to have the wisdom to know the difference, but also your finger on the pulse to recognize, is this an issue with patience or an issue with process?

**中文翻译:**
当那位 CEO 和我交谈时，我们进行了深入讨论，我启发他意识到有些问题需要他介入并解决，但他一直觉得“我需要保持耐心”。所以我想告诉大家：有时你需要耐心，但有时你需要审视流程。我认为作为领导者，你需要有智慧去分辨两者的区别，同时也要敏锐地察觉：这到底是耐心的问题，还是流程的问题？

---

### 01:14:22 Lenny Rachitsky

**English:**
I guess, is there a sign that you're like, it's probably a process thing and you're just ignoring a glaring problem that everyone else sees?

**中文翻译:**
我想问，有没有什么迹象表明这可能是一个流程问题，而你只是在忽视一个所有人都看到的显而易见的问题？

---

### 01:14:30 Alisa Cohn

**English:**
I think the sign is when, if you search your mind, you don't really know how this thing is going to come together. There's no plan in your mind. You haven't touched in with people or talked to people about what's going on. You kind of hear this uncomfortable silence about it. Those are symptoms that you just need to dive deeper and just be a little more in touch with what's going on and talk to some folks and look at some data. And by the way, it might not be a massive process problem. It might just be one little thing that needs to get unstuck but you, as the leader, need to recognize that and figure out a way to make that unstuck. And if there's, of course, a big problem that needs to somehow be just surfaced.

**中文翻译:**
我认为迹象在于：如果你仔细想想，你其实并不知道这件事最终会如何达成。你脑子里没有计划。你没有和相关人员沟通，没有了解进度。你感觉到一种令人不安的沉默。这些症状表明你需要深入调查，多了解情况，找人谈谈，看看数据。顺便说一下，这可能不是一个巨大的流程问题，可能只是一个小环节卡住了，但你作为领导者需要识别出来并想办法解决。当然，如果是一个大问题，也需要想办法让它浮出水面。

---

### 01:15:09 Lenny Rachitsky

**English:**
So if there's this hope this'll work out versus I see a path to this working out, it's probably a problem. Awesome.

**中文翻译:**
所以，如果只是“希望这能行”而不是“我看到了可行的路径”，那可能就是出问题了。太棒了。

---

### 01:15:16 Alisa Cohn

**English:**
Yeah, well said.

**中文翻译:**
是的，说得好。

---

### 01:15:17 Lenny Rachitsky

**English:**
Is there anything else that you wanted to share or touch on that you think might be helpful?

**中文翻译:**
还有什么你想分享或提及的、觉得有帮助的内容吗？

---

### 01:15:21 Alisa Cohn

**English:**
We talked a little about the co-founders prenup, which I think people would think, "Well, I'm not a co-founder, I don't need that." I just want to invite everyone to also think about a different tool that I have, which is called the Personal Operating Manual. And it helps prompt you to talk about working style together because you may not be co-founders, of course, but you're working on a team with a bunch of people and they all have their different working style.

**中文翻译:**
我们聊了创始人婚前协议，可能有人会想：“我又不是创始人，我不需要那个。”我想邀请大家思考我的另一个工具，叫做“个人操作手册”（Personal Operating Manual）。它能引导大家讨论彼此的工作风格。虽然你们可能不是联合创始人，但你在一个团队中工作，每个人都有不同的工作风格。

---

### 01:15:42 Alisa Cohn

**English:**
So it's kinds of questions like, what communication style do you like the best? How do you like to work? Do you like large uninterrupted blocks? Do you like meetings here and there? When I'm trying to get a hold of you for something important, what's the best way to do that? What is one of your pet peeves or some of your pet peeves? How can I get a gold star with you? Also, this is my favorite. What's your delegation style?

**中文翻译:**
它包含这类问题：你最喜欢什么样的沟通方式？你喜欢怎样工作？你喜欢大块不被打断的时间，还是喜欢穿插会议？当我为了重要事情找你时，最好的方式是什么？你最讨厌什么（pet peeves）？我怎么做才能在你这里得到“金星”表扬？还有我最喜欢的：你的授权风格是什么？

---

### 01:16:10 Alisa Cohn

**English:**
Do you want me to check in with you regularly, like once a week as I'm working down the path of a project? Or do you want me to just let you know when it's done and just tell you at the end that it's been complete? So lots of different ways people assume other people work because it's like your style, but actually it's just your style. So those kinds of conversations can be great for working together and also be a great team activity.

**中文翻译:**
你希望我在项目进行过程中定期（比如每周一次）向你汇报吗？还是希望我只在完成后告诉你？人们往往假设别人的工作方式和自己一样，但其实那只是你个人的风格。所以这类对话对于团队协作非常有益，也是很好的团队活动。

---

### 01:16:34 Lenny Rachitsky

**English:**
So this kind of what goes into these READMEs people put together, here's how to-

**中文翻译:**
这就像是人们写的“自述文件”（README），关于如何……

---

### 01:16:37 Alisa Cohn

**English:**
Yes.

**中文翻译:**
是的。

---

### 01:16:37 Lenny Rachitsky

**English:**
... work with me. I really love the gold star concept because I feel like people want to know how do I be super awesome? How do I be really successful working for you? And I like that visual of the gold star and the pet peeves. I feel like a lot of people will identify that. What are my pet peeves so that people don't do these things because they don't know, right? They don't know until you tell them.

**中文翻译:**
……与我共事。我非常喜欢“金星”这个概念，因为我觉得人们想知道“我如何才能表现得超级棒？我如何才能在为你工作时获得成功？”我也喜欢“金星”和“雷区”（pet peeves）这种形象的说法。我觉得很多人会有共鸣。我的雷区是什么，这样大家就不会因为不知道而踩雷。你不说，没人会知道。

---

### 01:16:55 Alisa Cohn

**English:**
Nobody knows what's your operating style until you tell them. And the more you can showcase, the more everybody will be able to do it right for you and you'll be able to do it right for them. And then you'll be able to have better workplace harmony and save your conflict with things that are really important. Not just because like, "Oh, you didn't text me when I wanted you to text me."

**中文翻译:**
你不说，没人知道你的操作风格。你展示得越多，大家就越能以正确的方式对待你，你也能以正确的方式对待他们。这样你们就能拥有更好的职场和谐，把冲突留给真正重要的事情，而不是因为“噢，你没在我希望的时候给我发短信”这种小事。

---

### 01:17:13 Lenny Rachitsky

**English:**
Being clear. What do you know? Is there anything else that you think might be helpful to share before we get to a very exciting lightning round?

**中文翻译:**
保持清晰。还有什么你觉得在进入令人兴奋的闪电问答前值得分享的吗？

---

### 01:17:20 Alisa Cohn

**English:**
No, just that.

**中文翻译:**
没有了，就这些。

---

### 01:17:21 Lenny Rachitsky

**English:**
Well, with that, Alisa, we reached our very exciting lightning round. Are you ready?

**中文翻译:**
好，Alisa，我们进入了令人兴奋的闪电问答环节。准备好了吗？

---

### 01:17:24 Alisa Cohn

**English:**
I can't wait. I'm ready.

**中文翻译:**
迫不及待，准备好了。

---

### 01:17:26 Lenny Rachitsky

**English:**
Here we go. First question, are there two or three books that you find yourself most recommending to other people?

**中文翻译:**
开始。第一个问题：有没有两三本你经常向别人推荐的书？

---

### 01:17:33 Alisa Cohn

**English:**
So we already talked about Kim Scott, the wonderful, amazing Kim Scott and her book, Radical Candor, is one I recommend a lot to people. It's fantastic. Working Backwards by gosh, Colin Bryar and Bill something, is about sort of the Amazon way of working backwards from the customer. Super geeky and tactical. I love it. I slurp it up like Harry Potter. It's so good. And I definitely recommend to my clients about Amazon's Management Science. And the third is Walt Disney by Neil Gabler because it really shows how Walt Disney, sort of it's everything about his youth and how he turned into a very bad entrepreneur and ultimately into a fantastic inventive entrepreneur. And it shows all the origins of how he invented these different pieces that now make up the Walt Disney Company.

**中文翻译:**
我们已经提到了 Kim Scott，了不起的 Kim Scott，她的《彻底坦率》（Radical Candor）是我经常推荐的，非常棒。第二本是 Colin Bryar 和 Bill Carr 合著的《逆向工作法》（Working Backwards），讲的是亚马逊从客户出发逆向推导的工作方式。非常硬核且具战术性，我非常喜欢，读起来像读《哈利·波特》一样过瘾。我肯定会向客户推荐亚马逊的管理科学。第三本是 Neil Gabler 写的《华特·迪士尼》（Walt Disney），它展示了迪士尼的青少年时期，以及他如何从一个糟糕的企业家转变为一个伟大的、充满创造力的企业家。它展示了构成现在迪士尼公司的各个部分的起源。

---

### 01:18:26 Lenny Rachitsky

**English:**
The first two recommendations we've had on the podcast, Kim Scott and Bill Carr, is the other-

**中文翻译:**
前两个推荐我们播客都请过，Kim Scott 和 Bill Carr……

---

### 01:18:29 Alisa Cohn

**English:**
Bill Carr.

**中文翻译:**
Bill Carr。

---

### 01:18:30 Lenny Rachitsky

**English:**
... co-author. He's been on the podcast and people love that episode. I haven't had Walt Disney on. I got to work on that.

**中文翻译:**
……另一位作者。他上过播客，大家很喜欢那一集。我还没请过华特·迪士尼，我得努力一下（开玩笑）。

---

### 01:18:37 Alisa Cohn

**English:**
Or the writer, Neil Gabler

**中文翻译:**
或者是作者 Neil Gabler。

---

### 01:18:38 Lenny Rachitsky

**English:**
Or the writer. Yeah, yeah. Good tip. Okay, next question. Is there a favorite recent movie or TV show you really enjoy?

**中文翻译:**
或者是作者。是的。好建议。好，下一个问题：最近有没有你非常喜欢的电影或电视剧？

---

### 01:18:44 Alisa Cohn

**English:**
Yeah, I enjoyed Inside Out 2. I thought it was fantastic, the idea [inaudible 01:18:49].

**中文翻译:**
是的，我喜欢《头脑特工队 2》（Inside Out 2）。我觉得那个创意非常棒。

---

### 01:18:48 Lenny Rachitsky

**English:**
I could see why you love it. I feel like it's for all coaches in the world.

**中文翻译:**
我能理解你为什么喜欢它。我觉得那是拍给全世界所有教练看的。

---

### 01:18:51 Alisa Cohn

**English:**
Totally. Just the idea that like, oh yeah, we're all this complex stew of emotions and it's okay.

**中文翻译:**
完全正确。就是那种“我们都是各种复杂情绪的混合体，这没关系”的想法。

---

### 01:18:56 Lenny Rachitsky

**English:**
Mm-hmm. I also love that movie. Next question. Do you have a favorite product you recently discovered that you really love?

**中文翻译:**
嗯，我也喜欢那部电影。下一个问题：你最近有没有发现什么非常喜欢的产品？

---

### 01:19:03 Alisa Cohn

**English:**
Yes, the Ninja Creami. So good.

**中文翻译:**
有，Ninja Creami（冰淇淋机）。太好用了。

---

### 01:19:07 Lenny Rachitsky

**English:**
Say more.

**中文翻译:**
展开说说。

---

### 01:19:09 Alisa Cohn

**English:**
The Ninja Creami turns anything into ice cream. So you can actually make ice cream. Good, God bless. But I take my protein shake, which is okay, and turn it into ice cream, which is delicious. And it takes 10 minutes and very little prep, and it's simple to use and it works as expected, which so many things do not. The Ninja Creami, go get it.

**中文翻译:**
Ninja Creami 能把任何东西变成冰淇淋。你可以真的做冰淇淋。但我会把我的蛋白粉奶昔（味道一般）变成冰淇淋（味道极佳）。只需要 10 分钟，几乎不需要准备，使用简单，而且效果完全符合预期——现在很多东西都做不到这一点。Ninja Creami，去买吧。

---

### 01:19:28 Lenny Rachitsky

**English:**
That's the first for the Ninja Creami. And I love, the holidays are coming around, so this is going to be good for people. Do you have a favorite life motto that you often come back to you find useful in work or in life?

**中文翻译:**
这是第一次有人推荐 Ninja Creami。我很喜欢，假期快到了，这对大家很有用。你有没有什么经常想起的、觉得在工作或生活中很有用的座右铭？

---

### 01:19:41 Alisa Cohn

**English:**
This quote by Joseph Campbell animates my life, which is, "If you can see your path all the way through to the end, you are following someone else's path. Your path only becomes clear moment by moment as each foot hits the ground."

**中文翻译:**
约瑟夫·坎贝尔（Joseph Campbell）的这句话激励着我的生活：“如果你能一眼看到道路的尽头，那么你走的是别人的路。你的路只有在你的脚踏上地面的那一刻，才会一步步变得清晰。”

---

### 01:19:57 Lenny Rachitsky

**English:**
Wow, that's so good. It's so empowering because it helps you realize if you don't see where it's all going, that's normal and that's good. Wow. Great one, good one. I need to do something with all these mottos. They're so good. I need to create a poster or something.

**中文翻译:**
哇，太棒了。这非常给人力量，因为它让你意识到，如果你看不清未来的走向，那是正常的，也是好事。哇，太经典了。我得把这些座右铭收集起来，它们太棒了，我得做个海报之类的。

---

### 01:20:14 Alisa Cohn

**English:**
That's a great idea. Or your newsletter.

**中文翻译:**
好主意。或者放进你的时事通讯（newsletter）里。

---

### 01:20:16 Lenny Rachitsky

**English:**
Here we go.

**中文翻译:**
这就安排。

---

### 01:20:16 Alisa Cohn

**English:**
Send them out.

**中文翻译:**
发出去。

---

### 01:20:18 Lenny Rachitsky

**English:**
Yeah, that's the easy path. Okay. Last question. So I'm curious, and not to create more competition for you, but I feel like a lot of people think about becoming a coach of some kind, like a product coach, exec coach. If someone is thinking about going down that path, is there one piece of advice you could share to help them pursue this path, even explore if it's right for them?

**中文翻译:**
是的，那是条捷径。好，最后一个问题。我很好奇——不是为了给你增加竞争对手——我觉得很多人都在考虑成为某种教练，比如产品教练、高管教练。如果有人想走这条路，或者想探索这是否适合自己，你有什么建议可以分享吗？

---

### 01:20:38 Alisa Cohn

**English:**
If you think you want to become a coach and you immediately want to build up your coaching skills, listen to people more deeply and ask deeper questions, not just respond to what they just said, but why do you think that? Or where is that coming from? And you will see if you enjoy that process of really going deeper with people. I think that would be helpful for everyone to do. But certainly if you want to become a coach, I think that's essential to be able to get really beneath the surface.

**中文翻译:**
如果你想成为教练并想立即提升教练技能，那就更深入地倾听，问更深层次的问题。不要只是回应他们刚才说的话，而是问“你为什么那样想？”或者“那个想法是从哪儿来的？”你会发现自己是否享受这种与人深入交流的过程。我认为这对每个人都有好处，但如果你想成为教练，能够深入表象之下是必不可少的。

---

### 01:21:13 Lenny Rachitsky

**English:**
I love how your energy just changed into coaching mode when you said that. I love that. That was such an interesting thing to see and that was great advice. That's easier said than done. And it's interesting, you could tell people are so good at that specific skill versus not. And so I love that that's the thing to work on, is ask better questions, think deeper about the person and what they're coming from. Alisa, this was incredible. Two final questions. Where can folks find you if they want to reach out, maybe work with you, what kind of people do you work with in case people are interested in that, and finally, how can listeners be useful to you?

**中文翻译:**
我喜欢你刚才说话时瞬间切换到“教练模式”的样子。太棒了，非常有意思，建议也很棒。这说起来容易做起来难。有趣的是，你能看出有些人非常擅长这项技能，而有些人则不然。所以我很喜欢这个切入点：问更好的问题，深入思考对方以及他们的出发点。Alisa，这太精彩了。最后两个问题：如果大家想联系你或与你合作，可以在哪里找到你？你主要与哪类人合作？最后，听众可以如何帮到你？

---

### 01:21:47 Alisa Cohn

**English:**
Oh, thank you. Well, I work with executives at startups and also at large public companies, so feel free to reach out if you want to have a conversation about coaching. And you can find me at alisacohn.com. And actually, I'm going to take some resources and put them at a special link, which is alisacohn.com/lenny. If you want to download the Co-Founder Prenup. I also have a Personal Operating Manual and a few other resources I will put there. So alisacohn.com/lenny and you can also join my newsletter from there.

**中文翻译:**
噢，谢谢。我与初创公司以及大型上市公司的管理层合作，所以如果你想聊聊教练服务，欢迎联系我。你可以在 alisacohn.com 找到我。实际上，我会把一些资源放在一个专属链接：alisacohn.com/lenny。如果你想下载《创始人婚前协议》，我还会放上《个人操作手册》和其他一些资源。所以请访问 alisacohn.com/lenny，你也可以在那里订阅我的时事通讯。

---

### 01:22:20 Alisa Cohn

**English:**
And I think in terms of helping me, I guess there's two things I want to say. My life's work genuinely is to make a difference. When I became a coach, it was because the music in my head was to make a difference. And so I hope I've made a difference for all of you today and I would invite you to try one thing that makes you uncomfortable, this week. As soon as you hear this, this week, try something that makes you uncomfortable and feel free to let me know on LinkedIn or even send me an email and let me know what you did that made you uncomfortable.

**中文翻译:**
至于如何帮到我，我想说两点。我一生的事业核心就是“带来改变”。我之所以成为教练，是因为我内心的声音告诉我去做有意义的改变。所以我希望今天能给各位带来一些改变。我邀请大家在本周尝试一件让你感到不舒服的事情。听完这期节目，就在本周，尝试一件让你不适的事，欢迎在 LinkedIn 上告诉我，或者给我发邮件，告诉我你做了什么让你不适的事。

---

### 01:22:51 Alisa Cohn

**English:**
So that would be very meaningful to me. And the second thing that would be very meaningful to me is if you would go find my podcast called, From Start-Up to Grown-Up and give it a listen. Maybe give it a rating and review because as you know, Lenny, the way people find your podcast is when other people are interested in your podcast.

**中文翻译:**
那对我来说会非常有意义。第二件对我有意义的事是，请去搜搜我的播客，叫《从初创到成熟》（From Start-Up to Grown-Up），听一听。如果可以的话，请给个评分和评价，因为正如你所知，Lenny，别人发现你播客的方式就是看到其他人对它感兴趣。

---

### 01:23:09 Lenny Rachitsky

**English:**
From Start-Up to Grown-Up. I love that title.

**中文翻译:**
《从初创到成熟》，我喜欢这个标题。

---

### 01:23:11 Alisa Cohn

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### 01:23:12 Lenny Rachitsky

**English:**
Alisa, thank you so much for being here. This was awesome.

**中文翻译:**
Alisa，非常感谢你能来，这太棒了。

---

### 01:23:15 Alisa Cohn

**English:**
Thank you so much for having me, Lenny. It was great.

**中文翻译:**
非常感谢你的邀请，Lenny。这很愉快。

---

### 01:23:17 Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
各位再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。