# Ami Vora - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Ami Vora.

---

### (00:00:00) Lenny Rachitsky

**English:**
Boz, the CTO of Meta, said something about you. "Working with Ami, she could have the most profound disagreement in the world and she would respond, fascinating, you have to tell me more why you think that."

**中文翻译:**
Meta 的首席技术官 Boz 曾这样评价你：“与 Ami 共事时，即使她面对世界上最严重的分歧，她也会回应说：‘太有意思了，你一定要多跟我讲讲你为什么会那样想。’”

---

### (00:00:09) Ami Vora

**English:**
I really enjoy being right and then it turns out in the working world, that did not serve me so great. I think the hard part is sublimating your ego a little bit and saying it's more important to get to the outcome than to be right.

**中文翻译:**
我以前非常享受“正确”的感觉，但后来发现在职场中，这种心态对我并没有什么好处。我认为最难的部分是稍微克制一下你的自我（Ego），并意识到达成目标比证明自己正确更重要。

---

### (00:00:19) Lenny Rachitsky

**English:**
I love this very tactical piece of advice when you're trying to come up with a metaphor or analogy, think about what you want your users to feel when you're using the product.

**中文翻译:**
我非常喜欢这个极具战术性的建议：当你试图构思一个隐喻或类比时，去思考你希望用户在使用产品时产生什么样的感受。

---

### (00:00:27) Ami Vora

**English:**
If we all agree that the feeling of something should be, I'm sitting in Dolores Park with my friends on a sunny Saturday, then people will just naturally build something that feels more consistent.

**中文翻译:**
如果我们都认同某种产品的感受应该是“在阳光明媚的周六，和朋友们坐在多洛雷斯公园（Dolores Park）里”，那么大家自然而然就会做出感觉更一致的东西。

---

### (00:00:36) Lenny Rachitsky

**English:**
There's also this metaphor about the hill climb.

**中文翻译:**
还有一个关于“爬坡”（Hill Climb）的隐喻。

---

### (00:00:38) Ami Vora

**English:**
For me, the hill climb is all about the difference between a local optimum and a global optimum. You're standing on top of the hill, you're looking down, you can see rolling hills, the sheep, the grass, whatever, but then, way off in the distance you can see a mountain. And the thing that gets me through the valley is remembering what the summit feels like.

**中文翻译:**
对我来说，“爬坡”的核心在于局部最优（Local Optimum）和全局最优（Global Optimum）之间的区别。你站在小山丘顶上向下看，能看到起伏的丘陵、羊群和草地等等，但在遥远的远方，你能看到一座大山。而支撑我走过低谷的，是记住登上巅峰的那种感觉。

---

### (00:00:59) Lenny Rachitsky

**English:**
Today, my guest is Ami Vora. Ami is Chief Product Officer at Faire, which connects independent retailers and brands around the world, and I believe is the most successful and biggest B2B marketplace startup out there. Prior to Faire, Ami was employee 150 at Facebook, where she launched the first Facebook developer platform and was later head of product for the $55 billion global Facebook ads business. She also oversaw the introduction of ads on the Instagram platform and most recently, she led product and design for the largest messaging app in the world, WhatsApp.

**中文翻译:**
今天的嘉宾是 Ami Vora。Ami 是 Faire 的首席产品官（CPO），Faire 连接着全球的独立零售商和品牌，我认为它是目前最成功、规模最大的 B2B 电商平台初创公司。在加入 Faire 之前，Ami 是 Facebook 的第 150 号员工，她在那里推出了首个 Facebook 开发者平台，后来担任年营收 550 亿美元的 Facebook 全球广告业务的产品负责人。她还监督了 Instagram 平台广告的引入，最近，她领导了全球最大的即时通讯应用 WhatsApp 的产品和设计工作。

---

### (00:01:34) Lenny Rachitsky

**English:**
In our conversation we cover a lot of ground, including building your strategy skills, how to disagree with people skillfully, being a successful woman in tech, using metaphors and imagery to rally your team and get your point across, setting up effective goals, plus a bunch of jokes in the lightning round that you don't want to miss. This was a really special and authentic conversation that I'm very excited to bring to you. With that, I bring you, Ami Vora.

**中文翻译:**
在我们的对话中，我们涵盖了许多领域，包括培养战略技能、如何巧妙地与人产生分歧、如何成为科技界成功的女性、利用隐喻和意象来凝聚团队并传达观点、设定有效目标，以及闪电问答环节中一系列不容错过的笑话。这是一次非常特别且真实的对话，我很高兴能把它带给大家。现在，让我们欢迎 Ami Vora。

---

### (00:02:03) Lenny Rachitsky

**English:**
Ami, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Ami，非常感谢你能来到这里，欢迎来到播客。

---

### (00:02:06) Ami Vora

**English:**
Oh, thank you. I'm so happy to be here.

**中文翻译:**
噢，谢谢。我很高兴能来到这里。

---

### (00:02:08) Lenny Rachitsky

**English:**
So, when I asked you about your goal for our conversation today, you said the most amazing thing, which I love. You said that your goal is to be as authentic as possible and to show that people can be pretty messy and imperfect at times, yet still be very successful. I love that so much. Let's definitely try to do this. Is there anything else you want to add on that?

**中文翻译:**
当我问你今天对话的目标时，你说了句让我非常惊喜的话。你说你的目标是尽可能保持真实，并展示出人们有时可以表现得很凌乱、很不完美，但依然能取得巨大的成功。我太喜欢这个观点了。我们一定要尝试这样做。关于这一点，你还有什么想补充的吗？

---

### (00:02:28) Ami Vora

**English:**
Yeah, I mean, maybe I'll just say a couple more words on that. Actually, I feel like when I was coming up, when I looked at people who were successful, they seemed to have everything figured out, especially the women. They were all super women, where they respond to every email in 10 seconds, they didn't seem to sleep, they always wore high heels. They were just perfect and I was just like, oh, I guess I'm never going to be successful. That is not me. I love to sleep, I waste time doing absurd things all the time.

**中文翻译:**
是的，我想再多说两句。实际上，当我还在职业起步阶段时，我看着那些成功人士，他们似乎掌控了一切，尤其是那些女性。她们个个都是“女超人”，能在 10 秒内回复每一封邮件，似乎从不睡觉，总是穿着高跟鞋。她们太完美了，以至于我觉得：“噢，看来我永远不会成功了。”那根本不是我。我特别爱睡觉，我经常把时间浪费在一些荒唐的事情上。

---

### (00:03:00) Ami Vora

**English:**
And I'll tell you how glamorous my lifestyle is, I'm currently working out of my bathroom. I'm talking to you from my bathroom, which is where I work from because I love my house, it's a great house, wasn't meant for work from home, three kids, two parents remote work, and it was just the place with the most closing doors between me and my children when the pandemic started. And so it just took me a while to realize that actually, it's all fine. No one's got it fully figured out, you never know how someone else is living. Most of us are winging it and learning as we're going and learning through trial and error and it's all normal. It's all fine and I can do it and you can do it, and everyone.

**中文翻译:**
我再告诉你我的生活有多“光鲜亮丽”吧：我现在是在浴室里办公。我是在浴室里跟你说话的，这就是我工作的地方，因为我爱我的房子，它很棒，但它不是为居家办公设计的。家里有三个孩子，两个大人都要远程办公，疫情开始时，这里是唯一一个能在我跟孩子们之间关上最多道门的地方。所以我花了一段时间才意识到，其实这一切都没关系。没有人能完全掌控一切，你永远不知道别人的生活真实样貌。我们大多数人都是在边做边摸索（Winging it），在过程中学习，通过试错来进步，这都很正常。这没什么大不了的，我能做到，你也能做到，每个人都能做到。

---

### (00:03:43) Lenny Rachitsky

**English:**
I so love hearing this. This is something people often want to hear more of on this podcast, because there's all these stories of here's all these successes, here's all these things I did and everything, it just always seems to work out. And we try to, we have this failure corner on the podcast where people share story failure. So I love just setting that frame for this conversation of just super being real and being clear that there's a lot of things that go wrong behind the scenes that people often don't hear about.

**中文翻译:**
我太喜欢听这些了。这是听众经常想在这个播客里多听到的内容，因为到处都是成功的故事，都是“我做了这些事，然后一切就顺理成章地成功了”。我们也尝试在播客里设立一个“失败角落”，让大家分享失败的故事。所以我很喜欢为这次对话设定这样一个基调：保持超级真实，并明确指出在幕后有很多不为人知的挫折。

---

### (00:04:08) Ami Vora

**English:**
I for a long time felt like I was held back because I don't have a plan, but I realized that probably the most important thing is to just acknowledge that that is true for me. That I'm not going to be a person with a plan, and actually the thing that has consistently served me is to do the thing that feels right, go to the place that feels like home, work with the people who feel like my friends. Just work where when I put on the code of the job, I feel like, oh, this is a place where I could really be lucky, I could be creative, I'm in the right spot, as opposed to feeling like, oh, there is an end state that I know of and I'm just going to have to work my way to that end state. Whenever I get in that zone of, there's only one outcome and I just have to get there, I'm not my best. I'm not bringing the creativity and the luck and the excitement in the same way.

**中文翻译:**
很长一段时间里，我觉得自己停滞不前是因为我没有计划。但我意识到，最重要的事情或许就是承认这就是我的真实状态——我不是一个有计划的人。事实上，一直以来对我有效的方法是：做感觉正确的事，去感觉像家的地方，和感觉像朋友的人一起工作。就在那种当你穿上这份工作的“外套”时，你会觉得：“噢，在这里我真的会很走运，我可以发挥创造力，我找对地方了。”而不是觉得：“噢，我知道有一个最终目标，我必须努力爬到那里。”每当我进入那种“只有一个结果，我必须达成它”的状态时，我就不是最好的自己。我无法以同样的方式带来创造力、运气和兴奋感。

---

### (00:05:03) Lenny Rachitsky

**English:**
Let me tell you about a product called Sidebar. The best way to level up your career is to surround yourself with extraordinary peers. This gives you more than a leg up, it gives you a leap forward. This worked really well for me in my career and this is the Sidebar ethos. When you have a trusted group of peers, you can discuss challenges you're having, get career advice and just gut check how you're thinking about your work, your career, and your life. This was a big trajectory changer for me, but it's hard to build this trusted group of peers.

**中文翻译:**
让我向你介绍一款名为 Sidebar 的产品。提升职业生涯的最佳方式就是让自己置身于优秀的同行之中。这不仅能给你提供助力，更能让你实现跨越式的发展。这在我的职业生涯中非常奏效，也是 Sidebar 的核心理念。当你拥有一群值得信赖的同行时，你可以讨论面临的挑战，获得职业建议，并对你关于工作、职业和生活的想法进行直觉检查（Gut check）。这对我来说是一个巨大的轨迹转折点，但建立这样一个值得信赖的同行群体并不容易。

---

### (00:05:34) Lenny Rachitsky

**English:**
Sidebar is a private highly vetted leadership program where senior leaders are matched with peer groups to lean on for unbiased opinions, diverse perspectives and raw feedback. Guided by world-class programming and facilitation, Sidebar enables you to get focused, tactical feedback in every step of your career journey. If you're a listener of this podcast, you're already committed to growth. Sidebar is the missing piece to catalyze your career. 93% of members say Sidebar helped them achieve a significant positive change in their career. Why spend a decade finding your people when you can meet them at Sidebar today? Join thousands of top senior leaders who have taken the first step to career growth, from companies like Microsoft, Amazon, and Meta by visiting sidebar.com/lenny. That's sidebar.com/lenny.

**中文翻译:**
Sidebar 是一个私密的、经过严格筛选的领导力项目，资深领导者会被匹配到同行小组中，从中获得公正的意见、多元的视角和原始的反馈。在世界级课程和引导的帮助下，Sidebar 让你在职业生涯的每一步都能获得专注且具战术性的反馈。如果你是本播客的听众，说明你已经致力于成长。Sidebar 就是催化你职业生涯的那块缺失拼图。93% 的成员表示 Sidebar 帮助他们在职业生涯中实现了显著的积极变化。为什么要花十年时间去寻找志同道合的人，而现在就可以在 Sidebar 遇见他们呢？访问 sidebar.com/lenny，加入成千上万来自微软、亚马逊和 Meta 等公司的顶尖资深领导者，迈出职业成长的第一步。网址是 sidebar.com/lenny。

---

### (00:06:26) Lenny Rachitsky

**English:**
This episode is brought to you by Anvil. Their document SDK helps product teams build and launch software for documents, fast. Companies like Carta and Vouch Insurance use Anvil to accelerate the development of their document workflows. Getting to market fast is a top priority for product teams, and the last thing that you or your developers want is to build document workflows from scratch. It's time consuming, expensive and distracts from core work. You could stitch together multiple tools and manage those integrations or you can use an all-in-one document SDK.

**中文翻译:**
本集节目由 Anvil 赞助。他们的文档 SDK 帮助产品团队快速构建和发布文档软件。像 Carta 和 Vouch Insurance 这样的公司都在使用 Anvil 来加速其文档工作流的开发。快速进入市场是产品团队的首要任务，而你或你的开发人员最不想做的就是从头开始构建文档工作流。这既耗时又昂贵，还会分散核心工作的精力。你可以拼凑多个工具并管理这些集成，也可以使用一体化的文档 SDK。

---

### (00:07:00) Lenny Rachitsky

**English:**
Most product managers will tell you, paperwork sucks. Anvil's document SDK helps teams get to market fast, incorporate your brand's style and give you back time to focus on your company's core differentiated features. For your users, paperwork often starts with an AI powered web form styled and embedded in your application. From there, you can route data to your backend systems and to the correct fields in your PDFs via API. Complete the process with a white labeled e-signature.

**中文翻译:**
大多数产品经理都会告诉你，文书工作（Paperwork）糟透了。Anvil 的文档 SDK 帮助团队快速上市，融入你的品牌风格，并让你腾出时间专注于公司的核心差异化功能。对于你的用户来说，文书工作通常始于一个嵌入在应用程序中的、由 AI 驱动的网页表单。从那里，你可以通过 API 将数据路由到后端系统以及 PDF 中的正确字段。最后通过白标电子签名完成整个流程。

---

### (00:07:29) Lenny Rachitsky

**English:**
The best part about Anvil is the level of customization their SDK provides. Non-technical folks love Anvil's drag and drop builder and developers love their flexible APIs and easy to understand documentation. Build documents software fast with Anvil, that's useanvil.com/lenny, to learn more or start a free trial. That's useanvil.com/lenny.

**中文翻译:**
Anvil 最棒的地方在于其 SDK 提供的定制化程度。非技术人员喜欢 Anvil 的拖拽式生成器，而开发人员则喜欢他们灵活的 API 和易于理解的文档。使用 Anvil 快速构建文档软件，访问 useanvil.com/lenny 了解更多信息或开始免费试用。网址是 useanvil.com/lenny。

---

### (00:07:55) Lenny Rachitsky

**English:**
Let's actually spend some more time here. I wasn't planning to go here yet, but this is really great and important advice. I've just, basically you're saying that a lot of your success has come from following people that are awesome. Can you just talk more about that, just what it is you've followed and seen that has helped you land in places that have worked out so well, because clearly you've done incredibly well.

**中文翻译:**
让我们在这里多花点时间。我本来没打算这么快聊这个，但这确实是非常棒且重要的建议。基本上你是说，你的很多成功来自于追随那些优秀的人。你能多谈谈这一点吗？你追随了什么，看到了什么，从而帮助你进入了那些发展得如此之好的地方？因为显然你做得非常出色。

---

### (00:08:14) Ami Vora

**English:**
I mean, I think a lot of us are just like, you have a spreadsheet in your head of the axes and certainly when you're choosing between jobs, for me it feels like, oh man, the rest of my career hangs in the balance of making the exact right decision and getting the exact right job. And you work through all of this spreadsheet mass of, if I took this job, here's what it would do for me, here's where I'd be in five years, etc. And I have that engine in my head also, but what I try to do is work through the spreadsheets and then tear it up because none of that stuff is actually going to determine how good I am at the job. The thing that'll determine... In my track record, the thing that has determined it is when I walk through the doors, do I feel like I'm lucky to be there?

**中文翻译:**
我想我们很多人都是这样：脑子里有一张带有各种坐标轴的电子表格。尤其是在选择工作时，对我来说，感觉就像是：“天哪，我余下的职业生涯都取决于能否做出那个绝对正确的决定，得到那份绝对正确的工作。”然后你会处理这一大堆电子表格数据：如果我接了这份工作，它会给我带来什么，五年后我会在哪里，等等。我脑子里也有这种引擎，但我尝试做的是，处理完这些表格后就把它们撕掉，因为这些东西实际上并不能决定我在那份工作上做得有多好。在我的过往经历中，决定性因素是：当我走进那扇门时，我是否觉得自己能在这里工作很幸运？

---

### (00:09:03) Ami Vora

**English:**
So for me, it's actually a lot more emotional. I try to just put on the coat of the job. When I wake up in the morning, I'm like, what would it be like if I were doing this job? What would I think about on my commute? Who would I have lunch with? Do I like them? What problems am I going to solve today? And that gives me an emotional response, which is just much more telling than the spreadsheets of, here's where I'm going to be in five years.

**中文翻译:**
所以对我来说，这实际上更多是情感层面的。我尝试“穿上这份工作的外套”。当我早上醒来，我会想：如果我做这份工作会是什么样子？通勤时我会想些什么？我会和谁一起吃午饭？我喜欢他们吗？今天我要解决什么问题？这会给我一个情感上的反馈，这比那些“五年后我会达到什么位置”的电子表格要深刻得多。

---

### (00:09:31) Ami Vora

**English:**
And for me, the thing that has led me to the places where I do my best work is a feeling of being at home, which is all about trust and trust with the people around me. Can I walk through and feel like these people are going to have my back, they're going to let me take risks, I'm going to enjoy spending time with them? And that's where I feel like I've always just been able to try more things and do better because a big, trust is a big unlock for me.

**中文翻译:**
对我来说，引导我进入那些能发挥出最佳水平的地方的，是一种“家”的感觉，这完全关乎信任，以及与周围人的信任。我走进去时，是否觉得这些人会支持我，会允许我冒险，我会享受和他们在一起的时光？这就是我觉得自己总能尝试更多事情、做得更好的原因，因为信任对我来说是一个巨大的开启键。

---

### (00:09:56) Lenny Rachitsky

**English:**
I love this metaphor of putting on the coat of the job, of just feeling out what it would be to work there. I imagine that was something that you did before you joined Faire, which I want to talk about, but let me transition a bit to talking about Meta and specifically, Boz. The CTO of Meta was on this podcast a few months ago and he said something about you that I want to read.

**中文翻译:**
我喜欢“穿上工作的外套”这个隐喻，去感受在那里工作会是什么样子。我猜你在加入 Faire 之前也这么做了，稍后我想聊聊这个。但现在让我转而谈谈 Meta，特别是 Boz。Meta 的首席技术官 Boz 几个月前上过这个播客，他评价了你一些话，我想读一下。

---

### (00:10:17) Ami Vora

**English:**
Oh, kind.

**中文翻译:**
噢，他真客气。

---

### (00:10:18) Lenny Rachitsky

**English:**
Okay, so you've heard what he said about you?

**中文翻译:**
好，所以你听过他怎么评价你的了？

---

### (00:10:21) Ami Vora

**English:**
[inaudible 00:10:21].

**中文翻译:**
（听不清）

---

### (00:10:20) Lenny Rachitsky

**English:**
Okay, cool. So let me read this and then I want to learn from you how to do this. So here's what he said. "Working with Ami, it was like watching an alien because she could have the most profound disagreement in the world with somebody and they would say something that she thought was not just wrong, but crazy wrong, and she would respond, 'Fascinating, you have to tell me more why you think that.' And she meant it from the core of her being. She saw this schism and rather than reacting as if it was a threat, she reacted with the most genuine and profound curiosity. I just watched it absolutely tear down walls between points of view. Embracing curiosity in those moments of challenges completely changed my life and I owe that to Ami Vora."

**中文翻译:**
好，太棒了。让我读一下这段话，然后我想向你学习如何做到这一点。他是这么说的：“和 Ami 共事就像在观察一个外星人，因为她可以和某人产生世界上最深刻的分歧，对方说了一些她认为不仅是错误的、甚至是错得离谱的话，而她的反应却是：‘太有意思了，你一定要多跟我讲讲你为什么会那样想。’而且她是发自内心地这么想。她看到了这种裂痕（Schism），但她没有把它当作威胁，而是以最真诚、最深刻的好奇心去应对。我亲眼目睹了这种方式彻底拆除了观点之间的围墙。在那些充满挑战的时刻拥抱好奇心彻底改变了我的生活，这都要归功于 Ami Vora。”

---

### (00:10:58) Ami Vora

**English:**
Oh man, I love Boz, what a great guy, and so kind of him to say that. I mean, I will say that this did not come naturally to me. I really enjoy being right, I love to be right. I think most of us love being right, and at least in my childhood, part of my identity was built on being the person who was right and being the person who knew everything.

**中文翻译:**
噢天哪，我爱 Boz，他真是个大好人，能这么说真是太客气了。我想说的是，这对我来说并不是天生就有的。我非常享受“正确”的感觉，我喜欢自己是对的。我想我们大多数人都喜欢正确，至少在我的童年时期，我的一部分身份认同就是建立在做一个“正确的人”和“无所不知的人”之上的。

---

### (00:11:22) Ami Vora

**English:**
And then it turns out that in the working world, that did not serve me so great, it wasn't great to walk into things and be like, all y'all are wrong, I am the only answer, everyone please to listen to me and stop talking. And what really happened was that someone pointed out to me that not only... One of my old managers pointed out to me that not only was I spending a lot of energy trying to think through every possible thing by myself so I could be totally right, I was often not really coming to the right answer. Other people have a bunch of information that I do not have. And so I'm just ignoring that, I was letting my ego overtake my desire to get to the best outcome, which is just, that's a silly trade off and an unnecessary one.

**中文翻译:**
但后来事实证明，在职场中，这种心态对我并没有什么好处。走进一个场合然后表现得像“你们都错了，我才是唯一的答案，请大家都听我说，别说话了”，这并不好。真正发生改变的是有人提醒了我……我以前的一位经理指出，我不仅花了大量精力试图独自思考每一件事以确保绝对正确，而且我往往并没有得出真正的正确答案。其他人拥有我所不具备的大量信息。而我却忽视了这一点，我让我的自我（Ego）压倒了追求最佳结果的愿望，这真是一个愚蠢且不必要的权衡。

---

### (00:12:12) Ami Vora

**English:**
The thing that changed there is me just saying it's more important for us to get to the outcome and I very selfishly just like to learn more things. And so by deciding that I already knew everything, I was cutting myself off from learning the things that other people were really good at and it's so easy to just open the door instead and say like, hey, you seem to know something that I don't know yet. Why not tell me about it? I'm going to get better. We'll probably come to the right outcome. Maybe you'll have a better time. Why not?

**中文翻译:**
改变的关键在于我告诉自己，达成结果更重要，而且从私心来说，我也喜欢学习新东西。如果我认定自己已经无所不知，我就切断了向他人学习其擅长领域的机会。其实打开心扉非常简单，只需说：“嘿，你似乎知道一些我还不知道的事情。为什么不跟我讲讲呢？”这样我会变得更好，我们可能会得出正确的结果，也许你也会过得更愉快。何乐而不为呢？

---

### (00:12:45) Ami Vora

**English:**
And so it was a little bit just accidental evolution in that direction. But it's made work and life so much more interesting to just be like, hey, what does this person know that I don't know yet? It means that every meeting you walk into, you're probably not going to get bored and I get bored a lot, but if you assume that every person there knows something that you don't know, then it's not just wait to get to the right answer, it's like, discover the thing that they know that you don't know and it becomes just a little bit of uncovering.

**中文翻译:**
所以这有点像是朝着那个方向的“无意间的进化”。但这让工作和生活变得有趣得多，只需想：“嘿，这个人知道哪些我还不知道的事？”这意味着你走进的每一个会议，你可能都不会感到无聊——而我经常感到无聊。但如果你假设那里的每一个人都知道一些你不知道的事情，那么这就不仅仅是等待正确答案，而是去发现他们知道而你不知道的东西，这变成了一种探索的过程。

---

### (00:13:18) Lenny Rachitsky

**English:**
For people that want to learn to be good at this the way you are, a couple things that I take away from the historian and the way you're talking about this is, one is there's an enthusiasm of, I disagree with you, but I want you to know I really care about what you think. So there's an energy of like, please tell me what I'm missing. There's also this assumption that a lot of disagreement is rooted in, we just have different information, so tell me what I'm missing. Can you talk a bit about just how to, what you've learned about actually do this well?

**中文翻译:**
对于那些想像你一样擅长此道的人，我从你的叙述和你谈论这件事的方式中总结出几点：第一，有一种热情，即“我不同意你的观点，但我希望你知道我非常在意你的想法”。所以有一种“请告诉我我遗漏了什么”的能量。第二，还有一种假设，即很多分歧源于我们掌握的信息不同，所以请告诉我我漏掉了什么。你能谈谈你学到的关于如何真正做好这件事的经验吗？

---

### (00:13:45) Ami Vora

**English:**
Yeah, I mean, I think the hard part is just sublimating your ego a little bit and saying it's more important to get to the outcome than to be right. And I think all of growth is a battle with yourself, but this is one of the hardest ones because we all want to be right, we all want to protect ourselves and it served us, many of us for so long to be right. I just try to think about the feedback loop of, I think all of life is feedback loops, so I just started to think about the feedback loop I'm creating of like, I was curious about something. I learned something new, we got for a better outcome. Probably the other person felt better as well as I felt better. It's all positive feedback and you do that a couple of times and the positive feedback far outweighs the desire to be right because now we're more right, we're more right together. And so just building that as a practice of just noticing how much better things can get when you can be open to them, has been really fun.

**中文翻译:**
是的，我认为难点在于稍微克制一下你的自我，并告诉自己达成结果比证明正确更重要。我认为所有的成长都是一场与自己的战斗，而这一场是最难的之一，因为我们都想正确，都想保护自己，而且长期以来“正确”确实让我们受益匪浅。我尝试去思考反馈循环——我认为生命就是由反馈循环组成的。所以我开始思考我正在创建的反馈循环：我对某事感到好奇，我学到了新东西，我们得到了更好的结果，对方可能感觉更好了，我也感觉更好了。这全是正向反馈。当你这样做几次后，这种正向反馈带来的满足感远超证明正确的欲望，因为现在我们“更正确”了，我们一起变得更正确。所以，把这作为一种练习，去观察当你保持开放心态时事情能变得多么美好，这真的很有趣。

---

### (00:14:43) Lenny Rachitsky

**English:**
What do you think of this phrase that he used that he remembers? Is that a phrase that you find useful? Just fascinating, you have to tell me more why you think that.

**中文翻译:**
你觉得他记得的那句话怎么样？你觉得那句话有用吗？就是“太有意思了，你一定要多跟我讲讲你为什么会那样想”。

---

### (00:14:52) Ami Vora

**English:**
I do think that is a word that I say a lot. I do say that a lot, because it's true, it's fascinating that someone to look at the same movie that I was looking at and come away with a totally different understanding of the plot. I could sit in the same meeting as other people and they would leave with just a different retelling of what happened, and that to me is fascinating. Isn't that surprising, that we can all see the same, what we think are the same facts and walk away with a totally different narrative? And when you really go deep into that and you just understand how people see the world, and that is helpful. I'm curious about things, I like to know more things, and so that just helps me know more things.

**中文翻译:**
我确实经常说那个词（Fascinating）。我确实说得很多，因为那是事实。看到有人和我看同一部电影，却对情节有完全不同的理解，这太有意思了。我可以和别人坐在同一个会议里，他们离开时对发生的事情却有完全不同的复述，这对我来说太有意思了。这难道不令人惊讶吗？我们都能看到同样的、我们认为是事实的东西，却带着完全不同的叙事离开。当你真正深入其中，理解人们是如何看待世界的，这非常有帮助。我对事物充满好奇，我喜欢了解更多事情，所以这只是帮助我了解更多。

---

### (00:15:36) Lenny Rachitsky

**English:**
I feel like the hardest part of this for people is you hear someone say something, say, okay, so our mutual friend, Dan Hockenmaier, he's in a meeting and he just says something that you are just like, no, because he's got influence. He's a big deal at Faire. Most people have this visceral reaction of like, oh no, I really don't think that's a good idea. Is there something you've learned about controlling that bodily reaction of like, oh, and then just being positive about it?

**中文翻译:**
我觉得对人们来说最难的部分是，当你听到某人说了一些话——比如我们共同的朋友 Dan Hockenmaier，他在会议上说了一些让你觉得“不，绝对不行”的话，因为他很有影响力，他在 Faire 是个大人物。大多数人会有这种本能反应：“噢不，我真的不觉得那是个好主意。”关于控制这种“噢不”的生理反应，并转而以积极的态度面对，你有什么心得吗？

---

### (00:16:00) Ami Vora

**English:**
Yeah, I do think it is just that feedback loop. It's not like I don't have the visceral reaction, it's just that instead of interpreting it as this is a visceral reaction, I got to shut something down, it's like, this is a visceral reaction and it's a chance to learn more. Just reinterpreting some of the feelings in ways that are more about opening than about closing stuff down.

**中文翻译:**
是的，我认为这还是归结为那个反馈循环。并不是说我没有本能反应，而是我不再将其解读为“这是一种本能反应，我必须反驳它”，而是解读为“这是一种本能反应，这是一个学习更多东西的机会”。只是将某些感受重新解读为“开启”而非“关闭”的方式。

---

### (00:16:23) Lenny Rachitsky

**English:**
Got it, so it's kind of like a thinking you do of like, okay, hey, let me frame this and think about this [inaudible 00:16:28].

**中文翻译:**
明白了，所以这更像是你的一种思维方式，比如：“好，让我重新构架一下，思考一下这个……”（听不清）

---

### (00:16:28) Ami Vora

**English:**
For me the most important thing is just taking a pause. I think when you just take a pause, your body calms down, your mind gets a chance to breathe a little bit, and then your response is going to be better, but you got to take the pause because the immediate visceral reaction, is not always... It's going to be primal, it's going to be protective. It's just when you take a pause you're like, this is all fine, let's just learn.

**中文翻译:**
对我来说，最重要的事情就是“暂停一下”。我认为当你停顿一下时，你的身体会平静下来，你的大脑有机会喘口气，然后你的反应会变得更好。但你必须停顿，因为即时的本能反应并不总是……它往往是原始的、防御性的。只有当你停顿下来，你才会觉得：“这都没关系，让我们学习一下吧。”

---

### (00:16:52) Lenny Rachitsky

**English:**
I feel like more people are going to start using this phrase, fascinating.

**中文翻译:**
我觉得会有更多人开始使用这个词——“太有意思了”（Fascinating）。

---

### (00:16:55) Ami Vora

**English:**
Fascinating.

**中文翻译:**
太有意思了。

---

### (00:16:56) Lenny Rachitsky

**English:**
When they hear something [inaudible 00:16:58].

**中文翻译:**
当他们听到一些……（听不清）

---

### (00:16:57) Ami Vora

**English:**
It's kind of my tagline. There were a few years where I had to be careful about not saying it because whenever I said it, people would be like, she disagrees. So I've had to use a thesaurus and expand my words I use.

**中文翻译:**
这有点像我的口头禅。有几年我不得不小心不去说它，因为每当我一说，大家就会觉得：“她在表示反对。”所以我不得不翻翻同义词词典，扩大我的词汇量。

---

### (00:17:12) Lenny Rachitsky

**English:**
No, that's such a good word. Maybe we'll make that the title of this episode.

**中文翻译:**
不，这词太棒了。也许我们会把它作为这一集的主题。

---

### (00:17:12) Ami Vora

**English:**
Totally.

**中文翻译:**
完全同意。

---

### (00:17:16) Lenny Rachitsky

**English:**
What a great title that would be. So we've been talking a bit about the bodily reaction to stuff and our lizard brain almost, reacting to things. It reminds me of this metaphor that you called the dinosaur brain and how it applies to product reviews. Talk about what that is.

**中文翻译:**
那会是个很棒的标题。我们刚才聊到了对事物的生理反应，几乎是我们的“蜥蜴脑”在起作用。这让我想起你提到的一个叫“恐龙脑”的隐喻，以及它是如何应用在产品评审（Product Review）中的。谈谈那是什么吧。

---

### (00:17:31) Ami Vora

**English:**
Okay, so a lot of people on my team, they're coming in to do product reviews and they're worried about it. They're stressed out, they don't exactly know what to show, and the normal temptation is just to show as much information as possible because that way you come in and you think, hey, the people in this room are super smart. I'll show them the information, they will come to the right conclusions. They'll probably make a better decision than I'm going to make. So my job is to catalog the information and present it.

**中文翻译:**
好。我团队里的很多人来参加产品评审时都会感到担心。他们压力很大，不知道该展示什么，通常的诱惑是展示尽可能多的信息。因为你会想：“嘿，这间屋子里的人都超级聪明。我把信息展示给他们，他们就会得出正确的结论。他们可能会做出比我更好的决定。所以我的工作就是整理信息并展示出来。”

---

### (00:17:59) Ami Vora

**English:**
And one of the first things that I talk to people about is, okay, for the purposes of this conversation, I'm going to put myself in the capitally executive bucket because that makes what I'm about to say less offensive. Assume that executives have a little tiny dinosaur brain. We all have a little brontosaurus brain and we can really only hold three facts at the same time. We will never be able to go deep in the way that you are able to do on everything that crosses our desk. And so the best service you can do is actually do the work of making a recommendation. That's the way we're going to be complimentary. The breadth that I normally have to look across means that I'm going to be better at things like pattern matching or giving you more context or telling you stuff that's happening in the company or the industry. But what I'm not going to be better at is looking at all the information that you looked at and coming up with a meaningful outcome. That's what you're going to do and my little dinosaur brain is going to be like, okay, that sounds like a very reasonable pattern, I've seen other patterns that look like this. Okay, that sounds like an outcome, however, it conflicts with this outcome over here. I can tell you about that. Does that make sense?

**中文翻译:**
我首先会告诉大家的是：好，为了这次对话，我把自己归入“高管”那一类，这样我接下来的话听起来就不那么冒犯了。假设高管们都有一个微小的“恐龙脑”。我们都有一个“雷龙脑子”，一次只能记住三个事实。我们永远无法像你那样，对经过我们办公桌的每一件事都进行深入研究。所以，你能提供的最好服务实际上是做好“提出建议”的工作。这就是我们互补的方式。我通常需要关注的广度意味着我更擅长模式匹配、提供更多背景信息，或者告诉你公司或行业内正在发生的事情。但我并不擅长看完你看到的所有信息并得出一个有意义的结果。那是你的工作，而我的小恐龙脑会想：“好，这听起来是一个非常合理的模式，我见过其他类似的模式。好，这听起来是一个结果，但是，它与这边的另一个结果相冲突。我可以告诉你这一点。”这能理解吗？

---

### (00:19:17) Lenny Rachitsky

**English:**
Yeah, and I love that you put yourself in that bucket. You have a dinosaur brain also, it's not other people.

**中文翻译:**
是的，我喜欢你把自己也归入那一类。你也有一个恐龙脑，不只是别人。

---

### (00:19:22) Ami Vora

**English:**
It's a pretty bad, bad look, but it's really true. As you get more breadth, you are less and less able to go deep on everything that deserves going deep and you just end up doing a different service than the people on your team, and recognizing that as complimentary has been really helpful.

**中文翻译:**
这听起来形象不太好，但确实是真的。随着你关注的广度增加，你越来越无法对每一件值得深入的事情进行深挖，你最终提供的是与团队成员不同的服务。意识到这种互补性非常有帮助。

---

### (00:19:38) Lenny Rachitsky

**English:**
You have this phrase, my manager owns context, I own the recommendation. Kind of along the same lines?

**中文翻译:**
你有一句话：“我的经理掌握背景（Context），我掌握建议（Recommendation）。”也是类似的道理吗？

---

### (00:19:42) Ami Vora

**English:**
Exactly, very similar. And I think the thing that was helpful for me there is that really unlocked what I was looking for from my managers because otherwise I wanted them to be exactly like me. If I assume that I need to bring them information and then they would come to the same conclusion that I would come to, that's very narrow. They have to be able to look at the exact same information and process it in the same way and come out with the same idea. Whereas if what they're doing is complimentary to me, then I can learn from everyone. They're going to just have a different view, they're going to have new information that I don't have, and it gives me a lot more space to take accountability.

**中文翻译:**
没错，非常相似。我认为这对我很有帮助，因为它真正开启了我对经理的期待。否则，我会希望他们和我一模一样。如果我假设我需要给他们提供信息，然后他们会得出和我一样的结论，那眼光就太狭隘了。他们必须能看到完全相同的信息，以相同的方式处理，并得出相同的想法。但如果他们所做的是与我互补的，那么我可以向每个人学习。他们会有不同的视角，会有我没有的新信息，这给了我更大的空间去承担责任。

---

### (00:20:20) Lenny Rachitsky

**English:**
Is there any other advice that you could share along these lines of just product reviews? So, the big takeaway here is just keep it simple and have a recommendation.

**中文翻译:**
关于产品评审，你还有什么其他的建议可以分享吗？所以，这里的核心要点就是：保持简单，并给出建议。

---

### (00:20:30) Ami Vora

**English:**
Keep it simple, have a recommendation. I also think that, I think we misuse product reviews sometimes as ways to get decisions and actually, they should be ways to calibrate on principles. So what you don't want is to come to a product review for every single that you want to make. Instead, what you want is to come to a product review with one decision, but the goal of that decision is to walk out with principles about how to make these decisions in the future so that you don't have to come to product review, but you still have this consistent and coherent product that you're building.

**中文翻译:**
保持简单，给出建议。我还认为，我们有时误用了产品评审，把它当作获取决策的手段，而实际上，它应该是“对齐原则”的方式。所以，你并不希望为了每一个你想做的决定都跑去参加产品评审。相反，你希望带着一个决定去参加评审，但那个决定的目标是带走一套关于未来如何做此类决定的“原则”。这样你以后就不必再来参加评审，但依然能构建出一致且连贯的产品。

---

### (00:21:04) Ami Vora

**English:**
And so I think when you flip the frame of reviews to being less about, okay, I'm going to bring this information to an exec, my manager, whoever, and they're going to decide every piece, you're not actually building that much more capacity in the system. You're getting fast decision making, but you're not changing who can make really good decisions. And I think you always want to change the org to constantly make better decisions, and a way to do that is when you bring these sorts of questions, what you talk about is, why did you make this decision? What are the trade-offs you have in mind? Who are you optimizing for? What timeline are you thinking about? What's the risk level we're willing to tolerate? And then you don't have to come back. You have enough information that you can take those principles and run with them.

**中文翻译:**
因此，我认为当你改变评审的框架，不再是“我要把这些信息带给高管、经理或任何人，让他们决定每一个细节”时，你实际上并没有在系统中建立更多的能力。你得到了快速的决策，但你并没有改变“谁能做出真正好的决策”。我认为你总是希望改变组织，使其不断做出更好的决策。实现这一目标的方法是，当你提出这类问题时，你讨论的是：你为什么做这个决定？你考虑了哪些权衡？你在为谁优化？你考虑的时间线是什么？我们愿意承担多大的风险？然后你就不必再回来了。你有了足够的信息，可以带着这些原则去执行。

---

### (00:21:51) Lenny Rachitsky

**English:**
Is there a framework or a process you use for product reviews that might be helpful for people to hear? Just like a agenda or a way of thinking about just how to set up a product review for success? Because a lot of people are trying to set these up at their companies and they're like, I don't know if we're doing this optimally.

**中文翻译:**
你有没有在产品评审中使用的框架或流程，可以分享给大家？比如议程，或者关于如何成功设置产品评审的思考方式？因为很多人都在尝试在公司建立这种机制，但他们不确定自己做得是否最优。

---

### (00:22:05) Ami Vora

**English:**
Yeah, I think everyone's got... I think there's so many different takes on frameworks. I don't have a single system. I mean, actually I think Boz has written about a bunch of this, and I probably most agree with him. Where there's different kinds of product reviews, it's like, what are you trying to solve? What's the timeline on which you're thinking about for these? Is it a philosophy? Is it a strategic shift? Is it a day-to-day product decision? And then keeping it extremely short and pointed and then making sure you walk away with principles, not answers.

**中文翻译:**
是的，我想每个人都有……关于框架有很多不同的见解。我没有一个单一的系统。实际上，我认为 Boz 写过很多关于这方面的内容，我可能最认同他的观点。产品评审有不同的类型，比如：你试图解决什么问题？你考虑的时间线是多久？这是一个哲学问题吗？是一个战略转型吗？还是一个日常的产品决策？然后保持极其简短和有针对性，并确保你带走的是原则，而不是现成的答案。

---

### (00:22:36) Lenny Rachitsky

**English:**
I think there's a lot of nuance and importance there of what you just said, which is start with the problem you're solving. What are we trying to do here? And the timeline, I think that's also really useful and important for people to hear.

**中文翻译:**
我觉得你刚才说的很有深度也很重要，那就是：从你正在解决的问题开始。我们在这里到底想做什么？还有时间线，我认为这对大家来说也非常有用且重要。

---

### (00:22:47) Ami Vora

**English:**
The temptation is always to err toward writing more, and what I always really recommend people do is write whatever you need to write and then cut out almost all of it. What you really want to bring to any forum, whether it's a product review or a written inform or anything else, is the minimal amount of information that you need to make a clean recommendation because then you are forced to be opinionated. Otherwise, the opinion can get lost in all of this information. You can hide behind, well, all of these analyses seem to suggest, and instead you should probably just say, looked at all the data, there's three analyses that suggest this. There's one that suggests that, we think that one is inaccurate or worth taking the risk on. Let's go. Any objections? Let me know. Any new context? Let me know. That really forces you to deeply understand and take an opinion on the material.

**中文翻译:**
人们总是倾向于写得更多，而我总是建议大家：写下你需要写的一切，然后删掉其中的绝大部分。无论是在产品评审、书面汇报还是其他任何场合，你真正想要呈现的是做出明确建议所需的“最小信息量”，因为这会迫使你形成鲜明的观点。否则，你的观点可能会淹没在海量信息中。你可能会躲在“嗯，所有这些分析似乎都表明……”后面，而你应该直接说：“看了所有数据，有三项分析表明这一点。有一项表明那一点，我们认为那一项不准确，或者值得冒险。开始吧。有异议吗？请告诉我。有新背景吗？请告诉我。”这会真正迫使你深入理解材料并发表见解。

---

### (00:23:43) Lenny Rachitsky

**English:**
Final question, who do you like to invite to these product reviews and your thoughts, rules, policy?

**中文翻译:**
最后一个问题，你喜欢邀请谁参加这些产品评审？你有什么想法、规则或政策吗？

---

### (00:23:50) Ami Vora

**English:**
Yeah, I mean I do think that usually fewer people is better. It leads to a sense of being informal and that is really useful because it lowers the bar on how complete or strong these conversations are and I'd rather have a less formal conversation faster than a formal conversation and lose three weeks in the process when we could have been building. I think it needs to be cross-functional. I think one of the things you want is cross-functional accountability. So we want it cross-functional at the leadership level and cross-functional at the team presenting level. And I think those are normally the groups.

**中文翻译:**
是的，我认为通常人越少越好。这会营造一种非正式感，这非常有用，因为它降低了对话的门槛，不需要非得多么完整或强硬。我宁愿更快地进行一次非正式谈话，也不愿为了准备一次正式谈话而浪费三周时间，而那段时间我们本可以用来构建产品。我认为评审必须是跨职能的（Cross-functional）。你想要的是跨职能的问责制。所以我们希望在领导层和汇报团队层面都是跨职能的。我认为这些通常就是参与群体。

---

### (00:24:25) Ami Vora

**English:**
I think the thing that gets hard is you often cut out the middle, where if it's a working team presenting to the senior leaders on something important, it's really hard because it means people's managers are not in the room and can't help the conversation or other things. And so in order to do that, you have to really have a bunch of implicit trust inside the team that everyone will get the context later, that everyone's going to be kind to everyone else and you don't need a ton of air cover, and that the managers trust their team to present in the best possible way.

**中文翻译:**
我认为难点在于你经常会切断中间层。如果是执行团队向高级领导层汇报重要事项，这很难，因为这意味着成员的经理不在场，无法协助对话或处理其他事情。因此，为了做到这一点，团队内部必须有大量的默契信任：相信每个人稍后都会了解背景，相信每个人都会善待彼此，相信你不需要大量的“空中掩护”（Air cover，指上级的保护），并且经理们信任他们的团队能以最佳方式进行展示。

---

### (00:25:02) Lenny Rachitsky

**English:**
That is always a stressful place for a manager to be, where their success is riding in that meeting and they're not there and they-

**中文翻译:**
对经理来说，那总是一个压力很大的处境，他们的成功取决于那场会议，而他们却不在场，他们……

---

### (00:25:07) Ami Vora

**English:**
It's so stressful, it's so stressful. I think anything you do to make it less stressful is useful. But then there've also been times in my career where I would keep the room itself small, but because we were all trying to calibrate on specific principles, I would record or broadcast the reading to anyone who wanted to see it, just so they could all see the principles by which we were decision-making and get calibrated on that.

**中文翻译:**
压力太大了，真的压力很大。我认为任何能减轻这种压力的方法都是有用的。但在我的职业生涯中，也曾有过这样的时刻：我会保持会议规模很小，但因为我们都在尝试对齐特定的原则，我会录制或向任何想看的人广播这次会议，这样他们都能看到我们做决策所依据的原则，并据此进行对齐。

---

### (00:25:32) Lenny Rachitsky

**English:**
So through your career you've transitioned from being the person pitching the products and being reviewed to the person reviewing and being on the other side. Is there anything being on this side of it that you think is helpful for people earlier in their career to know about that experience, from your angle now?

**中文翻译:**
在你的职业生涯中，你已经从推销产品、接受评审的人，转变为评审他人、站在另一边的人。从你现在的角度来看，处于这一方有什么经验是对于职业生涯早期的人来说有帮助的吗？

---

### (00:25:53) Ami Vora

**English:**
I mean, I think for what it's worth, I think I still do a fair amount of product pitching in the past few years because there's always someone else to convince.

**中文翻译:**
我想说的是，在过去的几年里，我实际上仍然在做相当多的产品推销，因为总有其他人需要去说服。

---

### (00:25:59) Lenny Rachitsky

**English:**
That's true.

**中文翻译:**
确实如此。

---

### (00:26:01) Ami Vora

**English:**
Especially if you want to do something dramatically different. Really, I think the biggest service for people who are starting out a little earlier is that point around bringing the recommendation, really having the opinion and standing behind it with conviction and doing what they need to do to build that conviction for themselves.

**中文翻译:**
尤其是当你想要做一些翻天覆地的改变时。真的，我认为对于那些起步较早的人来说，最大的帮助就是我提到的关于“带来建议”的那一点：真正拥有自己的观点，坚定地支持它，并尽其所能为自己建立这种信念。

---

### (00:26:22) Lenny Rachitsky

**English:**
Awesome. You've done this a number of times already in this conversation, and so I want to spend a little time here, which is using metaphors and imagery to make your point and get people to understand what you're trying to say. So you have this code of putting on the coat of the job and this dinosaur brain, and so someone told me that this is just a skill you have where you use metaphor and imagery to rally your team, get your point across, get people to understand what you're trying to say. There's also this metaphor, someone told me I need to ask you about the hill climb metaphor. Does that ring a bell?

**中文翻译:**
太棒了。在这次对话中你已经多次展示了这一点，所以我想在这里多花点时间，即：利用隐喻和意象来阐述观点，并让人们理解你想表达的意思。你提到了“穿上工作的外套”和“恐龙脑”，有人告诉我这是你的一项技能，你擅长用隐喻和意象来凝聚团队、传达观点、让大家理解你的意思。还有一个隐喻，有人告诉我一定要问问你关于“爬坡”（Hill Climb）的隐喻。你有印象吗？

---

### (00:26:52) Ami Vora

**English:**
Yeah.

**中文翻译:**
有的。

---

### (00:26:53) Lenny Rachitsky

**English:**
Okay, what is that all about?

**中文翻译:**
好，那到底是怎么回事？

---

### (00:26:55) Ami Vora

**English:**
For me, the hill climb is all about the difference between the local optimum and a global optimum. That sounds very abstract, but I think a lot of the time when we're doing our job, when we're doing life stuff, whatever you're doing, you try to just get better and better and you optimize your current system and then you feel really good about it, and that is great. You're standing on top of the hill, you're looking down, you can see the, I don't know, rolling hills, the sheep, the grass, whatever. But then way off from the distance you can see a mountain, one that's even higher than you can't even see the top of it, and you have to decide, are you going to take the risk of climbing down your hill, crossing an unknown chasm, and then climbing back up, just to get to the same level you started at with more climbing to do to get to that summit? And that is really hard.

**中文翻译:**
对我来说，“爬坡”的核心在于局部最优和全局最优之间的区别。这听起来很抽象，但我认为很多时候当我们工作、生活或做任何事情时，我们只是试图变得越来越好，优化当前的系统，然后感觉非常棒，这很好。你站在山丘顶上向下看，能看到起伏的丘陵、羊群、草地等等。但在遥远的远方，你能看到一座大山，一座更高、甚至看不见顶峰的山。你必须决定：你是否愿意冒险走下现在的山丘，跨越未知的深渊（Chasm），然后再往上爬，仅仅是为了回到你开始时的那个高度，并且还要继续攀登才能到达那个巅峰？这真的很难。

---

### (00:27:51) Ami Vora

**English:**
I'm thinking of things like, maybe the first time I saw this was like a lot of companies were really good at desktop and you could see the mobile mountain way out over there, but to get there you had to really make a lot of trade-offs in your core desktop business that you were not totally sure were going to pay off when you made it to the mobile mountain, and you had to do a ton of work. You had to fundamentally rewire a lot of what you're doing without a guarantee that you're going to get there. I mean, you can see it in life when you think about new jobs or new moves or new relationships, anything that you think about. You are giving up something that is working pretty well without knowing whether you're going to make it to the top of that next mountain. And that's been really helpful to me just to place where I am on different things, where you get the inkling that there is a much better way to do this, there really is.

**中文翻译:**
我想起了一些例子，也许我第一次看到这种情况是很多公司在桌面端做得非常好，你能看到远处的移动端大山。但要到达那里，你必须在核心桌面业务上做出很多权衡，而你并不完全确定当你到达移动端大山时，这些权衡是否会有回报。你必须做大量的工作，必须从根本上重新构建你的业务，而没有任何保证你能到达那里。在生活中也是如此，当你考虑新工作、搬家或新的人际关系时，你正在放弃一些运作良好的东西，却不知道自己是否能登上下一座山的顶峰。这对我很有帮助，让我能定位自己在不同事情上的位置，当你察觉到有一种更好的方式时，真的有一种更好的方式。

---

### (00:28:48) Ami Vora

**English:**
Is it going to be worth going down into the valley, climbing up, keeping climbing? Is that going to be worth it? Most of the time the answer is yes, but it's helpful for me to know, boy, this feels like a slog. It is supposed to? Because I'm still in the valley and the thing that gets me through the valley is remembering what the summit feels like. When you're on top of it and you're like, this is great, it was absolutely worth it. My life is better in these ways, we're able to solve these problems in these ways. It was worth it.

**中文翻译:**
走下山谷、向上攀登、持续攀登，这值得吗？大多数时候答案是肯定的。但对我来说，知道“天哪，这感觉像是在苦熬”是很有帮助的。这正常吗？是的，因为我还在山谷里。支撑我走过山谷的是记住巅峰的感觉。当你站在顶峰时，你会觉得：“这太棒了，绝对值得。我的生活在这些方面变得更好了，我们能以这些方式解决这些问题。一切都值得。”

---

### (00:29:19) Lenny Rachitsky

**English:**
I love that. It feels like a big value of the metaphor, which I love is that to set expectations, it's going to be really hard for a little bit or we will slow down what we're trying to do now, but the idea is there's a bigger hill and a bigger mountain.

**中文翻译:**
我喜欢这个。这个隐喻的一大价值在于设定预期：在一段时间内会非常艰难，或者我们会放慢现在的进度，但核心思想是，前方有一座更大的山丘和更高的山峰。

---

### (00:29:32) Ami Vora

**English:**
It's a bigger hill and it's worth it.

**中文翻译:**
那是一座更大的山，而且值得去爬。

---

### (00:29:34) Lenny Rachitsky

**English:**
On this kind of broader idea of metaphors and imagery, is there something there that you've learned of just like, this works really well, I'm going to invest in becoming better at this, or is this something that's come natural to you? Anything you can share about that skill and approach?

**中文翻译:**
关于隐喻和意象这个更广泛的概念，你是否学到了什么，比如“这非常奏效，我要投入精力变得更擅长”，还是说这是你天生就有的能力？关于这项技能和方法，你有什么可以分享的吗？

---

### (00:29:46) Ami Vora

**English:**
I think this one came from, I worked for a manager, his name was Eric Antino, and he was just a master of the metaphor and analogies. And so whenever I would bring him something, he would be like, how is this product going to make you feel, and when is the last time that you felt this way? And you can say, oh, I felt this way when I was hanging with my friends in Dolores Park and he'd be like, cool, tell me what it feels like, why that's the analogy, what ramifications come out of that?

**中文翻译:**
我想这源于我曾为一位名叫 Eric Antino 的经理工作，他简直是隐喻和类比的大师。每当我带给他一些东西时，他都会问：“这个产品会让你有什么感觉？你上一次有这种感觉是什么时候？”你可以说：“噢，当我和朋友在多洛雷斯公园闲逛时我有这种感觉。”他会说：“酷，告诉我那是种什么感觉，为什么用这个类比，这会带来什么后果？”

---

### (00:30:18) Ami Vora

**English:**
One thing I like to do is try to build an emulator for different people in my head, because I've just had the good fortune of working with an amazing number of very different leaders, and so he's one of the people I tried to build an emulator for where I'd be like, okay, I see this thing. I don't know how to solve this problem. How would Eric describe this? I've tried to build one for Boz, which is all about principle of decision making and principle of trade-offs. There's a few other people where I'm like, I don't know how to solve this problem. Can I load this other person into my head and how would they approach it? And that gives me a fresh lens on it.

**中文翻译:**
我喜欢做的一件事是在脑子里为不同的人建立“模拟器”（Emulator），因为我有幸与许多非常不同的领导者共事过。他就是我尝试建立模拟器的人之一，我会想：“好，我看到了这件事。我不知道该怎么解决。Eric 会怎么描述它？”我也尝试为 Boz 建立一个，他的核心是决策原则和权衡原则。还有其他几个人，当我不知道如何解决问题时，我会想：“我能不能把这个人的思维模式加载到我脑子里，他们会怎么处理？”这给了我一个全新的视角。

---

### (00:30:55) Ami Vora

**English:**
And I really like metaphors and analogies because I think especially as you scale a team, narrative becomes increasingly important. Narrative can carry so much weight and water where otherwise it's similar to the product review point, where either you can tell everybody exactly what to do at every point or you can create a story that we all agree on. And when we all agree on that story, people just know better what to do. If we all agree that the feeling of something should be, I'm sitting in Dolores Park with my friends on a sunny Saturday. You know what the iconography, the designers know what iconography should look like. You know what the communication and join pattern should look like. You're not going to build something cold and corporate, you're not going to build something strobe light, you're not going to build something flashy, but you don't have to go and make all those individual decisions. You can buy into the same story and then people will just naturally build something that feels more consistent.

**中文翻译:**
我非常喜欢隐喻和类比，因为我认为特别是在扩大团队规模时，叙事（Narrative）变得越来越重要。叙事可以承载巨大的力量，否则就像产品评审时那样：你要么在每一点上都告诉每个人该做什么，要么创造一个我们都认同的故事。当我们都认同那个故事时，人们就更清楚该做什么。如果我们都认同某种感觉应该是“阳光明媚的周六和朋友坐在多洛雷斯公园”，那么设计师就知道图标应该长什么样，你就知道沟通和加入模式应该是什么样。你不会做出冷冰冰的、充满企业感的东西，不会做出闪烁刺眼的东西，也不会做出花哨的东西，而且你不需要去参与每一个细小的决定。大家认同同一个故事，自然而然就会做出感觉更一致的东西。

---

### (00:31:56) Lenny Rachitsky

**English:**
This is such a powerful and important skill. Is there an example that comes to mind where you did this really well, say at WhatsApp or Facebook of the story that carried a lot of water for you and the team?

**中文翻译:**
这真是一项强大且重要的技能。你能想到一个你做得特别好的例子吗？比如在 WhatsApp 或 Facebook，有没有哪个故事为你和团队发挥了巨大的作用？

---

### (00:32:08) Ami Vora

**English:**
Yeah, I mean I think the product metaphor we arrived at for WhatsApp was face-to-face communication. Our goal there was to make it so that every person in the world could feel connected to the people they cared most about, even when they were separate, even they're distant geographically for whatever reason, we were always going to be apart from the people you cared about. And we really had to build something that would work for literally everyone in the world. People who are carrying these high-end devices in western markets who are very tech comfortable and savvy, and people in the low end markets who were carrying these low end devices, they weren't that familiar with technology, it was maybe their first time online. We had to build something that worked for everyone.

**中文翻译:**
是的，我想我们在 WhatsApp 确立的产品隐喻是“面对面沟通”。我们的目标是让世界上每一个人都能感受到与他们最关心的人的连接，即使他们身处异地，即使因为各种原因在地理上相隔遥远。我们必须构建出真正适用于全球每一个人的产品。既包括西方市场使用高端设备、对技术非常熟悉的人，也包括低端市场使用低端设备、对技术不太熟悉、甚至是第一次上网的人。我们必须做出一个对所有人都有效的东西。

---

### (00:32:57) Ami Vora

**English:**
And the most universal form of communication is face-to-face. When you talk to someone face-to-face, you're not thinking, how do I present? What tool do I have to learn? You just open your mouth and words come out, and that's the feeling that we wanted to create. And that involved a lot of the app stepping back from communication, creating spaces that felt really intimate so people wouldn't have to think to themselves, what kind of space am I in? They could immediately map where they were in the app to the, okay, I'm sitting around in my kitchen table and people are joining and leaving calls just like they're walking in and out of my living room, but it is a family space and the family is there. Or, in one-on-one disappearing messages, you're like, cool, this is my close friend. We don't need to keep track of everything that we're saying. We're here for a little bit of banter, a little bit of relationship, a little bit of quick, what's your wifi password and stuff, and whatever's really important, that's what we'll hold onto and the rest is just day-to-day, normal intimacy.

**中文翻译:**
而最普遍的沟通形式就是面对面。当你和某人面对面交谈时，你不会想：“我该如何表现？我得学习什么工具？”你只需张开嘴，话就说出来了。这就是我们想要创造的感觉。这涉及到让应用从沟通中“退后”，创造出感觉非常亲密的场景，让人们不必思考：“我处于什么样的空间？”他们可以立即将应用中的位置映射到现实：“好，我正坐在厨房桌子旁，人们加入和离开通话，就像他们走进和走出我的客厅一样，但这是一个家庭空间，家人都在这里。”或者在 1-on-1 的阅后即焚消息中，你会觉得：“酷，这是我的密友。我们不需要记录说的每一句话。我们只是在这里闲聊、维系感情、问问 WiFi 密码之类的，真正重要的东西我们会保留，其余的只是日常的、自然的亲密感。”

---

### (00:33:58) Lenny Rachitsky

**English:**
That is super interesting. WhatsApp, one of the main differentiators and benefits is it's super fast. And I see completely how it connects this idea of you're just like, ideas, we want you to feel like you're talking to someone.

**中文翻译:**
这非常有趣。WhatsApp 的主要优势和差异化之一就是它超级快。我完全理解这如何连接到那个想法：我们希望你感觉就像在和某人实时交谈。

---

### (00:34:09) Ami Vora

**English:**
And it's all really a small thing. It's like a typing indicator is like someone who's about to take a breath, give them a second to talk, the two check marks lighting up or someone's face lighting up when they hear you, it's just a recognition of being heard. These are all super small things, but I think they add up to a feeling of being there.

**中文翻译:**
这其实都是些小细节。比如“正在输入”的提示，就像某人正准备深吸一口气说话，给他们一秒钟时间；两个勾选标记亮起，就像某人听到你说话时脸庞亮起，这是一种“被听到”的确认。这些都是极小的事情，但我认为它们累积成了一种“身临其境”的感觉。

---

### (00:34:29) Lenny Rachitsky

**English:**
That is super interesting. So I love this very tactical piece of advice that you just shared of just when you're trying to come up with a metaphor or analogy, think about what you want your users to feel when you're using the product and when else have they felt that same feeling? So interesting. And then this other point you made of making this emulator of a person in your head.

**中文翻译:**
这太有趣了。我非常喜欢你刚才分享的这个战术性建议：当你尝试构思隐喻或类比时，思考你希望用户在使用产品时有什么感受，以及他们还在什么时候有过同样的感受？太有意思了。还有你提到的在脑子里建立一个人的“模拟器”。

---

### (00:34:49) Ami Vora

**English:**
I mean, it sounds a little wild now that I think about it.

**中文翻译:**
我是说，现在想起来这听起来有点疯狂。

---

### (00:34:51) Lenny Rachitsky

**English:**
No.

**中文翻译:**
不。

---

### (00:34:51) Ami Vora

**English:**
That's robotic.

**中文翻译:**
这听起来很像机器人。

---

### (00:34:52) Lenny Rachitsky

**English:**
It makes total sense.

**中文翻译:**
但这完全说得通。

---

### (00:34:55) Ami Vora

**English:**
I get very bored a lot. It's another way to make sure meetings are really interesting where you're like, okay, let me see what that person is going to say next. Let me put myself in their shoes. Let me think about what they're reacting to and why they're going to think that and how they're going to see the world. And again, it just gives me more toolkits because it means when I'm stumped on something, I can be like, what would Rob Goldman say? He'd say, look at the dashboard. Have I looked at the dashboard? No. Okay, let me go look at the dashboard. You can load up these different skillsets that people have been so generous with sharing with me.

**中文翻译:**
我经常感到无聊。这是确保会议有趣的另一种方式，你会想：“好，让我看看那个人接下来会说什么。让我设身处地为他想想。让我思考他在对什么做出反应，他为什么会那样想，他如何看待世界。”这又给了我更多的工具箱，因为这意味着当我被难住时，我可以想：“Rob Goldman 会怎么说？他会说‘看仪表盘’。我看仪表盘了吗？没有。好，让我去看仪表盘。”你可以加载这些人们慷慨分享给我的不同技能集。

---

### (00:35:28) Lenny Rachitsky

**English:**
What would be the Ami emulator? What are people thinking when they loaded it?

**中文翻译:**
那“Ami 模拟器”会是什么样的？人们加载它时会想到什么？

---

### (00:35:33) Ami Vora

**English:**
Fascinating.

**中文翻译:**
太有意思了（Fascinating）。

---

### (00:35:33) Lenny Rachitsky

**English:**
Fascinating?

**中文翻译:**
太有意思了？

---

### (00:35:35) Ami Vora

**English:**
Fascinating, probably the number one, no joke.

**中文翻译:**
“太有意思了”，绝对是排第一的，没开玩笑。

---

### (00:35:37) Lenny Rachitsky

**English:**
Is there an emulator you most often come back to that you find most useful in just in your day-to-day? Who's the person that like, oh yeah-

**中文翻译:**
有没有哪个模拟器是你日常最常使用、觉得最有用的？那个人是谁？

---

### (00:35:44) Ami Vora

**English:**
I think those are the three. I think it is like Antino's story. Story, metaphor, analogy creation. I think it's like Boz's, if we played this out, what principles are we using? And if we kept on using those principles, what would happen? And it is Rob Goldman, who's an amazing metrics growth product leader being like, look at the dashboard. I mean, look at the dashboard, which is a great central rooting part of my life.

**中文翻译:**
我想就是那三个。Antino 的故事、隐喻和类比创作。Boz 的“如果我们这样做，我们遵循的是什么原则？如果我们继续遵循这些原则，会发生什么？”还有 Rob Goldman，他是一位了不起的指标增长产品领导者，他总是说“看仪表盘”。看仪表盘是我生活中一个非常核心的基础部分。

---

### (00:36:16) Lenny Rachitsky

**English:**
This was so fascinating, fascinating.

**中文翻译:**
这太有意思了，太有意思了。

---

### (00:36:19) Ami Vora

**English:**
It revs up.

**中文翻译:**
渐入佳境。

---

### (00:36:20) Lenny Rachitsky

**English:**
I love this topic of just metaphors and stories and visions and things like that. It's something that a lot of people are wanting to get better at. Is there another example, per chance, that you could share of maybe using a metaphor to rally team, get things done?

**中文翻译:**
我喜欢关于隐喻、故事和愿景之类的话题。这是很多人都想变得更擅长的。你还能再分享一个例子吗？也许是利用隐喻来凝聚团队、完成任务的例子？

---

### (00:36:34) Ami Vora

**English:**
I mean, I think taking a sub part of WhatsApp or when we talk about video calling. I really, one the metaphors was sitting around in your family room when you think about how to make calls work, where when you're sitting in a family room, you're not scheduling it, you're not, I don't know, having this cold corporate feeling, the way you do with a conference where there's heavyweight interactions, and instead there's just, you can join and leave. It feels lightweight, it feels like the space exists even when you're not there. And so just creating things like joinable calls, like that feeling of people popping in and just paying attention to whoever's there and letting them leave, but the call can flow on without a super heavyweight action that everyone needs to take. I think that was another one where we were just able to agree on the feeling and then you know what to build.

**中文翻译:**
我想想，比如 WhatsApp 的一个子功能，或者当我们谈论视频通话时。其中一个隐喻是“坐在家里的起居室”。当你思考如何让通话运作时，如果你坐在起居室里，你不会去预约它，你不会有那种冷冰冰的企业感，不像参加那种有沉重交互感的会议。相反，你可以随时加入和离开。它感觉很轻盈，感觉即使你不在那里，那个空间也依然存在。所以我们创造了像“可加入通话”这样的功能，那种人们随时进来、关注在场的人、然后离开的感觉，通话可以继续进行，而不需要每个人都执行某种沉重的操作。我认为那是另一个例子，我们只需对感觉达成一致，然后你就知道该构建什么了。

---

### (00:37:27) Lenny Rachitsky

**English:**
I was just using WhatsApp to do video call with my mom. They were traveling to Italy and so-

**中文翻译:**
我刚才还在用 WhatsApp 和我妈视频通话。他们正在意大利旅行，所以……

---

### (00:37:30) Ami Vora

**English:**
That's great, that's exactly [inaudible 00:37:33].

**中文翻译:**
太棒了，那正是……（听不清）

---

### (00:37:32) Lenny Rachitsky

**English:**
I experienced it, it felt great.

**中文翻译:**
我体验到了，感觉很棒。

---

### (00:37:35) Lenny Rachitsky

**English:**
Let me go in a slightly different direction. One of my favorite posts of yours is called execution beats strategy every time, and I think another way you phrase it is, execution eats strategy for breakfast. I think you put that somewhere. I'd love to hear about this because I completely agree. I think a lot of people obsess with strategy and vision and got to get this right and forget that most of the work is execution. So yeah, I'd love to hear just your take and insight here.

**中文翻译:**
让我换个话题。我最喜欢的你的一篇文章叫《执行力每次都胜过战略》，我想你还有另一种表达方式：“执行力把战略当早餐吃了”（Execution eats strategy for breakfast）。我想你在哪里写过。我很想听听这个，因为我完全同意。我认为很多人痴迷于战略和愿景，觉得必须把这些搞对，却忘了大部分工作其实是执行。所以，我很想听听你的看法和见解。

---

### (00:37:58) Ami Vora

**English:**
Yeah, I don't know if I coined execution eats strategy for breakfast, I think a lot of things eat other things for breakfast, but I'm a believer. I do think execution eats strategy for breakfast and that's something we used to say a lot at Meta. It was just the most important part and I was well-trained in that. That was one of the key lessons that I learned there, and it's because when you have... Look, strategy is super fun. You get to think about all this pie in the sky stuff. You get to think about if the world operated in rational patterns and you could predict the future, what is going to be the second and third order effect? You get to use your brain in a really fun, philosophical way, but customers don't care. Customers don't care about your fancy strategies and your five-year plan. They care about the product that's in their hands. And so anything that distracts you from thinking about the product in your hands I think, or maybe worse, takes you away from solving customer's problems today, I think is a distraction.

**中文翻译:**
是的，我不知道“执行力把战略当早餐吃了”是不是我发明的，我想很多东西都会把别的东西当早餐吃，但我深信不疑。我确实认为执行力胜过战略，这是我们在 Meta 经常说的一句话。那是核心部分，我也在那方面受过良好的训练。那是我在那里学到的关键教训之一。原因在于……听着，战略非常有趣。你可以思考各种宏大的蓝图。你可以思考如果世界按理性模式运行且你能预测未来，二阶和三阶效应会是什么？你可以以一种非常有趣、哲学的方式使用大脑，但客户不在乎。客户不在乎你华丽的战略和五年计划。他们在乎的是手里拿到的产品。所以，任何让你分心、不去思考手中产品的事情，或者更糟的是，让你无法解决客户今天面临的问题的事情，我认为都是干扰。

---

### (00:39:03) Ami Vora

**English:**
And I think one of the things that you learn is if you have great strategy, perfect strategy but poor execution, you don't win because your strategy never makes it to the market. And what's even worse is that you have learned nothing. You don't know whether it was your strategy that was wrong or whether it was your execution that was wrong, all you know is you didn't win. Whereas when you have a pretty good strategy, a good enough strategy, you're in the right direction and you have perfect execution, you still don't win immediately, but you know your execution was great. So then you learn, what do you need to do to improve your strategy? You've got the execution machine, you go back, you update your strategy, you relaunch, and you keep on doing it until your strategy is perfect and then you do win. And that's the lesson I repeatedly learned.

**中文翻译:**
我认为你学到的一件事是：如果你有伟大的战略、完美的战略，但执行力很差，你赢不了，因为你的战略永远无法推向市场。更糟糕的是，你什么也没学到。你不知道是战略错了，还是执行错了，你只知道你没赢。而当你有一个相当不错的战略、一个足够好的战略，方向是对的，并且你有完美的执行力，你可能也不会立即获胜，但你知道你的执行力很棒。于是你学到了：你需要做些什么来改进战略？你拥有执行机器，你回去更新战略，重新发布，不断重复，直到战略变得完美，然后你就赢了。这就是我反复学到的教训。

---

### (00:39:50) Lenny Rachitsky

**English:**
Is this advice a reaction to what you said, where people, PMs let's say, are just like, I want to work on strategy, we got to spend all this time, get the strategy nailed, and it's just like, okay, we also need to execute and that's maybe even more important.

**中文翻译:**
这个建议是对你刚才所说情况的回应吗？比如产品经理（PM）们会说：“我想做战略，我们要花大量时间把战略定死。”而现实是：“好，我们也需要执行，而且执行可能更重要。”

---

### (00:40:02) Ami Vora

**English:**
Yeah, I do think it is very glamorous to work on strategy. It's so fun. It's so fun to have the word strategy in your [inaudible 00:40:11]. I don't know, we've built a mythology around strategy being the most important thing. And execution is not glamorous, it is not like white-boarding by yourself and pointing to things and coming out with the grand vision. It is the nuts and bolts and sometimes boring, sometimes grind it out work of like, you got to bring the donuts, you got to look at the dashboards, you got to rewrite the spec. You got to just do a bunch of the grinding, but that is what leads to the customer's outcomes. That is what the customer is eventually going to feel. They're never going to see the whiteboard, they're going to see that someone took the time to fix this bug.

**中文翻译:**
是的，我认为做战略确实感觉很光鲜。它很有趣。在你的（听不清）里有“战略”这个词很有趣。我不知道为什么，我们围绕“战略是最重要的事情”建立了一种神话。而执行并不光鲜，它不像你一个人在白板前指指点点，构思宏伟愿景。它是琐碎的、有时是乏味的、有时是磨人的工作，比如：你得去买甜甜圈（指琐碎的后勤），你得看仪表盘，你得重写规格说明书。你必须做大量的磨人工作，但那才是带来客户结果的东西。那是客户最终会感受到的东西。他们永远看不到白板，他们只会看到有人花时间修复了这个 Bug。

---

### (00:40:53) Lenny Rachitsky

**English:**
This episode is brought to you by User Testing, transform how you build products and experiences with User Testing. Get fast feedback throughout the development process so that you can build the right thing the first time, make better decisions that lead to better business outcomes.

**中文翻译:**
本集节目由 User Testing 赞助。使用 User Testing 改变你构建产品和体验的方式。在整个开发过程中获得快速反馈，以便你第一次就能做对，做出能带来更好业务结果的明智决策。

---

### (00:41:11) Lenny Rachitsky

**English:**
Companies are being asked to do more with less. They need to move quickly to build experiences that meet changing customer expectations and do so faster than ever, all while minimizing risk and costly rework. With User Testing, you have a trusted partner in experience research. They empower user research, product and design teams to make higher confidence decisions with human insights. Learn more today at usertesting.com/lenny.

**中文翻译:**
现在的公司被要求用更少的资源做更多的事。他们需要快速行动，构建满足不断变化的客户预期的体验，并且要比以往任何时候都快，同时还要尽量减少风险和昂贵的返工。有了 User Testing，你就拥有了一个值得信赖的体验研究合作伙伴。他们通过人类洞察力，赋能用户研究、产品和设计团队做出更有信心的决策。立即访问 usertesting.com/lenny 了解更多信息。

---

### (00:41:39) Lenny Rachitsky

**English:**
Is this advice you give to your PMs on your teams? I guess, how do you think about this when they're trying to move up the ranks, become better product managers? Is this just a common thing that you often share, like yeah, strategy is going to be amazing, important. You got to get good at it, but also make sure this is going great.

**中文翻译:**
这是你给团队里的产品经理们的建议吗？当他们想要晋升、成为更好的产品经理时，你是怎么考虑这一点的？这是你经常分享的常识吗？比如：“是的，战略会很棒、很重要。你必须擅长它，但也要确保执行得很好。”

---

### (00:41:57) Ami Vora

**English:**
Yeah, I think about it a little bit in terms of proportion of time you should expect to spend. So I mean, there's no point next being on that strategy, you can't have a bad strategy. So you should spend some time, maybe it's like 20% of your time, but the bulk of your time should be confirming that strategy actually makes sense for the customers. Getting it out there, building the machine to constantly make it better, as opposed to a perfect strategy. You go away, you build it for a year, you ship it, the market has changed. Customers have changed, their needs have changed, competition, just the whole landscape has changed and you probably could have solved those problems more easily had you headed in the right direction, but done it with more ongoing customer feedback.

**中文翻译:**
是的，我会从你应该投入的时间比例来考虑。我的意思是，战略不能出错，你不能有一个糟糕的战略。所以你应该花一些时间，也许是 20% 的时间，但你大部分的时间应该用来确认该战略对客户是否真的有意义。把它推向市场，建立不断改进它的机制，而不是追求一个“完美的战略”。你躲起来闭门造车一年，发布时市场已经变了。客户变了，需求变了，竞争对手变了，整个格局都变了。如果你当初朝着正确的方向前进，并结合持续的客户反馈，你本可以更轻松地解决这些问题。

---

### (00:42:39) Lenny Rachitsky

**English:**
In terms of this proportion, I imagine what you see is as you get more senior, more of your time spent on strategy, less time on execution, right?

**中文翻译:**
关于这个比例，我猜你看到的是：随着职位越来越高，花在战略上的时间越多，花在执行上的时间越少，对吗？

---

### (00:42:46) Ami Vora

**English:**
I don't 100% know that that's true. I think again, even at high levels, maybe the strategic directions become more important to get mostly right, but I think still most of your time is making sure they can make it to market. I think you should still be spending your time understanding what's slowing people down and unblocking it. Understanding, how is the market changing? Understanding what the broad customer feedback is, just constantly improving the system that you are building. I think that's, I mean, how much time can you spend thinking about the future, as opposed to actually trying to create it.

**中文翻译:**
我不百分之百确定那是真的。我认为即使在高层，虽然确保战略方向大致正确变得更重要，但你大部分的时间仍然是确保它们能推向市场。我认为你仍然应该花时间去理解是什么拖慢了大家的进度并扫除障碍。理解市场是如何变化的，理解广泛的客户反馈，不断改进你正在构建的系统。我的意思是，比起实际去创造未来，你到底能花多少时间去“思考”未来呢？

---

### (00:43:29) Lenny Rachitsky

**English:**
That is really interesting advice because I think most people imagine as you get more senior, I'm going to have more time thinking about vision and strategy, not have to be in the weeds building things. And I love this point you're making of even as a senior exec, you're still, it's executing in a different way, but it's still execution.

**中文翻译:**
这真的是非常有趣的建议，因为我想大多数人想象的是：随着职位升高，我会有更多时间思考愿景和战略，不必再深陷于具体的构建工作中。我喜欢你提出的观点：即使作为高级主管，你仍然在执行，只是方式不同，但它本质上仍然是执行。

---

### (00:43:44) Ami Vora

**English:**
A different way, yeah. You're focusing on the execution of the system a little bit more, but you got to stay connected, I think, to the customer and to what you're bringing to them.

**中文翻译:**
是的，方式不同。你会更多地关注“系统”的执行，但我认为你必须保持与客户的联系，保持与你带给他们的价值的联系。

---

### (00:43:54) Lenny Rachitsky

**English:**
I love that. Obviously, strategy is also very important. You have this great quote that I'm going to read here. "For strategy to be useful, it actually has to change our behavior as a team to create better customer outcomes." Can you talk about that?

**中文翻译:**
我喜欢这个。显然，战略也非常重要。你有一句很棒的话，我在这里读一下：“战略若要发挥作用，它实际上必须改变我们团队的行为，从而创造更好的客户结果。”你能谈谈这个吗？

---

### (00:44:08) Ami Vora

**English:**
Yeah. I mean, I think again, some of the joy of strategy is the philosophy and excitement of thinking about all the long-term stuff that will happen, but I try to always come back to, what's going to change for the customer? If we have all of these conversations and we come out with this shiny five-year plan, but then we change nothing about the products that we're building or how we are building, what was the point of that exercise? It made us feel good, and there's something to making us feel good. That is good, it's important for teams to feel good and connected and this is a good exercise for that, but it's so much more powerful when it's an exercise that translates into us doing something differently, whether that's prioritizing different products, whether that's changing our portfolio allocation, like moving people to the things we think are most important now versus things that are going to be less important right now. What's the change, or coming out with a strategy that'll align people because we have the story, we have the narrative, we have the sequence. What's going to change for our customers as a result of this strategy exercise?

**中文翻译:**
是的。我想再次强调，战略的一部分乐趣在于思考长期愿景时的那种哲学感和兴奋感。但我总是尝试回到原点：客户会发生什么变化？如果我们进行了所有这些对话，制定了一个光鲜亮丽的五年计划，但随后我们构建的产品或构建方式没有任何改变，那么这个过程的意义何在？它让我们感觉良好，感觉良好确实有其价值，让团队感到连接和振奋很重要，这确实是一个很好的练习。但如果这个练习能转化为我们采取不同的行动，它的力量会大得多。无论是优先考虑不同的产品，还是改变我们的投资组合分配（比如把人手调往现在最重要的事，而不是目前次要的事）。改变是什么？或者是制定一个能让大家对齐的战略，因为我们有了故事、有了叙事、有了顺序。作为这次战略演练的结果，我们的客户会发生什么改变？

---

### (00:45:12) Lenny Rachitsky

**English:**
Many people want to get better at strategy. Often their performance feedback is become more strategic, think better about strategy. What has helped you become a better strategic thinker? Is it just doing it? Is it a person that influenced you heavily? Is it a book? What has helped you and what do you often recommend to people to get better at this skill?

**中文翻译:**
很多人都想变得更擅长战略。通常他们的绩效反馈是“变得更具战略性”、“更好地思考战略”。是什么帮助你成为了一个更好的战略思考者？是仅仅通过实践吗？是某个对你影响很大的人吗？还是一本书？是什么帮助了你，你通常推荐人们如何提升这项技能？

---

### (00:45:30) Ami Vora

**English:**
I think I got that same feedback quite a lot, actually, of needing to think bigger and be more visionary, etc. And I still do, frankly, actually, there's moments where I retrench way too far into execution and worry a little less about long-term strategy. So it's definitely my bias still.

**中文翻译:**
实际上，我也经常收到同样的反馈，说需要想得更远、更有远见等等。坦白说，我现在依然如此。有些时刻我会过度陷入执行，而较少关注长期战略。所以这仍然是我的偏好。

---

### (00:45:49) Ami Vora

**English:**
The biggest thing that held me back from talking about strategy was I didn't feel confident that I knew enough to declare a strategy. It was actually almost like a self-confidence, imposter syndrome thing, where there were people who could just say, I know how the world is going to develop in the next five years, and let me tell you, here's where we're going to be, this is the dot on the map. And I was always like, how could anything could happen? Who would I be to say I know how the world's going to develop and here's where we're heading?

**中文翻译:**
阻碍我谈论战略的最大因素是我不觉得自己有足够的信心去宣称一个战略。这实际上几乎是一种自信心问题，或者说是“冒充者综合征”（Imposter Syndrome）。有些人可以随口说出：“我知道未来五年世界会如何发展，让我告诉你，我们会在这个位置，这就是地图上的那个点。”而我总是想：“怎么可能？任何事情都可能发生。我凭什么说我知道世界会如何发展，我们要走向何方？”

---

### (00:46:21) Ami Vora

**English:**
And so for me, a lot of it was actually learning the things that made me feel confident in my own opinion. And there's a bunch of things that do make me feel confident in my opinion. When I talk to specific customers and I feel like I can build an emulator for them, like a customer on my shoulder where I can say, oh, I talked to this person working in this job, here's what they would say if I showed them this product or this strategy. So, I think talking to customers is a big unlock for me and feeling like I have unique knowledge of the customer. I think working through different product iterations of, if we thought this was the right outcome, what would it really look like from a product perspective or a product portfolio in three to five years? And which of those seems right or rational or it will go the way I think the world goes. I think asking for other opinions. Sometimes I run surveys to the leadership team where I'm just like, what percentage of our revenue is going to come from small businesses versus big businesses in three years? And if we all agree on that topic, we should just take it as the truth and we should just fill it. If we disagree, then we should talk about it and we should talk about the strategic ramifications if we chose one path or the other path.

**中文翻译:**
所以对我来说，很大一部分实际上是学习那些让我对自己的观点感到自信的东西。有很多事情确实能让我感到自信。当我与特定的客户交谈时，我觉得我可以为他们建立一个“模拟器”，就像肩膀上坐着一个客户，我可以想：“噢，我跟做这份工作的人聊过，如果我给他们看这个产品或战略，他们会这么说。”所以，与客户交谈对我来说是一个巨大的突破口，让我觉得我对客户有独特的了解。我会思考不同的产品迭代：如果我们认为这是正确的结果，那么从产品视角或产品组合来看，三到五年后它到底长什么样？其中哪一个看起来是正确或理性的，或者符合我对世界走向的预期。我还会征求其他意见。有时我会对领导团队进行调查，比如：“三年后我们有多少收入将来自小企业，多少来自大企业？”如果我们都认同，我们就把它当作事实去执行。如果我们有分歧，我们就讨论它，讨论选择这条路或那条路的战略后果。

---

### (00:47:35) Ami Vora

**English:**
So for me, it was getting more comfortable having an opinion, honestly, about how the world was going to go, and also feeling comfortable that we would be able to change it when we learned that maybe that wasn't exactly right. We would have the machine, the execution machine behind it to try it out and then change and iterate and improve with customer feedback.

**中文翻译:**
所以对我来说，关键在于坦诚地对世界走向发表见解时感到更自在，并且在发现见解不完全正确时，也能坦然地去改变它。我们背后有执行机器，可以去尝试，然后根据客户反馈进行改变、迭代和改进。

---

### (00:47:59) Lenny Rachitsky

**English:**
At which point in your career was this overcoming this fear and uncertainty? Was it sometime within Facebook?

**中文翻译:**
在你职业生涯的哪个阶段克服了这种恐惧和不确定性？是在 Facebook 期间吗？

---

### (00:48:07) Ami Vora

**English:**
It was sometime within Facebook. It was really when I was stepping into the bigger ads jobs, getting to be Head of Product for Facebook ads. I got feedback, I got a lot of feedback over the course of my career and some of the stacking of feedback was basically like, you could be the smartest person in the room, but it doesn't matter if people don't like you, which is very complicated feedback and I wouldn't give that feedback to anyone else, but I took it very seriously. It was coming from so many different places, it was coming from people I'm really trusted. And so I went out of my way to be more likable, which for me ended up being shrinking myself a little bit and not being so aggressive and not being so opinionated, being more unobjectionable.

**中文翻译:**
是在 Facebook 期间。具体是在我接手更大的广告业务职位、成为 Facebook 广告产品负责人时。在我的职业生涯中，我收到了很多反馈，其中一些反馈堆叠起来的意思基本上是：“你可能是屋子里最聪明的人，但如果大家不喜欢你，那也没用。”这是一种非常复杂的反馈，我不会把这种反馈给别人，但我当时非常认真地对待它。它来自很多不同的渠道，来自我非常信任的人。于是我刻意让自己变得更讨人喜欢，对我来说，这最终变成了“缩小”自己，不再那么咄咄逼人，不再那么固执己见，变得更让人无可挑剔。

---

### (00:49:07) Ami Vora

**English:**
And the weird part is that it worked for a long time. People were more likely to work with me, they were more likely to say nice things. I mean, I take this to extremes. I wore earth tones for two years because I was just like, I got to fade back a little bit. And then at some point I actually had to do a leadership job and my team was like, well, what do you think? What's your opinion? And I was like, you've been telling me not to have an opinion for so long. And so it took a little bit of work to get back to, oh yeah, I have a lot of opinions, I have a lot of thoughts. It is okay for me to express. It is needed, my team needs me to have these opinions and thoughts and be a leader who can take ownership and be visible.

**中文翻译:**
奇怪的是，这在很长一段时间内都奏效了。人们更愿意和我合作，更愿意说好话。我甚至做到了极致：我有两年时间只穿大地色系的衣服，因为我觉得我得“淡化”自己的存在感。但到了某个阶段，我必须承担领导职责，我的团队问我：“那么，你怎么想？你的意见是什么？”我当时心想：“你们已经告诉我要没主见这么久了。”所以，我花了一些功夫才找回状态：“噢对了，我有很多想法，我有很多见解。表达出来是可以的。这是被需要的，我的团队需要我有这些见解和想法，需要我做一个敢于承担责任、有存在感的领导者。”

---

### (00:49:52) Lenny Rachitsky

**English:**
Thanks for sharing that. Do you think that was the right approach, going and indexing far to the other end and then realizing that maybe that's too far, or do you think you would've done things differently looking back?

**中文翻译:**
谢谢你的分享。你认为那是正确的方法吗？先走向另一个极端，然后意识到可能走得太远了。回过头来看，你觉得你会采取不同的做法吗？

---

### (00:50:05) Ami Vora

**English:**
Yeah, it's one of my Roman empires. I think about this every so often, way too much, I think. Especially because I talked to other senior women who received similar feedback and chose not to act on it or did act on it, and what happened to their paths were different. I think where I landed is I wouldn't give that feedback to someone else. And the way I do give that feedback, actually, because I think there is a lot of really useful information in that. The way I do give that feedback is, you do need to be able to work with a broader range of people and the way to do that is to expand your tool sets. You're not going to make yourself smaller, you're not going to be any less of who you are, but you are going to build new tools, new keys to unlock new different kinds of doors. And that is only going to make you bigger and more powerful and more expansive. But the end outcome is the same, is that you can work with more different styles of people, more different styles of problems.

**中文翻译:**
是的，这是我的“罗马帝国”之一（指经常思考的事情）。我经常想到这个，我想频率太高了。特别是因为我与其他收到类似反馈的资深女性交流过，她们有的选择不理会，有的选择了理会，而她们的职业路径各不相同。我现在的结论是，我不会把那种反馈给别人。但我确实会以另一种方式给出反馈，因为那里面确实包含很多有用的信息。我给出的方式是：你确实需要能够与更广泛的人群合作，而实现这一目标的方法是扩展你的“工具集”。你不需要缩小自己，不需要改变本色，但你要构建新的工具、新的钥匙去开启不同类型的门。这只会让你变得更强大、更有影响力、更开阔。最终结果是一样的：你可以应对更多不同风格的人和不同类型的问题。

---

### (00:51:08) Lenny Rachitsky

**English:**
I love that framing. There's an episode that's going to come out before this episode with this professor from Stanford, Jeffrey Pfeffer, who teaches a class called The Path to Power, which is how to become powerful in the world. And he actually has a big lesson that many people hate hearing, which is, you don't need to be authentic in the workplace, what you're trying to achieve, you're trying to achieve stuff and you can do... You need to use tools that you need to use to achieve the thing you want to achieve. So sometimes don't be exactly who you are and act in a slightly different way, which is basically what you're describing.

**中文翻译:**
我喜欢这个构架。在这一集之前会播出一集，嘉宾是斯坦福大学的 Jeffrey Pfeffer 教授，他教一门叫《权力之路》的课，讲的是如何在这个世界上获得权力。他实际上有一个很多人讨厌听到的重要教训：在职场中你不需要保持“真实”，你是在努力达成目标，你可以……你需要使用必要的工具来达成你想达成的目标。所以有时不要完全做你自己，而是以一种略微不同的方式行事，这基本上就是你所描述的。

---

### (00:51:42) Ami Vora

**English:**
More tools. I think that's a theme that's coming up, is just like, I'm all about more lenses, more keys, more tools in general because why not? Why not have access to more different styles of things?

**中文翻译:**
更多的工具。我想这是一个反复出现的主题：我非常推崇更多的视角、更多的钥匙、更多的工具，因为何乐而不为呢？为什么不让自己拥有更多应对不同风格事物的能力呢？

---

### (00:51:54) Lenny Rachitsky

**English:**
Something that you were talking about subtly is the being a woman in tech and being a female leader. I imagine you've gone through some stuff that isn't what something men would've gone through. Is there anything there that you want to share or anything you've learned about just being really successful as a woman in tech?

**中文翻译:**
你刚才微妙地谈到了作为科技界女性和女性领导者的话题。我猜你经历过一些男性不会经历的事情。关于作为一名成功的科技界女性，你有什么想分享的或者学到的经验吗？

---

### (00:52:13) Ami Vora

**English:**
I think we've talked through some of them. I think one, you get a different style of feedback and a lot of the ways to interpret that feedback. I think to this day, I get feedback that is about walking a very narrow tightrope where not only do you have to change a bunch of things and do a bunch of things that are important, you have to make people feel a certain way about how you do them and the ways that they want you to make you feel are diametrically opposite. Some people are going to be like, be more directive so that way everyone knows your thing. Some people are going to say be less directive so people can come to their own conclusions. Some people are going to say move faster because there's always more you can do. Some people are going to say move less fast because otherwise you're going to end up steamrolling people.

**中文翻译:**
我想我们已经聊到了一些。第一，你会收到不同风格的反馈，以及解读这些反馈的多种方式。直到今天，我收到的反馈仍然像是让我走钢丝：你不仅要改变很多事、做很多重要的事，你还得让人们对你做事的方式产生某种特定的感觉，而他们希望你带给他们的感觉往往是截然相反的。有人会说：“表现得更有指令性一些，这样大家才知道你的想法。”有人会说：“少一点指令性，让大家自己得出结论。”有人会说：“行动快一点，因为总有更多事可以做。”有人会说：“慢一点，否则你会把大家压垮。”

---

### (00:52:57) Ami Vora

**English:**
And a lot of it is personal, there's a bunch research about how women get a lot more personal feedback that is less about the content of their role and more about their style, I think that is still true and there's often a kernel of truth in it. For me, this is forever work. I do have biases toward execution and being directive and things like that, but I think learning how to interpret and respond to feedback has been a really important point for me and making my choices of, just because I'm getting feedback doesn't mean I immediately need to respond to all of it. There's a step in between where I can choose, is this feedback I want to take action on in this exact way? Am I going to look for more themes, take action in a different way, or am I going to say this is who I am and I understand the trade-offs, I'm going to do a better job of giving people context on the decisions I'm making and why I'm choosing these trade-offs. But actually this is part of how I want to operate and I'm going to keep on operating.

**中文翻译:**
而且很多反馈是针对个人的。有很多研究表明，女性会收到更多针对个人的反馈，这些反馈较少关乎工作内容，更多关乎个人风格。我认为这依然是事实，而且其中往往包含一部分真相。对我来说，这是一项长期的功课。我确实偏向于执行和指令性风格，但学习如何解读和回应反馈对我来说非常重要。我学会了做选择：仅仅因为我收到了反馈，并不意味着我必须立即对所有反馈做出回应。中间有一个步骤，我可以选择：这是我想以这种方式采取行动的反馈吗？我是要寻找更多的共同主题并以不同的方式采取行动，还是说“这就是我，我理解其中的权衡，我会更好地向大家解释我做决策的背景以及为什么选择这些权衡，但这确实是我运作方式的一部分，我会继续这样运作”。

---

### (00:54:01) Ami Vora

**English:**
And then I think we just give women weird advice. Here's a hot take. I think we tell women things like, you need to find a mentor and you need to find a sponsor, and that's just another set of hoops that we have that we tell women to jump through that I don't think we tell other parts of the population to jump through. I think we tell women to unlock your future success, you've got to find somebody who has made all the same life decisions you have and who you look up to and relate to, but who also had an hour every month to be an oracle to tell you all the things you do in your life. And it feels like yet another burden where you're like, I don't know how to do that.

**中文翻译:**
而且我认为我们给女性的建议很奇怪。这里有一个尖锐的观点：我们告诉女性“你需要找一个导师（Mentor）”和“你需要找一个赞助人（Sponsor）”，这只是我们让女性去跳的另一组圈套，而我认为我们并不会让其他人群去跳。我们告诉女性，为了开启未来的成功，你必须找到一个做过所有和你相同生活决定的人，一个你仰慕且能产生共鸣的人，而且这个人每个月还得有一个小时的时间像神谕一样告诉你生活中该做的一切。这感觉像是又一个负担，你会觉得：“我不知道该怎么做。”

---

### (00:54:45) Ami Vora

**English:**
I had the extreme generosity of so many wonderful leaders who helped me on my way, but I didn't feel like I had this mentor and for a while it was just like, oh man, if I only had a mentor, I would know how to do all of this stuff and it felt like another weight that I needed to carry, which I didn't. I had everything I needed, people were so kind and generous, but I didn't recognize it that way because we talk about it differently.

**中文翻译:**
在我的成长道路上，有很多优秀的领导者对我非常慷慨并给予了帮助，但我并不觉得我拥有那种所谓的“导师”。有一段时间我觉得：“天哪，如果我有一个导师，我就知道该怎么做所有这些事了。”这感觉像是我需要背负的另一块重担，但其实并不需要。我拥有我需要的一切，大家都很友善和慷慨，但我当时没有意识到这一点，因为我们谈论它的方式不同。

---

### (00:55:09) Lenny Rachitsky

**English:**
Thank you for sharing all that. I wasn't planning on going in this direction, but this is such important advice for say, young women that are just getting started in the same product. Is there any advice you'd want to share to help them get to be the next Ami?

**中文翻译:**
谢谢你的分享。我本来没打算聊这个方向，但对于那些刚开始从事产品工作的年轻女性来说，这是非常重要的建议。为了帮助她们成为下一个 Ami，你有什么建议想分享吗？

---

### (00:55:23) Ami Vora

**English:**
Oh, I mean number one, no next Ami, they're going to be their next themselves. That is maybe the most important thing, is everyone will only tell you their own story. That's all anyone can do, but the thing that I tell people is, don't dampen who you are and your strengths, just continue expanding. Whenever you run into a problem, just add more to the things that you can do, the tools that you have, the way you can express yourself. Just keep on adding and growing and don't shrink yourself, ever.

**中文翻译:**
噢，首先，没有“下一个 Ami”，她们会成为下一个她们自己。这也许是最重要的一点：每个人都只能告诉你他们自己的故事。这就是所有人能做的。但我告诉大家的是：不要压抑你的本色和优势，只需不断扩展。每当你遇到问题，只需增加你能做的事情、你拥有的工具、你表达自己的方式。不断增加，不断成长，永远不要缩小你自己。

---

### (00:55:57) Lenny Rachitsky

**English:**
I love that. I want to move to a different topic. There's a few things I definitely wanted to touch on while we had our time together. One is that I hear, now this is going to be a total tangent, but I think it's really important and I'm excited to talk about it. I hear you're really good at setting goals and aligning incentives really well for teams. One of your colleagues told me you're best in class at building product orgs and figuring out how product orgs can best work with other teams. I'm curious if there's any tricks or lessons you can share here about what you've learned about how to do this well.

**中文翻译:**
我喜欢这个。我想换个话题。在我们的时间里，有几件事我一定要聊聊。第一，我听说——这可能有点离题，但我认为非常重要，我也很兴奋能聊聊——我听说你非常擅长设定目标并很好地对齐团队的激励机制。你的一位同事告诉我，你在构建产品组织以及理顺产品组织如何与其他团队合作方面是顶尖的。我很好奇你是否有什么技巧或教训可以分享，关于你学到的如何做好这件事。

---

### (00:56:27) Ami Vora

**English:**
Yeah, I mean I think one thing is to try to decouple all the things we're trying to do. Sometimes when you give people direction, you're like, okay, everybody just go get revenue or everybody just go get GMV. And it seems obvious because that's the thing you have to do as a company, but there's only a few places where you are guaranteed to get that and it's measurable and you can do it. And that leads to what I call toddler soccer, where everybody just runs to the same surface or the same customer set or the same exact product where you can do this and it's measurable and you end up, everyone's tripping on each other, everyone's trying, nobody really gets contact on the ball, there's no coordination. I have three kids, I've watched a lot of toddlers play soccer. [inaudible 00:57:18], it's a very fresh, very fresh metaphor.

**中文翻译:**
是的，我认为其中一点是尝试解耦（Decouple）我们正在做的所有事情。有时当你给人们指引时，你会说：“好，大家去搞收入”或者“大家去搞 GMV（商品交易总额）”。这看起来显而易见，因为那是公司必须做的事。但只有少数几个地方能保证你获得这些，并且是可衡量的、可操作的。这就会导致我所说的“幼儿足球”（Toddler Soccer）：每个人都跑向同一个界面、同一组客户或同一个产品，因为在那里可以出成果且可衡量。结果就是，大家互相绊倒，每个人都在努力，但没人真正踢到球，完全没有协作。我有三个孩子，我看过很多幼儿踢足球。（听不清），这是一个非常新鲜、非常生动的隐喻。

---

### (00:57:20) Ami Vora

**English:**
And instead, one of the things I like to do is just detangle, okay, as a company, let's think about our customers. Let's think about all the things they're going to need in their journey. Let's think about how we will know how we will match our own metrics to customer success. Let's play the entire field. What would it look like if we could detangle it so that every team we had internally had a different goal that ladders into a goal framework that's actually the thing that we need to do to solve the full customer impact? And then you don't have the same swim lanes problem. You have plenty of room for people to make progress on their lanes. They all know how they fit into the bigger picture, and it just opens up a lot more growth for every team and it makes sure that we're solving the customer problem end to end.

**中文翻译:**
相反，我喜欢做的一件事是理清头绪：好，作为一家公司，让我们思考我们的客户。思考他们在旅程中需要的一切。思考我们如何知道我们的指标与客户的成功相匹配。让我们利用整个球场。如果我们能把它理顺，让内部的每一个团队都有一个不同的目标，这些目标最终汇聚成一个目标框架，而这个框架正是我们解决完整客户影响所需做的事情，那会是什么样子？这样你就不会有“泳道冲突”的问题。每个人都有足够的空间在自己的泳道上取得进展。他们都知道自己如何融入大局，这为每个团队开启了更多的增长空间，并确保我们端到端地解决了客户问题。

---

### (00:58:11) Lenny Rachitsky

**English:**
Is there an example that you could share to make this even more concrete from say, WhatsApp or Facebook or Instagram or anything like that, where you can share some of these goals that you've like, oh, this worked out really well? I know it's probably private information and partly-

**中文翻译:**
你能分享一个例子让这更具体吗？比如来自 WhatsApp、Facebook 或 Instagram 的例子，分享一些你觉得“噢，这效果非常好”的目标？我知道这可能是私密信息，而且部分……

---

### (00:58:25) Ami Vora

**English:**
It might be trickier. I mean, maybe going back to the GMV example. Maybe instead of motivating everyone on GMV, you motivate them on GMV per surface and you divide up the surfaces, or maybe you motivate them on actually different goals that underlie. When you think about GMV, what are all the various engagements, customer engagements that lead to GMV? Can you goal on those input metrics, can you goal on number of people who visit, number of people who convert, number of people who reorder, number, etc? Rather than going strictly on the output.

**中文翻译:**
这可能比较棘手。我是说，回到 GMV 的例子。也许不是用总 GMV 来激励每个人，而是按界面（Surface）来激励 GMV，并划分这些界面。或者，你可以根据底层的不同目标来激励。当你思考 GMV 时，导致 GMV 的各种客户参与行为是什么？你能不能针对这些“投入指标”（Input Metrics）设定目标？比如访问人数、转化人数、复购人数等等，而不是死盯着最终的产出指标。

---

### (00:58:59) Lenny Rachitsky

**English:**
So the core advice here is each team should have different goals that are part of this metrics tree that ladder up to revenue, GMV, something like that?

**中文翻译:**
所以这里的核心建议是：每个团队应该有不同的目标，这些目标是指标树的一部分，最终通向收入、GMV 之类的目标？

---

### (00:59:07) Ami Vora

**English:**
Whatever, yeah. The thing that best matches the overall customer outcome that mirrors the company outcome as well.

**中文翻译:**
没错。就是那些最能匹配整体客户结果，同时也反映公司结果的东西。

---

### (00:59:14) Lenny Rachitsky

**English:**
Got it. And there's always this balance between it's actually the best metric versus it's something they can move and understand and it's easy to watch and it's movable and things like that, right?

**中文翻译:**
明白了。这中间总有一个平衡：它是否真的是最好的指标，以及它是否是团队可以推动、理解、易于观察且可改变的指标，对吧？

---

### (00:59:24) Ami Vora

**English:**
Yeah, and you have to have faith that it is actually connected to that output metric. You don't want to create a metric that's disconnected just to make a team feel good. It really does need to solve the customer problem and that's reflected in company's performance, but you can usually break it down into smaller pieces and I think that breaking down into smaller pieces and assigning those out to teams, that's really helpful.

**中文翻译:**
是的，而且你必须坚信它确实与那个产出指标相关联。你不想为了让团队感觉良好而创建一个脱节的指标。它确实需要解决客户问题，并反映在公司的业绩中。但你通常可以把它分解成更小的部分，我认为这种分解并分配给团队的做法非常有帮助。

---

### (00:59:46) Lenny Rachitsky

**English:**
Is there anything else along these lines of things you've learned about helping teams work together and not play toddler soccer, beyond having different goals that all ladder up to the one that really matters?

**中文翻译:**
除了设定通向核心目标的差异化目标之外，关于帮助团队协作、避免“幼儿足球”现象，你还学到了什么吗？

---

### (00:59:58) Ami Vora

**English:**
I think there's value in also acknowledging that teams are going to have different incentives. Even inside a team like cross-functional teams on the same pod or whatever, are going to have different incentives, they're going to come in with different information, they're going to have disagreements. And certainly, different teams inside a company or different pillars inside a company, different products inside, they're all going to have different incentives, and I think sometimes that feels like something is going wrong when people disagree, but actually, that's just a sign of healthy tension and knowledge.

**中文翻译:**
我认为承认团队会有不同的激励机制也是有价值的。即使在同一个小组（Pod）内的跨职能团队中，大家也会有不同的激励机制，会带着不同的信息进来，会产生分歧。当然，公司内部的不同团队、不同支柱、不同产品，也都会有不同的激励机制。我认为有时当人们产生分歧时，会觉得出了什么问题，但实际上，这只是健康的张力和知识碰撞的信号。

---

### (01:00:34) Ami Vora

**English:**
I think the thing that makes tension healthy is one, when you can acknowledge it and say, yeah, of course there's tension. You're bringing different information than I'm bringing. We should be disagreeing. No one's a bad person, no one is coming in with poor intent. Everyone's doing the thing they are supposed to do and that is a useful thing to do. And then you have to agree on an outcome that you're aiming for. If you disagree on what the company outcome is or what the customer outcome is, then you've got some structural stuff you need to work out and normally you just have to escalate it, but if you agree on like, we're all trying to move this metric by changing this customer experience, then all you're doing is having a conversation about the best way to do that using the different information that everyone is bringing. And I think that's super important to just have as a rational, open, explicit discussion, as opposed to trying to hide it or pocket vetoing or something else. Because you assume that when someone disagrees with you that, I don't know, there's something emotional or wrong about it.

**中文翻译:**
我认为让张力变得健康的关键在于：第一，你能承认它并说：“是的，当然会有张力。你带来的信息和我带来的不同。我们理应产生分歧。没人是坏人，没人怀有恶意。每个人都在做他们该做的事，这是有益的。”第二，你们必须对共同的目标达成一致。如果你对公司的目标或客户的目标有分歧，那么你就有一些结构性的问题需要解决，通常你必须向上汇报（Escalate）。但如果你认同“我们都在尝试通过改变这种客户体验来提升这个指标”，那么你所做的只是利用每个人带来的不同信息，讨论实现这一目标的最佳方式。我认为进行理性、开放、明确的讨论至关重要，而不是试图隐藏分歧、搞“口袋否决”（Pocket vetoing）或其他小动作。因为你往往会假设当有人反对你时，是因为情绪化或出了什么错。

---

### (01:01:37) Lenny Rachitsky

**English:**
But it's fascinating.

**中文翻译:**
但其实这“太有意思了”。

---

### (01:01:40) Ami Vora

**English:**
Exactly.

**中文翻译:**
没错。

---

### (01:01:41) Lenny Rachitsky

**English:**
There's a piece of advice I once heard from the Head of Product at Airbnb once where we were trying to find, reorg the business and try to figure out the best org and his advice and something he realized is, there's never the best org, there's just the best idea we have at the time with the here's the things we know are not going to be optimal about it and let's build processes around that.

**中文翻译:**
我曾听过 Airbnb 产品负责人给出的一个建议，当时我们正尝试进行业务重组并寻找最佳组织架构。他的建议和他意识到的一点是：永远没有所谓的“最佳架构”，只有“我们当时能想到的最佳方案”，以及“我们知道其中哪些部分不是最优的，并围绕这些部分建立流程”。

---

### (01:01:59) Ami Vora

**English:**
I think that's my take on leadership in general. Especially as you get more senior, you can only make bad decisions. At some point someone can bring you a problem, you can recognize a problem and you can solve it, and there's so much happiness in solving that and tying a bow around it. But as you get senior, the only problems you'll see are ones that are fundamentally unsolvable because otherwise, someone would've solved it before they got to you. And so all you're doing is choosing which branch of suboptimal you're going to put your name on and describing the principles you're using and the context and the fact that it's suboptimal, but it's still the best thing. I think that's a really hard thing, is just to recognize and acknowledge that increasingly people only see you do, make suboptimal decisions and from a distance they're just like, why is that person only making bad decisions? And it's because those are your only options. All you can do is choose the least bad, the best possible for the time, for the problem that's consistent that makes sense with the framework, and that's been a tough thing to learn too.

**中文翻译:**
我认为这也是我对领导力的一般看法。特别是当你职位越高，你只能做“坏决定”。在某个阶段，有人会带给你一个问题，你可以识别并解决它，解决问题并圆满收尾会带来巨大的幸福感。但当你变得资深，你看到的唯一问题都是那些从根本上无法解决的问题，因为否则的话，在传到你手里之前就已经有人把它解决了。所以你所做的只是选择在哪一个“次优”（Suboptimal）的分支上签下你的名字，并描述你使用的原则、背景以及它确实是次优的事实，但它依然是目前最好的选择。我认为这是一件非常困难的事情，即承认并意识到，越来越多的人只看到你做次优决策，从远处看他们会想：“为什么那个人总是做坏决定？”那是因为那是你唯一的选择。你所能做的就是选择最不坏的、在当时针对该问题最可能的、且符合框架逻辑的决定。这也是一个很难学习的教训。

---

### (01:03:10) Lenny Rachitsky

**English:**
You said somewhere that as you get more senior, you get worse at everything because the problems get harder.

**中文翻译:**
你曾在哪里说过，随着职位升高，你在每件事上都变得更糟，因为问题变得更难了。

---

### (01:03:14) Ami Vora

**English:**
Yes, exactly. I mean, it's a kind of dark view of leadership where yeah, you can't fully solve problems, you have to say no a lot people are unhappy with you. I thought as you get more senior, everyone listens to you and they like you and you could just say a thing and then it happens and that is not at all accurate. It really is, most of the decisions you make are not going to be perfect.

**中文翻译:**
是的，没错。我是说，这是一种对领导力的阴暗看法：你无法完全解决问题，你必须经常说“不”，人们会对你不满。我以前以为随着职位升高，每个人都会听你的，都会喜欢你，你只要说一句话，事情就会发生，但这完全不准确。事实是，你做的大多数决定都不会是完美的。

---

### (01:03:42) Ami Vora

**English:**
And I think I'm all about just normalizing and acknowledging those hard truths because otherwise, I feel like I'm failing. And if I just know that something is normal that it's part of the job, then it's not me. It's just like, okay, this is a fact of the job that I have to get accustomed to if I want to have this kind of impact. And there's something about having the impact, being able to serve the customer, being able to be part of this team, there's something about it that is so worthwhile that it's worth being terrible at everything and being visibly terrible at everything because that is the best way that I have to have that kind of impact in the world.

**中文翻译:**
我认为我所做的一切就是让这些残酷的真相正常化并承认它们，否则我会觉得自己很失败。如果我知道某些事情是正常的、是工作的一部分，那么这就不是我的问题。这就像是：“好，这是工作的一个事实，如果我想产生这种影响力，我就必须习惯它。”而产生影响力、能够服务客户、能够成为这个团队的一员，这些事情是如此有价值，以至于值得在每件事上都表现得糟糕，甚至在众目睽睽之下表现得糟糕，因为这是我在这个世界上产生那种影响力的最佳方式。

---

### (01:04:21) Lenny Rachitsky

**English:**
I think this is really important for early ICPMs to hear because they see their CPO and founders making all these decisions and they're like, what the hell? That's a terrible idea, why are they doing this? What you're saying is just like it's the best... Options are limited and then-

**中文翻译:**
我认为这对早期的个人贡献者（IC）产品经理来说非常重要，因为他们看到自己的 CPO 和创始人做出的所有这些决定，会想：“搞什么鬼？那是个糟糕的主意，他们为什么要这么做？”而你所说的是，那只是最好的……选项有限，而且……

---

### (01:04:38) Ami Vora

**English:**
[inaudible 01:04:38].

**中文翻译:**
（听不清）

---

### (01:04:38) Lenny Rachitsky

**English:**
... nothing's going to be optimal.

**中文翻译:**
……没有什么会是最优的。

---

### (01:04:39) Ami Vora

**English:**
Yeah, no org is optimal. It's definitely not. You can optimize for the people you have and you can optimize for the products you have, can optimize for the customers you have and you can optimize for the technology you have. Those are the options that you have, and in every one of those you trade off everything else. And so you just have to know, there's not going to be a perfect where all of it works and that's okay. That is part of the fun of it. That's part of getting to do this work, is continuing to improve, but it's hard. It's hard when people, it's hard, especially when you want everyone to think you're so great at everything.

**中文翻译:**
是的，没有哪个组织是最优的。绝对没有。你可以为现有的人员优化，可以为现有的产品优化，可以为现有的客户优化，也可以为现有的技术优化。这些就是你的选项，而在每一个选项中，你都在权衡掉其他所有东西。所以你必须知道，不会有一个完美的方案让一切都运转良好，这没关系。这也是其中的乐趣所在。这是从事这项工作的一部分——不断改进。但这很难。当人们……这很难，尤其是当你希望每个人都觉得你在每件事上都很出色时。

---

### (01:05:12) Lenny Rachitsky

**English:**
This idea you mentioned of as a senior person solving people's problems, feeling really good, reminds me. Rolling to this, there's this Harvard Business Review article from the '70s or '80s or something about monkeys on your back. Have you read this or heard of this?

**中文翻译:**
你提到的作为资深人士解决别人的问题感觉非常好，这让我想起了一件事。顺着这个话题，有一篇 70 或 80 年代的《哈佛商业评论》文章，讲的是“背上的猴子”。你读过或听说过吗？

---

### (01:05:24) Ami Vora

**English:**
Oh yeah, yeah, I did.

**中文翻译:**
噢是的，是的，我读过。

---

### (01:05:26) Lenny Rachitsky

**English:**
Where it's basically like as a manager, [inaudible 01:05:28]-

**中文翻译:**
基本上是说作为一名经理，（听不清）……

---

### (01:05:28) Ami Vora

**English:**
You're trying to get monkey off of your back on people's backs?

**中文翻译:**
你是想把猴子从你背上甩到别人背上？

---

### (01:05:28) Lenny Rachitsky

**English:**
Exactly.

**中文翻译:**
没错。

---

### (01:05:28) Ami Vora

**English:**
Right, right, right.

**中文翻译:**
对，对，对。

---

### (01:05:32) Lenny Rachitsky

**English:**
People come to you, Ami, here's my monkey, please take it for me and feed it for me and take care of it. And your job as a leader is to keep the monkeys on people's backs and help them figure out how to feed this monkey themself.

**中文翻译:**
人们来找你：“Ami，这是我的猴子，请帮我拿着它，喂养它，照顾它。”而你作为领导者的工作是让猴子留在人们自己的背上，并帮助他们弄清楚如何自己喂养这只猴子。

---

### (01:05:43) Ami Vora

**English:**
It's a weird one.

**中文翻译:**
这个比喻挺怪的。

---

### (01:05:43) Lenny Rachitsky

**English:**
To get it off their back. It's very visceral. I want to talk about Faire and your current role as a final section of our chat. First of all, what was it like starting something completely new after 15 years at Meta at the various properties of Meta?

**中文翻译:**
为了把它从他们背上弄走。这非常形象。我想把 Faire 和你目前的职位作为我们聊天的最后一个部分。首先，在 Meta 及其各个业务部门工作了 15 年之后，开始一件全新的事情是什么感觉？

---

### (01:06:00) Ami Vora

**English:**
Yeah, I mean, I was so lucky. I had such an amazing run at Meta. I got to work with amazing leaders, truly great products. And I came to Faire for the same reason that I've been anywhere, because I believe in the people and I believe in the mission. A lot of my family in India is in wholesale and local retail, which is what Faire does, and so it was also a very personal thing for me too. I felt like I knew those customers. I'm a huge fan of small businesses, I got to work with a bunch of them in previous jobs as well.

**中文翻译:**
是的，我是如此幸运。我在 Meta 有过一段非常精彩的经历。我有机会与优秀的领导者合作，接触到真正伟大的产品。我来到 Faire 的原因和我去任何地方的原因一样：因为我相信这里的人，我相信这里的使命。我在印度的很多家人都从事批发和当地零售业务，这正是 Faire 所做的，所以这对我来说也是一件非常私人的事情。我觉得我了解那些客户。我是小企业的忠实粉丝，在之前的工作中我也接触过很多小企业。

---

### (01:06:30) Ami Vora

**English:**
I would say coming to Faire, I mean, one of the things I always think about is that especially as you are more senior, ramping on anywhere feels terrible because you expect to be as good at your new job as you were when you left your last job, but you forget that at your last job, you were there for years, you had years to build up the vocabulary and the cultural context and the network and the product knowledge, and then you're stepping in somewhere where you know none of that, but you have the same expectations of yourself of being able to have an impact and improve things and help your team. And so I always just try to remind myself, it's going to take time and what's most important is not for me to try to come in and change everything immediately, but to learn enough to be able to change things like 60 or 90 or 120 days in the future. And so that breathing helps a little bit.

**中文翻译:**
我想说，来到 Faire，我一直在思考的一件事是：特别是当你职位越高，在任何地方的“上手期”（Ramping on）都会感觉很糟糕。因为你期望自己在这一份新工作中的表现能像离开上一份工作时那样出色，但你忘了在上一份工作中，你待了多年，你有数年的时间来积累词汇量、文化背景、人脉和产品知识。而现在你进入了一个全新的环境，你对这些一无所知，但你对自己产生影响力、改进事物和帮助团队的期望却没变。所以我总是尝试提醒自己：这需要时间。最重要的事情不是一进来就尝试立即改变一切，而是学习足够多的东西，以便在未来的 60 天、90 天或 120 天能够做出改变。这种喘息的空间很有帮助。

---

### (01:07:29) Ami Vora

**English:**
It was also really interesting because Faire was entirely new to me. It was a new business model, it was a whole new set of people. It was a whole new set of customer problems. And so every interaction I just had to learn so much. I had to learn, who is this person? How do they see the world? What's the problem they're talking to me about? What's the customer impact, I think? So it was just a dramatic learning curve, which I always really love.

**中文翻译:**
这也非常有趣，因为 Faire 对我来说完全是全新的。它是一个新的商业模式，是一群全新的人，是一套全新的客户问题。所以每一次互动我都必须学习很多东西。我必须学习：这个人是谁？他们如何看待世界？他们跟我谈论的问题是什么？我认为对客户的影响是什么？所以这只是一个巨大的学习曲线，而我一直非常喜欢这种感觉。

---

### (01:07:54) Ami Vora

**English:**
Maybe the last thing I'd say is, again, I was super lucky at Meta. I think I always had this maybe deep-seated insecurity that maybe I was only good at Meta. Maybe there was something about that network of people and how great they were and how well I knew those products, and maybe I wouldn't be that successful somewhere without that scaffolding. And so leaving and being able to go somewhere else and lead through change and a new place, a new customer set, a new business model, that's also been really, really affirming for me, honestly.

**中文翻译:**
也许最后我想说的是，再次强调，我在 Meta 非常幸运。我想我内心深处一直有一种不安全感：也许我只在 Meta 表现出色。也许是因为那里的人脉网、那些优秀的人以及我对那些产品的熟悉程度，如果没有那个“脚手架”（Scaffolding），也许我在别的地方就不会那么成功。所以，离开并能够去别的地方，在变革中领导，面对新环境、新客户群、新商业模式，坦白说，这对我也非常有肯定意义。

---

### (01:08:34) Lenny Rachitsky

**English:**
Well, you have a lot of fans at Faire from the people I know there.

**中文翻译:**
据我认识的那些人说，你在 Faire 有很多粉丝。

---

### (01:08:36) Ami Vora

**English:**
[inaudible 01:08:36].

**中文翻译:**
（听不清）

---

### (01:08:36) Lenny Rachitsky

**English:**
And so clearly, things are going well, at least as far as I can tell. Something that I think is, Faire definitely has, and a lot of companies have, is a very product minded visionary founder. And CPOs classically last a year or two, and then they're like, ah, this sucks. The founder just tells me what to do and what's the point of this role? And it's so frustrating. I'm curious just what you've learned about, at least so far, about working with someone like that as a CPO and not just being this middle person between what the founder wants to do with the team, this building.

**中文翻译:**
显然，事情进展得很顺利，至少据我所知是这样。我认为 Faire 确实拥有——很多公司也有——一位非常有产品头脑、有远见的创始人。而首席产品官（CPO）通常只能干一两年，然后他们就会觉得：“啊，这太糟了。创始人总是告诉该我做什么，这个职位的意义何在？”这非常令人沮丧。我很想知道，至少到目前为止，作为 CPO 与这样的人合作，你学到了什么？如何避免只做一个传声筒，传达创始人想让团队构建的东西？

---

### (01:09:09) Ami Vora

**English:**
Yeah, I mean, this is going to sound so naive, but I literally didn't know how important it was for me to have such a great relationship with the CEO, because I always had great relation, I was lucky, I had great relationships with a lot of people at my previous jobs. I was like, oh, of course it's going to be fine, everyone's going to let me do what I want, whatever. And I think I just got really lucky because Max is an amazing CEO, who's also super growth mindset and super open to talking over ideas, even when they involve a lot of change.

**中文翻译:**
是的，这听起来可能很天真，但我以前真的不知道与 CEO 建立如此良好的关系对我来说有多重要。因为我很幸运，在之前的工作中我与很多人关系都很好。我当时想：“噢，当然没问题，大家都会让我做我想做的事，无所谓。”我想我只是非常幸运，因为 Max 是一位了不起的 CEO，他非常有成长心态，非常愿意讨论想法，即使这些想法涉及巨大的变革。

---

### (01:09:42) Ami Vora

**English:**
So when I was onboarding, one of the things I always like to do is write a list of observations. I go out and talk to, I have one-on-ones with a lot of people, and I write, here's the themes that I'm hearing. Here's what's going well, here's what's not going well. And that's a way for me to both share what I'm seeing and build some credibility and trust that way, but also for people to give me feedback and be like, oh, you're wrong about this, just so I can correct my starting point of knowledge.

**中文翻译:**
所以当我入职时，我总是喜欢做的一件事是写一份“观察清单”。我会去和很多人进行 1-on-1 谈话，然后写下我听到的主题：哪些进展顺利，哪些不顺利。这既是我分享所见所闻、建立公信力和信任的一种方式，也是让大家给我反馈的方式，比如：“噢，你在这点上错了。”这样我就可以修正我的知识起点。

---

### (01:10:10) Ami Vora

**English:**
And with Max, I also wrote a parallel document of hot takes. So once a quarter or so for the first year, I'd write a document that was just like, hey, for sake of provocation, if we wanted to fundamentally change a few things, here's ideas on what we could fundamentally change. And Max, very, very well could have just been like, hey, can you please just run product? That's you're job, can you please do that? And instead, he and the entire rest of the executive team were like, yeah, let's step through these. Let's talk about which of these we should try, let's talk about maybe context you don't have for why these don't make sense or why we don't do these. And that was such a gift because I was able to build such a great relationship, a trusting and complimentary relationship with Max and the rest of the exec team, and also that he took seriously things that he really didn't have to that I have so much respect for that, and I think I got really lucky in just finding a great CEO and exec team.

**中文翻译:**
对于 Max，我还写了一份平行的“犀利观点”（Hot takes）文档。在第一年里，大约每季度一次，我会写一份文档，内容大概是：“嘿，为了激发讨论，如果我们想从根本上改变几件事，这里有一些关于我们可以从根本上改变什么的建议。”Max 完全可以回绝说：“嘿，你能只管好产品吗？那是你的工作，请做好它。”但他和整个执行团队却说：“好，让我们逐一讨论这些。让我们谈谈其中哪些值得尝试，谈谈你可能不了解的背景，为什么有些建议行不通或者为什么我们不这样做。”这真是一份厚礼，因为我能够与 Max 和执行团队的其他成员建立如此良好的、信任且互补的关系。而且他非常认真地对待那些他其实不必理会的事情，我对此深表敬意。我想我真的很幸运，找到了这么棒的 CEO 和执行团队。

---

### (01:11:18) Lenny Rachitsky

**English:**
Is there anything you learned about this vetting process? Say you're a founder looking for a head of product, A CPO, any advice for how they might vet this person to make sure they are good fit and will last?

**中文翻译:**
关于这个筛选过程，你学到了什么吗？假设你是一位正在寻找产品负责人或 CPO 的创始人，对于他们如何筛选这个人以确保契合且能干得长久，你有什么建议吗？

---

### (01:11:32) Ami Vora

**English:**
What I'd say to everyone else is, make sure you just have a mind meld with a CEO. Before you decide to take the job, spend a day together, understand how they think and how they operate, and whether you're going to work together in a way that feels really high fidelity and high trust and you're going to have room. I mean, I'm not a founder by any stretch and so when founders ask me what should I look for in a head of product or CPO, I say something a little bit different, which is, make sure that you really need the level of seniority that you are hiring. I think that a lot of founders think, I need a CPO, I need a VP of product, I need someone who's really senior, when often the founder has a bunch of the vision and knowledge, and what they really need is somebody to build the product. They don't need somebody who's going to scale the team or build systems like they've got enough of that. And so that to me is part of building that complimentary relationship where the founder and CEO know what they need and on the CPO side, they know that they can mind meld enough with the CEO to actually have an impact.

**中文翻译:**
我想对其他人说的是：确保你与 CEO 能够达成“思想融合”（Mind meld）。在决定接受这份工作之前，花一天时间待在一起，了解他们的思维方式和运作方式，以及你们是否能以一种高保真、高信任的方式合作，并且你是否有发挥空间。我绝不是创始人，所以当创始人问我该在产品负责人或 CPO 身上寻找什么特质时，我会说一些略有不同的建议：确保你真的需要你所招聘的那个资历级别的员工。我认为很多创始人觉得“我需要一个 CPO，我需要一个产品副总裁，我需要一个非常资深的人”，而实际上创始人已经拥有了大量的愿景和知识，他们真正需要的是有人去把产品做出来。他们不需要有人去扩大团队规模或建立系统，因为他们已经够忙这些了。所以对我来说，建立互补关系的一部分是创始人/CEO 知道他们需要什么，而 CPO 知道他们能与 CEO 达成足够的思想融合，从而真正产生影响力。

---

### (01:12:41) Lenny Rachitsky

**English:**
Last question. You started as an intern in the PR department, I think, at Meta?

**中文翻译:**
最后一个问题。我想你最初是在 Meta 的公关部门做实习生？

---

### (01:12:47) Ami Vora

**English:**
Oh, I started as a temp, actually.

**中文翻译:**
噢，实际上我是从临时工（Temp）开始的。

---

### (01:12:51) Lenny Rachitsky

**English:**
At temp, okay, amazing. And then you ended up leading Facebook ads and then WhatsApp and many other things. Can you share that story of just how you joined and how that happened?

**中文翻译:**
临时工，好，太神奇了。然后你最终领导了 Facebook 广告，接着是 WhatsApp 以及许多其他业务。你能分享一下你当初是如何加入以及那是如何发生的吗？

---

### (01:12:59) Ami Vora

**English:**
Well, I had quit my last job. I knew that what I wanted to do was be involved in all the wild stuff happening in Silicon Valley in the mid 2000s. So I'd quit my last job, I was traveling around the world a little bit. I was living in New York, an extremely blissful lifestyle. I was unemployed, I was doing whatever I wanted. It was some of the best time I've had in my life, and eventually I needed a job, like you do. But it was 2007 and the only place I wanted to work was Facebook. You could hear the way people talked about these products. People would say Facebook is more important than than my car. It's like how I connect with the world. It was such a magical product, and you could hear that.

**中文翻译:**
嗯，当时我辞掉了上一份工作。我知道我想参与到 2000 年代中期硅谷发生的那些疯狂的事情中去。所以我辞职了，去环游世界了一段时间。我当时住在纽约，过着极其幸福的生活。我失业了，想做什么就做什么。那是我一生中最美好的时光之一。最终，我需要一份工作，就像大家一样。那是 2007 年，我唯一想去的地方就是 Facebook。你能听到人们谈论这些产品的方式。人们会说：“Facebook 比我的车还重要。它是我与世界连接的方式。”那是一个如此神奇的产品，你能感受到这一点。

---

### (01:13:51) Ami Vora

**English:**
And I knew some people at the company and I convinced one of them to introduce me to everyone at the office. I'd made a trade, I said, I'll buy you a fancy coffee at Coupa Cafe in downtown Palo Alto, and in exchange just introduced me to everyone, everyone you know, take me around the office. So everyone I met, I said, "Hey, I'm Ami, I really want to work here. I'll do whatever you need." And the only call I got back was from the Head of PR, Brandy Barker, who said, "Look, we can't hire you. We didn't interview you. We don't have headcount. You're not really qualified." It was just like 10 reasons. I was like, okay, thank you for calling me. And she said, "But we need a temp to review our press releases, so if you want to come join a temp agency, we'll tell them to send you here." And that's what I did, I moved out to California and I slept on people's couches and eventually they hired me full time and I didn't look back.

**中文翻译:**
我认识公司里的一些人，我劝说其中一个带我认识办公室里的所有人。我做了一个交易，我说：“我请你在帕洛阿尔托市中心的 Coupa Cafe 喝杯高级咖啡，作为交换，你把我介绍给每个人，把你认识的所有人都介绍给我，带我参观办公室。”所以我见到的每一个人，我都说：“嘿，我是 Ami，我真的很想在这里工作。我愿意做任何你需要的事。”我收到的唯一回复电话来自公关负责人 Brandy Barker，她说：“听着，我们不能雇佣你。我们没面试过你。我们没有名额。你其实并不够格。”她列了大概 10 个理由。我说：“好的，谢谢你给我打电话。”接着她说：“但我们需要一个临时工来审核我们的新闻稿，所以如果你愿意加入一家劳务派遣公司，我们会告诉他们把你派到这里来。”于是我就这么做了。我搬到了加州，睡在别人的沙发上，最终他们全职录用了我，从此我再也没有回头。

---

### (01:14:50) Lenny Rachitsky

**English:**
And now you're on Lenny's podcast, what a run. It's interesting, this reminds me of another path to power rule from the Jeffrey PFeffer podcast, of networking is one of the best ways to acquire power in the world. So it's interesting that now that seed has planted in my head. Anyway, just A plug for that other episode also.

**中文翻译:**
而现在你上了 Lenny 的播客，这一路走来真精彩。有趣的是，这让我想起了 Jeffrey Pfeffer 播客中的另一条权力之路规则：人脉（Networking）是世界上获得权力的最佳方式之一。很有意思，这个种子现在种在了我的脑海里。总之，也顺便推荐一下那一集。

---

### (01:15:06) Ami Vora

**English:**
Ami, is there anything else that you wanted to share or leave listeners with before we get to a very exciting lightning round?

**中文翻译:**
Ami，在进入非常精彩的闪电问答环节之前，你还有什么想分享或留给听众的吗？

---

### (01:15:13) Ami Vora

**English:**
Sometimes people ask me who are working in product, what's the one thing they should do to be successful at product? And maybe the thing I would say is, especially as an org scale or a company scales, there's just a lot of distractions that get between you and the customer. And so the one thing that I would just advise everyone to do is just think about the customer, talk to the customer, be an advocate for them. It's such a shortcut to everything else you need to do in order to be successful, but it's so easy for that to get lost when you're thinking about, okay, how do I get alignment on my team? How do I figure out my roadmap? How do I convince people to join the company? There's all these different things, but fundamentally, we're here to create value for the customer. And the closer you can get to that, I always found myself the happiest because I'm building that feedback loop with the customer, but also more successful.

**中文翻译:**
有时从事产品工作的人会问我：要在产品领域取得成功，最应该做的一件事是什么？我想说的是，特别是随着组织或公司规模的扩大，你和客户之间会出现很多干扰因素。所以我建议每个人的那一件事就是：思考客户，与客户交谈，成为他们的倡导者。这是通往成功所需做的一切事情的捷径。但当你思考“我如何让团队达成一致？”、“我如何制定路线图？”、“我如何说服人们加入公司？”时，这一点很容易被遗忘。尽管有这么多不同的事情，但从根本上说，我们在这里是为了给客户创造价值。你离这一点越近，我发现自己就越快乐，因为我正在与客户建立反馈循环，同时也更容易获得成功。

---

### (01:16:09) Lenny Rachitsky

**English:**
Well, let me actually follow up on this because this is really important and interesting. There's a PM part of my brain of like, okay, but we also got to move some metrics and sometimes that metric isn't going to be moved by, we need to do something specifically for the customer, but it's something that will help the business. Is there anything there of just that balance of like, we need to move over this conversion metric, versus, let's focus fully on what does the customer want and need? Any thoughts there?

**中文翻译:**
让我针对这一点追问一下，因为这非常重要且有趣。我脑子里 PM 的那部分会想：“好，但我们也得提升一些指标，有时那个指标并不是通过专门为客户做某事来提升的，而是通过一些对业务有帮助的事情。”关于这种平衡，比如“我们需要提升这个转化指标”与“让我们完全专注于客户想要和需要什么”，你有什么想法吗？

---

### (01:16:34) Ami Vora

**English:**
Yeah, I think we often make things adversarial that are not actually adversarial. It is very rare for customer value to be different than a company value on a long enough time horizon. There might be short-term divergences, but really, to solve, to create value for the customer, you got to be around as a business, otherwise you are creating zero value for the customer. And so I think really, just starting with the, what are the end goals and where does stuff diverge in the very short term versus the medium term versus in the long term? It shouldn't, and really thinking about where you are in the journey and how to place that. That always helps me because our metrics should absolutely be about long-term customer impact. It's very rare if those aren't, and then you're still able to be successful.

**中文翻译:**
是的，我认为我们经常把原本不敌对的事情对立起来。在足够长的时间跨度内，客户价值与公司价值很少会发生冲突。短期内可能会有分歧，但实际上，为了解决问题、为客户创造价值，你必须作为一个企业生存下去，否则你为客户创造的价值就是零。所以，我认为真正应该从终极目标开始思考：在短期、中期和长期，事情在哪里产生了分歧？它不应该产生分歧。思考你处于旅程的哪个阶段以及如何定位。这总是能帮到我，因为我们的指标绝对应该是关于长期的客户影响。如果不是这样，你很难获得持久的成功。

---

### (01:17:26) Lenny Rachitsky

**English:**
It comes back to our chat about metrics and how to do those well. With that, we've reached our very exciting lightning round.

**中文翻译:**
这又回到了我们关于指标以及如何做好指标的讨论。说到这，我们进入了非常令人兴奋的闪电问答环节。

---

### (01:17:29) Ami Vora

**English:**
Cool, I'm ready.

**中文翻译:**
酷，我准备好了。

---

### (01:17:34) Lenny Rachitsky

**English:**
Here we go. First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
开始。第一个问题，你向别人推荐最多的两三本书是什么？

---

### (01:17:39) Ami Vora

**English:**
The Year of Yes, by Shonda Rhimes. I almost never read nonfiction. I love Shonda Rhimes, made an exception for this one. It's about just saying yes to things and finding your voice when you do feel like you're sometimes the first or the only or the different, and what that feels like. And it was very life-changing for me, actually.

**中文翻译:**
Shonda Rhimes 的《一年 Say Yes》（The Year of Yes）。我几乎从不看非虚构类书籍。我爱 Shonda Rhimes，所以为这本书破了例。它是关于对事物说“是”，以及当你觉得自己有时是第一个、唯一的或与众不同的人时，如何找到自己的声音，以及那是种什么感觉。实际上，这本书对我的人生产生了巨大的影响。

---

### (01:18:00) Lenny Rachitsky

**English:**
That's an awesome pick. No one has recommended that one yet. Reminds me of an episode of Matthew Dicks, who has a Ted Talk about saying yes to everything.

**中文翻译:**
这是一个很棒的选择。还没人推荐过这本书。这让我想起 Matthew Dicks 的那一集，他有一个关于对一切说“是”的 TED 演讲。

---

### (01:18:00) Ami Vora

**English:**
Really?

**中文翻译:**
真的吗？

---

### (01:18:07) Lenny Rachitsky

**English:**
He just says, Chris, to say yes to everything and his life is incredibly interesting as a result. Next question, do you have a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
他只是说，对一切说“是”，结果他的生活变得极其有趣。下一个问题，你最近有没有特别喜欢的电影或电视剧？

---

### (01:18:17) Ami Vora

**English:**
I watch a lot of witty workplace comedies from the mid 2000s. So I watch a lot of The Office or 30 Rock reruns. Things are just very comfortable that I already know everything, there's no surprises. I'm not great with new stuff right now.

**中文翻译:**
我会看很多 2000 年代中期那种机智的职场喜剧。所以我经常重看《办公室》（The Office）或《我为喜剧狂》（30 Rock）。这些东西让我感到很舒服，因为我已经知道所有的情节，没有意外。我现在不太擅长接受新东西。

---

### (01:18:33) Lenny Rachitsky

**English:**
I heard they're bringing back The Office. There's a reboot happening.

**中文翻译:**
我听说他们要重启《办公室》了。

---

### (01:18:36) Ami Vora

**English:**
Oh really? Let's see.

**中文翻译:**
噢真的吗？拭目以待。

---

### (01:18:38) Lenny Rachitsky

**English:**
Yeah, exactly. Is there a favorite product you've recently discovered that you love, either digital, physical, anything?

**中文翻译:**
是的。你最近有没有发现什么特别喜欢的产品？数字的、实体的，任何东西都可以。

---

### (01:18:47) Ami Vora

**English:**
Maybe a physical product that I really like. I drink a lot of coffee and tea through the day and it's just, I don't know, a calming ritual. And so I have a Fellow's electric kettle, that was my big work from home upgrade. So I have this life for kettle, I have a pour over kit. I have these lovely colorful mugs that I like, that has actually just made my day-to-day a lot better, is just a little feeling of luxury.

**中文翻译:**
也许是一个我非常喜欢的实体产品。我一天中会喝很多咖啡和茶，这对我来说是一种平静的仪式。所以我买了一个 Fellow 的电热水壶，那是我居家办公的一大升级。我有这个水壶，有一套手冲工具，还有一些我喜欢的可爱彩色马克杯。这确实让我的日常生活变得更好了，带给我一点点奢华感。

---

### (01:19:16) Lenny Rachitsky

**English:**
I love that. I think we have that same kettle. I also drink tea during every episode I have here.

**中文翻译:**
我喜欢这个。我想我们用的是同款水壶。我录每一集节目时也都会喝茶。

---

### (01:19:19) Ami Vora

**English:**
Oh, yeah. You know it.

**中文翻译:**
噢，是的。你懂的。

---

### (01:19:21) Lenny Rachitsky

**English:**
So we're on the same page. Next question. Do you have a favorite life motto that you often think about, come back to, share with friends or family, in work or in life?

**中文翻译:**
看来我们志趣相投。下一个问题，你有没有最喜欢的人生格言，是你经常思考、反复回味、或与亲友分享的？无论是在工作还是生活中。

---

### (01:19:30) Ami Vora

**English:**
It is definitely not a motto. I feel like I know people have mottos and I'm so impressed. I'm like, you know what you are, you know what you need. I am not that person, but I have a piece of advice that someone gave me very early in my career. Actually, it was Chamath, he said, "You can either have more energy or less ambition." And I was like, oh, that's a little harsh, but also really true. And I think about that, it's another of my Roman empires. I think about it all the time where I'm like, okay, if I want to have this kind of impact, I'm going to have to do the work, I'm going to have to try new things, I'm going to have to feel uncomfortable, and sometimes I don't want to do those things. I don't want to do all of that work, and then I can't be mad if I'm not having the impact. Those two just have to go together. I also have to get lucky in all these different ways, but the two have to go together and that's been just a good governor, a little bit, of how I think about what I'm putting in.

**中文翻译:**
那绝对称不上格言。我觉得我知道有些人有格言，我对此深感佩服。我会觉得：“你很清楚自己是谁，知道自己需要什么。”我不是那种人。但我有一条职业生涯早期别人给我的建议。实际上是 Chamath 说的，他说：“你要么拥有更多的精力，要么拥有更小的野心。”我当时想：“噢，这有点刻薄，但也非常真实。”我经常想到这个，这是我的另一个“罗马帝国”。我一直在想：“好，如果我想产生这种影响力，我就必须付出努力，必须尝试新事物，必须感到不适。”有时我不想做那些事，不想付出那么多努力，那么如果我没能产生影响力，我也没资格生气。这两者必须并存。当然我也得在各方面都很走运，但这两者必须结合在一起。这成了我衡量自己投入程度的一个很好的标尺。

---

### (01:20:26) Lenny Rachitsky

**English:**
I love that quote. By the way, if people don't know what you're talking about when you talk about the Roman Empires, there's a meme on TikTok where somebody said that every man thinks about the Roman Empire at least once a week. Right?

**中文翻译:**
我喜欢这句话。顺便说一下，如果大家不知道你说的“罗马帝国”是什么意思，那是 TikTok 上的一个梗，有人说每个男人每周至少会想到一次罗马帝国。对吧？

---

### (01:20:39) Ami Vora

**English:**
It's made me think about, what are all the things I think about repeatedly without really having trigger or reason? And there's still a lot. I don't think about the Roman Empire though. That is not one of them.

**中文翻译:**
这让我思考：有哪些事情是我在没有诱因或理由的情况下反复思考的？确实有很多。不过我不怎么想罗马帝国，那不是其中之一。

---

### (01:20:49) Lenny Rachitsky

**English:**
I also don't think about the Roman Empires, something's wrong with me. Okay, final question. You can blame your colleague Barr for this question. He tells me that you are very good at jokes, you tell very good jokes. Do you have a joke that you want to share by any chance?

**中文翻译:**
我也不想罗马帝国，看来我有问题。好，最后一个问题。你可以把这个问题怪到你同事 Barr 头上。他告诉我你非常擅长讲笑话，讲得非常好。你有什么想分享的笑话吗？

---

### (01:21:06) Ami Vora

**English:**
I love jokes. There was a year at Facebook where I posted a joke of the week to the company and they're all terrible.

**中文翻译:**
我爱笑话。在 Facebook 的有一年，我每周都会向全公司发布一个“每周笑话”，结果全都很冷。

---

### (01:21:15) Lenny Rachitsky

**English:**
To the company.

**中文翻译:**
向全公司？

---

### (01:21:19) Ami Vora

**English:**
Yeah, exactly. All right. Here's my favorite joke.

**中文翻译:**
是的，没错。好，这是我最喜欢的笑话。

---

### (01:21:22) Lenny Rachitsky

**English:**
Great.

**中文翻译:**
太好了。

---

### (01:21:24) Ami Vora

**English:**
Why don't sharks eat clowns?

**中文翻译:**
为什么鲨鱼不吃小丑？

---

### (01:21:26) Lenny Rachitsky

**English:**
Why?

**中文翻译:**
为什么？

---

### (01:21:27) Ami Vora

**English:**
Because they taste funny. I'll tell you one more and you can choose one, you can choose which one. All right.

**中文翻译:**
因为他们尝起来“很有趣”（Taste funny，funny 兼有有趣和古怪的意思）。我再给你讲一个，你可以选一个。好。

---

### (01:21:33) Lenny Rachitsky

**English:**
No, we're not cutting anything.

**中文翻译:**
不，我们什么都不会剪掉。

---

### (01:21:36) Ami Vora

**English:**
What did the zero say to the eight?

**中文翻译:**
0 对 8 说了什么？

---

### (01:21:38) Lenny Rachitsky

**English:**
What did the zero say to the eight? Something like us. Okay, no, I don't know.

**中文翻译:**
0 对 8 说了什么？“长得像我们”之类的？好吧，我不知道。

---

### (01:21:43) Ami Vora

**English:**
Nice belt.

**中文翻译:**
“腰带不错。”

---

### (01:21:44) Lenny Rachitsky

**English:**
Nice what?

**中文翻译:**
什么不错？

---

### (01:21:45) Ami Vora

**English:**
Belt.

**中文翻译:**
腰带。

---

### (01:21:46) Lenny Rachitsky

**English:**
Belt. Oh, I got it.

**中文翻译:**
腰带。噢，我懂了（8 就像 0 系了腰带）。

---

### (01:21:51) Ami Vora

**English:**
[inaudible 01:21:51].

**中文翻译:**
（听不清）

---

### (01:21:53) Lenny Rachitsky

**English:**
I get it, I get it. I'm going to tell you a joke. I just heard a standup share. How do you turn an egg into a vegetable?

**中文翻译:**
我懂了，我懂了。我也给你讲一个，我刚听一个脱口秀演员说的。你怎么把鸡蛋变成蔬菜？

---

### (01:22:02) Ami Vora

**English:**
I feel like if you put a letter on it'll turn into a vegetable name, but I can't think of the letter.

**中文翻译:**
我觉得如果你加一个字母，它就会变成一种蔬菜的名字，但我还没想到是哪个字母。

---

### (01:22:06) Lenny Rachitsky

**English:**
I love that you're really trying to analyze it and get there because I don't know if it's ever possible to actually get the answer. Okay, so how do you turn an egg into a vegetable? Squash.

**中文翻译:**
我喜欢你努力分析并试图找到答案的样子，因为我不知道是否真的能猜到。好，怎么把鸡蛋变成蔬菜？“压扁它”（Squash，既是压扁的意思，也是西葫芦/南瓜的意思）。

---

### (01:22:17) Ami Vora

**English:**
That is definitely my level of joke, definitely.

**中文翻译:**
这绝对是我这个水平的笑话，绝对是。

---

### (01:22:20) Lenny Rachitsky

**English:**
They're like, this is for your kid. Go home and do this joke. Ami, this was everything I hoped it would be. I'm going to read again the goal you had for this podcast, I 100% think we achieved it. To be as authentic as possible and show that people can be pretty messy and imperfect at times, yet still be very successful. I think exactly what this podcast ended up being. Thank you so much for being here.

**中文翻译:**
他们会说：“这是给你孩子讲的。回家讲这个笑话吧。”Ami，这次对话完全符合我的预期。我再读一遍你为这次播客设定的目标，我百分之百认为我们实现了它：尽可能保持真实，并展示出人们有时可以表现得很凌乱、很不完美，但依然能取得巨大的成功。我想这正是这期播客最终呈现的样子。非常感谢你能来到这里。

---

### (01:22:40) Lenny Rachitsky

**English:**
Two final questions. Where can folks find you online if they want to reach out and learn more, and how can listeners be useful to you?

**中文翻译:**
最后两个问题。如果大家想联系你或了解更多信息，可以在哪里找到你？以及，听众可以为你提供什么帮助？

---

### (01:22:46) Ami Vora

**English:**
Oh, thank you, Lenny. It's been such a pleasure. I write a blog on Substack at amivora@substack.com. It's called The Hard Parts of Growth, it's just about how even when you're working in great places with great people at great companies, sometimes things are hard and that's normal. And so you can find me there. I do the same, I crosspost to LinkedIn so you can find me there. And how can people be helpful to me? I don't know, just by being great, by being kind and nice and making the world slightly better. Yeah, I think that's what we can all do.

**中文翻译:**
噢，谢谢你，Lenny。这真是一次愉快的经历。我在 Substack 上写博客，地址是 amivora@substack.com。它叫《成长的艰辛部分》（The Hard Parts of Growth），讲的是即使你在伟大的公司、与优秀的人一起在很棒的地方工作，有时事情依然很艰难，而这很正常。你可以在那里找到我。我也会同步发布到 LinkedIn。至于大家能帮我什么？我不知道，只要保持优秀、保持善良和友好，让世界变得稍微好一点点。是的，我想那是我们所有人都能做的。

---

### (01:23:17) Lenny Rachitsky

**English:**
I love that, and I will link to your Substack in the show notes, so if where people want to check it out, and I'll recommend it. I haven't done it yet, but I'm going to recommend it for my Substack.

**中文翻译:**
我喜欢这个。我会在节目笔记中附上你的 Substack 链接，方便大家查看。我也会推荐它，虽然还没做，但我会在我的 Substack 上推荐它。

---

### (01:23:25) Ami Vora

**English:**
Thank you, Lenny, so much. This was such a fun conversation. I've really enjoyed it.

**中文翻译:**
非常感谢你，Lenny。这是一次非常有趣的对话。我很享受。

---

### (01:23:29) Lenny Rachitsky

**English:**
I loved it. Ami, thank you so much for being here. Bye, everyone.

**中文翻译:**
我也很喜欢。Ami，非常感谢你能来。大家再见。

---

### (01:23:33) Ami Vora

**English:**
Bye.

**中文翻译:**
再见。

---

### (01:23:35) Lenny Rachitsky

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。