# Andrew Wilkinson - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Andrew Wilkinson.

---

### (00:00:00) Andrew Wilkinson

**English:**
You don't want to walk into the gym on day one and try and deadlift 300 pounds. So when someone comes to me and they're a first time entrepreneur and they say, "I'm going to make the next great AI company," I think that is the equivalent.

**中文翻译:**
你肯定不想在第一天走进健身房就尝试硬拉 300 磅。所以，当有人来找我，作为一个初次创业者说“我要打造下一家伟大的 AI 公司”时，我认为这性质是一样的。

---

### (00:00:12) Lenny Rachitsky

**English:**
I feel like you've actually started and run more companies than maybe anyone else in the world. What is your best advice for coming up with a great startup idea?

**中文翻译:**
我觉得你创办和经营过的公司可能比世界上任何人都多。关于如何想出一个伟大的创业点子，你最好的建议是什么？

---

### (00:00:20) Andrew Wilkinson

**English:**
Charlie Munger, Warren Buffett's longtime business partner, has this amazing quote.

**中文翻译:**
沃伦·巴菲特的长期商业伙伴查理·芒格有一句名言。

---

### (00:00:24) Speaker 3

**English:**
Fish where the fish are.

**中文翻译:**
去有鱼的地方钓鱼。

---

### (00:00:26) Andrew Wilkinson

**English:**
The biggest mistakes I've made have been going into business models where other people have repeatedly failed and thinking, I can do this better.

**中文翻译:**
我犯过最大的错误就是进入那些别人屡遭失败的商业模式，并自以为我能做得更好。

---

### (00:00:34) Lenny Rachitsky

**English:**
It's so funny to watch you on Twitter. Clearly you've become AI obsessed.

**中文翻译:**
在 Twitter（现 X）上关注你很有趣。显然你已经对 AI 着迷了。

---

### (00:00:38) Andrew Wilkinson

**English:**
It's like having the world's most reliable employee who costs $200 a month and works 24/7. So many knowledge work jobs are going to change massively. I think the fundamental question is, do all jobs just become a single prompt?

**中文翻译:**
这就像拥有世界上最可靠的员工，每月只需 200 美元，而且全天候工作。许多知识型工作将发生巨大变化。我认为根本问题是：是否所有的工作最终都会变成一个简单的提示词（Prompt）？

---

### (00:00:54) Lenny Rachitsky

**English:**
Today, my guest is Andrew Wilkinson. Andrew is the co-founder and CEO of Tiny, a holding company that's often called the Berkshire Hathaway of the internet. They own over 40 businesses ranging from Dribble to WeCommerce to the AeroPress coffee maker, and they focused on buying profitable businesses from founders and holding them for the long term. Andrew and his co-founder bootstrapped the business from zero to hundreds of millions of dollars in value, and Andrew personally was worth over $1 billion at one point. In our wide-ranging conversation, we cover a bunch of strategies for coming up with a good business idea, what common business ideas you should avoid, his experience automating much of his work and life using AI, and what that means for employment in the near future. Also, what he's learned about happiness and money and how they're not directly related, and also how getting diagnosed with ADHD and then taking SSRIs was the thing that most impacted his happiness in life.

**中文翻译:**
今天的嘉宾是 Andrew Wilkinson。Andrew 是 Tiny 的联合创始人兼 CEO，这家控股公司常被称为“互联网界的伯克希尔·哈撒韦”。他们拥有 40 多家企业，从 Dribble 到 WeCommerce，再到 AeroPress 咖啡机。他们专注于从创始人手中收购盈利的企业并长期持有。Andrew 和他的合伙人白手起家（Bootstrapped），将业务从零做到了数亿美元的价值，Andrew 本人的身价曾一度超过 10 亿美元。在我们这次广泛的交流中，我们讨论了构思创业点子的策略、应该避开哪些常见的业务类型、他利用 AI 自动化大部分工作和生活的经验，以及这对未来就业的意义。此外，他还分享了关于幸福与金钱的感悟（以及两者为何没有直接关系），以及被诊断出 ADHD（多动症）并服用 SSRI（选择性 5-羟色胺再摄取抑制剂）药物是如何成为对他生活幸福感影响最大的因素。

---

### (00:01:46) Lenny Rachitsky

**English:**
This is both a powerful and also a very tactically useful conversation and I'm really excited for you to hear it. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a year free of a bunch of amazing products including Bolt, Linear, Superhuman, Notion, Perplexity, Granola and more. Check it out at Lenny's newsletter.com and click bundle. With that, I bring you Andrew Wilkinson. This episode is brought to you by Sauce. The way teams turn feedback into product impact is stuck in the past, vague reports, static taxonomies, unactionable insights that don't move business metrics. The result, churn, lost deals, misgrowth. Sauce is the AI product copilot that helps CPOs and product teams uncover business impact and act faster. It listens to your sales calls, support tickets, churn reasons, and lost deals, surfacing the biggest product issues and opportunities in real time.

**中文翻译:**
这是一次既有深度又极具战术实用性的对话，我非常期待你们能听到。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我新闻通讯（Newsletter）的年度订阅者，你将免费获得一年的一系列优秀产品，包括 Bolt、Linear、Superhuman、Notion、Perplexity、Granola 等。请访问 Lennysnewsletter.com 并点击“Bundle”查看。现在，让我们欢迎 Andrew Wilkinson。本期节目由 Sauce 赞助。团队将反馈转化为产品影响力的方式还停留在过去：模糊的报告、静态的分类、无法转化为行动且不能推动业务指标的见解。结果就是：用户流失、丢单、增长停滞。Sauce 是一款 AI 产品副驾驶（Copilot），帮助 CPO 和产品团队发现业务影响并更快采取行动。它能听取你的销售电话、支持工单、流失原因和丢单情况，实时呈现最大的产品问题和机会。

---

### (00:02:41) Lenny Rachitsky

**English:**
It then routes them to the right teams to turn signals into PRDs, prototypes, and even code that drives revenue retention and adoption. That's why Whatnot, Linktree, Incident.io and Zip use Sauce one enterprise uncovered a product gap that unlocked $16 million ARR, another caught a issue and prevented millions in churn. You can too at sauce.app/lenny. Sauce built for AI product teams, don't get left behind.

**中文翻译:**
然后，它会将这些信息分发给正确的团队，将信号转化为 PRD（产品需求文档）、原型，甚至是能推动收入增长、留存和采用的代码。这就是为什么 Whatnot、Linktree、Incident.io 和 Zip 都在使用 Sauce。一家企业通过它发现了一个产品空白，从而释放了 1600 万美元的 ARR（年度经常性收入）；另一家企业捕捉到了一个问题，阻止了数百万美元的流失。你也可以访问 sauce.app/lenny 体验。Sauce 专为 AI 产品团队打造，别被时代抛在后面。

---

### (00:03:10) Lenny Rachitsky

**English:**
This episode is brought to you by Enterpret. Enterpret is a customer intelligence platform used by a leading CXN product orgs like Canva, Notion, Perplexity, Strava, Hinge, and Linear to leverage the voice of the customer and build best-in-class products. Enterpret unifies all customer conversations in real time, from Gong recordings to Zendesk, tickets to Twitter threads, and makes it available for your team for analysis and for action. What makes Enterpret unique is its ability to build and update a customer-specific knowledge graph that provides the most granular and accurate categorization of all customer feedback and connects that customer feedback to critical metrics like revenue and CSAT. If modernizing your voice of customer program to a generational upgrade is a 2025 priority, like customer-centric industry leaders like Canva, Notion, Perplexity, and Linear, reach out to the team at enterpret.com/lenny. That's E-N-T-E-R-P-R-E-T.com/lenny.

**中文翻译:**
本期节目由 Enterpret 赞助。Enterpret 是一个客户智能平台，被 Canva、Notion、Perplexity、Strava、Hinge 和 Linear 等领先的客户体验（CX）和产品组织所采用，旨在利用客户的声音打造一流产品。Enterpret 实时统一所有客户对话——从 Gong 的录音到 Zendesk 的工单，再到 Twitter 的帖子——并供你的团队进行分析和采取行动。Enterpret 的独特之处在于它能够构建并更新特定于客户的知识图谱，对所有客户反馈进行最细致、最准确的分类，并将这些反馈与收入和 CSAT（客户满意度）等关键指标联系起来。如果将你的“客户之声”计划进行代际升级是 2025 年的优先事项，请像 Canva、Notion、Perplexity 和 Linear 这些以客户为中心的行业领导者一样，联系 enterpret.com/lenny 团队。

---

### (00:04:12) Lenny Rachitsky

**English:**
Andrew, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Andrew，非常感谢你能来。欢迎来到本播客。

---

### (00:04:15) Andrew Wilkinson

**English:**
Oh, thanks man, great to be here.

**中文翻译:**
噢，谢谢，很高兴能来到这里。

---

### (00:04:17) Lenny Rachitsky

**English:**
I've been wanting to chat with you for so long. There's so much that I want to talk about and I want to start with a topic that I know that you think a lot about and that it's also in the minds of a lot of people, which is coming up with a great startup idea and this is something that a lot of people are thinking about right now because AI makes it so easy to actually build your idea into something real, and I feel like this is something you spent a lot of time thinking about. I feel like you've actually started and run more companies than, I don't know, maybe anyone else in the world. I feel like you're in the top a hundred, top 10, something like that. I don't know. Does that feel right?

**中文翻译:**
我一直想找你聊聊。我想谈的话题很多，首先我想从一个我知道你思考了很多，也是很多人都在关注的话题开始，那就是：如何想出一个伟大的创业点子。现在很多人都在思考这个问题，因为 AI 让把想法变成现实变得非常容易。我觉得你在这个问题上花了很多时间。我感觉你创办和经营过的公司可能比世界上任何人都多，也许能排进前一百甚至前十。我不确定，你觉得这个说法对吗？

---

### (00:04:51) Andrew Wilkinson

**English:**
I've definitely had a lot of experiences and I've probably started or been involved with 75 different projects or businesses where I've been a primary contributor and I wouldn't say that's anything to brag about because I've been an inch deep in a mile wide. So that's been in a lot of ways kind of my Achilles heel is I get too excited about ideas and I start too many businesses, but as a result I've seen almost every business model under the sun.

**中文翻译:**
我确实有很多经历，我可能创办或参与过 75 个不同的项目或企业，并在其中担任主要贡献者。我不觉得这有什么好炫耀的，因为我一直处于“一英里宽，一英寸深”的状态（指涉猎极广但不够深入）。在很多方面，这是我的阿喀琉斯之踵——我对点子太容易兴奋，创办了太多的公司。但结果是，我几乎见识过阳光下的每一种商业模式。

---

### (00:05:18) Lenny Rachitsky

**English:**
Amazing. Okay. Yeah, I think the benefit is for us is we get to learn from your experience. Let me just ask you this question, what is your best advice for coming up with a great startup idea?

**中文翻译:**
太棒了。好的，我想对我们来说，好处是可以从你的经验中学习。让我直接问这个问题：关于如何想出一个伟大的创业点子，你最好的建议是什么？

---

### (00:05:28) Andrew Wilkinson

**English:**
Ultimately the best thing is something you're going to be interested in, but I think a mistake a lot of people make is they choose something that everybody is interested in. So for example, they say I don't know anyone that has hadn't had the thought, man, I would love to start a really cool restaurant or I want to have a cool cafe or something. And in reality, what they think about is how cool would it be to come up with an amazing logo or all fun stuff, design the menu and stuff. But in reality, operating those businesses is miserable and it's also a very hard business because every morning millions of people wake up and they go, I should start a cafe. But on the flip side, almost nobody wakes up every morning and says, "You know what? I'd love to start a funeral home," or "I would like to start a pest control business," or "I should start software that helps people fill out forms for the government."

**中文翻译:**
最终，最好的点子应该是你感兴趣的事情。但我认为很多人犯的一个错误是，他们选择了每个人都感兴趣的事情。例如，几乎每个人都曾想过：“天哪，我很想开一家很酷的餐厅，或者开一家很酷的咖啡馆。” 实际上，他们想到的是设计一个惊艳的 Logo、设计菜单这些有趣的事。但现实中，经营这些业务是痛苦的，而且竞争极其激烈，因为每天早上都有成千上万的人醒来想：“我应该开家咖啡馆。” 但反过来说，几乎没有人每天醒来会说：“你知道吗？我很想开一家殡仪馆，”或者“我想做害虫防治业务，”或者“我应该开发一个帮人们填写政府表格的软件。”

---

### (00:06:26) Andrew Wilkinson

**English:**
And Charlie Munger, Warren Buffett's longtime business partner, has this amazing quote. He says, "Fish where the fish are." And he gives this example, he says, "If you're a fisherman and you see a large pond and all around the pond, there's a whole bunch of fishermen and they're all elbowing each other out of the way. They're all using the best lures, the best fishing line, they all have amazing strategy. You actually want to walk off into the forest and find a small fishing hole with lots of fish and very little competition. And I think that's probably the most important thing in business is actually to find those niches where you can actually make real money because competition equals lower margin. The more competitors there are, the lower your prices have to be and the more competitive the business is ultimately.

**中文翻译:**
沃伦·巴菲特的长期商业伙伴查理·芒格有一句名言，他说：“去有鱼的地方钓鱼。” 他举了这样一个例子：如果你是一个渔夫，你看到一个大池塘，池塘周围挤满了渔夫，大家都在互相推搡。他们都用着最好的诱饵、最好的鱼线，都有着惊人的策略。这时候，你其实应该走进森林，找一个小水坑，那里鱼很多，但几乎没有竞争。我认为在商业中最重要的事就是找到那些能赚到真钱的利基市场（Niches），因为竞争意味着低利润。竞争对手越多，你的价格就必须越低，生意最终就会变得越难做。

---

### (00:07:19) Lenny Rachitsky

**English:**
It doesn't feel intuitive to go after small markets and to find niches. So let's just follow that thread. Well, why is that actually a source of some of the best ideas starting really small and niche?

**中文翻译:**
追求小市场和寻找利基市场似乎并不符合直觉。让我们顺着这个思路聊聊：为什么从极小和利基的市场开始，反而是产生一些最好点子的源泉呢？

---

### (00:07:30) Andrew Wilkinson

**English:**
I don't necessarily think it has to be something that is small forever, but it has to be something that like I think about if you're a first time entrepreneur or a student or something, you don't want to walk into the gym on day one and try and deadlift 300 pounds. So when someone comes to me and they're a first time entrepreneur and they say, "I'm going to make the next great AI company," or "I'm going to launch a new bank," or something like that, something that is very, very rigorous and complicated and highly competitive and regulated, I think that is the equivalent. I think you really want to take the baby weights and start slowly building your muscle. And I think about my own experience starting a business, I was so lucky because the first business I ever started my web design agency, which became Metalab, that was so easy and it worked immediately because all I had to do was know how to build websites and be able to talk to potential customers.

**中文翻译:**
我不认为它必须永远很小，但它必须是那种……我想，如果你是一个初次创业者或学生，你肯定不想在第一天走进健身房就尝试硬拉 300 磅。所以当有人作为初次创业者来找我说“我要做下一家伟大的 AI 公司”或者“我要开一家新银行”之类的事情时——这些事情非常严谨、复杂、竞争激烈且受监管——我认为这就相当于硬拉 300 磅。我觉得你应该先拿轻量级的哑铃，慢慢锻炼肌肉。回想我自己创业的经历，我非常幸运，因为我创办的第一家公司——后来成为 Metalab 的网页设计机构——非常容易，而且立即就成功了。因为我当时只需要知道如何建网站，并能与潜在客户沟通。

---

### (00:08:33) Andrew Wilkinson

**English:**
And then once they said, "Yes, I will pay you $5,000," I just had to send them an invoice, do the work, and that was it. It was a very simple business. And because of that, I got immediate positive feedback and I built my own narrative. And my narrative was, "I'm good at business, I can do this, keep going." And then I went off and I started taking my money that I made from that original business and that's when I fucked up. So I went out and I started a pizzeria and I lost all my money. I started a designer cat furniture business, a online DJ school, a skin cream business, all of these things. I've just lost all my money almost immediately, but because I had that first win I kept on going. And I just think it's so critical that people choose a business where they get that initial win.

**中文翻译:**
一旦他们说“好，我付你 5000 美元”，我只需要发个发票，把活干完，就这么简单。这是一个非常简单的业务。正因为如此，我得到了即时的正向反馈，并建立了自己的心理叙事。我的叙事是：“我擅长做生意，我能行，继续加油。” 然后我拿着从第一家公司赚到的钱去折腾，结果就开始搞砸了。我开了一家披萨店，赔光了所有的钱。我还做过设计师猫家具业务、在线 DJ 学校、护肤霜业务，所有这些几乎立刻让我赔光了钱。但因为我有过第一次成功的经历，所以我坚持了下来。我认为人们选择一个能获得“初始胜利”的业务是至关重要的。

---

### (00:09:22) Lenny Rachitsky

**English:**
Okay, this is a great topic. This is just like how do you avoid creating a job for yourself that you hate? There's a lot of business opportunities and ideas that like, "Yeah, you can make this work," and then it works, and then you're stuck doing this thing running a restaurant. My wife tells a story where a friend started a coffee shop and then he's like, "I thought I was starting a coffee shop, but I'm just replacing milk and buying milk all day. That's my job now." So just kind of along those lines to help people avoid creating a beast that they didn't expect any advice for Just how to know this is maybe even though this may work and make money, you probably don't want to be spending your life doing this sort of business.

**中文翻译:**
好的，这是一个很棒的话题。这就像是如何避免为自己创造一份讨厌的工作？有很多商业机会和点子，你确实能把它做成，但一旦成功了，你就被困在经营餐厅这类事情中了。我妻子讲过一个故事，她有个朋友开了一家咖啡馆，然后他说：“我以为我是在开咖啡馆，结果我整天都在换牛奶、买牛奶。这就是我现在的工作。” 所以，为了帮助人们避免创造出一个超出预期的“怪兽”，你有什么建议吗？如何判断即使这门生意能赚钱，你可能也不想把一生花在这种业务上？

---

### (00:09:59) Andrew Wilkinson

**English:**
So I just started a pressure washing business. I was speaking at a local business school and after I spoke, one of the kids walked up to me and he said, "Hey, I'm an entrepreneur. I've started two or three businesses in the past doing landscaping and I'm not enjoying school." And so just on the spot, I said to him, "Why don't you drop out and we'll start a business together?" And I'd been cooking on this idea of a pressure washing business because I'd studied that industry a little bit and I knew a few friends who'd done it in other cities. And I had this unfair advantage, which is I owned a whole bunch of media properties where I could advertise it for free basically. And so we started this business and I think for him, he kind had this moment of, do I really want to be washing people's driveways for the rest of my life?

**中文翻译:**
我最近刚创办了一家高压清洗业务。我在当地一所商学院演讲，结束后一个孩子走过来对我说：“嘿，我是个创业者。我过去做过两三家景观美化公司，我不喜欢上学。” 于是我当场对他说：“你为什么不退学，我们一起创办一家公司呢？” 我当时一直在构思高压清洗业务，因为我研究过这个行业，也知道几个在其他城市做这个的朋友。而且我有一个“不公平竞争优势”，那就是我拥有一堆媒体资产，基本上可以免费打广告。于是我们创办了这家公司。我想对他来说，他曾有过这样一个瞬间：“我真的想余生都在帮人冲洗车道吗？”

---

### (00:10:47) Andrew Wilkinson

**English:**
And what I said to him is, "Look, if this gets to scale, you'll never touch a pressure washer unless you want to." If the business can get big enough where you can have employees, he can just focus on sales or digital marketing or whatever aspect of the business that he really loves. And I think that's the biggest thing that a lot of entrepreneurs miss. They say, "I don't want to do that for the rest of my life. I don't want to be in the back of a dry cleaner dry cleaning clothes." And to me it's just a question of scale. I think the cafe is a great example because a cafe, if it doesn't get to a reasonable scale is just a job.

**中文翻译:**
我对他说的是：“听着，如果这门生意做大了，除非你想，否则你永远不需要碰高压清洗机。” 如果业务规模足够大，可以雇佣员工，他就可以专注于销售、数字营销或任何他真正喜欢的业务环节。我认为这是很多创业者忽略的一点。他们说：“我不想余生都做那个，我不想在干洗店后面洗衣服。” 对我来说，这只是一个规模问题。咖啡馆是一个很好的例子，因为如果咖啡馆达不到一定的规模，它就只是一份工作。

---

### (00:11:26) Andrew Wilkinson

**English:**
There's a big difference between a business and a job. I think if you could start a pressure washing business where you're the only employee, yeah, that's a job, but if you can get to a scale where you can drive 10 leads a day, then you don't have to do any of the pressure washing and you just do what you love. So I think a lot of people have this kind of Protestant work ethic where they think, well, I've got to be the person to do everything. And I think they really need to lean into what I call lazy leadership, which is how do I get away from the things I hate as quickly as humanly possible? How do I be Teflon for tasks?

**中文翻译:**
“事业”和“工作”之间有很大的区别。如果你创办的高压清洗业务只有你一个员工，那确实是一份工作。但如果你能做到每天能吸引 10 个潜在客户的规模，那你就不需要亲自去清洗，只需要做你喜欢的事。我觉得很多人有一种“清教徒式的工作伦理”，认为自己必须亲力亲为。我认为他们真正需要学习的是我所说的“懒惰领导力”，即：如何以最快的速度摆脱我讨厌的事情？如何对任务像特氟龙（Teflon，不粘锅涂层）一样不粘手？

---

### (00:12:00) Lenny Rachitsky

**English:**
It's interesting that this business is non-software related at all, this pressure washing business. So I guess just for folks that are coming up with ideas, and I imagine most ideas are there's a pull to make it software oriented, something AI is going to help build for you and help you run. What's your calculus on just going down a direction of real world physical business, like a restaurant power washing business versus a software just like what are the benefits of that direction when should someone actually seriously think about doing a business like a power washing business?

**中文翻译:**
很有趣，这个高压清洗业务完全与软件无关。我想对于那些正在构思点子的人来说，大多数想法都会倾向于软件导向，或者是 AI 能帮你构建和运行的东西。你对于选择现实世界的实体业务（如餐厅、高压清洗）还是软件业务的权衡标准是什么？这种方向的优势是什么？什么时候一个人应该认真考虑做像高压清洗这样的业务？

---

### (00:12:30) Andrew Wilkinson

**English:**
I think if someone's listening to this podcast, odds are they're someone who's kind of a digital native. And I think the question is, what's your unfair advantage and what are you great at? So for me, I think I have reasonably good taste. And so what I could do is I identify and I knew enough to identify great design and development talent, but mostly I was lucky because I was a talker. I was good at meeting with clients and selling myself. And so ultimately my highest and best use my superpower was sales. And so that can be applied to anything, anything where you need to go out and you need to sell a customer. And so really it just comes down to what do you get drawn to and then how do you find the profitable business within that? So here's an example. A friend of mine, he owns a restaurant and he said, "Oh, I love it. I'm so passionate about it. It's this stunning beautiful restaurant in my hometown."

**中文翻译:**
我想，如果有人在听这个播客，他们很可能是“数字原住民”。我认为关键问题是：你的不公平优势是什么？你擅长什么？对我来说，我认为我有不错的品味。因此，我能识别出优秀的规划和开发人才。但最主要的是我很幸运，因为我很健谈，擅长见客户并推销自己。所以最终，我最高效的用途、我的超能力是销售。这可以应用到任何领域，任何需要你去推销客户的地方。所以，这取决于你被什么吸引，以及你如何从中找到盈利的业务。举个例子：我有一个朋友开了一家餐厅，他说：“噢，我爱死它了，我对此充满激情。这是我家乡一家非常漂亮的餐厅。”

---

### (00:13:32) Andrew Wilkinson

**English:**
And he said, "But it's really just a job for a few different people and we can't make any money at it, but I've been noticing that there's all these vendors that service the restaurant and those guys are making a killing." And so he told me about a business that cleans grease traps, another one that cleans exhaust vents for kitchens. So I think looking around and seeing where your passion is and then sniffing around within it, probably somewhere within your passion, there's an opportunity. So for example, I love movies. My happy place is a dark theater. That's the best way for me to de-stress is go to a dark theater and watch a movie and get lost in it. And probably about four or five years ago, I was like, "Man, how cool would it be to invest in movies in some way to be a part of that creative world?"

**中文翻译:**
他说：“但这其实只是几个人的工作，我们赚不到钱。但我注意到，所有为餐厅提供服务的供应商都在大赚特赚。” 他告诉我有一家公司专门清理隔油池，另一家专门清理厨房排气口。所以，看看你的热情所在，然后在其中四处打探，很可能在你的热情领域里就藏着机会。例如，我热爱电影。我最放松的地方就是黑暗的电影院。对我来说，最好的减压方式就是去电影院看场电影，沉浸其中。大约四五年前，我想：“天哪，如果能以某种方式投资电影，成为那个创意世界的一部分，该有多酷？”

---

### (00:14:26) Andrew Wilkinson

**English:**
And so I started looking into funding movies and I realized that when you fund movies, like 90% of the time you lose all your money. And even if you do make some money, you rarely make a good return. But I spend a bunch of time understanding the industry and learning about it. And then two years ago I was in New Zealand and I met the founder of Letterboxd and I realized, "Oh my God, this is a business where this has a moat, so it has a network effect, it's a huge social network for film reviewers. It's something I'm passionate about and it's something that we can buy at a fair price." All those things came together and I was like, "Oh my god, I can invest in film now." In the same way I used to be a barista, we ended up buying the AeroPress coffee maker company. So I follow my passions and spend a long time learning different industries and then I find the profitable niche within.

**中文翻译:**
于是我开始研究电影投资，结果发现投资电影 90% 的时间都会赔钱。即使赚了钱，回报率也很低。但我花了很多时间去了解和学习这个行业。两年前我在新西兰遇到了 Letterboxd 的创始人，我意识到：“天哪，这门生意有护城河，它有网络效应，它是影评人的巨大社交网络。这是我热爱的领域，而且我们可以以合理的价格收购它。” 所有这些因素结合在一起，我想：“天哪，我现在可以投资电影了。” 同样地，因为我以前当过咖啡师，我们最终收购了 AeroPress 咖啡机公司。所以我追随自己的热情，花很长时间学习不同的行业，然后在其中找到盈利的利基市场。

---

### (00:15:19) Lenny Rachitsky

**English:**
Okay, and this is a great takeaway essentially when you're thinking about startup ideas, make sure there's some connection to something unique to you where you have some unfair advantage. This makes me think about Brian Armstrong. I saw him do a talk once and he gave this really amazing insight about why Coinbase did well and why he started Coinbase. And it's because if you look at his background, he had this really rare Venn diagram of background of computer science and I think it was cryptography and economics, which is the exact set of skills you need to start something like Coinbase. So I think the tip there is just what is that unique Venn diagram of skills in your background and just ideally what you're building connects to that and gives you an unfair advantage.

**中文翻译:**
好的，这是一个非常棒的总结：当你思考创业点子时，确保它与你独特的地方有某种联系，让你拥有某种不公平优势。这让我想起了 Brian Armstrong（Coinbase 创始人）。我听过他的一次演讲，他分享了一个关于 Coinbase 为什么成功以及他为什么要创办 Coinbase 的精彩见解。如果你看他的背景，他拥有一个非常罕见的技能韦恩图：计算机科学、密码学和经济学。这正是创办 Coinbase 所需的技能组合。所以，这里的建议是：看看你背景中独特的技能韦恩图是什么，理想情况下，你所构建的东西应该与之相连，并赋予你不公平的优势。

---

### (00:16:02) Andrew Wilkinson

**English:**
Well, yeah. I just met another UVic student at the local university student. She is interested in marketing and so she's gone out and she's found some local clients, so small restaurants and stuff and managed their social media and she said, "Yeah, it's okay. I can make a thousand bucks a month, but it's a lot of work," and the owners really want a lot for their money. And I said, "Well, if you just pivot that idea just ever so slightly, and instead of doing restaurants, you did realtors or wealth managers who have quite a large marketing budget and are used to spending serious money and it only has to work a little bit to make a lot of money for them. Those people, you can charge $5,000 a month."

**中文翻译:**
没错。我最近在当地大学遇到另一个维多利亚大学的学生。她对营销感兴趣，所以她找了一些当地客户，比如小餐厅之类的，帮他们管理社交媒体。她说：“还行吧，一个月能赚 1000 美元，但工作量很大，”而且老板们总想花小钱办大事。我对她说：“如果你稍微调整一下这个点子，不去做餐厅，而是去做房地产经纪人或财富管理人，他们有很大的营销预算，习惯于花大钱，而且只要有一点效果就能帮他们赚很多钱。对这些人，你可以每个月收 5000 美元。”

---

### (00:16:44) Andrew Wilkinson

**English:**
So I think often it's you find your passion, your skill set, you zero in, and then you just kind of pivot and you find the most profitable way to do it. When I started my web design firm, I started mostly with local and small projects, but very quickly I found a job board in San Francisco where startups would share projects they needed help with. I could charge five times the amount for five times less work.

**中文翻译:**
所以我觉得通常情况是：你找到你的热情和技能组合，锁定目标，然后稍微转型，找到最盈利的方式。当我创办网页设计公司时，我最初主要做本地的小项目，但很快我在旧金山发现了一个招聘板，初创公司会在上面分享他们需要帮助的项目。我可以收五倍的费用，而工作量只有原来的五分之一。

---

### (00:17:09) Lenny Rachitsky

**English:**
This point about fish where the fish are I think is really important. You can start something that's awesome that you love, that you're so excited about, but nobody needs it. Talk a bit more about just what that looks like. What have you seen when you're thinking about ideas that tell you that there's fish but also not overfished as you pointed out?

**中文翻译:**
关于“去有鱼的地方钓鱼”这一点我认为非常重要。你可以创办一个你热爱、让你兴奋的超棒项目，但可能根本没人需要它。能再多谈谈这方面吗？当你思考点子时，你看到了什么迹象会让你觉得“这里有鱼”，而且像你指出的那样，“还没有被过度捕捞”？

---

### (00:17:25) Andrew Wilkinson

**English:**
I think it's hard like Warren Buffett has this great quote, "I'm a better businessman because I'm an investor and I'm a better investor because I'm a businessman." And I feel like in order to know what problems are valuable to solve, you kind of need to have valuable problems. So it's a bit of a hard thing because I remember when I was like 20, I would say, I hate how all the cat furniture I can buy for my cats is I bet people would pay a lot of money to solve this, but I didn't understand anything about the realities of that business model. I didn't understand how little people were actually willing to pay. I didn't have a enough life experience to go, "Yes, that's actually a worthwhile opportunity." And I think that being able to know what people would pay to solve the problem realistically is incredibly valuable.

**中文翻译:**
我认为这很难。沃伦·巴菲特有一句名言：“因为我是商人，所以我成了更好的投资者；因为我是投资者，所以我成了更好的商人。” 我觉得为了知道哪些问题值得解决，你首先需要接触到有价值的问题。这有点难，因为我记得我 20 岁的时候会说：“我讨厌我能买到的所有猫家具，我敢打赌人们愿意花大钱解决这个问题。” 但当时我完全不了解那个商业模式的现实。我不明白人们实际上愿意付出的钱是多么少。我没有足够的生活经验去判断：“是的，这确实是一个值得把握的机会。” 我认为，能够现实地知道人们愿意花多少钱来解决某个问题，是非常有价值的。

---

### (00:18:20) Andrew Wilkinson

**English:**
So my example of a realtor selling a house, because I've studied that industry, I know that a realtor can make like 20 to $50,000 selling a single house. So I can intuit that they'd be willing to spend a lot of money if I have a unique way of getting them clients that'll buy houses that'll convert at a high conversion rate that is worth $5,000 a lead maybe, right? So I think you kind of have to understand the problem in depth before you really know. Because when I was starting out, I would go down every rabbit trail, every infomercial idea I had I would think was genius.

**中文翻译:**
以房地产经纪人卖房子为例，因为我研究过那个行业，我知道经纪人卖掉一栋房子能赚 2 万到 5 万美元。所以我能直觉地感到，如果我有一种独特的方式帮他们找到买房客户，且转化率很高，那么一个线索可能就值 5000 美元，对吧？所以我觉得你必须深入了解问题才能真正明白。因为当我刚开始创业时，我会钻进每一个死胡同，我觉得我想到的每一个电视购物式的点子都是天才之作。

---

### (00:18:59) Lenny Rachitsky

**English:**
Or people, I don't know, that don't have this experience, which is most people. Is there one thing you do, maybe a heuristic that gives you a sense, maybe there's something here, maybe there's a lot of fish, maybe it's a value of prompt or no, the soul tell me it probably isn't.

**中文翻译:**
对于那些没有这种经验的人（也就是大多数人），你有没有什么方法，或者说一种启发式（Heuristic）的直觉，能让你感觉到“这里可能有戏”、“这里鱼很多”？或者说，有没有什么迹象能告诉你“这可能行不通”？

---

### (00:19:12) Andrew Wilkinson

**English:**
No, unfortunately, I think it's mostly gut. I mean Munger and Buffett talk about having a whole bunch of mental models in your brain and they form a latticework, right? And they all kind of piece together. And I feel like for me, there's so much of this that is, it's almost like I'm an AI model and I've trained on all this data of what works and what doesn't and what's a good moat and what's a bad business, et cetera. And when I see it, I just immediately know. I mean, I think all entrepreneurs are so lucky now to be able to go into Claude or ChatGPT and just say, "Hey, I'm thinking about starting a Botox clinic. Can you break down the numbers? Is this a good business? What's hard about it? What is the regulatory moat? What would my payroll look like?" I didn't have any of that and so I started so many incredibly stupid businesses, but I think there's no excuse at this point. You should be able to do it with AI.

**中文翻译:**
不，不幸的是，我认为主要靠直觉。芒格和巴菲特谈到过脑子里要有一堆“思维模型”，它们形成一个格栅（Latticework），互相拼凑在一起。对我来说，这就像我是一个 AI 模型，我已经针对“什么行得通、什么行不通”、“什么是好的护城河、什么是烂生意”等海量数据进行了训练。当我看到它时，我立刻就能知道。现在的创业者非常幸运，可以去问 Claude 或 ChatGPT：“嘿，我想开一家肉毒杆菌诊所。你能帮我拆解一下数据吗？这是一门好生意吗？难点在哪？监管护城河是什么？我的工资支出大概是多少？” 我以前没有这些工具，所以我创办了那么多愚蠢的公司。但在今天，已经没有借口了，你应该能用 AI 做到这些。

---

### (00:20:07) Lenny Rachitsky

**English:**
That's a really good tip actually. Then there's this point you made about boring is good. That's a really good piece of advice. A lot of people are going after flashy stuff, things they condemn on Twitter. Your advice here is boring is actually a really good thing because fewer people are going after it. Is that the general tip?

**中文翻译:**
这确实是个好建议。然后你提到了“枯燥即是好”。这是一个非常好的建议。很多人都在追求那些光鲜亮丽的东西，或者在 Twitter 上大谈特谈的东西。你的建议是，枯燥其实是一件好事，因为追求它的人更少。这是核心建议吗？

---

### (00:20:22) Andrew Wilkinson

**English:**
Totally. I mean, so I started this business, one of my first called Flow and Flow was basically Asana before Asana came out. So it was a way to manage your to-do's and projects with your team in a web app and we basically did the thing. We made the mistake that so many entrepreneurs make, which is to go after an industry that everybody goes after just like cafes. Everybody has the idea, man, I wish I could design my own project management system or my own to-do system. And not only that, but everybody loves new things. They love jumping around. I know me personally, in the last three years, I've probably used three different productivity systems and I love jumping around in them and I didn't understand that and I ended up losing $10 million trying to compete with venture-backed businesses and bootstrapping.

**中文翻译:**
完全正确。我创办的第一批公司中有一家叫 Flow，它基本上是在 Asana 出现之前的 Asana。它是一个在 Web 应用中与团队管理待办事项和项目的工具。我们犯了许多创业者都会犯的错误：进入一个每个人都想进入的行业，就像咖啡馆一样。每个人都有过这样的想法：“天哪，我希望我能设计自己的项目管理系统或待办事项系统。” 不仅如此，每个人都喜新厌旧，喜欢换来换去。就我个人而言，过去三年我可能用了三种不同的生产力系统，我喜欢在里面跳来跳去。当时我不明白这一点，结果我投入了 1000 万美元试图在白手起家的情况下与风投支持的企业竞争。

---

### (00:21:17) Andrew Wilkinson

**English:**
It was all my own money, poured $10 million, lit it on fire trying to compete with Asana because I didn't understand how the business world worked really as they had raised hundreds of millions of dollars and they were run by the co-founder of Facebook and it was a little bit like, I'm Fiji and I'm deciding I'm going to invade the United States in retrospect, just completely silly. Now on the flip side, if I'd taken that same amount of energy and I'd instead focused on, let's see, what's a really boring one I've heard about, there was a business I saw recently.

**中文翻译:**
那全是我的血汗钱，我投了 1000 万美元，就像烧钱一样试图与 Asana 竞争。因为我当时并不真正了解商业世界的运作方式——他们筹集了数亿美元，由 Facebook 的联合创始人经营。回想起来，这有点像我是斐济，却决定要入侵美国，简直愚蠢透顶。现在反过来想，如果我把同样的精力花在……让我看看，我听过的一个非常枯燥的业务，我最近看到的一家公司。

---

### (00:21:52) Andrew Wilkinson

**English:**
They were making $30 million a year and all they did was help people fill out forms to get government assistance in certain programs. So it'd be like your uncle is disabled and you need to access government funding. The process to do it is incredibly time-consuming and miserable and you have to fill out all these forms. They just have software that fills out the forms for you and it says, look, you're going to get $20,000 as a grant, pay us a thousand bucks, and that is such a boring, nobody wakes up and goes, "I want to make form filling software," but I think they would if they could make 20 million a year

**中文翻译:**
他们每年赚 3000 万美元，而他们所做的只是帮助人们填写表格，以获得某些项目的政府援助。比如你的叔叔残疾了，你需要申请政府资金。申请过程极其耗时且痛苦，你必须填写所有这些表格。他们只是开发了一个帮你填表的软件，然后说：“看，你能拿到 2 万美元的补助，付给我们 1000 美元就行。” 这是一个如此枯燥的业务，没有人醒来会说“我想做填表软件”，但我想如果能一年赚 2000 万，他们会愿意做的。

---

### (00:22:29) Lenny Rachitsky

**English:**
Along these lines of just bad ideas, things people shouldn't start, what are a few ideas that you think everyone thinks is going to be a great idea and then they do it and then they always fail?

**中文翻译:**
顺着这些“坏点子”或“人们不该创办的公司”的思路，有哪些点子是你认为每个人都觉得会是好主意，但一旦做了就总是失败的？

---

### (00:22:37) Andrew Wilkinson

**English:**
Well, I think the biggest mistake, I can speak from my own experience, the biggest mistakes I've made business-wise have been going into business models where other people have repeatedly failed and thinking, I can do this better. So for example, me and one of my best friends about 10 years ago, we really wanted to start a bar. We just thought it'd be so cool to have a bar where us and all of our friends could go, we thought it'd be great for the city. We thought we can run this really high margin because we're tech guys, we know how to build systems, we're good at business, and we were utterly humbled. We realized that we didn't know anything about business compared to someone who runs a pizzeria. If you think about it, like my example earlier of if you run a software company, what has to happen?

**中文翻译:**
我认为最大的错误——我可以从我自己的经验出发——就是在商业上进入那些别人屡遭失败的商业模式，并自以为我能做得更好。例如，大约 10 年前，我和我最好的一个朋友非常想开一家酒吧。我们觉得能有一个自己和朋友们常去的酒吧太酷了，对城市也有好处。我们觉得我们可以把它经营成高利润，因为我们是搞技术的，懂系统，擅长做生意。结果我们被现实狠狠打脸了。我们意识到，与经营披萨店的人相比，我们对生意一窍不通。你想想看，就像我之前举的例子，如果你经营一家软件公司，会发生什么？

---

### (00:23:24) Andrew Wilkinson

**English:**
You have to hire a bunch of nerds, they need internet connections and computers and you need to pay them and you need to coordinate online and everyone can work asynchronously. Nothing has to go right. It's not that complicated, at least at small-scale. A pizzeria, it's like if the baker doesn't wake up at three in the morning and start prepping dough, the entire thing is effed and all along the way there's a hundred different failure points from front of house, back of house, the deliveries, arriving on time, all this logistics. And so I think it's been stuff like that. I mean also I got into the news business, the local news business. I ended up buying an old paper in Vancouver and it's the exact same thing. It's like you can't take a brilliant management team and change a bad business model. Ultimately the business model wins.

**中文翻译:**
你只需要雇一群极客，他们需要网络和电脑，你付钱给他们，大家在线协作，异步工作。不需要事事完美，至少在小规模时没那么复杂。而披萨店呢，如果面包师没在凌晨三点起床准备面团，整件事就搞砸了。从前厅到后厨，从配送到准时送达，整个物流过程中有上百个可能的失败点。我觉得就是这类事情。我还涉足过新闻业，本地新闻业务。我买下了温哥华的一份老报纸，情况完全一样。你无法用一支优秀的管理团队去改变一个糟糕的商业模式。最终，商业模式决定胜负。

---

### (00:24:20) Lenny Rachitsky

**English:**
This is really good advice. Basically if there's a bunch of dead bodies in that space, there's probably something there that keeps killing them that you're probably not aware of until maybe somebody figures something out, right? Once in a while, once in a blue moon, someone's like, "Okay, here's how we do this and then it works."

**中文翻译:**
这建议非常好。基本上，如果某个领域已经尸横遍野，那说明那里一定有什么东西在不断“杀人”，而你可能还没意识到，直到有人最终解决了它。虽然偶尔、极少数情况下，会有人说“好，我们这样做”，然后就成功了。

---

### (00:24:34) Andrew Wilkinson

**English:**
Well, look at Instacart. When Instacart came out, everyone said, "Well, Webvan failed. This is never going to work." And we still don't necessarily know if Instacart is a great business. I don't know, I haven't studied it, but I think it was like, okay, enough technology has changed that it can happen, but would it be easier to start Instacart, Amazon or Coupang or would it be easier to start an enterprise SaaS software company? Definitely the enterprise SaaS software company.

**中文翻译:**
看看 Instacart。当 Instacart 出现时，每个人都说：“Webvan 失败了，这永远行不通。” 我们现在也不一定知道 Instacart 是否是一门伟大的生意。我不知道，我没研究过，但我认为当时的情况是：技术已经发生了足够的改变，让它变得可行。但问题是，创办 Instacart、亚马逊或 Coupang 更容易，还是创办一家企业级 SaaS 软件公司更容易？绝对是企业级 SaaS 软件公司。

---

### (00:25:02) Lenny Rachitsky

**English:**
I see. So this is I guess is the advice there. The thing that is easy to start is the thing you should not do because everyone's going after that.

**中文翻译:**
我明白了。所以这里的建议大概是：容易开始的事情是你最不该做的，因为每个人都在往里挤。

---

### (00:25:10) Andrew Wilkinson

**English:**
Well, it goes back to my gym analogy of if you're going to deadlift 300 pounds, trained for 15 years, you should have already had three startups and they should have worked and you've really built up the reps. And I think that if I was going to start Instacart, that's different than someone who's 20 starting it. Not that I would be good at it, but at least I would know what I'm getting into.

**中文翻译:**
这又回到了我那个健身房的比喻：如果你要硬拉 300 磅，你应该已经训练了 15 年，创办过三家成功的初创公司，并且已经积累了足够的经验。我想，如果我要创办 Instacart，那和一个 20 岁的人去创办是不一样的。不是说我一定能做好，但至少我知道我将面临什么。

---

### (00:25:32) Lenny Rachitsky

**English:**
Let's talk about something that is this endless debate on Twitter. Maybe it's a false dichotomy between lifestyle businesses, bootstrap businesses, this idea of not raising money, just making revenue, living off the revenue versus venture-backed venture scale companies feels like you're very good at the first bucket and a lot of people, this is their dream, "I'm just going to start something. I'll start a lifestyle business, make a few million a year, never raise money. Who needs VCs? VCs suck." Advice for deciding which route to go with an idea you have.

**中文翻译:**
让我们谈谈 Twitter 上那个永无止境的争论。也许这在“生活方式型业务”（Lifestyle Business）、“自筹资金业务”（Bootstrap Business）——即不融资、只靠营收生存——与“风投支持的规模化公司”之间是一个伪命题。感觉你非常擅长第一类，而很多人也以此为梦想：“我就创办个小公司，做个生活方式型业务，一年赚几百万，永远不融资。谁需要风投？风投太烂了。” 对于如何根据自己的点子决定走哪条路，你有什么建议？

---

### (00:26:03) Andrew Wilkinson

**English:**
Well, I think it's just not true that a "lifestyle" or bootstrap business can't get huge. I mean, we bootstrapped the entire business and now across all of our companies we do almost $300 million in revenue. And the whole time I had been focusing on taking, starting small businesses, small ideas, simple ideas, often buying small companies and watching them grow really big. And I think that the only difference between what we do and what a venture capitalist does is the level of tolerance of burning money on fire. And I just haven't seen that If we choose the right businesses that aren't in incredibly competitive markets or where they have some sort of moat. So what I mean by that is a great brand or a network effect like a social network or something like that, I don't feel we're holding them back by not letting them light up a bunch of money on fire because these things naturally grow.

**中文翻译:**
我认为“生活方式型”或自筹资金业务无法做大，这完全是一个误区。我们整个业务都是自筹资金的，现在我们所有公司的总营收接近 3 亿美元。一直以来，我专注于创办小业务、小点子、简单的想法，或者经常收购小公司并看着它们壮大。我认为我们所做的和风投所做的唯一区别在于对“烧钱”的容忍度。我发现，如果我们选择了正确的业务——那些不在极度竞争的市场中，或者拥有某种护城河的业务（比如强大的品牌或像社交网络那样的网络效应）——我不觉得不让他们烧钱是在阻碍他们，因为这些业务会自然增长。

---

### (00:27:12) Andrew Wilkinson

**English:**
The numbers, I mean they're like balloons, they just go as long as we don't mess them up too much. So I think the decision ultimately comes down to how hairy do you want your big, hairy, audacious goal to be? And if your big, hairy, audacious goal is I'm going to start the next satellite business that creates some sort of crazy technological revolution. Yes, you're going to have to raise a venture capital unless you're already a billionaire or something like that. But if you're wanting to just tinker and solve a problem that you think is not going to be hyper-competitive, so for example, that form-filling thing or software that just does a narrow thing that doesn't require 20, 30, 40 million to be lit on fire before it can make money, then you can have a wonderful life and build a wonderful company that can scale into the hundreds of millions of dollars if you play your cards right without ever raising money.

**中文翻译:**
那些数字就像气球，只要我们不搞砸，它们就会一直上升。所以，最终的决定取决于你想要一个多么宏大、艰难且大胆的目标（BHAG）。如果你的目标是创办下一家卫星公司，创造某种疯狂的技术革命，那么是的，你必须筹集风险投资，除非你已经是亿万富翁。但如果你只是想折腾一下，解决一个你认为竞争不会太激烈的问题——比如那个填表软件，或者只做一个细分领域的软件，不需要在赚钱前先烧掉两三千万美元——那么如果你牌打得好，你完全可以过上美好的生活，并建立一家规模达数亿美元的公司，而无需融资。

---

### (00:28:09) Lenny Rachitsky

**English:**
Per the story you shared with Flow where you're competing against a venture-funded company, if there is a venture-backed company in this space, is the advice you're not going to win competing with them most likely and try to do something else.

**中文翻译:**
根据你分享的 Flow 的故事，你在与一家风投支持的公司竞争。如果某个领域已经有了风投支持的公司，你的建议是“你很可能赢不了，还是换个事情做”吗？

---

### (00:28:22) Andrew Wilkinson

**English:**
Well, look at Things. Do you know Things?

**中文翻译:**
看看 Things（一款待办事项软件）。你知道 Things 吗？

---

### (00:28:25) Lenny Rachitsky

**English:**
I have used Things

**中文翻译:**
我用过 Things。

---

### (00:28:26) Andrew Wilkinson

**English:**
I do too. It's awesome. Things still exist and Things has existed for 20 years. It's run by I believe one or two or three people. It's not a big team, certainly under 10 people, it was, I believe, bootstrapped and it's just consistently delivered an exceptional product and built up a loyal following. They have their 10,000 true fans who use it, and that's enough for them, but they don't do a lot. They've been very intentional. They don't do any AI stuff, they don't have an API. They're not on Android. They're very focused and I think they have succeeded. But the question is, what would an MBA or a business professor say about their success? If the measure of success is did they maximize taking as much market share as possible and grow to be as big as possible, then the answer is no because Asana and other people have built multi-billion dollar companies.

**中文翻译:**
我也在用，它很棒。Things 依然存在，而且已经存在 20 年了。据我所知，它只有两三个人在经营，团队规模肯定不到 10 人。它是自筹资金的，始终如一地提供卓越的产品，并建立了忠实的追随者。他们有 1 万名真正的粉丝在使用它，这对他们来说足够了。但他们做得并不多，他们非常有针对性：不做 AI，没有 API，没有 Android 版。他们非常专注，我认为他们成功了。但问题是，MBA 或商学教授会如何评价他们的成功？如果成功的衡量标准是“是否最大化地占领了市场份额”以及“是否长到了最大规模”，那么答案是否定的，因为 Asana 和其他人已经建立了数十亿美元的公司。

---

### (00:29:28) Andrew Wilkinson

**English:**
If the goal is the founder has an incredible life, probably has three houses, flies all over the place, does whatever he wants, has recurring revenue and he gets to work with headphones on building beautiful piece of software that people love, then I think he's won. I am generally much more in the camp of the Things guy has won, not Dustin Moskovitz. Dustin Moskovitz is just playing a different game than the Things guy. And if Dustin Moskovitz was running Things, he'd be miserable and if the Things guy was running Asana, he would probably kill himself because he wants to put his headphones on and build.

**中文翻译:**
如果目标是创始人拥有精彩的生活，可能有三套房子，到处飞，想做什么就做什么，拥有经常性收入，并且可以戴着耳机开发人们喜爱的精美软件，那么我认为他赢了。我通常更倾向于认为 Things 的老板赢了，而不是 Dustin Moskovitz（Asana 创始人）。Dustin 玩的是和 Things 老板完全不同的游戏。如果让 Dustin 去经营 Things，他会很痛苦；如果让 Things 的老板去经营 Asana，他可能会崩溃，因为他只想戴上耳机搞开发。

---

### (00:30:05) Lenny Rachitsky

**English:**
I wonder why nobody has come. It feels like just with lifestyle businesses, if it's working and you would think somebody would come in with more money and more funding and just eat their lunch, is the key that the market is too small for a VC to ever be excited and so that's why no one's coming for them?

**中文翻译:**
我在想为什么没有人来竞争。感觉对于生活方式型业务，如果它运行良好，你会认为有人会带着更多的钱和融资进来抢走他们的生意。关键是不是因为市场太小，风投根本不感兴趣，所以才没人去动他们？

---

### (00:30:21) Andrew Wilkinson

**English:**
I think so. I mean, I think Things probably, I'm just guessing, I don't know any of the numbers or whatever, but I would assume it makes between five and $25 million of revenue, which to a VC is not even worth considering a VC. For a VC to invest in your business, you need to have a story where it's worth 300 million to a billion dollars or more. So it's just not that exciting to them, which again, going back to fish where the fish are, you don't want to be fighting against the commercial fishermen. If you just want to have a little business where you get enough fish to feed your family and your village or whatever, find the other fishing hole. Don't go where the trawlers are.

**中文翻译:**
我想是的。我猜——我不知道具体数据——Things 的年营收可能在 500 万到 2500 万美元之间，这对风投来说根本不值一提。风投要投资你的业务，你需要讲一个价值 3 亿到 10 亿美元甚至更多的故事。所以这对他们来说没那么吸引力。这再次回到了“去有鱼的地方钓鱼”：你不想和商业渔船竞争。如果你只想做个小生意，钓到足够的鱼养活家人和村庄，那就找另一个鱼塘。别去拖网渔船出没的地方。

---

### (00:31:04) Lenny Rachitsky

**English:**
This is great advice if you're trying to start a non venture backed company is find. This metaphor just keeps working for us, which is fish where the fish are, but not where the professional fishermen are. Also, ideally not where there's just a ton of, I don't know, fishermen from all over the place. I don't know, solopreneur fishermen. Okay. Coming back to just starting a successful company, what would you say are the keys to an amazing business model, an amazing business broadly, what should you be thinking about and looking into? I know you spent a lot of time thinking about this. When you're buying companies, what are a few bullet points that you want to focus on?

**中文翻译:**
如果你想创办一家非风投支持的公司，这建议太棒了。这个比喻对我们非常适用：去有鱼的地方钓鱼，但别去职业渔夫扎堆的地方。理想情况下，也别去那种挤满了来自各地的个体户渔夫的地方。好的，回到创办成功公司的话题，你认为一个优秀的商业模式、一个优秀的企业的关键是什么？你应该思考和研究什么？我知道你花了很多时间思考这个问题。当你收购公司时，你会关注哪几个核心点？

---

### (00:31:38) Andrew Wilkinson

**English:**
What I do for a living is basically buy businesses. So in my early career I started one business, then I started about 10 more, and then I realized starting businesses was extremely hard and I was doing pretty well. I was making quite a bit of money and I'd sold one of my businesses and I was looking out at the next 10 years and really asking myself what do I want my career to be and am I happy doing what I'm doing? And the answer was no. I did not starting businesses and experiencing that failure rate, it was incredibly stressful. And so I picked up a book about investing and I got lucky. The first one I bought was about Warren Buffett, and for those that don't know, Warren Buffett is he's counter to every VC kind of hustle culture thing you might hear because he basically just sits quietly in a room and reads all day, despite owning 260 different businesses and being one of the 10 wealthiest people in the world, his life is incredibly calm.

**中文翻译:**
我的职业基本上就是收购公司。在职业生涯早期，我创办了一家公司，接着又创办了大约 10 家，然后我意识到创业极其艰难。当时我做得还不错，赚了不少钱，也卖掉了一家公司。我展望未来的 10 年，问自己：我想要什么样的职业生涯？我现在做的事让我快乐吗？答案是不。我不喜欢创业，那种失败率带来的压力大得惊人。于是我拿起一本关于投资的书，我很幸运，买的第一本是关于沃伦·巴菲特的。对于那些不了解的人，巴菲特与你听到的任何风投式的“拼命文化”（Hustle Culture）都背道而驰。他基本上整天静静地坐在房间里看书，尽管他拥有 260 家不同的公司，是世界上最富有的 10 个人之一，但他的生活极其平静。

---

### (00:32:44) Andrew Wilkinson

**English:**
He only does what he wants and he spends most of his time quietly reading and once or twice a year, he makes a big decision to buy a business. And so when I read about Warren Buffett, I just thought, wow, I'm a sucker. I'm running around like a crazy person trying to run all these businesses. Why am I not just buying businesses and letting them run? And so when I'm buying a business, what I'm really looking for is something that I can't mess up. Right now, obviously we buy a business, we try not to mess it up, and we're very intentional, actually very odd in that when Tiny buys a company, we generally just leave them alone. If they already have management in place, we say nothing changes, no one should know that we've even bought them. Obviously people know that, but really there should be no change whatsoever.

**中文翻译:**
他只做自己想做的事，大部分时间都在静静地阅读，每年只做一两次收购业务的重大决定。当我读到巴菲特时，我想：“哇，我真是个傻瓜。我像个疯子一样到处跑，试图经营所有这些公司。为什么我不直接买下公司并让它们自己运行呢？” 所以当我收购一家公司时，我真正寻找的是那种“我搞不砸”的公司。当然，我们买下公司后会努力不搞砸它，而且我们非常有针对性。Tiny 收购公司时其实很奇怪，我们通常不去干预。如果他们已经有了管理团队，我们会说一切照旧，甚至没人应该知道我们买下了它。显然人们会知道，但实际上不应该有任何改变。

---

### (00:33:31) Andrew Wilkinson

**English:**
The only change that we generally make is if the founder wants to leave the business, then we'll bring in a CEO to run the company, and that's probably the most important decision that we make. So I'm looking for a business though where it is so good that it's hard to mess up, and most businesses are very easy to mess up. One person leaves and the whole business falls apart because it's held together with dental floss and duct tape. And so I'm really looking for what Warren Buffett would call a moat. So a moat is basically a brand, so that could be a brand like Coca-Cola, Tylenol, Advil, something like that. So something that gives you pricing power where you can consistently charge and you have loyal customers or where we usually find a lot of opportunity is in network effects.

**中文翻译:**
我们通常做出的唯一改变是：如果创始人想离开，我们会聘请一位 CEO 来经营公司，这可能是我们做出的最重要的决定。我寻找的是那种好到很难搞砸的业务，而大多数业务都很容易搞砸。一个人离职，整个公司就垮了，因为它是靠牙线和胶带勉强维持的。所以我寻找的是巴菲特所说的“护城河”。护城河基本上就是品牌，比如可口可乐、泰诺（Tylenol）、安舒疼（Advil）之类的。它能赋予你定价权，让你能持续收费并拥有忠实客户。或者，我们通常在“网络效应”中发现很多机会。

---

### (00:34:23) Andrew Wilkinson

**English:**
So typically we're looking for a community that's gotten so big where people don't want to go elsewhere. So for example, we own Letterboxd, which is the largest social network for film lovers. And the question is, if someone else wants to compete with us, why would someone go to their social network that has a small number of users when all their friends are already on Letterboxd? And so you see that same kind of thing with Instagram or Facebook or similar. And so we're looking for businesses like that, something that has staying power that is hard to compete with and that we can hold over the very long term.

**中文翻译:**
通常我们寻找的是一个已经变得如此庞大、以至于人们不想离开的社区。例如，我们拥有 Letterboxd，它是最大的电影爱好者社交网络。问题是，如果别人想和我们竞争，当用户所有的朋友都在 Letterboxd 上时，他们为什么要跑去一个用户寥寥的新社交网络？你在 Instagram 或 Facebook 身上也能看到同样的情况。所以我们寻找的就是这样的业务：具有持久力、难以竞争，并且我们可以长期持有。

---

### (00:35:01) Lenny Rachitsky

**English:**
It was interesting when Elon bought X, how that was such a test of the power of network effects. If you think about it, back then he changed the name. So the brand completely changed the team. 80% of the people left. What was left, it was the network and the network effect and the simplest way. Just for folks that aren't super familiar with network effects, the way I think about it is just network effect is where every additional user that joins the network becomes more useful for everybody.

**中文翻译:**
当埃隆（马斯克）收购 X 时，那是对网络效应力量的一次巨大考验。想想看，他改了名字，品牌完全变了，团队 80% 的人都离开了。剩下的只有网络和网络效应。对于那些不太熟悉网络效应的人，我的理解是：网络效应就是每增加一个加入网络的用户，都会让这个网络对所有人变得更有用。

---

### (00:35:27) Andrew Wilkinson

**English:**
There's another moat, which is high switching costs, which I don't really like because it's not really very consumer friendly, but an example might be Salesforce where no one wants to, they've spent years and they've done all the implementation and trained everyone on it, and it's kind of the standard, everybody hates it, but ripping it out and switching is such a pain in the that they just won't bother. That's another form of sometimes a great business, but again, that's more depressing. I don't love that one.

**中文翻译:**
还有一种护城河是“高昂的切换成本”，我不太喜欢这种，因为它对消费者不太友好。比如 Salesforce，没人想换掉它，因为他们已经花了多年时间进行实施和全员培训，它已经成了标准。虽然大家都讨厌它，但把它拔掉换成别的太痛苦了，所以大家干脆就不折腾了。这有时也是一种伟大的业务形式，但比较让人压抑，我不喜欢这种。

---

### (00:35:56) Lenny Rachitsky

**English:**
What's the last company you guys bought?

**中文翻译:**
你们最近收购的一家公司是什么？

---

### (00:35:58) Andrew Wilkinson

**English:**
We bought Serato. Serato is the largest DJ software company in the world. So if you ever see a DJ playing and they've got a laptop in front of them, probably using Serato to DJ.

**中文翻译:**
我们收购了 Serato。Serato 是全球最大的 DJ 软件公司。如果你看到 DJ 在表演，面前放着一台笔记本电脑，他们很可能就在用 Serato。

---

### (00:36:09) Lenny Rachitsky

**English:**
Wow, that is super cool. What I'd like a funding to be walking into.

**中文翻译:**
哇，那太酷了。我也想走进这样的投资项目。

---

### (00:36:14) Andrew Wilkinson

**English:**
I used to DJ so I was aware of them and it was one of those moments we talked about earlier where I understood the business. They had a really interesting mode of this huge passionate user base and deep hardware integration. And I also love DJing and I was able to analyze the business and luck comes to the prepared mind and it worked out.

**中文翻译:**
我以前当过 DJ，所以我知道他们。这就是我们之前讨论过的“我了解这门生意”的时刻。他们有一种非常有趣的模式：庞大且充满热情的用户群，以及深度的硬件集成。我也热爱 DJ，我能够分析这门生意。机会总是留给有准备的人，结果很成功。

---

### (00:36:35) Lenny Rachitsky

**English:**
This is another great callback to your excellent piece of advice of just ideally what you're working on, whether you're starting the company or buying the company, is you have a unique unfair advantage or some kind of unique background that connects to that idea. Let me ask you one more question before we shift a whole different topic, hint, hint, AI. Something that I know you talk a lot about, something you believe strongly and something you deal with a lot is when you buy companies is just as people and the challenges of management and hiring and people. So what have you learned about just how to successfully, I don't know, find amazing people, keep amazing people, help people be more successful within the companies that you operate?

**中文翻译:**
这又是对你那条绝佳建议的呼应：理想情况下，无论你是创业还是收购，你所做的事情都应该与你独特的不公平优势或某种独特的背景相连。在转向另一个完全不同的主题（提示：AI）之前，我再问你一个问题。我知道你经常谈论、坚信并经常处理的事情——尤其是在收购公司时——就是“人”的问题，以及管理、招聘和人才的挑战。关于如何成功地找到优秀的人、留住优秀的人，并帮助他们在你经营的公司中取得更大的成功，你学到了什么？

---

### (00:37:15) Andrew Wilkinson

**English:**
My business partner, Chris, has a really great quote. He says, "There are no problems. There is only people problems." And so we've found that you could tell us that there's a disaster that one of our business units is about to fail or something like that. As long as I'm surrounded by really great smart people, I feel fine. But when we have a bad actor, we have a psycho or a narcissist or a really horrible, difficult person we're dealing with, all bets are off and life becomes incredibly stressful. So I'd say I spend probably 20% of my time just trying to make sure we're filtering people very carefully and ensuring we're working with people that we enjoy. And I could talk about it in the AI, I've done some really interesting stuff to help me screen and identify difficult people, but I've just found that the biggest mistake I made in my early career was I would hire people because I liked them on gut and I would think that I could change them.

**中文翻译:**
我的商业伙伴 Chris 有一句名言：“没有问题，只有人的问题。” 我们发现，即使你告诉我们某个业务部门即将倒闭或发生了灾难，只要我身边有一群非常优秀、聪明的人，我就觉得没问题。但当我们遇到一个“坏分子”，比如一个疯子、自恋狂或一个极其糟糕、难以相处的人时，一切都乱套了，生活会变得压力巨大。所以我大约 20% 的时间都花在确保我们非常仔细地筛选人才，并确保与我们喜欢的人共事。稍后谈到 AI 时，我可以聊聊我做的一些有趣尝试，利用 AI 帮我筛选和识别难相处的人。但我发现，我职业生涯早期犯的最大错误就是凭直觉雇佣我喜欢的人，并以为我可以改变他们。

---

### (00:38:12) Andrew Wilkinson

**English:**
So it's kind of like in romantic relationships, it never works out well. If you get married to someone and you go, "Okay, well this is going to be a great relationship as long as I can convert them to Christianity or I can change their parents or their personality," or whatever it is. And so I've just found that I've never been able to change someone. You can never mentor someone out into being a good employee. And the kind of heuristic I have is if I ever think, should I fire this person even once, I should fire them immediately. It has always been a signal, at least for me, that when someone's a superstar, I can't imagine firing them. I think it's impossible, I'd be lost without them.

**中文翻译:**
这有点像恋爱关系，结果通常都不好。如果你和某人结婚时想：“只要我能让他信教，或者改变他的父母，或者改变他的性格，这段关系就会很棒，”那是不可能的。我发现我从未能改变过任何人。你无法通过指导（Mentor）把一个不合适的人变成好员工。我的一个启发式原则是：如果我哪怕产生过一次“我是不是该开除这个人”的念头，我就应该立刻开除他。对我来说，这始终是一个信号。当某人是超级巨星时，我根本无法想象开除他，我觉得没了他我会不知所措。

---

### (00:38:56) Andrew Wilkinson

**English:**
But when I repeatedly start going, "Man, is this person going to work out?" Almost always within six to 12 months, it doesn't work out. And so I really try and be really direct about stuff like that and just cut when it's not working. So I'd say the lesson really is hire for what you need. Don't hire just for potential, which is counter to what a lot of people say. A lot of people say hire for potential and coach them into being whatever you need. I just haven't found that. I think you need to hire someone who already is fully formed and can do what you need. But again, everyone does it differently.

**中文翻译:**
但当我反复开始想“这家伙到底行不行”时，几乎总是在 6 到 12 个月内，结果就是不行。所以我现在努力在这些事情上保持直接，不行就立刻止损。所以教训是：为你当下的需求而招聘。不要只为了“潜力”而招聘，这与很多人的说法相反。很多人说要看潜力，然后把他们培养成你需要的人。我没发现这行得通。我认为你需要雇佣一个已经完全成型、能够胜任你需求的人。不过，每个人做事的方式不同。

---

### (00:39:31) Lenny Rachitsky

**English:**
This is big advice. Powerful advice. Is this true not just for the CEOs of the companies you run? As for folks under lower down the ladder too?

**中文翻译:**
这是非常重要的建议，很有力量。这不仅适用于你经营的公司的 CEO，也适用于职位更低的员工吗？

---

### (00:39:39) Andrew Wilkinson

**English:**
Well, for CEOs, one of the most interesting things we've observed is, so I'll give you an example. We had a CEO come in and we were interviewing them and in my opinion, the business needed to grow via organic marketing. In his opinion, it was enterprise sales. And so when we're interviewing him, he keeps going back to his experience building with enterprise sales. And there's this great saying, "To a man with a hammer, everything looks like a nail." And so for him, he's looking at this business and going enterprise sales, that's the way to grow. I hire him, but I say, "Look, if we're going to hire you, we need you to do the organic marketing." Lo and behold, of course, he goes off and he does the enterprise sales thing. And I've just found that hiring CEOs is like they're an elephant and you're the rider.

**中文翻译:**
对于 CEO，我们观察到的最有趣的事情之一是——我给你举个例子。我们面试过一位 CEO，在我看来，那项业务需要通过自然营销（Organic Marketing）来增长。而在他看来，应该是大客户销售（Enterprise Sales）。面试时，他不断回到他构建大客户销售的经验上。有一句名言：“对于手里拿着锤子的人来说，看什么都像钉子。” 对他来说，他看着这项业务，觉得大客户销售才是增长之道。我雇了他，但我说：“听着，如果我们雇你，我们需要你做自然营销。” 结果不出所料，他上任后还是去搞大客户销售了。我发现雇佣 CEO 就像他们是象，而你是骑象人。

---

### (00:40:31) Andrew Wilkinson

**English:**
They're going to go wherever it is that they want to go. And so listening incredibly carefully to people's words and their experiences, because generally people will do the thing they tell you. So what I look for when I interview a CEO now, I want to be nodding along. I want to go, that's exactly what I would do or that's way smarter than my idea. And then I just leave them alone because I've found that anytime I try and pull them in a certain direction or coach them or whatever, it just doesn't work. And again, this could be my problem. I might be the world's worst coach and mentor, but for me, that's been what's true.

**中文翻译:**
他们会去他们想去的地方。所以要极其仔细地倾听人们的话语和经验，因为通常人们会去做他们告诉你的那些事。所以我现在面试 CEO 时，我寻找的是那种能让我一直点头的人。我想听到的是：“那正是我会做的”，或者“那比我的主意聪明多了”。然后我就放手让他们去做，因为我发现任何时候我想把他们拉向某个方向或指导他们，都行不通。当然，这可能是我的问题，我可能是世界上最差的教练和导师，但对我来说，这就是事实。

---

### (00:41:06) Lenny Rachitsky

**English:**
I imagine there's also an element of they won't love the job if they want to be doing say enterprise sales, and then they're creating viral TikTok videos all day and tweeting. They're like, "What the hell?"

**中文翻译:**
我想还有一个因素是，如果他们想做大客户销售，却整天在拍 TikTok 病毒视频和发推特，他们也不会喜欢这份工作。他们会想：“这搞什么鬼？”

---

### (00:41:15) Andrew Wilkinson

**English:**
Well, I've also found people will shoot themselves in the foot. If I tell them an idea in a board meeting and I say, "I really need you to try this," it never works because usually they sandbag it, right? They don't really put their heart into it or they're just placating me and they don't want it to work. They want their idea to work. And so I've learned not to do that.

**中文翻译:**
我还发现人们会搬起石头砸自己的脚。如果我在董事会上告诉他们一个主意，说“我真的需要你尝试一下这个”，它永远不会成功。因为通常他们会消极怠工，对吧？他们不会真心投入，或者只是在敷衍我，他们并不希望它成功。他们希望自己的主意成功。所以我学会了不再那样做。

---

### (00:41:37) Lenny Rachitsky (Ad Break)

**English:**
This episode is brought to you by Miro. Every day new headlines are scaring us about all the ways that AI is coming for our jobs, creating a lot of anxiety and fear. But a recent survey for Miro tells a different story. 76% of people believe that AI can benefit their role, but over 50% of people struggle to know when to use it. Enter Miro's innovation Workspace, an intelligent platform that brings people and AI together in a shared space to get great work done. Miro has been empowering teams to transform bold ideas into the next big thing for over a decade. Today, they're at the forefront of bringing products to market even faster by unleashing the combined power of AI and human potential. Teams can work with Miro AI to turn unstructured data like sticky notes or screenshots into usable diagrams, product briefs, data tables, and prototypes in minutes.

**中文翻译:**
本期节目由 Miro 赞助。每天都有新的头条新闻在恐吓我们 AI 将如何取代我们的工作，引发了大量的焦虑和恐惧。但 Miro 最近的一项调查显示了不同的情况：76% 的人相信 AI 能使他们的角色受益，但超过 50% 的人不知道何时使用它。欢迎使用 Miro 的创新工作空间（Innovation Workspace），这是一个将人与 AI 聚集在共享空间中以完成出色工作的智能平台。十多年来，Miro 一直在赋能团队将大胆的想法转化为下一个大事件。今天，他们通过释放 AI 与人类潜力的结合力量，走在让产品更快上市的前沿。团队可以利用 Miro AI 在几分钟内将便签或截图等非结构化数据转化为可用的图表、产品简报、数据表和原型。

---

### (00:42:26) Lenny Rachitsky

**English:**
You don't have to be an AI master or to toggle yet another tool. The work you're already doing in Miro's canvas is the prompt. Help your teams get great work done with Miro. Check it out at Miro.com to find out how. That's M-I-R-O.com.

**中文翻译:**
你不需要成为 AI 大师，也不需要切换到另一个工具。你在 Miro 画布上已经在做的工作就是提示词。使用 Miro 帮助你的团队完成出色工作。请访问 Miro.com 了解详情。

---

### (00:42:41) Lenny Rachitsky

**English:**
Let's talk about AI. It's so funny to watch you on Twitter. Clearly you've become AI obsessed, AIphile. I don't know what the term is, and I love that you're not just the kind of person that just talks about it and tweets pontifications, you're clearly using it in every facet of your job and looking for more ways to use AI. So I have a lot of questions here because I think this is where more and more founders are going to be where you are today. First of all, just what's in your AI stack these days? What are the tools you find yourself coming back to most or finding most useful?

**中文翻译:**
让我们谈谈 AI。在 Twitter 上关注你很有趣。显然你已经对 AI 着迷了，成了“AI 狂热者”。我不知道该用什么词，但我很喜欢你不是那种只会在推特上夸夸其谈的人，你显然在工作的方方面面都在使用它，并寻找更多使用 AI 的方法。我有很多问题，因为我认为越来越多的创始人会达到你今天的状态。首先，你现在的 AI 工具栈（AI Stack）里都有什么？哪些工具是你最常使用或觉得最有用的？

---

### (00:43:10) Andrew Wilkinson

**English:**
So the primary tool I use is a tool called Lindy, Lindy.ai. And what it basically lets you do is build workflows and agents. So it's very simple. You might say, "When I get an email in the Gmail API, I want to add an AI agent that reads the email and labels it based on that." Or you can build a crazy Rube Goldberg machine that sends different emails all sorts of different places. So for example, when I get an email and it's related to my kid's school, one of the big problems I have is that my kid's school sends so many emails, the field trip is on Thursday and you need to bring the following things. And meanwhile, there's parent teacher interviews and all these things get added to my calendar. The AI agent automatically takes that, puts it onto my calendar, makes sure there's notes for all the things I need to prepare and stuff. So I have just basically tried to take every single thing a human could do in my inbox and automate it with Lindy.

**中文翻译:**
我使用的主要工具是一个叫 Lindy 的工具（Lindy.ai）。它基本上可以让你构建工作流和智能体（Agents）。非常简单，你可以说：“当我在 Gmail API 中收到邮件时，我想要一个 AI 智能体读取邮件并据此打标签。” 或者你可以构建一个复杂的“鲁布·戈德堡机械”（Rube Goldberg machine，指极其复杂的自动化流程），将不同的邮件发送到各种地方。例如，当我收到与孩子学校相关的邮件时——我的一大烦恼是学校发太多邮件了，比如周四有实地考察，你需要带这些东西；同时还有家长教师见面会。AI 智能体会自动提取这些信息，放入我的日历，并确保备注里写清了我需要准备的所有事项。我基本上尝试将人类在收件箱里能做的每一件事都用 Lindy 自动化了。

---

### (00:44:10) Andrew Wilkinson

**English:**
No, I do it myself.

**中文翻译:**
不，我自己弄。

---

### (00:44:22) Andrew Wilkinson

**English:**
Oh man, I think I probably have not a crazy amount within... Let's see. Well, each workflow probably has four or five agents. So for example, my inbox has four or five agents, and then I have a whole bunch of other, I've got a calendar agent, I've got a meeting agent, I've got an email agent, I've got a scheduler, I've got a CRM, and basically they're all different workflows. So the whole bunch of agents within.

**中文翻译:**
噢，天哪，我想数量不算太夸张……让我想想。每个工作流大概有四五个智能体。例如，我的收件箱有四五个智能体，然后我还有一堆其他的：日历智能体、会议智能体、邮件智能体、调度器、CRM，基本上它们都是不同的工作流。所以里面有一大堆智能体。

---

### (00:44:50) Lenny Rachitsky

**English:**
Okay, and you're not an investor in Lindy, right? You're just a fan, super user.

**中文翻译:**
好的，你不是 Lindy 的投资者吧？你只是个粉丝和超级用户。

---

### (00:44:53) Andrew Wilkinson

**English:**
No, no.

**中文翻译:**
不，不是。

---

### (00:44:54) Lenny Rachitsky

**English:**
Fun fact. I actually am. So this is great.

**中文翻译:**
有趣的是，我其实是。所以这太棒了。

---

### (00:44:56) Andrew Wilkinson

**English:**
Oh, no way. That's awesome.

**中文翻译:**
噢，真的吗？那太赞了。

---

### (00:44:57) Lenny Rachitsky

**English:**
Tiny angel investor. So just want to put that out there, which I love that this came up organically. What are a couple other really interesting use cases, workflows you've built that people might be inspired by it?

**中文翻译:**
我是个小小的天使投资人。只是想说明一下，我很喜欢这个话题是自然而然聊出来的。还有哪些非常有趣的使用案例或工作流是你构建的，可以让大家参考一下？

---

### (00:45:08) Andrew Wilkinson

**English:**
Let me go through the email one a little more. So basically emails come in and the first agent says, does Andrew even need to see this? Let's say you're in a thread and you've already chimed in and everyone's just saying, cool, that works. I don't need to see that. So just archives that never. So that immediately reduces my email by about 20%. Then it decides is this something that is time sensitive? Is this something that needs to be dealt with in the next 24 hours? And if so, it labels it in a special 24-hour label. So when I go in my email, one of the biggest stresses I find is I go, "Shit, there's 200 emails in here, and if I don't go through all of them, I don't know if there's an emergency burning somewhere." So now I do. Then it takes any email or every single email and it decides, is this a simple decision?

**中文翻译:**
让我再详细说说邮件那个。基本上邮件进来后，第一个智能体会判断：Andrew 真的需要看这个吗？假设你在一个邮件组里，你已经发言过了，大家只是在回“酷”、“收到”。我不需要看这些，所以它会直接归档。这立刻减少了我 20% 的邮件量。然后它会判断：这是有时效性的吗？是否需要在未来 24 小时内处理？如果是，它会打上一个特殊的“24 小时”标签。这样当我打开邮箱时，我最大的压力来源——“该死，这里有 200 封邮件，如果不全看完，我不知道哪里是不是着火了”——就消失了。现在我知道了。接着，它会处理每一封邮件并判断：这是一个简单的决定吗？

---

### (00:46:00) Andrew Wilkinson

**English:**
So for example, let's say you email me and you say, "Hey, do you want to get lunch?" So it emails me privately and it says, "Hey, Lenny wants to get lunch. Do you want to say yes? Do you want to say yes, but in a few months? Do you want to say no? How do you want to say no?" And it gives me multiple choice. I just can say four, number four, and then it'll email you as me and it'll write out a nice thoughtful email or whatever. So stuff like that is so freaking cool and helpful. And I'd say that it's replaced stuff that my full-time, I used to have a full-time assistant just working on email that's all completely automated and there's all sorts of other cool stuff I'm doing there. Other agents, I'm working on one right now to manage my calendar, which is really complex. I do a lot of scheduling and a lot of rules. I have another really simple one. It adds emojis to every single calendar event. So when I look at my calendar, I've got beautiful little emojis for every single calendar event. Very silly.

**中文翻译:**
例如，假设你给我发邮件说：“嘿，想一起吃午饭吗？” 智能体会私下发消息给我说：“嘿，Lenny 想约午饭。你想答应吗？还是想答应但推迟几个月？还是想拒绝？想怎么拒绝？” 它会给我多项选择。我只需要回复“4”，它就会以我的名义给你回信，写一封得体、周到的邮件。这类事情简直太酷、太有用了。我想说，它已经取代了我以前全职助理的工作——我以前有个全职助理专门处理邮件，现在全自动化了。我还在做其他很酷的事。比如我正在做一个管理日历的智能体，我的日历非常复杂，有很多调度和规则。还有一个非常简单的：它会给每个日历事件添加 Emoji。所以当我查看日历时，每个事件都有漂亮的小图标。虽然很幼稚，但很有趣。

---

### (00:47:00) Andrew Wilkinson

**English:**
Yeah, so if I write weightlifting, it'll just do a guy weightlifting or whatever. I've got one that, this one's cool. Basically what it does, every time I email someone, it looks them up online, it figures out what city they live in. It checks my CRM and air table. It says, "Okay, I don't know where do you live."

**中文翻译:**
是的，如果我写“举重”，它就会放一个举重的小人。我还有一个很酷的：基本上，每当我给某人发邮件时，它会在网上搜索他们，查出他们住在哪个城市。它会检查我的 CRM 和 Airtable。它会说：“好吧，我不知道你住哪。”

---

### (00:47:21) Lenny Rachitsky

**English:**
In Marin, in the Bay Area.

**中文翻译:**
在湾区的马林县（Marin）。

---

### (00:47:22) Andrew Wilkinson

**English:**
Okay. So it'd say, "Okay, you email Lenny, he lives in Marin." It puts in the database you live in Marin. And then next time I travel to the Bay Area, the agent will see two weeks before and it'll say, "I saw you're going to San Francisco. Here's all the people in San Francisco you should try and have coffee with." Right? So just all these things that-

**中文翻译:**
好的。它会记录：“你给 Lenny 发了邮件，他住在马林县。” 然后把这个信息存入数据库。下次我要去湾区出差时，智能体会提前两周发现，并提醒我：“我看到你要去旧金山。这里有所有在旧金山、你应该尝试约咖啡的人。” 对吧？所以所有这些事情——

---

### (00:47:22) Lenny Rachitsky

**English:**
I would pay for that.

**中文翻译:**
我愿意为此付钱。

---

### (00:47:43) Andrew Wilkinson

**English:**
Yeah, yeah, exactly. All these things that I've dreamed of having my assistant do that my assistant could just never consistently do because she gets distracted, we're doing an event, there's something going on. It's like having the world's most reliable employee who costs $200 a month and works 24/7.

**中文翻译:**
没错。所有这些我曾梦想让助理做的事，助理却永远无法持续稳定地完成，因为她会分心，或者我们要办活动，或者有别的事。这就像拥有世界上最可靠的员工，每月只需 200 美元，而且 24/7 全天候工作。

---

### (00:48:02) Lenny Rachitsky

**English:**
Okay, I want to follow that thread, but first of all, what other tools do you have? Lindy's one, what else do you find really useful?

**中文翻译:**
好的，我想继续聊这个话题，但首先，你还有其他工具吗？Lindy 是一个，还有什么你觉得非常有用的？

---

### (00:48:08) Andrew Wilkinson

**English:**
So the other one is Replit. So Replit is basically a vibe coding platform. You can literally go into it and say, "I want to make a website for my sound software business. Here's a big document with a bunch of details," and it'll go and design a pretty impressive website. But then you can also build web apps now. So you can literally be like, "Yeah, build a Python web app that does XYZ," and the design is getting so good because it uses Claude 4. You can start saying, "Do it in the style of Stripe. Think this through, rewrite all the copy and the tone of David Ogilvy or Malcolm Gladwell," or whoever you like, and it does a really incredible job. So what I'm finding is that things that previously would've frustrated me because I would've had to rely on a team of five, I can just do entirely on my own when it comes to web projects and stuff like that. So I'm having a blast with that.

**中文翻译:**
另一个是 Replit。Replit 基本上是一个“氛围编程”（Vibe Coding）平台。你可以直接进去说：“我想为我的音频软件业务做一个网站。这是一份包含细节的大文档，”它就会去设计一个相当惊艳的网站。而且你现在还可以构建 Web 应用。你可以直接说：“用 Python 写一个能做 XYZ 的 Web 应用，”而且设计感越来越好，因为它使用了 Claude 3.5/4。你可以开始要求：“按照 Stripe 的风格来做。仔细思考一下，用大卫·奥格威或马尔科姆·格拉德威尔的语气重写所有文案，”它做得非常出色。我发现，以前那些让我沮丧、必须依赖五人团队才能完成的 Web 项目，现在我完全可以一个人搞定。我玩得很开心。

---

### (00:49:07) Lenny Rachitsky

**English:**
That's cool. So your team Replit versus Lovable, Bolt, v0, is that roughly right?

**中文翻译:**
太酷了。所以你是 Replit 阵营的，而不是 Lovable、Bolt 或 v0，大概是这样吗？

---

### (00:49:12) Andrew Wilkinson

**English:**
I mean, they're all great. I, just am the most familiar with Replit, and it seems like it has the most functionality. It has a lot of beef to it, whereas Lovable and Bolt seem a little more basic. You might have to deal with deployment and stuff in a fiddlier way with them.

**中文翻译:**
它们都很棒。我只是对 Replit 最熟悉，而且它似乎功能最全。它很有“料”，而 Lovable 和 Bolt 看起来稍微基础一些。用它们可能在部署等方面会更麻烦一点。

---

### (00:49:29) Lenny Rachitsky

**English:**
Awesome. Okay. Anything else?

**中文翻译:**
太棒了。好的，还有别的吗？

---

### (00:49:32) Andrew Wilkinson

**English:**
Another one I love, so Limitless. I don't know if you've seen this.

**中文翻译:**
另一个我喜欢的是 Limitless。不知道你见过没。

---

### (00:49:32) Lenny Rachitsky

**English:**
I've got one of those.

**中文翻译:**
我也有一个。

---

### (00:49:37) Andrew Wilkinson

**English:**
It's really cool. So clips to your shirt. I actually just put it on my pocket so no one actually notices that I've got it on usually, and I just have it on all day. And what it does is it just records everything I do. And then I can say, the other day I had a coffee with someone and I'm the kind of person where I go a mile a minute and I say, "Oh, I'll send you that and I'll do this," or whatever. And so at the end of the day, I can just say, "Hey, what did I promise to people today?" Or even better, everyone loves this use case, I have a fight with my girlfriend. And she says, "You didn't say that." And I'm able to say, "Well, actually you did." And you can query it as an LLM.

**中文翻译:**
它真的很酷。夹在衬衫上。我通常把它放在口袋里，所以没人注意到我戴着它，我整天都戴着。它会记录我做的每一件事。然后我可以问——比如前几天我和某人喝咖啡，我是那种说话飞快的人，我会说“噢，我会把那个发给你”、“我会做那个”之类的。到了一天结束时，我可以问：“嘿，我今天答应了别人什么？” 或者更棒的——大家都喜欢这个用例——我和女朋友吵架了。她说：“你没说过那话。” 我就能说：“其实你说了。” 你可以把它当作一个大语言模型（LLM）来查询。

---

### (00:50:16) Andrew Wilkinson

**English:**
So you can say you're a couples counselor. Look at this fight. What did each person need? How did it start? What are the key lines? Where did it change? How could you do this better? And so honestly, from a relationship standpoint is probably where it's been the most useful. What's cool too is that has an API. And so eventually, I haven't gotten there yet, but eventually you'll be able to just have it record your entire day and then automatically go into your Todoist or whatever it is, and add to-do's or send emails or whatever you need it to do.

**中文翻译:**
你可以对它说：“你现在是一名情感咨询师。看看这段争吵。每个人当时的需求是什么？是怎么开始的？关键台词是什么？转折点在哪？你本可以怎么做得更好？” 说实话，从人际关系的角度来看，这可能是它最有用武之地的地方。更酷的是它有 API。最终——我还没做到那一步——你将能够让它记录你的一整天，然后自动进入你的 Todoist 或其他工具，添加待办事项、发送邮件，或者做任何你需要它做的事。

---

### (00:50:48) Lenny Rachitsky

**English:**
Wow, this is so fun. Or just per your point with the relationship, ask it, "What could I have done better today? Where did the day go downhill?"

**中文翻译:**
哇，这太有趣了。或者就你提到的关系问题，问它：“我今天本可以做得更好吗？今天是从什么时候开始变糟的？”

---

### (00:50:57) Andrew Wilkinson

**English:**
Yeah, I saw a guy on Twitter. He said, "Every day I ask it, 'How could I have been a better dad?'" And it'll be like, "Oh, your daughter tried to get your attention about this. You should have paid attention," or whatever.

**中文翻译:**
是的，我在 Twitter 上看到一个人说：“我每天都问它，‘我怎样才能成为一个更好的父亲？’” 它会回答：“噢，你女儿曾试图就这件事引起你的注意，你当时应该多留心的，”之类的。

---

### (00:51:07) Lenny Rachitsky

**English:**
And that was with the Limitless data. Oh, man, I love that. With the relationship, you didn't go where I thought you were going to go, where it's like, "Oh, but who actually said it? What did you actually say?" I love that It became much more wholesome of just like how could we have communicated better holistically? Okay. My wife actually is like, "Don't wear this around."

**中文翻译:**
那是基于 Limitless 的数据。天哪，我太喜欢这个了。关于关系，你没往我想象的方向走——比如“噢，到底是谁说的？你到底说了什么？” 我很喜欢它变得更健康了，比如“我们整体上如何能沟通得更好”。好的。我妻子其实跟我说：“别整天戴着这玩意儿。”

---

### (00:51:25) Andrew Wilkinson

**English:**
You just got to wear it really covertly. Honestly, I know it sounds kind of cheesy because you think like, "Oh, it'll tell her," right? But in reality, usually you're both guilty in the fight. And my girlfriend has actually appreciated it because there's been half the time it'll be like, "Oh yeah, Zoe said this and it triggered this," but a lot of the time it's me too. And I think I'm totally right. So I find it actually really helpful. Other tools, I mean otherwise, it's the basic stack of Claude and ChatGPT and Gemini. And Gemini I use mostly for things that are really large. So for example, all my medical records, I have trained on Gemini 2.5 just because the other ones can't really go through it all. Claude, I use for writing very extensively. I find it's the best for that.

**中文翻译:**
你只需要戴得隐蔽一点。老实说，我知道这听起来有点俗气，因为你会想“噢，它会告发她”，对吧？但现实中，争吵通常双方都有错。我女朋友其实挺感激它的，因为有一半时间它会显示：“噢是的，Zoe 说了这个，触发了那个，”但很多时候也是我的问题，而我当时还觉得自己完全正确。所以我发现它其实非常有帮助。其他工具的话，基本上就是 Claude、ChatGPT 和 Gemini。Gemini 我主要用于处理超大型任务。例如，我所有的医疗记录都放在 Gemini 1.5/2.0 上训练，因为其他的模型处理不了这么大的量。Claude 我广泛用于写作，我觉得它是写作最强的。

---

### (00:52:14) Andrew Wilkinson

**English:**
And then ChatGPT for everything else. In terms of cool things I do, recently, I went through my entire medicine cabinet and I just took big photos that showed all the different medicines and stuff. And now I can say something like, "Hey, I'm really tired and stressed out today. What supplement should I take and what dose?" Or I'll say, "Remember all the medications I'm taking, whenever I ask you a health question, always remind me in the context of I might be taking that medication." So a few times it's said, "Hey, you shouldn't take this other medication because your genetics say you're not compatible with it and you're already taking this other one." So stuff like that's been really helpful.

**中文翻译:**
剩下的事都用 ChatGPT。说到我做的酷事，最近我清理了整个药柜，拍了大照片，展示了所有的药品。现在我可以问：“嘿，我今天很累压力很大。我该吃什么补剂，剂量是多少？” 或者我会说：“记住我正在服用的所有药物，每当我问你健康问题时，请务必结合我可能正在服用的药物来提醒我。” 有几次它说：“嘿，你不应该服用另一种药，因为你的基因显示你不适合它，而且你已经在服用这一种了。” 这类事情非常有帮助。

---

### (00:52:57) Lenny Rachitsky

**English:**
For that use case, do you come back to a specific conversation where you've given it that context, use a project or something-

**中文翻译:**
对于那个用例，你是回到一个特定的对话（你已经给了它背景），还是使用“项目”（Project）功能之类的？

---

### (00:53:02) Andrew Wilkinson

**English:**
No, I say remember. I just say remember these supplements, this is what I have in my medicine cabinet or this is what I take every day.

**中文翻译:**
不，我用“记住”（Remember）功能。我直接说“记住这些补剂，这是我药柜里的东西”或者“这是我每天吃的药”。

---

### (00:53:10) Lenny Rachitsky

**English:**
I see. So just tap into the memory of ChatGPT.

**中文翻译:**
明白了。就是利用 ChatGPT 的记忆功能。

---

### (00:53:12) Andrew Wilkinson

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:53:13) Lenny Rachitsky

**English:**
This is awesome. This makes me remember that. And this connects to other points you've been making, I've started to use ChatGPT deep research to prep for these conversations. I used to have a researcher who did this for 400 bucks. They did research on every guest that I had, four to 500 bucks, and gave me a whole doc, "Here's everything about them. Here's their background, here's questions you might want to ask." Deep research is better. Just as of recently, especially with o3-pro.

**中文翻译:**
太棒了。这让我想起了一件事，也和你之前提到的观点相连：我开始使用 ChatGPT 的“深度研究”（Deep Research）功能来准备这些对话。我以前有个研究员，做一次研究收 400 美元。他们会研究我的每一位嘉宾，收四五百美元，然后给我一份完整的文档：“这是关于他们的一切，这是他们的背景，这是你可能想问的问题。” 现在深度研究做得更好，尤其是最近的 o3-pro 模型。

---

### (00:53:39) Andrew Wilkinson

**English:**
We were talking earlier about agents. I forgot one of my favorite agents. So it looks on my calendar 30 minutes before I meet anyone. It goes on to Perplexity and it does a deep dive on the person and it sends me, it goes into my email and it gets the context of the meeting. So often I book meetings three months out. So I usually look at my calendar and I go, "Who is this person? I don't even remember booking this meeting." It'll text me before and it'll say, "Here's who you are, here's your background, here's the email context of why we're meeting." And it basically does all the research for me. So I do the same thing. I also use deep research and say, "If I'm meeting them, you know everything about me. What are our commonalities and what are all the fun things we should talk about?"

**中文翻译:**
我们刚才聊到智能体，我忘了一个我最喜欢的。它会在我见任何人前 30 分钟查看我的日历，然后去 Perplexity 对那个人进行深度搜索，并把结果发给我。它还会进入我的邮件，获取会议的背景。我经常提前三个月约会议，所以我看日历时常想：“这人是谁？我都不记得约过这会。” 智能体会提前发短信给我：“这是对方是谁，这是背景，这是你们为什么要见面的邮件上下文。” 它基本上帮我做了所有的研究。我也用深度研究功能说：“我要见他们，你了解关于我的一切。我们的共同点是什么？有哪些有趣的话题可以聊？”

---

### (00:54:22) Lenny Rachitsky

**English:**
Oh my God, I just want to plug and play all these agents you've built to use them myself. Interestingly, I tried to create an agent to do this research kickoff for me, but I don't think you can automate ChatGPT deep research. Okay.

**中文翻译:**
天哪，我真想直接把你建的这些智能体“即插即用”到我这儿。有趣的是，我也试过建一个智能体帮我做研究启动，但我发现好像没法自动化 ChatGPT 的深度研究功能。

---

### (00:54:35) Andrew Wilkinson

**English:**
Only Perplexity. Yeah.

**中文翻译:**
只能用 Perplexity。是的。

---

### (00:54:37) Lenny Rachitsky

**English:**
Okay. Perplexity is great too, but it's different. Okay. So let me follow this thread I was going down, which is around job displacement. I know you think a lot about this. So with me, this researcher as a contractor I was working with for a few months, I no longer need them. Your assistant, you no longer need. Thoughts on just the impact we're going to see on jobs as a result of AI.

**中文翻译:**
好的。Perplexity 也很棒，但不太一样。好的，让我继续刚才关于“失业”的话题。我知道你对此思考了很多。对我来说，那个合作了几个月的兼职研究员，我现在不需要了。你的助理，你也不需要了。关于 AI 对就业的影响，你有什么看法？

---

### (00:54:58) Andrew Wilkinson

**English:**
There's this great William Gibson quote, "The future is already here, it's just not evenly distributed." And I think that we are in the Palm Treo phase. Do you remember the Palm Treo?

**中文翻译:**
威廉·吉布森有一句名言：“未来已经到来，只是分布不均。” 我认为我们正处于 Palm Treo 阶段。你还记得 Palm Treo 吗？

---

### (00:55:09) Lenny Rachitsky

**English:**
No.

**中文翻译:**
不记得。

---

### (00:55:10) Andrew Wilkinson

**English:**
So when I was, let's see, in 2007 I think, was that when the iPhone came out? 2007?

**中文翻译:**
让我想想，是在 2007 年，iPhone 是那时候出来的吗？2007 年？

---

### (00:55:17) Lenny Rachitsky

**English:**
I know [inaudible 00:55:19].

**中文翻译:**
我知道……（听不清）。

---

### (00:55:18) Andrew Wilkinson

**English:**
Something like that. In 2007, there was this device called the Palm Treo and it was like a little PDA with a stylus and it had a little modem attachment. And so what you could do is you could get your email anywhere and that was this shocking thing. It had a black and white or barely color screen and you could go in and email people. And I remember walking through the mall buying shoes while answering business emails and going, "This is the ultimate freedom. This is incredible." But the problem with that device was it sucked. You had to use a stylus, it's not a good user experience. And then the iPhone comes out and you're like, "Okay, this is what I was waiting for. This is the real thing." But I got a little preview with the Palm Treo and so right now people like me who have the time and skillset to nerd out and build the agents can do this. It's just not accessible to everybody.

**中文翻译:**
差不多。2007 年有一种叫 Palm Treo 的设备，它就像一个带手写笔的小型 PDA，还有一个调制解调器附件。你可以随时随地收邮件，这在当时非常震撼。它有一个黑白或几乎没颜色的屏幕，你可以发邮件。我记得当时在商场买鞋，同时回复商务邮件，心想：“这就是终极自由，太不可思议了。” 但那个设备的问题在于它很烂。你必须用手写笔，用户体验不好。然后 iPhone 问世了，你会觉得：“好吧，这才是我想等的，这才是真家伙。” 但 Palm Treo 给了我一个预告。现在，像我这样有时间、有技能去钻研并构建智能体的人可以做到这些。但它对普通大众来说还不可及。

---

### (00:56:14) Andrew Wilkinson

**English:**
And I think that if it was accessible to everybody in terms of if you could just open ChatGPT and say, "Hey, ChatGPT, I run a business, can you help me?" And it started asking you questions and it said, "Oh well you do sales. Do you want me to set up a sales agent? Okay, great, plug in your HubSpot API, now tell me a few things and then give me access to all your data." And then before you know it, it's just a digital employee that's on the other end of the phone on ChatGPT just like in the movie, Her, that you can talk to and it can go do stuff. I think that is kind of the iPhone moment that we're going to have in some time in the next five years. And so I think that if AI doesn't progress, we will see some serious job displacement, like what you already mentioned, the translators, the researchers, the admin, some assistant jobs, depending on the kind of work they do, those jobs will definitely be massively affected.

**中文翻译:**
我认为，如果它对每个人都变得触手可及——比如你只需打开 ChatGPT 说：“嘿，我经营一家公司，你能帮我吗？” 它开始问你问题：“噢，你做销售。需要我帮你设置一个销售智能体吗？好的，接入你的 HubSpot API，告诉我一些情况，然后给我访问你所有数据的权限。” 接着，不知不觉中，它就成了一个数字员工，就在 ChatGPT 的另一端，就像电影《她》（Her）里那样，你可以和它交谈，它可以去办事。我认为这就是我们在未来五年内会迎来的“iPhone 时刻”。如果 AI 按照现在的速度发展，我们将看到严重的失业，就像你提到的：翻译、研究员、行政、部分助理岗位，根据工作性质的不同，这些工作肯定会受到巨大冲击。

---

### (00:57:13) Andrew Wilkinson

**English:**
But I think pretty quick, all knowledge work jobs could be affected if the models scale in the way that they say they're going to. I mean if you trust Sam Altman and Dario Amodei, I mean Dario Amodei said by, "2027, our models will be smarter than all PhDs." So in any subject. That is a staggering statement. And he's been a very conservative kind of almost fearful voice in the AI world. Very cautious to say things like that. And so when he said that, I perked up and started listening carefully. I don't know that that's how it's going to play out. He might be trying to fundraise, we have to take it with a grain of salt. But if that's true, then I think so many knowledge work jobs are going to change massively.

**中文翻译:**
但我认为很快，如果模型按照他们预期的规模扩展，所有的知识型工作都可能受到影响。如果你相信萨姆·奥特曼（Sam Altman）和达里奥·阿莫代（Dario Amodei，Anthropic 创始人）的话——达里奥曾说：“到 2027 年，我们的模型将比所有博士都聪明。” 指的是任何学科。这是一个令人震惊的声明。他在 AI 界一直是一个非常保守、甚至带点恐惧色彩的声音，说话非常谨慎。所以当他这么说时，我立刻警觉起来并开始仔细倾听。我不知道事情是否会真的这样发展，他可能是在为了融资，我们要持保留态度。但如果这是真的，那么我认为太多的知识型工作将发生巨变。

---

### (00:58:09) Lenny Rachitsky

**English:**
Okay, there a lot here. I actually had Mike on the podcast, their CPL, Mike Krieger, and he pointed out that Dario, every prediction he's had so far has been right over the past few years. And so there's a reason to listen to his insights. Okay. Andrew, I know you're not going to have all the answers for people. But let me ask you kind of a two-part question for new grads and for people currently in the workforce say like, I don't know, senior product manager advice on what they should do, where should they focus? What skills will matter most? What jobs do you think will last? What advice can you give us?

**中文翻译:**
好的，信息量很大。我之前请 Mike Krieger（Anthropic 的 CPO）上过节目，他指出达里奥过去几年的每一个预测到目前为止都是正确的。所以有理由听取他的见解。好的，Andrew，我知道你不可能给所有人答案。但我还是想问一个两部分的问题：对于应届毕业生，以及对于目前在职的人（比如资深产品经理），你对他们该做什么、该关注什么有什么建议？哪些技能最重要？你认为哪些工作能持久？你能给我们什么建议？

---

### (00:58:43) Andrew Wilkinson

**English:**
Everybody 10 years ago, do you remember there was this whole movement that we should teach kids how to code? Remember that?

**中文翻译:**
10 年前，你记得当时有一个全民运动，说我们应该教孩子写代码吗？记得吗？

---

### (00:58:49) Lenny Rachitsky

**English:**
Mh-hmm.

**中文翻译:**
嗯哼。

---

### (00:58:51) Andrew Wilkinson

**English:**
Now teaching kids how to code is teaching kids Basic and we have a GUI, right? You don't need to learn punch cards and basic programming or MS-DOS because we all have keyboards and mice. We don't have to do that. And I feel like coding has really gone away because of that. And I think now people are saying people need to learn how to prompt, which I think is very true for the tool set right now. But I don't know how relevant that is in the future because I think we're still, again, in the Palm Treo phase, I think that the AIs will be very good at eliciting what the actual problem you're trying to solve is and reinterpreting it in a way that it can optimize the query to get the right answer and solve the problem.

**中文翻译:**
现在教孩子写代码就像教孩子 Basic 语言，而我们已经有了图形界面（GUI），对吧？你不需要学习打孔卡、基础编程或 MS-DOS，因为我们都有键盘和鼠标。我们不需要做那些。我觉得编程本身也因为这个原因正在淡出。我认为现在人们说需要学习如何写提示词（Prompt），这对于现在的工具集来说确实是对的。但我不知道这在未来还有多大关联，因为我认为我们仍处于 Palm Treo 阶段。我认为 AI 将非常擅长引导出你真正想解决的问题，并以一种优化查询的方式重新解释它，从而获得正确答案并解决问题。

---

### (00:59:38) Andrew Wilkinson

**English:**
And so I think the fundamental question is do all jobs just become a single prompt? For example, does a CEO just grow the business while making the customers happy and turning a profit or something like that? And it is able to actually be an omniscient presence that can run a whole company. Now that's a big I'm someone building AI agents. I can barely get it to reliably do calendar entries and that kind of stuff. So I don't think that's totally imminent, but I can certainly see a world where that's coming. And so the question is, what is one to do when that reality is barreling down at you? For people who have resources, I think there's a lot of things they can do in terms of investment, they can invest in the companies that'll benefit from this, companies that have a lot of compute or energy or that sort of thing.

**中文翻译:**
所以我觉得根本问题是：所有的工作都会变成一个简单的提示词吗？例如，CEO 的工作是否变成了“在让客户满意的同时实现盈利并增长业务”之类的？而 AI 能够作为一个全知全能的存在来运行整个公司。当然，这是一个巨大的跨越——作为一个构建 AI 智能体的人，我目前甚至很难让它可靠地处理日历条目之类的事。所以我不认为这迫在眉睫，但我确实能预见到那样的世界。所以问题是：当那个现实向你疾驰而来时，该怎么办？对于有资源的人，我认为在投资方面有很多事可以做，比如投资那些能从中受益的公司，拥有大量算力或能源的公司。

---

### (01:00:29) Andrew Wilkinson

**English:**
So that's one thing, but that's not really the question. The question is what do you do if you're a smart 18-year-old or 19-year-old or whatever? In my opinion, I think the best thing to do right now is to get incredibly good with these tools and utilize them to build enough wealth that you can put the money into diversifying into compute and energy. And I do think that while everybody thinks that all jobs will go away in five years and robots will be everywhere, people generally overestimate things in the short term and underestimate them in the long term. So I think there's going to be this long window where robotics is not anywhere near good enough to even do raking leaves and stuff. And I think there's going to be a ton of opportunity for people to just spin up new businesses that never existed before.

**中文翻译:**
那是一方面，但那不是真正的问题。问题是：如果你是一个聪明的 18 或 19 岁的年轻人，你该怎么办？在我看来，现在最好的做法是极其熟练地掌握这些工具，并利用它们积累足够的财富，然后将资金分散投资到算力和能源领域。我也确实认为，虽然大家都觉得五年内所有工作都会消失、机器人无处不在，但人们通常会高估短期影响而低估长期影响。所以我认为会有一个很长的窗口期，期间机器人技术还远不足以胜任扫落叶之类的工作。我认为会有大量的机会让人们去创办以前从未存在过的新业务。

---

### (01:01:20) Andrew Wilkinson

**English:**
I was talking to some friends and we were like, "What do you do in a world of abundance where everything is really cheap and companies operate almost autonomously?" I think there's a lot of weird skillsets that we can't imagine right now. For example, just being funny, right? Being funny to hang out with them. Think about OnlyFans, right? Right now, there's this whole idea of OnlyFans where people are paying for comfort and connection, but in a romantic sense. Imagine people did that day to day, they just love hanging out with funny people. So you have a funny guy who you chat with or comes over to your house or whatever it is, I'm making stuff up. Maybe it's a guy who comes to play pickleball with you or something, I don't know. But I can imagine that in this weird world, there's all these weird new jobs.

**中文翻译:**
我曾和一些朋友聊天，我们说：“在一个一切都很便宜、公司几乎自主运行的丰饶世界里，你该做什么？” 我认为会有很多我们现在无法想象的奇怪技能。比如，单纯的“有趣”，对吧？因为有趣而让人想和你待在一起。想想 OnlyFans，对吧？现在 OnlyFans 的核心是人们为了情感慰藉和连接而付费，虽然带有浪漫色彩。想象一下人们日常也会这样做，他们只是喜欢和有趣的人待在一起。所以你有一个有趣的家伙可以聊天，或者他来你家，或者别的什么，我是在瞎编。也许是找个人陪你打皮克球（Pickleball）之类的，我不知道。但我能想象在那个奇怪的世界里，会有各种奇怪的新工作。

---

### (01:02:06) Andrew Wilkinson

**English:**
So I think my take is things will either be totally fine or they will be terrible and we'll all be dead. And I can't predict which those is there. I don't think it's worth thinking about all of us being dead. And so I think it's really just lean into what are the tools, how do you stay cutting edge? How do you build businesses and wealth in this new world? But I am certainly feeling a little bit like all of our brains could be defunct in the next 10 years. And that's kind of a scary thought.

**中文翻译:**
所以我的看法是：事情要么会完全没问题，要么会变得极其糟糕，我们都得完蛋。我无法预测是哪一种。我觉得没必要去想“大家都完蛋”的情况。所以我认为真正的做法是：全身心投入，掌握工具，保持前沿。在这个新世界里如何建立业务和财富？但我确实感觉到，在未来 10 年内，我们所有人的大脑可能都会变得“多余”。这是一个挺可怕的想法。

---

### (01:02:36) Lenny Rachitsky

**English:**
I'm picturing this dystopian world where humans are just going around making jokes.

**中文翻译:**
我正在脑补一个反乌托邦的世界，人类整天无所事事，到处讲笑话。

---

### (01:02:44) Andrew Wilkinson

**English:**
Where does status come from in a world of abundance? Where does status come from? Maybe it is just like being the best at hiking or something.

**中文翻译:**
在一个丰饶的世界里，地位从何而来？地位从何而来？也许就是看谁最擅长徒步之类的。

---

### (01:02:52) Lenny Rachitsky

**English:**
Well, let me ask you this because this is where it gets even more real is just with your kids. What are you encouraging them to learn? What are you encouraging them to get good at? Because this is the real problem a lot of people are having right now is what will matter in the future. Obviously we don't know, but what are you encouraging them to focus on?

**中文翻译:**
让我问你这个，因为这涉及到一个更现实的问题：你的孩子。你鼓励他们学习什么？鼓励他们擅长什么？因为这是现在很多人面临的真实难题：未来什么才重要？显然我们不知道，但你鼓励他们关注什么？

---

### (01:03:09) Andrew Wilkinson

**English:**
Well, I don't know. I mean there's so little, they're five and eight. And so really what I'm focused on is making sure they're socialized and they're polite, very basic. So are they comfortable talking to adults? I often send my son, whenever he wants something at a cafe, I always make him go up, ask nicely, pay himself, all that kind of stuff. But at this point I feel like for the first 10 years of life, you're just trying to make sure that they're not traumatized or rude. And I think it's going to be really interesting when they're 10 plus where they're really aware of this stuff and can start building with these tools. And to be honest, I just don't know. I think I just want them to lean into whatever they're passionate about and go from there. But I have no idea. And to be honest, it's not something I'm worrying about because it's too hard to worry about. I don't know, it's too multivariate. There's too many ways it can go.

**中文翻译:**
我也不知道。他们才五岁和八岁，还太小。所以我现在的重点是确保他们社会化、有礼貌，非常基础。比如，他们和成年人交流时是否自然？每当我的儿子在咖啡馆想要什么东西时，我总是让他自己去，礼貌地询问，自己付钱，诸如此类。在目前这个阶段，我觉得在人生的前 10 年，你只是在确保他们没有心理创伤，且不粗鲁。我认为当他们 10 岁以后，当他们真正意识到这些事情并开始使用这些工具构建东西时，情况会变得非常有趣。老实说，我真的不知道。我只想让他们投入到自己热爱的任何事情中，然后顺其自然。但我完全没头绪。老实说，我也没在担心这个，因为这太难担心了。变量太多，可能性太多。

---

### (01:04:03) Lenny Rachitsky

**English:**
I feel like a core part of your message is just get good with these tools. There's this classic quote, "AI won't replace you, it'll be somebody very good using AI is going to replace you," at least for a while. And so it feels like a big part of this is just use these things. Before we started recording, we were having a mic issue and I love you just went straight to ChatGPT, "ChatGPT, how do I connect this mic to reverse side and make it work?" And I feel like that's just a habit to build is just like go to ChatGPT whenever you have a problem like that. I've been doing that a lot. I was connecting a subwoofer from what wire do I need to buy to connect the subwoofer to the receiver?

**中文翻译:**
我觉得你传达的核心信息就是：熟练掌握这些工具。有一句名言：“AI 不会取代你，是一个非常擅长使用 AI 的人会取代你，”至少在一段时间内是这样。所以感觉很大一部分就是去使用这些东西。在我们开始录音前，麦克风出了点问题，我很喜欢你直接去问 ChatGPT：“ChatGPT，我怎么把这个麦克风连接到反面并让它工作？” 我觉得这就是需要建立的习惯：遇到这类问题就去找 ChatGPT。我也经常这么做。比如我连接低音炮时，会问需要买什么线来连接低音炮和接收器。

---

### (01:04:37) Andrew Wilkinson

**English:**
Well, the best part about ChatGPT is I used to just get stuck and I have ADHD. So when I got stuck, let's say, what's an example? I was redoing my home IT security. And what will happen is I'll be in the terminal and I'll enter something and then something goes wrong and it just keeps erroring. And then I'm like, "Well, I'm out." I have ADHD, I can't tolerate this. I just lose the thread completely. And ChatGPT allows me to stay on track and go so much further and faster than I ever could before. I love not being artificially stopped in your tracks and being able to continue the flow state as a result.

**中文翻译:**
ChatGPT 最棒的地方在于，我以前经常会卡住，而且我有 ADHD（多动症）。当我卡住时——举个例子，我正在重新布置家里的 IT 安全。我在终端（Terminal）里输入命令，然后出错了，一直报错。这时候我会想：“好吧，我不干了。” 我有 ADHD，我忍受不了这个，我会完全失去头绪。而 ChatGPT 让我能保持在轨道上，走得比以前远得多、快得多。我喜欢那种不被意外打断、能够持续保持“心流”状态的感觉。

---

### (01:05:17) Lenny Rachitsky

**English:**
And also I noticed you were using voice mode, which is what I've been using more and more. And I feel like that's something a lot of people sleep on is just the voice mode where you could talk to it and not have to sit there and type your questions. Okay, so let me go in a different direction. You've been spending a lot of time, you wrote a whole book about this, of just your journey from, you call it Barista to Billionaire where you started serving coffee, then you ended up being very successful, then realize that didn't make you happy. You're quite unhappy with lots and lots of money. I think a lot of people hear these stories, they see this stuff, they're like, "Yeah, okay, I sort of get it." But they still do the same sorts of things. They still assume they will be happy once they reach that next goal, that next title, make certain dollar amount. What can you share? What have you learned about just what it actually takes to be happy that you think people are still not really recognizing and still kind of are confused about?

**中文翻译:**
我还注意到你在用语音模式，这也是我最近用得越来越多的。我觉得很多人忽略了语音模式，你可以直接和它对话，而不需要坐在那儿打字。好的，让我们换个方向。你花了很多时间——还专门写了一本书——讲述你从“咖啡师到亿万富翁”的旅程。你从端咖啡开始，最终变得非常成功，然后意识到那并没有让你快乐。你拥有巨额财富却相当不快乐。我想很多人听过这类故事，看过这类东西，他们会说：“行吧，我大概懂。” 但他们还是会做同样的事，还是会假设一旦达到下一个目标、拿到下一个头衔、赚到一定数额的钱，他们就会快乐。你能分享一下吗？关于“究竟什么才能让人快乐”，你学到了什么你认为人们仍然没有真正意识到、仍然感到困惑的东西？

---

### (01:06:10) Andrew Wilkinson

**English:**
Do you remember when you're in your early 20s? I remember when I was in my early 20s, I'd always be like, "I need to move away to Europe. I need to go discover myself." And I'd be really anxious and stressed out and in an existential crisis and then I'd fly to Europe to go backpacking or something and I'd still feel anxious and have my existential crisis. It's just now I'm in Europe. And I think the reality is that whatever's in your brain, whatever that anxiety loop is, doesn't go away just because you have a bigger house or more money in the bank account or you're in Bali or wherever it is, that's a chemical reaction happening inside you that relates to your past and your DNA and all that stuff that creates that soup. And for me, I've always been a very anxious person. I've always worried about tomorrow, I rarely enjoy today, I'm always worrying about what could go wrong in health or my businesses or with my family or whatever it is.

**中文翻译:**
你还记得你 20 岁出头的时候吗？我记得我 20 岁出头时，总会想：“我得搬去欧洲，我得去寻找自我。” 当时我非常焦虑、压力巨大，陷入存在主义危机。然后我飞到欧洲去背包旅行，结果我依然感到焦虑，依然有存在主义危机。只不过，我现在是在欧洲焦虑。我认为现实是：无论你脑子里在想什么，无论那种焦虑循环是什么，它都不会因为你有了更大的房子、银行账户里有了更多的钱，或者你身在巴厘岛而消失。那是你体内发生的化学反应，与你的过去、你的 DNA 以及所有构成你这个人的因素有关。对我来说，我一直是个非常焦虑的人。我总是担心明天，很少享受今天。我总是在担心健康、业务、家庭或其他任何事情可能出问题。

---

### (01:07:12) Andrew Wilkinson

**English:**
And so when I started my business, all I thought was I just don't want to work for someone else. If I can just wake up in the morning, do my own thing, make 60K a year, then I'll be happy. So I got that and then it was once I make a million dollars a year and I can buy a house, well, I got that and so on and so on and so on all the way up to at one point being worth over a billion dollars, by the way, should redo the title of the book from Barista to Billionaire, now it's former billionaire because our stock went down, but it didn't change anything. I'm still just as anxious as ever. I remember a month ago, I had this day where I was sitting in the sauna and I was stressing about a bunch of business problems and money things and I stopped myself and I was like, "Wait a minute."

**中文翻译:**
所以当我开始创业时，我唯一的想法就是我不想为别人工作。如果我能早上醒来，做自己的事，一年赚 6 万美元，我就会快乐。我做到了。然后是“一旦我一年赚 100 万美元并能买房”，我也做到了。以此类推，直到一度身价超过 10 亿美元。顺便说一下，我应该把书名改了，不叫《从咖啡师到亿万富翁》，现在是“前亿万富翁”，因为我们的股价跌了。但这没有改变任何事情。我依然像以前一样焦虑。我记得一个月前，有一天我坐在桑拿房里，为一堆业务问题和金钱问题发愁，我突然停下来想：“等等。”

---

### (01:08:04) Andrew Wilkinson

**English:**
10 years ago I had all the same thoughts and I was stressed out about similar kinds of problems and our revenue was $20 million bucks or $15 million bucks. Now we're at almost 300 million and I'm still stressed about the same things. And the saddest part was as I met more and more wealthier people all the way up to multibillionaires, I realized they were all still comparing themselves to their peers, competing over who has what and tracking stuff and still unhappy that anxiety loop or depression was still in their brain. I remember I had this moment where I met this guy who is a single-digit multibillionaire, and he goes, "Oh, Jeff Bezos, he's just so fucking rich." And I was like, "Wait, what do you mean you're worth $5 billion? What can he do that you can't?" And he goes, "He can buy a super yacht." And it's like, "What?"

**中文翻译:**
10 年前我也有完全一样的想法，为类似的问题感到压力，而当时我们的营收只有 1500 万或 2000 万美元。现在我们接近 3 亿了，我还在为同样的事情发愁。最悲哀的是，随着我见到越来越多富有的人，甚至包括身价数十亿的人，我意识到他们依然在和同龄人比较，竞争谁拥有什么，追踪各种数据，依然不快乐。那种焦虑循环或抑郁依然留在他们脑子里。我记得有一次我遇到一个身价几十亿的人，他说：“噢，杰夫·贝佐斯，他简直太 TM 有钱了。” 我当时想：“等等，你身价 50 亿，你什么意思？他能做什么是你做不了的？” 他说：“他能买超级游艇。” 我心想：“啥？！”

---

### (01:09:09) Andrew Wilkinson

**English:**
You can look at that guy and you can say, "Oh, that's a wacko and all the other stuff." But the reality is that we're all just comparing ourselves to our peers, whatever our peers have that we don't feel hard done by. And I remember just thinking like, "Oh my God, how do I avoid becoming this?" And that's the scary reality is no matter how lucky you are, I mean we're also fortunate. For me, I live in Canada. I have every opportunity that I ever could have hoped for. And there's people all over the world who have nowhere near what I had growing up. And yet I felt hard done by because in my neighborhood I was the poor kid. I wasn't poor globally. I wasn't even poor based on Canada. But all my friends had big screen TVs and would go to Hawaii and I never got to do any of that stuff. My parents were stressed about money. So I feel hard done by.

**中文翻译:**
你可以看着那个人说：“噢，那是个疯子”之类的。但现实是，我们都在和同龄人比较。只要同龄人有的我们没有，我们就会觉得委屈。我记得当时在想：“天哪，我该如何避免变成这样？” 这就是可怕的现实：无论你多么幸运——我是说，我们都很幸运。对我来说，我住在加拿大，我拥有我能期望的所有机会。世界上有很多人成长环境远不如我。然而我还是觉得委屈，因为在我的邻里间，我是那个“穷孩子”。在全球范围内我不穷，甚至在加拿大标准下我也不穷。但我所有的朋友都有大屏幕电视，都会去夏威夷度假，而我从来没有。我父母为钱发愁。所以我感到委屈。

---

### (01:10:05) Lenny Rachitsky

**English:**
There's a phrase of friend's financial advisor once shared, "The Joneses are doing really well," and that's hard to get over. So what changes did you make to just be happier? It's hard to give up money. It's hard to give up more money you could make. It's hard to give up things that money buys, I guess just so what did you change?

**中文翻译:**
我朋友的财务顾问曾说过一句话：“邻居们（The Joneses）过得太好了，”这很难释怀。那么，为了变得更快乐，你做了哪些改变？放弃金钱很难，放弃赚更多钱的机会很难，放弃金钱能买到的东西也很难。所以，你到底改变了什么？

---

### (01:10:28) Andrew Wilkinson

**English:**
Well, there's a few things. I mean, one was reframing money to some degree to have it be something that wasn't just about feathering my own nest and making it better. So for example, I was talking to a friend who's very wealthy and I was saying all the feelings I described of have all this and yet I don't feel better. And he said, "Well, what are you working for?" And I said, "Well, I guess I'm just working for the numbers to get bigger and have more employees and that's nice. Our businesses do good things in the world and help more people and stuff, but ultimately it's just to pile up cash." And he said, "I've reframed it so that all my money, 90% of my money plus, goes into my philanthropic foundation and then it gets given away to great causes. So when I think about working really hard or losing a deal or an investment going well, the win isn't for me. The win is about doing something good."

**中文翻译:**
有几件事。首先是在某种程度上重新定义金钱，让它不再仅仅是为了“装点自己的小窝”和让自己过得更好。例如，我曾和一个非常富有的朋友聊天，我向他描述了我的感受：拥有了这一切，却没觉得更好。他问：“那你为什么工作？” 我说：“我想我只是为了让数字变大，雇更多员工，这挺好的。我们的业务在世界上做着好事，帮助更多人，但最终只是为了堆积现金。” 他说：“我重新定义了它，我 90% 以上的钱都会进入我的慈善基金会，然后捐给伟大的事业。所以当我想到努力工作、丢掉一笔交易或投资顺利时，赢家不是我，而是为了做善事。”

---

### (01:11:26) Andrew Wilkinson

**English:**
So I did that and that definitely helped. I also stopped spending as much money. I found that the more stuff I had, the more houses I had, the more people that directly worked for me to manage all that stuff, the less happy, I was owned by my stuff. And then I work really hard not to have people... I try not to beat people over the head with it. I drive a normal car. I don't bring people to my house until I know them really, really well. I meet them on neutral ground, I meet them in a cafe. I dress like a schmo. I just try not to be a weird out of touch rich person. But the biggest thing, which is a weird answer, is actually medicating myself. So basically all my life I've been really anxious.

**中文翻译:**
我也这么做了，这确实有帮助。我也停止了挥霍。我发现我拥有的东西越多——房子越多、直接为我管理这些东西的人越多——我就越不快乐，我被我的财物“占有”了。然后我努力不让别人……我尽量不显山露水。我开一辆普通的车。在非常熟悉之前，我不会带人回我家。我在中立地带见人，比如咖啡馆。我穿得像个普通人。我只是努力不做一个古怪、脱离群众的有钱人。但最重要的一点——这是一个奇怪的答案——其实是药物治疗。基本上我这辈子一直非常焦虑。

---

### (01:12:18) Andrew Wilkinson

**English:**
And in 2020, I remember I was watching a movie with my ex-wife and I was looping on, "I need to respond to this email. If I don't respond to that email, this person's going to be mad." And then I realized that I was watching a movie for the last 20 minutes and I didn't know anything about what was happening in the movie. And then I was going, "Oh my God, my wife is going to be mad at me. We're going to get in a fight," and I'm projecting all this negative stuff. And in that moment I was like, "Okay, maybe I do need to try an SSRI or something. This is not sustainable." And so I went to my doctor and I got prescribed with one, and I remember I was so scared of it that I cut it into 10 pieces. I said, "I'm just going to take a tiny little piece."

**中文翻译:**
2020 年，我记得我和前妻在看电影，我脑子里一直在循环：“我得回这封邮件。如果不回，那个人会生气的。” 然后我意识到，过去 20 分钟我虽然在看电影，却完全不知道剧情讲了什么。接着我想：“天哪，我妻子会生气的，我们会吵架，”我一直在投射这些负面情绪。那一刻我想：“好吧，也许我真的需要尝试 SSRI（抗抑郁/焦虑药物）之类的。这样下去不可持续。” 于是我去看医生，开了药。我记得当时我非常害怕，把药片切成了 10 份。我说：“我只吃一小块。”

---

### (01:13:01) Andrew Wilkinson

**English:**
And it took me six months after that to try any. But I started taking these pieces every day and I just noticed that within about three or four days, it was like someone had turned down the volume on the nasty voice inside of me doing all that. For the first time in my life I felt relief. No amount of money or success or attention or anything else had done what this little tiny yellow pill could do for my mental state. And so now I've been on an SSRI for four and a half years or something like that. And then I also started medicating my ADHD. And I would say that my brain went from Times Square to a quiet library. And I think a lot of people are scared of that, but ultimately most people are acting out something that's going on inside of them. There's a trauma or something medically going on and that's creating this anxiety, this depression, this feeling and addressing that is so much more important than trying to get praise from the external world.

**中文翻译:**
在那之后我花了六个月才敢尝试。但我开始每天吃一小块，我注意到在大约三四天内，就像有人调低了我内心那个刻薄声音的音量。我这辈子第一次感到了解脱。再多的金钱、成功、关注或其他任何东西，都无法像这颗黄色的小药丸一样改善我的精神状态。所以现在我已经服用 SSRI 大约四年半了。接着我也开始针对 ADHD 进行药物治疗。我想说，我的大脑从“时代广场”变成了“安静的图书馆”。我想很多人对此感到害怕，但最终，大多数人只是在表现出内心正在发生的事情。可能存在创伤或某种生理上的问题，从而产生了焦虑、抑郁和这种感觉。解决这些问题，比试图获得外界的赞美要重要得多。

---

### (01:14:05) Lenny Rachitsky

**English:**
Wow, it's really powerful. I really am really thankful you're sharing this. The advice most people hear, the general, I don't know, culture is just like, "No, don't take meds. Don't medicate yourself, I don't know, there's all these downsides, all this risk. The pharma industry is trying to make money." I love this other perspective of it. It's actually really effective and actually makes a big difference in your life and it may be the only solution.

**中文翻译:**
哇，这非常有力量。我真的很感谢你分享这些。大多数人听到的建议，或者说大众文化通常是：“不，别吃药。别给自己用药，会有各种副作用和风险。制药行业只是想赚钱。” 我很喜欢你提供的另一个视角：它其实非常有效，能给你的生活带来巨大改变，而且可能是唯一的解决方案。

---

### (01:14:29) Andrew Wilkinson

**English:**
Well, it's funny because if you have a headache, I don't think many people say, "Oh, don't take Tylenol, you're benefiting Johnson & Johnson, big pharma." They go, "Yeah, you take a Tylenol when you have a headache." Or a lot of people have seasonal allergies and they take antihistamines and they forget that histamine is not just in your nose, histamines in your brain and everywhere in your body. And so when you take an antihistamine or even a Tylenol, you're changing your brain, you're changing the way you think, you're changing everything. And yet for some reason, people are so scared, myself included, of taking an SSRI or similar medication to treat something that is ruining their life. Anxiety was ruining my life. Every minute of every day I was convinced that something terrible was about to happen. And even now medicated, I still have that voice. It's not like that frankly beneficial voice that helps you grow your business or whatever becomes unproductive at a certain point. And I think that it is wonderful to be able to actually just get a little bit of solace from it.

**中文翻译:**
这很有趣，因为如果你头痛，我想没多少人会说：“噢，别吃泰诺，你是在让强生公司这种大制药厂获利。” 他们会说：“是的，头痛就吃泰诺。” 很多人有季节性过敏，他们吃抗组胺药，却忘了组胺不仅在鼻子里，也在大脑和全身各处。所以当你吃抗组胺药甚至泰诺时，你都在改变你的大脑，改变你的思维方式，改变一切。然而出于某种原因，人们（包括曾经的我）却非常害怕服用 SSRI 或类似药物来治疗正在毁掉他们生活的问题。焦虑曾毁掉了我的生活。每一天的每一分钟，我都确信会有可怕的事情发生。即使现在服药了，那个声音依然存在。并不是说那个能帮你增长业务的“有益声音”在某个点之后就变得没用了。我认为能从中获得一点慰藉是非常美妙的。

---

### (01:15:38) Lenny Rachitsky

**English:**
Well, for folks that, I mentioned many folks listening, are like, "Oh man, I should really explore this," what's the best way to explore is to talk to your primary care physician?

**中文翻译:**
那么，对于那些听了之后觉得“天哪，我真的应该探索一下这个”的人，最好的探索方式是咨询全科医生（Primary Care Physician）吗？

---

### (01:15:47) Andrew Wilkinson

**English:**
Yeah. I think talking to your doctor, and one note I think a lot of people miss is when I was so scared of side effects because you hear about all these horrific side effects of people lose their libido and feel terrible and stuff. And so I looked into it and a lot of the side effects are due to the way that people metabolize different drugs. And so you can actually do your 23andMe or similar DNA test and you can find out how you metabolize different SSRIs. And then I chose one that I could metabolize well. And so I've had no side effects or problems. And I know every time I mention this, I get a lot of people that say exactly what you say, big pharma and all this other stuff. But I just ask everyone listening, if you take a Tylenol or you take an antihistamine or other medications, I don't know why something that can be so profoundly helpful is something that people need to be afraid of.

**中文翻译:**
是的。我认为应该咨询医生。还有一点很多人忽略了：我当时非常害怕副作用，因为你会听说各种可怕的副作用，比如失去性欲、感觉糟糕之类的。于是我研究了一下，发现很多副作用是因为人们代谢不同药物的方式不同。你其实可以通过 23andMe 或类似的 DNA 检测，查出你如何代谢不同的 SSRI。然后我选择了一种我能很好代谢的药物。所以我没有任何副作用或问题。我知道每当我提到这个，很多人会说你刚才提到的那些话——大制药厂之类的。但我只想问听众：如果你吃泰诺、抗组胺药或其他药物，我不明白为什么这种能带来深刻帮助的东西需要让人感到害怕。

---

### (01:16:40) Lenny Rachitsky

**English:**
Amazing. Andrew, we've covered so much ground. I love the spectrum of topics we've gone after. Is there anything else that you wanted to share? Anything you wanted to double down on? Any last nugget you want to leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
太棒了。Andrew，我们聊了非常多的内容。我喜欢我们涵盖的这些话题。还有什么你想分享的吗？有什么想强调的？在进入精彩的闪电问答环节之前，还有什么想留给听众的建议吗？

---

### (01:16:56) Andrew Wilkinson

**English:**
One thing that was shocking for me was I was doing... My doctor asked me to get a cognitive test, not because I had any problem, but he said, "Look, it's really important to get a baseline in your 30s because then as you age, we can make sure that you're not getting Alzheimer's or dementia or whatever." So I go and I do this test with a neurologist and she asked me a bunch of questions. It's, "Remember these 10 digits and say them backwards and all this stuff." And finally when I get my test results back, she said, "Look, your crystallized intelligence, your ability to remember stuff, long range is totally fine. You're above average. Your short-term memory, your working memory is 10th percentile, very, very bad. And you probably should get checked for ADHD."

**中文翻译:**
有一件事让我很震惊。我的医生让我去做认知测试，不是因为我有问题，而是他说：“在 30 多岁时建立一个基准非常重要，这样随着年龄增长，我们可以确保你没有患上阿尔茨海默症或痴呆症。” 于是我去找神经科医生做了测试，她问了我一堆问题，比如“记住这 10 个数字并倒着说出来”之类的。最后当我拿到测试结果时，她说：“看，你的晶体智力（Crystallized Intelligence）——即长期记忆能力——完全没问题，高于平均水平。但你的短期记忆、工作记忆处于第 10 百分位，非常非常糟糕。你可能应该去检查一下是否有 ADHD。”

---

### (01:17:47) Andrew Wilkinson

**English:**
And I was like, "Nope. There's no way. I don't have ADHD. I'm organized. I've got to-do lists. I built a business. I wasn't the hyper kid in school or anything like that." And she said, "Well, look, just humor me. Just go get tested." And so I went through this crazy process. You can go online and just quickly get tested or whatever. But I went through this really, really five-day process to get tested. And it turned out that I do have it. And it's really interesting because if you take the normal population of about 5% of people have ADHD, but about 30% of entrepreneurs have ADHD. And many entrepreneurs I talk to, they love new things. They love jumping around between a million different topics. They're an inch deep and a mile wide like I described. And they describe themselves as unemployable. And frankly, I remember I was so skeptical of ADHD that when my girlfriend told me, a friend of hers got diagnosed with it, I sarcastically said, "Oh good, she better take some meth," talking about stimulant drugs.

**中文翻译:**
我当时想：“不，不可能。我没有 ADHD。我很自律，我有待办清单，我创办了公司。我在学校也不是那种多动的小孩。” 她说：“好吧，就当是迁就我，去测一下吧。” 于是我经历了一个疯狂的过程。你可以去网上快速测试，但我经历了一个整整五天的测试过程。结果证明我确实有。这很有趣，因为在普通人群中大约有 5% 的人患有 ADHD，但在创业者中，这一比例约为 30%。我聊过的许多创业者都喜欢新鲜事物，喜欢在无数个话题间跳跃。他们就像我描述的那样，“一英里宽，一英寸深”。他们形容自己是“无法被雇佣的人”。坦白说，我以前对 ADHD 非常怀疑，以至于当我女朋友告诉我她的一个朋友被确诊时，我讽刺地说：“噢太好了，她最好吃点冰毒（指兴奋剂类药物）。”

---

### (01:18:54) Andrew Wilkinson

**English:**
Previously I was very, very skeptical of ADHD, but it is a real brain disorder if you actually dig into it. It's a very real thing, very objective that people have poor executive function. And for me, it's given me a lot more empathy for myself and my behaviors because at work, if you have ADHD, you can delegate to other people and build systems to get around your disability. But at home, that's where it really plays out. And so for me, my girlfriend asked me to take the garbage out, and I say, "Of course." And then I forget three times in a row. And she views that as you are being very hurtful and you're not caring for me. And it causes all sorts of different problems at home.

**中文翻译:**
以前我对 ADHD 非常怀疑，但如果你深入研究，它是一种真实的大脑障碍。这是一个非常客观的事实，即人们的执行功能较差。对我来说，这让我对自己和自己的行为有了更多的同理心。因为在工作中，如果你有 ADHD，你可以授权给别人，建立系统来规避你的缺陷。但在家里，问题就暴露无遗了。比如，我女朋友让我去倒垃圾，我说“没问题”。然后我连续忘了三次。她会觉得你很伤人，觉得你不在乎她。这会在家里引发各种问题。

---

### (01:19:37) Andrew Wilkinson

**English:**
And so for me, not only did it make my work life better because I was more focused, but it actually really helped me in my personal life and it made me feel not broken. I always felt a bit broken. I couldn't put my finger on why, but I just went, "I'm not good at doing all the things everyone else seems to be able to do no problem." And so I think especially because you have an entrepreneur audience, I think a lot of entrepreneurs should consider getting checked for ADHD. Just go and ChatGPT say, "Ask me a of questions and tell me if you think I might have it." But I was very surprised, and that's been really impactful for me too.

**中文翻译:**
所以对我来说，这不仅让我的工作生活变得更好（因为我更专注了），而且确实在个人生活上帮了我大忙，让我觉得自己不再是“坏掉的”。我以前总觉得自己有点坏掉了，说不出原因，只是觉得“我没法像别人那样轻而易举地处理所有事”。所以我认为，特别是考虑到你的听众很多是创业者，很多创业者应该考虑检查一下 ADHD。可以直接去问 ChatGPT：“问我一些问题，看看你觉得我是否可能有 ADHD。” 我当时非常惊讶，这对我也产生了巨大的影响。

---

### (01:20:13) Lenny Rachitsky

**English:**
Man, this garbage story is very descriptive of my life, and so I'm going to do this. There's this implication that it's good to know this, right? It feels scary to feel like, "Oh, shit I might get diagnosed with ADHD." Your advice I imagine is it's better to know because you could do stuff about it.

**中文翻译:**
天哪，那个倒垃圾的故事简直就是我生活的写照，我也要去测一下。这暗示了知道这件事是有好处的，对吧？虽然感觉有点吓人：“噢该死，我可能被诊断出 ADHD。” 我想你的建议是：知道总比不知道好，因为你可以采取行动。

---

### (01:20:33) Andrew Wilkinson

**English:**
Totally. I think it's like any medical thing, right? It's like there's an Alzheimer's gene, right? And if you know you have it, there's a lot you can do to slow the disease or prevent maybe getting it or whatever. It's always better to know. Even if you don't medicate, I think there's a lot of lifestyle interventions, dietary interventions, and just things you can do to make your life easier, even if it's just explaining to your partner, "Hey, I need things to be explained to me this way so that I can be effective in loving you."

**中文翻译:**
完全正确。我认为这就像任何医学问题一样。比如阿尔茨海默症基因，如果你知道自己携带，你可以做很多事来减缓病情或预防。知道总是更好的。即使你不服药，我认为也有很多生活方式的干预、饮食干预，以及你可以做的事情来让生活更轻松。哪怕只是向你的伴侣解释：“嘿，我需要你用这种方式向我解释事情，这样我才能更有效地爱你。”

---

### (01:21:05) Lenny Rachitsky

**English:**
Beautiful. Okay. Well, Andrew, with that, we've reached a very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
太棒了。好的，Andrew，聊到这里，我们进入了非常刺激的闪电问答环节。我有五个问题问你，准备好了吗？

---

### (01:21:11) Andrew Wilkinson

**English:**
Let's go.

**中文翻译:**
开始吧。

---

### (01:21:12) Lenny Rachitsky

**English:**
First question, what are two or three books that you find yourself recommending most to other people?

**中文翻译:**
第一个问题：你最常向别人推荐的两三本书是什么？

---

### (01:21:17) Andrew Wilkinson

**English:**
If I could only recommend two, I would recommend The Laws of Human Nature by Robert Greene. It's basically like a compendium of every single type of personality disorder or psychological effect. How do people work their minds to make bad decisions? What is a narcissist? What is a psychopath? All that kind of stuff. And Robert Greene does such a great job of telling all that in a really engaging way by using storytelling. So every single chapter has a story about someone with that personality disorder. So I love that book.

**中文翻译:**
如果只能推荐两本，我会推荐罗伯特·格林的《人性法则》（The Laws of Human Nature）。它基本上是各种人格障碍或心理效应的汇编。人们是如何思考并做出错误决定的？什么是自恋狂？什么是精神病态者？诸如此类。罗伯特·格林通过讲故事的方式，非常引人入胜地讲述了这些内容。每一章都有一个关于患有该种人格障碍的人的故事。我非常喜欢这本书。

---

### (01:21:48) Andrew Wilkinson

**English:**
The other one that I love is a book by Felix Dennis called How to Get Rich. It's hilarious because the whole book starts out saying, "I got rich and I regret it, and I wish that I'd become a poet." And instead he went off and he built this huge publishing empire, became a poet in his sixties, and then he died of throat cancer. So it's his story, he basically says, "I'll tell you how to build the business even though you probably shouldn't." And I read that when I was in my 20s, and I found it so exciting and inspiring, and then I recently reread it and I was like, "Oh my God, why didn't I listen to this guy?" Everything he said came true.

**中文翻译:**
另一本我喜欢的是菲利克斯·丹尼斯的《如何致富》（How to Get Rich）。这本书很滑稽，因为开头就说：“我变富了，但我很后悔，我希望我当时成了一名诗人。” 结果他去建立了一个庞大的出版帝国，在 60 多岁时成了诗人，最后死于喉癌。这是他的故事，他基本上在说：“我会告诉你如何建立业务，尽管你可能不应该这么做。” 我 20 多岁读到它时觉得非常兴奋和受启发，最近重读时我想：“天哪，我当时为什么没听这家伙的话？” 他说的一切都应验了。

---

### (01:22:23) Lenny Rachitsky

**English:**
Next question, do you have a favorite recent movie or TV show that you have really enjoyed?

**中文翻译:**
下一个问题：你最近有没有非常喜欢的电影或电视剧？

---

### (01:22:27) Andrew Wilkinson

**English:**
I love Challengers. I don't know if you've seen it, but it's amazingly acted, amazing cinematography. It's like this amazing romantic triad tennis movie. Really, really good.

**中文翻译:**
我喜欢《挑战者》（Challengers）。不知道你看了没，演技很棒，摄影也很美。这是一个关于网球和三角恋的精彩电影。非常非常棒。

---

### (01:22:40) Lenny Rachitsky

**English:**
Do you have a favorite product you recently discovered that you really love? You already mentioned Limitless. Is there anything else?

**中文翻译:**
你最近有没有发现什么非常喜欢的产品？你已经提到了 Limitless，还有别的吗？

---

### (01:22:45) Andrew Wilkinson

**English:**
I'm one of those people who really believes in the idea of a robot vacuum. I've probably spent $10,000 on different robot vacuums over the years, probably five or six of them. And I finally got one that actually works. It's called the Matic Vacuum, M-A-T-I-C. And basically, I think it's like former Google Engineers basically built like a mini Waymo car. So it has machine vision and it will avoid absolutely everything and never get tangled, and it can mop your floors and vacuum. I've been super impressed with it so far.

**中文翻译:**
我是那种坚信扫地机器人理念的人。这些年来我可能花了 1 万美元买各种扫地机器人，大概买了五六个。我终于买到一个真正好用的了，叫 Matic Vacuum。基本上，我觉得它就像是前谷歌工程师造的一辆微型 Waymo 自动驾驶汽车。它有机器视觉，能避开所有障碍物，永远不会被缠住，还能拖地和吸尘。到目前为止，它给我留下了深刻印象。

---

### (01:23:16) Lenny Rachitsky

**English:**
I've got one of these myself. Completely agree. My wife loves it, which I did not expect. She's like, "Turn that Matic on." It's very delightful. It has his little personality and it just does a really good job. And I'm not an investor, and that's awesome. I'm a huge fan. Okay, next question. Do you have a favorite life motto that you often come back to find useful in work or in life?

**中文翻译:**
我自己也有一个，完全同意。我妻子很喜欢它，这出乎我的意料。她会说：“快把 Matic 打开。” 它很有趣，有点小个性，而且干活很利索。我不是投资者，但我真的是它的超级粉丝。好的，下一个问题：你有没有什么座右铭，是你经常觉得在工作或生活中很有用的？

---

### (01:23:38) Andrew Wilkinson

**English:**
Yeah. My favorite is a quote by Jerzy Gregorek. It's, "Easy choices, hard life. Hard choices, easy life." And I often find that anytime that I'm making the easy choice, my life gets hard. And when I make the hard choice to shut down the business, fire the person, say bye to a project that I was excited about, it's almost always the right choice and it makes my life a lot easier.

**中文翻译:**
有的。我最喜欢的是 Jerzy Gregorek 的一句话：“选择容易，生活艰难；选择艰难，生活容易。” 我经常发现，每当我做容易的选择时，我的生活就会变得艰难。而当我做出艰难的选择——关闭业务、开除员工、告别一个让我兴奋的项目——这几乎总是正确的选择，并让我的生活变得轻松得多。

---

### (01:24:07) Lenny Rachitsky

**English:**
Final question. Okay, so let me know if this is true. I found that when you were a teenager, when you're running Macteens, you interviewed Steve Jobs at a conference. Is that true?

**中文翻译:**
最后一个问题。好的，告诉我这是不是真的：我发现你青少年时期经营 Macteens 时，曾在一次会议上采访过史蒂夫·乔布斯。是真的吗？

---

### (01:24:18) Andrew Wilkinson

**English:**
So when I was a teenager, I had a tech news website and I emailed the Apple PR people and I said, "Hey, could I interview Steve Jobs?" And they kind of laughed at me. They're like, "Yeah, there's no way. You're not going to interview Steve Jobs, but hey, why don't you go to this tour of the Apple Store?" So this is no other Apple Store has existed. This is in New York at Macworld back in 2004, no, 2003, something like that. And so I was really excited about that. So I show up to go do this tour and there's 30 other journalists there, and I'm first in line, and this big black SUV pulls up and this man gets out and the man is wearing gray New Balance, little circular John Lennon glasses, the mock turtleneck. And my brain finally puts it together and I realize it's Steve Jobs.

**中文翻译:**
当我还是个青少年时，我有一个科技新闻网站。我给苹果的公关发邮件说：“嘿，我能采访史蒂夫·乔布斯吗？” 他们有点嘲笑我，说：“没门，你不可能采访到乔布斯。不过，嘿，你要不要来参加这个 Apple Store 的参观活动？” 当时还没有其他的 Apple Store。那是 2003 或 2004 年在纽约的 Macworld 大会上。我非常兴奋。我准时出现在参观现场，那里还有 30 名其他记者。我排在第一位，这时一辆黑色大 SUV 停了下来，一个男人走了出来。他穿着灰色的新百伦（New Balance）鞋，戴着约翰·列侬式的小圆眼镜，穿着半高领毛衣。我的大脑终于反应过来了：那是史蒂夫·乔布斯。

---

### (01:25:11) Andrew Wilkinson

**English:**
And he walks directly up to me because I'm first in line and he shakes my hand and he says, "Hi, I'm Steve." And I'm like a quivering mess. I'm 17 years old. He is my hero. He's my Jesus. And so I was just so high on adrenaline that I just started asking him questions. As soon as we walked in, I basically just stayed at his side, and I just picked his brain about all sorts of different stuff. So it's not like I got to ask him questions about life. I was asking him about the new 17-inch iMac or whatever. But it was a pretty cool experience to get to meet him.

**中文翻译:**
他直接朝我走来，因为我排在第一位。他握了我的手说：“嗨，我是史蒂夫。” 我当时激动得全身发抖。我才 17 岁，他是我的英雄，是我的上帝。我肾上腺素飙升，开始不停地问他问题。一进店，我就紧跟在他身边，向他请教各种事情。当然，我没问什么人生大道理，我问的是关于新款 17 英寸 iMac 之类的事。但能见到他真的是一次非常酷的经历。

---

### (01:25:46) Lenny Rachitsky

**English:**
That is awesome. There's such a funny thread recently with guests. Everyone, there's like a Steve Jobs connection for the past couple months of guests. That's an awesome story. It just shows that it wasn't luck. You made this happen. You got there first in line.

**中文翻译:**
太赞了。最近几个月的嘉宾似乎都有某种“乔布斯情结”，这很有趣。这是一个很棒的故事，它说明这不仅仅是运气，是你促成了这件事，因为你排在了第一位。

---

### (01:25:59) Andrew Wilkinson

**English:**
The lesson for me was ask big and maybe you'll get something great. Ask for amazing, you'll get something great, which I did.

**中文翻译:**
对我来说，教训就是：大胆去要求，也许你会得到伟大的回报。追求极致，你会得到伟大的结果，我当时就是这么做的。

---

### (01:26:07) Lenny Rachitsky

**English:**
Yes, door in the face technique, I think people call it.

**中文翻译:**
是的，人们常说的“留面子效应”（Door-in-the-face technique，指先提一个大要求被拒后再提小要求）。

---

### (01:26:11) Andrew Wilkinson

**English:**
Yeah.

**中文翻译:**
是的。

---

### (01:26:12) Lenny Rachitsky

**English:**
Andrew, this was incredible. Two final questions. Where can folks find you if they want to reach out? I know you're buying companies, investing in companies. Just talk about what you're looking for there in case people are like, "Oh, this is me." And then finally, how can listeners be useful to you?

**中文翻译:**
Andrew，这次对话太精彩了。最后两个问题：如果大家想联系你，可以在哪里找到你？我知道你在收购和投资公司，请谈谈你在寻找什么样的目标，万一有人觉得“这就是我”。最后，听众可以如何帮到你？

---

### (01:26:26) Andrew Wilkinson

**English:**
Yeah, my business is Tiny, T-I-N-Y.com, and we buy businesses. Basically, when we sold the business, we hated it. We went through this process where we talked to all these douchebags that ran private equity firms that would show up in our office in suits and use a bunch of words we didn't understand. And we ended up going, "Man, why can't we just sell to somebody who's like us?" And so we basically started Tiny to become the buyer we wish we could have sold to. And we're looking for businesses that have some of the qualities I mentioned before. So really high quality businesses that do something positive in the world and have happy customers, happy employees, and some kind of competitive advantage that will make them continue into the future. So we own AeroPress, Letterboxd, Dribble, which is a design social network, whole bunch of businesses like that. So if somebody is thinking about selling their business, definitely get in touch.

**中文翻译:**
好的，我的公司叫 Tiny（Tiny.com），我们收购业务。基本上，当我们卖掉自己的第一家公司时，我们很讨厌那个过程。我们不得不和那些经营私募股权公司的混蛋打交道，他们穿着西装出现在办公室，满嘴我们听不懂的术语。我们最后想：“天哪，为什么我们不能卖给像我们这样的人呢？” 所以我们创办了 Tiny，旨在成为我们当年梦寐以求的那种买家。我们在寻找具备我之前提到的那些品质的业务：高质量、对世界有积极影响、拥有快乐的客户和员工，以及某种能让它们持续发展的竞争优势。我们拥有 AeroPress、Letterboxd、Dribble（设计社交网络）等一大堆公司。所以如果有人考虑出售业务，请务必联系我们。

---

### (01:27:29) Lenny Rachitsky

**English:**
Amazing. Okay. And then how can listeners be useful to you if it's not just that?

**中文翻译:**
太棒了。好的。除了这个，听众还能怎么帮到你？

---

### (01:27:33) Andrew Wilkinson

**English:**
I just would say if there's anyone really interesting coming to Victoria, Canada, which is where I live, send me an email and would love to have coffee with you. The reason I love going on podcasts is because I get to meet so many interesting people, both randomly. If I'm in a cafe and someone sees me and says hi, I often make a lot of friends that way, or if someone comes to my hometown. So yeah, just get in touch.

**中文翻译:**
我只想说，如果有任何有趣的人来到加拿大维多利亚市（我住的地方），请给我发邮件，我很乐意和你一起喝杯咖啡。我喜欢上播客的原因是我能遇到这么多有趣的人。无论是在咖啡馆偶遇打招呼，还是有人专门来到我的家乡，我经常通过这种方式交到很多朋友。所以，尽管联系我吧。

---

### (01:27:56) Lenny Rachitsky

**English:**
Amazing. Andrew, thank you so much for being here.

**中文翻译:**
太棒了。Andrew，非常感谢你能来。

---

### (01:27:59) Andrew Wilkinson

**English:**
Yeah, thanks, dude. That was fun.

**中文翻译:**
谢谢，伙计。聊得很开心。

---

### (01:28:00) Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。