# Andy Johns - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Andy Johns.

---

### (00:00:00) Andy Johns

**English:**
There are day-to-day stresses that are normal and we just have to put up with, but then there's the other stuff that's the flashing red alarm. Again, you can go back to animals. It's like when their fundamental functions, when their core behaviors of diet, exercise, playfulness, socialization, sleep, when those things get disrupted, it's a sign that there is something going on here that you need to take a look at.
So the same is true with people. If your sleep always sucks, if your relationships are constantly strained or frequently strained, if your physical health is failing, there's so many ways that that can be measured. So there's really no excuse for that to say, "Oh, I just didn't know." I'd say it's to look at those things. When those are suffering or when they're really out of whack, it's undeniable that there is something that is detrimental to your wellbeing that's going on right now, and your body is telling you, "Stop. Something needs to change."

**中文翻译:**
日常压力是正常的，我们必须忍受，但还有另一种情况，那是闪烁的红色警报。同样，你可以观察动物。就像当它们的基本功能，当它们关于饮食、运动、玩耍、社交、睡眠的核心行为被打乱时，这就表明出了一些你需要关注的问题。
人也是一样。如果你的睡眠一直很糟糕，如果你的关系经常处于紧张状态，如果你的身体健康正在衰退，这些都是可以衡量的。所以真的没有理由说：“噢，我只是不知道。”我会说，去看看这些指标。当这些方面出现问题或严重失衡时，不可否认，现在正发生着一些损害你福祉的事情，你的身体在告诉你：“停下来。有些事情需要改变了。”

---

### (00:01:03) Lenny

**English:**
Welcome to Lenny's Podcast, where interview world-class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful products. Today, my guest is Andy Johns. This is going to be a very different type of episode and maybe the most meaningful and important episode of the podcast.
Andy was a legendary product and growth leader at Facebook, Twitter, Quora, and Wealthfront, where he was VP of Growth and VP of Product, and then President, and as you'll hear, was in line to be CEO of Wealthfront until he came to realize that this path was not right for him. After a lot of internal reflection and hard self-work, he changed his entire life's path to becoming a mental health advocate and helping burned out high achievers and also veterans with their mental health journey.
In our conversation, Andy shares his personal story, what true burnout looks like, and when you should pay attention to your mental health. Talks about the process of deep personal transformation and the four steps involved in making lasting change in your life. He also shares how to actually allow change to happen in your life, tactics for moving down this path, and a lot of advice and real talk on mental health and tech.
There's a lot of struggle happening in the world right now, including in tech, and so I hope this conversation helps you with your own journey. You can check out Andy's work at Clues.Life. With that, I bring you Andy Johns after a short word from our sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我们采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中辛苦换来的经验。今天，我的嘉宾是 Andy Johns。这将是一集非常不同的节目，也许是本播客最有意义、最重要的一集。
Andy 曾是 Facebook、Twitter、Quora 和 Wealthfront 的传奇产品和增长领导者。他在 Wealthfront 担任过增长副总裁、产品副总裁，后来担任总裁。正如你将听到的，他曾是 Wealthfront CEO 的继任人选，直到他意识到这条路并不适合他。经过大量的内心反思和艰苦的自我提升，他改变了整个人生轨迹，成为一名心理健康倡导者，帮助那些职业倦怠的高成就者以及退伍军人进行心理健康疗愈。
在我们的对话中，Andy 分享了他的个人故事、真正的职业倦怠（burnout）是什么样子的，以及你何时应该关注自己的心理健康。他谈到了深度个人转型的过程，以及在生活中做出持久改变所涉及的四个步骤。他还分享了如何真正让改变在生活中发生、走这条路的策略，以及关于科技行业心理健康的大量建议和真心话。
现在世界上有很多挣扎，包括在科技界，所以我希望这次对话能对你的人生旅程有所帮助。你可以在 Clues.Life 查看 Andy 的工作。在赞助商的简短广告之后，我将为你带来 Andy Johns。

---

### (00:02:26) Lenny (Sponsorships)

**English:**
This episode is brought to you by Mercury, who I also happen to use for my business checking account. I've tried a lot of business banks and there is nothing even close to the experience you get with Mercury. I moved cash over from another bank and it literally took less than half an hour to set up the account and wire money over at no cost. They make you want to use the site more often, which I had never felt with another banking site. Mercury is banking engineered for the startup journey, a modern solution to help your company become the best version of itself.
Mercury isn't just a place to hold and send money. It's software built to help you scale with safety and stability, whether you're a team of two or a team of a thousand. Mercury also goes beyond banking to provide you with access to the foremost investors, operators, and tools. Visit mercury.com to join over 100,000 startups on Mercury, the powerful and intuitive way for ambitious companies to bank. Mercury is a financial technology company, not a bank. Banking services provided by Choice Financial Group and Evolve Bank & Trust. Members FDIC.
This episode is brought to you by Coda. You've heard me talk about how Coda is the doc that brings it all together, and how can it help your team run smoother and be more efficient. I know this firsthand because Coda does that for me. I use Coda every day to wrangle my newsletter content calendar, my interview notes for podcasts, and to coordinate my sponsors. More recently, I actually wrote a whole post on how Coda's product team operates, and within that post, they shared a dozen templates that they use internally to run their product team, including managing the roadmap, their OKR process, getting internal feedback, and essentially their whole product development process is done within Coda.
If your team's work is spread out across different documents and spreadsheets and a stack of workflow tools, that's why you need Coda. Coda puts data in one centralized location regardless of format, eliminating roadblocks that can slow your team down. Coda allows your team to operate on the same information and collaborate in one place. Take advantage of this special limited time offer just for startups. Plan up today at coda.io/lenny and get a thousand dollars starter credit on your first statement. That's C-O-D-A dot I-O slash Lenny to sign up and get a startup credit of $1,000, coda.io/lenny.
Andy, thank you so much for being here and welcome to the podcast.

**中文翻译:**
本集节目由 Mercury 赞助，我自己的商业支票账户也在使用它。我尝试过很多商业银行，没有一家能提供像 Mercury 这样的体验。我从另一家银行把资金转过来，建立账户并免费电汇资金只用了不到半小时。他们让你想更频繁地使用这个网站，这是我在其他银行网站从未有过的感受。Mercury 是为创业之旅设计的银行服务，是一个帮助你的公司成为最佳版本的现代解决方案。
Mercury 不仅仅是一个存钱和汇钱的地方。它是为了帮助你安全稳定地扩张而构建的软件，无论你是两人团队还是千人团队。Mercury 还超越了银行服务，为你提供接触顶尖投资者、运营者和工具的机会。访问 mercury.com，加入 Mercury 上的 10 万多家初创公司，这是雄心勃勃的公司进行银行操作的强大且直观的方式。Mercury 是一家金融科技公司，不是银行。银行服务由 Choice Financial Group 和 Evolve Bank & Trust 提供。FDIC 成员。
本集节目由 Coda 赞助。你听我谈过 Coda 是如何将一切整合在一起的文档，以及它如何帮助你的团队运行得更顺畅、更高效。我有亲身体会，因为 Coda 就在为我服务。我每天都用 Coda 来管理我的时事通讯内容日历、播客采访笔记，并协调我的赞助商。最近，我写了一篇关于 Coda 产品团队如何运作的文章，在那篇文章中，他们分享了十几个他们在内部运行产品团队时使用的模板，包括管理路线图、OKR 流程、获取内部反馈，基本上他们整个产品开发流程都是在 Coda 中完成的。
如果你的团队工作分散在不同的文档、电子表格和一堆工作流工具中，这就是你需要 Coda 的原因。Coda 将数据放在一个中心位置，无论格式如何，消除了可能拖慢团队速度的障碍。Coda 允许你的团队在相同的信息上运作并在一个地方协作。利用这个专门为初创公司提供的限时优惠。今天就在 coda.io/lenny 注册，并在你的第一张账单上获得 1000 美元的启动信用额度。访问 C-O-D-A.I-O/Lenny 注册并获得 1000 美元的创业信用额度，coda.io/lenny。
Andy，非常感谢你能来到这里，欢迎来到播客。

---

### (00:04:53) Andy Johns

**English:**
Thanks, Lenny. Happy to be here.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。

---

### (00:04:54) Lenny

**English:**
So I've been both looking forward to our conversation, but I've also been dreading it a little bit because I know it's going to be incredibly valuable, but I also think it's going to get very heavy, and I think it's important to get heavy sometimes, especially with the stuff we're going to be talking about, but just wanted to share that.

**中文翻译:**
我一直很期待我们的对话，但同时也感到有些畏惧，因为我知道它会非常有价值，但我也认为内容会变得非常沉重。我认为有时候变得沉重是很重要的，尤其是我们要讨论的这些话题，只是想先分享一下这种感觉。

---

### (00:05:09) Andy Johns

**English:**
Yeah, and I'm looking forward to that. I think one of the things that has been a change for me over the last several years is that I prefer to move forward in my life being completely honest with who I am, not hiding any aspects of myself, including the stuff that in the past I'd be afraid to share.

**中文翻译:**
是的，我也很期待。我想过去几年对我来说的一个改变是，我更倾向于在生活中完全诚实地面对自己，不隐藏自己的任何方面，包括那些过去我害怕分享的东西。

---

### (00:05:29) Lenny

**English:**
Well, on that topic, I'd love for you to just walk us through the path that you've taken. Basically, you're like me in a sense. You're helping companies build product, drive growth, worked with some of the best companies in the world, and then things took a turn. So could you just start with a brief overview of what happened?

**中文翻译:**
关于这个话题，我希望你能带我们回顾一下你走过的路。基本上，在某种意义上你和我一样：你帮助公司构建产品、推动增长，曾与世界上一些最优秀的公司合作，然后事情发生了转折。你能先简要概述一下发生了什么吗？

---

### (00:05:48) Andy Johns

**English:**
Sure. So the short background is I spent about 17 years working in the world of startups. I think on the whole, it was a successful experience. I managed to land at a handful of really good companies and had a great experience, but along the way, despite having built somewhat of an impressive resume, I guess you could say, I was also struggling quite a bit in terms of my emotional, psychological, and spiritual health. So in some ways, it feels like the cliche that as my career reached its pinnacle, that from a professional, from a financial perspective, I was at my highest, but when it came to other aspects of my life, I was arguably at my lowest or close to my lowest.
So even though I had those successes, there was a lot that I needed to work through that was under the hood, which I eventually came to understand very, very deeply as a result of turning inward and doing a lot of work on my own path towards self-understanding and healing some deep emotional wounds.

**中文翻译:**
好的。简短的背景是，我在初创企业界工作了大约 17 年。总的来说，我认为那是一段成功的经历。我成功进入了几家非常优秀的公司，拥有了很棒的体验。但在这一过程中，尽管建立了一份相当令人印象深刻的简历，我同时也在情感、心理和精神健康方面挣扎得很厉害。所以从某种程度上说，这听起来像个陈词滥调：当我的职业生涯达到巅峰，从专业和财务角度看我处于最高点时，但在生活的其他方面，我可以说处于最低点或接近最低点。
所以，尽管我取得了那些成功，但我内心深处（under the hood）有很多需要解决的问题。通过向内看（内省）并在自我理解和治愈深层情感创伤的道路上做了大量工作，我最终非常深刻地理解了这些问题。

---

### (00:07:14) Andy Johns

**English:**
Sure. I can share that. It actually goes back to ... This is 2010. I was at Twitter at the time. I was in my late 20s. Again, my career was going really well. I was starting to string together a series of successful experiences, and I was suddenly hit with near constant panic, panic attacks, depression. I was having a very, very difficult time sleeping and just managing my emotions as a whole. It got to the point to where there were several occasions while I was at work where I could tell that I was about ready to have a breakdown of sorts, and I would just grab my laptop, throw it in my bag, and pretty quietly just walk out of the office even if it was 10:00 AM and I'd only been there for an hour or two. That happened on multiple occasions.
There were some occasions in which I was set up to go and speak to the entire company during an all-hands session, and it was something where I just had to come up with an excuse and bow out of it because at the time, I was already completely overcome and overwhelmed by this near constant panic I was experiencing, but I had a really good poker face, I don't think most people could see it.
To give a little bit of an explanation and to tie first question together with this, there were two major things that contributed to me having a pretty acute case of burnout and needing to step away from my career as I knew it. The first was just the slow and steady accumulation of the pressure, the stresses, the anxieties, the emotional ups and downs that came from having such a strong commitment to my career, and frankly an addiction to achievement as a way to feel good and to feel whole, but I was so focused on my work that I had slowly become the frog that was boiling in the pot, the typical analogy of you don't realize how bad things are getting because it's happening to you slowly until it happens quickly, right?
On one hand, I was not only struggling emotionally and psychologically because of the pressures of the career and climbing the ladder and just the common existential angst that comes with being at a startup and not knowing what the future holds. What I later came to understand was that I was also starting to experience and to address old emotional pain that I'd buried for a very long time, stemming back to the death of my mom when I was 10. She was severely mentally ill. She was bipolar, had bouts of psychosis, and had spent time in and out of psychiatric hospitals. I can remember going to those hospitals as some of my earliest memories as a kid.
So there was a lot of disruption in my childhood, a lot of neglect, some occasional abuse, and then it culminated with the loss of the most important female figure in my life when I was 10. Of course, like anyone else after that, I was in a lot of pain emotionally, but as a kid, you don't have the tools or even the capabilities to effectively process something as significant and traumatic as an experience like that.
So my mind did what the mind of most children will do, which is it finds a way to bury it or to ignore it. The thing that I had latched onto that made me feel better was that anytime I hit a home run or scored a goal or got straight A's and was just basically a stellar student and a stellar athlete, I was showered with love, not only from my family, which is fantastic, but from society at large, especially within the world that we live in.
So I learned very early on that if I wanted to feel good, I needed to achieve, and that if I wanted to love myself and be considered lovable by others, I needed to achieve. That pulled me out of a darkness that I was in for several years as a kid, and I'm glad that it did, and it led to an excellent experience in high school, in college, and then well into my 20s, but eventually, those emotional wounds are going to come to the surface. They're going to come up for error, and when they do, it's going to be difficult, and that's what happened with me.
So it was really two things coming together at the same time. It was the growing pressures of an escalating career within the dynamic industry, but then also, I think, the natural maturation of my mind and of adult development such that it was time for that old pain to come to the surface, and when it did, it was very disruptive and it's something that I'm still continuing to work on to this day.

**中文翻译:**
好的，我可以分享。这实际上要追溯到……那是 2010 年。当时我在 Twitter 工作，二十多岁快三十岁。同样，我的职业生涯非常顺利，开始积累一系列成功的经验。但我突然陷入了近乎持续的恐慌、惊恐发作和抑郁。我睡眠非常困难，整体情绪管理也出了问题。情况严重到有好几次在工作时，我能感觉到自己快要崩溃了，于是我就抓起笔记本电脑塞进包里，悄悄走出办公室，哪怕当时才上午 10 点，我才到公司一两个小时。这种情况发生了多次。
还有几次，我本该在全员大会上向全公司发言，但我不得不找个借口退出，因为当时我已经被那种持续的恐慌完全击垮和淹没了。但我有一张很好的“扑克脸”，我想大多数人都看不出来。
为了解释一下并将第一个问题联系起来，有两件主要的事情导致了我严重的职业倦怠，并让我不得不离开我所熟知的职业生涯。第一是压力、焦虑、情绪起伏的缓慢而稳定的积累，这些来自于我对事业的极度投入，坦率地说，是对“成就”的成瘾，以此来获得良好和完整的感觉。但我太专注于工作，以至于慢慢变成了“温水里的青蛙”——典型的比喻是，你没有意识到情况变得多么糟糕，因为它发生得很慢，直到它突然爆发，对吧？
一方面，我不仅因为职业压力、职位晋升以及在初创公司面临未来不确定性时常见的“存在主义焦虑”而在情感和心理上挣扎。我后来才明白，我也开始经历并处理埋藏已久的旧情感伤痛，这可以追溯到我 10 岁时母亲的去世。她患有严重的精神疾病，是双相情感障碍，有过精神错乱，进出过精神病院。我记得小时候最早的记忆之一就是去那些医院。
所以我的童年有很多动荡、忽视，偶尔还有虐待，最后在我 10 岁时失去了生命中最重要的女性形象。当然，在那之后，像其他人一样，我在情感上非常痛苦。但作为一个孩子，你没有工具甚至没有能力去有效处理像那样重大且创伤性的经历。
所以我的大脑做了大多数孩子大脑会做的事：找个办法把它埋起来或忽视它。我抓住的让我感觉好一点的东西是：每当我打出全垒打、进球或拿到全 A，基本上成为一名卓越的学生和运动员时，我就会被爱包围——不仅来自我的家人（这很棒），还来自整个社会，尤其是在我们生活的这个世界里。
所以我很早就学会了：如果我想感觉良好，我就需要取得成就；如果我想爱自己并被他人认为值得爱，我就需要取得成就。这把我从童年几年的黑暗中拉了出来，我很庆幸它做到了，这让我在高中、大学以及二十多岁时都有了极好的经历。但最终，那些情感创伤总会浮出水面。它们会出来“透气”，当它们出现时，情况会变得很艰难。这就是发生在我身上的事。
所以这实际上是两件事同时发生的：一是动态行业中不断升级的职业压力，二是，我认为，随着我心智的自然成熟和成年后的发展，那些旧伤痛到了该浮出面的时候了。当它发生时，极具破坏性，直到今天我仍在继续处理这些问题。

---

### (00:13:16) Andy Johns

**English:**
For the last two years, I've been doing a lot of writing, and most of my writing has really just been me opening up and sharing this personal side of what was going on behind the scenes. Along the way, I've been able to connect with, at this point, hundreds of folks in the tech industry who are dealing with their own forms of burnout or their own deep existential questions that are coming to the surface and they're trying to understand them.
So from some of the surveys I've put out from my own anecdotal experience and from some proper research that's been conducted by experts who focus on entrepreneur and high performer wellbeing, I'd say that it's a fair estimate to say that at least 50% to 60% of tech employees who have, just to give it a bit more nuance, who have been in the saddle, so to speak, for a minimum of five to seven years, they're experiencing some form of psychological and emotional distress. It may be minor enough such that they think it's just day-to-day anxiety, but it's often much more significant than people realize because, again, it creeps up on you slowly and then all of a sudden it hits you quickly.

**中文翻译:**
在过去的两年里，我写了很多东西，大部分内容其实只是我敞开心扉，分享幕后发生的这些个人经历。在这个过程中，我已经联系到了数百名科技行业的人士，他们正在处理各种形式的职业倦怠，或者正在面对浮出水面的深层存在主义问题，并试图理解它们。
所以，根据我发布的一些调查、我个人的见闻（anecdotal experience），以及一些专注于企业家和高成就者福祉的专家所做的正式研究，我认为一个合理的估计是：至少 50% 到 60% 的科技从业者——更具体地说，是那些已经在岗位上（in the saddle）至少工作了五到七年的人——正在经历某种形式的心理和情感痛苦。这种痛苦可能轻微到让他们认为只是日常焦虑，但它往往比人们意识到的要严重得多，因为，我再说一遍，它会慢慢潜伏在你身上，然后突然猛烈地袭击你。

---

### (00:15:04) Andy Johns

**English:**
Yeah. So one of the things that I did towards the tail end of my career as I became a consumer or founding partner of the consumer arm of an early stage venture capital firm, and most folks know that especially once a fund gets big enough, it can be a high paying job. Suddenly, I found myself in a position where I was making high six figures per year into early seven figures. When I look back on it in retrospect, I had put in so much effort to get to that point really going back to when I was 10 years old, having always been the straight A student and captain of whatever team I was on.
From the age of 10 to basically 35, I was switched on, constantly seeking to perform at the top of whatever my field was. So I gotten to that point first as an executive at a high growth startup, that was Wealthfront, and I became president and was next in line to be CEO before I had a health scare with my heart that led to me stepping away from the company because I knew I couldn't take on the CEO position. Then here I was six or seven months later, again, very subconsciously driven by the desire to succeed because underneath that was the sense that I wasn't lovable unless I was succeeding.
Here I was after a heart attack scare at the age of 35 sweeping that under the carpet like I'd swept so much stuff under the carpet and choosing to join on as a founding partner of a venture capital firm, which is not an easy job at all, and especially when you're starting a new firm up, it's, in a lot of ways, it's a company in and of its own. So it was another startup. It was my sixth startup in a row.
So three years into that though, even though I was working on my own mental health and my emotional wellbeing, I had convinced myself repeatedly for so many years that everything was okay and that I could continue to put my head down and run through these walls, these professional walls and keep going, but it got to a point to where that was no longer the case.
In fact, it was the culmination of conversations with my doctors and with the experts that I've been working with where I ended up actually spending 45 days in a mental health institute myself. It was something that was extremely difficult to do. It was something that certainly contributed or was really the tip of the sphere of me stepping away from my career of realizing that the only reason I was continuing to push forward despite how poorly I felt on the inside was because of stuff that had happened to me when I was much younger and because of the fallible nature of the human mind and how it wants to interpret experiences and ways that can become so self-critical and self damaging.
So that happened for me roughly three years ago. Needless to say, my life has changed quite a bit since then, and I'm happy to chat more about that, but that was a difficult decision to walk away from my career at the peak of it, but I guess the takeaway, and then I'll stop for a bit, is it's important for people to understand that there are formative experiences in our lives which put us in positions to where we form adaptations in order to survive, just like my attachment to achievement and how my self-worth was entirely tied up in that.
I needed that when I was younger because I was heartbroken, I lost a parent, and that adaptation that I formed saved my life when I was young, and it gave me a great childhood after that, and a great next couple of decades, but these adaptations, if you're unaware of them and if you're unaware of the subconscious drivers that are responsible for them, they run the risk that they go too far, and that these adaptations, which were initially beneficial to you and to your life, they reverse course in a sense, and they become detrimental to your present state and your future development.
So my stepping away from the career, stepping away from the high salary, and stepping away from everything I'd worked so hard to obtain was an action that I took in recognition of the fact that that early life adaptation had now gone awry and was responsible for my life heading in a negative direction and it was time to change.

**中文翻译:**
是的。在我职业生涯的末期，我成为了一家早期风险投资公司消费部门的创始合伙人。大多数人都知道，尤其是当基金规模足够大时，这是一份高薪工作。突然间，我发现自己每年的收入从六位数高薪（几十万美元）涨到了七位数（百万美元以上）。回首往事，我为了达到那个高度付出了巨大的努力，这真的可以追溯到我 10 岁的时候，我一直是全 A 学生，无论在哪个队都是队长。
从 10 岁到基本上 35 岁，我一直处于“开启”状态，不断追求在任何领域都做到顶尖。我先是在一家高速增长的初创公司 Wealthfront 担任高管，后来成为总裁，并成为 CEO 的继任者。直到我的心脏出现了一次健康警告，这导致我离开了公司，因为我知道我无法承担 CEO 的职位。然而，六七个月后，在潜意识里对成功的渴望驱动下（因为在那之下，我觉得除非我成功，否则我不值得被爱），我又出发了。
在 35 岁经历心脏病惊魂后，我像以前掩盖很多事情一样，把它“扫到地毯下”掩盖起来，选择加入一家风险投资公司担任创始合伙人。这绝不是一份轻松的工作，尤其是当你创办一家新公司时，它在很多方面本身就是一家初创公司。所以那是我的连续第六家初创公司。
然而，在那工作了三年后，尽管我一直在关注自己的心理健康和情感福祉，但我多年来反复说服自己一切都好，我可以继续埋头苦干，冲破这些职业围墙继续前进。但到了一个点，情况不再是这样了。
事实上，在与我的医生和我一直合作的专家进行了一系列对话后，我最终在一家精神健康机构住了 45 天。这是一件极其困难的事情。这无疑促使我，或者说是让我意识到，我之所以在内心感觉如此糟糕的情况下仍继续推进，唯一的原因是年轻时发生在我身上的事，以及人类心智的脆弱性——它倾向于以一种自我批判和自我伤害的方式来解读经历。
那大约发生在三年前。不用说，从那以后我的生活发生了很大变化，我很乐意多聊聊。但在职业生涯巅峰时期选择离开是一个艰难的决定。我想我想表达的重点是（然后我会停一下）：人们必须理解，我们生命中会有一些性格形成期的经历，这些经历让我们为了生存而形成“适应机制”（adaptations），就像我对成就的执着，以及我的自我价值感完全与之捆绑在一起。
我年轻时需要这种机制，因为我心碎了，我失去了一位亲人。我形成的这种适应机制在我年轻时救了我的命，给了我之后美好的童年和接下来的二十年。但是，如果你没有意识到这些机制，没有意识到负责这些机制的潜意识驱动力，它们就有可能走得太远。这些最初对你和你的生活有益的适应机制，在某种意义上会反转方向，变得对你现在的状态和未来的发展有害。
所以，我离开职业生涯、离开高薪、离开我努力获得的一切，是我意识到早年的那种适应机制现在已经出了差错，并导致我的生活走向负面方向，是时候做出改变了。

---

### (00:20:52) Andy Johns

**English:**
Now, when people ask me what I do, I say I do mental health advocacy, and I do it in a few ways. One is I sit on the board of a nonprofit called Heroic Hearts Project, and what we do is we raise money so that we can pay for military veterans with PTSD to get access to alternative therapies, namely psychedelic assisted psychotherapy. It was started by a handful of veterans. I was lucky enough to meet a few of them a couple of years ago. Given my own personal experience with PTSD stemming from my childhood experiences, I was bonded together with these men and women of the Armed Forces who had, in many cases, not only their own personal trauma, but also war trauma. So that's one organization that I'm thankful to be able to work with and help out.
I also write my newsletter and have created a new website that I'm toying with. In general, my writing and the content that I've put out is focused on the unhappy achievers, the other folks like myself who are out there, which there's quite a few of us. I write in order to express my personal experience because I think there's many others that can relate. So those are the things that I've been working on and a little bit of coaching with some of the high performers as well.

**中文翻译:**
现在，当人们问我做什么时，我说我从事心理健康倡导工作，我通过几种方式来实现。一是我是非营利组织 Heroic Hearts Project 的董事会成员。我们的工作是筹集资金，以便为患有 PTSD（创伤后应激障碍）的退伍军人支付替代疗法的费用，即迷幻剂辅助心理治疗（psychedelic assisted psychotherapy）。这个组织是由几位退伍军人发起的。我有幸在几年前遇到了他们。鉴于我自己童年经历导致的 PTSD 个人经验，我与这些武装部队的男女军人们产生了共鸣，他们在许多情况下不仅有个人创伤，还有战争创伤。所以我很感激能与这个组织合作并提供帮助。
我还写自己的时事通讯，并创建了一个正在尝试的新网站。总的来说，我的写作和发布的内容都集中在“不快乐的成就者”（unhappy achievers）身上，也就是像我一样的其他人，我们这类人其实挺多的。我写作是为了表达我的个人经历，因为我认为还有很多人能产生共鸣。这些就是我一直在做的事情，另外还对一些高成就者进行了一些辅导。

---

### (00:22:23) Lenny

**English:**
Throw out the website in case people want to check it out while we're talking.

**中文翻译:**
把网站告诉大家吧，以防人们想在听我们聊天时去看看。

---

### (00:22:26) Andy Johns

**English:**
The website that I'm playing around with is called Clues.Life, clues as in questions, clues, not truth dot life or facts dot life. I called it Clues Dot Life for a reason because if there's one thing that I've learned in my own personal journey, it's that given the immense heterogeneity of the human population and how we're all born unique and then we're made further unique through our own individual life experiences, the thing that's clear to me is that if somebody is going through their own struggles, at the end of the day, they have to find the philosophies, the tools, and the methods that work for them.
You can read plenty of studies, you can read the books, you can listen to what others are doing, but at the end of the day, you got to personalize it to yourself. So that's why I called it Clues Dot Life because I'm building this library of mental health information that allows people to navigate all of this information in search of their own clues.

**中文翻译:**
我正在尝试的网站叫 Clues.Life，“clues”意为线索、疑问，而不是 truth.life（真理）或 facts.life（事实）。我叫它 Clues.Life 是有原因的：如果在我的个人旅程中我学到了一件事，那就是考虑到人类群体的巨大差异性（heterogeneity），我们生来独特，又通过各自的生活经历变得更加独特。对我来说很清楚的一点是，如果有人正在经历挣扎，最终他们必须找到适合自己的哲学、工具和方法。
你可以阅读大量的研究，可以看书，可以听别人在做什么，但最终，你必须将其个性化。这就是为什么我叫它 Clues.Life，因为我正在建立这个心理健康信息库，让人们能在这些信息中导航，寻找属于他们自己的“线索”。

---

### (00:23:47) Andy Johns

**English:**
I love this question. So most of the conversations I have are with folks who are going through significant change. Now, what's involved in that? It can happen on a spectrum where everyone's process is unique. We all change and unfold in identical ways. Some can go through subtle shifts. I've heard this referred to as a micro transition, where, for example, they may be working at a tech industry or at a tech company, but this specific company they're working at, they have no real values connection to it. So part of their suffering is the fact that they feel that the work that they're doing doesn't really matter or they don't feel a connection to it. So switching to work at a different company that's aligned with something that's consistent with their values, that may be enough for somebody to go through a small transition and then find themselves in a happier place.
The transitions that I talk about are the big fundamental ones like the transition that I've been going through myself. Now, what's involved in that? I think that there are four parts, just to give it a simple general framework. Step one is it begins with suffering. These large transitions in life rarely take place in the absence of suffering. So step number one is suffer. Usually, the deeper somebody suffers, the more significant the transition that may follow. There's a reason why in the 12 steps community like Alcoholics Anonymous, Narcotics Anonymous, you name it, there's a reason that rock bottom is in the vernacular because rock bottom tends to proceed somebody getting sober. So step one is suffering.
Step two is seeking the truth behind why we suffer. Once the suffering gets so bad in somebody through some spiritual intervention, a legal intervention, the intervention of friends and family, whatever it may be, they decide to change, and in order to change, you have to understand the truth as to who you are and why you are the way you are and why you're suffering. The answer lies in understanding the truth, and that is usually a long process. Digging through the subconscious mind, digging through your history and your past, digging through your relationships, that takes a lot of time. It takes a lot of time to remove the mental blocks that we might've spent decades developing such that we don't even see these patterns that we play out regularly.
So first, you begin with suffering, and then second, you seek the truth for your suffering. What I have found, and that leads to step three in the process, is that once you discover the truth of your suffering, the real root cause of it and where it came from, that's when you move to step three, which is you begin to experience and to practice self-compassion and self-love because inevitably, what you discover through this process of seeking the truth is that your suffering isn't necessarily your fault. Maybe you're suffering because of things that you experienced or had to go through of which you had no control over.
Nonetheless, it's common for the mind, especially the mind of a child, to interpret those less than nurturing experiences as, "This happened because of me." So what sits at the core of their suffering is not only a low sense of self, but a shame, a shame regarding who they are and who they believe themselves to be.
When you dig deep enough into your own self-understanding, eventually you'll discover that that's not true, that it isn't your fault, that these things swept you up like a wave, and you were just along for a ride of which you had no choice. When you understand that and you start to feel a sense of forgiveness and to begin to love yourself for the first time, you make this switch where then you're willing to live in a way that is more consistent with self-love and self-compassion.
So me, for example, stepping away from my career, at the end of the day, I wasn't running from something, I was running back towards myself. That was an act of kindness towards myself. Going into a 45-day hospitalization, that was an act of love. So what ends up happening is the truth fuels that process of self-love, and when you begin to live in a way that is consistent with valuing yourself and understanding that it's not your fault, then that's when you move to step four, which is compassion towards others because by understanding yourself and realizing the true nature of why you are the way you are and forgiving yourself because you understand it's not your fault, guess what? You see the same thing in everybody else.
This is what is meant when folks sometimes say we're all adults or we're all children walking around in adult bodies, right? We're just acting out the things that were done to us in the past because when I think of the human mind, there are many ways that you can describe what the brain is, but one way that I describe it certainly is that it's autobiographical. It tries to predict what's going to happen next based on what happened in the past. It's a prediction engine. That's what it does, and that's why I say it's autobiographical because the way that you present yourself to the world as an adult is a reflection of what happened to you in the past, the messages you were told, the ways you were conditioned by society, maybe the traumas you experienced.
So that's the process as I see it of deep, deep, deep transformation. It's that four-step process of the suffering, the seeking of truth, the living in a way that is compassionate towards oneself, and then living in a way that is compassionate towards others. When you do that, you change. Think of that as the horizontal foundation to which the rest of your external life is built. The place you choose to live, the partner you choose to have, the friends you have, the career you have, all of these things are erections on top of a foundation of identity, and that identity is what is completely rewired when somebody goes through that four-step process, and as a result, everything that's built on top of that identity, it doesn't necessarily have to change, but it might.

**中文翻译:**
我非常喜欢这个问题。我进行的大多数对话都是与那些正在经历重大改变的人。那么，这其中涉及什么呢？它是一个光谱，每个人的过程都是独特的。我们都以相同的方式改变和展开。有些人可能会经历微妙的转变。我听过这被称为“微转型”（micro transition），例如，他们可能在科技行业或科技公司工作，但他们工作的这家特定公司与他们的价值观没有真正的联系。所以他们痛苦的一部分在于，他们觉得所做的工作并不重要，或者感觉不到联系。因此，换到一家与自己价值观一致的公司工作，对于某些人来说，这可能足以完成一个小转型，然后发现自己处于一个更快乐的状态。
我所说的转型是那些重大的、根本性的转型，就像我自己一直在经历的那种。那么，这涉及什么呢？我认为有四个部分，可以给出一个简单的通用框架。
第一步：始于受苦（suffering）。生活中这些重大的转型很少在没有痛苦的情况下发生。所以第一步是受苦。通常，一个人受苦越深，随之而来的转型就越重大。这就是为什么在匿名戒酒会（AA）、匿名戒毒会（NA）等“十二步疗法”社区中，“跌入谷底”（rock bottom）是一个常用词，因为跌入谷底往往是戒除成瘾的前奏。所以第一步是受苦。
第二步：寻求痛苦背后的真相。当一个人的痛苦变得如此糟糕，通过某种精神干预、法律干预、亲友干预或其他任何方式，他们决定改变。为了改变，你必须了解关于你是谁、你为什么是现在这样、以及你为什么受苦的真相。答案在于理解真相，这通常是一个漫长的过程。挖掘潜意识，挖掘你的历史和过去，挖掘你的人际关系，这需要很多时间。消除我们可能花了数十年建立的心理障碍需要很多时间，以至于我们甚至看不见自己经常表现出的这些模式。
所以，首先你从受苦开始，其次你为你的痛苦寻求真相。我发现，这会引向过程中的第三步：一旦你发现了痛苦的真相、真正的根源以及它从何而来，你就会进入第三步，即开始体验并练习自我慈悲（self-compassion）和自我爱护。因为不可避免地，通过寻求真相的过程，你会发现你的痛苦并不一定是你的错。也许你受苦是因为你经历过或不得不面对的一些你无法控制的事情。
尽管如此，人类的心智，尤其是孩子的心智，通常会将那些缺乏养育的经历解读为：“这件事发生是因为我不好。”所以，他们痛苦的核心不仅是低自我感，还有羞耻感——一种对自己是谁以及自己认为自己是谁的羞耻感。
当你对自我的理解挖掘得足够深时，最终你会发现那不是真的，那不是你的错，这些事情像浪潮一样席卷了你，你只是身不由己地随波逐流。当你理解了这一点，并开始感受到一种宽恕感，并第一次开始爱自己时，你就完成了这个转变，然后你愿意以一种与自爱和自我慈悲更一致的方式生活。
以我为例，离开我的职业生涯，归根结底，我不是在逃避什么，我是在跑回自己身边。那是对自己的一种仁慈行为。进入 45 天的住院治疗，那是一种爱的表现。所以最终发生的是，真相驱动了自爱的过程，当你开始以一种重视自己并理解这不是你的错的方式生活时，你就进入了第四步：对他人的慈悲。因为通过理解自己并意识到你为什么是现在这样的真实本质，并因为理解这不是你的错而原谅自己，猜猜怎么着？你在其他人身上也看到了同样的东西。
这就是人们有时说的“我们都是成年人”或“我们都是行走在成年人身体里的孩子”，对吧？我们只是在演练过去对我们做过的事情。因为当我想到人类心智时，描述大脑的方式有很多，但我描述它的一种方式肯定是：它是“自传式”的。它试图根据过去发生的事情来预测接下来会发生什么。它是一个预测引擎。这就是它的功能，这就是为什么我说它是自传式的，因为你作为一个成年人向世界展示自己的方式，是你过去经历的反映——你听到的信息、社会对你的制约、也许还有你经历过的创伤。
所以这就是我所看到的深层、深层、深层转型的过程。它是受苦、寻求真相、以对自己慈悲的方式生活、然后以对他人的慈悲的方式生活的四步过程。当你这样做时，你就改变了。把这看作是你外部生活其余部分赖以建立的水平地基。你选择居住的地方、你选择的伴侣、你的朋友、你的职业，所有这些都是建立在身份地基之上的建筑。当一个人经历这四个步骤的过程时，那个身份会被完全重构。结果，建立在那个身份之上的所有东西不一定非要改变，但它们可能会改变。

---

### (00:31:41) Lenny

**English:**
That feels like a reason somebody wouldn't want to go down this journey of, "I don't want to change everything about myself."

**中文翻译:**
这听起来像是一个人不想踏上这段旅程的原因：“我不想改变关于我自己的一切。”

---

### (00:31:48) Andy Johns

**English:**
Yes, and this is the power of the human mind at work or what someone referred to as the ego. As soon as the ego senses that something wants to challenge it and to undermine its authority, it finds a way to push it away. It finds a way to ignore it because it is a very difficult process. I now understand what some philosophers described as death before dying. In this process of change that I've been going through, it's been the death of the old me, the death of Andy whose identity was entirely attached to succeeding, and that old Andy doesn't want to let go. It's been around for a few decades. It believes that it's there to protect me.
This is a survival mechanism that's somewhat gone awry within the context of modern life. So it doesn't want to let go, but that's what I've been doing. That's the process I've been going through is slowly but surely finding a way to take my fingers off the steering wheel and to let that old sense of self die, and then in doing so create the room for what's next, whatever that may be. I'm three years into the process of discovering what that will be. So we'll see.

**中文翻译:**
是的，这就是人类心智运作的力量，或者有人称之为“小我”（ego）。一旦小我感觉到有什么东西想要挑战它并削弱它的权威，它就会想方设法把它推开。它会想方设法忽视它，因为这是一个非常艰难的过程。我现在理解了一些哲学家所说的“死前的死亡”。在我经历的这个改变过程中，那是“旧我”的死亡，是那个身份完全依附于成功的 Andy 的死亡。那个旧的 Andy 不想放手。它已经存在了几十年，它认为它的存在是为了保护我。
这是一种在现代生活背景下有些失控的生存机制。所以它不想放手，但这正是我一直在做的。我经历的过程就是缓慢而坚定地找到一种方法，把手指从方向盘上拿开，让那种旧的自我感死去，从而为接下来的事情创造空间，无论那是什么。我正处于发现那将是什么的过程中的第三年。所以，拭目以待吧。

---

### (00:33:45) Andy Johns

**English:**
I think you're pretty spot on with it. This dips into a lot of the ancient Eastern spiritual traditions of just this recognition that life involves suffering. One way or another, there's going to be suffering. I think of it as there's two types of suffering. There's the necessary suffering like we're going to get old and our bodies are going to hurt and we're going to have physical ailments and toothaches and shit's just going to happen and we're going to lose the people we love, all of us, and the 80 to a hundred billion homo sapiens that live before us gone through the same thing.
So there is necessary suffering in life or the mandatory suffering, and then there's the unnecessary suffering, which is the suffering that is almost entirely, and I think the argument could be made that it's entirely made up in our minds. This is the superpowers of the human mind gone awry again in the modern context. So there's going to be a lot of suffering one way or another. I think if there's a goal or objective, it's to minimize the unnecessary suffering, but the seeking of the truth part is very difficult. It takes years.
There's a reason that, again, in some of these spiritual traditions, let's take Buddhism for example, there's a reason that there's so much structure and discipline and there's a daily method that they adhere to because it turns out it takes daily practice. In the same way that if you want to get extremely fit and climb Mount Everest, that's not something you do by just getting off the couch, right? It takes a dedication to it. I think that the seeking of truth takes that dedication, and that's, again, why I believe that the first step is almost always suffering because to undergo that process of personal transformation, which can be very difficult, and it can feel like you're in a life raft and you've just pushed away from the shore completely untethered, uncertain of where you're floating. In order to work up the courage to get to that point, things typically have to get pretty bad.
You say, "I can't fucking do this anymore. I'm not going to live like this. Something's got to change." So much of that seeking of the truth is actually at first driven by intense fear, fear of going back to how bad things were and feeling that bad again. Eventually, the process changes tone when you move past the fear stage and you understand yourself enough and then you start to look forward optimistically towards the future, where instead of just being driven by fear, you're also pulled forward by a vision for the future that inspires you. So that eventually comes, but to begin with, yes, this process of discovering the truth is very, very, very, very difficult. It requires a personal commitment. It's not something anyone else can do for you.

**中文翻译:**
我觉得你说得很准。这涉及许多古代东方精神传统，即承认生命包含苦难。无论如何，苦难总会存在。我认为有两种苦难：一种是“必要的苦难”，比如我们会变老，身体会疼痛，会有病痛、牙痛，破事总会发生，我们会失去所爱的人，我们所有人，以及在我们之前生活过的 800 亿到 1000 亿智人都经历过同样的事情。
所以生活中存在必要的苦难或强制性的苦难。然后是“不必要的苦难”，这种苦难几乎完全——我认为甚至可以争论说是完全——是由我们的头脑虚构出来的。这是人类心智的超能力在现代语境下再次失控的结果。所以无论如何都会有很多苦难。我认为如果有一个目标，那就是尽量减少不必要的苦难。但“寻求真相”的部分非常困难，需要数年时间。
这就是为什么，再次以某些精神传统为例，比如佛教，为什么会有那么多的结构和戒律，以及他们坚持的日常方法，因为事实证明这需要每天的练习。就像如果你想变得极其强壮并攀登珠穆朗玛峰，那不是你从沙发上站起来就能做到的，对吧？这需要全身心的投入。我认为寻求真相也需要这种投入。这就是为什么我相信第一步几乎总是受苦，因为要经历个人转型的过程是非常困难的，感觉就像你在救生筏上，刚刚推离岸边，完全没有束缚，不知道自己漂向何方。为了鼓起勇气达到那个点，情况通常必须变得非常糟糕。
你会说：“我他妈再也受不了了。我不能再这样生活了。必须做出改变。”寻求真相的过程在很大程度上最初是由强烈的恐惧驱动的——害怕回到过去那种糟糕的状态，害怕再次感到那种痛苦。最终，当你度过恐惧阶段并足够了解自己，然后开始乐观地展望未来时，这个过程的基调就会发生变化。那时，你不再仅仅被恐惧驱动，而是被一个激励你的未来愿景所吸引。这最终会到来，但首先，是的，发现真相的过程非常、非常、非常困难。它需要个人的承诺，这不是别人能为你做的。

---

### (00:37:40) Andy Johns

**English:**
Commonly in the West, the first step that makes a lot of sense is you turn to somebody who's trained in helping you figure out what those truths are, which is a therapist or a psychologist or a psychiatrist or a counselor. Sometimes people turn to religious or spiritual leaders because they can be quite gifted in this as well. That's the most common step.
That's the first step that I turn to when I was just completely stricken by panic and terrified that I might harm myself. I said, "I got to figure out what the hell's going on because I can't live feeling like this," and all I knew to do was reach out to a therapist, and that is a wonderful first start because if anything, they're not going to have all the answers, but they can act like a router, where as they're helping you understand yourself and they're really understanding you, they're thinking about, "Okay. Who might this person also benefit from speaking with? Let's route them to this person that specializes in body-based work, somatic work. Let's send this person to somebody that specializes in nervous system management through breath work or other things." So seeking a therapist is a pretty good first step.

**中文翻译:**
在西方，通常很有意义的第一步是向受过训练的人寻求帮助，帮你看清那些真相，比如心理治疗师、心理学家、精神科医生或咨询师。有时人们也会求助于宗教或精神领袖，因为他们在这些方面也很有天赋。这是最常见的一步。
这也是我采取的第一步，当时我完全被恐慌击垮，害怕自己会伤害自己。我说：“我必须弄清楚到底发生了什么，因为我不能这样生活下去。”我唯一知道的就是联系心理治疗师。这是一个极好的开始，因为即使他们没有所有的答案，他们也可以像一个“路由器”一样。当他们帮助你了解自己并真正理解你时，他们会想：“好吧，这个人还可能从与谁的交谈中获益？让我们把他们引向专门从事身体工作、躯体化工作（somatic work）的人。让我们把这个人送到专门通过呼吸法或其他方法进行神经系统管理的人那里。”所以，寻找心理治疗师是一个非常好的第一步。

---

### (00:39:13) Andy Johns

**English:**
It's like speed dating at first because I would argue that the most important factor is that you feel safe. Animals can teach us so much about what it means to heal ourselves. Imagine going to the pound and you go in there and there's a bunch of dogs that have been picked up off the street or that have been abandoned, and the vast majority of them, they're a nervous wreck, right? Their tail is down in between their legs. They're hunched over and they might be shaking. Their nervous system is completely overwhelmed. That is not the time to teach a dog tricks. When the dog still can't come out the corner of the kennel is not the time to teach it how to sit. Once that dog can make it into the arms of an owner that it feels safe with and loved by, that's when you see the dog transform and change, and that's when you can teach it a lot because it's open and receptive to it.
So that's number one in my advice is speed date if you've got the opportunity to and try out a few therapists and just go based on intuition, what just feels right to you, and you're going to want to fall into that feeling of comfort. Now, a quick asterisk on that. Of course if you're in real distress, if you're in a bad place, just see whatever professional you can as soon as possible. That's what I did. I was fortunate to where the first one that I saw was also fantastic. I ended up seeing many other specialists over the years, but that first one, she was wonderful.
So it's essential that you feel comfortable with them. I would also say, this one's a little controversial, but you're going to want a therapist that is at least as intelligent, if not more intelligent than you because I think part of that openness to learning from them and to feeling somewhat comfortable but also feeling inspired and looking forward to it as if sometimes they say things that make you say, "Oh, shit. Wow. Wow, I never thought of that. That was smart," or, "That was a wonderful insight." I don't think if you respect their intellectual abilities, then it's going to be difficult for them to help you. They may not be able to communicate on the same wavelength. So you really want to look for that intuitive feeling of something that is safe and comfortable. Ideally, if you can find somebody with some intellectual horsepower that matches your own, honestly, I think the rest after that is just implementation details.

**中文翻译:**
起初这就像快速约会，因为我认为最重要的因素是你感到安全。动物可以教会我们很多关于自我疗愈的知识。想象一下去流浪狗收容所，那里有一群从街上捡回来或被遗弃的狗，绝大多数都处于精神崩溃状态，对吧？它们的尾巴夹在两腿之间，蜷缩着，可能还在发抖。它们的神经系统完全崩溃了。那时候不是教狗把戏的时候。当狗还不敢走出犬舍角落时，不是教它如何坐下的时候。一旦那只狗能投入到一个让它感到安全和被爱的主人怀抱中，你就会看到这只狗发生转变和改变，那时你可以教它很多东西，因为它变得开放且乐于接受。
所以我的第一条建议是：如果有机会，可以进行“快速约会”，尝试几个治疗师，凭直觉行事，看哪个感觉对。你会想要沉浸在那种舒适感中。当然，这里要加个注脚：如果你处于真正的痛苦中，处于非常糟糕的状态，请尽快去看任何你能找到的专业人士。我当时就是这么做的。我很幸运，我看到的第一个治疗师就非常棒。这些年来我看了很多其他专家，但第一个她真的很棒。
所以，你感到舒适是至关重要的。我还想说一点，这可能有点争议，但你会想要一个至少和你一样聪明、甚至比你更聪明的治疗师。因为我认为，向他们学习的开放心态、感到舒适、以及感到受启发并期待交流，部分源于他们有时说的话会让你感叹：“噢，天哪。哇。哇，我从未想过这一点。这太聪明了，”或者“这是一个极好的见解。”如果你不尊重他们的智力水平，他们就很难帮助你。他们可能无法在同一个波长上交流。所以你真的要寻找那种安全、舒适的直觉。理想情况下，如果你能找到一个智力水平（intellectual horsepower）与你匹配的人，老实说，我认为剩下的就只是执行细节了。

---

### (00:42:23) Andy Johns

**English:**
Absolutely. Absolutely. If you're not in a state of distress, but you feel like there's something to be figured out, there's an ancient technology known as pen and paper. At the end of the day, the seeking of the truth involves the seeking of a deep sense of self-understanding, and if you can get into the daily practice of being able to sit down with pen and paper and write to yourself, to ask yourself questions, to really sit there and evaluate the thoughts that are running through your head, it is possible for somebody to, and I'll use the term, I won't get into it, but to reach some state of bliss or enlightenment or some real spiritual awakening, it is possible for somebody to do that entirely on their own with just pen and paper and a quiet room.
I know people that have arrived at a deep place of self-love and self-understanding through those methods, and I know a lot of others, including myself, where the writing to others was really the writing to myself 15 years ago as a way for me to continue to understand myself more deeply. So I think pen and paper is deeply, deeply overlooked and underrated in this process.

**中文翻译:**
绝对是这样。如果你没有处于极度痛苦中，但觉得有些事情需要弄清楚，有一种古老的技术叫做“纸和笔”。归根结底，寻求真相涉及寻求深度的自我理解。如果你能养成每天坐下来用纸笔给自己写信、问自己问题、真正坐在那里评估脑海中闪过的想法的习惯，一个人是有可能——我会用这个词，虽然不深入展开——达到某种极乐、启蒙或真正的精神觉醒状态的。一个人完全有可能仅凭纸笔和一间安静的房间就做到这一点。
我知道有人通过这些方法达到了深度自爱和自我理解的境界。我也知道很多其他人，包括我自己，向他人写作实际上是在向 15 年前的自己写作，作为我继续深入了解自己的一种方式。所以我认为纸和笔在这个过程中被严重忽视和低估了。

---

### (00:43:58) Andy Johns

**English:**
Yeah. There are different ways of doing it. Some advocate for a completely unstructured approach because what you want is you don't want to turn it into assignment. You want to feel your way into it. If something is bubbling up in your mind, just spit it out. Don't analyze why it's coming up, just allow it to flow. That method certainly works. Sit down with no agenda. On some days you'll write one sentence and that's enough, and on other days you'll write 10 pages and that's also enough. There's some magic to allowing the human mind to just work and to not interrupt it through some analytical process.
On the flip side, if you want a little bit more structure, one thing you can do is I'd like to start with if the goal is to understand oneself, then one of the quickest ways of doing that is to quickly write down a list of simple bullet points of the most recent situations you can think of where you became most acutely reactionary and emotional. You could have been having a political conversation with somebody and they said something that really just you felt like you just wanted to reach out and strangle them. You could have felt deeply insecure in a social setting.
Just run through those scenarios where something disrupted what might've been your current state of presence and calmness. When you identify those situations where there was some strong reaction, that is very revealing because that wasn't a conscious thought process that led to the reaction. That was a knee-jerk reaction. That was a reflex. If there's a reflex, then there's something that's underlying the reflex, and the question to then ask is, "Why did that happen?"
Then from there, it's an unstructured process. Keep asking, keep digging, keep asking, "Okay. If this happened, why did that happen? Well ..." and then write a little bit, "Well, is that really the reason why? Was there something else?" Just keep working at it until you hit the truth, and you'll know what the truth is because it always feels either deeply uncomfortable or it feels like an epiphany.

**中文翻译:**
是的。有不同的方法。有些人主张完全非结构化的方法，因为你不想把它变成一项任务。你想凭感觉进入状态。如果脑子里冒出什么东西，就把它吐出来。不要分析它为什么出现，就让它流淌。这种方法肯定有效。坐下来，不带任何议程。有些日子你只写一句话，那也够了；有些日子你写 10 页，那也够了。让人的心智自然运作而不通过某种分析过程去打断它，这其中有一种魔力。
另一方面，如果你想要多一点结构，你可以做的一件事是——如果目标是了解自己，那么最快的方法之一就是快速写下一份简单的要点清单，列出你能想到的最近你反应最激烈、情绪最激动的时刻。你可能正在和某人谈论政治，他们说了一些让你简直想伸手掐死他们的话。或者你可能在社交场合感到深深的不安全感。
回顾一下那些打破了你原本平静状态的场景。当你识别出那些产生强烈反应的情况时，那是非常有启发性的，因为导致那种反应的不是有意识的思考过程。那是一种本能反应（knee-jerk reaction），一种反射。如果有反射，那么反射之下一定隐藏着什么，接下来的问题就是：“为什么会发生那种情况？”
然后从那里开始，就是一个非结构化的过程。不断追问，不断挖掘，不断问：“好吧，如果发生了这件事，为什么会发生？嗯……”然后写一点，“嗯，那真的是原因吗？还有别的吗？”一直努力下去，直到你触及真相。你会知道真相是什么，因为它要么让你感到极度不适，要么让你感觉像是一次顿悟。

---

### (00:46:32) Andy Johns

**English:**
There were many parts of it. At its core, at first it began with a simple truth, which was I went into the therapist, I was describing what I was feeling, I was describing the uncontrollable thoughts and mental imagery that I was experiencing, and my sleep disruption, and my pounding heart, and everything else, and she said, "Yup, you're having panic attacks," and just knowing like, "Oh, there's a thing and it's called a panic attack," starting at that basic truth was enough in the moment to just take a little bit of the edge off.
So this journey along the way is there are dozens of truths and then hundreds of truths, and then every now and then it's punctuated by the big, "Oh, holy shit. I never saw that coming," kind of truth. It's just what the experience is. I had many, many truths about myself that I discovered before I hit some of the fundamental ones that were at the core of my subconscious.

**中文翻译:**
这包含很多部分。核心上，起初它始于一个简单的真相：我去看治疗师，描述我的感受，描述我正在经历的无法控制的想法和心理意象，还有我的睡眠障碍、心跳加速等等。她说：“是的，你正在经历惊恐发作（panic attacks）。”仅仅知道“噢，有这么个东西叫惊恐发作”，从这个基本事实开始，在当时就足以稍微缓解一下压力。
所以这一路走来，会有几十个真相，然后是几百个真相，然后时不时会被一个重大的真相打破，那种“噢，天哪，我完全没料到”的真相。这就是这种经历的本质。在触及潜意识核心的那些根本真相之前，我发现了很多很多关于自己的真相。

---

### (00:48:09) Andy Johns

**English:**
There are day-to-day stresses that are normal and we just have to put up with, but then there's the other stuff that's the flashing red alarm. For me, and a lot of the research and literature supports this too, is, again, you can go back to animals. It's like when their fundamental functions, when their core behaviors of diet, exercise, playfulness, socialization, sleep, when those things get disrupted, it's a sign that there is something going on here that you need to take a look at.
So the same is true with people. If your sleep always sucks, if your relationships are constantly strained or frequently strained, if your physical health is failing, there's so many ways that that can be measured so there's really no excuse for that to say, "Oh, I just didn't know," I'd say it's to look at those things. When those are suffering or when they're really out of whack, it's undeniable that there is something that is detrimental to your wellbeing that's going on right now, and your body is telling you, "Stop. Something needs to change." So that is number one to look at. Look at the fundamentals.
Reflecting on my own situation, I almost had a heart attack at 35, and I got the classic talk from a Stanford cardiologist saying, "You're just going to be another 40-something-year-old CEO with a broken heart." The years of really poor sleep, the number of teeth that I had broken that I had to have fixed multiple times because for years my grinding was so bad that I had to, now two times over, had to completely redo all the teeth, all my molars, and then most of the front teeth as well, and I just continued to move forward even though my body was, again, throwing out all the signals.
For anyone who's listening to this, especially for the folks who haven't, go get the book, The Body Keeps the Score by Bessel van der Kolk. He's a expert clinician who's worked with trauma patients for decades, and the entire book is basically one big message saying, "Hey, when mental health presents itself, look to the body because it's the body that is keeping the score." It's the body that's the scoreboard, and it's the body that is actually holding on to all of this shit you've been carrying for years, and eventually, the body breaks in the form of chronic disease and illness and so on and so forth.

**中文翻译:**
日常压力是正常的，我们必须忍受，但还有另一种情况，那是闪烁的红色警报。对我来说，很多研究和文献也支持这一点，那就是：再次回到动物身上。就像当它们的基本功能，当它们关于饮食、运动、玩耍、社交、睡眠的核心行为被打乱时，这就表明出了一些你需要关注的问题。
人也是一样。如果你的睡眠一直很糟糕，如果你的关系经常处于紧张状态，如果你的身体健康正在衰退，这些都是可以衡量的，所以真的没有理由说：“噢，我只是不知道。”我会说，去看看这些指标。当这些方面出现问题或严重失衡时，不可否认，现在正发生着一些损害你福祉的事情，你的身体在告诉你：“停下来。有些事情需要改变了。”所以这是首要关注点：看基本面。
反思我自己的情况，我在 35 岁时差点心脏病发作，我听到了斯坦福大学心脏病专家的经典谈话，他说：“你只会成为另一个 40 多岁、心碎的 CEO。”多年极差的睡眠，我咬碎的牙齿数量——我不得不修复多次，因为多年来我的磨牙非常严重，以至于我现在已经两次彻底重做了所有的牙齿，所有的臼齿，以及大部分门牙。尽管我的身体一直在发出所有信号，我却依然继续前进。
对于正在听这段话的人，尤其是还没读过的人，去买 Bessel van der Kolk 写的《身体从未忘记》（The Body Keeps the Score）这本书。他是一位与创伤患者打了几十年交道的专家临床医生，整本书基本上就是一个巨大的信息，在说：“嘿，当心理健康问题出现时，看看身体，因为是身体在记录一切（keeping the score）。”身体就是记分牌，身体实际上承载了你多年来背负的所有烂事，最终，身体会以慢性病、疾病等形式崩溃。

---

### (00:51:12) Lenny (Sponsorships)

**English:**
Today's episode is brought to you by Miro, an online collaborative whiteboard that's designed specifically for teams like yours. The best way to see what Miro is all about and how it can help your team collaborate better is not to listen to me talk about it, but to go check it out for yourself. Go to miro.com/lenny. With the help of the Miro team, I created a super cool Miro board with two of my own favorite templates, my one pager template and my managing up template that you can plug and play and start using immediately with your team. I've also embedded a handful of my favorite templates that other people have published in the Miroverse. When you get to the board, you can also leave suggestions for the podcast, answer a question that I have for you, and generally just play around to get a sense of how it all works.
Miro is a killer tool for brainstorming with your team, laying out your strategy, sharing user research findings, capturing ideas, giving feedback on wireframes, and generally just collaborating with your colleagues. I actually used Miro to collaborate with the Miro team on creating my own board, and it was super fun and super easy. Go check it out at miro.com/lenny. That's M-I-R-O dot com slash Lenny.

**中文翻译:**
今天的节目由 Miro 赞助，这是一个专门为像你们这样的团队设计的在线协作白板。了解 Miro 到底是什么以及它如何帮助你的团队更好协作的最佳方式，不是听我在这里说，而是亲自去看看。访问 miro.com/lenny。在 Miro 团队的帮助下，我创建了一个超级酷的 Miro 看板，里面有两个我最喜欢的模板：我的“一页纸模板”和我的“向上管理模板”，你可以即插即用，立即开始与你的团队一起使用。我还嵌入了一些其他人在 Miroverse 中发布的我最喜欢的模板。当你进入看板时，你还可以为播客留下建议，回答我向你提出的问题，或者只是随便玩玩，感受一下它是如何运作的。
Miro 是一个与团队进行头脑风暴、制定战略、分享用户研究结果、捕捉想法、对线框图提供反馈以及与同事协作的绝佳工具。我实际上就是用 Miro 与 Miro 团队合作创建了我自己的看板，过程非常有趣且简单。去 miro.com/lenny 看看吧。即 M-I-R-O.com/Lenny。

---

### (00:52:56) Andy Johns

**English:**
It's likely this deeply internalized self-belief. You can think of that as one of the deepest grooves in the neural pathways in your mind. Now, that was the case for me, so deep that you don't even realize that it's there, it's omnipresent. It's going to take time to rewire that because what you're effectively trying to do is take an internal narrative and edit and rewrite that thing, and this internal narrative is probably at a foothold in you for years or decades. So it's reasonable to believe or to understand that, "Okay. If I have not had a high opinion of myself for 30 years, that's not going to change overnight."
For some people, it miraculously does. That's not the norm. For most others, including myself, it starts with that truth stage because with truth is the awareness, "Okay. I understand that I have a low sense of self-worth, and I understand that it plays out in all these ways, and I have the awareness of it that now when I'm doing something that is a conditioned behavior or a conditioned response born out of that deep self-belief or that negative core belief, then when I spot it, there's an opportunity for me to intervene," and it starts in the simple ways.
For example, I had a boss once where he would come over and he would give me praise all the time. He was wonderful human being, and I think I was doing a good job. One day, he swung by, he said, "Hey, amazing job," and my response was, "Oh, yeah, I did my best," and then he looked at me and he said, "Hey, say thank you or you're welcome. That's it. When somebody gives you a compliment, just say thanks, accept it." So it's become a pattern of mine now that if somebody gives me a compliment, I look them in the eyes and I say, "Thank you," and I really try and embrace that little moment because it's in all of those ways where you identify these little patterns, you intercept them, and you choose to make a change to how you're conditioned to behave in that moment. If you do that consistently enough and you keep practicing it, and you keep it up every day, then you're developing a new internal narrative through all those little actions, and it accumulates in ways that are pretty powerful.
Every now and then, there's things that you can do that are more of a brute force method of driving that home. Some may find it through a Vipassana retreat, a seven to 10-day silent retreat, which is agonizing if folks haven't tried to be that quiet that long. Things bubble up, you confront the stuff in your mind that in our day-to-day, it's easy to just keep it under the hood. Some find that through psychedelics. Some find that through somewhat extreme physical feats.
There was a period in time where I didn't realize this at the time, but not only was I building my career, but I was running ultra marathons. Looking back at that I was like, "Yeah, there I was, another desperate attempt to feel worthy," but I also recognize now that that was medicine for me, that me going out onto a remote mountain range for five hours every Saturday and just running well beyond the point of discomfort was consistently cathartic for me. I would cry at the end of almost every single one of those runs. So it's just a recap. It's in those little moments and sometimes in those big moments too, but it begins with the awareness based on truth and then the daily practice.

**中文翻译:**
这很可能是一种深度内化的自我信念。你可以把它看作是你大脑神经通路中最深的沟壑之一。对我来说就是这样，深到你甚至意识不到它的存在，它无处不在。重新布线需要时间，因为你实际上是在试图获取一段内部叙事，并编辑、重写它。而这段内部叙事可能已经在你心中占据了几年甚至几十年。所以，去相信或理解这一点是合理的：“好吧，如果我 30 年来对自己评价都不高，那不可能一夜之间改变。”
对某些人来说，奇迹般地改变了。但那不是常态。对于包括我在内的大多数人来说，它始于“真相”阶段。因为有了真相，就有了觉察：“好吧，我明白我的自我价值感很低，我明白它以所有这些方式表现出来。我现在觉察到了，当我做出某种基于那种深层自我信念或负面核心信念的条件反射行为或反应时，当我发现它时，我就有机会干预。”这从简单的方式开始。
例如，我曾经有一个老板，他总是过来表扬我。他是一个很棒的人，我想我当时工作做得不错。有一天，他走过来，说：“嘿，做得太棒了。”我的回答是：“噢，是的，我尽力了。”然后他看着我说：“嘿，说‘谢谢’或‘不客气’。就这样。当有人给你赞美时，就说谢谢，接受它。”所以现在这成了我的一个模式：如果有人赞美我，我会看着他们的眼睛说“谢谢”，并努力拥抱那一刻。因为正是通过这些方式，你识别出这些小模式，拦截它们，并选择改变你在那一刻被制约的行为方式。如果你坚持这样做，每天练习，那么你就在通过所有这些小动作建立一个新的内部叙事，它会以非常强大的方式积累起来。
偶尔，你也可以采取一些更“暴力破解”（brute force）的方法来强化这一点。有些人可能会通过内观（Vipassana）静修——一种 7 到 10 天的禁语静修，如果人们没试过保持那么久的安静，那是非常痛苦的。事情会浮现出来，你会面对脑子里那些在日常生活中很容易被掩盖的东西。有些人通过迷幻剂找到这种感觉，有些人通过某种极端的体力挑战找到。
有一段时间，我当时并没意识到，我不仅在建立事业，还在跑超级马拉松。回想起来，我觉得：“是的，那是另一次为了感到自己有价值而进行的绝望尝试。”但我现在也意识到，那对我来说是良药。每个周六去偏远的山脉跑五个小时，跑出远超不适感的程度，对我来说是一种持续的情绪宣泄（cathartic）。几乎每次跑步结束我都会哭。所以总结一下：它存在于那些微小的时刻，有时也存在于重大的时刻，但它始于基于真相的觉察，然后是每日的练习。

---

### (01:02:46) Andy Johns

**English:**
Again, it's a spectrum. What I've experienced is that the vast majority of people who feel some tug to undergo a process of change, I'd say 90%, 95% of the time pretty confidently I can say that those changes are more of the micro transitions. It's, "Okay. Let me change my job. Let me downsize my house. Let me break up with my partner." Still hard things, and for them, that may be all that is needed and necessary. There's no moral judgment on my side about everyone's got to dive into the deep end. That's certainly not the case, and I'm not advocating for it. I honestly don't even know if it's a choice. There's a part of me that, based on some of the experiences I've had, believes that it was somewhat preordained and that this was going to happen for me, but it's in the minority of cases where the radical transformation of one's sense of identity takes place. It's not common. My general sense is it's definitely less than 1% of the population, and I suspect that's just the way things are.

**中文翻译:**
再说一次，这是一个光谱。我的经验是，绝大多数感到有动力去经历改变过程的人，我敢说 90% 到 95% 的情况下，那些改变更多是“微转型”。比如，“好吧，让我换个工作。让我换个小点的房子。让我和伴侣分手。”这些仍然是困难的事情，对他们来说，这可能就是全部所需和必要的。我这边没有任何道德评判说每个人都必须跳进深水区。事实并非如此，我也不是在提倡这样做。老实说，我甚至不知道这是否是一种选择。基于我的一些经历，我内心有一部分相信这在某种程度上是冥冥之中注定的（preordained），这注定会发生在我身上。但在少数情况下，一个人的身份感会发生彻底的转变。这并不常见。我的总体感觉是，这绝对不到人口的 1%，我怀疑事实就是这样。

---

### (01:06:20) Andy Johns

**English:**
A significant thing that holds people back from change is the inertia of civilization because we all experience a fundamental conflict in our life because when we're born, we have many needs, but there are two substantial needs that are immutable in everyone, especially children. The first need is the need for love, acceptance, and connection for mammals. We have one of the longest gestation periods of the entire animal kingdom, and even when we're born, we're helpless, we can't survive. We need nurturing for many, many more years afterwards in order to survive.
That goes hand-in-hand with our need for connection. So we're biologically hardwired to need to be accepted and connected because it is perhaps the most essential thing to survival, more essential than water. So we're born with that need. Yet at the same time, we're also born as unique individuals.
I read a study where the scientists estimated the probability that two sperm or two egg would be genetically identical. For context, I think the average man generates in their prime somewhere around between 10 to 100 million sperm a day. So we generate a lot of sperm in our lifetime. The math that they came up with was that the probability of two sperm being identical is roughly 10 to the 15th power, which is a million times greater than the number of stars in the Milky Way galaxy. There's somewhere between 100 to 400 billion stars in the galaxy. So it's a million times greater than that. So all that is to say is when you were born, you were unique. There's never been a you before ever, and it's going to be a really, really long time or another dimension before another one of you shows up again.
Then further through the socialization of life, we all have unique experiences, and those experiences are passed through this unique prism of our own mind and genetics to where we're further accentuated as individuals. So we're born with this fundamental need to be connected and to be loved, but we're also born with this need to be ourselves and to express ourselves. What ends up happening though is the world that you're born into eventually conditions you away from the unique individual that you were, and that is the function of society.
Society operates because enough people choose to agree on the same beliefs and ideas around the style of education, of raising children, of city planning, of millions of things. So the substrate of society or the adhesive of it is shared belief. So that's why I say the inertia of civilization or I should have said the inertia of society is because you're born into a world that begins to condition you at a very early age to act a certain way and not act a certain way, believe some things and don't believe others.
Why am I a San Francisco Giants fan? Well, because I grew up in a Giants family. It's not like I was two years old and I picked the Giants. It doesn't work that way. What ends up happening then is, and this begins, again, really young. You're two, three, four, five years old and the world around you, namely the adults in the world, start telling you who to be, and it begins to challenge or run into conflict with that individuality, but because our fear of not being accepted and loved is so great that what do we end up doing? We choose to push down our individuality in exchange for being accepted by the pack, beginning with our parents, and then our friends, and then our teachers, and then our bosses, and all of the other dimensions of society.
So we lose who we were before the world told us who to be. It's actually a Carl Jung quote, "The world will ask you who you are, and if you don't know, it'll tell you." So I would say that that is the number one reason why transformation doesn't take place. It's because a long time ago, we made that exchange to forego our individuality in order to be accepted by others because of that deep primal need for love and acceptance. In order to undertake that process of personal transformation, one of the truths you have to realize is that truth, that truth that you are in large part the way you are but because of what the world told you to be, and it's making the choice consciously to then say, "Fuck that, and I'm going to go against the grain and I'm going to now tell the world that I don't want its influence on me anymore, and I will, like Moby Dick or like Ahab going down with the white whale, I am willing to die to return to my individuality and to break free and to be who I want to be in the face of the currents around us regarding the messages around how we should think, live, act, and feel."
So that is the thing that prevents transformation. The simple thing is you could say fear, but what is the fear? That is the fear. It's to say, "I'm going to walk my own path now and I'm going to be who I want to be, and I'm going to discover who I was before the world told me who to be, and by doing so, I run the risk that I'm not going to be accepted anymore." That's terrifying.

**中文翻译:**
阻碍人们改变的一个重要因素是“文明的惯性”，因为我们的一生都在经历一种根本性的冲突。当我们出生时，我们有很多需求，但有两个基本需求在每个人身上都是不可改变的，尤其是孩子。第一个需求是哺乳动物对爱、接纳和连接的需求。在整个动物王国中，我们的妊娠期（gestation periods）是最长的之一，甚至当我们出生时，我们也是无助的，无法独立生存。为了生存，我们需要在之后的很多很多年里得到抚育。
这与我们对连接的需求并行。所以我们在生物学上就被设定为需要被接纳和连接，因为这也许是生存最基本的东西，比水还重要。所以我们带着这种需求出生。但与此同时，我们也作为独特的个体出生。
我读过一项研究，科学家估计了两个精子或两个卵子基因完全相同的概率。作为背景，我认为一个成年男性在壮年时期每天产生大约 1000 万到 1 亿个精子。所以我们一生中会产生大量的精子。他们得出的数学结果是，两个精子完全相同的概率大约是 10 的 15 次方分之一，这比银河系中恒星的数量还要大一百万倍。银河系中大约有 1000 亿到 4000 亿颗恒星。所以概率比那还要低一百万倍。所有这些都是为了说明：当你出生时，你是独一无二的。以前从未有过你，在另一个你再次出现之前，将需要非常非常长的时间或另一个维度。
然后，通过生活的社会化，我们都有了独特的经历，这些经历通过我们自己的头脑和基因这一独特的棱镜，使我们作为个体的特征进一步加强。所以我们生来就有这种被连接和被爱的基本需求，但我们也生来就有做自己和表达自我的需求。然而，最终发生的是，你出生的这个世界最终会制约你，让你远离那个独特的个体，这就是社会的功能。
社会之所以运作，是因为足够多的人选择在教育方式、抚养孩子、城市规划等数百万件事上达成相同的信念和想法。所以社会的基质或粘合剂是“共同信念”。这就是为什么我说“文明的惯性”，或者我应该说“社会的惯性”，是因为你出生在一个从很小的时候就开始制约你的世界，告诉你该怎么做、不该怎么做，相信什么、不相信什么。
为什么我是旧金山巨人队的球迷？嗯，因为我在一个巨人队的家庭长大。并不是说我两岁的时候就选了巨人队，不是那样运作的。接下来发生的是，这再次从很小的时候就开始了。你两三四五岁，你周围的世界，即世界上的成年人，开始告诉你该成为谁。这开始挑战你的个性，或与之发生冲突。但因为我们害怕不被接纳和不被爱的恐惧是如此巨大，我们最终做了什么？我们选择压抑自己的个性，以换取被群体接纳——从父母开始，然后是朋友、老师、老板，以及社会的所有其他维度。
所以我们失去了在世界告诉我们该成为谁之前的那个自己。这实际上是卡尔·荣格的一句话：“世界会问你是谁，如果你不知道，它会告诉你。”所以我说，这是转型不发生的头号原因。因为很久以前，我们为了被他人接纳，为了那种深层的原始爱与接纳的需求，做出了放弃个性的交换。为了进行个人转型的过程，你必须意识到的真相之一就是：你在很大程度上是现在的样子，是因为世界告诉你要成为这样。然后有意识地做出选择说：“去它的，我要逆流而上，我现在要告诉世界，我不再想要它对我的影响。我将像《白鲸记》里的亚哈船长随白鲸沉入大海一样，我愿意为了回归我的个性和获得自由而‘死’，在面对周围关于我们应该如何思考、生活、行动和感受的信息流时，成为我想成为的人。”
这就是阻碍转型的东西。简单来说你可以说是恐惧，但恐惧的是什么？这就是恐惧：说“我现在要走自己的路，我要成为我想成为的人，我要发现世界告诉我该成为谁之前的那个我。而这样做，我冒着不再被接纳的风险。”那是极其恐怖的。

---

### (01:13:41) Andy Johns

**English:**
Yeah. That really ties in with this point of the uniqueness of people. You have to find what works for you. For some people, it's going to be the ice bath thing. For others it's not. Last year, a quick anecdote, I spent a month working at an animal sanctuary in northern Thailand for abused animals and neglected animals. This place is amazing. They take in anything and they say, "We'll find a way," and that's what they do. So they have hundreds and hundreds of animals, including a large herd of elephants, which is pretty amazing.
There was a worker there who I met, and just by the expression on his face, I could tell that this was a liberated man. This was somebody who had figured out something that was contributing to his deep sense of peace. So I went to talk with him. I said, "Hey, something tells me that you figured out the secret to life and I'd like to chat." So we talked, and it turned out that half the time he was a farmer, he had a small little farm, an acre up on a hill in the mountains, and he'd work at his farm half the time and the other half he would then go and work at the animal sanctuary, and he was a practicing Buddhist.
One of the things he said to me really stood out. He used a simple analogy. He said, "Everyone's trying to make it to Bangkok. The problem is they're getting to Bangkok by following somebody else's road. The whole point is to find your own path to Bangkok." He was making that same point or a similar point of you've got to find your own way. That is the message. For me, I take that as maybe the most fundamental message in looking back at the story of the original Buddha himself was, sure, the teachings, the traditions, everything that's formed around his teachings has power and merit to it, but I look at what he did. He was born as a prince into a royal family. Something wasn't right, and he was seeking the truth behind this anguish and this unfulfillment, and there was something inside of him that said, "I must seek the answer because growing up in this sheltered life as a prince, this can't be the answer."
So he left it all behind, including his wife and child, and then he lived as an aesthetic for years, nearly dying close to starvation. He did that for years. Then eventually he realized, "Well, that's not the answer either." Then he famously made his way to the Bodhi tree and sat under it and meditated for 40, 41 days. I can't recall what it was, a long time. Then he had his enlightenment, and out of that came one of the teachings, which is known as the middle way. It's not about being a prince, it's not about being poor. There's something in between. He found that was his path to Bangkok. You could walk that path and maybe it'll teach you something or it'll lead you nowhere because it's not your own path. I think that's the point.

**中文翻译:**
是的。这确实与人的独特性这一点紧密相连。你必须找到适合自己的方法。对某些人来说，可能是冰浴；对另一些人来说则不然。去年，讲个小故事，我在泰国北部的一家动物收容所工作了一个月，那里收容被虐待和被忽视的动物。那个地方太棒了，他们接收任何动物并说“我们会想办法”，他们也确实做到了。那里有成百上千的动物，包括一大群大象，非常壮观。
我在那里遇到了一位工作人员，仅仅通过他脸上的表情，我就能看出这是一个获得解脱（liberated）的人。这是一个弄清楚了某些事情并因此获得了深度平静的人。于是我去和他聊天。我说：“嘿，直觉告诉我你发现了生活的秘密，我想聊聊。”我们聊了聊，原来他一半时间是农民，在山上有一英亩的小农场，他一半时间在农场干活，另一半时间去动物收容所工作，他还是个修行的佛教徒。
他对我说的其中一句话让我印象深刻。他用了一个简单的比喻，他说：“每个人都想去曼谷。问题是，他们是跟着别人的路去曼谷的。关键是要找到你自己的曼谷之路。”他表达的是相同或类似的观点：你必须找到自己的路。这就是核心信息。对我来说，回顾佛陀本人的故事，这也许是最基本的信息：当然，教义、传统、围绕他的教导形成的一切都有其力量和价值，但我看他做了什么。他出生在皇室，是个王子。但有些事情不对劲，他在寻求这种痛苦和不满足感背后的真相。他内心有个声音说：“我必须寻求答案，因为作为王子在受保护的生活中长大，这不可能是答案。”
于是他抛下了一切，包括妻儿，然后作为苦行僧（ascetic）生活了多年，几近饿死。他那样生活了多年。最后他意识到：“嗯，那也不是答案。”然后他著名的举动是走到菩提树下坐下，冥想了 40 或 41 天——我不记得具体多久了，很长时间。然后他觉悟了，由此产生了一项教义，即“中道”（middle way）。不是关于当王子，也不是关于贫穷，而是介于两者之间。他发现那是他的“曼谷之路”。你可以走那条路，也许它会教给你一些东西，或者它会让你一无所获，因为它不是你自己的路。我认为这就是重点。

---

### (01:17:44) Andy Johns

**English:**
Sure, sure. Well, let me answer the first one, a message to leave to folks. I would imagine that there's a lot of high performers, successful folks out there. Some of you, you may feel like you're on the verge of answering a call towards a new chapter in life or towards finding a way out of whatever situation you're in that you don't want to be in anymore. The thing I guess I would say to you is that having undergone some change myself, all I can promise you is that it's going to be in some ways the best thing that's ever happened to you, but also the worst thing that's ever happened to you, but those are the experiences that define a life.
If you feel that call inside of you to seek a new way of living, just know that you're not the only one out there doing it. There are others out there such as myself and that I can always be reached. So I wish you a happy journey and just know that things are going to be okay. Now, the second question, what am I up to nowadays? Is that-
I'm good. I still have my ups and downs. I've arrived at an interesting part in my journey where it's something that I'm practicing now and I still don't quite have the hang of it. I'll use one more metaphor. I think the way that I approached the first part of my life was as if life was a big mountain to be climbed, where you're trying to head up Everest under this assumption that once you get to the top, you're going to have this bliss that will persist or that will make you feel that you had a life well-lived, and that that was the answer, but what I experienced was that once I got to the top of one mountain, then I had to find the top of another and another and another. Although you see and do some amazing things along the way, at some point it's too exhausting. At some point, you may really get yourself into trouble and you might not survive.
The vast majority of people who die on Mount Everest actually die on the way down, not on the way up. You don't save anything for the return home, I think is the point. Instead of pursuing my life now as a mountain to be climbed in the hopes that reaching the top will make me feel good again, I'm instead trying to float down river. So for example, if you go whitewater rafting, they'll give you a little safety crash course at the beginning. They'll say, "Here's how you paddle. Put your vest on." One of the things they'll ask you is, what do I do if I fall overboard, especially if I fall overboard into the rapids or the cold water? This is maybe the most important thing they teach because commonly what happens if you're in sizable enough rapids and you fall overboard, the tendency is to freak out and to fight the current. When people freak out in the water, especially when the water's choppy, that's when they get in trouble.
The thing they teach you to do is instead you go into mummy mode, right? You lay back, you cross your arms across your chest, and you stick your feet out like you're a mummy, and you do the opposite of fighting the current. You allow the current to take you where it's trying to take you. For me, I actually find that I believe that that's a more fitting metaphor for life. It's possible that there's something amazing for us downstream so long as we're willing to surrender and just let go, to turn off the intellectual mind a bit, to quit trying to plan as if you can predict the future, to quit thinking about all the edge cases and trying to optimize our life, which I think is a bunch of bullshit. It's possible that if you just relax and you instead pay attention to the signals around you, you feel where the current is trying to take you, maybe towards a potential life partner, maybe away from an oppressive work environment, maybe towards a place to live that is more calm and peaceful, whatever it may be.
If you really tune in with yourself and pay attention to that current and you relax into it, you'll arrive at a destination that you were meant for. In a sense, that's what I did that has brought me to this conversation today. Instead of talking about investing in companies and what have you, I'm instead trying to connect with people on an entirely different level and help them make their own way downstream, so to speak.
So for me nowadays, that's how I'm living at the moment. I'm actually in Vietnam. Just got here about 10 days ago because it seemed like the current of life was taking me here right now. It's likely that it's just the next lily pad towards wherever else I'm heading to, but I guess I'm in the mindset now where I'm willing to just surrender and see how it unfolds.

**中文翻译:**
当然。让我先回答第一个问题，留给听众的一句话。我想外面有很多高成就者、成功人士。你们中的一些人可能觉得正处于响应某种召唤的边缘，去开启人生的新篇章，或者去寻找一条出路，离开你不再想待的任何境地。我想对你们说的是，作为经历过一些改变的人，我唯一能向你保证的是，在某些方面，这将是你经历过的最好的事情，但同时也是最坏的事情。但正是这些经历定义了人生。
如果你感到内心有那种寻求新生活方式的召唤，请记住你不是唯一一个这样做的人。还有像我这样的人，而且我随时可以联系到。所以我祝你旅途愉快，只要知道一切都会好起来的。现在，第二个问题，我最近在忙什么？
我很好。我仍然有起伏。我来到了旅程中一个有趣的部分，这是我正在练习的东西，但我仍然没有完全掌握。我再用一个比喻。我认为我处理前半生的方式就像生活是一座要攀登的大山，你试图登上珠穆朗玛峰，假设一旦到达顶峰，你就会拥有持久的幸福，或者让你觉得这一生过得很值，那就是答案。但我经历的是，一旦我登上一座山的顶峰，我就必须寻找另一座山的顶峰，然后又一座，又一座。虽然沿途你会看到并做一些了不起的事情，但在某个点，这太累了。在某个点，你可能会真的陷入麻烦，可能无法生存。
绝大多数死在珠穆朗玛峰上的人实际上是死在下山的路上，而不是上山的路上。我想重点是，你没有为回家留下任何体力。我现在不再把生活追求为一座要攀登的山，希望登顶能让我再次感觉良好，而是试图顺流而下。例如，如果你去玩白水漂流，开始时他们会给你一个简短的安全培训。他们会说：“这是划桨的方法。穿上救生衣。”他们会问你的一件事是：如果我掉进水里怎么办，尤其是掉进急流或冷水里？这也许是他们教的最重要的事情，因为通常如果你在足够大的急流中掉进水里，倾向是惊慌失措并与水流搏斗。当人们在水中惊慌失措时，尤其是水面波涛汹涌时，那就是出问题的时候。
他们教你做的是，相反，你进入“木乃伊模式”（mummy mode），对吧？你向后躺，双臂交叉在胸前，像木乃伊一样伸出双脚，你做的是与水流搏斗相反的事情。你让水流带你去它想带你去的地方。对我来说，我实际上发现我相信这是一个更贴切的生活比喻。只要我们愿意臣服（surrender）并放手，关闭一点理智的头脑，停止试图预测未来式的计划，停止思考所有的极端情况并试图优化我们的生活（我认为那是一堆废话），下游可能会有令人惊叹的东西在等着我们。如果你只是放松，转而关注周围的信号，感受水流试图带你去哪里——也许是去向一个潜在的人生伴侣，也许是离开一个压抑的工作环境，也许是去向一个更平静安宁的居住地，无论那是什么。
如果你真的与自己同步并关注那股水流，并放松地融入其中，你就会到达一个你注定要去的目的地。从某种意义上说，这就是我所做的，它带我来到了今天的这场对话。我不再谈论投资公司之类的东西，而是试图在完全不同的层面上与人建立联系，帮助他们找到自己的“顺流而下”之路。
所以对我来说，这就是我目前的生活方式。我现在实际上在越南。大约 10 天前刚到这里，因为看起来生活的潮流现在正把我带到这里。这可能只是通往我下一个目的地的又一片“睡莲叶”，但我现在的心态是，我愿意臣服并看看生活将如何展开。

---

### (01:23:35) Lenny

**English:**
The metaphor for that is they lost your luggage on the way to Vietnam, and we had to push back this recording a week.

**中文翻译:**
这个比喻的现实版是：他们在你去越南的路上弄丢了你的行李，我们不得不把这次录音推迟了一周。

---

### (01:23:41) Andy Johns

**English:**
Yeah, that's right, that's right. My luggage was half a world away from me, and so when that happened, what could I do? I just said, "Okay. Well, I have shorts and a shirt on me that I can wear for the next three or four days," and that's what I did.

**中文翻译:**
是的，没错，没错。我的行李在半个地球之外，当那发生时，我能怎么办？我只是说：“好吧。嗯，我身上穿着短裤和衬衫，接下来的三四天我可以一直穿这个。”我就是这么做的。

---

### (01:24:00) Lenny

**English:**
Amazing. Andy, I think this might end up being one of the most meaningful episodes of the podcast. I think it's going to end up being a Trojan horse for people are coming here for advice on optimizing their product and growth, and they'll opt up rethinking their whole life, hopefully in a good way, maybe cause some suffering, maybe help people through suffering. Thank you, Andy, so much for being here. Two final questions. You said people could reach out if they're going down this path and maybe need some help or advice. So what's the best way for people to reach out, and then how can listeners be useful to you?

**中文翻译:**
太棒了。Andy，我认为这可能会成为本播客最有意义的一集。我认为它最终会成为一个“特洛伊木马”：人们来到这里是为了寻求优化产品和增长的建议，结果却开始重新思考他们的人生。希望是以一种好的方式，也许会引起一些痛苦，也许会帮助人们度过痛苦。Andy，非常感谢你能来到这里。最后两个问题：你说如果人们正在走这条路，可能需要一些帮助或建议，可以联系你。那么人们联系你的最佳方式是什么？以及听众可以如何帮助你？

---

### (01:24:31) Andy Johns

**English:**
Sure, a couple ways. You can find me on Twitter, my username is Clues Dot Life, so C-L-U-E-S-D-O-T-L-I-F-E. You can also find me on LinkedIn, search for Andrew Johns, you'll find me on there. You can check out my website Clues.Life. It's a basic MVP, but it's an art project that's in process. So those are a couple of ways that you can reach out. In terms of ways you can help, you can't always tell who you're helping. When I sit behind my laptop and I write and I send my messages out into the world, other than getting some thumbs up here and there, you don't always know what impact you're having.
Sometimes it's good to hear because, again, for me, this is part of me rewriting that internal narrative where I'm trying to do more work for the benefit of others as opposed to what it does for my bank account. So if part of this message has been beneficial to you, it would certainly put wind in my sails to hear that. So that would be one way to help.

**中文翻译:**
好的，有几种方式。你可以在 Twitter 上找到我，我的用户名是 CluesDotLife，即 C-L-U-E-S-D-O-T-L-I-F-E。你也可以在 LinkedIn 上搜索 Andrew Johns 找到我。你可以查看我的网站 Clues.Life。它是一个基本的 MVP，但它是一个正在进行中的艺术项目。这些是你可以联系我的几种方式。至于你可以如何帮助我：你并不总是知道你在帮助谁。当我坐在笔记本电脑前写作并将信息发送到世界各地时，除了偶尔得到一些点赞，你并不总是知道自己产生了什么影响。
有时听到反馈是很好的，因为再说一次，对我来说，这是我重写内部叙事的一部分——我正努力做更多造福他人的工作，而不是为了我的银行账户。所以，如果这些信息对你有益，听到这些肯定会成为助我前行的动力（put wind in my sails）。所以那将是一种帮助我的方式。

---

### (01:25:50) Lenny

**English:**
What a great answer. So let's blow up the YouTube comments and send you some DMs and LinkedIn messages if people find this valuable. Andy, thank you again so much for being here.

**中文翻译:**
多么棒的回答。所以，如果人们觉得这很有价值，就让我们在 YouTube 评论区刷屏，并给你发一些私信和 LinkedIn 消息吧。Andy，再次感谢你能来到这里。

---

### (01:26:02) Andy Johns

**English:**
Lenny, I appreciate it, man. Thank you.

**中文翻译:**
Lenny，我很感激。谢谢。

---

### (01:26:04) Lenny

**English:**
Bye, everyone.
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。
非常感谢您的收听。如果您觉得这很有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。