# Andy Raskin_ - 双语对照

以下是《Lenny's Podcast》访谈 Andy Raskin 的完整双语对照文档。

---

### [00:00:00] [Andy Raskin]

**English:**
The way I learned how to pitch in business school, and I think the way most people did is what I call the arrogant doctor. So you have a problem, a pain, I have a solution, a treatment, and I'm going to tell you why it's better than all the other treatments. And the structure that I read about in these movies was different. Every movie starts with some kind of shift in the world, and I call this shift the shift from the old game to a new game. The archetypal example of this, I think in the business world, is what Benioff did with Salesforce. So he comes in and he says, "Hey, software is over and there's this new world called the cloud, a new game, new rules. That's the new way to win. And we're going to help you if you're in there." This structure really is about defining a movement, and that's very different from, "Hey, I'm going to solve your problem."

**中文翻译:**
我在商学院学到的推销（pitch）方式，也是大多数人学到的方式，我称之为“傲慢的医生”模式。也就是说，你有一个问题、一种痛苦，我有一个解决方案、一种疗法，然后我要告诉你为什么我的疗法比所有其他疗法都好。而我在电影中读到的结构则完全不同。每部电影都始于世界某种形式的转变，我称之为“从旧游戏到新游戏的转变”。我认为商业世界中这方面的典型例子是贝尼奥夫（Benioff）在 Salesforce 所做的。他走出来说：“嘿，软件时代结束了，现在有一个叫‘云’的新世界，这是一个新游戏，有新规则。那是新的获胜方式。如果你加入其中，我们会帮助你。”这种结构的核心在于定义一场“运动”，这与“嘿，我要解决你的问题”是截然不同的。

---

### [00:00:54] [Lenny]

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful products. Today my guest is Andy Raskin. Andy helps CEOs and company leaders align their teams around something he calls a strategic narrative, which as you'll learn all about in this episode, is essentially a simple story that helps people understand why they need your product. And with that helps you align your sales, marketing, and product teams along with your fundraising and even your hiring efforts.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中辛苦换来的经验。今天的嘉宾是 Andy Raskin。Andy 帮助 CEO 和公司领导者围绕他称之为“战略叙事”（strategic narrative）的东西来统一团队。正如你将在本集节目中了解到的，这本质上是一个简单的故事，帮助人们理解为什么他们需要你的产品。通过这种方式，它能帮助你协调销售、营销和产品团队，甚至包括融资和招聘工作。

---

### [00:01:25] [Lenny]

**English:**
Andy has worked closely with some of the most successful founders and companies out there, including companies like Gong, Dropbox, Uber, Salesforce, Square, IBM, and many others. In our conversation, Andy explains why most people are pitching their product completely wrong, why focusing on the problem you're solving for people is no longer an effective pitch and how the strategic narrative helps you frame your solution in a much more effective way. Andy also shares a ton of examples of the framework in action, why focusing on categories and category creation is so limiting, signs your narrative needs to work and so much more. Enjoy this episode with Andy Raskin after a short word from our sponsors.

**中文翻译:**
Andy 曾与一些最成功的创始人和公司密切合作，包括 Gong、Dropbox、Uber、Salesforce、Square、IBM 等。在我们的对话中，Andy 解释了为什么大多数人推销产品的方式完全错误，为什么仅仅关注为人们解决的问题不再是有效的推销手段，以及战略叙事如何帮助你以更有效的方式构建你的解决方案。Andy 还分享了大量该框架的实际案例，解释了为什么关注“品类”和“品类创造”具有局限性，以及你的叙事需要改进的迹象等等。在听完赞助商的简短介绍后，请欣赏与 Andy Raskin 的精彩对话。

---

### [00:02:07] [Lenny]

**English:**
This episode is brought to you by Coda. You've heard me talk about how Coda is the doc that brings it all together, and how it can help your team run smoother and be more efficient. I know this firsthand because Coda does that for me. I use Coda every day to wrangle my newsletter content calendar, my interview notes for podcasts, and to coordinate my sponsors. More recently, I actually wrote a whole post on how Coda's product team operates, and within that post, they shared a dozen templates that they use internally to run their product team, including managing a roadmap, their OKR process, getting internal feedback, and essentially their whole product development process is done within Coda.

**中文翻译:**
本集节目由 Coda 赞助。你听我谈过 Coda 是如何将一切整合在一起的文档，以及它如何帮助你的团队运行得更顺畅、更高效。我有切身体会，因为 Coda 确实帮到了我。我每天都用 Coda 来管理我的时事通讯内容日历、播客采访笔记以及协调赞助商。最近，我还专门写了一篇文章介绍 Coda 的产品团队是如何运作的，在那篇文章中，他们分享了十几个内部用于管理产品团队的模板，包括路线图管理、OKR 流程、获取内部反馈，基本上他们的整个产品开发流程都是在 Coda 中完成的。

---

### [00:02:45] [Lenny]

**English:**
If your team's work is spread out across different documents and spreadsheets and a stack of workflow tools, that's why you need Coda. Coda puts data in one centralized location regardless of format, eliminating roadblocks that can slow your team down. Coda allows your team to operate on the same information and collaborate in one place. Take advantage of this special limited time offer just for startups. Sign up today at Coda.io/Lenny and get $1,000 starter credit on your first statement. That's C-O-D-A.io/Lenny to sign up and get a startup credit of $1,000. Coda.io/Lenny.

**中文翻译:**
如果你的团队工作分散在不同的文档、电子表格和一堆工作流工具中，那么你正需要 Coda。Coda 将数据集中在一个位置，无论格式如何，从而消除了可能拖慢团队进度的障碍。Coda 让你的团队能够在同一信息基础上进行协作。现在就利用这个专门针对初创公司的限时优惠吧。今天就在 Coda.io/Lenny 注册，即可在第一张账单中获得 1000 美元的启动抵扣额度。地址是 C-O-D-A.io/Lenny，注册并获取 1000 美元的初创公司抵扣额度。Coda.io/Lenny。

---

### [00:03:24] [Lenny]

**English:**
Are you hiring or on the flip side, are you looking for a new opportunity? Well, either way, check out Lennysjobs.com/talent. If you're a hiring manager, you can sign up and get access to hundreds of hand curated people who are open to new opportunities. Thousands of people apply to join this collective, and I personally review and accept just about 10% of them. You won't find a better place to hire product managers and growth leaders.

**中文翻译:**
你正在招聘吗？或者反过来，你正在寻找新的机会？无论哪种情况，请访问 Lennysjobs.com/talent。如果你是招聘经理，你可以注册并接触到数百名经过人工筛选、正在寻找新机会的优秀人才。成千上万的人申请加入这个人才库，而我个人会审核并仅录取其中约 10% 的人。你找不到比这更好的地方来招聘产品经理和增长领导者了。

---

### [00:03:49] [Lenny]

**English:**
Join almost 100 other companies who are actively hiring through this collective. And if you're looking around for a newer opportunity, actively or passively, join the collective. It's free. You can be anonymous and you can even hide yourself from specific companies. You can also leave anytime and you'll only hear from companies that you want to hear from. Check out Lennysjobs.com/talent.

**中文翻译:**
加入近 100 家正在通过这个人才库积极招聘的公司吧。如果你正在寻找新的机会，无论是主动还是被动，都欢迎加入。这是免费的。你可以保持匿名，甚至可以对特定公司隐藏自己。你也可以随时退出，并且只会收到你感兴趣的公司的消息。请访问 Lennysjobs.com/talent。

---

### [00:04:16] [Lenny]

**English:**
Andy, welcome to the podcast.

**中文翻译:**
Andy，欢迎来到播客。

---

### [00:04:18] [Andy Raskin]

**English:**
Oh, thanks Lenny. So great to talk with you.

**中文翻译:**
噢，谢谢 Lenny。很高兴能和你交流。

---

### [00:04:21] [Lenny]

**English:**
You are quite known as someone that helps CEOs optimize their pitch, their story, their strategy, which we're going to get deep into. But before we do that, can you just give us a little glimpse into how you found your way into this line of work?

**中文翻译:**
你以帮助 CEO 优化他们的推销、故事和战略而闻名，我们稍后会深入探讨这些内容。但在那之前，你能简要介绍一下你是如何进入这一行工作的吗？

---

### [00:04:35] [Andy Raskin]

**English:**
I started as a coder. I was a computer science major, undergrad, a friend and I had an idea for an app. So this was like during the dot com years. So Windows app, and we coded a little prototype and we started, we put it out there, we started getting some users and we thought, "Oh, okay, maybe we can get some investments." So of the two of us, I spoke English fluently. So we decided, okay, I'll write the investor pitch. So I wrote the pitch, we sent it out and the reaction was really bad. One VC wrote back and said, "Listen, I rate every plan I get on a scale of 1 to 10, and yours is a 1," and the next to the one he wrote in parentheses, "Worst," in case we thought maybe that was the top of his rating scale.

**中文翻译:**
我最初是一名程序员。我本科读的是计算机科学专业，当时我和一个朋友想到了一个应用的创意。那是互联网泡沫（dot com）时期。是一个 Windows 应用，我们编写了一个原型并发布了出去，开始有了一些用户，于是我们想：“噢，好吧，也许我们可以拿到一些投资。”在我们两个人中，我的英语说得比较流利，所以我们决定由我来写投资人推销信。我写好了推销信发了出去，结果反馈非常糟糕。一位 VC 回信说：“听着，我会给收到的每一份计划书打分，总分 1 到 10 分，而你的计划书是 1 分。”他在 1 旁边还加了个括号写着“最差”，以防我们以为 1 分是他评分标准的最高分。

---

### [00:05:20] [Lenny]

**English:**
Brutal.

**中文翻译:**
太扎心了。

---

### [00:05:22] [Andy Raskin]

**English:**
Yeah, brutal. But then lower down, so this was back when they would like you'd print, send the hard copy of the plan and they might mail it back with comments written in. And he had written in, "Not a compelling story." A few weeks later, I'm walking by this Barnes & Noble and there's a sign in the window that says, "For anyone who wants to tell a compelling story," okay, that's me. And there's an arrow that points to these books and they turned out to be screenwriting books. I didn't know anything about this, so I started reading these books and it strikes me a movie is a pitch. What is Star Wars a pitch for? It's a pitch for be good, care about people, trust The Force in their terms. But I don't have couple hours. I'm pitching a business. It's very different. I'm not writing a three X screenplay.

**中文翻译:**
是的，很扎心。但在信的下方——那时候你还要打印并寄送计划书的纸质版，他们可能会写上评语再寄回来——他写道：“故事不吸引人。”几周后，我路过一家 Barnes & Noble 书店，橱窗里贴着一个牌子，上面写着：“致所有想要讲出引人入胜故事的人”，我想，好吧，那就是我。牌子上有一个箭头指向一些书，结果那些是编剧书籍。我当时对此一窍不通，于是开始读这些书，我突然意识到：电影其实就是一种推销。比如《星球大战》是在推销什么？它是在推销“向善、关爱他人、信任原力（The Force）”。但我没有几个小时的时间，我是在推销一桩生意，这很不一样。我不是在写三幕式剧本。

---

### [00:06:11] [Andy Raskin]

**English:**
So what applies, what doesn't apply? I mean these are questions I think I'm still asking, but I did my best to take some of the learnings of how the movie was structured. It was very different from how my pitch was structured and kind of restructure it. And we did that and we sent the pitch out and we start getting more interest. It was really clear. And then we had a term sheet I think a few months later and I'm like, "What is this story thing?" That we didn't change the product, it was basically the same business just sort of how we talked about it. That was really interesting to me.

**中文翻译:**
那么，哪些适用，哪些不适用？这些问题我想我至今仍在探索，但我尽力借鉴了电影结构的一些精髓。它与我之前的推销结构非常不同，我对其进行了重构。我们照做了，把推销信发出去后，开始引起了更多的兴趣。效果非常明显。我想几个月后我们就拿到了投资意向书（term sheet），我当时想：“这个‘故事’到底是什么神奇的东西？”我们并没有改变产品，业务基本上还是那个业务，只是改变了我们描述它的方式。这对我来说非常有意思。

---

### [00:06:49] [Andy Raskin]

**English:**
I mean, over the next 10, 15 years, I thought about, "Hey, maybe I could do consulting with this." CEOs who heard about this were asking me about it. But I still was like, "No. No CEO's going to budget a line item for the story. That's not a thing." So I just didn't do it for a really long time until eventually I was proven wrong about that.

**中文翻译:**
在接下来的 10 到 15 年里，我一直在想：“嘿，也许我可以以此做咨询。”听闻此事的 CEO 们也一直在向我咨询。但我当时还是觉得：“不，没有哪个 CEO 会为‘故事’专门列一项预算。这根本不成气候。”所以我很长一段时间都没有去做这件事，直到最终事实证明我错了。

---

### [00:07:13] [Lenny]

**English:**
And how many years ago was this at this point?

**中文翻译:**
到目前为止，那是多少年前的事了？

---

### [00:07:15] [Andy Raskin]

**English:**
So this was dot com. This was like '98 when I was pitching that company.

**中文翻译:**
那是互联网泡沫时期。大约是 1998 年，我为那家公司做推销的时候。

---

### [00:07:20] [Lenny]

**English:**
Amazing. I think there's a couple interesting tidbits about this. One is that interesting opportunities arise when you're doing something you're excited about. So you had the startup, it didn't work out, but you had a problem that you solved for yourself and that led to another, a bigger opportunity for your career.

**中文翻译:**
太棒了。我觉得这里有几个有趣的细节。一是当你做自己兴奋的事情时，有趣的机会就会出现。你当时创办了那家公司，虽然没成功，但你遇到了一个自己解决掉的问题，而这为你职业生涯带来了另一个更大的机会。

---

### [00:07:34] [Andy Raskin]

**English:**
Yeah, totally.

**中文翻译:**
是的，完全正确。

---

### [00:07:35] [Lenny]

**English:**
So that's interesting. And then also just some of the best opportunities arise from solving your own problem, not planning to start something with it, but just like, "I have a problem." Turns out [inaudible 00:07:44]-

**中文翻译:**
这很有趣。而且，一些最好的机会往往源于解决你自己的问题，而不是计划以此创业，只是单纯觉得“我有个问题”。结果证明……

---

### [00:07:44] [Andy Raskin]

**English:**
Yeah, I think that's same with you. Right, Lenny? You started writing about stuff and boom, that became the thing.

**中文翻译:**
是的，我想你也是这样，对吧 Lenny？你开始写一些东西，然后砰的一声，它就成了你的事业。

---

### [00:07:49] [Lenny]

**English:**
Absolutely. It was not quite boom, but eventually it became boom.

**中文翻译:**
没错。虽然不是立刻就“砰”地爆发，但最终确实爆发了。

---

### [00:07:53] [Andy Raskin]

**English:**
Feels like boom from outside.

**中文翻译:**
从外面看感觉就像是突然爆发。

---

### [00:07:55] [Lenny]

**English:**
Yeah, that's how it goes. It always overnight for everyone else that isn't here.

**中文翻译:**
是的，就是这样。对于不在其中的人来说，这看起来总是像一夜成名。

---

### [00:08:01] [Andy Raskin]

**English:**
Right, exactly.

**中文翻译:**
没错，正是如此。

---

### [00:08:03] [Lenny]

**English:**
Yeah. Okay, so let's get into it. So you help CEOs at this point come up with what you call a strategic narrative and you help them not only come up with this strategic narrative, but you help their teams align around this strategic narrative. So let's just start with what is a strategic narrative?

**中文翻译:**
好，让我们进入正题。你现在帮助 CEO 构思你所谓的“战略叙事”，你不仅帮他们构思，还帮他们的团队围绕这个战略叙事达成一致。那么，我们先从“什么是战略叙事”开始吧？

---

### [00:08:19] [Andy Raskin]

**English:**
Yeah, you'd think, I've been doing this for 10 years, I'd have a very snappy definition of it there, and I don't know if I'm really happy with ... like I've ever found one that totally gets at it yet. The one thing I say is it's this one story that the CEO uses to drive success in marketing, sales, but also product. That it becomes like a north star, strategic north star for product roadmap, for fundraising, for recruiting, really everything.

**中文翻译:**
是的，你可能会想，我都做这行 10 年了，应该有一个非常简练的定义，但我不知道我是否真的满意……我还没找到一个能完全概括它的定义。我常说的一点是：它是 CEO 用来驱动营销、销售以及产品成功的“那一个故事”。它成为了产品路线图、融资、招聘，乃至一切工作的“北极星”，即战略北极星。

---

### [00:08:54] [Andy Raskin]

**English:**
What I think is really interesting as a kind of qualifier is that this story has a certain structure. Like I said, when I found those screenwriting books, I sort of shifted the structure. And the traditional structure, the way I learned how to pitch in business school, I think the way most people did is what I call the arrogant doctor. So you have a problem, a pain, I have a solution, a treatment, and I'm going to tell you why it's better than all the other treatment.

**中文翻译:**
我认为一个很有趣的限定条件是，这个故事有一定的结构。就像我说的，当我发现那些编剧书时，我转变了结构。而传统的结构，也就是我在商学院学到的、我想也是大多数人学到的推销方式，我称之为“傲慢的医生”。即：你有一个问题、一种痛苦，我有一个解决方案、一种疗法，然后我要告诉你为什么它比所有其他疗法都好。

---

### [00:09:24] [Andy Raskin]

**English:**
Not to say it's not better, but just this is the structure of it, and it kind of sets you up for bragging. Let me tell you why it's so great. And the structure that I read about in these movies was different. In the movies, every movie starts with some kind of shift in the world, in the character's world. And I call this shift the shift from the old game to the new game. And the archetypal example of this, I think in the business world is what Benioff did with Salesforce. So he comes in and he says, "Hey, software is over," meaning software in the sense that we're going to own it and maintain it, "And there's this new world called the cloud, a new game, like the new rules, everything has changed and that's the new way to win. And we're going to help you if you're in there." This structure really is about defining a movement and that's very different from, "Hey, I'm going to solve your problem."

**中文翻译:**
并不是说它不更好，只是这种结构本身就让你陷入了“自夸”的境地：让我告诉你为什么它这么棒。而我在电影中读到的结构则不同。在电影里，每部电影都始于世界、始于角色世界的某种转变。我把这种转变称为“从旧游戏到新游戏的转变”。我认为商业世界中这方面的典型例子是贝尼奥夫在 Salesforce 所做的。他走出来说：“嘿，软件时代结束了，”——这里的软件是指我们需要拥有并维护的那种软件——“现在有一个叫‘云’的新世界，这是一个新游戏，有新规则，一切都变了，那是新的获胜方式。如果你加入其中，我们会帮助你。”这种结构的核心在于定义一场“运动”，这与“嘿，我要解决你的问题”截然不同。

---

### [00:10:34] [Lenny]

**English:**
I think the Salesforce example is an awesome example of your approach. If they were thinking about it in the old way, what would Salesforce have done? How would they have pitched it if not for, "Everyone's moving to the cloud, your dumb for using desktop software,"?

**中文翻译:**
我觉得 Salesforce 的例子完美诠释了你的方法。如果他们用旧思维思考，Salesforce 会怎么做？如果不说“大家都在转向云端，你还用桌面软件太蠢了”，他们会怎么推销？

---

### [00:10:48] [Andy Raskin]

**English:**
Well, I think they would've just come out and said like, "Oh hey ..." I mean CRM by the way, was already a category. I mean, already Siebel was the huge giant of that space. There were already even companies doing it online, doing it through the web. And so they would've come and said, "Oh, we're easier to install, faster to get up and running than Siebel," or, "We have this much functionality compared to," I think it was, was it NetSuite? Or, I don't know. It was some early Salesforce-like thing that was out there. They would've done these sort of comparison things.

**中文翻译:**
嗯，我想他们可能会直接出来说：“噢，嘿……”顺便说一下，CRM 当时已经是一个品类了。Siebel 已经是那个领域的巨头。甚至已经有公司在通过网络在线做这件事了。所以他们可能会说：“噢，我们比 Siebel 更容易安装，启动运行更快，”或者“与某某相比，我们有这么多功能，”我想当时是 NetSuite？或者我不确定，总之是当时一些早期的类 Salesforce 产品。他们会做这种对比。

---

### [00:11:25] [Andy Raskin]

**English:**
And Benioff, I mean he is a pretty proud guy. I think he did still say like, "Hey, we're the number one CRM," but wasn't what they led with. They led with this story about this fundamental paradigm shift and, are you in or are you not in? And what they did was instead of just saying, "Hey, we're better than," they said, "Hey, all those others, those Siebel's, they're part of that old game. You want to play that software game? Be my guest, go buy Siebel," and of course we know how it played out.

**中文翻译:**
贝尼奥夫，我是说他是个挺自负的人。我想他当时还是会说：“嘿，我们是排名第一的 CRM，”但这并不是他们的主打口号。他们主打的是关于这种根本性范式转移的故事：你加入还是不加入？他们所做的不是简单地说“嘿，我们比谁更好”，而是说：“嘿，所有其他的，那些 Siebel 之流，他们都是旧游戏的一部分。你想玩那个软件游戏吗？请便，去买 Siebel 吧。”当然，我们都知道结果如何。

---

### [00:12:02] [Lenny]

**English:**
So the crux of the approach is instead of, "Problem, solution, you should go do this," it's, "The world is changing, here's where it's going and we're going to help you get there." I want go in a little more depth of the framework. But before that, what are some other examples to give people a sense of like, oh, I see, I understand what this might be.

**中文翻译:**
所以这种方法的核心不是“问题、解决方案、你应该这样做”，而是“世界正在改变，这是它的走向，我们将帮助你到达那里”。我想更深入地探讨一下这个框架。但在那之前，还有哪些例子能让大家感觉到“噢，我明白了，我知道这是怎么回事了”？

---

### [00:12:19] [Andy Raskin]

**English:**
Yeah, so another great example and no coincidence, so is Zuora. So Zuora is the company I wrote about in this post called The Greatest Sales Deck I've Ever Seen, the CEO of Zuora, Tien Tzuo, was employee number 11 at Salesforce. So he learns this from Benioff. And he's pitching, "Hey, in the old world, businesses operated on transactions. You sold things to people outright. In this new world," he calls it the subscription economy, where people want the benefits of those things without necessarily having to pay for them. And of course gives all these examples of all the winners in this, look at all the winning companies. They're all basically going to this new model.

**中文翻译:**
是的，另一个绝佳的例子是 Zuora，这并非巧合。Zuora 是我在那篇名为《我见过的最伟大的销售 PPT》博文中写到的公司。Zuora 的 CEO Tien Tzuo 是 Salesforce 的第 11 号员工。所以他是从贝尼奥夫那里学到这一点的。他的推销词是：“嘿，在旧世界，企业靠交易运作。你直接把东西卖给别人。在这个新世界，”他称之为“订阅经济”，人们想要获得这些东西带来的好处，而不一定非要买下它们。当然，他举了所有赢家的例子，看看所有成功的公司，它们基本上都在转向这种新模式。

---

### [00:13:05] [Andy Raskin]

**English:**
And so he's pitching someone like Ford and you can imagine they're going to Ford and pitching a subscription for car service, which is quite different from just a lease. And they're starting out with this. This is the big shift. Another one, team I worked with early on, and I think they'd agree their story came out of this work was Gong. So Gong everyone probably knows by now, they take the video recordings of all your sales calls and they stick AI onto it and come out with all these insights. And that story is, hey, goodbye opinions. Used to be a world where sales is run on opinions. Hello reality, that now all the winners are adopting this new mindset where we really have to see what's really going on.

**中文翻译:**
所以当他向福特这样的人推销时，你可以想象他们去福特推销汽车服务订阅，这与单纯的租赁大不相同。他们就是从这里开始的：这就是巨大的转变。另一个例子是我早期合作过的团队，我想他们也会同意他们的故事源于这项工作，那就是 Gong。现在大家可能都知道 Gong 了，他们记录你所有的销售通话视频，利用 AI 进行分析并得出洞察。那个故事是：“嘿，告别主观意见。过去销售是靠主观意见运作的。你好，现实。现在所有的赢家都在采用这种新思维，即我们必须真正看清到底发生了什么。”

---

### [00:13:56] [Lenny]

**English:**
In the Gong example, let's say, what would they have done if they were going, "Here's the problem, here's the solution, here's what we're going to do for you,"?

**中文翻译:**
在 Gong 的例子中，如果他们走“这是问题，这是解决方案，这是我们要为你做的”路线，他们会怎么做？

---

### [00:14:03] [Andy Raskin]

**English:**
Yeah, I mean that's kind of what they were doing when they started out. And I'm not saying that didn't work totally. I mean already by the time they started doing this, they were starting to become a big company. I remember Bendov said to me, "Listen, Andy," they were around series B, I think this is around 2018. It's like, "We're going to be a huge company. The question is how huge. And I think that this narrative along the lines of Zuora or Salesforce, if we get this right, this is going to be a multiplier on our growth."

**中文翻译:**
是的，我是说他们刚开始时确实是那么做的。我并不是说那完全没用。在他们开始尝试这种新叙事时，他们已经开始成长为一家大公司了。我记得 Bendov（Gong 的 CEO）对我说：“听着，Andy，”当时他们大约在 B 轮融资，大概是 2018 年，“我们会成为一家巨大的公司。问题是会有多大。我认为，如果我们能像 Zuora 或 Salesforce 那样搞定这个叙事，这将成为我们增长的乘数。”

---

### [00:14:38] [Andy Raskin]

**English:**
So I don't remember exactly the pitch beforehand, but it was very much like, "Hey, we're going to record your calls. We're going to get insights from them. They're better than the insights you could get from Salesforce." There wasn't this kind of unifying kind of movement ideology that put it all in context. And what was really interesting was one thing, I don't think they'd be upset if I shared, and maybe it's known. Initially, they were seen as a tool for sales operations, for someone who's going to record the calls and what this narrative did for them. And I think it was already starting to happen, but what it really coalesced was this is a tool for sales leadership.

**中文翻译:**
所以我不记得之前的推销词具体是怎么说的了，但大概就是：“嘿，我们会记录你的通话，从中获取洞察。这些洞察比你从 Salesforce 获得的更好。”当时还没有这种能把一切置于宏大背景下的统一的“运动意识形态”。非常有趣的一点是——我想如果我分享出来他们应该不会介意，也许这已经是公开的秘密了——最初，他们被视为销售运营（sales operations）的工具，是给那些记录通话的人用的。而这个叙事为他们做的是——我想这当时已经开始发生了，但叙事真正将其凝聚成了——这是一个为销售领导层（sales leadership）准备的工具。

---

### [00:15:23] [Lenny]

**English:**
You talked about Zuora in the post you wrote, and I imagine many people listening are like, "Oh, shit. This is the guy that wrote that post that everyone's always sharing with me about how to make a deck." And I wanted to ask, how impactful was that one piece of writing for you in your career, just like as a tangent?

**中文翻译:**
你在博文中提到了 Zuora，我想很多听众可能会想：“噢，天哪，原来他就是写那篇大家一直在转发给我的‘如何做 PPT’博文的人。”我想顺便问一下，那一篇文章对你的职业生涯产生了多大的影响？

---

### [00:15:39] [Andy Raskin]

**English:**
I had written some other posts on Medium in particular. Medium has changed quite a bit, but back then I found that I could write stuff there and get really a lot of people who were interested in what I was interested would sort of come in and create some noise about it. So I was already doing this kind of work for a couple of years, but that post immediately got something like 2 million views around the world and I started getting inquiries from teams all over the world.

**中文翻译:**
我之前在 Medium 上写过一些其他的文章。Medium 现在变了很多，但那时我发现我可以在那里写东西，吸引很多志同道合的人关注并引发讨论。当时我已经做这类工作几年了，但那篇文章迅速在全球获得了大约 200 万次的浏览量，我开始收到来自世界各地团队的咨询。

---

### [00:16:12] [Andy Raskin]

**English:**
And it was I think what really allowed me to say no, okay, I could do this work. That CEO's would budget a line item for this. Because I think if you really understand that post, it's not really about a sales deck, it's really about this story that Tien, the CEO is telling everywhere and that is showing up in the sales deck and structuring it that way.

**中文翻译:**
我想正是那篇文章让我确信：我可以以此为生，CEO 们会为此专门拨出预算。因为如果你真的读懂了那篇文章，你会发现它其实不是关于销售 PPT 的，而是关于 CEO Tien 在各个场合讲述的那个故事，以及如何将那个故事呈现在销售 PPT 中并以此进行结构化。

---

### [00:16:40] [Lenny]

**English:**
I think it's just another example that comes up a bunch on this podcast is just the power of writing and the power of content. Yeah, and you're shaking your head.

**中文翻译:**
我觉得这又是本播客中经常提到的一个例子：写作的力量和内容的力量。是的，你也在点头。

---

### [00:16:48] [Andy Raskin]

**English:**
Totally. I mean, I had a little mini career as a journalist, as a freelance writer and I really loved that. I actually, I took a class in New York called How to Write a Magazine Article, because I was sort of mid-career, I was curious. And the class wound up being more about how to sell a magazine article. And I found I really loved that, pitching articles, but one thing that was always a downer for me was there's always this editor sort of deciding what's going to be out there.

**中文翻译:**
完全正确。我曾有过一段短暂的记者和自由撰稿人生涯，我非常热爱那段经历。实际上，我在纽约参加过一个名为“如何撰写杂志文章”的课程，因为当时我正处于职业中期，对此很好奇。结果那个课程更多是关于如何“推销”杂志文章。我发现我非常喜欢推销文章，但有一点总是让我感到沮丧，那就是总有一个编辑在决定什么内容可以发布。

---

### [00:17:23] [Andy Raskin]

**English:**
And when you work with a great editor, it's great, they make yourself better and they're priceless. But still there's this intermediary. What started to happen, I think around when I started writing around 2013, '14, you start to see these platforms, like Medium, even LinkedIn where you can just write and have this audience and I think no way I could do this, the work I do if that development hadn't happened first.

**中文翻译:**
当你遇到一位优秀的编辑时，那感觉很棒，他们能让你变得更好，他们是无价之宝。但中间人依然存在。我想大约在我 2013、2014 年开始写作的时候，情况开始发生变化，你开始看到像 Medium 甚至 LinkedIn 这样的平台，你可以直接写作并拥有受众。我想，如果没有这些平台的发展，我根本无法从事我现在的工作。

---

### [00:17:53] [Lenny]

**English:**
I'm taking us off track, but I want to go a little deeper with this. I find that there's kind of two paths to writing online. One is your path where you write one piece that just blows up like crazy. The other path is more my path where I just write consistently for a long time, and both work and most people try to go your path and they never succeed. It's really hard to make something gets 2 million views, but you can go that path.

**中文翻译:**
我有点扯远了，但我还想深入探讨一下。我发现线上写作大概有两种路径。一种是你的路径，写出一篇爆款文章，然后彻底火了。另一种更像是我的路径，长期坚持不懈地写作。这两种方式都行得通，但大多数人尝试走你的路径却从未成功。要做出一个拥有 200 万浏览量的东西真的很难，但你确实做到了。

---

### [00:18:14] [Andy Raskin]

**English:**
This is like you said earlier, hey, it seems like boom, but really it didn't. So that was probably the 30th or 40th piece and they were gradually getting more and more traction. There was one I wrote before that about, it's kind of dissecting Elon Musk's pitch for the Powerwall, the battery that they sell. And that one got maybe few hundred thousand views and also was a big jump. And then the next one got some poultry number. So what I find is like, yeah, there's this a while where you're writing and it feels like you're talking to nobody and then gradually it grows and you'll have these peaks, but then over time is where the magic is.

**中文翻译:**
这就像你之前说的，嘿，看起来像是突然爆发，但其实并不是。那可能是我写的第 30 或 40 篇文章了，它们在逐渐获得越来越多的关注。在那之前我写过一篇关于剖析埃隆·马斯克推销 Powerwall（他们卖的电池）的文章。那篇大概有几十万的浏览量，也是一个巨大的飞跃。然后下一篇可能浏览量又很惨淡。所以我发现，确实有那么一段时间你在写作，感觉像是在对着空气说话，然后它逐渐增长，你会遇到一些高峰，但真正的魔力在于长期的积累。

---

### [00:19:03] [Lenny]

**English:**
Okay, I really glad you pointed that out, that it rarely is just you write one thing and it's boom.

**中文翻译:**
好的，我很高兴你指出了这一点，很少有写一篇文章就立刻爆发的情况。

---

### [00:19:08] [Andy Raskin]

**English:**
I'll also say, sorry, because I worked in a magazine, I haven't done a newsletter because that idea of having a deadline all the time and constantly having to, we used to call the magazine Feed the Beast, I feel so free not to have that. So for now at least I haven't done that.

**中文翻译:**
我还想说，抱歉，因为我曾在杂志社工作过，所以我一直没做时事通讯（newsletter），因为那种时刻面临截止日期、不断需要“喂饱这头怪兽”（我们以前对杂志的称呼）的想法让我压力很大。没有这些束缚让我感到非常自由。所以至少到目前为止，我还没做那个。

---

### [00:19:27] [Lenny]

**English:**
I know that well, so let me take us back on track and let's talk about just the high level framework here. So you talked about, it starts with this idea of tell people worlds changing, join this movement. What's the simple way to think about this, the pieces of this strategic narrative framework?

**中文翻译:**
我很理解那种感觉。那让我们回到正轨，谈谈这个高层级的框架。你提到它始于这样一个想法：告诉人们世界正在改变，加入这场运动。那么，思考这个战略叙事框架的组成部分，有没有什么简单的方法？

---

### [00:19:42] [Andy Raskin]

**English:**
A lot of times people will contact me, say, "Hey, I tried it, didn't work." Well, one very common thing, at least earlier was they would basically just take the Zuora deck, they'd get ahold of it and just put their logo on it. And so that's not going to work. One thing is we're not just saying, "Hey, the world is changing." And then sometimes I'll see, "The world is changing," and there'll be, "Used to be," and there's a long list of things and then, "Now it is," a long list of bullet points.

**中文翻译:**
很多时候人们联系我说：“嘿，我试过了，没用。”嗯，一个非常常见的情况（至少在早期是这样）是，他们基本上只是拿到了 Zuora 的 PPT，然后换上自己的 Logo。那当然行不通。首先，我们不只是在说“嘿，世界正在改变”。有时我会看到有人写“世界正在改变”，然后列出一长串“过去是怎样”，接着又是一长串“现在是怎样”的要点。

---

### [00:20:11] [Andy Raskin]

**English:**
What's really, I think key is naming it, naming that old game. The examples you saw, software, cloud, transactions, subscription opinions, reality. This very, very concise naming is really key. And it's hard because in making it compact you're losing completeness. So you can imagine you're in a meeting, someone says like, "Hey, how about we do transactions to subscriptions?" And someone says, "Well I don't know, there's a lot of things I don't really subscribe to. Subscription economy, really?" So we're always kind of overstating it in a way, but it's not a problem. I don't think people say like, "Oh that's wrong, subscription economy, because I still go to the grocery store and buy things." So anyway, that's the first piece.

**中文翻译:**
我认为真正的关键在于“命名”，命名那个“旧游戏”。你看到的例子：软件、云、交易、订阅、主观意见、现实。这种非常非常简洁的命名至关重要。这很难，因为在追求简洁的同时，你会失去完整性。你可以想象你在开会，有人说：“嘿，我们把‘交易到订阅’作为主题怎么样？”另一个人说：“嗯，我不知道，有很多东西我并没有订阅啊。订阅经济，真的吗？”所以我们在某种程度上总是在夸大其词，但这没问题。我不认为人们会说：“噢，订阅经济是错的，因为我还是会去超市买东西。”总之，这是第一部分。

---

### [00:20:59] [Andy Raskin]

**English:**
The second piece is what I call naming the stakes. And there's a few ways to do this, but one that's really great if we can do it is to name the winners to show that winners are already playing this new game. So for instance with Zuora they're saying, "Hey, look, look at all the new winners," this is like 2015 so, "Airbnb, Box," all these companies, they're already doing this subscription thing.

**中文翻译:**
第二部分是我所谓的“明确利害关系”（naming the stakes）。有几种方法可以做到这一点，但如果可以的话，最棒的一种方法是列举“赢家”，以展示赢家们已经在玩这个新游戏了。例如，Zuora 会说：“嘿，看，看看所有这些新的赢家，”那是 2015 年左右，“Airbnb、Box，”所有这些公司，它们已经在做订阅这件事了。

---

### [00:21:28] [Andy Raskin]

**English:**
And by the way, overall they show this scary stat about the longevity of Fortune 500 companies. It's getting smaller, and so it's a little disingenuous, but basically they make this case that, "Hey, companies are dying, the ones that are winning are doing this." And so to the extent we want to make this life and death just like a movie. This is again, I'll make the parallel to Star Wars. So Luke, he spends the first 15 minutes of the movie belly aching. He wants to be a pilot, he wants to go out and have adventures in space. So Obiwan comes, he says, "Hey, we got this mission, this princess we got to go," and all this stuff, "Let's go. I'll teach you to be a pilot. We'll go have adventures in space." What does Luke say? He says, "Ooh, you know what, I can't really get involved. They got to go home. It's late." Who does this sound like? The reluctant buyer.

**中文翻译:**
顺便说一下，总的来说，他们展示了一个关于《财富》500 强公司寿命的惊人统计数据。寿命正在变短。虽然这有点以偏概全，但基本上他们建立了一个论点：“嘿，公司正在消亡，而那些获胜的公司正在这样做。”所以我们要像电影一样，把这上升到生死存亡的高度。我再次以《星球大战》为例。卢克在电影的前 15 分钟里一直在抱怨。他想当飞行员，想去太空冒险。于是欧比旺来了，他说：“嘿，我们有任务，我们要去救这位公主，”等等，“走吧，我教你当飞行员，我们去太空冒险。”卢克怎么说？他说：“噢，你知道吗，我真的不能参与。我得回家了，太晚了。”这听起来像谁？像那些犹豫不决的买家。

---

### [00:22:27] [Andy Raskin]

**English:**
So yeah, "I want to be innovative and all this. Ooh, you know what? I don't have budget this quarter." So how does George Lucas change Luke's mind? He basically kills the aunt and uncle, sorry, spoilers, it's been 40 years though. If you haven't seen it, you're probably not going to see it. Kills the aunt and uncle. Now it's pretty clear they're coming for Luke. Now the stakes are life and death. Probably he's going to be dead. But there is this other path that Obiwan holds out for him.

**中文翻译:**
所以，买家会说：“是的，我想创新，想做这些。噢，你知道吗？我这季度没预算。”那么乔治·卢卡斯是如何改变卢克的想法的呢？他基本上杀死了卢克的叔叔和婶婶——抱歉剧透了，不过都过去 40 年了，如果你还没看，估计也不会看了。杀死了叔叔和婶婶后，很明显敌人是冲着卢克来的。现在利害关系变成了生死存亡。他很可能会死。但欧比旺为他指出了另一条路。

---

### [00:22:55] [Andy Raskin]

**English:**
And whenever I work with teams and I talk about this, so they're like, "Okay, I guess we got to then for kill the prospect's aunt and uncle," and basically yes, I mean figuratively. We got to show them that the future is not going to just be sort of okay. People talk about making it emotional and I've always wondered, what does that mean? Literally, what is the definition? This is for me the definition, is that the prospect doesn't see the future as sort of okay. They see it as split between a very negative outcome and a potentially very positive outcome.

**中文翻译:**
每当我与团队合作谈到这一点时，他们会说：“好吧，我想我们得‘杀死’潜在客户的叔叔和婶婶了。”基本上是的，我是指比喻意义上的。我们必须向他们展示，未来不会只是“还凑合”。人们谈论要让叙事具有情感，我一直在想，那到底是什么意思？字面定义是什么？对我来说，定义就是：潜在客户不再认为未来是“还凑合”的。他们看到未来分化为：一个非常负面的结果和一个潜在的非常正面的结果。

---

### [00:23:29] [Andy Raskin]

**English:**
The third piece is what I call naming the object of the new game. I used to call it the promised land message, but I've changed it to this because I've found that it's sort of a little more fruitful. This subscription economy, transactions, it can get a little highfalutin and sort of big, but on the website when we just have to boil it down to a couple of words that's going to be clear right away, what can we say? And I find that what's the object of the new game really boils it down as kind of the rallying cry of the movement. So the example with Zuora, the object for a while was turn customers into subscribers. Very simple. It just sort of flows from it. Airbnb for a while had this one, live anywhere. If you think about-

**中文翻译:**
第三部分是我所谓的“命名新游戏的目标”。我以前称之为“应许之地”（promised land）信息，但我现在改成了这个说法，因为我发现它更有效。订阅经济、交易，这些词可能有点高大上且宏大，但在网站上，当我们必须将其浓缩为几个能立刻让人明白的词时，我们该说什么？我发现，“新游戏的目标是什么”能将其浓缩为这场运动的战斗口号。以 Zuora 为例，有一段时间他们的目标是“将客户转变为订阅者”。非常简单，顺理成章。Airbnb 有一段时间用的是“居住在任何地方”（live anywhere）。如果你想想——

---

### [00:24:21] [Lenny]

**English:**
Belong anywhere.

**中文翻译:**
四海为家（Belong anywhere）。

---

### [00:24:23] [Andy Raskin]

**English:**
Well actually it was-

**中文翻译:**
嗯，实际上是……

---

### [00:24:24] [Lenny]

**English:**
Oh, live like a human.

**中文翻译:**
噢，“像人一样生活”。

---

### [00:24:25] [Andy Raskin]

**English:**
So you're right, it was, "Belong anywhere," and then it switched to, "Live there." I may have the chronology wrong, but it was the two of those things. You know better than I do. But either one, I mean think they're saying very similar things. Hey, there's this new world where you don't have to live in hotels, you can stay in people's houses. What's the object of that game is to belong anywhere, but live there. And I love it when it works that way where it's almost like an asymptotically unachievable thing. You are never literally going to live there. And if you think about it, this buyer mission statement, this rallying cry, I think of it really as the mission of the company. I mean, what is the mission of Airbnb other than to help people live there if they're going to be customer focused and all that?

**中文翻译:**
你是对的，是“四海为家”，然后变成了“住在那里”（Live there）。我可能记错了先后顺序，但就是这两个。你比我更清楚。但无论哪一个，我想它们表达的意思都非常相似。嘿，现在有一个新世界，你不需要住在酒店里，你可以住在别人的家里。那个游戏的目标就是“四海为家”，并且“住在那里”。我喜欢这种方式，它几乎像是一个渐进式但无法完全达到的目标。你不可能真的永远住在那里。如果你仔细想想，这个买家使命宣言、这个战斗口号，我真的把它看作是公司的使命。我是说，如果 Airbnb 要以客户为中心，除了帮助人们“住在那里”，它的使命还能是什么呢？

---

### [00:25:17] [Andy Raskin]

**English:**
The fourth piece is, okay, well this object of the game, winning this game, it better be hard because if it's not, why would we even exist? Just with the movie, if Luke can just go destroy the Death Star then no movie. So there's got to be sort of obstacles in the way, things that are preventing them from. So saying, "Okay, you want to turn customers into subscribers." So whereas Zuora, where they go next is to say, "Okay, well how are you going to measure lifetime value?" Because now you have this always on thing. "How are you going to measure preferences and how they're changing over?" All these new kind of challenges that didn't exist before. And then these are like the monsters in Lord of the Rings or the Empire in Star Wars, these are the obstacles.

**中文翻译:**
第四部分是，好吧，这个游戏的目标、赢得这个游戏，最好是困难的，因为如果不难，我们为什么还要存在？就像电影一样，如果卢克能直接去摧毁死星，那就没电影可拍了。所以必须有障碍，有阻止他们实现目标的东西。比如，“好吧，你想把客户变成订阅者。”那么 Zuora 接下来会说：“好吧，那你打算如何衡量终身价值（LTV）？”因为现在这是一个持续的过程。“你打算如何衡量偏好以及它们是如何变化的？”所有这些以前不存在的新挑战。这些就像《指环王》里的怪兽或《星球大战》里的帝国，它们就是障碍。

---

### [00:26:11] [Andy Raskin]

**English:**
I think about them because they sound like problems. This is what people would normally say, "Oh, these are the problems we solve." But by setting up this story thing first we've repackaged them as obstacles to a new goal state that we've already positioned as life and death. So they take on this much more emotional meaning. We understand why they matter. And then of course the last piece is now talking about, well, how are we going to overcome these obstacles? Narrative people, in the movie business they call these the magic gifts that the main character gets to go help them win. What are the ways? Now we can talk about that and success stories and all the rest of the stuff.

**中文翻译:**
我思考这些障碍，因为它们听起来像“问题”。通常人们会说：“噢，这些是我们解决的问题。”但通过先建立这个故事背景，我们将它们重新包装成了通往新目标状态的“障碍”，而这个目标状态我们已经将其定位为生死攸关。因此，它们具有了更深层的情感意义。我们理解了它们为什么重要。当然，最后一部分就是讨论：好吧，我们该如何克服这些障碍？在电影界，叙事专家称之为主角获得的、帮助他们获胜的“神奇礼物”。有哪些方法？现在我们可以谈论这些方法、成功案例以及其他所有内容了。

---

### [00:26:58] [Lenny]

**English:**
There's some obvious parallels to the hero's journey here. I imagine that it was a source of inspiration, and the Star Wars I think is the epitome of that journey. Can you talk about just how related those two are, how you think about that?

**中文翻译:**
这与“英雄之旅”（hero's journey）有明显的相似之处。我猜那是你的灵感来源之一，而我认为《星球大战》是这种旅程的缩影。你能谈谈这两者之间的联系，以及你是如何看待它们的吗？

---

### [00:27:09] [Andy Raskin]

**English:**
Yeah, I mean so hero's journey is this book that comes from, I think it's Hero of A Thousand Faces is a book by Joseph Campbell, a sociologist. He looks at myths over different cultures and different times and he finds this kind of common structure that he calls the hero's journey. I mean it's some controversy about that, about his book. Is it a very male oriented sort of take on things and a bunch of things.

**中文翻译:**
是的，我是说，“英雄之旅”源自约瑟夫·坎贝尔（Joseph Campbell）的一本书，我想是《千面英雄》。他是一位社会学家，他研究了不同文化、不同时代的神话，发现了一种共同的结构，他称之为“英雄之旅”。当然，关于他的书也有一些争议，比如它是否过于以男性为中心等等。

---

### [00:27:38] [Andy Raskin]

**English:**
But even that aside, I found when I would talk about hero's journey and stuff, it's just like, it didn't really tell me what to do. Yeah, okay, yeah I got to do this pitch. So in the hero's journey there's like refusal of the call. That's actually that thing where Luke says he doesn't want to go and where the buyer says, "Hey, I don't have budget." But I don't know, it was just too theoretical for me to really ... when I use it, people seem to sort of glass over. So I just don't really talk about that at all. But yeah, I mean that's behind a lot of this stuff for sure.

**中文翻译:**
但撇开这些不谈，我发现当我谈论“英雄之旅”之类的东西时，它并没有真正告诉我该怎么做。是的，好吧，我得做这个推销。在英雄之旅中，有“拒绝召唤”这一环。这实际上就是卢克说他不想去，以及买家说“嘿，我没预算”的时候。但我不知道，对我来说它太理论化了……当我使用它时，人们似乎听得云里雾里。所以我根本不怎么谈论它。但没错，它确实是很多这些东西背后的基础。

---

### [00:28:17] [Lenny]

**English:**
Yeah, that makes sense because I think if people hear about that all the time when they're like, become a better storyteller, tell your story in this hero's journey, and it's like, "I don't know what I'm doing."

**中文翻译:**
是的，这很有道理，因为我想如果人们总是听到“成为更好的讲故事的人”、“用英雄之旅讲你的故事”，他们会觉得“我还是不知道该怎么做”。

---

### [00:28:25] [Andy Raskin]

**English:**
Also, I would say there's storytelling as a skill kind of thing, which is a great thing. Learn how to tell stories better, blah, blah, blah, blah. I'm not really interested in that in my work, what I'm interested in is the one story and the structure of that one story. And this one story, it doesn't really have ... like, the world is moved from transactions to subscriptions. There's not a main character in that story who's like having a problem and getting saved. It's almost as if what's happening is we're turning the person we talk to into the main character. By spelling out the shift, we're changing their world and we're saying, "Hey, you got to change and you want to come with us."

**中文翻译:**
此外，我想说讲故事（storytelling）可以被看作一种技能，这很好。学习如何更好地讲故事，等等。但在我的工作中，我并不真正对那感兴趣，我感兴趣的是“那一个故事”以及“那一个故事的结构”。而这一个故事，它并不真的……比如，“世界从交易转向订阅”。在这个故事里并没有一个遇到问题并获救的主角。这几乎就像是，我们正在把与我们交谈的人变成主角。通过阐明这种转变，我们正在改变他们的世界，并说：“嘿，你必须改变，你想和我们一起走吗？”

---

### [00:29:13] [Lenny]

**English:**
It's almost like you're putting them into the hero's journey, like, "Here's how you win."

**中文翻译:**
这几乎就像是你把他们带入了英雄之旅，告诉他们“这就是你获胜的方式”。

---

### [00:29:16] [Andy Raskin]

**English:**
Exactly. I love that.

**中文翻译:**
没错，我喜欢这个说法。

---

### [00:29:18] [Lenny]

**English:**
Let me just try to summarize what you shared, this five step framework. So you start with here's a new movement that's happening and you want to name it, you want to name the stakes and there's winners and losers and here's already happening and it's really important. Then you want to name the object of the new game, like turning customers into subscribers. Then show the obstacles, here's why it's challenging, and then talk about how you're going to overcome these obstacles.

**中文翻译:**
让我试着总结一下你分享的内容，这个五步框架。首先，从正在发生的新运动开始，你要为它命名，明确利害关系，指出赢家和输家，说明它已经在发生且至关重要。然后，命名新游戏的目标，比如“将客户转变为订阅者”。接着，展示障碍，说明为什么这具有挑战性。最后，谈谈你将如何克服这些障碍。

---

### [00:29:41] [Andy Raskin]

**English:**
And by the way, the naming of the object of the new game, I find it often is really nice to do it as a question. So we hey, there's this shift from transactions to subscriptions and look, everyone's doing it. So we asked a simple question, what would it take to turn every customer into a subscriber? And this way we're kind of bringing the person we're pitching to almost like they're coming along with us as a co, I don't know, adventurer in crafting this story.

**中文翻译:**
顺便说一下，关于新游戏目标的命名，我发现以问题的形式提出通常效果很好。比如：“嘿，现在发生了从交易到订阅的转变，看，大家都在这么做。所以我们问了一个简单的问题：如何才能将每一位客户都转变为订阅者？”通过这种方式，我们把推销对象带了进来，让他们感觉像是和我们一起构思这个故事的……我不知道该怎么说，共同冒险者。

---

### [00:30:17] [Lenny]

**English:**
This episode is brought to you by Eco. Last month Eco users earned an average of $84 in cash back rewards. How? With Eco the future of personal finance. Eco is the update to a misaligned financial system providing an app that works just like your bank but removes almost all of the middlemen, helping even the best money optimizers optimize in less time automatically.

**中文翻译:**
本集节目由 Eco 赞助。上个月，Eco 用户平均获得了 84 美元的现金返还奖励。怎么做到的？通过 Eco，个人理财的未来。Eco 是对失调的金融系统的更新，它提供了一个像银行一样运作的应用，但去除了几乎所有的中间商，帮助即使是最擅长理财的人也能在更短的时间内自动优化财务。

---

### [00:30:40] [Lenny]

**English:**
What if you earn rewards for paying your rent or got rewarded for ordering food and shopping online or even earn rewards for saving each month? And then imagine if you got rewarded again just for getting rewarded. With Eco, you can spend at some of your favorite merchants and automatically get 5% cash back plus Eco's APY rewards look more like $80, not 80 cents. And then there are Eco points, the world's first open reward system. You earn them whenever you do almost anything in the eco app. Eco is working to make these points the most rewarding points ever so it pays to be early.

**中文翻译:**
如果你付房租能赚奖励，订餐和网购能得奖励，甚至每月存钱也能得奖励，那会怎样？再想象一下，如果你仅仅因为获得了奖励而再次获得奖励。通过 Eco，你可以在一些你最喜欢的商家消费并自动获得 5% 的现金返还，此外 Eco 的年化收益（APY）奖励更像是 80 美元，而不是 80 美分。还有 Eco 积分，这是世界上第一个开放式奖励系统。只要你在 Eco 应用中进行几乎任何操作，都能赚取积分。Eco 致力于让这些积分成为有史以来最有价值的积分，所以越早加入越划算。

---

### [00:31:13] [Lenny]

**English:**
Sound too good to be true? Go to Eco.com/Lenny, sign up for an onboarding and find out why it isn't. Lenny's podcast listeners who attend an Eco welcome session will get an exclusive 4% APY on deposits over $1,000. Learn more at Eco.com/Lenny, that's E-C-O.com/Lenny. Maybe just to reinforce this even more, what if we go through the five steps and just with one company as an example and just talk about what each of those were for them?

**中文翻译:**
听起来好得令人难以置信？访问 Eco.com/Lenny，注册参加新手引导，看看为什么它是真的。参加 Eco 欢迎会的 Lenny 播客听众，存款超过 1000 美元即可获得独家 4% 的年化收益。欲了解更多信息，请访问 Eco.com/Lenny，即 E-C-O.com/Lenny。为了进一步巩固这一点，我们能不能以一家公司为例，走一遍这五个步骤，谈谈每一个步骤对他们来说意味着什么？

---

### [00:31:41] [Lenny]

**English:**
Okay, great. So there's a company called 360Learning. So this company, I don't know if folks know, but this company is raised over $200 million. They're in the space of corporate training software. So big companies, they have to train their people on all kinds of stuff. So you want to go through that one?

**中文翻译:**
好的，太棒了。有一家公司叫 360Learning。我不知道大家是否了解，这家公司已经融资超过 2 亿美元。他们从事企业培训软件领域。大公司必须对员工进行各种培训。你想聊聊这家公司吗？

---

### [00:32:01] [Andy Raskin]

**English:**
Yeah, that sounds great.

**中文翻译:**
好啊，听起来不错。

---

### [00:32:03] [Andy Raskin]

**English:**
Okay, great. By the way, Nick Hernandez is the CEO and Nick's been on my podcast, so he's talked about this. So they for a long time were pitching themselves as collaborative learning. So they have features that let people sort of collaborate on courses and all kinds of stuff. And Nick is often pitching CEOs, of course his team is as well. And he told me that it was sort of falling a little bit flat. People, collaborative learning, whatever. How are you different from this learning platform, this learning platform?

**中文翻译:**
好的。顺便说一下，Nick Hernandez 是他们的 CEO，Nick 上过我的播客，所以他谈过这件事。长期以来，他们一直把自己推销为“协作式学习”（collaborative learning）。他们有一些功能，让人们可以在课程和各种事情上进行协作。Nick 经常向 CEO 们推销，当然他的团队也是。他告诉我，这种说法有点反响平平。人们会觉得，协作式学习，那又怎样？你和这个学习平台、那个学习平台有什么区别？

---

### [00:32:42] [Andy Raskin]

**English:**
And so when we worked together this collaborative learning, it's almost like a category name or a descriptor or something. They were so embedded that I decided, I don't even want to take it out, but can we define it in terms of a story? So the story they came to was, hey, used to be that companies train their people through basically a mindset of top-down learning. There's going to be some learning guru at the company, they're going to get all the courses, they're going to put it all together and sort of send out this training material to everybody.

**中文翻译:**
所以当我们合作时，这种“协作式学习”几乎就像是一个品类名称或描述词之类的。它们已经根深蒂固了，所以我决定甚至不想把它去掉，但我们能不能用故事的形式来定义它？于是他们想出的故事是：嘿，过去公司培训员工基本上是靠“自上而下学习”的思维。公司里会有某个学习专家，他们获取所有课程，把它们整合在一起，然后把这些培训材料发给每个人。

---

### [00:33:23] [Andy Raskin]

**English:**
What's happening now is winning companies are approaching this differently. They're adopting this approach we might call upskill from within, which is if you look at Google, there's this page where I think you can go, it's a public. You can connect with Google's AI experts. They literally turn their internal experts into champions that are educating, not even just the company but even external people. They've created this culture of our own people are going to be the educators. So that's the shift from top down to this upskill from within. And of course I just even started to do the second piece which was like, hey, look at the big companies who are doing this.

**中文翻译:**
现在发生的情况是，获胜的公司正在以不同的方式处理这件事。他们采用了一种我们可能称之为“内部技能提升”（upskill from within）的方法。如果你看谷歌，有一个公开页面，你可以联系谷歌的 AI 专家。他们真的把内部专家变成了“冠军”，这些专家不仅在教育公司内部，甚至在教育外部人员。他们创造了一种“我们自己的人就是教育者”的文化。所以这就是从“自上而下”到“内部技能提升”的转变。当然，我刚才甚至已经开始讲第二部分了，也就是：嘿，看看那些正在这样做的大公司。

---

### [00:34:10] [Andy Raskin]

**English:**
And then I think they showed, "Hey, you're not doing this. Look, training is becoming very expensive. People don't care. So this is the downside. So we're creating these sort of stake ..." And also I think he has something about how training now, like companies, if you don't adapt, if you can't get these skills to your people, if you're a car company and you can't get these skills around electric cars, you're dead.

**中文翻译:**
然后我想他们展示了：“嘿，你还没这样做。看，培训正变得非常昂贵，员工也不在乎。这就是负面影响。所以我们正在建立这种利害关系……”而且我想他还提到，现在的培训对公司来说，如果你不适应，如果你不能让你的员工掌握这些技能——如果你是一家汽车公司，而你不能让员工掌握电动汽车相关的技能，你就死定了。

---

### [00:34:35] [Andy Raskin]

**English:**
Nick was in France and he saw this poster, a recruiting poster from McDonald's and it said, "Hey, if you work at McDonald's you're going to learn from everybody else on your team." And it was like, wow, there it is. So there's another example we used as a kind of winner example. And so then the question became, I can't remember exactly, it was something like, how do you upskill from within? What would it take for you to turn your experts into champions of learning in the company and turn them into stars, and all this?

**中文翻译:**
Nick 当时在法国，他看到了一张海报，是麦当劳的招聘海报，上面写着：“嘿，如果你在麦当劳工作，你会向团队中的每一个人学习。”当时就觉得，哇，就是这个。所以这是我们作为“赢家案例”使用的另一个例子。接下来的问题变成了——我不记得确切的措辞了，大概是——你如何实现内部技能提升？如何才能让你的专家成为公司里的学习冠军，把他们变成明星，等等？

---

### [00:35:06] [Andy Raskin]

**English:**
And then I'm going to forget here what all the obstacles were. But I think it was things like, well, how are you going to make it possible for anybody to create a course? People who might have expertise in electric engines but don't know how to create a course, how are you going to make sure that there's still the learning department, they're going to keep control and can ... all this. You can imagine all the different kind of questions. And then of course now 360Learning starts talking about all that stuff.

**中文翻译:**
然后我不记得所有的障碍是什么了。但我认为障碍包括：你如何让任何人都能创建课程？那些可能拥有电动引擎专业知识但不知道如何创建课程的人该怎么办？你如何确保学习部门仍然能保持控制并能够……等等。你可以想象所有这些不同类型的问题。当然，现在 360Learning 开始谈论所有这些东西了。

---

### [00:35:36] [Andy Raskin]

**English:**
What Nick has told me, I'm actually going to be on a webinar with Nick where someone asked me, "Could you bring in a CEO who could talk about this stuff? Not just you B blabbing on about strategic narrative." And so Nick is going to join it. And we had a dress rehearsal the other day and he was telling me it's just like when he starts with this now he doesn't even get the question anymore of well how are you different from this other learning platform? Which used to always be the thing. It's just a much more seamless, okay, yeah, talk to our learning people, get this going. So it's just sounds like it's been really effective for them.

**中文翻译:**
Nick 告诉我——实际上我要和 Nick 一起参加一个网络研讨会，有人问我：“你能不能请一位 CEO 来谈谈这些东西？不只是你一个人在那儿瞎扯战略叙事。”所以 Nick 会参加。我们前几天进行了彩排，他告诉我，现在当他以这种方式开始推销时，他甚至再也听不到“你和那个学习平台有什么区别”之类的问题了，而这在以前总是避不开的。现在变得更加顺畅了，对方会说：“好的，没问题，去和我们的学习部门谈谈，把这件事办了。”所以听起来这对他们非常有效。

---

### [00:36:13] [Lenny]

**English:**
That's actually was what I was going to ask next is what kind of impact have you seen with someone shifting their pitch story from this doc? What was the arrogant doctor approach to the strategic narrative?

**中文翻译:**
这正是我接下来想问的：当你看到有人将他们的推销故事从那种“傲慢的医生”模式转变为“战略叙事”模式时，你观察到了什么样的影响？

---

### [00:36:23] [Andy Raskin]

**English:**
Yeah, I mean it's always this kind of thing I hear. I mean, of course it's very difficult to measure this. I mean, what was the value of the strategic narrative for Gong and its growth? Was it 3X versus 1X, 2X? Or I don't, who knows, right? But the things I hear from CEOs, a few things. One is that when they're pitching, they're not pitching features out of context, they're pitching now a movement which is a lot better place to be, I think. In a way you're not pitching product. Product is like a prop for making the story come true. Very important prop, but there's this higher level overlay that becomes the focus of the conversation, at first, and of course we're going to get into product and that helps sell. Once we have this story then everything in marketing can be all about this story.

**中文翻译:**
是的，我听到的反馈通常是这样的。当然，这很难衡量。战略叙事对 Gong 及其增长的价值到底是多少？是 3 倍、1 倍还是 2 倍？谁知道呢，对吧？但我从 CEO 们那里听到了一些东西。一是当他们推销时，他们不再是脱离背景地推销功能，而是在推销一场“运动”，我认为这是一种好得多的姿态。在某种程度上，你不是在推销产品。产品就像是让故事成真的道具。非常重要的道具，但首先成为对话焦点的是这个更高层级的背景。当然，我们之后会深入探讨产品，那有助于销售。一旦我们有了这个故事，营销中的一切都可以围绕这个故事展开。

---

### [00:37:21] [Andy Raskin]

**English:**
With Zuora, if you look at their website, well when they first started doing this, maybe 80% of the content is not, "Hey, let me tell you about how Zuora is so great," or, "Here's our new release," or whatever. It's, "Here's how music companies are embracing subscriptions. Here's how luxury goods companies are embracing subscriptions." It's all these kind of almost trend pieces that become unlimited fodder. And again, you're not touting your ... it's less salesy, right?

**中文翻译:**
以 Zuora 为例，如果你看他们的网站，在他们刚开始这样做的时候，可能 80% 的内容都不是“嘿，让我告诉你 Zuora 有多棒”或者“这是我们的新版本”之类的。而是“音乐公司是如何拥抱订阅模式的”、“奢侈品公司是如何拥抱订阅模式的”。这些几乎都是趋势性的文章，成为了源源不断的素材。而且，你不是在吹嘘自己……推销味儿没那么重，对吧？

---

### [00:37:51] [Andy Raskin]

**English:**
Another thing I just hear always, I just interviewed a CEO this morning for my podcast and this is the first thing he actually said was, "It becomes the strategic north star for the product." So what he was telling me, and this was actually a little unusual, I asked him, "Why did you come to me at first?" And of course I'd asked him that before, but he said something this time that was a little different from what I'd heard before. He said, "We are constantly getting feature requests through sales, through customer success. And we had sort of no way, bar to decide well what do we take on, what don't we take on? And this clearly has become our bar."

**中文翻译:**
我经常听到的另一件事是——今天早上我刚为我的播客采访了一位 CEO，这是他说的第一句话——“它成为了产品的战略北极星。”他告诉我——这其实有点不同寻常，我问他：“你最初为什么来找我？”当然我以前也问过他，但这次他说了一些和我以前听到的不太一样的东西。他说：“我们不断通过销售、通过客户成功收到功能请求。我们以前没有标准来决定哪些该做，哪些不该做。而这显然已经成为了我们的标准。”

---

### [00:38:38] [Andy Raskin]

**English:**
If you think about it for 360Learning, does it help us upskill from within? It's in. Does it not? Or it's prioritized. Does it not? Less prioritized. Amit Bendov told me this directly, he said we exactly the same thing. He said, "We get a lot of requests for features and a lot of them are basically about opinions, some way to record opinions."

**中文翻译:**
想想看，对于 360Learning 来说，这个功能是否有助于“内部技能提升”？如果是，就做。如果不是，或者优先级较低。Amit Bendov 直接告诉过我，他说他们也是完全一样的情况。他说：“我们收到很多功能请求，其中很多基本上是关于‘主观意见’的，某种记录主观意见的方式。”

---

### [00:39:04] [Andy Raskin]

**English:**
And this is Gong.

**中文翻译:**
这是在说 Gong。

---

### [00:39:04] [Andy Raskin]

**English:**
"We're not going to do those." In Gong, yeah. "We're not going to do those."

**中文翻译:**
“我们不会做那些。”在 Gong，是的，“我们不会做那些。”

---

### [00:39:08] [Lenny]

**English:**
Are there any companies out there that maybe aren't clients that you see as like, wow, these guys are nailing it and they're doing a great job of this strategic narrative?

**中文翻译:**
有没有哪些公司可能不是你的客户，但你觉得“哇，这些家伙做得太棒了，他们在战略叙事方面做得非常出色”？

---

### [00:39:15] [Andy Raskin]

**English:**
Well, one that really comes to mind is, I mean it's been out there for a while, but Drift. Drift comes out with essentially like a chatbot for your website, which might be the 30th chatbot for your website. And they don't say, "Hey, here's why our chatbot is the best one." They start from a completely different place, which is, "Hey, used to be people would sort of wait around for you to get back to them. It was a world of later. They called it the world of forms. You put up a web form and you expect someone's going to fill it out and maybe wait a few days while you take your sweet time deciding if you're going to get back to them."

**中文翻译:**
嗯，我立刻想到的一家公司是 Drift，虽然它已经存在一段时间了。Drift 推出的本质上是一个网站聊天机器人，这可能是市面上第 30 个聊天机器人了。他们没有说：“嘿，这就是为什么我们的聊天机器人是最好的。”他们从一个完全不同的角度切入：“嘿，过去人们总是等着你回复。那是一个‘稍后’的世界。他们称之为‘表单世界’。你放一个网页表单，期望有人去填，然后可能等上几天，而你则慢悠悠地决定是否要回复他们。”

---

### [00:39:58] [Andy Raskin]

**English:**
And David Cancel and David Gerhardt started from right the beginning saying, "Now we're in a world of now, where buyers are ..." I think they showed this woman, I remember it was this woman sleeping with her phone. That's your prospect. They're always on and they're going to expect you to be engaging with them right away. And they called this conversational marketing, and they really went with that and created I think a whole movement and they broke away from all of the other chatbots.

**中文翻译:**
David Cancel 和 David Gerhardt 从一开始就说：“现在我们处于一个‘当下’的世界，买家们……”我想他们展示了一个女人，我记得是那个抱着手机睡觉的女人。那就是你的潜在客户。他们时刻在线，并期望你能立即与他们互动。他们称之为“对话式营销”（conversational marketing），他们真的贯彻了这一点，我认为这创造了一场运动，让他们从所有其他聊天机器人中脱颖而出。

---

### [00:40:35] [Lenny]

**English:**
Awesome example. So earlier you threw out this word category, and I've noticed you haven't talked about category and category creation too much, and I think that you're kind of not a fan of this idea of creating a category and focusing on category. I'd love to hear your perspective on how that all relates to the stuff you recommend.

**中文翻译:**
很棒的例子。刚才你提到了“品类”这个词，我注意到你并没有过多谈论品类和品类创造，我觉得你似乎不太喜欢“创造品类”和“关注品类”这个想法。我很想听听你对这与你推荐的内容之间关系的看法。

---

### [00:40:55] [Andy Raskin]

**English:**
Lenny, are you trying to get me in trouble? Like that guy who guy on your podcast who attacked jobs to be done?

**中文翻译:**
Lenny，你是想让我惹上麻烦吗？就像你播客里那个攻击“待办任务”（jobs to be done）理论的家伙一样？

---

### [00:41:02] [Lenny]

**English:**
Apparently, let's do it. Let's see what kind of trouble we can get into.

**中文翻译:**
显然是这样，来吧。看看我们会惹上什么麻烦。

---

### [00:41:06] [Andy Raskin]

**English:**
I would soften it a little bit and not just ... because I don't want the ire of the category design folks, but I really would soften and say, I wouldn't say I'm not a fan of creating category. Look, I think if you look at Play Bigger, which has become The Bible of that category creation thing, if you look behind that going to, what do they say the category is? They say it's a narrative. It's a story about how the world was to how it is. And so what I find though is that when people think about category creation, they tend to just focus on, okay, well, what is this category name going to be that we got? What are these three words or two words, whatever, that are going to magically make us seem like we're totally different from everybody else?

**中文翻译:**
我会说得委婉一点，不只是……因为我不想激怒那些做品类设计的人。我真的会委婉地说，我不会说我不支持创造品类。你看，如果你读过《Play Bigger》（这书已经成了品类创造领域的圣经），如果你看它背后的逻辑，他们说品类是什么？他们说品类就是一种叙事。是一个关于世界过去如何、现在如何的故事。但我发现，当人们思考品类创造时，他们往往只关注：好吧，我们要用的这个品类名称是什么？哪三个词或两个词能神奇地让我们看起来与众不同？

---

### [00:41:52] [Andy Raskin]

**English:**
And A, I think that's not really possible. These three words aren't going to do it. Take Gong, I mean already other companies were using this term revenue intelligence. With Gong, it suddenly becomes a thing because I think they have this opinions-to-reality story behind it. At one point, again, I asked Amit, he said, "Yeah," because I remember he really struggled, "What should we call it? What should we call it?"

**中文翻译:**
首先，我认为这不太可能。这三个词本身起不了作用。以 Gong 为例，当时已经有其他公司在使用“营收智能”（revenue intelligence）这个词了。但在 Gong 这里，它突然火了，因为我认为他们背后有那个“从主观意见到现实”的故事。有一次，我再次问 Amit，他说：“是的，”因为我记得他当时真的很纠结，“我们该叫它什么？该叫它什么？”

---

### [00:42:20] [Andy Raskin]

**English:**
He came up with that one. But then when I asked him later, he is like, "Yeah, you know what? In hindsight we probably could have called it strawberry intelligence. It didn't matter. It was really the story that sort of mattered." I think he was exaggerating a little bit. And I think the category people would actually agree with this, I think they would agree with, hey, these three words are, it's sort of a shorthand for this movement of old game narrative.

**中文翻译:**
他想出了那个名字。但后来我问他时，他说：“是的，你知道吗？事后看来，我们可能把它叫做‘草莓智能’也行。名字并不重要，真正重要的是那个故事。”我想他有点夸张了。而且我认为做品类的人实际上也会同意这一点，他们会同意：嘿，这三个词其实只是这种“旧游戏叙事运动”的一种缩写。

---

### [00:42:48] [Andy Raskin]

**English:**
But I guess I feel like still by calling it category and category name, we're just focusing on those three words so much. And what happens often is CEOs will, they'll kind of come up with this little category, like what happened with Nick at the 360Learning with collaborative learning. We have this name, but we don't know how to tell the story around it. So my feeling is like, well, let's focus on the story. So that's why I talk about strategic narrative and movement creation versus category creation. If someone decides that your movement is a category, great. Bonus.

**中文翻译:**
但我还是觉得，通过称之为“品类”和“品类名称”，我们太过于关注那几个词了。经常发生的情况是，CEO 们会想出一个小品类，就像 360Learning 的 Nick 遇到的“协作式学习”一样。我们有了这个名字，但我们不知道如何围绕它讲故事。所以我的感觉是：好吧，让我们专注于故事。这就是为什么我谈论的是“战略叙事”和“运动创造”，而不是“品类创造”。如果有人认为你的运动是一个品类，那太好了，那是额外奖励。

---

### [00:43:32] [Lenny]

**English:**
I see. So essentially your approach is category can play a part of this, but there's a bigger question you have of what's the story, what's the movement, what are the obstacles and categories and element of that potentially?

**中文翻译:**
我明白了。所以本质上你的方法是，品类可以是其中的一部分，但你关注的是一个更大的问题：故事是什么？运动是什么？障碍是什么？而品类可能只是其中的一个元素？

---

### [00:43:45] [Andy Raskin]

**English:**
I mean, I almost see them as orthogonal, like with HubSpot. HubSpot had this narrative around inbound. It used to be just outbound stuff, now we're going to have inbound. And that wasn't really a category. Back then they were probably known as marketing automation. Now they're probably known as CRM because they've broadened. But this movement is the thing that's sort of the constant and in some ways orthogonal to whatever category they're in.

**中文翻译:**
我是说，我几乎把它们看作是正交的（orthogonal）。就像 HubSpot。HubSpot 有一个关于“入境”（inbound）的叙事。以前只有“出境”（outbound）推销，现在我们要有“入境”吸引。那其实并不是一个品类。当时他们可能被称为“营销自动化”。现在他们可能被称为“CRM”，因为他们业务扩大了。但这场“运动”是某种恒定的东西，在某种程度上与他们所处的任何品类都是正交的。

---

### [00:44:16] [Lenny]

**English:**
Is the strategic narrative framework right for essentially any company or is there a sweet spot? And I've noticed most of the companies you've been talking about are B2B SaaS. So I don't know, maybe if there's a spectrum of perfect fit for strategic narrative framework and then not a fit at all. What's along that spectrum?

**中文翻译:**
战略叙事框架是否适用于任何公司，还是说它有一个“最佳适用点”？我注意到你提到的大多数公司都是 B2B SaaS。所以我不知道，是否有一个光谱，一端是完美契合战略叙事框架的公司，另一端是完全不契合的公司？这个光谱上都有什么？

---

### [00:44:33] [Andy Raskin]

**English:**
Yeah, well you can see, I mean it takes a little time to tell this story and you were kind of framing it a little bit and we're telling it in lots of different channels. So I think it does really play well in this enterprise sales context because also we have a group buyer there. So it's not just one person who's doing some research. This whole group has to have a uniting story. So I think you're right that in noticing that the companies that this tends to resonate with tend to be B2B, enterprise sales, technology I think because often the product is very complicated. That arrogant doctor stuff comes from an age when the things people were selling were products on shelves that didn't change much, cans of soup at the supermarket or a car in a dealership. Even software back then, shrink-wrapped in a box, doesn't change.

**中文翻译:**
是的，你可以看到，讲好这个故事需要一点时间，你需要对它进行构建，并在许多不同的渠道中讲述它。所以我认为它在企业级销售（enterprise sales）背景下确实非常有效，因为那里通常是群体决策。不只是一个人在做研究，整个群体需要一个统一的故事。所以你是对的，那些容易产生共鸣的公司往往是 B2B、企业级销售和科技公司。我想是因为这些产品通常非常复杂。那种“傲慢的医生”模式源于一个时代，那时人们卖的是货架上不怎么变化的商品，比如超市里的罐头汤或经销商那里的汽车。甚至是当时的软件，装在盒子里塑封好，不会改变。

---

### [00:45:44] [Andy Raskin]

**English:**
B2B software, this stuff is changing by the minute. And does it even make sense to make a claim to say, "Oh, we have these features and they have those features, therefore we're better," does that make any sense? That said, hey, I was looking for a sports watch, a Fitbit and I'm comparing specs and I'm doing all that stuff. And so that mode of buying is still happening, but I think, so yeah, when consumer products companies contact me, I usually say, "No." Occasionally they still say, "Okay, yeah, we'll build this, we still want to have this narrative." But yeah, I think it has the most value, most impactful right away for B2B enterprise technology companies.

**中文翻译:**
而 B2B 软件，这些东西每分每秒都在变化。在这种情况下，声称“噢，我们有这些功能，他们有那些功能，所以我们更好”还有意义吗？话虽如此，嘿，我之前在找运动手表，看 Fitbit，我在对比规格参数，做这些事情。所以那种购买模式依然存在。但是，当消费品公司联系我时，我通常会拒绝。偶尔他们还是会说：“好吧，我们要建立这个，我们还是想要这个叙事。”但总的来说，我认为它对 B2B 企业科技公司的价值最大，影响最直接。

---

### [00:46:33] [Lenny]

**English:**
Just a few more questions. One is just what's a sign that you should spend time in this area, that something is broken in your strategic narrative story pitch?

**中文翻译:**
还有几个问题。一个是，有什么迹象表明你应该在这个领域投入时间，或者说你的战略叙事故事推销出了问题？

---

### [00:46:42] [Andy Raskin]

**English:**
Well, I can tell you what I hear from CEOs when they contact me. I always ask, what's happening? Because that idea I had, no CEO's going to budget a line item for this. I'm basically asking, why was I wrong? So a few things they tell me, one is that the company is maturing from a point a stage where they've been successful, but that success is ... one CEO put it this way, was brute force of the founders. So the founders are in every meeting, they're in every product discussion, every sales call, and that's shifting, the company's getting bigger.

**中文翻译:**
嗯，我可以告诉你 CEO 们联系我时是怎么说的。我总是问：“发生了什么？”因为我之前那个“没有 CEO 会为此拨预算”的想法，我其实是在问：“为什么我错了？”他们告诉我的几件事：一是公司正在从一个成功的阶段走向成熟，但那种成功……一位 CEO 是这样描述的，是靠创始人的“蛮力”。创始人参加每一次会议，参与每一次产品讨论，每一次销售通话。而这种情况正在改变，公司正在变大。

---

### [00:47:21] [Andy Raskin]

**English:**
Usually I'm seeing this around series B where the company is getting ... so they can't be in every sales call, every market call and they're looking to transmit all the good stuff and some direction in a way that people are going to remember and all that. Everything from how we pitch to what the product should be and all that, and they see this as that.

**中文翻译:**
通常我会在 B 轮融资前后看到这种情况，公司规模扩大了，创始人无法参加每一次销售通话、每一次市场会议，他们希望以一种人们能记住的方式传递所有的精华和方向。从我们如何推销到产品应该是什么样，等等，他们把战略叙事看作是实现这一点的手段。

---

### [00:47:47] [Andy Raskin]

**English:**
There's another point that I see people contacting me at, which is where they're growing. It's usually a bit later where they've scaled tremendously successfully. Now we're either acquiring or building out whole new product units. And that old story we told is just, it's just not big enough and we got to expand it to something bigger. This is the example of OneTrust, which the CEO I had on my podcast recently. Starts out with just, I think it's data privacy around the regulations that people have to be able to say, "Don't track me," things like that. And then they buy these other company and now we have this much bigger offering. So how do we tell the story? And then I guess the third one is some form of pivot where hey, we were telling an old story but whatever, the market changed or whatever and we want to go in a different direction.

**中文翻译:**
我看到的另一个人们联系我的时点是他们正在扩张。通常是在他们已经非常成功地扩大规模之后。现在我们要么在进行收购，要么在建立全新的产品部门。我们以前讲的那个老故事已经不够宏大了，我们需要把它扩展成更大的东西。这就是 OneTrust 的例子，我最近刚采访过他们的 CEO。他们最初只是做数据隐私，围绕法规让人们能说“别跟踪我”之类的事情。然后他们收购了其他公司，现在有了大得多的产品线。那么我们该如何讲这个故事？我想第三种情况是某种形式的转型（pivot），嘿，我们以前讲的是老故事，但市场变了，我们想朝不同的方向发展。

---

### [00:48:53] [Lenny]

**English:**
Say a founders listening to this and they're like, "Okay, I realize I need to do this. I haven't spent enough time on this. Something's not working. This could be a huge unlock for us." What are the first couple steps they could take to start to figure this out? And I imagine at some point it's like, go talk to Andy. He'll help you through this. Is there stuff you can do on your own? How do you go about figuring this out?

**中文翻译:**
假设有一位创始人正在听这期节目，他们想：“好吧，我意识到我需要做这件事。我在这上面花的时间不够。有些东西不对劲。这可能对我们来说是一个巨大的突破。”他们可以采取哪几个初步步骤来开始理清头绪？我想在某个阶段可能是“去找 Andy，他会帮你解决”。但有没有什么可以自己动手做的事情？该如何着手理清这件事？

---

### [00:49:11] [Andy Raskin]

**English:**
Well, a lot of folks have emailed me over the years like, well I told you before, there were some who emailed me like, "Hey, tried it, didn't work." But many more have emailed me, "Hey, I tried it, it did work. Thank you." And so yeah, just try to lay out that structure and try it mean even when I work with teams, I adapt what people might call sort of lean approach. I want to get that thing out there into sales calls. We're not rolling it out to the whole sales team right away, but getting it out into some sales calls and get a sense, "Hey, is this resonating? Are people given the nods?"

**中文翻译:**
嗯，这些年来很多人给我发邮件，就像我之前说的，有些人发邮件说：“嘿，试过了，没用。”但更多的人发邮件说：“嘿，我试过了，真的有用。谢谢。”所以，是的，试着列出那个结构并去尝试。即使当我与团队合作时，我也会采用人们可能称之为“精益”的方法。我想把那个东西放到销售通话中去测试。我们不会立刻向整个销售团队推广，而是先在一些销售通话中使用，看看：“嘿，这能引起共鸣吗？人们有点头吗？”

---

### [00:49:49] [Andy Raskin]

**English:**
Ideally by the way, one way I look to test it, is it working, is when we talk about this shift and the stakes and do they stick. Do they kind of say, "Yeah, let me tell you how that's playing out for us,"? Or, "Am I? Yes, I'm seeing that." Sometimes I'll literally, I'll train salespeople to ask them that question, like, "Am I crazy or are you seeing this?" And what do they say? And you can usually tell if they're in and it's qualitative. But I really like that kind of testing to see if it's working. And I think anybody can do that.

**中文翻译:**
顺便说一下，理想情况下，我测试它是否有效的一种方法是：当我们谈论这种转变和利害关系时，它们是否能“粘住”对方。对方是否会说：“是的，让我告诉你这对我们来说是怎么回事，”或者“我是不是……是的，我也看到了这一点。”有时我真的会训练销售人员问客户这个问题，比如：“是我疯了，还是你也看到了这种情况？”看看他们怎么说。你通常能从定性的反馈中判断出他们是否认同。我非常喜欢这种测试方式，我认为任何人都可以做到。

---

### [00:50:32] [Lenny]

**English:**
Is there a template or guide you have online for folks to follow other than maybe just listening to this podcast and reading? Is there a post that's like, "Here's the framework defined, and go follow these steps,"?

**中文翻译:**
除了听这期播客和阅读相关内容，你网上有没有什么模板或指南供大家参考？有没有哪篇文章写着“这就是定义的框架，请按照这些步骤操作”？

---

### [00:50:41] [Andy Raskin]

**English:**
I mean, I guess the closest is that The Greatest Sales Deck I've Ever Seen post, which is the Zuora deck. But even there, people have asked me for a framework and presentation companies say, "Can we have your template so we could make it available to people? We'll revenue share with you or something." And I am so against this template. Every team I work with, it's different. It's not the same number of slides. Sometimes we can lay out this shift in one slide, sometimes it just feels better or the team likes it better, whatever, if it's a few and we're sort of getting people into it. Sometimes there's no slides. So I am really hesitant to recommend any template. And what I'd say is these are principles for building it, not any prescribed formula.

**中文翻译:**
我想最接近的是那篇《我见过的最伟大的销售 PPT》博文，也就是 Zuora 的那个 PPT。但即便如此，人们还是向我要框架，演示文稿公司也会说：“能不能把你的模板给我们，好让我们提供给大众？我们可以和你分成。”但我非常反对这种模板。我合作的每一个团队都是不同的。幻灯片的数量也不一样。有时我们可以在一张幻灯片里展示这种转变，有时分几张展示感觉更好，或者团队更喜欢那样，总之是引导人们进入情境。有时甚至根本不用幻灯片。所以我非常不情愿推荐任何模板。我想说的是，这些是构建它的“原则”，而不是任何死板的公式。

---

### [00:51:37] [Lenny]

**English:**
If they do want to reach out to you while we're on this topic, what's the best way to contact you?

**中文翻译:**
既然谈到了这个话题，如果大家想联系你，最好的方式是什么？

---

### [00:51:42] [Andy Raskin]

**English:**
Connect with me on LinkedIn. That's usually a good one. And I'm usually posting things on LinkedIn that I've learned from working with other teams.

**中文翻译:**
在 LinkedIn 上联系我。这通常是个好办法。我经常在 LinkedIn 上发布我从与其他团队合作中学到的东西。

---

### [00:51:52] [Lenny]

**English:**
Awesome. Last question before we get to a very exciting lightning round. Speaking of LinkedIn, you posted how in a working session with companies that the second session is always this low point they all go through and that everyone's starting to get discouraged and pained. And first of all, I love the expectation setting. You're like, "This is going to suck initially and it'll get better." Why is that the low point and what is it that they focus on in that second session?

**中文翻译:**
太棒了。在进入非常令人兴奋的闪电轮问答之前，最后一个问题。说到 LinkedIn，你发过一条动态，说在与公司进行的研讨会中，第二次会议总是大家都会经历的低谷期，每个人都开始感到沮丧和痛苦。首先，我非常喜欢这种预期管理。你就像在说：“刚开始会很糟糕，但会好起来的。”为什么那是低谷期？他们在第二次会议中主要关注什么？

---

### [00:52:17] [Andy Raskin]

**English:**
Well, apparently I'm not doing enough of an expectation setting, because what that post was about was this woman. So when I work with a CEO I always ask them to create what I call a strategic narrative team of up to four people. And usually those are leads of marketing, sales, whatever. In this case, the CFO was a really important person in this company. And so the CEO wanted her as part of this team. And she said to me at the end, she's like, "I love where we got to." I always ask, "What worked? What didn't work?" And she's like, "I love where we got to. That worked great. What didn't work was like, you told us that this second session was going to be bad, but I think you could have drilled home more like exactly how bad."

**中文翻译:**
显然我的预期管理做得还不够，因为那篇帖子是关于一位女士的。当我与 CEO 合作时，我总是要求他们组建一个我所谓的“战略叙事团队”，成员最多四人。通常是营销、销售等部门的负责人。在这个案例中，CFO 是这家公司非常重要的人物，所以 CEO 希望她加入团队。最后她对我说：“我喜欢我们最终达成的结果。”我总是问：“什么起作用了？什么没起作用？”她说：“我喜欢最终的结果，那很棒。没起作用的是……你告诉我们第二次会议会很糟糕，但我认为你应该更深入地强调一下到底会有‘多’糟糕。”

---

### [00:52:58] [Andy Raskin]

**English:**
And then I asked her, "Actually, could I have that quote with your face on a slide that I now present to future teams?" She said, "Yeah, you could do that." So the way I work it is I have a kickoff session where essentially I'm asking people on the team, what are these pieces? What is this old game, new game shift? How do we talk about when to set the stakes and everything I just took you through? And we have like five people in the room. There's going to be ... we're going to come out of this with notes and notes, boards and boards of ideas of this stuff.

**中文翻译:**
然后我问她：“实际上，我能不能把这句话连同你的头像放在幻灯片上，展示给未来的团队？”她说：“可以，没问题。”我的工作方式是：先有一个启动会议，基本上是询问团队成员：这些组成部分是什么？这种旧游戏到新游戏的转变是什么？我们如何讨论何时明确利害关系，以及我刚才带你了解的一切？房间里大概有五个人。会议结束时，我们会有一堆笔记，一板又一板的创意。

---

### [00:53:34] [Andy Raskin]

**English:**
And so then two things happen. One is I ask the team to start interviewing customers about how they see this shift and sometimes the customers will literally give us the words and that can be helpful in sort of aligning if we have differences. But I also start working with the CEO one-on-one and we build a first version of this thing, and it's the second session where we present this first version to the team and think about what's happening.

**中文翻译:**
然后会发生两件事。一是要求团队开始采访客户，了解他们如何看待这种转变，有时客户真的会直接提供给我们一些词汇，这在消除分歧、达成一致方面非常有帮助。但同时我也开始与 CEO 进行一对一合作，构建这个东西的第一个版本。然后在第二次会议上，我们会向团队展示这个初版，想想当时发生了什么。

---

### [00:54:02] [Andy Raskin]

**English:**
The team has just given us millions of gold ideas, truly they're all ... and in order to make something sort of clean and powerful, the CO and I have had to pretty much throw out all of them, save one or two. And there's going to be feelings about that, first of all. Second of all, if this were easy to just get all ... interview everybody, come up with it, they would've done it. So it's going to be wrong.

**中文翻译:**
团队刚刚给了我们无数个绝妙的主意，真的，它们都很棒……但为了做出简洁而有力的东西，CEO 和我不得不抛弃几乎所有的主意，只保留一两个。首先，大家对此肯定会有情绪。其次，如果这件事真的那么容易——采访每个人就能想出来——他们早就做到了。所以，初版肯定是会有问题的。

---

### [00:54:30] [Andy Raskin]

**English:**
But the good news is this is where the team gets to weigh in. I also ask, what's working, not working in this thing? And when we learn how it's not working, that gives us the juice to then me and the CEO go back to the drawing board. We plan on this in advance, we're going to go back to the drawing board and then bring up something good. So having a shit draft is a million times more valuable than having all these great ideas. But it's also really painful. It's painful not only for them, but for me. No matter how many times I say this, I expect they're going to love it in that first one too. And I'm really pissed off when they don't. But luckily now I've done enough times I know that's going to happen.

**中文翻译:**
但好消息是，这正是团队参与进来的地方。我也会问：这个东西里哪些起作用了，哪些没起作用？当我们了解到它哪里不行时，这给了我和 CEO 动力去重新构思。我们预先计划好了这一点，我们会重新开始，然后拿出好东西。所以，拥有一个“糟糕的初稿”比拥有一堆伟大的创意要有价值一百万倍。但这也真的很痛苦。不仅对他们痛苦，对我也是。无论我说过多少次，我还是会期望他们在第一次看到初稿时就爱上它。当他们不爱时，我也真的很生气。但幸运的是，现在我已经做了足够多次，我知道那是必然会发生的。

---

### [00:55:20] [Lenny]

**English:**
I was just watching a documentary about Annie Lamont who came up with the first draft concept for writers that I stick to.

**中文翻译:**
我最近刚看了一部关于安妮·拉莫特（Anne Lamott）的纪录片，她提出了作家们都信奉的“糟糕初稿”概念。

---

### [00:55:27] [Andy Raskin]

**English:**
I'm a firm believer in that. Yeah.

**中文翻译:**
我深信不疑。是的。

---

### [00:55:30] [Lenny]

**English:**
As you're talking, one last thought that I had is, so you'd work with because and founders. I feel like this could be just as useful to product leaders, product managers working on a product that they're launching, just like what is the movement, where it's happening, here's why this product's important. Do you find that too?

**中文翻译:**
听你说话时，我产生的最后一个想法是：你主要与 CEO 和创始人合作。我觉得这对于正在发布产品的产品领导者、产品经理来说同样有用，比如：这场运动是什么？它在哪里发生？为什么这个产品很重要？你也有同感吗？

---

### [00:55:45] [Andy Raskin]

**English:**
Absolutely. And very frequently, the product leader, chief product officer is part of this group. What I'd say though is that the reason ... so after I did this work for a few years, I looked back and I was like, which were the engagements I did where I can see it, and the narrative is really this true north star for everything?

**中文翻译:**
绝对如此。而且产品领导者、首席产品官经常是这个团队的一员。不过我想说的是，原因在于……在我做这项工作几年后，我回顾了一下，我想：在我参与的那些项目中，哪些项目我能看到叙事真正成为了所有事情的“北极星”？

---

### [00:56:10] [Andy Raskin]

**English:**
It was always the ones where the CEO was leading it, not just in name, but literally the person who called me who was working on the drafts with me and going through. And so initially I didn't insist that it would be the CEO doing that, but eventually I started to, and I think even for a product leader, you're going to want the support. You don't want to be just telling that story in product. You're going to want that supported from this Zuora person who gave me the initial deck, he said it, "It was like I had air cover and I was just going down and knocking down deals on the ground." You're going to want that air cover in marketing, sales, recruiting, everything. And how much better is it if it's really driven by the CEO and you have that?

**中文翻译:**
那总是那些由 CEO 亲自领导的项目，不仅是名义上的，而是那个真正打电话给我、和我一起修改初稿、一起过流程的人。所以最初我并不坚持必须由 CEO 来做，但后来我开始坚持了。我认为即使对于产品领导者来说，你也需要这种支持。你不想只是在产品部门讲那个故事。你会希望得到支持——那个给我最初 PPT 的 Zuora 员工说过：“这就像我有了‘空中支援’（air cover），而我只是在地面上不断谈成生意。”你会希望在营销、销售、招聘等所有环节都有这种“空中支援”。如果这真的由 CEO 驱动，而你拥有了这种支持，那该有多好？

---

### [00:57:01] [Lenny]

**English:**
Amazing. Is there anything else you wanted to touch on or you want to share before we get to our very exciting lighting round?

**中文翻译:**
太棒了。在进入我们非常令人兴奋的闪电轮问答之前，你还有什么想谈谈或分享的吗？

---

### [00:57:07] [Andy Raskin]

**English:**
No, except I love category design people and it's really just sort of terms that I like that are ... you know what? Forget it. Scratch that part.

**中文翻译:**
没有了，除了我想说我爱那些做品类设计的人，其实只是我喜欢的术语有些……你知道吗？算了，把那段删掉吧。

---

### [00:57:19] [Lenny]

**English:**
I thought that was funny.

**中文翻译:**
我觉得那挺好笑的。

---

### [00:57:21] [Andy Raskin]

**English:**
Oh yeah. Okay. Yeah, we could leave it in. We could leave it in. You could even leave this in where I'm telling you to scratch it.

**中文翻译:**
噢，好吧。行，我们可以留着。我们可以留着。你甚至可以把我叫你删掉这段话的内容也留着。

---

### [00:57:26] [Lenny]

**English:**
Sounds good. I was actually going to joke that I was going to cut this out and leave you hanging, but okay.

**中文翻译:**
听起来不错。我本来还想开玩笑说我要把它剪掉，让你尴尬一下，不过算了。

---

### [00:57:31] [Andy Raskin]

**English:**
No, you can do that. Yeah. Category design people. Love you. Don't hate me. Thank you.

**中文翻译:**
不，你可以那样做。是的。品类设计的人们，爱你们。别恨我。谢谢。

---

### [00:57:37] [Lenny]

**English:**
Great. I love it. We're going to be okay, I think. Well, with that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
太好了。我想我们会没事的。那么，我们进入了非常令人兴奋的闪电轮问答。我有五个问题要问你。准备好了吗？

---

### [00:57:46] [Andy Raskin]

**English:**
I'm ready. I saw like what you sent them, but I didn't really look at them, so I'm just going to tell you what I said. I'll go off that.

**中文翻译:**
准备好了。我看到了你发过来的问题，但我没仔细看，所以我直接凭直觉回答。

---

### [00:57:52] [Lenny]

**English:**
Perfect. Excellent. The best version of this. What are two or three books that you've recommended most to other people?

**中文翻译:**
完美。太棒了。这才是最好的状态。你向别人推荐最多的两三本书是什么？

---

### [00:57:59] [Andy Raskin]

**English:**
One of the books that I read initially from that Barnes & Noble, it was Story by Robert McKee. I think a lot of people know about it who are sort of interested in story stuff, but it's kind of a Bible of people who are doing screenwriting and stuff. If anyone who's in Hollywood who thought about going to Hollywood, they know about this book. I love a book called Out of Sheer Rage. It's really not about what I do or anything, but the author is Geoff Dyer. Geoff, he's written a lot of books that are kind of essay memoir, and this is a book about him trying to write a book about DH Lawrence. So it's all about procrastinating and like, "Oh, I'm supposed to write this book. I'm about to go on a trip somewhere. Should I bring the collected works of DH Lawrence with me on the trip because that'll help me start the book, but maybe I shouldn't because it's not going to ... Then I could come back refreshed without having ..." Basically, it's all that. It's this sort of in the head. I just really enjoy that book.

**中文翻译:**
其中一本是我最初在 Barnes & Noble 读到的，罗伯特·麦基（Robert McKee）的《故事》（Story）。我想很多对讲故事感兴趣的人都知道这本书，它几乎是编剧界的圣经。任何在好莱坞或想去好莱坞的人都知道这本书。我还喜欢一本叫《纯粹的愤怒》（Out of Sheer Rage）的书。它真的和我做的工作没关系，作者是杰夫·戴尔（Geoff Dyer）。杰夫写过很多随笔式回忆录，这本书是关于他试图写一本关于 D.H. 劳伦斯的书。所以全书都是关于拖延症的，比如：“噢，我应该写这本书。我要去某个地方旅行。我该不该带上 D.H. 劳伦斯的全集？因为那能帮我开始写作，但也许我不该带，因为那不会……然后我可以神清气爽地回来，而不用……”基本上全是这些。这是一种心理层面的描写。我非常喜欢那本书。

---

### [00:58:59] [Lenny]

**English:**
What's a favorite recent movie or TV show that you really enjoyed?

**中文翻译:**
最近你非常喜欢的电影或电视剧是什么？

---

### [00:59:03] [Andy Raskin]

**English:**
Station 11. Station 11. That was just so beautiful to me.

**中文翻译:**
《第十一站》（Station 11）。对我来说，它太美了。

---

### [00:59:09] [Lenny]

**English:**
Trippy. That was a trippy movie. Did not expect to go where it went. I usually ask what's a favorite interview question you like to ask, and I don't know how often you're interviewing people, but does anything come to mind when I ask that?

**中文翻译:**
很迷幻。那是一部很迷幻的剧。没想到剧情会那样发展。我通常会问你最喜欢的面试问题是什么，我不知道你多久面试一次人，但当我问这个问题时，你脑海中有什么浮现吗？

---

### [00:59:21] [Andy Raskin]

**English:**
Well, I can tell you one thing I ask when I speak with CEOs is I like to ask, what role has this narrative played in your leadership? How does it work in your leadership? And it's always really interesting for me to hear that, 'cause I often hear things that I don't expect.

**中文翻译:**
嗯，我可以告诉你，当我与 CEO 交流时，我喜欢问：“这个叙事在你的领导力中扮演了什么角色？它是如何在你的领导工作中发挥作用的？”听他们的回答总是很有趣，因为我经常听到意想不到的东西。

---

### [00:59:39] [Lenny]

**English:**
What's a favorite product you've recently discovered that you just really like?

**中文翻译:**
你最近发现并非常喜欢的某个产品是什么？

---

### [00:59:43] [Andy Raskin]

**English:**
I recently got a Fitbit. I think I may have mentioned it earlier. I was looking for a product like that, and so far I'm really loving it.

**中文翻译:**
我最近买了一个 Fitbit。我想我之前提到过。我一直在找那样的产品，到目前为止我非常喜欢它。

---

### [00:59:53] [Lenny]

**English:**
Amazing. Have you tried other versions of Fitbits or that's the one that's working?

**中文翻译:**
太棒了。你试过其他版本的 Fitbit 吗，还是就这一个好用？

---

### [00:59:58] [Andy Raskin]

**English:**
I also ordered a Polar at the same time and wound up returning the Polar. Basically, it was just a little clunkier on my wrist, so I went with a Fitbit. Well, do you have one that you recommend instead?

**中文翻译:**
我当时还同时订了一个 Polar，结果把 Polar 退了。基本上是因为它戴在手腕上感觉有点笨重，所以我选了 Fitbit。那么，你有什么推荐的替代品吗？

---

### [01:00:13] [Lenny]

**English:**
I just have the Apple Watch and I've never tried a Fitbit and it gives me all this stuff that seems cool, but I've never gone further.

**中文翻译:**
我只有 Apple Watch，从没试过 Fitbit。Apple Watch 提供的功能看起来挺酷的，但我没再深入研究过。

---

### [01:00:21] [Andy Raskin]

**English:**
I got the Fitbit like a week ago and I actually still am on the fence whether I bring it back to return it for the Apple Watch, so I'm enjoying it, but we'll see.

**中文翻译:**
我大约一周前买的 Fitbit，其实我现在还在犹豫要不要把它退了换成 Apple Watch。虽然现在挺喜欢的，但再看吧。

---

### [01:00:28] [Lenny]

**English:**
Okay. Final question. You're expert on presentations and I imagine you spend a lot of time in decks, and so just what's like one small change people can make to how they put together a deck or a presentation that will make their presentation a lot better?

**中文翻译:**
好的。最后一个问题。你是演示文稿方面的专家，我想你花了很多时间研究 PPT。那么，人们在制作 PPT 或演示文稿时，可以做的一个能让演示效果大大提升的小改动是什么？

---

### [01:00:41] [Andy Raskin]

**English:**
This is the one thing, make the title the takeaway of the slide so that the person looking at it has to do zero work to take away. So example, you'll sometimes see, "The problem," or, "The team." Replace, "The team," with, "Our team is veterans of whatever industry," or every single slide it's a takeaway, not a label. It'll make everything flow a lot better.

**中文翻译:**
就是这一件事：把幻灯片的标题改成该页的核心结论（takeaway），这样看的人不需要费任何力气就能获取信息。例如，你有时会看到标题写着“问题”或“团队”。把“团队”换成“我们的团队是某某行业的资深人士”。每一张幻灯片的标题都应该是一个结论，而不是一个标签。这会让整个流程顺畅得多。

---

### [01:01:17] [Lenny]

**English:**
You did a killer job answering the lightning round questions without having a peek at what they were going to be. Andy, this was incredibly insightful. I'm going to go start working on my strategic narrative for my podcast and newsletter. Two final questions. Where can folks find you online if they want to reach out, learn more, maybe consider working with you? And then how can listeners be useful to you?

**中文翻译:**
你在没看问题的情况下，闪电轮回答得太棒了。Andy，这次谈话非常有见地。我要开始为我的播客和时事通讯构思战略叙事了。最后两个问题：如果大家想联系你、了解更多信息，或者考虑与你合作，可以在哪里找到你？以及，听众们能为你做些什么？

---

### [01:01:35] [Andy Raskin]

**English:**
So I mentioned LinkedIn as a way to connect with me. That's fine. My website is AndyRaskin.com. I also have a podcast where I talk with CEOs, so if you're interested in hearing more details about actual use of this, it's called The Bigger Narrative. My mom introduces every episode. I sent her the interviews in advance. I call her and interview about what she thinks people will get out of it, and that conversation becomes the intro to the podcast episode. And what was the last question?

**中文翻译:**
我提到过 LinkedIn 是联系我的好方式。我的网站是 AndyRaskin.com。我也有一个播客，在那里我与 CEO 们交谈，如果你有兴趣了解更多关于这方面的实际应用细节，它叫《更大的叙事》（The Bigger Narrative）。我妈妈为每一集做开场白。我会提前把采访发给她，然后打电话采访她，问她觉得人们能从中收获什么，那段对话就成了播客的开头。最后一个问题是什么来着？

---

### [01:02:04] [Lenny]

**English:**
How can listeners be useful to you?

**中文翻译:**
听众们能为你做些什么？

---

### [01:02:06] [Andy Raskin]

**English:**
Useful to me. Just if you try any of this stuff, let me know. Like, "Hey, worked. Didn't work. Have this question." I would love to hear that stuff.

**中文翻译:**
对我有所帮助的话……如果你尝试了这些方法，请告诉我。比如：“嘿，起作用了”、“没起作用”或者“我有这个疑问”。我很想听听这些反馈。

---

### [01:02:17] [Lenny]

**English:**
Amazing. Andy, thank you again for being here.

**中文翻译:**
太棒了。Andy，再次感谢你的到来。

---

### [01:02:20] [Andy Raskin]

**English:**
Thanks so much for having me, Lenny. This is really fun.

**中文翻译:**
非常感谢你邀请我，Lenny。这真的很有趣。

---

### [01:02:22] [Lenny]

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at LennysPodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，因为这能真正帮助其他听众发现这个播客。你可以在 LennysPodcast.com 找到所有往期节目或了解更多信息。下期节目再见。