# Anneka Gupta - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Anneka Gupta.

---

### [00:00:00] [Anneka Gupta]

**English:**
When people say, "I want someone that's strategic," what they're really saying is, "I want someone that can come up with and articulate a compelling and simple why behind the decisions and the direction of the company and product." So that's number one. And the second piece is, "I want someone that's going to champion and be a change agent to do things that may be hard but actually best for the long-term interest of the product or company, even though those things are not going to be easy to execute on." And I think if you have one without the other, ultimately people are not going to see you as strategic.

**中文翻译:**
当人们说“我想要一个有战略眼光的人”时，他们真正的意思是：“我想要一个能够为公司和产品的决策及方向，提出并清晰表达出一个令人信服且简单的‘为什么’的人。”这是第一点。第二点是：“我想要一个能够倡导并成为变革推动者（change agent）的人，去执行那些可能很困难、但实际上最符合产品或公司长期利益的事情，即使这些事情执行起来并不容易。”我认为，如果你只有其中一点而没有另一点，最终人们还是不会认为你具有战略眼光。

---

### [00:00:40] [Lenny Rachitsky]

**English:**
Today my guest is Anneka Gupta. Anneka is Chief Product Officer at Rubrik, a lecturer on product management at Stanford University's Graduate School of Business and on the board of Tinuiti. Previously, she was President, GM, and head of product at LiveRamp, where she spent 11 years and joined as one of their earliest employees. A bunch of former guests recommended Anneka Come on this podcast and you'll soon see why.
(00:01:03):
In our conversation, Anneka shares a ton of powerful advice on navigating difficult personalities, giving and hearing hard feedback, bringing humor and gratitude to every situation, managing your energy versus managing your time. Super tactical tips for how to become more strategic and how to make better decisions, and also how to break into product management for people that are trying to become product managers. There's something in this episode for everyone and I am excited for you to learn from Anneka. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that, I bring you Anneka Gupta. Anneka, thank you so much for being here and welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Anneka Gupta。Anneka 是 Rubrik 的首席产品官（CPO），也是斯坦福大学商学院产品管理课程的讲师，同时还是 Tinuiti 的董事会成员。此前，她曾担任 LiveRamp 的总裁、总经理及产品负责人，她在那里工作了 11 年，是该公司的早期员工之一。很多之前的嘉宾都推荐 Anneka 来参加这个播客，你很快就会明白原因。
(00:01:03):
在我们的对话中，Anneka 分享了大量强有力的建议，包括如何应对难相处的性格、如何给予和听取严厉的反馈、如何在各种情况下保持幽默和感恩、以及如何管理精力而非仅仅管理时间。她还分享了关于如何变得更有战略性、如何做出更好决策的超实用技巧，以及为那些想成为产品经理的人提供的入行建议。这集节目适合每一个人，我很高兴能让大家向 Anneka 学习。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对播客有很大帮助。下面，让我们欢迎 Anneka Gupta。Anneka，非常感谢你能来到这里，欢迎来到播客。

---

### [00:01:51] [Anneka Gupta]

**English:**
Thanks for having me.

**中文翻译:**
谢谢你的邀请。

---

### [00:01:52] [Lenny Rachitsky]

**English:**
So, I want to start with a question that I've started to ask guests that come on the podcast that have had extraordinarily successful careers and also just consistently successful careers. So here's the question. What do you believe are one or two skills or mindsets or habits that you think most contributed to your success that you think might be helpful for other people to learn and build to help them have more successful careers?

**中文翻译:**
所以，我想从一个问题开始，这是我最近开始问那些事业极其成功且一直保持成功势头的嘉宾的问题。问题是：你认为最有助于你成功的技能、心态或习惯中，哪一两个是你认为对其他人学习和建立更有成效的职业生涯最有帮助的？

---

### [00:02:18] [Anneka Gupta]

**English:**
So it's funny, before we kicked this off, you talked about the post-it that you have on your computer that says have fun. My one mindset that I really have leaned into after someone actually gave me advice on this is to figure out how to have fun in my job, even in the most difficult of times. The reason why I say that is because when you're hit with really hard times, it's easy to operate from a mindset of scarcity and to look at everything as an unachievable hurdle to overcome. And when I was able to switch my mindset and say, "Well, I'm actually going to figure out a way to have fun with this," it actually changed my entire for how to deal with super difficult situations.
(00:03:03):
This advice specifically came up to me when I had a scenario where I had to essentially change out all of my direct reports in very short order, and I figured that out. It was a super daunting situation. I didn't know how I was going to manage and at first I felt so scared by what was ahead of me and how much change I was going to have to go through in a very short period of time. But when I got this advice, I started to try to reframe my thinking and it actually really made it so that I was able to get through that hard time and opened my mind up to so many more opportunities. So, now I try to embody that in every situation that I come across where I'm faced with something super, super challenging.

**中文翻译:**
很有意思，在我们开始录制之前，你提到了你电脑上贴着一张写着“玩得开心”的便签。我非常受用的一种心态——这也是别人给我的建议——就是即便在最困难的时刻，也要想办法在工作中找到乐趣。我之所以这么说，是因为当你遭遇艰难时期时，很容易陷入一种“匮乏心态”（mindset of scarcity），把一切都看作是无法逾越的障碍。而当我能够转变心态，对自己说“好吧，我其实可以想办法从中找点乐子”时，这完全改变了我处理极端困难情况的方式。
(00:03:03):
这个建议是在我遇到一个特殊情况时出现的：当时我必须在极短的时间内更换我所有的直接下属。那是一个非常令人生畏的局面。我不知道该如何应对，起初我对即将面临的挑战以及短时间内必须经历的巨大变革感到非常恐惧。但当我得到这个建议后，我开始尝试重构我的思维，这真的让我度过了那段艰难时光，并让我的思维对更多机会敞开了大门。所以，现在每当我遇到极具挑战性的情况时，我都会努力践行这种心态。

---

### [00:03:45] [Lenny Rachitsky]

**English:**
I love this advice. It's something that I've recently seen also in public speaking. If you can just reframe your thinking from "I'm scared of this" to "This is going to be fun. I'm going to have so much fun doing this. It's going to be like this energy and anxiety I'm feeling is me feeling like it's going to be a lot of fun." So, spending a little more time here, how do you actually do this? So in this case, you shared an example of basically you have to fire a bunch of people, not something one can quickly think about how to have fun with that. How did you do this? Is it just in your mind you're like, "I'm going to have fun with this," or is there something tactically people can do to make something fun?

**中文翻译:**
我非常喜欢这个建议。这也是我最近在公众演讲中看到的一种技巧。如果你能把思维从“我很害怕”重构为“这会很有趣。我会做得很开心。我感受到的这种能量和焦虑其实是因为我觉得这会非常有趣。” 那么，我们再深入探讨一下，具体该怎么做？在你刚才分享的例子中，你基本上要解雇一群人，这可不是那种能让人立刻想到“怎么找乐子”的事情。你是怎么做到的？只是在脑子里想“我要从中找乐子”，还是有什么具体的战术动作可以让事情变得有趣？

---

### [00:04:18] [Anneka Gupta]

**English:**
I think there were a couple of things that I did and I've continued to do. One is figure out and really look at the situation and ask myself, what can I learn from this situation? What can I get out of this that's a positive outcome even though it is incredibly challenging to be facing it right now? So that's one thing that I've done. The second thing I think that has been really helpful is in going into meetings or other situations where I was trying to figure out how to collectively solve some big challenge, figuring out how to bring humor into the meeting. Just starting it on a light note and that elevated my own mood and way I was approaching the meeting, but also adds a level of levity to the situation for other people as well, which I think as a leader is super important because it's not just about your own mindset, but how are you transferring that mindset to the people that you're working with and the people that are working for you.

**中文翻译:**
我想我当时做了几件事，并且一直在坚持做。第一是审视现状并问自己：我能从这个情况中学到什么？即便现在面对它极具挑战性，我能从中获得什么积极的结果？这是我做的一件事。第二件我认为非常有帮助的事是，在参加会议或其他需要集体解决重大挑战的场合时，想办法把幽默感带进会议。以轻松的基调开始，这不仅提升了我自己的情绪和参会方式，也为其他人增加了一份轻松感。我认为作为领导者，这一点至关重要，因为这不仅关乎你自己的心态，还关乎你如何将这种心态传递给你的同事和下属。

---

### [00:05:12] [Lenny Rachitsky]

**English:**
Got it. So part of it is just like, "How do I add a little humor?" Part of it is just thinking, "How do I make this fun?" Is part of this just like this is not as important as people make it out to be and we could just have a little fun with this thing. It doesn't have to be like we're not curing cancer.

**中文翻译:**
明白了。所以一部分是“我怎么加点幽默？”，另一部分是思考“我怎么让这变得有趣？”。这其中是否也包含一种想法，即：这件事并没有人们想象的那么生死攸关，我们可以轻松对待。毕竟我们又不是在攻克癌症。

---

### [00:05:28] [Anneka Gupta]

**English:**
Yeah, definitely I think that helps. Reflecting on this too, I feel like a lot of it comes down to the amount of emotional and mental energy I can bring to solving a problem. And there's always so much going on in life, like personal life as well as professional life, trying to figure out how can I architect my day and time to maximize my energy and be able to bring my full self to work and to these difficult so that I can have that mindset to look at things more broadly versus operating from a place of scarcity. That may come down to simple things like making sure that I have lunch. Sometimes when things get so busy you're like, "Oh, I'm just going to grab a protein bar and I'm going to skip lunch." But I found that that really decreases my energy.
(00:06:15):
Or, trying to do things that are really difficult late in the day. Five to 6:00 PM is my worst time of day and I know that about myself, so I'm not going to schedule in my most difficult meeting or writing up a strategy deck or something for that period of time because I know that that's not going to be my best and it's actually going to make it more difficult for me to get the work done. Being able to manage my energy levels and figuring out how to schedule my time for my energy has really allowed me also to figure out how to have that abundant mindset in all situations.

**中文翻译:**
是的，绝对有帮助。反思这一点，我觉得很大程度上取决于我能投入多少情绪和精神能量来解决问题。生活中总是有很多事情，无论是个人生活还是职业生活。我尝试去架构我的每一天和时间，以最大化我的能量，从而能全身心地投入到工作和这些困难中，这样我才能拥有那种更宽广的视野，而不是陷入匮乏感中。这可能归结为一些简单的小事，比如确保吃午饭。有时忙起来你会想：“哦，我就随便啃个蛋白棒，不吃午饭了。”但我发现那真的会降低我的能量。
(00:06:15):
或者是，避免在一天快结束时做非常困难的事情。下午 5 点到 6 点是我状态最差的时候，我很了解自己这一点，所以我不会在那个时段安排最难的会议，或者写战略 PPT 之类的，因为我知道那不是我的最佳状态，反而会让工作变得更难完成。能够管理我的能量水平，并根据能量状态来安排时间，这让我能够在所有情况下都保持那种“丰盈的心态”（abundant mindset）。

---

### [00:06:50] [Lenny Rachitsky]

**English:**
This episode is brought to you by the Enterprise Ready Conference, a one-day event in San Francisco, bringing together product and engineering leaders shaping the future of enterprise SaaS. The event features a curated list of speakers with direct experience building for the enterprise, including leaders from OpenAI, Vanta, Checker, Dropbox and Canva. Topics included advanced identity management, compliance, encryption, and logging essentially at complex features that most enterprise customers require. If you're a founder, exec, product manager or engineer tasked with the enterprise roadmap, this conference is for you. You'll get detailed insights from industry leaders that have years of experience navigating the same challenges that you face today. And best of all, it's completely free since it's hosted by WorkOS. Spots are filling up quickly. Make sure to request an invite at EnterpriseReady.com. That's EnterpriseReady.com.
(00:07:47):
Today's episode is brought to you by Command AI. If you're like me and most users that I've built product for, you're probably used to chatbots at the bottom right of websites where you ask a question and it says something like, "Check out these three helpful articles. Did that answer your question?" And then you click away and then a few seconds later you get bombarded with some other useless pop-ups. For those of us who work on software, no one wants their product to feel like this. Command AI is an AI power toolkit for support, product, growth and marketing teams that embeds in your company's product.
(00:08:19):
The AI support agent can deflect upwards of 80% of support questions providing actually useful answers, and it can magically co-browse with your users to show them around your interface. They do pop-ups too, but their nudges are based on in-product behaviors like confusion or intent classification, which makes them much less annoying and much more impactful. Command AI works with web apps, mobile apps and websites, and they work with industry-leading companies like Gusto, Freshworks, HashiCorp, LaunchDarkly, and over 25 million end-users interact with Command AI interfaces. To try out Command AI, you can sign up at command.ai/Lenny and experience a custom demo of how it works in your app. That's command.ai/Lenny.

**中文翻译:**
本集节目由 Enterprise Ready 大会赞助。这是一场在旧金山举行的为期一天的盛会，汇聚了塑造企业级 SaaS 未来的产品和工程领袖。活动邀请了具有丰富企业级产品构建经验的演讲者，包括来自 OpenAI、Vanta、Checker、Dropbox 和 Canva 的领导者。主题涵盖高级身份管理、合规性、加密和日志记录——这些基本上是大多数企业客户要求的复杂功能。如果你是负责企业路线图的创始人、高管、产品经理或工程师，这场会议就是为你准备的。你将从拥有多年实战经验的行业领袖那里获得深刻见解。最棒的是，由于由 WorkOS 主办，它是完全免费的。名额有限，请务必在 EnterpriseReady.com 申请邀请。
(00:07:47):
今天的节目由 Command AI 赞助。如果你像我以及我服务过的大多数用户一样，你可能已经习惯了网站右下角的聊天机器人：你问一个问题，它会说“看看这三篇有用的文章。这解决了你的问题吗？”然后你关掉它，几秒钟后又被其他没用的弹窗轰炸。对于我们这些开发软件的人来说，没人希望自己的产品给用户这种感觉。Command AI 是一个为支持、产品、增长和营销团队提供的 AI 驱动工具包，它可以嵌入到你的公司产品中。
(00:08:19):
它的 AI 支持代理可以分流 80% 以上的支持问题，提供真正有用的回答，并且可以神奇地与用户“协同浏览”（co-browse），带他们熟悉你的界面。他们也做弹窗，但他们的“微调提示”（nudges）是基于产品内行为的，比如用户困惑或意图分类，这让它们不那么讨人厌，且更有影响力。Command AI 适用于 Web 应用、移动应用和网站，合作伙伴包括 Gusto、Freshworks、HashiCorp、LaunchDarkly 等行业领先公司，超过 2500 万终端用户在使用 Command AI 界面。要试用 Command AI，你可以访问 command.ai/Lenny 注册，并观看它在你的应用中运行的定制演示。

---

### [00:09:06] [Lenny Rachitsky]

**English:**
I'm going to go in a totally different direction. Before we were recording, we were also chatting about founder mode, and this is recently. This episode we're recording shortly after Paul Graham put out his now classic, instant classic founder mode post. And he had some really interesting takes on ways to think about founder mode, both from product leader perspective, from a founder perspective. So, there's kind of two questions I want to ask, but just broadly, what's your take on founder mode?

**中文翻译:**
我要换个完全不同的方向。在录音之前，我们也聊到了“创始人模式”（founder mode），这是最近的热门话题。我们录制这一集时，Paul Graham 刚发布了他那篇现在已经成为经典的“创始人模式”文章。他对于如何思考创始人模式有一些非常有趣的见解，无论是从产品领导者的角度，还是从创始人的角度。所以，我想问两个问题，但首先宽泛地谈谈，你对“创始人模式”怎么看？

---

### [00:09:33] [Anneka Gupta]

**English:**
Well, first of all, I think Paul Graham did an amazing thing by putting a name to something so many of us have seen in practice. And while he didn't in his article say this is exactly what this is, I think many, many people that I talked to were like, "Oh yeah, I recognize this." I recognize people that I've worked for, CEOs, that have done founder mode, great founders that have done founder mode poorly. And it opened up a level of discussion that I think is really valuable for everyone to be having, whether you're a founder or you're someone that works for a founder.

**中文翻译:**
首先，我认为 Paul Graham 做了一件了不起的事情，他为一个我们许多人在实践中都见过现象定了一个名字。虽然他在文章中没有明确说“这就是它的定义”，但我交流过的很多人都说：“哦，是的，我认得这个。”我认得我为之工作过的人，那些开启了创始人模式的 CEO，还有那些把创始人模式搞砸了的优秀创始人。它开启了一个非常有价值的讨论层面，无论你是创始人，还是为创始人工作的人，都应该参与其中。

---

### [00:10:04] [Lenny Rachitsky]

**English:**
Okay, so I'm going to ask two questions around this. One is from the perspective of working for a founder and founder mode, the other is being a product leader in founder mode. So, first of all, imagine you've worked with a few founders that operate in founder mode. As a CPO, as head of product, that's often a difficult place to be between the founder and the team that are building the thing. What have you learned about how to effectively work as a product leader with a founder in founder mode?

**中文翻译:**
好，关于这个我有两个问题。一个是作为创始人的下属如何应对创始人模式，另一个是作为产品领导者如何运用创始人模式。首先，假设你曾与几位以创始人模式运作的创始人共事过。作为 CPO 或产品负责人，夹在创始人与实际开发产品的团队之间，往往是一个很难做的位置。关于如何作为产品领导者与处于创始人模式下的创始人有效协作，你学到了什么？

---

### [00:10:30] [Anneka Gupta]

**English:**
So, I think when a founder's in founder mode and if they're doing it well, what they're doing is really deeply understanding the business and then figuring out when to use their power as a founder to either tweak things and send something in a slightly different direction or fundamentally innovate and completely change directions or completely innovate in a totally new area. Now I think the way to use that effectively as a head of product is to recognize that they have that power to figure out how to use that power to get the things done that you know are best for the company. So, I always think about I have all the people around me. Whether they're people on my team, my peers, or my CEO, these are different resources I have to go get a initiative done or get work done in the company.
(00:11:23):
And as having a founder that can effectively operate in founder mode means that I can go and have a conversation with the CEO and say, "Hey, look, we have this huge opportunity and these are the things that aren't working, and I need your help to help figure out how we can move the needle more substantially in the direction that we need to go." And so activating that founder, that CEO to really be able to push the initiative that I think is best by making them an ally in doing so. I think one aspect. The second aspect is, which often happens, it's very difficult for many people and I've had this happen to me many times, is when a founder is like, "Well, I have this idea," and then you may or may not agree that that's the best direction to go in and how do you navigate that kind of situation?
(00:12:10):
So, one is actually taking a step back and objectively saying, "Well, why are they pushing this?" Maybe it's the wrong mechanism to go actually get done a strategy that's quite important for the company. So having a really deep understanding about why are they asking this, what are they ultimately trying to get at and what is the objective that they're trying to get at and is this the right way to get at it? If the answer is no to that, then you can go have a conversation. If you know what the objective is, you can go have a conversation with that founder and say, "Hey, look, I know this is what you're trying to do, but maybe instead of looking at option A here of how we go about tackling this, we should have explored these three other options instead." And that can help you and help navigate that conversation.
(00:12:53):
Now sometimes it's difficult to even get to that kind of understanding of the objective because someone might be just super set in their ways of, "Hey, I really want to go after this opportunity. It's my pet project." Then you have to decide as a head of product, do I really want to fight this or do I just give in on this, let it go? And also make sure that we get the stuff done that's most important to the company. You have to make that judgment call as a head of product and decide what is really going to make or break the company. What's the hill that I'm going to die on and is this something that I can shift or is this something that is not worth shifting? Of course it comes down to the personality. I've been very fortunate that I've actually had very few of those situations where the founder has been like, "Hey, I really want to go in this direction and I haven't agreed, at least with what we're trying to go after, regardless of the mechanism behind it."

**中文翻译:**
我认为，当一个创始人处于创始人模式且运作良好时，他们是在深入理解业务，然后决定何时利用他们作为创始人的权力：或是微调方向，或是进行根本性创新并彻底改变方向，又或是在全新领域进行创新。作为产品负责人，有效利用这一点的方法是：意识到他们拥有这种权力，并思考如何利用这种权力去完成那些你认为对公司最有利的事情。我总是认为，我周围的所有人——无论是我的团队成员、同僚还是 CEO——都是我可以用来推动某项倡议或完成工作的资源。
(00:11:23):
拥有一个能有效运作创始人模式的创始人，意味着我可以去找 CEO 谈话，说：“嘿，看，我们有这个巨大的机会，但这些事情目前进展不顺，我需要你的帮助，来更大幅度地推动我们向目标方向迈进。”通过让创始人或 CEO 成为盟友，来推动我认为最好的倡议。这是其中一个方面。第二个方面是经常发生的情况，对很多人来说都很困难，我也经历过很多次：当创始人说“我有这个想法”时，你可能并不认同那是最好的方向，你该如何应对？
(00:12:10):
一种方法是退后一步，客观地问：“为什么他们要推行这个？”也许这只是实现公司某项重要战略的错误手段。所以要深入理解：他们为什么要提这个要求？他们最终想达到什么目的？目标是什么？这是实现目标的正确方式吗？如果答案是否定的，你就可以去沟通。如果你知道目标是什么，你可以对创始人说：“嘿，我知道你想做这个，但与其用方案 A，我们也许应该探索另外三个选项。”这能帮你引导对话。
(00:12:53):
当然，有时很难理解对方的目标，因为有人可能非常固执己见，觉得“我就是想做这个机会，这是我的心头好”。这时作为产品负责人，你必须决定：我是要据理力争，还是就此妥协？同时还要确保公司最重要的工作能完成。你必须做出判断：什么才是真正决定公司成败的关键？什么是值得我坚持到底的原则（hill to die on）？这是我可以改变的事情，还是不值得费力去改变的事情？当然，这取决于性格。我很幸运，很少遇到那种创始人坚持一个方向而我完全不认同的情况——至少在目标上我们通常是一致的，即便手段有所不同。

---

### [00:13:47] [Lenny Rachitsky]

**English:**
I really love the point you made, especially about how the founder could be this lever to get things done. When you identify something needs to change, the best way to change that is just have the founder go in there, tell everyone, "Hey, we're going to do this thing differently." It's such like a positive spin on how to leverage founder mode where a founder actually has a lot of power to change that other people in the company don't. Okay, so let's go from the other side. So, I was talking to Nikhyl Singhal who runs the Skip, which is a community you're part of about you. And he said that you're a leader who excels in founder mode, that you operate in founder mode a lot. And so as a product leader, what have you learned about just how to think in founder mode, operate in founder mode, leverage that approach to leading teams, leading product teams?

**中文翻译:**
我非常喜欢你提到的那一点，尤其是关于创始人如何成为推动事情进展的杠杆。当你发现某些事情需要改变时，最好的办法就是让创始人出面告诉大家：“嘿，我们要换个方式做这件事。”这对于如何利用创始人模式是一个非常积极的视角——创始人确实拥有公司里其他人所不具备的巨大变革力量。好，让我们从另一个角度来看。我曾和 Nikhyl Singhal（他运营着你所在的 Skip 社区）聊起过你。他说你是一位擅长创始人模式的领导者，你经常以这种模式运作。那么作为产品领导者，关于如何以创始人模式思考、运作，并利用这种方法来领导团队和产品团队，你学到了什么？

---

### [00:14:32] [Anneka Gupta]

**English:**
Yeah, I think it's often easy as a leader to say, "I'm not going to roll up my sleeves and get into the details of the business or ask a lot of detailed questions about the business because you want to empower people and make them successful." What I've found is that understanding the details of the business and asking questions and understanding to the utmost extent you can, what's working, what's not, what are the financial goals of the business? Are we on track to get there? How are we making decisions? Getting into that level of depth is super important, and then you can decide as a leader, what do you want to do with that information? So there's a lot of information that I collect about what's happening in the organization, the decisions that we're making that I don't do anything with at a point in time.
(00:15:20):
That's my choice to make, but I want the information because in understanding the depth and what is happening, I can decide where I actually think I need to go in deep and make either very significant course correction or a small course correction. Then the way that I think about how do I bring my team along for that so they don't feel like I'm coming in and stomping all over the work that they're doing or trying to re-adjudicate a decision, one, is how do I get in there early?
(00:15:51):
One of the tactics I use is I ask people to present their strategies for things that I think we may need to do a course correction on, and I have them come in and then I ask them questions and then I make suggestion. And I'm able to do that in a forum where it doesn't feel like I'm coming in and rewriting the entire strategy, but I'm giving them there an opportunity to present their best thinking and then trying to figure out how do I take that and make that better and make them feel like I'm making it better versus stomping all over and dismissing the work that they've done.
(00:16:23):
I pick a strategic set of areas. So I think about what is most important for the business? What's going to kill the business if we don't get right and what are the biggest opportunities for the business that we need to go after regardless of how difficult it is for us to actually execute on that? By doing that, then at least I have clarity in my mind and I can provide clarity to the team about what is most important and rally the troops around making that stuff happen if that is what is essentially right. And I'll have all the context because I've asked all the questions of why this is right for the business, why is this going to help us with increased margins or get better growth or get into a new persona if that's what we're trying to do as an overall organization.

**中文翻译:**
是的，我认为作为领导者，很容易会想：“我不想卷起袖子深入业务细节，或者问太多细节问题，因为我想授权给下属并让他们获得成功。”但我发现，理解业务细节、提问并尽可能地了解现状——什么行得通，什么行不通，财务目标是什么，我们是否在正轨上，决策是如何做出的——深入到这种程度是非常重要的。然后作为领导者，你可以决定如何处理这些信息。我收集了很多关于组织动态和决策的信息，但在某个时间点，我可能什么都不做。
(00:15:20):
那是我的选择，但我需要这些信息，因为通过深入了解现状，我可以决定在哪里需要介入，是进行重大的航向修正还是微调。然后，我思考如何带着团队一起走，让他们不觉得我是在粗暴干涉他们的工作或推翻既定决策。第一点是：如何尽早介入？
(00:15:51):
我使用的一个策略是，让人们针对我认为可能需要修正方向的事情来陈述他们的战略。我让他们来汇报，然后我提问，再提出建议。我是在一个讨论的氛围中做这件事，而不是直接重写整个战略。我给他们机会展示他们最好的思考，然后尝试如何在此基础上改进，让他们觉得我是在帮他们做得更好，而不是在否定他们的工作。
(00:16:23):
我会挑选一组战略领域。我会想：对业务来说最重要的是什么？如果我们搞砸了，什么会毁掉公司？业务最大的机会是什么，无论执行起来多难我们都必须追求？通过这样做，我至少在脑子里是清晰的，我也能向团队清晰地传达重点，并动员大家去实现那些正确的事情。而且我会拥有完整的背景信息，因为我已经问过了所有问题：为什么这对业务是正确的，为什么这能帮我们提高利润、获得增长或进入新的用户画像（persona）。

---

### [00:17:04] [Lenny Rachitsky]

**English:**
So in that example, and I love this tactic, you have your team come in, you ask them, "Tell me what the strategy is for this thing that you're working on." What you've seen work is instead of like, "No, this is broken, this is wrong, this isn't going to work." Your approach is ask questions and hope that they see the flaws or gaps. Is that how-

**中文翻译:**
所以在那个例子中（我非常喜欢这个策略），你让团队进来，问他们：“告诉我你们正在做的这件事的战略是什么。”你发现有效的方法不是直接说“不，这行不通，这错了”，而是通过提问，希望他们自己发现缺陷或漏洞。是这样吗——

---

### [00:17:24] [Anneka Gupta]

**English:**
Yeah, it's ask questions, but you can't always lead someone somewhere with asking questions. It's also sharing a hypothesis. So I might have a particular hypothesis about the business where I might see something like, "Well, I was talking to security leaders in our customer advisory board recently and I heard this piece of feedback and this is what it made me think about our strategy, what do you think about that?" And then let them say like, "Okay, yeah, actually I see this or maybe I have some follow up questions."
(00:17:54):
It actually opens a whole discussion where I'm still able to provide my perspective and point of view but not completely shut down the discussion. Because what I always worry about is a leader is I'm going to come in and say something, and because I'm one of the more senior people in the room, no one is going to say if they have a concern. And the reality is I'm not always right far from it, but I want to be able to seed an assumption and then have a discussion based on that and then figure out what the right outcome is about what we should do next based on that discussion.

**中文翻译:**
是的，是提问，但你不能总是只靠提问来引导别人。还要分享假设。我可能会对业务有一个特定的假设，比如我会说：“我最近在客户顾问委员会和一些安全主管聊天，听到了这样的反馈，这让我对我们的战略有了这样的思考，你怎么看？”然后让他们回应：“好吧，是的，我确实看到了这一点，或者我有一些后续问题。”
(00:17:54):
这实际上开启了一场讨论，我仍然能表达我的观点，但不会彻底终结讨论。因为作为领导者，我总是担心我一开口，因为我是房间里资历最深的人之一，就没人敢表达异议了。事实是我并不总是正确的，远非如此。但我希望能抛出一个假设（seed an assumption），然后基于此进行讨论，最后根据讨论结果决定下一步该怎么做。

---

### [00:18:27] [Lenny Rachitsky]

**English:**
Speaking of strategy, you shared with me that at one point in your career you got this feedback that you just weren't strategic enough and that that comment led you to research and dig into what does it mean to be strategic, and also just to level up your strategic mindset and the way you think about strategy. What did you end up with recognizing as being strategic? What is that in your work and in your research? And then how did you actually get better at this work of being strategic?

**中文翻译:**
说到战略，你曾跟我分享过，在你职业生涯的某个阶段，你收到的反馈是“不够有战略眼光”。这个评价促使你去研究和挖掘“具有战略眼光”到底意味着什么，并提升你的战略思维。在你的工作和研究中，你最终认为什么是“战略性”？你是如何具体提高这种能力的？

---

### [00:18:57] [Anneka Gupta]

**English:**
I got this feedback once in a performance review and then I actually got it as well a few years ago when I was interviewing for head of product roles and I thought I had made a lot of progress on it, but when I reflected back, I think it actually all came back to the same themes. Which was I think when people say "I want someone that's strategic," what they're really saying is "I want someone that can come up with and articulate a compelling and simple why behind the decisions and the direction of the company and product." So that's number one. The second piece is, "I want someone that's going to champion and be a change agent to do things that may be hard but actually best for the long-term interest of the product or company, even though those things are not going to be easy to execute on."
(00:19:45):
And I think if you have one without the other, ultimately people are not going to see you as strategic. If you're really good at articulating the why, but you're only bringing small ideas to the table, then that's not strategic. If you're championing big ideas but you can't articulate the why behind them in a compelling and simple way, then you're not going to be seen as strategic either. So, that's the formula that I've come up with. This is what it means. And so I focused a lot on how do I make sure I do both of these things? How do I champion a few things that a really big ideas that are going to help change the direction of the company, and then how do I articulate that in a simple and compelling why?

**中文翻译:**
我曾在一次绩效评估中收到过这个反馈，几年前我在面试产品负责人职位时也收到了同样的反馈。当时我以为自己已经进步很大了，但回过头来看，我认为这都归结为相同的主题。我认为当人们说“我想要一个有战略眼光的人”时，他们真正的意思是：“我想要一个能为公司和产品的决策及方向，提出并表达出一个令人信服且简单的‘为什么’的人。”这是第一点。第二点是：“我想要一个能倡导并成为变革推动者的人，去执行那些可能很困难、但实际上最符合产品或公司长期利益的事情，即便执行起来并不容易。”
(00:19:45):
我认为如果你只有其中一点而没有另一点，最终人们不会认为你有战略眼光。如果你很擅长解释“为什么”，但你提出的都是些微不足道的想法，那不叫有战略眼光。如果你倡导宏大的想法，但你无法用简单有力的方式解释背后的“为什么”，你同样不会被视为有战略眼光。所以，这就是我总结出的公式。这就是它的含义。因此，我花了很多精力研究如何同时做到这两点：如何倡导几个能改变公司方向的大想法，以及如何用简单有力的“为什么”来表达它们。

---

### [00:20:26] [Lenny Rachitsky]

**English:**
That's such a cool simple way of thinking about this. Is there an example from your work that might illustrate some of this from a project you worked on or a product you built?

**中文翻译:**
这真是一个既酷又简单的思考方式。在你的工作中，有没有哪个项目或产品可以说明这一点？

---

### [00:20:35] [Anneka Gupta]

**English:**
I can take some recent examples. We've been doing a lot of strategic planning for where do we want to be as a company over the next three years, and Rubrik operates in the cybersecurity space. It's a very fast moving landscape. There's a lot of places that we could go as a business, and one of the ways that I've exhibited this, and this is what I recommend to other people too, is sometimes it's really hard to come up with the compelling and simple why behind something and sometimes it's also really hard to come up with a really big idea out of thin air. So these things can be very challenging. The first step that I found as very useful, and I use this tactic every single day in meetings, is just summarization. So, bringing people together, lots of different voices into a room and hearing what they have to say and at various times in the conversation summarizing what people are saying and summarizing what that means in terms of the direction that we could go in.
(00:21:34):
And then that's a checkpoint of saying, "Okay, this is how I've synthesized what is happening. Is this correct or do we actually need to do another turn because we don't all agree with where we're landing here?" That summarization, even though I may not be adding a new idea into that, I found people actually view that as strategy. They view the effective summarization as strategy. So I think that's one element. Then what I've also found is that when I summarize what other people are saying and especially multiple different stakeholders, then I can think about offline and not in the context of right in the meeting, sometimes in the meeting too I guess, is how do I make this idea one click better? It's not about how do you do something radically, radically different, but taking ideas and then making it slightly better, slightly better.
(00:22:25):
When you think about that, especially from an outside-in perspective of what are the customer problems we're trying to solve and how are we going to take this to market, and don't worry about how difficult the technical implementation is going to be, then you start to get to these big ideas that can really be the change agent ideas. So, I've started doing this more and more and I think especially in the past three to six months, and I'm seeing a material difference in terms of the number of big ideas that we're going and pursuing overall as a company and also the quality of the strategic thinking that I can bring to the table, and it's been really exciting and rewarding.

**中文翻译:**
我可以举一些最近的例子。我们一直在为公司未来三年的目标做大量的战略规划，Rubrik 所在的网络安全领域变化非常快。作为一家企业，我们可以选择的方向很多。我展现战略眼光的一种方式（我也向其他人推荐这种方式）是：有时候很难凭空想出一个令人信服且简单的“为什么”，也很难凭空想出一个宏大的想法。这些都极具挑战性。我发现非常有效的第一步——也是我每天在会议中都会使用的战术——就是“总结”（summarization）。把拥有不同声音的人聚在一起，听取他们的意见，并在对话的不同阶段总结大家所说的话，以及这些话对于我们可能走向的方向意味着什么。
(00:21:34):
然后这是一个检查点，我会说：“好，这是我对现状的综合理解。这正确吗？还是我们需要再讨论一轮，因为大家对目前的结论并不完全一致？”这种总结，即便我没有加入任何新想法，我发现人们实际上会将其视为“战略”。他们认为有效的总结就是战略。这是其中一个要素。接着我还发现，当我总结了其他人的话（尤其是多个不同利益相关者的话）之后，我可以在会后（有时也在会中）思考：我如何让这个想法“再好那么一点点”？这不关乎如何做出翻天覆地的改变，而是吸取想法并让它变得稍微好一点，再好一点。
(00:22:25):
当你从“由外而内”的角度思考——我们要解决什么客户问题，我们要如何推向市场，先别担心技术实现有多难——你就会开始产生那些真正能推动变革的大想法。我开始越来越多地这样做，尤其是在过去的 3 到 6 个月里，我看到了实质性的变化：无论是公司整体追求的大想法的数量，还是我能提供的战略思考的质量，都有了显著提升。这非常令人兴奋且富有成效。

---

### [00:23:02] [Lenny Rachitsky]

**English:**
There's so much you're sharing that resonates with other podcast episodes. For example, this idea of just going one click better. I had Roger Martin on the podcast where this book, Playing to Win, which is one of the more popular strategy books, and he has this concept of betterment as a way to work on strategy. A lot of people go huge with a big strategy and vision, and his advice is just find the thing that is the biggest constraint and bottleneck to your business right now and just make it better and that's your next step. And then just keep doing that and you'll end up in a much better place over time, even though it feels like you're just doing one little thing. And so I love this idea of just picking one thing and making it one click better. There's going to be an episode that comes out right before this with Alex Komoroske, and he has this concept of the adjacent possible and it's just find the next thing that's possible and focus on that versus some big lofty thing. So I'm just sharing a bunch of stuff, that's not a question.

**中文翻译:**
你分享的很多内容都与我之前的播客节目产生了共鸣。比如，这个“再好一点点”的想法。我曾邀请过 Roger Martin，他的著作《赢在战略》（Playing to Win）是最受欢迎的战略书籍之一。他提出了“改进”（betterment）作为制定战略的一种方式。很多人喜欢搞宏大的战略和愿景，而他的建议是：找到目前业务中最大的约束和瓶颈，把它改进一点，这就是你的下一步。然后不断重复，随着时间的推移，你最终会达到一个好得多的境地，即便当时感觉只是做了一件小事。所以我很喜欢这种挑选一件事并让它“再好一点点”的想法。在这一集之前会有一集 Alex Komoroske 的节目，他提出了“相邻可能”（adjacent possible）的概念，即找到下一个可能的步骤并专注于此，而不是追求宏大空洞的目标。我只是分享一些感悟，这不算个问题。

---

### [00:23:56] [Anneka Gupta]

**English:**
That totally resonates though.

**中文翻译:**
但这确实非常有共鸣。

---

### [00:23:58] [Lenny Rachitsky]

**English:**
Okay, okay. Okay, great. And then the summarization idea, I love it. So tactical, basically any PM can do this just in a meeting just like, "Okay, let me just summarize to make sure everyone's on the same page." Funny enough, this is the feedback I get on this podcast and I haven't been doing this in our conversation yet, but I often try to summarize the person's point and everyone's like, "Oh, I love that you do that. That's so helpful." So I totally see the power of that in my experience.

**中文翻译:**
好，太棒了。关于“总结”的想法，我也很喜欢。非常具有实操性，基本上任何产品经理（PM）都可以在会议中做到这一点，比如：“好，让我总结一下，确保大家达成共识。”有趣的是，这也是我从这个播客收到的反馈——虽然在我们的对话中我还没开始这么做——但我经常尝试总结嘉宾的观点，大家都会说：“哦，我喜欢你这样做，非常有帮助。”所以我从自己的经验中完全能感受到这种力量。

---

### [00:24:22] [Anneka Gupta]

**English:**
It also makes people feel heard and especially when you have a lot of diverse voices in the room that may not agree on all things but have valid viewpoints, it helps bring people together and ultimately the diverse perspectives are going to yield better insights and better decisions for the organizations. You want that, but some people shy away from that because it's scary because you have to deal with a lot of conflict and it's a way to kind of move beyond the conflict and get to the heart of an issue, which in my mind, that's what the PM job is all about is getting to the very, very heart of a problem.

**中文翻译:**
这也会让人们感到被倾听，尤其是当房间里有很多不同的声音，大家可能在所有事情上都不一致，但都有合理的观点时。总结有助于把大家凝聚在一起。最终，多元化的视角会为组织带来更好的洞察和决策。你想要这种多元化，但有些人会因为害怕冲突而回避它。总结是一种超越冲突、直击问题核心的方式。在我看来，PM 的工作本质就是直击问题的最核心。

---

### [00:24:56] [Lenny Rachitsky]

**English:**
If someone wants to work on this skill of summarizing as kind of a tactic, can you give just an example of how you would do that? Is there like a phrase to use? Is there words or an example you could give of just like here's how it would look in a meeting?

**中文翻译:**
如果有人想把“总结”作为一种战术来练习，你能举个例子说明你会怎么做吗？有没有什么常用的短语？或者你能给出一个在会议中具体如何操作的例子吗？

---

### [00:25:10] [Anneka Gupta]

**English:**
Yeah. So, often if there's a lot of discussion going on, sometimes it can be a little hard to insert yourself. I still may insert myself and say, "Hey, let me pause here for a second and try to capture what has been said." This is what I've heard. I've heard that our customers are having these kinds of challenges. We feel like this is the way that we want to solve these challenges. We have a right to win in this way and therefore we're going to take this action.
(00:25:36):
Is everyone in agreement with that or is there some dissent about whether that's an accurate portrayal of where we've landed with this conversation? That's the way I'll frame it up and again, ending it on a question so that you're not coming in and just being like, "Hey, this is where we're at." But then inviting people to discuss and say "Yes," or "No, I agree with 90% of that or 10% off." And that helps move the conversation forward because sometimes you'll get stuck in these circular discussions that aren't moving forward and you need to figure out a way to move it forward.

**中文翻译:**
好的。通常如果讨论非常激烈，有时很难插话。但我还是会尝试介入并说：“嘿，让我先暂停一下，尝试捕捉一下刚才大家说的话。”我会说：“这是我听到的内容：我听到我们的客户面临这些挑战；我们认为这是我们想要解决这些挑战的方式；我们相信通过这种方式我们有获胜的权利（right to win），因此我们将采取这项行动。”
(00:25:36):
“大家是否同意这一点？或者对于这是否准确描述了我们对话的结论，是否有不同意见？”我会这样组织语言，并且再次强调，要以问题结束，这样你就不是在强加结论说“嘿，这就是我们的现状”，而是邀请大家讨论并表态：“是的”，或者“不，我同意 90%，但有 10% 的偏差”。这有助于推动对话，因为有时你会陷入那种原地打转、无法推进的循环讨论中，你需要想办法打破僵局。

---

### [00:26:11] [Lenny Rachitsky]

**English:**
And then you experience is just doing that makes you look more strategic and gives people the impression you're thinking strategically?

**中文翻译:**
根据你的经验，仅仅这样做就能让你看起来更有战略眼光，并给人们留下你在进行战略思考的印象？

---

### [00:26:18] [Anneka Gupta]

**English:**
Yes. Yeah.

**中文翻译:**
是的，没错。

---

### [00:26:19] [Lenny Rachitsky]

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:26:19] [Anneka Gupta]

**English:**
The other way you can do it is if you're in a room with someone and you have a whiteboard is actually summarize on the whiteboard while people are talking and then show your summarized framework or whatever on that. So that's kind of a good way to do it too. If you're having a hard time interrupting the flow of discussion or you don't feel as comfortable thinking on your feet and interrupting and then framing your point of view, you can do that. In Zoom you can also use a chat. I've done that very effectively and said, "I'm not going to interrupt the flow conversation. I'm just going to summarize in Zoom chat this is what I've heard, and this is what I think we're saying in this conversation." And then sometimes that'll get invited back into the broader conversation that's happening live on the Zoom itself.

**中文翻译:**
另一种方法是，如果你在会议室里且有白板，可以在大家说话时在白板上进行总结，然后展示你总结出的框架或其他内容。这也是个好办法。如果你觉得很难打断讨论流，或者不习惯即兴打断并陈述观点，你可以这样做。在 Zoom 会议中，你也可以使用聊天框。我曾非常有效地使用过这一招，我会说：“我不想打断大家的讨论，我只是在 Zoom 聊天框里总结一下我听到的内容，以及我认为这次对话的核心。”有时这会被引回到 Zoom 正在进行的实时对话中。

---

### [00:27:05] [Lenny Rachitsky]

**English:**
That's a much lower stakes way of doing it, and I'm picturing all the PMs listening to this, they're going to start doing this and there's going to be all these summaries now in Zoom chats and everyone will be like, "Oh my God, why is everyone sharing?"

**中文翻译:**
这是一种压力小得多的方式。我能想象到所有听这个播客的 PM 们都会开始这么做，然后 Zoom 聊天框里全是总结，大家会想：“天哪，为什么所有人都在发总结？”

---

### [00:27:14] [Anneka Gupta]

**English:**
And then Zoom AI will start just doing it all for you. Then we'll have to think again.

**中文翻译:**
然后 Zoom AI 就会开始帮你做这一切。到那时我们就得再想新招了。

---

### [00:27:19] [Lenny Rachitsky]

**English:**
And then PMs are over and AI replaced us all.

**中文翻译:**
然后 PM 的时代就结束了，AI 取代了我们所有人。

---

### [00:27:19] [Anneka Gupta]

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:27:22] [Lenny Rachitsky]

**English:**
Okay, so then just to close the loop on becoming more strategic, your advice is when someone's like, "Hey, you're not strategic enough. You need to be more strategic." Your insights is the two things to work on is one, be clear on the whys behind the ideas that you're working on and be very crystal clear. People may not be understanding why you're working on the things you want to work on, the things you're pitching. And then two is actually be the person that makes these things happen, not just put a doc out there. If you're not actually achieving them, people are going to think you're not strategic.

**中文翻译:**
好，那么总结一下关于变得更有战略眼光的建议：当有人说“嘿，你不够有战略眼光，你需要加强”时，你的见解是需要从两方面入手：第一，对你正在做的想法背后的“为什么”保持清晰，而且是非常透彻的清晰。人们可能不理解你为什么要推行你正在做或正在推销的事情。第二，真正成为让这些事情发生的人，而不仅仅是发个文档。如果你没有真正实现目标，人们还是会觉得你没有战略眼光。

---

### [00:27:53] [Anneka Gupta]

**English:**
Yep.

**中文翻译:**
没错。

---

### [00:27:53] [Lenny Rachitsky]

**English:**
Awesome. Okay. I want to talk about decision-making. You have a really interesting perspective on how to become a better decision-maker in relation to being kind of a historian, which I love this concept. Talk about that insight.

**中文翻译:**
太棒了。好，我想聊聊决策。关于如何成为更好的决策者，你有一个非常有趣的视角，即成为某种意义上的“历史学家”，我非常喜欢这个概念。谈谈这个见解吧。

---

### [00:28:07] [Anneka Gupta]

**English:**
Yeah, so I was at my previous company for 11 years, so I kind of ended up becoming the historian. And when I joined Rubrik about three years ago, I came into an organization that had a lot of history that I just didn't know about. So one of the things that I decided to do when I joined the company was to really understand what happened in the past. What were the products that we launched that weren't successful? Why weren't they successful? What was the perspective on the history of how we've decided to develop the things that we did and why? What was the perception of different people in the organization? I tried to construct this past knowledge of what had happened and what were the decisions that were made and why were those decisions made, whether they were good or bad it didn't matter, so that I could better understand how to make decisions going forward and to learn from the mistakes that I didn't personally live through.
(00:29:07):
I think that's the part that's really important about being a historian. You can always be a historian. It doesn't have to be just when you join a company, but even today I'll hear about projects from many years ago that people will bring up and I'll be like, "Tell me about this project. What happened with it? How did we decide to do this?" And just really learn and be curious about it because that gives me more context into, well, what is it that we did poorly and how can we do that better? And also, what is the baggage that people have around trying to do something similar again? Because people always come with their baggage of, oh, this hasn't worked before, so why is it going to work now? And as a product leader, you're obviously putting in place a lot of thoughts and ideas around this is what I want to go achieve and these are the initiatives. And some people are going to come and say, "Well, we've tried that before." Especially you've been at an organization that's been around for a while.

**中文翻译:**
是的，我在上一家公司待了 11 年，所以最后我自然而然地成了那里的“历史学家”。三年前我加入 Rubrik 时，进入的是一个拥有大量我不了解的历史的组织。所以我加入公司后决定做的一件事就是：真正去了解过去发生了什么。我们发布过哪些不成功的产品？为什么不成功？关于我们决定开发某些东西的历史背景和原因是什么？组织中不同人的看法是怎样的？我试图构建关于过去发生的事情、做出的决策以及决策原因的知识库（无论好坏都不重要），这样我就能更好地理解未来如何做决策，并从那些我没有亲身经历过的错误中学习。
(00:29:07):
我认为这就是作为“历史学家”真正重要的地方。你随时可以成为历史学家，不一定非得是刚加入公司时。即便到今天，当我听到人们提起多年前的项目时，我仍会问：“跟我讲讲这个项目。当时发生了什么？我们是怎么决定做这个的？”保持好奇并真正去学习，因为这能给我提供更多背景信息：我们哪里做得不好，如何改进？此外，人们对于再次尝试类似事情会有什么样的“心理包袱”？因为人们总是带着包袱：“哦，这以前没成功过，为什么现在就能行？”作为产品领导者，你显然会提出很多关于目标和举措的想法，而有些人会说：“我们以前试过那个。”尤其是当你在一个成立已久的组织中时。

---

### [00:29:56] [Lenny Rachitsky]

**English:**
I've been that guy. We've done this so many times. It didn't work. Why are we thinking about this again? Okay, so the advice is if you're new to a company especially, just study the past decisions that were made and share them out as a part of that and then as a side effect, it'll help you make better decisions because you'll have this history about what the company has done. I love that. Along the same lines of decision-making, I asked your former colleague Rachel Wolan what to ask you, and she said that your parting advice when she left to join a different company was it's not about making the right decision, it's about making the decision. That's like the things she remembered about you most, that parting advice. Talk about why that is so important and your insight there.

**中文翻译:**
我以前就是那种人：“我们都试过好多次了，没用。为什么又要考虑这个？”好，所以建议是：尤其是当你刚加入一家公司时，去研究过去做出的决策，并将其作为工作的一部分分享出来。副作用是，这会帮你做出更好的决策，因为你掌握了公司过往的经验。我喜欢这个。关于决策，我问过你的前同事 Rachel Wolan 该问你什么，她说当她离开去另一家公司时，你给她的临别赠言是：“重要的不是做出正确的决定，而是做出决定。”那是她对你印象最深的一句话。谈谈为什么这如此重要，以及你的见解。

---

### [00:30:42] [Anneka Gupta]

**English:**
Very easy to get into analysis paralysis before making a decision and say, "Well, if I just had this one more data point, if I just knew this, then I could make a decision." But the reality is that you were always operating off of imprecise information as a product leader. What I've found is that once you commit to a decision, you actually learn more post committing to that decision about what's going to work and not going to work, and you move out of the hypothetical. And as long as your decision is like 70% right, you can iterate on that 20, 30% in either direction, but if you don't commit, then you don't actually get any new information that is high fidelity and high quality. So, I'm a big believer in making decisions...
(00:31:28):
I know you've had a few guests talk about speed is super important in organizations. Well, I think making decisions quickly and then being able to iterate on them is a form of that. Just make a decision. Don't make it uninformed, but have a strong hypothesis and then just keep testing whether that hypothesis is accurate or not and you'll shift here and there. You might build something that you have to throw away 20% of the work on, but that's okay. It's better than making no decision at all because you won't get any new information if you don't make any decision at all.

**中文翻译:**
在做决定之前很容易陷入“分析瘫痪”（analysis paralysis），心想：“如果我再多一个数据点，如果我再多了解一点，我就能做决定了。”但现实是，作为产品领导者，你永远是在基于不精确的信息进行操作。我发现，一旦你承诺了一个决定，你在承诺之后学到的关于“什么行得通、什么行不通”的知识，比承诺之前要多得多，因为你脱离了假设阶段。只要你的决定有 70% 是正确的，你就可以在剩下的 20% 或 30% 上进行迭代。但如果你不做出承诺，你就无法获得任何高保真、高质量的新信息。所以，我非常坚信要做出决定……
(00:31:28):
我知道你的一些嘉宾谈过速度对组织至关重要。我认为快速决策并能够基于此进行迭代就是速度的一种形式。直接做决定。不是说在毫无根据的情况下瞎做，而是要有一个强有力的假设，然后不断测试这个假设是否准确，并进行微调。你可能会开发出一些最后不得不扔掉 20% 工作量的东西，但这没关系。这总比不做决定好，因为不做决定你就得不到任何新信息。

---

### [00:31:56] [Lenny Rachitsky]

**English:**
As a PM that might be listening to this, feeling like, "Okay, yeah, that sounds great." But then I make a bad decision and then Anneka is going to be like, "You messed up here. You've shipped the wrong thing here. It didn't work." How do you create a culture where people don't feel that and aren't as afraid of making bad decisions and making decisions with 70% of the information?

**中文翻译:**
作为一名正在听这段话的 PM，可能会觉得：“好吧，听起来不错。”但万一我做了一个错误的决定，然后 Anneka 就会说：“你搞砸了，你发错货了，这没起作用。”你如何创造一种文化，让人们不会有这种顾虑，不再害怕做出错误的决定，也不再害怕在只有 70% 信息的情况下做决定？

---

### [00:32:19] [Anneka Gupta]

**English:**
I think part of it comes down to making sure there's a strong hypothesis that everyone understands when you're making the decision. Or it might not just be one hypothesis, it might be a series of hypotheses and assumptions that we're making that are informing the decision. So it might be a hypothesis that this segment of customers is going to be willing to pay for this product because it's solving an urgent and important enough need for them that they're going to go do it and this is the evidence we have to find it, but this is also the stuff we don't know.
(00:32:52):
Then along the way, we learn whether that hypothesis is true or not. And so at the end of the day, if something didn't work out, we can go back to the original hypothesis and say, "Well, this is what we learned in this process that our hypothesis was actually not true, and we learned all of this after the fact." I think the way to make a culture of risk taking and people willing to make these bets and go out on a limb is to reward the learning versus the outcome. That's what I try to focus on is if we're constantly learning, it is okay if we make bad decisions, but we learn from them and we get better for next time. Even in making this bad decision, we learn something about our customers or our business that we otherwise wouldn't have learned that we can use in another context.

**中文翻译:**
我认为部分原因在于确保在做决定时，每个人都理解背后的强有力假设。或者不只是一个假设，而是一系列支撑决策的假设和前提。比如一个假设可能是：这部分客户愿意为这个产品付费，因为它解决了他们足够紧迫且重要的需求，而这是我们目前掌握的证据，但这些是我们还不知道的部分。
(00:32:52):
然后在执行过程中，我们会了解到这个假设是否成立。所以最终如果事情没成，我们可以回到最初的假设说：“在这个过程中我们学到的是，我们的假设其实是不成立的，这些是我们事后才了解到的。”我认为建立一种敢于冒险、愿意下注的文化，关键在于“奖励学习过程而非仅仅奖励结果”。这就是我努力关注的：如果我们一直在学习，那么做出错误的决定是可以接受的，只要我们能从中吸取教训并在下次做得更好。即便是一个错误的决定，我们也学到了关于客户或业务的一些原本无法获知的知识，这些知识可以应用到其他场景中。

---

### [00:33:40] [Lenny Rachitsky]

**English:**
First of all, I love that this comes back to your strategic lesson of just if you have a strong why behind something, that's incredibly powerful and people will be confident that you're thinking strategically. Two, I was just at a talk with Zuck. He's being interviewed at the Chase Center, the Acquired Podcast at this whole event, and his main thing that he talked about that he values most in the culture of Facebook is learning faster than anyone else. Shipping stuff that isn't perfect, but just so that you can get one more turn and learn something faster than someone else. So, that super resonates that's Facebook's culture. Is there an example of something you worked on where you did that, where you kind of ship something that you weren't fully confident in and you learn faster?

**中文翻译:**
首先，我喜欢这一点又绕回到了你的战略课：如果你对某件事有强有力的“为什么”，那是非常强大的，人们会相信你在进行战略思考。其次，我最近刚听了扎克伯格的一个讲座。他在大通中心接受 Acquired 播客的采访，他提到在 Facebook 文化中他最看重的一点就是“比任何人都学得快”。发布不完美的东西，只是为了能多迭代一轮，比别人更快地学到东西。这与 Facebook 的文化非常契合。在你做过的事情中，有没有类似的例子？即发布了一些你并不完全有把握的东西，从而学得更快？

---

### [00:34:26] [Anneka Gupta]

**English:**
Yeah, I mean, I think there's a lot because anytime you're shipping products, there's so many different things that could go right and wrong. There's a situation where we created a really amazing high value product and we decided not to monetize it, and then we realized after the fact, "Wait, we should have monetized it. So, we're trying to figure out how to package some new capabilities to monetize this thing that we know has a lot of value without taking away what we've already given to existing customers." So that was something we learned along the way that we originally didn't think, oh, we should monetize this, but then we realized that there's actually an avenue to do that after the fact. There's been other things where we've developed a set of capabilities thinking that it will solve for this new persona's problems, but then we misunderstood how easy it was going to be to go sell to that new persona within our own organization. I've made that mistake many times actually.
(00:35:26):
And so now I think now what I've taken from that is really know how you're going to sell something and who's going to do the selling before you actually go build out the product. Because if you don't have that right focus, you may build out the best product and yet it's going to get zero adoption because no one in your organization is ready to sell it. So there's tons of stuff like that where it's like been okay, yeah, we've learned something from this, and it's not all throwaway, it just means that we've got to do something differently for this product and we need to do something differently for our organization going forward.

**中文翻译:**
是的，我觉得有很多例子，因为任何时候发布产品，都有太多可能出错或成功的地方。有一次我们开发了一个非常棒、高价值的产品，但我们决定不将其货币化。事后我们意识到：“等等，我们本该收费的。”所以现在我们正尝试如何打包一些新功能，在不收回已提供给现有客户的利益的前提下，对这个高价值产品进行货币化。这是我们在过程中学到的：起初没想过收费，后来发现其实是有路径的。还有一些情况，我们开发了一系列功能，以为能解决新用户画像的问题，但我们误判了在公司内部向这个新画像销售产品的难度。实际上我犯过很多次这种错误。
(00:35:26):
所以现在我吸取的教训是：在真正开发产品之前，一定要搞清楚你要如何销售它，以及谁来负责销售。因为如果你没有这个重点，你可能开发出了最好的产品，却发现根本没人用，因为你的组织里没人准备好去卖它。有很多类似的事情，虽然没达到预期，但我们学到了东西，这并不全是浪费，只是意味着我们需要对这个产品采取不同的策略，并且在未来对组织进行调整。

---

### [00:36:01] [Lenny Rachitsky]

**English:**
This episode is brought to you by Eppo. Eppo is a next-generation A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams. Companies like Twitch, Miro, ClickUp and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and for understanding the performance of new features. And Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does.
(00:36:31):
When I was at Airbnb, one of the things that I loved most was our experimentation platform where I could set up experiments, easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more with advanced statistical methods that can help you shave weeks off experiment time and accessible UI for diving deeper into performance and out-of-the-box reporting that helps you avoid annoying prolonged analytic cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the A/B testing flywheel. Eppo powers experimentation across every use case, including product, growth, machine learning, monetization, and email marketing. Check out Eppo at geteppo.com/Lenny and 10X your experiment velocity. That's geteppo.com/Lenny.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依赖 Eppo 来驱动他们的实验。实验对于驱动增长和理解新功能表现越来越重要。Eppo 能够帮助你提高实验速度，同时解锁其他商业工具无法提供的严谨深度分析。
(00:36:31):
当我在 Airbnb 时，我最喜欢的东西之一就是我们的实验平台，我可以独立设置实验、轻松排查问题并分析表现。Eppo 不仅能做到这些，还拥有先进的统计方法，可以帮你缩短数周的实验时间，其易用的 UI 方便深入研究表现，开箱即用的报告能帮你避免烦人且漫长的分析周期。Eppo 还能让你轻松与团队分享实验见解，为 A/B 测试飞轮激发新灵感。Eppo 支持包括产品、增长、机器学习、货币化和邮件营销在内的各种应用场景。访问 geteppo.com/Lenny 了解 Eppo，让你的实验速度提升 10 倍。

---

### [00:37:20] [Lenny Rachitsky]

**English:**
I want to come back to something Rachel also shared with me when asked her what questions to ask you. By the way, first of all, she spent a lot of time raving about how amazing you are first. That was the first set of conversations, and then she came up with a bunch of questions to ask you. And so her other question was about how good you are at navigating very difficult personalities. She showed this quote that she constantly saw you interact with and bring together several leaders who had much higher egos and very disparate points of view who are not informed or thoughtful or as gracious as you were, and she also said you have very low ego. She wanted me just to ask you for what you've learned about how to navigate very difficult personalities and help people align when it's not neatly what they want to do.

**中文翻译:**
我想回到 Rachel 跟我分享的另一件事。顺便说一下，她先是花了很多时间赞美你有多么出色。那是我们对话的第一部分，然后她才提出了一堆要问你的问题。她的另一个问题是关于你如何擅长应对非常难相处的性格。她提到，她经常看到你与几位自我意识（ego）极强、观点迥异、且不像你那样见多识广、深思熟虑或谦逊有礼的领导者互动并让他们达成一致。她还说你是一个自我意识非常低的人。她想让我问问你，关于如何应对难相处的性格，以及在大家意见不统一时如何促成一致，你学到了什么？

---

### [00:38:06] [Anneka Gupta]

**English:**
I try to embody the mindset of feeling like and believing that I can work with anyone. I think what I do when I hit a difficult personality and difficult personalities come in all shapes and sizes and forms is I really try to understand what drives that person. What is it that they really care about? Hopefully they care about something deeply about the company and making the company successful. Sometimes they care about their own personal career, how they're showing up, what people view of them. That's fine. I just need to understand what it is that they really care about, and then if I need something from them, what is it that I can do to motivate them to find what I need from them important? And trying to make that match of they have this desire kind of like building a product, they have this desire and how am I going to get them to care about the thing that I want to care about?
(00:39:08):
The other thing I do is instead of feeling like anger or frustration with the person and instead trying to shift that to a mindset of feeling gratitude and a positive emotion about them is I look at them and I ask myself what can I learn? Maybe I don't want to adopt their personality or operate the way that they are operating, but everyone has something that they can teach you, whether it's their communication style or the way they're able to marshal people together, the way they come up with visionary ideas, whatever it may be, trying to study that person and be curious about them, learn from them and then thank them for that and feel the generosity genuinely about what I got from this situation. It's easier to do sometimes than others, but I think it comes back to that abundant mindset. If you can approach it with an abundant mindset, then you can really consciously do this and when you actually learn something, you will feel the gratitude when you recognize that you are able to get something from that.

**中文翻译:**
我努力践行一种心态，即相信我可以与任何人合作。当我遇到难相处的性格时（难相处的人有各种各样的形式），我所做的是努力理解是什么在驱动那个人。他们真正关心的是什么？希望他们深切关心的是公司以及如何让公司成功。有时他们关心的是个人职业生涯、个人形象或别人对他们的看法。这也没关系。我只需要理解他们真正关心什么，然后如果我需要他们的配合，我该如何激励他们，让他们觉得我需要的东西对他们也很重要？这就像开发产品一样：他们有某种需求，我如何让他们关心我所关心的事？
(00:39:08):
我做的另一件事是，与其对那个人感到愤怒或沮丧，不如尝试转向一种感恩和积极的心态。我会看着他们问自己：我能学到什么？也许我不想模仿他们的性格或做事方式，但每个人都有值得学习的地方，无论是沟通风格、召集众人的能力，还是提出远见卓识的想法。尝试研究那个人，对他们保持好奇，向他们学习，然后为此感谢他们，真诚地感受从这种情况中获得的收获。有时这很难做到，但我认为这又回到了那种“丰盈的心态”。如果你能以这种心态去面对，你就能有意识地做到这一点。当你真正学到东西时，你会意识到自己有所收获，从而产生由衷的感激。

---

### [00:40:13] [Lenny Rachitsky]

**English:**
I love that this connects with your other original piece of advice of just turning something into this is going to be fun. Let's make this fun. And in this case it's like make it great. What can I learn from this person even though they're really annoying me and it's frustrating and don't want anything done? Then your other point of understanding what they want and kind of using that as a way to pull them in your direction, how do you figure out what they want? Do you have any tricks for just like, "Here's how I learn what this person's motivations are and goals are"?

**中文翻译:**
我喜欢这与你最初的建议联系在一起，即把事情变得有趣。在这种情况下，就像是“把它变好”。即便这个人让我很烦、很沮丧、什么都不想配合，我能从他身上学到什么？关于理解他们的需求并以此引导他们，你有什么诀窍吗？比如“我是如何了解这个人的动机和目标的”？

---

### [00:40:42] [Anneka Gupta]

**English:**
Talk to other people that have worked with them before and have done so successfully. So that might be people that work for them because if you work for a person like that, you have to figure out and or you're successful working for that person, you probably understand what makes them tick. So that's one, or talk to people that are peers, anything like that to try to understand and build this view of this person that helps me empathize with them and also helps me understand what they may be wanting to get out of a situation and why.

**中文翻译:**
去和那些以前与他们共事过且合作成功的人聊聊。这可能是他们的下属，因为如果你为那样的人工作且很成功，你可能很清楚他们的软肋或动力。这是其一。或者去和他们的同僚聊聊，尝试理解并构建对这个人的认知，这能帮我产生共情，也能帮我理解他们在某种情况下想要得到什么以及原因。

---

### [00:41:16] [Lenny Rachitsky]

**English:**
I love that. Yeah, they don't have to be involved in that. You just ask other people, "What is this person's motivations?" And then the idea is connect what they want with the thing you're trying to achieve. Beautiful. I really love this idea of when you're frustrated by someone just reframing it to like, "I'm grateful I'm going to learn something from this person in our interaction, even though they're making life hard for me." I really love that. Another skill I hear you're really strong at, and this comes from another one of your colleagues, Hema Mohan shared that you're world-class at giving feedback, giving hard feedback, and receiving hard feedback. And so I want to just ask you, what have you learned about how to do this? It's very hard to give hard feedback. That's why it's called hard feedback. So from either direction, what have you learned about receiving hard feedback or giving hard feedback where someone actually hears Zoom doesn't get defensive?

**中文翻译:**
太棒了。是的，不需要直接找本人，问问其他人：“这个人的动机是什么？”然后把他们的需求与你的目标联系起来。漂亮。我真的很喜欢这种在被某人激怒时，将其重构为“我很感激能从这次互动中学到东西，即便他们让我的日子不好过”的想法。我还听说你擅长另一项技能，这是你的另一位同事 Hema Mohan 分享的：你在给予反馈（尤其是严厉反馈）和接受严厉反馈方面是世界级的。所以我想问问，关于如何做到这一点，你学到了什么？给予严厉反馈很难，所以才叫严厉反馈。无论是接受还是给予，你学到了什么能让对方真正听进去而不产生防御心理的方法？

---

### [00:42:07] [Anneka Gupta]

**English:**
The answer is so much, I've learned so much from it. So maybe I'll start with receiving feedback. So, on the receiving feedback side, I think it's very natural to feel upset, defensive, all the negative emotions when you first see a piece of negative feedback, whether it's you're reading it in a employee survey or you're receiving it in a one-on-one from a direct report or from a manager or from a peer. And I try to let myself just feel the things that I'm going to feel. Sometimes that's an emotional feeling, sometimes that means I want to step out of the room or it depends on who I'm talking to, but let myself feel the things that I'm going to feel. Then once that's passed, whether that's a few hours or a few days, don't react. Don't try to say, "Oh, I don't believe this." Listen. And then ask myself, okay, well where is this feedback coming from? Why am I getting this feedback?
(00:43:07):
And try to be super curious about it. And that might be going back to the person that gave me the feedback and maybe asking someone that's a peer somewhere in the organization that might have more context and flavor to what the feedback really is, just trying to learn. Then I can decide, do I think this is valid or not? Is this something I should do something about or not? Actually, all feedback I think is valid. People's feelings are valid, but it doesn't mean that you need to do something about all of those things. Going through that process and letting myself ride the emotional wave and not judging myself for that, but then not reacting and letting myself then figure out and come back curious. I think when you come back curious, people then want to give you more feedback because they know that you're listening and that you're hearing what they say.

**中文翻译:**
答案是太多了，我从中受益匪浅。也许我先从接受反馈开始。在接受反馈方面，当你第一次看到负面反馈时（无论是员工调查、一对一面谈、来自下属、上司还是同僚），感到难过、防御或产生各种负面情绪是非常自然的。我会允许自己去感受这些情绪。有时是情绪化的，有时意味着我想离开房间，这取决于我在和谁说话，但我会让自己去感受。一旦这种情绪过去了（可能是几小时或几天后），不要立刻反应。不要试图说：“哦，我不相信这个。”去倾听。然后问自己：这个反馈是从哪儿来的？为什么我会收到这个反馈？
(00:43:07):
尝试保持极大的好奇心。这可能意味着回到给反馈的人那里，或者询问组织中的其他同僚，以获得更多背景信息，了解反馈的真实含义。只是为了学习。然后我可以决定：我认为这是否有效？我是否应该为此做点什么？实际上，我认为所有反馈都是有效的，因为人们的感受是真实的，但这并不意味着你需要对每一条反馈都采取行动。经历这个过程，让自己度过情绪波动期，不为此评判自己，然后不带情绪地回归好奇心。我认为当你带着好奇心回归时，人们会更愿意给你反馈，因为他们知道你在倾听并理解了他们的话。

---

### [00:43:55] [Lenny Rachitsky]

**English:**
So the advice is feel it, don't block it off and be like, "No, no, no, no, no, this isn't real." So fully let your body go through the roller coaster of feeling the negative feedback. Sometimes the feedback is just like, "No, this isn't actually a thing." Do you have any just heuristic of like I should actually pay attention to this deeply or just like let me wait for more data points?

**中文翻译:**
所以建议是：去感受它，不要屏蔽它并说“不不不，这不是真的”。让你的身体完整经历负面反馈带来的情绪过山车。有时反馈可能确实不属实。你有没有什么启发式的判断标准（heuristic），来决定是该深入关注这条反馈，还是先等等看更多的数据点？

---

### [00:44:15] [Anneka Gupta]

**English:**
Yeah, I think in product you receive feedback all the time for your organization or for yourself, and you can't make everyone happy. Everyone wants a different thing from product. So I think this comes up quite often where there's a lot of feedback for the organization or for you as a leader and you have to decide what to focus on and what not to focus on. I always try to anchor on, "Well, what is best for the company and what does the company need for me and for my team at this point in time?" There's stuff that is a must-have on that list, and there's stuff that's nice to have. Sometimes there's just too many must-haves to go deal with the nice-to-haves and you have to just be like, well, I know this is a problem, or I know we could be 10% better in this, but it actually doesn't matter as much as fixing these things that are really, really important and are really what's going to help my organization deliver what it needs to for the company and for the business overall.

**中文翻译:**
是的，我认为在产品领域，你随时都会收到针对组织或你个人的反馈，你不可能让所有人满意。每个人对产品的需求都不同。所以经常会出现针对组织或领导者的大量反馈，你必须决定关注什么，忽略什么。我总是锚定在：“什么对公司最有利？公司目前需要我和我的团队做什么？”清单上有“必须做”的，也有“做了更好”的。有时“必须做”的事情太多了，顾不上那些“做了更好”的，你只能说：我知道这是个问题，我知道我们可以做得更好，但目前它没有解决那些真正重要的事情重要，而那些重要的事情才是能帮助我的组织为公司和整体业务交付价值的关键。

---

### [00:45:13] [Lenny Rachitsky]

**English:**
In terms of receiving hard feedback, so you shared one example or I shared an example where someone said you weren't strategic enough. Is there another example of receiving hard feedback that you got that you're like, "Ugh, that sucks"? Either earlier in your career or more recently, anything else come to mind?

**中文翻译:**
关于接受严厉反馈，你分享了一个例子（或者说我提到了那个例子），即有人说你不够有战略眼光。还有没有其他让你觉得“呃，这感觉真糟”的严厉反馈？无论是职业生涯早期还是最近，有没有什么想到的？

---

### [00:45:26] [Anneka Gupta]

**English:**
I mean all the time. So there's always hard stuff. Well, people will give feedback of, "Oh, I feel like we're not moving fast enough on our roadmap and priorities. We need to be doing more. Why aren't we moving fast?" Or-

**中文翻译:**
我是说，一直都有。总会有困难的事情。比如，人们会反馈说：“哦，我觉得我们在路线图和优先级上的进展不够快。我们需要做更多。为什么我们不快点？”或者——

---

### [00:45:47] [Lenny Rachitsky]

**English:**
Never heard that one before.

**中文翻译:**
这反馈还真是头一回听说（讽刺）。

---

### [00:45:48] [Anneka Gupta]

**English:**
Never heard that one before, right? Or disparaging the direction that we're taking a certain product because they don't agree with it because a competitor is doing something else, but we've decided for our reasons that we're not going to go follow that path. There's always something that people have negative feedback about and sometimes I'm like, "Okay, this is an eye roll." I understand where they're coming from. I understand why they're giving me this feedback, but I also don't agree that we should change directions because of it. I don't know, some of the things cut deeper than others, but I think people are making personal statements about my team or they're feeling like, "Hey, the product team isn't listening to feedback, or the product team has a bad culture. Anneka isn't listening." Things like that cut deep and are a lot more... I know like physiologically they make me kind of seize up a little bit, but again, then I try to feel the things I'm going to feel and try to understand why are they saying that. Why do they really feel that and what does that mean behaviorally that I have to do differently or my team has to do differently or maybe just two people on my team need to do differently and someone is extrapolating this out to be a much bigger problem than actually is?

**中文翻译:**
从来没听过，对吧？或者贬低我们某个产品的方向，因为他们不认同，或者因为竞争对手在做别的事情，但我们基于自己的理由决定不走那条路。总有人会有负面反馈，有时我会想：“好吧，翻个白眼。”我理解他们的立场，理解他们为什么给这个反馈，但我不同意因此改变方向。有些反馈比其他的更伤人，比如当人们对我的团队进行人身攻击，或者觉得“产品团队不听取反馈，或者产品团队文化很糟糕，Anneka 不听劝”。这类话伤得很深，而且在生理上会让我感到一阵紧缩。但同样地，我会尝试去感受这些情绪，并尝试理解：他们为什么要这么说？他们真实感受是什么？这是否意味着我在行为上需要做出改变，或者我的团队需要改变，或者只是团队里的某两个人需要改变，而对方把这归结为一个比实际情况大得多的问题？

---

### [00:46:59] [Lenny Rachitsky]

**English:**
Awesome. Okay, and then we were going to shift to what you've learned about giving hard feedback so that someone actually listens and doesn't just put up a shield and like, "It's not real."

**中文翻译:**
太棒了。好，那我们转到关于给予严厉反馈的经验：如何让对方真正听进去，而不是立刻竖起盾牌说“这不是真的”。

---

### [00:47:10] [Anneka Gupta]

**English:**
So I think in giving feedback, you can never fully control how someone else is going to respond to that feedback. All you can control is what you do, your body language and what you say. What I have found is that if I can convey, and I will say this very directly to people, I care so much about you and I'm giving you this feedback because I want you to be successful and I want you to be able to reach the pinnacle of what I know you can accomplish. And you do all of that setup and you don't just hope that they understand that, you actually explicitly say that and you show that in your body language, then it makes the other person much more receptive to hearing whatever you have to say. Then I think the other piece is that you've got to be direct.
(00:47:57):
The worst feedback is the kind of passive-aggressive feedback versus saying directly this is what you are doing or this is how you are being perceived in the organization, and here are the three things that you can do to change the way you're being perceived or to change the outcomes of what you're driving or become more strategic or whatever it is that I'm trying to give feedback on. I do a lot of prep before I give someone a lot of feedback. I really think about how can I frame this in a way that's going to resonate with them that doesn't come across as attacking them, but helps them understand why what they're doing isn't working or is being perceived poorly? And try to give them examples and even examples that I've personally had to go through myself of how I've approached those situations. And let them ask questions and brainstorm with them, be part of the solution versus saying like, "Here's all this feedback, now you go figure out what to do with it."

**中文翻译:**
我认为在给予反馈时，你永远无法完全控制对方的反应。你唯一能控制的是你自己的行为、肢体语言和言语。我发现，如果我能传达出——而且我会非常直接地对他们说——“我非常关心你，我给你这个反馈是因为我希望你成功，我希望你能达到我知道你能达到的巅峰。”你做了这些铺垫，而且不只是希望他们能理解，而是明确地说出来，并通过肢体语言表现出来，那么对方就会更容易接受你接下来的话。另一部分是，你必须直接。
(00:47:57):
最糟糕的反馈是那种阴阳怪气（passive-aggressive）的，而不是直接说：“这是你正在做的事，或者这是你在组织中的形象，这里有三件事你可以做，来改变这种形象，或者改变你推动的结果，或者变得更有战略眼光。”在给别人大量反馈之前，我会做很多准备。我会思考：我该如何组织语言，让它能引起共鸣，而不是像在攻击他们？如何帮他们理解为什么他们现在的做法行不通或评价不高？我会给他们举例子，甚至是分享我亲身经历过的类似情况。然后让他们提问，和他们一起头脑风暴，成为解决方案的一部分，而不是丢下一句“这是给你的反馈，你自己看着办吧”。

---

### [00:48:56] [Lenny Rachitsky]

**English:**
This reminds me of Radical Candor. Basically make people feel like you care deeply about them, but be very direct about what they can be doing better. Are there phrases or ways that you set up the conversation? You mentioned a few of just like, "I want to help you become the best version of who you could be and what you're capable of." Is there any phrases you find helpful that you come back to often of just a way to start the conversation?

**中文翻译:**
这让我想起了《彻底坦率》（Radical Candor）。基本上是让人们感受到你深切地关心他们，但对他们可以改进的地方保持非常直接的态度。有没有什么你常用的短语或开场白？你刚才提到了一些，比如“我想帮你成为最好的自己”。还有没有其他你觉得好用的、经常使用的开场方式？

---

### [00:49:21] [Anneka Gupta]

**English:**
Yeah, I think what I started with is like, "I care a lot about you. You have a lot of potential. I can see you doing these kinds of things. I can see you getting to where you want to go in your career." Sometimes I even start the conversation by asking them, "What do you want to do? Where do you want to go in your career?" And that will help me frame up which of these things are important. Because honestly, if someone wants to be eventually like a CPO, the feedback I'm going to give to them is very different than if they're like, "Hey, I don't really want to manage people ever. I just want to be the best I see I can ever be." I'm not going to give them the same feedback. And so having that conversation up front also allows them even before I jump into the feedback to give them their perspective of what they want and then I can tailor the conversation more to what they're looking for.
(00:50:04):
I think that has really helped as well make sure that I focus on the things that are going to really matter. During the feedback conversations, I also try to frame things as this is how you're being perceived than you are doing X. Because I think even though it's hard to hear, "Oh, hey, this person doesn't perceive you in the way that you may think," then we can talk about, "Well, what are ways that we can change the perception?" I also think it's important because sometimes people are like if you say, "Hey, I don't think you're X," and then they're like, "Well, yes I am." And if you're saying, "Hey, well this is how other people perceive you including me, but maybe this is not what you are intending," and you actually say that, you're giving them the benefit of the doubt of actually how they're trying to show up is different than how people are perceiving them. You can have a better conversation then around, "Well, what can you do to change that perception?"

**中文翻译:**
是的，我通常会以“我非常关心你。你很有潜力。我能预见到你可以做这些事，能达到你职业生涯的目标”开始。有时我甚至会先问他们：“你想做什么？你的职业目标是什么？”这能帮我确定哪些反馈是重要的。因为坦白说，如果有人最终想成为 CPO，我给的反馈会和那些“我永远不想带人，只想做最强个人贡献者”的人完全不同。我不会给他们同样的反馈。所以先进行这种对话，能让他们在听反馈之前先表达自己的愿景，然后我可以根据他们的需求量身定制谈话内容。
(00:50:04):
我认为这也有助于确保我关注那些真正重要的事情。在反馈过程中，我也尝试将事情描述为“这是你给人的印象”，而不是“你做了某事”。因为我觉得，即便听到“某人对你的看法和你想象的不一样”很难受，我们也可以讨论：“那么，我们有哪些方法可以改变这种看法？”我认为这很重要，因为如果你直接说“我觉得你不够 X”，对方可能会反驳“不，我是 X”。但如果你说“这是包括我在内的其他人对你的看法，但这可能不是你的本意”，你其实是在给他们台阶下，承认他们的初衷可能是好的，只是表现出来的效果不一样。这样你们就能围绕“如何改变这种印象”展开更好的对话。

---

### [00:51:01] [Lenny Rachitsky]

**English:**
You mentioned I see product managers, and this is a good segue too. You're a big deal, fancy chief product officer person. A lot of people listening to this podcast are early career PMs or trying to get into product. I want to ask a couple of questions along these lines. One is about getting into products. So, interestingly, you got into product the same way I got into product, which is you used to be an engineer and then you moved into product within a company, which is maybe one of the simplest ways to get into product potentially. For people that are trying to break into product management, what advice do you often give them of how they could go about doing it? I know there's never the silver bullet, but what's your advice?

**中文翻译:**
你提到了产品经理，这正好是个很好的过渡。你是一位重量级的首席产品官。很多听众是职业生涯早期的 PM，或者正尝试进入产品领域。我想问几个相关的问题。一个是关于入行。有趣的是，你进入产品领域的方式和我一样：以前是工程师，然后在公司内部转岗做产品，这可能是最简单的入行方式之一。对于那些尝试进入产品管理领域的人，你通常会给他们什么建议？我知道没有万灵药，但你的建议是什么？

---

### [00:51:41] [Anneka Gupta]

**English:**
I definitely think doing it within the same company is a lot easier than trying to switch companies and switch jobs at the same time because when you're within a company, you've already built credibility, hopefully. And if you haven't, then go crush it at your job so you build the credibility. Then you can start to raise your hand, interact with the product team, take on projects and do things that allow you to get some experience and build a relationship with a leader on the product team who then may be willing to take a chance on you to put you into a product role even if you don't have the experience. Especially when you're within the same company, you bring other things to the table. Let's say you're working in customer support, well, you have a huge amount of knowledge about what are the big problems that people are calling up the support team or opening tickets on the support team for, and that is valuable knowledge for being a product manager.
(00:52:33):
You're coming from the sales side, you're coming with a knowledge of how to sell the product, what really resonates, how do you do the objection handling, and that can be a valuable perspective. If you come from the engineering side, but you understand how the product is built and you understand that technical nuances of that well, that can also be a valuable way to enter into the product team. That way, even though you don't have the direct product experience, you're still bringing something to the table where you are going to have to get trained on core product management, but you're not going to have to be totally trained on the business or the technology.

**中文翻译:**
我绝对认为在同一家公司内部转岗比同时换公司和换职位要容易得多。因为在公司内部，你（希望）已经建立了信誉。如果没有，那就先在现有岗位上做出成绩，建立信誉。然后你可以开始主动请缨，与产品团队互动，承担一些项目，积累经验，并与产品团队的领导建立关系，这样即便你没有经验，他们也可能愿意给你一个机会。尤其是当你身处同一家公司时，你能带来其他价值。比如你在客户支持部门，你对客户反馈最多的问题、最常开的工单了如指掌，这对 PM 来说是极其宝贵的知识。
(00:52:33):
如果你来自销售部门，你了解如何销售产品、什么能引起共鸣、如何处理异议，这都是宝贵的视角。如果你来自工程部门，你了解产品是如何构建的，熟悉技术细节，这也是进入产品团队的有效途径。这样，即便你没有直接的产品经验，你依然能为团队带来价值。你只需要接受核心产品管理的培训，而不需要在业务或技术上从零学起。

---

### [00:53:06] [Lenny Rachitsky]

**English:**
So is the advice basically get a job in any function, not necessarily any function, but join a company however you can essentially and then push to try to get into the product team in some form?

**中文翻译:**
所以建议基本上是：先在任何职能部门找份工作（不一定是任何职能，但尽可能加入一家公司），然后想方设法以某种形式进入产品团队？

---

### [00:53:19] [Anneka Gupta]

**English:**
Yeah, I think join a product adjacent function, which honestly pretty much every function is product adjacent, because what function does product not engage with, but as closely product adjacent as possible, and then yeah, find your way into the product world from there.

**中文翻译:**
是的，我认为加入一个与产品相关的职能部门（坦白说，几乎所有职能都与产品相关，因为产品部门无处不在），尽可能靠近产品，然后从那里寻找进入产品世界的路径。

---

### [00:53:34] [Lenny Rachitsky]

**English:**
Ideally there's something within the company, there's some program I imagine that does this sort of thing. Some companies have something structured, some are just kind of ad hoc. Is there anything there you're just like should you talk about this in your interview just like, "Hey, I would really love to become product manager someday." Do you have anything along those lines that would help me get into that or not? Or should you not talk?

**中文翻译:**
理想情况下，公司内部会有一些类似的项目。有些公司有结构化的转岗机制，有些则是随机的。你觉得在面试时应该提这件事吗？比如问：“嘿，我未来很想成为产品经理，你们有没有什么机制能帮我实现这个目标？”还是说最好别提？

---

### [00:53:52] [Anneka Gupta]

**English:**
Well, I think it depends. For instance, when I joined LiveRamp, which was my previous company as a software engineer, I actually did say in the interview process I want to become a product manager I think. At that point I was still early in my career, I didn't know for sure, but I said that. Now that was a 20-person startup, so it was worth saying it because they didn't really have a product team and I wanted to put it out there that that was something I was interested in growing into.
(00:54:17):
If you're joining a 5000-person company, you're hiring manager is probably not going to receive it well if you're like, "Hey, I'm interviewing for product marketing, but really what I want to do is go into product." So, it just kind of depends on the company and the stage. You have to play that wisely. But I think once you're in a company, then finding a way to make a relationship with the product leader, or if you're in a startup that is really small and they don't have product management, well then you have the opportunity to take on projects for sure that are product management related because no one is doing that work. Really taking initiative to do that so that you can find an inroad into product management.

**中文翻译:**
这取决于具体情况。例如，当我作为软件工程师加入上一家公司 LiveRamp 时，我确实在面试中说过我想成为产品经理。当时我职业生涯还很早期，并不完全确定，但我说了。那是一家只有 20 人的初创公司，所以值得一说，因为他们当时还没有正式的产品团队，我想表达我有兴趣往那个方向发展。
(00:54:17):
但如果你是加入一家 5000 人的大公司，如果你说“我面试的是产品市场（PMM），但我真正想做的是产品经理”，招聘经理可能不会太高兴。所以这取决于公司规模和阶段，你需要灵活应对。但一旦你进入了公司，就要想办法与产品领导建立联系。或者如果你在一家非常小的初创公司，他们还没有产品管理职能，那你绝对有机会承担一些产品管理相关的工作，因为没人做。主动出击，这样你就能找到进入产品管理的切入点。

---

### [00:54:57] [Lenny Rachitsky]

**English:**
Kind of along these lines, you have a really unique perspective on new PMs because you teach product management at Stanford. You've been doing that for a while. I just want to ask you work with a lot of people that are new to product, thinking about getting into product, then get into product. What do you find are the things that new PMs or people getting into product most misunderstand about the role of PM or are most surprised by when they become product managers?

**中文翻译:**
说到这儿，你对新 PM 有非常独特的见解，因为你在斯坦福教产品管理课，已经教了一段时间了。我想问问，你接触过很多产品新人，或者想入行的人。你发现新 PM 或想入行的人对 PM 这个角色最大的误解是什么？或者他们成为 PM 后最感到惊讶的是什么？

---

### [00:55:23] [Anneka Gupta]

**English:**
When we interviewed students as we were designing the class about what they wanted to learn, what was most surprising to me was that students would say, "Well, can you teach me how to use Figma? Can you teach me the tools that product managers are going to have to use?" What was surprising me about that was I don't think it's the tools that you need to learn to be successful. I think what you need to learn to be successful is how to take very ambiguous situations and consistently drive more and more clarity over time. So, it was interesting to see this mismatch between what people said they wanted to learn and what I felt they actually needed to learn.
(00:56:03):
Now, having taught this class for a few years now, I think talking to students who have then left and become product managers, they've seen a lot of this in practice now and I think they understand that, but there is this mismatch of people who haven't been in product management saying they want to go and thinking that they need to learn some tools or process versus the mindset and the skills required to clarify ambiguity.

**中文翻译:**
当我们为了设计课程而采访学生想学什么时，最让我惊讶的是学生们会说：“你能教我怎么用 Figma 吗？你能教我 PM 必须使用的工具吗？”让我惊讶的是，我不认为学习工具是成功的关键。我认为成功的关键是学习如何处理极其模糊（ambiguous）的情况，并随着时间的推移不断提升清晰度。所以，看到人们想学的东西和我认为他们真正需要学的东西之间的错位，非常有意思。
(00:56:03):
现在这门课已经教了几年，我和那些毕业后成为 PM 的学生交流，他们在实践中已经体会到了这一点。但在入行前，人们往往认为需要学习的是工具或流程，而不是处理模糊性所需的心态和技能。

---

### [00:56:29] [Lenny Rachitsky]

**English:**
Along those lines, I actually saw you somewhere in a talk or maybe something you wrote talk about how creating this class and creating the curriculum helped you crystallize your own thinking on product and helped you crystallize the mental models of becoming a product manager. Is there anything that you recall from that time of like here's something that's really helped me understand about this function and the skill as you were putting together the class?

**中文翻译:**
说到这儿，我曾在你的演讲或文章中看到，你提到创建这门课程和编写大纲帮你理清了自己对产品的思考，并帮你固化了关于成为 PM 的心智模型。在编写课程的过程中，有没有什么让你记忆深刻的感悟，真正帮你理解了这个职能和技能？

---

### [00:56:51] [Anneka Gupta]

**English:**
Yeah, I know anytime you're teaching something, you have to figure out a way to synthesize it for another audience, and so many of us have learned product management just figuring it out on the job. I don't know if there's a particular framework that I would say came out of that, but what I found very interesting was seeing the questions that people asked in the class and then feeling like, "Oh, I understand how to answer this question. I can provide an example for it." That was super interesting to me because I didn't expect that coming out of the conversation. Yes, there's frameworks we developed to talk about ideation and product discovery and all of that, but I think those are fairly flexible frameworks.
(00:57:33):
What was most enlightening was being able to crystallize the answers to some of these questions, whether it was about how do you interact as a PM effectively with engineering or what happens if the data shows you that it doesn't matter which direction you pick, like there's merits to both ways. How do you actually go about making those decisions? It was very interesting being able to then have those conversations with students and bring in the real life examples. And I found in some situations that actually go back to my own team and share the same answer that I came up with in class, I was like, "Oh, this is actually a valuable thing to share with my team back at my company."

**中文翻译:**
是的，当你教别人东西时，你必须想办法为受众进行综合总结。我们很多人都是在工作中边做边悟。我不确定是否有什么特定的框架由此诞生，但我发现非常有意思的是，看到学生在课堂上提出的问题，然后我发现：“哦，我知道怎么回答这个问题，我能举出实例。”这对我来说非常有趣，因为我没预料到会有这种收获。虽然我们开发了一些关于构思（ideation）和产品探索（discovery）的框架，但那些都是比较灵活的。
(00:57:33):
最受启发的是能够固化一些问题的答案，比如 PM 如何与工程部门有效互动，或者当数据表明两个方向各有优劣、选哪个都行时，你该如何做决策？能与学生进行这些对话并引入现实案例非常有趣。我发现有时我会回到公司，把我在课堂上给出的答案分享给我的团队，我想：“哦，这其实对我的团队也很有价值。”

---

### [00:58:15] [Lenny Rachitsky]

**English:**
Reminds me of the recent chat I had with this guy Alex Komoroske, where he talked about how oftentimes talking with people helps them uncover new insights that he had in his head and then he writes them down as soon as he says something that's really clever in any way. He's like, "Okay, I'm going to remember that now." Coming back to how to become a PM, so you see all these people getting and taking this class want to become product managers. I know they're like Stanford students and people more likely hire Stanford people. But I guess in terms of how they end up becoming PMs, if you were to look at the pie chart of the people that end up getting a PM job, what's the biggest chunk? Is it they join at some other function and then move into product? Do they just join as a junior PM somewhere? How are people actually getting into the PM role in that class?

**中文翻译:**
这让我想起最近和 Alex Komoroske 的聊天，他说与人交谈经常能帮他挖掘出脑子里潜藏的新见解，一旦他说出了什么聪明的话，他就会立刻记下来。回到如何成为 PM 的话题，你看到这么多学生上这门课想成为 PM。我知道他们是斯坦福的学生，人们更倾向于雇佣斯坦福的人。但就他们最终如何成为 PM 而言，如果你看一个饼图，最大的那一块是什么？是先加入其他职能再转岗？还是直接作为初级 PM 入职？那个班里的学生实际上是怎么入行的？

---

### [00:59:00] [Anneka Gupta]

**English:**
Yeah, I think very few are directly going to an established company and becoming a PM directly, so I would say a big chunk of them. Some of them are, but many of those then had PM experience to begin with or had engineering experience and then went to a technical company into a PM role. The vast majority of them are joining product adjacent roles or they're going to small startups where they might be doing product management, might be the first product manager, or they might be doing product management plus plus, chief of staff, something like that where they get to put their hands in product management, but it's a super small company. So I think those have been the two most successful paths to get into product.

**中文翻译:**
是的，我认为很少有人能直接进入一家成熟公司并直接担任 PM。虽然有一部分人是这样，但他们通常要么本来就有 PM 经验，要么有工程背景然后进入技术型公司担任 PM。绝大多数人是先加入产品相关的职位，或者去小型初创公司，在那里他们可能是第一个 PM，或者做一些“PM+”的工作，比如幕僚长（Chief of Staff）之类，在极小的公司里接触产品管理。我认为这是目前最成功的两条入行路径。

---

### [00:59:40] [Lenny Rachitsky]

**English:**
Awesome. That's a really interesting lens into how people actually get into this role. Potentially final question, but we'll see where it goes. I have this recurring segment on this podcast called AI Corner where I try to get a sense of just how people are finding AI tools useful in their work, in their life. So, let me just ask you, is there anything you've found useful in some AI tool in how you work? Like something you found that helps you work more productively, more efficiently, either you or people on your team?

**中文翻译:**
太棒了。这对于人们如何入行是一个非常有趣的视角。可能是最后一个问题了，但看情况。我播客里有一个固定环节叫“AI 角落”，我尝试了解人们在工作和生活中如何使用 AI 工具。所以，我想问问，你有没有发现什么 AI 工具对你的工作很有帮助？比如能让你或你的团队工作更高效、更有产出的工具？

---

### [01:00:08] [Anneka Gupta]

**English:**
One way that we're using AI today is summarizing our user research calls. So, that has been really valuable because we're doing all these calls all the time, we're getting a ton of rich insights. Some of those rich insights are related to the specific project that we were doing this call for and some of them aren't. And now we have that summarized and tagged in a way where you can look up any sort of thing that you want around the calls that we've done and it'll find you the call, it'll find you the context, it'll find you the transcript and summarize exactly what we've learned from that call. So we're starting to use that more and more. It's very powerful capability. I definitely think that that kind of summarization of information for PMs is a big unlock for organizations and I think we're still in the very, very early days of AI making a meaningful difference to the way that PMs do their work.

**中文翻译:**
我们目前使用 AI 的一种方式是总结用户调研访谈。这非常有价值，因为我们一直在做这些访谈，积累了大量丰富的洞察。有些洞察与特定项目有关，有些则无关。现在我们可以对这些内容进行总结和打标签，你可以搜索任何你想了解的内容，它会帮你找到对应的访谈、背景、转录文本，并准确总结出我们从那次访谈中学到了什么。我们正越来越多地使用这个功能。这是一种非常强大的能力。我绝对认为，这种针对 PM 的信息总结能力对组织来说是一个巨大的释放，而且我认为 AI 在改变 PM 工作方式方面仍处于非常早期的阶段。

---

### [01:01:01] [Lenny Rachitsky]

**English:**
Is there a specific tool that you love to help you with that that you may want to give a shout-out to or is it something you guys built?

**中文翻译:**
有没有什么你特别喜欢的工具想推荐一下？还是说这是你们自己开发的？

---

### [01:01:07] [Anneka Gupta]

**English:**
Yeah, we use Dovetail and it's been fantastic. Connects into all of the Zoom calls and everything, it does a great job with summarization, with search, everything.

**中文翻译:**
是的，我们用 Dovetail，它非常棒。它可以连接所有的 Zoom 会议，在总结、搜索等方面都做得非常好。

---

### [01:01:18] [Lenny Rachitsky]

**English:**
Awesome. I love it when someone recommends a very awesome sponsor of the podcast. Dovetail is ongoing and excellent sponsor, so I'm really happy to hear that. Amazing. Anneka, is there anything else that you thought you wanted to share or that you want to leave listeners with that you think might be helpful before we get to a very exciting lightning round?

**中文翻译:**
太棒了。我喜欢听到有人推荐我们播客的优秀赞助商。Dovetail 一直是我们非常棒的赞助商，听到这个我很高兴。太好了。Anneka，在进入激动人心的闪电轮问答之前，还有什么你想分享或者留给听众的建议吗？

---

### [01:01:38] [Anneka Gupta]

**English:**
The mindset that you bring to your work is actually the most important thing over anything else that you can do. And if you are approaching every situation as much as possible with the positive mindset, you can do more than you could ever possibly hope to achieve.

**中文翻译:**
你对待工作的心态实际上比你做的任何其他事情都重要。如果你能尽可能以积极的心态面对每一种情况，你能成就的事业将超出你的想象。

---

### [01:01:56] [Lenny Rachitsky]

**English:**
I'm going to pull on this thread because this is such a powerful point and I think it's easy to just hear that. It's hard to learn to do it. Do you have any advice on just how to build that mindset? Like it connects to many of the things you said: how can this be fun? How can I be grateful to this person that's annoying me and the things that they might teach me? Is there just anything you've done that has helped you build this mindset?

**中文翻译:**
我想深入探讨一下这个话题，因为这是一个非常有力的观点，但听起来容易做起来难。关于如何建立这种心态，你有什么建议吗？这和你之前说的很多点都有关：如何让事情变得有趣？如何对那个让我烦心的人心存感激并向他学习？有没有什么具体的方法帮你建立了这种心态？

---

### [01:02:20] [Anneka Gupta]

**English:**
Journaling is very powerful. So actually growing up I journaled every single day of my life from when I was 13 to when I was 23. And while I cringe to go back to read any of those, I think what it helped me do and build a practice around that I still do today is when I have a lot of thoughts going through my head, especially negative thoughts, just putting them all down on a piece of paper, writing them on my phone and trying to explore why am I feeling this way? Why am I getting triggered? What is it about the situation that's making me feel so strongly?
(01:02:56):
And when I put it down on paper, then it takes this thing that's abstract and things that I'm ruminating on and actually makes it possible for me to break it down and understand, "Well, okay, this is something I may feel, but the why behind it is a little irrational, so let me let this go." I realize that this isn't rational way to think about this. Whereas other things I start to uncover, well, what is it about the situation and what is it that I need to do differently? What's within my control and what is it maybe that I need to go talk to someone about and say, "Hey, I need you to do this differently to be able to make myself feel better and make the situation better."

**中文翻译:**
写日记（Journaling）非常有效。实际上，我从 13 岁到 23 岁每天都写日记。虽然现在回头看那些内容会觉得很尴尬，但它帮我建立了一种延续至今的习惯：当我脑子里有很多想法，尤其是负面想法时，我会把它们全部写在纸上或手机里，尝试探索：我为什么会有这种感觉？为什么我会被激怒？这种情况的什么地方让我反应如此强烈？
(01:02:56):
当我把它们写下来时，那些抽象的、反复纠结的事情就变得具体了，我就可以去剖析它们：“好吧，我可能有这种感觉，但背后的原因其实有点不理智，所以随它去吧。”我意识到这不是一种理性的思考方式。而对于其他事情，我会开始发现：这种情况的本质是什么？我需要做出什么改变？什么是我的控制范围内的？或者我是否需要找某人谈谈，说：“嘿，我需要你换个方式做这件事，这样我的感觉会好一些，情况也会改善。”

---

### [01:03:34] [Lenny Rachitsky]

**English:**
It's interesting this is another thread that's been coming up a bunch on the podcast recently that when something is bothering you or something is hard, the more you actually listen to that part of yourself and dive into it and explore it and give it a space to share and talk, the less power it gets and the more space is created for the stuff you actually want to take space. It's not what you would expect because usually it's like, "No, shut up, everything's fine." But the more you actually hear that out, the easier things get. So, I love that you share that.

**中文翻译:**
很有意思，这是最近播客中经常出现的一个话题：当某件事困扰你或让你感到困难时，你越是倾听内心的那个声音，深入探索它，给它表达的空间，它的负面力量反而会减弱，从而为你想关注的事情腾出空间。这和直觉相反，因为通常我们会说：“不，闭嘴，一切都好。”但你越是倾听它，事情反而变得越容易。我很高兴你分享了这一点。

---

### [01:04:09] [Anneka Gupta]

**English:**
It's like doing cognitive behavioral therapy on yourself. That's how I think of it. I've never actually done cognitive behavioral therapy, but I've read a lot about it and sometimes when I go through this, I'm asking myself the same questions that I think are asked in those settings.

**中文翻译:**
这就像是在对自己进行认知行为疗法（CBT）。我就是这么想的。我其实从未真正接受过认知行为疗法，但我读过很多相关书籍。有时当我经历这个过程时，我问自己的问题，正是那种疗法中会问到的问题。

---

### [01:04:26] [Lenny Rachitsky]

**English:**
Love that. All right, Anneka, is there anything else that you wanted to share or leave listeners with?

**中文翻译:**
太棒了。好了，Anneka，还有什么想分享或留给听众的吗？

---

### [01:04:29] [Anneka Gupta]

**English:**
I think that's all I can think of.

**中文翻译:**
我想到的就这些了。

---

### [01:04:31] [Lenny Rachitsky]

**English:**
Well, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
那么，我们进入了非常激动人心的闪电轮问答。准备好了吗？

---

### [01:04:35] [Anneka Gupta]

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [01:04:36] [Lenny Rachitsky]

**English:**
All right. First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
好。第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:04:41] [Anneka Gupta]

**English:**
The Hard Thing About Hard Things by Ben Horowitz, such a great book, great again about mindset of how to approach hard things. Second is I'm a huge fantasy sci-fi fan, so I love Brandon Sanderson's books. I highly recommend those to people as well.

**中文翻译:**
本·霍罗威茨的《创业维艰》（The Hard Thing About Hard Things），非常棒的书，讲的是面对困难的心态。第二，我是个超级奇幻科幻迷，所以我非常喜欢布兰登·桑德森（Brandon Sanderson）的书。我也强烈推荐给大家。

---

### [01:04:57] [Lenny Rachitsky]

**English:**
All I know about him is I saw videos of him after COVID where he just said, "I wrote five new books during COVIID." I was like, "what is going on?"

**中文翻译:**
我对他的了解仅限于在疫情后看到他的视频，他说：“我在疫情期间写了五本新书。”我当时想：“这人怎么回事？”

---

### [01:05:03] [Anneka Gupta]

**English:**
He is someone that is at the top of his craft and I admire people so much that are truly the elite in what they do, and he's truly the elite in what he does. He writes a lot about writing, he podcasts a lot about writing. It's pretty impressive.

**中文翻译:**
他是一个处于行业巅峰的人。我非常钦佩那些在自己领域真正做到顶尖的人，而他确实是顶尖的。他写了很多关于写作的东西，也做了很多关于写作的播客。非常令人印象深刻。

---

### [01:05:17] [Lenny Rachitsky]

**English:**
And he writes fantasy books, is that right?

**中文翻译:**
他是写奇幻小说的，对吧？

---

### [01:05:18] [Anneka Gupta]

**English:**
He writes fantasy, yep.

**中文翻译:**
是的，写奇幻。

---

### [01:05:20] [Lenny Rachitsky]

**English:**
Okay, cool. It feels like a lot of books to read though. I'm just like, "Oh, my God, so many books." Okay, great. Next question, do you have a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
好，酷。不过感觉要读的书太多了，我想：“天哪，这么多书。”好，下一个问题：你最近有没有特别喜欢的电影或电视剧？

---

### [01:05:31] [Anneka Gupta]

**English:**
Again, on the fantasy sci-fi track, I really like Fallout, which is a dystopian show based on a post-apocalyptic, post-nuclear war world. It's very entertaining.

**中文翻译:**
还是奇幻科幻类的，我很喜欢《辐射》（Fallout），这是一部基于后启示录、核战后世界的反乌托邦剧集。非常有意思。

---

### [01:05:42] [Lenny Rachitsky]

**English:**
Yeah, it's just very quirky and fun.

**中文翻译:**
是的，非常古怪且有趣。

---

### [01:05:45] [Anneka Gupta]

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:05:46] [Lenny Rachitsky]

**English:**
And unexpected. Awesome. Do you have a favorite product that you've recently discovered that you really love?

**中文翻译:**
而且出人意料。太棒了。你最近有没有发现什么特别喜欢的电子产品或生活用品？

---

### [01:05:53] [Anneka Gupta]

**English:**
My eight-foot iPhone charger. So I have a cord that's very long that allows me to move around the house and do stuff while my phone is charging because my phone is always running out of batteries. So, highly recommend getting a super long charging cord.

**中文翻译:**
我的 8 英尺（约 2.4 米）长的 iPhone 充电线。这根线非常长，让我可以在手机充电时在屋里走动做事，因为我的手机总是没电。强烈推荐买一根超长的充电线。

---

### [01:06:10] [Lenny Rachitsky]

**English:**
I've got one of those and I know exactly what you mean. Do you have a favorite life motto that you often come back to find useful and work during life?

**中文翻译:**
我有一根，完全明白你的意思。你有没有什么常用的人生格言，觉得在工作或生活中很有用？

---

### [01:06:18] [Anneka Gupta]

**English:**
I think it comes back to dealing with lots of different types of people. I really try to remind myself that everyone has something to teach and everyone has something to learn. I think that helps not only think about how you interact with other people, but also combat imposter syndrome because you have something to bring to the table and teach as well as anyone else, no matter what your age is, no matter what your background, and leaning into that and realizing that people can learn from you and you can learn from others in every single situation.

**中文翻译:**
我认为这又回到了如何与不同类型的人打交道。我努力提醒自己：每个人都有值得教给别人的东西，每个人也都有需要学习的东西。我认为这不仅有助于思考如何与人互动，也有助于克服“冒充者综合征”（imposter syndrome），因为无论你的年龄或背景如何，你都有可以贡献和教给别人的东西。意识到在任何情况下，别人可以向你学习，你也可以向别人学习。

---

### [01:06:51] [Lenny Rachitsky]

**English:**
Final question. I heard that you're a big fan of Isaac Asimov. Do you have a favorite Asimov book, one that you'd think if someone were to explore his canon, they might want to start with?

**中文翻译:**
最后一个问题。听说你是艾萨克·阿西莫夫（Isaac Asimov）的超级粉丝。你最喜欢他的哪本书？如果有人想开始读他的作品，你建议从哪本开始？

---

### [01:07:01] [Anneka Gupta]

**English:**
I really like the Foundation series, so starting with that is really good. It's a very different style of writing. You kind of have to stick with it, but it's good, I promise.

**中文翻译:**
我非常喜欢《基地》（Foundation）系列，所以从那本开始很好。那是一种非常不同的写作风格，你可能需要坚持读下去，但我保证它很棒。

---

### [01:07:11] [Lenny Rachitsky]

**English:**
And I'll build on that and say, "Don't watch the show because the show is so different from the book series." I don't know if you've seen it and-

**中文翻译:**
我再补充一点：别看那部剧，因为剧集和原著差别太大了。我不知道你有没有看——

---

### [01:07:16] [Anneka Gupta]

**English:**
Yes, I have.

**中文翻译:**
是的，我看了。

---

### [01:07:17] [Lenny Rachitsky]

**English:**
... not nearly as good.

**中文翻译:**
……完全没法比。

---

### [01:07:17] [Anneka Gupta]

**English:**
Okay.

**中文翻译:**
好吧。

---

### [01:07:18] [Lenny Rachitsky]

**English:**
I was just like, what is going on? This is not the story.

**中文翻译:**
我当时就想：这是在搞什么？这根本不是原著的故事。

---

### [01:07:20] [Anneka Gupta]

**English:**
Yeah, very different.

**中文翻译:**
是的，非常不同。

---

### [01:07:21] [Lenny Rachitsky]

**English:**
What are they doing? Amazing. Anneka, this has been amazing. We covered so much ground. I feel like this is going to help a lot of people. Two final questions, where can folks find you online if they want to follow up on things, maybe ask you questions or just check out the stuff you're up to and how can listeners be useful to you?

**中文翻译:**
他们在干嘛呢？太棒了。Anneka，这次对话太精彩了。我们聊了这么多领域，我觉得这会帮到很多人。最后两个问题：如果大家想关注你的动态、问你问题或了解你的近况，可以在哪里找到你？听众们能为你做点什么？

---

### [01:07:38] [Anneka Gupta]

**English:**
You can find me on LinkedIn, follow me, DM me. I would love to connect. The way you can help me is we're actually redesigning our Stanford class right now for PMs, and I would love to hear from you if you don't have any PM experience, what is it that you wish a class could teach you? And that would be super helpful for me as we're redesigning this class. Thanks.

**中文翻译:**
你可以在 LinkedIn 上找到我，关注我或给我发私信。我很乐意建立联系。你可以帮我的一件事是：我们现在正在重新设计斯坦福的产品管理课程。如果你没有任何 PM 经验，我很想听听你希望一门课程能教给你什么？这对我重新设计课程非常有帮助。谢谢。

---

### [01:07:59] [Lenny Rachitsky]

**English:**
Amazing. And the way they could share that is DM you on LinkedIn or Twitter?

**中文翻译:**
太好了。他们可以通过 LinkedIn 或 Twitter 私信你吗？

---

### [01:08:03] [Anneka Gupta]

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:08:06] [Lenny Rachitsky]

**English:**
Easy. Amazing. Anneka, thank you so much for being here.

**中文翻译:**
没问题。太棒了。Anneka，非常感谢你能来。

---

### [01:08:07] [Anneka Gupta]

**English:**
Thanks for having me.

**中文翻译:**
谢谢你的邀请。

---

### [01:08:09] [Lenny Rachitsky]

**English:**
Absolutely. My pleasure. Bye everyone.
(01:08:13):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
当然，这是我的荣幸。大家再见。
(01:08:13):
非常感谢大家的收听。如果你觉得这集节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期再见。