# Annie Duke - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Annie Duke.

---

### [00:00:00] Annie Duke

**English:**
It's so incredibly necessary in improving decision quality to take what's implicit and make it explicit. It's not that intuition is crap, your intuition is sometimes right. If you don't make it explicit, then you don't get to find out when it's wrong.

**中文翻译:**
在提高决策质量的过程中，将内隐（implicit）的东西转化为外显（explicit）是极其必要的。这并不是说直觉一文不值，你的直觉有时是正确的。但如果你不把它明确地表达出来，你就无法发现它什么时候是错误的。

---

### [00:00:12] Lenny Rachitsky

**English:**
When you look at companies that have read your book, what do you find are the brainwashing tactics that really stick?

**中文翻译:**
当你观察那些读过你书的公司时，你发现哪些“洗脑式”的策略（指深入人心的技巧）真正发挥了持久的作用？

---

### [00:00:16] Annie Duke

**English:**
People generally think the purpose of a meeting is for three things, discover, discuss, decide. The only thing that's ever supposed to happen in a meeting is the discussion part.

**中文翻译:**
人们通常认为会议的目的有三点：发现、讨论、决定。但实际上，会议中唯一应该发生的事情只有“讨论”这一部分。

---

### [00:00:25] Lenny Rachitsky

**English:**
Something that comes up in product a lot is this idea of pre-mortems.

**中文翻译:**
在产品领域经常被提及的一个概念是“事前剖析”（pre-mortems，又称事前验尸）。

---

### [00:00:28] Annie Duke

**English:**
So a pre-mortem, it's great only if you set up kill criteria. Commit to actions that you're going to take if you see those signals.

**中文翻译:**
事前剖析非常棒，但前提是你必须设定“终止准则”（kill criteria）。你必须承诺，一旦看到那些预警信号，就会采取相应的行动。

---

### [00:00:35] Lenny Rachitsky

**English:**
You have a very interesting framework for how to think about decision quality when the outcome is very long-term.

**中文翻译:**
对于当结果需要很长时间才能显现时，如何思考决策质量，你有一套非常有趣的框架。

---

### [00:00:40] Annie Duke

**English:**
There is no such thing as a long feedback loop. And the way you choose to shorten the feedback loop is to say, what are the things that are correlated with the outcome that I eventually desire?

**中文翻译:**
世界上不存在所谓的“长反馈循环”。缩短反馈循环的方法是去思考：有哪些因素是与我最终想要的结果呈正相关的？

---

### [00:00:53] Lenny Rachitsky

**English:**
Today, my guest is Annie Duke. Annie is the author of the bestselling book Thinking in Bets, and also her more recent book Quit: The Power of Knowing When to Walk Away. She's also a special partner at First Round Capital, which we spent some time on and is incredibly fascinating. Prior to this part of her career, she was a professional poker player. She's won over $4 million in tournaments, including winning a World Series of Poker Bracelet, and she's the only woman who's won the World Series of Poker Tournament of Champions and the National Poker Heads-Up Championship. Currently, she spends her time helping companies make better decisions. In our conversation, we cover the many lessons that she's learned from her friend Daniel Kahneman, who recently passed away. What simple change she's found has the most impact in a company's ability to make better decisions, how to make better quick decisions when the feedback loop is very long, and also why she doesn't actually believe in long feedback loops, how she changed the way that the partners at First Round Capital make decisions, which is incredibly interesting.

**中文翻译:**
今天的嘉宾是安妮·杜克（Annie Duke）。安妮是畅销书《对赌》（Thinking in Bets）以及近作《放弃的力量》（Quit: The Power of Knowing When to Walk Away）的作者。她还是 First Round Capital 的特别合伙人，我们在访谈中聊到了这一点，内容非常精彩。在开启这段职业生涯之前，她是一名职业扑克选手。她在各项赛事中赢得了超过 400 万美元，包括获得一枚世界扑克大赛（WSOP）金手链，她也是唯一一位赢得 WSOP 冠军锦标赛和全美扑克单挑锦标赛的女性。目前，她致力于帮助公司做出更好的决策。在我们的对话中，我们涵盖了她从最近去世的朋友丹尼尔·卡尼曼（Daniel Kahneman）身上学到的诸多教训；她发现的能对公司决策能力产生最大影响的简单改变；当反馈循环很长时如何做出更好的快速决策（以及为什么她实际上不相信长反馈循环）；还有她如何改变了 First Round Capital 合伙人们的决策方式，这部分内容极其有趣。

---

### [00:01:51] Lenny Rachitsky (Continued)

**English:**
Plus, why when you're thinking about quitting, that probably means you've already waited too long and you should have quit a while ago. I learned a ton from this conversation and this is definitely going to change the way I think about a lot of things. With that, I bring you Annie Duke after a short word from our sponsors. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast.

**中文翻译:**
此外，我们还聊到了为什么当你考虑放弃时，通常意味着你已经等待太久了，早该在一段时间前就放弃。我从这次对话中学到了很多，这绝对会改变我对许多事情的看法。在听完赞助商的简短介绍后，我们将为您带来安妮·杜克的访谈。如果你喜欢这个播客，别忘了在您常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最佳方式，也对本节目有巨大的帮助。本集节目由 Vanta 赞助。当涉及到确保公司拥有顶级的安全实践时，事情很快就会变得复杂。

---

### [00:02:27] Lenny Rachitsky (Sponsor: Vanta)

**English:**
Now you can assess risk, secure the trust of your customers, and automate compliance for SOC 2, ISO 27001, HIPAA and more with a single platform, Vanta. Vanta's market-leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risk. Plus, you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to vanta.com/lenny. That's vanta.com/lenny.

**中文翻译:**
现在，你可以通过 Vanta 这一个平台来评估风险、赢得客户信任，并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规情况，同时报告和跟踪风险。此外，你还可以通过 Vanta AI 完成安全问卷，从而节省数小时的时间。加入全球数千家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的公司吧。访问 vanta.com/lenny 即可享受 1,000 美元的折扣。地址是 vanta.com/lenny。

---

### [00:03:11] Lenny Rachitsky (Sponsor: UserTesting)

**English:**
This episode is brought to you by UserTesting. Get fast feedback from real people throughout the development process so that you can build the right thing the first time. Companies are being asked to do more with less. They need to move more quickly while building experiences that meet changing customer expectations, all while minimizing risk and costly rework. With UserTesting, you have a trusted partner who provides user research teams with the skills, tools, and data to be able to articulate the value of user research to the business so that you can make an impact and build the best experiences with confidence. Get started today at usertesting.com/lenny. Annie, thank you so much for being here and welcome to the podcast.

**中文翻译:**
本集节目由 UserTesting 赞助。在整个开发过程中获取真实用户的快速反馈，确保你第一次就能做对产品。现在的公司被要求“降本增效”。他们需要在快速行动的同时，构建满足不断变化的客户期望的体验，并尽量减少风险和昂贵的返工。有了 UserTesting，你就拥有了一个值得信赖的合作伙伴，它为用户研究团队提供技能、工具和数据，使其能够向业务部门阐明用户研究的价值，从而让你能够产生影响并充满信心。今天就访问 usertesting.com/lenny 开始吧。安妮，非常感谢你能来到这里，欢迎来到本播客。

---

### [00:03:58] Annie Duke

**English:**
Thank you so much for having me.

**中文翻译:**
非常感谢邀请我。

---

### [00:03:59] Lenny Rachitsky

**English:**
It's my pleasure. I was telling a bunch of people that you were coming on this podcast and every single one of them was so excited that we were doing this, so I'm quite excited that this is happening. I want to start with a question about Daniel Kahneman. I know you two were very close. You did a podcast together. I know you grew to be good friends over the past few years. Sadly, he passed away about a week ago at this point.

**中文翻译:**
这是我的荣幸。我告诉很多人你要来参加这个播客，每一个人都非常兴奋，所以我对这次访谈也充满期待。我想从一个关于丹尼尔·卡尼曼（Daniel Kahneman）的问题开始。我知道你们两个关系非常亲密，还一起做过播客。我知道在过去的几年里你们成了很好的朋友。遗憾的是，他在大约一周前去世了。

---

### [00:04:21] Annie Duke

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:04:21] Lenny Rachitsky

**English:**
I'm curious, what are some lasting lessons that you took away from your time with him? Maybe one or two things that stick with you and you think will stick with you?

**中文翻译:**
我很好奇，在与他相处的时光中，你学到了哪些让你受用终身的教训？有没有一两件让你记忆深刻、且你认为会一直影响你的事情？

---

### [00:04:31] Annie Duke

**English:**
It's hard for me to describe properly how humble this man was, and it seems so impossible because his influence was so huge and his intellect was so huge and his insight was so change-making in the areas that he worked. But he was so humble, he really wanted to hear what you thought. He said, "I don't know a lot", he would change his mind. It's funny, I got asked in a class that I was teaching about thinking fast and slow and someone was talking about how there's a lot of studies in there that didn't end up replicating.

**中文翻译:**
我很难准确地描述这个人的谦逊程度，这听起来几乎是不可能的，因为他的影响力如此巨大，他的才智如此卓越，他在所研究领域的见解具有如此深远的变革意义。但他非常谦虚，他真的很想听听你的想法。他会说：“我了解得并不多”，他也会改变主意。很有趣，在我教的一堂关于《思考，快与慢》的课上，有人提到书中有很多研究最终未能被重复实验验证（replication crisis）。

---

### [00:05:19] Annie Duke (Continued)

**English:**
And what I've seen from a lot of other people in the field who really where their work is defined by some line of work that didn't replicate, where they're really arguing against the fact that it doesn't replicate. Just trying to justify or say, "But no", or this and that. This real lack of open-mindedness to the idea that you know what? Maybe it turns out not to be true and that should be okay. But the thing about Danny was when you talked about it, he was the first one to tell you, "I wish priming wasn't in the book. It doesn't replicate." He was just so open-minded to the idea that he knows what he knows now, but he knows that he doesn't know everything.

**中文翻译:**
我见过该领域的许多其他人，当他们的工作被证明无法重复时，他们会极力辩解，试图证明它是对的，或者找各种借口。他们缺乏那种“也许事实证明它是错的，这也没关系”的开放心态。但丹尼（Danny）不同，当你谈到这件事时，他是第一个告诉你：“我希望书中没有写‘启动效应’（priming）那部分，它无法被重复验证。”他非常坦然地接受：他知道他现在所知道的，但他也知道自己并非无所不知。

---

### [00:06:06] Annie Duke (Continued)

**English:**
Another thing that people don't know about him outside of academics I think are that he was one of the pioneers in something called an adversarial collaboration. So one of his favorite things, and he in some ways invented it, was find someone who really disagrees with you and then write a paper with them and try to figure out with them what's the study that would resolve the issue. So an example of that was Danny did work on happiness as it relates to wealth. Kahneman and a collaborator, Angus Deaton, they published a result that got a lot of press about the relationship between money and happiness, and the idea was money doesn't buy happiness beyond $75,000. So that got published in 2010. I'm sure if you ran that exact same study, it would be more than $75,000 now because it would adjust for inflation. But it was like the idea being once your basic needs are met and you're not that worried about paying rent and so on and so forth, it's not going to have that big of an effect.

**中文翻译:**
我想学术界以外的人可能不知道的另一件事是，他是“对抗性合作”（adversarial collaboration）的先驱之一。这是他最喜欢的事情之一，在某种程度上也是他发明的：找一个真正反对你观点的人，然后和他们一起写论文，共同设计一个能解决分歧的研究。例如，丹尼曾研究过财富与幸福的关系。卡尼曼和合作者安格斯·迪顿（Angus Deaton）发表了一项引起广泛关注的研究，观点是：当收入超过 7.5 万美元后，金钱就不再能增加幸福感了。那是 2010 年发表的。如果现在做同样的研究，考虑到通货膨胀，这个数字肯定会高于 7.5 万美元。但核心观点是，一旦你的基本需求得到满足，不再为付房租等发愁，钱的影响就不再那么大了。

---

### [00:07:09] Annie Duke (Continued)

**English:**
But then a decade later, Matthew Killingsworth said, "That's not true that actually money and happiness are correlated through all the income levels. The more money you have, the more happy you tend to be." Okay, so this is a classic example where people will tear each other down sometimes and that guy's wrong and whatever. And instead, it was Kahneman's like, "All right, let's do it together." And they joined forces along with Barb Mellers to basically try to resolve that issue. He was just always seeking out, it was just like everything was like, why am I wrong? And he was eager and he was excited and he wanted to...

**中文翻译:**
但十年后，马修·基林斯沃思（Matthew Killingsworth）提出：“事实并非如此，金钱和幸福感在所有收入水平上都是相关的。钱越多，人往往越幸福。”这是一个典型的例子，通常人们会互相攻击，说对方是错的。但卡尼曼却说：“好吧，让我们一起来研究。”于是他与基林斯沃思以及巴布·梅勒斯（Barb Mellers）联手，试图解决这个分歧。他总是在寻找——就像每件事他都会问：为什么我是错的？他非常渴望、兴奋，并且想要……

---

### [00:07:56] Annie Duke (Continued)

**English:**
I remember having a lunch with him where I realized after the lunch that the whole lunch was him asking me questions about my work. Why is he asking me questions about my work? Right? He's Danny Kahneman. But he was just so curious about other people and he just made time for everybody. He just loved the people around him so much. And I think that in the end, it's hard to believe, but I just think that that dwarfs his body of work, which is spectacular. But he as a human being was just so spectacular. And I do think you hear all the time about people who are so incredibly brilliant. It's the brilliant but asshole thing, and it was just so the opposite with him. He was so kind.

**中文翻译:**
我记得有一次和他共进午餐，午餐结束后我才意识到，整个过程都是他在问我关于我工作的问题。他为什么要问我工作的问题？对吧？他可是丹尼·卡尼曼啊。但他对别人充满好奇，他为每个人都腾出时间。他非常爱身边的人。我认为，尽管这听起来难以置信，但他的人格魅力甚至让他那辉煌的学术成就都显得逊色。作为一个普通人，他太了不起了。你经常听到有些天才虽然聪明但性格很糟糕，但他完全相反。他非常善良。

---

### [00:08:51] Lenny Rachitsky

**English:**
That's amazing. And it feels like there's probably a strong correlation between people that are curious, always looking for how they're wrong, and finding time to spend it with people to debate and discuss and ask. Feels like there's going to be a strong correlation with that and finding really interesting insights uncovering new things.

**中文翻译:**
太棒了。感觉那些充满好奇心、总是寻找自己错误、并愿意花时间与人辩论、讨论和请教的人，与能够发现有趣见解、揭示新事物之间，可能存在很强的相关性。

---

### [00:09:10] Annie Duke

**English:**
Yeah, yeah, yeah. [inaudible 00:09:12].

**中文翻译:**
没错，确实如此。

---

### [00:09:11] Lenny Rachitsky

**English:**
Well, thank you. Thank you for sharing all that. I wish I had known him. Let's talk about decision-making. So there's two areas I want to spend time on. As one would not be surprised, decision-making and quitting. And I know that you've been on a lot of podcasts. I imagine many listeners have read your book or have heard a lot about the stuff that you teach. I'm going to try to come at this from a bunch of different directions and do it a little differently. First of all, I know you're a parent. As last I heard, you have four kids. I just had a kid, he's almost 10 months now.

**中文翻译:**
谢谢你分享这些。真希望我以前能认识他。让我们聊聊决策。我想花时间讨论两个领域：决策和放弃，这并不令人意外。我知道你参加过很多播客，我也想象很多听众读过你的书或听过你的教导。我打算尝试从几个不同的角度切入，做得稍微不一样些。首先，我知道你是一位家长，我记得你有四个孩子。我刚当上爸爸，孩子现在快 10 个月大了。

---

### [00:09:43] Annie Duke

**English:**
Oh, congratulations.

**中文翻译:**
噢，恭喜你。

---

### [00:09:44] Lenny Rachitsky

**English:**
Thank you. I'm curious, what are some frameworks you find most helpful in parenting and in raising your kids that have stuck with you there?

**中文翻译:**
谢谢。我很好奇，在育儿和抚养孩子的过程中，你发现哪些框架对你最有帮助，并且一直沿用至今？

---

### [00:09:53] Annie Duke

**English:**
Well, let me just first off say I get a lot of people who are pregnant who come and ask me for my advice about parenting. And I'll tell you the two pieces of advice I give people. The first is this, there's all sorts of parenting books, there's all sorts of styles. A book needs to sell, so they need to sell you something new or different or whatever, okay. But the only thing that matters really is that your kids know you love them, really know deep in their bones, know you love them.

**中文翻译:**
首先，有很多准妈妈来找我咨询育儿建议。我会告诉他们两条建议。第一条是：市面上有各种各样的育儿书和育儿风格。书要卖出去，就得推销一些新奇或不同的东西，这没问题。但真正唯一重要的事情是，你的孩子知道你爱他们，是那种刻在骨子里的、深切的知道。

---

### [00:10:32] Annie Duke (Continued)

**English:**
And we can argue breastfeeding versus not breastfeeding or co-sleeping versus not co-sleeping or attachment parenting or sleep training, we can talk about all that stuff, right? Do you homeschool? Do you send them to private school? Do you send them [inaudible 00:10:49]? We can have lots of [inaudible 00:10:51], but it all dwarfs in comparison to your children know that you would lay down in the street in the front of a bus if it meant that they would be alive and happy. That's the number one thing I say. Number two is at some point, you will drop your baby on its head. So I bet this has happened to you already.

**中文翻译:**
我们可以争论母乳喂养还是非母乳喂养，同床睡还是不同床睡，亲密育儿还是睡眠训练，这些都可以讨论，对吧？是居家教育还是送去私立学校？我们可以有很多争论，但与“你的孩子知道你愿意为了他们的生存和幸福躺在公交车前的马路上”相比，这些都微不足道。这是我说的第一点。第二点是：在某个时刻，你一定会不小心把宝宝摔到头。我敢打赌这已经发生在你身上了。

---

### [00:11:18] Lenny Rachitsky

**English:**
Well, yeah. Sort of. Okay.

**中文翻译:**
额，是的。算是吧。好吧。

---

### [00:11:18] Annie Duke

**English:**
Sort of, right.

**中文翻译:**
算是，对吧。

---

### [00:11:18] Lenny Rachitsky

**English:**
Keep coming.

**中文翻译:**
请继续。

---

### [00:11:20] Annie Duke

**English:**
So here's the thing about babies, is babies can't move. And so you get very used to as a mom or a dad or you're sitting on the couch and you're folding laundry and your baby is right here next to you and your baby can't move. And then one day without warning, your baby can roll over. And you think it's fine because you put a pillow there or something, but you turn your back for a second because you're like whatever and then your baby falls on its head. It happened with every single one of my children. And they don't fall that far and whatever, but they're totally fine and you're not a bad parent. And it's just this, there are things you don't know and stuff's going to happen and it's not going to be perfect. And every little thing isn't going to have some lasting impression on your child because at some point, you will drop your baby on its head and you will not mean to, you didn't intend to.

**中文翻译:**
关于宝宝的一点是：他们一开始是不会动的。所以作为父母，你习惯了坐在沙发上叠衣服，宝宝就在你身边，一动不动。然后有一天，毫无预兆地，宝宝学会翻身了。你觉得没问题，因为你放了个枕头在那儿，但你转过身的一秒钟，宝宝就摔到了头。我的每一个孩子都发生过这种事。他们摔得并不重，而且完全没事，你也不是个坏家长。这只是说明：总有些事情是你不知道的，意外总会发生，事情不会完美。并不是每一件小事都会对孩子产生持久的影响，因为在某个时刻，你一定会不小心摔到宝宝的头，你不是故意的。

---

### [00:12:21] Annie Duke (Continued)

**English:**
But in my case, it was always like, oh my gosh, my baby can roll over. I did not think that was going to happen today. And gosh, by the time I got to the fourth one, it's like I'm chasing after one baby to try to get the diaper on and this and that, so then the other baby hits its head. So I think there's just a lesson in that which is like it's a small thing, don't sweat it and don't get mad at yourself because you made a mistake. It's like the mistake would be, oh, I realize my baby could roll over now. So now you should make sure that you're taking extra precautions about your baby rolling over off the couch. But it's really just a funny way for me to say your baby's going to hit its head or walk into a coffee table or get cut or whatever. It's like they're very resilient and you didn't do anything wrong as a parent, so don't beat yourself up about that. And then I do actually have one other thing I say.

**中文翻译:**
但在我看来，当时的感觉总是：“天哪，我的宝宝会翻身了，我没料到今天会发生这种事。”到了第四个孩子的时候，情况就变成了我正追着一个孩子换尿布，结果另一个孩子撞到了头。所以这里的教训是：这是一件小事，别太在意，别因为犯了错就责怪自己。真正的“错误”应该是：哦，我意识到宝宝现在会翻身了，所以我现在应该采取额外的预防措施防止他从沙发上翻下来。这只是我的一种幽默表达，宝宝总会撞到头、撞到咖啡桌或被割伤。他们非常有韧性，你作为父母没做错什么，所以别自责。实际上我还有另外一件事要说。

---

### [00:13:20] Lenny Rachitsky

**English:**
Yeah, go for it.

**中文翻译:**
好，请讲。

---

### [00:13:21] Annie Duke

**English:**
Be having four, you have very little, you have no influence whatsoever basically on what your child's personality is. What you can do as a parent is make sure they say please and thank you. So what I find with parents of one is particularly if that one is very well-behaved, they think they're a great parent and they may be. That would be resulting. They may be, but once you have four, what you realize is like, oh, my parenting really didn't have anything to do with it. But my children do say please and thank you.

**中文翻译:**
有了四个孩子后，你会发现你对孩子的性格基本上没有任何影响力。作为父母，你能做的就是确保他们会说“请”和“谢谢”。我发现只有一个孩子的父母，特别是如果那个孩子很乖，他们会觉得自己是伟大的父母——也许他们确实是，但这其实是“以结果论成败”（resulting）。也许他们很棒，但一旦你有了四个孩子，你就会意识到：“噢，我的育儿方式其实没起多大作用。”但我的孩子们确实会说“请”和“谢谢”。

---

### [00:14:01] Lenny Rachitsky

**English:**
This is really valuable, good advice. I need to hear this. My wife is going to need to hear this, too. She's always worried about the soft spot on our kid's head and getting hit into some things.

**中文翻译:**
这真的是非常有价值的建议。我需要听听这些，我妻子也需要。她总是担心孩子头上的囟门（soft spot）会被撞到。

---

### [00:14:09] Annie Duke

**English:**
No, it'll be fine.

**中文翻译:**
没事的，会好起来的。

---

### [00:14:10] Lenny Rachitsky

**English:**
Okay, great.

**中文翻译:**
好的，太好了。

---

### [00:14:11] Annie Duke

**English:**
It's actually it's part of why it's there. Really, your baby will be fine. I mean, that's the thing. We used to cart babies around in the wilderness, we were living in case. We're fine, we're built for it. We're built for a much rougher world than the world that babies actually grow up in now. I will say my oldest child when she was in high school, just for whatever reason, she had no interest whatsoever in alcohol or drugs or anything like that. And I remember just feeling so smug about how well I had raised this child and how great she was, and oh, these other parents who clearly weren't doing a good job. I mean, I didn't really but because it's hard not to. And then my next child went through high school and I was like, [inaudible 00:15:02]. That's just a temperament thing.

**中文翻译:**
那其实也是它存在的部分原因。真的，宝宝会没事的。以前我们在荒野里带着孩子，住在山洞里。我们没事，人类天生就能适应。我们天生是为了适应比现在宝宝成长环境粗糙得多的世界。我想说，我的大女儿上高中时，出于某种原因，她对酒精或毒品完全没兴趣。我记得当时我非常自鸣得意，觉得我把孩子教得太好了，她太棒了，而其他父母显然做得不够好。我是说，我虽然没明说，但很难不这么想。然后我的第二个孩子上了高中，我就意识到……那纯粹是性格问题。

---

### [00:15:08] Annie Duke

**English:**
It is a good example of resulting, but all my kids have turned out fine and they're all very different, but yeah. But as far as decision-making is concerned, which is a totally different thing, I'll actually quote Danny Kahneman on this one. Nothing is as important as it seems when you're thinking about it, that's a really important one. One of the things that I used to try to do with my kids all the time was mental time travel, which is actually a very good decision tool. So they would be really upset about something and it could be something that happened at school or it could be like they were grounded for something or whatever.

**中文翻译:**
这是一个典型的“以结果论成败”的例子。不过我的孩子们现在都很好，虽然性格迥异。但就决策而言（这是完全不同的另一回事），我想引用丹尼·卡尼曼的一句话：当你思考某件事时，没有什么事情像它看起来那么重要。这非常关键。我以前经常和孩子们做的一件事是“心理时间旅行”（mental time travel），这实际上是一个非常好的决策工具。当他们对某件事感到非常沮丧时——可能是学校发生的事，或者是因为某事被禁足等等。

---

### [00:15:46] Annie Duke (Continued)

**English:**
And the thing is when you're in the moment, it just feels like so big. And the thing that I used to say and they say all the time now is this is going to be so great for you when you're 40 at Thanksgiving. You're going to be able to tell these stories to your children and it's going to be the best, like you should be thanking me so that you can talk about your crazy mother at the Thanksgiving table. And it allowed them to get some time and space from it to realize this is going to be funny at some point.

**中文翻译:**
问题在于，当你身处其中时，感觉事情非常严重。我以前常说，他们现在也常说的一句话是：“当你 40 岁过感恩节时，这件事会成为一个很棒的话题。你可以把这些故事讲给你的孩子听，那会是最棒的时刻。你应该感谢我，让你能在感恩节餐桌上吐槽你那个疯狂的老妈。”这让他们能够从当下的情绪中抽离出来，意识到在未来的某个时刻，这会变成一件趣事。

---

### [00:16:19] Annie Duke (Continued)

**English:**
At some point, it's going to be a hilarious story that you tell people. No matter how horrible it seems now, it's going to be a hilarious story at some point when you're older. And it sounds like a fun thing I was doing with them, but it's actually a really good decision-making tool for us in general, right? Look, there are absolutely things that 20 years from now are going to matter, for sure. But most things, no. If you think about most things that ever happen to you, like you're 21 and your girlfriend breaks up with you or whatever and you just think it's the end of the world and you're never going to recover and all these things, but if you could get yourself like, well, how do I really think I'm going to think about this in 10 years? Am I still going to be heartbroken in 10 years?

**中文翻译:**
在未来的某个时刻，这会成为你讲给别人听的爆笑故事。无论现在看起来多么糟糕，当你长大后，它都会变成一个幽默的故事。这听起来像是我和他们玩的一个游戏，但实际上它对我们所有人来说都是一个非常好的决策工具。听着，确实有些事情在 20 年后依然重要，但绝大多数事情并非如此。想想你经历过的大多数事，比如你 21 岁时女朋友和你分手，你觉得世界末日到了，永远无法恢复，但如果你能问问自己：“10 年后我会怎么看这件事？10 年后我还会心碎吗？”

---

### [00:17:03] Annie Duke (Continued)

**English:**
Probably not. And I think that we need to get that perspective of time so that we can get out of the moment because in the moment it just feels so important and the feelings are so big. And it's like the focusing effect on this second and the feelings you're feeling right now are so huge that we forget the scope of time. And I think that that's absolutely one of the best things you can do with your kids, and you can do it in small ways too, right? You can choose to play this video game or you can choose to study for your task. A week from now when you get that test back, how do you think you're going to feel about those two choices? Right?

**中文翻译:**
大概率不会。我认为我们需要这种时间视角，以便从当下抽离出来，因为在当下，事情显得如此重要，情绪如此强烈。这就像是“聚焦效应”（focusing effect），这一秒的感觉被无限放大，以至于我们忘记了时间的跨度。我认为这是你能教给孩子的最棒的事情之一，而且可以从小事做起。比如：“你可以选择玩这个电子游戏，也可以选择为考试复习。一周后当你拿到成绩单时，你觉得你会对这两个选择有什么感觉？”对吧？

---

### [00:17:43] Annie Duke (Continued)

**English:**
So that was a tool that I used a ton and it's just generally an amazing decision-making tool, just generally for people. It's one that I happen to use with my kids all the time. And then I would say that the other one was using the word nevertheless, which is this a great leadership skill, the word nevertheless. So let's say my child got caught doing something wrong. I don't know, I found a bag of red solo cups in my backyard that they forgot to throw out after a weekend that I was away. That's hypothetical. So I'm grounding them and it's a lot of argument back, right? So they think this is a debate and they're giving me all of their input and their opinions on why it's unfair and all the other kids do it and the other parents don't get mad and whatever, whatever the argument is. You have to have the balance between them feeling heard, which I think is incredibly important that your children feel heard, and following through on what you know or believe is right.

**中文翻译:**
所以这是一个我经常使用的工具，它对所有人来说都是一个了不起的决策工具。我恰好经常对我的孩子使用它。另一个工具是使用“尽管如此”（nevertheless）这个词，这是一个伟大的领导力技巧。假设我的孩子做错事被抓住了。比如，我出差回来在后院发现了一袋他们忘了扔掉的红色塑料杯（暗示开派对）。这只是假设。所以我禁他们的足，他们会反驳，对吧？他们觉得这是一场辩论，给我各种理由说明这不公平，别的孩子也这么做，别的家长不生气等等。你必须在“让他们感到被倾听”和“坚持你认为正确的决定”之间取得平衡。

---

### [00:18:56] Annie Duke (Continued)

**English:**
So it's I hear you. Nevertheless, you're grounded for two weeks. I hear what you're saying and I understand. Nevertheless, this is what's going to happen. And obviously, the words that you can use for that might be different. You have so much more authority obviously over your children than you do in other places. But in the workplace, this is very good because employees gripe all the time at decisions that you make in leadership because they think they're right and they want their way. And to have the ability to say, I heard you and your input, trust me, was incorporated into the decision, nevertheless, this is the path we're going to take. Right or wrong, that's what we're going to do. So I think there's a lot of things that basically you can say. These are good things to do with kids, but they're actually just generally really good decision strategies.

**中文翻译:**
所以我会说：“我听到你的话了。尽管如此，你还是要被禁足两周。”“我明白你的意思，我也理解。尽管如此，这就是结果。”显然，你可以使用不同的措辞。在孩子面前你显然比在其他地方更有权威。但在职场中，这同样非常有效，因为员工经常会对领导层的决策发牢骚，因为他们觉得自己是对的。如果你有能力说：“我听到了你的意见，请相信，你的建议已被纳入决策考虑中。尽管如此，我们还是会走这条路。无论对错，这就是我们要做的。”所以，这些不仅是育儿的好方法，也是非常棒的通用决策策略。

---

### [00:19:47] Lenny Rachitsky

**English:**
I'm taking notes on all these things. These are going to be extremely useful.

**中文翻译:**
我正在把这些都记下来。这些会非常有用。

---

### [00:19:51] Annie Duke

**English:**
Nevertheless is a really good one with children.

**中文翻译:**
“尽管如此”对付孩子真的很管用。

---

### [00:19:53] Lenny Rachitsky

**English:**
It connects to something Dr. Becky teaches, if you know her, of telling someone, "I believe you." When your kid says something and they're upset about something, start with I believe you.

**中文翻译:**
这让我想起了贝基博士（Dr. Becky）教的一点，如果你知道她的话，就是告诉对方“我相信你”。当你的孩子说了一些话或者对某事感到沮丧时，先说“我相信你”。

---

### [00:20:03] Annie Duke

**English:**
Nevertheless.

**中文翻译:**
然后接“尽管如此”。

---

### [00:20:03] Lenny Rachitsky

**English:**
And here's nevertheless, exactly. Fair enough. I think we're going to start having to pivot this podcast to a parenting podcast because there's so much stuff here, but I'm going to try to resist. So we've been talking about decision-making and frameworks and things like that. Something I wanted to ask you is how much better can someone get at making better decisions? So for example, say someone listens to all of your podcasts, reads your book, studies it intensely. What's the delta you find in somebody being able to make a better decision? And where [inaudible 00:20:35] comes from is Daniel Kahneman of all people. People ask him, "Do you just live such a optimal life now that you know all of these biases we have and all these mental errors we make?" And he's like, "No, I can't..." I think he said famously, "I don't, actually. I can't use these in practice. This is just stuff that I have learned, but it doesn't actually impact my day to day." So I'm curious just how much better can someone get? What kind of delta have you found in terms of making decisions?

**中文翻译:**
没错，就是“尽管如此”。有道理。我想我们得忍住，别把这个播客变成育儿播客，因为这方面的内容太多了。我们一直在聊决策和框架之类的话题。我想问你的是，一个人在做决策方面到底能提高多少？例如，如果有人听了你所有的播客，读了你的书并深入研究。你发现一个人的决策能力会有多大的提升（delta）？这个问题源于丹尼尔·卡尼曼。人们问他：“既然你知道我们所有的偏见和心理错误，你现在的决策是不是非常完美？”他回答说：“不，我做不到……”他有一句名言：“实际上我做不到。我无法在实践中运用这些。这些只是我学到的知识，但并不会真正影响我的日常生活。”所以我很好奇，一个人到底能提高多少？在决策方面，你发现的提升空间有多大？

---

### [00:20:59] Annie Duke

**English:**
Okay, so it depends on whether you actually do the things. I mean, I think that that's what the issue is. I think Kahneman did some work way back that started him on this journey. That was basically work on hiring and it was taking it from completely unstructured Lenny, saying, "I just know a great product manager when I see one", whatever that means, to me going to Lenny and saying, "Okay, I understand that you think that you see a great product manager you know one when you see one", but can you explain to me what that means? In the abstract, what are the things that you're looking for in someone that you want to fill that role? And we can then excavate that, right? And make what is implicit because you're applying some implicit model to how you're thinking about the person that you're interviewing and how they map onto the role that they're going to be, but let's make that explicit.

**中文翻译:**
好吧，这取决于你是否真的去实践。我认为这就是问题所在。卡尼曼早年做过一些研究，开启了他的这段旅程。那主要是关于招聘的研究，将完全非结构化的面试（比如 Lenny 说：“我一眼就能看出谁是优秀的产品经理”，不管那意味着什么）转变为：我去问 Lenny，“好吧，我知道你觉得自己能一眼看出优秀的产品经理，但你能向我解释一下那意味着什么吗？抽象地讲，你在寻找具备哪些特质的人来填补这个职位？”然后我们可以挖掘这些特质，对吧？把你面试时的内隐模型（implicit model）以及你如何将面试者与职位匹配的过程，转化为外显的（explicit）标准。

---

### [00:22:04] Annie Duke (Continued)

**English:**
So we can make that explicit, we can turn it into a decision rubric, we can create a structured interview process out of that. And then what he found was after you've gone through that process, if you then use your intuition after having done that, not before, that then you actually can really drastically improve your hit rate on hiring. And in that case, it was from about a 50% hit rate to 65. So that's pretty huge, so that's a really big difference. The problem is nobody does it. So I can tell you that most of the conversations that I had with Danny that were about my work in particular were just him saying, "How do you get anybody to do it?" Now that's not to say that I would be better at that than him, it's that he didn't do my job, right? So he was an academic doing research and so on and so forth, I'm living in companies embedding for years.

**中文翻译:**
我们可以将其外显化，转化为决策准则（decision rubric），并以此建立结构化面试流程。他发现，在完成这个过程之后，如果你再使用直觉（注意是之后，而不是之前），你的招聘成功率会大幅提升。在那个案例中，成功率从 50% 提高到了 65%。这是非常巨大的提升。问题在于，没人这么做。我可以告诉你，我和丹尼之间关于我工作的对话，大部分时间他都在问：“你怎么能让别人真的去执行呢？”这并不是说我比他更擅长执行，而是他不做我的工作，对吧？他是一名做研究的学者，而我多年来一直深入公司内部。

---

### [00:23:02] Annie Duke (Continued)

**English:**
I've been with one client for five years, one client for four years, one client for four years also, almost four years, three and a half years. And then I just took on a new client who I've been with for six months, and that's my whole client roster because I stay with them so long. So if you do it, the answer is quite a bit. Like at least in terms of Danny's work in relation to something pretty noisy like hiring, you went from 50% hit rate to 65% hit rate, which is huge. It's enormous. The problem is that the way that you can make decisions in order to be better at them is not supernatural to the way that humans make decisions.

**中文翻译:**
我有一个客户合作了五年，两个客户合作了四年左右，还有一个新客户合作了六个月。这就是我全部的客户名单，因为我跟他们合作的时间非常长。所以，如果你真的去执行，提升是非常显著的。就像丹尼在招聘这种充满噪音的领域所做的研究，成功率从 50% 提升到 65%，这是巨大的进步。问题在于，为了做得更好而采取的决策方式，并不符合人类做决策的自然本能。

---

### [00:23:47] Annie Duke (Continued)

**English:**
I think we think a lot more highly of our intuition than we really ought to. We think very highly of our ability to notice things in the moment and act rationally toward them in a way that really we ought not to. We tend to think that we have insight that other people don't have when actually the other people probably have more insight into our situation than we do. So I think the answer is a lot with a big if, with an if you can get people to do it. And I think that's where the issue comes in. Now, the good news is that you can then reverse that and say if I'm willing to do it, think about what an edge I'm going to have over people who aren't willing to do it, right?

**中文翻译:**
我认为我们对直觉的评价过高了。我们过高地估计了自己在当下察觉事物并理性行动的能力。我们往往认为自己拥有别人没有的洞察力，而实际上，别人可能比我们自己更了解我们的处境。所以，我认为答案是“可以提高很多”，但有一个巨大的前提：如果你能让人们真的去执行。这就是问题所在。不过，好消息是你可以反过来想：如果我愿意执行，想想看，相比那些不愿意执行的人，我将拥有多大的优势，对吧？

---

### [00:24:36] Annie Duke (Continued)

**English:**
So we can think there's people who don't know about it, there's people who do know about it but don't do it, and then there's people who do know about it, but do do it. And it's that last group that's so tiny. So the answer is I think a lot, but nobody does it.

**中文翻译:**
我们可以把人分为：不知道这些方法的人、知道但不做的人、以及既知道又真正执行的人。最后一组人非常少。所以答案是：提升空间很大，但几乎没人去做。

---

### [00:24:54] Lenny Rachitsky

**English:**
So maybe following that thread, when you look at companies that you've worked with or companies that have read your book and really dove in and started to implement some of your piece of advice to make better decisions, if you could look back at the ones that had an impact, what do you find are the mental models or frameworks or tactics that really stick that most often have an impact and the biggest impact?

**中文翻译:**
顺着这个思路，当你观察那些你合作过的公司，或者读过你的书并真正开始实施你的建议以改善决策的公司时，回顾那些产生显著影响的案例，你发现哪些心理模型、框架或策略是最容易被坚持下来、且往往能产生最大影响的？

---

### [00:25:18] Annie Duke

**English:**
I think the one that's easiest to implement is this. And it's so easy, and I just wish more people would do it. The best way to get somebody's opinion is independently of other people's opinions, independently asynchronously. So the way that I put is I want people to stop talking to each other so much. When we think about what did people generally think the purpose of a meeting is, they think it's for three things. Discovery, which is I want to discover what your opinions are, what your judgments are of something, right? So I want to find out what you think about something. So for example, if we're in product development and we're trying to figure out a timeline, we're trying to develop a product roadmap and we're trying to figure out how long it's going to take to release certain features or something like that, we all come into a room and we start yelling it out together.

**中文翻译:**
我认为最容易实施的是这一点。它非常简单，我真希望更多人能这么做：获取某人意见的最佳方式是让他们独立于他人的意见，即独立且异步地表达。我的说法是，我希望人们不要在会议上过多地交谈。当我们思考人们通常认为会议的目的是什么时，他们认为是三件事。第一是“发现”（Discovery），即我想发现你的观点是什么，你对某事的判断是什么。例如，在产品开发中，我们要确定时间线或产品路线图，估算发布某些功能需要多长时间，我们通常会聚在一个房间里，大家一起喊出自己的想法。

---

### [00:26:29] Annie Duke (Continued)

**English:**
It's so bad for decision-making, I can't even tell you. There's cross influence, the loudest person in the room tends to then have an outsized influence on the decision, the most confident person in the room tends to have an outsized influence on the decision. And that's great if the most confident person is also right, but the problem is that's not always so. And so that's the discovery piece, right? And we tend to do that in a group. And then there's discussion, which is I've now discovered the way that Lenny is modeling this problem or what his judgments are about certain things or his forecasts are, his estimates are. And now, we're going to discuss those ideas and we're going to discuss your ideas in comparison to my ideas, and that's going to happen in the group setting. And then there's also now, we're going to decide in the group setting. So we're going to make some set of decisions about say what the roadmap is going to look like.

**中文翻译:**
这对决策来说太糟糕了。存在相互影响，房间里嗓门最大的人往往会对决策产生过大的影响，最自信的人也是如此。如果最自信的人恰好也是正确的，那当然好，但问题是情况并非总是如此。这就是“发现”环节，我们倾向于在群体中完成它。第二是“讨论”（Discussion），即我已经发现了 Lenny 是如何构建这个问题的模型，或者他对某些事情的判断、预测和估算是什么。现在，我们要讨论这些想法，将你的想法与我的想法进行对比，这会在群体环境中发生。第三是“决定”（Decide），即在群体环境中做出决定，比如确定路线图最终是什么样的。

---

### [00:27:26] Annie Duke (Continued)

**English:**
Here's the thing that I think is the easiest to change, is to realize the only thing that's ever supposed to happen in a meeting is the discussion part. So we should absolutely be coming together as human beings to discuss everybody's judgments and opinions and the way they're modeling the problem and their forecasts. In particular, it's really good to come in and discuss the places where people are different. So you've been in many meetings, I'm sure about 80% of the time is double clicking. Oh, I agree. And I want to now we've literally just used different words to say the exact same thing because I'm in agreement.

**中文翻译:**
我认为最容易改变的一点是：意识到会议中唯一应该发生的事情就是“讨论”部分。我们绝对应该聚在一起讨论每个人的判断、意见、建模方式和预测。特别是，讨论大家意见不一致的地方是非常有益的。你肯定参加过很多会议，其中 80% 的时间都在重复确认：“哦，我同意。”然后用不同的措辞把同样的话再说一遍，仅仅因为我表示赞同。

---

### [00:28:07] Annie Duke (Continued)

**English:**
If we can focus the discussion on places that people disagree, we're much better off. But so now we can take this, discover, discuss, decide. So I'm saying discuss is only supposed to happen in the meeting, that's the only thing that's supposed to happen in the meeting. So what's happening with the other stuff, the discover and the decide? Well, and this is the thing that I think I actually have been able to get people to do is discover what people think before you get in a room independently of each other. So how would you do that? Well, let's imagine that you're going to have a meeting about the product roadmap.

**中文翻译:**
如果我们能把讨论集中在人们意见分歧的地方，效果会好得多。所以，回到“发现、讨论、决定”。我说讨论只应该在会议中发生，那是会议中唯一该做的事。那么其他两项呢？关于“发现”，我成功让人们做到的一点是：在进入会议室之前，独立地发现每个人的想法。具体怎么做？假设你要开一个关于产品路线图的会议。

---

### [00:28:43] Annie Duke (Continued)

**English:**
So you would say to yourself in this meeting, what are the opinions that I need to get from the people in the room? It could be a brainstorm. What are all the different features that we could develop? So it could be a brainstorm. Fine. Write to them independently and say, "Hey, free for off. Just come up with all the different features that you think would be reasonable for us to consider developing and then give me a forced rank from best to worst of your own ideas with some three to five sentence rationale as to why you have these things in this order." And so I could do that, but maybe we already have a list. I can send that out for a forced rank to everybody. Okay, so here's the final list of things we're really considering. Prioritize those for me, just force rank them. And then again, give me a rationale.

**中文翻译:**
你会问自己：在这次会议中，我需要从参会者那里获得哪些意见？可能是头脑风暴，比如“我们可以开发哪些不同的功能？”没问题。独立写信给他们说：“嘿，大家自由发挥。想出所有你认为合理的、值得考虑开发的功能，然后对你自己的想法进行强制排序（从最好到最差），并用三到五句话说明你这样排序的理由。”或者，如果我们已经有了一个清单，我可以发给每个人进行强制排序：“这是我们正在考虑的最终清单，请帮我排个优先级。”同样，也要给出理由。

---

### [00:29:32] Annie Duke (Continued)

**English:**
Give me a little bit of free writing as to why you think this should be, that you have these things in this order. Maybe we've decided now on what our top five priorities are. Great. I could, before the meeting, send the top five priorities out. "Hey, we've decided on this stuff." For each thing, I'd like to understand what you think a reasonable timeline is, how many sprints it's going to take, so on, so forth, right? So we can ask for that type of information so that we can start making estimates because that's going to affect budget and what we're going back to the board with and so on so forth. But regardless, just figure out what is the thing that we're going to be discussing in this meeting? And I'm going to send it out to everybody independently and I'm going to say, "Don't reply all, just send it back to me independently."

**中文翻译:**
写一点简短的文字，解释为什么你认为应该这样排序。假设我们已经确定了前五个优先级。太好了。在会议之前，我可以把这五个优先级发出去：“嘿，我们已经决定了这些。对于每一项，我想了解你认为合理的时间线是什么，需要多少个冲刺（sprints）等等。”我们可以索要这类信息以便开始估算，因为这会影响预算以及我们要向董事会汇报的内容。但无论如何，先搞清楚会议要讨论什么，然后独立发送给每个人，并强调：“不要回复所有人，只单独回复给我。”

---

### [00:30:14] Annie Duke (Continued)

**English:**
If it's a repeated decision, you can actually create a rubric that lives on Airtable or Coda or Google Sheets or whatever, I don't really care. And people can input their decisions there where they can't see anybody else's decision. So with Google, you can use Google Forms in order to do it, and then it dumps into a spreadsheet that only you can see. That's a great way to do it. So anyway, so you do that and now you can now see everybody's opinions that you then now send out to the group and say, "Everybody, look this over before we come in and discuss." So notice you're still working as a group, but you're working as a group where you're not in the same room together and talking at the same time. And there's a word for that, which is nominal group. So it's a group that at that moment is working independently and asynchronously of each other.

**中文翻译:**
如果这是一个重复性的决策，你可以在 Airtable、Coda 或 Google Sheets 上创建一个准则表。人们可以在那里输入他们的决定，且看不到别人的。使用 Google Forms 也是个好办法，数据会汇总到只有你能看到的表格中。总之，你收集了所有人的意见，然后在会前发给全组说：“大家在讨论前先看一下这些意见。”注意，你们仍然作为一个团队在工作，但不是在同一个房间里同时说话。这有一个术语叫“名义小组”（nominal group），即在那个时刻，小组成员是独立且异步工作的。

---

### [00:31:03] Annie Duke (Continued)

**English:**
So if you can get people to do that, and I do have companies where I don't consult with them, but I've just come in and talked to them briefly or whatever that do actually implement that piece of it. That is a huge piece of it, that's ginormous. And then you do the same thing for deciding. So the decision should not be made in a room, it's made either. I love the one decision maker model, but not everybody's down with that. But you can have a vote forum where people go vote in private about the way they're leaning.

**中文翻译:**
如果你能让人们做到这一点（我确实见过一些我只是简短交流过、并未深入咨询的公司在实施这一点），那将产生巨大的影响。对于“决定”环节也是如此。决定不应该在会议室里做出。我个人非常推崇“单一决策者”模型，但并非所有人都能接受。不过，你可以建立一个投票机制，让人们私下投票表达他们的倾向。

---

### [00:31:39] Annie Duke (Continued)

**English:**
You can do a variety of things with that, but just don't do it. Don't do it in the meeting. And then just the last thing that I'll add, which is a muscle that you really have to exercise, is I think it's really important to understand that the word alignment in terms of we're all aligned as a group, right? The word alignment is stupid and it shouldn't be used. And I know I'm saying that very harshly, but it's true. It's dumb because it doesn't exist. You have 10 people in a room and they're all really different people with different opinions, and they're never going to come out of the room agreeing with each other. And it's really bad if the expectation is that they're supposed to, and it's really bad for a few reasons. One is it isn't reality, and that I don't like coming out of things without reality actually kicking.

**中文翻译:**
你可以采取多种方式，但千万不要在会议中做决定。最后我想补充一点，这是一项需要锻炼的能力：我认为理解“达成共识”（alignment）这个词非常重要。在“我们作为一个团队达成共识”这个语境下，“共识”这个词很愚蠢，不应该被使用。我知道我说得很重，但这是事实。它很蠢，因为它根本不存在。房间里有 10 个人，他们都是性格迥异、观点不同的人，他们走出房间时不可能完全达成一致。如果预期是他们“应该”达成一致，那是非常糟糕的，原因有几点。第一，这不符合现实，我不喜欢脱离现实的结果。

---

### [00:32:38] Annie Duke (Continued)

**English:**
So it's not reality. People don't actually agree, they're not actually aligned on the decision. That's just the thing that makes you feel better, right? So I think that that's problem number one. But problem number two is that if the goal is alignment, if the goal is agreement, then the meeting becomes coercive and you never want that. So the way that I'm supposed to talk about my ideas is to convey why I believe what I do, not to convince anybody that I'm right because if I'm working to convince people that I'm right, it becomes coercive and that's horrible. So you have to get comfortable with walking out of the room. This is the nevertheless. Walking out of the room understanding that once you have that discussion, it's not that Lenny, your opinion might change. It could, right? I could say my thing and it could be just so damn brilliant that you change your mind somewhat, right?

**中文翻译:**
所以这不是现实。人们实际上并没有达成一致，也没有在决策上完全统一。那只是让你感觉好受一点的东西，对吧？这是第一个问题。第二个问题是，如果目标是“达成共识”或“一致同意”，那么会议就会变得具有强迫性（coercive），而你绝对不希望看到这一点。我表达想法的方式应该是传达我为什么相信我所相信的，而不是为了说服别人我是对的。因为如果我努力说服别人我是对的，那就变成了强迫，这很糟糕。所以你必须习惯于走出房间时依然存在分歧。这就是“尽管如此”。走出房间时要明白，讨论之后，Lenny 你的观点可能不会改变。当然也可能会变，也许我的观点太精辟了，让你改变了主意。

---

### [00:33:37] Annie Duke (Continued)

**English:**
So you come maybe you're like, "Oh, I'm thinking about this differently and actually", but maybe you don't and you still believe a thing that's very different than me. And leadership has to say, "That's fine. I've heard both of you and I know that this isn't going Annie's way. Nevertheless, trying to think about what all of our goals are, this is what the decision is going to be and it's totally fine that you ended up not agreeing with each other because it's reality. And what it allows me to do is get a better sense of what the space of decisions is." So those things I have been able to get people to do and they're actually quite impactful.

**中文翻译:**
所以你可能会说：“哦，我的想法确实不一样了。”但也可能你依然坚持与我完全不同的看法。领导层必须说：“没关系。我已经听取了你们两人的意见，我知道这不符合安妮的想法。尽管如此，考虑到我们所有的目标，这就是最终的决定。你们最终没有达成一致完全没问题，因为这就是现实。这让我能更好地了解决策的空间。”这些是我成功让人们做到的事情，它们确实非常有影响力。

---

### [00:34:17] Lenny Rachitsky (Sponsor: LinkedIn Ads)

**English:**
Imagine a place where you can find all your potential customers and get your message in front of them in a cost-efficient way. If you're a B2B business, that place exists, and it's called LinkedIn. LinkedIn Ads allows you to build the right relationships, drive results, and reach your customers in a respectful environment. Two of my portfolio companies, Webflow and Census, are LinkedIn success stories. Census had a 10X increase in pipeline with the LinkedIn startup team. For Webflow, after ramping up on LinkedIn in Q4, they had the highest marketing source revenue quarter to date. With LinkedIn Ads, you'll have direct access to and can build relationships with decision-makers, including 950 million members, 180 million senior execs and over 10 million C-level executives. You'll be able to drive results with targeting and measurement tools built specifically for B2B. In tech, LinkedIn generated two to five X higher return on ad spend than any other social media platforms.

**中文翻译:**
想象一下，有一个地方可以让你找到所有潜在客户，并以极具成本效益的方式向他们传递信息。如果你是一家 B2B 企业，这个地方确实存在，它就是 LinkedIn。LinkedIn Ads 允许你在尊重的环境中建立正确的关系、推动业绩并触达客户。我的两家投资组合公司 Webflow 和 Census 都是 LinkedIn 的成功案例。Census 通过 LinkedIn 创业团队实现了销售线索（pipeline）10 倍的增长。对于 Webflow 来说，在第四季度加大 LinkedIn 投入后，他们实现了有史以来最高的营销来源收入季度。通过 LinkedIn Ads，你可以直接接触并与决策者建立关系，其中包括 9.5 亿会员、1.8 亿高级管理人员和超过 1000 万 C 级高管。你将能够利用专为 B2B 设计的定向和衡量工具来推动业绩。在科技领域，LinkedIn 的广告支出回报率（ROAS）比其他任何社交媒体平台高出 2 到 5 倍。

---

### [00:35:14] Lenny Rachitsky (Sponsor: LinkedIn Ads Continued)

**English:**
Audiences on LinkedIn have two times the buying power of the average web audience, and you'll work with a partner who respects the B2B world you operate in. Make B2B marketing everything it can be and get $100 credit on your next campaign. Just go to linkedin.com/podlenny to claim your credit. That's linkedin.com/podlenny. Terms and conditions apply. There's an implication here you touched on a bit that there's a DRI essentially, there's one decision maker. Sometimes people start to feel like, "Oh, my voice isn't heard. I don't have a lot of say, I can't be part of this decision." And you talked a bunch about just how to make people feel included, you get feedback along the way. But any advice there if you try to move to this model of making people feel like, "Okay, I actually have impact on where this goes"?

**中文翻译:**
LinkedIn 上的受众购买力是普通网络受众的两倍，而且你将与一个尊重你所处 B2B 世界的伙伴合作。让 B2B 营销发挥最大潜力，并在下次活动中获得 100 美元的抵用金。只需访问 linkedin.com/podlenny 即可领取。地址是 linkedin.com/podlenny。受条款和条件限制。你刚才提到了一点，即本质上有一个直接负责人（DRI），也就是唯一的决策者。有时人们会觉得：“哦，我的声音没被听到。我没有发言权，我无法参与这个决策。”你谈到了很多关于如何让人们感到被包容、在过程中获取反馈的方法。但如果你尝试转向这种模式，有没有什么建议能让人们觉得“好吧，我确实对事情的走向产生了影响”？

---

### [00:35:58] Annie Duke

**English:**
Yeah. So here's the really wonderful thing about moving from a coercive model to really, I guess you could say a model of curiosity, right? You want to be curious, not coercive, which means that the way that people in the meeting are talking about what their opinions are is in the mode of conveying information, not trying to convince anybody. So once we move away from that coercive model, and when I say coercive, I'm not saying anybody is purposely trying to set up a culture of coercion. Sometimes that's true, but for the most part, everybody's trying to do a good job and nobody's trying to set up a culture of coercion. But as soon as you say, "Are we all in agreement? Are we all in alignment?" And as soon as you're allowing people, and I'm sure you've been in these meetings, right? If you allow people to interrupt, if you allow people to say this, "I think you're wrong", "I disagree", "Here's why", those are all very coercive things to have happen.

**中文翻译:**
是的。从强迫模式转向我所谓的“好奇模式”是一件非常美妙的事情。你要保持好奇，而不是强迫。这意味着参会者表达观点的方式是“传递信息”，而不是“试图说服任何人”。当我们摆脱强迫模式时（我说的强迫并不是指有人故意建立强迫文化，虽然有时确实如此，但大多数人只是想做好工作），一旦你说出“我们都同意吗？我们都达成共识了吗？”或者你允许人们互相打断，允许人们说“我觉得你错了”、“我不同意”、“理由如下”，这些都是非常具有强迫性的行为。

---

### [00:37:12] Annie Duke (Continued)

**English:**
Interrupting someone is silencing them. Saying, "You're wrong", well now, you become tribal and people aren't going to be open-minded and they're going to stake their ground and it's all really bad. So let's move away from that. Number one, that's already going to help. But when we think about the way that meetings normally happen, again, there's all this crosstalk and some people aren't speaking and some people are and so on, so forth. And then of course, not everybody feels equally heard. But when you work as a nominal group, let's talk about something as simple as we're going to make a forecast of how long it's going to take to launch this product feature. Okay. So I'm going to send out to everybody, what's your point estimate? What's your lower bound? What's your upper bound in terms of timeline?

**中文翻译:**
打断别人就是在让他们噤声。说“你错了”，会让大家变得像部落一样对立，人们不再开放心态，而是死守阵地，这非常糟糕。所以我们要远离这些。这是第一点，已经很有帮助了。但想想通常的会议，总是充满了交谈，有些人说话，有些人不说话。当然，并不是每个人都感到被平等地倾听。但当你以“名义小组”的方式工作时——比如我们要预测发布某个产品功能需要多长时间。我会发给每个人：你的点估算（point estimate）是多少？你的下限和上限是多少？

---

### [00:38:02] Annie Duke (Continued)

**English:**
And you could do it in some way, like how many sprints do you think is going to take whatever language you want to use? Now, everybody independently now gives their forecast with a rationale for why they believe that. And then you come into the room and you run a discussion where everybody's getting to say what their estimate was and why they believe that, and people are getting to ask questions. "I have a question" always is a clarification, it's just I don't understand. And as the leadership, the way that you would do it is, let me give you an example from a real one because that'll be easy. I did one of these discussions for a question about remote work, like what did the company want in terms of remote versus hybrid and that kind of thing. And so there was a lot of disagreement about whether whatever the policy was, it should be consistent across functions. Lots of disagreement.

**中文翻译:**
你可以用任何术语，比如需要多少个冲刺。现在，每个人独立给出他们的预测和理由。然后进入会议室进行讨论，每个人都有机会说出自己的估算和理由，其他人可以提问。“我有一个问题”应该始终是为了“澄清”，即“我不明白”。作为领导者，你的做法应该是——让我举个真实的例子。我曾主持过一次关于远程办公的讨论，比如公司想要远程、混合办公还是其他模式。关于政策是否应该跨职能部门保持一致，存在很多分歧。

---

### [00:39:01] Annie Duke (Continued)

**English:**
So let's take somebody who was on the, no, it shouldn't be consistent across functions. So they now say why they believe it shouldn't be consistent across functions and they say things like, "Well, different functions have different requirements, right?" So there's some functions that have to be in the office, like if you're IT as an example, but there's other functions which are more collaborative and creative and whatnot where it makes sense for people to be in the office, whereas engineers doesn't really matter, right? So there's different needs of different functions in terms of how much they need to be in the same space. So I'm not agreeing or disagreeing with this, I'm just saying what somebody said. So now as a facilitator, I never say, "Oh, I agree." What I say is I just want to make sure I understood what you said and I reflect it back.

**中文翻译:**
假设有人认为“不应该跨职能一致”。他们会解释原因，比如：“不同的职能有不同的需求，对吧？”有些职能必须在办公室，比如 IT 部门；有些职能更具协作性和创造性，在办公室更有意义；而对于工程师来说，可能无所谓。所以不同职能对共同空间的需求不同。我并不表示同意或反对，我只是在陈述某人的观点。作为主持人，我绝不会说“哦，我同意”。我会说：“我只是想确认我理解了你的意思”，然后把观点复述一遍。

---

### [00:39:57] Annie Duke (Continued)

**English:**
So I say, "So what I heard you say is that not all functions are created equal in terms of how well they work remotely or how well they work in person or what the flexibility might be. So what you're saying is there're functions that have to be in person. Period. And then other functions where that collaborative element being in the same office would be more important versus some functions where being remote is totally fine. Is that what you meant?" And then they have the ability to say, "Yes, that is what I meant" or, "Actually, I meant something slightly different. Let me say what that is", and then I reflect that back. Okay, so literally you're just going around, you're calling on people to do that, and then you're reflecting back what they say without offering your own opinion. I don't know, Lenny. Tell me how someone doesn't feel heard in that situation.

**中文翻译:**
我会说：“所以我听到的是，你认为并非所有职能在远程工作、实地工作或灵活性方面的表现都是平等的。也就是说，有些职能必须实地办公，没得商量。而另一些职能中，在同一个办公室协作更重要，还有一些职能远程办公完全没问题。你是这个意思吗？”然后他们可以回答：“是的，我就是这个意思”，或者“其实我的意思稍微有点不同，让我再解释一下”，然后我再复述一遍。所以，你只是轮流点名让大家发言，然后复述他们的话，而不表达自己的观点。Lenny，告诉我，在这种情况下，谁会觉得自己没被倾听？

---

### [00:40:48] Lenny Rachitsky

**English:**
Yeah. Absolutely. I would feel so good if somebody just clarified and made it clear they know exactly what I'm saying, even if the decision doesn't end up the way I want.

**中文翻译:**
是的，绝对如此。如果有人能澄清并明确表示他们完全理解我在说什么，即使最终决定不符合我的心意，我也会感觉非常好。

---

### [00:40:57] Annie Duke

**English:**
Right, so that's the thing. And then what actually ends up happening is that the people in the room feel more, the psychological term would be endowed, more endowed to the decision. In other words, they feel like they have ownership over the decision. And whatever the decision is, they generally will see their selves reflected in it because they were heard. And they also will generally understand that nobody, no one really ends up with exactly every single thing that they wanted to see in the decision because they also get to see the true spread of opinions on the team. And what you see in that situation is that there's lots and lots and lots and lots of disagreement, which you don't see if you talk in a group. It narrows the space, right?

**中文翻译:**
没错，这就是关键。实际结果是，房间里的人会感到更多的——心理学术语叫“禀赋感”（endowed）——对决策更有主人翁意识。换句话说，他们觉得对决策拥有所有权。无论决定是什么，他们通常都能在其中看到自己的影子，因为他们被倾听了。他们通常也会理解，没有人能让决策完全符合自己的每一项要求，因为他们也看到了团队中意见的真实分布。在这种情况下，你会看到大量的分歧，而如果你只是在群体中交谈，这些分歧是被掩盖的。群体交谈会缩小决策空间，对吧？

---

### [00:41:48] Annie Duke (Continued)

**English:**
So for example, particularly if you're senior, if you say, "I think this is going to take three months to launch" and I was thinking four weeks, you're never going to hear four weeks from me, ever. But if we get those opinions independently, you will actually hear that I think it's going to take four weeks. You may tend to be more right there being more senior, but I may have something interesting to say. You should hear what I have to say. And this also allows me to learn from you, too. But because I haven't heard your opinion first, then I'm not going to conform my opinion to yours. So it actually spreads the surface area of disagreement that you see on the team, which then makes people feel much better about the decision not being exactly what they want because they recognize like, "Oh, this is actually a hard problem. People really disagree on this stuff."

**中文翻译:**
例如，特别是如果你是资深人士，如果你说“我认为这需要三个月才能发布”，而我原本想的是四周，那么你永远不会从我嘴里听到“四周”这个词。但如果我们独立收集意见，你就会听到我认为需要四周。作为资深人士，你可能更正确，但我可能有有趣的见解，你应该听听。这也让我能向你学习。但因为我没有先听到你的意见，我就不会为了迎合你而改变自己的看法。所以这实际上扩大了团队中可见的分歧面，反而让人们对最终决定（即使不完全符合心意）感到释怀，因为他们意识到：“哦，这确实是个难题，大家的意见真的很不统一。”

---

### [00:42:41] Lenny Rachitsky

**English:**
Amazing. I think this is going to be really helpful to a lot of people. Just to close the thread on this little summary maybe is core advice here is brainstorm separately. So I guess first, there's discover, discuss, decide. To discover ideas completely independently, basically brainstorms. You're a big advocate of brainstorming independently, sitting on your own, thinking through ideas. And then bringing people together to discuss all the things they've come up with and especially where they disagree. And then ideally having one person that makes a decision once she or he has taken all the input.

**中文翻译:**
太棒了。我想这对很多人都会非常有帮助。总结一下核心建议：分开进行头脑风暴。首先是发现、讨论、决定。完全独立地发现想法，本质上就是独立头脑风暴。你非常提倡独立思考，自己坐下来理清思路。然后把大家召集起来讨论所有的想法，特别是分歧点。最后，理想情况下由一个人在听取所有意见后做出决定。

---

### [00:43:12] Annie Duke

**English:**
Yeah, you can have one person. I mean, I work with people where it's like a partnership and there's six people who are going to vote, but they still do it independently. They go to a forum. So I don't know what your vote is. And all six people don't have to agree. I mean, I just think it's really important that once you get above an end of one, you shouldn't necessarily expect the people to agree, which I think is just really important. And this is good for more than just brainstorming. It's for forecasting, any kind of project planning, budgeting. Yeah, I mean, we do this, for example, at First Round, we have a structured forum for evaluating a company in terms of whether you should invest in it because there are facts and then there are the way that you model those facts in. So it's a lot, what are the investor's opinion of the founder and the product and that kind of thing.

**中文翻译:**
是的，可以由一个人决定。我也和一些合伙制企业合作，比如有六个人投票，但他们仍然是独立投票的。他们去一个平台投票，我不知道你的投票结果。而且这六个人不一定要达成一致。我认为非常重要的一点是，一旦决策者超过一个人，就不应该强求大家达成一致。这不仅适用于头脑风暴，也适用于预测、任何类型的项目规划和预算编制。例如，在 First Round，我们有一个结构化的平台来评估是否投资一家公司，因为事实是一回事，而你如何对这些事实建模是另一回事。这很大程度上取决于投资者对创始人、产品等方面的看法。

---

### [00:44:06] Annie Duke (Continued)

**English:**
And we just have structure around how we're eliciting those opinions, which is really helpful. The other thing that I'll just add to what you said is that you can actually be in the same room together and still discover information independently. So this will happen on the fly all the time where people are talking and they start talking. Something comes up, like someone suggests some new feature or something like that, and then people start saying, "Yeah, but that's going to take..." And you go, "Stop. Okay, everybody take out a piece of paper." So you can still get that same independence on the fly as well as doing it in advance. But yes, that was a very nice summary.

**中文翻译:**
我们对如何引导这些意见有一套结构化的流程，这非常有帮助。我还想补充一点：你们其实可以待在同一个房间里，但仍然独立地发现信息。这种情况经常即兴发生：大家正在聊天，突然有人提议了一个新功能，然后大家开始议论：“是的，但那需要……”这时你可以说：“停。好，每个人拿出一张纸。”所以你既可以提前做，也可以即兴地获得这种独立性。不过是的，你刚才的总结非常到位。

---

### [00:44:49] Lenny Rachitsky

**English:**
If this is just the one thing people take away from this conversation already, I think that could have a big impact. Speaking of First Round, one, we actually just had Todd Jackson on the podcast talking about-

**中文翻译:**
如果人们从这次对话中只学到这一件事，我认为也会产生巨大的影响。说到 First Round，我们刚邀请了托德·杰克逊（Todd Jackson）来播客聊……

---

### [00:44:59] Annie Duke

**English:**
Love Todd.

**中文翻译:**
我超爱托德。

---

### [00:44:59] Lenny Rachitsky

**English:**
... love Todd, talking about product market fit. That episode will have come out before this episode. Also, so I asked Brett Berson, your colleague at First Round, what to ask you.

**中文翻译:**
……我也爱托德，他聊了产品市场匹配（PMF）。那集节目会在这一集之前播出。另外，我问了你在 First Round 的同事布雷特·伯森（Brett Berson），该问你些什么。

---

### [00:45:00] Annie Duke

**English:**
Oh, okay.

**中文翻译:**
噢，好的。

---

### [00:45:08] Lenny Rachitsky

**English:**
Yeah, yeah. By the way, your title of First Round is amazing, special partner. I've never seen that before.

**中文翻译:**
是啊。顺便说一句，你在 First Round 的头衔太酷了，“特别合伙人”（special partner）。我以前从未见过这种头衔。

---

### [00:45:15] Annie Duke

**English:**
I am. It's a title just for me.

**中文翻译:**
是的，这是专门为我设立的头衔。

---

### [00:45:17] Lenny Rachitsky

**English:**
Oh, my God.

**中文翻译:**
天哪。

---

### [00:45:17] Annie Duke

**English:**
I adore Brett Berson.

**中文翻译:**
我非常崇拜布雷特·伯森。

---

### [00:45:19] Lenny Rachitsky

**English:**
Me, too.

**中文翻译:**
我也是。

---

### [00:45:19] Annie Duke

**English:**
So I'm interested, I'm interested in what he said you should ask me.

**中文翻译:**
所以我很好奇，他让你问我什么。

---

### [00:45:23] Lenny Rachitsky

**English:**
Nothing too spicy, it's along the lines of what you talked about. So you said that you have a very interesting framework for how to think about decision quality in the short term when the outcome is very long term. For example, investing. Also, many decisions we make in business, things you need to decide now that you only find out years from now. Can you talk about your advice there and your insights here?

**中文翻译:**
没什么太劲爆的，和你刚才聊的差不多。你说过你有一套非常有趣的框架，用于在结果非常长期的情况下（例如投资）思考短期的决策质量。此外，我们在商业中做出的许多决定，现在就需要决定，但结果要几年后才知道。你能聊聊这方面的建议和见解吗？

---

### [00:45:43] Annie Duke

**English:**
Oh my gosh, I'm so happy that that's the question that he asked.

**中文翻译:**
天哪，我太高兴他问了这个问题。

---

### [00:45:45] Lenny Rachitsky

**English:**
Yep, I see.

**中文翻译:**
是的，我看得出来。

---

### [00:45:47] Annie Duke

**English:**
Okay, so can I give a tiny bit of background to this?

**中文翻译:**
好，我能先介绍一点背景吗？

---

### [00:45:49] Lenny Rachitsky

**English:**
Absolutely.

**中文翻译:**
当然可以。

---

### [00:45:50] Annie Duke

**English:**
So prior to talking to First Round, I have another client too who, they're amazing, Renegade Partners at Roseanne Wincek and Renata Quintini. They're incredible. Before finally hooking up with them, and they work at different stages, First Round is C, obviously. Renegade is more like A B, tiny bit of dabble in C. But before running into them, I talked to quite a few venture firms who are interested in talking to me post-Thinking in Bets having come out, so this would be 2018. And there was a theme, there was a theme across them all. The first one was, well, the kind of decision-making you're talking about we don't need to do because we just know a good founder when we see one. So that is a sentence that came out of many people's mouths. And as I just said to you, okay, I have no doubt, but don't you want [inaudible 00:46:52] make that explicit?

**中文翻译:**
在与 First Round 合作之前，我还有另一个客户，Renegade Partners 的 Roseanne Wincek 和 Renata Quintini，她们非常棒。在与他们合作之前（First Round 投种子轮，Renegade 投 A 轮和 B 轮），我接触过不少风投公司，那是 2018 年《对赌》出版后。他们都有一个共同的主题。第一个是：“嗯，你说的这种决策方式我们不需要，因为我们一眼就能看出谁是优秀的创始人。”很多人都说过这句话。正如我刚才对你说的，好吧，我不怀疑你的眼光，但难道你不想把它外显化吗？

---

### [00:46:53] Annie Duke (Continued)

**English:**
There's all sorts of great things that come from making it explicit, not just in terms of the increase in decision quality in the moment, but it actually allows you to close feedback loops much better. So that was one thing that I found quite surprising. But the one that I really found very interesting was being told, "Well, what you're talking about doesn't apply because our feedback loops are a decade." And in poker, you got an answer right away. You won or lost the hand right away. So the way that you're thinking about decision-making doesn't really apply, until I met First Round and then Renegade where they actually heard what I had to say because I gave the same answer to everybody. So we'll just put aside that wouldn't you want to make that explicit. The first thing that I would say is, oh, poker is much noisier than you think because when I win a hand, I have no idea why.

**中文翻译:**
将其外显化有很多好处，不仅能提高当下的决策质量，还能让你更好地闭合反馈循环。这是让我感到惊讶的一点。但真正让我觉得有趣的是有人告诉我：“你说的这些不适用，因为我们的反馈循环长达十年。”在扑克中，你马上就能得到答案，赢了还是输了。所以他们觉得我的决策方式不适用。直到我遇到 First Round 和 Renegade，他们真正听进去了我的话。我对所有人的回答都是一样的：首先，扑克比你想象的要嘈杂得多，因为当我赢了一手牌时，我其实不知道为什么赢。

---

### [00:47:50] Annie Duke (Continued)

**English:**
So I do actually have to wait a long time because I have to play many, many, many hands before I actually know, do I actually have an edge? Because I actually don't know very much. On one hand, for one thing, I almost never see my opponent's card, so I'm left in a dust of uncertainty. But separately from that, the main thing that I said was, how could you possibly think that the feedback loop is 10 years? And this is what I think really caught First Round's eye because when I was talking to Josh Kopelman about it, he said, "Well, what you're mean? We don't get an exit for 10 years." And I said, "Oh, I'm sorry, do you invest? And then you go to sleep like Rip Van Winkle? And then you wake up 10 years later and you go, 'Hey, how'd that go?' Or are there all sorts of things that happen in between?" The simplest thing, the simplest thing is does it fund at Series A?

**中文翻译:**
所以我实际上也需要等待很长时间，玩很多很多手牌，才能知道自己是否真的有优势。因为我了解的信息并不多。一方面，我几乎从来看不到对手的牌，所以我处于极大的不确定性中。除此之外，我说的核心观点是：你怎么可能认为反馈循环是 10 年呢？这就是吸引 First Round 注意的地方。当我与乔希·科佩尔曼（Josh Kopelman）交谈时，他说：“你什么意思？我们要 10 年后才能看到退出（exit）。”我说：“噢，抱歉，难道你投资之后就像瑞普·凡·温克尔（Rip Van Winkle，美国小说中一觉睡了 20 年的人）一样去睡觉，10 年后醒来问‘嘿，结果怎么样？’还是说这中间会发生各种各样的事情？”最简单的一件事就是：它能拿到 A 轮融资吗？

---

### [00:48:46] Annie Duke (Continued)

**English:**
And the little pushback that I would get there is, but we're not investing for Series A. And I say, "Well, I know that", but have you ever had a company that exited for more than a billion dollars that did not fund at Series A? And the answer is no. And I'm like, okay. So it sounds like that's necessary. Might not be sufficient, but it's necessary. And it's certainly a signal that is actually more highly correlated with exiting out well than the investment at C. And then, oh, right, you have series B. And that's separate from all the other things that you can look at, like what you talked to Todd Jackson about. Is it achieving product market fit? We know that eventually for it to be successful, it's going to have to achieve product market fit, right? So you can look at what's happening with that, just general things about traction, what's happening with net new ARR, ability to retain top talent churn.

**中文翻译:**
我得到的反驳通常是：“但我们投资的目标不是为了 A 轮。”我说：“我知道，但你见过哪家退出金额超过 10 亿美元的公司是没有拿到 A 轮融资的吗？”答案是没有。我说，好吧，看来这是必要条件。虽然不充分，但很必要。而且这绝对是一个信号，与最终成功退出的相关性比种子轮投资本身更高。然后，还有 B 轮。除此之外，还有你和托德·杰克逊聊到的：它是否实现了产品市场匹配（PMF）？我们知道，要成功，它最终必须实现 PMF，对吧？所以你可以观察进展，比如牵引力（traction）、净新增 ARR、留住顶尖人才的能力、流失率等等。

---

### [00:49:55] Annie Duke (Continued)

**English:**
I mean, there's so many different things that you can look at, all of which are things that you know must happen in order for the big thing to happen. Okay, so what that means is that this is the big, I'm going to make a bold statement here. There is no such thing as a long feedback loop. You can make a decision about how long the feedback loop is. That is your choice to live in a long feedback loop, and you can choose to shorten the feedback loop. And the way you choose to shorten the feedback loop is to say, what are the things that are necessary but not sufficient? That's one thing, for getting a good exit, or what are the things that are correlated with the outcome that I eventually desire? And what that means is that when you're at the decision point, right? Like in First Round's case, I'm going to invest in a company.

**中文翻译:**
我的意思是，你可以观察很多不同的事情，所有这些都是为了实现最终大目标而必须发生的事情。所以，我要在这里发表一个大胆的声明：世界上不存在所谓的“长反馈循环”。反馈循环有多长，取决于你的决定。选择生活在长反馈循环中是你的选择，你也可以选择缩短它。缩短反馈循环的方法是问：为了获得理想的退出，哪些是必要但不充分的条件？或者，哪些因素与我最终想要的结果相关？这意味着当你处于决策点时（比如 First Round 决定投资一家公司）。

---

### [00:50:51] Annie Duke (Continued)

**English:**
What you have to understand is that you are making a prediction about how the world is going to unfold, how the future is going to unfold. And those things that you're predicting. You can track, and you can track them back to the decision and you can do it pretty darn fast, mind you. I mean, think about being in 2021. There were companies that were raising in A six months after seed. Today, it's a little more 16 months-ish. But even so, let's just say that that was the only thing that you decided to do. I'm going to forecast the probability that this company's going to fund at Series A. And then obviously, those companies start to fund or not fund at Series A and you're finding that out in 16 months. Here's my question for you, Lenny. Is 16 months shorter than 10 years?

**中文翻译:**
你必须理解，你是在对世界如何展开、未来如何演变做出预测。而你预测的那些事情是可以追踪的，你可以将它们追溯到当初的决策，而且速度非常快。想想 2021 年，有些公司在种子轮后 6 个月就拿到了 A 轮。现在可能需要 16 个月左右。但即便如此，假设你只做一件事：预测这家公司拿到 A 轮融资的概率。显然，这些公司是否拿到 A 轮，你在 16 个月内就能知道。Lenny，我的问题是：16 个月是不是比 10 年短？

---

### [00:51:38] Annie Duke (Continued)

**English:**
So it's probably why he said to ask me that question because I just really do. I mean, I have a very strong opinion about this. The feedback loop is as long as you choose it to be. And if I take that back to some of the things that I heard early on when I was talking to people, what I would say is that I think that there is a certain amount of psychological safety in allowing the feedback loop to stay long because really of two main factors. One is that, look, if I was early into Uber and now I'm a celebrity investor or something, I don't really want to know if I'm good or not. Do I? Right? I don't really want the world to know that. I mean, if I'm good, that's great. But it feels like they already believe that I'm good because I happen to be early into Uber.

**中文翻译:**
这可能就是他让你问我这个问题的原因，因为我对此有非常强烈的观点。反馈循环的长度取决于你的选择。回到我早期听到的那些话，我认为让反馈循环保持很长，其实能提供某种“心理安全感”，主要有两个因素。第一，如果我早期投中了 Uber，现在成了明星投资者，我真的想知道我到底是不是真的厉害吗？我不一定想让世界知道真相。如果我真的很厉害，那当然好。但感觉大家已经因为我投中了 Uber 而认为我很厉害了。

---

### [00:52:47] Annie Duke (Continued)

**English:**
So since people already think I'm good, I'm just losing to that decision, psychologically speaking. Not investment quality speaking, but psychologically speaking. Okay, so here's the problem though. Why was I early into Uber? Did I have an insight into a real pain point in a developing market, blah, blah, blah? Or did my buddy start Uber and I was like, "Sure, I'll give you some money?" Right? I mean, obviously, I'm talking about the extremes here, but we don't actually know what the decision quality was, right? All we know is that you had a good result and given that you had a good result and people think very highly of you, what are you going to gain? Right? So it's so nice to just let that feedback loop sit there and allow people to have the opinion of you. That is really nice, feels good, right? And not actually find out the answer because why would I want to?

**中文翻译:**
既然人们已经觉得我很棒，从心理学角度（而非投资质量角度）来看，去验证真相只会让我蒙受损失。问题在于：我为什么能早期投中 Uber？是因为我对新兴市场的痛点有深刻洞察，还是因为我哥们儿创办了 Uber，我随手给了点钱？显然我是在说极端情况，但我们实际上不知道决策质量如何，对吧？我们只知道你得到了好结果，而且人们对你评价很高，那你还能从验证真相中获得什么呢？所以，让反馈循环挂在那儿，让人们保持对你的好印象，这感觉多好啊，对吧？为什么要去找答案呢？

---

### [00:53:51] Annie Duke (Continued)

**English:**
Unless you're really super focused on decision quality, then you would want to do that. So that's part of the psychological safety. And what that goes to is, the real core of it is that it's very, very difficult for human beings to deal with feeling wrong in the moment, even if it helps them in the long run. It's just hard. And the tighter the feedback loop, the more that you risk finding out you are wrong in the short run. Now that helps you to learn and improve your decision-making if you're focused on it and you're good at it, right? That's going to help you. And then in the long run, you're actually going to do better. But human beings are notoriously good at trading off the long run just to feel good in the short run. That's why we're all eating chocolate and cupcakes and stuff that we know is bad for us because it feels good.

**中文翻译:**
除非你超级关注决策质量，否则你不会想去验证。这就是心理安全感的一部分。其核心在于，人类很难处理“当下觉得自己错了”这种感觉，即使这在长期内对他们有帮助。这很难。反馈循环越紧密，你在短期内发现自己错误的风险就越大。如果你专注于此并擅长此道，这能帮你学习并改进决策，对吧？长期来看你会做得更好。但人类出了名地擅长为了短期快感而牺牲长期利益。这就是为什么我们明知巧克力和纸杯蛋糕对身体不好却还要吃，因为感觉很好。

---

### [00:54:45] Annie Duke (Continued)

**English:**
And so much of our decision-making is trying to advance this positive self-narrative and the idea that yeah, we're going to have a more positive narrative ourselves in five years if we do some stuff. Most of us are like, "No, I don't really want to make that trade. I'd rather just feel good now", and I can use the fact that we are living in power law, under the influence of power law. I can use that to just confirm a lot of things that I wish to believe that are true of me. And if you take that away from me and you take the uncertainty away from me, it's going to be really hard. And I will tell you that's what I love about both Renegade and First Round is that they're just like, I want to know. It would be such a horror for me to think that I was making good decisions when I actually wasn't. And that's what really matters to me and I think that it's just so special.

**中文翻译:**
我们的许多决策都是为了维持一种积极的自我叙事。虽然我们知道如果现在做些努力，五年后会有更好的叙事，但大多数人会想：“不，我不想做那个交易，我只想现在感觉良好。”我可以利用我们生活在“幂律分布”（power law）下的事实，来证实那些我希望自己拥有的特质。如果你拿走了这种不确定性，我会很难受。我之所以喜欢 Renegade 和 First Round，是因为他们会说：“我想知道真相。如果我以为自己在做正确决策而实际上并没有，那对我来说才是恐怖的事。”这才是真正重要的，我觉得这非常特别。

---

### [00:55:47] Lenny Rachitsky

**English:**
Hearing all this makes me want to be an LP in First Round. Not that they would let me in there, but just knowing that you're in there futzing with everything and the way they're thinking is really inspiring. I'm curious if you could share an example of anything that they tweaked as a result of this analysis that you did and how they evaluate.

**中文翻译:**
听了这些，我都想成为 First Round 的有限合伙人（LP）了。虽然他们可能不会让我加入，但知道你在那里优化一切，以及他们的思维方式，真的很令人振奋。我很好奇，你能不能分享一个例子，说明他们根据你的分析调整了什么，以及他们是如何进行评估的？

---

### [00:56:05] Annie Duke

**English:**
Well, first of all, let me just say they didn't really record a lot about their decisions when I first came in. They voted and they had a record of the vote so they knew who said yes and who said no, but they didn't have a lot of other information. So the first thing that happened was just that. Okay, what do we really think is the way that you would model whether you should invest or not invest in? Very broadly, you would say you're reading the market, the team, the founder, the product broadly. We're going to make sure that those opinions aren't just like it's good or it's bad, but it's on a scale of one to seven so that we can actually get some precision and some spread among the partners in terms of, say, strength of market. We're going to make sure that we have shared definitions of those things, which you'd be surprised people don't.

**中文翻译:**
首先，我刚去的时候，他们并没有记录太多关于决策的过程。他们投票，有投票记录，知道谁投了赞成或反对，但没有太多其他信息。所以第一件事就是：我们到底该如何建立模型来决定是否投资？广义上说，你会看市场、团队、创始人和产品。我们要确保这些意见不只是简单的“好”或“坏”，而是 1 到 7 分的量表，这样我们才能在市场强度等方面获得精确度，并看到合伙人之间的分歧。我们要确保对这些概念有共同的定义——你会惊讶地发现，人们往往没有共同定义。

---

### [00:57:00] Annie Duke (Continued)

**English:**
So when I am thinking about market and market quality, I might be thinking about something very different than you. So we want to make sure that we have a shared definition of that, and that's reflected in something that we would call mediating judgments, which are judgments that you make related to market prior to actually judging what you think of the market in general. So you could think of something like competitive landscape, so you would judge that. So that turns into what these mediating judgments are, which is basically an implied definition.

**中文翻译:**
当我思考市场和市场质量时，我想的可能和你完全不同。所以我们要确保有共同定义，这体现在我们所谓的“中介判断”（mediating judgments）中，即在对市场进行总体判断之前，先对与市场相关的具体因素做出判断。比如竞争格局，你会先评估它。这些中介判断本质上就是一种隐含的定义。

---

### [00:57:30] Annie Duke (Continued)

**English:**
So you create that, and then you also think about what are the forecasts that are important. One thing that you already know is you're going to forecast the probability the company funds at Series A. So that was a huge change, just a very different way of making decisions. What we've been able to do with that now because I've been there for five years is we now can actually look, say the partnership as a whole, and look at these ratings that they're making of the component pieces of parts of how they're modeling, like what makes a good investment, these forecasts that they're making.

**中文翻译:**
建立这些之后，你还要考虑哪些预测是重要的。其中一个你已经知道的，就是预测公司拿到 A 轮融资的概率。这是一个巨大的改变，一种完全不同的决策方式。因为我已经在那儿五年了，我们现在可以观察整个合伙关系，分析他们对投资模型各组成部分的评分（比如什么构成了好的投资）以及他们所做的预测。

---

### [00:58:03] Annie Duke (Continued)

**English:**
And we actually know how these companies have now unfolded. So in the simplest sense, we know whether hundreds of companies have funded at Series A or not. And now, we can actually look and say, how good are the partners at actually forecasting this thing? Right? Are they random? Are they better than random? And we actually know that and we can feed that back to them so that they can understand their own accuracy around these pieces of the decision because the fact is that whatever a seed investor says to you, whether that company is going to fund at Series A is part of their decision. It's included in the decision. So they're making that forecast whether they make the forecast explicitly or not. So what we're saying over at First Round is let's make it explicit because you're doing it implicitly anyway, and then we can actually start to look at your accuracy.

**中文翻译:**
我们现在知道这些公司后来的发展情况了。简单来说，我们知道数百家公司中哪些拿到了 A 轮，哪些没有。现在我们可以分析：合伙人们预测这件事的能力到底如何？是随机的吗？还是比随机好？我们知道结果，并可以反馈给他们，让他们了解自己在这些决策环节中的准确性。因为事实是，无论种子轮投资者怎么说，那家公司是否能拿到 A 轮融资都是他们决策的一部分。无论他们是否明确做出预测，这个预测都隐含在决策中。所以 First Round 的做法是：既然你已经在内隐地做预测了，不如把它外显化，这样我们就能衡量你的准确性。

---

### [00:58:58] Annie Duke (Continued)

**English:**
We can now feed that back to you and let you know how accurate you are, which will then help you to become more accurate, right? We can also look, because we know in any given vintage what are the best companies or what are the worst companies. Remember, we're having people do these ratings on a scale of one to seven of say the quality of the market, and we can look across the partnership and say, "Look, Lenny, when you think the market is great, how does that map onto how well the company is doing in the future? When you say the market is terrible, how well does that map onto how that company is doing, how that company ends up doing in the future?" And I can come to you and I can say, "Oh, Lenny, by the way, your judgments about market are amazing."

**中文翻译:**
我们可以把结果反馈给你，让你知道自己的准确度，从而帮你变得更准确，对吧？我们还可以观察，因为我们知道任何特定年份中哪些是最好的公司，哪些是最差的。记住，我们让人们对市场质量进行 1 到 7 分的评分，我们可以横向对比说：“看，Lenny，当你认为市场很好时，这与公司未来的表现匹配度如何？当你认为市场很糟时，匹配度又如何？”我可以告诉你：“Lenny，顺便说一下，你对市场的判断简直神了。”

---

### [00:59:47] Annie Duke (Continued)

**English:**
You know a good market when you see one and it's really mapping on in a great way onto how that company unfolds, but you're not so great with founder, or maybe you're great across the board, or maybe you're not. So we can now start to give people, we can give the partners insight into their own decision-making, not only to allow them to improve the decision-making, but also to allow them to understand not to over index on certain things that maybe aren't as predictive as an example for them. We also can change the rubric based on the evidence now.

**中文翻译:**
“你一眼就能看出什么是好市场，而且这与公司的发展高度吻合。但在判断创始人方面，你可能没那么准。”或者你可能全能，也可能不是。现在我们可以让合伙人洞察自己的决策过程，不仅能提高决策水平，还能让他们明白不要过度依赖某些预测性不强的因素。我们现在还可以根据证据来修改评分准则。

---

### [01:00:22] Annie Duke (Continued)

**English:**
So the first version of the rubric is always taking the intuitions of the partners and making those explicit, but then we can start to loop those back together and understand, well, maybe this thing that the partners thought was important actually isn't predictive across any partner. For example, we can start to develop the rubric based on the data. These were all things that weren't possible because prior to that, if I had come in and said, "Well, let's look at decision quality", how would I do that? I mean, I have no idea why people were... I just know whether they said yes or no. And so it's very difficult to them to start to do some really serious refining of the decisions if I don't have that information.

**中文翻译:**
评分准则的第一版总是将合伙人的直觉外显化，但随后我们可以通过闭环反馈发现：也许合伙人们认为重要的某件事，实际上对任何合伙人来说都没有预测价值。例如，我们可以开始基于数据开发准则。以前这是不可能的，因为如果我问“让我们看看决策质量”，我根本无从下手，我不知道人们为什么投赞成或反对。如果没有这些信息，就很难对决策进行严肃的精细化改进。

---

### [01:01:08] Lenny Rachitsky

**English:**
I desperately want to know which partner it makes the best decisions. I know you're not going to share them.

**中文翻译:**
我太想知道哪个合伙人做的决策最准了。我知道你不会分享的。

---

### [01:01:13] Annie Duke

**English:**
No, I'm not going to. The partnership as a whole is excellent as we know. And this is what I will tell you is that all partners have strengths and all partners have weaknesses, and they're not perfectly overlapping, which is wonderful, right? I mean, that's one of the things. It's like what's really wonderful, and I think it shows the power of why would you have more than one person having input into a decision, is some people are very strong on rating a particular aspect of market, or some people are very strong on rating a particular aspect of the founder. There's overlap and then there's things where Todd is uniquely great at something, or Josh is uniquely great at something, or Bill is uniquely great at something. So that's a wonderful thing about it is that everybody has strengths and everybody has weaknesses and they're not perfectly overlapping. So this is where you can see getting that spread of opinions and really understanding, breaking that decision down into its component parts really shows you the value of diverse opinions as input into a decision.

**中文翻译:**
是的，我不会说。如我们所知，整个合伙团队都非常优秀。我要告诉你的是，所有合伙人都有长处和短处，而且它们并不完全重叠，这太棒了，对吧？这就是为什么需要多个人参与决策的原因：有些人非常擅长评估市场的某个特定方面，有些人非常擅长评估创始人的某个特质。虽然有重叠，但托德在某方面有独特天赋，乔希在另一方面很强，比尔也是。每个人都有优缺点且互补，这正是多元化意见作为决策输入的价值所在——通过将决策分解为各个组成部分，你能看到这种价值。

---

### [01:02:21] Lenny Rachitsky

**English:**
I could talk about this thread forever. Maybe let me just ask one more question just because I'm super curious. Is there anything surprising that stands out, that came out of this analysis so far? Just like, oh wow, maybe market isn't as important as we thought or this person is amazing at-

**中文翻译:**
这个话题我可以聊一辈子。出于好奇，我再问一个问题。到目前为止，这项分析中有没有什么令人惊讶的发现？比如，“哇，也许市场并没有我们想象的那么重要”，或者“某人竟然在某方面如此出色”？

---

### [01:02:34] Annie Duke

**English:**
Yes. So I think just generally speaking, when you're creating the initial decision rubric, there are things that people are really pounding the table about that they think is especially important in making a decision. And one of the things that we found is that sometimes their intuition was absolutely right. The thing that they were pounding the table about is incredibly predictive, not just for them but other partners. But sometimes it's not at all predictive, and these are equal table-pounding situations. So let's say you're pounding the table about something, sometimes the thing you're pounding at the table about is predictive for you and for all the other partners that it's actually quite predictive about how the company does. But sometimes when you're really pounding the table about something, it's not just that it's not predictive for the other partners, it's not predictive for you.

**中文翻译:**
有的。总的来说，当你创建初始决策准则时，人们会拍着桌子强调某些他们认为对决策至关重要的因素。我们发现，有时他们的直觉完全正确，他们强调的因素确实具有极强的预测性，不仅对他们自己，对其他合伙人也是如此。但有时，那些同样被拍着桌子强调的因素，却完全没有预测价值。也就是说，有时你极力坚持的东西对你和大家都有用，但有时，它不仅对别人没用，对你自己也没用。

---

### [01:03:33] Annie Duke (Continued)

**English:**
And I think that what's really important to understand about this, and this is why it's so incredibly necessary in improving decision quality to take what's implicit and make it explicit, is that our intuition is sometimes right and sometimes wrong. It's not that intuition is crap and your intuition is just completely wrong, I mean obviously, that can't be true. We would die, right? So your intuition is sometimes right, but it's also sometimes wrong. And if you don't make it explicit, then you don't get to find out when it's wrong.

**中文翻译:**
理解这一点非常重要，这也是为什么提高决策质量必须将内隐转化为外显的原因：我们的直觉有时是对的，有时是错的。并不是说直觉一文不值或完全错误，显然如果真是那样我们早就没命了。直觉有时是对的，但有时也会出错。如果你不把它明确化，你就永远无法发现它什么时候是错的。

---

### [01:04:07] Annie Duke (Continued)

**English:**
You don't get to find out when it's off base, and that's a disaster. So that's the thing that I think is really interesting is that you have equal vehement and confidence that this particular factor is really important. And sometimes it is and sometimes it isn't. And it's so surprising because we're talking about people who are true experts who are great, and I think that we all just have intuition about intuition, right? You just intuit that if they're so amazing, clearly their intuition about what's important would have to be good, but not necessarily. That's the thing, not necessarily. Yeah, I think that was probably the most exciting thing.

**中文翻译:**
你无法发现它什么时候偏离了轨道，这才是灾难。有趣的是，你对某个因素重要性的坚持和信心可能是一样的，但结果却截然不同。这很令人惊讶，因为我们谈论的是真正的顶级专家。我认为我们对“直觉”本身也有一种直觉：既然他们这么厉害，他们对“什么重要”的直觉肯定也很好。但事实并非必然。这就是最令人兴奋的地方。

---

### [01:04:56] Lenny Rachitsky

**English:**
Keeping it mysterious, but I still appreciate you sharing.

**中文翻译:**
虽然保持了神秘感，但我依然感谢你的分享。

---

### [01:04:59] Annie Duke

**English:**
Well, I have to keep it mysterious.

**中文翻译:**
我必须保持神秘。

---

### [01:05:02] Lenny Rachitsky

**English:**
Yes, I understand.

**中文翻译:**
是的，我理解。

---

### [01:05:03] Annie Duke

**English:**
I can't give away the trade secrets.

**中文翻译:**
我不能泄露商业机密。

---

### [01:05:06] Lenny Rachitsky

**English:**
I wanted to touch on a different framework that I've heard a lot of companies actually using, and something that comes up in product a lot is this idea of pre-mortems, which is essentially think ahead of time what might go wrong. Can you talk about this? Because I think that it's something that's easy to implement, really powerful, and a lot of people are actually doing this.

**中文翻译:**
我想谈谈另一个我听说很多公司都在使用的框架，在产品领域经常出现，那就是“事前剖析”（pre-mortems），本质上就是提前思考可能出现什么问题。你能聊聊这个吗？因为我觉得它很容易实施，非常强大，而且很多人确实在做。

---

### [01:05:25] Annie Duke

**English:**
Yes, okay. So a pre-mortem is great, but only if you attach a pre-commitment with it. So I just want to be super clear about that. What you find with pre-mortems, this actually work. I actually did this work with Maurice Schweitzer and Linnea Gandhi, who are both at Penn. Then when you have people do pre-mortems, it generally doesn't actually change their plan very much or it changed their behavior. So I think that we have the feeling that if you do a pre-mortem and you think what are the ways that things might go wrong, that that's going to change your plan, but probably not unless you're specifically using it for that purpose and you say, "Okay, we're going to do this, but let's think about how we might change our plan in light of this information." But I think what's actually more important than that is what a pre-mortem allows you to do is to set up kill criteria.

**中文翻译:**
好的。事前剖析很棒，但前提是你必须附带一个“预先承诺”（pre-commitment）。我想明确这一点。我和宾夕法尼亚大学的莫里斯·施魏策尔（Maurice Schweitzer）和林内亚·甘地（Linnea Gandhi）做过研究。结果发现，让人们做事前剖析通常并不会显著改变他们的计划或行为。我们往往觉得，只要想到了可能出错的地方，计划就会改变，但事实并非如此，除非你明确以此为目的。但我觉得更重要的是，事前剖析能让你设定“终止准则”（kill criteria）。

---

### [01:06:18] Annie Duke (Continued)

**English:**
So kill criteria are just a set of signals that you might see that would tell you that it's time to pivot or stop because once we actually launch something, we're very, very slow to decide to quit. I'm sure that everybody has felt that way before. Things go on way too long, even like they're over budget and you've blown the timeline. And when you finally shut it down, you realize you should have done it a lot earlier. And this is true across the board because of a variety of biases. The most well-known, and probably the biggest influence is something called sunk cost, which is that feeling, but then I'll have wasted all the time and effort that I've put into this already. So it's taking into account what you've put in in the past and deciding whether to continue on in the future. So what we want to do is actually just get better at that thing. So understanding that when you've gotten to the pre-mortem process, you probably are going to launch it, like it's probably going to be the case.

**中文翻译:**
终止准则就是一系列信号，告诉你什么时候该转型或停止。因为一旦我们启动了某件事，我们就很难决定放弃。我相信每个人都有过这种感觉：事情拖得太久，预算超支，进度落后，当你最终关掉它时，你才意识到早该这么做了。由于各种偏见，这种情况普遍存在。最著名且影响最大的是“沉没成本”（sunk cost），即那种“如果我不继续，我之前投入的时间和精力就白费了”的感觉。这其实是在用过去的投入来决定未来的行动。我们要做的就是改进这一点。要明白，当你进入事前剖析阶段时，你大概率还是会启动项目的。

---

### [01:07:22] Annie Duke (Continued)

**English:**
Use the pre-mortem to set up kill criteria. So I'll give you an example from a sales team that I worked with. Basically, I sent them out a prompt, all the IC is a prompt that was, imagine that you got a lead through an RFP or RFI and you worked on it for six months. And now, it's six months later and the deal is dead. Looking back, you realized they were early signals that that was going to be the case, what were they. So this is a pre-mortem. What are the things that you saw that would tell you that this was going to go south? And they came up with all sorts of ideas. Notice this doesn't mean they're not going to start off pursuing the lead, right? But they saw, they came up with all sorts of signals. So I'll just give you three of them.

**中文翻译:**
利用事前剖析来设定终止准则。我举个我合作过的销售团队的例子。我给所有的个人贡献者（IC）发了一个提示：想象你通过招标书（RFP）获得了一个线索并跟进了六个月，现在交易黄了。回过头看，你意识到其实早就有预警信号了，那些信号是什么？这就是事前剖析。他们想出了各种主意。注意，这并不意味着他们不打算跟进这个线索，但他们识别出了各种信号。我举其中三个例子。

---

### [01:08:12] Annie Duke (Continued)

**English:**
The RFP RFI was clearly written with a competitor in mind, so they felt that was a very bad signal that was probably going to go badly. Another one was the customer didn't want to demo, they only wanted to talk about price. Obviously, that's quite bad. And another one was after the first few meetings, they couldn't get a decision maker in the room, right? So it was a much longer list than this, but those are three. So for each of those, that now becomes a kill criteria if I see this thing and now you attach an action with it. So in the case of price, they actually just said, "We should kill it." If they literally don't want to demo and they're only asking about price, they're just trying to beat up somebody else on price like we're a box-checking exercise. So there, they just said, "We're going to kill it. We're not going to pursue the deal anymore."

**中文翻译:**
第一，招标书显然是为竞争对手量身定制的，这是一个非常糟糕的信号。第二，客户不想看演示（demo），只想谈价格。这显然很糟。第三，前几次会议后，依然见不到决策者。清单很长，但这三点很典型。对于每一项，如果看到了这个信号，它就成了终止准则，并且你要附带一个行动。在“只谈价格”的情况下，他们决定直接放弃。如果对方完全不想看演示，只想压价，那我们只是人家用来压低竞争对手价格的陪跑工具。所以他们决定不再跟进。

---

### [01:08:59] Annie Duke (Continued)

**English:**
So this is great because salespeople will pursue deals forever and leadership is like, "Well, why did you stop pursuing that deal?" And they get in trouble for it. So this is going to help with that problem, right? In the case of the RFP RFI was written with a competitor in mind, they have an action associated with that as well, which is ask them directly if they're working with a competitor and how far down the road they are, depending on the answer you would kill or pursue. In the case of we couldn't get a decision maker in the room, offer up executive alignment at the next meeting. And if they say sure, great. And if they say no, kill.

**中文翻译:**
这太棒了，因为销售人员往往会永远跟进一笔交易，而领导层会问：“你为什么停止跟进？”他们会因此惹上麻烦。这能解决这个问题。在“招标书偏向竞争对手”的情况下，他们的行动是：直接询问对方是否在与竞争对手合作以及进展到哪一步，根据回答决定放弃还是继续。在“见不到决策者”的情况下，行动是：提议下次会议进行高管对接。如果对方同意，太好了；如果拒绝，直接放弃。

---

### [01:09:35] Annie Duke (Continued)

**English:**
So that is actually what I feel is the best use of a pre-mortem is to say, I'm going to try to figure out what those signals are along the way that things are going badly. And now instead of just hoping that when I see those signals, I actually act rationally, which is a hope that it will not come true. That's why there's many people who climb Everest in the middle of a blizzard, even though they shouldn't be doing that. Use the pre-mortem to now create structure around those signals that you've spotted and commit to actions that you're going to take if you see those signals. And I think that's the best use of a pre-mortem.

**中文翻译:**
所以我认为事前剖析的最佳用途是：找出那些预示事情变糟的信号。现在，不要只是寄希望于当你看到这些信号时能理性行动（这种希望通常会落空，就像很多人在暴风雪中依然坚持攀登珠峰一样），而是利用事前剖析为这些信号建立结构，并承诺一旦看到信号就采取行动。我认为这才是事前剖析的精髓。

---

### [01:10:15] Lenny Rachitsky

**English:**
That's really helpful. And it's interesting how many of your examples come back to just of a framework that you often talk about, which is make it explicit what is implicit. There's another example that the First Round example is a great example of that where it's just, here's all our assumptions, they just make them actually explicit and just shows how much [inaudible 01:10:32].

**中文翻译:**
这非常有帮助。有趣的是，你的很多例子最终都回到了你经常谈到的框架：将内隐的东西外显化。First Round 的例子也是如此，把所有的假设都明确地表达出来，这显示了巨大的价值。

---

### [01:10:32] Annie Duke

**English:**
Right, then you can examine them. You can examine them, people can discuss them, you can figure out if they're wrong or right or whatever. It's like, I want to be very clear, I'm not anti your gut or your intuition. I think it's probably sometimes pretty good. I just want you to make it explicit, that's all.

**中文翻译:**
没错，这样你才能审视它们。你可以审视它们，大家可以讨论，你可以判断对错。我想明确一点，我不反对直觉。我认为直觉有时非常准。我只是希望你把它明确化，仅此而已。

---

### [01:10:55] Lenny Rachitsky

**English:**
Okay. So we didn't have time to get into quitting, which is your more recent book. Maybe we'll do a follow-up episode specifically thinking about quitting, but let me just ask-

**中文翻译:**
好的。我们还没时间聊聊“放弃”，那是你最近的一本书。也许我们可以做一期专门关于放弃的后续节目，但让我先问一个问题……

---

### [01:11:03] Annie Duke

**English:**
It's my fault because my answers are long.

**中文翻译:**
是我的错，我的回答太长了。

---

### [01:11:05] Lenny Rachitsky

**English:**
It's my fault.

**中文翻译:**
是我的错。

---

### [01:11:06] Annie Duke

**English:**
I apologize to everybody.

**中文翻译:**
我向大家道歉。

---

### [01:11:06] Lenny Rachitsky

**English:**
No apology is necessary. We'll have plenty of time in the future, hopefully. Well, let me just ask one question. I found this one quote from you where you said you should assume that if you're thinking about quitting, it's already probably past the time that you should have quit. Do you still believe that? Is that generally a good rule of thumb? And just any takeaway, tip, lesson on quitting as our one question on quitting?

**中文翻译:**
不需要道歉。希望我们以后有充足的时间。让我只问一个问题。我读到过你的一句话，你说：如果你正在考虑放弃，那么通常已经过了你应该放弃的最佳时机。你现在还相信这一点吗？这是否是一个通用的经验法则？关于放弃，你能给出一个核心建议或教训吗？

---

### [01:11:29] Annie Duke

**English:**
So the data is pretty strong that by the time you quit, it's probably long after the [最佳时机]. And it's really just because, look, when we start things, we're starting things under difficult circumstances, which come from the uncertainty of the decision to start something. So when we start something, luck is going to have an influence on the outcome, which obviously, we have no control over because luck isn't in our control. And then there's also hidden information. So what happens is that after the fact, we know that we're going to learn new information and it can make it very hard to start things because we want to be more sure than we actually need to be. It's why Bezos has the 70% role to try to roll people back and be willing to accept that uncertainty in the starting decision. Now the good news is that when you learn that new stuff and the new stuff that you learn is, "Ooh, if I had known this, I wouldn't have started it", you have the option to quit generally.

**中文翻译:**
数据非常有说服力：当你最终决定放弃时，通常已经远远超过了最佳时机。这是因为，当我们开始做某事时，是在不确定的情况下开始的。运气会影响结果，而我们无法控制运气。此外还有隐藏信息。事实是，事后我们总会学到新信息。这让开始变得很难，因为我们总想比实际需要的更确定。这就是为什么贝佐斯有“70% 规则”，鼓励人们在只有 70% 信息时就做决定，接受不确定性。好消息是，当你学到新东西并意识到“如果我早知道这个，我就不会开始了”时，你通常可以选择放弃。

---

### [01:12:28] Annie Duke (Continued)

**English:**
So that's the good news. The bad news is that the same difficulties that apply to the decision to start apply to the decision to stop. In other words, we're making that decision under uncertainty as well. So we're not going to know for sure whether it would've turned out well or poorly unless we continue to do the thing that we already started. And we don't like to walk away from things unless we know for sure. So as Richard Thaler put it, most people won't quit until it actually isn't a decision. In other words, the whole thing is blown up, the startup has no money, or you're up on Everest and the blizzard is literally upon you and you're stuck in it. Or I think as he said, until you've fallen in the crevasse already, then you'll make the decision to quit because then you know how it was really bad. So people generally, for example, don't quit their jobs until they feel they have no other choice or relationships or projects or products that they're developing, it all applies because we want to know for sure.

**中文翻译:**
但坏消息是，开始时的困难同样适用于停止。换句话说，我们也是在不确定的情况下做停止的决定。除非我们继续做下去，否则我们永远无法确切知道结果会是好是坏。而除非我们确切知道，否则我们不喜欢离开。正如理查德·塞勒（Richard Thaler）所说，大多数人直到“不再是一个选择”时才会放弃。换句话说，事情已经彻底搞砸了，创业公司没钱了，或者你在珠峰上被暴风雪困住了。或者像他说的，直到你掉进冰裂缝里，你才会决定放弃，因为那时你确切知道情况有多糟。人们通常直到别无选择时才会辞职、结束关系或停止项目，因为我们想“确切知道”。

---

### [01:13:35] Annie Duke (Continued)

**English:**
And then on top of that is the fact that there is this issue of sunk cost, which is when we walk away, we feel like we'll have wasted everything that we've already put into what we're doing. But of course, waste is a prospective problem, not a retrospective one, even if we treat it like a retrospective one because it's the prospective one. Well, if you wouldn't start this today, then that means that everything that you're putting into this going forward is the actual waste, right? But we do that all the time. We go forward with things that we ought not to be going forward with because we're trying to protect the resources that we've already sunk into it in the past. Then there's other issues that have to do with, for example, endowment, the ownership over the things that we've built. This is particularly bad in product because we're building things.

**中文翻译:**
除此之外，还有沉没成本的问题：当我们离开时，我们觉得浪费了之前投入的一切。但事实上，“浪费”是一个前瞻性的问题，而不是回顾性的。如果你今天不会重新开始这件事，那么你未来投入的一切才是真正的浪费，对吧？但我们总是为了保护过去的投入而继续做不该做的事。此外还有“禀赋效应”（endowment），即对自己建立的东西的所有权感。这在产品领域尤为严重，因为我们在亲手构建东西。

---

### [01:14:18] Annie Duke (Continued)

**English:**
And once we build things, we own them. And once we own them, we don't want to give them up and we actually value them more highly than identical things that we don't own. And then there's issues of internal and external validity, which is really just a fancy way to say your identity. How do other people view you? How do you view yourself? Do you feel like you failed? And what that means is that by the time, there's so many biases against stopping that by the time you're actually even thinking about quitting, it's probably already past the time that you ought to have quit. But we'll still continue on until we know for sure we didn't have any choice because here's the thing. When you walk away from something and someone's like, "Hey, why'd you stop that?" And you're like, "Oh, I had no choice" and you tell them everything that went wrong and, nobody's going to question you.

**中文翻译:**
一旦我们建立了某样东西，我们就拥有了它。一旦拥有，我们就不想放弃，而且我们会比别人更看重它。还有内外效度的问题，其实就是你的“身份认同”。别人怎么看你？你怎么看自己？你觉得自己失败了吗？这意味着，由于存在这么多反对停止的偏见，当你开始考虑放弃时，通常已经过了该放弃的时候。但我们仍会继续，直到确信别无选择。因为当你离开并说“我别无选择”并列举所有出错的地方时，没人会质疑你。

---

### [01:15:04] Annie Duke (Continued)

**English:**
They're going to be like, "Oh, well, it sounds like you put in your best effort." But if you walk away early, people are like, "What?" So just quickly, I'll tell you I think just one of the best stories of this that I've got in my pocket here. Let me pull it out before the end. So Stewart Butterfield creating a product called Glitch, and Glitch is a massive multiplayer online world-building cooperative game. Releases it, this is in the aughts, and it's like a huge hit with the critics. It's Monty Python meets Dr. Seuss, it's an incredible whatever. They're getting tons and tons of great word of mouth and PR not doing any paid marketing. They have incredible investors in Andreessen Horowitz and Accel, they have $6 million in the bank and they 5,000 have diehard users, meaning users who use the game who play over 20 hours a week.

**中文翻译:**
他们会说：“噢，看来你已经尽力了。”但如果你早点离开，人们会说：“什么？”我快速讲一个我最喜欢的故事。斯图尔特·巴特菲尔德（Stewart Butterfield）曾开发过一款名为 Glitch 的大型多人在线协作游戏。那是 2000 年代，评论界反响极好，被形容为“蒙提·派森遇见苏斯博士”。他们没有做任何付费营销，却获得了极好的口碑和公关。他们的投资者包括 A16Z 和 Accel，银行里有 600 万美元，还有 5000 名每周玩超过 20 小时的死忠用户。

---

### [01:16:04] Annie Duke (Continued)

**English:**
The issue is that customer acquisition was a beast that for every one person who was playing over 20 hours a week, there were between 95 and 99 people who came for five minutes and left. So obviously, this is a customer acquisition problem, which everybody knows. So they make an agreement in 2012 that they're going to do paid marketing, which they do for six weeks. And during that six weeks, their acquisition of new users, it's growing like six to 7% week over week, which is amazing. And at the end of that six weeks, this is November of 2012, at the end of that six weeks, that Monday morning, Stewart Butterfield writes a note to his investors and co-founders and says, "I woke up this morning with the dead certainty that Glitch was over."

**中文翻译:**
问题在于客户获取成本极高：每增加一个每周玩 20 小时的用户，就有 95 到 99 个人只玩了 5 分钟就走了。显然这是获客问题。2012 年，他们决定尝试付费营销，持续了六周。在那六周里，新用户每周增长 6% 到 7%，非常惊人。但在那六周结束后的 2012 年 11 月的一个周一早上，斯图尔特给投资者和联合创始人写了一封信：“今天早上醒来，我百分之百确定 Glitch 完蛋了。”

---

### [01:16:58] Annie Duke (Continued)

**English:**
Now notice nobody would do this in this case, right? But this is what happened is that the issue is that you really have to see is this worthwhile or not? Would I start this today? That's a forecast of the future, right? And what he did was some back-of-the-envelope math, and he said, "Look, if we continue to acquire customers at the weight that we've been acquiring them at the cost that we've been acquiring them, it's going to be 31 weeks until we break even." But that's an absurd assumption because customer acquisition costs, it's going to go up. Cap has to rise because we're going to saturate the core gaming market, so it's got to rise. So what he realized at that point was that this was not a venture scale business, and he was in this for a venture scale business. So even though nobody else saw that he was supposed to shut it down, he saw he was supposed to shut it down.

**中文翻译:**
注意，在这种情况下没人会这么做，对吧？但事实就是，你必须看清这是否值得。如果今天重新开始，我会做吗？这是对未来的预测。他做了一些简单的计算，发现：“如果我们按现在的速度和成本获客，需要 31 周才能盈亏平衡。”但这是一个荒谬的假设，因为获客成本（CAC）必然会上升，因为核心游戏市场会饱和。他意识到这不是一个具有风险投资规模（venture scale）潜力的业务，而他追求的是这种规模。所以，尽管别人没觉得该关掉，他却看清了。

---

### [01:17:45] Annie Duke (Continued)

**English:**
And not only that, he saw that he was supposed to shut it down for his employees who were working for equity, and he had now realized that the equity wasn't worth their time and that it wasn't fair to them to keep going with it. So he shuts it down. Obviously, that feels... Who does that? Right? And he will actually tell you that he knows he should have shut it down before the marketing push, but he needed the marketing push to prove it to himself that he was seeing the future clearly. Now, the code to this story just quickly is two days later, he's like, "Well, I'm a startup guy. I want to start something", and he's got this internal communication tool that his team is using in order to develop this product that everybody loves. And he says, "Actually, they really like that. Maybe that should be the next product."

**中文翻译:**
不仅如此，他还意识到为了那些拿股权工作的员工，他也该关掉它。因为他意识到这些股权不值得员工投入时间，继续下去对他们不公平。所以他关掉了它。显然，这让人觉得……谁会这么干？他后来坦言，他知道在营销推广之前就该关掉，但他需要那次推广来向自己证明他对未来的判断是正确的。故事的后续是：两天后，他说：“我是个创业者，我想做点新东西。”他发现团队在开发 Glitch 时使用的一个内部沟通工具非常受欢迎。他说：“也许这才是下一个产品。”

---

### [01:18:29] Annie Duke (Continued)

**English:**
So he goes and talks to the investors, they roll their money over into that. And that thing, which had no name at the time, now gets a name which is searchable log of all company knowledge, which is Slack. And so I think this is the important thing to realize is that we get so focused on, "But what about everything that I've put into it?" When what we forget is that when you're doing something, there's not just the cost of doing something that's not worthwhile that's direct, but there's also the cost of not being able to devote your attention to other opportunities that might be available to you. And as smart as Stewart Butterfield is, he couldn't see Slack until he quit Glitch. And that is a true cost that he would've born of continuing with Glitch. If he had continued with Glitch, Slack would not be something that we're all using today.

**中文翻译:**
于是他去找投资者，投资者把钱转投到了那个新项目。那个当时还没有名字的东西，后来有了一个名字：Slack（Searchable Log of All Company Knowledge 的缩写）。我认为最重要的一点是：我们太关注“我已经投入了什么”，却忘记了当你做一件不值得的事情时，不仅有直接成本，还有“机会成本”——你无法关注其他机会。像斯图尔特这么聪明的人，在放弃 Glitch 之前也看不到 Slack。如果他继续做 Glitch，Slack 就不会诞生。

---

### [01:19:21] Lenny Rachitsky

**English:**
That is an incredibly beautiful way to end our conversation. I feel like I have at least a billion more questions to ask you and on the other hand, I feel like we've also helped a lot of people make much better decisions through this chat so I'm really thankful that you made time for this. Two last questions. Where can folks find you online if they want to learn about the stuff you're up to in case they want to work with you? And how can listeners be useful to you?

**中文翻译:**
这是一个非常完美的结尾。我觉得我还有无数个问题想问你，但另一方面，我也觉得这次对话已经帮助很多人做出了更好的决策。非常感谢你抽出时间。最后两个问题：如果听众想了解你的动态或与你合作，在哪里可以找到你？以及，听众可以为你做些什么？

---

### [01:19:43] Annie Duke

**English:**
You can find me at annieduke.com if you're interested in working with me. I have a Substack, Thinking in Bets. Please go check that out. I teach a class on maven.com twice a year on effective decision-making. So if you're interested in that, you can go to Maven and check it out. My next cohort at the moment is in September, although I might do one in May. I'm not sure. But in terms of people can help me, I co-founded an organization called The Alliance for Decision Education. We're trying to bring the kinds of knowledge that we have about improving human decision-making in adults to K through 12 education to make the world a better place. So I would love it if people could go look at that. If you're interested in it, get the word out.

**中文翻译:**
如果你有合作意向，可以在 annieduke.com 找到我。我有一个 Substack 专栏叫 Thinking in Bets，欢迎订阅。我每年在 maven.com 上教两次关于有效决策的课程。下一期目前定在九月，也许五月也会有一期。至于大家如何帮我，我共同创立了一个名为“决策教育联盟”（The Alliance for Decision Education）的组织。我们正努力将改善成人决策的知识引入 K-12 教育，让世界变得更好。如果大家能关注一下并帮忙宣传，我会非常感激。

---

### [01:20:26] Lenny Rachitsky

**English:**
Amazing. So we'll link to all those things in the show notes. Annie, again, thank you so much for being here.

**中文翻译:**
太棒了。我们会把这些链接都放在节目介绍里。安妮，再次感谢你的到来。

---

### [01:20:32] Annie Duke

**English:**
Thank you. Thank you so much, this was so fun.

**中文翻译:**
谢谢。非常感谢，这次聊天非常愉快。

---

### [01:20:35] Lenny Rachitsky

**English:**
Same. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
我也是。大家再见。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本节目。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目再见。