# Annie Pearl - 双语对照

# Lenny's Podcast: Annie Pearl (CPO at Calendly) - Full Bilingual Transcript

---

### (00:00:00) Annie Pearl

**English:**
Strategy is really just an integrated set of choices that outline how you're going to win in whatever marketplace you choose. And so, a good product strategy is going to answer questions like what's your winning aspiration? But maybe more importantly, where are you going to play? What are the markets you're going to go after? What are the segments of those markets? What are the personas in the segments of those markets? And then, how are you going to win with a target audience?

**中文翻译:**
策略实际上就是一套整合的选择，概述了你打算如何在所选的任何市场中获胜。因此，一个好的产品策略需要回答诸如“你的获胜愿景是什么？”之类的问题。但可能更重要的是，“你打算在哪里竞争？”你要进军哪些市场？这些市场的细分领域是什么？这些细分领域中的用户画像（Personas）又是怎样的？最后，你打算如何赢得目标受众的青睐？

---

### (00:00:27) Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today, my guest is Annie Pearl. Annie is currently chief product officer at Calendly. Before that, she was chief product officer at Glassdoor. And before that, she was director of product management at Box. She's also a member of Skip, a community for chief product officers, and she's on the board of two different companies.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在打造和增长当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Annie Pearl。Annie 目前担任 Calendly 的首席产品官（CPO）。在此之前，她是 Glassdoor 的首席产品官，更早之前，她是 Box 的产品管理总监。她还是 Skip（一个首席产品官社区）的成员，并担任两家不同公司的董事。

---

### (00:00:54) Lenny

**English:**
In our conversation, we cover a lot of ground, including how Calendly builds product, how Calendly has grown, including the wild story of how they got their first 1,000 users, and also how they built a sales team on top of what historically has been a very product-led growth company. Annie also shares a ton of great advice on how to get into product management. I learned a ton from Annie and I know you'll too. Annie also shares a few killer tips for using Calendly, which I loved. And so, with all that, I bring you Annie Pearl through a short word from our wonderful sponsors.

**中文翻译:**
在我们的对话中，我们涵盖了广泛的话题，包括 Calendly 如何打造产品、Calendly 是如何增长的（包括他们获得前 1000 名用户的离奇故事），以及他们如何在这家历来以产品驱动增长（PLG）为主的公司基础上建立销售团队。Annie 还分享了大量关于如何进入产品管理领域的宝贵建议。我从 Annie 身上学到了很多，我相信你们也会。Annie 还分享了几个使用 Calendly 的绝佳技巧，我非常喜欢。在开始之前，先听一段我们优秀赞助商的简短广告，随后为您带来 Annie Pearl 的访谈。

---

### (00:01:25) Lenny (Sponsor: Miro)

**English:**
Today's episode is brought to you by Miro, an online collaborative whiteboard that's designed specifically for teams like yours. I have a quick request. Head on over to my Miro board at miro.com/lenny and let me know which guests you'd want me to have on this year. I've already gotten a bunch of great suggestions, which you'll see when you go there, so just keep it coming. And while you're on the Miro board, I encourage you to play around with the tool. It's a great shared space to capture ideas, get feedback, and collaborate with your colleagues on anything that you're working on.

**中文翻译:**
本期节目由 Miro 赞助播出。Miro 是一款专为像你们这样的团队设计的在线协作白板。我有一个小请求：请访问我的 Miro 画板 miro.com/lenny，告诉我你希望我今年邀请哪些嘉宾。我已经收到了很多很棒的建议，你访问时就能看到，请继续向我投递。当你使用 Miro 画板时，我鼓励你尝试一下这个工具。它是一个绝佳的共享空间，可以捕捉灵感、获取反馈，并与同事就任何工作项目进行协作。

---

### (00:01:56) Lenny (Sponsor: Miro)

**English:**
For example, with Miro, you can plan out next quarter's entire product strategy. You can start by brainstorming, using sticky notes, live reactions, a voting tool, even an estimation app to scope out your team's sprints. Then your whole distributed team can come together around wire frames, drive ideas with a pen tool, and then put full mocks right into the Miro board. And with one of Miro's readymade templates, you can go from discovery and research to product roadmaps to customer journey flows to final mocks, all in Miro. Head on over to miro.com/lenny to leave your suggestions. That's M-I-R-O.com/lenny.

**中文翻译:**
例如，利用 Miro，你可以规划下个季度的整个产品策略。你可以从头脑风暴开始，使用便签、实时互动表情、投票工具，甚至是用估算应用来确定团队冲刺（Sprints）的范围。然后，你的整个分布式团队可以围绕线框图（Wireframes）聚集在一起，用画笔工具激发灵感，并将完整的原型图（Mocks）直接放入 Miro 画板。借助 Miro 的现成模板，你可以完成从探索研究到产品路线图、客户旅程图再到最终原型的全过程。请访问 miro.com/lenny 留下你的建议。网址是 M-I-R-O.com/lenny。

---

### (00:02:32) Lenny (Sponsor: Coda)

**English:**
This episode is brought to you by Coda. You've heard me talk about how Coda is the dock that brings it all together and how can I help your team run smoother and be more efficient. I know this firsthand because Coda does that for me. I use Coda every day to wrangle my newsletter content calendar, my interview notes for podcasts, and to coordinate my sponsors. More recently, I actually wrote a whole post on how Coda's product team operates. And within that post, they shared a dozen templates that they use internally to run their product team, including managing the roadmap, their OKR process, getting internal feedback, and essentially their whole product development process is done within Koda.

**中文翻译:**
本期节目由 Coda 赞助。你听我多次提到过 Coda 是如何将一切整合在一起的文档工具，以及它如何帮助你的团队运行得更顺畅、更高效。我有切身体会，因为 Coda 确实帮到了我。我每天都用 Coda 来管理我的时事通讯内容日历、播客采访笔记以及协调赞助商。最近，我还专门写了一篇文章介绍 Coda 的产品团队是如何运作的。在那篇文章中，他们分享了十几个内部用于管理产品团队的模板，包括路线图管理、OKR 流程、获取内部反馈，基本上他们整个产品开发流程都是在 Coda 中完成的。

---

### (00:03:10) Lenny (Sponsor: Coda)

**English:**
If your team's work is spread out across different documents and spreadsheets and a stack of workflow tools, that's why you need Koda. Koda puts data in one centralized location regardless of format, eliminating roadblocks that can slow your team down. Koda allows your team to operate on the same information and collaborate in one place. Take advantage of the special limited time offer just for startups. Sign up today at koda.io/lenny and get $1,000 start credit on your first statement. That's C-O-D-A.io/lenny, the signup and get a startup credit of $1,000, koda.io/lenny.

**中文翻译:**
如果你的团队工作分散在不同的文档、电子表格和一堆工作流工具中，那么你正需要 Coda。Coda 将数据集中在一个地方，无论格式如何，消除了可能拖慢团队进度的障碍。Coda 让你的团队基于相同的信息在同一个地方协作。现在有针对初创公司的限时特别优惠：立即在 koda.io/lenny 注册，首张账单即可获得 1000 美元的启动抵扣额度。网址是 C-O-D-A.io/lenny，注册并获取 1000 美元的初创公司抵扣额度。

---

### (00:03:50) Lenny

**English:**
Annie, welcome to the podcast.

**中文翻译:**
Annie，欢迎来到播客。

---

### (00:03:53) Annie Pearl

**English:**
Thanks for having me, Lenny. Super excited to be here.

**中文翻译:**
谢谢邀请我，Lenny。非常高兴能来到这里。

---

### (00:03:55) Lenny

**English:**
I've been a big fan of yours from afar. We've crossed paths a little bit on Reforge, on Twitter, probably been at events that maybe we didn't know each other at yet. So, I'm really excited to finally be chatting, real life, in real time, at least.

**中文翻译:**
我一直是你的忠实粉丝。我们在 Reforge 和 Twitter 上有过一些交集，可能还参加过一些当时互不相识的活动。所以，我非常激动终于能进行这次实时的、现实生活中的对话。

---

### (00:04:09) Annie Pearl

**English:**
Me as well.

**中文翻译:**
我也是。

---

### (00:04:09) Lenny

**English:**
I've got a Calendly question to kick things off. It feels like with Calendly one of the most awkward elements of it is I have to put the burden on someone else to book at Calendly. So, I'm sending a link and I haven't figured out a good way to send it to someone without it coming across like a power move. So, my question to you is how do I send a Calendly to someone without it feeling bad?

**中文翻译:**
我想用一个关于 Calendly 的问题来开始。感觉使用 Calendly 最尴尬的一点是，我必须把预约时间的负担推给别人。我发一个链接过去，但我还没找到一种既能发链接又不会显得像是在“耍威风”（Power move）的好方法。所以我的问题是，如何发送 Calendly 链接给别人而不会让他们感觉不舒服？

---

### (00:04:31) Annie Pearl

**English:**
All right, well I love this question to kick us off. We actually have a whole blog post about this if you're curious to learn more.

**中文翻译:**
好的，我很喜欢用这个问题开场。如果你感兴趣的话，我们其实专门写过一篇博客文章来讨论这个问题。

---

### (00:04:31) Lenny

**English:**
Oh, okay.

**中文翻译:**
噢，好的。

---

### (00:04:37) Annie Pearl

**English:**
But I think that at a high level, I think I recommend first really just kind of opening the door for the person you're trying to schedule time with to share their availability first. So instead of just sending the link, I usually start the email with something like looking forward to connecting, feel free to share, sometimes you're available or if easier, you can choose to find time on my calendar using the Calendly link here. So, opening the door to let them choose before you offer up your Calendly link, I think is a little bit of a subtle way to let them take the lead if they want.

**中文翻译:**
但从宏观层面来看，我的建议是，首先要为对方“开个门”，让他们先分享他们的空闲时间。所以，不要直接发链接，我通常会在邮件开头写类似这样的话：“很期待与您联系，请随时分享您的空闲时间；或者如果更方便的话，您也可以通过这个 Calendly 链接在我的日历上选个时间。”在提供链接之前先给对方选择的余地，我认为这是一种微妙的方式，让他们在愿意的情况下掌握主动权。

---

### (00:05:08) Annie Pearl

**English:**
And the second piece I would recommend too is once you opened that door, you can further reduce the effort on the recipient by adding times you're available directly in the email. So, when you go to share a Calendly link, there's an option to add times to email and you can then just paste those directly into the email you're creating, so that reduces yet another sort of point of friction to ask the user to click the link and get taken to Calendly. So, opening the door and then adding times to email are two things that I do to really make sure that it's not awkward and it doesn't put the burden on the other person.

**中文翻译:**
我推荐的第二点是，一旦你开了那个门，你可以通过直接在邮件中添加你的空闲时间来进一步减轻接收者的负担。当你分享 Calendly 链接时，有一个“添加到邮件”（Add times to email）的选项，你可以直接把这些时间段粘贴到你正在写的邮件里。这样就减少了另一个摩擦点，即不需要用户点击链接跳转到 Calendly 页面。所以，“先开门”和“直接在邮件中添加时间”是我常用的两种方法，能确保不尴尬且不把负担推给对方。

---

### (00:05:39) Lenny

**English:**
That is awesome advice. That first one is what I ended up doing actually. That's really interesting where you don't send the link immediately. You first just ask, "Hey, send me your Calendly." And actually, I always say, "Send me your Calendly." I assume that's what they're using. That's kind of funny.

**中文翻译:**
这建议太棒了。第一种方法其实就是我最后采取的做法。不立即发送链接这一点很有趣。你先问：“嘿，把你的 Calendly 发给我。”事实上，我总是说“发你的 Calendly 给我”，我默认大家都在用这个。这挺有意思的。

---

### (00:05:53) Annie Pearl

**English:**
Right.

**中文翻译:**
没错。

---

### (00:05:53) Lenny

**English:**
I don't even know what else is out there.

**中文翻译:**
我甚至都不知道还有什么别的同类工具。

---

### (00:05:54) Annie Pearl

**English:**
That's good. That's what we like to hear.

**中文翻译:**
那太好了，这正是我们想听到的。

---

### (00:05:56) Lenny

**English:**
Yeah, absolutely. It's like its own word now. Okay, that was awesome. So, there's this already actionable advice for anyone listening.

**中文翻译:**
是的，绝对的。它现在已经成了一个专有名词了。太棒了，听众们现在就已经得到了可操作的建议。

---

### (00:06:03) Annie Pearl

**English:**
Sweet.

**中文翻译:**
太棒了。

---

### (00:06:04) Lenny

**English:**
Transitioning a little bit to product, the main focus of chat, you transitioned into product from being a lawyer. You told me at one point that a lot of people ask you for advice about how to transition into product from other functions, especially non-technical functions as someone without a technical background. So, what advice do you give people when they ask you how to transition into a product role?

**中文翻译:**
稍微转向我们聊天的核心——产品。你是从律师转行做产品的。你曾告诉我，很多人向你咨询如何从其他职能部门（尤其是非技术职能部门）转行做产品，特别是对于没有技术背景的人。那么，当人们问你如何转行到产品岗位时，你会给他们什么建议？

---

### (00:07:07) Annie Pearl

**English:**
I got what I'll call lucky, which is I kind of stumbled into product management after law school, joined the founding team of a startup and ended up doing product management there. But when I think about folks who are looking to get in their product management, I think there's really two paths. I think one is more formal in nature. There are associate product manager programs out there and many scaled companies, Google, Meta. All have APM programs that you can formally apply to. And actually, when we were at Box, much earlier stage company than either of those companies I just mentioned, we actually created an APM program to help grow our bench of more junior PM. So, I think you can actually find APM programs even at smaller, earlier stage companies than even kind of big tech. So that's one, it's just formal APM programs.

**中文翻译:**
我算是比较“幸运”的，法学院毕业后误打误撞进入了产品管理领域，加入了一家初创公司的创始团队，并在那里开始做产品。但当我思考那些想要进入产品管理领域的人时，我认为主要有两条路径。第一条是比较正式的路径。市面上有很多“助理产品经理”（APM）项目，许多规模化的公司如 Google、Meta 都有可以正式申请的 APM 项目。实际上，我们在 Box 时（当时比我刚才提到的那些公司规模小得多），我们也创建了一个 APM 项目来培养初级 PM 储备。所以，即使在比大厂规模更小、阶段更早的公司，你也能找到 APM 项目。这是第一种：正式的 APM 项目。

---

### (00:07:38) Annie Pearl

**English:**
I think another "more formal" way to get into PM is really by just directly applying to a junior PM role where there's no expectation of any sort of experience. I've usually seen this work best when you're already working somewhere in some product adjacency. Maybe you're in customer support, implementation, or maybe you're a sales engineer. But you can look at the internal job board and find junior PM roles that are posted and that's one way to make the move. So that's kind of on the formal side like APM programs and just applying via internal job boards.

**中文翻译:**
我认为另一种“较正式”的进入方式是直接申请那些对经验没有要求的初级 PM 职位。我发现这种方式在一种情况下效果最好：你已经在某家公司的产品相关部门工作了。比如你在客户支持、交付实施，或者你是销售工程师。你可以查看内部招聘板，寻找发布的初级 PM 职位，这是转行的一种方式。所以，正式路径包括 APM 项目和通过内部招聘板申请。

---

### (00:07:38) Annie Pearl

**English:**
I think on the informal side, really two suggestions here. The first one is to seek out opportunities to shadow or partner closely with a product manager and maybe even offer to take on some work. So, some of the best PMs that I've brought over to product from other functions, they really start by expressing interest in product and then start partnering closely with the product manager and maybe even doing a little bit of product work before they make that transition.

**中文翻译:**
在非正式路径方面，我有两个建议。第一个是寻找机会去“影子学习”（Shadow）或与产品经理紧密合作，甚至主动提出承担一些工作。我从其他职能部门招募到产品团队的一些最优秀的 PM，最初都是通过表达对产品的兴趣，然后开始与 PM 紧密配合，甚至在正式转岗前就已经做了一些产品工作。

---

### (00:08:02) Annie Pearl

**English:**
And one tactical suggestion is there's oftentimes companies will have subject matter expert programs where they want to pair someone from a go-to-market function with a certain product squad or a certain product area. And so that's becoming a SME. It allows you to really get more involved and embedded into the product team. So, that's one suggestion. And then maybe last one is just the path I did, which is joining an early stage startup. There's really usually an expectation that everyone's going to get their hands dirty doing a lot of different things. And so, I think that's one way where you might have an opportunity to try product management if you end up joining an early stage company.

**中文翻译:**
一个战术性的建议是：公司通常会有“领域专家”（SME）计划，他们希望将来自市场端（Go-to-market）的人员与特定的产品小组或领域配对。成为 SME 可以让你更深入地参与并嵌入到产品团队中。这是另一个建议。最后一个就是我走过的路：加入一家早期初创公司。在那种环境下，通常期望每个人都能亲力亲为处理各种事情。所以，如果你加入早期公司，你可能有机会尝试产品管理。

---

### (00:08:38) Lenny

**English:**
So, maybe it was four, maybe it was more paths that you described. Join APM program. What was the second one again?

**中文翻译:**
所以，你描述的大概有四条或更多的路径。第一，加入 APM 项目。第二个是什么来着？

---

### (00:08:45) Annie Pearl

**English:**
Internal job board apply, when you're in the company.

**中文翻译:**
当你已经在公司内部时，通过内部招聘板申请。

---

### (00:08:48) Lenny

**English:**
As just like a junior PM. Two is, find someone that mentors you and helps you start doing the role. And is that internal? Is that the internal transfer app?

**中文翻译:**
就是作为初级 PM 申请。第三个是，找一个能指导你并帮你开始履行该职责的人。那是内部的吗？是内部转岗申请吗？

---

### (00:08:58) Annie Pearl

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### (00:08:58) Lenny

**English:**
Cool.

**中文翻译:**
酷。

---

### (00:08:59) Annie Pearl

**English:**
And then, another flavor of that is sometimes companies will have these SME programs.

**中文翻译:**
然后，另一种形式就是我提到的，有时公司会有这些 SME（领域专家）计划。

---

### (00:09:03) Lenny

**English:**
What is a SME program?

**中文翻译:**
什么是 SME 计划？

---

### (00:09:05) Annie Pearl

**English:**
Subject matter expert. So, you'll say, "Hey, I want to make sure we have subject matter expert in our CS team on this area of the product." And they'll partner really closely with the product manager and designer within that area.

**中文翻译:**
Subject Matter Expert（领域专家）。比如你会说：“嘿，我想确保我们的客户成功（CS）团队中有人是这个产品领域的专家。”然后他们会与该领域的产品经理和设计师紧密合作。

---

### (00:09:16) Lenny

**English:**
Got it. And then the fourth bucket is, join a startup, start doing PM work and then you end up being a PM.

**中文翻译:**
明白了。第四类是加入初创公司，开始做 PM 的工作，最后顺理成章成为 PM。

---

### (00:09:21) Annie Pearl

**English:**
You got it.

**中文翻译:**
完全正确。

---

### (00:09:21) Lenny

**English:**
Which of those four do you find most common? And would you push people in one direction or another?

**中文翻译:**
这四种路径中，你觉得哪种最常见？你会倾向于推荐人们走哪条路？

---

### (00:09:26) Annie Pearl

**English:**
Yeah, I've brought a lot of folks over internally for the path of someone's really interested in product, they express they're interested, they want to help, they want to learn, they're eager, they're curious. And so, they make that really well known and they're even willing to do some work on the side to help out and really show and demonstrate the skills before they have the job. So, I've seen that one to actually probably bring the most folks over in my role in terms of being on the product leadership side.

**中文翻译:**
是的，我通过内部转岗带过很多人。通常是某人对产品非常感兴趣，他们表达了这种兴趣，想帮忙、想学习，表现得很渴望且充满好奇心。他们让这种意愿众所周知，甚至愿意在业余时间做一些工作来帮忙，在正式获得职位前就展示出相关的技能。作为产品领导层，我发现这种方式实际上是带入新人最多的一种。

---

### (00:09:53) Lenny

**English:**
On the APM program route, are there any APM programs you recommend? Because I'm sure people hear this and they're like, "Yeah, but I don't know where to apply. I don't know which ones are good." I don't know if you have a list, but just what comes to mind as APM programs to go pursue?

**中文翻译:**
关于 APM 项目这条路，你有什么推荐的项目吗？因为我肯定听众听到这会想：“是啊，但我不知道去哪申请，不知道哪些好。”我不知道你手头有没有清单，但你脑海中首先浮现的值得追求的 APM 项目有哪些？

---

### (00:10:05) Annie Pearl

**English:**
The folks who started it all was Google, with the Google APM program. And Meta obviously has a pretty strong robust APM program. But as I mentioned around Box, I think those are obviously very, very competitive and most people want to get into them. It may be better to try and find a company like Box or a company that's a bit earlier stage, not as scaled to think about looking at those APM programs. And I'm sure if you want to, go to glassdoor.com where I used to work at Glassdoor, so had to throw that in there. You could search for associate product manager and I think you'll find a whole host of open roles that you might be able to apply to.

**中文翻译:**
开创先河的是 Google 的 APM 项目。Meta 显然也有一个非常强大且成熟的 APM 项目。但正如我提到 Box 时说的，大厂的项目竞争极其激烈，每个人都想进。尝试寻找像 Box 这样规模稍小、阶段稍早、还没那么庞大的公司去看看他们的 APM 项目可能会更好。当然，如果你愿意，可以去 glassdoor.com（我以前在那工作，所以必须提一下）。你可以搜索“Associate Product Manager”，我相信你会发现一大堆可以申请的开放职位。

---

### (00:10:39) Lenny

**English:**
That is a cool tip. I haven't heard of that. Go to Glassdoor and search for APM. So, you search for companies that have an APM title.

**中文翻译:**
这个建议很酷，我以前没听过。去 Glassdoor 搜 APM，也就是搜索那些设有 APM 职位的公司。

---

### (00:10:45) Annie Pearl

**English:**
Yes. You could just use associate product manager and you'll see all the open jobs out there and then go apply to them.

**中文翻译:**
是的。你只需搜索“Associate Product Manager”，就能看到所有公开的职位，然后去申请。

---

### (00:10:50) Lenny

**English:**
That's cool. Okay, good tip. What I find, and you mentioned this the best, if you have the option is internal transfer. If you're just like another function, you find someone that can help you move into the role.

**中文翻译:**
太酷了，好建议。我发现（你也提到了）最好的选择其实是内部转岗。如果你在另一个职能部门，找一个能帮你转岗的人。

---

### (00:11:01) Annie Pearl

**English:**
You have the relationships, you can show your work really well. The other thing I would say is when I think about folks who have successfully transferred over, I think they tend to have a couple of characteristics. They're usually very curious, they tend to be really passionate about the product and solving customer problems. And sometimes, they've even tinkered with a side project as a way to hone their PM skills. So, I think as you're thinking about making that transition, those types of characteristics really showing eagerness and interest in the product itself and solving customer problems are also great ways to get noticed and increase your chances.

**中文翻译:**
你有现成的人际关系，可以很好地展示你的工作成果。另一件我想说的是，当我回想那些成功转岗的人时，他们往往具备几个共同特征：通常非常好奇，对产品和解决客户问题充满热情。有时，他们甚至会捣鼓一些副业项目来磨练 PM 技能。所以，当你考虑转型时，展现出对产品本身和解决客户问题的渴望与兴趣，是获得关注并增加成功机会的绝佳方式。

---

### (00:11:36) Lenny

**English:**
Why do you think it is that not more companies have an APM program? It feels like such a win for so many people. Why is it just so rare?

**中文翻译:**
你觉得为什么没有更多公司设立 APM 项目？这看起来对很多人来说都是双赢的事，为什么却如此罕见？

---

### (00:11:42) Annie Pearl

**English:**
Yeah, I think when we built this at Box, so drawing on that experience, it was a lot of work. If you're going to do it, you want to do it really well and you want to create an environment where you can help the associate product managers be successful, the goal is to ultimately graduate everyone from the APM program into being a product manager. And so, I think it takes a lot of intentionality and for us, it took a lot of work. We had to make sure we had clarity around the interview process. We had to make sure we had clarity around expectations in the role. We wanted to have a training element.

**中文翻译:**
是的，根据我们在 Box 建立这个项目的经验，这需要投入大量工作。如果你要做，你就想把它做好，创造一个能帮助 APM 成功的环境。最终目标是让 APM 项目中的每个人都能顺利“毕业”成为正式的产品经理。我认为这需要极强的目的性。对我们来说，这涉及大量工作：必须确保面试流程清晰，必须明确岗位预期，还要加入培训环节。

---

### (00:12:16) Annie Pearl

**English:**
We wanted to make sure that, again, we're setting people up for success. So, I think companies have to be at a stage of scale where they can really invest and they have the excess capacity to build the program in a way. I think that's going to help make sure everyone who comes through it has a chance at really learning, growing and ultimately being successful.

**中文翻译:**
我们想确保能为人们的成功铺平道路。因此，我认为公司必须达到一定的规模阶段，才有能力真正投入并拥有多余的精力去构建这样一个项目。我认为这有助于确保每个参与其中的人都有机会真正学习、成长并最终获得成功。

---

### (00:12:33) Lenny

**English:**
That's the same thing we found at Airbnb. There's a PM that was so excited to make the APM program and it just never really happens. It just takes so much work. And to your point, you have to set up for success. You want to make sure there's clear paths and you upgrade to a regular PM and have the interview.

**中文翻译:**
我们在 Airbnb 也发现了同样的情况。有个 PM 非常兴奋地想搞 APM 项目，但最后总是不了了之。这确实太费功夫了。正如你所说，你必须为成功做好铺垫，确保有清晰的晋升路径，能升到正式 PM，并有相应的面试机制。

---

### (00:12:49) Annie Pearl

**English:**
And are we doing, is this really an APM program for internal folks? Is this external? Are we going to be really trying to promote this? So, I think there's a lot of ancillary activities around the actual program itself that have to be taken into consideration to make sure that it is actually very successful.

**中文翻译:**
而且还要考虑：这到底是针对内部员工的 APM 项目，还是面向外部的？我们要大力推广它吗？所以，围绕项目本身有很多辅助性活动需要考虑，以确保它能真正取得成功。

---

### (00:13:06) Lenny

**English:**
Yeah. Maybe a last point we should probably imagine you agree with is generally just hard to get into product management. That's like the default. There's just not that many roles at companies versus say, engineers or some other functions.

**中文翻译:**
是的。最后一点我想你也会同意，那就是进入产品管理领域通常很难。这是默认事实。相比工程师或其他职能，公司里的产品岗位并没有那么多。

---

### (00:13:17) Annie Pearl

**English:**
Right. That's right. Yep.

**中文翻译:**
没错，确实如此。

---

### (00:13:27) Lenny

**English:**
Okay. So, I want to transition a little bit to talking about Calendly.

**中文翻译:**
好的。现在我想转而聊聊 Calendly。

---

### (00:13:29) Annie Pearl

**English:**
Sure.

**中文翻译:**
没问题。

---

### (00:13:29) Lenny

**English:**
There are two areas I want to go. One is just how do you build product at Calendly? What have you learned about product development and team building? And then two, talk about how Calendly grows and what you've learned about growing a product like Calendly. It's such an interesting product, especially from a growth perspective. So, to start on just how product is built at Calendly, just a little context. How many product managers are there and how many PMs are there? How many people total, roughly? Yeah, just to give us a little bit of [inaudible 00:13:57].

**中文翻译:**
我想探讨两个领域。第一，Calendly 是如何打造产品的？你在产品开发和团队建设方面学到了什么？第二，聊聊 Calendly 是如何增长的，以及你在增长像 Calendly 这样的产品中学到了什么。从增长的角度来看，这是一款非常有趣的产品。首先，关于 Calendly 如何打造产品，先给点背景信息：那里有多少产品经理？大概总共有多少人？

---

### (00:13:56) Annie Pearl

**English:**
Let's see, when I joined about two years ago, I think the company was about 150 people and I think we're about 600 now. And then the product team, there were about 15 product managers and designers when I joined again about two years ago, and I think we're around 60 this year.

**中文翻译:**
让我想想，我大约两年前加入时，公司大概有 150 人，现在大约有 600 人。至于产品团队，两年前我加入时大约有 15 名产品经理和设计师，今年大概有 60 人左右。

---

### (00:14:08) Lenny

**English:**
Wow. So, 60 product managers.

**中文翻译:**
哇，60 名产品经理。

---

### (00:14:14) Annie Pearl

**English:**
Product managers, designers, and a research team. Yeah.

**中文翻译:**
包括产品经理、设计师和研究团队。是的。

---

### (00:14:16) Lenny

**English:**
Got it. What about just PMs?

**中文翻译:**
明白了。那单纯 PM 有多少？

---

### (00:14:20) Annie Pearl

**English:**
PMs probably, my guess is 20. Twenty-ish. Yeah.

**中文翻译:**
PM 的话，我猜大概有 20 个左右。

---

### (00:14:25) Lenny

**English:**
Cool. And then, can you talk about how the product team is structured roughly? If you think about a tree, [inaudible 00:14:30] tree.

**中文翻译:**
酷。那你能大概说一下产品团队的架构吗？如果把它想象成一棵树的话。

---

### (00:14:30) Annie Pearl

**English:**
Yeah. So, as I mentioned, we've got product managers, we have designers, we have a research team, and then product operations. And then, on my product leadership team, we have head of design, head of research, head of product operations. And then, within the product management team, I have leaders across core, across enterprise and platform.

**中文翻译:**
好的。正如我提到的，我们有产品经理、设计师、研究团队，还有产品运营（Product Ops）。在我的产品领导团队中，有设计负责人、研究负责人和产品运营负责人。在产品管理团队内部，我有负责核心业务（Core）、企业级业务（Enterprise）和平台业务（Platform）的领导者。

---

### (00:14:50) Lenny

**English:**
Got it. So, you manage the design team and engineering team, you said?

**中文翻译:**
明白了。所以你管理设计团队和工程团队，是吗？

---

### (00:14:54) Annie Pearl

**English:**
Not engineering. Design, product and research. Yeah.

**中文翻译:**
不包括工程。是设计、产品和研究。

---

### (00:14:56) Lenny

**English:**
Got it. Something that I find is one of the big differences between product orgs is design reporting up to a product leader versus not. What's the rationale there? And then has Calendly tried a different approach?

**中文翻译:**
明白了。我发现不同产品组织之间的一个巨大差异在于设计团队是否向产品领导者汇报。这样做的逻辑是什么？Calendly 有尝试过不同的方法吗？

---

### (00:15:08) Annie Pearl

**English:**
Yeah. So, when I was at Glassdoor in the CPO role, I had the opportunity to lead design for the first time. So, coming into Calendly, I had led both product and design as well as research. And so, I think it made sense given I'd already done it once to keep that structure coming into Calendly. I think at the end of the day, the real benefit of the structure is really to say at the end, we want to be thinking about everything we're doing through the lens of the end-to-end user experience.

**中文翻译:**
是的。当我在 Glassdoor 担任 CPO 时，我有机会第一次领导设计团队。所以来到 Calendly 时，我已经有过同时领导产品、设计和研究的经验。考虑到我已经做过一次，在 Calendly 延续这种架构是合理的。我认为这种架构的核心优势在于：我们希望通过端到端用户体验的视角来审视我们所做的一切。

---

### (00:15:53) Annie Pearl

**English:**
So, if we have product managers who are really prioritizing the problems we're going after, and we've got designers who are really trying to think about how do we bring solutions to life to solve those problems, having both of those functions roll into one person just really allows us to think more holistically around the end-to-end user experience. So, certainly, it can work where you have product and design reporting into different leaders that ultimately report into the CEO, but when you get to this level of scale from just a pure people management, but also just the scale of the business, you know often see this consolidation where product and design start to roll into one leader. And at least in my experience, I think it can help ensure that all the different pieces of work are integrated well together and ultimately deliver a better experience for customers.

**中文翻译:**
如果我们的产品经理负责确定我们要解决的问题的优先级，而设计师负责思考如何通过方案来解决这些问题，那么将这两个职能归口到同一个人管理，能让我们更全面地思考端到端的用户体验。当然，产品和设计分别向不同的领导汇报并最终汇总到 CEO 那里也是可行的，但当你达到这种人员管理规模和业务规模时，你经常会看到这种整合，即产品和设计开始归口于同一位领导。至少根据我的经验，这有助于确保所有不同的工作环节都能很好地整合在一起，最终为客户提供更好的体验。

---

### (00:16:23) Lenny

**English:**
So, it sounds like before you joined it wasn't like that. And if that's true, was there something that improved with that shift?

**中文翻译:**
听起来在你加入之前并不是这样的。如果是这样的话，这种转变带来了哪些改进？

---

### (00:16:29) Annie Pearl

**English:**
So, the structure was there that way. At that time, we didn't have a head of design, so we had a lot of really great individual contributors and who had been, many of whom had been with the company for quite some time and really contributed to the great user experience that existed in the product. But we didn't have a design leader. So, one of the first leadership hires I made was to bring in a head of design to really build out that function. And then, that head of design is a peer partnering with the different heads of products across the product management organization as well.

**中文翻译:**
其实架构原本就是那样的。只是当时我们没有设计负责人，虽然有很多非常优秀的个人贡献者（IC），其中许多人在公司待了很久，为产品现有的出色用户体验做出了巨大贡献。但我们缺少一位设计领导者。所以我最早进行的领导层招聘之一就是引入一位设计负责人来真正构建这个职能。现在，这位设计负责人与产品管理组织中各业务板块的产品负责人是平级合作伙伴关系。

---

### (00:16:59) Lenny

**English:**
What about in terms of the structure, whatever you can share one level below, how do you structure teams? Is it around outcomes? Is it around features of the product? Is it around type of persona? How do you think about that?

**中文翻译:**
关于架构，在下一层级你是如何组建团队的？是围绕产出（Outcomes）？围绕产品功能？还是围绕用户画像类型？你是怎么考虑的？

---

### (00:17:13) Annie Pearl

**English:**
Yeah, yeah. So, we have a core team who's really responsible for the core end to-end user experience. In many ways, they're both doing feature development and then they're also doing growth work. So, they're thinking about how do we build new features and functionalities to help our core personas, which is typically folks who are in sales, recruiting and customer success. So, anyone in an externally facing role, we're really trying to help them do their jobs better. So, the core team's thinking about features and functionalities to really help our core end user persona. And then growth work to think about the PLG funnel, everything from acquisition, activation, conversion, and retention. So, that's one group.

**中文翻译:**
好的。我们有一个核心团队（Core Team），负责核心的端到端用户体验。在很多方面，他们既做功能开发，也做增长工作。他们思考如何构建新功能来帮助我们的核心用户画像——通常是销售、招聘和客户成功人员。总之，对于任何面向外部的角色，我们都在努力帮他们把工作做得更好。核心团队关注功能开发以服务核心用户，同时也关注 PLG 漏斗的增长工作，包括获取、激活、转化和留存。这是第一组。

---

### (00:17:49) Annie Pearl

**English:**
And then, second group is our "enterprise group." And they're really thinking about two different personas. One is the IT admin, the person who needs to make sure that Calendly is secure and that they have all the reporting mechanisms to be able to manage their account and all the tools to manage users and groups at scale. And the second piece of that is also departmental leaders. So as Calendly selling into or being used by a sales organization, the head of sales is not the IT admin, but they are a Teams admin who needs to manage their organization within Calendly. So, the enterprise group really thinks both about the admin, but also sort of the departments and how do we better serve departments.

**中文翻译:**
第二组是我们的“企业组”（Enterprise Group）。他们主要考虑两种不同的画像。一是 IT 管理员，他们需要确保 Calendly 的安全性，拥有管理账户的所有报告机制，以及大规模管理用户和群组的工具。第二部分是部门领导。当 Calendly 卖给或被销售部门使用时，销售主管不是 IT 管理员，但他们是团队管理员，需要在 Calendly 中管理他们的组织。所以企业组既考虑管理员，也考虑部门需求，以及我们如何更好地服务部门。

---

### (00:18:31) Annie Pearl

**English:**
And then lastly, we have a platform team who's really thinking about how do we embed Calendly into the business processes of the organizations that we support and that we provide our product into. And so, that's everything from partnerships and integrations to our APIs.

**中文翻译:**
最后，我们有一个平台团队（Platform Team），他们主要思考如何将 Calendly 嵌入到我们所支持的组织的业务流程中。这涵盖了从合作伙伴关系、集成到我们的 API 的所有内容。

---

### (00:18:46) Lenny

**English:**
Interesting. So, it's like problem focused/persona focused. Who are you trying to sell it to?

**中文翻译:**
很有趣。所以是围绕问题或画像展开的。也就是看你想把产品卖给谁。

---

### (00:18:54) Annie Pearl

**English:**
That's right, that's right. Yeah, trying to sell it to, and then the persona of who's going to be using the functionality. And then, really having those teams hone and own those personas as they're developing functionality within the product.

**中文翻译:**
没错。看卖给谁，以及谁会使用这些功能。然后让这些团队在开发产品功能时，深入研究并对这些画像负责。

---

### (00:19:07) Lenny

**English:**
What's your take on OKRs? Do you all use OKRs in some form?

**中文翻译:**
你对 OKR 怎么看？你们公司以某种形式使用 OKR 吗？

---

### (00:19:11) Annie Pearl

**English:**
Yes, we do. We use OKRs both at the company level. So, we have three main OKRs that we're focused on for this year, for example, across the whole company. And then we have department level OKRs, many of which are in support of the company level OKRs, but then there's some additional things that we'll be doing at the department level, for example, that aren't going to show up at the company level. So yeah, we use them both at the company as well as on the product side.

**中文翻译:**
是的，我们用。我们在公司层面使用 OKR。例如，今年全公司关注三个主要的 OKR。然后我们有部门层面的 OKR，其中许多是为了支持公司层面的 OKR，但部门层面也会有一些额外的工作，比如不会体现在公司层面的任务。所以，我们在公司和产品端都使用 OKR。

---

### (00:19:34) Lenny

**English:**
Is there anything you've learned about making OKRs work? People love them. People hate them. Is there something you do to make OKRs work? Something you've changed, something you've learned over time in how to work with OKRs?

**中文翻译:**
关于如何让 OKR 发挥作用，你有什么心得吗？人们对它爱恨交织。为了让 OKR 奏效，你做了什么？随着时间的推移，你在使用 OKR 方面有什么改变或教训？

---

### (00:19:44) Annie Pearl

**English:**
Yeah. When I first joined, I'd say we didn't have this muscle well built out. We didn't really have a clear product strategy at the time or clear OKRs guiding the work. And so, there was a lot of great work happening, but it really was unclear how it all fit together or how we were going to measure success in that work. So that was a first phase. I think the second phase for us was we developed a product strategy. We then had product team OKRs that corresponded to that product strategy, but they were really contained to the product team and each department across the organization had their own kind of siloed OKRs.

**中文翻译:**
是的。我刚加入时，这种“肌肉记忆”还没建立起来。当时我们没有清晰的产品策略，也没有明确的 OKR 来指导工作。虽然有很多出色的工作在进行，但并不清楚这些工作是如何整合在一起的，或者如何衡量成功的。那是第一阶段。第二阶段是我们制定了产品策略，并有了与之对应的产品团队 OKR，但这些 OKR 仅限于产品团队内部，组织内的每个部门都有各自孤立的 OKR。

---

### (00:20:20) Annie Pearl

**English:**
And then, phase three, where really, I'd say we headed into this year, we have a really clear set, as I mentioned, of company OKRs and then in these really tightly integrated plans across the company around how we're going to support the key results and ultimately deliver on the objectives. And this has been a really incredible transformation of dependency mapping, being able to make sure that we're pulling all the levers across the organization to drive our most important objective. So, I think it's just the kind of maturing of the business from almost no OKRs to product team OKRs to now company OKRs in a really tight planning process to make sure there's a lot of integration across the company to support what we need to do as a business.

**中文翻译:**
然后是第三阶段，也就是今年。我们有一套非常清晰的公司级 OKR，以及全公司范围内紧密整合的计划，明确我们将如何支持关键结果（Key Results）并最终实现目标（Objectives）。这是一个令人惊叹的转变，涉及依赖关系梳理（Dependency mapping），确保我们动用全组织的所有杠杆来推动最重要的目标。我认为这就是业务成熟的过程：从几乎没有 OKR，到只有产品团队 OKR，再到现在的公司级 OKR，并配合严密的规划流程，确保全公司高度整合，支持业务需求。

---

### (00:21:01) Lenny

**English:**
So, what I'm hearing is one of the biggest changes in learnings was to connect OKRs across from the top to the bottom, right?

**中文翻译:**
所以我听到的是，最大的改变和教训之一就是将 OKR 从上到下贯通起来，对吗？

---

### (00:21:08) Annie Pearl

**English:**
Absolutely. Absolutely.

**中文翻译:**
绝对是这样。

---

### (00:21:09) Lenny

**English:**
Is there anything else that has made a big impact on your ability to build and ship and execute as a company in terms of changes you've made in terms of how the company and how the teams build?

**中文翻译:**
在公司和团队构建产品的方式上，还有什么改变对你们的构建、发布和执行能力产生了重大影响？

---

### (00:21:20) Annie Pearl

**English:**
I think one of the biggest changes that we've made, when I first joined, again, we had a product that served a lot of horizontal users. We help solo users who are freelancers, consultants. We help sales teams, we help recruiting teams, we help customer success, we help folks in education. So, we had a very broad user base. And what that means is that product managers in particular are I think had a really hard time prioritizing. At any point in time, it was really difficult to say, should I do work on feature A or for feature B without that clarity?

**中文翻译:**
我认为我们做出的最大改变之一是：我刚加入时，我们的产品服务于大量的横向用户。我们帮助自由职业者、顾问等个人用户，也帮助销售团队、招聘团队、客户成功团队，还有教育领域的人员。我们的用户群非常广泛。这意味着产品经理在确定优先级时非常痛苦。在任何时候，如果没有清晰的指引，很难决定是该做功能 A 还是功能 B。

---

### (00:22:09) Annie Pearl

**English:**
And so, I think one of the most impactful things we did pretty early on in my tenure here was to hone in on our overall product strategy, but a poor piece of that being what's the actual market we're going after? What are the segments of that market? Who are the personas within the segments of that market? And so, we've made a pretty clear distinction now that while a lot of the feature work that we'll do to support our target personas of sales teams, customer success teams and recruiting teams will impact folks who are not in those personas. Those are the core ICPs that we're going after. And so, historically, that would've been always a sort of trade off decision and a question. And now I think we have a lot of rigor around who our target market and then persona we're going after. And so, teams can use that to prioritize and also just deliver better value for those users.

**中文翻译:**
因此，在我任职早期，最有影响力的一件事就是明确我们的整体产品策略，其中核心部分是：我们到底要进军哪个市场？该市场的细分领域是什么？这些细分领域中的用户画像是谁？我们现在做出了非常清晰的区分：虽然我们为销售、客户成功和招聘团队这些目标画像开发的功能也会影响到非目标画像的用户，但这些才是我们要追求的核心 ICP（理想客户画像）。过去，这总是一个需要权衡的难题，而现在我们对目标市场和画像有了严格的定义。这样团队就可以据此确定优先级，并为这些用户提供更好的价值。

---

### (00:22:45) Lenny

**English:**
So, it sounds like the biggest unlock and one of the biggest unlocks for making the team more efficient, move faster, make decisions quicker, is narrowing in on exactly who you're going to be selling to.

**中文翻译:**
所以听起来，让团队更高效、行动更快、决策更迅速的最大突破口之一，就是精准锁定你们到底要卖给谁。

---

### (00:22:55) Annie Pearl

**English:**
I think it's one of the harder things for companies to do. So, it sounds relatively easy, and I think most companies believe that they have clarity around this. But then when you go down into the weeds of asking someone who's product manager or a designer, I don't know that it's always as clear because there's always a bit of a hesitation to say no, right? And the idea of saying no is scary. When in reality, the ability to say no is going to allow you to make sure you're building something that's going to be amazing for the people that matter most and not something that's going to be average or okay for a lot of different people.

**中文翻译:**
我认为这是公司最难做到的事情之一。听起来相对容易，大多数公司也自认为很清楚。但当你深入细节去问产品经理或设计师时，我不确定是否总是那么清晰，因为人们总是犹豫要不要说“不”。说“不”是很可怕的。但现实中，说“不”的能力能确保你为最重要的人打造出惊艳的产品，而不是为一大群不同的人打造一个平庸或“还凑合”的产品。

---

### (00:23:28) Lenny

**English:**
Was there anything that was really hard about actually executing that, convincing people we're going to narrow and not worry about these people and any lessons from going through that process? Because I imagine a lot of founders listening are like, "Oh, that sounds we should be doing this, but oh man, we're leaving all this money on the table, people are going to be pissed."

**中文翻译:**
在实际执行过程中，说服大家“我们要缩小范围，不再关注某些人”有什么困难吗？在这个过程中有什么教训？因为我能想象很多听众中的创始人会想：“噢，听起来我们应该这么做，但天哪，我们要损失这么多潜在收入，人们会生气的。”

---

### (00:23:45) Annie Pearl

**English:**
Yeah, I think it's a pretty big cultural shift. Some of this intersects with the shift from product led growth to adding in a sales motion. When I joined Calendly, all of our ARR came from our PLG channel. We didn't have a sales team, we just hired a CRO who was going to build out a sales team. And so, in that world, the way you think about product, the way you think about processes, even the people you have on the team are tailored to that business model. And then, as we sort of moved up market and have now explicitly started to go after teams of users and departments of users and organizations of larger scale, everything about people, process, and product all changes.

**中文翻译:**
是的，我认为这是一个巨大的文化转变。这其中一部分与从产品驱动增长（PLG）转向增加销售驱动（Sales motion）有关。我加入 Calendly 时，所有的 ARR（年度经常性收入）都来自 PLG 渠道。我们没有销售团队，刚聘请了一位首席营收官（CRO）来组建销售团队。在那个阶段，你对产品、流程甚至团队人员的思考方式都是为那种商业模式量身定制的。而当我们向高端市场进军，明确开始争取团队用户、部门用户和更大规模的组织时，关于人员、流程和产品的一切都会发生变化。

---

### (00:24:29) Annie Pearl

**English:**
I think I touched on culture because I think that's pervasive across the entire organization. The way that things get done has to be highly integrated versus can be a bit more siloed when you're just sort of the self-service PLG business that in many ways runs itself through the product being well optimized. So, there's a lot of process change that needs to happen, the type of people that you need to bring into the organization, that changes as you layer in the new selling motion. And then the product itself of course has to change.

**中文翻译:**
我提到文化是因为它渗透在整个组织中。办事方式必须高度整合，而当你只是一个通过优化产品就能自我运转的自助式 PLG 业务时，各部门可以相对独立。因此，需要发生大量的流程变革，你需要引入的人才类型也会随着新销售模式的加入而改变。当然，产品本身也必须随之改变。

---

### (00:24:56) Annie Pearl

**English:**
So, I guess let's just say the example of PLG and SLG or the direct selling motion is tied in to your question around what are the things that need to change in order to get clear on your target user? And I think it's highly cultural in nature across people, across process, and then obviously across the actual product itself.

**中文翻译:**
所以，PLG 和 SLG（销售驱动增长）或直销模式的例子，正好回答了你关于“为了明确目标用户需要改变什么”的问题。我认为这在本质上是高度文化性的，涉及人员、流程，显然也涉及产品本身。

---

### (00:25:15) Lenny

**English:**
I have a whole bunch of questions about how Calendly grows and maybe we just get into some of the stuff because I imagine a lot of people are interested. First, let me ask this. I imagine Calendly mostly grows through, I sign up for Calendly, they send it to everyone when I book a meeting and they're like, "Oh, what is this?" And they're like, "Oh, cool, I'm going to use this." And then they start using, it spreads, and then sales eventually finds people at a company that are using it a lot and tries to get the whole company in it. Is that roughly right?

**中文翻译:**
关于 Calendly 如何增长，我有一堆问题，也许我们可以聊聊这个，因为我猜很多人感兴趣。首先，我猜 Calendly 的增长主要是这样的：我注册了 Calendly，预约会议时发给所有人，他们会想：“噢，这是什么？”然后觉得：“噢，酷，我也要用。”接着它就开始传播，最后销售发现某家公司有很多人在用，就尝试让整家公司都买单。大概是这样吗？

---

### (00:25:39) Annie Pearl

**English:**
Yeah. Seventy percent of our signups come through that viral loop that you referred to. And then, of those signups, then they're usually solo users and then they start to invite team members in and then the team starts using Calendly and then usually the head of that team either inbounds to us or we have some sort of PQL data to know we should go after that team lead to try and have a conversation around expanding Calendly across their entire organization.

**中文翻译:**
是的。我们 70% 的注册来自你提到的那个病毒式循环。在这些注册用户中，通常最初是个人用户，然后他们开始邀请团队成员，接着整个团队开始使用。通常该团队的主管要么主动联系我们，要么我们通过 PQL（产品合格线索）数据发现应该去找那个团队负责人，谈谈在整个组织推广 Calendly 的事。

---

### (00:26:05) Lenny

**English:**
And PQL, product qualified lead, right?

**中文翻译:**
PQL 就是 Product Qualified Lead（产品合格线索），对吧？

---

### (00:26:08) Annie Pearl

**English:**
You got it. Yep.

**中文翻译:**
没错。

---

### (00:26:08) Lenny

**English:**
Wow, what a loop. What a magical way to grow that everybody wishes they could have.

**中文翻译:**
哇，真是个完美的闭环。这种每个人都梦寐以求的神奇增长方式。

---

### (00:26:14) Annie Pearl

**English:**
It's pretty incredible, I will say.

**中文翻译:**
我必须说，这确实非常不可思议。

---

### (00:26:16) Lenny

**English:**
Oh man. Okay, so going back to the question. When did Calendly hire their first salesperson, like any learnings about just how to start down that road once you start a product?

**中文翻译:**
天哪。好，回到问题。Calendly 是什么时候雇佣第一名销售人员的？关于在产品起步后如何开启销售这条路，有什么经验教训吗？

---

### (00:26:25) Annie Pearl

**English:**
Yeah. As I mentioned, when I joined two years ago, we just hired our first CRO and the PLG business really represented 99% of our ARR. And then, over the last two years, we've scaled the sales team in our SLG motion. Our sales led growth motion now represents about 20% of our ARR and it's actually the fastest growing segment of the business. I think there's probably two things I would touch on in terms of early sales hires.

**中文翻译:**
是的。正如我提到的，两年前我加入时，我们刚聘请了第一位 CRO，当时 PLG 业务占我们 ARR 的 99%。在过去的两年里，我们扩大了 SLG（销售驱动增长）模式下的销售团队。现在我们的销售驱动增长部分约占 ARR 的 20%，而且它实际上是业务中增长最快的部分。关于早期销售招聘，我想提两点。

---

### (00:27:17) Annie Pearl

**English:**
I think the first is, when you're making that transition from PLG to adding in the sales led motion, because you're starting from PLG, it's tends to be much more inbound in nature. You've got these sales reps who are working leads who have usually proactively reached out interested or as we mentioned PQLs. They have data to tell them that this is someone who has usage within their team, and therefore, we should reach out. And so, that's a very different profile of a sales team member than you might need after you need to pursue more of a heavy outbound motion, more of a hunter profile than a grower profile. So, I think that's the first piece is just make sure you think about the motion when you're moving towards a sales led model. In those early days, it's more inbound in nature, and so the type of sales reps you might need are not necessarily going to be outbound, heavy kind of hunting sales reps.

**中文翻译:**
第一点是，当你从 PLG 转型或增加销售驱动模式时，因为你是从 PLG 开始的，所以它往往更具“入站”（Inbound）性质。你的销售代表处理的线索通常是主动联系表示感兴趣的，或者是我们提到的 PQL。他们有数据支撑，知道某人在团队内有使用量，因此我们应该去联系。这与后期需要进行大量“出站”（Outbound）开拓、需要“猎人型”而非“农夫型”销售的人才画像非常不同。所以第一点是，当你转向销售驱动模型时，要考虑你的销售模式。在早期，它更多是入站性质的，所以你需要的销售代表不一定是那种擅长主动出击、重度开拓的“猎人”。

---

### (00:27:46) Lenny

**English:**
Just one quick question on that actually, because that's really interesting. I don't know how involved you are in hiring these folks, but is it like, look at their background and they've worked at a company like that? Or is it personality type? Is there anything to look for specifically there?

**中文翻译:**
关于这一点我想追问一下，这很有趣。我不知道你参与招聘这些人的程度有多深，但你是看他们的背景（比如是否在类似公司工作过），还是看性格类型？有什么特别需要寻找的特质吗？

---

### (00:27:58) Annie Pearl

**English:**
Yeah, I think it is mostly background and the type of selling that they've done previously more so than personality type. But I think the second piece, that's important too, and I'll answer your question on that one too, which is the target buyer. So, when you transition from PLG to sales led or adding this direct sales motion, the buyer is usually just the department head. It's the head of sales, it's the head of rev ops, it's the head of recruiting and it's not a senior person in IT or the CIO. And so, selling into this audience is different than selling into IT.

**中文翻译:**
是的，我认为更多是看背景和他们之前从事的销售类型，而不是性格类型。但第二点也很重要，这也能回答你的问题，那就是目标买家。当你从 PLG 转向销售驱动或增加直销模式时，买家通常只是部门主管——销售主管、营收运营（Rev Ops）主管、招聘主管，而不是 IT 部门的高层或 CIO。卖给这些受众与卖给 IT 部门是完全不同的。

---

### (00:28:32) Annie Pearl

**English:**
And so, I think you have to be sure again that you have the right fit of sales folks with the target buyer in those early days. And so, to your question around what's that mean? You wouldn't necessarily want to bring on a bunch of sales folks who are at Oracle who are heavy in selling into CIOs in the early days because that's just not who you're the buyer's going to be. I mean, think we will graduate there eventually, but it's probably going to start from team lead to someone in IT to eventually a CIO led purchase, but that's certainly several years away. And so, making sure that the profile, the folks you're bringing on early match that target buyer in addition to match the motion around how you're going to be acquiring customers.

**中文翻译:**
所以，你必须确保早期招聘的销售人员与目标买家相匹配。回到你的问题，这意味着什么？你可能不想在早期招募一大堆来自 Oracle、习惯于卖给 CIO 的销售，因为那根本不是你的买家。我的意思是，我们最终会发展到那个阶段，但过程可能是从团队领导到 IT 人员，最后才是 CIO 主导的采购，而那肯定还要好几年。所以要确保早期人员的画像既匹配目标买家，又匹配获取客户的销售模式。

---

### (00:29:15) Lenny

**English:**
And to see that, is it similar? You look at the companies they worked at, it's like PLG-ish companies.

**中文翻译:**
为了判断这一点，方法是否类似？就是看他们工作过的公司，是不是那种带有 PLG 色彩的公司。

---

### (00:29:20) Annie Pearl

**English:**
Definitely. Yeah, exactly. Yep. Yep.

**中文翻译:**
绝对是，完全正确。

---

### (00:29:23) Lenny

**English:**
Okay. So, along the same lines, as a product leader working with a strong and large sales team, anything you've learned about just how to build that relationship and build a product org that works really closely and well with a sales org?

**中文翻译:**
好的。顺着这个思路，作为一名与强大且庞大的销售团队合作的产品领导者，关于如何建立这种关系，以及如何建立一个能与销售组织紧密良好协作的产品组织，你有什么心得吗？

---

### (00:29:37) Annie Pearl

**English:**
The first piece that really starts with is customer empathy. And at the end of the day, seeing the sales team and the go-to-market team as this really great asset that can help you as a product manager get closer to the customer. So, I've certainly seen organizations or been in organizations where the product team doesn't necessarily want to be bothered by sales, but I sort of flip that on the head and say sales and sort of the go-to-market teams in general could be your biggest asset to helping you get your job done well.

**中文翻译:**
第一点首先是客户同理心。归根结底，要将销售团队和市场端团队视为一种非常棒的资产，他们能帮助你作为产品经理更接近客户。我确实见过或待过一些组织，那里的产品团队不希望被销售打扰，但我把这种观念反转了过来：销售和市场团队通常是你做好工作的最大资产。

---

### (00:30:07) Annie Pearl

**English:**
When I was at Box, I was a product manager on the enterprise team and I spent a ton of time in the field and I don't know how I would possibly know how to have what to have built or how to build it to solve the needs of our customers if I didn't have that close relationship with the sales team and be able to lean on them because they're talking to, 10X of them were customers that I was able to ever talk to within any given week, really lean on them to be the voice of the customer to help me make the best product decisions that I could.

**中文翻译:**
我在 Box 担任企业组产品经理时，花了大量时间跑一线。如果没有与销售团队的紧密关系并依靠他们，我根本不知道该构建什么或如何构建来解决客户需求。因为他们接触的客户数量是我每周能接触到的 10 倍。真正依靠他们作为“客户之声”，能帮助我做出最好的产品决策。

---

### (00:30:35) Lenny (Sponsor: Vanta)

**English:**
Today's episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements.

**中文翻译:**
本期节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。如果你的业务在云端存储数据，那么你很可能已经被问到或将被问到 SOC 2 合规性。SOC 2 是证明公司采取了适当安全措施保护客户数据的一种方式，能建立客户和合作伙伴（尤其是那些有严格安全要求的伙伴）的信任。

---

### (00:31:00) Lenny (Sponsor: Vanta)

**English:**
Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold. If you don't have a SOC two, there's a good chance you won't even get a seat at the table. Beginning a SOC 2 report can be a huge burden, especially for startups. It's time consuming, tedious and expensive. Enter Vanta. Over 3,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time. Lenny's podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny. That's V-A-N-T-A.com/lenny to learn more and to claim your discount get started today.

**中文翻译:**
此外，如果你想向企业销售产品，证明安全性至关重要。SOC 2 既能为你开启更大、更好的交易之门，也可能让你的业务停滞不前。如果你没有 SOC 2，很可能连谈判桌都上不去。获取 SOC 2 报告可能是一个巨大的负担，尤其是对初创公司而言，既耗时、繁琐又昂贵。Vanta 应运而生。超过 3000 家快速增长的公司使用 Vanta 自动完成高达 90% 的 SOC 2 相关工作。Vanta 能让你在几周内（而不是几个月）做好安全审计准备，时间不到通常所需的三分之一。限时优惠：Lenny 播客的听众可享受 Vanta 1000 美元的折扣。只需访问 vanta.com/lenny 即可了解更多并领取折扣。

---

### (00:31:52) Lenny

**English:**
I'm curious how you prioritize work that you could be doing as a product team. There are salespeople coming at you, there's issues you're probably having, there are some founders wanting to ask you for few stuffs, just like a classic product management question. But I'm curious if you found any frameworks or approaches for just deciding what to actually build of all the things you're hearing.

**中文翻译:**
我很好奇你如何为产品团队的工作确定优先级。销售人员会找你，你可能会遇到各种问题，还有创始人想让你做点这做点那，这就是经典的产品管理难题。但我很好奇，在听到的所有需求中，你是否发现了一些框架或方法来决定到底该构建什么。

---

### (00:32:09) Annie Pearl

**English:**
The core challenge of being a product manager, right?

**中文翻译:**
这就是做产品经理的核心挑战，对吧？

---

### (00:32:12) Lenny

**English:**
Just to add that I feel like the core job of PM is just tell people what's next, what's the next thing.

**中文翻译:**
补充一下，我觉得 PM 的核心工作就是告诉大家接下来要做什么，下一件事是什么。

---

### (00:32:16) Annie Pearl

**English:**
That's right, and hopefully, you have a good reasoning as to why that thing, next is going to have the biggest impact, which is really where I start. I think it really starts with a clear product strategy that will dictate a few things. And I like this framework that's taken from a book called Playing to Win and it talks about how strategy is really just an integrated set of choices that outline how you're going to win in whatever marketplace you choose.

**中文翻译:**
没错，而且希望你能有一个充分的理由说明为什么下一件事会有最大的影响力，这正是我开始的地方。我认为这始于一个清晰的产品策略，它决定了几件事。我喜欢《赢在策略》（Playing to Win）这本书里的一个框架，它谈到策略实际上就是一套整合的选择，概述了你打算如何在所选的任何市场中获胜。

---

### (00:32:59) Annie Pearl

**English:**
And so, a good product strategy is going to answer questions like, what's your sort of winning aspiration, but maybe more importantly, where are you going to play? What are the markets you're going to go after? What are the segments of those markets? What are the personas in the segments of those markets? And then, how are you going to win with a target audience? And so, what I think this framework does kind of dovetails back to what I was saying before around prioritization is it forces you to create clarity around where you're going to play and where you're not going to play.

**中文翻译:**
因此，一个好的产品策略会回答诸如“你的获胜愿景是什么”之类的问题，但可能更重要的是，“你打算在哪里竞争？”你要进军哪些市场？这些市场的细分领域是什么？这些细分领域中的用户画像是谁？最后，你打算如何赢得目标受众？我认为这个框架与我之前提到的优先级划分相契合，它迫使你明确“在哪里竞争”以及“不在哪里竞争”。

---

### (00:33:28) Annie Pearl

**English:**
And so, this really helps the product team hone in on delivering value for a very clear set of people versus trying to build something for everyone. And so, once you've established what that strategy is or what the playing field you're going to go after, then I think you can divide up your product work and service of that strategy. So, I'll give you an example. At Calendly, we have the sort of vision, our winning aspiration to become the best place to schedule, prepare for and follow up on your external meetings. And we've articulated three horizons around how we're going to get there.

**中文翻译:**
这能帮助产品团队专注于为一组非常明确的人群提供价值，而不是试图为所有人构建产品。一旦你确定了策略或你要进军的领域，你就可以围绕该策略分配产品工作。举个例子：在 Calendly，我们的愿景（获胜愿景）是成为安排、准备和跟进外部会议的最佳场所。我们制定了实现这一目标的三个阶段（Horizons）。

---

### (00:34:00) Annie Pearl

**English:**
Now, the year one that I was here, the percentage of resources we spent on that first horizon and the second horizon was about a 70/30 split and we put 0% of our resources on horizon three. That was too far out in the future and we didn't want to make any investments there quite yet, but we knew where we were going. In year two, it shifted. We went to a 50/50 split between horizon one and horizon two, but still, no explicit investments in Horizon three. And then, as we're entering to year three now, we've significantly scaled back the investment in horizon one, that's about 30% and then we've got 60% in horizon two and call it 10 in horizon three.

**中文翻译:**
我来的第一年，我们在第一阶段和第二阶段投入的资源比例大约是 70/30，而在第三阶段投入为 0%。那离未来太远了，我们还不想在那里投资，但我们知道方向。第二年，比例发生了变化，变成了 50/50，但仍然没有对第三阶段进行明确投资。现在进入第三年，我们大幅缩减了第一阶段的投入（约 30%），将 60% 投入第二阶段，大约 10% 投入第三阶段。

---

### (00:34:38) Annie Pearl

**English:**
So, I think to close on the question of prioritization, I think it starts with a really clear product strategy which defines where you're going to play and how you're going to win. And then, the work and the percentage of allocation just should feed right into that product strategy and how you're doing against where you need to be in order to achieve ultimately your winning aspiration.

**中文翻译:**
所以，总结一下优先级的问题：我认为它始于一个非常清晰的产品策略，定义了竞争领域和获胜方式。然后，具体工作和资源分配比例应该直接服务于该策略，并根据你与最终获胜愿景之间的差距进行调整。

---

### (00:34:38) Lenny

**English:**
I don't know how much you could share here, but is there a feature that is people keep asking for it and it hasn't been built because of the strategy, the long-term vision, something that's like, "Nope, it doesn't fit. We're not going to do this."

**中文翻译:**
我不知道你能分享多少，但有没有什么功能是人们一直想要，但因为策略或长期愿景而一直没做的？那种“不，这不合适，我们不打算做”的功能。

---

### (00:34:50) Annie Pearl

**English:**
Yeah, I think the best example I can give is there's lots of small businesses and solopreneurs who would love us to have a Venmo integration. We have a PayPal integration. But our target market that we're really trying to go after as our primary persona are as I've mentioned, these sort of core ICPs within organizations. So, sales teams, recruiting teams, customer success teams. And so, it doesn't make sense within those personas to pursue something like a Venmo integration. Now, there's a lot of things we'll build for those personas that are going to help the small business, the solopreneur, the freelancer, but that specific feature is something that would be clearly deprioritized given the current strategy.

**中文翻译:**
是的，我能给出的最好例子是：有很多小企业和个人创业者非常希望我们能集成 Venmo。我们已经有了 PayPal 集成。但我们真正努力争取的目标市场和主要画像，正如我提到的，是组织内部的那些核心 ICP——销售团队、招聘团队、客户成功团队。对于这些画像来说，追求 Venmo 集成是没有意义的。虽然我们为这些画像构建的很多功能也会帮到小企业或自由职业者，但根据目前的策略，那个特定功能的优先级显然会被排在后面。

---

### (00:35:29) Lenny

**English:**
That's an awesome example. I want to get back to the growth stuff, but before I do that, we're kind of on this topic of planning and a cares and prioritization. I'd love to know just how you do planning at Calendly? How far out do you plan in detail? How far do you have roadmaps? How often do you plan? Anything you can share there?

**中文翻译:**
这是一个很棒的例子。我想回到增长的话题，但在那之前，既然我们聊到了规划、OKR 和优先级，我想知道你们在 Calendly 是如何做规划的？你们详细规划到多远以后？路线图（Roadmap）有多长？多久规划一次？有什么可以分享的吗？

---

### (00:35:45) Annie Pearl

**English:**
This starts again, I sound like a broken record, but with this really clear strategy around where we're going over the next couple of years and then we take that and we break that down into what are the most important things we need to do as a company this year in order to be able to make the right progress against that strategy. So, we have the company level OKRs and I mentioned that we have about three of those this year. And then, those KRs within the company, OKRs are measured annually, but we have milestones across a quarterly basis so we can measure progress more frequently than obviously on the annual or semi-annual basis.

**中文翻译:**
这又要说回来了（我听起来像个坏掉的唱片机），首先是关于未来几年发展方向的清晰策略，然后我们将其分解为公司今年为了实现该策略需要做的最重要的事情。所以我们有公司级的 OKR，我提到今年大约有三个。这些公司级 OKR 中的关键结果（KR）是按年衡量的，但我们有季度里程碑，这样我们可以比年度或半年度更频繁地衡量进度。

---

### (00:36:30) Annie Pearl

**English:**
I think one thing I'll just touch on real fast on is estimations and dates. Something we've done over the last year is really kind of moved to a model of talking about dates and promising and committing to dates that are within our control. And so, if you think about the product development life cycle, we can commit to a discovery effort of doing research around a certain problem space and we can have a general sense of when we know that effort's going to conclude. We don't know if we're going to actually end up going, and based on the results whether we're going to actually move forward with investing in that area, but that's a body of work we can commit to.

**中文翻译:**
我想快速提一下关于估算和日期的问题。去年我们转向了一种模式，即只讨论、承诺和交付我们能够控制的日期。如果你思考产品开发生命周期，我们可以承诺进行针对某个问题领域的“探索”（Discovery）研究，并且对这项工作何时结束有一个大致的了解。我们不知道最终是否会基于结果继续在该领域投资，但这是一项我们可以承诺的工作内容。

---

### (00:37:05) Annie Pearl

**English:**
From there, we then move into, "Okay, if this is something a problem space we want to go after, we're going to go work on a couple different solutions and we're going to go do some user testing and we're going to land on a solution," and that's another sort of phase we can commit to. Then, once we actually have that completed and we actually know not just the problem but the solution, we can do estimation planning and actually have a date for delivery from an engineering perspective. And so, we've gotten a lot better at making the commitments around the work that's right in front of us versus making a commitment around a project six months out when we haven't even done enough discovery, enough design and ideation to have a real clear understanding of estimation.

**中文翻译:**
从那里开始，我们进入下一阶段：“好，如果这是我们要解决的问题领域，我们将研究几种不同的方案，进行用户测试，并最终确定一个方案。”这是另一个我们可以承诺的阶段。一旦完成，当我们不仅知道问题而且知道了方案时，我们就可以进行估算规划，并从工程角度给出一个实际的交付日期。因此，我们现在更擅长对眼前的工作做出承诺，而不是对一个六个月后的项目做出承诺——因为那时我们甚至还没做足够的探索、设计和构思，无法对估算有清晰的了解。

---

### (00:37:43) Lenny

**English:**
That is really cool. Do you have terms for these phases, like these phases you have to get through these kinds of gates? Yeah, how do you describe that?

**中文翻译:**
这真的很酷。你们对这些阶段有专门的术语吗？比如必须通过的某些“关卡”？你是怎么描述的？

---

### (00:37:50) Annie Pearl

**English:**
Yeah, so the first phase we just call generally discovery. The second phase, we call solutioning. The third phase, build. And then, the fourth phase is launch, measure and iterate. And then, we've designed the product development lifecycle around that framework.

**中文翻译:**
是的，第一阶段我们通常称之为“探索”（Discovery）。第二阶段称为“方案设计”（Solutioning）。第三阶段是“构建”（Build）。第四阶段是“发布、衡量与迭代”（Launch, measure and iterate）。我们围绕这个框架设计了产品开发生命周期。

---

### (00:38:04) Lenny

**English:**
So, discovery for example, is that a roadmap item for a quarter and that's like what you've committed to? And if that goes well, the next quarter has the next step.

**中文翻译:**
所以，以“探索”为例，那是某个季度的路线图项吗？那是你们承诺的内容？如果进展顺利，下个季度就进入下一步？

---

### (00:38:12) Annie Pearl

**English:**
Yeah, exactly. You got it.

**中文翻译:**
是的，没错。

---

### (00:38:14) Lenny

**English:**
Sweet. Okay. In terms of the strategy artifacts, how does that look or do you have a Google Doc with a template that you all use? What does that look like? What's interesting about people not working at a company or working at just one company is they only have, strategy documents are really hard to see and see examples of. So, I'm always curious what these looks like. So, whatever you can share about what they look like and where you put them and how long and that kind of thing.

**中文翻译:**
太棒了。关于策略产出物（Artifacts），它们长什么样？你们有统一使用的 Google 文档模板吗？对于不在公司工作或只在一家公司工作的人来说，很难看到策略文档的实例。所以我一直很好奇这些文档长什么样，你们把它们放在哪，有多长，诸如此类。

---

### (00:38:40) Annie Pearl

**English:**
We have a couple of different layers of this. I think the first is this high-level three-year strategy and this is actually called at the company level. So, if the doc, it also has slides that have been presented many times to the company when we're in the process of making sure that, that is part of new hire orientation so that everyone should understand where are we going over the next three years and then therefore how does this year's objectives fit into that.

**中文翻译:**
我们有几个不同的层级。第一层是高层级的三年策略，这实际上是公司层面的。它既有文档，也有在公司内部多次演示过的幻灯片。我们确保将其纳入新员工入职培训中，这样每个人都能理解未来三年的方向，以及今年的目标是如何与之契合的。

---

### (00:39:07) Annie Pearl

**English:**
And then, from there, we've got our product team OKRs. These generally start by docs and we write them in docs. So, they usually get translated into slides at some point for presentation purposes to the company and those are stored centrally in a location and then you get down to the feature level or the project level. And we have different kind of templates for the teams to use based on the type of work that they're going to be doing. And we're a pretty heavy Confluence culture, so we tend to use Confluence as one of the tools for housing and storing information around the work that's being done.

**中文翻译:**
然后，我们有产品团队的 OKR。这些通常始于文档，我们用文档来编写。在某些时候，为了向公司演示，它们会被转化为幻灯片。这些都集中存储在一个地方。再往下就是功能级别或项目级别。我们为团队提供了不同的模板，取决于他们要开展的工作类型。我们有很浓厚的 Confluence 文化，所以我们倾向于使用 Confluence 作为存放和存储工作信息的工具之一。

---

### (00:39:39) Lenny

**English:**
Cool. So, maybe on that topic, what else is in the stack of Calendly product team tools?

**中文翻译:**
酷。顺着这个话题，Calendly 产品团队的工具栈里还有什么？

---

### (00:39:44) Annie Pearl

**English:**
We talked about roadmap planning, some combination of starts with docs, there's mural boards involved. Usually, it ends in slides. Then actually roadmap tracking, we use Aha and we use Airtable collaboration/communication. We use Slack, we use Loom, bug management, we use Jira. Confluence, you mentioned. Pando, we use quite a bit of Pando to help educate users within the product when we're launching new features. Yeah, I think that's the main stack.

**中文翻译:**
我们谈到了路线图规划，通常是文档开头，中间涉及 Mural 画板，最后以幻灯片结束。路线图跟踪方面，我们使用 Aha 和 Airtable。协作和沟通方面，我们使用 Slack 和 Loom。缺陷管理使用 Jira。还有你提到的 Confluence。我们还经常使用 Pando，在发布新功能时帮助引导和教育产品内的用户。是的，我认为这就是主要的工具栈。

---

### (00:40:16) Lenny

**English:**
And docs is Google Docs and slides is Google Slides.

**中文翻译:**
文档用的是 Google Docs，幻灯片用的是 Google Slides。

---

### (00:40:19) Annie Pearl

**English:**
You got it. Yep. That's right.

**中文翻译:**
没错，正是如此。

---

### (00:40:21) Lenny

**English:**
Okay. I'm going to bounce around and go back to growth questions and then I have a couple more product team questions. How did Calendly get their first thousand users?

**中文翻译:**
好的。我要跳跃一下，回到增长问题，然后再问几个关于产品团队的问题。Calendly 是如何获得前 1000 名用户的？

---

### (00:40:30) Annie Pearl

**English:**
A great question and I had to fact check it with my CEO earlier this morning, but there's actually a few really interesting things about this story and a few things that Tope did in the early days to get 2,000 users. So, for those who aren't familiar Tope, our CEO and founder started his career in sales and he spent lots of years in sales. And so, he was very used to the challenges of trying to organize external meetings with prospective customers. So, he knew the problem space really, really well. And he had evaluated all the scheduling solutions that were on the market and came to conclusion that there really weren't any great products out there and especially there weren't any great products for the recipient of the actual booking service.

**中文翻译:**
这是一个好问题，今天早上我还特意向我们的 CEO 核实了一下。关于这个故事有几个非常有趣的点，以及 Tope（我们的 CEO 兼创始人）在早期为了获得前 2000 名用户所做的一些事。对于不熟悉 Tope 的人来说，他职业生涯始于销售，并做了很多年。所以他非常熟悉与潜在客户安排外部会议的挑战。他非常了解这个领域的问题。他评估了市场上所有的预约方案，得出的结论是：市面上真的没有好的产品，尤其是对于预约服务的接收者（Recipient）来说，没有好的产品。

---

### (00:41:23) Annie Pearl

**English:**
And so, I think he saw this as an opportunity for disruption. So, he raided his 401k, he took out all his savings. He didn't make raise any money. And he hired an outside development firm actually in out of the Ukraine to build the first version of Calendly. So, that's the background on Calendly. Why it's important is that the first 10 users were actually customer success agents at a company in the education space that contracted with the same firm that Tope was using to build Calendly. So, he really found his first set of users through the firm that he was using to build the product.

**中文翻译:**
因此，他认为这是一个颠覆的机会。于是他动用了自己的 401k 退休金，拿出了所有积蓄。他当时没有融资。他聘请了一家位于乌克兰的外部开发公司来构建 Calendly 的第一个版本。这就是背景。之所以重要，是因为前 10 名用户实际上是一家教育领域公司的客户成功（CS）专员，而那家公司恰好也雇佣了 Tope 用来开发 Calendly 的那家外包公司。所以，他实际上是通过帮他开发产品的公司找到了第一批用户。

---

### (00:41:51) Annie Pearl

**English:**
And then, those CSMs or customer success managers were actually using Calendly to schedule calls with parents in K through 12 education. And so, then those parents started using Calendly for their own parent-teacher conference scheduling. And then from there, the school started using it and then all the parents within the school started using it for lots of other use cases and it grew organically from there. So that was one piece.

**中文翻译:**
然后，那些客户成功经理（CSM）开始使用 Calendly 与 K-12 教育阶段的家长预约通话。接着，那些家长开始使用 Calendly 来安排他们自己的家长会。再然后，学校开始使用它，学校里的所有家长也开始将其用于许多其他场景，它就这样有机地增长起来了。这是其中一个环节。

---

### (00:42:17) Annie Pearl

**English:**
I think the other piece that's really important is that he started off by just having a free tier. The entire product was free. Some of this came from honestly not being able to actually build the billing infrastructure that would be required to actually charge. So, it came a little bit out of necessity, but it was also free. So not only was it a better product than the alternatives out there, but it was also free. So, the combination of the viral loop and coming in through getting those first 10 users as part of the firm he was using and then the free aspect or I think what led to the first 2,000, and then 10,000, and millions of users from there.

**中文翻译:**
我认为另一个非常重要的点是，他一开始只提供免费层级。整个产品都是免费的。老实说，这部分是因为当时还没能力构建收费所需的计费基础设施。所以这有点出于无奈，但它确实是免费的。因此，它不仅比市面上的替代品更好，而且还是免费的。病毒式循环、通过外包公司获得前 10 名用户，再加上免费策略，我认为这些共同促成了前 2000 名用户，随后是 1 万名，直到现在的数百万用户。

---

### (00:42:52) Lenny

**English:**
That is crazy. I have never heard a story like that where the team that is building your product ends up being the source of initial growth.

**中文翻译:**
太疯狂了。我从未听过这样的故事：帮你开发产品的团队竟然成了你最初增长的源头。

---

### (00:42:58) Annie Pearl

**English:**
I know, pretty crazy.

**中文翻译:**
我知道，确实挺疯狂的。

---

### (00:43:00) Lenny

**English:**
Oh my God. So many nice things happening in this history of Calendly. And wow, in Ukraine. So, I'm actually from Ukraine.

**中文翻译:**
天哪。Calendly 的历史上发生了这么多好事。而且，哇，在乌克兰。其实我就是乌克兰人。

---

### (00:43:08) Annie Pearl

**English:**
Oh nice. That's awesome. They're great.

**中文翻译:**
噢，太棒了。他们很优秀。

---

### (00:43:11) Lenny

**English:**
Yeah, and it's also interesting that it's rare that you hear a successful business starts with contractor engineers. I think OICs are like, "Do not do that." So that's a cool counter example of it can actually work out, especially if they're your first users and spread it to others.

**中文翻译:**
是的，而且很有趣的是，很少听说成功的业务是从外包工程师开始的。我想很多风投（VC）都会说：“千万别那么做。”所以这是一个很酷的反例，证明这确实可行，尤其是当他们成为你的第一批用户并向外传播时。

---

### (00:43:27) Annie Pearl

**English:**
And we still work with them. They're fantastic and they have incredible engineers, so they're still part of our culture, which is great.

**中文翻译:**
我们现在仍然和他们合作。他们非常棒，拥有出色的工程师，所以他们仍然是我们文化的一部分，这很好。

---

### (00:43:32) Lenny

**English:**
So, Calendly got big in Ukraine, it sounds like initially.

**中文翻译:**
所以听起来，Calendly 最初是在乌克兰火起来的。

---

### (00:43:35) Annie Pearl

**English:**
There you go. There you go.

**中文翻译:**
可以这么说。

---

### (00:43:37) Lenny

**English:**
What's something that would surprise people in terms of how Calendly grows today or grew through its history?

**中文翻译:**
关于 Calendly 现在的增长方式或历史增长过程，有什么会让人们感到惊讶的吗？

---

### (00:43:43) Annie Pearl

**English:**
Most people probably think about Calendly as the scheduling link and really for individual users to reduce the back and forth of email and scheduling. So, they think of that one-on-one use case and I think people would be surprised to learn that our team's business, so multiple users in an organization who want to collaboratively schedule together is growing much faster than our solo user business. And that's really where the future of where we think growth will come from is supporting these teams of users who are in externally facing roles and selling into departments and supporting multi-departmental deployments of Calendly across an entire organization.

**中文翻译:**
大多数人可能认为 Calendly 只是一个预约链接，主要是为了让个人用户减少邮件往返和预约的麻烦。他们想到的是一对一的场景。但我认为人们会惊讶地发现，我们的团队业务（即组织内多个用户希望协作预约）的增长速度远快于个人用户业务。我们认为未来的增长点在于支持这些面向外部角色的用户团队，向部门销售，并支持 Calendly 在整个组织内的多部门部署。

---

### (00:44:17) Annie Pearl

**English:**
So, I think it's still really well known as this solo user tool to eliminate the back and forth of email, but the growth of what we're seeing and where we think it's going to go is actually more teams of users and departments of users and then multiple departments in an organization.

**中文翻译:**
所以，虽然它仍以消除邮件往返的个人工具而闻名，但我们看到的增长趋势以及我们认为的未来方向，实际上是更多的用户团队、部门用户，以及组织内的多个部门。

---

### (00:44:32) Lenny

**English:**
It's interesting when you hear the story of Calendly that just has so many good things happening, basically for free, it's just grows so well. I think people don't realize you eventually will, that'll slow down, it'll taper off eventually. You'll need to drive growth very actively in these new ways that you're describing. And I think people don't often realize that they just wanted to find something that was viral and then things are going to go great, but it tapers off.

**中文翻译:**
听 Calendly 的故事很有趣，发生了这么多好事，基本上是免费增长，而且长势喜人。但我认为人们没意识到，增长最终会放缓，会进入平台期。你需要通过你描述的这些新方式非常主动地推动增长。人们往往没意识到，他们只想找个能病毒式传播的东西，然后觉得一切都会顺风顺水，但其实增长是会逐渐减弱的。

---

### (00:44:54) Annie Pearl

**English:**
Yeah. I mean, there's only so many people who, solo users who are going to pull out a credit card. And I think once you also get to hundreds of millions of dollars of revenue scale, just the law of large numbers, it means that growth will slow. And so, you have to figure out where's that next growth curve going to come from. I think the beauty of Calendly is that while we certainly have built features and functionality to support teams and departments, we got pulled there. It wasn't one of those things where we sort of said, "We need to find our next growth lever. Let's go build X." Our customers really pulled us there by the way that they were using the product.

**中文翻译:**
是的。我的意思是，愿意掏信用卡的个人用户数量是有限的。当你达到数亿美元的营收规模时，根据大数定律，增长必然会放缓。所以你必须弄清楚下一个增长曲线从哪里来。Calendly 的妙处在于，虽然我们确实构建了支持团队和部门的功能，但我们是被“拉”到那里的。这并不是那种我们说“我们需要寻找下一个增长杠杆，去做 X 吧”的情况。是我们的客户通过他们使用产品的方式，真正把我们拉到了那个领域。

---

### (00:45:30) Annie Pearl

**English:**
And so again, a very fortunate position to be in, but when you can see in the data and see how customers are using it, that they want to be working on scheduling with their teams, that was our early sign, that's where the business was going to go in the future.

**中文翻译:**
所以，这又是一个非常幸运的处境。但当你能从数据中看到客户是如何使用它的，看到他们想和团队一起协作预约时，那就是早期的信号，预示着业务未来的走向。

---

### (00:45:46) Lenny

**English:**
I don't think I mentioned this, I'm paying user of Calendly. It's what I use for booking these podcast episodes. You got me. I think I started when it was totally free and I was like, "How will they ever make money?" This is too much power.

**中文翻译:**
我好像没提过，我是 Calendly 的付费用户。我就是用它来预约这些播客节目的。你赢了。我记得我开始用的时候它还是完全免费的，我当时想：“他们到底怎么赚钱啊？”这功能太强大了。

---

### (00:45:56) Annie Pearl

**English:**
And then, now, you learned that it was free almost by accident.

**中文翻译:**
而现在，你了解到它当初免费几乎是出于偶然。

---

### (00:46:02) Lenny

**English:**
Yep. I was like, "Yeah, please take my money. This makes my life easier." What are some fun or unique traditions and cultural kind of components of the Calendly product team?

**中文翻译:**
是的。我当时想：“拿走我的钱吧，这让我的生活轻松多了。”Calendly 产品团队有哪些有趣或独特的传统和文化元素？

---

### (00:46:12) Annie Pearl

**English:**
A couple of fun ones I thought we could talk about. One, we have a meeting called OPA, which stands for opportunity/problem, assessment. And so, what this is, it's a meeting where basically PMs, I don't even go to it's a meeting for PMs to really debate and discuss with each other and spar around either areas and problems that they want to go investigate or after they've gotten data back or research back from evaluating an opportunity, deciding whether we actually want to move forward and go try to develop a solution. It's really in the product development lifecycle of letting product managers really get into a room with each other on a frequent basis and just think through things, debate, discuss. And I know that they all get a lot of value out of that.

**中文翻译:**
我们可以聊几个有趣的。第一，我们有一个叫 OPA 的会议，代表“机会/问题评估”（Opportunity/Problem Assessment）。这是一个基本上只有 PM 参加的会议，我甚至都不参加。PM 们在会上互相辩论、讨论，围绕他们想要调查的领域和问题进行切磋；或者在评估某个机会并获得数据或研究反馈后，决定是否真的要推进并开发方案。这属于产品开发生命周期的一部分，让 PM 们能经常聚在一起，深入思考、辩论和讨论。我知道他们都从中获益匪浅。

---

### (00:46:59) Lenny

**English:**
It reminds me of something just like a bad version of that. I had a friend who was a PM at Zynga and he said there's a meeting where PMs present their plans to all the other PM. It was like you're in a shark tank where everyone's coming to destroy you. They just point out all the problems. That's all it ever is in this.

**中文翻译:**
这让我想起了一个反面教材。我有个朋友曾在 Zynga 做 PM，他说那里有个会，PM 要向所有其他 PM 展示计划。那就像进了“鲨鱼池”，每个人都想把你撕碎，他们只会指出所有的问题。那个会永远都是那样。

---

### (00:47:15) Annie Pearl

**English:**
I would say on this one, it's the opposite where I feel like everyone really needs the meeting. They're like, "Ugh, I really need to take this to OPA because I need to, I'm working through these problems and I really want to bounce it off of other people." So, I could imagine a world where it would be that. Actually, part of the reason I don't go to the meeting is that I really want everyone to be able to be open and transparent and provide feedback and not feel like there's any judgment from me or any needing to act a certain way because I'm in the room. So, that's sort of why I intentionally don't go.

**中文翻译:**
我想说，我们的 OPA 会议恰恰相反，我觉得每个人都非常需要这个会。他们会说：“呃，我真的需要把这个带到 OPA 上，因为我正在处理这些问题，非常想听听别人的意见。”我可以想象那种充满敌意的会议，但我之所以不参加，是因为我真心希望每个人都能开放透明地提供反馈，而不会觉得我在场会有所评判，或者因为我在场而不得不表现得某种样子。这就是我刻意不参加的原因。

---

### (00:47:44) Annie Pearl

**English:**
Another fun one we do is something we call competitive work gaming. So, on some sort of time interval, sometimes it's been quarterly, we'll have assigned people into groups for the quarter to own a competitor. And their job is to essentially spend a lot of time immersing themselves into the product of the competitor, really trying to think through the lens of, do a SWAT analysis, really try to think through the lens of where's this competitor going and how Calendly only think about that and as it relates to our strategy.

**中文翻译:**
另一个有趣的是我们称之为“竞争博弈”（Competitive war gaming）的活动。我们会定期（有时是每季度）将人员分组，每组负责研究一个竞争对手。他们的任务是花大量时间沉浸在竞争对手的产品中，进行 SWOT 分析，尝试从对方的角度思考：这个竞争对手的发展方向是什么？Calendly 应该如何看待这一点？这与我们的策略有什么关系？

---

### (00:48:12) Annie Pearl

**English:**
And so, we spent a quarter doing that and then we have the competitive war gaming day where every team comes and presents and there's prizes and it's a lot of fun, but it's a really great way to stay on top of what's happening across the market without requiring every product manager designer to be deep in the weeds, there are a lot of different competitors. We can bring all of that knowledge together through what we call competitive work gaming.

**中文翻译:**
我们会花一个季度做这件事，然后举行“竞争博弈日”，每个团队都会来展示，还有奖品，非常有趣。这是一种了解市场动态的绝佳方式，不需要每个 PM 或设计师都深陷于研究每一个竞争对手。我们可以通过这种方式把所有的知识汇集在一起。

---

### (00:48:34) Lenny

**English:**
That is cool. It's really impressive how you do these exercises and they seem really positive and friendly and constructive. It sounds like there is a pretty unique culture at Calendly. I'm curious if there's anything else that's core to the values or the way that you think about the principles of building product at Calendly.

**中文翻译:**
这很酷。你们开展这些活动的方式非常积极、友好且富有建设性，这令人印象深刻。听起来 Calendly 有一种非常独特的文化。我很好奇，在 Calendly 构建产品的原则或核心价值观中，还有什么其他核心内容吗？

---

### (00:48:51) Annie Pearl

**English:**
What I touched on earlier is really core to how we build product, which is honing in on this target user and honing in on our target market. I do think it's quite rare. I think in most organizations that I've seen, I think there's a desire to do that. But I think, again, when it push comes to shove, it's really hard for executives to make decisions that say no to things. One of Calendly's actually core principles is focus wisely. It's pretty deeply embedded into our culture.

**中文翻译:**
我之前提到的内容确实是我们构建产品的核心，即精准锁定目标用户和目标市场。我认为这相当罕见。在我见过的多数组织中，大家都有这种愿望，但到了关键时刻，高管们很难做出说“不”的决定。Calendly 的核心原则之一是“明智聚焦”（Focus wisely）。这深深植根于我们的文化中。

---

### (00:49:29) Annie Pearl

**English:**
And so, I think one of the reasons that I've been successful in being able to create the clarity around who the target personas are is because I think it's embedded into the culture of Calendly to focus wisely. So, I don't know that it'll work in every organization. I think many organizations really struggle to say no, and they're always adding more onto the plate versus taking off. But I do think from an ethos perspective, there is something around focusing and the ability to focus to therefore deliver the highest quality of product that you can to your target customers. That is unique and I think it starts with some of the broader cultural paradigms that exist at the company and then we've now embedded that into the way we think about how we build product.

**中文翻译:**
我认为我之所以能成功明确目标画像，原因之一就是“明智聚焦”已经融入了 Calendly 的文化。我不确定这在每个组织都行得通。许多组织很难说“不”，他们总是在增加任务而不是减少。但我确实认为，从精神层面来看，专注以及专注的能力能让你为目标客户提供最高质量的产品。这是独特的，我认为它始于公司更广泛的文化范式，而我们现在已将其嵌入到我们构建产品的思维方式中。

---

### (00:49:59) Lenny

**English:**
Is there anything else you do to instill that? It sounds like it's a core value. Do you put posters around the office? So how else do you keep people focused?

**中文翻译:**
为了贯彻这一点，你还做了什么？听起来这是核心价值观。你们会在办公室贴海报吗？还有什么办法让大家保持专注？

---

### (00:50:06) Annie Pearl

**English:**
We're a fully remote company. So, now you've got my brain going on. Are there some sort of virtual sticky notes that you could get people to put onto their laptops to remind them? Backgrounds to show us [inaudible 00:50:16]. Yeah, exactly. Yeah, it's embedded into a lot of the documentation. So, it's embedded into the templates that I talked about in terms of, everything from sort of the way we structure that OPA, document that folks are going to be working on and debating too when they go to create the actual sort of PRD.

**中文翻译:**
我们是一家完全远程办公的公司。所以你让我想到了：有没有什么虚拟便签可以让大家贴在笔记本电脑上提醒自己？或者背景图？没错。它被嵌入到了大量的文档中。比如我提到的模板，从 OPA 文档的结构，到大家在编写实际 PRD（产品需求文档）时的辩论过程。

---

### (00:50:50) Annie Pearl

**English:**
When teams come in to present as part of our product reviews, we have a template that keeps reinforcing who's the target customer, who's the target user within that customer base, what are their needs and then how are we going to solve their needs better than any alternative that there is on the market. So, I think there's lots of different reinforcing mechanisms to that focus.

**中文翻译:**
当团队在产品评审中进行演示时，我们的模板会不断强化：谁是目标客户？该客户群中的目标用户是谁？他们的需求是什么？以及我们打算如何比市场上的任何替代方案更好地解决他们的需求？所以，我认为有很多不同的强化机制来维持这种专注。

---

### (00:50:57) Lenny

**English:**
I feel like sometimes things like that come from a big problem the company had and then you index weigh the other side, focus, here's the four people we all build for. It becomes instilled in the culture.

**中文翻译:**
我觉得有时这类事情源于公司曾经遇到的重大问题，然后你们就走向了另一个极端：聚焦，明确我们要为哪四类人构建产品。这随后就融入了文化。

---

### (00:51:08) Annie Pearl

**English:**
And I think you're right. I mean, because Calendly started as such a horizontal product, which was amazing because that's how it grew so virally and so it had the entry, the wedge into scheduling and how our first horizon and becoming the best horizontal scheduling automation platform was because we had that horizontal focus. And so, it was a blessing. But as we think about transitioning to horizon two, which is really about deepening our support for these teams and departmental users as well as verticals, that's I think the inflection point where we said, in order to shift us from horizon one to horizon two, we need to be making some real trade off decisions and we need to create this focus so that we can actually allow teams to go do that.

**中文翻译:**
我想你是对的。Calendly 最初是一个非常横向的产品，这很棒，因为它实现了病毒式增长，成为了进入预约领域的切入点。我们的第一阶段目标是成为最好的横向预约自动化平台，这正是因为我们当时有那种横向的关注点。那是一种福分。但当我们考虑转向第二阶段——即深化对团队、部门用户以及垂直领域的支持时，我认为那就是转折点。我们意识到，为了从第一阶段跨越到第二阶段，我们需要做出真正的权衡决策，必须建立这种聚焦，以便让团队能够真正去执行。

---

### (00:52:07) Lenny

**English:**
Before Calendly, you were at Box. Before that, you were at Glassdoor. I'm going to ask two different questions. You could pick which direction you want to go. What would you say are the biggest differences culturally between these three? If you had to bucket, here's how I'd describe Glassdoor, Box, Calendly. Or what did you take from those two places that you bring with you to Calendly and future opportunities?

**中文翻译:**
在 Calendly 之前，你在 Box 工作，再之前在 Glassdoor。我要问两个不同的问题，你可以选一个回答。你会如何描述这三家公司在文化上的最大差异？如果你要归类，你会如何描述 Glassdoor、Box 和 Calendly？或者，你从那两家公司带走了什么经验，应用到了 Calendly 和未来的机会中？

---

### (00:52:27) Annie Pearl

**English:**
I love this question. So, they're all different, which is why I just feel so fortunate to have had experiences that were all quite different. So, starting with Box, maybe I'll take your second question. Box, when I joined, we were in the process of moving up market and trying to capture as much enterprise market share as possible, and I was on the enterprise product management team. So, I spent a lot of time, as I mentioned earlier, talking to customers. And in my first year in particular trying to ramp on the business.

**中文翻译:**
我很喜欢这个问题。它们各不相同，所以我感到非常幸运能拥有这些截然不同的经历。从 Box 开始，也许我来回答你的第二个问题。我加入 Box 时，我们正处于向高端市场进军、努力获取尽可能多企业市场份额的过程中，而我当时在企业产品管理团队。正如我之前提到的，我花了大量时间与客户交谈。尤其是在第一年，我努力熟悉业务。

---

### (00:53:07) Annie Pearl

**English:**
And I'd say my biggest learning during that time was around how to ask the right questions to really understand the why behind what a customer was asking for and then figuring out how to build a solution to their problem that would also meet the needs of a broader swath of customers. It became very clear early to me if I would just go build what customer A wanted and what customer B wanted and the customer C wanted, not only would that be wasted effort to do it three times, but more importantly, what they wanted me to go build was going to have a negative impact on the end user experience. And preserving that end user experience was so critical. So, learning how to ask the right questions to understand the actual problem and then build the solution that's going to be most scalable to that problem set across lots of customers was probably my biggest learning from Box.

**中文翻译:**
在那段时间里，我最大的收获是学会了如何提出正确的问题，以真正理解客户需求背后的“为什么”，然后思考如何构建一个既能解决他们问题、又能满足更广泛客户需求的方案。我很早就明白，如果我只是去构建客户 A、B、C 分别想要的东西，不仅是重复劳动的浪费，更重要的是，他们让我构建的东西往往会对最终用户体验产生负面影响。而保护用户体验至关重要。所以，学会通过提问理解真实问题，并构建一个能跨客户扩展的方案，是我在 Box 学到的最重要的东西。

---

### (00:53:37) Annie Pearl

**English:**
Moving to Glassdoor, totally different business model. Glassdoor is actually really more of a consumer business and 60 million unique users go to Glassdoor every month and it's a marketplace between job seekers and employers and it's highly, highly dependent on the consumer engagement, growing traffic, getting that traffic to come and engage and apply to jobs. And so, during my time as CPO there, I was responsible now for both sides of that marketplace, the consumer business and the B2B. And so, I learned all about how do you build PR consumer products, how do you think about optimization of a funnel? How do you think about building up a growth team and growth as a discipline? How do you use data and AB testing to make decisions?

**中文翻译:**
转到 Glassdoor，商业模式完全不同。Glassdoor 实际上更像是一家 C 端（消费者）业务，每月有 6000 万独立用户访问，它是一个连接求职者和雇主的双边市场，高度依赖用户参与、流量增长以及引导流量进行互动和申请职位。在我担任 CPO 期间，我负责市场的两端：C 端业务和 B2B 业务。我学到了如何构建 C 端产品，如何思考漏斗优化，如何建立增长团队并将增长作为一门学科，以及如何利用数据和 AB 测试来做决策。

---

### (00:54:17) Annie Pearl

**English:**
So, I think that kind of consumer mentality and how you approach product, I then have brought with me to Calendly, which is really a blend of both, right? Calendly is first, as we've talked about a PLG business and it looks a lot more like a consumer business like Glassdoor. And then, it's got this direct selling business that looks a lot more like Box's enterprise business. So, I think I've been able to take kind of lessons learned from both Box and Glassdoor and apply them together to Calendly.

**中文翻译:**
所以，这种 C 端思维和产品方法论被我带到了 Calendly。Calendly 实际上是两者的结合：它首先是一个 PLG 业务，看起来很像 Glassdoor 那样的 C 端业务；同时它又有直销业务，看起来很像 Box 的企业级业务。因此，我能够将从 Box 和 Glassdoor 学到的经验结合起来，应用到 Calendly 中。

---

### (00:54:43) Lenny

**English:**
What a cool set of experiences. I'm trying to imagine you using all three in the same day. Sending a Calendly, storing your files in a Box and looking at reviews... and recruiting. Yeah, yeah. Not looking for anything new. Okay. Final question. You are part of something called the Skip community, which I believe Nikhyl and a few people run. And so, I'd love to just hear a little bit about that and maybe how folks can join if they might be a fit.

**中文翻译:**
真是一组很酷的经历。我在想象你同一天使用这三种产品：发一个 Calendly 链接，把文件存进 Box，然后查看公司评价……还有招聘。当然，不是在找新工作。好，最后一个问题。你是 Skip 社区的一员，我相信那是 Nikhyl 和几个人运营的。我很想听听关于它的情况，以及如果合适的话，大家该如何加入。

---

### (00:55:08) Annie Pearl

**English:**
Yeah, as you mentioned about two years ago, Nikhyl, who was the former CPO of Credit Karma and is now a VP of product at Meta, got a small group of CPOs together who were all going through similar phases of companies' growth, late stage growth companies, and we all were facing the same challenges in our roles. And he formalized this community as a way to help us gather advice from one another, talk through how to manage challenges we're facing and just make us more successful in the roles. And we always joke, we're like the support group.

**中文翻译:**
是的。正如你提到的，大约两年前，Nikhyl（曾任 Credit Karma 的 CPO，现任 Meta 产品副总裁）召集了一小群 CPO。我们所在的公司都处于类似的增长阶段（后期增长型公司），在岗位上面临着相同的挑战。他将这个社区正式化，作为一种帮助我们互相获取建议、讨论如何应对挑战并让我们在岗位上更成功的途径。我们总开玩笑说，我们就像个“互助小组”。

---

### (00:55:37) Annie Pearl

**English:**
We meet on Sundays and it has been incredibly valuable as I've sort of gone through the last couple of years in my role at Calendly. Since then, we've grown the group to about 23 heads of products and CPOs and expanded the charter a bit, which I think is interesting to help product leaders not just be successful in their current role, but also how to think about setting them up for success in the role after this.

**中文翻译:**
我们每周日见面。在我担任 Calendly 职位的这两年里，这对我来说非常有价值。从那时起，我们将规模扩大到了约 23 位产品负责人和 CPO，并稍微扩展了章程。我觉得很有趣的一点是，它不仅帮助产品领导者在当前职位上取得成功，还帮助他们思考如何为下一个职位做好准备。

---

### (00:55:59) Annie Pearl

**English:**
And so, we're experimenting with a couple of different interesting ways to help product leaders grow. One of them is we're actually partnering with some companies right now to experiment with how can we help them as they're looking to make their first head of product hire or their first C O hire really hone in on what they're looking for and partnering with the talent partners we know to really help try to increase the success that they find the right candidates. That's something interesting we're doing.

**中文翻译:**
所以，我们正在尝试几种不同的有趣方式来帮助产品领导者成长。其中之一是，我们目前正与一些公司合作，尝试在他们寻找第一位产品负责人或第一位 CPO 时，帮助他们明确需求，并与我们认识的人才合作伙伴配合，提高他们找到合适人选的成功率。这是我们正在做的一件有趣的事。

---

### (00:56:23) Annie Pearl

**English:**
We also recently launched a podcast covering some topics like, how do you manage the next job search, how do you avoid burnout, breaking down things like equity, and other kind of timely topics. And then also, we just have an active Discord server where we've got all sorts of channels from topics, how to manage the CEO/CPO partnership, compensation, even sharing planning, even sharing some advising opportunities or other CPO roles that kind of come across our radar.

**中文翻译:**
我们最近还推出了一个播客，涵盖了诸如“如何管理下一次求职”、“如何避免职业倦怠”、解析股权等时下热门话题。此外，我们还有一个活跃的 Discord 服务器，里面有各种频道，讨论如何管理 CEO/CPO 伙伴关系、薪酬、甚至分享规划方案，以及分享一些顾问机会或我们关注到的其他 CPO 职位。

---

### (00:56:53) Annie Pearl

**English:**
So, it's been a really, really cool kind of experiment to see how the power of the community. And I know Lenny, you do a ton of stuff around community, how that has helped all of us. I think it's just more effective in our roles and feel like we have a group of people who are behind us supporting us during what is a very hard role.

**中文翻译:**
所以，看到社区的力量是一次非常酷的尝试。Lenny，我知道你也围绕社区做了很多工作。社区帮助我们所有人更有效地履行职责，让我们觉得在这个非常艰难的岗位上，有一群人在背后支持着我们。

---

### (00:57:11) Lenny

**English:**
I love this. I imagine when people look at a CPO, they imagine they just know everything already. They have a bunch of friends in the same role, but I think in reality, it's a lonely role a lot of times. And so, I could see the power of something like this just to help people understand who'd be a good fit for this, how do they go find it and yeah, it's like the [inaudible 00:57:33].

**中文翻译:**
我喜欢这个。我想当人们看向 CPO 时，会觉得他们已经无所不知，并且有一堆同行的朋友。但现实中，这往往是一个孤独的角色。所以我能看到这种社区的力量，它能帮助人们理解谁适合这个职位，如何找到它，就像是……

---

### (00:57:33) Annie Pearl

**English:**
The best thing to do is just follow the Skip community on LinkedIn. And then, we're targeting head of products, call it series B, C and beyond, up to late stage growth companies and up to CPOs. So, I'd say start by following the Skip community and if you see folks in there who are in the group, reach out to them to get a sense of what it's like and what it would be like to join.

**中文翻译:**
最好的办法就是在 LinkedIn 上关注 Skip 社区。我们的目标受众是 B 轮、C 轮及以后，直到后期增长型公司的产品负责人和 CPO。所以，我建议先关注 Skip 社区，如果你看到里面有认识的人，可以联系他们，了解一下加入这个社区是什么感觉。

---

### (00:57:57) Lenny

**English:**
And then, it sounds like if you're a company hiring a CPO, maybe reach out too.

**中文翻译:**
听起来，如果一家公司正在招聘 CPO，也许也可以联系你们。

---

### (00:58:00) Annie Pearl

**English:**
Yeah, that'd be great. That'd be great. Yeah.

**中文翻译:**
是的，那太好了。

---

### (00:58:03) Lenny

**English:**
Okay. And they do that by going to LinkedIn also and looking for the Skip community?

**中文翻译:**
好的。他们也是通过 LinkedIn 搜索 Skip 社区吗？

---

### (00:58:06) Annie Pearl

**English:**
Yeah, that'd be great.

**中文翻译:**
是的，那样很好。

---

### (00:58:07) Lenny

**English:**
Okay, cool. We'll put all the links in the show notes as well. Well, with that, we've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
好的，酷。我们也会把所有链接放在节目笔记里。那么，我们进入了非常令人兴奋的闪电问答环节。我有六个问题要问你，准备好了吗？

---

### (00:58:15) Annie Pearl

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### (00:58:17) Lenny

**English:**
What are two or three books that you recommend most to other people?

**中文翻译:**
你最推荐给别人的两三本书是什么？

---

### (00:58:20) Annie Pearl

**English:**
Playing to Win, so, I reference that one earlier, Good to Great, and Hooked.

**中文翻译:**
《赢在策略》（Playing to Win），我之前提到过；《从优秀到卓越》（Good to Great）；还有《上瘾》（Hooked）。

---

### (00:58:25) Lenny

**English:**
Awesome. What's a favorite other podcast that you enjoy other than maybe this podcast?

**中文翻译:**
太棒了。除了本播客，你还喜欢听哪个播客？

---

### (00:58:30) Annie Pearl

**English:**
I think I got introduced to you by Harry from the 20VC, I think. But if not, either way, I'll cross promote his podcast, which is a great one.

**中文翻译:**
我想我是通过 20VC 的 Harry 认识你的。如果不是的话，无论如何，我也要交叉推广一下他的播客，那是一个非常棒的节目。

---

### (00:58:39) Lenny

**English:**
Yeah, Harry's responsible for this podcast. I was on his podcast and he's like, "Lenny, you should be [inaudible 00:58:43]". You got to do it. He's the godfather of this podcast.

**中文翻译:**
是的，Harry 对这个播客的诞生负有责任。我上过他的节目，他说：“Lenny，你应该自己做一个。”他是这个播客的教父。

---

### (00:58:48) Annie Pearl

**English:**
He is. That's great.

**中文翻译:**
他是的，太棒了。

---

### (00:58:49) Lenny

**English:**
What's a favorite recent movie or TV show? And you cannot say White Lotus.

**中文翻译:**
最近最喜欢的电影或电视剧是什么？不许说《白莲花度假村》（White Lotus）。

---

### (00:58:53) Annie Pearl

**English:**
I have two young kids. So, whether I like it or not, Sing 2. It's a great movie, especially if you have young children.

**中文翻译:**
我有两个年幼的孩子。所以不管我喜不喜欢，《欢乐好声音 2》（Sing 2）。这是一部很棒的电影，尤其是如果你有小孩的话。

---

### (00:59:00) Lenny

**English:**
Sing 2. So, it's like the second of Sing?

**中文翻译:**
《欢乐好声音 2》，也就是第一部的续集？

---

### (00:59:03) Annie Pearl

**English:**
It is. It is. Distinct from Sing 1. Sing 2 is better.

**中文翻译:**
是的。它和第一部不同，《欢乐好声音 2》更好看。

---

### (00:59:07) Lenny

**English:**
It's better. Okay, cool. I haven't seen it.

**中文翻译:**
更好看？好吧，酷。我还没看过。

---

### (00:59:10) Annie Pearl

**English:**
I would hope you haven't.

**中文翻译:**
我希望你没看过（除非你有娃）。

---

### (00:59:11) Lenny

**English:**
Okay, cool. Favorite interview question that you like to ask people you interview.

**中文翻译:**
好的。你在面试别人时最喜欢问的问题是什么？

---

### (00:59:15) Annie Pearl

**English:**
Talk me through your biggest product flop. What happened and what did you do about it?

**中文翻译:**
跟我聊聊你经历过的最大的产品失败。发生了什么，你是如何处理的？

---

### (00:59:21) Lenny

**English:**
What do you look for in an answer? What's a sign of something good in their answer?

**中文翻译:**
你希望在回答中听到什么？什么样的回答是好的信号？

---

### (00:59:24) Annie Pearl

**English:**
People being brutally honest around how bad it was and why it failed. The rest of the interview, they're trying to tell you all the wonderful things they did and all the accomplishments they had. And so, I think the rawer the answer in terms of how bad it was and why, the better.

**中文翻译:**
我希望人们能坦诚地说明当时有多糟糕以及为什么失败。在面试的其他时间里，他们都在努力告诉你他们做了多少了不起的事，取得了多少成就。所以，我认为关于失败原因和惨烈程度的回答越真实、越不加修饰越好。

---

### (00:59:38) Lenny

**English:**
Awesome. Next question. I think, you might have answered, what are top five SaaS products you use day-to-day, either at work or home, whatever?

**中文翻译:**
太棒了。下一个问题，我想你可能已经部分回答过了：你日常（无论工作还是生活）最常用的五个 SaaS 产品是什么？

---

### (00:59:46) Annie Pearl

**English:**
Slack, Miro, Loom, Pendo, and Confluence.

**中文翻译:**
Slack、Miro、Loom、Pendo 和 Confluence。

---

### (00:59:51) Lenny

**English:**
Awesome. And these are actually, unlike other people's answers, so that's really interesting. Kind of a unique stack you got there.

**中文翻译:**
太棒了。这些答案和其他人的不太一样，很有趣。你的工具栈挺独特的。

---

### (00:59:57) Annie Pearl

**English:**
I love it.

**中文翻译:**
我很喜欢。

---

### (00:59:58) Lenny

**English:**
Final question. What's your best Calendly Pro tip?

**中文翻译:**
最后一个问题。你最好的 Calendly 专业技巧是什么？

---

### (01:00:01) Annie Pearl

**English:**
Yeah, so we just launched a new feature that I'm loving personally called Customized Once and Share. So, this really allows you to make changes on the fly to an event type and tweak things like title or duration or override a date based on the person you're actually sending it to without having to go create a brand new event type just to make one small change based on the recipient. So, it's that one-off use case where you need to make a little bit of a change on the fly depending on who you're sending it to, but you don't want to go through the effort of creating a brand-new event type. So, I'm loving it and you should check it out.

**中文翻译:**
是的，我们刚发布了一个我个人非常喜欢的新功能，叫做“单次自定义并分享”（Customized Once and Share）。它允许你根据发送对象即时修改事件类型，调整标题、时长或覆盖日期，而不需要为了一个收件人的小需求去创建一个全新的事件类型。这非常适合那种需要根据对方情况做微调的临时场景。我很喜欢这个功能，你应该试试。

---

### (01:00:34) Lenny

**English:**
That is awesome. I need that. I find that I need to block dates out and change times and I just like go do that on my calendar, in my Calendly.

**中文翻译:**
太棒了，我正需要这个。我发现我经常需要屏蔽某些日期或更改时间，我以前只能在我的日历或 Calendly 后台里改。

---

### (01:00:42) Annie Pearl

**English:**
There you go there.

**中文翻译:**
现在你可以直接用了。

---

### (01:00:43) Lenny

**English:**
All right. Annie, this was amazing. We learned a ton about Calendly growth product building. Two final questions. Where can people find you online if they want to learn more and reach out, maybe ask some questions. And two, how can listeners be useful to you?

**中文翻译:**
好的。Annie，这太精彩了。我们学到了很多关于 Calendly 增长和产品构建的知识。最后两个问题：如果人们想了解更多或联系你问问题，可以在哪里找到你？第二，听众们能为你做些什么？

---

### (01:00:56) Annie Pearl

**English:**
Finding me, best place online is LinkedIn. And then, in terms of being helpful to me, one we're hiring at Calendly. So, explore open roles on the product team at Calendly if you're interested. Share any feedback for me on this episode@a.pearl@calendly.com. And then, as we talked about, would love to have you follow the Skip community on LinkedIn as well.

**中文翻译:**
找我的话，最好的地方是 LinkedIn。至于如何帮到我：第一，Calendly 正在招聘。如果你感兴趣，请查看 Calendly 产品团队的开放职位。第二，欢迎通过 a.pearl@calendly.com 分享你对本期节目的反馈。最后，正如我们讨论过的，也希望大家在 LinkedIn 上关注 Skip 社区。

---

### (01:01:15) Lenny

**English:**
Awesome. We'll have all those links in the show notes. Annie, thank you again for being here.

**中文翻译:**
太棒了。我们会把所有链接放在节目笔记里。Annie，再次感谢你的到来。

---

### (01:01:20) Annie Pearl

**English:**
Thank you so much, Lenny.

**中文翻译:**
非常感谢，Lenny。

---

### (01:01:22) Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。