# Anton Osika - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny’s Podcast featuring Anton Osika, CEO of Lovable.

---

### [00:00:00] Anton Osika

**English:**
... Lovable is your personal AI software engineer. You describe an idea and then you get a fully working product. The reason is to enable those who have had such a hard time finding people who are good at creating software that's been their absolute bottleneck and let them take their ideas and their dreams into reality.

**中文翻译:**
……Lovable 是你的个人 AI 软件工程师。你描述一个想法，然后就能得到一个完全可以运行的产品。我们的初衷是赋能那些在寻找优秀软件开发人才方面遇到极大困难的人，因为人才匮乏一直是他们的绝对瓶颈。我们希望让他们能将自己的想法和梦想变为现实。

---

### [00:00:19] Lenny Rachitsky

**English:**
You guys hit 4 million ARR in the first four weeks. You hit 10 million ARR in the first two months with just 15 people. You're the fastest growing startup in all of Europe. How did you decide on Lovable is the name. It's so sweet.

**中文翻译:**
你们在头四周就达到了 400 万美元的 ARR（年度经常性收入）。在只有 15 个人的情况下，头两个月就达到了 1000 万美元的 ARR。你们是全欧洲增长最快的初创公司。你是怎么决定用“Lovable”这个名字的？它听起来很温馨。

---

### [00:00:31] Anton Osika

**English:**
The best word for a great product is that it's lovable. A lot of jargon that I like to use to emphasize what we should be striving for is building a minimum lovable product and then building a lovable product and then building an absolutely lovable product. So I took that jargon with me in the company name.

**中文翻译:**
形容一个好产品最好的词就是“lovable”（讨人喜欢/可爱）。我喜欢用很多行话来强调我们应该努力的方向，那就是先构建一个“最小可爱产品”（Minimum Lovable Product，简称 MLP），然后构建一个“可爱产品”，最后构建一个“绝对可爱的产品”。所以我把这个行话带到了公司的名字里。

---

### [00:00:47] Lenny Rachitsky

**English:**
People would wonder just what jobs will be more important, what skills will be less important?

**中文翻译:**
人们会好奇，究竟哪些工作会变得更重要，哪些技能会变得不那么重要？

---

### [00:00:51] Anton Osika

**English:**
Doing a bit of everything. Being a generalist, I think much more important than it used to be. If I'm putting together a product team today, I would really obsess about getting as many skill sets as possible for each person I hire.

**中文翻译:**
什么都懂一点。我认为做一个“全才”（Generalist）比以前重要得多。如果我今天要组建一个产品团队，我会非常执着于让我雇佣的每一个人都拥有尽可能多的技能组合。

---

### [00:01:03] Lenny Rachitsky

**English:**
What have you done that has allowed you to grow this fast with so few people?

**中文翻译:**
你们做了什么，让你们在人手这么少的情况下增长得如此之快？

---

### [00:01:07] Anton Osika

**English:**
People love the product. That's the driver of the growth.

**中文翻译:**
人们热爱这个产品。这就是增长的动力。

---

### [00:01:15] Lenny Rachitsky

**English:**
Today, my guest is Anton Osika. Anton is co-founder and CEO of Lovable, which is essentially an AI engineer that takes an English prompt and codes a product for you in minutes. You can then talk to it, iterate on the product, and then launch it to the world. It's one of the fastest growing products in history. The fastest growing startup in Europe ever, and as Anton describes, their goal for Lovable is for it to be the last piece of software that anybody has to write because it'll be able to create all future products for us. They launched just a few months ago in the first four weeks, hit 4 million ARR in the first two months across 10 million ARR, all with just 15 people. Absurd. In our conversation, we covered a lot of ground, including a live demo of Lovable, how their team operates, how they hire, what has most enabled their team to scale this quickly with so few people, pro tips for using Lovable, how it all started, how he recommends you build product teams going forward with tools like this existing, what skills will matter more and less going forward?
(00:02:17):
Plus how to think about Lovable versus competitors and so much more. If you're trying to wrap your head around how product building will change with the rise of AI tools, this episode is a must watch. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become a yearly subscriber of my newsletter, you now get a year free of Perplexity and Notion and Superhuman and Linear and Granola. Check it out at Lennysnewsletter.com. With that, I bring you Anton Osika.

**中文翻译:**
今天，我的嘉宾是 Anton Osika。Anton 是 Lovable 的联合创始人兼 CEO。Lovable 基本上就是一个 AI 工程师，它接收英文提示词（prompt），并在几分钟内为你编写出一个产品。然后你可以与它对话、迭代产品，并将其发布给全世界。它是历史上增长最快的产品之一，也是欧洲有史以来增长最快的初创公司。正如 Anton 所描述的，他们对 Lovable 的目标是让它成为任何人需要编写的“最后一款软件”，因为它将能够为我们创建所有未来的产品。他们几个月前才发布，头四周就达到了 400 万美元的 ARR，头两个月突破了 1000 万美元的 ARR，而团队只有 15 人。简直不可思议。在我们的对话中，我们涵盖了很多内容，包括 Lovable 的现场演示、他们的团队如何运作、如何招聘、是什么让他们的团队在人手如此之少的情况下实现如此快速的扩张、使用 Lovable 的专业技巧、它是如何开始的、在拥有这类工具的情况下他建议未来如何组建产品团队，以及未来哪些技能会变得更重要或更不重要。
(00:02:17):
此外，还有如何看待 Lovable 与竞争对手的关系等等。如果你想了解随着 AI 工具的兴起，产品构建将如何发生变化，这一集是必看的。如果你喜欢这个播客，别忘了在你不常用的播客应用或 YouTube 上订阅和关注。另外，如果你成为我时事通讯（newsletter）的年度订阅者，你现在可以免费获得一年的 Perplexity、Notion、Superhuman、Linear 和 Granola。请访问 Lennysnewsletter.com 查看。下面，让我们欢迎 Anton Osika。

---

### [00:02:49] Lenny Rachitsky (Ad Segment: Cinch)

**English:**
This episode is brought to you by Cinch the customer Communications Cloud. Here's the thing about digital customer communications. Whether you're sending marketing campaigns, verification codes or account alerts, you need them to reach users reliably. That's where Cinch comes in. Over 150,000 businesses, including eight of the top 10 largest tech companies globally use Cinch's API to build messaging, email and calling into their products. And there's something big happening in messaging that product teams need to know about. Rich Communication Services or RCS, think of RCS as SMS 2.0. Instead of getting texts from a random number, your users will see your verified company name and logo without needing to download anything new. It's a more secure and branded experience, plus you get features like interactive carousels and suggested replies, and here's why this matters. US carriers are starting to adopt RCS. Cinch is already helping Nature Brands send RCS messages around the world and they're helping Lenny's podcast listeners get registered first before the rush hits the US market. Learn more at get started at Cinch.com slash Lenny. That's S-I-N-C-H dot com slash Lenny.

**中文翻译:**
本期节目由客户沟通云平台 Cinch 赞助。关于数字客户沟通，情况是这样的：无论你是在发送营销活动、验证码还是账户提醒，你都需要它们可靠地送达用户。这就是 Cinch 的用武之地。超过 15 万家企业，包括全球前十大科技公司中的八家，都在使用 Cinch 的 API 将短信、邮件和通话功能集成到他们的产品中。目前短信领域正在发生一件产品团队需要了解的大事：富通信服务（Rich Communication Services，简称 RCS）。你可以把 RCS 看作是短信 2.0。用户收到的不再是来自随机号码的文本，而是会看到你经过验证的公司名称和 Logo，且无需下载任何新应用。这是一种更安全、更具品牌感的体验，此外你还可以获得交互式轮播图和建议回复等功能。这之所以重要，是因为美国运营商正开始采用 RCS。Cinch 已经在帮助 Nature Brands 在全球范围内发送 RCS 消息，并且他们正在帮助 Lenny 播客的听众在美国市场爆发前优先注册。欲了解更多信息并开始使用，请访问 Cinch.com/Lenny。拼写是 S-I-N-C-H dot com slash Lenny。

---

### [00:04:02] Lenny Rachitsky (Ad Segment: Persona)

**English:**
This episode is brought to you by Persona, the adaptable identity platform that helps businesses fight fraud, meet compliance requirements, and build trust. While you're listening to this right now, how do you know that you're really listening to me, Lenny? These days, it's easier than ever for fraudsters to steal PII, faces and identities. That's where Persona comes in. Persona helps leading companies like LinkedIn, Etsy, and Twilio securely verify individuals and businesses across the world. What sets Persona apart is its configurability. Every company has different needs depending on its industry, use cases, risk tolerance and user demographics. That's why Persona offers flexible building blocks that allow you to build tailored collection and verification flows that maximize conversion while minimizing risks. Plus Persona's orchestration tools, automate your identity process so that you can fight rapidly shifting fraud and meet new waves of regulation. Whether you're a startup or an enterprise business, Persona has a plan for you. Learn more at withpersona.com slash Lenny. Again, that's with P-E-R-S-O-N-A dot com slash Lenny. Anton, thank you so much for being here and welcome to the podcast.

**中文翻译:**
本期节目由 Persona 赞助。Persona 是一个灵活的身份平台，帮助企业打击欺诈、满足合规要求并建立信任。当你现在听这段音频时，你怎么知道你真的在听我——Lenny 的声音？如今，诈骗者比以往任何时候都更容易窃取个人身份信息（PII）、面部数据和身份。这就是 Persona 的用武之地。Persona 帮助 LinkedIn、Etsy 和 Twilio 等领先公司安全地验证全球范围内的个人和企业。Persona 的独特之处在于其可配置性。每家公司根据其行业、用例、风险承受能力和用户群体都有不同的需求。这就是为什么 Persona 提供灵活的构建模块，允许你构建量身定制的收集和验证流程，在最大化转化率的同时最小化风险。此外，Persona 的编排工具可以自动化你的身份流程，以便你可以应对快速变化的欺诈并满足新的监管浪潮。无论你是初创公司还是大型企业，Persona 都有适合你的方案。欲了解更多信息，请访问 withpersona.com/Lenny。再次强调，是 with P-E-R-S-O-N-A dot com slash Lenny。Anton，非常感谢你能来，欢迎来到本播客。

---

### [00:05:19] Anton Osika

**English:**
It's a pleasure to talk to you, Lenny, great to be here.

**中文翻译:**
很高兴能和你聊天，Lenny，很高兴来到这里。

---

### [00:05:22] Lenny Rachitsky

**English:**
I don't know how you have time to do this podcast. Your life must be insane these days with the pace at which you guys are scaling, just how much is changing in AI every day. So I just extra appreciate you making time for this. I think you said it's 10:30, your time, is when we're doing this.

**中文翻译:**
我不知道你怎么有时间来做这个播客。以你们现在的扩张速度，加上 AI 领域每天都在发生巨变，你的生活最近一定疯掉了。所以我特别感激你能抽时间。我想你刚才说，我们录制的时候你那边已经是晚上 10:30 了。

---

### [00:05:39] Anton Osika

**English:**
I'm a bit tired, yes. Mostly from the crazy pace of everything, but yes.

**中文翻译:**
我确实有点累。主要是因为所有事情的节奏都太疯狂了，但没错。

---

### [00:05:45] Lenny Rachitsky

**English:**
This is going to be an invigorating conversation and you're not going to be able to sleep.

**中文翻译:**
这将是一场令人振奋的对话，听完你可能会兴奋得睡不着觉。

---

### [00:05:50] Anton Osika

**English:**
Yes. I'm sure. I'm sure.

**中文翻译:**
是的，我确定，我确定。

---

### [00:05:51] Lenny Rachitsky

**English:**
Okay, so for folks that are maybe a little bit familiar with Lovable or not at all familiar, what is Lovable? What's the simplest way to understand it?

**中文翻译:**
好，对于那些可能对 Lovable 有点了解或者完全不了解的人来说，Lovable 到底是什么？最简单的理解方式是什么？

---

### [00:06:00] Anton Osika

**English:**
I'd say Lovable is your personal AI software engineer. You describe an idea and then you get a fully working product from the AI. And what this means is that entrepreneurs actually today, they turn their ideas into real businesses. We have a lot of designers and product managers that create the first version of their product ideas to show to the teams, and some of them become founders because of the empowerment from this, but also developers themselves, they actually writing code or creating products much faster. The reason, it's pretty obvious for me, but I'll spell it out, the reason why we're doing Lovable is that I don't know about your mom, but my mom doesn't write code and-

**中文翻译:**
我会说 Lovable 是你的个人 AI 软件工程师。你描述一个想法，然后就能从 AI 那里得到一个完全可以运行的产品。这意味着企业家们现在真的可以将他们的想法转化为真实的业务。我们有很多设计师和产品经理，他们创建了产品想法的第一版展示给团队，其中一些人因为这种赋能而成为了创始人。同时，开发者自己编写代码或创建产品的速度也快得多。原因对我来说很明显，但我还是说明一下：我们做 Lovable 的原因是，我不知道你妈妈怎么样，但我妈妈不会写代码，而且——

---

### [00:06:52] Lenny Rachitsky

**English:**
Same.

**中文翻译:**
我妈也一样。

---

### [00:06:55] Anton Osika

**English:**
... almost all my friends throughout my life reached out for help. Like, "Anton, I need to build something. How do I find a great software engineer?" And we are building for this 99% of the population who don't write code. Currently, if you're technically inclined, you get much further, but over time, naturally the way to build software is by just talking to an AI. And that's how we see it.

**中文翻译:**
……我生命中几乎所有的朋友都曾向我求助过。比如，“Anton，我需要做个东西，怎么才能找到优秀的软件工程师？”我们正是为这 99% 不会写代码的人群而构建的。目前，如果你有技术背景，你会走得更远，但随着时间的推移，构建软件的自然方式将仅仅是与 AI 对话。这就是我们的看法。

---

### [00:07:21] Lenny Rachitsky

**English:**
I love the way that you guys describe it and you didn't mention it, but I think it's building the last piece of software ever. How do you phrase that?

**中文翻译:**
我喜欢你们描述它的方式，你刚才没提到，但我记得你们说过是在构建“有史以来最后一款软件”。你是怎么表述的？

---

### [00:07:28] Anton Osika

**English:**
Yeah, we say we're building the last piece of software.

**中文翻译:**
是的，我们说我们正在构建最后一款软件。

---

### [00:07:31] Lenny Rachitsky

**English:**
The last piece of software. Okay, we're going to do a live demo, but first of all, can you just share some stats on the scale of this business at this point because it's quite absurd.

**中文翻译:**
最后一款软件。好，我们待会儿做一个现场演示，但首先，你能分享一下目前这项业务规模的一些数据吗？因为这简直太离谱了。

---

### [00:07:42] Anton Osika

**English:**
Yeah. So we launched Lovable less than three months ago, and now we have 300,000 monthly active users and 30,000 of those are actually paying and it is growing at the same rates, just almost only through organic word of mouth.

**中文翻译:**
是的。我们发布 Lovable 还不到三个月，现在我们有 30 万月活跃用户，其中 3 万是付费用户，而且它还在以同样的速度增长，几乎完全是靠有机的口碑传播。

---

### [00:08:02] Lenny Rachitsky

**English:**
Okay. And I'll share a couple stats in terms of revenue, just so folks know this, and we'll have this in the intro too. I think you guys hit 4 million ARR in the first four weeks. You hit 10 million ARR in the first two months with just 15 people. You're the fastest growing startup in all of Europe, and you guys had to rewrite your entire code base recently and you couldn't ship any new features for a while. Is that right?

**中文翻译:**
好的。我再分享几个关于收入的数据，让大家有个概念，我在开场白里也会提到。我想你们在头四周就达到了 400 万美元的 ARR。在只有 15 个人的情况下，头两个月就达到了 1000 万美元的 ARR。你们是全欧洲增长最快的初创公司。而且你们最近不得不重写了整个代码库，有一段时间无法发布任何新功能，对吗？

---

### [00:08:26] Anton Osika

**English:**
That's right, yeah. People were saying like, "Oh, you're shipping so fast." And we were all quite frustrated because we wrote our service in this kind of scripting language and then as we started scaling, we were just, no, we have to throw everything away and rewrite it in a more performant way.

**中文翻译:**
没错。人们常说，“噢，你们发布速度太快了。”但我们其实挺沮丧的，因为我们最初是用一种脚本语言编写的服务，随着规模扩大，我们意识到不行，必须把所有东西都扔掉，用性能更高的方式重写。

---

### [00:08:43] Lenny Rachitsky

**English:**
Okay, before we get to the demo, last question, you shared there's some companies that have started based on Lovable. I didn't even know that. So what are some examples of companies slash businesses that have launched off of Lovable and now are actually companies?

**中文翻译:**
好，在演示之前最后一个问题：你提到有一些公司是基于 Lovable 创立的。我之前都不知道。那么有哪些例子是基于 Lovable 启动并现在已经成为正式公司的业务？

---

### [00:08:56] Anton Osika

**English:**
I mentioned designers using Lovable and one of our early users, Harry, he started shipping real web apps to his clients instead of just shipping designs. And then he went on to say, okay, wait, I'm going to start an AI startup. And his company, he launched on Product Hunt and everything and making money is just like, let's anyone upload their photo library and then the AI parses and categorizes it. And if you go to launched.lovable.app, this is an app built with Lovable is again a product Hunt version where you can see a lot of businesses or small SaaS featured there.

**中文翻译:**
我提到过设计师使用 Lovable。我们的一位早期用户 Harry，他开始向客户交付真实的 Web 应用，而不仅仅是设计稿。然后他想，等等，我要创办一家 AI 初创公司。他的公司在 Product Hunt 上发布了，已经开始赚钱了，功能是让任何人上传他们的照片库，然后 AI 会进行解析和分类。如果你访问 launched.lovable.app，这是一个用 Lovable 构建的应用，也是一个类似 Product Hunt 的版本，你可以在那里看到很多已经上线的业务或小型 SaaS。

---

### [00:09:38] Lenny Rachitsky

**English:**
Okay, cool. So we're going to come back to some of this stuff, but let's get into demo. I rarely do demos on this podcast, but I'm finding that I think it's really important for people to see these products in action because in a large part, this is the future of product building and a lot of people hear about, "Oh yeah, AI's coming," and I don't think a lot of people actually see what the latest tools are capable of. And so I love showing these sorts of things on this podcast.

**中文翻译:**
太酷了。我们会再回到这些话题，但现在让我们开始演示吧。我很少在播客里做演示，但我发现让人们亲眼看到这些产品的运作非常重要，因为在很大程度上，这就是产品构建的未来。很多人听说“AI 时代来了”，但我认为很多人并没有真正看到最新工具的能力。所以我很喜欢在播客上展示这类东西。

---

### [00:10:05] Anton Osika

**English:**
So Lenny, I was thinking, did you ever consider making a copy and build your own Airbnb?

**中文翻译:**
Lenny，我在想，你有没有考虑过克隆一个并建立你自己的 Airbnb？

---

### [00:10:14] Lenny Rachitsky

**English:**
I haven't, but go on.

**中文翻译:**
还没想过，不过请继续。

---

### [00:10:17] Anton Osika

**English:**
How about you do that?

**中文翻译:**
要不你现在就做一个？

---

### [00:10:18] Lenny Rachitsky

**English:**
Let's do it. Let's do it. Okay, so we're going to make our own Airbnb.

**中文翻译:**
来吧，来吧。好，我们要做一个我们自己的 Airbnb。

---

### [00:10:22] Anton Osika

**English:**
So I just put in the first prompt for an Airbnb clone.

**中文翻译:**
好，我刚刚输入了第一个提示词，要求做一个 Airbnb 的克隆版。

---

### [00:10:27] Lenny Rachitsky

**English:**
Okay. And what is the prompt, just for folks that aren't watching?

**中文翻译:**
好的。为了那些没在看视频的听众，提示词是什么？

---

### [00:10:31] Anton Osika

**English:**
Two words, Airbnb clones. That's the prompt.

**中文翻译:**
就两个词，“Airbnb clone”。这就是提示词。

---

### [00:10:34] Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:10:34] Anton Osika

**English:**
Just start simple and then what you get is that the AI says, okay, I can go through what does a beautiful Airbnb clone look like and it goes through a bit of design decisions and then I'll zoom out to see more of it. We have this just UI that is... I mean it has all the nice things you would expect from Airbnb clone where you see different categories and you can see two listings from Airbnb with login buttons and everything. So far it doesn't have the functionality of Airbnb, it just has the UI. I would now ask for an improvement on some of the functionality. Like if I'm switching category, I want to see different listings, let's say. But if you have any thoughts on what we should build next, let me know.

**中文翻译:**
先从简单的开始。然后你会看到 AI 说，好的，我可以分析一个漂亮的 Airbnb 克隆版长什么样，它会做一些设计决策，然后我缩小画面让你看全貌。我们现在有了这个 UI……它具备了你对 Airbnb 克隆版所期望的所有优点，你可以看到不同的分类，看到两个来自 Airbnb 的房源列表，还有登录按钮等等。到目前为止，它还没有 Airbnb 的实际功能，只有 UI。我现在会要求改进一些功能。比如，如果我切换分类，我希望能看到不同的房源。如果你对下一步该建什么有想法，请告诉我。

---

### [00:11:25] Lenny Rachitsky

**English:**
Okay, and so you had this preloaded, so you didn't see how long it would take, but how long would this normally take for it to just write all this code and have it for you?

**中文翻译:**
好，因为你是预先加载好的，所以没看到具体耗时，但通常情况下，它写完所有这些代码并呈现给你需要多长时间？

---

### [00:11:32] Anton Osika

**English:**
The first prompt takes 30 seconds.

**中文翻译:**
第一个提示词大约需要 30 秒。

---

### [00:11:34] Lenny Rachitsky

**English:**
30 seconds? Okay. And it's like a very good copy of Airbnb. I love that you didn't have to show it a design, you just tell it Airbnb and it knows. Okay, so your question is would I want to add to my own version of Airbnb? I've always wanted to explore buying the place that I look at just like, Is this for sale? So what if we see what that would feel like if you're just a way to buy a listing.

**中文翻译:**
30 秒？天哪。而且它看起来就是一个非常棒的 Airbnb 副本。我喜欢你不需要给它看设计图，只要告诉它 Airbnb，它就懂了。好，你问我想在我的版本里加什么？我一直想探索一种功能，就是能直接买下我正在看的房子，比如“这房子卖吗？”。所以，如果我们加一个购买房源的功能，看看感觉如何？

---

### [00:11:59] Anton Osika

**English:**
Okay. Okay. So how about we add, I mean prompting is important here, so let's be specific, but we would ask, add a button on the listing which has purchased this Airbnb home. Is that it?

**中文翻译:**
好，好。那我们加一个……提示词在这里很重要，所以我们要具体一点。我们会要求：在房源列表上添加一个按钮，显示“购买这套 Airbnb 住宅”。是这样吗？

---

### [00:12:16] Lenny Rachitsky

**English:**
Perfect.

**中文翻译:**
完美。

---

### [00:12:19] Anton Osika

**English:**
Okay, so, add, and [inaudible 00:12:19]. I'll be even more specific. It will pop up a model to purchase the listing.

**中文翻译:**
好的，添加，并且……我会说得更具体：点击后会弹出一个模态框（modal）来购买该房源。

---

### [00:12:32] Lenny Rachitsky

**English:**
Perfect. And I love... So I think something as you're typing, I'm just going to share thoughts as you're doing this. So the site that you asked this AI engineer to build, it's actually a functioning website that you can browse around. It's not just a design, obviously there's no actual listings here, there's no actual houses here. Say you were trying to actually build Airbnb and you wanted to start adding actual homes that plug into this, how does that sort of step work?

**中文翻译:**
完美。而且我喜欢……在你输入的时候，我分享一下我的想法。你让这个 AI 工程师构建的网站，实际上是一个可以浏览的功能性网站。它不只是一个设计稿，虽然显然这里没有真实的房源和房子。假设你真的想做一个 Airbnb，并想开始添加接入这个系统的真实房屋，那一步是怎么操作的？

---

### [00:13:02] Anton Osika

**English:**
So as you say, this is just kind of the mockup UI, but it's also interactive. If I want to add login and add listing management, then we will connect something called the backend. So where data is stored, where user's log information is stored, and I can show you how to do that. First let's just try out where we got with this short prompt.

**中文翻译:**
正如你所说，这目前只是某种模型 UI（mockup UI），但它也是可交互的。如果我想添加登录和房源管理功能，那么我们会连接一个叫“后端”的东西。也就是存储数据、存储用户登录信息的地方。我可以演示怎么做。首先，让我们看看刚才那个简短的提示词做出了什么。

---

### [00:13:29] Lenny Rachitsky

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### [00:13:31] Anton Osika

**English:**
Adding the purchase listing and it didn't do exactly what I wanted. I said, add a button... Or I didn't say what a button should say, but it says book now, and if I click book now I get a booking confirmation. So the AI was like, okay, it didn't... It was probably surprised by you wanting to buy the listing since it's Airbnb. So it still says book the listing, but it shows a pretty model where I can click confirm and pay. And then it's says booking confirmed.

**中文翻译:**
正在添加购买房源功能……它没有完全按照我的想法做。我说添加一个按钮……或者我没说按钮上该写什么，结果它写的是“立即预订”（book now）。如果我点击“立即预订”，我会得到一个预订确认。AI 可能是觉得，既然是 Airbnb，你居然想买下房源，它感到很惊讶。所以它还是显示“预订房源”，但它显示了一个漂亮的模态框，我可以点击“确认并支付”，然后显示“预订已确认”。

---

### [00:14:05] Lenny Rachitsky

**English:**
I'll just say real quick, I love that this is actually a really good example of why being a good product manager is important. A lot of wasted time happens when you're not clear about the problem you're trying to solve and why you're trying to solve it and all that kind of stuff. So it's really cool that this is a use case where you have to be really good at explaining what it is you want. And it's interesting, you don't have to tell this AI-why. Humans want to understand, "Why is this important." Mostly you need to be very clear about what it is you're doing and I love that's a really strong PM skill. Your PM's really good at that. So we have to...

**中文翻译:**
我简单插一句，我非常喜欢这个例子，因为它很好地说明了为什么做一个优秀的产品经理（PM）很重要。当你对要解决的问题、为什么要解决它等事情不明确时，会浪费大量时间。所以这真的很酷，在这个用例中，你必须非常擅长解释你想要什么。有趣的是，你不需要告诉 AI “为什么”。人类需要理解“为什么这很重要”，但对 AI，你主要需要非常清楚地说明你在做什么。我喜欢这一点，这是一种非常强的 PM 技能。

---

### [00:14:39] Anton Osika

**English:**
Hey. Explaining exactly what you expect and what you're not getting is even more important with AI than with the humans. So I'm going into hooking up more of the actual functionality, but first I'll actually show you something. What's the fastest way to change what went wrong, it's created buttons that say book now and I want them to say, "Buy now." And what I could do is select this item and say change it to buy now. But what we just realized is that you can actually edit this, this is a fully functioning product, but you can edit it visually like you do in Squarespace and Wix and so on. So I'll just change the text to buy now and then it instantly changes. It actually changes deep down in the code base, but it's very fast to do that.

**中文翻译:**
嘿。与 AI 沟通时，准确解释你的期望以及你没得到什么是比对人解释更重要的。我现在要去连接更多的实际功能，但首先我要给你看样东西。纠正错误的快方式是什么？它创建了写着“立即预订”的按钮，而我想要的是“立即购买”。我可以选中这个元素，然后说把它改成“立即购买”。但我们刚刚意识到，你其实可以直接编辑它。这是一个功能齐全的产品，但你可以像在 Squarespace 或 Wix 那样进行可视化编辑。所以我直接把文本改成“立即购买”，它就立即变了。它实际上修改了代码库深处的代码，但操作起来非常快。

---

### [00:15:35] Lenny Rachitsky

**English:**
So I think people listening to this and seeing this, if you're not aware this is the cutting edge of tools like this, no other tool out there lets you generate code from an AI engineer and then actually just change a small element of it of every other tool that I'm aware of. You have to ask the agent, do this for me, and then you hope that it does the right thing. So this is a huge deal which you just showed. Right?

**中文翻译:**
我想听众和观众们，如果你还没意识到，这就是此类工具的最前沿。据我所知，没有任何其他工具能让你先通过 AI 工程师生成代码，然后直接手动修改其中的一个小元素。其他工具你必须要求智能体（agent）“帮我做这个”，然后祈祷它做对了。所以你刚才展示的功能意义重大，对吧？

---

### [00:16:00] Anton Osika

**English:**
Yeah. Now it says buy now.

**中文翻译:**
是的。现在它显示“立即购买”了。

---

### [00:16:01] Lenny Rachitsky

**English:**
Okay. Like that's amazing. Okay, and that's something you just launched?

**中文翻译:**
太神奇了。这是你们刚发布的功能吗？

---

### [00:16:04] Anton Osika

**English:**
Yeah. Great. We just launched this a few days ago, but I won't go into for building the full functionality, but what it looks like is that you connect an open source backend as a service and that's called SuperBase. And I have this instance to connect to that's completely empty, just like one click to set that up and now it's connected to the backend. It's just automatically generating some code and explaining what I can do next. And what I would do now is, say, let's add login, let's say let's add login.

**中文翻译:**
是的。太棒了。我们几天前刚发布这个。我不会演示构建完整功能的全过程，但它的流程是这样的：你连接一个开源的“后端即服务”（BaaS），叫做 Supabase。我有一个完全空的实例可以连接，只需一键设置，现在它就连接到后端了。它会自动生成一些代码并解释我下一步可以做什么。我现在要做的就是说：让我们添加登录功能。

---

### [00:16:41] Lenny Rachitsky

**English:**
And where is it actually hosted on the backend and everything in general?

**中文翻译:**
那它的后端和所有东西通常是托管在哪里的？

---

### [00:16:45] Anton Osika

**English:**
So everything can be one click deployed and then it's running. It's hosted by a cloud vendor, which is hosting, I think a huge chunk of the internet, it's called Cloudflare, and the backend is hosted by also good cloud writer, which is called SuperBase.

**中文翻译:**
所有东西都可以一键部署并运行。它由一家云供应商托管，我想这家公司托管了互联网的很大一部分，叫 Cloudflare。后端则由另一家优秀的云服务商托管，叫 Supabase。

---

### [00:17:07] Lenny Rachitsky

**English:**
Amazing. Okay, let's wrap up the demo, that was... Unless there's anything else, was there anything else really important that you wanted to show?

**中文翻译:**
太棒了。好，演示就到这里吧，除非……还有什么非常重要你想展示的吗？

---

### [00:17:14] Anton Osika

**English:**
No I'll just explain what I would do next. I would say, okay, let's add login. Let's make the listings editable by the users so users can upload listings and then this is going to take a bit more time, but with patience and good prompting skills, you're going to get to a full working Airbnb.

**中文翻译:**
没有了，我只解释一下我下一步会做什么。我会说，好，让我们添加登录。让房源可以被用户编辑，这样用户就可以上传房源。这会多花一点时间，但只要有耐心和良好的提示词技巧，你就能得到一个功能完整的 Airbnb。

---

### [00:17:33] Lenny Rachitsky

**English:**
That was a really good piece to add. So basically this is getting to a place where it actually is not so different from actual Airbnb. People can log in, they can add their home, you can add internal tools to add listings for your, say, sales team, ops team. Basically it just will allow you to build a marketplace that looks a lot like Airbnb. Amazing. Okay, thank you for the demo. I think for a lot of people they're like, "Yeah, yeah, I've seen this kind of stuff," for most people, like, "Holy shit." It's unreal what... It's almost like we're taking for granted now. You can ask an app to build you a whole website and that costs probably like a few pennies. It took like five minutes versus it would've been tens of thousands and weeks and weeks and months to even build just a prototype.

**中文翻译:**
补充得很好。所以基本上，这已经发展到了一个与真实的 Airbnb 没太大区别的程度。人们可以登录，添加自己的房子，你可以添加内部工具让销售团队或运营团队添加房源。基本上，它允许你构建一个看起来非常像 Airbnb 的市场。太棒了。好，谢谢你的演示。我想对很多人来说，他们可能会觉得“哦，我看过这类东西”，但对大多数人来说，反应会是“我的天呐”。这简直不可思议……我们现在好像已经习以为常了。你可以要求一个应用为你构建整个网站，成本可能只有几分钱，只花了五分钟。而以前，即使只是做一个原型，也需要花费数万美元和数周甚至数月的时间。

---

### [00:18:23] Anton Osika

**English:**
I mean, these tools as we see here, they're already very good, it looks really good as well, but mainly I would say they're getting better very, very fast. And I'd say one of the bigger bottlenecks is now they're not integrated into the current way that you have your existing products and so on. But since they're getting better so fast, I think the best thing for people who are interested in this or interested in just being a part of the future economies, get your hands very dirty with these tools because being in the top 10% in using them is going to absolutely set you apart in the coming months and years.

**中文翻译:**
我的意思是，正如我们在这里看到的，这些工具已经非常出色了，看起来也很棒。但更主要的是，它们进步的速度非常快。我想说，目前较大的瓶颈之一是它们还没有集成到你现有的产品工作流中。但既然它们进步得这么快，我认为对于那些对此感兴趣或想成为未来经济一部分的人来说，最好的办法就是亲自动手尝试这些工具。因为在未来几个月和几年里，成为使用这些工具的前 10% 的人将让你脱颖而出。

---

### [00:19:05] Lenny Rachitsky

**English:**
So let me follow that thread. So say you are magically able to sit next to everybody that is using Lovable for the first time and you could just whisper a tip in their ear to be successful with Lovable, what would that tip be?

**中文翻译:**
那让我顺着这个话题问下去。假设你有一种魔力，能坐在每一个第一次使用 Lovable 的人身边，在他们耳边低声说一个能让他们成功使用 Lovable 的秘诀，那个秘诀会是什么？

---

### [00:19:20] Anton Osika

**English:**
It takes a lot to master using tools like Lovable and being very curious and patient and we have something called chat mode where you can just ask to understand like, "How does this work? I'm not getting what I want here, am I missing something? What should I do?" Is the best way to be productive is also one of the best ways to just learn about how software engineering works, which is you don't have to write the code anymore, but it is useful to understand how software engin- or how building products works. So I think that's the patience and curiosity is super useful. The second part that we spoke about is that being, if I would sit next to you, I would probably say like, "Hey, you are not being super clear here." For example, don't say it doesn't work. Just explain exactly what you're expecting and which parts are working and which parts are not working. And that's something that a lot of people don't do naturally.

**中文翻译:**
掌握像 Lovable 这样的工具需要很多练习，要保持好奇心和耐心。我们有一个叫“对话模式”（chat mode）的功能，你可以直接问它来理解，比如：“这是怎么运作的？我没得到我想要的结果，我是漏掉了什么吗？我该怎么做？”这是提高效率的最佳方式，也是学习软件工程运作方式的最佳方式之一。虽然你不再需要亲手写代码，但理解软件工程或产品构建的逻辑仍然很有用。所以耐心和好奇心超级有用。第二点就是我们刚才聊到的，如果我坐在你旁边，我可能会说：“嘿，你这里表达得不够清楚。”例如，不要只说“它坏了”，要准确解释你的预期是什么，哪些部分在工作，哪些部分没在工作。这是很多人天生不太擅长做的事情。

---

### [00:20:25] Lenny Rachitsky

**English:**
I love that when you have an engineer you're working with that does a very expensive mistake to miscommunicate something, to just forget about a feature, to forget a better requirement, and here it's... You do that and then 30 seconds later you're like, "Oh okay, sorry, that was wrong." And then you could just try again.

**中文翻译:**
我喜欢这一点。当你和工程师合作时，沟通失误、漏掉一个功能或忘记一个需求可能是代价高昂的错误。而在这里……你犯了错，30 秒后你说：“噢好吧，抱歉，那是错的。”然后你就可以重试。

---

### [00:20:41] Anton Osika

**English:**
That's true. It might be more costly with humans.

**中文翻译:**
确实。和人类合作的成本可能更高。

---

### [00:20:45] Lenny Rachitsky

**English:**
Okay, and so the first step is chat mode. So your advice is chat with the... What do you call it? Do you call it an agent? What's the term for the thing that you were talking with?

**中文翻译:**
好，所以第一步是对话模式。你的建议是与……你怎么称呼它？你叫它智能体（agent）吗？你刚才对话的那个东西术语是什么？

---

### [00:20:57] Anton Osika

**English:**
Yeah, Lovable is an agent.

**中文翻译:**
是的，Lovable 是一个智能体。

---

### [00:20:59] Lenny Rachitsky

**English:**
Just Lovable?

**中文翻译:**
就叫 Lovable？

---

### [00:20:59] Anton Osika

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:21:00] Lenny Rachitsky

**English:**
Okay. So you're talking about Lovable by the way. How decide on Lovable as the name? It's so sweet.

**中文翻译:**
好的。顺便问一下，你是怎么决定用 Lovable 这个名字的？它太温馨了。

---

### [00:21:06] Anton Osika

**English:**
I think it's all about building a great product. That's what I want more people to be able to do and the best word for a great product is that it's Lovable. A lot of jargon that I like to use to emphasize what we should be striving for is building a minimum Lovable product and then building a Lovable product and then building an absolutely Lovable product. So I took that jargon with me in the company name.

**中文翻译:**
我认为核心在于构建伟大的产品。这就是我希望更多人能做到的事情。形容伟大产品最好的词就是“Lovable”。我喜欢用很多行话来强调我们的目标：先做一个“最小可爱产品”（MLP），然后做一个“可爱产品”，最后做一个“绝对可爱的产品”。所以我把这个行话带进了公司名字。

---

### [00:21:36] Lenny Rachitsky

**English:**
That is great. Absolute Lovable product. ALP is the new MVP. Okay, so we talked about this, the scale you guys have hit at this point, I imagine it's far beyond 10 million ARR. Do you share that at this point or are you keeping that private?

**中文翻译:**
太棒了。绝对可爱产品（ALP）是新的 MVP。好，我们聊聊规模，我猜你们现在的 ARR 已经远超 1000 万美元了。你现在会分享具体数据吗，还是保持私密？

---

### [00:21:51] Anton Osika

**English:**
We don't anchor on the numbers, but I could probably do a two X tweet about this quite soon. Yes.

**中文翻译:**
我们不纠结于具体数字，但我可能很快会发一条关于“翻倍”的推文。是的。

---

### [00:21:57] Lenny Rachitsky

**English:**
Okay, so it's far beyond 10 million ARR at this point. It's one of the fastest growing startups in history, the fastest growing startup in Europe. I want to zoom us back to the beginning. What is the origin story of Lovable? How did it all begin? What was the journey to today?

**中文翻译:**
好，所以现在已经远超 1000 万美元 ARR 了。它是历史上增长最快的初创公司之一，也是欧洲增长最快的初创公司。我想把话题拉回到最开始。Lovable 的起源故事是什么？它是如何开始的？走到今天经历了怎样的历程？

---

### [00:22:14] Anton Osika

**English:**
I think I was not impressed by what people were doing with the large language models [inaudible 00:22:21], especially after I was using them way back. But when ChatGPT came out, they were starting to get really good at taking a human instruction and spitting out code and then people in my team, I was the CTO at a YC startup, they felt like, "Oh, Anton, you're exaggerating. This is not going to change anything in the coming years." So I wanted to prove a point and I created an open source tool called GPT Engineer where you write something like create a snake game and then it spits out a lot of code, a little of different files and then opens the snake game. And then I tweeted a video about that and GPT Engineer is to date the most popular open source tool to showcase the ability for large language models to create applications and it's at like 50 something thousand GitHub stars and dozens of academic references.

**中文翻译:**
我觉得当时人们用大语言模型（LLM）做的事情并没有让我印象深刻，尤其是在我很早以前就开始使用它们之后。但当 ChatGPT 问世时，它们开始变得非常擅长接收人类指令并吐出代码。当时我是某 YC 初创公司的 CTO，我团队里的人觉得：“噢，Anton，你太夸张了。这在未来几年内不会改变任何事情。”所以我为了证明这一点，创建了一个名为 GPT Engineer 的开源工具。你输入类似“创建一个贪吃蛇游戏”的指令，它就会吐出大量代码和不同的文件，然后运行贪吃蛇游戏。我发了一条关于它的推文视频，GPT Engineer 至今仍是展示大语言模型构建应用能力的最受欢迎的开源工具，拥有约 5 万多个 GitHub Star 和数十篇学术引用。

---

### [00:23:21] Lenny Rachitsky

**English:**
And I know that I'll just add that it GitHub shut you down because they thought it was some kind of attack, like how many stars you're getting, how many people were using it,

**中文翻译:**
我补充一下，我知道 GitHub 后来封禁了你们，因为他们以为那是某种攻击，因为你们获得的 Star 数量和使用人数太惊人了。

---

### [00:23:29] Anton Osika

**English:**
Right. Yeah. So that came later. That's with Lovable. So this is Lovable. Lovable, earlier was always creating new projects on GitHub when someone used Lovable and we asked them, "Is it fine? How was the limits here?" They said, "Oh, there are no limits." But once we started creating 15,000 projects per day, so there were a lot of usage. Then some engineer when was on call, maybe they woke up in the night and they saw their servers were taking too much load because of us. So then they shut off down completely and we got this email that said, "Oh, you broke some kind of rules and we didn't know what was going on."

**中文翻译:**
对。那是后来的事，是关于 Lovable 的。早期的 Lovable 在有人使用时总是在 GitHub 上创建新项目。我们问过 GitHub：“这样行吗？限制是多少？”他们说：“噢，没有限制。”但当我们开始每天创建 1.5 万个项目时，使用量太大了。然后某个值班工程师可能半夜醒来，发现他们的服务器因为我们而负载过高。于是他们彻底关停了我们，我们收到一封邮件说：“噢，你们违反了某些规则”，而我们当时根本不知道发生了什么。

---

### [00:24:13] Lenny Rachitsky

**English:**
That's similar to a story I heard when ChatGPT was originally being trained, Microsoft servers blocked it because they thought it was some crawler and it was just actually the very first version ChatGPT being trained on data. Anyway, keep going.

**中文翻译:**
这和我听到的 ChatGPT 最初训练时的故事很像：微软的服务器屏蔽了它，因为他们以为那是某种爬虫，但实际上那是 ChatGPT 的第一个版本在训练数据。不管怎样，请继续。

---

### [00:24:29] Anton Osika

**English:**
So I built this tool called GPT Engineer and I was thinking about we're seeing the biggest change humanity will ever see, I think, where before you had the manual labor being taken over by machines, but now it's actually cognitive labor being done better than humans by machines and what's the best way to have some kind of positive impact here? It's not to make engineers more productive, which there's a lot of companies using AI to make engineers more productive, Microsoft did with co-pilot and so on. But it is to enable those who have such a hard time finding people who are good at creating software that's been their absolute bottleneck and let them take their ideas and their beliefs into reality. So enabling more entrepreneurship and innovation by building the AI software engineer for anyone. And then I grabbed a previous colleague of mine who has also been a founder, Fabian, and I said we should build something like GPT Engineer but it has to be for the people who don't write code and that's the story.

**中文翻译:**
所以我构建了 GPT Engineer 这个工具，我当时在想，我们正在见证人类历史上最大的变革。以前是体力劳动被机器取代，但现在实际上是认知劳动被机器做得比人类更好。在这里产生积极影响的最佳方式是什么？不是让工程师变得更高效——已经有很多公司在利用 AI 让工程师更高效了，比如微软的 Copilot 等等。而是要赋能那些极难找到优秀软件开发人才的人，因为这一直是他们的绝对瓶颈，让他们能将自己的想法和信念变为现实。通过为所有人构建 AI 软件工程师，来促进更多的创业和创新。然后我找了我以前的一位同事 Fabian，他也曾是一位创始人，我说我们应该做一个类似 GPT Engineer 的东西，但它必须是面向那些不会写代码的人的。这就是故事的由来。

---

### [00:25:43] Lenny Rachitsky

**English:**
Okay. And then that became lovable? There's the shift from open source into a product that anyone can use but also pay for. Makes sense. Okay, so from that point I saw a stat that you started making a million dollars in ARR per week and once you launched lovable, is that true?

**中文翻译:**
好。然后那就变成了 Lovable？经历了从开源到任何人都可以使用且付费的产品的转变。明白了。好，从那时起，我看到一个数据说，一旦你们发布了 Lovable，你们就开始每周增加 100 万美元的 ARR，是真的吗？

---

### [00:26:00] Anton Osika

**English:**
Yeah, so launched, we actually called the first version of the product like GPT Engineer app and it was very different in some ways and we launched that under a waitlist and said like, Oh yeah, we have this waitlist and we got a lot of feedback and iterated. Finally, when we thought the product was really good we said okay, now we have a Lovable product. And it was mainly on the AI that we did a lot of improvements, once we launched that, that was 21st of November, so that's almost three months ago. We just hit 1 million ARR in a week and then it kept growing at that pace. It still growing at even faster than that pace.

**中文翻译:**
是的。发布时，我们实际上把产品的第一版叫做 GPT Engineer app，它在某些方面非常不同。我们当时采用了候补名单（waitlist）模式，收到了很多反馈并进行了迭代。最后，当我们认为产品真的很棒时，我们说：好了，现在我们有了一个“可爱”的产品（Lovable product）。我们主要在 AI 方面做了很多改进。一旦我们发布——那是 11 月 21 日，大约三个月前——我们就在一周内达到了 100 万美元的 ARR，然后一直保持这个速度增长。现在的增长速度甚至比那还要快。

---

### [00:26:43] Lenny Rachitsky

**English:**
Faster than 1 million ARR per week. Holy shit.

**中文翻译:**
每周增长超过 100 万美元 ARR。我的天。

---

### [00:26:48] Anton Osika

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:26:48] Lenny Rachitsky

**English:**
Okay, that sounds like product market fit to me. You said that you did a lot of work on the backend. I saw you tweet about this that you guys figured out some kind of unlock on scalability, like a new scaling law that allowed you to build something like this. What can you talk about there that on the technical element allowed you to build something new and the successful?

**中文翻译:**
好，这在我看来就是典型的“产品市场契合”（PMF）。你说你在后端做了很多工作。我看到你发推特说，你们在可扩展性方面发现了一些突破，比如一种新的“扩展定律”（scaling law），让你们能够构建出这样的东西。在技术层面，你能谈谈是什么让你们构建出如此新颖且成功的东西吗？

---

### [00:27:08] Anton Osika

**English:**
There are many scaling laws I would say when you build AI systems and this one in particular is about when you put in more work, the product reliably gets better and better. And what you've seen generally when you have AI building something is that it can get stuck in some place. It is super good in the beginning and then it gets stuck. What we did was to painstakingly identify places where it got stuck and there is different approaches but address different ways how we do it but address the places where it gets stuck, tune the entire system quantitatively and having a very fast feedback loop to improve it in the areas where it got stuck. The most important areas, it still does get stuck sometimes, but that's the scaling law and we're still early in that scaling law, I would say.

**中文翻译:**
我想说，当你构建 AI 系统时，有很多扩展定律。这一个特别之处在于，当你投入更多工作时，产品会可靠地变得越来越好。通常当你让 AI 构建东西时，你会发现它会在某些地方卡住。刚开始表现超级好，然后就卡住了。我们所做的是煞费苦心地识别它卡住的地方，并采用不同的方法——虽然处理方式各异，但核心是解决卡点，对整个系统进行定量调优，并建立非常快速的反馈循环，在它卡住的领域进行改进。在最重要的领域，它有时仍然会卡住，但这就是扩展定律，而且我想说，我们还处于这个扩展定律的早期阶段。

---

### [00:28:04] Lenny Rachitsky

**English:**
And so when you talk about things getting stuck, it's like the AI agent just saying, I don't know what to do from this point or they introduce some kind of bug. Is that an example of getting stuck?

**中文翻译:**
所以当你谈到“卡住”时，是指 AI 智能体说“我不知道下一步该做什么”，或者它们引入了某种 Bug。这是卡住的例子吗？

---

### [00:28:13] Anton Osika

**English:**
Yeah. It introduces some kind of bug and then it's not smart enough to figure out how to get out of that bug.

**中文翻译:**
是的。它引入了某种 Bug，然后它不够聪明，不知道如何解决那个 Bug。

---

### [00:28:20] Lenny Rachitsky

**English:**
I see. And this is a common problem people have with tools like this is they get to a certain point and then it's like, "Well I don't know what to do. I'm not an engineer, here's a bug it's running into or the infrastructure's built the wrong way." And so it sounds like one of the paths to solving that is what you're describing is you make the AI smarter to avoid more and more of these places they get stuck. Another is people just learning how to get AI unstuck. This is something when we had Amjad on the podcast from Replit, he said that this is the main skill that he thinks people need to learn is how to unstuck AI when it runs into a problem. Just thoughts there, I don't know anything along those lines come up as I say that.

**中文翻译:**
明白了。这是人们使用此类工具时常遇到的问题：进行到一定程度后，用户会觉得“我不知道该怎么办了，我不是工程师，这里有个 Bug，或者架构搭错了”。听起来解决这个问题的一条路径就是你描述的：让 AI 变得更聪明，以避开越来越多卡住的地方。另一条路径是人们学习如何让 AI “脱困”。Replit 的 Amjad 来我们播客时也说过，他认为人们需要学习的核心技能就是当 AI 遇到问题时如何让它脱困。对此你有什么看法？

---

### [00:29:04] Anton Osika

**English:**
This is something that is a problem today and the frontier of where this is a problem is very rapidly receding back. So what we did was we identified the most important areas, so specifically adding login, creating data persistence, adding payment with Stripe. Those are the things that we made sure it doesn't get stuck on, for example. And the places where it gets stuck today is currently something that you can use being very good at understanding and getting unstuck, but in the future it won't be so important. This experience just going to not get stuck.

**中文翻译:**
这在今天确实是个问题，但这个问题的边界正在迅速退缩。我们所做的是识别出最重要的领域，具体来说是添加登录、创建数据持久化、添加 Stripe 支付。例如，我们确保了它在这些事情上不会卡住。今天它卡住的地方，目前确实需要你非常擅长理解并引导它脱困，但在未来这不会那么重要。这种体验最终将进化到完全不会卡住。

---

### [00:29:48] Lenny Rachitsky

**English:**
And I know you're not talking super in-depth about this because this is one of your unfair advantages, this kind of stuff you figured out. So I'm not going to push too far. I know you want not everyone's into exactly the same stuff. So I want to zoom back to the pace of growth that you guys have seen. One of the big stories, everyone's always looking at you guys of like 15 people, 10 million ARR in two months. That's absurd. I don't know if it's ever been done in history. If so, it's maybe a couple other AI startups recently. How have you been able to do this? What have you done that has allowed you to grow this fast with so few people?

**中文翻译:**
我知道你不会深入探讨这个，因为这是你们的“不公平竞争优势”之一，是你们摸索出来的门道。所以我不会逼问太深。我知道不是每个人都对这些细节感兴趣。我想回到你们所经历的增长速度上。一个大新闻是，大家都在关注你们：15 个人，两个月 1000 万美元 ARR。这太荒谬了。我不知道历史上是否有人做到过。如果有，可能也就是最近那几家 AI 初创公司。你们是怎么做到的？你们做了什么让你们在人手这么少的情况下增长得如此之快？

---

### [00:30:24] Anton Osika

**English:**
I'd like to take credit of having done everything end to end in the product, but we are building on top of taking the oil here, which we have discovered oil, which is are the foundation models and then what we've done is that we're obsessed about what's the right way to present this to a user. What's the interface for the human to get as much out of this as possible? Packaging together, I showed you in the demo how you can add authentication and making this work seamlessly together as a whole. That's what we've done. And then people love the product. That's the driver of the growth. For getting awareness, we've mainly been posting what we've shipped on social media, that's how people know about us.

**中文翻译:**
我很想把功劳都揽在自己身上，说我们完成了产品端到端的所有工作，但实际上我们是站在巨人的肩膀上。我们发现了“石油”，也就是基础模型（foundation models）。然后我们所做的是，我们痴迷于如何以正确的方式将其呈现给用户。人类与它交互的界面应该是怎样的，才能从中获得最大的价值？我们将功能打包在一起，就像我在演示中展示的那样，你可以添加身份验证，并让这一切作为一个整体无缝协作。这就是我们所做的。然后人们热爱这个产品，这就是增长的动力。为了获得知名度，我们主要是在社交媒体上发布我们交付的内容，人们就是这样知道我们的。

---

### [00:31:17] Lenny Rachitsky

**English:**
So building in public is how people usually describe that. So I think it's like you guys have the advantage of the demos are just like, "Holy shit, you can do that." And then you guys share the numbers that you guys are growing at. So it's innately interesting and shareable, but I imagine most people have something interesting to share. I guess is there anything that you think you did that other companies maybe haven't done that make the product so lovable?

**中文翻译:**
这就是人们常说的“公开构建”（building in public）。我想你们的优势在于，演示效果总是让人惊呼“天哪，你竟然能做到这个”。然后你们分享你们的增长数据。所以它天生就很有趣且易于分享。但我猜大多数人都有有趣的东西可以分享。我想知道，你觉得你们做了哪些其他公司可能没做的事情，才让产品如此“可爱”（lovable）？

---

### [00:31:43] Anton Osika

**English:**
I mean the team is everything in building a great product, so I just give a big shout-out to the team that has written the code. I haven't written much of the code recently, I would say. You want people who can ship really fast and have good taste for what this simple, what's the right abstractions and I think that's what we've done differently and have this obsession for us making it better and better and better.

**中文翻译:**
我的意思是，在构建伟大产品时，团队就是一切。所以我要向编写代码的团队致敬。我想说，我最近没怎么写代码。你需要那些能够快速交付，并且对什么是简洁、什么是正确的抽象有良好品味的人。我认为这就是我们做得不同的地方，并且我们有一种执念，要让它变得越来越好。

---

### [00:32:17] Lenny Rachitsky (Ad Segment: Fundrise)

**English:**
This episode is brought to you by the Fundrise Flagship Fund. Full disclosure, real estate investing is boring. Prediction markets are exciting. Meme coins are a thrill ride. Even the stock market can swing wildly on a headline. Hello Deepseek. But with real estate and investing there's no drama or adrenaline or excuses to refresh your portfolio every few minutes. Just bland and boring stuff like diversification and dividends. So you won't be surprised to learn that the Fundrise Flagship real estate fund is a complete snoozefest. The fund holds 1.1 billion dollars worth of institutional caliber real estate managed by team of pros focused on steadily growing your net worth for decades to come, see? Boring.
(00:32:59):
That's the point. You can start investing in minutes and with as little as $10 by visiting Fundrise.com slash Lenny. Carefully consider the investment objectives, risks, charges and expenses of the Fundrise Flagship fund before investing. Find this information and more in the fund's prospectus at fundrise.com slash flagship. This is a paid ad.

**中文翻译:**
本期节目由 Fundrise 旗舰基金赞助。坦白说，房地产投资很无聊。预测市场很刺激，Meme 币像过山车，甚至股市也会因为一个头条新闻而剧烈波动（你好，Deepseek）。但在房地产投资中，没有戏剧性，没有肾上腺素，也没有理由每隔几分钟就刷新一次投资组合。只有平淡乏味的东西，比如多元化和分红。所以，当你听说 Fundrise 旗舰房地产基金完全是个“催眠曲”时，你不会感到惊讶。该基金持有价值 11 亿美元的机构级房地产，由专业团队管理，专注于在未来几十年稳步增长你的净资产。看吧？很无聊。
(00:32:59):
但这正是重点。你可以在几分钟内开始投资，只需 10 美元，访问 Fundrise.com/Lenny。在投资前，请仔细考虑 Fundrise 旗舰基金的投资目标、风险、费用和开支。在 fundrise.com/flagship 查看基金招股说明书中的这些信息及更多内容。这是一则付费广告。

---

### [00:33:22] Lenny Rachitsky

**English:**
Okay, I want to come back to the team. I know you have a lot of thoughts there in terms of writing code, how much do you guys actually use AI to write the code that is building Lovable? How does that work on your team?

**中文翻译:**
好，我想回到团队的话题。我知道你在编写代码方面有很多想法。你们在构建 Lovable 的过程中，实际上有多少代码是使用 AI 编写的？你们团队内部是如何运作的？

---

### [00:33:32] Anton Osika

**English:**
We have set up lovable so that we can change lovable with itself. We have done that. There is a lot of hyper-specific things in terms of running a separate... We spin up a dedicated computer for each user. It doesn't do everything. Lovable doesn't do everything. So we use the tools that are for developers, not for the 99%, most of the time. And everyone uses AI all the time in writing code. It's also in great course for experimentations.

**中文翻译:**
我们设置了 Lovable，让它可以用 Lovable 自身来改变 Lovable。我们已经做到了。在运行独立的……我们为每个用户启动一台专用计算机方面，有很多非常具体的技术细节。它并不做所有事情，Lovable 并不包揽一切。所以大多数时候，我们使用的是面向开发者的工具，而不是面向那 99% 普通人的工具。而且每个人在写代码时都一直在使用 AI。这也是进行实验的绝佳方式。

---

### [00:34:10] Lenny Rachitsky

**English:**
And are there tools like Cursor and stuff like that? Like any tools you can share right now?

**中文翻译:**
会有像 Cursor 之类的工具吗？有没有什么你现在可以分享的工具？

---

### [00:34:14] Anton Osika

**English:**
Yeah. I think Cursor is the one that almost everyone uses in the team.

**中文翻译:**
是的。我想 Cursor 是团队里几乎每个人都在用的工具。

---

### [00:34:19] Lenny Rachitsky

**English:**
Yeah. Okay, cool. I did a survey recently on tools that my listeners and readers use in cursor. 17% of all people that read my newsletter use Cursor already, which is absurd and you guys are in there, too. Okay, so kind of along these lines, there's obviously other competitors and companies in this space, so everyone's always wondering, you, Bolt, Replit, Cursor is a different kind of thing. What's the simplest way to understand maybe how Lovable might be different from say Bolt and Replit, which I think are probably the closest.

**中文翻译:**
好的，太酷了。我最近对我的听众和读者使用的工具做了一个调查。17% 的读者已经在使用 Cursor 了，这很惊人，你们也在其中。好，顺着这个思路，这个领域显然还有其他竞争对手和公司，大家总是在想：你们、Bolt、Replit，而 Cursor 是另一种东西。要理解 Lovable 与 Bolt 和 Replit（我认为它们最接近）的区别，最简单的方式是什么？

---

### [00:34:49] Anton Osika

**English:**
The packaging for non-technical people is what we aim for and I showed you in the demo that you can edit the text, you can change the colors and so on instantly without having to go into the code editor and without having to wait about 30 seconds for the AI do the full change. So that's the big way that we think about packaging it. And then for making sure that this can be used as productively as possible in a larger team. Something that's different from I think all the other tools is that it is synchronized with GitHub and that means that you can use Cursor, or the people in your team that want to be more low-level, they can use Cursor and while the people who don't want to mess and set up their local file system and commit to GitHub and so on, they can use Lovable's.
(00:35:48):
Not getting stuck is I think the most important thing for people. And that's why we entered this space late, we haven't done the same type of marketing as many others and we still, from the people that I talked to, ranked as the one that works most reliably.

**中文翻译:**
我们的目标是面向非技术人员的封装。我在演示中展示了你可以立即编辑文本、更改颜色等等，而无需进入代码编辑器，也不必等待 AI 花 30 秒完成整个更改。这就是我们考虑封装的主要方式。其次是确保它能在更大的团队中尽可能高效地使用。我认为与所有其他工具不同的一点是，它是与 GitHub 同步的。这意味着你可以使用 Cursor，或者你团队中想要进行底层操作的人可以使用 Cursor，而那些不想折腾本地文件系统、提交 GitHub 等操作的人可以使用 Lovable。
(00:35:48):
我认为对人们来说，最重要的事情是“不卡住”。这就是为什么我们进入这个领域较晚，也没有像其他公司那样做大量的营销，但据我接触过的人反馈，我们仍然被认为是运行最可靠的一个。

---

### [00:36:06] Lenny Rachitsky

**English:**
I love it. Okay. So this point about how you can just use Lovable to build a lot of it for you and then get into Cursor to edit and tweak is a really big point. And you're saying other companies aren't as good at that. I don't know if any other does that.

**中文翻译:**
我喜欢这一点。所以，你可以先用 Lovable 帮你构建大部分内容，然后进入 Cursor 进行编辑和微调，这是一个非常重要的点。你是说其他公司在这方面做得没那么好？我不知道是否还有其他公司能做到这一点。

---

### [00:36:06] Anton Osika

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:36:23] Lenny Rachitsky

**English:**
I don't think they let you do that. Amazing. Okay. And then what's the vision for Lovable? What's the end state of this? Is this everybody can build anything they want sort of thing? What's the simplest way to understand where you're going in the next, I don't know, five, 10 years.

**中文翻译:**
我想他们确实没让你这么做。太棒了。好，那么 Lovable 的愿景是什么？它的最终状态是怎样的？是那种“每个人都能构建任何他们想要的东西”吗？要理解你们在未来 5 到 10 年的发展方向，最简单的方式是什么？

---

### [00:36:37] Anton Osika

**English:**
I have to say. So we're building the last piece of software and it is inherently very hard to predict how the world looks like in five years. These days it's very hard. But the last piece of software, how I see that is that it's almost instant to go from what you want to change in the product or what product you want to build to having it fully working end-to-end, integrated with any of your existing systems or integrated with the very powerful third-party providers. Already today you can just ask, add and chat with OpenAI and then you get the chat with OpenAI in your product. But that's just working perfectly is something that's coming in the coming two years, I would say. And then after that there is a lot of things in building a product that is not just the engineering side, right? And I think an AI can be very useful in aggregating and understanding your users.
(00:37:42):
So, if you use the analytics tools, you know that there is something quite common which is to see how users have interacted with the product. AIs can do that on an absolutely massive scale and propose changes to a human to say, "Oh, yeah, that sounds like a good change to make it a bit more intuitive." And it can also automatically run A-B tests so that you can see the data, all these improvements to the product. I think that's on the horizon as well, quite.

**中文翻译:**
我得说，我们正在构建最后一款软件，而预测五年后的世界本质上是非常困难的，尤其是现在。但我所理解的“最后一款软件”是：从你想改变产品中的某个东西或你想构建什么产品，到它完全端到端运行、与你现有的任何系统集成或与强大的第三方供应商集成，几乎是瞬间完成的。今天你已经可以直接要求“添加与 OpenAI 的聊天功能”，然后你的产品里就有了这个功能。但我认为，让这一切完美运行是未来两年内会实现的事情。在那之后，构建产品还有很多工程以外的事情，对吧？我认为 AI 在聚合和理解用户方面会非常有用。
(00:37:42):
如果你使用过分析工具，你会知道查看用户如何与产品交互是很常见的。AI 可以以绝对巨大的规模完成这项工作，并向人类建议更改，比如：“噢，是的，这看起来是一个让产品更直观的好改动。”它还可以自动运行 A/B 测试，让你看到数据和所有这些对产品的改进。我认为这也很近了。

---

### [00:38:15] Lenny Rachitsky

**English:**
What's interesting about this in one way is people wonder just what jobs will be more important, what skills will be less important? Let me share a thought I have and then I want to get your take and see where you go with this. It feels like what is getting more valuable is being good at figuring out what to build and then knowing if the thing you had built is correct and good and ready. So it's like discovery, ideation, idea, part of the step of launching a product and then it's like taste and craft. Just like is this the thing? Is this going to solve people's problems because the building now is being done more and more and it's interesting, it used to be the reverse engineering was the hardest, most valuable skill and now it's figuring out what to build.
(00:38:59):
You could sit there and you could just tell it what to build and a lot of people get to your screen I'm sure and they're like, "I don't know what to build, I don't know what people want." And it's like that's the thing now. So just reactions to that and thoughts on what's skills will matter more and less.

**中文翻译:**
从某种角度来看，有趣的是人们会好奇哪些工作会变得更重要，哪些技能会变得不那么重要。让我分享一个想法，然后我想听听你的看法。感觉现在变得越来越有价值的是：擅长弄清楚该构建什么，然后知道你构建出来的东西是否正确、优秀且准备就绪。所以这就像是发现（discovery）、构思（ideation）、创意，这些发布产品的步骤，然后是品味（taste）和工艺（craft）。比如：这就是那个东西吗？这能解决人们的问题吗？因为“构建”本身正越来越多地被自动化。有趣的是，以前工程实现是最难、最有价值的技能，而现在变成了弄清楚该构建什么。
(00:38:59):
你可以坐在那里直接告诉它建什么，但我敢肯定很多人看到你们的界面时会想：“我不知道该建什么，我不知道人们想要什么。”这就是现在的关键。所以，你对此有什么反应？你认为哪些技能会变得更重要或更不重要？

---

### [00:39:13] Anton Osika

**English:**
I mean if you're a founder or you want to build something. Yeah, I totally agree that figuring out what are pain points and seeing there are often currently solutions, some kind of solution to everything. How can you make this 10X better somehow figuring that out is super important when you have an existing product. Then I think taste and tasting what is good is even more of the important part. The engineer skill set is still going to be important because that helps you understand what are the constraints, so what you can build and I just think a lot of software engineers are probably a bit scared now like, "Okay, am I out of a job? What's going to happen?" But they should see themselves as the people who translate the problems that are stated a human, probably, to technical solutions, but they do have to abstract themselves up a few steps, not just looking at in their tech stack like oh I can just do the front end changes. Engineers or technical people are very good at understanding what are the constraints technically and they should see themselves as that translators.

**中文翻译:**
我的意思是，如果你是一个创始人或者你想构建一些东西，我完全同意：弄清楚痛点在哪里，并看到目前通常已经有了各种解决方案。如何能让它好上 10 倍？在已有产品的情况下，弄清楚这一点至关重要。然后我认为品味（taste）和鉴赏什么是好东西变得更加重要。工程师的技能组合仍然很重要，因为这能帮你理解约束条件是什么，从而知道你能构建什么。我只是觉得很多软件工程师现在可能有点害怕，觉得“好吧，我要失业了吗？会发生什么？”但他们应该把自己看作是将人类描述的问题转化为技术解决方案的人。不过，他们确实需要把自己提升几个抽象层次，而不仅仅是盯着他们的技术栈，比如“哦，我只能做前端更改”。工程师或技术人员非常擅长理解技术上的约束，他们应该把自己视为那种翻译者。

---

### [00:40:30] Lenny Rachitsky

**English:**
Is it almost like you want to learn the eng manager skill of overseeing engineers versus the actual engineering skill or you think it's still going to be really important to learn how to code and be really good at that?

**中文翻译:**
这听起来像是你更应该学习工程经理（EM）监督工程师的技能，而不是实际的工程技能？还是说你认为学习如何写代码并精通它仍然非常重要？

---

### [00:40:44] Anton Osika

**English:**
I mean doing a bit of everything. Being a generalist is I think much more important than it used to be. And if I'm putting together a product team today, I would re-obsess about getting as many skill sets as possible for each person I hire. They should know how architecting a system works, preferably they should know the sign, they should have product taste, they should know how to talk to users. I think everyone should know a bit of all of that, preferably.

**中文翻译:**
我的意思是，什么都得懂一点。我认为做一个“全才”（generalist）比以前重要得多。如果我今天要组建一个产品团队，我会重新执着于让我雇佣的每一个人都拥有尽可能多的技能组合。他们应该知道系统架构是如何运作的，最好懂设计，有产品品味，知道如何与用户交谈。我认为理想情况下，每个人都应该对这些领域略知一二。

---

### [00:41:17] Lenny Rachitsky

**English:**
Easier said than done. It's hard to find people that know all these things. So let's segue to hiring and how you hire. How many people do you have at this point? Is that something you share?

**中文翻译:**
说起来容易做起来难。很难找到精通所有这些领域的人。那让我们转到招聘话题，你们是怎么招聘的？你们现在有多少人？这个可以分享吗？

---

### [00:41:27] Anton Osika

**English:**
Yeah, now we're at 18.

**中文翻译:**
是的，现在我们有 18 个人。

---

### [00:41:29] Lenny Rachitsky

**English:**
18. Okay. Wow. I love that you... It sounded like you're about to say, "Oh, we have a hundred people now." No, 18. Okay, so you went from 15 to 18. Okay, great. So what do you look for when you're hiring people? The way I saw you describe it on Twitter is you look for cracked engineers, the best crack team in Europe, things like that. I guess just specifically what are you looking for when you're hiring?

**中文翻译:**
18 个。哇。我喜欢你刚才的语气……听起来你好像要说“哦，我们现在有一百人了”，结果只有 18 个。好，所以你们从 15 人增加到了 18 人。太棒了。那么你在招人时看重什么？我看到你在推特上描述说，你在寻找“顶级大牛”（cracked engineers），欧洲最顶尖的精英团队之类的。我想知道，具体来说，你在招聘时在寻找什么？

---

### [00:41:52] Anton Osika

**English:**
I think the most important thing is that people care a lot and they're not just like, "Oh, I'm here for a job. I'm here for being just a passenger on this journey," but everyone should really care about the product, the users and care a ton about the team, how the team works together and that you're always contributing to making the team work more productively together and that care or preferably obsession gets you a very long way and then you do often want to have absolute superpower in some dimension to be able to understand and do as many possible things as possible, have this generalist brain that quickly learns any skill but be super, super good in one dimension. And for us that's mostly cramming as much out of AI, out of the large language models and understanding the entire parameter space of what you can change to make our product perform better.

**中文翻译:**
我认为最重要的一点是人们要非常在意（care a lot）。他们不应该只是觉得“哦，我只是来打份工，只是这段旅程中的一名乘客”。每个人都应该真正关心产品、关心用户，并且非常关心团队——团队如何协作，以及你是否总是在为提高团队生产力做贡献。这种“在意”或者说“痴迷”能让你走得很远。然后，你通常还需要在某个维度上拥有绝对的“超能力”，能够理解并处理尽可能多的事情，拥有一种能快速学习任何技能的“全才大脑”，但在某个维度上又极其出色。对我们来说，这主要是指能从 AI 和大语言模型中榨取最大的价值，并理解所有可以改变的参数空间，从而让我们的产品表现得更好。

---

### [00:42:58] Lenny Rachitsky

**English:**
So, how do you actually test for these things? Some of these things describe, I think everyone's looking for, they care about the user, they want to collaborate well. Because you have 18 people building in a company that's growing more than a million ARR every week. That's an absurd scale and the people you have found are clearly world-class and I think a lot of people are going to want to hire the type of people you're hiring. So when you're actually interviewing, how do you suss out some of these things like their AI cramming skills, their team building collaboration, what do you actually do?

**中文翻译:**
那么，你实际上是如何测试这些素质的？你描述的一些特质我想每个人都在找，比如关心用户、善于协作。但你们只有 18 个人，却在支撑一家每周增长超过 100 万美元 ARR 的公司。这规模太离谱了，你找到的人显然是世界级的。我想很多人都会想雇佣你正在招揽的那种人才。所以当你面试时，你如何察觉出他们的 AI 榨取能力、团队协作能力？你具体是怎么做的？

---

### [00:43:32] Anton Osika

**English:**
I ask people what they've done before and these people that I'm describing, they have often done something where they care a lot about what they've done before and dig into details about the technical things that they did. And then we do the normal thing of showing a very hard problem that is a bit unorthodox that someone hasn't seen before preferably and see how they think through thinking research through that. Then something that I think is more uncommon is that we do, I pretty much always have people join the work simulation for at least a day, often a full week.

**中文翻译:**
我会问人们以前做过什么。我描述的这类人，通常对他们以前做过的事情非常投入，并且会深入探讨他们所做的技术细节。然后我们会做一些常规操作，比如给出一个非常难、有点不寻常且对方最好没见过的问题，看他们如何思考和研究。然后，我认为比较少见的一点是，我几乎总是让候选人参加至少一天、通常是一整周的“工作模拟”。

---

### [00:44:13] Lenny Rachitsky

**English:**
Awesome. Okay, so work trial. That's awesome. So basically they work with the team for at least a day. You said sometimes a week, and I love this point you made about they care deeply about something they previously worked on and you look for just obsession with the thing that they built last or something they worked on. What percentage are engineers of these 18?

**中文翻译:**
太棒了。所以是“试工”（work trial）。这很棒。基本上他们会和团队一起工作至少一天，有时是一周。我喜欢你提到的那一点：他们对自己以前做过的事情深切关注，你会寻找他们对上一个构建的东西或参与的工作的某种“痴迷”。在这 18 个人中，工程师占多大比例？

---

### [00:44:39] Anton Osika

**English:**
So 12 at least write code at least part-time.

**中文翻译:**
至少有 12 个人至少是兼职写代码的。

---

### [00:44:44] Lenny Rachitsky

**English:**
12 out of 18. Okay, cool. When we were setting up, you're like, "Oh, our engineer's creating content now." I think that's a cool example of how people do a lot of different things. Also. Okay, so I have your job posting that you shared once of the actual job description. I'm going to read a few lines from it. It's very inspired by Shackleton, right?

**中文翻译:**
18 个里有 12 个。好，酷。我们准备录制时，你说：“噢，我们的工程师现在正在创作内容。”我认为这是一个人们身兼数职的很酷的例子。好，我这里有你曾经分享过的一份实际职位描述。我要读几行。它非常受沙克尔顿（Shackleton，南极探险家）的启发，对吧？

---

### [00:45:07] Anton Osika

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:45:07] Lenny Rachitsky

**English:**
Would you agree? Cool. I love it. By the way, did you write this or did you have AI write this job description where you create an engineering job description? In fact, let me read it to you. I don't even know, you may not know what M you're referring to. I'll read a few lines here. "Long hours, high pace, candidates must thrive under a high urgency under AGI timelines approaching, difficult mission ahead, honor and recognition in case of success, those seeking comfortable work need not apply." And then there's a few other things, "Collaboration with other exceptional minds, purpose larger than any normal engineering role, generous share in the venture success." Amazing.

**中文翻译:**
你同意吗？酷，我喜欢。顺便问一下，这是你写的，还是你让 AI 写的？让我读给你听，你可能都不记得具体内容了。我读几行：“工作时间长，节奏快，候选人必须在 AGI（通用人工智能）时间线临近的高度紧迫感下茁壮成长。前方任务艰巨，成功将获得荣誉和认可，寻求舒适工作者请勿申请。”然后还有几条：“与其他杰出人才协作，使命感超越任何普通工程职位，慷慨分享创业成功的果实。”太精彩了。

---

### [00:45:44] Anton Osika

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:45:44] Lenny Rachitsky

**English:**
Thoughts?

**中文翻译:**
有什么感想？

---

### [00:45:45] Anton Osika

**English:**
Yeah, so I did get some help with the formatting of this, but then it was mostly me doing the exact phrasing of the different sentences.

**中文翻译:**
是的，我在格式化方面确实得到了一些帮助，但不同句子的具体措辞主要是我自己完成的。

---

### [00:45:56] Lenny Rachitsky

**English:**
So good. And I love that to some people it's going to be like, "Holy shit, I'm not signing up for this." But to a lot of people, the people you want is like, "Yes, this is exactly what I want to be doing."

**中文翻译:**
太棒了。我喜欢这一点，对某些人来说，他们会觉得“天哪，我才不干这个”，但对很多人——也就是你想要的那种人——来说，他们会觉得“没错，这正是我想要做的”。

---

### [00:46:07] Anton Osika

**English:**
Great.

**中文翻译:**
太好了。

---

### [00:46:07] Lenny Rachitsky

**English:**
Amazing.

**中文翻译:**
太神奇了。

---

### [00:46:08] Anton Osika

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:46:08] Lenny Rachitsky

**English:**
Okay, cool. So it feels like one of the elements of hiring here is, create a really good filter to be clear about just how intense this is so that the people that want that are the ones drawn to you. Okay. And then you're also, you're in Sweden, fastest growing startup in Europe ever thoughts on building in Europe slash Sweden versus the US slash San Francisco?

**中文翻译:**
好，酷。所以感觉招聘的一个要素是：建立一个非常好的过滤器，明确说明工作的强度，这样那些渴望这种环境的人就会被你吸引。好。另外，你在瑞典，那是欧洲增长最快的初创公司。关于在欧洲/瑞典构建公司，与在美国/旧金山构建公司相比，你有什么看法？

---

### [00:46:34] Anton Osika

**English:**
Yeah, so this ambition level that you're talking about in the job ad is more uncommon in Sweden and I think that is the biggest unlock that someone like me, sees that this is the time in human history when you have the most impact for a worked hour and that's why we have to be super ambitious, just up the ambition level and then we can maybe retire and have AI take care of most things in society and inspiring people to be this ambitious in a place where the average ambition is lower but the talent, the raw talent is much more available, is a great recipe. I think that's a great recipe. And that's, I think it's some kind of advantage there. It is a bit of a double-edged sword but it's some kind of advantage.

**中文翻译:**
是的，你在招聘广告中提到的这种雄心水平在瑞典比较少见。我认为最大的突破口在于，像我这样的人看到，现在是人类历史上单位工作时间产生影响最大的时刻。这就是为什么我们必须超级有雄心，提高雄心水平，然后也许我们就可以退休，让 AI 处理社会的大部分事务。在一个平均雄心水平较低但原始人才储备非常充足的地方，激励人们变得如此有雄心，这是一个绝佳的秘诀。我认为这是一个伟大的秘诀。这在某种程度上是一种优势。虽然是一把双刃剑，但确实是一种优势。

---

### [00:47:34] Lenny Rachitsky

**English:**
So what I'm hearing is there's incredible people in Europe, they're just not, they're harder to find and what I'm hearing is the key is how do you suss them out and get them to want to talk to you?

**中文翻译:**
所以我听到的是，欧洲有非常出色的人才，只是他们……更难被发现。关键在于你如何识别出他们，并让他们愿意和你交流？

---

### [00:47:49] Anton Osika

**English:**
Most people in Europe, they haven't thought that, "Oh, going on an extremely ambitious mission is what I want to do." So that's figuring out who those are is a big part of it.

**中文翻译:**
欧洲的大多数人还没想过“噢，参与一项极具雄心的使命正是我想要做的”。所以，找出这些人是谁是很大一部分工作。

---

### [00:48:01] Lenny Rachitsky

**English:**
Awesome. Okay. I want to talk about prioritization. I imagine all these things that I just shared about just how ambitious this mission is, how much you're doing the last piece of software, you must have a bazillion things that people ask you to build that you want to build. What's your approach to deciding what to prioritize and actually build?

**中文翻译:**
太棒了。好，我想聊聊优先级排序。我能想象，既然这个使命如此宏大，你们在做“最后一款软件”，肯定有无数人要求你们构建的东西，以及你们自己想构建的东西。你决定优先处理什么以及实际构建什么的策略是什么？

---

### [00:48:21] Anton Osika

**English:**
Just top line? I think identifying what is the biggest bottleneck, what's the biggest problem and iterating fast on saying, "Okay, this is the biggest problem, let's really, really solve that problem." And then picking in the next one and not overthinking, not dreaming out the long roadmap, that's my [inaudible 00:48:41]. There's a very, very simple algorithm. Understanding what is the, mostly the biggest problem is not always a simple problem I think. Yeah, so we spend time as one should on talking to users, reading up on what people are writing. We have the feature board for where people do a lot of requests, as you say. And then when we pick one of the problems, we are quite engineering-led. For a product like ours, it's hard to be have product managers that are not engineers say, oh, this is what we should do now because the right solution to the problem might be entangled in things that are technical details.
(00:49:32):
They might be entangled in technical details of like, "Okay, yes, this is the biggest problem, but we should have this larger technical initiative that's going to solve all of these problems." So it's quite engineering-led compared to many other product companies.

**中文翻译:**
最核心的？我认为是识别出最大的瓶颈是什么，最大的问题是什么，然后快速迭代并说：“好，这是最大的问题，让我们彻底解决它。”然后再选下一个。不要过度思考，不要空想长期的路线图，这就是我的逻辑。这是一个非常非常简单的算法。我认为，理解什么是最大的问题通常并不简单。是的，我们会像大家一样花时间与用户交谈，阅读人们写的东西。正如你所说，我们有一个功能看板，人们在那里提出很多请求。当我们选中一个问题时，我们是非常“工程导向”的。对于像我们这样的产品，很难让非工程师出身的产品经理说“哦，我们现在应该做这个”，因为问题的正确解决方案可能与技术细节纠缠在一起。
(00:49:32):
它们可能纠缠在类似这样的技术细节中：“好，是的，这是最大的问题，但我们应该启动这个更大的技术方案，它将一次性解决所有这些问题。”所以与许多其他产品公司相比，我们非常受工程驱动。

---

### [00:49:48] Lenny Rachitsky

**English:**
As it should. I'd be worried if you guys had a product manager at this point, that wouldn't make no sense right now. I imagine the answer is it's chaos and there's no actual defined process, but just what does it look like generally? What's kind of the cadence you guys operate on? How do you take an idea to build it, spec it, launch it? Just what does that look like if you have something?

**中文翻译:**
理应如此。如果你们现在就有产品经理，我反而会担心，那现在根本没意义。我猜答案是目前还处于混沌状态，没有真正定义的流程，但通常情况下它看起来是怎样的？你们的运作节奏是怎样的？你们如何将一个想法转化为构建、编写规格说明并发布？如果有的话，那个过程是怎样的？

---

### [00:50:10] Anton Osika

**English:**
If you look back three months, we mainly said, "Okay, let's do this weekly planning." We do have a big jam board where we have all the main problems and then we have kind of ranked them which else do we focus or when we focus on next or this week? And then we have a demo where we say, "Okay, these are things we ship this week." So to get everyone on the same page, we do have a bit more of a roadmap now, where we say we are going to make so sure you can support custom domains. Next, they're going to add collaboration after that. And the biggest problem now or the biggest initiative now that solves the biggest problem is making the system more agentic and that has a bit of a longer roadmap, but we still do the cadence of weekly planning. These are the things we're focusing on. This week, it's mostly... There's a good word for this that I would want your help with, but polish, we were fixing the bugs and polish this week and that was the planning on Monday.

**中文翻译:**
回看过去三个月，我们主要说：“好，让我们做周计划。”我们确实有一个大的 FigJam 看板，上面列出了所有主要问题，然后我们会对它们进行排序：我们接下来或这周要关注哪些？然后我们有一个演示环节，我们会说：“好，这些是我们这周交付的东西。”为了让大家步调一致，我们现在确实有了一个更明确一点的路线图，比如我们会说我们要确保支持自定义域名，接下来要添加协作功能。而目前最大的问题或解决最大问题的最大举措是让系统更具“智能体特性”（agentic），这有一个稍长一点的路线图，但我们仍然保持周计划的节奏。这些是我们正在关注的事情。这周主要是……我需要你帮我想个好词，就是“打磨”（polish），我们这周在修复 Bug 和打磨产品，那是周一计划好的。

---

### [00:51:21] Lenny Rachitsky

**English:**
That was actually this week was polish, polish week. I love that. How far is this roadmap that you are now having?

**中文翻译:**
所以这周实际上是“打磨周”。我喜欢这个。你现在的路线图规划到多远以后了？

---

### [00:51:28] Anton Osika

**English:**
I mean it's clear over the coming month, but it stretches out three months, but in one month it's probably going to look a bit different.

**中文翻译:**
我的意思是，未来一个月是很清晰的，它延伸到了三个月，但一个月后它可能会看起来有点不一样。

---

### [00:51:39] Lenny Rachitsky

**English:**
Okay. And then what are the tools you use just for folks that want to understand the latest tools? So you said FigJam, what else is in that stack of tools?

**中文翻译:**
好。那么你们使用的工具还有哪些？为了让那些想了解最新工具的人明白。你提到了 FigJam，你们的工具栈里还有什么？

---

### [00:51:46] Anton Osika

**English:**
I mean we do so many things in our company in Linear because it's just amazing product. So we do talent application tracking in Linear and after going through and this thing, lot of the other custom-made tools for that Linear and then FigJam.

**中文翻译:**
我们在公司里用 Linear 做很多事情，因为它真的是个很棒的产品。我们在 Linear 里做人才申请跟踪，在尝试了很多其他定制工具后，我们还是选了 Linear，然后就是 FigJam。

---

### [00:52:06] Lenny Rachitsky

**English:**
So simple. How soon until one of your engineers is an agent engineer, an AI Engineer, do you have a sense?

**中文翻译:**
真简单。你觉得还要多久，你们的工程师中就会出现一个“智能体工程师”或“AI 工程师”？你有感觉吗？

---

### [00:52:06] Anton Osika

**English:**
I love to dig into what does that question actually mean? I think we've been talking about, Oh, AI that would require something playing chess, that's AI. If a computer can play chess, that's AI and now that's like, Oh no, that's a chess program and which always shifting this forward and forward. I think anything that a human doesn't do is just a smart computer system, right? When is an software engineer and agent, I think it's always going to be just we're building in... Lovable is just an interface that humans interact with to create the software that they want and then how we solve that, we said going to be an agent under some definition. Yeah, sure. I think so, but that's less important to me.

**中文翻译:**
我很想深究一下这个问题到底是什么意思。我想我们一直在讨论，噢，AI 曾经是指能下国际象棋的东西。如果电脑能下棋，那就是 AI，而现在人们会说：“噢不，那只是个象棋程序。”这个定义总是在不断向前推移。我认为任何人类不做的事情都只是一个智能计算机系统，对吧？软件工程师什么时候变成智能体？我认为它永远只是……Lovable 只是一个人类与之交互以创建他们想要的软件的界面，至于我们如何实现它，在某种定义下它会是一个智能体。是的，当然，我是这么认为的，但这对我来说没那么重要。

---

### [00:53:15] Lenny Rachitsky

**English:**
Okay, I like that. Let me ask this, you guys are moving super fast, scaling like crazy. You described a little bit about your process, weekly planning, FigJam board of ideas and now there's a roadmap that you're kind of thinking out in the future. Is there anything else that you found helps you move this fast that gives you a lot of leverage over the small team you have to ship quickly and move fast that you haven't already mentioned?

**中文翻译:**
好，我喜欢这个回答。让我问问这个：你们动作超级快，扩张得也疯。你描述了一点你们的流程：周计划、FigJam 创意看板，以及现在正在构思的未来路线图。除了你已经提到的，还有什么你发现能帮助你们如此快速行动、让这个小团队获得巨大杠杆作用以快速交付和移动的东西吗？

---

### [00:53:40] Anton Osika

**English:**
We work from the office most of the time. I think it's pretty nice. Then you can say like, "Hey, I think we're thinking wrong about this thing," or, "Shouldn't we actually do this other thing?" And especially I think lunch, eating lunch together is a pretty productive hour where you're cross pollinating. I mean people are constantly thinking subconsciously as well about how to solve these different problems and which the most important ones are. And then being in office has this focus or most of the time usually focus, but you also have this high bandwidth where everyone has to be down structured communication.

**中文翻译:**
我们大部分时间都在办公室工作。我觉得这很棒。你可以直接说：“嘿，我觉得我们这件事想错了，”或者“我们不应该做另一件事吗？”特别是午餐，一起吃午餐是非常高效的一小时，大家可以进行“跨界交流”。我的意思是，人们潜意识里也在不断思考如何解决这些不同的问题，以及哪些问题最重要。在办公室工作能让你保持专注（通常情况下），而且你还拥有这种高带宽的沟通环境，大家不必非得通过结构化的方式交流。

---

### [00:54:18] Lenny Rachitsky

**English:**
I love that. The answer to the CEO of a company that's one of the most advanced AI tools in the world is one of your answers to how to move fast is lunch together. I love that. That's so human and so it makes all the sense in the world, but I love that that's still a part of this.

**中文翻译:**
我太喜欢这个了。作为世界上最先进的 AI 工具之一的公司的 CEO，你关于如何快速行动的答案之一竟然是“一起吃午餐”。我喜欢这一点。这非常人性化，而且完全合情合理，但我很喜欢这仍然是其中的一部分。

---

### [00:54:34] Anton Osika

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:54:36] Lenny Rachitsky

**English:**
Okay. You talked about this kind on the same thread you talked about if you were to start a team, like a new product team today, say you were head of product somewhere or head of RPM, VP of product somewhere building a new product team, scaling a product team, what would you do going forward that's different from what people have done in the past in terms of who you're hiring, how you're structuring them, that kind of thing? Just what do you think people should be thinking as they build product teams going forward? Knowing tools like Lovable exist and all the other stuff that's going on.

**中文翻译:**
好。顺着这个话题，你谈到如果你今天要组建一个团队，比如一个新的产品团队，假设你是某地的产品负责人或产品副总裁，正在组建或扩展一个产品团队，在招聘人选、团队架构等方面，你会做哪些与过去不同的事情？在知道 Lovable 这样的工具存在以及所有其他正在发生的事情的情况下，你认为人们在未来组建产品团队时应该考虑什么？

---

### [00:55:13] Anton Osika

**English:**
I mean everyone should be excited about using AI. I think that's a pretty big ones. And then the team working really well together is, like the lunch, you have to sit down and solve problems together. The bottleneck for most products these days is not going to be as much on engineering, but having good taste, good intuition about your users. And that, engineers and everyone preferably in the team should have that willingness at least to want to go through that motion and listen to the users and truly understand what they care about.

**中文翻译:**
我的意思是，每个人都应该对使用 AI 感到兴奋。我认为这是一个非常重要的点。然后是团队协作得非常好，就像午餐一样，你们必须坐下来一起解决问题。如今大多数产品的瓶颈将不再是工程实现，而是拥有良好的品味、对用户良好的直觉。工程师以及团队中的每个人最好都至少有那种意愿，愿意去经历那个过程，倾听用户并真正理解他们关心什么。

---

### [00:55:59] Lenny Rachitsky

**English:**
Well it's kind of like the background of most of the engineers and people you've hired. Is there anything in common? Are they just super impressive humans generally, like champions of programming contests, stuff like that? I don't know. What are some attributes of the folks you've hired so far?

**中文翻译:**
这有点像你雇佣的大多数工程师和员工的背景。他们有什么共同点吗？他们通常是那种超级厉害的人吗，比如编程竞赛冠军之类的？我不知道。你目前雇佣的人有哪些特质？

---

### [00:56:19] Anton Osika

**English:**
I think raw cognitive capability is the strongest, the strongest correlate of being at Lovable. But there is this startup mindset that I think is also very strong. Being much more interested in moving very fast and iterating fast, then having a lot of structure, a lot of process and thinking about the business as a whole. More than thinking about my specific profession, my specific craft that I'm seeing myself wanting to dig into on me.

**中文翻译:**
我认为“原始认知能力”是进入 Lovable 最强、最相关的关联因素。但还有一种“初创公司心态”，我认为也非常重要。比起拥有大量的结构和流程，他们对快速行动和快速迭代更感兴趣，并且会从整体业务的角度思考，而不仅仅是思考我特定的专业、我特定的手艺。

---

### [00:56:58] Lenny Rachitsky

**English:**
Amazing. Okay. So smart, very smart entrepreneurial, acts like an owner, isn't just like, this isn't just a job. But they feel like they actually have agency. Okay, this is great. There's something you said kind of along these lines that I think is important that one of the things that gets you excited about what you're building is giving people super powers and especially people that don't add a code, basically 99% of people. Is there anything along those lines that you think is important to share?

**中文翻译:**
太棒了。好。聪明，非常聪明，有创业精神，表现得像个主人，而不仅仅是觉得“这只是一份工作”。他们觉得自己真的有自主权。好，这很棒。你刚才说的一些话我觉得很重要：让你对正在构建的东西感到兴奋的事情之一，是赋予人们“超能力”，尤其是那些不会写代码的人，也就是那 99% 的人。关于这一点，你觉得还有什么重要的想分享吗？

---

### [00:57:27] Anton Osika

**English:**
It's very clear to most people who have been engineers or been founders, that there's so many that have failed in their endeavors because they didn't have someone that know how to solve the technical parts. And now that we're close to having people know that this exists and they solve everything, it's going to be an Cambrian explosion of entrepreneurship and better software product. We're not going to settle for all the annoying bad technology that we use today. And everyone who has an idea is going to say, "Okay, I'm going to build this thing and show you that this is the best version of the product or what our company should be doing," instead of having long meetings or writing up documents. So it's going to be empowering across a lot of different professions and places in the world.

**中文翻译:**
对于大多数当过工程师或创始人的人来说，很明显，有太多人在创业中失败是因为他们没有懂技术的人来解决技术问题。现在，我们接近于让人们知道这种工具的存在，并且它们能解决所有问题，这将引发一场创业和更优秀软件产品的“寒武纪大爆发”。我们不会再忍受今天使用的那些烦人且糟糕的技术。每个有想法的人都会说：“好，我要把这个东西做出来，向你展示这就是产品的最佳版本，或者这就是我们公司应该做的，”而不是开长会或写文档。所以，这将赋能全球许多不同的职业和地区。

---

### [00:58:33] Lenny Rachitsky

**English:**
What next for Lovable? What's the next few things they might launch as this episode comes out?

**中文翻译:**
Lovable 的下一步是什么？在这一集播出时，你们可能会发布哪几样新东西？

---

### [00:58:38] Anton Osika

**English:**
As I mentioned this agentic behavior, and when I say agentic, what it means is that you give more freedom to the system to decide what happens next. It might want to write a test, run those tests and say like, "Oh, the test failed, let's fix those." So that's one of the big unlocks for getting further faster. And then there's some more obvious things that you want to do to go all the way to easily go all the way to making money with Lovable. And that's like how do you set up so that it's hosted on your specific domain? How do you collaborate there seamlessly with your team and making that is here so that those are just obvious things and something we're thinking about is to help founders succeed after they built their first version. And how do they get more users? How do they get feedback? How do they get the word out if they build something useful?

**中文翻译:**
正如我提到的这种“智能体行为”（agentic behavior），我所说的“智能体特性”是指你赋予系统更多的自由来决定下一步发生什么。它可能想写一个测试，运行这些测试，然后说：“噢，测试失败了，让我们修复它们。”这是让我们走得更快、更远的重要突破之一。然后还有一些更显而易见的事情，你想让用户能通过 Lovable 轻松赚到钱。比如：如何设置以便它托管在你特定的域名上？如何与团队无缝协作？这些都是显而易见的事情。我们还在思考的是如何帮助创始人在构建完第一版后取得成功。他们如何获得更多用户？如何获得反馈？如果他们构建了有用的东西，如何传播出去？

---

### [00:59:42] Lenny Rachitsky

**English:**
I was just going to say that and that's exactly where my mind went is everyone's going to be building all these things. No one's ever going to get any traction with these tools. No one knows how to find users, get anyone to basically go to market. And growth is a whole different skill. So that is so cool that you're thinking about that. How do we run some paid ads for you? How do we think about SEO? How do we think about word of mouth, reality referrals? That is very cool. Okay.

**中文翻译:**
我正想说这个，我的想法和你完全一致：每个人都会构建所有这些东西，但如果没有这些工具，没人能获得增长。没人知道如何寻找用户，如何推向市场。增长是一项完全不同的技能。所以你正在考虑这一点真的很酷。比如：我们如何为你投放付费广告？我们如何考虑 SEO？我们如何考虑口碑传播和推荐？这非常酷。好。

---

### [01:00:06] Anton Osika

**English:**
Yeah, we already have playbooks that we help the people building with how do you do those things that you can find up on our blog?

**中文翻译:**
是的，我们已经有了“剧本”（playbooks），帮助人们学习如何做这些事情，你可以在我们的博客上找到。

---

### [01:00:15] Lenny Rachitsky

**English:**
Interestingly, this makes me want to buy some meta stock because all these apps that everyone's building, they're going to be running paid ads on Facebook and Google. Oh my god, what a good business those other guys get. I want to come back to, you said that you can work on your existing code base. This is actually a big question for a lot of people. They see all these tools, they're all amazing for prototypes and concepting. You talked about how you can actually do this within your existing code base, use Lovable.

**中文翻译:**
有趣的是，这让我想买点 Meta 的股票，因为大家构建的所有这些应用都会在 Facebook 和 Google 上投放付费广告。天哪，那些家伙的生意真好。我想回到你说的，你可以在现有的代码库上工作。这对很多人来说其实是个大问题。他们看到所有这些工具，觉得它们做原型和概念设计很棒。你刚才提到如何实际在现有代码库中使用 Lovable。

---

### [01:00:41] Anton Osika

**English:**
Let me correct you there. You cannot use it on any existing code base.

**中文翻译:**
让我纠正你一下。你目前还不能在任何现有的代码库上使用它。

---

### [01:00:46] Lenny Rachitsky

**English:**
Got it.

**中文翻译:**
明白了。

---

### [01:00:47] Anton Osika

**English:**
We kind of have a research preview of importing your code base, but what you can do is if you start in Lovable, then you can have engineers editing it in whatever tool they want to use for editing it.

**中文翻译:**
我们目前有一个导入代码库的研究预览版，但你能做的是：如果你在 Lovable 中开始，那么你可以让工程师在他们想用的任何工具中编辑它。

---

### [01:00:59] Lenny Rachitsky

**English:**
Okay, cool. That's great clarification. So I guess just for people, because most listeners here are not building something brand new, they're working within an existing product. So you're saying that that is coming, you can use Lovable in the future in some form with your existing app and product?

**中文翻译:**
好，酷。这是一个很好的澄清。我想对于大多数听众来说，因为他们不是在构建全新的东西，而是在现有的产品中工作。所以你是说这个功能即将推出，未来你可以以某种形式在现有的应用和产品中使用 Lovable？

---

### [01:01:15] Anton Osika

**English:**
Correct.

**中文翻译:**
没错。

---

### [01:01:16] Lenny Rachitsky

**English:**
Wow, that's huge. Okay. Because basically most people, so that's going to be a big deal. Okay. Final question. We have the segment on this podcast called Failure Corner, where most people come to this podcast, they show all these stories of success and everything's going great, and here's all the things always winning. You guys, this is a good example, just up into the right, the fastest growing product ever. What's an example when something totally failed in the course of your career and what did you learn from that?

**中文翻译:**
哇，那意义重大。好。因为基本上大多数人……所以那将是一件大事。好。最后一个问题。我们播客有一个叫“失败角落”（Failure Corner）的环节。大多数来这个播客的人都会展示成功的案例，一切都很顺利，总是在赢。你们就是一个很好的例子，曲线一直向上，史上增长最快的产品。在你的职业生涯中，有没有什么完全失败的例子？你从中学习到了什么？

---

### [01:01:49] Anton Osika

**English:**
I am a bit hard-pressed to find something that totally failed, but I think there's a bit of a product lesson where I was the first employee at an AI startup here in Stockholm called Summer Labs, and the premise was just, okay, so humans learn in different ways. If you personalize, then you get two standard deviations more effective learning. So there are a lot of products like education software that helps you learn that is not personalized. And we were building an API to personalize learning and the AI and so on, it was pretty good.
(01:02:34):
But the thing that we were doing in the end was to say like, Okay, here's this product. Someone has to build a product or some way to learn or be it like English thing Duolingo, and then the people that have that product have to use this advanced AI API to start making it personalized. And it is very hard retrofitting like, oh, you have to switch out the engine and put in this AI. And the big learning here is that it didn't work very well for the company. I mean, the company wasn't super successful in this. The big learning is that you have to start with how is this product working end-to-end and then add AI or think where should we add AI? So that was a big learning for me that you really want to see what does the big picture of the user, what's the big picture of how do you think the user experience should be? And then add something with AI to solve specific problems. And now Summer Labs is doing great, but it's not on top of that product specifically.

**中文翻译:**
我很难找到一个完全失败的例子，但我认为有一个产品教训。我曾是斯德哥尔摩一家名为 Summer Labs 的 AI 初创公司的第一号员工。前提是：人类学习的方式各不相同，如果你能实现个性化，学习效率就能提高两个标准差。当时有很多教育软件是不具备个性化的。我们当时在构建一个用于个性化学习的 API，AI 技术本身非常出色。
(01:02:34):
但我们最后做的事情是：好吧，这里有一个产品，有人必须构建一个产品或某种学习方式（比如像多邻国那样的英语学习应用），然后拥有该产品的人必须使用这个先进的 AI API 来开始实现个性化。而这种“改造”是非常困难的，比如你必须更换引擎并植入这个 AI。这个教训是，这对公司来说效果并不好，公司在这方面并不算超级成功。最大的教训是：你必须从“这个产品如何端到端运作”开始，然后再添加 AI，或者思考“我们应该在哪里添加 AI”。这对我来说是一个巨大的启发，即你真的需要看清用户的全貌，看清你认为的用户体验全貌，然后用 AI 来解决具体问题。现在 Summer Labs 发展得很好，但并不是基于那个特定的产品。

---

### [01:03:49] Lenny Rachitsky

**English:**
I think it's a lot of people hear this and they're like, of course, but I think it's so hard to actually remember this point when you have some cool tech and you're like, "Holy shit, everyone needs to try this. They're going to love it." And then you don't realize no one actually cares if it's not solving a problem for them. There's a lot of novelty products that everyone want to use for a little bit and then forget instant, I don't actually need this often. And so what this makes me think about is, there's all these product lessons for what is likely to help your product be successful. And an app like a tool like Lovable can help you do this because if someone is building something, you can guide them, Okay, what's the problem you're solving for somebody? How many people have this problem? How much does this matter to them?

**中文翻译:**
我想很多人听到这个会觉得“理所当然”，但当你拥有一项很酷的技术并觉得“天哪，每个人都得试试这个，他们会爱死它的”时，真的很难记住这一点。然后你没意识到，如果它不能解决他们的问题，根本没人关心。有很多新奇的产品，大家只想用一小会儿，然后立刻就忘了，因为“我其实不需要经常用这个”。所以这让我想到，有很多产品教训可以帮助你的产品获得成功。而像 Lovable 这样的工具可以帮助你做到这一点，因为如果有人在构建东西，你可以引导他们：好，你正在为谁解决什么问题？有多少人有这个问题？这对他们有多重要？

---

### [01:04:38] Anton Osika

**English:**
Maybe we should add the Lenny mode. It activates in Lovable, it activates this product coach. That would be infinite questions, like, "No, no, wait, hold on, why are you doing this?"

**中文翻译:**
也许我们应该添加一个“Lenny 模式”。在 Lovable 中激活它，就会激活这个“产品教练”。它会问无穷无尽的问题，比如：“不，不，等等，你为什么要这么做？”

---

### [01:04:50] Lenny Rachitsky

**English:**
Absolutely. Let's take a step back. Everyone's going to be like, "[inaudible 01:04:55], get out of my way."

**中文翻译:**
绝对的。让我们退后一步。大家肯定会说：“别挡我的路。”

---

### [01:04:57] Anton Osika

**English:**
[inaudible 01:04:57].

**中文翻译:**
（笑声）

---

### [01:04:56] Lenny Rachitsky

**English:**
Yeah, exactly. What's your experiment plan? I think there's actually a big opportunity there to save people. There's a play around with this thing and then there's like, okay, but really is this anything people actually want?

**中文翻译:**
是的，没错。你的实验计划是什么？我认为那里其实有一个巨大的机会来拯救人们。有一种是“玩玩这个东西”，另一种是“好吧，但这真的是人们真正想要的东西吗？”

---

### [01:05:09] Anton Osika

**English:**
I love it. Can we call it Lenny mode? Is that fine with you?

**中文翻译:**
我喜欢这个主意。我们可以叫它“Lenny 模式”吗？你介意吗？

---

### [01:05:12] Lenny Rachitsky

**English:**
100%.

**中文翻译:**
100% 没问题。

---

### [01:05:13] Anton Osika

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [01:05:14] Lenny Rachitsky

**English:**
Let's do it. I'll license you no cost.

**中文翻译:**
就这么办。我免费授权给你。

---

### [01:05:16] Anton Osika

**English:**
Sure.

**中文翻译:**
当然。

---

### [01:05:17] Lenny Rachitsky

**English:**
Okay. Okay. We made a deal here. Let's do it. Okay, Anton, is there anything else that you wanted to share? Anything you want to leave listeners with before I let you go and go to sleep?

**中文翻译:**
好，好。我们达成协议了。开始吧。好，Anton，还有什么你想分享的吗？在我让你去睡觉之前，有什么想留给听众的吗？

---

### [01:05:28] Anton Osika

**English:**
I think, again, the world is changing quickly and it's very fun. You should see that's like have fun in all of this change, and the best thing you can do for your current profession or if you want to have a new job is to be in the top 1% in knowing how to use AI tools. So go out there, use Loveable, use other AI tools, and become... Make sure to understand or try to understand as much as possible in how to use them productively. That's something I tell all my friends generally, and I love the audience to know as well.

**中文翻译:**
我想再次强调，世界变化很快，这很有趣。你应该在所有这些变化中寻找乐趣。为了你现在的职业，或者如果你想找份新工作，你能做的最好的事情就是成为使用 AI 工具的前 1% 的人。所以，去尝试吧，使用 Lovable，使用其他 AI 工具，并确保尽可能多地理解或尝试理解如何高效地使用它们。这是我通常告诉所有朋友的话，我也希望听众们知道。

---

### [01:06:06] Lenny Rachitsky

**English:**
Okay. Well, I got to try to make this even more specific for people. How do you know if you're in the top 1%? What's a heuristic almost slash how do you get there? Is it just use it a hundred times a day? What else? What can you recommend?

**中文翻译:**
好。那我得试着为听众说得更具体一点。你怎么知道自己是否属于那前 1%？有没有什么启发式的标准，或者说如何达到那个水平？是每天使用一百次吗？还有什么？你有什么建议？

---

### [01:06:19] Anton Osika

**English:**
Yeah. I think if you spend a full week on trying to reach an outcome, the best way to learn is I want to do this thing and then I want to use AI to do that thing. And you've spent a full week, you are in the top 1% in the global population. And if you surround yourself with friends who have this obsession or they also care a lot about this, then you'd be quickly in the top 0.1%.

**中文翻译:**
是的。我认为如果你花整整一周时间尝试达成一个结果——最好的学习方式是“我想做这件事，然后我想用 AI 来做这件事”——如果你花了一整周，你就已经处于全球人口的前 1% 了。如果你身边有一群同样对此痴迷或非常关注的朋友，你很快就能进入前 0.1%。

---

### [01:06:47] Lenny Rachitsky

**English:**
So what I'm hearing is find a problem that can be solved, find a problem, a pain point for yourself or someone, and then end-to-end fully solve that problem. Spend a week getting from idea to a thing that somebody's actually using and you're in the top 1%.

**中文翻译:**
所以我听到的是：找一个可以解决的问题，找一个你自己或别人的痛点，然后端到端地完全解决那个问题。花一周时间，从想法到做出一个别人真正能用的东西，你就进入前 1% 了。

---

### [01:07:03] Anton Osika

**English:**
Yeah. I think... At the top, yeah, the top 1% by just spending a full week and asking AI if you don't understand. So making sure that you understand.

**中文翻译:**
是的。我认为……通过花整整一周时间，如果不理解就问 AI，确保你理解了，你就是前 1%。

---

### [01:07:15] Lenny Rachitsky

**English:**
Yeah, that's the thing people forget. You just ask. Would you ask the chat feature of Lovable in this case or would you go to Cloud or ChatGPT to ask for advice?

**中文翻译:**
是的，那是人们容易忘记的一点。直接问就行。在这种情况下，你会问 Lovable 的聊天功能，还是会去问 Claude 或 ChatGPT 寻求建议？

---

### [01:07:24] Anton Osika

**English:**
I mean, my recommendation here, if you're in product is to use Lovable to build software and learn that AI tool and then you should use ChatMode and ChatMode, I have to add, is something you activate in your user profile. It's not launched in the main product, so it's in labs, but if you add that flag, then you can use ChatMode. If you want to learn some other AI tool, then you should ask that tool or ask Cloud, ChatGPT about how that topic, that domain works.

**中文翻译:**
我的建议是，如果你在做产品，就用 Lovable 来构建软件并学习那个 AI 工具，然后你应该使用“对话模式”（ChatMode）。我得补充一下，对话模式是你需要在用户个人资料中激活的功能。它还没有在主产品中发布，还在实验室（labs）阶段，但如果你勾选那个选项，就可以使用对话模式。如果你想学习其他 AI 工具，你应该问那个工具本身，或者问 Claude、ChatGPT 关于那个主题或领域是如何运作的。

---

### [01:08:02] Lenny Rachitsky

**English:**
Okay, amazing. Where can people find you? Where can they find Lovable and how can listeners be useful to you?

**中文翻译:**
太棒了。人们在哪里可以找到你？在哪里可以找到 Lovable？听众可以为你提供什么帮助？

---

### [01:08:09] Anton Osika

**English:**
Lovable posts updates, and memes on Lovable underscore dev on Twitter, we post things on LinkedIn as well, and there are a lot of things coming out and changing in how we build software, so you can follow Lovable underscore dev and you can follow me at AntonOsika at Twitter. I'd love more feedback on where people see this is a huge change for them. There are a lot of people posting about that on Twitter, but we have a Discord where you can share like, "Oh, this is how I use Lovable. It was super useful to me." And feedback.lovable.dev can ask for new features. There's a lot of people asking and uploading what features you want next. And that's super useful. That's the most important thing for us. We just want to solve people's problems.

**中文翻译:**
Lovable 在 Twitter 上的账号是 @lovable_dev，我们会发布更新和梗图，我们也会在 LinkedIn 上发布内容。关于我们如何构建软件，有很多新东西正在涌现和变化，所以你可以关注 @lovable_dev，也可以在 Twitter 上关注我 @AntonOsika。我很想听到更多反馈，看看人们在哪些方面觉得这给他们带来了巨大的改变。推特上已经有很多人在发这些了，但我们也有一个 Discord，你可以在那里分享，比如：“噢，我是这样用 Lovable 的，它对我超级有用。”在 feedback.lovable.dev 你可以申请新功能。那里有很多人在提要求并投票选出下一个想要的功能。那非常有用。这对我们来说是最重要的事情。我们只想解决人们的问题。

---

### [01:09:04] Lenny Rachitsky

**English:**
Amazing. Anton, you're doing incredible work. What a journey. I'm excited to have you back someday when we see more chapters of this journey.

**中文翻译:**
太棒了。Anton，你正在做着了不起的工作。多么精彩的一段旅程。我很期待有一天能再次邀请你回来，看看这段旅程的更多篇章。

---

### [01:09:12] Anton Osika

**English:**
I have a lot more to learn.

**中文翻译:**
我还有很多东西要学。

---

### [01:09:13] Lenny Rachitsky

**English:**
As do we all. That's why people listen to this podcast. Anton, thank you so much for being here.

**中文翻译:**
我们都一样。这就是人们听这个播客的原因。Anton，非常感谢你能来。

---

### [01:09:18] Anton Osika

**English:**
Thank you so much, Lenny.

**中文翻译:**
非常感谢，Lenny。

---

### [01:09:19] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lenny'sPodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这真的能帮助其他听众发现这个播客。你可以在 LennysPodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。