# Anuj Rathi - 双语对照

这是一份为您准备的《Lenny's Podcast》访谈 Anuj Rathi 的完整中英双语对照文档。

---

### [00:00:00] Anuj Rathi

**English:**
There are only three reasons why things do not happen the way you want them to happen as a leader. You can look at a person, and you would say either that person can't do, which is a capability issue, or they won't do, which is a motivation or an alignment issue, or they were not set up to do, which is really your problem that you didn't set up the ways of working now design properly. So, as a leader, do you have the right people in terms of capability? If not, is the right answer for us to coach them or to really put them... or mentor them and so on, or move them to some other place because maybe their capability is suited elsewhere? If they won't do, why won't they? Are they not aligned to you? Do they not agree with your vision? Do they not just have enough time? So on and so forth. So you need to really go deeper there. Why won't they do?

**中文翻译:**
作为一名领导者，事情没有按照你预期的方向发展，只有三个原因。当你观察一个人时，你会发现要么是那个人“不能做”（can't do），这是能力问题；要么是他们“不愿做”（won't do），这是动力或对齐（alignment）问题；要么是他们“没被安排好去做”（not set up to do），这其实是你的问题，因为你没有设计好工作方式。所以，作为领导者，你是否拥有能力匹配的人才？如果没有，正确的做法是指导他们、提供辅导，还是将他们调往其他更适合其能力的地方？如果他们不愿做，原因是什么？是他们与你的目标不一致吗？他们不认同你的愿景吗？还是他们单纯没有足够的时间？诸如此类。你需要深入挖掘：他们为什么不愿做？

---

### [00:00:50] Lenny

**English:**
Today, my guest is Anuj Rathi. I've been looking to get more India-based product leaders on the podcast because this podcast has a large audience in India. When I put out a call on Twitter and LinkedIn asking people who I should have on, Anuj was the single most requested person. Anuj is Chief Product and Marketing Officer at Jupiter Money. Previously, he was Senior Vice President of Revenue and Growth at Swiggy where he spent seven years. He was also VP of Product at Snapdeal, a Senior PM at Walmart Labs, and the very first Product Manager at Flipkart where he led the buyer experience team.

**中文翻译:**
今天的嘉宾是 Anuj Rathi。我一直希望能邀请更多常驻印度的产品领袖参加节目，因为本播客在印度拥有庞大的受众群体。当我在 Twitter 和 LinkedIn 上征集人选时，Anuj 是呼声最高的一位。Anuj 目前是 Jupiter Money 的首席产品官兼首席营销官。此前，他在 Swiggy 工作了七年，担任收入与增长高级副总裁。他还曾担任 Snapdeal 的产品副总裁、Walmart Labs 的高级产品经理，并且是 Flipkart 的第一位产品经理，负责领导买家体验团队。

---

### [00:01:24] Lenny

**English:**
In our conversation, we dig into how product management is different in India, Anuj's lessons about building product experiences for new users, how he operationalized the working backwards process at the companies he's worked at, why he pushes his teams to explore three divergent directions before settling on a plan, why he thinks product managers and companies should be much more full stack than they are. Also, a bunch of frameworks and contrarian takes about building product and your career in product. A big thank you to Sayan Maiti and Nikhil Kulkarni for helping me navigate the product scene in India. Look for more amazing India-based product leaders to come. With that, I bring you Anuj Rathi after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们将深入探讨印度的产品管理有何不同、Anuj 在为新用户构建产品体验方面的经验、他是如何在所任职的公司中落实“逆向工作法”（working backwards）的、为什么他要求团队在确定方案前先探索三个发散的方向，以及为什么他认为产品经理和公司应该比现在更加“全栈”（full stack）。此外，我们还会讨论一系列关于构建产品和职业发展的框架及反直觉的观点。非常感谢 Sayan Maiti 和 Nikhil Kulkarni 帮我了解印度的产品生态。未来会有更多优秀的印度产品领袖加入。在听完赞助商的简短介绍后，让我们欢迎 Anuj Rathi。

---

### [00:02:08] Lenny (Sponsor Break - Sanity)

**English:**
This episode is brought to you by Sanity. Your website is the heart of your growth engine. For that engine to drive big results, you need to be able to move super fast, ship new content, experiment, learn, and iterate, but most content management systems just aren't built for this. Your content teams wrestle with rigid interfaces as they build new pages. You spend endless time copying and pasting across pages and recreating content for other channels and applications, and their ideas for new experiments are squashed when developers can't build them within the constraints of outdated tech. Forward-thinking companies like Figma, Amplitude, Loom, Riot Games, Linear, and more use Sanity to build content growth engines that scale, drive innovation, and accelerate customer acquisition. With Sanity, your team can dream bigger and move faster. As the most powerful headless CMS on the market, you can tailor editorial workflows to match your business, reuse content seamlessly across any page or channel, and bring your ideas to market without developer friction. Sanity makes life better for your whole team. It's fast for developers to build with, intuitive for content managers, and it integrates seamlessly with the rest of your tech stack. Get started with Sanity's generous free plan, and as a Lenny's Podcast listener, you can get a boosted plan with double the monthly usage. Head over to sanity.io/lenny to get started for free. That's sanity.io/lenny.

**中文翻译:**
本期节目由 Sanity 赞助。你的网站是增长引擎的核心。为了让这个引擎产生巨大成果，你需要能够快速行动、发布新内容、实验、学习并迭代，但大多数内容管理系统（CMS）并非为此设计。你的内容团队在构建新页面时不得不忍受僵化的界面。你花费大量时间在页面间复制粘贴，并为其他渠道和应用重新创建内容，而当开发人员无法在过时技术的限制下实现新实验的想法时，这些创意就会被扼杀。像 Figma、Amplitude、Loom、Riot Games、Linear 等具有前瞻性的公司都在使用 Sanity 来构建可扩展、驱动创新并加速客户获取的内容增长引擎。有了 Sanity，你的团队可以拥有更大的梦想并行动得更快。作为市场上最强大的无头 CMS（headless CMS），你可以定制符合业务需求的编辑工作流，在任何页面或渠道无缝复用内容，并在没有开发摩擦的情况下将想法推向市场。Sanity 让整个团队的生活变得更美好。开发人员构建速度快，内容经理操作直观，且能与你的其他技术栈无缝集成。从 Sanity 慷慨的免费计划开始，作为 Lenny's Podcast 的听众，你可以获得每月使用量翻倍的增强计划。访问 sanity.io/lenny 免费开始。

---

### [00:03:30] Lenny (Sponsor Break - Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Com, Quora, and Modern Treasury trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs, and get ready for audits in weeks, not months. By offering the most in-demand, security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA, and many more, Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny. That's V-A-N-T-A.com/lenny to learn more and to claim your discounts, Get started today.

**中文翻译:**
本期节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。数千家快速成长的公司（如 Gusto、Com、Quora 和 Modern Treasury）信任 Vanta，通过它来构建、扩展、管理和展示其安全合规计划，并在几周而非几个月内做好审计准备。通过提供最热门的安全和隐私框架（如 SOC 2、ISO 27001、GDPR、HIPAA 等），Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5000 家快速成长的公司使用 Vanta 自动完成 SOC 2 及其他框架高达 90% 的工作。限时优惠，Lenny's Podcast 的听众可享受 1000 美元的 Vanta 折扣。访问 vanta.com/lenny 了解更多并领取优惠。

---

### [00:04:31] Lenny

**English:**
Anuj, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
Anuj，非常感谢你能来，欢迎来到本播客。

---

### [00:04:34] Anuj Rathi

**English:**
Thank you so much, Lenny. Thank you for having me.

**中文翻译:**
非常感谢，Lenny。谢谢你邀请我。

---

### [00:04:37] Lenny

**English:**
It's my pleasure. I haven't told you this, but when I put a call out on Twitter and LinkedIn for people's favorite India-based product leaders, you are the single most recommended person, and so I just wanted to start with how does it feel to be the most loved India-based product leader at least according to my Twitter followers and LinkedIn followers?

**中文翻译:**
这是我的荣幸。我还没告诉你，当我在 Twitter 和 LinkedIn 上征集大家最喜欢的印度产品领袖时，你是被推荐次数最多的人。所以我想先问问，作为至少在我的粉丝心目中最受喜爱的印度产品领袖，感觉如何？

---

### [00:04:58] Anuj Rathi

**English:**
Well, it feels really good, and I really feel it's come together because I've been doing product management for the longest time. In 2010, when I started the product management journey with Flipkart. I think that that was a time when there were not a lot of products being built for India. So I think one part is just the tenure, and B, I think it's just a lot of people have known the work.

**中文翻译:**
感觉非常好。我觉得这是一种积累的结果，因为我从事产品管理已经很久了。2010 年我在 Flipkart 开始产品管理生涯时，那个时代还没有太多专门为印度市场打造的产品。所以我想，一方面是因为资历深，另一方面是因为很多人都了解我参与过的工作。

---

### [00:05:20] Lenny

**English:**
Awesome. You're very modest. I wanted to start with a question about product in India, and I'm just curious just how is product management and product building in general just most different in India?

**中文翻译:**
太棒了，你非常谦虚。我想先问一个关于印度产品的问题：在印度，产品管理和产品构建总体上最大的不同点在哪里？

---

### [00:05:33] Anuj Rathi

**English:**
Yeah. I think that's a very interesting question, and I think about this all the time. When I look at product management in India, and I do have a lot of friends comparing product management versus in US or even in Europe versus even in China, Southeast Asia, et cetera. I think India has had a very interesting journey of products in general and hence, product management also. I think till about 2010-ish, there were not really many products built for the Indian consumers in the first place. There were a lot of products being built, a lot of technology being built, but largely, because it was a back office, so you had a lot of great engineers working in companies which would build products for the American customer or even for the European customer and so on. So once these startups started coming in, which were thinking about building for the Indian consumers, I think we did not really have that talent which we could directly tap into. We're trained into product building. Forget product management as a field in the first place. There were no colleges which were teaching anything about this. There was no playbooks, and so on, and so forth. We would go to the internet, and look at YouTube, and look at SVPG and all of that, but what we would understand would not... you could not put directly to the Indian startups.

**中文翻译:**
这是一个非常有趣的问题，我也一直在思考。我有很多朋友会将印度的产品管理与美国、欧洲、甚至中国和东南亚进行比较。我认为印度的产品发展历程非常独特，因此产品管理也随之演变。在 2010 年左右之前，印度几乎没有专门为本土消费者打造的产品。当时有很多产品和技术在开发，但大多是因为印度扮演着“后台办公室”（back office）的角色——很多优秀的工程师在为美国或欧洲客户开发产品。所以当那些想要为印度消费者服务的初创公司出现时，我们并没有现成的人才储备。大家没有受过系统性的产品构建培训，更不用说产品管理这个领域了。当时没有大学教这些，也没有现成的实战手册。我们会去网上看 YouTube，看 SVPG（硅谷产品集团）的内容，但我们学到的东西无法直接套用到印度的初创公司中。

---

### [00:06:48] Anuj Rathi

**English:**
The way that they shaped up I think also shaped up the way product management field would evolve in India. So it's taken a bunch of iterations, and I think there are two or three different waves that have come in, and we are way closer to how good product management should be done in India. We still have a little bit way to go compared to, say, US. I also think of it along... For example, in US, the product building culture probably started in 1970s, the modern software product building culture, and you didn't only have product manager, but the entire ecosystem... If you think about a company, who is the VP of business, and who is the VP of supply, and sales, and ops, and technology, and all of that? That group knew how to work with each other to build software products. They understood how that would be built and what to expect.

**中文翻译:**
这些公司的成长方式也塑造了印度产品管理领域的发展。我们经历了几次迭代，大概有两三波浪潮，现在我们已经非常接近“好的产品管理”在印度应有的样子了。虽然与美国相比还有一段路要走。我常这样想：在美国，现代软件产品构建文化可能始于 20 世纪 70 年代，不仅有产品经理，整个生态系统——业务副总裁、供应副总裁、销售、运营、技术等等——都知道如何协作来构建软件产品。他们理解构建过程以及预期结果。

---

### [00:07:37] Anuj Rathi

**English:**
I think in India, when we were in 2010, et cetera, even those different people who needed to come together to build, say, e-commerce, they would come from, say, FMCG, or they would come from manufacturing and so on. What they would have seen in their journeys in terms of what we expect is a very request response kind of understanding which is, "Here's machinery. If I give this X resources, I expect, with a little bit of variability, why predictable output will come," and that mentality also moved on to what I expect from product managers or product building journeys and so on. So I think over a period of time, a lot of those cycles have happened, and a lot more other leaders in companies have now seen those cycles and understood, "All right. Now, I understand software is not machinery. Consumers are not predictable as much as we thought." That has led to, now, finally, I think, product management coming of age.

**中文翻译:**
而在 2010 年左右的印度，那些聚在一起构建电子商务的人可能来自快速消费品（FMCG）行业或制造业。他们在职业生涯中形成的认知是一种非常“请求-响应”式的理解，即：“这是一台机器，如果我投入 X 资源，我预期会得到 Y 的可预测产出，误差很小。”这种心态也延续到了他们对产品经理或产品开发过程的预期上。随着时间的推移，经历了多次周期，公司里的其他领导者也看到了这些过程并意识到：“好吧，我现在明白了，软件不是机器，消费者也不像我们想象的那么容易预测。”我认为这最终促成了印度产品管理的成熟。

---

### [00:08:34] Lenny

**English:**
You said that, I guess, in the Bay Area, things started 1970s, something like that. When would you say things started to really ramp up in modern product thinking in India?

**中文翻译:**
你提到湾区大约在 70 年代开始，那么你认为印度的现代产品思维是什么时候开始真正加速发展的？

---

### [00:08:43] Anuj Rathi

**English:**
I think 2010 was when it started because... Look, there were a few products that were built before that also, and I think somebody said this clearly that usually, when modern consumer internet starts coming in countries, it usually starts with travel, so you do have... Basically, any country, we would start with, usually, the first travel company. So I think India started with some companies like MakeMyTrip and so on way earlier. There were a few very interesting products being built in India which were solving uniquely for the Indian consumers that were in the matrimony side which is Shaadi.com, and Bharmatrimony.com, and so on. We're like, "What do you think about Tinder?" India is famous for arranged marriages, so a product that would really understand that, "Hey, if you're a parent, if you want to get your kid up for matrimony, how would you solve for them?" and that marketplace of matchmaking, et cetera started.

**中文翻译:**
我认为是从 2010 年开始的。虽然在那之前也有一些产品，有人曾精辟地指出，当现代消费互联网进入一个国家时，通常是从旅游业开始的。所以印度很早就有了 MakeMyTrip 等公司。当时还有一些非常有趣的、专门解决印度消费者独特需求的产品，比如婚恋网站 Shaadi.com 和 BharatMatrimony.com。就像你会问“你怎么看 Tinder？”一样，印度以包办婚姻闻名，所以需要一种产品能真正理解：“如果你是父母，想给孩子找对象，该如何解决？”于是这种相亲撮合的市场就开始了。

---

### [00:09:34] Anuj Rathi

**English:**
So a few blips here and there which was following uniquely for India. I think 2010 was a decade or time when I can very clearly imagine that's where a lot of people started building for India. So I think, again, Flipkart started that kind of journey, but in a couple of years, then they were like, say, Ola which was, in a way, similar to Uber, what they were doing elsewhere, and then a whole bunch of other startups that started coming in. So, for example, in food delivery, when I was working at Swiggy, that came in like, say, 2015, 2014, in that timeframe. Now, you see a whole bunch of startups which are trying to do not only things which are... what could an Uber for India look like or what could a DoorDash for India look like. Very different and also, very innovative. So I think now is the time when you see a lot more product building around that area.

**中文翻译:**
所以当时有一些零星的、针对印度的独特尝试。但我能清晰地记得，2010 年是一个转折点，很多人开始真正为印度市场构建产品。Flipkart 开启了这段旅程，几年后出现了 Ola（类似于 Uber 在其他地方的做法），接着一大批初创公司涌现。例如，我在 Swiggy 工作的外卖领域，大约是在 2014、2015 年左右兴起的。现在，你会看到很多初创公司不仅在思考“印度的 Uber”或“印度的 DoorDash”长什么样，而且做得非常不同且极具创新。我认为现在正是该领域产品构建大爆发的时期。

---

### [00:10:24] Lenny

**English:**
Where are some numbers of just like companies in India, people in India's money spent in India? I don't know. Things that would be like, "Wow, that is a much bigger opportunity than I thought."

**中文翻译:**
能不能提供一些数据，比如印度的公司数量、人口消费能力等？一些能让人感叹“哇，这个机会比我想象的要大得多”的数据。

---

### [00:10:33] Anuj Rathi

**English:**
Okay. This is a very wide question, so I'll tell you. Before the opportunity in India, I think I'll talk about the complexity in India which I think a lot of people don't understand. India has what? 1.4 billion people. So there were three waves, really, that happened in India, but also, in the globe. I think first wave was from desktop to mobile, and then even from mobile to smartphones. From smartphones, there was what we call the Jio revolution. There's an Indian company called Reliance Jio that basically got internet at the cheapest prices for smartphones. So because of this, a whole population came onto the internet which was hungry for newer products, newer content, completely different ways of interacting with each other, and using internet for all sorts of different things. That was one of the waves.

**中文翻译:**
好的，这是一个很宏大的问题。在谈论机会之前，我想先谈谈印度的复杂性，这是很多人不理解的。印度有 14 亿人口。印度乃至全球经历了三波浪潮：第一波是从桌面端到移动端，然后是从普通手机到智能手机。在智能手机阶段，发生了我们所说的“Jio 革命”。一家名为 Reliance Jio 的印度公司以极低的价格普及了智能手机上网。正因如此，整个人口群体涌入互联网，他们渴望新产品、新内容，以及完全不同的互动和使用互联网的方式。这是其中一波浪潮。

---

### [00:11:24] Anuj Rathi

**English:**
The other part is really what the Indian government really enabled which is... especially in digitization of a bunch of absolute core fundamental citizen-related machinery which is either through digital payments, which is a whole bunch of Indians now started having a bank account by default, and something called UPI. So even if you do not have a bank account or that bank account is linked to your mobile phone number, but now everybody would pay through that, and that brought in a very different kind of revolution. So even if 5 rupees, that is basically 10 cents or less than that, that would be paid through UPI, and people started moving away from cash and so on. There's something called the India Stack that is all of these things coming together, which is social security, identity, payments, and so on, that a whole bunch of other apps can now use to build their own layers on top of that. So many interesting cases started coming about. So that's one which is just a number and the infrastructure.

**中文翻译:**
另一部分是印度政府的推动，特别是一系列核心公民基础设施的数字化。通过数字支付，大量印度人开始默认拥有银行账户，以及一种叫 UPI（统一支付接口）的东西。即使你没有传统的银行账户，只要绑定手机号，现在每个人都可以通过它支付，这带来了一场截然不同的革命。哪怕是 5 卢比（约 10 美分或更少），也可以通过 UPI 支付，人们开始摆脱现金。还有所谓的“印度堆栈”（India Stack），它将社会保障、身份认证、支付等整合在一起，其他应用可以在此基础上构建自己的服务。这催生了许多有趣的案例。这是基础设施和数字层面的规模。

---

### [00:12:25] Anuj Rathi

**English:**
Now, the other thing to look at is India is very diverse, so the number of languages spoken here, even the official languages is so high, and they say... There's an elders' quote in India like, "Every 15 miles, the language will change, and the people and the culture will change, and it's a huge country of so many people." So your traditional ways of thinking about products also, the "Who I'm building for?" is very different. "Are you building for this person or that?" Et cetera. So a bunch of frameworks break down because it's not even that the same language will apply. While English is a language that is used by the people at least who have the money and who have the dollar to even give to you, but you have to think way more widely.

**中文翻译:**
另一件要注意的事是印度的多样性。这里使用的语言数量极多，甚至官方语言也非常多。印度有一句老话：“每走 15 英里，语言就会变，人和文化也会变。”这是一个拥有庞大人口的大国。所以你传统的产品思维——“我为谁而建？”——会变得非常不同。你是为这类人还是那类人构建？很多框架在这里会失效，因为甚至连语言都不统一。虽然英语是那些有钱、能贡献利润的人使用的语言，但你必须考虑得更广。

---

### [00:13:06] Anuj Rathi

**English:**
The other thing about India that is interesting is the price that people are willing to pay. Generally, it does look at the per capita money that people have. It is very low. It's in the two, two and a half thousand dollar range compared to US which is maybe 30 times more and so on. So while there's a lot of people who are going to give you traffic, and engagement, and so on, but the craft of actually choosing the right kind of paying customer who will actually come, and engage, and give you money is at a premium. So a lot harder work needs to be done. If you're running e-commerce, who are the people who will pay me delivery fee? Who are the people who will actually buy this expensive stuff? So a whole bunch of different ways of thinking has evolved in this country, and that's why it's so vibrant and so different than any other global products.

**中文翻译:**
印度另一个有趣的地方是人们的付费意愿。通常看人均收入，印度非常低，大约在 2000 到 2500 美元之间，而美国可能是它的 30 倍。所以，虽然有很多人能给你带来流量和活跃度，但如何精准挑选出那些真正愿意留下来、参与并付钱的客户，是一门极高的艺术。你需要做更多艰苦的工作。如果你经营电商，谁会愿意付配送费？谁会买昂贵的商品？因此，这个国家演变出了一整套不同的思维方式，这也是为什么它如此充满活力，且与全球其他产品如此不同的原因。

---

### [00:14:01] Lenny

**English:**
Wow. Fascinating. I could keep going, but I want to talk product. I've collected a bunch of questions from people that know you or people that have worked with you about a bunch of different stuff, so I'm just going to go a little bit all over the place. The first area I wanted to talk about is the user experience. Apparently, you have a interesting insight and a different approach of thinking about new users and new user experiences.

**中文翻译:**
哇，太迷人了。我本可以继续聊下去，但我更想聊聊产品。我从认识你或与你共事过的人那里收集了很多关于不同话题的问题，所以我会聊得比较散。我想谈的第一个领域是用户体验。显然，你在思考新用户和新用户体验方面有独特的见解和方法。

---

### [00:14:24] Anuj Rathi

**English:**
One of the things that I realized once we started working with the products is that product managers and generally, companies are too engrossed in thinking about... because they are very close to the product. It's close to their heart, and they're looking at it all the time. They're looking at a lot of minor nuances in terms of how this works and feels, and almost inherent into this is the bias that everybody is thinking about this product all day, all the time, and so on, and so forth. Whereas the reality is most consumers in the country or in your target market, they don't care, and they may have sometime heard about your product. The word of mouth is not ever so strong, even if you're the strongest brand, and so on, and so forth, but that is the customer that you've got to bring in, and then serve.

**中文翻译:**
在开始做产品后我意识到一件事：产品经理和公司通常太沉迷于自己的产品了，因为他们离产品太近，倾注了心血，且时刻盯着它。他们关注产品运作和感受的每一个微小细节，这导致了一种固有的偏见，即认为所有人整天都在关注这个产品。但现实是，该国或你目标市场的大多数消费者根本不在乎，他们可能只是偶尔听说过你的产品。即使你是最强的品牌，口碑也不总是那么强大。但这些正是你需要吸引并服务的客户。

---

### [00:15:07] Anuj Rathi

**English:**
So there's very interesting insight that I heard from Scott Belsky from Adobe, and then now, he's doing very interesting stuff, and that stayed with me which was you have to think about users on modern internet consumers having three attributes. So they are lazy, they are vain, and they're selfish. So lazy meaning, "I don't have time for this, so blow my mind away. Otherwise, I'm not going to pay attention." Vain which means, "I have a habit. I'm solving this problem in a particular way, and here, you come with your two-pack product and ask me to change my habit. Do you really expect me to do that?" That's second. That's their inherent attribute. The third one is that they're selfish like, "Show me what's in it for me."

**中文翻译:**
我从 Adobe 的 Scott Belsky 那里听到了一个非常有趣的见解，这对我影响深远：你必须认为现代互联网消费者具有三个属性——他们是**懒惰的（lazy）**、**虚荣的（vain）**和**自私的（selfish）**。懒惰意味着：“我没时间研究这个，除非你让我眼前一亮，否则我不会关注。”虚荣（或固执）意味着：“我有自己的习惯，我一直在用某种方式解决问题，而你带着一个半成品过来让我改变习惯？你真的指望我这么做吗？”这是他们的固有属性。第三个是自私：“告诉我这对我有什么好处。”

---

### [00:15:52] Anuj Rathi

**English:**
Once you start thinking about users in that vein, and if these users are not even using your product, suddenly, you realize, "Oh my god, it's quite difficult even... How do I attract this kind of customer, and if my marketing team has done a good job at bringing this user to my product, how do I actually now empathize with this lazy, selfish, and vain customer, and build my product in a way so that I can make this appear on your site like this is the thing that you have to use, the way you write your copy, the way you build your onboarding, the way you do your first warm welcome?" It's going to make the biggest amount of change in terms of a product success, then your core product features that you're going to build for your loyal consumers.

**中文翻译:**
一旦你从这个角度思考用户，尤其是那些还没开始使用你产品的用户，你猛然发现：“天哪，这太难了。”我该如何吸引这种客户？如果营销团队成功把用户带到了产品面前，我该如何与这些懒惰、自私、虚荣的客户共情？我该如何构建产品，让它看起来就是你必须使用的东西？包括文案的写法、新手引导（onboarding）的设计、第一次欢迎的方式。这些对产品成功的贡献，远比你为忠实用户构建的核心功能要大得多。

---

### [00:16:37] Anuj Rathi

**English:**
So that one insight, and I've seen and applied that multiple times not only the companies that I worked with, the companies I've consulted and spoken with. Most neglect it. Well, they get user onboarding is important, but just how important is that is one, and B, the craft of thinking like a user who's lazy, vain, and selfish, and basically, rejecting all your products, but this does not work for this kind of customer. It's extremely hard. It's very hard, but it's totally worth it if you put that lens on.

**中文翻译:**
这个见解我在我工作过、咨询过或交流过的多家公司中多次应用。大多数人都忽略了它。虽然他们知道新手引导很重要，但却不知道它到底有多重要。其次，像一个懒惰、虚荣、自私且随时准备拒绝你产品的用户那样去思考，这是一种极难掌握的技艺。这非常困难，但如果你戴上这层滤镜，绝对值得。

---

### [00:17:06] Lenny

**English:**
Is there an example of you using this framework on a product you worked on where you're just like, "Here's a thing we really did..." I don't know, had a big impact or really surprised everyone?

**中文翻译:**
能不能举个例子，说明你在某个产品中使用了这个框架，并产生了巨大影响或让所有人感到惊讶？

---

### [00:17:16] Anuj Rathi

**English:**
So we used it in two different areas. So one is, of course, products I worked on. So I worked in Swiggy for the last seven years, and really, when we started working towards this user, instead of thinking about everybody as, "This is what our onboarding experience looks like, and this is what our product is." So, essentially, we used, basically, say, a key that it's... "We are a food delivery app. We are a grocery delivery app, and we have these bunch of things." Instead of that, we just started reframing it from the point of view of, "What would you want, and how could you use us? What is it in it for you?" and we started connecting all our marketing messages along with the onboarding.

**中文翻译:**
我们在两个不同领域用过它。一个当然是我工作过的产品。我在 Swiggy 工作了七年，当我们开始针对这类用户进行优化时，我们不再把所有人看作一个整体，也不再只是展示“这是我们的新手引导，这是我们的产品”。以前我们基本上是说：“我们是一个外卖 App，我们是一个生鲜配送 App，我们有这些功能。”相反，我们开始从用户的角度重新构思：“你想要什么？你怎么使用我们？这对你有什么好处？”我们将所有的营销信息与新手引导连接起来。

---

### [00:18:20] Anuj Rathi

**English:**
So right from the entire journey of you hearing us, what was the trigger, and what was the marketing message, and what was the promotion that we were running? How do we continue that journey on your onboarding from your splash, that 200 rupees of... X rupees if you buy from us, continuing that entire journey in the language that they understand and with the user experience that is continuation from the marketing to product, other thing that we started focusing on a lot more, and it instantly started showing us results. But while I'm talking about just a very simple example and everybody should be doing it, that is true even when you have a particular app which has multiple products and many product lines. It's the same principle that applies there, and that's where I think the largest amount of delta that happens that people don't know really why are we not able to cross-pollinate or cross-sell, and so on, and so forth.

**中文翻译:**
从你听说我们的那一刻起，触发点是什么？营销信息是什么？我们正在进行的促销活动是什么？我们如何在新手引导中延续这段旅程？从开屏画面开始，比如“购买立减 200 卢比”，用他们能理解的语言延续整个旅程，并提供从营销到产品一脉相承的用户体验。这是我们开始重点关注的事情，并且立即见效。虽然我举的是个简单的例子，每个人都应该这样做，但即使是拥有多个产品和产品线的复杂 App，这一原则同样适用。我认为这就是产生最大差异的地方——很多人不知道为什么他们无法实现交叉引流或交叉销售。

---

### [00:19:14] Anuj Rathi

**English:**
Right now, I'm working with a company called Jupiter which is a financial services app, and it's a neobank. So we care for personal finance, and it has a bunch of offerings. There's a personal account or savings account. There's a credit card. There's mutual funds. There is investments in, say, gold, and FD, and so on, and so forth. It's a bunch of things. But when people think about why using us only for one service and just go away, actually, the key is to recognize that this user has found value in... They are not interested in all the other things that you talked about, so be able to empathize with that user, and now thinking about the behavioral science aspects in terms of, "How do I convert this user from one to the other?" That I think is extremely important.

**中文翻译:**
现在我在一家叫 Jupiter 的公司工作，这是一个金融服务 App，也是一家数字银行（neobank）。我们关注个人理财，提供多种服务：个人账户、储蓄账户、信用卡、共同基金、黄金投资、定期存款（FD）等等。当人们思考为什么用户只用了一项服务就离开时，关键在于要意识到：用户只在那一项服务中找到了价值，他们对你说的其他东西不感兴趣。所以要能与用户共情，并从行为科学的角度思考：“我该如何引导用户从一项服务转向另一项？”我认为这极其重要。

---

### [00:20:00] Lenny

**English:**
So a couple things I'm hearing here. One is the importance of focusing on not people currently using your product, but this idea of maybe the marginal user or the adjacent user, the next state of users is who you should be thinking about when you're trying to optimize onboarding the user experience, and then two is... Something that sounds like you've had a lot of success with is picking one value prop, maybe one positioning statement, and then following that through their entire journey versus like, "Here's all the things we do." Is that right?

**中文翻译:**
我听到了几点。第一，重点不应放在当前正在使用产品的用户身上，而应关注“边际用户”或“邻近用户”，即下一波潜在用户，这是优化新手引导体验时该考虑的对象。第二，你似乎在“选择一个价值主张或定位，并将其贯穿整个用户旅程”上取得了很大成功，而不是罗列“这是我们做的所有事情”。对吗？

---

### [00:20:31] Anuj Rathi

**English:**
That's absolutely right. Let me give an example of this one. One of the reasons why I really feel product managers must, if not better, but equally understand, category consumers which are not in market or which are not really buying your products just yet. As good as the marketer or the brand expert in your team does... because they really are tasked with, "What is that one message that I can say that will make the user take attention or get to like, 'Oh, this is interesting,' and direct attention towards your product?" If the product managers are able to do that, then they will choose that positioning and essentially, understand, "What is my hope product, and what is the hope that..." At least get them to try my app or any of those things, right? So if they understand it as well as the marketer, and then understand, "Over a period of time, what is the right time when I introduce them to this other one rather than being very greedy about letting the new user try everything?" So that's one.

**中文翻译:**
完全正确。我举个例子。我认为产品经理必须像团队里的营销人员或品牌专家一样，甚至比他们更了解那些尚未进入市场或尚未购买你产品的品类消费者。营销人员的任务是：“我该说哪一句话能让用户注意到我，或者觉得‘哦，这很有趣’，从而关注我的产品？”如果产品经理能做到这一点，他们就能选准定位，并理解：“什么是我的‘钩子’产品？什么是能让他们至少尝试一下我的 App 的希望？”如果他们能像营销人员一样理解这一点，并明白：“随着时间的推移，什么时候才是引入另一项功能的最佳时机，而不是贪心地想让新用户尝试所有功能？”这是第一点。

---

### [00:21:37] Anuj Rathi

**English:**
The other thing that I feel a lot of product managers don't do right is... "Forget about everything. Here's my app. Go figure," is how most of the products are designed unfortunately. Automatically, these things will happen without any intervention. I have created something which is so beautiful, and once you tap that icon, everyone can say, "That is my product that is so working perfectly," but they don't really think about, "At what moment do I actually get this user here, and will they use it?" Well, this user is lazy, vain, and selfish.

**中文翻译:**
另一件我觉得很多产品经理没做对的事是……不幸的是，大多数产品的设计逻辑是：“别管别的，这是我的 App，你自己研究吧。”他们觉得一切都会在没有干预的情况下自动发生。他们觉得自己创造了如此精美的东西，只要用户点击图标，就会感叹：“这就是我的产品，运行得太完美了。”但他们并没有真正思考：“我到底是在什么时刻把用户带到这里的？他们会用吗？”别忘了，用户是懒惰、虚荣且自私的。

---

### [00:22:09] Lenny

**English:**
That phrase reminds me of something I always think about. Marc Andreessen had this great quote that your user's time is already allocated. They're not looking for more apps to download. They already have a plan for the day. Basically, they have things to do. They're not like, "Hmm, what's another iPhone app I'm going to check out right now?" So somehow you have to convince them, "This is worth your time," and I like this framework. Is there an example of a phrase you found really effective either at Swiggy, or Jupiter, or Flipkart, or anything just like, "Here's a quick example of something that had a big impact on either simplifying the value prop," or if you don't have an example top of mind, what was the impact you saw from implementing some of these ideas?

**中文翻译:**
这句话让我想起我常思考的一件事。Marc Andreessen 有句名言：用户的时间已经被分配好了。他们并不是在寻找更多 App 来下载，他们已经有了全天的计划。基本上，他们有事要做，而不是在想：“嗯，我现在该去看看哪个 iPhone App 呢？”所以你必须以某种方式说服他们：“这值得你花时间。”我喜欢这个框架。有没有哪个短语是你觉得特别有效的（无论是在 Swiggy、Jupiter 还是 Flipkart）？比如一个能简化价值主张并产生巨大影响的例子？或者如果没有具体的短语，你实施这些想法后看到了什么样的影响？

---

### [00:22:48] Anuj Rathi

**English:**
I'll talk about a phrase that I now use with product managers a lot to simplify how they should be thinking. I think one thing is... and that's not only for the consumers, but even how we operate. We are product managers, and we are in the business of influence. Users are doing something, and now we want them to do something else. Our engineers are doing something, and now we want to influence them into building something fast. Really, leadership has some plans. We'll influence them to, essentially, look at a plan, and basically, sign off, and do something else. We are in the business of influence, and you are doing this all the time internally. Otherwise, you're not successful even in shipping. Now, we have to extend this to our users and really think about it from that point of view. So you are a full-stack influencer and not only an external influencer. So we've got to think more like sales, more like marketing, more like influencers.

**中文翻译:**
我来说一个我现在常对产品经理说的话，用来简化他们的思维。这不仅针对消费者，也针对我们的运作方式。我们是产品经理，我们从事的是**影响力（influence）**的生意。用户正在做某事，我们想影响他们去做另一件事；工程师正在做某事，我们想影响他们快速构建某物；领导层有某些计划，我们要影响他们审视并批准另一个计划。我们处于影响力的行业，你在内部时刻都在这样做，否则你连产品都发布不了。现在，我们需要把这一点延伸到用户身上，从这个角度思考。所以你是一个“全栈影响力者”，而不仅仅是外部的影响者。我们必须像销售、像营销、像网红（influencers）一样思考。

---

### [00:23:42] Lenny

**English:**
One of the most important skills for a product manager is influencing people on team, and I like the point that you're also trying to influence your user. That's interesting. Just more reason to get really good at influence, so. I actually have a newsletter about how to get better influence based on Frodo Baggins and Lord of the Rings. We'll link to that in the show notes. Okay. Let's shift to a different topic. You have a really concrete way of actually implementing the working backwards process. We had one of the authors of the book Working Backwards on recently, and I'm excited to just hear what you've learned about how to actually put this into practice. It's easy to hear about, "Let's work backwards," but doing it is a different beast, and so I'd love to hear what you've learned there.

**中文翻译:**
产品经理最重要的技能之一就是影响团队成员，我喜欢你提到的“也要影响用户”这一点。这很有趣，也更有理由去精进影响力了。我其实写过一期关于如何提升影响力的通讯，是基于《指环王》里的弗罗多·巴金斯的，我们会把链接放在节目介绍里。好，让我们换个话题。你有一套非常具体的方法来实施“逆向工作法”。我们最近刚请到了《逆向工作法》的一位作者，我很想听听你在实践中积累了哪些经验。听起来“逆向工作”很容易，但实际操作起来完全是另一回事，我很想听听你的心得。

---

### [00:24:20] Anuj Rathi

**English:**
So I think the people who invented working backwards is clearly Amazon. I think they started this entire process which are like, "Hey, why don't you write a press release, and with that press release, we'll work backwards from that one?" I thought that was a very cool idea, and I was trying to dig down into like, "Hey, why does it work?" My insight or at least the way that I thought about this one is it's not working backwards only from a customer value proposition. "Will our customers love it, and will they pay for it? Is it noteworthy, and is it something that we should even be working?" While that is one of the most important things that the Working Backwards framework teaches us, but essentially, what you're working backwards from is an entire machinery at a particular day that is working for... For the date of GTM, what do we need to do from here till that particular day so that the GTM is successful, but also, what will be the machinery we would have created so that this product is successful?

**中文翻译:**
我认为逆向工作法的发明者显然是亚马逊。他们开启了整个流程，比如：“嘿，你为什么不先写一份新闻稿（press release），然后根据这份新闻稿往回推导？”我觉得这是个很酷的主意，我也在深挖它为什么有效。我的见解是，它不仅仅是从客户价值主张开始逆推——比如“客户会喜欢吗？会付钱吗？这值得关注吗？我们该做吗？”虽然这是该框架教给我们的最重要的事情之一，但本质上，你是在从某个特定日期的整套运行机制往回推。为了 GTM（进入市场）的那一天，从现在到那天我们需要做什么才能确保 GTM 成功？以及，为了让产品成功，我们需要建立什么样的机制？

---

### [00:25:20] Anuj Rathi

**English:**
Now, because you're already talking about GTM, you're already thinking about, "How will users love it? What is the money that we'll spend? What are the alternatives that we will... routes that we have explored that finally we have zeroed in on all of those?" So they are all going to be a part of a PR review. If I take a slightly open stance on this one, what is a press release? A press release is you have a one-pager which talks about what are we building, what is a particular date, what is the exact value proposition, what will consumers say, what will the business manager say, how will they respond, how will they use it. But the one thing that comes out from this framework is that you can use it for a whole bunch of other things. You can use it for negotiation, for example, because you start with a date, and then you say, "This is the one-pager that I need to ship, and I want the consumers to see that." You can use it to now go to our VP Engineering and say, "By this date, can we build all of this?" Now, they do not have all the PRDs and everything, but they can give you a sense that this is too aggressive or this is not and so on.

**中文翻译:**
因为你已经在谈论 GTM 了，你已经在思考：“用户会如何喜爱它？我们要花多少钱？我们探索过哪些替代方案，最后确定了哪条路径？”这些都会成为新闻稿评审（PR review）的一部分。如果我稍微展开说一下，什么是新闻稿？新闻稿就是一张纸，上面写着我们要构建什么、具体日期、确切的价值主张、消费者会说什么、业务经理会说什么、他们会如何反应、如何使用。但这个框架的一个妙处在于，你可以把它用于很多其他事情。比如用于谈判，因为你从一个日期开始，然后说：“这是我要发布的单页文档，我希望消费者看到这个。”你可以拿着它去找工程副总裁说：“到这个日期，我们能把这些都做出来吗？”虽然现在还没有详细的 PRD（产品需求文档），但他们能给你一个直观的感觉：这是否太激进了。

---

### [00:26:18] Anuj Rathi

**English:**
We can also use the quotes here to actually find alliances or find people who are going to actually derail this. So you actually use the customer quote to basically say, "I want my customers to say this. From marketing and from my pricing team, can we actually ship this so that consumers will say that?" Then, from the business owner's quote, you actually say, "This is what we are shipping, but what are your goals? Can you say that within three months, we would have achieved this much?" So using that to build one entire picture is one way that I found it really powerful because if you find disagreements here, then say, "I can't ship it," then you change the date, and then you change the goals because all of these things are changing together. So instead of one, you find the other set of all the things that need to come together for that press release to go live is the real value.

**中文翻译:**
我们还可以利用文档里的“引言”（quotes）来寻找盟友，或者发现那些可能会阻碍计划的人。你可以利用客户引言说：“我希望我的客户这样评价。营销和定价团队，我们能做出这样的产品让消费者给出这种评价吗？”然后，通过业务负责人的引言，你可以说：“这是我们要发布的东西，但你的目标是什么？你能承诺三个月内达到这个目标吗？”用这种方式构建一个完整的蓝图非常强大，因为如果你在这里发现了分歧，你可以说：“那我没法发布”，然后调整日期、调整目标，因为所有这些都是联动的。所以，真正的价值不在于那一张纸，而在于为了让那份新闻稿成真，所有需要整合在一起的要素。

---

### [00:27:07] Anuj Rathi

**English:**
The other part that I found interesting here is that I really truly believe in the power of three. So I actually ask my teams to write three press releases, alternative and divergent like, "What if we..." Suppose you're launching a membership program. So, instead of two tiers, let's do three tiers, or for example, let's take another one which is instead of building a membership, let's build up tiering pricing program with membership points. Instead of this segment, let's use another segment. Let's say within these three, and they all need to be fully thought-through, and that helps the leadership choose.

**中文翻译:**
我发现的另一个有趣点是，我深信“三的力量”。我会要求团队写三份新闻稿，它们是替代性的、发散性的。比如：“如果我们……”假设你要推出一个会员计划，不要只做一个方案，而是写三个：方案一是三级会员；方案二是不做会员，而是做带积分的分级定价计划；方案三是针对另一个细分市场。这三个方案都需要经过充分思考，这能帮助领导层做出选择。

---

### [00:27:44] Anuj Rathi

**English:**
So the two things that work here. When you are in the product discovery phase, you would have heard from a lot of folks. Finally, if you show them just one roadmap, it feels like, "Hey, this person didn't..." They listened to my interesting point which was valuable, but didn't include it. But when you're doing this three PR FAQs, I considered this, and this added up to a story that eventually is valuable, this alternative route. I considered your point of view, and I created a story, but unfortunately, it is not adding up so we rejected it. So, now, people can compare and contrast, and that's a very powerful leadership tool. That, actually, is a very powerful tool even for CXOs. When they say, "Let's build this," you'll say, "Here are three ways we can build this, and here's the reason why I'm not building what you said because you would like these two more."

**中文翻译:**
这里有两个起作用的地方。在产品探索阶段，你会听到很多人的意见。最后如果你只展示一个路线图，别人会觉得：“嘿，这个人没听我的。”虽然他们听到了我很有价值的观点，但没采纳。但当你做三份 PR/FAQ 时，你可以说：“我考虑了这一点，它构成了这个最终很有价值的故事（替代路径）。我也考虑了你的观点，并为此构建了一个故事，但不幸的是，它逻辑不通，所以我们否决了。”这样人们就可以进行对比，这是一种非常强大的领导力工具。对于 CXO（高管）来说也很有用，当他们说“我们做这个吧”时，你可以说：“这里有三种做法，我不按你说的做是因为你会更喜欢另外这两个。”

---

### [00:28:36] Lenny

**English:**
That's a really cool idea of just using the PR FAQ and working backwards process to think very differently partly to make sure you've explored all the options, partly to just think through things that are in the back of people's minds and see if there's something there before committing to the one direction.

**中文翻译:**
这是一个非常酷的想法，利用 PR/FAQ 和逆向工作法来进行差异化思考。一方面确保探索了所有选项，另一方面在确定方向前，把人们脑子里的各种想法都理清楚，看看是否有更好的可能。

---

### [00:28:51] Anuj Rathi

**English:**
So the FAQs also are very important to set processes in the system. For example, now, at Jupiter, we have a financial services app. So every FAQ will mandatorily have, "How are you going to make sure that it is fully compliant? Have you gotten sign-off from A, B, C people? Have you actually thought about legal aspects, and so on, and so forth?" So, for example, you can use the FAQs very effectively here. Whereas, for example, when it was Swiggy, and it's a three-way marketplace, you have consumers, delivery executives, and restaurant partners. Now, any small change that you do on, say, delivery partners, for example, if you're working on optimizing their earnings per hour which will lead to some changes in cost per delivery, but that may have a completely different impact on delivery fee.

**中文翻译:**
FAQ 对于在系统中建立流程也非常重要。例如，现在在 Jupiter，我们做的是金融服务 App，所以每个 FAQ 都必须包含：“你如何确保完全合规？你得到 A、B、C 负责人的签字了吗？你考虑过法律方面的问题吗？”你可以非常有效地利用 FAQ。再比如以前在 Swiggy，那是一个三方市场：消费者、骑手和餐厅合作伙伴。你在骑手端做的任何微小改动（比如优化他们的时薪），都会导致每单配送成本的变化，进而可能对消费者的配送费产生完全不同的影响。

---

### [00:29:31] Anuj Rathi

**English:**
I'm just making this up, but now, because of so many moving parts in your FAQs, you're explicitly asking, "Have you thought about what are the implications on restaurant partners? Have you thought about what are implications on delivery partners?" We, in fact, also have that PR FAQ in terms of we write down the different segments of delivery partners, and sometimes it will have extremely weird correlations because those product managers on one side of the equation have started thinking or at least consulting the other part of the marketplace, "What could this mean for you?" It gets everybody together to create very crisp products that work for all sides of the marketplace.

**中文翻译:**
我只是举个例子，但因为有这么多变动因素，在 FAQ 中你会明确询问：“你考虑过对餐厅合作伙伴的影响吗？考虑过对骑手的影响吗？”事实上，我们甚至会在 PR/FAQ 中写下不同类型的骑手群体，有时会发现极其奇怪的相关性。因为等式一端的产品经理开始思考或咨询市场的另一端：“这对你们意味着什么？”这让所有人齐心协力，创造出对市场各方都行之有效的、干练的产品。

---

### [00:30:10] Lenny

**English:**
One thread I'm pulling out of a few of your stories so far is you often come back to this full-stack approach to many models. So you talked about how PM is like an influencer, but also, they're influencing users. That's a cool way of thinking about it. With this working backwards process, you can use it to think about the full stack of launch, not just what features you're going to build. I know you also have some strong opinions about product managers, and they should be much more full-stack than most PMs. Does that ring a bell, and if so, can you talk about that?

**中文翻译:**
从你目前讲的故事中，我发现了一个贯穿始终的线索，就是你经常回到这种“全栈方法”的模型。你谈到产品经理像影响力者，不仅影响内部，也影响用户。这很酷。通过逆向工作法，你可以思考发布的整个环节，而不仅仅是要构建的功能。我知道你对产品经理也有一些强烈的看法，认为他们应该比大多数 PM 更加“全栈”。这听起来耳熟吗？如果是的话，能聊聊吗？

---

### [00:30:39] Anuj Rathi

**English:**
Yes. No, I think it is the same thread that is connecting the first and the second. I think product managers have to own outcomes and not only features and parts of the problem. Well, they will own some parts of the problem fully, but if they need to work with everybody to make sure that eventual product that they launch is successful and not only successful from the point of view of, "Hey, we launched something that works for users," et cetera, that's not the definition of success. Did it work in the way that it really changed the behavior of the kind of user that we wanted to achieve a business outcome that will build a capability that is important for us? All of those things combined will not happen if the product manager is only thinking about their part. So they have to think about external users, they have to think about competition, they have to think about other product managers and product leaders about engineering, about marketing, and so on because it's such a diverse field.

**中文翻译:**
是的，我认为这正是连接前两点的同一条线索。我认为产品经理必须对**结果（outcomes）**负责，而不仅仅是对功能或问题的某个部分负责。虽然他们会完全负责问题的某些部分，但他们需要与所有人协作，确保最终发布的产品是成功的。这种成功不仅是“嘿，我们发布了一个对用户有用的东西”，那不是成功的定义。成功是：它是否真的改变了目标用户的行为，从而实现了业务目标，并为我们构建了重要的能力？如果产品经理只考虑自己那一块，所有这些目标是不可能同时实现的。所以他们必须考虑外部用户、竞争对手、其他产品经理和领导者、工程、营销等等，因为这是一个如此多元的领域。

---

### [00:31:36] Anuj Rathi

**English:**
Unless you really... and I'm not saying you need to be an authority of that. Either you are very, very good at that, or you have built partnerships, and have run your ideas or product through those people and gotten weighted from them, and finally made a decision around that part, I don't think you'll be very successful. So, in my opinion, the full-stack product managers are the ones who are going to be more successful rather than product managers who are doing very good at one particular area only. So there's one book which is Range, right? I'm sure you may have heard about it, right? Even the first chapter, what they talk about is... They take two examples. One is the example of Federer, Roger Federer. So, with Roger Federer, for example, I think I'll just continue that, that till 18, he played a bunch of racket sports, and this wasn't even tennis. But then, you bring in ideas from one racket sport to the other, and second to the third, and so on, and so forth, and now you have such a range of ideas that you can connect a lot more dots and actually ship it. I think that's a better playbook for being more successful in product.

**中文翻译:**
除非你真的……我不是说你必须成为那些领域的权威。你要么非常擅长，要么建立了深厚的伙伴关系，让你的想法或产品经过这些人的检验并获得他们的反馈，最后做出决策。否则，我不认为你会非常成功。所以在我看来，“全栈产品经理”会比只擅长某一特定领域的 PM 更成功。有一本书叫《范围》（Range，中文译名《通才》），你肯定听说过。第一章就举了两个例子，一个是费德勒。费德勒在 18 岁之前玩过各种球拍类运动，甚至不只是网球。但他把一种运动的想法带到另一种运动中，现在他拥有如此广阔的思路，可以连接更多的点并最终打出好球。我认为这是在产品领域取得成功的更好策略。

---

### [00:32:41] Lenny

**English:**
I was just watching a documentary on... I think it was called Greatness and had Wayne Gretzky. He had exactly the same experience actually. When he was young, he played hockey just during the winter times, and during summer, he played other sports. Hockey was just like one sport he played, and then eventually started to focus on it, and they talked about how people that played different sports in their childhood actually ended up being much better at that one sport that they chose. So a lot of parallels. I know you also have a lot of interesting ways of thinking about coming up with a roadmap ideas, and ideating and building a roadmap backlog. So you already talked about this idea of going in very divergent directions and seeing if that leads anywhere. There's a couple more someone shared. One is you have this idea of show don't tell. What is that?

**中文翻译:**
我最近刚看了一部纪录片，好像叫《伟大》（Greatness），里面有韦恩·格雷茨基（冰球传奇）。他其实也有完全相同的经历。他小时候只在冬天打冰球，夏天玩其他运动。冰球只是他玩的众多运动之一，后来才开始专注。片中提到，小时候玩过多种运动的人，最终在他们选择的那项运动中表现得更出色。这有很多相似之处。我知道你在构思路线图想法、头脑风暴和构建路线图积压任务（backlog）方面有很多有趣的方法。你刚才提到了尝试非常发散的方向。还有人分享了几个，其中一个是你的“演给他们看，而不是说给他们听”（show don't tell）的想法。那是什么？

---

### [00:33:27] Anuj Rathi

**English:**
Actually, show don't tell is an idea which is an extension of what we are talking about from what backwards. When we're talking about working backwards, one is a PR FAQ which is a written documentation of what we are trying to achieve. Show don't tell is essentially a way in where the product manager starts ideating with the entire experience, and they actually create all the collaterals together of a user they need to begin with if you're working on a single-play product which is a single-user product. Then, you actually start bringing together your marketers and others in terms of, "What is literally the first screen, and how is my user getting here?" It's not as simple as he imagines somebody who will be doing this and reaching here. We try to recreate an exact situation.

**中文翻译:**
实际上，“演给他们看”是逆向工作法的延伸。当我们谈论逆向工作时，PR/FAQ 是关于我们要实现什么目标的书面文档。而“演给他们看”本质上是产品经理开始构思整个体验的方式。如果你在做一个单用户产品，他们会把用户需要的所有素材整合在一起。然后，你会召集营销人员和其他人讨论：“第一屏到底长什么样？用户是怎么来到这里的？”这不仅仅是想象某人会这么做并到达这里，我们要尝试重现一个确切的场景。

---

### [00:34:16] Anuj Rathi

**English:**
There's a concept of person, not personas. So we'll talk about personas, but we try to go to, "All right. No. Don't think about agentic user. Let's say Lenny, 30 years old, doing A, B, C things, earning this much, et cetera, et cetera. His relationship with this category of food delivery is X. These are the things that he has done in the last month. In the last three days, there were the needs, desires, aspirations, fears, frustrations, et cetera, et cetera." We say, "Okay. It's 11:00. What's happened? Why is this user open, or what triggered this particular app, and then what happened?" So you literally start from there, and I think 50% of my product reviews are on that part, and then when we say, "All right. Then, this app got open. Do we have the right kind of way forward for Lenny to actually achieve what he came here for?" Literally, each pixel, and each copy, and each word is going to be in service of that part.

**中文翻译:**
有一个概念叫“具体的人，而非画像”（person, not personas）。我们会谈论用户画像，但我们会深入到：“好吧，别想什么抽象用户。假设就是 Lenny，30 岁，做着 A、B、C 工作，赚这么多钱。他与外卖这个品类的关系是 X。他在过去一个月做了这些事。在过去三天里，他有哪些需求、愿望、渴望、恐惧、挫折等等。”我们会说：“现在是上午 11 点，发生了什么？为什么这个用户打开了 App？或者是什么触发了这个特定的 App？然后发生了什么？”你真的从那里开始。我认为我 50% 的产品评审都在讨论这部分。然后我们会问：“好，App 打开了，我们是否为 Lenny 提供了正确的路径，让他实现来这里的目的？”字面上，每一个像素、每一行文案、每一个词都要为那个目标服务。

---

### [00:35:08] Anuj Rathi

**English:**
So that's showing the entire journey rather than just staying and assuming. So that is something that I've found really powerful with respect to even designing products or even thinking about why are we building something. What it also helps is when we are building complex products, especially in marketplaces because once you are building this for the user, simultaneously, something is happening on the other part if it is simultaneous, if it's a real-time marketplace, or something like that. So you're building something for the user and saying, "All right. If this guy ordered, now there's a 30 minutes time when our delivery executors will come to the user with food. What is happening? What's the emotional state of the user, and let's plot out the 30 minutes time, and let's create various scenarios. Is it like, 'Hey, maybe he went to the restaurant, and the food is delayed,' or the dude on a bike, his bike got punctured, et cetera. Now, what is the consumer thinking at this time?" So you show all of those things in real time, and that cuts out a whole bunch of random ways in which the product could have looked like if you're creating even a chatbot. So just having that showcase of all journeys coming together helps a lot in building your products in the right way.

**中文翻译:**
这就是展示整个旅程，而不是停留在假设层面。我发现这在设计产品或思考“我们为什么要建这个”时非常强大。它在构建复杂产品（尤其是双边市场）时也很有帮助。因为当你为用户构建功能时，如果是实时市场，另一端也在同时发生某些事情。你为用户构建了功能并说：“好，如果这个人下单了，现在有 30 分钟时间等待骑手送餐。这期间发生了什么？用户的情绪状态如何？让我们描绘出这 30 分钟，并创建各种场景。比如：‘嘿，也许骑手去了餐厅但出餐慢了’，或者‘骑手的车爆胎了’。这时消费者在想什么？”你实时展示所有这些情况，这能排除掉很多如果你只是在做聊天机器人时可能会出现的随机设计。这种将所有旅程整合在一起的展示，对以正确方式构建产品大有裨益。

---

### [00:36:19] Lenny

**English:**
So, essentially, just getting very detailed and very concrete with the product experience that you're building thinking about the user experience. Sounds like a lot of work. I can't imagine you do this often. Is the advice here to do this once a year or once and just keep it updated? It sounds like you did this at Swiggy, and that was a really impactful way of building the product.

**中文翻译:**
所以本质上，就是对你正在构建的产品体验变得非常细致和具体，深入思考用户体验。这听起来工作量很大。我无法想象你会经常这样做。你的建议是每年做一次，还是做一次然后不断更新？听起来你在 Swiggy 就这么做，而且这对构建产品产生了很大影响。

---

### [00:36:41] Anuj Rathi

**English:**
Yeah. I think there's not only one way actually. I think I recommend this every product manager to do a show don't tell version of their current version. At the same time, there's a new version all the time. So they can compare and contrast, and very easily explain to everyone why they're doing something. In fact, that wall... So it's called a wall. It also becomes one common place where you can get all the stakeholders in because it becomes... Instead of just doing the elevator pitch, you can actually do detailed discussions on why I'm choosing this versus something else, and so on, and so forth. That's a product manager's version of doing this.

**中文翻译:**
是的，其实不只有一种方法。我建议每个产品经理都为当前版本做一个“演给他们看”的版本。同时，产品总是在迭代。这样他们就可以进行对比，并非常容易地向所有人解释为什么要这么做。事实上，那面“墙”——我们称之为墙——会成为所有利益相关者聚集的地方。你不再只是做简短的电梯演讲，而是可以进行详细讨论：为什么我选这个而不选那个。这是产品经理层面的做法。

---

### [00:37:10] Anuj Rathi

**English:**
There's also a product leader's version of doing this thing which is recycle strategy on a page, and a lot of people call it like growth loops. Right? Don't show our user's journey. Now, let's see the entire strategy of the company together on one page. "All right. This is what the market looks like, and why will we get what kind of users? What is our activation budgets, and how many of them are we going to get to this next stage and get them to use it? How will we get them to cross-pollinate into different sections? Do we need a membership program? Are there any different levers which will press more or less and so on?" So that also is a show don't tell, and not only one, but usually, I like to create three of them as well like, "Why did we choose a strategy versus the other?" That, for example, is a very good way for our product leaders to get to one strategy that their CXOs align with and something that they can essentially tell the entire product and other teams, "This is what we're going to follow."

**中文翻译:**
还有一个产品领导者层面的做法，就是“一页纸策略”，很多人称之为增长环（growth loops）。不再只是展示用户旅程，而是把公司的整个策略放在一页纸上。“好，市场长这样，我们为什么要获取这类用户？我们的激活预算是多少？有多少人会进入下一阶段并开始使用？我们如何让他们交叉使用不同板块？我们需要会员计划吗？有哪些不同的杠杆可以调节？”这也是一种“演给他们看”。通常我也喜欢创建三个版本，比如：“为什么我们选择这个策略而不是另一个？”例如，这是产品领导者达成共识的好方法，让他们能与 CXO 保持一致，并告诉整个产品和其他团队：“这就是我们要遵循的方向。”

---

### [00:38:09] Lenny (Sponsor Break - Wix Studio)

**English:**
This episode is brought to you by Wix Studio. Your agency has just landed a dream client, and you already have big ideas for the website, but do you have the tools to bring your ambitious vision to life? Let me tell you about Wix Studio, the new platform that lets agencies deliver exceptional client sites with maximum efficiency. How? First, let's talk about advanced design capabilities. With Wix Studio, you can build unique layouts with a revolutionary grid experience and watch as elements scale proportionally by default. No-code animations add sparks of delight while adding custom CSS gives total design control. Bring ambitious client projects to life with any industry with a fully integrated suite of business solutions from e-commerce to events, bookings, and more, and extend the capabilities even further with hundreds of APIs and integrations. You know what else? The workflows just make sense. There's the built-in AI tools, the on-Canvas collaborating, a centralized workspace, the reuse of assets across sites, the seamless client handover, and that's not all. Find out more at wix.com/studio.

**中文翻译:**
本期节目由 Wix Studio 赞助。你的代理公司刚签下了一个梦想客户，你对网站已经有了宏大的构思，但你是否有工具将这一雄心壮志变为现实？让我向你介绍 Wix Studio，这个新平台能让代理公司以最高效率交付卓越的客户网站。如何实现？首先是先进的设计能力。通过 Wix Studio，你可以利用革命性的网格体验构建独特的布局，并观察元素如何默认按比例缩放。无代码动画增添了惊喜，而自定义 CSS 则提供了完全的设计控制。通过从电子商务到活动、预订等全套集成的业务解决方案，为任何行业的雄心项目注入生命，并通过数百个 API 和集成进一步扩展功能。还有什么？工作流非常合理。内置 AI 工具、画布协作、集中工作区、跨站点资产复用、无缝客户移交，远不止于此。访问 wix.com/studio 了解更多。

---

### [00:39:14] Lenny

**English:**
What kind of impact have you seen from implementing something like this, or is there an example of something that came out of this that was a big unlock? Again, it's probably a lot of work for someone to put together a whole board, keep it updated, screenshots, marketing, funnels of where people are coming from. What sort of impact do you see from doing this either on growth or people, what people think?

**中文翻译:**
实施这种方法后你看到了什么样的影响？或者有没有什么例子说明这带来了一个重大的突破？毕竟，要把整个看板拼凑起来、保持更新、截屏、分析营销漏斗和用户来源，工作量肯定很大。你认为这样做对增长、对团队成员或大家的想法有什么影响？

---

### [00:39:34] Anuj Rathi

**English:**
I think the largest impact that happens here is on alignment, so how CXOs are thinking if that is not very clear, and that can be a document, and so on, and so forth. But for a lot of people, it's not very clear on... I can see one part of the funnel. I can understand... The marketing team can understand the best why we are acquiring those users, but they don't fully see the picture of, "If I attract this kind of users, why will these users become loyal, and what does that entire thing look like or, say, some other team which is building a part of the product? Where do I come in and so on?" So I think the largest impact that the show don't tell has is on, basically, getting the entire company together on the same page and them being able to understand why I'm doing, and which part of the entire picture I am working on, and why others are working on so that I can actually work with them to solve that part. That's one.

**中文翻译:**
我认为最大的影响在于**对齐（alignment）**。如果 CXO 的想法不清晰，虽然可以写成文档，但对很多人来说，他们可能只看得到漏斗的一部分。营销团队最清楚为什么要获取这些用户，但他们不一定能看到全貌：“如果我吸引了这类用户，他们为什么会变得忠诚？整个过程长什么样？”或者其他负责产品某个部分的团队会问：“我在这里扮演什么角色？”所以，“演给他们看”最大的影响是让全公司达成共识，让他们明白我为什么这么做，我负责全貌中的哪一部分，以及别人在做什么，这样我才能与他们协作解决问题。这是第一点。

---

### [00:40:30] Anuj Rathi

**English:**
The other thing that it helps, Lenny, is it also helps in choosing directions, like I said, because we are not doing one, but three of them. I'm choosing one alternative versus the other, and sometimes these strategic discussions, they can get going all sorts of different ways, and maybe you will talk about one particular unique point and go deeper rather than look at the entire picture together and say, "This is good because of all of these five points that we presented in page one versus the other one."

**中文翻译:**
Lenny，它还有助于选择方向。正如我所说，因为我们不是只做一个方案，而是三个。我在对比不同的替代方案。有时战略讨论会跑偏，大家可能会揪住一个点深挖，而不是看全貌。有了这个工具，你可以说：“基于第一页展示的这五个点，这个方案比另一个好。”

---

### [00:41:01] Lenny

**English:**
I think the other benefit, just one of the benefits of working backwards in Amazon's whole written-down memo approach is it forces you to crystallize ideas and not stay superficial because there's so many good ideas in theory. But then, when you have to get really concrete, that's actually a terrible idea. Basically, it's the same benefit in a lot of ways of get very concrete. What are you actually going to do? That will help you identify, "Okay. This isn't going to work. What are we even thinking?" So I like that. Awesome. Okay. Another framework that you have is something that you call the four BB framework for product strategy. Can you talk about what that's all about?

**中文翻译:**
我认为亚马逊这种书面备忘录式的逆向工作法的另一个好处是，它迫使你使想法具体化，而不是停留在表面。理论上有很多好主意，但当你必须变得非常具体时，你会发现那其实是个烂主意。基本上，这在很多方面都有助于变得具体。你到底打算怎么做？这会帮你识别出：“好吧，这行不通，我们到底在想什么？”我喜欢这一点。太棒了。好，你还有另一个框架，叫产品策略的“4 BB 框架”。能聊聊那是怎么回事吗？

---

### [00:41:36] Anuj Rathi

**English:**
We essentially saw that if a startup actually usually wants to do a bunch of things across the border, there's always like, "Hey, I should be investing in tech debt or building core platforms. That would really help my product in the long term. That's super important," and that's my engineering managers and largely, people asking for that bandwidth. Then, there is the product manager themselves who's basically saying, "I want to do feature enhancement, bug fixes, my version twos, a few areas, experiments, and so on, and so forth." That's a regular product backlog that would work on screen by screen, and there's this leadership which will say, "You know what? Now, we have a suite of products. Now, I want to take a large delta bit that may work. It may not work, but we need to make sure that it works, but I need work across teams, and it's not only one person that needs to do it. I need contribution from four or five of you that come together and deliver that," or there are places where a company is just reimagining their identity, or they're pivoting which is like, "All right. We were doing X. Now, we are doing X plus Y. That's how we want to be known," or, "We were doing X. Now, we want to do very little of X because current consumers, okay, we will take care of them, but now we want to pivot into Y."

**中文翻译:**
我们发现，初创公司通常想做很多跨领域的事情。总会有人说：“嘿，我应该投资技术债或构建核心平台，这对产品的长期发展非常有帮助，这超级重要。”这通常是工程经理和大部分技术人员要求的带宽。然后产品经理会说：“我想做功能增强、修复 Bug、开发 2.0 版本、做一些实验等等。”这是常规的产品积压任务。接着领导层会说：“你看，我们现在有一系列产品了，我想做一个大的尝试（delta bit），它可能成功也可能失败，但我们需要确保它成功。这需要跨团队协作，不是一个人能完成的，需要你们四五个人共同努力。”或者有些公司正在重塑品牌身份或转型，比如：“我们以前做 X，现在要做 X+Y，这是我们希望建立的认知。”或者“我们要减少 X 的投入，转而投向 Y。”

---

### [00:42:55] Anuj Rathi

**English:**
So it usually is in four of these buckets, and what really happens is it gets down to product managers eventually prioritizing between these four. So I don't think it's a tactical prioritization product manager call. It really is a product strategy call, and the conversation that needs to happen is between, say, the head of product and the CEO or even the leadership. If I gave you a hundred focus points, how much will you put in each of these buckets, and what are those four buckets? Those are the four BB buckets, so what are the ones? We call them... First BB is Brilliant Basics. The reason why we call it BB, Brilliant Basic, you need to brand... You cannot brand it as tech debt, so it feels like very off because these are brilliant, these are important. That's what the company's built on, and the company needs to invest in that. So that's one.

**中文翻译:**
所以通常会有这四个“桶”，最后往往变成产品经理在这四者之间做优先级排序。我不认为这是一个战术性的优先级决策，它实际上是一个产品战略决策。这种对话应该发生在产品负责人和 CEO 甚至领导层之间。如果我给你 100 个关注点，你会给每个桶分配多少？这四个桶就是“4 BB”。第一个 BB 是 **Brilliant Basics（卓越基础）**。之所以叫这个名字，是因为你不能把它贴上“技术债”的标签，那听起来很消极。这些是卓越的、重要的，是公司立足之本，公司必须投资。这是第一个。

---

### [00:43:46] Anuj Rathi

**English:**
The second one is Bread and Butter. So that's your backlogs. If the product managers had no big ideas, and they just were left on their own, what would they come up with in terms of just improving that line of business that they're given? Then, there are Big Bets. Now, that's where your larger ideas that have come together, but how many big bets should we take, or is this big bet even a big one? That's where you're working backwards or PR FAQs start becoming even more important because those are the kind of bets that cannot be taken without everybody basically signing up, working backwards, and saying, "We will all make this successful."

**中文翻译:**
第二个是 **Bread and Butter（生计/常规业务）**。这就是你的积压任务。如果产品经理没有大想法，只是让他们自己发挥，他们会想出什么来改进他们负责的那条业务线？第三个是 **Big Bets（大赌注）**。这是那些整合在一起的大想法。但我们要下多少个大赌注？这个赌注真的够大吗？这时逆向工作法或 PR/FAQ 就变得尤为重要，因为这类赌注需要所有人达成共识、逆向推导并承诺：“我们将共同让它成功。”

---

### [00:44:26] Anuj Rathi

**English:**
Breaking Bad essentially is a different world altogether. That's where you want to redefine your company. For example, in Swiggy, if we were doing food delivery, now we want to do grocery delivery as well. It's like these are two companies working together, or from a food delivery company, we wanted to become a convenience company. So that's almost breaking bad. Again, like I said, we got cheesy, but the good thing that happens is now what you can do is, along with your leadership, take stock, and the head of product essentially can say, "You know what? In the next year, I can invest a lot less on my brilliant basics, and we should as a company focus a lot on this breaking back because that is existential." But then, we should not look back and say, "Why were tech systems a little bit broken this time? We had a little bit more down times."

**中文翻译:**
**Breaking Bad（绝命毒师/颠覆性创新）**本质上是另一个世界。这是你想重新定义公司的时候。例如在 Swiggy，如果我们以前做外卖，现在也想做生鲜配送，这就像两家公司在协作。或者从一家外卖公司变成一家便利服务公司。这就是“Breaking Bad”。虽然名字有点俏皮，但好处是，现在你可以和领导层一起盘点，产品负责人可以说：“明年我可以减少对‘卓越基础’的投入，全公司应该专注于这个‘颠覆性创新’，因为这关乎生死存亡。”但到那时，我们不能回头抱怨：“为什么这次技术系统有点出问题？停机时间变长了？”

---

### [00:45:17] Anuj Rathi

**English:**
You can basically blow it out and almost showcase what to expect. For example, if we are just working on a whole bunch of bread and butters, so you'll start seeing a lot fewer bugs, customers will be a little happier. You worked a lot more... drill in basics. Tech systems are nice, but you didn't create any differentiators. Well, none of your bets went out, and your competitors are catching up. So does that sound like a better future? These are hard questions, and these privatization questions... I don't think of product management questions so much as product strategy questions, but in a lot of cases, executors don't know what they're trading off against.

**中文翻译:**
你基本上可以摊开来说，展示预期的结果。例如，如果我们只做一堆“常规业务”，你会看到 Bug 变少了，客户更开心了。如果你多做“卓越基础”，技术系统会很棒，但你没有创造任何差异化。你的“大赌注”一个都没发，竞争对手正在赶超。这听起来像是一个更好的未来吗？这些是很难回答的问题。这些优先级问题，与其说是产品管理问题，不如说是产品战略问题。但在很多情况下，执行者并不知道他们在权衡什么。

---

### [00:45:53] Anuj Rathi

**English:**
So if you are able to create the conversation around which buckets do we want to put in and create three alternatives... I have tried to do that a bunch of times. Let's look at strategy A, and we see how to be divergent. Suppose we were putting a lot fewer focus points in brilliant basics and a lot more on, for example, big bets, then there will be a risk that they will be like, "We won't have any experiments or very less experiments. Bugs will stay bugs, but we will get a shot at changing the game." Is that a future that sounds better or something else which is like because you're pained also by a lot of bugs and constant down times, which is more secure, but we won't build something amazing, so which sounds better? Because you are able to drive that, now the clarity to the product managers is way clearer in terms of what will they do. Also, they would know that if they have been signed up for a big bet, then they will need to contribute to the PR FAQ. They will need to contribute to the actual working on that irrespective of what their product was, but now they're part of something bigger.

**中文翻译:**
所以，如果你能围绕“我们要把资源投进哪个桶”展开对话，并创建三个替代方案……我试过很多次。看看策略 A，我们如何发散。假设我们在“卓越基础”上投入很少，而在“大赌注”上投入很多，那么风险就是：“我们几乎没有实验，Bug 还是 Bug，但我们有机会改变游戏规则。”这个未来听起来更好吗？还是另一个方案：因为你受够了 Bug 和停机，所以选一个更稳妥的方案，但我们不会做出惊人的东西。哪个听起来更好？因为你能推动这种讨论，现在产品经理对该做什么就清晰多了。而且他们知道，如果他们参与了一个“大赌注”，无论他们原本负责什么产品，他们都需要为 PR/FAQ 做出贡献，参与实际工作，因为他们现在是宏大目标的一部分。

---

### [00:47:03] Lenny

**English:**
Awesome. I love it. So just to summarize so people can have just a very short definition of this framework. Brilliant Basics is essentially tech debt and things that you just have to do like hygiene almost. Bread and Butter is essentially optimizing the product, existing product. Big Bets are big bets, and Breaking Bad are just future big rocket like moon shots just transform the way the business works?

**中文翻译:**
太棒了，我喜欢这个。总结一下，让大家对这个框架有个简短的定义：**Brilliant Basics（卓越基础）**本质上是技术债和像卫生习惯一样必须做的事；**Bread and Butter（常规业务）**本质上是优化现有产品；**Big Bets（大赌注）**就是重大的尝试；**Breaking Bad（颠覆性创新）**则是未来的“登月计划”，旨在改变业务运作方式。

---

### [00:47:29] Anuj Rathi

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:47:30] Lenny

**English:**
I love it. It's also interesting. Another thread that comes up again and again in your advice is exploring all the options before committing to one like you always... I think it sounds like you always try to recommend three. I guess let me say what I always find is important there is I think it's important for the product manager to recommend one along with that. It's not just like, "Here's three. You tell me which one you do." It's like, "Here's three. Here's my recommendation why." Is that your advice too, or do you see something-

**中文翻译:**
我喜欢这个。很有趣的是，你的建议中反复出现的一个线索是在确定方案前探索所有选项。听起来你总是尝试推荐三个。我想说，我发现很重要的一点是，产品经理在给出三个选项的同时，必须推荐其中一个。不能只是说“这有三个，你选吧”，而是要说“这有三个，我的建议是这个，理由如下”。这也是你的建议吗？

---

### [00:47:53] Anuj Rathi

**English:**
100%, 100%. So when you have explored the three, you essentially have done the work one like, "I have covered all bases and also crystallized them into a concrete option. Now, I'm choosing one on the company's behalf on the basis of whatever I know about the market, about the company, about our strategy, and about how we will make it successful." Now, if I miss something, it's also a time where you can actually work with leadership and other product managers to essentially get that knowledge complete, or if you're 80% right, you can actually use elements of strategy two and strategy three to bring into one. So that's always the way that your thing that... one very concrete option, but because you have these other tools so that you're not missing and bringing it together. But ultimately, you're the one who is going to champion this, and that's where the other leadership element of Amazon comes in which is disagree and commit. But once we have aligned on this one, we'll all commit to launching this, and then the leadership should not go back and forth on that part.

**中文翻译:**
100% 正确。当你探索了三个方案，你本质上完成了第一步工作：“我已经覆盖了所有基础，并将它们具体化为可行的选项。现在，我根据对市场、公司、战略的了解，以及如何让它成功的判断，代表公司选择其中一个。”如果我遗漏了什么，这也是与领导层和其他产品经理协作、完善认知的时机。或者如果你有 80% 是对的，你可以吸收策略二和策略三的元素。所以，你始终要提供一个非常具体的选项，但因为你有其他工具，所以不会遗漏。最终，你是那个要推动这件事的人。这涉及亚马逊的另一个领导力原则：**持不同政见但服从大局（disagree and commit）**。一旦我们达成一致，我们就全力以赴发布它，领导层不应再反复摇摆。

---

### [00:48:59] Lenny

**English:**
Awesome. I want to go in a completely different direction. It feels like you have a lot of contrarian opinions about how to build product, and how to build teams, and build companies, and things like that, so I just want to start broad. What are some things you have contrarian opinions about, things you believe that a lot of other people maybe don't believe or seek differently?

**中文翻译:**
太棒了。我想换个完全不同的方向。感觉你对如何构建产品、团队和公司有很多反直觉（contrarian）的观点。我想先泛泛地问一下：你有哪些反直觉的观点？也就是那些你相信但很多人不相信或看法不同的事情？

---

### [00:49:19] Anuj Rathi

**English:**
So one, for example, excellence and speed. There's always a question around that. "Hey, would you rather ship faster, or would you rather ship better?" In my opinion, when you have to make a choice, think more and ship better. Most experiments should be thought experiments. They should not even be tried out because they're obviously going to fail which is contrary to, "Let's try it out, and then let's see." I think that wastes a lot of company time. If you had smart people who could do metathinking, a lot of experiments would just not even be like... It's not a rule, but it's a preference. I think speed and excellence are two different axes. Ideally, you should be better at both, but if you had to choose one, choose excellence.

**中文翻译:**
比如，关于**卓越（excellence）与速度（speed）**。总有人问：“你宁愿发布得更快，还是发布得更好？”在我看来，如果必须选择，那就多思考，发布得更好。大多数实验应该是“思想实验”，甚至不应该去尝试，因为它们显然会失败。这与“先试一下看看结果”的观点相反。我认为那浪费了公司大量时间。如果你有能进行元思考（metathinking）的聪明人，很多实验根本不需要做。这不是死律，而是偏好。我认为速度和卓越是两个不同的轴，理想情况下你应该两者兼得，但如果非选其一，选卓越。

---

### [00:50:04] Anuj Rathi

**English:**
There's another contrarian opinion which is... I think most product managers, and again, I'm probably talking a little bit of the kind of people that I work with and have interacted with in product. Most product managers should not even be product managers. They should think a little bit more around whether this is actually the right field for them because I think a lot of people from other areas have entered the field without fully realizing what it takes. So there is definitely a way in which you can coach yourself, and then work your way upwards of that one, but it can make you quite miserable if it's not right for you.

**中文翻译:**
另一个反直觉的观点是……我认为大多数产品经理甚至不应该做产品经理。我指的是我接触过的一些人。他们应该多想想这是否真的是适合他们的领域，因为我觉得很多来自其他领域的人进入这个行业时，并没有完全意识到这需要什么。当然，你可以通过自我训练不断提升，但如果这个职业不适合你，它会让你非常痛苦。

---

### [00:50:49] Lenny

**English:**
Is there something folks should look for there that will tell them you probably shouldn't be a product manager? Either motivation, or skill set, or background, or anything?

**中文翻译:**
有没有什么迹象能告诉人们“你可能不适合做产品经理”？是动力、技能集、背景还是别的什么？

---

### [00:50:55] Anuj Rathi

**English:**
No. I don't think about particular domains that you come from. I have, again, a simple framework of three. I think the first thing is essentially raw sharps, and that can manifest itself into problem identification and problem solving. That's one, and also, higher-order thinking and all of that. I think that is super important. The second one is what I call drive or grit. I think with that comes a whole bunch of qualities around curiosity, learnability, never giving up, consumer-backward thinking, "I really want to solve this," and all of that that comes with that. Third, which is a little difference, we talked about that, is influence. You're in the business of influence, and if you can see yourself that, "I'm built this way," or, "I want to really get better at these," that's when I think this field is going to serve you well.

**中文翻译:**
不，我不看重你来自哪个特定领域。我还是有一个简单的“三点框架”。第一是**原生智慧（raw sharps）**，体现为识别问题和解决问题的能力，以及高阶思维。我认为这极其重要。第二是我所说的**驱动力或韧性（drive or grit）**。随之而来的是好奇心、学习能力、永不言弃、以消费者为中心的逆向思维，以及“我真的很想解决这个问题”的决心。第三点略有不同，就是我们谈过的**影响力（influence）**。你从事的是影响力的生意，如果你觉得自己“天生如此”或者“真的很想在这些方面变强”，那么这个领域会很适合你。

---

### [00:51:45] Lenny

**English:**
I love that everything is three. How handy.

**中文翻译:**
我喜欢你所有的东西都是三点，真方便。

---

### [00:51:48] Anuj Rathi

**English:**
Only the BBs are four. I wish I could compress them three.

**中文翻译:**
只有 BB 框架是四个，我也希望我能把它压缩成三个。

---

### [00:51:51] Lenny

**English:**
Yeah. There's too many things to do there. Essentially, these are maybe your perspective on the most important PM skills. A good way to think about it. Influence, grit, and just being smart.

**中文翻译:**
是的，要做的事情太多了。本质上，这些可能是你认为最重要的 PM 技能：影响力、韧性和聪明。

---

### [00:52:02] Anuj Rathi

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### [00:52:03] Lenny

**English:**
I think what you said here is not like you have to be amazing at these to get into product and do well. It's you need to be excited about getting better at these skills.

**中文翻译:**
我觉得你说的意思不是说你必须在这些方面出类拔萃才能进入产品领域并做好，而是你需要对“提升这些技能”感到兴奋。

---

### [00:52:10] Anuj Rathi

**English:**
Yes. That's right.

**中文翻译:**
是的，没错。

---

### [00:52:12] Lenny

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:52:12] Anuj Rathi

**English:**
Well, I think it's not as if that everybody is born with a lot of influence. Of course, you can get better at it, but it's a prospect of that, "Hey, I will need to be influential to succeed at this job." That should excite you and not scare you away. You should not think like, "Hey, you know what? I can get away from this and still be very successful product manager," because most likely, you will not.

**中文翻译:**
并不是每个人天生就有很强的影响力。当然你可以通过练习变强，但关键在于这种前景：“嘿，为了在这份工作中成功，我必须具备影响力。”这应该让你兴奋，而不是把你吓跑。你不应该想：“嘿，我可以避开这一点，仍然做一个非常成功的产品经理”，因为极大概率你做不到。

---

### [00:52:34] Lenny

**English:**
Maybe spending a little more time here. So, smart, you're probably not going to be able to do a lot about. In terms of grit or influence, is there anything you can share about what you've seen most helps people develop at these skills other than just doing the job for a while, and then starting to get better at this?

**中文翻译:**
也许可以在这里多花点时间。关于“聪明”，可能没办法改变太多。但在“韧性”或“影响力”方面，除了工作一段时间自然积累经验外，你有没有发现什么能最有效地帮助人们提升这些技能？

---

### [00:52:49] Anuj Rathi

**English:**
Yeah. I think even smartness, I think 80% of that smartness, I think, is something that's very achievable. You don't need to be outstanding on that. Domain knowledge, for example, is something just like... An average smart person with no domain knowledge versus you armed with a lot of knowledge around domain and so on can already take you there, but you can take better decisions. I think first one is more about decision-making, problem identification, problem solving, and all of that. So I think that really can be developed at least to a level where you are very effective. Drive, I think, is probably the hardest to coach, probably the hardest. I've not seen people with less drive actually eventually turning out with a lot of drive, et cetera, but they can be inspired. I think you need to be a person who can think about it that way, but the third one, influences, I think, there's no negotiation there. You need to really think that, "I have to be good at this one."

**中文翻译:**
我觉得即使是“聪明”，其中 80% 也是可以达到的，你不需要天赋异禀。例如领域知识（domain knowledge）——一个没有领域知识的普通聪明人，对比一个武装了大量领域知识的你，你已经胜出了，因为你能做出更好的决策。我认为第一点更多关乎决策、识别问题和解决问题，这些是可以培养到非常高效的水平的。**驱动力（Drive）**可能是最难教的，我还没见过驱动力不足的人最后变得动力十足，但他们可以被启发。至于第三点**影响力**，我认为这是没商量的，你必须告诉自己：“我必须擅长这个。”

---

### [00:53:46] Anuj Rathi

**English:**
There's another framework that, Lenny, I wanted to talk about. When I look at product leadership in general and how do you think about different people and so on. When is it a product manager problem, or your problem, or a company problem? There are only three reasons, again, why things do not happen the way you want them to happen as a leader. You can look at a person, and you would say either that person can't do, which is a capability issue, or they won't do, which is a motivation or an alignment issue, or they were not set up to do, which is really your problem that you didn't set up the ways of working now design properly, or we are okay as such and such, and so on, and so forth.

**中文翻译:**
Lenny，我还想聊聊另一个框架。当我审视产品领导力以及如何评价不同的人时，我会问：这到底是一个产品经理的问题，是你的问题，还是公司的问题？作为领导者，事情没按预期发展，同样只有三个原因。观察一个人，你会说：要么是那个人**“不能做”（can't do）**，这是能力问题；要么是他们**“不愿做”（won't do）**，这是动力或对齐问题；要么是他们**“没被安排好去做”（not set up to do）**，这真的是你的问题——你没有设计好工作方式。

---

### [00:54:26] Anuj Rathi

**English:**
So, as a leader, it's almost the opposite of what we talked about, great influence and raw sharps. Do you have the right people in terms of capability? If not, is the right answer for us to coach them or to really put them... or mentor them and so on, or move them to some other place because maybe their capability is suited elsewhere? If they won't do, why won't they? Are they not aligned to you? Do they not agree with your vision? Do they not just have enough time? So on and so forth. So you need to really go deeper there. Why won't they do?

**中文翻译:**
所以作为领导者，这几乎是我们刚才谈论的（影响力、韧性、智慧）的反面。在能力方面，你是否有合适的人选？如果没有，正确的答案是辅导他们、指导他们，还是把他们调到其他更适合其能力的地方？如果他们不愿做，为什么？是目标不一致？不认同愿景？还是时间不够？你需要深入挖掘：他们为什么不愿做？

---

### [00:55:05] Anuj Rathi

**English:**
There are different answers for that, but if it's a setup issue, and at least I've realized that apart from what product managers can do, almost 70%, 80% of problems why things don't happen are a setup issue. Product leaders or other leaders have not thought through what OKRs are doing to my company, not really fully thought through around org design. If you've read the book called TEEN Topologies, that's one interesting book which starts with Conway's law and essentially saying, "Show me an engineering architecture, and I will actually tell you what the org design of this company is," but that also manifests itself in products that you can basically look at a product. In most cases, you will be able to say what was org design that led to this kind of product.

**中文翻译:**
这些问题有不同的答案。但如果是“安排/设置”问题，我意识到除了产品经理个人能做的之外，几乎 70%-80% 的问题都出在设置上。产品领导者或其他领导者没有想清楚 OKR 对公司意味着什么，没有充分考虑组织设计。如果你读过《团队拓扑》（Team Topologies）这本书，它从康威定律（Conway's law）开始，本质上是说：“给我看工程架构，我就能告诉你这家公司的组织设计长什么样。”这也体现在产品上，大多数情况下，你通过看一个产品，就能推断出是什么样的组织设计导致了这样的产品。

---

### [00:55:51] Lenny

**English:**
I have heard that book mentioned a couple of times recently. I got to check it out just to the three you just shared, which is another three. I love it. Can do, won't do. What was the third one again, didn't do?

**中文翻译:**
我最近听人提过好几次这本书，我得去看看。你刚才分享的又是三个点，我喜欢。**能做（Can do）**、**不愿做（Won't do）**，第三个是什么来着？**没做（Didn't do）**？

---

### [00:56:01] Anuj Rathi

**English:**
Not set up to do.

**中文翻译:**
**没被安排好去做（Not set up to do）**。

---

### [00:56:03] Lenny

**English:**
Not set up to do. That one is long. That's a long one. I think what's cool about these are they're essentially ways to measure performance. Maybe if you're a product manager, like performance reviews, it's like, "Did you have the skills to do this? Did you have the motivation to do this, or is it something not set up for you?" You weren't set up for success, basically?

**中文翻译:**
没被安排好去做。这个有点长。我觉得这些很酷的地方在于，它们本质上是衡量绩效的方法。如果你是产品经理，在绩效评估时可以问：“你有做这件事的技能吗？你有动力吗？还是说环境没为你准备好？”基本上就是你没有被安置在成功的路径上。

---

### [00:56:20] Anuj Rathi

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### [00:56:21] Lenny

**English:**
Okay. Let's go to AI corner, something I'm trying to do with every guest. Is there anything you've learned about working with AI that you think might be helpful to listeners?

**中文翻译:**
好，让我们进入“AI 角落”，这是我尝试对每位嘉宾都做的环节。关于与 AI 协作，你学到了什么你认为对听众有帮助的东西吗？

---

### [00:56:31] Anuj Rathi

**English:**
Yeah. I think a couple of things. I think working with AI, many, many teams and companies get too excited about AI, and the possibilities, and so on, and it's almost like a solution ready to find a problem within their companies, which also is fine because now you're thinking about possibilities on what this particular technology can do for my company. So it's a good way to start, but many people don't actually use it in the best way possible and force fit it. Instead of that, you can think about, "How do I get AI to work with HI?" Again, it's connecting back with... and this is something that Swiggy CEO, Sriharsha, invented this term called HI just to make sure that everybody understands.

**中文翻译:**
有几点。我认为在与 AI 协作时，很多团队和公司对 AI 及其可能性过于兴奋，这几乎变成了一种“拿着锤子找钉子”的情况——带着解决方案在公司里找问题。这也没关系，因为你在思考这项技术能为公司做什么，是个好的开始。但很多人并没有以最佳方式使用它，而是强行套用。相反，你应该思考：“我如何让 AI 与 **HI** 协作？”这又绕回来了——Swiggy 的 CEO Sriharsha 发明了 HI 这个词，就是为了让大家明白。

---

### [00:57:13] Anuj Rathi

**English:**
Artificial intelligence is important as much as human intelligence. If you're not humanly intelligent, you're not going to be artificially intelligent or AI really help your company a lot. So, literally, any product that you're building, even when it is technologically quite interesting, and exciting, and so on, it needs to be balanced out and work together along with a great UX, along with behavioral science. The combination of those two will actually make sure that you're getting the best outcome of that, unless you are building something which is completely backed and with no human interventions. We're talking about consumer products largely.

**中文翻译:**
**人类智能（Human Intelligence, HI）**与人工智能同样重要。如果你本身不够聪明（缺乏人类智能），人工智能也帮不了你的公司太多。字面上看，你构建的任何产品，即使技术上非常有趣、令人兴奋，也需要与优秀的 UX（用户体验）和行为科学相平衡并协同工作。除非你构建的是完全后台运行、无需人工干预的东西，否则两者的结合才能确保获得最佳结果。我们这里主要讨论的是消费级产品。

---

### [00:57:51] Lenny

**English:**
You've helped build some of the most successful marketplaces in India and in the world. I'm curious just what may be a lesson or two about building a successful marketplace?

**中文翻译:**
你曾帮助构建了印度乃至全球最成功的一些双边市场（marketplaces）。我很想知道，关于构建成功的双边市场，你有什么经验教训可以分享？

---

### [00:58:02] Anuj Rathi

**English:**
One thing that I would definitely want to talk about is when you're thinking marketplaces, it's not as a one plus one equals two, it multiplies. We're thinking about three-way marketplaces. You almost not need to think like it's a two-dimensional plane going into three-dimension. It becomes that amount of complexity, and your regular product management and leadership principles start failing. So a bunch of usual suspects will not work. Let me give an example. OKRs will not work. Why not? So, fundamentally, OKRs are a way to think about objectives and key results, but the fundamental assumption here is that it is solving for a kind of user, and that kind of user, you can divide and conquer. Of course, there will be a little bit of tussle between different teams, but you can get them to work with each other. But if it is working for three different kinds of users, then all the goals will all the time be in conflict with each other.

**中文翻译:**
我一定要谈的一点是：当你思考双边市场时，它不是 1+1=2，而是乘法效应。我们考虑的是三方市场（消费者、骑手、餐厅）。你必须把它想象成从二维平面进入三维空间。复杂度呈几何倍数增长，你常规的产品管理和领导力原则会开始失效。很多常用的方法都不管用。举个例子：OKR 行不通。为什么？从根本上说，OKR 是关于目标和关键结果的，但它的基本假设是你在为某一类用户解决问题，你可以分而治之。虽然不同团队间会有摩擦，但可以协作。但如果涉及三类不同的用户，所有的目标会时刻处于冲突之中。

---

### [00:59:00] Anuj Rathi

**English:**
What are examples of the three users? There's like the delivery person, the restaurant-

**中文翻译:**
这三类用户是哪些？比如配送员、餐厅——

---

### [00:59:04] Anuj Rathi

**English:**
The end user. So if you have... I'll give you an example of. On the consumer side, we need to collect more delivery fee. What does that really mean for those other two? On the restaurant side, hey, we need to get more commissions because profitability is a goal. On the delivery partner side, it means pay them less or optimize a little bit more. But once you start moving one lever, those two are already stretched towards the other directions. They're not independent levers in the first place, and the way to even model them out... How will it work? What if we choose X versus what... Ys will change. Y on Z. Z will change. It's almost impossible to do that.

**中文翻译:**
还有终端用户。我举个例子：在消费者端，我们需要收取更多配送费。这对另外两方意味着什么？在餐厅端，嘿，我们需要更多佣金，因为盈利是目标。在骑手端，这意味着少付给他们钱或者进一步优化效率。但一旦你拨动一个杠杆，另外两个就会被拉向相反的方向。它们根本不是独立的杠杆。甚至很难建立模型：如果我们选择 X，Y 会变，Y 变了 Z 也会变。这几乎是不可能完成的任务。

---

### [00:59:43] Anuj Rathi

**English:**
So I've seen OKRs fail multiple times when you're running this kind of a marketplace. Big bets work much better. That's when you say, "Hey, we want to take this bit," but it's all going to be... It's all going to come together as... If we pull this lever, then something else will change. So here's the entire story of, "Let's go make this profitable by making delivery fee higher, but maybe not touching earnings per hour, or maybe not touching restaurant commissions." Things like that. So I've at least found that's a better way to choose strategically which direction we have to go.

**中文翻译:**
所以我见过 OKR 在这种市场模式中多次失败。**“大赌注”（Big bets）**效果要好得多。这时你会说：“嘿，我们要尝试这个方案”，但它是一个整体。如果拨动这个杠杆，其他东西也会变。所以整个故事是：“让我们通过提高配送费来实现盈利，但可能不触动骑手的时薪，或者不触动餐厅的佣金。”诸如此类。我发现这至少是选择战略方向的一种更好方式。

---

### [01:00:18] Anuj Rathi

**English:**
The other thing is managing multiple empathies together that's not straightforward. So, again, Swiggy being a real-time, hyper-local marketplace, and we discussed about that, right? As soon as the order comes, what happens between when user does this and when delivery executor is doing something else, and what are absolute different kind of scenarios that are going to be faced by the delivery executor? At the same time, how will I really work with the user to manage their emotions? So you need to manage a whole bunch of these things together, and product management here, you cannot have... The delivery executive product manager only care about that side. They also need to be a champion on the consumer side and vice versa.

**中文翻译:**
另一件事是同时管理多重共情，这并不简单。再以 Swiggy 为例，它是一个实时的、超本地化的市场。订单一进来，用户操作和骑手操作之间发生了什么？骑手会面临哪些完全不同的场景？同时，我该如何与用户沟通以管理他们的情绪？你需要同时管理这一大堆事情。在这里，负责骑手端的产品经理不能只关心那一端，他们也必须是消费者端的捍卫者，反之亦然。

---

### [01:01:03] Lenny

**English:**
Yeah. I find with marketplaces... Uber went through this, Lyft went through this where the supply often just gets squeezed because they need to deliver for the customer. So drivers end up getting housed. Airbnb hosts get pushed to do things they may not want to do. Imagine delivery people, same thing.

**中文翻译:**
是的，我发现双边市场都有这个问题。Uber 经历过，Lyft 也经历过，供应端（司机/房东）往往会被挤压，因为平台需要为客户提供服务。所以司机最后很惨，Airbnb 房东被迫做不想做的事。想象一下配送员，也是一样。

---

### [01:01:18] Anuj Rathi

**English:**
Now that you mentioned Uber, for example, one of the things that companies which were running taxi businesses. If you have just one limited pool of money, for example, and you want to get the marketplace humming with respect to number of orders per day, how do you decide, "Should I incentivize my users, for example, for the first ride, first 10 rides, and so on, or put zero money in there, but incentivize my drivers?" You need to come here, so you have to think about liquidity also in very different ways, and sometimes you need to pull the lever completely towards the other side. So the experiments also. A/B experiments also don't work, and that's a very unique thing about marketplaces. I mean, not work the way that you would expect them to work because there are network effects all over. So if you have to run A/B experiments on your drivers side, if you put half drivers on A versus half on B, but there is a network effect between the both of them.

**中文翻译:**
既然你提到了 Uber，举个例子，经营出租车业务的公司如果只有有限的资金池，而你想让市场在每日订单量上活跃起来，你该如何决定？是补贴用户的前 10 次行程，还是完全不给用户钱，转而补贴司机？你必须以非常不同的方式思考**流动性（liquidity）**，有时你需要把杠杆完全推向另一边。此外，实验也是如此。A/B 测试在双边市场中往往行不通，或者说不像你预期的那样起作用，因为到处都是网络效应。如果你在司机端做 A/B 测试，一半司机在 A 组，一半在 B 组，但他们之间存在网络效应。

---

### [01:02:19] Lenny

**English:**
When you're trying to decide which side of the marketplace to focus on and prioritize, do you have any lessons or rules of thumb of just focus on the customer and index towards their happiness versus the supply versus, say, the delivery person?

**中文翻译:**
当你决定优先关注市场的哪一端时，你有什么经验法则吗？是专注于客户并倾向于他们的幸福感，还是倾向于供应端，比如配送员？

---

### [01:02:32] Anuj Rathi

**English:**
There's one thing that I think marketplaces need to realize is that, A, you need to be operating in a stable marketplace. So all sides need to be stable enough so that they're not going to go away. So I think that's a starting point, and that's an important point because once we have established that, then after a stable marketplace, then we say, "Which are the kind of customer that we are in the service for? Which are the customer that we will really focus on?" For example, Amazon is very, very clearly a customer-centric company. If they have to make a choice, they won't because they need to have a stable marketplace. So sellers also are very... as important, but slightly more important than the customer.

**中文翻译:**
我认为双边市场需要意识到的一点是：首先，你必须在一个稳定的市场中运营。各方都必须足够稳定，不会流失。这是起点，也是重要的一点。一旦确立了稳定性，我们再问：“我们是为哪类客户服务的？我们真正关注哪类客户？”例如，亚马逊显然是一家以客户为中心的公司。如果必须做选择，他们会很纠结，因为他们需要稳定的市场。所以卖家也非常重要，但可能比客户稍微次要一点点。

---

### [01:03:10] Anuj Rathi

**English:**
For example, if you looked at, say, Taobao or in Alibaba, their way of thinking is their aim in life is to create life-changing experience for 10 million Chinese sellers, and they will create a marketplace from the point of view of sellers which can actually sell. Again, they will have the same consumer app, and a seller work, and so on. They are in the service of sellers, so you really need to derive from the company's vision. I think the way we had thought about it at Swiggy that we had to clarify in our values that the first value is... Initially, it used to be customer comes first, but that was very confusing because everybody is a customer. Even a restaurant is a selling customer and so on. We had to clarify that consumer comes first, the end consumer which is actually eating food because we are a convenience company that delivers to the end consumer, and when you're thinking about restaurants or delivery partners, we work with them because we both are... When you're talking with the delivery partner, Swiggy and the delivery partner, we both are in the service of the customer. So you'll build that app also from that perspective and even the restaurant side also from that perspective that we both are together in the service of the end customer.

**中文翻译:**
再比如，如果你看淘宝或阿里巴巴，他们的思维方式是：人生的目标是为 1000 万中国卖家创造改变生活的体验。他们会从卖家的角度构建一个能卖出货的市场。当然，他们也有消费者 App。但他们是为卖家服务的。所以你真的需要从公司的愿景出发。在 Swiggy，我们必须在价值观中明确：第一条价值观最初是“客户第一”，但这很令人困惑，因为每个人都是客户。餐厅也是付费客户。我们后来明确为“消费者第一”，即那个真正吃东西的终端消费者。因为我们是一家为终端消费者提供便利的公司。当我们考虑餐厅或骑手时，我们与他们合作是因为我们双方都在为消费者服务。所以你会从这个角度构建骑手 App 和餐厅端，即我们都在共同为终端客户服务。

---

### [01:04:25] Lenny

**English:**
I feel like you have probably a hundred more frameworks, and processes, and acronyms we can talk about, but I know you got to go. Is there anything else you wanted to touch on, or is there anything else you want to leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
我觉得你可能还有一百个框架、流程和缩写可以聊，但我知道你得走了。在进入激动人心的闪电轮问答之前，你还有什么想补充的，或者想留给听众的话吗？

---

### [01:04:38] Anuj Rathi

**English:**
Just last few words that I want to revise. Work backwards from an amazing future. So first thing is creatively imagine a future, and then work backwards from that, and essentially, think what will make that successful, and be paranoid about... that everything is going to go wrong. Hence, I need to just make sure that it all comes together.

**中文翻译:**
最后想重申几句话：从一个美好的未来开始逆向工作。首先是创造性地想象一个未来，然后从中逆推，思考什么能让它成功。并且要保持偏执，时刻担心一切都会出错，因此我必须确保所有环节都紧密配合。

---

### [01:04:59] Lenny

**English:**
Only the paranoids survive. Great advice to leave people with. We've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
“只有偏执狂才能生存”。这是留给大家的好建议。我们进入了激动人心的闪电轮。我有六个问题要问你，准备好了吗？

---

### [01:05:07] Anuj Rathi

**English:**
Yeah.

**中文翻译:**
准备好了。

---

### [01:05:07] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:05:12] Anuj Rathi

**English:**
One book is Working Backwards. We covered that. The other one that has shaped my beliefs a lot is called How Brands Grow by a professor called Byron Sharp. There are two paths to it, How Brands Grow 1 and 2, that's both very good. The other book which I really love is... and recently, Kunal Shah, who's the founder of Cred, an Indian startup, suggested is The Luxury Strategy. The reason why I love that book is because it gets into the depth of the human psychology behind hierarchies, and how lords, and kings, and those kind of social hierarchies have shaped how people think about aspirational products and so on. So highly recommend it.

**中文翻译:**
一本是《逆向工作法》（Working Backwards），我们聊过了。另一本极大地塑造了我的信念的书是 Byron Sharp 教授写的《品牌如何增长》（How Brands Grow），有 1 和 2 两部，都非常好。还有一本我很喜欢的书，是印度初创公司 Cred 的创始人 Kunal Shah 最近推荐的，叫《奢侈品战略》（The Luxury Strategy）。我喜欢这本书是因为它深入探讨了等级制度背后的人类心理，以及领主、国王等社会等级如何塑造了人们对向往类产品（aspirational products）的看法。强烈推荐。

---

### [01:05:52] Lenny

**English:**
What's a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
最近有什么非常喜欢的电影或电视节目吗？

---

### [01:05:57] Anuj Rathi

**English:**
I really like to do reruns of The Office. I was trying to think about this as, "What is a recent movie that I watched?" I'm like, "No." I keep on going back to The Office and some other episode. Like today, I have a lot of stories from Michael Scott.

**中文翻译:**
我非常喜欢重温《办公室》（The Office）。我试着想最近看了什么电影，结果发现没有，我总是在反复看《办公室》的某一集。比如今天，我脑子里全是 Michael Scott 的段子。

---

### [01:06:13] Lenny

**English:**
Okay. The US one, not the British one, or do you watch both?

**中文翻译:**
好，是美版的还是英版的？还是两部都看？

---

### [01:06:16] Anuj Rathi

**English:**
No. I watch both, but the US one has a lot more seasons.

**中文翻译:**
两部都看，但美版的季数更多。

---

### [01:06:21] Lenny

**English:**
Do you have a favorite interview question that you like to ask candidates when you're interviewing product-manager-specific?

**中文翻译:**
在面试产品经理时，你有没有最喜欢问的问题？

---

### [01:06:27] Anuj Rathi

**English:**
"Which are the products where you decide speed is more important versus which are the products where you have to say excellence is what's important?" I think that gives me a good understanding of their frameworks and why they're just saying what, and then we go back into concrete examples where they chose one versus the other, and then take it from there.

**中文翻译:**
“哪些产品你会决定速度更重要，哪些产品你必须说卓越更重要？”我认为这能让我很好地了解他们的思维框架，以及他们为什么这么说。然后我们会深入探讨他们选择其中之一的具体案例，并以此展开。

---

### [01:06:46] Lenny

**English:**
Then, what do you look for In a good answer to that question?

**中文翻译:**
那么，一个好的回答你最看重什么？

---

### [01:06:49] Anuj Rathi

**English:**
I look for, essentially, their assessment of risk, their assessment of how important or how well have they assessed the market and the competition or the competitive products in that market. If their answer is, "Let's ship something, and we'll find out, and so on," that also gives me, basically, a point of view that they really don't understand that this product, what they're talking about with the shipping speed, is not really... The V part of the MVP is not viable or is not... I don't know. How do you call the MLP or whatever? But it's not differentiated enough that it can be marketed. It is not worth enough where we can take it to user. It's not going to work for a lazy win and selfish user, and maybe that's not the answer towards speed versus excellence versus, for example, there's some products which are... There's a very clear competitive differentiation that we can find. There was a clear market gap. I want to launch something even if it is half-baked. No problem. I want to go, take it out, get user feedback, I trade, and so on. So understanding of the market, A, but B, also understanding of the core orientation.

**中文翻译:**
我主要看他们对风险的评估，以及他们对市场和竞争对手的了解程度。如果他们的回答只是“先发出去看看”，这告诉我他们并不理解：他们所说的追求速度而发出的产品，可能连 MVP（最小可行性产品）中的“V”（可行性）都达不到。它可能不够差异化，无法进行营销，不值得推给用户，也无法打动那些懒惰、虚荣、自私的用户。而有些产品，如果存在明显的市场空白和竞争差异化，即使是半成品我也想发布，去获取反馈并迭代。所以，第一是对市场的理解，第二是对核心导向的把握。

---

### [01:08:00] Lenny

**English:**
It comes back to your ongoing advice of being full-stack in a lot of ways, and in this case, being a full-stack PM thinking about marketing, launch, and adoption, all those things. Next question, what is a favorite product you've recently discovered that you really like?

**中文翻译:**
这又回到了你一直强调的“全栈”建议，即作为一个全栈 PM，要考虑营销、发布、采用等所有环节。下一个问题：你最近发现了什么非常喜欢的个人产品？

---

### [01:08:15] Anuj Rathi

**English:**
The very recent product that I like is called RISE. It's a sleep track app because I am half insomniac, and for the longest time, I was thinking about, "How can I track this? What am I doing, and how can I actually get better at this?" So I really like the way that they actually help the end user. It's just been a week since I've started using it, but recommend it.

**中文翻译:**
最近很喜欢的一个产品叫 RISE。它是一个睡眠追踪 App。因为我有半失眠症，长期以来我都在想：“我该如何追踪睡眠？我到底在做什么？我该如何改善？”我非常喜欢他们帮助终端用户的方式。我才用了一周，但很推荐。

---

### [01:08:42] Lenny

**English:**
Has that helped your sleep yet or too soon to say?

**中文翻译:**
它改善你的睡眠了吗？还是现在说还太早？

---

### [01:08:45] Anuj Rathi

**English:**
It's helped me track my sleep, so it's... Now, it's getting into the zone where it is actionable, but I like it.

**中文翻译:**
它帮我追踪了睡眠，现在正进入“可采取行动”的阶段，我很喜欢它。

---

### [01:08:51] Lenny

**English:**
Okay, okay. We'll see.

**中文翻译:**
好，拭目以待。

---

### [01:08:52] Anuj Rathi

**English:**
We'll see.

**中文翻译:**
拭目以待。

---

### [01:08:53] Lenny

**English:**
Do you have a favorite life motto that you often come back to, share with people, think about in either work or life?

**中文翻译:**
你有没有什么人生格言，是你在工作或生活中经常想起或分享给别人的？

---

### [01:09:01] Anuj Rathi

**English:**
I would call it a life motto as much, but one of the things that I keep telling my people who work with me, alongside me, and so on is, "Stop externalizing." That's one, which also means the more artistic way to say that is you are the reason for your own misery. So that something that I keep using a lot more in a fun way. But if things go wrong, if that leadership meeting didn't happen in that way, if my product bombed, and so on, go back and let's ask ourselves what could we have done better, what I could have done better, and so on. Of course, because I'm also a poker player, so in a way, I understand there is half luck involved and half skill. But over a long period of time, if it's only luck and you're failing, and failing, and failing, you have to go and look back at your skill. So, yeah. You are the reason for your own misery.

**中文翻译:**
我不确定这算不算格言，但我经常对共事的人说：“停止外因化（Stop externalizing）。”换种更文艺的说法就是：“你才是造成自己困境的原因。”我经常开玩笑地用这句话。如果事情出了差错，如果领导会议没按预期进行，如果产品搞砸了，回到原点问问自己：我们本可以做得更好吗？我本可以做得更好吗？当然，我也是个德州扑克玩家，我明白其中一半是运气，一半是技术。但长期来看，如果你一直在失败，你就不能只怪运气，必须反思自己的技术。所以，是的，“你才是造成自己困境的原因”。

---

### [01:09:50] Lenny

**English:**
I love that advice. Be very empowering, and be responsible. Final question. I was stalking your LinkedIn. You host an event called The Secret Soiree, which is not that secret because you post about it, but I'm curious, just what is that all about, and what got you to do these sorts of events?

**中文翻译:**
我喜欢这个建议，非常有力量且负责任。最后一个问题：我翻了你的 LinkedIn，你举办了一个叫“秘密晚会”（The Secret Soiree）的活动，虽然你在网上发了，所以也不算太秘密。我很想知道那是关于什么的，是什么促使你举办这类活动的？

---

### [01:10:07] Anuj Rathi

**English:**
So we just started, me and an ex-colleague of mine, Shivangi. So we essentially wanted to meet cool people around. So that's how it started. Interesting people without agenda who can come together and discuss interesting stuff about entrepreneurship, about startups, about products, about connections, and so on, and so forth. So it just started like that, and now we are onto many, many more interesting things that we are bringing in terms of cohorts which will be team-based. So it could be around product management, around marketing, around growth, and so on. We are strictly keeping it not-for-profit for at least the next year, but long way to go.

**中文翻译:**
这是我和前同事 Shivangi 刚发起的。本质上我们只是想结识周围酷的人。没有特定目的，有趣的人聚在一起讨论创业、初创公司、产品、人脉等等。就这样开始了。现在我们正在尝试更多有趣的形式，比如基于团队的学习小组（cohorts），涵盖产品管理、营销、增长等领域。至少在未来一年内，我们坚持非营利性质，路还很长。

---

### [01:10:51] Lenny

**English:**
Amazing, and so for listeners, is this something they could join? Who should look into this? Who is this for?

**中文翻译:**
太棒了。对于听众来说，这是他们可以加入的吗？谁应该关注这个？它是为谁准备的？

---

### [01:10:57] Anuj Rathi

**English:**
Absolutely. At that time, probably, we'll not call it The Secret Soiree once we have probably expanded.

**中文翻译:**
当然可以。等我们规模扩大了，可能就不叫“秘密晚会”了。

---

### [01:11:02] Lenny

**English:**
No longer secret. Okay. Cool, and then I guess they just follow you on LinkedIn, right? That's how they can keep up to date with these sorts of events. Okay. Cool.

**中文翻译:**
不再秘密了。好，酷。我想大家只要在 LinkedIn 上关注你就行了，对吧？那是了解这类活动最新动态的方式。

---

### [01:11:11] Anuj Rathi

**English:**
Yes, on LinkedIn as well as on Twitter.

**中文翻译:**
是的，LinkedIn 和 Twitter 都可以。

---

### [01:11:12] Lenny

**English:**
Awesome. Anuj, we've gone through so many topics. We've talked about breaking bad and full-stack product management, full-stack thinking, working backwards, bread and butter, rule of threes. I don't know. So many things. Two final questions. Where can folks find you online if they want to reach out and follow up on anything we've talked about, and how can listeners be useful to you?

**中文翻译:**
太棒了。Anuj，我们聊了这么多话题：颠覆性创新、全栈产品管理、全栈思维、逆向工作法、常规业务、三点原则等等。最后两个问题：如果大家想联系你或跟进我们聊过的内容，可以在哪里找到你？以及，听众可以为你提供什么帮助？

---

### [01:11:33] Anuj Rathi

**English:**
Yes. So I'm on Twitter, so on twitter.com/anujrathi, and LinkedIn, you can just search my name. I'm pretty active on both of them. I do a bunch of... not podcasts all the time like you host, Lenny, but a bunch of other events as well as talks, so. I keep on posting on Twitter. They can find me there.

**中文翻译:**
好的。我在 Twitter（twitter.com/anujrathi）和 LinkedIn 上，直接搜我的名字就行。我在两个平台上都很活跃。我会参加很多活动和演讲，虽然不像你这样经常主持播客。我会一直在 Twitter 上发动态，大家可以在那里找到我。

---

### [01:11:55] Lenny

**English:**
Amazing. Anuj, thank you so much for being here.

**中文翻译:**
太棒了。Anuj，非常感谢你能来。

---

### [01:11:59] Anuj Rathi

**English:**
Thank you so much, Lenny, for hosting.

**中文翻译:**
非常感谢 Lenny 的主持。

---

### [01:12:01] Lenny

**English:**
It's my pleasure. Bye, everyone.

**中文翻译:**
我的荣幸。大家再见。

---

### [01:12:05] Lenny (Outro)

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。此外，请考虑为我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。