# April Dunford 2.0 - 双语对照

# Lenny's Podcast: April Dunford 2.0 - Sales Pitch

---

### [00:00:00] April Dunford

**English:**
40 to 60% of B2B purchase processes end in no decision. If you scratch on that data, the majority of those aren't saying, "Well, I'm not making a decision to buy something new because the old thing we were doing is better." That's not true at all. In fact, the majority of those is they couldn't figure out how to make a choice confidently. So what they did was they just went to their boss and said, "You know what? Now's not a good time. Let's not do it now. Let's do it next year. Let's just delay it." Because that is the safe risk-free thing for that person who's on the hook to make the decision to do.

**中文翻译:**
40% 到 60% 的 B2B 采购流程最终以“无决策”告终。如果你深入研究这些数据，你会发现其中大多数人并不是在说：“我不打算买新东西，是因为我们过去用的旧东西更好。” 事实并非如此。实际上，绝大多数情况是因为他们不知道如何自信地做出选择。所以他们采取的行动就是去找老板说：“你知道吗？现在不是个好时机。我们现在先别做了，明年再说吧。咱们推迟一下。” 因为对于那个负责做决策的人来说，这样做才是最安全、无风险的选择。

---

### [00:00:39] Lenny

**English:**
Today. My guest is April Dunford. April is the world's foremost authority on product positioning. She's the author of the bestselling book, Obviously Awesome, which is my favorite book on positioning. And this is her second time on the podcast because she just published a new book called Sales Pitch, which builds on her 25-year career as VP of marketing and advisor to companies like Google and Epic Games and many others. The book guides you through a better way to pitch and sell your product. And in our conversation, April shares the framework that she has seen work most often in getting potential customers to get excited about your product and to decide to buy your product.
(00:01:16):
Like I say, at the top of this episode, you'll become better at pitching and selling your product by the end of this episode. And if that's useful to you, which it should be, this episode is for you. With that, I bring you April Dunford after a short word from our sponsors.

**中文翻译:**
今天，我的嘉宾是 April Dunford。April 是全球产品定位领域的顶级权威。她是畅销书《显然很棒》（Obviously Awesome）的作者，这也是我最喜欢的关于定位的书。这是她第二次来到本播客，因为她刚刚出版了一本名为《销售话术》（Sales Pitch）的新书。这本书凝聚了她 25 年担任营销副总裁以及谷歌、Epic Games 等多家公司顾问的职业生涯精华。书中指导你如何以更好的方式推销和销售产品。在我们的对话中，April 分享了一个她认为在激发潜在客户兴趣并促使他们决定购买产品方面最有效的框架。
(00:01:16):
正如我在本集开头所说，听完这集节目，你推销和销售产品的能力将会得到提升。如果这对你有用（事实也确实如此），那么这一集就是为你准备的。下面，在听完赞助商的简短广告后，让我们欢迎 April Dunford。

---

### [00:01:32] Speaker 1 (Sponsor Ads)

**English:**
This episode is brought to you by Composer, the AI powered trading platform now with retirement accounts. Algorithmic trading has historically been reserved for the hedge fund elite. Now with Composer, you can automate your trading with a library of over 1000 strategies that are easy to understand and tweak using an AI assistant and visual editor. Composer is the first ever algorithmic trading platform where you don't need any coding experience. It includes a full range of trading indicators for you to get creative and a Discord community of 2,500 traders to discuss your ideas with.
(00:02:06):
Composer also has a powerful back tester to see the historical performance of your strategies, and you can then invest with a single click. Once you invest, Composer will automatically trade for you based on the logic of your strategy. With $1 billion in trading volume and over 1 million trades executed, composer already has many big time investors using the platform regularly.
(00:02:26):
Head to composer.trade and use the code Lenny for an extra week of free trial on your composer membership. That's composer.trade. This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums from modern growth teams. Companies like DraftKings, Zapier, click up, Twitch and Cameo rely on Eppo to power their experiments. Wherever you work running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to wasted time building internal tools or trying to run your own experiments through a clunky marketing tool.
(00:03:04):
When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform where I was able to slice and dice data by device types, country, user stage. Eppo, does all that and more delivering results quickly, avoiding annoying prolonged analytic cycles and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic click through metrics and instead use your north star metrics like activation, retention, subscription and payments. Eppo supports test on the front end, on the backend, email marketing, even machine learning clients. Check out Eppo at geteppo.com, that's geteppo.com and 10 x your experiment velocity.

**中文翻译:**
本集节目由 Composer 赞助播出，这是一款现已支持退休账户的 AI 驱动交易平台。算法交易在历史上一直是对冲基金精英的专属。现在有了 Composer，你可以通过拥有 1000 多种策略的库来实现交易自动化，这些策略易于理解，并可以使用 AI 助手和可视化编辑器进行调整。Composer 是首个无需任何编程经验的算法交易平台。它包含全套交易指标供你发挥创意，还有一个拥有 2500 名交易者的 Discord 社区供你讨论想法。
(00:02:06):
Composer 还拥有强大的回测功能，可以查看策略的历史表现，然后只需一键即可投资。一旦投资，Composer 将根据你的策略逻辑自动为你交易。凭借 10 亿美元的交易量和超过 100 万次的交易执行，Composer 已经吸引了许多大牌投资者定期使用。
(00:02:26):
访问 composer.trade 并使用代码 “Lenny”，即可获得额外一周的 Composer 会员免费试用。地址是 composer.trade。本集节目还由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 AB 测试平台。像 DraftKings、Zapier、ClickUp、Twitch 和 Cameo 这样的公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有能与现代增长团队技术栈集成的商业工具。这导致人们浪费时间构建内部工具，或者尝试通过笨拙的营销工具运行实验。
(00:03:04):
当我在 Airbnb 时，我最喜欢的工作内容之一就是我们的实验平台，在那里我可以按设备类型、国家、用户阶段对数据进行切片分析。Eppo 具备所有这些功能，甚至更多，它能快速交付结果，避免令人烦恼的漫长分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基础的点击率指标，转而使用你的北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。请访问 geteppo.com 查看 Eppo，即 geteppo.com，让你的实验速度提升 10 倍。

---

### [00:03:47] Lenny

**English:**
April, thank you so much for being here. Welcome back to the podcast.

**中文翻译:**
April，非常感谢你能来。欢迎回到播客。

---

### [00:03:52] April Dunford

**English:**
So great to be back. We were talking about this earlier, but it feels like it was so long ago when I did the last one. I was one of the first guests and I feel like, man, you've been running this thing forever. And that was like a year ago.

**中文翻译:**
很高兴能回来。我们刚才还在聊这个，感觉上次录节目已经是好久以前的事了。我是你最早的嘉宾之一，感觉你做这个播客已经做了很久很久了。其实也就才过了一年左右。

---

### [00:04:05] Lenny

**English:**
It feels like a lifetime, but it was about a year ago.

**中文翻译:**
感觉像过了一辈子，但确实大约是一年前。

---

### [00:04:08] April Dunford

**English:**
But what you've done with it is amazing, right? The growth in it, everything else, it's super inspirational.

**中文翻译:**
但你取得的成就太惊人了，对吧？它的增长速度，还有其他方方面面，都超级励志。

---

### [00:04:13] Lenny

**English:**
Thanks April. I appreciate that.

**中文翻译:**
谢谢 April，我很感激。

---

### [00:04:15] April Dunford

**English:**
You're welcome. It's true though. I think everybody looks at your stuff and goes, "What the heck? How does he do it?"

**中文翻译:**
不客气。这是实话。我觉得每个人看到你的成果都会想：“天呐，他是怎么做到的？”

---

### [00:04:22] Lenny

**English:**
The secret is a lot of work.

**中文翻译:**
秘诀就是大量的工作。

---

### [00:04:24] April Dunford

**English:**
Yes.

**中文翻译:**
没错。

---

### [00:04:24] Lenny

**English:**
That's the get rich quick scheme there.

**中文翻译:**
这就是所谓的“快速致富方案”。

---

### [00:04:28] April Dunford

**English:**
Nobody wants to hear that.

**中文翻译:**
没人想听这个（大实话）。

---

### [00:04:30] Lenny

**English:**
Yeah. But it's work that's extremely fulfilling and we get to chat again and you are a very rare return guest, which makes me very happy. And the reason you're back is you've written an incredible new book, which I have right here if you're on YouTube called Sales Pitch.

**中文翻译:**
是的。但这份工作非常有成就感，而且我们能再次聊天，你是一位非常罕见的返场嘉宾，这让我非常高兴。你回来的原因是，你写了一本非常棒的新书，如果你在看 YouTube 的话，书就在我手里，叫作《销售话术》（Sales Pitch）。

---

### [00:04:44] April Dunford

**English:**
That's so cool.

**中文翻译:**
太酷了。

---

### [00:04:45] Lenny

**English:**
There it is. And it's in your background, too. It's like a inception. The book is called Sales Pitch, How to Craft a Story to Stand Out and Win. And we're going to be spending our time today digging into all of the lessons and frameworks in the book as much as we can in the hour that we have. And my goal for this conversation is for listeners to leave this podcast with better skills at pitching and selling their product. Which I think every product leader and founder will want to do and get better at. How does that sound?

**中文翻译:**
就在这儿。你的背景里也有这本书，感觉像《盗梦空间》一样。书名全称是《销售话术：如何打造脱颖而出并获胜的故事》。在今天的一个小时里，我们将尽可能深入探讨书中的所有教训和框架。我希望通过这次对话，听众在离开时能掌握更好的产品推销和销售技巧。我想每一位产品领导者和创始人都希望做到这一点并不断精进。听起来怎么样？

---

### [00:05:13] April Dunford

**English:**
That sounds great.

**中文翻译:**
听起来很棒。

---

### [00:05:14] Lenny

**English:**
Okay, sweet. I was thinking as a way to get into the conversation, we start with maybe a story or an example of a company that you worked with where you applied the frameworks and lessons they teach in the book. And then use that as kind of a jumping off point for digging in further.

**中文翻译:**
太好了。我想作为切入点，我们可以先从一个故事或例子开始，讲讲你合作过的一家公司，你是如何应用书中的框架和教训的。然后以此为起点进一步深入探讨。

---

### [00:05:30] April Dunford

**English:**
Yeah, sure. So my background is, I do positioning work. And so in the work that I do with clients, generally what we're working on is a shift in the positioning, which is a little bit of a shift in our thinking around, how do we win in the market? So in order to test that positioning, what we want to do is take the positioning and translate it into a sales pitch and then test it live with prospects.
(00:05:53):
And one of the things I noticed right at the beginning of doing this work is that everybody's sales pitch kind of looked the same and they weren't all that great. And for the most part what was happening in the sales pitch is there was no positioning going on in the sales pitch at all. The sales pitch was essentially a product exposition, so essentially a glorified product box room. If there was five dropdown menus, we're going to click on all five dropdown menus and show everybody everything just feature, feature, feature, feature, feature.
(00:06:24):
And so, most of the teams weren't used to doing any kind of pitching in the pitch really. It was just the facts Jack, were just going to show you that. Some would do this really lightweight thing. Here's the problem, we're the solution. Now let me walk you through all the dropdown menus, but it is basically the same thing like that.
(00:06:43):
And so what I wanted to do was build a pitch structure that would reflect the positioning. And so in order to do that, we have to get a little bit into storytelling mode. Not a lot, but at least a little. And when we're talking about features, we shouldn't be talking about features. We should be talking about the value that the features deliver.
(00:07:01):
So let me give you an example and I'll do before and after what this would look like. So I work with these folks, Help Scout, and so they're in the customer service space, so think Zendesk or whatever. They're in that space. And what's interesting about them is they were built from the ground up to serve digital businesses. So businesses that don't have a physical store, they don't have sales reps. And so their approach to customer service was different from the outset. Help Scout said, "Well, you know what? Customer service for that kind of business is really important. It's the only time you ever get to interact with actual customers." And so the data shows that if you give them a really great interaction in service, it improves loyalty, it improves repeat purchases, and it's actually a growth driver. Now, most folks in other industries see customer service as a cost center.
(00:07:49):
So your telephone company for example, wants to get you off the phone as fast as possible. And they want to push you to the self-serve FAQ channels, and they don't care about giving you a good service at all. They don't care about any of that. And so they're all about driving the cost down. So if we look at Help Scout in their positioning, the alternatives to Help Scout are a handful of things. Most folks start using a shared inbox and it's really easy to use and the reps love it. It's easy to use. The problem is, is you start growing and then you want customer service features. You want to be able to do assignments and prioritization and things like that. So then these customers end up upgrading to help desk software and now they're in this whole different world.
(00:08:31):
So the first thing is really hard to use. So we're not in shared inbox territory anymore. And the second thing is that there's this attitude of we're trying to push folks to low cost channels. We don't really care about them. We're going to assign you a ticket number. You're not a person anymore. All this stuff. So that's the situation. So Help Scout, if they did a typical pitch the way I see most SaaS companies pitch, they would just expose the features. Right? So the pitch would look like this. Digital business comes in and they say, "Hi, Help Scout, let me show you how to log in, let me show you all the features. Look, there's a shared inbox thing there that's really great. Oh, look, we can do assignments and prioritization and we can do this other thing and we can do this other thing and la, la la." And I keep going until the time runs out and I don't have any more features to talk about.
(00:09:20):
The problem with that pitch is the customer's sitting there going, "I don't know, man, that sounds a little bit like my shared inbox, but it also sounds like help desk software. Is it different than help desk software? I'm not so sure. And there's overlap in the features there." And so it doesn't really answer the question, why pick us over the other guys?
(00:09:42):
And so a different style of pitch would be one, we would do a little bit of setup to give everybody an idea about how we fit amongst all the other solutions and what our point of view is in the market. And then when we get to exploring the features, we would do that within the context of the differentiated value. So here's how that pitch would look like. Customer comes in and Help Scout says, "Hey, digital business, we work with a lot of companies like you, and I'm going to show you the product. But before we get there, one of the things we think is interesting is that digital businesses look at customer service differently. They look at it as a growth driver rather than a cost center. And so most of the folks we work with see delivering a really amazing experience as a key part of customer service. Would you agree with that?"
(00:10:26):
Yeah, we would. They have a little conversation and then they say, "Great. We you have choices here. So most of the folks we work with start with a shared inbox, and that's great because it's really easy, really easy to use all that stuff. The problem is if you're growing and you probably are, then you're going to outgrow that because you're going to need prioritizations assignments, help desk stuff.
(00:10:45):
And so then your option is to go to help desk software. And so help desk software is great, does all the things. The problem is that it was not designed for businesses like you. It was designed for businesses that want to take the cost out of customer service. So it's going to do some things that are weird. It's going assign your customers a ticket number and it's going to try to drive them to low cost channels. So can we agree that in a perfect world for digital business like yours, we'd want something as easy to use as a help desk, but had all the bells and whistles so we wouldn't have to migrate to something else. And on top of that was built from the ground up to deliver amazing customer service. Do we agree we want that?"
(00:11:26):
Now, at that point, the customer is either with you or you're not. But if they are, then we switch to the actual demo part. If we do a demo and then we say, "Great, we've got those three things. Let me show you how that works. So one as easy to use an inbox. Look, here's the inbox. It's easy to use. Looks just like an inbox. It's amazing. Two, features, so you never have to outgrow it. Look, here's how we do prioritizations assignments, whatever. We can do all the stuff you need as you grow, and you're never going to have to switch platforms. And then last one, deliver an amazing experience. Look, the customer gets to choose which channel that they interact with you with. And look, they get to stay Dave and not ticket number 1479."
(00:12:02):
That sort of thing. So that's how the pitch looks in the after. But that's a really different pitch. That pitch is designed to answer the question, "Why pick us over the other folks?" And so as you might imagine, it is a lot more effective at actually getting clients to get their head around, what is this thing? Why is it different? Why should I pick you? And it just works way better in a sales situation.

**中文翻译:**
好的，没问题。我的背景是做定位工作的。在我与客户合作的过程中，通常我们处理的是定位的转变，这实际上是转变我们关于“如何在市场中获胜”的思维。为了测试这种定位，我们要做的就是将定位转化为销售话术，然后与潜在客户进行实战测试。
(00:05:53):
在刚开始做这项工作时，我注意到一个现象：每个人的销售话术看起来都大同小异，而且效果并不理想。大部分情况下，销售话术中根本没有体现出“定位”。销售话术本质上变成了产品展示，就像是一个华丽的产品陈列室。如果有五个下拉菜单，我们就点击所有五个下拉菜单，向大家展示每一个功能，全是功能、功能、功能。
(00:06:24):
所以，大多数团队并不习惯在话术中真正进行“推销”。他们只是陈述事实，展示产品。有些会做一些很浅层的引导：“这是问题，我们是解决方案。现在让我带你看一下所有的下拉菜单。” 但本质上还是一样的。
(00:06:43):
因此，我想构建一个能够反映定位的话术结构。为了做到这一点，我们需要进入一点“讲故事”模式。不需要太多，但至少要有一点。当我们谈论功能时，我们不应该只谈论功能本身，而应该谈论功能所交付的“价值”。
(00:07:01):
让我给你举个例子，对比一下“之前”和“之后”的样子。我曾与 Help Scout 合作，他们属于客户服务领域，就像 Zendesk 那样。有趣的是，他们从一开始就是为“数字业务”（digital businesses）设计的。这类业务没有实体店，也没有销售代表。因此，他们从一开始对客户服务的理解就不同。Help Scout 认为：“对于这类业务，客户服务至关重要。这是你唯一能与真实客户互动的机会。” 数据显示，如果你在服务中提供极佳的互动，就能提高忠诚度、增加重复购买，它实际上是增长的驱动力。而大多数其他行业的公司将客户服务视为“成本中心”。
(00:07:49):
比如你的电话公司，他们想让你尽快挂断电话。他们想把你推向自助服务的常见问题解答（FAQ）频道，他们根本不在乎提供好服务，只在乎降低成本。所以如果我们看 Help Scout 的定位，他们的替代方案有几种。大多数人开始使用“共享收件箱”，它非常易用，客服代表很喜欢。但问题是，随着业务增长，你需要客服功能，比如任务分配、优先级排序等。于是这些客户会升级到“服务台软件”（help desk software），进入了一个完全不同的世界。
(00:08:31):
首先，这类软件非常难用，不再像共享收件箱那样简单。其次，它的态度是尽量把人推向低成本渠道。他们不在乎客户，会给你分配一个工单号，你不再是一个活生生的人，而是一个数字。这就是现状。如果 Help Scout 采用典型的 SaaS 公司推销方式，他们只会展示功能。话术会是这样的：数字业务客户来了，他们说：“你好，Help Scout，让我展示一下如何登录，展示一下所有功能。看，这里有一个共享收件箱，非常好用。哦看，我们可以做分配和优先级排序，还可以做这个做那个，啦啦啦。” 一直讲到时间耗尽，没功能可讲为止。
(00:09:20):
这种话术的问题在于，客户坐在那儿会想：“我不知道，这听起来有点像我的共享收件箱，但也像服务台软件。它和服务台软件有区别吗？我不确定。功能上有很多重叠。” 它并没有回答那个核心问题：为什么要选你们而不是别人？
(00:09:42):
而另一种风格的话术会是这样的：首先，我们会做一些铺垫（setup），让大家了解我们在所有解决方案中处于什么位置，以及我们在市场中的观点是什么。然后，当我们探索功能时，我们会将其置于“差异化价值”的语境中。话术会变成这样：客户来了，Help Scout 说：“嘿，数字业务的朋友，我们和很多像你们这样的公司合作。我会给你们展示产品，但在那之前，我们发现一件有趣的事：数字业务对客户服务的看法不同。他们将其视为增长驱动力，而非成本中心。因此，我们合作的大多数人都认为提供惊人的体验是客户服务的核心。你同意吗？”
(00:10:26):
客户说：“是的，我们同意。” 接着进行简短交流，然后说：“太好了。你在这里有几种选择。大多数人从共享收件箱开始，这很好，因为它非常简单易用。但问题是，如果你在增长（你可能确实在增长），你很快就会不够用，因为你需要优先级、分配等服务台功能。
(00:10:45):
所以你的选择是转向服务台软件。服务台软件很好，功能全。但问题是，它不是为你们这样的公司设计的。它是为那些想要削减客服成本的公司设计的。所以它会做一些奇怪的事：给你的客户分配一个工单号，并尝试把他们赶到低成本渠道。那么，我们是否可以达成共识：在理想世界里，对于像你们这样的数字业务，我们需要一种像收件箱一样简单，但又具备所有高级功能、无需迁移到其他平台，并且从底层逻辑上就是为了提供惊人服务而构建的工具。我们同意需要这样的东西吗？”
(00:11:26):
到这一步，客户要么认同你，要么不认同。如果认同，我们就转入实际的演示部分。我们说：“太好了，我们具备这三点。让我展示一下它是如何工作的。第一，像收件箱一样易用。看，这就是收件箱，看起来一模一样，太棒了。第二，功能齐全，无需更换。看，这就是我们如何做优先级和分配的，随着你的成长，你永远不需要切换平台。第三，提供惊人体验。看，客户可以自由选择互动渠道。而且，他们始终是‘Dave’，而不是‘1479 号工单’。”
(00:12:02):
就是这种感觉。这就是“之后”的话术。这是一个完全不同的话术。它的设计初衷就是为了回答：“为什么要选我们而不是别人？” 正如你所料，这种方式在让客户理解“这是什么、有什么不同、为什么要选你”方面要有效得多，在销售实战中表现也更好。

---

### [00:12:22] Lenny

**English:**
Awesome. So just to maybe summarize the framework 'cause you went through each of these pieces, and I think it might be helpful to give people the kind of steps. And I have them here, but maybe it might be better for you to kind work through.

**中文翻译:**
太棒了。为了总结一下这个框架，因为你刚才提到了每一个部分，我觉得给听众列出具体的步骤会很有帮助。我这里有记录，但也许由你来梳理会更好。

---

### [00:12:33] April Dunford

**English:**
So you can think of it is... So first of all, the pitch structure has two big pieces. So the first is the setup. The setup piece is not about us, it's about the market, our point of view on the market. The second bit is all about our differentiated value. So why pick us over the other guys? So those pieces aren't equal. In a normal sales pitch situation, we don't want to spend all day in the setup part. We want to get to the meat, which is our differentiated value, but we can't skip that bit. So if I've got a half hour call or a 45-minute call, maybe I spend a few minutes on this upfront, this upfront stuff is really important though.
(00:13:12):
And we could break the upfront into three pieces. So it starts with our insight into the market. So you can think of this as our point of view on the market or kind of like the problem inside the problem, in some ways. So in Help Scout's case, the insight is, " Hey, customer service is just different for digital businesses, and this is really a growth driver, not a cost center. So we need to think about customer service in a different way." That's their insight. So we start with that.
(00:13:41):
The second piece is pluses and minuses of alternative solutions. What we want to do is paint a picture of the entire market and talk about what's good and bad of the other ways of approaching the job. And then out of that conversation, we have a conclusion, which is what I call perfect world. But just kind of like can we agree that if we really wanted to solve this problem and knowing what works and doesn't work in the alternate solutions, can we agree really good solutions should tick these boxes? This is getting the customer aligned with your worldview.
(00:14:14):
If they're aligned, then we switch to the follow through. The follow through has a handful of steps, but the main step is this differentiated value step. So usually what we'd start with is an introduction. "Hey, we're Help Scout. We do customer service stuff specifically for digital businesses." And then we would move on to, "Here's the value we deliver. Here's how we do it. Here's the value we deliver. Here's how we do it. Here's the value we deliver. Here's how we do it."
(00:14:37):
We generally end the sales pitch with a couple of little steps. So one is after we talk about the value, generally there's a step for proof, which is how can we prove that we do what we say we could do. Which is often a customer case study or it might be independent third party verification on stuff. But usually there's a proof step. There's an optional step after that, which is handling objections that haven't come up during the call. So sometimes we'll have a silent objection, "Yeah, that sounds really good, but it sounds really hard to adopt." Or, "Yeah, that sounds really good, but it's probably pretty expensive." Or, "Yeah, that's okay, but it probably doesn't meet our needs for security or whatever."
(00:15:15):
And so we handle that at the end in this special objection step. And then we end the pitch with what I call the ask, which is whatever we want the customer to do next. So it could be just asking for the sale or it could be, "Hey, we want to do a proof of concept. Who do we need to talk to about that?" Or, "Hey, we're going to do a project. Who needs to be involved in defining the project?" Whatever the next step is in your sales process. That's how we end is with dask.

**中文翻译:**
你可以这样理解……首先，话术结构分为两大块。第一块是“铺垫”（Setup）。铺垫部分不是关于我们的，而是关于市场，以及我们对市场的观点。第二块则是关于我们的“差异化价值”（Differentiated Value），即为什么要选我们而不是别人。这两部分的比例是不对等的。在正常的销售场景中，我们不想整天耗在铺垫部分，我们想尽快进入核心内容，也就是差异化价值。但铺垫部分不能跳过。如果我有半小时或 45 分钟的通话，我可能会花几分钟在前面的铺垫上，这非常关键。
(00:13:12):
我们可以把铺垫分为三个部分。首先是我们的“市场洞察”（Insight）。你可以把它看作我们对市场的观点，或者某种程度上是“问题背后的问题”。以 Help Scout 为例，他们的洞察是：“嘿，数字业务的客户服务就是不一样的，它其实是增长驱动力，而不是成本中心。所以我们需要换个方式思考客户服务。” 这就是他们的洞察，我们从这里开始。
(00:13:41):
第二部分是“替代方案的优缺点”。我们要描绘整个市场的全景，讨论解决这个问题的其他方式有哪些好与坏。然后从这段对话中得出一个结论，我称之为“理想世界”（Perfect World）。基本上就是说：“既然我们想解决这个问题，也知道了其他方案的优劣，我们是否同意，一个真正好的解决方案应该满足这些条件？” 这是为了让客户认同你的世界观。
(00:14:14):
如果他们认同了，我们就转入“后续跟进”（Follow Through）。后续跟进有几个步骤，但核心是“差异化价值”。通常我们会先做一个自我介绍：“嘿，我们是 Help Scout，我们专门为数字业务提供客户服务工具。” 然后进入：“这是我们提供的价值，我们是这样实现的；这是另一个价值，我们是这样实现的……”
(00:14:37):
销售话术通常以几个小步骤结束。第一，在谈完价值后，通常有一个“证明”（Proof）环节，即我们如何证明自己能说到做到。这通常是客户案例研究，或者是独立的第三方验证。通常必须有证明环节。之后是一个可选步骤，即处理通话中尚未出现的“异议”（Objections）。有时会有“沉默的异议”，比如客户心里想：“听起来不错，但感觉很难上手。” 或者 “听起来不错，但可能很贵。” 或者 “还行，但可能不符合我们的安全要求。”
(01:15:15):
所以我们在最后这个专门的异议处理环节来解决这些问题。最后，我们以我所说的“请求”（The Ask）结束话术，也就是我们希望客户下一步做什么。可以是直接要求下单，也可以是：“嘿，我们想做一个概念验证（POC），我们需要和谁谈谈？” 或者 “我们要启动一个项目，谁需要参与项目定义？” 无论你的销售流程中下一步是什么，这就是结尾的“请求”。

---

### [00:15:44] Lenny

**English:**
Cool. I wanted to actually talk about objections. 'Cause I imagine going through this, companies often don't agree with what you're saying, and I wonder how you handle that. So you're going in this, do you agree? And yeah, the silent objection is really interesting. I don't even think about that, where they're just like, "Yeah, yeah, yeah, we agree." But they don't really agree. How would you suggest people handle them being like, "No, I don't actually see the world that way." Or the silent objection, which I guess is something you save for the end.

**中文翻译:**
太酷了。我想聊聊“异议”。因为我能想象，在进行这个流程时，公司往往并不完全同意你所说的，我想知道你如何处理这种情况。当你问“你同意吗？”时，那种“沉默的异议”非常有趣。我以前甚至没想过这一点，就是他们嘴上说“对对对，我们同意”，但心里其实并不认同。如果对方直接说“不，我其实不这么看世界”，或者面对那种你留在最后处理的“沉默异议”，你建议大家怎么处理？

---

### [00:16:09] April Dunford

**English:**
Typically when we're starting with insight, our insight into the market, if we're doing this well, the insight is generally not all that controversial. So you could think of it this way. So it's kind of the reason you built what you built. So most founders, when you talk to them, they didn't just come up with the idea out of nowhere. They woke up in the morning and said, "You know what sucks about email, this thing sucks about email. And so I'm going to build this different kind of email that solves that problem." Or in the case of Help Scout, it's like, do you know what sucks about customer service? It just wasn't built for these kinds of businesses.
(00:16:44):
And so if you've got a point of view on the world and you're talking to a customer that just fundamentally doesn't agree with that... In the case of a Help Scout, they come in and they say, "No, actually it's a cost center for us. We're just trying to get the cost down." They should disqualify that deal because they can't serve that customer better than Zendesk does. Zendesk is going to win that deal. But if you've done this properly, your insight should resonate for the target account that you're trying to go after. Now, that doesn't mean there aren't going to be other objections, and usually there's all kinds of other objections. But the objections are more on a level of, if I can get you hooked at the beginning in this setup, then we go to the value, which is just proving I can do what we already agreed we wanted to get done. Then the objections tend to be more like operational stuff. "Yeah, this sounds good, but I don't know if we can forward it." Or "This sounds good, but boy, we're going to have to migrate off the old thing or whatever."
(00:17:40):
So mentally they're kind of sold already, but they're worried about, "Well, what's IT going to say? And can I actually get budget about this?" And in B2B, we've got this network of people that we've got to go get agreement from to move forward on this thing. And so often there's objections around that. The beginning of the sales pitch thing... One more thing on that is that part of what we're doing in that setup is what salespeople would call discovery. And so that setup part should not be me talking at you. It should be a conversation between me and the client saying, "Do you agree with this? Is this what you're seeing? Did you start with a shared inbox? What are you doing right now? Did you ever consider using help desk software? Why yes, why no? Do you have any constraints on what you're looking at? What have you tried before? What are you looking at trying right now?"
(00:18:31):
This is part of the discovery that we do in a first substantive sales call that your sales reps would know how to do this. Typically, one of the things we don't have in the pitch decks that I see in SaaS companies is there's no good place to do this discovery. So it kind of happens outside of the structure of the pitch. In this pitch structure, there's a definite spot for discovery. So by the time we get to the end of the setup, we should either be aligned like, "Yep, this looks like a good prospect for us. Yep, we can do something. Yep, they got a problem we can solve. This all looks good." Or we kind of jointly come to the conclusion, "Hey, this just... Our stuff just ain't for you, man." And that's it.

**中文翻译:**
通常当我们从“洞察”开始时，如果我们做得好，这个市场洞察通常不会有太大争议。你可以这样想：这其实就是你开发这个产品的初衷。大多数创始人并不是凭空想出主意的。他们早上醒来会想：“你知道电子邮件哪里烂吗？这一点最烂。所以我要做一种不同的邮件来解决这个问题。” 或者像 Help Scout 的例子：“你知道客户服务哪里烂吗？它根本不是为这类公司设计的。”
(00:16:44):
所以，如果你有一个世界观，而你面对的客户根本不认同……比如 Help Scout 遇到一个客户说：“不，对我们来说它就是个成本中心，我们只想省钱。” 那么 Help Scout 应该直接放弃（disqualify）这笔交易，因为他们不可能比 Zendesk 服务得更好，Zendesk 肯定会赢。但如果你做得对，你的洞察应该能引起目标客户的共鸣。当然，这并不意味着没有其他异议，通常会有各种各样的异议。但如果我能在开头的铺垫部分吸引住你，然后进入价值展示（证明我能做到我们达成共识的目标），那么剩下的异议往往是操作层面的。比如：“听起来不错，但我不知道能不能报销。” 或者 “听起来不错，但天呐，我们得从旧系统迁移过来，太麻烦了。”
(00:17:40):
所以从心理上讲，他们已经基本被说服了，但他们担心：“IT 部门会怎么说？我真的能申请到预算吗？” 在 B2B 领域，我们需要获得一整群人的同意才能推进。所以经常会有这类异议。关于销售话术的开头……还有一点，我们在铺垫部分所做的，其实就是销售人员所说的“需求挖掘”（Discovery）。铺垫部分不应该是我一个人在说，而应该是和我与客户之间的对话：“你同意这一点吗？这是你看到的情况吗？你是从共享收件箱开始的吗？你现在是怎么做的？你考虑过服务台软件吗？为什么考虑，或者为什么不考虑？你有什么限制条件吗？你以前尝试过什么？你现在打算尝试什么？”
(00:18:31):
这是我们在第一次实质性销售电话中进行的“需求挖掘”的一部分，你的销售代表应该知道怎么做。通常，我在 SaaS 公司看到的演示文稿（pitch decks）中，没有一个合适的地方来进行这种挖掘，所以它往往脱离了话术结构。但在我这个结构中，有一个明确的位置留给需求挖掘。所以到铺垫部分结束时，我们要么达成一致：“是的，这是一个优质潜在客户，我们可以提供帮助，他们有问题我们可以解决，一切看起来都不错。” 要么我们共同得出结论：“嘿，我们的东西真的不适合你。” 这样也就结束了。

---

### [00:19:13] Lenny

**English:**
I mentioned a lot of this comes from doing this enough times. You get to understand where people generally agree, this is a problem. We all know this is our problem. And it's unlikely that you're going to have to throw everything out because someone just decides, "No, this isn't for us."
(00:19:29):
I think one of the biggest shift maybe from this framework is that you go into a teaching mindset. It's not just like, "Here's our product, it's going to solve your problem." It's more, "Here's what's happening broadly. Maybe you don't have the time to do the research we've done. Here's what we found." And then that builds trust, I think in you as a company and as a leader, a salesperson. And then they're like, "Okay, see, they see the world the way we do." Or, "I've just realized something new. I never thought of it that way." And then, "Okay, cool. How do they think about the solution to this?"

**中文翻译:**
我提到过，这很大程度上源于多次实践。你会逐渐明白大家普遍认同的问题在哪里。我们都知道这是我们的痛点。你不太可能因为某人决定“不，这不适合我们”就得推翻一切。
(00:19:29):
我认为这个框架带来的最大转变之一是，你进入了一种“教学心态”（teaching mindset）。不再只是说“这是我们的产品，它能解决你的问题”，而是说“这是目前的大趋势。也许你没时间像我们这样深入研究，这是我们的发现。” 我认为这能建立起对公司、对领导者或销售人员的信任。然后客户会觉得：“好吧，他们看世界的方式和我们一样。” 或者 “我刚发现了一些新东西，以前从没这么想过。” 接着他们会想：“太酷了，那他们是怎么考虑解决方案的呢？”

---

### [00:19:57] April Dunford

**English:**
Right. One of the key things to think about in all of this stuff that I think we don't think about enough as software vendors is that customers will come to us and they've done their homework. They've Googled around and they've looked at stuff, but that doesn't mean they have perfect understanding of the market. In fact, it's usually far from it. If we think about it, most of the folks in B2B software, most of the time, your buyer has never purchased software like yours before. This is the first time they've done it. And their bosses come to them and said, "Hey, figure this out. Go find us a CRM and look at all the CRMs and figure it out."
(00:20:33):
And the buyers looking at it going, "Geez, I don't know, man. There's a lot of CRMs out there, and I'm looking at all the things. I'm on G2 Crowd and there's 24 CRMs in the top right corner. And I'm looking at Gardner Group and I'm looking at this thing and I'm actually doing my research, but I'm overwhelmed. What I don't have is a clear picture of the market. What are the different approaches to this problem? Forget about products. What are the approaches to the problem? Where do the products fit in those approaches? What's a good solution for me look like? What should be my purchase criteria?" That's really hard for buyers to figure out.
(00:21:10):
And in general, in a sales process, we're not doing anything to help the buyer figure that out, even though we know it. We eat, sleep and breathe this market. We spend all day looking at competitors and thinking about this stuff and whatever. But we've got this idea, "Well, we shouldn't do this because first of all, we can't talk about the other guys that we'd be seen as bashing our competition, and that's bad." The other thing is, even if we did give our opinion, nobody would trust us because we're biased. But if you look at the research on this stuff, the research doesn't support that. The research actually says what B2B software buyers want in a sales interaction is perspectives on the market and help weighing their options. And we don't do that. We're just like, "Here's our stuff. You figure it out, it's up to you. You figure it out."
(00:22:03):
And so as a result, what we get are these buyers come in, they're overwhelmed with all this information. They come in and they sit in our sales process, and we overwhelm them even more with more features and more information. And what they're really worried about is, "What if I make a bad choice here? I've never done this before and I'm going to have to recommend to my boss. And if I make the wrong suggestion to my boss, maybe my boss thinks I'm stupid. Or maybe I buy something and the whole department hates me because awful to use. Or maybe I pick something and it's just bad software and then bad things happen for the business, maybe I get fired."
(00:22:40):
And so the data on this shows that for B2B, 40 to 60% of B2B purchase processes end in no decision. And then when you look at, if you scratch on that data, the majority of those aren't saying, "Well, I'm not making a decision to buy something new because the old thing we were doing is better." That's not true at all. In fact, the majority of the...

**中文翻译:**
没错。作为软件供应商，我们经常忽略的一点是：客户来找我们时确实做了功课，他们搜过 Google，看过资料，但这并不意味着他们对市场有完美的理解。事实上，通常差得远。想想看，在 B2B 软件领域，大多数时候你的买家以前从未购买过像你这样的软件。这是他们第一次买。老板对他们说：“嘿，把这事搞定。去给我们找个 CRM，把市面上所有的 CRM 都看一遍，然后拿个方案。”
(00:20:33):
买家看着这些东西会想：“天呐，我不知道，市面上有这么多 CRM。我看了 G2 Crowd，右上角就有 24 个 CRM。我看了 Gartner 的报告，我确实在做研究，但我快崩溃了。我缺乏的是对市场的清晰全景图。解决这个问题有哪些不同的‘路径’？先别管产品，路径有哪些？产品在这些路径中处于什么位置？对我来说好的解决方案长什么样？我的采购标准应该是什么？” 这些对买家来说非常难搞清楚。
(00:21:10):
通常在销售过程中，我们并没有做任何事情来帮助买家理清这些，尽管我们对此了如指掌。我们在这个市场里摸爬滚打，整天研究竞争对手。但我们总有一种想法：“我们不该谈论别人，因为那会被视为抨击竞争对手，这不好。” 另一种想法是：“即使我们给出了意见，也没人会相信，因为我们是有偏见的。” 但如果你看相关的研究，研究结果并不支持这种观点。研究表明，B2B 软件买家在销售互动中真正想要的是对市场的看法，以及帮助他们权衡各种选择。而我们却没做这些，我们只是说：“这是我们的东西，你自己看着办吧。”
(00:22:03):
结果就是，买家带着满脑子混乱的信息进来，坐在我们的销售流程里，而我们又用更多的功能和信息让他们更加不知所措。他们真正担心的是：“如果我选错了怎么办？我以前没做过这个，我得向老板汇报。如果我给了错误的建议，老板可能会觉得我很蠢。或者我买了个东西，结果全部门都因为难用而讨厌我。或者我选了个烂软件，导致公司业务受损，我甚至可能被解雇。”
(00:22:40):
数据表明，在 B2B 领域，40% 到 60% 的采购流程最终以“无决策”告终。如果你深入挖掘这些数据，你会发现其中大多数人并不是在说：“我不买新的是因为旧的更好。” 事实并非如此。事实上，大多数……

---

### [00:23:00] April Dunford

**English:**
The old thing we were doing is better, that's not true at all. In fact, the majority of those is they couldn't figure out how to make a choice confidently. So what they did was they just went to their boss and said, "You know what? Now's not a good time. Let's not do it now. Let's do it next year. Let's just delay it," because that is the safe risk-free thing for that person who's on the hook to make the decision to do.

**中文翻译:**
（接上文）……并不是因为旧的更好。事实上，绝大多数情况是因为他们无法自信地做出选择。所以他们采取的行动就是去找老板说：“你知道吗？现在不是个好时机。我们现在先别做了，明年再说吧。咱们推迟一下。” 因为对于那个负责做决策的人来说，这样做才是最安全、无风险的选择。

---

### [00:23:23] Lenny

**English:**
I think this is one of the most interesting insights that you share in your book and you also share this in the newsletter post about how buying software you could argue is harder than selling it because people will have learned there's skills and training for selling, but buying is, as you described, extremely stressful. Basically your job's on the line if you make a mistake. Is there anything more you can share along those lines just to help reinforce that buying software is extremely hard and stressful and people don't understand that?

**中文翻译:**
我认为这是你在书里分享的最有趣的见解之一，你在那篇通讯文章里也提到了：你可以说购买软件比销售软件更难。因为销售是有技巧和培训的，但购买过程正如你所描述的，压力极大。基本上，如果你犯了错，你的饭碗可能就不保了。关于这一点，你还能分享更多吗？以此来强化“购买软件极其困难且压力巨大，而人们往往不理解这一点”这个观点。

---

### [00:23:50] April Dunford

**English:**
Once you get into that mindset, I think then you look at the situation a lot different. I think we've seen the statistics on this that says the buyer is 80% of the way through their buying journey by the time they talk to your sales rep. Yeah, maybe, but they might be 80% of the way to saying, "Nope, I'm not buying nothing." And in fact that's true 60% of the time. And so how do we combat that? The way we combat that is not just talking about ourselves, it's actually about trying to be helpful to that person in this very stressful situation that is trying to figure out how do I make a really good decision.
(00:24:27):
So what we should be doing is giving them a way to think about the whole market and say, in the case of Help Scout, "Look, there's shared inbox and then there's help desk software and then there's us. And I don't care who the vendor is, I'm going to put them in one of those buckets." And so you can just think of it that way. So you don't need to know every single feature, every single thing. I'm giving you a bigger picture of the whole market and helping you feel good. Well, if you choose this or you choose that, now you know why.

**中文翻译:**
一旦你进入这种思维模式，你看待情况的方式就会大不相同。我们都看过这样的统计数据：当买家联系你的销售代表时，他们已经完成了 80% 的购买旅程。是的，也许吧，但他们也可能是完成了 80% 的“决定不买任何东西”的旅程。事实上，60% 的情况都是这样。那我们该如何应对呢？应对的方法不仅仅是谈论我们自己，而是尝试在这个压力巨大的时刻去帮助那个人，帮他理清如何做出一个真正好的决策。
(00:24:27):
所以我们应该做的是给他们一种思考整个市场的方式。以 Help Scout 为例，我们可以说：“看，市场上有共享收件箱，有服务台软件，还有我们。不管供应商是谁，我都会把他们归入这几个类别之一。” 你可以就这样去思考。你不需要了解每一个功能、每一件事。我是在给你一个市场的全景图，帮你建立信心。这样，无论你选择这个还是那个，你都知道原因了。

---

### [00:24:57] Lenny

**English:**
I think what's interesting about this is a lot of startups fail because they can't convince anyone to switch from the status quo. And I think people always think of that as the current product is good enough and that's why they're losing, but I think this adds an additional wrinkle of it's also the person buying it is just like, "I don't want to add the stress to even decide and make the choice and put my butt on the line to switch." And I never thought of it that way.

**中文翻译:**
我觉得有趣的是，很多初创公司失败是因为他们无法说服任何人放弃“现状”（status quo）。人们总认为失败是因为现有的产品已经足够好了，但我觉得这增加了一个新的维度：购买者其实是在想，“我不想增加压力去权衡和做决定，更不想为了切换系统而拿自己的前途冒险。” 我以前从未从这个角度想过。

---

### [00:25:22] April Dunford

**English:**
I think that hurdle is a lot more than you think. So we obviously have to compete with status quo, we can't ignore status quo, because sometimes status quo just is good enough and so we can't ignore that. We still lose deals to status quo, but we lose an awful lot of deals to just plain customer indecision, customers being more afraid of screwing up than missing out.

**中文翻译:**
我认为这个障碍比你想象的要大得多。显然我们必须与现状竞争，不能忽视它，因为有时现状确实足够好。我们确实会因为现状而丢掉订单，但我们也因为客户的“犹豫不决”而丢掉了大量的订单——客户比起担心“错过机会”（missing out），更担心“搞砸事情”（screwing up）。

---

### [00:25:46] Lenny

**English:**
So to try to overcome that, to drill into the things you find most powerful, one is help the customer understand the bigger picture and why essentially they're falling behind, why maybe competition is going to have an advantage because they're thinking in a different way.

**中文翻译:**
所以为了克服这一点，深入探讨你认为最有效的方法：一是帮助客户理解大局，以及为什么他们本质上正在落后，为什么竞争对手可能会因为思维方式的不同而占据优势。

---

### [00:26:04] April Dunford

**English:**
Well, I'll throw something out about that.

**中文翻译:**
关于这一点，我想提一些不同的看法。

---

### [00:26:06] Lenny

**English:**
Please.

**中文翻译:**
请讲。

---

### [00:26:10] April Dunford

**English:**
And I've heard people talk about this a lot that one of the things we could do in this situation when a customer is feeling this indecision is to lean into this FOMO and say, "Look, you're missing out. The competitors are all doing it and you're not doing it." And so this is an interesting question. And so I was super excited, Matt Dixon wrote this book called The JOLT Effect, and in that they studied two and a half million sales calls, they recorded on Gong and they studied it with AI, and then they looked at what happened after the sales call, so were these successful or not successful, did a deal happen or whatever. It's pretty rare that we get a chance to dig into some data like this.
(00:26:49):
And so what his data showed is if a customer is indecisive, throwing FOMO into the mix makes it worse. So they're less likely to close the deal if you throw that in. And the idea is that they're already stressed out and you're just putting more stress on them by pressuring them, by saying, "Oh, this is happening, bad things are going to..." You're like, "Bad things will happen if I do something, bad things happen if I don't do something, what do I do?"

**中文翻译:**
我经常听人说，当客户犹豫不决时，我们可以利用 FOMO（错失恐惧症），说：“看，你正在错过机会，你的竞争对手都在做，而你没做。” 这是一个很有趣的问题。我当时非常兴奋，因为 Matt Dixon 写了一本叫《JOLT 效应》（The JOLT Effect）的书。他们在书中研究了 250 万个录制在 Gong 上的销售电话，并用 AI 进行了分析，然后观察销售电话后的结果：是否成功，是否成交。我们很少有机会能深入研究这样的数据。
(00:26:49):
他的数据表明：如果客户处于犹豫不决的状态，加入 FOMO 反而会让情况变得更糟。如果你加入 FOMO，成交的可能性反而会降低。原因在于他们已经压力很大了，你通过施压只会增加他们的压力，比如你说：“哦，大趋势正在发生，坏事要降临了……” 客户会想：“如果我做了，会有坏事；如果我不做，也会有坏事。我到底该怎么办？”

---

### [00:27:22] Lenny

**English:**
They just put their head in the sand, right? They're just like, "Ah, forget it."?

**中文翻译:**
他们就会像鸵鸟一样把头埋进沙子里，对吧？他们会想：“啊，算了，不管了。”

---

### [00:27:24] April Dunford

**English:**
So they're just like, "Forget it, I'm doing nothing. Now I'm totally paralyzed." And so there's an assumption that companies are very motivated by this FOMO thing, but I think that that is not always true, and if the customer is actually indecisive, throwing in this FOMO thing isn't going to do it. So what does work in that situation is, one, giving them the tools to make the decision. So that includes paint the picture of the market, teaching them how to buy essentially. So teaching them, look, for customers like you, you just have to worry about these three, four things, and all this other stuff, it doesn't apply to you. That applies to bigger companies, that applies to whatever, so this idea of teaching a customer how to buy is one way to take that stress down.
(00:28:08):
And then there's a whole bunch of other techniques you can use. So one is if it's a really big deal, we can split it into smaller pieces, we can do things like offer you a money back guarantee, we can do things like sometimes we have services and support that are going to help you if things go bad and this is how we're going to make sure. So this idea of being able to take risk off the table is a really serious one if we've got a customer that is actually paralyzed because of this indecision thing.

**中文翻译:**
没错，他们会想：“算了，我什么都不做。现在我彻底瘫痪了。” 人们总假设公司会被 FOMO 驱动，但我认为这并不总是真的。如果客户真的很犹豫，扔出 FOMO 是没用的。在这种情况下，真正有效的是：第一，给他们做出决策的工具。这包括描绘市场全景，本质上是“教他们如何购买”。教导他们：“看，对于像你们这样的客户，你只需要担心这三四件事，其他所有的东西都不适用于你。那些是给大公司用的，或者给其他情况用的。” 这种教客户如何购买的理念是减轻压力的一种方式。
(00:28:08):
此外还有很多其他技巧。比如，如果这是一笔大交易，我们可以把它拆成小块；我们可以提供退款保证；我们可以提供服务和支持，承诺如果出问题我们会如何协助。如果客户因为犹豫而陷入瘫痪，这种“消除风险”的思路是非常严肃且有效的。

---

### [00:28:36] Lenny

**English:**
That makes a lot of sense, basically it's like how do we help the buyer cover their ass if they made a mistake, because what you're saying is that's the main reason they're not buying your product.

**中文翻译:**
这很有道理。基本上就是：我们如何帮助买家在犯错时“保住饭碗”，因为正如你所说，这是他们不买你产品的主要原因。

---

### [00:28:43] April Dunford

**English:**
And this FOMO thing is just not going to do it.

**中文翻译:**
而 FOMO 根本解决不了这个问题。

---

### [00:28:43] Lenny

**English:**
That's so interesting. So I really like this framework. I wrote this down, teaching them how to buy, that is a really simple way of just thinking about this whole process.

**中文翻译:**
太有意思了。我很喜欢这个框架。我记下来了，“教他们如何购买”，这是思考整个流程的一个非常简单明了的方式。

---

### [00:28:53] April Dunford

**English:**
Well, it's funny, I was having this conversation with Bob Moesta, he did Jobs To Be Done.

**中文翻译:**
很有趣，我之前和 Bob Moesta 聊过这个，他是“待办任务”（Jobs To Be Done）理论的创始人。

---

### [00:28:58] Lenny

**English:**
Yeah, I watched that episode.

**中文翻译:**
是的，我看过那一集。

---

### [00:29:00] April Dunford

**English:**
So he's just the best. And so one of the things I think of is normally when we come at this we're like, "Well, how can we convince the customer that we do the job that they need to have done?" And obviously we need to do that, but there is this secondary job that the champion of the deal is, and that's how do I make a decision without getting fired? And so we got to help them accomplish that job, otherwise we don't get what we want, which is the money.

**中文翻译:**
他太棒了。我想到的一点是，通常我们处理销售时会想：“我们如何说服客户，我们能完成他们需要完成的任务？” 显然我们需要这样做，但交易的“内部推动者”（champion）还有一个“次要任务”，那就是：“我如何在做决定的同时不被开除？” 我们必须帮他们完成那个任务，否则我们也得不到我们想要的——也就是那笔钱。

---

### [00:29:28] Lenny

**English:**
It's so interesting. And it's not even necessarily get fired, it's even the performance sufferers or they don't get the promotion, it's did they do a good job. This makes me think of a process at Airbnb we went through to buy community forum software and I just remember these massive teams of salespeople come to the office and pitching everyone on the software and they just keep pushing you to make what's the next step here, who do we need to roll in, who needs to buy into it? And it's just like, "Oh my God, it's so stressful. I have to keep this thing moving." And then there's IT coming in like, "Oh, we got to make sure it integrates with Salesforce." And you start with I just wanted the best community forum software because we were trying to build something really different and unique and you end up with like, "Okay, it's fine, just go with the thing that works with Salesforce. It's all good. I'm just going to move on to another process."

**中文翻译:**
太有意思了。甚至不一定是怕被开除，可能是怕绩效受损，或者拿不到晋升，关键在于“他们是否做得很出色”。这让我想起在 Airbnb 时，我们购买社区论坛软件的过程。我记得庞大的销售团队来到办公室，向每个人推销软件，他们不断催促你：“下一步是什么？我们需要把谁拉进来？谁需要审批？” 这种感觉就是：“天呐，压力太大了，我得让这事儿转起来。” 然后 IT 部门进来说：“哦，我们要确保它能和 Salesforce 集成。” 你最开始只是想要最好的社区论坛软件，因为你想做一些独特的东西，但最后你妥协了：“行吧，就选那个能和 Salesforce 配合的吧。没问题，我得赶紧处理下一个流程了。”

---

### [00:30:15] April Dunford

**English:**
Well, this is the thing, it's so easy to default to the market leader in that situation. The market leader has this big advantage that you can say, "You know what? Who's going to get me in trouble for picking Salesforce? Nobody." It's so easy to just flip back on that. And so if you're the challenger in this situation, the brand that's number two or number three, you've got to get over all of this inertia and tilting towards the status quo, because it's just so easy, it's the lowest risk decision, besides do nothing is to just pick the leader in the market and we'll just run with that.

**中文翻译:**
没错，这就是问题所在。在这种情况下，人们很容易默认选择市场领导者。市场领导者有一个巨大的优势，你可以说：“你知道吗？选 Salesforce 谁会找我麻烦？没人。” 很容易就倒向那边。所以如果你是挑战者，是排名第二或第三的品牌，你必须克服所有的惯性和向现状倾斜的趋势。因为选择市场领导者太容易了，那是除了“什么都不做”之外风险最低的决定，直接选老大然后照做就行了。

---

### [00:30:49] Lenny

**English:**
I think the classic phrase was no one gets fired for buying Microsoft. I wonder is it Salesforce now that's the default version of that now?

**中文翻译:**
我想那句经典的话是“没人会因为买微软的东西而被开除”。我在想，现在的默认版本是不是变成 Salesforce 了？

---

### [00:30:55] April Dunford

**English:**
Yeah, the original one was IBM. [inaudible 00:30:57]

**中文翻译:**
是的，最早的版本是 IBM。

---

### [00:30:56] Lenny

**English:**
I think you're right. Oh, man.

**中文翻译:**
我想你是对的。噢，天呐。

---

### [00:30:59] April Dunford

**English:**
Now you totally get fired for buying IBM. I don't know what happens. The other thing you bring up is I think an interesting thing to think about too that really messes people up in these situations is that in B2B, typical purchase process, we have five to seven people involved in making the deal happen and so there's this complexity we don't have a consumer, but a lot of people I think overcomplicate that. In a typical B2B purchase process, we've got someone in that buying team is what we would call the champion. So that person is the person who's been tasked with, hey, pick us the accounting software or pick us the CRM, you figure it out. And so that person is the person that does the initial research, makes the short list, probably sits on the first calls, and then there's all these other people.
(00:31:49):
Now, the other people can't make a deal happen, but they can kill it a thousand ways. So the way this works is your positioning and your pitch needs to really work for the champion, because if it doesn't, you don't even get to talk to anybody else, you don't even get to go near anybody else if you don't make it out of the shortlist and you don't get the deal cooking. But once the deal is cooking it is on you to arm that champion to handle all the objections potentially of all the other groups. So if you're the line of business buyer, let's say you're in the sales department and you're buying a CRM, IT is going to have to get involved at some point, and IT doesn't really care about the value of your CRM, but they do care does it meet the security requirements and does it integrate with the stuff we already have and how much of a pain is this thing going to be to manage, and so we're not actually pitching value to those people, we're just handling objections.
(00:32:46):
And so once we realize that, then we can get really tight on our positioning in our sales pitch. What we're really trying to do is just cook the champion, get the champion, and then once the deal's going we got to arm the champion for how to handle all these objections of all these other groups so that you can get a consensus to get a deal moving forward.

**中文翻译:**
现在你买 IBM 反而可能会被开除，我也不知道怎么变成这样的。你提到的另一件事也很值得思考，这在 B2B 场景中经常让人头大：典型的采购流程有 5 到 7 个人参与决策，这种复杂性在 C 端消费中是没有的。但我认为很多人把它想得太复杂了。在典型的 B2B 采购中，采购团队里有一个我们称之为“内部推动者”（champion）的人。这个人是被指派任务的，比如：“嘿，去给我们挑个会计软件或 CRM，你来搞定。” 这个人负责初步研究、制定短名单，并参加第一次电话会议。然后才是其他那些人。
(00:31:49):
其他那些人虽然不能直接促成交易，但他们有一千种方法毙掉交易。所以运作方式是：你的定位和话术必须对“推动者”非常有效。因为如果对他无效，你根本没机会见到其他人，甚至进不了短名单。但一旦交易开始运作，你的任务就是“武装”这位推动者，去处理其他所有部门可能提出的异议。比如，如果你是业务部门买家，在销售部买 CRM，IT 部门迟早要介入。IT 并不关心你的 CRM 有多大价值，他们只关心它是否符合安全要求、是否能与现有系统集成、管理起来麻不麻烦。所以我们并不是在向这些人推销价值，我们只是在处理异议。
(00:32:46):
一旦我们意识到这一点，我们就可以精准地调整定位和销售话术。我们真正要做的是先搞定推动者，然后当交易推进时，武装推动者去应对其他群体的异议，从而达成共识，推动交易前进。

---

### [00:33:05] Lenny

**English:**
How do you actually do that? Is it ask them what are all the concerns you're hearing? Is it ask the individual stakeholders what your biggest concern is?

**中文翻译:**
具体怎么做呢？是问推动者“你听到了哪些顾虑”吗？还是去问每个利益相关者“你最大的担心是什么”？

---

### [00:33:11] April Dunford

**English:**
Well, if we're really smart, we already know because we've done lots of deals. So if we're being a good partner in this, sometimes even in the very first meeting in that spot where we're talking about objectives, we're going to say, "Hey, look, IT is going to come in and they're going to be worried about this, this, and this, and don't worry, we got you."
(00:33:32):
So we're SOC 2 compliant, we do this, we do that, we know because we've done 15 deals and we know what these deals are like and we know what the stuff is going to be. You might have the champion come in and say, "Well, I don't know, end users might not like it." And it's like, "Okay, well, here's how we're going to get your end users on board, this is the training we have, this is the stuff we're going to do." The neat thing, if you have a product like [inaudible 00:33:54] on the front end of that, it takes that objection off the table. And you might have other things like you're going to take this to your boss and they're going to want to know ROI numbers, blah, blah, blah, and we've already done that, look, here's our calculator, if you give us this information, we can put this in, here's how you sell your boss.
(00:34:12):
So that's what we're doing. We're trying to arm them because we've done a million deals, they've never bought software like this before. So half the time you'll be doing deals and they don't even know what the purchase process is. And so if we're being good partners, we're like, "Okay, does this need to go to purchasing?" And they'll say, "Yeah, it probably does." Oh, well, here's what typically happens at purchasing. They're going to do this, this, this, and we're going to give you this stuff and that's going to help you get it through purchasing.

**中文翻译:**
如果我们足够聪明，我们其实已经知道了，因为我们做过很多交易。如果我们想成为一个好的合作伙伴，有时甚至在第一次会议讨论目标时，我们就会说：“嘿，听着，IT 部门肯定会介入，他们会担心 A、B 和 C，别担心，我们已经准备好了。”
(00:33:32):
我们会说：“我们符合 SOC 2 标准，我们有这个那个功能。” 我们之所以知道，是因为我们做过 15 笔类似的交易，知道流程是怎样的。推动者可能会说：“我不知道，最终用户可能不喜欢。” 我们可以回应：“没问题，这是我们让用户上手的方案，这是我们的培训计划。” 如果你有一个好的前端产品，就能消除这个异议。还有其他情况，比如你要向老板汇报，老板想知道投资回报率（ROI），我们可以说：“我们已经准备好了，看，这是我们的计算器，只要你提供这些信息，我们就能算出结果，这就是你如何说服老板的方法。”
(00:34:12):
这就是我们要做的。我们要武装他们，因为我们做过无数次交易，而他们从未买过这类软件。一半的时间里，你在谈交易，而客户甚至不知道采购流程是什么。如果我们是好的合作伙伴，我们会问：“这需要经过采购部吗？” 他们会说：“是的，可能需要。” 我们就说：“哦，采购部通常会做这些事，我们会提供这些资料，帮你顺利通过采购部。”

---

### [00:34:40] Lenny

**English:**
The way you're describing it now makes it feel like you need to be a big company for this to be useful because smaller companies don't have all these reps and they may not have the resources to do all these things you're describing. Who is this framework useful for? Can you use this approach if you're just, say, an early stage B2B?

**中文翻译:**
你现在的描述听起来像是只有大公司才用得上，因为小公司没有这么多销售代表，可能也没有资源去做你描述的所有这些事。这个框架对谁有用？如果你只是一家初创期的 B2B 公司，你能用这种方法吗？

---

### [00:34:53] April Dunford

**English:**
Well, so it's B2B products. If you don't have a sales team, I still think you can use this structure to build a story that marketing can use and you can use in different ways, and we can talk about that. But in the companies that I work with, they're B2B, they've got a sales team, and so the immediate thing we're doing is we're making a shift in positioning, we're building a sales pitch that reflects that positioning, we can immediately implement that in sales even though it's going to take a while for us to forklift the messaging and do other stuff and change our campaigns and everything else to match this new positioning, but we can tighten up the sales pitch and have an immediate impact over in sales on that. Second thing is that I've worked with tons of companies where the founder is the only sales rep and this works pretty good for that.
(00:35:39):
I don't think we need a ton of resources to do it, but I do think we need to have enough traction in the market that we understand how a deal typically goes. So if we haven't sold anything yet then we don't know yet, it's hard for us to help you buy something if we don't even know how to sell it. But if I've done 10 deals, I know what happens, I got a pretty good guess of what IT is going to say when you try to implement this stuff, I have a good guess of what's going to happen when we go to roll it out, I have a pretty good guess of what your boss might object to or might get excited by. And so I don't necessarily need a research team to go figure this out. This is just me trying to be helpful and help the champion do their job of getting this deal to the finish line.

**中文翻译:**
它是针对 B2B 产品的。即使你没有销售团队，我仍然认为你可以使用这个结构来构建一个营销部门可以使用的故事，并以不同的方式应用它，我们可以稍后讨论。但在我合作的公司中，他们是 B2B，有销售团队。我们立即要做的是转变定位，并建立一个反映该定位的销售话术。我们可以立即在销售中实施，尽管全面更新营销信息、更改广告活动以匹配新定位需要时间，但我们可以先收紧销售话术，并在销售端产生立竿见影的效果。第二点是，我合作过很多公司，创始人是唯一的销售，这套方法对他们也非常有效。
(00:35:39):
我不认为这需要大量资源，但我认为我们需要在市场上有足够的牵引力（traction），以便了解交易通常是如何进行的。如果我们还没卖出过任何东西，那我们确实不知道。如果我们连怎么卖都不知道，就很难教别人怎么买。但如果我已经做了 10 笔交易，我就知道会发生什么。我能猜到当你尝试实施时 IT 部门会说什么，我能猜到推广时会发生什么，我也能猜到你老板会反对什么或对什么感兴趣。所以我并不需要一个研究团队来搞清楚这些。这只是我尝试提供帮助，协助推动者完成他们的工作，把交易带到终点线。

---

### [00:36:23] Lenny

**English:**
So maybe the MVP of this approach is a deck that you continue iterating and adjust and restructure, and also bullet points of things you want to bring up like, "Okay, cool, IT is going to ask for these things," a few bullet points that you keep track of.

**中文翻译:**
所以这种方法的“最小可行性产品”（MVP）可能就是一个不断迭代、调整和重构的演示文稿，再加上一些你想提到的要点，比如“IT 部门会问这些问题”，记录下这些要点。

---

### [00:36:38] April Dunford

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:36:39] April Dunford

**English:**
I'm also thinking from the perspective of a product team building a product, they don't really sell it themselves. They work with sales, they work with marketing. Is there anything that you would recommend or that you think product teams could learn from this approach of selling that would help them build products in a different way or work with sales in a different way?

**中文翻译:**
我也在从产品团队的角度思考，他们负责打造产品，但并不直接销售。他们与销售和营销部门合作。你有什么建议，或者你认为产品团队可以从这种销售方法中学到什么，从而帮助他们以不同的方式打造产品，或者以不同的方式与销售部门合作？

---

### [00:36:59] April Dunford

**English:**
Yeah. So here's what I think, the core of a good sales pitch is really deeply understanding your differentiated value, which is what is the value I can deliver that no other solution can. Often what I see at companies is you got a smart product team and they know a lot about the stuff they're building and why it's important and what the value is to the customer, and they did all this work on that when they were building it, but that information never made the jump to sales, because sales isn't even trying to pitch value. They're just pitching features like here's the dropdown menus, here's what they do. And so the first step in fixing this I think is to have a cross-functional team work on positioning.
(00:37:43):
So if I've got product, marketing, and sales together in the room working on defining what our differentiated value is, then I'm going to get all the good juice out of the product team that deeply understands the product, deeply understand what's differentiated about it, deeply understands value, and then I'm also going to have all the juice from the sales team that understands what the common objections are, what the champion really wants to get done and doesn't want to get done, what the situation is in a typical account, and then all of this cool information sharing happens, which actually you end up with way better definition of your differentiated value in the first place.
(00:38:22):
And so once we've done that work, it is very natural then for us to work together on the sales pitch that reflects that. What typically happens is not that at all. What typically happens is product's working on some stuff, sales is working on some stuff, marketing's working on some stuff. Marketing in their own little bubble comes up with positioning, they might build some stuff for the sales team, heave it over to the sales team. Sales team looks at it and says, "I don't get what any of this stuff is. I disagree with this. This doesn't match what I see," and they just throw it out and they go back to doing the same pitch they've been doing since the year of the flood.

**中文翻译:**
是的。我是这样想的：一个好的销售话术的核心是深入理解你的“差异化价值”，即我能提供而其他解决方案无法提供的价值是什么。我经常在公司看到，产品团队很聪明，他们非常了解自己正在打造的东西，知道它为什么重要，知道它对客户的价值，他们在开发时做了大量工作。但这些信息从未传递给销售，因为销售甚至根本没尝试去推销“价值”。他们只是在推销“功能”，比如“这是下拉菜单，这是它们的功能”。所以我认为解决这个问题的第一步是让一个跨职能团队来处理定位。
(00:37:43):
如果我让产品、营销和销售人员聚在一起，共同定义我们的差异化价值，那么我就能从产品团队那里获得精华——他们深谙产品，知道差异化在哪，理解价值所在。同时，我也能从销售团队那里获得精华——他们知道常见的异议是什么，推动者真正想达成什么，不想做什么，以及典型客户的情况。这种酷炫的信息共享一旦发生，你最初对差异化价值的定义就会变得好得多。
(00:38:22):
一旦完成了这项工作，大家一起制定反映该价值的销售话术就变得顺理成章了。而通常情况并非如此。通常是产品在忙自己的，销售在忙自己的，营销也在忙自己的。营销部门在自己的小圈子里搞出一套定位，可能为销售团队做点资料，然后扔给销售。销售团队一看：“我不明白这些是什么。我不同意这个。这和我看到的情况不符。” 然后他们就把它扔进垃圾桶，继续用那套自盘古开天辟地以来就在用的老掉牙话术。

---

### [00:38:57] Lenny

**English:**
That's a long time. So first podcast episode was all around positioning, and so folks want to get deep into that, they should listen to that, so we're not going to spend tons of time there, but differentiated value is a big part of this process also so I think it's worth spending a bit of time here. Could you maybe share a couple examples of what this is to give people a sense of what does it mean to share differentiated value?

**中文翻译:**
那确实很久了。我们的第一集播客全是关于定位的，所以想深入了解的人应该去听那一集，我们就不在这里花太多时间了。但“差异化价值”也是这个流程的重要组成部分，所以我觉得值得在这里花点时间。你能分享几个例子吗？让大家感受一下分享差异化价值到底意味着什么。

---

### [00:39:20] April Dunford

**English:**
Yeah. So differentiated value is the answer to the question why pick us over the other alternatives? And so the way we get at that in positioning is we start with putting a stake in the ground of who do we actually compete with? And so if we didn't exist in the market, what would a customer do? And so typically there's some status quo thing, it might not even look like you, it might just be a spreadsheet, or do it with the intern or manual labor, and then there's whatever else ends up on a short list against us. And it's basically the definition of I got to beat all this plus indecision in order to win a deal, so I can stick my stake in the ground. Sales knows the answer to this question. If you have a sales team, they know the answer to this question, what would a customer do if we didn't exist, they know.
(00:40:06):
And then we get to the next step is, well, so what do we have that's different? And that's capability wise, feature function of the product or capability of the company, so it could be features, it could be your pricing model, it could be we have support in a way that the other folks don't. So there's all kinds of things it could be. It could be be the breadth of the portfolio that you have beyond that one product, we can fill whiteboards with this stuff. And then what we do is we go down that list of features and we say, "So what? You got advanced AI, whatever the heck the thing is, so what? Why does anybody care?" And the answer to that so what is your value. And because it came from this differentiated feature, it's generally value that the other guys can't deliver because they don't have the capabilities that underpin it.
(00:40:53):
So if I give you an example, a company I worked with a few years back, they've recently been acquired by Salesforce called LevelJump, and so they're in the sales enablement space, which is terrible. There's a million companies in the sales enablement space and they all look the same. And so LevelJump, so if you look at, well, what's the competitive alternatives, if I look at all the companies in the sales enablement space, you can put them into two buckets in terms of approaches, they're either a CMS like a jazzy content repository where you could make sure that people are using the right content and whatever, or they're an LMS, a learning management system, which I can build the course and certify you on the course, and that's how we're going to train the sales reps.
(00:41:39):
If you look at LevelJump, they're differentiated capability is they're the only one that's built on top of Salesforce. That's the feature, we're built on Salesforce, the other folks aren't. And then who cares? So what? And so when we first had a conversation about it, there was five or six different answers to that so what question, but the big answer was, well, because we're built on top of Salesforce, my sales enablement data is integrated with my sales data. And then you say, "Well, so what about that?" Well, because then that means I can actually tell did the sales enablement improve time to first deal or improve time to make quota? Well, so what about that? Well, if I improve that ramp time, then we get way more revenue faster. So that's the differentiated value.
(00:42:29):
When I go to do that in a sales pitch, I can translate that into my insight. My insight is every day your rep's not making [inaudible 00:42:36] it costs you money. So if we really want to solve sales enablement, don't we really want to have something where we can measure whether or not the sales enablement is working with sales metrics? Yeah, we do.

**中文翻译:**
好的。差异化价值就是回答这个问题：为什么要选我们而不是其他替代方案？在定位中，我们首先要明确：我们到底在和谁竞争？如果我们在市场上不存在，客户会怎么做？通常会有一些“现状”，它可能看起来根本不像你的产品，可能只是一个 Excel 表格，或者让实习生去做，或者是体力劳动。然后是其他进入短名单的竞争对手。基本上，为了赢得交易，我必须击败所有这些因素加上客户的犹豫不决。销售人员知道这个问题的答案。如果你有销售团队，他们知道如果你们不存在，客户会怎么做。
(00:40:06):
接下来的一步是：那我们有什么不同的地方？这包括能力方面、产品的功能特性或公司的能力。可以是功能，可以是定价模型，也可以是我们拥有别人没有的支持方式。可以有很多种。甚至可以是除了这一个产品之外，你拥有的整个产品组合的广度。我们可以用这些东西填满整个白板。然后，我们逐一查看这些功能并问：“那又怎样？（So what?）你有先进的 AI，管它是什么呢，那又怎样？为什么有人会在乎？” 对这个“那又怎样”的回答，就是你的“价值”。因为它源于差异化的功能，所以通常是别人无法提供的价值，因为他们没有支撑它的底层能力。
(00:40:53):
举个例子，我几年前合作过的一家公司叫 LevelJump，最近被 Salesforce 收购了。他们属于“销售赋能”（sales enablement）领域，这个领域很糟糕，有上百万家公司，而且看起来都一样。如果你看 LevelJump 的竞争替代方案，这个领域的所有公司可以分为两类：一类是 CMS（内容管理系统），就像一个花哨的内容库，确保大家使用正确的内容；另一类是 LMS（学习管理系统），可以建立课程并进行认证，以此培训销售代表。
(00:41:39):
如果你看 LevelJump，他们的差异化能力在于：他们是唯一一家直接构建在 Salesforce 之上的。这就是功能——我们构建在 Salesforce 上，别人不是。那又怎样？谁在乎？当我们第一次讨论这个问题时，有五六个不同的答案，但核心答案是：因为我们构建在 Salesforce 之上，所以我的销售赋能数据与我的销售数据是集成的。接着问：“那又怎样？” 答：“这意味着我可以真正判断销售赋能是否缩短了达成第一笔交易的时间，或者是否缩短了达标（make quota）的时间。” 再问：“那又怎样？” 答：“如果我缩短了入职爬坡期（ramp time），我们就能更快获得更多收入。” 这就是差异化价值。
(00:42:29):
当我把这个应用到销售话术中时，我可以将其转化为我的“洞察”。我的洞察是：你的销售代表每耽误一天没出单，你都在亏钱。所以如果我们真的想解决销售赋能问题，难道我们不想要一个能用销售指标来衡量赋能是否有效的工具吗？是的，我们想要。

---

### [00:42:47] Lenny

**English:**
Interesting. So the differentiated value often informs the insight that you start with?

**中文翻译:**
很有趣。所以差异化价值通常会启发你开头所用的那个“洞察”？

---

### [00:42:52] April Dunford

**English:**
It does. It absolutely is. The insight is basically the context that makes your differentiated value important, what is the thing you need to know to understand the importance of my differentiated value? In the case of Help Scout, the insight is, look, digital businesses like customer service is a growth driver, where does that come from? If you look at their differentiated value, it's there. And so we can just reverse it, flip it around. Even if the product wasn't necessarily constructed with that insight, maybe we got there sideways or the roundabout way or whatever, we iterated our way into that. We can look at the differentiated value and then basically reverse it out to the insight.

**中文翻译:**
没错，绝对是这样。洞察本质上是让你的差异化价值变得重要的“语境”。为了理解我差异化价值的重要性，你需要知道什么背景？以 Help Scout 为例，洞察是：看，对于数字业务来说，客户服务是增长驱动力。这从何而来？如果你看他们的差异化价值，就在那里。所以我们可以反向推导。即使产品最初不一定是基于这个洞察构建的，也许我们是歪打正着或者通过迭代走到了这一步，我们也可以观察差异化价值，然后反向推导出那个洞察。

---

### [00:43:33] Lenny

**English:**
What's a sign that the differentiated value or insight that you've come up with just isn't clicking?

**中文翻译:**
有什么迹象表明你提出的差异化价值或洞察根本没起作用？

---

### [00:43:37] April Dunford

**English:**
If the differentiated value doesn't work in a sales pitch, what you'll get is the company going, "Why would I pay for that? This is not value for me, buddy." The companies I work with, the way I look at it is if you're in market and you're selling and you have happy, engaged customers, there's differentiated value there. That's why they picked you. That's why they love you. That's why they don't turn out on you. It's there. You might not know what it is, we might have to do a little process to get at it, but it's there and it exists.

**中文翻译:**
如果差异化价值在销售话术中不起作用，你会听到客户说：“我为什么要为此付钱？伙计，这对我不产生价值。” 对于我合作的公司，我的看法是：如果你已经在市场上销售，并且拥有满意、活跃的客户，那么差异化价值一定存在。这就是他们选择你、爱护你、不流失的原因。它就在那里。你可能还不知道它是什么，我们可能需要一个小流程来把它挖掘出来，但它确实存在。

---

### [00:44:16] Lenny

**English:**
Awesome. Another question that's been in the back of my mind since we started talking about differentiated values is just how honest should you be about the competition? Obviously there's a spectrum of extremely honest to super biased, what's your guidance on just how honest to be there?

**中文翻译:**
太棒了。自从我们开始讨论差异化价值，我脑子里一直盘旋着另一个问题：在谈论竞争对手时，你应该有多诚实？显然，这中间有一个光谱，从极端诚实到超级偏见。关于诚实度，你有什么建议？

---

### [00:44:34] April Dunford

**English:**
The posture I think you should assume in a sales situation, I had an old boss used to talk about this, is the posture we should have is calm confidence. So where that calm confidence comes from is we really understand why people should pick us. So this is differentiated value, we really understand it and we really understand who that's a really good fit for, and we don't even bother trying to chase anybody else.
(00:45:03):
So we should be able to come in and say, "Look, we're sales enablement that delivers results. If you don't care about those results, you shouldn't pick us. You should pick someone else." And so generally what we're trying to be is extremely honest. We're trying to come in and actually give credit where credit is due with the other approaches, because typically the other approaches work just fine for other kinds of companies. If you're really small and you're not growing e-commerce business, use a shared inbox. It's free, it's easy to use, there's no problems there, just use it. If you're really worried about bringing the cost down in a customer service center, maybe you should use Zendesk. And so I think the more we can act as a guide in this situation and come in and say, "Look, these guys are good for this, these folks are good for this, and we're good for this. And you might not care about that, and if you don't care about that, we're not the one for you. You shouldn't pick us." But I think that...

**中文翻译:**
我认为在销售场景中你应该采取的姿态——我以前的老板经常提到这一点——就是“从容的自信”（calm confidence）。这种自信源于我们真正理解为什么人们应该选择我们。这就是差异化价值，我们深知它，也深知它最适合谁，我们甚至懒得去追逐其他不匹配的客户。
(00:45:03):
所以我们应该能够走进去说：“看，我们是能交付结果的销售赋能工具。如果你不在乎这些结果，你不该选我们，你应该选别人。” 通常我们尝试做到极端诚实。我们甚至会给予其他方案应有的肯定，因为通常其他方案对其他类型的公司确实有效。如果你是一家规模很小、不怎么增长的电商，那就用共享收件箱吧，免费、好用，没毛病。如果你真的只担心降低客服中心的成本，也许你应该用 Zendesk。我认为在这种情况下，我们越能扮演“向导”的角色，说出“这些家伙擅长这个，那些人擅长那个，而我们擅长这个。你可能不在乎这一点，如果你不在乎，那我们不适合你，你不该选我们。” 我觉得……

---

### [00:46:00] April Dunford

**English:**
We're not the one for you. You shouldn't pick us. But I think that this calm confidence idea is that where we know the client should pick us, we should be unafraid to fight for that business. But we should totally walk away from business where we're not the best fit. We shouldn't be chasing that business at all.

**中文翻译:**
（接上文）……“我们不适合你，你不该选我们。” 但这种“从容自信”的理念在于，当我们知道客户确实应该选择我们时，我们会毫不畏惧地去争取。但对于我们不是最佳选择的业务，我们应该完全放弃，根本不该去追逐。

---

### [00:46:20] Lenny

**English:**
And this comes back to teaching them how to buy again and again. For these cases where you're like, "This is not a fit." Ideally you know that before you fly to their office and pitch them.

**中文翻译:**
这又回到了“教他们如何购买”这一点。对于那些“不匹配”的情况，理想情况下，在你飞到他们办公室进行推销之前，你就应该已经知道了。

---

### [00:46:29] April Dunford

**English:**
Yeah, generally you've had some kind of qualification happen upstream, and so that qualification could be done in lots of different ways. If you've got some kind of product like growth motion in the beginning, you're looking for signals in that. And if the signals aren't there, then you're not talking to them. And so if you've designed your signals right, then you already know there's intent there. You already know you're a fit. You already know stuff. The way a lot of companies do this is they'll have inside sales do a qualification call before they set up a first call with a sales rep. In that qualification call, you're trying to make sure is this the right person? Do they have a need that we can actually meet? Is this actually a good fit for what we do? And if they're not, they don't even make it to the call.

**中文翻译:**
是的，通常在流程上游会有某种“准入筛选”（qualification）。筛选可以有很多种方式。如果你一开始有某种 PLG（产品驱动增长）模式，你会寻找其中的信号。如果没有信号，你根本不会和他们谈。如果你设计的信号正确，你就已经知道对方有意向，知道你们是匹配的。很多公司的做法是，在安排销售代表进行第一次正式通话前，先让内勤销售（inside sales）打一个筛选电话。在那个电话里，你要确认：这是对的人吗？他们有我们能满足的需求吗？这真的适合我们吗？如果不适合，他们甚至没机会进入正式通话环节。

---

### [00:48:09] Lenny (Sponsor Ad - LinkedIn)

**English:**
Imagine a place where you can find all your potential customers and get your message in front of them in a cost efficient way. If you're a B1B business, that place exists, and it's called LinkedIn. LinkedIn Ads allows you to build the right relationships, drive results, and reach your customers in a respectful environment. Two of my portfolio companies, Webflow and Census, are LinkedIn success stories. Census had a 10x increase in pipeline with the LinkedIn startup team. For Webflow after ramping up on LinkedIn in Q3, they had the highest marketing source revenue quarter to date. With LinkedIn Ads you'll have direct access to and can build relationships with decision makers including 950 million members, 180 million senior execs and over 10 million C-level executives. You'll be able to drive results with targeting and measurement tools built specifically for B2B. In tech LinkedIn generated two to five x higher return on ad spend than any other social media platforms.
(00:48:09):
Audiences on LinkedIn have two times the buying power of the average web audience, and you'll work with a partner who respects the B2B world you operate in. Make B2B marketing everything it can be and get $100 credit on your next campaign. Just go to linkedin.com/podlenny to claim your credit. That's linkedin.com/podlenny. Terms and conditions apply.

**中文翻译:**
想象一下，有一个地方你可以找到所有的潜在客户，并以高性价比的方式将你的信息展示在他们面前。如果你是一家 B2B 企业，这个地方确实存在，它就是 LinkedIn。LinkedIn 广告让你能够在相互尊重的环境中建立正确的关系、驱动业绩并触达客户。我的两家投资组合公司 Webflow 和 Census 都是 LinkedIn 的成功案例。Census 通过 LinkedIn 创业团队实现了销售管线（pipeline）10 倍的增长。Webflow 在第三季度加大 LinkedIn 投入后，获得了迄今为止最高的营销来源收入季度。通过 LinkedIn 广告，你可以直接接触并与决策者建立联系，包括 9.5 亿会员、1.8 亿高管和超过 1000 万名 C 级高管。你将能够利用专为 B2B 打造的定向和衡量工具来驱动业绩。在科技领域，LinkedIn 的广告支出回报率（ROAS）比其他任何社交媒体平台高出 2 到 5 倍。
(00:48:09):
LinkedIn 上的受众拥有普通网络受众两倍的购买力，你将与一个尊重你所处 B2B 领域的伙伴合作。让 B2B 营销发挥其最大潜力，并在你的下一次活动中获得 100 美元的抵用金。只需访问 linkedin.com/podlenny 即可领取。地址是 linkedin.com/podlenny。受条款和条件约束。

---

### [00:48:32] Lenny

**English:**
Another question around this idea of differentiated value and just alternative approaches is there's a certain previous guest who was very big on creating a category being extremely important, and that potentially being the only way to build a legendary business. I know you have a different perspective on that because in theory if you go that direction, there's no alternative. It's like "We're the one." What's your take on that?

**中文翻译:**
关于差异化价值和替代方案，还有一个问题：我之前请过的一位嘉宾非常强调“创造品类”（creating a category）的重要性，认为这可能是打造传奇企业的唯一途径。我知道你对此有不同的看法，因为理论上如果你走那条路，就没有替代方案了，就像在说“我们是独一无二的”。你对此怎么看？

---

### [00:48:55] April Dunford

**English:**
Well, so here's a few things. So one, obviously creating a category is not the only way to create a legendary business because the vast majority of legendary businesses did not create the categories that they're in. So Google did not create search, Facebook did not create social network. There's so many of them. It's actually more of an exception to the rule that the company is creating a category than the other way around. So I think it's a bit disingenuous to say the only way. It is a way to build a big business, no question about that. But it's absolutely not the only way. In fact, it is not the most common way, but it is a way and it does work. So that's one thing. The second thing is that category creation is interesting. Like most companies, if you look at their arc, even the category creators that are successful, they did not start out as category creators.
(00:49:53):
So they started out as a niche play in an existing category, and that's because that's generally the easiest way to get traction for a company early because what is the job of the market category? The job of a market category is to help answer the question, what is this thing all about? If I'm positioning an existing category, I can say, "Well, I'm CRM for very small businesses." That was Salesforce's initial positioning. I didn't have to explain to you what a CRM was, that already existed. There was already billion dollar company in that space. We know what a CRM is, and I could say "We're CRM for very small businesses. The reason you can use in this very small businesses is we don't have any software. So you don't have to have an IT department to babysit it. It's fantastic."
(00:50:34):
So most companies start there. Now what happens is that if you become the dominant player in that space, which again, category creation folks talk about this like no category creator has ever lost the market. In fact, most category creators wins their market. Like what happened to MySpace? What happened to Ask Jeeves? It didn't work out so good for them. Most category creators actually get overtaken by fast followers. So if we look at the CRM market, Siebel was the big dominant player there and now they're not. So now we've got Salesforce. Once you're the dominant player in that market, a cool move to do is to actually extend the boundaries of the category so that you can continue to grow. And most of the category creation examples we see are companies that when they were 200, 300, 400 million revenue dominating their space, then decided to move the goalposts and say, "Well actually now we're expanding into all these other areas and we're going to call this category something. And that's what it is."
(00:51:38):
And there's loads of examples of that. Like Qualtrics for example, is a company that a lot of people talk about very successful category creation. Well, they were survey software up until there were 300 million revenue just like everybody else in an existing category. So that got them there and that worked just fine. Oh, well, once we're dominating it, now we can say it's whatever, it is, customer experience software, whatever it is. Snowflake. Another good example like data warehousing in the cloud, they were that data warehousing, an existing market, were data warehousing for the cloud. That is not category creation. And that took them all the way up to the point where they were about to go public and now they're cloud data, which is their attempt to expand and say, "Well, it's not just data warehousing, it's actually data lakes and all other data stuff."
(00:52:22):
And so that's a smart move for them because they're now very well known in that space. I'm not saying category creation is a bad thing. There are examples of company that came right out of the gate and successfully created a category and then survived to own the category longer term. But a more common thing that happens is that the company does the hard work of creating the category and in exactly the moment where the category starts to take hold, fast follower can come in with fresh funding and a lot of it and learn from all your mistakes and come in and knock you off the peak right when you think you've made it.
(00:53:01):
So I think category creation is, again, it's good, it works, but I think we have to be very careful when we're thinking about doing that at an early stage business or a business that isn't already dominating the category that they're in. It's much more common to see companies come in, shave off a piece of the market, dominate that, and then successfully branch out. It's what Jeffrey Moore called bowling pin strategy. Almost all successful companies follow bowling pin strategy.

**中文翻译:**
好的，有几点看法。第一，显然创造品类并不是打造传奇企业的唯一途径，因为绝大多数传奇企业并没有创造它们所在的品类。谷歌没有创造搜索，Facebook 没有创造社交网络。例子太多了。实际上，一家公司创造一个品类反而是特例，而不是常态。所以说它是“唯一途径”有点不真诚。它确实是打造大企业的一种方式，毫无疑问，但绝对不是唯一的方式。事实上，它甚至不是最常见的方式，但它确实是一种可行的方式。这是第一点。第二点是，品类创造很有趣。如果你观察大多数公司的发展轨迹，即使是那些成功的品类创造者，他们最初也不是以品类创造者的身份开始的。
(00:49:53):
他们最初是在现有品类中做一个利基市场（niche play），因为这通常是公司早期获得牵引力最简单的方式。为什么？因为“市场品类”的作用是什么？它的作用是帮助回答“这到底是个什么东西”。如果我定位在一个现有品类中，我可以讲：“我是专门为小微企业设计的 CRM。” 这就是 Salesforce 最初的定位。我不需要向你解释什么是 CRM，因为它已经存在了，那个领域已经有价值十亿美元的公司了。大家都知道 CRM 是什么，我只需说：“我们是给小微企业用的 CRM。之所以适合小微企业，是因为我们不需要安装软件，你不需要 IT 部门来维护它。太棒了。”
(00:50:34):
所以大多数公司是从这里开始的。接下来发生的是，如果你成为了该领域的霸主——顺便说一下，那些鼓吹品类创造的人总说品类创造者从未输过市场，事实上大多数品类创造者确实赢了。但看看 MySpace 发生了什么？Ask Jeeves 发生了什么？他们结局并不好。大多数品类创造者实际上会被“快速跟进者”（fast followers）超越。看看 CRM 市场，Siebel 曾是霸主，现在不是了，现在是 Salesforce。一旦你成为该市场的霸主，一个很酷的举动就是扩大品类的边界，以便继续增长。我们看到的大多数品类创造的例子，其实是公司在年营收达到 2 亿、3 亿、4 亿美元并统治了所在领域后，决定移动球门柱，说：“其实我们现在正扩展到所有这些其他领域，我们要把这个品类叫作某某。” 事情就是这样。
(00:51:38):
这样的例子比比皆是。比如 Qualtrics，很多人说它是非常成功的品类创造案例。但在营收达到 3 亿美金之前，他们就是做调查软件的，和现有品类里的其他人一样。这让他们获得了成功，效果很好。哦，既然我们统治了调查软件，现在我们可以说它是“客户体验软件”或其他什么了。Snowflake 是另一个好例子，他们最初是“云端数据仓库”，数据仓库是现有市场，他们只是“云端的”。这并不是品类创造。这让他们一直走到了上市前夕，现在他们叫“云数据”，这是他们尝试扩张的手段，说：“我们不只是数据仓库，我们还做数据湖和所有其他数据业务。”
(00:52:22):
这对他们来说是明智之举，因为他们已经在那个领域非常有名了。我不是说品类创造不好。确实有公司一出门就成功创造了品类并长期持有。但更常见的情况是，一家公司辛苦地创造了品类，就在品类开始站稳脚跟的那一刻，一个带着巨额资金的快速跟进者出现了，吸取了你所有的教训，就在你以为自己成功了的时候，把你从巅峰撞下来。
(00:53:01):
所以我认为品类创造很好，很管用，但当我们考虑在初创阶段或尚未统治现有品类时就这样做，必须非常小心。更常见的情况是公司进入市场，切下一块蛋糕，统治它，然后成功分支扩张。这就是杰弗里·摩尔（Jeffrey Moore）所说的“保龄球瓶策略”（bowling pin strategy）。几乎所有成功的公司都遵循保龄球瓶策略。

---

### [00:53:29] Lenny

**English:**
Wait, what is that? Let's touch on that real quick.

**中文翻译:**
等等，那是什么？我们快速聊聊这个。

---

### [00:53:31] April Dunford

**English:**
Oh yeah, you remember that thing. It's funny how many times I've talked about bowling pin strategy in the last two months. So this comes from a bunch of work that was done around the way innovation gets adopted, blah, blah. So there's a bunch of research done on this stuff, and I'm going to misquote it because Jeffrey Moore stuff, I've been reading it for decades. But bowling pin strategy goes like this. The easiest way to take over a great big market is to define a segment of the market that is underserved by the market leader.
(00:53:59):
And so if you think about a bunch of bowling pins, we're going to circle around the lead pin, which is this little piece of the market that's easy for us to go get, and the market leader probably doesn't care about it. And so we knock over that pin and knocking over that pin enables us to get to the three pins right beside it. And so now I'm established here as a beachhead and I can go get the next three pins, I'm going to knock those over, and eventually I get big enough to challenge the market leader and then I overtake them.
(00:54:28):
So the example for my early career was I worked at this company, we thought we were enterprise software. We narrowed it down to CRM for investment banks, and so we literally drew bowling pins for our investors and said, "Lead pin is CRM for investment banks. Once we knock that over, then we're going to go to retail banking, then we're going to be CRM for banking. And then once we knock that over, we're going to go to insurance, then we're going to be CRM for financial services. Once we knock that over, then we're going to be a great big company and we're going to challenge Siebel to be CRM for enterprise software." Instead we got acquired by Siebel for like $1 billion, but whatever. So most companies, if you look at the history of them, they actually start that way. And so yeah, if we just fast forwarded to when they were 300 million, we can say "Category creation's the only thing to do," but it's like, well, what happened before then? That was something different.

**中文翻译:**
噢是的，你还记得那个。很有趣，过去两个月我无数次提到保龄球瓶策略。这源于关于创新扩散方式的一系列研究。杰弗里·摩尔的东西我已经读了几十年了，我可能会引用得不太精确。但保龄球瓶策略大致是这样的：占领一个巨大市场最简单的方法是定义一个被市场领导者忽视的细分市场。
(00:53:59):
如果你想象一堆保龄球瓶，我们会瞄准那个“领头瓶”（lead pin），也就是那一小块我们容易拿下的市场，而市场领导者可能根本不在乎它。我们撞倒那个瓶子，撞倒它能让我们触及旁边的三个瓶子。现在我在这里建立了一个“滩头阵地”，我可以去撞接下来的三个瓶子，最终我变得足够强大，可以挑战市场领导者并超越他们。
(00:54:28):
我职业生涯早期的例子是：我在一家公司工作，我们自认为是企业软件。我们将其缩小到“投资银行专用 CRM”，我们真的为投资者画了保龄球瓶，说：“领头瓶是投行 CRM。一旦撞倒它，我们就进入零售银行业，成为银行专用 CRM。再撞倒那个，我们就进入保险业，成为金融服务专用 CRM。等这些都撞倒了，我们就成了一家大公司，可以挑战 Siebel，成为全行业的企业级 CRM。” 结果我们被 Siebel 以 10 亿美元收购了，不过这不重要。大多数公司如果你看历史，其实都是这样开始的。所以，如果我们直接快进到他们营收 3 亿的时候，我们可以说“品类创造是唯一出路”，但问题是，在那之前发生了什么？那是完全不同的故事。

---

### [00:54:47] Lenny

**English:**
Awesome. Let's come back to your framework. I'm looking at the list of bullet points. So we've covered a lot of this already actually. So there's the insight where you helped them understand what's happening in the world and what's changing and why this is important. Then you talk about what the alternative approaches might be, pros and cons. Then there's this third step, which we haven't talked about yet, which is sharing the perfect world characteristics of a perfect solution. Can you talk a bit about that and why that's important?

**中文翻译:**
太棒了。让我们回到你的框架。我看着要点列表，其实我们已经涵盖了很多内容。包括“洞察”，即帮助客户理解世界正在发生什么、什么在改变以及为什么这很重要。然后你谈到了替代方案及其优缺点。接着是第三步，我们还没聊过，就是分享“理想世界”中完美解决方案的特征。你能谈谈这一点以及为什么它很重要吗？

---

### [00:55:47] April Dunford

**English:**
So this is the conclusion of the setup phase. So if I'm Help Scout for example, the conclusion is we say, "Look, you really want customer success software that's as easy to use as an inbox. You're never going to outgrow it, but it was built from the ground up to be deliver an amazing service." And so it's this part of the pitch where we actually get agreement with the customer that we are aligned in terms of our point of view on the universe. So it's where I say, "Okay, we've had our little discussion about the pros and cons of the other alternatives," and we say, "So look, so are you with me, man? Can we all agree that a really good solution for you would have A, B and C?" And the customer is either like, "Yeah, right," or they're not. And so if they're right with you on this definition of the perfect world, then I've got you. I've already won the deal and I haven't even talked about us yet because the way I've set it up, I'm the only one that can deliver that.
(00:56:49):
So if you say, "Right," all I got to do is prove that I can do that and get you over the hurdle that it's possible for you to adopt it.

**中文翻译:**
这是铺垫阶段的总结。以 Help Scout 为例，结论就是我们会说：“看，你真正想要的是一款像收件箱一样易用、永远不会不够用、且从底层逻辑上就是为了提供惊人服务而构建的客户成功软件。” 在话术的这个环节，我们实际上是在寻求客户的认同，确认我们的世界观是一致的。我会说：“好了，我们已经讨论了其他替代方案的优缺点，” 然后说：“那么，你认同吗？我们是否同意，一个真正适合你的好方案应该具备 A、B 和 C？” 客户要么说“是的，没错”，要么不认同。如果他们认同了你对“理想世界”的定义，那我就抓住你了。我甚至还没开始谈论我们自己，就已经赢得了这笔交易，因为根据我的设定，我是唯一能提供这些东西的人。
(00:56:49):
所以如果你说“没错”，我接下来要做的就是证明我能做到，并帮你克服采纳过程中的障碍。

---

### [00:56:59] Lenny

**English:**
Sounds too easy.

**中文翻译:**
听起来太容易了。

---

### [00:57:01] April Dunford

**English:**
Yeah, I mean...

**中文翻译:**
是啊，我是说……

---

### [00:57:04] Lenny

**English:**
It's like you lure them in.

**中文翻译:**
就像是你把他们诱导进来一样。

---

### [00:57:04] April Dunford

**English:**
If all of this was easy, Lenny we would be on a beach drinking out of a coconut.

**中文翻译:**
Lenny，如果这一切都很容易，我们现在就在沙滩上捧着椰子喝水了。

---

### [00:57:09] Lenny

**English:**
Oh man, let's make it happen. Okay, so that's the setup. What do you call the second part again?

**中文翻译:**
噢伙计，让我们实现它吧。好了，那是“铺垫”部分。第二部分你叫它什么来着？

---

### [00:57:14] April Dunford

**English:**
It's the follow through-

**中文翻译:**
是“后续跟进”（Follow Through）——

---

### [00:57:14] Lenny

**English:**
The follow through.

**中文翻译:**
后续跟进。

---

### [00:57:15] April Dunford

**English:**
... which is really focused on differentiated value. So in the second part, the first step is usually we introduce our stuff, which is where the market category is important. So we come in and we say, "Okay, can we agree that a really good solution should tick these boxes? Yes. Okay, good. Now let's talk about us. Okay, so we believe that. That's why we build what we build."
(00:57:36):
So here I am, I'm Help Scout, we're customer service software for digital businesses or whatever our market category is. So we introduce it just to get people straight in their mind about what it is, and then we move to here's the value, here's how we do it. If we think about a typical sales call, like let's say a sales call is half an hour, 45 minutes, I would expect to spend more than half of the time in the sales call in this differentiated value phase. So if we're doing a demo, that's the demo, and we're saying, "Okay, step one, let me show you how we do this. So easy to use as an inbox. Here's the features. Never have to outgrow it, here's the features. Delivers amazing customer experience, here's the features." And so that's where we're getting to the meat of what you thought you were getting when you clicked on the button that said, "Give me a demo."
(00:58:25):
So that's what we're doing there. And then we end with these three little pieces. One is generally I got to show you some proof that I can do what I say I can do. So if I'm claiming this thing delivers an amazing customer experience, how do I prove that? Well, I can prove it by other customers saying it was amazing. That's one way to prove it. If I had some independent third party data that proved whatever I was claiming, I could show that there too. But a lot of times what we're doing is we're like, "Let me show you how this worked in a company that used our stuff. So this is what the before looked like. They did this thing, here's the after." And so customer case study is usually good way to do that, but there's usually a step called proof, which is, I showed you the value, now here's the proof that I can actually deliver on that value and it's not just me blowing smoke.
(00:59:16):
And then the step after that then is this optional objection step where they say, "Oh yeah, sounds good, but IT is never going to go for it," or "Sounds good, but maybe it's going to be too expensive," or something. And so you're going to handle that objection as best as you can. And then you finish with the ask, which is whatever the next step in your sales process is. So it's, "Hey, so what we have to do to get a deal cooking here, do we have to get IT involved? Does IT need to see it? Would you like us to come in and present with you with IT or do you want me to just help you work on some stuff for IT?" It's whatever your next step in the sales process is.

**中文翻译:**
……这部分真正聚焦于差异化价值。在第二部分，第一步通常是介绍我们的产品，这时“市场品类”就很重要了。我们说：“好了，我们是否同意一个好的方案应该满足这些条件？是的。太好了，现在谈谈我们。我们认同那个观点，这就是我们开发这款产品的原因。”
(00:57:36):
所以，“我是 Help Scout，我们是为数字业务设计的客户服务软件（或其他品类名）。” 我们介绍它只是为了让大家脑子里有个清晰的概念，然后转入：“这是价值，我们是这样实现的。” 如果一个典型的销售电话是半小时到 45 分钟，我预计会花一半以上的时间在这个差异化价值阶段。如果我们做演示，这就是演示环节，我们会说：“第一步，让我展示我们如何做到这一点。像收件箱一样易用，这是功能。永远不会不够用，这是功能。提供惊人的客户体验，这是功能。” 这才是你点击“预约演示”按钮时真正想看的核心内容。
(00:58:25):
这就是我们在那儿做的。最后我们以三个小环节结束。第一，通常我得向你展示一些“证明”，证明我能说到做到。如果我声称这能提供惊人的客户体验，我怎么证明？我可以展示其他客户的好评。如果我有独立的第三方数据，我也可以展示。但很多时候我们是说：“让我展示一下这在另一家公司是如何运作的。这是之前的情况，他们做了这个，这是之后的情况。” 客户案例研究通常是很好的方式。这个环节叫“证明”，即：我展示了价值，现在这是我能交付该价值的证据，而不是我在吹牛。
(00:59:16):
之后是可选的“异议处理”环节，客户可能会说：“听起来不错，但 IT 部门绝不会同意，” 或者 “听起来不错，但可能太贵了。” 你要尽力处理这些异议。最后，你以“请求”结束，即销售流程的下一步。比如：“嘿，为了推进这笔交易，我们需要让 IT 部门介入吗？IT 需要看演示吗？你希望我们和 IT 一起开个会，还是我帮你准备一些给 IT 看的资料？” 无论下一步是什么，这就是结尾。

---

### [01:00:21] Lenny

**English:**
Awesome. So let me read through this just to have it also succinctly here in case people are taking notes or trying to remember the stuff. So there's the setup, there's the follow through. Within the setup, you have the insight, the alternative approaches, pros and cons, in the perfect world. And then you introduce your product, talk about the differentiated value, share the proof of why it works, potentially handle objections, silent objections, and then the ask of what comes next.

**中文翻译:**
太棒了。让我简要复述一遍，方便大家记笔记或记忆。分为“铺垫”和“后续跟进”。铺垫包括：洞察、替代方案及其优缺点、理想世界。后续跟进包括：介绍产品、谈论差异化价值、分享成功的证明、处理潜在异议（包括沉默的异议），最后是关于下一步的请求。

---

### [01:00:34] April Dunford

**English:**
That's right. That's it.

**中文翻译:**
没错，就是这样。

---

### [01:00:34] Lenny

**English:**
In terms of knowing if this is working and if your differentiated value works or if your insight works, do you have kind of a heuristic of a success rate that feels right? How often should this work for you to feel like "I think we have it?"

**中文翻译:**
关于如何判断这是否奏效，以及你的差异化价值或洞察是否有效，你有没有一个感觉比较合理的成功率标准？达到什么样的频率，你才会觉得“我觉得我们找对路了”？

---

### [01:00:41] April Dunford

**English:**
Well, so generally if the sales pitch isn't working, it's because the positioning was weak.
(01:00:41):
And so companies that jumped straight to building the new sales pitch without going back and really making sure that they really nailed the differentiated value, who knows? Maybe it works, maybe it doesn't. And a lot of times it doesn't, I think. And so in the work I do with my clients, we go all the way back to the beginning. So we go right back to let's work on the positioning first. Now, if I've got the smartest people from the company in the room and we've done enough deals that we are pretty knowledgeable about how customers buy and what they like and what they don't know. If I've got the senior executive team in the room and they've got a reasonable amount of customer experience, we can pretty much feel good that the positioning we come up with if we're following a process will be good.
(01:01:25):
Then it's just a matter of taking that positioning, mapping it to the sales pitch and then going to test it. So I think there's a bunch of things in testing that are really important. So one is we absolutely need sales involved in building the pitch. If we don't have sales involved in building the pitch, the pitch is never going to stick. The rule with sales reps is even if they don't like their current pitch, they're comfortable with the current pitch and they know it and they've memorized it and they have a little joke they tell on slide three. So they're not going to give up the current pitch without a fight. So you got to get sales management involved in building a new pitch, and then I would never just build the new pitch and then heave it over the wall and say, "Good luck, Chuck." Because what'll happen is they'll come up with all kinds of excuses why they can't use this pitch.
(01:02:07):
Instead, what you do is you take your best sales rep, your best one, and you bring your best sales rep over and you train them on the new pitch. They got to learn it, they got to pitch it to you, pitch it to the head of sales. We do a bunch of repetition on that, and then we have that rep test the pitch with qualified prospects. So we don't go to existing customers. They've already been polluted with the old positioning and the old pitch, and this needs to work with a qualified prospect, so let's do it in the way it was intended. We're going to take qualified prospects and work that new pitch with them. Usually what we'll do is a test period where after every pitch we'll huddle and say, "What worked? What didn't work? Maybe that word is tripping people up. Maybe we need to move this slide from here to here," and so we'll tune it.
(01:02:53):
And then after we've done a bunch of pitches, one of two things happens. And so in this test structure, I am very much relying on the expertise of my best rep to know what's good. So after the best rep is comfortable with the pitch, done a bunch of pitches, re-twizzled it, at some point the rep will say, "Okay, I think we're done optimizing this pitch, and I'm not going back to the old pitch. I'm sticking with this pitch because I think this one works better." An experienced sales rep will know that, whether the pitch is better than the old pitch, if you give them the opportunity to feel comfortable with it, work with it a bit and pitch a bunch of new prospects with it.
(01:03:38):
So if your best sales rep says, "Oh, this is way better than the old pitch. I can just feel it from the way people react to it and the number of times we've been able to convert people over into actual opportunities from a first call." Then what you do is at that point I call that pass. So then we take that rep, we can film them doing the pitch for training, and then we can take that rep, go back to the rest of the sales team and have that rep sell everybody else on it. So that rep goes back and says, "Listen up people, you're stupid if you're using that old pitch, which sucks. This new pitch is way better. Trust me, I'm the best rep on this whole team. By the way here's the list of deals I have cooking in the pipeline that I got using this deck. You should go do it and I'm going to teach you how to do it."
(01:04:24):
Now I got sales, teaching sales, teach and sales instead of marketing, sort of throwing something over the wall and crossing their fingers and saying, "Hey, I hope this works." What we should see is an immediate uplift in what happens after first call. So most of the time what that is we get a higher percentage of deals converting into opportunities after that first substantive calls. Sometimes depending on the quality of the pipeline we had coming in, we're actually disqualifying more. But sometimes that's a good thing.
(01:04:54):
But what we should see is an immediate uptick. It's stuff coming into the pipeline. It's a neat trick to pull, especially right now when everybody's budgets are really tight and you're just trying to squeeze more juice out of the lemon. It's a really easy way to get some more juice out of the pipeline. Just go in, tighten up your positioning, tighten up that sales pitch. And we can have instant impact with that because we can roll that out in a couple of weeks and start getting better deals flowing through the pipeline because these customers are understanding your value better, understanding why to pick you better. It's just easy, low hanging fruit to do when the economy's bad.

**中文翻译:**
通常情况下，如果销售话术不起作用，那是因为定位太弱。
(01:00:41):
有些公司直接跳到构建新话术，而不回头确认是否真正抓住了差异化价值，结果谁知道呢？也许有用，也许没用，我觉得大多数时候是没用的。在我与客户合作时，我们会回到最开始，先处理定位。如果我让公司里最聪明的人聚在一起，而且我们做过足够多的交易，对客户如何购买、喜欢什么、不知道什么有足够的了解；如果高管团队也在场，且有丰富的客户经验，那么只要遵循流程，我们得出的定位通常会很好。
(01:01:25):
接下来的工作就是把定位映射到销售话术中，然后去测试。测试中有几点非常重要。第一，绝对需要销售人员参与构建话术。如果没有销售参与，这套话术永远无法落地。销售代表的规律是：即使他们不喜欢现有的推销方式，但他们已经习惯了，他们熟悉它、背下了它，甚至在第三张幻灯片有个固定的小笑话。他们不会轻易放弃现有的方式。所以你必须让销售管理层参与构建新话术。我绝不会关起门来写好话术，然后扔给销售说：“祝你好运。” 因为那样的话，他们会找出一万个理由说这套话术没法用。
(01:02:07):
相反，你应该找你最优秀的销售代表，最顶尖的那一个。把他请过来，对他进行新话术的培训。他得学会它，向你演示，向销售主管演示。我们进行多次重复练习，然后让这位代表去对“合格的潜在客户”进行实战测试。注意，不要找老客户，因为他们已经被旧定位和旧话术“污染”了。这套东西必须在合格的潜在客户身上生效，所以我们要按预定方式进行。我们会找合格的潜在客户，用新话术和他们谈。通常我们会设一个测试期，每次谈完后我们都会碰头讨论：“什么奏效了？什么没奏效？是不是那个词让大家困惑了？是不是要把这张幻灯片挪个位置？” 然后进行微调。
(01:02:53):
在进行了一系列实战后，会出现两种情况之一。在这个测试结构中，我非常依赖顶尖代表的专业判断。当顶尖代表熟悉了话术、谈了几次、微调了几次后，在某个时刻他会说：“好了，我觉得优化得差不多了。我不想再用旧话术了，我要坚持用这套，因为我觉得这套效果更好。” 一个经验丰富的销售代表会知道新话术是否优于旧话术，只要你给他机会去熟悉它、实操它。
(01:03:38):
如果你的顶尖代表说：“噢，这比旧的好太多了。从人们的反应以及我们从第一次通话转化为实际机会的次数就能感觉得出来。” 那么，这就叫“通过测试”。然后我们拍下这位代表演示这套话术的视频用于培训，再让他回到销售团队中，让他去向其他人推销这套话术。这位代表会回去说：“大家听好了，如果你还在用那套烂透了的旧话术，那你就是傻瓜。这套新话术好得多。相信我，我是全队最强的。顺便说一下，这是我用这套方案谈下来的订单列表。你们应该去用它，我来教你们怎么做。”
(01:04:24):
现在变成了“销售教销售”，而不是营销部门把东西扔过墙然后祈祷它有用。我们应该能看到第一次通话后的转化率立即提升。大多数情况下，这意味着更高比例的实质性通话转化为了销售机会。有时根据进来的线索质量，我们实际上会排除掉更多不合适的客户，但这有时是件好事。
(01:04:54):
但我们应该看到立竿见影的增长，即进入管线的项目变多了。这是一个很棒的技巧，尤其是在现在大家预算都很紧、你想从柠檬里挤出更多汁的时候。这是一个非常简单的从管线中获取更多价值的方法：进去，收紧定位，收紧销售话术。我们可以在几周内推广并看到效果，让更好的交易流向管线，因为客户更理解你的价值，更明白为什么要选你。在经济不景气的时候，这就是最容易摘到的“低垂的果实”。

---

### [01:05:32] Lenny

**English:**
To give people a sense of maybe how easy that might be, how long would you suggest people spend on maybe tweaking their positioning and then also on this pilot, how much total time could it take to potentially significantly increase sales?

**中文翻译:**
为了让大家有个概念，你建议人们花多长时间来调整定位？还有这个试点项目，总共需要多长时间才能看到销售额的显著增长？

---

### [01:05:45] April Dunford

**English:**
So in the customers that I work with, when we do the positioning stuff, the positioning stuff takes a week. We're beginning and we're done in a week. We're all about speed on this thing. We're trying to get the thing happening fast. So we're in and out on the positioning in a week. It might take you, it depends on the company, the bigger the company, the slower this is, but some big companies are actually quite fast, and if you're motivated, it shouldn't take long for us to take that pitch and make it real.
(01:06:11):
Then we got to find a rep, train the rep, and then how long it takes us to test it really depends on how much deal flow you've got. So if you're working on monster deals and you don't actually get that many qualified prospects to pitch, that might take a few weeks. But if you've got a lot of prospects coming through the door, and you can get through this fairly quickly. So I've had companies do it start to finish. We got new pitch out the door and people using it in two weeks. That's about as fast as you can get it done. Most folks, I would say take about a month.

**中文翻译:**
在我合作的客户中，做定位工作只需要一周。从开始到结束一周搞定。我们追求的是速度，想让事情快点发生。所以定位一周出结果。至于把定位转化为话术，这取决于公司规模，公司越大越慢，但有些大公司其实也很快。如果你动力十足，把话术做出来不需要太久。
(01:06:11):
然后我们要找一个代表，培训他。测试需要多长时间取决于你的交易流量。如果你做的是巨额交易，合格的潜在客户不多，那可能需要几周。但如果你有很多潜在客户上门，你可以很快完成。我见过有公司从头到尾两周就让新话术落地并投入使用了。这几乎是最快的速度了。大多数人，我会说大约需要一个月。

---

### [01:06:50] Lenny

**English:**
You mentioned marketing and earlier you said that marketing is involved in this process in some way. What's your advice to just how to involve marketing, where they fit in?

**中文翻译:**
你提到了营销部门，之前你也说营销部门会以某种方式参与这个过程。关于如何让营销部门参与进来，以及他们应该处于什么位置，你有什么建议？

---

### [01:06:58] April Dunford

**English:**
Yeah, so usually marketing is going to end up being the stewards of the positioning once the positioning is done. So they're going to end up being positioning police after this because a lot of the positioning stuff is going to take the form of marketing things. So they're invested in this. So when I was the VP marketing, I was the person that would instigate the positioning thing, let's get everybody together and work on the positioning. And then I would usually be the person that is driving, getting the sales pitch figured out, but it's me and sales and product working together. And then once the sales pitch is done, depending on the size of the organization and whether or not you have sales enablement or somebody inside sales that can babysit the pitch. Usually me and the head of sales would work on, "Okay, this is the pitch and this is locked down and we're not actually going to change this pitch until something happens that requires us to change the positioning. And then that's when we'll re-look at the pitch."
(01:07:55):
So we would look at recertifying the reps every quarter on the pitch and all that kind of stuff. And that would be generally, me in partnership with the head of sales. But it depends on how you do it. I don't think it really matters who owns it. If you have a good product marketing organization, good product marketing organization generally is very concerned with the positioning and the pitch, and those two things sit in their purview, but depends on how you define it. I can't wait till you get Airbnb. Tell us how this stuff works. They're different because they're a consumer, but companies are arranged in all different ways. So if you have product marketing, it looks one way. If you don't, it looks another way. Somebody's got to kind of be the owner of this thing though. And so we have to decide who that's going to be.

**中文翻译:**
是的，通常一旦定位完成，营销部门就会成为定位的“管家”。他们最终会成为“定位警察”，因为很多定位内容会转化为营销素材。所以他们对此有投入。当我担任营销副总裁时，我是发起定位工作的人，召集大家一起处理。然后我通常是推动制定销售话术的人，但我会和销售、产品部门合作。一旦话术定稿，取决于组织规模以及是否有销售赋能团队，通常我和销售主管会达成一致：“好了，这就是最终话术，已经锁定了。除非发生需要改变定位的大事，否则我们不会改动它。到那时我们才会重新审视话术。”
(01:07:55):
我们会考虑每季度对代表进行话术认证之类的。这通常是我和销售主管合作完成的。但这取决于你的具体做法，谁来主导并不重要。如果你有一个好的产品营销（PMM）团队，他们通常会非常关注定位和话术，这两件事属于他们的职责范围。这取决于你的定义。我等不及想听听 Airbnb 是怎么运作的了，他们是 C 端，情况不同。但公司架构各异，有 PMM 是一种样，没有又是另一种样。不过，总得有人来当这个“负责人”，我们需要决定是谁。

---

### [01:08:38] Lenny

**English:**
Just a couple more questions. One is to motivate people to do this. What kind of impact have you seen at companies that invest this time and rethink the way they pitch?

**中文翻译:**
最后还有几个问题。一个是关于动力：在那些投入时间重新思考推销方式的公司中，你看到了什么样的影响？

---

### [01:08:49] April Dunford

**English:**
Well, so people don't like me to talk about revenue stuff. Hugely what we've seen though is again, the immediate impact is felted sales, and everybody's very jazzed about that.
(01:09:00):
Impact is felt in sales, and everybody's very jazzed about that. Because sometimes what the worry is, is we've got this old positioning and they came in through the pipeline that way. So they were exposed to our marketing somewhere with this old positioning, and then we hit them with the new positioning with this sales pitch. And aren't they going to be all like, "Oh, you moved my cheese." And usually it ends up not being a problem at all. So usually what we see immediately is an uptick in what's happening in sales. And so I've had a couple of companies tell me they've doubled the number of deals that they're bringing from first sales call to opportunity just by tightening up the pitch and getting that going. I think that's not unusual. I worked at a company where we did it in-house where I was the VP marketing, and we, within two quarters, had doubled the revenue just by tightening up the pitch. Just tighten it up.

**中文翻译:**
人们不太喜欢我谈论具体的收入数据。但我们看到的巨大变化是，销售端能立即感受到影响，大家对此都非常兴奋。
(01:09:00):
因为有时人们担心：“我们有旧的定位，客户是通过旧定位进入管线的。他们在某处接触了旧定位的营销，然后我们突然在销售话术中抛出新定位，他们会不会觉得‘你动了我的奶酪’？” 事实证明这根本不是问题。通常我们能立即看到销售数据的提升。有几家公司告诉我，仅仅通过收紧话术，他们从第一次通话到转化为销售机会的成交量翻了一番。我认为这并不罕见。我曾在一家公司担任营销副总裁时亲手做过，我们在两个季度内通过收紧话术让收入翻了一番。仅仅是收紧了它。

---

### [01:09:53] Lenny

**English:**
Holy shit. All right. Tighten it up. No big deal.

**中文翻译:**
天呐。好吧。收紧它。没什么大不了的（笑）。

---

### [01:09:54] April Dunford

**English:**
It was a big shift in positioning, I'll tell you that. Not small. Most of the time, we're not doing that. Most of the time, it's a tightening. We're not saying, "Oh, we used to be this and now we're this." Most of the time, it's a tightening, but usually the pitches are so bad. I'm telling you they're so bad that there's this low hanging fruit there that if we could improve it even a little bit, it actually has this big impact on how much stuff survives down the pipe.

**中文翻译:**
那次定位的转变确实很大，我得承认。不是小打小闹。大多数时候我们不需要做那么大的变动，只是“收紧”。我们不是在说“哦，我们以前是 A，现在是 B”。大多数时候是优化，但通常大家的话术实在太烂了。我告诉你，真的烂到家了，所以那里有很多“低垂的果实”，只要稍微改进一点点，就能对管线中留存的项目数量产生巨大的影响。

---

### [01:10:25] Lenny

**English:**
And again, if folks want to go deep into the positioning step, your first book Obviously Awesome, is a great guide, and our first podcast episode goes through this. Plus you have a guest post in my newsletter where you give them a quick start guide. So there's so many tools to help you through this process.

**中文翻译:**
再次强调，如果大家想深入了解定位步骤，你的第一本书《显然很棒》（Obviously Awesome）是极佳的指南，我们的第一集播客也详细讨论过。此外，你在我的通讯（newsletter）中也写过一篇客座文章，提供了一个快速入门指南。所以有很多工具可以帮助大家完成这个过程。

---

### [01:10:39] Lenny

**English:**
The other thought I've had in the back of my mind as we've been chatting is a previous guest, Andy Raskin, has a different framework, feels similar, but I know they're different. His framework starts with a shift that's happened in the world, and then here's who's going to win in the shift, here's who's going to lose. And then he goes into why this product is the best. What's your perspective on that approach versus this approach and the big differences?

**中文翻译:**
在我们聊天时，我脑子里闪过的另一个念头是：我之前的一位嘉宾 Andy Raskin 有一套不同的框架，感觉有点像，但我知道它们不同。他的框架从“世界上发生的某种转变”开始，然后讲“谁会在这种转变中获胜，谁会失败”，接着才进入“为什么这个产品是最好的”。你如何看待他的方法与你的方法的区别？

---

### [01:11:01] April Dunford

**English:**
So the thing with that framework is I do think it works in certain conditions, but again, I think the conditions might be kind of edgy. So there's a couple of things that I think are lacking in that structure for a sales pitch. So the first one is there's actually no concept of differentiated value in that pitch, which for me is a giant miss. So in that pitch, it assumes that new is inherently valuable and old is inherently bad, and sometimes that's true. So sometimes there's just you versus the status quo and the status quo is some terrible old thing, some legacy thing or it's manual processes or something, and you're the only thing out there, then you can get away with that. But most of the time, we don't have that. Most of the time, there's multiple new ways of doing something and you just can't say, "Well, I'm the only new and the rest of you are old and bad."
(01:11:55):
So usually I've got to thread the needle. And so that's the first thing. The second thing is that for most companies, if we really understood customer and decision, old is good, it's safe, it's not risky. And does anybody ever say, "No, I'm not going to buy Salesforce. That's the old stuff,"? I just don't think that happens. So in a lot of cases, I don't think you can rely, it's lazy to say, "Buy this because it's new and new is better." Most of the time, the customers are going to want to know, well, what's better about it? Tell me what the value is that I can't get anywhere else. And you're going to have to get more specific than just saying, "Trust me, it's new and new is good." So that's the first thing. The second thing is this idea of starting with a trend. On the surface it looks kind of good, but the problem is often the trend is not unique to you. So everybody else sees the trend too. And so you are starting in a way that any of your competitors could start the same way.
(01:12:59):
I did this for years where I was taught to do problem solution. We would define the problem like a trend. We'd say, "Well, the change in the world." I was selling databases and I'd say, "Change in the world, data is exponentially growing." It's like, no shit. We all know that. All of my competitors could say that, and all of my competitors deal with the trend in the same way. So unless you have a particularly unique take on the trend, well, then it's not the trend at all really, is it? It's your insight into the trend. So I don't think trend is that great because it's not always unique to you. And ideally what we want is something that we can say that none of our competitors can. And typically a trend is something outside of our control. It's out in the world and everybody else can see it too.
(01:13:47):
So I don't think it's great. I think that structure looks a lot like the structure we use in a VC pitch or an investor pitch because we're talking about much longer timelines and we can say, "Look, the world is really changing and 10 years from now there's going to be chaos and destruction and the only one standing is us and therefore there is no competition." And because the timeframes are longer and we're talking about disruption of an entire market, which is pretty theoretical, we can get away with a lot of that stuff in investor pitch. In fact, we want to go there in investor pitch. Sales pitch is all about right now. Sales pitch is like, okay, I'm going to exchange my money for right now. You can't get too far into the future. Otherwise, all I'm doing is giving everybody a reason to delay, which they're likely to do anyway because they're indecisive about what they should do.

**中文翻译:**
那个框架我认为在某些特定条件下是有效的，但这些条件可能比较极端。我认为那个结构在销售话术中有几点缺失。第一，它实际上没有“差异化价值”的概念，对我来说这是一个巨大的失误。那个话术假设“新”本身就有价值，“旧”本身就是坏的。有时确实如此，比如只有你和现状竞争，而现状是某种糟糕的旧系统或手动流程，你是唯一的选择，那你可以这么说。但大多数时候并非如此。大多数时候，有多种“新”方法在竞争，你不能简单地说“我是唯一的新方法，你们其他人都是旧的、坏的”。
(01:11:55):
所以我必须精准切入，这是第一点。第二点是，对于大多数公司来说，如果我们真正理解客户的决策心理，“旧”意味着好、安全、无风险。有没有人会说“不，我不买 Salesforce，那是老古董”？我觉得不会。所以在很多情况下，我认为不能依赖“买这个因为它是新的，新就是好”，这太偷懒了。大多数时候，客户想知道：它到底哪里更好？告诉我我无法在别处获得的价值是什么。你必须比“相信我，新就是好”说得更具体。这是第一点。第二点是关于“以趋势开头”。表面上看不错，但问题是趋势通常不是你独有的，每个人都能看到趋势。这意味着你的任何竞争对手都可以用同样的方式开头。
(01:12:59):
我以前也这么干过，当时被教导要做“问题-解决方案”。我们会把问题定义得像个趋势。我会说：“看，世界在变。” 当时我在卖数据库，我会说：“世界在变，数据呈指数级增长。” 废话，大家都知道。我的所有竞争对手都会这么说，而且他们处理趋势的方式也大同小异。所以，除非你对趋势有特别独特的见解，否则那根本不是趋势，而是你的“洞察”。所以我认为“趋势”没那么好，因为它不总是你独有的。理想情况下，我们想说一些竞争对手说不出来的话。而趋势通常是我们无法控制的，是外部世界共见的。
(01:13:47):
所以我不觉得它很棒。我认为那个结构更像是 VC 演示或投资者演示的结构，因为那是关于更长的时间跨度，我们可以说：“看，世界正在发生巨变，10 年后将是一片混乱，只有我们能屹立不倒，所以没有竞争。” 因为时间跨度长，讨论的是整个市场的颠覆（这很理论化），在投资者演示中可以这么说。事实上，投资者演示就该这么说。但销售话术是关于“现在”的。销售话术是：“好，我现在要掏钱换你的东西。” 你不能扯太远的未来，否则你只是在给每个人提供推迟决策的理由——而他们本来就因为犹豫不决而倾向于推迟。

---

### [01:14:39] Lenny

**English:**
I feel like I need a debate version of this podcast where people come on and-

**中文翻译:**
我觉得我需要做一个辩论版的播客，让大家上来……

---

### [01:14:43] April Dunford

**English:**
I know, but here's the thing that I think people should think about when they're looking at all this stuff because it's terribly confusing if you're trying to figure this out. The one thing I really dislike about the category creation folks is they say that's the only way that you can be successful. And in general, that's just not true about anything. There's lots of ways to do everything. And so I think people should mess around with stuff. And for any of these frameworks, I think they should look at it and see if it works for them and their situation. And maybe it does, maybe it doesn't.
(01:15:16):
And I think they should steal things from wherever they can steal it and figure out what works in their own situation. My stuff, I like to think is a starting point, folks should use it as a starting point, but people shouldn't be slaves to it. There are lots of things that work at a market, and I think the only thing that we know for certain is that we can't say, "Well, this is the rule and it always works like this." If it was that easy, again, this wouldn't be so hard. We wouldn't have podcasts and newsletters and all kinds of things trying to figure this stuff out.

**中文翻译:**
我知道，但有一点我觉得大家在看这些东西时应该思考，因为如果你想弄明白，这确实非常令人困惑。我最不喜欢“品类创造”派的一点是，他们说那是成功的“唯一”途径。一般来说，任何事情都没有唯一的途径。做任何事都有很多方法。所以我认为大家应该多尝试。对于任何框架，都应该看看它是否适合自己和所处的情况。也许适合，也许不适合。
(01:15:16):
我认为大家应该从任何地方汲取灵感，找出适合自己的方法。我希望我的东西是一个起点，大家应该把它当作起点，但不应该成为它的奴隶。市场上有很多行之有效的方法，我认为唯一可以确定的是，我们不能说“这就是铁律，永远有效”。如果真那么简单，这事儿就不会这么难了，我们也就不需要播客、通讯和各种东西来研究它了。

---

### [01:15:49] Lenny

**English:**
Extremely true. Well, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
非常正确。那么，我们进入了非常令人兴奋的闪电问答环节。准备好了吗？

---

### [01:15:54] April Dunford

**English:**
Oh yeah. Lightning round. Oh gosh. It gives me stress. Okay.

**中文翻译:**
噢是的。闪电问答。天呐，压力好大。来吧。

---

### [01:15:58] Lenny

**English:**
Okay, question number one. What are two or three books that you've recommended most to other people?

**中文翻译:**
好，第一个问题。你向别人推荐最多的两三本书是什么？

---

### [01:16:04] April Dunford

**English:**
Well, that's an easy question. So right now I'm really into Matt Dixon's work right now, which we've mentioned him a couple of times on the podcast, but Matt Dixon's new book called The JOLT Effect is really great just because there's all this data and the things that he discovered with that data, a lot of it go against what we would consider accepted sales wisdom. And so I think that book is full of juicy nuggets and everybody should look at it. His previous book, The Challenger Sale, and there was a companion book to that called The Challenger Customer. Those were also excellent and based on a deep set of research. And those books are older now, but what we see in The JOLT Effect is all the stuff holds true. All the stuff from The Challenger Sale has not changed in 10 years. So I think those books together are really cool.
(01:16:54):
The other one that I always recommend is the original book on positioning, which is the book by Ries and Trout Positioning: The Battle for Your Mind. I have my copy of it, is dogeared. I probably read that book 100 times and I still see stuff in that book that I didn't see before. So I think if you really want to go deep on this positioning stuff, my book is the how to book. Their book is what is it in the first place book. And I think everybody that's interested in positioning should go read that.

**中文翻译:**
嗯，这个简单。我现在非常迷 Matt Dixon 的作品，我们在节目里提过他几次。他的新书《JOLT 效应》（The JOLT Effect）非常棒，因为里面有大量数据，他通过数据发现的很多东西都颠覆了我们公认的销售常识。我认为那本书干货满满，大家都该看看。他之前的书《挑战式销售》（The Challenger Sale）以及配套的《挑战式客户》（The Challenger Customer）也非常出色，都是基于深度研究。虽然那些书有些年头了，但在《JOLT 效应》中我们看到，那些结论依然成立。《挑战式销售》里的东西 10 年来都没变。所以我觉得这些书结合起来看很酷。
(01:16:54):
另一本我总是推荐的是关于定位的鼻祖，里斯和特劳特的《定位：争夺用户心智的战争》。我那本已经翻烂了，我可能读了 100 遍，但每次读依然能发现以前没注意到的东西。如果你想深入研究定位，我的书是“如何做”的手册，而他们的书是“它到底是什么”的基石。我觉得每个对定位感兴趣的人都应该读读那本书。

---

### [01:17:19] Lenny

**English:**
Amazing. By the way, I have your first book somewhere behind me there. I don't know where it is, but it's there.

**中文翻译:**
太棒了。顺便说一下，你的第一本书就在我身后的某个地方，我不知道具体在哪，但肯定在。

---

### [01:17:23] April Dunford

**English:**
I got mine right here so I can do this gag. There it is.

**中文翻译:**
我这儿也有一本，正好可以配合你演这出戏。就在这儿。

---

### [01:17:23] Lenny

**English:**
Nailed it.

**中文翻译:**
完美配合。

---

### [01:17:27] April Dunford

**English:**
There's the new one, there's the old one.

**中文翻译:**
这是新的，这是旧的。

---

### [01:17:27] Lenny

**English:**
The YouTube audience can see that trick that you've learned. Second question, what is a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
YouTube 的观众可以看到你练就的这个小把戏。第二个问题，最近你非常喜欢的电影或电视剧是什么？

---

### [01:17:36] April Dunford

**English:**
Oh man, I'm going to get in trouble for this. So you know Bong Joon-ho is the guy that did the movie Parasite?

**中文翻译:**
噢天呐，这个问题可能会让我惹麻烦。你知道奉俊昊吧，就是拍《寄生虫》的那个导演？

---

### [01:17:47] Lenny

**English:**
Yeah.

**中文翻译:**
知道。

---

### [01:17:47] April Dunford

**English:**
So [inaudible 01:17:48] before Parasite, there was this book called, this movie called Snow Piercer. It's really old. I think it came out in-

**中文翻译:**
在《寄生虫》之前，有一部电影叫《雪国列车》（Snow Piercer）。挺老的了，我想是……

---

### [01:17:54] Lenny

**English:**
I've seen that. Is that with the train?

**中文翻译:**
我看过。是关于火车的那部吗？

---

### [01:17:54] April Dunford

**English:**
2013. Have you seen it?

**中文翻译:**
2013 年出的。你看过？

---

### [01:17:54] Lenny

**English:**
Yeah.

**中文翻译:**
看过。

---

### [01:17:57] April Dunford

**English:**
So I love this movie so much. So recently I went on a train trip with my dad and before I went to the train trip, we got talking about trains. And then we all had to go watch Snow Piercer again. Like me and my daughter watching Snow Piercer. We're really into this movie. And it's funny, when it came out, I was working at a startup and the CEO came and said, "Seen any good movies lately?" And I was like, "Oh man, you got to see this movie Snow Piercer." And he went on a first date with a woman and he came back the next day and he was so mad. He was not just kind of mad. He was really mad at me. He was like, "That was the worst movie I've ever seen." I was like, "Dude, you should have told me you were going on a date. I didn't know."

**中文翻译:**
我太喜欢这部电影了。最近我和我爸去坐火车旅行，出发前我们聊到了火车，然后我们就全家又看了一遍《雪国列车》。我和我女儿一起看的，我们非常迷这部电影。有趣的是，这部电影刚上映时，我在一家初创公司工作，CEO 过来问：“最近看什么好电影了吗？” 我说：“噢伙计，你一定要看《雪国列车》。” 结果他带着一个女士去第一次约会时看了这部电影，第二天回来他气疯了。不是一般的生气，是非常生我的气。他说：“那是我看过的最烂的电影。” 我说：“老兄，你应该告诉我你是去约会的，我不知道啊。”

---

### [01:18:40] Lenny

**English:**
Yeah, that is my experience with that movie. I did not enjoy it, but I think you have to go into it [inaudible 01:18:46]

**中文翻译:**
是的，我对那部电影的感受也是那样。我不怎么喜欢，但我觉得看这部电影得带着某种特定的心态……

---

### [01:18:46] April Dunford

**English:**
It's polarizing. You either think it's amazing or you're like, that was terrible. What did I just watch?

**中文翻译:**
它的评价很两极分化。你要么觉得它太神了，要么觉得太烂了，心想“我到底看了个啥？”

---

### [01:18:52] Lenny

**English:**
This explains your taste in movies. We learned a lot about you, April. That movie is something else.

**中文翻译:**
这解释了你的电影品味。April，我们对你有了更深的了解。那部电影确实很特别。

---

### [01:19:00] April Dunford

**English:**
Did you see Parasite? That was amazing.

**中文翻译:**
你看过《寄生虫》吗？那部太棒了。

---

### [01:19:02] Lenny

**English:**
That was amazing. Very different. Not what I imagined. I didn't realize it was the same person.

**中文翻译:**
那部确实很棒。非常不同，完全出乎意料。我以前没意识到是同一个导演。

---

### [01:19:06] April Dunford

**English:**
Oh yeah.

**中文翻译:**
噢是的。

---

### [01:19:08] Lenny

**English:**
All right. Okay, cool. That's two movies for people to watch. I'm curious how people think of Snow Piercer.

**中文翻译:**
好了。酷。大家有两部电影可以看了。我也很好奇大家怎么看《雪国列车》。

---

### [01:19:13] April Dunford

**English:**
Be warned don't go on a date with this.

**中文翻译:**
警告：千万别带着约会对象去看。

---

### [01:19:16] Lenny

**English:**
Oh man, I still think about that movie sometimes. Next question, what is a favorite interview question you like to ask people that you're interviewing? Usually this is for when you're hiring, so whatever this comes up for you.

**中文翻译:**
噢伙计，我有时还会想起那部电影。下一个问题，你面试别人时最喜欢问的问题是什么？通常是在你招人时问的。

---

### [01:19:28] April Dunford

**English:**
So back when I was running teams internally back in my VP marketing days, I felt like a lot of marketing folks came with a certain amount of bad habits, particularly startup marketing folks. It's a bit of the wild west in marketing. And so sometimes they'd come in and you get into somebody new and they'd be really smart, but they learned something at the previous company that you're like, please never do that here. It's not going to work here. And so I developed a thing where I was just looking for attitude. Were you enthusiastic? Are you super into what we're doing here? And I can teach you pretty much anything. The only thing I can't teach you is persuasive writing. And I think that's a learnable skill. I think people can learn how to do persuasive writing.
(01:20:12):
I just don't have time to teach it to you myself. And so I used to give people a writing test, so I'd say, "Look, think of something you bought recently and write me two paragraphs and just sell me on it." And I used to love that test because people could either do it or they can't. And there's just so much stuff we end up doing in product marketing and marketing that involves a little bit of writing that it's kind of a foundational skill. And if you don't have that, that was the one thing I couldn't teach you.

**中文翻译:**
以前当我还在做营销副总裁带团队时，我觉得很多营销人员都带着一些坏习惯，尤其是初创公司的营销人员。营销领域有点像“西部荒野”。有时新人进来，他们很聪明，但在前一家公司学到的一些东西让你觉得：“求你了，千万别在这里这么干，这行不通。” 所以我总结出一套方法，我只看态度：你是否有热情？你是否真的对我们正在做的事感兴趣？我可以教你几乎任何东西，唯独教不了你“说服性写作”（persuasive writing）。虽然我认为这是可以习得的技能，但我没时间亲自教你。所以我以前会给应聘者一个写作测试，我会说：“听着，想想你最近买的一样东西，写两段话向我推销它。” 我非常喜欢这个测试，因为一个人行不行，一写就看出来了。在产品营销和日常营销中，有太多工作涉及写作，这是一种基础能力。如果你不具备，那是我唯一没法教你的东西。

---

### [01:20:42] Lenny

**English:**
Wow, that is fascinating. I've never heard of that as an interview question. And I love it. I feel like product managers-

**中文翻译:**
哇，太有意思了。我从未听过这种面试题。我很喜欢。我觉得产品经理……

---

### [01:20:47] April Dunford

**English:**
I stole it from a company that made me do it before I got hired, and I was like, this is a really smart thing. I'm [inaudible 01:20:53] stealing it. My thing was I got anxiety and I couldn't decide what product to write about, and I had literally just bought a new pair of running shoes. So I wrote two paragraphs about my new Brooks distance running shoes. But it was good. I got the job.

**中文翻译:**
我是从一家公司那里“偷”来的，我入职前他们就让我做过这个，我觉得这太聪明了。当时我很焦虑，不知道该写什么产品，正好我刚买了一双新跑鞋。于是我就写了两段关于我的 Brooks 长跑鞋的内容。效果不错，我拿到了那份工作。

---

### [01:21:09] Lenny

**English:**
It is an excellent segue to our next question, which is, is there a favorite product you've recently discovered that you really like?

**中文翻译:**
这正好引出了下一个问题：你最近有没有发现什么非常喜欢的、心头好的产品？

---

### [01:21:15] April Dunford

**English:**
Right now I'm kind of into, I don't even know how to describe this category of things, but things that are kind of low tech but are awesome. And so one of the category of things that I really love right now is I'm really into fountain pens. I don't know if you've ever written with a fountain pen. [inaudible 01:21:35]

**中文翻译:**
我现在有点迷上了一些……我甚至不知道该怎么描述这个类别，就是那种“低科技但很棒”的东西。我现在非常喜欢的一个品类是钢笔。我不知道你有没有用钢笔写过字。

---

### [01:21:35] Lenny

**English:**
I haven't, but I know what they are.

**中文翻译:**
没写过，但我知道钢笔。

---

### [01:21:36] April Dunford

**English:**
And so there's this company, Lamy, they're based in Germany, and they make the world's greatest fountain pens. They're beautiful, they're amazing. Some of them are really expensive. If you want to spend a lot of money on a pen, you can. But they have this one called the AL-Star, which is not an expensive pen. It's 20, $30. It may be expensive for a pen, but it's not so much money that you wouldn't feel bad if you lost it. So Lamy AL-Star. That's my great product lately. I don't have one right here. I should, it'd be a great prop to pick it up, but I actually don't have my bag here and it's in my bag. But Lamy AL-Star. You Google it. These are beautiful pens. And then if you haven't written with a fountain pen, it takes a minute to get used to it, but then it's like, gosh, it just feels great. You'll never write with a ballpoint pen again.

**中文翻译:**
有一家德国公司叫 Lamy（凌美），他们制造世界上最棒的钢笔。非常漂亮，非常神奇。有些非常贵，如果你想在笔上花大钱，完全可以。但他们有一款叫 AL-Star（恒星系列），并不贵，大约 20 到 30 美元。作为一支笔可能算贵的，但丢了也不会太心疼。Lamy AL-Star，这就是我最近心仪的产品。我现在手边没有，本来应该拿来当道具的，但我包没在身边，笔在包里。你可以去搜搜 Lamy AL-Star，非常漂亮。如果你没用过钢笔，可能需要一分钟适应，但一旦适应了，天呐，手感太棒了。你再也不想用圆珠笔了。

---

### [01:22:22] Lenny

**English:**
I was going to ask, is it the feel of the writing that you really enjoy about it?

**中文翻译:**
我正想问，你最喜欢的是不是那种书写的感觉？

---

### [01:22:25] April Dunford

**English:**
Feel. Totally different. Yeah. Amazing.

**中文翻译:**
就是手感。完全不同。是的，太神奇了。

---

### [01:22:29] Lenny

**English:**
I use Muji pens. I don't know if you know these pens.

**中文翻译:**
我用无印良品（Muji）的笔。不知道你知不知道。

---

### [01:22:31] April Dunford

**English:**
Oh yeah, these are actually really good. They're like roller ball pens, roller ball pen, very good, but not as good as the fountain pen.

**中文翻译:**
噢知道，那些其实也很好。它们是中性笔，非常好用，但还是比不上钢笔。

---

### [01:22:31] Lenny

**English:**
It's no fountain pen.

**中文翻译:**
确实比不上钢笔。

---

### [01:22:38] April Dunford

**English:**
The Muji pen is pretty good.

**中文翻译:**
无印良品的笔也挺不错的。

---

### [01:22:39] Lenny

**English:**
Then do you have to dip it in ink and stuff? How does that work?

**中文翻译:**
那钢笔是不是得蘸墨水之类的？怎么弄？

---

### [01:22:41] April Dunford

**English:**
No. You actually, they either come with a little cartridge that you stick in or if you feel bad about the environment, you don't want to be throwing out cartridges all the time, there's a refillable cartridge, so you basically just stick another thing and it sucks it up and yeah, you don't dip it in ink. That would be crazy. I can't take that on the airplane, man.

**中文翻译:**
不用。实际上，它们要么配有可以插进去的小墨囊，要么如果你觉得总扔墨囊不环保，也有可吸墨的转换器，你只需把它插进去吸墨就行。不用蘸墨水，那太疯狂了，我也没法带上飞机啊。

---

### [01:22:58] Lenny

**English:**
Confiscate your ink. All right, questions get a little more challenging potentially or really easy. Do you have a favorite life motto that you like to repeat to yourself, you like to share with people, that you find useful to come back to?

**中文翻译:**
没收你的墨水（笑）。好了，接下来的问题可能会更有挑战性，也可能很简单。你有没有什么最喜欢的人生格言，是你经常对自己重复、喜欢分享给别人，并且觉得很有用的？

---

### [01:23:11] April Dunford

**English:**
My thing lately is, and maybe this is just an old person thing, but my thing lately is nothing's a big deal. Nothing's a big deal, nothing's a big deal. And so you'll have stuff that you think is a really big deal, positive or negative, and you'll be like, wow, if this thing happened, it'd be so great, and then it happens and you're like, yeah, it's pretty great, but things are good otherwise, or it'll be the opposite. Like, oh, if this thing happened, it'd be so bad. Then it happens and you're like, that wasn't that bad. And so I don't know if this is good or bad, but lately I'm in this zone of I'm in this kind of chill zone where I'm like, nothing's a big deal, man. Everything's cool.

**中文翻译:**
我最近的感悟是——也许这只是年纪大了的表现——但我最近常想的是：“没什么大不了的。” 没什么大不了的，真的。有时你会遇到一些你认为非常重大的事情，无论是好是坏。你会想：“哇，如果这事成了，那就太棒了。” 结果成了，你觉得：“嗯，确实挺好，但生活也就那样。” 或者反过来：“噢，如果这事发生了，那就太糟了。” 结果发生了，你觉得：“其实也没那么糟。” 我不知道这算好还是坏，但我最近处于一种非常放松的状态，觉得：“伙计，没什么大不了的，一切都挺好。”

---

### [01:23:56] Lenny

**English:**
That super resonates. And as much as you say that to yourself, it's still hard to convince yourself of that sometimes. But that is a really good motto. I'm going to steal that myself. I kind of say that to myself often in different way.

**中文翻译:**
这非常有共鸣。虽然你对自己这么说，但有时还是很难真正说服自己。不过这确实是一句很好的格言。我要把它偷过来用。我经常以不同的方式对自己说类似的话。

---

### [01:24:08] April Dunford

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:24:10] Lenny

**English:**
What is the most valuable lesson your mom or your dad taught you?

**中文翻译:**
你父母教给你的最宝贵的一课是什么？

---

### [01:24:15] April Dunford

**English:**
Yeah, it is funny because it's a little bit related to that. So my dad ran a business, so I grew up in a really small town and my dad and it's cottage country in Canada. And so my dad ran the local toys for tourists, like boats and motorcycles and ATVs and that sort of thing. And he ran that business for years and years and he sold it a few years back when he retired. But it's a neat thing to grow up in entrepreneurial family because you kind of see this highs and lows. The business is really good. Then the business was really bad and then we were all broke and then the business was good and we were not broke. So there was this thing, and my dad used to always kind of have this attitude of you just got to grind it out.
(01:25:01):
You're just going to grind it out. There's going to be good stuff, there's going to be bad stuff, but the key is to just keep going, just keep going. And so he ran that business for whatever, 30, 40 years. I don't know. His motto is the home of fun since '71. So he started it in '71. I think he sold it three, four years ago. So a long time.

**中文翻译:**
很有趣，这和刚才说的有点关系。我父亲经营着一份生意。我在加拿大的一个小镇长大，那里是度假胜地。我父亲经营着一家专门卖给游客“大玩具”的店，比如船、摩托车、全地形车（ATV）之类的。他经营了很多很多年，几年前退休时才卖掉。在创业家庭长大是一件很酷的事，因为你会看到起起落落。生意好的时候非常好，差的时候非常差，全家都快破产了，然后生意又好转了。所以我父亲总是有一种态度：“你只需要熬过去（grind it out）。”
(01:25:01):
你只需要熬过去。会有好事，也会有坏事，但关键是继续前进，不停地走下去。他经营那份生意大概有 30、40 年吧。他的座右铭是“自 71 年以来的欢乐之家”。他 1971 年开店，三四年前卖掉的。真的很久。

---

### [01:25:21] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:25:22] April Dunford

**English:**
It all worked out good in the end. And so I don't know, I think there's something cool about growing up in a family where you can see the highs and lows and then again be like everything's we're just grinding it out over here. Nothing's a big deal.

**中文翻译:**
最后结果都挺好。所以我不知道，我觉得在能看到高潮和低谷的家庭长大很酷，这让你觉得：“我们只是在努力熬过去，没什么大不了的。”

---

### [01:25:34] Lenny

**English:**
It's clear where all that comes from now.

**中文翻译:**
现在很清楚你那种性格是从哪儿来的了。

---

### [01:25:37] April Dunford

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:25:37] Lenny

**English:**
Final question. You do a lot of traveling, you do a lot of speaking, you go to a bunch of cities. I'm curious just what is your favorite either city that you go to that maybe people may not know about or venue that you speak at?

**中文翻译:**
最后一个问题。你经常出差、演讲，去过很多城市。我很想知道，你最喜欢的城市（也许是大家不太熟悉的）或者你最喜欢的演讲场馆是哪里？

---

### [01:25:49] April Dunford

**English:**
It's such a cliche, but I love Paris. I just love it. But for me, Paris is like a particular vibe. So when I was in university, I did an exchange when I was in engineering and I did third year engineering at a school just outside of Paris. And so I spent the whole year there, learned a bit of French. My French was pretty good at the end. My French is really bad now. So I kind of get Paris. I like Paris. And so when I go to Paris, I just have the best time. I have my set of restaurants I want to go to. I have my handful of places I want to go shopping. I put my butt down in a cafe, look at the beautiful people, drink my nice coffee. I just really dig the whole vibe of Paris and people are starting to know that now. So French companies will call me and they'll say, "Do we get a Paris discount? We hear you like coming here." And I go, "Okay."

**中文翻译:**
虽然很老套，但我真的很爱巴黎。我就是喜欢那里。对我来说，巴黎有一种独特的氛围。大学时我学工程，大三那年我在巴黎郊外的一所学校做交换生。我在那里待了一整年，学了点法语。当时法语还不错，现在很烂了。所以我很懂巴黎。每次去巴黎我都过得非常开心。我有必去的餐厅清单，有固定的购物去处。我会坐在咖啡馆里，看着来往的美丽的人们，喝着美味的咖啡。我非常迷恋巴黎的氛围，现在大家都知道这一点了。所以法国公司打电话给我时会问：“既然你这么喜欢来这儿，能给我们个‘巴黎折扣’吗？” 我说：“行吧。”

---

### [01:26:50] Lenny

**English:**
Now this is going to [inaudible 01:26:51]

**中文翻译:**
现在这事儿要传开了（笑）。

---

### [01:26:51] April Dunford

**English:**
There's a great product management conference there called La Product Conference run by these folks at Tega, shout out to Tega. So I've been there a number of times for their conferences and they do an amazing job and the venue is really great. It changes around. But last year, the last time I went there, which was two years ago, it was at an old theater in [inaudible 01:27:13]. Absolutely beautiful. And that was a pretty great venue in a great city with a great conference. So yeah, shout out to French people.

**中文翻译:**
那里有一个很棒的产品管理会议叫 La Product Conference，是由 Tega 的朋友们举办的，向 Tega 致敬。我去参加过好几次他们的会议，他们做得非常出色，场地也很棒。场地会变，但我最后一次去（两年前）是在一个古老的剧院里，绝对美轮美奂。在伟大的城市举办伟大的会议，还有伟大的场馆。所以，向法国朋友们致敬。

---

### [01:27:22] Lenny

**English:**
Oh man. That sounds dreamy. Paris. I see how that could be a favorite. April, I think we accomplished everything we were hoping to accomplish. I think everyone that has listened to this podcast is going to be better at pitching and selling. It feels like even if they take one element of this framework, say starting with an insight or focusing on different value will make them better. And so I'm proud of us. Thank you so much for doing this. Two final questions. Where can folks find you online if they want to reach out and how can listeners be useful to you?

**中文翻译:**
噢伙计，听起来像梦一样。巴黎，我明白为什么它是你的最爱了。April，我想我们完成了预定的所有目标。我相信听过这期节目的每个人在推销和销售方面都会有所提升。感觉即使他们只采用这个框架中的一个元素，比如从洞察开始，或者专注于差异化价值，都会让他们变得更强。我为我们感到自豪。非常感谢你参加节目。最后两个问题：如果大家想联系你，可以在哪里找到你？听众可以为你做些什么？

---

### [01:27:50] April Dunford

**English:**
So where can people find me? I'm aprildunford.com. The only social media I'm doing these days is LinkedIn. I'm a bit social media-ed out. I'm experimenting a little on threads and Instagram, but LinkedIn is a good place to find me if you just want low lift way to follow my stuff. But I'm doing all the things now, Lenny, I got a podcast, it's called Positioning with April Dunford. I got a newsletter that's also called Positioning. You can find that if you go to, it's on Substacks, you can find it there, otherwise aprildunford.com/books and you can sign up there. But those are the big things. And then there's the books, obviously, if you want to learn more about this stuff. Everything I know is in the book. There isn't stuff that I know that isn't in the book to be honest.

**中文翻译:**
大家可以在哪里找到我？我的网站是 aprildunford.com。这些天我唯一活跃的社交媒体是 LinkedIn，我对社交媒体有点倦怠了。我也在尝试 Threads 和 Instagram，但如果你只想简单地关注我的动态，LinkedIn 是最好的地方。不过 Lenny，我现在什么都在做：我有一个播客叫《Positioning with April Dunford》，还有一个同样叫《Positioning》的通讯，你可以在 Substack 上找到，或者去 aprildunford.com/books 订阅。这些是主要渠道。当然还有我的书，如果你想深入了解，我所知道的一切都在书里了。老实说，我没有什么压箱底的知识是没写进书里的。

---

### [01:28:34] Lenny

**English:**
Amazing. And then how can listeners be useful to you? Just check out those things.

**中文翻译:**
太棒了。那听众能为你做点什么？就是去关注这些东西吗？

---

### [01:28:37] April Dunford

**English:**
I guess so. You know what? I'm in this phase. I think, again, I think it's an old age thing. I am in this kind of philosophical phase where I'm not going to be doing this forever. And what I'm trying to do right now is get everything that's useful out of my head and out in the world before I'm done. And so right now I'm very focused on delivering useful things for other people. I didn't think I needed to write a book about sales pitches, but then I got the idea in my head, everybody's sales pitch is so bad and there isn't a book on how to build a sales pitch. And I'm not saying mine's the world's greatest thing, but it's better than nothing. So this is what I'm trying to do right now. I'm trying to be useful to other people because pretty soon I'm not going to be doing anything, I think is the idea.

**中文翻译:**
我想是的。你知道吗？我正处于这样一个阶段——我想这又是年纪大了的表现——我处于一种哲学思考期，觉得自己不会永远做这件事。我现在想做的，就是在退休前把我脑子里所有有用的东西都掏出来，分享给世界。所以我现在非常专注于为他人提供有用的东西。我以前没想过要写一本关于销售话术的书，但后来我意识到大家的销售话术都太烂了，而且市面上竟然没有一本教人如何构建销售话术的书。我不是说我的书是世界上最伟大的，但总比没有强。这就是我现在的追求：尝试对他人有用。因为我觉得，很快我就什么都不想干了。

---

### [01:29:29] Lenny

**English:**
Arnold Schwarzenegger's new book is called Be Useful. And I feel like that's the perfect description of how to be successful and especially in the work that we do, just helping people. But I keep coming back to that. It's just be useful.

**中文翻译:**
阿诺德·施瓦辛格的新书就叫《做个有用的人》（Be Useful）。我觉得这是对如何获得成功最完美的描述，尤其是在我们所做的工作中，就是帮助他人。我总是回到这一点：只要做到“有用”就好。

---

### [01:29:41] April Dunford

**English:**
I think this is a really important thing. When I wrote the first book, people started writing back to me and saying, "Oh, your book was so great." And my reflex action was to say, "Oh, I'm glad you enjoyed it." But then I stumped myself and I was like, you know what? I don't actually care if you enjoyed it. This isn't entertainment. I'm actually trying to create something that's useful. So what I really want is for people to read this stuff and come back and say, "That was useful. We were struggling with this thing, and that unlocked something for me and that was useful." And that's what I'm trying to do right now.

**中文翻译:**
我认为这非常重要。当我写第一本书时，人们开始给我回信说：“噢，你的书太棒了。” 我的本能反应是说：“噢，很高兴你喜欢它。” 但后来我反思了一下，我想：你知道吗？我其实并不在乎你是否“享受”阅读它，这不是娱乐。我是在尝试创造一些有用的东西。所以我真正想要的是，人们读完后回来告诉我：“这很有用。我们之前在这个问题上很挣扎，你的书为我解开了心结，这很有用。” 这就是我现在的目标。

---

### [01:30:11] Lenny

**English:**
April, thank you so much for being here. This was amazing.

**中文翻译:**
April，非常感谢你能来。这期节目太精彩了。

---

### [01:30:14] April Dunford

**English:**
Thanks so much. It's always good to be here.

**中文翻译:**
非常感谢。来到这里总是很愉快。

---

### [01:30:17] Lenny

**English:**
Always good to have you here. And we might do a V3 when you do a third book if you ever-

**中文翻译:**
很高兴你能来。如果你以后写第三本书，我们可能会做第三版访谈……

---

### [01:30:21] April Dunford

**English:**
No, not happening.

**中文翻译:**
不，不会有第三本了（笑）。

---

### [01:30:25] Lenny

**English:**
Okay. All right. Well, bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
好吧。好的。那么，大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期节目再见。