# April Dunford - 双语对照

以下是 Lenny’s Podcast 与 April Dunford 访谈的完整双语对照文档。

---

### (00:00:04) Lenny

**English:**
If your product isn't doing well, there's a chance that it may not be the product that's the problem, it may be your positioning. And there's no one I've learned more from about how to very practically and tactically think about your positioning than from April Dunford.

**中文翻译:**
如果你的产品表现不佳，很有可能问题不在于产品本身，而在于你的定位（Positioning）。关于如何非常务实且讲求策略地思考定位，我从 April Dunford 那里学到的东西比从任何人都多。

---

### (00:00:17) Lenny

**English:**
April is the best selling author of the book, Obviously Awesome, which many consider an industry bible on product positioning. She's also led teams at seven successful B2B startups, worked with over 200 companies, helping them nail their positioning, and has almost certainly done more positioning work than any human alive.

**中文翻译:**
April 是畅销书《显然很棒》（*Obviously Awesome*）的作者，许多人将此书视为产品定位领域的行业圣经。她还曾在七家成功的 B2B 创业公司领导过团队，与超过 200 家公司合作帮助他们精准定位，而且她所做的定位工作几乎肯定比目前世界上任何人都多。

---

### (00:00:34) Lenny

**English:**
Also, April's guest post in my newsletter, A Quickstart Guide to Positioning is still one of the most popular posts of all time in my newsletter and one I share often with founders. I had a total blast speaking with April, and I hope you learn as much from this conversation as I did.

**中文翻译:**
此外，April 在我的时事通讯中发表的客座文章《定位快速入门指南》至今仍是我所有文章中最受欢迎的 Top 20 之一，也是我经常分享给创始人们的一篇。和 April 的交谈非常愉快，我希望你能从这次对话中学到和我一样多的东西。

---

### (00:00:52) Lenny

**English:**
This episode is brought to you by Amplitude, the number one product analytics solution. Amplitude helps product teams, growth teams, marketing and data teams build winning products, faster and turn products into revenue.

**中文翻译:**
本期节目由 Amplitude 赞助播出，它是排名第一的产品分析解决方案。Amplitude 帮助产品团队、增长团队、营销和数据团队更快地打造制胜产品，并将产品转化为收入。

---

### (00:01:05) Lenny

**English:**
Amplitude has everything you need, including an integrated CDP, self-service analytics and even an experimentation platform to help you better understand your users, drive conversions and increase engagement, growth, and revenue.

**中文翻译:**
Amplitude 拥有你所需的一切，包括集成的 CDP（客户数据平台）、自助式分析，甚至还有一个实验平台，帮助你更好地了解用户、驱动转化并提高参与度、增长和收入。

---

### (00:01:18) Lenny

**English:**
Amplitude is built for teams that want to learn as fast as they ship and ship as fast as they learn, ditch your vanity metrics, trust your data, work smarter and grow your business. With over 1,700 customers like Atlassian, Instacart and HBO, Amplitude is helping companies build better products. Try Amplitude for free. Visit amplitude.com to get started.

**中文翻译:**
Amplitude 专为那些希望“交付多快，学习就有多快”的团队而设计。告别虚荣指标，信任你的数据，更聪明地工作并实现业务增长。Amplitude 拥有超过 1,700 家客户，包括 Atlassian、Instacart 和 HBO，正助力各家公司打造更好的产品。免费试用 Amplitude，请访问 amplitude.com 开始体验。

---

### (00:01:40) Lenny

**English:**
This episode is brought to you by Flatfile. Think of the last time you imported a spreadsheet. Did it work the first time? Chances are it did not. You probably got some weird error, had to try a bunch of things like removing the blank title rows above your column headers, or Googling how to save with UTF-8 encoding.

**中文翻译:**
本期节目由 Flatfile 赞助。回想一下你上次导入电子表格的情景。第一次成功了吗？很可能没有。你可能遇到了奇怪的错误，不得不尝试各种办法，比如删除列标题上方的空白行，或者去谷歌搜索如何以 UTF-8 编码保存。

---

### (00:01:56) Lenny

**English:**
What even is UTF? Who cares? You're just trying to get your file where it needs to go so you can do your actual job. Your customers run into the same issues when it matters most, right after signing up for your product. Enter Flatfile.

**中文翻译:**
UTF 到底是什么？谁在乎呢？你只是想把文件传到该去的地方，好让你能开始干正事。你的客户在最关键的时刻——也就是刚注册完你的产品后——也会遇到同样的问题。这时候就需要 Flatfile 了。

---

### (00:02:08) Lenny

**English:**
Flatfile is the data onboarding platform built to take the acute pain out of importing customer data into your product so they can see the magic that you promised them. Flatfile is SOC type 1 and 2 certified, GDPR compliant, and even HIPAA complaint, ensuring your customers, no matter where in the world they're located are sharing their data securely and in compliance every step of the way.

**中文翻译:**
Flatfile 是一个数据导入（Data Onboarding）平台，旨在消除将客户数据导入产品的剧烈痛苦，让他们能立刻看到你承诺的“奇迹”。Flatfile 通过了 SOC 1 类和 2 类认证，符合 GDPR，甚至符合 HIPAA 医疗合规要求，确保你的客户无论身处何地，都能在每一步中安全合规地共享数据。

---

### (00:02:29) Lenny

**English:**
No more emailing files back and forth, no more help articles that just don't land, just clean data on day one, when it matters most. Get started importing millions of rows of customer data in minutes at flatfile.com/lenny.

**中文翻译:**
不再需要反复通过邮件发送文件，不再需要那些没用的帮助文档，在最关键的第一天就能获得干净的数据。现在就访问 flatfile.com/lenny，在几分钟内开始导入数百万行客户数据。

---

### (00:02:50) Lenny

**English:**
April, thank you so much for being here. You're a legend. I am humbled to chat with you and to learn from you, and honestly I am. And your guest post on-

**中文翻译:**
April，非常感谢你能来。你是个传奇。能和你聊天并向你学习，我感到非常荣幸，真的。你在我那里的客座文章……

---

### (00:03:00) April Dunford

**English:**
Lenny, you're the legend around here, not me.

**中文翻译:**
Lenny，你才是这里的传奇，不是我。

---

### (00:03:02) Lenny

**English:**
No, no, no. Let's not-

**中文翻译:**
不，不，不。咱们别……

---

### (00:03:02) April Dunford

**English:**
You're the guy. You're like Madonna. You're just a one-name guy now. You're Lenny, the Lenny.

**中文翻译:**
你就是那个大人物。你就像麦当娜一样，现在大家只叫你的名字就行了。你是 Lenny，那个唯一的 Lenny。

---

### (00:03:09) Lenny

**English:**
I don't know what to do with that. I'm just going to move on. I appreciate it. Anyway, welcome to the podcast.

**中文翻译:**
我不知道该怎么接这话了，咱们继续吧。谢谢你的夸奖。总之，欢迎来到本播客。

---

### (00:03:17) April Dunford

**English:**
So good to be here. Thanks for having me.

**中文翻译:**
很高兴来到这里。谢谢你的邀请。

---

### (00:03:19) Lenny

**English:**
Of course. I was also going to say that your guest post on positioning on my newsletter is still in the top 20 most popular all-time posts. I keep coming back to it. People keep telling me how useful it is. I keep sending it to founders. And so I'm just excited to dive a lot deeper on this topic.

**中文翻译:**
那是肯定的。我刚才还想说，你在我时事通讯上写的关于定位的客座文章，至今仍是有史以来最受欢迎的前 20 篇之一。我经常翻看它，人们也一直告诉我它有多有用。我经常把它发给创始人。所以我非常兴奋能就这个话题进行更深入的探讨。

---

### (00:03:32) April Dunford

**English:**
Cool.

**中文翻译:**
太棒了。

---

### (00:03:33) Lenny

**English:**
All right, let's do it. So for listeners who maybe aren't super familiar with your background and how you came to be such an expert on positioning, could you just briefly share your journey to what you do today?

**中文翻译:**
好，那我们开始吧。对于那些可能不太熟悉你的背景，以及你是如何成为定位专家的听众，你能简要分享一下你走到今天的历程吗？

---

### (00:03:44) April Dunford

**English:**
Yeah, sure. So my background is I didn't study marketing in school, I studied engineering. Straight out of engineering school, I got a job, a product marketing job at a startup. And I've been doing this a long time, so this was back when startups weren't even cool and we just called them small companies.

**中文翻译:**
好的。我的背景是这样的：我在学校不是学营销的，而是学工程的。工程学院毕业后，我直接在一家创业公司找到了一份产品市场营销（PMM）的工作。我做这行很久了，那时候创业公司甚至还不流行，我们只管它们叫“小公司”。

---

### (00:04:01) April Dunford

**English:**
So I got a job at a little company and then that company, I was assigned to a product that was kind of a loser and we weren't selling very much. We ended up repositioning it and the thing took off, it got hugely successful. That company got acquired, my boss quit and they made me the vice president of marketing. I still have no idea why. And then I decided, well, this is my jam, this is what I do now.

**中文翻译:**
我在那家小公司工作，当时我被分配到一个表现很差的产品上，销量惨淡。后来我们重新定位了它，结果产品一飞冲天，获得了巨大的成功。那家公司后来被收购了，我的老板辞职了，他们让我当了营销副总裁（VP Marketing），我至今都不知道为什么。然后我意识到，这就是我的拿手好戏，这就是我以后要干的事。

---

### (00:04:24) April Dunford

**English:**
And in particular, we had a handful of products there, the positioning also seemed kind of weak. And so I embarked on this journey of, hey, positioning seems to be really important because when we get it wrong, everything sucks, and when we get it right, we all make all kinds of money, so I should figure out how to do this properly.

**中文翻译:**
特别是在那家公司，我们还有几个产品，定位看起来也挺弱的。于是我开始了这段探索之旅：定位似乎非常重要，因为一旦搞错，一切都很糟糕；而一旦搞对，大家都能赚大钱。所以我得弄清楚到底该怎么正确地做定位。

---

### (00:04:43) April Dunford

**English:**
And so I read a bunch of books, took a bunch of courses and what I discovered is that positioning is this foundational marketing concept, but we didn't really have a methodology for doing it. And so from that point forward, I became a repeat vice president of marketing at a series of startups. So I think I did seven and six of those got acquired.

**中文翻译:**
我读了很多书，上了一堆课，结果发现定位虽然是一个基础的营销概念，但我们并没有一套真正的执行方法论。从那时起，我先后在多家创业公司担任营销副总裁。我大概做了七家，其中六家都被收购了。

---

### (00:05:04) April Dunford

**English:**
So I repositioned a lot of products across that and positioning became my specialty. Basically, if you were looking for a vice president of marketing and I came into the interview, the reason you hired me is because your positioning was crappy and I could talk intelligently about how we were going to fix that.

**中文翻译:**
在这个过程中，我为很多产品重新做了定位，定位也成了我的专长。基本上，如果你在招营销副总裁而我去面试，你雇我的原因一定是你们的定位很烂，而我能条理清晰地告诉你我们将如何修复它。

---

### (00:05:21) April Dunford

**English:**
And then about five, six years ago, I decided I wanted to go do something different and so I made the switch to consulting and now that's all I do. So I basically do positioning. Even more specifically though, I really focused on, I only do tech companies. I only do B2B companies, because my background is all really B2B and I don't really get consumer.

**中文翻译:**
大约五六年前，我决定尝试一些不同的事情，于是转行做咨询，现在这就是我的全部工作。我基本上只做定位咨询。更具体地说，我专注于科技公司，而且只做 B2B 公司，因为我的背景全是 B2B，我不太懂 C 端消费者业务。

---

### (00:05:43) April Dunford

**English:**
And mainly I work with startups. For the most part it's what I would call a growth stage startup, post series A, series B, but occasionally I do some really, really big companies that have weird positioning stuff going on, like they've acquired a bunch of things and they're trying to turn it into a business unit or something and there's no story around that. So that's how I got here.

**中文翻译:**
我主要和创业公司合作。大部分是我所说的增长阶段创业公司，即 A 轮或 B 轮之后。但偶尔我也会服务一些非常大的公司，它们可能面临奇怪的定位问题，比如收购了一堆业务，正试图把它们整合进一个事业部，但却讲不出一个完整的故事。这就是我走到今天的过程。

---

### (00:06:04) Lenny

**English:**
Awesome. To set a little color, I guess, how many companies have you worked with at this point and helped with positioning?

**中文翻译:**
太棒了。为了让大家有个直观感受，到目前为止，你大约和多少家公司合作并帮助他们做过定位？

---

### (00:06:10) April Dunford

**English:**
It's around 200-

**中文翻译:**
大概 200 家左右。

---

### (00:06:11) Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### (00:06:11) April Dunford

**English:**
... I think. I think, I suspect that I have done more positioning than anybody on the planet.

**中文翻译:**
……我想是的。我怀疑我做的定位工作比地球上任何人都多。

---

### (00:06:18) Lenny

**English:**
I was just going to say that.

**中文翻译:**
我正想这么说。

---

### (00:06:19) April Dunford

**English:**
That's my suspicion. I certainly have positioned more B2B tech companies than anybody. I don't know how anybody's going to get me on that one.

**中文翻译:**
这是我的直觉。我为 B2B 科技公司做定位的数量肯定是最多的，我想不出谁能在这方面超过我。

---

### (00:06:27) Lenny

**English:**
I would not be surprised. Okay, so I'm excited to learn a lot from our conversation along those lines. I'm curious, what's the most interesting or unusual company that you've worked with around positioning and what happened there?

**中文翻译:**
我一点也不意外。好，我很期待能从这次对话中学到很多。我很好奇，在你合作过的公司中，关于定位最有趣或最不寻常的是哪一家？当时发生了什么？

---

### (00:06:39) April Dunford

**English:**
The fun part about positioning is that when you do this kind of work, you get to dive into a market that maybe you haven't thought very much about. So it's like, I'm going to drop some names, but this week I'm working with Epic Games on a product that they have called Twinmotion, which is absolutely mind-blowing tech. You should look at it.

**中文翻译:**
做定位最有趣的地方在于，你可以深入研究一个你可能从未仔细思考过的市场。比如，我提几个名字，这周我正和 Epic Games 合作，针对他们一个叫 Twinmotion 的产品，那技术绝对令人震撼，你应该去看看。

---

### (00:07:01) April Dunford

**English:**
I don't come from that world of doing three dimensional graphic stuff, and so it's fun to just do a big, deep dive on that and look at everything in the space and look at what's possible and what isn't possible there.

**中文翻译:**
我不是搞 3D 图形那个圈子的，所以深入研究那个领域、观察空间里的所有事物、探索什么是可能的、什么是不可能的，这非常有趣。

---

### (00:07:12) April Dunford

**English:**
And so I've done everything from stuff like that to I come from databases. And so I have a lot of companies doing deep data stuff and data analytics stuff, which I find really interesting and cool, but then occasionally you'll get one that makes you think about your life differently.

**中文翻译:**
我做过各种各样的项目，我本身是做数据库出身的。所以我有很多客户在做深度数据和数据分析，我觉得这很有趣也很酷。但偶尔，你会遇到一个让你对生活产生不同思考的项目。

---

### (00:07:28) April Dunford

**English:**
I did one a year or so ago and the company's called Bluelight Analytics. And what they do is technology for helping certain kinds of dentistry instruments work better. And so I didn't really think much about what happens in the dentist office until I went to do this workshop.

**中文翻译:**
大约一年前我做过一个项目，公司叫 Bluelight Analytics。他们做的技术是帮助某些牙科器械更好地工作。在参加那个工作坊之前，我从未真正思考过牙科诊所里到底在发生什么。

---

### (00:07:47) April Dunford

**English:**
And then we spent the whole time talking about it's terrifying actually, half the stuff that a dentist does in your mouth is very likely to fail because the equipment is terrible and the way they actually do things like cure fillings is actually really terrible. And so sometimes I learn things in these workshops that I wish I didn't know. I'm a little bit scared going to the dentist now.

**中文翻译:**
然后我们整场都在讨论，其实挺恐怖的，牙医在你嘴里做的很多操作有一半都很容易失败，因为设备很糟糕，而且他们填充补牙的方式其实也很糟糕。所以有时候我在这些工作坊里学到的东西，我宁愿自己不知道。我现在去牙医那儿都有点害怕了。

---

### (00:08:07) Lenny

**English:**
Oh man, sounds like they-

**中文翻译:**
天哪，听起来他们……

---

### (00:08:08) April Dunford

**English:**
Sorry to the Bluelight guys, but yeah.

**中文翻译:**
对不住 Bluelight 的哥们儿了，但事实就是这样。

---

### (00:08:09) Lenny

**English:**
I thought Bluelight was going to be like not getting exposed to blue light when you're trying to get asleep.

**中文翻译:**
我还以为 Bluelight 是指睡觉时避免蓝光照射之类的。

---

### (00:08:14) April Dunford

**English:**
No. No. I wish. That would make me not make me so scared of the dentist.

**中文翻译:**
不，不。我也希望是那样，那样我就不会这么怕牙医了。

---

### (00:08:21) Lenny

**English:**
Also a problem. How do you know that you have a positioning problem and that you should focus on positioning?

**中文翻译:**
那确实也是个问题。那么，你怎么知道自己存在定位问题，并且应该开始关注定位了呢？

---

### (00:08:26) April Dunford

**English:**
So this is a thing that people ask me this a lot. And I think what people want, and I want this too, what I wish we had was a metric that I could say, "Hey, when you start seeing this metric go in this direction, then you know the positioning is bad." But unfortunately, weak positioning gets you all the way across the pipeline.

**中文翻译:**
很多人问我这个问题。我想人们想要的是——我也想要——一个指标，我可以指着它说：“嘿，当你看到这个指标朝这个方向发展时，你就知道定位出问题了。”但遗憾的是，定位薄弱的影响贯穿了整个销售漏斗（Pipeline）。

---

### (00:08:47) April Dunford

**English:**
Weak positioning hurts you in the early stages of pipeline in that people don't really get what you are, so they're not responding to your marketing the way they should. And you'll get this sluggishness in the middle of your pipeline, particularly if you have sales people. The light doesn't come on until they've had three calls with the sales rep and then the light comes on.

**中文翻译:**
定位薄弱会在漏斗早期伤害你，因为人们不明白你到底是做什么的，所以他们不会对你的营销做出应有的反应。在漏斗中期，你会感到一种停滞感，特别是如果你有销售团队的话。客户往往要和销售代表打三次电话才能“开窍”，明白是怎么回事。

---

### (00:09:06) April Dunford

**English:**
And then sometimes what you'll get is your sales team is actually really good at selling the stuff, but the positioning's wrong, so you close a lot of deals, but then people get using the product and they're like, "Wait a minute, this isn't the thing that I thought it was or it doesn't do what I expected it to do," and then they churn out on you.

**中文翻译:**
还有一种情况是，你的销售团队其实非常擅长卖东西，但定位错了，所以你成交了很多单。但当人们开始使用产品时，他们会说：“等等，这跟我以为的不一样，或者它没达到我的预期。”然后他们就会流失（Churn）。

---

### (00:09:20) April Dunford

**English:**
So all your metrics look bad and you can only tell they look bad by comparing them to your own metrics. And so it's really hard to measure if the positioning isn't working or not.

**中文翻译:**
所以你所有的指标看起来都很糟糕，而且你只能通过和自己过去的指标对比才能发现。因此，很难直接衡量定位是否起作用。

---

### (00:09:31) April Dunford

**English:**
Back when I used to be VP marketing, what I would do to assess this is I'd be the brand new VP of marketing, I'd come on board and I'd say, "Well, I'm just going to go hang out with sales for a bit." And you can really hear it in sales calls, particularly in an initial sales call with a client.

**中文翻译:**
以前我当营销副总裁时，评估定位的方法是：作为新上任的 VP，我会说：“我要去销售部待一阵子。”在销售电话中，你真的能听出来，特别是在与客户的初次通话中。

---

### (00:09:49) April Dunford

**English:**
And what you'll hear is things like the customer comes on, your sales rep comes on, and your sales rep's doing a great job pitching the product like, "Oh, we got this thing and it does this, that, and the other thing."

**中文翻译:**
你会听到这样的情况：客户上线了，你的销售代表也上线了，销售代表表现得很出色，推销着产品：“哦，我们有这个功能，它能做这个、那个，还有另一件事。”

---

### (00:10:01) April Dunford

**English:**
And they'll get a certain way through the pitch and you can see the customer's just like, "Yeah. Yeah. Yeah. Just back it up and pitch it to me again." That's probably the most common one I get is, "Huh? Could you just say that again? Could you just back up to the beginning and do that thing from the beginning?"

**中文翻译:**
推销到一半，你会发现客户一脸茫然：“额，等等，你能退回去再跟我讲一遍吗？”这是我听到的最常见的情况：“哈？你能再说一遍吗？能不能回到开头，从头再讲一遍那个东西？”

---

### (00:10:15) April Dunford

**English:**
So there's this confusion. Sometimes what you'll get is the even worse one is the customer thinks they know exactly what you are, but you ain't that. So you'll get people who say, "Yeah. Yeah. I get it, you're just like Salesforce." And you're like, "Oh actually, no, we're nothing like Salesforce. Sorry. No, that's it. Let me back up and start from the beginning."

**中文翻译:**
这就是困惑。有时候更糟的是，客户以为他们完全知道你是做什么的，但你根本不是。你会听到有人说：“哦，我懂了，你们就像 Salesforce 一样。”然后你只能尴尬地说：“额，其实不是，我们和 Salesforce 完全不同。抱歉，不是那样的，让我退回去从头开始讲。”

---

### (00:10:34) April Dunford

**English:**
Or you'll get this and this one is actually terrible where people will say, "Well, I get it. I mean, I totally get it. I totally get what you do. I just don't get why anyone would pay for that. I can do that in a spreadsheet. I don't get it." So they think they get what you do, but they don't really understand the value.

**中文翻译:**
或者你会遇到这种情况，这真的很糟糕，人们会说：“好吧，我懂了，我完全明白你们是做什么的。我只是不明白为什么有人会为此付钱。我用 Excel 就能搞定。我不理解。”也就是说，他们以为自己懂了，但并没有真正理解其中的价值。

---

### (00:10:50) April Dunford

**English:**
And so if you start hearing stuff like that in an initial sales call, those are usually good signs that the positioning is weak.

**中文翻译:**
所以，如果你在初次销售电话中开始听到这类反馈，通常就是定位薄弱的明显信号。

---

### (00:10:58) Lenny

**English:**
That is really helpful. Backing up a little bit, we jumped right in. I'm curious how you even describe positioning, what the heck is positioning? And broadly, just why is it important for people to think about?

**中文翻译:**
这非常有帮助。稍微往回退一点，我们刚才直接切入主题了。我很好奇你如何描述“定位”，定位到底是什么鬼？广义上讲，为什么人们需要思考它？

---

### (00:11:08) April Dunford

**English:**
In my opinion, it's really misunderstood, which is funny because it's not a new concept. We've been talking about positioning since the '80s, but like a lot of things in marketing people have stretched the definition or there's different definitions, even among marketing people. If I had a dozen vice presidents of marketing together in a room and said, "Hey, define positioning," we'd get a dozen different definitions.

**中文翻译:**
在我看来，定位被严重误解了。这很有趣，因为它不是什么新概念。我们从 80 年代就开始谈论定位了，但就像营销中的很多事物一样，人们延伸了它的定义，甚至在营销人员内部也有不同的定义。如果我把一打营销副总裁关在一个房间里，让他们定义定位，我会得到 12 个不同的答案。

---

### (00:11:30) April Dunford

**English:**
But I think about it this way, positioning defines how your product is the best in the world, delivering some value that a well-defined set of companies care a lot about. So put another way, it encompasses a lot of things, it defines what are the alternatives to what you do? How are you different? What value can you deliver that no other product on the market can?

**中文翻译:**
但我这样看：定位定义了你的产品如何成为世界上最好的，并为一组定义明确的公司提供他们非常在意的某种价值。换句话说，它包含很多内容：它定义了你所做事情的替代方案是什么？你有什么不同？你能提供市场上其他产品无法提供的什么价值？

---

### (00:11:56) April Dunford

**English:**
And oh, by the way, who cares a lot about that value? So who is it that you're trying to target? And then it also encompasses the definition of your market category or what market is it that you intend to win.

**中文翻译:**
还有，顺便说一下，谁会非常在意那个价值？也就是你的目标客户是谁？此外，它还包括对你的市场类别（Market Category）的定义，或者说你打算赢得哪个市场。

---

### (00:12:08) Lenny

**English:**
That is such a succinct, simple way of thinking about it. Something that I've been thinking about is this isn't something just founders should care about. PMs on teams that are building a product should think about this, leaders, GMs of business units. This applies across the board, basically to any product, whether it's the entire company or just one feature.

**中文翻译:**
这真是一个简洁明了的思考方式。我一直在想，这不仅仅是创始人应该关心的事。负责打造产品的产品经理（PM）、领导者、事业部总经理（GM）都应该思考这个问题。它适用于所有层面，基本上适用于任何产品，无论是整个公司还是仅仅一个功能。

---

### (00:12:24) April Dunford

**English:**
Well, this is one of the things that where I think people get into weak positioning. One of the things that happens in companies, and I see this a lot where the founder has an idea what the positioning is, but then you go to the marketing department and it's a little bit different, not a lot different, but a little bit different.

**中文翻译:**
没错，这就是我认为人们陷入定位薄弱的原因之一。公司里经常发生这种情况——我见得多了——创始人对定位有一套想法，但你去营销部门问，他们的理解又有点不同，虽然差别不大，但确实有出入。

---

### (00:12:42) April Dunford

**English:**
And then you sit in on the sales pitch and that's a little bit different again. And then you walk over to the product team and they're thinking about it slightly differently. So I think a lot of weak positioning comes from the fact that we don't have perfect alignment across the team on all these piece parts of positioning.

**中文翻译:**
然后你去听销售推销，发现又有点不一样。接着你走到产品团队，发现他们的想法也略有偏差。所以我认为，很多定位薄弱的问题源于团队内部在定位的各个组成部分上没有达成完美的对齐（Alignment）。

---

### (00:13:00) April Dunford

**English:**
So in the work I do, and even back when I was a VP marketing, if we're going to fix this thing, we can't just have the marketing department or just the product managers sit down and cook up new positioning and then heave it over the wall to everybody else, it actually needs to be a group effort. It's a team sport.

**中文翻译:**
所以在我的工作中，甚至回溯到我当营销副总裁时，如果我们想解决这个问题，不能只让营销部门或产品经理坐下来炮制一个新的定位，然后把它扔给其他人。它实际上需要全员参与，这是一项团队运动。

---

### (00:13:19) April Dunford

**English:**
So if we're going to do positioning well and then actually have that positioning stick and get adopted the way we want it to across the company, if we're going to do a positioning exercise, ideally we've got marketing, product, sales, customer success, and anybody else we need from the executive team, particularly the CEO, together in a room when we're building it.

**中文翻译:**
如果我们想做好定位，并让它在公司内部真正扎根并按预期被采纳，那么在进行定位练习时，理想情况下，我们应该让营销、产品、销售、客户成功（CS）以及执行团队中任何需要的人（特别是 CEO）聚在一个房间里共同构建。

---

### (00:13:41) April Dunford

**English:**
So that we can all bring our expertise to the table, bring our understanding of what customers do and our product to the table, thrash around on it a little bit until we get agreement on it. And then now that we've all got agreement and alignment around it, then we can all go execute on it and we're all singing the same song.

**中文翻译:**
这样我们就能各抒己见，把对客户行为和产品的理解摆到桌面上，反复推敲，直到达成共识。一旦我们达成共识并对齐了，大家就可以去执行，所有人都在唱同一首歌。

---

### (00:13:59) Lenny

**English:**
That's so interesting. How often do you find that the problem is misalignment within the company versus just they don't actually have the right positioning and that's the problem?

**中文翻译:**
这很有趣。你发现问题更多是由于公司内部的不对齐，还是因为他们根本就没有正确的定位？

---

### (00:14:07) April Dunford

**English:**
Well, a lot of times it's misalignment. I would say the majority of the time it's misalignment, because what it is a piece of the company has it right, but the other pieces don't. So I get one of two things are happening.

**中文翻译:**
很多时候是不对齐。我会说大部分时间都是不对齐，因为往往公司的一部分人是对的，但其他人不是。我通常会遇到两种情况。

---

### (00:14:21) April Dunford

**English:**
So sometimes what I'll get is the founder comes to me and the founder says, "I know exactly how to tell this story. You put me in front of a customer, I crush it every time. I know how to position this thing. I know how to do whatever. But we've gotten big now and I got a brand new VP marketing and I got a brand new VP sales and I just hired somebody to do product and they don't understand it the way I understand it."

**中文翻译:**
第一种是创始人来找我，说：“我完全知道该怎么讲这个故事。只要把我放在客户面前，我每次都能搞定。我知道怎么定位，我知道该怎么做。但现在公司变大了，我有了新的营销副总裁、新的销售副总裁，还刚招了产品负责人，但他们对定位的理解跟我完全不一样。”

---

### (00:14:43) April Dunford

**English:**
"And when I listen in on a sales call, what I hear is all wrong, that it's not it. When I look at our marketing, what I see, that's not it. And I've tried to get everybody in alignment and I can't. And so I need you to come in here and facilitate a thing where we can all get in alignment." That happens a lot.

**中文翻译:**
“当我听销售电话时，我觉得全错了，不是那样的。当我看到我们的营销内容时，我觉得也不是那样的。我试过让大家对齐，但我做不到。所以我需要你过来主持一下，让我们所有人达成共识。”这种情况经常发生。

---

### (00:14:58) April Dunford

**English:**
The other one I get is kind of the opposite of that, where you've got a founder that used to run sales, used to do all the deals, used to do everything, had their arms around this market very tight at one point and then the company's grown, often very quickly. They've hired a bunch of very senior people to run pieces, but at the same time, the market itself has shifted a lot.

**中文翻译:**
另一种情况则相反：创始人以前管销售，亲自谈成所有单子，曾经对市场了如指掌。但随着公司快速成长，他们雇了一群资深人士来分管各块业务，而与此同时，市场本身也发生了巨大变化。

---

### (00:15:20) April Dunford

**English:**
And so I'll get approached then often by the head of product or the head of marketing that comes in and says, "I don't think we have this right. I think we're actually positioned for what the market used to be. And I'm having a hard time getting the founder, having their heads around it and everybody else on the team, because we're all coming at it with different information."

**中文翻译:**
这时，产品负责人或营销负责人会来找我，说：“我觉得我们的定位不对。我们现在的定位是针对过去的市场。我很难让创始人明白这一点，也很难让团队其他人达成共识，因为大家掌握的信息都不一样。”

---

### (00:15:41) April Dunford

**English:**
And so sales sees what's happening in sales. Marketing sees what's happening in marketing. The founder's getting pulled into certain deals, but not all the deals. Product's seeing what's happening in the thing. And so again, there's pieces of it there, but we're not all in alignment and agreement. And so we got to get everybody together and then work through it.

**中文翻译:**
销售只看到销售端的情况，营销只看到营销端的情况。创始人只参与某些特定的单子，而不是全部。产品团队只看到产品内部的情况。所以，每个人手里都只有碎片化的信息，大家没有达成共识。因此，我们必须把所有人聚在一起，共同解决这个问题。

---

### (00:15:59) Lenny

**English:**
What does it look like when you've nailed it, when you are maybe in a good place with positioning? And also just along those-

**中文翻译:**
当你真正搞定定位时，或者说当定位处于良好状态时，是什么样子的？而且顺着这个……

---

### (00:16:05) April Dunford

**English:**
Yeah-

**中文翻译:**
是的……

---

### (00:16:05) Lenny

**English:**
Go for it. Go for it.

**中文翻译:**
请讲，请讲。

---

### (00:16:06) April Dunford

**English:**
... it's interesting because when it's working really well, it feels like magic and really great positioning feels obvious. You pitch it to people and they're like, "Well, of course that's it. What else could it be?"

**中文翻译:**
这很有趣，因为当定位非常奏效时，感觉就像魔法一样。伟大的定位感觉是“显而易见”的。你向人们推销，他们会说：“哦，当然就是这样，还能是什么样呢？”

---

### (00:16:22) April Dunford

**English:**
One of my favorite companies, this is a company I worked with a little bit a couple of years ago is Postman. You know these folks?

**中文翻译:**
我最喜欢的公司之一是 Postman，几年前我和他们合作过一点。你知道他们吧？

---

### (00:16:28) Lenny

**English:**
Mm-hmm.

**中文翻译:**
嗯哼。

---

### (00:16:28) April Dunford

**English:**
So they basically have an API platform, a platform for building and using APIs. And just how I described that right there is so simple, it's so simple, of course that's what it is. But it was not simple getting there and that's not the way they were always describing themselves. And if you run that back three years ago, that's not at all what you would have gotten as the pitch for Postman.

**中文翻译:**
他们基本上就是一个 API 平台，一个用于构建和使用 API 的平台。我刚才的描述非常简单，简单到让人觉得“理所当然”。但达到这种简洁并不容易，他们以前也不是这么描述自己的。如果你回到三年前，Postman 的推销词绝不是现在这样。

---

### (00:16:51) April Dunford

**English:**
But really, really great positioning just feels like it's so clear, it's so simple, of course that's what it is, of course, and of course we need one of those. If we're serious about APIs, why would we not have a platform for building and managing APIs? Of course we need that. And so it's hard to judge sometimes from the outside.

**中文翻译:**
但真正伟大的定位就是感觉如此清晰、如此简单，让人觉得“当然是这样，我们当然需要一个”。如果我们认真对待 API，为什么会不需要一个构建和管理 API 的平台呢？我们当然需要。所以，有时从外部很难判断定位的好坏。

---

### (00:17:11) April Dunford

**English:**
The other thing is that positioning is somewhat like messaging in some ways in that it's not a static thing, it changes over time. Your product itself doesn't stay the same, the market doesn't stay the same, and so things will shift over time. And so you can have good positioning that suddenly becomes bad positioning and it's not great positioning anymore, or good positioning that goes sideways or whatever, then you got to come back.

**中文翻译:**
另一件事是，定位在某些方面有点像信息传达（Messaging），它不是静态的，会随时间变化。你的产品在变，市场也在变，所以情况会随时间推移而改变。你可能原本有很好的定位，但突然间它就不再适用了，或者定位偏离了方向，这时你就得重新审视。

---

### (00:17:36) April Dunford

**English:**
And so usually I think there's value in checking in on your positioning because it's really hard. Again, I don't have a measurement to say yes or no, the positioning's working. And so I think there's no harm in checking in on it, going through a process to walk through it and just check in and see, could it be better? Maybe we could tighten this up. Maybe this could be a lot better than it is right now, but we've never sat down and actually deliberately looked at it.

**中文翻译:**
所以我认为定期检查定位是有价值的，因为这确实很难。再说一次，我没有一个指标能直接告诉你定位是否奏效。因此，定期检查、走一遍流程、看看是否能做得更好，这并没有坏处。也许我们可以把定位收得更紧，也许它能比现在好得多，只是我们从未坐下来刻意审视过它。

---

### (00:18:03) Lenny

**English:**
Just to make it even a little more concrete, what are just some examples of good positioning statements or just the positioned companies?

**中文翻译:**
为了让它更具体一点，有哪些好的定位陈述（Positioning Statements）或者定位非常成功的公司案例？

---

### (00:18:11) April Dunford

**English:**
So one thing is a lot of times people will send me a link to their homepage and they'll say, "What do you think? Is this positioning good or not?" And the problem with B2B tech companies is, well, unless I'm your buyer, I'm not the right person to ask.

**中文翻译:**
有一点是，经常有人发给我一个官网链接问：“你觉得怎么样？这个定位好不好？”B2B 科技公司的问题在于，除非我是你的买家，否则我不是那个适合回答这个问题的人。

---

### (00:18:26) April Dunford

**English:**
So you can have companies, people will say, "Well, I looked at the website and who knows what that is?" And it's like, well, it doesn't matter if I can understand what it is or not. If I'm selling a deeply technical thing to deeply technical buyers, it's okay if your grandmother doesn't understand what it is when they get there. What matters is, does it resonate for your buyers? And when they land there, do they go, "Oh yeah, I get what this is, and that seems like a thing I should have."

**中文翻译:**
有些公司，人们会说：“我看过他们的网站，谁知道那是干嘛的？”其实，我能不能看懂并不重要。如果我是在向深度技术型买家销售深度技术产品，那么你奶奶看不懂也没关系。重要的是，它是否能引起你买家的共鸣？当他们访问网站时，是否会说：“哦，是的，我明白这是什么，这正是我需要的东西。”

---

### (00:18:53) April Dunford

**English:**
And so a lot of the companies that I really love the positioning of, you would go and look at it and say, "I don't know, man, I'm not even sure I really understand what that is." If you didn't have anything to do with APIs and you didn't know what the fuck an API was, whatever, you might land on Postman's page and go, "I honestly don't get that." But that's okay, you're not a person building the APIs, so you don't have to understand it. That's all right.

**中文翻译:**
所以很多我非常喜欢的定位案例，你去看的时候可能会说：“我不知道，伙计，我甚至不确定我是否真的理解那是做什么的。”如果你和 API 没关系，甚至不知道 API 是什么鬼，你访问 Postman 的页面可能会觉得：“我真的看不懂。”但这没关系，你不是构建 API 的人，所以你不需要懂。

---

### (00:19:18) April Dunford

**English:**
Particularly, I've worked a lot with companies doing deep AI stuff, deep, deep digital analytics and deep data stuff and you can't tell from looking at the website, whether it's working or not. The true test of whether the positioning's working or not is, if I'm sitting across from a qualified prospect and I tell the story, does the prospect get excited and want to buy something? That's the real test of it.

**中文翻译:**
特别是，我曾与许多从事深度 AI、深度数字分析和深度数据业务的公司合作，你无法通过看网站来判断定位是否奏效。真正的测试是：如果我坐在一个合格的潜在客户面前讲这个故事，客户是否会感到兴奋并想要购买？这才是真正的考验。

---

### (00:19:41) April Dunford

**English:**
Any other test I think is we're bringing our own baggage into it and saying ... I pick on these guys a little bit, but in Canada, there's a big startup conference, it's great, it's called Startupfest. It's in Montreal.

**中文翻译:**
我认为任何其他的测试都带有个人的主观偏见。我拿某些人开个玩笑，在加拿大有一个很大的创业大会，非常棒，叫 Startupfest，在蒙特利尔举行。

---

### (00:19:51) Lenny

**English:**
I've been to that.

**中文翻译:**
我去过。

---

### (00:19:52) April Dunford

**English:**
But every year they have this thing and it's called Pitch the Grannies. And you go in and you're a startup and you pitch the grandmothers and the grandmothers decide whether or not your pitch was any good. And this infuriates me because I'm like, "This is a terrible judge of pitching." Maybe if we're doing the VC pitch, in which case you're saying the VCs and the grandmothers are exactly the same, that's a little insulting.

**中文翻译:**
他们每年都有一个环节叫“向老奶奶推销”（Pitch the Grannies）。创业公司进去向老奶奶们推销，由她们决定你的推销好不好。这让我很生气，因为我觉得：“这简直是推销水平的最差评判标准。”除非你是在做 VC 投融资推销，而你认为 VC 和老奶奶是一回事，那这还有点侮辱人。

---

### (00:20:16) April Dunford

**English:**
But certainly, if the pitch is a customer facing pitch, I don't care whether the grandmother understands it or not. Unless I happen to be building the thing for grandmas, I really don't think that matters at all, so yeah.

**中文翻译:**
但如果这是一个面向客户的推销，我根本不在乎老奶奶能不能听懂。除非我恰好是在为老奶奶们开发产品，否则我认为这根本不重要。

---

### (00:20:28) Lenny

**English:**
Hopefully no B2B startups are pitching to grandmas, don't think that would go well.

**中文翻译:**
希望没有 B2B 创业公司在向老奶奶推销，我觉得那不会有好结果。

---

### (00:20:32) April Dunford

**English:**
Yeah.

**中文翻译:**
没错。

---

### (00:20:32) Lenny

**English:**
Okay, so say that you're a PM or a founder that's ready to start figuring out their positioning for their product, what's the first thing that you do?

**中文翻译:**
好，假设你是一个产品经理或创始人，准备开始为产品确定定位，你做的第一件事是什么？

---

### (00:20:41) April Dunford

**English:**
So I've done a lot of thinking about how should we actually do positioning. And so a critical piece of positioning is your differentiated value, what's the value that you can deliver that no other company can deliver?

**中文翻译:**
我一直在思考我们到底应该如何做定位。定位的一个关键部分是你的“差异化价值”（Differentiated Value），即你能提供而其他公司无法提供的价值是什么？

---

### (00:20:56) April Dunford

**English:**
And so how companies get this wrong a lot is they'll say, "Okay, well, we want to look at our positioning, so let's get everybody together." Or sometimes they'll say, "Let's just sit in the marketing department and think about the value."

**中文翻译:**
很多公司在这里会犯错，他们会说：“好吧，我们要审视定位，大家聚一聚。”或者有时他们会说：“让营销部门坐下来想想价值是什么。”

---

### (00:21:07) April Dunford

**English:**
But sometimes folks will get a team together, they get a team together and then they'll say, "Okay, so why does everybody love our stuff?" And this is a terrible way to go about it because what you'll get is just a bunch of opinions and we don't really know how to measure is that good or not.

**中文翻译:**
有时大家把团队聚在一起，然后问：“好吧，为什么大家都喜欢我们的东西？”这是一个非常糟糕的方法，因为你得到的只是一堆主观意见，而我们根本不知道如何衡量这些意见的好坏。

---

### (00:21:20) April Dunford

**English:**
So I actually think the first step in a good positioning exercise is to really understand, what do we have to position against? So put another way, it's like saying, what do I have to beat in order to win a deal? So in positioning work we call this competitive alternatives.

**中文翻译:**
所以我认为，一个好的定位练习的第一步是真正理解：我们要针对什么进行定位？换句话说，为了赢得订单，我必须击败什么？在定位工作中，我们称之为“竞争替代方案”（Competitive Alternatives）。

---

### (00:21:36) April Dunford

**English:**
Now how people mess up this first step is I say competitive alternatives and they think competition, so things that look exactly like me. But in B2B, we have two sets of competitors. We have status quo, which is whatever the company is doing to attempt to solve the problem right now, even if it's crappy and not great.

**中文翻译:**
人们在第一步容易搞混的地方是：我说“竞争替代方案”，他们就想到“竞争对手”，即那些看起来和自己一模一样的东西。但在 B2B 领域，我们有两类竞争对手。第一类是“现状”（Status Quo），即客户目前用来解决问题的任何方式，哪怕这种方式很烂、很不理想。

---

### (00:21:56) April Dunford

**English:**
And then there's if the company does decide they're going to buy something different, they usually make a short list, so it's whoever else lands on the short list. So I need to be able to put a stake in the ground and say, "I got to beat all that in order to win a deal."

**中文翻译:**
第二类是，如果客户决定购买不同的东西，他们通常会列一个候选名单（Short List），也就是名单上的其他所有人。所以我需要明确表态：“为了赢得订单，我必须击败所有这些对手。”

---

### (00:22:10) April Dunford

**English:**
Now, most folks will discount the status quo, but they shouldn't because in B2B we lose about 40% of our deals to quote-unquote, "no decision," which actually means we lost to the spreadsheet, we lost to pen and paper, we lost to interns. And if we're not positioning well against that, we're never going to get the customer to come off of that.

**中文翻译:**
现在，大多数人会忽视“现状”，但他们不应该这样做，因为在 B2B 领域，我们大约有 40% 的单子是因为所谓的“未做决定”而丢掉的，这实际上意味着我们输给了 Excel 表格，输给了纸和笔，输给了实习生。如果我们不能针对这些现状做好定位，我们就永远无法让客户放弃它们。

---

### (00:22:31) April Dunford

**English:**
So I got to win against status quo, but I also have to win, if it's ... Most of the time, if it's B2B, you don't just buy the first thing you come across, you make a short list of alternatives and I got to win against those as well.

**中文翻译:**
所以我必须战胜现状，而且如果是在 B2B 领域，大多数时候你不会直接买你看到的第一个东西，你会列一个替代方案名单，我也必须战胜名单上的那些对手。

---

### (00:22:44) April Dunford

**English:**
So step number one, what am I positioning against? Once I have that stake in the ground, then I can start thinking about what makes us different. So the easiest way to do this is okay, this is what I have to position against, what have I got capabilities wise that the alternatives don't have?

**中文翻译:**
所以第一步是：我要针对什么进行定位？一旦明确了这一点，我就可以开始思考我们的不同之处。最简单的方法是：既然这是我的竞争对手，那么在能力方面，我有哪些是替代方案所不具备的？

---

### (00:23:01) April Dunford

**English:**
So feature, function, or even capabilities of the company, which could be pricing or professional services or other things that you've got, but also capabilities of the product. What have I got that the alternatives don't have? And I can make a giant list of these things.

**中文翻译:**
这包括功能、特性，甚至是公司的能力（比如定价、专业服务或其他优势），当然还有产品的能力。我有哪些东西是替代方案没有的？我可以列出一大清单。

---

### (00:23:15) April Dunford

**English:**
And then I can translate that stuff into value by going down the list and saying, "Okay, we have this great feature, so what? Why does a customer care about it? What is the value that feature enables?" And when I do that mapping over to value, what generally happens is I end up with two or three value buckets or value themes.

**中文翻译:**
然后，我可以逐项将这些能力转化为价值，问自己：“好吧，我们有这个很棒的功能，那又怎样？客户为什么要在意它？这个功能实现了什么价值？”当我完成这种到价值的映射时，通常会得到两三个价值维度或价值主题。

---

### (00:23:36) April Dunford

**English:**
And quite often those value buckets or value themes are different than what I would've gotten, if I got all the smart people in my company together and said, "Hey, why does everybody love our stuff?" When I do it this way, I'm ensured that those value themes are differentiated and not just things that are generally valuable, but any alternative could get it done, so why are we even talking about it? So in my mind, that's how we do it.

**中文翻译:**
而且通常这些价值维度与我召集公司所有聪明人问“大家为什么喜欢我们”得到的答案是不同的。通过这种方式，我能确保这些价值主题是具有差异化的，而不仅仅是那些虽然有价值但任何替代方案都能做到的事情——如果是那样，我们根本没必要谈论它。在我看来，这就是定位的方法。

---

### (00:24:00) April Dunford

**English:**
Once I've got differentiated value, then I can start thinking about, well, look, I could sell this product to any company that has this problem, but not everybody cares about this value the same way. And so what are the characteristics of a target account that make them really, really care a lot about that value? If I do some deep thinking about that, that's going to be my definition of a really best fit customer.

**中文翻译:**
一旦我确定了差异化价值，我就可以开始思考：虽然我可以把产品卖给任何有这个问题的公司，但并不是每个人都以同样的方式在意这个价值。那么，目标客户的哪些特征会让他们非常、非常在意这个价值？如果我对此进行深入思考，就能定义出谁才是“最适合”的客户。

---

### (00:24:22) April Dunford

**English:**
And then the last piece of positioning of course, is market category. And so again, a lot of people will just start with market category and then try to back up, which I think is crazy, because then we don't have any way to judge the goodness of a market category.

**中文翻译:**
定位的最后一部分当然是市场类别。很多人会直接从市场类别开始，然后试图反推，我觉得这很疯狂，因为那样我们就没有办法判断一个市场类别的好坏。

---

### (00:24:35) April Dunford

**English:**
But if I've got, look, this is the value only I can deliver, these are the kind of people that really care a lot about that value, if I start thinking about positioning as the context I position my product in, then the best market category is the context I position my product in such that this value is obvious to these people.

**中文翻译:**
但如果我已经明确了“这是只有我能提供的价值”以及“这是非常在意该价值的人群”，那么当我把定位看作是产品所处的语境时，最好的市场类别就是那个能让我的价值对目标人群显得显而易见的语境。

---

### (00:24:57) April Dunford

**English:**
This is my long-winded way of doing it, but this is the only way I know how to get positioning done.

**中文翻译:**
这是我比较啰嗦的执行方式，但这是我所知道的唯一能把定位做好的方法。

---

### (00:25:02) Lenny

**English:**
So you just basically went through the steps and the bullet points of things you've got to figure out your position. Could you just briefly summarize that just for people to have that in their brain?

**中文翻译:**
所以你基本上已经梳理了确定定位所需的步骤和要点。你能简要总结一下，好让大家记在脑子里吗？

---

### (00:25:10) April Dunford

**English:**
Yeah. So it works like this. I start with competitive alternatives. What do I got to beat in order to win a deal, status quo, things on the short list. Once I've got that, then I can make a list of differentiated capabilities, what capabilities do I have that the alternatives do not? I can then translate those capabilities into value, the so what for the customer. And while I'm doing that, these things will theme out. So I'll end up with two, three value themes, value buckets.

**中文翻译:**
好的。流程是这样的：首先从“竞争替代方案”开始。为了赢得订单，我必须击败什么？包括现状和候选名单上的对手。明确之后，列出“差异化能力”清单：我有哪些替代方案不具备的能力？然后将这些能力转化为“价值”，即对客户而言的意义。在这个过程中，这些价值会形成主题，最终得到两三个价值维度。

---

### (00:25:37) April Dunford

**English:**
Once I have that, then I can ask myself the question, well, okay, what are the characteristics of a target account that make them care a lot about that value? So that next piece is best fit customers or target customers, who am I going after for this thing? And then the last bit's market category, so what's the context I position this thing in that makes my value obvious to the people I'm going after?

**中文翻译:**
有了这些，我就可以问自己：目标客户的哪些特征会让他们非常在意这些价值？接下来的部分就是“最适合的客户”或“目标客户”，即我要把这东西卖给谁？最后一部分是“市场类别”，即我把产品放在什么样的语境中，才能让我的价值对目标人群显而易见？

---

### (00:25:59) Lenny

**English:**
Super helpful. What if we pick a company either that you worked with or that's just out there and think through what they would do for each of these steps to make this super real?

**中文翻译:**
非常有帮助。如果我们选一家你合作过的公司，或者市面上的某家公司，按照这些步骤推演一遍，让它变得更真实，你觉得如何？

---

### (00:26:09) April Dunford

**English:**
Sure. I'm going to do Help Scout because I like these guys.

**中文翻译:**
没问题。我选 Help Scout 吧，因为我很喜欢他们。

---

### (00:26:11) Lenny

**English:**
Sounds good.

**中文翻译:**
听起来不错。

---

### (00:26:12) April Dunford

**English:**
And I was just talking to the CEO not too long ago. So Help Scout's a good example in that they're a startup. I would call them a growth stage startup. They're not super big, but they're not teeny-weeny either. And they're in what would appear to be a terrible market, which is they sell software for customer success. So their competitor's like Zendesk. There's actually a million companies in this space, but the gorilla in the market is Zendesk.

**中文翻译:**
我不久前刚和他们的 CEO 聊过。Help Scout 是个很好的例子，他们是一家创业公司，我会称之为增长阶段的创业公司。规模不算特别大，但也不小。他们处于一个看起来很糟糕的市场，即销售客户成功软件。他们的竞争对手像 Zendesk。这个领域其实有无数家公司，但市场上的巨头是 Zendesk。

---

### (00:26:39) April Dunford

**English:**
And so if I put the stake in the ground and say, "Well, what do I got to replace?" Well, their customer's a lot of small, medium businesses, a lot of direct to consumer E-commerce businesses. And so they obviously have to beat Zendesk and the other folks that are out there, but sometimes they're replacing just email or even a rudimentary shared inbox. That's who they got to beat.

**中文翻译:**
如果我明确目标说：“我要取代什么？”他们的客户很多是中小企业，很多是 D2C 电商。他们显然必须击败 Zendesk 和其他对手，但有时他们取代的仅仅是电子邮件，甚至是原始的共享收件箱。这就是他们要击败的对象。

---

### (00:27:04) April Dunford

**English:**
And so when you look through what Help Scout has that's differentiating, they've got a whole bunch of features that are really around delivering really amazing service to the customer. So they do a shared inbox. They were the first ones to do a proper services-oriented shared inbox to make sure that nobody gets missed and the right people get assigned to the right thing and you don't get conflicts.

**中文翻译:**
当你审视 Help Scout 的差异化优势时，你会发现他们有一堆功能是围绕着为客户提供卓越服务而设计的。比如他们做共享收件箱，他们是第一个做真正的服务导向型共享收件箱的，确保没有客户被遗漏，正确的人被分配到正确的任务，且不会产生冲突。

---

### (00:27:27) April Dunford

**English:**
But they do a lot of other things like their whole philosophy about how they treat a customer in the service process is really different from Zendesk. So you get assigned a ticket number, you get assigned a person and things like that. And so they do all the neat, integrated things like they'll do a chat bot thing, but it only appears when there's an actual person to chat with you. They don't try to pretend they're a machine, things like that. So they want to guarantee a really high level of service.

**中文翻译:**
但他们还做了很多其他事情，比如他们在服务过程中对待客户的整体哲学与 Zendesk 完全不同。在 Zendesk，你会得到一个工单号，被分配给某个人等等。Help Scout 做了一些很棒的集成，比如他们也有聊天机器人，但只有当真的有人在线可以和你聊天时，机器人才会出现。他们不试图假装自己是机器，诸如此类。他们想要保证极高水平的服务。

---

### (00:27:52) April Dunford

**English:**
So when you map that to value, the value is one, I'm delivering this extra amazing service for customers. I'm not trying to push customers to a low cost channel. I'm treating them like a person. So their value is really around delivering amazing customer service that's going to deepen your relationship with the customer. That's the value.

**中文翻译:**
当你把这些映射到价值时，价值之一就是：我正在为客户提供超乎想象的服务。我不是在试图把客户推向低成本渠道，而是把他们当人看。所以他们的价值核心在于提供卓越的客户服务，从而加深你与客户的关系。这就是价值。

---

### (00:28:15) April Dunford

**English:**
And then you say, "Well, who cares a lot about that?" Well, not everybody. So there are businesses out there, I would argue maybe your phone company doesn't really care. They have a giant call center and all they care about is reducing the cost in their call center and driving you to low cost channels.

**中文翻译:**
然后你问：“谁会非常在意这个？”显然不是所有人。有些企业，比如你的电话公司，可能根本不在乎。他们有一个巨大的呼叫中心，他们唯一关心的就是降低呼叫中心的成本，把你赶到低成本渠道去。

---

### (00:28:33) April Dunford

**English:**
They don't actually see customer service as a way to build a relationship with you versus a lot of direct to consumer brands or E-commerce brands. This is almost the only way that they can interact with their customer. So they actually see customer service as a way to really drive growth through customer loyalty. And so those are the kind of companies that are a really good fit for Help Scout.

**中文翻译:**
他们并不把客户服务看作是建立关系的方式。相比之下，很多 D2C 品牌或电商平台，这几乎是他们与客户互动的唯一方式。因此，他们将客户服务视为通过客户忠诚度驱动增长的一种手段。这类公司就是 Help Scout 的理想客户。

---

### (00:28:57) April Dunford

**English:**
So I go through that process, that's my positioning. Then the next thing you got to do is okay, now that I understand all that, how do I weave a story around that? So how do I tell the story about that, if a customer comes to me? And so what we want to do with our positioning is turn it into a sales narrative that clicks with the kind of customers we know we can sell to.

**中文翻译:**
走完这个流程，定位就出来了。接下来的事就是：既然我理解了这一切，我该如何围绕它编织一个故事？如果客户找上门，我该怎么讲这个故事？我们要做的就是把定位转化为一套销售叙事（Sales Narrative），让它能引起那些我们确信可以成交的客户的共鸣。

---

### (00:29:19) April Dunford

**English:**
So the way Help Scout delivers the story, if you come in, you're a qualified prospect, it starts with this idea that customer success is a growth driver. Modern E-commerce companies see customer success as a way to deepen customer relationships, increase repeat buying, show it as a growth driver. And they have a bunch of great stats that prove that this is true.

**中文翻译:**
Help Scout 讲故事的方式是这样的：如果你是一个合格的潜在客户，故事会从“客户成功是增长引擎”这个理念开始。现代电商公司将客户成功视为加深客户关系、增加复购的手段，将其视为增长驱动力。他们有一堆很棒的数据来证明这一点。

---

### (00:29:40) April Dunford

**English:**
And then they go look at all your other alternatives. All your other alternatives treat your people like a number. They give them a number. They try to drive them to low cost channels. They try to do these things. They are not treating this like a growth driver, they're treating it like a cost center.

**中文翻译:**
然后他们会审视所有的替代方案。所有其他替代方案都把你的客户当成一个数字，给他们一个编号，试图把他们赶到低成本渠道。他们没有把这当作增长引擎，而是当作成本中心。

---

### (00:29:57) April Dunford

**English:**
And so being able to tell that story that takes your differentiated value and puts it into context is the way all this stuff comes together and the rubber meets the road. So I don't know if that's a good example.

**中文翻译:**
能够讲出这样一个故事，将你的差异化价值置于具体的语境中，就是所有这些工作最终落地并产生实效的方式。我不知道这算不算一个好例子。

---

### (00:30:07) Lenny

**English:**
Oh, that's an amazing example. That makes it so real. Is the output of this process a doc with these bullet points, plus this story that you train sales on? Or how does that look?

**中文翻译:**
噢，这是一个非常棒的例子，非常真实。这个过程的产出物是一个包含这些要点的文档，加上一个用来培训销售的故事吗？具体形式是怎样的？

---

### (00:30:18) April Dunford

**English:**
Yeah. So we do two things in the workshops that I do. So first we get the gang together. So I want representation from sales, marketing, product, customer success, CEO, everybody in the room together. And then we're going to work through the five piece parts.

**中文翻译:**
是的。在我主持的工作坊里，我们会做两件事。首先，把大家聚在一起。我希望销售、营销、产品、客户成功、CEO 的代表都在场。然后我们一起梳理这五个组成部分。

---

### (00:30:33) April Dunford

**English:**
So once we've got, here's what we compete with, here's how we're different, this is the value we can deliver no one else can, these are the kind of people that really love our stuff, so here's who we're going after, this is the market we're going to win, then we can document that in a document.

**中文翻译:**
一旦我们确定了：我们的竞争对手是谁、我们有何不同、我们能提供哪些独一无二的价值、谁会非常喜欢我们的东西（即目标客户）、以及我们要赢得哪个市场，我们就会将其记录在文档中。

---

### (00:30:46) April Dunford

**English:**
And for the marketing people, that's a good starting place to then go and build messaging because we've got an idea what our value props are. But if we end there and we just stop there, then what usually happens is the rest of the team goes back to normal and they go, "Yeah, we did this thing." And conceptually they get it, but they don't know how to tell a story. It's super important in sales because if sales can't tell the story, they can't pitch it, if they can't pitch it, they're going to make shit up.

**中文翻译:**
对于营销人员来说，这是构建信息传达（Messaging）的一个很好的起点，因为我们已经知道了价值主张是什么。但如果我们到此为止，通常发生的情况是团队其他人会回到常态，他们会说：“是的，我们做了定位。”概念上他们懂了，但他们不知道如何讲故事。这在销售中至关重要，因为如果销售不会讲故事，他们就无法推销；如果无法推销，他们就会胡编乱造。

---

### (00:31:12) April Dunford

**English:**
And so what we want to do then is, okay, we've got this positioning, now let's put it together into a sales narrative that we can then take and test with qualified prospects and make sure it works, but we've also got something that the sales team can pitch and oh, by the way, everybody else knows how to tell the story too. So product knows how to tell the story, customer success knows how to tell the story, CEO knows how to tell the story.

**中文翻译:**
所以我们要做的就是：既然有了定位，现在把它整合进一套销售叙事中，然后拿去在合格的潜在客户身上测试，确保它奏效。这样销售团队就有了可以推销的内容，而且顺便说一下，其他人也都知道该怎么讲这个故事了——产品团队知道，客户成功团队知道，CEO 也知道。

---

### (00:31:35) April Dunford

**English:**
So the last thing we do is we map this positioning to a sales narrative. So what we do in the workshop is we storyboard it out. And then after the workshop is done, the team's going, usually it's marketing and sales together, they take that storyboard and then turn it into an actual pitch, which is like a deck, a demo, a script. And then they can use that to test the positioning as well.

**中文翻译:**
所以我们做的最后一件事是将定位映射到销售叙事。在工作坊中，我们会画出故事板（Storyboard）。工作坊结束后，团队（通常是营销和销售配合）会根据故事板制作实际的推销材料，比如 PPT、演示 Demo、话术脚本。然后他们可以用这些东西来进一步测试定位。

---

### (00:31:57) Lenny

**English:**
This episode is brought to you by Productboard. Product leaders trust Productboard to help their teams build product that matter. From startups to industry titans, over 6,000 companies rely on Productboard to get the right products to market faster, including companies like Zoom, Volkswagen, UiPath, and Vanguard.

**中文翻译:**
本期节目由 Productboard 赞助。产品领导者信任 Productboard，帮助他们的团队打造重要的产品。从创业公司到行业巨头，超过 6,000 家公司依靠 Productboard 更快地将正确的产品推向市场，包括 Zoom、大众汽车、UiPath 和 Vanguard 等公司。

---

### (00:32:14) Lenny

**English:**
Productboard can help you create a scalable, transparent and standardized process so your PMs understand what their customers really need and then prioritize the right features to build next.

**中文翻译:**
Productboard 可以帮助你创建一个可扩展、透明且标准化的流程，让你的产品经理了解客户的真实需求，并优先处理接下来要构建的正确功能。

---

### (00:32:25) Lenny

**English:**
Stakeholders feel the love too with an easy to view roadmap that automatically updates so everyone knows what you're building and why, make data driven product decisions that result in higher revenue and user adoption, and empower your product teams to create delightful customer experiences. Visit productboard.com to learn more.

**中文翻译:**
利益相关者也会喜欢它，因为有易于查看且自动更新的路线图，让每个人都知道你在构建什么以及为什么。做出数据驱动的产品决策，从而带来更高的收入和用户采用率，并赋能你的产品团队创造令人愉悦的客户体验。访问 productboard.com 了解更多信息。

---

### (00:32:44) Lenny

**English:**
Got it. So the output ends up being an actual pitch or a story they tell on sales calls, forms the way they marketing position or talks about the company. There's two questions I want to ask. I want to make sure I don't forget.

**中文翻译:**
明白了。所以产出物最终是一套实际的推销词，或者他们在销售电话中讲的故事，这构成了营销定位或谈论公司的方式。我想问两个问题，以免待会儿忘了。

---

### (00:32:55) Lenny

**English:**
One is about messaging versus positioning. But maybe before that, it's interesting that positioning starts with focusing on your differentiator. Is that essential for a company to always figure out a differentiator and be different? Or are there examples where maybe you don't need to focus on that?

**中文翻译:**
一个是关于信息传达与定位的区别。但在那之前，很有趣的一点是定位始于关注你的“差异化因素”。对于一家公司来说，始终找出差异化因素并保持不同是必不可少的吗？有没有一些例子是可能不需要关注这个的？

---

### (00:33:08) April Dunford

**English:**
Well, what you want to do is you want to take a customer's viewpoint on this, right? So let's think about how customers buy. We don't talk about this a lot, but let's think about how customers buy. Typical B2B buying process, this is what it looks like.

**中文翻译:**
你要做的是站在客户的角度看问题，对吧？让我们想想客户是如何购买的。我们不常讨论这个，但典型的 B2B 购买流程是这样的。

---

### (00:33:22) April Dunford

**English:**
Somebody, VP sales wakes up in the morning and says, "You know what sucks? The way we track our pipeline sucks. It's stupid. I can't deal with this anymore. We need to get a tool in here. We should have a CRM, man." And they go to the office and they don't actually go look for the new tool. They find some sucker in the office like John, you, get out there, manager of sales ops or whatever, find us a CRM.

**中文翻译:**
某位销售副总裁早上醒来心想：“你知道什么最烂吗？我们追踪销售漏斗的方式太烂了，简直愚蠢。我受够了，我们需要一个工具，我们需要一个 CRM。”然后他们去办公室，但他们并不会亲自去找新工具。他们会找个“倒霉蛋”，比如约翰，“约翰，你，去，你是销售运营经理，给我们找个 CRM。”

---

### (00:33:45) April Dunford

**English:**
And John's panicked. John's like, "Oh my God, you're kidding me." Maybe John's used some CRMs, but he's not an expert on the CRM market. He doesn't know what's possible and what isn't possible. So John's like, "Oh God, I don't even know." And then he Googles and what does he get? A fire hose of information.

**中文翻译:**
约翰慌了，心想：“天哪，你在开玩笑吧。”也许约翰用过一些 CRM，但他不是 CRM 市场的专家。他不知道现在有什么可能，什么不可能。所以约翰想：“天哪，我甚至不知道从哪儿开始。”然后他去谷歌搜索，结果得到了什么？排山倒海般的信息。

---

### (00:34:04) April Dunford

**English:**
He goes on a G2 Crowd and Software Advice and all these places. There's 9,000 companies listed, they're all in the top ranked quadrant. There's like a thousand of them. Some of them are for big companies. Some of them are small companies. I have no idea how to make a short list, freaking out.

**中文翻译:**
他去了 G2 Crowd、Software Advice 等各种网站。上面列出了 9,000 家公司，而且它们似乎都在“顶级象限”里。大概有一千家看起来都不错。有些是给大公司的，有些是给小公司的。约翰完全不知道该如何筛选候选名单，整个人都崩溃了。

---

### (00:34:17) April Dunford

**English:**
And so somehow they figure out how to make a short list and that person has got to justify this choice to their boss, so there better be something there. I'm not allowed to just throw the dart at it. I'm not allowed to just go back to my VP and say, "I just like the rep better, man. They're all the same. I picked this one by spinning the wheel." No, you got to go back and tell your boss why you made a smart choice.

**中文翻译:**
最后他总算弄出了一个候选名单，而这个人必须向他的老板证明这个选择的合理性，所以必须得有理有据。我不能只是随便扔个飞镖决定，我也不能回去跟 VP 说：“我只是更喜欢那个销售代表，伙计。他们都一样，我是转轮盘选的。”不，你必须回去告诉老板为什么你做了一个明智的选择。

---

### (00:34:43) April Dunford

**English:**
And so we have to be able to give customers that when they get on the sales call with us. The best thing we could do is say, "Look, buddy, there's lots of CRMs out there, and let me tell you how this market shakes out. These ones are really good for big enterprises. These ones are really good, if you got this. These ones are really good, if you got this. But look, if you're this, this and this, you really need these four things and we got that and that's why you should pick us."

**中文翻译:**
所以当客户和我们通电话时，我们必须能提供这些理由。我们能做的最好的事就是说：“听着，伙计，市面上有很多 CRM，让我告诉你这个市场是怎么划分的。这些适合大型企业，这些适合有某种需求的公司。但如果你是 A、B、C 这种情况，你真正需要的是这四样东西，而我们正好有，这就是你为什么应该选我们。”

---

### (00:35:08) April Dunford

**English:**
Because we need to make that customer feel comfortable they've made a good decision. Otherwise, what happens? No decision, that's what happens. If they can't figure that out, they go back to the boss and say, "You know what? All the CRMs are shit. We should just keep using the spreadsheet. It's fine. Let's just allay this." And 40% of the time that's what happened.

**中文翻译:**
因为我们需要让客户觉得他们做了一个正确的决定。否则会发生什么？“未做决定”，这就是后果。如果他们搞不清楚，就会回去跟老板说：“你知道吗？所有的 CRM 都很烂。我们还是继续用 Excel 吧，挺好的。咱们先把这事儿放一放。”40% 的情况都是这样发生的。

---

### (00:35:26) April Dunford

**English:**
So if you can't help the customer figure out how to justify this decision and make this decision and basically come back and say, "I decided this was the right approach to the problem and I picked this one for this reason," then you're not going to get the deal and nobody's going to get the deal.

**中文翻译:**
所以，如果你不能帮助客户弄清楚如何证明这个决定的合理性，并让他们能回来说“我决定这是解决问题的正确方法，我选这个是因为这个原因”，那么你就拿不到订单，谁也拿不到。

---

### (00:35:41) Lenny

**English:**
And in your experience, the fact that here's why it's different from maybe the incumbents or other options ends up being really important? Basically, it's really hard to win by just saying we're better, say better than Slack or better than Zoom. It needs to be-

**中文翻译:**
根据你的经验，“为什么我们与现有产品或其他选择不同”这一点最终变得非常重要？基本上，仅仅说“我们更好”（比如比 Slack 更好或比 Zoom 更好）是很难赢的。它必须是……

---

### (00:35:58) April Dunford

**English:**
But better how? You got to be able to articulate better. So sometimes it's like they have more bells and whistles, but we're simpler and you don't actually need all those bells and whistles. So we're better because we're easier at it, less training, easier to get stood up, whatever.

**中文翻译:**
但“更好”在哪里？你必须能清晰地表达出这种“更好”。有时是这样的：他们有很多花哨的功能，但我们更简单，而你其实不需要那些花哨的东西。所以我们更好，因为我们更容易上手、培训成本更低、部署更快。

---

### (00:36:10) April Dunford

**English:**
Or you might say the opposite of that, we have all the bells and whistles. It's super customizable. You could do whatever you want. Those other things are Mickey Mouse play things. You're a big mature company, you need all the bells and whistles. We're better.

**中文翻译:**
或者你可能会说相反的话：我们拥有所有的高级功能，高度可定制，你想怎么做都行。其他那些产品只是小孩子玩的玩具。你是一家成熟的大公司，你需要这些高级功能。所以我们更好。

---

### (00:36:21) Lenny

**English:**
Great.

**中文翻译:**
太棒了。

---

### (00:36:22) April Dunford

**English:**
And so that better has two pieces to it, what's the value and who cares about that value? Because better means something different to different segments in the market. So better for a small company is not the same thing as better for a large enterprise.

**中文翻译:**
所以这种“更好”包含两个部分：价值是什么，以及谁在意这个价值？因为对于不同的市场细分，“更好”的含义是不同的。对小公司而言的“更好”与对大企业而言的“更好”完全不是一回事。

---

### (00:36:36) April Dunford

**English:**
Your trick in the positioning is to be able to articulate, why are we the best kind of solution for this particular type of customer? That's it. And if you could nail that, then you sell lots of stuff, you beat the other guys, you win deals all the time.

**中文翻译:**
定位的诀窍在于能够清晰地表达：为什么我们是针对这类特定客户的最佳解决方案？仅此而已。如果你能做到这一点，你就能卖出很多东西，击败对手，不断赢得订单。

---

### (00:36:51) Lenny

**English:**
I love that. That's going to be our soundbite from this episode maybe.

**中文翻译:**
我太喜欢这段了。这可能会成为本期节目的金句。

---

### (00:36:54) April Dunford

**English:**
Oh great.

**中文翻译:**
太好了。

---

### (00:36:55) Lenny

**English:**
There it is. I want to go back to the messaging versus positioning. What's the difference between those two concepts?

**中文翻译:**
就是这段。我想回到“信息传达”与“定位”的话题。这两个概念之间有什么区别？

---

### (00:37:02) April Dunford

**English:**
So they get confused a lot and a lot of people will say, "Well, I don't like our messaging. So can you come in and help do messaging?" I think they're really distinct because I see positioning as a fundamental input to messaging.

**中文翻译:**
它们经常被混淆。很多人会说：“我不喜欢我们的信息传达，你能来帮我们做一下信息传达吗？”我认为它们区别很大，因为我把定位看作是信息传达的基础输入。

---

### (00:37:18) April Dunford

**English:**
Most of the time when people say messaging, what they mean is this is the text on the homepage, which is really different from what is my definition of competitive alternative? How do we win in the market? Where do we win in the market? So positioning's all about defining that and then things flow out of that. So I can't write the messaging until I understand, well, who's the message for, and what's our value against who? And so once I understand all of that, then I can understand how to write messaging.

**中文翻译:**
大多数时候人们说“信息传达”，他们指的是官网首页上的文案。这与“我对竞争替代方案的定义是什么”、“我们如何在市场中获胜”、“我们在市场的哪个部分获胜”是非常不同的。定位就是定义这些东西，然后其他东西随之而来。在我弄清楚信息是给谁看的、我们针对谁有什么价值之前，我没法写信息传达。一旦我理解了这一切，我才知道该怎么写文案。

---

### (00:37:46) April Dunford

**English:**
A lot of people get confused between positioning and branding as well. And folks will sometimes use those words interchangeably or they'll talk about brand positioning, which really bugs me. I mean, there's positioning and there's branding, those two things are different.

**中文翻译:**
很多人也会混淆定位和品牌（Branding）。人们有时会交替使用这些词，或者谈论“品牌定位”，这让我很困扰。定位就是定位，品牌就是品牌，这两者是不同的。

---

### (00:38:00) April Dunford

**English:**
But if I was going to work on branding, again, I can't figure out what I want the brand to stand for until I understand, well, who's my target buyer and what's my differentiation from the other alternatives in the market because I want that brand to be distinct.

**中文翻译:**
如果我要做品牌工作，同样地，在我弄清楚目标买家是谁、我与市场其他替代方案的差异化在哪里之前，我无法确定品牌应该代表什么，因为我希望品牌是独特的。

---

### (00:38:17) April Dunford

**English:**
So I need to have positioning figured out first and then practically everything I do in marketing and sales flows downstream from that.

**中文翻译:**
所以我需要先搞定定位，然后我在营销和销售中所做的几乎每一件事都是定位的下游产物。

---

### (00:38:24) Lenny

**English:**
Are there any companies out there that you think need help with their positioning that maybe have an opportunity to work with someone like you?

**中文翻译:**
有没有哪些公司是你认为需要定位方面的帮助，或者可能有机会和你这样的人合作的？

---

### (00:38:32) April Dunford

**English:**
There's some companies that I think you can tell they've not really thought about it. And a lot of times you'll see it in companies where they're brand new and the tech is really spectacular, but you can tell they haven't quite figured out well, so what?

**中文翻译:**
有些公司你能看出来他们根本没仔细想过这个问题。很多时候，你会发现一些初创公司的技术非常惊人，但你能感觉到他们还没搞清楚：“那又怎样？”

---

### (00:38:49) April Dunford

**English:**
So when Magic Leap first launched that stuff was so mind blowing and it was like, oh my gosh, and all their demonstrations, the thing with the elephant and the guy's hand and all that stuff, and you're like, "Wow, that's amazing."

**中文翻译:**
比如 Magic Leap 最初发布时，那些东西太震撼了，天哪，他们所有的演示——大象在人手心里跳舞之类的——你会觉得：“哇，太神奇了。”

---

### (00:39:04) April Dunford

**English:**
And I read this really in depth interview with the founder and he was talking about the tech and this guy's view on the market, it was so interesting, but it was like, so what? What am I actually going to do with that? Who's your target market for this? What is the value of this? We all get it's cool, but what is the actual value of this?

**中文翻译:**
我读过一篇对创始人的深度访谈，他谈论技术和对市场的看法，非常有趣。但问题是：“那又怎样？我到底拿它来干嘛？目标市场是谁？它的价值是什么？”我们都知道它很酷，但它的实际价值是什么？

---

### (00:39:26) April Dunford

**English:**
And you can see now, which I don't know if people know this, but if you go to the Magic Leap site, and I do because I'm interested in Magic Leap because I've been following their story since the beginning, but they've now gotten much tighter on their positioning.

**中文翻译:**
你现在可以看到——我不知道大家是否知道——如果你去 Magic Leap 的官网（我经常去，因为我从一开始就关注他们的故事），你会发现他们现在的定位已经收得非常紧了。

---

### (00:39:42) April Dunford

**English:**
And they're actually selling B2B now, into manufacturing and they're talking about wide frame of view and all this stuff you can do, that's really differentiated than you could with other types of traditional VR things. And so if you look at their positioning, now, it's getting much, much tighter, but at the beginning it was like, what?

**中文翻译:**
他们现在实际上在做 B2B，面向制造业，谈论宽广的视野以及各种你可以实现的操作，这些与传统的 VR 设备相比具有很强的差异化。所以如果你看他们现在的定位，已经变得非常精准了，但刚开始的时候，简直让人摸不着头脑。

---

### (00:39:58) April Dunford

**English:**
And I felt the same thing about Google Glass, when it first came out. It was like, I get why people get excited about it, I just don't get why anybody would buy. I get what it is, but why do we need one of those? I don't see the value in this thing at all.

**中文翻译:**
我对 Google Glass 刚出来时也有同样的感觉。我明白人们为什么兴奋，但我就是不明白为什么有人会买。我知道它是什么，但我们为什么需要它？我完全看不出这东西的价值。

---

### (00:40:11) April Dunford

**English:**
And then again, if you see the applications for Google Glass now, there's a lot of very specific B2B use cases that they're now doubling down on. And they're coming back to the consumer use case a little bit now for some augmented reality stuff that actually sounds like it's useful. But a lot of times what we'll get is the initial launch of something will be this gee-whiz, it's so amazing.

**中文翻译:**
再看看现在 Google Glass 的应用，有很多非常具体的 B2B 使用场景，他们正在这些领域加倍投入。现在他们也开始回归一些听起来确实有用的 AR 消费级场景。但很多时候，新产品的初始发布往往只是“哇，太神奇了”这种噱头。

---

### (00:40:34) April Dunford

**English:**
The archetype of this is the launch of the Segway. So there's been a couple of books written about it, but it's fascinating. The original founder of the Segway was the Elon Musk of his day. He had done three or four other companies, they were all wildly successful. When he got the idea for the Segway, he literally lifted his little pinky and raised a hundred million from Steve Jobs, Jeff Bezos, and a who's who of Silicon Valley venture.

**中文翻译:**
这方面的典型案例是 Segway（平衡车）的发布。关于它已经写了好几本书，非常精彩。Segway 的创始人是那个时代的埃隆·马斯克。他之前创办过三四家公司，都获得了巨大的成功。当他有了 Segway 的想法时，他动动小指头就从史蒂夫·乔布斯、杰夫·贝佐斯以及硅谷的一众风投大佬那里筹集了一亿美元。

---

### (00:40:59) April Dunford

**English:**
And he kept positioning the thing as a revolution in human transport, but he didn't want to let the cat out of the bag, what it was, so he just kept saying that. And he was in the news all over and he's like, "Revolution in human transport." And people were getting so excited because they were like, "What's a revolution in human transport? It's a flying car, man. We're finally getting flying cars."

**中文翻译:**
他一直把这东西定位为“人类交通工具的革命”，但他不想泄露它到底是什么，所以就一直这么说。他登上了各大新闻头条，宣称是“人类交通工具的革命”。人们兴奋极了，心想：“什么是人类交通工具的革命？肯定是会飞的汽车，伙计！我们终于要有会飞的汽车了。”

---

### (00:41:18) April Dunford

**English:**
So everybody's studying his patent filings and all this stuff, and they were like, "Oh my God, we're getting flying cars. It's going to be amazing." And there was such hype around this thing when they launched it that he actually got invited to Good Morning America.

**中文翻译:**
于是所有人都在研究他的专利申请，心想：“天哪，我们要有会飞的汽车了，太棒了。”发布时炒作得非常厉害，他甚至被邀请参加了《早安美国》节目。

---

### (00:41:31) Lenny

**English:**
I was watching that. I was watching that live [inaudible 00:41:33]-

**中文翻译:**
我当时在看，我看了直播……

---

### (00:41:33) April Dunford

**English:**
Yeah, to come on Good Morning America, do the thing and everyone's like, "Oh my God, we're getting flying cars." And then he comes out on the Segway and everyone's like, "What the fuck? That's not what we were promised, man."

**中文翻译:**
是的，在《早安美国》上，大家都期待着：“天哪，会飞的汽车来了。”结果他骑着 Segway 出来了，所有人都在想：“这他妈是什么鬼？这跟承诺的不一样啊，伙计。”

---

### (00:41:45) April Dunford

**English:**
And the interesting thing about this Segway was that refusal to position it at a micro level, left it up to the customers to decide what it was. So even when we saw it was like, "Okay, so it's human transport. We get that, but what should I compare it to? Should I compare it to a car or a bicycle?"

**中文翻译:**
Segway 有趣的地方在于，由于拒绝在微观层面进行定位，它把“它是什么”的决定权留给了客户。所以即使我们看到了它，也会想：“好吧，它是人类交通工具，我们懂了。但我该拿它和什么比？是和汽车比，还是和自行车比？”

---

### (00:42:05) April Dunford

**English:**
And so a lot of the early users were saying it was the worst thing to have a Segway because nobody knew where you were supposed to drive it because they didn't know what it was. So if you were driving on the road, cars were honking at you and they're like, "Get that stupid thing off the road." But if you drive it on the sidewalk, then the ladies with the baby strollers are like, "Get that stupid thing off the sidewalk."

**中文翻译:**
很多早期用户说，拥有一辆 Segway 是最糟糕的事，因为没人知道你该在哪儿骑它，因为没人知道它到底算什么。如果你在马路上骑，汽车会对你按喇叭：“把那蠢东西从路上挪开！”但如果你在人行道上骑，推着婴儿车的女士会说：“把那蠢东西从人行道上挪开！”

---

### (00:42:26) April Dunford

**English:**
And the thing was a colossal failure eventually. The patents are still amazing. The patents just got sold last year or the year before to some company that does these hoverboard things. But the tech was way, way ahead of its time, but there wasn't good positioning to answer the question, who's this for? Why do they care? So what?

**中文翻译:**
这东西最终遭到了巨大的失败。它的专利依然很惊人，去年或前年刚卖给了一家做平衡车的公司。技术远远领先于时代，但没有好的定位来回答：这是给谁用的？他们为什么在意？那又怎样？

---

### (00:42:46) Lenny

**English:**
That's a really good segue to a question I wanted to ask you is when-

**中文翻译:**
这真是一个很好的过渡（Segue，此处 Lenny 玩了个双关语），我想问你的问题是……

---

### (00:42:48) April Dunford

**English:**
Segue, ooh.

**中文翻译:**
过渡（Segue），噢。

---

### (00:42:49) Lenny

**English:**
Wow. Unintentionally intended. When does it make sense for a company to bring in someone like you to go deep on positioning?

**中文翻译:**
哇，无意中的双关。什么时候一家公司应该请像你这样的人来深入研究定位？

---

### (00:42:59) April Dunford

**English:**
I think most companies can do positioning on their own. That's my belief. Some companies I think lack a methodology to follow to go do it. So I wrote a book called Obviously Awesome, and that was the purpose of that book. If you want to do positioning and you just want to start a little exercise and do it yourself in house, you can use my methodology and my way to do it. And I think most companies can get it done that way.

**中文翻译:**
我相信大多数公司都可以自己做定位。我认为有些公司只是缺乏一套可以遵循的方法论。所以我写了《显然很棒》这本书，这就是那本书的目的。如果你想做定位，只想在公司内部开始一个小练习，你可以用我的方法论。我认为大多数公司都能通过这种方式完成。

---

### (00:43:24) April Dunford

**English:**
But most of the ones that come to me have attempted to do that and it hasn't worked out for one reason or another. So sometimes it's because, and this is not unusual in startups, we got an executive team full of A type people and we're all pretty opinionated and we just can't get to agreement on stuff. And it makes a lot of sense to bring an outside person in to help facilitate that conversation, particularly one that's got a lot of experience in positioning.

**中文翻译:**
但大多数来找我的人都尝试过自己做，但由于种种原因没成功。有时是因为——这在创业公司很常见——执行团队里全是 A 型人格的人，大家都很有主见，无法达成共识。这时请一个外部人士来协助对话就非常有意义，尤其是请一个在定位方面经验丰富的人。

---

### (00:43:49) April Dunford

**English:**
So sometimes I get brought in for that reason. Other times I get brought in as companies just feel like they really got to nail it because there's a lot at stake. I've done a lot of work with companies that they're about to hire 10, 15 people in sales or they're about to make a really big investment in marketing and they just want to make sure they really nail it and not have to maybe do a not so great version and then redo it and then redo it again. If you bring me in, then we're going to nail it. There's no way we're going to get to something that isn't good.

**中文翻译:**
有时我是因为这个原因被请去的。另一些时候，是因为公司觉得这件事非成不可，因为赌注很大。我合作过很多公司，他们正准备招聘 10 到 15 名销售，或者准备在营销上投入巨资，他们只想确保定位精准，而不是先做一个平庸的版本，然后改了又改。如果你请我，我们就能一次搞定，绝不会做出不好的东西。

---

### (00:44:17) April Dunford

**English:**
So sometimes people bring me in because they feel like there's a lot at stake. And those are generally the companies that bring me in. Some bigger companies I think bring me in, again, a bit more of a security blanket. We know we could do it ourselves, we kind of got it ourselves, but we'd feel better if we had the expert in here just to make sure we nail it once and we don't have to come back and do this again right away.

**中文翻译:**
所以有时人们请我是因为觉得事关重大。通常是这类公司会找我。一些大公司请我，我觉得更多是为了买个保险。他们知道自己能做，也大概知道怎么做，但如果有专家在场确保一次搞定，他们会觉得更踏实，不用很快又回过头来重做。

---

### (00:44:39) April Dunford

**English:**
So those are the kind of companies typically I work with, but I think a lot of companies could get it done with my book or some methodology, get the gang together and just bang it out themselves. I think everybody should start there.

**中文翻译:**
这些通常是我合作的公司类型。但我认为很多公司可以通过读我的书或学习某种方法论，把大家聚在一起自己搞定。我觉得每个人都应该从那里开始。

---

### (00:44:50) Lenny

**English:**
How long should it take to do this kind of process either on their own and then with you? How long do these things take?

**中文翻译:**
无论是他们自己做还是和你一起做，这种流程通常需要多长时间？

---

### (00:44:57) April Dunford

**English:**
Well, so the work that I do, we do it as a week long sprint. Now there's a bunch of prep that happens before that and there's some stuff we do afterwards, but the actual exercise itself is a series of sessions spread out over a week. I've seen companies do it on their own and they do it in a couple of days. They trap everybody in a room over a couple of days.

**中文翻译:**
我做的工作通常是一个为期一周的冲刺（Sprint）。之前会有很多准备工作，之后也会有一些后续工作，但实际的练习是一周内分布的几次会议。我见过公司自己做，大概花两三天，把所有人关在房间里突击完成。

---

### (00:45:17) April Dunford

**English:**
Assuming you've got the right information to go and start with it, it shouldn't take you too long. And it really depends on how contentious things are because again, what you're trying to get to is agreement and alignment across the team. You're not done until everybody thinks what we've come up with is good.

**中文翻译:**
假设你已经掌握了开始所需的正确信息，那不会花太长时间。这主要取决于争议有多大，因为你的目标是让团队达成共识和对齐。直到每个人都认为我们得出的结论是好的，工作才算完成。

---

### (00:45:33) Lenny

**English:**
So it sounds like you work mostly with larger companies and later stage companies. I mentioned this to you before we-

**中文翻译:**
所以听起来你主要和规模较大的公司以及后期公司合作。我在我们开始前跟你提过……

---

### (00:45:39) April Dunford

**English:**
Yes and no.

**中文翻译:**
是，也不是。

---

### (00:45:39) Lenny

**English:**
Okay. Okay.

**中文翻译:**
好吧。

---

### (00:45:40) April Dunford

**English:**
Yes and no. It depends on how you define that really. I've done a lot of companies that are around 5 million revenue, 10 million revenue in there. So they're beyond seed stage, but I wouldn't call them a large company quite yet.

**中文翻译:**
这取决于你如何定义。我合作过很多年收入在 500 万到 1000 万美元之间的公司。所以他们已经过了种子轮阶段，但我还不会称他们为大公司。

---

### (00:45:55) April Dunford

**English:**
But I will say this, I do get a lot of calls from companies that are super early stage and where I don't think they're ready to actually really ... Well, they're not ready to bring in someone like me, and I think in general, they're not ready to really over tighten their positioning.

**中文翻译:**
但我得说，我确实接到很多处于极早期阶段公司的电话，我认为他们还没准备好……嗯，他们还没准备好请像我这样的人，而且我认为总的来说，他们还没准备好把定位收得太紧。

---

### (00:46:12) April Dunford

**English:**
So I think about it this way. So I've got this new thing, I'm either about to launch it into market or I've got it in market, I've got a handful of customers. At that stage, what I think you've got is a positioning thesis. And so the best thing you could do is deliberately go through a positioning exercise, document the thesis.

**中文翻译:**
我是这样想的：如果你有一个新产品，要么正准备推向市场，要么刚上市，只有少数几个客户。在那个阶段，我认为你拥有的是一个“定位假设”（Positioning Thesis）。你能做的最好的事就是刻意进行一次定位练习，把这个假设记录下来。

---

### (00:46:30) April Dunford

**English:**
And so the thesis says, we think we compete with these folks. We think this is differentiating. This is the value we think we can deliver that no one else can. These are the people we think are going to get really excited about that. Therefore, this is the market we're going to win. But it's just a thesis.

**中文翻译:**
这个假设会说：我们认为我们的竞争对手是这些人；我们认为这是我们的差异化优势；这是我们认为只有我们能提供的价值；这是我们认为会对此感到兴奋的人群；因此，这是我们要赢得的市场。但这仅仅是一个假设。

---

### (00:46:43) April Dunford

**English:**
And so internally it's good for us all to be in alignment internally, but when I go to launch that externally, if I don't have any customers yet, it's very likely, and in my experience, 100% of the time, the thesis is partially incorrect. It's based on a bunch of assumptions and our best guess at it, based on what we did in customer discovery or all our research we did before we built the thing.

**中文翻译:**
在内部达成共识是好事，但当我向外部发布时，如果我还没有客户，根据我的经验，100% 的情况下，这个假设都会有部分错误。它是基于一堆假设和我们的最佳猜测，基于我们在构建产品之前所做的客户调研或研究。

---

### (00:47:05) April Dunford

**English:**
But we always, we're never a hundred percent correct. And so in these cases, I actually think it's better in the early days of a product to keep the positioning a little bit loose and allow the market to pull you maybe in a direction that you didn't think it was going to.

**中文翻译:**
但我们永远不可能百分之百正确。所以在这种情况下，我认为在产品早期，保持定位稍微宽松一点会更好，允许市场把你拉向一个你可能从未想过的方向。

---

### (00:47:23) April Dunford

**English:**
So here's my terrible analogy I use all the time, but I'm going to use it here. But it's like I designed a fishing net and my thesis is this thing's amazing for tuna. It's a tuna fishing net. It's the world's greatest tuna fishing net.

**中文翻译:**
这是我经常用的一个不太恰当的类比，但我还是要在这里用一下。这就像我设计了一个渔网，我的假设是这东西对捕金枪鱼非常有效。它是一个金枪鱼渔网，是世界上最棒的金枪鱼渔网。

---

### (00:47:35) April Dunford

**English:**
So I could launch that and say, "It's just for tuna, only tuna. Don't use it if it's not tuna." And maybe it works for tuna, maybe it doesn't and I don't really know. And if it fails, it fails hard.

**中文翻译:**
我可以发布它并宣称：“这只是给金枪鱼用的，只能捕金枪鱼。如果不是金枪鱼就别用。”也许它对金枪鱼有效，也许无效，我并不确定。如果失败了，会败得很惨。

---

### (00:47:47) April Dunford

**English:**
A better way I think is we know internally that it's the tuna fishing net. That's why we built it. That's what it is, but let's just at the beginning, let's put it out there and keep it a little loose and we say, "It's a net for fish, big fish, all kinds of big fish, any kind of big fish. And then let's just see, let's let the fishermen try it out. Let's see what they pull up."

**中文翻译:**
我认为更好的方法是：我们内部知道它是金枪鱼渔网，这是我们建造它的初衷。但在开始时，我们把它推向市场时保持一点宽松，我们说：“这是一个捕鱼的网，捕大鱼的，各种大鱼都行。”然后让我们看看，让渔民们去试，看看他们能捞上来什么。

---

### (00:48:06) April Dunford

**English:**
And maybe what we discover is, you know what? This thing's actually amazing for grouper and we just didn't know, because we're not grouper people. We didn't really think about grouper. And then once we've got enough of that signal and we start seeing the pattern in who loves our stuff and why, then we can really tighten it up and run at that market.

**中文翻译:**
也许我们会发现：“你知道吗？这东西其实捕石斑鱼效果惊人。”而我们之前并不知道，因为我们不是捕石斑鱼的人，我们压根没想过石斑鱼。一旦我们获得了足够的信号，并开始看到谁喜欢我们的东西以及为什么喜欢的模式（Pattern），那时我们就可以真正收紧定位，全力进攻那个市场。

---

### (00:48:22) April Dunford

**English:**
But at the beginning, I think it's actually okay if your positioning's a little bit loose. And so I think you can worry too much about positioning in the super early days of a product when it's impossible to tighten it up, because you just don't have the data to do it.

**中文翻译:**
但在开始阶段，我认为定位稍微宽松一点其实没关系。我觉得在产品极早期，你可能会过度担心定位问题，而那时由于缺乏数据，根本不可能把定位收得很紧。

---

### (00:48:35) Lenny

**English:**
I know that you touched on this a bit, but what does that transition look like between, okay, it's okay to keep it loose and see where the market pulls to, okay, we got to start taking this seriously? Is there a trigger that's like, okay, let's get into this?

**中文翻译:**
我知道你刚才提到了这一点，但从“可以保持宽松并观察市场走向”到“我们必须开始认真对待定位”的转变过程是怎样的？有没有什么触发信号让你觉得“好吧，我们得开始搞这个了”？

---

### (00:48:47) April Dunford

**English:**
Yeah. It's one of those things that usually like you know when you know. But what you want is you want to start feeling comfortable that there's a pattern and it isn't just like, hey, I got one customer in this segment and one customer in this segment and one customer in this segment and I don't really know.

**中文翻译:**
是的，这通常是一种“到时候你就知道了”的感觉。但你想要的是，你开始感觉到一种模式的存在，而不仅仅是“嘿，我在这类客户里有一个，在那类客户里也有一个”，让你摸不着头脑。

---

### (00:49:06) April Dunford

**English:**
What it usually starts at the beginning is it starts with, you'll say, "Gosh, all kinds of people like our stuff. All kinds of people like our stuff for all kinds of different reasons." And if you're seeing that you don't see the pattern yet.

**中文翻译:**
刚开始通常是这样的，你会说：“天哪，各种各样的人都喜欢我们的东西，而且理由各不相同。”如果你看到的是这种情况，说明你还没发现模式。

---

### (00:49:19) April Dunford

**English:**
And eventually what happens is the pattern starts becoming clear that it's like, oh, all those customers look differently but there's actually this thread through them. Look, they all have the same marketing automation tool. Isn't that interesting? Or they all have the same number of sales people on their team. Isn't that interesting? I've done enough of these pitches now to know if you've got this, this, and this, this pitch is going to go good, and if you don't, it is not going to go good.

**中文翻译:**
最终，模式会变得清晰，你会发现：“哦，虽然这些客户看起来不同，但他们之间有一条主线。看，他们都用同样的营销自动化工具，这不很有趣吗？或者他们的销售团队规模都一样，这不很有趣吗？”我已经做了足够多的推销，现在我知道如果你具备 A、B、C 特征，这次推销就会很顺利；如果不具备，就不会顺利。

---

### (00:49:47) April Dunford

**English:**
So once you start feeling like I got the pattern here, it's starting to come into focus, then I think you're ready to really tighten things up, smash your foot on the gas and say, "We're just going to run at that because we know we can sell here. We know we win pretty much every time when we meet these conditions. Let's go do that."

**中文翻译:**
所以，一旦你开始觉得“我抓到模式了”，它开始变得清晰，那么我认为你就准备好真正收紧定位、踩下油门并宣布：“我们就主攻这个方向，因为我们知道在这里能卖得动。我们知道只要满足这些条件，我们几乎每次都能赢。咱们就这么干吧。”

---

### (00:50:06) Lenny

**English:**
I'm really glad we touched on this topic. I mentioned to you earlier that I was at a meetup last night and I was talking about this podcast that I'm starting and I asked who they'd love to hear on this podcast, and your name was the first name this guy brought up. And so-

**中文翻译:**
我很高兴我们谈到了这个话题。我之前跟你提过，我昨晚参加了一个聚会，聊到了我正在创办的这个播客，我问大家想听谁的访谈，结果有个哥们儿第一个就提到了你的名字。所以……

---

### (00:50:19) April Dunford

**English:**
That's awesome.

**中文翻译:**
太棒了。

---

### (00:50:19) Lenny

**English:**
... he's a huge fanboy. And I asked him what question he would ask you.

**中文翻译:**
……他是你的超级粉丝。我问他会问你什么问题。

---

### (00:50:22) April Dunford

**English:**
I have fans. That's so cool.

**中文翻译:**
我居然有粉丝，太酷了。

---

### (00:50:26) Lenny

**English:**
You're out there. You're out there at meetups. And this is what he wanted to know actually is around just how do you think about this for startups and early stage stuff. So I'm glad we touched on it.

**中文翻译:**
你名声在外，连聚会上都有人提。他其实想知道的就是关于创业公司和早期阶段该如何思考定位。所以我很高兴我们谈到了这一点。

---

### (00:50:32) April Dunford

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:50:33) Lenny

**English:**
The last topic I want to make sure we chat about, and this is what led to our conversation, we had a Twitter exchange about this was around segmentation versus personas and just how people confuse these things and how to think about these topics. And so I guess I'd love to get your take on just what's the difference between say segmentation and personas.

**中文翻译:**
我想聊的最后一个话题——这也是促成我们这次对话的原因，我们在 Twitter 上交流过——是关于“市场细分”（Segmentation）与“用户画像”（Personas）的区别，以及人们是如何混淆这些概念的。我想听听你的看法，市场细分和用户画像到底有什么区别？

---

### (00:50:51) April Dunford

**English:**
Right. So you know how I said earlier marketers, we're really bad with definitions on things? And so everything in marketing is poorly defined and the marketers are always fighting over what do we mean when we say brand and things like this? So personas and segments, oh my gosh, terrible.

**中文翻译:**
没错。记得我之前说过营销人员很不擅长给事物下定义吗？营销中的一切定义都很模糊，营销人员总是在为“品牌”到底是什么意思之类的事情争论不休。用户画像和市场细分，天哪，简直是一团糟。

---

### (00:51:10) April Dunford

**English:**
So now this I think stems from if you go to marketing school, a lot of what you learn in marketing school is very consumer oriented, like consumer product oriented. And so if you're selling to consumers, a lot of the ways a consumer market gets segmented ... So segmentation is the way you split up a market.

**中文翻译:**
我认为这源于如果你去读营销专业，你学到的大部分内容都是面向消费者的，比如消费品导向。如果你是向消费者销售，消费市场的细分方式……所谓细分，就是你划分市场的方式。

---

### (00:51:29) April Dunford

**English:**
So the way you would segment a consumer market is you might say, "Well, I've got this toothpaste. And this toothpaste is for men under the age of 16 that want to get a date or something like that." And that would be how you would segment the market, which coincidentally sounds a lot like a persona.

**中文翻译:**
你细分消费市场的方式可能是：“我有一款牙膏，这款牙膏是给 16 岁以下、想要约会的男生用的。”这就是你细分市场的方式，而这听起来恰好非常像一个用户画像。

---

### (00:51:51) April Dunford

**English:**
So personas are about people and it's characteristics of a particular buyer, a particular type of buyer. And so we'll do personas to try to get really deep understanding of, who is this buyer? What are they care about? What are their hopes and dreams? What makes them scared? What makes them excited? What are they trying to get done? This kind of stuff.

**中文翻译:**
用户画像是关于“人”的，是特定买家或特定类型买家的特征。我们做用户画像是为了深入了解：这个买家是谁？他们在意什么？他们的希望和梦想是什么？什么让他们害怕？什么让他们兴奋？他们想完成什么任务？诸如此类。

---

### (00:52:10) April Dunford

**English:**
Now we go to B2B and that's not how we segment a market. We're not talking about 25 year old down to the age of whatever, whatever. We're segmenting the market on different things. And in fact, in B2B, we can segment a market on almost anything, but typically there would be what we call firmographics, like how big's the company? How many employees? How much revenue? What geography is it in? But then we often do segmentations on things that are nothing to do with that.

**中文翻译:**
但到了 B2B 领域，我们不是这样细分市场的。我们不谈论 25 岁到多少岁的人群。我们根据不同的维度来细分市场。事实上，在 B2B 中，我们可以根据几乎任何维度进行细分，但通常会有所谓的“企业统计特征”（Firmographics），比如公司规模、员工人数、年收入、地理位置。但我们也经常根据与这些无关的因素进行细分。

---

### (00:52:35) April Dunford

**English:**
So if we really want to target a set of customers, often we'll say, "You know what? My product is really good for folks that have a creative team with more than three people and a budget of this and they use this particular software package." We win all day, if we have that.

**中文翻译:**
如果我们真的想针对一组客户，我们经常会说：“你知道吗？我的产品非常适合那些拥有超过 3 人的创意团队、预算在某个范围、并且使用特定软件包的公司。”如果我们遇到这样的客户，我们稳赢。

---

### (00:52:56) April Dunford

**English:**
And that's a very actionable segmentation, I can go find companies that have that, I can make a list of companies that have that. And that's who my marketing and sales is going to go after. If sales needs to make a list of companies to go chase, that's that. And so in my mind, this is super important.

**中文翻译:**
这是一个非常具有可操作性的细分。我可以去找具备这些特征的公司，列出一份清单。这就是我的营销和销售要主攻的对象。如果销售需要一份要去开发的清单，那就是它。所以在我看来，这非常重要。

---

### (00:53:13) April Dunford

**English:**
Coming back to the previous question, when we were talking about, I'm starting to see the patterns in who loves my stuff and why, I'm not talking about the person there, I'm talking about the kind of company. What is common amongst the companies that love us, that I can segment the market and say, "Look, if your company is this size, you have this software package, you have this and this," I'm going to win all day.

**中文翻译:**
回到之前的问题，当我们谈论“我开始看到谁喜欢我的东西以及为什么喜欢的模式”时，我指的不是那个人，而是那种“公司”。那些喜欢我们的公司有什么共同点？我可以据此细分市场并说：“看，如果你的公司是这个规模，有这个软件，有这个和那个特征，我就能赢。”

---

### (00:53:35) April Dunford

**English:**
And so I need to understand that deeply in order to build my whole go-to market strategy, in order to have marketing campaigns that resonate with those kinds of companies, in order to make a list, if my sales are doing outbound, or if I'm doing target account selling, or ABM, how do I make that list of who I'm going after, that kind of stuff.

**中文翻译:**
我需要深入理解这一点，以便构建我的整个进入市场（GTM）策略，以便开展能引起这类公司共鸣的营销活动，以便在销售做主动开发、目标客户销售或 ABM（基于账户的营销）时列出目标清单。

---

### (00:53:53) April Dunford

**English:**
Then we have personas. Now again, if I'm selling a consumer thing, maybe all I care about is personas, all I care about is who's this person who's the buyer. B2B, everything's a little bit more complicated than that. So in a typical B2B purchase process, particularly if it's what we would call enterprise software, even if it's not very expensive enterprise software, typically we have between five and seven people are involved in what we call making the decision for what gets bought.

**中文翻译:**
然后是用户画像。再说一次，如果我卖的是消费品，也许我只关心用户画像，只关心买家是谁。但在 B2B 中，一切都更复杂。在典型的 B2B 采购流程中，特别是所谓的企业软件（即使是不太贵的企业软件），通常会有 5 到 7 个人参与采购决策。

---

### (00:54:24) April Dunford

**English:**
So if I come back to my example earlier where the VP sales decides they need a CRM and they pick on poor John, and then John's got to go figure it out. John, that persona, let's say he's the sales ops manager, we would make a sales ops manager persona that would capture that person, but there's other people involved in this deal.

**中文翻译:**
回到我之前的例子：销售副总裁决定需要一个 CRM，然后指派给可怜的约翰去搞定。约翰这个画像，假设他是销售运营经理，我们会做一个“销售运营经理”的画像来刻画他，但交易中还有其他人。

---

### (00:54:44) April Dunford

**English:**
So as part of figuring out which CRM to buy, when he got in the later stages of the deal, he probably consults some of the sales reps, because they're going to be the end users of this thing, and so he doesn't want to pick something that they're all going to hate.

**中文翻译:**
在决定买哪个 CRM 的过程中，到了交易后期，他可能会咨询一些销售代表，因为他们是最终用户，他不想选一个大家都讨厌的东西。

---

### (00:54:56) April Dunford

**English:**
He's probably got an IT department and IT probably gets to say about, well, does it meet our security and compliance stuff? And we're going to have to take care of it. Does it integrate with what we need to integrate with? Can it suck in data or push out data to our data warehouse or whatever? So that person has a say.

**中文翻译:**
他可能还有个 IT 部门，IT 部门可能会有发言权：它符合我们的安全和合规要求吗？我们需要维护它吗？它能与我们需要集成的系统集成吗？它能从我们的数据仓库导入或导出数据吗？所以那个人也有发言权。

---

### (00:55:14) April Dunford

**English:**
There might be a purchasing department. There might be legal involved. There might be head of security involved. There might be chief security officers. Somebody gets their nose in there and gets involved in that. So five to seven people involved in this deal.

**中文翻译:**
可能还有采购部门，可能涉及法务，可能涉及安全主管或首席安全官。总会有人插手其中。所以一笔交易涉及 5 到 7 个人。

---

### (00:55:26) April Dunford

**English:**
And so here's where I think we go off the rails in marketing. So what I see marketing teams doing is they'll do personas for all those people. So they'll have this sheet and the sheet will say, Eric, the IT person doesn't like talking on the phone, who really likes video games. And they'll have this stereotype of Eric, the IT person. And then they'll say, Janet, the sales rep really outgoing, loves talking to people on the phone. Doesn't know what a video game is, that sort of thing.

**中文翻译:**
我认为营销在这里就开始跑偏了。我看到营销团队在为所有这些人做画像。他们会有一张表，上面写着：IT 人员埃里克，不喜欢打电话，喜欢玩电子游戏。他们对 IT 人员埃里克有一种刻板印象。然后他们会说：销售代表珍妮特，性格外向，喜欢打电话，不知道电子游戏是什么。诸如此类。

---

### (00:56:01) April Dunford

**English:**
So for positioning work, I'm going to say something that is contentious, but I don't think it is at all. Think about how the deal gets done. Here's how this actually happens. Vice president says to John, "Go figure it out." John then does all this research and figures out how to get a short list.

**中文翻译:**
对于定位工作，我要说一些可能有争议的话，但我认为一点争议都没有。想想交易是如何达成的。实际过程是这样的：副总裁对约翰说：“去搞定它。”约翰随后进行所有研究并确定候选名单。

---

### (00:56:18) April Dunford

**English:**
And then John might actually go all the way through to having calls with sales people and all this sort of stuff with all the vendors. And then John's really getting down to, okay, I'm going to pick this thing over this thing and then starts bringing in the other people.

**中文翻译:**
然后约翰可能会一直跟进，与所有供应商的销售人员通话等等。接着约翰真正进入决策阶段：“好吧，我要选这个而不是那个。”然后他才开始把其他人拉进来。

---

### (00:56:30) April Dunford

**English:**
So by far the most important persona that matters is that one. We call this the champion in the account because this person, their job is to get consensus and champion the deal across everybody, including their boss, who's the actual economic buyer, the person that writes the check.

**中文翻译:**
所以到目前为止，唯一重要的画像就是那一个。我们称之为账户里的“内部推动者”（Champion），因为这个人的工作是达成共识，并在所有人面前推动这笔交易，包括他的老板——真正的经济买家，也就是签支票的人。

---

### (00:56:49) April Dunford

**English:**
And so if our positioning doesn't resonate for that champion, we're dead in the water. We don't even get on a short list. We don't even get to care about all the other personas, if we don't nail it with John because John's a gatekeeper.

**中文翻译:**
如果我们的定位不能引起那个“推动者”的共鸣，我们就彻底完蛋了。我们甚至进不了候选名单。如果我们搞不定约翰，我们根本没机会去关心其他画像，因为约翰是守门人。

---

### (00:57:03) April Dunford

**English:**
So my positioning needs to crush it with John. And at some point way down the road, I need to arm John to be able to sell IT, to be able to sell purchasing, to be able to make sure everybody is cool on the user side and to be able to sell their boss, who's the economic buyer.

**中文翻译:**
所以我的定位必须彻底征服约翰。在之后的某个阶段，我需要武装约翰，让他能够去说服 IT 部门、说服采购部门、确保用户端没问题，并且能够说服他的老板（经济买家）。

---

### (00:57:22) April Dunford

**English:**
And so I think there's really only one persona that really, really matters in this, which is the champion in the account. And we should be very thoughtful and we should really have our arms around that persona. And then later in the deal cycle, we need to figure out how to arm that persona to go sell to all the other constituents in the deal. But if we don't nail that champion persona, we got nothing.

**中文翻译:**
所以我认为在这件事中，真正、真正重要的画像只有一个，那就是账户里的“推动者”。我们应该深思熟虑并真正掌控这个画像。在交易周期的后期，我们需要想办法武装这个画像，让他去向交易中的所有其他相关方推销。但如果我们没搞定这个“推动者”画像，我们就一无所有。

---

### (00:57:46) April Dunford

**English:**
So I think it is an utter waste of time for marketing to build these stupid little one pager persona things for these 17 million personas and treat them like they're the same as the champion, when the champion matters times a thousand and all we really need to do is figure out how to arm the champion, because the champion's going to do this, the heavy lifting of selling IT. We're likely not even going to get all that involved. Gee, that's my [inaudible 00:58:12].

**中文翻译:**
所以我认为，营销部门花时间为 1,700 万个画像制作那些愚蠢的单页介绍，并把它们看得和“推动者”一样重要，简直是浪费时间。事实上，“推动者”的重要性是其他人的千倍，我们真正需要做的是弄清楚如何武装“推动者”，因为“推动者”会去承担说服 IT 部门等重活，我们甚至可能都不需要参与那么多。哎呀，这就是我的……（笑）。

---

### (00:58:13) Lenny

**English:**
That was amazing. I've never heard it described so directly and clearly. And so I think that's actually a good way to just wrap things up. I feel like I've sucked up enough of your time. Where can folks find your book, contact you if they want to work with you, anything like that?

**中文翻译:**
太精彩了。我从未听过如此直接且清晰的描述。我认为这是一个很好的总结。我觉得我已经占用了你够多时间了。大家可以在哪里找到你的书，或者如果想和你合作该如何联系你？

---

### (00:58:29) April Dunford

**English:**
Sure. The book's called Obviously Awesome, and you can Google me and find that wherever books are sold. And then there's an audio book, if that's your jam or an E-book or whatever. And then my website is aprildunford.com, so you can find me there. I'm on LinkedIn, I'm on Twitter. I'm @aprildunford on social media, but I don't really do any social media except Twitter and a little bit of LinkedIn these days because I'm feeling less certain about the future of Twitter, but yeah.

**中文翻译:**
好的。书名叫《显然很棒》（*Obviously Awesome*），你可以在谷歌上搜到它，各大书店都有售。如果你喜欢听书，也有有声书，或者电子书。我的网站是 aprildunford.com，你可以在那里找到我。我在 LinkedIn 和 Twitter 上也很活跃，社交媒体账号是 @aprildunford。不过最近除了 Twitter 和一点 LinkedIn，我不太玩别的社交媒体了，虽然我对 Twitter 的未来感到不太确定，但目前还在用。

---

### (00:58:56) Lenny

**English:**
Your tweets are great by the way. I highly recommend following April on Twitter.

**中文翻译:**
顺便说一下，你的推文很棒。我强烈建议大家在 Twitter 上关注 April。

---

### (00:58:59) April Dunford

**English:**
Oh good. Yeah, follow of me on Twitter.

**中文翻译:**
噢，太好了。是的，在 Twitter 上关注我吧。

---

### (00:59:01) Lenny

**English:**
How can listeners be useful to you?

**中文翻译:**
听众们能为你做些什么呢？

---

### (00:59:03) April Dunford

**English:**
That's a great question. I don't know. Well, one thing I will say that I really love about Twitter is I use Twitter a lot to clarify my thinking on things. And so I really appreciate smart interactions with people on Twitter because sometimes I'll have a half-baked idea. And it's one of the things that I really like about Twitter versus LinkedIn, if I have a half-baked idea, I throw it out on LinkedIn and everyone goes, "That's great April," and that's it. Whereas if I have a half-baked idea and I throw it out on Twitter, people aren't shy about telling me I'm wrong.

**中文翻译:**
问得好。我也不知道。不过有一点，我非常喜欢 Twitter 的原因是，我经常用它来理清自己的思绪。我非常感激在 Twitter 上与聪明人的互动，因为有时我会有一些不成熟的想法。这就是我喜欢 Twitter 胜过 LinkedIn 的地方：如果我在 LinkedIn 上发一个不成熟的想法，大家都会说“太棒了 April”，仅此而已。但如果我在 Twitter 上发，人们会毫不客气地指出我错了。

---

### (00:59:36) April Dunford

**English:**
And I appreciate it because I think that's how your thinking gets clearer. I mean, I'd like you to be nice about it if possible, but I like it when people jump in and they go, "Well, actually that doesn't really work if it's this, this and this." And you're like, "Ooh yeah, actually, you're right. Never really thought about that before."

**中文翻译:**
我很感激这一点，因为我认为这能让思考变得更清晰。当然，如果可能的话，我希望大家能客气点，但我喜欢人们跳出来说：“嗯，其实如果情况是 A、B、C，那就不太行得通。”然后你会想：“噢，是的，你是对的，我以前从未想过这一点。”

---

### (00:59:52) April Dunford

**English:**
So people that follow me on Twitter are really useful that way. And then I think I have this really engaged, thoughtful bunch of people following me on Twitter, people that are really interested in this stuff. And so I think it's kind of fun to be able to bat some deeper ideas around on stuff and not just have everybody go thumbs up, yay, April. That's kind of boring to me.

**中文翻译:**
所以关注我的 Twitter 粉丝在这方面非常有用。我觉得我有一群非常投入、有思想的粉丝，他们对这些东西真的很感兴趣。能够就一些深层次的想法进行探讨，而不是每个人都只是点赞说“耶，April”，这很有趣。对我来说，光有点赞挺无聊的。

---

### (01:00:12) Lenny

**English:**
Radical candor, that's what you need.

**中文翻译:**
“激进的坦诚”，这就是你需要的。

---

### (01:00:13) April Dunford

**English:**
Oh yeah, I appreciate the thumbs up. Give me the thumbs up, but if that's all I was trying to do, then I wouldn't be throwing out as much half-baked, sort of controversial hot takes on Twitter as I do.

**中文翻译:**
噢是的，我也感激点赞。给我点赞吧，但如果我只是为了点赞，我就不会在 Twitter 上发那么多不成熟、甚至有争议的犀利观点了。

---

### (01:00:26) Lenny

**English:**
I use Twitter in a very similar way, and so I completely understand that aspect.

**中文翻译:**
我使用 Twitter 的方式非常相似，所以我完全理解。

---

### (01:00:30) April Dunford

**English:**
Yeah, it's great for that.

**中文翻译:**
是的，它在这方面很棒。

---

### (01:00:31) Lenny

**English:**
It's amazing for that. April, thank you so much for making time. I learned a ton and I really appreciate your time.

**中文翻译:**
确实很神奇。April，非常感谢你抽时间过来。我学到了很多，非常感谢你的分享。

---

### (01:00:36) April Dunford

**English:**
All right. Well, thanks so much for having me and congratulations on the new podcast. I'm so excited for it.

**中文翻译:**
好的。非常感谢邀请我，也祝贺你的新播客开播。我非常期待。

---

### (01:00:42) Lenny

**English:**
Me too. Me too. That was awesome. Thank you for listening. If you enjoyed the chat, don't forget to subscribe to the podcast. You could also learn more at lennyspodcast.com. I'll see you in the next episode.

**中文翻译:**
我也是。太棒了。感谢大家的收听。如果你喜欢这次谈话，别忘了订阅本播客。你也可以在 lennyspodcast.com 了解更多信息。我们下期节目再见。