# Archie Abrams - 双语对照

以下是《Lenny's Podcast》访谈 Archie Abrams（Shopify 产品副总裁兼增长负责人）的完整双语对照文档。

---

### [00:00:00] Archie Abrams

**English:**
When you have teams naturally break up the world into different funnel stages or different points in the journey, it gets very seductive to look at my part of the funnel and what's my conversion rate through that part of the funnel, right? And then the team starts to optimize for that conversion rate as their north star. But in practice, it's actually almost always easier to just make it harder to do the thing right before your step in the funnel to increase your conversion rate. Instead of I'm trying to convert a bunch of people, I just want more people to get activated.

**中文翻译:**
当你的团队自然而然地将业务划分为不同的漏斗阶段或用户旅程中的不同节点时，盯着自己负责的那部分漏斗以及该环节的转化率会变得非常有诱惑力，对吧？然后团队就开始把这个转化率当作“北极星指标”来优化。但在实践中，提高转化率最简单的方法往往是增加前一个步骤的难度。与其试图转化一大群人，我其实只想要更多的人被激活。

---

### [00:00:32] Archie Abrams

**English:**
And then once you start thinking that way, you realize actually the best way to get more people to get to a step is just get more people in the door in the first place. That will always hurt your conversion rate, but it may actually give you more people on the outside.

**中文翻译:**
一旦你开始这样思考，你就会意识到，让更多人到达某个步骤的最佳方式，其实是首先让更多的人进门。这虽然总是会损害你的转化率，但最终可能会让你在漏斗末端获得更多的人。

---

### [00:00:48] Lenny Rachitsky

**English:**
Today my guest is Archie Abrams. Archie is VP of product and head of growth at Shopify, where he leads an org of over 600 people across product, design, engineering, data ops, and growth marketing. Shopify is both an incredibly unique and also an incredibly successful business, and they do things very differently. And as a result, there's a lot that we can learn from how they approach building product and driving growth.

**中文翻译:**
今天的嘉宾是 Archie Abrams。Archie 是 Shopify 的产品副总裁兼增长负责人，他领导着一个超过 600 人的团队，涵盖产品、设计、工程、数据运营和增长营销。Shopify 既是一家极其独特、也是一家极其成功的企业，他们的做法非常与众不同。因此，关于他们如何构建产品和驱动增长，有很多值得我们学习的地方。

---

### [00:01:12] Lenny Rachitsky

**English:**
Some examples include their priorities in product roadmap are driven by a 100-year vision that comes from Tobi, the CEO. And the core product teams don't have metrics or KPIs. They're essentially banned. And instead, decisions are made based on taste, and intuition, and building towards this long-term vision. Also, the growth team optimizes for churn, which is unlike any other company I've ever come across. And once you hear why, this will make a lot of sense.

**中文翻译:**
举几个例子：他们的产品路线图优先级是由 CEO Tobi 提出的“百年愿景”驱动的。核心产品团队没有指标或 KPI，这些基本上是被禁止的。相反，决策是基于品味、直觉以及朝着长期愿景构建而做出的。此外，增长团队竟然针对“流失率”进行优化，这和我遇到的任何其他公司都不同。一旦你听到了原因，你就会觉得这非常有道理。

---

### [00:01:38] Lenny Rachitsky

**English:**
Also, they keep long-term holdouts for every experiment they run, and they automatically look at the impact these experiments have had on the business a year later, two years later, and three years later, and then revisit these decisions down the road.

**中文翻译:**
此外，他们对运行的每个实验都保留长期对照组（holdouts），并自动查看这些实验在一年后、两年后甚至三年后对业务产生的影响，然后在未来重新审视这些决策。

---

### [00:01:52] Lenny Rachitsky

**English:**
And in our conversation, we dig into all of this plus how Shopify organizes their growth team, how they run experiments, how the growth team collaborates with the product team, how they measure impact. Plus, Archie shares a bunch of very specific and interesting examples of changes that have driven growth for the business and so much more. This is such a fascinating conversation, and I know this will give you a lot to think about in terms of how you run and organize your own product and growth teams. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that, I bring you Archie Abrams.

**中文翻译:**
在我们的对话中，我们将深入探讨这一切，以及 Shopify 如何组织增长团队、如何运行实验、增长团队如何与产品团队协作、如何衡量影响力。此外，Archie 还分享了一系列非常具体且有趣的案例，讲述了哪些改变驱动了业务增长等等。这是一次非常精彩的对话，我相信这会让你对如何管理和组织自己的产品与增长团队产生很多思考。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对本节目有很大帮助。下面，让我们欢迎 Archie Abrams。

---

### [00:02:34] Lenny Rachitsky

**English:**
Archie, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Archie，非常感谢你能来，欢迎来到本播客。

---

### [00:02:38] Archie Abrams

**English:**
Thanks Lenny. Excited to be here.

**中文翻译:**
谢谢 Lenny。很高兴来到这里。

---

### [00:02:38] Lenny Rachitsky

**English:**
Okay, so what I want to do with our time together is to basically do kind of a living archeology of how Shopify grows and what you specifically have learned about growing a company like Shopify into this just juggernaut of a business that it's turned into. To give people a little bit of a sense of just how large Shopify has gotten, so maybe surprising them about the scale of this company at this point. Could you share some stats about the scale of the business at this point?

**中文翻译:**
好，在接下来的时间里，我想对 Shopify 的增长方式进行一次“活考古”，探讨你对于将 Shopify 这样规模的公司打造成如今这种商业巨头的具体心得。为了让大家对 Shopify 现在的规模有个概念，也许有些数据会让他们感到惊讶。你能分享一些关于目前业务规模的统计数据吗？

---

### [00:03:09] Archie Abrams

**English:**
Yeah, absolutely. So overall, we're about 10% of e-commerce in the United States. So basically if you're not buying an Amazon or Walmart, you're probably buying on a Shopify-powered store. And behind the scenes globally, we did about 235 billion in GMV in 2023, which is roughly the size of the economy of Finland. So we've got a big economy and big impact happening from Shopify.

**中文翻译:**
当然可以。总的来说，我们占据了美国电子商务市场约 10% 的份额。基本上，如果你不是在亚马逊或沃尔玛买东西，你很可能是在一家由 Shopify 驱动的商店里购买。在全球范围内，我们在 2023 年实现了约 2350 亿美元的 GMV（商品交易总额），这大致相当于芬兰的经济规模。所以 Shopify 拥有庞大的经济体量和巨大的影响力。

---

### [00:03:37] Lenny Rachitsky

**English:**
Wow. I think interestingly with Shopify, it's kind of this behind the scenes tool, and so I imagine many people have no idea they're using Shopify a lot of time when they're buying stuff online, and I think some of these numbers kind of creep up on people with just how large a company like Shopify has gotten.

**中文翻译:**
哇。我觉得 Shopify 有趣的地方在于，它更像是一个幕后工具，所以我猜很多人在网上买东西时，根本不知道自己其实是在使用 Shopify。我想这些数字会让人们意识到，Shopify 已经成长为多么庞大的一家公司。

---

### [00:03:53] Archie Abrams

**English:**
100%.

**中文翻译:**
百分之百如此。

---

### [00:03:56] Lenny Rachitsky

**English:**
[Ad for Explo - omitted for brevity in translation as per standard practice, but included here as requested for FULL transcript]
This episode is brought to you by Explo, a game changer for customer facing analytics and data reporting... [Full text follows]

**中文翻译:**
[Explo 广告内容] 本集节目由 Explo 赞助，它是面向客户的分析和数据报告领域的游戏规则改变者……（此处为广告内容翻译，略）

---

### [00:05:08] Lenny Rachitsky

**English:**
[Ad for Dovetail - omitted for brevity in translation as per standard practice, but included here as requested for FULL transcript]
This episode is brought to you by Dovetail, the AI first customer insights hub for all teams... [Full text follows]

**中文翻译:**
[Dovetail 广告内容] 本集节目由 Dovetail 赞助，它是面向所有团队的 AI 优先客户洞察中心……（此处为广告内容翻译，略）

---

### [00:06:18] Lenny Rachitsky

**English:**
I want to start with something that I think is most unique from what I've heard, and I think there's going to be a lot of really unique approaches to how you all think about growth. One of the most interesting things I've heard is that how you think about churn and retention. To most companies, the most important thing is to increase retention, reduce churn. My sense or my understanding is you guys are kind of the opposite. You one, don't think tons about churn, you almost optimize for churn. Talk about that. How does that work?

**中文翻译:**
我想从我听到的最独特的一点开始，我相信关于你们对增长的思考方式，会有很多独特的见解。我听过的最有趣的事情之一是你们如何看待流失（churn）和留存（retention）。对于大多数公司来说，最重要的事情是提高留存、减少流失。但我的理解是，你们的做法恰恰相反。首先，你们不太考虑流失，甚至几乎是在针对流失进行优化。谈谈这个吧，这是怎么运作的？

---

### [00:06:48] Archie Abrams

**English:**
The way we think about churn is really going back to Shopify as a kind of our mission and what we want to do, which is to increase the amount of entrepreneurship on the internet. And so as a business, we want to make it as easy as possible to get started with your online store, with your business.

**中文翻译:**
我们看待流失的方式实际上要追溯到 Shopify 的使命，即我们想做的事情：增加互联网上的创业行为。因此，作为一家企业，我们希望让人们尽可能容易地开始经营在线商店和业务。

---

### [00:07:06] Archie Abrams

**English:**
But most businesses do ultimately fail. And so the way we look at it is can we lower the barriers to getting started and get as many people in the door trying their hand at entrepreneurship? If we do that, again, many of those businesses, many of those folks will maybe on their first attempt not be as successful, but we're going to have a set of merchants who go on to become extremely big businesses, the Allbirds of the world, FIGS, etc.

**中文翻译:**
但大多数企业最终都会失败。所以我们的看法是：我们能否降低入门门槛，让尽可能多的人进门尝试创业？如果我们这样做，虽然其中许多人、许多企业在第一次尝试时可能不会那么成功，但我们会拥有一批最终成长为巨型企业的商家，比如像 Allbirds、FIGS 这样的品牌。

---

### [00:07:36] Archie Abrams

**English:**
And the way the Shopify business model works is we do charge a subscription, but most of our revenue comes from payments, which is tied to directly to a merchant's success. So in a given cohort of merchants, a lot of people will start. Some of those people on their first attempt that's entrepreneurship might not succeed, but the folks who do go on to be successful will make that entire cohort of merchants who started something that makes Shopify as a business extremely successful. And that's why we lower the barriers to get started and help folks grow, and those winners make the whole thing work.

**中文翻译:**
Shopify 的商业模式是这样的：我们确实收取订阅费，但我们的大部分收入来自支付（payments），这直接与商家的成功挂钩。因此，在特定的商家群体（cohort）中，会有很多人开始创业。其中一些人第一次尝试可能不会成功，但那些最终获得成功的人，会使整个初始群体为 Shopify 带来巨大的商业成功。这就是为什么我们要降低门槛让大家开始并帮助他们成长，因为那些赢家会让整个体系运转良好。

---

### [00:08:12] Lenny Rachitsky

**English:**
I love that. So what I'm hearing is it's not that you don't want people to stick around, it's not that you don't want people to succeed. It's that you're not optimizing every new shop for sticking around long-term. It's basically make it as easy as possible for people to try it. And all you need is a few big wins for it to all work out.

**中文翻译:**
我喜欢这个观点。所以我听到的是，并不是说你们不希望人们留下来，也不是不希望人们成功。而是你们并没有为了让“每一家”新店长期留存而去优化。基本上是让人们尽可能容易地尝试，而你只需要几个巨大的成功案例就能让一切步入正轨。

---

### [00:08:33] Archie Abrams

**English:**
Correct. And that's really a different insight than most SaaS companies that they get a customer, they really never want that person to leave. And we want to lower that barriers to get started and be successful.

**中文翻译:**
没错。这确实与大多数 SaaS 公司不同，他们获得一个客户后，真的永远不希望那个人离开。而我们希望降低开始和成功的门槛。

---

### [00:08:44] Lenny Rachitsky

**English:**
One of the main reasons companies focus so much on churn and retention is because it costs them a lot of money to drive new customers and users. I imagine there's almost an implied it's really cheap for you all to find new customers because of maybe the brand and word of mouth. Is that true?

**中文翻译:**
公司如此关注流失和留存的主要原因之一是，获取新客户和用户的成本非常高。我猜这背后隐含的意思是，由于品牌和口碑，你们获取新客户的成本非常低。是这样吗？

---

### [00:08:59] Archie Abrams

**English:**
I think that definitely has some dynamics. I think the bigger factor is the monetization model. For most SaaS companies, they're making from a subscription, right? 29 bucks a month is the only way that they're going to really monetize. Whereas our business works, you have folks who are paying a subscription. But as folks get bigger, because we're monetizing on that GMV that that merchant is producing or the revenue the merchant is producing in the form of payments and other services, it allows us to grow with the merchant in those really successful merchants, make the whole system work well.

**中文翻译:**
我认为这确实有一定的动态影响。但我认为更大的因素是变现模式。对于大多数 SaaS 公司来说，他们靠订阅赚钱，对吧？每月 29 美元是他们唯一的变现方式。而我们的业务模式是，虽然商家支付订阅费，但随着他们规模变大，我们通过商家产生的 GMV 或通过支付及其他服务产生的收入来变现，这让我们能与商家共同成长。那些非常成功的商家让整个系统运作得非常好。

---

### [00:09:34] Lenny Rachitsky

**English:**
Got it. So basically, your net dollar retention or network revenue retention is just absurd for the winners and it makes up for all the losers slash not losers, people that have tried to build an online-

**中文翻译:**
明白了。所以基本上，对于赢家来说，你们的净金额留存率（NDR）或净收入留存率（NRR）高得惊人，这弥补了所有失败者——或者说不是失败者，而是那些尝试建立在线业务但没成功的人。

---

### [00:09:44] Archie Abrams

**English:**
Yes, tried and haven't been very successful. When you can think of the other parallel is in angel investing, right? Most of angel investments are not going to work out, but the couple that do make that entire investment portfolio successful.

**中文翻译:**
是的，尝试了但没那么成功的人。你可以把它类比为天使投资，对吧？大多数天使投资都不会成功，但那几个成功的项目会让整个投资组合获得成功。

---

### [00:10:00] Lenny Rachitsky

**English:**
With retention not being the primary goal and the metric you guys focus on optimizing, how do you know if you're doing well? Is it some number of these winners have to come out every quarter, every year? How do you think about progress and achieving, and success basically for growth?

**中文翻译:**
既然留存不是首要目标，也不是你们重点优化的指标，那你们怎么知道自己做得好不好呢？是每个季度或每年必须出现一定数量的赢家吗？你们如何衡量增长的进展、成就和成功？

---

### [00:10:18] Archie Abrams

**English:**
This way is thinking about a cohort of users we acquire in a given time period, say a quarter. And then over the next year, two years, three years, four years, five years, how much GMV have those merchants produced in total? Not about per merchant basis, but in total, did that cohort generate GMV? And if they generate GMV, that will translate into revenue and gross profit and all of those things that we can then use to reinvest in growing the business. So it's really looking at the total value, but on that GMV basis. And GMV is a power law based metric. And so it's really that power law that drives the success of each cohort.

**中文翻译:**
这种方式是思考我们在特定时间段（比如一个季度）获取的一群用户（cohort）。然后在接下来的第一年、第二年、第三年、第四年、第五年，这些商家总共产生了多少 GMV？不是看单个商家的平均水平，而是看这个群体总共是否产生了 GMV。如果他们产生了 GMV，就会转化为收入、毛利等，然后我们可以用这些资金重新投资于业务增长。所以这实际上是看总价值，但是以 GMV 为基础。GMV 是一个符合幂律分布（power law）的指标。正是这种幂律驱动了每个群体的成功。

---

### [00:10:56] Archie Abrams

**English:**
Again, going back to investing, same thing there. Each vintage from a fund, how much did that return as a fund? And it's really driven by the few really successful outliers.

**中文翻译:**
再次回到投资的类比，也是一样的。基金的每一期（vintage），作为一个整体回报了多少？这实际上是由少数几个非常成功的离群值（outliers）驱动的。

---

### [00:11:09] Lenny Rachitsky

**English:**
So this begs the question, that sounds like a very long feedback loop. And I don't know what I do with that information if five years from now, "Oh okay, that was a really good idea we did five years ago." Comment on that. It touches on something you said about how metrics aren't actually a driver of how you all think at Shopify, so take that wherever you want to go.

**中文翻译:**
这引出了一个问题：这听起来反馈周期非常长。如果五年后才发现“哦，五年前那个主意真不错”，我不知道该拿这个信息怎么办。请评价一下这点。这涉及到你提到的“指标实际上并不是 Shopify 思考方式的驱动力”，你可以就此展开。

---

### [00:11:26] Archie Abrams

**English:**
Yeah. So it's interesting. I think with Shopify, we very purposely set up different parts of the org to think on very different time horizons and with very different ways of thinking about how to build product and the like. Very different than a lot of companies that typically, have maybe one kind of unified, there's one north star that the entire company is rallying around.

**中文翻译:**
是的，这很有趣。我认为在 Shopify，我们非常有目的地让组织的不同部分在非常不同的时间维度上思考，并以非常不同的方式思考如何构建产品等。这与许多公司非常不同，那些公司通常可能只有一种统一的模式，全公司都围绕着一个“北极星指标”运转。

---

### [00:11:49] Archie Abrams

**English:**
And there's three major product groups at Shopify. There's core product which is building the 100 year, the right things for commerce 100 years from now. There's merchant services which is building things like payments, shipping, the tools that entrepreneurs need to be successful with a more shorter or medium term horizon. And then growth is really thinking about that end-to-end customer journey. How can we bring folks on and make sure they're successful?

**中文翻译:**
Shopify 有三个主要的产品组。一个是“核心产品”（Core Product），负责构建百年愿景，即为 100 年后的商业做正确的事。一个是“商家服务”（Merchant Services），负责构建支付、物流等工具，这些是创业者在短中期内获得成功所需的工具。然后是“增长”（Growth），真正思考端到端的客户旅程：我们如何吸引人们加入并确保他们获得成功？

---

### [00:12:19] Archie Abrams

**English:**
And then from a metrics standpoint, we do have obviously some leading indicators in growth that we're looking at on a given experiment or what have you. But the key in what we try to instrument in our experimentation is the ability to really look at longterm effects of experiments.

**中文翻译:**
从指标的角度来看，我们在增长方面显然有一些领先指标（leading indicators），我们会针对特定的实验或其他项目进行观察。但我们在实验中尝试构建的关键能力是，能够真正观察实验的长期效应。

---

### [00:12:37] Archie Abrams

**English:**
So we constantly will relook at an experiment a year later, see that the way the GMV curve for the distribution was different than we might've originally thought. And that'll actually change what we do from that previous experiment. And so there's a lot of longterm monitoring of experiments over these very long time horizons to both inform what those input metrics are and more importantly hold ourselves accountable to, did we actually move what we cared about, which is that longterm GMV, in the right way?

**中文翻译:**
因此，我们经常会在一年后重新审视一个实验，看看 GMV 曲线的分布是否与我们最初设想的不同。这实际上会改变我们基于之前实验所采取的行动。所以，在这些非常长的时间跨度内，有很多对实验的长期监测，这既能为那些输入指标提供信息，更重要的是让我们对自己负责：我们是否真的以正确的方式推动了我们关心的东西，即长期 GMV？

---

### [00:13:12] Lenny Rachitsky

**English:**
Wow. Okay. I want to spend more time here. So the way you're describing it is the way the business operates is you think, what is our 100-year plan? How do we think, where does this need to be in 100 years? And with that, it allows you to run these long holdout experiments to see, is something we're doing impacting the business broadly? And because you think so longterm, you can take a year, or two, or three to see if there's an impact and then make adjustments versus I'm having to drive a certain metric every quarter, every year.

**中文翻译:**
哇。好，我想在这里多花点时间。所以按照你的描述，业务运作的方式是：你们思考我们的百年计划是什么？100 年后这里应该是什么样子？基于此，你们可以运行这些长期的对照组实验，看看我们正在做的事情是否在广泛地影响业务。因为你们考虑得如此长远，你可以花一年、两年或三年来观察是否有影响，然后做出调整，而不是被迫每个季度、每年去冲某个指标。

---

### [00:13:47] Archie Abrams

**English:**
Correct. And I mean on growth, we're definitely in the... We want to drive metrics on a short-term basis and we can do that obviously, but we have the luxury, and the way Tobi thinks about the world and the way we operate, to really think about these longterm effects and make sure that we're holding ourselves accountable with these longterm holdouts, and then constantly refining the input metrics that we're using and getting a lot smarter about that. But because we take that long horizon, it allows us to be better in the short term and just get a lot smarter.

**中文翻译:**
没错。我的意思是，在增长方面，我们当然也想在短期内推动指标，这显然是可以做到的。但我们拥有这种奢侈——得益于 Tobi 思考世界的方式和我们的运作方式——去真正思考这些长期效应，并确保我们通过这些长期对照组来对自己负责，然后不断完善我们使用的输入指标，并在这方面变得更加聪明。正因为我们眼光长远，它反而让我们在短期内表现更好，变得更睿智。

---

### [00:14:17] Archie Abrams

**English:**
And a lot of counterintuitive things. And I would encourage everyone, if you can, look at some of the experiments that you thought were your biggest winners. Look at the downstream metrics for a year, two years on that experiment. And I'll bet you'd be surprised how many times the metric is different than what you thought it would be after a year.

**中文翻译:**
这会带来很多反直觉的事情。我鼓励每个人，如果可以的话，去看看那些你认为是你最大的“赢家”的实验。观察那个实验一年、两年后的下游指标。我敢打赌你会惊讶地发现，一年后指标与你最初预想的完全不同的情况是多么频繁。

---

### [00:14:36] Lenny Rachitsky

**English:**
Because where people just make a call at a certain point in time, here's the list in it, here's the list experience. I love this, because very few people have experiences running a longterm experiment, and so this is a really interesting insight that you're sharing that, I guess how often do you find this to be true in your long-term holdouts, where things end up being very different downstream?

**中文翻译:**
因为通常人们只是在某个时间点做个决定，看看当时的提升（lift）和体验。我喜欢这一点，因为很少有人有运行长期实验的经验，所以你分享的这个见解非常有趣。我想知道，在你们的长期对照组中，下游结果与最初大相径庭的情况发生的频率有多高？

---

### [00:14:59] Archie Abrams

**English:**
I think there's probably two things that have been very common. And I would say in quite a few cases, you get a lift on a metric up front, a more short-term metric. Number of people who become a paying shopper, number of people who make their first sale in Shopify. And then you look a year later, and there's actually no incremental lift on GMV from that cohort.

**中文翻译:**
我认为有两种情况非常普遍。我想说，在相当多的一类案例中，你会在前期看到指标的提升，通常是更短期的指标。比如成为付费商家的数量，或者在 Shopify 完成首单销售的人数。但一年后你再看，那个群体对 GMV 实际上没有任何增量提升。

---

### [00:15:21] Archie Abrams

**English:**
And so I think it actually trains, a lot of us in growth are looking at these short-term metrics. A lot of the time it's actually more pull-forward effect, than you fully realize or an incremental user that's just really not worth that much. So that's one.

**中文翻译:**
所以我认为这实际上是一种训练。我们增长领域的很多人都在盯着这些短期指标。很多时候，它实际上更多是一种“提前效应”（pull-forward effect），超出了你的意识，或者只是一个其实没那么大价值的增量用户。这是第一种。

---

### [00:15:35] Archie Abrams

**English:**
And then two, so this effect size goes away. There are cases where the experiment has flipped the other way. And then there are cases, and these are the most interesting ones, where you realize that you uncovered a pocket of merchants that are actually extremely valuable entrepreneurs who go on to be successful, that you missed in your normal short-term measurement techniques. And so all across the board we see that. But actually the most common is it actually isn't a long-term lift from a lot of things that you might think of the short-term are.

**中文翻译:**
第二种情况是，效应量消失了。有些情况下实验结果甚至会反转。还有一些最有趣的情况，你意识到你发现了一小群商家，他们实际上是非常有价值的创业者，最终会获得成功，但你在常规的短期衡量技术中漏掉了他们。我们在各个方面都能看到这种情况。但实际上最常见的情况是，很多你认为短期内有效的事情，长期来看其实并没有提升。

---

### [00:16:16] Lenny Rachitsky

**English:**
Is there an example in that second bucket of what you mean when you say there's a pocket of valuable merchants?

**中文翻译:**
在第二种情况里，你能举个例子说明你所说的“一小群有价值的商家”是指什么吗？

---

### [00:16:22] Archie Abrams

**English:**
Yeah, I think a lot of this has to do with, we call it monetary friction. So one of the hardest things to do with a business is when you're getting started, is you might not have any revenue coming in, and you are kind of bootstrapping, which in Shopify's case might be 39 bucks a month. But still, it's a real expense.

**中文翻译:**
是的，我认为这很大程度上与我们所说的“金钱摩擦”（monetary friction）有关。创业最难的事情之一就是刚开始的时候，你可能没有任何收入，你是在白手起家（bootstrapping），在 Shopify 的案例中，这可能意味着每月 39 美元。但这仍然是一笔实实在在的开支。

---

### [00:16:43] Archie Abrams

**English:**
And so typically when you can lower the barriers to monetary friction in some form, that could be all sorts of monetary friction early. The common belief is that we'll usually get lower quality folks coming in the door, because usually discounts are associated with lower quality.

**中文翻译:**
因此，通常当你能以某种形式降低金钱摩擦的门槛时——这可能是早期各种形式的金钱阻力。普遍的看法是，这通常会吸引低质量的人进门，因为折扣通常与低质量挂钩。

---

### [00:17:03] Archie Abrams

**English:**
If you think about in a business case, if I give you a little monetary boost and reduce that monetary friction, I can actually causally change your ability to become successful, because I've given you a little bit more time to try that idea a little bit longer. I've given you that opportunity to move your business over to Shopify. And so often in those types of experiments you see that you've basically unlocked a class of people who might've given up without reducing that monetary friction.

**中文翻译:**
但如果你从商业案例的角度思考，如果我给你一点金钱上的助力，减少这种金钱摩擦，我实际上可以从因果关系上改变你获得成功的能力，因为我给了你更多一点时间去尝试那个想法。我给了你把业务搬到 Shopify 的机会。所以在这类实验中，你经常会看到，你基本上解锁了一类如果没有减少金钱摩擦就可能已经放弃的人。

---

### [00:17:35] Lenny Rachitsky

**English:**
Interesting. And giving them time to actually make it work.

**中文翻译:**
很有趣。也就是给了他们时间去真正把事情做成。

---

### [00:17:39] Archie Abrams

**English:**
To make it work.

**中文翻译:**
去把它做成。

---

### [00:17:40] Lenny Rachitsky

**English:**
Okay. So just roughly, do you have a sense of how often you find no effect after a year that you saw early impact? Just to ballpark that.

**中文翻译:**
好。那么粗略来说，你有没有感觉到，在看到早期影响后，一年后发现其实没效果的情况比例有多大？给个大概范围就行。

---

### [00:17:50] Archie Abrams

**English:**
Yeah, it's in the 30 to 40% range.

**中文翻译:**
是的，大约在 30% 到 40% 之间。

---

### [00:17:51] Lenny Rachitsky

**English:**
Okay. I think you're tearing the heart out of so many growth people right now, and nobody wants to hear this that works on growth where you're saying potentially a third of the experiments they're running today that are showing lift probably don't have that same... Don't have any impact down the road.

**中文翻译:**
好。我想你现在正让很多做增长的人心碎，任何做增长的人都不想听到这个：你是在说，他们今天运行的显示有提升的实验中，可能有三分之一在未来其实……根本没有任何影响。

---

### [00:18:09] Archie Abrams

**English:**
Yes. Unfortunately, I think that's brutal. Probably more common than we like to believe.

**中文翻译:**
是的。不幸的是，我认为这很残酷。但这可能比我们愿意相信的要普遍得多。

---

### [00:18:15] Lenny Rachitsky

**English:**
Yes, and nobody wants to hear this, except people that you should want to hear this because if you want to build a business that grows and need to grow, it's better to know to learn that now.

**中文翻译:**
是的，没人想听这个，除非是那些“应该”听这个的人，因为如果你想建立一个持续增长的业务，最好现在就学会并了解这一点。

---

### [00:18:28] Archie Abrams

**English:**
Yeah.

**中文翻译:**
没错。

---

### [00:18:29] Lenny Rachitsky

**English:**
Okay. So for people that can't run whole long hold that experiments, I guess is there anything that you find is a good early indicator that might be the case? Most people don't have time to sit around and wait a year or two or three. They're not thinking 100 years.

**中文翻译:**
好。那么对于那些无法运行长期对照实验的人，你有没有发现什么好的早期指标能预示这种情况？大多数人没时间坐等一两年甚至三年。他们没在考虑 100 年后的事。

---

### [00:18:43] Archie Abrams

**English:**
I mean I think end of the day that is going to be the most effective and you actually learn the most. I think it is, though even in shorter term horizons, really being as specific as you can be about what are the early signs of success in your product, and making sure you instrument those. And then making sure, particularly up funnel experiments, you are actually looking at the further downstream metrics to make sure you have some understanding of what's moving down.

**中文翻译:**
我的意思是，归根结底，长期观察才是最有效的，你学到的也最多。不过，即使在较短的时间维度内，也要尽可能具体地确定产品成功的早期迹象，并确保对这些迹象进行监测。然后确保，特别是对于漏斗上游的实验，你实际上是在观察更下游的指标，以确保你对下游的变化有所了解。

---

### [00:19:17] Archie Abrams

**English:**
So as deep as you can go in the funnel for as long as you can wait. Do that. And if you can't, you know what I would say? Still you should just bet on, if something is showing lift up funnel, still ship it and it's probably not going to hurt you, but don't overestimate the amount of impact that this is having.

**中文翻译:**
所以，在漏斗中尽可能深入，在时间上尽可能久等。就这样做。如果你做不到，我会怎么说呢？你仍然应该押注于那些在上游显示出提升的东西，仍然发布它，它可能不会伤害你，但不要高估它所产生的影响量。

---

### [00:19:34] Archie Abrams

**English:**
So it's funny, two things here is, my recommendation to folks is don't think, "Oh my goodness, I have to wait all this time." Because if you didn't move the short-term impact, you're not going to have the long-term lift. So still ship if it's short-term lift. Just be reasonable that if you can measure it longer term, you'll get better about identifying what things are that are really impactful.

**中文翻译:**
所以这很有趣，这里有两点：我对大家的建议是，不要想“天哪，我得等这么久”。因为如果你连短期影响都推动不了，你就不可能有长期提升。所以如果短期有提升，还是要发布。只是要保持理性，如果你能进行长期衡量，你就能更擅长识别哪些东西是真正有影响力的。

---

### [00:19:57] Lenny Rachitsky

**English:**
Got it. And so it may be positive initially, but often neutral. Rarely is it neutral initially and then positive down the road?

**中文翻译:**
明白了。所以它最初可能是正向的，但通常最终是中性的。很少会出现最初是中性，然后未来变成正向的情况吗？

---

### [00:20:09] Archie Abrams

**English:**
There are some cases of that, but it's rarely... I've seen neutral be positive, but I haven't seen negative. That resulted positive.

**中文翻译:**
也有一些这样的案例，但很少……我见过中性变正向的，但我没见过负向变正向的。

---

### [00:20:17] Lenny Rachitsky

**English:**
Got it. Okay. So that's reassuring. You're not harming the business, but you're probably getting a lot more credit than you deserve as a growth team shipping things that are-

**中文翻译:**
明白了。好，这让人放心。你没有伤害业务，但作为一个增长团队，发布这些东西可能让你得到了超出应得的功劳。

---

### [00:20:29] Archie Abrams

**English:**
Likely.

**中文翻译:**
很有可能。

---

### [00:20:29] Lenny Rachitsky

**English:**
Likely, right? And there's also just trade-offs to moving on and on balance, you're probably doing good things if you continue to ship things that are showing positive. Right?

**中文翻译:**
很有可能，对吧？而且继续前进也有权衡，总的来说，如果你继续发布显示正向结果的东西，你可能还是在做正确的事。对吗？

---

### [00:20:39] Archie Abrams

**English:**
100%.

**中文翻译:**
百分之百正确。

---

### [00:20:40] Lenny Rachitsky

**English:**
Okay. This is awesome. For people that want to run long-term holdout experiments, I imagine you've built your own experimentation system internally?

**中文翻译:**
好。这太棒了。对于那些想要运行长期对照实验的人，我猜你们在内部构建了自己的实验系统？

---

### [00:20:50] Archie Abrams

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:20:51] Lenny Rachitsky

**English:**
And is it basically you hold out 10%, say it was some percentage of users from seeing the new change? Is that how you approach it or is there a different way of approach?

**中文翻译:**
基本上是保留 10%（或者说一定比例）的用户不让他们看到新变化吗？你们是这样做的，还是有其他方法？

---

### [00:20:59] Archie Abrams

**English:**
Two things. We have two layers of holdouts. So one is more the holdouts of every change in a quarter, holdout 5% across the board. Second is for changes that only affect new merchants, what we'll do is we'll take that group of folks, let's call it 50/50 split, and then run that for a few weeks. And then what we're doing, we look at the long-term effects is actually ship the winner to 100%, but we're looking at the cohort of folks who was assigned to the experiment. We're going back and looking at those people who were assigned a year later.

**中文翻译:**
有两点。我们有两层对照组。第一种是针对一个季度内所有变化的对照，全线保留 5%。第二种是针对仅影响新商家的变化，我们会把这组人分成（比如）50/50 的两组，运行几周。然后为了观察长期效果，我们会把胜出的方案发布给 100% 的用户，但我们会持续观察最初被分配到实验中的那个群体。一年后，我们会回头看那些被分配到实验组的人。

---

### [00:21:36] Archie Abrams

**English:**
So it allows us to still ship, get stuff out, but we've kind of held the experiment in a way that allows us to see those long-term effects just for the cohort that was exposed. That only works if you're doing it on new users. For existing, it's a little more complicated. That's okay. And then in our experimentation tools, all experimenters are paying that three months, six months, nine months, 12 months with here are the updated results. So you can't really get hide from, what did this really result in over a longer term horizon?

**中文翻译:**
这样我们既能发布产品，又能以某种方式保留实验数据，从而观察受影响群体的长期效应。这只在针对新用户时有效。对于老用户，情况会复杂一些。没关系。然后在我们的实验工具中，所有实验人员都会在 3 个月、6 个月、9 个月、12 个月时收到提醒：“这是更新后的结果”。所以你真的无法逃避：从长期来看，这到底产生了什么结果？

---

### [00:22:10] Lenny Rachitsky

**English:**
So your tool is email everyone that's involved with the experiment of here's what this cohort is doing now.

**中文翻译:**
所以你们的工具会自动给参与实验的每个人发邮件，告诉他们这个群体现在的表现。

---

### [00:22:16] Archie Abrams

**English:**
Correct.

**中文翻译:**
没错。

---

### [00:22:16] Lenny Rachitsky

**English:**
I love that. Okay, that's awesome. It's interesting that you use kind of these cohort curves for GMV, and is that the core metric you look at to see?

**中文翻译:**
我喜欢这个。太棒了。有趣的是你们使用 GMV 的群体曲线（cohort curves），这是你们观察的核心指标吗？

---

### [00:22:25] Archie Abrams

**English:**
There's a few GMV, obviously gross profit. But GMV is kind of like a key determinant of long-term success.

**中文翻译:**
有几个，GMV，显然还有毛利。但 GMV 算是长期成功的关键决定因素。

---

### [00:22:35] Lenny Rachitsky

**English:**
So it's interesting. Most people use cohort retention curves. You're using cohort because you don't look at retention. You're looking at for GMV over time. So that's really interesting.

**中文翻译:**
这很有趣。大多数人使用群体留存曲线。你们使用群体曲线是因为你们不看留存，而是看随时间变化的 GMV。这真的很特别。

---

### [00:22:45] Archie Abrams

**English:**
GMV over time, which correlates better. And there's a retention in profit. And then really the absolute number of merchants who are on the platform and then reaching certain GMV.

**中文翻译:**
随时间变化的 GMV，它的相关性更好。利润中也包含留存。然后真正重要的是平台上商家的绝对数量，以及达到特定 GMV 水平的商家数量。

---

### [00:22:56] Lenny Rachitsky

**English:**
Okay, I'm going to not keep falling this path. We can go on and on. While we're in the topic of experiments and what you've done, I'm curious if there's any examples of big wins that your team has shipped that might inspire people as they're thinking about launching experiments. I know there's probably some trade secret stuff you don't want competitors to know, and I know this is particular to Shopify and a platform in eCommerce. But I guess is there anything that would be worth sharing of like, "Here's a huge win that maybe we didn't expect."

**中文翻译:**
好，我不再沿着这条路问下去了，否则我们可以聊个没完。既然我们在聊实验和你做过的事情，我很好奇你们团队是否发布过一些大的“胜出案例”，可以给那些正在考虑启动实验的人一些启发。我知道可能涉及一些不想让竞争对手知道的商业机密，而且这与 Shopify 这种电商平台非常相关。但我想知道有没有什么值得分享的，比如“这是一个我们可能没预料到的巨大成功”。

---

### [00:23:25] Archie Abrams

**English:**
Going back, there's always a lot of value in thinking through monetary friction as I mentioned. That's always going to be something to export. Trial dynamics, different types of incentives, all of those things are very impactful.

**中文翻译:**
回到刚才说的，思考“金钱摩擦”总是有很大价值。这永远是值得探索的方向。试用动态、不同类型的激励措施，所有这些都非常有影响力。

---

### [00:23:39] Archie Abrams

**English:**
I would say on things that are maybe more practical and for everyone, there's an enormous amount, and we do see these with long-term effects. But just the nuts and bolts of sign up, collecting the right information. And you usually want to collect more information than most people think you do in your sign up flow. If you can then leverage that to personalize the guidance. And this is for SaaS product, the guidance that someone can get when they onboard into Shopify.

**中文翻译:**
我想说一些可能更实际、对每个人都有用的东西，有很多，而且我们确实看到了长期效应。那就是注册的基础环节：收集正确的信息。通常在注册流程中，你应该收集比大多数人认为的更多的信息。如果你能利用这些信息来提供个性化的引导。对于 SaaS 产品来说，就是某人入驻 Shopify 时能得到的引导。

---

### [00:24:09] Archie Abrams

**English:**
So whether you're coming on, Shopify is a very diverse product, in-person selling, online selling different channels. There's the nuts and bolts of get more information from folks, build trust in there, give them right amount of guidance when they come on in a personalized way.

**中文翻译:**
无论你是通过什么渠道加入，Shopify 都是一个非常多元化的产品，涵盖线下销售、线上销售等不同渠道。基础工作就是从用户那里获取更多信息，建立信任，并在他们加入时以个性化的方式提供适量的引导。

---

### [00:24:25] Archie Abrams

**English:**
And that may sound like, okay, that's kind of obvious. But the amount of impact by just nailing those flows has never ceased to amaze me and setting up that person for long-term success. So monetary friction. Then just really good onboarding, personalization, a well of opportunities there.

**中文翻译:**
这听起来可能有点显而易见。但仅仅通过完善这些流程所产生的影响，以及为用户奠定长期成功的基础，从未停止让我感到惊讶。所以，金钱摩擦，然后是极佳的入驻体验、个性化，那里有大量的机会。

---

### [00:24:49] Lenny Rachitsky

**English:**
I love that onboarding comes up every time I ask anyone where they've seen ongoing success and opportunities, particularly in actually surprisingly driving retention. It's interesting that that's not what you look at, but it turns out that's one of the biggest levers for increasing retention. Interesting that even for a company that doesn't look at retention, that's a big opportunity.

**中文翻译:**
我喜欢这一点，每当我问别人在哪里看到了持续的成功和机会时，“入驻体验”（onboarding）总会被提及，特别是在出人意料地驱动留存方面。有趣的是，虽然这不是你们关注的指标，但事实证明它是提高留存率的最大杠杆之一。有趣的是，即使对于一家不看留存的公司，这仍然是一个巨大的机会。

---

### [00:25:07] Archie Abrams

**English:**
Yes. Yeah, it's really because it's setting people up, for Shopify's case, I think the big thing about all of our metrics is... What we get very nervous about is the easiest way to increase retention is always to constrict the funnel stage one above the retention metric you're trying to optimize for.

**中文翻译:**
是的。这确实是因为它在为人们做铺垫。在 Shopify 的案例中，我认为关于我们所有指标的一件大事是……我们非常担心的是，提高留存率最简单的方法，永远是收紧你试图优化的留存指标上方的那个漏斗阶段。

---

### [00:25:27] Archie Abrams

**English:**
The simplest way to increase my signup to activated thing is just make it harder to sign up. Nuts and bolts, that will always happen is when you have teams on that local conversion rates, you get all these weird team incentives, because they're optimizing to basically implicitly make it harder to do the step before them.

**中文翻译:**
提高“注册到激活”转化率最简单的方法就是让注册变得更难。从根本上说，当你的团队只关注局部转化率时，就会出现各种奇怪的团队激励问题，因为他们优化的结果基本上是含蓄地让前一个步骤变得更难。

---

### [00:25:49] Archie Abrams

**English:**
And because we focus on that long-term GMV, number of merchants who are successful, orienting every team to think about the total number of people, not the rate, but the total number of people who got to the end of their part of the journey is a very powerful way to incentivize people to do the right thing in terms of getting people set up versus do the, "I'm going to constrict the funnel step right before me to make my local conversion rate look better," which is the bane of my existence but something I see a lot of teams, implicitly or explicitly do when they get too focused on rates as a way to think about the world.

**中文翻译:**
因为我们关注长期 GMV 和成功商家的数量，所以引导每个团队去思考“总人数”而不是“转化率”。关注完成他们那部分旅程的总人数，是一种非常有效的方式，可以激励人们在引导用户方面做正确的事，而不是去做那种“我要收紧前一步漏斗，好让我的局部转化率看起来更漂亮”的事。这种做法是我最痛恨的，但我看到很多团队在过度关注转化率时，都会含蓄或明确地这么做。

---

### [00:26:32] Lenny Rachitsky

**English:**
Incentives. What a power.

**中文翻译:**
激励机制。真是强大的力量。

---

### [00:26:34] Archie Abrams

**English:**
Incentives, what a power, what a lever.

**中文翻译:**
激励机制，强大的力量，强大的杠杆。

---

### [00:26:36] Lenny Rachitsky

**English:**
I definitely want to chat a little bit more about metrics. I know you have a really interesting take that's kind of built on what you're just talking about. But first of all, you mentioned this term monetary friction as one of the levers that you've seen success with. Can you just describe what that actually means?

**中文翻译:**
我肯定想再多聊聊指标。我知道你有一个非常有趣的观点，是建立在你刚才所说的基础上的。但首先，你提到了“金钱摩擦”这个词，作为你见证过成功的杠杆之一。你能描述一下这到底是什么意思吗？

---

### [00:26:48] Archie Abrams

**English:**
Totally. So things like trial, trial dynamics, trial length, trial amount. It means incentives. So what is in your product? What do people value and need in order to be successful? So in Shopify's case, that might be app score credits or things like that, but those are the two forms of monetary friction we talk about and then of course actual price point. But that's what the larger bucket of monetary friction is.

**中文翻译:**
当然。比如试用、试用动态、试用时长、试用金额。它意味着激励。你的产品里有什么？人们为了成功需要什么、看重什么？在 Shopify 的案例中，这可能是应用商店积分之类。这就是我们讨论的两种形式的金钱摩擦，当然还有实际的价格点。这就是“金钱摩擦”这个大范畴所包含的内容。

---

### [00:27:16] Lenny Rachitsky

**English:**
So let's follow this thread of metrics. You're big on absolute numbers and you've been talking about this already, versus percentages and ratios. Talk about that and how you encourage your teams to think about metrics.

**中文翻译:**
那我们继续聊聊指标。你非常看重绝对数值，而不是百分比和比例，你刚才已经提到了一些。谈谈这个，以及你如何鼓励你的团队去思考指标。

---

### [00:27:29] Archie Abrams

**English:**
Yeah, I think one of the things that I think happens particularly in large, in Shopify's growth order, it's about 600 folks. When you have teams naturally break up the world into different funnel stages or different points in the journey, it gets very seductive to look at my part of the funnel, and what's my conversion rate through that part of the funnel? And then the team starts to optimize for that conversion rate as their north star over a longer time period. I'm going to try to move my conversion rate from 10 to 12% or what have you.

**中文翻译:**
是的，我认为特别是在大型组织中——Shopify 的增长部门大约有 600 人——当团队自然地将业务划分为不同的漏斗阶段或旅程节点时，盯着自己那部分漏斗及其转化率会非常有诱惑力。然后团队开始在较长的时间跨度内将该转化率作为北极星指标进行优化，比如试图将转化率从 10% 提高到 12%。

---

### [00:28:04] Archie Abrams

**English:**
But in practice, I talked about it's actually almost always easier to just make it harder to do the thing right before your step in the funnel to increase your conversion rate. If I make it harder to sign up, it's going to be very easy to increase sign up to activated rate, because I just have fewer people and the people who made it through our higher intent.

**中文翻译:**
但在实践中，正如我所说，提高转化率几乎总是通过增加前一步的难度来实现的。如果我让注册变得更难，那么提高“注册到激活”的转化率就会变得非常容易，因为人数变少了，而通过的人意图更高。

---

### [00:28:23] Archie Abrams

**English:**
And so I see teams get really stuck when they are trying to optimize conversion rate, but they just make it harder to do the previous thing. Versus everyone is thinking about absolute number of people who made it through their "stage" of the funnel. So instead of I'm trying to convert a bunch of people, a conversion rate, I just want more people to get activated.

**中文翻译:**
所以我看到很多团队在试图优化转化率时陷入困境，因为他们只是让前一步变得更难。相反，如果每个人都在思考通过他们那个漏斗“阶段”的绝对人数，情况就不同了。与其说“我要转化一群人”（转化率），不如说“我只想让更多的人被激活”。

---

### [00:28:48] Archie Abrams

**English:**
And then once you start thinking that way, you realize actually the best way to get more people to get to a step sometimes, and often they just get more people in the door in the first place. So make it easier to sign up or reduce friction. It's the opposite.

**中文翻译:**
一旦你开始这样思考，你就会意识到，有时让更多人到达某个步骤的最佳方式，往往是首先让更多的人进门。所以要让注册变得更容易，或者减少摩擦。这与之前的逻辑正好相反。

---

### [00:29:05] Archie Abrams

**English:**
Because that will always hurt your conversion rate, but it may actually give you more people on the outside. And a lot of teams get very nervous, their retention rate went down, their LTV went down. Oh my goodness, is this this going to affect our ability to pay? No, your CAC also went down by probably more. And so now you have the ability to likely spend more and you have more people through the door, getting to each point in the activation or the immersion journeys.

**中文翻译:**
因为这总是会损害你的转化率，但它实际上可能会在漏斗末端给你带来更多的人。很多团队会变得非常紧张：留存率下降了，LTV（终身价值）下降了。天哪，这会影响我们的支付能力吗？不，你的 CAC（获客成本）可能下降得更多。所以现在你可能有能力花更多的钱，并且有更多的人进门，到达激活或沉浸旅程的各个节点。

---

### [00:29:33] Lenny Rachitsky

**English:**
What I'm hearing is essentially teams are gold not on increase, lift this conversion step by some percentage. It's drive some absolute number of new merchants, potentially.

**中文翻译:**
我听到的是，团队的目标基本上不是“将这个转化步骤提升多少百分比”，而是“驱动一定绝对数量的新商家”。

---

### [00:29:45] Archie Abrams

**English:**
Merchants, yeah. Exactly.

**中文翻译:**
商家，是的。正是如此。

---

### [00:29:47] Lenny Rachitsky

**English:**
This is a good segue to I want to hear how you structure your growth team at Shopify. Essentially, what's the raw structure, what are the different teams, and what do they focus on? And then what are the functions within each teams?

**中文翻译:**
这是一个很好的过渡，我想听听你在 Shopify 是如何构建增长团队的。基本上，原始结构是什么样的？有哪些不同的团队？他们关注什么？每个团队内部又有哪些职能？

---

### [00:29:59] Archie Abrams

**English:**
We have two big groups within growth. So one is what we call growth R&D. So this might be what you traditionally consider product design engineering, data, your traditional product teams. Then we have growth marketing, which in Shopify's case is paid acquisition, media buying, affiliate marketing, email, content, and SEO. So that's growth R&D, growth marketing.

**中文翻译:**
我们在增长部门有两个大组。一个是“增长研发”（Growth R&D），这可能就是传统意义上的产品、设计、工程、数据，即传统的产研团队。另一个是“增长营销”（Growth Marketing），在 Shopify，这包括付费获客、媒体购买、联盟营销、邮件营销、内容和 SEO。这就是增长研发和增长营销。

---

### [00:30:23] Archie Abrams

**English:**
Within growth R&D, three pillars. One is what we call growth products. And so this is basically everything from landing pages, sign up, onboarding, monetization. So trial, incentives, the like, all the way through to what we call our home feed, our engagement to basically get more merchants. Again, not necessarily to retain, but to keep giving entrepreneurship a try to become bigger and bigger businesses. So that's growth product, the full life cycle there.

**中文翻译:**
在增长研发内部，有三个支柱。第一是“增长产品”（Growth Products），这基本上涵盖了从落地页、注册、入驻到变现的所有环节。包括试用、激励等，一直到我们所说的“主页信息流”（home feed），即通过参与度让更多商家留下来。再次强调，不一定是为了留存，而是为了让他们继续尝试创业，成长为越来越大的企业。这就是增长产品，负责完整的生命周期。

---

### [00:30:56] Archie Abrams

**English:**
Second is what we call our enable pillar, and this pillar is building tools for both growth and the rest of Shopify. So things like experimentation platform, our communication platform, our business intelligence tooling that powers a lot of what we're doing, our more tech work to support our growth marketing team.

**中文翻译:**
第二是“赋能支柱”（Enable Pillar），这个支柱负责为增长部门和 Shopify 的其他部门构建工具。比如实验平台、沟通平台、驱动我们大部分工作的商业智能（BI）工具，以及支持增长营销团队的更多技术工作。

---

### [00:31:14] Archie Abrams

**English:**
And then our third bucket, which is maybe a little different from most growth teams is actually our customer support, groups within growth. We want to think about customer support as part of this merchant journey of coming on, giving entrepreneurship a try, all the way through to here's the support I need as I'm becoming a multi-billion dollar business on Shopify. So those are the three big growth product buckets. And then within growth marketing, it's a more traditional channel setup. Paid, all the different channels online, offline, SEO, email, and affiliates.

**中文翻译:**
第三个部分可能与大多数增长团队有点不同，那就是增长部门内部的“客户支持”组。我们希望将客户支持视为商家旅程的一部分：从加入、尝试创业，一直到成为 Shopify 上价值数十亿美元的企业时所需的各种支持。这就是增长产品的三大块。而在增长营销内部，则是更传统的渠道设置：付费（线上线下所有渠道）、SEO、邮件和联盟营销。

---

### [00:31:49] Lenny Rachitsky

**English:**
Super cool. Okay. So within growth RD, I just took notes. I'm going to summarize what you just shared, which is awesome. So there's three big buckets. One is growth product, which essentially is onboarding. It feels like it's like the top of funnel, get people in. Well okay, so growth marketing feels like that's super top of funnel bring-

**中文翻译:**
太酷了。好。在增长研发内部，我记了笔记，总结一下你刚才分享的内容，非常棒。有三个大块：一是增长产品，本质上是入驻。感觉像是漏斗顶端，吸引人进来。好吧，增长营销感觉才是真正的漏斗顶端，负责引流……

---

### [00:32:07] Archie Abrams

**English:**
That's super top funnel.

**中文翻译:**
那是极上游的漏斗。

---

### [00:32:08] Lenny Rachitsky

**English:**
Yeah. Okay, got it. So growth marketing, drive people to Shopify.com. Then within RD team, growth product takes that user and tries to get them to activate it. Enable helps... It feels like that's like internal tooling and ways to make the teams internally more efficient.

**中文翻译:**
是的。好，明白了。增长营销负责把人引到 Shopify.com。然后在研发团队中，增长产品接手用户并尝试激活他们。“赋能”则提供帮助……感觉像是内部工具，旨在提高团队内部效率。

---

### [00:32:27] Archie Abrams

**English:**
Correct. Both growth and outside growth.

**中文翻译:**
没错。既服务于增长部门，也服务于外部。

---

### [00:32:29] Lenny Rachitsky

**English:**
Awesome. Okay. And then the customer support team, that's really interesting. So there's a customer support product team that helps new merchants be successful. And does that include actual customer support agents? Is that within that team?

**中文翻译:**
太棒了。好。关于客户支持团队，这很有趣。所以有一个客户支持产品团队来帮助新商家获得成功。这包括实际的客户支持专员吗？他们在那个团队里吗？

---

### [00:32:46] Archie Abrams

**English:**
That's not. We build a tooling to make those support advisors superheroes. And then on the help center, all of our AI stuff to make a great customer experience for people who are just engaging in a self-serve. So it's the tooling and the experience for merchants.

**中文翻译:**
不包括。我们构建工具是为了让那些支持顾问成为“超级英雄”。然后在帮助中心，我们利用所有的 AI 技术为那些进行自助服务的用户提供极佳的客户体验。所以它负责的是面向商家的工具和体验。

---

### [00:33:03] Lenny Rachitsky

**English:**
Okay. So with these teams, is there anything you can share about just how you think about metrics/goals for these different buckets? We don't need to get too deeply, but does everyone basically have an absolute new merchants goal or is it a little different?

**中文翻译:**
好。对于这些团队，你能分享一下你们是如何考虑这些不同板块的指标或目标的吗？我们不需要深入细节，但每个人基本上都有一个“绝对新商家数量”的目标吗？还是有所不同？

---

### [00:33:18] Archie Abrams

**English:**
So yeah. So at the highest level we think about that total cohort value. We bring in a set of merchants in a given year. How much GMV, how much that set of merchants worth over the next three, four years to Shopify? And that's the most important thing that we want to focus on. And then that of course, from an efficiency standpoint, that of course meeting our payback guardrails and all of that. So that's the macro growth perspective. Cohort value over cost and payback. So that's the macro point of view.

**中文翻译:**
是的。在最高层级，我们考虑的是“总群体价值”（total cohort value）。我们在某一年引入了一批商家。在接下来的三四年里，这批商家对 Shopify 价值多少 GMV？这是我们最想关注的事情。当然，从效率的角度来看，这还必须符合我们的回本周期（payback）警戒线等。这就是宏观增长视角：群体价值对比成本和回本周期。

---

### [00:33:52] Archie Abrams

**English:**
And then within growth marketing, each channel operates with certain guardrails around their LTV CACs. Same thing for content and SEO. That operates with kind of a guardrail model for each piece of content. How much is that going to come back and down the line?

**中文翻译:**
在增长营销内部，每个渠道都在一定的 LTV/CAC（终身价值/获客成本）警戒线下运作。内容和 SEO 也是如此。每篇内容都以一种警戒线模式运作：它未来能带来多少回报？

---

### [00:34:09] Archie Abrams

**English:**
For growth products, it's also a combination of total GP incremental cohort value that's produced from those teams. So everything is basically going to be measured on from an experiment, ideally measured over a very long time period. What was the incremental cohort value lift that this generated? And that's how we think about and measure the impact of each of those sub teams along the way.

**中文翻译:**
对于增长产品，它也是这些团队产生的总毛利（GP）增量群体价值的结合。所以基本上，一切都会基于实验来衡量，理想情况下是在很长一段时间内衡量。这产生了多少增量群体价值提升？这就是我们思考和衡量每个子团队影响力的方式。

---

### [00:34:40] Archie Abrams

**English:**
Each of those have a civic part of the funnel they play with. But because they're measured on absolutes and they really think about that absolute value, we don't get caught into, did your conversion rate over the course of this year go up or down? It's kind of irrelevant. What was the sum of the impact over a long period on that total cohort value that we're trying to produce from before merchants?

**中文翻译:**
每个团队都有自己负责的漏斗环节。但因为他们是按绝对值衡量的，并且真正思考绝对价值，我们不会陷入“你今年的转化率是上升了还是下降了”这种争论。这基本上无关紧要。重要的是，在很长一段时间内，我们试图从商家那里产生的总群体价值的影响总和是多少？

---

### [00:35:01] Lenny Rachitsky

**English:**
And the way you come up with this goal I imagine is you have a forecast of where things would go organically, and then here's the lift we want to see from the work this team does this quarter, this year.

**中文翻译:**
我猜你们制定目标的方式是：先有一个关于自然增长趋势的预测，然后设定一个我们希望看到该团队在本季度或今年通过工作带来的提升（lift）。

---

### [00:35:12] Archie Abrams

**English:**
Correct. And then we're going to measure against for each experiment, did it actually get to where we expect that lift to be?

**中文翻译:**
没错。然后我们会针对每个实验进行衡量：它是否真的达到了我们预期的提升水平？

---

### [00:35:21] Lenny Rachitsky

**English:**
And those experiments again, are those all long-term holdout experiments where you look wait a year or some-

**中文翻译:**
再次确认，这些实验都是那种需要等待一年或更久的长期对照实验吗？

---

### [00:35:29] Archie Abrams

**English:**
We call. We call the experiment after three weeks, but in all cases, the group is held, we watch them. And that's where that ping comes back, every experiment is watched. And that ping comes back three, six months, 12 months to re-look at was this actually successful?

**中文翻译:**
我们会做决定。我们在三周后对实验做出初步结论，但在所有情况下，对照组都会被保留，我们会观察他们。这就是“提醒”发挥作用的地方，每个实验都会被监测。提醒会在 3 个月、6 个月、12 个月时发回，让我们重新审视：这真的成功了吗？

---

### [00:35:42] Archie Abrams

**English:**
So that creates the loop of shipping value quickly, but making sure we're holding ourselves accountable to did this actually produce results over a long period, or did it actually just have this neutral effect? It's like, oh, then we can learn from that and get better.

**中文翻译:**
这创造了一个循环：既能快速发布价值，又能确保我们对自己负责——这在长期内是否真的产生了结果，还是仅仅产生了一个中性效应？如果是后者，我们可以从中学习并改进。

---

### [00:36:01] Lenny Rachitsky

**English:**
[Ad for Dovetail - repeated/similar content]
This episode is brought to you by Dovetail, the AI-first customer insights hub for all teams... [Full text follows]

**中文翻译:**
[Dovetail 广告内容] 本集节目由 Dovetail 赞助，它是面向所有团队的 AI 优先客户洞察中心……（此处为广告内容翻译，略）

---

### [00:37:10] Lenny Rachitsky

**English:**
So maybe just to dig into this again, because it's so interesting. Basically, product team ships stuff, they run an experiment, they see impact. Say it's 5% lift on something. Huzzah, you did it. Great work, performance review. Your exceeds, you're doing great. This team's killing it. And then a year later you realize, "Oh, that didn't last." How often do you find a team that is shipping wins looks back and ends up seeing, "That wasn't actually as successful as it." I know you said maybe it's a third of the time.

**中文翻译:**
也许我们可以再深入探讨一下，因为这太有趣了。基本上，产品团队发布了东西，运行了实验，看到了影响。假设某项指标提升了 5%。万岁，你做到了！干得好，绩效评估。你“超出预期”，做得太棒了，这个团队太牛了。然后一年后你意识到，“噢，那没能持久。”你发现一个发布了“胜出方案”的团队回头看时，发现“其实没那么成功”的情况有多频繁？我知道你刚才说大约是三分之一的时间。

---

### [00:37:38] Archie Abrams

**English:**
30. Yeah.

**中文翻译:**
30%。是的。

---

### [00:37:39] Lenny Rachitsky

**English:**
Yeah. Okay, so it's still roughly, yeah.

**中文翻译:**
好，所以大概还是那个比例。

---

### [00:37:42] Archie Abrams

**English:**
And it's great learning and that's why we take it. It's like, wow, okay, now we really uncovered something and it's such a successful discovery. Wow, okay, we thought this thing. But now we learned it actually wasn't as true as we thought. Cool. What can we take from that and be smarter next time so we don't just double down on the wrong things?

**中文翻译:**
这是很好的学习机会，这也是我们接受它的原因。就像是，“哇，好吧，现在我们真的发现了一些东西，这是一个非常成功的发现。”哇，好吧，我们原本以为是这样，但现在我们知道事实并非如此。酷。我们能从中吸取什么教训，下次变得更聪明，这样我们就不会在错误的事情上加倍投入？

---

### [00:38:02] Lenny Rachitsky

**English:**
That's so interesting. And again, and you mentioned most of the reason this is the case when something doesn't show lift down the road is it's pulling forward success that would've been seen later on its own if you had not even shipped this thing?

**中文翻译:**
这太有意思了。再次确认，你提到当某些东西在未来没有显示出提升时，主要原因是它“提前透支”了成功——即即使你不发布这个东西，那些成功在未来也会自然发生？

---

### [00:38:14] Archie Abrams

**English:**
Correct.

**中文翻译:**
没错。

---

### [00:38:14] Lenny Rachitsky

**English:**
Awesome. Is there an example by any chance that comes to mind of something like that that's just like, "Wow, that was a big win. And then oh I see we just pulled forward some revenue from the future."

**中文翻译:**
太棒了。有没有什么例子让你印象深刻，就是那种“哇，那是个巨大的胜利，然后……噢，我明白了，我们只是提前透支了未来的收入”？

---

### [00:38:25] Archie Abrams

**English:**
So I think one good example is something around payment failure notifications. So one of the things that a lot of teams have or see is we call Dunning effects where somebody might have a payment not go through, a credit card that doesn't go through. So we did a bunch of experimentation around, hey, how can we alert people that their credit card is failed, their payment attempt failed?

**中文翻译:**
我认为一个很好的例子是关于“支付失败通知”的。很多团队都会遇到我们称之为“催款效应”（Dunning effects）的情况，即某人的支付没通过，信用卡刷不动。所以我们做了一系列实验：嘿，我们如何提醒人们他们的信用卡失效了，或者支付尝试失败了？

---

### [00:38:47] Archie Abrams

**English:**
And that's a typical growth win, usually produces a lot of short-term impact. And that's what we saw here. We were doing much better alerting, reminding people, sending them a million emails about it. Cool, we got some pretty major lift. You look back six, 12 months. There was really no long-term lift. And why is that? Because there's really a little bit of a selection bias there that people who were letting that payment fail probably weren't actually that dedicated to this entrepreneurship craft. They may have updated their credit card, but they still really weren't in it.

**中文翻译:**
这是一个典型的增长“胜出案例”，通常会产生巨大的短期影响。我们当时也看到了这一点：我们做了更好的提醒、催促，给他们发了无数封邮件。酷，我们获得了相当大的提升。但回头看 6 个月、12 个月后的数据，实际上没有任何长期提升。为什么呢？因为这里存在一点选择偏差：那些让支付失败的人，可能本身对创业这件事就没那么投入。他们可能更新了信用卡，但他们仍然没有真正投入其中。

---

### [00:39:37] Archie Abrams

**English:**
And so that was a good example of in a bunch of this stuff around payments, even "preventing" churn where you look, it's six, 12, 18 months. On a GMV metric, not a lot of lift over that long-term horizon.

**中文翻译:**
所以这是一个很好的例子，在支付相关的很多事情中，甚至是所谓的“防止”流失，当你观察 6、12、18 个月后的数据时，在 GMV 指标上，长期来看并没有多少提升。

---

### [00:39:54] Lenny Rachitsky

**English:**
I love this example. I could see so many people having run experiments like this and like, "Oh, we found such a huge win. This team's killing it. What a great idea. Of course this makes sense," and then turns out it's nothing long term.

**中文翻译:**
我喜欢这个例子。我可以想象很多人都运行过类似的实验，然后想：“噢，我们发现了一个巨大的胜利。这个团队太牛了。多棒的主意，这当然说得通。”结果证明长期来看毫无意义。

---

### [00:40:12] Archie Abrams

**English:**
Which is great. We were going to spend a lot of time, okay, what else can we do here? It's like, no actually bigger fish to fry in a lot of other areas. So it helps the team just feel really good that their work is really the things that were good.

**中文翻译:**
但这其实很好。我们原本打算花很多时间研究“好，我们还能在这里做点什么？”，结果发现其实在很多其他领域有更重要的事情要做。所以这有助于团队感觉良好，因为他们知道自己的工作真正聚焦在了有价值的事情上。

---

### [00:40:25] Archie Abrams

**English:**
Another one that went the other way, which was really interesting was in our online store, and this might be if you use Shopify, we have sections and blocks that come pre-configured. And so we tested, okay, if we give you a pre-configured block of you should have an image up top, then a text banner, and then a collage with your products. That should help folks understand what to do when they're building the online store. It actually had no lift in people converting to a paying merchant.

**中文翻译:**
另一个反向的例子也非常有趣，是关于我们的在线商店的。如果你使用 Shopify，你会知道我们有预配置的“板块”（sections）和“模块”（blocks）。我们测试了：如果我们给你一个预配置的模块，比如顶部应该有一张图片，然后是一个文字横幅，接着是产品的拼贴图。这应该能帮助人们理解在构建在线商店时该做什么。结果，它在“转化为付费商家”方面完全没有提升。

---

### [00:40:48] Archie Abrams

**English:**
However, when we looked longer term on that six months later, it had a pretty massive impact on the number of people who were selling and producing GMV. And why is that? Because it didn't likely really influence anyone to buy Shopify or pay for Shopify. But the people who used it created better stores that were higher converting, and so they got early sales. They actually converted one of their visitors and they got momentum, and they stuck with entrepreneurship a little bit longer. And we saw that in that opposite way.

**中文翻译:**
然而，当我们观察六个月后的长期数据时，它对“正在销售并产生 GMV 的人数”产生了相当巨大的影响。为什么呢？因为它可能并没有真正影响任何人去购买或支付 Shopify。但使用它的人创建了更好的商店，转化率更高，因此他们获得了早期销售。他们真正转化了一名访客，获得了动力，从而在创业道路上坚持得更久了一点。我们以这种相反的方式看到了效果。

---

### [00:41:21] Lenny Rachitsky

**English:**
And so this is an example where that neutral, and so we tend to ship neutral. It's like it could be positive and so let's let it go if we have good intuition about it and it'll turn. So we've seen a bunch of these things go in very different directions.

**中文翻译:**
所以这是一个关于“中性结果”的例子，因此我们倾向于发布中性结果。就像是，它未来可能是正向的，如果我们有很好的直觉，那就让它上线，它会好转的。所以我们看到很多事情朝着完全不同的方向发展。

---

### [00:41:36] Lenny Rachitsky

**English:**
This is so fascinating. I didn't realize that you ship neutral experiments. That's an interesting insight. So it's like if you feel good about it and it's neutral, you ship it?

**中文翻译:**
这太迷人了。我没意识到你们会发布结果为中性的实验。这是一个有趣的见解。所以如果你们感觉不错，即使结果是中性的，你们也会发布？

---

### [00:41:45] Archie Abrams

**English:**
In our culture of the kind of aim heavy, if the intuition is right that this probably is helping merchants, why do we start with that the original control is better if it's neutral? Let's start with, what would we have shipped if we were a blank slate? And if it's neutral, actually neither is better, so let's just pick the one we feel better about and ship that.

**中文翻译:**
在我们这种“志存高远”（aim heavy）的文化中，如果直觉告诉我们这可能对商家有帮助，那么如果结果是中性的，为什么我们要默认原始对照组更好呢？让我们从“如果我们是一张白纸，我们会发布什么”开始思考。如果结果是中性的，实际上两者都不比对方好，那我们就选那个我们感觉更好的发布。

---

### [00:42:03] Lenny Rachitsky

**English:**
Makes so much sense. Oh man. Okay, so let's talk about this a little bit more. So this aim heavy concept, this idea of thinking 100 years out, can you just share more about that insight and that philosophy? I know it sounds like it comes from Tobi of how he likes to think about the business.

**中文翻译:**
非常有道理。天哪。好，让我们再多聊聊这个。这个“志存高远”的概念，这种思考 100 年后的想法，你能分享更多关于这个见解和哲学吗？我知道这听起来像是来自 Tobi 思考业务的方式。

---

### [00:42:18] Archie Abrams

**English:**
Totally. It is all Tobi of really making sure Shopify is so oriented around, we are here to build 100 year company. And so the decisions we're going to make are really oriented towards the long-term success of merchants, of Shopify. Embedded in all of our principles are make the best product in the world, make money to do more of one. Never reverse principles two and three. In every kind of executive meeting, every town hall, that slide comes up. It's like you've been at Shopify, you've probably seen that slide 10,000 times.

**中文翻译:**
完全正确。这全是 Tobi 的想法，他确保 Shopify 的导向是：我们在这里是为了建立一家百年公司。因此，我们做出的决策真正导向商家和 Shopify 的长期成功。我们所有的原则中都嵌入了：做出世界上最好的产品，赚钱是为了做更多最好的产品。永远不要颠倒原则二和原则三。在每一次高管会议、每一次全员大会上，那张幻灯片都会出现。如果你在 Shopify 待过，你可能已经看过那张幻灯片一万次了。

---

### [00:43:15] Archie Abrams

**English:**
But it's an important reminder job is to build the best product for merchants over the long period of time. And then all of the metrics and the make money part of it, secondary to that. So what we care about is that long term piece. It ties a little bit to that original conversation about entrepreneurs and being the core of why we just want more people to start businesses and go.

**中文翻译:**
但这是一个重要的提醒：我们的工作是在长期的维度内为商家构建最好的产品。所有的指标和赚钱的部分都是次要的。所以我们关心的是长期利益。这与我们最初讨论的关于创业者以及为什么我们希望更多人开始创业的核心理念相契合。

---

### [00:43:40] Archie Abrams

**English:**
It's very seductive I think in most companies, including in Shopify because we can support large enterprise businesses today, right? Big brands who want to get off an outdated solution and come over to Shopify. It's very easy to just say, "Oh, that's very concrete." There's an existing business, we want to have them come join Shopify. And in the short term it feels really good. It brings a lot of revenue right away.

**中文翻译:**
我认为在大多数公司，包括在 Shopify，这都非常有诱惑力，因为我们今天可以支持大型企业业务，对吧？那些想要摆脱过时方案并转向 Shopify 的大品牌。很容易就会说：“噢，这非常具体。”有一个现成的业务，我们想让他们加入 Shopify。短期内这感觉非常好，能立刻带来大量收入。

---

### [00:44:09] Archie Abrams

**English:**
But if you're thinking about the long-term 100 years from now, guess what? All of the big brands of today be out of business. And many of them will be out of business in 30, 40, 50 years. The real success of Shopify is getting every business to start with us and go, but making that type of an investment and being so focused on that entrepreneur segment and making it easier is how we build a very, very long-term oriented company. So just even how we do capital investment, how we do product decision-making comes back to, hey, we can't chase the short-term.

**中文翻译:**
但如果你思考 100 年后的长期情况，猜猜会怎样？今天所有的大品牌可能都已经倒闭了。其中许多在 30、40、50 年后就会消失。Shopify 真正的成功在于让每家企业都从我们这里开始并成长。进行这种投资，如此专注于创业者群体并让创业变得更容易，才是我们建立一家极度长期导向的公司的方式。所以，即使是我们如何进行资本投资、如何进行产品决策，都会回到这一点：嘿，我们不能追逐短期利益。

---

### [00:44:35] Lenny Rachitsky

**English:**
Is there an example that comes to mind where you did that where something short-term looked like, "We should definitely do this," but we're thinking thinking 100 years out so we're going to approach it this way?

**中文翻译:**
有没有什么例子让你想到，某件事短期看起来像是“我们绝对应该这么做”，但因为考虑 100 年后的情况，所以你们采取了另一种方式？

---

### [00:44:45] Archie Abrams

**English:**
It's kind of very much just imbued in the culture. Almost everything kind of feels that way. And I'll give, practically speaking, every six weeks all the R&D group leads we get together and we sit with Tobi and each other and review every single project across the company. Every six weeks, every single R&D pull up the dashboard, and look at it.

**中文翻译:**
这基本上已经融入了文化。几乎每件事感觉都是这样的。实际操作上，每隔六周，所有的研发组负责人都会聚在一起，和 Tobi 坐在一起，审查公司里的每一个项目。每六周，每一个研发项目都会拉出仪表盘供大家查看。

---

### [00:44:56] Archie Abrams

**English:**
And in that conversation, so much of the conversation is about both the technical how. How are we building this in a way that allows for Shopify to have optionality in the technical decisions that we are making? And I think for Tobi, one of the things I've learned and so is that how, the technical architecture determines strategy in a technology company even more than the what and who we're building for.

**中文翻译:**
在那种对话中，很大一部分内容是关于“技术上如何实现”。我们如何以一种让 Shopify 在技术决策中拥有选择权的方式来构建它？我认为对于 Tobi 来说，我学到的一点是：在一家科技公司，技术架构对战略的决定作用甚至超过了“我们在构建什么”和“为谁构建”。

---

### [00:45:17] Archie Abrams

**English:**
If you build the right technical how and set yourself up to have a platform that can be adaptable, flexible, that is incredibly valuable over the long term. It means we will sometimes take longer to ship a feature. It means we'll not chase certain deals or what have you, but we're going to kind of make that investment. And it comes through in all of our reviews and just how we got to do our work together.

**中文翻译:**
如果你构建了正确的“技术实现方式”，并建立起一个适应性强、灵活的平台，这在长期内是极具价值的。这意味着我们有时会花更长的时间发布一个功能。这意味着我们不会去追逐某些特定的交易或其他东西，但我们会进行这种投资。这体现在我们所有的审查中，以及我们如何共同开展工作中。

---

### [00:45:53] Lenny Rachitsky

**English:**
Wow, that is really unique. I've not heard of that where how... Usually it's the opposite. Let's not worry about how we're going to build this thing. It's why are we building this thing and then when are we building it? And not just the architecture is the most important thing.

**中文翻译:**
哇，这真的很独特。我还没听说过这种……通常情况正好相反。大家会说“别担心我们要怎么造这玩意儿”，而是关注“我们为什么要造它”以及“什么时候造好”。而不是把架构看作最重要的事。

---

### [00:46:09] Archie Abrams

**English:**
Yeah, I mean in the last one, it was great. We had a 30-minute discussion about how to build CSV importers for people coming over from different platforms, and it was all about are we using open source library, doing it internally, are we doing it in the core code base? Are we building a separate first party app to do it? It was incredible detail.

**中文翻译:**
是的，我的意思是，在最近的一次会议中，非常精彩。我们花了 30 分钟讨论如何为从不同平台迁移过来的用户构建 CSV 导入工具。讨论的全是：我们是用开源库，还是内部开发？是在核心代码库里做，还是构建一个独立的官方应用来做？细节非常惊人。

---

### [00:46:29] Archie Abrams

**English:**
This is what's amazing about Tobi. The technical detail of how we're going to do this was incredibly important to get right, to kind of set up this type of infrastructure. And most companies it'd be okay what, you're going to make it easier for people to migrate their data over. Cool. Team, go figure out how. And if team does figure out the how do we work on it with Tobi and the details, because the how is so important to how we build for the future.

**中文翻译:**
这就是 Tobi 的神奇之处。关于我们如何实现这一点的技术细节对于建立这种基础设施至关重要。在大多数公司，情况可能是：“好，你要让人们更容易迁移数据。酷。团队，去想办法实现吧。”但在我们这里，我们会和 Tobi 一起研究细节，因为“如何实现”对于我们如何为未来构建至关重要。

---

### [00:46:54] Lenny Rachitsky

**English:**
That's fascinating. And usually it's how do we do this as quick as possible, because CVS importing is not our core differentiator. It'll just build something good enough, we'll ship it, we'll move on.

**中文翻译:**
这太迷人了。通常人们会想“我们怎么能最快搞定这个”，因为 CSV 导入不是我们的核心竞争力。只要造个够用的东西，发布，然后继续下一项。

---

### [00:47:02] Archie Abrams

**English:**
Correct.

**中文翻译:**
没错。

---

### [00:47:02] Lenny Rachitsky

**English:**
Totally the opposite. That is fascinating. What's also really interesting about this is I think about Brian Chesky at Airbnb where I worked for a while and his... So one, he also had this idea of the 100-year vision and thinking for the future way out in 100 years. But interestingly, since he's a designer, he had a very different focus. So Tobi, he was an engineer. He still codes from what I can see on Twitter, he still-

**中文翻译:**
完全相反。这太有意思了。同样有趣的是，我想到了我在 Airbnb 工作时的 Brian Chesky。首先，他也拥有百年愿景和对 100 年后未来的思考。但有趣的是，因为他是设计师出身，他的关注点非常不同。而 Tobi 是工程师出身，从我在 Twitter 上看到的来看，他现在还在写代码……

---

### [00:47:24] Archie Abrams

**English:**
Absolutely.

**中文翻译:**
绝对在写。

---

### [00:47:26] Lenny Rachitsky

**English:**
So I could see why his brain goes there and why he's really strong in the how. Brian on the other hand is very focused on the experience and making sure the design is amazing, and the app is exactly what he wants it to feel like. It is very experience oriented. So it's interesting that these founders lean into the thing that they're strong at, and understand deeply, and that ideally connects with the way this business specifically wins and grows. And it makes sense a platform, I could see why engineering would be so essential to get right. Travel, hospitality, consumer app. I could see why design is so important.

**中文翻译:**
所以我能理解为什么他的大脑会往那儿想，为什么他在“如何实现”方面非常强。另一方面，Brian 非常关注体验，确保设计是惊人的，App 的感觉正是他想要的。那是极度体验导向的。所以有趣的是，这些创始人都倾向于他们擅长并深刻理解的事物，而这理想情况下又与业务的具体获胜和增长方式相联系。这很有道理，对于一个平台，我能理解为什么工程实现是如此核心；而对于旅游、酒店、消费者应用，我能理解为什么设计如此重要。

---

### [00:48:03] Archie Abrams

**English:**
100%.

**中文翻译:**
百分之百正确。

---

### [00:48:04] Lenny Rachitsky

**English:**
Fascinating. One more tidbit that I've heard about how you all think about this is metrics. And you mentioned before we started recording that a lot of the company doesn't actually have metrics that drive what they build, especially within the core business, which I think surprised a lot of people. Most people are like, "Every team needs a metric and a KPI, and this is how we measure progress and this is how we know if they're doing well." Talk about just how that works, how most of the companies doesn't have a metric.

**中文翻译:**
太有意思了。关于你们如何思考，我还听到了一个细节，那就是指标。你在我们开始录音前提到，公司里很多部门实际上并没有驱动他们构建产品的指标，特别是在核心业务内部，我想这会让很多人感到惊讶。大多数人认为“每个团队都需要一个指标和一个 KPI，这是我们衡量进展和了解他们是否做得好的方式”。谈谈这是怎么运作的，为什么公司大部分部门没有指标。

---

### [00:48:31] Archie Abrams

**English:**
Yeah. It's funny, we ran against KPIs are basically banned as OKRs or banned and all that. And so certainly, in growth you have metrics, but they take a different form. And then in core, it truly is, do we have conviction that this is the right technical foundation to build the future of commerce?

**中文翻译:**
是的。很有趣，我们基本上禁止了 KPI，OKRs 也被禁止了。当然，在增长部门你确实有指标，但它们以不同的形式存在。而在核心部门，真正的标准是：我们是否有信心认为这是构建未来商业的正确技术基础？

---

### [00:49:00] Archie Abrams

**English:**
And that is built through certainly looking at data. So it's not that teams are not looking at data and using it as a piece of their puzzle, but it's not the overriding. And when we go to ship a feature in core, it's not like a team is held accountable for this metric over this six months. It's much more, did we ship the right thing? And we're going to kind of get at that through a variety of lenses. Could be some of that could be data, qualitative, just our own product sense of what's good or not.

**中文翻译:**
这当然是通过观察数据建立起来的。所以并不是说团队不看数据，数据是他们拼图中的一块，但它不是决定性的。当我们要在核心部门发布一个功能时，并不是说团队要为未来六个月的某个指标负责。更多的是：我们发布的东西对吗？我们会通过各种视角来审视这一点，可能是数据、定性分析，或者仅仅是我们自己对好坏的产品直觉。

---

### [00:49:24] Archie Abrams

**English:**
And so I think the upside of that is I think we tend to ship things in core and that are incredibly forward-facing and we take more risk. I think to acknowledge some of the downside of it though is sometimes conversations get extremely subjective about what is the right thing to do. And so that requires the right way of having good discussions, openness from all leaders and from teams to debate those things. But it does result in some squishiness, which again has its pros and cons, but taste is what drives a lot of what we're shipping in core.

**中文翻译:**
我认为这样做的好处是，我们在核心部门发布的东西往往是非常前瞻性的，我们愿意承担更多风险。但也要承认缺点，那就是有时关于“什么是正确的事”的讨论会变得极其主观。因此，这需要正确的讨论方式，需要所有领导者和团队保持开放态度去辩论。这确实会导致一些模糊性（squishiness），这同样有利有弊，但“品味”确实驱动了我们在核心部门发布的大部分内容。

---

### [00:50:05] Lenny Rachitsky

**English:**
Yeah, I'm glad you touched on that. I was going to say, okay, everyone would love this idea of just build things that we think are awesome. It's going to be great. But then you build a whole org with teams and people building stuff. How does one know if they're building things that are good and helping versus not? And you're pointing out there are pros and cons to that. The pros is we're not optimizing for some short-term wins and driving some poor metric. The con is you might ship stuff that... There's a lot of subjectivity, and people may not agree, and it's a lot of squishy stuff.

**中文翻译:**
是的，我很高兴你提到了这一点。我本来想说，大家都喜欢“只造我们认为很棒的东西”这个主意，听起来很棒。但当你建立一个完整的组织，有这么多团队和人在造东西时，一个人怎么知道他们造的东西是好的、有帮助的，还是相反？你指出了这有利有弊。好处是我们不会为了短期胜利去冲某个糟糕的指标。坏处是你发布的东西……存在很多主观性，人们可能不一致，有很多模糊地带。

---

### [00:50:39] Archie Abrams

**English:**
Yeah, totally. Glen, who's heads of core product, I mean one of the things that's so impressive about Glen and that core team is they go incredibly deep into every single release that is shipped. And so you do have a central eye on the quality and how it all fits together.

**中文翻译:**
是的，完全正确。Glen 是核心产品的负责人，关于 Glen 和那个核心团队，令人印象深刻的一点是，他们会对发布的每一个版本进行极其深入的研究。所以你确实有一个核心视角在盯着质量以及各部分是如何整合在一起的。

---

### [00:51:00] Archie Abrams

**English:**
And so that I think helps make sure there's a consistent kind of bar for taste. A bunch of folks Tobi obviously that can enforce that. So it's subjective, but it's objective in the sense that it's kind of a small number of people who really hold what that bar is and needs to be. I think if it's just subjective, let's just ship what we want without a couple people really holding that quality and that taste bar, that's where things go really sideways.

**中文翻译:**
我认为这有助于确保有一个一致的品味标准。Tobi 和一群人显然可以执行这个标准。所以它是主观的，但从某种意义上说它也是客观的，因为有一小部分人真正掌握着这个标准应该是什么。我认为如果只是纯粹的主观——“让我们随心所欲发布吧”，而没有几个人真正把控质量和品味关，那事情就会变得一团糟。

---

### [00:51:31] Lenny Rachitsky

**English:**
Awesome. That's exactly what I was going to ask is, who's the ultimate decider of taste and what is good? And so it sounds like basically Tobi above, and then he's kind of deputized Glen and relies on him to make a lot of these final calls. And then I imagine Glen has some folks that he kind of deputizes to make smaller decisions along the way. Or not, or he's very involved in everything.

**中文翻译:**
太棒了。这正是我要问的：谁是品味和好坏的最终裁决者？听起来基本上是顶层的 Tobi，然后他授权给 Glen，并依靠他做出许多最终决定。我猜 Glen 也会授权一些人去做过程中的小决策。或者不是，也许他事无巨细都参与？

---

### [00:51:55] Archie Abrams

**English:**
And I think this is the fun thing about Shopify. Literally we have our own internal project management system that's been kind of crafted just for Shopify and every shift-

**中文翻译:**
我认为这是 Shopify 有趣的地方。字面上说，我们有自己的内部项目管理系统，是专门为 Shopify 打造的，每一次发布……

---

### [00:52:03] Lenny Rachitsky

**English:**
What is that called by the way? It's got a cool name, right?

**中文翻译:**
顺便问一下，那个系统叫什么？它有个很酷的名字，对吧？

---

### [00:52:06] Archie Abrams

**English:**
GSD.

**中文翻译:**
GSD。

---

### [00:52:07] Lenny Rachitsky

**English:**
GSD, yeah. [inaudible 00:52:10].

**中文翻译:**
GSD，是的。

---

### [00:52:10] Archie Abrams

**English:**
Yeah, get it done.

**中文翻译:**
是的，搞定它（Get it done）。

---

### [00:52:11] Lenny Rachitsky

**English:**
That's what I remember.

**中文翻译:**
我记得是这个。

---

### [00:52:12] Archie Abrams

**English:**
So get shit done. And every project, so you got a core project, you have emergency service, you got growth project. And the expectation is that the group leads. Every single project that goes out has a few minute video with Figmas and everything, and everything that shipped. Needs to be okay-toed, so approved by the group lead. There's nothing that can ship without that okay-to approval. And that okay-to approval has to be Glen, Carl, myself with different groups. And so that is how everything is reviewed. Now of course there's great amazing teams that do amazing work, but it is that that's how the system works.

**中文翻译:**
也就是“把破事搞定”（Get shit done）。每一个项目，无论是核心项目、商家服务项目还是增长项目，预期都是由组长负责。每一个发布的项目都必须有一个几分钟的视频，展示 Figma 原型和所有细节。所有发布的东西都需要被“Okay-toed”，也就是由组长批准。没有这个“Okay-to”批准，任何东西都不能发布。而这个批准必须来自 Glen、Carl 或我（针对不同的小组）。这就是所有东西被审查的方式。当然，我们有很棒的团队在做很棒的工作，但系统就是这样运作的。

---

### [00:52:50] Lenny Rachitsky

**English:**
And okay-to specifically means someone above reviews it or all this whole team, everyone looks at it?

**中文翻译:**
“Okay-to”具体是指上级审查，还是整个团队所有人都要看？

---

### [00:52:56] Archie Abrams

**English:**
No. So Glen reviews the core stuff. Carl reviews the MS. Okay-to. It's interesting.

**中文翻译:**
不。Glen 审查核心产品，Carl 审查商家服务。Okay-to。这很有趣。

---

### [00:53:05] Lenny Rachitsky

**English:**
It's basically Glen is founder mode and not as a founder where he's involved in all the details, has final say. So this is a really cool example of founder mode, but not as a founder.

**中文翻译:**
这基本上就是 Glen 处于“创始人模式”，虽然他不是创始人，但他参与所有细节并拥有最终决定权。所以这是一个非常酷的“非创始人的创始人模式”案例。

---

### [00:53:15] Archie Abrams

**English:**
Correct.

**中文翻译:**
没错。

---

### [00:53:16] Lenny Rachitsky

**English:**
In the way you guys operate. And I imagine sometimes Tobi disagrees with Glen and then they talk about it and things get ironed out.

**中文翻译:**
在你们的运作方式中。我猜有时 Tobi 会不同意 Glen 的看法，然后他们会讨论并解决分歧。

---

### [00:53:22] Archie Abrams

**English:**
Totally. And that's why we come together every six weeks, everyone in person to review every project so we can hash out those disagreements. Go through all the core projects, all the merge service projects, all the growth projects. And it's a great forum to say, "Hey, here's where we disagree," really on the how and the tactics of what's happening. And we can flag those things, have good debates about whether there might be misalignment.

**中文翻译:**
完全正确。这就是为什么我们每六周聚在一起，所有人面对面审查每一个项目，这样我们就能解决这些分歧。过一遍所有的核心项目、商家服务项目和增长项目。这是一个很好的论坛，可以说：“嘿，这是我们有分歧的地方”，通常是关于“如何实现”以及具体的战术。我们可以标记这些事情，就可能存在的不一致进行深入辩论。

---

### [00:53:43] Lenny Rachitsky

**English:**
Amazing. What a unique way of working. I'm so fascinated by all this. So what I'm hearing essentially within Core, Glen and his team come up with, "Here's what we're going to build the next quarter." You guys have twice a year releases, is that right? Or is it every season?

**中文翻译:**
太神奇了。多么独特的工作方式。我对这一切非常着迷。所以我听到的是，在核心部门，Glen 和他的团队决定“下个季度我们要造什么”。你们每年发布两次大版本，对吗？还是每个季度？

---

### [00:53:58] Archie Abrams

**English:**
Yeah, so big additions. Twice a year. Obviously continually shipping, but we package them twice a year in a big bang.

**中文翻译:**
是的，大的更新（Additions）是每年两次。显然我们一直在持续发布，但我们会每年两次集中进行大发布。

---

### [00:54:05] Lenny Rachitsky

**English:**
Big launch. Yep, I've seen those. Okay. So he's like, "Here's what we're going to do in the next release. We're just going to build this because we think this is right. And we're not driving a specific goal. We're building for 100 years in the future. Let's just build it." And basically you build it. He's like, "This is great, not great, iterate until it's this good," and then ship. And great. Okay, this is great. Okay, so then there's that team, and then there's your team, which is drive some freaking numbers, drive growth, hit these goals. How do you collaborate across these two teams? Do you have a model for how you work together? Because these feel like very different ways of working?

**中文翻译:**
大发布。是的，我见过。好。所以他的逻辑是：“这是我们下个版本要做的事。我们要造这个，因为我们认为它是对的。我们不冲特定指标，我们是为 100 年后的未来而造。就造它吧。”然后你们就造。他说：“这很棒，那不怎么样，迭代到这么好为止”，然后发布。太好了。好，那是那个团队，然后是你的团队，你的任务是冲那些该死的数据，驱动增长，达成目标。你们这两个团队如何协作？你们有协作模式吗？因为这听起来像是完全不同的工作方式。

---

### [00:54:41] Archie Abrams

**English:**
Yeah, honestly, it's been one of the things I'm very proud of. We built a really great partnership for the last three and a half years, because it's intentionally meant to be almost at odds, and that's part of the structure of how we want to work.

**中文翻译:**
是的，老实说，这是我非常自豪的事情之一。在过去的三年半里，我们建立了非常棒的伙伴关系，因为这种结构在设计上几乎就是为了让双方处于某种“对立”状态，这是我们工作结构的一部分。

---

### [00:54:56] Archie Abrams

**English:**
But it comes from, I think, a place of respect on both sides. And I'd say for anyone, it's okay, here's what growth is going to do. We're going to do it in a way that is high quality, that is shipping really good stuff for merchants. We're probably going to approach it in a faster way. We might disagree on things, but we're going to have reasonable paths to handle that conflict.

**中文翻译:**
但我认为，这源于双方的互相尊重。我会对任何人说，好吧，这是增长部门要做的事。我们会以高质量的方式去做，为商家发布真正好的东西。我们可能会采取更快的方式。我们可能会有分歧，但我们会通过合理的路径来处理冲突。

---

### [00:55:17] Archie Abrams

**English:**
And so while there's no magic bullet, it wasn't like these are the surfaces that growth can touch, these are not. It was like you can go anywhere in the product, but let's go figure out how to work together to figure out that quality bar to understand when you're going to be different on it, on the quality bar to get something out to learn, and just building trust along the way that we're actually going to ship high quality things and we ship it to 100% and move. And so a lot of great work on the team to make those relationships really strong.

**中文翻译:**
虽然没有万灵药，但并不是说“这些是增长部门可以碰的界面，那些不能碰”。而是“你可以触及产品的任何地方，但我们要弄清楚如何协作，确定质量标准，理解什么时候为了学习而可以在质量标准上有所妥协，并在此过程中建立信任，即我们最终会发布高质量的东西，并将其推向 100% 的用户”。团队做了很多工作来让这些关系变得非常牢固。

---

### [00:55:47] Lenny Rachitsky

**English:**
Got it. Basically, you guys are like, "Moving this button over here is going to drive so much growth," and then Glen's like, "No, this is not acceptable. We don't want a button here. This looks terrible. Everyone's going to hate it." So that's the healthy tension. I'm describing a combative-

**中文翻译:**
明白了。基本上，你们会说：“把这个按钮移到这里会带来巨大的增长”，然后 Glen 说：“不，这不可接受。我们不想在这里放按钮，这看起来太糟了，大家会讨厌它的。”这就是那种健康的张力。我描述得有点像在打架……

---

### [00:56:01] Archie Abrams

**English:**
[inaudible 00:56:01] totally. And it's like, okay, so how are we going to work to figure this out? It might be, "Hey, we're going to move the button. Hey let's run the test," but see the short-term lift. You know we're going to monitor it long term. You know when we ship it, it's going to be high quality, high quality polish. And you trust us to make those trade-offs.

**中文翻译:**
完全是这样。然后就是，“好吧，那我们怎么解决这个问题？”可能是，“嘿，我们要移按钮。嘿，让我们跑个测试”，但要看短期提升。你知道我们会长期监测它。你知道当我们发布它时，它会有很高的质量和打磨度。你信任我们去做这些权衡。

---

### [00:56:19] Archie Abrams

**English:**
I wish I had a better answer of it's very human. It's very that trust that's that's very important in any of these. I think growth with other teams is like, there's no replacement for just the human trust and then following through on commitments of no, we are actually going to make this thing really good.

**中文翻译:**
我希望我有更好的答案，但这其实非常人性化。在任何这类关系中，信任都非常重要。我认为增长团队与其他团队的关系就像是，没有什么能替代人与人之间的信任，以及履行“不，我们真的会把这东西做得很好”的承诺。

---

### [00:56:38] Lenny Rachitsky

**English:**
Is there an example of that, that comes to mind where you had something that was you thought was going to drive meaningful growth? You showed it to Glenn, he is like, "No, don't know about this." And then either you iterated or you just forget it, this isn't right for the platform even though it's going to drive some meaningful growth?

**中文翻译:**
有没有什么例子让你想到，你认为某件事会驱动显著增长，但你给 Glen 看时，他说：“不，我不确定这个。”然后你们要么迭代了，要么干脆放弃了，觉得“即使它能带来增长，也不适合这个平台”？

---

### [00:56:54] Archie Abrams

**English:**
The place that we often come back to is, and this is with I think Tobi is great, Tobi and Glen, is on wizards. So wizards-

**中文翻译:**
我们经常回到的一个点是——我认为 Tobi 和 Glen 在这方面很棒——关于“向导”（wizards）。向导就是……

---

### [00:57:07] Lenny Rachitsky

**English:**
Onboarding carousels.

**中文翻译:**
入驻引导轮播图。

---

### [00:57:08] Archie Abrams

**English:**
Onboarding carousels. Some way that basically has folks get set up by not using the actual product. And so we've always kind of danced around and we have very specific no wizard principle, but I think that sometimes the tension is wizards can serve a purpose in certain circumstances, but we've avoided doing that. But we've always worked to try to make the principles of what a wizard does really well, which is it simplifies the product into something that allows people to have a lower bar, to try to work with core to bring that into the actual experience itself.

**中文翻译:**
入驻引导轮播。某种让人们在不使用实际产品的情况下完成设置的方式。我们一直在这个问题上纠结，我们有一个非常明确的“禁止向导”原则。但我认为有时张力在于，向导在某些情况下确实有用，但我们一直避免这样做。我们一直在努力实现向导所擅长的原则——即将产品简化为某种让人们门槛更低的东西——并尝试与核心团队合作，将其融入到实际的产品体验本身中。

---

### [00:57:52] Archie Abrams

**English:**
So the example of that experiment I mentioned to you of giving pre-filled sections in the online store editor, you could have solved that in a wizardy way of, "Enter a few things, and we're going to generate these sections for you." Instead, we actually took those pre-generated things based on what we know about you and put it into the actual project experience itself.

**中文翻译:**
比如我刚才提到的那个实验，在在线商店编辑器中提供预填充板块。你本可以用向导的方式解决：“输入几项内容，我们将为你生成这些板块。”相反，我们实际上是根据我们对你的了解，将这些预生成的内容直接放入了实际的产品体验中。

---

### [00:58:15] Archie Abrams

**English:**
So it tried to get at some of the principles of what a wizard can do well without avoiding the wizard principle, without creating actual wizard. So that's been some of the, how do we work together to get the intent of what the growth ideas but in a way that's consistent with the way we want to build in core?

**中文翻译:**
所以它尝试在不违反“禁止向导”原则、不创建实际向导的情况下，实现向导所擅长的功能。这就是我们如何协作的例子：实现增长想法的意图，但方式要与我们在核心部门构建产品的方式保持一致。

---

### [00:58:34] Lenny Rachitsky

**English:**
Got it. And I get why that you think about this a lot because you talked about one of the biggest levers is onboarding and helping more people get activated, and so I could see why you spent a lot of time thinking about how do we help more people succeed there.

**中文翻译:**
明白了。我理解你为什么经常思考这个问题，因为你提到最大的杠杆之一就是入驻和帮助更多人被激活，所以我能理解为什么你花这么多时间思考如何帮助更多人在那个环节获得成功。

---

### [00:58:46] Archie Abrams

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:58:48] Lenny Rachitsky

**English:**
I want to ask your insight on this idea that people might be listening to this and feeling like, "Oh, we need to build a team that just builds great product and is not constrained by metrics and driving growth." Short-term thinking, long-term thinking, 100 years. This is inspiring I think to a lot of companies because the sounds great.

**中文翻译:**
我想请教你一个见解：人们听了这些可能会觉得，“噢，我们需要建立一个只负责打造伟大产品、不受指标和增长驱动约束的团队。”短期思考、长期思考、100 年。我认为这对很多公司来说都很鼓舞人心，因为听起来很棒。

---

### [00:59:08] Lenny Rachitsky

**English:**
What do you think it takes to make something like that work? Because in a bad case, this team just sits around and builds whatever they want, and the rest of the company's like, "God damn, this sucks. I have to show success in metrics and moving a metric in this team, over there just build beautiful things." Is it like you need a founder like Tobi, that prioritizes this and values it and has a very good taste and intuition? What do you think are important elements of something like that, of this approach working at a company based on what you've seen?

**中文翻译:**
你认为要让这种模式奏效需要什么条件？因为在糟糕的情况下，这个团队可能只是无所事事，随心所欲地造东西，而公司其他部门会觉得，“该死，这太糟了。我必须在指标上表现出色，而那边的团队却只管造漂亮的东西。”是不是需要一个像 Tobi 这样的创始人，他优先考虑并重视这一点，并且拥有极佳的品味和直觉？根据你的观察，这种方法在一家公司奏效的重要元素是什么？

---

### [00:59:37] Archie Abrams

**English:**
Yeah, I think it needs to have a very opinionated founder set of people who are driving what good looks like. And I think Shopify a few years ago and before maybe sometimes drifted into the mode of, "We are just going to build stuff and each kind of team is just going to build stuff not really accountable for it," and that is a very, very bad state to end up.

**中文翻译:**
是的，我认为它需要有一群非常有主见的创始人或核心人员来定义“什么是好的”。我认为几年前的 Shopify 有时会陷入一种模式：“我们只是在造东西，每个团队都在造东西，但并不真正为此负责”，那是一个非常、非常糟糕的状态。

---

### [01:00:00] Archie Abrams

**English:**
So I think you either have to use, my sense is metrics as accountability, which is the most common kind of way to drive accountability and focus. Or extremely strong founder or set of folks who have extremely strong opinions on what good is and what taste is. If you have one of those two, you can make it work, but the worst case is let's just go build a bunch of cool stuff in kind of a haphazard way. That I don't think would work.

**中文翻译:**
所以我认为，你要么使用指标作为问责机制（这是驱动问责和专注最常见的方式），要么拥有一位极其强势的创始人或一群对“什么是好”和“什么是品味”有极强见解的人。如果你拥有这两者之一，你就能让它奏效。但最糟糕的情况是，以一种随意的方式去造一堆所谓的“酷东西”。我认为那行不通。

---

### [01:00:30] Lenny Rachitsky

**English:**
Yeah, this is great. So either you need metrics to tell you you're doing the right thing or really correct and good taste in your founder.

**中文翻译:**
是的，这很棒。所以要么你需要指标来告诉你你在做正确的事，要么你的创始人需要有真正正确且优秀的品味。

---

### [01:00:42] Archie Abrams

**English:**
Correct.

**中文翻译:**
没错。

---

### [01:00:42] Lenny Rachitsky

**English:**
Cool. I think that's a really good way of... And I imagine every founder is going to think, "Oh, that's me. I have this, I can do this." I think it's rare in real life. It's rare that you're like a Tobi, or Brian Chesky, or Elon.

**中文翻译:**
酷。我认为这是一个很好的……我猜每个创始人都觉得，“噢，那就是我。我有品味，我能做到。”但我认为在现实生活中这很罕见。像 Tobi、Brian Chesky 或 Elon 这样的人是很罕见的。

---

### [01:00:43] Archie Abrams

**English:**
100%.

**中文翻译:**
百分之百。

---

### [01:00:57] Lenny Rachitsky

**English:**
Yeah. It's hard to internalize that, but I think that's the reality. So most people will be more successful building things that are driving metrics they can track in an experiment.

**中文翻译:**
是的。很难接受这一点，但我认为这就是现实。所以大多数人通过构建那些能驱动实验中可追踪指标的东西，会获得更大的成功。

---

### [01:01:07] Archie Abrams

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:01:08] Lenny Rachitsky

**English:**
Awesome. This is very fascinating. I'm so happy we're spending so much time on this. Okay, there's a few other random things I'm going to touch on. One is sales. So historically, Shopify has been very product-like growth, very organic. Go check it out, sign up, shop a store, start a store, grow. And you guys have layered on sales. In a sales motion that's an increasing part of your business. What have you learned about your team, the growth team working with sales and making that a successful relationship?

**中文翻译:**
太棒了。这非常迷人。我很高兴我们花了这么多时间讨论这个。好，我还要触及其他几个随机的话题。一个是销售。历史上，Shopify 一直是非常产品驱动增长（PLG）的，非常有机。去看看，注册，开店，成长。现在你们增加了销售环节。销售动作在你们业务中的占比越来越大。关于你的团队（增长团队）如何与销售团队合作并建立成功的关系，你学到了什么？

---

### [01:01:36] Archie Abrams

**English:**
Yeah, no, it has been great over the last couple of years as built out, the sales order has added a whole new kind of motion to Shopify. As Shopify's product got better, it can serve the biggest companies in the world. It's like the natural evolution. Well what are you going to do that for people to grow up on Shopify and to be the biggest companies, but we're also going to take folks another platform, bring them over.

**中文翻译:**
是的，过去几年销售团队的建立非常棒，它为 Shopify 增加了一种全新的动力。随着 Shopify 的产品变得更好，它可以服务于世界上规模最大的公司。这就像是自然进化：你不仅要让人们在 Shopify 上成长为大公司，还要把其他平台上的大客户挖过来。

---

### [01:01:57] Archie Abrams

**English:**
For growth in sales, I think the biggest learning from the the R&D side at least has been the scale is very different with sales, and so it's really hard to use as much quantitative data to make growth, to make some of those decisions.

**中文翻译:**
对于增长和销售的结合，至少从研发端的角度来看，最大的教训是销售的规模感非常不同，因此很难像以前那样使用大量的定量数据来做增长决策。

---

### [01:02:18] Archie Abrams

**English:**
And so a lot of it has been building much more qualitative insights working with merchant success, sales about the challenges they're facing and onboarding a large customer. So how do we build import tools that work for them? How do we make sure they have the right guidance in the product for a very different set of use cases? So a lot of it has just been very much empathy building with sales about what that merchant journey looks like, and quite frankly challenging ourselves to think differently. It's been one thing.

**中文翻译:**
所以很大一部分工作是与商家成功团队、销售团队合作，建立更多的定性洞察，了解他们在入驻大客户时面临的挑战。比如：我们如何构建适合他们的导入工具？我们如何确保产品中针对完全不同的用例有正确的引导？所以很多工作是与销售团队建立共情，了解商家的旅程，坦率地说，也是在挑战我们自己去换位思考。这是其一。

---

### [01:02:49] Archie Abrams

**English:**
And then second, we kind of built two very distinct funnels for a little bit. There's a sales funnel. You come in, you contact us, that's it. There's no mention of self-service, there's no this. There's just drive MQLs, boom. Then there's the self-service thing. There's no mention of sales anywhere.

**中文翻译:**
第二，有一段时间我们构建了两个非常截然不同的漏斗。一个是销售漏斗：你进来，联系我们，仅此而已。没有提到自助服务，什么都没有，只是为了驱动 MQL（市场认可线索）。另一个是自助服务漏斗，完全没提到销售。

---

### [01:03:05] Archie Abrams

**English:**
So one of the last thing the year, last year we've been really doing is how do we create these hyper journeys where there is... We shouldn't force the merchant to choose, do you want to talk to sales? You want to do self-service? Should give them the options, whatever path that they want to go on.

**中文翻译:**
所以去年我们一直在做的一件事是：我们如何创建这些“混合旅程”？我们不应该强迫商家选择“你是想和销售谈，还是想自助服务？”应该给他们选项，让他们选择自己想走的路径。

---

### [01:03:19] Archie Abrams

**English:**
And so a lot of that has been building into the self-service journey over to sales and then from sales into self-service. That's broken a lot of metrics in the business. That's broken a lot of ways people have thought about their jobs, and so there's been a lot of cultural resetting and just getting smarter from a metric standpoint about, how do we measure this thing of hybrid journey? They came in via self-service, they went over to sales. How do we value each of those components in the process? And transparently, that's something we're still getting better at, but it's really important to get there.

**中文翻译:**
所以很多工作是把销售环节融入自助旅程，或者从销售引导回自助服务。这打破了业务中的很多指标，也打破了很多人对自己工作的认知。因此，我们进行了大量的文化重塑，并从指标的角度变得更聪明：我们如何衡量这种混合旅程？他们通过自助服务进来，然后转到了销售。我们如何评估这个过程中每个环节的价值？坦率地说，这是我们仍在努力改进的地方，但达到那个目标非常重要。

---

### [01:03:55] Lenny Rachitsky

**English:**
Is there an example of something that broke that would be illustrative of what you're describing?

**中文翻译:**
有没有什么“崩掉”的例子可以说明你所描述的情况？

---

### [01:04:01] Archie Abrams

**English:**
Yeah. So I think that breaks is drive someone from an ad over to self-service. We typically look at only the self-service LTV of that person. But what happens if they come in, they sign up via self-service and then they go talk to sales? They get changed to a sales driven merchant, which means that that value of that merchant, which is usually actually quite large, does not get associated back to that ad campaign.

**中文翻译:**
是的。我认为崩掉的地方在于：通过广告把某人引向自助服务。我们通常只看那个人的自助服务 LTV。但如果他们进来了，通过自助服务注册，然后去和销售谈了呢？他们会被标记为“销售驱动型商家”，这意味着该商家的价值（通常很大）不会被关联回最初的那个广告活动。

---

### [01:04:35] Archie Abrams

**English:**
Oh, guess what that means? That means you would probably reduce investment on that ad campaign because you weren't valuing that. Our system had two different models for calculating LTV. Sales driven one, and a self-service one. Uh oh, we're going to make suboptimal investment decisions now by kind of moving things around even though it's the right thing to do.

**中文翻译:**
猜猜这意味着什么？这意味着你可能会减少对那个广告活动的投入，因为你没有评估到它的真实价值。我们的系统有两种不同的 LTV 计算模型：销售驱动型和自助服务型。噢，糟糕，即使我们做的是正确的事，但因为数据归因问题，我们现在会做出次优的投资决策。

---

### [01:04:55] Archie Abrams

**English:**
So a lot of it's in rebuilding all instrumentation, how we do LTV modeling, how we do attribution, how we do incrementality testing across each of those different types of outcomes, because it was not an intuitive thing for us originally because we had built all of these systems with a much more siloed view.

**中文翻译:**
所以很多工作在于重建所有的监测手段：我们如何做 LTV 建模、如何做归因、如何针对每种不同类型的结果做增量测试。因为最初这对我们来说并不直观，因为我们构建这些系统时视角是非常孤立的。

---

### [01:05:16] Lenny Rachitsky

**English:**
Yeah, basically attribution gets a lot more complicated. Are you going in a multi-touch attribution direction or is there something even more clever?

**中文翻译:**
是的，基本上归因变得复杂得多。你们是在往“多触点归因”（multi-touch attribution）的方向走，还是有更聪明的办法？

---

### [01:05:26] Archie Abrams

**English:**
My rant is I am... Multi-touch attribution as its place. I think ideally what we want to get through is what we really care about is incrementality. So incrementality is kind of the gold standards, for people who are less like attribution measure is, how do you assign value to a given touch point, right? Click, a view, etc. But it doesn't tell you causally what drove something. That's where incrementality tells you.

**中文翻译:**
我的观点是……多触点归因有它的位置。但我认为理想情况下，我们真正关心的是“增量性”（incrementality）。增量性是金标准。对于不太了解的人来说，归因衡量的是你如何给特定的触点分配价值（点击、浏览等），但它不能从因果关系上告诉你是什么驱动了结果。而增量性可以告诉你。

---

### [01:06:04] Archie Abrams

**English:**
Incrementality test is basically don't show ads on meta for certain number of people. Show it to the other set, see what the lift is and the outcome. A lot of what we're doing is trying to get a lot, is continuing to get even more sophisticated in incrementality measurement for not just self-serve outcomes, but for self-service outcomes that then drive to sales for sales specific outcomes.

**中文翻译:**
增量测试基本上是：不对一部分人展示 Meta 广告，对另一部分人展示，然后看结果的提升。我们正在做的很多工作是尝试在增量衡量方面变得更加精细，不仅针对自助服务结果，还针对那些转化为销售的自助服务结果，以及纯销售驱动的结果。

---

### [01:06:35] Archie Abrams

**English:**
And as soon as we have that kind of incrementality at the channel level, we can get a lot more sophisticated in terms of our bidding, budgeting, and all of that. But that's really the key thing we want to get to.

**中文翻译:**
一旦我们在渠道层面拥有了这种增量数据，我们在竞价、预算等方面就能变得更加精细。这才是我们真正想要达到的目标。

---

### [01:06:46] Lenny Rachitsky

**English:**
There's certain topics that alone can be their own podcast conversation to just dive deep into this stuff. But I'm going to stop myself and I'll go further down that track. Let me touch on a couple more things before I let you go. One is marketing. So we talked about sales, marketing. You guys don't have a CMO, there's no Shopify CMO. Instead you embed marketing leads within the org. For folks that are trying to grapple with that, should we hire CMO? Should we do something else? What have you learned about maybe the benefits and also maybe some downsides of approaching it the way you guys have approached it?

**中文翻译:**
有些话题本身就足以撑起一整集播客。但我得克制一下，不再深入下去了。在你离开前，我再提两件事。一个是营销。我们谈到了销售和营销。你们没有 CMO，Shopify 没有首席营销官。相反，你们将营销负责人嵌入到组织内部。对于那些正在纠结“我们该雇 CMO 还是做点别的”的人，关于你们这种做法的好处和坏处，你学到了什么？

---

### [01:07:07] Archie Abrams

**English:**
The benefit is, so there's growth marketing who sits in growth, there's revenue marketing who sits over closer to sales. There's a brand team under Harley who does amazing work. Our president. There's marketing embedded in core and PMM, sit with the product managers there. There's shop marketing on a consumer side. So marketing is truly everywhere in the org.

**中文翻译:**
好处是：增长营销在增长部门，收入营销更靠近销售。Harley（我们的总裁）领导着一个做得很棒的品牌团队。核心部门和 PMM（产品市场经理）中也嵌入了营销人员，他们和产品经理坐在一起。消费者端还有 Shop 营销。所以营销真正遍布整个组织。

---

### [01:07:28] Archie Abrams

**English:**
And I think the benefit of it is it's closest to the primary goal that those marketers are trying to do. They sit with growth so we can focus on that self-service motion. Harley is an amazing communicator, so brand sits with him so he can have a lot of influence over that. And so I think it sits with the people its most relevant outcomes are driving, which is great. It allows us move faster with less kind of coordination.

**中文翻译:**
我认为这样做的好处是，它最接近这些营销人员试图实现的初衷。他们和增长团队坐在一起，所以我们可以专注于自助服务。Harley 是一位了不起的沟通者，所以品牌团队跟着他，这样他可以产生很大的影响力。所以我认为它与最相关的产出驱动者坐在一起，这很棒。它让我们能以更少的协调成本跑得更快。

---

### [01:07:58] Archie Abrams

**English:**
I think it only works because Tobi and Harley has such amazing intuition on what the brand is, needs to be, and all of that. Some of what the CMO does of kind of creating the cohesive story of Shopify it held in their heads and they have the pen on that. And so that allows then, that piece of that CMO's job to not be as important at Shopify. But the other pieces are obviously critical, but they can be now closer to the action and where they're going to drive the most impact. The downside is things are sometimes very messy. So that's...

**中文翻译:**
我认为这之所以奏效，是因为 Tobi 和 Harley 对品牌是什么、应该是什么有着惊人的直觉。CMO 的部分工作——即创造 Shopify 统一的故事——就在他们脑子里，他们掌握着那支笔。这使得 CMO 的那部分工作在 Shopify 显得没那么重要。但其他部分显然很关键，现在它们可以更接近实战，在最能产生影响的地方发挥作用。缺点是事情有时会变得非常混乱。所以……

---

### [01:08:40] Lenny Rachitsky

**English:**
It's another example where the founder, their background and interest in skills can impact significantly the way the work is structured and who you hire and don't hire. Okay, one last question. Totally different topic, discounting. So you worked at Udemy for a long time. And from what I understand, discounting was one of the key reasons Udemy succeeded and one of the big differentiators. I'm curious what you learned about discounting, the power of discounting as a growth lever.

**中文翻译:**
这又是另一个例子，说明创始人的背景、兴趣和技能会显著影响工作的组织方式以及你雇佣或不雇佣谁。好，最后一个问题。完全不同的主题：折扣。你在 Udemy 工作了很长时间。据我所知，折扣是 Udemy 成功的关键原因之一，也是重大的差异化因素。我很想知道你关于折扣学到了什么，以及折扣作为增长杠杆的力量。

---

### [01:09:09] Archie Abrams

**English:**
Yeah, so Udemy is a very an online marketplace for online courses. So come on course. And I think what was happening in I started, and we were there 2012-ish was people were like, "What is this online course thing? I don't really understand what it is. I don't understand what the value is and what I'm willing to pay."

**中文翻译:**
是的，Udemy 是一个在线课程的市场。我 2012 年左右加入时，人们还在想：“在线课程到底是什么鬼？我不理解它是什么，不理解它的价值，也不理解我该付多少钱。”

---

### [01:09:30] Archie Abrams

**English:**
And so what discounting has a really powerful effect on is it can signal value with a high list price, but then bring something down to an affordable price. And that may seem like of course that's obvious, but in online courses what was important is the list price would be high at 100 bucks. So it's associated with a college course. But what people really value this thing as was a book.

**中文翻译:**
折扣的一个非常强大的作用是：它可以通过高昂的标价来释放价值信号，然后将其降至可负担的价格。这听起来可能很显而易见，但在在线课程中，重要的是标价很高（比如 100 美元），这样它就会与大学课程联系起来。但人们内心真正评估它的价值其实是一本书。

---

### [01:09:54] Archie Abrams

**English:**
And so you could signal very high, signal quality through price, which was very murky at that point in online learning. Signal value through price. Discount it to 10 bucks, or that was a typical Udemy deal. And then so 99% off, 90% off. We might see fire sales, but it changed the value in willingness to pay and then it tapped into the fact that, and still is education is very aspirational.

**中文翻译:**
所以你可以通过价格释放非常高的质量信号，这在当时的在线学习领域是非常模糊的。通过价格传递价值信号，然后打折到 10 美元（这是典型的 Udemy 交易）。也就是 1 折甚至 0.1 折。我们可能会看到大甩卖，但它改变了价值感和支付意愿，并利用了这样一个事实：教育是非常具有感召力（aspirational）的。

---

### [01:10:23] Archie Abrams

**English:**
And so what a lot of people missed in education is yes, we want people to actually take the course, but that's actually in many cases not the job to be done. That there's an emotional job that's even more important, which is I'm feeling like I'm making progress in my educational journey, and just the act of purchasing a course or the act of buying a book is progress.

**中文翻译:**
很多人在教育领域忽略的一点是：是的，我们希望人们真正去上课，但在很多情况下，那并不是用户真正的“待办任务”（job to be done）。还有一个更重要的情感任务，那就是“我觉得我在教育旅程中取得了进步”，而仅仅是购买课程或买书这个行为本身，就是一种进步。

---

### [01:10:47] Archie Abrams

**English:**
And so if you can make it very enticing, very high value thing, cheap, urgency, you can let people make that emotional journey by the act of purchasing, which then allowed us to actually have very good retention. Because you could keep coming back to that emotional job over and over again, which just counting with urgency allowed us to do.

**中文翻译:**
所以，如果你能把它做得非常诱人，看起来价值极高，但价格便宜且有紧迫感，你就能让人们通过购买行为完成那次情感旅程，这实际上让我们获得了很好的留存。因为你可以一次又一次地回到那个情感任务中，而带有紧迫感的折扣正好能做到这一点。

---

### [01:11:10] Lenny Rachitsky

**English:**
Amazing. Well with that, we reached our very exciting lightning round. Archie, are you ready?

**中文翻译:**
太棒了。那么，我们进入了非常令人兴奋的闪电轮环节。Archie，准备好了吗？

---

### [01:11:15] Archie Abrams

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [01:11:17] Lenny Rachitsky

**English:**
First question, what are two or three books that you recommended most to other people?

**中文翻译:**
第一个问题，你向别人推荐最多的两三本书是什么？

---

### [01:11:21] Archie Abrams

**English:**
So one, I love to go back to marketers who wrote in the 1920s. And so one that I love is Scientific Advertising by Claude Hopkins. So it's basically one of the first direct marketers that came out and he innovated on some of the concepts of copywriting and just how you sell a product around can't make this product, can't sell the product, can you tell the product will help the customer achieve their goals?

**中文翻译:**
第一，我喜欢读 1920 年代营销人员写的书。我非常喜欢的一本是 Claude Hopkins 的《科学的广告》（Scientific Advertising）。他基本上是第一批直复营销人员之一，他在文案策划和产品销售概念上进行了创新：不要只说你能造这个产品，要说这个产品如何帮助客户实现他们的目标。

---

### [01:12:09] Archie Abrams

**English:**
Scientific Advertising, it's a great book.

**中文翻译:**
《科学的广告》，这是一本伟大的书。

---

### [01:12:09] Lenny Rachitsky

**English:**
It's just like the name alone, it sounds really cool. Especially for someone in your shoes that feels like the perfect book for your role. And I think there's so much wisdom in just the thing someone figured out many years ago about what convinces people to buy something is still true and people overcomplicate it. Just going back to the original is often really useful.

**中文翻译:**
光是这个名字听起来就很酷。特别是对于你这样职位的人来说，这简直是为你量身定制的书。我认为这里面蕴含着巨大的智慧：某人多年前发现的关于如何说服人们购买东西的道理至今依然适用，而人们往往把它复杂化了。回归本源通常非常有用。

---

### [01:12:28] Archie Abrams

**English:**
Totally. And The Perfect Mile about the chase for sub four minute mile by Roger Bannister and a few other folks is just a wonderful... As a runner, it's a really fun book to read about perseverance, how these folks really, they all competed to get to that really amazing goal of under four minutes in a mile.

**中文翻译:**
完全正确。还有《完美的一英里》（The Perfect Mile），讲述了 Roger Bannister 和其他几个人追逐“一英里四分钟大关”的故事。作为一个跑者，这是一本关于毅力的非常有趣的书，讲述了这些人如何竞争以实现那个惊人的目标。

---

### [01:12:52] Lenny Rachitsky

**English:**
Awesome. Do you have a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
太棒了。你最近有没有特别喜欢的电影或电视剧？

---

### [01:12:58] Archie Abrams

**English:**
I went back in time and I watched for the first time actually the entire season or all the episodes of The Sopranos, which was quite fun. Highly recommend. I did that in The Wire in the last six months.

**中文翻译:**
我“穿越”回过去，第一次完整看完了《黑道家族》（The Sopranos）的所有剧集，非常精彩。强烈推荐。过去六个月我还看完了《火线》（The Wire）。

---

### [01:13:13] Lenny Rachitsky

**English:**
It's a lot of watching.

**中文翻译:**
那可得花不少时间看。

---

### [01:13:14] Archie Abrams

**English:**
It's a lot watching. Work out in the morning on my elliptical or bike, so it's a nice-

**中文翻译:**
确实很多。我早上在椭圆机或动感单车上锻炼时看，所以是个不错的……

---

### [01:13:20] Lenny Rachitsky

**English:**
That's smart-

**中文翻译:**
那很聪明。

---

### [01:13:21] Archie Abrams

**English:**
Workout show.

**中文翻译:**
健身剧。

---

### [01:13:22] Lenny Rachitsky

**English:**
That's a good motivator to just work out out something. I got to watch the next episode. The Wire, it's hour long episodes and five seasons times 20. I think it's 22 episodes per season, right?

**中文翻译:**
这是一个很好的健身动力。我得看下一集。《火线》每集一小时，五季，每季大概 20 到 22 集，对吧？

---

### [01:13:32] Archie Abrams

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:13:33] Lenny Rachitsky

**English:**
Oh geez. It's a lot of watching and I did that once and I was like, "I've got a lot of episodes to watch," but incredible. Okay. It's funny you should say The Sopranos. I feel like a number of people recently told me they're watching the full Sopranos again. It's like a trend recently for some reason.

**中文翻译:**
天哪。那要看很久，我以前看过一次，感觉“我有太多的剧要追了”，但确实很棒。好。有趣的是你提到了《黑道家族》。我觉得最近有好几个人告诉我他们正在重看整部《黑道家族》。不知为何，这最近成了一种趋势。

---

### [01:13:50] Archie Abrams

**English:**
Oh, interesting.

**中文翻译:**
噢，有趣。

---

### [01:13:51] Lenny Rachitsky

**English:**
Anyway, do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
不管怎样，你最近有没有发现什么非常喜欢的电子产品或应用？

---

### [01:13:54] Archie Abrams

**English:**
So the AI music creator. My kids and I... I'm the least musical person in the world and it's been amazing. My kids and I will create songs together about our days, about what's going on. So it's just been really fun to be able to have a musical experience for a non-musical person, and have that creative experience for them and it's been really awesome to use.

**中文翻译:**
AI 音乐创作工具。我和我的孩子们……我是世界上最没有音乐细胞的人，但这太神奇了。我和孩子们会一起创作关于我们日常生活、关于正在发生的事情的歌曲。对于一个不懂音乐的人来说，能拥有这种音乐体验和创作体验真的很有趣，用起来非常棒。

---

### [01:14:15] Lenny Rachitsky

**English:**
Suno is Insane. I think it's Suno.ai, folks want to check it out. It's just such a fun party trick too, just to write a song on the spot about something that you're thinking about. Awesome. Two more questions. Do you have a favorite life motto that you often come back to, find helpful and worker life?

**中文翻译:**
Suno 简直太疯狂了。我想是 Suno.ai，大家可以去看看。这还是个很有趣的聚会小把戏，可以当场根据你正在想的事情写首歌。太棒了。还有两个问题。你有没有什么经常想起的、觉得对工作或生活有帮助的人生格言？

---

### [01:14:31] Archie Abrams

**English:**
Yeah, I often come back to the plan is the plan until it's not. And it's basically like we have a plan. It's the plan, it's our best, let's commit to it. But acknowledge it might change and we'll deal with it then. But if the combination of we have a plan, stay focused on that, with also the acknowledgement that you need to be flexible, and try to combine those two sometimes contradictory things of focus plan with we got to be able to react in an effective way.

**中文翻译:**
是的，我经常想起一句话：“计划就是计划，直到它不再是计划为止。”基本上就是：我们有一个计划，它是目前最好的，让我们致力于执行它。但也要承认它可能会改变，到时候我们会处理。这是一种结合：既要有一个计划并保持专注，又要承认需要保持灵活性，尝试将“专注计划”与“有效应对变化”这两个有时矛盾的东西结合起来。

---

### [01:15:01] Lenny Rachitsky

**English:**
Reminds me of strong opinions loosely held as a concept.

**中文翻译:**
这让我想起了“持有强烈的观点，但保持开放的心态”（strong opinions loosely held）这个概念。

---

### [01:15:07] Archie Abrams

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [01:15:08] Lenny Rachitsky

**English:**
Awesome. Okay, final question. So I asked your wife what to ask you when you came on this podcast and she suggested that I ask you about your late father who had a lot of impact on your leadership style. So here's my question, what did you learn from your dad that impacts the way you work today?

**中文翻译:**
太棒了。好，最后一个问题。我问过你妻子当你来这个播客时该问你什么，她建议我问问你已故的父亲，他对你的领导风格有很大影响。所以我的问题是：你从父亲那里学到了什么，影响了你今天的工作方式？

---

### [01:15:26] Archie Abrams

**English:**
Yeah. My dad a lot is a father, and he was an entrepreneur in technology. And I think one of the things that I so appreciate about his leadership style was the empathy, and curiosity, and kindness that he showed in everything. And I hope in some of the stories that of him, it's like no matter who anyone was, curious, love to engage and learn from. And I hope that's something that I try to take inspiration from is just be with everyone kind and learn from everyone you're with and around. So something I think about a lot.

**中文翻译:**
是的。我父亲不仅是一位父亲，他还是科技领域的创业者。我认为我最欣赏他的领导风格的一点是，他在每件事中表现出的共情、好奇心和善良。在他的一些故事里，无论对方是谁，他都充满好奇，乐于交流并向对方学习。我希望我也能从中汲取灵感：对每个人都保持友善，并向身边的每一个人学习。这是我经常思考的事情。

---

### [01:16:08] Lenny Rachitsky

**English:**
That super resonates. He sounds like a wonderful human as are you. Archie, this was wonderful. We touched on so much. We covered so much. I feel like we could go on for many more hours. Maybe we'll do round two as you learn more things at your time at Shopify. Two final questions. Where can folks find you online if they want to potentially reach out or follow the stuff you're up to, and how can listeners be useful to you?

**中文翻译:**
这引起了极大的共鸣。他听起来是个很棒的人，你也是。Archie，这次谈话太棒了。我们触及了这么多话题，涵盖了这么多内容。我觉得我们可以再聊好几个小时。也许等你以后在 Shopify 学到更多东西时，我们可以进行第二轮。最后两个问题：如果大家想联系你或关注你的动态，可以在哪里找到你？听众们能为你做些什么？

---

### [01:16:30] Archie Abrams

**English:**
So not super on social media. But on LinkedIn, check me out, send me a message. And then yeah, if folks are hiring a bunch of folks, growth marketers, PMs, engineers, data folks, UXers, you want to work at Shopify and growth or other parts? Fully remote. So we'd love to have great people join.

**中文翻译:**
我不太玩社交媒体。但在 LinkedIn 上可以找到我，给我发消息。另外，如果大家正在找工作，我们正在招聘大量的增长营销人员、产品经理、工程师、数据人员、UX 设计师。你想在 Shopify 的增长部门或其他部门工作吗？我们是完全远程办公的。所以我们非常欢迎优秀的人才加入。

---

### [01:16:54] Lenny Rachitsky

**English:**
Awesome. And that last point, I think I'll just highlight one of the few remaining fully remote tech companies that is not returning to work. Returning to the office [inaudible 01:17:05] work. Definitely work.

**中文翻译:**
太棒了。最后一点我想强调一下：Shopify 是少数几家坚持完全远程办公、不强制要求回到办公室工作的科技公司之一。

---

### [01:17:07] Archie Abrams

**English:**
Yes. Yes.

**中文翻译:**
是的，没错。

---

### [01:17:09] Lenny Rachitsky

**English:**
Amazing. And sounds like basically you're hiring across all functions.

**中文翻译:**
太好了。听起来你们基本上在所有职能岗位上都在招聘。

---

### [01:17:12] Archie Abrams

**English:**
All functions.

**中文翻译:**
所有职能。

---

### [01:17:13] Lenny Rachitsky

**English:**
Perfect. Archie, thank you so much for being here.

**中文翻译:**
完美。Archie，非常感谢你能来。

---

### [01:17:17] Archie Abrams

**English:**
Thank you Lenny, it was fun.

**中文翻译:**
谢谢 Lenny，很有趣。

---

### [01:17:19] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。