# Arielle Jackson - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Arielle Jackson.

---

### [00:00:00] Arielle Jackson

**English:**
So over time, a word can come to mean something that is beyond what that actual word means. Like Disney means magic today. Volvo means safety. Those names are not good. If I just put it in a spreadsheet or one of those lists, no one would pick it. So that's kind of what I mean, that the name is just part of the overall marketing or the overall brand and a bad name with a really great company with great company strategy, great marketing is going to be great over time. And a good name is just going to help you, but I don't think a bad name is going to kill a good company.

**中文翻译:**
随着时间的推移，一个词所代表的含义可能会超越它本身的字面意思。比如今天，“迪士尼”意味着魔幻，“沃尔沃”意味着安全。这些名字本身其实并不算好。如果我只是把它们放在电子表格或名单里，没人会选中它们。所以我的意思是，名字只是整体营销或整体品牌的一部分；一个名字虽然不好，但如果公司非常出色，有伟大的公司战略和优秀的营销，随着时间的推移，它依然会变得伟大。一个好名字固然会有所帮助，但我认为一个烂名字不会毁掉一家优秀的公司。

---

### [00:00:42] Lenny

**English:**
Arielle Jackson spent nine years at Google, where she helped grow Gmail in its early days, taking it from just a side project to a product that is now used by hundreds of millions of people all over the world. Then she went on to Square, where she was one of the first marketers and helped launch and scale the growth of Square reader. She's also worked with over 100 early stage companies, helping them nail their brand and marketing efforts, including Patreon, Loom, Front, Eero, Maven, Sprig, just to name a few.

**中文翻译:**
Arielle Jackson 在 Google 工作了九年，在 Gmail 的早期阶段协助其成长，将其从一个副业项目转变为现在全球数亿人使用的产品。随后她加入了 Square，成为那里最早的营销人员之一，并助力 Square 读卡器的发布和规模化增长。她还与 100 多家初创公司合作过，帮助他们精准定位品牌和营销工作，其中包括 Patreon、Loom、Front、Eero、Maven、Sprig 等等。

---

### [00:01:12] Lenny

**English:**
These days, she teaches a super popular course on startup brand strategy and she's a marketer in residence at First Round capital. In our chat, we cover primarily three things, naming strategies for your startup or your product, a framework for developing your brand, that includes your purpose, your positioning, and your personality, and also getting PR for your startup. I can't wait for you to listen to this conversation with Arielle. And so with that, I bring you Arielle Jackson.

**中文翻译:**
如今，她在教授一门非常受欢迎的初创公司品牌战略课程，并且是 First Round Capital 的驻场营销专家（Marketer in Residence）。在我们的交谈中，我们主要涵盖了三件事：初创公司或产品的命名策略；开发品牌的框架（包括使命、定位和个性）；以及如何为初创公司争取公关（PR）机会。我迫不及待想让大家听到与 Arielle 的这段对话。那么，下面请出 Arielle Jackson。

---

### [00:01:41] Lenny

**English:**
Hey, Ashley, head of marketing at Flatfile, how many B2B SaaS companies would you estimate need to import CSV files from their customers?

**中文翻译:**
嘿，Ashley（Flatfile 的营销负责人），你估计有多少 B2B SaaS 公司需要从客户那里导入 CSV 文件？

---

### [00:01:49] Ashley

**English:**
At least 40%.

**中文翻译:**
至少 40%。

---

### [00:01:51] Lenny

**English:**
And how many of them screw that up? And what happens when they do?

**中文翻译:**
那其中有多少公司把这件事搞砸了？搞砸之后会发生什么？

---

### [00:01:54] Ashley

**English:**
Well? Based on our data, about a third of people will consider switching to another company after just one bad experience during onboarding. So if your CSV importer doesn't work right, which is super common, considering customer files are chock-full of unexpected data and formatting, they'll leave.

**中文翻译:**
嗯，根据我们的数据，大约三分之一的人在入驻（onboarding）过程中只要经历一次糟糕的体验，就会考虑更换公司。所以，如果你的 CSV 导入工具运行不正常（这非常普遍，因为客户文件里充满了各种意想不到的数据和格式），他们就会流失。

---

### [00:02:13] Lenny

**English:**
I am 0% surprised to hear that. I'm consistently seeing that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing long-term retention. Getting people to your aha moment more quickly and reliably is so incredibly important.

**中文翻译:**
听到这个我一点也不意外。我一直认为，改善入驻流程是提高注册转化率和增加长期留存率的最高杠杆机会之一。让用户更快速、更可靠地达到“顿悟时刻”（aha moment）是极其重要的。

---

### [00:02:28] Ashley

**English:**
Totally. It's incredible to see how our customers like Square, Spotify and Zuora are able to grow their businesses on top of Flatfile. It's because [inaudible 00:02:38] data onboarding acts like a catalyst to get them and their customers where they need to go faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zuora 这样的客户能够在 Flatfile 的基础上发展业务，真是令人惊叹。这是因为数据入驻就像催化剂一样，让他们和他们的客户能更快地达到目标。

---

### [00:02:45] Lenny

**English:**
If you'd like to learn more or get started, check out Flatfile at flatfile.com/lenny.

**中文翻译:**
如果你想了解更多信息或开始使用，请访问 flatfile.com/lenny 查看 Flatfile。

---

### [00:02:53] Lenny

**English:**
This episode is brought to you by unit. What did Gusto, Uber, Shopify and AngelList all have in common? They've all decided to build banking into their product. According to AngelList head of product, banking makes every single feature more interesting. With it, our platform functions as financial mission control for our customers. Without it, we're just another software tool in a big messy stack.

**中文翻译:**
本期节目由 Unit 赞助。Gusto、Uber、Shopify 和 AngelList 有什么共同点？他们都决定将银行功能内置到自己的产品中。根据 AngelList 产品负责人的说法，银行功能让每一个功能都变得更有趣。有了它，我们的平台就能成为客户的财务控制中心；没有它，我们只是庞杂工具堆栈中的又一个软件工具而已。

---

### [00:03:15] Lenny

**English:**
Embedding banking into your product, not only adds differentiation, but also helps you acquire, retain and monetize your customers. Unit is the market leader in banking as a service combining multiple bank partners with a developer friendly API to empower companies of all sizes to launch accounts, cards, payments, and lending in just a few weeks. Unit is trusted by leading brands, such as AngelList, [inaudible 00:03:39] Invoice2go And Roofstock.

**中文翻译:**
将银行功能嵌入到你的产品中，不仅能增加差异化，还能帮助你获取、留存客户并实现变现。Unit 是“银行即服务”（BaaS）领域的市场领导者，它将多个银行合作伙伴与开发者友好的 API 相结合，使各种规模的公司都能在短短几周内推出账户、卡片、支付和贷款业务。Unit 深受 AngelList、Invoice2go 和 Roofstock 等领先品牌的信赖。

---

### [00:03:41] Lenny

**English:**
To hear more about how Unit enables companies like yours to build banking, visit unit.co/ lenny to request a demo or to try their free sandbox. That's unit.co/lenny.

**中文翻译:**
想了解更多关于 Unit 如何赋能像你这样的公司构建银行功能的信息，请访问 unit.co/lenny 申请演示或试用他们的免费沙盒环境。网址是 unit.co/lenny。

---

### [00:03:58] Lenny

**English:**
Welcome to the podcast, Arielle.

**中文翻译:**
欢迎来到我的播客，Arielle。

---

### [00:04:01] Arielle Jackson

**English:**
Thanks so much for having me. It's great to be here.

**中文翻译:**
非常感谢邀请我。很高兴来到这里。

---

### [00:04:03] Lenny

**English:**
It's absolutely my pleasure. I've read so much of your writing online. You've done a lot of writing, which I found really helpful. And so I'm really jazzed to be digging into all kinds of really good stuff. Before we get into some of the meat, just a couple questions that I had in my mind. You've worked with so many amazing companies, Google, Square, Loom, Patreon, Front. So many others. I don't want to keep going. What's been either your favorite or most unusual project that you've worked on?

**中文翻译:**
这是我的荣幸。我在网上读过很多你写的文章。你写了很多东西，我觉得非常有帮助。所以我非常兴奋能深入探讨这些干货。在进入正题之前，我有几个问题。你和这么多优秀的公司合作过，Google、Square、Loom、Patreon、Front 等等。还有很多，我就不一一列举了。在你参与过的项目中，哪一个是你的最爱，或者是最特别的？

---

### [00:04:35] Arielle Jackson

**English:**
Gosh, it's like asking me to choose my favorite son. I'm like, gosh, I can't really like pick one.

**中文翻译:**
天哪，这就像让我选出最喜欢的儿子一样。我真的很难选出一个。

---

### [00:04:40] Lenny

**English:**
That'll be the next question.

**中文翻译:**
那是下一个问题。

---

### [00:04:41] Arielle Jackson

**English:**
I would probably say that my favorite project, and this is because they get reminded of it on a daily basis was working at on the Square stand at Square. It was the first time I ever worked on hardware and our joint Square was 140 people. We had no marketing function. We had a couple marketing people. We had no product managers and the hardware team was running the show on launching this new product that was supposed to get us up market into brick and mortar.

**中文翻译:**
我可能会说我最喜欢的项目是 Square 的 Square Stand（iPad 支架读卡器），因为我每天都会看到它。那是我第一次接触硬件产品。我加入 Square 时公司只有 140 人。我们当时没有营销部门，只有几个营销人员。我们也没有产品经理，硬件团队主导了这款新产品的发布，目的是让我们进入高端市场和实体店领域。

---

### [00:05:05] Arielle Jackson

**English:**
And anyway, I was running event marketing at the time and giving away a bunch of those readers that you stick into a phone for free and having a lot of small merchants use. I volunteered to run the launch of this product as a product marketer for the first time. And it was just so fun, doing everything from positioning it, figuring out how we were going to talk about this beautiful new piece of hardware that would turn your iPad into a real point of sale.

**中文翻译:**
总之，我当时负责活动营销，免费发放大量那种插在手机上的读卡器，让很多小商户使用。我自荐作为产品营销人员（PMM）第一次负责这款产品的发布。那真的很有趣，从定位产品，到构思如何描述这款精美的硬件——它能把你的 iPad 变成一个真正的销售终端（POS）。

---

### [00:05:31] Arielle Jackson

**English:**
We had people fly around the country and get cool coffee shops and brick and mortar businesses seeding it so that they would all use it. We had I think 15 Metro areas covered with the coolest coffee shops and donut shops and everything at launch. And you know, there was a lot of fake it till you make it. I was negotiating a deal with Best Buy in the Apple store. Never done anything like that before.

**中文翻译:**
我们派人飞往全国各地，在酷炫的咖啡馆和实体店进行“播种”，让他们都用上这款产品。发布时，我们覆盖了大约 15 个大都市区，包括最酷的咖啡店、甜甜圈店等等。你知道，当时有很多“边做边学”的成分。我当时在和百思买（Best Buy）和苹果商店谈判，以前从未做过这种事。

---

### [00:05:53] Arielle Jackson

**English:**
Designing packaging was really awesome. There was just so much to it launching a physical product. And at the time it was at a pretty high price point for a company that had always had one free product and helping that company go up market. And I remember I was 30 something weeks pregnant when we launched. We got all the blue bottle stores to use it. And we had this launch event where Jack, our head of hardware, Jesse unveiled this product at the blue bottle in Mint Plaza. And I was super pregnant and super proud. And I still get kind of excited every time I pay on one of those, which is all the time.

**中文翻译:**
设计包装也非常棒。发布一款实体产品涉及的事情太多了。当时对于一家一直提供免费产品的公司来说，这款产品的价位相当高，它帮助公司走向了高端市场。我记得发布时我已经怀孕 30 多周了。我们让所有的 Blue Bottle 咖啡店都用上了它。我们举办了发布会，Jack（多西）和我们的硬件负责人 Jesse 在 Mint Plaza 的 Blue Bottle 展示了这款产品。当时我挺着大肚子，感到超级自豪。直到现在，每次我用那个设备付钱时（我经常用），我还是会感到很兴奋。

---

### [00:06:30] Lenny

**English:**
Super pregnant and super proud. I love it. And that product that was the POS stand, the iPad thing that you kind of swivel and sign.

**中文翻译:**
“挺着大肚子，超级自豪”，我喜欢这个说法。那个产品就是 POS 支架，就是那个可以旋转并签名的 iPad 装置。

---

### [00:06:39] Arielle Jackson

**English:**
Yeah. And there's been new versions of it since, there's a contactless version of it, and there's one with an integrated screen that I think is Android based, which you don't have to have an iPad, but that product's still around. I still pay on that original Square stand all the time. I drink a lot of coffee. Those independent coffee shops around LA. So they're all still using it.

**中文翻译:**
是的。后来有了新版本，有感应支付版，还有一个带集成屏幕的版本（好像是基于安卓的，不需要 iPad），但那个产品一直都在。我经常在那个原始的 Square Stand 上付钱。我喝很多咖啡，洛杉矶周围的那些独立咖啡馆现在还在用它。

---

### [00:07:01] Lenny

**English:**
We're going to talk about positioning a bunch, but while we're on the topic, what was the positioning of that product while we're talking about it?

**中文翻译:**
我们待会会深入讨论定位，但既然聊到了这儿，那款产品当时的定位是什么？

---

### [00:07:07] Arielle Jackson

**English:**
Yeah, so at the time Square was mostly used by farmer's market vendors and event vendors. I made jewelry in a past life and that's how I got to Square was being one of those vendors. And the positioning was really that it was for brick and mortar businesses, particularly quick serve coffee, donuts, sandwich shops that kind of quick serve brick and mortars. And it was up against your ugly old point of sale. Your cash register effectively. That was our foil. And the benefit was turn your iPad into a point of sale. And the differentiator was about one unified experience that you can do everything you can on your cash register and more, and you'd be proud to have it out on your counter.

**中文翻译:**
是的，当时 Square 主要被农贸市场的摊主和活动商贩使用。我以前做过珠宝，就是作为那样的商贩才接触到 Square 的。那款产品的定位是针对实体店，特别是快餐咖啡、甜甜圈、三明治店这类快餐实体店。它的竞争对手是你那丑陋的旧 POS 机，实际上就是你的收银机。那是我们的衬托对象。核心利益点是“把你的 iPad 变成销售终端”。差异化在于一种统一的体验：你可以完成收银机能做的所有事，甚至更多，而且你会很自豪地把它摆在柜台上。

---

### [00:08:01] Lenny

**English:**
So you said that you were creating jewelry and that's how you got into Square to work on this product. I need to hear more about that.

**中文翻译:**
你提到你以前做珠宝，并因此进入 Square 开发这款产品。我想听听更多细节。

---

### [00:08:08] Arielle Jackson

**English:**
Yeah, sure. So I was working at Google before Square and I'd always had this hobby of making jewelry and I used to sell my jewelry in a few different like boutiques around San Francisco and LA. It was a very small side hustle, but it was my creative outlet. And I sold at craft fairs around Hanukah/Christmas time. So I used to sell and just take cash. And then I got a Square reader and I sold at a craft fair that year. And it was awesome. That Square reader, it helped people buy more, it helped me sort of look cool. It was just really great to accept credit cards. I'd never done it before.

**中文翻译:**
好的。在加入 Square 之前我在 Google 工作，我一直有做珠宝的爱好，以前在旧金山和洛杉矶的一些精品店卖过。那是一个很小的副业，但它是我的创意出口。我会在光明节或圣诞节期间的工艺品展销会上卖。以前我只收现金。后来我拿到了一个 Square 读卡器，那年我在展销会上用它卖货。体验太棒了。那个读卡器让人们买得更多，也让我看起来很酷。能接受信用卡真的太棒了，我以前从未做到过。

---

### [00:08:49] Arielle Jackson

**English:**
I used to take PayPal invoices and be on my computer and send someone an invoice and they'd get it. It was painful. All the reasons that people use Square, I experienced it. And two people I knew from Google, Megan Quinn and Kyle Dink had gone to Square from Google. And so after I had that experience, I think I sent them both an email just being like, this thing's fucking awesome. I make jewelry. It was great. I sold I think it was 50% more than I did last year because I accepted credit cards and I can't remember which of them wrote back first, but they were like, come interview. And so that was basically how I ended up at Square.

**中文翻译:**
我以前用 PayPal 发票，得在电脑上给别人发发票，然后他们才能收到。那很痛苦。人们使用 Square 的所有理由，我都亲身经历过。我认识的两个 Google 前同事 Megan Quinn 和 Kyle Dink 去了 Square。在我有了那次体验后，我给他们发了邮件，大意是：“这玩意儿太牛了。我做珠宝，用它太棒了。因为能刷卡，我的销量比去年增加了 50%。”我不记得他们谁先回的信，但他们说：“来面试吧。”这就是我进入 Square 的经过。

---

### [00:09:27] Lenny

**English:**
Wow. I bet that helped you a lot through the interview, actual have personal experience.

**中文翻译:**
哇。我敢打赌这在面试中帮了你大忙，毕竟你有亲身经历。

---

### [00:09:32] Arielle Jackson

**English:**
Having been a merchant, I think it helped me understand the small merchant that initially we were marketing to.

**中文翻译:**
作为一名商户，我认为这帮助我理解了我们最初营销针对的那些小商户。

---

### [00:09:38] Lenny

**English:**
And so today you are marketing expert in residence at [inaudible 00:09:45] capital. I was going to ask what does that mean and what is it that you do day to day these days?

**中文翻译:**
那么现在，你是 First Round Capital 的驻场营销专家。我想问问那意味着什么，你现在的日常工作是什么？

---

### [00:09:51] Arielle Jackson

**English:**
Sure. So after I left Square, I went to a tiny startup that was seven people. They were funded by First Round and I helped them with everything that a tiny startup that's trying to grow needs.

**中文翻译:**
好的。离开 Square 后，我加入了一家只有 7 个人的微型初创公司。他们是由 First Round 投资的，我帮他们处理一家处于成长期的小公司所需的一切事务。

---

### [00:10:06] Lenny

**English:**
What startup was that?

**中文翻译:**
那是哪家公司？

---

### [00:10:06] Arielle Jackson

**English:**
It was called Cover. They were acquired by Twitter. It was an Android app that could get you the right apps at the right time based on where you were by changing the lock screen on your phone. And so that company and that experience of working at this tiny startup that was seven people, I really liked it. And then they got acquired by Twitter, but I had just left Square. So I decided not to join Twitter with the rest of the team. And instead I just decided I was going to help a bunch of other small startups. And I emailed a few friends from past lives who had small startups, which was like, Hey, I'm not going to Twitter with the rest of the team. You do need marketing help. And every single person wrote back and said, yes. And that's basically how I started consulting.

**中文翻译:**
叫 Cover。后来被 Twitter 收购了。它是一款安卓应用，能根据你所处的位置改变手机锁屏，在正确的时间为你提供正确的应用。我很喜欢在那家 7 人小公司工作的经历。后来他们被 Twitter 收购，但我刚离开 Square 不久，决定不随团队加入 Twitter。相反，我决定去帮助其他一些小初创公司。我给以前认识的几个开初创公司的朋友发了邮件，说：“嘿，我不去 Twitter，你们需要营销方面的帮助吗？”结果每个人都回信说“需要”。这就是我开始做咨询的契机。

---

### [00:10:49] Arielle Jackson

**English:**
I guess it was about eight or nine years ago. At the same time, First Round had reached out and said, hey, who did you use for marketing comps for cover? And I got connected with Brett from First Round and he's like, would you help our companies? And we did a three month project for one day a week, nine years ago. And I'm still there. I work halftime at First Round. So I do everything I do for other companies, but for First Round companies on First Rounds time.

**中文翻译:**
大概是八九年前吧。与此同时，First Round 联系了我，问：“嘿，Cover 的营销对标（comps）你是找谁做的？”然后我联系上了 First Round 的 Brett，他问：“你能帮帮我们的被投公司吗？”九年前，我们开始了一个为期三个月、每周工作一天的项目。结果我一直留到了现在。我现在在 First Round 兼职工作。我为其他公司做的事情，也会在 First Round 的时间里为他们的被投公司做。

---

### [00:11:17] Arielle Jackson

**English:**
So the way it works is if you're funded by First Round and as part of your onboarding, we offer a lot of value add services and I'm one of them. And those services can be everything from, we have someone who's really good at compensation and HR stuff and we have someone who will help you with pricing and I'll help you with marketing. And what that means when you're a seed stage startup is everything from naming to positioning, to developing a brand identity, a website and your initial launch, and eventually hiring a marketer. So that's sort of the bread and butter. That's what I like working on anyway. So it's a good fit because we invest in a lot of seed stage companies at First Round, I get to help almost all of them.

**中文翻译:**
运作方式是这样的：如果你获得了 First Round 的投资，作为入驻流程的一部分，我们会提供很多增值服务，我就是其中之一。这些服务包罗万象：我们有擅长薪酬和 HR 的专家，有帮助制定定价策略的专家，而我负责营销。对于种子轮阶段的初创公司，这意味着从命名、定位、开发品牌标识、建立网站到初始发布，以及最终招聘营销人员。这就是我的核心工作。反正我也喜欢做这些。这非常契合，因为 First Round 投资了很多种子期公司，我几乎能帮到他们所有人。

---

### [00:11:58] Lenny

**English:**
That's an excellent segue to what I wanted to get to next. What I want to do in our chat is cover three broad topics. Things that I know are very near and dear to your heart, naming for products and startups, your brand development framework and how to hire marketers. Does that sound good?

**中文翻译:**
这正好引出了我接下来想聊的话题。在我们的交谈中，我想涵盖三个大主题，这些都是我知道你非常热衷的：初创公司和产品的命名、你的品牌开发框架，以及如何招聘营销人员。听起来怎么样？

---

### [00:12:15] Arielle Jackson

**English:**
Awesome. That's what I like to talk about. So yeah, let's do it.

**中文翻译:**
太棒了。这些正是我喜欢聊的。来吧。

---

### [00:12:19] Lenny

**English:**
Let's do it. Surprise, surprise. Okay. So with naming, I've actually heard from a few founders that you were really helpful to them in naming their startups. Folks that have maybe been on this podcast that will go unnamed. So for founders trying to come up with a name for their company or their product, two questions. What makes a good name for a product or a startup, and then just how do you come up with a great name?

**中文翻译:**
意料之中。好，关于命名，我确实听几位创始人说过，你在帮他们给初创公司起名方面非常有帮助。有些可能上过这个播客的人我就不点名了。对于那些试图为公司或产品起名的创始人，我有两个问题：什么才算是一个好的产品或初创公司名称？以及，如何想出一个伟大的名字？

---

### [00:12:44] Arielle Jackson

**English:**
I love naming. I think I've named just over 30 companies at this point. And actually when I mention how I got into consulting when I emailed some friends and asked them if they needed marketing help, I think I'm allowed to talk about this one. So one of those companies was some friends from Google, Adrian and Carl. They had left Google, gone to Facebook and then started a company it's now called Seesaw. It's an ed tech company. That was the first company I named post Google Square, all of that.

**中文翻译:**
我热爱命名。到目前为止，我大概已经给 30 多家公司起过名字了。其实，当我提到我是如何通过给朋友发邮件开始咨询工作时，我想我可以聊聊这个例子。其中一家公司是我在 Google 的朋友 Adrian 和 Carl 创办的。他们离开 Google 去了 Facebook，然后创办了一家现在叫 Seesaw 的公司。这是一家教育科技公司。那是我离开 Google 和 Square 后命名的第一家公司。

---

### [00:13:09] Lenny

**English:**
It's an awesome name.

**中文翻译:**
那是个很棒的名字。

---

### [00:13:10] Arielle Jackson

**English:**
It is an awesome name and I'll use it as an example. So seesaw is a ed tech company. They had a really bad name before that and we did this whole naming process and ended with that name and why I think that's a good name is when I say Seesaw, you don't really know what it is, but when I tell you, oh, it's this ed tech company and it's an iPad app and it helps the work that elementary school students do go between the teacher, the parents and the student. And you're like, oh, well, Seesaw makes sense for elementary school, it's something that goes back and forth. It has that sort of nostalgic feel. And it makes sense that it's an ed tech company.

**中文翻译:**
确实很棒，我把它当作例子。Seesaw（跷跷板）是一家教育科技公司。他们之前的名字很烂，我们经历了一整套命名流程，最后选定了这个名字。我认为它好的原因是：当我提到 Seesaw 时，你可能不知道它是做什么的，但当我告诉你“哦，这是一家教育科技公司，是一个 iPad 应用，它能帮助小学生在老师、家长和学生之间同步作业”时，你会觉得，“哦，Seesaw 对小学来说很有意义，它是某种来回互动的东西。”它有一种怀旧感，而且作为教育科技公司的名字很合逻辑。

---

### [00:13:48] Arielle Jackson

**English:**
And I personally tend to like those kinds of names that are suggestive or evocative, where when I tell you what the company does, you're like, oh, that makes sense. But it's not that what the name is tells you exactly what the company does. So that's an example, I think of a good name. I don't know, during COVID and when my older son's school was closed and they all used Seesaw and I got to tell my son, oh, that's my friend's company and we named it back in the day. And he was like, oh, that's cool. That name makes sense.

**中文翻译:**
我个人倾向于喜欢那种具有暗示性或启发性的名字，即当我告诉你公司是做什么的时候，你会觉得“哦，有道理”。但名字本身并不会直接告诉你公司到底是做什么的。我认为这就是一个好名字的例子。疫情期间，我大儿子的学校关闭了，他们都用 Seesaw，我告诉儿子：“哦，那是我朋友的公司，当年是我们起的名。”他说：“哦，那很酷，这个名字很有道理。”

---

### [00:14:21] Arielle Jackson

**English:**
That's the reaction you want. It also has a little bit of emotion to it. It has some nostalgia. It's fun to say it's short, it's memorable. I think all of those things make a good name. Another company that has a good name that you and I have both worked with is Maven. So they're a First Round company. Gogan has talked about this publicly. We named that company together. Maven is a Yiddish word that means one who understands and it means specifically one who understands because they've done something, they've acquired the skills or knowledge over time.

**中文翻译:**
这就是你想要的反应。它还带有一点情感色彩，有一点怀旧感。读起来很有趣，简短且好记。我认为这些都是好名字的要素。另一家拥有好名字的公司是我们都合作过的 Maven。他们是 First Round 投资的公司。Gogan 公开谈论过这件事，我们一起给那家公司起的名。“Maven”是一个意第绪语词汇，意思是“行家”或“专家”，特指那些因为亲身实践、随着时间积累了技能或知识而精通某事的人。

---

### [00:14:58] Arielle Jackson

**English:**
And I just think that's such a cool name for a platform that allows X operators or current operators to teach their skills to other people through cohort based classes. You want to be a Maven, instructors are Maven's, it's short, it's easy to say, when I tell you what that company does, that name makes perfect sense. So I tend to like those [inaudible 00:15:17] of names myself, but I also, I don't know, I like other kinds of names for other kinds of products too. I think it really comes down to what is your product? What is your company? What is the name trying to achieve and really getting clearer with those criteria. So we can talk about the criteria that always apply, the criteria you might add and a process to get there.

**中文翻译:**
对于一个允许前任或现任运营者通过“小班制课程”（cohort-based classes）向他人传授技能的平台来说，我觉得这个名字太酷了。你想成为一个 Maven，讲师们也是 Maven。它简短、朗朗上口，当我告诉你公司业务时，这个名字完全说得通。所以我个人偏好这类名字，但我也喜欢针对不同产品的其他类型的名字。我认为这最终取决于你的产品是什么？你的公司是什么？这个名字想要达到什么目的？并明确这些标准。我们可以聊聊通用的标准、你可能增加的特定标准，以及实现这一目标的流程。

---

### [00:15:38] Lenny

**English:**
That sounds great. Yeah. I'm really curious about a process. If one exists, that'd be really cool. So another question in my mind is just some names are just nonsense words like Yahoo and I don't know Google, I guess. What's your take on that as a name, that approach?

**中文翻译:**
听起来很棒。我对流程非常好奇。如果有一套流程，那就太酷了。我脑子里还有一个问题：有些名字纯粹是无意义的词，比如 Yahoo，或者 Google（我想也是）。你对这种命名方式怎么看？

---

### [00:15:51] Arielle Jackson

**English:**
Yeah. So words like that are empty vessels, they really don't mean anything. If you think about the name Yahoo, it's actually like really silly. It's like Yahoo. I always hear it like that. Google has a meaning for people in the know with the one followed by as many zeros. It's like a big number and it's a misspelling of that. So that one's a little less silly to me than Yahoo. My take on empty vessel names is they can be really memorable and they can be evocative of the emotion, but you have to do a lot more marketing work over time to make it mean something.

**中文翻译:**
是的。这类词就像“空容器”（empty vessels），它们本身没有任何意义。如果你想想 Yahoo 这个名字，它其实挺傻的，就像一声欢呼。我听起来总是那种感觉。Google 对知情者来说是有意义的，代表 1 后面跟着很多个 0，是一个巨大的数字，它是那个词的拼写错误。所以对我来说，它比 Yahoo 稍微没那么傻。我对“空容器”类名字的看法是：它们可以非常令人难忘，也能唤起某种情感，但随着时间的推移，你必须投入更多的营销工作才能赋予它具体的含义。

---

### [00:16:25] Arielle Jackson

**English:**
So if I say Yahoo today, we know it's that search engine we use before we all switch to Google and we have the purple color in our head, and we think about what it meant at the time that we might have used it, but it took a lot of marketing dollars and a lot of time for that word to be in that. So they're doable. I worked on a company Eero. That has kind of what is almost an empty vessel name. Eero is for Eero Saarinen who was a designer. He did like these really beautiful buildings, architectural buildings. And then also some tables. You can get a Saarinen and table at Design Within Reach, but that name, nobody knows that unless you're in the design community. And so that name is effectively an empty vessel and they have to spend a lot and be consistent about making that [inaudible 00:17:16] mean a wifi system.

**中文翻译:**
所以如果我今天说 Yahoo，我们知道那是我们在转向 Google 之前使用的搜索引擎，脑子里会出现紫色，会想到我们使用它时的意义。但这花费了大量的营销资金和时间才让这个词深入人心。所以这种方式是可行的。我曾为 Eero 公司工作过，它的名字几乎就是一个“空容器”。Eero 是为了纪念设计师 Eero Saarinen，他设计了一些非常漂亮的建筑，还有一些桌子。你可以在 Design Within Reach 买到 Saarinen 的桌子。但除非你在设计圈，否则没人知道这个。所以这个名字实际上就是一个空容器，他们必须投入大量资金并保持一致性，才能让这个词代表一个 WiFi 系统。

---

### [00:17:17] Lenny

**English:**
I want to get to the process, but another question is why is it important for the name to kind of connect to the company and what they do? Is that just it feels nice to people or is there some kind of a bigger reason?

**中文翻译:**
我想聊聊流程，但另一个问题是：为什么名字与公司及其业务建立某种联系很重要？仅仅是因为让人感觉舒服，还是有更深层的原因？

---

### [00:17:30] Arielle Jackson

**English:**
Yeah. So it doesn't have to, and examples like Eero and Yahoo, it doesn't. Even if you think about Apple, it doesn't. Apple has nothing to do with Apple computers. It's a word we all know. There's a lot of words where there's no meaning behind it. If there is a meaning behind your name, your name is doing a little bit more of your marketing work for you. So if your name is Internet Explorer, RIP, I know exactly what you do.

**中文翻译:**
是的，其实并不一定要有联系，像 Eero 和 Yahoo 就是例子。即使是 Apple，苹果和电脑也没什么关系。那只是一个我们都认识的词。有很多名字背后并没有深意。但如果你的名字背后有含义，那么名字就在为你分担一部分营销工作。如果你的名字叫 Internet Explorer（愿它安息），我一眼就知道你是做什么的。

---

### [00:17:56] Arielle Jackson

**English:**
If your name is Chrome and you're a designer on the web, you kind of might be like, oh, that makes sense. That's the area around the browsing window. If your name is Firefox, I have no idea what you did. You just took two words and put them together and made something up. And now you have to spend, and you have to be consistent over time in making that word mean something for people. But all three of those browsers were successful at a time. And I don't think the name had anything to do with Internet Explorer's demise.

**中文翻译:**
如果你的名字叫 Chrome，而你是一名网页设计师，你可能会觉得：“哦，有道理，那是浏览器窗口周围的区域。”如果你的名字叫 Firefox，我完全不知道你是干嘛的。你只是把两个词拼在一起，凭空造了一个词。现在你必须投入精力，并长期保持一致，才能让这个词对人们产生意义。但这三款浏览器在当时都很成功。而且我不认为名字与 Internet Explorer 的没落有任何关系。

---

### [00:18:25] Lenny

**English:**
Got it. So it's kind of ideally you can find an easy mode. If that doesn't work, then you go hard mode. You come up with your empty vessel name and then you just have to do a lot of work.

**中文翻译:**
明白了。所以理想情况下你可以找个“简单模式”。如果不行，那就选“困难模式”：起一个“空容器”名字，然后你得做大量的工作。

---

### [00:18:33] Arielle Jackson

**English:**
That's my personal preference.

**中文翻译:**
那是我的个人偏好。

---

### [00:18:35] Lenny

**English:**
Okay, cool. That makes sense.

**中文翻译:**
好，有道理。

---

### [00:18:37] Arielle Jackson

**English:**
My personal preference is if you think about there's descriptive names, the Internet Explorer, there's suggestive names like Chrome, then there's evocative names, which I would say Seesaw and Maven fit into there where they're like in between suggestive and evocative, and then there's empty vessel names or fanciful names. There's a spectrum. And when you do your brainstorm, we can talk about this in the process, you want to think across all of them, but you might have in your naming brief, we want a suggestive name, or we want a descriptive name. You might go into it with that. And so there's times and places for all of those names across the spectrum. My personal bias is I tend to like suggestive names.

**中文翻译:**
我的个人偏好是这样的：名字可以分为描述性名字（如 Internet Explorer）、暗示性名字（如 Chrome）、启发性名字（我觉得 Seesaw 和 Maven 介于暗示和启发之间），最后是“空容器”名字或臆造的名字。这是一个光谱。当你进行头脑风暴时（我们待会聊流程），你会考虑光谱上的所有类型。但在你的命名简报（naming brief）中，你可能会说“我们想要一个暗示性的名字”或“我们想要一个描述性的名字”。你可以带着这个目标开始。光谱上的每种名字都有其适用的时间和场合。我的个人偏好是倾向于暗示性的名字。

---

### [00:19:16] Lenny

**English:**
Makes sense. Okay, let's get into it. What should teams do when they're trying to name something?

**中文翻译:**
有道理。好，让我们进入正题。团队在尝试命名时应该怎么做？

---

### [00:19:22] Arielle Jackson

**English:**
Yeah. So the first thing is to do your product positioning. I really believe that positioning dictates so much of your marketing and should always be the first thing you do. I had a student in my last class that I taught through Maven. I teach a class on brand strategy and he was I think a second or third time founder, who had never taken a class on brand strategy. He worked really hard. He was awesome. Anyway, at the end of the class and you kind of do this closing thing. And he goes, I'll never write a line of code without doing positioning first. And that was music to my ears. I think positioning comes first, but in any case, you do that first, and we'll talk about that in a little bit. And then you write a naming brief and it's really simple.

**中文翻译:**
好的。第一件事是做产品定位。我坚信定位决定了你大部分的营销工作，应该永远是第一步。在我上一期 Maven 课程中（我教品牌战略课），有一个学生，我想他是第二次或第三次创业的创始人，以前从未上过品牌战略课。他非常努力，表现很棒。总之，在课程结束的总结环节，他说：“我以后再也不会在没做定位之前写一行代码了。”这对我来说简直是天籁之音。我认为定位先行。总之，先做定位（我们稍后会聊），然后写一份命名简报，这非常简单。

---

### [00:20:07] Arielle Jackson

**English:**
What are you naming? Are you naming a company? Are you naming the product? Are you naming both? Usually if you're early stage company, you're naming both and they're going to have one name because you don't want people to have to remember two things. What do you want the name to communicate? So in that example of Seesaw, we wanted it to communicate young childhood. In the example of Eero, we wanted it to communicate design, being designed forward. It can be whatever you want it to communicate. What do you want to avoid? We don't want it to sound like this competitor, or we hate this word or whatever you want to avoid. What are the names of competitive and related products? And then are there other considerations? I worked with another First Round company that was operating in China.

**中文翻译:**
你要命名的是什么？是公司名？产品名？还是两者都有？通常如果你是早期公司，你会同时命名两者，并且共用一个名字，因为你不想让人们记住两件事。你希望这个名字传达什么？比如 Seesaw，我们希望它传达“童年”；比如 Eero，我们希望它传达“设计感”和“设计领先”。它可以是任何你想要传达的东西。你想避开什么？比如“我们不想听起来像某个竞争对手”，或者“我们讨厌这个词”。竞争对手和相关产品的名字是什么？还有其他考虑因素吗？我曾与另一家在海外运营的 First Round 公司合作。

---

### [00:20:53] Arielle Jackson

**English:**
And one of the considerations was this has to be pronounceable for a native Chinese speaker. That's a very valid, additional consideration. And then there are seven criteria for names that always apply in my opinion. And you could add additional ones, like that Chinese speaking one would be an additional one. The seven are trademark, which is kind of obvious, can you use this? Are you violating someone else's trademark? And the second step with trademark is, do you need to proactively protect the name? Domain availability, so everyone gets hung up on getting a.com like maven.com got maven.com. It was an arduous process that Gogan wrote about on Twitter. But these days, you don't necessarily need the.com. Square operated on SquareUp for very, very long time. Lots of companies are operating on variants of a .com. So domain availability, distinctiveness. Is it memorable?

**中文翻译:**
其中一个考虑因素是：这个名字必须让母语为中文的人也能发音。这是一个非常合理的额外考虑因素。此外，我认为有七个通用的命名标准。你可以添加额外的标准，比如刚才说的发音问题。这七个标准是：1. 商标（Trademark），这很显而易见，你能用吗？是否侵犯了他人的商标？第二步是，你是否需要主动保护这个名字？2. 域名可用性（Domain availability），大家总是纠结于要拿到 .com，比如 Maven 拿到了 maven.com，那是 Gogan 在 Twitter 上写过的一个艰辛过程。但现在，你并不一定非要 .com。Square 曾长期使用 SquareUp。很多公司都在使用 .com 的变体。3. 独特性（Distinctiveness），它好记吗？

---

### [00:21:51] Arielle Jackson

**English:**
Is it sound like someone else's name? That's I think one of the most important ones, just is it different and distinctive? Is it timeless? So there's a lot of naming trends. If you tell me Optimizely I could tell you what year was the company formed when it ends in LY. If you tell me a word like Flicker, I can tell you what year it was, because that was the naming trend to remove vowels. So I generally stay away from naming trends, because I want your company named not to sound dated in 10 or 20 years. The last one is it's kind of related to that. What we talked about in the brief, what do you want the name to communicate? Which is the name reflective of your key messaging or does it somehow suggest an emotion or feeling that you're trying to convey, and then sound and ease of pronunciation.

**中文翻译:**
它听起来像别人的名字吗？我认为这是最重要的标准之一，即它是否与众不同且具有独特性。4. 永恒性（Timelessness），命名有很多趋势。如果你告诉我 Optimizely，看到以 LY 结尾，我就能猜出它是哪年成立的。如果你告诉我 Flicker 这种词，我也能猜出年份，因为那是去掉元音的命名趋势。所以我通常避开命名趋势，因为我不希望你的公司名字在 10 或 20 年后听起来很过时。5. 传达力，这与简报有关：名字是否反映了你的核心信息，或者是否暗示了你想要传达的情绪或感觉。6. 声音和易读性（Sound and ease of pronunciation）。

---

### [00:22:44] Arielle Jackson

**English:**
Is it fun to say, is it easy to say, how is it to spell? We almost named a First Round company a while ago Lattice which is now a different company that's doing quite well, but we didn't name it that because this was a company that was B2B sales was going to be their main channel. So they're going to be people on the phone being like, hey, I'm calling from Lattice and we went through this exercise and we're like lettuce? It's not so easy to say and spell. So we actually didn't name the company that and went with something else. But there's a company now doing quite well.

**中文翻译:**
读起来有趣吗？容易读吗？好拼写吗？不久前我们差点给一家 First Round 的公司起名叫 Lattice（格子），现在有另一家叫这个名字的公司发展得很好。但我们当时没用这个名字，因为那家公司的主要渠道是 B2B 销售。销售人员得在电话里说：“嘿，我是 Lattice 的。”我们模拟了一下，感觉听起来像“生菜”（lettuce）？它没那么容易读和拼。所以我们最终没用那个名字，选了别的。不过现在确实有一家叫 Lattice 的公司做得很好。

---

### [00:23:16] Lenny

**English:**
You think that was the right move?

**中文翻译:**
你觉得那是正确的决定吗？

---

### [00:23:18] Arielle Jackson

**English:**
I don't know. I always say a good name is only going to help you, but a bad name won't hurt a good company. So I don't really feel-

**中文翻译:**
我不知道。我总是说，一个好名字只会锦上添花，但一个烂名字不会伤害一家优秀的公司。所以我并不觉得——

---

### [00:23:25] Lenny

**English:**
Interesting. Good to know. Yeah. Keep going.

**中文翻译:**
有趣。很有参考价值。好，请继续。

---

### [00:23:27] Arielle Jackson

**English:**
And then the last two are appearance. So there are some names that just lend themselves really nicely to visual design and they have to do with how tall the letters are and is their symmetry and if you give this to designer, making a logo just so awesome and cool and fun and then length. So a lot of people, they want to name like Square and Stripe and these one syllable names, but a two syllable or even a three syllable name can often be more memorable.

**中文翻译:**
最后两点是：7. 外观（Appearance），有些名字天生就适合视觉设计，这与字母的高度、对称性有关，如果交给设计师，能做出非常棒、酷炫且有趣的 Logo。最后是长度（Length）。很多人想取像 Square 或 Stripe 这种单音节的名字，但双音节甚至三音节的名字往往更容易让人记住。

---

### [00:23:57] Lenny

**English:**
lennysnewsletter.com. Shoot.

**中文翻译:**
lennysnewsletter.com。哎呀。

---

### [00:24:00] Arielle Jackson

**English:**
Yeah. Well, so you got the Lenny part with the two syllables is generally a nice sweet spot.

**中文翻译:**
哈哈，你名字里的 Lenny 是两个音节，这通常是一个很棒的平衡点。

---

### [00:24:07] Lenny

**English:**
Sweet. Have you put out a template or anything that folks can find to do this? Or should they kind of listen here and take notes?

**中文翻译:**
太好了。你有没有发布过模板之类的东西供大家参考？还是他们应该在这里听然后记笔记？

---

### [00:24:15] Arielle Jackson

**English:**
Yeah, there's an article on the First Round review called Positioning Your Startup is Vital, Here's How to Nail It and all those criteria and how to do naming is actually in that article.

**中文翻译:**
有的，First Round Review 上有一篇文章叫《初创公司定位至关重要，教你如何搞定》（Positioning Your Startup is Vital, Here's How to Nail It），所有的标准和命名方法都在那篇文章里。

---

### [00:24:27] Lenny

**English:**
Awesome. We'll put that in our little show notes. And then as you go through this, is this a binary thing or you kind of rate each of these categories one to five?

**中文翻译:**
太棒了。我们会把它放在节目介绍里。当你审核这些标准时，它是非黑即白的，还是你会给每个类别打 1 到 5 分？

---

### [00:24:36] Arielle Jackson

**English:**
Yeah. So the way I do it is I apply the criteria after we do the brainstorm. And then we do red, yellow, green on each of those criteria just to weed out ones that are not doing well on any of those. Got it. And then you add your own criteria. So the next steps the brainstorm. I'm going to go fast through this.

**中文翻译:**
是的。我的做法是在头脑风暴之后应用这些标准。然后我们对每个标准进行“红、黄、绿”灯评级，以此剔除那些在任何标准上表现都不佳的名字。明白了。然后你可以添加自己的标准。接下来的步骤是头脑风暴。我会快速讲一下。

---

### [00:24:55] Lenny

**English:**
Yeah. I was going to ask you about the brainstorm. I'm excited to hear this.

**中文翻译:**
对，我正想问头脑风暴的事。我很期待。

---

### [00:24:57] Arielle Jackson

**English:**
Yeah. So the way that I run a naming process is I like to first do positioning and then I set up an hour with the founders and me and ideally a couple other people who are interested, but disinterested. So I'll bring a writer from the First Round team or the founder has a friend who's a linguist or the founder has a friend who speaks four languages. We like those kind of people to be in it if possible. And it's generally five to seven people in a brainstorm. And the idea is we spend one hour, I set it up beforehand and we try to come up with hundreds and hundreds of bad ideas and a couple decent ones that are worth exploring more. And the brainstorm is two parts. The first part is based on words in your positioning statement.

**中文翻译:**
好的。我运行命名流程的方式是：首先做定位，然后安排一个小时，参与者包括创始人和我，理想情况下还有几个“感兴趣但无利益相关”的人。比如我会带一个 First Round 团队的文案，或者创始人有个语言学家朋友，或者会说四种语言的朋友。如果可能，我们喜欢这类人参与。通常头脑风暴有 5 到 7 人。核心理念是：我们花一个小时（我会提前准备好），尝试想出成百上千个烂主意，以及几个值得进一步探索的体面主意。头脑风暴分为两部分。第一部分基于你定位声明（positioning statement）中的词汇。

---

### [00:25:40] Arielle Jackson

**English:**
So we take all the meaningful words out of your positioning statement is the warmup and we run synonyms, antonyms, free associations, other languages, whatever we can do off of those words. And so if your words in your positioning statement are related to what that you do, which they very well should be, that's a great way to just come up with hundreds of words really quickly. And then the second step is a thematic brainstorm. So I pick between seven and 10 themes, you can think of them like Jeopardy themes. So it's like, I don't know, okay, so there was an-

**中文翻译:**
作为热身，我们从你的定位声明中提取所有有意义的词，然后针对这些词寻找同义词、反义词、自由联想、其他语言的对应词，尽我们所能进行发散。如果定位声明中的词与你的业务相关（理应如此），这是快速产生数百个词的好方法。第二步是主题式头脑风暴。我会挑选 7 到 10 个主题，你可以把它们想象成《危险边缘》（Jeopardy）游戏里的主题。比如，我不知道，好吧，比如有一个——

---

### [00:26:11] Lenny

**English:**
Source.

**中文翻译:**
来源。

---

### [00:26:11] Arielle Jackson

**English:**
... AI. Yeah. It was like an AI tool for strawberry picking and the themes would be the history of strawberry farming or botany 101, things that are related. You could do like last names of famous farmers, think about how did Tesla get their name? They probably did last names of people related to electricity, and that's such a great name, so thematic brainstorm. And then that's usually a little more fruitful. And we do the same thing, free association, all that.

**中文翻译:**
……AI。对。比如一个用于采摘草莓的 AI 工具，主题可能是“草莓种植史”或“植物学入门”等相关内容。你可以找著名农民的姓氏。想想特斯拉（Tesla）是怎么得名的？他们可能是找了与电相关的名人的姓氏，那是个非常棒的名字。这就是主题式头脑风暴，通常更有成效。我们做同样的事：自由联想等等。

---

### [00:26:40] Arielle Jackson

**English:**
I spend some time afterwards on Wikipedia and the internet and actually finding words words. Also love the library, check out books sometimes and just read books on the topic and just write down the interesting words that come up. And anyway, so then I give them back a short list. The short list is around 10 to 25 concepts that are ideas that are worth looking at further. And from there narrow it down based on the criteria and the red, yellow, green, we come up with three to five, don't come up with one because you might not get it for trademark, and it's really sad when you get really attached to one and then you can't use it. So yeah, three to five top contenders. And then you go through trademark process domain and kind of go from there.

**中文翻译:**
之后我会花时间在维基百科和互联网上查找具体的词汇。我也喜欢图书馆，有时会借书，阅读相关主题的书籍，记下有趣的词。总之，最后我会给他们一个短名单。短名单大约包含 10 到 25 个值得进一步研究的概念。然后根据标准和“红黄绿”评级进行筛选，最终选出 3 到 5 个。不要只选一个，因为你可能拿不到商标，如果你特别迷恋某一个却不能用，那会很令人难过。所以，选出 3 到 5 个顶级候选，然后走商标和域名流程，以此类推。

---

### [00:27:23] Lenny

**English:**
That was amazing. If you're doing a startup name versus a product, is the process any different or is it basically the same?

**中文翻译:**
太棒了。如果是给初创公司起名和给产品起名，流程会有所不同吗？还是基本一样？

---

### [00:27:29] Arielle Jackson

**English:**
No, same. The only difference is if you have a lot of equity in your company name... Square is a good example. Square had a lot of equity. Google is a perfect example. A lot of equity in the company name, you often don't want to name your products something really creative and different because you actually want the equity in the master brand to come through. So if you think about Square's names, they have other ones, when they diverge from the Square brand like cash or when they want something new or Google, when they came out with Android and they wanted to diverge from the master brand. But think about all the products. Square Register, Square Stand, Square App, Google Maps, they're really boring and it's because the equity is in the company name and the product name can actually be boring and descriptive.

**中文翻译:**
不，是一样的。唯一的区别是，如果你的公司名称已经积累了大量的品牌资产（equity）……Square 就是个好例子，Square 拥有很高的品牌价值。Google 也是完美的例子。当公司名拥有极高品牌资产时，你通常不想给产品起一个非常有创意且截然不同的名字，因为你希望母品牌的价值能传递下去。想想 Square 的名字，当他们偏离 Square 品牌时（比如 Cash App），或者想要新东西时；或者 Google 推出 Android 时，他们想要偏离母品牌。但看看其他产品：Square Register、Square Stand、Square App、Google Maps，它们都很无聊，这是因为品牌资产在公司名里，产品名其实可以很无聊且具有描述性。

---

### [00:28:20] Lenny

**English:**
That makes sense. I want to come back to a point you made that a great name will help a startup and a bad name is not going to hurt you or I forget the word to use. I'd love to hear that because that's that's really interesting.

**中文翻译:**
有道理。我想回到你之前说的一点：一个伟大的名字会帮助初创公司，而一个烂名字不会伤害你（或者我不记得你用的词了）。我很想听听这个，因为这真的很有趣。

---

### [00:28:33] Arielle Jackson

**English:**
Yeah. So if your company has a great name and the name is remarkable, people will be like, oh, that's a great name, or it just makes sense. In the case of Seesaw like, that's a good name for that company. That good name is just going to help people talk about it. It's going to spread word of mouth. People are going to like to talk about the company. If you think about there's a lot of companies with bad names that we use all the time or even quite boring names that we now love. So if you think about Disney, Walt Disney's last name, it didn't mean anything, but over time that's such a good company and it got imbued with all this meaning and now it stands for magic and stands for so much, but it was just the dude's last name. So over time a word can come to mean something that is beyond what that actual word means.

**中文翻译:**
是的。如果你的公司有一个伟大的名字，而且这个名字很出众，人们会说：“哦，那是个好名字”，或者觉得它很合理。比如 Seesaw，对那家公司来说就是个好名字。好名字会帮助人们谈论它，促进口碑传播。人们会喜欢谈论这家公司。但如果你想想，有很多名字很烂的公司我们一直在用，甚至有些现在我们很喜欢的名字其实很无聊。想想迪士尼（Disney），那是华特·迪士尼的姓氏，本身没有任何意义。但随着时间的推移，这是一家如此优秀的公司，它被赋予了所有的意义，现在它代表着魔幻，代表着很多东西，但最初它只是那个人的姓。所以随着时间的推移，一个词所代表的含义会超越它本身的字面意思。

---

### [00:29:21] Arielle Jackson

**English:**
Disney means magic today. Volvo means safety. Those names are not good. If I just put it in a spreadsheet or one of those lists, no one would pick it. So that's kind of what I mean, that the name is just part of the overall marketing or the overall brand and a bad name with a really great company with great company strategy, great marketing is going to be great over time. And a good name is just going to help you, but I don't think a bad name is going to kill a good company.

**中文翻译:**
今天迪士尼意味着魔幻，沃尔沃意味着安全。这些名字本身并不好。如果我把它们放在电子表格里，没人会选。所以我的意思是，名字只是整体营销或整体品牌的一部分。一个烂名字配上一家拥有伟大战略和营销的伟大公司，随着时间的推移也会变得伟大。好名字只是助力，但我认为烂名字不会毁掉好公司。

---

### [00:29:51] Lenny

**English:**
So interesting. So basically your goal is to help find a name that will help. Worst case, you're going to be okay if your product is awesome.

**中文翻译:**
太有趣了。所以基本上你的目标是帮助找到一个能提供助力的名字。最坏的情况下，只要你的产品很棒，你也会没事的。

---

### [00:29:59] Arielle Jackson

**English:**
I think so. Yeah. I mean it also takes a little of the pressure off to be honest. Everyone wants to find that perfect name. If you actually think about it, this happens a lot. You give someone a list of 10 names or 15 names and they're just cells in the spreadsheet these days, we're doing most of this virtually. You give people a name like that and it's like, you have to imagine what it could be. You think about Apple or Disney or Nike or Volvo, Lego, any of these brands, in a cell spreadsheet in plain Arial in 10 point, they're just okay, you have to grow them over time. You just hear about I think Phil Nate with Nike, when he was given that name as an option, he was like, that's okay. Yeah. I'll sleep on it. Such a great name.

**中文翻译:**
我想是的。说实话，这也能减轻一点压力。每个人都想找到那个完美的名字。但如果你仔细想想，这种情况经常发生：你给某人一份包含 10 到 15 个名字的名单，现在大多是虚拟操作，它们只是电子表格里的单元格。你给人们看那样的名字，他们必须去想象它可能变成什么样。想想 Apple、Disney、Nike、Volvo、Lego，这些品牌如果只是放在表格里，用 10 号 Arial 字体显示，它们也就那样。你必须随着时间的推移去培育它们。我听说 Nike 的菲尔·奈特（Phil Knight）最初拿到这个名字作为选项时，他的反应是：“还行吧，我考虑考虑。”结果现在成了如此伟大的名字。

---

### [00:30:50] Lenny

**English:**
This makes me think about my startup back in the day, it was called Local Mind, and we went through an exercise similar to this. Not nearly as in depth and well run, but I remember our designer was the person that helped us nail the name. He's just like, oh, I could do so much with this name. Let's just see where this one can go. Is that something you find?

**中文翻译:**
这让我想起我当年的初创公司，叫 Local Mind。我们也经历过类似的练习，虽然远没有这么深入和规范。但我记得是我们的设计师帮我们敲定了名字。他当时说：“哦，这个名字我可以发挥的空间很大。让我们看看它能发展到什么程度。”你也有这种发现吗？

---

### [00:31:10] Arielle Jackson

**English:**
Yeah. There's definitely been bad names. I helped a company rebrand recently that they had a bad name. It just looked dated. It didn't fit any of those. It wasn't distinctive. It wasn't timeless. It had one of those like naming trends. Those are not good. You want to avoid those, but if you come up with something that is pretty good and you can make up something beautiful out of it and it fits your company, it does some of the marketing work for you and people like to say it and ideally it's memorable and it has some emotion to it, go, go for it.

**中文翻译:**
是的。确实存在烂名字。我最近帮一家公司做品牌重塑，他们的名字就很烂。看起来很过时，不符合任何标准。不独特，不永恒，还带着某种命名趋势。那些都不好，你应该避开。但如果你想出一个还不错的名字，并且能围绕它创造出美好的东西，而且它契合你的公司，它就能为你分担营销工作。如果人们喜欢读它，理想情况下它好记且带有情感色彩，那就大胆去用吧。

---

### [00:31:39] Lenny

**English:**
Awesome. One last question about naming. What's a common mistake that people make going through this process coming up with a name?

**中文翻译:**
太棒了。关于命名最后一个问题：人们在起名过程中常犯的错误是什么？

---

### [00:31:47] Arielle Jackson

**English:**
Yeah, a really funny one is if you have a code name for your product or at First Round, a lot of the companies we invest in, they raise their seed round with one name. They may or may not be attached to it, but then they work with me and I'm like, yeah, your name's not that good, and here's why, we should probably change it or they say, we can't use this name. We found out we have a trademark conflict. I really believe in using a code name that's so ridiculous that you won't ever launch a product like that if you're just trying to incorporate and go really quick.

**中文翻译:**
有个很有趣的错误是关于“代号”的。在 First Round，我们投资的很多公司在种子轮融资时用的是一个名字。他们可能对这个名字有感情，也可能没有。但当他们跟我合作时，我会说：“是的，你的名字不太好，原因如下，我们可能得改改。”或者他们发现有商标冲突不能用。我非常主张使用一个极其荒谬的代号，荒谬到你绝不会用它来发布产品，如果你只是为了快速注册公司的话。

---

### [00:32:18] Arielle Jackson

**English:**
So for example, a lot of people, they need their name for their corporation. And so they are filing all the steps to creating a business and they just like pick something, but then they end up getting attached to it and then they want to actually launch under that name. And it's like, well, that's not so great and here's why I think you should change it. If you pick something so ridiculous that you would never launch, it's actually helpful because then you can go through a process and find a name that will do more of your work for you and you won't be attached to something crappy.

**中文翻译:**
例如，很多人需要一个公司名来注册。在办理各种手续时，他们就随便选了一个。但最后他们对这个名字产生了感情，想用它正式发布。这时我会说：“嗯，这名字不太好，这就是为什么我认为你应该改掉它。”如果你选一个荒谬到绝不可能发布的代号，反而更有帮助，因为这样你就能静下心来走流程，找一个能为你分担工作的名字，而不会迷恋上一个烂名字。

---

### [00:32:50] Lenny

**English:**
Such a good point an idea. And by the way, so if you're a First Round company, you get this naming service for free and all these other things we're going to talk about just to be clear.

**中文翻译:**
非常有见地的观点。顺便说一下，如果你是 First Round 投资的公司，你可以免费获得这种命名服务，以及我们接下来要聊的所有其他服务，对吧？

---

### [00:32:59] Arielle Jackson

**English:**
Yes, that's right.

**中文翻译:**
是的，没错。

---

### [00:33:00] Lenny

**English:**
Oh my God. I could do a whole episode about how much I love First Round, but I will say I'm a huge fan. I think I've participated in every program that First Round offers. The First Round review is actually one of the first pieces of writing that kind of helped spur my now career. And so I'm really-

**中文翻译:**
天哪。我可以专门做一期节目来聊我有多爱 First Round。我是他们的超级粉丝。我想我参加过 First Round 提供的每一个项目。First Round Review 实际上是最初激励我开启现在职业生涯的文章之一。所以我真的——

---

### [00:33:15] Arielle Jackson

**English:**
I remember that article, was awesome.

**中文翻译:**
我记得那篇文章，写得太棒了。

---

### [00:33:17] Lenny

**English:**
Yeah. And I did two more after that. So much work, but yeah, that was a big deal. So I'm really appreciative to First Round. And we could talk about First Round a bit at the end, too.

**中文翻译:**
是的，在那之后我又写了两篇。工作量巨大，但确实意义非凡。所以我非常感激 First Round。我们最后也可以再聊聊 First Round。

---

### [00:33:26] Arielle Jackson

**English:**
Sure. Yeah. Everything we're talking about that you've asked me so far, I think that you're going to ask me about positioning and [inaudible 00:33:33] your marketing person, and all of that is stuff we offer to First Round company, we offer my services as part of the investment. There are times when we might get stuck and we have to bring in an outside person to help us with something, but for the most part, it's all included and you'd pay a lot of money... The naming firm I like the best when I get stuck, it's called A Hundred Monkeys. They're awesome. A long time ago, I used to be like, oh yeah, it's about $25,000. And I recently couldn't take on an outsider First Round project and referred it to them. It's $47,000 for a name.

**中文翻译:**
当然。到目前为止你问我的所有内容，包括你接下来要问的定位、招聘营销人员等等，都是我们为 First Round 投资的公司提供的服务。我的服务是投资的一部分。有时我们可能会遇到瓶颈，需要引入外部人员帮忙，但大部分情况下都是包含在内的。如果你自己去找，得花很多钱……当我遇到瓶颈时，我最喜欢的命名公司叫 A Hundred Monkeys。他们非常棒。很久以前，我记得价格大约是 2.5 万美元。最近我没法接一个非 First Round 的项目，就把他们推荐了过去，现在起一个名字要 4.7 万美元。

---

### [00:34:04] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:34:05] Arielle Jackson

**English:**
So yeah, it's gotten expensive, but if you have the means, it's nice to get some outside help.

**中文翻译:**
所以是的，价格变贵了。但如果你有财力，找外部专家帮忙是很不错的。

---

### [00:34:12] Lenny

**English:**
#valueadd. Okay. I want to transition to your brand development framework, which I read a bunch about. And I know you teach a course about this, which we could also chat a bit about, but first I'm curious, just practically, why is a brand useful? Why is it even something people should spend time investing in? Why does it matter?

**中文翻译:**
这就是“增值服务”。好，我想转向你的品牌开发框架，我读过很多相关内容。我知道你有一门关于这个的课程，我们也可以聊聊。但首先我很好奇，从实际角度来看，品牌为什么有用？为什么人们应该花时间投资品牌？它为什么重要？

---

### [00:34:33] Arielle Jackson

**English:**
Okay. So a lot of founders may think that when we say your brand, we mean your logo and your font and your colors, and that is a visual expression of your brand, but it's not actually your brand, your brand is who people think you are. And so why is it important for people to think what you want them to think? That really comes down to people's understanding and particularly your target audience's understanding of what your company and your product is. And I don't really think there's anything else more important than that if I was building a company.

**中文翻译:**
好的。很多创始人可能认为，当我们说“品牌”时，指的是 Logo、字体和颜色。那些只是品牌的视觉表达，并不是品牌本身。你的品牌是“人们认为你是谁”。那么，为什么让人们按照你希望的方式去思考很重要呢？这归结为人们（尤其是你的目标受众）对你的公司和产品的理解。如果我要创办一家公司，我认为没有什么比这更重要的了。

---

### [00:35:08] Arielle Jackson

**English:**
So your brand is who people think you are and developing a brand strategy is what do you want to be? What do you want people to think you are? And what are you going to do to help shape that perception? So when I work on a company, there's a lot of steps to this, but I kind of have this nice little process that's right sized for early stage startups. And I like to start with, why do you do what you do? Just having a really clear understanding of that. That's your purpose. The second part is your product positioning. So meaning how do you want people to understand your product and what role it plays in their lives? And then the last part is your personality, which is how do you show up in the world? What do you like? If your brand was a person, would I want to hang out with them? Would someone else want to hang out with them?

**中文翻译:**
所以你的品牌是“人们认为你是谁”，而制定品牌战略则是“你想成为谁？”“你希望人们认为你是谁？”以及“你将采取什么行动来塑造这种认知？”当我为一家公司工作时，虽然有很多步骤，但我有一套适合早期初创公司的精简流程。我喜欢从“你为什么做你正在做的事？”开始，即明确你的“使命”（Purpose）。第二部分是“产品定位”（Product Positioning），即你希望人们如何理解你的产品，以及它在他们的生活中扮演什么角色？最后一部分是“个性”（Personality），即你在世界上呈现出的形象。你像什么样的人？如果你的品牌是一个人，我会想和他一起玩吗？别人会想和他一起玩吗？

---

### [00:36:02] Lenny

**English:**
We're going to get into each of these three pieces, but before we get in there, as a founder, how do you know when you're done with your brand development? I know it's a never ending ongoing process, but at the end of a process, you figure out your purpose, positioning, and personality, and then there's logo and colors, when you think about just here's the brand package, what are all the little pieces of it? And then we'll dive into these three elements.

**中文翻译:**
我们会深入探讨这三个部分。但在那之前，作为创始人，你如何知道品牌开发什么时候算“完成了”？我知道这是一个永无止境的过程，但在一个阶段性流程结束时，你确定了使命、定位和个性，然后有了 Logo 和颜色。当你想到“品牌包”时，它包含哪些具体组成部分？然后我们再深入探讨这三个要素。

---

### [00:36:30] Arielle Jackson

**English:**
I think what you said is right. You get those three components, your purpose, your positioning, your personality, you use that as an informant to your visual design and also to your tone of voice. So the way your copy sounds, the way you show up in written copy. A lot of companies have what they call like a style guide or a brand style guide and it really only covers logo, fonts, colors, like don't put our logo and blue, don't tilt it on an angle, here's what it looks like in white, here's what it looks like in black, here's the favicon, but they don't have that for here's who we are, here's 10 lines that could be ad copy for us, here is why we do what we do.

**中文翻译:**
我觉得你说得对。你确定了这三个组成部分：使命、定位、个性，然后用它们来指导视觉设计和“语气”（tone of voice）。也就是你的文案听起来是什么感觉，你在文字中呈现的形象。很多公司都有所谓的“风格指南”或“品牌风格指南”，但通常只涵盖 Logo、字体、颜色，比如“不要把 Logo 设为蓝色”、“不要倾斜”、“白色背景下长这样”、“黑色背景下长这样”、“这是网站图标”。但他们没有关于“我们是谁”、“10 句可以作为广告语的话”、“我们为什么做这些”的内容。

---

### [00:37:14] Arielle Jackson

**English:**
This is the personality of our brand. Here are five attributes. We are playful, but not silly. We can talk about that a little bit more. But I think all of that belongs in the style guide, not just logo, font colors, which is really just a visual articulation that feeds into your brand. I'm a big Volvo fan. I'm on my fourth Volvo right now. So I'm super brand loyal. And I always use them as an example, because if you can picture the Volvo logo in your head right now, it kind of looks like the male symbol, it's like a circle with an arrow coming off the side.

**中文翻译:**
这就是我们品牌的个性。这里有五个属性。我们“风趣但不愚蠢”。我们可以再多聊聊这个。但我认为所有这些都应该属于风格指南，而不仅仅是 Logo、字体和颜色，后者其实只是支撑品牌的视觉表达。我是沃尔沃的铁杆粉丝，现在开的是我的第四辆沃尔沃，所以我对品牌非常忠诚。我总是拿他们举例，因为如果你现在脑海中浮现出沃尔沃的 Logo，它看起来有点像男性的符号，一个圆圈侧面带个箭头。

---

### [00:37:48] Arielle Jackson

**English:**
There's nothing about that logo that means all the things I like about Volvo, all the things that the Volvo brand has come to mean to me and they're colors, they're like black and white and a little blue. There's nothing more boring than their color palette. And so it's not the logo and the font and the colors of Volvo that has made them mean... They literally own the word safety in cars right now. It's other stuff. And if you looked at their style guide actually, looked at their style guide recently and it's just like, here's our black and our white and our blue and here's our tertiary colors and here's our logo. It would not help you understand Volvo as a brand.

**中文翻译:**
那个 Logo 本身并不能代表我喜欢沃尔沃的所有理由，也不能代表沃尔沃品牌对我意味着什么。他们的颜色是黑、白和一点蓝，没有比这更无聊的配色方案了。所以，并不是沃尔沃的 Logo、字体和颜色让他们成为了……他们现在几乎垄断了汽车领域“安全”这个词。是其他东西造就了这一切。如果你看他们的风格指南（我最近刚看过），里面只有“这是我们的黑白蓝”、“这是辅助色”、“这是 Logo”。它无法帮你理解沃尔沃作为一个品牌。

---

### [00:38:29] Lenny

**English:**
I'm guessing some of that happened because they've evolved over the years and it's probably a very different initial brand. So it kind of tells me that it's more important to have a logo and a brand that can kind of represent many things that isn't so stuck in a certain positioning, maybe. Does that resonate at all?

**中文翻译:**
我猜部分原因是他们多年来一直在进化，最初的品牌形象可能大不相同。所以这是否意味着，拥有一个能代表多种事物、不被局限在特定定位中的 Logo 和品牌更重要？这能引起你的共鸣吗？

---

### [00:38:44] Arielle Jackson

**English:**
Yeah. Their logo has to do with a very early history. I researched this because I was a nerd out on this stuff. They had some early history as a ball bearings company. And so I guess that logo had some meaning then, but it wasn't so descriptive to being a ball bearing company that they were able to keep it as they evolved into a car company.

**中文翻译:**
是的。他们的 Logo 与非常早期的历史有关。我研究过这个，因为我对这些东西很痴迷。他们早期是一家滚珠轴承公司。所以我猜那个 Logo 在当时是有意义的，但它对轴承公司的描述性并不强，所以当他们演变成汽车公司时，依然能保留它。

---

### [00:39:05] Arielle Jackson

**English:**
But if you look at their early writing, it's so cool. It's so cool. Long, long time ago they would talk about cars are driven by humans. And our job as a car manufacturer is to protect the humans who drive the cars. That was fundamental formation of the company. So they really knew why they existed. And then they did stuff in I think it was the 1950s when everyone just wore lap bands in the car and they came out with the three point safety harness and instead of patenting it and licensing it, they gave that away for free for everyone because that would make all the world's cars safer and those kinds of company decisions. That's what made Volvo stand for safety. It's not the logo.

**中文翻译:**
但如果你看他们早期的文案，太酷了。很久以前他们就说：“汽车是由人驾驶的。作为汽车制造商，我们的职责是保护驾驶汽车的人。”那是公司的根基。所以他们非常清楚自己为什么存在。然后在 1950 年代，当时大家都只系腰部安全带，他们发明了三点式安全带，但他们没有申请专利并收取授权费，而是免费提供给所有人，因为这会让全世界的汽车都更安全。正是这类公司决策让沃尔沃代表了安全，而不是 Logo。

---

### [00:39:48] Lenny

**English:**
Very interesting.

**中文翻译:**
非常有趣。

---

### [00:39:50] Lenny

**English:**
This episode is brought to you by Athletic Greens. I've been hearing about AG1 on basically every podcast that I listened to, like Tim Ferris, and Lex Fridman, and so I finally gave it a shot earlier this year and it has quickly become a core part of my morning routine, especially on days that I need to go deep on writing or record a podcast like this. Here's three things that I love about AG1. One with a small scoop that dissolves in water. You are absorbing 75 vitamins, minerals, probiotics and adaptogens. I kind of like to think of it as a safety net for my nutrition in case I've missed something in my diet. Two, they treat AG1 like a software product. Apparently they're on their 52nd iteration and they're constantly evolving it based on latest science research studies and internal testing that they do.

**中文翻译:**
本期节目由 Athletic Greens 赞助。我几乎在听过的每一个播客（比如 Tim Ferriss 和 Lex Fridman）里都听过 AG1，所以我终于在今年早些时候尝试了一下。它迅速成为了我早晨例行活动的核心部分，尤其是在我需要深度写作或录制像这样的播客的日子里。我喜欢 AG1 的三点：1. 只需一小勺溶解在水中，你就能吸收 75 种维生素、矿物质、益生菌和适应原。我把它看作是营养的“安全网”，以防我在饮食中遗漏了什么。2. 他们像对待软件产品一样对待 AG1。显然他们已经迭代到了第 52 版，并根据最新的科学研究和内部测试不断进化。

---

### [00:40:39] Lenny

**English:**
And three, it's just one easy thing that I can do every single day to take care of myself. Right now, it's time to reclaim your health and arm your immune system with convenient daily nutrition. It's just one scoop and a cup of water every day. And that's it. There's no need for a million different pills and supplements to look out for your health. Make it easy. Athletic Greens is going to give you a free one year supply of immune supporting vitamin D and five free travel packs with your first purchase. All you have to do is visit athleticgreens.com/lenny.

**中文翻译:**
3. 这是我每天都能轻松做到的照顾自己的一件事。现在是时候重获健康，用便捷的每日营养武装你的免疫系统了。每天只需一勺粉末和一杯水，就这么简单。不需要为了健康去吃无数种不同的药丸和补充剂。让事情变简单。Athletic Greens 将在你的首次购买中免费赠送一年的免疫支持维生素 D 和五份便携旅行装。你只需访问 athleticgreens.com/lenny 即可。

---

### [00:41:10] Lenny

**English:**
Again, that's athletic greens.com/lenny to take ownership over your health and pick up the ultimate daily nutritional insurance.

**中文翻译:**
再次强调，访问 athleticgreens.com/lenny，掌控你的健康，获取终极每日营养保障。

---

### [00:41:18] Lenny

**English:**
One question on my mind before we get into these three elements, last question kind of setting context is if I'm a non founder or a PM, I'm just like, oh my God, a branding exercise is going to take months going to suck up all these resources. I don't know what it's going to do for us. What kind of timeframe do you recommend for early stage companies to go through kind of a branding exercise and go through something like this and maybe even later stage, what's reasonable?

**中文翻译:**
在深入探讨这三个要素之前，我脑子里还有一个问题，算是设定背景：如果我不是创始人，或者我是一个产品经理（PM），我可能会想：“天哪，品牌练习要花好几个月，耗费这么多资源，我不知道它能给我们带来什么。”对于早期公司，你建议花多长时间来做这种品牌练习？对于后期公司，多长时间是合理的？

---

### [00:41:45] Arielle Jackson

**English:**
Yeah. It depends on the stage of your company and how much you have already that you have to kind of... It's hard for people to scrap up what they already have. There's a lot of sunk cost fallacy type stuff going on. If you're starting from nothing, I think you can do this in three weeks. The naming process itself because of trademark and domains can take a little longer. When I name companies, it usually takes about a month just for naming, but the whole brand strategy process you could do, if you're a really early stage company in a matter of weeks.

**中文翻译:**
这取决于公司的阶段，以及你已经拥有了多少需要……人们很难舍弃已经拥有的东西，这里有很多“沉没成本谬误”。如果你是从零开始，我认为三周就能搞定。由于商标和域名的原因，命名过程本身可能会长一点。我给公司起名通常需要一个月。但整个品牌战略流程，如果你是一家非常早期的公司，几周内就能完成。

---

### [00:42:15] Arielle Jackson

**English:**
And I think whatever time it takes you actually is going to save you so much time down the road. It's going to help you save time on company decision making. It's going to help you save time, writing your website. Literally your web copy almost writes itself, if you get this all done right. So it's a small investment of time up front that actually saves you a lot of time down the road is how I would sell it to a skeptical PM.

**中文翻译:**
而且我认为，无论现在花多少时间，实际上都会在未来为你节省大量时间。它能帮你节省公司决策的时间，节省写网站文案的时间。毫不夸张地说，如果你把这些都做对了，你的网页文案几乎是信手拈来。所以，前期的一点时间投入实际上能换来未来的高效。这就是我会对持怀疑态度的 PM 说的推销辞。

---

### [00:42:40] Lenny

**English:**
You've sold it. That sounds very high ROI. Let's get into it.

**中文翻译:**
你成功说服我了。听起来投资回报率（ROI）很高。让我们开始吧。

---

### [00:42:43] Arielle Jackson

**English:**
High ROI.

**中文翻译:**
高 ROI。

---

### [00:42:43] Lenny

**English:**
So purpose is the first piece. What is that? And then what are some examples of really good executions of purpose that you've seen?

**中文翻译:**
那么“使命”（Purpose）是第一部分。它到底是什么？你能举几个你见过的执行得非常好的使命案例吗？

---

### [00:42:50] Arielle Jackson

**English:**
Sure. So your purpose is why you do what you do. It makes people want to root for you. And it has a big role in aligning people to come want to work for you and to have employees all feel like they're part of something. I like to think of it as we exist to blank. And whatever that blank is your purpose. Do you want to hear about examples or do you want to hear about what makes a good purpose?

**中文翻译:**
当然。你的使命就是“你为什么做你正在做的事”。它让人们想要支持你。它在吸引人才加入以及让员工感到自己是事业的一部分方面起着巨大作用。我喜欢把它想成：“我们存在的意义是 [空格]。”那个空格里的内容就是你的使命。你想听案例，还是想听什么才算是一个好的使命？

---

### [00:43:14] Lenny

**English:**
Both would be most excellent.

**中文翻译:**
两者都听那就太棒了。

---

### [00:43:16] Arielle Jackson

**English:**
So a good purpose, it explains the change you want to see in the world irrespective of financial gain. So people often get hung up on mission and vision and values and all this stuff. And values are fine. They're internal. I'm not going to talk about those today, but I don't care about mission and vision. I just want one thing because people can only remember one thing and it's your purpose and it's why you do what you do. And when you articulate this really well, it helps you make company decisions, it exists on a 10 year frame. So everything we talk about with product positioning, it's pretty malleable. It exists on an 18 month frame if you're a early stage company, so it can evolve, whereas your purpose is pretty much going to stay the same for 10 years. It's that north star.

**中文翻译:**
一个好的使命，它解释了你希望在世界上看到的改变，且不考虑经济利益。人们经常纠结于使命（mission）、愿景（vision）和价值观（values）这些东西。价值观没问题，那是对内的，我今天不谈。但我不在乎使命和愿景的区别，我只要一样东西，因为人们只能记住一样东西，那就是你的“Purpose”（使命/宗旨），即你为什么做这件事。当你能很好地表达这一点时，它能帮你做公司决策。它的有效期通常是 10 年。我们谈论的产品定位是可塑的，对于早期公司来说，它的有效期大概是 18 个月，可以进化；而你的使命在 10 年内基本保持不变。它是那颗北极星。

---

### [00:44:03] Arielle Jackson

**English:**
And it helps align people in the company and it helps the public want you to win. I worked at Google right out of grad school and Google's purpose was to organize the world's information and make it universally accessible and useful. And I thought every company had a purpose that everyone at the company knew. I just thought that was my first real job. It turns out that's not true. And Google's actually been amazing at this. I had a person in my last cohort who had recently left Google when they were like, I don't know, 80 or a hundred thousand people. He said everyone still can say that. That's amazing. But I joined, it was like 1400 people. And by the time of your first day, you already knew that. It was part of your hiring process.

**中文翻译:**
它能统一公司内部的思想，并让公众希望你获胜。我研究生毕业后就在 Google 工作，Google 的使命是“整合全球信息，使人人皆可访问并从中受益”。我当时以为每家公司都有一个全员皆知的使命。毕竟那是我的第一份正式工作。后来发现事实并非如此。Google 在这方面做得非常好。我上一期课程里有个刚从 Google 离职的人，当时公司大概有八万或十万人。他说每个人依然能背出那句话。这太神奇了。我加入时只有 1400 人，但在你入职的第一天，你就已经知道了。它是招聘流程的一部分。

---

### [00:44:51] Arielle Jackson

**English:**
It was part of your onboarding. It was in your offer letter. It was everywhere. And I just thought that was really cool and a good purpose. One that is kind of related to financial gain, but I still think is cool is Stripe's, which is to increase the GDP of the internet. I think that's really well said and cool and just gets you thinking about the internet as a country. I don't know. If you're an internet person, it makes you want to root for them.

**中文翻译:**
它是入职培训的一部分，在你的录用信里，无处不在。我觉得那非常酷，是一个好的使命。还有一个虽然与经济利益有点关系，但我仍然觉得很酷的例子是 Stripe 的：“增加互联网的 GDP”。我觉得这说得非常好，很酷，让你把互联网想象成一个国家。如果你是一个互联网人，这会让你想支持他们。

---

### [00:45:21] Arielle Jackson

**English:**
Nike's is awesome. I wrote Nike's down because I don't remember it, to bring inspiration and innovation to every athlete in the world. And if you have a body, you are an athlete. It's not just about LeBron it's about me and how was my Peloton ride this morning too? So those are some famous companies. I could tell you a little bit about some that I've worked on that I think are pretty cool that are companies you may not have heard of yet, just because sometimes we get hung up in like thinking Stripe and Nike and Google are awesome names because of all the meaning we have behind them. And I want to talk about some companies you may not have heard of because you can have a good purpose and not be Stripe and Nike and Google.

**中文翻译:**
耐克（Nike）的也很棒。我记下来了，因为我背不全：“为全球每一位运动员带来灵感和创新。”而且他们补充说，“只要你有身体，你就是运动员。”这不仅仅关乎勒布朗·詹姆斯，也关乎我，关乎我今天早上的 Peloton 骑行。这些都是知名公司。我可以聊聊我合作过的一些我觉得很酷、但你可能还没听说过的公司。因为有时我们太迷信 Stripe、Nike 和 Google，觉得它们名字好是因为背后有深意。我想聊聊小公司，因为即使你不是大厂，也可以拥有伟大的使命。

---

### [00:46:07] Lenny

**English:**
Yeah. That'd be awesome. And by the way, the purpose, should it be a sentence? Is that the general-

**中文翻译:**
好啊，那太棒了。顺便问一下，使命应该是一句话吗？这是通用的——

---

### [00:46:08] Arielle Jackson

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:46:08] Lenny

**English:**
... guideline. Great.

**中文翻译:**
……准则。太好了。

---

### [00:46:09] Arielle Jackson

**English:**
So you can introduce yourself at a conference. You're the keynote speaker at a conference and I want you to introduce yourself and I want you to go, hi, I'm Lenny, I'm the founder of the company X, and we exist to blah and say it and have that feel natural.

**中文翻译:**
这样你就可以在会议上介绍自己。假设你是主讲嘉宾，我希望你这样介绍：“嗨，我是 Lenny，公司 X 的创始人，我们存在的意义是 [某某某]。”说出来要感觉很自然。

---

### [00:46:21] Lenny

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:46:22] Arielle Jackson

**English:**
And it should make people want to hear what else you have to say. And the other thing it should be able to do is be the header for your about page. So meaning we exist to blah, blah, blah, blah, blah. But you would just take out the we exist and say the verb and start there. That could be the header for your about page. So one company I worked on, First Round company, they're called LogicLoop and it's an operations automation company.

**中文翻译:**
它应该让人们想听你接下来的话。另一件事是，它应该能作为你网站“关于我们”页面的标题。也就是说，“我们存在的意义是……”你可以去掉“我们存在的意义是”，直接从动词开始。那就可以作为标题。比如我合作过的一家 First Round 投资的公司叫 LogicLoop，是一家运营自动化公司。

---

### [00:46:48] Arielle Jackson

**English:**
You can think of it almost stuff like a no code, low code platform to automate a lot of the operations data based work that people have to do. And we did this whole brainstorm and I really liked their purpose. You can look at their about page. It will be right there it's to make operations data work harder than operations people. And if you ever have worked in operations or have friends who have, they work really, really hard and it can be kind of thankless. So it gets anyone in that field to root for you. Your data should be working harder than your operations people.

**中文翻译:**
你可以把它想象成一个无代码或低代码平台，用来自动化人们必须做的许多基于数据的运营工作。我们做了一次头脑风暴，我非常喜欢他们的使命。你可以看他们的“关于”页面，就在那儿：“让运营数据比运营人员工作更努力。”如果你做过运营，或者有朋友做运营，你会知道他们工作非常辛苦，而且有时吃力不讨好。所以这会让该领域的任何人支持你。你的数据应该比你的运营人员更卖力。

---

### [00:47:21] Lenny

**English:**
Disclaimer, I'm an investor in LogicLoop, and I love that you worked with them.

**中文翻译:**
免责声明：我是 LogicLoop 的投资者，我很高兴你和他们合作过。

---

### [00:47:24] Arielle Jackson

**English:**
Cool. Awesome. And then another one that I worked on of another First Round company, they're called Woolf. They're informed by the UC model where there's a bunch of individual schools that all exist by themselves, but they get something from being part of a larger organization. And what they do is they provide accreditation through being part of the larger Woolf University, but every individual college can still operate as their own independent college.

**中文翻译:**
酷，太棒了。还有一家我合作过的 First Round 公司叫 Woolf。他们借鉴了加州大学（UC）模式，即有很多独立的学院，它们独立存在，但通过成为大型组织的一部分而获益。他们做的是通过成为更大的 Woolf 大学的一部分来提供认证，但每个学院仍可以作为独立的学院运营。

---

### [00:47:52] Arielle Jackson

**English:**
And so their purpose is to increase access to world class higher education and ensure that it is globally recognized and transferable. So this idea of you should be able to take a class from the best instructor online and then go travel to Australia and take a class there and then go to China and take a class there and get the best education that the world can offer.

**中文翻译:**
所以他们的使命是：“增加获得世界级高等教育的机会，并确保其在全球范围内获得认可且可转移。”也就是说，你应该能在线听最优秀导师的课，然后去澳大利亚上课，再去中国上课，获得世界所能提供的最好的教育。

---

### [00:48:15] Arielle Jackson

**English:**
Another one that I worked on a while ago is Alt. I think they've recently gone through a little bit of like a rebranding, but theirs was to increase the transparency and liquidity of alternative assets. And in their case, the product positioning was really about making sports cards as easy to invest in as stocks. So the idea of alternative assets in this case are not private equity and hedge funds in real estate, but alternatives to alternatives, like sports cards and Pokemon cards and art.

**中文翻译:**
我前段时间合作的另一家公司是 Alt。我想他们最近做了一点品牌重塑，但他们的使命是：“增加另类资产的透明度和流动性。”在他们的情况下，产品定位实际上是让投资球星卡像投资股票一样简单。所以这里的“另类资产”不是指私募股权、对冲基金或房地产，而是“另类中的另类”，比如球星卡、宝可梦卡和艺术品。

---

### [00:48:45] Lenny

**English:**
Awesome. Those are so many awesome examples. That's going to be useful for people to wrap their head around what a purpose might be. Execution wise, do you just kind of open up a Google doc and just start writing out ideas and brainstorm a little bit and just kind of keep refining with your team?

**中文翻译:**
太棒了。这么多精彩的例子。这对于人们理解什么是“使命”非常有帮助。在执行层面，你是直接打开一个 Google 文档开始写想法，进行头脑风暴，然后和团队不断完善吗？

---

### [00:48:58] Arielle Jackson

**English:**
I actually stole this exercise or borrowed it from [inaudible 00:49:03] that I actually think adds some structure to that. If you do it that way and it works for you, that's awesome. But if you want to go in and go through a process to get there, what I like to do is list all of the cultural tensions that are happening in the world that are relevant to your business first. And so for Alt, that would be things like there's an increase in interest in alternatives. People who are now in their 30s are nostalgic for things that happened in the '90s There is at the time really low interest rates and people are not getting any sort of edge off of investing in the things that their parents used to invest in. So those would be examples of cultural tensions. Cultural tensions are zeitgeist, their things that your audience might be thinking of.

**中文翻译:**
我其实是从别人那里借鉴了这个练习，我认为它增加了一些结构性。如果你直接写也行得通，那也很好。但如果你想走流程，我喜欢先列出世界上正在发生的、与你业务相关的“文化冲突”（cultural tensions）。对于 Alt 来说，这可能包括：人们对另类资产的兴趣增加；现在 30 多岁的人对 90 年代的事物感到怀旧；当时的利率非常低，人们无法通过投资父母辈投资的那些东西获得优势。这些就是文化冲突的例子。文化冲突是时代精神，是你的受众可能会想到的事情。

---

### [00:49:51] Arielle Jackson

**English:**
They're things that they may be even subconscious to them, their current events. So you make a long list of all of those. Then you make a long list of all the ways that you might describe your brand's best self. And this is related to your product positioning, but let's say you haven't done yet, so just think of it as your brand's best self. How would we want someone to describe us? When everything works perfectly, and our product really delivers, what does it deliver? And again, bullets, just ways that you would talk about that. And then you pick one from each side, that's really the best articulation of what's happening in the world, what your product delivers, and with that context, now you're primed.

**中文翻译:**
这些事情甚至可能是他们潜意识里的，或者是时事。你把这些列一个长单子。然后，你再列一个长单子，描述你“品牌的最佳状态”。这与产品定位有关，但假设你还没做定位，那就想成你品牌的最佳状态。我们希望别人怎么描述我们？当一切运行完美，我们的产品真正发挥作用时，它交付了什么？同样，用要点列出来。然后从两边各选一个最能表达“世界正在发生什么”和“你的产品交付了什么”的项。有了这个背景，你就准备好了。

---

### [00:50:30] Arielle Jackson

**English:**
With that context in mind, now you do the brainstorm of, we exist to let me finish this sentence, and even before you get there, sometimes it's helpful to do the world would be a better place if. So for my company, the world would be a better place if, and finish that sentence and then go into the we exist to.

**中文翻译:**
带着这个背景，现在开始头脑风暴：“我们存在的意义是……”来完成这个句子。甚至在到这一步之前，有时先做这个练习也很有帮助：“如果 [空格]，世界会变得更美好。”对于我的公司，先完成“如果……世界会更美好”，然后再进入“我们存在的意义是……”。

---

### [00:50:49] Lenny

**English:**
Wow. I'm so happy I asked that question. By the way, is there also a place we can point people to that want to do this exercise? Is there another First Round interview post, or I know you have a course on this too.

**中文翻译:**
哇。我太庆幸问了这个问题。顺便问下，有没有什么地方可以让想做这个练习的人参考？有没有另一篇 First Round 的文章，或者我知道你也有相关的课程。

---

### [00:50:59] Arielle Jackson

**English:**
Yeah. There's another First Round review article it's called Three Moves Every Startup Founder Should Make, something like that

**中文翻译:**
有的，还有一篇 First Round Review 的文章，叫《每个初创公司创始人应做的三个动作》（Three Moves Every Startup Founder Should Make）之类的。

---

### [00:51:07] Lenny

**English:**
Great. I will find it and I'll add it.

**中文翻译:**
太好了。我会找到并把它加进去。

---

### [00:51:09] Arielle Jackson

**English:**
Yeah. Okay. Awesome.

**中文翻译:**
好的，太棒了。

---

### [00:51:10] Lenny

**English:**
Amazing. Okay. Let's move on to the next part, which is around positioning, which is a big deal. First, just what is positioning? And then I'd love to know just what tells you may have a positioning problem, that's something you should really focus on?

**中文翻译:**
太棒了。好，让我们进入下一部分，关于“定位”（Positioning），这可是件大事。首先，什么是定位？其次，我想知道，什么迹象表明你可能存在定位问题，需要重点关注？

---

### [00:51:23] Arielle Jackson

**English:**
Okay. So positioning is the space that you occupy in your target customer's mind and everything you can do to influence how they describe your product. You have a positioning problem if I ask 10 of your customers or 10 of your employees what the company does or what the product does. And I get multiple answers. And unfortunately that's the case for most companies. It's okay if the answers are tiny slight variance on the same thing, but I have actually done this with some later stage companies [inaudible 00:52:01] my first step is often I go in and I interview 10 people, and the 10 people are everyone from execs to people who talk to customers to a few customers. And when you get 10 people saying 10 wildly different things, you have a positioning problem. Other ways you might know that if you have a positioning problem is if you can't explain what you do to me in a sentence that's, you have a positioning problem.

**中文翻译:**
好的。定位就是你在目标客户心中占据的空间，以及你为影响他们描述你产品的方式所做的一切努力。如果你有定位问题，表现为：如果我问 10 个客户或 10 个员工公司是做什么的，或者产品是做什么的，我得到了多个不同的答案。不幸的是，大多数公司都是这种情况。如果答案只是大同小异，那没关系。但我确实在一些后期公司做过这个：我的第一步通常是去访谈 10 个人，包括高管、一线销售/客服和几个客户。当 10 个人说出 10 种截然不同的东西时，你就有了定位问题。另一种判断方法是：如果你不能用一句话向我解释你是做什么的，那你就有定位问题。

---

### [00:52:25] Lenny

**English:**
That's a high bar.

**中文翻译:**
这门槛挺高的。

---

### [00:52:26] Arielle Jackson

**English:**
Yeah, it is. And when I first started consulting, I would spend the first meeting with a founder, just totally cold. Hey, tell me about your company. And they would take 30 minutes to tell me about their company. And at the end of 30 minutes, I would pretty much get it, but it always took the first 30 minutes. So now when I engage with a new company, I have them fill out this little worksheet beforehand. And one of the questions is what do you do? And they have to write in a box that's kind of paragraph length.

**中文翻译:**
是的，确实高。当我刚开始做咨询时，第一次见创始人，我会直接问：“嘿，跟我说说你的公司。”他们会花 30 分钟来介绍。30 分钟后，我基本能明白，但总是要花掉前 30 分钟。所以现在当我接触新公司时，我会让他们提前填一张小工作表。其中一个问题就是“你是做什么的？”，他们必须在一个段落长度的框里写出来。

---

### [00:52:55] Lenny

**English:**
Clever.

**中文翻译:**
聪明。

---

### [00:52:56] Arielle Jackson

**English:**
And then I go in and I ask questions about that. And ultimately we get it to sentence length.

**中文翻译:**
然后我会针对内容提问。最终，我们会把它缩减到一句话的长度。

---

### [00:53:00] Lenny

**English:**
Amazing. Okay. How do you go about figuring out your positioning? Big question.

**中文翻译:**
太棒了。好，你如何去确定你的定位？这是一个大问题。

---

### [00:53:05] Arielle Jackson

**English:**
Yeah. So I start with your audience. Who's this for? And we really think about what's the broadest set of customers or users that you might have and narrow in from there to a target audience, which is who are you outwardly going to try to acquire for the next 18 months?

**中文翻译:**
好的。我从受众开始。这是给谁用的？我们会思考你可能拥有的最广泛的客户或用户群，然后从中缩小范围到“目标受众”，即你在未来 18 个月内打算主动去获取的人群。

---

### [00:53:25] Arielle Jackson

**English:**
You can think of it like concentric circles. The biggest circle is your TAM. As you get smaller, there's five parts to it. So the biggest circle is circle one, circle two, circle three, circle four is your target audience. All of the circles have to be contained within the bigger circle. And then the dot in the middle is your model persona. So this is actually like a person with a name and an age and a location and a job and feelings and priorities and all of that.

**中文翻译:**
你可以把它想象成同心圆。最大的圆是你的 TAM（总可寻址市场）。随着圆变小，它分为五个部分。最大的圆是圆 1，然后是圆 2、圆 3，圆 4 就是你的目标受众。所有的圆都必须包含在大圆之内。最中间的那个点就是你的“典型画像”（model persona）。这实际上是一个有名字、年龄、地点、工作、情感、优先级和兴趣的具体的人。

---

### [00:53:54] Arielle Jackson

**English:**
And so we talk about the model user and the target audience, the target audience again is who will you outwardly try to acquire for the next 18 months? If you're an early stage company, it's very possible that you're going to acquire people outside of that circle, in the next circle or even the bigger circle, but they're not who you're actively going out to try to acquire.

**中文翻译:**
所以我们讨论典型用户和目标受众。再次强调，目标受众是你未来 18 个月主动尝试获取的人。如果你是一家早期公司，你很有可能获取到这个圆圈之外的人，比如下一个圆圈甚至更大圆圈里的人，但他们不是你主动出击去获取的对象。

---

### [00:54:15] Lenny

**English:**
Can I ask you a couple questions on the person?

**中文翻译:**
关于这个“画像”，我能问几个问题吗？

---

### [00:54:17] Arielle Jackson

**English:**
Yeah.

**中文翻译:**
可以。

---

### [00:54:18] Lenny

**English:**
I'm doing some writing and research into this stuff. How specific do you suggest people get with this person right at the middle? I love that it's an actual person, I guess not a real person, but a very descriptive [crosstalk 00:54:29]

**中文翻译:**
我正在对这些内容进行一些写作和研究。你建议人们对中间的这个“人”描述得具体到什么程度？我喜欢它是一个“真实的人”的设定，我猜不是真人，但描述非常详尽……

---

### [00:54:29] Arielle Jackson

**English:**
Can be a real person or an amalgamation of not real people. So with the target audience, I like to think of it as something you could name. So with Eero, it was tech savvy dads. It's a category of people. And then the model persona, or that individual user who represents a tech savvy dad for them was this guy who had teenage kids lived in suburban St. Louis, had a 2,800 Square foot house that was made of brick, worked at home on Fridays. His kids were into gaming. He was the VP of sales at a company that was tech adjacent, but not tech. He was more of like a tech enthusiast than an actual software engineer. We knew a lot about him. I could tell you a lot about him. It's kind of robust, but tech savvy dads was the way to represent him and other people like him, that would be their target audience.

**中文翻译:**
可以是真人，也可以是虚构人物的集合。对于目标受众，我喜欢用一个能命名的词。比如 Eero，目标受众是“精通技术的爸爸们”。这是一类人。而代表这类人的“典型画像”或个体用户是：一个住在圣路易斯郊区、有十几岁孩子的男人；住着 2800 平方英尺的砖房；周五在家办公；孩子喜欢打游戏；他在一家科技相关（但非纯科技）的公司担任销售副总裁；他更像是一个科技爱好者，而不是真正的软件工程师。我们对他了解很多，我可以告诉你很多细节。这很丰满，而“精通技术的爸爸们”就是代表他及类似人群的方式，也就是他们的目标受众。

---

### [00:55:22] Lenny

**English:**
A lot of founders have trouble recognizing that going very focused and niche is a good idea versus man, I'm just going to have these 10 people in the world that really want what I want. What have you found to be the reason it's very powerful and important to start really focused?

**中文翻译:**
很多创始人很难意识到，走极度聚焦和利基（niche）路线是个好主意。他们会想：“天哪，那全世界不就只有 10 个人想要我的东西了吗？”你认为从极度聚焦开始之所以非常强大且重要的原因是什么？

---

### [00:55:37] Arielle Jackson

**English:**
Yeah. So when you are an early stage company, the worst thing you can do is try to be everything to everyone because you don't have enough runway. You just don't have enough of anything to do that successfully. The best thing you can do is find an audience that is big enough, that if you got your significant market share among that audience, you'd be a giant business. And tech savvy dads is a pretty big audience. Also that's just who your outbound going to try to acquire for the next 18 months. I'm a tech savvy mom. I live with a tech savvy dad. I have an Eero system. It doesn't mean everyone you'll ever acquire must be in that audience, it means that is who we're focused on acquiring.

**中文翻译:**
是的。当你是一家早期公司时，你能做的最糟糕的事就是试图取悦所有人，因为你没有足够的资金（runway）。你没有足够的资源来成功做到这一点。你能做的最好的事是找到一个足够大的受众群体，如果你能在该群体中获得显著的市场份额，你就能成为一家巨大的企业。“精通技术的爸爸们”就是一个相当大的群体。此外，这只是你未来 18 个月主动去获取的对象。我是一个精通技术的妈妈，我家里也有个精通技术的爸爸，我有一套 Eero 系统。这并不意味着你获取的每个人都必须在这个群体中，它只是意味着这是我们专注获取的目标。

---

### [00:56:24] Lenny

**English:**
Awesome. I took us off course around the positioning process. I think we kind of went off course with concentric circles model. So I'll give it back to you to keep going.

**中文翻译:**
太棒了。我刚才把话题带偏了，扯到了同心圆模型。现在把话筒交还给你，继续讲定位流程。

---

### [00:56:36] Arielle Jackson

**English:**
Yeah. Okay. So the way that I like to run positioning exercise is to start with who is this for? And then what is the problem that they have? There's some problem usually that these people have, they may not even be aware it's a problem, or they may not be experiencing the problem as particularly troubling, but there's something going on for these people. And then how do they address that problem today? So they do something, they're buying something, they're have a workaround, they're doing something today. And that something might not be another startup or your direct competitor. It might be the old way of doing things, but they're doing something. So we go through who is it for? What's their problem? How do they address it? And then what do you make?

**中文翻译:**
好的。我喜欢运行定位练习的方式是：首先问“这是给谁用的？”然后“他们面临什么问题？”通常这些人都有某种问题，他们甚至可能没意识到那是问题，或者没觉得那个问题特别困扰，但确实有些事情在发生。接着，“他们今天是如何解决那个问题的？”他们正在做某事，买某样东西，或者有一个临时替代方案。那个“某事”可能不是另一家初创公司或你的直接竞争对手，可能是老旧的处理方式，但他们确实在做些什么。所以我们梳理：给谁用？什么问题？怎么解决？然后“你制造了什么？”

---

### [00:57:20] Arielle Jackson

**English:**
How does it work? And what would you want a user of your product or service to tell another? And that's kind of if you answer all of those questions, it ultimately leads into this classic four statement, which is not something I invented, it's something that's been around for 40 or 50 years. And I learned it when I was 22. And I think it's one of the most powerful tools in marketing. It can feel like mad libs if you just approach it cold. But if you've gone through that work of defining who is it and what's their problem, all it is a distillation of that. So that statement is for target audience who there's a statement of need or opportunity. And then you say our product name is a category that has a benefit, unlike the old thing they were doing, our product works this other way.

**中文翻译:**
它是如何运作的？你希望你的产品或服务用户如何向别人推荐？如果你回答了所有这些问题，最终会引向这个经典的“定位声明”（positioning statement）。这不是我发明的，它已经存在了四五十年。我 22 岁时就学到了它，我认为它是营销中最强大的工具之一。如果你直接去填，它可能像填字游戏。但如果你已经完成了定义受众和问题的准备工作，它就是这些工作的精华。这个声明是：“对于 [目标受众] 来说，他们有 [需求或机会]，我们的 [产品名称] 是一个 [类别]，它具有 [利益点]；不同于 [旧的解决方案]，我们的产品 [以这种方式运作]。”

---

### [00:58:10] Lenny

**English:**
Awesome. And we'll link to the post that actually has that so people don't have to write this all down. That last piece you mentioned, I hadn't heard before, the idea of what will they tell other people or how will they describe it to other people? Is that right?

**中文翻译:**
太棒了。我们会链接到包含这个公式的文章，大家就不用全记下来了。你提到的最后一点我以前没听过，就是“他们会告诉别人什么”或者“他们会如何向别人描述”。是这样吗？

---

### [00:58:22] Arielle Jackson

**English:**
Yeah. So I believe that great benefits if you've defined your benefit really, really well will actually be the thing that will be the H1 on your homepage and will be the thing that you want someone to tell someone else. Think about Square Stand and turn your iPad into a point of sale. Turn your iPad into a point of sale. Yeah. If I went to a small business owner and they were having drinks with a friend, who's also a small business owner, what would I want them to say about the Square Stand? Oh yeah. I just got the Square Stand. It's this really cool new register that turns my iPad into a point of sale. That's pretty much exactly what I want them to say. And so if you can write that line, that is your ideal benefit, what you want people to say, and it's something that your target audience would actually say, that's great.

**中文翻译:**
是的。我相信，如果你把“利益点”定义得非常好，它实际上就会成为你首页的 H1 标题，也会成为你希望用户转述给别人的话。想想 Square Stand 的“把你的 iPad 变成销售终端”。如果我去找一个小企业主，他正和另一个小企业主朋友喝酒，我希望他怎么评价 Square Stand？“哦对了，我刚买了 Square Stand。这是一个超酷的新收银机，能把我的 iPad 变成销售终端。”这几乎就是我希望他们说的话。所以，如果你能写出那句话——即你理想的利益点，且是目标受众真的会说出口的话，那就太棒了。

---

### [00:59:12] Lenny

**English:**
Interesting. I love that. That makes a lot of sense. For people trying to go through this exercise, you always have such a good answers to how actually the process of coming up with say you're positioning this case, is it again, you pull up a doc and start writing things or is there something even more structured?

**中文翻译:**
有趣。我喜欢这个。非常有道理。对于尝试做这个练习的人，你总是能给出关于“如何实际操作”的精彩答案。以确定定位为例，是再次打开文档开始写，还是有更结构化的方法？

---

### [00:59:28] Arielle Jackson

**English:**
Yeah. There's something more structured. I have kind of a worksheet that goes through all those things we just talked about. So it's like, who is it for? What are they doing today? All those questions we just talked about, it's more like a structured brainstorm. There's an exercise I really love that I've called the bar test that is helping you get everything you've written into human language because one of the really big pitfalls I see, especially for B2B companies, but really for everyone is they write in a way that people don't talk. So the document, when I get the first draft back from founders often has things like leverages and empowers and nobody talks like that. And so getting this into turns your iPad into a point of sale blankets your home in fast, reliable wifi, records your screen and cam at the same time, really basic stuff that it describes your product in a way that someone would actually say that's the type of language that I think people want to use.

**中文翻译:**
是的，有更结构化的方法。我有一个工作表，涵盖了我们刚才聊的所有内容：给谁用？他们今天在做什么？等等。这更像是一个结构化的头脑风暴。我非常喜欢一个叫“酒吧测试”（the bar test）的练习，它能帮你把写下的所有内容转化为“人话”。因为我看到的一个巨大陷阱（尤其是 B2B 公司，其实所有公司都有）是：他们的文案写得不像人说话。当我拿到创始人的第一稿时，经常看到“赋能”（empowers）、“杠杆利用”（leverages）之类的词，没人会那样说话。所以要把它变成“把 iPad 变成销售终端”、“让快速可靠的 WiFi 覆盖全家”、“同时录制屏幕和摄像头”这种非常基础的描述，就像人们真的会说出口的话。我认为这才是人们想用的语言。

---

### [01:00:28] Arielle Jackson

**English:**
First of all, you defined your target. Now you pretend to be someone in your target, having drinks with someone else in your target at a bar and you have to be able to say, hey, I just started using product name. It's this really great category, that benefit. And the other person goes, hm, tell me more or that's cool, what do you mean? Or some other similar prompts. And then you have to say your differentiator. You actually have to say it out loud. And if you run through that test and it's actually stuff people would say out loud, then you've done a pretty good job and you can start using that copy publicly.

**中文翻译:**
首先，你定义了目标受众。现在你假装自己是目标受众中的一员，正在酒吧里和另一个目标受众喝酒。你必须能说出：“嘿，我刚开始用 [产品名]。它是一个非常棒的 [类别]，可以 [利益点]。”对方会回应：“嗯，再多跟我说说”或者“很酷，什么意思？”之类的话。然后你必须说出你的差异化优势。你必须大声说出来。如果你通过了这个测试，而且这些话确实是人们会大声说出来的，那么你就做得很好，可以开始公开使用这些文案了。

---

### [01:01:07] Lenny

**English:**
That is very cool. I have not heard this bar test before and I like that it might happen at an actual bar. Is that also something people can find online or is that they write it down right now?

**中文翻译:**
这太酷了。我以前没听过这个“酒吧测试”，我喜欢它可能真的发生在酒吧里的设定。这个东西网上能找到吗？还是大家现在就得记下来？

---

### [01:01:18] Arielle Jackson

**English:**
Ooh, I don't know if that's online.

**中文翻译:**
噢，我不确定网上有没有。

---

### [01:01:20] Lenny

**English:**
Okay, cool. This is it. Exclusive.

**中文翻译:**
好，太棒了。这就是独家内容了。

---

### [01:01:22] Arielle Jackson

**English:**
Yeah, that's in my course, and we talk a lot about that and we go through the exercise like a real role play in the course, but yeah, take some notes.

**中文翻译:**
是的，这在我的课程里有，我们会详细讨论，并在课上进行真正的角色扮演练习。不过，大家现在可以记一下笔记。

---

### [01:01:31] Lenny

**English:**
I like that a lot.

**中文翻译:**
我很喜欢这个。

---

### [01:01:33] Arielle Jackson

**English:**
Thanks.

**中文翻译:**
谢谢。

---

### [01:01:33] Lenny

**English:**
Your point reminded me of an email I just pulled up that I got from ADP, your point about just you want to make sure you're branding is something that feels like something you would say to a person. So it's like ADP, which is a security service for fire, like alarms. I got this email, summer's on with fun or our free secure app and more. And then it's like make summer safer and more fun at home or away. ADP, you're not going to make it more fun. What are you talking about?

**中文翻译:**
你的观点让我想起我刚翻出来的一封来自 ADT（注：原文误为 ADP，实为安保公司 ADT）的邮件。你提到要确保品牌感觉像是在对人说话。ADT 是做火灾报警等安保服务的。我收到这封邮件说：“夏日乐趣开启，使用我们的免费安全应用及更多。”然后是：“让家内外的夏天更安全、更有趣。”ADT，你又不能让夏天变得更有趣，你在说什么呢？

---

### [01:02:01] Arielle Jackson

**English:**
See, that's an example of trying too hard. They tried too hard to make it sound colloquial and fun. They're a security system, it should be more like secure your home while you're away. Feel safe when you're on your summer trip. Stuff like that.

**中文翻译:**
看，这就是“用力过猛”的例子。他们太想听起来口语化和有趣了。他们是安保系统，文案应该更像：“当你不在家时保护你的家”、“在夏日旅行中感到安心”之类的。

---

### [01:02:16] Lenny

**English:**
They even included a gif of this TikTok'er being like ADP is my MVP.

**中文翻译:**
他们甚至还放了一个 TikTok 博主的 GIF，说“ADT 是我的 MVP”。

---

### [01:02:21] Arielle Jackson

**English:**
Yeah. This kind of relates to brand personality where the brand personality for ADP, I don't know, it's pretty not fun. And so for them, when they put on fun hat, it seems awkward and forced.

**中文翻译:**
是的。这与“品牌个性”有关。ADT 的品牌个性……怎么说呢，一点也不有趣。所以当他们强行戴上“有趣”的帽子时，就会显得尴尬和生硬。

---

### [01:02:36] Lenny

**English:**
That's exactly the feeling I got. And so, yeah, personality, that's our next topic. It's not something I you think about when you think about brand and marketing and plans and so I'm really curious to hear why I think that's important then how to figure out your own personality for your brand.

**中文翻译:**
我正是那种感觉。所以，是的，“个性”（Personality）是我们的下一个话题。在考虑品牌、营销和计划时，这通常不是人们首先想到的东西。所以我很好奇，为什么你认为它很重要，以及如何确定自己品牌的个性。

---

### [01:02:51] Arielle Jackson

**English:**
So I think personality is one of those inputs that will help define your visual design and it will definitely help define your written copy. And it really comes from this idea of brands are like people. And if you start thinking of your brand more like a person, it's quite obvious that it needs a personality, because all people have personalities. And these days, especially when brands show up in places where people show up, like TikTok and Instagram, your brand certainly needs a personality or else you end up like ADP trying to be fun for the summer, which just feels really off and weird. So personality is one of those things that it's actually the easiest part. I think it's the fastest part. It often ends up an hour and you can get it done. But I have some frameworks I like to use that really just get at are you Mountain Dew or are you Rolex or are you somewhere in between?

**中文翻译:**
我认为个性是帮助定义视觉设计和书面文案的关键输入之一。它源于“品牌如人”的理念。如果你开始把品牌想象成一个人，那么它显然需要个性，因为每个人都有个性。如今，尤其是当品牌出现在人们聚集的地方（如 TikTok 和 Instagram）时，你的品牌肯定需要个性，否则你就会像 ADT 那样试图在夏天变得有趣，结果感觉非常违和且古怪。个性其实是最简单的部分，也是最快的部分，通常一个小时就能搞定。但我有一些喜欢的框架，能帮你搞清楚：你是“激浪”（Mountain Dew）还是“劳力士”（Rolex），或者是介于两者之间？

---

### [01:03:46] Arielle Jackson

**English:**
And when you think about brands that have a lot of equity, they really do have a personality. I often talk about Mountain Dew marketing as that marketing that's like trying really hard to be cool and rugged and edgy and fast and kind of teen and Rolex, it's very like Gray Poupon, oh, roll down your window and do you have any Gray Poupon, it's fancy and sophisticated and a little bit aspirational and maybe even a little British. And those two things are really, really, really different. And there's a lot in the middle and not everyone's going to be a Mountain Dew or Rolex, but where are you? And so you can just write it down. I think a lot of these answers come back to like, if you are good with just opening a blank Google doc and like writing down who you are by all means, go for it.

**中文翻译:**
当你想到那些拥有极高品牌资产的品牌时，它们确实有个性。我经常把“激浪”的营销描述为：拼命想变得酷、粗犷、前卫、快速，带点青少年气息；而“劳力士”则非常像 Gray Poupon 芥末酱（注：美国经典高端广告梗），那种摇下车窗问“你有 Gray Poupon 吗？”的感觉，它是华丽、精致、带点向往感，甚至有点英国范儿。这两者截然不同。中间地带有很多空间，不是每个人都要成为激浪或劳力士，但你定位在哪？你可以直接写下来。如果你擅长直接打开空白文档写下“你是谁”，那就去做吧。

---

### [01:04:35] Arielle Jackson

**English:**
And if that feels daunting and hard for you, use a framework. And the framework that I like to use has two parts. The first part is based on some academic research by Jennifer Aker and it basically analyzed the top brands in the world and figured out that all brands can be segmented into five dimensions of brand personality. And that really strong brand spike in two of the five. So the five dimensions that she found were sincerity, so this is like, is it down to earth and honest, excitement, it's spirited, this is a Mountain Dew thing, competence, reliable and intelligent, sophisticated, sophistication, which is a charming and upper class and rugged outdoorsy and tough. So sincerity, excitement, competence, sophistication, and ruggedness. And going back to those two brands we just discussed Mountain Dew is rugged and exciting, Rolex is sophisticated and competent and you can do this with any brand who admire or just think about brands you like and kind of deduce them to their two of those five.

**中文翻译:**
如果那让你感到畏缩，那就用框架。我喜欢的框架分为两部分。第一部分基于 Jennifer Aaker 的学术研究，她分析了全球顶级品牌，发现所有品牌都可以分为五个维度的品牌个性。强大的品牌通常在其中两个维度上表现突出。她发现的五个维度是：1. 真诚（Sincerity）：务实、诚实；2. 刺激（Excitement）：充满活力，比如激浪；3. 胜任（Competence）：可靠、聪明；4. 精致（Sophistication）：迷人、上流感；5. 粗犷（Ruggedness）：户外感、坚韧。回到刚才说的两个品牌：激浪是“粗犷”和“刺激”，劳力士是“精致”和“胜任”。你可以对任何你钦佩的品牌做这个练习，把它们归纳为这五个维度中的两个。

---

### [01:05:39] Arielle Jackson

**English:**
So that's the first step. Which two of those five are you going to spike in? And it turns out a lot of tech companies end up spiking in sincerity and competence just usually does happen that way. Amazon is sincere and competent. Google is sincere and competent. Apple is not, Apple has a little more of that sophistication to it. But in any case, if you just did that, we would end in a world where everyone's sincere and competent or maybe sophisticated and competent. It's like a really boring world. So the next step after you do that is to define five attributes, five brand personalities, thinking about those two dimensions. I like to think about this as a star, five point star and brands need tension to be interesting. So if you tell me we're helpful, we're nice, we're approachable, we're competent, and we're reliable.

**中文翻译:**
这是第一步：你会在这五个维度中的哪两个表现突出？事实证明，很多科技公司最终都落在“真诚”和“胜任”上，通常就是这样。亚马逊是真诚且胜任的，Google 也是。苹果不是，苹果多了一点“精致”。但无论如何，如果只做这一步，我们会进入一个每个人都“真诚且胜任”或“精致且胜任”的世界，那太无聊了。所以下一步是根据这两个维度定义五个属性，即五个品牌个性特征。我喜欢把它想象成一颗五角星。品牌需要“张力”（tension）才会有趣。如果你告诉我：“我们乐于助人、友善、亲切、胜任且可靠。”

---

### [01:06:37] Arielle Jackson

**English:**
You basically haven't told me anything because you just use three words to say one thing and two words to say another thing. Whereas if you tell me, oh, well we're really savvy, but we're also really approachable. That's kind of cool. Because people who are expert are always approachable. They have to have a little tension and then you want to write them as statements that say we are X, but not Y, where Y is taking X too far. So in the example Google is playful but not silly, so they would say we are playful, but not silly, or maybe Mountain Dew would say we are daring, but not stupid. So taking that attribute a little too far. And so yeah, then you end up with these five statements that are we are X, but not Y. And those are really useful in informing how you write and maybe even what your visual design would look like, and certainly what your illustration style photography style ad copy will be like.

**中文翻译:**
你基本上什么也没告诉我，因为你用了三个词说同一件事，又用了两个词说另一件事。但如果你告诉我：“哦，我们非常精明（savvy），但我们也平易近人。”这就有趣了，因为专家并不总是平易近人的。必须有一点张力。然后你要把它们写成声明：“我们是 X，但不是 Y”，其中 Y 是把 X 推向了极端。例如 Google 是“风趣但不愚蠢”，或者激浪可能会说“大胆但不愚蠢（不计后果）”。也就是避免把某个属性发挥过头。最终你会得到五个“是 X 但不是 Y”的声明。这些对于指导你的写作、视觉设计，甚至插画风格、摄影风格和广告文案都非常有用。

---

### [01:07:39] Lenny

**English:**
Once you've gone through that exercise and in maybe the other two pieces, where do you put this? Is this just like in a doc that's like here's our brand overview, here's our personality, here's our positioning, here's our purpose. And then you refer back to that whenever you're designing and putting together strategies? Is that how it works?

**中文翻译:**
一旦完成了这个练习以及另外两个部分，你会把这些内容放在哪里？是放在一个文档里，写着“这是我们的品牌概览”、“这是我们的个性”、“这是我们的定位”、“这是我们的使命”，然后在设计或制定战略时参考它吗？是这样运作的吗？

---

### [01:08:00] Arielle Jackson

**English:**
Yeah, you could do it that way. That's definitely one way of doing it. That's a good start. I think that one other place where it shows up, like we talked about that visual style guide that everyone has, that they give to an agency or copywriter who's writing on their behalf. I think these should all be inputs into that doc that you end up sharing. I think it should go into any onboarding you do for new employees so that they understand who the company is. Any partners that you're marketing with, co-branding, all of that, it should really be think of it as your little brand Bible about who you are. And also it should be revisited when you're doing, let's say a new product or to make sure does this need to be updated or does this new product need to fit into who we are?

**中文翻译:**
是的，你可以那样做。这绝对是一种方式，也是个好的开始。我认为它还应该出现在其他地方，比如我们提到的视觉风格指南。当你把它交给代理商或代笔文案时，这些内容都应该是该文档的输入。我认为它也应该包含在给新员工的入职培训中，让他们了解公司是谁。还有任何营销合作伙伴、联名品牌等等。你应该把它看作是关于“你是谁”的小型品牌圣经。此外，当你开发新产品时，也应该重新审视它，以确保是否需要更新，或者新产品是否符合我们的身份。

---

### [01:08:40] Lenny

**English:**
What do you call this document/place?

**中文翻译:**
你管这个文档或地方叫什么？

---

### [01:08:44] Arielle Jackson

**English:**
When I take all those three components and then add a bunch of other stuff, I call it a creative brief, which is the thing you would hand to an agency or a writer who's writing on your behalf. It would include some other things too, that we didn't talk about, like creative inspiration direction. So picking visual clips and written clips and all these things that you like and that you don't like, so you can show both positive examples and counter examples to the thing you're looking for.

**中文翻译:**
当我把这三个组成部分加上其他一堆东西时，我称之为“创意简报”（creative brief），也就是你交给代理商或文案的东西。它还会包含一些我们没聊到的内容，比如创意灵感方向：挑选你喜欢的和不喜欢的视觉片段、文字片段，这样你就能展示你想要的东西的正反面示例。

---

### [01:09:09] Lenny

**English:**
Thank you for all of that. There's so much juice there. I think people are going to have to listen to this a couple times to get all the learnings. Before I let you go, there's two other areas I wanted to dive into. But I'll keep them brief because I know we're going long. One is about getting PR and just a question I wanted to ask you while I had you, founders and even bigger companies, they're always like, how do I get PR? How do I get press for my product, even though it's sometimes a waste of time. Do you have just any tactical advice for startups hoping to get some PR?

**中文翻译:**
感谢分享。干货太多了。我想大家得听好几遍才能完全吸收。在结束之前，我还想探讨另外两个领域，我会尽量简短，因为我知道时间快到了。一个是关于公关（PR）。我想问你，创始人们甚至大公司总是问：“我该如何获得 PR？如何让媒体报道我的产品？”尽管有时那是浪费时间。对于希望获得 PR 的初创公司，你有什么战术上的建议吗？

---

### [01:09:43] Arielle Jackson

**English:**
You mean initial coverage around a launch or ongoing?

**中文翻译:**
你是指发布时的初始报道，还是持续性的报道？

---

### [01:09:47] Lenny

**English:**
I'd say early on, yeah, before the launch.

**中文翻译:**
我会说是早期，也就是发布之前。

---

### [01:09:49] Arielle Jackson

**English:**
Sure. So the first one is to get your story straight. So, so many times I have founders come to me and they're like, hey, we need help with this announcement. I'm like, cool. What's the announcement? And back to the 30 minutes until I understand what the company is, so if you can't describe it to me in a sentence, your reporter is certainly not going to understand in a sentence and they won't be able to describe it to their audience in a sentence. And so really getting your story straight, all the stuff we talked about specifically around product positioning is so key. Almost always when someone comes to me and says, I'm ready to announce, we go back to positioning first. Also make sure that your website is ready for the traffic you're going to drive to it, that you're not driving traffic to a name that you're going to later scrap.

**中文翻译:**
好的。第一点是理顺你的故事。很多时候创始人来找我说：“嘿，我们需要这个发布公告的帮助。”我会问：“好啊，发布什么？”然后又是那 30 分钟我才明白公司是干嘛的。如果你不能用一句话向我描述清楚，记者肯定也没法用一句话理解，更没法用一句话向他们的读者描述。所以，理顺故事——也就是我们聊过的产品定位——至关重要。几乎每次有人跟我说“我准备好发布了”时，我们都会先回到定位。另外，确保你的网站已经准备好迎接流量，不要把流量引向一个你以后打算废弃的名字。

---

### [01:10:32] Arielle Jackson

**English:**
Are you really ready for this? So go back to all the other things we discussed first and then having realistic expectations about the outlets that will cover you and the time it will take to get them. So a lot of people will be like, I'm launching next week. And it's like, well, cool that you're doing that, but no reporters going to cover you next week. It just doesn't work like that anymore. Five years ago, eight years ago, founders could really dictate the date of a launch announcement, they could brief three to five outlets under embargo, which means like you all can't tell our secret news until we tell you at this time you can publish. And at that time, three of the five would all file a story and write, and it just doesn't work like that anymore. These days for early stage startups, we're almost always running the launch announcement as an exclusive, which means you give the news to a single outlet.

**中文翻译:**
你真的准备好了吗？先回到我们讨论过的所有其他事情。然后，对报道你的媒体渠道以及所需的时间要有现实的预期。很多人会说：“我下周发布。”我会说：“那很好，但下周不会有记者报道你。”现在的规则变了。五八年前，创始人真的可以决定发布日期，他们可以向三五家媒体提供“禁令期”（embargo）简报，即在指定时间前不能公开。到那个时间点，几家媒体会同时发稿。现在行不通了。如今对于早期初创公司，我们几乎总是以“独家报道”（exclusive）的形式进行发布，即只把消息给一家媒体。

---

### [01:11:19] Arielle Jackson

**English:**
And they're the only ones who get to write about it. You can obviously still do all your owned and operated stuff, your blog, your social, your investors, your friends and family, but they're the only like news outlet who gets to write about it. So having an expectation that this is probably going to be an exclusive, it's harder than ever to secure funding for a seed stage company and funding in and of itself is not that interesting anymore. There's so many bad companies getting funding. There's so many good companies getting funding too just more than ever. And the number of reporters and the number of outlets that are covering it is just less than it used to be. So really just thinking about like, well, who writes about this space? Do they write about company's at my stage?

**中文翻译:**
他们是唯一可以报道这件事的媒体。当然，你仍然可以做自媒体、博客、社交媒体，通知投资者和亲友，但他们是唯一的报道媒体。所以要有“这可能是个独家”的预期。现在种子轮融资比以往任何时候都难，而且融资消息本身已经没那么有趣了。有太多烂公司拿到融资，也有太多好公司拿到融资，数量远超以往。而负责报道的记者和媒体数量却比以前少了。所以要思考：谁在报道这个领域？他们会报道我这个阶段的公司吗？

---

### [01:12:08] Arielle Jackson

**English:**
That's another really big one is, hey, we want the New York Times. It's like, cool, no one's at the New York Times has ever covered a seed stage startup unless it's crazy for the last five years. Who do you think is going to write about you? But there are still outlets that do. The other one is don't do a straight funding announcement. A lot of founders raise money and they're like, cool, let's announce. It's like, no, we'll use that funding announcement as a news hook to tell a larger story and a larger story might be your products available. You have reference customers, you have momentum, you have some great partnership that you're announcing. There's something else going on, not just your funding and using your funding as part of that initial launch is great, but what else are you announcing?

**中文翻译:**
另一个大问题是：“嘿，我们想上《纽约时报》。”我会说：“好啊，但过去五年里，《纽约时报》几乎没报道过种子轮初创公司，除非那事儿特别离谱。”你觉得谁会写你？不过还是有一些媒体会写的。另一点是：不要只发融资公告。很多创始人融了钱就想发布。不，要把融资作为“新闻钩子”（news hook）来讲述一个更大的故事。这个故事可能是：你的产品上线了；你有标杆客户；你有增长势头；或者你宣布了一个重磅合作。除了融资，还有别的事情在发生。把融资作为初始发布的一部分很好，但你还宣布了什么？

---

### [01:12:55] Arielle Jackson

**English:**
The last thing is really about making what you do interesting and relevant so that it's not just interesting and relevant to you and the three other people who worked there at the time, but interesting to all the readers of whatever outlet you're trying to target. And so an example of that is I worked on this company, Vitable Health and the founder, Joseph, he created a product for hourly workers that their employer would buy and it costs like $50 per person per month. And what it does is it provides urgent care and primary care. So these hourly workers who make too much to qualify for Medicaid and too little to pay their health insurance premiums, and so primary and urgent care for hourly workers. And we tied it into this idea of the great resignation and small businesses not being able to hire hourly workers, which was like a big trend end of 2021, and the company operates in Philadelphia and Delaware, and we were actually able to get him the Sunday after Christmas, Philadelphia Inquirer story.

**中文翻译:**
最后一点是，要让你做的事情变得有趣且相关。不仅是对你和另外三个同事有趣，而是对目标媒体的所有读者都有趣。举个例子，我合作过一家叫 Vitable Health 的公司，创始人 Joseph 为小时工开发了一款产品，由雇主购买，每人每月约 50 美元。它提供急诊和基础医疗。这些小时工收入太高无法申请医疗补助（Medicaid），但收入又太低付不起商业医保保费。我们把它与“大离职潮”（Great Resignation）以及小企业招不到小时工的理念联系起来，那是 2021 年底的大趋势。该公司在费城和特拉华州运营，我们最终帮他在圣诞节后的周日登上了《费城询问报》（Philadelphia Inquirer）。

---

### [01:13:57] Arielle Jackson

**English:**
But it was all about making this daycare and this restaurant in Philadelphia into heroes because they offered this cool benefit to their hourly workers. And so the headline was perfect for them, but it wasn't like here's Vitable and here's what they announced and here's, it was like, hey, look at this cool new thing that local businesses are doing to attract hourly workers. And so think about your company in a way to make it interesting and relevant and don't sleep on local preps.

**中文翻译:**
但报道的重点是把费城的这家日托中心和这家餐厅塑造成“英雄”，因为他们为小时工提供了这么酷的福利。所以标题对他们来说很完美，它不是说“这是 Vitable，这是他们的发布”，而是说“嘿，看看当地企业为了吸引小时工正在做的这件酷事”。所以，思考如何让你的公司变得有趣且相关，并且不要忽视地方媒体。

---

### [01:14:23] Arielle Jackson

**English:**
If you have a local business or a local story or local customers, this was a huge thing at Square. We turned all of our customers into heroes and went after local press. Most PR firms that service the tech community aren't experts in local press, but if you have a way to make some connections with some local press, they are the ones hungry for these stories more than the New York Times and the Wall Street Journal.

**中文翻译:**
如果你有本地业务、本地故事或本地客户，这在 Square 曾是一件大事。我们将所有客户塑造成英雄，并寻求地方媒体的报道。大多数服务科技圈的 PR 公司并不擅长地方媒体，但如果你能与地方媒体建立联系，他们比《纽约时报》或《华尔街日报》更渴望这些故事。

---

### [01:14:50] Lenny

**English:**
What a good tip and most likely they're much more open to writing about you versus New York Times or Wall Street Journal. Cool. Okay. So I want to ask you one question about hiring marketing real quick and I'll keep it short just because I know we're going out of time. When should a startup hire a full-time marketing person in your experience?

**中文翻译:**
真是个好建议，而且地方媒体很可能比大报社更愿意写你。好，我想快速问一个关于招聘营销人员的问题，我会简短点，因为时间快到了。根据你的经验，初创公司什么时候应该招聘全职营销人员？

---

### [01:15:08] Arielle Jackson

**English:**
When you have a lot of problems that you're trying to solve that would be better solved by someone who knew what they're doing, or when you have a bunch of freelancers and agencies that are becoming too hard to manage by yourself.

**中文翻译:**
当你有很多问题需要解决，而这些问题由专业人士处理会更好时；或者当你有一堆自由职业者和代理商，多到你自己已经管不过来时。

---

### [01:15:21] Lenny

**English:**
When do you find that usually ends up being... Is there kind of a heuristic-

**中文翻译:**
你发现这通常发生在什么时候？有没有什么经验法则——

---

### [01:15:25] Arielle Jackson

**English:**
Yeah. Ballpark, it kind of depends if you're a marketing driven business or a sales driven business. So if you're a sales driven business and you don't have a repeatable sales motion, it's not yet time to hire a marketer, get that repeatable sales motion, and marketing's job is to bring you more marketing qualified leads. So that's one, so that kind of depends. If you're a marketing driven business, it generally seems to me like it happens around 10 people, the founders doing most of this themselves, they're not doing the best job usually or they've hired agency here, a freelancer there to kind of cobble some stuff together. And they now realize like, okay, if I had a person who would be able to do all of this and manage these agencies and freelancers, this would be a lot better.

**中文翻译:**
大概来说，这取决于你是营销驱动型还是销售驱动型业务。如果你是销售驱动型业务，且还没有一套可重复的销售流程，那还没到招营销人员的时候。先建立可重复的销售流程，营销的任务是为你带来更多“营销合格线索”（MQL）。所以这取决于情况。如果你是营销驱动型业务，通常在公司达到 10 人左右时会发生。创始人之前一直在亲力亲为，但通常做得不够好，或者东找一个代理商、西找一个自由职业者来拼凑。现在他们意识到：“如果我有一个人能统筹这一切并管理这些外部资源，情况会好得多。”

---

### [01:16:13] Arielle Jackson

**English:**
It also is do you have a one point in time project? Do you need to do positioning? Do you need a website? Do you need a name? Do you need to run a test of Google ads? Those things are all discreet when it becomes this is ongoing work that needs to happen over time. It's better to think about hiring a marketer and really what kind of marketer do you need? Do you need a product marketer, a performance marketer, a comms person, a creative person? Ideally everyone wants all of that. But I kind of like that idea of a T-shaped marketer who's really deep on one of those functions, but knows enough to be dangerous across all of them.

**中文翻译:**
另外还要看你是否只有阶段性项目。你需要做定位吗？需要网站吗？需要起名吗？需要测试 Google 广告吗？这些都是离散的任务。当这些变成需要长期持续进行的工作时，就该考虑招人了。而且要考虑你需要哪种营销人员：产品营销（PMM）、效果营销（Performance）、公关（Comms）还是创意人员？理想情况下大家都想要全才。但我比较推崇“T 型营销人”的概念：在某一领域钻研很深，但对其他领域也略知一二，足以应对挑战。

---

### [01:16:48] Lenny

**English:**
I think we're going to need another episode just about that one topic. I have so many questions I want to ask, but I need to let you go. That'll be V2. Before we do that, we've gotten to the very exciting lightning round where I'm just going to ask you quick questions and you just give me a quick answer and we will knock through them all. Does that sound good?

**中文翻译:**
我想我们需要专门再做一期节目来聊这个话题。我有太多问题想问了，但我得放你走了。那将是我们的第二版。在那之前，我们进入令人兴奋的“闪电问答”环节，我会快速提问，你快速回答，我们把它们全部搞定。听起来怎么样？

---

### [01:17:06] Arielle Jackson

**English:**
Sounds great.

**中文翻译:**
听起来很棒。

---

### [01:17:07] Lenny

**English:**
What are two or three books that you recommend most to other people?

**中文翻译:**
你最推荐给别人的两三本书是什么？

---

### [01:17:09] Arielle Jackson

**English:**
In marketing land, definitely the book called Positioning: The Battle for Your Mind. It's from 1980, it's still my favorite marketing book. Another recent marketing book is Alchemy by Rory Sutherland. It's like my favorite area of reading is behavioral science, psychology meets business. And that's in there. For fiction, I just read The Vanishing Half by Brit Bennett. It was awesome. I then read her other book called The Mothers, but I think The Vanishing Half's better.

**中文翻译:**
在营销领域，绝对是《定位：争夺用户心智的战争》（Positioning: The Battle for Your Mind）。它是 1980 年出版的，至今仍是我最喜欢的营销书。另一本最近的营销书是 Rory Sutherland 的《炼金术》（Alchemy）。我最喜欢的阅读领域是行为科学、心理学与商业的结合，这本书就属于此类。小说方面，我刚读了 Brit Bennett 的《消失的一半》（The Vanishing Half），非常棒。后来我又读了她的另一本书《母亲们》（The Mothers），但我认为《消失的一半》更好。

---

### [01:17:36] Lenny

**English:**
Awesome. I will check that out. What's a favorite podcast or even newsletter on marketing?

**中文翻译:**
太棒了。我会去看看。你最喜欢的营销类播客或时事通讯（Newsletter）是什么？

---

### [01:17:41] Arielle Jackson

**English:**
I love Nick Sharma's weekly newsletter. He's a growth marketer. He started his career I think at [inaudible 01:17:48] water. So he does a lot of CPG type DTC. He has a great marketing newsletter that comes out every Sunday night. On podcasts, I love How I Built This. I know that's already really popular, but I love that one. It's not really marketing, but just general business. The First Round podcast in depth is pretty great. Lenny's podcast I've been listening to is awesome. And then my friend Jasmine from The Concept Bureau has a marketing podcast called Unseen, Unknown. And it's kind of about culture and branding and how these things and society and trends. It's not like straight marketing. It's kind of more of the culture and sociology that informs marketing.

**中文翻译:**
我喜欢 Nick Sharma 的每周 Newsletter。他是一名增长营销专家，职业生涯始于 Hint Water。他做了很多消费品（CPG）类的直面消费者（DTC）业务。他的营销 Newsletter 每周日晚上发布，非常棒。播客方面，我喜欢《创业功成》（How I Built This）。我知道它已经很火了，但我真的很喜欢。它不完全是营销，而是通用商业。First Round 的播客《In Depth》也很棒。我一直在听的 Lenny 的播客也非常出色。还有我朋友 Jasmine（来自 The Concept Bureau）的一个营销播客叫《Unseen, Unknown》，它是关于文化、品牌以及社会趋势的。它不是那种纯营销，更多是关于影响营销的文化和社会学。

---

### [01:18:30] Lenny

**English:**
Wow. That is a lot of good stuff. What's a recent movie or TV show that you've loved?

**中文翻译:**
哇。干货真多。最近有什么你喜欢的电影或电视节目吗？

---

### [01:18:35] Arielle Jackson

**English:**
This is more embarrassing. How many movies have you seen in the last year? Just curious.

**中文翻译:**
这有点尴尬。你去年看了多少部电影？纯属好奇。

---

### [01:18:41] Lenny

**English:**
Me? A lot, on streaming services. Way too many also, if that's where you're going or have you seen none?

**中文翻译:**
我？很多，在流媒体平台上看的。也太多了点。你是想说你一部都没看吗？

---

### [01:18:48] Arielle Jackson

**English:**
Well, I've seen maybe four and they're probably all on Disney+.

**中文翻译:**
嗯，我大概看了四部，而且可能都在 Disney+ 上。

---

### [01:18:53] Lenny

**English:**
You're winning. That's excellent.

**中文翻译:**
你赢了。那很棒。

---

### [01:18:56] Arielle Jackson

**English:**
I would say I really like some of those Disney Pixar movies, Luca, Encanto. Those are all really great. I mostly only watch movies with my kids, but I'm pretty excited. I had a celebrity crush on Anthony Bourdain and I'm excited to watch his new documentary if I ever get around to it. And TV shows I'm equally bad.

**中文翻译:**
我想说我真的很喜欢迪士尼皮克斯的一些电影，比如《夏日友晴天》（Luca）、《魔法满屋》（Encanto）。它们都很棒。我基本只和孩子们一起看电影。但我挺兴奋的，我曾迷恋过安东尼·波登（Anthony Bourdain），如果我有时间，我很想看他的新纪录片。至于电视剧，我也看得很少。

---

### [01:19:16] Lenny

**English:**
Okay, great.

**中文翻译:**
好的，太好了。

---

### [01:19:16] Arielle Jackson

**English:**
And there's this little Netflix show called Old Enough. It's a Japanese show with subtitles about sending toddlers on errands in Japan. They like go by themselves. It's 10 minutes. They're awesome. My whole family watched them together. It's really cute.

**中文翻译:**
Netflix 上有一个叫《小不点大跑腿》（Old Enough）的小节目。这是一个带字幕的日本节目，讲的是让蹒跚学步的孩子在日本独自去跑腿。他们自己去，每集 10 分钟。非常棒，我们全家一起看的，真的很可爱。

---

### [01:19:29] Lenny

**English:**
Old Enough. I'm going to check that out. Okay. Two more questions. Favorite interview question when hiring a marketing person?

**中文翻译:**
《小不点大跑腿》，我会去看的。好，最后两个问题。招聘营销人员时你最喜欢的面试问题？

---

### [01:19:35] Arielle Jackson

**English:**
It's probably tell me a project you're proud of. Tell me about a project you're proud of, is just really open-ended and get to hear a lot about a lot of things that way. And then maybe runner up is tell me about a campaign you recently come across that you were not involved with that you thought was cool.

**中文翻译:**
可能是“告诉我一个让你自豪的项目”。这是一个非常开放的问题，通过这种方式可以听到很多事情。备选问题是：“告诉我一个你最近看到的、你没有参与但觉得很酷的营销活动。”

---

### [01:19:53] Lenny

**English:**
Hmm. Love that. Okay. Final question. Who else in the industry do you most respect as a thought leader?

**中文翻译:**
嗯，喜欢这个。好，最后一个问题。业内你最尊敬的意见领袖（Thought Leader）是谁？

---

### [01:20:01] Arielle Jackson

**English:**
In the marketing industry?

**中文翻译:**
在营销行业吗？

---

### [01:20:02] Lenny

**English:**
In the marketing industry? Yeah, sure.

**中文翻译:**
在营销行业？是的。

---

### [01:20:04] Arielle Jackson

**English:**
I guess old school thought leaders, David Ogilvy, Rory Sutherland, Seth Godin. New school thought leaders, we mentioned Nick Sharma. There's a woman named... I'm probably going to butcher her name, Anna Andjelic. She has a newsletter that I didn't mention before. It's called the Sociology of Business. That's really good. She's a CMO, chief brand officer type. She kind of turned around Banana Republic recently, which was cool. Emily Hayward from Red Antler. I also really like Ross. I don't know this guy, but Ross Simmons from Foundation, which is a content marketing agency. I'm not a content marketing expert, but he really is. And I think he puts out some good content.

**中文翻译:**
老派的意见领袖，我猜是奥格威（David Ogilvy）、Rory Sutherland、赛斯·高汀（Seth Godin）。新派的，我们提到了 Nick Sharma。还有一位女士，我可能会念错她的名字，Anna Andjelic。她有一份我之前没提到的 Newsletter，叫《商业社会学》（The Sociology of Business），非常棒。她是 CMO、首席品牌官那一类的人，最近成功重塑了 Banana Republic，很酷。还有 Red Antler 的 Emily Hayward。我也很喜欢 Ross Simmons（来自 Foundation，一家内容营销机构），我不认识他，但我不是内容营销专家，而他绝对是，他发布的内容质量很高。

---

### [01:20:48] Lenny

**English:**
Man, these show notes are going to be a long list of great stuff. Arielle, thank you so much for being here. There's just so much jampacked knowledge. I don't know if people were prepared when they started listening to this and so congrats on making it through and I hope you're probably going to go back and listen again and again. And so again, Arielle, thank you so much for doing this. Two last questions. Where can folks find you online if they want to reach out or ask questions and how can listeners be useful to you?

**中文翻译:**
天哪，这期节目的笔记将会是一份长长的干货清单。Arielle，非常感谢你能来。这里的信息量太大了。我不知道大家在开始听之前有没有做好心理准备，恭喜听完的朋友，我希望你们能反复收听。再次感谢 Arielle。最后两个问题：如果大家想联系你或提问，在网上哪里可以找到你？以及，听众可以为你做些什么？

---

### [01:21:14] Arielle Jackson

**English:**
Sure I'm on Twitter and LinkedIn. Twitter, I'm hiimarielle. And if you're interested in this stuff, but feeling overwhelmed, I will plug my Maven course. I teach a course on startup brand strategy that covers everything we talked about in this hour, or this is more than an hour now and kind of with a little more hand holding and feedback. So it's a crash course on all this stuff. The four founders that takes two weeks and you go through all of this and that next cohort of that, I think we're on cohort four will be this fall. So you can apply for that course at maven.com/arielle/startupbrandstrategy.

**中文翻译:**
当然，我在 Twitter 和 LinkedIn 上。Twitter 账号是 hiimarielle。如果你对这些内容感兴趣但感到无从下手，我想推荐一下我的 Maven 课程。我教一门关于初创公司品牌战略的课，涵盖了我们这一个多小时聊到的所有内容，并且有更多的手把手指导和反馈。这是一门针对创始人的速成课，为期两周，你会经历所有这些流程。下一期（我想是第四期）将在今年秋天开始。你可以在 maven.com/arielle/startupbrandstrategy 申请这门课程。

---

### [01:21:57] Lenny

**English:**
Amazing. And I guess that's how listeners can be useful to you.

**中文翻译:**
太棒了。我想这就是听众可以为你做的事。

---

### [01:22:00] Arielle Jackson

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:22:01] Lenny

**English:**
Excellent.

**中文翻译:**
太好了。

---

### [01:22:01] Arielle Jackson

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:22:02] Lenny

**English:**
All right. Well great. All right, well thank you again, thank you again and [inaudible 01:22:07].

**中文翻译:**
好的，太棒了。再次感谢你。

---

### [01:22:07] Arielle Jackson

**English:**
Thanks so much, Lenny. It was fun.

**中文翻译:**
非常感谢，Lenny。很有趣。

---

### [01:22:09] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期节目再见。