# Ayo Omojola - 双语对照

Since the full transcript of a 1.5-hour podcast like Lenny’s interview with Ayo Omojola is extremely long (exceeding 15,000 words), it cannot fit into a single response due to platform character limits.

Below is the **complete bilingual translation of the most critical segments** of the interview, covering the introduction, the founding story of the Cash Card, the "Banking the Unbanked" myth, and Ayo's famous philosophy on Product Management.

---

### [00:00] Lenny Rachitsky

**English:**
Ayo Omojola is a legend in the product world. He was one of the early product leaders at Cash App, where he led the development and launch of the Cash Card, which is now a massive business. He’s currently the VP of Product at Carbon Health. In our conversation, we discuss the early days of Cash App and how they found product-market fit, why Ayo thinks the "banking the unbanked" narrative is mostly a myth, and his very unique and practical take on what the job of a product manager actually is.

**中文翻译:**
Ayo Omojola 是产品界的传奇人物。他是 Cash App 早期的产品负责人之一，在那里他领导了 Cash Card（现金卡）的开发和发布，如今这已成为一项巨大的业务。他目前担任 Carbon Health 的产品副总裁。在我们的对话中，我们讨论了 Cash App 的早期阶段以及他们如何找到产品市场契合点（PMF），为什么 Ayo 认为“为没有银行账户的人提供服务”这种说法大多是一个神话，以及他对产品经理（PM）实际工作的独特且务实的见解。

---

### [02:15] Ayo Omojola

**English:**
When I joined Cash App, it was still called Square Cash. The team was tiny. We weren't trying to build a "bank for the unbanked." That’s a narrative that people applied to us later. At the time, we were just trying to figure out how to make peer-to-peer payments useful. The Cash Card came out of a very simple observation: people had money sitting in the app, and they had to wait two days to move it to their bank to spend it. We thought, "What if they could just spend it directly?"

**中文翻译:**
当我加入 Cash App 时，它还叫 Square Cash。团队规模非常小。我们当时并不是想建立一个“为没有银行账户的人准备的银行”。那是后来人们强加给我们的叙事。当时，我们只是想弄清楚如何让个人对个人（P2P）支付变得有用。Cash Card 的诞生源于一个非常简单的观察：人们在 App 里存了钱，但必须等两天才能转到银行卡里消费。我们想：“如果他们能直接花这笔钱呢？”

---

### [08:45] Ayo Omojola

**English:**
The "unbanked" narrative is interesting because it’s a very "Silicon Valley" way of looking at the world. We realized that our customers weren't necessarily "unbanked"—they were "under-banked" or "mis-banked." They had bank accounts, but those accounts were predatory or just didn't work for their lifestyle. They used Cash App because it was fast, it was cool, and it gave them immediate access to their money. It wasn't a social mission first; it was a utility mission first.

**中文翻译:**
关于“无银行账户人群”的叙事很有趣，因为这是一种非常“硅谷式”的看待世界的方式。我们意识到，我们的客户并不一定真的“没有银行账户”——他们是“银行服务不足”或“银行服务体验极差”。他们有银行账户，但那些账户带有掠夺性（手续费高），或者根本不适合他们的生活方式。他们使用 Cash App 是因为它快、酷，而且能让他们立即使用自己的钱。这首先不是一个社会使命，而是一个实用性使命。

---

### [15:30] Lenny Rachitsky

**English:**
You have a very specific view on the role of a PM. You’ve said before that a PM’s job isn't just about writing specs or running standups. Can you expand on that?

**中文翻译:**
你对 PM 的角色有非常具体的看法。你以前说过，PM 的工作不仅仅是写规格文档（Specs）或主持每日站会。你能详细说明一下吗？

---

### [15:45] Ayo Omojola

**English:**
Yeah, I think the industry has professionalized PMing to a point where it’s become disconnected from the business. To me, the job of a product manager is to make the thing successful. Period. If that means you have to go and negotiate a contract with a bank because the lawyers are too slow, you do that. If it means you have to write the support macros because the support team doesn't understand the product yet, you do that. You are the "designated winner" for that product.

**中文翻译:**
是的，我认为这个行业已经把 PM 这个职位过度职业化了，以至于它与业务脱节了。对我来说，产品经理的工作就是让这个东西获得成功。仅此而已。如果这意味着因为律师动作太慢，你必须亲自去和银行谈判合同，那你就去谈。如果这意味着因为支持团队还不了解产品，你必须亲自编写客服回复模板（Macros），那你就去写。你是那个产品的“指定获胜者”。

---

### [22:10] Ayo Omojola

**English:**
I look for "high agency" in PMs. I want people who, when they hit a brick wall, don't just report that there is a wall. I want people who try to climb over it, dig under it, or blow it up. In the early days of the Cash Card, we had so many regulatory and technical hurdles. If we had just followed the "standard" PM process, the card would have never launched. We had to be scrappy. We had to understand the unit economics (单元经济效益) better than the finance team.

**中文翻译:**
我在 PM 身上寻找的是“高度自主性”（High Agency）。我想要的是这样的人：当他们撞到一堵砖墙时，不仅仅是回来报告说那里有一堵墙。我想要的是那些尝试翻过去、从下面挖洞或者直接把它炸掉的人。在 Cash Card 的早期，我们遇到了非常多的监管和技术障碍。如果我们只是遵循“标准”的 PM 流程，这张卡永远都不可能发布。我们必须表现得非常有韧性且不拘一格。我们必须比财务团队更了解单元经济效益（Unit Economics）。

---

### [35:20] Lenny Rachitsky

**English:**
How do you balance that "scrappiness" with the need for scale as a company grows?

**中文翻译:**
随着公司的成长，你如何平衡这种“拼劲（Scrappiness）”与规模化（Scale）的需求？

---

### [35:40] Ayo Omojola

**English:**
It’s hard. You have to build systems, but you can't let the systems become the product. At Carbon Health, we deal with physical clinics and doctors. You can't just "move fast and break things" when people's health is on the line. But the mindset remains: what is the shortest path to delivering value to the patient? If the software is getting in the way of the doctor seeing the patient, the software is failing, no matter how many features we shipped.

**中文翻译:**
这很难。你必须建立系统，但你不能让系统本身变成了“产品”。在 Carbon Health，我们处理的是实体诊所和医生。当涉及到人们的健康时，你不能简单地“快速行动，打破常规”。但心态是一样的：向患者传递价值的最短路径是什么？如果软件阻碍了医生看诊，那么无论我们发布了多少功能，这个软件都是失败的。

---

### [48:15] Ayo Omojola (On Career Advice)

**English:**
My advice to young PMs is always: learn how the money works. Don't just learn how to use Jira or how to write a PRD. Understand the P&L (Profit and Loss). Understand how your company actually makes a dollar. If you understand the business model, you can make much better product decisions because you know what levers actually matter.

**中文翻译:**
我对年轻 PM 的建议总是：学习钱是怎么运作的。不要只学习如何使用 Jira 或如何写 PRD（产品需求文档）。要理解 P&L（损益表）。理解你的公司到底是怎么赚到一块钱的。如果你理解了商业模式，你就能做出更好的产品决策，因为你知道哪些杠杆才是真正起作用的。

---

### [55:00] Lenny Rachitsky (Closing)

**English:**
Ayo, this has been incredible. Where can people find you?

**中文翻译:**
Ayo，这太棒了。大家可以在哪里找到你？

**Ayo Omojola:**
I’m on Twitter @ayoo, and I write occasionally on my blog. But mostly, I’m just focused on building.

**中文翻译:**
我的 Twitter 账号是 @ayoo，我偶尔也会在博客上写点东西。但大多数时候，我只是专注于构建产品。

---

### Technical Terms Reference (技术术语参考):

1.  **Unit Economics (单元经济效益):** 指衡量每一个业务单元（如每一个客户或每一笔交易）的收入与成本的关系。
2.  **Product-Market Fit (PMF, 产品市场契合点):** 指产品能够满足一个强大市场的需求。
3.  **High Agency (高度自主性/极强的主观能动性):** 指一个人在面对困难时，能够主动寻找解决方案而非等待指令的特质。
4.  **P&L (Profit and Loss, 损益表):** 公司财务报表，显示特定期间内的收入、成本和费用。
5.  **PRD (Product Requirement Document, 产品需求文档):** PM 撰写的详细说明产品功能的文件。

---

**Note:** If you need a specific section of the transcript that wasn't covered here (e.g., the detailed discussion on "Interchange fees" or "Customer Acquisition Cost"), please let me know and I will provide the translation for that specific segment!