# Ben Horowitz - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Ben Horowitz.

---

### [00:00:00] Ben Horowitz

**English:**
The worst thing that you do as a leader is you hesitate on the next decision. The thing that causes you to hesitate is both decisions are horrible. Probably one of my bigger ones on that was we went public with $2 million in trailing 12 months revenue at 18 months old. That's obviously a bad idea. But the truth of it was the alternative was going bankrupt, and that's a worse idea.

**中文翻译:**
作为领导者，你做得最糟糕的事情就是在下一个决策上犹豫不决。导致你犹豫的原因通常是两个选项都很糟糕。我在这方面经历过的最大抉择之一是，我们在公司成立仅 18 个月、过去 12 个月营收（TTM）仅 200 万美元时就上市了。这显然是个坏主意。但事实是，另一个选择是破产，而那是更糟糕的主意。

---

### [00:00:23] Lenny Rachitsky

**English:**
It's a very difficult and painful to be a CEO, to be a founder. In spite of that. So many people want to start companies.

**中文翻译:**
当一名 CEO、一名创始人是非常困难且痛苦的。尽管如此，还是有那么多人想要创业。

---

### [00:00:29] Ben Horowitz

**English:**
The psychological muscle you have to build to be a great leader is to be able to click in the abyss and go, "Okay, that way's slightly better. We're going to go that way. If everybody agrees with the decision, then you didn't add any value because they would've done that without you." So the only value you ever add is when you make a decision that most people don't like.

**中文翻译:**
要成为一名伟大的领导者，你必须锻炼出的心理素质是：能够在深渊中洞察并说：“好吧，那条路稍微好一点，我们就走那条路。”如果每个人都同意你的决定，那么你其实没有创造任何价值，因为没有你他们也会这么做。所以，你唯一的价值体现，就是当你做出了大多数人都不喜欢的决定时。

---

### [00:00:47] Lenny Rachitsky

**English:**
You are famous for writing one of the most popular pieces of literature for product managers.

**中文翻译:**
你曾写过一篇在产品经理圈子里流传最广的文章，并因此闻名。

---

### [00:00:52] Ben Horowitz

**English:**
What I was trying to get out in Good Product Manager, Bad Product Manager, was the job is fundamentally a leadership job. And it's a tricky leadership job because nobody is actually reporting to you.

**中文翻译:**
我在《好产品经理，坏产品经理》中想要表达的是，这份工作本质上是一项领导工作。而且这是一项棘手的领导工作，因为实际上没有人直接向你汇报。

---

### [00:01:06] Lenny Rachitsky

**English:**
There's always this kind of sense that the PM is not the mini CEO. How dare you call yourself that? I actually think that's exactly what the PM is.

**中文翻译:**
总有一种观点认为产品经理（PM）不是“小 CEO”，甚至会觉得“你怎么敢自称 CEO”。但我实际上认为，PM 恰恰就是这个角色。

---

### [00:01:12] Ben Horowitz

**English:**
It doesn't matter if you write a good, spec or you have a good interview or you do this or do that. What matters is that the product works.

**中文翻译:**
你写了一份好的规格说明书，或者面试表现出色，或者做了这做了那，这些都不重要。重要的是产品得行得通。

---

### [00:01:21] Lenny Rachitsky

**English:**
Today my guest is Ben Horowitz. Ben is the Z in A16Z, the world's largest venture capital firm with over 46 billion in committed capital. They're investors in OpenAI, Cursor, Anduril, Databricks, Figma, basically every generational tech company. He's also the author of two New York Times bestselling books, The Hard Thing About Hard Things and What You Do is Who You Are.

**中文翻译:**
今天的嘉宾是 Ben Horowitz。Ben 是 A16Z 中的那个“Z”，这是全球最大的风险投资公司，管理着超过 460 亿美元的承诺资本。他们投资了 OpenAI、Cursor、Anduril、Databricks、Figma，基本上涵盖了每一家划时代的科技公司。他还是两本《纽约时报》畅销书的作者：《创业维艰》（The Hard Thing About Hard Things）和《你所做即你所是》（What You Do is Who You Are）。

---

### [00:01:43] Lenny Rachitsky

**English:**
Ben is endlessly fascinating. He started a rap group when he was younger. He started his career as a product manager and wrote the now famous Good Product Manager, Bad Product Manager piece. In our wide-ranging conversation, we cover a ton of ground and Ben shares stories and insights that he's never shared anywhere else. A huge thank you to Shaka Senghor, Ali Ghodsi, and Adam Neumann for suggesting topics for this conversation. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It helps tremendously. And if you become an annual subscriber of my newsletter, you get a year free of 15 incredible products, including a year free of Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, WhisperFlow, Gamma, Perplexity, Warp, Granola, Magic Patterns, RateCast, ChatPRD, and Mabin. Check it out at lennysnewsletter.com and click Product Pass. With that, I bring you Ben Horowitz.

**中文翻译:**
Ben 是一个非常有魅力的人。他年轻时组建过说唱团体。他的职业生涯始于产品经理，并撰写了那篇著名的《好产品经理，坏产品经理》。在我们这次广泛的对话中，我们涉及了大量领域，Ben 分享了一些从未在其他地方分享过的故事和见解。非常感谢 Shaka Senghor、Ali Ghodsi 和 Adam Neumann 为本次对话提供的选题建议。如果你喜欢这个播客，请不要忘记在订阅并关注。如果你成为我时事通讯的年度订阅者，你将免费获得 15 款不可思议的产品的一年使用权。详情请访问 lennysnewsletter.com 并点击 Product Pass。现在，让我们欢迎 Ben Horowitz。

---

### [00:02:38] Lenny Rachitsky (Sponsor: DX)

**English:**
Today's episode is brought to you by DX, the developer intelligence platform designed by leading researchers. To thrive in the AI era, organizations meet to adapt quickly. But many organization leaders struggle to answer pressing questions like which tools are working? How are they being used? What's actually driving value? DX provides the data and insights leaders need to navigate this shift. With DX, companies like Dropbox, Booking.com, Adyen, and Intercom get a deep understanding of how AI is providing value to their developers and what impact AI is having on engineering productivity. To learn more, visit DX's website at getdx.com/Lenny.

**中文翻译:**
本集节目由 DX 赞助。DX 是由领先研究人员设计的开发者情报平台。为了在 AI 时代蓬勃发展，组织需要快速适应。但许多领导者难以回答紧迫的问题，例如：哪些工具奏效了？它们是如何被使用的？什么才是真正的价值驱动力？DX 为领导者提供了应对这一转变所需的数据和见解。通过 DX，像 Dropbox、Booking.com、Adyen 和 Intercom 这样的公司能够深入了解 AI 如何为开发者提供价值，以及 AI 对工程生产力的影响。欲了解更多信息，请访问 getdx.com/Lenny。

---

### [00:03:22] Lenny Rachitsky (Sponsor: Basecamp)

**English:**
This episode is brought to you by Basecamp. Basecamp is the famously straightforward project management system from 37signals. Most project management systems are either inadequate or frustratingly complex, but Basecamp is refreshingly clear. It's simple to get started, easy to organize, and Basecamp's visual tools help you see exactly what everyone is working on and how all work is progressing. Keep all your files and conversations about projects directly connected to the projects themselves, so that you always know where stuff is and you're not constantly switching contexts. Running a business is hard. Managing your project should be easy. Sign up for a free account at basecamp.com/lenny.

**中文翻译:**
本集节目由 Basecamp 赞助。Basecamp 是来自 37signals 的著名且直观的项目管理系统。大多数项目管理系统要么功能不足，要么复杂得令人沮丧，但 Basecamp 却清晰得令人耳目一新。它上手简单，组织方便，其可视化工具能帮你准确看到每个人的工作内容和进度。将所有文件和项目对话直接与项目关联，让你随时掌握资料位置，无需频繁切换上下文。经营业务已经很难了，管理项目应该简单点。请在 basecamp.com/lenny 注册免费账户。

---

### [00:04:13] Lenny Rachitsky

**English:**
Ben, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Ben，非常感谢你能来，欢迎来到我的播客。

---

### [00:04:17] Ben Horowitz

**English:**
All right, thank you Lenny. Excited to be here.

**中文翻译:**
好的，谢谢 Lenny。很高兴来到这里。

---

### [00:04:19] Lenny Rachitsky

**English:**
I'm even more excited to have you here. I want to start with a question that a close friend of yours suggested I ask you, Shaka Senghor. So Shaka, he's, we could do an hour just on how interesting this guy and the things he's done.

**中文翻译:**
我更兴奋能请到你。我想从你的一位好友 Shaka Senghor 建议我问你的一个问题开始。关于 Shaka，他这个人非常有趣，他做过的事我们聊一个小时都聊不完。

---

### [00:04:32] Ben Horowitz

**English:**
Three hours on Joe Rogan that day. He is very—

**中文翻译:**
他那天在 Joe Rogan 的节目上聊了三个小时。他确实非常——

---

### [00:04:35] Lenny Rachitsky

**English:**
So we're not going to do that. Just to give a glimpse, he was in prison for 19 years. He was in solitary for seven years. He led a huge prison gang. You wrote about him in your book as a great exemplar of great culture in the prison gang that he ran. So interesting. But something that he learned from you that he told me I need to ask you about is about success and how to be successful and how it's not what people think. And he said that you learned this lesson from a pilot. What is that story? What is that lesson?

**中文翻译:**
所以我们今天不聊那么久。简单介绍一下，他曾入狱 19 年，其中 7 年被单独监禁。他曾领导过一个庞大的监狱帮派。你在书中把他作为优秀文化的典范来描写，讲述他如何管理那个帮派。这太有意思了。但他告诉我，他从你那里学到了一些关于“成功”的见解，以及成功如何与大众的认知不同。他说你是从一名飞行员那里学到这一课的。那个故事是什么？那一课又是什么？

---

### [00:05:08] Ben Horowitz

**English:**
I mean, I would say it's a long life lesson. But the pilot story is I actually, I ask people silly questions sometimes when they meet them. And so I met this gentleman who was a pilot and it was right around the time JFK Jr. crashed his airplane and ultimately died. And I asked him, I was like, "What happened?" Because there's always the story in the press, and I know this from them writing about me or anything, is it's always what's the best narrative not what's true. So you can never actually find out what happened, you just find the best story version of what happened.

**中文翻译:**
我想说这是一个漫长的人生教训。关于飞行员的故事是这样的：我有时在见到人时会问一些傻问题。我遇到这位飞行员绅士时，正好是小肯尼迪（JFK Jr.）飞机失事去世前后。我问他：“到底发生了什么？”因为媒体上的报道——我也深知这一点，无论是写我还是写别的——总是倾向于选择“最好的叙事”而不是“真相”。所以你永远无法真正了解发生了什么，你只能找到那个故事性最强的版本。

---

### [00:05:53] Ben Horowitz

**English:**
And the story in the press was all about, "Oh, he wasn't trained on instrumentation was flying at night." And I wanted to know is that right? And the pilot said, "Well," he said, "really, it's like all plane crashes are a series of bad decisions. And none of the decisions by themselves is that bad, but when you add them up, it's bad."

**中文翻译:**
当时媒体的说法全是：“哦，他没有接受过仪表飞行训练，却在夜间飞行。”我想知道这是否属实。那位飞行员说：“其实，所有的空难都是一系列错误决定的结果。单个决定本身可能没那么糟糕，但当它们累积起来时，灾难就发生了。”

---

### [00:06:14] Ben Horowitz

**English:**
So the first decision was he needed to get wherever he was going and that was the priority. And in flying, that can't ever be the priority because there are conditions, there are things that happen. And then the second one was, "Well, his timing of when the sun would go down was wrong." So he thought he'd be flying in sunlight and he wasn't. And then once he got up there, it was when the plane was going down making it go up was a bad decision because he was upside down. And so it was like, I can't remember all the things, but this guy had 17 bad decisions in a row. And the big thing for me that I felt was really true is it's one decision leads to another. And so if you can break psychologically, you can take the sunk cost, then that gets you out of a lot of bad paths. And then a little good decision may be difficult, but you have to believe it's going to lead to the next one. And a lot of success is about that. It's a small thing, a small thing that's hard to do that doesn't seem to have a high impact, but it leads to the next small hard to do thing and then eventually you get an outcome, so that was kind of the concept.

**中文翻译:**
第一个决定是：他必须赶到目的地，并将其视为首要任务。但在飞行中，这永远不能成为首要任务，因为天气和突发状况是不受控的。第二个决定是：他对日落时间的判断错了。他以为会在阳光下飞行，结果却不是。一旦飞上去，当飞机下坠时，他试图拉升，但这又是一个错误的决定，因为当时飞机是倒置的。我不记得所有的细节了，但那个人连续做了 17 个错误的决定。对我来说，最深刻的感悟是：一个决定会引发另一个决定。如果你能在心理上及时止损，接受沉没成本，就能摆脱许多错误的路径。一个微小的正确决定可能很难做出，但你必须相信它会引导你走向下一个。成功的很大一部分就在于此：做一件微小的、困难的、看起来影响不大的事，但它会引向下一件微小而困难的事，最终你才会得到结果。这就是那个核心理念。

---

### [00:07:46] Lenny Rachitsky

**English:**
So the lesson there is just success is just a bunch of little things. It's not this, "Cool, I got here in a big thing."

**中文翻译:**
所以这里的教训是，成功只是一堆小事的累积。它不是那种“酷，我做了一件大事就成功了”的过程。

---

### [00:07:52] Ben Horowitz

**English:**
If somebody were to write a story about me, they would be like, "Then Ben this really smart thing and blah, blah, blah, happy ending." But it really wasn't like that and I don't think it's like that for you or anybody. And I spent a lot of time with Shaka on how, because it's always your own psychology that gets you. And one of the most insightful things he said to me is, because most people who are in solitary for seven years, that's it. You're insane. You're never coming back from that. It's just an impossible thing. But if you study his story, he actually really was massively self-improved coming out of solitary, and he wouldn't recommend that for anybody, just to be clear. It wasn't solitary. But what it was was he changed, in solitary he was able to change a big set of beliefs that he had about himself that got him out of that.

**中文翻译:**
如果有人要写我的故事，他们会写：“然后 Ben 做了一件非常聪明的事，接着噼里啪啦，最后大团圆结局。”但事实并非如此，对你或任何人来说都不是这样。我和 Shaka 花了很多时间讨论这个问题，因为击败你的总是你自己的心理。他对我说的最有见地的一句话是——因为大多数被单独监禁七年的人，基本上就废了，会疯掉，永远无法恢复。这简直是不可能完成的任务。但如果你研究他的故事，他从禁闭室出来后实际上获得了巨大的自我提升。澄清一下，他并不推荐任何人去尝试。重点不在于禁闭，而在于他在禁闭期间改变了对自己的一系列核心信念，这让他走出了困境。

---

### [00:09:08] Ben Horowitz

**English:**
And the thing that his conclusion from it, which I thought was really interesting, he's like, "Look, was in prison for 19 years. I was in solitary for seven. I come out, I can't rent an apartment, I can't vote, I can't get a gun, I can't do, no rights. None of that was anything compared to what I did to myself."

**中文翻译:**
他的结论非常有趣，他说：“看，我坐了 19 年牢，其中 7 年被单独监禁。我出来后，不能租房，不能投票，不能持枪，没有任何权利。但所有这些外部的限制，都比不上我曾经对自己造成的伤害。”

---

### [00:09:08] Ben Horowitz

**English:**
And I think that's very true for CEOs in general and people in general is all the things that you perceive that are happening to you that are bad, be it the systems against you or somebody undercuts you or racism or sexism or this or that or the other is very small compared to ... It means a lot if you believe it. If you believe what people say about you, if you believe what they did to you, then that destroys you. But if you go, "That's not me," you can overcome almost anything. And he's got a new book out on that anyway that I think is very good because that's the, I'd say more than anything, that's the key to success.

**中文翻译:**
我认为这对 CEO 乃至所有人来说都是真理：你所感知到的那些发生在你身上的坏事——无论是体制对你不公、有人暗中中伤、种族歧视、性别歧视等等——与……相比其实都很渺小。如果你相信了这些，它们才会有巨大的杀伤力。如果你相信了别人对你的评价，相信了他们对你做的事，那就会毁了你。但如果你说：“那不是我”，你几乎可以克服任何困难。他出了一本关于这个主题的新书，我觉得非常好，因为我认为这才是成功的关键。

---

### [00:09:52] Lenny Rachitsky

**English:**
If you look at all the writing you've done, it's essentially about the struggle and pain and suffering of being a CEO, your first [inaudible 00:09:59] to Hard Thing About Hard Things. There's a lot of talk these days about just how important struggle is and how valuable it is to go through struggle. Jensen's big on this. He talks a lot about just you have to go through pain and suffering to be a great leader.

**中文翻译:**
回顾你所有的著作，本质上都是关于担任 CEO 的挣扎、痛苦和磨难，从你的第一本书《创业维艰》开始就是如此。最近有很多人在讨论“挣扎”有多重要，以及经历磨难的价值。黄仁勋（Jensen Huang）非常推崇这一点，他经常谈到要成为一名伟大的领导者，你必须经历痛苦和磨难。

---

### [00:10:12] Ben Horowitz

**English:**
You don't really have a choice. That's true.

**中文翻译:**
你其实别无选择。确实如此。

---

### [00:10:15] Lenny Rachitsky

**English:**
There's something that I saw you share that I love, which is running towards fear versus running away from fear. Something that you tell all your leaders to work on. Easy to hear, hard to do. We don't like doing things that are scary, running towards things that are scary. Why is this so important? Why is this something people need to learn to do?

**中文翻译:**
我看到你分享过一个我很喜欢的观点，那就是“奔向恐惧”而不是“逃避恐惧”。这是你要求所有领导者去努力做到的。听起来容易，做起来难。我们都不喜欢做可怕的事，更别说奔向它们了。为什么这如此重要？为什么人们需要学会这样做？

---

### [00:10:33] Ben Horowitz

**English:**
Well, so the biggest mistake that you make, the worst thing that you do as a leader, there's things in your control and there's things out of your control and hesitation, that's generally the most destructive. And I go through all the ways that it's destructive, but it's extremely bad. And the thing that causes you to hesitate is both decisions are horrible. It's that business school where you're going through a case study, "And if you had done that, then the company would have gone this way. But if you had done that, it's a great success." That's not actually what happens to you as CEO.

**中文翻译:**
作为领导者，你犯下的最大错误、做得最糟糕的事——在你能控制和不能控制的事情中——通常就是“犹豫”，这是最具破坏性的。我分析过它造成破坏的各种方式，后果极其严重。而让你犹豫的原因往往是两个选项都糟透了。商学院的案例研究通常是：“如果你做了 A，公司会这样；如果你做了 B，就会大获成功。”但在现实中，作为 CEO，情况并非如此。

---

### [00:11:16] Ben Horowitz

**English:**
What happens to as CEO, it's like, "Okay, if we rearchitect, this product, the architecture is not actually get us to where we need to go. I kind of know that. But if we rearchitect it, we're going to probably miss all the features, miss the quarter, have trouble raising money, shudder, et cetera. So that's really bad. And then not rearchitecting is really bad, and so I'm just going to try to and avoid this subject because I don't even want to deal with either of those." And that's the worst thing, because if action is the better choice and that's good. And then if you don't make an explicit decision, then the whole company's going to get nervous because they know that the architecture is whack and you got to fix it.

**中文翻译:**
作为 CEO，你面临的情况往往是：“好吧，如果我们重构这个产品，现在的架构确实无法带我们到达目的地，我心里清楚。但如果我们重构，可能会错过所有功能交付，错过季度目标，融资困难，甚至公司倒闭等等。所以这很糟糕。但不重构也很糟糕。于是我干脆回避这个话题，因为我哪一个都不想面对。”这就是最糟糕的情况。因为如果行动是更好的选择，那就去做。如果你不做明确的决定，整个公司都会变得焦虑，因为他们知道架构已经烂透了（whack），必须修理。

---

### [00:12:07] Ben Horowitz

**English:**
And probably one of my bigger ones on that was we went public with $2 million in trailing 12 months revenue at 18 months old. That's obviously a bad idea. I mean, there's no question that wasn't a bad idea. But the truth of it was the alternative because of where the private markets were was going bankrupt. And that's a worse idea.

**中文翻译:**
我经历过的最重大的抉择之一，就是我们在公司成立 18 个月、年营收仅 200 万美元时上市。这显然是个坏主意，毫无疑问。但事实是，考虑到当时的私募市场环境，另一个选择就是破产。而破产是更坏的主意。

---

### [00:12:34] Ben Horowitz

**English:**
And if you look at that time, March of 2001 when we went public, you just look at the number of CEOs that hesitated on that and didn't do it and went bankrupt. It's a lot. And so that getting good at making a decision that everybody's going to go, "Wow, that was insane, Ben." The Wall Street Journal wrote a whole long story about how stupid I was. And then Businessweek wrote a story called the IPO From Hell. That was the name of our idea, the IPO from hell, which was accurate in a sense.

**中文翻译:**
看看 2001 年 3 月我们上市的时候，有多少 CEO 因为犹豫而没有这样做，最终导致破产。数量惊人。所以，你要擅长做出那种让所有人都惊呼“哇，Ben 你疯了”的决定。《华尔街日报》曾写过长篇大论说我有多愚蠢，《商业周刊》甚至写了一篇名为《来自地狱的 IPO》的文章。那是对我们想法的称呼，某种意义上说，这个形容很准确。

---

### [00:13:13] Ben Horowitz

**English:**
So that's really bad, but it wasn't as bad, and this is why it's so scary you make that decision that's going to happen. I knew those stories would get written, there was no question. And yeah, that's the kind of muscle. So if you think about the psychological muscle you have to build to be a great leader is to be able to look in the abyss and go, "Okay, that way slightly better. We're going to go that way. And it's very hard to do." I would say it's a thing people struggle with. And it began something, should I fire the head of sales? So I don't want to have that conversation. And then I'll have to replace them. And then there's going to be a bad PR story. And you can kind of quickly calculate all the bad stuff that's going to happen if you do it. But if you don't do it, that's probably going to be much worse and that's why you have to run towards the pain in darkness.

**中文翻译:**
所以那确实很糟，但还没到最糟的地步。这就是为什么做决定如此可怕，因为你知道后果会发生。我当时就知道那些负面报道会出现，毫无疑问。这就是那种需要锻炼的“肌肉”。如果你想成为伟大的领导者，你必须建立这种心理素质：能够凝视深渊并说：“好吧，那条路稍微好一点，我们就走那条路。”这非常难做到。我认为这是人们最挣扎的地方。比如：我该解雇销售主管吗？我不想进行那场谈话，解雇后还得找人替代，还会有负面公关。你可以迅速算出如果做了这件事会发生的所有坏事。但如果你不做，后果可能会更严重。这就是为什么你必须在黑暗中奔向痛苦。

---

### [00:14:13] Lenny Rachitsky

**English:**
What is the advice you share with founders? Because as you said, it's very hard to do this, just what helps them actually get better at this? Is it just Ben being by their side telling them this is how it is? Is there anything else you can share?

**中文翻译:**
你给创始人们什么建议？正如你所说，这很难做到。有什么能帮助他们真正变得擅长此道吗？仅仅是 Ben 陪在他们身边告诉他们“事实就是这样”吗？还有什么可以分享的吗？

---

### [00:14:23] Ben Horowitz

**English:**
No, no. I would say this is one where I can't really coach you to be good at this. I can point it out so that you recognize that you were slow or whatever. But it's kind of like I always liken when I talk to them, it's like football. You can have a really fast great athlete, but if they don't trust their eyes, if they don't run to the ball when they see it, if they think, "Oh, maybe that was a fake," then they're that step slower and then they'll never be as good. And CEOs are like that. If you don't trust what you see and you don't run at it, then you're just not going to be good. And it's hard to get CEOs not to hesitate. But look, the thing that does help is they look at it and I look at it and I confirm, "No, that is as it appears."

**中文翻译:**
不，不。我想说，这方面我无法通过“教练”的方式让你变强。我可以指出来，让你意识到自己反应慢了。但我常对他们打比方，这就像美式橄榄球。你可以有一个速度极快、天赋异禀的运动员，但如果他不相信自己的眼睛，看到球时不立刻冲过去，而是想“哦，那可能是个假动作”，那他就慢了一步，永远无法达到顶尖水平。CEO 也是如此。如果你不相信自己看到的并果断出击，你就不会优秀。让 CEO 不犹豫很难。但有帮助的一点是，当他们观察情况时，我也在观察，然后我确认：“没错，情况确实如你所见。”

---

### [00:15:23] Ben Horowitz

**English:**
And sometimes they're afraid of the conversation. So that one I can help with. So A CEO might be afraid, like they want to do something but they don't know how to say it. They don't know how to have the conversation with the employee so I can walk them through that. I had an instance where the CEO said, "Hey, I need your help, Ben. My CTO, he's an asshole." And I was like, "Okay, great." I said, "But you're not going to fire him because I know he's a good CTO, or are you asking me should you fire him?" He said, "No, no, I don't want to fire him." And I was like, "So you're asking me what to do? You don't know how have that conversation with him about being an without him quitting. That's what you're saying?" And he goes, "Yeah, that's the problem."

**中文翻译:**
有时他们是害怕那场谈话。这方面我可以帮忙。CEO 可能会害怕，比如他们想做某事但不知道怎么开口，不知道如何与员工沟通。我可以引导他们。我曾遇到一个案例，CEO 说：“嘿，Ben，我需要你的帮助。我的 CTO 是个混蛋（asshole）。”我说：“好极了。但你不会解雇他，因为我知道他是个优秀的 CTO，还是说你在问我是否该解雇他？”他说：“不，不，我不想解雇他。”我说：“所以你在问我该怎么办？你不知道如何在不让他辞职的情况下，就他表现得像个混蛋这件事跟他谈谈。是这个意思吗？”他说：“对，这就是问题所在。”

---

### [00:16:09] Ben Horowitz

**English:**
And so I go, "Well, why is he an asshole?" And he says, "Well, he's an asshole because the other day he made a very junior young woman in our finance organization cry." And I was like, "Yeah, I got you." I said, "Look, this is what I would say to him. I'd say I just sit them down and I would say, 'Look, you're a really good director of engineering because you do a great job at managing the team, get the products out, all that. But you're not really a CTO because to be a CTO, you have to be effective with other parts of the organization. You can't just be effective only with engineering. And making somebody cry, she's never going to do anything you want. You lost all effectiveness with all of finance by doing that. And so if you want to get good at that, I'll help you. I'll work with you on it, but if you don't, I'm going to have to hire a CTO at some point because obviously I need that.'" And then he was like, "Oh, okay, I can have that conversation. I can't have the conversation that, 'Hey, you're an asshole,' because I don't want them to quit, but I can have the conversation that's more specific." And a lot of getting people not to hesitate is just getting them over that.

**中文翻译:**
于是我问：“他怎么混蛋了？”他说：“他前几天把财务部门一个非常资浅的年轻女同事给骂哭了。”我说：“明白了。听着，如果是我，我会这样对他说：‘听着，你是一个非常优秀的工程总监，因为你管理团队、交付产品都做得很好。但你还不是一个真正的 CTO，因为要当 CTO，你必须能与组织的其他部门有效协作，而不仅仅是工程部。你把人家弄哭了，她以后再也不会配合你了。你这样做，在整个财务部面前都失去了影响力。如果你想在这方面提高，我会帮你，我们可以一起努力；但如果你不想改，我迟早得雇一个新的 CTO，因为我显然需要一个能胜任的人。’”然后那位 CEO 说：“哦，好吧，这种谈话我可以谈。我没法直接说‘嘿，你是个混蛋’，因为我不想让他辞职，但我可以进行这种更具体的谈话。”很多时候，让人们不再犹豫，就是帮他们跨过这个坎。

---

### [00:17:20] Ben Horowitz

**English:**
And so often, and I would say early in a CEO's career, a lot of it is just not knowing how to have the conversation.

**中文翻译:**
很多时候，尤其是在 CEO 职业生涯的早期，很大一部分问题仅仅是不知道如何开启那场谈话。

---

### [00:17:29] Lenny Rachitsky

**English:**
There's also I imagine an element of I just want to be liked. I don't want people to hate me. You have this great line that you want to be liked and respected in the long run, not the short run.

**中文翻译:**
我猜还有一个因素是“我想被大家喜欢”，我不想让人讨厌。你有一句名言：你应该追求在长远中被喜欢和尊重，而不是短期。

---

### [00:17:37] Ben Horowitz

**English:**
Yeah, that's tricky. By the way, I have to deal with this in the firm too, and people want to be entrepreneur friendly. I'm like, "No, it's not friendly. Respectful. But you've got to be able to tell them the truth in a way that you probably don't tell most of your friends the truth." Because your friend, look anthropologically, we want people to like us. It's just so they don't throw us to the lion or whatever. That's just kind of a thing. So you say tell people what they want to hear, but in dealing at a company level in a context of you're on the board of somebody's company, you've got to be able to tell them what they don't want to hear. That's the most important thing you're going to say.

**中文翻译:**
是的，这很微妙。顺便说一下，我在公司里也要处理这个问题，大家总想对创业者“友好”。我说：“不，不是友好，是尊重。但你必须能够以一种你可能不会对大多数朋友说实话的方式告诉他们真相。”因为从人类学的角度看，我们希望被喜欢，这样别人才不会把我们扔给狮子。这是一种本能。所以你会挑别人爱听的说。但在公司层面，作为董事会成员，你必须能说出他们不想听的话。那才是你将要说的最重要的话。

---

### [00:18:22] Ben Horowitz

**English:**
And yes, they're not going to like it when you say it, there's no question. But over time it could save the company. And all the most important things I've said are things that I've said to CEOs that they did not want to hear. And that's what the leadership is about. If everybody agrees with the decision, then you didn't add any value because they would've done that without you. So the only value you ever add is when you make a decision that most people don't like and that's where leadership comes in because you know that's where it's got to get to. And that's the thing that takes practice.

**中文翻译:**
没错，当你开口时，他们肯定不会喜欢。但随着时间的推移，这可能会救了公司。我所说过的所有最重要的话，都是 CEO 们不想听的话。这就是领导力的意义所在。如果每个人都同意某个决定，那你根本没有增加任何价值，因为没有你他们也会这么做。所以，你唯一的价值体现就是当你做出了大多数人都不喜欢的决定时，这就是领导力发挥作用的地方，因为你知道那是必须达到的目标。而这需要练习。

---

### [00:19:05] Ben Horowitz

**English:**
I think when Jensen talks about luck, you've got to get to near death to get yourself to do that. That's true. It's hard to build that if everything's going great. And I would say the CEOs who had an easy run of it for their, let's say, they just launched a product that's an instant hit, it's very hard for them to develop that muscle compared to the ones that built a company like Jensen where he gutted it out for multiple decades before they had big success.

**中文翻译:**
我想当黄仁勋谈到运气时，他的意思是，你必须经历过濒死体验才能逼自己做到那一点。确实如此。如果一切顺风顺水，很难建立这种素质。我想说，那些一帆风顺的 CEO——比如刚发布产品就瞬间爆红——与像黄仁勋那样在获得巨大成功前苦熬了几十年的人相比，很难锻炼出这种心理素质。

---

### [00:19:36] Lenny Rachitsky

**English:**
Clearly, it's very difficult and painful to be a CEO, to be a founder. In spite of that so many people want to start companies. So many people dream of having their own company. Who is not right to start a company? What advice do you share with folks that are thinking about starting a company that may not understand just what they're about to get into?

**中文翻译:**
显然，当 CEO 和创始人非常困难且痛苦。尽管如此，还是有那么多人想创业，梦想拥有自己的公司。什么样的人不适合创业？对于那些想创业但可能还不了解自己将面临什么的人，你有什么建议？

---

### [00:19:57] Ben Horowitz

**English:**
Yeah, so it's funny. So there's a couple of things. John Reed, who was the CEO of Citigroup when I started as CEO, said to me something I never forget. He said, "Ben, the only reason to start a company is because you have an irrational desire to do so, because it's not worth the money." And I was like, "Wow, he doesn't even quantify how much money and this guy's running Citigroup." So he is a very numbers, banking guy and he didn't quantify it. And I remember when we sold LoudCloud for $1.6 billion, I remember thinking, "Wow, that wasn't worth the money whatsoever."

**中文翻译:**
这很有趣。有几件事。当我刚开始当 CEO 时，花旗集团当时的 CEO John Reed 对我说了一句让我终生难忘的话。他说：“Ben，创业的唯一理由是你有一种非理性的冲动（irrational desire）想去这么做，因为为了钱是不值得的。”我当时想：“哇，他甚至没有量化是多少钱，而这家伙可是掌管花旗集团的人。”他是个非常看重数字的银行家，却没能量化它。我记得当我们以 16 亿美元卖掉 LoudCloud 时，我心想：“哇，这辛苦程度跟赚的钱比起来，一点都不值。”

---

### [00:20:37] Ben Horowitz

**English:**
So I think if you're doing it for the money, that's a very bad reason and it will be extremely difficult to get you an outcome. You really have to have an irrational desire to do something larger than yourself to improve the world in some way that somehow that is your purpose. And if you don't feel that, then you'll never get through it. It's just too many bad things happen along the way.

**中文翻译:**
所以我觉得如果你是为了钱而创业，那是个非常糟糕的理由，而且你很难坚持到最后。你必须有一种非理性的渴望，去做一些超越自我的事情，以某种方式改善世界，并将其视为你的使命。如果你没有这种感觉，你永远无法熬过去。这一路上发生的坏事实在太多了。

---

### [00:21:08] Lenny Rachitsky

**English:**
So then how do you think of founders that are looking around for ideas that brainstorm, that look for market opportunities versus come from, "I have this a mission, I've got to do this thing in the world."

**中文翻译:**
那你怎么看那些四处寻找点子、进行头脑风暴、寻找市场机会的创始人，而不是那种“我有一个使命，我必须在世界上完成这件事”的创始人？

---

### [00:21:19] Ben Horowitz

**English:**
My business partner Mark always talks about that. So if you have a product that forces you to build a company, that is a great case of it, right? Okay, you built something and the world wants it and you need a company to deliver it, you know, already have the right product. And so that's very helpful.

**中文翻译:**
我的合伙人 Mark 经常谈到这一点。如果你有一个产品，它“迫使”你必须建立一家公司来承载它，那就是一个极好的案例。你造出了世界需要的东西，而你需要一家公司来交付它，这意味着你已经有了正确的产品。这非常有帮助。

---

### [00:21:37] Ben Horowitz

**English:**
I think there are cases of people, I think Hewlett-Packard was built that way, that they're like, "Okay, we've got to build technology," it was that abstract, "We've got built in technology for the world." And then they started with, "Well, what do you need?" They called it the next bench thing. What does the engineer sitting next to me need? The next engineer on the bench? So how they define the first set of products.

**中文翻译:**
我认为也有另一种情况，惠普（HP）似乎就是这样建立的。他们当时想：“好吧，我们要开发技术”，就是这么抽象，“我们要为世界开发技术”。然后他们从“你需要什么？”开始。他们称之为“隔壁实验台”（next bench）理念：坐在我旁边的工程师需要什么？实验台上的下一位工程师需要什么？这就是他们定义第一批产品的方式。

---

### [00:22:03] Ben Horowitz

**English:**
So it can work the other way, but I think the thing that is in common is it's just a very abstract idea that you have to build something that's going to be important that people are going to like working there, people are going to benefit from the products. You have to have some weird concept other than, "Oh, this is going to be successful and I'm going to make a lot of money." I think way better off taking Zuck's offer at Meta and just doing that. That's a way better deal.

**中文翻译:**
所以另一种方式也行得通，但我认为共同点在于：你必须有一个非常抽象的信念，即你要建立一些重要的东西，让人们喜欢在那里工作，让人们从产品中受益。你必须有一些除了“哦，这会成功，我会赚大钱”之外的某种执念。否则，我觉得还不如接受扎克伯格在 Meta 的 Offer，直接去那儿干。那划算得多。

---

### [00:22:37] Lenny Rachitsky

**English:**
Along these lines, something else Shaka suggested I ask you about, apparently there's a story where the CEO of Databricks asked you for $200,000 in the early days and you said no. And it's not because you didn't want to invest and it was more about helping them think bigger. What happened there?

**中文翻译:**
顺着这个话题，Shaka 还建议我问你另一件事。据说有一个故事：Databricks 的 CEO 早期找你要 20 万美元，你拒绝了。并不是因为你不想投资，而是为了帮他们想得更远大。当时发生了什么？

---

### [00:22:55] Ben Horowitz

**English:**
So there were six of them, they were six PhD student, well, and Ion Stoica who was their professor. And Ion was this super genius, but when I met with them, they were like, "We need to raise $200,000." And I knew at the time that what they had was this thing called Spark and the competitor was something called Hadoop. And Hadoop had very well-funded companies already running towards it and Spark was open source, so the clock was ticking.

**中文翻译:**
当时他们有六个人，六个博士生，还有他们的教授 Ion Stoica。Ion 是个超级天才。但我见到他们时，他们说：“我们需要筹集 20 万美元。”我当时知道他们手里有这个叫 Spark 的东西，而竞争对手是 Hadoop。Hadoop 已经有资金非常雄厚的公司在全力推进了，而 Spark 是开源的，时间紧迫。

---

### [00:23:39] Ben Horowitz

**English:**
And I think they didn't quite know what they had. And then there's also a thing always, although I wouldn't say Ion has this mentality, but professors in general it's a pretty big win if you start a company and you make $50 million. You're a hero on campus. That's a pretty cool thing to have done. And so I'm always a little nervous about a company that comes out of academia thinking too small anyway.

**中文翻译:**
我觉得他们当时并不完全清楚自己手里握着什么样的宝藏。而且总有这样一种情况——虽然我不是说 Ion 是这种心态，但通常对于教授来说，如果你创办一家公司赚了 5000 万美元，那就是巨大的胜利，你就是校园英雄。这确实很酷。所以我总是对学术界出身的公司有点担心，怕他们想得太小。

---

### [00:24:09] Ben Horowitz

**English:**
And so I said, "Look, I'm not going to write you a check for $200,000. I'll write you a check for $10 million because this company, you need to build a company. You need to really go for it if you're going to do this, otherwise you guys should stay in school." And they were all graduating right then, so that was kind of that. And Ali actually was VP of engineering at the time, and it was a while before I made him CEO and that was very good luck on my part because I had no idea that they had a guy that good inside the company who could become CEO when I invested. That was just, God smiled on me and gave me that one.

**中文翻译:**
所以我说：“听着，我不会给你们开 20 万美元的支票。我会给你们开 1000 万美元的支票，因为你们需要建立一家真正的公司。如果你们要做这件事，就必须全力以赴，否则你们还是留在学校吧。”当时他们正好都要毕业了，事情就是这样。Ali 当时其实是工程副总裁，过了一段时间我才让他担任 CEO。那是我的运气好，因为我投资时并不知道公司内部竟然有一个这么优秀、能胜任 CEO 的人。那是上帝眷顾我，给了我这个机会。

---

### [00:24:54] Lenny Rachitsky

**English:**
So speaking of Ali, I actually asked him what to ask you about, and he immediately shared this story. I don't know if you remember this. In your first one-on-one with him, after you made him CEO, he was struggling with a bunch of low performers because he was coming in to lead the company and he was trying to turn things around, trying to coach them, trying to level them up. And your advice to him was quote, "You don't make people great. You find people that make you great, that make the company great, that you learned from, not the other way around." And there's something that he called managerial leverage. What is that all about? What's the lesson there?

**中文翻译:**
说到 Ali，我其实问过他该问你什么，他立刻分享了这个故事。不知道你还记不记得。在你任命他为 CEO 后的第一次一对一谈话中，他正为一群表现不佳的员工感到苦恼。他刚开始领导公司，试图扭转局面，尝试指导他们、提升他们。你给他的建议是：“你无法让平庸的人变得伟大。你应该寻找那些能让你变得伟大、让公司变得伟大、能让你从他们身上学习的人，而不是反过来。”Ali 把这称为“管理杠杆”（managerial leverage）。这到底是怎么回事？其中的教训是什么？

---

### [00:25:27] Ben Horowitz

**English:**
Oh yeah, yeah. So understand, he had just become CEO. So I was teaching him, he had been VP of Engineering and CEO is different. And I'll get into why and what I mean by leverage. So I actually wrote a post about this with a little Lil Wayne quote where I think the quote was, "The truth is hard to swallow and hard to say too but I graduated from that bullshit, now I hate school." And that was always my feeling about this particular idea was, look, if you're VP of engineering, you can develop people. You can teach them to be better engineers. You can teach them, be better engineering managers. That's very doable.

**中文翻译:**
哦，是的。要理解，他当时刚当上 CEO。我是在教他，他以前是工程副总裁，而 CEO 是不同的。我会解释为什么，以及我所说的“杠杆”是什么意思。我其实写过一篇关于这个的文章，引用了 Lil Wayne 的一句歌词，大意是：“真相难以吞咽，也难以启齿，但我已经从那些废话中毕业了，现在我讨厌学校。”我对这个观点的看法一直是：如果你是工程副总裁，你可以培养人才。你可以教他们成为更好的工程师，教他们成为更好的工程经理。这是非常可行的。

---

### [00:26:08] Ben Horowitz

**English:**
But if you're a CEO, what do you know about being CFO? Like what do you know about being VP, HR? What do you know about any of these jobs except maybe VP of engineering? And so the idea that you're going to take somebody who isn't world-class at marketing and make and you them world class and you don't know anything about marketing, is a dumb idea. It just doesn't work.

**中文翻译:**
但如果你是 CEO，你对如何当 CFO 了解多少？你对如何当人力资源副总裁了解多少？除了工程副总裁，你对这些职位几乎一无所知。所以，如果你想把一个在营销方面不是世界级的人培养成世界级，而你自己对营销又一窍不通，这就是个愚蠢的想法。这根本行不通。

---

### [00:26:34] Ben Horowitz

**English:**
And then the company can't afford for you to be spending time on that because they need you to make very high quality, fast decisions. They need you to set the direction for the company and they need you to have a world-class team. And so it's a very hard lesson if you've been VP of engineering because if you're a good VP of engineering, you do develop your people. But as a CEO, it's not like you don't do any of it, but it is very, very small compared to it. So I like to make things just very stark. So you get what I'm saying? I don't like to hedge it.

**中文翻译:**
而且公司也负担不起你把时间花在这上面，因为他们需要你做出高质量、快速的决策。他们需要你为公司设定方向，需要你拥有一支世界级的团队。如果你以前是工程副总裁，这一课会非常难学，因为优秀的工程副总裁确实会培养下属。但作为 CEO，虽然不是完全不培养人，但那占的比重非常小。我喜欢把事情说得很绝对，你明白我的意思吗？我不喜欢含糊其辞。

---

### [00:27:08] Ben Horowitz

**English:**
And then managerial leverage means it is very simple. It's okay. If I have the ideas about what your department should do next. If I am kind of pushing you to kind of move your organization forward, then that's no leverage. What's leverage is if you're telling me what you should do and how you can push the company forward, that's leverage, then I'm getting more than I'd have if you weren't there otherwise I could just manage a team.

**中文翻译:**
所谓的“管理杠杆”其实很简单。如果关于你部门下一步该做什么的想法都来自我，如果是我在推着你前进，那就没有杠杆。真正的杠杆是：你告诉我你应该做什么，以及你如何推动公司前进。这就是杠杆，这意味着因为有你在，我得到了比没有你时更多的产出，否则我直接自己去带那个团队就好了。

---

### [00:27:39] Ben Horowitz

**English:**
And that's the point when you feel like you're not getting leverage. When you got to go say, "Hey, why aren't we doing this? Why aren't we doing that?" That's when you got to make a change. And by the way, he's unbelievable at that, as good as anybody I've seen as a guy who's not callous as a CEO. He really cares about the people who work for him. He really wants him to have great careers and all that, but he does not hesitate. If he's losing leverage, he'll make a move.

**中文翻译:**
当你觉得没有获得杠杆时，就是那个转折点。当你不得不去问：“嘿，为什么我们不做这个？为什么不做那个？”那就是你需要做出改变的时候。顺便说一下，Ali 在这方面做得不可思议，他是我见过的最优秀的 CEO 之一，而且他并不是一个冷酷无情的人。他真的很关心为他工作的人，真心希望他们有好的职业发展，但他绝不犹豫。如果他失去了杠杆，他就会采取行动。

---

### [00:28:06] Lenny Rachitsky

**English:**
Kind of going back to the origin story of A16Z something you guys were really big on was helping founders stay CEOs become great CEOs, not replace them with professional CEOs. I want to flip this question on you. When does it actually make sense to replace CEO? When are people not going to make great CEOs?

**中文翻译:**
回到 A16Z 的创立初衷，你们非常坚持的一点是帮助创始人留任 CEO 并成为伟大的 CEO，而不是用职业经理人替换他们。我想反过来问你：什么时候替换 CEO 才是合理的？什么样的人注定无法成为伟大的 CEO？

---

### [00:28:26] Ben Horowitz

**English:**
There's a very consistent thing that happens, which is when somebody doesn't make it and it kind of starts with confidence is the way I would put it. So if you invent a product, you kind of recruit a team so forth, all of a sudden you're CEO, but you don't run a big organization, you don't know how to do that. Most founders are like that. And so, if you don't know what you're doing, you're going to make mistakes and they all make a lot of mistakes. And then when you make those mistakes, they're very expensive. They could cost you to do a down round or they could cost you to lose a company or they could cost you a customer or you scrub the product. They're very high impact and not just on you, but everybody who you talked into joining you. And so that kind of motion can really cause you to lose confidence.

**中文翻译:**
失败的情况通常有一个非常一致的模式，我认为是从“信心”开始的。如果你发明了一个产品，招募了一个团队，突然间你就成了 CEO，但你从未管理过大型组织，你不知道该怎么做。大多数创始人都是这样。因为你不知道自己在做什么，你就会犯错，而且每个人都会犯很多错。这些错误的代价非常昂贵：可能会导致降估值融资（down round），可能会让你失去公司，失去客户，或者毁掉产品。这些影响不仅针对你，还针对所有被你劝说加入的人。这种挫败感会让你丧失信心。

---

### [00:29:20] Ben Horowitz

**English:**
And then if you lose confidence, what happens is you hesitate on the next decision. And as we talked about, hesitation is very dangerous because one, it locks up the company, but even worse what happens is if you have senior people working for you, they get very nervous and they feel like they need to jump into that void and make the decision for you. And that's when it gets political, very political, because people are vying for power inside your little screwed up company.

**中文翻译:**
一旦失去信心，结果就是你在下一个决策上犹豫不决。正如我们聊过的，犹豫非常危险。首先，它会让公司停滞不前；更糟的是，如果你手下有资深员工，他们会变得非常紧张，觉得必须填补那个决策真空，替你做决定。这时候公司就会变得政治化，非常政治化，因为人们开始在你那间乱成一团的小公司里争权夺利。

---

### [00:29:57] Ben Horowitz

**English:**
And so now you've got a political dysfunctional organization and that's generally where, okay, the founder probably can't run this thing anymore. That's how it happens. So most of what we do as a firm is to try to help people with that confidence problem and there's a whole series of ideas that we have around that, but you kind of have to somehow climb the confidence and the competency curve together. It's very hard to do and particularly if you're an engineer and you're used to getting things right or if you've been a straight A student or something like that, it's very disconcerting. Sometimes it's better to have CEOs who are like C minus students.

**中文翻译:**
现在你拥有了一个政治化且功能失调的组织，通常到这一步，创始人可能就没法再管理下去了。这就是过程。所以我们公司做的大部分工作就是试图帮助人们解决信心问题，我们有一系列相关的理念。但你必须设法让信心曲线和能力曲线同步上升。这很难做到，尤其是如果你是工程师出身，习惯了把事情做对，或者你一直是全 A 的优等生，这种挫败感会让你非常不安。有时候，找那些拿 C- 的学生当 CEO 反而更好。

---

### [00:30:45] Lenny Rachitsky

**English:**
Why is that?

**中文翻译:**
为什么呢？

---

### [00:30:45] Ben Horowitz

**English:**
Yeah, a little facetious. Well, it's just good to be used to failing. So I think I wrote this, but the median on the CEO kind of test is like 18. It's not like 90. And so you got to be comfortable getting a lot of D minuses because the D minus is fine, as long as you don't get the F, as long as you don't run out of cash, as long as you don't lose all thing. Okay, you got through it, keep going. And match, that's a lot of the thing that we try to do CEOs.

**中文翻译:**
哈哈，有点开玩笑。其实是因为习惯失败是件好事。我想我写过这个：CEO 考试的平均分大概只有 18 分，而不是 90 分。所以你必须习惯拿一堆 D-，因为拿 D- 没关系，只要不拿 F 就行——只要不耗尽现金，只要不输掉一切。好吧，你熬过去了，继续前进。这就是我们试图帮助 CEO 建立的心态。

---

### [00:31:20] Lenny Rachitsky

**English:**
Yeah, it comes back to your core, I don't know, message through your first book is just how much you'll fail and how much you'll struggle and how much paid you'll go through as CEO.

**中文翻译:**
是的，这回到了你第一本书的核心信息：作为 CEO，你会经历多少失败、多少挣扎以及多少痛苦。

---

### [00:31:29] Ben Horowitz

**English:**
Yeah, yeah, and I mean a lot of why I wrote that book was just to normalize it. I think what happens is, particularly when I wrote it, and I think it's come back and been true now, is the way the narrative gets written on all these successes is like, "Oh, they came up with a genius idea and then they built this company and they hired all these smart people and it was all great." But that's not at all how it happens and I've spent enough time with everybody from Mark Zuckerberg to Sam Altman and so forth, that they all go through that same thing that who has your struggling company go through? You screw a lot of things up and they have massive consequences, but you have to maintain your confidence.

**中文翻译:**
没错。我写那本书很大程度上是为了让这种状态“正常化”。我认为，尤其是在我写书的时候（现在依然如此），成功故事的叙事往往是：“哦，他们想出了一个天才的主意，然后建立了公司，雇了一群聪明人，一切都很棒。”但事实根本不是那样。我花了很多时间与马克·扎克伯格、萨姆·奥尔特曼等人交流，他们都经历过和你那间挣扎中的小公司一样的事情。你会搞砸很多事，产生严重的后果，但你必须保持信心。

---

### [00:32:19] Lenny Rachitsky

**English:**
Actually, I was at a storytelling event last night and I was chatting with someone that I ran into there and told her I was chatting with you today, and she said how meaningful your first book was to her as a founder. Exactly as you said, normalizing that it's very hard and painful and this is just the way it is.

**中文翻译:**
实际上，我昨晚参加了一个讲故事的活动，遇到一个人，我告诉她今天会和你聊天。她说你的第一本书对作为创始人的她意义重大。正如你所说，它让那种艰难和痛苦变得正常化了，让人知道事实就是如此。

---

### [00:32:36] Ben Horowitz

**English:**
And the feeling, look, if you think about organizational design or goals and objectives or OKRs or whatever management technique, you need a basic eighth grade education to do any of that stuff. It is not that complicated. The difficult part is the feeling that you have when you have to do it is very, the hard thing of matter a reorg is you're redistributing power, so you're going to have people really fricking mad at you because somebody's losing power if you do it correctly. And that person may be a really good employee. Dealing with that is the hard thing. Knowing how the organization should work to make communication better, it's not that complex.

**中文翻译:**
那种感觉……你看，如果你考虑组织设计、目标设定或 OKR 之类的管理技术，只要有初二水平就能搞定。这些并不复杂。难点在于当你必须去做这些事时的那种“感觉”。重组（reorg）最难的地方在于你在重新分配权力，如果你做得对，肯定会有人对你大发雷霆，因为有人失去了权力。而那个人可能还是个非常优秀的员工。处理这种情绪才是难点。至于如何设计组织让沟通更顺畅，那并不复杂。

---

### [00:33:18] Lenny Rachitsky

**English:**
Yeah, I think about I was at Airbnb for a long time and just thinking of Brian, who I don't know even know if he had a job before Airbnb now.

**中文翻译:**
是的，我在 Airbnb 待了很长时间，想到 Brian（Chesky），我甚至不知道他在创办 Airbnb 之前有没有过正式工作。

---

### [00:33:25] Ben Horowitz

**English:**
Oh yeah. I spent a lot of time with Brian and after COVID, it all kind of clicked for him and then he did that he and that good talk on founder mode and so forth. But the reason that was so articulate is he had screwed every one of those things up and he hired LT and all this stuff, and these are very senior people and he wanted to defer to them, but you can't defer as the CEO because you know what Airbnb should be doing. He may know what finance should do, but you know what Airbnb should do and this kind of thing. And then it gets really wild when you can't defer decisions as the CEO. You got to understand what people are saying and go, "Now we're going to do this."

**中文翻译:**
噢，是的。我和 Brian 交流过很多次。疫情之后，他突然开窍了，然后他发表了关于“创始人模式”（founder mode）的精彩演讲。他之所以能讲得那么透彻，是因为他把那些坑全踩了一遍。他雇了高管团队（LT），那些都是非常资深的人，他本想放权给他们，但作为 CEO 你不能完全放权，因为只有你最清楚 Airbnb 应该做什么。高管可能知道财务该怎么搞，但你知道 Airbnb 该往哪走。当你作为 CEO 无法推卸决策责任时，情况会变得非常激烈。你必须听取大家的意见，然后拍板：“现在，我们要这么做。”

---

### [00:34:13] Lenny Rachitsky

**English:**
And this again comes back to the point of you have to go through the struggle and pain and failure to learn those lessons.

**中文翻译:**
这又回到了那个观点：你必须经历挣扎、痛苦和失败才能学到这些教训。

---

### [00:34:18] Ben Horowitz

**English:**
Yeah, no. They're really hard to learn without doing and often without paying the consequence. Even I, like I make mistakes. I was having conversation with Ali the other day and I was like, he's like, "How's it going Ben?" And I was like, "Well, I'm finally dealing with something that I had put off for a very long time." And he said, "Why'd you put it off?" I said, "Because things were going too good. I didn't have to deal with it. "And he was like, "Yeah." He said, "I know that." I'd say Ali is one of the, if not the kind of best private company CEO out there, and he's making a mistake and I'm making a mistakes. So, it is just tough.

**中文翻译:**
没错。如果不亲身实践，不承担后果，这些东西很难学会。即使是我也会犯错。前几天我和 Ali 聊天，他问：“最近怎么样，Ben？”我说：“好吧，我终于在处理一件拖了很久的事情了。”他问：“为什么拖着？”我说：“因为之前一切都太顺利了，我不需要去面对它。”他说：“是的，我懂。”Ali 即使不是最顶尖的，也是目前最优秀的私营公司 CEO 之一，他会犯错，我也会犯错。这真的很不容易。

---

### [00:35:01] Lenny Rachitsky

**English:**
You said that one of maybe the main reason founders fail the CEOs is they lose confidence, and you had some ideas that you guys have to help founders work through that. Are there a couple you can share how you help?

**中文翻译:**
你提到创始人作为 CEO 失败的主要原因之一是丧失信心，而你们有一些方法来帮助创始人度过难关。你能分享几个你们是如何提供帮助的吗？

---

### [00:35:12] Ben Horowitz

**English:**
Yeah. So we do a lot of things on that. So the kind of design of the firm is about confidence. So the first thing is, well, what would give you? Well if you can get stuff done. So what if I could give you a network that's as good as Bob Iger's network, day one, the day you stepped into the job. And so we have 600 people at the firm and why is that? Well, most of them are building that network for you, so you can call any CEO or anybody in Washington or any executive or that kind of thing and get them on the phone and they'll talk to you and you can kind of deal with that thing. And then that just makes you feel like a CEO.

**中文翻译:**
是的。我们在这方面做了很多工作。我们公司的设计初衷就是为了建立信心。首先，什么能给你信心？是如果你能把事情办成。所以，如果我能在你上任的第一天，就给你一个像迪士尼 CEO Bob Iger 那样强大的关系网呢？我们公司有 600 人，为什么？因为其中大部分人都在为你构建那个网络。你可以给任何 CEO、华盛顿的任何人或任何高管打电话，他们会接你的电话并和你交谈，帮你处理问题。这会让你觉得自己像个真正的 CEO。

---

### [00:35:55] Ben Horowitz

**English:**
And then we have a lot of people in the firm like myself, who you can talk to on a CEO to CEO basis, as opposed to an investor to CEO, and just kind of feel that. Early in the firm days, we used to do this thing. I think I'm going to bring back in some form this thing called the CEO barbecue. And it was like a lot of people have these events where they bring in speakers and this and that and the other. And I always felt like those were one, they were too many days. And then sometimes what they said wasn't really applicable and that kind of thing.

**中文翻译:**
此外，我们公司有很多像我这样的人，你可以以“CEO 对 CEO”的身份与我们交谈，而不是“投资者对 CEO”，去感受那种氛围。在公司成立早期，我们经常举办一个活动，我想以后会以某种形式恢复，叫“CEO 烧烤会”。很多公司会举办那种请演讲嘉宾的活动，但我总觉得那种活动时间太长，而且嘉宾说的话有时并不适用。

---

### [00:36:32] Ben Horowitz

**English:**
So I said, "Why don't we just have a barbecue?" I would barbecue. We get everybody in my backyard because was 500 people at the peak, which is why at the stuff I couldn't cook that much, that kind of stuff. And then we'd have Larry Page and Mark Zuckerberg and Kanye West, and so you're a CEO in there with portfolio. You're like, "Wow, I must be important. I'm here with all these guys" and we're just hanging out having a drink, eating barbecue. And so then when I go back to my company, I feel like I am somebody. And okay, I might not be perfect at all this, but I am really a CEO. I was at the CEO barbecue, for crying out loud and that kind of thing. But the whole idea was always like, "Okay, do you feel like you can do it?" Because that's half the battle?

**中文翻译:**
所以我说：“为什么我们不直接办个烧烤会呢？”我亲自掌勺。我们把所有人聚在我家的后院——高峰期有 500 人，所以我后来也没法亲自烤那么多肉了。我们会请来拉里·佩奇、马克·扎克伯格和坎耶·韦斯特。你作为一个被投公司的 CEO 待在那儿，你会想：“哇，我一定很重要，我正和这些大人物待在一起。”我们只是在那儿喝酒、吃烧烤、闲聊。当你回到公司时，你会觉得自己是个“人物”。虽然我可能还不完美，但我真的是个 CEO，我可是参加过 CEO 烧烤会的人！整个核心理念就是：“你觉得自己能行吗？”因为信心就赢了一半。

---

### [00:37:29] Ben Horowitz

**English:**
And look, having been in and every CEO has been in a position where they feel like, "Well, maybe I shouldn't be the one running this thing. Maybe it's just too big for me." And that's a bad, you don't want to go there. And because as we've said, founders can get to the next product and that's something that almost no professional CEO is able to do. There've been rare cases, but very rare.

**中文翻译:**
听着，每个 CEO 都曾有过这种念头：“也许我不该是管理这家公司的人，也许这对我来说太难了。”这很糟糕，你不能陷入这种情绪。因为正如我们所说，创始人能够开发出下一个产品，而这几乎是任何职业经理人 CEO 都做不到的。虽然有罕见的例外，但极其少见。

---

### [00:37:57] Lenny Rachitsky

**English:**
So clearly you've worked with a lot of companies, a lot of founders. Let me kind of zoom out a little bit and ask you this question. What's the most counterintuitive lesson you've learned about building companies that goes against common startup wisdom?

**中文翻译:**
显然你和很多公司、很多创始人合作过。让我把视野放大一点，问你这个问题：在创办公司的过程中，你学到的最反直觉、且违背常见创业常识的教训是什么？

---

### [00:38:09] Ben Horowitz

**English:**
Well, the common startup wisdom keeps changing. One of the early ones that was wrong, and Brian articulated it, and then now I think a little bit of what people have gone to is also wrong. So the first idea that was wrong was like, okay, build a team of senior executives as soon as you get product market fit as fast as possible and they can scale the thing. And I think that you got to build that team slowly and deliberately, kind of pace to your ability to integrate and then manage them. Because if you bring in a bunch of senior people and you don't know really how they match to your company or how that function works or so forth, then you're going to start deferring. And once you start deferring, it's going to get out of control very fast because they're going to build empires, they're going to get political, they're going to do all that kind of thing.

**中文翻译:**
创业常识一直在变。早期有一个错误的观点——Brian（Chesky）也提到过，而现在人们走向的另一个极端我认为也是错的。第一个错误的观点是：一旦达到产品市场契合点（PMF），就尽快组建一支资深高管团队，让他们来规模化业务。我认为你应该缓慢且审慎地组建团队，节奏要匹配你整合并管理他们的能力。因为如果你招了一堆资深人士，却不了解他们是否契合公司，或者不了解那个职能如何运作，你就会开始“放权”。一旦你开始盲目放权，事情会迅速失控，因为他们会建立自己的地盘，搞政治斗争，诸如此类。

---

### [00:39:08] Ben Horowitz

**English:**
So that was bad advice. You kind of have to do it in a measured way. I think that founder mode, I think a lot of people have taken to never hire anybody with experience. And that's also bad advice in that, look, somebody who knows how to do something can really accelerate your thing. So very early on, one of the founders, great founder Arsalan at Databricks was running sales. And I'm like, "Ali, you're going to have to hire somebody who knows sales because Arsalan's, PhD in computer science. I like that, but that's probably not where you're going to have to start if you're going to catch these guys before they take Spark and use it against you."

**中文翻译:**
所以那是坏建议，你必须有节奏地进行。至于现在的“创始人模式”，我觉得很多人误解成了“永远不要雇佣有经验的人”。这也是坏建议。听着，懂行的人真的能加速你的事业。在 Databricks 早期，创始人之一、优秀的 Arsalan 负责销售。我对 Ali 说：“你得雇个懂销售的人，因为 Arsalan 是计算机科学博士。我喜欢他，但如果你想在竞争对手利用 Spark 反击你们之前抢占先机，销售可不能这么搞。”

---

### [00:39:53] Ben Horowitz

**English:**
And I sat down with Arsalan and I explained why. I said, "Look, a lot of what sales, there's a lot of knowledge in how to build a worldwide sales organization; maybe knowledge of customers, territories, territory splitting, rep profiles. There's just a litany of stuff that you really can only learn by doing trial and error and you don't know anything. And so you're phenomenal. Let's get you. And still, he's a very senior executive in the company now, but we need somebody who knows that. And the idea that there are companies that go, " Okay, we're just not going to hire that in founder mode." That's also a mistake. So there's a lot of, it's more subtle than you think, and it's more complex than you think. And so you kind of have to get all the way to the truth. And these little snippets of advice that he sees good, because they watch some fucking podcasts, are all fucking stupid.

**中文翻译:**
我找 Arsalan 谈了，解释了原因。我说：“销售涉及大量知识，比如如何建立全球销售组织、客户知识、领地划分、销售代表画像等等。有一长串的东西你只能通过试错来学习，而你现在一无所知。你很出色，我们会留住你（他现在依然是公司的高管），但我们需要懂行的人。”有些公司觉得“在创始人模式下我们就不雇这种人”，那也是错误的。这比你想象的要微妙和复杂得多。你必须探寻真相。那些因为看了几个该死的播客就觉得很好的零碎建议，全他妈是愚蠢的。

---

### [00:40:51] Ben Horowitz

**English:**
There's a lot of depth to these things. You have to know the answer to the next question, the next question and the next question, and it does drive me crazy. One of the funnier things that happened along these lines, just to show you how little. You know as an investor, about what it means to be CEO. We were at a board dinner. One of the CEOs says to me, he goes, or one of our CEO says, "Hey Ben, that thing you told me a while ago about don't be CEO at home." He said, "I was doing that and I stopped and it really helped me."

**中文翻译:**
这些事情很有深度。你必须知道下一个问题、再下一个问题的答案。这确实让我抓狂。顺便说一件有趣的事，能说明投资者对“当 CEO 意味着什么”了解得多么肤浅。有一次董事会晚宴，一位 CEO 对我说：“嘿 Ben，你之前跟我说‘在家里不要当 CEO’，我以前一直那样，后来我改了，这对我帮助很大。”

---

### [00:41:28] Ben Horowitz

**English:**
And then the other kind of VC said, " Yeah. You got to unplug some time." And I said, I was like, "What the fuck are you talking about? He's CEO. He's not unplugging. He's getting shit all the fucking time. He's got to deal with that. That was not what I meant. I was like, you can't go home and boss your family around. That's what I meant." You hear something from somebody who, but if you haven't done it, you don't even know what that means. And so then you then trying to transfer the advice to the next guy, that's not going to work. So anyway, but he was very innocent. I just don't want to kind of speak bad of him, but that's how it sounds, right? But that's not what it is.

**中文翻译:**
然后另一个风投（VC）接话道：“是啊，你得找时间‘断开连接’（unplug）。”我当时心想：“你他妈在说什么呢？他是 CEO，他没法断开连接。他随时随地都会遇到烂事，他必须处理。我说的不是那个意思。我的意思是，你不能回到家还像在公司一样对家人发号施令。”如果你没亲身经历过，你根本听不懂那些建议的真意。然后你还试图把这种建议传给下一个人，那是行不通的。总之，那个 VC 也是无心的，我不想说他坏话，但外行听起来就是那样，而事实并非如此。

---

### [00:42:09] Lenny Rachitsky

**English:**
That's an amazing story. So the advice partly here, is just don't believe everything you see on Twitter and little sound bites of advice.

**中文翻译:**
这个故事太棒了。所以这里的建议部分是：不要相信你在 Twitter 上看到的一切，也不要迷信那些简短的建议金句。

---

### [00:42:18] Ben Horowitz

**English:**
I think actual CEOs know it. And that's kind of how people in my profession going to get a bad wrap. Because giving advice, that's not something that you know but something that you heard, is very dangerous, I think.

**中文翻译:**
真正的 CEO 都懂。这也是为什么我这个行业（风投）名声不太好的原因。因为给出那些你只是“听说”而不是真正“理解”的建议，我认为是非常危险的。

---

### [00:42:31] Lenny Rachitsky

**English:**
So speaking of advice that you've shared that might be out of date now, you are famous for writing one of the most popular pieces of literature for product managers. There's a lot of PMs that listen to this podcast called Good Product Manager, Bad Product Manager. And if you actually go to that post today at the top you say, "This document was written 15 years ago and it's probably not relevant today for PMs. I present this nearly as an example of a useful training document." Still people link to it. I actually just link to it as just like this is something every PM needs to read. What is it that you think people should maybe not take away from it, and what do you think people still should take away from that piece?

**中文翻译:**
说到你分享过的可能已经过时的建议，你曾写过一篇产品经理界最著名的文章。很多听这个播客的 PM 都读过那篇《好产品经理，坏产品经理》。如果你现在去看那篇文章，你在开头写道：“这份文档写于 15 年前，对今天的 PM 可能已经不再适用。我展示它仅仅是作为一个有用的培训文档示例。”但人们依然在转发它。我甚至觉得这是每个 PM 必读的。你认为人们不该从中吸取什么，而又有哪些东西是至今依然适用的？

---

### [00:43:07] Ben Horowitz

**English:**
Yeah, so the reason I wrote it when I wrote it was that I had a lot of product managers. And one thing about product management is it's a job that's completely different at every company and there is no training for it. So everybody kind of figures it out as they go. And depending on what's being emphasized, they'll get wrapped around the axle on if it's an enterprise company, well pitching to customers or I need to be really good with the press, or I need to be really good at writing the product requirements document or that kind of thing.

**中文翻译:**
是的。我当时写它的原因是当时我手下有很多产品经理。产品管理的一个特点是，它在每家公司都完全不同，而且没有正式的培训。所以每个人都是边做边摸索。根据公司侧重点的不同，他们可能会陷入细节：如果是 2B 公司，他们可能纠结于如何向客户推销，或者如何应对媒体，或者如何写好产品需求文档（PRD）之类的。

---

### [00:43:49] Ben Horowitz

**English:**
And those are all these tasks, but none of those were the job and what I was trying to get out in Good Product Manager, Bad Product Manager was, the job is fundamentally a leadership job and it's a tricky leadership job because nobody is actually reporting to you. So it's like this influence, how do I get people to do what I want even though I'm not paying them. I can't fire them. I can't promote them, and so forth, which is kind of the essence of real leadership because if you start to rely on promotion and firing and so forth for authority, then you're never going to be good at being CEO or anything.

**中文翻译:**
这些都只是任务，而不是这份工作的本质。我在《好产品经理，坏产品经理》中想表达的是，这份工作本质上是领导力工作，而且是一种棘手的领导力，因为实际上没有人向你汇报。这关乎影响力：在我不给他们发工资、不能解雇他们、不能提拔他们的情况下，我如何让他们做我想让他们做的事？这正是真正领导力的精髓。因为如果你开始依赖提拔和解雇来建立权威，那你永远无法成为优秀的 CEO 或任何领导者。

---

### [00:44:38] Ben Horowitz

**English:**
So I wanted them to get into the mindset of, "Okay, your actual job is to get a product into market that customers love that's better than anything that anybody else in the world puts in market. That's your job." And so to accomplish that job, you need engineering to understand you with clarity. You need to understand engineering with clarity. You need to have a really good view of the market and the competitors and the technology and so forth and you need to put that all together and deliver the thing.

**中文翻译:**
所以我希望他们建立这样的心态：“好吧，你的真实工作是把一款客户喜爱的、比世界上任何竞争对手都好的产品推向市场。这就是你的工作。”为了完成这项工作，你需要让工程团队清晰地理解你，你也需要清晰地理解工程团队。你需要对市场、竞争对手和技术有深刻的见解，然后把这一切整合起来，交付产品。

---

### [00:45:17] Ben Horowitz

**English:**
And all the other things are tasks that you may or may not need to do. I don't know if you need to do them, but the thing is, you have to be the leader. You've got to get the thing done. And so what I think it's still good on is that the mindset, be the leader, I think the details of any kind of thing that was kind of task specific was really for my group a Netscape in 1996, whenever the hell I wrote it.

**中文翻译:**
其他所有事情都只是你可能需要、也可能不需要做的任务。我不确定你是否必须做那些，但关键是，你必须成为领导者，你必须把事情办成。所以我认为这篇文章至今依然适用的地方在于那种“成为领导者”的心态。至于那些具体的任务细节，那是针对我 1996 年在 Netscape 的团队写的，那是很久以前的事了。

---

### [00:45:56] Ben Horowitz

**English:**
So as a kind of document I wrote out of frustration. But I am glad that the people still like it, and I think leadership in general is undervalued, underestimated. It's the most powerful thing. And most of the great companies, Jensen is a great example. What a phenomenal leader he is not just of Nvidia, but of the whole industry. And he doesn't have authority over the industry, but he drives it forth and that's why the Good Product Manager, Bad Product Manager is so important because that thing, if you learn how to do it, that's the thing.

**中文翻译:**
那份文档是我在挫败感中写出来的。但我很高兴人们依然喜欢它。我认为领导力普遍被低估和轻视了，它是最强大的力量。大多数伟大的公司，黄仁勋就是一个极好的例子。他不仅是英伟达的杰出领导者，也是整个行业的领导者。他并没有对整个行业的行政权力，但他推动了行业的发展。这就是为什么《好产品经理，坏产品经理》如此重要，因为如果你学会了如何做到这一点，你就掌握了核心。

---

### [00:46:39] Lenny Rachitsky

**English:**
I didn't realize you wrote that initially as just an internal document and then you made a—

**中文翻译:**
我之前没意识到这最初只是一份内部文档，然后你才把它……

---

### [00:46:44] Ben Horowitz

**English:**
It was kind before blogging took off, so it is just an internal thing and I published it later. I was just getting so mad. And by the way, my product management team at the time was very good, very talented people. They just were not getting that concept. So like David Weiden at Khosla Ventures, Raghu Raghuram, who went on to be CEO of VMware, the team was like that team, but they were driving me crazy. And so I was like, "I can't yell at people anymore. I have to explain to myself." And so it's a good thing if you find yourself yelling at people, you probably haven't explained what you want, was the other big takeaway from that.

**中文翻译:**
那是在博客流行之前，所以它只是个内部的东西，我后来才发布的。我当时只是太生气了。顺便说一下，我当时的产品经理团队非常优秀，都是极具天赋的人。比如 Khosla Ventures 的 David Weiden，后来成为 VMware CEO 的 Raghu Raghuram。团队里全是这种大牛，但他们当时快把我逼疯了。于是我想：“我不能再对人吼叫了，我得把我的想法写清楚。”所以，如果你发现自己在对人吼叫，那很可能是因为你还没解释清楚你想要什么，这是那件事给我的另一个重大启示。

---

### [00:47:30] Lenny Rachitsky

**English:**
Did you ever think that piece would be so long-lasting? And so, I don't know, popular?

**中文翻译:**
你当时有没有想过这篇文章会流传这么久？而且这么受欢迎？

---

### [00:47:34] Ben Horowitz

**English:**
I didn't even know. I thought it was kind of like aggressive when I wrote it. You could tell I was mad. I called a Good Product Manager, Bad Product Manager. It's like bad dog, bad, bad, bad product manager. That was kind of the emotion I had. So, it is kind shocking some of the things that you write. I would say that that's and kind of creative, and you probably know this. The idea is that you have the things that you write in five minutes end up being much better than things you write in five weeks. And I find in talking to musicians or writers or everybody has that same experience. The thing that you've already synthesized so much that you just have to write it out, that's the best stuff.

**中文翻译:**
我完全没想到。写的时候我觉得它挺有攻击性的，你能看出我很生气。我把它命名为《好产品经理，坏产品经理》，就像在训狗一样：“坏狗狗，坏 PM，坏坏坏！”我当时就是那种情绪。所以，有些你写下的东西能产生这种效果确实挺令人吃惊的。我想说这是一种创作规律，你可能也知道：那些你花 5 分钟写出来的东西，往往比你花 5 周写出来的要好得多。我发现无论是和音乐家还是作家交流，大家都有同样的体会。那些已经在你脑海里高度浓缩、只需要写出来的东西，才是最棒的。

---

### [00:48:21] Lenny Rachitsky

**English:**
There's something that you mentioned there in your answer about the PM being the leader. There's always this kind of sense that the PM is not the mini CEO. How dare you call yourself that. I actually think that's exactly what the PM is. They're basically the closest to the CEO. Their kind job is to think like the CEO within the team.

**中文翻译:**
你在回答中提到 PM 是领导者。总有一种声音说 PM 不是“小 CEO”，觉得“你怎么敢这么自比”。但我实际上认为 PM 恰恰就是这个角色。他们基本上是最接近 CEO 的人，他们的工作就是在团队内部像 CEO 一样思考。

---

### [00:48:39] Ben Horowitz

**English:**
People get mad because everybody, this is the whole challenge of management in general. People get jealous over stewardship. But from the perspective of the PM, it doesn't matter if you write a good spec or you have a good interview or you do this or do that. What matters is that the product works. And you have to get all the way to there and work backwards from that and you can't do that without leadership because it is about, okay, we want to build that. And you're not necessarily the person who comes up with every idea or this or that, or that. You're just the keeper of the vision.

**中文翻译:**
人们会生气，因为——这是管理学普遍面临的挑战——人们会对“管理权”产生嫉妒。但从 PM 的角度来看，你写了好的规格书、面试表现好、做了这做了那都不重要。重要的是产品得成功。你必须以结果为导向进行倒推，而没有领导力你是做不到这一点的。因为这关乎于：“好吧，我们要造出那个东西。”你并不一定是那个想出每一个点子的人，你只是愿景的守护者。

---

### [00:49:22] Ben Horowitz

**English:**
And that's true for CEOs too. You don't want every idea in a company coming from the CEO. I think it's a misunderstanding of what a CEO is, is why people don't like that. They don't know what a CEO is. But a CEO isn't the one who has every idea it gives, every order does every. That's not the way it works. The way it works is there's somebody who's got to consolidate, get all the good ideas, prioritize them, decide which good ideas we're going to do, and then get everybody on the same page, so that they have very high fidelity understanding of what that is. And so that it is a CEO, kind of function. Now, it doesn't mean I'm better than you, it just means that...

**中文翻译:**
这对 CEO 也是一样的。你并不希望公司里的每一个点子都来自 CEO。我认为人们之所以不喜欢那个说法，是因为对 CEO 的职能有误解。他们不知道 CEO 是干什么的。CEO 并不是那个想出所有点子、下达所有命令、亲力亲为的人。事实并非如此。CEO 的工作是汇总所有的好点子，排列优先级，决定我们要执行哪些，然后让所有人达成共识，确保大家对目标的理解高度一致。这就是一种 CEO 式的职能。这并不意味着我比你优越，只是意味着……

---

### [00:50:05] Lenny Rachitsky (Sponsor: Miro)

**English:**
This episode is brought to you by Miro. Every day, new headlines are scaring us about all the ways that AI is coming for our jobs, creating a lot of anxiety and fear. But a recent survey for Miro tells a different story. 76% of people believe that AI can benefit their role, but over 50% of people struggle to know when to use it. Enter Miro's Innovation Workspace, an intelligent platform that brings people and AI together in a shared space to get great work done. Miro has been empowering teams to transform bold ideas into the next big thing for over a decade. Today, they're at the forefront of bringing products to market even faster by unleashing the combined power of AI and human potential. Check it out at miro.com/lenny.

**中文翻译:**
本集节目由 Miro 赞助。每天都有新的头条新闻在恐吓我们 AI 将如何取代我们的工作，引发了大量的焦虑和恐惧。但 Miro 最近的一项调查显示了不同的情况：76% 的人认为 AI 可以使他们的角色受益，但超过 50% 的人不知道何时使用它。Miro 的创新工作空间（Innovation Workspace）应运而生，这是一个将人和 AI 聚集在共享空间中以完成出色工作的智能平台。十多年来，Miro 一直在赋能团队将大胆的想法转化为下一个大事件。今天，他们通过释放 AI 与人类潜力的结合力量，走在加速产品上市的前沿。请访问 miro.com/lenny 了解详情。

---

### [00:51:16] Lenny Rachitsky

**English:**
Let's talk about AI. I'm very proud of us. It's been almost an hour. We haven't even mentioned AI. I think that's a record. Okay, so I asked Adam Neumann, WeWork founder, now Flow founder, someone you work closely with now what to ask you about. And he said he has some really interesting insights about how AI is impacting hiring.

**中文翻译:**
让我们聊聊 AI。我为我们感到自豪，聊了快一个小时，我们居然还没提到 AI，这创纪录了。我问了 Adam Neumann（WeWork 创始人，现 Flow 创始人，你现在的紧密合作伙伴）该问你什么。他说你对 AI 如何影响招聘有一些非常有趣的见解。

---

### [00:51:35] Ben Horowitz

**English:**
Adam is probably the single most controversial investment that we ever made. We got called everything from stupid to sexist to racist to this and that for literally just funding that. And I think it's going to end up being one of the best investments we ever made. He's doing a phenomenal job there. There's an important principle in that which we do as a firm, which I think is not widely done, but I would love it if people copied it, which is, and it's something I learned somewhat from Shaka, which is you don't judge a person by the worst thing that ever happened to them. We've all had bad things happen to us. We've all made bad decisions. Most of them, they don't make a miniseries about.

**中文翻译:**
Adam 可能是我们做过的最具争议的一笔投资。仅仅因为投资了他，我们就被人骂成愚蠢、性别歧视、种族歧视等等。但我认为这最终会成为我们最成功的投资之一。他在那里做得非常出色。这里面涉及我们公司的一个重要原则，我认为这个原则并没有被广泛采用，但我希望人们能效仿，这也是我从 Shaka 那里学到的：你不能根据一个人身上发生过的最糟糕的事来评判他。我们都经历过坏事，都做过错误的决定。只是大多数人的错没被拍成迷你剧而已。

---

### [00:52:35] Ben Horowitz

**English:**
And so to judge them on that, you want to judge people on what they do well, not what they screwed up, because that's where you see the talent. If you look at what Adam did well, it's truly spectacular. Everybody knows WeWork. Name a more important commercial real estate brand than WeWork. You can't. And so what an accomplishment. And there were so many things that went into that and so many things he did right.

**中文翻译:**
所以，你应该根据一个人做得好的地方来评判他，而不是根据他搞砸的地方，因为那才是才华所在。如果你看 Adam 做得好的地方，那真是惊人的。每个人都知道 WeWork。你能说出一个比 WeWork 更重要的商业地产品牌吗？你不能。那是多么了不起的成就。这背后有很多因素，他做对了很多事。

---

### [00:53:10] Ben Horowitz

**English:**
And then if you kind of look at really unravel the things that went wrong, most of it was like a combination of inexperience and nobody around him that would tell him the truth. And, yeah, maybe he wasn't good at listening to the truth either at the time, but to throw away a guy on that, which is by the way, the world was so mad at us for not throwing him away, for believing in him, is just that it's a big mistake. And I credit Mark because Mark is the one who called him up originally, and just said, "Hey, Adam, what are you doing?" Because we watched what you did at WeWork and we thought it was pretty impressive.

**中文翻译:**
如果你真的去梳理那些出错的地方，大部分是由于缺乏经验，以及身边没有人告诉他真相。是的，也许他当时也不擅长听取真相。但如果因此就彻底否定一个人——顺便说一下，全世界都因为我们没有抛弃他、因为我们相信他而对我们大发雷霆——那将是一个巨大的错误。这要归功于 Mark，是 Mark 最初给他打电话说：“嘿 Adam，你在忙什么？我们关注了你在 WeWork 的所作所为，觉得非常了不起。”

---

### [00:53:54] Ben Horowitz

**English:**
And so I think that that's probably the biggest secret there. Judge Al Davis once said, "Coach players on what they can do." And I think that's very true. Judge people on what they can do, coach people on what they can do, help them take their strengths and use them as opposed to over focus on their weaknesses and just hand wringing about the one fucking thing they don't know how to do. Because look, everybody's uneven.

**中文翻译:**
我认为这就是最大的秘诀。Al Davis 评委曾说过：“根据球员能做的事来指导他们。”我认为这非常正确。根据人们能做的事来评判他们，根据他们能做的事来指导他们，帮助他们发挥长处，而不是过度关注他们的弱点，或者为了他们那件该死的不会做的事而焦虑。因为听着，每个人都是不完美的。

---

### [00:54:31] Lenny Rachitsky

**English:**
What you're describing, essentially, this is the job of an investor, is to find an underappreciated asset and invest or before something people don't see.

**中文翻译:**
你所描述的本质上就是投资者的工作：寻找被低估的资产，并在别人还没看出来之前进行投资。

---

### [00:54:42] Ben Horowitz

**English:**
Venture capital is really about investing in people. You have ideas as an investor, but what you really are ultimately betting on is the entrepreneur and the entrepreneur's idea because the initial idea isn't where they end up usually. It changes a lot with everybody we invest in. So you kind of have to make the judgment on the person. And how you do that is really, really important. And one of the things we emphasize inside the firm is, look, we're investing in strength, not lack of weakness. I want to know how good, are they world-class? Do they have a world-class strength? And can that beat anybody? And look, everybody's flawed. And so let's help them deal with the flaws and surround them with people who can handle that and put the right person on the board who can talk to them.

**中文翻译:**
风险投资本质上是投人。作为投资者你会有自己的想法，但你最终赌的是创业者和他们的点子，因为最初的点子通常不是最终的终点。我们投资的每个人都会发生很大变化。所以你必须对“人”做出判断。如何判断至关重要。我们在公司内部强调的一点是：我们投资的是“长处”，而不是“没有短处”。我想知道他们有多强，是否是世界级的？他们是否有能击败任何人的世界级优势？听着，每个人都有缺陷。所以我们要帮他们处理缺陷，给他们配备能处理这些问题的人，并在董事会安排合适的人与他们沟通。

---

### [00:55:43] Ben Horowitz

**English:**
You know Mark's on the board, I go to all his board meetings because I'm the one who's good at killing a guy who's that confident when he's like, "Okay, that's not your best idea." That's good role for me. But that's how you deal with that. You don't throw them away and go, "Oh, okay, we don't want to be called names. So we're not going to invest in Adam Neumann after we built WeWork. That's crazy.

**中文翻译:**
Mark 在董事会里，我参加他所有的董事会会议，因为我擅长打击那种极度自信的人，当他说出某个想法时，我会说：“好吧，这不是你最好的主意。”这很适合我。这就是处理方式。你不能因为怕被人骂就抛弃他们，说：“哦，好吧，我们不想被叫难听的名字，所以即使 Adam Neumann 创办了 WeWork，我们也不投他。”那太疯狂了。

---

### [00:56:08] Lenny Rachitsky

**English:**
That's also why you guys invested in Cluely, I imagine similar.

**中文翻译:**
我想这也是你们投资 Cluely 的原因，情况类似。

---

### [00:56:10] Ben Horowitz

**English:**
Yeah, yeah, no, that's right. I mean, look, if you look at what those guys did, that was some high level marketing genius too, and that's really something. Plus the product is awesome.

**中文翻译:**
没错。我是说，看看那些家伙做的事，那也是高水平的营销天才，非常了不起。而且产品也很棒。

---

### [00:56:23] Lenny Rachitsky

**English:**
I'm going to bring us back to AI. Something that a lot of people are talking about right now while we're recording this is this potential huge bubble we're in with AI. Sam Altman said, "We're in a big bubble," which is, that's saying a lot. I'm curious just how you that it—

**中文翻译:**
我把话题拉回到 AI。在我们录音的时候，很多人都在讨论我们是否正处于一个巨大的 AI 泡沫中。萨姆·奥尔特曼（Sam Altman）曾说：“我们正处于一个大泡沫中”，这分量很重。我很想知道你怎么看——

---

### [00:56:36] Ben Horowitz

**English:**
What is it saying? First of all, I should qualify this by saying I am an investor and Sam's a CEO. So CEOs have to have much more purpose when they talk. Investors just have to be entertained. So you got to give Sam credit for what is it in his interest to say it? Well, if it's a bubble, then the one thing you should invest in is him and not all these guys chasing after him.

**中文翻译:**
这话意味着什么？首先，我得声明：我是投资者，而萨姆是 CEO。CEO 说话必须有更强的目的性，而投资者只需要听个乐呵。所以你得想想，萨姆这么说符合他的利益吗？如果这是一个泡沫，那么你唯一应该投资的就是他，而不是那些在他身后追赶的人。

---

### [00:57:09] Ben Horowitz

**English:**
I would say that's very smart. And then the other thing that's smart about it is there's nothing that you can say to the press that will make them love you more than saying, "All investors and entrepreneurs chasing this are idiots." They love them. The press are generally haters, and so it's just red meat for the haters, which was also super clever. So I think whether even he believes that or not, that was a super smart thing to say. So I'll just put it there. Whereas what I'm going to say won't be as smart, but it will...

**中文翻译:**
我会说这非常聪明。另一件聪明的事是，没有什么比对媒体说“所有追逐这个领域的投资者和创业者都是白痴”更能让他们爱死你了。媒体通常喜欢唱反调，所以这简直是给那些“黑粉”送上的大餐，非常高明。所以无论他自己信不信，这都是一句非常聪明的话。我就点到为止。而我要说的话可能没那么聪明，但是……

---

### [00:57:45] Ben Horowitz

**English:**
I don't really have an ax to grind here. I mean, I could have an ax to grind and say, "Okay, let's get all the other investors out." I'll say, "It's a massive bubble." But what I would say about that is, so the first thing, the one thing about bubbles is anytime everybody thinks it's a bubble, it's not a bubble because in order for it to bubble, you need capitulation. In that you need everybody to believe it's not a bubble, because then the prices really go out of control. But as long as there's people who think it's a bubble, then it's hard for that to happen.

**中文翻译:**
我在这里并没有什么私心。我也许可以有私心，说：“好吧，让其他投资者都滚出这个市场。”我会说：“这是一个巨大的泡沫。”但关于泡沫，我想说的是：任何时候只要每个人都认为它是泡沫，它就不是泡沫。因为要形成真正的泡沫，你需要“投降式认同”——你需要每个人都相信它不是泡沫，因为只有那样价格才会真正失控。只要还有人认为它是泡沫，泡沫就很难形成。

---

### [00:58:52] Ben Horowitz

**English:**
And it's funny, I had this debate in The Economist, I think with Steve Blank in like 2011 or '12 when everybody thought it was a tech bubble, if you can imagine that, which it absolutely was not. But because there were 1,400 articles saying that we were in a tech bubble, and I mean where prices were then compared to where they are now. But I knew because everybody was saying it was a bubble, it wasn't a bubble. I knew that. The prices were higher, but the reason the prices were higher was we're getting to a global market.

**中文翻译:**
这很有趣，我记得 2011 或 2012 年左右在《经济学人》上和 Steve Blank 辩论过，当时每个人都觉得那是科技泡沫——你能想象吗？事实证明绝对不是。但当时有 1400 篇文章说我们处于科技泡沫中，我是指当时的价格和现在的价格相比简直是毛毛雨。但我知道，正因为每个人都说它是泡沫，它就不是。价格确实高了，但价格高的原因是我们在进入全球市场。

---

### [00:59:23] Ben Horowitz

**English:**
AI prices are higher than prior prices, but if you look at the revenue growth and numbers, we had not seen anything like it. Sam's product worked so amazingly, we'd never seen that before. Not even Google, not anybody. And so that's real. And we have companies that went from zero to 800 million in a year and that kind of thing. I would say there's a basis for the prices going up, first of all. I think the thing that's right about what Sam is saying is the landscape is early, really early. The technology is very immature. As amazingly as it works, there's a long way to go to improve it.

**中文翻译:**
AI 的价格确实比以前高，但如果你看营收增长和数据，我们从未见过类似的情况。萨姆的产品表现如此惊人，我们以前从未见过，谷歌没见过，谁也没见过。所以这是真实的。我们有公司在一年内从零增长到 8 亿美元营收。首先，我认为价格上涨是有基础的。我认为萨姆说对的一点是，现在还处于早期，非常早期。技术还很不成熟。尽管它现在表现惊人，但仍有很长的路要走。

---

### [01:00:18] Ben Horowitz

**English:**
So it's very possible when you have that much technological change, that the positions that these companies have achieved with their high revenue isn't sustainable, and that there'll be a competitive change that either lowers prices or a new number one emerges or that kind of thing. Yeah, that's possible. But I wouldn't characterize that as being a financial bubble in that if you go back to the great dot-com bubble that everybody is always waiting for it to happen again, which I was CEO during.

**中文翻译:**
所以很有可能，当技术变革如此剧烈时，这些公司凭借高营收获得的地位是不可持续的，可能会出现竞争格局的变化，要么导致降价，要么出现新的第一名。是的，这很有可能。但我不会将其定性为金融泡沫。如果你回过头看那个每个人都在等它重演的互联网大泡沫（我当时正担任 CEO），情况完全不同。

---

### [01:01:03] Ben Horowitz

**English:**
The thing that happened there was very different, which is it was the internet and every smart investor knew that the internet was a big deal. How could you not fucking know that the internet was, of course it's a big deal. But if you go back to 1996, at Netscape, we had 90% browser share and we had 50 million users. So there were 55 million people on the internet in total, and half of those were on dial-up. And then to build a product like Evite, the greeting card company, had 300 engineers. That's how hard it was to build this stuff.

**中文翻译:**
当时发生的事情非常不同：那是互联网时代，每个聪明的投资者都知道互联网是件大事。你他妈怎么可能不知道互联网是大事？当然是。但回到 1996 年，在 Netscape，我们拥有 90% 的浏览器市场份额，拥有 5000 万用户。当时全球总共只有 5500 万人上网，其中一半还是拨号上网。而要开发像 Evite（电子贺卡公司）这样的产品，需要 300 名工程师。当时开发产品的难度就是这么大。

---

### [01:01:44] Ben Horowitz

**English:**
And the math didn't work, and the math didn't work on any of those ideas, but the investors kept pouring money in. And then eventually everybody went bankrupt because there was no revenue coming in. And when they figured that out, then nobody would invest in anything. And of course then everybody realized, well, the internet was actually real and Paul Krugman didn't know what he's talking about, and like it was going to be a big thing. And then Facebook and Google and all these things emerged.

**中文翻译:**
当时的商业逻辑根本不通，所有那些点子的账都算不过来，但投资者还是不断砸钱。最终每个人都破产了，因为没有收入进来。当大家意识到这一点时，就没人再投资任何东西了。当然，后来大家发现互联网其实是真的，保罗·克鲁格曼（Paul Krugman）根本不知道自己在说什么，互联网确实成了大事，然后 Facebook、谷歌等公司才相继出现。

---

### [01:01:44] Ben Horowitz

**English:**
But the thing that made it a bubble was the unit economics didn't work, the businesses didn't work. These businesses are all working, and they're being priced appropriately for how they're growing. So that's not in effect. The thing that you could say is, "They're not going to keep growing like that," and so forth. And I'm not sure about that. The products, like I said, are working so much better than any technology product that we've ever built has worked. It's just mind-blowing how good this stuff is. And so, I don't know, if I had to bet, I would bet not a bubble. I think there'll be some dislocation. I think always in venture capital, if you've got a run like this, then the great company and the crap company both get funded. But that's just venture capital. That's not a bubble.

**中文翻译:**
但当时之所以是泡沫，是因为单位经济效益（unit economics）不成立，业务模式行不通。而现在的这些 AI 业务都是成立的，它们是根据增长速度进行合理定价的。所以本质上不同。你可以说“它们不会一直这样增长下去”，但我对此并不确定。正如我所说，这些产品的表现比我们以往开发的任何科技产品都要好得多。这些东西的强大程度简直令人震撼。所以，如果非要我下注，我会赌它不是泡沫。我认为会出现一些错位。在风险投资中，如果你遇到这样的行情，伟大的公司和垃圾公司都会获得融资。但这只是风投行业的常态，不是泡沫。

---

### [01:02:44] Lenny Rachitsky

**English:**
For founders starting companies these days. When you look into the future of the AI industry, say in five, 10 years, how do you think things will play out slash where do you think the biggest opportunities remain? Where are you guys looking to invest most?

**中文翻译:**
对于现在创业的创始人来说，当你展望 AI 行业的未来，比如 5 到 10 年后，你认为局势会如何演变？或者说你认为最大的机会在哪里？你们最看好哪些领域的投资？

---

### [01:02:57] Ben Horowitz

**English:**
In infrastructure. I think that there is obviously a real estate power cooling play. I think that's a little outside of hardcore technology investing that we do. But there's another layer which is take a given open source model, who can run it the cheapest with the lowest latency? And that's going to be extremely valuable, whoever has that. And Google has been historically very good at that and so forth, and Sam is really trying to build that now with Stargate. And so I think that's going to be a very important layer of value.

**中文翻译:**
在基础设施领域。我认为显然存在房地产、电力、冷却方面的机会，但这有点超出了我们从事的核心技术投资范围。但还有另一层：对于给定的开源模型，谁能以最低的成本、最低的延迟运行它？无论谁拥有这种能力，都将极具价值。谷歌历史上一直非常擅长此道，萨姆现在也正试图通过 Stargate 项目来构建这种能力。所以我认为这将是一个非常重要的价值层。

---

### [01:03:39] Ben Horowitz

**English:**
I think that on the foundation model side, you have to be very selective as an investor. So in order to compete in foundational model world, our basic rule of thumb is you have to be able to, without much product progress, raise at least $ 2 billion because that's basically what it's going to cost you to train something that gets you competitive enough to make money. And there are just very few founders like that. So Ilya is one of those. Mary's one of those, Fei-Fei is one of those, but that's the kind of class of person you need. And there's whatever. There's certainly less than 10 of those in the world. And so that's kind of an important area, but a small area.

**中文翻译:**
我认为在基础模型（foundation model）方面，作为投资者必须非常挑剔。要在基础模型领域竞争，我们的基本准则是：你必须能够在没有太多产品进展的情况下，筹集到至少 20 亿美元，因为训练出具有盈利竞争力的模型基本上就需要这么多钱。能做到这一点的创始人寥寥无几。Ilya（Sutskever）是其中之一，Mary 是一个，李飞飞（Fei-Fei Li）也是一个，这就是你需要的那类人。全世界这种人肯定不到 10 个。所以这是一个重要但很小的领域。

---

### [01:04:43] Ben Horowitz

**English:**
And then I think the application layer is going to be very, very interesting. And I think that if you look at Sam, he's making most of his money off ChatGPT, almost all his money off ChatGPT now. And Chat GPT, like it or not, it's got a real moat. It's very hard to knock it off. It's perched. Everybody's taking a shot at it, people, great distribution like Google and Elon and Zuckerberg and everybody. And that thing just keeps going like it is. So I think the applications are both more complex and kind of stickier than people thought they were originally.

**中文翻译:**
然后我认为应用层（application layer）会非常非常有意思。如果你看萨姆，他现在大部分的钱、几乎所有的钱都是靠 ChatGPT 赚的。不管你喜不喜欢，ChatGPT 都有真正的护城河，很难被撼动。它已经占据了高地。每个人都在尝试挑战它，包括拥有强大分发能力的谷歌、马斯克、扎克伯格等等。但它依然屹立不倒。所以我认为应用比人们最初想象的更复杂，也更有粘性。

---

### [01:05:17] Ben Horowitz

**English:**
The thing that people got very wrong is this whole thin wrapper around GPT, that's really wrong. In fact, here's how wrong it is. Back in the '80s, that same phrase was used, but it was thin wrapper around an RDBMS— (Database). Yeah, yeah, yeah. So it meant companies like Salesforce were basically just a thin wrapper. And I think that that's kind of the mistake people made. So we're at this company Cursor, and if you look under the covers in Cursor, they've built 14 different models to really understand how a developer works, a high-end, a real developer.

**中文翻译:**
人们错得很离谱的一点是所谓的“GPT 薄封装”（thin wrapper，指套壳应用），这完全错了。事实上，这种错误在 80 年代就出现过，当时人们说某些应用只是“关系型数据库（RDBMS）的薄封装”。这意味着像 Salesforce 这样的公司最初也被认为只是个“薄封装”。我认为人们现在犯了同样的错误。比如我们投资的 Cursor，如果你深入了解 Cursor 的内部，他们构建了 14 个不同的模型来真正理解开发者是如何工作的——那种高端的、真正的开发者。

---

### [01:06:09] Ben Horowitz

**English:**
Those models have tons and tons of interactions with how people talk to their friend Cursor about how they should design their programming so forth. And that's real, that's not just a thin layer on a foundation model. And I think there are many, many applications like that. And so I think there's going to be a lot of opportunity at the application layer. There's going to be some opportunity at the foundation model, and of course you can invest in Sam, you can invest in Anthropic and so forth as well. But there will probably be a very small number of companies at that set, and then a almost unlimited number of companies at the application layer.

**中文翻译:**
这些模型包含了海量的交互数据，记录了人们如何与 Cursor 交流、如何设计程序等等。这是实打实的东西，而不仅仅是基础模型上的一个薄层。我认为会有非常多这样的应用。所以应用层会有大量机会，基础模型层会有一些机会（当然你也可以投资萨姆的公司、Anthropic 等等）。但基础模型层的公司数量会非常少，而应用层的公司数量几乎是无限的。

---

### [01:06:43] Ben Horowitz

**English:**
And then as the technology advances, we'll of course see more things we can body to AI. I mean already autonomous cars are working really well now after a long, long, long, long time. Since I think Sebastian won the challenge in 2006 when he drove the self-driving car across the country. And here we are 20 years later and now they're deployed. So that was a long time. Robots I think is a harder problem than self-driving cars. So we'll see how that goes. But, yeah, there's certainly a lot in that world as well.

**中文翻译:**
随着技术的进步，我们当然会看到更多 AI 赋能的实体。我是说，自动驾驶汽车在经历了漫长的发展后，现在已经运行得非常好了。自从 2006 年 Sebastian 赢得挑战赛、驾驶自动驾驶汽车横穿全国以来，20 年过去了，它们终于部署了。那是一段很长的时间。我认为机器人是比自动驾驶汽车更难的问题。我们会看看进展如何。但那个领域肯定也有很多机会。

---

### [01:07:34] Lenny Rachitsky

**English:**
Wow, okay. There's a lot to this answer. No, that was exactly what I was looking for. The Cursor example, it's something that comes up a lot on this podcast, in the application layer specifically. The thought that the way to win in this space and to build a moat is, as you said, "Build your own model slash have proprietary data that you build through people using your product." Thoughts on that?

**中文翻译:**
哇，好的。这个回答信息量很大。这正是我想要的。Cursor 的例子在这个播客中经常被提到，特别是在讨论应用层时。有一种观点认为，在这个领域获胜并建立护城河的方法，正如你所说，“建立自己的模型，或者通过用户使用产品来积累专有数据”。你对此有什么看法？

---

### [01:07:58] Ben Horowitz

**English:**
Yeah, I mean, I think that ends up just being what's required. So it turns out that the universe is long-tailed, is fat-tailed, and humans are very fat-tailed in terms of human behavior, human conversation and so forth. So to get to the real meaning of it and to get to the kind of essence of the problem, in any domain turns out to be, I think, more complex than we thought. And so the early things and people were running around saying, "Okay, there's going to be one big brain to rule them all on these kinds of things." That's kind of not played out yet.

**中文翻译:**
是的，我认为这最终会成为一种必然要求。事实证明，宇宙是长尾的，或者说是“肥尾”（fat-tailed）的，人类在行为、对话等方面也具有非常明显的肥尾特征。因此，要在任何领域触及问题的本质和真实含义，事实证明比我们想象的要复杂得多。早期人们到处说：“好吧，将会有一个‘超级大脑’统治所有这些事情。”目前看来还没变成现实。

---

### [01:08:41] Ben Horowitz

**English:**
And in fact, if you look underneath the covers, you have LLMs, which have generalized pretty in fascinating ways, but they've kind of also asymptoted in that we have run out of data for the most part. And so if you look at the GPT-5 LLM compared to the GPT-4.1 and how much more it costs to train and so forth, it's definitely not going linear anymore. On the other hand, the reinforcement learning side has been linear, but it doesn't generalize. So if you build a great programming model, it may be an idiot at math.

**中文翻译:**
事实上，如果你深入探究，你会发现大语言模型（LLM）虽然以迷人的方式实现了泛化，但它们也遇到了一些瓶颈（渐近线），因为我们大部分的数据已经用完了。如果你比较 GPT-5 和 GPT-4.1 的训练成本和进展，它绝对不再是线性增长了。另一方面，强化学习（RL）方面一直是线性的，但它无法泛化。所以如果你建立了一个很棒的编程模型，它在数学方面可能就是个白痴。

---

### [01:09:12] Ben Horowitz

**English:**
And so that I think is just very different than what people would've said three years ago. And I think that there's not something that's both scaling and generalizing yet, and maybe we'll get there, but that certainly opens the door to something that's more user-friendly, that's more effective in any number of domains than just the basic foundation model infrastructure. Now those models are incredibly important, and I think OpenAI is probably 80% of the revenue in AI are something like that now. It's massive, and so that foundation model is really, really important. And then the basic consumer app is really, really important.

**中文翻译:**
所以我认为这与人们三年前的预测大相径庭。目前还没有一种既能无限扩展又能完美泛化的东西，也许未来会有，但这无疑为那些比基础模型更易用、在特定领域更有效的应用打开了大门。当然，基础模型极其重要，我认为 OpenAI 现在可能占据了 AI 领域 80% 的营收。规模巨大，所以基础模型非常重要，基础消费级应用也非常重要。

---

### [01:10:12] Ben Horowitz

**English:**
That just answers whatever the hell you want to know. Those things are very, very real. But I do think particularly, and then if you get into enterprise stuff and then it's no longer internet data, it's their data that becomes very different. Databricks is having a lot of success there because, okay, well, once you're inside a company, guess what? You care about access control. That's hard with an AI world. It gets trained on some stuff. How does it know who has access to that information and who doesn't, and so forth.

**中文翻译:**
那些能回答你任何问题的应用是非常真实的。但我确实认为，特别是当你进入企业级领域时，数据不再是互联网公开数据，而是企业内部数据，情况就完全不同了。Databricks 在这方面非常成功，因为一旦进入公司内部，你猜怎么着？你会在意访问控制。这在 AI 世界里很难，模型是在数据上训练出来的，它怎么知道谁有权访问这些信息，谁没有？

---

### [01:11:19] Ben Horowitz

**English:**
You have semantic issues. So if you look at an enterprise, find 10 enterprises, they all have a different definition of what a customer means. You would think customer is a basic thing. Well, is it a department at AT&T? Is it AT&T? Is it a person at AT&T? What the hell is the customer? And it turns out to be very, very meaningful, particularly if you're trying to figure out important things like churn and this and that and third. So that kind of stuff matters. So I would just say the problem space is a lot bigger than you can just attack with a basic foundation model currently. Maybe that will change, and if that changes, then certain prices will have, in retrospect, look way inflated and others will look too low. But that is TBD.

**中文翻译:**
还有语义问题。如果你找 10 家企业，他们对“客户”的定义可能各不相同。你可能觉得“客户”是个基本概念，但它是指 AT&T 的一个部门？还是整个 AT&T？还是 AT&T 的某个人？到底什么是客户？事实证明这非常有意义，特别是当你试图计算流失率等重要指标时。所以这类细节很重要。我想说，目前的问题空间比基础模型能解决的要大得多。也许未来会改变，如果真的变了，那么回过头看，现在的某些估值会显得过高，而另一些则显得过低。但这还有待观察（TBD）。

---

### [01:11:48] Lenny Rachitsky

**English:**
So a big takeaway from this is that there's still tons of opportunity for founders to start companies building AI products.

**中文翻译:**
所以一个重要的结论是，创始人现在创办 AI 产品公司仍有海量的机会。

---

### [01:11:55] Ben Horowitz

**English:**
I think so. Everything that we couldn't solve with software we can solve now, almost. So it's a really big world. And it's funny because we're investors in Waymo, and one of the things when you get into what took so long to make Waymo so safe like they are now, it wasn't the things that everybody reported on the podcast. There wasn't sleet and heavy rain, it was people. It was like the human who was driving 75 in the 25 zone. It was very hard for the AI to anticipate because it was rare but important. And the number of rare, important crazy shit that humans do is very high. And I think that that goes for all of AI. So to make things work really well, you have to understand this very kind of fat tail of human behavior.

**中文翻译:**
我想是的。几乎所有以前我们无法用软件解决的问题，现在都能解决了。所以这是一个非常广阔的世界。有趣的是，我们是 Waymo 的投资者，当你深入了解为什么花了这么长时间才让 Waymo 像现在这样安全时，原因并不是播客里常说的那些——不是雨雪天气，而是“人”。比如有人在限速 25 的区域开到 75。AI 很难预判这种行为，因为它罕见但极其重要。而人类做出的罕见、重要且疯狂的烂事（crazy shit）数量非常多。我认为这对所有 AI 领域都适用。要让产品真正好用，你必须理解人类行为中这种非常明显的“肥尾”特征。

---

### [01:12:52] Lenny Rachitsky

**English:**
Along this AI thread, something that is really important to you, clearly something you talk a lot about is the US being successful in AI, in leading the world in AI. Why is this so important? Why is something you spend a lot of time on?

**中文翻译:**
顺着 AI 这个话题，有一件事对你显然非常重要，你也经常谈到，那就是美国在 AI 领域取得成功并保持全球领先地位。为什么这如此重要？为什么你愿意为此投入大量时间？

---

### [01:13:06] Ben Horowitz

**English:**
It starts with, I think, my view of the US and its role in the world. My personal view is it's very, very, very important. Not for society to be completely fair because it's not going to be completely fair or completely equal because we've never had one that's been completely equal. But it's important that everybody have a chance at life, and particularly both culturally, but also just you can't advance the world if you can't tap into all of your resources.

**中文翻译:**
我认为这始于我对美国及其在世界中所扮演角色的看法。我个人的观点是，这非常、非常、非常重要。并不是为了让社会变得绝对公平，因为社会永远不会绝对公平或绝对平等，人类历史上从未有过。但重要的是每个人都有改变命运的机会。特别是在文化层面，而且如果你不能开发利用所有的资源，你就无法推动世界的进步。

---

### [01:14:23] Ben Horowitz

**English:**
And so if you kind of take away motivation and these kinds of things, you get into trouble. And if you look at the kind of every country today, and this is by the way, so you want the right amount of decentralized power. You don't want it to be completely concentrated, concentrated power makes it very, very difficult for everybody to have a chance. This is the big lesson of communism over the last hundred years is it turned out right. And we still have politicians selling it this way today, it's like, "Oh, it's power to the people." No, no, no. It's power to you because you're removing all power from the private sector and installing it into the government, and then you're putting yourself in charge of the government.

**中文翻译:**
如果你剥夺了人们的动力，你就会陷入麻烦。看看当今的每个国家——顺便说一下，你需要适度的权力去中心化。你不想让权力完全集中，因为权力集中会让每个人都很难获得机会。这是过去一百年里共产主义留下的重大教训。今天仍有政客在推销这种理念，说什么“权力归于人民”。不，不，不。那是权力归于“你”，因为你剥夺了私营部门的所有权力并将其收归政府，然后你让自己掌控了政府。

---

### [01:14:51] Ben Horowitz

**English:**
And then I become extremely powerful. And this is why it didn't matter if it was Mao or Pol Pot or Ceausescu or Stalin, everybody died because when you give anybody that much power, nobody has a chance. There is no incentive, there's no carrot, there's only stick. And so you use that stick, and that's just the nature. It's a system's problem. It's not a person problem. It's not Stalin was evil, Ceausescu is evil. It was that system is evil.

**中文翻译:**
然后我就变得极其强大。这就是为什么无论是毛、波尔布特、齐奥塞斯库还是斯大林，结果都是生灵涂炭，因为当你给任何人那么大的权力时，其他人就没机会了。没有激励，没有胡萝卜，只有大棒。于是你就使用那根大棒，这就是本性。这是一个系统性问题，而不是个人问题。并不是斯大林邪恶或齐奥塞斯库邪恶，而是那个系统本身是邪恶的。

---

### [01:15:00] Ben Horowitz

**English:**
And that's the saying with fascism. Be it Hitler or Mussolini, it doesn't matter. That level of power is evil. And the US does the best job. Systematically, it's the best system. It's got all kinds of issues, it's got problems. People always try to defeat it. But one of the things that if you look at the Declaration of Independence or the Constitution, the language is very important. It's, "We hold these truths to be self-evident." What does that mean? It means it's not my rule, it's not the president's rule, it's God's rule. And so those rules are above the President, and then you work in that context and that distributes the power, because you're under the law, not under the person.

**中文翻译:**
法西斯主义也是如此，无论是希特勒还是墨索里尼，都一样。那种程度的权力就是邪恶。而美国做得最好。从系统上讲，它是最好的系统。它有各种各样的问题，人们总想破坏它。但如果你看《独立宣言》或《宪法》，其中的措辞非常重要：“我们认为这些真理是不言而喻的。”这意味着什么？这意味着这不是我的规则，也不是总统的规则，而是上帝的规则。所以这些规则高于总统，你在这种背景下运作，权力就得到了分配，因为你是在法律之下，而不是在个人之下。

---

### [01:16:07] Ben Horowitz

**English:**
We see that now even with Europe, where the leaders are going, "Well, I have a rule. It's you can't say certain things or I'll throw you in jail." And the kind of shield they hide behind as well, we have to keep the kids safe. But if you say something that I don't agree with and the kids hear it, they're not safe. So the kind of transited property of bullshit is going to override. And so it's really important that we have at least one society. And as flawed as we are, as flawed as the US is, it's still the best. And you can see it by the number of new company creations, the number of new ideas that come out of here and so forth. It's really, really important that the US stays important and powerful in the world.

**中文翻译:**
我们现在甚至在欧洲也能看到这种情况，领导人们说：“好吧，我定个规矩：你不能说某些话，否则我就把你关进监狱。”他们躲在“我们要保护孩子安全”的挡箭牌后面。但如果你说了我不赞成的话，而孩子听到了，他们就不安全了。这种“扯淡的逻辑”会凌驾于一切之上。所以，我们至少要有一个这样的社会，这一点非常重要。尽管我们有很多缺陷，尽管美国有很多缺陷，它依然是最好的。你可以从新公司的创立数量、从这里产生的新想法数量等方面看出来。美国在世界上保持重要地位和强大实力真的非常、非常重要。

---

### [01:16:51] Ben Horowitz

**English:**
We know from the last century, if you look at the last century, who were the countries that had economic power, military power, cultural power? They were the ones that industrialized, and the ones that industrialized first and best. And the ones that did became Communists, like Russia, China. They were slow on industrialization and they fell into this very fucking dangerous system. Looking forward, that's going to happen again, but it's going to be AI. And so it is fundamentally important, not just to America, but to humanity, that America succeed at that. We don't have to be the one winner or this or that, but we do have to be in that tier.

**中文翻译:**
回顾上个世纪，哪些国家拥有经济实力、军事实力和文化实力？是那些实现了工业化的国家，而且是那些工业化最早、最好的国家。而那些没能及时工业化的国家，比如俄罗斯、中国，它们曾陷入了这种极其危险的体制。展望未来，历史将重演，只是这次是 AI。所以，美国在 AI 领域取得成功，不仅对美国，对全人类都至关重要。我们不一定要成为唯一的赢家，但我们必须处于顶尖梯队。

---

### [01:17:41] Ben Horowitz

**English:**
And as I go around the world and travel, I can't tell you, everybody ... and then everybody was getting, by the way, very, very worried about us earlier. And they say, "Look, we need you to succeed. Don't destroy the dollar. Don't fall behind in AI. Don't over-regulate it too early. Don't do these things, please, because we need you to win, because we're all counting on that." And I think it's the most important work that we do. It's why we're so involved in policy and so forth. I think this is also going to be very, very true with crypto, which ends up being an incredibly important networking technology that complements AI. That work is, I would say, beyond for the money. Although we will end up making a lot of money with the right policies, so I don't want to seem totally philanthropic on this, but it's more important than that. It's certainly more important than us succeeding or anything like that, that the country succeed.

**中文翻译:**
当我在世界各地旅行时，我无法告诉你大家……顺便说一下，之前每个人都对我们非常、非常担心。他们说：“听着，我们需要你们成功。不要毁掉美元，不要在 AI 领域落后，不要过早过度监管。请不要做这些事，因为我们需要你们赢，我们都指望着这一点。”我认为这是我们所做的最重要的工作，这也是为什么我们如此深入地参与政策制定等事务。我认为这在加密货币领域也同样适用，它最终会成为一种与 AI 互补的极其重要的网络技术。我想说，这项工作的意义超越了金钱。虽然有了正确的政策，我们最终会赚很多钱（我不想显得完全是在做慈善），但它比赚钱更重要。国家的成功肯定比我们个人的成功更重要。

---

### [01:18:53] Lenny Rachitsky

**English:**
Speaking of philanthropic and other passions of yours, something that I don't think most people know about you, and I think will give them another insight into how interesting you are, you run an organization called Paid in Full, which is incredibly cool. Talk about what that's about, why this is so important to you.

**中文翻译:**
说到慈善和你其他的热情所在，有一件事我想大多数人都不了解，这能让他们进一步了解你有多有趣：你运行着一个叫“Paid in Full”的组织，非常酷。聊聊那是做什么的，为什么它对你这么重要？

---

### [01:19:14] Ben Horowitz

**English:**
Our ethos as a firm is kind of what I'd say is something from nothing. This is the greatness of entrepreneurship. You start with nothing and then you make something really important. That is also how Hip-hop started, where you have a bunch of kids who didn't even have instruments, and they created something out of nothing. And the people in that world always talk about that. And one of the really unfortunate things that happens is, the people who invent the art form, and certainly in the case of Hip-hop, don't get anywhere near the kind of proportional benefit of their invention. And a lot of the guys, people have forgotten about, or are struggling to make ends meet, and so forth.

**中文翻译:**
我们公司的理念是“白手起家”（something from nothing）。这就是创业的伟大之处：你从一无所有开始，然后创造出非常重要的东西。嘻哈（Hip-hop）也是这样开始的，一群甚至没有乐器的孩子，凭空创造了一些东西。那个圈子里的人总在谈论这一点。但非常不幸的一点是，那些发明了这种艺术形式的人（尤其是在嘻哈领域），并没有获得与他们的发明相称的利益。很多人已经被遗忘了，或者正在为生计而挣扎。

---

### [01:20:06] Ben Horowitz

**English:**
So what we created was this thing called the Paid in Full Foundation, named after the Rakim, Eric B. song, which I did call Rakim and ask him for permission to use the name, so we didn't just take it. What we do is, we give essentially pensions to the old rappers, that enable them to kind of continue their work. And then we have a big event go to paidinfullfoundation.org for tickets, which is amazing, where they get the award and they're celebrated by all their peers and so forth. And it's really phenomenal. Some of the awardees have been Rakim, Scarface from the Geto Boys, Roxanne Shante, Grandmaster Caz, Kool Moe Dee.

**中文翻译:**
所以我们创立了“Paid in Full 基金会”，名字取自 Rakim 和 Eric B. 的那首歌。我确实给 Rakim 打了电话征求许可，而不是直接拿来用。我们所做的是为那些老派说唱歌手提供实质上的“养老金”，让他们能继续从事创作。我们还会举办盛大的活动（可以去 paidinfullfoundation.org 买票），他们在那里领奖，接受同行的欢呼。这真的很了不起。获奖者包括 Rakim、Geto Boys 的 Scarface、Roxanne Shante、Grandmaster Caz、Kool Moe Dee 等。

---

### [01:20:56] Ben Horowitz

**English:**
This year we're honoring George Clinton for being sampled, Kool G Rap and Grand Puba, and also Jalil from Whodini. I can't even describe how high impact it is on these guys. I think Rakim was touring close to 200 nights a year, and he got his award, and came out with his first album in 15 years and is doing amazingly well. All of a sudden everybody's going, "Oh yeah, that's the greatest rapper of all time." They're finally going back and remembering all the things he did. Roxanne Shante, nobody had mentioned her in years and years and years. I think six months after we gave her the award, the Grammys gave her a lifetime achievement award, which is amazing. It's super high impact. It's a great thing. As a Hip-hop fan, I say dream come true. It's my only guilt.

**中文翻译:**
今年我们要表彰被广泛采样的 George Clinton、Kool G Rap、Grand Puba，以及 Whodini 的 Jalil。我无法形容这对他们有多大的影响。Rakim 以前一年要巡演近 200 晚，领奖后，他推出了 15 年来的第一张专辑，表现非常出色。突然间每个人都在说：“哦对，那是史上最伟大的说唱歌手。”大家终于开始回顾并记住他所做的一切。Roxanne Shante 已经很多年没人提起了，但在我们给她颁奖六个月后，格莱美给了她终身成就奖，这太棒了。这影响深远，是一件伟大的事。作为嘻哈乐迷，这简直是梦想成真。这是我唯一的“罪恶快感”。

---

### [01:21:51] Lenny Rachitsky

**English:**
What's the origin story of you and Hip-hop? I imagine many people look at you and wouldn't imagine these records behind you, Nas gifted you. You are so deep into the community, just how did this all begin?

**中文翻译:**
你和嘻哈的故事是怎么开始的？我想很多人看着你，很难想象你身后那些 Nas 送给你的唱片。你在这个圈子里扎根这么深，这一切是怎么开始的？

---

### [01:22:03] Ben Horowitz

**English:**
Well, I actually wrote a blog post on it called The Legend of the Blind MC, which I think would be, if you're really interested, it's worth reading. But it is kind of a story of me becoming a rapper, and how that occurred, and how it went, and so forth. I always say the very short story is, I was in New York at the birth of Hip-hop and when it really became big, '84 through '88. It's just the most exciting thing to see a new art form pop out and the creativity and everything. Once music becomes mainstream, I would say it's very shaped by business. And in the early days, everybody's just coming out with whatever idea they have and so forth. The early days of rock and roll were like that. The early days of jazz were like that.

**中文翻译:**
我其实写过一篇博客叫《盲人 MC 的传说》（The Legend of the Blind MC），如果你感兴趣，值得一读。那讲的是我如何成为一名说唱歌手的故事，以及那是如何发生的。简短的版本是：嘻哈诞生并真正壮大的 1984 到 1988 年间，我正好在纽约。看到一种全新的艺术形式横空出世，那种创造力，简直是最令人兴奋的事。一旦音乐变得主流，它就会被商业深度塑造。但在早期，每个人都只是在表达自己的想法。摇滚乐和爵士乐的早期也是如此。

---

### [01:23:02] Lenny Rachitsky

**English:**
I see now even more why you guys brought on Erik Torenberg. Beyond his many talents, he's also really big into rap himself.

**中文翻译:**
我现在更明白你们为什么招募 Erik Torenberg 了。除了他的多才多艺，他自己也是个嘻哈发烧友。

---

### [01:23:10] Ben Horowitz

**English:**
Yeah, that's a good reminder. I need to make sure he gets to Paid in Full.

**中文翻译:**
是的，提醒得好。我得确保他参加 Paid in Full 的活动。

---

### [01:23:17] Lenny Rachitsky

**English:**
Ben, this was incredible. Is there anything else that you want to leave listeners with or share before we get to our very exciting, quick lightning round?

**中文翻译:**
Ben，这太精彩了。在进入我们非常刺激、快速的闪电轮问答之前，你还有什么想留给听众或分享的吗？

---

### [01:23:28] Ben Horowitz

**English:**
Yeah, I would just say, if you're a CEO listening to this, then know that how you feel about yourself is going to end up meaning as much as anything, and take your time on that. Self-evaluation is ... one of my favorite quotes is that when my old manager saw me, as select players know, "From this day on, no credit will be given for predicting rain, only credit for building an ark." And I think that's more true for CEOs than anybody. You have to build the ark. It doesn't matter if you predict you're going to fail, you've still failed. It gets you nothing. So what you have to do is figure your way out of it and spend all your time on that.

**中文翻译:**
是的，我想说：如果你是一位正在听这个播客的 CEO，请记住，你对自己的看法最终将决定一切，在这上面多花点时间。自我评估是……我最喜欢的一句话是我的老上司对我说的：“从今天起，预测下雨不再有功劳，只有建造方舟才有功劳。”我认为这对 CEO 来说比任何人都适用。你必须建造方舟。预测自己会失败没有意义，失败了就是失败了，预测对了也不会给你任何奖励。所以你必须做的是找到出路，并把所有时间都花在上面。

---

### [01:24:23] Lenny Rachitsky

**English:**
Well, with that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
好，现在进入我们非常刺激的闪电轮。我有五个问题问你，准备好了吗？

---

### [01:24:27] Ben Horowitz

**English:**
Yes, sir.

**中文翻译:**
准备好了。

---

### [01:24:29] Lenny Rachitsky

**English:**
First question, what are two or three books that you find yourself recommending most to other people, not including your own books?

**中文翻译:**
第一个问题：除了你自己的书，你最常向别人推荐的两三本书是什么？

---

### [01:24:35] Ben Horowitz

**English:**
So two that I learned a lot from, one is The Weirdest People in the World, which it's a kind of big history book, but through an anthropological kind of cultural lens. It's really fascinating. It explains an awful lot about how society works and how little changes in the rules completely change the culture. One of the things that he basically endeavors to explain, why did the West get ahead on the rest of the world? It kind of comes down to a weird anomaly with the Catholic Church, where they enforced monogamous marriage.

**中文翻译:**
有两本让我受益匪浅。一本是《世界上最奇怪的人》（The Weirdest People in the World），这是一本宏大的历史书，但它是从人类学和文化的视角切入的。非常迷人。它解释了社会运作的许多原理，以及规则的微小变化如何彻底改变文化。作者试图解释：为什么西方能领先于世界其他地区？这归结为天主教会的一个奇怪现象：他们强制执行一夫一妻制。

---

### [01:25:02] Ben Horowitz

**English:**
And it turns out that the natural state of humans is polygamy, but the problem with polygamy is, there's no cooperation among men, which is a problem. And as a result, and then everything is secret, so there's no sharing of knowledge, because it's all kept in the family, in what he calls kin-based culture. It leads to something called kin-based culture. And even recipes won't be shared if you're in a kin-based culture, because it's a secret. So you can't build science, you can't build cities, you can't build big companies. So because the West kind of enforced broad monogamous marriage early, it was able to evolve into all these things.

**中文翻译:**
事实证明，人类的自然状态是一夫多妻制，但一夫多妻制的问题在于男性之间缺乏合作。结果就是一切都是秘密，没有知识共享，因为所有东西都留在家族内部，也就是他所说的“基于亲缘关系的文化”（kin-based culture）。在这种文化中，甚至连菜谱都不会分享，因为那是秘密。所以你无法建立科学，无法建立城市，无法建立大公司。因为西方很早就强制执行了广泛的一夫一妻制，它才得以演化出所有这些现代文明。

---

### [01:26:07] Ben Horowitz

**English:**
And he kind of shows why and how. He does these psychological tests today with people from monogamous marriage culture, Western culture, and kin-based culture. And the psychology is completely different. He gives examples like if a person murders another person, is that still murder if that person who did the murder is your brother? And in Western society, yeah, that's a murder. In kin-based culture, it's not a murder. It's just not. And so that's really different. And so morality is different, everything comes off of that. So it's just a fascinating, fascinating book. So that's one.

**中文翻译:**
他展示了原因和过程。他现在对来自一夫一妻制文化（西方文化）和亲缘文化的人进行心理测试，发现心理机制完全不同。他举例说：如果一个人杀了另一个人，如果凶手是你的兄弟，那还算谋杀吗？在西方社会，是的，那是谋杀。但在亲缘文化中，那不算谋杀，真的不算。所以这非常不同，道德观不同，一切都源于此。这是一本极其迷人的书。这是第一本。

---

### [01:26:55] Ben Horowitz

**English:**
Another book that I recommend a lot is Shaka's book, his first book, Writing My Wrongs. He has a new book that I think is better, which is called How to Be Free. It's not quite out, or maybe it's releasing. It's releasing next month, so I recommend it. What it does is, it goes through how did he work his way out of prison and solitary confinement to his current psychology, and what are the techniques he used? They're very powerful, very powerful ideas. CEOs always asks me, "How do you deal with it? How do you deal with it?" They'll ask in a work-life balance. It's like, "What are you talking about? No work-life balance for CEOs," or particularly entrepreneur CEOs, come on.

**中文翻译:**
另一本我经常推荐的是 Shaka 的书，他的第一本叫《书写我的过错》（Writing My Wrongs）。他有一本新书我觉得更好，叫《如何获得自由》（How to Be Free）。还没正式上市，下个月发布，我非常推荐。它讲述了他如何从监狱和单独监禁中走出来，达到现在的心理状态，以及他使用了哪些技巧。这些想法非常强大。CEO 们总问我：“你如何应对压力？”他们会问工作与生活的平衡。我说：“你在说什么呢？CEO 哪有工作生活平衡，特别是创业型 CEO，别逗了。”

---

### [01:27:43] Ben Horowitz

**English:**
But what do you do? Do you meditate? Do you do this or that? But he kind of goes through the things that you really ought to do. That's what I would recommend, if somebody's wondering, how do you deal with all this pressure?

**中文翻译:**
但你该怎么办？冥想吗？做这做那吗？Shaka 在书中讲述了你真正应该做的事情。如果有人想知道如何应对这种压力，这就是我的推荐。

---

### [01:27:57] Lenny Rachitsky

**English:**
I love this. Just the whole idea of Shaka being this help for CEOs, someone that killed someone, went to prison, led a prison gang. I just love that, how valuable his lessons—

**中文翻译:**
我太喜欢这个了。Shaka 这样一个杀过人、坐过牢、领导过监狱帮派的人，竟然能给 CEO 们提供帮助。我喜欢这种反差，他的教训是多么宝贵——

---

### [01:28:08] Ben Horowitz

**English:**
Prison gangs turn out to be really complicated things to manage. Sorry for getting into this, but the problem with running a prison gang is, you're just dealing with people who all come from broken culture. So in any organization, like the fundamental thing is trust. And so you're bringing in a bunch of no trust people. And so again, it's kind of like a military organization. It's a gang. If you think about a military operation, if you don't have trust, people don't trust the order, then you're completely dysfunctional.

**中文翻译:**
事实证明，监狱帮派的管理非常复杂。抱歉扯远了，但管理监狱帮派的问题在于，你面对的人全都来自破碎的文化。在任何组织中，最根本的东西是信任。而你面对的是一群完全没有信任感的人。这有点像军事组织。如果你考虑军事行动，如果没有信任，人们不信任命令，那你就彻底瘫痪了。

---

### [01:28:46] Ben Horowitz

**English:**
So how do you build trust from zero is a very interesting problem. And he's a genius at that, by the way. And I learned a lot from talking to him about it. So from a management standpoint, I would just say it's an important kind of boundary case of how you build culture. He is very, very smart at that. Like I said, you have to look at people about their greatness, not the worst thing they ever did.

**中文翻译:**
所以，如何从零开始建立信任是一个非常有趣的问题。顺便说一下，他在这方面是个天才。我从与他的交谈中学到了很多。从管理学的角度来看，这是一个关于如何建立文化的极端案例。他在那方面非常聪明。就像我说的，你必须看一个人的伟大之处，而不是他做过的最糟糕的事。

---

### [01:29:23] Lenny Rachitsky

**English:**
I know it's the lightning round, but can you just share one example of something he did that was like, wow, that's a really good lesson, someone trying to create a good culture that worked for him?

**中文翻译:**
我知道现在是闪电轮，但你能分享一个他做过的、让你觉得“哇，这真是一课”的例子吗？比如他如何创造出一种行之有效的文化？

---

### [01:29:32] Ben Horowitz

**English:**
Yeah. So one of the things that he did that I thought was really smart is ... Well, he did a couple of things. One is just a simple thing. He just made everybody eat lunch together in the gang, just to build rapport, relationship, trust, like it's all one thing. We're all together on that. And I think particularly in the remote work world and so forth, people really underestimate how powerful just that idea can be.

**中文翻译:**
是的。他做过的一件我认为非常聪明的事是……好吧，他做了好几件事。其中一件很简单：他要求帮派里的每个人必须一起吃午饭。只是为了建立融洽的关系、信任，这都是一回事。我们都在一起。我认为特别是在现在的远程办公世界里，人们真的低估了这个简单想法的力量。

---

### [01:30:26] Ben Horowitz

**English:**
And then another thing he did is, he made morality ... he had very specific things about, you had to be good to your word internally and externally. So normally a gang, like I said, it's kind of a kin-based culture thing. But it made it much more powerful when he said, "Look, you can't do devious shit outside the gang either." And he had a bunch of examples of that, that I went through in the book.

**中文翻译:**
他做的另一件事是建立道德准则……他有非常具体的要求，即无论对内还是对外，你都必须守信用。通常帮派就像我说的，是一种亲缘文化。但他提出：“听着，你在帮派之外也不能做那些阴险勾当（devious shit）。”这让组织变得强大得多。我在书里写了很多这方面的例子。

---

### [01:30:50] Ben Horowitz

**English:**
Like I said, because you're building it from zero, you really have to take a hard line on things that I think people in companies don't even take a hard line on. Is it okay to lie internally? Probably not. Is it okay to lie to a customer? Well, in some organizations it is, but in Shaka's organization, that's as big a penalty as lying internally. These things, I think, end up being really important.

**中文翻译:**
就像我说的，因为你是从零开始建立，你必须在某些事情上采取极其强硬的立场，甚至比一般公司还要强硬。对内撒谎可以吗？可能不行。对客户撒谎可以吗？在某些组织里是可以的，但在 Shaka 的组织里，对客户撒谎的惩罚和对内撒谎一样重。我认为这些细节最终变得非常重要。

---

### [01:31:15] Lenny Rachitsky

**English:**
We're going to link to this book. This is, What You Do is Who You Are. This is your second book that fewer people know about. And this is one of the stories you tell and just what the lessons are for building—

**中文翻译:**
我们会附上这本书的链接，叫《你所做即你所是》。这是你的第二本书，知道的人相对少一些。这是你讲述的故事之一，关于建立文化的教训——

---

### [01:31:23] Ben Horowitz

**English:**
Yeah. It's kind of the more advanced book. You kind of have to survive to want to care about dealing with the cultural issues. And so the survival book has a bigger audience.

**中文翻译:**
是的。这算是一本更进阶的书。你得先活下来，才会想去处理文化问题。所以关于“生存”的那本书受众更广。

---

### [01:31:36] Lenny Rachitsky

**English:**
Amazing. We're going to keep going with Lightning Round. Is there a favorite recent movie or TV show you have really enjoyed?

**中文翻译:**
太棒了。我们继续闪电轮。最近有没有你非常喜欢的电影或电视剧？

---

### [01:31:42] Ben Horowitz

**English:**
Well on TV, I really like Slow Horses, which is the show about the MI6 cast-off guys. And then I haven't seen a lot of movies lately, but I watched Sinners. I went to theater for Sinners. Just the cinematography is unbelievable, and the story is really original, and the acting is incredible, and the costumes are amazing. It's just a great, comprehensive piece of work. The craftsmanship on that thing is just a lot beyond what most people making movies are doing these days, so I really enjoyed that.

**中文翻译:**
电视剧方面，我很喜欢《慢马》（Slow Horses），讲的是一群军情六处（MI6）弃子的故事。最近没看太多电影，但我去电影院看了《罪人》（Sinners）。那部片的摄影简直不可思议，故事非常原创，演技精湛，服装也很棒。这是一部非常伟大的综合性作品。它的工艺水平远超当今大多数电影，我非常享受。

---

### [01:32:24] Lenny Rachitsky

**English:**
I hate scary movies, but I watched it and loved it.

**中文翻译:**
我讨厌恐怖片，但我看了这部，而且很喜欢。

---

### [01:32:27] Ben Horowitz

**English:**
It wasn't that scary.

**中文翻译:**
其实没那么恐怖。

---

### [01:32:29] Lenny Rachitsky

**English:**
It wasn't that scary, but still, it was zombies popping out of corners. That's not my jam usually. Is there a product you recently discovered that you really love? It could be a gadget, it could be clothes, could be something else.

**中文翻译:**
虽然没那么恐怖，但还是有僵尸从角落里跳出来。那通常不是我的菜。最近有没有你发现并非常喜欢的产品？可以是小玩意、衣服或其他东西。

---

### [01:32:40] Ben Horowitz

**English:**
I bought a coffee machine called the Technivorm Moccamaster, which is freaking incredible. In fact, a friend of mine saw it and was like, "What is that?" And I just bought it for him too, because it's so awesome. This thing makes coffee that it's just perfect. There's no bitterness. It's completely clean. It's amazing. The only problem with it is, I can't drink coffee that it doesn't make anymore. I don't know if that's a good thing or bad thing, but ...

**中文翻译:**
我买了一台叫 Technivorm Moccamaster 的咖啡机，简直太棒了。事实上，我一个朋友看到后问：“那是什么？”我也给他买了一台，因为它太赞了。这机器煮出来的咖啡简直完美，没有苦味，口感非常纯净。太神奇了。唯一的缺点是，我现在没法喝不是它煮出来的咖啡了。我不知道这是好事还是坏事，但是……

---

### [01:33:13] Lenny Rachitsky

**English:**
That might come out someday in the AI future.

**中文翻译:**
也许在未来的 AI 时代，这也会被解决。

---

### [01:33:16] Ben Horowitz

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:33:17] Lenny Rachitsky

**English:**
Two more questions. One, is there a life motto that you often come back to, find really useful in work or in life?

**中文翻译:**
还有两个问题。第一，有没有一个你经常想起、并觉得在工作或生活中非常有用的座右铭？

---

### [01:33:24] Ben Horowitz

**English:**
The thing that I would say has had the biggest effect on me is something my father said to me years ago, which is, "Life isn't fair." That seems really, really simple, but I think that the thing that defeats people more than any other thing that I've seen, just in life, is the expectation of some fairness. It's just not fair. There are all kinds of stuff that are going to happen to you, and happen to everybody, that don't happen to other people, that are completely unfair.

**中文翻译:**
对我影响最大的一句话是我父亲多年前对我说的：“生活是不公平的。”这听起来非常简单，但我认为在生活中，最能击垮人们的东西莫过于对“公平”的期待。生活就是不公平的。各种各样的事情会发生在你身上，发生在每个人身上，而不会发生在别人身上，这完全不公平。

---

### [01:34:05] Ben Horowitz

**English:**
But it doesn't matter, because that's the way it is. As soon as you get that idea out of your mind, then you can just deal with it, like, oh yeah, of course it's not fair, but what should I do now, which is the real question, not how do I go back and get people to be fair? Nobody's going to be fair. It's not fair. It's the nature of it. If you think about it for more than five seconds, you'll realize that. It's as an individual, if you want to make the world a better place, whatever, but as an individual, do not expect anything to be fair, it'll only defeat.

**中文翻译:**
但这没关系，因为事实就是如此。一旦你把“公平”这个念头从脑子里赶走，你就能坦然面对：哦，当然不公平，但我现在该怎么办？这才是真正的问题，而不是“我该如何回去让别人变得公平”。没人会变得公平，生活就是不公平的，这是本质。如果你思考超过五秒钟，你就会明白。作为一个个体，如果你想让世界变得更好，那是另一回事；但作为个人，不要期待任何公平，那只会让你失败。

---

### [01:34:43] Lenny Rachitsky

**English:**
Final question. This comes from Shaka, actually. He gave me so many great suggestions. I hate to save this one for last. So the question is, if you had to build a business curriculum from two Hip-hop albums and one Funk album, what would they be and why?

**中文翻译:**
最后一个问题。这其实也是 Shaka 提议的，他给了我太多好建议。我真不想把这个留到最后。问题是：如果你必须用两张嘻哈专辑和一张放克（Funk）专辑来构建一套商业课程，你会选哪些？为什么？

---

### [01:34:58] Ben Horowitz

**English:**
I think probably Follow the Leader by Rakim. And the reason is what we had kind of gotten into earlier, which is leadership. When he came out with that song, which was maybe the greatest Hip-hop song ever written, he's telling people to follow him, follow the leader. And just to have the idea that he was the leader of the entire art form, not just his band, it is amazing idea. And then the way he expressed it was incredible. And then he's got other great concepts in there that would give you ... It's hard to listen to that record and not have confidence.

**中文翻译:**
我想我会选 Rakim 的《Follow the Leader》。原因是我们之前聊过的“领导力”。当他推出那首歌（可能是史上最伟大的嘻哈歌曲）时，他在告诉人们跟随他，跟随领袖。他不仅把自己看作乐队的领袖，还看作整个艺术形式的领袖，这个想法太棒了。他的表达方式也令人惊叹。专辑里还有其他伟大的概念，听这张唱片很难不产生信心。

---

### [01:36:02] Ben Horowitz

**English:**
I think from a competitive, purely competitive standpoint, Stillmatic from Nas, that's the one with Get Ur Self a Gun, that's the one with You're da Man. It's like all of the idea of competition is encapsulated in that album, so that would be the other one. And then Funk, One Nation Under a Groove, for sure. Because it's like, how do you initiate people into a concept or an idea, and how do you infuse them? One Nation Under a Groove is all about joining the nation, and it's so musically interesting and getting people to be part of that. If you asked me tomorrow, I'd probably have three other ones.

**中文翻译:**
从竞争的角度，纯粹的竞争角度，我会选 Nas 的《Stillmatic》。里面有《Get Ur Self a Gun》和《You're da Man》。竞争的所有理念都浓缩在那张专辑里了。放克专辑，肯定选《One Nation Under a Groove》（来自 Parliament）。因为它展示了如何引导人们接受一个概念或想法，并激励他们。这张专辑讲的是加入一个“国度”，音乐上非常有趣，能让人们产生归属感。如果你明天问我，我可能会选另外三张。

---

### [01:37:03] Lenny Rachitsky

**English:**
Incredible. I'm going to go listen to these. Ben, final question, how can listeners be useful to you?

**中文翻译:**
太棒了，我要去听听这些。Ben，最后一个问题，听众可以如何帮到你？

---

### [01:37:07] Ben Horowitz

**English:**
If you get something that makes you better, please take it. If you need more advice on it, let me know. Look, my job is to help everybody build something great, so if you're an entrepreneur, thank you for that.

**中文翻译:**
如果你从这次谈话中学到了能让你变得更好的东西，请尽管拿去。如果你需要更多建议，请告诉我。听着，我的工作就是帮助每个人建立伟大的事业，所以如果你是一名创业者，谢谢你所做的一切。

---

### [01:37:22] Lenny Rachitsky

**English:**
Also, check out Paid in Full, paidinfullfoundation.org, if you want to learn more about that nonprofit.

**中文翻译:**
另外，如果你想了解更多关于那个非营利组织的信息，请访问 paidinfullfoundation.org。

---

### [01:37:26] Ben Horowitz

**English:**
Yes, definitely, we would love to have you.

**中文翻译:**
是的，当然，我们非常欢迎你的加入。

---

### [01:37:29] Lenny Rachitsky

**English:**
Amazing. Ben, thank you so much for being here.

**中文翻译:**
太棒了。Ben，非常感谢你能来。

---

### [01:37:31] Ben Horowitz

**English:**
All right, awesome. Thank you, Lenny.

**中文翻译:**
好的，太棒了。谢谢你，Lenny。

---

### [01:37:33] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。