# Ben Williams - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Ben Williams.

---

### [00:00:00] [Ben Williams]

**English:**
Being able to identify the various micro and macro loops, how they're all connected, being able to document them in a qualitative model to communicate a shared understanding of how you grow, it's really powerful. Augmenting that then with the quantitative side of things that helps guide quarter to quarter focus and ensure you can be intentional about where you're investing, that becomes a big enabler. You're never going to have a shortage of ideas in a high performing growth team. So, knowing where to focus amidst that kind of sea of ideas is a really important role of the strategy.

**中文翻译:**
能够识别各种微观和宏观循环（loops），了解它们是如何相互关联的，并能将它们记录在一个定性模型中，以传达关于公司如何增长的共识，这是非常强大的。随后，通过定量分析来增强这一模型，有助于指导每个季度的重点，并确保你在投资方向上是有意为之的，这会成为一个巨大的助力。在一个高效的增长团队中，你永远不会缺乏创意。因此，在创意的海洋中明确聚焦于何处，是战略中非常重要的一环。

---

### [00:00:40] [Lenny]

**English:**
Welcome to Lenny's Podcast. I'm Lenny, and my goal here is to help you get better at the craft of building and growing products. I interview world-class product leaders and growth experts to learn from their hard-won experiences building and scaling today's most successful companies. Today my guest is Ben Williams. Ben is a VP of product at Snyk which is likely one of the biggest and most interesting companies that you've never heard of. Snyk makes it easy for developers to catch security issues in their code, and there's a lot to learn from how Snyk got started. It started through product-led growth, evolved into product-led sales, was very community driven, and it was also laser-focused on developers which has become one of the most lucrative markets to go after.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你更好地掌握构建和增长产品的技巧。我采访世界级的产品领导者和增长专家，从他们构建和扩展当今最成功公司的艰辛经验中学习。今天的嘉宾是 Ben Williams。Ben 是 Snyk 的产品副总裁，Snyk 可能是你从未听说过的最大、最有趣的公司之一。Snyk 让开发者能够轻松发现代码中的安全问题，Snyk 的起步过程有很多值得学习的地方。它始于产品驱动增长（PLG），演变为产品驱动销售（PLS），非常注重社区驱动，并且始终专注于开发者群体——这已成为目前最赚钱的市场之一。

---

### [00:01:19] [Lenny]

**English:**
In our conversation, we cover how the founders have Snyk out their first a hundred users, what they got wrong when they tried to monetize early on, when they hired their first marketing and sales people, how they structured and grew their growth and product teams, what they figured out about what should go into freemium and what shouldn't, and so much more. As you'll soon hear, Ben is British, and so, the episode is automatically going to sound more sophisticated and I can't wait for you to hear it. With that, I bring you Ben Williams.

**中文翻译:**
在我们的对话中，我们讨论了创始人如何为 Snyk 找到前 100 名用户，他们在早期尝试变现时犯了哪些错误，何时雇佣了第一批营销和销售人员，他们如何构建和扩大增长及产品团队，他们对免费增值模式（Freemium）中哪些功能该免费、哪些不该免费的见解，以及更多内容。正如你很快会听到的，Ben 是英国人，所以这集节目听起来会自动显得更“高级”一些，我迫不及待想让你们听听。现在，让我们欢迎 Ben Williams。

---

### [00:01:48] [Lenny]

**English:**
This episode is brought to you by Coda. Coda's an all-in-one doc that combines the best of documents, spreadsheets, and apps in one place. I actually use Coda every single day. It's my home base for organizing my newsletter writing. It's where I plan my content calendar, capture my research, and write the first drafts of each and every post. It's also where I curate my private knowledge repository for paid newsletter subscribers, and it's also how I manage the workflow for this very podcast. Over the years, I've seen Coda evolve from being a tool that makes teams more productive to one that also helps bring the best practices across the tech industry to life with an incredibly rich collection of templates and guides in the Coda Doc Gallery, including resources for many guests on this podcast, including Shreyas, Gokul, and Shishir, the CEO of Coda. Some of the best teams out there, like Pinterest, Spotify, Square and Uber use Coda to run effectively and have published their templates for anyone to use.

**中文翻译:**
本集节目由 Coda 赞助。Coda 是一款全能文档工具，它将文档、表格和应用程序的优点融合在一起。实际上，我每天都在使用 Coda。它是我整理时事通讯写作的大本营。我在那里规划内容日历、记录研究资料，并撰写每一篇文章的初稿。它也是我为付费订阅者整理私人知识库的地方，我甚至用它来管理这个播客的工作流。多年来，我看到 Coda 从一个提高团队生产力的工具，进化为一个通过 Coda Doc Gallery 中极其丰富的模板和指南，将科技行业的最佳实践变为现实的平台。这些资源包括本播客许多嘉宾的分享，如 Shreyas、Gokul 和 Coda 的 CEO Shishir。Pinterest、Spotify、Square 和 Uber 等顶尖团队都在使用 Coda 高效运行，并发布了供任何人使用的模板。

---

### [00:02:47] [Lenny]

**English:**
If you're ping-ponging between lots of documents and spreadsheets, make your life better and start using Coda. You can take advantage of a special limited time offer just for startups. Head over to coda.io/lenny to sign up and get $1,000 credit on your first statement. That's C-O-D-A.io/lenny to sign up and get $1,000 in credit on your account.

**中文翻译:**
如果你还在大量的文档和表格之间来回切换，让你的生活变得更轻松，开始使用 Coda 吧。你可以享受专门针对初创公司的限时优惠。访问 coda.io/lenny 注册，即可在你的第一张账单中获得 1,000 美元的抵扣额度。即 C-O-D-A.io/lenny，注册并获取 1,000 美元账户额度。

---

### [00:03:15] [Lenny]

**English:**
This episode is brought to you by Athletic Greens. I've been hearing about AG1 on basically every podcast that I listened to, like Tim Ferris and Lex Fridman, and so, I finally gave it a shot earlier this year and it has quickly become a core part of my morning routine, especially on days that I need to go deep on writing or record a podcast like this. Here's three things that I love about AG1. One, with a small scoop that dissolved in water, you're absorbing 75 vitamins, minerals, probiotics, and adaptogens. I kind of like to think of it as a little safety net for my nutrition in case I've missed something in my diet. Two, they treat AG1 like a software product. Apparently they're on their 52nd iteration and they're constantly evolving it based on the latest science, research studies, and internal testing that they do. And three, it's just one easy thing that I can do every single day to take care of myself.

**中文翻译:**
本集节目由 Athletic Greens 赞助。我几乎在听过的每一个播客（比如 Tim Ferris 和 Lex Fridman）中都听说过 AG1，所以我终于在今年早些时候尝试了一下，它迅速成为了我早晨例行公事的核心部分，尤其是在我需要深入写作或录制像这样的播客的日子里。关于 AG1，我有三点非常喜欢：第一，只需一小勺溶解在水中，你就能吸收 75 种维生素、矿物质、益生菌和适应原。我喜欢把它看作是我营养摄入的一个小小安全网，以防我在饮食中遗漏了什么。第二，他们把 AG1 当作软件产品来对待。显然，他们已经进行了第 52 次迭代，并且不断根据最新的科学研究和内部测试进行演进。第三，这是我每天可以做的最简单的一件事来照顾好自己。

---

### [00:04:09] [Lenny]

**English:**
Right now it's time to reclaim your health and arm your immune system with convenient daily nutrition. It's just one scoop in a cup of water every day, and that's it. There's no need for a million different pills and supplements to look out for your health. To make it easy, athletic Greens is going to give you a free one-year supply of immune supporting vitamin D and five free travel packs with your first purchase. All you have to do is visit athleticgreens.com/lenny. Again, that's athletic greens.com/lenny to take ownership over your health and pick up the ultimate daily nutritional insurance.

**中文翻译:**
现在是时候重获健康，用便捷的每日营养武装你的免疫系统了。每天只需在杯子里加一勺水，就这么简单。不需要为了健康去吃无数种不同的药丸和补充剂。为了方便起见，Athletic Greens 将在你首次购买时，免费赠送一年的免疫支持维生素 D 和五个旅行装。你只需访问 athleticgreens.com/lenny。再次强调，访问 athleticgreens.com/lenny，掌控你的健康，获得终极每日营养保障。

---

### [00:04:45] [Lenny]

**English:**
Ben, welcome to the podcast.

**中文翻译:**
Ben，欢迎来到播客。

---

### [00:04:47] [Ben Williams]

**English:**
Thank you very much, Lenny. Thanks first of all for inviting me. It's a pleasure to finally meet you. I've got to say that kind of what you're creating with the newsletter and now the podcast, just such awesome resources for the product growth and wider tech community, so it's real honor to be invited onto the show, and I hope there's a few useful things that people can take away.

**中文翻译:**
非常感谢，Lenny。首先谢谢你邀请我。很高兴终于见到你。我必须说，你通过时事通讯和现在的播客所创造的内容，对产品增长和更广泛的科技社区来说是非常棒的资源，所以能被邀请参加节目真是我的荣幸，希望我分享的一些东西能对大家有所帮助。

---

### [00:05:07] [Lenny]

**English:**
Awesome, man. I really appreciate that. I have no doubt there will be many useful things people will be able to take away. I'm really excited to chat about Snyk and the things that you're building there. I feel like Snyk is this very under-talked about company and also super fascinating companies, especially in terms of how it got started, how it scaled, and it's also at the center of so many trends, product-led growth, community-led growth, focusing on developers to grow, and also just security in general is really interesting, and so, I'm really looking forward to our chat.

**中文翻译:**
太棒了，伙计。我非常感激。我毫不怀疑大家能从中获益良多。我非常兴奋能聊聊 Snyk 以及你们在那里的建设。我觉得 Snyk 是一家被讨论得不够多、但又极其迷人的公司，特别是在它的起步方式、扩展方式方面。它也处于许多趋势的中心：产品驱动增长（PLG）、社区驱动增长、专注于开发者实现增长，而且安全领域本身也非常有趣，所以我非常期待我们的交流。

---

### [00:05:36] [Ben Williams]

**English:**
Me too.

**中文翻译:**
我也是。

---

### [00:05:37] [Lenny]

**English:**
Before we get into all of that, I'd love to spend just a minute on your background. So, you're currently VP product at Snyk, and I'm curious how you got to that role and just some of the other wonderful things you've done in your career along the way there.

**中文翻译:**
在深入探讨这些之前，我想花一分钟了解一下你的背景。你目前是 Snyk 的产品副总裁，我很好奇你是如何走到这个职位的，以及你在职业生涯中经历过的其他精彩事情。

---

### [00:05:51] [Ben Williams]

**English:**
I'll try to keep it reasonably short. My education is in computer science, graduated from the University of Manchester back in the late '90s. I'd already landed as a job as a developer, but ended up having a bunch of other interesting offers, one of which was to join a small startup building requirements management tooling for product and engineering folks. This was all pre-Agile, but that whole space of developer tooling, engineering tooling, it was something I just felt naturally drawn to and it's where I've really specialized through my whole career. I actually joined that company as a solutions engineer, so lots of demos and so on. I was really close to the product team, but also speaking with customers every day which as is quite common I think was my path into products there.

**中文翻译:**
我尽量长话短说。我学的是计算机科学，90 年代末毕业于曼彻斯特大学。当时我已经找到了一份开发者的工作，但后来收到了一系列有趣的录用通知，其中之一是加入一家为产品和工程人员构建需求管理工具的小型初创公司。那还是在敏捷开发（Agile）普及之前，但开发者工具、工程工具这个领域让我感到自然而然的吸引力，这也是我整个职业生涯的专攻方向。我最初是以解决方案工程师（Solutions Engineer）的身份加入那家公司的，所以做了很多演示。我当时离产品团队很近，同时每天与客户交流，我认为这是进入产品领域的常见路径。

---

### [00:06:34] [Ben Williams]

**English:**
Several years and a few acquisitions later, I find myself in IBM with the Rational software developer tooling group. I was leading parts of the product strategy there and a bunch of initiatives. I actually, I learned a ton of useful stuff there, but also that I had a strong preference for working in smaller, fast-growing orgs verse 350,000 people [inaudible 00:06:55]. After an interesting unexpected interlude, leading a DevOps transformation at a fintech and some consulting and advising, I then joined CloudBees. They're a DevOps startup with an open-core model. I was leading product design and growth there. Stayed with them for three years through several raises and a period of really fast growth before finally joining Snyk to build out our growth organization and lead our developer experience initiatives. I have a broad remit at Snyk now than just the growth org, but yeah, that's how it started.

**中文翻译:**
几年后，经过几次收购，我来到了 IBM 的 Rational 软件开发工具部门。我在那里领导部分产品战略和一系列计划。实际上，我在那里学到了很多有用的东西，但也发现自己更倾向于在小型、快速增长的组织中工作，而不是在拥有 35 万人的大公司。在经历了一段有趣的意外插曲——在一家金融科技公司领导 DevOps 转型以及做了一些咨询顾问工作后，我加入了 CloudBees。他们是一家采用开源核心（open-core）模式的 DevOps 初创公司。我在那里负责产品设计和增长。在经历了三年的几轮融资和快速增长期后，我最终加入了 Snyk，负责建立我们的增长组织并领导开发者体验计划。现在我在 Snyk 的职责比最初的增长组织更广泛，但这就是开始的过程。

---

### [00:07:26] [Lenny]

**English:**
Awesome. To give folks a sense of just how successful and big Snyk has gotten, one is just what does Snyk do, we haven't even talked about that yet, and then two, just some stats about the scale of the company and the business at this point.

**中文翻译:**
太棒了。为了让大家了解 Snyk 有多成功、规模有多大，首先请介绍一下 Snyk 是做什么的（我们还没聊到这个），其次是关于目前公司规模和业务的一些数据。

---

### [00:07:40] [Ben Williams]

**English:**
The developer security company, we make it ridiculously easy for developers and their teams to improve their security posture while still moving fast. So, Snyk can find and automatically fixed vulnerabilities in code, open source dependencies, containers, infrastructure and cloud configurations, and all underpinned by the best security intelligence data in the market with a laser focus on developer experiences, which is why we're, we are really different. It's also an amazingly fast-growing business with some stellar PLG-focused investors and board members from the likes of Ed Sim at boldstart to Tamar Yehoshua, Slack CPO. We were founded in 2015, last valuation after our Series F was at 8.6 billion. We're securing the software of millions of developers now, well over 2,000 paying customers, now around 1300 people of which are around 500 in R and D with nearly 70 folks in our product org. And the people here just create this amazing culture, and all in all, it's just a really exciting place to be.

**中文翻译:**
我们是一家开发者安全公司，我们让开发者及其团队在保持高速开发的同时，能够极其容易地改善他们的安全状况。Snyk 可以发现并自动修复代码、开源依赖项、容器、基础设施和云配置中的漏洞。这一切都由市场上最顶尖的安全情报数据支撑，并高度专注于开发者体验，这也是我们与众不同的原因。这是一家增长惊人的公司，拥有一些顶尖的专注于 PLG 的投资者和董事会成员，比如 boldstart 的 Ed Sim 和 Slack 的 CPO Tamar Yehoshua。我们成立于 2015 年，F 轮融资后的估值为 86 亿美元。我们现在为数百万开发者的软件提供安全保障，拥有超过 2000 家付费客户，目前约有 1300 名员工，其中研发人员约 500 人，产品团队近 70 人。这里的人们创造了极佳的文化，总而言之，这是一个非常令人兴奋的地方。

---

### [00:08:44] [Lenny]

**English:**
Okay. Did you have any sense it would get to this scale when you joined early on?

**中文翻译:**
好的。你早期加入时，有预感到它会达到这种规模吗？

---

### [00:08:49] [Ben Williams]

**English:**
Yes, I think because I wasn't looking for a new role when I ended up joining Snyk, when I was first approached by them, but everyone I spoke with along the interview process, just became more and more impressed with not only the caliber of people here, but the vision, the mission for the company, and all those things you mentioned in terms of PLG, community-led growth, focus on developers, the security space, these were all things that if you create a Venn diagram of all the things that I'm really interested in professionally, super interested in, super exciting to me, then kind of Snyk ended up in the middle of it. So, it's pretty cool.

**中文翻译:**
是的，我想是因为当我最终加入 Snyk 时，我并没有在寻找新工作。当他们最初联系我时，我在面试过程中交谈过的每一个人都让我印象深刻，不仅是这里人才的素质，还有公司的愿景和使命。你提到的所有事情——PLG、社区驱动增长、专注于开发者、安全领域——如果你把我职业上真正感兴趣、非常兴奋的所有事物画一个韦恩图，Snyk 恰好就在中心。所以这真的很酷。

---

### [00:09:29] [Lenny]

**English:**
Awesome. So, that's a good segue to where I wanted to start is how Snyk started and how Snyk got their first hundred users, and I know you weren't there necessarily for that, but I'm curious what you can share about how the founders found their first say a hundred users. How did they get to their initial developers and get people excited?

**中文翻译:**
太棒了。这正好引出了我想开始的话题：Snyk 是如何开始的，以及 Snyk 是如何获得前 100 名用户的。我知道你当时不一定在场，但我很好奇你能分享些什么，关于创始人是如何找到最初的 100 名用户的。他们是如何接触到最初的开发者并让大家感到兴奋的？

---

### [00:09:47] [Ben Williams]

**English:**
I think it's a really fun story. So, if you don't mind, I'll just take a moment because I think it's important to set the stage by looking back at-

**中文翻译:**
我觉得这是一个非常有趣的故事。如果你不介意，我想花点时间回顾一下，因为我觉得回顾一下当时的背景很重要——

---

### [00:09:52] [Lenny]

**English:**
Let's do this.

**中文翻译:**
开始吧。

---

### [00:09:53] [Ben Williams]

**English:**
Yeah, just look back at the market in general. So, PLG or bottom up and security, these were never words that were known to have been spoken together in a single sentence, right? So, security has always been a centralized function. Security programs were historically more about audit and policing and enforcement versus developer enablement or empowerment. A sales motion you saw it was always top down. It was seen as immovable, CISOs, other AppSec leaders with the buyers. Security tooling that was out there at the time, they all catered to this dynamic and these were tools that slowed developers down. They created a lot of frustration. They were met with a lot of resistance, not the ideal recipe really for consistent adoption and strong engagement and retention, and ultimately, app security programs based around those kind of solutions just weren't effective as they really needed to be.

**中文翻译:**
是的，看看当时的整体市场。PLG（产品驱动增长）或“自下而上”与“安全”这两个词，在当时几乎从未在同一个句子里出现过，对吧？安全一直是一个中心化的职能。历史上的安全计划更多是关于审计、监管和强制执行，而不是关于开发者的赋能。你看到的销售模式总是自上而下的。它被视为不可撼动的，首席信息安全官（CISO）和其他应用安全（AppSec）领导者才是买家。当时市面上的安全工具都迎合了这种动态，而这些工具往往会拖慢开发者的速度。它们造成了很大的挫败感，遭到了很多抵制，这显然不是实现持续采用、强参与度和高留存的理想配方。最终，基于这类解决方案的应用安全计划并没有达到应有的效果。

---

### [00:10:46] [Ben Williams]

**English:**
So, it was a realization around this, timed with adjacent market shifts happening with DevOps that sparked the ideas behind Snyks. So, the founders, Guy, Danny and Assaf, they saw a real opportunity just to do things differently. They believed that the most effective way to improve application security posture was a developer-first approach. They knew that the developers were increasingly caring about the security of their code in the same way that they cared about performance and functional quality of their code. But they also knew that to empower developers to own that security, they needed just much better tools with way less friction than they ever had before. And their approach was, I think looking back, super smart, focus on a community. It wasn't the full extent of what we'd think of as community-led growth now, but it was close.

**中文翻译:**
正是基于这种认识，再加上 DevOps 带来的相邻市场转变，激发了 Snyk 背后的创意。创始人 Guy、Danny 和 Assaf 看到了一个以不同方式做事的机会。他们相信，改善应用安全状况最有效的方法是“开发者优先”。他们知道，开发者越来越关心代码的安全性，就像关心代码的性能和功能质量一样。但他们也知道，要让开发者能够掌控安全，他们需要比以前更好、摩擦力更小的工具。回顾过去，我认为他们的方法非常聪明：专注于社区。虽然这还不是我们现在所认为的完整的社区驱动增长，但已经很接近了。

---

### [00:11:35] [Ben Williams]

**English:**
They started with a really narrow, early focus. It was a single persona, single context, single use case, and what that meant for Snyk was developers building applications using Node.js who wanted to ensure that the open source dependencies they were pulling into their apps were secure. Now, open source software, that's a huge accelerant in building modern software. The average software application today is at least 75% of open source libraries and components. So, this was increasingly becoming a primary attack vector for malicious actors who could find a single vulnerability in an open source component and then find it and exploit it in every single application that was using that component. And at the same time, at least back then, open source software was much less tested for security vulnerabilities, and the maintainers of open source libraries were often less security aware. So, you get that context, and then at the same time, Node.js as a run time was gaining traction. So, there was this increasing adoption in the enterprise, more and more dedicated conferences and the like, but the community was still small enough that Snyk could meaningfully influence, and Guy and the others just went all out on being deeply involved in that community. They were presenting at dev conferences, meetups, they were building online content and so on.

**中文翻译:**
他们最初的切入点非常窄。单一的用户画像、单一的场景、单一的用例。对于 Snyk 来说，这意味着：使用 Node.js 构建应用程序，并希望确保他们引入应用的开源依赖项是安全的开发者。现在，开源软件是构建现代软件的巨大加速器。如今平均每个软件应用至少有 75% 是开源库和组件。因此，这日益成为恶意攻击者的主要攻击向量，他们只需在某个开源组件中发现一个漏洞，就能在每一个使用该组件的应用中利用它。与此同时，至少在当时，开源软件的安全漏洞测试要少得多，开源库的维护者往往安全意识较低。在这种背景下，Node.js 作为运行时环境正在兴起。企业中的采用率越来越高，相关的专门会议也越来越多，但社区规模仍然足够小，使得 Snyk 能够产生实质性的影响。Guy 和其他人全力以赴深入参与该社区。他们在开发者大会、聚会上演讲，制作在线内容等等。

---

### [00:12:35] [Ben Williams]

**English:**
And the question that they repeatedly posed to the community was do you have known vulnerabilities in your apps, and Snyk was there to help them answer that question. And fun kind of fact on the side, if you search for Snyk in the Urban Dictionary, you'll see it's an acronym for so now you know. But all of this kind of I think really only worked because of the parallel product-led approach. So, while the answer to the question about how does your product monetize users was much less clear cut in the early days for Snyk, the answer to the questions, how does your product acquire and retain users has always been product led.

**中文翻译:**
他们反复向社区提出的问题是：“你的应用中是否存在已知漏洞？”而 Snyk 就是为了帮助他们回答这个问题。顺便提一个有趣的冷知识，如果你在 Urban Dictionary（城市词典）中搜索 Snyk，你会发现它是“So Now You Know”（所以现在你知道了）的缩写。但我认为，所有这些之所以奏效，是因为同时采用了产品驱动的方法。虽然在 Snyk 早期，关于“产品如何变现”的问题答案并不明确，但关于“产品如何获取和留存用户”的答案始终是产品驱动的。

---

### [00:13:35] [Ben Williams]

**English:**
The initial version of Snyk, it was a command line tool. It was a tool for developers, it could be run locally or easily integrated into CICD pipelines for early feedback. It allowed devs to assume more responsibility for the security of their apps, and that was just very different from the typical incumbent technologies that were run by security teams late in the dev process, long feedback loops, issues thrown over the walls, inevitably just frustrating developers. And all of this was just built on this fundamental belief that the only viable path, and by viable I really mean sustainably effective, the only sustainably effective path for software-centric organizations to meet the challenge of becoming and staying secure was for them to take this developer-led approach to that challenge. So, really kind of complete disruption of the industry and developer adoption for that reason was always a key priority for us.

**中文翻译:**
Snyk 的初始版本是一个命令行工具。它是为开发者设计的，可以在本地运行，也可以轻松集成到 CI/CD 流水线中以获得早期反馈。它让开发者能够对应用的安全性承担更多责任，这与典型的传统技术截然不同——传统技术由安全团队在开发过程的后期运行，反馈周期长，问题被“扔过墙”给开发，不可避免地让开发者感到沮丧。所有这一切都建立在一个基本信念之上：对于以软件为中心的企业来说，应对安全挑战唯一可行且持续有效的路径，就是采取这种“开发者主导”的方法。因此，这实际上是对行业的彻底颠覆，而开发者采用率也因此一直是我们的核心优先级。

---

### [00:14:31] [Ben Williams]

**English:**
So, with that in mind, Snyk has just been free to use in some capacity from day one, and the early strategy was always about creating something valuable that was readily available, something that solved a real problem in a uniquely differentiated way, and making it pervasive. So, with dev-led option, this core concern, a freemium go-to-market strategy was just the obvious approach. So, eventually, getting back to your original question, that's all of the context and where and when and how they did it, but the first hundred or so users really just came from the founders engaging with the Node.js community and the interest that drove. I think we probably had maybe around 5,000 free users before there are any attempts at monetization.

**中文翻译:**
考虑到这一点，Snyk 从第一天起就可以在某种程度上免费使用。早期的策略始终是创造一些有价值且易于获取的东西，以独特差异化的方式解决真实问题，并使其无处不在。既然“开发者主导”是核心关注点，那么免费增值（Freemium）的进入市场策略就是显而易见的选择。所以，回到你最初的问题，在了解了所有背景、时间、地点和方式后，前 100 名左右的用户其实就是来自创始人与 Node.js 社区的互动以及由此引发的兴趣。我想在尝试任何变现手段之前，我们可能已经有了大约 5000 名免费用户。

---

### [00:15:13] [Lenny]

**English:**
Awesome. There's a bunch I want to unpack there because what's interesting the way you describe it maps to the series that I recently wrote about consumer growth strategy and how the first three steps after you have an idea is to come up with your super specific who, kind of your target persona, come up with a hook that catches them and gets them excited, and then go find them where they are and pitch them your hook. So, the super specific who for Snyk was you said open source developers working on Node.js. Is that right?

**中文翻译:**
太棒了。这里有很多我想拆解的内容，因为你描述的方式正好对应了我最近写的关于消费者增长策略的系列文章。在那篇文章中，我提到有了创意后的前三步是：确定你超级具体的“受众”（Who），即目标画像；设计一个能吸引并让他们兴奋的“钩子”（Hook）；然后去他们所在的地方找到他们，并向他们推销你的“钩子”。所以，Snyk 超级具体的“受众”是你说过的使用 Node.js 的开源开发者，对吗？

---

### [00:15:41] [Ben Williams]

**English:**
Well, it was Node.js developers, and Node.js developers were building their applications using open source Node components.

**中文翻译:**
是的，是 Node.js 开发者，而这些 Node.js 开发者正在使用开源 Node 组件构建他们的应用程序。

---

### [00:15:50] [Lenny]

**English:**
Mm-hmm. Got it. Was there any other constraint to that, do you know, or those were the two to three attributes of a user?

**中文翻译:**
嗯，明白了。除此之外还有其他限制吗？或者说这就是该用户的两到三个核心属性？

---

### [00:15:56] [Ben Williams]

**English:**
That's really it. The community was growing for sure. It was big enough to have a decent opportunity there-

**中文翻译:**
真的就这些。社区当时确实在增长，规模大到足以产生不错的机会——

---

### [00:16:03] [Lenny]

**English:**
Makes sense.

**中文翻译:**
有道理。

---

### [00:16:04] [Ben Williams]

**English:**
... but narrow enough that technology wise, it meant that a product could be brought to market in a reasonable time.

**中文翻译:**
……但从技术角度看又足够窄，这意味着产品可以在合理的时间内推向市场。

---

### [00:16:10] [Lenny]

**English:**
Yeah, that's great. And then the hook was basically you have known vulnerabilities in your code base which if I were an engineer, like, "I don't know, shoot, I don't know. Get a find exactly. I'm scared now."

**中文翻译:**
是的，太棒了。然后“钩子”基本上就是“你的代码库中有已知漏洞”。如果我是工程师，我会想：“我不知道啊，该死，我得去查清楚。我现在有点害怕了。”

---

### [00:16:20] [Ben Williams]

**English:**
Exactly. And then so now you know. Right?

**中文翻译:**
没错。然后就是“所以现在你知道了”（So Now You Know），对吧？

---

### [00:16:22] [Lenny]

**English:**
Yeah, exactly. Okay, cool. And then the where, so you said that they went to open source communities. Do you have any more specifics about what those were? Was it like a specific forum? Was it like GitHub somewhere? Was it Reddit? Do you know any idea where those communities lived?

**中文翻译:**
是的，没错。好，酷。然后是“地点”（Where），你说他们去了开源社区。你有更具体的细节吗？是特定的论坛？是 GitHub 的某个地方？还是 Reddit？你知道这些社区主要活跃在哪里吗？

---

### [00:16:36] [Ben Williams]

**English:**
Yeah, it was less about a particular place, but more about the community of developers themselves who focused on Node.js. So, a bunch of early evangelism was really at conferences. It was I think the Velocity Conference in Amsterdam where Guy and Assaf kind of first unveiled Snyk to the world, and yeah, it went from there.

**中文翻译:**
是的，与其说是某个特定的地方，不如说是专注于 Node.js 的开发者社区本身。所以，早期的很多布道工作实际上是在会议上进行的。我想是在阿姆斯特丹的 Velocity 大会上，Guy 和 Assaf 第一次向世界展示了 Snyk，然后就从那里开始了。

---

### [00:16:58] [Lenny]

**English:**
I see. Interesting. So, it was in-person events, conferences, and meetups probably focused on Node.js developers.

**中文翻译:**
我明白了。很有趣。所以是线下活动、会议和可能专注于 Node.js 开发者的聚会。

---

### [00:17:03] [Ben Williams]

**English:**
Exactly. Yeah.

**中文翻译:**
没错，是的。

---

### [00:17:05] [Lenny]

**English:**
Okay, awesome. What happened after that? So, that was the first hundred. Was it just roughly the next stage of growth or did it focus on that for a long time? What was the next stage roughly?

**中文翻译:**
好的，太棒了。那之后发生了什么？那是前 100 名用户。之后是直接进入下一个增长阶段，还是在那个领域专注了很长时间？下一个阶段大致是什么样的？

---

### [00:17:14] [Ben Williams]

**English:**
Yeah. I think that focus was the really important kind of element there, if I can kind of latch on that. Starting with that narrow focus and building around community engagement, I think it's a well-proven playbook now, particularly in the developer tooling space like New Relic did it notably with Ruby community for example. But ultimately it was important because of this kind of depth verse breadth approach and that depth-first approach that Snyk took was important to be able to effectively validate the solution on the path to product market fit. A JavaScript developer just won't care if you support Golang or Rust, but will absolutely care if a key feature like automated package upgrades just isn't available for their ecosystem.

**中文翻译:**
是的。如果我可以补充一点的话，我认为那种“聚焦”是非常关键的元素。从狭窄的焦点开始并围绕社区参与进行构建，我认为这现在已经是一个被充分证明的策略了，特别是在开发者工具领域，比如 New Relic 在 Ruby 社区的做法就非常出名。但归根结底，这种“深度胜过广度”的方法非常重要，Snyk 采取的这种“深度优先”策略对于在通往产品市场匹配（PMF）的道路上有效验证解决方案至关重要。一个 JavaScript 开发者根本不在乎你是否支持 Golang 或 Rust，但如果像“自动包升级”这样的核心功能在他们的生态系统中不可用，他们绝对会非常在意。

---

### [00:18:04] [Ben Williams]

**English:**
Of course, the bigger problem of vulnerable components in open source across all languages and all ecosystems, that's a very widespread problem. It affects the industry at large, but that just spoke to the potential opportunity that was there to be unlocked. But the key for Snyk I think was just not to go too wide, too early. So, it focused on nailing that initial use case for that specific community of Node.js devs, like I say, narrow enough to be able to really focus on quickly building a compelling solution to a real problem, but also wide enough to be something viable from a growth perspective. And even back then the NPM, the Node Package Manager hosted around 200,000 open source packages. They were downloaded something like two and a half billion times a month by over 2 million devs. And the typical node app would have hundreds of dependencies, mostly indirect and so hidden less immediately visible. But each of those dependencies brought with it some security risks. So, yeah, I think nailing that narrow and deep-use case before expanding wider was absolutely critical and generally just sound advice around finding product market fit and building solid momentum before casting a wider net. It's difficult to maintain that focus for sure as the lure of that bigger term can be really tempting, but ultimately you have to build a service and market well to capture it.

**中文翻译:**
当然，所有语言和生态系统中开源组件存在的漏洞是一个非常普遍的问题，它影响着整个行业，但这仅仅说明了那里存在着待开启的巨大潜力。但我认为 Snyk 的关键在于没有过早地铺得太开。它专注于为 Node.js 开发者这个特定社区解决最初的用例。正如我所说，这个切入点窄到足以让人专注于快速构建一个解决真实问题的引人注目的方案，但从增长的角度来看，它又宽到足以维持生存。即使在当时，NPM（Node 包管理器）也托管了大约 20 万个开源包，每月被超过 200 万开发者下载约 25 亿次。一个典型的 Node 应用会有数百个依赖项，其中大部分是间接的，因此隐藏得较深，不那么直观。但每一个依赖项都带来了安全风险。所以，我认为在扩大范围之前，先攻克这个“窄而深”的用例是绝对关键的，这也是寻找 PMF 和在撒大网之前建立稳固势头的明智建议。保持这种专注确实很难，因为更大的市场诱惑力很大，但最终你必须先构建好服务并做好市场，才能真正抓住它。

---

### [00:19:23] [Lenny]

**English:**
Do you have a sense of when that focus expanded to an adjacent group, how many years into the growth story that happened, or was there some kind of milestone there? Because I know everyone imagines, yeah, we'll expand, the question is when and when does it make sense and when is it too early. Do you have any insights into that phase?

**中文翻译:**
你是否知道这种焦点何时扩展到了相邻群体？是在增长故事开始后的第几年发生的，还是有什么里程碑？因为我知道每个人都会设想“是的，我们会扩张”，问题是什么时候扩张、什么时候合适、什么时候又太早。你对那个阶段有什么见解吗？

---

### [00:19:43] [Ben Williams]

**English:**
Yeah, for sure. First, I think if we're talking about PLG and the story with Snyk, I actually like that definition of product-led acquisition from Julian Shapiro when you spoke with him, and beyond that maniacal focus on finding product market fit for your product, founders really should be thinking about how their product is going to grow, and that's important of course as you think about taking that next step. So, let's assume in a simplistic definition that you found product market fit as demonstrated by a strong retention, and then the real question is where are the new users for your product going to come from, and founders really should have, I think, strong hypothesis around this, your risk essentially, adopting an if we build it, they'll come approach.

**中文翻译:**
是的，当然。首先，如果我们谈论 PLG 和 Snyk 的故事，我其实很喜欢你和 Julian Shapiro 交流时他提到的“产品驱动获取”的定义。除了疯狂地专注于为产品寻找 PMF 之外，创始人真的应该思考他们的产品将如何增长，当你考虑迈出下一步时，这当然非常重要。假设在一个简单的定义中，你已经通过强劲的留存证明了你找到了 PMF，那么真正的问题是：你的产品新用户将从哪里来？我认为创始人应该对此有强有力的假设，否则你本质上是在冒险采用“只要我们做出来，用户就会来”的方法。

---

### [00:20:27] [Ben Williams]

**English:**
So, if your acquisition strategy is product- led, then understanding and being intentional about your early acquisition growth loops I think is an essential founder's responsibility. Dedicating time there to design those loops into the product, it's key. And when I say product, I really mean the whole product experience considering every touchpoint in and out of the core application that your users and customers might have with you. Snyk, for example, believed very early that we could build out powerful content loops via fixed pull requests that we raise on GitHub. New users, they'll sign up for Snyk, they'll connect their GitHub accounts, Snyk will scan their code, will find vulnerabilities, will automatically create Snyk-branded pull requests to fix those vulnerabilities. Other devs in the repo will see and interact with those PRs, and some of them will follow links to Snyk, create accounts and some of them will connect their own repos, and so the loop continues. So, company generated, company distributed content loop, it's actually really powerful for us because it's both an acquisition loop and an engagement loop.

**中文翻译:**
所以，如果你的获取策略是产品驱动的，那么理解并有意识地构建早期的获取增长循环（growth loops）我认为是创始人的核心职责。花时间将这些循环设计进产品中是关键。当我提到“产品”时，我指的是整个产品体验，考虑到用户和客户在核心应用内外与你可能产生的所有接触点。例如，Snyk 很早就相信我们可以通过在 GitHub 上发起的“修复拉取请求”（fixed pull requests）建立强大的内容循环。新用户注册 Snyk，连接他们的 GitHub 账号，Snyk 扫描代码，发现漏洞，并自动创建带有 Snyk 品牌的 PR 来修复这些漏洞。代码库中的其他开发者会看到并与这些 PR 互动，其中一些人会点击链接来到 Snyk，创建账号，然后连接他们自己的代码库，循环就这样继续下去。这种“公司生成、公司分发”的内容循环对我们来说非常强大，因为它既是获取循环，也是参与循环。

---

### [00:21:28] [Ben Williams]

**English:**
Over the course of time, we extended that loop by adding support for other source controlled systems beyond GitHub. We layered on a bunch of new loops, and I think if founders can be intentional about this as you're developing early product iterations, then you're going to have a bigger advantage when the product clicks with the market, and that was built into Snyk as we went along. So, that was kind of ready as we found product market fit. But I think to talk about specifically how Snyk took that next stage, it was a function of when we were chatting before this, we talked a little bit about some of the failed experiences spinning up a self-serve revenue channel, and-

**中文翻译:**
随着时间的推移，我们通过增加对 GitHub 以外的其他源码控制系统的支持来扩展这个循环。我们叠加了一系列新循环。我认为，如果创始人在开发早期产品迭代时能有意识地这样做，那么当产品与市场契合时，你就会拥有更大的优势。Snyk 在发展过程中就内置了这些。所以当我们找到 PMF 时，这些已经准备就绪了。但要具体谈谈 Snyk 如何进入下一个阶段，这与我们之前聊到的有关建立自服务营收渠道的一些失败经验有关，而且——

---

### [00:22:09] [Lenny]

**English:**
Actually before we get there, which I definitely want to get into all that, I love this story you just shared. I hadn't heard of this growth tactic of basically they connect their GitHub account, you find all the vulnerabilities, push a fix, people see that Snyk did this for them and it just provides all this value, and you're saying that was really effective. It's an example of something that worked very well.

**中文翻译:**
在聊那个之前（我肯定想深入聊聊），我非常喜欢你刚才分享的故事。我以前没听说过这种增长策略：基本上用户连接 GitHub 账号，你发现所有漏洞，推送修复，人们看到 Snyk 为他们做了这些并提供了巨大的价值。你是说这非常有效，这是一个非常成功的案例。

---

### [00:22:29] [Ben Williams]

**English:**
First of all, that integration in terms of connecting your code with security scanning like that was a first of a kind integration.

**中文翻译:**
首先，这种将代码与安全扫描连接起来的集成方式在当时是首创的。

---

### [00:22:38] [Lenny]

**English:**
Yeah, magic.

**中文翻译:**
是的，简直像魔法。

---

### [00:22:39] [Ben Williams]

**English:**
No one had done that before. But the key was that we ultimately controlled the content. So, not only was the fixed pull request doing something useful in terms of the code, but all of the description of the pull request was explaining about the vulnerability, educating users, and it was all Snyk branded and saying, "If you find this useful, click here, come and learn more about the vulnerability. Sign up for an account if you don't have one." It kept existing users coming back.

**中文翻译:**
以前没人这么做过。但关键在于我们最终控制了内容。所以，修复 PR 不仅在代码层面做了有用的事，而且 PR 的所有描述都在解释漏洞、教育用户，并且全部带有 Snyk 品牌，上面写着：“如果你觉得这很有用，请点击这里，了解更多关于该漏洞的信息。如果你还没有账号，请注册。”这让老用户不断回来。

---

### [00:23:03] [Ben Williams]

**English:**
You sign up for an account if you don't have one, it kept existing users coming back and it brings new users, a lot of new users, in fact.

**中文翻译:**
如果你没有账号就注册一个，它让老用户留存，并带来了新用户，实际上是带来了大量新用户。

---

### [00:23:06] [Lenny]

**English:**
You'd be in there all like, "Do you have known vulnerabilities in your code base? Click here to find out." Is that responsible for much of the early growth, that loop?

**中文翻译:**
你就像在说：“你的代码库中有已知漏洞吗？点击这里查看。”这个循环是早期增长的主要原因吗？

---

### [00:23:15] [Ben Williams]

**English:**
I think that was one of the loops. We also have a couple of, from fairly early on as well, other content loops that are more kind of programmatic SEO assets that have both been pretty instrumental in terms of new user growth, yeah.

**中文翻译:**
我认为那是循环之一。我们从很早开始还有另外几个内容循环，更多是程序化 SEO 资产，它们在吸引新用户增长方面也起到了非常关键的作用。

---

### [00:23:31] [Lenny]

**English:**
It'd be cool to hear about those if they're relatively straightforward to explain, and then we can get to the thing that didn't work, the self-serve monetization piece you were going to get to.

**中文翻译:**
如果这些解释起来相对简单，听听它们会很酷。然后我们可以聊聊那个没奏效的东西，就是你刚才要提到的自服务变现部分。

---

### [00:23:40] [Ben Williams]

**English:**
We have a bunch of loops actually at this point to start off.

**中文翻译:**
实际上，我们现在有很多循环可以聊。

---

### [00:23:42] [Lenny]

**English:**
Lucky you.

**中文翻译:**
你真幸运。

---

### [00:23:44] [Ben Williams]

**English:**
Yeah, I'm a big loopist, funnily enough. But yeah, we have a bunch of loops. Company generated, company distributed content loops have actually worked really well for us. We have a side car product called Snyk Advisor. Snyk Advisor, it's basically a service that developers use to search and find open source packages when they're considering integrating some within their software applications. The unique thing about it is it indexes all of the package managers. It learns about those packages. It augments the data about them with a bunch of metadata, including of course Snyk security scans, but we also find out how actively maintained the software is on the source repo on GitHub or wherever.

**中文翻译:**
是的，说来也巧，我是个坚定的“循环论者”。我们确实有很多循环。公司生成、公司分发的内容循环对我们非常有效。我们有一个名为 Snyk Advisor 的周边产品。Snyk Advisor 基本上是一个供开发者在考虑将开源包集成到软件应用中时，用来搜索和查找这些包的服务。它的独特之处在于它索引了所有的包管理器。它学习这些包的信息，并用大量元数据增强这些数据，当然包括 Snyk 的安全扫描，但我们还会查出该软件在 GitHub 或其他源码库上的维护活跃度。

---

### [00:24:31] [Ben Williams]

**English:**
We build this kind of package health score, so anyone searching on Google for a package that does X, Y, Z or a specific package by name, Snyk Advisor will be right up there in terms of the search results. They'll land on there, they'll get a good idea about that package, they can look at similar packages and it's all, of course, a Snyk website and we have CTAs to say, "If you want to secure your application on a perpetual basis, then just come and join us." That's a great loop. That's all kind of a programmatic asset. There are hundreds of thousands of these package pages, but they're just automatically being generated continuously.

**中文翻译:**
我们构建了这种“包健康评分”，所以任何在 Google 上搜索实现某功能的包或特定名称的包的人，Snyk Advisor 都会出现在搜索结果的前列。他们点击进入，就能很好地了解那个包，还可以查看类似的包。当然，这整个都是 Snyk 的网站，我们有行动号召（CTA）说：“如果你想永久保护你的应用安全，那就加入我们吧。”这是一个很棒的循环。这完全是一种程序化资产。有成千上万个这样的包页面，它们只是在不断地自动生成。

---

### [00:25:07] [Lenny]

**English:**
Got it. It's programmatically generated better indexing of open source libraries that you can integrate with. That is so smart. It's programmatic because you can inform on the security vulnerabilities and then the maintenance and activity. Interesting. Yeah, that makes sense. That's all data you could just gather. That's awesome. Okay, so there's that. Is there anything else that's worked really well for you guys to help you grow self-serve?

**中文翻译:**
明白了。这是程序化生成的、更好的开源库索引，方便用户集成。这太聪明了。它是程序化的，因为你可以提供安全漏洞信息，还有维护和活跃度信息。很有趣。是的，这很有道理，这些都是你可以直接收集的数据。太棒了。好，那是其中之一。还有什么其他对你们自服务增长非常有帮助的方法吗？

---

### [00:25:31] [Ben Williams]

**English:**
One of the recent ones that's really interesting is security education. We think of Snyk as a change agent in helping DevSecOps transformations and it's fine kind of having this capability, but what we really want to get to is this position where developers truly understand and can be better placed to prevent security vulnerabilities being injected into their code. One of the things that is, again, something that's pretty different from the industry from an incumbent perspective is that we believe it's really important to democratize security education.

**中文翻译:**
最近一个非常有趣的是安全教育。我们将 Snyk 视为帮助 DevSecOps 转型的变革推动者。拥有这种能力固然好，但我们真正想达到的是让开发者真正理解并能更好地防止安全漏洞被注入到代码中。再次强调，从行业传统视角来看，我们做了一件非常不同的事：我们相信民主化安全教育非常重要。

---

### [00:26:06] [Ben Williams]

**English:**
We have been building this bunch of really high quality but bite size lessons about developer security that focus on developers about security issues and vulnerabilities and we surface them. Again, they're out there in the public domain. There's no paywall to get access to those. All the traditional solutions you need to sign up, you need to pay to get access beyond more than a couple. But these were just, they're all out there in the public domain. That works really well for us from a company generated company distributed loop as well.

**中文翻译:**
我们一直在构建一系列高质量、碎片化的开发者安全课程，专注于开发者关心的安全问题和漏洞，并将它们展示出来。同样，这些都是公开的。访问这些内容没有付费墙。所有传统的解决方案都需要你注册、付费才能访问两个以上的课程。但我们的这些内容完全在公共领域。这对我们来说也是一个非常有效的“公司生成、公司分发”的循环。

---

### [00:26:36] [Lenny]

**English:**
So cool. SEO and then integrating to GitHub in an interesting way. Imagine there's also a lot of intra-company virality when someone uses Snyk at a company and they spread it to their colleagues?

**中文翻译:**
太酷了。SEO 加上以有趣的方式集成到 GitHub。我猜当公司里有人使用 Snyk 并将其传播给同事时，也会有很多公司内部的病毒式传播吧？

---

### [00:26:47] [Ben Williams]

**English:**
Yeah, I mean, I didn't talk about those. I think those are pretty well understood. We have both referral loops and invite loops as well.

**中文翻译:**
是的，我是说，我还没提到那些。我认为那些大家都很熟悉了。我们既有推荐循环（referral loops），也有邀请循环（invite loops）。

---

### [00:26:55] [Lenny]

**English:**
Okay, awesome. Coming back to what didn't work, and I think you mentioned that there was a monetization attempt that was self-service oriented and that had some challenges. Can you talk about that?

**中文翻译:**
好的，太棒了。回到那些没奏效的事情上，我想你提到过曾有一个面向自服务的变现尝试遇到了挑战。你能聊聊那个吗？

---

### [00:27:06] [Ben Williams]

**English:**
At the time, a few things were in place. Valuable product, check, strong developer user growth, check, strong retention, check, but the first self-serve monetization efforts only really saw traction with individual developers paying a hundred dollars a month. Or purchases in larger companies, they just didn't happen as everyone had hoped. There was a really critical part of Snyk's history. At the time a bunch of investors didn't lean in, perhaps shy away from early conviction with the founders on building strong usage without a proven path to monetization at that point. Ed at BOLDStart who I mentioned previously, he was one of the first kind of true believers and was I think really key in helping with providing runway during that time. But it was clear that there was a lot of work still to do. The team dived in, they really figured out what the constraints were and through that process really learned about the importance of catering for the broader governance needs of the enterprise buyer.

**中文翻译:**
当时，有几件事已经就绪：有价值的产品，达成；强劲的开发者用户增长，达成；强劲的留存，达成。但最初的自服务变现尝试只在每月支付 100 美元的个人开发者那里见到了成效。而在大公司里的采购并没有像大家希望的那样发生。那是 Snyk 历史上一个非常关键的时期。当时很多投资者并没有跟进，也许是因为在没有证明变现路径的情况下，他们对创始人建立的强劲使用量缺乏早期信心。我之前提到的 BOLDStart 的 Ed 是最早的坚定支持者之一，我认为他在那段时间提供资金支持（runway）起到了关键作用。但很明显，还有很多工作要做。团队深入研究，找出了瓶颈所在，并通过那个过程真正了解了满足企业买家更广泛治理（governance）需求的重要性。

---

### [00:28:07] [Ben Williams]

**English:**
And that meant a couple of things. First, there was a need to build out table stakes features around governance at scale. Just things that companies of a certain scale and size expected reporting, robust user management and so on. And second that it was time to move beyond that depth first approach, right? That depth first approach was absolutely critical in getting to that point, but it wasn't good enough to take the next step. If you think about it, there's a point in a company scale where you start to see diversification of tech stacks and all of those tech stacks need securing. It's obvious in retrospect that only supporting developers using a narrow slice of those tech stacks wasn't going to meet the needs of the security teams who were ultimately the people who were held accountable for the security of their entire application estate. The teams worked hard over the next few months starting to build support for additional languages and ecosystems and adding those table stakes features.

**中文翻译:**
这意味着两件事：第一，需要构建大规模治理方面的“入场券”功能（table stakes features）。就是一定规模的公司所期望的报告功能、强大的用户管理等等。第二，是时候超越那种“深度优先”的方法了。深度优先对于达到那个阶段至关重要，但不足以支撑迈出下一步。如果你仔细想想，当公司规模达到一定程度时，你会看到技术栈的多样化，而所有这些技术栈都需要安全保障。回过头来看，显而易见的是，仅支持使用一小部分技术栈的开发者，无法满足安全团队的需求，而安全团队才是最终对整个应用资产安全负责的人。在接下来的几个月里，团队努力工作，开始增加对更多语言和生态系统的支持，并添加了那些基础功能。

---

### [00:29:04] [Ben Williams]

**English:**
I think back then Snyk were simply ahead of this inevitable curve of developer first security. At the time, the only buyers were security teams and dev first Security for the most part wasn't something that CISOs and ApSec leaders were driving. But if you look at Snyk through that lens of, as I mentioned, being a change agent, being a key piece of the transformational journey of our customers' DevSecOps journeys, you realize how important it was for us to start to build relationships with those security leaders. It was that time also that it was the right time to bring in the first sales and engineering hires as well.

**中文翻译:**
我认为当时 Snyk 只是走在了“开发者优先安全”这一必然趋势的前面。那时，唯一的买家是安全团队，而“开发者优先安全”在很大程度上并不是 CISO 和应用安全领导者所推动的。但如果你从我提到的“变革推动者”的角度来看 Snyk，把它看作客户 DevSecOps 转型旅程中的关键一环，你就会意识到我们开始与这些安全领导者建立关系是多么重要。也就是在那个时候，也是引入第一批销售和工程人员的正确时机。

---

### [00:29:48] [Lenny]

**English:**
You basically found it couldn't work self-serve monetization, it worked as a way to get into a company and then developers started using it in small scale, but you needed sales and marketing to really grow monetization. Is that what you found?

**中文翻译:**
你基本上发现自服务变现行不通，它只是进入公司的一种方式，然后开发者开始小规模使用，但你需要销售和营销来真正实现变现增长。这就是你发现的情况吗？

---

### [00:30:04] [Ben Williams]

**English:**
Today it's less like that. There are organizations where the buying center is still very much ApSec, but there are also many organizations where kind of technical leaders on the buying decision around security investments. What was always true though even back then was the influencing power of developers, regardless of where the buying center was.

**中文翻译:**
今天情况不太一样了。有些组织的采购中心仍然主要是应用安全部门，但也有很多组织的采购决策是由技术领导者做出的。不过，即使在当时，无论采购中心在哪里，开发者的影响力始终是存在的。

---

### [00:30:28] [Lenny]

**English:**
And I imagine as the brand has grown, it's gotten easier to convince people like, "Oh yeah, look at all these other logos using this. It's probably going to be okay."

**中文翻译:**
我猜随着品牌的成长，说服人们变得更容易了，比如：“哦，看，这么多其他大公司都在用这个，那肯定没问题。”

---

### [00:30:33] [Ben Williams]

**English:**
For sure.

**中文翻译:**
确实如此。

---

### [00:30:36] [Lenny]

**English:**
Just to understand in your experience with Snyk, it never really worked self-served monetization. It worked as a way to get into a company and then developers started using it in small scale, but you needed sales and marketing to really grow monetization. Is that what you found?

**中文翻译:**
为了确认一下，根据你在 Snyk 的经验，自服务变现从未真正成功过。它只是作为进入公司的一种方式，然后开发者开始小规模使用，但你需要销售和营销来真正推动变现增长。是这样吗？

---

### [00:30:51] [Ben Williams]

**English:**
I think back then, yes. Now it's a very different story. We have a lot of self-serve only customers scaling pretty large, so.

**中文翻译:**
我想在当时，是的。但现在情况完全不同了。我们有很多纯自服务的客户，规模也做得很大。

---

### [00:30:59] [Lenny]

**English:**
Got it. That's interesting. I rarely hear that you start out with sales being important and it becomes less important or I imagine it's still very important, but there's like a segment that has emerged that can self-serve. Fascinating.

**中文翻译:**
明白了。这很有趣。我很少听说一开始销售很重要，后来变得没那么重要，或者我猜销售依然很重要，但出现了一个可以自服务的细分市场。太迷人了。

---

### [00:31:14] [Ben Williams]

**English:**
Yeah, I think it is important to acknowledge though, that the product has always played a really key part in the sales process for sure.

**中文翻译:**
是的，但我认为必须承认，产品在销售过程中始终扮演着非常关键的角色。

---

### [00:31:21] [Lenny]

**English:**
That touches on something I wanted to ask. [inaudible 00:31:24] you've mentioned him a couple times, he's got this awesome newsletter, he talks about you guys all the time. I think he's very proud of the progress of Snyk and he talks a lot about that for developers, you got to win hearts and minds of developers to build something that works. Any lessons or pieces of advice for folks that are targeting developers to win hearts and minds and get engineers, developers excited about what you're building?

**中文翻译:**
这触及了我想问的一个问题。你提到过他几次，他有一份很棒的时事通讯，经常提到你们。我想他为 Snyk 的进步感到非常自豪，他经常说对于开发者，你必须赢得他们的“心智”才能做出成功的产品。对于那些目标受众是开发者的人，你有什么经验或建议来赢得他们的心智，并让工程师、开发者对你正在构建的东西感到兴奋吗？

---

### [00:31:47] [Ben Williams]

**English:**
I think there's two things, right? First of all, fundamentally for someone to get excited about using a product, they've got to care enough, right? They've got to have a problem that you're solving. I think there's two things. One, there is a shift that is happening and still happening. I think there's still a long way to go for developers to really care about security as an integral part of their job in the same way they think about functional quality or performance. I think that we're still, we're making strong progress there. It's changing all the time, but there's still a long way to go there. But the reality is that I think in most companies, developers have to care about security because their companies need to be secure. The key then is how do I make the job of being secure for these developers, as painless as it absolutely needs to be?

**中文翻译:**
我认为有两点。首先，从根本上说，要让某人对使用产品感到兴奋，他们必须足够在意，对吧？他们必须有一个你正在解决的问题。我认为有两方面：第一，一种转变正在发生，而且仍在继续。我认为要让开发者真正像对待功能质量或性能那样，将安全视为工作中不可或缺的一部分，还有很长的路要走。我觉得我们正在取得重大进展，情况一直在变，但仍有很长的路。但现实是，我认为在大多数公司，开发者必须关心安全，因为公司需要安全。那么关键就在于：我如何让这些开发者的安全工作变得尽可能地无痛？

---

### [00:32:44] [Ben Williams]

**English:**
And that means really meeting them where they are, integrating with their tools, finding ways to take security to them instead of trying to pull them out of their workflows. Flow is just this incredibly important concept for developers and you want to strive to keep them in that flow for as long as possible. The GitHub kind of pool requests are a great example of that. Someone can sign up for Snyk and they could theoretically be the only user of Snyk and connect their repos. All of a sudden we're protecting, securing those repos, a hundred, a thousand developers could be working in GitHub with that code, all benefiting from Snyk without necessarily needing to sign up. That's that example of taking the product to users without pulling them out of their workflows. I think that's absolutely critical.

**中文翻译:**
这意味着要真正做到“在他们所在的地方与他们相遇”，集成到他们的工具中，想办法把安全带给他们，而不是试图把他们从工作流中拉出来。“心流”（Flow）对开发者来说是一个极其重要的概念，你要努力让他们尽可能长时间地保持在那种状态中。GitHub 的拉取请求就是一个很好的例子。某人注册了 Snyk，理论上他可以是 Snyk 的唯一用户并连接他的代码库。突然之间，我们就在保护这些代码库的安全，成百上千名开发者可能在 GitHub 上处理这些代码，他们都从 Snyk 中受益，而不一定需要注册。这就是“将产品带给用户而不打断其工作流”的例子。我认为这绝对至关重要。

---

### [00:33:38] [Lenny]

**English:**
As an outsider hearing all this, it's a product that magically helps you avoid security issues, very little work, does a lot of the work for you. It's hard to imagine it not working looking at it now, and I'm curious what it was about the early days that just felt like maybe that people didn't believe in this working. Is it just there was doubt that it would be smart enough to find your security vulnerability issues? Was it the timing wasn't right, people weren't ready, weren't concerned about security enough? What do you think it was that created challenges early on? Because looking back, it's like, of course this is going to work. How could it not? It sounds just like a magical all win product.

**中文翻译:**
作为一个局外人听这些，这就像是一个能神奇地帮你避免安全问题的产品，几乎不需要什么工作，它为你做了大部分事。现在看来很难想象它会不成功。我很好奇早期是什么让人们觉得这可能行不通？是怀疑它不够聪明、找不到安全漏洞？还是时机不对，人们还没准备好，或者对安全不够关注？你认为早期产生挑战的原因是什么？因为回过头来看，这当然会成功，怎么可能不成功呢？听起来就像是一个神奇的双赢产品。

---

### [00:34:16] [Ben Williams]

**English:**
First of all, don't think the challenges were there in terms of the developer adoption. Even when those first kind of forays into self-serve were struggling in terms of breaking into some of the larger customers. The developer adoption, the free user base was still growing at a really good pace. That momentum was just constantly building and it's that momentum that has ultimately fueled the sales led business as we've gone through the years. But it was just those few things I think that I mentioned earlier in terms of stumbling blocks that needed to be overcome because when those first sales and marketing hires did join us and we started having conversations and we also tweaked some of the things in the product to meet, had some breadth, had some additional languages, ecosystems, building those table stakes features, then it really unlocked and it was rocket ship time from then.

**中文翻译:**
首先，我不认为在开发者采用方面存在挑战。即使在最初尝试进入大客户的自服务模式遇到困难时，开发者采用率和免费用户群仍在以非常好的速度增长。那种势头一直在不断积聚，正是这种势头最终推动了我们这些年来的销售主导业务。我认为只是我之前提到的那几个绊脚石需要克服。因为当第一批销售和营销人员加入，我们开始进行对话，同时我们也调整了产品的一些方面——增加了广度，支持了更多语言和生态系统，构建了那些基础功能——然后它就真正爆发了，从那时起就像坐上了火箭。

---

### [00:35:11] [Lenny]

**English:**
Got it. Sounds like the biggest issue is monetization. Can we make money doing this? Developers love it, they're using it like crazy, but will people be convinced to scale this an inside an organization and pay us a bunch of money for it?

**中文翻译:**
明白了。听起来最大的问题是变现。我们能靠这个赚钱吗？开发者喜欢它，用得发疯，但人们会被说服在组织内部大规模推广并为此支付一大笔钱吗？

---

### [00:35:21] [Ben Williams]

**English:**
Exactly, yep.

**中文翻译:**
没错，就是这样。

---

### [00:35:22] [Lenny]

**English:**
Okay, got it. I want to dive a little bit deeper into your growth team and product team and how you think about organizing teams like that in a product led growth sales org. The first question, just how did the growth team start at Snyk? What was kind of the early days and then what does it look like today?

**中文翻译:**
好的，明白了。我想深入探讨一下你们的增长团队和产品团队，以及在产品驱动增长（PLG）和销售结合的组织中，你是如何考虑组织这些团队的。第一个问题，Snyk 的增长团队是如何开始的？早期是什么样子的，现在又是什么样子？

---

### [00:35:41] [Ben Williams]

**English:**
There were some ad hoc efforts happening in various places. We had a small growth marketing function, we had [inaudible 00:35:49]. We also had some ownership of key growth services in R&D. There was a team that owned the new user onboarding flows, for example. But it wasn't until I joined that we really formalized the notion of a growth team. It was very kind of ad hoc before then. When I joined, we created what we call the developer growth group now. Before then there maybe wasn't strong an understanding about what a growth team needs to look like, how they might need to work differently to the core product teams. And I'd say overall it was much later than you'd typically expect to see. And at a bigger scale. You normally are going to start growth teams, one or two people, three or four maybe, and scale out from there. But we started much bigger than that. But at the same time, this bottom up developer first approach, it was baked into the company DNA in terms of how teams think and operate. Yeah, we were growing fast even before we spun up the growth group. I think the significant change that happened there, it was a transition from a simple freemium approach to a holistic and well-coordinated PLG strategy. It's much more common to start earlier, much more common to start at a smaller scale than we did at Snyk, but it worked for us because of this kind of perfect storm of where we had a product with that bottom up growth built in from the beginning. We had founders with a deep appreciation for how the product could grow and there was strongly exec alignment and sponsorship for scaling the motion. The problem when starting the growth group, it was really for the most part more oriented to how we can get the flywheel spinning faster as opposed to getting it moving in the first place.

**中文翻译:**
当时在不同地方有一些零散的尝试。我们有一个小的增长营销职能。在研发部门，我们也拥有一些关键增长服务的所有权，比如有一个团队负责新用户入职流程。但直到我加入，我们才真正正式确立了增长团队的概念。在那之前，它非常零散。我加入后，我们创建了现在所谓的“开发者增长小组”。在那之前，大家可能对增长团队应该是什么样子、他们与核心产品团队的工作方式有何不同缺乏深刻理解。我想说，总体而言，我们成立增长团队的时间比通常预期的要晚，而且规模更大。通常你会从一两个人、三四个人开始组建增长团队，然后逐步扩大。但我们开始时的规模比这大得多。与此同时，这种“自下而上、开发者优先”的方法已经植根于公司的 DNA 中，体现在团队的思考和运作方式上。是的，甚至在成立增长小组之前，我们就增长得很快。我认为那里发生的重大变化是从简单的免费增值模式转变为全面且协调良好的 PLG 战略。通常更常见的是更早开始、规模更小，但在 Snyk 奏效是因为一种“完美风暴”：我们拥有一款从一开始就内置了自下而上增长基因的产品，创始人对产品如何增长有深刻理解，而且高管层在扩展这一模式上达成了高度一致并给予了支持。成立增长小组时的问题，在很大程度上更多是关于如何让飞轮转得更快，而不是如何让它动起来。

---

### [00:37:26] [Lenny]

**English:**
Where did you initially focus that team? Which part of the flywheel?

**中文翻译:**
你最初让那个团队聚焦在哪里？飞轮的哪个部分？

---

### [00:37:30] [Ben Williams]

**English:**
Right now we have dedicated teams focused on acquisition, activation and monetization along with a supporting team who own our growth platform, including all of our data and experimentation stack. But the macro structure, it's changed over time to enable us to focus on the biggest constraints in our growth model. At the beginning we just focused on acquisition and activation, intentionally deferring any investment into specific monetization initiatives around the self-serve revenue channel until we felt confident that A, we'd built the necessary growth muscles to scale, and B, we'd figured out some of the more pressing issues that were present earlier in the user journey. It was important that we felt really confident about our ability to effectively connect developers to Snyk's value in such a way that introducing and optimizing a self-serve revenue channel would make sense. I also really wanted to avoid one of the common failure modes I've seen around cross-functional collaboration and growth.

**中文翻译:**
目前，我们有专门的团队负责获取（Acquisition）、激活（Activation）和变现（Monetization），还有一个支持团队负责我们的增长平台，包括所有数据和实验栈。但宏观结构随着时间的推移而改变，以便我们能够专注于增长模型中最大的瓶颈。开始时，我们只专注于获取和激活，有意识地推迟了对自服务营收渠道特定变现计划的投入，直到我们确信：第一，我们已经建立了扩展所需的增长肌肉；第二，我们已经解决了用户旅程早期存在的一些更紧迫的问题。重要的是，我们要对有效将开发者与 Snyk 的价值连接起来的能力充满信心，这样引入和优化自服务变现渠道才会有意义。我还非常想避免我在跨职能协作和增长中看到的一种常见失败模式。

---

### [00:38:28] [Ben Williams]

**English:**
When I joined, there was an inherent tension built into the system. It was particularly noticeable between R&D and the growth marketing team. We had amazing people in both teams, a ton of really great ideas, but many of them were just not being executed on and it was leading to a lot of friction, a lot of frustration, ultimately caused by misaligned incentives between the different functions. When creating the growth group, we resolved this by ensuring that each of the growth teams were truly cross-functional in nature with everyone in each team aligned around common objectives and KPIs. Every team has engineers, an engineering manager, a product manager, a designer, a growth marketer, decision science support, and a basic shape of the growth teams that'll be familiar to most, but I spoke to a bunch of people over the last couple of years and I've actually learned to my surprise that inclusion of growth marketers in the product teams is not all that common. And I personally think there's just a lot of opportunity being missed there and I expect that to start to become the norm rather than the exception over time.

**中文翻译:**
当我加入时，系统中存在一种固有的紧张关系。这种紧张在研发（R&D）和增长营销团队之间尤为明显。两个团队都有很棒的人才，有很多极好的点子，但其中很多都没有被执行，这导致了很多摩擦和挫败感，归根结底是由不同职能部门之间激励机制不一致造成的。在创建增长小组时，我们通过确保每个增长团队在本质上都是真正的跨职能团队来解决这个问题，每个团队中的每个人都围绕共同的目标和 KPI 达成一致。每个团队都有工程师、工程经理、产品经理、设计师、增长营销人员、决策科学支持。这种增长团队的基本形态对大多数人来说可能很熟悉，但过去几年我与很多人交流过，令我惊讶的是，在产品团队中包含增长营销人员其实并不常见。我个人认为这错失了很多机会，我预计随着时间的推移，这会开始成为常态而非特例。

---

### [00:39:32] [Lenny]

**English:**
Okay. I want to talk about that, but before we get there, you said there's a decision science person on the team. What is that about? That's cool.

**中文翻译:**
好的。我想聊聊那个，但在那之前，你说团队里有一个“决策科学”（Decision Science）人员。那是做什么的？听起来很酷。

---

### [00:39:38] [Ben Williams]

**English:**
That's right. We started off from a fundamental BI data analyst perspective, but over time we wanted to apply a much deeper level of analysis on the data such that we could start to build in predictive models that could help us make better decisions and can ultimately fuel and power some of the end product experiences. Yeah, we spun up a decision science function and those folks are very smart.

**中文翻译:**
没错。我们最初是从基础的 BI 数据分析师视角开始的，但随着时间的推移，我们希望对数据进行更深层次的分析，以便开始构建预测模型，帮助我们做出更好的决策，并最终为一些终端产品体验提供动力。是的，我们成立了一个决策科学职能部门，那些人非常聪明。

---

### [00:40:13] [Lenny]

**English:**
Is that similar to data science or is that a separate ... Okay. It's cool that you call them decision science people versus data science, because that's so much more actionable.

**中文翻译:**
那和数据科学类似吗，还是一个独立的……好的。你称他们为决策科学人员而不是数据科学人员，这很酷，因为这听起来更有行动导向。

---

### [00:40:23] [Ben Williams]

**English:**
Yeah, I think so.

**中文翻译:**
是的，我也这么认为。

---

### [00:40:24] [Lenny]

**English:**
Wow, that's cool. All right. I haven't heard that before. Makes me think of Annie Duke and all the stuff about how to make better decisions and I love ... Is this something anyone else does or is this something you came up with calling [inaudible 00:40:38]-

**中文翻译:**
哇，太酷了。好。我以前没听过这个说法。这让我想起 Annie Duke 以及关于如何做出更好决策的所有内容。我喜欢……这是别人也在做的，还是你发明的称呼？

---

### [00:40:37] [Ben Williams]

**English:**
I'm not sure. I don't necessarily think what we are doing is revolutionary there, but maybe the name, I'm not sure.

**中文翻译:**
我不确定。我不一定认为我们做的事情是革命性的，但也许这个名字是，我不确定。

---

### [00:40:46] [Lenny]

**English:**
Yeah, the name is cool. I haven't heard that before. It implies bias towards action versus just we're going to do a bunch of cool stuff with data. Interesting. Okay. Then you said that there's a growth marketer embedded in each team, so maybe just broadly what makes up these teams? Which you touched on briefly, then what have you learned is the value of having a growth marketer embedded within each team?

**中文翻译:**
是的，名字很酷。我以前没听过。它暗示了对行动的偏好，而不仅仅是“我们要用数据做一堆酷事”。有趣。好。然后你说每个团队都嵌入了一名增长营销人员，那么大致上这些团队是由什么构成的？你刚才简要提到了，那么你学到的在每个团队中嵌入增长营销人员的价值是什么？

---

### [00:41:06] [Ben Williams]

**English:**
It's important to have balanced teams with strong diversity across multiple vectors. Focusing on functional diversity at the moment, which is kind of what you're asking about with having growth marketers on the team, one of the big benefits you get is a broader pallet of ideas, but also a bigger toolbox when it comes to execution, which generally translates in an ability in a growth team for them to test and learn faster with more parallel, yet at the same time, aligned threats. Perhaps I can give a recent example there. Having a growth marketer in an acquisition focused team led us to some lightweight experimentation on the website in creating an SEO optimized page. It was something that was really high performing, both from the perspective of traffic and conversion, but it didn't require any engineering resources to create. The growth marketer and the team, and they decided together this was something worth pursuing.

**中文翻译:**
拥有在多个维度上具有强多样性的平衡团队非常重要。目前专注于职能多样性（也就是你问的在团队中加入增长营销人员），你获得的一大好处是更广阔的创意空间，以及在执行时拥有更大的工具箱。这通常转化为增长团队能够以更多并行且同时保持一致的路径，更快地进行测试和学习。也许我可以举一个最近的例子。在以获取为核心的团队中加入增长营销人员，促使我们在网站上进行了一些轻量级实验，创建了一个 SEO 优化页面。从流量和转化的角度来看，它的表现都非常好，而且创建它不需要任何工程资源。增长营销人员和团队共同决定这是值得尝试的。

---

### [00:42:01] [Ben Williams]

**English:**
But the growth marketer was able to kind of execute that independently while engineers were working on other things. But then based on the success of that, the team went on to build out a functional sidecar product that allowed users to basically try Snyk without needing to sign up by simply placing their code in for us to scan and giving them some results there and then. We saw really great results with that visitor traffic, saw a significant increase, sign up rate dropped a little bit as we'd expect it would, but overall new users had a big bump and those users had much higher intent, which we saw play out with increased activation rates.

**中文翻译:**
增长营销人员能够在工程师处理其他事情的同时独立执行。基于此项成功，团队随后开发了一个功能性的周边产品，允许用户在无需注册的情况下试用 Snyk——只需放入代码让我们扫描，即可当场获得结果。我们看到访客流量显著增加，效果非常好。虽然注册率如预期般略有下降，但总体新用户数量大幅提升，而且这些用户的意图更高，这体现在激活率的提高上。

---

### [00:42:37] [Lenny]

**English:**
Awesome. Okay. And so there's essentially four teams under the growth umbrella. There's acquisition, activation, monetization, and then this kind of experimentation platform team. Is that right?

**中文翻译:**
太棒了。好。所以增长伞下基本上有四个团队：获取、激活、变现，以及这种实验平台团队。对吗？

---

### [00:42:47] [Ben Williams]

**English:**
Yeah, that's right. And that team is also responsible for making that data available elsewhere in the organization as well. Product led sales is a really important motion for us, and so taking the knowledge we have, the insight we have around behavior with the users and their teams and their companies within the product, and making that available to the GTM teams outside in smart ways, allowing them to focus on the things that are most important to focus on. That's a really important part of what that team does.

**中文翻译:**
是的，没错。那个团队还负责将这些数据提供给组织的其他部门。产品驱动销售（PLS）对我们来说是一个非常重要的动作，因此，将我们在产品内部获得的关于用户、团队及其公司的行为知识和洞察，以智能的方式提供给外部的进入市场（GTM）团队，让他们能够专注于最重要的事情。这是该团队工作的一个非常重要的部分。

---

### [00:43:20] [Lenny]

**English:**
It's interesting, you guys are the epitome of product life sales. That's this new trend of from PLG to PLS for sales. It's obvious that they're a big part of this whole process. The fact that monetization happens almost all through sales is interesting. That's interesting. Cool. Okay. That's not a question, just a thought, talking out loud. One other thought I had is, so you talked about SEO being a really important part of your growth. What is the person team like to do the SEO piece, the right content? I imagine they're on the acquisition team, there's maybe a content person that lives within that team.

**中文翻译:**
很有趣，你们是产品驱动销售（PLS）的典范。这是从 PLG 到 PLS 的新趋势。显然，销售是整个过程的重要组成部分。变现几乎全部通过销售实现，这一点很有趣。酷。好。这不是问题，只是我大声说出来的想法。我的另一个想法是，你提到 SEO 是增长的重要组成部分。负责 SEO 部分、负责正确内容的团队是什么样的？我猜他们在获取团队中，也许团队里有一个内容人员。

---

### [00:43:55] [Ben Williams]

**English:**
We have actually one of, the smartest SEO people I've ever met within [inaudible 00:44:02].

**中文翻译:**
实际上，我们拥有我见过的最聪明的 SEO 专家之一。

---

### [00:44:02] [Lenny]

**English:**
What's their name? Let's give them a shout out if you want.

**中文翻译:**
叫什么名字？如果你愿意的话，可以公开表扬一下。

---

### [00:44:03] [Ben Williams]

**English:**
Anna. Yeah, cool.

**中文翻译:**
Anna。是的，很酷。

---

### [00:44:05] [Lenny]

**English:**
Joanna.

**中文翻译:**
Joanna。

---

### [00:44:05] [Ben Williams]

**English:**
Well, she's part of growth marketing, but she works extremely closely with the growth teams and she's got a few people in her organization and we bring them into specific SEO focused initiatives when we're looking to build loops around that. Incredibly important to have someone like that who understands that at a far deeper level than I could ever hope to, how SEO works. And particularly in terms of keeping on top of some of the things that Google are constantly doing in terms of their algorithm changes.

**中文翻译:**
她是增长营销团队的一员，但她与增长团队合作极其紧密。她的组织里有几个人，当我们想要围绕 SEO 建立循环时，我们会让他们参与特定的 SEO 计划。拥有这样的人非常重要，她对 SEO 运作方式的理解比我能期望的要深得多。特别是在紧跟 Google 不断进行的算法更新方面。

---

### [00:44:37] [Lenny]

**English:**
And does she actually do the writing for editorially, for I guess even the programmatically made pages or there's someone she outsources-

**中文翻译:**
她会亲自负责编辑写作吗？我是说，甚至是那些程序化生成的页面，还是她会外包给别人？

---

### [00:44:43] [Ben Williams]

**English:**
No, but what she does do a great job of is providing the kind of continuously updated guidelines on how content should be structured to lead us to good results.

**中文翻译:**
不，但她做得非常出色的一点是提供不断更新的指南，指导内容应该如何结构化，以引导我们获得好的结果。

---

### [00:44:55] [Lenny]

**English:**
Then it's just engineers and PMs that end up writing the things? Wow. Cool.

**中文翻译:**
所以最后是工程师和 PM 来写这些东西？哇，酷。

---

### [00:45:00] [Ben Williams]

**English:**
Yeah, that's exactly right.

**中文翻译:**
是的，完全正确。

---

### [00:45:04] [Lenny]

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold.

**中文翻译:**
本集节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。如果你的业务在云端存储任何数据，那么你很可能已经被问到或将被问到关于 SOC 2 合规性的问题。SOC 2 是证明你的公司采取了适当安全措施来保护客户数据的一种方式，它能建立客户和合作伙伴的信任，尤其是那些有严格安全要求的客户。此外，如果你想向企业销售产品，证明安全性是必不可少的。SOC 2 既可以为你打开更大、更好交易的大门，也可能让你的业务停滞不前。

---

### [00:45:39] [Lenny]

**English:**
If you don't have a SOC 2, there's a good chance you won't even get a seat at the table. Getting a SOC 2 report can be a huge burden, especially for startups. It's time consuming, tedious and expensive. Enter Vanta. Over 3000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months. Less than a-

**中文翻译:**
如果你没有 SOC 2，很有可能你连谈判桌都上不去。获取 SOC 2 报告可能是一个巨大的负担，尤其是对初创公司而言。它耗时、乏味且昂贵。这时 Vanta 就派上用场了。超过 3000 家快速增长的公司使用 Vanta 将 SOC 2 涉及的高达 90% 的工作自动化。Vanta 可以让你在几周内而不是几个月内准备好安全审计。不到……

---

### [00:46:03] [Lenny]

**English:**
Can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time. Lenny's podcast listeners, get $1,000 off Vanta. Just go to vanta.com/lenny, That's V-A-N-T-A.com/lenny to learn more and to claim your discount. Get started today. What advice do you have for folks building growth teams and maybe either similar space or just B2B, PLS oriented businesses in general? What have you learned about what is important to get right?

**中文翻译:**
可以在几周内而不是几个月内让你准备好安全审计，时间不到通常所需的三分之一。在有限的时间内，Lenny 播客的听众可以享受 Vanta 1,000 美元的优惠。只需访问 vanta.com/lenny，即 V-A-N-T-A.com/lenny 了解更多信息并领取折扣。今天就开始吧。对于那些正在组建增长团队的人，无论是在类似领域还是通用的 B2B、以 PLS 为导向的企业，你有什么建议？你学到了哪些必须做对的关键点？

---

### [00:46:34] [Ben Williams]

**English:**
This is a big topic. I have a lot of thoughts here based on what I've seen work well and also not so well. I think I can broadly bucket things here into maybe three main topics. So the first would be people and process. The second would be strategy, and the third would be data. Now they're all related and they all have to be working well to be effective in growth. Starting with people maybe touch the first element there in terms of balance teams, you've got to have those balance teams with diversity and ability to create great ideas, but also ability to execute. So that's the first thing.

**中文翻译:**
这是一个大话题。基于我看到的成功和失败的案例，我有很多想法。我认为大致可以将这些内容分为三个主要主题：第一是人员与流程，第二是战略，第三是数据。它们相互关联，必须全部运作良好才能在增长方面取得成效。从人员开始，也许先谈谈第一个要素，即平衡的团队。你必须拥有具备多样性、既能产生伟大创意又能执行的平衡团队。这是第一点。

---

### [00:47:14] [Ben Williams]

**English:**
But still on the topic of people, I have this kind of mental model, that potential that at its core is unbounded, but that a bunch of things situationally prevent people from fulfilling their potential. It might be how they're thinking about something. It might be organizational. It might be in relationships with coworkers or in broader team dynamics. It might be in them not even being in the right role even.

**中文翻译:**
关于人员，我有一个心理模型：人的潜力核心是无限的，但很多情境因素会阻碍人们发挥潜力。这可能是他们的思维方式，可能是组织层面的，可能是与同事的关系或更广泛的团队动态，甚至可能是他们根本没在合适的岗位上。

---

### [00:47:37] [Ben Williams]

**English:**
So fundamentally I think it's the role of managers and leaders to help them identify those things and work with them to find ways to thrive and grow. And I've seen this have particular significance in a growth org where people are just naturally less good fit. Now that doesn't mean that they're not amazing talented humans. It just means they aren't going to do their best work in a growth context.

**中文翻译:**
所以从根本上说，我认为经理和领导者的职责是帮助他们识别这些障碍，并与他们一起寻找茁壮成长的方法。我发现这在增长组织中尤为重要，因为有些人天生就不太适合增长岗位。这并不意味着他们不是才华横溢的人，只是意味着他们在增长的环境下无法发挥出最佳水平。

---

### [00:47:59] [Ben Williams]

**English:**
So when you're starting a growth team, you'll often be doing so with internal moves. So this can be something that's maybe a little bit easier to miss than with external candidates where you are likely testing for those things explicitly during the hiring process. I'll share an example with developers.

**中文翻译:**
当你开始组建增长团队时，通常会通过内部调动来进行。这可能比外部招聘更容易被忽视，因为在外部招聘中，你可能会在面试过程中明确测试这些特质。我以开发者为例。

---

### [00:48:17] [Ben Williams]

**English:**
So the devs that really thrive in a growth context are the ones that are motivated by moving quickly, iterating to create measurable impact. They're not attached to their work. They embrace imperfection as part of the process. They happily discard their code, their ideas even. They're curious and they're always looking for ways to be closer to their users.

**中文翻译:**
在增长环境中真正茁壮成长的开发者，是那些被“快速行动、通过迭代创造可衡量影响”所激励的人。他们不执着于自己的作品，接受不完美作为过程的一部分。他们乐于丢弃自己的代码，甚至是自己的想法。他们充满好奇心，总是在寻找更接近用户的方法。

---

### [00:48:38] [Ben Williams]

**English:**
Now those are the folks that generally make great growth engineers and I've also known incredible engineers that are most motivated when they're working on really deep technical challenges and love the process as much as the outcome. And they've struggled in growth. Of course it's never that simple in reality. There's nobody who's really at either extremity of that spectrum. But it's really important to try to answer the question, can this person do their best work in this environment? So I think that's a really key part of it.

**中文翻译:**
这些人通常能成为优秀的增长工程师。我也认识一些非常出色的工程师，他们最受激励的时候是处理深奥的技术挑战，并且热爱过程胜过结果。他们在增长团队中往往会感到挣扎。当然，现实中没那么简单，没有人真正处于光谱的极端。但试图回答“这个人能否在这个环境中发挥出最佳水平”这个问题非常重要。我认为这是关键部分。

---

### [00:49:10] [Ben Williams]

**English:**
And yeah, you need to also make sure they're well equipped from a kind of skills and knowledge perspective as well. So they need the right skills and knowledge to be able to do their best work in the context of your growth process. The ideal state is that every growth team member has common vocabulary. They're comfortable with the growth process. They can work well with data and experimentation platform. They understand the data. They have the right skills and mindset.

**中文翻译:**
是的，你还需要确保他们在技能和知识方面也装备精良。他们需要合适的技能和知识，才能在增长流程的背景下发挥最佳水平。理想状态是每个增长团队成员都有共同的语言，熟悉增长流程，能熟练使用数据和实验平台，理解数据，并具备正确的技能和心态。

---

### [00:49:36] [Ben Williams]

**English:**
Education I think plays a big part here. So we're big fans of Reforge, but we've also developed a bunch of internal programs to align and uplevel the teams. Something we learned, I think as an example, is the importance of starting simple and going deeper as the teams build experience. So for example, when it comes to experimentation, don't try at the beginning to introduce multivariate testing or concepts like sequential samplings and alternative evaluation approach.

**中文翻译:**
我认为教育在这里起到了很大作用。我们是 Reforge 的忠实粉丝，但我们也开发了一系列内部计划来对齐和提升团队水平。例如，我们学到的一点是：随着团队经验的积累，从简单开始并逐步深入非常重要。比如在实验方面，不要一开始就尝试引入多变量测试或序贯抽样（sequential sampling）等复杂的评估方法。

---

### [00:50:04] [Ben Williams]

**English:**
Teams are still trying to just dip their toes in that... This water, it's kind of a recipe for a lot of mistakes. So that would be some advice there.

**中文翻译:**
团队还在尝试涉足这个领域……这种做法很容易导致很多错误。所以这是我的一点建议。

---

### [00:50:15] [Ben Williams]

**English:**
But people also need to be well aligned. I've talked about this actually on another podcast that I did recently. But what I mean by that is their execution needs to be aligned with an evolving growth strategy. The growth strategy needs to be aligned with and at the same time influence where the company's going. The growth strategy needs hooks into the product strategy and ideally there's some overlap and alignment of KPIs so that the growth teams and the core product teams are swimming in the same direction. The skills and experience in the team need to be aligned with the strategy. If you've got to focus on activation and acquisition, then someone who's a plans and pricing expert probably isn't the right set of skills at that point in time.

**中文翻译:**
但人员也需要高度对齐。我最近在另一个播客中也聊过这个。我的意思是，他们的执行需要与不断演进的增长战略保持一致。增长战略需要与公司的发展方向对齐，同时也要影响公司的方向。增长战略需要与产品战略挂钩，理想情况下，KPI 应该有重叠和对齐，这样增长团队和核心产品团队就能朝着同一个方向努力。团队的技能和经验也需要与战略对齐。如果你目前的重点是激活和获取，那么一个定价专家在那个时间点可能并不是最合适的技能人选。

---

### [00:50:57] [Ben Williams]

**English:**
But you also, leaders need to plan to ensure those skills are available as focus of the growth team inevitably shifts over time. But at the end of the day, everyone needs to be able to easily answer the question why they're there. Why the work they're doing is important.

**中文翻译:**
作为领导者，你还需要制定计划，确保随着增长团队重心的转移，相应的技能能够及时到位。但归根结底，每个人都应该能轻松回答“为什么我在这里”以及“为什么我做的工作很重要”。

---

### [00:51:14] [Ben Williams]

**English:**
I don't know if it's too far off track here, but I have a vision and mission framework that I like to use that leads to I think, great simple statements of an imagined better future state and your role in getting there. So I can talk about that a little bit if it's a-

**中文翻译:**
我不知道这是否扯远了，但我有一个我喜欢的愿景和使命框架，我认为它可以引导出关于想象中的美好未来状态以及你在实现这一状态中角色的简洁陈述。如果可以的话，我可以聊聊这个——

---

### [00:51:28] [Lenny]

**English:**
Yeah, let's do it. That sounds too good to pass up.

**中文翻译:**
好啊，开始吧。听起来太棒了，不能错过。

---

### [00:51:31] [Ben Williams]

**English:**
-Cool. So the vision is the nirvana state that you aim to enable for your users and customers in five to 10 years. It's something that could equally be enabled by your competitors if you don't execute effectively or efficiently or quickly enough. You can always prefix a vision statement with in the future, dot, dot dot.

**中文翻译:**
太好了。愿景（Vision）是你希望在 5 到 10 年内为用户和客户实现的“涅槃状态”（理想终态）。如果你执行得不够有效、不够高效或不够快，你的竞争对手也同样可以实现它。你总是可以用“在未来……”作为愿景陈述的前缀。

---

### [00:51:52] [Ben Williams]

**English:**
Now it's something that should be bound to your target market. So not too wide and not too narrow. And critically it should not mention your company, your product, or anything solution related at all. Completely agnostic of those things.

**中文翻译:**
它应该与你的目标市场绑定，既不能太宽也不能太窄。关键是，它根本不应该提到你的公司、你的产品或任何与解决方案相关的东西。它应该与这些东西完全无关。

---

### [00:52:05] [Ben Williams]

**English:**
And then the mission, that's the thing that you are going to relentlessly iterate on to take you incrementally closer to the nirvana state described in the vision. It should answer how you'll realize the vision by describing what your fundamental approach will be. In other words, what you will do and how you'll do it. It should ideally aim to encode any unique differentiating advantage you have. So if I think about Snyk at large when it comes to advantage, we might mention our unequal security intelligence and knowledge of application context.

**中文翻译:**
然后是使命（Mission），这是你将不懈迭代的东西，让你逐步接近愿景中描述的理想状态。它应该通过描述你的基本方法来回答你将如何实现愿景。换句话说，就是你将做什么以及你将如何做。理想情况下，它应该旨在体现你拥有的任何独特差异化优势。所以如果我想到 Snyk 的整体优势，我们可能会提到我们无与伦比的安全情报和对应用上下文的了解。

---

### [00:52:36] [Ben Williams]

**English:**
And one of the neat things about this framework is if you find utility in doing so, you can apply it at every level from the company level all the way down to individual team. It doesn't mean the process is not difficult and you need to spend a lot of time, but it gives you this set of kind of a framework, a set of bounds that help you really come out with world crafted statements that kind of stand the test of time.

**中文翻译:**
这个框架的一个巧妙之处在于，如果你觉得有用，你可以将其应用到每一个层级，从公司层面一直到个人团队。这并不意味着过程不难，你确实需要花很多时间，但它为你提供了一套框架和界限，帮助你打磨出能够经受时间考验的精彩陈述。

---

### [00:53:00] [Lenny]

**English:**
Is there an example you could share of the mission vision, whether it's Snyk or something else?

**中文翻译:**
你能分享一个愿景使命的例子吗？无论是 Snyk 的还是其他的。

---

### [00:53:03] [Ben Williams]

**English:**
Yeah, yeah. I'll give you one for the growth group of Snyk. So great. The vision, every developer securely unleashes their creativity and the mission is to connect every developer and their organizations to the value of the Snyk platform with frictionless self-serve, adoption and expansion.

**中文翻译:**
好，好。我给你一个 Snyk 增长小组的例子。愿景是：让每一位开发者都能安全地释放他们的创造力。使命是：通过无摩擦的自服务、采用和扩展，将每一位开发者及其组织与 Snyk 平台的价值连接起来。

---

### [00:53:19] [Lenny]

**English:**
Interesting how the vision is so big beyond Snyk's current focus. And to your point, this kind of trickle down, right? There's a company vision and mission and it's the growth team's mission vision.

**中文翻译:**
很有趣，愿景如此宏大，超出了 Snyk 目前的重点。正如你所说，这是一种向下渗透，对吧？有公司的愿景使命，也有增长团队的愿景使命。

---

### [00:53:32] [Ben Williams]

**English:**
Yep.

**中文翻译:**
是的。

---

### [00:53:32] [Ben Williams]

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:53:34] [Lenny]

**English:**
I want to shift a bit and talk about your product work. So we've talked a lot about the growth org. I'm curious what the broader product org looks like. How many teams do you have? How do you structure it? Is it like product focused, user focused, outcome focused? And then just how does that team work with the growth team?

**中文翻译:**
我想转个话题，聊聊你的产品工作。我们已经聊了很多关于增长组织的内容。我很好奇更广泛的产品组织是什么样的。你们有多少个团队？如何构建它？是产品导向、用户导向还是结果导向？以及该团队如何与增长团队协作？

---

### [00:53:53] [Ben Williams]

**English:**
Sure. Happy to go into a bunch of that stuff. I know I'd mentioned earlier kind of three areas of building a growth team. I don't know if you want me to cover those other two. 'Cause we talked about-

**中文翻译:**
当然。我很乐意深入探讨。我知道我之前提到了组建增长团队的三个领域。我不知道你是否想让我涵盖另外两个？因为我们刚才只聊了——

---

### [00:54:02] [Lenny]

**English:**
Oh yeah, okay, let's do that. Let's finish that thread.

**中文翻译:**
噢对，好，我们继续。先把那个话题聊完。

---

### [00:54:05] [Ben Williams]

**English:**
-Cool. So people and process was the first and we'll cover process really quickly. I think on the process side, at a minimum here you need well understood, documented growth processes, practices, working cadences. Teams in growth need to work differently in some ways from R and D teams working on core product, assuming otherwise, and just giving growth responsibility to an existing team without working with them to implement appropriate ways of working. I think it's a common track.

**中文翻译:**
太好了。人员与流程是第一个，我们快速过一下流程。我认为在流程方面，你至少需要被充分理解并记录在案的增长流程、实践和工作节奏。增长团队在某些方面的工作方式需要与开发核心产品的研发团队不同。如果假设两者一样，只是把增长职责交给现有团队而不协助他们实施合适的工作方式，我认为这是一个常见的陷阱。

---

### [00:54:31] [Ben Williams]

**English:**
Ideally you get to a point there where the growth process is something that's continually refined and iterated on trying to build in more predictability. But what I've found I think most singularly most important in a growth process is facilitating a rapid learning cadence and providing the means to socialize those learnings, surfacing them in the right place at the right time so they can be leveraged and at the context. And if you think about experimentation, it's not about delivering outcomes it's about generating learnings that the organization can leverage effectively to deliver outcomes.

**中文翻译:**
理想情况下，增长流程应该是不断完善和迭代的，以试图建立更多的可预测性。但我发现，在增长流程中，最最重要的一点是促进快速的学习节奏，并提供社交化这些学习成果的手段，在正确的时间和地点将它们呈现出来，以便在特定背景下被利用。如果你思考实验，它的目的不是交付结果，而是产生组织可以有效利用以交付结果的学习成果。

---

### [00:55:05] [Ben Williams]

**English:**
Might not be now, might not be tomorrow or some point in the future. But the sad reality is that without good process learnings easily end up unused and gathering dust. And you have to ask then what was the point? So as people in process and you know when that's on the right track, when you start to see enthusiastic sharing of learnings, when you see regular contribution of ideas coming from everyone in the form of well crafted hypotheses that are based on data and learnings. And when you see a wide variety of folks, just assuming end to end ownership of managing and running experiments instead of delegating that to the product manager or an engineer and tech lead. So yeah, that's people in process and strategy is-

**中文翻译:**
可能不是现在，也不是明天，而是未来的某个时刻。但悲哀的现实是，如果没有良好的流程，学习成果很容易被束之高阁、落满灰尘。那你不得不问，意义何在？所以，关于人员与流程，当你开始看到大家热烈地分享学习成果，看到每个人都以基于数据和学习的精心设计的假设形式定期贡献想法时，你就知道它走上了正轨。当你看到各种各样的人开始承担管理和运行实验的端到端所有权，而不是将其委托给产品经理或工程师及技术负责人时，你就知道成功了。所以，这就是人员与流程，而战略是——

---

### [00:55:48] [Lenny]

**English:**
Let me throw in a question real quick before we get to the last piece.

**中文翻译:**
在聊最后一部分之前，让我快速插一个问题。

---

### [00:55:50] [Ben Williams]

**English:**
Sure.

**中文翻译:**
当然可以。

---

### [00:55:51] [Lenny]

**English:**
So learnings, just to kind of touch on that. I've heard more and more pushback on the idea of learnings being an outcome. Because a lot of... As a leader, you're not going to be like, Cool, we learned so many things but nothing really got done. How do you think about the tension between, yeah, learnings we want to learn, but we also want to move metrics, grow the business and learnings are a way to inform decisions more than even just learn. How do you think about that kind of balance?

**中文翻译:**
关于“学习成果”，我想聊一下。我听到越来越多的人反对将“学习”作为一种产出。因为作为领导者，你不会说：“太酷了，我们学到了这么多东西，但实际上什么都没做成。”你如何看待这种张力：我们确实想学习，但我们也想提升指标、增长业务，而学习更多是为决策提供信息，而不仅仅是学习本身。你如何看待这种平衡？

---

### [00:56:17] [Ben Williams]

**English:**
Ultimately you're there to create impact, right? There's no getting away from that, but learnings is the means. It's the same as, there's a quote that I love from [inaudible 00:56:27] around focus on the user's path to value not on monetization. Because if you focus on the form of the latter will follow, and that's the same thing with learnings and impact here. If you try and focus on the impact itself might struggle. If you focus on the things you need in terms of learnings to take you step by step, that will pave the path to creating impact.

**中文翻译:**
归根结底，你是在那里创造影响力的，对吧？这是无法回避的，但学习是手段。这就像我喜欢的一句话：关注用户的价值路径，而不是变现。因为如果你关注前者，后者自然会随之而来。学习和影响力的关系也是如此。如果你只关注影响力本身，可能会很挣扎。如果你关注为了步步为营所需学习的东西，那将为创造影响力铺平道路。

---

### [00:56:47] [Lenny]

**English:**
I imagine your OKRs and goals are still like move this metrics some percentage, but you think of that as an output and the input is let's learn a bunch of stuff about what works and doesn't work and use that to inform what we're going to double down on.

**中文翻译:**
我猜你的 OKR 和目标仍然是“将此指标提升百分之几”，但你将其视为产出，而投入是“让我们学习一堆关于什么有效、什么无效的东西”，并以此来决定我们要加倍投入什么。

---

### [00:57:00] [Ben Williams]

**English:**
Exactly. Yeah.

**中文翻译:**
没错，是的。

---

### [00:57:00] [Ben Williams]

**English:**
You got to focus on when you build a strategic opportunity, you are thinking about the outcomes, but you don't just go right to the end state. You've got to think about what's the quickest way we can test this hypothesis? And from there, what we learn from that and what do we take into the next set of the next set of experiments and it... You're paving this path along the way. You kind of that rough destination. How you get there, you don't know at the start. And that's what the path that the learnings take you on.

**中文翻译:**
你必须专注于：当你构建一个战略机会时，你在考虑结果，但你不会直接跳到最终状态。你必须思考：我们测试这个假设最快的方法是什么？然后，我们从中能学到什么，以及我们要把什么带入下一组实验？你是在沿途铺路。你有一个大致的目的地，但开始时你不知道如何到达那里。这就是学习带你走的路径。

---

### [00:57:31] [Lenny]

**English:**
Cool. Okay. And then strategy we're talking about.

**中文翻译:**
酷。好。然后我们要聊的是战略。

---

### [00:57:34] [Ben Williams]

**English:**
Strategy. Yeah, so strategy, it's a good one. At a very basic level, you need to be able to answer questions. How do you acquire users? How do you retain users? How do you monetize them? I know you talked with Elena on that in more depth, but from there you need more detail. It's going to guide the growth teams and where they look for strategic opportunity, how they approach that. The best way I've found to articulate a growth strategy that fulfills the promise of usefully guiding the team's execution, it's the loop based model, Reforge, as specific kind of documentation that I think is great around that.

**中文翻译:**
战略。是的，战略是个好话题。在最基础的层面，你需要能够回答：你如何获取用户？你如何留存用户？你如何变现？我知道你和 Elena 深入探讨过这个，但除此之外你需要更多细节。它将指导增长团队去哪里寻找战略机会，以及如何应对。我发现阐述增长战略并能有效指导团队执行的最佳方式是“基于循环的模型”（loop based model），Reforge 有专门的文档，我觉得非常棒。

---

### [00:58:15] [Ben Williams]

**English:**
Being able to identify the various micro and macro loops, how they're all connected, being able to document them in a qualitative model to communicate a shared understanding of how you grow. It's really powerful. Augmenting that then with the quantitative side of things, that helps guide quarter to quarter focus and ensure you can be intentional about where you're investing. That becomes a big enabler.

**中文翻译:**
能够识别各种微观和宏观循环，了解它们如何连接，并能将它们记录在定性模型中以传达关于如何增长的共识，这非常强大。然后用定量分析来增强它，这有助于指导每个季度的重点，并确保你在投资方向上是有意为之的。这会成为一个巨大的助力。

---

### [00:58:40] [Ben Williams]

**English:**
You're never going to have a shortage of ideas in a high performing growth team. So knowing where to focus amidst that kind of sea of ideas is a really important role of the strategy and fairly on, you'll probably have one or two core loops, but inevitably you'll need to layer on and connect new ones over time. And having a framework for doing that and having a framework for regularly revisiting that in the context of growth, team learnings, changes in broader company strategy, evolution of the product, new features being added, and so on. Market shifts, that becomes a big up level for teams to be able to create timely impact.

**中文翻译:**
在一个高效的增长团队中，你永远不会缺乏创意。因此，在创意的海洋中明确聚焦于何处，是战略的一个非常重要的作用。在早期，你可能只有一两个核心循环，但随着时间的推移，你不可避免地需要叠加并连接新的循环。拥有一个执行此操作的框架，并拥有一个在增长背景下定期回顾该框架的框架（结合团队学习、公司战略变化、产品演进、新功能添加、市场转变等），将大大提升团队创造及时影响力的能力。

---

### [00:59:19] [Ben Williams]

**English:**
So the model you create there is what enables you to know at any time where the biggest constraints to your growth are and allows you to balance your growth investments accordingly. It's neat for sure. We've had times where we've focused on a broad set of constraints and opportunities and other times where we've had a much narrower focus. For example, on driving improvement to activation and engagement, even more narrowed like doing that through empty states, for example.

**中文翻译:**
因此，你创建的模型能让你随时了解增长中最大的瓶颈在哪里，并允许你相应地平衡增长投资。这确实很巧妙。我们有时会关注一系列广泛的约束和机会，有时则会非常聚焦。例如，专注于提升激活和参与度，甚至更具体到通过优化“空白状态”（empty states）来实现。

---

### [00:59:44] [Lenny]

**English:**
I want to unpack the strategy piece real quick. How do you operationalize this idea of you have this growth model, growth loop, you figured out here's the ways we're growing. How do you tactically connect that to a strategy? Is it, here's how we're growing, here's where we're going to focus this quarter, optimize this part of the loop, or is there some other way? You write it down, basically.

**中文翻译:**
我想快速拆解一下战略部分。你如何将“拥有增长模型、增长循环、找出增长方式”这一想法付诸实践？你如何在战术上将其与战略联系起来？是说“这就是我们的增长方式，这是我们本季度的重点，优化循环的这一部分”，还是有其他方式？基本上就是把它写下来吗？

---

### [01:00:05] [Ben Williams]

**English:**
Very simply, it's first of all alignment on how you grow the different loops, how they work, the roles of different teams and the roles that they play in fueling those loops and getting them to spin faster. I think that's the first thing, having that common vocabulary and understanding.

**中文翻译:**
非常简单，首先是就如何增长达成一致：不同的循环、它们如何运作、不同团队的角色以及他们在推动这些循环转得更快方面所扮演的角色。我认为这是第一步，拥有共同的语言和理解。

---

### [01:00:25] [Ben Williams]

**English:**
Second is understanding the way they work in terms of what is constraining them, what are the inputs to them? What are the opportunities for making those loops spin faster? How can multiple loops work together in a macro context?

**中文翻译:**
第二是理解它们的运作方式：什么是它们的约束？它们的输入是什么？让这些循环转得更快的机会在哪里？多个循环如何在宏观背景下协同工作？

---

### [01:00:41] [Ben Williams]

**English:**
And particularly using the data there to be able to identify and understand and get alignment around where are the biggest constraints in your growth model overall and therefore where are the things that we need to focus on as a team over the next quarter or two quarters, and so on.

**中文翻译:**
特别是利用数据来识别、理解并就整个增长模型中最大的瓶颈达成共识，从而确定我们作为一个团队在接下来的一个或两个季度需要关注的事情。

---

### [01:01:01] [Ben Williams]

**English:**
And that it's constantly changing. As I mentioned, there's a bunch of stuff that needs to feed back into that model in terms of growth loop performance or the learnings you're making and so on. That means it's changing and you're constantly reevaluating and it's guiding kind of quarter to quarter planning.

**中文翻译:**
而且它是不断变化的。正如我提到的，有很多东西需要反馈到那个模型中，比如增长循环的表现、你获得的新认知等等。这意味着它在变，你需要不断重新评估，它指导着每个季度的计划。

---

### [01:01:19] [Lenny]

**English:**
Cool. So just to make it even more concrete for folks that are listening. So one of your loops is this integration with GitHub where you automatically fix their code and create a PR. You may find at some point somebody clicking that link to becoming a user is too high friction, too many people are falling out. So one strategy for one of say the activation team could be we're going to optimize this part of the funnel. So when clicking from GitHub to sign up as a user and get them to a point where they found value, right?

**中文翻译:**
酷。为了让听众更具体地理解：你们的循环之一是与 GitHub 的集成，自动修复代码并创建 PR。你可能会在某个时刻发现，某人点击链接成为用户的摩擦力太大，很多人流失了。所以，比如激活团队的一个战略可能是：我们要优化漏斗的这一部分，即从 GitHub 点击到注册为用户，并引导他们达到发现价值的那个点，对吗？

---

### [01:01:48] [Ben Williams]

**English:**
Yep. That exactly that sort of thing. Or earlier on, for example, it might have been with that taken that same example of that same loop, and this is sufficiently far in the past that it's easy for me to talk about. But we start with GitHub. We want to now expand the scope of that loop. We've seen success with it. We see the performance of that loop growing, but we think there's opportunity in saying let's expand that by adding support for Bitbucket. And now all of a sudden we spin up that same loop with Bitbucket and then GitLab and so on.

**中文翻译:**
是的，完全是这类事情。或者更早的时候，以同一个循环为例（这已经是很久以前的事了，所以我可以轻松谈论）：我们从 GitHub 开始，现在想扩大该循环的范围。我们看到了成功，看到该循环的表现正在增长，但我们认为有机会通过增加对 Bitbucket 的支持来扩展它。然后突然之间，我们在 Bitbucket 上启动了同样的循环，接着是 GitLab 等等。

---

### [01:02:20] [Lenny]

**English:**
Awesome. Okay. We could go a whole hour on just that piece, so we'll move on and we'll save that for feed two.

**中文翻译:**
太棒了。好。光是这一部分我们就能聊一个小时，所以我们继续，把那个留到第二部分。

---

### [01:02:26] [Ben Williams]

**English:**
Data was the last thing. And growth team just can't function without data that even with early stage products, before you have the needed volume of traffic to be able to run formal tests in reasonable timeframes, you still need to have signals that help you learn and inform your decisions, both quantum and of course qu through speaking with users. My advice there is really just to invest early the infrastructure, the tooling then at a given scale, the dedicated people as well. They're going to be core to building out the growth team and they'll enable data to ultimately pretty much inform all critical decisions.

**中文翻译:**
最后一点是数据。增长团队没有数据就无法运作。即使是早期产品，在拥有足够流量以在合理时间内运行正式测试之前，你仍然需要信号来帮助你学习并为决策提供信息，包括定量数据，当然还有通过与用户交谈获得的定性信息。我的建议是尽早投资基础设施和工具，然后在达到一定规模后，也投入专门的人员。他们将是构建增长团队的核心，并将使数据最终能够为几乎所有关键决策提供信息。

---

### [01:03:01] [Ben Williams]

**English:**
So Snyk was interesting that we didn't have a problem of not having enough data. In fact, there was an abundance of data, like too much. We collected absolutely everything. And the problem I identified very early was that we didn't have enough behavioral specific data and we weren't intentional enough about the data that we were collecting and how we were collecting it, which made the data hard to trust and that becomes a big problem.

**中文翻译:**
Snyk 的有趣之处在于我们没有“数据不足”的问题。事实上，数据非常丰富，甚至太多了。我们收集了绝对所有的数据。但我很早就发现的问题是，我们没有足够的特定行为数据，而且我们对收集什么数据以及如何收集数据不够有意识，这导致数据难以信任，成了一个大问题。

---

### [01:03:26] [Ben Williams]

**English:**
So we invested in tooling and processes for building out event tracking plans, and now we test conformance to schema of the instrumented code in our CI processes. So we have absolute confidence in the data. So that was getting to a point of trustworthy behavioral data was absolutely key.

**中文翻译:**
因此，我们投资了用于构建事件跟踪计划的工具和流程，现在我们在 CI 流程中测试埋点代码对 Schema 的符合性。所以我们对数据有绝对的信心。达到“可信的行为数据”这一点绝对是关键。

---

### [01:03:43] [Ben Williams]

**English:**
But the reason I say invest early here is that to remember that it also takes time to accrue enough data that you can learn about and make some key decisions around retention, for example. Also that you have enough data to run regressions on, be able to inform definition of your activation metrics or engagement states and so on. So the earlier you can start collecting the better. So yeah, people in process a strategy and data and you absolutely need all of those things to build and run an affected growth team.

**中文翻译:**
但我之所以说要尽早投资，是因为要记住，积累足够的数据也需要时间，这样你才能学习并就留存等方面做出关键决策。此外，你还需要足够的数据来运行回归分析，从而为激活指标或参与状态的定义提供信息。所以越早开始收集越好。所以，人员与流程、战略和数据，构建和运行一个有效的增长团队绝对需要所有这些。

---

### [01:04:14] [Ben Williams]

**English:**
When you get all of those things working, it's like rocket fuel for focus creativity, but at the same time slowing down to put the maturity in place as on all scales at the pace Snyk has it's pretty much impossible. You still have to get stuff done while you're kind of building all that stuff out. You have to accept that you're going to make a bunch of mistakes along the way. You have to be a hundred percent comfortable with that. And you have to treat those mistakes as learning opportunities that provide leaves for improvement.

**中文翻译:**
当你让所有这些都运转起来时，它就像是专注创造力的火箭燃料。但与此同时，像 Snyk 这样规模和速度的公司，想要慢下来去完善成熟度几乎是不可能的。你必须在构建这些东西的同时把事情办成。你必须接受沿途会犯很多错误，必须百分之百地接受这一点。你必须将这些错误视为提供改进契机的学习机会。

---

### [01:04:43] [Ben Williams]

**English:**
And it's also useful to... You know, asked about KPIs and what the team are responsible for it. And that is one way in which a growth team absolutely needs to make impact and it's the way that primarily they're going to be held accountable. But it's also I think, useful to think about the efficacy of the growth org, not just in terms of the impact they drive our experiments and new product experiences and on core growth pick KPIs, but also how they enable and uplevel the rest of the org.

**中文翻译:**
而且，考虑增长组织的效能也很有用。你问过 KPI 和团队负责什么，这是增长团队绝对需要产生影响的一种方式，也是他们被考核的主要方式。但我认为，不仅要看他们通过实验和新产品体验对核心增长 KPI 产生的影响，还要看他们如何赋能和提升组织的其余部分。

---

### [01:05:10] [Ben Williams]

**English:**
So for example, our entire product led sales process, it's powered by an evolving model that describes our understanding of users, teams, accounts, the usage and adoption patterns and signals, the best in form where and how our GTM teams focused. Insights from growth teams often have utility far beyond growth, but people can't know if something is useful to them if you haven't shared it with them. So the learnings made in the growth teams, even those from mistakes or failures, we socialize them widely and visibly.

**中文翻译:**
例如，我们的整个产品驱动销售流程是由一个不断演进的模型驱动的，该模型描述了我们对用户、团队、账户、使用和采用模式及信号的理解，从而最好地告知我们的 GTM 团队应该关注哪里以及如何关注。增长团队的洞察往往具有远超增长本身的效用，但如果你不分享，人们就无法知道某些东西对他们是否有用。因此，增长团队获得的认知，即使是来自错误或失败的认知，我们也会广泛且公开地进行社交化分享。

---

### [01:05:41] [Ben Williams]

**English:**
We want every R and D team to be leveraging experimentation where appropriate to learn to create business impact. So one of the things we did here is creating a paved row for adoption of behavioral analytics and experimentation stack, coach teams on getting started to make it as easy as possible for anyone to start to reap the benefits of the platform, built out internal education programs on data driven development, on experimentation, built internal tools to help with metrics design and so on.

**中文翻译:**
我们希望每个研发团队都能在适当的时候利用实验来学习如何创造业务影响。所以我们做的一件事是为采用行为分析和实验栈铺平道路，辅导团队入门，让任何人都能尽可能轻松地开始从平台中获益。我们还建立了关于数据驱动开发和实验的内部教育计划，构建了帮助指标设计的内部工具等等。

---

### [01:06:08] [Ben Williams]

**English:**
And then building core platform services as well that are useful for people outside of growth. So we built services that power contextual onboarding, and originally that was the intent, but now those same services can be used anywhere in the product to give contextual experiences. I know that was a bit of a ramble, but hopefully there's one or two useful things in there.

**中文翻译:**
此外，我们还构建了对增长部门以外的人也有用的核心平台服务。比如我们构建了驱动“上下文感知入职”（contextual onboarding）的服务，最初是这个目的，但现在这些服务可以用于产品中的任何地方，以提供上下文相关的体验。我知道我扯得有点远，但希望其中有一两点是有用的。

---

### [01:06:29] [Lenny]

**English:**
Yeah, there's two things I wanted to quickly follow up and then we can talk about the product team. You said you socialize learnings and experiment results. Is there anything you could share there about tips to do that? You have a tool you do use that for? Is there someone posts stuff in Slack? Is it an email that goes out? How do you actually socialize learning such that say a salesperson can do something with it?

**中文翻译:**
是的，有两件事我想快速跟进一下，然后我们可以聊聊产品团队。你说你会社交化分享学习成果和实验结果。关于如何做到这一点，你有什么技巧可以分享吗？你用什么工具吗？是有人在 Slack 里发帖？还是发邮件？你究竟如何社交化这些认知，以便让销售人员也能利用它们？

---

### [01:06:50] [Ben Williams]

**English:**
Yes. So there's, first of all, there's a bunch of Slack channels like Synk runs on Slack basically. So there's a bunch of Slack channels. Even when we're planning experiments, those are kind of wide and in the open and we invite collaboration on those. But from a ceremony perspective, we try hard to institutionalize ways to generate and leverage learnings. It's something I feel pretty strongly about. So we have these team level impact and learnings reviews loosely modeled from a blog years back down, I don't know... Six years I want to say that Brian Balfour wrote about a similar ceremony from these HubSpot days.

**中文翻译:**
是的。首先，有很多 Slack 频道，Snyk 基本上是在 Slack 上运行的。所以有很多频道。甚至当我们规划实验时，这些计划也是公开透明的，我们邀请大家协作。但从仪式感（ceremony）的角度来看，我们努力将产生和利用认知的方法制度化。这是我非常看重的一点。我们有这种团队层面的“影响与学习回顾会”，大致模仿了 Brian Balfour 几年前写的一篇关于他在 HubSpot 时期类似仪式的博客。

---

### [01:07:26] [Ben Williams]

**English:**
And if I had to pick one meeting that as the most important in the growth team, it would be this. The teams continuously document any learnings from data exploration, from experimentation, from user research and so on. They document that in their weekly impact and learnings document.

**中文翻译:**
如果让我选一个增长团队中最重要的会议，那就是这个。团队会不断记录来自数据探索、实验、用户研究等方面的任何认知。他们会将这些记录在每周的“影响与学习文档”中。

---

### [01:07:43] [Ben Williams]

**English:**
Some teams find it better to pair up and advanced into dedicated learning sessions to deep dive on specific relevant topics. But however it comes together, it's all put into that document.

**中文翻译:**
有些团队觉得结对进行专门的学习会议来深入探讨特定的相关主题会更好。但无论形式如何，最终都会汇总到那个文档中。

---

### [01:07:53] [Ben Williams]

**English:**
When it comes to the meeting itself, it's usually run by the pm. Most of it is spent discussing learnings that have been documented, their implications, how they can be leveraged in follow up work, where they might have relevance to other teams and so on. For relatively smaller part of the meeting is also spent looking at key metrics. Some teams have actually split that out entirely into a separate meeting. And then no time at all is spent reviewing what the team have actually been doing. It's more on kind of the outcomes and the learning. So that's at the team level.

**中文翻译:**
至于会议本身，通常由 PM 主持。大部分时间花在讨论已记录的认知、它们的影响、如何在后续工作中利用它们、它们可能与哪些其他团队相关等等。会议中相对较小的一部分时间用于查看关键指标。有些团队实际上已经将其完全拆分为一个独立的会议。然后，完全不会花时间回顾团队实际上做了什么。它更多是关于结果和学习。这是在团队层面。

---

### [01:08:21] [Ben Williams]

**English:**
But then we run that same meeting at the group level on a monthly basis. So that's run by the product engineering or marketing director for the growth group. And that's where all of the growth teams come together. They share some key learnings, can't share everything. Of course, what they're doing is picking specific learnings that have potential relevance in utility across the other teams. So also as a standing agenda item for our user research team to share what we call developer insights. That's one of my personal favorite meetings to attend. It's always recorded and socialize with the rest of the company afterwards. And yeah, I'd say that's really important, but there's a bunch of different ways in which we're filing out that information constantly.

**中文翻译:**
然后，我们每月在小组（Group）层面运行同样的会议。由增长小组的产品工程或营销总监主持。所有的增长团队都会聚在一起。他们分享一些关键认知，当然不能分享所有内容。他们会挑选那些对其他团队具有潜在相关性和效用的特定认知。此外，我们的用户研究团队还有一个固定议程，分享我们所谓的“开发者洞察”。这是我个人最喜欢参加的会议之一。它总是会被录制下来，事后在全公司范围内进行社交化分享。是的，我认为这非常重要，但我们有很多不同的方式在不断地分发这些信息。

---

### [01:08:59] [Lenny]

**English:**
So cool. And this is a meeting that anyone can come to like a sales person comes to.

**中文翻译:**
太酷了。这是一个任何人都可以参加的会议吗？比如销售人员也可以来看看产品团队最近从实验中学到了什么有趣的东西。

---

### [01:09:03] [Lenny]

**English:**
And this is a meeting that anyone can come to like a sales person comes to see what interesting stuff the product team has learned recently from experiments. How cool. Would you be able to share a template of that document that you put together that we could include in the show notes?

**中文翻译:**
这是一个任何人都可以参加的会议，比如销售人员可以来看看产品团队最近从实验中学到了什么有趣的东西。太酷了。你能分享一下你整理的那个文档的模板吗？我们可以把它放在节目介绍里。

---

### [01:09:13] [Ben Williams]

**English:**
Yeah, for sure.

**中文翻译:**
没问题，当然可以。

---

### [01:09:14] [Lenny]

**English:**
Sweet. And then the meeting, you said it's run by basically like some of the product functions and ideas to share things they've learned in recent experiments, say in the past month.

**中文翻译:**
太棒了。关于那个会议，你说它基本上由一些产品职能部门主持，目的是分享他们在最近（比如过去一个月）的实验中学到的东西。

---

### [01:09:25] [Ben Williams]

**English:**
Typically the team level ceremony, it's PM-led. That's from more from a facilitation perspective. The learnings are all brought forward by the various folks in the team and each one of them who's contributed to learning will talk about that learning with the group and facilitate the discussion from there. And then at the group level, those are read by the directors for the growth group and each team it might be an engineering lead, it might be a tech lead, it might be a designer, it might be the product manager. We'll talk about some key learnings from that month.

**中文翻译:**
通常团队层面的仪式是由 PM 领导的，这更多是从引导（facilitation）的角度。认知是由团队中的不同成员提出的，每个贡献了认知的人都会向小组讲解，并引导讨论。在小组层面，会议由增长小组的总监主持，每个团队可能会派出一名工程负责人、技术负责人、设计师或产品经理来分享当月的关键认知。

---

### [01:09:56] [Lenny]

**English:**
Makes sense. If there's nothing PMs are good at, it's facilitating meetings. So that makes sense. Okay. And so that's a good segue to just chatting a bit about the product org. I'm curious just like how you structure the product team and then how that works with the growth team.

**中文翻译:**
有道理。如果说 PM 有什么擅长的，那就是主持会议了。所以这很合理。好，这正好可以过渡到聊聊产品组织。我很好奇你是如何构建产品团队的，以及它是如何与增长团队协作的。

---

### [01:10:10] [Ben Williams]

**English:**
That's good. So the product org, what do you want to know?

**中文翻译:**
好的。关于产品组织，你想了解什么？

---

### [01:10:13] [Lenny]

**English:**
Broadly, how do you structure it? Just like how many teams do you have? Do you align it across by outcome or is it by surface area of a product? And then is the growth team like adjacent to this product org? Is it like a unit within the product org or is it integrated? But I don't think it is. So what does that look like org chart wise?

**中文翻译:**
大致上，你是如何构建它的？你们有多少个团队？是按结果（outcome）划分，还是按产品的表面积（surface area）划分？增长团队是独立于产品组织之外，还是产品组织内部的一个单元，或者是整合在一起的？我觉得不是整合的。那么从组织架构图上看是什么样的？

---

### [01:10:34] [Ben Williams]

**English:**
I think we've got a fairly common pattern for how we structure our product and wider R&D org. So most of the org functional ownership-based, there are a lot of really complex domains in the core product. So having that localized knowledge is important to be able to own and run the code that teams ship. The growth teams, on the other hand, are structured by outcomes. We talked about that already. Owning areas like acquisition, activation, engagement, monetization. These outcomes and team remits change over time as we talked about. But the teams here are often working on areas of the product where they don't own the code, which I think is the key difference between how we structure our growth teams and product teams with some exceptions. One of the growth teams actually own the onboarding flows and so on. So that does require a lot of trust.

**中文翻译:**
我认为我们在构建产品和更广泛的研发组织方面采用了一种相当常见的模式。大部分组织是基于职能所有权（functional ownership）的，核心产品中有很多非常复杂的领域。因此，拥有局部知识对于拥有和运行团队交付的代码至关重要。另一方面，增长团队是按结果（outcomes）构建的。我们已经聊过这个了，负责获取、激活、参与、变现等领域。正如我们所说，这些结果和团队职责会随时间而变化。但这里的团队经常在他们并不拥有代码的产品区域工作，我认为这是我们构建增长团队和产品团队之间的关键区别（当然也有例外，比如一个增长团队实际上拥有入职流程等）。所以这确实需要大量的信任。

---

### [01:11:25] [Ben Williams]

**English:**
It requires very transparent communication mechanisms built into how we work. One of the meetings that we have regularly is experiment plan reviews. They're ad hoc meetings. They're led by the experiment lead, could be the PM, could be anyone else in the team. But the important thing is a bunch of people will be invited there, especially stakeholders from other teams where we might be experimenting on their surfaces and that won't be the first time they've learned about this. We'd like to try and actually include them in co-designing the experiment plan so they're fully on board with it. But absolutely kind of inviting them into those experiment and views really key. If we're going to run an experiment on that surface, we need to make sure that everything in that experiment plan is watertight, especially from a scheduling perspective because the last thing we want is a week and a half into an experiment for some change to happen within that surface from the product team unaware that an experiment's happening and completely invalidate the experiment.

**中文翻译:**
这需要在我们的工作方式中建立非常透明的沟通机制。我们定期举行的会议之一是“实验计划评审”。这些是临时会议，由实验负责人（可能是 PM，也可能是团队中的其他人）主持。重要的是会邀请很多人参加，特别是来自其他团队的利益相关者，因为我们可能会在他们的产品区域进行实验，而这不应该是他们第一次听说这件事。我们希望尝试让他们参与共同设计实验计划，以便他们完全支持。邀请他们参与实验评审非常关键。如果我们要在那块区域运行实验，我们需要确保实验计划万无一失，特别是在进度安排方面。因为我们最不希望看到的是，实验进行到一周半时，产品团队在不知道有实验的情况下对该区域进行了更改，从而导致实验完全失效。

---

### [01:12:26] [Lenny]

**English:**
Cool. And then in terms of just org wise, do you have a lieutenant that is responsible for just say the product team and then someone responsible for the growth team or the directors report up to you and you have a bunch of reports? How's that structure?

**中文翻译:**
酷。那么从组织架构上讲，你是否有一个副手专门负责产品团队，另一个负责增长团队？还是说所有的总监都直接向你汇报，你有很多下属？结构是怎样的？

---

### [01:12:39] [Ben Williams]

**English:**
Oh, so our CPO on the exec team [inaudible 01:12:43], he runs the entire product organization. He has four, I want to say VPs, that own different areas. So there's a couple of VPs that own different areas of the product. So first of all, our application security products. Secondly, our cloud security products. Third is platform. And fourth is what we call developer journeys, which is the area I own, which has a few groups within there, one of which being the growth group.

**中文翻译:**
噢，我们的 CPO 负责整个产品组织。他有四位副总裁（VP），分别负责不同的领域。有两位 VP 负责产品的不同领域：首先是我们的应用安全产品，其次是我们的云安全产品。第三个领域是平台。第四个是我们所谓的“开发者旅程”，这是我负责的领域，其中包含几个小组，增长小组就是其中之一。

---

### [01:13:13] [Lenny]

**English:**
Got it. Okay. Makes sense. Okay. There's just a couple more questions I want to ask that are very tactical specific before we get to a very exciting lightning round to close this out. One is with a freemium product, there's always this question of what to put into free and what to put into the paid plan. Is there anything you've learned about how to think about that? What should be in free and what should be behind a paywall?

**中文翻译:**
明白了。好，有道理。在进入最后的精彩闪电轮之前，我还有几个非常具体的战术问题想问。一个是关于免费增值（Freemium）产品，总有一个问题：哪些功能该免费，哪些该放进付费计划。关于如何思考这个问题，你学到了什么吗？哪些应该免费，哪些应该放在付费墙后面？

---

### [01:13:36] [Ben Williams]

**English:**
Was it on your show with Elena that she talked about things that promote your growth model being good to land in free and things that add friction? So I really like that guidance. I'll add that for many businesses there might be some cost of service element to consider as well. Providing a feature to free users is cost prohibitive due to the volume, then that's obviously something you're going to want to reserve for paid. Ultimately, that was the whole reason cited behind Heroku, recently removing their free plain entirely. I think your plans from free to the top, they should have well defined understanding of the target customer, the use cases they should map out or you should map out the motivations for motion between each. You're really clear about what are the drivers for someone to take a step from one plan to the next. For Snyk, the real drivers to move from free to a paid plan, for example, is when you want to secure business critical code and you start having needs around governance and compliance.

**中文翻译:**
是在你和 Elena 的节目中吗？她提到过，有利于促进增长模型的东西适合放在免费版，而增加摩擦的东西则不然。我非常喜欢那个指导原则。我想补充一点，对于许多企业来说，可能还需要考虑服务成本因素。如果由于用户量巨大，向免费用户提供某项功能的成本过高，那么显然你会想将其保留给付费用户。归根结底，这就是 Heroku 最近完全取消免费计划的原因。我认为从免费到最高级的计划，都应该对目标客户、用例有明确的理解，你应该规划出各计划之间迁移的动力。你要非常清楚是什么驱动用户从一个计划迈向下一个。对于 Snyk 来说，从免费转向付费计划的真正驱动力，例如，是当你想要保护业务关键代码，并且开始在治理和合规方面有需求时。

---

### [01:14:39] [Ben Williams]

**English:**
I think the other interesting dimension is of how you approach trials. Like with most things. I think we're still figuring that out at Snyk. I don't know that there's ever a perfect answer or even a correct answer here. Certainly different from product to product. We have a self-serve trial to support time box evaluation of some of the capabilities that are reserved for our paid plans. But we're intentional in revisiting the model periodically. It's important I think to regularly challenge yourselves to ensure you don't fall into the trap of simply assuming what was best fit in the past is best fit now and in the future. What if the trial duration was limited by some dimension of usage instead of time? Or what if we didn't have a trial at all but put more into the free plan with appropriate limits? How might making those changes impact our growth model?

**中文翻译:**
我认为另一个有趣的维度是你如何处理试用（trials）。就像大多数事情一样，我认为我们在 Snyk 仍在摸索。我不确定是否有一个完美的答案，甚至不确定是否有正确的答案。不同产品肯定不同。我们有一个自服务试用版，支持对付费计划中保留的一些功能进行限时评估。但我们会定期有意识地重新审视这个模型。我认为定期挑战自己很重要，以确保你不会陷入“简单地假设过去最合适的现在和未来也最合适”的陷阱。如果试用期限不是按时间限制，而是按某种使用维度限制呢？或者如果我们根本没有试用期，而是把更多功能放入有适当限制的免费计划中呢？做出这些改变会如何影响我们的增长模型？

---

### [01:15:27] [Ben Williams]

**English:**
It's not always easy to answer those questions, but I think there are some ways that you could can help test there for example. You might cohort trial users and teams who have low engagement and don't convert during the trial and then when the trial ends, drop them back into a new enhanced freak plan and monitor engagement there. So there're some things you do, but I think that habit of continuously challenging yourselves and reevaluating whether the model, the specific delineations between the plans and how you support evaluation and the motion between those plans, I think it's really important to do that. And also when it comes to PLG and sales, we talked about the self-serve motion. Obviously, it's big and important for Snyk, but the sales led motion critically large as well and significantly impactful. You need to think about the plan design and those motions across both aspects of PLG and the sales led motion. When you have a strong PLG foundation that is inclusive of a product-led sales motion, you're going to be in a really powerful position from the perspective of having a significant volume of highly qualified leads that are coming from the product. We actually track a metric that we call product-driven revenue, which basically accounts for all revenue in customers where we saw meaningful value-based activity in the product before there was any sales contact. And that really tells actually a super interesting story about the PLG efficiency of your company across all revenue channels, self-serve and sales-led. And what's fascinating there is that the product-driven cohort contribute a relatively greater amount to net retention. So when you think about packaging, you know really need to think about and understand that macro level contribution of the freemium motion and know what you're trying to optimize for balancing revenue today versus potential future revenue.

**中文翻译:**
回答这些问题并不总是容易的，但我认为有一些方法可以帮助测试。例如，你可以对试用期参与度低且未转化的用户和团队进行分群，当试用结束时，将他们放回一个新的增强版免费计划中，并监测那里的参与度。所以你可以做一些尝试。但我认为，不断挑战自我并重新评估模型、计划之间的具体界限、以及你如何支持评估和计划间迁移的习惯，是非常重要的。此外，谈到 PLG 和销售，我们聊到了自服务动作。显然，这对 Snyk 来说非常重要，但销售主导的动作也极其庞大且影响深远。你需要考虑 PLG 和销售主导这两个方面的计划设计和动作。当你拥有包含产品驱动销售动作的强大 PLG 基础时，从拥有大量来自产品的高质量线索的角度来看，你将处于非常有利的地位。我们实际上追踪一个名为“产品驱动营收”的指标，它基本上涵盖了在任何销售接触之前，我们在产品中看到有意义的价值导向活动的客户的所有营收。这实际上讲述了一个关于公司在所有营收渠道（自服务和销售主导）中 PLG 效率的超级有趣的故事。令人着迷的是，产品驱动的这一群体对净留存（net retention）的贡献相对更大。所以当你考虑包装（packaging）时，你真的需要思考并理解免费增值动作的宏观贡献，并明确你是在平衡当下的营收与潜在的未来营收。

---

### [01:17:28] [Lenny]

**English:**
Is that increase in net revenue retention from product-led leads mostly because they start at a cheaper price, do you think? Or is it more that they just end up being better customers?

**中文翻译:**
你认为产品驱动线索带来的净收入留存增加，主要是因为他们开始时的价格较低吗？还是因为他们最终成为了更好的客户？

---

### [01:17:40] [Ben Williams]

**English:**
It's a great question. I'm not sure I have a good answer for that.

**中文翻译:**
这是一个好问题。我不确定我是否有一个好的答案。

---

### [01:17:45] [Ben Williams]

**English:**
I'm still trying to figure that out.

**中文翻译:**
我还在努力弄清楚这一点。

---

### [01:17:48] [Lenny]

**English:**
No problem. It's a good prompt to have people adding more customers in seats. You talked about the importance to figure out the trial length and what to put in the trial and free and things like that. Is there anything that just has surprised you? Something you've learned from iterating on that comes to mind?

**中文翻译:**
没关系。这是一个让人们增加更多客户席位的好提示。你谈到了确定试用长度、试用版和免费版放什么内容的重要性。有什么让你感到惊讶的事情吗？在迭代过程中学到的东西有什么想到的吗？

---

### [01:18:04] [Ben Williams]

**English:**
I wouldn't say surprised me per se, but it's something that I think it's perhaps obvious in retrospect and that is that companies of different sizes, of different complexities of different industries from those that are very highly regulated to the other end of the spectrum, they're going to take different lengths of time to need to evaluate properly. So being able to cater for those in some way, whether it might be dynamic trial lengths or whether it be trial lengths that are based on usage or things like that, I think it becomes really important. That's something to be thinking about for sure.

**中文翻译:**
我不会说这本身让我惊讶，但我觉得回过头来看这可能是显而易见的：不同规模、不同复杂度、不同行业的公司（从受到高度监管的到光谱另一端的公司），评估产品所需的时间是不同的。因此，能够以某种方式迎合这些需求，无论是动态试用长度，还是基于使用情况的试用长度等等，我认为都变得非常重要。这绝对是值得思考的事情。

---

### [01:18:47] [Lenny]

**English:**
Awesome. That's a great learning. I know Elena talks a lot about how trials often, screw you because you don't give people enough time to really evaluate it a company, so that makes sense. Last tactical question that I wanted to touch on is around activation milestones. I'm doing a survey right now with Yuri that I think will come out before this episode airs. But anyway, in real time, I'm curious how you think about setting what the activation milestone is for a new Snyk user. So maybe just share briefly how you think about what is an activation milestone? Why is that important? And then how you define that for Snyk? What is the milestone of a user is activated for your product?

**中文翻译:**
太棒了。这是一个很好的经验。我知道 Elena 经常谈到试用期往往会坑了你，因为你没有给公司足够的时间去真正评估它，所以这很有道理。我想触及的最后一个战术问题是关于激活里程碑（activation milestones）。我目前正在和 Yuri 进行一项调查，我想在这一集播出之前就会发布。无论如何，实时地，我很想知道你是如何考虑为 Snyk 新用户设置激活里程碑的。也许可以简要分享一下你如何看待什么是激活里程碑？为什么它很重要？以及你是如何为 Snyk 定义它的？对于你的产品，用户被“激活”的里程碑是什么？

---

### [01:19:28] [Ben Williams]

**English:**
First of all, what is activation? So for us, activation is indicative of the team forming a habit around the usage of Snyk. And when I say the usage, I actually mean deriving core value, which is ultimately fixing vulnerabilities. It's not just logging in. It's not even just finding vulnerabilities, it's fixing vulnerabilities. So building a habit around that. And the reason I say team instead of using them is, and we actually base most of our definitions of activation engagement around teams. It's really important because ultimately security is a team sport. That team might be one person, which case a user is equivalent to team, but often a team is multiple people and we actually expect different people to fulfill different parts of the team activation journey.

**中文翻译:**
首先，什么是激活？对我们来说，激活预示着团队围绕 Snyk 的使用形成了习惯。当我提到“使用”时，我实际上是指获得核心价值，即最终修复漏洞。不仅仅是登录，甚至不仅仅是发现漏洞，而是修复漏洞。所以是围绕这一点建立习惯。我之所以说“团队”而不是“用户”，是因为我们实际上将大多数激活参与度的定义建立在团队基础上。这非常重要，因为归根结底，安全是一项团队运动。那个团队可能只有一个人，这种情况下用户等同于团队，但通常一个团队由多人组成，我们实际上期望不同的人完成团队激活旅程的不同部分。

---

### [01:20:17] [Ben Williams]

**English:**
We also want to enumerate aggregate level activity around fix that sometimes happens off-platform where we can't explicitly measure it at the user level. So in the activation process, we have set up moments, aha moments and habit moments and our habit moments that we define as a team being activated, it's related to fixing vulnerabilities within 30 days of team creation. And the reason that is chosen, it's because there is a significant correlation with downstream. And in that case with activation three month retention and retention again based on, again, not just coming back and logging in but still fixing. So teams, that fix of vulnerability within their first 30 days are much more likely to still be fixing three months later.

**中文翻译:**
我们还想量化关于修复的聚合层级活动，这些活动有时发生在平台之外，我们无法在用户层级明确衡量。所以在激活过程中，我们有“设置时刻”（setup moments）、“顿悟时刻”（aha moments）和“习惯时刻”（habit moments）。我们将“习惯时刻”定义为团队被激活，它与团队创建后 30 天内修复漏洞有关。之所以选择这个，是因为它与下游指标有显著的相关性。在这种情况下，激活与三个月留存率相关，而这里的留存率同样是基于“是否仍在修复”，而不仅仅是回来登录。因此，在最初 30 天内修复了漏洞的团队，三个月后仍在修复的可能性要大得多。

---

### [01:21:09] [Lenny]

**English:**
That's really interesting. I love that. How did you come up with that number? Was there a decision scientist that looked at some inflection of at 30 days, and it's probably not exactly 30 in real life, but it's like a nice round number that's close enough, right?

**中文翻译:**
这真的很有趣。我喜欢这个。你是怎么得出这个数字的？是不是有决策科学家观察了 30 天左右的某个拐点？现实生活中可能不正好是 30 天，但它是一个足够接近的整数，对吧？

---

### [01:21:24] [Ben Williams]

**English:**
Yep, that's it. So there absolutely was a decision scientist in involved thankfully. We had to collect a lot of baseline data first. So after we built out the data platform, we needed actually to wait for bit to build a good data set. We did a huge amount of quantum analysis, a lot of splunking of the data, applying ML models along with a bunch of supporting call research as well. But we started really with identifying the corpus personas and they used cases, different roles of different users within the team based activation journey, defining our retention metric, which is still fixing. It's whether a team is fixed. Along with natural usage behavior and expected natural usage frequency. And then we found the habit moment that ultimately most strongly correlated with improved long-term retention. And most of the numbers side of things came out of our ML ops platform.

**中文翻译:**
没错，就是这样。谢天谢地，确实有决策科学家参与其中。我们必须先收集大量的基准数据。所以在我们构建好数据平台后，我们实际上需要等待一段时间来建立一个好的数据集。我们进行了大量的定量分析，对数据进行了大量的挖掘（splunking），应用了机器学习模型，并结合了一系列支持性的定性研究。但我们真正的起点是识别核心画像及其用例、基于团队的激活旅程中不同用户的不同角色，定义我们的留存指标（即“仍在修复”——团队是否修复了漏洞），以及自然使用行为和预期的自然使用频率。然后我们找到了最终与长期留存率提升最强相关的“习惯时刻”。大部分数据方面的工作都来自我们的机器学习运维（ML ops）平台。

---

### [01:22:19] [Ben Williams]

**English:**
But after that, we then worked back to figure out that's the habit moment. That's what we see as activation, but there's a set of steps that teams need to get there. So what's the aha moment before that? What's the setup moment and what are the individual steps that the team needs to go through to reach that set up moment? So that's the overall process and ultimately it's a really strong model that allows us then to feed in the set of user level behaviors that we know can influence those different steps on that path to activation.

**中文翻译:**
在那之后，我们反向推导：既然那是习惯时刻，也就是我们认为的激活，那么团队需要经过哪些步骤才能到达那里？在那之前的顿悟时刻是什么？设置时刻是什么？团队为了达到设置时刻需要经历哪些具体步骤？这就是整个过程。最终，这是一个非常强大的模型，它允许我们输入一系列我们知道可以影响激活路径上不同步骤的用户级行为。

---

### [01:22:50] [Lenny]

**English:**
Awesome. I'm excited to get this post out and that's a really good anecdote of how a company comes up with it and what they set. I also just thought of another question I may start asking everybody. I know I keep saying we're going to wrap this up, but here's a question and if it doesn't work, we'll get rid of it. You mentioned a bunch of tools that you use and I'm curious, if you had to think of what are the five most important/valuable SaaS products to your organization other than the obvious ones like Salesforce? What comes to mind?

**中文翻译:**
太棒了。我很兴奋能发布这篇文章，这是一个关于公司如何得出结论并设定目标的极佳案例。我还想到了另一个我可能会开始问每个人的问题。我知道我一直在说我们要结束了，但这里有一个问题，如果效果不好我们就把它删掉。你提到了很多你使用的工具，我很想知道，如果你必须想出对你的组织最重要/最有价值的五个 SaaS 产品（除了像 Salesforce 这样显而易见的），你会想到什么？

---

### [01:23:21] [Ben Williams]

**English:**
When you say organization, do you mean Snyk at large or do you mean the growth?

**中文翻译:**
当你提到“组织”时，是指整个 Snyk，还是指增长部门？

---

### [01:23:25] [Lenny]

**English:**
Let's say, let's start with growth and see where it goes.

**中文翻译:**
我们先从增长部门开始，看看情况如何。

---

### [01:23:27] [Ben Williams]

**English:**
Okay. So I'm going to say Amplitude, first of all. Segment as a means to be able to get our data from the products to Amplitude and to everywhere else that cares about it. Whether that be a downstream BI system, Snowflake can looker on top of that, or system marketing automation systems like Marketo and stuff like that. So I'd say Amplitude. I will next say full story, which is absolutely fantastic for session replays of course. And it bridges that gap between [inaudible 01:24:11]. I would say userinterviews.com, which is comparable to usertesting.com, both of them amazing services in terms of getting fast curated access to individuals to participate in user research. Sprig is another one. So Sprig is a fantastic in-app survey platform, which is what we primarily use it for, but it also does a bunch of other cool stuff in terms of being able to test UX designs as well in-app. How many have I said?

**中文翻译:**
好的。首先我要说的是 Amplitude。然后是 Segment，作为将数据从产品传输到 Amplitude 以及其他任何关注数据的地方（无论是下游 BI 系统、Snowflake 上的 Looker，还是像 Marketo 这样的营销自动化系统）的手段。所以我说 Amplitude。接下来我会说 FullStory，它在会话重放（session replays）方面绝对非常棒，它弥补了……之间的差距。我会说 userinterviews.com，它与 usertesting.com 类似，两者在快速获取经过筛选的个人参与用户研究方面都是极好的服务。Sprig 是另一个，它是一个非常棒的应用内调查平台，这是我们主要使用它的目的，但它在应用内测试 UX 设计方面也有很多其他酷炫的功能。我说几个了？

---

### [01:24:49] [Lenny]

**English:**
I think four. If there's anything else, you could add a fifth. If not, we can move on. That's awesome. This is a really interesting list.

**中文翻译:**
我想是四个。如果有其他的，你可以加第五个。如果没有，我们可以继续。太棒了，这是一个非常有趣的名单。

---

### [01:24:55] [Ben Williams]

**English:**
I'll stick it at four.

**中文翻译:**
我就停在四个吧。

---

### [01:24:56] [Lenny]

**English:**
Okay. Is there anything for in the wider product team that also comes to mind that you guys find useful?

**中文翻译:**
好的。在更广泛的产品团队中，还有什么你们觉得有用的工具吗？

---

### [01:25:02] [Ben Williams]

**English:**
Airtable. In fact, Airtable for growth and product, just so flexible. It's just you can do anything. And in fact, if we think about growth, I should have mentioned that first because that's where we keep most of our experiment plans and knowledge base and our user research base.

**中文翻译:**
Airtable。事实上，Airtable 对增长和产品来说非常灵活。它几乎无所不能。事实上，如果我们考虑增长，我本该第一个提到它，因为那是我们存放大部分实验计划、知识库和用户研究库的地方。

---

### [01:25:18] [Lenny]

**English:**
Okay. I like this question. I'm going to start asking it. This is great. Okay. That was a precursor tour, very exciting lightning round. I'm just going to ask you a bunch of rapid fire questions, just answer whatever comes to mind. We'll keep it short and quick. Question one, what are two or three books that you recommend most to other people?

**中文翻译:**
好的。我喜欢这个问题，我要开始问了。这太棒了。好，那是前奏，现在进入非常令人兴奋的闪电轮。我会问你一堆快速问题，想到什么就回答什么。我们会保持简短快速。第一个问题：你最推荐给别人的两三本书是什么？

---

### [01:25:34] [Ben Williams]

**English:**
I have been dreading this question as there are too many. So I'm pick a couple that I've enjoyed reading in recent months. So for product and growth geeks like me, or in fact anyone with more than a passing interest in data, I'll recommend "How to Measure Anything" by Douglas Hubbard. Second up, you had Marty Cagan and he mentioned the book "Sprint" by Jake Knapp and John Zeratsky and I love that book, but personally their "Make Time" book. It was something that radically changed my relationship with information and I recommend that to all time staff, product people out there. And for number three, I'm going to say, "This is How They Tell Me the World Ends" by Nicole Perlroth, which gives an amazing view into the world of digital espionage.

**中文翻译:**
我一直很怕这个问题，因为好书太多了。所以我选几本我最近几个月读得很开心的书。对于像我这样的产品和增长极客，或者实际上对数据有浓厚兴趣的任何人，我推荐 Douglas Hubbard 的《如何衡量一切》（How to Measure Anything）。第二本，你采访 Marty Cagan 时他提到了 Jake Knapp 和 John Zeratsky 的《设计冲刺》（Sprint），我也很喜欢那本书，但我个人更推荐他们的《专注力：如何找回你的时间》（Make Time）。它彻底改变了我与信息的关系，我向所有忙碌的产品人推荐它。第三本，我要说 Nicole Perlroth 的《这就是他们告诉我世界末日的方式》（This is How They Tell Me the World Ends），它提供了一个观察数字间谍世界的绝佳视角。

---

### [01:26:22] [Lenny]

**English:**
Oh, I read that book. Tim Ferris recommended that at one point. That is a wild ass book. Very beautiful. Cool. I love these recommendations. All right. Great choices. Favorite podcast other than the podcast you're currently on

**中文翻译:**
噢，我读过那本书。Tim Ferris 曾经推荐过。那是一本非常疯狂的书，写得非常漂亮。酷。我喜欢这些推荐。好，很棒的选择。除了你现在参加的这个播客，你最喜欢的播客是什么？

---

### [01:26:37] [Ben Williams]

**English:**
Maybe "Acquired" with Ben Gilbert and David Rosenthal. I just wish I had enough time to listen to them all.

**中文翻译:**
可能是 Ben Gilbert 和 David Rosenthal 的《Acquired》。我只是希望我有足够的时间把它们都听完。

---

### [01:26:43] [Lenny]

**English:**
They're very long. I was just at an event where they interviewed someone live as a live podcast. That was very cool. Those guys were pros. What's a favorite recent movie or TV show?

**中文翻译:**
它们确实很长。我刚参加了一个活动，他们在现场进行了一次直播播客采访。非常酷，那些家伙是专业的。最近最喜欢的电影或电视节目是什么？

---

### [01:26:54] [Ben Williams]

**English:**
So a movie, "Turning Red" on Disney Plus, which we love watching with our kids. It was just fun. TV show, the most recent Curb Season had me in tears as usual.

**中文翻译:**
电影的话，Disney Plus 上的《青春养成记》（Turning Red），我们很喜欢和孩子们一起看，很有趣。电视节目，最近一季的《抑制热情》（Curb Your Enthusiasm）像往常一样让我笑出眼泪。

---

### [01:27:03] [Lenny]

**English:**
They haven't had a new one in a while. So that's a little bit out there.

**中文翻译:**
他们已经有一段时间没出新的了。所以这有点久远。

---

### [01:27:09] [Ben Williams]

**English:**
The new one's coming.

**中文翻译:**
新的快来了。

---

### [01:27:10] [Lenny]

**English:**
Oh, it is? I don't love watching that show. My wife loves it. Cringe, painful. But watch it anyway.

**中文翻译:**
噢，是吗？我不怎么喜欢看那个节目。我妻子很喜欢。太尴尬了，看得痛苦。但还是会看。

---

### [01:27:19] [Ben Williams]

**English:**
And my wife's actually the same. She can't watch it because she cringes too much.

**中文翻译:**
我妻子其实也一样，她看不下去，因为太尴尬了。

---

### [01:27:23] [Lenny]

**English:**
We're reverse.

**中文翻译:**
我们正好相反。

---

### [01:27:24] [Ben Williams]

**English:**
I love the awkwardness.

**中文翻译:**
我喜欢那种尴尬感。

---

### [01:27:25] [Lenny]

**English:**
Oh man. It's good for a product leader to have that enjoyment. Favorite interview question that you'd like to ask candidates?

**中文翻译:**
天哪。产品领导者能享受这种尴尬感是件好事。你最喜欢问应聘者的面试问题是什么？

---

### [01:27:34] [Ben Williams]

**English:**
Give a couple here if it's not cheating too much. First is one I like to ask when hiring for anyone actually really it's fast forward three years. What's different about you then? A lot of people will default to telling you where they aspire to be in terms of role or title, but what I'm really looking for is signals of humility, of self-awareness around areas of personal and professional growth. So people who can be open about where they think they need to work on to grow themselves as people. I love that. Also, so there's just generally throughout interviews, I'm looking for curiosity. So day-to-day good PMs will be asking why as much as my six year old son does, which is a lot. So I'll try and discern that through the course of the conversation. It's not really a question, but something I'm looking for.

**中文翻译:**
如果不算作弊的话，我分享两个。第一个是我喜欢问任何应聘者的：快进到三年后，那时的你有什么不同？很多人会默认告诉你他们渴望达到的职位或头衔，但我真正寻找的是谦逊的信号，以及对个人和职业成长领域的自我意识。也就是那些能坦诚分享他们认为自己需要在哪些方面努力以实现个人成长的人。我喜欢那个。此外，在整个面试过程中，我都在寻找好奇心。日常工作中，优秀的 PM 问“为什么”的次数应该和我六岁的儿子一样多，那是相当多的。所以我会尝试在对话过程中辨别这一点。这不完全是一个问题，而是我寻找的一种特质。

---

### [01:28:27] [Ben Williams]

**English:**
And then maybe I want to flip it because building on something that Adam Fishman was saying, his theme of evaluating the people dimension of folks you are potentially going to work with when you're interviewing with a company. And this was a question I got asked myself recently by a candidate, which I just thought would brilliant, and that was, "Tell me about the diversity, equity, inclusion, and belonging initiatives that you've recently personally been involved with?" And it just felt like a really great way for them to be able to test alignment of their personal values with those of someone they'd be working with really closely. So I love that.

**中文翻译:**
然后也许我想反过来，基于 Adam Fishman 所说的主题，即当你去一家公司面试时，评估你潜在共事者的“人”的维度。这是最近一个应聘者问我的问题，我觉得非常精彩，那就是：“告诉我你最近亲自参与过的多样性、公平、包容和归属感（DEIB）计划有哪些？”我觉得这是一种非常棒的方式，让他们能够测试自己的个人价值观是否与即将紧密共事的人一致。所以我很喜欢这个。

---

### [01:29:01] [Lenny]

**English:**
Awesome. By the way, I love how many callbacks to other episodes you're making. You're definitely a power adopter of the podcast and I really appreciate that.

**中文翻译:**
太棒了。顺便说一下，我非常喜欢你对其他剧集的多次引用。你绝对是本播客的深度用户，我非常感激。

---

### [01:29:09] [Ben Williams]

**English:**
Okay, there we go.

**中文翻译:**
好的，就是这样。

---

### [01:29:11] [Lenny]

**English:**
Last question. Who else in the industry do you most respect as a thought leader, as a leader in general?

**中文翻译:**
最后一个问题。在行业中，作为思想领袖或一般的领导者，你最尊敬谁？

---

### [01:29:17] [Ben Williams]

**English:**
So maybe I'll cheat on this one a bit too, and I'm not going to combine it to the, when you say industry, I think security industry, but I'm going to look at the product domain and specifically product operations. And in my mind, there's not many people who know more in this area than Christine [inaudible 01:29:34]. So if you ever get chance to talk with her, I know that would be a fun conversation. Many gems would be dropped, I think.

**中文翻译:**
这个我也许也要“作弊”一下。我不打算局限于你说的行业（我首先想到的是安全行业），我要看产品领域，特别是产品运营（Product Operations）。在我心中，没有多少人比 Christine 在这个领域了解得更多。所以如果你有机会和她交谈，我知道那会是一次有趣的对话，我想会产生很多金句。

---

### [01:29:40] [Lenny]

**English:**
Wow. I will get her on this podcast. That is my new goal. I had not heard of her and that's awesome. Thank you for the suggestion. Ben, this has been awesome. So many nuggets and stories and insights. I so appreciate you being here. Two last questions. Where can folks find you online if they want to reach out or learn more or maybe come work at Snyk? And then how can listeners be useful to you?

**中文翻译:**
哇。我会邀请她来参加这个播客的，这是我的新目标。我以前没听说过她，这太棒了。谢谢你的建议。Ben，这集太精彩了。有这么多干货、故事和见解。非常感谢你能来。最后两个问题：如果大家想联系你、了解更多信息或者想来 Snyk 工作，可以在哪里找到你？以及，听众能为你做些什么？

---

### [01:30:04] [Ben Williams]

**English:**
Firstly, I'm of course want to say a big thanks for having me on, Lenny. I love talking about all this stuff and really appreciate you being willing to let me bend your ear a little bit. As to finding me, I'm a bit of a Twit when it comes to Twitter. I generally spend a bit more time over at LinkedIn, but you can find me on both of those platforms @SemanticBen. And in terms of how people can be useful to me, I'm starting to take on some additional clients in advisory capacity, so feel free to get in touch if you think I could help.

**中文翻译:**
首先，我当然要非常感谢你邀请我，Lenny。我喜欢聊这些东西，非常感谢你愿意听我唠叨。至于找到我，在 Twitter 上我有点笨拙，我通常在 LinkedIn 上花的时间更多一点，但你可以在这两个平台上通过 @SemanticBen 找到我。至于大家能为我做些什么，我开始以顾问身份接收一些额外的客户，所以如果你觉得我可以提供帮助，请随时联系我。

---

### [01:30:36] [Lenny]

**English:**
I can't not ask about Symantec Ben and what the story is there and before we let you go.

**中文翻译:**
在让你走之前，我不能不问问 Semantic Ben 这个名字背后的故事。

---

### [01:30:41] [Ben Williams]

**English:**
Sure. It's actually when I was at IBM, it was a focus that I had on linked data.

**中文翻译:**
当然。其实是我在 IBM 时，我当时的研究重点是关联数据（linked data，语义网相关）。

---

### [01:30:48] [Lenny]

**English:**
Became Semantic Ben. All right. Awesome. All right. Ben, thank you so much for being here and thanks for listening.

**中文翻译:**
于是就成了 Semantic Ben。好，太棒了。好，Ben，非常感谢你能来，也感谢大家的收听。

---

### [01:30:56] [Ben Williams]

**English:**
Thanks, Lenny. Take care.

**中文翻译:**
谢谢，Lenny。保重。

---

### [01:30:59] [Lenny]

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这集节目有价值，可以在 Apple Podcast、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目再见。