# Benjamin Lauzier - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Benjamin Lauzier.

---

### [00:00:00] Benjamin Lauzier

**English:**
I think when you're running a marketplace, you tend to sit in your ivory tower a little bit, looking at stats and thinking like, "If only we could get people to do X, it'd be better for everyone." I certainly did that in my career. I think that's missing the point that we're humans, and I think sometimes we act in ways that are non-deterministic or counterintuitive. But my take is I'm a huge believer in market forces and empowerment, so provide guardrails for what a good experience is in your marketplace, set a clear bar for quality, and provide the right coaching and tools for supply to be successful, and then take a step back and see where the gaps are and invest more in hands-on tactics just to close those gaps more specifically.

**中文翻译:**
我认为当你经营一个双边市场（Marketplace）时，往往会有点坐在“象牙塔”里的感觉，盯着统计数据心想：“要是我们能让用户去做某某事，对大家都会更好。”在我的职业生涯中，我也确实这么做过。但我认为这忽略了一个重点，那就是我们是人类，有时我们的行为是非确定性的或违背直觉的。我的观点是，我非常相信市场力量和赋能。因此，你应该为市场中的良好体验提供“护栏”（Guardrails），设定明确的质量标准，并为供给侧提供成功的指导和工具。然后退后一步，观察差距在哪里，再针对性地投入更多的人工干预策略来弥补这些具体的差距。

---

### [00:00:47] Lenny Rachitsky

**English:**
Today my guest is Ben Lauzier. Ben was VP of product and growth at Thumbtack, where he rebuilt the product team and Thumbtack's growth strategy, re-architected the revenue model, and helped 3X Thumbtack's growth within three years. Prior to Thumbtack, Ben was at Lyft for over six years, where he was employee number 30 and led product and growth for the driver's side of the business, and at one point reached 1% of U.S. workers driving for Lyft every month. He currently spends his time advising marketplace teams and founders, teaching a reforged course on marketplace growth, and most recently started a healthcare company called Nurra that connects you to a care advocate to help you navigate the healthcare system in the U.S. In our conversation, we go many layers deep on the many key elements of building and scaling a marketplace business, including what to focus on pre-product market fit, how to know which side of the marketplace to prioritize, what product market fit looks like, how to track liquidity, what causes most marketplaces to fail and how to avoid that.

**中文翻译:**
今天的嘉宾是 Ben Lauzier。Ben 曾任 Thumbtack 的产品与增长副总裁，在那里他重组了产品团队和增长策略，重新构建了营收模型，并在三年内帮助 Thumbtack 实现了三倍增长。在加入 Thumbtack 之前，Ben 在 Lyft 工作了六年多，是公司的第 30 号员工，负责司机端的产品和增长，曾一度实现全美 1% 的劳动人口每月为 Lyft 开车。目前，他致力于为双边市场团队和创始人提供咨询，在 Reforge 教授双边市场增长课程，最近还创办了一家名为 Nurra 的医疗保健公司，旨在将用户与护理倡导者（Care Advocate）联系起来，帮助其应对复杂的美国医疗系统。在我们的对话中，我们将深入探讨构建和扩展双边市场业务的许多关键要素，包括在达到产品市场匹配（PMF）之前应关注什么、如何确定优先考虑市场的哪一侧、PMF 的具体表现、如何追踪流动性（Liquidity），以及导致大多数双边市场失败的原因及避免方法。

---

### [00:01:43] Lenny Rachitsky

**English:**
And a bunch of examples of really clever growth strategies, especially on the supply side, and some really interesting stories about how Lyft was able to compete with Uber early on with one-tenth of the resources. As a bonus, Ben also shares insights into how the European product market is different from the U.S. product market, and what he encourages European companies to change in order to operate more effectively and be more innovative. This episode is for anyone building or thinking about building a marketplace business. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube, it's the best way to avoid missing future episodes and it helps the podcast tremendously. With that, I bring you Ben Lauzier. Ben, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
我们还会分享一系列非常聪明的增长策略案例，特别是在供给侧，以及一些关于 Lyft 早期如何以十分之一的资源与 Uber 竞争的有趣故事。此外，Ben 还分享了关于欧洲产品市场与美国市场差异的见解，以及他鼓励欧洲公司做出哪些改变以更有效地运作并提高创新能力。本期节目适合任何正在构建或考虑构建双边市场业务的人。如果你喜欢这个播客，请不要忘记在您常用的播客应用或 YouTube 上订阅和关注，这是避免错过未来节目的最佳方式，也对本播客有巨大帮助。现在，让我们欢迎 Ben Lauzier。Ben，非常感谢你能来，欢迎来到本播客。

---

### [00:02:29] Benjamin Lauzier

**English:**
Thank you so much, so good to be here. Thanks for having me.

**中文翻译:**
非常感谢，很高兴来到这里。谢谢你的邀请。

---

### [00:02:32] Lenny Rachitsky

**English:**
It's absolutely my pleasure. Okay, so you are one of the most knowledgeable and experienced product leaders in the world on building and scaling a marketplace company, and so I want to spend the bulk of our time talking about and essentially extracting as much wisdom out of your brain on how to build and scale a marketplace business so that founders and teams that are struggling with building their marketplace company, or just thinking about building a marketplace business, can save a lot of time and a lot of pain. How does that sound to you?

**中文翻译:**
这是我的荣幸。好的，你是世界上在构建和扩展双边市场公司方面最有见识、经验最丰富的产品领导者之一。因此，我想把大部分时间花在探讨这个话题上，本质上是从你的大脑中提取尽可能多的智慧，关于如何构建和扩展双边市场业务，以便那些正在为此挣扎的创始人或团队，或者刚开始考虑这个业务的人，可以节省大量的时间并少走弯路。你觉得怎么样？

---

### [00:03:03] Benjamin Lauzier

**English:**
That sounds amazing. That's a high bar, but I will try to live up to your expectations.

**中文翻译:**
听起来太棒了。虽然这个标准很高，但我会努力达到你的期望。

---

### [00:03:08] Lenny Rachitsky

**English:**
I'm confident we will hit that bar. Let me start with just setting a little context, and for folks that aren't super familiar with what is a marketplace business, they hear this term marketplace company, what's the simplest way to understand what makes a company a marketplace company and a marketplace business?

**中文翻译:**
我有信心我们能达到那个标准。让我先设定一点背景。对于那些不太熟悉什么是双边市场业务的人来说，他们经常听到“Marketplace Company”这个词，理解一家公司属于双边市场业务的最简单方式是什么？

---

### [00:03:24] Benjamin Lauzier

**English:**
I mean, like you mentioned, I love marketplaces. I think I've been building and scaling marketplaces for I think almost 15 years now, and I feel like they add just such a fascinating dimension to the challenge that we work on as PMs, and it's this hidden dimension that you uncover when you work on marketplaces. And I think on paper what makes a marketplace is pretty straightforward, it's two or more sides that are distinct from one another, and they provide value to each other, and then you have an intermediary trying to facilitate that exchange of value in the middle. So, that's pretty simple explanation. I think in practice it's always a little bit more nuanced on the fringes. You have all those interesting dimensions, like how involved is the intermediary defines how managed the marketplace is. So, something like Craigslist is super hands-off, unmanaged, and something like Lyft starts to be more into the semi-managed where the platform significantly shapes the transaction in this exchange of value. So, I think that's how I see it, but there's all those fascinating variations of marketplaces, I guess.

**中文翻译:**
正如你提到的，我非常热爱双边市场。我想我已经构建和扩展这类市场快 15 年了。我觉得它们为我们作为产品经理（PM）所面临的挑战增加了一个迷人的维度，这是你在处理双边市场时才会发现的隐藏维度。从理论上讲，双边市场的构成非常简单：它有两个或更多彼此独立的侧面，它们互相提供价值，然后有一个中间人（Intermediary）在中间试图促进这种价值交换。这是一个很简单的解释。但在实践中，边缘地带总是更有细微差别。你会看到很多有趣的维度，比如中间人的参与程度定义了该市场的“托管程度”（Managed degree）。例如，Craigslist 是完全放手的、非托管的；而像 Lyft 这样的平台则属于半托管型，平台会显著地塑造价值交换中的交易过程。这就是我的看法，双边市场有很多迷人的变体。

---

### [00:04:25] Lenny Rachitsky (Ad Segment - Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams... [Ad content omitted for brevity in translation, but kept in English as per instructions] ...Check out Eppo at geteppo.com/lenny and 10X your experiment velocity. That's get E-P-P-O dot com slash Lenny.

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台……（广告内容略）……请访问 geteppo.com/lenny 查看 Eppo，让您的实验速度提升 10 倍。

---

### [00:06:52] Lenny Rachitsky

**English:**
You've mentioned managed marketplaces and just how that becomes something marketplaces start to think about more, I want to get back to that because a really important point. But just to even clarify this point, a key part of a marketplace is that the company doesn't own the supply. That's in a sense what defines their marketplace versus they're just selling stuff.

**中文翻译:**
你提到了托管型市场（Managed Marketplaces），以及这如何成为市场开始更多思考的问题。我想稍后回到这一点，因为这非常重要。但为了进一步澄清，双边市场的一个关键部分是公司并不拥有供给（Supply）。从某种意义上说，这就是定义“双边市场”与“单纯卖东西”的区别。

---

### [00:07:12] Benjamin Lauzier

**English:**
Totally. Yes, yes. And I think again, you have companies that claim to be managed marketplaces, I think depending on how you want to look, with investors perhaps, you'll pick one angle or the other, but that's where you get into gray waters. But yeah, the marketplace implies this concept of two independent and supposedly autonomous parties that you help connect and provide this exchange of value for them.

**中文翻译:**
完全正确。是的。而且我认为，有些公司声称自己是托管型市场，这取决于你想从哪个角度看（也许是为了给投资者看），你会选择其中一个角度，但那就会进入灰色地带。不过，双边市场确实隐含了这样一个概念：有两个独立且理应自主的各方，你帮助他们建立联系并为他们提供价值交换。

---

### [00:07:40] Lenny Rachitsky

**English:**
Awesome. Okay, so let's come back to that, because that's a really important topic and it's something that every marketplace trends towards or thinks about is just like we're going to control the supply, we're going to manage it, we're going to maybe own it in the future, but let's get back to that. So, you work with a ton of marketplaces, you've built a bunch of marketplaces. What do you find is the biggest struggle to building a successful marketplace business? The most common problem people run into.

**中文翻译:**
太棒了。好的，让我们稍后回到那个话题，因为那是一个非常重要的主题，每个双边市场都会趋向于或思考“我们要控制供给、管理供给，未来甚至可能拥有供给”。那么，你与大量的双边市场合作过，也构建过很多。你认为构建成功的双边市场业务最大的挑战是什么？人们最常遇到的问题是什么？

---

### [00:08:05] Benjamin Lauzier

**English:**
I think there's two types of challenges, I guess there's when you're talking about creating a marketplace, and then there's when you're talking about scaling a marketplace. For creating a marketplace, I see many founders that are pre-product market fit, super eager to nerd out on marketplace dynamics. They're super excited to launch a marketplace, we all are, and they want to talk about supply and demand, they want to look at all kinds of ratios. They show me economic papers and ask, "How could we apply this principle to my company?" And here, my advice is generally always, "If you don't have product market fit, and if you don't have a good enough growth strategy for at least one side of your marketplace, just forget about all this marketplace stuff." Focus on this core exchange of value, go deep with one side of the marketplace and see if you can rely on some crutch, some hack for the other side for time being. And you see companies like Airbnb and Thumbtack doing this with Craigslist pretty early on to jumpstart their growth as just countless examples, but don't get distracted by this shiny and cool intellectually challenging idea of working on the marketplace, and nail the basics of your product market fit at first.

**中文翻译:**
我认为挑战分为两类：一类是关于“创建”市场，另一类是关于“扩展”市场。在创建阶段，我看到很多处于 PMF（产品市场匹配）之前的创始人，非常渴望钻研市场动态（Marketplace dynamics）。他们对启动一个市场感到兴奋，我们都是如此，他们想谈论供给和需求，想看各种比例。他们给我看经济学论文并问：“我们如何把这个原理应用到我的公司？”在这里，我的建议通常总是：“如果你还没有达到 PMF，如果你还没有为市场的至少一侧制定出足够好的增长策略，那就先忘掉这些‘市场’的东西吧。”专注于核心的价值交换，深入挖掘市场的一侧，看看另一侧是否可以暂时依靠一些“拐杖”或黑客手段（Hack）。你会看到像 Airbnb 和 Thumbtack 早期都利用 Craigslist 来启动增长，这样的例子数不胜数。不要被这种闪亮、酷炫且具有智力挑战的“研究市场”的想法所分心，首先要打好 PMF 的基础。

---

### [00:09:13] Lenny Rachitsky

**English:**
So, just to spend a little more time there to make this even more real. So, you're saying that pre-product market fit, before you find that anyone really wants what you're building, focus on figuring out a way to grow one side of the marketplace. So, maybe just two quick follow up questions. How do you know which side to focus on initially? And can you give an example, I think Thumbtack may be a good example of this, of how they did that?

**中文翻译:**
为了让这一点更具体，我们再多花点时间。你是说在 PMF 之前，在你发现真的有人想要你构建的东西之前，要专注于找到增长市场其中一侧的方法。那么，我有两个简短的后续问题：你如何知道最初应该关注哪一侧？你能举个例子吗？我想 Thumbtack 可能是他们如何做到这一点的一个好例子。

---

### [00:09:38] Benjamin Lauzier

**English:**
Which side to focus on is there's different approaches to this, but generally people will pick the hardest side. And so, I'll take the example of Thumbtack, because we're going to talk about it. So, Thumbtack is a home services marketplace to help you find plumbers, electricians, and the harder side there was demand. There's supply, and you can look for, you can open the yellow pages, you can find plumbers somewhere, but the hardest question was can we go out there and can we find people who want to do something in their house, who have projects that need to be done? What is the core growth strategy for us to acquire those people, to find them? And what kind of retention can we create? Can we create a delightful experience for them to come back to our platform and want us to take care of their home for them? Pick the hardest side is my advice. And then, how some companies do this, again, I think there's a lot of different ways to do this, but a common advice is find a way to jumpstart one side. Find a way to hack one side, play one player mode is what it's also called sometimes, but try to find a way to tap into existing channels that have one side of your marketplace already latent. And so again, you have countless businesses that if you've been built off of Craigslist, I think Thumbtack was partially one of them, and the idea was like, "Hey, we can find all those great pros on Thumbtack. When we have someone who wants a job, 'Oh, you want your kitchen remodeled?' We can, behind the scenes, go and post a job on Craigslist and then we'll bring on all the contractors who are browsing Craigslist looking for jobs, we'll bring them to our platform." That's an example of how that you worry about the core value proposition of can we get people to come back to the platform? Can we create this delightful exchange of value? Are people trusting us? Do we have the right checks in place to make sure that you are hiring the right person? What will make you come back? And once that's done, then you can focus around how do I build a flywheel on the supply side, and how do I manage and how do I make sure I have enough plumbers per market, or something like that.

**中文翻译:**
关于关注哪一侧，有不同的方法，但通常人们会选择“最难的一侧”。我以 Thumbtack 为例，因为我们要聊到它。Thumbtack 是一个家庭服务市场，帮助你找水管工、电工，而那里最难的一侧是需求侧（Demand）。供给侧是现成的，你可以翻黄页找到水管工，但最难的问题是：我们能否走出去找到那些想在家里做点什么、有项目需要完成的人？我们获取这些人、找到他们的核心增长策略是什么？我们能创造什么样的留存？我们能否创造一种愉悦的体验，让他们愿意回到我们的平台，让我们为他们打理家务？我的建议是：选择最难的那一侧。至于公司如何做到这一点，有很多方法，一个常见的建议是找到启动其中一侧的方法。找到“黑进”一侧的方法，有时也叫“单机模式”（One player mode），尝试找到一种方法切入已经潜伏着你市场一侧的现有渠道。同样，有无数企业是建立在 Craigslist 之上的，我想 Thumbtack 部分也是如此。当时的想法是：“嘿，我们可以在 Thumbtack 上找到所有这些优秀的专业人士。当有人想要服务时，比如‘你想装修厨房？’我们可以在后台去 Craigslist 发布一个工作，然后把那些正在浏览 Craigslist 找工作的承包商带到我们的平台上。”这就是一个例子，说明你应该担心核心价值主张：我们能让人们回到平台吗？我们能创造这种愉悦的价值交换吗？人们信任我们吗？我们是否有正确的检查机制来确保你雇佣了正确的人？什么会让你回来？一旦这些完成了，你就可以专注于如何在供给侧建立飞轮，以及如何管理并确保每个市场有足够的水管工等等。

---

### [00:11:53] Lenny Rachitsky

**English:**
When you say find the hard side, how do you find that? Any advice you can give founders and teams?

**中文翻译:**
当你提到“找到最难的一侧”时，该如何找到它？你能给创始人和团队一些建议吗？

---

### [00:11:58] Benjamin Lauzier

**English:**
In general, I would say intuitively the teams know, especially the teams are in the weeds, they know. They know, "Well, yeah, we can get X. But what we really struggle with is getting students to look at this." That's your sign. And I think sometimes it takes someone else to make you think about it, to reflect like, "Actually, yes, you're right. This side is obvious. We know how to get it, we just don't have the right supply for it and we don't know where to find the supply." Boom, that's the side that you should be focused on. Then you find a way to add source to demand, subsidize it, find some other way, and focus on this side that you have no idea how to grow. You should have a reliable growth strategy for the side.

**中文翻译:**
总的来说，我认为团队凭直觉就能知道，特别是那些深入一线的团队。他们知道：“嗯，是的，我们可以搞定 X。但我们真正挣扎的是让学生们关注这个。”这就是信号。我认为有时需要别人提醒你思考，让你反思：“事实上，是的，你是对的。这一侧很明显，我们知道怎么获取，但我们就是没有合适的供给，也不知道去哪里找供给。”砰，那就是你应该关注的一侧。然后你想办法外包需求、提供补贴或找其他方法，专注于那个你完全不知道如何增长的一侧。你应该为那一侧建立一个可靠的增长策略。

---

### [00:12:39] Lenny Rachitsky

**English:**
In my experience, it's almost always the supply side is what you need to work on, because once you have awesome supply, people are going to be really excited to tap it. Like Uber drivers, Airbnb homes, professionals on Thumbtack. Is that your experience too?

**中文翻译:**
根据我的经验，几乎总是供给侧（Supply side）是你需要努力的地方，因为一旦你有了极棒的供给，人们就会非常兴奋地去使用它。比如 Uber 司机、Airbnb 房源、Thumbtack 上的专业人士。你的经验也是这样吗？

---

### [00:12:54] Benjamin Lauzier

**English:**
Yes. I would say supply is the hardest side maybe like 80% to 90% of the time. Yeah, I totally agree. I was trying to think of counter examples, but I can't think of one. I just know that there are.

**中文翻译:**
是的。我会说供给侧在大约 80% 到 90% 的情况下是最难的一侧。是的，我完全同意。我试着想一些反例，但我想不出来。我只知道肯定存在反例。

---

### [00:13:05] Lenny Rachitsky

**English:**
There's one I know, which is Rover, based on research I did, because it turned out it was really easy to find people who want to walk dogs and watch dogs for 50 bucks an hour or whatever. It was a very easy value prop, and so they had a waitlist, they had just so many people. Also, TaskRabbit is the one I know about where they had so many people wanting to be taskers, whatever they call them-

**中文翻译:**
我知道一个，就是 Rover，根据我的研究，事实证明找到愿意以每小时 50 美元左右的价格遛狗或看狗的人非常容易。这是一个非常简单的价值主张，所以他们有候补名单，人多得是。另外，TaskRabbit 也是我知道的一个，那里有太多人想成为“Taskers”（任务执行者）。

---

### [00:13:24] Benjamin Lauzier

**English:**
I was going to mention TaskRabbit as well. I heard of that as well, yeah.

**中文翻译:**
我也正想提 TaskRabbit。我也听说过那个，是的。

---

### [00:13:27] Lenny Rachitsky

**English:**
Okay. And then you talked about there's a core part of figuring out how to grow that part, how to grow the hard part, generally the supply side. You shared a couple examples. Are there any more clever things you recall that you might be able to share of just ways people grew supply early on that could inspire people that are trying to figure this out right now?

**中文翻译:**
好的。然后你谈到了弄清楚如何增长那一侧的核心部分，即如何增长最难的部分，通常是供给侧。你分享了几个例子。你还记得有什么更聪明的做法可以分享吗？关于人们早期增长供给的方式，可以启发那些现在正在摸索的人？

---

### [00:13:46] Benjamin Lauzier

**English:**
Yeah, I think there's a couple of common tactics I would say pretty early on that I think companies rely on. So, we've talked about jump-starting one side of the marketplace with, it may be with Thumbtack and Lyft, also leverage job boards. You have also a lot of companies building value added services pretty early on as a core way of retaining supply pretty early on. Like let's build a really compelling basket of value for this supply, and this is going to be the thing that appeals everyone. So, OpenTable did this really well with all the restaurant services, other things that I've seen people use really well early on or converting your supply into demand or demand into supply pretty early on, so Lyft, we tried that. It actually didn't work at Lyft, but I know other marketplaces have been pretty successful with that.

**中文翻译:**
是的，我想有一些早期公司依赖的常见策略。我们谈到了启动市场的一侧，比如 Thumbtack 和 Lyft，还有利用招聘板块。还有很多公司在很早期就构建增值服务，作为留住供给的核心方式。比如“让我们为这些供给侧构建一个非常有吸引力的价值包”，这将是吸引所有人的东西。OpenTable 在餐厅服务方面做得非常好。我还见过人们在早期非常成功地将供给转化为需求，或将需求转化为供给。在 Lyft，我们尝试过这个，但在 Lyft 没奏效，但我知道其他双边市场在这方面非常成功。

---

### [00:14:44] Lenny Rachitsky

**English:**
Just to make sure people understand that one, it's a really interesting one is, in the Lyft example would be convincing drivers to become riders, convincing riders to become drivers, and mostly the latter, convincing riders to become drivers.

**中文翻译:**
为了确保大家理解这一点，这是一个非常有趣的策略。在 Lyft 的例子中，就是说服司机成为乘客，说服乘客成为司机，主要是后者——说服乘客成为司机。

---

### [00:14:55] Benjamin Lauzier

**English:**
Yeah, exactly. In our case at Lyft early on, we had a waitlist on the demand side because we just couldn't onboard enough supply. And so, we had this idea of having a pop-up. Instead of saying no drivers available, it would be like, "Hey, sorry, all the drivers are taken. People are making 50 bucks an hour right now, do you want to hop on your car and drive?" And we had some conversions, but it felt a little distracting to the overall experience and it wasn't a huge driver of supply. But I know that for Uber it actually was. I think they had a relatively meaningful amount of supply coming from [inaudible 01:15:27]

**中文翻译:**
是的，没错。在 Lyft 早期，我们在需求侧有候补名单，因为我们无法招募足够的供给。所以我们想到了一个弹窗的主意。与其说“没有可用的司机”，不如说：“嘿，抱歉，所有司机都被约满了。现在人们每小时能赚 50 美元，你想上车去开车吗？”我们确实有一些转化，但感觉对整体体验有点干扰，而且它并不是供给的主要驱动力。但我知道对 Uber 来说，这确实有效。我想他们有相当一部分供给来自[听不清]。

---

### [00:15:27] Lenny Rachitsky

**English:**
Wow, how does that make you feel that Uber figured out a better way to approach this and made it work? That doesn't feel-

**中文翻译:**
哇，Uber 找到了更好的方法并让它奏效了，这让你感觉如何？这感觉不太——

---

### [00:15:33] Benjamin Lauzier

**English:**
And it's a different audience. You would think that the Lyft passenger and driver is more likely to flip back and forth between the two. I don't know, I don't know. [inaudible 00:15:47]

**中文翻译:**
而且受众不同。你会认为 Lyft 的乘客和司机更有可能在两者之间切换。我不知道，我不知道。[听不清]

---

### [00:15:46] Lenny Rachitsky

**English:**
Yeah, a PM at Uber outdid you guys. Oh, no.

**中文翻译:**
是啊，Uber 的一个产品经理胜过了你们。噢，不。

---

### [00:15:50] Benjamin Lauzier

**English:**
Yes, on a couple of other things.

**中文翻译:**
是的，在其他几件事上也是。

---

### [00:15:52] Lenny Rachitsky

**English:**
Interesting.

**中文翻译:**
有趣。

---

### [00:15:52] Benjamin Lauzier

**English:**
And we outdid them on a few other things [inaudible 00:15:55]

**中文翻译:**
而我们在另外几件事上也胜过了他们[听不清]。

---

### [00:15:54] Lenny Rachitsky

**English:**
Okay, okay. That's right. So, essentially what we've been spending some time on here is just when you're starting a marketplace, figure out which side you need to drive, because that's what will unlock this opportunity. There's a hard thing that nobody's ever done before, and most of the time it's build a bunch of supply that nobody has done before, and there's all these tactics to do that. And all of this is, as you coming back to the main question I asked, we've gone on this awesome tangent, is pre-product market fit before you even know this is a thing. Spend time most of the time building supply to see if demand, customers actually want this thing. Right?

**中文翻译:**
好，好。没错。所以，本质上我们在这里讨论的是，当你启动一个双边市场时，要弄清楚你需要驱动哪一侧，因为那是开启机会的关键。有一件没人做过的难事，大多数时候就是建立一堆没人建立过的供给，有很多策略可以做到这一点。所有这些，回到我问的主题（我们刚才扯远了），都是在 PMF 之前，在你甚至不知道这是否可行之前。大部分时间花在建立供给上，看看需求侧、客户是否真的想要这个东西。对吧？

---

### [00:16:34] Benjamin Lauzier

**English:**
Exactly. And then I think there's a different set of challenges. The other pitfall that I see is, so pre-product market fit, people tend to be distracted by those marketplace dynamics like we talked about instead of doing what we just talked about. For companies that have some sort of scale and product market fit, to me the place where I see people getting tripped up most often is the concept of marketplace liquidity or how to match the health of a marketplace. To me, liquidity is how marketplaces win. It's this measure of your ability to match buyers and sellers efficiently, it's how quickly and efficiently people can find what they're looking for on your platform. So, you can picture a Venn diagram. One circle is this is what supply wants to sell, and another circle is this is what demand wants to buy, and your liquidity is the overlap between those two circles.

**中文翻译:**
没错。然后我认为会有另一套挑战。我看到的另一个陷阱是，在 PMF 之前，人们往往会被我们谈到的那些市场动态所分心，而不是去做我们刚才谈到的事。对于已经有一定规模和 PMF 的公司，我看到人们最常被绊倒的地方是“市场流动性”（Marketplace liquidity）的概念，或者如何衡量市场的健康状况。对我来说，流动性是双边市场获胜的关键。它是衡量你高效匹配买家和卖家的能力，是人们在你的平台上找到所需东西的速度和效率。你可以想象一个韦恩图（Venn diagram）：一个圆圈是供给侧想卖的东西，另一个圆圈是需求侧想买的东西，你的流动性就是这两个圆圈之间的交集。

---

### [00:17:26] Benjamin Lauzier

**English:**
So for, let's take the example of Lyft or Uber, because we talked about them. It might be for all the people who open the app with the intention to book a ride, how many of those actually turn into a ride? And this metric liquidity, it's a direct multiplier on the efficiency of your marketplace. It's literally at the center of your vision, it's why you exist as a marketplace is to connect the two. And it's also the ultimate engagement loop. The more supply you have, the more choice people have, the better the services, the more likely it is that it turns into a transaction and the more likely it is that they come back. And so, it's really this incredible circle. And what I see is people missing how critical this component is in the marketplace, struggle to define it for the business, and most importantly struggle to build an actionable playbook against it. Like, "Okay, how do I manage this? Okay, it's important, but what do I do about it?" Basically.

**中文翻译:**
以 Lyft 或 Uber 为例。流动性可能是指：在所有带着叫车意图打开 App 的人中，有多少人最终真的打到了车？流动性这个指标是你市场效率的直接乘数。它确实是你愿景的核心，你作为一个市场存在的原因就是连接两者。它也是终极的参与循环（Engagement loop）：供给越多，人们的选择就越多，服务越好，就越有可能转化为交易，他们也就越有可能再次光顾。所以，这真的是一个不可思议的圆环。我看到的是人们忽略了这一组成部分在市场中的关键性，难以在业务中定义它，最重要的是，难以围绕它构建一套可执行的方案（Playbook）。基本上就是：“好吧，我该如何管理这个？我知道它很重要，但我该怎么办？”

---

### [00:18:21] Lenny Rachitsky

**English:**
Is there a metric you recommend people specifically look at to understand liquidity?

**中文翻译:**
有没有什么指标是你特别推荐人们用来理解流动性的？

---

### [00:18:26] Benjamin Lauzier

**English:**
I think the metric that I like the most is a predictor of liquidity. So your liquidity might be, it's typically a measure of demand utilization. It might be looking for something on there, maybe how many of those searches with intent actually turn into a transaction. So, it's your field rate of your intentful demand typically, and that's really indicative of the net output of your marketplace. And so, that gives you a sense of the health of your marketplace, but it can be influenced by a whole bunch of different factors. So, if you think about for Thumbtack, it can be influenced by if there's a snowstorm out there, if the competition is bidding, there's a whole bunch of exogenous factors that come into play. And the metric that I think is slightly more actionable is a little harder to define, but so much more helpful in my opinion.

**中文翻译:**
我认为我最喜欢的指标是流动性的“预测指标”。你的流动性通常是衡量需求利用率的指标。它可能是看平台上的搜索，有多少带有意图的搜索最终转化为了交易。所以，它通常是你“有意图的需求”的填充率（Fill rate），这确实能反映你市场的净产出。这能让你感知市场的健康状况，但它会受到一大堆不同因素的影响。比如在 Thumbtack，它可能受到外面是否有暴风雪、竞争对手是否在竞价等一系列外部因素的影响。我认为稍微更具可操作性的指标虽然更难定义，但在我看来更有帮助。

---

### [00:19:19] Benjamin Lauzier

**English:**
It's what I call a market health metric, and this is basically think of your proxy that is the best predictor of your liquidity. So, I'll use the example of Lyft. You have your liquidity is your demand utilization, it's how many app opens turn into a ride, and what predicts this? What will predict you and deciding to book a ride? For Lyft and for Uber, it was ETAs. So, we knew that if the closest driver was at least two minutes away from you or closer, then we had hit a ceiling, you were more than X person likely to convert and book a ride. If it's more than two minutes, if it's five, then maybe you check at Uber, maybe you walk, maybe you take the bus. If it's two minutes, it doesn't make a big enough difference, you're just going to book the ride anyway. So find this threshold, find this predictor that tends to plateau that correlates strongly with retention but with also the transaction happening, and that's the metric that you can predict. That's a metric that's so much more actionable for teams to work against. If you're a supply team now you can think of, "Okay, I'm adding 100 supplies into the platform. I want to know if it's actually reducing ETAs in this case," or I can look at correlations like this and limiting some of the effect of those exhaustive factors that I mentioned.

**中文翻译:**
这就是我所说的“市场健康指标”，基本上就是寻找能最好预测流动性的代理指标（Proxy）。我再用 Lyft 举例。你的流动性是需求利用率，即多少次 App 打开转化为了行程，那么什么能预测这一点？什么能预测你决定叫车？对于 Lyft 和 Uber 来说，就是 ETA（预计到达时间）。我们知道，如果最近的司机距离你两分钟或更短，我们就达到了一个上限，你转化并叫车的可能性会超过 X%。如果超过两分钟，比如五分钟，那你可能会去查 Uber，或者走路，或者坐公交。如果是两分钟，差别没那么大，你无论如何都会叫车。所以，找到这个阈值，找到这个趋于平稳且与留存及交易发生强相关的预测指标，这就是你可以预测的指标。对于团队来说，这是一个更具可操作性的指标。如果你是供给团队，现在你可以想：“好吧，我向平台增加了 100 个供给，我想知道这是否真的降低了这种情况下的 ETA。”或者我可以观察这类相关性，并限制我提到的那些外部因素的影响。

---

### [00:20:38] Lenny Rachitsky

**English:**
Awesome. So, essentially watch fill rate is the term used that a lot of people love, which is just people with intent converting. So, the Airbnb example is exactly the way we did Airbnb is we looked at people that are searching with dates as intentful users, and then how many of them convert to a booking. So, that's basically what you're trying to get to, and your point here is that's kind of the output metric. That's what you want to move, but in order to move it, there's something that is the biggest lever to moving fill rate. And in your experience, and I've seen this exact same thing, it's usually amount of supply. Do you have enough good supply? And so, in the case of Lyft is do you have enough cars? Do you have enough homes, do you have enough plumbers on Thumbtack? And that's usually where you can actually impact fill rate. Sweet.

**中文翻译:**
太棒了。所以，本质上关注“填充率”（Fill rate）是很多人喜欢的术语，即有意图的人发生了转化。Airbnb 的例子正是我们做 Airbnb 的方式：我们将带日期搜索的人视为有意图的用户，然后看其中有多少人转化为了预订。所以，这基本上就是你想要达到的目标。你的观点是，这是一种“产出指标”（Output metric）。这是你想移动的指标，但为了移动它，存在一个移动填充率的最大杠杆。根据你的经验（我也见过完全相同的情况），这通常是供给的数量。你是否有足够的优质供给？在 Lyft 的案例中，是你是否有足够的车？是否有足够的房子？在 Thumbtack 上是否有足够的水管工？这通常是你真正能影响填充率的地方。漂亮。

---

### [00:21:25] Benjamin Lauzier

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:21:34] Lenny Rachitsky

**English:**
And that becomes the goal of the team, that becomes the focus of the company, basically drive that up in all the little markets you're in and all the categories you're in.

**中文翻译:**
这成了团队的目标，成了公司的焦点，基本上就是在你所在的所有细分市场和所有类别中提升这个指标。

---

### [00:21:34] Benjamin Lauzier

**English:**
Exactly. Yeah, completely.

**中文翻译:**
没错。是的，完全正确。

---

### [00:21:36] Lenny Rachitsky

**English:**
Awesome. You mentioned this idea of product market fit and the things change, pre-product market fit, post-product market fit. Classic question, I'm curious if you have any insights here, just what tells you that you've climbed that hill of product market fit, that you might have product market fit, or you definitely have product market fit in a marketplace?

**中文翻译:**
太棒了。你提到了 PMF 这个概念，以及在 PMF 之前和之后事情会如何变化。经典问题，我很好奇你在这里是否有见解：什么迹象告诉你已经爬过了 PMF 的那座山？在双边市场中，什么迹象表明你可能拥有 PMF，或者肯定拥有 PMF？

---

### [00:21:55] Benjamin Lauzier

**English:**
It's hard because to me, the two are most independent. Maybe this is a hot take, but I feel like product market fit is independent of your marketplace dynamics. You might have a great product, and it provides amazing value to both sides, but you have yet to crack the flywheel on the supply side for how to bring those people. You don't have the right product channel fit, for example. And so, this will have a massive impact on the dynamics of your marketplace. And so, to me, my answer would tend to be pretty classical, it would be like measure your product market fit the way you would for a normal company. So yeah, it's a bit of an art more than the science, but I like the classic if we were to take this product away, what percentage of users would be significantly disappointed or have no other solution?

**中文翻译:**
这很难，因为对我来说，这两者在很大程度上是独立的。也许这是一个大胆的观点，但我觉得 PMF 与你的市场动态是相互独立的。你可能有一个伟大的产品，它为双方都提供了惊人的价值，但你还没有破解供给侧如何吸引这些人的飞轮。例如，你还没有找到合适的产品渠道匹配（Product channel fit）。这将对你的市场动态产生巨大影响。所以对我来说，我的回答倾向于比较经典：像衡量普通公司那样衡量你的 PMF。所以，这更多是一门艺术而非科学，但我喜欢那个经典的测试：如果我们拿走这个产品，百分之多少的用户会感到非常失望，或者没有其他替代方案？

---

### [00:22:50] Benjamin Lauzier

**English:**
So, questions like this I think go to the heart of how valuable is your solution to users, and you can do this on the supply side and the demand side. I think here my advice is typically to consider that you have two product market fits essentially. You want to make sure that you have a compelling enough value proposition on both sides of the marketplace, and very often at the beginning you find product market fit on the demand side, but you realize it's not compelling enough for your suppliers because your margins are too high or something like that. So, realizing that you have both those things, but I think you can measure them in a way that's relatively traditional, and that's independent of marketplace dynamics.

**中文翻译:**
我认为这类问题触及了你的解决方案对用户价值的核心，你可以在供给侧和需求侧都做这个测试。在这里，我的建议通常是：本质上你要考虑你有“两个”PMF。你要确保在市场的两侧都有足够引人注目的价值主张。通常在开始时，你在需求侧找到了 PMF，但你意识到它对供应商不够有吸引力，可能是因为你的抽成太高之类的。所以，要意识到你同时拥有这两样东西，但我认为你可以用相对传统的方式来衡量它们，这与市场动态是独立的。

---

### [00:23:27] Lenny Rachitsky

**English:**
I love that. We actually just had Sean Ellis on the podcast talking about that exact survey, the Sean Ellis test of asking people how disappointed would you be if they left, if the product didn't exist. And I just love that you keep coming back to this point that I 100% agree with, that most of the challenges you have with a marketplace business, 90% are the same challenges you'll have with a non-marketplace business. And people over-focus on, "Oh, I need to think of this like a marketplace, and all the marketplace science behind all this stuff." And really it's all the same stuff every founder is dealing with product market fit, except you have two sides of it growth strategy, but you have two sides of it. So, I love that you keep going back to that.

**中文翻译:**
我喜欢这个观点。我们最近刚请 Sean Ellis 上过播客，谈论的正是那个调查，即 Sean Ellis 测试——询问人们如果产品不存在了，他们会有多失望。我非常喜欢你不断回到这一点，我 100% 同意：你在双边市场业务中遇到的大多数挑战，90% 与非市场业务的挑战是一样的。人们过度关注“噢，我需要像对待市场一样思考，研究背后的所有市场科学”。实际上，这都是每个创始人都要处理的事情，比如 PMF，只不过你有两个侧面；比如增长策略，只不过你有两个侧面。所以我很喜欢你一直强调这一点。

---

### [00:24:10] Lenny Rachitsky

**English:**
Something that I definitely want to touch on is when people are thinking about starting a marketplace company, what are signals that a marketplace is a good model for the idea? Because I think a lot of people come into and be like, "I want to build a marketplace. Oh, I'm going to connect these two sides. It's going to be great," and there's no marketplace in this business, in this vertical. What are signs that marketplace dynamic and a business model is right for an idea versus no, it's not?

**中文翻译:**
我非常想探讨的一点是，当人们考虑创办一家双边市场公司时，有哪些信号表明“双边市场”是该想法的一个好模型？因为我觉得很多人进场时会想：“我想建一个市场。噢，我要连接这两端，这会很棒。”但在这个业务或垂直领域里其实并没有市场的空间。有哪些迹象表明市场动态和这种商业模式适合某个想法，而哪些迹象表明不适合？

---

### [00:24:40] Benjamin Lauzier

**English:**
No one ever say like, "Oh, I'm going to build Airbnb for X," it's not something that people say. I think the signs that come to mind are one, higher fragmentation. I think you want this long tail of buyers and sellers without a handful of big players controlling the market, because this is where you can provide value by doing this job of aggregation. I think you also want a relatively uniform set of needs. That means that it can be, like your supply can be commoditized to some extent. This is what's so tricky, by the way, about services, service marketplaces like Thumbtack, because unlike eBay, where sellers, they just want to sell very clear and distinct inventory, on Thumbtack you have electricians who only want certain types of jobs, but they only want it if they're available that day. And they might take a job and cancel it because something better comes up.

**中文翻译:**
现在没人会再说“噢，我要为 X 领域做一个 Airbnb”了，这不是人们会说的话。我想到的迹象首先是：高度碎片化（Fragmentation）。你希望拥有长尾的买家和卖家，而不是由少数几个大玩家控制市场，因为这样你才能通过聚合工作提供价值。其次，你还需要相对统一的需求。这意味着你的供给在某种程度上可以被“商品化”（Commoditized）。顺便说一下，这就是服务类市场（如 Thumbtack）如此棘手的原因。因为不像 eBay，卖家只想卖非常清晰、独特的库存；在 Thumbtack 上，电工只想接特定类型的工作，而且只有在他们那天有空时才接。他们可能会接下一个活，然后因为出现了更好的活而取消。

---

### [00:25:34] Benjamin Lauzier

**English:**
And so, this makes for a very fuzzy definition of supply, and you have very different set of needs. One electrician wants something, the other one has a very different perception of the same unit of demand, and that makes it very, very difficult. So, it's feasible, but I would say that is not a compelling attribute for building a marketplace. So, a relatively uniform set of needs. And the last one I'd mention is a high enough bearer in the matchmaking or the creation. I think how hard it is for people to find each other today, and how much effort do they have to put in to vet each other, I think is another great sign. The higher it is, the bigger the opportunity because it means you come in, implement the right processes to simplify this exchange of value.

**中文翻译:**
因此，这导致供给的定义非常模糊，而且需求也各不相同。一个电工想要某种活，另一个电工对同一单位需求的看法可能完全不同，这使得事情变得非常非常困难。所以，虽然可行，但我会说这并不是构建双边市场的一个吸引人的属性。所以，需要相对统一的需求。最后一点是，在撮合（Matchmaking）或创建过程中存在足够高的障碍。我认为，目前人们找到彼此有多难，以及他们需要花多少精力去审查彼此，是另一个重要的迹象。障碍越高，机会越大，因为这意味着你可以介入，实施正确的流程来简化这种价值交换。

---

### [00:26:24] Lenny Rachitsky

**English:**
Awesome. I'd love to know if there's any examples you can think of, of bad marketplace ideas that people have tried, but I'll summarize the three points you just made, which I love. So, these are signs that this is a great opportunity for marketplace business, that there's a lot of fragmentation on both sides. There's not just a small number of companies or customers on one side or the other, because if there are, why do they need you? There's five airlines or whatever, you don't need a marketplace to match with an airline. Then two is there's uniform needs, the needs are basically consistent. I just want to stay in a home, I want a car to take me somewhere, I want a plumber. And then there's a barrier, there's complexity to the matchmaking and helping someone book the thing, work with them. Finding a car, I imagine is like, I'm not going to just flag down a car. There's challenge there. I'm not going to just go and ask someone, "Can I stay in your home?" There's challenges there.

**中文翻译:**
太棒了。我想知道你是否能想到一些人们尝试过的糟糕的市场想法，但我先总结一下你刚才提到的三点，我非常喜欢。这些是双边市场业务大好机会的迹象：1. 两侧都有大量的碎片化。不仅仅是某一侧只有少数几家公司或客户，因为如果是那样，他们为什么需要你？比如只有五家航空公司，你不需要一个市场来匹配航空公司。2. 统一的需求，需求基本上是一致的。我只想住进一个家，我想要一辆车带我去某个地方，我想要一个水管工。3. 存在障碍，撮合和帮助某人预订、合作的过程具有复杂性。找一辆车，我想象中不是随手招一辆那么简单，这其中有挑战。我也不会直接去问某人：“我能住在你家吗？”这其中也有挑战。

---

### [00:27:19] Benjamin Lauzier

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:27:20] Lenny Rachitsky

**English:**
Awesome. Are there any examples of companies you've seen that are just like, that will never work as a marketplace, or here's a funny example of a marketplace that tried to be a marketplace and it's not ...

**中文翻译:**
太棒了。有没有你见过的公司例子，让你觉得“这永远不可能作为双边市场运作”，或者有没有一个有趣的例子，某个市场试图成为市场但失败了……

---

### [00:27:29] Benjamin Lauzier

**English:**
I don't have a great example of that, but I can give you a tangentially related example of a marketplace that I don't want to throw anyone under the bus. I respect the company and the effort, but Sidecar at the time was another ride-sharing company competing with Lyft and Uber, and there's, I'm sure a whole bunch of lessons there. They ended up closing, but I think one really interesting direction that they took pretty early on to differentiate themselves was, in my mind perhaps very naively a mistake, they decided to give complete control to the user where as a user you had a whole bunch of filters. You could decide, "I want a car that's at least 2015 or newer. I want a driver that's at least this or newer." And so, I think the theory was reasonable on paper. It was like, "Hey, let's give people more control over it."

**中文翻译:**
我没有特别典型的例子，但我可以给你一个间接相关的例子。我不想公开指责任何人，我尊重那家公司和他们的努力，但当时的 Sidecar 是另一家与 Lyft 和 Uber 竞争的网约车公司，我相信那里有很多教训。他们最终倒闭了，但我认为他们早期为了差异化而采取的一个非常有趣的方向（在我看来也许是非常天真的错误）是：他们决定给用户完全的控制权。作为用户，你有一大堆过滤器，你可以决定：“我想要一辆 2015 年或更新的车。我想要一个至少达到某某级别的司机。”我认为这个理论在纸面上是合理的，就像是：“嘿，让我们给人们更多的控制权。”

---

### [00:28:29] Benjamin Lauzier

**English:**
But you have those other players out there, you have Lyft and Uber, and people feel forced in this standardized experience, "We're going to compete by giving you the choice, you get to decide the experience that you want." I think in reality, it just fragments your marketplace even further, and you have this hyper fragmentation in your marketplace, and I think it hurt their SLAs quite drastically. If you think about the ETA, when you ask explicitly you're like, "Yeah, sure, I want a newer car," and you slide it to 2020 not realizing that you just lost 10 minutes because now we had a great driver, but they have a Honda Civic from 2018, and it's not the special that you wanted. So, I think people who build marketplaces tend to want to give a lot of control to the users because this is what users want, or this is what comes up oftentimes in user feedback like, "Oh, we have those two distinct group of users. Those ones, they really want new cars. Those ones, they don't want new cars." And so, naturally you have a product team that builds the toggle to get the new cars, and I think the mistake is that you unknowingly fragment your supply in a way that has a much more meaningful impact on the health of your marketplace than you suspect.

**中文翻译:**
但外面还有其他玩家，比如 Lyft 和 Uber，人们在那种标准化的体验中感到被动。Sidecar 想：“我们要通过给你选择权来竞争，你可以决定你想要的体验。”我认为在现实中，这只会让你的市场进一步碎片化，导致市场出现“过度碎片化”，这严重损害了他们的 SLA（服务等级协议）。想想 ETA，当你明确要求“是的，当然，我想要一辆更新的车”并把滑块拉到 2020 年时，你没有意识到你刚刚损失了 10 分钟，因为原本我们有一个很棒的司机，但他开的是 2018 年的本田思域，不是你想要的那种特别款。所以，我认为构建市场的人往往想给用户很多控制权，因为这是用户想要的，或者这是用户反馈中经常出现的，比如：“噢，我们有两组截然不同的用户。这一组非常想要新车，那一组不在乎。”于是，产品团队自然而然地做了一个开关来筛选新车。我认为错误在于，你不知不觉地碎片化了你的供给，这种方式对市场健康的影响比你想象的要深远得多。

---

### [00:29:43] Lenny Rachitsky

**English:**
I think this is another awesome example of don't over listen to users and do what you think is going to be best for the business, and this is not even a marketplace lesson. It's just generally you don't want to give users more options than they will need to be successful and happy. And I think Sidecar did that because they were trying to differentiate from Lyft and Uber, like, "What can we do differently?" And they're like, "Oh, let's give people all these options." I think they even let drivers choose the price that they're offering their ride at, which made it extra complicated. They're like, "Oh my God, all these cars at different prices," but I respect their attempt because they were just the third wheel, no pun intended.

**中文翻译:**
我认为这是另一个极好的例子，说明不要过度听从用户，而要去做你认为对业务最有利的事情。这甚至不只是双边市场的教训，通常来说，你不想给用户提供超过他们获得成功和快乐所需的选项。我想 Sidecar 这样做是因为他们试图从 Lyft 和 Uber 中脱颖而出，心想：“我们能做点什么不一样的？”然后他们觉得：“噢，让我们给人们所有这些选项吧。”我记得他们甚至让司机自己定价，这让事情变得格外复杂。用户会觉得：“天哪，这么多车价格都不一样。”但我尊重他们的尝试，因为他们当时只是“第三者”（Third wheel，这里是个双关语，意指第三个轮子/多余的人）。

---

### [00:30:21] Benjamin Lauzier

**English:**
Ironically, it's almost the opposite advice that I usually give to companies who struggle with market health, it's if you have different verticals, try if possible to open up your supply walls. Your user is telling you like X, but try to give them something that is tangential to what you think they want, because odds are that they are actually fine with it. There's this amazing example from Thumbtack, it's the smoke machine example. So Thumbtack, now they specialize a little bit more in home services, but a few years ago they were also doing a lot of events. So, you had DJs, you had photographers, and a lot of people were hiring for wedding DJs on the platform. And one of the checkboxes was a smoke machine, and it turns out a lot of people are checking this. You're like, "Yeah, hell yeah, I want a smoke machine at my wedding."

**中文翻译:**
讽刺的是，这几乎与我通常给那些在市场健康方面挣扎的公司的建议相反。我的建议是：如果你有不同的垂直领域，尽可能尝试打破供给的围墙。你的用户告诉你想要 X，但试着给他们一些与你认为他们想要的相切的东西，因为很有可能他们其实觉得那样也行。Thumbtack 有一个很棒的例子，就是“烟雾机”的例子。Thumbtack 现在更专注于家庭服务，但几年前他们也做很多活动服务。所以你有 DJ、摄影师，很多人在平台上雇佣婚礼 DJ。其中一个复选框是“烟雾机”，结果发现很多人都勾选了这个。你会想：“是的，太棒了，我想要婚礼上有烟雾机。”

---

### [00:31:14] Benjamin Lauzier

**English:**
And unknowingly to them, obviously, only 5% of our DJs had a smoke machine, and so you would carve out 95% of our supply. And if when we talked to users, they were like, "Oh, no, no, I don't care that much about the smoke machine. I didn't realize that this was automatically going to remove half of the supply." And so, work on ways to make this checkbox affect the ranking but not the actual filtering is a great example of how you can listen to your users and tweak the experience, but simplify their cognitive load by knowing like, "Hey, we know you prefer a smoke machine, but we're intelligent enough to know it's probably not a deal breaker for you."

**中文翻译:**
但用户显然不知道，我们只有 5% 的 DJ 有烟雾机，所以你这一勾选就排除了 95% 的供给。当我们与用户交谈时，他们会说：“噢，不，不，我没那么在乎烟雾机。我没意识到这会自动移除一半以上的供给。”因此，想办法让这个复选框影响排名（Ranking）而不是实际的过滤（Filtering），这是一个很好的例子，说明你既可以听取用户的意见并调整体验，又可以通过了解“嘿，我们知道你更喜欢烟雾机，但我们足够聪明，知道这可能不是你的‘一票否决项’（Deal breaker）”来简化他们的认知负荷。

---

### [00:31:54] Lenny Rachitsky

**English:**
I love that example. The other thing that I think is important to talk about briefly is when you're thinking about building a marketplace, a lot of times they fail because the business model just doesn't work. I think about a company like Cherry that tried to do Uber for car washes, and in theory there's a smart idea of I'm going to just do on-demand car wash. The problem is no one's going to pay what it costs to do that, to a car wash person shows up and washes your car. I think cleaning is another example. There's also just like going-

**中文翻译:**
我喜欢那个例子。我认为另一件重要且需要简短讨论的事是，当你考虑构建一个双边市场时，很多时候它们失败是因为商业模式根本行不通。我想起了一家叫 Cherry 的公司，他们试图做“洗车界的 Uber”，理论上这是一个聪明的想法——我要做按需洗车。问题是，没有人愿意支付让洗车工上门为你洗车的实际成本。我想家政清洁是另一个例子。还有像……

---

### [00:32:26] Benjamin Lauzier

**English:**
Exec is another one that comes to mind.

**中文翻译:**
我想到了 Exec。

---

### [00:32:27] Lenny Rachitsky

**English:**
Oh Exec, yeah, where it's just like someone come does stuff for you.

**中文翻译:**
噢 Exec，是的，就是那种让人来帮你办事的服务。

---

### [00:32:32] Benjamin Lauzier

**English:**
Something, yeah.

**中文翻译:**
是的，类似那样的。

---

### [00:32:32] Lenny Rachitsky

**English:**
Yeah. And so I guess, is there anything you want to add there? Just like this is another reason your marketplace might fail? And maybe just let me expand on this question. Just what are the most common reasons marketplaces fail in your experience? And I think it's important to say most marketplace ideas fail, just like most startup ideas fail.

**中文翻译:**
是的。所以我想，关于这一点你有什么想补充的吗？这是否是市场可能失败的另一个原因？也许让我扩展一下这个问题：根据你的经验，双边市场失败最常见的原因是什么？我认为有必要说明，大多数双边市场的想法都会失败，就像大多数创业想法都会失败一样。

---

### [00:32:49] Benjamin Lauzier

**English:**
Yeah, most ideas period fail, I think. Yes.

**中文翻译:**
是的，我认为大多数想法最终都会失败。是的。

---

### [00:32:51] Lenny Rachitsky

**English:**
Most ideas period fail, same. Coming back to most of the things you're going to struggle with are the same things that every company struggles with outside of marketplace. So, let me just ask, is maybe specifically within marketplaces or even just broadly, what are the biggest reasons that marketplaces fail?

**中文翻译:**
大多数想法都会失败，同感。回到刚才说的，你将面临的大多数挣扎与市场之外的每家公司所面临的挣扎是一样的。那么，让我问一下，也许是专门针对双边市场，或者更广泛地说，市场失败的最大原因是什么？

---

### [00:33:06] Benjamin Lauzier

**English:**
I think a few things come to mind. One is this concept of liquidity that we've talked about. So, you need to kick off this flywheel, you need to build enough of that density within your marketplace. And depending on the business, you can take a lot of time or money, and without the right diagnostic framework you can end up running out of both. And so it's like, that's the same one, and I felt this at Lyft, I've seen this at other companies, this rush like, "Wow, we have to get to this point, otherwise we know it's a losing battle until we have enough density for both sides to have a good enough experience." The other one that I see is ignoring one side. So, we talked about doing that when you're early on, but I see a lot of larger companies operating for too long as one-sided businesses. Many large marketplaces only thinking about their demand side funnel.

**中文翻译:**
我想到了几点。第一是我们谈过的流动性概念。你需要启动这个飞轮，你需要在市场内建立足够的密度。根据业务的不同，这可能需要大量的时间或金钱，如果没有正确的诊断框架，你最终可能会耗尽这两者。这就像我在 Lyft 感受到的，在其他公司也见过的，那种紧迫感：“哇，我们必须达到这个点，否则我们知道这是一场注定失败的战斗，直到我们有足够的密度让双方都有足够好的体验。”我看到的另一个原因是忽视了其中一侧。我们谈过在早期可以这样做，但我看到很多大公司作为单边业务运营了太长时间。许多大型双边市场只考虑他们的需求侧漏斗。

---

### [00:34:01] Benjamin Lauzier

**English:**
So they run ads, they get clicks, they turn those clicks into dollars, and they try to get enough supplies that intuitively the experience is good enough for users. And my advice is, if you're doing this you're missing out on half of your business. And the trick is marketplaces are very laggy, so once your network effects start to die down it turns into this moment of panic of, "Oh shoot, we forgot about half of our users. We forgot that sellers are people too, and they're all leaving, and now we need to completely transform our product to save the ship, and to create a compelling value proposition on their side." So, that's the other thing that I see is businesses realizing that they are marketplaces with true marketplace needs too late in the game. And the last one is quality. I think we talked a little bit about the quality before, but it doesn't mean that you always need to have the best quality in your marketplace, but being a marketplace implies a level of curation.

**中文翻译:**
所以他们投放广告，获取点击，将点击转化为收入，并试图获得足够的供给，使直觉上用户的体验足够好。我的建议是，如果你这样做，你就错失了一半的业务。诀窍在于双边市场是非常滞后的，所以一旦你的网络效应开始消退，就会陷入恐慌时刻：“噢该死，我们忘了一半的用户。我们忘了卖家也是人，他们都在离开，现在我们需要彻底改造我们的产品来拯救这艘船，并在他们那一侧创造一个引人注目的价值主张。”所以，这是我看到的另一件事：企业意识到自己是具有真正市场需求的双边市场时已经太晚了。最后一点是质量。我想我们之前谈过一点质量，但这并不意味着你的市场总是需要最好的质量，但作为一个市场，意味着一定程度的“策展”（Curation）。

---

### [00:34:58] Benjamin Lauzier

**English:**
You need to be intentional about the quality that you aim to provide, and I think a lot of companies don't have necessarily that intentionality and you have this constant push of supply, "If only we'd lower our bar a little bit, we could get more supply." And so until you end up, we've all experienced this at some point, you found some e-commerce website, you look for something and there is also like, "Oh my god, this looks super shady," because all the sellers don't look that great. That's a quality problem. And so, you need to be intentional about your quality and I think that's another area where companies fail.

**中文翻译:**
你需要对你旨在提供的质量有意识。我认为很多公司不一定有这种意识，你会不断面临增加供给的压力：“要是我们稍微降低一点门槛，我们就能获得更多供给。”直到最后（我们都经历过），你发现某个电商网站，你搜寻某样东西，结果发现：“天哪，这看起来超级不靠谱”，因为所有的卖家看起来都不怎么样。这就是质量问题。所以，你需要对质量有意识，我认为这是公司失败的另一个领域。

---

### [00:35:31] Lenny Rachitsky (Ad Segment - Vanta)

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast... [Ad content omitted for brevity] ...Get $1,000 off Vanta when you go to vanta.com/lenny. That's V-A-N-T-A dot com slash Lenny.

**中文翻译:**
本期节目由 Vanta 赞助。当涉及到确保您的公司拥有顶级的安全实践时，事情会迅速变得复杂……（广告内容略）……访问 vanta.com/lenny 即可享受 Vanta 1,000 美元的优惠。

---

### [00:36:23] Lenny Rachitsky

**English:**
Kind of as a segue from that idea of quality, I want to talk about managed marketplaces, managed supply. So, I think the reason quality is such an issue for marketplaces is because you do not own the supply and control the supply your marketplace, you're not just selling something, quality is innately going to be a challenge. Airbnb doesn't own homes, Uber doesn't employee drivers. They can't even legally tell them exactly what to do because their contractors, so quality is always this ongoing challenge with marketplaces. So, there's always this push towards making it more of a managed marketplace. We give people a lot more instruction, maybe they own some of the supply, maybe they invest a lot in training, all that kind of stuff. And in a perfect world, not unlike an idealized world, quality will be best if you own it. But then you're no longer marketplace, your business model sucks. I guess just any thoughts on marketplaces that are considering becoming more managed? Any advice on when it makes sense to move towards that spectrum, and how far to go?

**中文翻译:**
作为质量话题的延续，我想谈谈托管型市场（Managed marketplaces）和托管型供给。我认为质量之所以成为双边市场的一个大问题，是因为你不拥有供给，也不控制市场中的供给，你不仅仅是在卖东西，质量天生就是一个挑战。Airbnb 不拥有房子，Uber 不雇佣司机。法律上他们甚至不能告诉司机具体该怎么做，因为他们是独立承包商，所以质量一直是双边市场面临的持续挑战。因此，总有一种力量推动其向托管型市场转变：我们给人们更多的指导，也许拥有部分供给，也许在培训上投入大量资金等等。在一个理想化的世界里，如果你拥有供给，质量会是最好的。但那样你就不再是双边市场了，你的商业模式会变得很糟。我想请教一下，对于那些考虑变得更具“托管性”的市场，你有什么看法？关于何时转向那个光谱，以及走多远，你有什么建议吗？

---

### [00:37:27] Benjamin Lauzier

**English:**
I think when you're running a marketplace, you tend to sit in your ivory tower a little bit looking at stats and thinking, "If only we could get people to do X, it'd be better for everyone." And I certainly did that in my career. I think that's missing the point that we're humans, and I think sometimes we act in ways that are non-deterministic or intuitive. I'll mention another example, but we'd originally sell leads to pros like plumbers and electricians. And of those leads, obviously only a fraction would turn into actual jobs and revenue for those pros. So, we also saw that those pros were always great at converting leads into jobs. And so, naturally we thought that we could provide a more consistent experience for customers and for pros by improving their ROI and selling bookings directly to those pros. It's a common marketplace move, going from some version of lead to a direct booking.

**中文翻译:**
我认为当你经营一个双边市场时，你往往会坐在象牙塔里盯着统计数据想：“要是我们能让人们去做 X，对大家都会更好。”在我的职业生涯中，我也确实这么做过。我认为这忽略了我们是人类这一点，有时我们的行为是非确定性的或直觉性的。我再举一个例子：我们最初向水管工和电工等专业人士出售“销售线索”（Leads）。在这些线索中，显然只有一小部分会转化为实际的工作和收入。我们还看到，这些专业人士并不总是擅长将线索转化为工作。所以，我们自然而然地认为，我们可以通过提高他们的投资回报率（ROI）并直接向这些专业人士出售“预订”（Bookings），从而为客户和专业人士提供更一致的体验。这是双边市场常见的举动：从某种形式的线索转向直接预订。

---

### [00:38:22] Benjamin Lauzier

**English:**
And digital, great. We knew we were going to improve their ROI by something like 20% maybe, and we launched this and pros hated it. They hated it because they actually subconsciously, they liked the thrill of the sale. They loved this contact with customer, and they sometimes completely overestimated their ability to close the customer. They were like, "You took all those phone calls, they kept me busy. I felt like I was hustling, I was about to close this customer." And so, no matter what the data says of like, "Oh, we increased their earnings by 20%," the pros don't feel this way and it's the right to feel however they want. And we saw the same thing at Lyft when trying to make driver earnings less volatile, we had to fight a lot of that perception and a lot of that peak end effect. So, my call-out here is any attempt at control can be really tricky and backfire in ways that are unpredictable.

**中文翻译:**
数字化，太棒了。我们知道我们可能会将他们的 ROI 提高 20% 左右，我们推出了这个功能，结果专业人士讨厌它。他们讨厌它是因为在潜意识里，他们喜欢销售带来的快感。他们喜欢与客户接触，有时他们完全高估了自己成交客户的能力。他们会觉得：“你拿走了所有那些电话，那些电话让我很忙。我觉得自己在拼搏，我快要成交这个客户了。”所以，无论数据怎么说“噢，我们将他们的收入提高了 20%”，专业人士并不这么觉得，他们有权产生任何感觉。我们在 Lyft 尝试让司机的收入波动变小时也看到了同样的情况，我们不得不应对大量的这种认知和“峰终定律”（Peak-end effect）的影响。所以，我在这里的提醒是：任何控制的尝试都可能非常棘手，并以不可预测的方式产生反作用。

---

### [00:39:12] Benjamin Lauzier

**English:**
You also touched on employment classification. In the U.S., when you talk about controlling supply, all the lawyers are like, "No, no, no, that's not something that we do." Because if you control your supply, then there can be legally classified as employees and be entitled to a whole bunch of benefits. So, my take on this in general is I'm a huge believer, and it really depends on the type of company I should say, obviously, but my take is I'm a huge believer in market forces and empowerment. So, provide guardrails for what a good experience is in your marketplace, set a clear bar for quality, and provide the right coaching and tools for supply to be successful. And then take a step back and see where the gaps are, and invest more in hands-on tactics just to close those gaps more specifically.

**中文翻译:**
你也提到了雇佣分类（Employment classification）。在美国，当你谈论控制供给时，所有的律师都会说：“不，不，不，这不是我们该做的事。”因为如果你控制了供给，那么他们在法律上就可能被归类为员工，并有权享受一大堆福利。所以，总的来说，我的看法是（当然这取决于公司的类型），我非常相信市场力量和赋能。因此，为市场中的良好体验提供护栏，设定明确的质量标准，并为供给侧提供成功的指导和工具。然后退后一步，观察差距在哪里，再投入更多的人工干预策略来更具体地弥补这些差距。

---

### [00:40:02] Benjamin Lauzier

**English:**
So, lots of coaching tools that Lyft, Uber did it, like most marketplaces provide some sort of coaching. You have a review system perhaps, you have stars for your sellers, for sellers who fall below the threshold then coach them, provide them the right tools, the right guidance, what is the standard that you have on your marketplace and help them meet that bar. And for people who fall through the gaps that you have, then that's when you invest in more hands-on tools. And this is one of the things that we did at Lyft also with the rental company that we spent up. I'm happy to tell you more about that, that's interesting.

**中文翻译:**
所以，Lyft 和 Uber 做了很多指导工具，就像大多数双边市场都会提供某种形式的指导。你可能有一个评价系统，给卖家打星级，对于低于阈值的卖家，就去指导他们，提供正确的工具和引导，告诉他们市场的标准是什么，并帮助他们达到那个标准。而对于那些仍然无法达标的人，那就是你投入更多人工干预工具的时候。这也是我们在 Lyft 与我们创办的租赁公司一起做的事情之一。我很乐意多讲讲那个，很有趣。

---

### [00:40:40] Lenny Rachitsky

**English:**
I'd love to hear about that. Before we hear that, is there any marketplace that has been very good at upleveling quality without becoming managed, that did this really well that you can think of?

**中文翻译:**
我很想听听那个。在听那个之前，有没有哪个双边市场在不走向“托管化”的情况下，非常擅长提升质量，并且做得非常好？

---

### [00:40:54] Benjamin Lauzier

**English:**
Yeah, there's a talent marketplace called Toptal, and they are specialized in this. They have a really high bar for quality, they claim to only have the top 1%, top 3% I believe, of talent there. And they have a really amazing set of checks and processes. This funny story from them, but apparently they advertise something maybe a 3% pass rate for their talent, so they only on board like 3% of the people who apply. And allegedly their actual pass rate is even lower than that, but they thought that if they actually advertise the actual number it would sound fake. And so, they actually say 3% because 1% would sound like too ridiculous and it would discredit their talent. So, they're one company that does a tremendous amount of work for vetting quality early on with a ton of different checks, but also maintaining that quality. So, throughout with the right coaching tools, with education and things like that.

**中文翻译:**
有的，有一个叫 Toptal 的人才市场，他们专门做这个。他们对质量的要求非常高，声称只拥有前 1% 或前 3% 的人才。他们有一套非常惊人的审核和流程。关于他们有一个有趣的故事：显然他们宣传的人才通过率大约是 3%，也就是说他们只招收 3% 的申请者。据称他们实际的通过率甚至比这还低，但他们认为如果宣传实际数字，听起来会像假的。所以他们实际上说 3%，因为 1% 听起来太荒谬了，会损害他们人才的可信度。所以，他们是一家在早期通过大量不同审核来筛选质量，并持续维持这种质量的公司。通过正确的指导工具、教育等手段贯穿始终。

---

### [00:42:06] Lenny Rachitsky

**English:**
That's a really good example. And so, basically they just vet and only approve high quality supply in their case. It's mostly engineers, right? I think on Toptal?

**中文翻译:**
这是一个非常好的例子。所以，基本上他们只是审核并只批准高质量的供给。在他们的情况下，主要是工程师，对吧？我想 Toptal 上主要是工程师？

---

### [00:42:16] Benjamin Lauzier

**English:**
Correct. Yes, it's mostly engineers, designers, I think.

**中文翻译:**
没错。是的，我想主要是工程师和设计师。

---

### [00:42:18] Lenny Rachitsky

**English:**
Which you can only do if you have so much supply that has so much interest in becoming part of your platform, but that's a really cool example. Basically it's just only allow really high quality supply. Let's hear this rental car story, so this is Lyft trying to do rental cars, right?

**中文翻译:**
只有当你拥有如此多的供给，且他们非常有兴趣加入你的平台时，你才能这样做，但这是一个非常酷的例子。基本上就是只允许极高质量的供给。让我们听听这个租赁车的故事，这是 Lyft 尝试做租赁车，对吧？

---

### [00:42:32] Benjamin Lauzier

**English:**
Correct. Yes, yes. Yeah, so this is a little bit of context. I was leading the driver's side of product at Lyft, and General Motors had invested half a billion dollars in our last round of funding. And this was Christmas Eve, I'll always remember, I got a call from Lyft CEO and General Motors CTO, and we decided to build a rental company essentially. And the reason for it was really fascinating. GM had all those vehicles that were coming off of lease, and that they were forced to sell at auctions they didn't really know what to do with. And from our perspective, we had this massive supply gap. We've talked about this before, but we had this huge supply crunch, we were growing super fast and couldn't hire drivers fast enough, couldn't onboard drivers fast enough. And when we looked at the market, we realized that 50% of the job seekers and welfare recipients in the U.S. don't have a car.

**中文翻译:**
没错。是的。好，这有一点背景。当时我在 Lyft 负责司机端产品，通用汽车（General Motors）在我们上一轮融资中投资了 5 亿美元。那是圣诞前夜，我永远记得，我接到了 Lyft CEO 和通用汽车 CTO 的电话，我们决定基本上建立一家租赁公司。原因非常迷人：通用汽车有很多租赁到期的车辆，他们被迫在拍卖会上出售，却不知道该拿这些车怎么办。而从我们的角度来看，我们有巨大的供给缺口。我们之前谈过这个，我们当时面临巨大的供给紧缩，增长极快，招募司机的速度跟不上，入职司机的速度也跟不上。当我们观察市场时，我们意识到美国 50% 的求职者和福利领取者没有车。

---

### [00:43:26] Benjamin Lauzier

**English:**
So, that was our supply gap. This was a huge pool of people that we just couldn't tap into because they didn't have a car. And so, by renting cars we could essentially manufacture our own supply. We could dial this up and down, we could be very surgical about how many vehicles do we bring in, which markets do we bring this in, at what price? We could even offer to pay for the car if they drove 30 hours a week and completely transform the lives of those people, now we allow them to have true mobility. They can go buy groceries, they can go take the kids on vacation. So, a huge win-win for everybody with something like this. And I think in few months we had built a rental company from the ground up, and within 18 months I think we were the fourth-largest rental fleet in the U.S.

**中文翻译:**
所以，那就是我们的供给缺口。这是一大群我们无法触及的人，因为他们没有车。因此，通过出租汽车，我们基本上可以“制造”我们自己的供给。我们可以调高或调低这个规模，我们可以非常精准地决定引入多少车辆、引入哪些市场、以什么价格引入。我们甚至可以提出，如果他们每周开车 30 小时，我们就为这辆车买单，这彻底改变了这些人的生活，现在我们让他们拥有了真正的流动性。他们可以去买菜，可以带孩子去度假。所以，这样的事情对每个人来说都是巨大的双赢。我想在几个月内我们就从头开始建立了一家租赁公司，在 18 个月内，我想我们成为了美国第四大租赁车队。

---

### [00:44:10] Benjamin Lauzier

**English:**
But all of this stemmed from this gap that we saw of like, okay, it's not about controlling the drivers in general. It's about like, okay, we want to be surgical. We want to control the quality of the cars on the platform. So, we talked about that, that's a great example. In the markets where we thought the vehicles of quality was too low, we knew we could onboard more rental vehicles that were more recent to raise the average age of a vehicle on the platform. So, it gave us more control in a much more surgical way, I guess.

**中文翻译:**
但所有这些都源于我们看到的那个缺口，即：好吧，这通常不是为了控制司机，而是为了精准干预。我们想控制平台上汽车的质量。我们谈过这个，这是一个很好的例子。在那些我们认为车辆质量太低的市场，我们知道我们可以招募更多更新的租赁车辆，以提高平台上车辆的平均车龄。所以，我想这给了我们一种更精准的控制方式。

---

### [00:44:44] Lenny Rachitsky

**English:**
So, it's not that you are launching a rental car service, the idea was add supply and give drivers a car so that they could become drivers.

**中文翻译:**
所以，并不是说你们在推出一项租车服务，其核心想法是增加供给，给司机一辆车，让他们能够成为司机。

---

### [00:44:54] Benjamin Lauzier

**English:**
It was a bit of both. We actually launched, it was we had vehicles that drivers could rent from Lyft, and to drive on the platform, and also to drive for their personal needs essentially. But yeah.

**中文翻译:**
两者兼而有之。我们确实推出了这个项目，司机可以从 Lyft 租车，在平台上驾驶，本质上也可以用于个人需求。但确实如此。

---

### [00:45:10] Lenny Rachitsky

**English:**
Got it, okay. And then, did this actually work and have impact? Was this a good idea?

**中文翻译:**
明白了，好的。那么，这真的奏效并产生影响了吗？这是一个好主意吗？

---

### [00:45:16] Benjamin Lauzier

**English:**
Yeah. Yeah, it had a tremendous impact. Like I mentioned, I think we scaled this exponentially to become, I think again, the fourth-largest rental fleet in the U.S. because it was so effective for us, both because we had the right amount of control, but also those drivers were incredibly loyal to us. We had a whole bunch of other incentives that we could do, we could offer to pay for the car but only if you don't drive for the competition for Uber, and only if you drive at least 30 hours a week. So, this again provided us with, again, much greater retention, much higher engagement, and was a real incentive for us but also for the drivers.

**中文翻译:**
是的。是的，它产生了巨大的影响。正如我提到的，我想我们实现了指数级增长，再次强调，成为了美国第四大租赁车队，因为它对我们非常有效。一方面是因为我们拥有适当的控制权，另一方面是因为这些司机对我们非常忠诚。我们还可以提供一大堆其他激励措施，比如我们可以提出为你付车费，但前提是你不能为竞争对手 Uber 开车，且每周至少开车 30 小时。所以，这再次为我们带来了更高的留存率和更高的参与度，对我们和司机来说都是真正的激励。

---

### [00:45:59] Lenny Rachitsky

**English:**
Awesome. And maybe the reason it's most interesting is this is along the spectrum of a managed marketplace. It moves closer to you guys are paying and covering costs of cars. It makes it less just like this simple, highly efficient marketplace.

**中文翻译:**
太棒了。也许它最有趣的原因在于，它处于托管型市场的光谱上。它更接近于你们付钱并承担汽车成本。这使得它不再仅仅是一个简单、高效的市场。

---

### [00:46:15] Benjamin Lauzier

**English:**
Exactly, yeah. It's the marketplace version of maybe your black car fleet owner has their fleet of vehicle and they have people. So, this was the marketplace version of doing that.

**中文翻译:**
没错，是的。这就像是市场版的“高级轿车车队所有者拥有自己的车队和人员”。所以，这是实现那一模式的市场化版本。

---

### [00:46:26] Lenny Rachitsky

**English:**
And it's also just a differentiator, because GM and you guys were close, and so you had this lever that say Uber didn't have. Amazing. Another area that I know you spent time on that I think is really interesting, and I think it'd be helpful to people to hear is the mentorship program, and the ambassador program that you had at Lyft, and how that helped you scale much more quickly than other folks were able to. Can you share that story?

**中文翻译:**
而且这还是一个差异化因素，因为通用汽车和你们关系密切，所以你们拥有 Uber 所没有的杠杆。太棒了。我知道你还花时间研究了另一个我认为非常有趣的领域，我觉得让大家听听会很有帮助，那就是你们在 Lyft 实施的导师计划（Mentorship program）和大使计划（Ambassador program），以及这如何帮助你们比其他人更快地扩展规模。你能分享一下那个故事吗？

---

### [00:46:52] Benjamin Lauzier

**English:**
Pretty early on at Lyft, this was 2014, 2015 maybe, Uber was basically 30X our size. They had 30 times more revenue, more people, more liquidity, everything you can think of. They were growing like crazy, and we had a bit of this existential moment, as you can imagine, where we were wondering how we're supposed to compete with that. And we had to be super clever, everything that you did at the company had to be 10 times more efficient per person than the competition just to survive. That was the bar, just not to die, and put a lot of pressure on us but we basically found a clever way of onboarding drivers at a fraction of the cost and resources. So, let me give you a little bit of context on how the onboarding flow worked. So, at the time, the last step to get onboarded as a driver was after you background check and your driving record check came back, you had to do a visual inspection of your car, a quick test drive, some light training, and we would check your documents.

**中文翻译:**
在 Lyft 非常早期，大概是 2014、2015 年，Uber 的规模基本上是我们的 30 倍。他们的收入、人员、流动性以及你能想到的一切都是我们的 30 倍。他们增长得像疯了一样，你可以想象，我们当时面临着生存危机，在想我们该如何与之竞争。我们必须非常聪明，公司里你做的每一件事，人均效率必须比竞争对手高 10 倍才能生存。这就是标准——仅仅为了不倒闭。这给了我们很大压力，但我们基本上找到了一种以极低成本和资源招募司机的聪明方法。让我给你一点关于入职流程背景。当时，司机入职的最后一步是：在背景调查和驾驶记录检查通过后，你必须对车辆进行外观检查、进行简短的试驾、接受一些简单的培训，我们还会检查你的证件。

---

### [00:47:53] Benjamin Lauzier

**English:**
We would check that you are the person with a driver's license and all those things. And Uber at the time would launch a team on the ground, they would go and open an office and they would have DMV-style group onboarding sessions and car inspections. And we did this as well in our first three to four markets, but you can imagine the overhead and the lead time. You had to go and you had to find office space, sign the lease, hire employees, you had huge, huge lead time. And we thought about it, and at the time a huge competitive differentiator for us was our brand. As a passenger or as a driver, why would you use a platform with lower liquidity? As a driver, you had lower earnings guaranteed. As a passenger, you had longer wait times. Why would you use a service like that? You do because of the brand, because of its values, it's how it makes you feel.

**中文翻译:**
我们会检查你是否是持有驾照的那个人等等。当时的 Uber 会派出地面团队，去开设办公室，举行 DMV（车管所）风格的集体入职会议和车辆检查。我们在前三四个市场也这样做过，但你可以想象那样的管理费用和前置时间（Lead time）。你必须去找办公空间、签租约、雇员工，前置时间非常非常长。我们思考了一下，当时我们巨大的竞争优势是我们的品牌。作为乘客或司机，你为什么要使用一个流动性较低的平台？作为司机，你的收入保障较低；作为乘客，你的等待时间较长。你为什么要使用那样的服务？你使用是因为品牌，因为它的价值观，以及它带给你的感受。

---

### [00:48:41] Benjamin Lauzier

**English:**
And so, we had the pink mustaches at the time, we had this very strong brand identity. I think a lot of that has been lost now, but we also had this amazing community of drivers who were fierce advocates for the brand. And so, what we did is leveraging this community and building essentially a soft onboarding supply engine where we would pay our best drivers $35 per mentor session, and a mentor session was essentially replacing this onboarding flow. So, it was basically another driver looking at your vehicle to check all your documents, take photos of your driver's license and all that stuff, and take you on a short ride along. And the benefits of this were absolutely mind-blowing and kind of unexpected for us on all sides. First, the mentors were our very best drivers, and they were evangelists for the brand. So, what they did was they would share personal tips on when and where to drive.

**中文翻译:**
所以，我们当时有粉红胡子，有非常强烈的品牌认同感。我想现在很多都已经流失了，但我们当时也有一个令人惊叹的司机社区，他们是品牌的坚定拥护者。所以，我们所做的是利用这个社区，建立一个本质上是“软入职”的供给引擎：我们向最优秀的司机支付每场导师会议 35 美元的报酬，而导师会议本质上取代了之前的入职流程。基本上就是由另一名司机检查你的车辆、核对所有证件、拍摄驾照照片，并带你进行一次简短的试驾。这对我们各方来说，好处绝对是惊人的，而且有点出乎意料。首先，导师是我们最优秀的司机，他们是品牌的福音传道者。他们会分享关于何时何地开车的个人技巧。

---

### [00:49:34] Benjamin Lauzier

**English:**
Oftentimes they shared their contact info. And this created tremendous leverage and social proof for those new drivers who were on the fence about taking strangers into their car. It's actually quite funny because we had the brightest minds in the company writing the best marketing emails and copy, like, "Hey, hop on the car and drive this Saturday." And you had all those drivers and all those mentors like, "No, no, don't listen to those Lyft guys. Here's what you should do. Go on Tuesday at 2:00 PM, text me, I'll tell you where the good spot is, and this is how you're going to get rides. This is how you're going to get rich and make a lot of money." And this recognition lever was just so much more powerful than anything we could be telling you. And so, very, very efficient activation lever for the new drivers. For us, also incredibly scalable.

**中文翻译:**
他们经常分享自己的联系方式。这为那些对“把陌生人带进车里”犹豫不决的新司机创造了巨大的杠杆和社交证明（Social proof）。这其实挺有趣的，因为我们公司里最聪明的人在写最好的营销邮件和文案，比如：“嘿，这周六上车开起来吧。”而那些司机和导师会说：“不，不，别听 Lyft 那些家伙的。你应该这样做：周二下午 2 点去，发短信给我，我会告诉你哪里是好地方，这样你就能接到单。这样你才能发财，赚大钱。”这种来自同行的认可杠杆比我们能告诉你的任何东西都要强大得多。所以，这对新司机来说是非常非常高效的激活杠杆。对我们来说，它也具有极高的可扩展性。

---

### [00:50:22] Benjamin Lauzier

**English:**
We could fly a small team to rigorously vet and onboard maybe like 10, 20 top drivers, and then they'd fly to a different market, and we would let the rest of our drivers be onboarded by those mentors. And even for those mentors, for those top drivers, it was an incredible recognition lever. For them, if you were a 4.9 driver, you had enough rides, you had a chance to make it into being a mentor, and this provided additional earnings opportunity for you. If you did two mentor sessions in an hour, you could make 70 bucks an hour. You could take a break from driving if you're tired, and just do some of those. It felt like getting promoted at a job. And so, it actually had a huge impact on the retention of our very best drivers, which was unexpected. So, a lot of really, really interesting benefits, and we actually lean into this and built a couple of really fascinating variations of this for a while, but this allowed us to match most of Uber's footprint with a 10th or a 20th of the resources at incredible speed, I guess.

**中文翻译:**
我们可以派一个小团队去严格审核并招募大约 10 到 20 名顶级司机，然后他们飞往另一个市场，剩下的司机就由这些导师来负责入职。甚至对于这些导师、这些顶级司机来说，这也是一个令人难以置信的认可杠杆。对他们来说，如果你是一个 4.9 分的司机，有足够的行程，你就有机会成为导师，这为你提供了额外的收入机会。如果你一小时做两次导师会议，你每小时能赚 70 美元。如果你开车累了，可以休息一下，做几场导师会议。这感觉就像在工作中获得了晋升。所以，它实际上对我们最优秀司机的留存产生了巨大影响，这是意料之外的。所以，有很多非常非常有趣的益处，我们实际上深入研究了这一点，并在此基础上构建了几个非常迷人的变体。这使我们能够以十分之一或二十分之一的资源，以惊人的速度匹配 Uber 的大部分版图。

---

### [00:51:21] Lenny Rachitsky

**English:**
That is an amazing story, and it's such a great lever that I totally agree, I don't hear people using and I wonder why. So, what I'm hearing is it was cheaper, the drivers were making money. I imagine the drivers trained by the mentors ended up being better drivers, that's what we saw at Airbnb, hosts that came in through a referral ended up being better hosts, for whatever reason. And you're saying basically, this is what allowed you to compete with Uber at a much smaller scale and much less money raised. Amazing.

**中文翻译:**
这是一个惊人的故事，这是一个非常棒的杠杆，我完全同意，我没怎么听人提起过，我也在想为什么。所以我听到的是：它更便宜，司机能赚到钱。我猜想由导师培训的司机最终会成为更好的司机，这正是我们在 Airbnb 看到的——通过推荐加入的房东最终成为了更好的房东，不管出于什么原因。你基本上是说，这就是让你们在规模小得多、融资少得多的情况下能与 Uber 竞争的原因。太神奇了。

---

### [00:51:51] Benjamin Lauzier

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:51:52] Lenny Rachitsky

**English:**
You said there's a couple of variations. Is there anything interesting there to share, just things that you built as a follow-up based on the success?

**中文翻译:**
你说有几个变体。有什么有趣的可以分享吗？就是基于这次成功，你们后续构建了什么？

---

### [00:51:58] Benjamin Lauzier

**English:**
So, the next step in that journey was basically we were growing like crazy, but now we had cracks in like the activation phase, but now we had a whole bunch of people dropping off in the funnel before activation. So, they didn't enter their SSN, they didn't enter the right info for us to run all those checks in the previous steps of the onboarding flow. So, we built a team of hundreds of account executives, and their job was just pick up the phone and call those drivers. And so, we had the same aha moment of like could we get some of our best drivers to do that for us, and empower them to be a part of this? And so, we did this and we launched another, like I said, role. We called them recruiters. And so, as a recruiter, as a driver, you could just, if this was quiet on the road, you could just hop on your phone and you would have a mini sales dashboard where you could claim leads.

**中文翻译:**
在那段旅程的下一步，基本上是因为我们增长得太快了，但在激活阶段出现了裂痕——有一大堆人在激活前的漏斗中流失了。他们没有输入社会安全号码（SSN），没有输入正确的信息让我们在入职流程的前几步进行检查。于是，我们建立了一个由数百名客户经理（Account Executives）组成的团队，他们的工作就是拿起电话给这些司机打电话。于是，我们产生了同样的“顿悟”时刻：我们能不能让一些最优秀的司机帮我们做这件事，并授权他们参与其中？于是我们这样做了，推出了另一个角色，我们称之为“招聘员”（Recruiters）。作为招聘员，如果你在路上没活，你可以打开手机，你会有一个微型销售仪表盘，可以在那里领取线索。

---

### [00:52:49] Benjamin Lauzier

**English:**
And this was a driver who had dropped off in the funnel, and you had a telephone number, you could just call them and text them. And same thing, those guys were outperforming our very best of trained salespeople, because it's not like, "Hey, it's Ben from Lyft. Hop on the road, please." It's like, "Hey, my name is James and I'm a fellow driver as well. Lyft told me that you have a incomplete application. Do you have any questions? Do you want me to come to your house, we can do this together?" And we would pay them 20 bucks per person that they converted to activation. And so, something incredibly scalable for us, another way for us to reward and recognize our best drivers. And it also provided a really interesting way for us to smooth out the supply and demand. The problem with a marketplace like Lyft is that you have this big spike. Everyone wants to drive on a Tuesday at 2:00 PM, but everyone wants rides on a Saturday at 2:00 AM. And so, how can you manufacture demand during those low utilization times? This was a great way to do that. Now you could wait on the road and still make money while just sitting in your car while waiting for the next ride. So, this was another iteration of this model that was really cool.

**中文翻译:**
这些是在漏斗中流失的司机，你有他们的电话号码，可以直接给他们打电话或发短信。同样，这些人的表现优于我们训练有素的顶尖销售人员。因为这不再是：“嘿，我是来自 Lyft 的 Ben，请上路开车吧。”而是：“嘿，我叫 James，我也是一名司机。Lyft 告诉我你的申请还没填完。你有什么问题吗？你想让我去你家，我们一起完成吗？”每转化一个人激活，我们就付给他们 20 美元。这对我们来说是极具扩展性的，也是我们奖励和认可优秀司机的另一种方式。它还为我们提供了一种非常有趣的方式来平滑供需。像 Lyft 这样的市场的难题在于存在巨大的峰值：每个人都想在周二下午 2 点开车，但每个人都想在周六凌晨 2 点打车。那么，你如何在这些低利用率时段“制造”需求？这是一个很好的方法。现在你可以在路上等待，坐在车里等下一单的同时还能赚钱。所以，这是该模型的另一个非常酷的迭代。

---

### [00:53:58] Lenny Rachitsky

**English:**
Amazing. That is so cool. I just know the feeling of being on a team, coming up with this idea and the thing working must feel so great. Just like, "Holy shit, look at this. Look at all these cool things that we can do with our supply." Something I wasn't going to get into, but it might be interesting just to hear if you have thoughts on this. So, I've been a huge fan of Lyft from the beginning, I used Lyft the very first weekend it came out in San Francisco when there was like five drivers. It was like a beta test, I was friends with someone that worked at Lyft early on, and it was just like, "Man, Lyft's the best." I was like all Lyft, Uber sucks, I hate that. I want to give it the fist bump or the mustache. So great. Today though, I was just looking at market caps. Uber is worth $150 billion, Lyft is worth $5 billion. I'm curious if you have thoughts on just, it feels like Uber has won at this point, and I don't know where Lyft goes.

**中文翻译:**
太神奇了。这太酷了。我能体会那种在团队中提出一个想法并让它奏效的感觉，一定非常棒。就像是：“天哪，看这个。看看我们可以利用我们的供给做这么多酷的事情。”有一件事我本来没打算谈，但听听你的想法可能会很有趣。我从一开始就是 Lyft 的忠实粉丝，Lyft 在旧金山推出的第一个周末我就用了，当时大概只有五个司机。那就像是一个 Beta 测试，我当时和早期在 Lyft 工作的人是朋友，当时觉得：“伙计，Lyft 是最棒的。”我当时完全支持 Lyft，觉得 Uber 很烂，我讨厌它。我想给它一个“碰拳”或挂上那个胡子。太棒了。但今天，我看了看市值：Uber 价值 1500 亿美元，Lyft 价值 50 亿美元。我很好奇你对此有什么看法，感觉 Uber 在这一点上已经赢了，我不知道 Lyft 会走向何方。

---

### [00:55:15] Benjamin Lauzier

**English:**
Yeah. I think it all went south when I left the company. I'm just kidding. No, and again, I have to call out the fact that I haven't been close to Lyft, and their business and strategy for many years at this point. So, take this with a grain of salt. This is my very naive perspective, but I think to me, perhaps the biggest blow to Lyft's business was somewhat inherent, like the vision. Lyft's vision was always anchored around transportation, people of transportation. The founders were deeply passionate about moving people, they were passionate about transforming the way people move around in a city. They wanted to just change how cities are designed, how roads are designed. And so, that meant investing in dynamic shuttles and things like that, and there's a lot of experimentation that went to that. But it also meant that Lyft never invested in things like food delivery, or goods and parcels, and things like that.

**中文翻译:**
是的。我想一切都是在我离开公司后变糟的。开个玩笑。不，再次强调，我已经很多年没有接触过 Lyft 及其业务和策略了。所以，请持保留态度听我的观点。这是我非常天真的看法，但我认为，对 Lyft 业务最大的打击在某种程度上是内在的，比如愿景。Lyft 的愿景始终锚定在交通运输、人的运输上。创始人对运送人充满热情，他们热衷于改变人们在城市中的移动方式。他们想改变城市的规划方式、道路的设计方式。因此，这意味着投资于动态班车之类的事物，为此做了很多实验。但也意味着 Lyft 从未投资过外卖、货物和包裹递送之类的事情。

---

### [00:56:26] Benjamin Lauzier

**English:**
And I think that crushed them during COVID essentially. I think Uber had, I think at some point their slogan was moving in bits and atoms, or something like that. But I think it implies this notion of being a logistics platform for assets in the world, for transporting people, for transporting things, for transporting ... And I think they built, they invested lot in trucks and food delivery, and all those really exotic things that Lyft had never any intention to invest in. Not even because of the lack of resources, but because this was in part a distraction from our vision. We wanted to change how people move around in cities, we wanted to reinvent public transportation, we did not want to be a DoorDash competitor and help you get in donuts during COVID. And a huge part of it also was leaning heavily in shared rides. And so, this was like, again, how do you reinvent public transportation?

**中文翻译:**
我认为这在 COVID 期间基本上击垮了他们。我想 Uber 曾几何时，他们的口号是“在比特和原子中移动”之类的。我认为这隐含了作为一个全球资产物流平台的概念，用于运输人、运输物、运输……我想他们建立并投资了大量卡车、外卖以及所有那些 Lyft 从未打算投资的“异域”事物。甚至不是因为缺乏资源，而是因为这在某种程度上偏离了我们的愿景。我们想改变人们在城市中的移动方式，我们想重新发明公共交通，我们不想成为 DoorDash 的竞争对手，在 COVID 期间帮你送甜甜圈。其中很大一部分还在于重度投入共享乘车（Shared rides）。所以，这又是那个问题：你如何重新发明公共交通？

---

### [00:57:28] Benjamin Lauzier

**English:**
It's like every car is a dynamic bus, and now there's a bus line. The bus line is always running, it's always by your house. So, a lot of our investment I think in thinking went in that direction, and the last thing that people wanted with COVID was to be in a car with five strangers, but what people wanted is food delivered to their house. And so, I know that the business had a huge blow during COVID, whereas I think Uber was able to rebound much more quickly because of how diversified the business was. And so, it's funny now because I think Lyft actually killed shared rides, which was just so core to their identity. They were the first ones to launch this. And so yeah, the new COO I think killed the shared rides, which actually I'm really sad about. But yeah, so I think it indicates a very different vision now, a very different direction for the business. And yeah, that's my take, I guess.

**中文翻译:**
就像每辆车都是一辆动态巴士，现在有了一条巴士线。巴士线一直在运行，总是在你家门口。所以我认为我们的很多投资和思考都朝着那个方向发展，而 COVID 期间人们最不想要的就是和五个陌生人挤在一辆车里，人们想要的是把食物送到家里。所以我知道业务在 COVID 期间遭受了巨大打击，而我认为 Uber 能够更快地反弹，是因为其业务非常多元化。现在很有趣，因为我想 Lyft 实际上取消了共享乘车，而这曾是他们身份的核心。他们是第一个推出这个功能的。所以是的，我想新任 COO 取消了共享乘车，这其实让我挺难过的。但是的，我认为这表明了现在截然不同的愿景，业务方向也完全不同了。这就是我的看法。

---

### [00:58:19] Lenny Rachitsky

**English:**
Interesting. So, essentially COVID really effed them because their strategy was always about transportation, and when nobody needs a ride and people want food, strategically Uber made a really good move expanding into food delivery, which I think was a bigger business than rides for a long time. I don't know where it's at today for Uber, and Lyft didn't have that, and it's hard to recover from a time like that. So, it sounds like it's a combination of strategy was pointing Lyft in a certain direction, and circumstances in the world just made it really hard-

**中文翻译:**
有趣。所以，本质上 COVID 真的把他们搞惨了，因为他们的策略始终围绕交通。当没人需要打车而人们需要食物时，Uber 进军外卖领域在战略上是一个非常好的举动，我想在很长一段时间里外卖业务甚至比打车业务还要大。我不知道 Uber 现在的状况如何，但 Lyft 没有那个业务，很难从那样的时期恢复过来。所以，听起来是策略将 Lyft 指向了某个方向，而世界局势让它变得非常艰难——

---

### [00:58:50] Benjamin Lauzier

**English:**
And losing me me.

**中文翻译:**
还有失去了我。

---

### [00:58:51] Lenny Rachitsky

**English:**
And losing Ben. So, you left in 2019, March 2019, and is that when they went public?

**中文翻译:**
还有失去了 Ben。所以，你在 2019 年离开，2019 年 3 月，那是他们上市的时候吗？

---

### [00:58:52] Benjamin Lauzier

**English:**
Not for the IPO.

**中文翻译:**
不是为了 IPO。

---

### [00:58:59] Lenny Rachitsky

**English:**
Yeah, and it's all downhill from then. And then-

**中文翻译:**
是的，从那以后就开始走下坡路了。然后——

---

### [00:59:03] Benjamin Lauzier

**English:**
I'm telling you.

**中文翻译:**
我告诉你吧。

---

### [00:59:04] Lenny Rachitsky

**English:**
... during COVID actually, when there was a big bump, which I think when people started riding again, and then it went down again. So, I think there was a correlation there, so there we go. That's the thing, don't ever fire Ben, don't let Ben leave. That's our take on it.

**中文翻译:**
……实际上在 COVID 期间，曾有过一个巨大的反弹，我想那是人们重新开始打车的时候，然后又下去了。所以我认为这其中存在相关性。所以结论就是：永远不要解雇 Ben，不要让 Ben 离开。这就是我们的看法。

---

### [00:59:16] Benjamin Lauzier

**English:**
I was not fired, yeah. Just to be clear.

**中文翻译:**
我没被解雇，是的。澄清一下。

---

### [00:59:18] Lenny Rachitsky

**English:**
Okay, just different ways you might leave a company, don't let it happen.

**中文翻译:**
好的，只是离开公司的不同方式而已，别让它发生。

---

### [00:59:23] Benjamin Lauzier

**English:**
I know, I'm kidding.

**中文翻译:**
我知道，我开玩笑的。

---

### [00:59:25] Lenny Rachitsky

**English:**
Okay, so there's two more things I want to spend a little time on before we close up. One is your work in Europe, so you're a product leader in Europe, and I want to hear a little bit about what it's like to be a product person in Europe. And then two, I want to hear about the startup. So, at this point no one can actually fire. You have your own company that you're running, and I want to spend a little time here. Usually we don't spend time on this sort of stuff, but you're working on something very cool that I think is going to be really helpful to a lot of people in a really meaningful way. So, I want to spend a little time there. But before that, so you're living in France now. Before you started your company, you were interviewing for CPR roles in France, you work with a lot of French companies, European companies. I'm curious what you've noticed might be different in the cultures of tech companies in France and Europe in general versus the U.S.

**中文翻译:**
好的，在结束之前，还有两件事我想花点时间聊聊。第一是你在欧洲的工作。你现在是欧洲的一位产品领导者，我想听听在欧洲做产品人是什么感觉。第二，我想听听你的初创公司。在这一点上，没人能解雇你了。你经营着自己的公司，我想在这里花点时间。通常我们不花时间聊这类事情，但你正在做一件非常酷的事情，我认为它将以一种非常有意义的方式对很多人非常有帮助。所以我想在那儿花点时间。但在此之前，你现在住在法国。在你创办公司之前，你在法国面试过 CPO 职位，你与很多法国公司、欧洲公司合作过。我很好奇你注意到法国和整个欧洲的科技公司文化与美国有什么不同。

---

### [01:00:12] Benjamin Lauzier

**English:**
It's been really fascinating, I think. So, my entire career has been in the U.S., and I'm just starting to understand what that European and the French market in particular looks like. And my read so far is that product management has really exploded I think in Europe in recent years, but the market dynamics are still quite different. In the U.S. I think you have this inherently very liquid and dynamic market. I think, this is my interpretation of it, but I think it leads to greater ownership and accountability for people and product at all levels. So, product managers and leaders, they join a startup and you're immediately in charge of a relatively meaningful piece of the business, with genuine autonomy oftentimes. It doesn't always happen, but oftentimes I think that's the case. And if things don't work out, well, there's this expectation that you'll be managed out.

**中文翻译:**
我认为这真的非常迷人。我的整个职业生涯都在美国度过，我才刚刚开始了解欧洲市场，特别是法国市场。到目前为止，我的看法是，产品管理在欧洲近年来确实呈爆炸式增长，但市场动态仍然非常不同。在美国，我认为你拥有一个天生非常具有流动性和活力的市场。这是我的解读，但我认为这导致了各个层级的人员和产品都拥有更大的所有权（Ownership）和问责制（Accountability）。所以，产品经理和领导者加入一家初创公司，你立即负责业务中相对重要的一部分，通常拥有真正的自主权。虽然并非总是如此，但我认为通常是这样。如果事情进展不顺利，那么就会有你被“优化”（Managed out）的预期。

---

### [01:01:09] Benjamin Lauzier

**English:**
There are countless memes on LinkedIn about the tenure of CPOs at tech companies to illustrate that. I think in France the market is much less liquid, so it's incredibly difficult to change jobs, and it's very expensive to fire someone in France. So, it seems to lead to two effects beyond the obvious job security. One is, I think PMs tend to have less autonomy and ownership, and a little bit more like micromanagement. And there are also less business owners than they can be in the U.S. And I see founders and managers struggling to let go of control a little bit more, again because it's understandable in a way, you don't have as much of a control as you do in the U.S. And so, you see a lot of really fascinating effects.

**中文翻译:**
LinkedIn 上有无数关于科技公司 CPO 任期的梗图来证明这一点。我认为在法国，市场的流动性要低得多，所以换工作非常困难，而且在法国解雇一个人的成本非常高。所以，除了显而易见的职业保障外，这似乎导致了两个影响。一是，我认为 PM 往往拥有较少的自主权和所有权，更多的是微观管理（Micromanagement）。而且，与美国相比，这里的“业务负责人”（Business owners）也较少。我看到创始人和经理们更难放权，这在某种程度上是可以理解的，因为你不像在美国那样拥有那么多控制权。所以，你会看到很多非常迷人的现象。

---

### [01:01:55] Benjamin Lauzier

**English:**
You have startups who tend to wait a little bit longer before hiring, especially in product. The art of product a little bit less of a thing. You have a lot of amazing PMs in France, but the recognition of the craft is a little bit different outside of the people who practice it. And you have a lot of real interesting outsourcing also, you see startups and companies of all sizes actually relying on great product studios, like Mozza, to build end-to-end products from the ground up. So, something that's been really, really interesting. Another side that I see is this dominance of business over tech in France. There isn't as much of a cult of technology and software engineering in France as there is in the U.S. And so, the French Ivy League schools are business schools, like HEC, and the most highly valuable skill that you get is soft skills around management and business. It differs from the stereotype of the CS degree, Stanford dropout that you have in Silicon Valley.

**中文翻译:**
初创公司往往会等待更长时间才开始招聘，尤其是在产品领域。“产品艺术”在这里没那么受重视。法国有很多优秀的 PM，但除了从业者之外，外界对这门手艺的认可度略有不同。你还会看到很多非常有趣的业务外包，你会看到各种规模的初创公司和公司实际上依赖于优秀的产品工作室（如 Mozza）来从头开始构建端到端的产品。这真的非常非常有趣。我看到的另一面是法国“业务优于技术”的主导地位。在法国，对技术和软件工程的崇拜不像美国那么盛行。法国的“常春藤盟校”是商学院，比如 HEC，你获得的最有价值的技能是围绕管理和业务的软技能。这与硅谷那种“计算机学位、斯坦福辍学生”的刻板印象不同。

---

### [01:03:25] Benjamin Lauzier

**English:**
And I think because of a few of those things that I just mentioned, less liquid job market, but also less liquid financial markets, the last thing that I've observed that's interesting that's also around ownership I guess, is equity is much less meaningful in France. So, of the product leaders that I talked to, most of them consider their equity to be virtually worthless. None of them know of anyone who's made a down payment on a house thanks to their sort of equity. So, it's seen as a nice bonus, but it's not the token of ownership and the promise of future wealth that it can be in the U.S. when you join a startup. For exec roles, I think it's often sub 10% of their total compensation, whereas in the U.S. it's very often more than 50% of your compensation will be equity. So, that's been interesting in terms of the dynamic, but it's also been real interesting to just see how vibrant the startup culture is here in France.

**中文翻译:**
我认为由于我刚才提到的几点——流动性较低的就业市场，以及流动性较低的金融市场——我观察到的最后一件有趣的事也与所有权有关，那就是股权（Equity）在法国的意义要小得多。在我交谈过的产品领导者中，大多数人认为他们的股权几乎一文不值。他们中没有人认识谁是因为股权而付得起房子首付的。所以，它被视为一种不错的奖金，但它不像在美国加入初创公司时那样，是所有权的象征和未来财富的承诺。对于高管职位，我想股权通常不到其总薪酬的 10%，而在美国，股权往往占你薪酬的 50% 以上。所以，这种动态非常有趣，但看到法国这里的初创文化如此充满活力也真的很有趣。

---

### [01:04:03] Benjamin Lauzier

**English:**
You have a truly exciting innovation happening, especially in AI. You have a lot of French companies at the forefront of this, like Mistral AI and Hugging Face, and things like that. And also how it's been exciting to see how the government is leaning into that as a catalyst for this innovation. I think the French government has dedicated something like $2.5 billion in funding to support French AI excellence by 2030. So, they're running a lot of internal government incubators to try to disrupt some of the government functions from the inside, and they're hiring top talents to do that. I've met some of the people working on this, it's just really fascinating. It makes me super excited about what a federal startup task of reinventing [inaudible 01:04:38] would look like. So yeah, it's been really exciting to see the whole space and how it differs from the U.S.

**中文翻译:**
这里正在发生真正令人兴奋的创新，特别是在 AI 领域。有很多法国公司处于前沿，比如 Mistral AI 和 Hugging Face 等等。看到政府如何将其作为创新的催化剂也令人兴奋。我想法国政府已经拨出了大约 25 亿美元的资金，用于支持到 2030 年的法国 AI 卓越计划。所以，他们正在运行很多政府内部孵化器，试图从内部颠覆一些政府职能，并为此聘请顶尖人才。我见过一些从事这项工作的人，真的非常迷人。这让我对重新发明[听不清]的联邦初创任务会是什么样子感到超级兴奋。所以，看到整个领域以及它与美国的差异真的很有趣。

---

### [01:04:45] Lenny Rachitsky

**English:**
Fascinating. So, I know there's also AI regulation that feels really strange in Europe, but think that's EU based, not like France specifically.

**中文翻译:**
迷人。我知道欧洲的 AI 监管感觉也很奇怪，但我认为那是基于欧盟的，而不是专门针对法国。

---

### [01:04:46] Benjamin Lauzier

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:04:55] Lenny Rachitsky

**English:**
Yeah, that people are not excited about. There's just a lot of fear of AI, and so there's a lot of regulation talk in Europe.

**中文翻译:**
是的，人们对此并不兴奋。欧洲对 AI 有很多恐惧，所以有很多关于监管的讨论。

---

### [01:05:02] Benjamin Lauzier

**English:**
I'm a big Android guy, and a lot of the features like Gemini and all this is only available in the U.S., and now that I'm in France I see the difference a little bit.

**中文翻译:**
我是个忠实的安卓粉丝，很多功能比如 Gemini 之类的目前只在美国可用，现在我在法国，我能感觉到一点差异。

---

### [01:05:12] Lenny Rachitsky

**English:**
Interesting. So, the cultural differences you spoke of, do you think they're rooted in the fact that people don't move jobs often, or is it culture? People just don't learn to work in the way that people learn to work in the U.S. in the product role? What do you think is the root of why things are so different?

**中文翻译:**
有趣。所以，你提到的文化差异，你认为它们根植于人们不经常换工作这一事实，还是文化本身？人们只是没有学会以美国人在产品角色中的工作方式来工作？你认为导致如此巨大差异的根源是什么？

---

### [01:05:35] Benjamin Lauzier

**English:**
I'm not quite sure, it's a good question. My take, and I think this is I'm sure very naive and reductive, and I know this is one of my core principles, so I'm sure I also have a tunnel vision on this a little bit. But to me, one of the biggest difference that I see is really around this concept of ownership and accountability. Whereas in the U.S., and again, I saw it, I'm sure you saw it at Airbnb, you see it at a lot of companies, not everywhere, but a lot of companies will hire you, give you a big chunk of the business, and it's up to you to prove yourself out. Where you have six months, you have a year, it's up to you to show impact. I think the French employment model is less conducive to this type of dynamic, because employment is much more rigid.

**中文翻译:**
我不太确定，这是一个好问题。我的看法（我确信这非常天真且简化，而且我知道这是我的核心原则之一，所以我确信我在这方面也有一点隧道视野）是：对我来说，我看到的最大的差异之一确实是围绕着所有权和问责制的概念。而在美国，正如我看到的，我相信你在 Airbnb 也看到了，你在很多公司都能看到（虽然不是到处都有），很多公司会雇佣你，给你一大块业务，由你自己去证明自己。你有六个月，你有一年，由你来展示影响力。我认为法国的雇佣模式不太有利于这种动态，因为雇佣关系要僵化得多。

---

### [01:06:20] Benjamin Lauzier

**English:**
So, you have much less of this hire now and prove yourself out, it's much more of prove yourself beforehand. And if you've made a bad hire than as a founder, you become perhaps a little bit cagey about your vision. You want to be more hands-on because you made a bad hire. It's not like someone perfect, then he'll make you work but it means you'll be more hands-on in the work of PMs daily, and perhaps we'll think like, "Oh, maybe I don't need product managers who want on my vision, I'll hire project managers," or something like that. So, it's perhaps slightly more conducive to those types of dynamics.

**中文翻译:**
所以，你很少看到这种“先雇佣再证明自己”的情况，更多的是“事先证明自己”。如果你作为创始人招错了人，你可能会对你的愿景变得有点守口如瓶。因为招错了人，你想更多地亲力亲为。这不像遇到一个完美的人，他会让你放手工作，这意味着你会更多地参与 PM 的日常工作，也许会想：“噢，也许我不需要能理解我愿景的产品经理，我雇个项目经理（Project managers）就行了。”所以，这可能稍微更有利于产生这类动态。

---

### [01:06:53] Lenny Rachitsky

**English:**
And you're saying that's in part because it's harder to fire people in France and in Europe?

**中文翻译:**
你是说这部分是因为在法国和欧洲更难解雇人？

---

### [01:06:58] Benjamin Lauzier

**English:**
Yeah, I think so. It's not just about firing I think, to be clear, I just think it's culturally the market seems like a lot less liquid and dynamic.

**中文翻译:**
是的，我想是的。澄清一下，我认为不仅仅是解雇的问题，我只是觉得从文化上讲，市场似乎缺乏流动性和活力。

---

### [01:07:05] Lenny Rachitsky

**English:**
So, people don't move around as much, they stick around for a long time.

**中文翻译:**
所以，人们不怎么流动，他们会待很长时间。

---

### [01:07:10] Benjamin Lauzier

**English:**
Yeah, exactly. Yeah.

**中文翻译:**
是的，没错。是的。

---

### [01:07:11] Lenny Rachitsky

**English:**
Got it. And it sounds like there's also just a cultural difference of founders innately are much more, "I am in control, and I'm not going to hire people and trust you to take this thing on. I'm just going to run the show." It's basically Paul Graham's founder mode is already instilled in everyone.

**中文翻译:**
明白了。听起来还有一种文化差异，创始人天生就更倾向于：“我掌控一切，我不会雇了人就信任你让你接手。我要掌控全局。”基本上保罗·格雷厄姆（Paul Graham）所说的“创始人模式”（Founder mode）已经根植在每个人心中了。

---

### [01:07:29] Benjamin Lauzier

**English:**
Maybe yeah, maybe that's a little bit. And I think also it's this culture of business, so very business-centric sort of culture. And again, it makes sense, the markets, you have less venture capital, you have less equity in the financial markets as well. And so, when you raise funding you need to have a strong business case. The business case is at the center of your habits. Whereas I think oftentimes in the U.S. you have, again, it's a little bit stereotypical, but it's a very tech or product-centric view of the world, or it can be a very tech or product-centric view of the world where it'll be like this product, this is the vision of the product, and sometimes even the business model will follow. And in France, I think the business model has to be front and center perhaps for you to be able to raise venture capital for you to be able to even exist. So, it means it attracts a lot of business minded entrepreneurs, much more so perhaps than tech-minded or product-minded entrepreneurs.

**中文翻译:**
也许吧，也许有一点。我认为这也是一种商业文化，非常以业务为中心。这也有道理，因为市场上的风险投资较少，金融市场中的股权也较少。所以，当你融资时，你需要有一个强大的商业案例（Business case）。商业案例是你习惯的核心。而在美国，虽然有点刻板印象，但通常是一种非常以技术或产品为中心的世界观，或者是“这就是产品，这就是产品的愿景，有时甚至商业模式会随之而来”。而在法国，我认为商业模式必须放在首位，也许这样你才能筹集到风险投资，甚至才能生存下去。这意味着它吸引了很多具有商业头脑的企业家，可能比具有技术头脑或产品头脑的企业家多得多。

---

### [01:08:29] Lenny Rachitsky

**English:**
Got it. If someone wants to help their company in Europe and France operate more closely to the way companies in the U.S. operate, do you have any advice for them? I know you talk and work with a lot of companies in Europe, what do you help them change and see differently?

**中文翻译:**
明白了。如果有人想帮助他们在欧洲和法国的公司以更接近美国公司运作的方式运作，你对他们有什么建议吗？我知道你与很多欧洲公司交流和合作，你帮助他们改变了什么，让他们看到了什么不同的东西？

---

### [01:08:47] Benjamin Lauzier

**English:**
Yeah, it's a great question. I haven't fully cracked that, and think it's a really hard question. I'll give some sort of small pointers that have helped at least some of the companies that I've talked to. But the one is equity, I think there's a desire from a lot of the founders that I talk to, to give equity to employees, but because it's not in the culture yet I think employees also have an under-appreciation for equity. Like, "Well yeah, it's nice, but I don't know what's going to happen. I just work for the CEO anyways." There's less of this sense of, again, ownership that you can have in the U.S.

**中文翻译:**
是的，这是一个好问题。我还没有完全破解它，我认为这是一个非常难的问题。我会提供一些小的建议，这些建议至少对我交谈过的一些公司有所帮助。第一是股权。我交谈过的很多创始人都希望给员工股权，但因为这还没有形成文化，我认为员工对股权的重视程度也不够。就像：“嗯，是的，挺好的，但我不知道会发生什么。反正我只是为 CEO 打工。”这里缺乏那种在美国能拥有的所有权感。

---

### [01:09:22] Benjamin Lauzier

**English:**
And so, I think leaning into that and investing in education around equity, the case is also in the U.S., I'm convinced 80% of people just don't fully understand their equity. But I think leaning into that, especially in Europe, to help people understand the value of their equity, help them by telling more about the story of the business, the trajectory of the business, why it matters for their future equity. I think anything along those lines I think can help cultivate this greater ownership mindset, I think for people. And then yeah, I think another big piece again is, at least to me this is a big recipe to successful product teams, is to develop teams that revolve around this concept of ownership and accountability teams that are clearly owning a huge, or it doesn't have to be huge, like a slice of the business, not feature teams like shipping maybe guests, but teams that have clear accountability with consequences, but also clear ownership and leeway to do their best and to thrive.

**中文翻译:**
所以，我认为应该投入精力进行股权教育。在美国也是如此，我确信 80% 的人并不完全理解他们的股权。但我认为在欧洲，投入精力帮助人们理解股权的价值，通过讲述更多关于业务的故事、业务的轨迹、为什么这对他们未来的股权很重要，这些都能有所帮助。我认为任何这类举措都能帮助培养更强的所有权心态。然后，我认为另一个重要的部分（至少对我来说这是成功产品团队的一大秘诀）是：建立围绕所有权和问责制概念的团队。这些团队清晰地拥有业务的一大块（不一定要很大，但要是一块完整的业务），而不是只负责发布某个功能的“功能团队”，而是拥有明确的问责制（伴随结果）以及明确的所有权和余地，让他们能尽力而为并蓬勃发展。

---

### [01:10:29] Lenny Rachitsky

**English:**
Again, I usually don't spend time on this sort of thing, but I just think that what you're working on is extremely cool, and I think it's going to be really meaningful to a lot of people. And so, I just want to spend a few minutes giving you a chance to talk about what you're working on now. You started a company, is this your first company that you've started?

**中文翻译:**
再次强调，我通常不花时间聊这类事情，但我真的认为你正在做的事情非常酷，而且我认为它对很多人来说将非常有意义。所以，我想花几分钟给你一个机会谈谈你现在正在做的事情。你创办了一家公司，这是你创办的第一家公司吗？

---

### [01:10:45] Benjamin Lauzier

**English:**
It is, yeah.

**中文翻译:**
是的。

---

### [01:10:45] Benjamin Lauzier

**English:**
First real company. Doesn't accept projects, but first company.

**中文翻译:**
第一家真正的公司。不只是接项目，而是第一家公司。

---

### [01:10:48] Lenny Rachitsky

**English:**
Yeah, there's a LC, there's a C corp, or yeah, it's like filed. There's paperwork. Amazing. Talk about what you're building, how people know how to find it if it's right for them.

**中文翻译:**
是的，有 LLC，有 C Corp，或者已经注册了，有文书工作。太棒了。谈谈你在构建什么，如果人们觉得适合自己，该如何找到它。

---

### [01:10:59] Benjamin Lauzier

**English:**
Yeah, I have to say entrepreneurship has been a very humbling journey. I think the zero to one is way harder than anything us have done so far, and I feel like when you're used to building and scaling products within companies, you take for granted, at least I did, I take for granted that the problem space has already been validated. You have some brand equity, even if you launch a new vertical, there's an existing user base, there's a validation of the broader problem space. I think going to truly zero felt, at least to me, super overwhelming and lonely, but also super exciting with tons of condensed learnings. It's been a really interesting journey. So, what brought me there is my wife started to have some health issues about three years ago now, it's partially why we decided to move to France last year just for a couple of years.

**中文翻译:**
是的，我必须说创业是一段非常让人谦卑的旅程。我认为从 0 到 1 比我们到目前为止所做的任何事情都要难得多。我觉得当你习惯了在公司内部构建和扩展产品时，你会认为理所当然（至少我是这样），认为问题空间已经得到了验证。你有一些品牌资产，即使你推出了一个新的垂直领域，也有现有的用户群，有对更广泛问题空间的验证。我认为真正回到零，至少对我来说，感觉非常压抑和孤独，但也非常令人兴奋，有大量的浓缩学习。这是一段非常有趣的旅程。至于是什么把我带到这里的：我妻子大约三年前开始出现一些健康问题，这也是我们去年决定搬到法国住几年的部分原因。

---

### [01:11:47] Benjamin Lauzier

**English:**
And she's had this undiagnosed condition and chronic pain, and we saw just how much of a nightmare it was to manage her care and to navigate the healthcare system in the U.S. So, we'd wait three months for an appointment for a neurologist, then did see her for maybe eight minutes. Average appointment time in the U.S. is between 10 and 12 minutes. They'd dump a bunch of jargon, say like, "Hey, tests all look normal. Sorry, you should just go see this other specialist instead." Would wait another three months, see another specialist. And with a lot of anxiety, a lot of pain, as you can imagine, all those things, you have another eight minute slot with someone and you're like, "Oh, why didn't the neurologist do this test? I can help you, let's make some sense." And so, it ends up being incredibly isolating. The whole time we just felt completely alone.

**中文翻译:**
她患有这种未确诊的病症和慢性疼痛，我们亲眼目睹了在美国管理她的护理和应对医疗系统是多么的一场噩梦。我们要等三个月才能约到神经科医生，然后医生可能只看她八分钟。美国的平均就诊时间在 10 到 12 分钟之间。他们会抛出一堆术语，说：“嘿，检查结果看起来都很正常。抱歉，你应该去看另一个专科医生。”然后又要等三个月，看另一个专科医生。你可以想象，伴随着大量的焦虑和痛苦，你又得到了另一个八分钟的就诊机会，你会想：“噢，为什么神经科医生不做这个检查？我能帮你，让我们理清头绪。”所以，这最终让人感到极其孤立。整个过程中，我们感到完全孤立无援。

---

### [01:12:32] Benjamin Lauzier

**English:**
It was just like us and Google, we felt we kept getting conflicting advice from doctors, and I was spending all my time researching specialists, what solutions to consider, spend all my nights reading through research papers to [inaudible 01:12:48], "Hey, what is the academic consensus on this particular treatment that the doctors don't seem to know about?" And throughout this whole process it felt like no one really had her back, no one within the medical system was fighting for her the way that your family doctor might have fought for you 20 years ago, knowing everything about you and being like, "Lenny, let's talk about this. I know your uncle had this," or there's this sort of a sense of advocacy that came from your family doctor that just doesn't exist today. It's not uncommon for doctors to have thousands of patients that they see just a few minutes each year.

**中文翻译:**
只有我们和 Google。我们觉得不断从医生那里得到相互矛盾的建议，我花所有时间研究专家、考虑什么解决方案，整晚都在阅读研究论文以[听不清]：“嘿，医生们似乎不知道的这种特定疗法的学术共识是什么？”在整个过程中，感觉没有人真正支持她，医疗系统中没有人像 20 年前的家庭医生那样为她而战——那时候医生了解你的一切，会说：“Lenny，我们谈谈这个，我知道你叔叔得过这个病。”那种来自家庭医生的“倡导感”（Advocacy）在今天已经不存在了。医生每年有成千上万个病人，每个病人只看几分钟，这并不罕见。

---

### [01:13:19] Benjamin Lauzier

**English:**
And so digging into this, we just realized it's not an isolated case. You have nearly half of Americans have at least one chronic condition, or have to deal with some sort of complex health issue largely on their own. You see a lot of those large online communities revolving around chronic conditions or chronic pain, and trying to make sense of it and advocate for themselves. And I think I want to be clear, in my mind the problem is obviously not about the practitioners, it's systemic. It's just growing financial pressure from private equity firms, it's just countless other factors. But you see the physicians being overwhelmed, overworked, burning out, and you see that pressure just only increasing, I think. So, I basically spent the next six months just talking to hundreds of patients, and doctors, and experts, and what we built is basically a platform to help people fight for their health.

**中文翻译:**
深入研究后，我们意识到这并非个案。近一半的美国人患有至少一种慢性病，或者不得不基本上靠自己处理某种复杂的健康问题。你会看到很多围绕慢性病或慢性疼痛的大型在线社区，人们试图理清头绪并为自己争取权益。我想明确一点，在我看来，问题显然不在于从业者，而是系统性的。这只是来自私募股权公司日益增长的财务压力，以及无数其他因素。但你看到医生们不堪重负、过度劳累、职业倦怠，而且我认为这种压力只会不断增加。所以，我基本上花了接下来的六个月时间与数百名患者、医生和专家交谈，我们构建的基本上是一个帮助人们为自己的健康而战的平台。

---

### [01:14:12] Benjamin Lauzier

**English:**
And so, we want to close the gap between patients and the healthcare system. There's this critical layer of the system that's missing, I think, people are navigating life-threatening or debilitating conditions largely with Google, and at some point you just get tired of fighting for yourself. So, we connect people with complex conditions, typically with their own health advocate. So, it's essentially like their own health assistant. They're available 24/7 to help you navigate your care. So, we find appointments for you, we help you prepare your appointment, we make sense of a diagnosis, of test results. We spend hours researching solutions and potential treatments, and just more generally we do everything we can to help you just better advocate for themselves basically. And now we launched in the U.S. a early version of this few weeks ago, and the engagement has been really, really, really mind-blowing so far.

**中文翻译:**
所以，我们想缩小患者与医疗系统之间的差距。我认为系统中缺失了一个关键层，人们主要靠 Google 来应对危及生命或致残的疾病，而在某个时刻，你只是厌倦了为自己而战。所以，我们将患有复杂疾病的人与他们自己的健康倡导者（Health advocate）联系起来。这本质上就像是他们自己的健康助手。他们 24/7 全天候在线，帮助你处理护理事务。我们会为你找预约，帮你准备就诊，帮你理解诊断结果和检查结果。我们花数小时研究解决方案和潜在疗法，更广泛地说，我们尽一切努力帮助你更好地为自己争取权益。几周前我们在美国推出了一个早期版本，到目前为止，参与度真的非常非常惊人。

---

### [01:15:15] Benjamin Lauzier

**English:**
And we're helping cancer patients, people with a lot of those niche chronic conditions, and literally harassing the doctor's office like, "Hey, we still haven't received that referral." All the things that you just get tired of doing when you're dealing with so many appointments, and when you're having to manage a condition like this. And our mental model is what would we do if this user was our partner or our parent? You'd likely spend all night combing through research. You'd call all the providers in the state to be like, "Hey, who has an appointment?" Because there's no PT available for the next two months. We'll find you a PT available sooner. So, we're building the engine to do that at scale essentially, and make people feel like they're not alone and that someone is fighting for them.

**中文翻译:**
我们正在帮助癌症患者、患有很多小众慢性病的人，甚至会去“骚扰”医生办公室，比如：“嘿，我们还没收到那份转诊单。”当你处理这么多预约、不得不管理这样的病情时，这些都是你会厌倦去做的事情。我们的心理模型是：如果这个用户是我们的伴侣或父母，我们会怎么做？你可能会整晚埋头研究。你会给全州所有的医疗机构打电话问：“嘿，谁有空位？”因为接下来的两个月都没有可用的理疗师（PT）。我们会为你找到更早有空的理疗师。所以，我们正在构建一个大规模实现这一目标的引擎，让人们感到自己并不孤单，有人在为他们而战。

---

### [01:15:45] Lenny Rachitsky

**English:**
Super cool. It's sad that we need something like this, but we do, because the healthcare system is so not ideal. And so, it's basically someone in your corner that's just, it's like in the inside that knows how these things work that is there to help you through the process. What's the company called, where do people find it?

**中文翻译:**
超级酷。我们需要这样的东西是很悲哀的，但我们确实需要，因为医疗系统太不理想了。所以，这基本上是站在你这一边的人，就像是一个了解这些事情运作方式的内部人士，在那里帮助你完成整个过程。公司叫什么名字，人们在哪里可以找到它？

---

### [01:16:03] Benjamin Lauzier

**English:**
Yeah, it's called Nurra Health, and our website is Nurra, N-U-R-R-A.me.

**中文翻译:**
是的，它叫 Nurra Health，我们的网站是 Nurra.me (N-U-R-R-A.me)。

---

### [01:16:09] Lenny Rachitsky

**English:**
Awesome, and we'll link to it in the show notes. And just to be clear, I'm not an investor, I'm just excited about this thing. I think a lot of people need this. Just to loop back to what we've been talking about, it's not a marketplace. How would you describe this business in relation to marketplace companies?

**中文翻译:**
太棒了，我们会把它链接到节目介绍中。澄清一下，我不是投资者，我只是对这件事感到兴奋。我认为很多人需要这个。回到我们一直在谈论的话题，这目前还不是一个双边市场。你会如何描述这项业务与双边市场公司的关系？

---

### [01:16:22] Benjamin Lauzier

**English:**
We're ignoring the marketplace dynamics. I'm following my own advice, and I'm one jumpstarting one side of the marketplace, the health advocates were like jumpstarting this side for now, and we're only focusing on what I think is going be the hardest side for us, and it's going to be demand. How do we find those people? How do we create the right value proposition for them? So, that's what we're focused on.

**中文翻译:**
我们现在忽略了市场动态。我正在遵循我自己的建议：我正在启动市场的一侧，目前是在启动健康倡导者这一侧，我们只专注于我认为对我们来说最难的一侧，那就是需求侧。我们如何找到那些人？我们如何为他们创造正确的价值主张？这就是我们目前关注的。

---

### [01:16:44] Lenny Rachitsky

**English:**
And so, in the future there may be a marketplace component, is what I'm hearing?

**中文翻译:**
所以，我听到的是，未来可能会有双边市场的成分？

---

### [01:16:49] Benjamin Lauzier

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [01:16:50] Lenny Rachitsky

**English:**
Interesting. Very cool. Ben, is there anything else that you want to share, mention, leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
有趣。非常酷。Ben，在进入我们非常令人兴奋的闪电轮（Lightning round）之前，还有什么想分享、提及或留给听众的吗？

---

### [01:16:59] Benjamin Lauzier

**English:**
No, no. Thank you.

**中文翻译:**
没有了，谢谢。

---

### [01:17:01] Lenny Rachitsky

**English:**
Well, with that, we've reached our very exciting lightning round. Ben, are you ready?

**中文翻译:**
那么，我们进入了非常令人兴奋的闪电轮。Ben，准备好了吗？

---

### [01:17:06] Benjamin Lauzier

**English:**
I'm ready, let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [01:17:08] Lenny Rachitsky

**English:**
All right. First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
好的。第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:17:14] Benjamin Lauzier

**English:**
I'll give you books in different directions. One is Misbehaving: The Makings of Behavioral Economics. I'm really interested in behavioral economics, I love this intersection between economics and human psychology. It's a great analogy for product, so that's a great introduction to this field. The second book that I recommend a lot is Range: Why Generalists Triumph in a Specialized World, by David Epstein. I've always felt curious about a lot of things, but it's made me feel like I'm decent at many things but I'm good at nothing. I'm very good at nothing. And so, even in my career I see all those pianists who are like machine learning gurus leading conferences on weekends that are contributing to think tanks, I just felt like a generalist.

**中文翻译:**
我给你推荐几个不同方向的书。第一本是《错误的行为》（Misbehaving: The Makings of Behavioral Economics）。我对行为经济学非常感兴趣，我喜欢经济学和人类心理学的交集。这是对产品的一个很好的类比，所以它是进入该领域的一个很好的入门读物。第二本我经常推荐的书是《范围》（Range: Why Generalists Triumph in a Specialized World），作者是 David Epstein。我一直对很多事情感到好奇，但它让我觉得我擅长很多事情，却精通不了任何事情。我什么都不精通。所以，即使在我的职业生涯中，我看到那些像机器学习大师一样的 PM，周末主持会议，为智库做贡献，我只是觉得自己是个通才。

---

### [01:17:55] Benjamin Lauzier

**English:**
So, if you feel this way, this is a good book to make you feel a little bit better by yourself and your imposter syndrome. At least it did for me. And last one, nothing to do with business, but Immune, by Philipp Dettmer. This is the creator of the YouTube channel Kurzgesagt. I don't know if I'm pronouncing this right, but it's a science channel. If you're even remotely curious about how your body works, how your immune system works, it's an amazing book that's really, really fun to read, super entertaining, and just great biology and fun book, I promise.

**中文翻译:**
所以，如果你也有这种感觉，这是一本能让你对自己和“冒充者综合征”（Imposter syndrome）感觉好一点的好书。至少对我来说是这样。最后一本与业务无关，是 Philipp Dettmer 的《免疫》（Immune）。他是 YouTube 频道 Kurzgesagt 的创始人。我不知道我发音对不对，那是一个科学频道。如果你对身体如何运作、免疫系统如何运作哪怕有一点点好奇，这是一本非常非常有趣的惊人之作，极具娱乐性，而且生物学知识很棒，我保证这是一本有趣的书。

---

### [01:18:26] Lenny Rachitsky

**English:**
I've been trying to get the author of Range on the podcast, I have not had success yet. So, if anyone knows him, his name is Epstein? Is that right?

**中文翻译:**
我一直想请《范围》的作者上播客，但还没成功。如果有人认识他，他叫 Epstein？对吗？

---

### [01:18:34] Benjamin Lauzier

**English:**
Yes. David Epstein.

**中文翻译:**
是的，David Epstein。

---

### [01:18:36] Lenny Rachitsky

**English:**
David Epstein, please connect me. I would love to have him on the podcast. I really love his message of just, basically it's the most successful people, or is it that you should be a generalist or that you can be very successful as a generalist? Is that the message?

**中文翻译:**
David Epstein，请帮我引荐。我很想请他上播客。我真的很喜欢他的观点，基本上是说最成功的人，或者是你应该成为通才，还是说作为通才也可以非常成功？是这个意思吗？

---

### [01:18:50] Benjamin Lauzier

**English:**
You can be very successful as a generalist. Yes.

**中文翻译:**
作为通才你可以非常成功。是的。

---

### [01:18:51] Lenny Rachitsky

**English:**
Yeah, great. I completely agree. That's been me too. Next question, do you have a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
是的，太棒了。我完全同意。我也是这样。下一个问题：你最近有没有特别喜欢的电影或电视剧？

---

### [01:18:58] Benjamin Lauzier

**English:**
TV show? I haven't seen anything lately that's been mind-blowing, but I'll share an old new one. I've rewatched The Last of Us recently, and it's an old favorite. I love the TV show. I like the game, I played the game many years ago, and love the TV show

**中文翻译:**
电视剧？我最近没看到什么让人惊艳的东西，但我分享一个“老的新剧”。我最近重温了《最后生还者》（The Last of Us），那是我的老最爱。我喜欢这部剧。我喜欢那个游戏，很多年前玩过，也非常喜欢这部剧。

---

### [01:19:12] Lenny Rachitsky

**English:**
When the heck's the next season coming up? I'm excited for that. Because I know the game has more-

**中文翻译:**
下一季到底什么时候出？我很期待。因为我知道游戏还有更多内容——

---

### [01:19:12] Benjamin Lauzier

**English:**
2025.

**中文翻译:**
2025 年。

---

### [01:19:16] Lenny Rachitsky

**English:**
2025. Oh man, so long. Okay, good to know though. Next question, do you have a favorite product you recently discovered that you really love?

**中文翻译:**
2025 年。天哪，太久了。好吧，知道了。下一个问题：你最近发现并非常喜欢的某个产品是什么？

---

### [01:19:25] Benjamin Lauzier

**English:**
Maybe a little bit behind the curve on this one, but I've been loving the Arc browser. I don't know if you use it, but it's been-

**中文翻译:**
在这方面我可能有点落后了，但我一直很喜欢 Arc 浏览器。我不知道你是否在用，但它一直——

---

### [01:19:32] Lenny Rachitsky

**English:**
Oh, I love Arc. It's my number one, my main browser. Absolutely, I love it.

**中文翻译:**
噢，我爱 Arc。它是我的首选，我的主浏览器。绝对喜欢。

---

### [01:19:36] Benjamin Lauzier

**English:**
Amazing. All right, so yeah, you know all about it. Yeah, it's been really fun.

**中文翻译:**
太棒了。好吧，看来你很了解。是的，它真的很有趣。

---

### [01:19:41] Lenny Rachitsky

**English:**
Yeah, just the onboarding of the Arc browser is such a lesson in onboarding. They do such an amazing job. It's like that alone is a great thing to do as a product person, just see how they do onboarding.

**中文翻译:**
是的，Arc 浏览器的入职流程（Onboarding）简直是一堂入职流程课。他们做得太棒了。仅仅是这一点，作为产品人就值得去看看他们是怎么做入职流程的。

---

### [01:19:52] Benjamin Lauzier

**English:**
I was like, I've been using Chrome for 12 years, or I don't know how many years, it feels like such high friction to change my entire life. In eight seconds it was done, it felt like home. I was like, "Wow, this is way faster than I expected."

**中文翻译:**
我想，我已经用了 12 年 Chrome 了，或者不知道多少年，改变我的整个生活习惯感觉阻力很大。结果八秒钟就搞定了，感觉像回到了家。我想：“哇，这比我想象的要快得多。”

---

### [01:20:05] Lenny Rachitsky

**English:**
Two more questions. Do you have a favorite motto that you often come back to or repeat yourself, share with friends or family?

**中文翻译:**
最后两个问题。你有没有一句经常想起或重复，并分享给朋友或家人的座右铭？

---

### [01:20:11] Benjamin Lauzier

**English:**
I don't have anything particularly philosophical, unfortunately. I lived in [inaudible 01:20:16] for a few years. I live now in the French Alps, so I have a frame with a John Muir's quote, "The mountains are calling and I must go." I feel like this is, it's my grounding place. The mountains are my happy place, and so I don't share that work often. I don't peace out in the middle of meetings like, "The mountains are calling, I must go." But it's been a grounding motto, I guess, for me.

**中文翻译:**
遗憾的是，我没有什么特别富有哲理的话。我在[听不清]住了几年。我现在住在法国阿尔卑斯山，所以我有一个相框，上面写着约翰·缪尔（John Muir）的名言：“大山在呼唤，我必须出发。”我觉得这就是我的归宿。大山是我的快乐之地，所以我不会经常在工作中分享这个。我不会在会议中途突然说：“大山在呼唤，我必须出发”然后溜走。但对我来说，这是一句让我感到踏实的座右铭。

---

### [01:20:38] Lenny Rachitsky

**English:**
That's beautiful. My nervous system relaxes just hearing that quote, and I know you live in a mountainy part of France so you've done it, you've listened to the call. Final question. You live in France, the Olympics were just in Paris. Did you go to any of the games? Did you watch any of the games? Anything stand out to you about the Olympics that were not so far from where you are now?

**中文翻译:**
太美了。听到这句话我的神经系统都放松了。我知道你住在法国的山区，所以你已经做到了，你听从了呼唤。最后一个问题：你住在法国，奥运会刚刚在巴黎举行。你去现场看了吗？或者看了比赛吗？关于离你现在住的地方不远的奥运会，有什么让你印象深刻的吗？

---

### [01:21:02] Benjamin Lauzier

**English:**
Good question. I did not see any live events, unfortunately. Perhaps the highlight for me was I'm a big mountain biker, but in the biking realm I love the Men BMX event where all three men on the podium were French, so this was a great moment for France.

**中文翻译:**
好问题。遗憾的是，我没去现场看任何比赛。对我来说，亮点可能是——我是一个资深山地自行车爱好者——在自行车领域，我喜欢男子小轮车（BMX）比赛，领奖台上的三名选手都是法国人，这对法国来说是一个伟大的时刻。

---

### [01:21:25] Lenny Rachitsky

**English:**
I didn't even know that was an Olympic sport. So, it's a BMX, like dirt bike kind of race.

**中文翻译:**
我甚至不知道那是奥运项目。所以那是 BMX，像越野自行车那样的比赛。

---

### [01:21:32] Benjamin Lauzier

**English:**
Yeah, yeah.

**中文翻译:**
是的，是的。

---

### [01:21:33] Lenny Rachitsky

**English:**
So cool. Amazing. Ben, thank you so much for being here. Two final questions, where can folks find you online, and what else are you doing that people can check out if they want to learn more? And how can listeners be useful to you?

**中文翻译:**
太酷了。太棒了。Ben，非常感谢你能来。最后两个问题：大家可以在哪里在线找到你？如果你还有其他事情想让大家了解，可以在哪里查看？听众可以为你提供什么帮助？

---

### [01:21:46] Benjamin Lauzier

**English:**
Yeah, you can find me, two things that are perhaps helpful for people out there. One is I have a Reforge course if you're curious about marketplace, if you want to dig deeper into marketplace growth, I have a course on Reforge. We're about to do our fifth or sixth cohort I think now. It's been going really well, we've been working with tons of really, really cool marketplaces, going much deeper into some of the topics that we just talked about. So, if you're interested in marketplaces, I would say check this out.

**中文翻译:**
好的，你可以找到我。有两件事可能对大家有帮助。一是我有一个 Reforge 课程，如果你对双边市场感兴趣，想深入研究市场增长，我在 Reforge 有一门课。我想我们现在正要开始第五或第六期了。进展一直很好，我们与大量非常酷的市场合作，深入探讨了我们刚才谈到的一些话题。所以，如果你对双边市场感兴趣，我建议去看看。

---

### [01:22:13] Lenny Rachitsky

**English:**
And on that real quick, is the customer ideal, is it founders or is it like PMs at larger marketplace companies? Who is this perfect for?

**中文翻译:**
快速插一句，理想的客户是创始人，还是大型市场公司的 PM？这最适合谁？

---

### [01:22:23] Benjamin Lauzier

**English:**
We've had both founders and PMs, and like a heads of product, but it's my strong recommendation it's people that have product market fit. Per our conversation, if you don't have product market fit, wait a little bit before enrolling in this course. Focus on your core business before worrying about the marketplace dynamics aspect.

**中文翻译:**
我们既有创始人也有 PM，还有产品负责人。但我强烈建议是那些已经达到 PMF 的人。根据我们的谈话，如果你还没有达到 PMF，请等一段时间再报名这门课。在担心市场动态方面之前，先专注于你的核心业务。

---

### [01:22:44] Lenny Rachitsky

**English:**
And I cut you off, there's something else you were going to point people to?

**中文翻译:**
我打断你了，你刚才还要向大家推荐什么？

---

### [01:22:47] Benjamin Lauzier

**English:**
Oh, and just Nurra, the company that we're building. Anyone that you know, or if you yourself have chronic or complex conditions, and if you feel like you need help managing your health and navigating your care, would love to help or share what you need, and how we can help you. And our website is Nurra.me, N-U-R-R-A.me.

**中文翻译:**
噢，还有就是 Nurra，我们正在建立的公司。如果你认识任何人，或者你自己患有慢性或复杂疾病，如果你觉得在管理健康和应对护理方面需要帮助，我们很乐意提供帮助，或者分享你的需求以及我们如何能帮到你。我们的网站是 Nurra.me (N-U-R-R-A.me)。

---

### [01:23:09] Lenny Rachitsky

**English:**
And then how can listeners be useful to you?

**中文翻译:**
那么听众可以为你提供什么帮助？

---

### [01:23:11] Benjamin Lauzier

**English:**
If you have advice, if you know anyone in the space, if you're interested in learning more about this, if you have advice, if you have learnings, if you know anything about this I would love to hear it. If you have hot takes about marketplace, if you disagree with any of what I've said, I'd love to also hear it.

**中文翻译:**
如果你有建议，如果你认识这个领域的任何人，如果你有兴趣了解更多，如果你有心得，如果你知道关于这方面的任何事情，我很想听听。如果你对双边市场有犀利的见解，或者如果你不同意我说的任何话，我也很想听听。

---

### [01:23:25] Lenny Rachitsky

**English:**
I love it. Ben, thank you so much for being here.

**中文翻译:**
我喜欢。Ben，非常感谢你能来。

---

### [01:23:30] Benjamin Lauzier

**English:**
Thank you so much for having me, it's been a dream come true. Finally, I'm on this podcast.

**中文翻译:**
非常感谢你邀请我，这真是梦想成真。终于，我上了这个播客。

---

### [01:23:34] Lenny Rachitsky

**English:**
Same. Same for me, Ben. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
我也一样，Ben。再见，各位。非常感谢收听。如果你觉得这很有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。