# Bill Carr - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Bill Carr.

---

### [00:00:00] Bill Carr

**English:**
... Jeff would say, we took it as an article of faith. If we served customers well, if we prioritized customers and delivered for them, things like sales, things like revenue and active customers and things like the share price and free cash flow would follow. So therefore, when we're making a decision thinking about a problem, we're going to start with what's best for the customer and then come backward from there. That informs what's the work you have to do to then create this new solution for customers.

**中文翻译:**
……杰夫（贝佐斯）会说，我们将其视为一种信念。如果我们服务好客户，如果我们优先考虑客户并为他们提供价值，那么销售额、收入、活跃客户数以及股价和自由现金流等自然会随之而来。因此，当我们做决定或思考问题时，我们会从“什么对客户最好”开始，然后以此为终点向后推导。这决定了你为了给客户创造这种新解决方案而必须开展的工作。

---

### [00:00:33] Lenny

**English:**
Today my guest is Bill Carr. Bill is the co-author of the book Working Backwards, which is a synthesis of the biggest lessons that Bill and his co-author learned from their many years at Amazon. Bill joined Amazon just five years after it was founded, stayed there for 15 years where he worked on the books business, and then as VP of Digital Media, launched and managed the company's global digital music and video businesses, including Amazon Music, Prime Video, and Amazon Studios. After Amazon, Bill was an executive in residence at Maveron, an early stage VC firm, then chief operating officer at OfferUp. And these days, Bill runs a consulting firm called Working Backwards, LLC, where he and his co-authored, Colin Breyer, help growth stage and public companies implement the many practices developed at Amazon.

**中文翻译:**
今天的嘉宾是 Bill Carr。Bill 是《逆向工作法》（Working Backwards）一书的合著者，该书总结了 Bill 和他的合著者在亚马逊工作多年学到的最重要教训。Bill 在亚马逊成立仅五年后就加入了公司，并在那里工作了 15 年。他最初负责图书业务，后来担任数字媒体副总裁，启动并管理了公司的全球数字音乐和视频业务，包括 Amazon Music、Prime Video 和 Amazon Studios。离开亚马逊后，Bill 曾在早期风投公司 Maveron 担任驻点高管，随后担任 OfferUp 的首席运营官。如今，Bill 经营着一家名为 Working Backwards, LLC 的咨询公司，他与合著者 Colin Breyer 一起，帮助成长型公司和上市公司实施亚马逊开发的各种实践方法。

---

### [00:01:20] Lenny

**English:**
In our conversation, we go many levels deep on how to actually implement a number of the practices and ways of working that helped Amazon become the success that it is today, including the process of how to actually work backwards, how to organize your team with a single-threaded leader, how to divide up your metrics into input and output metrics, how to practice disagreeing and committing, how to implement the Bar Raiser program in your hiring process and so much more.

**中文翻译:**
在我们的对话中，我们将深入探讨如何实际落地那些助力亚马逊取得今日成就的实践和工作方式，包括：如何真正执行“逆向工作”流程、如何通过“单线程领导者”（single-threaded leader）来组织团队、如何将指标划分为“投入指标”和“产出指标”、如何践行“表达异议并执行”（disagree and commit）、如何在招聘流程中实施“Bar Raiser”（人才准入门槛提升者）计划等等。

---

### [00:01:47] Lenny

**English:**
Huge thank you to Ethan Evans for making this episode possible and introducing me to Bill. With that, I bring you Bill Carr, after a short word from our sponsors.

**中文翻译:**
非常感谢 Ethan Evans 促成了本期节目并向我介绍了 Bill。在听完赞助商的简短介绍后，我们将正式请出 Bill Carr。

---

### [00:01:58] Lenny (Sponsor: Assembly AI)

**English:**
Today's episode is brought to you by Assembly AI. If you're looking to build AI powered features in your audio and video products, then you need to know about Assembly AI, which makes it easy to transcribe and understand speech at scale. What I love about assembly AI is you can use their simple API to access the latest AI breakthroughs from top tier research labs, product team to startups and enterprises are using Assembly AI to automatically transcribe and summarize phone calls and virtual meetings, detect topics in podcasts, pinpoint when sensitive content spoken and lots more. All of Assembly AI's models which are accessed through their API are production ready. So many PMs I know are considering or already building with AI, and Assembly AI is the fastest way to build with AI for audio use cases. Now's the time to check out Assembly AI... Visit assemblyai.com/lenny to try their API for free.

**中文翻译:**
本期节目由 Assembly AI 赞助。如果你正寻求在音视频产品中构建 AI 驱动的功能，那么你需要了解 Assembly AI，它能让你轻松实现大规模的语音转录和理解。我最喜欢 Assembly AI 的一点是，你可以通过他们简单的 API 访问来自顶级研究实验室的最新 AI 突破。从初创公司到大型企业的产品团队都在使用 Assembly AI 来自动转录和总结电话及虚拟会议、检测播客主题、精准识别敏感内容等等。Assembly AI 所有通过 API 访问的模型都是生产级别的。我认识的许多产品经理都在考虑或已经开始使用 AI 进行构建，而 Assembly AI 是在音频场景中使用 AI 构建的最快方式。现在就去 assemblyai.com/lenny 免费试用他们的 API 吧。

---

### [00:03:07] Lenny (Sponsor: Coda)

**English:**
This episode is brought to you by Coda. You've heard me talk about how Coda is the doc that brings it altogether and how it can help your team run smoother and be more efficient. I know this firsthand because Coda does that for me. I use Coda every day to wrangle my newsletter content calendar, my interview notes for podcasts, and to coordinate my sponsors... If your team's work is spread out across different documents and spreadsheets and a stack of workflow tools, that's why you need Coda. Coda puts data in one centralized location regardless of format, eliminating roadblocks that can slow your team down... Sign up today at coda.io/lenny and get a thousand dollars starter credit on your first statement.

**中文翻译:**
本期节目由 Coda 赞助。你听我多次提到过 Coda 是一个能将所有内容整合在一起的文档工具，它能让你的团队运行更顺畅、更高效。我有切身体会，因为 Coda 就在帮我处理这些。我每天都用 Coda 来管理我的简报内容日历、播客访谈笔记以及协调赞助商……如果你们团队的工作分散在不同的文档、表格和一堆工作流工具中，那么你正需要 Coda。Coda 将数据集中在一个地方，无论格式如何，消除了可能拖慢团队进度的障碍……今天就在 coda.io/lenny 注册，首张账单可获得 1000 美元的启动抵扣额度。

---

### [00:04:26] Lenny

**English:**
Bill, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Bill，非常感谢你能来，欢迎来到本播客。

---

### [00:04:30] Bill Carr

**English:**
Thanks, Lenny. Thanks so much for having me. Pleasure to be here.

**中文翻译:**
谢谢 Lenny。非常感谢你的邀请，很高兴来到这里。

---

### [00:04:32] Lenny

**English:**
It's my pleasure. So, I was reading your book, and something that I recognized as I was going through this is just how many new ways of working Amazon contributed to the way tech and business runs. And I made this little list, and I'm curious if there's anything I'm forgetting that's obvious. So, obviously the idea of working backwards, the idea of one way and two way door decisions, the concept of disagreeing and committing input and output metrics using memos versus decks, just the idea of two pizza teams, and then I know that evolved into single-threaded leaders. Is there anything else that's just like an obvious core thing that's maybe almost too obvious that I don't even think about that Amazon contributed?

**中文翻译:**
这是我的荣幸。我在读你的书时意识到，亚马逊为科技和商业运作贡献了如此多全新的工作方式。我列了一个小清单，好奇我是否遗漏了什么显而易见的东西。清单包括：逆向工作法（Working Backwards）、单向门和双向门决策（one-way and two-way door decisions）、表达异议并执行（disagree and commit）、投入与产出指标（input and output metrics）、使用备忘录而非 PPT（memos vs decks）、“两个披萨团队”（two-pizza teams），我知道后来演变成了“单线程领导者”。还有什么核心的东西是亚马逊贡献的，甚至因为太理所当然而让我忽略了的吗？

---

### [00:05:10] Bill Carr

**English:**
The one that's non-obvious and is really the way in which Amazon created a set of leadership principles that were very real, and the way in which Amazon created a set of processes to reinforce them. I think I certainly haven't encountered anything quite like that. It was very intentional. So, that is also a distinctive element of that we try to point out in our book.

**中文翻译:**
有一个不太明显但非常关键的，就是亚马逊创建了一套非常真实且落地的“领导力准则”（Leadership Principles），并建立了一套流程来强化这些准则。我想我还没遇到过类似的东西。这是非常有意识的行为。所以，这也是我们在书中试图指出的一个独特元素。

---

### [00:06:13] Lenny

**English:**
Awesome. Okay. So, maybe we will come back to that, because that is also really powerful mechanism. So, the question I wanted to ask about this is there are companies that are bigger than Amazon, that are more successful than Amazon, that have been around longer than Amazon, but I don't think any other company has contributed so many unique, new ways of working and also been able to coin them into such shareable ways. What would you say it is about Amazon that enables this sort of way of working and also just making things so just proliferate through the culture?

**中文翻译:**
太棒了。我们稍后可能会回到这个话题，因为那也是一个非常强大的机制。我想问的是，虽然有些公司比亚马逊规模更大、更成功或历史更悠久，但我认为没有哪家公司贡献了这么多独特的工作方式，并能将它们总结成如此易于传播的术语。你认为亚马逊有什么特质，能让这种工作方式产生并使其在文化中如此广泛地传播？

---

### [00:06:41] Bill Carr

**English:**
That's actually one of the reasons why Colin and I set out to write our book because everyone knows about Amazon as a innovative product company... The Kindle, AWS, Alexa, Echo, the Prime subscription itself is innovative... But what people don't realize is that Amazon was actually, to some degree, equally focused on process innovation. In many cases, by the way, we stood on other people's shoulders... But to more directly answer your question, how or why did this happen. So, this period of both product and process innovation actually occurred in this one narrow window of 2003 to 2007. During that window of time, all of the products I just mentioned and all of the processes except for one were all developed in this one four year period.

**中文翻译:**
这实际上也是我和 Colin 决定写这本书的原因之一。大家都知道亚马逊是一家创新的产品公司……Kindle、AWS、Alexa、Echo，甚至 Prime 订阅本身都是创新的……但人们没意识到的是，亚马逊在某种程度上同样专注于“流程创新”。顺便说一下，很多情况下我们也是站在巨人的肩膀上。更直接地回答你的问题：这一切是如何以及为何发生的。实际上，产品创新和流程创新的爆发都发生在一个狭窄的窗口期，即 2003 年到 2007 年。在那段时间里，我刚才提到的所有产品以及除了一个流程之外的所有管理流程，都是在这短短四年内开发出来的。

---

### [00:07:53] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:07:54] Bill Carr

**English:**
And this is the period actually where we were going from hypergrowth stage, zero to one company, to what I would call one to whatever, a thousand, infinity. That next step that companies have to make where what happens is things become very complex... The CEO can no longer be in every important meeting... And Jeff Bezos is fundamentally, he's a very scientific and analytical thinker... He applied this... When he thought about this problem, he said, "Well, I need to be scientific about this. There needs to be some system or some approach, some mechanism for me to be able to manage such a company. So, I'm going to experiment, like a scientist would, with different ideas, different hypotheses, implement them and see what works, and iteratively improve."

**中文翻译:**
那段时期正是我们从超高速增长的“从 0 到 1”阶段，迈向“从 1 到 1000 甚至无穷大”的阶段。这是公司必须跨越的下一步，此时事情会变得非常复杂……CEO 不再可能参加每一个重要会议……而杰夫·贝佐斯从根本上说是一个非常科学和理性的思考者。当他思考这个问题时，他说：“我需要科学地对待这件事。必须有一套系统、方法或机制让我能够管理这样一家公司。所以，我要像科学家一样，用不同的想法和假设进行实验，实施它们，观察效果，然后迭代改进。”

---

### [00:09:55] Lenny

**English:**
Awesome. I had Eric Ries on, and he also happened... I thought about this at the same time, he contributed a lot of core concepts to the way tech worked, and he actually brought up a couple concepts that were on the cutting room floor, basically things that he thought would be things people adopt everywhere. And I'm curious, is there an example of that at Amazon where you built a process and had this clever term for it and just never spread or never actually worked at Amazon? Anything come to mind?

**中文翻译:**
太棒了。我曾邀请过 Eric Ries（《精益创业》作者），他也为科技行业的工作方式贡献了许多核心概念。他提到过一些被“弃用”的概念，即他原本以为会被广泛采用但实际上没有的东西。我很好奇，亚马逊有没有这样的例子？你们建立了一个流程，起了一个聪明的名字，但最终没有传播开来，或者在亚马逊内部也没奏效？

---

### [00:10:20] Bill Carr

**English:**
The dev team, the design team, the product team, they're all in one group, and they'll go operate autonomously... So, we're going to create something called a fitness function, which was let's figure out what are the four or five or six metrics that matter most for your particular area. Let's give a weighting to all of them and then let's create an index for those, and we'll measure that index up and down. And that's the fitness function.

**中文翻译:**
当时开发、设计和产品团队都在一个组里，自主运作。我们创建了一个叫“适应度函数”（fitness function）的东西，即找出对你特定领域最重要的四五个指标，给它们分配权重，然后创建一个综合指数，通过观察这个指数的升降来衡量表现。这就是适应度函数。

---

### [00:10:52] Lenny

**English:**
That is a very nerdy way of organizing teams. I love it.

**中文翻译:**
这真是一种非常“极客”的团队组织方式。我喜欢。

---

### [00:10:55] Bill Carr

**English:**
Yeah, super nerdy. But we realized after, I don't know how long, several months or a year of doing this, so the fitness function was not a good idea. This is what I would describe as a compound metric where you try to take several important metrics and munge them into one. The problem is it's actually becomes totally meaningless. When you're measuring things, you're trying to understand what actions or reactions are creating the good outputs that you want, revenue, customer growth. But by putting them all together, you basically obfuscate that. And what really we realized is we need to just break each one of these out individually and manage them each in its own way. So today, I discouraged teams and companies from creating any sort of compound metrics.

**中文翻译:**
是的，超级极客。但做了几个月或一年后，我们意识到“适应度函数”并不是个好主意。这就是我所说的“复合指标”，即试图将几个重要指标揉成一个。问题在于，这实际上变得毫无意义。当你衡量事物时，你是想了解哪些行动或反应创造了你想要的良好产出（如收入、客户增长）。但把它们混在一起，基本上就模糊了因果关系。我们意识到，我们需要把每个指标单独拆解出来，以各自的方式进行管理。所以今天，我反对团队和公司创建任何形式的复合指标。

---

### [00:11:44] Lenny

**English:**
I've done that once, and it was a terrible idea as well... Let's actually go deeper into the single threaded leader piece since you mentioned it. It's actually come up a lot on this podcast of people working this way where they have a single threaded leader. And so clearly, it's worked. And I guess we'll just help people understand what does a single threaded leader actually mean, and then why is it such an effective way of working.

**中文翻译:**
我也做过一次，效果也很糟糕……既然你提到了，我们深入探讨一下“单线程领导者”（single-threaded leader）。这个概念在我的播客中经常出现，显然它很奏效。我想请你帮大家理解，单线程领导者到底意味着什么，以及为什么它是一种如此高效的工作方式。

---

### [00:12:23] Bill Carr

**English:**
So, the concept of single-threaded leadership was first... born from this time of complexity at Amazon... Once you get to a certain scale, you get to a point of where there are competing departments... competing for some centralized pool of resources... engineering resources, or today, data science and AI resources... Most companies solve this by having an intense, centralized, highly collaborative process. We decided to go in the other direction... we're spending all our time in these meetings, planning... what we realized instead was how do we get... ownership, speed and agility. And so, we experimented with that and said, "Let's create teams that can stand alone, where there's a single leader and the cross-functional resources that they need are all either directly report to them or are dedicated to them."

**中文翻译:**
单线程领导力的概念诞生于亚马逊变得复杂的时期。一旦达到一定规模，就会出现部门竞争，争夺中央资源池，比如工程资源，或者现在的数科和 AI 资源。大多数公司通过强化中央集权、高度协作的流程来解决这个问题。我们决定反其道而行之，因为我们发现自己把所有时间都花在了开会和计划上。我们意识到我们需要的是：所有权（ownership）、速度和敏捷性。于是我们实验并提出：“让我们创建能够独立存在的团队，由一名领导者负责，且他们所需的跨职能资源要么直接向其汇报，要么专门分配给他们。”

---

### [00:14:24] Bill Carr

**English:**
So, we've moved from what we called a project orientation to a program orientation... A project orientation means, oh, we are going to do this project to change our search result page... The resources will come and swarm on that, and then they'll move off to some other thing... The program based orientation says... There's a team that works on search, and they always work on search... They have a set of metrics by which they're looking to drive those metrics... Things like what percent of the time is a customer clicking on one of the top three results... And they then are running their own roadmap.

**中文翻译:**
所以，我们从所谓的“项目导向”转向了“项目群/长期计划导向”（program orientation）。项目导向意味着，我们要做一个项目来改变搜索结果页面，资源会涌向那里，完成后再转移到其他地方。而基于 Program 的导向是说，有一个团队专门负责搜索，而且永远负责搜索。他们有一套自己驱动的指标，比如客户点击前三个结果的比例。然后，他们运行自己的路线图（roadmap）。

---

### [00:15:54] Bill Carr

**English:**
And so, the benefit of this is if there are success or failures, they're really dependent on themselves now... this way, it also solves a big management problem, which is instead of management, senior management refereeing every item on a roadmap, they're refereeing which teams have how many resources, which is more of like a once or twice or three times a year decision versus refereeing everything on the product roadmap.

**中文翻译:**
这样做的好处是，成功或失败现在真正取决于他们自己。这也解决了一个重大的管理问题：高层管理人员不再需要对路线图上的每一个细项进行仲裁，而是仲裁哪些团队拥有多少资源。这更像是每年做一两次或三次的决策，而不是每天去纠结产品路线图上的琐事。

---

### [00:16:56] Bill Carr

**English:**
And then all the resource contention issues, that's a daily issue. And so, it frees teams up then to actually go and sprint ahead... Once we moved to a service-based architecture, and then teams could own their code with defined endpoints, APIs that other teams could understand that are well-documented, then we could move in that direction. And the other thing is we had to create, what I would call, countermeasures because there's no free lunch in org structures... you're trading off potentially functional excellence... if you no longer have every single engineer... reporting into a C-level leader of that particular function... you risk the problem of then the people in those teams not gaining functional competency.

**中文翻译:**
资源争夺是日常问题。这种模式让团队能够解脱出来去冲刺。当我们转向基于服务的架构（SOA），团队拥有带明确端点和文档化 API 的代码后，我们才能朝这个方向迈进。另一件事是，我们必须建立我所说的“对策”，因为组织架构中没有免费的午餐。你可能在牺牲“职能卓越性”。如果工程师不再向该职能的 C 级领导汇报，而是分散在小团队中向通才汇报，你就会面临团队成员无法提升职能专业能力的风险。

---

### [00:18:07] Lenny

**English:**
To drill into this a little bit further, is the origin of this, this recognition at Amazon that the best stuff comes from one person's vision and just one person driving and one person's ask being on the line versus the often, the decision by committee approach?

**中文翻译:**
进一步探讨一下，这种做法的起源是否是因为亚马逊意识到，最好的东西往往源于一个人的愿景、一个人的推动以及一个人的责任担当，而不是通常那种“委员会式”的决策方式？

---

### [00:18:24] Bill Carr

**English:**
It is less about that. I do want to be clear, it's one leader and their team who are accountable and responsible... Now, they don't just get to go off and do that. There was an intense review process at Amazon where either at some level... this plan would be reviewed and scrutinized deeply... getting alignment between the senior leadership team and each one of these single-threaded teams on that plan before the team could go off and run. The beauty of that though is that once we'd had those discussions... then the teams were free to sprint hard after their plan.

**中文翻译:**
倒不完全是那样。我想明确一点，是一领导者及其团队负责并承担责任。但他们不能直接就去干。亚马逊有严格的评审流程，在某个层级上，计划会被深度审查和质询，在高管团队和每个单线程团队之间达成一致后，团队才能开始运作。这种方式的妙处在于，一旦讨论结束并达成一致，团队就可以心无旁骛地朝着计划全力冲刺。

---

### [00:20:15] Lenny

**English:**
I like that. I like metaphor of pushing on a string. Is this approach similar to just the GM model, or is there a big difference when someone's thinking about going GM model versus the single-threaded leader approach?

**中文翻译:**
我喜欢那个“推绳子”的比喻。这种方法和传统的 GM（总经理）模式类似吗？还是说当人们考虑 GM 模式与单线程领导者模式时，两者有很大区别？

---

### [00:20:27] Bill Carr

**English:**
Yeah. Obviously, there are probably different definitions of what people consider the GM model, but I would consider that being this person is a P&L owner... one of the three questions you have to ask when you establish one of these teams is, does the team have the resources within their control to effectively manage this part of this department, this product, this P&L? ... A great example, this was in Prime Video... we could create a single-threaded team who just was working on applications for TV sets... another team that's working on game consoles... In those cases, then it's very clear how you can break the teams down and they can have very clear ownership.

**中文翻译:**
是的。显然，人们对 GM 模式有不同的定义，但我认为它意味着这个人是损益（P&L）负责人。建立这种团队时必须问的三个问题之一是：该团队是否拥有其控制范围内的资源，来有效管理该部门、产品或损益？Prime Video 就是个好例子：我们可以创建一个单线程团队专门负责电视端应用，另一个负责游戏机端。在这种情况下，如何拆分团队以及如何界定清晰的所有权就非常明确了。

---

### [00:22:06] Lenny

**English:**
Awesome. Let's go back to the countermeasures topic... What are some other things that you think you need to put in place to be successful in trying to shift to this model?

**中文翻译:**
太棒了。回到“对策”这个话题……你认为要成功转向这种模式，还需要建立哪些机制？

---

### [00:22:26] Bill Carr

**English:**
The other thing was these functional countermeasures... I started managing a small team of software engineers at that point. Well, I have never... Well, I have written lines of code, but that would be back in high school... I'm a generalist, okay? So, I'm not equipped to coach. I couldn't possibly conduct a code review... So, what we did... we came up with various countermeasures. One example was that we still had a C-level leader of engineering in Rick Dalzell... Rick still could be a technical leader for the whole company and he and his team could create things like what are the standard ways that we're going to do code reviews?

**中文翻译:**
另一件事是职能对策。当时我开始管理一小队软件工程师。但我从未……好吧，我在高中写过代码，但那是 Basic 和 Pascal。我是个通才，对吧？所以我没能力指导他们，不可能进行代码审查。所以我们想出了各种对策。例如，我们仍然有一位 C 级的工程负责人 Rick Dalzell。Rick 仍然是全公司的技术领袖，他和他的团队会制定标准，比如：我们进行代码审查的标准方式是什么？

---

### [00:24:41] Bill Carr

**English:**
Effectively, what it also meant is that anyone who is an engineering vice president... they would often have something else beyond their day job of some sort of subject matter expertise area where they would also contribute to the company. A good example of this would be that they might sit on a panel for promotion... or they might be available to do code review outside of their organization for another organization.

**中文翻译:**
实际上，这也意味着任何工程副总裁在日常工作之外，通常还负责某些专业领域并为公司做出贡献。一个例子是，他们可能会参加晋升评审小组，或者为其他部门提供跨组织的代码审查。

---

### [00:25:23] Lenny

**English:**
Let's go in a different direction and talk about one of my favorite principles of Amazon, which is disagree and commit. I think in the way I even describe it I know is wrong. I think people hear this term and they often use this principle incorrectly. For example, it actually starts with have backbone and then disagree and commit. So I'd love to just hear how you've seen this actually implemented well...

**中文翻译:**
让我们换个方向，聊聊我最喜欢的亚马逊准则之一：“表达异议并执行”（disagree and commit）。我觉得我描述它的方式可能都是错的。人们听到这个词时经常误用。例如，它实际上是以“有骨气”（have backbone）开头的，然后才是“表达异议并执行”。我很想听听你见过的真正好的执行方式是怎样的……

---

### [00:25:49] Bill Carr

**English:**
... this was always the least well understood when I was at Amazon too, and partly because it is actually the most nuanced and difficult to actually use. So here's what it means. What it means is that have backbone and disagree, meaning when we are making any kind of a decision... it is your obligation to voice your point of view if you disagree... The point of that disagreement, by the way, is to provide usually additional information or a new point of view that people have not considered.

**中文翻译:**
……我在亚马逊时，这也是最难被理解的一条，部分原因是它确实非常微妙且难以运用。它的意思是：要有骨气并表达异议。也就是说，当我们做任何决定时，如果你不同意，你有义务表达你的观点。顺便说一下，表达异议的目的是提供额外的信息或人们尚未考虑到的新视角。

---

### [00:27:41] Bill Carr

**English:**
This is sort of no different than that which is the disagree part is about bringing forth new information... Now the important point is first of all about hearing and understanding your point of view. What would often happen... someone come to me with a disagreement... I would say, "I hear your disagreement. We have already considered that factor. But even though that factor is there, here are these other factors that outweigh that." Now that is the point at which as long as the disagreer is hearing back from the leader that they understand their point of view... that is the point for them to commit.

**中文翻译:**
这就像国王和他的顾问团。表达异议是为了提出新信息。关键点首先在于你的观点被听到并理解了。经常发生的情况是，有人向我提出异议，我会说：“我听到了你的异议。我们已经考虑过那个因素了。但尽管有那个因素，还有其他更重要的因素压过了它。” 只要异议提出者从领导那里得到了“我理解你的观点”的反馈，那就是他们该“执行”（commit）的时候了。

---

### [00:29:39] Bill Carr

**English:**
Ideally it's, oh, now I've heard the argument, I've actually now thought about the argument and hopefully that person has now understood why we're taking that direction... Because the worst thing to do is to say, "Yeah, we're committed to this. I don't really agree and I still think it's wrong, but I'm committed to it." That's not actually commitment.

**中文翻译:**
理想情况下，应该是：“哦，现在我听到了论据，我也思考了这些论据，希望那个人现在理解了我们为什么要往那个方向走。” 因为最糟糕的做法是说：“好吧，我们执行这个决定。我并不真正同意，我仍然觉得它是错的，但我会执行。” 那不叫真正的执行（commitment）。

---

### [00:30:22] Lenny

**English:**
I imagine there are many times I've gone through this where I still don't agree. What's your advice to a manager or to a report of just like, okay, when you actually still don't agree, how do you behave?

**中文翻译:**
我能想象很多时候讨论完了我还是不同意。你对经理或下属有什么建议？当你真的还是不同意时，该如何表现？

---

### [00:30:37] Bill Carr

**English:**
... Jeff doesn't think a normal person... there'd be times when even after we've had that discussion, I would maybe still disagree, but then what I would do is I'd focus on, okay, well what is the kernel or the core of why Jeff thinks that we should do this and I would focus on that kernel... your job is to then take that kernel and try to run with it and expand it and try to see how I can take that idea, that concept, and then make it into something viable.

**中文翻译:**
……杰夫的思维方式不像普通人。有些时候即使讨论完了，我可能还是不同意。但我会专注于：杰夫认为我们应该这么做的“核心”或“内核”是什么？然后我的工作就是拿住这个内核，尝试去运行它、扩展它，看看如何把这个想法变成可行的东西。

---

### [00:32:18] Lenny

**English:**
Awesome. So the advice there is focus on the parts you agree with and think about how you can find out if it's actually right or not.

**中文翻译:**
太棒了。所以建议是专注于你同意的部分，并思考如何验证它是否正确。

---

### [00:32:25] Bill Carr

**English:**
Agree with, or even just you may not even agree, but what is the core of what that person is thinking is the big benefit or good guy or thinking vector that they're on that's causing them to want to go in this direction.

**中文翻译:**
哪怕你不同意，也要去想：那个人认为的核心利益是什么？或者说促使他们想往这个方向走的“思维矢量”（thinking vector）是什么。

---

### [00:32:42] Lenny

**English:**
Thinking vector, love that term. Along the same lines, another principle that I love is leaders are right a lot. I feel like this is a term that it almost goes unsaid. You almost can say this in a lot of companies. I'm curious just the origin of why that became an important principle and then how it's implemented at Amazon.

**中文翻译:**
“思维矢量”，我喜欢这个词。顺着这个思路，另一个我喜欢的准则是“领导者通常是对的”（leaders are right a lot）。我觉得这句话在很多公司几乎是心照不宣的。我很好奇为什么这会成为一条重要的准则，以及它在亚马逊是如何实施的。

---

### [00:33:03] Bill Carr

**English:**
... the data rarely makes the decision for you. What is happening is then a lot of judgment and interpretation of the data... The right a lot part comes from having what we call sort of sound judgment, which generally come... mostly they get it through experience. A lot of experiences actually about being wrong, by the way, about making mistakes... and then using that to understand then how to weight different information when making a decision.

**中文翻译:**
……数据很少能直接替你做决定。真正起作用的是对数据的判断和解读。所谓“通常是对的”，源于我们所说的“健全的判断力”，这通常来自经验。顺便说一下，很多经验其实来自于“犯错”。通过犯错，你学会了在做决策时如何权衡不同的信息。

---

### [00:35:12] Lenny

**English:**
I love that it's a lot. I like that it's not just leaders are right. It's right a lot.

**中文翻译:**
我喜欢“通常”（a lot）这个词。不是“领导者总是对的”，而是“通常是对的”。

---

### [00:35:18] Bill Carr

**English:**
Yeah, yeah. No one is right every time. That is totally unrealistic. Yeah.

**中文翻译:**
没错。没人能每次都对，那完全不现实。

---

### [00:35:26] Lenny

**English:**
Let's talk about the titular concept of your book... working backwards. First of all, just what does it actually mean to work backwards versus working forwards?

**中文翻译:**
聊聊你书名中的核心概念……逆向工作法（Working Backwards）。首先，逆向工作和正向工作到底有什么区别？

---

### [00:35:37] Bill Carr

**English:**
... great leaders start with the customer's needs and work backwards from there... starting with without the constraints of my financial constraints, my resource constraints, my legal constraints... because the problem is what most of us do is we start with those constraints and work forward from there, or we start with things like I got to increase revenue.

**中文翻译:**
……伟大的领导者从客户的需求开始，然后向后推导。在开始时不考虑财务、资源、法律或工程等限制。问题在于，我们大多数人是从这些限制出发向前推导，或者从“我必须增加收入”这样的目标出发。

---

### [00:37:22] Bill Carr

**English:**
Whereas we had, as Jeff would say, we took it as an article of faith. If we served customers well... things like sales, things like revenue... would follow... therefore, when we're making a decision thinking about a problem, we're going to start with what's best for the customer and then come backward from there.

**中文翻译:**
而我们，正如杰夫所说，将其视为一种信念。如果我们服务好客户，销售额和收入自然会随之而来。因此，在做决定时，我们会从对客户最好的方案开始，然后向后推导。

---

### [00:38:36] Lenny

**English:**
Awesome. So just to summarize, you start with what are the customer's needs and problems... and then think with no constraints. When you work with companies to implement this idea of working backwards, is it always what is the customer problem and need versus revenue or growth or something like that?

**中文翻译:**
太棒了。总结一下，就是从客户的需求和问题开始，不设限地思考。当你帮助公司实施逆向工作法时，出发点总是客户的问题和需求，而不是收入或增长之类的吗？

---

### [00:39:07] Bill Carr

**English:**
Well, the working backwards part is strictly about the customer's needs. Yeah, we don't want to work backwards from revenue... we used it in this method of new products and features that I'm going to go build on behalf of customers.

**中文翻译:**
逆向工作法严格来说是关于客户需求的。我们不想从收入开始逆推。我们专门将其用于为客户开发新产品和新功能的方法中。

---

### [00:40:10] Lenny (Sponsor: Wix Studio)

**English:**
This episode is brought to you by Wix Studio. Your agency has just landed a dream client... but do you have the tools to bring your ambitious vision to life? Let me tell you about Wix Studio... build unique layouts with a revolutionary grid experience... Find out more at wix.com/studio.

**中文翻译:**
本期节目由 Wix Studio 赞助。你的代理公司刚刚签下了一个梦想客户，但你有工具将宏伟愿景变为现实吗？让我向你介绍 Wix Studio……通过革命性的网格体验构建独特的布局。更多信息请访问 wix.com/studio。

---

### [00:41:31] Lenny

**English:**
Okay. So then when you go work with a company to implement this idea of working backwards, what are the very tactical things that you do to help them here? I know PR/FAQ is a part of that...

**中文翻译:**
那么，当你去一家公司实施逆向工作法时，你会做哪些具体的战术动作？我知道 PR/FAQ（新闻稿/常见问题解答）是其中的一部分……

---

### [00:41:31] Bill Carr

**English:**
... we came up with this process called the PR/FAQ process. So what it means is that whenever we're devising a new product or feature, we're going to start by writing a press release describing the feature and describing it in a way that speaks to the customer... the PR, you're going to describe very carefully and clearly who's the customer, what's their problem, and what's the solution that you're planning to build.

**中文翻译:**
……我们想出了这个叫 PR/FAQ 的流程。这意味着每当我们构思新产品或新功能时，我们先写一份新闻稿，以面向客户的口吻来描述它。在 PR（新闻稿）中，你要非常仔细、清晰地描述谁是客户、他们的问题是什么，以及你计划构建的解决方案是什么。

---

### [00:43:50] Bill Carr

**English:**
... writing PR/FAQs is one thing. Well, how do I actually use them? ... there's this iterative nature to writing PR/FAQs where it's sort of a concentric circle review. You start off small with one author... and then you start to share them with a small group and get feedback and improve it, a wider group... until... you get up to the CEO.

**中文翻译:**
……写 PR/FAQ 是一回事，如何使用它们是另一回事。写 PR/FAQ 具有迭代性，就像“同心圆评审”。先由一名作者开始，然后分享给小范围人群获取反馈并改进，再扩大范围，直到提交给 CEO。

---

### [00:44:55] Lenny

**English:**
Awesome. Okay. That was an awesome overview. I'm going to fire off a couple of questions around the first part. Do you still suggest people do it as a press release? It feels like press releases aren't a thing anymore. Do you ever suggest people do it as a tweet or as TikTok video or a blog post?

**中文翻译:**
太棒了，这是一个很好的概述。我想针对第一部分问几个问题。你现在还建议人们把它写成“新闻稿”吗？感觉新闻稿已经过时了。你会建议人们把它写成推文、TikTok 视频或博客文章吗？

---

### [00:45:09] Bill Carr

**English:**
Good question. So the first thing is it's not a real press release, okay? ... there really are three money paragraphs in this... first paragraph, it's a short description, that second paragraph, that's the problem statement, and that third paragraph, that's solution statement. If you wanted to ditch the rest of it... you could.

**中文翻译:**
好问题。首先，它不是真的要发出去的新闻稿。其中有三个核心段落：第一段是简短描述，第二段是问题陈述，第三段是解决方案陈述。如果你想丢掉其他部分，也可以。

---

### [00:46:11] Bill Carr

**English:**
The date is also a meaningful thing when you write the press release. The date is meant to be a hypothetical timing on which you're envisioning launching this thing which tells the reader something. Are you thinking that this is something that's so simple and easy, we're going to launch it next month or so complex that we're going to launch it in a year from now.

**中文翻译:**
写新闻稿时，日期也是有意义的。日期是你设想发布这个产品的虚拟时间，它能告诉读者很多信息：你认为这东西很简单，下个月就能发？还是非常复杂，需要一年时间？

---

### [00:47:01] Lenny

**English:**
Do you try to write it in a way that would be announced, like a press release feel? Or is it mostly just who is the customer? Do you try to pitch it as a part of this experience?

**中文翻译:**
你会试着把它写得像真的要发布一样吗？还是主要侧重于“谁是客户”？你会把它当作一种体验的一部分来推销吗？

---

### [00:47:01] Bill Carr

**English:**
So you try to write it in that way, but the one thing is you don't want to use hyperbole. It would be very factual with numbers, data rich document too. So again, not like a real press release. A lot of internal confidential data would be in this press release.

**中文翻译:**
你会试着那样写，但有一点：不要使用夸张修辞。它应该是基于事实的，包含大量数字和数据。所以它不像真实的新闻稿，里面会包含很多内部机密数据。

---

### [00:47:34] Lenny

**English:**
Is there a template that we can point people to in the show notes to help them craft this?

**中文翻译:**
有没有什么模板可以让我们在节目介绍中提供给听众，帮助他们撰写？

---

### [00:47:43] Bill Carr

**English:**
Yeah, so we have a website related to the book, which is www.workingbackwards.com, and there's a resources section within there and you'll find a template.

**中文翻译:**
有的，我们有一个与书相关的网站 www.workingbackwards.com，里面有一个资源（resources）板块，你可以找到模板。

---

### [00:47:53] Lenny

**English:**
Amazing. Okay. Then the concentric circle piece. So the idea there is basically get feedback from an increasingly larger swath of the company and it sounds like a big part of that is also get buy-in as you go along the way.

**中文翻译:**
太好了。关于“同心圆”部分，其核心思想是让公司越来越大范围的人提供反馈，听起来很大一部分也是为了在过程中获得支持（buy-in）。

---

### [00:48:05] Bill Carr

**English:**
Yes and no... you're a product manager... and you write 100 PRFAQs in a year, maybe 20 of those make it their way to the CEO... what you're really trying to create is a product funnel, not a product tunnel. And with a funnel, meaning lots of things at the top, fewer things at the bottom. The tunnel means that everything that comes in is also going to come out the other side.

**中文翻译:**
是也不是。如果你是一名产品经理，一年写了 100 份 PR/FAQ，可能只有 20 份能最终提交给 CEO。你真正想要建立的是一个“产品漏斗”，而不是“产品隧道”。漏斗意味着顶部有很多想法，底部产出很少；而隧道意味着进去什么，另一头就出来什么。

---

### [00:49:40] Bill Carr

**English:**
... you should think of yourself honestly as a venture capitalist. They don't fund every company that they meet with... At Amazon, we had lots and lots of PRFAQs that were a great idea, but we didn't ship them because we had other ones that were just a better idea...

**中文翻译:**
你应该把自己看作一名风险投资家。他们不会投资见到的每一家公司。在亚马逊，我们有很多非常棒的 PR/FAQ 创意，但我们没有发布它们，因为我们有更好的创意。

---

### [00:50:27] Lenny

**English:**
It feels like a lot of these processes are basically just ways to stop stupid shit from happening. I think the narrative is a good example where you have to expose your thinking deeply. This is a great example of that.

**中文翻译:**
感觉这些流程基本上都是为了防止“蠢事”发生。我认为“叙述性备忘录”（narrative）就是一个很好的例子，你必须深度展示你的思考。PR/FAQ 也是如此。

---

### [00:50:39] Bill Carr

**English:**
Yeah. And it's also, I would say, an example of where this is a process to prevent the other process, which is the product development process, from becoming the thing where you just get locked in on, "What are we doing in this sprint..." What I recommend is you try to break that into two different processes. One is the process of deciding what you should go build... and then once you've decided that, then, yes, by all means, use all that good thinking...

**中文翻译:**
是的。我会说，这也是为了防止产品开发流程变成一种“我们这轮冲刺要做什么”的机械循环。我建议将其拆分为两个流程：一个是决定“该建什么”的流程；一旦决定了，再进入“如何高效构建”的流程。

---

### [00:51:19] Lenny

**English:**
I was just reading this Harvard Business Review article... the thinking to doing gap... I'm curious how you try to avoid that at Amazon considering there's this period of just like, "Let's explore, explore, explore..."

**中文翻译:**
我刚读了一篇《哈佛商业评论》的文章，讲的是“思考与执行之间的鸿沟”。我很好奇亚马逊是如何避免这个问题的，毕竟你们有很长一段“探索、探索、再探索”的时间。

---

### [00:51:39] Bill Carr

**English:**
... one such version of this problem is what I'd call the-big-idea-that's-not-fleshed-out problem... once you've spent some time looking at that idea more deeply, you then start to identify several roadblocks or maybe a fatal flaw... So one problem is that companies get stuck, I think, where they never actually go do that documentation.

**中文翻译:**
这个问题的一个版本是我所说的“未完善的大创意”问题。一旦你深入研究，你就会发现障碍或致命缺陷。我认为一个问题是，很多公司停留在口头讨论，从未真正去写文档。

---

### [00:53:50] Bill Carr

**English:**
What I always found as I became more senior... is that when something came up, some idea that didn't neatly fit within my org structure... I had to decide this was a compelling enough idea that we were going to take a resource... and I'm going to have to assign that resource to actually go look at this and work at this. Otherwise, it will never happen.

**中文翻译:**
随着我职位的提升，我发现当一些不符合现有组织架构的想法出现时，我必须决定这是否足够吸引人，值得我抽调资源（可能是一个人或一个团队）去专门研究。否则，它永远不会实现。

---

### [00:54:31] Lenny

**English:**
I've been through those many times. Okay. So there's two more concepts I want to try to touch on before we wrap up. The next one is the idea of input and output metrics... could you just describe what that is and why that's so important...

**中文翻译:**
我经历过很多次。在结束前，我还想探讨两个概念。下一个是“投入指标”与“产出指标”（input and output metrics）。你能描述一下那是什么，以及为什么它如此重要吗？

---

### [00:55:03] Bill Carr

**English:**
... in our early years at Amazon... growth started to... hit a wall eventually... what ensues then is, "We're not going to hit our number. What should we do about that to hit our number?" ... we would run around like chickens with our heads cut off and come up with a bunch of ideas that tended to be promotional in nature... we started to realize, "Huh, these fire drills don't really work."

**中文翻译:**
在亚马逊早期，增长最终碰到了壁。接着大家就开始慌：“我们达不到指标了，该怎么办？” 然后我们就跟没头苍蝇一样乱撞，想出一堆促销点子。后来我们意识到：“嘿，这些‘救火演习’根本没用。”

---

### [00:56:58] Bill Carr

**English:**
And this is about the same time when Jeff and the S-Team were reading the book, Good to Great... what it did is to help us codify our growth flywheel, meaning what are the inputs that if we improve these things... things like how easy was it to find what you wanted to buy... Were the prices low? ... So we identified these things on our flywheel.

**中文翻译:**
大约在同一时间，杰夫和高管团队（S-Team）读了《从优秀到卓越》（Good to Great）。这本书帮我们明确了“增长飞轮”，即如果我们改进了哪些“投入”，增长就会发生。比如：找到想买的东西有多容易？价格够低吗？我们在飞轮上识别出了这些要素。

---

### [00:59:03] Bill Carr

**English:**
... we took it as an article of faith that if we can just improve these inputs, the outputs will take care of themselves. The inputs are the things that drive the outputs, which are revenue, customer activity, free cashflow.

**中文翻译:**
我们坚信，只要我们能改进这些投入指标，产出指标自然会变好。投入指标是驱动产出指标（如收入、客户活跃度、自由现金流）的因素。

---

### [01:00:37] Lenny

**English:**
The flywheel, you reminded me... On the topic of input metrics, just briefly, what is an example of a good input metric?

**中文翻译:**
飞轮，你提醒了我。关于投入指标，能不能简单举个例子，什么是好的投入指标？

---

**[01:01:02] Bill Carr**

**English:**
A sign that's a good input metric is, first of all, map your end-to-end customer experience... I'm not an Airbnb... So then you've reserved. Now you have interactions with a property owner. How do I measure the quality of those? How many messages go back and forth? Is a lot of messages a good thing? Is that a bad thing? ... You know it's an input metric if it is measuring something with respect to the customer experience... and do you control it?

**中文翻译:**
好的投入指标的标志是，首先，绘制出端到端的客户体验。以 Airbnb 为例（虽然我没在那工作过）：客户预订后会与房东互动。我该如何衡量互动的质量？往返消息的数量是多少？消息多是好事还是坏事？如果它衡量的是客户体验的某个环节，并且是你能够控制的（即你可以投入资源使其变好或变坏），那它就是一个投入指标。

---

### [01:03:26] Lenny

**English:**
Oh, here it is. I'm looking at... Define, measure, analyze, improve-

**中文翻译:**
哦，找到了。我正在看……定义（Define）、测量（Measure）、分析（Analyze）、改进（Improve）——

---

### [01:03:30] Bill Carr

**English:**
And analyze. Thank you. Yeah, duh, analyze. So we just use that process... we tell a story in the book about one of our most important input metrics, which was how much selection do we have, and we were actually not measuring that right for several years.

**中文翻译:**
还有分析。谢谢。对，分析。我们就用那个流程（DMAIC）。我们在书中讲了一个故事，关于我们最重要的投入指标之一——“选品丰富度”（selection），实际上我们有好几年都没能量对这个指标。

---

### [01:04:23] Lenny

**English:**
... something that came up a bunch is with working backwards, obviously some products Amazon has launched have not worked out. Say the Fire Phone is a classic example. What have you learned from that process...

**中文翻译:**
……很多人问到，既然有逆向工作法，为什么亚马逊发布的一些产品还是失败了？比如 Fire Phone 就是个经典例子。你从那个过程中学到了什么？

---

### [01:04:47] Bill Carr

**English:**
... Fire Phone is a great example... I would argue this is a case where we made the mistake of what we had a technology solution in mind, which was 3D effects. And then we took that solution and we're then in search of a problem. I don't think it solved any meaningful problems for customers.

**中文翻译:**
Fire Phone 是个很好的例子。我认为这是我们犯的一个错误：我们先有了一个技术解决方案（3D 效果），然后拿着这个方案去寻找问题。我不认为它解决了客户的任何实质性问题。

---

### [01:06:48] Lenny

**English:**
I imagine there was a lot of disagreeing and committing on that concentric circle process. Is there anything that you've found of just the number of disagreement and commits... that tells you maybe this is not a good idea?

**中文翻译:**
我能想象在那个“同心圆”评审过程中有很多“表达异议并执行”。你有没有发现，如果异议的数量达到一定程度，就预示着这可能不是个好主意？

---

### [01:07:03] Bill Carr

**English:**
Not necessarily... a lot of people inside Amazon doubted that the Kindle was going to be a good idea... I can tell you that for years is working on Prime Video... they would laugh at me. They thought that was crazy. So that's not necessarily the sign of whether the product is right or wrong.

**中文翻译:**
不一定。亚马逊内部很多人曾怀疑 Kindle 是否是个好主意。我在做 Prime Video 的那些年，人们甚至会嘲笑我，觉得那太疯狂了。所以，异议多并不一定代表产品想法是错的。

---

### [01:08:02] Lenny

**English:**
Yeah. And I think something Amazon's incredibly good at is being okay with a lot of failures... Is that true?

**中文翻译:**
是的。我认为亚马逊非常擅长的一点是能够接受大量的失败……是这样吗？

---

### [01:08:11] Bill Carr

**English:**
... Some of them are very public and obvious... We were not afraid to take what we considered a well-calculated risk. I think many, many companies are less willing to do so... They do fear failure, and they're really focused on their near-term financial goals.

**中文翻译:**
有些失败非常公开且显而易见。我们不害怕承担经过周密计算的风险。我认为很多公司不太愿意这样做，他们害怕失败，并且过于关注短期财务目标。

---

### [01:09:55] Lenny

**English:**
... Is there something that you recommend to companies that want to actually improve in this? What could they actually change and actually do this well?

**中文翻译:**
……对于想要在这方面改进的公司，你有什么建议？他们可以改变什么来真正做好这一点？

---

### [01:10:16] Bill Carr

**English:**
... there were two things. One was our compensation system. So there were no performance bonuses... our compensation was based on the stock price. So we all had an incentive to do what was right for the company, frankly, over a long-term... And then the second thing was having a CEO who was really committed to it and it wasn't something that they delegated to someone else.

**中文翻译:**
有两点。一是我们的薪酬体系。我们没有绩效奖金，薪酬是基于股价的。所以我们都有动力去做对公司长期有利的事。第二点是有一位真正致力于创新的 CEO，而且他不会把这件事授权给别人就不管了。

---

### [01:13:10] Bill Carr

**English:**
... when we went to go build digital media and AWS, we put two of our smartest leaders in the company on those things, Steve Kessel and Andy Jassy. And number two, they were meeting with Jeff regularly. Jeff was deeply engaged with them...

**中文翻译:**
……当我们开始构建数字媒体和 AWS 时，我们派出了公司最聪明的两位领导者：Steve Kessel 和 Andy Jassy。其次，他们定期与杰夫会面，杰夫深度参与其中。

---

### [01:13:52] Lenny

**English:**
... Can you just talk about what this idea of a Bar Raiser is in the hiring process and then what people can do if they wanted to add this to their hiring process?

**中文翻译:**
……你能谈谈招聘流程中的“Bar Raiser”（人才准入门槛提升者）是什么概念吗？如果人们想在自己的招聘流程中加入这个，该怎么做？

---

### [01:14:19] Bill Carr

**English:**
... The Bar Raiser hiring process... was established... back in 1999... we had new people hiring new people hiring new people... So what information are they using to make these hires... obviously they were just using their own personal judgment...

**中文翻译:**
Bar Raiser 招聘流程建立于 1999 年。当时我们处于超速增长期，新人招新人，新人再招新人。他们根据什么信息来招人呢？显然只是根据个人判断。

---

### [01:16:21] Bill Carr

**English:**
... on every interview loop there's one person, who is not the hiring manager... they are on the interview loop and they're a Bar Raiser... they technically have veto power over the hiring manager... And so the Bar Raiser was there to act as a balance also on the urgency bias that every hiring manager has...

**中文翻译:**
在每一轮面试中，都有一个非招聘经理的人，他们就是 Bar Raiser。从技术上讲，他们对招聘经理拥有一票否决权。Bar Raiser 的存在是为了平衡每个招聘经理都会有的“紧迫性偏见”（急于填补空缺而降低标准）。

---

### [01:18:21] Lenny

**English:**
... who has the final decision in hiring, is it the hiring manager?

**中文翻译:**
……谁拥有最终的招聘决定权？是招聘经理吗？

---

### [01:18:27] Bill Carr

**English:**
Yes... The decision maker is the hiring manager, the whole interview loop and the Bar Raiser are actually just there to help the hiring manager make the right decision.

**中文翻译:**
是的。决策者是招聘经理，整个面试小组和 Bar Raiser 实际上只是为了帮助招聘经理做出正确的决定。

---

### [01:19:40] Lenny

**English:**
And then when you're choosing a Bar Raiser, is there any suggestions you have of who to choose and how often you pull them into these things?

**中文翻译:**
那么在选择 Bar Raiser 时，你有什么建议？选谁？以及多久让他们参与一次？

---

### [01:19:49] Bill Carr

**English:**
It is a huge time suck... Pick people who are A, care a lot about your hiring process, B, appear to be good interviewers, and C, seem to have high standards. It's also a great role for people who are earlier in their career by giving them this additional leadership opportunity.

**中文翻译:**
这非常耗时。选择那些：A. 非常在意招聘流程；B. 看起来是很棒的面试官；C. 拥有高标准的人。对于职业生涯早期的人来说，这也是一个很好的角色，能给他们额外的领导力锻炼机会。

---

### [01:20:41] Lenny

**English:**
... If someone were trying to move along the path of becoming more Amazonian, which of these elements and processes do you think often has the most impact?

**中文翻译:**
……如果有人想变得更像亚马逊，你认为这些元素和流程中，哪一个通常影响最大？

---

### [01:21:10] Bill Carr

**English:**
... the first thing I tell them is... no, that's not the idea is for you to try to become Amazon, the purpose is to sort of look at these processes and best practices... The other piece of advice I give is that a lot of these changes are relatively profound, they really require buy-in all the way up to the CEO...

**中文翻译:**
我告诉他们的第一件事是：不，目的不是让你变成亚马逊，而是借鉴这些流程和最佳实践。我给出的另一个建议是，这些变革非常深刻，确实需要一直到 CEO 层面的支持。

---

### [01:23:10] Lenny

**English:**
... I know you also work with companies to implement a lot of these practices. Could you just talk about what it is you can help folks with and then how to potentially engage if they're interested?

**中文翻译:**
……我知道你也帮助公司实施这些实践。你能谈谈你能帮到大家什么，如果他们感兴趣该如何联系你？

---

### [01:23:27] Bill Carr

**English:**
... we are advisors, consultants... non-traditional... Each of us just work directly with the companies who engage us... Generally speaking what we do is the right kind of company for us to work with, first of all, has to achieve a certain scale... well over 100 million in annual run rate...

**中文翻译:**
我们是顾问、咨询师，但非传统模式。我们每个人都直接与聘请我们的公司合作。一般来说，适合我们的公司首先要达到一定规模，年营收通常在 1 亿美元以上。

---

### [01:25:51] Bill Carr

**English:**
Simple way is you can just send an email, I'm bill@workingbackwards.com... You can also just check out our website, www.workingbackwards.com.

**中文翻译:**
简单的方法是发邮件，我是 bill@workingbackwards.com。你也可以查看我们的网站 www.workingbackwards.com。

---

### [01:26:05] Lenny

**English:**
Okay. Well with that we've reached our very exciting lightning round. I've got six questions for you, are you ready?

**中文翻译:**
好的。现在进入我们非常激动人心的闪电问答环节。我有六个问题，准备好了吗？

---

### [01:26:11] Bill Carr

**English:**
I'll try.

**中文翻译:**
我试试。

---

### [01:26:12] Lenny

**English:**
... what are two or three books that you've recommended most to other people?

**中文翻译:**
……你向别人推荐最多的两三本书是什么？

---

### [01:26:23] Bill Carr

**English:**
... Good to Great. I'd say Drucker on Management... Steve Jobs biography... On a personal basis, recent books would be Seveneves by Neal Stephenson... and A Gentleman in Moscow.

**中文翻译:**
《从优秀到卓越》。还有德鲁克的管理著作……《史蒂夫·乔布斯传》。个人方面，最近读的书有尼尔·斯蒂芬森的《七夏娃》（Seveneves）和《莫斯科绅士》。

---

### [01:27:07] Lenny

**English:**
... do you have a favorite recent movie or TV show?

**中文翻译:**
……你最近有喜欢的电影或电视剧吗？

---

### [01:27:15] Bill Carr

**English:**
Yeah, my favorite recent movie is the latest Dune movie... And I just watched... the TV series A Spy Among Friends...

**中文翻译:**
有的，我最近最喜欢的电影是《沙丘》。我还看了电视剧《友谊之谍》（A Spy Among Friends）。

---

### [01:28:01] Lenny

**English:**
What is a favorite product you've recently discovered that you really like...

**中文翻译:**
你最近发现并非常喜欢的某个产品是什么？

---

### [01:28:08] Bill Carr

**English:**
... I'm an avid cyclist and I got myself a new set of wheels for my road bike this year... It's the Zipp 303 Firecrest...

**中文翻译:**
我是一个狂热的自行车爱好者，今年我给我的公路车买了一套新轮组：Zipp 303 Firecrest。

---

### [01:28:47] Lenny

**English:**
Do you have a favorite interview question that you really like to ask?

**中文翻译:**
你有没有最喜欢问的面试问题？

---

### [01:28:52] Bill Carr

**English:**
Yeah, it's actually quite basic, it's tell me about your most significant professional accomplishment... I could basically then... ask a lot of probing and follow-up questions...

**中文翻译:**
有的，其实很基础：请告诉我你最显著的职业成就。然后我会针对这个例子问很多深入的追问。

---

### [01:29:46] Lenny

**English:**
Next question, what's a favorite life motto that you often find yourself coming back to...

**中文翻译:**
下一个问题，你经常想起或分享给朋友的人生格言是什么？

---

### [01:29:55] Bill Carr

**English:**
... slow is smooth and smooth is fast... to really to go fast, you actually need to go slow first and to be very clear on what you're doing...

**中文翻译:**
“慢即是稳，稳即是快”（Slow is smooth and smooth is fast）。为了真正快起来，你实际上需要先慢下来，明确你在做什么。

---

### [01:31:25] Lenny

**English:**
Final question... is there a pro-tip that you could suggest for using Amazon?

**中文翻译:**
最后一个问题……关于使用亚马逊，你有什么“专业小贴士”吗？

---

### [01:31:36] Bill Carr

**English:**
Sorry, I have no secret insights...

**中文翻译:**
抱歉，我没有什么秘密洞察……

---

### [01:32:06] Lenny

**English:**
... how can listeners be useful to you?

**中文翻译:**
……听众可以如何帮到你？

---

### [01:32:19] Bill Carr

**English:**
We're always looking for feedback. You can post a review on Amazon for our book... or send us an email telling us what you found most useful...

**中文翻译:**
我们一直在寻求反馈。你可以在亚马逊上给我们的书写评论，或者发邮件告诉我们你觉得书里最有用的部分是什么。

---

### [01:32:46] Lenny

**English:**
Amazing... Bill, thank you again so much for being here.

**中文翻译:**
太棒了……Bill，再次感谢你的到来。

---

### [01:32:59] Bill Carr

**English:**
Thanks so much, Lenny, really enjoyed it.

**中文翻译:**
非常感谢 Lenny，我很享受这次对话。

---

### [01:33:00] Lenny

**English:**
Me too, bye everyone. Thank you so much for listening... See you in the next episode.

**中文翻译:**
我也是，大家再见。非常感谢收听……下期节目见。