# Bob Moesta - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Bob Moesta.

---

### [00:00:00] [Bob Moesta]

**English:**
I think one of the biggest misconceptions around Jobs to Be Done is this notion that it's pain and gain as opposed to context and outcome. When you hear somebody's story and it seems irrational, like we'll have people go, "Oh my God, that's an anomaly. That doesn't happen." But what you realize is that the context makes the irrational rational. So the moment you hear a story, you go, "I can't believe that," nine times out of 10, it's because you don't have the rest of the story. And so part of it's being able to understand the rest of that context that would drive somebody to say, "Why would somebody cut their arm off?" Well, if they're in this situation and this and this and this, there's nobody who would say they want to cut their arm off, but in certain situations you'll do it. And so that's what we're trying to do is find, where will people change behavior?

**中文翻译:**
我认为关于“待办任务”（Jobs to Be Done，简称 JTBD）最大的误解之一，是认为它仅仅关乎“痛苦与收益”（pain and gain），而实际上它关乎的是“情境与结果”（context and outcome）。当你听到某个人的故事觉得很不合理时，比如有人会说：“天哪，那只是个特例，现实中不会发生的。”但你会意识到，正是特定的情境让那些看似不合理的行为变得合理。所以，当你听到一个故事并心想“我简直不敢相信”时，十有八九是因为你还不了解故事的全貌。因此，我们的工作一部分就是去理解那些驱动行为的完整情境。比如，“为什么有人会砍掉自己的手臂？”正常情况下没人会想这么做，但在某些极端情境下，你不得不这么做。这就是我们要做的：寻找人们在什么情况下会改变自己的行为。

---

### [00:00:38] [Lenny]

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Bob Moesta. Bob is the co-creator of the Jobs to Be Done Framework alongside Clay Christensen. And as you'll hear at the top of our conversation, is maybe the most anticipated guest I've had based on the LinkedIn response. Bob has started eight companies and is currently the co-founder and CEO of the Rewired Group, and currently spends his time helping companies of all sizes unlock hidden insights and create successful products and services.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的跨国产品负责人和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Bob Moesta。Bob 是“待办任务”框架（JTBD）的共同创始人，曾与克莱·克里斯坦森（Clay Christensen）并肩作战。正如你在我们对话开始时会听到的那样，根据 LinkedIn 上的反馈，他可能是我邀请过的最受期待的嘉宾。Bob 创办过八家公司，目前是 Rewired Group 的联合创始人兼 CEO，他现在致力于帮助各种规模的公司挖掘隐藏的洞察，并创造成功的产品和服务。

---

### [00:01:12] [Lenny]

**English:**
In our conversation, we get deep into all aspects of the Jobs to Be Done framework. What is it, how to apply it to your product, when it's not a good fit, how to interview customers to get accurate insights into their struggles, plus examples of how Jobs to Be Done works for zero to one products and a ton more. Thank you to everyone who suggested questions and topics for our conversation. Enjoy my chat with Bob Moesta after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们将深入探讨 JTBD 框架的各个方面：它究竟是什么、如何应用到你的产品中、什么时候它不适用、如何通过访谈客户来准确洞察他们的挣扎，以及 JTBD 在“从 0 到 1”的产品中如何发挥作用的案例等等。感谢所有为这次对话提供问题和建议的朋友。在听完赞助商的简短介绍后，请欣赏我与 Bob Moesta 的访谈。

---

### [00:01:38] [Lenny]

**English:**
This episode is brought to you by Sidebar. Are you looking to land your next big career move or start your own thing? One of the most effective ways to create a big leap in your career and something that worked really well for me a few years ago is to create a personal board of directors, a trusted peer group where you can discuss challenges you're having, get career advice, and just kind of gut check how you're thinking about your work, your career, and your life. This has been a big trajectory changer for me, but it's hard to build this trusted group. With Sidebar, senior leaders are matched with highly vetted, private supportive peer groups to lean on for unbiased opinions, diverse perspectives, and raw feedback. Everyone has their own zone of genius, so together we're better prepared to navigate professional pitfalls leading to more responsibility, faster promotions, and bigger impact. Guided by world-class programming and facilitation, Sidebar enables you to get focused tactical feedback at every step of your journey.

**中文翻译:**
本期节目由 Sidebar 赞助。你是否正在寻求职业生涯的下一次重大跨越，或者准备开始创业？实现职业飞跃最有效的方法之一（也是几年前对我非常有用的方法），就是建立一个“个人董事会”——一个值得信赖的同行群体。在这里，你可以讨论面临的挑战，获取职业建议，并对你的工作、职业和生活想法进行直觉检查。这对我来说是一个巨大的轨迹转折点，但建立这样一个互信的群体很难。通过 Sidebar，资深领导者可以与经过严格审核、私密且相互支持的同行小组匹配，从而获得公正的意见、多元的视角和原始的反馈。每个人都有自己的天才领域，因此聚在一起，我们能更好地应对职业陷阱，从而承担更多责任、获得更快晋升并产生更大影响。在世界级项目和引导的带领下，Sidebar 让你在旅程的每一步都能获得专注且具战术性的反馈。

---

### [00:02:33] [Lenny]

**English:**
If you're a listener of this podcast, you're likely already driven and committed to growth. A Sidebar personal board of directors is the missing piece to catalyze that journey. Why spend a decade finding your people when you can meet them at Sidebar today? Jump the growing wait list of thousands of leaders from top tech companies by visiting sidebar.com/lenny to learn more. That's sidebar.com/lenny.

**中文翻译:**
如果你是本播客的听众，你可能已经非常有动力并致力于成长。Sidebar 的个人董事会就是催化这一旅程的最后一块拼图。既然今天就能在 Sidebar 遇到志同道合的人，为什么要花十年时间去寻找呢？访问 sidebar.com/lenny 了解更多信息，跳过数千名来自顶尖科技公司领导者的候补名单。网址是 sidebar.com/lenny。

---

### [00:02:58] [Lenny]

**English:**
This episode is brought to you by Merge. Every product manager knows how slow product development can get when developers have to build and maintain integrations with other platforms. Merge's Unified API can fully remove this blocker from your roadmap. With one API, your team can add over 180 HR, accounting, ATS, ticketing, CRM, file storage and marketing automation integrations into your product. You can get your first integration into production in a matter of days and save countless weeks building custom integrations, letting you get back to building your core product. Merge's integrations speed up the product development process for customers like Ramp, Drada and many other fast-growing and established companies, allowing them to test their features at scale without having to worry about a never-ending integrations roadmap. Save your engineers countless hours, hit your growth targets and expedite your sales cycle by making integration offerings your competitive advantage with Merge. Visit merge.dev/lenny to get started and integrate up to three customers for free.

**中文翻译:**
本期节目由 Merge 赞助。每位产品经理都知道，当开发人员必须构建和维护与其他平台的集成时，产品开发速度会变得多么缓慢。Merge 的统一 API 可以完全从你的路线图中移除这一障碍。通过一个 API，你的团队就可以在产品中添加超过 180 种人力资源（HR）、会计、招聘（ATS）、工单、客户关系管理（CRM）、文件存储和营销自动化集成。你可以在几天内将第一个集成投入生产，节省数周构建自定义集成的时间，让你重新专注于构建核心产品。Merge 的集成加速了 Ramp、Drada 以及许多其他快速增长和老牌公司的产品开发过程，使他们能够大规模测试功能，而无需担心永无止境的集成路线图。通过 Merge 将集成服务转化为你的竞争优势，为你的工程师节省无数小时，达成增长目标并缩短销售周期。访问 merge.dev/lenny 开始使用，并免费集成最多三个客户。

---

### [00:04:04] [Lenny]

**English:**
Bob, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Bob，非常感谢你能来。欢迎来到本播客。

---

### [00:04:08] [Bob Moesta]

**English:**
Thanks, Lenny. Excited to be here. Big fan.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。我是你的忠实粉丝。

---

### [00:04:10] [Lenny]

**English:**
Ah, I'm a big fan of yours. I wasn't even super familiar with you before we started organizing this podcast chat. And then as you saw, I posted on LinkedIn what questions people had for you and around Jobs to Be Done in general. And I've never seen so many comments and questions and so much passion for guests I had on, I think there was over-

**中文翻译:**
啊，我也是你的粉丝。在开始筹划这次播客访谈之前，我对你还不是特别熟悉。然后如你所见，我在 LinkedIn 上发帖询问大家对你以及 JTBD 框架有什么问题。我从未见过听众对嘉宾有这么多评论、问题和如此高的热情，我想当时有超过——

---

### [00:04:30] [Bob Moesta]

**English:**
Really?

**中文翻译:**
真的吗？

---

### [00:04:30] [Lenny]

**English:**
Absolutely. There's, I don't don't know, 130 questions and comments and folks like Jason Fried, founder of 37signals and Des from Intercom came out and just like, I'm excited for this episode, so we got some here.

**中文翻译:**
绝对是真的。大概有 130 多个问题和评论，像 37signals 的创始人 Jason Fried 和 Intercom 的 Des 都出来留言说非常期待这一集，所以我们今天准备了很多内容。

---

### [00:04:45] [Bob Moesta]

**English:**
I've worked with all of them, they're great people and fun to work with.

**中文翻译:**
我和他们都合作过，他们都是很棒的人，合作起来很有趣。

---

### [00:04:48] [Lenny]

**English:**
I just had no idea there's so much passion for Jobs to Be Done. I have a million questions for you, a lot of them coming from the audience, some from me. So I'm excited to dig into a lot of this stuff.

**中文翻译:**
我之前真没想到大家对 JTBD 有这么大的热情。我有无数个问题想问你，很多来自观众，也有一些是我自己的。所以我很兴奋能深入探讨这些内容。

---

### [00:04:57] [Bob Moesta]

**English:**
All right, let's dive in.

**中文翻译:**
好的，我们开始吧。

---

### [00:04:58] [Lenny]

**English:**
Okay, so I thought it'd be useful just to start with the very basics briefly, just what is the simplest way to understand the Jobs to Be Done framework?

**中文翻译:**
好的，我想先从最基础的开始，简单介绍一下：理解 JTBD 框架最简单的方式是什么？

---

### [00:05:07] [Bob Moesta]

**English:**
I think the easiest way to think about it is that I'm an engineer, electrical, basically have been building product for almost 30 years and one of the lies I was told growing up was build it and they will come. And so we always think about it from a technological, how do I build this thing? And all right, who wants this product? And what I realized very early in my career is that really it didn't work, I couldn't make it work.
(00:05:31):
And so Jobs to Be Done is this whole premise that people hire products, they don't buy them, they hire them to make progress in their life. And if we can take a step back and look at it, we see it in a very different light to realize at some point they're in some context and there's some outcome they want. And if we can understand that, we start to realize that different things compete, right?
(00:05:51):
A simple example is think of Snickers and Milky Way, right? They're both candy bars, they're both bought in the checkout aisle, they're both made almost with the same ingredients, one has peanuts, one doesn't. And if you start to compare the products and do a competitive benchmark, you start to get to one's a little softer, one's a little harder, one's got a few more calories, one's got less calories. But when you talk to people about when's the last time they ate a Snickers, when time's the last time they ate a Milky Way, you start to realize that Snickers typically is a case where they missed the last meal, they've got a lot of work to do, they're running out of energy and they want to basically get back to the tasks as fast as possible. And so you start to realize that Snickers is about almost like a meal replacement and it's about the stomach is growling and things like that. And you start to realize that if they didn't have a Snickers, it competes with a protein drink, it competes with a Red Bull, a coffee.
(00:06:49):
But a Milky Way typically is eaten after an emotional experience, could be positive, could be negative. It's usually eaten alone, and it's taking time to regroup after this emotional thing. And you start to realize that it competes with things like a glass of wine, a brownie, and to be honest, a run. And so when you start to realize that, jobs helps you see the true competitive set from what we call the demand side of the world as opposed to the competitive set from the supply side of the world, which is the technology or the underlying business model by how which we're making it. And so it allows you to actually see what customers really want as opposed to trying to figure out, how do we sell things to people?

**中文翻译:**
我认为最简单的理解方式是这样的：我是一名电子工程师，从事产品开发近 30 年了。我成长过程中听到的一个谎言是“只要你把它造出来，人们自然会来买”。所以我们总是从技术的角度思考：我该怎么造这个东西？谁会想要这个产品？但在职业生涯早期我就意识到，这根本行不通。
(00:05:31):
所以 JTBD 的核心前提是：人们不是“购买”产品，而是“雇佣”（hire）产品来帮助他们在生活中取得进步。如果我们退后一步来看，会发现视角完全不同：人们处于某种“情境”中，想要达到某种“结果”。如果我们能理解这一点，就会发现竞争对手其实是意想不到的。
(00:05:51):
举个简单的例子：想想士力架（Snickers）和星河巧克力（Milky Way）。它们都是巧克力棒，都在收银台旁边卖，成分也差不多，只是一个有花生一个没有。如果你只是对比产品做竞品分析，你会发现一个软一点，一个硬一点，热量高低有别。但当你问人们上一次吃士力架是什么时候，上一次吃星河是什么时候，你会发现：吃士力架通常是因为错过了正餐，还有很多工作要做，能量快耗尽了，想尽快回到工作状态。所以士力架更像是一种“代餐”，解决的是肚子咕咕叫的问题。你会发现，如果没有士力架，它的竞争对手是蛋白饮、红牛或咖啡。
(00:06:49):
但星河巧克力通常是在经历了一场情绪波动（无论是好是坏）之后吃的。通常是独自一人吃，用来在情绪波动后重新调整状态。你会发现它的竞争对手是一杯红酒、一块布朗尼，说实话，甚至是一次跑步。当你意识到这一点时，JTBD 就能帮你从“需求侧”（demand side）看到真正的竞争格局，而不是从“供给侧”（supply side，即技术或商业模式）来看。这让你能看清客户真正想要什么，而不是苦思冥想如何把东西卖给别人。

---

### [00:07:29] [Lenny]

**English:**
To maybe follow up on this example a bit, how often do you find these jobs emerge after they've developed a product, in this case I guess Snickers or Milky Way, how often is it just like they see this problem and actually apply this approach even accidentally?

**中文翻译:**
针对这个例子追问一下，你觉得这些“任务”有多少是在产品开发出来之后才显现出来的（比如士力架或星河）？又有多少情况是他们先看到了问题，然后（哪怕是无意中）应用了这种方法？

---

### [00:07:44] [Bob Moesta]

**English:**
What's interesting is that at least for me, the thing is what I learned was that supply and demand are not as connected as everybody thinks. Most people think they create a product and that creates demand. But the real thing that if you start to study causality is that a struggling moment causes demand. And you start to realize that in some cases that struggling moment exists and can exist for a long time and nobody solved it. So one of the companies I helped was Southern New Hampshire University and Paul Le Blanc. And one of the things in 2010, we found basically these anomalies, these people who were going to school but not actually coming to class and watching everything online. And it was like 50 or 60 of them and the anomalies basically, and they're paying full price, they didn't want to come. For Paul, it was kind of like why are they doing this?
(00:08:29):
And when we went to study them, we realized that they actually had a very different job than a typical 18 to 24 year old because one, they were a little bit older, typically they had either already had a degree or they basically had tried to go to college and it didn't work. And it was about basically time now that they had responsibility to do something new. And so they didn't actually build the product at all. And as they started to look and say how many people want to go back to school but can't? They started to realize it's not a thousand people, it's not 10,000 people, they have over 200,000 students. They're one of the largest universities in the world. And so all of this starts with a struggling moment, not with a product.
(00:09:06):
And so that's what we mean when we're customer-centric is that we're studying the struggling moments they have and people like Intercom and Basecamp, they look at struggling moments and that becomes their roadmap. Because again, think about a roadmap. I'm literally trying to tell you what I'm going to build in the next 24 months, for example, but none of us saw ChatGPT coming. And so all of a sudden I have to go undo the roadmap. But if I talk about the struggling moments that I'm trying to go after, all of a sudden I realize that the roadmap is now when I get to that struggling moment, there's multiple ways I can solve it. So instead of just talking about features, it's typically talking about features for the first 90 to 120 days, but after that we just talk about struggling moments because that's the seed for real innovation and basically where new products come from.

**中文翻译:**
有趣的是，至少对我来说，我学到的是供给和需求并不像大家想象的那样紧密相连。大多数人认为创造了产品就创造了需求。但如果你研究因果关系，你会发现是“挣扎时刻”（struggling moment）产生了需求。你会意识到，在某些情况下，这种挣扎时刻已经存在了很久，却没人解决。我曾帮助过南新罕布什尔大学（SNHU）和校长 Paul Le Blanc。在 2010 年，我们发现了一些“异常现象”：有五六十个学生付了全额学费，却从不来教室上课，而是在网上看所有内容。对 Paul 来说，这很奇怪：他们为什么要这么做？
(00:08:29):
当我们去研究他们时，发现他们的“任务”与典型的 18 到 24 岁大学生完全不同。首先，他们年龄稍大，通常已经有了学位，或者之前尝试上大学失败了。现在他们有了责任，想要学习新东西。学校其实并没有专门为他们开发新产品。但当他们开始观察有多少人想回学校却回不去时，他们意识到这不只是 1000 人或 10000 人，现在他们有超过 20 万名学生，是世界上最大的大学之一。所以，一切都始于“挣扎时刻”，而不是产品。
(00:09:06):
这就是我们所说的“以客户为中心”：研究他们的挣扎时刻。像 Intercom 和 Basecamp 这样的公司，他们观察挣扎时刻，并以此制定产品路线图。想想看，路线图通常是告诉你未来 24 个月要造什么，但谁也没预料到 ChatGPT 的出现，于是路线图被打乱了。但如果我关注的是我要解决的“挣扎时刻”，那么路线图就变成了：当我面对那个挣扎时刻时，我有多种方式去解决它。所以，我们通常只在前 90 到 120 天讨论具体功能，之后就只讨论挣扎时刻，因为那是真正创新的种子，也是新产品的来源。

---

### [00:10:07] [Bob Moesta]

**English:**
But it's not just the pain. See, what we're taught in business school was pain and gain, but the reality is it's the context. It's the fact that I didn't eat lunch before, the fact that I still have a lot of work to do, the fact that I have this podcast going on. It's not that I'm in pain, but it's the context that makes me value this in the moment that much more than something else. And so part of this is it's not just about pain and gain, it's about context and outcomes.
(00:10:34):
And so when you frame it that way, it becomes a vector, a vector of progress or a vector of intention of what they're trying to do. And once we frame that, then we can actually wrap technology around it. And the crazy part is that I was always told or taught if I build the best product, it will sell better. And what I've learned is that actually a kick-ass half is better than a half-ass hole, and that's what Jason talks about. But the reality is like if you look at QuickBooks, QuickBooks has half the features and double the price. And you start to realize that at some point in time it's about meeting customers where they are, not trying to wow them and not trying to convince them. They convince themselves to make the progress.

**中文翻译:**
但这不仅仅是关于痛苦。你看，商学院教我们的是“痛苦与收益”，但现实是“情境”。比如我没吃午饭，我还有很多工作要做，我还要录这个播客。这并不是说我有多痛苦，而是这个“情境”让我此时此刻对某样东西的价值评估远高于其他东西。所以，这不只是痛点，而是情境和结果。
(00:10:34):
当你这样构思时，它就变成了一个“矢量”——一个进步的矢量，或者说他们试图达成的意图矢量。一旦我们确定了这个矢量，就可以围绕它应用技术。疯狂的地方在于，我以前总是被教导：只要做出最好的产品，就能卖得更好。但我学到的是，正如 Jason 所说，“一个牛逼的半成品胜过一个平庸的全能品”。现实情况是，比如 QuickBooks，它的功能只有竞品的一半，价格却是两倍。你会意识到，关键在于在客户所处的位置满足他们，而不是试图惊艳他们或说服他们。是他们说服自己去取得进步。

---

### [00:11:14] [Lenny]

**English:**
I'd like to understand this vector piece more because that feels really important. So you were saying that it's not just there's a pain point, solve that, what you're saying is what's even more important is this context around that pain point and things that precede it?

**中文翻译:**
我想多了解一下这个“矢量”的部分，因为这听起来非常重要。所以你的意思是，不仅仅是发现一个痛点然后解决它，更重要的是围绕这个痛点的情境以及发生在这个痛点之前的事情？

---

### [00:11:27] [Bob Moesta]

**English:**
Yeah, so the first thing is we don't talk to people who just want to.

**中文翻译:**
是的，首先我们不和那些只是“想要”的人谈。

---

### [00:11:34] [Lenny]

**English:**
For people listening on the podcast, Bob pulled up a drawing, so you should try to check out the YouTube video of this to see what he's doing.

**中文翻译:**
各位听众注意，Bob 拿出了一个绘图板，建议大家去 YouTube 看视频版，看看他在画什么。

---

### [00:11:42] [Bob Moesta]

**English:**
So there's some Product A is the old product and there's some Product B, which is the new product. And ultimately people don't randomly do anything. And so the real heart of the method of Jobs to Be Done is understanding the causation of what pushes people to say, "Today's the day I got to do something different." And the push or the context they're in has nothing to do with the new product, it's the only reason why they would leave the old product. And if there's no push, they can't even see your product because we're creatures of habit, right? And so as soon as I have a push, I call that F1, force one, and I have some idea of what's possible, then I create something called F2, which is basically the pull to a new outcome, a new state, a new thing, right? And so at some point in time it's like I have to be in this situation and I have to want this outcome, right?
(00:12:34):
But here's the other part is that there's this waterline that there's these other forces and there's two other forces. Every time I show somebody something new, it actually creates anxiety, right? Anxiety of the new, and I call this F3, right? And then the other thing is I have to get them to leave old thing. So I call this habit of the present. And what you start to realize, and I call that F4, is if F1 and F2 are not greater than F3 and F4, they're not going to move, they're not going to do anything. And so ultimately what we're doing is we're framing the market as a system of behavior. And most people say, "If I just add more features, create more pull, people will buy." It's not true. More features create actually anxiety, can it do all those things?
(00:13:24):
And what you start to realize is if I reduce friction, which is the bottom part, I actually don't have to do anything with a product, I just have to make easier. So for example, one of the things I did is I built houses and one of the frictional points that people had in moving was the fact of moving house was basically packing all their stuff up and going somewhere. And so I would literally sell them a condo, they'd go from a 3000 square foot home to a 1500 square foot condo and they'd cancel six weeks later because they didn't know how to get rid of all their stuff, which is a frictional point. So what did I do? I actually raised the price of the condo, included moving in two years of storage as part of the deal with the condo because it's the frictional coefficient and I increased sales over 30%.

**中文翻译:**
假设产品 A 是旧产品，产品 B 是新产品。人们不会随机做任何事。JTBD 方法的核心在于理解驱动人们说“今天我必须做点不一样的”背后的因果关系。这种“推力”（push）或他们所处的情境与新产品无关，但它是他们离开旧产品的唯一原因。如果没有推力，他们甚至看不见你的产品，因为人是习惯的动物。一旦有了推力（我称之为 F1，第一种力），并且对未来的可能性有了想法，就会产生 F2，即新结果、新状态或新事物的“拉力”（pull）。所以，你必须处于某种情境，并且想要某种结果。
(00:12:34):
但还有另一部分：在水面之下还有另外两种力。每当我向某人展示新东西时，都会产生“焦虑”（anxiety），即对新事物的焦虑，我称之为 F3。另一件事是，我必须让他们离开旧事物，这叫“现状习惯”（habit of the present），我称之为 F4。你会发现，如果 F1 + F2 不大于 F3 + F4，人们就不会行动。所以，我们是将市场视为一个行为系统。大多数人认为“只要增加更多功能，创造更多拉力，人们就会买”，其实不然。更多功能反而会增加焦虑：它真的能做到所有这些吗？
(00:13:24):
你会意识到，如果我减少摩擦（即底部的阻力部分），我甚至不需要对产品做任何改动，只需要让过程变得更容易。例如，我以前盖房子，人们搬家时的一个摩擦点是打包所有东西。我卖给他们公寓，他们从 3000 平方英尺的大房子搬到 1500 平方英尺的公寓，结果六周后他们退订了，因为他们不知道怎么处理旧东西。这就是摩擦点。于是我做了什么？我提高了公寓价格，但在交易中包含了搬家服务和两年的仓储服务。因为解决了这个摩擦系数，我的销量增长了 30% 以上。

---

### [00:14:07] [Bob Moesta]

**English:**
So what this is it's really about focusing on the customer. It's about understanding the causation behind it and then using design thinking to actually start to realize, how do we actually enable people to make progress? We don't need to sell them, we need to enable them to buy.
(00:14:24):
And so I wrote a book called Demand Side Sales that basically took the premise of stop trying to sell people and just help them make progress, help them buy. And so the whole book is instead of trying to base the sales process on how we want to sell, we need to actually design the sales process on how they want to buy. And it seems like it's the same thing, but they're actually really, really different things.

**中文翻译:**
所以这本质上是关于以客户为中心。理解背后的因果关系，然后利用设计思维去思考：我们如何赋能人们去取得进步？我们不需要“推销”给他们，我们需要“赋能”他们去购买。
(00:14:24):
所以我写了一本书叫《需求侧销售》（Demand Side Sales），核心前提就是停止推销，转而帮助他们取得进步，帮助他们购买。整本书都在讲：与其根据我们想怎么卖来设计销售流程，不如根据他们想怎么买来设计。这听起来是一回事，但实际上完全不同。

---

### [00:14:51] [Bob Moesta]

**English:**
So one of the companies I work with a lot lately is a company called Autobooks, they're based here in Detroit. And basically they help banks basically do invoicing through let's say Apple Pay. And so instead of having to use Square or PayPal, you literally can use your bank now to do these things. And so there's two things, they have to sell small business on it, but they also have to sell banks on it. And when we started talking about it, they talked about why do banks want it? And the first thing we did is we found out there's three really different reasons why banks want them.
(00:15:22):
But the thing is that where the process looked at is they would talk about the struggling moment, they talk about what was going on and then everything was about getting them to a demo. And once we got them to a demo, we had to close them. Well, it turns out that the buying process literally has different phases in it. There's the first thought, there's something called passive looking where they're problem aware and solution unaware and they have to learn a bunch of things, and then there's active looking where they're both problem and solution aware and they're trying to figure out and frame a solution, and then there's deciding which is about making trade-offs.
(00:15:53):
And so what we end up doing is when I started to talk to the team about it, what they started to realize is I said, "Where is the customer in their timeline of buying?" And they looked at me like, "Huh?" I said, "No, no, you have a timeline of how you want to sell to them and after the demo you try to close, but what if they're actually in passive looking and want a demo to learn more? It's very different than if I'm trying to close." And so what we ended up doing is breaking the demo apart, asking people where they were in their buying process. And by doing that we actually then found out a way in which to give them three different demos, one about telling stories and giving them the background about the problem, another one about showing them all the alternatives, and then the last one is about basically giving them choices between ways to move forward, right?
(00:16:37):
And you'd think that it would make the sales process longer, it actually made the sales process almost half and at 4x basically conversion because now we meet them where they are as opposed to where we want them to be.

**中文翻译:**
我最近经常合作的一家公司叫 Autobooks，总部在底特律。他们帮助银行通过 Apple Pay 等方式进行发票处理。这样小企业就不必非得用 Square 或 PayPal，直接用自己的银行账户就能搞定。这涉及两方面：向小企业推销，以及向银行推销。当我们开始讨论时，他们谈到银行为什么要这个？我们发现银行想要它的原因有三种完全不同的理由。
(00:15:22):
但问题在于，原来的流程是：谈论挣扎时刻，谈论发生了什么，然后所有努力都是为了引导客户看演示（demo）。一旦看了演示，就得设法成交。但事实证明，购买过程其实有不同的阶段：产生初衷、被动寻找（意识到问题但不知道解决方案，需要学习）、主动寻找（意识到问题和方案，试图构思方案），以及最后的决策（权衡取舍）。
(00:15:53):
于是我问团队：“客户处于购买时间轴的哪个位置？”他们一脸茫然。我说：“不，你们只有‘想怎么卖’的时间轴，演示完就想成交。但如果他们还处于‘被动寻找’阶段，看演示只是为了多了解一下呢？这和‘准备成交’完全不同。”所以我们拆分了演示，询问客户处于购买过程的哪个阶段。通过这种方式，我们设计了三种不同的演示：一种是讲故事和背景；一种是展示所有替代方案；最后一种是提供不同的推进方案供选择。
(00:16:37):
你可能以为这会让销售周期变长，但实际上它让销售周期缩短了近一半，转化率提高了 4 倍。因为我们是在他们所处的位置迎接他们，而不是强迫他们来到我们想要的位置。

---

### [00:16:59] [Bob Moesta]

**English:**
Yeah, there's actually, I call them six phases. First thought, passive looking, active looking, deciding, first use, and then ongoing use. How do we build the new habit? And so if we don't actually study that part of how do people transform themselves through a struggling moment, we don't know what they want. If I talk to people who want to buy a house, they tell me they want granite and hardwood and they'll make everything these things they want.
(00:17:25):
But when you actually talk to people who bought a house, they actually made a lot of trade-offs. Although for example, everybody I would survey before buying a house, I had 93% say they wanted an Energy Star compliant house. It cost 30 grand to make an Energy Star compliant at the time. And the reality is nobody bought it, they all bought the finished basement. And so there's the difference between what they say they want and what they want.
(00:17:48):
And so the method itself is not based on traditional research or market research, asking people what it is. It's actually based on criminal and intelligence interrogation about telling me the story about how you decided today's the day I bought a house or today's the day I went back to school. It's not random. And if it's not random, then we need to actually find it. And that to me is one of the bigger differences, most people build their sales process on probability, "If I get so many leads in, I'll convert so many to here to so many..." But the ultimate thing is, how many people are really ready for your product? They have to actually be ready for it. And that's what Jobs to Be Done is really about, is understanding where they are, what's causing it, and how do they make the trade-offs?

**中文翻译:**
是的，我把它们分为六个阶段：产生初衷、被动寻找、主动寻找、决策、首次使用、持续使用（如何建立新习惯）。如果我们不研究人们如何通过挣扎时刻实现自我转变，我们就不知道他们想要什么。如果我问想买房的人，他们会说想要花岗岩台面、硬木地板，列出一堆想要的东西。
(00:17:25):
但当你去问那些真正买了房的人，你会发现他们做了很多权衡。例如，在买房前调查时，93% 的人说想要符合“能源之星”标准的房子。当时达到那个标准要多花 3 万美元。结果呢？没人买那个标准，大家都买了带装修的地下室。这就是“他们说想要的”和“他们实际想要的”之间的区别。
(00:17:48):
所以这个方法本身不是基于传统的市场调研（问人们想要什么），而是基于类似刑事或情报审讯的技术：请告诉我你决定“今天就买房”或“今天就回学校”背后的完整故事。这绝非偶然。既然不是偶然，我们就需要找到原因。对我来说，这是最大的区别之一：大多数人根据概率建立销售流程（“如果有这么多线索，就能转化这么多……”），但核心问题是：有多少人真正为你的产品做好了准备？他们必须准备好。这就是 JTBD 的真谛：理解他们所处的位置、原因以及他们如何做权衡。

---

### [00:18:39] [Bob Moesta]

**English:**
The first thing we do is we frame a question. And the way I think about it is most people, so the one thing to know about me is I've been building things for over 30 years, I've worked on 3,500 different products and services across many, many industries, but I've had three close head brain injuries before I was seven years old and I can't read and I can't write. And so one of the things for me is that I could not understand the research that I would get from marketing around basically they'd say, "Hey, I need something that's easy, fast and fun and cheap." And I'd be like, "Okay, what does any of that mean? What is fast? How fast is fast and what's not fast?" And you start to undo all those things.
(00:19:18):
And so the first thing we do is we start to frame, let's just talk about what causes people to say today's the day they want to go on vacation or today's the day they wanted a new set of windows. And you start to frame around that, and then you go find people who recently purchased and say, "What in the world happened that says today's the day I need new windows?" And you start to realize that there's pushes and there's pulls and there's anxieties and there's habits. And so the first thing we do is we try to extract the story from the customer. And it doesn't have to be my product, it could be somebody else's product if I haven't built it yet. It's like, what are people going to fire when they hire me?
(00:19:55):
And so when we get the stories though, then the stories are going to get us the pushes, the pulls, the anxieties and the habits, the trade-offs and what we call the hire and fire criteria. And then what we do is instead of trying to look for themes across all of them, we actually do something, instead of segmenting them, we cluster them, we find the pathways because what you start to realize is it's not one reason why people do it, it's sets of reasons. And those sets actually work together. So the pushes work with the pulls. So when they have these pushes, they want these pulls. And when they don't have these pushes, they don't want those pulls.
(00:20:29):
And so when you start to see the patterns and you start to pull it out, you start to realize that most companies or most products are hired to do 3, 4, 5 different jobs and they're in conflict with each other. One person wants to go faster and one person wants to be more thorough. And so all of a sudden being more thorough means it's slower. If I say we're thorough, the people who want it fast say, "I don't want this because it's too slow." So how do you frame those things out and understand where the conflicts are behind it and think about different products from it?
(00:20:59):
That's what Intercom did, right? Intercom realized that people hired it for four very, very different reasons and then instead of building four different products, they literally took their product and turned off the features that were not relevant to the pathway that people wanted to take. So for acquire, they didn't need a whole bunch of these other features and so they actually framed it around basically, how do we help people convert? And that job actually competed with HubSpot.
(00:21:24):
There's another one where it was about helping with support, and that one competed with Zendesk. And so they changed the pricing model to basically match who the competition was and to match the progress that people were trying to make because Zendesk was too much and too hard, and HubSpot felt like it was an overkill for where people were. We basically figured out how to actually position ourselves as a good next step between HubSpot adds nothing or between nothing and HubSpot. And that's how they've grown to be valued over 2 billion.

**中文翻译:**
我们做的第一件事是构思一个问题。关于我，有一点你需要知道：我做产品 30 多年，参与过 3500 多种产品和服务，跨越无数行业，但我 7 岁前受过三次严重的头部脑损伤，我不会读也不会写。所以对我来说，我无法理解市场部给我的那些调研报告，比如他们说：“嘿，我需要一个简单、快速、有趣且便宜的东西。”我会想：“这到底是什么意思？什么是快？多快算快？什么算不快？”你需要去拆解这些模糊的词。
(00:19:18):
所以我们首先构思：是什么导致人们说“今天我要去度假”或“今天我要换窗户”？围绕这一点，去找那些最近购买的人，问他们：“到底发生了什么，让你觉得今天必须换新窗户？”你会发现推力、拉力、焦虑和习惯。我们尝试从客户那里提取故事。不一定要是我的产品，如果我还没造出来，可以是别人的产品。关键是：当他们“雇佣”我时，他们会“解雇”什么？
(00:19:55):
当我们拿到故事后，就能得到推力、拉力、焦虑、习惯、权衡，以及我们所说的“雇佣与解雇标准”。然后，我们不是去寻找所有故事的共同主题，而是进行“聚类”（cluster）而非“细分”（segment）。我们寻找路径，因为你会发现人们做某事不是因为一个原因，而是一组原因。这些原因成组起作用：特定的推力对应特定的拉力。
(00:20:29):
当你看到这些模式并将其提取出来时，你会意识到大多数公司或产品被雇佣来完成 3、4、5 种不同的任务，而这些任务之间往往是冲突的。有人想更快，有人想更彻底。而更彻底往往意味着更慢。如果我说我们很彻底，追求速度的人就会说：“我不要这个，太慢了。”你如何构思这些冲突并据此思考不同的产品？
(00:20:59):
这就是 Intercom 所做的。Intercom 意识到人们雇佣它是出于四个完全不同的原因。他们没有开发四个产品，而是根据用户选择的路径关闭不相关的功能。比如对于“获取客户”这个任务，他们不需要其他一大堆功能，于是围绕“如何帮助转化”来构思。这个任务的竞争对手其实是 HubSpot。
(00:21:24):
另一个任务是“提供支持”，竞争对手是 Zendesk。于是他们改变了定价模型，以匹配竞争对手和用户想要取得的进步。因为 Zendesk 太重太难，而 HubSpot 对某些人来说又大材小用。我们找到了自己的定位：作为 HubSpot 之外的一个很好的下一步，或者介于“什么都没有”和 HubSpot 之间。这就是他们如何成长到估值超过 20 亿美元的。

---

### [00:22:00] [Bob Moesta]

**English:**
Yeah, can't read and write. So the thing is I cannot read the words that I write and I cannot read... So if somebody reads it to me, I can actually play it back. So I'll listen to audio. But the fact is the way I was taught to read is so that when I look at a paragraph, I see the spaces between the words first, and then I usually see the left-hand edge of the words, so the last three letters. And so my mom taught me to look at the five largest words on the page by circling the longest words on the page. And then I would study those and translate those and then figure out what those five words would have in common. Because for me, the part that's broken in my brain is that I can't look up things fast enough. So by the time I try to look at a word, figure out what it is, get the definition, I've literally forgotten every word before it.

**中文翻译:**
是的，我不会读写。我读不出自己写的字，也读不了……如果有人读给我听，我可以复述出来，所以我听音频。事实是，我学认字的方式很特别：当我看到一段话时，我先看到的是单词之间的空格，然后通常看到单词的左边缘，也就是最后三个字母。我妈妈教我圈出页面上最长的五个单词，然后研究它们，翻译它们，找出这五个词的共同点。因为我大脑受损的部分让我无法快速检索信息。当我费劲看清一个词、弄明白它的意思时，我已经把前面的词全忘了。

---

### [00:22:55] [Bob Moesta]

**English:**
It's a gift. I'm telling you, it's a gift. It's a gift I'd never wish upon my children. But to be honest, it's given me abilities to see patterns in so many different ways because I can remember the first five words in the first paragraph and the last five words in the last paragraph so I turned through a book three or four times, and I have as good a comprehension as everybody else.

**中文翻译:**
这是一种天赋。我告诉你，这真的是天赋，虽然我绝不希望我的孩子也这样。但老实说，它赋予了我从多种维度观察模式的能力。因为我能记住第一段的前五个词和最后一段的最后五个词，我把书翻上三四遍，理解力就和别人一样好了。

---

### [00:23:19] [Bob Moesta]

**English:**
It's really simple, I have a company called Scribe Media, and what we do is first thing we do is we look for what struggling moments do people have? We then look at what are the competitive books wrapped around it? I then basically outline what progress looks like. We then take each chapter and define it as a system and what we have to do in each chapter to help them make the progress along the way. And then we just talk and we talk, we have ten two hour sessions, they get recorded, and then somebody basically takes... So if you listen or read any of my books, it sounds like me talking because it is.

**中文翻译:**
其实很简单，我有一家叫 Scribe Media 的公司。我们做的第一件事是寻找人们有哪些“挣扎时刻”？然后看市面上相关的竞争书籍有哪些？接着我勾勒出“进步”是什么样子的。我们将每一章定义为一个系统，明确每一章需要做什么来帮助读者取得进步。然后我们就一直聊，进行 10 次、每次 2 小时的谈话并录音。最后有人负责整理……所以如果你听或读我的书，感觉就像我在说话，因为那确实就是我说的话。

---

### [00:24:52] [Bob Moesta]

**English:**
It's been fun. I pinched myself. The other part is I don't know how I got here. One of the things that I've been doing is I've been studying people for the last 10 years around why they switched from one company to another to literally understand the jobs of jobs because employees actually hire companies more than companies hire employees. And so you start to realize the struggling moment is why don't we have enough people? And otherwise I want to leave, but I don't know how to leave. And so I'm in the midst of writing a book around that right now with Michael Horn and Ethan Bernstein.

**中文翻译:**
这很有趣。我有时都觉得不可思议。另一方面，我也不知道自己是怎么走到今天的。过去 10 年我一直在研究人们为什么从一家公司跳槽到另一家公司，去理解“工作的任务”，因为实际上员工“雇佣”公司的情况比公司雇佣员工的情况更多。你会意识到挣扎时刻是：为什么我们招不到足够的人？或者我想离开，但我不知道该怎么走。我现在正和 Michael Horn 以及 Ethan Bernstein 一起写一本关于这个主题的书。

---

### [00:25:27] [Bob Moesta]

**English:**
So the number one thing that I would say is almost everybody when you ask them about how they got the job they're in, the number one phrase you get is, "It was so lucky. I was so lucky, just happened to fall in my lap." And then when you actually unpack the story, luck had nothing to do with it. They were prepped, they were ready, there was pushes, there were pulls, there was anxieties, they were able to do it. And you start to realize, and the funny part is that if I talked to somebody who's been through three or four kind of switches, they all can say, "Yep, I've had that job. Yep, I've had that job. Yep, I've had that." And so there's frames around basically understanding what progress are you really trying to make now? Is it, do I need balance? Am I not challenged enough?
(00:26:08):
And you start to frame it, and when you frame it, you start to realize, I'm willing to actually take less money to be around smarter people because I want to be a founder later. And so you start to realize that all of these things where we think we have to pay more money, over 50% of the people who got new jobs didn't get more money. It's a lie. It's about progress. It's about what do they want to learn? What skills do they want to get? At some point it's about money, but it's not always about money.
(00:26:37):
And the other interesting part is when you talk about money, we talk about this notion of unpacking. We'll say, "Well, why do you need more money?" It's like, "Well, I have larger obligations," or, "I want more money because I want more respect." And so what you realize is in the hiring and firing criteria, they talk about money, but money actually has a bigger effect than just money. It's about respect or it's about responsibility or it's about their metric of progress. There's a whole bunch of things, but it's not just money. That's the interesting part.

**中文翻译:**
我想说的第一点是，当你问几乎所有人是如何得到现在的工作时，最常听到的一句话是：“太走运了，我运气真好，机会就这么掉到我怀里了。”但当你真正拆解故事时，运气根本不是主因。他们早有准备，时机成熟，有推力、有拉力、有焦虑，他们最终做到了。有趣的是，如果我跟一个跳过三四次槽的人聊，他们都能说：“是的，我做过那个任务；是的，我也做过那个。”所以这里有一个框架去理解：你现在到底想取得什么样的进步？是需要平衡？还是觉得挑战不够？
(00:26:08):
当你开始构思时，你会意识到：我愿意拿更少的钱去和更聪明的人共事，因为我以后想创业。你会发现，虽然我们认为必须付更多钱才能招到人，但超过 50% 换了新工作的人并没有拿到更高的薪水。那是个谎言。关键在于进步：他们想学什么？想获得什么技能？在某些阶段钱很重要，但并不总是为了钱。
(00:26:37):
另一个有趣的地方是，当我们谈论钱时，我们会进行“拆解”。我们会问：“你为什么需要更多钱？”对方可能会说：“因为我有更大的财务责任，”或者“我想要更多钱是因为我想要更多尊重。”所以你会发现，在“雇佣与解雇标准”中，虽然他们谈论钱，但钱背后的影响远超金钱本身。它关乎尊重、责任或他们衡量进步的指标。有很多因素，不仅仅是钱。这是最有趣的部分。

---

### [00:27:37] [Bob Moesta]

**English:**
Let me give you three tips. The first tip I'd tell you is go read Never Split The Difference by Chris Voss. I started to write a book around basically techniques that I learned back in the eighties and nineties around this, and his book is amazing around it, the whole notion of getting to know. I play things back incorrectly because they're going to say no, and I'm going to say, "All right, fix it," and then they'll talk more. The moment somebody says yes, there's nothing more to say. And so there's a bunch of techniques you have to learn to basically get them talking.
(00:28:09):
The second is I only talk to people who have already tried to make the progress, right? So for example, people talk about like, "Well, you can't apply this to something that's new. It doesn't exist." So I worked with a company that was, let's say a fairly large social media company, and at some point in time they found people kind of transacting on their platform, but they didn't know anything about it and they hadn't built anything. And what they ended up doing is we ended up going and studying eBay and Etsy and what caused somebody to say, "Today's the day I'm going to set up an eBay store or sell something on Craigslist." And out of that, we found all the jobs of what people, both sellers were doing and buyers were doing, and now I think it's I think almost a $3 billion marketplace that didn't exist and they learned about it all from the competitors.

**中文翻译:**
我给你三个建议。第一，去读 Chris Voss 的《掌控谈话》（Never Split The Difference）。我曾想写一本关于我在八九十年代学到的访谈技巧的书，而他的书在这方面写得太棒了，尤其是关于“获取信息”的概念。我会故意错误地复述一些事，因为对方会说“不”，然后我会说“好吧，那你纠正我”，接着他们就会说得更多。一旦有人说“是”，谈话就结束了。所以你必须学习一系列技巧来引导他们开口。
(00:28:09):
第二，我只和那些已经尝试过取得进步的人谈。例如，有人说：“你不能把这套方法应用到全新的、还不存在的事物上。”我曾与一家大型社交媒体公司合作，他们发现人们在平台上进行交易，但他们对此一无所知，也没开发相关功能。我们做的是去研究 eBay 和 Etsy，研究是什么导致某人说“今天我要开个 eBay 店”或“在 Craigslist 上卖东西”。通过研究，我们发现了买卖双方的所有“任务”。现在，那个原本不存在的市场规模已经接近 30 亿美元，而他们所有的洞察都来自对竞争对手的研究。

---

### [00:29:07] [Bob Moesta]

**English:**
That's a great controversial question. The interesting part is from a causal mechanism perspective and from a set theory perspective, meaning the sets of pushes, pulls anxieties and habits, it starts to repeat around seven or eight. And I usually do 10, no more than 12. And I would rather do two rounds of 12 interviews than do 24 interviews. I had some really interesting mentors, one of them was Dr. Deming, who's the father of lean and quality systems and like that. And so he would always push me to basically how to do things faster and smaller. And so that's where a lot of it came. And you just realize that people will say, "Oh, we have to do something statistically significant." Well, you do if you're doing it randomly, but if you actually understand the range of your market and you know that 50% of it is above 30 years old and 50% is below 30 years old, I could actually sample in a way that makes me get a good representation without having to actually do 50 interviews. And so we use something called design experiments to help with that.

**中文翻译:**
这是一个很有争议的好问题。有趣的是，从因果机制和集合论的角度来看（即推力、拉力、焦虑和习惯的集合），模式通常在访谈到第 7 或第 8 个人时就开始重复了。我通常做 10 个，最多不超过 12 个。我宁愿做两轮各 12 次的访谈，也不愿一次性做 24 次。我有一些非常棒的导师，其中一位是戴明博士（Dr. Deming），他是精益生产和质量管理体系之父。他总是敦促我思考如何把事情做得更快、更精简。这就是很多方法的来源。你会发现人们总说：“哦，我们必须做具有统计学意义的研究。”如果你是随机抽样，确实需要。但如果你了解市场的分布，比如知道 50% 的人超过 30 岁，50% 的人低于 30 岁，我就可以进行定向抽样，在不需要做 50 次访谈的情况下获得很好的代表性。我们称之为“实验设计”（design experiments）。

---

### [00:30:18] [Bob Moesta]

**English:**
In a lot of cases, you have to look at it from multiple perspectives. And so the other tip I have is to not have a discussion guide. It drives people crazy because everybody wants to ask the same set of questions, but the problem happens is when you ask the same set of questions, you actually don't follow the ones that actually have the most meaningful information in it, right? And so what happens is, what I say is I use the framework of pushes, pulls, anxieties and habits and say, "What caused them to do this?" And everything else is just a conversation of trying to understand their story.
(00:30:53):
And so part of this is being able to ask the questions around why, but you can't ask "Why, why, why, why why?" It's like, "Tell me more about that. Give me an example." And in a lot of cases, I usually get them to what I call the edge of language where they have no more language, and what I do is I literally then bracket it, "So was it more about this or more about that?" And I know it's neither one of those, and it forces them to talk more, right? It's always trying to get them to know, because the moment I get to... So when I play it back, "So you did this and this and this and this," and say, "No, that wasn't it." And the people who I'm working with are like, "You know that's not the right answer," I'm like, "I know, but they're going to elaborate on why it's not that." And so it's literally being able to reveal kind of the causal mechanisms of why people do what they do.

**中文翻译:**
在很多情况下，你必须从多个角度观察。我的另一个建议是：不要准备“访谈提纲”。这会让很多人抓狂，因为大家都想问同样的一组问题。但问题在于，当你死守提纲时，你就会错过那些最有价值的信息。我所做的是利用推力、拉力、焦虑和习惯的框架，核心问题是“是什么导致他们这么做的？”，其余的一切都只是为了理解他们故事的对话。
(00:30:53):
所以，部分技巧在于询问“为什么”，但你不能连珠炮似地问“为什么、为什么、为什么”。你应该说：“多跟我讲讲那个，举个例子。”很多时候，我会把他们带到我所谓的“语言的边缘”——也就是他们词穷的时候。这时我会给出一个“区间”：“所以更多是因为这个，还是因为那个？”我知道两者都不是，但这会迫使他们说得更多。我总是试图引导他们说“不”，因为当我复述“所以你做了这、这、这”而他们说“不，不是那样的”时，我的同事会奇怪：“你知道那不是正确答案啊。”我说：“我知道，但他们会详细解释为什么不是那样。”这正是揭示人们行为背后因果机制的方法。

---

### [00:33:14] [Bob Moesta]

**English:**
So what I would say is I find a lot of founders, especially really successful founders, like I would say Jason Fried is one of those where he intuitively understood this. He actually thinks this way but didn't have language wrapped around it, right? So I think that it's a very useful framework. I think that the danger you run into is that when you look at the customer through the product, so if I look at the customers through the Snickers bar, then I think of Milky Way as a competitor. But if I look at the customer and say, "Why did they pick that thing?" Then I realize that a protein shake and an apple and a sandwich are the competitors not Milky Way.

**中文翻译:**
我想说的是，我发现很多创始人，尤其是非常成功的创始人（比如 Jason Fried），直觉上就理解这一点。他确实是这样思考的，只是之前没有专门的术语来描述。所以我认为这是一个非常有用的框架。但你面临的危险是：如果你透过“产品”去看客户（比如透过士力架看客户），你会认为星河巧克力是竞争对手。但如果你看着客户问“他们为什么选那个东西？”，你会意识到蛋白饮、苹果和三明治才是竞争对手，而不是星河巧克力。

---

### [00:34:04] [Bob Moesta]

**English:**
So there's two things. If I have a product, go find 10 people who recently bought your product, but what I want you do is go talk to them, not about the product, but about why they bought the product, what was going on, what were they hoping for, what were they worried about? What did they have to give up? How did they convince somebody else? Just listen to the story. Start with just getting the story.
(00:34:26):
Because there's three levels of information we have to get or three sources of energy that I talk about. So think about it as there's got to be energy in the system for us to do something. And there's what I call functional energy, which is usually time, space, effort, knowledge, right? There's emotional energy, which is how I feel. I want to feel better, I feel frustrated, I feel overlooked. There's emotional aspects to it. And then there's social aspects, how I want others to perceive me or how others perceive me, "Oh, my boss is going to fire me because he doesn't think I'm doing this fast enough and I feel inadequate." So part of his understanding kind of the emotional, social and functional components that are part of that energy source.

**中文翻译:**
有两件事可以做。如果你已经有了产品，去找 10 个最近购买的人。但我要你做的不是聊产品，而是聊他们为什么要买：当时发生了什么？他们期待什么？担心什么？必须放弃什么？他们是如何说服别人的？只是倾听故事，从获取故事开始。
(00:34:26):
因为我们需要获取三个层面的信息，或者说我所说的三种“能量来源”。想象一下，系统中必须有能量，我们才会行动。第一种是“功能性能量”，通常涉及时间、空间、精力和知识。第二种是“情感能量”，即我的感受：我想感觉更好、我感到沮丧、我感到被忽视。第三种是“社交能量”，即我希望别人如何看待我，或者别人如何看待我：“哦，我老板要开除我了，因为他觉得我做得不够快，我觉得自己能力不足。”所以，理解这些情感、社交和功能组件，就是理解能量来源的一部分。

---

### [00:35:11] [Bob Moesta]

**English:**
The second part is if it's an established product and it's been there a while, I'd actually go and talk to people who churned. Because in churn, what's interesting is when somebody leaves your product, they're still making progress. We think it's bad for us, which it probably is, but in their mind it's like, "Yeah, this was too hard and complicated," or, "You know what? It didn't do enough for us." It allows you to actually understand the struggling moment they had because, again, they were using your product and something happened and some context changed and now they struggle with it, and now they got to go find something else.
(00:35:43):
Nobody wants to change. So that makes this actually the easiest thing to look at is tell me why people change. We just seem to literally not want to go deep enough and we use the lazy word of random and probability as pseudo for knowledge, and it's not knowledge. It's literally just if context is the same, if outcomes is the same, then I can do it. But if I listen to football stats, third down in preseason is very different than third down in playoffs, right? And so giving me a stat about how their third down conversion is across the whole season makes no sense to me because the context is different.

**中文翻译:**
第二部分是，如果是一个已经存在一段时间的成熟产品，我会去和那些“流失”的客户聊。因为在流失过程中，有趣的是当某人离开你的产品时，他们仍然在寻求进步。我们觉得流失很糟糕，事实也确实如此，但在他们看来：“是的，这太难太复杂了，”或者“它对我们来说不够用。”这让你能理解他们经历的挣扎时刻，因为他们原本在使用你的产品，但发生了某些事，情境变了，他们开始感到挣扎，于是不得不寻找别的东西。
(00:35:43):
没人喜欢改变。所以最容易观察的就是：告诉我人们为什么改变。我们似乎只是不想深入研究，而是懒惰地用“随机”和“概率”来充当知识，但那不是真正的知识。只有当情境相同、结果相同时，概率才有意义。就像橄榄球统计数据，季前赛的三档进攻和季后赛的三档进攻完全不同。所以给我一个全赛季的三档转化率统计对我来说毫无意义，因为情境变了。

---

### [00:36:43] [Bob Moesta]

**English:**
The very first thing I would say is I never trust anybody telling me things they're going to do because they can't assure it, and it usually never happens. It's my experience that says that. And so the thing is, I need to talk to people who did something and tried and though they might've failed, what made them try? So the phrase I have 'Bitchin' ain't switchin'." Just because people bitch about something doesn't mean they're going to do anything about it. This is where at Basecamp, we learned the fact that everybody said, "Oh, if you had Gantt charts, I'm going to leave you if you don't put Gantt charts in or resource allocation," and as much as they all say they want it, they're not leaving because of it.
(00:37:23):
And this is the other part, if you follow your best users, they'll take you up to this world that then actually destroys the lower end of the world of why people are there. And so if Basecamp would've added all those things, one of the reasons why people join Basecamp is because it's so dang simple. And if I start to add all these things that make it more complicated, it doesn't work.

**中文翻译:**
我首先要说的是，我从不相信任何人告诉我他们“打算”做什么，因为他们无法保证，而且通常也不会发生。这是我的经验告诉我的。所以，我需要和那些已经采取了行动、尝试过的人谈，即使他们失败了，也要问是什么促使他们尝试。我有一句话叫：“抱怨不代表会切换”（Bitchin' ain't switchin'）。仅仅因为人们抱怨某事，并不意味着他们会采取行动。我们在 Basecamp 学到了这一点：大家都说“如果你不加甘特图或资源分配功能，我就不用了”，尽管他们都说想要，但他们并不会因此离开。
(00:37:23):
另一部分是，如果你盲目跟随你的“核心用户”，他们会把你带向一个高度复杂的世界，从而摧毁了吸引普通用户的根基。如果 Basecamp 加上了所有那些功能，它就不再是 Basecamp 了，因为人们加入的原因正是因为它极其简单。如果我开始增加这些让它变复杂的功能，它就失效了。

---

### [00:37:55] [Bob Moesta]

**English:**
So for example, in the first five minutes of an interview, they're going to tell you, "I bought a new car because I got a deal on it and it was a car I've been dreaming about forever," and it's like they have all these things and then when you start to get to, it's like, no, the old car had 280,000 miles on it. You had three large bills in the last four months. The fact is it's making a sound and you've got a long trip coming up, that's why you're getting a car. You're not getting the car because of the deal. And so there's these, I call it the layers of language. And the very first layer is called the pablum layer, where people just, "How was your day?" "Oh, it was good," but nobody knows what that means. And if you ask one further question, "Well, what was good about it?" They're like, "Ugh."
(00:38:34):
And then you get to the next layer, the next layer is usually the fantasy nightmare layer, "Oh, it was so good because of this," or, "Oh my God, it was so bad because..." They exaggerate to one degree or the next. And then what you want to do is actually then pull it back to what actually happened. This is where you've got to be more of an investigator and an interrogator. And the way I would describe it is it's criminal and intelligence interrogation that feels like therapy because most people don't actually know why they bought because they only think about the time they wrote the check, swiped the card. But the reality is like I did an interview with somebody who bought a coat rack, $137 coat rack. It took them 18 months to buy it. And in their mind, they say they bought it in a week, but the reality is the debate about getting it and why they couldn't get it was happening for over 18 months. So this is where you can't believe what they say, you have to do your investigation to get there.

**中文翻译:**
例如，在访谈的前五分钟，他们会告诉你：“我买新车是因为有个优惠，而且这是我梦寐以求的车。”他们会说出一堆理由。但当你深入挖掘，你会发现：不，是因为旧车已经开了 28 万英里了，过去四个月修了三次大钱，车子开始发出怪声，而你马上要出远门，这才是你买车的原因。你不是因为优惠才买的。这就是我所说的“语言的层次”。第一层叫“废话层”（pablum layer），就像问“今天过得怎么样？”回答“挺好”，但没人知道这什么意思。如果你追问“哪里好？”，他们就支支吾吾了。
(00:38:34):
下一层通常是“幻想/噩梦层”：“哦，太棒了，因为……”或者“天哪，太糟了，因为……”他们会夸大其词。而你要做的是把他们拉回到“实际发生了什么”。这时你必须更像一个调查员或审讯员。我把它描述为一种“感觉像心理治疗的刑事和情报审讯”，因为大多数人其实不知道自己为什么要买，他们只记得开支票或刷卡的那一刻。但现实是，我曾访谈过一个买衣帽架的人，一个 137 美元的衣帽架，他花了 18 个月才决定买。在他脑子里，他觉得只花了一周，但实际上关于买不买、为什么不能买的纠结已经持续了 18 个月。所以你不能全信他们说的话，你必须通过调查来还原真相。

---

### [00:39:36] [Bob Moesta]

**English:**
The intention, it's the context that they're in and the outcome. So here's the thing is that most people talk about you want to get to this outcome and people value this outcome, but value is not just the outcome. Value also has where you start. So if I start here and I end here, I'm going to value it this much. But if I start down here... Wait, I've got to get there, start down here, and I go up here, I value it that much more. And so part of it is value is actually part of where they're starting from and where they want to go. And most people say, "If I just get them up here, they're really going to love it," but some people say, "I just want to get here." And so you're overshooting it and they actually want a price discount because you're giving them more than they want.

**中文翻译:**
意图，就是他们所处的情境和想要的结果。问题在于，大多数人只谈论“你想达到这个结果”以及“人们看重这个结果”，但价值不仅仅在于结果。价值还取决于你的起点。如果我从这里开始到这里结束，我会觉得它值这么多。但如果我从更低的地方开始，达到同样的高度，我会觉得它价值大得多。所以价值实际上取决于起点和终点的差距。大多数人认为“只要我把他们带到这个高度，他们就会爱死它”，但有些人会说“我只想达到这里”。所以你做得过头了（overshooting），他们反而想要折扣，因为你给了他们不想要的多余东西。

---

### [00:41:03] [Bob Moesta]

**English:**
I already told you an example. I can't say it, but you can. The thing is, for example, Autobooks is another one that did this, right? They start to realize that the fact is you need to study the struggling moments and it helps you determine what not to build, right? Too many times we just keep adding more and more things to the product. And so in larger organizations it's very difficult because at some point the dominant market research is about hypothesis testing, "I'm going to go build a hypothesis and go basically then go build a research project to prove or disprove that hypothesis."
(00:41:44):
But the reality is, Jobs to Be Done research is hypothesis building research. I don't know, that's part of the point is we really don't know. We think we know, but Dr. Taguchi would always tell me there's way more unknown than there is known and never forget it. And so again, what causes people to buy windows is not what we think it is. And so you start to realize that. I think Drucker said it best, he goes, "What businesses think they're selling is not what customers are buying." And to be honest, he said that in 1953, and it's still true today. I just did interviews today where they're like, "Oh, people are buying for this reason," and we did 12 interviews and you started to realize, nope, that's not why they're buying. And they're shocked.

**中文翻译:**
我已经举过一个例子了（指 Facebook Marketplace）。我不能明说，但你可以猜到。另一个例子是 Autobooks。他们意识到你必须研究挣扎时刻，这能帮你决定“不造什么”。太多时候我们只是不断往产品里塞功能。在大型组织中这很难，因为主流的市场调研是“假设检验”：“我要建立一个假设，然后做一个研究项目来证明或证伪它。”
(00:41:44):
但现实是，JTBD 研究是“假设构建”研究。我们其实不知道答案，这就是重点。我们以为自己知道，但田口博士（Dr. Taguchi）总是告诉我：未知的远比已知的多，永远不要忘记这一点。所以，人们买窗户的原因并不是我们想象的那样。德鲁克（Drucker）说得最好：“企业认为自己在卖的东西，往往不是客户在买的东西。”老实说，他在 1953 年就说了这话，今天依然适用。我今天刚做完访谈，客户说：“哦，人们是因为这个原因买的，”结果做了 12 个访谈后发现，根本不是。他们都惊呆了。

---

### [00:43:57] [Bob Moesta]

**English:**
Very early, yeah.

**中文翻译:**
非常早，是的。

---

### [00:44:10] [Bob Moesta]

**English:**
This is where I think there's different flavors of it. And what I would say is that one flavor is really what I call very supply side driven, where it takes the underlying technology and then looks at it and says, "All right, what else can we do? Where can we be better? Where are things that are important but we're not satisfying on them?" And being able to prioritize. And so there's a very systematic approach that's hundreds of steps and very, very prescriptive in nature.
(00:44:38):
The method that I have and that I've been using mostly because I've been in the startup world and doing new to the world type stuff is it's very, very qualitative, organic, and it's a combination of a process, practice and skills. So every company actually has its own innovation process based on who they have, who they're serving, the underlying technology. And so, in my opinion, to have a very predictive one process that fits across everybody, I think there are principles, but I don't think there's one process. And so I think that's what they used at Twitter.
(00:45:16):
The other thing is that I think Jack was actually a big fan and he worked with Clay on a couple of things, but I don't think they worked on the method part of it, they worked on the thinking part of it. And so it was more about, so one of the most dangerous things you can do is sit in a room and hypothesize what the jobs are because I will guarantee you you're 100% wrong. And so this is what happens, by the way, this is the gift of dyslexia is I'm not an A student and so most A students don't start until they know the answer, most D students start because they don't know the answer. And so you start to realize we're wired very differently to do that. And so I always say that the A students have a disadvantage against the D students and entrepreneurship because we just go start and we learn right that in there. We don't have to hypothesize everything first because we actually don't know how to do that.

**中文翻译:**
我认为 JTBD 有不同的“流派”。一种流派我称之为“供给侧驱动”，它从底层技术出发，思考：“好吧，我们还能做什么？哪里可以做得更好？哪些重要需求还没被满足？”然后进行优先级排序。这是一种非常系统化的方法，有几百个步骤，极具规范性。
(00:44:38):
而我一直使用的方法（主要因为我身处创业圈，做的是开创性的东西）是非常定性的、有机生成的，它是流程、实践和技能的结合。每家公司其实都有基于其人才、客户和技术的独特创新流程。在我看来，想要一套放之四海而皆准的预测性流程是不现实的。原则是通用的，但流程不是。我想 Twitter 当时用的就是那种规范化的流程。
(00:45:16):
另一件事是，我想 Jack (Dorsey) 确实是粉丝，他和克莱（Clay）合作过几次，但他们合作的是“思维”层面，而不是“方法”层面。最危险的事情之一就是坐在办公室里假设“任务”是什么，我保证你 100% 会错。顺便说一下，这就是阅读障碍带给我的礼物：我不是优等生。大多数优等生在知道答案前不敢开始，而差生因为不知道答案才开始。你会发现我们的思维构造完全不同。我总说在创业领域，优等生相对于差生是有劣势的，因为我们直接开始，在过程中学习。我们不需要先假设一切，因为我们根本不会那一套。

---

### [00:46:21] [Bob Moesta]

**English:**
Yeah. They think more about the outcomes and they think about what's the best outcomes we can get for people. And what you start to realize is that there are trade-offs people make. And ultimately there's some irrational piece, some irrational component that makes everything twist around. The irrational component is like, why in the world do people eat Snickers when they're hungry? It's a candy bar. Well, it turns out when you bite it, it masticates into a ball and it sits in your stomach and it absorbs the acid that's causing you to say, "Hey, I got to eat something." And so part of it is the roll of the peanuts and the roll of the nougat is actually to masticate it together. The caramel should be sticking it together versus in a Milky Way, the melting temperature of the caramel is so light that you take a bite, it's liquid, you drink it down, you swallow it like it's a drink, it has nothing to do with food.
(00:47:13):
And so you start to realize that it's connecting the experiences to the context and outcome. It's connecting the supply side with the demand side, but it starts with the demand side first. Struggling moments and opportunities all exist before there's a product.

**中文翻译:**
是的。他们过多地思考结果，思考能给人们带来的最佳结果。但你会意识到人们是在做权衡。最终，总有一些不合理的因素让事情发生转折。比如，为什么人们饿的时候会吃士力架？它只是个糖果棒啊。事实证明，当你咬它时，它会咀嚼成一个球状物留在胃里，吸收引起饥饿感的胃酸。所以花生和牛轧糖的作用其实是把它们嚼在一起，焦糖负责粘合。相比之下，星河巧克力的焦糖熔点非常低，你咬一口它就化成液体了，你像喝饮料一样把它咽下去，它跟填饱肚子没关系。
(00:47:13):
所以你会意识到，这是将体验与情境和结果联系起来。是将供给侧与需求侧联系起来，但必须从需求侧开始。挣扎时刻和机会在产品出现之前就已经存在了。

---

### [00:48:34] [Bob Moesta]

**English:**
So Clay and I collaborated on it. So I was lucky enough to have Clay as a mentor for 27 years, I met with him once a quarter for 27 years, and at some point I shared with him the hack of how I was thinking about this and what I was doing, and at some point he said, "We need to turn it into a theory." To me, it was more like my work around because I couldn't read and write, "Let me go talk to some people, I'll figure it out." And ultimately we turned it into a theory. So if you look at Competing Against Luck, it was written with Tady Hall and Karen Dillon, Dave Duncan, but I helped on that book for 16 months. Some of the clients in there are my clients. I think Intercom is in that one. So Clay and I are aligned in that. Clay was more about turning it to a theory and I would say I'm more about having it be a method. So his is like a thinking framework and a philosophy and a strategic kind of frame where mine is very tactical about how do we get it and then what do we do with it.
(00:49:31):
Ulwick's comes from a very different perspective, and again, I think it's very valuable, but it comes from the notion of functions and it's more like, what can our product do? What jobs can our product do? As opposed to the way I look at it is basically only people have jobs, products don't have jobs, people have jobs, organizations don't have jobs, people in organizations have jobs because that's the irrational part. And so fundamentally there's that two different views of how do we look at it, but ultimately I would say Clay's approach and my approach are derived from the same dataset where Ulwick's is derived from a different dataset and a different set of experiences.

**中文翻译:**
克莱和我在这方面有合作。我很幸运能让克莱担任我 27 年的导师，这期间我们每季度见一次面。有一次我向他分享了我思考这些问题的“捷径”和我正在做的事，他说：“我们需要把它变成一套理论。”对我来说，这更像是因为我不会读写而采取的权宜之计：“让我去跟人聊聊，我就能搞明白。”最终我们把它变成了理论。如果你看《与运气竞争》（Competing Against Luck），那是他与 Tady Hall、Karen Dillon 和 Dave Duncan 合著的，但我为那本书协助了 16 个月。书里的一些客户是我的客户，比如 Intercom。所以克莱和我在这一点上是一致的。克莱更倾向于将其理论化，而我更倾向于将其方法化。所以他的更像是一个思维框架、哲学和战略构架，而我的则非常战术化：我们如何获取洞察，以及拿到后该怎么做。
(00:49:31):
Ulwick 的方法源自完全不同的视角。我认为它也很有价值，但它源自“功能”的概念，更像是：“我们的产品能做什么？我们的产品能完成什么任务？”而我的观点是：只有“人”才有任务，产品没有任务；组织也没有任务，是组织里的人有任务，因为那是感性的部分。所以从根本上说，这是两种不同的视角。但我会说，克莱和我的方法源自同一组数据集，而 Ulwick 的方法源自不同的数据集和经验。

---

### [00:51:11] [Bob Moesta]

**English:**
Oh yeah. So couple places, one is when there's no choice or there's no real choice. So what's interesting is think about is why do you know more about your car insurance than your health insurance, right? And most of it is because your health insurance is given to you by your employer and you only utilize it when you're sick. But the car insurance, you have to pay for it so you have to sit down and decide what are the different trade-offs you're going to make where when you do it for the employer, it's good, better, best. And it literally is like, where am I my life? Have I been sick? There's some basic things, but there's no real choice there.
(00:51:48):
And so you start to realize where there's no real choice or where people want to make the choice obvious, it doesn't work. You have to be able to accept how people see you as opposed to how you want to be seen. So when companies will come to us and say, "All right, I want you to find these jobs for us," like, "Nope, I can't do it because it doesn't work. I can tell you what the demand side is asking for and then we can see how your product fits to it and what you have to modify to it, but if I try to help you build the case to make the jobs what you think they are, it doesn't work."

**中文翻译:**
当然有。有几个场景不适用：一是当没有选择或没有真正的选择时。有趣的是，想想为什么你对汽车保险的了解比对医疗保险多？主要是因为医疗保险是雇主给你的，你只有生病时才用。但汽车保险是你自己掏钱买的，你必须坐下来决定做哪些权衡。而雇主提供的保险通常只是“好、更好、最好”几个档次，你只需根据生活现状选一个，没有真正的选择空间。
(00:51:48):
你会发现，在没有真正选择，或者人们想让选择变得显而易见的地方，JTBD 就不起作用。你必须能够接受人们如何看待你，而不是你想如何被看待。所以当公司来找我说“我想让你帮我们找到这些任务”时，我会说：“不，我做不到，因为那行不通。我可以告诉你需求侧在要求什么，然后看你的产品如何匹配，以及需要修改什么。但如果我想帮你证明‘任务就是你想象的那样’，那是行不通的。”

---

### [00:52:26] [Bob Moesta]

**English:**
In a lot of cases to me, I'd do some ethnography, I'd literally figure out kind of where there's frictional points in the system. I might do some prototyping around kind of different alternatives, but typically it's more about what I would call the little hire or how do they use, for example, the health insurance as opposed to why do they buy the health insurance.
(00:52:48):
The other example I could use is chewing gum. If I talk to people about buying a pack of chewing gum, most people can't remember at all when they bought a pack of chewing gum, even if it was in the last week like, "Uh, I think so." But if I asked them when they chewed gum, they can tell me about when they chewed gum. And ultimately that will then imply when they buy gum. If you go to something that it doesn't register, it's so deep of a habit that they don't really know what they're doing, you'll never going to be able to get that information out of them. Again, the habitual stuff is very hard to see the job. It's only when people change do you see, it's like you can reveal the entire iceberg but if I've been using Tide for 20 years and I ask you why do you hire Tide, you just make it up. You have no idea why you Tide. But if you switch from Tide to Gain or Gain to Tide, you can tell me that story very detailed.

**中文翻译:**
在很多情况下，我会做一些民族志研究（ethnography），找出系统中的摩擦点。我可能会针对不同的替代方案做一些原型设计。但通常这更多是关于我所谓的“小雇佣”（little hire），即他们如何“使用”产品（比如医疗保险），而不是他们为什么“购买”它。
(00:52:48):
另一个例子是口香糖。如果我问人们买口香糖的事，大多数人根本记不起什么时候买的，即使是上周买的。但如果我问他们什么时候“嚼”口香糖，他们能说得很清楚。这最终会暗示他们什么时候买。如果你研究的是那种完全无意识的、根深蒂固的习惯，你永远无法从他们口中获得真实信息。习惯性的东西很难看出“任务”。只有当人们发生“改变”时，你才能看清。这就像揭开整个冰山：如果我用了 20 年汰渍（Tide）洗衣粉，你问我为什么雇佣汰渍，我只会瞎编，因为我根本不知道。但如果你从汰渍换成了 Gain，或者从 Gain 换成了汰渍，你能把那个故事讲得非常详细。

---

### [00:53:59] [Bob Moesta]

**English:**
The first thing I want to say is actually, in doing it, I've explicitly made it very accessible because the moment you make it too copywritten, too patented, too whatever, people just move by it. So part of it was being able to make it in the public domain so people could have conversation and try it and do different things with it.
(00:54:21):
What I would say is there's enough people that have used it and have worked with it and have had great success with it that at some point in time, most of the people who are trying it and not using it well, it's obvious. And so it'd be lik, how do you double down into it? I think one of the biggest misconceptions around Jobs to Be Done is this notion that it's pain and gain as opposed to context and outcome. And that I think one of the other ones is it's purely about the outcome and not just about the context and outcome together.
(00:54:51):
And again, I think the biggest mistakes I've seen made is because they do it in a conference room and they don't go talk to people. They don't actually find the contradictions, they don't find the irrational parts. What's really interesting is when you hear somebody's story and it seems irrational, like we'll have people go, "Oh my God, that's an anomaly. That doesn't happen." But what you realize is that the context makes the irrational rational. So the moment you hear a story and you go, "I can't believe that," nine times out of 10 it's because you don't have the rest of the story. And so part of it's being able to understand the rest of that context that would drive somebody say, "Why would somebody cut their arm off?" Well, if they're in this situation and this and this and this, there's nobody who would say they want to cut their arm off, but in certain situations you'll do it.
(00:55:37):
And so that's what we're trying to do is find where will people change behavior? Most people are studying the momentum of where people are and what's the momentum of their direction, but the reality is what we're trying to do is study what causes people to change their direction. And that's where innovation happens. Innovation happens when people change.

**中文翻译:**
首先我想说，在推广这个框架时，我特意让它变得非常易于获取。因为一旦你把它搞得版权森严、专利重重，人们就会敬而远之。所以，把它放在公共领域，让大家讨论、尝试并灵活运用，是我的初衷。
(00:54:21):
我想说的是，已经有足够多的人使用它并取得了巨大成功。那些尝试了但没用好的人，原因通常很明显。我认为 JTBD 最大的误解之一就是认为它是“痛苦与收益”，而不是“情境与结果”。另一个误解是认为它纯粹关乎结果，而忽略了情境与结果的结合。
(00:54:51):
此外，我见过的最大错误是人们只在会议室里闭门造车，而不去跟人交流。他们发现不了矛盾，发现不了不合理的地方。最有趣的是，当你听到一个看似不合理的故事时，比如有人说“天哪，那是特例”，你会意识到是情境让不合理变得合理。当你觉得“不可思议”时，十有八九是因为你没听全故事。理解那些驱动行为的情境，比如“为什么有人会砍掉自己的手臂？”，在特定极端情境下，谁都会这么做。
(00:55:37):
这就是我们要做的：寻找人们在什么时候会改变行为。大多数人在研究人们现状的惯性，而我们要研究的是什么导致人们改变方向。这就是创新发生的地方。创新发生在人们改变的时候。

---

### [00:56:08] [Bob Moesta]

**English:**
That's a great question. So I think I started out as I just love to build things. My mom would take me, basically we have something around here called Big Trash Day is where they throw out the dishwasher and they throw out the old mini bike and all these different things. And my mom would basically say anything that we could fit in the trunk, we could bring home. And so I've been building things my whole life because I've been just always fascinated with how things work. So that's the first thing.
(00:56:38):
The second part is I love to help people. One of the things I realized is I can't build products for myself, and I've done seven startups, but I realized that I have to build for others. And so to me, building for others was where I started product. And then I realized that I'm a method builder and that I really help people innovate. And so I exist to help make the abstract concrete. So that phrase has helped lead me to becoming now a teacher and a professor and writing books is something I never wanted to do because I hated books. Clay convinced me that I had to learn how to speak and I had to write books.
(00:57:18):
So here's a really good one is that this is in 1990, so one of the things that happened was when my youngest kid moved out and basically moved out of the house, I had my notebooks from almost 30 years of every project on everything I worked on any company, and this is from one of my mentors, Dr. Taguchi, he said this in 1990 when I was living in Cologne, Germany. He said, "Write a book." So I opened this 30 years later, I'm like, "Oh, dang it. I got to write a book because he told me to." So it's just one of those things where I realized I really like helping people, I like creating methods. I'm very curious, sometimes annoyingly curious, but that's kind of the triad of things that I love to do.

**中文翻译:**
问得好。我想我起初只是单纯热爱创造东西。我妈妈会带我去参加这里的“大垃圾日”，那天人们会扔掉旧洗碗机、旧迷你摩托车之类的。我妈说只要后备箱装得下，我们就能带回家。所以我这辈子都在造东西，因为我一直对事物的运作原理着迷。这是第一点。
(00:56:38):
第二点是我喜欢帮助别人。我意识到我不能只为自己造产品（虽然我做过七次创业），我必须为他人而造。对我来说，为他人而造是产品的起点。后来我意识到我是一个“方法构建者”，我真正做的是帮助人们创新。我的存在是为了让抽象变得具体。这句话引导我成为了老师、教授，并开始写书——虽然我以前讨厌书，从没想过要写。是克莱说服我必须学会演讲和写书。
(00:57:18):
这里有个有趣的故事：1990 年，当我最小的孩子搬出去住时，我翻出了过去 30 年在不同公司做过的每一个项目的笔记。我的导师田口博士在 1990 年我住在德国科隆时对我说：“写本书吧。”30 年后我看到这句话，心想：“该死，我得写本书，因为他叫我写。”所以，我意识到我喜欢助人，喜欢创造方法，而且我有着近乎烦人的好奇心，这就是我热爱的事业的三大支柱。

---

### [00:58:14] [Bob Moesta]

**English:**
There's three big things to take away. One is struggling moments is the key and it's struggling moments that people take action on. And what I would say is they're everywhere. They are freaking everywhere in our lives and there's only certain contexts when all of a sudden we realize we have to do something about it. So study struggling moments because at some point that's where we need the innovation the most. The second thing is think about the progress people are trying to make. What is their standard, not your standard? What is that context? What is that outcome? And the last thing, the way I phrase it is choose what to suck at and figure out the trade-offs that you need to make and make sure that your trade-offs map the trade-offs of the customer. Because nine times out of 10, most products that fail is because they made a trade-off that the customer didn't agree with.

**中文翻译:**
有三点核心总结。第一，“挣扎时刻”是关键，它是促使人们采取行动的动力。挣扎时刻无处不在，充斥在我们的生活中，只有在特定情境下，我们才会意识到必须采取行动。所以要研究挣扎时刻，因为那是创新最迫切的地方。第二，思考人们想要取得的“进步”。要用他们的标准，而不是你的标准。情境是什么？结果是什么？最后一点，我的说法是“选择在哪些方面做得烂”，弄清楚你需要做的权衡，并确保你的权衡与客户的权衡相匹配。因为十有八九，产品失败是因为开发者做了一个客户不认同的权衡。

---

### [00:59:19] [Bob Moesta]

**English:**
Shape Up by Ryan Singer, it's phenomenal. The other book I would say is End of Average by Todd Rose. I listen to it every single year. I get something on it every single year. I've been listening to it for probably eight or 10 years. I literally called Todd, I've become friends with Todd. We interact on a regular basis. It's an amazing book.

**中文翻译:**
Ryan Singer 的《Shape Up》，非常出色。另一本是 Todd Rose 的《平均的终结》（End of Average）。我每年都会听一遍，每年都有新收获。我已经听了大概八到十年了。我甚至直接给 Todd 打了电话，现在我们成了朋友，经常交流。那是一本了不起的书。

---

### [00:59:42] [Bob Moesta]

**English:**
I love Big Bang. I watch it every... People would say that I'm Sheldon, I think I'm more Leonard, but I can see there's days that I come across as Sheldon, I don't mean to be Sheldon. But I like Oppenheimer. I think any of the science type, I'm not really a science fiction person, but it's more about, I'll say historic documentaries, I love them all because they help me understand the science.

**中文翻译:**
我喜欢《生活大爆炸》（Big Bang Theory）。别人说我像 Sheldon，我觉得我更像 Leonard，但我承认有时我确实表现得像 Sheldon，虽然我不是故意的。我也喜欢《奥本海默》。我喜欢科学类的东西，虽然我不怎么看科幻，但我非常喜欢历史纪录片，因为它们能帮我理解科学。

---

### [01:00:14] [Bob Moesta]

**English:**
What are the top three things you struggle with in your business today that if you could solve would fundamentally change the business?

**中文翻译:**
你目前业务中面临的哪三个最大的挣扎，如果能解决，将从根本上改变你的业务？

---

### [01:00:28] [Bob Moesta]

**English:**
I recently purchased a massage chair, and it's one of those things where I've been getting massages for a while, and as I get older and I'm working out more, I've lost almost 100 pounds. And so I'm to the point where I'm working out more and God, nobody told me I'm going to be cold all the time, I'm sore all the time and I'm hungry all the time. And so it's like, "Okay, I need a way in which this..." So I would get a massage every two weeks or so, and now I can get a massage in 20 minutes on demand. And it's pretty freaking amazing.

**中文翻译:**
我最近买了一把按摩椅。我一直有按摩的习惯，随着年龄增长和运动量增加（我减掉了近 100 磅），我发现自己总是感到冷、肌肉酸痛且容易饿。以前我每两周去按摩一次，现在我可以随时享受 20 分钟的按摩。这简直太棒了。

---

### [01:01:18] [Bob Moesta]

**English:**
Kyoto is the one that I have. I got it from Costco. It's fabulous.

**中文翻译:**
我买的是 Kyoto 牌的。在 Costco 买的，非常棒。

---

### [01:01:33] [Bob Moesta]

**English:**
There's two. One is Intercom. So the way that Intercom really took off and why it did so well is actually, it was Des Traynor and Eoghan McCabe who were the two founders, they actually studied, they came to one of my workshops in the beginning, but they studied it and they tried to do it, and then we talked about it. But then they brought Matt Hodges and Paul Adams and Sean Townson and the executive team, and they did the interviews. And when they did the interviews, they understood what to do and it literally all went downhill from there. And they knew how to ask the questions.
(01:02:23):
The other is to find a place in a very large organization where a group is struggling, they can't deliver product, they can't move fast enough, they keep getting the wrong insights, they say it's going to be this big, and literally focusing on a very small area and giving them a little space to demonstrate the use of it, and then it will spread with a case study or two. And so most companies, if they start small case studies and sharing it with people both when it works and not works, or starting with the top.

**中文翻译:**
有两个例子。一个是 Intercom。Intercom 真正起飞的原因是两位创始人 Des Traynor 和 Eoghan McCabe 早期参加了我的工作坊，他们深入研究并尝试应用。后来他们让整个高管团队（包括 Matt Hodges, Paul Adams 等）亲自去做访谈。一旦他们亲自做了访谈，就明白该怎么做了，之后的一切都顺理成章了。他们学会了如何提问。
(01:02:23):
另一个是在大型组织中找一个陷入困境的小组——他们无法交付产品、速度太慢、洞察错误。专注于一个非常小的领域，给他们一点空间去演示如何使用 JTBD，然后通过一两个案例研究进行推广。大多数公司如果能从小的案例研究开始，并分享成功与失败的经验，或者从高层开始推动，效果会很好。

---

### [01:03:01] [Bob Moesta]

**English:**
Yeah. So one of the things I did is I built houses. So before I built houses, I was running a venture capital, private equity firm. We had about 100 million. I was doing 25 transactions and just traveling too much, I had four children. And so my wife and I kind of had the conversation that I wound it down and I said, "What am I going to do?" I wanted to try and find a business I could work in and be part of and own part of so I joined a building company here in Detroit, and we ended up building a thousand homes here in Detroit and had 14 sites. One of the things we did is we built for downsizers like your parents. And one of the things they constantly told us was, "Look, we're downsizing. We're not having the holidays. We're done with that. I don't want a dining room table, so we can't even have people over. If we're going to do it, we're going to go somewhere else. I don't want the dining room table."
(01:03:50):
And so we made, it's a two bedroom, two and a half bath, first floor laundry, gourmet kitchen, kind of amazing condo. But what we realized is people, if they didn't know where the dining room table was going to go, they weren't going to move. And so it turns out that the dining table was the emotional bank account for their entire life. And so if you weren't going to take it or your sister wasn't going to take it or your brother wasn't going to take it, the reality is they weren't going to give it the Goodwill, it was not going to go in the basement. It might go into the storage unit, but for the most part, people would literally stay where they are until they knew where the dining table's going to go.
(01:04:25):
So I did the opposite of what they told me to do, which is I built a place to put the dining room table. You could never eat at it, it was never big enough to actually pull the chairs out of it, but it was still a symbolic of what it was and they would use it for puzzles and that kind of stuff. But I sacrificed the second bedroom suite to basically add that, and it increased sales 22%. So this is a case where you learn, again, that irrational contradiction that says, "They've said this, but you did that. That doesn't make any sense." That's what jobs helps you with, those kinds of really important, small but subtle and important insights.

**中文翻译:**
是的。我以前盖过房子。在盖房子之前，我经营一家风险投资和私募股权公司，管理约 1 亿美元。我当时处理 25 笔交易，出差太多，而我有四个孩子。我和妻子商量后结束了那份工作。我想找一个能亲身参与并持股的业务，于是加入了底特律的一家建筑公司。我们最终在底特律盖了 1000 套房子。我们针对像你父母那样想要“大房换小房”（downsizers）的人群。他们总是告诉我们：“听着，我们要换小房子住，不再操办节日聚会了，我们不需要餐桌，也不打算请人来家里。如果聚会，我们会去别处。我不要餐桌。”
(01:03:50):
于是我们设计了非常棒的公寓：两室两卫半，一楼洗衣房，高级厨房。但我们发现，如果人们不知道原来的餐桌该放哪，他们就不会搬家。事实证明，餐桌是他们一辈子生活的“情感银行账户”。如果你的兄弟姐妹都不想要这张桌子，他们也不忍心把它捐给慈善机构或扔进地下室。他们宁愿留在老房子里，直到知道餐桌的去处。
(01:04:25):
所以我做了与他们所说的相反的事：我专门设计了一个放餐桌的地方。你永远没法在那儿吃饭，因为空间不够把椅子拉出来，但它具有象征意义，他们可以用它来拼图之类的。我牺牲了第二个卧室的套间来增加这个空间，结果销量增长了 22%。这就是你学到的那种“不合理的矛盾”：他们嘴上说一套，但你做另一套才有效。这就是 JTBD 能帮你的——发现那些微小、微妙但极其重要的洞察。

---

### [01:05:09] [Bob Moesta]

**English:**
Yeah, so at the end of the night, I have this philosophy that I have the energy in your body and your brain literally you need to use every ounce of it every day because you wake up the next day with a full bank account and you can't really save it. So every night I paint. And so these are paintings of my mentors and they're above me, but Dr. Deming, Clay, Dr. Taguchi, and Dr. Willie Moore, I wrote about him in a book called Learning to Build, and the five skills that they taught me to enable me to kind of work on so many different things in different areas.
(01:06:20):
And then the last one was Clay Christensen, which is I just walked in his office and he had a sign outside his office basically saying anomalies wanted, and I walked in and I said, "Look, I'm an anomaly. I don't really know if you want anomalies, but I am." And we sat down and started talking, and ultimately I asked him, "What's your research and how can I help?" He had been there maybe about a year, and it was one of those things where he got kind of somber and it was almost like he had a tear, and I was like, "What's going on?" He goes, "I've been here a year and everybody's asked me for things, but nobody's ever asked to help me, and you're the first person." And so that was the beginning of the relationship, and I had four hours a quarter for 27 years with Clay with no agenda, which is kind of amazing.

**中文翻译:**
是的。我有一个哲学：你每天身体和大脑里的能量都应该用光，因为第二天醒来你的“能量账户”又是满的，你没法把能量存起来。所以每晚我都画画。这些是我导师的画像，挂在我上方：戴明博士、克莱、田口博士和 Willie Moore 博士。我在《学习构建》（Learning to Build）一书中写过他们，以及他们教会我的五项技能，让我能在这么多不同领域工作。
(01:06:20):
最后一位是克莱·克里斯坦森。我当时走进他的办公室，他办公室外挂着个牌子写着“征集异常现象”（anomalies wanted）。我走进去说：“听着，我就是一个异常现象。我不知道你是不是真的想要，但我就是。”我们坐下来开始聊，最后我问他：“你的研究是什么？我能帮上什么忙？”他当时在那儿待了大约一年。他突然变得很严肃，甚至眼含泪水。我问怎么了，他说：“我来这一年了，所有人都是来找我要东西的，从来没人问过能帮我什么，你是第一个。”那就是我们关系的开始。在随后的 27 年里，我每季度有 4 小时与克莱相处的时间，没有任何预设议程，这真的很神奇。

---

### [01:07:21] [Bob Moesta]

**English:**
Yeah, LinkedIn is probably the best place, and I post most of the stuff there. And then I have several different companies, but one is called The Rewired Group, and I've had that for about 14 years, and that's a design consultancy agency around helping people build and launch products. And we do everything from Fortune 100 to not-for-profits, to startups and different ways. And then I have something called Laser Ventures where we actually work for equity and we also put money into investments as well. And that's called Laser Ventures with Andrew Glazer. And we have a podcast called The Circuit Breaker, which it's more or less all these different concepts in 20 minute format of me and my partner just riffing around what is the empathetic perspective or what are the forces of progress? Or just small little things that basically help people learn along the way, and it's just long enough for a commute or a walk or something like that.

**中文翻译:**
LinkedIn 可能是最好的地方，我大部分内容都发在那儿。我有几家不同的公司，一家叫 The Rewired Group，已经开了 14 年，是一家帮助人们构建和发布产品的设计咨询机构。我们的客户涵盖财富 100 强、非营利组织和初创公司。另一家叫 Laser Ventures，我们通过提供服务换取股权，也进行投资。我们还有一个播客叫《The Circuit Breaker》，每集 20 分钟，我和合伙人会探讨诸如“同理心视角”或“进步的力量”等概念，非常适合在通勤或散步时听。

---

### [01:08:20] [Bob Moesta]

**English:**
To be honest, I was so excited for this podcast. I was excited, one, because I'm a fan, but two is to see your post and then get all those responses. I think I said, "Boy, I think we need more than an hour. This is amazing." And so to be honest, posting questions, asking questions, letting the community kind of interact. And what was so interesting is it was people who had questions, but then there were people like Des and Jason who reached out and said, "Oh, this will be awesome. You'll love this." All those kind things.
(01:08:51):
So to me, just keep being a community. And what I would say is, as this is posted, just put more questions up there. The hard part for me is actually answering questions in a written form. My request would be is that if we can figure out a format so I can answer them more in a conversation where we almost like a list of things where there might be a follow-up of some sort, but if your listeners could literally help me by being more articulate, that would be great.

**中文翻译:**
老实说，我对这次播客非常兴奋。一是因为我是你的粉丝，二是因为看到你的帖子下有那么多回复。我当时想：“天哪，一小时肯定不够，这太棒了。”所以，继续发帖提问、让社区互动起来。有趣的是，不仅有提问的人，还有像 Des 和 Jason 这样的人特意过来说“这会很棒，你会喜欢的”。
(01:08:51):
所以对我来说，保持这种社区氛围就好。在这一集发布后，欢迎大家提出更多问题。对我来说，最难的部分是用书面形式回答问题（因为阅读障碍）。我的请求是，如果我们能找一种对话的形式来回答，比如列出清单然后我通过谈话来回复，或者有某种后续跟进，那就太好了。如果听众能把问题表达得更清晰、更具体，那对我帮助很大。

---

### [01:09:26] [Lenny]

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期内容有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期再见。