# Brendan Foody - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Brendan Foody, CEO of Mercor.

---

### [00:00:00] Brendan Foody

**English:**
The wealthiest companies in the world are willing to spend whatever it takes to improve model capabilities.

**中文翻译:**
世界上最富有的公司愿意不惜一切代价来提升模型的各种能力。

---

### [00:00:05] Lenny Rachitsky

**English:**
We are entering the era of evals.

**中文翻译:**
我们正在进入“评测”（Evals）时代。

---

### [00:00:07] Brendan Foody

**English:**
We started working with all of the top AI labs. What the labs need is labor marketplace. They actually need extraordinary professionals that can measure model capabilities.

**中文翻译:**
我们开始与所有顶尖的 AI 实验室合作。这些实验室真正需要的是一个劳动力市场。他们实际上需要极其优秀的专业人士来衡量模型的能力。

---

### [00:00:17] Lenny Rachitsky

**English:**
They found this pocket, maybe the biggest business opportunity in history.

**中文翻译:**
他们发现了这个切入点，这可能是历史上最大的商业机会。

---

### [00:00:20] Brendan Foody

**English:**
We grew from 1 to 400 million in revenue run rate in 16 months, fastest ascent in history.

**中文翻译:**
我们的营收年化运行率（Revenue Run Rate）在 16 个月内从 100 万美元增长到了 4 亿美元，这是历史上最快的增长速度。

---

### [00:00:27] Lenny Rachitsky

**English:**
Why is this so valuable?

**中文翻译:**
为什么这如此有价值？

---

### [00:00:29] Brendan Foody

**English:**
The market is bound by the amount of things where humans can do something that models can't. The lab's primary bottleneck to improve models is how they can effectively have some way of measuring what success looks like for the model.

**中文翻译:**
这个市场的边界取决于人类能做而模型做不到的事情。实验室改进模型的主要瓶颈在于，他们如何能有效地通过某种方式来衡量模型的“成功”标准。

---

### [00:00:43] Lenny Rachitsky

**English:**
There's this tweet that you retweeted. "If you really think about it, we were put on Earth to create reinforcement learning training data for labs."

**中文翻译:**
你转发过这样一条推文：“如果你仔细想想，我们被降临到地球上，就是为了给实验室创建强化学习（Reinforcement Learning）的训练数据。”

---

### [00:00:49] Brendan Foody

**English:**
It's highly likely that the entire economy will become an aural environment machine, building out all of these worlds and contexts. And I think the narrative in AI over the last three years has almost entirely been one of job displacement, but very few companies and people have talked about this new category of jobs that's being created.

**中文翻译:**
极有可能整个经济都会变成一个强化学习的环境机器，构建出所有这些世界和语境。我认为过去三年关于 AI 的叙事几乎全是关于“工作被取代”的，但很少有公司和个人讨论正在被创造出的这一类全新的工作岗位。

---

### [00:01:08] Lenny Rachitsky

**English:**
I talked to a lot of people about what should I be studying? Where should I be getting better?

**中文翻译:**
我经常和很多人聊：我该学习什么？我该在哪些方面提升自己？

---

### [00:01:12] Brendan Foody

**English:**
How can they leverage this technology to do so much more? We'll give people interviews where we say, "Use whatever tools are available to build a website and let's see what product you're able to build in an hour."

**中文翻译:**
他们如何利用这项技术做得更多？在面试中我们会告诉应聘者：“利用任何可用的工具去建立一个网站，让我们看看你在一小时内能做出什么样的产品。”

---

### [00:01:24] Lenny Rachitsky

**English:**
Today, my guest is Brendan Foody, CEO and co-founder of Mercor. Mercor is the fastest-growing company in history to go from 1 to $500 million in revenue. They did this in 17 months, less than a year and a half. Brendan is also the youngest unicorn founder ever. They just raised $100 million at $2 billion valuation. Mercor, if you haven't heard of them, helps AI labs and AI companies hire experts to help them train their models using AI. They've never had a customer churn, their net retention is over 1,600%, and they're on a nine-figure revenue run rate.

**中文翻译:**
今天的嘉宾是 Brendan Foody，Mercor 的首席执行官兼联合创始人。Mercor 是历史上增长最快的公司，营收从 100 万美元增长到 5 亿美元仅用了 17 个月，不到一年半的时间。Brendan 也是有史以来最年轻的独角兽创始人。他们刚刚以 20 亿美元的估值筹集了 1 亿美元。如果你还没听说过 Mercor，他们主要是帮助 AI 实验室和 AI 公司聘请专家，利用 AI 来训练他们的模型。他们从未有过客户流失，净留存率超过 1,600%，目前的营收年化运行率已达九位数。

---

### [00:01:59] Lenny Rachitsky

**English:**
In our conversation, we talk about the increasing value and importance of evals, the landscape of AI training companies like Mercor, and why they've become so important and valuable, how Brendan discovered this opportunity, his insights on what product market fit looks like, the core tenets he's instilled within his organization that have allowed him to build the fastest growing company in history, what people writing evals for labs are actually doing day to day, which skills and jobs are going to last the longest with the rise of AI, why he doesn't think we'll see AGI or superintelligence anytime soon, and so much more. This episode is incredible. You need to hear this.

**中文翻译:**
在我们的对话中，我们讨论了评测（Evals）日益增长的价值和重要性，像 Mercor 这样的 AI 训练公司的行业格局，以及为什么它们变得如此重要和有价值。Brendan 还分享了他如何发现这个机会，他对“产品市场契合点”（PMF）的见解，他在组织内部建立的、让他能够打造出史上增长最快公司的核心原则。此外，我们还聊到了为实验室编写评测的人每天具体在做什么，哪些技能和工作在 AI 崛起中能维持最久，为什么他不认为我们会很快看到 AGI（通用人工智能）或超级智能，以及更多精彩内容。这一集非常精彩，你绝对不能错过。

---

### [00:02:33] Lenny Rachitsky

**English:**
If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It helps tremendously. Also, if you become an annual subscriber of my newsletter, you get 15 incredible products for free for one year, including Lovable, Replit, Bolt, N8N, Linear, Superhuman, Descript, Whisperflow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD, and Mobbin. Check it out at lennysnewsletter.com and click Product Pass. With that, I bring you Brendan Foody.

**中文翻译:**
如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这对我们帮助很大。此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你可以免费获得 15 款出色产品的一年使用权，包括 Lovable、Replit、Bolt、N8N、Linear、Superhuman、Descript、Whisperflow、Gamma、Perplexity、Warp、Granola、Magic Patterns、Raycast、ChatPRD 和 Mobbin。请访问 lennysnewsletter.com 并点击 Product Pass 查看。下面，让我们欢迎 Brendan Foody。

---

### [00:03:01] Lenny Rachitsky (Ad)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know, like Vercel, Webflow, and Loom.

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，你的客户迟早会要求提供企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让你快速且无痛地为应用添加企业功能。他们的 API 易于理解，让你能快速交付并专注于构建其他功能。如今，数百家公司已由 WorkOS 提供支持，包括你可能熟悉的 Vercel、Webflow 和 Loom。

---

### [00:03:32] Lenny Rachitsky (Ad)

**English:**
WorkOS also recently acquired Warrant, the fine fine-grained authorization service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube. This enables fast authorization checks at enormous scale while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on, SCIM, or user management, you should consider WorkOS. It's a drop-in replacement for auth zero and supports up to one million monthly active users for free. Check it out at workos.com to learn more. That's workos.com.

**中文翻译:**
WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于名为 Zanzibar 的突破性授权系统，该系统最初是为 Google 设计的，用于支持 Google Docs 和 YouTube。这使得在大规模环境下进行快速授权检查成为可能，同时保持了能够适应最复杂用例的灵活模型。如果你目前正寻求构建基于角色的访问控制（RBAC）或其他企业功能（如单点登录 SSO、SCIM 或用户管理），你应该考虑 WorkOS。它是 Auth0 的即插即用替代方案，并免费支持多达 100 万月活跃用户。访问 workos.com 了解更多信息。

---

### [00:04:18] Lenny Rachitsky (Ad)

**English:**
You fell in love with building products for a reason, but sometimes the day-to-day reality is a little different than you imagined. Instead of dreaming up big ideas, talking to customers, and crafting a strategy, you're drowning in spreadsheets and roadmap updates and you're spending your days basically putting out fires. A better way is possible.

**中文翻译:**
你爱上构建产品是有原因的，但有时日常现实与你的想象略有不同。你并没有在构思伟大的创意、与客户交谈或制定战略，而是淹没在电子表格和路线图更新中，整天基本上都在“救火”。其实有更好的方法。

---

### [00:04:38] Lenny Rachitsky (Ad)

**English:**
Introducing Jira Product Discovery, the new prioritization and roadmapping tool built for product teams by Atlassian. With Jira Product Discovery, you can gather all your product ideas and insights in one place and prioritize confidently, finally replacing those endless spreadsheets. Create and share custom product roadmaps with any stakeholder in seconds. And it's all built on Jira, where your engineering team's already working so true collaboration is finally possible. Great products are built by great teams, not just engineers. Sales, support, leadership, even Greg from finance, anyone that you want can contribute ideas, feedback, and insights in Jira Product Discovery for free. No catch. And it's only $10 a month for you. Say goodbye to your spreadsheets and the never-ending alignment efforts. The old way of doing product management is over. Rediscover what's possible with Jira Product Discovery. Try it for free at atlassian.com/lenny. That's atlassian.com/lenny.

**中文翻译:**
向大家介绍 Jira Product Discovery，这是 Atlassian 为产品团队打造的全新优先级排序和路线图工具。通过 Jira Product Discovery，你可以将所有产品创意和见解集中在一处，并自信地进行优先级排序，最终取代那些没完没了的电子表格。几秒钟内即可创建并与任何利益相关者分享自定义产品路线图。它完全构建在 Jira 之上，你的工程团队已经在那里工作了，因此真正的协作终于成为可能。伟大的产品是由伟大的团队打造的，而不仅仅是工程师。销售、支持、领导层，甚至是财务部的 Greg，任何你想要的人都可以在 Jira Product Discovery 中免费贡献创意、反馈和见解。没有套路。对你来说每月只需 10 美元。告别电子表格和永无止境的对齐工作吧。旧的产品管理方式已经结束。通过 Jira Product Discovery 重新发现无限可能。在 atlassian.com/lenny 免费试用。

---

### [00:05:42] Lenny Rachitsky

**English:**
Brendan, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Brendan，非常感谢你能来。欢迎来到我们的播客。

---

### [00:05:45] Brendan Foody

**English:**
Thank you so much for having me, Lenny. I'm a huge fan, and so excited to have a conversation.

**中文翻译:**
非常感谢你邀请我，Lenny。我是你的忠实粉丝，很高兴能和你交流。

---

### [00:05:51] Lenny Rachitsky

**English:**
I'm really excited to have this conversation as well. I'm a huge fan of yours. I'm excited for more people to learn about you and what you're building.
(00:05:57):
I want to start with a tweet that you have pinned at the top of your Twitter feed right now, and here's the tweet. "We are now working with six out of the Magnificent 7, all of the top five AI labs, most of the AI application layer companies. One trend is common across every customer. We are entering the era of evals."
(00:06:19):
The reason this caught my attention is that's one of the most recurring trends on this podcast, people talking about the increasing value of learning how to do evals well and the value of evals for companies. It feels like still people don't know what the hell this is what we're talking about, why this is so important. Talk about just what you think people are still missing, what they need to know, what this era of evals means.

**中文翻译:**
我也非常期待这次对话。我是你的粉丝，很高兴能让更多人了解你和你正在做的事情。
我想从你现在置顶在 Twitter 个人资料上的一条推文开始。推文是这么说的：“我们现在正与‘七大科技巨头’（Magnificent 7）中的六家、排名前五的所有 AI 实验室以及大多数 AI 应用层公司合作。每个客户都有一个共同的趋势：我们正在进入‘评测’（Evals）时代。”
这条推文引起我注意的原因是，这是本播客中出现频率最高的趋势之一——人们总在谈论学习如何做好评测的价值，以及评测对公司的价值。但感觉大家还是不太明白我们到底在谈论什么，为什么这如此重要。请谈谈你认为人们还忽略了什么，他们需要了解什么，以及这个“评测时代”到底意味着什么。

---

### [00:06:39] Brendan Foody

**English:**
If the model is the product, then the eval is the product requirement document. And the way that researchers' day-to-day looks is that they'll run dozens of experiments where they'll make small improvements on an eval set. And reinforcement learning is becoming so effective that once they have an eval, they can help climb it. If you look at just how fast people were able to saturate Olympiad Math once they focused on it, how fast we're even saturating SWE-bench once we focus on it. And so in many ways, the barrier to applying agents the entire economy to automate every workflow is how do we measure success? How do we eval it? And write the PRDs for everything that we want agents to do, which Mercor is obviously a huge part of doing.

**中文翻译:**
如果说模型是产品，那么评测（Eval）就是产品需求文档（PRD）。研究人员的日常工作是运行几十个实验，在评测集上进行微小的改进。强化学习（Reinforcement Learning）现在变得如此有效，以至于一旦他们有了评测标准，就可以帮助模型不断攀升。看看一旦人们集中精力，奥数（Olympiad Math）被攻克的速度有多快，甚至 SWE-bench（软件工程基准测试）被攻克的速度有多快。因此，在很多方面，将智能体（Agents）应用到整个经济中以实现每个工作流自动化的障碍在于：我们如何衡量成功？我们如何评测它？并为我们希望智能体做的每一件事编写 PRD，而 Mercor 显然在其中扮演了重要角色。

---

### [00:07:25] Lenny Rachitsky

**English:**
So people hearing this, they're like, "Oh, yeah. Okay, shit. I got to really pay attention to this eval stuff." Any advice about learning how to do this well? What companies that are doing this well are doing differently? Help people get better at this thing.

**中文翻译:**
听到这里的人可能会想：“哦，天哪，我真的得好好关注一下这个评测的东西了。”关于如何做好这件事，你有什么建议吗？那些做得好的公司有什么不同之处？请帮大家在这个领域提升一下。

---

### [00:07:39] Brendan Foody

**English:**
Yeah. I think that for enterprises especially, the core way to think about it is how can they build a test or systematic way to measure how well AI automates their core value chain? So if it's an architecture firm that's producing these architecture diagrams of what they provide to their end customer, how can they effectively measure that? And each company has its own value chain or maybe a handful of them if it's a multi-product company. And just thinking about how they measure that is the prerequisite to really effectively applying AI throughout their entire business.

**中文翻译:**
是的。我认为尤其是对于企业来说，核心思考方式应该是：他们如何建立一套测试或系统化的方法，来衡量 AI 在自动化其核心价值链方面的表现？比如，如果是一家建筑公司，他们为最终客户提供建筑图纸，他们该如何有效地衡量 AI 生成图纸的质量？每家公司都有自己的价值链，如果是多产品公司，可能还有好几条。思考如何衡量这些价值链，是在整个业务中有效应用 AI 的前提。

---

### [00:08:21] Lenny Rachitsky

**English:**
I saw you talking about this on the No Priors podcast with Sarah and Elad, and I don't know if it was after this or before this, but Sarah tweeted, "Evals equals your new marketing." What does that mean? What do you think she's saying there?

**中文翻译:**
我看到你在 Sarah 和 Elad 的《No Priors》播客中也谈到了这一点。我不确定是在那之后还是之前，Sarah 发推说：“评测等于你新的营销手段。”这是什么意思？你觉得她想表达什么？

---

### [00:08:32] Brendan Foody

**English:**
Yeah. Well, it ties to what I said earlier about how if the model is the product, evals are the PRD, but also subsequently the sales collateral, right? Because evals are what you give to researchers to show them what they should be building and going on, but they're also the way that you demonstrate the efficacy of capabilities.
(00:08:51):
And historically, everyone's been pointing to these academic evals of PhD level reasoning with GPQA, Humanity's Last Exam, or Olympiad Math, but now it's moving towards the capabilities that people practically care about of how do we get models to automate the way that we build a software platform or automate the way that we do an investment banking analysis. And I think labs as well as application layer companies will increasingly use evals to demonstrate the capabilities of their models and their products.

**中文翻译:**
是的。这和我之前说的有关：如果模型是产品，评测就是 PRD，但随后它也会变成销售素材（Sales Collateral），对吧？因为评测是你交给研究人员的东西，告诉他们应该构建什么、朝着什么方向努力；但同时，它也是你展示模型能力有效性的方式。
过去，大家都在关注那些学术性的评测，比如 GPQA（博士级推理）、“人类最后一场考试”或奥数，但现在它正转向人们实际关心的能力，比如：我们如何让模型自动化构建软件平台的过程，或者自动化投资银行的分析工作。我认为实验室以及应用层公司将越来越多地使用评测来展示其模型和产品的能力。

---

### [00:09:26] Lenny Rachitsky

**English:**
Okay. So let's build on this and zoom out a little bit and talk about the landscape of the market that you're in. And I was just reflecting on this as I was preparing for this conversation. If you think about the companies growing faster than any company's ever grown in history, there's essentially three buckets. There's the foundational model companies, there's vibe coding apps, Cursor and Loveable and Bolt and Replit and all these here, and then there's data labeling data companies like you. So I've had the CEO of Handshake on the podcast. I have the CEO of Scale coming on. There's also Surge. There's you guys. Help us just understand the landscape of what this is all about because I think people don't really know what the hell's going on and see all these companies growing like crazy.

**中文翻译:**
好，让我们在此基础上放大视角，聊聊你所处的市场格局。我在准备这次对话时也在思考：如果你观察那些历史上增长最快的公司，基本上可以分为三类。第一类是基础模型公司；第二类是“氛围编程”（Vibe Coding）应用，比如 Cursor、Lovable、Bolt、Replit 等等；第三类就是像你们这样的数据标注和数据公司。我之前请过 Handshake 的 CEO，Scale 的 CEO 也要来，还有 Surge，以及你们。请帮我们理解一下这个领域的全貌，因为我觉得大家看到这些公司疯长，但并不真正清楚到底发生了什么。

---

### [00:10:06] Brendan Foody

**English:**
Yeah, I'll give a little bit of the origin story, incorporate in that and how it frames the landscape. Because when we started the company, I met my co-founders when we were 14 years old. We started the company together when we were 19 initially, in January 2023, initially hiring people internationally, matching them with our friends and automating all the processes of how we did that. So similar to how a human would review a resume, conduct an interview, and decided to hire. We automated all of those processes with LLMs, bootstrap the company to a million dollar revenue run rate before we dropped out of college.
(00:10:40):
And then a handful of other things happened, but we met OpenAI and we saw that there was this enormous transition in the human data market where it was moving away from this crowdsourcing problem of how do you find low and medium skilled people that can write barely grammatically correct sentences for early versions of LLMs and moving towards this sourcing and vetting problem. How do we source and assess the best professionals, the experienced? Think software engineers, the investment bankers and doctors and lawyers that can actually help to evaluate and interpret all of the capabilities that people want models to have.
(00:11:21):
So from there, we start working with all of the top AI labs. We grew from 1 to 400 million in revenue run rate in 16 months, and it's been an extraordinary journey and super exciting.

**中文翻译:**
好的，我来讲讲我们的创业故事，并以此来勾勒出整个行业的格局。我和我的联合创始人 14 岁就认识了。我们在 19 岁时，也就是 2023 年 1 月，一起创办了这家公司。最初是在国际范围内招聘人员，将他们与我们的朋友匹配，并将整个过程自动化。就像人类筛选简历、进行面试并决定录用一样，我们用大语言模型（LLM）自动化了所有这些流程。在大学退学之前，我们就靠自筹资金（Bootstrap）把公司的营收年化运行率做到了 100 万美元。
后来发生了一些事，我们见到了 OpenAI，并意识到人类数据市场正在发生巨大的转型：它正从“众包问题”（即如何寻找低中技能人员为早期 LLM 编写勉强符合语法的句子）转向“寻源与审核问题”。即：我们如何寻找并评估最顶尖的专业人士？比如经验丰富的软件工程师、投资银行家、医生和律师，他们能真正帮助评估和解读人们希望模型具备的各种能力。
从那时起，我们开始与所有顶尖的 AI 实验室合作。我们在 16 个月内将营收年化运行率从 100 万美元提升到了 4 亿美元。这是一段非凡且令人兴奋的旅程。

---

### [00:11:36] Lenny Rachitsky

**English:**
Okay. First of all, that is out of control. I don't know if people understand. I think this is the first time you're sharing that number. I know we're recording this, you'll have announced it by now, but 1 to 400 million in revenue in 16 months.

**中文翻译:**
好家伙，这简直太疯狂了。我不知道大家能不能理解这个概念。我想这是你第一次公开分享这个数字。我知道我们在录音，当你听到这段话时他们应该已经宣布了，但 16 个月从 100 万增长到 4 亿营收，太惊人了。

---

### [00:11:49] Brendan Foody

**English:**
Exactly. So fastest ascent in history, which is an exciting statistic we're very proud of.

**中文翻译:**
没错。这是历史上最快的增长速度，一个让我们非常自豪的令人兴奋的数据。

---

### [00:11:57] Lenny Rachitsky

**English:**
Okay. So something big is happening here. Why is this so valuable? What is going on here? So it's just to try to summarize what you guys do simply is you help hire people for labs to help them train their models, and you help them find not just generalist labor, but experts, helping them with very specific gaps in the model's knowledge.

**中文翻译:**
好，这里面肯定有大事发生。为什么这这么值钱？到底是怎么回事？简单总结一下你们做的事情：你们帮实验室招人来训练模型，而且你们帮他们找的不是普通的通用劳动力，而是专家，帮他们填补模型知识中非常具体的空白。

---

### [00:12:21] Brendan Foody

**English:**
Yeah, precisely. And so it really ties to your first question around the era of evals that's framing all of this, which is that the lab's primary bottleneck to being able to improve models is how they can effectively have some way of measuring what success looks like for the model, both to use it as the eval for the tests that they're measuring their progress against, as well as the verifiers in an RL environment to then reward the model, improve capabilities, et cetera. And they need this across every domain for every capability that models don't know how to use. And the wealthiest companies in the world are willing to spend whatever it takes to improve model capabilities where Mercor is sitting at the forefront and the primary bottleneck.

**中文翻译:**
是的，正是如此。这回到了你关于“评测时代”的第一个问题。实验室改进模型的主要瓶颈在于，他们如何有效地衡量模型的“成功”标准——既要将其作为衡量进度的评测基准，又要作为强化学习（RL）环境中的验证器（Verifiers），从而奖励模型、提升能力等。他们需要在每个领域、针对模型尚不具备的每种能力都做到这一点。世界上最富有的公司愿意不惜一切代价来提升模型能力，而 Mercor 正处于这个最前沿且最核心的瓶颈位置。

---

### [00:13:12] Lenny Rachitsky

**English:**
Okay, what are these people actually doing? So what's an example of a kind of person that is sought after? And then what are they doing sitting there at the computer?

**中文翻译:**
好，那这些人具体在做什么呢？能不能举个例子，什么样的专家最受欢迎？他们坐在电脑前到底在干什么？

---

### [00:13:19] Brendan Foody

**English:**
Effectively, the market is bound by the amount of things where humans can do something that models can't. So I'll make that very concrete. Say you have a model that you want to write a red line for a contract in the way that a lawyer would, and it makes a handful of mistakes, misses a bunch of key points in doing so. What you could do is have a lawyer create a rubric similar to how a professor might create a rubric to create a deliverable for what are the things we want the model to be able to do?
(00:13:50):
So it can effectively score that, right? Plus however much of it identifies this or XYZ key point. And that's really the foundation to measuring what does progress look like for models? Is this model achieving the capabilities that these professionals want? As well as how do we use this as training data to reward and to reinforce a lot of the capabilities that people want models to achieve.

**中文翻译:**
实际上，这个市场的边界在于人类能做而模型不能做的事情。我举个具体的例子。假设你有一个模型，你想让它像律师一样对合同进行修订（Redline），但它犯了一些错误，遗漏了一些关键点。你可以让一名律师创建一个评分标准（Rubric），就像教授为作业创建标准一样，明确我们希望模型能做到哪些事。
这样就可以有效地给模型打分，对吧？比如识别出某个关键点加多少分。这正是衡量模型进步的基础：这个模型是否达到了这些专业人士要求的水平？同时，我们如何将这些作为训练数据，来奖励和强化人们希望模型具备的能力。

---

### [00:14:19] Lenny Rachitsky

**English:**
Okay, so they're essentially writing evals just to connect it back to original conversation.

**中文翻译:**
好，所以他们本质上是在编写评测（Evals），这又回到了我们最初的话题。

---

### [00:14:23] Brendan Foody

**English:**
Exactly. Well, that's an interesting thing is everyone talks about RL environment. I feel like the two hot button things are like RL environments and evals, but one thing like Andrej Karpathy's tweeted out about a bunch is there's not actually a nuance. It's in the data type. It's more just a different semantic way of describing what it's being used for. But ultimately, it's just some stasis point for how do you measure what good looks like? And you can use that either as the benchmark to the sales collateral, as Sarah was saying, to say, here is why are models the best model in the world and here's the capabilities that we've been working towards, or you can use it on the post-training side to reward certain model trajectories and achieve those capabilities.

**中文翻译:**
没错。有趣的是，大家都在谈论强化学习（RL）环境。我觉得现在的两个热点就是 RL 环境和评测。但正如 Andrej Karpathy 在推特上多次提到的，这两者在数据类型上其实没有本质区别，更多只是描述其用途的不同语义方式。归根结底，它就是一个衡量“什么是优秀”的基准点。你可以把它当作基准测试（Benchmark）作为销售素材，就像 Sarah 说的，用来证明“为什么我们的模型是世界上最好的”；或者你也可以在后训练（Post-training）阶段使用它，来奖励某些模型路径并实现这些能力。

---

### [00:15:08] Lenny Rachitsky

**English:**
Okay. So say this lawyer, this person is writing, "Here's what a great red line contract looks like and here's the rubric of what excellent is." Then are they also providing data, like actual examples of red line documents as a part of that?

**中文翻译:**
好。假设这位律师正在写：“一份优秀的合同修订应该是这样的，这是优秀的评分标准。”那么他们是否也会提供数据，比如作为其中的一部分，提供实际的合同修订范例？

---

### [00:15:22] Brendan Foody

**English:**
They may. The data landscape historically has included two kinds of data. The first is supervised fine-tuning data, which is input/output. When people think about fine-tuning in the historical sense, that's what it is. The second is RLHF where the model will generate a couple of examples. We'll choose which is the most popular example.
(00:15:43):
What everyone is generally moving towards is reinforcement learning from AI feedback instead of human feedback where you have instead the human defined some sort of success criteria, some way to measure that. And examples in code, it could be a unit test. We can scalably measure success and other domains that could be a rubric. And then you use that to incentivize model capabilities. And it's far more scalable and data-efficient, and so that's why a lot of the broader trend in the market across the board is moving towards RLHF to both eval models as well as improved capabilities.

**中文翻译:**
可能会。历史上的数据格局包含两种数据。第一种是监督微调（SFT）数据，即“输入/输出”对。这是人们传统认知中的微调。第二种是 RLHF（基于人类反馈的强化学习），模型生成几个例子，我们选出最好的一个。
现在大家普遍转向的是 RLAIF（基于 AI 反馈的强化学习），而不是人类反馈。在这种模式下，人类定义某种成功标准或衡量方式。在代码领域，这可能是一个单元测试；在其他领域，这可能是一个评分标准。然后你利用这个标准来激励模型的能力。这种方式更具可扩展性，数据效率也更高。这就是为什么整个市场的趋势都在转向利用这种方式来评测模型并提升能力。

---

### [00:16:24] Lenny Rachitsky

**English:**
I had one of the co-founders of Anthropic on. He said exactly the same thing. That's what they've done at Anthropic, is move towards AI-driven reinforcement learning.
(00:16:32):
So essentially, if I can understand this correctly, I'm the lay person here trying to understand this on behalf of the audience. So essentially a lawyer is like, "Here's what correct looks like for redlining," and then it's AI is just on its own almost, just like, "I'm going to try to get this. I'm going to try to improve on this and I know if I'm heading the right direction based on this eval/rubric I've been given."

**中文翻译:**
我之前请过 Anthropic 的一位联合创始人，他也说了同样的话。Anthropic 已经在转向 AI 驱动的强化学习了。
所以本质上，如果我理解得没错（我代表观众作为门外汉来确认一下）：基本上律师会说“这是正确的合同修订方式”，然后 AI 几乎是独立运作，它会想“我要努力达到这个标准，我要不断改进，而且根据给我的这个评测标准/评分表，我知道自己是否走在正确的方向上”。

---

### [00:16:55] Brendan Foody

**English:**
Exactly. Applying all of the criteria of what good looks like similar to how the TA might apply the professor's criteria of does the student's response meet this criteria or this criteria plus however many planes, et cetera.

**中文翻译:**
没错。应用所有关于“优秀”的标准，就像助教应用教授的标准来评判学生的回答是否符合各项要求一样。

---

### [00:17:10] Lenny Rachitsky

**English:**
Awesome, okay. Let me shift to talking about the broader labor market here. So there's two parts to this question as we talk about this. One is just how long will we need to do this? You guys grew so incredibly fast. Is there a point of like, "Okay, we don't need humans. We're tapped out." So let's start there and then I'll ask a broader question.

**中文翻译:**
太棒了。让我们转向更广泛的劳动力市场话题。这个问题有两个部分。第一，我们需要做这件事多久？你们增长得如此之快，会不会有一天突然觉得“好了，我们不再需要人类了，已经到头了”？我们先从这里开始，然后再问更宏观的问题。

---

### [00:17:29] Brendan Foody

**English:**
So the key question is how long there's going to be things in the economy that humans can do that AI can't do? And I think there's certainly a bucket of people that say we're going to have superintelligence within three years and humans won't play a role in the economy. And that's one school of thought.
(00:17:46):
Our perspective is very different. Our perspective is that these models are extraordinary and automating a lot of things very quickly, but there's a lot of things that they're horrible at. Even still, it can't schedule time on my calendar. It can't draft emails for me. It can't use basic tools. And we need evals for everything. For everything that the models can't do, we need evals for the tool use, evals for the long horizon reasoning.
(00:18:12):
Imagine in 10 years when we want models to be able to go out and build a startup for 30 days. We need evals for that to effectively reward it. And I think that that road to improving models will last for as long as there is anything in the economy that humans can do which models can't and be a huge portion of what the future of work looks like. And so our mission is creating the future of work, and I think that this is a really exciting industry and giving us a glimpse into the direction that everything is headed towards.

**中文翻译:**
关键问题在于：经济活动中还有多少事情是人类能做而 AI 做不到的，这种情况会持续多久？我知道有一群人认为三年内我们就会拥有超级智能，届时人类将不再参与经济活动。这是一种流派。
我们的观点非常不同。我们认为这些模型虽然非凡，能快速自动化很多事情，但仍有很多事情它们做得一塌糊涂。直到现在，它还不能帮我安排日程，不能帮我起草邮件，不能使用基础工具。我们需要为每一件事建立评测。对于模型做不到的每一件事，我们需要工具使用的评测、长程推理的评测。
想象一下，10 年后我们希望模型能独立去创办一家公司并运营 30 天，我们需要为此建立评测来有效地奖励它。我认为，只要经济中还存在人类能做而模型不能做的事情，改进模型的道路就会一直走下去，而这也会成为未来工作的重要组成部分。我们的使命是创造工作的未来，这是一个非常令人兴奋的行业，让我们得以窥见未来的发展方向。

---

### [00:18:49] Lenny Rachitsky

**English:**
There's this tweet that you retweeted that I want to ask you about. "If you really think about it, we were put on Earth to create reinforcement learning training data for labs."

**中文翻译:**
你转发过的一条推文我想问问你：“如果你仔细想想，我们被降临到地球上，就是为了给实验室创建强化学习的训练数据。”

---

### [00:18:59] Brendan Foody

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:19:00] Lenny Rachitsky

**English:**
What does that mean to you? What is this person implying? And it's basically what you're saying is we're just helping train models.

**中文翻译:**
这对你意味着什么？这个人暗示了什么？基本上就是你说的，我们只是在帮助训练模型。

---

### [00:19:06] Brendan Foody

**English:**
It speaks to conversations I've had with a lot of researchers and executives at top labs, which is that it's highly likely that the entire economy will become an aural environment machine, building out all of these worlds and contexts for us to then have rubrics or other kinds of verifiers. And that is really exciting in so many ways.
(00:19:32):
Because I think let's draw an analog to other revolutions where when we had the industrial revolution, everyone was freaking out about losing their jobs, but there was this whole new class of jobs of how do we build the machines? How do we have knowledge work? How do we create everything new? And I think that the narrative in AI over the last three years has almost entirely been one of job displacement, right? Sure, there's ChatGPT is growing fast and it's very cool that everyone loves using it, but from an economic standpoint, people talking a lot about job displacement. But very few companies and people have talked about this new category of jobs that's being created and what that's going to mean and how people can prepare and upskill for that. And I think that the most exciting thing possible is creating that future of how do humans fit into the economy and how will that evolve over time?

**中文翻译:**
这反映了我与许多顶尖实验室的研究人员和高管的交流：极有可能整个经济都会变成一个强化学习环境机器，构建出所有这些世界和语境，让我们能够拥有评分标准或其他验证器。这在很多方面都非常令人兴奋。
我们可以类比一下其他的革命。工业革命时期，每个人都在担心丢掉工作，但随后出现了一整类全新的工作：如何制造机器？如何进行知识性工作？如何创造全新的事物？我认为过去三年关于 AI 的叙事几乎完全集中在“工作被取代”上。当然，ChatGPT 增长很快，大家也爱用，但从经济角度看，大家谈论最多的还是失业。然而，很少有公司和个人讨论正在被创造出的这一类新工作，以及这意味着什么，人们该如何准备和提升技能。我认为最令人兴奋的事情就是创造人类如何融入经济的未来，以及这种关系将如何随时间演变。

---

### [00:20:22] Lenny Rachitsky

**English:**
I talk to a lot of people about just what should I be studying? Where should I be getting better? People in school right now are just like, "What is even going to be valuable in the future?" You're at the center of a lot of just what jobs are most in demand, how hiring is evolving. So let me just ask you a very concrete question. What jobs do you think will remain in the future/what skills are still worth investing in for younger people, especially?

**中文翻译:**
我经常和人聊：我该学什么？我该在哪些方面提升？现在的学生都在想：“未来什么东西才有价值？”你正处于“哪些工作需求最大”以及“招聘如何演变”的核心位置。所以我问你一个非常具体的问题：你认为未来哪些工作会保留下来？尤其是对年轻人来说，哪些技能仍然值得投资？

---

### [00:20:47] Brendan Foody

**English:**
In terms of jobs, I would respond with a category of things that have very elastic demand are going to be super exciting. Because when we make people 10 times more productive, we'll build 10 times, if not 100 times as much software as an example. And so I think the product managers that can now do so much more are going to be extremely well-positioned. And so far as the skills, I think it's people that can leverage AI to do whatever their day-to-day workflows are.
(00:21:16):
I have had a couple conversations with teachers where they get my thoughts on how they should be assessing their students because we originally started out curating all of these AI interviews and assessments for people and have thought about this immensely. And what we realized is that you don't want to fight against them using the models. It's similar to when the calculator came out, you don't want to give people all of this arithmetic work of how do you get them to do it and not use the calculator. You want to tell them, "Use the tools and let's see what you can do."
(00:21:49):
And so we'll give people interviews where we say, "Use ChatGPT and Kodak. Use Claude code. Use whatever tool cursor and whatever tools are available to build a website and let's see what product you're able to build in an hour." And so I think that I give that an example in so far as talent assessment because I think it pertains also to the skills that people should be honing in on of how can they leverage this technology to do so much more in whatever industry or vertical they're operating in.

**中文翻译:**
关于工作，我会回答：那些具有“高需求弹性”的类别将非常令人兴奋。举个例子，当我们让人的生产力提高 10 倍时，我们会构建 10 倍甚至 100 倍的软件。因此，我认为那些现在能做更多事情的产品经理将处于非常有利的位置。至于技能，我认为是那些能够利用 AI 来完成日常工作流的人。
我曾与一些老师交流过，他们问我该如何评估学生，因为我们最初就是为人们策划 AI 面试和评估的。我们意识到，你不能反对学生使用模型。这就像计算器刚出现时一样，你不想给学生布置一堆算术题然后不准他们用计算器。你应该告诉他们：“使用这些工具，让我们看看你能做出什么。”
所以我们会给面试者这样的题目：“使用 ChatGPT、Claude、Cursor 或任何可用工具来建立一个网站，让我们看看你在一小时内能做出什么样的产品。”我举这个人才评估的例子，是因为它也适用于人们应该磨练的技能：无论在哪个行业或垂直领域，如何利用这项技术做得更多。

---

### [00:22:17] Lenny Rachitsky

**English:**
When you talk about elastic, being elastic, is it generalists being good at just a bunch of different things, or what do you say? What do you mean when you think elastic?

**中文翻译:**
当你谈到“弹性”时，是指通才擅长很多不同的事情吗？你所说的“弹性”具体指什么？

---

### [00:22:25] Brendan Foody

**English:**
So I more mean how much capacity for demand there is in that industry. So I'll give a couple of examples. In accounting, I think realistically we only need so much accounting in the world. Maybe there's areas where we can do more and that'll be good, but it doesn't feel like the world needs 100 times more accounting.
(00:22:46):
On the other hand, in software development, I think we can ship 100 times more features for our products, move 100 times faster, build so much more. There's just it feels like there's unlimited demand for the industry. And I think Mark Andreessen tweeted about this recently, that software is the most elastic industry of all where when we increase productivity, there's so much more that will be built. And it's definitely characteristic of a lot of other domains as well. And so I would focus on those domains where if we make everyone 10 times more productive, that'll increase demand, not reduce it.

**中文翻译:**
我更多是指该行业的需求容量。举几个例子：在会计领域，现实中世界上只需要一定量的会计工作。也许有些领域我们可以做得更多，那很好，但感觉世界并不需要 100 倍的会计。
另一方面，在软件开发领域，我认为我们可以为产品交付 100 倍的功能，速度快 100 倍，构建更多的东西。感觉这个行业的需求是无限的。Mark Andreessen 最近也发推说，软件是所有行业中最具弹性的，当我们提高生产力时，会有更多的东西被建造出来。很多其他领域也有这个特点。所以我会关注那些“如果让每个人的生产力提高 10 倍，需求会随之增加而不是减少”的领域。

---

### [00:23:23] Lenny Rachitsky

**English:**
Okay. So you're in the bucket of learn to code, still useful as a skill. You take computer science. And so in terms of elastic categories of jobs, sounds like engineering, product management is in that bucket. Great. A lot of people listening to this are PMs. What else, like design users? I don't know. What else do you feel is in that bucket from what you've seen?

**中文翻译:**
好。所以你属于“学习编程仍然有用”那一派。你支持学计算机科学。那么在具有弹性的工作类别中，听起来工程、产品管理都在其中。太好了，听这个播客的很多人都是 PM。还有别的吗？比如设计？根据你的观察，还有什么在这一类里？

---

### [00:23:44] Brendan Foody

**English:**
Yeah, I think that there's a lot of things where the whole value chain of building companies has a lot of these variable costs, even large portions of operations or consulting. Imagine if we could have 10 times as many McKinsey consultants, what would be possible in so far as the research we could do, the analysis, et cetera. But I think the companies and people that are going to succeed are those that lean into this narrative of abundance of how do we do so much more rather than fighting back against it of how do we try to stop displacement.

**中文翻译:**
是的，我认为在构建公司的整个价值链中，有很多环节都有大量的变动成本，甚至包括运营或咨询的大部分。想象一下，如果我们能拥有 10 倍数量的麦肯锡顾问，我们在研究、分析等方面能实现什么。但我认为，未来能够成功的公司和个人，是那些拥抱“丰盈叙事”（Narrative of Abundance）的人——即思考“我们如何做得更多”，而不是那些抵制它、试图阻止“被取代”的人。

---

### [00:24:20] Lenny Rachitsky

**English:**
So along those lines, I think about your second bucket, which is the people that will be most successful. It's not like a specific skill, but it's being good with AI, using AI to become better at what you're already doing. This reminds me of Elon's whole thing with Neuralink, which I don't know if this is how we put it, but the way I've always heard it is you wanted to build Neuralink because in the future when AGI and superintelligence is around, we need a way to compete and the best way to compete is plug our brains into a superintelligence so we have a chance. And it feels like that's what AI is. Getting good at AI tools is essentially is having this super superpower.

**中文翻译:**
沿着这个思路，我想到了你说的第二类人，也就是那些最成功的人。这不关乎某项具体技能，而是关乎擅长使用 AI，利用 AI 让自己现有的工作做得更好。这让我想起埃隆·马斯克的 Neuralink。我听到的说法是，他想建立 Neuralink 是因为在未来 AGI 和超级智能出现时，人类需要一种竞争方式，而最好的方式就是把大脑接入超级智能，这样我们才有机会。感觉 AI 工具就是这样，擅长使用它们本质上就是拥有了一种超级超能力。

---

### [00:24:58] Brendan Foody

**English:**
Figuring out how to leverage them and incorporate it will definitely be of paramount importance.

**中文翻译:**
弄清楚如何利用并整合它们绝对是重中之重。

---

### [00:25:04] Lenny Rachitsky

**English:**
It just comes back to this almost cliche quote now. It's, "AI won't replace you. People that are really good with AI will replace you."

**中文翻译:**
这又回到了那个现在几乎成了陈词滥调的说法：“AI 不会取代你，那些擅长使用 AI 的人会取代你。”

---

### [00:25:10] Brendan Foody

**English:**
I think it's totally spot on. And I've definitely seen this at the enterprise level as well where there's certain enterprises we talk to that are almost fearful not wanting to engage, not wanting to eval their businesses because that'll provide the evidence that their value chain is being automated. And there's others that... Literally some of the most recognized sophisticated Fortune 500 businesses that have this mentality and there's others that are leaning into it of if we have the ability to do 10 or 100 times more, what will that mean and how do we lean into that future? Because there's so many things that are going to change over the next 10 years, and I think those are the kinds of businesses that are going to be successful.

**中文翻译:**
我认为这完全正确。我在企业层面也看到了这一点：有些企业几乎是出于恐惧而不想参与，不想对自己的业务进行评测，因为那会证明他们的价值链正在被自动化。甚至一些最知名的财富 500 强企业也有这种心态。而另一些企业则在积极拥抱它：如果我们有能力多做 10 倍或 100 倍的事情，那意味着什么？我们如何迈向那个未来？因为未来 10 年会发生太多变化，我认为只有这类企业才能获得成功。

---

### [00:25:54] Lenny Rachitsky

**English:**
Let's talk about labor markets more broadly. You guys, so it's interesting though. You started not feeding people to AI labs, not training models. It was just like help people find jobs, help companies hire, and then you're like, "Oh wow, this whole opportunity." You have this really interesting view on the future of just labor markets and hiring. Talk about that.

**中文翻译:**
让我们更广泛地谈谈劳动力市场。很有趣的是，你们最初并不是为了给 AI 实验室输送人才或训练模型。最初只是为了帮人找工作，帮公司招聘，然后你们突然发现：“哇，这有个巨大的机会。”你对劳动力市场和招聘的未来有着非常有趣的见解，请聊聊这个。

---

### [00:26:14] Brendan Foody

**English:**
Yeah, it's interesting. I remember when we started the company, as I mentioned, we were 19, and just had this gut intuition that it felt so wildly inefficient that labor markets are so disaggregated. And what I mean by that is when we would hire someone internationally, they would apply to a dozen jobs. When we as a company in the Bay Area were considering candidates, we would consider a fraction of a percent of candidates that were available in the market. And the reason for that is that there was this matching problem that everyone's solving manually where they'll manually review resumes, they'll manually conduct interviews, and manually decide who to hire. But when we're able to automate that matching problem at the cost of software, it makes way for this global unified labor market that every candidate applies to and every company hires from facilitating a perfect flow of information in the economy.
(00:27:08):
And I think that that future is undoubtedly what we're heading towards, but what we've realized over time is that the nature of work is also changing dramatically. And part of building that future over a 10-year time horizon is creating that future of work and all of the more tactical things we do and building these incredible data sets across evals and RL environments for our customers.

**中文翻译:**
是的，很有意思。我记得公司刚成立时（正如我提到的，我们当时 19 岁），我有一种直觉，觉得劳动力市场如此分散，效率极低。我的意思是，当我们进行国际招聘时，一个人会申请几十个工作；而我们作为一家湾区的公司在筛选候选人时，只能接触到市场上极小比例的人才。原因在于“匹配问题”目前是靠人工解决的：人工筛选简历、人工面试、人工决定录用。但当我们能以软件的成本自动化这个匹配问题时，它就为全球统一的劳动力市场铺平了道路——每个候选人都向其申请，每家公司都从中招聘，从而促进经济中信息的完美流动。
我认为我们无疑正朝着那个未来迈进，但我们也意识到工作的本质也在发生剧变。在 10 年的时间跨度内构建那个未来的过程中，一部分工作就是创造“工作的未来”，以及我们正在做的所有战术性工作，比如为客户构建跨评测和强化学习环境的惊人数据集。

---

### [00:27:35] Lenny Rachitsky

**English:**
What I've seen in how hiring has changed, I'm doing research on this with a partner, Gnome, it's so much easier to apply for companies that everyone's just applying now, to hundreds of companies. AI is just making it easy to adjust their resumes and cover letters and make it feel like, "Oh, I applied to more of course very specifically, but it was one of 100 places." And then on the flip side, hiring managers are getting flooded with applications and so now they need AI to filter. So even if we didn't want to get to this place, we're almost being pushed into this direction of so much volume on both sides. We need something really smart at filtering and helping us hire and select, and this is exactly what you guys have been building for a long time.

**中文翻译:**
我也观察到了招聘方式的变化，我正和合作伙伴 Gnome 研究这个。现在申请公司变得太容易了，每个人都在申请几百家公司。AI 让修改简历和求职信变得轻而易举，让人感觉“哦，我申请了很多家，而且都很针对性”，但实际上只是 100 个申请中的一个。反过来，招聘经理被海量的申请淹没，所以他们现在需要 AI 来筛选。所以即使我们不想走到这一步，双方巨大的数量级也在把我们推向这个方向。我们需要非常智能的东西来过滤、帮助我们招聘和选拔，而这正是你们长期以来一直在构建的东西。

---

### [00:28:13] Brendan Foody

**English:**
Precisely, yeah. And the fascinating thing a lot of people ask, do we think about ourselves as a labor marketplace or do we think about ourselves as a data company? And I think that the reason it's an interesting question is our realization on from what the labs need is that they actually need a labor marketplace. They actually need these exceptionally high caliber people. And of course we'll layer on some project management and some software platform associated with it. But the really core thing that they want is how do they find these extraordinary professionals across all of these different domains that can measure model capabilities and work to build that future work together?

**中文翻译:**
正是如此。很多人问我们，是把自己看作劳动力市场还是数据公司？这个问题的有趣之处在于，我们意识到实验室真正需要的就是一个劳动力市场。他们需要这些极其高素质的人才。当然，我们会在此基础上增加一些项目管理和相关的软件平台。但他们最核心的需求是：如何找到这些跨越不同领域的杰出专业人士，来衡量模型能力并共同构建工作的未来？

---

### [00:28:56] Lenny Rachitsky (Ad)

**English:**
This episode is brought to you by Enterpret. Enterpret is a customer intelligence platform used by our leading CXN product orgs like Canva, Notion, Perplexity, Strava, Hinge, and Linear to leverage the voice of the customer and build best in class products. Enterpret unifies all customer conversations in real time, from Gong recordings to Zendesk tickets to Twitter threads, and makes it available for your team for analysis and for action.
(00:29:21):
What makes Enterpret unique is its ability to build and update a customer-specific knowledge graph that provides the most granular and accurate categorization of all customer feedback and connects that customer feedback to critical metrics like revenue and CSAT. If modernizing your voice of customer program to a generational upgrade is a 2025 priority, customer-centric industry leaders like Canva, Notion, Perplexity, and Linear, reach out to the team at enterpret.com/lenny. That's E-N-T-E-R-P-R-E-T.com/lenny.

**中文翻译:**
本集节目由 Enterpret 赞助。Enterpret 是一个客户智能平台，被 Canva、Notion、Perplexity、Strava、Hinge 和 Linear 等领先的产品组织所采用，用于利用客户的声音构建一流产品。Enterpret 实时统一所有客户对话，从 Gong 录音到 Zendesk 工单再到 Twitter 线程，并供你的团队进行分析和采取行动。
Enterpret 的独特之处在于它能够构建并更新特定于客户的知识图谱，提供对所有客户反馈最细粒度且准确的分类，并将这些反馈与收入和客户满意度（CSAT）等关键指标联系起来。如果将你的“客户之声”计划升级为代际更新是 2025 年的优先事项，请联系 enterpret.com/lenny。

---

### [00:29:55] Lenny Rachitsky

**English:**
Going back to just how this all works and what you guys do for models, I was talking to a friend who had an ankle sprain or his foot was hurting and he got an x-ray and he fed the x-ray into ChatGPT and then asked him, "Give me this specific x-ray." And it's like, "Okay, sure." And then it gave him, "Here's what you have." And he was talking to me, he's like, "What is out there on the internet that trained this model to know this stuff?" And I was like, "No, it's actually somebody sitting there helping the model understand this. Once they recognize, it doesn't fully understand this. Humans are actually helping them learn these things."

**中文翻译:**
回到这一切是如何运作的，以及你们为模型做了什么。我有个朋友扭伤了脚踝，他拍了 X 光片，然后把照片传给 ChatGPT，问它：“帮我看看这张片子。”ChatGPT 说：“好的，没问题。”然后告诉了他诊断结果。他跟我说：“互联网上到底有什么东西能训练出让模型懂这些知识的？”我说：“不，其实是有人坐在那里帮助模型理解这些。一旦实验室发现模型不完全理解某事，就会有人类在实际帮助它们学习这些东西。”

---

### [00:30:29] Brendan Foody

**English:**
Exactly. Well, so the way it works, at least what most people's understanding is there's a lot of complexity in how the models work, is that pre-training gets a lot of the knowledge into the model of what are all the different things that see into the world. And then post-training and reinforcement learning is for all of the reasoning of what are the pieces of knowledge that are accurate, what are inaccurate, and what to prioritize at any given time to make a decision. And so behind that, there would've been radiologists that worked on the post-training data set to create some stasis point for here's the diagnosis and rewards and penalties associated with it. And it's really the quality of those people that went into the quality of the decision and recommendation that ChatGPT ultimately made.

**中文翻译:**
没错。虽然模型运作非常复杂，但大多数人的理解是：预训练（Pre-training）将大量的世界知识灌输给模型。而“后训练”（Post-training）和强化学习则是为了推理——哪些知识是准确的，哪些是不准确的，以及在任何特定时间应该优先考虑什么来做出决策。所以在那个例子背后，一定有放射科医生参与了后训练数据集的工作，建立了一个基准点，明确诊断结果以及相关的奖励和惩罚。正是这些人的专业水平，决定了 ChatGPT 最终做出的决策和建议的质量。

---

### [00:31:14] Lenny Rachitsky

**English:**
So let's actually follow that, right, because that's really interesting and I don't know how many people understand it. I understand it. So the work that you do and these experts do is post-training. It's not feeding data into the model that it's trained on. It's, "We have this model GPT-5. Now here's all the things that's missing. Let's add to it."

**中文翻译:**
让我们深入探讨一下，这很有趣，我不知道有多少人理解。我的理解是：你和这些专家所做的工作属于“后训练”。这不是在给模型喂基础训练数据，而是说：“我们已经有了 GPT-5 这个模型，现在看看它还缺什么，让我们把它补上去。”

---

### [00:31:31] Brendan Foody

**English:**
Exactly, yeah. It's really unlocking, allowing the model to focus on all the right tokens, from pre-training all the right things in model context, up weighting the effective reasoning chains to enable the models to reason better in a more generalized way.

**中文翻译:**
没错。这实际上是在解锁模型，让它能够专注于正确的 Token，从预训练中提取正确的上下文，增加有效推理链的权重，从而使模型能够以更通用的方式进行更好的推理。

---

### [00:31:48] Lenny Rachitsky

**English:**
What's the scale of people just working on the stuff. It's like thousands, tens of thousands, hundreds of thousands?

**中文翻译:**
现在做这类工作的人员规模大概是多少？几千、几万还是几十万？

---

### [00:31:53] Brendan Foody

**English:**
Tens of thousands at any given time, hundreds of thousands more generally. It's huge. And the most exciting thing is that it's growing really quickly. I think that to your question also about the competitive landscape, historically there were all these crowdsourcing companies that would get these super high volumes of low-skilled people. I think Scale and Surge were the primary companies that pioneered that industry. And then in this transition to higher-skilled labor, what people realized is that actually you can go a lot further with just getting higher caliber people even in smaller amounts initially, and now subsequently scaling that back up once they're able to meet the quality bar.
(00:32:35):
And I think that there's a bunch of companies that after our success and very rapid revenue growth that started early last year have chased after that, which makes sense. And seeing that the market was changing very quickly, we were taking off, and trying to pursue a similar thesis on the market.

**中文翻译:**
任何特定时间都有数万人，广义上则有数十万人。规模非常大。最令人兴奋的是它增长得非常快。关于你提到的竞争格局，历史上有很多众包公司，他们招募海量的低技能人员。我认为 Scale 和 Surge 是这个行业的先驱。但在向高技能劳动力转型的过程中，人们意识到，最初即使只招募少量高素质人才，也能走得更远，然后在他们能达到质量标准后再逐步扩大规模。
我认为在去年初我们取得成功并实现营收快速增长后，有很多公司开始效仿，这很正常。他们看到市场变化极快，我们正在崛起，于是也尝试追求类似的市场论点。

---

### [00:32:56] Lenny Rachitsky

**English:**
It's interesting. There's always been these companies, AlphaSights and GLG, that did this before AI or is paid to connect to an expert and ask them questions about stuff. And essentially, okay, it turns out this is really useful for models. We don't need the person in the middle.

**中文翻译:**
很有趣。一直以来都有像 AlphaSights 和 GLG 这样的公司，在 AI 出现之前就在做这件事，或者说是付费联系专家咨询问题。现在看来，这对模型也非常有用。我们不再需要中间人了。

---

### [00:33:11] Brendan Foody

**English:**
Exactly, yeah. Well, but one core difference is that AlphaSights would generally be a one-off call versus a lot of our work is really hiring people for projects of how do they work on something for a longer period of time. And so that's, I think, one of the reasons that some of the traditional expert networks have struggled to get into this. And also how do you retain those people and think about all the incentives where it actually looks more similar in some ways to one of the traditional labor marketplaces of an Uber or DoorDash, just with much higher-skilled talent that's treated exceptionally well?

**中文翻译:**
没错。但一个核心区别是，AlphaSights 通常是一次性的电话咨询，而我们的工作更多是为项目招聘人员，让他们在较长时间内专注于某件事。我认为这就是传统专家网络难以进入这个领域的原因之一。此外，如何留住这些人，以及如何设计激励机制，这在某些方面其实更像 Uber 或 DoorDash 这样的传统劳动力市场，只不过我们对接的是受到极好待遇的高技能人才。

---

### [00:33:50] Lenny Rachitsky

**English:**
It's such a good opportunity for me to learn so much about this, so I'm going to ask questions.

**中文翻译:**
这对我来说是一个了解这个领域的大好机会，所以我要多问几个问题。

---

### [00:33:55] Brendan Foody

**English:**
Yeah.

**中文翻译:**
好的。

---

### [00:33:55] Lenny Rachitsky

**English:**
It's so interesting to me. How much of the experts are focused on specific concrete knowledge versus personality and softer skills? How much of it's like, "Here's how you do an exam. Here's how you do an x-ray"?

**中文翻译:**
我很好奇。这些专家中有多少是专注于具体的硬知识，有多少是专注于性格和软技能？有多少是像“这是如何做考试题”或“这是如何看 X 光片”这样的？

---

### [00:34:09] Brendan Foody

**English:**
It depends on the lab. It's a lot of both. I think that previously it might've been more softer skills, but now a lot of the labs are focused on their business models of what are the economically valuable capabilities that drive revenue and leaning a lot into these professional domains. But I think the creative side is also still really important to everyone. And so we're seeing a meaningful amount of both. We hired all the people from the Harvard Lampoon a couple of months ago, their comedy club, to help with making models funnier. And so do all sorts of stuff like that, hiring Emmy award-winning screenwriters and everything across the board on creative capabilities that you'd look for.

**中文翻译:**
这取决于实验室。两者都有很多。我认为以前可能更多是软技能，但现在很多实验室都专注于他们的商业模式，即哪些具有经济价值的能力可以驱动收入，因此他们大量转向这些专业领域。但我认为创意方面对每个人来说仍然非常重要。所以我们看到这两者都有相当大的比例。几个月前，我们聘请了《哈佛讽刺文社》（Harvard Lampoon，哈佛的喜剧俱乐部）的所有成员，来帮助模型变得更有幽默感。我们还做了很多类似的事情，比如聘请艾美奖获奖编剧，以及各种你需要的创意能力人才。

---

### [00:34:51] Lenny Rachitsky

**English:**
That is amazing. What a cool story. I'm excited for this to kick in. How fast do these things turn around? Say you hired this team, how fast are we going to see the impact potential? Is like months? Is it years?

**中文翻译:**
太棒了，这个故事真酷。我很期待看到成效。这些工作的周转周期有多快？假设你雇佣了这个团队，我们多快能看到潜在的影响？是几个月还是几年？

---

### [00:35:03] Brendan Foody

**English:**
Well, so it depends, because some models or some labs will release iteratively where they'll just improve the model behind the scenes.

**中文翻译:**
这取决于情况。因为有些模型或实验室会进行迭代发布，他们只是在幕后改进模型。

---

### [00:35:11] Lenny Rachitsky

**English:**
Without announcing a new model?

**中文翻译:**
不宣布新模型吗？

---

### [00:35:12] Brendan Foody

**English:**
Exactly. Every couple of weeks versus others do these big releases. And so it depends a lot. We're behind all of them, but we move really fast. It would be a customer gives us a request of we need these award-winning screenwriters, and within 24 hours we'll turn around the experts. And then there's also this really interesting dynamic where in a set of 100 people that we hire, oftentimes the top 10% of people will drive majority of the model improvement. It's like a company. If you have 100-person company, oftentimes the top 10% of the company will drive majority of the impact. And what that means is that when we're able to build proprietary advantages in identifying who are those top 10% of people, both in so far as how do we have them on our platform but also identify and match them effectively, it creates so much value for customers that it's difficult to compete against.
(00:36:08):
And so it really does tie back to the founding thesis of the company, which is how do we find these extraordinary people and identify them so that we can reliably deliver these top 10% or top 10X experiences for our customers.

**中文翻译:**
没错。有的每隔几周就更新一次，而有的则进行重大版本发布。所以这很大程度上取决于情况。我们支持所有的实验室，而且动作非常快。如果客户提出需求说“我们需要这些获奖编剧”，我们在 24 小时内就能交付专家。还有一个非常有趣的动态：在我们雇佣的 100 个人中，通常前 10% 的人会推动模型的大部分改进。这就像一家公司，如果你有 100 名员工，通常前 10% 的人会产生大部分影响。这意味着，当我们能够在识别这前 10% 的人才方面建立专有优势时（包括如何让他们留在我们的平台上，以及如何有效地识别和匹配他们），这会为客户创造巨大的价值，让竞争对手难以企及。
所以这确实回到了公司的创始理念：我们如何找到这些非凡的人才并识别他们，从而能够可靠地为客户提供这种“前 10%”或“10 倍级”的体验。

---

### [00:36:25] Lenny Rachitsky

**English:**
So on that, so is the idea, you hire Jane. She's incredible at coding and she now works for Anthropic and that's her full-time job doing this? Or is this a part-time thing? Is this a project thing mostly?

**中文翻译:**
关于这一点，你们的模式是这样的吗：你们雇了 Jane，她编程非常厉害，现在她为 Anthropic 工作，这是她的全职工作吗？还是兼职？或者主要是项目制的？

---

### [00:36:38] Brendan Foody

**English:**
It would sometimes be part-time. Sometimes it would be full-time. I would say most often it's part-time where it's like someone might work at a thing company where they're underemployed, maybe one of the ones that's moving slower where they have an extra 20 hours a week and then they're able to do this on the side or whatever the equivalent is across a bunch of different industries. But we also do a lot of 40 hour a week roles as well.

**中文翻译:**
有时是兼职，有时是全职。我会说大部分情况下是兼职。比如某人在一家大公司工作，但可能“大材小用”，或者在一家节奏较慢的公司，每周有额外的 20 小时空闲，然后他们就可以利用业余时间做这个，或者在其他行业也有类似的情况。但我们也提供很多每周 40 小时的全职岗位。

---

### [00:37:08] Lenny Rachitsky

**English:**
And how much are they making? Is it meaningful enough for a AI engineer to spend time on this?

**中文翻译:**
他们能赚多少钱？对于一名 AI 工程师来说，花时间做这个回报够高吗？

---

### [00:37:13] Brendan Foody

**English:**
Yeah, very meaningful. So our median pay rate in the marketplace is $95 an hour, but it can flex up, well up into $500 an hour based on the depth of someone's expertise. And one thing that highlights this difference relative to a lot of the crowdsourcing companies is if you look at the economics of the crowdsourcing companies, oftentimes they would pay $30 an hour to town as the average. And so think about the people that you can hire, the undergrads for $30 now versus the Goldman bankers, the McKinsey analysts, the Fang software engineers. And ultimately it comes down to what are the capabilities that labs want their models to have? And it much more falls in the latter bucket than the former one.

**中文翻译:**
是的，非常可观。我们市场的时薪中位数是 95 美元，但根据专业深度，时薪可以灵活上调，甚至高达 500 美元。有一点能凸显我们与众包公司的区别：如果你看众包公司的经济模式，他们通常平均支付每小时 30 美元。想想看，30 美元你能雇到什么样的人？是大学生，还是高盛的银行家、麦肯锡的分析师、或者是大厂（FAANG）的软件工程师？归根结底，这取决于实验室希望模型具备什么样的能力。显然，这些能力更多地落在后者（高技能人才）身上。

---

### [00:38:02] Lenny Rachitsky

**English:**
I know there's only so much you can talk about with this stuff, but so Anthropic, Claude has been so good at coding so much better historically than other models. I also use it for writing, giving feedback on writing. What is it that allowed them to get so good at this and continue to be so good at this?

**中文翻译:**
我知道这些事你不能透露太多，但 Anthropic 的 Claude 在编程方面一直表现得非常出色，历史上比其他模型好得多。我也用它来写作，让它给我的文章提建议。是什么让他们能做得这么好，并一直保持领先？

---

### [00:38:19] Brendan Foody

**English:**
Well, I can't go too much into detail about customer work, but I think that it's this trend of reinforcement learning and being very thoughtful about defining the right rewards that we're releasing across the board. And how we could mitigate reward hacking, set up the right rewards, that's super impactful.

**中文翻译:**
我不能透露太多关于客户工作的细节，但我认为这是强化学习的趋势，以及在定义正确的“奖励机制”方面非常深思熟虑。如何减轻“奖励作弊”（Reward Hacking）、设置正确的奖励，这些都非常有影响力。

---

### [00:38:42] Lenny Rachitsky

**English:**
Evals. Again, evals is all you need.

**中文翻译:**
又是评测。看来“评测就是你所需要的一切”。

---

### [00:38:44] Brendan Foody

**English:**
Back to evals.

**中文翻译:**
回到评测。

---

### [00:38:45] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:38:45] Brendan Foody

**English:**
One of my favorite quotes from customers is that, "Models are only as good as their evals," which has always held true.

**中文翻译:**
我最喜欢的客户语录之一是：“模型的上限取决于其评测的水平。”这句话永远适用。

---

### [00:38:53] Lenny Rachitsky

**English:**
I think Greg Brockman tweeted this once. "Evals are all you need."

**中文翻译:**
我想 Greg Brockman 曾经发过推文：“评测就是你所需要的一切。”

---

### [00:38:56] Brendan Foody

**English:**
Yeah, truly.

**中文翻译:**
是的，确实如此。

---

### [00:38:58] Lenny Rachitsky

**English:**
Let's talk about Mercor a little bit more. One of the maybe, not even maybe, I believe the data tells us it's the fastest growing company in history.

**中文翻译:**
让我们多聊聊 Mercor。它可能是——甚至不用说“可能”，我相信数据告诉我们，它是历史上增长最快的公司。

---

### [00:39:07] Brendan Foody

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:39:09] Lenny Rachitsky

**English:**
I want to understand what you did to make this happen. So let me just ask, what do you think are some of the core tenets of how you built Mercor that most contributed to being this successful?

**中文翻译:**
我想了解你是怎么做到的。我想问，你认为在构建 Mercor 的过程中，有哪些核心原则对这种成功贡献最大？

---

### [00:39:20] Brendan Foody

**English:**
I think the most important thing is looking at the leading indicators in fast-moving markets. I remember when I used to think... Everyone in venture talks about the why now, and I used to think about the why now of how from a product standpoint, less from a market standpoint of now we can automate the way that we review resumes or the way that we conduct interviews, et cetera. But ultimately there is this legacy market that's has all these incumbents and it's relatively stagnant. But what matters a ton is actually figuring out what are the new markets, the new pockets of demand that are changing very quickly where the wealthiest customers in the world are willing to pay whatever it takes to improve model capabilities, and how do we focus on the leading indicators of those markets to make sure that we have the best solution for the flagship customers in the market and optimize everything around that.
(00:40:18):
And that's what I found has been most impactful in building the business. I think maybe that's one thing is leading indicators in markets. If I had to choose another, it's customer obsession. We have had for the last... We're starting to have a couple of product managers help out with go-to-market, but for the last year and a half of the business, we've had no one in sales and marketing. And so we're immature from a sales and marketing standpoint because we focused 100% of company resources on how do we build great products and experiences for our customers. Just getting word of mouth, the people that have worked with us at other businesses want to keep working with us and leaning into creating those great experiences. And so that's where I spend all my time. And I think that some founders can get caught up in how do they get really good at marketing before they've figured out the thing that really drives a lot of customer love and creates the six-star experiences that you're used to building.

**中文翻译:**
我认为最重要的一点是观察快速变化市场中的“领先指标”。我记得以前我总在想……风投界都在谈论“为什么是现在”（Why now），我以前更多是从产品角度去想，而不是从市场角度。比如现在我们可以自动化简历筛选或面试流程等等。但归根结底，传统市场有很多老牌企业，而且相对停滞。真正重要的是找出那些变化极快的新市场、新的需求点，在这些地方，世界上最富有的客户愿意不惜一切代价来提升模型能力。我们要关注这些市场的领先指标，确保我们能为市场中的旗舰客户提供最佳解决方案，并围绕这一点优化一切。
这就是我发现对构建业务最有影响力的东西。如果非要选另一个，那就是“客户痴迷”。在过去的一年半里，我们甚至没有销售和营销人员（最近才开始有几个 PM 协助进入市场）。从销售和营销的角度来看，我们还不成熟，因为我们将 100% 的资源都集中在如何为客户打造伟大的产品和体验上。通过口碑传播，那些在其他公司与我们合作过的人会想继续与我们合作。这就是我花所有时间的地方。我认为有些创始人可能会在还没弄清楚什么能真正赢得客户喜爱、创造“六星级体验”之前，就纠结于如何做好营销。

---

### [00:41:19] Lenny Rachitsky

**English:**
I'm going to go back to that first point, which is like, okay, you found this pocket, maybe the biggest business opportunity in history. How did you first find... What was that moment of, "Wait, this could be really big"?

**中文翻译:**
我想回到第一点，也就是你发现的那个切入点，那可能是历史上最大的商业机会。你是怎么发现的？那个让你意识到“等等，这可能会做大”的时刻是什么样的？

---

### [00:41:31] Brendan Foody

**English:**
So there's some crazy stories here. I remember we started the company as I mentioned in January 2023. And then in August 2023 when I was still in college, one of our customers introduced us to the co-founders of xAI over a Zoom call saying how we had these really smart Indian software engineers that were great at math and coding. So we met them and we explained how the software engineers we had were really good at math and coding because they weren't distracted by all the humanities. They didn't have to study history and English and all these other things, and they loved it. So they had us in two days later to the Tesla office and we met the entire xAI co-founding team except for Elon, while I was still a college student. And xAI was just getting started at that point and they were super excited about our focus on the quality of the experts.
(00:42:22):
And so while they were still doing pre-training, they weren't ready for human data at the time and we didn't start working with them at that point. We just knew from that point forward before we even dropped out that the market was about to change radically and we needed to be at the frontier of that. And so then fast-forward a few months, one of the crowdsourcing players came to us and actually used our platform to hire over 1,000 people where this is very interesting experience because we started getting flooded with support tickets about how those people weren't getting paid. And we obviously felt horrible because we had referred them to this opportunity. It was this reputable company. And we realized that a lot of the incumbents were resting on their laurels with respect to what was needed in the experiences they were creating for talent in their marketplaces to help improve models. And there was this opportunity to work directly with the labs in a way that kept the dignity of the experts in the marketplace, paid them extremely well, and cut out the middlemen.
(00:43:31):
And so we started doing that in May of last year, and then the rest is history.

**中文翻译:**
这里有一些疯狂的故事。我记得公司是 2023 年 1 月成立的。然后在 2023 年 8 月，我还在上大学时，我们的一个客户通过 Zoom 电话把我们介绍给了 xAI 的联合创始人，说我们有一些非常聪明的印度软件工程师，擅长数学和编程。我们见了面，解释说我们的工程师之所以擅长这些，是因为他们没有被各种人文课程分心，不需要学历史、英语之类的，他们很热爱技术。两天后，他们邀请我们去特斯拉办公室，我当时还是个大学生，就见到了除埃隆以外的整个 xAI 创始团队。当时 xAI 才刚刚起步，他们对我们对专家质量的关注感到非常兴奋。
虽然他们当时还在做预训练，还没准备好接收人类数据，我们那时也没开始合作，但从那一刻起，甚至在我们退学之前，我们就知道市场即将发生剧变，我们必须站在最前沿。几个月后，一家众包巨头找到我们，利用我们的平台雇佣了 1,000 多人。这是一次非常有趣的经历，因为我们开始收到大量的投诉，说那些人没拿到工资。我们感到非常糟糕，因为是我们推荐了这个机会，而且那是一家很有名气的公司。我们意识到，很多老牌企业在为人才创造体验以帮助改进模型方面固步自封。这是一个直接与实验室合作的机会，既能保持市场中专家的尊严，给他们极高的报酬，又能省去中间环节。
于是我们在去年 5 月开始这样做，接下来的事情大家都知道了。

---

### [00:43:37] Lenny Rachitsky

**English:**
Wow, okay. Hundreds of millions of dollars in revenue since. So what I'm hearing here is you were very open to looking for poll. You saw some poll, you explored it. And then once you saw that there was something really meaningful there, you just went deep on making that an incredible experience as amazing as possible.

**中文翻译:**
哇，从那以后营收达到了数亿美元。所以我听到的是，你对寻找“市场拉力”（Poll）持非常开放的态度。你看到了拉力，进行了探索，一旦发现那里有真正有意义的东西，你就全力以赴，把体验做到极致。

---

### [00:43:57] Brendan Foody

**English:**
Exactly. I think if I had to distill it into advice for founders, one thing I've realized is that I spent a lot of time trying forced product-market fit. And in some ways you should be persistent. You should have these theses that you have conviction about how the world will change. But sometimes you just need to sheer it from the market and know that it's there, the poll, to know the right places to focus. Because if it's difficult to sell, if it's extremely difficult to sell the marginal customer, you're not going to be able to grow a huge business. What you actually need to find is the customer that's surprisingly easy to sell into where you're going to be able to grow with them. You know that it's a large pain point. And so it's some combination of being stubborn with respect to your thesis around how the world will change, but also very open-minded with respect to exactly what form that takes and how the market's developing and how your company will fit into it.

**中文翻译:**
没错。如果要我给创始人一些建议，我意识到我曾花了很多时间试图“强行”达成产品市场契合（PMF）。在某些方面你应该坚持，你应该对世界将如何变化有坚定的信念。但有时你只需要从市场中感受那种拉力，知道它就在那里，从而知道该关注哪里。因为如果产品很难卖，如果向边际客户推销极其困难，你就无法做大。你真正需要寻找的是那些出奇容易成交的客户，你可以和他们一起成长。你知道那是一个巨大的痛点。所以，这是一种结合：既要对世界变化的信念保持“固执”，又要对具体形式、市场发展以及公司如何融入其中保持极度的“开放”。

---

### [00:44:55] Lenny Rachitsky

**English:**
That's an amazing insight. In the moments you described, felt like it was a combination of this xAI meeting feeling like, "Oh wow, they really, really want this thing that we have. We're now doing an amazing job," and then it's 1,000 people hiring in the platform. Was that those two moments that are like, "Wow"?

**中文翻译:**
这是个了不起的见解。在你描述的那些时刻中，感觉是与 xAI 的会面让你觉得“哇，他们真的非常想要我们拥有的东西”，然后是平台上 1,000 人的招聘规模。是这两个时刻让你感到“哇”的吗？

---

### [00:45:09] Brendan Foody

**English:**
Exactly. And those happened, keep in mind, while we were a seed company, right? Well, so the first one was before we even raised any seed funding, we were totally bootstrapped because we bootstrapped the company to a million dollar revenue run rate and have always remained super capital-efficient. We've never burned money. We were lifetime profitable. And then we raised our seed round in September from General Catalyst, and it was the other experience after we raised our seed round where we really knew that there was an enormous amount of demand in this market where we saw the volume and we saw that the incumbents were sleeping with respect to how the market was changing and the kinds of people that were needed to make that change happen.

**中文翻译:**
没错。请记住，这些发生在我们还是一家种子轮公司的时候。第一个时刻甚至发生在我们融资之前，我们完全是自筹资金，因为我们已经把营收做到了 100 万美元，并且一直保持极高的资本效率。我们从未烧过钱，一直处于盈利状态。然后在 9 月我们从 General Catalyst 拿了种子轮融资。种子轮之后的另一次经历让我们真正确信这个市场存在巨大的需求，我们看到了业务量，也看到了老牌对手在市场剧变和人才需求面前反应迟钝。

---

### [00:45:50] Lenny Rachitsky

**English:**
It's one thing to see this opportunity and start to execute on it. It's another to actually succeed at this scale and consistently win. You guys have very specific values within the business. Talk about those. It feels like that's a big part of your success too.

**中文翻译:**
看到机会并开始执行是一回事，真正实现这种规模的成功并持续获胜是另一回事。你们公司内部有非常具体的价值观，请聊聊这些。感觉这也是你们成功的重要原因。

---

### [00:46:04] Brendan Foody

**English:**
It totally is. So I'll give the three and maybe a brief story associated with each of them.
(00:46:10):
So the first one is having a can-do attitude, which everyone gives me a little bit of a hard time for because it's a funny saying, but we've always set these ridiculously ambitious goals, and then somehow the trajectory of the company forms around those goals. Where I remember when we were talking to Benchmark before they led our Series A, we were at 1.5 million in run rate. And I said we'd be at 50 million in run rate by the end of the year. And they said we were absolutely insane, right, as anyone would. And plus or minus two weeks, we hit it. And then we've now well blown past the tracking to 500 million in run rate, which was initially our goal for this year. So setting these incredibly ambitious goals with respect to the revenue scale of the business, the caliber of experiences for talent, all those dimensions is super important to first have a can-do attitude.
(00:47:04):
The second thing is really high standards, which is who we hire and what we expect of them. We have an incredibly high hiring bar where we hire tons of former founders, people that have incredible experiences. We just hired or partnered with Sundeep Jain who joined us as president. He was previously the chief product officer and chief technology officer at Uber and joined our relatively small in the grand scheme of things company to help scale up all the processes where Uber is of course the largest labor marketplace in the world. So super high standards is of paramount importance.
(00:47:41):
And then the third one that we really lean on significantly is intensity. And that if you look at the early cultures of the legendary companies, thinking of Meta or Google, they have these incredible, intense early-stage cultures of people just moving heaven and earth and doing whatever it takes to push the frontier of model capabilities. And so still very much output-oriented of what do people achieve rather than input-oriented of the specific hours they work, but recognizing that it takes a lot to build a legendary business, and that's ultimately what we're optimizing for.

**中文翻译:**
确实如此。我分享三个原则，并给每个原则配一个小故事。
第一个是“凡事皆可成”（Can-do attitude）。大家有时会拿这个开玩笑，因为这听起来有点土，但我们总是设定极其宏大的目标，然后公司的发展轨迹就会围绕这些目标展开。我记得在 Benchmark 领投 A 轮之前，我们的年化营收是 150 万美元。我说到年底我们会达到 5000 万。他们觉得我疯了，换谁都会这么想。但结果我们在误差不到两周的时间内实现了。现在我们已经远远超过了 5 亿年化营收的目标，这原本是我们今年的目标。所以，在营收规模、人才体验等各个维度设定极具野心的目标，首先需要这种“凡事皆可成”的态度。
第二个是“极高标准”，这体现在我们雇佣谁以及对他们的期望。我们的招聘门槛极高，雇佣了大量的前创始人、经验极其丰富的人。我们刚刚聘请了 Sundeep Jain 担任总裁。他曾是 Uber 的首席产品官和首席技术官，加入我们这家规模相对较小的公司，帮助我们扩展流程，而 Uber 当然是全球最大的劳动力市场。所以，极高的标准至关重要。
第三个我们非常依赖的是“强度”（Intensity）。如果你观察那些传奇公司的早期文化，比如 Meta 或 Google，他们都有极其强悍的早期文化，员工们为了突破模型能力的边界而不遗余力。我们仍然非常看重产出（人们成就了什么），而不是投入（具体工作了多少小时），但我们意识到，打造一家传奇企业需要付出巨大的努力，这正是我们最终追求的目标。

---

### [00:48:18] Lenny Rachitsky

**English:**
I could see why this works. Can-do attitude plus high standards plus intensity, I could see how that leads to success. There's a lot of talk these days about this 6-9-9 culture, working six days a week, 9:00 AM to 9:00 PM. A lot of people are like, "Why? That's terrible. Why would you make people do that?" But at the same time, I'm just constantly hearing this from the most successful AI companies. This is just the way it is to be successful. Things are moving so fast. This is an opportunity you'll never see again. Just talk about your thoughts on that.

**中文翻译:**
我能理解为什么这行得通。积极的态度加上高标准和高强度，必然通向成功。最近大家都在讨论“996”文化（或者说 6-9-9，每周六天，早九点到晚九点）。很多人觉得：“为什么？这太糟糕了，为什么要让人这么干？”但与此同时，我不断从最成功的 AI 公司那里听到这种说法。这就是成功的必经之路，事情发展得太快了，这是一个千载难逢的机会。谈谈你对此的看法。

---

### [00:48:50] Brendan Foody

**English:**
Yeah. Well, to clarify, we've never mandated hours. It's more been a byproduct of people that care a lot where we care a lot about the trajectory of the business. And so a lot of people come into the office and stay late. But if they need to leave early and get dinner with their kids or travel on the weekend, of course that's totally fine. And for us, it's much more about finding people who have a lot of ownership and are really bought in, less so about the specific hours in the office, even though we found that oftentimes it's the people that are most bought in, not always, but oftentimes it's the people that are most bought in and that burn the midnight oil with us.

**中文翻译:**
是的。首先澄清一下，我们从未强制规定工作时长。这更多是那些非常在意公司发展轨迹的人自发产生的结果。很多人会来办公室并待到很晚。但如果他们需要早点走去陪孩子吃饭，或者周末去旅行，那当然完全没问题。对我们来说，更重要的是找到那些有极强主人翁意识并全身心投入的人，而不是纠结于在办公室待了几个小时。尽管我们发现，通常是那些最投入的人（虽然不全是）会和我们一起挑灯夜战。

---

### [00:49:30] Lenny Rachitsky

**English:**
When you say high standards, is there something you could share that gives us an example of what you mean there? Because a lot of people think they have high standards and they don't.

**中文翻译:**
当你提到“高标准”时，能不能举个例子说明一下？因为很多人自以为标准很高，其实不然。

---

### [00:49:37] Brendan Foody

**English:**
If you are very patient, there's always some trade-off between speed and quality when hiring. And I remember especially for our first 10 people, we were just so patient and disciplined about finding some of the best people in the world. Half of them are... Our second employee, Sid, as an example, our second employee in the US, Sid was previously the head of growth at Scale who joined us when we were a seed stage company. Daniel who joined us was previously scaled to consumer apps to over 100,000 users and all sorts of just extraordinary backgrounds of our first 10 hires. And I think that that initial talent density shaped so much of what the rest of the org looks like as you scale it up.

**中文翻译:**
如果你非常有耐心，招聘时在速度和质量之间总会有权衡。我记得尤其是前 10 名员工，我们在寻找全球顶尖人才方面非常有耐心且自律。比如我们的第二号员工 Sid，他之前是 Scale 的增长负责人，在我们还是种子轮阶段时就加入了。还有 Daniel，他曾将消费级应用扩展到超过 10 万用户。我们的前 10 名员工都有着非凡的背景。我认为这种初始的人才密度决定了组织在后续扩张过程中的样貌。

---

### [00:50:28] Lenny Rachitsky

**English:**
I know you also have this perspective that people talk about waiting to hire, to hire really slowly, but it's actually not necessarily the right advice. Talk about that.

**中文翻译:**
我知道你也有这样一种观点：人们常说要慢慢招人，但你觉得这不一定是正确的建议。请聊聊这个。

---

### [00:50:39] Brendan Foody

**English:**
It painful because it's a double-edged sword. On one hand, I'm thrilled that our first 10 people are so phenomenal and I think that that has paid dividends for the business. But on the other hand, I think that companies do get to the point where you just need to hire really fast. And there's some things where you need a lot of people to do them and you need to recognize that there's going to be some variants associated with hiring, but moving quickly is the priority.
(00:51:07):
And I think that in some ways, we move too slowly with how we scaled out the team. And so the benefit is that everyone is extraordinary. We have this super high bar and we want to maintain that over time. But I think the downside is that while the company has grown incredibly quickly, we likely could have grown even faster if we had moved a little bit more quickly with especially ramping from call, like 10 to 100 people.

**中文翻译:**
这很痛苦，因为这是一把双刃剑。一方面，我为前 10 名员工如此出色而感到欣喜，这为业务带来了巨大的回报。但另一方面，我认为公司确实会达到一个需要快速招聘的阶段。有些事情需要大量的人手，你必须意识到招聘中会有一些变数，但快速行动是首要任务。
我觉得在某些方面，我们在扩大团队规模时动作太慢了。好处是每个人都很优秀，我们有极高的门槛并希望长期保持。但坏处是，虽然公司增长极快，但如果我们能在从 10 人扩展到 100 人的阶段动作再快一点，我们可能会增长得更快。

---

### [00:51:37] Lenny Rachitsky

**English:**
Okay, I was going to ask. So it sounds like the first 10, be very careful, take your time, 10 to 100, maybe speed up a bit.

**中文翻译:**
好，我正想问。听起来前 10 个人要非常谨慎、慢慢来，10 到 100 人时可以稍微加速。

---

### [00:51:44] Brendan Foody

**English:**
Yes, though I wouldn't say it's necessarily 10. It's determined by the point where you know it's really working. And I know that's still not a bright line, but it's like once you know that there's so much more demand than you can handle, that's when you want to step on the gas and optimize for speed in a lot of ways. But I think especially until then, it's important to be patient, be disciplined. Get the best people is always important, but speed becomes more important once you find the market opportunity, the market vacuum.

**中文翻译:**
是的，虽然不一定是 10 这个数字。这取决于你什么时候意识到业务真的跑通了。我知道这没有明确的界限，但一旦你发现需求远超你的处理能力，那就是该踩油门、在很多方面优化速度的时候了。但在那之前，保持耐心和自律非常重要。招到最好的人永远重要，但一旦你发现了市场机会和市场空白，速度就变得更加重要。

---

### [00:52:20] Lenny Rachitsky

**English:**
I know you've started a couple companies in the past, much smaller scale. In this new role as CEO of this massive hyper growth company, what surprised you most about where you spend the time most or just what the role involves? Because a lot of people want to start companies dream about being in your shoes. What are they maybe not understanding about where a lot of your time goes?

**中文翻译:**
我知道你过去创办过几家规模较小的公司。作为这家大规模超高速增长公司的 CEO，在时间分配或角色职责方面，最让你感到意外的是什么？因为很多人想创业，梦想能处在你的位置。他们可能不了解你的大部分时间都花在了哪里？

---

### [00:52:42] Brendan Foody

**English:**
Yeah, it's actually not too surprising. The top two buckets are always working on hiring and time with customers of how do I really deeply understand what customers need and how we can support them? And then how do I build the team and a lot of the processes around that? Of course, there's all of the ad hoc things I didn't expect of dealing with the people questions of how do we set up our levels and our comp bands and all of that, which you learn as you scale a business. But I think the core places that I spend my time are in line with what I expected as well as what I love doing, which is very fortunate.

**中文翻译:**
其实并不太意外。最核心的两块永远是招聘和与客户沟通——如何深入了解客户需求以及我们如何支持他们？然后是如何建立团队以及相关的流程。当然，也有很多意料之外的琐事，比如处理人事问题、设定职级和薪酬体系等等，这些都是在规模化过程中学习的。但我认为我花时间的核心领域与我的预期一致，也是我热爱做的事情，这非常幸运。

---

### [00:53:27] Lenny Rachitsky

**English:**
So these two companies you've started in the past, maybe share what they work because they're fun, and then how do they help you be successful in this? What's something that they taught you that helped you in your current role?

**中文翻译:**
你过去创办的那两家公司，能不能分享一下是做什么的？挺有趣的。它们是如何帮助你在现在的岗位上取得成功的？它们教给了你什么对现在有帮助的东西？

---

### [00:53:38] Brendan Foody

**English:**
Yeah, so there's been like a dozen, but I'll choose my favorite two. So when I was in eighth grade, I started Donut Dynasty where I saw that Safeway Donuts were selling for $5 a dozen, and I was amazed because I felt like as an eighth grader, this was such an incredible deal. And I started to bike down to Safeway, buy Safeway Donuts for $5 a dozen, and then go back to my middle school and then sell them for $2 each, running really good margins of course. It sold out super quickly. And so then I need to scale up. So I would pay my mom $20 to drive me in her minivan down to Safeway, buy 10 dozen donuts, go to my middle school, sell them all out.
(00:54:19):
And then the school tried to shut me down because I was selling food on school campus, which they didn't like. So they had me in the principal's office asking me to not do that. And then I moved my donut stand over 50 feet, so it was off school campus, saying that they could no longer police me. I remember we had competitors pop up where the competitors were charging. They bought these Chuck's Donuts, which if anyone in the Bay Area knows, are higher end donuts than Safeway Donuts, but they have a higher cost basis. They cost a dollar per. And so I dropped my prices to $1 for two weeks to run them out of business before I knew what anti-competitive practices were. And I'd hire all my friends, paying my friends in donuts because they perceived the donuts as $2 each where they could sell them throughout the school and I could have a lower cost basis on them.
(00:55:12):
So I had all of these fun experiences in selling donuts, and then I could talk more about my high school business as well, which was a more significant scale. But I think the takeaway from that was just like you can just do things. So many people have ideas, but the barrier to more companies being built, I think, is just initiative and taking the steps to build the product or experience that customers want and investing the time and the ambition to scale that up. And so I think it was really getting reps of that that enabled me to realize that I should do it later on at a much larger scale.

**中文翻译:**
其实我做过大概十几个项目，但我选两个最喜欢的。八年级时，我创办了“甜甜圈王朝”（Donut Dynasty）。我发现 Safeway 超市的甜甜圈一打才卖 5 美元，作为一个八年级学生，我觉得这简直太划算了。于是我骑车去 Safeway 买一打，回学校每个卖 2 美元，利润非常丰厚。很快就卖光了，所以我需要扩大规模。我付给我妈 20 美元，让她开着面包车带我去 Safeway 买 10 打甜甜圈，然后回学校卖光。
后来学校想取缔我，因为他们不喜欢在校园里卖食品。我被叫到校长办公室，让我别干了。于是我把摊位挪开了 50 英尺，挪到了校外，告诉他们现在管不着我了。我记得当时出现了竞争对手，他们卖的是 Chuck's Donuts（湾区的人知道，这比 Safeway 的高级），但成本更高，每个要 1 美元。于是我把价格降到 1 美元卖了两周，在还没听说过什么是“反竞争行为”之前就把他们挤出了市场。我还雇了朋友，用甜甜圈给他们发工资，因为在他们看来甜甜圈值 2 美元，他们可以在学校里卖，而我的成本更低。
这些卖甜甜圈的经历很有趣，我高中时还做过规模更大的业务。但我觉得最大的收获是：你真的可以“直接去做”。很多人都有想法，但阻碍更多公司建立的障碍其实是缺乏主动性，没有迈出构建产品或体验的第一步，也没有投入时间和野心去扩大规模。正是这些早期的锻炼让我意识到，我以后应该在更大的规模上再做一次。

---

### [00:55:51] Lenny Rachitsky

**English:**
Amazing story. I love how wholesome that is versus drugs, selling donuts.

**中文翻译:**
太棒了。这故事真健康，不是卖药，是卖甜甜圈。

---

### [00:55:56] Brendan Foody

**English:**
Then my mom was very worried. She was like, "Oh, is there any pot of these donuts?" I was like, "No, mom, I assure you these are pure donuts."

**中文翻译:**
当时我妈还很担心，问我：“这些甜甜圈里没放大麻吧？”我说：“没，妈，我保证这是纯正的甜甜圈。”

---

### [00:56:05] Lenny Rachitsky

**English:**
I love that you paid your mom $20 to drive.

**中文翻译:**
我喜欢你付给你妈 20 美元车费这个细节。

---

### [00:56:07] Brendan Foody

**English:**
Yeah. She was adamant it couldn't be a handout that she was taking her time to drive me, so she needed to make a little bit of money off of it. We haggled over her title where eventually she wanted to be head of global operations, which we found very entertaining.

**中文翻译:**
是的。她坚持认为这不能是施舍，她花时间开车带我，所以她得赚点钱。我们还为她的头衔讨价还价，最后她想当“全球运营负责人”，我们觉得这非常有意思。

---

### [00:56:22] Lenny Rachitsky

**English:**
I hope that's on her LinkedIn.

**中文翻译:**
我希望这写在她的 LinkedIn 上。

---

### [00:56:24] Brendan Foody

**English:**
Not yet. Maybe she'll have to add it.

**中文翻译:**
还没，也许她得加上去。

---

### [00:56:27] Lenny Rachitsky

**English:**
So you said that you've started a dozen companies?

**中文翻译:**
所以你说你创办过十几个公司？

---

### [00:56:29] Brendan Foody

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:56:29] Lenny Rachitsky

**English:**
Wow. Okay.

**中文翻译:**
哇，好吧。

---

### [00:56:30] Brendan Foody

**English:**
Well, a dozen projects, but I think it was that, and then my AWS company were the two that I scaled up.

**中文翻译:**
准确说是十几个项目，但甜甜圈项目和后来的 AWS 相关公司是我真正做大规模的两个。

---

### [00:56:39] Lenny Rachitsky

**English:**
What's the story behind Mercor as the name?

**中文翻译:**
Mercor 这个名字背后有什么故事吗？

---

### [00:56:42] Brendan Foody

**English:**
Mercor means marketplace in Latin or to buy, sell, trade. And we want to build the largest marketplace in the world, the marketplace for how everyone finds jobs, and that was really the draw to it.

**中文翻译:**
Mercor 在拉丁语中意为“市场”，或者“买卖、交易”。我们想建立全球最大的市场，一个让每个人都能找到工作的市场，这就是这个名字吸引我们的原因。

---

### [00:56:55] Lenny Rachitsky

**English:**
Okay, maybe a last question. This is going back to earlier in discussion because it's something I've been thinking about as we're talking. There's been this shift from data as the fuel for models, and now it's experts. Do you think there's a next step, or is this just will take us to AGI, superintelligence?

**翻译:**
好，最后一个问题。回到我们之前的讨论，因为我在聊天时一直在思考。模型进化的动力已经从“通用数据”转向了“专家”。你认为还有下一步吗？还是说这就会直接带我们走向 AGI 和超级智能？

---

### [00:57:15] Brendan Foody

**English:**
I don't think it's necessarily changing from data to experts. It's more just the paradigm of realizing that labs need this close collaboration with experts to help understand what are the evals that they're building and how can they push the frontier. But I think it's very clear that evals are evergreen, that so long as we want to improve models, we'll need experts to create evals for them and to create the post-training data for them to learn those capabilities. And of course there might be changes in the exact way that people do training with RL or otherwise, but they will always need an eval to measure what does success look like across every domain that they want to build.

**中文翻译:**
我不认为这一定是“从数据转向专家”。更多是一种范式的转变，即实验室意识到需要与专家紧密合作，来理解他们正在构建的评测标准，以及如何突破前沿。但我认为非常明确的一点是，评测是长青的。只要我们想改进模型，我们就需要专家来为它们创建评测，并创建后训练数据让它们学习这些能力。当然，强化学习或其他训练的具体方式可能会变，但他们永远需要一个评测标准来衡量在每个目标领域中“成功”是什么样子的。

---

### [00:58:01] Lenny Rachitsky

**English:**
Okay. So then building on that, a question that comes up a lot these days is, and I know we're talking about fun stuff but I'm getting to serious stuff again, scaling laws and just progression of model intelligence. A lot of people are feeling like, "I don't know, it's slowing down. We're not going to really get to superintelligence at this rate." What is your sense?

**中文翻译:**
好。那么在此基础上，最近经常被提到的一个问题是（我知道我们在聊有趣的事，但我又要聊严肃的话题了）：缩放法则（Scaling Laws）和模型智能的进展。很多人觉得：“我不知道，进展好像变慢了，按这个速度我们无法真正达到超级智能。”你的感觉呢？

---

### [00:58:21] Brendan Foody

**English:**
I totally agree with that. I know there's been some executives to big labs that say we'll have superintelligence in three years, but I think the truth is that it's a longer road. And that's not to diminish from how extraordinary the models are. I think we'll be able to automate a majority of knowledge work tasks in the next 10 years for sure, but that long road is paved with all of the evals that help to make those capabilities possible. And it's not going to be 10X more pre-training data that gets those capabilities. It's much more going to be all of the post-training data sets that are far more data-efficient and thoughtful that help us get there.

**中文翻译:**
我完全同意。我知道有些大实验室的高管说三年内就会有超级智能，但我认为事实是，这是一条更漫长的路。这并不是要贬低模型的非凡之处。我相信未来 10 年内我们肯定能自动化大部分知识性工作任务，但这条长路是由所有帮助实现这些能力的评测铺就的。获得这些能力靠的不是 10 倍的预训练数据，而更多是靠那些数据效率更高、更深思熟虑的后训练数据集。

---

### [00:59:05] Lenny Rachitsky

**English:**
David Sachs tweeted this interesting point that the situation we're now is almost the best case scenario where AI is not in this fast takeoff to superintelligence. There's a lot of competitors keeping each other in check. Models are already very valuable and only getting valuable, more valuable, but there's not just this winner superintelligence taking over the world situation.

**中文翻译:**
David Sachs 发过一条有趣的推文，说我们现在的处境几乎是最好的情况：AI 没有快速起飞直接变成超级智能。有很多竞争对手在互相制衡。模型已经非常有价值，而且越来越有价值，但并没有出现那种“赢家通吃的超级智能统治世界”的局面。

---

### [00:59:26] Brendan Foody

**English:**
Yeah, I think that's true. I think a lot of the super intelligence fearmongering is probably overrated, but at the same time a lot of people's framing around that is even if there is a 5 to 10% chance of this P-Doom, then we should be careful, which seems logical. But I think that it's going to be an extraordinary 10 years for all of Silicon Valley and all of the world as this technology is able to create abundance and giving everyone better medical treatment, the best access to legal recommendations, and the ability to build great products more than we've ever seen before.

**中文翻译:**
是的，我也这么认为。我觉得很多关于超级智能的恐慌可能被夸大了，但同时很多人的逻辑是：即使只有 5% 到 10% 的“毁灭概率”（P-Doom），我们也应该小心，这听起来也合情合理。但我认为，对于硅谷和全世界来说，未来 10 年将是非凡的，因为这项技术能够创造丰盈，为每个人提供更好的医疗、最顶尖的法律建议，以及前所未有的构建伟大产品的能力。

---

### [01:00:06] Lenny Rachitsky

**English:**
And education feels like is transforming.

**中文翻译:**
教育领域似乎也在发生变革。

---

### [01:00:08] Brendan Foody

**English:**
Absolutely, right. I even have felt bits of this over the last 10 years where I remember ever... My parents would give me a hard time for not going to classes in college and I'd be like, well, there's way better lectures on YouTube. Why not just listen there? But I can only imagine as the models get extremely good at conveying information, better than the best professor, what that'll mean and access to all sorts of information to better forward humanity and upskill everyone.

**中文翻译:**
绝对是。过去 10 年我已经感受到了这一点。我记得我上大学时不怎么去上课，我爸妈还为此责备我，我会说：“YouTube 上有更好的讲座，为什么不去那听呢？”但我可以想象，随着模型变得极其擅长传递信息（甚至比最好的教授还好），那将意味着什么——获取各种信息来推动人类进步并提升每个人的技能。

---

### [01:00:41] Lenny Rachitsky

**English:**
So I'll use that as a segue to a final question. I'm going to take us to AI Corner, which is a recurring segment on the podcast. What's some way that you personally use AI to do better work to help you in life?

**中文翻译:**
那我就以此为过渡，问最后一个问题。进入我们的“AI 角落”（AI Corner）环节，这是播客的一个固定板块。你个人是如何使用 AI 来提升工作效率或帮助生活的？

---

### [01:00:52] Brendan Foody

**English:**
Well, let's see. I use it a lot to write documents, as you would expect. I also talk to get advice on problems. I find it helpful to just reason through almost as a thought partner because, yeah, I don't know. I find I think better sometimes when I'm talking something through, but I can't talk through everything with colleagues or people around me.

**中文翻译:**
让我想想。正如你预料的，我经常用它写文档。我也会通过对话来获取关于问题的建议。我发现把它当作“思考伙伴”来理清思路非常有帮助。因为有时候我在边说边想时思考得更清楚，但我不能把所有事情都拿去跟同事或身边的人讨论。

---

### [01:01:15] Lenny Rachitsky

**English:**
And so this is like ChatGPT Voice Mode mostly or something else.

**中文翻译:**
所以这主要是用 ChatGPT 的语音模式（Voice Mode）吗？还是别的？

---

### [01:01:16] Brendan Foody

**English:**
Yeah, I like ChatGPT Voice Mode a lot. There's stuff-

**中文翻译:**
是的，我非常喜欢 ChatGPT 的语音模式。虽然还有……

---

### [01:01:16] Lenny Rachitsky

**English:**
Me too.

**中文翻译:**
我也是。

---

### [01:01:21] Brendan Foody

**English:**
... or room for improvement, but I am very excited about the future of Voice.

**中文翻译:**
……还有改进空间，但我对语音的未来感到非常兴奋。

---

### [01:01:25] Lenny Rachitsky

**English:**
Let me show you something I built, actually. I wasn't planning to talk about this, but there's this guy, Eric Antonow, who's been recommended by a lot of people to get him on this podcast. He's this creative product person that's under the radar now. He's at Facebook for a long time. He built this project called Pirate GPT, which is you basically put ChatGPT into a stuffed animal to talk to it. So built a little wise owl. I don't have it on right now.

**中文翻译:**
其实给你看个我做的东西。我本来没打算聊这个，但有个叫 Eric Antonow 的人，很多人推荐我请他上播客。他是个非常有创意的产品人，现在比较低调，曾在 Facebook 待了很久。他做了一个叫 Pirate GPT 的项目，基本上就是把 ChatGPT 放进毛绒玩具里跟它聊天。所以我做了一个“智慧小猫头鹰”，我现在没把它打开。

---

### [01:01:25] Brendan Foody

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:01:49] Lenny Rachitsky

**English:**
But basically you sew in a little speaker right here and you put a little magnet underneath and you can put it on your shoulder and then you just talk to it.

**中文翻译:**
基本上就是在这里缝一个小扬声器，下面放个磁铁，你可以把它放在肩膀上，然后直接跟它说话。

---

### [01:01:57] Brendan Foody

**English:**
That's so cute. Wow. I love it. I'll have to get one of those. Because I have some of the voice assistants in my apartment, but I really want a ChatGPT voice assistant, so I'm excited for-

**中文翻译:**
太可爱了。哇，我太喜欢了。我也得弄一个。我公寓里有一些语音助手，但我真的很想要一个 ChatGPT 语音助手，所以我很期待……

---

### [01:02:07] Lenny Rachitsky

**English:**
I was just thinking that. Yeah, just come on. Why can't we have a ChatGPT voice just sitting around listening to us all the time. And you can't on your phone because it goes to sleep and it's like, "Hello, what?"

**中文翻译:**
我刚才也在想。是啊，为什么我们不能有一个 ChatGPT 语音助手一直待在旁边听我们说话呢？手机不行，因为它会进入休眠，然后你还得喊“喂？”

---

### [01:02:17] Brendan Foody

**English:**
Exactly. Yeah.

**中文翻译:**
没错。

---

### [01:02:18] Lenny Rachitsky

**English:**
Yeah, so it's what this is trying to be. Well, there's a kickstarter he started that we'll link to that. You could help out.

**中文翻译:**
是的，这就是这个小东西想实现的功能。他发起了一个 Kickstarter 众筹，我们会放上链接，你可以支持一下。

---

### [01:02:22] Brendan Foody

**English:**
There we go.

**中文翻译:**
太好了。

---

### [01:02:23] Lenny Rachitsky

**English:**
That's really easy.
(01:02:25):
Brendan, is there anything else that you wanted to share or touch on or maybe leave listeners with before we get to a very exciting lighting round?

**中文翻译:**
这很容易。
Brendan，在进入激动人心的闪电轮问答之前，你还有什么想分享、探讨或者留给听众的话吗？

---

### [01:02:32] Brendan Foody

**English:**
Tying to the point around initiative and that you can just do things, I encourage everyone, especially with AI and it being so much easier to build, just take the initiative to go out and build products and talk with customers and take that leap of faith because I think that that is in so many ways, the largest barrier to more innovation, the economy in any way that we can support that.

**中文翻译:**
回到关于“主动性”和“你直接去做就行”的那一点，我鼓励每个人，尤其是现在有了 AI，构建东西变得容易得多。请主动去构建产品、与客户交谈，勇敢地迈出那一步。因为我认为在很多方面，缺乏行动力是阻碍经济中更多创新的最大障碍，我们应该尽力支持这种行动力。

---

### [01:02:58] Lenny Rachitsky

**English:**
Yeah. There's so many people that just, let's not bash the podcast, but just listen to podcasts, read posts, just keep reading and listening and don't do anything with that information. And there's never been an easier time to actually build stuff and try stuff.

**中文翻译:**
是的。有很多人（不是要贬低播客）只是听播客、看文章，不停地读和听，却不对这些信息采取任何行动。而现在确实是历史上构建和尝试东西最容易的时候。

---

### [01:03:12] Brendan Foody

**English:**
Totally.

**中文翻译:**
完全同意。

---

### [01:03:12] Lenny Rachitsky

**English:**
So definitely take that advice. Just you can do things. You can move your donut stand 50 feet and get out of their jurisdiction.

**中文翻译:**
所以一定要听从这个建议。你真的可以做成很多事。你可以把甜甜圈摊位挪开 50 英尺，跳出他们的管辖范围。

---

### [01:03:21] Brendan Foody

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:03:21] Lenny Rachitsky

**English:**
Okay, Brendan, with that, we've reached a very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
好了，Brendan，接下来进入激动人心的闪电轮问答。我有五个问题，准备好了吗？

---

### [01:03:26] Brendan Foody

**English:**
All set.

**中文翻译:**
准备好了。

---

### [01:03:27] Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
你最常向别人推荐的两三本书是什么？

---

### [01:03:31] Brendan Foody

**English:**
Let's see. I would say in order, High Output Management is a phenomenal book on running companies. Second is Zero to One, which of course is a classic. And then third is Shoe Dog, where I just find it to be a really inspirational story.

**中文翻译:**
让我想想。按顺序来说：第一本是《高产出管理》（High Output Management），关于公司运营的杰作。第二本是《从 0 到 1》（Zero to One），当然是经典。第三本是《鞋狗》（Shoe Dog），我觉得那是一个非常励志的故事。

---

### [01:03:46] Lenny Rachitsky

**English:**
What is a recent movie or TV show you really enjoyed?

**中文翻译:**
最近有什么你非常喜欢的电影或电视剧吗？

---

### [01:03:49] Brendan Foody

**English:**
I really liked Oppenheimer. My favorite TV show of all time is Suits, so I know not recent, but if I had to choose a recent one, probably Oppenheimer.

**中文翻译:**
我很喜欢《奥本海默》。我最喜欢的电视剧是《金装律师》（Suits），虽然不是最近的。如果非要选一个最近的，那就是《奥本海默》。

---

### [01:03:58] Lenny Rachitsky

**English:**
Very cool. Suits, first time someone's mentioned that. Favorite product you recently discovered that you really love?

**中文翻译:**
很酷。《金装律师》，还是第一次有人提到。最近发现的、你非常喜欢的某个产品？

---

### [01:04:05] Brendan Foody

**English:**
I love using Codex, like the new version. I know it's sort of new in terms of version. Yeah, I think it's incredible and just a huge, huge improvement. So yeah.

**中文翻译:**
我喜欢用 Codex，就是新版本。我知道版本上算比较新的。我觉得它非常不可思议，是一个巨大的进步。

---

### [01:04:19] Lenny Rachitsky

**English:**
Do you have a life motto that you find yourself coming back to, sharing with folks, finding useful in work or in life?

**中文翻译:**
你有什么人生格言吗？那种你会反复思考、分享给别人，并觉得在工作或生活中很有用的？

---

### [01:04:25] Brendan Foody

**English:**
I think it's you can just do stuff, what we were talking about earlier. Take the leap of faith.

**中文翻译:**
我觉得就是“你直接去做就行”，就像我们之前聊的。勇敢迈出那一步。

---

### [01:04:31] Lenny Rachitsky

**English:**
I thought you were going to say can do, which is in your Twitter profile.

**中文翻译:**
我以为你会说“凡事皆可成”（Can do），那是你 Twitter 简介里的。

---

### [01:04:34] Brendan Foody

**English:**
Can do as well, yeah.

**中文翻译:**
“凡事皆可成”也是，没错。

---

### [01:04:36] Lenny Rachitsky

**English:**
Two great ones. Final question. So we were chatting before this about things that we could talk about and you shared this interesting thing that you haven't shared anywhere else, which is that you're dyslexic. Why don't you share that with folks? And just how do you get around that having built the fastest-growing company in history?

**中文翻译:**
两个都很棒。最后一个问题。我们之前聊过可以谈论的话题，你分享了一个从未在别处提过的事：你有阅读障碍（Dyslexic）。为什么不跟大家分享一下呢？在建立了历史上增长最快的公司的同时，你是如何克服这一点的？

---

### [01:04:55] Brendan Foody

**English:**
I don't hide it at all. I think a lot of my colleagues know. And I think on one hand it definitely makes it difficult to go through 1,000 emails a day or read every document that I'm supposed to, but on the other hand, I feel like it helps me to think a little bit differently, to be more creative, and perhaps see that markets are changing that not everyone sees. And so it's turned out okay so far. And so I think one thing it's helped me realize from a management standpoint is that we focus much more on how we can leverage people's strengths rather than helping to improve weaknesses, because there's some things that I'm not great at and I'll never be the best in the world at, and there's others that I can hopefully refine and strive to be.

**中文翻译:**
我一点也不隐瞒，很多同事都知道。一方面，这确实让我很难每天处理 1,000 封邮件或阅读所有该读的文档；但另一方面，我觉得它帮助我以不同的方式思考，让我更有创意，或许还能让我看到别人没察觉到的市场变化。到目前为止，结果还不错。从管理角度来看，这让我意识到：我们应该更多地关注如何发挥人们的长处，而不是去补短板。因为有些事情我确实不擅长，永远做不到世界顶尖，但有些事情我可以不断精进并努力做到最好。

---

### [01:05:46] Lenny Rachitsky

**English:**
That's such a also recurring theme on this podcast of just focusing on strengths and not focusing over all your focus on weaknesses.
(01:05:53):
Brendan, this was incredible. I learned so much. I have a billion more questions, but you got shit to do. Two final questions. What should people know about what you're doing and roles you're hiring for? And then how can listeners be useful to you?

**中文翻译:**
这也是本播客经常出现的主题：专注于长处，而不是把所有精力都花在短板上。
Brendan，这太精彩了。我学到了很多。我还有无数个问题想问，但你还有正事要忙。最后两个问题：关于你们正在做的事以及正在招聘的岗位，大家应该了解什么？听众可以如何帮到你？

---

### [01:06:06] Brendan Foody

**English:**
Absolutely. We're hiring a ton across the board on our team. We're hiring strategic project leads on our operations team, software engineers in our engineering team, as well as researchers. And so please go to mercor.com and we would love to work with you, and that's the largest way that you can help us. Share it with your friends as well. Over half of people in our marketplace come from referrals because we have a platform of people that love us. And so any jobs that you want to apply to or send your friends to, we would love to have you.

**中文翻译:**
当然。我们团队正在全面大举招聘。我们正在招聘运营团队的战略项目负责人、工程团队的软件工程师以及研究人员。请访问 mercor.com，我们非常期待与你共事，这是对我们最大的帮助。也请分享给你的朋友。我们市场中超过一半的人才来自推荐，因为我们的平台拥有一群热爱我们的人。无论你是想自己申请还是推荐朋友，我们都非常欢迎。

---

### [01:06:37] Lenny Rachitsky

**English:**
Brendan, thank you so much for joining me.

**中文翻译:**
Brendan，非常感谢你参加我的节目。

---

### [01:06:39] Brendan Foody

**English:**
Thank you for having me.

**中文翻译:**
谢谢你的邀请。

---

### [01:06:41] Lenny Rachitsky

**English:**
Bye, everyone.
(01:06:43):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。
非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。