# Brian Balfour - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny’s Podcast featuring Brian Balfour.

---

### [00:00:00] Lenny Rachitsky

**English:**
Everyone's always complaining SEO's dead, it can't grow. Word of mouth is so hard.

**中文翻译:**
大家总是在抱怨 SEO 已经死了，没法再增长了。口碑传播也变得非常困难。

---

### [00:00:03] Brian Balfour

**English:**
All of the ingredients for new distribution platform are essentially happening. My prediction, the new distribution platform will be ChatGPT. There's a bunch of signals that they're about to launch that.

**中文翻译:**
新分发平台出现的所有要素基本上都已经具备了。我的预测是，新的分发平台将会是 ChatGPT。有很多信号表明他们即将推出这个平台。

---

### [00:00:14] Lenny Rachitsky

**English:**
This is a huge opportunity for companies to get on it.

**中文翻译:**
对于公司来说，这是一个入局的巨大机会。

---

### [00:00:16] Brian Balfour

**English:**
It ends up being a prisoner's dilemma. Don't trick yourself into thinking that you can't play the game. The cycles seem to be getting shorter and shorter, so you actually have a smaller amount of time. If you don't do it, your competitors are going to go to the new platform and your customer expectations change. There is no opting out of the game.

**中文翻译:**
这最终演变成了一个“囚徒困境”。不要自欺欺人地认为你可以不玩这个游戏。周期似乎变得越来越短，所以你实际拥有的时间更少了。如果你不去做，你的竞争对手就会转向新平台，而你的客户预期也会随之改变。在这个游戏中，没有退出选项。

---

### [00:00:31] Lenny Rachitsky

**English:**
This is the opportunity to disrupt an incumbent.

**中文翻译:**
这是一个颠覆现有巨头（Incumbent）的机会。

---

### [00:00:33] Brian Balfour

**English:**
If you're a late-stage company, you place multiple bets. For startups, it's a totally different ballgame. You have to choose one and go all in.

**中文翻译:**
如果你是一家后期公司，你会进行多方下注。但对于初创公司来说，情况完全不同。你必须选择一个方向并全力以赴。

---

### [00:00:40] Lenny Rachitsky

**English:**
Think about companies like Zynga that grew on Facebook and then became massive companies.

**中文翻译:**
想想那些像 Zynga 这样的公司，它们在 Facebook 上成长起来，然后变成了巨头。

---

### [00:00:43] Brian Balfour

**English:**
Building a great product is one of those things that's necessary, but not sufficient. And actually the separation is between those that build really great distribution.

**中文翻译:**
打造一款优秀的产品是必要条件，但并不充分。实际上，真正的差距在于那些能够建立起极佳分发渠道（Distribution）的人。

---

### [00:00:52] Lenny Rachitsky

**English:**
What would be the backup if not ChatGPT?

**中文翻译:**
如果不是 ChatGPT，备选方案会是什么？

---

### [00:00:54] Brian Balfour

**English:**
My hypothesis of who's best-positioned would actually be...

**中文翻译:**
关于谁处于最有利位置，我的假设其实是……

---

### [00:00:59] Lenny Rachitsky

**English:**
Today, my guest is Brian Balfour. Brian is the founder and CEO of Reforge, a company that I've been a long-time fan and advocate of. Historically, Reforge has focused primarily on teaching courses on product and growth, but more recently they've transitioned to building their own products, including a product called Reforge Insights and a bunch more really cool stuff coming very soon.
(00:01:18):
Prior to Reforge, Brian led growth at HubSpot, and over the course of his career, he has seen the rise and fall of every major distribution channel, including Facebook's ad platform, Google Ads and SEO, and the Apple App Store. Based on what he's seeing, he is predicting the emergence of a brand new and powerful distribution channel that will likely arise in the next six months, centered most likely around ChatGPT. It is really rare for a new growth channel to open up. It's been a long time since the last one appeared, and the people who recognize this and hop on it early are the ones that reap the most rewards. So this is a huge deal.
(00:01:54):
In this conversation, Brian shares what he's predicting, what he's seeing, why this is a big deal, and what you should be doing about it right now. I highly recommend you listen to this full conversation and discuss the ramifications with your team. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a bunch of incredible products for free for one year, including Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Wispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD, and Mobbin. Check it out at lennysnewsletter.com and click Product Pass. With that, I bring you Brian Balfour.

**中文翻译:**
今天的嘉宾是 Brian Balfour。Brian 是 Reforge 的创始人兼 CEO，我长期以来一直是这家公司的粉丝和支持者。从历史上看，Reforge 主要专注于教授产品和增长课程，但最近他们已转型开始构建自己的产品，包括一款名为 Reforge Insights 的产品，还有更多非常酷的东西即将推出。
(00:01:18):
在创立 Reforge 之前，Brian 在 HubSpot 领导增长工作。在他的职业生涯中，他见证了每一个主要分发渠道的兴衰，包括 Facebook 广告平台、Google 广告和 SEO，以及苹果应用商店。根据他的观察，他预测在未来六个月内将出现一个全新的、强大的分发渠道，极有可能围绕 ChatGPT 展开。新的增长渠道开启是非常罕见的，距离上一个渠道出现已经过了很长时间，而那些能够意识到这一点并尽早加入的人将获得最丰厚的回报。所以这是一件大事。
(00:01:54):
在这次对话中，Brian 分享了他的预测、他的所见所闻、为什么这很重要，以及你现在应该做些什么。我强烈建议你听完这段完整的对话，并与你的团队讨论其影响。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯的年度订阅者，你将获得一年免费使用一系列不可思议产品的机会，包括 Lovable、Replit、Bolt、n8n、Linear、Superhuman、Descript、Wispr Flow、Gamma、Perplexity、Warp、Granola、Magic Patterns、Raycast、ChatPRD 和 Mobbin。请访问 lennysnewsletter.com 并点击 Product Pass 查看。下面，让我们欢迎 Brian Balfour。

---

### [00:02:32] Lenny Rachitsky

**English:**
Today's episode is brought to you by DX, the developer intelligence platform designed by leading researchers. To thrive in the AI era, organizations need to adapt quickly, but many organization leaders struggle to answer pressing questions like which tools are working? How are they being used? What's actually driving value? DX provides the data and insights that leaders need to navigate this shift. With DX, companies like Dropbox, Booking.com, Adyen, and Intercom get a deep understanding of how AI is providing value to their developers and what impact AI is having on engineering productivity. To learn more, visit DX's website at getdx.com/lenny. That's getdx.com/lenny.
(00:03:16):
This episode is brought to you by Basecamp. Basecamp is the famously straightforward project management system from 37signals. Most project management systems are either inadequate or frustratingly complex, but Basecamp is refreshingly clear. It's simple to get started, easy to organize, and Basecamp's visual tools help you see exactly what everyone is working on and how all work is progressing. Keep all your files and conversations about projects directly connected to the projects themselves so that you always know where stuff is and you're not constantly switching contexts. Running a business is hard. Managing your project should be easy. I've been a long-time fan of what 37signals has been up to and I'm really excited to be sharing this with you. Sign up for a free account at basecamp.com/lenny. Get somewhere with Basecamp. Brian, thank you so much for being here and welcome back to the podcast.

**中文翻译:**
本期节目由 DX 赞助，这是一个由顶尖研究人员设计的开发者情报平台。为了在 AI 时代蓬勃发展，组织需要快速适应，但许多领导者难以回答紧迫的问题，比如：哪些工具奏效？它们是如何被使用的？到底什么在驱动价值？DX 为领导者提供了应对这一转变所需的数据和洞察。通过 DX，像 Dropbox、Booking.com、Adyen 和 Intercom 这样的公司能够深入了解 AI 如何为开发者提供价值，以及 AI 对工程生产力的影响。欲了解更多信息，请访问 DX 网站 getdx.com/lenny。
(00:03:16):
本期节目由 Basecamp 赞助。Basecamp 是来自 37signals 的著名且直观的项目管理系统。大多数项目管理系统要么功能不足，要么复杂得令人沮丧，但 Basecamp 却清晰得令人耳目一新。它上手简单，易于组织，Basecamp 的可视化工具能帮你准确看到每个人在做什么以及工作进展如何。将所有关于项目的文化和对话直接与项目本身关联，这样你就总能知道东西在哪，而不需要不断切换上下文。经营业务已经很难了，管理项目应该简单点。我长期以来一直是 37signals 的粉丝，很高兴能与大家分享这个。在 basecamp.com/lenny 注册免费账户。用 Basecamp 取得进展。Brian，非常感谢你能来，欢迎回到播客。

---

### [00:04:09] Brian Balfour

**English:**
Yeah, thanks for having me. Excited for this one.

**中文翻译:**
好的，谢谢邀请。我对这次对话很期待。

---

### [00:04:12] Lenny Rachitsky

**English:**
I'm really excited to have you back. We're just going to dive right in. Essentially, you've uncovered a really important trend or insight about how products are going to grow differently in the future, how growth is changing, and this is something that I think a lot of people need to hear, so I asked you to come on to share what you're seeing. I also think this is just very timely. I think you said you're going to say in the next six months things might significantly change, so I'm really excited to do this. We're going to spend this whole conversation on this insight. To set us up, what is just the big idea? What's the high-level idea here?

**中文翻译:**
我很高兴你能回来。我们直接切入正题。基本上，你发现了一个关于未来产品增长方式、增长如何变化的重要趋势或洞察，我认为很多人都需要听听这个，所以我请你来分享你的所见。我也觉得这非常及时。我想你提到过，在接下来的六个月里，情况可能会发生重大变化，所以我很兴奋。我们将用整个对话来讨论这个洞察。为了开始，这个大想法是什么？高层级的核心观点是什么？

---

### [00:04:45] Brian Balfour

**English:**
Just like you, I've spent my whole career just really passionate about startups, figuring out how to build products that win, that emerge in new markets, and one of the things that I have learned over time or one of the things you hear a lot from a lot of folks is, to win, you have to really build a great product. A lot of advice boils down to that. And one of the things that I feel like I've banged my head against the wall in a lot of ways in my career is actually telling people that building a great product is one of those things that's necessary, but not sufficient, and actually the separation is between those that build really great distribution.
(00:05:26):
So this general partner, his name's Alex Rampell, he's at Andreessen Horowitz, actually wrote this blog post 10 years ago back in I think 2015. In the essence of the blog post, he basically says one thing, which is that startups is a game of trying to get distribution before the incumbent can copy. It's this kind of concept of escape philosophy.
(00:05:54):
On that note, which I think os a very good summary of what you're trying to do in a startup and distribution, is that we're right now living in this environment where that game of startups getting distribution faster than the incumbent has gotten way harder in a lot of ways, and in some small cases has gotten a little bit easier. But if we think about this, the way that it's gotten harder and some of the things that probably a lot of founders or folks working on the growth side that probably feel is that, one is that incumbents can copy faster these days. That window that you have to get that escape velocity has actually shrunk. It's decreased.
(00:06:34):
The second thing is that a lot of the organic distribution that we've had, especially over the past few years, has really shrunk as well. Everybody's talking about the decline of SEO and clicks declining, but you also see it in some other cases. A lot of these social platforms don't really let you send as much traffic to sites. LinkedIn just changed their algorithm, which has really dropped organic distribution. Obviously the Twitter-to-X, transition that happened, right? TikTok's almost always been like that.
(00:07:06):
And then the third way that it's gotten harder is that AI's really good at writing software and code generation, and so everybody's feeling this infinite increase of competition, especially at the startup level. YC is pumping out six of the same thing every single cohort. That's what it literally feels like.
(00:07:23):
So it's gotten way harder. This game, this escape velocity game has gotten a lot harder. It's gotten easier in some very exceptional cases like the Cursor or something where AI has been like the spark. I know you wrote the blog post about the race car engine, and I think you said there's the spark plug in the engine. AI really created that, a new type of spark, a new type of interest of early adopters to fuel some new players in a short period of time. So it's amazing to see something like Cursor overtake market share of something like GitHub Copilot in nine months or less. That's how fast it happens. It's kind of crazy.
(00:08:01):
But the main thing that people need to understand is, okay, well, if that's the game I'm playing, how to get to escape velocity before the incumbent? What are all the ways to do that and to really figure that out? There's multiple ways that this can happen, but one of the major ways, one of the major, major ways that we always see is that this can happen when new distribution platforms emerge, because when new distribution platforms emerge, startups are usually the fastest to take advantage of them. It's slower for the incumbents to move. It gives startups this opportunity essentially to play this game.
(00:08:39):
Casey Winters wrote this blog post about two years ago, maybe 18 months ago, about the AI technology shift. His key point was the AI technology shift has been a technology shift that has not come with a distribution shift yet. If you look historically, we've had a bunch of technology shifts from the internet to the cloud to mobile to social, all of these different types of things. Some of them come with new distribution platforms, new ways to distribute products, and some of them don't, but the most powerful ones, the most impactful ones are the ones that do come with these new distribution platforms. His second key point was that these two things don't actually happen at once. Usually you get the technology shift, then you get the distribution shift a little bit later.
(00:09:25):
Now we're a couple years from that post. We are a couple years into AI technology shift, and one of the things that I am seeing is all of the conditions, all of the ingredients for a new distribution platform to emerge are essentially happening. So I think we're at an inflection point where we're going to see this emerge really fast.
(00:09:45):
The key thing for everybody to know is that as new distribution platforms emerge, they follow the same four-step cycle and it's a game that you're playing, that everybody's playing. Just like any game, you need to know the rules of the game. You need to know the steps of the game in order to have any sort of opportunity to win. That's the thing that I've lived through once again, both painfully and also in good ways, and is something that I'm keeping my eye on and something that I've been talking about. Before we go into that four-step cycle, I figured I'll pause there to see if you have any follow-up questions on that.

**中文翻译:**
和你一样，我的整个职业生涯都对初创公司充满热情，研究如何打造制胜产品，如何在市场中脱颖而出。我学到的一件事，也是你经常听人说的一件事是：要赢，你必须打造一款伟大的产品。很多建议都归结为这一点。但在我的职业生涯中，我感觉自己在很多方面都在碰壁，因为我一直在告诉人们，打造一款伟大的产品是必要条件，但并不充分，真正的分水岭在于那些能建立起极佳分发渠道（Distribution）的人。
(00:05:26):
Andreessen Horowitz 的合伙人 Alex Rampell 在 10 年前（大约 2015 年）写过一篇博文。博文的核心观点是：初创公司其实是一场“在现有巨头抄袭你之前获得分发渠道”的游戏。这是一种“逃逸速度”（Escape Velocity）的概念。
(00:05:54):
关于这一点，我认为它很好地总结了初创公司和分发渠道的关系。我们现在所处的环境是，初创公司比巨头更快获得分发渠道的游戏在很多方面变得更难了，虽然在极少数情况下变简单了。如果我们思考一下变难的原因，很多创始人或增长人员可能会感同身受：第一，现在的巨头抄袭速度更快了。你获得逃逸速度的窗口期实际上缩小了。
(00:06:34):
第二，过去几年我们拥有的很多有机分发（Organic Distribution）渠道也大幅萎缩。大家都在谈论 SEO 的衰落和点击量的下降，但在其他方面也能看到。很多社交平台不再允许你向外部网站发送那么多流量。LinkedIn 刚刚更改了算法，大幅降低了有机分发。显然还有 Twitter 到 X 的转变，对吧？TikTok 几乎一直都是这样。
(00:07:06):
第三个变难的原因是 AI 非常擅长写软件和生成代码，所以每个人都感受到了竞争的无限增加，尤其是在初创公司层面。YC 每一期都会推出六个一模一样的东西。这就是现在的真实感受。
(00:07:23):
所以游戏变得难多了。这种逃逸速度的游戏变得难多了。在一些非常特殊的案例中变简单了，比如 Cursor，AI 就像是一个火花。我知道你写过关于赛车引擎的博文，你说引擎里有火花塞。AI 确实创造了那种火花，一种吸引早期采用者的新型兴趣，在短时间内为新玩家提供了动力。看到像 Cursor 这样的产品在不到九个月的时间里就夺取了 GitHub Copilot 的市场份额，真是令人惊叹。速度就是这么快，简直疯狂。
(00:08:01):
但人们需要理解的核心是：好吧，如果这就是我要玩的游戏——如何在巨头之前达到逃逸速度？有哪些方法可以实现这一点？有很多方式，但其中一个最主要的方式，就是当新的分发平台出现时。因为当新平台出现时，初创公司通常是反应最快、最先利用它们的。巨头行动较慢。这给了初创公司玩这场游戏的机会。
(00:08:39):
Casey Winters 在大约两年前写过一篇关于 AI 技术转型的博文。他的核心观点是：AI 技术转型目前还没有伴随分发渠道的转型。回顾历史，我们经历过从互联网到云、到移动、到社交的各种技术转型。其中一些带来了新的分发平台和分发产品的新方式，有些则没有。但最强大、影响最深远的是那些伴随着新分发平台的转型。他的第二个观点是，这两者通常不会同时发生。通常先有技术转型，稍后才有分发转型。
(00:09:25):
现在距离那篇文章已经过去几年了。我们进入 AI 技术转型也几年了，我看到的是，新分发平台出现的所有条件和要素基本上都已经具备了。所以我认为我们正处于一个拐点，我们将看到这种平台迅速崛起。
(00:09:45):
大家需要知道的关键是，随着新分发平台的出现，它们遵循同样的四个阶段循环，这是每个人都在玩的游戏。就像任何游戏一样，你需要了解游戏规则和步骤，才有机会获胜。这是我再次经历过的事情，既有痛苦的教训，也有成功的经验，这也是我一直在关注和谈论的事情。在我们进入那四个阶段循环之前，我想先停一下，看看你有没有什么后续问题。

---

### [00:10:24] Lenny Rachitsky

**English:**
Okay. This is amazing. Essentially what you're saying is we follow these ways to grow, there's SEO, there's paid growth, there's sales. All these channels have been around for a long time. They're extremely saturated. Everyone's always complaining SEO's dead, it can't grow, the SEO, anymore. It can't grow. Word of mouth is so hard, there's so many amazing things now that's hard. Paid is so hard. It's just all this money just-

**中文翻译:**
太棒了。基本上你的意思是，我们习惯了这些增长方式：SEO、付费增长、销售。所有这些渠道都已经存在很久了，而且极度饱和。每个人都在抱怨 SEO 死了，没法再通过 SEO 增长了。口碑传播也很难，现在优秀的东西太多了。付费广告也极难，钱就像是……

---

### [00:10:24] Brian Balfour

**English:**
Tax are rising.

**中文翻译:**
获客成本（CAC）在上升。

---

### [00:10:24] Lenny Rachitsky

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:10:49] Brian Balfour

**English:**
All these things. Yeah.

**中文翻译:**
所有这些因素。是的。

---

### [00:10:50] Lenny Rachitsky

**English:**
So all these saturated channels, and what you're saying is there's an emerging new channel that has not yet been saturated, and this is a huge opportunity for companies to get on it. And you'll talk about timing because it's a little tricky to even know exactly when to go big on this.

**中文翻译:**
所以这些渠道都饱和了，而你所说的是有一个新兴的、尚未饱和的新渠道，这对公司来说是一个巨大的机会。你待会会谈到时机问题，因为要准确知道什么时候该大举投入确实有点微妙。

---

### [00:11:05] Brian Balfour

**English:**
That's right. Yeah.

**中文翻译:**
没错。

---

### [00:11:06] Lenny Rachitsky

**English:**
But that's a huge deal. This has been a long time since there's a new way to grow that you can actually use as a lever for growth and not just hope for the best. Okay.

**中文翻译:**
但这是一件大事。已经很久没有出现一种你可以真正作为增长杠杆，而不仅仅是碰运气的增长方式了。好的。

---

### [00:11:15] Brian Balfour

**English:**
Yeah. That's right.

**中文翻译:**
是的，没错。

---

### [00:11:15] Lenny Rachitsky

**English:**
Before you get into the cycles, do you want to tease what the answer is, just to give people a little hint, or do you want to keep it secret?

**中文翻译:**
在你进入循环讲解之前，你想先透露一下答案吗？给人们一点提示，还是想保持神秘？

---

### [00:11:23] Brian Balfour

**English:**
Well, to be clear, okay, so my prediction, we don't have a clear winner yet. My prediction of the new distribution platform will be ChatGPT, in some ways that people probably already think it's happening in some ways that it won't, but the thing that is less important or that is more important than whether I have predicted the exact winner correctly, the thing that's more important is to understand the cycle and evaluate how to determine where you want to place your bets and how to place those bets, which I know we'll talk about.
(00:12:02):
I could be wrong about the ChatGPT prediction and what's going to happen there. I think there's going to be two parts of it. There's going to be what they do with a ChatGPT search experience, but I think the bigger thing will be whatever they do with launching a third-party platform on top of ChatGPT, there's a bunch of signals that they're about to launch that, I'm pretty sure it's going to be ChatGPT.
(00:12:25):
The thing I'm way more sure about is that some new distribution platform will emerge and it will follow the same four-step cycle. That's the key. Could be wrong on the first piece, I am very confident on the second piece.

**中文翻译:**
好吧，说清楚一点，我的预测是——虽然目前还没有明确的赢家——我认为新的分发平台将是 ChatGPT。在某些方面，人们可能已经觉得它正在发生，而在另一些方面则不然。但相比于我是否准确预测了赢家，更重要的事情是理解这个循环，并评估如何决定在哪里下注以及如何下注，我们待会会讨论这个。
(00:12:02):
关于 ChatGPT 的预测以及那里会发生什么，我可能会错。我认为会有两个部分：一个是他们在 ChatGPT 搜索体验上的动作，但我认为更大的动作将是他们在 ChatGPT 之上推出的第三方平台。有很多信号表明他们即将推出这个，我非常确定会是 ChatGPT。
(00:12:25):
我更确定的是，某个新的分发平台将会出现，并且它会遵循同样的四个阶段循环。这是关键。第一点我可能会错，但第二点我非常有信心。

---

### [00:12:40] Lenny Rachitsky

**English:**
Okay. Excellent foreshadowing. I completely agree, if it's anything, it would be ChatGPT at this point. Let's get into it. What are the cycles that platforms generally follow?

**中文翻译:**
好的，完美的铺垫。我完全同意，如果说现在有什么平台的话，那一定是 ChatGPT。让我们开始吧，平台通常遵循的循环是什么？

---

### [00:12:49] Brian Balfour

**English:**
Yeah, and I'll give some examples of this, but let me explain the four steps of the cycle first and then we'll go through a bunch of examples of all those individual steps. The four steps are essentially, one is I call a Step Zero. It's the conditions of the market have been met. Step One is about a moat, Step Two is about a platform opening, and Step Three is about the platform closing for control and monetization. Let me briefly explain each one.
(00:13:20):
Step Zero is about the competitive market being met, the conditions being met, and there's a few part piece of this. One is that typically what happens is that there is consensus that there is going to be this new huge category. Think social, think mobile, like all those types of things. In this case, these AI like chat platforms, like a ChatGPT or a clock. There's consensus about that, but there's no clear winner yet. We typically have somewhere between five to seven major players really battling it out and they're all looking for what is the edge? What is the thing that is going to help me win? Because all of these dynamics, in all the history, they either end up in monopolies or duopolies, and so the stakes are really large and so the competition is fierce.
(00:14:13):
That's Step Zero. I think we could all agree that we are in that mode right now. We've got OpenAI battling with Claude, battling with Gemini, and Google with whatever Meta comes out with their new team, so on and so forth. There's huge amounts of capital, there's consensus, all the types. They are in a fierce composition. That's Step Zero.
(00:14:36):
Step One is then these players, somebody essentially identifies whatever the moat is, the thing that is going to help build them defensibility and help them hit escape velocity and become that monopoly or duopoly in that single category. Once they figure out what that moat is, then they need to press the advantage. They need to figure out how to gather that moat as fast as humanly possible. It tends to be that you can't do that by yourself, so you need the help of an ecosystem in order to gather more of that moat.
(00:15:12):
That typically comes down to third-party content creators or app developers and other businesses. So they all establish a third-party platform that has some incentives built in, and usually the value exchange is, hey, you develop on top of my platform, you add more use cases, more engagement, all of these things to my platform, and in exchange, I'm going to give you something in return. Usually that thing that's in exchange is, I'm going to give you some new form of distribution for your application and for your business.
(00:15:48):
But what essentially happens over time is that we go into Step Three, which is the closing period, which is at some point, all of these companies end up starting to lock down the platform. This tends to happen for reasons of monetization and growth. They either competitively don't want somebody to use their own platform to disrupt themselves. We saw that in the early Twitter days with things like Vine and Periscope, shutting those things down unceremoniously, or they need to find ways to monetize at a deeper and deeper level because all these companies, they have to grow.
(00:16:32):
Google's the classic example here of just more and more real estate has either been taken up by either ads or their own first-party applications. That's the key is they close it down by doing by one of a few things. They either shut it down entirely, two, they develop their own first-party applications to absorb the highest use cases, or three, they artificially depress the organic distribution that they gave you in the step prior to push you towards paid mechanisms in order to monetize. I think we should go through multiple examples here, but that's the core essence of the four steps. I'll pause there.

**中文翻译:**
好的，我会举一些例子，但让我先解释一下循环的四个步骤。这四个步骤分别是：我称之为“第零步”的市场条件成熟；第一步是关于“护城河”；第二步是“平台开放”；第三步是“平台关闭”以进行控制和变现。让我简要解释一下每一个。
(00:13:20):
第零步是竞争市场条件成熟。这包含几个部分：一是通常大家会达成共识，认为将出现一个新的巨大类别。想想社交、移动等。在这种情况下，就是像 ChatGPT 或 Claude 这样的 AI 聊天平台。大家有共识，但还没有明确的赢家。通常有 5 到 7 个主要玩家在激烈厮杀，他们都在寻找“优势”是什么？什么能帮我赢？因为历史上所有的这些动态，最终要么形成垄断，要么形成双头垄断，所以赌注巨大，竞争异常激烈。
(00:14:13):
这就是第零步。我想我们都同意现在就处于这个模式。OpenAI 在和 Claude 斗，和 Gemini 斗，Google 也在发力，还有 Meta 的新团队等等。有巨额资本，有共识，竞争白热化。这就是第零步。
(00:14:36):
第一步是，这些玩家中有人识别出了“护城河”是什么，即能帮助他们建立防御性、达到逃逸速度并成为该类别垄断者或双头垄断者的东西。一旦他们弄清楚护城河是什么，就需要扩大优势。他们需要尽可能快地积累护城河。通常你无法独自完成，需要生态系统的帮助。
(00:15:12):
这通常涉及第三方内容创作者、应用开发者和其他企业。因此，他们建立了一个带有激励机制的第三方平台，通常的价值交换是：嘿，你在我的平台上开发，为我的平台增加更多用例和参与度，作为交换，我会给你一些回报。通常这个回报就是为你的应用和业务提供一种新的分发形式。
(00:15:48):
但随着时间的推移，本质上会发生的是我们进入第三步，即“关闭期”。在某个时间点，所有这些公司都会开始锁定平台。这通常是出于变现和增长的原因。要么是出于竞争考虑，不想让别人利用自己的平台来颠覆自己（我们在早期 Twitter 时代看到过，他们毫不留情地关闭了 Vine 和 Periscope）；要么是他们需要找到更深层次的变现方式，因为所有这些公司都必须增长。
(00:16:32):
Google 是这方面的经典例子，越来越多的页面空间被广告或他们自己的第一方应用占据。关键在于，他们通过以下几种方式之一关闭平台：1. 完全关闭；2. 开发自己的第一方应用来吸收最高频的用例；3. 人为压低之前给予你的有机分发，迫使你转向付费机制以实现变现。我认为我们应该多举几个例子，但这就是四个步骤的核心本质。我先停在这里。

---

### [00:17:12] Lenny Rachitsky

**English:**
Awesome. So it's essentially figure out what's going to make, create defensibility long-term with your moat, bring everyone in, "Hey, everyone, welcome to Facebook," everyone joins Facebook and then, okay, and all the developers build on Facebook to bring in more people on Facebook and then they're like, "Okay, now you got to pay. There's a toll," but you love this so much and you're so hooked to all your friends that you're here, you may as well stick around.

**中文翻译:**
太棒了。所以本质上是：弄清楚什么能通过护城河创造长期防御性，把大家都拉进来，“嘿，各位，欢迎来到 Facebook”，大家都加入了。然后，所有开发者在 Facebook 上构建，吸引更多人加入，接着平台说：“好了，现在你们得付钱了，这里有买路钱。”但因为你太喜欢这里了，而且你的朋友都在这，你离不开，所以你只能留下来。

---

### [00:17:35] Brian Balfour

**English:**
That's right. That's right.

**中文翻译:**
没错，就是这样。

---

### [00:17:35] Lenny Rachitsky

**English:**
Amazing. Okay, so yeah, a few examples would be great.

**中文翻译:**
太神奇了。好的，举几个例子会很有帮助。

---

### [00:17:38] Brian Balfour

**English:**
Yeah. You just hit on the first one. This is the first one that I always think about because this is where I learned about this cycle very early in my career. One of my first companies was during the Facebook platform boom, social gaming, all of those applications, and I lived the full cycle in a very short period. I lived the glory days and just the absolute horror days, and it was very painful, but this is exactly what happened.
(00:18:06):
Let's go through the four steps. Step Zero. Facebook was in a brutal battle with MySpace, Friendster and a few others. People forget this. People forget that there was actually a bunch of competitors at that time, and in fact those competitors were bigger than Facebook. They had more users back in 2007 when Facebook launched their third-party platform. But one of the key things is that Facebook was very early to the insight about the direct network effects in that there's going to create real lock-in that the more friends, the more of the global network that was on there, the more that it was just going to feed and hit this escape velocity.
(00:18:44):
At the time they launched their platform, I think they were maybe one-fourth, one-fifth the size of something like MySpace or even Friendster, Orkut, these are some of the names at that time, but they opened up their third-party platform. What was the value exchange? They went to third-party developers and they said, "Okay, we've created this canvas," they used to call it the canvas, and they were like, "You can put anything in the canvas that you want: an app, a game, whatever. You can monetize in any way you want. We just want this sidebar real estate on the ads. That's what we're really interested in." There was this mad gold rush on that Facebook.
(00:19:24):
Oh, sorry, the other part of that was, "Not only will you put it there, we're going to give you access to all of these notification channels and feed to get distribution for your application." That was the other piece of it. You had this mad rush of developers coming in and you had this huge social application, social gaming boom. People just grew incredibly virally very fast, but eventually, essentially what happened over time is they kept peeling back that value exchange.
(00:19:52):
They first were like, "Ah, actually those dollars that you're making inside that canvas area, well, we want a percentage of that." So they changed that. And then they figured out their ad systems and then they started peeling back. They started suppressing access to all of the organic channels that they had. Eventually, they went all the way towards absorbing the highest use case into their own first-party platform, things like first-party applications, things like events, photos, all those types of things, and basically shut down the platform for dead.
(00:20:30):
These companies that have basically built on top of this platform, the other thing is by the time they started closing all those things down, all those competitors that we talked about, they were so far ahead at that point because they had built off the back of all these developers coming, adding use cases, bringing more users onto the platform, identifying that moat. They were so far ahead, it didn't matter. It didn't matter what the other folks did at that point, and that's what really gives you confidence to start closing down. But there's so many other examples of this if we go through it.

**中文翻译:**
是的，你刚好提到了第一个。这是我经常想到的第一个例子，因为我在职业生涯早期就学到了这个循环。我的第一批公司之一是在 Facebook 平台繁荣时期，做社交游戏和相关应用，我在很短的时间内经历了完整的循环。我经历了辉煌的日子，也经历了绝对恐怖的日子，非常痛苦，但这正是发生的事情。
(00:18:06):
让我们走一遍这四个步骤。第零步：Facebook 当时正与 MySpace、Friendster 等对手进行惨烈战斗。人们忘了这一点，忘了当时其实有很多竞争对手，事实上那些对手比 Facebook 还要大。2007 年 Facebook 推出第三方平台时，他们的用户更多。但关键在于，Facebook 很早就洞察到了直接网络效应，即更多的朋友、更多的全球网络在上面会创造真正的锁定效应，从而推动它达到逃逸速度。
(00:18:44):
在他们推出平台时，规模可能只有 MySpace、Friendster 或 Orkut 的四分之一或五分之一。但他们开放了第三方平台。价值交换是什么？他们对第三方开发者说：“好的，我们创建了这个‘画布’（Canvas），你可以在里面放任何你想要的东西：应用、游戏等等。你可以用任何方式变现。我们只想要侧边栏的广告位，那是我们真正感兴趣的。”于是 Facebook 上出现了疯狂的淘金热。
(00:19:24):
哦，抱歉，另一部分是：“你不仅可以把东西放在那，我们还会让你访问所有的通知渠道和信息流（Feed），为你的应用获取分发。”这是另一块。于是开发者蜂拥而至，出现了巨大的社交应用和社交游戏热潮。人们通过病毒式传播增长得极快。但随着时间的推移，本质上发生的是他们不断收回那种价值交换。
(00:19:52):
他们首先说：“啊，其实你在画布区域赚的那些钱，我们要抽成。”于是他们改了规则。接着他们完善了广告系统，开始收回权限。他们开始压制对所有有机渠道的访问。最终，他们走向了极端，将最高频的用例吸收到自己的第一方平台中，比如第一方应用、活动、照片等，基本上把平台给封死了。
(00:20:30):
对于那些构建在平台之上的公司来说，另一件事是，当 Facebook 开始关闭这些东西时，他们已经遥遥领先于我们提到的那些竞争对手了。因为他们借助所有这些开发者加入、增加用例、带来更多用户，识别并巩固了护城河。他们领先太多了，以至于其他人在那个点做什么都无所谓了，而这正是让你有信心开始关闭平台的底气。如果我们继续讲下去，还有很多其他的例子。

---

### [00:21:02] Lenny Rachitsky

**English:**
Just before you give other examples, just something I'll highlight here. One is the moat they identified in theory was the friend graph, I imagine?

**中文翻译:**
在你举其他例子之前，我想强调一点。我猜他们理论上识别出的护城河是“好友关系图谱”（Friend Graph）？

---

### [00:21:02] Brian Balfour

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:21:10] Lenny Rachitsky

**English:**
Just once we have all your friends, you're not going to want to go anywhere. I imagine it's also important to note, this is a natural thing that would happen if you build the thing and it grows and you're like, "Oh, maybe we should change strategy." I imagine not everyone even knows this is what will happen and they organically evolve their strategy, or do you think everyone's just like, "This is now going to be our plan, Step 1, 2, 3, 4?"

**中文翻译:**
只要我们掌握了你所有的朋友，你就哪儿也不想去了。我想还有一点很重要：如果你做了一个东西，它成长了，然后你觉得“哦，也许我们该改变策略”，这似乎是自然发生的。我猜并不是每个人都知道会发生这种事，他们是自然而然地演变策略的，还是你认为大家其实心里都有数：“这就是我们的计划，第 1、2、3、4 步”？

---

### [00:21:32] Brian Balfour

**English:**
I think a different version of that question is I think some people could sit here and interpret this as all these folks are evil. That's not what I'm saying. That's actually not what I'm saying. I want to be very clear on that, because I think this cycle happens because of competitive and capitalistic dynamics and pressures. It's the same environment that enables creating amazing new companies here in the US.
(00:22:01):
And there's two sides of the coin. You go through this cycle because it's a competitive environment. You're trying to figure out how to beat competitors, and this is one of the strategies to beat competitors. But at some point you just have to continue growing. You have to grow those dollars. The market does not reward flat companies, if anybody's noticed. You have to keep growing, and so they have to keep finding ways to grow as well as prevent their own disruption. TThey can get so big and they can give access, so much access of distribution to new developers, they don't want to enable their own disruption as well as they need to keep growing.
(00:22:38):
My guess is anybody who is sitting in their shoes owning their platform is going to follow the exact same playbook and the exact same reasoning. Look, sometimes it happens also because it actually is the best thing for the user. Facebook's channels did get super spammy and all of those things, and that was part of the reason they'd play this, but let's be honest, it wasn't the only reason. A lot of it was for these other reasons. I don't think it's evil. You just need to know how to play the game. That's competition, that's business. They're playing you, so you need to play them. That might be a little sadistic or something, but that is business. You're in a game of competition.

**中文翻译:**
我认为这个问题的另一个版本是：有些人可能会觉得这些人很邪恶。我并不是这个意思，我想说得很清楚。我认为这个循环的发生是因为竞争、资本主义动态和压力。正是这种环境让美国能够创造出令人惊叹的新公司。
(00:22:01):
硬币有两面。你经历这个循环是因为竞争环境。你在想方设法击败对手，而这就是击败对手的策略之一。但在某个点，你必须持续增长。你必须增加收入。如果有人注意到了，市场是不奖励停滞不前的公司的。你必须不断增长，所以他们必须不断寻找增长的方法，同时防止自己被颠覆。他们变得如此庞大，给了新开发者如此多的分发权限，他们既不想让自己被颠覆，又需要保持增长。
(00:22:38):
我的猜测是，任何处在他们位置、拥有平台的人，都会遵循完全相同的剧本和逻辑。听着，有时这样做也是因为对用户最好。Facebook 的渠道确实变得非常垃圾（Spammy），那是他们采取行动的部分原因，但坦白说，那不是唯一的原因。很大程度上是出于其他原因。我不认为这很邪恶，你只需要知道如何玩这个游戏。这就是竞争，这就是生意。他们在利用你，所以你也需要利用他们。这听起来可能有点残酷，但这就是商业。你处于一场竞争游戏中。

---

### [00:23:23] Lenny Rachitsky

**English:**
Essentially, the incentives are pointing you in this direction. Capitalism, they say capitalism works, and so it'll pull everyone in this direction even if maybe they want to avoid it. Let's do a couple more examples.

**中文翻译:**
本质上，激励机制指向了这个方向。资本主义，人们说资本主义行得通，所以它会把每个人都拉向这个方向，即使他们可能想避开。让我们再看几个例子。

---

### [00:23:33] Brian Balfour

**English:**
Yeah, we'll go through them quick. I think everybody's probably... Google's an interesting one because it played out over a much longer period of time. Facebook happened over the course of about in five-ish years, something like that. Google did it very slowly over years, but same thing, early massive competition against Yahoo, I don't know, AltaVista, Lycos, you name them all. That was even before my time. They were first to really identify these data moats and incentivizing essentially web developers, content folks to optimize for their search algorithms, create this great distribution mechanism. Everybody's building content and everything for them, but over time, slowly but surely they did two things.
(00:24:19):
One is more and more that real estate became ads that they were monetizing, so they're suppressing organic distribution in order to push people towards the ads, as well as absorbing a bunch of the highest value first-party use cases, things like travel as an example, or even restaurant search and all those types of things. The former Yelp CEO and founder has been out there saying a lot of things about these practices. So, same exact cycle.
(00:24:48):
Mobile went through the exact same cycle. iOS created a new distribution mechanism. They had a ton of competition among different phones when they first started on. They found the defensibility was more about the apps, the data and all the developers, created the App Store, all of these types of things, but over time, we've seen more and more restrictions there on that front.
(00:25:09):
And then most recently, we've seen this happen in smaller places, too. LinkedIn, as an example, first went through this wave with company pages. They were like, "Ah, companies, come on, promote your company page. Bring in more users, all that type of stuff, and then get all these followers." And then of course you get almost no distribution now through your company page because they're pushing you towards ads. And then they recently just did this with personal profiles, too, which is they really boosted distribution for individuals to create content for that platform. They then introduced the thought leader ad format, a way to monetize those individual posts, and now you've seen them really pull back on that organic distribution.
(00:25:52):
So this happens in big forms and it happens even in smaller use cases as well, but once again, the steps of the cycle are exactly the same. The key part about this, too, is that the broad trend is that the cycles seem to be getting shorter and shorter and shorter and shorter, so you actually have a smaller amount of time to play the game.

**中文翻译:**
好的，我们快点过一下。我想大家可能……Google 是个有趣的例子，因为它发生的时间跨度要长得多。Facebook 大约发生在五年左右的时间里。Google 则是在很多年里缓慢进行的，但情况是一样的：早期与 Yahoo、AltaVista、Lycos 等对手激烈竞争。那甚至是在我入行之前。他们率先识别出了数据护城河，并激励 Web 开发者和内容创作者针对他们的搜索算法进行优化，建立了一个极佳的分发机制。每个人都在为他们构建内容，但随着时间的推移，他们缓慢而坚定地做了两件事。
(00:24:19):
一是越来越多的页面空间变成了他们用来变现的广告，所以他们压制有机分发以迫使人们转向广告；二是吸收了一系列最高价值的第一方用例，比如旅游、餐厅搜索等。Yelp 的前 CEO 兼创始人一直在公开抨击这些做法。所以，完全是同样的循环。
(00:24:48):
移动端也经历了同样的循环。iOS 创造了新的分发机制。刚开始时，不同手机之间竞争激烈。他们发现防御性更多在于应用、数据和所有开发者，于是创建了 App Store 等等。但随着时间的推移，我们看到那里的限制越来越多。
(00:25:09):
最近，我们在一些较小的领域也看到了这种情况。以 LinkedIn 为例，它首先经历了公司主页（Company Pages）的浪潮。他们说：“嘿，公司们，快来推广你们的主页，带来更多用户，获取粉丝。”然后，现在你的公司主页几乎得不到任何分发，因为他们在推广告。最近他们对个人资料也这么干了：他们极大地提高了个人在平台上创作内容的分发量，接着推出了“思想领袖广告”（Thought Leader Ad）格式来变现这些个人帖子，现在你看到他们已经开始大幅削减有机分发了。
(00:25:52):
所以这种情况既发生在大平台上，也发生在较小的用例中。再次强调，循环的步骤完全相同。关键在于，大趋势是这些周期似乎变得越来越短，所以你玩游戏的时间实际上变少了。

---

### [00:26:11] Lenny Rachitsky

**English:**
Okay, and the big a-ha here is, yes, this will end maybe not great for you, but there's this magical period when they're open to customers and users where you can grow like crazy because they want everyone to come and they give you a distribution. What you're saying essentially is ChatGPT, potentially some other platform, maybe is about to enter this moat.

**中文翻译:**
好的，这里的核心感悟（A-ha moment）是：是的，结局对你来说可能不太妙，但在他们对客户和用户开放的那个神奇时期，你可以疯狂增长，因为他们希望大家都来，并且会给你分发量。你本质上是说 ChatGPT，或者其他潜在平台，可能即将进入这个“护城河”阶段。

---

### [00:26:35] Brian Balfour

**English:**
Yeah. Well, before we get to ChatGPT, I think the natural reaction when you first realize this is, "Screw them, I'm not playing that game." That's what I feel like most people, how they react. Because the unfortunate truth is that a lot of companies don't predict that last stage and end up in a really hard position. So many companies got completely killed during the crash of the Facebook social platform. Apple's 30% tax basically destroyed a bunch of types of applications and business models because you feel like it just wasn't margin-effective. So many companies built on SEO loops that are in serious, serious trouble right now if that's their only channel. So all these things.
(00:27:33):
I think the natural reaction is, why would I play this game if I'm a startup or a company? You can even see this with ChatGPT, as an example. They just launched these deep research connectors. One of them was my former company, HubSpot. If you sat inside HubSpot and you were just thinking in isolation, you would be like, well, why would I want to make all of my data accessible through ChatGPT and have all of the usage you start to accrue there? That doesn't really make sense in isolation. But we don't operate in isolation. Once again, we operate in a competitive environment.
(00:28:11):
What's going to happen is that if you don't do it, your competitors are going to certainly go to the new platform and your customer expectations change, and you have to rise to those customers' expectations. They're going to start expecting you to be in these new experiences and all these things. It ends up being a prisoner's dilemma, which is, there is no opting out of the game. You have to play the game. So it's better to be early than to be super late to this game, especially, especially if you are a startup. That's the key opportunity.
(00:28:51):
We will talk a little bit more about how to play the game more, but it's better to be early as well as, then the key, the harder part about it is anticipating that last stage of the cycle and figuring out how to sequence away from something before that last cycle comes. I think that's the key part, but let me pause there and then I'll talk a little bit about ChatGPT and some of my reasoning behind that.

**中文翻译:**
是的。在谈到 ChatGPT 之前，我想当你第一次意识到这一点时，自然的反应是：“去他们的，我不玩这个游戏。”我觉得大多数人都会这么反应。因为不幸的事实是，很多公司没有预见到最后一个阶段，最终陷入了非常艰难的境地。Facebook 社交平台崩溃期间，很多公司彻底倒闭了。苹果 30% 的税基本上摧毁了一堆应用类型和商业模式，因为利润率根本撑不住。很多建立在 SEO 循环上的公司，如果那是他们唯一的渠道，现在正处于非常严重的麻烦中。
(00:27:33):
我认为自然的反应是：如果我是一家初创公司或企业，我为什么要玩这个游戏？以 ChatGPT 为例，你甚至能看到这一点。他们刚刚推出了深度研究连接器（Deep Research Connectors）。其中之一就是我的前公司 HubSpot。如果你坐在 HubSpot 内部孤立地思考，你会觉得：为什么要让 ChatGPT 访问我所有的数据，让所有的使用量都开始在那里累积？孤立来看这确实没道理。但我们不是在孤立运作，再次强调，我们处于竞争环境中。
(00:28:11):
将会发生的是，如果你不做，你的竞争对手肯定会去新平台，而你的客户预期会改变，你必须满足这些预期。他们会开始期望你在这些新体验中出现。这最终变成了“囚徒困境”，也就是说，你无法退出。你必须玩这个游戏。所以在这个游戏中，早入局总比晚入局好，尤其是如果你是一家初创公司。这是关键的机会。
(00:28:51):
我们会再多谈谈如何玩这个游戏，但早入局是更好的，而且关键且更难的部分是预见循环的最后一个阶段，并想办法在最后一个周期到来之前有序地撤离。我认为这是核心部分。我先停一下，然后谈谈 ChatGPT 以及我背后的一些逻辑。

---

### [00:29:12] Lenny Rachitsky

**English:**
Cool. So what you're saying is not only is there going to be this big opportunity to grow, if you don't take advantage of it, somebody in your space will. It's not only there's an opportunity, but this is something you need to do because you might miss the boat.
(00:29:26):
I think about companies like Zynga that grew on Facebook and then became massive companies. If they didn't do that, they would've missed the boat, someone else would've eaten that lunch. I don't know, I'm thinking about the Technology Bros podcast on Twitter right now, TBPN, where they basically figured out on Twitter you can create this livestream and you see it all day in your Twitter feed just like, hey, they're broadcasting, and it's a really cool distribution channel.
(00:29:49):
I think there's a big call to arms here almost of just the opportunities emerging and you basically need to pay attention. You can't opt out.

**中文翻译:**
酷。所以你的意思是，不仅有一个巨大的增长机会，而且如果你不利用它，你所在领域的某个人也会利用。这不仅是一个机会，而且是你必须做的事情，因为你可能会错过这趟车。
(00:29:26):
我想到了像 Zynga 这样的公司，它们在 Facebook 上成长并成为巨头。如果它们没那么做，就会错过机会，别人会抢走它们的生意。我想到了 Twitter 上的 Technology Bros 播客（TBPN），他们发现在 Twitter 上可以创建直播，你整天都能在信息流里看到他们在广播，这是一个非常酷的分发渠道。
(00:29:49):
我认为这几乎是一个“战斗号召”：机会正在显现，你必须关注。你无法置身事外。

---

### [00:29:58] Brian Balfour

**English:**
That's right. That's right.

**中文翻译:**
没错，就是这样。

---

### [00:29:58] Lenny Rachitsky

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:29:58] Brian Balfour

**English:**
Exactly.

**中文翻译:**
正是如此。

---

### [00:30:00] Lenny Rachitsky

**English:**
Okay, so let's talk ChatGPT.

**中文翻译:**
好的，那我们来谈谈 ChatGPT。

---

### [00:30:02] Brian Balfour

**English:**
Look, let's go through this cycle. Right now we're in that competitive environment. Like we said, all those players we talked about, ChatGPT, Claude, Gemini, all these folks, they are battling it out. We've seen this with the Talent Awards especially over the past month or so. There's no clear winner yet, but there's consensus around the category.
(00:30:25):
The second thing is then, okay, what's the moat? Has the moat been identified? And who seems to have identified it the first or as furthest along? My hypothesis, and I think there's a lot more consensus around this now than there might've even been three months ago, is that the moat is about context and memory. These models by themselves, if you compare them side by side, they generate the same result, and so the actual difference-maker is which one has more of your context, because it's the context plus the model that produces the best output, and then that starts to accrue to this loop around memory. The more you use it, the more it's able to store a memory around you, which feeds more personalized context, which produces better outputs. It ends up being another one of those flywheels, another one of those loops.
(00:31:16):
If you look at who's farthest on this, it definitely is ChatGPT. They were the first ones to memory. They've been investing a lot in these different types of data connectors, essentially context connectors, gathering all of this context, so you can really start to see it in the usage.
(00:31:37):
The second thing is, and one of the pushbacks I've gotten on my prediction has been, well, what about Google and Gemini? They have so much distribution through Chrome and all of this other stuff. Deedy Das, who's a VC at Menlo Ventures, actually published some good data on retention of all of these different ones.
(00:32:00):
I think the second reason I predict ChatGPT is if you look at history once again, it was never the person who had the biggest distribution at the moment of time. It was the one that had the best retention and engagement. Google had the best retention and engagement over the others. Facebook was smaller, but had way better retention and engagement over the others, so on and so forth.
(00:32:22):
The data that Deedy published clearly show that both the retention curves, which I know you and I have both written about at exhaustion, level off at significant portions higher than all the other platforms, as well as those retention curves have been shifting up dramatically over time, you can start to see the effects of memory. They have the very elusive smile curve, the ones that you just like. I've seen all of those dynamics very few times in my career, and they tend to be the folks like Slack and all of the big winners. It's just so elusive

**中文翻译:**
听着，让我们走一遍这个循环。现在我们处于竞争环境。就像我们说的，ChatGPT、Claude、Gemini 这些玩家正在激战。尤其是在过去一个月左右的人才争夺战中就能看出来。目前还没有明确的赢家，但大家对这个类别有共识。
(00:30:25):
第二件事是：护城河是什么？护城河被识别出来了吗？谁似乎最先识别出它，或者走得最远？我的假设是——而且我认为现在的共识比三个月前要多得多——护城河在于“上下文”（Context）和“记忆”（Memory）。这些模型本身如果并排比较，生成的结果差不多，所以真正的区别在于哪一个拥有你更多的上下文。因为是“上下文 + 模型”产生了最好的输出，然后这开始累积成一个围绕记忆的循环。你用得越多，它就越能存储关于你的记忆，从而提供更个性化的上下文，产生更好的输出。这最终变成了另一个飞轮，另一个循环。
(00:31:16):
如果你看谁在这方面走得最远，那绝对是 ChatGPT。他们最先推出记忆功能。他们一直在投资各种数据连接器，本质上是上下文连接器，收集所有这些上下文，所以你真的能从使用情况中看到效果。
(00:31:37):
第二点，我收到的一个反对意见是：那 Google 和 Gemini 呢？他们通过 Chrome 和其他东西拥有巨大的分发量。Menlo Ventures 的风投 Deedy Das 发布了一些关于这些不同平台留存率的数据。
(00:32:00):
我预测 ChatGPT 的第二个原因是，如果你再次回顾历史，赢家从来不是那个在当时拥有最大分发量的人，而是那个拥有最好留存和参与度的人。Google 当时的留存和参与度超过了其他对手。Facebook 当时规模较小，但留存和参与度远超其他对手，以此类推。
(00:32:22):
Deedy 发布的数据清楚地显示，留存曲线（我知道你我都写过很多次了）趋于平稳的比例显著高于所有其他平台，而且这些留存曲线随着时间的推移一直在大幅上移，你可以开始看到记忆效应。他们拥有那种非常罕见的“微笑曲线”（Smile Curve）。在我的职业生涯中，我很少见到这种动态，它们通常出现在像 Slack 这样的大赢家身上。这太难得了。

---

### [00:33:04] Lenny Rachitsky

**English:**
The smile curve, just to people who don't know what that is, is essentially retention goes up over time, it goes down a little bit, and then you come back to it and you use it more.

**中文翻译:**
“微笑曲线”，给那些不知道的人解释一下，本质上是留存率随时间推移而上升：它先下降一点，然后你又回来并更多地使用它。

---

### [00:33:12] Brian Balfour

**English:**
Yeah, that's right, and it's usually the result of some type of network of factor or something else, and it's an early indicator that that platform is on a trajectory to hit escape velocity.
(00:33:27):
The third piece is that, and they haven't really hidden these, but there's all sorts of signals that they're about to launch a third-party platform. They've been hiring for a bunch of roles. I've seen multiple postings on product manager engineering roles, all that kind of stuff for, quote, unquote, "agent platform" and all those pieces. It feels pretty inevitable that one of these players will need to launch a third-party platform in order to serve all the possible use cases on these tools. There's going to be some value exchange, which is like, hey, for your agent to be effective, you probably need access to the context and memory and distribution, so there'll be some value which is, "Integrate to us and we'll give you those three things which is going to drive more users and more usage," and we're going to go through the steps of the cycle.
(00:34:21):
You can already see this. They're starting to form preferred partnerships with some of the bigger players, which paves the way for smaller third-party players. It lends credibility to the platform. It's like, well, if HubSpot and XYZ are doing it, then I should probably do it, too. It's like that type of mentality. But that's why I think out of all of these platforms, ChatGPT has the best shot right now.
(00:34:47):
And then, a bunch of folks are always like, "Well, what about Claude? I really like Claude. I use Claude." Well, the problem with that is I think ChatGPT at this point has at least a 10x difference on MAU. If you're a developer and you're comparing those two platforms and you're looking at it and you're like, "Well, ChatPT has 10x the number of users and better retention engagement," it's like, what's the logical choice of which one you're going to prioritize your scarce resources on?
(00:35:20):
Those are just some of the reasons that my prediction is on ChatGPT. In the blog post that I wrote about this, I actually then played my own devil's advocate and said, "Okay, here are some reasons why it might not be ChatGPT," but I think we're in that part of the cycle. That's my prediction. I might be wrong in the prediction of ChatGPT, but I really think, I feel very confident we're going to see this cycle play out again.

**中文翻译:**
是的，没错。这通常是某种网络效应或其他因素的结果，它是平台正处于达到逃逸速度轨道上的早期指标。
(00:33:27):
第三部分是，他们并没有真正隐藏这些意图，各种信号表明他们即将推出第三方平台。他们一直在招聘一系列职位。我看到过多个产品经理和工程职位的招聘，都是针对所谓的“智能体平台”（Agent Platform）之类的。感觉这些玩家中的某一个必然需要推出第三方平台，以满足这些工具上所有可能的用例。这其中会有价值交换，比如：嘿，为了让你的智能体有效，你可能需要访问上下文、记忆和分发渠道。所以会有这样的价值主张：“接入我们，我们会给你这三样东西，这将带来更多用户和使用量”，然后我们将经历循环的各个步骤。
(00:34:21):
你已经可以看到这一点了。他们开始与一些大玩家建立首选合作伙伴关系，这为小型第三方玩家铺平了道路。这为平台增加了可信度。就像是：“既然 HubSpot 和某某公司都在做，那我也该做。”就是这种心态。这就是为什么我认为在所有这些平台中，ChatGPT 目前的机会最大。
(00:34:47):
然后，很多人总是说：“那 Claude 呢？我很喜欢 Claude，我一直在用。”问题在于，我认为 ChatGPT 目前在月活用户（MAU）上至少有 10 倍的差距。如果你是一个开发者，在比较这两个平台，你看到 ChatGPT 有 10 倍的用户量，而且留存和参与度更好，那么逻辑上的选择是什么？你会把稀缺资源优先投入到哪一个？
(00:35:20):
这些就是我预测 ChatGPT 的部分原因。在我写的关于这个主题的博文中，我也扮演了自己的反面角色，说：“好吧，这里有一些可能不是 ChatGPT 的原因”，但我认为我们正处于循环的那个阶段。这是我的预测。我关于 ChatGPT 的预测可能会错，但我非常确信我们会看到这个循环再次上演。

---

### [00:35:45] Lenny Rachitsky

**English:**
Two follow-up questions here. One is, what would be the backup if it's not ChatGPT? It sounds like it might be Gemini or Google?

**中文翻译:**
这里有两个后续问题。第一，如果不是 ChatGPT，备选方案会是谁？听起来可能是 Gemini 或 Google？

---

### [00:35:51] Brian Balfour

**English:**
My hypothesis of who's best-positioned but is not executing on it right now would actually be Apple-

**中文翻译:**
我的假设是，处于最有利位置但目前没有执行这一策略的其实是苹果——

---

### [00:35:59] Lenny Rachitsky

**English:**
Whoa.

**中文翻译:**
哇。

---

### [00:35:59] Brian Balfour

**English:**
... because through the devices, they basically can see everything. They have the ultimate view into your context. They're sitting at that level But I don't know what they're doing. From an execution standpoint, maybe they're going to surprise us with something crazy magical, but we haven't seen any external signals around this. That's probably just based on what real estate and where people live in the stack would own.
(00:36:34):
And then, I think right behind that, I would probably put Google because of owning the context of things like email and the distribution points of search and Chrome and Android and those types of pieces. A lot of people point to them, but my experience with all of their products, going back to the retention engagement thing, is that if we could take a look inside their metrics, I think what we would see is a bunch of fly-by users in their mouse. They're sprinkling the Gemini bucket everywhere. I've literally clicked on it accidentally multiple times. My guess is a huge portion of their mouse is exactly that of what's happening right now. Look, they just acquired a very talented team from Windsurf and from-

**中文翻译:**
……因为通过设备，他们基本上能看到一切。他们对你的上下文拥有终极视角。他们处于那个层级。但我不知道他们在做什么。从执行的角度来看，也许他们会用一些疯狂神奇的东西让我们大吃一惊，但我们还没看到任何相关的外部信号。这可能仅仅是基于他们在技术栈中所占据的地位和用户停留的时间。
(00:36:34):
然后，紧随其后的我认为可能是 Google，因为他们拥有电子邮件等事物的上下文，以及搜索、Chrome、Android 等分发点。很多人看好他们，但根据我对他们所有产品的经验，回到留存和参与度的问题上，如果能看一眼他们的内部指标，我认为我们会看到月活用户（MAU）里有很多“路过”的用户。他们把 Gemini 的入口撒得到处都是。我好几次都是不小心点进去的。我猜他们很大一部分 MAU 正是这种情况。不过，他们刚刚从 Windsurf 招募了一支非常有才华的团队……

---

### [00:37:30] Lenny Rachitsky

**English:**
And just the team. Just the team, part of the team.

**中文翻译:**
只是团队，团队的一部分。

---

### [00:37:31] Brian Balfour

**English:**
Yeah. We'll see. Things are changing dramatically on a week-to-week basis, so we'll see if they're able to press those advantages in a very clear way. But I think the window is very small for them if ChatGPT plays their cards right, because they clearly have the escape velocity right now. If they just keep pressing that advantage in the right way, I think it's going to be very hard for Google to counter in the amount of time that's left

**中文翻译:**
是的。我们拭目以待。情况每周都在发生剧变，所以我们要看他们是否能以非常明确的方式扩大这些优势。但如果 ChatGPT 策略得当，我认为 Google 的窗口期非常小，因为 ChatGPT 现在显然已经具备了逃逸速度。如果他们继续以正确的方式扩大优势，我认为 Google 在剩下的时间里很难反击。

---

### [00:38:00] Lenny Rachitsky

**English:**
On the Claude piece, I'll just throw this nugget out, I had Mike Krieger on the podcast, Head of Product, CPO, at Anthropic, and asked him just, "You're losing to ChatGPT. How do you approach the future of Claude?" He very specifically said, "Yes, they've caught lightning in a bottle. This is just going to win based on what I've seen at Instagram. So we are specifically focusing on what is Anthropic and Claude incredibly good at, which is developer tools, coding, backend stuff." So they're actually leaning more and more into that. If you've seen the revenue recently, they're making, I don't know, approaching 10 billion a year or some crazy amount of money. They're actually doing super well, just in a different use case.

**中文翻译:**
关于 Claude，我分享一个小料。我曾请 Anthropic 的产品负责人（CPO）Mike Krieger 上过播客，问他：“你们正输给 ChatGPT，你如何看待 Claude 的未来？”他非常明确地说：“是的，他们抓住了千载难逢的机会（Caught lightning in a bottle）。根据我在 Instagram 的经验，这注定会赢。所以我们专门专注于 Anthropic 和 Claude 极其擅长的领域，即开发者工具、编程和后端工作。”所以他们实际上越来越倾向于那个方向。如果你看了最近的营收，他们每年的收入接近 100 亿美元，或者某个天文数字。他们在不同的用例中其实做得非常好。

---

### [00:38:40] Brian Balfour

**English:**
I'm glad you mentioned this because this brings up something that we skipped, which is, there are smaller platforms that have existed and will also emerge in this environment as well, and that's what you're alluding to. This tends to happen is things end up growing into more niches. Even if you look at social, like LinkedIn emerged as a subset of the social world, but even on these smaller platforms, these new distribution channels, they go through the same cycle.
(00:39:12):
I'll give something, really a very opposite example of the ones that I gave. Look at the platform Udemy. They are a platform for course creators. I don't know if most people know this, but when they started, their rev share to creators was something like 80% to creators. They started very high. That brought on all the course creators, got their whole marketplace going, so on and so forth. I believe it was about a year ago they announced that they're essentially pushing that rev share down to somewhere between 15 and 20%.

**中文翻译:**
我很期待你提到这一点，因为这引出了我们跳过的一个话题：在这个环境中，已经存在并将继续出现一些较小的平台，这就是你所暗示的。通常发生的情况是，事物最终会向更细分的领域（Niches）发展。即使你看社交领域，LinkedIn 也是作为社交世界的一个子集出现的。但即使在这些较小的平台、这些新的分发渠道上，它们也会经历同样的循环。
(00:39:12):
我举一个和我之前说的完全相反的例子。看看 Udemy 平台。他们是一个面向课程创作者的平台。我不知道大多数人是否知道，他们刚开始时，给创作者的收入分成大约是 80%。起步非常高。这吸引了所有的课程创作者，让整个市场运转起来，等等。我记得大约一年前，他们宣布基本上要把分成比例降到 15% 到 20% 之间。

---

### [00:39:48] Lenny Rachitsky

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:39:48] Brian Balfour

**English:**
They're somewhere at 25 and 30%. Another example of they close down organic distribution in order to monetize, all that kind of stuff. The same thing will happen in this AI world. Cursor, it's very clear Cursor's on the path to also probably create some type of agent platform for developers. That'll be a smaller ecosystem to play in for some products. It feels like everybody has the same strategy at this point is everybody wants to launch an agent platform. I imagine some of these other horizontal productivity tools will do the same thing, maybe like a Notion or an Airtable or a Monday.com or something like that.
(00:40:31):
There will be smaller platforms that will emerge, and they will follow the exact same cycle that I'm also discussing, but in terms of the biggest consumer one, that's where I think ChatGPT has probably the most escape velocity and others will focus on different areas. Just to be clear, I love Claude. I actually use both Claude and ChatGPT-

**中文翻译:**
现在大概在 25% 到 30% 左右。这是另一个为了变现而关闭有机分发的例子。同样的事情也会发生在 AI 世界。Cursor 很明显也正走在为开发者创建某种智能体平台的道路上。对于某些产品来说，那将是一个较小的生态系统。感觉现在每个人的策略都一样：每个人都想推出智能体平台。我想其他一些水平生产力工具也会这么做，比如 Notion、Airtable 或 Monday.com 之类的。
(00:40:31):
会有较小的平台出现，它们会遵循我讨论的完全相同的循环。但在最大的消费级平台方面，我认为 ChatGPT 拥有最强的逃逸速度，而其他人会专注于不同领域。澄清一下，我喜欢 Claude，我实际上同时使用 Claude 和 ChatGPT——

---

### [00:40:58] Lenny Rachitsky

**English:**
Same.

**中文翻译:**
我也是。

---

### [00:40:59] Brian Balfour

**English:**
... for different things. I have lots of love to go around for all these tools. My prediction has no bearing on which product I like the most right now.

**中文翻译:**
……用于不同的事情。我对这些工具都很有好感。我的预测与我现在最喜欢哪款产品无关。

---

### [00:41:07] Lenny Rachitsky

**English:**
Also love Claude. So the key point here you're making is that there's almost a number of distribution channels emerging. Many of them will be niche. I think of LinkedIn. LinkedIn for me has a very targeted audience, for folks that listen to this podcast. Even though it's not, I don't know, Google or Facebook or whatever, it's still incredibly valuable for this specific thing that I do.

**中文翻译:**
我也喜欢 Claude。所以你在这里表达的关键点是，几乎有一系列分发渠道正在出现。其中许多会是细分领域的。我想到了 LinkedIn。对我来说，LinkedIn 拥有非常精准的受众，就是听这个播客的人。尽管它不像 Google 或 Facebook 那样，但对于我做的这件事来说，它仍然非常有价值。

---

### [00:41:30] Brian Balfour

**English:**
For sure.

**中文翻译:**
确实。

---

### [00:41:31] Lenny Rachitsky

**English:**
I think this is even more interesting that there's going to be a number of distribution channels that emerge out of this whole AI wave.
(00:41:37):
The other thing I'll note real quick, you mentioned this idea of everyone's building agents. I just had Brett Taylor on the podcast who's building Sierra, and he made me realize why everyone's building agents partly. One is because the outcome-based pricing that you can charge with agents is incredible because, one, you can actually attribute their impact on your business's ROI. You can actually see this is saving an agent $15 because it solved the case. And it's attributable and it's autonomous. It's just doing it on its own. With that, you can charge per outcome. You can say, "We'll charge you a dollar," every time it solves an issue. So the monetization opportunity is huge and the margins go up like crazy.

**中文翻译:**
我认为更有趣的是，在这一波 AI 浪潮中会出现多个分发渠道。
(00:41:37):
另一件我想快速提一下的事，你提到了每个人都在构建智能体（Agents）。我刚请了正在构建 Sierra 的 Brett Taylor 上播客，他让我意识到为什么大家都在做智能体。部分原因之一是：你可以收取的“基于结果的定价”（Outcome-based pricing）非常惊人。因为第一，你可以真正归因它们对业务投资回报率（ROI）的影响。你可以看到这节省了人工客服 15 美元，因为它解决了案例。而且它是可归因的、自主的，它自己在干活。因此，你可以按结果收费。你可以说：“每解决一个问题，我们收你 1 美元。”所以变现机会巨大，利润率也会疯涨。

---

### [00:42:19] Brian Balfour

**English:**
Can I just ask a question about that?

**中文翻译:**
我能就此问个问题吗？

---

### [00:42:21] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
当然。

---

### [00:42:22] Brian Balfour

**English:**
Do you think that has longevity in the sense that... That makes sense in the current environment that we're sitting in right now because people are comparing these outcomes relative to what it costs them today with pure humans. But once again, competition comes in at some point, and so that feels like that creates a pretty ripe opportunity to undercut and come into... and then you have the disruption theory playing out as well. It obviously depends on the infrastructure costs and compute costs to run these things, but I just wonder how much of that is temporary versus something that'll be long-term.

**中文翻译:**
你认为这有持久性吗？在当前环境下这很有道理，因为人们是在将这些结果与目前纯人工的成本进行比较。但再次强调，竞争迟早会介入，所以这感觉像是一个非常成熟的机会，让别人通过低价竞争进入……然后你就会看到颠覆理论上演。这显然取决于运行这些东西的基础设施成本和计算成本，但我只是好奇这在多大程度上是暂时的，还是长期的。

---

### [00:43:07] Lenny Rachitsky

**English:**
So you're saying that dollar will come down to 50 cents, 25 cents, or you're saying someone's going to come with a whole new business model and disrupt that whole approach?

**中文翻译:**
所以你是说那 1 美元会降到 50 美分、25 美分，还是说有人会带着全新的商业模式出现，颠覆整个方法？

---

### [00:43:15] Brian Balfour

**English:**
More the first, yeah. It's just competition erodes that away, essentially, right?

**中文翻译:**
更多是前者。本质上，竞争会侵蚀掉那部分利润，对吧？

---

### [00:43:19] Lenny Rachitsky

**English:**
Yeah, that's a good point. So margins will be higher for a while, and then they'll come down.

**中文翻译:**
是的，好观点。所以利润率会在一段时间内保持高位，然后下降。

---

### [00:43:24] Brian Balfour

**English:**
Unless there's something else that creates a durable pricing power, right?

**中文翻译:**
除非有其他东西能创造持久的定价权，对吧？

---

### [00:43:31] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:43:34] Brian Balfour

**English:**
That's probably the second piece of this. Yeah, that's probably the second piece of that hypothesis, I feel like.

**中文翻译:**
那可能是这个假设的第二部分。我觉得是这样。

---

### [00:43:38] Lenny Rachitsky

**English:**
Yeah. I guess the opportunity there, the moat would be the data, similar to how Cursor is collecting more feedback on what people want in their code suggestions, maybe in theory CRF and has more and more data over time, and there's this network effect-

**中文翻译:**
是的。我猜那里的机会，或者说护城河，将是数据。类似于 Cursor 如何收集更多关于人们对代码建议的需求反馈，理论上 Sierra 随着时间的推移拥有越来越多的数据，就会产生这种网络效应——

---

### [00:43:53] Brian Balfour

**English:**
Yeah. That's right. Let me revise that. I believe in that as long as it's paired with-

**中文翻译:**
是的，没错。让我修正一下：我相信那种模式，只要它配合——

---

### [00:43:59] Lenny Rachitsky

**English:**
Some moat?

**中文翻译:**
某种护城河？

---

### [00:44:00] Brian Balfour

**English:**
... this second piece. Otherwise, it gets competed away.

**中文翻译:**
……这第二部分。否则，它就会被竞争掉。

---

### [00:44:03] Lenny Rachitsky

**English:**
Good tangent. Okay, one more question. What is your prediction on timeline for when the opportunity appears, and what do you predict, as of the day we're recording, what do you predict will be the next couple things that ChatGPT, and let's just focus on that, releases to start to open up this platform to get everyone in there?

**中文翻译:**
很有意思的题外话。好的，还有一个问题。你对机会出现的时间线有什么预测？截至我们录音的今天，你预测 ChatGPT（我们就专注于它）接下来会发布哪几样东西来开始开放这个平台，吸引大家加入？

---

### [00:44:26] Brian Balfour

**English:**
Well, look, I'll first give the disclaimer that I feel like any thoughts on timing in the AI market have been very hard to predict. It's always shorter. That's where we should buy us. It's always shorter than you think of when something's going to happen. That's what it's felt like from the seat that I've been sitting in. But my guess is this: we're going to see the next major steps of this play out over the next six months.
(00:44:57):
I think we just saw one of the pieces drop around this, which was, ChatGPT's recently launched Agent mode. It's kind of a general-purpose agent, and I think that starts to introduce all of the users to using agents and they're figuring out and placing it in the different tiers and business models, all of those pieces. But it's likely that no general-purpose agent is going to fulfill all of the infinite use cases successfully. There's two reasons for this.
(00:45:30):
Users struggle with horizontal tools. They can do everything, and that's exactly why they struggle to adopt, and so they typically need more specific entry points. But also, the more specific use case you get, sometimes you need specific UI, specific data, other specific ingredients to properly fulfill that use case for a given audience. I think their Agent mode was a step in this direction.
(00:45:56):
What I would expect to see play out next is that they will either launch, they will announce the platform with preferred partners, or what they're going announce first is basically a set of preferred partners, the guinea pigs, an initial 10 to 20 folks that are bringing agents to their platform. What that does is essentially, once again, it's a credibility card. You do special deals with some brand names to give the platform credibility, and it creates this desire from everybody else to come on to the platform.
(00:46:37):
And then the step after that is starting to opening up the platform. This is where we'll really start to figure out what this game is going to look like because they basically have to define what the value exchange is. What are they giving you access to, and what are they incentivizing you with to come onto the platform? That's one version of it.
(00:46:58):
The other version of it is just the replacement to search. You can also see them starting to make more moves here, which is deeper attribution in some of the results, those types of pieces. They're bringing in shopping. That's one of their recent announcements as well, native into the UI. Essentially they will form new monetization mechanisms around that stuff as well. That's actually going to be very important because, going back to the moat around memory and context is that they will want to incentivize as many people to their free tier as possible, but given the cost of AI, they have to cover it somehow, so they're going to need some monetization mechanisms. The more that they can cover that free usage with things that aren't subscriptions, I think that probably also feeds the moat.
(00:47:51):
I think those are some of the next steps on two different vectors, more of a third-party developer platform and more of the content, whatever you want to call it, AEO, GEO. I don't know what acronym is we've all decided on yet. Let me know if we have. I think those will be the next steps that we'll see.
(00:48:13):
Now, that's what I think for ChatGPT. I think the thing that we should talk about is, essentially what I would advise folks, especially startups, is you're placing bets. At this part of the cycle, you're placing bets. The winner is 100% guaranteed, as I mentioned, and so you essentially at some point will need to make some decisions about where to place your bets.
(00:48:37):
In the Facebook days, all those other social networks, they also came out with their own platforms. iOS had Android and some failed initiatives from Windows. I don't even remember what that platform was called. You can look back and whoever placed through... the iPhone was actually a very, and iOS is a good one, which is, if you had only aligned your bets to Android, you probably lost. If you somehow found a way to play on both ecosystems, you could be a winner. But if you only aligned to iOS, you could also be a winner. You had to have iOS as part of your betting strategy in order to win.
(00:49:21):
Everybody right now, you're probably at this cycle and you're trying to figure out, well, everybody will need to figure out where are they going to place their chips. How are they going to bet? Depending on how you bet really depends on what your current position is in the marketplace. If you're a late-stage startup, let's start with that, or a late-stage company, you can afford the luxury to place multiple bets and spread your chips and wait it out a little bit to see who the winner is, and then really throw your muscle behind that winner. You have that luxury a little bit. But the risk of that, the risk of that is that sometimes the incumbents wait too long to make that decision, and that's the key question they will need to answer.
(00:50:08):
The key question for startups is totally different. You don't have the luxury to spread your chips. You have to go all in. You have to choose one and go all in. You have scarce resources, scarce attention from the market. It's a totally different ballgame. Higher risk, higher reward, for sure. That's part of the betting strategy for startups. That's what you have to do is you have to figure out your betting strategy, and then we can talk a little bit about how you might evaluate and pick the right course for you. That's where we're all at right now is we just entered the casino, we just put some cash in for some chips, and now we've got to figure out what tables and where to place those chips.

**中文翻译:**
首先我要声明，我觉得 AI 市场的时间线非常难以预测。它总是比你预想的要快。这是我们的偏见。从我的位置来看，事情发生的速度总是比你想象的要短。但我的猜测是：我们将在接下来的六个月里看到接下来的主要步骤。
(00:44:57):
我认为我们刚刚看到了其中一块拼图落地，那就是 ChatGPT 最近推出的“智能体模式”（Agent mode）。它有点像通用智能体，我认为这开始引导所有用户使用智能体，他们正在摸索并将其放入不同的层级和商业模式中。但很可能没有哪个通用智能体能成功满足所有无限的用例。原因有二：
(00:45:30):
用户很难驾驭“水平工具”（Horizontal tools）。它们什么都能做，而这正是用户难以采用的原因，所以他们通常需要更具体的切入点。此外，用例越具体，有时你就越需要特定的 UI、特定的数据和其他特定要素，才能为特定受众妥善满足该用例。我认为他们的智能体模式是朝这个方向迈出的一步。
(00:45:56):
我预计接下来会发生的是，他们要么会发布平台并宣布首选合作伙伴，或者他们首先宣布的是一批首选合作伙伴，也就是“小白鼠”，最初的 10 到 20 个将智能体引入他们平台的人。这本质上再次是一张“信誉牌”。你通过与一些知名品牌达成特殊交易来赋予平台信誉，这会激发其他所有人加入平台的欲望。
(00:46:37):
在那之后的步骤就是开始开放平台。这时我们才会真正开始弄清楚这个游戏会是什么样子，因为他们基本上必须定义价值交换是什么。他们给你开放什么权限？他们用什么激励你加入平台？这是其中一个版本。
(00:46:58):
另一个版本就是搜索的替代品。你也可以看到他们开始在这里采取更多行动，比如在一些结果中加入更深层次的归因。他们正在引入购物功能，这也是他们最近的公告之一，直接内置在 UI 中。本质上，他们也会围绕这些东西形成新的变现机制。这实际上非常重要，因为回到围绕记忆和上下文的护城河，他们会希望激励尽可能多的人使用免费层级，但考虑到 AI 的成本，他们必须以某种方式覆盖成本，所以他们需要一些变现机制。他们越能通过非订阅的方式覆盖免费使用成本，我认为这可能也越能巩固护城河。
(00:47:51):
我认为这些是两个不同维度上的下一步：一个是第三方开发者平台，另一个是内容端，不管你怎么称呼它，AEO（AI 引擎优化）还是 GEO（生成式引擎优化）。我不知道大家最后决定用哪个缩写。我认为这些就是我们将看到的下一步。
(00:48:13):
这就是我对 ChatGPT 的看法。我认为我们应该讨论的是，我给人们（尤其是初创公司）的建议是：你们正在下注。在循环的这个阶段，你们正在下注。正如我提到的，赢家是 100% 确定的（指必有赢家），所以你最终需要在某个时间点决定在哪里下注。
(00:48:37):
在 Facebook 时代，所有其他社交网络也推出了自己的平台。iOS 有 Android，还有 Windows 一些失败的尝试。你可以回过头看，谁把注押在了……iPhone 实际上是一个非常好的例子，如果你只把注押在 Android 上，你可能输了。如果你想办法在两个生态系统上都玩，你可能是赢家。但如果你只押注 iOS，你也可以成为赢家。你必须把 iOS 作为你投注策略的一部分才能赢。
(00:49:21):
现在每个人可能都处于这个循环中，都在试图弄清楚该把筹码放在哪里。如何投注？这取决于你目前在市场中的位置。如果你是一家后期初创公司或后期公司，你可以奢侈地进行多方下注，分散筹码，观望一下谁是赢家，然后全力支持那个赢家。你有一点这种奢侈。但风险在于，有时巨头等待决策的时间太长了，这是他们需要回答的关键问题。
(00:50:08):
初创公司的关键问题则完全不同。你没有分散筹码的奢侈。你必须全力以赴。你必须选择一个并全力以赴。你的资源有限，市场关注度有限。这是完全不同的玩法。风险更高，回报更高，这是肯定的。这是初创公司投注策略的一部分。这就是你必须做的：弄清楚你的投注策略。然后我们可以谈谈如何评估并选择适合你的路径。这就是我们现在的处境：我们刚进赌场，刚换了一些筹码，现在得弄清楚去哪张桌子，筹码放哪儿。

---

### [00:50:56] Lenny Rachitsky

**English:**
I love this analogy. Just to be crystal clear about what listeners should do, what founders should do, what product teams should do, the advice here essentially is integrate with ChatGPT, maybe Gemini, maybe if Apple has something, actually integrate with what they launch. It could be a login thing, could be a search thing, could be a connect and suck up your memory in context. The advice here is you need to do this because this is potentially the way that most companies will start to grow and your competitors may overtake you.

**中文翻译:**
我喜欢这个类比。为了让听众、创始人和产品团队听得清清楚楚，这里的建议本质上是：与 ChatGPT 集成，也许还有 Gemini，如果苹果推出了什么，也要集成。它可能是一个登录功能，可能是一个搜索功能，也可能是一个连接并吸收你上下文记忆的功能。这里的建议是：你必须这样做，因为这可能是大多数公司未来增长的方式，否则你的竞争对手可能会超越你。

---

### [00:51:30] Brian Balfour

**English:**
Yeah. If we had to really simplify it, it's essentially, play the game. Don't opt out of the game. Don't trick yourself into thinking that you can't play the game. That's number one. Number two, no matter who you bet on, just make it a focused bet. Because if you look back, all the failures are the ones that tried to play multiple games at once with scarce resources, and that just tends to never work if you're an early-stage startup. So those two things: play the game, put a focused bet.

**中文翻译:**
是的。如果要极度简化，那就是：入局玩这个游戏。不要退出。不要自欺欺人地认为你玩不了。这是第一点。第二点，无论你押注谁，都要专注。因为回顾过去，所有的失败者都是那些在资源匮乏的情况下试图同时玩多个游戏的人，这对于早期初创公司来说几乎行不通。所以就这两点：入局，专注投注。

---

### [00:52:03] Lenny Rachitsky

**English:**
This episode is brought to you by Miro. Every day, new headlines are scaring us about all the ways that AI is coming for our jobs, creating a lot of anxiety and fear, but a recent survey from Miro tells a different story. 76% of people believe that AI can benefit the role, but over 50% of people struggle to know when to use it. Enter Miro's Innovation Workspace, an intelligent platform that brings people and AI together in a shared space to get great work done.
(00:52:29):
Miro has been empowering teams to transform bold ideas into the next big thing for over a decade. Today, they're at the forefront of bringing products to market even faster by unleashing the combined power of AI and human potential. Guests of this podcast often share Miro templates. I use it all the time to brainstorm ideas with my team. Teams especially can work with Miro AI to turn the unstructured data, like sticky notes or screenshots, into usable diagrams, product briefs, data tables, and prototypes in minutes.
(00:52:58):
You don't have to be an AI master or to toggle yet another tool. The work you're already doing in Miro's canvas is the prompt. Help your teams get great work done with Miro. Check it out at miro.com/lenny. That's M-I-R-O dot com slash Lenny.

**中文翻译:**
本期节目由 Miro 赞助。每天，新的头条新闻都在恐吓我们 AI 将如何取代我们的工作，制造了大量的焦虑和恐惧。但 Miro 最近的一项调查显示了不同的情况：76% 的人相信 AI 可以使他们的角色受益，但超过 50% 的人不知道何时使用它。欢迎使用 Miro 的 Innovation Workspace，这是一个智能平台，将人和 AI 聚集在一个共享空间中，共同完成伟大的工作。
(00:52:29):
十多年来，Miro 一直在赋能团队将大胆的想法转化为下一个大事件。今天，他们通过释放 AI 和人类潜力的结合力量，走在让产品更快进入市场的最前沿。本播客的嘉宾经常分享 Miro 模板。我也一直用它和团队一起头脑风暴。团队尤其可以利用 Miro AI，在几分钟内将便签或截图等非结构化数据转化为可用的图表、产品简报、数据表和原型。
(00:52:58):
你不需要成为 AI 大师，也不需要切换到另一个工具。你在 Miro 画布上已经在做的工作就是提示词（Prompt）。帮助你的团队用 Miro 完成伟大的工作。请访问 miro.com/lenny 查看。

---

### [00:53:14] Lenny Rachitsky

**English:**
So you were Head of Growth at HubSpot for a long time, and you gave that as an example, HubSpot, why would they integrate, why would they give away all their data so that ChatGPT can suck it up, and you never have to go to HubSpot, you're just working through their agent. Would you at HubSpot be like, "Yes, we got to do this. This is the game we got to play"?

**中文翻译:**
你曾在 HubSpot 担任了很长时间的增长负责人，你举了 HubSpot 的例子：他们为什么要集成？为什么要交出所有数据让 ChatGPT 吸收，从而让用户再也不用去 HubSpot，只需通过智能体工作？如果你还在 HubSpot，你会说“是的，我们必须这么做，这就是我们要玩的游戏”吗？

---

### [00:53:31] Brian Balfour

**English:**
Yeah, 100%, and that's exactly what I think you see them doing. Look, to be very clear, I have not talked to anybody at HubSpot about this. I have not talked to Dharmesh about this, but Dharmesh I think has also published about this. The right thing to do is, essentially, even though you understand how the cycle plays out and you don't necessarily understand what your exit strategy is once you get out, it's better to be early, know that you need to figure out an exit strategy and figure out that exit strategy along the way versus waiting and then being super late and then know what the exit strategy is.
(00:54:15):
I think that's exactly what you see them doing. They're trying to be as early to this stuff as possible. I think it's a pretty smart play, even though we might not necessarily see what the exit strategy is out of this cycle for them.

**中文翻译:**
是的，100% 会。我认为你现在看到的正是他们在做的。听着，澄清一下，我没和 HubSpot 的任何人谈过这个，也没和 Dharmesh 谈过，但我认为 Dharmesh 也发表过相关的文章。正确做法是：本质上，即使你明白循环是如何运作的，即使你还不一定知道退出策略是什么，早入局也比晚入局好。早入局，知道自己需要制定退出策略并在过程中去摸索，这比等待、最后迟到、然后才知道退出策略要好。
(00:54:15):
我认为这正是你看到他们在做的。他们正试图尽可能早地参与其中。我认为这是一个相当聪明的举动，尽管我们目前还不一定能看出他们在这个循环中的退出策略是什么。

---

### [00:54:34] Lenny Rachitsky

**English:**
Going back to that amazing quote that you shared at the beginning of the conversation by, I think it was Alex Rampell?

**中文翻译:**
回到你对话开始时分享的那句精彩语录，我想是 Alex Rampell 说的？

---

### [00:54:40] Brian Balfour

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:54:40] Lenny Rachitsky

**English:**
Of that startups win by finding a distribution channel before the incumbent copies them. What you're saying here is this is the opportunity for startups to disrupt an incumbent. This is the opportunity for someone to disrupt Salesforce, I don't know, ServiceNow, all these guys that have been around for a long time.

**中文翻译:**
即初创公司通过在巨头抄袭之前找到分发渠道来获胜。你在这里所说的是，这是初创公司颠覆巨头的机会。这是某人颠覆 Salesforce、ServiceNow 等这些存在已久的公司的大好机会。

---

### [00:54:59] Brian Balfour

**English:**
Yeah, it's going to be one of the major ones. Now look, you've already seen players that have been able to hit this escape velocity, the Cursors and stuff of the world. Once again, there's multiple ways to hit that escape velocity, but this is one of the major ways to do it is to basically hitch yourself to a new platform. Look, you did it yourself, actually. You hitched yourself to Substack super early. You took a focused bet.

**中文翻译:**
是的，这将是主要的机会之一。你看，你已经看到有些玩家能够达到这种逃逸速度了，比如 Cursor 之类的。再次强调，达到逃逸速度有多种方式，但其中一个主要方式就是基本上把自己挂靠在一个新平台上。其实你自己也这么做了：你很早就把自己挂靠在了 Substack 上，你做了一个专注的投注。

---

### [00:55:27] Lenny Rachitsky

**English:**
I was going to say that.

**中文翻译:**
我正想说这个。

---

### [00:55:28] Brian Balfour

**English:**
Yeah, yeah. I don't know why that just hit me, but you took a focused bet and you've benefited from it in a disproportional way than those that came later. I think that's actually a great meta example here as I sit here and think about this.

**中文翻译:**
是啊，我不知道为什么突然想到这个，但你做了一个专注的投注，并且从中获得了比后来者多得多的不成比例的收益。当我坐在这里思考这个问题时，我认为这实际上是一个很好的元例子（Meta example）。

---

### [00:55:44] Lenny Rachitsky

**English:**
Yeah, that's actually the way I thought about when I was moving to Substack. I feel like there's this wave rising and I want to ride this wave, even if maybe it's not the best place or they take a cut, all that stuff. But it worked out really well.

**中文翻译:**
是的，当我转向 Substack 时，我确实是这么想的。我觉得有一股浪潮正在兴起，我想乘风破浪，即使它可能不是最好的地方，或者他们会抽成等等。但结果非常好。

---

### [00:55:55] Brian Balfour

**English:**
That's right. I think it worked out very well.

**中文翻译:**
没错，我认为结果非常出色。

---

### [00:55:58] Lenny Rachitsky

**English:**
It worked out really well. To be honest, it felt like it was too late when I started six years ago.

**中文翻译:**
结果确实很好。老实说，六年前我开始的时候，感觉已经太晚了。

---

### [00:55:58] Brian Balfour

**English:**
It felt too late?

**中文翻译:**
感觉太晚了？

---

### [00:56:05] Lenny Rachitsky

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:56:06] Brian Balfour

**English:**
Oh, say more about that.

**中文翻译:**
噢，多讲讲。

---

### [00:56:07] Lenny Rachitsky

**English:**
It always feels too late, I think, to people that join... Silicon Valley, or sorry, Marc Andreessen has this famous quote. He's like, "I came to Silicon Valley in the '80s. I thought it was over, I was too late. I missed all the opportunities." That's fair. There was just a lot of newsletters. They were doing really well. Millions of subscribers. I'm like...

**中文翻译:**
我认为对于加入的人来说，总会感觉太晚。硅谷……抱歉，Marc Andreessen 有句名言，他说：“我 80 年代来到硅谷，我觉得一切都结束了，我来得太晚了，错过了所有机会。”这很正常。当时已经有很多时事通讯了，它们做得非常好，有数百万订阅者。我就觉得……

---

### [00:56:24] Brian Balfour

**English:**
And what do you say to people now who want to join Substack?

**中文翻译:**
那你现在对那些想加入 Substack 的人怎么说？

---

### [00:56:27] Lenny Rachitsky

**English:**
"Learn from this example." A lot of times when people think that it's too late, it's definitely not too late, and it's always only just getting started. Especially if you're on Twitter all day listening to podcasts like this where we're surrounded with this bubble of everyone talking about something, when in reality, 1% of people know anything about what you're hearing about every day.

**中文翻译:**
“从这个例子中学习。”很多时候当人们认为太晚了，其实绝对不晚，而且往往才刚刚开始。特别是如果你整天泡在 Twitter 上，听像这样的播客，我们被这种“每个人都在谈论某事”的泡沫包围着，而现实中，只有 1% 的人知道你每天听到的那些东西。

---

### [00:56:45] Brian Balfour

**English:**
Yeah. Yeah, that's so interesting.

**中文翻译:**
是的，这很有趣。

---

### [00:56:47] Lenny Rachitsky

**English:**
Okay, so coming back to the advice, say someone is sitting there and talking to their manager like, "Brian just shared all this mind-blowing advice. We got to pick our battles, we got to pick our platform," what would your advice be for them to decide where to place their bets?

**中文翻译:**
好的，回到建议上。假设有人坐在那儿跟他们的经理说：“Brian 刚刚分享了这些令人震撼的建议，我们得选择战场，选择平台。”你会给他们什么建议来决定在哪里下注？

---

### [00:57:06] Brian Balfour

**English:**
I think this is a great question because, once again, put my personal prediction aside for a second, and I would encourage everybody to think about it from first principles from who their audience is, what their product is, what stage of company they're at, their current strengths and weaknesses, you got to take all this into account, but if I had to boil it down to a few criteria, the main things I would think about is, when you're looking at new distribution channels and new platforms to choose on, one, going back to what we said before is the better signal is retention and depth of engagement of the users on this platform than it is pure user level like MAU or some other number of signups, one of those vanity metrics. Look at that number one.
(00:57:51):
Number two is, there's some element of user quality and ability to monetize the users on this platform. I think the starkest example here would be iOS and Android. Even today it's something like Android has 70-some percent of devices, but only 30% of the market share by dollars, and it's the exact flip for iOS. It goes back to what we were talking about earlier, which was, if you bet on Android only, you probably lost, but if you bet on iOS only, even though smaller user base, you were still able to parlay that into a win later.
(00:58:31):
The third thing to look at is, as these platforms emerge, just analyze what the value exchange is. What are they giving you to incentivize you to develop on their platform? All these platforms, it's a bit of a game of whoever understands the rules and how to arbitrage the rules the best tend to be the ones with the edge and figure that out.
(00:58:58):
And then finally, fourth on my criteria would be pure scale. Obviously, even if you have those other three, but there's a 200x difference in scale and momentum, obviously you probably have to choose the bigger platform.
(00:59:20):
But last but not least is as you go through these criteria, these are how you think through entering the game. Once you enter the game, then you immediately need to move to starting to think about how do you exit the game. Knowing once again that that last step is going to come at some point in the future, that there's going to be some closure for monetization, then that's where you have to start thinking through your strategy to exit.
(00:59:47):
That comes down to things like, okay, well how are you going to own an important part of the user experience or workflow? Or how are you going to accumulate specialized data in context that the major platforms don't have? Or how do you create different types of micro network effects? All of these types of things. So just once again, there is the entrance criteria, but once you figure that out and you feel like you're in the game, you immediately need to move towards, okay, what's my exit plan here, knowing this is all coming.

**中文翻译:**
我认为这是一个很好的问题。再次强调，先把我个人的预测放一边，我鼓励每个人从第一性原理出发去思考：受众是谁、产品是什么、公司处于什么阶段、目前的优劣势是什么。你必须考虑所有这些。但如果我必须将其归纳为几个标准，我主要会考虑：
1. 回到我们之前说的，更好的信号是该平台上用户的留存率和参与深度，而不是纯粹的用户规模（如 MAU 或注册数等虚荣指标）。这是第一位的。
(00:57:51):
2. 用户质量和在该平台上变现的能力。最明显的例子是 iOS 和 Android。即使在今天，Android 占据了约 70% 的设备，但按金额计算的市场份额仅为 30%，而 iOS 正好相反。回到我们之前说的：如果你只押注 Android，你可能输了；但如果你只押注 iOS，尽管用户群较小，你仍然能将其转化为后来的胜利。
(00:58:31):
3. 观察这些平台出现时的价值交换。他们给你什么来激励你在他们的平台上开发？所有这些平台都有点像一场游戏，谁最理解规则并最擅长利用规则进行套利（Arbitrage），谁就往往拥有优势。
(00:58:58):
4. 纯粹的规模。显然，即使你拥有前三项，但如果规模和势头有 200 倍的差距，你可能还是得选择更大的平台。
(00:59:20):
最后但同样重要的一点是，当你通过这些标准考虑如何“入局”后，一旦你进入游戏，你就需要立即开始思考如何“出局”。再次强调，知道最后一步（为了变现而关闭平台）迟早会到来，你就必须开始思考你的退出策略。
(00:59:47):
这归结为：你将如何拥有用户体验或工作流的重要部分？或者你将如何积累大平台所没有的专业数据和上下文？或者你如何创造不同类型的微型网络效应？所以，再次强调，有入场标准，但一旦你入局，就要立即制定退出计划，因为你知道那一天总会到来。

---

### [01:00:22] Lenny Rachitsky

**English:**
It's interesting that another way to think about this model you've described as building, the strategy of building on top of LLMs and becoming a GPT wrapper. Because essentially this tech allows you to, say, create a cursor that is incredible, and then you could argue, oh, you're just going to be this wrapper, and they're getting all the money here, everyone can copy you. What's your defensibility long-term? The answer is, what is the moat you will build over time sitting on top of this thing that will make you more and more valuable on term and not have to rely on this thing? It feels like you could use the same framework for building a GPT wrapper business, to use that euphemism.

**中文翻译:**
有趣的是，你描述的这个模型的另一种思考方式是：在 LLM（大语言模型）之上构建的策略，即成为一个“GPT 套壳”（GPT Wrapper）。因为本质上这项技术允许你创建一个像 Cursor 这样不可思议的产品，但别人会争辩说：“哦，你只是个套壳，钱都被模型厂商赚走了，谁都能抄你。”你长期的防御性在哪？答案是：随着时间的推移，你在这些东西之上建立了什么样的护城河，使你变得越来越有价值，而不再依赖于底层模型？感觉你可以用同样的框架来构建一个“GPT 套壳”业务（用这个委婉的说法）。

---

### [01:01:02] Brian Balfour

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:01:04] Lenny Rachitsky

**English:**
Say someone is sitting there today. Is there anything they can do to start making a bet? Is it simply creating an MCP that allows LLMs to suck in your data? Is that the one thing you could do today? Is there anything else that's available today to start using these platforms, or is it just a little too early and they haven't released the good stuff yet?

**中文翻译:**
假设有人今天坐在那儿。他们现在能做些什么来开始下注吗？仅仅是创建一个 MCP（模型上下文协议），让 LLM 吸收你的数据吗？这是今天唯一能做的事吗？还有什么其他现成的方法可以开始利用这些平台，还是说现在还太早，他们还没发布真正的好东西？

---

### [01:01:25] Brian Balfour

**English:**
It might be just a tad too early. We're right on that edge. Some of the questions I'm asking myself is, I'm going through all of these players and where our customers and target audience live, and I'm asking myself the question, okay, if this player launched some type of platform, how would we evaluate it? So on and so forth.
(01:01:51):
You can also try to cozy up to these folks. I would place a large portion of my net worth right now that if we could sit in the OpenAI offices at that front desk, that they are having meetings with potential preferred developers talking about this, we could probably sit there and log it. I do think some people are going to be in a place to develop preferred relationships and make a note. If you're in that spot, then you should definitely play that card. A lot of early-stage startups will be in that place.
(01:02:30):
Other than that, I would say, once they launch these platforms, you can't do much else, so you really know what the value exchange is and what they're going to expose for you, but also just be prepared to turn your strategy on a dime and go all in. I think that's probably one of the hardest parts of this is that these things emerge and you have to capitalize extremely quickly. A lot of times, it's hard for leaders to do that because they don't want to create a feeling of whiplash into the unknown, and we've got all these projects in play. You know all the things. I think that's probably the last part of what we can be doing right now versus just staying on top of everything as it emerges.

**中文翻译:**
可能还稍微早了一点点。我们正处于边缘。我问自己的一些问题是：我正在梳理所有这些玩家以及我们的客户和目标受众在哪里，我在问自己：好吧，如果这个玩家推出了某种平台，我们会如何评估它？等等。
(01:01:51):
你也可以尝试去接近这些人。我现在敢拿我很大一部分身家打赌，如果我们能坐在 OpenAI 办公室的前台，我们会看到他们正在和潜在的首选开发者开会讨论这件事。我确实认为有些人会处于建立首选关系的位置。如果你处于那个位置，那你绝对应该打这张牌。很多早期初创公司都会处于那个位置。
(01:02:30):
除此之外，我想说，在他们正式发布这些平台之前，你做不了太多，因为你得知道价值交换到底是什么，以及他们会为你开放什么。但你也要做好准备，随时调整策略并全力以赴。我认为这可能是最难的部分之一：这些东西一旦出现，你必须极其迅速地抓住机会。很多时候，领导者很难做到这一点，因为他们不想让团队感到一种冲向未知的剧烈震荡（Whiplash），而且我们还有这么多正在进行的项目。你懂的。我认为这可能是我们现在能做的最后一部分工作，此外就是密切关注一切新动向。

---

### [01:03:14] Lenny Rachitsky

**English:**
As you were talking, this reminded me, I recently noticed that ChatGPT is driving me to my newsletter more traffic than Twitter, and I feel like that recently shifted. I didn't even know this was a thing until I just started looking through my referrals. I'm like, "ChatGPT? What the hell is going on there?" It's like a different version of what you're talking about, but essentially, in theory I could block ChatGPT from... I don't know. I don't even know if I can from... including all my stuff.

**中文翻译:**
当你说话时，这让我想起，我最近注意到 ChatGPT 为我的时事通讯带来的流量比 Twitter 还要多，我觉得这是最近才转变的。直到我开始查看推荐来源（Referrals），我才知道这件事。我心想：“ChatGPT？这到底是怎么回事？”这就像是你所说的另一个版本，但本质上，理论上我可以阻止 ChatGPT……我不知道，我甚至不知道我能不能阻止它包含我所有的内容。

---

### [01:03:39] Brian Balfour

**English:**
You can in Substack now, yeah. I just saw that setting in there.

**中文翻译:**
现在在 Substack 里可以了。我刚看到那个设置。

---

### [01:03:42] Lenny Rachitsky

**English:**
Okay. Oh, interesting. That's the similar kind of decision is, is it better for me for it to be recommending my stuff and telling people, "Hey, go check this thing out," or is it better to block it off? I think, per your point, and this is the way I felt, take it all. It's good. In that, it's better that it's from Lenny's newsletter than something else. So someone else will come in and eat that market share.

**中文翻译:**
好的。噢，有趣。这就是类似的决策：是让它推荐我的东西并告诉人们“嘿，去看看这个”更好，还是把它封掉更好？我认为，正如你所言，这也是我的感受：全拿走吧，没关系。因为与其让别人抢走市场份额，不如让流量来自“Lenny's Newsletter”。

---

### [01:04:06] Brian Balfour

**English:**
Yeah, that's right. If you don't do it, somebody else is. I think that's also what all the major media publishers are really contending with right now.

**中文翻译:**
是的，没错。如果你不做，别人就会做。我认为这也是目前所有主要媒体出版商正在努力应对的问题。

---

### [01:04:18] Lenny Rachitsky

**English:**
I guess I need a licensing deal with New York check. Anyway. Okay. I want to go on a totally different tangent. We weren't planning to talk about this. I know that I said this, we're going to be fully focused on this one topic, but there's something you mentioned to me before we start recording that I think will be really interesting to a lot of people.
(01:04:34):
You guys at Reforge are now building actual SaaS products that people can buy. It's not just courses. I don't know if people know that, but let's make sure people understand this. There's actually products for product teams, so maybe just explain that briefly, but the thing that I think is really interesting here is you work with a lot of companies now selling them AI tools, and you have noticed a very big difference between the companies that are really good at adopting AI tools and seeing gains from them from those that don't. Talk about just what you see there, and because this is in theory going to be really helpful to companies that are struggling with adopting AI tools and seeing gains.

**中文翻译:**
我想我需要和《纽约时报》谈个授权协议。不管怎样，我想转到一个完全不同的题外话。我们原本没打算谈这个，我知道我说过我们会专注于这一个话题，但你在录音前跟我提到的一件事，我觉得很多人会感兴趣。
(01:04:34):
你们 Reforge 现在正在构建人们可以购买的实际 SaaS 产品。不只是课程。我不知道大家是否知道这一点，但让我们确保大家理解：现在确实有面向产品团队的产品。也许可以简要解释一下，但我认为这里非常有趣的一点是，你现在和很多公司合作，向他们销售 AI 工具，你注意到那些擅长采用 AI 工具并从中获益的公司与那些不擅长的公司之间存在巨大的差异。谈谈你的所见所闻，因为理论上这对那些在采用 AI 工具并获取收益方面挣扎的公司会非常有帮助。

---

### [01:05:09] Brian Balfour

**English:**
Just to quickly explain that transition so it makes sense for people, which is, I started Reforge just with the interest that there was all these incredible leaders out there growing on the front lines of some of the fastest growing companies and they have all this amazing knowledge and I wanted to encode it in useful and practical ways for others. That took the form of courses and content and product, all that kind of stuff at the beginning. Along the way, everybody kept asking us to essentially build the tools to implement what we taught. Because with anything, you can learn as much as you want. You can listen to my podcast, your podcast, Lenny, whatever, as much as you want, but if you don't actually put it into action and implement it, then it's not really going to create value.
(01:05:56):
People kept asking us to really close that gap and we said no for the longest time. And then about a couple of years ago when AI really started to inflect, it really created this moment that, oh, wow, now there's this opportunity not just to encode this knowledge into content, but also into the products, the software, the tools that we use ourselves. So we started to take a really big bet on that and started to develop this new platform for AI-native product teams.
(01:06:22):
The first product we launched is called Reforge Insights, which acts like your AI product researcher, aggregates all the feedback from all the sources, uses AI to analyze it, helps you explore it, but also will start to identify what are the gaps, the things that you don't have in your feedback today and auto-generate the research to go gather all those new insights, so complete the full cycle. We're going to launch two other major products as part of this platform before the end of the year, but we'll save that for some future episode.
(01:06:53):
So that's been our journey. We've seen inside companies that are going through this transformation from two perspectives. One is obviously selling in that tools, but the other perspective is, for 10 years, companies have been coming to us to help them try some sort of transformation with our learning product.
(01:07:15):
Most companies are not coming to us to just throw a bunch of courses in front of, they're trying to solve some big business problem, some transformation. Now that used to be things like, we've got to figure out this growth thing, or I'm going from sales-led to product-led, or I have more project managers and I need to transition to product managers, something like that. There's some business problem, they're going through some transformation and they saw us as part of that transformation and we got to partake in quite a few of those types of transformation.
(01:07:50):
Now of course, the transformation that everybody's going through is, okay, how do I become more AI-native? How do I adopt this stuff? We've seen a pretty wide spectrum and from both perspectives of how companies are approaching this. I'm sure everybody's seen that AI, we've been calling them the AI manifesto memos from CEOs out there that proclaim, "We are now AI-native," in some grandiose way, but behind the scenes, there's actually some incredibly stark differences in the actual teeth of what backs up those memos and backs up those executive decrees that we should all be AI.
(01:08:43):
Just to point out a few of them, which is, one is that I think the most impactful thing that you can do is form really hard constraints. There's other parts that's like, okay, you want to communicate this, you want to establish an owner of who's going to drive this, you want to build an incentives and rewards, and you see this all playing out in things like building it into your career ladders, or some people are starting to introduce this as questions into their performance reviews, all those types of pieces. But the thing that is actually moving the needle are the companies that are defining incredibly hard constraints.
(01:09:30):
One company that we worked with developed this constraint that they benchmarked against other companies of their revenue size and the team sizes for those stages, and they set a benchmark that we will be one-fifth, each of our functions will be one-fifth the size. What that did is it created a constraint that you couldn't hire above that level, and it forced people to essentially find ways to adopt AI and do things to replace that. So that was one.
(01:10:01):
You've seen these other ones, I can't remember from what company, that might've been Shopify or another, who was like, you are not allowed new headcount until you prove to us that you are not able to accomplish this with AI. That's another hard constraint. But you also see these other constraints on a smaller level, which is executives saying, "I will not do a product review or review a PRD unless it comes with three prototypes." Something like that. That's the hardest one. Those are the biggest constraints.
(01:10:33):
I think the biggest change that I'm seeing is, and the things that separates out the top few percent making this change and everybody else is essentially making the hardest decisions, and that hardest decision is going to come down to exiting people. In every transformation, what we see is essentially three groups of folks. We call them the catalysts, the people leading the charge, the people who are experimenting, doing this on their own time, all that kind of stuff.
(01:11:07):
You then have what we call your converts. These are folks that will make the transformation, they will adapt, but they need structure, they need permission, they need a clear outline, they need a clear plan. I don't say this in a negative way, it's just that that's how some people operate. That's where things like all the things that we were talking about before, which was the decree, the permission, the clear budgets, the rewards, all of those types of things.
(01:11:37):
But then, inevitably you have a certain percentage that are anchors. They're dragging their feet, they're silently creating friction in the background and all those pieces. There's a big difference in how I think companies are treating and thinking about their strategy for those folks. One group is like, ah, we're going to work with them very passively. Others have set a hard deadline. They're either going to make the transformation by X date or we're going to exit folks.
(01:12:13):
A lot of people look at this as being really harsh. I think a lot of people would think that, especially individuals, but let me explain it from more of a CEO perspective. A lot of these companies are seeing this AI transformation, the ones that are taking it more seriously, as this isn't adopting new tools, this isn't a light change. This is a fundamental culture change of how we operate as a company. You can't have 20, 30%, whatever meaningful number of it is of your company trying to operate in a completely different way, in a completely different culture.
(01:12:48):
Cultures thrive on density, and that's why there's sometimes the best ones feel like cults. As a result, from that perspective, it's like, hey, for us to be successful, for this to be the best thing for all employees, we all need to be operating around the same culture of principles and stuff. If that's not you anymore, then we're defining a plan to exit it.
(01:13:16):
I would say that less than 10% of companies we see are taking this hard stance, but I would say they are probably the ones that are farthest along getting the most adoption and are seeing the most results of the ones that are taking those hard stances. There's a bunch of other stuff I could talk about, but that's the high level of what we've seen across a bunch of different companies.

**中文翻译:**
为了让大家理解，我快速解释一下这个转型。我创立 Reforge 是因为我看到有这么多优秀的领导者在一些增长最快的公司前线奋斗，他们拥有惊人的知识，我想把这些知识以有用且实用的方式编码给其他人。最初这表现为课程、内容和产品。在这个过程中，大家一直要求我们构建工具来实现我们所教的内容。因为无论什么事，你可以学到很多，你可以听我的播客、Lenny 的播客，但如果你不付诸行动并实施，它就不会真正创造价值。
(01:05:56):
人们一直要求我们弥合这个差距，但我们在很长一段时间里都拒绝了。直到大约两年前，当 AI 真正开始爆发时，它创造了这样一个时刻：哦，哇，现在不仅有机会将知识编码进内容，还可以编码进我们自己使用的产品、软件和工具中。所以我们开始在这方面下大注，并开始为“AI 原生产品团队”开发这个新平台。
(01:06:22):
我们推出的第一个产品叫 Reforge Insights，它就像你的 AI 产品研究员，汇总来自所有来源的反馈，使用 AI 进行分析，帮助你探索，还会开始识别反馈中的空白，并自动生成研究方案去收集这些新见解，从而完成整个循环。我们将在年底前作为该平台的一部分推出另外两个主要产品，但我们留到以后的节目再说。
(01:06:53):
这就是我们的历程。我们从两个角度看到了公司内部正在进行的这种转型。一是销售这些工具，另一个角度是，10 年来，公司一直找我们通过学习产品来帮助他们进行某种转型。
(01:07:15):
大多数公司找我们不只是为了把一堆课程扔给员工，他们是想解决某个重大的业务问题或转型。过去可能是：我们要搞清楚增长是怎么回事，或者我要从销售驱动转向产品驱动，或者我有更多的项目经理需要转型为产品经理。他们正经历某种转型，并将我们视为转型的一部分。
(01:07:50):
现在，当然，每个人都在经历的转型是：好吧，我如何变得更加 AI 原生？我如何采用这些东西？我们看到了非常广泛的光谱，以及公司对待这件事的两种不同态度。我确信大家都见过那些 CEO 发出的“AI 宣言”，以宏大的方式宣称“我们现在是 AI 原生了”，但在幕后，支撑这些备忘录和行政命令的实际力度却有着天壤之别。
(01:08:43):
指出其中几点：第一，我认为你能做的最有影响力的事情就是设定“硬约束”。其他部分包括：你想沟通这件事，你想确定一个负责人，你想建立激励和奖励机制，你能在职业阶梯或绩效评估中看到这些。但真正起作用的是那些定义了极硬约束的公司。
(01:09:30):
我们合作的一家公司制定了这样一个约束：他们根据同等收入规模的其他公司及其团队规模设定了基准，然后规定我们的每个职能部门规模只能是基准的五分之一。这创造了一个约束，即你不能招聘超过该水平的人员，这迫使人们必须寻找采用 AI 的方法来替代人力。这是其中一个。
(01:10:01):
你还见过其他的，我不记得是哪家公司了，可能是 Shopify 或其他公司，他们规定：除非你向我们证明你无法用 AI 完成这项工作，否则不允许增加新员额。这是另一个硬约束。但在较小层面上你也能看到这些约束，比如高管说：“除非附带三个原型，否则我不会进行产品评审或审阅 PRD。”诸如此类。这是最难的，也是最大的约束。
(01:10:33):
我认为我看到的最大的变化，以及区分那顶尖的百分之几和其别人的地方，在于是否做出了最艰难的决定。而那个最艰难的决定最终归结为“裁员”（Exiting people）。在每一次转型中，我们基本上会看到三类人：我们称之为“催化剂”（Catalysts），即那些带头冲锋、利用业余时间进行实验的人。
(01:11:07):
然后是“转化者”（Converts）。这些人会进行转型，他们会适应，但他们需要结构、许可、清晰的大纲和计划。我这么说并没有贬义，只是有些人的运作方式就是这样。这就是我们之前谈到的那些东西发挥作用的地方：命令、许可、明确的预算、奖励等等。
(01:11:37):
但是，不可避免地，你会有一定比例的“锚定者”（Anchors）。他们拖后腿，在后台默默制造摩擦。我认为公司对待这些人的策略有很大不同。一类公司是采取消极应对；另一类公司则设定了硬期限：要么在某日期前完成转型，要么请你离开。
(01:12:13):
很多人认为这很残酷，尤其是个人。但让我从 CEO 的角度来解释。很多公司将这次 AI 转型（那些认真对待转型的公司）视为不仅仅是采用新工具，也不是微小的改变，而是我们公司运作方式的根本文化变革。你不能让公司里 20%、30% 或任何有意义比例的人试图以完全不同的方式、在完全不同的文化中运作。
(01:12:48):
文化靠“密度”生存，这就是为什么有时最好的文化感觉像邪教。因此，从这个角度来看：嘿，为了让我们成功，为了对所有员工最好，我们都需要围绕相同的文化原则运作。如果你不再适应这种文化，那么我们就制定一个请你离开的计划。
(01:13:16):
我会说，我们看到的只有不到 10% 的公司采取这种强硬立场，但他们可能是走得最远、采用率最高、效果最明显的公司。我还可以谈很多，但这就是我们在不同公司中看到的高层级情况。

---

### [01:13:37] Lenny Rachitsky

**English:**
That is incredibly interesting. I'm glad we went there. I have a newsletter post coming out soon, probably before this episode, that touches on a lot of advice along these lines. I am excited for you guys to keep seeing these insights into companies and sharing more of this because this is I think what a lot of people are looking for, just like things aren't quite clicking at our company. We keep hearing everyone just getting so much more productive. All these companies are running more efficiently and it's not working here. I think that's the kind of advice a lot of people are looking for, so thank you for sharing all that.

**中文翻译:**
这非常有趣。很高兴我们聊到了这个。我很快会发布一篇时事通讯（可能在本集播出前），其中涉及了很多类似的建议。我很兴奋你们能继续深入了解这些公司并分享更多见解，因为我认为这正是很多人在寻找的：为什么我们公司感觉不太对劲？我们一直听说大家变得更有生产力了，所有这些公司运行得更高效了，但在我们这儿行不通。我认为这正是很多人需要的建议，谢谢你的分享。

---

### [01:14:09] Lenny Rachitsky

**English:**
Brian, is there anything else that you wanted to touch on? Anything else you wanted to leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
Brian，还有什么你想谈的吗？在进入我们非常精彩的闪电轮问答之前，还有什么想留给听众的吗？

---

### [01:14:15] Brian Balfour

**English:**
Well, actually, just a couple more points on this topic we should go. There's probably two more things I would say about this. One is that, if you're a CEO listening to this, I would say that most CEOs or most executives are incredibly disconnected from the actual AI adoption taking place inside their companies. I think a lot of executives who have done these decrees and all that kind of stuff think it's happening naturally, but we talked to both groups. We talked to tons of end users and we talked to tons of executives.
(01:14:49):
The story we hear from the end users, the PMs, the eng, all that kind of stuff that we talk to using all this stuff, one of the main questions we ask them is, if we're talking to somebody who's picked up a prototyping tool, say, "Well, how many other people on the product and design team are using this?" Almost 90% of the time it's like, "Ah, it's me and this one other person," and everybody else hasn't taken it up. So there's a huge disconnect.
(01:15:17):
We heard one story, and I can't say the name, but it's a company we all know. It's a major tech company, a tech-forward company. CEO's been out there talking about being AI-native. We talked to one of their principal PMs. Person was early to the prototyping tools. This person shared a prototype with the designer, the eng manager. The designer and eng manager escalated it to the VPs. It caused this whole conversation. Month later, it was still stalling out. This PM happened to then attend a happy hour where the CEO was at and approached the CEO and told the CEO about the experiment that they were running with prototyping and stuff, and the CEO was like, "This is fantastic. Where is it at right now?" He was like, "Oh, well, X, Y, Z happened." The CEO had no idea. And then the CEO is like, "Okay, let me take care of it," and then the next day, it happened.
(01:16:18):
So one is that you have to go to the ground floor on this stuff. Some of the best companies like Shopify and others are measuring actual adoption and usage. They've gone to the extreme on that front to get a bunch of signals and close to the ground. It just goes to show that this is... I don't think we want to talk about going founder mode, but the reality is it's not just about getting into the weeds of your product, but with something this sizable, you got to get into the weeds of the transformation to really understand what's going on and adopt it. That's point number one.
(01:16:58):
The second point I would say is Fareed, we do this podcast called Unsolicited Feedback, Fareed Mosavat had this great quote on it. He was like, "Look, your output is constrained by the slowest part of your system." That stuck in my head because it's absolutely true. If you think about AI adoption as a system, there's all parts of the system that could be slowing adoption. It might be that people don't feel permission or they don't have the budget or they don't have the knowledge, all these types of things. In a lot of these cases, it's things like IT, legal, procurement are the slowest part of the friction and are setting the pace of all of this output.
(01:17:43):
You can also see this in just product teams. There's been all this talk about product managers are becoming the new bottleneck because engineers are speeding up. Well, that's because people are speeding up one part of the product system and not the other parts, which makes sense. They adopted all of this tooling for engineers because they're the biggest head count and the most expensive and all that type of stuff, but product is an output of design, PMs, and engineering. The system is there not to produce code, it's to ship product, and shipping product is the function of those three things.
(01:18:19):
If you just accelerate one part of the system, you're just going to move to the bottleneck to another part and your actual product output, the output of the system doesn't accelerate, either. I think people have to really understand those two things: what is actually happening on the ground floor, and what is the slowest part? What is the thing that is causing the slowest part of the adoption? Just attack them ruthlessly if you're really serious about making this transition.

**中文翻译:**
其实关于这个话题还有两点。第一，如果你是正在听这个节目的 CEO，我想说大多数 CEO 或高管与公司内部实际发生的 AI 采用情况严重脱节。我认为很多发布了命令的高管觉得事情在自然发生，但我们和两边都聊过：我们和大量的终端用户聊过，也和大量的高管聊过。
(01:14:49):
我们从终端用户（PM、工程师等）那里听到的故事是：当我们问一个开始使用原型工具的人，“产品和设计团队里还有多少人在用这个？”几乎 90% 的时间得到的回答是：“啊，就我和另外一个人”，其他人还没开始用。所以存在巨大的脱节。
(01:15:17):
我们听过一个故事，我不能说名字，但那是我们都知道的一家大公司，一家技术领先的公司。CEO 一直在外面谈论 AI 原生。我们和他们的一位首席 PM 聊了聊。这个人很早就开始用原型工具了，他把原型分享给了设计师和工程经理。设计师和工程经理把这件事上报给了 VP。这引发了一场大讨论。一个月后，事情仍然停滞不前。这位 PM 碰巧参加了一个 CEO 也在场的欢乐时光活动，他走过去告诉 CEO 他们正在做的原型实验。CEO 说：“这太棒了，现在进展到哪了？”他说：“哦，发生了某某事。”CEO 完全不知情。然后 CEO 说：“好，我来处理。”第二天，事情就办成了。
(01:16:18):
所以第一点是，你必须深入基层。像 Shopify 这样的一些优秀公司正在衡量实际的采用率和使用情况。他们在这一方面做到了极致，以获取大量信号并贴近地面。这说明……我不想谈论所谓的“创始人模式”（Founder Mode），但现实是，这不仅关乎深入产品的细节，对于如此重大的变革，你必须深入转型的细节，才能真正了解发生了什么并推动采用。这是第一点。
(01:16:58):
第二点，我和 Fareed Mosavat 做了一个叫《不请自来的反馈》（Unsolicited Feedback）的播客，他在里面说了一句很棒的话：“你的产出受限于系统中速度最慢的部分。”这句话深深印在我的脑海里，因为它是绝对正确的。如果你把 AI 采用看作一个系统，系统的各个部分都可能减缓采用速度。可能是人们觉得没有许可，或者没有预算，或者没有知识。在很多情况下，IT、法务、采购是摩擦力最大的部分，决定了所有产出的节奏。
(01:17:43):
在产品团队中也能看到这一点。现在都在谈论产品经理正在成为新的瓶颈，因为工程师的速度变快了。那是因为人们加速了产品系统的一个部分，而没有加速其他部分，这很合理。他们为工程师采用了所有这些工具，因为工程师人数最多、最贵。但产品是设计、PM 和工程的共同产出。系统的存在不是为了产生代码，而是为了交付产品，而交付产品是这三者的函数。
(01:18:19):
如果你只加速系统的一个部分，你只是把瓶颈转移到了另一个部分，你实际的产品产出（系统的产出）并不会加速。我认为人们必须真正理解这两件事：基层到底在发生什么？最慢的部分在哪里？是什么导致了采用过程中最慢的部分？如果你真的想完成这个转型，就无情地攻击这些瓶颈。

---

### [01:18:47] Lenny Rachitsky

**English:**
What a wild time we're living through. So much changes.

**中文翻译:**
我们生活在一个多么疯狂的时代。变化太快了。

---

### [01:18:48] Brian Balfour

**English:**
It is a wild time, yeah.

**中文翻译:**
确实是个疯狂的时代。

---

### [01:18:51] Lenny Rachitsky

**English:**
All these ways that we're all so used to, okay, this is how we do it.

**中文翻译:**
所有这些我们习以为常的方式，那些“好吧，我们就是这么做的”规矩都在变。

---

### [01:18:54] Brian Balfour

**English:**
Yeah. It's exciting and exhausting at the same time, man. That's how I think about it.

**中文翻译:**
是啊。这既令人兴奋又让人筋疲力尽。我就是这么想的。

---

### [01:19:00] Lenny Rachitsky

**English:**
Such a simple way of describing the road.

**中文翻译:**
对这段路程非常简单的描述。

---

### [01:19:02] Brian Balfour

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:19:03] Lenny Rachitsky

**English:**
Oh, my God. Okay, Brian, is there anything else before we get through our very exciting lightning round?

**中文翻译:**
天呐。好的，Brian，在进入我们非常精彩的闪电轮问答之前，还有别的吗？

---

### [01:19:08] Brian Balfour

**English:**
That's it. Let's do lightning round.

**中文翻译:**
没了。开始闪电轮吧。

---

### [01:19:09] Lenny Rachitsky

**English:**
Here we go.

**中文翻译:**
来了。

---

### [01:19:09] Brian Balfour

**English:**
Zap, zap, zap.

**中文翻译:**
嗖，嗖，嗖。

---

### [01:19:11] Lenny Rachitsky

**English:**
Ding, ding, ding. All right, Brian, I've got five questions for you. Are you ready?

**中文翻译:**
叮，叮，叮。好了，Brian，我有五个问题问你。准备好了吗？

---

### [01:19:14] Brian Balfour

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### [01:19:14] Lenny Rachitsky

**English:**
Okay. What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
好的。你最常向别人推荐的两三本书是什么？

---

### [01:19:20] Brian Balfour

**English:**
My God honest answer is that I have not had the time to finish an entire book since I had my second child. From a complete book standpoint, I have not been able to... Things that I actively read on a regular basis, just other content out there that I'll throw out there is, gosh, Jamin Ball from Altimeter Capital writes this great newsletter called Clouded Judgment, which is mixture of market thoughts as well as market stats. That's really useful to help me keep a pulse on the market. I was just reading through some stuff from NFX that's been pretty good lately on all of this. I know James Currier and I, we lived a lot of the same cycles through social and stuff, so I tend to identify with that. I don't know, those are two things that I love reading.
(01:20:19):
Sorry, I'll give one more shout-out to a different podcast, which is from two guys at Spark Capital, Nabeel Hyatt, which I know from my early Boston days, and Fraser, sorry, I'm blanking on the last name right now, who was Head of Product at OpenAI, and they've got a great format where it's just those two riffing on some ideas and stuff. I highly suggest that one. I like that one a lot.

**中文翻译:**
我最诚实的回答是：自从有了第二个孩子，我就没时间读完一整本书了。从完整书籍的角度来看，我还没能……我经常阅读的东西，我会推荐一些其他内容：Altimeter Capital 的 Jamin Ball 写了一份很棒的时事通讯叫《Clouded Judgment》，结合了市场思考和市场统计数据。这对我把握市场脉搏非常有用。我最近还在读 NFX 的一些东西，关于这些话题写得很不错。我知道 James Currier 和我经历了很多相同的社交周期，所以我很有共鸣。这是我喜欢读的两样东西。
(01:20:19):
抱歉，我还要推荐另一个播客，是 Spark Capital 的两个人做的：Nabeel Hyatt（我早年在波士顿就认识他）和 Fraser（抱歉，我突然忘了他的姓），他是 OpenAI 的前产品负责人。他们的形式很棒，就是两个人即兴讨论一些想法。我强烈推荐那个，我很喜欢。

---

### [01:20:45] Lenny Rachitsky

**English:**
Here's my reading tip that has changed my reading habits. Bryan Johnson, the longevity guy, he has this advice for better sleep, which includes, before you go to sleep, read for 10 minutes in bed.

**中文翻译:**
这里有一个改变了我阅读习惯的小贴士。追求长寿的 Bryan Johnson 有一个改善睡眠的建议：睡觉前在床上读 10 分钟书。

---

### [01:20:58] Brian Balfour

**English:**
It does put you to sleep. I don't feel like I retain anything that I read that close to bed, though. Do you feel like you retain it?

**中文翻译:**
这确实能催眠。但我感觉睡前读的东西我什么都记不住。你觉得你能记住吗？

---

### [01:21:05] Lenny Rachitsky

**English:**
I do, I do. I'm reading fiction. It's nonfiction. Sorry. You want to read something calm, not like I'm learning. I'm reading fiction and it's really nice. Knowing that this is going to help me sleep better makes me motivated.

**中文翻译:**
我能记住。我在读小说。噢，不是非虚构类。抱歉。你应该读一些平静的东西，而不是那种“我在学习”的东西。我在读小说，感觉非常好。知道这能帮我睡得更好，我就有动力去读。

---

### [01:21:17] Brian Balfour

**English:**
There's an incentive. There's a reward there.

**中文翻译:**
这是一种激励，一种奖励。

---

### [01:21:19] Lenny Rachitsky

**English:**
The reward, yeah.

**中文翻译:**
是的，奖励。

---

### [01:21:20] Brian Balfour

**English:**
They're talking about rewards and creating behavior change, yeah.

**中文翻译:**
我们在谈论奖励和创造行为改变，没错。

---

### [01:21:23] Lenny Rachitsky

**English:**
Exactly. The reason to do it is this whole thing is you want to get to low resting heart rate, and that helps lower your resting heart.

**中文翻译:**
没错。这么做的原因是你想达到较低的静息心率，而这有助于降低静息心率。

---

### [01:21:29] Brian Balfour

**English:**
I've got some other sleep tips on that front if you want to go down that path, but we'll save that for you.

**中文翻译:**
关于睡眠我还有其他一些建议，如果你想聊的话，但我们留到以后吧。

---

### [01:21:34] Lenny Rachitsky

**English:**
Please, for the third podcast. Okay, next question. Do you have a favorite recent movie or TV show that you really recently enjoyed?

**中文翻译:**
请留到第三次播客。好的，下一个问题。你最近有没有特别喜欢的电影或电视剧？

---

### [01:21:40] Brian Balfour

**English:**
It's not new, but I just rewatched Silicon Valley that I hadn't watched in a number of times. It's painful because the first few seasons, I went through almost every one of those moments in my first startup, like hiring the gray-haired CEO, the funding falling through at the last second, all the crazy stuff, but going back and watching that, there's just some extra nuances and stuff that I feel like they wrote really well that I thought was really good. I've really been watching that.
(01:22:16):
The other thing that I've watched is just more of a just pure entertainment, calming thing, turn the brain off is Owen Wilson's new show on Apple TV, Stick, which is about him as a former professional golfer and all that. I won't ruin the show and stuff, but it's a very nice calming, little bit fun type of show.

**中文翻译:**
虽然不是新剧，但我刚重温了《硅谷》（Silicon Valley），我已经看了好几遍了。看这部剧很痛苦，因为前几季里我第一家初创公司几乎经历过每一个瞬间：比如雇佣一个白发苍苍的 CEO、融资在最后一秒告吹，以及所有那些疯狂的事。但回头再看，我发现他们写得非常好，有很多额外的细节。我最近一直在看这个。
(01:22:16):
另一部我看的剧纯粹是为了娱乐和放松，不用动脑子，是 Owen Wilson 在 Apple TV 上的新剧《Stick》，讲的是他作为一个前职业高尔夫球手的故事。我不会剧透，但那是一部非常舒缓、有点意思的剧。

---

### [01:22:40] Lenny Rachitsky

**English:**
I've been seeing that on my Apple TV. Maybe I should check it out. Good tip. Do you have a favorite product you've recently discovered that you really love? It could be a gadget, it could be a app on your phone, it could be something in your computer. It could be nothing at all.

**中文翻译:**
我也在 Apple TV 上看到了，也许我该看看。好建议。你最近有没有发现什么特别喜欢的产品？可以是一个小工具、手机应用、电脑软件，或者什么都没有。

---

### [01:22:54] Brian Balfour

**English:**
You can't see it, but I just changed my whole setup. Now I have a UltraGear super-wide curved screen with a very nice standing desk from, I believe it's called Ergonofis. Er.

**中文翻译:**
你看不见，但我刚换了整套办公设备。现在我有一个 UltraGear 超宽曲面屏，还有一个非常棒的升降桌，我想品牌叫 Ergonofis。

---

### [01:23:13] Lenny Rachitsky

**English:**
Ergonofis?

**中文翻译:**
Ergonofis?

---

### [01:23:15] Brian Balfour

**English:**
Yes. I think it's Ergonofis, E-R-G-O-N-O-F-I-S.

**中文翻译:**
是的，我想是 Ergonofis，拼写是 E-R-G-O-N-O-F-I-S。

---

### [01:23:21] Lenny Rachitsky

**English:**
All right.

**中文翻译:**
好的。

---

### [01:23:21] Brian Balfour

**English:**
It's a very nice, sleek standing desk. Very stable, very quiet. Very much enjoy.

**中文翻译:**
这是一个非常漂亮、时尚的升降桌。非常稳，非常安静。我很喜欢。

---

### [01:23:29] Lenny Rachitsky

**English:**
Excellent tip. And the curved monitor, very cool. Okay, two more questions. Do you have a life motto that you often come back to and find useful in work or in life, something you share with folks, something that you think about when times are hard or just generally?

**中文翻译:**
很棒的建议。曲面显示器也很酷。好了，最后两个问题。你有没有什么人生格言是经常回想起来，并觉得在工作或生活中很有用的？或者是你经常分享给别人的，在困难时期或平时会想到的？

---

### [01:23:42] Brian Balfour

**English:**
Look, it's a little cliche at this point, but it's somewhere around here, I used to have the quote printed out about the man in the arena. Especially in times like this where so many things are changing and there's so much competition, but so much opportunity for great, I really both respect and enjoy the game and spending time with folks that are in the arena figuring this stuff out, tinkering with things. That's what I keep coming back to, especially been at Reforge for 10 years, that's a good portion of my life, and we've gone through some great periods and some tough periods, so I tend to come back to that.

**中文翻译:**
听着，这现在可能有点陈词滥调了，但我以前把那段关于“竞技场中的人”（The Man in the Arena）的名言印出来贴在附近。特别是在现在这种万物剧变、竞争激烈但又充满伟大机遇的时代，我真的很尊重并享受这场游戏，喜欢和那些在竞技场中摸索、折腾的人待在一起。这是我经常回想的，特别是在 Reforge 待了 10 年，那是我人生中很大一部分，我们经历过辉煌也经历过艰难，所以我倾向于回归那句话。

---

### [01:24:30] Lenny Rachitsky

**English:**
And that's what always separated Reforge from so much other content and advice is it's people in the arena sharing their wisdom, not just a bunch of influencers. It's sad that Chamath made that quote so cringey.

**中文翻译:**
这就是 Reforge 始终区别于其他内容和建议的地方：它是竞技场中的人在分享智慧，而不仅仅是一群网红。可惜 Chamath 把那段话搞得有点让人尴尬（Cringey）。

---

### [01:24:41] Brian Balfour

**English:**
I know, I know. That's why I said it's a little cliche cringe right now.

**中文翻译:**
我知道，我知道。所以我才说现在听起来有点陈词滥调且尴尬。

---

### [01:24:47] Lenny Rachitsky

**English:**
Screwed it up for everyone.

**中文翻译:**
他把这句名言给毁了。

---

### [01:24:49] Brian Balfour

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:24:49] Lenny Rachitsky

**English:**
Final question. Brian, you don't know this, but your parenting advice on Adam Fishman's podcast-

**中文翻译:**
最后一个问题。Brian，你可能不知道，你在 Adam Fishman 播客上给出的育儿建议——

---

### [01:24:54] Brian Balfour

**English:**
Oh.

**中文翻译:**
噢。

---

### [01:24:55] Lenny Rachitsky

**English:**
... really impacted my parenting philosophy, specifically this line you had about independence.

**中文翻译:**
……真的影响了我的育儿哲学，特别是你关于“独立”的那段话。

---

### [01:25:01] Brian Balfour

**English:**
Oh, yes.

**中文翻译:**
噢，是的。

---

### [01:25:02] Lenny Rachitsky

**English:**
I'd love for you to just share that insight about how you think about raising kids,

**中文翻译:**
我很想让你分享一下关于你如何看待抚养孩子的见解。

---

### [01:25:08] Brian Balfour

**English:**
I wish I could remember where I grabbed this from so I could attribute it properly, but basically, the philosophy is, if you think about going from when they're born until they're essentially 18 and leave the home, your job as a parent is to essentially make them more and more independent. What that involves is continuously looking for opportunities for them to make even bigger and riskier decisions for themselves as they grow up and you're there as a support to those decisions, but letting them make those decisions on their own so that by the time they're 18, they are a fully independent person able to think through those decisions themselves.
(01:26:03):
Now, look, my sons are young. They're five and three, so it's not like I'm having them make life and death decisions or where we might buy our next house or stuff like that, but it's even small things at this age of... My oldest, five and a half, is really starting to learn and get curious about money and how you spend money and where new things come from and how you earn money. Rather than just buying things for him, he's got money from his grandparents and stuff saved up, and we can be like, "Okay, you can buy that thing, but you're going to spend this," and try to teach him the consequences and all that kind of stuff, and then when he breaks something...
(01:26:50):
It's just small things like that, but thinking about the time from zero to 18 as this spectrum of independence and being a supporting role in what you're essentially doing is you're trying to move as many decisions, the percentage of decisions you make for them down to zero by the time that they're 18. That's something that I've kept in the back of my head since really seeing that.

**中文翻译:**
我希望我能记得我是从哪儿看到这段话的，这样我好注明出处。但基本上，这个哲学是：如果你思考从孩子出生到他们 18 岁离开家这段时间，你作为父母的工作本质上是让他们变得越来越独立。这包括随着他们的成长，不断寻找机会让他们自己去做更大、更有风险的决定，而你作为这些决定的支持者存在，但要让他们自己做决定。这样到他们 18 岁时，他们就是一个完全独立的人，能够自己思考这些决定。
(01:26:03):
现在，我的儿子们还小，一个五岁一个三岁，所以我不是让他们做生死攸关的决定，或者决定下一套房子买哪儿。但在他们这个年纪，也有一些小事。我五岁半的大儿子开始对钱感到好奇，好奇钱是怎么花的、东西是从哪儿来的、钱是怎么赚的。与其直接给他买东西，他有从祖父母那儿攒下的钱，我们可以说：“好，你可以买那个东西，但你要花掉这么多钱”，并试着教他后果之类的，还有当他弄坏东西时……
(01:26:50):
就是这些小事。但把 0 到 18 岁看作一个“独立光谱”，而你扮演支持角色，你本质上是在努力将你替他们做决定的比例在 18 岁时降到零。自从看到那个观点后，我就一直把它记在心里。

---

### [01:27:19] Lenny Rachitsky

**English:**
Thank you for sharing that. I know I didn't tell you that I was going to ask you about this, so that was a beautiful way of summarizing it.

**中文翻译:**
谢谢你的分享。我知道我没提前告诉你我会问这个，所以这是一个非常优美的总结。

---

### [01:27:25] Brian Balfour

**English:**
Yeah, I couldn't remember that whole podcast. I had no idea what I said, but-

**中文翻译:**
是啊，我不记得那整集播客了，我完全不知道我当时说了什么，但是——

---

### [01:27:25] Lenny Rachitsky

**English:**
I would say you nailed it.

**中文翻译:**
我想说你总结得很到位。

---

### [01:27:28] Brian Balfour

**English:**
... that's a good one, yeah.

**中文翻译:**
……那确实是个好观点，是的。

---

### [01:27:31] Lenny Rachitsky

**English:**
Brian, two final questions. Where can folks find you if they want to reach out and where can they find the products you guys offer? Whatever you want to plug. Also, how can listeners be useful to you?

**中文翻译:**
Brian，最后两个问题。如果大家想联系你，可以在哪里找到你？在哪里可以找到你们提供的产品？你想宣传什么都可以。另外，听众可以如何帮到你？

---

### [01:27:41] Brian Balfour

**English:**
Check out reforge.com. Check out our new products like Reforge Insights. They're on the website. You can find me personally, my writing, including a bunch of the stuff that we talked about today now on Substack. Just recently moved. You can either go to my website, brianbalfour.com, where I have some info or just the blog.brianbalfour.com where all of my new writing is taking place. Those are the two major pieces.
(01:28:08):
Last but not least is that, as I mentioned, Fareed Mosavat, who I used to work with at Slack, we have this fun podcast. The two of us get on there and riff like we were having dinner every couple of weeks about different product and strategy types of things. It's a fun format for us, so if that's something you enjoy, it's called Unsolicited Feedback, where we give feedback and advice to nobody that ever asked for it.

**中文翻译:**
请访问 reforge.com。查看我们的新产品，比如 Reforge Insights，都在网站上。你可以在 Substack 上找到我个人和我的文章，包括我们今天谈到的大部分内容。我刚搬到那里。你可以去我的网站 brianbalfour.com 获取信息，或者直接去 blog.brianbalfour.com，我所有的新文章都在那里。这是两个主要渠道。
(01:28:08):
最后但同样重要的是，正如我提到的，我和曾在 Slack 共事的 Fareed Mosavat 办了一个有趣的播客。我们每隔几周就会聚在一起，像吃晚饭一样即兴讨论不同的产品和策略问题。这对我们来说是一个很有趣的形式，如果你喜欢这种风格，它叫《不请自来的反馈》（Unsolicited Feedback），我们在里面向那些从未要求过反馈的人提供反馈和建议。

---

### [01:28:36] Lenny Rachitsky

**English:**
That's amazing. Perfect title. Brian, thank you so much for being here.

**中文翻译:**
太棒了，完美的标题。Brian，非常感谢你能来。

---

### [01:28:36] Brian Balfour

**English:**
Yeah, thanks for having me again. This is great.

**中文翻译:**
好的，再次感谢邀请。这次聊得很开心。

---

### [01:28:43] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。