# Brian Chesky - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Brian Chesky, CEO of Airbnb.

---

### [00:00:00] Brian Chesky

**English:**
Way too many founders apologize for how they want to run the company. They find some midpoint between how they want to run a company and how the people they lead want to run the company. That's a good way to make everyone miserable. Because what everyone really wants is clarity. And what everyone really wants is to be able to row in the same direction really quickly. And so I basically got involved in every single detail and I basically told leaders that leaders are in the details. And there's this negative term called micromanagement. I think there's a difference between micromanagement, which is like telling people exactly what to do, and being in the details. Being in the details is what every responsible company's board does to the CEO. That doesn't mean the board is telling them what to do. But if you don't know the details, how do you know people are doing a good job? People think that great leader's job is to hire people and just empower them to do a good job. Well, how do you know they're doing a good job if you're not in the details? And so I made sure I was in the details and we really drove the product.

**中文翻译:**
有太多的创始人会为自己管理公司的方式感到抱歉。他们在自己想如何管理公司和下属想如何管理公司之间寻找某种折中点。这是让每个人都感到痛苦的好方法。因为大家真正想要的是清晰度。大家真正想要的是能够快速地朝同一个方向划船。所以我基本上参与到了每一个细节中，我告诉领导者们：领导者就应该关注细节。有一个负面词汇叫“微观管理”（micromanagement）。我认为微观管理（即告诉别人具体该怎么做）与“关注细节”之间是有区别的。关注细节是每个负责任的公司董事会对 CEO 所做的事情。这并不意味着董事会在告诉 CEO 该做什么。但如果你不了解细节，你怎么知道员工做得好不好？人们认为伟大领导者的工作就是雇人，然后授权他们去做好工作。好吧，如果你不了解细节，你怎么知道他们做得好不好？因此，我确保自己深入细节，我们真正推动了产品的进步。

---

### [00:01:01] Lenny

**English:**
Today my guest is Brian Chesky. Brian is the CEO and co-founder of Airbnb, which he started in his apartment with his co-founders, Joe and Nate, and has turned into an $80 billion global business with travelers and homes in 220 countries. I was very lucky to get to work with Brian for many years, and my sense is if you ask people who they consider the most inspiring tech or business leaders today, Brian would be right near the top of that list.
(00:01:27):
In our conversation, Brian shares an in-depth explanation of what's happening with product management at Airbnb, which caused quite a stir in the product world when he talked about this previously. We also get deep into Brian's new approach of how he runs Airbnb, including shifting away from traditional growth channels like paid growth, and instead betting that if they just build the best possible product and tell people about it, growth will happen. Also, how the product team now operates including having just one single roadmap across the entire company and Brian staying very close to every design and every feature. We also get a bit into his personal life, including how he finds balance and avoids burnout, how he continues to learn himself so that he can stay ahead of the business and its growth. This is a very special episode for me and I'm thrilled to bring you Brian Chesky after a short word from our sponsors.

**中文翻译:**
今天的嘉宾是 Brian Chesky。Brian 是 Airbnb 的首席执行官兼联合创始人。他最初和联合创始人 Joe 以及 Nate 在自己的公寓里创办了这家公司，如今它已发展成为一家价值 800 亿美元的全球业务，足迹遍布 220 个国家。我很幸运能与 Brian 共事多年，我的感觉是，如果你问人们谁是当今最鼓舞人心的科技或商业领袖，Brian 一定名列前茅。
(00:01:27):
在我们的对话中，Brian 深入解释了 Airbnb 产品管理（Product Management）的现状，他之前谈到这个话题时在产品界引起了不小的轰动。我们还深入探讨了 Brian 管理 Airbnb 的新方法，包括摆脱付费增长等传统增长渠道，转而押注于：只要打造出最好的产品并告知大众，增长就会自然发生。此外，我们还聊到了产品团队现在的运作方式，包括全公司共用一份路线图（Roadmap），以及 Brian 亲自把关每一个设计和功能。我们还谈到了他的个人生活，包括他如何寻找平衡、避免职业倦怠，以及他如何持续学习以保持领先于业务增长。这对我来说是非常特别的一集，在赞助商的简短广告后，我很高兴为您带来 Brian Chesky。

---

### [00:02:17] Lenny (Sponsor: Sidebar)

**English:**
This episode is brought to you by Sidebar. Are you looking to land your next big career move or start your own thing? One of the most effective ways to create a big leap in your career and something that worked really well for me a few years ago is to create a personal board of directors. A trusted peer group where you can discuss challenges you're having, get career advice, and just gut check how you're thinking about your work, your career, and your life. This has been a big trajectory changer for me, but it's hard to build this trusted group. With Sidebar, senior leaders are matched with highly vetted, private, supportive peer groups to lean on for unbiased opinions, diverse perspectives, and raw feedback. Everyone has their own zone of genius, so together we're better prepared to navigate professional pitfalls leading to more responsibility, faster promotions, and bigger impact.
(00:03:06):
Guided by world-class programming and facilitation, Sidebar enables you to get focused, tactical feedback at every step of your journey. If you're a listener of this podcast, you're likely already driven and committed to growth. A Sidebar personal board of directors is the missing piece to catalyze that journey. Why spend a decade finding your people when you can meet them at Sidebar today. Jump the growing wait list of thousands of leaders from top tech companies by visiting sidebar.com/lenny to learn more. That's sidebar.com/lenny.

**中文翻译:**
本集节目由 Sidebar 赞助。你是否正在寻求职业生涯的下一次重大飞跃，或者准备开始创业？提升职业生涯最有效的方法之一，也是几年前对我非常有帮助的方法，就是建立一个“个人董事会”。这是一个值得信赖的同行群体，你可以在这里讨论面临的挑战，获得职业建议，并对你关于工作、事业和生活的想法进行直觉检查。这极大地改变了我的职业轨迹，但建立这样一个互信群体很难。通过 Sidebar，资深领导者可以与经过严格审核、私密且相互支持的同行群体匹配，从而获得公正的意见、多元的视角和原始的反馈。每个人都有自己的天才领域，因此大家在一起能更好地应对职业陷阱，从而承担更多责任、获得更快晋升并产生更大影响。
(00:03:06):
在世界级项目和引导的指导下，Sidebar 让你在旅程的每一步都能获得专注且具战术性的反馈。如果你是本播客的听众，你可能已经非常有动力并致力于成长。Sidebar 的个人董事会就是催化这一旅程的最后一块拼图。为什么要花十年时间去寻找志同道合的人，而今天就可以在 Sidebar 遇到他们呢？访问 sidebar.com/lenny 了解更多信息，跳过数千名来自顶尖科技公司领导者的等待名单。地址是 sidebar.com/lenny。

---

### [00:03:38] Lenny (Sponsor: Jira Product Discovery)

**English:**
You fell in love with building products for a reason, but sometimes the day-to-day reality is a little different than you imagined. Instead of dreaming up big ideas, talking to customers and crafting a strategy, you're drowning in spreadsheets and roadmap updates and you're spending your days basically putting out fires. A better way is possible. Introducing Jira Product Discovery, the new prioritization and roadmapping tool built for product teams by Atlassian.
(00:04:04):
With Jira Product Discovery, you can gather all your product ideas and insights in one place and prioritize confidently finally, replacing those endless spreadsheets. Create and share custom product roadmaps with any stakeholder in seconds and it's all built on Jira where your engineering team's already working so true collaboration is finally possible. Great products are built by great teams, not just engineers. Sales, support, leadership, even Greg from finance. Anyone that you want can contribute ideas, feedback, and insights in Jira Product Discovery for free. No catch. And it's only $10 a month for you. Say goodbye to your spreadsheets and the never ending alignment efforts. The old way of doing product management is over. Rediscover what's possible with Jira Product Discovery. Try for free at atlassian.com/lenny. That's atlassian.com/lenny.

**中文翻译:**
你爱上打造产品是有原因的，但有时日常现实与你的想象大相径庭。你没有在构思伟大的创意、与客户交谈和制定战略，而是淹没在电子表格和路线图更新中，整天忙于“救火”。其实有更好的方法。向您介绍 Jira Product Discovery，这是由 Atlassian 为产品团队打造的全新优先级排序和路线图工具。
(00:04:04):
通过 Jira Product Discovery，你可以将所有的产品创意和洞察集中在一处，并自信地进行优先级排序，最终取代那些没完没了的电子表格。在几秒钟内创建并与任何利益相关者分享自定义产品路线图，而且它完全构建在你的工程团队已经在使用的 Jira 之上，因此真正的协作终于成为可能。伟大的产品是由伟大的团队打造的，而不仅仅是工程师。销售、支持、领导层，甚至是财务部的 Greg，你想要的任何人都可以免费在 Jira Product Discovery 中贡献创意、反馈和洞察。没有陷阱。对你来说每月只需 10 美元。告别你的电子表格和永无止境的对齐工作。旧的产品管理方式已经结束。通过 Jira Product Discovery 重新发现可能性。在 atlassian.com/lenny 免费试用。

---

### [00:05:00] Lenny

**English:**
Brian, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Brian，非常感谢你能来。欢迎来到本播客。

---

### [00:05:04] Brian Chesky

**English:**
Well, thank you for having me.

**中文翻译:**
好的，谢谢你邀请我。

---

### [00:05:06] Lenny

**English:**
Did you ever think when I left Airbnb, one, that I would have a podcast and two, that you would be on my podcast?

**中文翻译:**
当我离开 Airbnb 时，你有没有想过：第一，我会办一个播客；第二，你会出现在我的播客上？

---

### [00:05:12] Brian Chesky

**English:**
I had no idea you would become a podcast host and that you would have such a successful podcast. But yeah, congrats on everything. This is awesome.

**中文翻译:**
我完全没想到你会成为一名播客主持人，而且办得这么成功。但是，是的，祝贺你所取得的一切。这太棒了。

---

### [00:05:18] Lenny

**English:**
I appreciate it. Congrats to you too, Brian. Things seem to be going great. I'm excited that you're here. I want to start with the elephant in the room for a lot of listeners of this podcast. What is going on with product management at Airbnb? You made some comments at Figma Config and a lot of people got this impression that you eliminated product management at Airbnb, and I've heard from a lot of product execs having boardroom conversations as a result of that. And they were trying to decide should we remove product management from the company? Should we significantly cut product management? So I'm just curious to hear from you, what is the latest on your thinking on product management and what's happening with product management at Airbnb?

**中文翻译:**
谢谢。也祝贺你，Brian。一切看起来都很顺利。很高兴你能来。我想从本播客许多听众都关心的“显而易见却被避而不谈的问题”（elephant in the room）开始。Airbnb 的产品管理到底发生了什么？你在 Figma Config 大会上发表了一些言论，让很多人觉得你取消了 Airbnb 的产品管理职能。我听说很多产品高管因此在董事会上展开了讨论。他们试图决定：我们是否应该从公司中移除产品管理？我们是否应该大幅削减产品管理？所以我很好奇想听听你最新的想法，Airbnb 的产品管理现状究竟如何？

---

### [00:05:56] Brian Chesky

**English:**
I spoke at Figma four or five months ago. I spoke to a room of designers. I then got off-stage. I saw somebody tweet that said something to the nature of that I said I got rid of the product management function and all the designers in the room started cheering. So I want to talk about two things. What I actually meant, because I didn't actually get rid of the people. And also why did the people in the room cheer? Because that's also a thing we should ask ourselves. And I hope everyone listening to this podcast should understand where did that place come from, that 5,000 designers in a room cheered because they thought I eliminated the existence of a function? Because if I said I eliminated the engineering function, no one would've cheered. It was specifically that function. So I want to talk about what that might mean. It wasn't the people, it's the way they're working together.

**中文翻译:**
四五个月前我在 Figma 大会上演讲。台下坐满了设计师。我下台后看到有人发推特，大意是说我说我取消了产品管理职能，全场的设计师都开始欢呼。所以我想谈两件事。第一，我真正的意思是什么，因为我并没有真的裁掉这些人。第二，为什么房间里的人会欢呼？因为这也是我们应该反思的问题。我希望听这个播客的每个人都能理解，为什么 5000 名设计师会因为认为我取消了一个职能而欢呼？因为如果我说我取消了工程职能，没人会欢呼。唯独是这个职能。所以我想谈谈这可能意味着什么。问题不在于人，而在于他们合作的方式。

---

### [00:06:46] Brian Chesky

**English:**
So we don't have any longer the traditional product management function as it existed when you was here. But we didn't get rid of people helping drive the product. What we did is we combined what one might call the inbound product development responsibilities of product manager with the outbound or marketing responsibilities of product marketing. That's the first thing we did. The second thing we did is we off boarded much of the program management functions that product managers may do to actual program managers. A lot of people with the product management title are actually program managers. So we actually started off boarding some responsibilities to program management. The last thing we did is we made the group smaller and more senior. So we don't really have a lot of junior product marketers. So the most senior people are called product marketers, but everyone has to understand how to talk about the product.
(00:07:42):
So the basic idea is this. You can't build a product unless you know how to talk about the product. You can't be an expert in making the product unless you're also an expert in the market of it. And a lot of companies, what they do is they ship a product, it doesn't work, and they say, "We tried that. It didn't work." And if you say you tried and it didn't work, my question is, was it a bad product, a bad strategy or bad execution? Maybe it was a really well-made product, but you had no distribution plan. You had no way to talk about the product. If you build a great product and no one knows about it, did you even build a product? So that is essentially what we do. We have a much smaller function. The people are much more senior. They have much more responsibility. The other thing though is that they do not control or drive designing or engineering. We are a fairly purely functional model. They manage by influence. They do not have control.

**中文翻译:**
所以，我们不再拥有你在这里时那种传统的产品管理职能。但我们并没有裁掉推动产品的人。我们所做的是将产品经理所谓的“对内”（inbound）产品开发职责与产品市场（Product Marketing）的“对外”（outbound）或营销职责结合在了一起。这是我们做的第一件事。第二件事是，我们将产品经理可能承担的大部分项目管理（Program Management）职能移交给了真正的项目经理。很多挂着产品经理头衔的人实际上是项目经理。所以我们开始将这些职责剥离给项目管理。最后，我们缩小了团队规模，并提高了资历要求。所以我们没有很多初级的产品市场人员。最资深的人被称为产品市场经理（Product Marketers），但每个人都必须懂得如何谈论产品。
(00:07:42):
基本理念是：除非你知道如何谈论产品，否则你无法构建产品。除非你也是该市场的专家，否则你无法成为制造产品的专家。很多公司做的是：发布一个产品，没效果，然后说“我们试过了，没用”。如果你说试过了没用，我的问题是：是产品不好、策略不对，还是执行不力？也许产品做得很好，但你没有分发计划，没有谈论产品的方法。如果你做了一个伟大的产品却没人知道，那你算做了产品吗？所以这本质上就是我们所做的。我们的职能部门小得多，人员资历深得多，责任也大得多。但另一件事是，他们不控制或驱动设计或工程。我们是一个相当纯粹的职能模型（Functional Model）。他们通过影响力进行管理，没有控制权。

---

### [00:08:31] Brian Chesky

**English:**
Now you might ask, how does that work in a company where people can only manage by influence? Here's the amazing thing. We built and designed a company where you can manage by influence and no one has to like you. You don't actually have to win people over. Oh, and the last thing I want to say is, why did 5,000 designers cheer when the people thought I removed the product management function? Because I want to say ... I don't know if I can speak on behalf of all the designers, but having talked to a lot of designers, I think designers in the valley are very, very frustrated with the product development process. Not to say the product managers, but they're extremely frustrated.

**中文翻译:**
现在你可能会问，在一个只能靠影响力管理的公司里，这怎么运作？神奇的地方在于：我们建立并设计了一家公司，在这里你可以通过影响力进行管理，而且不需要每个人都喜欢你。你实际上不需要去刻意争取人心。哦，最后我想说的是，为什么当人们以为我取消了产品管理职能时，5000 名设计师会欢呼？因为我想说……我不知道我是否能代表所有设计师，但在与许多设计师交流后，我认为硅谷的设计师对产品开发流程感到非常、非常沮丧。不是针对产品经理个人，而是对流程感到极度沮丧。

---

### [00:09:09] Brian Chesky

**English:**
I think a lot of designers feel like they're compromising. Many designers I know ... Heads of design. Well-known heads of design. I told them they're not designers, they're design administrators. They're running a design service organization. Because Silicon Valley often treats design as a service organization. Like design is catching things before it goes out the door. It's not actually typically part of the development process. And I think this is not just bad for design, it's bad for product managers and engineers because we all want to build the best products. And one day you wake up and a variety of phenomenon might have happened. And if people are watching this from a large company, here might be some of the characteristics.

**中文翻译:**
我觉得很多设计师觉得自己一直在妥协。我认识的很多设计师……设计负责人，知名的设计负责人。我告诉他们，他们不是设计师，而是设计管理员。他们经营着一个设计服务机构。因为硅谷通常把设计看作一个服务部门。就像设计只是在产品出门前做最后的把关。它通常不是开发过程的一部分。我认为这不仅对设计不利，对产品经理和工程师也不利，因为我们都想打造最好的产品。有一天你醒来，可能会发现各种现象已经发生了。如果有人在大型公司看这个，以下可能就是一些特征。

---

### [00:09:43] Brian Chesky

**English:**
The first thing you notice is that these different groups might be running on slightly different technical stacks. That's the first problem. And they may actually be accumulating technical debt. The next problem you'll see is that there's a lot of dependencies. So five teams are going different directions, but they all need a payment platform. And so what happens is that the teams that everyone's dependent on get this backup like a deli and people are going around the block. And then at some point they just give up. So then the teams that are dependent on other people say, "Give me the resources and I'll build this group myself." So instead of five teams going to marketing to get a campaign or to leverage some service, they start building their own marketing departments, their own groups. So now they're really becoming separate divisions. And this is where a division comes from.

**中文翻译:**
你注意到的第一件事是，这些不同的团队可能运行在略有不同的技术栈上。这是第一个问题。他们实际上可能在积累技术债。你看到的下一个问题是存在大量的依赖关系。比如五个团队朝不同方向发展，但他们都需要支付平台。结果就是，每个人都依赖的那个团队就像熟食店排长队一样积压，人们只能绕道而行。然后到某个点，他们就放弃了。于是那些依赖别人的团队说：“给我资源，我自己建这个组。”所以，不再是五个团队去找营销部做活动或利用某种服务，而是他们开始建立自己的营销部门、自己的小组。现在他们真的变成了独立的部门（Divisions）。这就是“事业部制”的由来。

---

### [00:10:34] Brian Chesky

**English:**
Now, once you have a division, your division is as successful as you are a priority. So now you have to advocate for your division. So there's a lot of advocacy. If you have dependencies, you've got to persuade people by building relationships. And so the people that are liked that build the best relationships are the ones that get the most resources and that creates what we call politics. And so now politics that brood in the company. And suddenly people gets more subdivided, more subdivided, subdivided. And that creates another problem, which we call bureaucracy. And that bureaucracy means it's hard to know who's doing what. People are going in different directions and that creates a lack of accountability. When there's lack of accountability, then there's a sense that what I do doesn't matter and that creates complacency. And then suddenly a fast-growing company becomes a big slow moving bureaucracy. This is a general arc that winds up happening.

**中文翻译:**
一旦你有了事业部，你的事业部是否成功取决于你的优先级有多高。所以现在你必须为你的事业部争取利益。于是出现了很多“游说”工作。如果你有依赖关系，你就必须通过建立关系来游说别人。于是，那些受人喜欢、能建立最好关系的人就能获得最多的资源，这就产生了我们所说的“政治”。现在政治在公司内部滋生。突然间，人员被进一步细分、再细分。这又产生了另一个问题，我们称之为“官僚主义”。官僚主义意味着很难知道谁在做什么。人们朝不同的方向走，导致缺乏问责制。当缺乏问责制时，就会产生一种“我做的事不重要”的感觉，从而导致自满。然后，一家快速增长的公司突然变成了一个庞大、缓慢移动的官僚机构。这就是通常会发生的演变过程。

---

### [00:11:30] Brian Chesky

**English:**
And then you end up having this situation where a company's done 10 marketing efforts, but no customer's heard anything. They have thousands of engineers, they shipped all these products, but a customer can't tell you a single thing you did. Marketing and engineering don't talk to each other. It's not even they hate each other, they're in different universes. I've always said that the health of an organization, one simple heuristic is how close is engineering and marketing? And marketing is at lot of companies are like the waiters, engineers are like the chefs and the chefs yell at the waiters and they go in the kitchen. In fact, the waiters are the ones talking to the customers all day and they also know how to sell things so you really want them being enjoined at the hip and you want engineers to be thinking about maybe how to talk about the products that they're building.

**中文翻译:**
最后你会遇到这种情况：公司做了 10 次营销努力，但没有客户听说过任何消息。他们有成千上万名工程师，发布了所有这些产品，但客户却说不出你做过的一件事。营销和工程部门互不交流。甚至不是他们互相讨厌，而是他们处于不同的宇宙。我一直说，衡量一个组织健康状况的一个简单启发式方法是：工程和营销的距离有多近？在很多公司，营销人员就像服务员，工程师就像厨师，厨师对服务员大吼大叫，然后钻进厨房。事实上，服务员才是整天和客户交谈的人，他们也知道如何推销东西，所以你真的希望他们紧密结合，你希望工程师也能思考如何谈论他们正在构建的产品。

---

### [00:12:17] Brian Chesky

**English:**
So this is the problem that we had. And also the other thing we were doing is, as you know Lenny, we were spending a lot of money in performance marketing. I don't think performance marketing is a bad thing. I think of performance marketing as a laser. Actually my co-founder who obviously you know well, Joe, used to have this metaphor of lasers, flash bulbs and chandeliers. If you want to light up a room, performance marking is a laser. It can light up a corner of a room. You don't want to use a bunch of lasers to light up an entire room. You should use a chandelier and that's what brand marketing is. But if you do need to laser in and balance supply and demand, then performance marketing is really good. It literally lasers in. Performance marketing though doesn't create very good accumulating advantages because it's not an investment. Now if you want to build it permanently, like booking.com, if you have a really high ROI, now you can have a performance marketing arbitrage business. But assuming you don't want an arbitrage business, you actually need to be investing. And so we think of marketing as education. That we're educating people on the unique benefits.

**中文翻译:**
这就是我们当时面临的问题。另外一件事是，正如你所知，Lenny，我们当时在效果营销（Performance Marketing）上投入了大量资金。我不认为效果营销是件坏事。我把效果营销看作是激光。实际上，我的联合创始人 Joe（你显然很熟悉他）曾用激光、闪光灯和吊灯做比喻。如果你想照亮一个房间，效果营销就是激光。它可以照亮房间的一个角落。你不想用一堆激光来照亮整个房间。你应该用吊灯，那就是品牌营销（Brand Marketing）。但如果你确实需要精准定位并平衡供需，那么效果营销就非常好。它确实能像激光一样精准。然而，效果营销不会产生很好的累积优势，因为它不是一种投资。如果你想永久地建立它，像 booking.com 那样，如果你有极高的投资回报率（ROI），你就可以做一个效果营销套利业务。但假设你不想做套利业务，你实际上需要进行投资。因此，我们将营销视为“教育”，即教育人们了解产品的独特优势。

---

### [00:13:23] Brian Chesky

**English:**
So a lot of companies don't do product marketing. They do brand marketing, which are ads about the app or they do performance marketing, but they're never really educating people about new things they're making and shipping. And because no one's marketing new things they're shipping, there's no purpose to ship new things. Because you ship new things and people don't know about them or use them or they're not educated. And so you try these big new things, people don't adopt them immediately, so then you get more and more incremental. Now what we do is we have a rolling two year roadmap. We don't even really do an annual plan. As you remember, Lenny, when you were at Airbnb, we would have three month planning cycles. Now planning cycle is just a budgeting cycle and most people only spend a week or two on it. Some don't spend any time on it. And we have a rolling two year product plan. Strategy. Product strategy roadmap that gets updated every six months with releases. We release products every May and every November or October. Obviously we did one today we can talk about.

**中文翻译:**
所以很多公司不做产品市场（Product Marketing）。他们做品牌营销（关于 App 的广告）或者做效果营销，但他们从未真正教育人们了解他们正在制造和发布的新事物。因为没有人为发布的新事物做营销，所以发布新事物就失去了意义。因为你发布了新东西，人们却不知道、不用，或者没有被告知。于是你尝试这些重大的新事物，人们没有立即采用，于是你就变得越来越趋向于“渐进式改进”。现在我们做的是一个滚动的两年期路线图。我们甚至不怎么做年度计划。Lenny，你记得你在 Airbnb 时，我们有三个月的计划周期。现在的计划周期只是一个预算周期，大多数人只花一两周时间在上面，有些人甚至不花时间。我们有一个滚动的两年产品计划、战略和产品战略路线图，每六个月随发布会更新一次。我们每年 5 月和 11 月或 10 月发布产品。显然，我们今天就发布了一个，待会儿可以聊聊。

---

### [00:14:26] Brian Chesky

**English:**
The entire company works together. They row in the same direction. And the product management also does the product marketing. So they're figuring out how people are going to learn about it, they're doing the demos, they're understanding the story, the videos, they're figuring out all the customer touchpoints, making sure everyone understands it. Our product marketing works with communications. We work months ahead of time on all the different assets. And when we're working on a launch, one of the first things we'll do is start figuring out what the story is. And the story will often dictate the product. Because ultimately you have to tell the story to people. But a story also is a really helpful way to develop a cohesive product. We wanted a company where a thousand people could work, but it'll look like 10 people did it. Sorry, that was a bit of a brain dump, but that is a little bit of a universal theory for how we develop products now. And I could go into a lot more detail, but I probably will stop there.

**中文翻译:**
整个公司协同工作。他们朝同一个方向划船。产品管理同时也负责产品市场。所以他们在思考人们将如何了解产品，他们在做演示，他们在理解故事、制作视频，他们在梳理所有的客户接触点，确保每个人都能理解。我们的产品市场团队与公关团队合作。我们会提前几个月准备所有的素材。当我们准备发布会时，我们要做的第一件事就是确定故事是什么。故事往往会决定产品。因为最终你必须向人们讲述这个故事。但故事也是开发具有凝聚力产品的非常有用的方式。我们想要一家有一千人工作，但看起来像只有十个人做出来的公司。抱歉，刚才说得有点多，但这基本上就是我们现在开发产品的通用理论。我可以讲得更详细，但我想先停在这里。

---

### [00:15:24] Lenny

**English:**
That was amazing. You touched on all of the things I want to talk about. So I'm going to-

**中文翻译:**
太棒了。你触及了所有我想谈论的话题。所以我要——

---

### [00:15:27] Brian Chesky

**English:**
Oh, gee. So we can go deeper and deeper because the rabbit hole goes deep.

**中文翻译:**
噢，天哪。所以我们可以越挖越深，因为这个话题深不见底。

---

### [00:15:31] Lenny

**English:**
Yeah, exactly. Exactly. So I'm going to pull on a couple threads. The first is this idea of a single roadmap you talked about. And what this reminds me of is I was talking to another very prominent CEO of a public company and he pointed out that there's this cycle that he sees a lot of founders go through where they initially run the show, they're in charge, they tell people what to build, and then over time they're encouraged to delegate and to empower and it leads to a bunch of optimization work and small thinking maybe. And you talked about bureaucracy and politics. And then eventually you realize I need to take the reins again and drive the ship and take back control of what's happening. And it feels like you went on that journey.

**中文翻译:**
是的，没错。所以我打算从几个方面入手。首先是你提到的“单一路线图”的想法。这让我想起我曾与另一位非常著名的上市公司 CEO 交谈，他指出他看到很多创始人都会经历这样一个周期：最初他们掌控全局，负责指挥，告诉大家该建什么；随着时间的推移，他们被鼓励去授权和赋能，结果导致了一堆优化工作和可能存在的狭隘思维。你提到了官僚主义和政治。最后你意识到，我需要重新掌舵，重新控制局面。感觉你也经历了这段旅程。

---

### [00:16:08] Brian Chesky

**English:**
That's exactly how it went, and that's how it goes almost at every company I've heard of. By the way, I think that many years ago, I remember I think reading a blog post by Ben Horowitz saying that a lot of people tell product led founders or engineering led founders to step away and delegate their product to other people, but suddenly they've delegated away the thing they're best at. The thing that is hardest for them to replace. So we don't have a chief product officer title, but if we had one, it would be me. I wouldn't have a chief product officer. I think the CEO should be basically the chief product officer of a product or tech company. If the CEO is not the chief product officer then I don't know if they're a product or tech led company. Maybe that's okay if they're an ops company or if they're a marketing company or if they're not a tech company at all. But ultimately I think the founder or CEO should be that person.

**中文翻译:**
确实是这样，而且我听说的几乎每家公司都是如此。顺便说一句，我记得很多年前读过 Ben Horowitz 的一篇博文，他说很多人告诉产品驱动型或工程驱动型的创始人要退后一步，把产品授权给别人，但突然之间，他们把自己最擅长、最难被取代的东西授权出去了。所以我们没有“首席产品官”（CPO）这个头衔，但如果有，那也是我。我不会设立首席产品官。我认为 CEO 基本上应该是产品或科技公司的首席产品官。如果 CEO 不是首席产品官，那么我不知道他们是否真的是一家产品或科技驱动的公司。如果他们是运营公司、营销公司或者根本不是科技公司，那也许没问题。但最终，我认为创始人或 CEO 应该是那个人。

---

### [00:16:59] Brian Chesky

**English:**
So when we were starting Airbnb, it was probably the three of us. As you know, I think Airbnb was a unique situation where it was three of us. I don't think any of us was that dominant. I probably played the closest thing to the role of the people listening, the closest thing to the role of the product manager. But again, I did marketing, I did design, I did ops, I did a little bit of everything. So I was basically everything but engineering. And then as we grew, I started getting more and more hands off in the product.
(00:17:27):
And I always remember Lenny there was this paradox where the less involved I was in a project ... Let me be clear. There were times I inserted myself and dysfunction occurred. That is absolutely true. And that was just a learning experience for me. But there was this other scenario where the less involved I was in the project, the more spin there was, the less clear the goals, the less advocacy the team had, the less resources, the fewer resources they had. And then therefore the slower they moved. And the slower they moved, the more they assumed it was because I was too involved. Because people assume that our natural equilibrium's to move fast so if we're moving slow, it's because of an over involvement in leadership and therefore I would get less involved. I would give teams more control. I would give them teams more empowerment. And the more I kept giving people what they asked for initially, they may have been happy, but the outcome of it was always, it seemed weirdly like they got less of what they wanted. They wanted to move faster so I'd empower them and move slower.

**中文翻译:**
当我们创办 Airbnb 时，大概就是我们三个人。如你所知，我认为 Airbnb 的情况很独特，是我们三个人。我不认为我们中有人占据绝对主导。我扮演的角色可能最接近听众心目中的产品经理。但同样，我也做营销、做设计、做运营，什么都做一点。所以除了工程，我基本上什么都干。随着公司的成长，我开始越来越少地插手产品。
(00:17:27):
Lenny，我一直记得有一个悖论：我参与项目越少……让我说清楚，有些时候我介入了，结果导致了功能失调，这绝对是真的，那对我来说只是学习经验。但还有另一种情况：我参与项目越少，内耗就越多，目标就越不清晰，团队获得的支持就越少，资源也越匮乏。因此，他们行动得越慢。而他们行动越慢，就越觉得是因为我参与太多了。因为人们假设我们的自然平衡状态是快速移动，所以如果我们移动缓慢，那一定是因为领导层过度参与，因此我会减少参与。我会给团队更多控制权，给他们更多赋能。我越是给人们他们最初想要的东西，他们起初可能很开心，但结果总是奇怪地发现，他们得到的反而更少。他们想跑得更快，所以我授权给他们，结果跑得更慢。

---

### [00:18:26] Brian Chesky

**English:**
And again, how that happened is what I described. That you end up in a situation where you're delegating down. So I think that things were getting worse and slower and slower and slower. 2015, 2016, 2017, 2018, 2019. And by 2019 we were spending a billion dollars on AdWords. We weren't really investing in the brand. We were doing a huge amount of AB testing. I think AB testing is important in times. Actually, let me clarify AB testing. We don't test blue versus green. We have a control and a treatment like I think we did when you were here. So we have a design. We might do a holdback occasionally to see how the thing is working. But if we do an AB test, there has to be a hypothesis. If we don't have a hypothesis and A is better than B, then we're stuck with B. And that's a really, really big problem, but we can never change it.

**中文翻译:**
再说一次，发生这种情况的原因正如我所描述的。你最终陷入了层层授权的境地。所以我认为情况变得越来越糟，越来越慢。2015、2016、2017、2018、2019 年。到 2019 年，我们在 Google 关键词广告（AdWords）上花费了 10 亿美元。我们并没有真正投资于品牌。我们做了大量的 AB 测试。我认为 AB 测试有时很重要。实际上，让我澄清一下 AB 测试。我们不测试蓝色还是绿色。我们有一个对照组和一个实验组，就像你在的时候那样。我们有一个设计，偶尔可能会做一个保留测试（holdback）来看看效果。但如果我们做 AB 测试，必须有一个假设。如果我们没有假设，而 A 比 B 好，那我们就只能用 B。这是一个非常大的问题，但我们永远无法改变它。

---

### [00:19:27] Brian Chesky

**English:**
And then imagine 10 teams doing AB testing. Imagine if you designed software the way you designed a house or design a house the way design software. And we AB test a sofa. And we said, well, how does this sofa work? And it seems like with this sofa that we've AB tested people spend more time in the living room, so therefore people are going to like this room better. But actually the sofa has a relationship to the end stands which have a relationship to the lamps which have a relationship to the carpet or the rug which have a relationship to the television which have a relationship to the house and everything else. So you have to think about the whole cohesive system. And I started realizing that. I asked one person on your team, somebody you know well, and I asked him, I said, "I feel like I open our app and the product hasn't changed and four years." I remember saying this, 2018, 2019. And this person described that you know well as just the way we were doing things. The initial way we were doing things to move fast had made us move slow.

**中文翻译:**
想象一下 10 个团队都在做 AB 测试。想象一下如果你像设计房子一样设计软件，或者像设计软件一样设计房子。我们对沙发进行 AB 测试，然后说，好吧，这个沙发效果如何？看起来用了这个测试沙发后，人们在客厅待的时间更长了，所以人们会更喜欢这个房间。但实际上，沙发与边几有关，边几与灯具有关，灯具与地毯有关，地毯与电视有关，电视又与整个房子及其他一切有关。所以你必须考虑整个内聚的系统。我开始意识到这一点。我问了你团队里的一个人（你很熟悉的人），我问他：“我觉得我打开我们的 App，产品四年都没变过。”我记得在 2018、2019 年说过这话。而这个你熟悉的人描述说，这就是我们做事的方式。最初为了快而采取的方式，反而让我们变慢了。

---

### [00:20:29] Brian Chesky

**English:**
So what we ended up doing is ... It was now late 2019. I don't know what to do. I'm like, the product is slow, the app seems to not change, costs are rising. I keep adding more people. There seems to be more politics. By politics I mean advocating for individual interests rather than the whole company. More bureaucracy meaning meetings about meetings about meetings and a lot of dependencies. People were describing working 80 hours and getting 20 hours of productive work done, which is just a crazy ratio a week. And I didn't really quite know what to do.

**中文翻译:**
所以我们最终做的是……那是 2019 年底。我不知道该怎么办。我觉得产品很慢，App 似乎没变化，成本在上升。我不断增加人手。似乎有更多的政治——我说的政治是指为了个人利益而不是整个公司去游说。更多的官僚主义，意味着为了开会而开会，还有大量的依赖关系。人们描述说每周工作 80 小时，但只有 20 小时是有产出的，这比例简直疯了。我真的不知道该怎么办。

---

### [00:21:03] Brian Chesky

**English:**
And then right before the pandemic, I meet two people that really affected how I thought about things. The first was Hiroki Asai. Hiroki now works at Airbnb. He's one of my executives and actually product design, product marketing design and marketing report into him. And he was a creative director for Apple. So he worked for Steve Jobs, was basically dotted line to Steve for many, many years. Came from graphic design. Eventually ran all of marketing communications. In Apple Marketing Communications, they actually designed the app. They made the app. They designed all the marketing touchpoints for the store. So it wasn't just ads, it was every brand touchpoint they were responsible. So everything flowed through marketing. And so marketing became the governing factor that made everything really organized.

**中文翻译:**
就在疫情爆发前，我遇到了两个真正影响我思考方式的人。第一个是 Hiroki Asai。Hiroki 现在在 Airbnb 工作，他是我的高管之一，产品设计、产品市场设计和营销都向他汇报。他曾是苹果公司的创意总监。他曾为史蒂夫·乔布斯工作，多年来基本上直接向史蒂夫汇报。他出身平面设计，最终负责所有的营销传播（Marcom）。在苹果的营销传播部门，他们实际上设计了 App，制作了 App，设计了商店的所有营销接触点。所以不仅仅是广告，他们负责每一个品牌接触点。因此，一切都流经营销部门。营销成为了让一切变得井井有条的主导因素。

---

### [00:21:52] Brian Chesky

**English:**
I met another person or got reacquainted a person named Jony Ive. And Jony Ive was the head of industrial design and Chief Design Officer at Apple. And they described this way of running a company that was totally different than the way that I was running it. It was basically the way that Steve Jobs ran Apple from about 1998 until he died in 2011. Apple somewhat runs it this way today, but the services is turning into a division and they are just so big that I think it's not a one-to-one anymore, but they are still technically run this way. And I had this image of not being divisional because we were running ... We had 10 divisions. We had a flights division and we had a homes division which was divided to pro hosts and core hosts and lux and we had business travel and we had a magazine and we had experiences and we had .org and we had China. So we had these 10 different divisions all going in 10 different directions. And I created this culture where everyone would be a business manager or business leader, general manager, which made them want to create many general managers. And so the company kept getting subdivided, subdivided, subdivided and that made it very, very difficult to turn.

**中文翻译:**
我遇到了另一个人，或者说重新结识了一个人，名叫 Jony Ive。Jony Ive 曾是苹果的工业设计主管和首席设计官。他们描述了一种与我当时管理公司完全不同的方式。这基本上是史蒂夫·乔布斯从 1998 年到 2011 年去世期间管理苹果的方式。苹果今天在某种程度上仍这样运行，但服务部门正在变成一个事业部，而且他们规模太大了，我认为不再是一对一的模式，但技术上仍是这样运行的。我当时产生了一个想法，就是不要搞事业部制，因为我们当时有 10 个事业部：机票部、房源部（又分为专业房东、核心房东和豪华房源）、商务旅行部、杂志部、体验部、公益部（.org）和中国区。这 10 个不同的部门朝 10 个不同的方向发展。我创造了一种文化，让每个人都想成为业务经理、业务领导或总经理（GM），这让他们想创造更多的总经理。于是公司不断被细分、细分、再细分，这让公司很难转型。

---

### [00:22:57] Brian Chesky

**English:**
And this was all about me delegating responsibility. The problem is if you're running a divisional company, you're a product-led founder ... What are you doing? Strategy, capital allocation. My job went from proactive to very reactive. I was reacting to a lot of things. I was in a lot of meetings. Trying to adjudicate different issues between groups. So then the pandemic occurs and I had this image on mind. It's like I have this dream that I could run a company much more like a startup. I remember going on a walk with Joe and Nate in Bolinas. It was October 2019. And I told them I had this dream that I left the company 10 years ago and they just asked me to come back. And I said, "I was horrified at what I found." And they said, "Well, what'd you find?" I said, "I found a company that on the one hand had amazing culture and people with a great mission, with a brand people really loved, but we lost our design roots. We weren't investing in the longterm. We were obsessing over hitting metrics. We didn't actually have any cohesive understanding of what we were doing. It was really hard to get work done. A lot of the great people were leaving and cost was rising and growth was slowing." And that was exactly what was happening.

**中文翻译:**
这全是因为我在授权责任。问题是，如果你经营一家事业部制公司，而你是一个产品驱动型创始人……你在做什么？战略、资本配置。我的工作从主动变成了非常被动。我在应对很多事情。我参加了很多会议。试图裁决不同小组之间的问题。然后疫情发生了，我脑海中浮现出这样一个画面：我梦想着能像初创公司一样管理公司。我记得 2019 年 10 月和 Joe 以及 Nate 在 Bolinas 散步。我告诉他们我做了一个梦，梦见我 10 年前离开了公司，他们刚请我回来。我说：“我被我发现的情况吓坏了。”他们问：“你发现了什么？”我说：“我发现这家公司一方面有着惊人的文化和带着伟大使命的人，品牌深受喜爱，但我们失去了设计的根基。我们没有投资于长期。我们痴迷于达成指标。我们实际上对自己在做什么没有统一的理解。工作很难开展。很多优秀的人正在离开，成本在上升，增长在放缓。”而这正是当时发生的事。

---

### [00:24:20] Brian Chesky

**English:**
And then the pandemic occurred and we lost 80% of our business in eight weeks. And then suddenly we're like, oh my God. I remember basically staring into the abyss. And luckily I've never had a near-death experience, but the way it's been described to me is it's like your life flashes before your eyes and you have clarity. And that's what happened to our business. We had a near-death business experience and our business flashed before our eyes. And so suddenly I basically got into action and I said, I'm going to run it this other way where I'm going to get back involved in the details. And by the way, Lenny, here's the funny thing. Before the crisis, a lot of people felt like I was too involved in different areas. Once the crisis happened, guess what happened? People were like, what do we do? We need you more involved. And so I got more involved.

**中文翻译:**
接着疫情爆发了，我们在八周内失去了 80% 的业务。突然间我们觉得，天哪。我记得当时基本上是在凝视深渊。幸运的是，我从未有过濒死体验，但别人向我描述过，那就像你的生命在眼前闪过，你突然变得清醒。我们的业务也发生了同样的事情。我们经历了一次业务上的濒死体验，我们的业务在眼前闪过。于是突然间，我开始采取行动，我说，我要用另一种方式来管理，我要重新参与到细节中。顺便说一句，Lenny，有趣的是：在危机之前，很多人觉得我在不同领域参与太多了。一旦危机发生，猜猜发生了什么？人们会说：“我们该怎么办？我们需要你更多地参与。”于是我参与得更多了。

---

### [00:25:05] Brian Chesky

**English:**
When I got involved, I made the following changes. The first thing I did is I said, everything we're doing has to be written down and put into a Google sheet. It turns out people couldn't even write down everything they were doing. I remember one person told me, "We're doing too many things for me to ever be able to document." I'm like, "What?" But anyways, we eventually got everyone to write everything down. And I said, okay, we can do about 20% of these things. And so if everyone says, "Oh, Airbnb is simple. I'm only doing three things." Yes, but you're one of a thousand people. So actually we're doing 3000 things. So instead of one team doing three things, three teams should do one thing. So we totally cut down the number of projects. We removed layers of management. I wanted to be as few layers as possible from leaders of the team. We went to a functional model. We went back to a startup.

**中文翻译:**
当我介入后，我做了以下改变。我做的第一件事是：我们正在做的每一件事都必须写下来并放入 Google 表格中。结果发现，人们甚至无法写下他们正在做的所有事情。我记得有人告诉我：“我们做的事情太多了，我根本无法记录。”我心想：“什么？”但无论如何，我们最终让每个人都把所有事情写了下来。我说，好吧，我们只能做其中大约 20% 的事情。如果每个人都说：“噢，Airbnb 很简单，我只做三件事。”是的，但你是千分之一。所以实际上我们正在做 3000 件事。因此，不再是一个团队做三件事，而是三个团队做一件事。所以我们彻底削减了项目数量。我们取消了管理层级。我希望从团队领导到我之间的层级越少越好。我们转向了职能模型。我们回到了初创公司的模式。

---

### [00:26:28] Brian Chesky

**English:**
So we said, we're not going to have divisional leaders. We're going to have design, engineering, product which turned to product marketing and marketing and communications and sales and operations, all the functions of a startup. I said, we're going to have fewer employees. We're going to have fewer more senior people. There's a great saying that the best way to slow a project down is add more people to it. And so we felt like very few employees. We have fewer than 7,000 employees today. As a relative comparison, I think Uber has 30,000. And it's not to say they're big, it's just say that's how small we are and we've really benefited from having not a lot of employees.

**中文翻译:**
所以我们说，我们不再设立事业部负责人。我们将拥有设计、工程、产品（转变为产品市场）、营销、公关、销售和运营，这些初创公司的所有职能。我说，我们要减少员工数量，我们要拥有更少但更资深的人。有一句名言说，减慢项目进度的最好方法就是增加人手。所以我们觉得员工要精简。我们今天只有不到 7000 名员工。作为对比，我认为 Uber 有 3 万名员工。这并不是说他们大，只是说我们规模很小，而我们确实从员工精简中受益匪浅。

---

### [00:27:11] Brian Chesky

**English:**
So we made sure that every executive was an expert in their functional domain. So you know how there's a lot of engineering managers that aren't that technical or maybe not a lot, but they exist. Or there's designers, but there's design leaders who lead the people. A design leader's job should be managing the design first, the people second. That's what Jony did. They're interchangeable. I could never imagine Jony out at Apple just being a manager of people. He was looking and designing the work with the team. How do you manage the people without managing their work? How do you give them development if you're not in the details with them on the work? So the same thing is true. So people had to be experts. Everyone had to be an expert.

**中文翻译:**
因此，我们确保每位高管都是其职能领域的专家。你知道有很多工程经理其实并不懂技术，或者也许不多，但确实存在。或者有设计师，但设计领导者只是在管人。设计领导者的工作应该是首先管理设计，其次才是管人。Jony Ive 就是这么做的。这两者是不可分割的。我无法想象 Jony 在苹果只是一个管人的经理。他是在和团队一起观察和设计作品。如果你不管理他们的工作，你怎么管理这些人？如果你不和他们一起深入工作的细节，你怎么给他们提供职业发展？所以道理是一样的。人们必须成为专家，每个人都必须是专家。

---

### [00:27:54] Brian Chesky

**English:**
I stopped pushing decision-making down. I pulled it in. I created one shared consciousness and I said, the top 30, 40 people in the company are going to have one continuous conversation. Metrics are going to be subordinate to the calendar. So we're going to have a roadmap. It's going to be a two-year roadmap. We'll update the roadmap literally every month. People may wonder, well, what if the world changes? Yeah, it changes every day. So the roadmap's something where the next month doesn't change, but two years out it changes. It's a rolling roadmap. And by the way, if Ukraine gets invaded and you want to provide housing for refugees, you can still pivot people and adapt very quickly. We house 120,000 refugees. So you still keep a reserve of resources to be able to pivot and do things because there's always unexpected events.

**中文翻译:**
我停止了决策权下放，而是将其收回。我创造了一种“共同意识”，我说公司最顶层的 30 到 40 人将进行持续的对话。指标将服从于时间表。所以我们将有一份路线图，一份两年的路线图。我们几乎每个月都会更新路线图。人们可能会问，如果世界变了怎么办？是的，世界每天都在变。所以路线图是下个月不变，但两年后的内容会变。这是一个滚动的路线图。顺便说一句，如果乌克兰遭到入侵，你想为难民提供住房，你仍然可以调动人员并非常迅速地适应。我们安置了 12 万名难民。所以你仍然保留一部分资源储备，以便能够转型和做事，因为总会有突发事件。

---

### [00:28:46] Brian Chesky

**English:**
I created this new function called product marketing. We basically described what that is. I made the group much smaller. I took a lot of product managers, I reassigned them as program managers. I had many of them trained in actual program management because their roles got much bigger. Program management at Airbnb is a high status job. A lot of companies, it's like a coordination job. At Airbnb we said because we're going to do launches, it's high status. We said we're going to do two launches a year and you can't ship something unless it's on the roadmap. So every single thing in the company, with the exception of some infrastructure projects have to be on the roadmap. And then I'm going to review all the work. And so we create the CEO review schedule where I said I'm getting back involved in the project and I'm going to review all the product and all the marketing. So every project I would review every week, every two weeks, every four weeks, every eight weeks or every 12 weeks. There'd be a cadence.

**中文翻译:**
我创建了这个名为“产品市场”的新职能。我们基本上已经描述了那是什么。我把这个团队缩减得很小。我把很多产品经理重新任命为项目经理（Program Managers）。我让他们中的许多人接受了实际的项目管理培训，因为他们的角色变得更重要了。在 Airbnb，项目管理是一项地位很高的工作。在很多公司，这就像是一个协调工作。在 Airbnb，我们说因为我们要搞发布会，所以它的地位很高。我们说每年搞两次发布会，除非在路线图上，否则不能发布任何东西。所以公司里的每一件事，除了一些基础设施项目外，都必须在路线图上。然后我会审查所有的工作。我们制定了 CEO 审查时间表，我说我要重新参与到项目中，我要审查所有的产品和所有的营销。所以每个项目我都会每周、每两周、每四周、每八周或每十二周审查一次。这有一定的节奏。

---

### [00:29:25] Brian Chesky

**English:**
And then I had a head program manager that would score all the projects. Either they're green, yellow, or red. Meaning they're on track or not on track to ship. Whether we thought they were work, we don't know until after we ship it. But I use the reviews of the work every single week. And the reason there's not a lot of bureaucracy and the reason you don't need any influence at Airbnb is I'd review the work and if something wasn't happening, then I would stop the meeting and say, "Why isn't this happening?" And we would all get together. And so you couldn't have a situation where a team wouldn't collaborate. It would be like I could then feel the work of an individual engineer.

**中文翻译:**
然后我有一名首席项目经理，他会给所有项目打分。要么是绿色、黄色，要么是红色。意思是它们是否按计划发布。至于我们是否认为它们有效，在发布之前我们不知道。但我每周都会利用对工作的审查。Airbnb 之所以没有很多官僚主义，之所以不需要刻意经营影响力，是因为我会审查工作，如果某件事没有进展，我就会停止会议并问：“为什么这件事没进展？”然后大家会聚在一起。所以不会出现团队不协作的情况。这就像我能直接感受到每个工程师的工作。

---

### [00:29:25] Brian Chesky (Continued)

**English:**
Because imagine if we're a car company and I see the car prototype every week and I notice there's something about the tires off. Now I can identify the individual person who was blocked. So every week I would try to see the equivalent of at least a semi assembly of the entire new product we were working on, which allowed me to identify with teams the different bottlenecks happening in the company. The reviews were the thing that allowed us to dictate the pace. And so because we had all these reviews, I didn't need to mandate people going back to an office. I didn't really care where they worked because I could track how well they were working because of the review cycle. So these were some of the changes that we made. We also started really building out much more of a marketing communications and creative function. We built our own in-house creative agency. So we use production partners, but we don't use Wieden+Kennedy or ChiatDay or any of those anymore. We actually built our own in-house agency, so to speak, which is a creative group.

**中文翻译:**
想象一下如果我们是一家汽车公司，我每周都看汽车原型，我注意到轮胎有点不对劲。现在我可以识别出是哪个人遇到了阻碍。所以每周我都会尝试看到我们正在开发的整个新产品的“半成品”，这让我能和团队一起识别公司中出现的不同瓶颈。审查是让我们决定节奏的关键。正因为有了这些审查，我不需要强制要求人们回到办公室。我并不在乎他们在哪里工作，因为通过审查周期，我可以追踪他们的工作成效。这些就是我们做出的一些改变。我们还开始大力建设营销传播和创意职能。我们建立了自己的内部创意机构。我们使用制作合作伙伴，但不再使用 Wieden+Kennedy 或 ChiatDay 等外部广告公司。可以说，我们建立了自己的内部机构，也就是创意小组。

---

### [00:30:32] Brian Chesky

**English:**
The creative group does not just the ads but the creative on the product. So we got really, really functional. We got rid of a function called UX writing, and we combined it with marketing writing. We said, wait, why don't we just have the best writers do everything? Why is UX writing a separate function? Because actually the emails, the app, the ads should all be one voice. Now, there may be people that come from a different background, like there are people that come from UX, but they all roll up to one function of writing. And writing should not go to design. Writing should go to a function called writing. Unless you want your head of writing to report to design, then that doesn't make sense. So we really made a lot of those changes.

**中文翻译:**
创意小组不仅负责广告，还负责产品上的创意。所以我们变得非常、非常职能化。我们取消了名为“用户体验文案”（UX writing）的职能，并将其与营销文案合并。我们说，等等，为什么不让最好的作家做所有事情呢？为什么 UX 文案是一个独立的职能？因为实际上电子邮件、App、广告都应该是一个声音。现在，可能有人来自不同的背景，比如有人来自 UX，但他们都归属于“写作”这一职能。写作不应该归属于设计，写作应该归属于一个叫“写作”的职能。除非你想让你的写作主管向设计主管汇报，但这说不通。所以我们确实做了很多这类改变。

---

### [00:31:16] Brian Chesky

**English:**
Just to round up the question that you asked, I think that way too many founders apologize for how they want to run the company. I don't know why they do, but I think they apologize for how they run the company. They basically find some midpoint between how they want to run a company and how the people they lead want to run the company. If you're a founder, what I would tell you is the problem with finding a negotiation between how you want to run a company, the people you want, is that's a good way to make everyone miserable. Because what everyone really wants is clarity and what everyone really wants is to be able to row in the same direction really quickly. And also if you try to appease employees, they may not even be there the whole time. So we have entire projects at the company where somebody advocated to do it, it was a big commitment and then they left and now we're still doing the project they advocated for. So it really has to be something that everyone wants to sign up for, not just the person who's there because they might not always be there.

**中文翻译:**
总结一下你问的问题，我认为有太多的创始人会为自己管理公司的方式感到抱歉。我不知道他们为什么要道歉，但我觉得他们确实在道歉。他们基本上是在自己想如何管理公司和下属想如何管理公司之间寻找折中点。如果你是创始人，我想告诉你的是：在你管理公司的方式和员工的需求之间进行谈判，是让每个人都痛苦的好方法。因为大家真正想要的是清晰度，大家真正想要的是能够快速地朝同一个方向划船。而且，如果你试图取悦员工，他们可能根本不会一直待在那里。我们公司有些项目是某人极力主张做的，那是一个巨大的承诺，然后他们离开了，现在我们还在做他们主张的项目。所以，这必须是每个人都愿意参与的事情，而不仅仅是那个可能不会永远待在那儿的人。

---

### [00:32:17] Brian Chesky

**English:**
I basically got involved in every single detail. And I basically told leaders that leaders are in the details. And there's this negative term called micromanagement, and I think there's a difference between micromanagement, which is telling people exactly what to do and being in the details. Being the details is what every responsible company's board does to the CEO. That doesn't mean the board is telling them what to do. But if you don't know the details, how do you know people are doing a good job? People think that great leader's job is to hire people and just empower them to do a good job. Well, how do you know they're doing a good job if you're not in the details? And so I made sure I was in the details and we really drove the product.

**中文翻译:**
我基本上参与了每一个细节。我告诉领导者们：领导者就应该关注细节。有一个负面词汇叫“微观管理”，我认为微观管理（告诉别人具体该怎么做）与“关注细节”之间是有区别的。关注细节是每个负责任的公司董事会对 CEO 所做的事情。这并不意味着董事会在告诉 CEO 该做什么。但如果你不了解细节，你怎么知道员工做得好不好？人们认为伟大领导者的工作就是雇人，然后授权他们去做好工作。好吧，如果你不了解细节，你怎么知道他们做得好不好？因此，我确保自己深入细节，我们真正推动了产品的进步。

---

### [00:32:57] Lenny (Sponsor: Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation AB testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams. Companies like Twitch, Miro, ClickUp and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and for understanding the performance of new features. And Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does.
(00:33:27):
When I was at Airbnb, one of the things that I loved most was our experimentation platform where could set up experiments easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more with advanced statistical methods that can help you shave weeks off experiment time, an accessible UI for diving deeper into performance and out of the box reporting that helps you avoid annoying prolonged analytics cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the AB testing flywheel. Eppo powers experimentation across every use case, including product, growth, machine learning, monetization and email marketing. Check out Eppo at geteppo.com/lenny and 10x your experiment velocity. That's get E-P-P-O .com/lenny.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 AB 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依靠 Eppo 来驱动他们的实验。实验对于推动增长和了解新功能的表现越来越重要。Eppo 帮助你提高实验速度，同时以其他商业工具无法做到的方式解锁严谨的深度分析。
(00:33:27):
当我在 Airbnb 时，我最喜欢的事情之一就是我们的实验平台，在那里我可以轻松设置实验、排除故障并独立分析表现。Eppo 具备所有这些功能，甚至更多，它拥有先进的统计方法，可以帮你缩短数周的实验时间，拥有易用的 UI 来深入研究表现，还有开箱即用的报告，帮你避免烦人且漫长的分析周期。Eppo 还让你能轻松与团队分享实验见解，激发 AB 测试飞轮的新创意。Eppo 支持各种场景下的实验，包括产品、增长、机器学习、商业化和邮件营销。访问 geteppo.com/lenny 了解 Eppo，让你的实验速度提升 10 倍。

---

### [00:34:15] Lenny

**English:**
You guys found such a unique way of working. I've never heard of a company working in these ways, in so many contrarian ways. I think it's going to be a really interesting case study as things progress. Essentially what you've done is shut down traditional growth channels or at least limited them. Paid growth and maybe SEO, maybe referrals at least for a while. And you've shifted to let's just make an awesome product and tell people about it. And our bet is that's going to grow. Do you feel like this can work for most other products or is there a consumer specific opportunity? What advice would you give to founders that are thinking about, man, we should try something like this?

**中文翻译:**
你们找到了一种如此独特的运作方式。我从未听说过有哪家公司以这么多反传统的方式运作。随着时间的推移，我认为这将是一个非常有趣的案例研究。本质上，你关闭了传统的增长渠道，或者至少限制了它们——付费增长，也许还有 SEO，也许还有推荐（referrals），至少有一段时间是这样。你转向了“让我们做一个很棒的产品并告诉大家”，我们的赌注是这会带来增长。你觉得这适用于大多数其他产品吗？还是说这只是针对消费者的特定机会？对于那些在想“天哪，我们也该试试这个”的创始人，你有什么建议？

---

### [00:34:53] Brian Chesky

**English:**
I think that this methodology can work for everyone, but I don't think you have to be as ideological or have to go all the way to 100. I still think growth channels matter. To be clear, we still spend money on performance marketing. We still do measure conversion and we will do some experiments. Think of conversion and growth optimization as like running a football down a field and think of these big leaps as passes. You should probably be doing 80% passes, 20% running the ball down the field, and a lot of companies that do 80% running down the ball down the field and 20% passes. So I think that this methodology will work for everyone.

**中文翻译:**
我认为这种方法论适用于每个人，但我不认为你必须变得那么意识形态化，或者必须做到 100% 彻底。我仍然认为增长渠道很重要。明确地说，我们仍然在效果营销上花钱。我们仍然衡量转化率，也会做一些实验。把转化和增长优化想象成在球场上带球跑，把这些重大飞跃想象成传球。你可能应该做 80% 的传球和 20% 的带球跑，而很多公司做的是 80% 的带球跑和 20% 的传球。所以我认为这种方法论对每个人都有效。

---

### [00:35:33] Brian Chesky (Continued)

**English:**
Here are the things I believe. I'll give you a checklist. Number one, I think that the CEO, unless they're not a product person, should think of themselves as this chief product officer and they should be involved in the product. Number two, if you're not functional, I would at least think about everyone being really close together. So here's another way of saying it, Lenny. Every product manager should be interconnected and know what everyone else is doing. They shouldn't be independently siloed unless they really are running separate companies or separate orgs and they have no dependencies. I think that every leader should be an expert in what they're leading. There should be no people managers in the entire company. And when I say people managers, meaning your only responsibility is people, not the work or not the domain. Because you can't manage people devoid of their work.

**中文翻译:**
以下是我相信的事情。我给你一个清单。第一，我认为 CEO（除非他们不是产品人）应该把自己看作首席产品官，并参与到产品中。第二，如果你不是职能制，我至少会考虑让每个人都紧密联系在一起。Lenny，换种说法：每个产品经理都应该互联互通，知道其他人在做什么。他们不应该独立成“孤岛”，除非他们真的在经营独立的公司或组织且没有依赖关系。我认为每个领导者都应该是他们所领导领域的专家。全公司不应该有单纯的“管人经理”（people managers）。我说的管人经理是指你的唯一职责是管人，而不是管工作或领域。因为你无法脱离工作去管人。

---

### [00:36:18] Brian Chesky (Continued)

**English:**
Imagine a fire chief and they don't know anything about putting out fires. That's crazy. You have to know the subject matter. People should aim to have as few people as possible on their team. I'm not saying eliminate people. I mean grow slowly and do not be reckless. Five teams should do one thing rather than one team do five things. So that's just a metaphor. But people should work together. I think that people should consider doing launches. You can by the way, ship every hour of every day, but then package it and tell a story if you want hold the product back. I think that teams should use data, but they should also use research and intuition. There's a designer called Charles Eames that said you can't delegate understanding. If you're going to do AB experiments or measure data, you have to understand what it means. I think that you have to have an intuition. Intuition comes not from arbitrariness, it comes from understanding. I would make sure that you have engineering and design ideally report to the founder, product led person. I would not have design under product unless you have an extremely good reason or the product person is a designer.

**中文翻译:**
想象一个消防局长，他却对灭火一窍不通。这太疯狂了。你必须了解专业知识。人们应该力求团队人数越少越好。我不是说裁员，我是说增长要缓慢，不要鲁莽。应该是五个团队做一件事，而不是一个团队做五件事。这只是个比喻。但人们应该协同工作。我认为人们应该考虑搞“发布会”。顺便说一句，你可以每天每小时都发布代码，但如果你想暂缓发布产品，那就把它包装起来讲个故事。我认为团队应该使用数据，但也应该使用研究和直觉。有一位名叫 Charles Eames 的设计师说过，你不能授权“理解”。如果你要做 AB 实验或衡量数据，你必须理解它的含义。我认为你必须有直觉。直觉并非来自随意，而是来自理解。我会确保工程和设计理想情况下直接向创始人（产品驱动的人）汇报。我不会把设计放在产品部门之下，除非你有极其充分的理由，或者产品负责人本身就是设计师。

---

### [00:37:25] Brian Chesky (Continued)

**English:**
I would try to think about product management, expanding the responsibility and including distribution. Understanding the customer and teaching people how to tell a story. I would try to make sure that the product managers are a combination of art and science. I do not think you want purely technical product managers doing things if they're going to work with non-technical functions. If they're only work technical functions, that's fine, but they're going to work with non-technical functions, I think that's a problem. I should make sure that marketing and engineering are interconnected. I would make sure that you have as few layers between a CEO and other people. If you're a CEO, every direct to your direct should be a implicit dotted line to you. So I treat every direct to my direct as if they're a direct report. A dotted line. I don't try to conflict with the direction of my team, but I always want to know what another layer below me is doing.

**中文翻译:**
我会尝试思考产品管理，扩大其职责并包括分发（distribution）。理解客户并教人们如何讲故事。我会努力确保产品经理是艺术与科学的结合。我不认为你想要纯技术型的产品经理去处理那些需要与非技术职能部门合作的事情。如果他们只处理技术职能，那没问题，但如果要与非技术职能合作，我认为那会有问题。我会确保营销和工程是互联的。我会确保 CEO 和其他人之间的层级尽可能少。如果你是 CEO，你下属的下属应该是你隐含的虚线汇报对象。所以我把下属的下属也当作直接下属对待，也就是虚线汇报。我不会试图与我团队的方向发生冲突，但我总是想知道我下面那一层在做什么。

---

### [00:38:18] Brian Chesky (Continued)

**English:**
I think you should think of each release as a chapter of a story or like an episode of a TV series. And you should think of your company in a five or 10 years story. You may not know where you are in 10 years, but you're telling this ongoing story. And most of all, I would say that everyone should row in the same direction. If there's only one thing I said in this interview today, actually I'm not sure what it would be, but I think a good candidate is try to get everyone to row together in the same direction. Otherwise, why the hell are you all in the same company?

**中文翻译:**
我认为你应该把每一次发布看作故事的一个章节，或者像电视剧的一集。你应该把你的公司看作一个 5 年或 10 年的故事。你可能不知道 10 年后你在哪里，但你正在讲述这个持续进行的故事。最重要的是，我想说每个人都应该朝同一个方向划船。如果今天这次采访我只能说一件事，我不确定会是什么，但一个很好的候选是：努力让每个人都朝同一个方向划船。否则，你们到底为什么要在同一家公司？

---

### [00:38:48] Lenny

**English:**
Speaking of rowing in the same direction, you had a huge launch today. I know you wanted to talk about it. Your winter release. And it is the culmination of a lot of the things you're talking about. I'd love to hear just some of the stuff you're launching.

**中文翻译:**
说到朝同一个方向划船，你今天有一个重大的发布。我知道你想聊聊这个——你们的冬季发布会。这是你刚才谈到的很多事情的结晶。我很想听听你们发布的一些内容。

---

### [00:39:00] Brian Chesky

**English:**
Let me just back up Lenny. You know this problem really well. One of the best things of Airbnb is that we're this marketplace where guests and hosts come together and we have all this unique inventory and people list it on Airbnb. And every home is one of a kind and we have seven million homes and there's all this surprise and all this delight. The problem is that every home is one of a kind and you often don't know what you're going to get. And so a lot of guests have described checking into Airbnb as a moment of truth. Where when you open the door you find out if the home is exactly the home that you booked. And this turns out to be a big problem for people wanting to book an Airbnb. And when we survey guests or people who don't use Airbnb, the number one ... Hotels are not as special, they're not as unique, but the advantage they have is you know what you're going to get. You know exactly what you're going to get.

**中文翻译:**
Lenny，让我先退一步。你非常了解这个问题。Airbnb 最棒的一点是，我们是一个房客和房东聚集的市场，我们拥有所有这些独特的库存，人们在 Airbnb 上发布房源。每个家都是独一无二的，我们有 700 万个房源，充满了惊喜和愉悦。问题在于，正因为每个家都是独一无二的，你往往不知道自己会得到什么。因此，很多房客将入住 Airbnb 描述为“真相时刻”：当你打开门的那一刻，你才知道这个家是否正是你预订的那个。事实证明，这对于想要预订 Airbnb 的人来说是一个大问题。当我们调查房客或不使用 Airbnb 的人时，排名第一的原因是……酒店虽然没那么特别、没那么独特，但它们的优势在于你知道自己会得到什么。你确切地知道会得到什么。

---

### [00:39:56] Brian Chesky (Continued)

**English:**
And so what we found is that reliability is Airbnb's achilles heel, or at least it has been. That with hotels you know what you're going to get an Airbnb you don't always know what you're going to get. And so we asked ourselves, what if we could combine the uniqueness of Airbnb with the reliability that you've come to expect in a hotel? And that's what we've done with Guest Favorites. Guest Favorites are homes that guests in our community love the most. We took 370 million reviews on Airbnb plus millions of customer service tickets, plus all the host cancellation data and we use all the signal to create the top two million homes. This collection of two million homes that we call Guest Favorites because the guests rate the highest. We think combine the uniqueness of Airbnb with a reliability you've come to expect in a hotel and I can't imagine there's a lot of use cases where you wouldn't want to book a Guest Favorite.

**中文翻译:**
所以我们发现，可靠性是 Airbnb 的致命弱点（Achilles heel），或者至少曾经是。住酒店你知道会得到什么，住 Airbnb 你并不总是知道。于是我们问自己：如果我们能将 Airbnb 的独特性与你在酒店所期望的可靠性结合起来呢？这就是我们通过“房客最爱”（Guest Favorites）所做的事情。“房客最爱”是我们社区中房客最喜爱的房源。我们分析了 Airbnb 上的 3.7 亿条评价，加上数百万张客服工单，再加上所有房东取消预订的数据，我们利用所有这些信号筛选出了前 200 万个房源。这 200 万个房源的集合我们称之为“房客最爱”，因为房客给出的评分最高。我们认为这结合了 Airbnb 的独特性和酒店般的可靠性，我无法想象在很多场景下你竟然不想预订“房客最爱”。

---

### [00:40:50] Brian Chesky (Continued)

**English:**
We think that's also part of this broader system of ratings and reviews. You see, as you know, Airbnb is built on a system of trust and we invented this new way for people to trust one another, at least at scale through living together certainly. And we felt like the rating and review system could use a little bit of an upgrade. So we obviously made some upgrades to ratings and reviews. The final thing, and this brings up another point I might bring up, is we've completely overhauled the host tab. One of the most important things when you get to an Airbnb is the listing is accurate. But the problem is that a lot of host listings don't have all the details up to date. So they might not describe perfectly their listing, they might not have filled up their amenities, they might not have a photo tour. And the reason why as we're doing research is because they found it was hard to manage their listing. And it was hard to manage their listing because it was designed as this hodgepodge thing by different teams over many years.

**中文翻译:**
我们认为这也是更广泛的评分和评价系统的一部分。如你所知，Airbnb 建立在信任体系之上，我们发明了这种让人们相互信任的新方式，至少是通过共同生活在大规模范围内实现的。我们觉得评分和评价系统可以进行一些升级。所以我们显然对评分和评价做了一些改进。最后一点，这引出了我可能要提到的另一点，就是我们彻底改革了“房东端”（host tab）。当你到达 Airbnb 时，最重要的事情之一就是房源信息准确。但问题是，很多房东的房源信息没有及时更新。他们可能没有完美地描述房源，可能没有填全设施，可能没有照片导览。我们在研究中发现，原因是他们觉得管理房源很难。而管理房源之所以难，是因为它在多年间由不同团队设计，成了一个大杂烩。

---

### [00:41:47] Brian Chesky (Continued)

**English:**
Oh, here's the other thing, Lenny, when you were at Airbnb, we had a guest team and a host team. We don't have a guest team and host team. We have a design team. We have a marketing team. We have an engineering team. The reason we don't break the app into guests and hosts anymore is because reviews affect guests and hosts. It turns out that almost everything involves connecting the guest and host. When you have separate teams, they tend to have separate roadmaps that go in separate directions that become incompatible. So we have product marketers that are responsible for guests and host things, but the designers and the engineers are fairly fungible and they can move from project to project.

**中文翻译:**
噢，还有另一件事，Lenny，你在 Airbnb 时，我们有一个房客团队和一个房东团队。现在我们没有房客团队和房东团队了。我们有设计团队、营销团队和工程团队。我们不再将 App 划分为房客端和房东端的原因是，评价会同时影响房客和房东。事实证明，几乎所有事情都涉及连接房客和房东。当你拥有独立的团队时，他们往往会有独立的路线图，朝不同的方向发展，最后变得互不兼容。所以我们有负责房客和房东事务的产品市场人员，但设计师和工程师是相当通用的，他们可以从一个项目转到另一个项目。

---

### [00:42:25] Brian Chesky (Continued)

**English:**
And then we keep some people, especially the product marketing people on a domain area, but we really want to make sure that we have designers and engineers covering a much larger surface. And so that's what we did. We have this incredible new tab called the listing tab that we designed. It's quite possibly one of the nicest things we ever designed. If you go to my Twitter account, you'll see a little sizzle reel from some of the design we've done. By the way, the design is a whole new aesthetic. I'd like to make the announcement that I think flat design is over or ending. I think if you remember the 2000s was dominated by skeuomorphism. The 2010s have been dominated with the launch of iOS seven by flat design. And I think we're going to move back into a world with color, texture, dimensionality, more haptic feedback, but I don't think it's going to be skeuomorphism where it pretends to be a wood grain to reference a dashboard or leather, but I think it's going to have a sense of dimension.

**中文翻译:**
我们会让一些人（特别是产品市场人员）留在某个领域，但我们真的希望确保设计师和工程师能覆盖更广的范围。这就是我们所做的。我们设计了一个令人惊叹的新标签页，叫“房源标签页”（listing tab）。这很可能是我们设计过的最漂亮的东西之一。如果你去我的 Twitter 账号，你会看到一些我们设计的宣传短片。顺便说一句，这个设计是一种全新的审美。我想宣布，我认为“扁平化设计”（flat design）已经结束或即将结束。如果你记得 2000 年代是由“拟物化设计”（skeuomorphism）主导的。2010 年代随着 iOS 7 的发布，由扁平化设计主导。我认为我们将回到一个充满色彩、纹理、维度感和更多触觉反馈的世界，但我认为它不会是那种假装木纹或皮革的拟物化，而是一种具有维度感的设计。

---

### [00:43:24] Brian Chesky (Continued)

**English:**
I think the reason why is we're spending more and more time on screens and we want the screens to replicate some of what we see in the natural environment. Light, texture. I think it's more intuitive, it's more playful. I think AI allows the development of more sophisticated interfaces. People in AI are gravitating to image generating art that has got more dimension to it. And so I think that we've really started to push this more three-dimensional, colorful aesthetic that I think it's going to be where a lot of interface design is going. And we built this AI powered photo tour where we created our own AI computer visioning language that we trained on 100 million photos and it can basically scan all your photos and organize them by room. So that's what we did today. Maybe just to round it up, what I would say is that none of this would've been possible in the old way of working. We could have theoretically launched a lot of these features, but really getting them to work together has been key. And Guest Favorites has required the guests, people ... You have to work with guests, you have to work with hosts, you have to essentially ... You have to figure out how to communicate to the market. So it's a much more integrated approach.

**中文翻译:**
我认为原因是我们在屏幕上花费的时间越来越多，我们希望屏幕能复制一些我们在自然环境中看到的东西：光影、纹理。我认为这更直观、更有趣。我认为 AI 允许开发更复杂的界面。AI 领域的人们正趋向于生成更具维度感的图像艺术。因此，我认为我们已经开始推动这种更具三维感、色彩丰富的审美，我认为这将是许多界面设计的发展方向。我们还构建了一个由 AI 驱动的照片导览，我们创建了自己的 AI 计算机视觉语言，并在 1 亿张照片上进行了训练，它基本上可以扫描你所有的照片并按房间进行整理。这就是我们今天所做的。总结一下，我想说的是，在旧的工作方式下，这一切都不可能实现。理论上我们可以发布很多这些功能，但让它们真正协同工作才是关键。“房客最爱”需要房客、房东……你必须与房客合作，必须与房东合作，你必须弄清楚如何向市场传达。所以这是一个更加整合的方法。

---

### [00:44:41] Lenny

**English:**
The designs you talked about, they are incredibly cute. You tweeted a little video of a lot of them, like the couch with little textures on it. It is really cool. Also, the listing tab. I think people that aren't hosts don't understand how important the listing experience is to a host. How many hosts are there? Seven million? Something like that?

**中文翻译:**
你提到的那些设计真的非常可爱。你发了一段视频，里面有很多设计，比如那个带纹理的小沙发。真的很酷。还有房源标签页。我认为不是房东的人无法理解房源管理体验对房东有多重要。现在有多少房东？700 万？类似这样？

---

### [00:45:00] Brian Chesky

**English:**
There's seven million listings. Over seven million listings.

**中文翻译:**
有 700 万个房源。超过 700 万个房源。

---

### [00:45:04] Lenny

**English:**
Yeah. And so that's the home base. That's like the small business platform for millions of people. And so I worked on the host sites. I have a special place in my heart for host features, and I feel like travelers don't really appreciate the value of that part of the product.

**中文翻译:**
是的。所以那是大本营。那是数百万人的小微企业平台。我曾负责过房东端的工作，所以我对房东功能情有独钟，我觉得旅行者并不真正理解这部分产品的价值。

---

### [00:45:18] Brian Chesky

**English:**
Well, yeah, you did some amazing work there. Yeah. The big lesson, Lenny, the other thing we learned is to create a great guest experience, you need great hosts, and to have great hosts, they need great tools. And so if you want to create a great experience for guests, it often starts with building great tools for hosts to enable them to provide a great experience for guests. And so that was one of the theories behind the listing tab is we're going to build great tools for hosts. They're going to love it. And we also felt like if we put care in the design of our app, that hosts are going to see that and that they're going to actually put care into hosting. Even more than they already do. And they do put a lot of care in now.

**中文翻译:**
是的，你在那儿做了一些了不起的工作。Lenny，我们学到的另一个重要教训是：要创造伟大的房客体验，你需要伟大的房东；而要拥有伟大的房东，他们需要伟大的工具。所以如果你想为房客创造伟大的体验，通常要从为房东构建伟大的工具开始，让他们能够为房客提供伟大的体验。这就是房源标签页背后的理论之一：我们要为房东构建伟大的工具，他们会喜欢的。我们也觉得，如果我们用心设计我们的 App，房东会看到这一点，他们也会在出租过程中更加用心。甚至比现在更用心，虽然他们现在已经很用心了。

---

### [00:45:55] Lenny

**English:**
Speaking of great products, a defining characteristic of Brian Chesky in my mind is how big you make people think. How you push people to think bigger. Memories I have of you is in meetings, we present our goal and you're always saying, "How do we 10X this? What would it take to 10X this idea?" And somehow we often hit these crazy goals after you 10X'd them or sometimes just double them. What have you learned about just the power of setting really ambitious goals, but also finding the balance with not demoralizing people if they don't hit these really ambitious goals?

**中文翻译:**
说到伟大的产品，在我心中，Brian Chesky 的一个鲜明特征就是你如何让人们思考得更远大。你如何推动人们去想得更大。我记忆中的你在会议上，当我们展示目标时，你总是说：“我们如何把这个扩大 10 倍？要把这个想法扩大 10 倍需要什么？”不知何故，在你把目标扩大 10 倍（或者有时只是翻倍）后，我们经常能达成这些疯狂的目标。关于设定雄心勃勃的目标的力量，以及在没达成目标时如何平衡不让员工感到沮丧，你学到了什么？

---

### [00:46:32] Brian Chesky

**English:**
As you know, there was a saying inside of Airbnb, it was add a zero. Add a zero at the end, which is to imagine something you order, imagine it bigger. The exercise isn't necessarily to say if people say they want to hit a goal, I say, okay, I added a zero, you have to hit that goal. It's more the exercise of what would it take to be 10X bigger or do something 10 times better? Because what you find is when you push people, they will sometimes think about the problem differently. And one of the best ways to get unstuck from a problem is to imagine a 10X scale or 10X better or 10X faster where you can't do the current process to do it. You have to think differently about the problem. And to think differently about the problem means you have to deeply understand the problem. And to deeply understand the problem, you have to break it into its components.

**中文翻译:**
如你所知，Airbnb 内部有一句话叫“加个零”。在末尾加个零，也就是想象你所要求的东西规模更大。这个练习并不一定是说，如果人们说他们想达成一个目标，我说，好吧，我加了个零，你必须达成那个目标。它更多的是一种练习：要扩大 10 倍或做得好 10 倍需要什么？因为你会发现，当你推动人们时，他们有时会以不同的方式思考问题。摆脱困境的最佳方法之一就是想象 10 倍的规模、10 倍的好或 10 倍的快，在这种情况下，你无法用当前的流程来完成。你必须以不同的方式思考问题。而以不同的方式思考问题意味着你必须深入理解问题。要深入理解问题，你就必须将其分解为各个组成部分。

---

### [00:47:22] Brian Chesky (Continued)

**English:**
And we might call this first principle thinking. What are the foundational elements that comprise this problem and how can we reconstruct them? So the first thing is I think by adding a zero, at least conceptually for teams, that helps them understand a problem. The second is, I think one of the most important things for a founder or leader to do is set the pace of the team. I think the pace of the team is one of the most important things you can do. And that pace is sometimes governed not by how hard people work, but how decisive they are. If you want to improve the speed of a company, then make faster decisions. And fast decisions come from a bias of action. If we're in a meeting, we don't just say, "Okay, let's circle back on this next week." No, we'll have it done by next week. Let's stay in this meeting until it's done. What are you doing? Have a bias for action. Who's responsible? Okay, what are you doing? Okay, let's check in an hour. I'll call you in the morning. Okay, how do we do this? And so you end up getting three months of work done over that period of time.

**中文翻译:**
我们可以称之为“第一性原理思维”（first principle thinking）。构成这个问题的基础元素是什么，我们如何重构它们？所以第一点是，我认为通过“加个零”（至少在概念上对团队而言），有助于他们理解问题。第二点是，我认为创始人或领导者要做出的最重要的事情之一就是设定团队的节奏。我认为团队节奏是你所能做的最重要的事情之一。而这种节奏有时不是由人们工作有多努力决定的，而是由他们的果断程度决定的。如果你想提高公司的速度，那就更快地做决定。快速决策来自“行动偏好”（bias of action）。如果我们在开会，我们不只是说：“好吧，我们下周再来讨论这个。”不，我们下周就要把它做完。让我们待在这个会议里直到完成。你在做什么？要有行动偏好。谁负责？好，你在做什么？好，一小时后检查一下。我明早给你打电话。好，我们怎么做这个？于是，你最终在那段时间里完成了三个月的工作量。

---

### [00:48:18] Brian Chesky (Continued)

**English:**
But the last thing I'll say about adding a zero, Lenny, is I remember there was a story about a great basketball coach named John Wooden. He was one of the winningest basketball coaches, I think, in college basketball history, perhaps the greatest. And someone asked him once ... I'm going to paraphrase what he said. What is your secret to success? And he said, "That I just asked my players to do their very best." And I remember thinking to myself, that doesn't sound like the secret to success, asking people to do their best. But there was an implicit thing that he didn't say, which is that he saw potential in people that they never saw in themselves. And so the role of a leader is to see potential in people that they may not even see themselves.

**中文翻译:**
关于“加个零”，Lenny，最后我想说的是，我记得有一个关于伟大的篮球教练 John Wooden 的故事。他是大学篮球史上获胜次数最多的教练之一，也许是最伟大的。有人曾问他……我转述一下他的话：你成功的秘诀是什么？他说：“我只是要求我的球员尽力而为。”我记得当时心想，要求人们尽力而为听起来不像成功的秘诀。但他有一句潜台词没说，那就是：他在人们身上看到了他们自己从未察觉到的潜力。所以，领导者的角色就是看到人们身上他们自己甚至都没看到的潜力。

---

### [00:49:04] Brian Chesky (Continued)

**English:**
When I tell somebody it's not good enough, either I'm saying, you're not good enough, or I believe that you have more potential than you're showing me. So in other words, you can push a team and they could feel demoralized because they can feel like what they're doing is not good enough if they have a fixed mindset or you create a growth mindset organization where the more I'm involved, the more I say you can do better, it's because the more I believe in you, and I know that you have more in you. And the way to know if a team could do better is if they're life dependent on it, could they do it? And Andy Grove used to say that there's competency and motivation. And motivation is if they're life ... Not literally dependent on it, but if it was a crisis or if it was a defining moment in their lives. I think the job of a leader is not to make it life and death, that's too far, but to be able to motivate a team to see potential in them that they don't see in themselves, and to really push them. To set a tempo, to break something down to first principle thinking. And if you do that, then I think that's going to be the opposite of these slow moving, soul crushing bureaucracies.

**中文翻译:**
当我告诉某人“这还不够好”时，要么我是在说“你不够好”，要么是我相信你拥有的潜力比你展示给我的更多。换句话说，你可以推动一个团队，如果他们拥有“固定型思维”，他们可能会感到沮丧，因为他们觉得自己的工作不够好；但如果你建立一个“成长型思维”的组织，我参与得越多，我说你可以做得更好，是因为我越相信你，我知道你还有潜力。判断一个团队是否能做得更好的方法是：如果这关系到他们的生命，他们能做到吗？安迪·格鲁夫（Andy Grove）曾说，有能力和动力之分。动力就是如果他们的生命……不是字面意义上的依赖，而是如果这是一个危机，或者这是他们生命中的决定性时刻。我认为领导者的工作不是把它变成生死攸关的事（那太过分了），而是能够激励团队看到他们自己看不到的潜力，并真正推动他们。设定节奏，将事物分解为第一性原理思维。如果你这样做，那么我认为这将与那些缓慢移动、摧残灵魂的官僚机构截然相反。

---

### [00:50:06] Lenny

**English:**
I've definitely been through that where you set a crazy goal and then we ended up hitting it. And so I've seen that myself. With some of the things you've talked about of say, do it now, we're not going to wait another week to circle back and this stuff you talked about of taking on the CPO role, not having a CPO, and also all these launches, it sounds like a lot of work and a lot of hours. What have you learned about avoiding burnout and creating balance and also just helping people on your team avoid burnout and creating balance?

**中文翻译:**
我确实经历过那种情况，你设定了一个疯狂的目标，最后我们竟然达成了。所以我亲眼见证过。关于你提到的那些事，比如“现在就做，不要再等一周再讨论”，还有你承担 CPO 角色、不设 CPO，以及所有这些发布会，听起来工作量巨大，时间很长。关于避免职业倦怠、创造平衡，以及帮助你的团队成员避免倦怠和创造平衡，你学到了什么？

---

### [00:50:34] Brian Chesky

**English:**
First of all, I want to give you a very surprising learning. I weirdly now, the more I get involved ... This is so weird. The more in the details I am, the more time I have on my hands. That's a paradox. And I want to explain that paradox. It doesn't make any sense. But when I explain this process to people that I would be in the details, we'd have one shared consciousness, I would review everything, we would do endless edits of even the press release, it would seem like I would be working 80, 100 hours a week and that people will be disempowered and that no one would want to do anything. And I got just the opposite. Here's what I found. If you decide to be in the details and get very, very hands-on like I did, it might be a lot more work for about one to two years.

**中文翻译:**
首先，我想告诉你一个非常令人惊讶的发现。奇怪的是，现在我参与得越多……这真的很奇怪，我越深入细节，我手头的时间反而越多。这是一个悖论。我想解释一下这个悖论。这听起来毫无道理。但当我向人们解释这个过程——我会深入细节，我们会有一个共同意识，我会审查一切，我们会对甚至新闻稿进行无休止的修改——看起来我每周要工作 80 到 100 小时，人们会被剥夺权力，没人想做事。但我得到的结果恰恰相反。以下是我的发现：如果你决定像我一样深入细节并亲力亲为，大约在一到两年内工作量会大得多。

---

### [00:51:20] Brian Chesky (Continued)

**English:**
And so for one to two years it was way more work than the old way. But once we turned the corner, suddenly everyone started rowing the same direction. Suddenly I didn't have to be in meetings anymore and people would do what I wanted them to do if I wasn't there. And by the way, that's what the culture is. They say the culture is what happens when you're not in the room and the brand is what people say when you're not in the room. And so that became our culture. Suddenly there was fewer conflicts in the company. There was less turnover. People were rowing in the same direction. That I wasn't reacting. Before, I would get 10 surprises and nine were bad. Now I get 10 surprises and nine are good. And you don't really have to do anything about good surprises, only bad surprises. That I used to have to intervene in projects that I wasn't involved in because they were going off in the wrong direction and by the time I got involved, I was associated with dysfunction, but I only got involved because it was dysfunctional. It wasn't actually going well. And then it was three times as work to fix something because we weren't involved in the very early stages. So I was much more involved. I had a lot less time on my hands initially, and now I actually weirdly have a lot more time on my hands.

**中文翻译:**
所以在一到两年里，工作量比旧方式大得多。但一旦我们度过了转折点，突然间每个人都开始朝同一个方向划船。突然间我不需要再参加那么多会议了，即使我不在场，人们也会按照我的意图去做事。顺便说一句，这就是文化。人们说文化就是当你不在房间里时发生的事情，品牌就是当你不在房间里时人们谈论的内容。这成了我们的文化。突然间，公司内部的冲突减少了，人员流失减少了，大家都在朝同一个方向努力。我不再是被动应对。以前，我收到 10 个惊喜，9 个是坏的；现在我收到 10 个惊喜，9 个是好的。对于好的惊喜，你不需要做任何事，只需要处理坏的惊喜。以前我不得不干预那些我没参与的项目，因为它们偏离了方向，而当我介入时，我就与“功能失调”联系在了一起，但我介入仅仅是因为它失调了，并不是因为它进展顺利。然后修复某件事的工作量是原来的三倍，因为我们没有在早期阶段参与。所以我参与得更多了。起初我手头的时间少得多，但现在奇怪的是，我手头的时间反而多得多了。

---

### [00:52:33] Brian Chesky

**English:**
But to answer your question on burnout, I think is another very good question. I do not think I am the poster child, at least historically, of work-life balance. I'm 42 years old. I live with a golden retriever. I don't yet have a family. And if you asked me when I was in college how I thought my life would be right now, I probably would've thought the inverse. That I'd have a family and I'd one day run a company. And I did things in a slightly different order. But one of the things I've learned is that there's this temptation to work more and more and more hours. And sometimes you need ... Let's say an artist, you have to step away from the painting. And you actually start getting more derivatives, slower and slower.

**中文翻译:**
但回答你关于职业倦怠的问题，我认为这是另一个非常好的问题。我不认为我是工作与生活平衡的典范，至少从历史上看不是。我 42 岁了，和一只金毛寻回犬住在一起，还没有组建家庭。如果你在我上大学时问我，我觉得我现在的生活会是什么样子，我可能会想到相反的情况：我会有一个家庭，有一天会经营一家公司。我只是以略微不同的顺序做了这些事。但我学到的一件事是，人们总有一种诱惑去工作越来越长的时间。有时你需要……就像艺术家一样，你必须从画作前退后一步。否则你实际上开始变得越来越平庸，速度越来越慢。

---

### [00:53:13] Brian Chesky (Continued)

**English:**
And so I basically have tried to make it a practice to step away from the work. And so here's some of the things I do. Every other weekend I don't really work at all. And then every other weekend I work pretty intensely. If I had a family, it would probably be more like a day of the weekend I'd work more intensely. You wouldn't be a parent every other weekend, but I'm not so it's a little different. I usually make sure I exercise and I never miss a workout. So I usually wake up, I'll do 20 minutes of morning cardio on a Peloton. I'll go to the gym three or four times a week and do weights. I'll basically do cardio just about every day. I make sure that I eat really healthy. I have a classic bodybuilding diet of five to six meals a day. So I try to make sure I do that. I try to make sure I get a fairly good amount of sleep.

**中文翻译:**
所以我基本上尝试养成一种从工作中抽离的习惯。以下是我做的一些事情：每隔一个周末我完全不工作，然后另一个周末我会非常高强度地工作。如果我有家庭，可能更像是周末的一天高强度工作。你不能每隔一个周末才当父母，但我没有家庭，所以情况有点不同。我通常确保自己锻炼，从不缺席。我通常起床后会在 Peloton 动感单车上做 20 分钟晨间有氧。我每周去三四次健身房做负重训练。我基本上每天都做有氧运动。我确保饮食非常健康，采用经典的健身饮食，每天五到六餐。我努力确保做到这一点。我也努力确保有充足的睡眠。

---

### [00:54:01] Brian Chesky (Continued)

**English:**
The other two things I try to do is have really healthy relationships. I think one of the most important things that will govern how happy you are in your life is your relationships. I think the three things are your health, your relationships, and your work. Those are probably the three most important things. So as long as you're healthy and you have meaningful work, the last is relationships. And there was this Harvard study. It's the longest study on human happiness. I think it's 85 years old. And the question was, what's the secret of happiness? And of course they weren't expecting to have a single answer, but they got one. And the answer was, the secret to happiness, if there is one, is healthy relationships. And I had found, Lenny, that over the time of being an entrepreneur, I had gotten totally isolated. It was almost as if I didn't have friends. I had friends, but I didn't keep in touch with them. And every time I reached out to a friend, I had to get them up to speed on my life. And if you have to get people up to speed, you're not really keeping as much in touch with them. And so I started making a practice a couple of years ago to make sure that I have a group of friends that I'm constantly in touch with, including old friends.

**中文翻译:**
我尝试做的另外两件事是拥有非常健康的人际关系。我认为决定你一生幸福感的最重要因素之一就是你的人际关系。我认为三件事最重要：健康、人际关系和工作。只要你健康且拥有有意义的工作，最后就是人际关系。哈佛大学有一项研究，是关于人类幸福感最长的一项研究，持续了 85 年。问题是：幸福的秘诀是什么？当然，他们并没指望得到单一的答案，但他们得到了。答案是：幸福的秘诀（如果真有的话）就是健康的人际关系。Lenny，我发现作为一名企业家，随着时间的推移，我变得完全孤立了。就好像我没有朋友一样。我有朋友，但我没和他们保持联系。每次我联系朋友，我都得让他们了解我的近况。如果你必须让别人了解近况，说明你并没有真正保持联系。所以几年前我开始养成一个习惯，确保我有一群经常联系的朋友，包括老朋友。

---

### [00:55:03] Brian Chesky (Continued)

**English:**
So I have a group of high school friends, we have a group chat and we take one to two trips together a year. I have a group of college friends, we have a group chat. We take probably a couple trips together a year. By the way, doing Airbnbs are great. We all get in a house together and it's like your opportunity to have a shared experience. And if you don't travel with your old friends, you'll have only old stories to talk about and then you say the same old stories over and over. So you want to be able to have new shared experiences. When I stay here in New York City ... I'm in New York right now. That's why you don't see my typical background. I stay in my sister's apartment. So she's got a two bedroom and I stay in her house because I like to see her. And I just make sure I spend a lot of time with friends. And of course we travel. Traveling is what I do with a lot of my friends. And then I like to draw and read. So I try to make sure it's health, work and relationships. And I try to make sure I have a balance of each. And you might call family relationships. I'm single, but that would be another version of it.

**中文翻译:**
我有一群高中朋友，我们有一个群聊，每年一起去旅行一两次。我有一群大学朋友，也有一个群聊，每年大概一起旅行几次。顺便说一句，住 Airbnb 太棒了，我们大家住在一栋房子里，这是拥有共同体验的机会。如果你不和老朋友一起旅行，你就只有老掉牙的故事可以聊，然后一遍又一遍地重复那些旧事。所以你希望能有新的共同体验。当我待在纽约市时……我现在就在纽约，这就是为什么你没看到我典型的背景。我住在我姐姐的公寓里。她有一个两居室，我住在她家是因为我想见她。我确保花很多时间和朋友在一起。当然，我们也会旅行，旅行是我和很多朋友一起做的事。然后我喜欢画画和阅读。所以我努力确保健康、工作和人际关系的平衡。你也可以把家庭归为人际关系。我是单身，但那是另一种形式。

---

### [00:56:02] Lenny

**English:**
I heard you say along the same lines on a different podcast about how when you're really busy, you didn't have time to reach out to anyone and they never thought they could reach out to you because they thought you were so busy.

**中文翻译:**
我听你在另一个播客上也说过类似的话，关于当你真的很忙时，你没时间联系任何人，而他们也从没想过联系你，因为他们觉得你太忙了。

---

### [00:56:12] Brian Chesky

**English:**
In the old world, I was reacting, so everyone thought I was busy. So the people I really cared about, a lot of them said, "Well, he's busy so he'll reach out to me when he's not busy." But here's a problem. I was so busy that all I was doing all day was responding to people. And so if people I cared about didn't reach out to me, I was dealing with incoming. I could barely deal with the incoming. Now that was a mistake. But I was reacting. By the way, here's another lesson for founders. A lot of founders spend their time based on reacting. So people will email them and they'll wake up and they'll respond to emails, and suddenly their email sets the agenda. People ask for meetings, and suddenly the meetings they take are based on the people who email them. Versus here's my strategy and then over the next year, what are the relationships I need to have and the meetings I need to take to be able to execute this strategy?

**中文翻译:**
在旧模式下，我一直在被动应对，所以每个人都觉得我很忙。我真正关心的人中，很多人会说：“好吧，他很忙，等他不忙的时候会联系我的。”但问题是：我忙到整天都在回复别人。所以如果我关心的人不联系我，我一直在处理被动收到的信息，我几乎无法处理完。那是个错误。但我当时是在被动应对。顺便说一句，这是给创始人的另一个教训：很多创始人把时间花在被动应对上。人们给他们发邮件，他们醒来就回邮件，突然间邮件决定了他们的日程。人们请求开会，突然间他们参加的会议是基于谁给他们发了邮件。而正确的做法应该是：这是我的战略，在接下来的一年里，为了执行这个战略，我需要建立哪些关系，需要参加哪些会议？

---

### [00:57:05] Brian Chesky (Continued)

**English:**
If my life were to end in a year or in 10 years or some time horizon that's shorter than I expected, who are the people I would've wanted to make sure I spent time with? And if you imagine that your life is finite, because it is, and you imagine you're not going to be here as long as you thought you would be, because it's possible, it would completely change how you prioritize your time. I think suddenly you would start to say no to things and you'd say yes to other things. I now try to say no to what I call fake work, which is things that feel like work, but they don't actually move the ball down the field. And I really try to say yes to the work that's very meaningful and people that are very meaningful to me. So yeah, it's a really, really good insight. And by the way, that metaphor, Lenny, but it's true of companies too. You can sometimes be ... You don't want to only spend your time reacting or spending your time with the employees reaching out to you. You do want to do some of it, but then you're rewarding only one type of behavior and the introverts or the people that aren't reaching out to you aren't going to get any attention.

**中文翻译:**
如果我的生命在一年或十年内结束，或者比我预期的更短，我最想确保花时间陪伴的人是谁？如果你想象生命是有限的（事实确实如此），想象你不会像你以为的那样活那么久（这完全有可能），这会彻底改变你排列时间优先级的方式。我想突然间你会开始对某些事情说“不”，对另一些事情说“是”。我现在努力对所谓的“虚假工作”（fake work）说不，即那些感觉像在工作但实际上并没有推动进展的事情。我真的努力对非常有意义的工作和对我非常有意义的人说是。所以，是的，这是一个非常好的见解。顺便说一句，Lenny，这个比喻对公司也适用。你有时会……你不想只花时间在被动应对上，或者只花时间在那些主动找你的员工身上。你确实需要做一部分，但那样你只奖励了一种行为，而那些性格内向或没主动找你的人就得不到任何关注。

---

### [00:58:14] Lenny

**English:**
Just one more question and then I have a quick fun question at the end. I know you have to run. If I were to ask people who are the most inspiring leaders in tech and in business in general, I think you'd be right near the top of that list. You've been through a lot of ups and downs, you've learned a lot of lessons along the way. What have you found has been most helpful to helping you continue to grow and keep up with the business, the way the business has grown, the scale and just to take on this leadership role? Is it coaching? Is it reading? Is it other mentors? Something along those lines.

**中文翻译:**
最后一个问题，然后最后有一个简短有趣的提问。我知道你得走了。如果我问人们谁是科技界和商界最鼓舞人心的领袖，我认为你一定名列前茅。你经历了很多起伏，一路上学到了很多教训。你发现什么对你持续成长、跟上业务发展规模并承担起这个领导角色最有帮助？是教练辅导？是阅读？还是其他导师？或者是类似的东西。

---

### [00:58:46] Brian Chesky

**English:**
You ask really good questions. And by the way, thank you. I'll share a few thoughts. I was with Sam Altman probably a few weeks ago at dinner, and I told him, "I still feel like I have a lot to prove. I haven't made it yet." And he was really surprised. He's like, "What are you talking about?" And I didn't even realize that he thought that was an absurd notion, but I said, no, I haven't made it yet. It's not to say I'm not grateful or I feel like I need to get somewhere so that therefore I'll feel worthy. But I have this beginner's mindset that the bigger I get, the more a beginner I tend to feel. It's a weird feeling. I think when I first took off, I think I thought I knew everything or I knew more than I certainly did. But then you get past some peak or you go into this trough where you realize, oh my God, the moment you get to some frontier of knowledge, you start to become a beginner again and everything is new.

**中文翻译:**
你问的问题非常好。顺便说声谢谢。我分享几点想法。大概几周前我和 Sam Altman 一起吃晚饭，我告诉他：“我仍然觉得我还有很多东西要证明，我还没‘成功’呢。”他非常惊讶，说：“你在说什么呢？”我甚至没意识到他觉得这个想法很荒谬，但我说，不，我还没成功。这并不是说我不感激，或者我觉得我需要达到某个高度才能感到自己有价值。但我有一种“初学者心态”（beginner's mindset），即我做得越大，我往往越觉得自己像个初学者。这是一种奇怪的感觉。我想当我刚起步时，我以为我无所不知，或者至少比实际知道的多。但当你越过某个巅峰或进入低谷时，你会意识到，天哪，当你到达知识的某个前沿时，你又重新成为了初学者，一切都是崭新的。

---

### [00:59:49] Brian Chesky (Continued)

**English:**
And so I think the first thing I try to do is to be a beginner. Pablo Picasso had a saying. He said, "It took me four years to learn to paint like Raphael, but a lifetime to learn to paint like a child." And so I've tried to always see the world through the eyes of a child. And I think one of the key characteristics of a child is curiosity. To see everything with fresh eyes. To not have too many judgments. When I was trying to figure how to run the company, I studied the history of divisional organizations and I studied Steve Jobs, but also studied what Bill Gates did. And I studied Alfred Sloan at General Motors that MIT Sloan is named after. And actually the founding of divisional companies, which I believe was DuPont. They were making powder for gunpowder. The war ends. What do we do with powder? Turns out powder can be used for paint, but the way you sell gunpowder and paint are different sales channels so they created what we now know as the divisional structure.

**中文翻译:**
所以我认为我尝试做的第一件事就是成为一个初学者。毕加索有一句名言：“我花了四年时间画得像拉斐尔，却花了一辈子时间画得像个孩子。”所以我一直努力通过孩子的眼睛看世界。我认为孩子的一个关键特征就是好奇心。用新鲜的眼光看一切，不要有太多的评判。当我试图弄清楚如何管理公司时，我研究了事业部制组织的历史，研究了史蒂夫·乔布斯，也研究了比尔·盖茨的做法。我研究了通用汽车的阿尔弗雷德·斯隆（Alfred Sloan，麻省理工斯隆商学院就是以他命名的）。实际上，事业部制公司的创立者我认为是杜邦公司。他们当时在制造火药粉。战争结束了，粉末怎么办？结果发现粉末可以用来做油漆，但销售火药和油漆的渠道不同，于是他们创造了我们现在所知的事业部结构。

---

### [01:00:46] Brian Chesky (Continued)

**English:**
So I try to understand the sources of things. I try to learn. I try to be shameless about reaching out to help. I think that a lot of people are afraid to reach out to help because they think other people are busy. The biggest honor most people get in their lives, or one of the biggest honor is when other people ask them for help. Because we all just want to feel useful. So don't feel ashamed to reach out to something for help. It gives a lot of them great honor. And I think you don't need to reach out to people 10 years ahead of you. They can just be people a year ahead of you. In fact, an entrepreneur getting started, I might be less youthful than somebody two years ahead of them that knows the latest distribution channels that I have forgotten. So I think that that is the key. It's learning, it's growing, it's curiosity. It's constantly having that hunger and that fire to always want to be better. To feel like I haven't made it yet. Because the reason I say I haven't made it yet is because if I've made it, then I'm done. And I want to feel like an artist. Bob Dylan used to say, "An artist has to be in a constant place of becoming and so long as they don't become something, then they're going to be okay."

**中文翻译:**
所以我试图理解事物的源头。我努力学习。我努力厚着脸皮去寻求帮助。我认为很多人害怕寻求帮助，因为他们觉得别人很忙。大多数人一生中获得的最大荣誉之一，就是别人向他们寻求帮助。因为我们都想感到自己是有用的。所以不要为寻求帮助感到羞耻，这会给很多人带来巨大的荣誉感。而且我认为你不需要找领先你 10 年的人，他们可以只是领先你 1 年的人。事实上，对于一个刚起步的企业家来说，我可能不如一个领先他们两年、了解我早已忘记的最新分发渠道的人更有用。所以我觉得这就是关键：学习、成长、好奇心。不断保持那种渴望和火焰，总是想要变得更好。感觉自己还没成功。因为我说我还没成功的原因是，如果我成功了，那我就结束了。我想感觉自己像个艺术家。鲍勃·迪伦曾说：“艺术家必须处于一种不断的‘生成’状态，只要他们还没‘变成’某种东西，他们就会没事的。”

---

### [01:02:05] Brian Chesky (Continued)

**English:**
And so you have to always be evolving, learning, growing, and the canvas keeps getting bigger. The mountaintop keeps getting higher. And I feel like I'm just getting started and I hope that ... I don't know how long you intend to do the podcast, but I intend to do this for a long time and if you do or whatever, we'll definitely want to have talks. And I hope years from now, Lenny, I hope 70% of what I said I still believe, but if 100% of what I say, I still believe then I probably haven't learned very much. And so if 90% I say I don't believe anymore than I'm delusional and wrong. But I sincerely hope that I retract it or change or modify a few things I said today in a few years, because that will mean that I've gained more wisdom. And so how do I do that? By being curious.

**中文翻译:**
所以你必须不断进化、学习、成长，画布会越来越大，山峰会越来越高。我觉得我才刚刚开始。我不知道你打算办这个播客多久，但我打算把这件事做很久，如果你也继续办下去，我们肯定还会交流。Lenny，我希望几年后，我今天说的话里有 70% 我仍然相信；但如果 100% 我都还相信，那我可能没学到什么东西。如果 90% 我都不再相信了，那我就是妄想且错误的。但我真诚地希望几年后我会撤回、改变或修改今天说的一些话，因为那意味着我获得了更多的智慧。我该怎么做呢？通过保持好奇心。

---

### [01:02:59] Lenny

**English:**
That is beautiful. It reminds me, you mentioned Sam Altman. There's a tweet that he put out a couple of weeks ago that I'll read real quick. "Many people have reached out to offer help and advice over the past year. No one has gotten close to Brian Chesky in terms of delivering. He will take a midnight call at any time, put in hours of work on any topic, answer difficult questions correctly with clarity, make any intro, et cetera." How does that feel to have seen that?

**中文翻译:**
说得太好了。这让我想起你提到的 Sam Altman。他在几周前发了一条推特，我快速读一下：“过去一年里，很多人主动提供帮助和建议。在执行力方面，没有人能接近 Brian Chesky。他随时会接听午夜电话，在任何话题上投入数小时的工作，清晰准确地回答难题，引荐任何人脉，等等。”看到这些你有什么感觉？

---

### [01:03:23] Brian Chesky

**English:**
I had no idea he was going to do that. And I just want to say I think Sam is obviously a once in a generation founder. I think what he's done with OpenAI is extraordinary. And when he launched ChatGPT I had known him for a real long period of time, and I knew a sense of the journey he was about to go on. And I think that he was very deep into the technical part and then research part of OpenAI. But it turned out there was a product, a design, a marketing, a leadership, a sales. So there were all these other functional responsibilities. And so being able to just play a small part in giving some advice when necessary ... And he would take what he wanted and discard others. But I think, Lenny, maybe this goes to another thing, which is all I tried to do with Sam was what other people did for me.

**中文翻译:**
我完全没想到他会发那条推特。我只想说，我认为 Sam 显然是这一代人中难得一见的创始人。我认为他在 OpenAI 所做的一切是非凡的。当他发布 ChatGPT 时，我已经认识他很长时间了，我能感受到他即将踏上的旅程。我认为他当时非常深入 OpenAI 的技术和研究部分。但事实证明，还有产品、设计、营销、领导力、销售等所有这些其他的职能职责。所以，能够在必要时提供一些建议，尽一点微薄之力……他会采纳他想要的，舍弃其他的。但是，Lenny，也许这涉及另一件事，那就是我对 Sam 所做的一切，正是别人曾为我做过的。

---

### [01:04:13] Brian Chesky (Continued)

**English:**
Before Y Combinator, there was a person named Michael Seibel. He's in Y Combinator. And he used to meet with me and give me advice. And he wasn't an official advisor, he wasn't an investor. I didn't hire him or anything like that. He wasn't on my board. And I asked him, I said, "How do I repay you?" And he said, "Well, I want you to pass this on to other founders." And I would meet with a lot of people in the valley, and there was just this incredible culture of generosity that we all were going to win if the ecosystem was healthy. And the ecosystem would be healthy if we all helped one another. And you pay it forward. I think that it's just one continuation of the valley of people helping one another, learning from one another. And I also feel like I learned by teaching as well.

**中文翻译:**
在进入 Y Combinator 之前，有一个人叫 Michael Seibel，他在 YC 工作。他以前经常见我并给我建议。他不是正式顾问，不是投资者，我没雇佣他，他也不在我的董事会里。我问他：“我该怎么报答你？”他说：“我希望你把这些传给其他创始人。”我在硅谷见过很多人，那里有一种令人难以置信的慷慨文化：如果生态系统健康，我们都会赢。而如果我们互相帮助，生态系统就会健康。这就是“代代相传”（pay it forward）。我认为这只是硅谷人们互相帮助、互相学习的一种延续。我也觉得我在教别人的过程中也学到了东西。

---

### [01:05:03] Lenny

**English:**
Final question. When someone joins Airbnb, there's a very longstanding tradition of sharing a fun fact about yourself. It might be the longest standing tradition. It's always tough on the spot, but I'm curious, Brian, if there's a fun fact that you want to share about yourself that maybe people don't already know.

**中文翻译:**
最后一个问题。当有人加入 Airbnb 时，有一个非常悠久的传统，就是分享一个关于你自己的“趣事”（fun fact）。这可能是最悠久的传统了。当场想总是很难，但我很好奇，Brian，有没有什么大家可能还不知道的关于你的趣事想分享？

---

### [01:05:18] Brian Chesky

**English:**
Yeah. A fun fact about me is that I actually spent most of my life as an artist. When I was five years old I remember my parents take me to the Norman Rockwell museum and I would sit in front of his beautiful illustrations. They're really paintings I should say. I shouldn't even call them illustrations. And I would try to reproduce them. And I got obsessive with art. I remember when I was maybe in elementary school, I asked Santa for poorly designed Christmas toys so I could redesign them. When I got older, one of my friends, I went to his house ... I'm going to say I was eight or nine years old. And his dad was basically redoing his deck, but his dad decided to design it himself. I think maybe he was an architect. So he had this giant dining room table, and he had this vellum paper and he had a T-square and a drawing triangle and a protractor. They were really cool looking tools, and they were basically floor plans and architectural drawings.

**中文翻译:**
是的。关于我的一个趣事是，我生命中的大部分时间其实是一个艺术家。我记得五岁时，父母带我去诺曼·洛克威尔（Norman Rockwell）博物馆，我会坐在他美丽的插画前——我应该说那是油画，甚至不该叫插画。我会尝试临摹它们。我对艺术非常痴迷。我记得大概在小学时，我向圣诞老人要那些“设计拙劣”的圣诞玩具，这样我就可以重新设计它们。当我长大一点，去一个朋友家……大概八九岁吧，他爸爸正在翻新露台，但他爸爸决定自己设计。我想他可能是一名建筑师。他有一张巨大的餐桌，上面铺着牛皮纸，还有丁字尺、绘图三角板和量角器。那些工具看起来酷毙了，基本上都是平面图和建筑图纸。

---

### [01:06:15] Brian Chesky (Continued)

**English:**
So I got into architectural and landscape design when I was like eight or nine, and that led to my interest in architecture. I went to RPI when I was in freshman year of high school to do a pre-college program. Then I got into more and more drawing and figure drawing. Then I got into a film and animation. Then I got involved in environmental design. I realized that if you buy stock in a company, you could get these cool glossy annual reports. This is when the internet was nascent and people still mailed the annual reports. As so I got my dad to buy a few shares at some Disney stock. And I got these renderings and he had a report of theme parks. And I started drawing and designing theme parks in communities.

**中文翻译:**
所以我在八九岁时就迷上了建筑和景观设计，这引发了我对建筑的兴趣。高一那年我去了 RPI（伦斯勒理工学院）参加大学预科项目。然后我越来越深入地学习绘画和人体素描。接着我接触了电影和动画。然后我参与了环境设计。我意识到如果你买了一家公司的股票，你就能得到那些酷炫光滑的年报。那是互联网刚起步的时代，人们还在邮寄年报。所以我让我爸买了几股迪士尼的股票。我得到了那些效果图，他有一份关于主题公园的报告。于是我开始在社区里画画和设计主题公园。

---

### [01:07:00] Brian Chesky (Continued)

**English:**
And I was at this private school actually for hockey. Because I had this life where I was playing ice hockey and I thought I was going to play college hockey. My dad was really into it. I was really into it. And I had an art teacher in high school at this military school. That's another fun fact. I basically went to a military high school.

**中文翻译:**
我当时在一所私立学校，其实是为了打冰球。因为我当时的生活就是打冰球，我以为我会去打大学冰球。我爸很投入，我也很投入。在那所军事化学校里，我有一位美术老师。这是另一个趣事：我基本上上的是一所军事高中。

---

### [01:07:21] Lenny

**English:**
Wow. I did not know that.

**中文翻译:**
哇，我以前不知道这个。

---

### [01:07:22] Brian Chesky

**English:**
And at this military sports academy oriented high school, I had the same art teacher from eighth grade to 11th grade. And that's not a good thing, by the way. I don't say it as a good thing because I was not diversifying my skills. And so I leave this high school because I wanted to pursue different interests than hockey. And I transferred to my public high school late my junior year. And imagine transferring to a new public high school late junior year. And I meet my art teacher who changes my life. Her name is Ms. Williams, and she sees my artwork. And by the way, my mom was nervous about me becoming an artist. She used to tell me, "I chose a job for the love, and I got paid no money. So you should choose a job that pays you a lot of money." And I said to my mom, "One day, I'm going to be an artist." She said, "Oh my God, you chose the only job where you're going to paid less than a social worker." So I think my parents, they were supportive of me going to art, but they were very nervous. And then Ms. Williams told my mom, she said, "Don't worry. He's going to be a famous artist one day." I wasn't going to become a famous artist. But what that did is I think it gave everyone the confidence for me to pursue art.

**中文翻译:**
在那所偏向体育学院的军事高中，我从八年级到十一年级都是同一个美术老师。顺便说一句，这并不是件好事，因为我的技能没有多样化。后来我离开了那所高中，因为我想追求冰球以外的兴趣。我在高三快结束时转到了一所公立高中。想象一下在高三快结束时转到一所新的公立高中。在那儿我遇到了改变我一生的美术老师，她叫 Williams 女士。她看到了我的作品。顺便说一句，我妈当时对我成为艺术家很紧张。她常对我说：“我选了一份出于热爱的职业，结果没赚到钱。所以你应该选一份能赚大钱的工作。”我对她说：“总有一天，我会成为一名艺术家。”她说：“天哪，你选了唯一一个比社工赚得还少的职业。”所以我认为我父母虽然支持我学艺术，但非常担心。然后 Williams 女士告诉我妈：“别担心，他总有一天会成为著名的艺术家。”我并没有成为著名的艺术家，但那句话给了每个人信心，让我去追求艺术。

---

### [01:08:31] Brian Chesky

**English:**
I ended up being a winner, there were multiple winners, of a national art competition, and I had my artwork displayed in the Rotunda Gallery. That then led to me getting a scholarship at the Rhode Island School of Design where I ended up going to RISD. It's like MIT for design or whatever. It's a prestigious art and design school. But I got to RISD and I realized I was born 100 years too late for what I wanted to do, which is draw and paint. And I felt like at that point, photography and now AI generated art, but certainly even back then, photography was replacing a lot of the skills that I had. And that's when I was in my freshman year of college and I learned about a field called industrial design. They said industrial design is the design of everything from a toothbrush to a spaceship and everything in between.

**中文翻译:**
我最终成为了一项全国艺术竞赛的获胜者（当时有几位获胜者），我的作品在 Rotunda 画廊展出。这让我获得了罗德岛设计学院（RISD）的奖学金，我最终去了 RISD。它就像是设计界的麻省理工。那是一所享有盛誉的艺术与设计学院。但我到了 RISD 后意识到，对于我想做的事情（绘画），我晚出生了 100 年。我觉得在那个时间点，摄影（现在是 AI 生成艺术，但当时是摄影）正在取代我拥有的很多技能。就在我大一的时候，我了解到一个叫“工业设计”的领域。他们说工业设计是设计从牙刷到宇宙飞船以及其间的一切。

---

### [01:09:26] Brian Chesky (Continued)

**English:**
And really, Lenny, maybe just to round out the story, because that was a fun fact, but I'm just ... And this is the pre founding story that I never tell. I don't think I could have ever done what I did if I wasn't an industrial designer. I think industrial designer is different than a graphic designer. Because an industrial designer, you have to work with engineering in your training. I worked with mechanical engineers, electric engineers. You have to understand manufacturing. Industrial design's very accountable to sales. If you design a building, an architect, and you design an office building and the office building doesn't get leased, the architect's usually not on the hook for it. But if you're an industrial designer and you design a product, it doesn't sell, you're on the hook for it. At least people assume you didn't design a good product. So you had to understand marketing and strategy.

**中文翻译:**
Lenny，为了把这个故事讲完，虽然这只是个趣事，但……这是我从未讲过的创业前传。如果我不是一名工业设计师，我不认为我能做到我所做的一切。我认为工业设计师与平面设计师不同。因为作为工业设计师，你在训练中必须与工程部门合作。我曾与机械工程师、电子工程师合作。你必须了解制造。工业设计对销售非常负责。如果你是建筑师，设计了一栋办公楼，如果办公楼租不出去，建筑师通常不需要负责。但如果你是工业设计师，设计了一个产品却卖不出去，你就得负责。至少人们会认为你没设计好产品。所以你必须了解营销和战略。

---

### [01:10:11] Brian Chesky (Continued)

**English:**
And so that became this gateway. But I didn't really want to make items and objects my whole life. At RISD, the biggest value I got in addition to learning industrial design was I met my co-founder, Joe Gebbia. And the day of graduation Joe looks to me, he says, "Brian, I think we're going to start a company together one day." And I had no idea what he was referring to. So I moved to Los Angeles where I work as an industrial designer for two years when one day I got a package in the mail that changed my life. I opened this package and it's a seat cushion with a handle on it. And it's a letter from Joe, my friend from RISD. He said, "I started a company and everyone in San Francisco ... I live in San Francisco and all these people are starting companies. You should come here." And this is in 2007. YouTube had just come out. I had seen all these Steve Jobs keynotes finally on YouTube. I didn't know who he was. I'd never heard his voice before YouTube. And Apple had this renaissance and Google was on fire and Facebook was taking off. And it felt like the gears of the world that were turning were in San Francisco.

**中文翻译:**
所以这成了一个入口。但我并不想一辈子只制造物品。在 RISD，除了学习工业设计，我获得的最大价值是遇到了我的联合创始人 Joe Gebbia。毕业那天，Joe 看着我说：“Brian，我想总有一天我们会一起创办一家公司。”我当时完全不知道他在指什么。后来我搬到洛杉矶当了两年的工业设计师，直到有一天我收到一个改变我一生的包裹。我打开包裹，里面是一个带把手的座垫。那是 Joe（我 RISD 的朋友）寄来的一封信。他说：“我开了一家公司，旧金山的每个人……我住在旧金山，这里所有人都在创业，你应该来这儿。”那是 2007 年。YouTube 刚出现，我终于在 YouTube 上看到了史蒂夫·乔布斯所有的演讲。在 YouTube 之前我甚至不知道他是谁，也没听过他的声音。当时苹果正在复兴，谷歌如日中天，Facebook 正在起飞。感觉世界的齿轮正在旧金山转动。

---

### [01:11:18] Brian Chesky (Continued)

**English:**
And so one day I go into work and I quit my job. My boss is dumbfounded. And I pack everything in the backseat of old Honda Civic. I get to San Francisco and Joe tells me the rent is $1,150. I don't have enough money to pay our rent. This design conference is coming to San Francisco. All the hotels are sold out. We said, what if we turned our house into a bed and breakfast for the design conference? I didn't have any beds, but Joe had beds and we called it Air Bed and Breakfast.
(01:11:45):
So my fun fact was I was an artist and designer before Airbnb. Really an artist, at least how I thought about it. And I think that's maybe one of the things that makes Airbnb different. Because there's not a lot of designers or artists running Fortune 500 or S&P 500 companies. And I think that intuition, imagination, design, curiosity, I think we need more of that. By the way, I think the people listening, I think everyone on this, listen, you have these qualities. But I think that a lot of companies, it's like we're a body and the companies are cut off at the head and they're disembodied from their heart, and they're often really biased towards one side of their head. And I think that some of the greatest scientists played musical instruments like Einstein. I think that being a whole, well-rounded way of thinking about the world is good. So anyways, that's my final thought.

**中文翻译:**
于是有一天我去上班，辞掉了工作。我的老板惊呆了。我把所有东西塞进一辆旧本田思域的后座。我到了旧金山，Joe 告诉我房租是 1150 美元。我没钱交房租。当时旧金山要举办一个设计大会，所有的酒店都订满了。我们说，如果我们把房子变成设计大会期间的“床位加早餐”（bed and breakfast）呢？我没有床，但 Joe 有充气床，我们把它叫做“充气床加早餐”（Air Bed and Breakfast）。
(01:11:45):
所以我的趣事就是：在创办 Airbnb 之前，我是一名艺术家和设计师。至少在我看来，我本质上是个艺术家。我认为这也许是让 Airbnb 与众不同的原因之一。因为在财富 500 强或标普 500 强公司中，并没有很多设计师或艺术家在担任 CEO。我认为我们需要更多的直觉、想象力、设计感和好奇心。顺便说一句，我认为正在听这个播客的每个人都拥有这些品质。但我认为很多公司就像一个身体，头被切断了，与心灵分离了，而且往往偏向大脑的某一边。我认为一些最伟大的科学家也会演奏乐器，比如爱因斯坦。我认为拥有一种完整、全面的思考世界的方式是件好事。总之，这就是我的最后一点想法。

---

### [01:12:37] Lenny

**English:**
I love that fun fact because it almost explains everything you've been talking about, which is rethinking the way companies can run, doing things super differently. So I really appreciate you sharing that. I also love that it transitioned into the creation story of Airbnb, which happens a lot at Airbnb. People hear that story over and over because it's so interesting and so important. Brian, I know you have to run. Thank you so much for being here and being generous with your time.

**中文翻译:**
我喜欢这个趣事，因为它几乎解释了你刚才谈论的一切：重新思考公司的运作方式，以完全不同的方式做事。非常感谢你分享这些。我也很喜欢它自然过渡到了 Airbnb 的创业故事，这在 Airbnb 经常发生。人们一遍又一遍地听这个故事，因为它如此有趣且重要。Brian，我知道你得走了。非常感谢你能来，并慷慨地分享你的时间。

---

### [01:12:58] Brian Chesky

**English:**
Thank you, Lenny, and congratulations on everything you're doing.

**中文翻译:**
谢谢你，Lenny，祝贺你所做的一切。

---

### [01:13:01] Lenny

**English:**
Thanks Brian. Bye everyone.
(01:13:04):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
谢谢 Brian。大家再见。
(01:13:04):
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客 App 上订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。