# Cam Adams - 双语对照

以下是《Lenny's Podcast》对话 Canva 联合创始人兼首席产品官 Cameron Adams 的完整双语对照文档。

---

### (00:00:00) Lenny Rachitsky

**English:**
Canva is bigger than Figma and Miro and Webflow combined. You guys are generating $2.3 billion in ARR and you're profitable. You're also growing 60% year over year and it's accelerating.

**中文翻译:**
Canva 的规模比 Figma、Miro 和 Webflow 加起来还要大。你们每年的 ARR（年度经常性收入）高达 23 亿美元，而且已经实现盈利。你们的年增长率达到 60%，并且还在加速增长。

---

### (00:00:12) Cameron Adams

**English:**
I run everyone through the culture of Canva. One of those sections is on giving away your Lego, finding joy in the other things of building a team, passing on your experience, helping other people do great writing or great product building or great engineering.

**中文翻译:**
我会向每个人介绍 Canva 的文化。其中一个章节是关于“放弃你的乐高”（Giving away your Lego，意指学会授权和交出职责），在组建团队的其他事务中寻找乐趣，传承你的经验，帮助他人完成出色的写作、产品构建或工程开发。

---

### (00:00:25) Lenny Rachitsky

**English:**
When is this coaching concept? I've never heard of this.

**中文翻译:**
这个“教练”（Coaching）概念是什么时候提出的？我以前从未听说过。

---

### (00:00:27) Cameron Adams

**English:**
We don't really have managers, but everyone at Canva has a coach. They're constantly working with you to look at your skills, but also when it might be time to move on to the next level.

**中文翻译:**
我们其实没有传统意义上的经理，但 Canva 的每个人都有一位教练。他们会不断与你合作，审视你的技能，并探讨什么时候是你晋升到下一个阶段的时机。

---

### (00:00:37) Lenny Rachitsky

**English:**
I'm curious just how you think about product management.

**中文翻译:**
我很想知道你是如何看待产品管理（Product Management）的。

---

### (00:00:39) Cameron Adams

**English:**
I didn't want to do product management like they did at Google, and that's because of the different cultures. I have seen product managers at other companies who are very independent of teams and that seems very weird to me. For us, product managers are really connected.

**中文翻译:**
我不想像谷歌那样做产品管理，这是因为文化不同。我见过其他公司的产品经理与团队非常疏离，这在我看来很奇怪。对我们来说，产品经理是紧密连接各方的纽带。

---

### (00:00:50) Lenny Rachitsky

**English:**
It feels like Canva has just been this non-stop up into the right all win, all success. In reality, that's never actually the case.

**中文翻译:**
感觉 Canva 一直在不断攀升，一路赢到底，全是成功。但在现实中，情况绝非如此。

---

### (00:00:56) Cameron Adams

**English:**
How many failure stories do you want? We got plenty.

**中文翻译:**
你想听多少失败的故事？我们多的是。

---

### (00:01:03) Lenny Rachitsky

**English:**
Today, my guest is Cameron Adams. Cameron is the co-founder and chief product officer at Canva, which is a truly incredible business and company. At the top of the episode, I share a bunch of stats. They'll probably surprise you about the scale that Canva has reached these days.
(00:01:19):
In our conversation, we cover a ton of ground including how Canva stays product obsessed, their freemium strategy, lessons about building MVPs, how Cam and the product team think about AI within their product, also peek into their unique team culture, their SEO and growth strategy, and also peek into some of the stuff they just launched.
(00:01:37):
This episode is for anyone building or growing a product or company, and I guarantee by the end of this conversation, you'll be as blown away with Canva as I am. With that, I bring you Cameron Adams. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously.
(00:02:01):
Cameron, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Cameron Adams。Cameron 是 Canva 的联合创始人兼首席产品官，这是一家真正令人惊叹的企业。在节目开始时，我分享了一系列数据，Canva 如今的规模可能会让你大吃一惊。
(00:01:19):
在我们的对话中，我们涵盖了大量内容，包括 Canva 如何保持对产品的痴迷、他们的免费增值（Freemium）策略、构建 MVP（最小可行性产品）的教训、Cam 和产品团队如何看待产品中的 AI、深入了解他们独特的团队文化、SEO 和增长策略，以及他们刚刚发布的一些新功能。
(00:01:37):
这一集适合任何正在构建或发展产品或公司的人，我保证在对话结束时，你会像我一样被 Canva 所震撼。下面，让我们欢迎 Cameron Adams。如果你喜欢这个播客，别忘了在订阅并关注。这是避免错过未来节目的最好方式，也对我们帮助巨大。
(00:02:01):
Cameron，非常感谢你能来，欢迎来到本播客。

---

### (00:02:04) Cameron Adams

**English:**
It is so great to be here, Lenny. I'm very excited.

**中文翻译:**
很高兴来到这里，Lenny。我非常激动。

---

### (00:02:07) Lenny Rachitsky

**English:**
I'm even more excited. I have at least a billion questions for you. I'm hoping I get through at least half a billion. There's so much I want to talk to you about, but I want to start with a warm and fuzzy question. Do you ever just take a moment to reflect on the insane success of this business that you've built? And before you answer that, I'm going to share some stats about Canva that I think are going to blow people's minds. So think about the answer.
(00:02:30):
So I was researching Canva, all of this was just... I didn't know any of this actually, and I think it'll surprise a lot of people just the scale that Canva has reached at this point. Okay. So Canva is bigger than Figma and Miro and Webflow combined both in terms of valuation and in terms of revenue. You guys are generating $2.3 billion in ARR per year and you're profitable. You've been profitable for about seven years at this point. You're also growing 60% year over year and it's accelerating, faster than last year. I think this is all quite unheard of at this scale. Do you ever just reflect back on this and, like, "Okay, I've done well."?

**中文翻译:**
我比你更激动。我有至少十亿个问题想问你，希望能问完其中的一半。我想聊的内容太多了，但我先从一个感性的问题开始：你是否曾停下来反思过你所建立的这项事业取得的疯狂成功？在你回答之前，我要分享一些关于 Canva 的数据，我觉得这会让大家大开眼界。所以请先思考一下答案。
(00:02:30):
我在研究 Canva 时，发现这些……其实我之前也不知道，我想很多人都会对 Canva 现在的规模感到惊讶。好的：无论是在估值还是收入方面，Canva 都比 Figma、Miro 和 Webflow 加起来还要大。你们每年的 ARR 达到 23 亿美元，而且已经盈利。到目前为止，你们已经连续盈利约七年了。你们的年增长率还达到了 60%，而且正在加速，比去年还快。我认为在这样的规模下，这简直是闻所未闻。你是否曾回首这一切，心想：“好吧，我做得确实不错”？

---

### (00:03:11) Cameron Adams

**English:**
When you say it all like that, it sounds pretty amazing. I don't think every day you're cognizant of that growth and that achievement, but there are particular moments where you get to really reflect, and for me, it's most of the time when we bring the team together. Obviously now we're in a pretty virtual world, hybrid in some best cases. But when the team all get together and we celebrate is when we finally have those moments where you get to step out of yourself, look at this huge sea of people and realize what you've achieved together.
(00:03:48):
Probably the most recent moment we got to do that was for our 10th birthday last year. So Canva is largely centered in Australia. We've got lots of offices around the world, but we had a big birthday celebration in Sydney right on the harbor there in front of the water and we had thousands of people there, and we just got to look back on everything we've achieved over the previous 10 years, and that was the pretty amazing moment.

**中文翻译:**
当你这么说的时候，听起来确实很了不起。我不认为每天都能意识到这种增长和成就，但在某些特定时刻，你会真正去反思。对我来说，大多数时候是当我们把团队聚在一起时。显然，现在我们处于一个相当虚拟的世界，最好的情况也是混合办公。但当团队聚在一起庆祝时，我们终于有了那些时刻，你可以跳出自我，看着这片巨大的人海，意识到大家共同取得的成就。
(00:03:48):
最近一次这样的时刻是去年我们的 10 周年庆典。Canva 的总部主要在澳大利亚，虽然我们在全球有很多办公室，但我们在悉尼海港的水边举行了一场盛大的生日庆典。现场有几千人，我们回顾了过去 10 年所取得的一切，那真的是一个非常奇妙的时刻。

---

### (00:04:11) Lenny Rachitsky

**English:**
What about just personally, you basically went from a designer on Google Wave to a co-founder of one of the most generational successful startups in the past decade. How does that feel?

**中文翻译:**
那个人层面呢？你基本上是从 Google Wave 的一名设计师，变成了过去十年中最具代际成功意义的初创公司之一的联合创始人。这种感觉如何？

---

### (00:04:24) Cameron Adams

**English:**
I still think I'm constantly growing, I'm constantly learning stuff. I don't feel like I've achieved a ceiling or being a massive smash hit. We're always changing how we're doing things. We're always doing things we've never done before and we feel totally like a fish out of water. So yeah, I've achieved a few things personally, but I still feel like there's so much more to go.

**中文翻译:**
我仍然觉得自己是在不断成长，不断学习新东西。我不觉得我已经达到了天花板，或者成了一个巨大的成功典范。我们总是在改变做事的方式，总是在做以前从未做过的事情，有时感觉完全像“离水的鱼”一样不知所措。所以，是的，我个人取得了一些成就，但我仍然觉得还有很长的路要走。

---

### (00:04:50) Lenny Rachitsky

**English:**
That sounds right. I want to talk about the flip side from the outside, like I described, it feels like Canva has just been this non-stop up into the right all win, all success, just killing it all the time. In reality, that's never actually the case. It's often really helpful for people to hear a story of, okay, there's actually this moment of this may be all falling apart or a struggle for yourself. Is there a moment that comes to mind of just like, "Oh, man, this was really scary and hard for me."?

**中文翻译:**
听起来很对。我想谈谈另一面。从外界看，就像我描述的那样，Canva 似乎一直在势如破竹地获胜，从未停歇。但在现实中，情况并非如此。让大家听听那些“一切可能都要崩盘”或“个人挣扎”的故事通常很有帮助。你脑海中是否有一个时刻，让你觉得“天哪，这对我来说真的太可怕、太艰难了”？

---

### (00:05:17) Cameron Adams

**English:**
I think there's probably a few different stories that would resonate with your audience because there's like business kind of stories of how the actual company's tracking. There's product stories of stuff we launched that didn't go anywhere. There's team stories where you're dealing with people and all the different quirks that entails. I think I'll choose a business story. There was a moment around our 100 million valuation mark where we were putting together around... We had a lot of existing investors who were really keen to invest. This is probably our third or our fourth round by this stage, and it was all looking good. There was a particular investor who was really to lead out. We were fine with that. They were doing due diligence, got to the stage where every other investor in the round had signed on. They were super excited. They'd wired the money into our bank accounts already. They'd signed all the long docs but lead investor.
(00:06:15):
And about two days before they were due to sign and get all the money into our account, they came back and said, "Look, business is going great, but essentially we think we can get a better deal, so we're going to cut your valuation by 50%." It was a huge surprise and totally screwed up the entire round. All the other investors were like, "What the hell are you doing?" My co-founders, Mel and Cliff, pretty much jumped on a plane that night to go to Silicon Valley, rallied around a whole bunch of other investors, found a new lead investor, took them about a week. This was the week right before Christmas. It was incredibly stressful, incredibly tumultuous.
(00:07:05):
We eventually came out of it better. We actually got better terms on the deal that we came up with. That investor has fallen to the wayside now and it was a real learning moment for us in terms of how to approach fundraising and also how to be totally independent, and that's one of the reasons why we've focused on profitability for so long now. We've been profitable to spend the seven years and one of the reasons is that we never want to be put in the situation where we have to go to someone for money to ensure the survival of the business, and being profitable means that we never have to do that. We can always do it on our own terms and in our own time.

**中文翻译:**
我想可能有几个不同的故事能引起听众的共鸣，比如关于公司运营的商业故事，关于产品发布后石沉大海的产品故事，或者是关于处理人际关系及其各种怪癖的团队故事。我选一个商业故事吧。在我们的估值达到 1 亿美元左右时，我们正在筹备一轮融资……当时有很多现有投资者非常渴望跟投。这大概是我们的第三或第四轮融资，一切看起来都很顺利。有一位特定的投资者非常想领投，我们也同意了。他们进行了尽职调查，到了除了领投方以外的所有投资者都已签约的阶段。大家都非常兴奋，钱已经汇入我们的账户，所有长篇文档都签好了，唯独缺领投方。
(00:06:15):
就在他们原定签约并放款的前两天，他们回来对我们说：“听着，业务发展得很好，但本质上我们觉得能拿到更好的价格，所以我们要把你们的估值削减 50%。”这太让人意外了，完全搞砸了整轮融资。其他投资者都傻眼了：“你们到底在干什么？”我的联合创始人 Mel 和 Cliff 当晚就飞往硅谷，召集了一大批其他投资者，寻找新的领投方，花了大约一周时间。那是圣诞节前的一周，压力巨大，动荡不安。
(00:07:05):
最终我们的结果反而更好了，新交易的条款甚至更优。那位投资者现在已经出局了。这对我们来说是一个真正的学习时刻，关于如何进行融资，以及如何保持完全的独立性。这也是为什么我们长期以来一直专注于盈利的原因之一。我们已经盈利七年了，原因之一就是我们永远不想陷入必须求人给钱才能生存的境地。盈利意味着我们永远不必那样做，我们可以始终按照自己的节奏和条件行事。

---

### (00:07:49) Lenny Rachitsky

**English:**
Something that I've heard from one of your investors actually will not be named is that at your board meetings, you have one slide on the financials of the business and then the rest of the deck is product updates, the roadmap. I think this is very rare, especially for companies at your stage that become really focused on financials in the business from the CFO perspective and a lot of founders lose sight of the product. Can you just talk about this element of how you all think about the product that's so central to the business?

**中文翻译:**
我从你们的一位投资者（不便透露姓名）那里听说，在你们的董事会上，关于公司财务的幻灯片只有一张，剩下的全是产品更新和路线图。我认为这非常罕见，尤其是对于你们这个阶段的公司，通常会从 CFO 的角度变得非常关注财务，很多创始人会因此忽视产品。你能谈谈你们是如何看待产品在业务中的核心地位的吗？

---

### (00:10:32) Cameron Adams

**English:**
I think one key thing is that we don't know it's very rare. We approach a board meeting just like we do anything, we craft the experience about how we think it should be and how we think it's going to be useful. So just like our board meetings or our product meetings or the way that we do launches, we have shaped that in the image that we want it to be and in the way that we think it's going to be most effective. We've always been an incredibly product-led company. We always think first and foremost about the product. That was the whole genesis of Canva itself, having a product that we thought people would love to use and desperately needed to get out into the world and that's the lens that we approach everything through.
(00:11:13):
In terms of board meetings, I think it's been very helpful that our financials and our growth have been amazing for so many years that we don't need to focus on it and we can just have that one slide with the graph going up and to the right. We've also attracted investors who believe in us and who understand that us driving product and getting as much product value out to our customers is probably the most important thing we can be doing. So that's why the board meetings do focus on that because what we are launching in the product, what's ahead is really determining the success of the company. Obviously, financials are important and you can do a bunch of lever pulling and thinking about margins and all that kind of stuff, but product is at the end of the day the most important thing to Canva and the thing that's going to help us stand out and continue to have success.

**中文翻译:**
我觉得关键的一点是，我们并不知道这很罕见。我们对待董事会就像对待其他事情一样：我们会根据自己认为应该的样子以及认为有用的方式来打造这种体验。所以，无论是董事会、产品会议还是发布会，我们都按照自己想要的形象和认为最有效的方式来塑造。我们一直是一家极其“产品驱动”（Product-led）的公司。我们始终首要考虑产品。这正是 Canva 诞生的初衷——拥有一款我们认为人们会喜爱并迫切需要推向世界的产品，这就是我们审视一切的视角。
(00:11:13):
至于董事会，我觉得很有利的一点是，多年来我们的财务状况和增长一直非常出色，以至于我们不需要过多关注它，只需要展示那张曲线一直向右上方增长的图表即可。我们也吸引了那些相信我们、并理解“推动产品创新并为客户提供最大产品价值”才是最重要事情的投资者。所以董事会确实专注于此，因为我们在产品中发布的内容以及未来的规划真正决定了公司的成功。显然，财务很重要，你可以进行各种杠杆操作或考虑利润率，但归根结底，产品才是 Canva 最核心的东西，也是帮助我们脱颖而出并持续成功的关键。

---

### (00:12:02) Lenny Rachitsky

**English:**
I really like this point you made about how you didn't know any better almost, and it reminds me of something else I heard about Canva. It took you guys a long time to hire outside execs. Almost all your leaders are homegrown and it took you a long time to even hire outside of Australia. Its even higher in the US. Can you just talk about why that's been so important and just the impact that has come out of hiring people internally and helping people be promoted internally?

**中文翻译:**
我很喜欢你说的“因为不知道（常规做法）所以才这么做”这一点，这让我想起了关于 Canva 的另一件事。你们花了很长时间才开始聘请外部高管，几乎所有的领导者都是内部培养的。你们甚至花了很长时间才开始在澳大利亚以外的地方招聘，更不用说在美国招聘了。你能谈谈为什么这如此重要，以及内部招聘和提拔人才带来了什么样的影响吗？

---

### (00:12:26) Cameron Adams

**English:**
One thing really focused on is team and culture. I think you can probably bring in the world's best person at X, Y, and Z, but if they're not fitting into your team and understanding your culture and have the same passion and vision that you do, they're not going to succeed. So it's super important that we have people along with us for the ride and that might mean everyone at Canva is awesome. They mightn't be the number one person in the world for that particular thing, but they get more done than the number one person could because they've built that trust and that safety with their team. They know how to communicate their ideas, they know how to bring other people along with them and lay out a vision in the way that we understand it at Canva, and that is a critical thing to building a great company, I think, is having that alignment across everyone, across your product teams, across your marketing teams, across your customer happiness.
(00:13:21):
They all need to be aligned and we all need to be rowing in the same direction. We have brought in leaders, and some of them have been incredibly successful. We have brought in leaders, and they've exited the company after a few months just because there wasn't that fit and they didn't manage to figure out or understand what Canva was and how to work within this big ecosystem. Now we've got 4,500 employees now and it's not just a matter of you coming in and bringing all your ideas. You also need to work together with all the other leaders that we have and the team that's surrounding you.

**中文翻译:**
我们非常关注团队和文化。我认为你或许可以请来在某方面全球最顶尖的人才，但如果他们不能融入团队、不理解你的文化，或者没有和你一样的激情和愿景，他们是不会成功的。所以，让志同道合的人一起同行至关重要。这可能意味着 Canva 的每个人都很棒，虽然他们可能不是某个特定领域的世界第一，但他们比世界第一能完成更多工作，因为他们与团队建立了信任感和安全感。他们知道如何沟通想法，知道如何带动他人，并以 Canva 理解的方式描绘愿景。我认为建立一家伟大公司的关键在于所有人——产品团队、营销团队、客户服务团队——达成共识。
(00:13:21):
大家需要步调一致，向同一个方向划船。我们也引进过外部领导者，其中一些非常成功。但也有些领导者在几个月后就离开了，仅仅是因为不契合，他们没能弄清楚或理解 Canva 到底是什么，以及如何在这个庞大的生态系统中工作。我们现在有 4500 名员工，这不仅仅是你带着想法进来的问题，你还需要与现有的所有领导者以及你周围的团队协作。

---

### (00:13:56) Lenny Rachitsky

**English:**
As a lens into what is important. Canva, when you say that they didn't understand what Canva is, what's something that doesn't click for people a lot of times that forces them to be exited potentially? What is it that's so maybe unique or important to the way you all think about stuff?

**中文翻译:**
作为一个观察窗口，当你提到有些人不理解 Canva 是什么时，通常是什么样的情况让他们无法融入，甚至最终不得不离开？你们思考问题的方式中，有哪些是如此独特或重要的？

---

### (00:14:12) Cameron Adams

**English:**
I have this theory that the type of product you're building very much influences the way that you think, and this stemmed out of a chat I was having with one of the product leaders at Spotify. And they said that at Spotify they do an incredible amount of talking about problems. They'll have a meeting, they'll talk about this new product feature and they'll just hash it out through conversation. And I imagined that that was because Spotify is a very auditory product. Everyone there thinks about music, sound, podcasts, that is their mindset. At Canva, we're all about visual communications. It's pitch decks, it's social media posts, it's video, it's t-shirts that you can make, and that's how we think about things in a very visual manner.
(00:15:01):
So one of the things that's very particular about Canva is really setting visions. And I'm in visions, not just in the sense of looking forward two, three years, but also visions in the very visual sense. We need to be able to see it. We need mock-ups. We need prototypes. You need to get that idea out of your head and present it to someone in a visual form that helps you talk about and communicate about it. That's one aspect of why some people I think don't land on their feet at Canva because they aren't necessarily visual thinkers and they don't end up communicating what they want to do in a visual way to the rest of people at Canva.
(00:15:38):
Another way is that the way that we've grown, the way that we've built product has been quite idiosyncratic over the years. And as I said, we've learned so much just through doing and established our own processes. And I think in any system, if someone comes up from the outside with preconceived notions or this idea that they're an expert and tries to bring that in, it's going to be rejected. So you really need to work together and I think the advice that I can give to people coming to Canva is just listen for a couple of months, figure out what is really working at Canva and why it works before you try and change it. We're very open to change and to new ideas, but just coming in wholesale and totally changing the process, just because that's what you've done somewhere else isn't going to get you the most level of success.

**中文翻译:**
我有一个理论：你所构建的产品类型会极大地影响你的思维方式。这源于我与 Spotify 一位产品负责人的聊天。他说在 Spotify，他们会花大量时间讨论问题。他们开会讨论新功能，纯粹通过对话来解决。我想这是因为 Spotify 是一个听觉产品，那里的每个人都思考音乐、声音、播客，那是他们的思维模式。而在 Canva，我们关注的是视觉沟通：演示文稿、社交媒体帖子、视频、定制 T 恤，这就是我们以视觉方式思考问题的原因。
(00:15:01):
所以 Canva 非常独特的一点是“设定愿景”（Setting visions）。我说的愿景不仅是指展望未来两三年，还包括字面意义上的“视觉化”。我们需要能看到它，需要模型（Mock-ups），需要原型。你需要把想法从脑子里拿出来，以视觉形式呈现给别人，这有助于交流。我认为有些人无法在 Canva 立足的原因之一就是他们不是视觉思考者，没能以视觉化的方式向其他人传达他们的意图。
(00:15:38):
另一个原因是，多年来我们增长和构建产品的方式非常独特。正如我所说，我们通过实践学到了很多，并建立了自有的流程。我认为在任何系统中，如果有人带着先入为主的观念或“专家”姿态从外部进来并试图强加这些东西，都会遭到排斥。所以你真的需要协作。我给新加入 Canva 的人的建议是：先听几个月，弄清楚 Canva 到底什么在起作用以及为什么起作用，然后再尝试改变。我们对变革和新想法非常开放，但如果仅仅因为你在别处这样做过就全盘否定并彻底改变现有流程，是不会取得成功的。

---

### (00:16:31) Lenny Rachitsky

**English:**
That makes so much sense. We're talking about cultural elements and so I have one more question around culture. I saw a video interview you did once about how you love this concept of giving away your Legos, that's part of your culture and the culture at Canva broadly potentially, and this was originally popularized by Molly Graham in this first round review article. That's something you still believe in and if so, can you just describe that concept briefly because a lot of people haven't actually heard about this?

**中文翻译:**
非常有道理。既然我们在谈论文化元素，我还有一个关于文化的问题。我曾看过你的一个视频采访，提到你非常推崇“放弃你的乐高”（Giving away your Legos）这个概念，这是你们文化的一部分。这个概念最初是由 Molly Graham 在 First Round Review 的文章中推广开来的。你现在还相信这一点吗？如果是的话，能否简要描述一下这个概念，因为很多人可能还没听说过？

---

### (00:17:00) Cameron Adams

**English:**
Yeah, Molly wrote a great article, which I actually refer everyone who joins Canva to in the cultural onboarding session, which I give them. So I run everyone through the culture at Canva and what they can expect over the next few years as they work here, and one of those sections is on giving away your Lego, and it's really important to us because part of being in a startup is scaling, when you're scaling from zero users to a million to a hundred million, and when you're scaling from three founders to 10 employees to 100 employees to 4,000 employees. You're scaling everything from the product to the internal processes you have, the finance team paying people how you deal with user feedback. Everything's just constantly growing, growing, growing. And I think this is slightly different to a traditional job where you get good at the thing that you always do and you try and turn that into a process that just continually works all the time.
(00:17:58):
As a startup, you just have to be changing and we want people who are flexible, you can bring new ideas, you can go to that next level. You can think about not just a million people, but 10 million people, 100 million people, a billion people using the product, and to constantly ratchet up that multiplier, you need to change yourself, which means that you probably need to give away some of the stuff that you're doing now in order to get to that next level. If you're the first email copywriter at Canva, you can get away from writing all the emails for the first year maybe, but when you're writing emails for 100 million people in 190 different countries, in 100 different languages, all at different stages of their journey through using Canva from beginners to intermediates to experts, that just massively multiplies the complexity of the job that you have to do. And if you're trying to write every single one of those emails, you have no chance of scaling.
(00:18:56):
So you need to think about who you're going to bring in to help you, what systems you're going to introduce, what are the processes needed to get 100 different languages translated every time you send out an email and that requires you to hand off that stuff. You need to maybe stop writing every single email, give that to someone else, be comfortable with doing that because you often build up a lot of self-identity and doing that and you get a lot of joy out of it. That's why you're a writer in the first place. But finding joy in the other things of building a team, passing on your experience, helping other people do great writing or great product building or great engineering is really what giving away your Lego is about. And we still encourage everyone to do that, to think about those moments where they need to level up in their impact, how they can bring their team along with them, how they can pass on their experience and help everyone really have a tremendous impact with the skills that they have.

**中文翻译:**
是的，Molly 写了一篇很棒的文章。事实上，在每个新人加入 Canva 的文化入职培训中，我都会向他们推荐这篇文章。我会带大家了解 Canva 的文化以及未来几年的预期，其中一个章节就是“放弃你的乐高”。这对我们非常重要，因为初创公司的一部分就是规模化（Scaling）——从零用户到一百万再到一亿，从 3 个创始人到 10 个员工、100 个员工再到 4000 个员工。从产品到内部流程、财务发放、用户反馈处理，一切都在不断增长。我认为这与传统工作略有不同，传统工作中你擅长某件事并将其转化为固定流程。
(00:17:58):
作为初创公司，你必须不断改变。我们需要灵活、能带来新想法、能迈向更高台阶的人。你需要考虑的不仅是一百万人，而是千万级、亿级甚至十亿级用户。为了不断提升这个乘数，你必须改变自己，这意味着你可能需要放弃现在正在做的一些事情，以便达到下一个水平。如果你是 Canva 的第一位邮件文案，第一年你可能还能应付所有邮件，但当你面对 190 个国家、100 种语言、处于不同使用阶段（从新手到专家）的一亿用户时，工作的复杂性呈几何倍数增长。如果你还想亲手写每一封邮件，你根本无法实现规模化。
(00:18:56):
所以你需要思考请谁来帮你，引入什么系统，每次发邮件需要什么样的翻译流程，这要求你把手头的工作交出去。你可能需要停止写每一封邮件，把它交给别人，并对此感到坦然。这很难，因为你往往在这些工作中建立了自我认同并获得了乐趣，这也是你最初成为作家的原因。但“放弃你的乐高”本质上是在组建团队、传承经验、帮助他人完成出色工作（无论是写作、产品还是工程）中寻找新的乐趣。我们仍然鼓励每个人这样做，思考如何提升自己的影响力，如何带动团队，如何通过分享经验让每个人都能发挥巨大的作用。

---

### (00:19:51) Lenny Rachitsky

**English:**
I think a lot of people and a lot of companies struggle with this idea, and I'm curious if there's something you've learned about how to actually implement this. Is it just like, "Hey, go read this article and then I might bring it up sometimes when things are changing and there's a reorg."? Or is there anything even deeper of just this is a cultural element of we are constantly giving up our Lego's giving things that we own?

**中文翻译:**
我觉得很多人和很多公司都在这个理念上挣扎。我很想知道你在实际执行中有什么心得。是仅仅说“嘿，去读读这篇文章”，然后在组织架构调整时提一下？还是有更深层次的东西，让它成为一种“我们不断放弃自己拥有的东西”的文化元素？

---

### (00:20:10) Cameron Adams

**English:**
Probably the deeper thing I think is giving people opportunity so you can talk about growth than just say, "Please grow." That's not going to be terribly effective, but giving them the opportunity and the support to do so is super important. We have a system we call coaching at Canva where you have a coach and they're constantly working with you to look at your skills, how you can improve each of those individual skills, but also what it is that you're actually doing and when it might be the time to move on to the next level. Say you are just doing a product role in this particular product and now you need to be a coach of other product managers and help build products. Understanding those pivot points is really important and our coaches help everyone at Canva. Everyone at Canva has a coach that is constantly thinking about this aspect of their personal growth.
(00:21:00):
And finding those opportunities where you can push someone to do something that they haven't done before or to expand upon an idea that they've had and give them ownership of that idea is super important. So when people do come to us with an amazing product idea or a feature that they want to build or an entire team that they think should be spun up, we really listen to them, and if it makes sense, we say, "Go and do that. Go and build that part of the product, grab a couple of people and start building video at Canva. Do that thing that you're talking about." And I think if you give them the opportunity and a little push to go beyond what they think they're comfortable with right now, that is the best way to drive growth in your team.

**中文翻译:**
更深层次的东西应该是给人们机会。你不能只是口头上说“请成长”，那没什么效果，给他们机会和支持才至关重要。在 Canva，我们有一套叫做“教练”（Coaching）的系统。每个人都有一位教练，他们会不断与你合作，审视你的技能，探讨如何提升，同时也关注你正在做的事以及何时该迈向下一阶段。比如，你原本只负责某个特定产品的产品工作，现在你需要去指导其他产品经理。理解这些转折点非常重要。Canva 的每个人都有一位教练，在不断思考他们个人成长的这一方面。
(00:21:00):
寻找那些可以推动某人尝试未曾做过的事、或者扩展他们想法并给予他们所有权的机会，这非常关键。所以当有人带着惊人的产品创意、功能构思或组建新团队的提议来找我们时，我们会认真倾听。如果合理，我们会说：“去做吧。去构建那部分产品，带几个人开始在 Canva 做视频功能。去做你说的那个东西。”我认为，给他们机会并推一把，让他们超越目前的舒适区，是驱动团队成长的最佳方式。

---

### (00:21:44) Lenny Rachitsky

**English:**
Okay. There's two things I want to follow up on there. One is this coaching concept. I've never heard of this. So how does that work? Do they have a manager and they have coach, and who is this coach?

**中文翻译:**
好的，关于这一点我想追问两件事。一是这个“教练”概念，我从未听说过。它是如何运作的？员工是既有经理又有教练吗？教练又是谁？

---

### (00:21:54) Cameron Adams

**English:**
We don't really have managers. So your coach is the person who thinks about you in a specialty sense. So we have specialties, engineering, product design, we got tens of different specialties across Canva, and your coach really helps.. Your coach is a similar specialty leads, so if you're a product manager, they're a product manager, so they know the skills that you have to use. They know the trajectory that you could possibly grow into. They know the structures that are around Canva that you could slot into when you want to go to the next level. And your coach constantly checks in with you, has sessions, might help you with the strategy doc, might have a one-on-one with you. They just constantly thinking about those ways that you can grow and improve at Canva.
(00:22:42):
And then we have probably more of a, I would say, collegiate managerial circle of colleagues who help you who do 360 feedback, all that kind of stuff. So that's the structure that we've arrived on and it's worked pretty well for us and it was driven actually by a formative coaching experience that we had as founders quite a few years ago from an external coach and we decided to bring that into Canva as a whole philosophy.

**中文翻译:**
我们其实没有经理。你的教练是从“专业领域”的角度来关注你的人。Canva 有几十个不同的专业领域，如工程、产品设计等。你的教练通常是同领域的领导者，比如如果你是产品经理，你的教练也是产品经理。因此，他们了解你所需的技能，知道你可能的成长轨迹，也熟悉 Canva 内部可以让你晋升的架构。教练会不断与你沟通，进行辅导，帮你修改战略文档，或者进行一对一谈话。他们始终在思考你在 Canva 成长和进步的方式。
(00:22:42):
此外，我们还有一种我称之为“学院式管理圈”的同事群体，他们会通过 360 度反馈等方式提供帮助。这就是我们最终确定的结构，对我们非常有效。这实际上源于多年前我们创始人从外部教练那里获得的一次深刻的辅导经历，于是我们决定将其作为一种整体哲学引入 Canva。

---

### (00:23:10) Lenny Rachitsky

**English:**
And these coaches, are they professional coaches or they're people in the company that are like, "I will be a coach for this function."?

**中文翻译:**
这些教练是职业教练，还是公司内部的人说“我来担任这个职能的教练”？

---

### (00:23:15) Cameron Adams

**English:**
They're people in the company. So we've got probably close to 800 or 1,000 coaches now at Canva.

**中文翻译:**
他们是公司内部的人。现在 Canva 大约有 800 到 1000 名教练。

---

### (00:23:22) Lenny Rachitsky

**English:**
Wow.

**中文翻译:**
哇。

---

### (00:23:23) Cameron Adams

**English:**
We do have very specific coaches who are just coaches and they can drop into any situation. They're not product managers, they're not designers, but they're relatively few. I think, we've got probably five of those type of coaches and they just work in very special situations, but what we're focused on is enabling the broader circle of coaches, so those 800 people to understand what it is to be a coach and have the skills of coaching. So we focus a lot on teaching them the skills of coaching, how to build a growth mindset in their coaches, all the skills that you need. So yeah, it's a massive part of Canva.

**中文翻译:**
我们确实有一些专门只做教练的人，他们可以介入任何情况。他们不是产品经理或设计师，但这类人相对较少，大概只有 5 个，专门处理非常特殊的情况。但我们的重点是赋能那 800 多名更广泛的教练群体，让他们理解什么是教练以及掌握教练技能。我们投入大量精力教他们如何辅导、如何在被辅导者中建立成长型思维等。所以，这确实是 Canva 非常重要的一部分。

---

### (00:24:02) Lenny Rachitsky

**English:**
And so there's a product management coach and this person helps all the PMs become better at the craft of product management.

**中文翻译:**
所以会有一个产品管理教练，这个人负责帮助所有的 PM（产品经理）提升产品管理的专业技能。

---

### (00:24:09) Cameron Adams

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:24:09) Lenny Rachitsky

**English:**
Wow, so interesting. Okay, and then the performance review piece, how does that work?

**中文翻译:**
哇，太有意思了。那绩效评估（Performance Review）部分是怎么运作的？

---

### (00:24:13) Cameron Adams

**English:**
Yeah. So your coach feeds into that, but we also do 360 feedback from all the people that you work with and we do that on regular cycles. As with everything at Canva, the cadence of those cycles has changed over the years, but now we do that every six months.

**中文翻译:**
教练会提供反馈，但我们也会从你合作的所有人那里收集 360 度反馈。我们会定期进行，就像 Canva 的其他事情一样，周期的节奏多年来有所变化，现在是每六个月一次。

---

### (00:24:29) Lenny Rachitsky

**English:**
We talked about product for a little bit. I want to spend a little time on product management. I'm curious just how you think about product management. There's this constant debate across tech companies about the value of PMs. Are we better with more PMs? Are there too many PMs? What do PMs do for you? You're a chief product officer. Where do you find product managers bring the most value to Canva? And then do you just have thought on the future of the field of product management?

**中文翻译:**
我们刚才聊了一会儿产品。我想在产品管理上多花点时间。我很想知道你是如何看待产品管理的。科技公司一直在争论 PM 的价值：PM 多一点好吗？PM 是不是太多了？PM 对你来说意味着什么？作为首席产品官，你认为产品经理在 Canva 哪里发挥的价值最大？另外，你对产品管理领域的未来有什么看法吗？

---

### (00:24:54) Cameron Adams

**English:**
I don't know. It's one of those things that I don't want to quantify. I don't want to put it in a box and say this is product management. Because I've worked at a few places now. I've actually only had one real job, which was at Google where I got to experience product managers the Google way. And the way that they do product management is totally different to the way that we do it at Canva, and that's partially by design because I didn't want to do product management like they did at Google, and that's because of the different cultures that they have. Google's a fantastically engineering-driven culture and the way that they think about product management is mostly in the technical sense of like, "Here's a piece of technology, what can that technology do, how do we scale it?" At Canva, we focus a lot on experience and as I said before, it's a very visual experience, so we require a different product management process, but also a different product management mindset.
(00:25:51):
I think we probably did that more from the ground up than a lot of other startups just because Mel and Cliff were a lot less, I think, inculcated into how product management has done other places. I had a bit of experience from Google but was still fairly independent in my thinking, so we almost went back to first principles on how product management should be done, and to be honest, we didn't want to have the term product manager for a long, long time. It wasn't until about year '06 or '07 where we actually had product managers, we decided to cave just because it was easier to explain to people.
(00:26:30):
But it also took us four or five years before we even had another product owner who wasn't us. Part of that was us giving up our Lego, and I think we took a little too long to give up our Lego on that one, but the other part of it was us figuring out exactly what we wanted and how we built product and how to communicate that to someone else and get them to do it in a similar way and work with the teams in the way that we did.
(00:27:00):
For us, product managers are really connectives. They connect the team, ideas, data, a whole bunch of different things, and it's very messy. There's no exact recipe for how to do it, but connecting these disparate areas and moving the team and the technology and our customers to a new place, a new vision is essentially what product managers do, and it's going to involve compromise, it's going to involve changes in the feature scope, it's going to involve timelines of like, "Okay, we can't ship it in May, it's going to have to be July. Let's figure out what we can do with marketing to make that work." This constant movement and connection and reorienting around the constraints that have suddenly arisen in the last week, and that's where we see great product managers operating in Canva.

**中文翻译:**
我不知道。这是我不愿意去量化的事情之一。我不想把它框起来说“这就是产品管理”。因为我也在几个地方工作过，其实我只有过一份真正的“打工”经历，就是在谷歌，在那里我体验了谷歌式的产品经理。他们做产品管理的方式与 Canva 完全不同，这在一定程度上是刻意为之的，因为我不想像谷歌那样做，毕竟文化不同。谷歌是极度工程驱动的文化，他们对产品管理的思考大多是技术层面的，比如“这里有一项技术，它能做什么，我们如何规模化？”而在 Canva，我们非常关注体验，正如我之前所说，这是一种非常视觉化的体验，所以我们需要不同的流程和思维模式。
(00:25:51):
我想我们比很多初创公司更彻底地从零开始构建这套体系，因为 Mel 和 Cliff 几乎没有受到其他地方产品管理模式的影响。虽然我有谷歌的经验，但思维还算独立，所以我们几乎是回到了“第一性原理”来思考产品管理应该怎么做。坦白说，很长一段时间我们都不想使用“产品经理”这个头衔。直到大概第六、七年，我们才正式有了产品经理，我们妥协只是因为这样更容易向外界解释。
(00:26:30):
而且，我们花了四五年时间才有了除了我们创始人之外的其他产品负责人。部分原因是我们“放弃乐高”的速度慢了点，但另一部分原因是我们当时还在摸索自己到底想要什么、如何构建产品，以及如何将这些传达给别人，让他们以类似的方式工作。
(00:27:00):
对我们来说，产品经理本质上是“连接者”。他们连接团队、想法、数据和各种杂乱的事物。这没有确切的秘诀，但将这些零散的领域连接起来，推动团队、技术和客户走向一个新的愿景，这就是产品经理的工作。这涉及妥协、功能范围的调整、时间表的变动（比如“5 月发不了，得推到 7 月，想想怎么配合营销”）。这种不断的移动、连接以及围绕突发限制进行的重新定位，正是我们认为优秀产品经理在 Canva 发挥作用的地方。

---

### (00:27:56) Lenny Rachitsky

**English:**
You mentioned Mel and Cliff. For folks that don't know, they're the other two co-founders of Canva and they were dating when they were starting Canva, I think it was called Fusion Books back in the day before Canva. Now, they're married. What's it like working with a married couple as the other two co-founders, and is there something they did well that didn't make you feel like this third wheel person that isn't married to them?

**中文翻译:**
你提到了 Mel 和 Cliff。对于不了解的人，他们是 Canva 的另外两位联合创始人。他们在创立 Canva（当时叫 Fusion Books）时正在约会，现在已经结婚了。作为另外两位联合创始人，和一对夫妻一起工作是什么感觉？他们有哪些地方做得很好，让你不会觉得自己像个“电灯泡”？

---

### (00:28:22) Cameron Adams

**English:**
It is always tricky working with a couple because they're on it 24/7. When you leave the office and they head home, they're still talking about product, business strategy, all the things. I think they've done a really good job of evolving those ideas overnight through the conversations they have and over dinner and walking, but then bringing that back the next day and being transparent about that and that's super important. If you are working in that kind of dynamic. There are definitely moments where I have missed out on a memo and stuff has rapidly proceeded, and I think I've just gotten used to that and gotten used to catching up really quickly, having a word with them on the side to clarify what the motivation is here and just constantly maintaining that alignment.
(00:29:11):
And I think it happens in any partnership or team. There's moments where there's small alignments, there's more tectonic stuff that happens over months or years, and you need to realign at some stage. I think it happens with friendships, it happens with my wife, it happens with our product teams. There's always these moments where you need to re-communicate things and relay the land of it. And I think we've been great at doing that as co-founders even for the small things and also for the more tectonic things.

**中文翻译:**
和一对夫妻工作确实有些微妙，因为他们是 24/7 全天候在线的。当你离开办公室，他们回到家后，可能还在讨论产品、商业战略等所有事情。我觉得他们做得很好的一点是，通过晚餐或散步时的交谈，让想法在夜间演进，然后在第二天把这些想法带回来并保持透明，这非常重要。如果你在这种动态环境下工作，肯定会有我没收到通知但事情已经飞速进展的时刻。我想我已经习惯了这一点，习惯了快速跟上进度，私下找他们聊聊以明确动机，并不断保持一致。
(00:29:11):
我认为这在任何合伙关系或团队中都会发生。会有小的分歧，也会有持续数月或数年的“地壳运动”般的大调整，你需要在某个阶段重新对齐。这在友谊中、我和我妻子的关系中、以及我们的产品团队中都会发生。总会有需要重新沟通、重新审视现状的时刻。我认为作为联合创始人，我们在处理这些小事和大事上都做得很好。

---

### (00:29:44) Lenny Rachitsky

**English:**
This episode is brought to you by Vanta... (Ad break)
(00:30:37):
I'm going to go back to the beginning of Canva. I know that it took you guys a long time of building before you launched it, so it took you a year to build the MVP essentially. And I know you have some strong opinions on how long to wait, how MVPs are often way too early. Can you talk about that just why you guys waited so long before launching clearly worked out and so I'm just curious your lessons from that experience.

**中文翻译:**
（广告略）
(00:30:37):
我想回到 Canva 的初创时期。我知道你们在发布前花了很长时间构建，基本上花了一年时间才做出 MVP。我知道你对于“等待多久发布”以及“MVP 往往发布得太早”有一些强烈的看法。你能谈谈为什么你们等了这么久才发布吗？显然这个决定是正确的，我很想听听你从那次经历中学到的教训。

---

### (00:30:59) Cameron Adams

**English:**
Yeah, so when we launched or when we were building the Lean Startup book came out, so that was all anyone talked to us about investors, other people building products, trying to give us advice. They were like, "Just get something out the door, as crappy as it is just to get in front of users." I think, for us, the product is the experience and giving people a great experience is an intrinsic part of the product. It's also an intrinsic part of how we've grown. People having a good experience of being enthusiastic about it has been how we've spread the word of Canva and organic word-of-mouth growth was the biggest driver of Canva's growth for many years and probably still is, I think. People just telling someone else to jump on this amazing product, I don't think we would've had that if we just put our pretty crappy product that people didn't have joy in using. Sure, it might've got the job done, but if they weren't excited about using it the next day, then that wasn't a bar that we wanted to hit.
(00:32:08):
So we did hold off on launching the product for a long time and investors did ask us many, many times, "When are you launching? Can you just get this thing out the door?" But we had done enough research, we knew the problem space, we knew what people wanted from the product. Part of that was due to the work that Mel and Cliff did on Fusion Books in a very constrained area. They had looked at school yearbooks, they had built an experience for that, and they had observed what worked didn't work and how they might scale that into a bigger product. It also worked for me who'd worked in a lot of creative tools and built a lot of creative tools over the previous 15 years. So I had a lot of understanding of how people interacted with these systems and the experience that we wanted to build.
(00:32:57):
So we did hold off and the product we launched launched, we obviously weren't happy with. You have to launch something that you're not completely happy with, all the rough edges, but you're releasing it knowing that the rough edges are going to be outweighed by the joyful experience. We still did a ton of user testing, right? It's not like we just launched this thing blind and said, "We hope people like it." We did a ton of user testing. We did a ton of user research into the features that people wanted, and we built that up over time. And one year to me actually seems like short time, a lot of people think it's a long time, but one year was just enough for us to scrape in with an experience that people did truly love when we launched, and particularly the market that we went after when we launched really loved it.

**中文翻译:**
是的。当我们开始构建时，《精益创业》（Lean Startup）这本书刚好出版，所以投资者和其他做产品的人都在跟我们聊这个。他们建议：“先弄个东西出来，哪怕再烂也要先推给用户。”但对我们来说，产品即体验，提供卓越的体验是产品的内在组成部分。这也是我们增长的内在动力。用户拥有良好的体验并对此充满热情，是 Canva 口碑传播的方式。多年来，有机口碑增长一直是 Canva 增长的最大驱动力，现在可能依然如此。如果只是推出一个让人毫无愉悦感的烂产品，我不认为人们会主动向别人推荐。当然，它可能完成了任务，但如果用户第二天不想再用它，那就没达到我们的标准。
(00:32:08):
所以我们确实推迟了很久才发布。投资者多次催促：“什么时候发布？能不能先把东西弄出来？”但我们做了足够的研究，了解问题所在，知道用户想要什么。部分原因在于 Mel 和 Cliff 在 Fusion Books 时期的积累，他们在学校年鉴这个垂直领域观察到了什么有效、什么无效，以及如何将其扩展为更大的产品。对我来说也是如此，在之前的 15 年里，我开发过很多创意工具，非常了解人们如何与这些系统交互。
(00:32:57):
所以我们按兵不动。当然，发布时的产品我们也不是完全满意。你总得发布一些自己不完全满意、还有棱角的东西，但你发布它的前提是知道这些棱角会被愉悦的体验所抵消。我们做了大量的用户测试，并不是盲目发布。我们对用户想要的功能做了大量研究，并随着时间推移不断完善。对我来说，一年其实很短，虽然很多人觉得长，但一年时间刚好够我们打磨出一种让用户真正喜爱的体验，尤其是我们发布时针对的那个市场非常喜欢它。

---

### (00:33:49) Lenny Rachitsky

**English:**
I'm curious just what advice you share with founders when they're asking you how joyous does this first version have to be? How awesome does my MVP need to be? One thread I picked up as you were describing your experiences, you all had deep experience in this space, so you knew what you wanted to build. It wasn't like this dark forest of exploration is like we know what we want generally. Do you have advice you share with founders of how awesome their MVP should be and when it's worth spending a year or two or three building it?

**中文翻译:**
我很想知道，当创始人问你“第一个版本需要多么令人愉悦？我的 MVP 需要多么出色？”时，你会给他们什么建议？我注意到你描述经历时的一个细节：你们在这个领域都有深厚的经验，所以你们知道自己想做什么。这不像是在黑暗森林里摸索，你们大致知道目标。对于 MVP 应该达到什么水准，以及什么时候值得花一两年甚至三年去构建它，你有什么建议吗？

---

### (00:34:20) Cameron Adams

**English:**
There's a couple of points in there. First is that even today we build for ourselves, and I think this is advice that probably a lot of product people wouldn't give you is that you shouldn't build for yourself, you should build for your customer. But I think we're fortunate that we are our customer and that the problems we experience are the problems that hundreds of millions, billions of people experience. I think that is maybe a fortunate part of just the problem area that we're interested in, but it has enabled us to move really quickly on the product because we can quickly know what's working in the product, whether this feature is useful, whether it's reached that bar of a great experience.
(00:35:03):
So that's one aspect of it and I think that is also about being passionate, you entering an area that you are extremely passionate about. I often hear people are like, "I want to do a tech startup. What is the best area I should focus on to build a product in?" And to me, that is totally the wrong way to go about building a company that you're going to spend the next 10, 20 years in because if you're in an area that you are particularly passionate about but you see the opportunity to make a bit of money or have some external measure of success, that is a terrible way to go about being a founder because you're going to hit these rock bottom dark places and if the passion isn't driving you through that, you're going to have an incredibly hard time getting to the next step. So that's probably the first area I talk about in terms of knowing when a product is amazing.
(00:35:58):
The second one is that it really needs to spark, joy, and delight in people and just pure excitement. It can't just be like, "Oh, yeah, this is a useful tool for me." It needs to light up their eyes. They need to be like, "How do I sign up for this thing tomorrow? How do I get it? How do I pay for it?" And they need to want to talk to other people about it because in the early days of your startup, you don't have marketing dollars, you don't have channels which you can go to immediately get access to a million people. You need to really foster the first people that are going to use your product and they're going to be the ones that are going to spread it and they're going to set the foundations for your growth.

**中文翻译:**
有几点建议。首先，直到今天我们依然是“为自己而建”。很多产品经理可能会建议你不要为自己建，要为客户建。但我觉得我们很幸运，因为我们本身就是自己的客户，我们遇到的问题也是数以亿计的人会遇到的问题。这可能是因为我们感兴趣的领域比较普适，但这让我们能快速推进产品，因为我们能迅速判断什么有效、功能是否有用、是否达到了卓越体验的标准。
(00:35:03):
所以这是第一点，这也关乎激情。你必须进入一个你极其热爱的领域。我经常听到有人说：“我想做科技创业，我应该关注哪个领域？”对我来说，如果你打算在未来 10 到 20 年里经营这家公司，这种想法完全错了。如果你对某个领域没有激情，只是看到了赚钱的机会或外部成功的衡量标准，那作为创始人是很糟糕的。因为你会遇到跌入谷底的黑暗时刻，如果没有激情支撑你度过，你很难迈向下一步。这是关于如何判断产品是否出色的第一个方面。
(00:35:58):
第二点是，它真的需要能激发人们的喜悦和纯粹的兴奋。不能只是“哦，这对我很有用”，而是要让他们的眼睛发亮。他们必须心想：“我明天怎么注册？怎么下载？怎么付钱？”并且他们必须想向别人推荐它。因为在创业初期，你没有营销预算，没有能立刻触达百万人的渠道。你需要悉心培养第一批用户，他们才是传播者，是为你增长奠定基础的人。

---

### (00:36:41) Lenny Rachitsky

**English:**
Interesting. So piece of advice number one is work on something you really want yourself that you're excited to work on. Two is get it to a place where it lights up people's eyes. They're just so excited with this thing. For that second bar, what was it for Canva? Was it just that it was impossible to do this design in a browser?

**中文翻译:**
很有意思。所以建议一：做你自己真正想要、并且有激情去做的事情。建议二：把它做到能让用户眼前一亮、感到兴奋的程度。对于第二个标准，Canva 当时是怎么做到的？是因为当时在浏览器里做设计几乎是不可能的吗？

---

### (00:37:00) Cameron Adams

**English:**
It was 2012, 2013 when we launched and visual content was still in its infancy. Instagram had only been out a couple of years. Pinterest was on the rise. People were just getting used to creating visuals and it was hived off to a very select few because to create those visuals you needed to afford some expensive software, know how to use that expensive software, nowhere to go to get fonts and photos and illustrations, know how to put that together into something that looked decent and then ship that off. It was something that only 1% of the world could do and democratizing design, empowering the world to design is Canva's entire mission, and we saw this sweet spot at the time in social media. It wasn't what we set out to go after. We set out to democratize design to bring design to literally everyone in the world and to everything that they're doing.
(00:37:59):
But through the user testing that we did, through the levels of excitement that we saw from different people, social media managers really came to the fore at that time. So we knew that they really fit what we could ship right now. We didn't ship a presentation product or a T-shirt builder in our very first version. We shipped a thing that could make square landscape and portrait graphics and blog post graphics, and that got a particular segment of society excited. We added on all the things afterwards because that was part of vision and ultimately what we wanted to build. But with a team of 10 people in the space of a year, building something that really got social media managers excited was what we could pull off. And that's something we realized in the last six months of that launch year. We didn't quite know who our audience was going to be. We knew it was a tool that anyone could use, but in that last six months of user testing and refining is when we really identified that first target market and we just leant into it.

**中文翻译:**
我们发布是在 2012、2013 年，当时视觉内容还处于萌芽阶段。Instagram 才出来几年，Pinterest 正在兴起。人们刚开始习惯创建视觉内容，但这种能力仅限于极少数人。因为要制作这些内容，你需要买得起昂贵的软件，学会使用它，还得知道去哪里找字体、照片和插图，知道如何把它们组合成体面的样子，最后再发出去。这在当时是全球只有 1% 的人能做的事。而“设计民主化，赋予世界设计的力量”是 Canva 的全部使命。我们当时在社交媒体领域看到了一个切入点。这并不是我们最初设定的唯一目标，我们的目标是让世界上每一个人在做每一件事时都能使用设计。
(00:37:59):
但通过用户测试和观察不同人群的兴奋程度，社交媒体经理（Social media managers）在当时脱颖而出。我们知道他们非常契合我们当时能交付的产品。我们在第一个版本里没有发布演示文稿或 T 恤设计功能，我们发布的是一个可以制作正方形、横向、纵向图形和博客配图的工具。这让特定的群体感到兴奋。之后我们才陆续添加了其他功能，因为那是愿景的一部分。但在只有 10 个人、只有一年时间的情况下，做出一个让社交媒体经理兴奋的东西是我们能做到的极限。这是我们在发布那一年的最后六个月里意识到的。起初我们并不完全确定受众是谁，只知道这是一个任何人都能用的工具，但在最后六个月的测试和精炼中，我们锁定了第一个目标市场并全力以赴。

---

### (00:39:08) Lenny Rachitsky

**English:**
There are so many things you all nailed early on. One of them is the focus persona/ICP, which is you said social media managers. Just to take the lesson from that, you basically saw that segment getting the most excited about the product and that told you, let's focus on this group. Is that right?

**中文翻译:**
你们早期做对了很多事情。其中之一就是锁定了核心用户画像（Persona/ICP），即社交媒体经理。总结一下教训：你们基本上是看到那个群体对产品最兴奋，从而决定专注于这个群体，对吗？

---

### (00:39:27) Cameron Adams

**English:**
Exactly.

**中文翻译:**
没错。

---

### (00:39:29) Lenny Rachitsky

**English:**
And was it like an order magnitude more excited? What do people look for there that tells them, "This is the one."? What did you see there other than just more excitement?

**中文翻译:**
那种兴奋程度是高出一个数量级吗？人们应该寻找什么样的信号来告诉自己“就是这个群体了”？除了兴奋之外，你还看到了什么？

---

### (00:39:39) Cameron Adams

**English:**
It was just incredibly emotive language, like sheer joy. Particularly coming into the product, we worked a lot on the onboarding process in the last couple of months of launch and that was really pivotal because the product features were there. You could add text, you could add images, you can change the color of things, you can move stuff around the page. It was a simple but powerful product, but there was this thing holding people back from actually using it and understanding what Canva could do for them. And when user tested the onboarding of Canva a ton, actually usertesting.com had just launched them, which really unlocked us because we didn't have to do these big formal labs or anything like that. We could just go online and get results in the space of half an hour. So that was like a pivotal unlock for our product process and that's something we still employ today.
(00:40:39):
And through that, we tailored the onboarding process to get people excited and to understand the deeper goal with Canva and the deeper impact it could let them have. It wasn't just about letting them put a pretty picture on the page, it really unlocked their ideas and let them do things they couldn't do before. And we shaped the onboarding to do that and it resonated the most with social media managers because they had this massive content need that they couldn't really service. And in the first minute of Canva with the right onboarding, it just unlocked the whole realm of productivity and impact that they didn't have before and that's why they got super excited.

**中文翻译:**
那是非常感性的语言，纯粹的喜悦。特别是在进入产品时，我们在发布的最后几个月里花了很多精力优化“新手引导”（Onboarding）。这非常关键，因为产品功能已经具备了：添加文本、图片、改颜色、移动位置。产品简单而强大，但总有些东西阻碍人们真正开始使用并理解 Canva 的价值。我们对新手引导做了大量测试，当时 usertesting.com 刚上线，这帮了大忙，因为我们不需要做正式的实验室测试，只需上网就能在半小时内得到结果。这成了我们产品流程的一个关键突破口，我们沿用至今。
(00:40:39):
通过测试，我们定制了新手引导流程，让人们感到兴奋并理解 Canva 的深层目标和影响力。这不仅仅是让他们在页面上放一张漂亮的图片，而是释放他们的创意，让他们做到以前做不到的事。我们调整了引导方式，这在社交媒体经理中引起了最强烈的共鸣，因为他们有巨大的内容需求却无法满足。在 Canva 的第一分钟，配合正确的引导，它开启了一个全新的生产力和影响力领域，这就是他们超级兴奋的原因。

---

### (00:41:23) Lenny Rachitsky

**English:**
We talk a lot on this podcast about the power of onboarding and the impact that can have on retention and everything down funnel. Do you remember what the unlock was in terms of and getting more people activated? Is there anything that's something that other people can learn from?

**中文翻译:**
我们在播客里经常讨论新手引导的力量，以及它对留存和漏斗下游的影响。你还记得在提高用户激活率方面，那个关键的“解锁点”是什么吗？有什么是其他人可以借鉴的？

---

### (00:41:38) Cameron Adams

**English:**
For us, it was taking that first step, particularly with Canva and any I think creative tool. There's a real fear of the blank page. So prior to any onboarding thought from us, we had a blank page. We had a few coach marks that said, "Here's where you do this, here's where you do this." And then they'd be left on this blank page and people would freak out. So what we really focused on was just taking that first step and then the next step and then the next step. And before they knew it, they built a design. And the way that we did that was to encourage a really simple step. So the first one was click on this search box and search for a monkey. It literally said that.
(00:42:18):
Searching for a monkey is something you probably don't do in most tools. So it was a little surprising, which was a good inroad, but it was still super easy. Anyone can type monkey. And then you type that in, it comes up with this whole sway the monkey images, which look hilarious, and just dragging one of those out onto a page is another simple step. And we just got people to walk through that keeping their interest up, keeping the bar of effort quite low, but within three or four steps, they'd built up something that they've never been able to do before, and it surprised them. The words that we literally got out of years at testing were, I didn't know I could be a designer. And that was what we managed to do through several rounds of refinement on the onboarding process. It is lowering the barriers to entry and also increasing the amount of delight, and I think those two things are what you should be aiming for with your onboarding.

**中文翻译:**
对我们来说，关键是迈出第一步。尤其是对于 Canva 这种创意工具，人们对“空白页面”有一种天然的恐惧。在优化引导之前，我们只有一个空白页，加几个提示点说“这里是做什么的”。然后用户面对空白页就抓狂了。所以我们专注于引导他们迈出第一步，然后是下一步。在他们意识到之前，他们已经完成了一个设计。我们的做法是鼓励一个极其简单的动作。第一个动作是：点击搜索框，搜索“猴子”。字面上就是这么写的。
(00:42:18):
在大多数工具里你可能不会搜索“猴子”，所以这有点出人意料，是个很好的切入点，而且非常简单，谁都会打“猴子”这个词。搜完后会出现一大堆滑稽的猴子图片，把其中一张拖到页面上又是简单的一步。我们就这样引导用户走下去，保持他们的兴趣，同时把门槛降得很低。在三四步之内，他们就做出了以前从未做过的东西，这让他们感到惊喜。我们在测试中听到的原话是：“我以前不知道我也能当设计师。”这就是我们通过几轮新手引导优化实现的目标：降低进入门槛，同时增加愉悦感。我认为这两点就是新手引导应该追求的目标。

---

### (00:43:16) Lenny Rachitsky

**English:**
That an incredible insight. Is there a video of that original onboarding out there or is the current one still similar?

**中文翻译:**
非常有见地。现在还能看到那个原始新手引导的视频吗？或者现在的引导还和以前类似吗？

---

### (00:43:16) Cameron Adams

**English:**
The current one isn't similar. We have constantly gone back to it because it performs really well. We do actually apply the same approach of little steps building up into bigger accomplishments, and that's actually rolled out through our last round of launches for the last couple of years through something we call learn and play. So with every launch that we do now, we think about how to teach people about that feature and how to get them really involved in it. We have a whole series of learn and plays where when we launch AI photo editing, they can try it out right then and there. They've got some great content that they can immediately operate on, and it's a super simple step for them to type in a prompt and see the result of that.

**中文翻译:**
现在的引导已经不一样了。但我们经常回顾它，因为它表现得非常好。我们确实在应用同样的方法：用小步骤积累成大成就。这在过去几年的发布中通过我们称之为“边学边玩”（Learn and Play）的方式推广开了。现在每发布一个新功能，我们都会思考如何教用户使用并让他们参与进来。我们有一系列“边学边玩”环节，比如发布 AI 照片编辑功能时，用户可以当场试用。我们提供现成的素材让他们操作，他们只需输入提示词（Prompt）并查看结果，步骤极其简单。

---

### (00:44:05) Lenny Rachitsky

**English:**
I think an interesting and really important takeaway here is you built a very delightful, incredible, innovative product, but it still didn't work until you figured out the onboarding and that you needed to figure out the persona to focus on. All those things end up being incredibly important, it's not just build something amazing and delightful.

**中文翻译:**
我觉得这里有一个非常重要且有趣的结论：你构建了一个非常令人愉悦、不可思议且创新的产品，但在你搞定新手引导并确定核心用户画像之前，它依然无法大获成功。所有这些因素最终都极其重要，而不仅仅是做一个神奇、好用的东西。

---

### (00:44:25) Cameron Adams

**English:**
Definitely.

**中文翻译:**
绝对是这样。

---

### (00:44:26) Lenny Rachitsky

**English:**
Staying within this realm of growth, you've grown in large part thanks to this incredibly SEO template strategy. You mentioned in interview there's this guy, Andre that came on early and helped you figure this stuff out. Is that true? And if so, what was the key insight that he had that led to such a great success in terms of growth for you all?

**中文翻译:**
回到增长领域，你们的增长很大程度上归功于那套惊人的 SEO 模板策略。你在采访中提到过一个叫 Andre 的人，他很早就加入并帮你们搞定了这些。是真的吗？如果是的话，他当时的关键洞察是什么，从而带来了如此巨大的增长成功？

---

### (00:44:49) Cameron Adams

**English:**
Andre is an amazing guy. He's actually been in and out of Canva three or four times now.

**中文翻译:**
Andre 是个了不起的人。他实际上已经进出 Canva 三四次了。

---

### (00:44:54) Lenny Rachitsky

**English:**
Keep pulling him back.

**中文翻译:**
一直把他拉回来。

---

### (00:44:56) Cameron Adams

**English:**
Yeah, keep pulling him back. We originally found him, he came from a startup that was going under here in Sydney. We had thought about SEO. We knew it was this thing that you could use, and I think in a couple of our pitch decks, we had SEO as a whole growth channel that we were going to execute upon in order for investors to make a ton of money, but we pretty much knew nothing about it. And it was sitting away in our backlog of things to do in the first couple of years of Canva. And we came across Andre and he just really crystallized what SEO was and how it would actually help us grow. So we brought him on, he rolled out his strategy and it was fantastically effective. It was also incredibly cheap, and it was super easy for us to do ourselves.
(00:45:51):
He set up a whole team of people who looked at people's motivations and the top jobs to be done that Canva could service. He then mapped that through the entire experience of going into Google, typing a search query, getting that search query, seeing that it was a great result, firstly getting to the top result, but then also the experience after they landed on Canva. So if they searched for want to make a Halloween poster, the top Google result would be Canva. They'd click on it, they'd land on the Halloween poster landing page. It would tell them how they were going to do, it show you how the product was going to do that, have a button there that immediately took them into a Halloween poster template, went through a fantastic onboarding of customizing that poster really simply, and then they would hit done, download the image, and they had a fantastic experience and he thought through that whole end-to-end flow from first landing on Google and typing into the search box through to that magic moment where they're like, "Canva just helped me do something amazing and I want to do it again."

**中文翻译:**
是的，一直拉他回来。我们最初发现他时，他刚从悉尼一家倒闭的初创公司出来。我们考虑过 SEO，知道它是可以利用的手段。在几份商业计划书中，我们把 SEO 列为一个增长渠道，以此向投资者展示能赚大钱，但其实我们对此一窍不通。在 Canva 的头几年，它一直躺在我们的待办清单里。后来我们遇到了 Andre，他清晰地阐述了 SEO 是什么以及它如何帮助我们增长。我们聘请了他，他推行了自己的策略，效果惊人。而且成本极低，我们自己操作起来也非常容易。
(00:45:51):
他组建了一个团队，研究用户的动机以及 Canva 能提供的“待办任务”（Jobs to be done）。然后他将这些映射到整个体验中：从进入谷歌输入搜索词，到看到搜索结果（首先要排在第一位），再到进入 Canva 后的体验。比如，如果用户搜索“想做一张万圣节海报”，谷歌的第一条结果就是 Canva。点击后进入万圣节海报落地页，页面会告诉用户怎么做，展示产品功能，并有一个按钮直接带用户进入万圣节海报模板。接着通过极简的新手引导完成海报定制，点击完成并下载。Andre 思考了从谷歌搜索框到那个“Canva 帮我完成了惊人作品，我还想再用一次”的“魔法时刻”的整个端到端流程。

---

### (00:46:58) Lenny Rachitsky

**English:**
Amazing. Okay. So a few things I'm hearing there. One is figure out the jobs to be done of potential users, figuring out where their search volume, figure out ones you can actually solve for them, like say a Halloween poster, and then think about that experience end to end from search to landing. And obviously, you have to deliver on that promise. You have to actually show them a really cool Halloween poster that they can create, right?

**中文翻译:**
太棒了。我听到了几点：一是弄清楚潜在用户的“待办任务”，找到有搜索量的需求；二是确定你能真正帮他们解决的需求（如万圣节海报）；三是思考从搜索到落地的端到端体验。显然，你必须兑现承诺，真的给他们展示一个能制作的超酷海报模板，对吧？

---

### (00:47:19) Cameron Adams

**English:**
Yeah. Again, it's like product led truly means product led because you can't just SEO the hell out of something that is a terrible experience. So tying that experience at the end of the SEO journey is just as important as the technicalities of SEO itself, and Andre really harnessed the whole spectrum of that to produce the end experience, which ultimately ended up with an active user having a delightful experience.

**中文翻译:**
是的。再次强调，“产品驱动”是真的以产品为核心，因为你不能对一个体验极差的东西进行疯狂的 SEO。将 SEO 旅程终点的体验打磨好，与 SEO 技术本身同样重要。Andre 掌控了整个环节，从而创造了最终体验，让活跃用户获得了愉悦感。

---

### (00:47:47) Lenny Rachitsky

**English:**
Is there anything else along those lines that was really surprising to you or really, wow, that worked a lot better than I thought because it's probably one of the most well executed, most successful SEO strategies in history. And I'm so curious, just if there's anything else there that's just like, "Oh, wow, that was really effective and I didn't expect that."

**中文翻译:**
在这方面还有什么让你感到惊讶，或者让你觉得“哇，这比我想象的好得多”的事情吗？因为这可能是历史上执行最出色、最成功的 SEO 策略之一。我很想知道是否还有其他让你意想不到的有效招数。

---

### (00:48:05) Cameron Adams

**English:**
There's a ton in the SEO realm that Andre drove that can get quite technical. But I think one of the other pivotal growth moments for us was internationalization. I think as an Australian company, we're fortunate in that Australia isn't a great market to focus on. We've got 25 million people here. It's okay, but it's not sizeable. It's not going to make you a huge success. Whereas probably a startup that starts in the US will tend to focus on the US because it's a huge monetizable market, and you can entirely create a great company that just services the US. But from Australia, we needed to think about the world. And that meant that we very quickly got into internationalization.
(00:48:52):
We started localizing and internationalizing our products three years after launch, which is quite early compared to a lot of other companies. And we tackled it with real vigor. We had a goal of being in five different languages within the first year of localization, and we actually hit eight in that first year. And then we set ourselves a goal of being in 100 different languages the next year. And the internationalization team smashed that goal by the end of 2017. And it has drastically changed Canva's growth trajectory because being in other languages, offering a localized experience, something that people in Brazil or Indonesia or Spain or Poland can authentically feel like they're using a product that's made for them has totally changed who our market is, how quickly we can grow. And the way the product's used internationalizing into Brazilian Portuguese meant that we had to focus a ton more on the Android mobile experience, which was really different for us because we focused a lot on the desktop experience for the first four years.
(00:49:58):
People also in Brazil run entire businesses from their mobile phone and the types of content they're creating to interact with their audience is totally different. So it's actually shaped our product and changed our product trajectory as a result of thinking about internationalization. And it has just fueled tremendous growth. Brazil, India, Indonesia, they're all in our top five markets and they grow way faster than the US does.

**中文翻译:**
Andre 推动的 SEO 领域有很多非常技术性的东西。但我认为另一个关键的增长时刻是“国际化”（Internationalization）。作为一家澳大利亚公司，我们很幸运，因为澳大利亚本身不是一个值得死磕的市场。这里只有 2500 万人，还行，但规模不够大，不足以支撑巨大的成功。相比之下，美国的初创公司往往专注于美国，因为那是一个巨大的可变现市场，你完全可以只服务美国就做成一家伟大的公司。但从澳大利亚出发，我们必须考虑全球。这意味着我们很早就进入了国际化阶段。
(00:48:52):
我们在发布三年后就开始对产品进行本地化和国际化，这比很多公司都要早。我们投入了巨大精力。第一年的目标是支持 5 种语言，结果做到了 8 种。第二年的目标是 100 种语言，国际化团队在 2017 年底就超额完成了任务。这彻底改变了 Canva 的增长轨迹。支持多种语言、提供本地化体验，让巴西、印尼、西班牙或波兰的用户觉得这是为他们量身定制的产品，这改变了我们的市场构成和增长速度。比如，进军巴西葡萄牙语市场意味着我们必须重点关注 Android 移动端体验，这与我们前四年专注桌面端完全不同。
(00:49:58):
巴西用户甚至完全通过手机经营业务，他们创作的内容类型也完全不同。因此，国际化思考实际上塑造并改变了我们的产品轨迹。它带来了巨大的增长：巴西、印度、印尼现在都在我们的前五大市场之列，且增长速度远超美国。

---

### (00:50:25) Lenny Rachitsky

**English:**
I know you went international in your four, something like that, which is really early for a company. It also makes sense for SEO plus internationalization. Makes tons of sense.

**中文翻译:**
我知道你们在第四年左右就开始国际化了，这对一家公司来说非常早。SEO 加上国际化，这逻辑非常通顺。

---

### (00:50:35) Cameron Adams

**English:**
Totally.

**中文翻译:**
完全正确。

---

### (00:50:36) Lenny Rachitsky

**English:**
It's a lot more surface area. Okay. I'm going to have two more questions. One is around your freemium strategy. Another a thing you all nailed. There's just this, you're both seeing incredible growth and incredible monetization. I'm curious what your philosophy is on what to include in the free plan versus what people should pay for because it's clearly worked out great.

**中文翻译:**
这增加了巨大的覆盖面。好的，我还有两个大问题。一个是关于你们的免费增值（Freemium）策略，这也是你们做得很棒的一点。你们同时实现了惊人的增长和惊人的变现。我很想知道你们对于“哪些该免费、哪些该收费”的哲学是什么，因为这显然非常奏效。

---

### (00:50:59) Cameron Adams

**English:**
Freemium for us wasn't so much a growth strategy or a monetization strategy as much as it spoke to our core mission of empowering the world to design. We truly want to democratize design, which means we want to get design into the hands of as many people as we can because we think that the world is a better place when more people can create really rich visual content. So freemium just made sense to us because we could get the tool into billions of people's hands and they wouldn't necessarily have to pay for it. And much of the world can't pay for products because they just don't have access to that level of income.
(00:51:36):
So providing that equality was really important to us. But also you need to build a viable business because you can't help the world design if you can't afford to keep the lights on. So freemium just really hit this sweet spot for us between philosophy and business building, so it was always part of our plan since day one. We initially had element sales as our business models. So when we first went to pitch Canva, it was all about create a design. Anything you use in that design will cost you a dollar. So if you dragged in a monkey and you wanted to export that whole design, you'd have to pay a dollar for the money.

**中文翻译:**
对我们来说，免费增值与其说是增长或变现策略，不如说是对我们“赋予世界设计力量”核心使命的践行。我们真心希望实现设计民主化，这意味着我们要让尽可能多的人掌握设计能力，因为我们相信当更多人能创作丰富的视觉内容时，世界会变得更好。所以免费增值对我们来说顺理成章，因为我们可以让数十亿人使用这个工具而无需付费。世界上很多地方的人负担不起付费产品，因为他们的收入水平还没到那一步。
(00:51:36):
提供这种平等对我们非常重要。但同时，你也需要建立一个可持续的业务，因为如果你连电费都交不起，就没法帮助世界设计。所以免费增值在我们的哲学和商业构建之间找到了完美的平衡点。从第一天起，它就是我们计划的一部分。最初我们的商业模式是“素材销售”。当我们第一次去推销 Canva 时，核心是：创建一个设计，你在设计中使用的任何素材都只需 1 美元。比如你拖进一只猴子素材，导出整个设计时，你需要为那只猴子付 1 美元。

---

### (00:52:14) Lenny Rachitsky

**English:**
Yeah, I've done that many times.

**中文翻译:**
是的，我以前经常这么干。

---

### (00:52:15) Cameron Adams

**English:**
Yes. It was really exciting to investors at the time. It was also really exciting to the content creators who were giving us the monkeys to put into our product. It was a totally new business model. It unlocked, I think, an area that a lot of people were unfamiliar with, which was stock photography. Most people had not paid 100, $500 for photo, and that really held them back from being visual content creators. So it was a really unique innovation for us. And for the first two years of Canva's life, that was how we derived our revenue. It grew pretty well. It was still like, I don't know, 30% month-on-month growth in terms of revenue. But you can do that in the early stages of a startup. It wasn't until we introduced our first subscription product that we saw really hockey stick growth in our revenue. And that was always the plan to launch a subscription product.
(00:53:09):
But as with many things, it was a vision that we didn't quite have meat around the bones. So we knew we wanted to put in a subscription what exactly that subscription would look like. We didn't quite know. And through the first couple of years of Canva, we started noticing what people were asking for, what they would be more likely to pay in a subscription for. And that formed the first few features that became what was then called Canva for Work, which is now called Canva Pro. And we launched our first subscription, I think about three years after we launched the first product, and we just rapidly saw the revenue from the subscription start overtaking the $1 image payments.
(00:53:53):
So much so that three or four years later we made image element payments part of the subscription. And again, that was like a second hockey stick in gross in terms of the revenue from the subscription because all you can eat images inside the Canva Pro subscription with just amazing value add for people. And I don't even know if we get any revenue from image element sales now. It's all about just going into this subscription.

**中文翻译:**
是的。当时这让投资者非常兴奋，也让那些提供素材的创作者非常兴奋。这是一种全新的商业模式。它解锁了一个很多人不熟悉的领域——图库摄影。大多数人以前不会花 100 或 500 美元买一张照片，这阻碍了他们成为视觉创作者。所以这对我们来说是一个非常独特的创新。在 Canva 的头两年，这就是我们的收入来源。它增长得不错，月营收增长率大约有 30%。但在创业初期，这还不够。直到我们推出了第一个订阅产品，我们的收入才真正出现了“曲棍球棒式”的爆发增长。推出订阅产品一直都在计划中。
(00:53:09):
但就像很多事情一样，当时这只是一个骨架，还没长肉。我们知道要做订阅，但具体长什么样还不确定。通过头两年的观察，我们注意到用户在提什么需求，他们更愿意为订阅中的哪些功能买单。这构成了最初的几个功能，也就是后来的“Canva for Work”（现更名为 Canva Pro）。我们在发布首款产品约三年后推出了订阅服务，很快订阅收入就超过了 1 美元的单次素材付费。
(00:53:53):
以至于三四年后，我们将素材付费直接包含在了订阅中。这又带来了第二次收入爆发，因为 Canva Pro 订阅里的“素材全家桶”对用户来说价值巨大。我现在甚至不知道单次素材销售还有没有收入，几乎所有人都转向了订阅模式。

---

### (00:54:24) Lenny Rachitsky

**English:**
Amazing. Just hockey stick after hockey sticks. Speaking of another hockey stick, I want to talk about AI.

**中文翻译:**
太神奇了，一个接一个的爆发式增长。说到增长，我想聊聊 AI。

---

### (00:54:29) Cameron Adams

**English:**
Oh, a whole hockey team of hockey sticks.

**中文翻译:**
噢，那简直是一整支曲棍球队的爆发增长。

---

### (00:54:32) Lenny Rachitsky

**English:**
Just need to acquire hockey teams. I want to talk about AI, something on the top of everyone's minds these days. It's another area you guys have nailed. You're doing amazing work with AI. It's providing actual value and business impact. I hear you have an amazing internal AI ops team. Is there anything that you've learned so far that you can share about just how to integrate AI successfully and effectively into a product?

**中文翻译:**
干脆去买支曲棍球队算了。我想聊聊 AI，这是现在每个人都在关注的话题。这也是你们做得非常出色的领域。你们在 AI 方面做得很好，提供了实际价值和商业影响。我听说你们有一个很棒的内部 AI 运营团队。关于如何成功且有效地将 AI 集成到产品中，你有什么心得可以分享吗？

---

### (00:54:58) Cameron Adams

**English:**
As a technology company, you always just need to be constantly evolving and using the best technology. And when we started that was mobile phones and cloud computing. They were the innovations that came in that really unlocked Canva. AI is the next decade I think of innovation. It's the next pivotal piece of technology that helps you build better products, but it also can't just be the basis for your product. You can't just be a product that's purely built on AI on being a rapper around an LLM or something like that. You still need to think about what it is that people want to do and how you build a product that actually meets that need. It isn't just about slapping a chatbot on something that already existed. It's about deeply thinking about how AI can help them get to that goal even faster. And we view AI as the next way of democratizing design and empowering the world to design, helping more people design, helping more people design quicker, helping more people design quicker with better quality. And that's how we approach every aspect of including AI in the Canva platform.
(00:56:04):
We've had a team of machine learning engineers for probably seven years now. I think their work has become a lot more visual now and more customer facing way back when they were just doing recommendation engines inside our emails and our homepage and suggesting templates to you. But now they get to work with some really cool technology, which lets them produce images for people and create designs and summarize text and translate to a hundred different languages like it's really stuff that you can put directly in front of customers now, and that's super exciting. And over the last couple of years, we've built up more and more visual AI experts inside Canva, and we approach AI inside the product through three pillars.
(00:56:53):
First of these is that we need to build some of our own AI tech, and we focus on building the AI tech that we have the biggest advantage in that we have the most data that we can put into it, the most insights, the most criticality to our product and our business. So we have teams building our own AI models around design and images and that stuff. Second pillar is just finding the world's best AI people to partner with. And there's a whole bunch of stuff that you don't need to internalize in your company. You don't need to create an LLM because it's a commodity thing now. And there's a bunch of providers who can do it way better and have way more resources to do it with than you do. So finding a great partner like OpenAI, and we partnered with RunwayML to do video generation, finding the world's best and bringing them into your product with a great integration, the second pillar.
(00:57:48):
And for us, the third pillar is our app ecosystem. So we're fortunate now we've got 170 million people using the product every single month. We have quite an audience that people want access to. And through our app developer ecosystem, they can build apps which directly integrate with the Canva product to give them access to those hundreds of millions of people when people are quite eager to do that. Now, we've seen huge uptake in that from AI developers who have included stuff in Canva from music generators to virtual avatars that can present your presentation to you to a whole slew of things. And those three pillars have, I think, allowed us to create a really coherent experience and one that still keeps a focus on what people want to do, how to help them reach their big goals in a way that doesn't just push technology in the face in a way that just is part of the experience and is a natural way of getting them to where they want to go.

**中文翻译:**
作为一家科技公司，你必须不断进化并使用最先进的技术。我们刚起步时，那是手机和云计算，这些创新真正解锁了 Canva。我认为 AI 是未来十年的创新核心。它是下一个能帮你构建更好产品的关键技术，但它不能仅仅是产品的全部。你不能做一个纯粹基于 AI 的产品，比如只是给大语言模型（LLM）套个壳。你仍然需要思考用户想做什么，以及如何构建一个真正满足该需求的产品。这不仅仅是在现有产品上加个聊天机器人，而是要深入思考 AI 如何帮助用户更快达成目标。我们将 AI 视为实现设计民主化的新途径：帮助更多人设计，帮助他们设计得更快，且质量更高。这就是我们将 AI 融入 Canva 平台的出发点。
(00:56:04):
我们的机器学习工程师团队已经存在大约七年了。以前他们只是做邮件和首页的推荐引擎，建议你用什么模板。但现在他们的工作变得更加视觉化且面向客户。他们现在利用酷炫的技术为用户生成图片、创建设计、总结文本、翻译百种语言。这些东西可以直接呈现在客户面前，非常令人兴奋。过去几年，我们在内部培养了越来越多的视觉 AI 专家。我们通过三个支柱来推进产品内的 AI：
(00:56:53):
第一，构建我们自己的 AI 技术。我们专注于那些我们拥有最大优势的领域，即拥有最多数据、洞察力以及对业务最关键的领域。所以我们有团队在构建关于设计和图像的自有 AI 模型。第二，寻找全球顶尖的 AI 合作伙伴。有很多东西你不需要在公司内部自己做。你不需要自己做一个 LLM，因为那已经成了通用商品，有很多供应商做得比你好、资源比你多。所以我们寻找像 OpenAI 这样的合作伙伴，或者像 RunwayML 这样合作生成视频。将全球顶尖技术集成到产品中是第二支柱。
(00:57:48):
第三，我们的应用生态系统。我们很幸运，每月有 1.7 亿活跃用户。这是一个开发者梦寐以求的受众群体。通过我们的应用开发者生态，他们可以构建直接集成到 Canva 的应用。我们看到 AI 开发者对此反响热烈，从音乐生成器到可以帮你演讲的虚拟数字人，各种应用层出不穷。我认为这三个支柱让我们创造了连贯的体验，既保持了对用户目标的关注，又没有把技术生硬地推到用户脸上，而是让它成为体验的一部分，自然地引导用户到达目的地。

---

### (00:58:49) Lenny Rachitsky

**English:**
I was also looking at the GPT story of the fifth most popular custom GPT where people can generate logos using it. So maybe that's driving some growth too. I know you wanted to share something that you guys are launching or have launched by the time this episode comes out. Is that true?

**中文翻译:**
我也关注到了 GPT 的故事，Canva 的 GPT 是第五大最受欢迎的自定义 GPT，人们可以用它生成 Logo。所以这可能也带动了一些增长。我知道你想分享一些你们正在发布或在本集播出时已经发布的东西，对吗？

---

### (00:59:08) Cameron Adams

**English:**
Yeah, so we've got a big event in Los Angeles in a couple of months. It's our Canva Create, which is an evolution of the season openness that we used to do. So season openers are no longer just inside Canva now. We actually invite our whole community in, and we're going to have probably about 4,000 people in the theater in LA and a couple of million online. And we're really going to be pulling the covers off pretty much the next decade of Canva. We've focused for the first decade of Canva on unlocking individuals and small businesses, giving them the tools that they need to design and to express themselves and create visual content. And as Canva has grown and people have gotten used to creating this stuff, they've invited their teams in, they now collaborate with people on presentations, on Canva videos, on swag T-shirts that they need to make for their event next week.
(01:00:06):
And as more and more people are using Canva together, it's picking up a lot of steam. We've got 95% of the Fortune 500 using Canva. We've got huge teams of thousands of people using Canva. And this has really opened our eyes to not only the enterprise opportunity, but also just the way to redesign the way people work. And that is what the event at the end of May is about. It's really redesigning work for a whole number of different verticals, from marketing to sales to HR to IT to creatives that work inside large teams, large organizations, large enterprises. We've redesigned Canva for this collaborative enterprise age, so we'll be pulling the covers off that alongside work kits, which are a whole verticalized experiences for people inside marketing and sales and HR that want to use Canva, as well as a bunch of improvements to our AI products and an actual enterprise skew that we're launching as well.
(01:01:13):
So through this growth and through getting to understand the needs of CIOs and heads of security at enterprises, we've realized that there pretty much needs to be a new enterprise product of Canva that meets the needs of hugely scaled teams, which has been quite different for us because we have scaled from those individuals just using the product all by themselves and organically growing the teams. And now looking at it from a top-down lens and building that enterprise products is what we've been focused on for the last couple of years. So we'll be pulling the covers off that as well in LA.

**中文翻译:**
是的。几个月后我们在洛杉矶有一场盛大活动，叫“Canva Create”，这是我们以前内部“季度发布会”的进化版。现在它不再仅仅是内部活动，我们会邀请整个社区参加。洛杉矶现场会有约 4000 人，线上会有数百万人。我们将揭开 Canva 下一个十年的序幕。在第一个十年，我们专注于赋能个人和小企业，给他们提供设计、表达和创作视觉内容的工具。随着 Canva 的成长，用户开始邀请团队加入，协作制作演示文稿、视频或活动 T 恤。
(01:00:06):
随着越来越多的人共同使用 Canva，势头非常猛。目前 95% 的财富 500 强企业都在使用 Canva，有些团队规模达到数千人。这让我们看到了不仅是企业的机会，更是重新设计人们工作方式的机会。这就是 5 月底那场活动的主题：为营销、销售、人力资源、IT 以及大型组织内的创意人员重新设计工作方式。我们为这个协作的企业时代重新设计了 Canva。我们将发布“工作套件”（Work Kits），这是为营销、销售和 HR 提供的垂直化体验，同时还有 AI 产品的改进，以及我们即将推出的全新企业版 SKU（产品型号）。
(01:01:13):
通过这种增长以及对企业 CIO 和安全负责人的需求了解，我们意识到需要一个全新的 Canva 企业产品来满足超大规模团队的需求。这对我们来说是一个转变，因为我们是从个人用户自发增长起家的。现在，从自上而下的视角构建企业产品是我们过去两年的重点。我们也会在洛杉矶发布这些内容。

---

### (01:01:50) Lenny Rachitsky

**English:**
I see another hockey stick approaching. I'm excited of all these things you're launching. What a business you've built. I feel like it's still way too under the radar, even though it's this juggernaut. Nice work, Cameron and team. Two more questions I ask everyone, where can folks find you online and how can listeners be useful to you?

**中文翻译:**
我预感到又一个“曲棍球棒”增长要来了。我很期待你们发布的所有新东西。你们建立了一项多么了不起的事业。我觉得尽管它已经是一个巨头，但依然被低估了。干得漂亮，Cameron 和团队。最后两个我必问每个人的问题：大家可以在哪里找到你？以及听众可以为你做些什么？

---

### (01:02:06) Cameron Adams

**English:**
They can find me online at themaninblue.com, which is my blog that's been around for 24 years now. What was the other question? How can you-

**中文翻译:**
大家可以在 themaninblue.com 找到我，那是我的博客，已经开了 24 年了。另一个问题是？

---

### (01:02:15) Lenny Rachitsky

**English:**
Yeah. How can listeners be useful to you?

**中文翻译:**
是的，听众可以为你做些什么？

---

### (01:02:18) Cameron Adams

**English:**
I love their design stories, how design has helped unlock something for them, whether it's starting their first business or helping a nonprofit that they volunteer at. I just love bumping into someone in the street and seeing the joy of design right up in their eyes. So please do that whenever you see me.

**中文翻译:**
我喜欢听他们的设计故事，设计如何帮他们开启了新篇章，无论是创立第一家公司，还是帮助他们做志愿者的非营利组织。我喜欢在街上偶遇某人，看到他们眼中闪烁着设计的喜悦。所以如果你见到我，请务必告诉我你的故事。

---

### (01:02:36) Lenny Rachitsky

**English:**
Beautiful. Cam, you're awesome. Canva is awesome. Go check out canva.com. Easy to find. Thanks for being here.

**中文翻译:**
太棒了。Cam，你很出色，Canva 也很棒。大家去看看 canva.com 吧，很好找。感谢你的到来。

---

### (01:02:42) Cameron Adams

**English:**
Thanks, Lenny. See you soon.

**中文翻译:**
谢谢，Lenny。再见。

---

### (01:02:43) Lenny Rachitsky

**English:**
All right. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
好的，大家再见。非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅。另外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。