# Camille Hearst - 双语对照

This is the complete bilingual transcript of Lenny's Podcast featuring Camille Hearst.

---

### [00:00:00] Camille Hearst

**English:**
... those Steve Jobs' lore was that if you were in an elevator with him, you better be prepared to talk about what you do at the company because he had a habit of getting in the elevator and looking at you and saying, "What do you do? What do you do here?" And there were also rumors that people who had not given him a good answer, that ended up being their last day at Apple.
So there was someone who I didn't know personally but worked in my department before I got there who got in an elevator and looked up and Steve was approaching him and so he went to press the button to open the door and accidentally pressed the one to close the door. And it was like doing this press... You can't see me if you're listening on podcast but frantically pressing the button, trying to open the door, but accidentally pressing the closed door button and the elevator going to its destination. And apparently he got off and just bolted straight up, ran down the hallway.

**中文翻译:**
……关于史蒂夫·乔布斯（Steve Jobs）的那些传闻是，如果你和他同乘一部电梯，你最好准备好谈谈你在公司是做什么的，因为他有个习惯，进电梯后会看着你问：“你是做什么的？你在这里负责什么？” 还有传言说，那些没能给出满意答案的人，那天就成了他们在苹果工作的最后一天。
所以有个我不认识、但在我入职前就在我部门工作的人，有次进了电梯，抬头一看史蒂夫正走过来，于是他想去按开门键，结果误按了关门键。他就像这样一直按……如果你在听播客可能看不见我，但他当时在疯狂地按按钮，想把门打开，结果却误按了关门键，电梯直接开往目的地了。据说他下电梯后直接拔腿就跑，冲向了走廊尽头。

---

### [00:01:00] Lenny

**English:**
He'll never remember my face.

**中文翻译:**
他永远不会记得我的长相。

---

### [00:01:02] Camille Hearst

**English:**
Yeah, exactly.

**中文翻译:**
没错，正是如此。

---

### [00:01:02] Lenny

**English:**
I disappeared.
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard win experiences building and growing today's most successful products.
Today my guest is Camille Hearst. Camille is head of fan monetization at Spotify. Before that, she was head of product for creators of Patreon. She was product marketing manager at YouTube and the second PM on iTunes. She's also a former founder. She started a company called Kit that she sold to Patreon.
And this episode is for anyone who's curious about the creator space, either from the creator side or the platform side, or if you'd just like to hear a bunch of fun stories from an awesome product leader.
We chat about the future of creator platforms, how to be successful as a creator, and also as a new creator platform, the downsides of creator life plus frameworks, stories from Steve Jobs, ways to monetize being a creator and so much more.
Enjoy this episode with Camille Hearst after a short word from our sponsors.

**中文翻译:**
我消失了。
欢迎来到 Lenny 的播客，在这里我会采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中获得的宝贵经验。
今天的嘉宾是 Camille Hearst。Camille 目前是 Spotify 的粉丝变现（Fan Monetization）负责人。在此之前，她是 Patreon 的创作者产品负责人。她曾担任 YouTube 的产品市场经理，也是 iTunes 的第二位产品经理（PM）。她还是一位前创业者，创办了一家名为 Kit 的公司并卖给了 Patreon。
本集节目适合所有对创作者领域感兴趣的人，无论你是站在创作者的角度还是平台的角度，或者你只是想听听一位优秀产品领导者的趣事。
我们聊到了创作者平台的未来、如何成为一名成功的创作者、如何打造一个新的创作者平台、创作者生活的负面影响，以及各种框架、史蒂夫·乔布斯的故事、创作者的变现方式等等。
在听完赞助商的简短介绍后，请欣赏与 Camille Hearst 的精彩对话。

---

### [00:02:02] Lenny

**English:**
This episode is brought to you by Merge. Every product manager knows how slow product development can get when developers have to build and maintain integrations with other platforms.
Merge's unified API can fully remove this blocker from your roadmap. With one API, your team can add over 180 HR, accounting, ATS, ticketing, CRM, file storage and marketing automation integrations into your product. You can get your first integration into production in a matter of days and save countless weeks building custom integrations, letting you get back to building your core product.
Merge's integration speed up the product development process for customers like Ramp, Drata, and many of their fast growing and established companies, allowing them to test their features at scale without having to worry about a never ending integrations roadmap.
Save your engineers countless hours, hit your growth targets, and expedite your sales cycle by making integration offerings your competitive advantage with Merge.
Visit merge.dev/lenny to get started and integrate up to three customers for free.

**中文翻译:**
本集节目由 Merge 赞助。每位产品经理都知道，当开发人员必须构建和维护与其他平台的集成时，产品开发速度会变得多么缓慢。
Merge 的统一 API 可以完全从你的路线图中移除这一障碍。通过一个 API，你的团队就可以在产品中添加超过 180 种人力资源（HR）、会计、招聘管理（ATS）、工单、客户关系管理（CRM）、文件存储和营销自动化集成。你可以在几天内将第一个集成投入生产，节省数周构建自定义集成的时间，让你重新专注于构建核心产品。
Merge 的集成为 Ramp、Drata 等许多快速增长和成熟的公司加速了产品开发过程，让他们能够在大规模环境下测试功能，而无需担心永无止境的集成路线图。
使用 Merge，为你的工程师节省无数小时，达成增长目标，并通过将集成服务转化为你的竞争优势来加速销售周期。
访问 merge.dev/lenny 开始使用，并可免费集成多达三个客户。

---

### [00:03:05] Lenny

**English:**
This episode is brought to you by Coda. You've heard me talk about how Coda is the doc that brings it all together and how it can help your team run smoother and be more efficient.
I know this firsthand because Coda does that for me. I use Coda every day to wrinkle my newsletter content calendar, my interview notes for podcasts, and to coordinate my sponsors.
More recently, I actually wrote a whole post on how Coda's product team operates, and within that post, they shared a dozen templates that they use internally to run their product team, including managing the roadmap, their OKR process, getting internal feedback, and essentially their whole product development process is done within Coda.
If your team's work is spread out across different documents and spreadsheets and a stack of workflow tools, that's why you need Coda. Coda puts data in one centralized location regardless of format, eliminating roadblocks that can slow your team down. Coda allows your team to operate on the same information and collaborate in one place.
Take advantage of the special limited time offer just for startups. Plan up today at coda.io/lenny and get a thousand dollars startup credit on your first statement. That's C-O-D-A .io/lenny to sign up and get a startup credit of $1000. coda.io/lenny.
Camille, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
本集节目由 Coda 赞助。你听我谈过 Coda 是如何将一切整合在一起的文档，以及它如何帮助你的团队运行得更顺畅、更高效。
我对此有亲身体会，因为 Coda 确实帮了我大忙。我每天都用 Coda 来整理我的时事通讯内容日历、播客采访笔记以及协调赞助商。
最近，我写了一篇关于 Coda 产品团队如何运作的文章，在文章中，他们分享了十几个内部用于管理产品团队的模板，包括路线图管理、OKR 流程、获取内部反馈，基本上他们的整个产品开发流程都是在 Coda 中完成的。
如果你的团队工作分散在不同的文档、电子表格和一堆工作流工具中，这就是你需要 Coda 的原因。Coda 将数据放在一个集中的位置，无论格式如何，消除了可能拖慢团队速度的障碍。Coda 让你的团队能够基于相同的信息进行操作，并在一个地方协作。
利用专为初创公司提供的限时特别优惠。立即在 coda.io/lenny 注册，即可在第一张账单中获得 1000 美元的初创公司抵用金。注册地址是 C-O-D-A .io/lenny，即可获得 1000 美元的抵用金。coda.io/lenny。
Camille，非常感谢你能来。欢迎来到播客。

---

### [00:04:28] Camille Hearst

**English:**
Thank you so much for having me, Lenny.

**中文翻译:**
非常感谢你邀请我，Lenny。

---

### [00:04:29] Lenny

**English:**
I first wanted to just give a big thank you to Adam Fishman for introducing us who had just so many nice things to say about you and so I'm really excited to be chatting.
I want to start with talking about your current role at Spotify and I believe your role is head of fan monetization. What does that actually entail and what are you responsible for within Spotify?

**中文翻译:**
首先，我要衷心感谢 Adam Fishman 的介绍，他对你赞不绝口，所以我非常期待这次对话。
我想先聊聊你目前在 Spotify 的角色，我相信你的职位是粉丝变现负责人。这具体包括哪些内容？你在 Spotify 负责什么？

---

### [00:04:49] Camille Hearst

**English:**
As head of fan monetization, I have a team of folks who are really passionate about figuring out new ways to help artists and fans connect and also figure out ways to make those connections result in new monetization opportunities for the artists.
So one of the things that we all know and we've seen is how passionate fans are about the artists that they love. You've been following any of the latest bits about the Taylor Swift tour, the Beyoncé tour that's been happening this summer, and their effect on local economies. It's been pretty impressive.
But one of the things that we also know is it's not just the big huge superstars who have those rabid and super engaged fan bases. People are really passionate just about supporting the artists that they love in general.
And on Spotify, we want to figure out ways we can help that result in more money that goes directly to the artist.

**中文翻译:**
作为粉丝变现负责人，我带领着一支团队，他们热衷于寻找新方法来帮助艺术家和粉丝建立联系，并设法让这些联系为艺术家带来新的变现机会。
我们都知道并亲眼目睹了粉丝对他们喜爱的艺术家的狂热程度。如果你关注了今年夏天泰勒·斯威夫特（Taylor Swift）或碧昂丝（Beyoncé）巡演的最新动态，以及它们对当地经济的影响，你会发现那非常惊人。
但我们也知道，不只是那些超级巨星才拥有疯狂且高度参与的粉丝群。人们通常对自己喜爱的艺术家都充满支持的热情。
在 Spotify，我们希望找到一些方法，帮助这种热情转化为直接流向艺术家的更多收入。

---

### [00:05:48] Lenny

**English:**
What are some of those ways just to give people a sense of what might be happening?

**中文翻译:**
能举几个例子吗？让大家感受一下具体在做些什么。

---

### [00:05:52] Camille Hearst

**English:**
So one of the ones that most mature is merch which is funny to say because most people probably don't realize that you can purchase merch on Spotify. That's one that's been around-

**中文翻译:**
其中最成熟的一个是周边商品（merch），说起来挺有意思，因为大多数人可能还没意识到你可以在 Spotify 上购买周边。这个功能已经存在——

---

### [00:06:03] Lenny

**English:**
I did not realize that.

**中文翻译:**
我确实没意识到。

---

### [00:06:04] Camille Hearst

**English:**
... for a bit of time and my team's recently been working on making it more prominent, giving artists more ways to offer that merch in the form of a reward for fans. So things like an exclusive discount or an exclusive design or early access because you're a top listener on Spotify, really thinking about thank yous and rewards for your Spotify listenership and fandom.
And then other things we've been looking at have been listening parties. We ran a few of those over the past year. I think I talked about it actually on a Spotify event a few years ago. We were running... Sorry, it wasn't a few years ago, it was last year.
But listening parties is another way and then we've got some new ideas we're exploring.

**中文翻译:**
……已经有一段时间了，我的团队最近一直在努力让它变得更显眼，为艺术家提供更多方式，将周边商品作为给粉丝的奖励。比如专属折扣、专属设计，或者因为你是 Spotify 上的头号听众而获得优先购买权，真正考虑如何回馈和奖励你的 Spotify 听众身份和粉丝热情。
此外，我们还在研究“试听派对”（listening parties）。过去一年我们举办了几场。我记得几年前在 Spotify 的一次活动中提到过。我们当时在办……抱歉，不是几年前，是去年。
试听派对是另一种方式，我们还有一些正在探索的新想法。

---

### [00:06:50] Lenny

**English:**
I've heard people do listening parties with this podcast actually and I hope that you roll that out to podcast too because that would be very cool.

**中文翻译:**
我听说有人为这个播客举办过试听派对，我希望你们也能把这个功能推广到播客上，那会非常酷。

---

### [00:06:58] Camille Hearst

**English:**
Yeah. We have all kinds of ideas of really interesting ways we can bring groups of people together and get the monetization going.

**中文翻译:**
是的。我们有很多想法，想通过各种有趣的方式把人群聚集在一起，并推动变现。

---

### [00:07:08] Lenny

**English:**
All right.

**中文翻译:**
好的。

---

### [00:07:08] Camille Hearst

**English:**
One day.

**中文翻译:**
总有一天会实现的。

---

### [00:07:09] Lenny

**English:**
Mysterious but exciting.
Speaking of Taylor Swift, I was watching a TikTok the other day and they showed a video of someone inside the concert showing the whole concert and then they panned to the parking lot and there was just tens of thousands of people just standing around in the parking lot listening to the second order music out at the stadium. And I wonder how can you monetize that if there's an opportunity?

**中文翻译:**
神秘但令人兴奋。
说到泰勒·斯威夫特，我前几天在看 TikTok，视频里有人在演唱会现场展示全场盛况，然后镜头转到停车场，那里竟然有成千上万的人就站在停车场里，听着体育场传出的“二手音乐”。我在想，如果有机会的话，该如何针对这种情况进行变现？

---

### [00:07:34] Camille Hearst

**English:**
Yeah. I think they often have the merch trucks in those parking lots though one way-

**中文翻译:**
是的。我想他们通常会在那些停车场停放周边商品售卖车，这是一种方式——

---

### [00:07:38] Lenny

**English:**
Probably unofficial merch.

**中文翻译:**
可能是不太正式的周边。

---

### [00:07:40] Camille Hearst

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:07:40] Lenny

**English:**
So you work with artists and I actually wanted to ask this question. What's the best part about working with artists, musical artists, and what's the worst part?

**中文翻译:**
你经常和艺术家打交道，我其实想问：与艺术家（尤其是音乐艺术家）合作，最棒的部分是什么？最糟糕的部分又是什么？

---

### [00:07:48] Camille Hearst

**English:**
I think the best part is working with people who really lean into their creativity and their passion so much so that they do it for a living. And I think a lot of us have creative pursuit and passions and things we love to do and if we made millions of dollars and could retire, what would you do full time? Usually, it's one of these pursuits. But I think it takes an element of bravery, not to mention talent, but you really have to go out on a limb.
And so that's this equality that exists in this group of people and it's fun to be around and feel that rub off on you and think, "Oh, maybe I could take the dive one day and I don't know, go do my calligraphy or learn my ukulele and then do it full time." But that's the best part.
And the thing I'm really... I grew up in a musical household. My dad's a drummer although his joke when we were growing up was real musicians have day jobs because he had to actually have a job with benefit to support the family and couldn't just be gigging full time.
Which actually brings me to the flip side of the question which you asked what is the hardest part. I do think we saw this a lot at Patreon and I think you see it especially with musicians and artists, this feeling that you want to give your fans everything that you create and you want to do it for free because you're so enamored with this idea that people really love you and want to support you and they're really responding to your creativity and everything that you're making, you don't want to charge them. But what comes with that is, well, how are you going to make a living.
To some degree, there has to be a value exchange that happens in order for a creative person to live from their art.
And I've found that that's much more pronounced with musicians, this starving artist ethos which makes what I'm trying to do actually quite difficult because a lot of the feedback we get is, "Oh, that's awesome. I want to have a listening party and have everything be free and just have everyone show up and don't sell anything." And we're really looking at it as a way to fans want to support the artists they love, they want to open up their wallets.
You've see nothing else from a Substack and Patreons that people are actually really happy to be a patron of the arts and they look at it as like a badge of honor.
But musicians in particular I think tend to shy away from that which makes the kind of thing that I'm working on more difficult.

**中文翻译:**
我认为最棒的部分是能与那些全身心投入创意和激情，甚至以此为生的人合作。我们很多人都有创意追求和爱好，如果我们赚了几百万美元可以退休了，你会全职做什么？通常就是这些追求。但我认为这不仅需要天赋，更需要一种勇气，你必须敢于冒险。
这就是这群人身上共有的一种特质，和他们在一起很有趣，能感受到那种感染力，你会想：“噢，也许有一天我也能放手一搏，去练书法或者学尤克里里，然后全职去做。”这是最棒的部分。
我是在一个音乐家庭长大的。我父亲是个鼓手，尽管我们小时候他常开玩笑说“真正的音乐家都有正职”，因为他必须有一份带福利的工作来养家糊口，不能只靠全职演出。
这正好引出了你问的另一个问题：最困难的部分是什么。我在 Patreon 工作时经常看到这种情况，尤其是在音乐家和艺术家身上，他们总想把创作的所有东西都免费送给粉丝。因为他们沉浸在被人们喜爱和支持的喜悦中，粉丝对他们的创意有共鸣，所以他们不想收钱。但随之而来的问题是：你该如何维持生计？
在某种程度上，必须存在一种价值交换，创意工作者才能靠艺术生活。
我发现这种现象在音乐家身上尤为明显，这种“穷困艺术家”的情怀（starving artist ethos）让我现在做的事情变得相当困难。因为我们收到的很多反馈是：“噢，太棒了，我想办个试听派对，一切免费，让大家都来，什么都不卖。”而我们实际上是想提供一种途径，因为粉丝其实很想支持他们喜爱的艺术家，他们愿意掏腰包。
从 Substack 和 Patreon 就能看出，人们其实非常乐意成为艺术的赞助人，并将其视为一种荣誉勋章。
但音乐家们尤其倾向于回避这一点，这让我正在做的工作变得更具挑战性。

---

### [00:10:20] Lenny

**English:**
This's a great segue to an area I want to spend time on is the creator economy and creators and artists and things like that. And along these lines, I think I have this issue too. I feel bad charging people but there's also... I don't think my stuff is worth enough to charge for and why would anyone ever pay anything for it and so I imagine you see that too. It's just like, "No one's going to pay for this. It's crazy."

**中文翻译:**
这很好地过渡到了我想深入探讨的领域：创作者经济、创作者和艺术家等等。说到这儿，我觉得我也有这个问题。我觉得收别人的钱心里过意不去，而且我也觉得我的东西不值那个价，为什么会有人愿意付钱呢？我想你也经常看到这种情况，创作者会觉得：“没人会为此付钱的，这太疯狂了。”

---

### [00:10:40] Camille Hearst

**English:**
Yeah. It's funny because we live in a very capitalist and market dictate the price kind of society, but on an individual level, particularly when the commodity so to speak is art, there's so many emotions and feelings involved in that that it's hard for someone who's the creator to disassociate themselves from it and see what the market will bear.
Which is why I actually think it's great that there's platforms who have stepped in and said, "Hey, we see an opportunity. Let us insert ourselves in the center, let us aggregate, and let us do the hard work of pricing and payment and tax and finance and actually create value where it would be really hard for an individual person who's a creator to do all of this work and facilitate that connection." It's almost like the perfect marketplace solution.
But again, it's hard because if the supplier doesn't want to actually make money in some cases or shies away from optimizing or making money.
And then there's the creative process. Sometimes, you're in a flow mode and you're producing a lot and then other times, you're in a drought spell and these things ebb and flow which is why I think companies like Patreon and Substack are really cool because what they try to do is smooth out that revenue and make it so an artist can actually have a predictable... They're not even artist, a creator can have a predictable sustainable paycheck so that they aren't bouncing around from job to job and losing the ability to have that burst of creativity because they're worried about their bills.

**中文翻译:**
是的。很有意思，因为我们生活在一个非常资本主义、由市场决定价格的社会，但在个人层面，尤其是当所谓的“商品”是艺术时，其中掺杂了太多的情感和感受，创作者很难将自己从中抽离出来，去客观观察市场能承受的价格。
这就是为什么我觉得有平台介入是一件好事。平台会说：“嘿，我们看到了机会。让我们站在中心位置，进行整合，处理定价、支付、税务和财务等繁重工作，在个人创作者难以独立完成这些工作并建立联系的地方创造价值。”这几乎是完美的市场解决方案。
但话说回来，这也很难，因为如果供应方（创作者）在某些情况下根本不想赚钱，或者回避优化收益。
此外还有创作过程的问题。有时你处于“心流”状态，产出很多；有时你又处于枯竭期，这些都是起伏不定的。这就是为什么我觉得像 Patreon 和 Substack 这样的公司很酷，因为它们试图平滑这些收入，让艺术家——甚至不只是艺术家，让创作者能有一份可预测、可持续的薪水，这样他们就不用在各种零工之间奔波，也不会因为担心账单而失去爆发创意的能力。

---

### [00:12:22] Lenny

**English:**
I have that experience myself with Substack which is a subscription newsletter and one of the big downsides people don't think about with this life is once you start charging, people start buying, say, an annual subscription and that means I have to at least go for another year and in reality, I never really want to stop it because the revenue would just stop and that would be really sad. So you get on the treadmill where you don't really have an exit path. And I'm not sure exactly where this all goes, but it's been great. But that's something people don't think a lot about is this never ending, keep creating, keep creating life.

**中文翻译:**
我自己在使用 Substack（一个订阅制时事通讯平台）时也有这种体会。人们没想到的一个巨大弊端是，一旦你开始收费，人们开始购买（比如）年度订阅，这意味着我至少得再干一年。实际上，我永远不想停止，因为一旦停止收入就断了，那会很悲哀。所以你就像踏上了跑步机，没有真正的退出路径。我不确定这最终会走向何方，虽然目前感觉很棒，但这种永无止境、必须不断创作的生活，是人们很少深思的。

---

### [00:12:52] Camille Hearst

**English:**
We call it internally the hamster wheel of content creation. You get on because you love it and then how do you get off.
So it's actually an interesting challenge again for platforms to think about where can they add value, are there ways to either make the content creation process that much easier and I don't want to say less of a burden because it's not a burden but sometimes, if you don't have time or you're just at a point in life where you can't do it, are there services or things that can be offered, are there things like financing that makes sense for creators that banks or traditional institutions wouldn't offer because of just the difference in the type of work that's being produced.
Or another potential solution is are there ways that platforms can create content. Maybe it's automated so that the creator can take a break. So maybe they're not AI necessarily, maybe it's more just aggregating data or doing summaries or maybe there's just other ideas that haven't been explored out there. But it's a real problem.

**中文翻译:**
我们内部称之为“内容创作的仓鼠轮”。你因为热爱而跳上去，然后就不知道该怎么下来了。
所以这对平台来说又是一个有趣的挑战：思考在哪里可以增加价值。有没有办法让内容创作过程变得更轻松？我不想说“减轻负担”，因为它不是负担，但有时如果你没时间，或者处于人生中无法创作的阶段，有没有可以提供的服务？有没有适合创作者的融资方案？因为工作性质的不同，银行或传统机构可能不会提供这些。
或者另一个潜在的解决方案是，平台能否协助创作内容？也许是自动化的，这样创作者就能休息一下。不一定非得是 AI，也许只是整合数据、做摘要，或者其他尚未被探索的想法。但这确实是一个现实问题。

---

### [00:13:56] Lenny

**English:**
So I have this lennybot.com site which is an AI chatbot based on all my content including the podcast episodes and actually, an engineer who was listening to this podcast reached out and offered to help me build it and he did and it's awesome. And I'm curious if that becomes my retirement plan as the bot ends up just doing this and learns enough. I highly doubt it, but it's fun to experiment with.

**中文翻译:**
我有一个 lennybot.com 网站，它是一个基于我所有内容（包括播客节目）的 AI 聊天机器人。实际上，是一位听这个播客的工程师联系我并提议帮我构建它，他做到了，效果非常棒。我在想，如果这个机器人学得足够多，最后能替我工作，这会不会成为我的退休计划？我深表怀疑，但实验起来很有趣。

---

### [00:14:18] Camille Hearst

**English:**
Yeah. Use your own content as your large language model, right?

**中文翻译:**
是的，把你自己创作的内容作为你的大语言模型（LLM），对吧？

---

### [00:14:22] Lenny

**English:**
Exactly. That's exactly what it is. And I'm curious where this goes.
I want to follow the thread of the creator economy. It feels like there's this huge wave of the creator economies, the future of work, and all these platforms launched to allow creator to make money. But it feels like over the past couple of years, it feels like it faded away. And these very small number of platforms essentially one YouTube, Spotify, Instagram, TikTok, Patreon, maybe Substack, and there was also the sense that the future of work is freelance, everyone's going to be working for themselves, creating stuff, and it feels like people are still working regular jobs. A lot of these startups haven't done great.
So I guess I'm just curious what you think happens maybe in the next five or 10 years from a perspective of platforms emerging and also just from creators, what... Do you think things stay the same? Do you think there's another wave? Where do you think things go?

**中文翻译:**
没错，正是如此。我也很好奇这会走向何方。
我想继续聊聊创作者经济。感觉曾经有过一波巨大的浪潮，说创作者经济是工作的未来，所有这些平台纷纷推出，让创作者能赚钱。但感觉在过去几年里，这股热潮似乎消退了。剩下的基本上就是那几家大平台：YouTube、Spotify、Instagram、TikTok、Patreon，也许还有 Substack。曾经还有一种感觉，认为未来的工作是自由职业，每个人都会为自己工作、创作内容，但现在看来大家还是在做普通的工作。很多相关的初创公司表现并不理想。
所以我很好奇，从平台涌现和创作者的角度来看，你认为未来 5 到 10 年会发生什么？你认为现状会维持下去吗？还是会有另一波浪潮？你认为趋势会往哪走？

---

### [00:15:14] Camille Hearst

**English:**
I think it was probably predictable to some degree that platforms would win because just of the nature of aggregation. Once you have either all of the supply or you've aggregated the demand, it's really a strong network effect. Why investors love to invest in these types of businesses, it's hard to break out.
I wouldn't underestimate the strategic ability either of some the big platforms. They were definitely thinking ahead and building features and thinking about whether or not they saw it as a monetization opportunity. It certainly is a great strategic play to make sure that creators felt like they were on the platform that made the most sense for them and they weren't going to churn or leave or try too many other places out.
So I think the rush and the funding was to figure out is there room for any other new platforms, are there specific vertical that maybe there's an opportunity to create vertical specific features and tooling.
And actually, I think we saw a huge massive creation there in Twitch, right? Twitch did not exist and they're just a juggernaut.
I think TikTok is another one that came out of this era. Maybe they weren't positioned as creator economy type startups but effectively...
Did you see what happened in Union Square here with Kai, the gaming streamer?

**中文翻译:**
我认为在某种程度上，平台最终胜出是可以预见的，因为这是聚合（aggregation）的本质。一旦你拥有了所有的供应或者聚合了所有的需求，就会产生极强的网络效应。这就是为什么投资者喜欢投资这类业务，因为一旦形成规模，竞争对手很难突围。
我也不会低估一些大平台的战略能力。他们肯定在未雨绸缪，构建功能，并思考这是否是一个变现机会。确保创作者觉得留在这个平台是最明智的选择，不会流失、离开或去尝试太多其他地方，这无疑是一个高明的战略举措。
所以我认为之前的热潮和融资是为了弄清楚是否还有新平台的空间，或者是否有特定的垂直领域可以创建针对性的功能和工具。
实际上，我们看到了 Twitch 的崛起，对吧？Twitch 以前并不存在，而现在它是一个巨头。
我认为 TikTok 是这个时代的另一个产物。也许他们最初并没有被定位为创作者经济类的初创公司，但实际上……
你看到最近在联合广场（Union Square）发生的关于游戏主播 Kai 的事了吗？

---

### [00:16:39] Lenny

**English:**
No.

**中文翻译:**
没看到。

---

### [00:16:39] Camille Hearst

**English:**
So I'm in New York and last week, there was a mob and a riot because a Twitch streamer announced that he was going to be giving away PlayStations and computer gear in Union Square and something like a million teenage boys showed up. I'm not making this up. And they had to shut down the center of New York City to clear what turned into protest, riot, mob-

**中文翻译:**
我在纽约，上周那里发生了一场骚乱，因为一位 Twitch 主播宣布他要在联合广场免费发放 PlayStation 和电脑设备，结果来了大约一百万个青少年。我没瞎编。他们不得不封锁纽约市中心来清理这场演变成抗议、暴乱和骚乱的——

---

### [00:17:07] Lenny

**English:**
Holy shit.

**中文翻译:**
我的天呐。

---

### [00:17:08] Camille Hearst

**English:**
... of teenagers who came for this one creator that probably no one listening to me right now has even heard of.

**中文翻译:**
……成群结队的青少年为了这一个创作者而来，而现在听我说话的人里可能根本没人听说过他。

---

### [00:17:15] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:17:17] Camille Hearst

**English:**
So I do think a lot of the predictions have come to bear. There are tons of people making money and making a living from creating content on the internet.
There have been studies too where they ask young people what they want to do and what they want to be when they grow up, we quote these at, excuse me, Patreon and over 60% want to create content for a living.
So those trends I don't think are going anywhere. Maybe it'll be supplemental income, maybe it'll be something you do for a period of your life. But I do think that this area continues to be untapped. I just don't see a world where...
I think of Michelle Phan, right? She's basically a mini Disney and when you think of it like that, she's created IP. What can you do with IP? Comic books, movies, TV shows, plushies, merch. How many millions of Michelle fans are we going to have seen?
Look at what's happening in China. There's tons of creators like this.
So whether or not the VCs have won or the startups have succeeded, there's no way that you can lower the cost of content creation and increase the scale of distribution and not see this emerge, this creator economy I think emerge. But I think that maybe there's still opportunity for more companies to blossom and to grow and certainly for more individuals maybe do this, figure it out on their own, and do it without too many big platforms getting paid off of their creative pursuit.

**中文翻译:**
所以我确实认为很多预测已经实现了。有无数人正在通过在互联网上创作内容来赚钱和谋生。
也有研究调查年轻人长大后想做什么，我们在 Patreon 经常引用这些数据：超过 60% 的人想以创作内容为生。
所以我不认为这些趋势会消失。也许它会成为补充收入，也许是你人生中某个阶段从事的事情。但我确实认为这个领域仍有待挖掘。我无法想象一个……
我想到了 Michelle Phan（美妆博主鼻祖），对吧？她基本上就是一个迷你迪士尼，当你这样想时，她创造了 IP。有了 IP 你能做什么？漫画、电影、电视节目、毛绒玩具、周边。我们会看到多少个像 Michelle 这样拥有数百万粉丝的人？
看看中国正在发生的事情，那里有无数这样的创作者。
所以，无论风险投资人是否赢了，或者初创公司是否成功，只要内容创作的成本在降低，分发的规模在扩大，创作者经济就必然会兴起。但我认为，也许仍有空间让更多公司蓬勃发展，当然也让更多个人能够独立摸索出路，在不被太多大平台抽成的情况下实现创意追求。

---

### [00:18:58] Lenny

**English:**
Have you seen the NPC trend on TikTok/maybe Instagram Reels where people pretend to be NPCs, non-playable characters, from a video game?

**中文翻译:**
你见过 TikTok 或者 Instagram Reels 上的 NPC 趋势吗？就是人们假装成电子游戏里的 NPC（非玩家角色）。

---

### [00:19:06] Camille Hearst

**English:**
I have not.

**中文翻译:**
我没见过。

---

### [00:19:07] Lenny

**English:**
Okay. It's crazy. People just pretend to be a computer character and people pay them little gifts to do a thing.

**中文翻译:**
好吧。那太疯狂了。人们就假装成电脑角色，然后观众送小礼物让他们做一个动作。

---

### [00:19:15] Camille Hearst

**English:**
Oh. Is this the... Yes. Have seen it. [inaudible 00:19:19] ice cream, ice cream.

**中文翻译:**
噢。是那个……是的，我见过。[听不清] “冰淇淋，冰淇淋”。

---

### [00:19:22] Lenny

**English:**
Yeah, exactly.

**中文翻译:**
对，没错。

---

### [00:19:22] Camille Hearst

**English:**
Yes. I didn't realize.

**中文翻译:**
是的，我之前没意识到（这就是 NPC 趋势）。

---

### [00:19:24] Lenny

**English:**
You're making tens of thousands of dollars a day just... So that's one way to make a living.

**中文翻译:**
每天能赚好几万美元，就靠……所以这也是一种谋生方式。

---

### [00:19:24] Camille Hearst

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:19:30] Lenny

**English:**
On the thread of becoming a creator, you've seen a lot of creators try to do this on Patreon, back at Apple even with iTunes, I want to chat about that, at Spotify now, and even your startup. I'm curious what you've seen is important to success in the creator life, especially things that are maybe not obvious to people. What do people need to get right if they want to pursue that path?

**中文翻译:**
关于成为创作者，你见过很多创作者在 Patreon 上尝试，甚至以前在苹果的 iTunes（我想聊聊这个）、现在的 Spotify，还有你自己的初创公司。我很想知道，根据你的观察，在创作者生涯中获得成功最重要的是什么？尤其是那些人们可能不太容易察觉的事情。如果有人想走这条路，他们需要做对什么？

---

### [00:19:54] Camille Hearst

**English:**
One of the things that I've seen that I don't know if people realize is consistency and predictability of content creation which is where this idea that we were talking about earlier of a hamster wheel kind of comes on.
But there is something to churning out consistent quality work and putting it out there for your audience to consume and respond and react to that goes a long way. It's almost like the 10,000 hours. You have to do 10,000 hours of something in order to truly master it. But I've seen that time and again.
I started at YouTube in, let's see, how old am I? It must have been 2010. And that was when I really think this whole thing was just first getting going. And we used to put together these playbooks of what made a creator successful because a lot of the effort there was trying to support this burgeoning economy. And I remember even back then in 2010 and to this day, that continues to be one of the top pieces of advice.
Another one is collaboration. So working with other great creators, sharing audience, exposing one another to those audiences, and then this was something we tried to employ at my startup, Kit. We would actually host events for creators to get together to facilitate meeting and cross pollination in the hopes that it would just benefit their careers. If they were doing YouTube videos with someone they met at the party, then it would be great for all parties all around. So those are two things.
And then I do think in a world with all of this content, there continues to be a need and a space for the curator. And curators as creator's kind of an interesting concept. But a curator is almost like what the role at book publishing company plays or a record label plays or a radio station plays, right?
There is a degree of having a brand, having something you stand for, having a vibe or an ethos and that person being almost, not a gatekeeper in a bad way, but like, "I, Camille, can't consume anywhere near all this content. You, I trust your vibe. Tell me what I should be listening to." And so that would be the third thing I would say is figure out who are those curators who you really can associate your content with who are on the same page as you, have an audience who you think would like your stuff and just try and get associated with them.

**中文翻译:**
我观察到的一点是，我不确定人们是否意识到了内容创作的“一致性”和“可预测性”，这就是我们之前提到的“仓鼠轮”概念的来源。
但持续产出高质量的作品，并将其发布给受众去消费、回应和互动，确实大有裨益。这有点像“一万小时定律”，你必须做够一万小时才能真正精通。我一次又一次地看到这一点。
我是在——让我想想我多大了——应该是 2010 年开始在 YouTube 工作的。我觉得那是整个行业刚刚起步的时候。我们当时会编写关于创作者如何成功的“剧本”，因为当时很多精力都花在支持这个新兴经济上。我记得即使在 2010 年，直到今天，这仍然是首要的建议之一。
另一个建议是协作。与其他优秀的创作者合作，共享受众，互相引流。这是我们在我的初创公司 Kit 尝试应用的东西。我们会为创作者举办活动，让他们聚在一起，促进交流和“交叉授粉”，希望能对他们的职业生涯有所帮助。如果他们和在派对上认识的人一起拍 YouTube 视频，那对各方都有好处。这是前两点。
此外，我认为在这个内容爆炸的世界里，依然需要“策展人”（curator）的空间。策展人作为一种创作者是一个很有趣的概念。策展人的角色有点像图书出版公司、唱片公司或广播电台所扮演的角色，对吧？
这涉及到拥有一个品牌、拥有你代表的立场、拥有一种氛围或特质。那个人几乎就像是一个——不是贬义的“把关人”，而是像这样：“我，Camille，根本看不过来这么多内容。但我信任你的品味，告诉我该听什么。”所以我要说的第三点是：找出那些与你志同道合、受众可能喜欢你作品的策展人，并尝试与他们建立联系。

---

### [00:22:30] Lenny

**English:**
Yeah. The last piece is so... I totally see that all the time. If there's someone I super respect and they recommend something, I'm obviously going to value that recommendation highly. That's like we're influencing emerged from organically, right? People just, "Here's something you should check out," and then, "Oh, let's pay you to share things so that people try our product."

**中文翻译:**
是的。最后一点非常……我经常看到这种情况。如果是我非常尊敬的人推荐了什么，我显然会非常看重那个推荐。这就是“影响力”有机产生的方式，对吧？人们只是说：“嘿，这个东西值得一看”，然后就演变成了：“噢，我们付钱让你分享，好让人们尝试我们的产品。”

---

### [00:22:48] Camille Hearst

**English:**
That was the exact concept behind my startup, Kit. It was all about curating, finding people who are great recommenders for gear, having them curate that gear, and then you could follow the curators you love who wants to go look on Amazon and see reviews from people you've never heard of. Oftentimes, if it's your brother-in-law who's a great cyclist and they say, "Buy this," you just buy it. You don't even care what the reviews say because you trust that person.

**中文翻译:**
这正是我的初创公司 Kit 背后的核心理念。它完全是关于策展的：寻找那些擅长推荐装备的人，让他们整理这些装备，然后你可以关注你喜欢的策展人。谁想去亚马逊看那些素不相识的人写的评论呢？通常情况下，如果你的姐夫是个厉害的自行车手，他说“买这个”，你就买了。你甚至不在乎评论怎么说，因为你信任那个人。

---

### [00:23:14] Lenny

**English:**
What happened with the startup and what did you learn from that experience?

**中文翻译:**
那家初创公司后来怎么样了？你从那段经历中学到了什么？

---

### [00:23:17] Camille Hearst

**English:**
I started working on the startup in 2015. We managed to raise some money, raised over $2 million, which is a huge accomplishment, especially if you know anything about venture capital. They have a horrible track record when it comes to funding people of color, women, people who are non-cisgender white male, just the track record.
And we had an amazing experience building this company over several years, grew a bunch of the key metrics up into the right and got to a point where we were trying to figure out what the next move was and should we get a bridge round. We were trying to raise Series A. We were, I think, early on the creator economy trend. Probably about a year and a half later, it would've been, I think, I hope a snap to raise money. But anyway, we were battling a bunch of different choices, different options.
And I actually did this startup accelerator called StartX that's run out of Stanford which is my alma mater. And we learned a lot about how to sell a company and what M&A looks like. So we started exploring that path.
And in the end, it made the most sense for us to have an exit and join forces with Patreon. And so that's what we ended up doing. Sold the company in 2018, joined Patreon, worked there a couple of years, and that's where I met Adam.

**中文翻译:**
我是 2015 年开始做那家初创公司的。我们成功筹到了一些钱，超过 200 万美元，这是一项巨大的成就，尤其是如果你了解风险投资的话。在资助有色人种、女性、非顺性别白人男性方面，风投的历史记录非常糟糕。
我们在几年的时间里打造这家公司，经历了一段奇妙的时光，多项关键指标都呈增长态势。后来我们到了一个节点，需要决定下一步怎么走，是进行过桥融资，还是尝试 A 轮融资。我觉得我们当时处于创作者经济趋势的早期。如果再晚个一年半，我想筹款应该会容易得多。但总之，当时我们面临着很多不同的选择和方案。
后来我参加了一个叫 StartX 的创业加速器，它是从我的母校斯坦福大学发起的。我们在那里学到了很多关于如何出售公司以及并购（M&A）是怎么回事。于是我们开始探索那条路。
最终，对我们来说最合理的方案是退出并加入 Patreon。所以我们最后就是这么做的。2018 年卖掉了公司，加入了 Patreon，在那里工作了几年，也就是在那儿我遇到了 Adam。

---

### [00:24:49] Lenny

**English:**
Amazing. And I wanted to ask actually about that experience of selling a company. There's a lot of people listening right now who are thinking about selling their company or maybe you hope to sell their company someday, and I think there's a reality of it and then there's the idea of how it might go. I'm curious what you've taken away from that experience. And I guess specifically is there any advice you could share with folks that are thinking about selling their company someday? What you think maybe could have done earlier or also just share a glimpse of the reality of acquisitions?

**中文翻译:**
太棒了。我其实想问问关于卖掉公司的经历。现在有很多听众可能正在考虑卖掉公司，或者希望有一天能卖掉公司。我觉得现实情况和想象中的样子是有差距的。我很想知道你从那段经历中收获了什么。具体来说，对于那些考虑未来卖掉公司的人，你有什么建议吗？你觉得有哪些事本可以早点做？或者能不能让我们窥见一下收购的真实情况？

---

### [00:25:20] Camille Hearst

**English:**
I think it's different for every company for sure. Some companies get souped in and get bought. And other companies actively sell themselves.
We are definitely in the latter camp which means that we manage a process. It's similar to how you manage a process for fundraising. Not every company just meets the VC and raises money on the first try. They go through a process and meet tons of VCs and put them through the funnel and end up on the other side hopefully with a successful round. So I think that's one takeaway is treat it like a process and manage it like a process if it is something you're interested in. It doesn't really just... For most companies, I would say it doesn't just happen.
And then the second piece of advice I would give I think we should have been talking to potential acquirers from the beginning and sharing our vision and what we were trying to accomplish because we started those quite late in our journey as a company and it just meant it took... When I met a potential CPO, who would acquire the company, who would end up being my boss or CEO, it was their first time meeting me whereas if it had been their fifth time, we would've had a relationship established and they would've known more about the vision and what we're trying to do and hopefully, would've had some more time to think about it.
So those would be my two pieces of advice. Start preparing to sell your company from the moment you found it which is a weird thing because obviously, if you're starting a company, for most founders, they want it to be the next big thing, they're not starting it in order to sell it, but it's a good thing to have on your radar because you never know what the future holds. And then two is to treat it like a process.

**中文翻译:**
我认为每家公司的情况肯定都不一样。有些公司是被看中然后被收购的，而有些公司则是主动推销自己。
我们显然属于后者，这意味着我们要管理一个流程。这类似于你管理融资流程。不是每家公司都能在第一次见风投时就拿到钱。他们要经历一个过程，见大量的风投，把他们放入漏斗，最后希望能成功完成一轮融资。所以我觉得一个心得是：如果你感兴趣，就把它当作一个流程来对待和管理。对于大多数公司来说，收购不会凭空发生。
我要给出的第二条建议是：我认为我们应该从一开始就与潜在的收购者沟通，分享我们的愿景和目标。因为我们在公司发展的后期才开始做这些，这意味着……当我见到那位可能收购公司、并最终成为我老板的首席产品官（CPO）或首席执行官（CEO）时，那是他们第一次见到我。如果那是第五次见面，我们之间就已经建立了联系，他们会更了解我们的愿景和我们在做的事情，也希望能有更多时间去考虑。
所以这就是我的两条建议：一是从你创办公司的时刻起就准备好出售它。这听起来很奇怪，因为大多数创始人创办公司是希望它成为下一个伟大的事物，而不是为了卖掉它，但把它放在你的雷达上是件好事，因为你永远不知道未来会发生什么。二是把它当作一个流程来对待。

---

### [00:27:07] Lenny

**English:**
Yeah. On that piece of knowing people who may acquire you, I found that to be a thousand percent true. We sold our company the Airbnb and that's how it got to Airbnb and what I realized is you just need people who may buy you in the future to have you in their head when they have a problem so that they could be like, "Oh, Camille and her team could solve this problem for us. Let us go chat with her and-

**中文翻译:**
是的。关于结识潜在收购者这一点，我发现是百分之百正确的。我们把公司卖给了 Airbnb，我就是这样进入 Airbnb 的。我意识到，你只需要让那些未来可能买下你的人在遇到问题时能想到你，这样他们就会觉得：“噢，Camille 和她的团队可以帮我们解决这个问题。让我们去找她聊聊，看看——”

---

### [00:27:28] Camille Hearst

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:27:28] Lenny

**English:**
... see if they're interested in acquisition."
And on the process piece too, 1000% resonates. We basically... When we started chatting with a company, we're just like, "Okay, who else could potentially acquire us? Let's make a big list and who we can talk to at that company as soon as possible and then just explore." But it's more challenging there because it's you reaching out to them being like, "Hey, you want to chat about buying our company," versus them reaching out to you. So to your point, always goes better if they reach out to you, but you can't always control that.

**中文翻译:**
“……看看他们是否对收购感兴趣。”
关于流程那部分，我也非常有共鸣。基本上，当我们开始与一家公司洽谈时，我们会想：“好吧，还有谁可能收购我们？让我们列个大名单，看看能尽快联系到那家公司的谁，然后开始探索。”但这样做更有挑战性，因为是你主动找他们说：“嘿，想聊聊买我们公司的事吗？”而不是他们主动找你。所以正如你所说，如果他们主动找你，情况总是会更好，但你并不总能控制这一点。

---

### [00:27:54] Camille Hearst

**English:**
Right. Or if the meeting is not under the context of buying it all, it's like, "We're working on something cool. We have a great vision. It aligns with what you're doing. Maybe there's a partnership here," versus just tell you what we're doing and then when I contact you in 12 months about buying me, you've heard of me before.

**中文翻译:**
对。或者见面的背景根本不是为了收购，而是说：“我们正在做一些很酷的事情，我们有一个伟大的愿景，这与你们正在做的事情很契合。也许我们可以合作。”这比单纯告诉对方我们在做什么要好，这样当我 12 个月后联系你谈收购时，你已经听说过我了。

---

### [00:28:12] Lenny

**English:**
I find even when you're starting to chat about acquisitions, you never want to say directly, "Hey, you want to buy us?" It's like, "Hey, you want to have a strategic partnership of some kind? You want to explore partnership?" So funny.

**中文翻译:**
我发现即使当你开始谈论收购时，你也永远不想直接说：“嘿，你想买下我们吗？”而是会说：“嘿，你想建立某种战略伙伴关系吗？你想探索一下合作吗？”挺有意思的。

---

### [00:28:23] Camille Hearst

**English:**
Like dating.

**中文翻译:**
就像约会一样。

---

### [00:28:24] Lenny

**English:**
Yeah, yeah. You can't just be too direct sometimes.
So when you got to Patreon, I don't know if it was immediate or eventually you ended up leading the creator side of the marketplace, and I find that looking at your background, you basically stayed on the supply side of marketplaces through your career mostly.
And I actually did the same thing. All I worked on at Airbnb especially, or mostly, was the host side.
And I think it takes a specific mindset in person to be excited about that side of the marketplace versus the consumer side which is where everyone always generally wants to go, to the customer side. So I'm curious what it is that's drawn you to that side of the business across all the places you work and then just what you found to be important to be successful in that role and on that side?

**中文翻译:**
是啊，有时候不能太直接。
当你去 Patreon 时，我不确定是立即还是后来，你最终负责了平台的创作者端（供给侧）。我发现看你的背景，你的职业生涯大部分时间都停留在平台的供给侧。
我也做过同样的事情。我在 Airbnb 工作期间，主要负责的也是房东端。
我认为，要对平台的这一端（供给侧）产生兴趣，而不是大家都想去的消费者端（需求侧），需要一种特定的心态。所以我很好奇，在你工作过的所有地方，是什么吸引你关注业务的这一端？你认为要在那个角色和那一端取得成功，最重要的是什么？

---

### [00:29:09] Camille Hearst

**English:**
What drew me to that side of the business probably was maybe accidental at the beginning. Just again, coming from this musical family and background, I always had a natural interest in helping artists make a living. So I think that interest was there.
At Apple, I did... There were only two PMs there. We did everything.
At YouTube, I accidentally ended up in creator.
But where I started understanding deeply the dynamics of the marketplace was actually my experience and the one job I've had that not been in the creator or art or these big consumer platforms or creator economy which was at a startup called Hailo based out of London and at the time was a huge competitor to Uber and Lyft in the ride sharing and ride hailing space and I worked on the supply side making sure that there were enough cars to fuel the demand.
And in a marketplace like that where it's real time people trying to get a cab to go from uptown to downtown, you see the inexperience firsthand the impact to your business if you don't have suppliers, if your suppliers aren't happy, if they go on strike, if there's regulations that mean you can't use your service. And there I think I was...
So one of the projects that I worked on that I launched was the U.S. Uber competitor because Hailo in Europe was all about getting taxi cabs and did not play in the livery is what it's called in New York or the private rides. Basically, it's like your uncle or your aunt or your cousin who can switch on Lyft and go pick up whoever. That just was not a thing in Europe.
And so we had to figure out how to launch that in the U.S., how to get drivers on how to create this supply and it was like it doesn't matter how nice the user experience is, how great the marketing is, how much demand you can generate if when someone opens that app, there are no cars available.
So a lot of people talk about marketplaces as chicken and egg. I actually just think they're two-sided and you start with the supply and at the end of the day, you can optimize for the demand side or choose who you're going to prioritize in terms of if there's a conflict, we're going to pick this side or the other.
And yes, you won't be successful with one side or the other but I just experienced and lived firsthand the pain of having built this great operations back in that fed into this gray UI and then you open that app and you can't get a ride because there aren't enough cars available.
So I think that solidified my feeling that with marketplaces, you can't lose sight of the solving real pain points and needs for the supply side in order to make sure the entire business can operate.

**中文翻译:**
吸引我关注业务那一端的原因，最初可能是偶然的。正如我所说，由于我的音乐家庭背景，我天生就对帮助艺术家谋生感兴趣。所以这种兴趣一直存在。
在苹果，当时只有两个 PM，我们什么都做。
在 YouTube，我阴差阳错地进入了创作者端。
但我真正开始深入理解平台动态，其实是在我唯一一份不在创作者、艺术或大型消费者平台领域的工作经历中。那是在一家总部位于伦敦的初创公司 Hailo，当时它是 Uber 和 Lyft 在网约车领域的强劲对手。我当时负责供给侧，确保有足够的车辆来满足需求。
在那样一个实时匹配的市场中，人们想打车从市中心去郊区，如果你没有供应商（司机），或者供应商不开心、罢工，或者有法规限制你使用服务，你会亲身感受到这对业务的巨大冲击。
我当时负责启动的一个项目是 Hailo 在美国的竞争产品。因为 Hailo 在欧洲主要是叫出租车，不涉及私家车（在纽约被称为 livery）。基本上就是像你叔叔阿姨那样打开 Lyft 就能接人的模式，这在当时的欧洲并不存在。
所以我们必须弄清楚如何在美国推出这种服务，如何招募司机，如何创造这种供给。当时的感觉是：如果有人打开 App 却发现没车，那么用户体验做得再好、营销做得再棒、产生的需求再多也无济于事。
很多人把平台市场比作“先有鸡还是先有蛋”的问题。我其实认为它们就是双向的，而你应该从供给侧开始。最终，你可以优化需求侧，或者在发生冲突时决定优先考虑哪一侧。
当然，缺了哪一侧你都不会成功，但我亲身体会过那种痛苦：构建了强大的后台运营和精美的 UI，结果用户打开 App 却打不到车，因为没有足够的可用车辆。
所以这巩固了我的信念：在做平台业务时，你不能忽视解决供给侧的真实痛点和需求，这样才能确保整个业务的运转。

---

### [00:32:26] Lenny

**English:**
I've done a bunch of research into marketplaces and I found basically the same thing, that supply is almost always where you need to focus almost all your time especially at the beginning.
The way I think about it is that's if you have a store that's stuff on your shelves and you're not going to have a business if you don't have anything on the shelves.

**中文翻译:**
我对平台市场做了大量研究，发现结论基本一致：供给侧几乎总是你投入绝大部分精力的地方，尤其是在初期。
我的理解是，这就像开店，供给就是货架上的商品。如果货架上空空如也，你就没法做生意。

---

### [00:32:41] Camille Hearst

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:32:42] Lenny

**English:**
There's a few rare cases, I forget exactly which they were, where demand was actually the bigger challenge and supply is really easy.
You know what? It was Rover. Rover had no problem it turns out with supply because who wouldn't want to make 50 bucks watching a dog for a few hours. It was a really easy sell and a lot of people could do it and wanted to do it so they actually found supply was not an issue.
But in most cases exactly how you said most 10 times supply is what people are looking for.

**中文翻译:**
也有极少数例外，我忘了具体是哪些了，在那些案例中，需求反而是更大的挑战，而供给非常容易。
我想起来了，是 Rover（宠物托管平台）。事实证明 Rover 在供给方面没问题，因为谁不想通过看几个小时狗就赚 50 美元呢？这很容易推销，很多人能做也愿意做，所以他们发现供给不是问题。
但在大多数情况下，正如你所说，十有八九供给才是人们关注的重点。

---

### [00:33:05] Camille Hearst

**English:**
Totally.
I find that the counter example I hear a lot is eBay, how they were so good at aggregating demand, they were basically able to force suppliers to the terms that they like. But I can't imagine... It'd be interesting to talk to some folks who were at eBay in their early days that the whole thing didn't start up without them going out and figuring out who are the key suppliers we need to get on this thing so that we can get aggregating demand.

**中文翻译:**
完全同意。
我发现经常听到的反例是 eBay，他们非常擅长聚合需求，以至于基本上能强迫供应商接受他们喜欢的条款。但我无法想象……如果能和 eBay 早期的员工聊聊会很有趣，我相信如果没有他们去弄清楚需要拉拢哪些关键供应商入驻，整个平台是不可能启动并开始聚合需求的。

---

### [00:33:32] Lenny

**English:**
Yeah. You got to have some good stuff on eBay. I wonder if Beanie Babies or whatever they started with.

**中文翻译:**
是的，eBay 上得有好东西才行。我在想是不是从豆豆娃（Beanie Babies）或者其他什么东西开始的。

---

### [00:33:37] Camille Hearst

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:33:39] Lenny

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Comm, Quora, and Modern Treasury trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs and get ready for audits in weeks, not months.
By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA, and many more, Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders.
Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks.
For a limited time, Lenny's Podcast listeners get $1000 off Vanta. Go to vanta.com/lenny, that's V-A-N-T-A .com/lenny, to learn more and to claim your discounts. Get started today.

**中文翻译:**
本集节目由 Vanta 赞助，帮助你简化安全合规流程，加速业务增长。数千家快速增长的公司，如 Gusto、Comm、Quora 和 Modern Treasury，都信任 Vanta 来帮助构建、扩展、管理和展示其安全与合规计划，并在几周而非几个月内为审计做好准备。
通过提供最受青睐的安全和隐私框架，如 SOC 2、ISO 27001、GDPR、HIPAA 等，Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。
超过 5000 家快速增长的公司使用 Vanta 将 SOC 2 和其他框架涉及的工作自动化程度提高到 90%。
在限时优惠期间，Lenny 播客的听众可享受 Vanta 1000 美元的优惠。访问 vanta.com/lenny（即 V-A-N-T-A .com/lenny）了解更多信息并领取折扣。立即开始吧。

---

### [00:34:37] Lenny

**English:**
You mentioned Apple and I want to spend a little time there. So you said you were the second PM on iTunes back in the day and I'm curious what you learned from the experience you had working at Apple. I think I read somewhere you worked maybe closely with Steve Jobs and Jony Ive, but I don't know if that's true, but I'm curious just... No? Okay, but you do have a Steve Jobs story?

**中文翻译:**
你提到了苹果，我想在那儿多聊一会儿。你说你当年是 iTunes 的第二位产品经理，我很想知道你在苹果工作的经历中学到了什么。我好像在什么地方读到过，你可能曾与史蒂夫·乔布斯和乔尼·艾夫（Jony Ive）密切合作过，不知道是不是真的？……不是吗？好吧，但你确实有一个关于史蒂夫·乔布斯的故事？

---

### [00:34:57] Camille Hearst

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:35:00] Camille Hearst

**English:**
Yes. So I was very early on in the iTunes days I started interning there when I came out of grad school and my internship was actually in label relation and then I started a full-time job doing product marketing.
At Apple at the time, I think even to this day, they didn't have a product manager title, they had product marketing managers. And so one of my colleagues who remains good friends to this day, Steve was the first also named Steve, not Steve Jobs was the first PMM working on iTunes and he primarily was doing all the client stuff. He launched the store and everything. But I think I was the second person in the iTunes group with that title. So that was really cool.
And then as far as the Steve Jobs story, I would think I mentioned to you people like hearing this story, nothing happened, I just went up to him and said, "Hi, I'll tell the story."
But I think the context of why people find it interesting is because of other stories about Steve. So let me give a little context.
Those Steve Jobs lore was that if you were in an elevator with him, you better be prepared to talk about what you do at the company because he had a habit of getting in the elevator and looking at you and saying, "What do you do? What do you do here?" And there were also rumors that people who had not given him a good answer that ended up being their last day at Apple.
So there was someone who I didn't know personally but worked in my department before I got there who got in an elevator and looked up and Steve was approaching him. And so he went to press the button to open the door and accidentally press the one to close the door and was doing this press... You can't see me if you're listening on podcast but frantically pressing the button, trying to open the door, but accidentally pressing the close door button and the elevator going to its destination. And apparently he got off and just bolted straight up, ran down the hallway.

**中文翻译:**
是的。我在 iTunes 早期就在那里了，研究生毕业后我开始在那儿实习，我的实习岗位其实是唱片公司关系（label relation），后来我开始做产品市场（product marketing）的全职工作。
当时的苹果，我想直到今天也是，他们没有“产品经理”这个头衔，而是叫“产品市场经理”（PMM）。我的一位同事，直到今天我们还是好朋友，他也叫史蒂夫（不是乔布斯），他是 iTunes 的第一位 PMM，主要负责所有的客户端事务。他推出了商店等等。我想我是 iTunes 团队中第二个拥有这个头衔的人。那真的很酷。
至于史蒂夫·乔布斯的故事，我想我跟你提过，人们喜欢听这个故事。其实没发生什么惊天动地的事，我只是走过去对他说了声“嗨”。我会讲讲这个故事。
但我认为人们觉得它有趣的原因在于关于史蒂夫的其他传闻。让我提供一点背景。
关于史蒂夫·乔布斯的传说是，如果你和他同乘电梯，你最好准备好谈谈你在公司做什么，因为他有个习惯，进电梯后会盯着你问：“你是做什么的？你在这里负责什么？” 还有传言说，那些没能给出满意答案的人，那天就成了他们在苹果工作的最后一天。
有个我不认识、但在我入职前就在我部门工作的人，有次进了电梯，抬头一看史蒂夫正走过来。于是他想去按开门键，结果误按了关门键。他就像这样一直按……如果你在听播客可能看不见我，但他当时在疯狂地按按钮，想把门打开，结果却误按了关门键，电梯直接开往目的地了。据说他下电梯后直接拔腿就跑，冲向了走廊尽头。

---

### [00:37:02] Lenny

**English:**
He'll never remember my face.

**中文翻译:**
他永远不会记得我的长相。

---

### [00:37:03] Camille Hearst

**English:**
Yeah, exactly.

**中文翻译:**
没错，正是如此。

---

### [00:37:04] Lenny

**English:**
I disappeared.

**中文翻译:**
我消失了。

---

### [00:37:04] Camille Hearst

**English:**
So that's the context.
In 2005, it's my first day of my internship at Apple and I had this situation where I attended graduation because I only had one semester left to go back to, so I just decided to attend the graduation. That happened basically the week before. And for those of you who are the job span, this is when he gave his really inspiring and famous Stanford commencement speech and it's an awesome, awesome thing to listen to.

**中文翻译:**
这就是背景。
2005 年，是我在苹果实习的第一天。当时的情况是，我刚参加完毕业典礼，因为我只剩一个学期就要回学校了，所以我决定去参加毕业典礼。那大概发生在入职前一周。对于那些关注乔布斯的人来说，那就是他发表那篇非常鼓舞人心且著名的斯坦福大学毕业演讲的时候，那真的是一段非常非常值得一听的演讲。

---

### [00:37:41] Lenny

**English:**
You were at that speech?

**中文翻译:**
你当时在演讲现场？

---

### [00:37:42] Camille Hearst

**English:**
I was there, yeah.

**中文翻译:**
我在现场，是的。

---

### [00:37:42] Lenny

**English:**
Whoa. People love that speech.

**中文翻译:**
哇。人们超爱那段演讲。

---

### [00:37:47] Camille Hearst

**English:**
It's a good one. It's really-

**中文翻译:**
确实很棒。它真的——

---

### [00:37:48] Lenny

**English:**
What did you feel being there listening to it in the moment?

**中文翻译:**
当时在现场听的时候，你是什么感觉？

---

### [00:37:51] Camille Hearst

**English:**
Totally inspired.
Apple was not quite what it is today in terms of brand and influence and just it's at the peak. It's really come a long way. It was still when I met the recruiter at a conference, I was like, "Apple? What do they do again? My roommate had a Mac, but what's iTunes? Oh, yeah, I think I've heard of that. I think..."
The dancing iPod silhouette ads which really sent Apple over the top. Those hadn't even really dropped yet, but it was starting, right? It was starting to percolate and bubble and you heard more and more about it and just the association with music was making Apple more cool.
But that speech is... Talk about a commencement speech. That is top-notch.
And Steve's great at those. He was phenomenal storyteller.
So graduation is what? Saturday, I go home Sunday. The Monday I started my internship and here we are at Cafe Max with my new coworkers and Steve is sitting literally at the table next to me. And so I was like, "Oh my gosh, there's Steve. I would love to say hi and introduce myself and everyone at the table."
Now mind you, I hadn't heard this story about the elevator button in the full yet because it was my first day, but they're all looking at each other. They're like, "Yeah, go say hi to him if you want, but you're an intern." They say, "Hopefully, he doesn't fire you on your first day."
But I've always, in my family and in my life, had this encouragement to say hi to people when you see them and let them know that you appreciate what they do and just thank them because it doesn't happen often.
A lot of times, people go and they ask for a picture or an autograph but this idea of just introducing yourself, saying hello, and thanking someone for something that they've done that impacted you to something that's been a way that my parents have encouraged me to behave in the world and something that I saw them do and saw them model because probably, again, coming from my dad being a musician and being fans of other musicians that like a thing in music, the artist culture that talked to one another about how something you created influenced you or whatnot.
So I went up to him and I got up from my lunch table and walked over and I said, "Hi, my name's Camille. I'm interning here this summer. It's my first day. I was at graduation at Stanford on Saturday and your speech was amazing. I was really inspired. I'm so excited to be here and so excited to work on this company and I just wanted to say thank you for spending your time doing that speech for us on Saturday."
And he was like, "Who are you? What? You're an intern? Well, what are you doing here?" It was a little... We had a little bit of an exchange. I had to clarify like, "Yeah, I graduated, but I'm interning and I have another semester left." And he was like, "Oh, okay. Well, welcome to Apple and good luck and I hope you have a really great experience this summer." And that was it. I didn't get fired and I said hello to Steve.
And after that, I felt like I knew him. Every time, I'd see him around campus I'd wave high and I think he had no idea who I was but he would look at me confused and then wave back hello.

**中文翻译:**
深受鼓舞。
当时的苹果在品牌和影响力方面还远不如今天这样处于巅峰。它确实走过了很长一段路。当时我在一个会议上遇到招聘人员时，我还在想：“苹果？他们是做什么的来着？我室友有一台 Mac，但 iTunes 是什么？噢，对，我好像听说过。我想……”
那些让苹果声名大噪的 iPod 剪影舞蹈广告当时甚至还没真正推出，但苗头已经显现了，对吧？它开始渗透、发酵，你会听到越来越多关于它的消息，而且与音乐的结合让苹果变得更酷了。
但那场演讲……说到毕业典礼演讲，那是顶级的。
史蒂夫非常擅长这些，他是个了不起的讲故事的人。
毕业典礼是周六，我周日回家。周一我开始实习，当时我和新同事在 Cafe Max 餐厅，史蒂夫就坐在我隔壁桌。我当时想：“天哪，那是史蒂夫。我很想过去打个招呼，自我介绍一下。”
请注意，因为那是我的第一天，我还没听过那个电梯按钮的完整故事，但同事们都面面相觑。他们说：“行啊，你想去打招呼就去吧，但你只是个实习生。”他们还说：“希望他别在你入职第一天就把你开除了。”
但在我的家庭和生活中，我一直被鼓励在见到人们时主动打招呼，让他们知道你欣赏他们的工作，并向他们致谢，因为这种事并不常发生。
很多时候，人们过去是索要照片或签名，但仅仅是介绍自己、问个好，并感谢对方所做的对你产生影响的事情，这是我父母一直鼓励我的处世方式，也是我看着他们身体力行的。这可能还是因为我父亲是音乐家，我们是其他音乐家的粉丝，在音乐和艺术家文化中，大家会互相交流你创作的作品如何影响了别人。
于是我站起来，离开餐桌走过去说：“嗨，我叫 Camille。我今年夏天在这里实习，今天是我的第一天。周六我在斯坦福的毕业典礼现场，您的演讲太棒了。我深受启发。我非常激动能来到这里，为这家公司工作，我只是想谢谢您周六花时间为我们做那场演讲。”
他当时的反应是：“你是谁？什么？你是实习生？那你在这里做什么？”我们进行了一点交流。我不得不澄清说：“是的，我毕业了，但我现在是实习生，我还有一个学期。”他说：“噢，好吧。那么欢迎来到苹果，祝你好运，希望你今年夏天有一段很棒的经历。”就这样。我没被开除，还跟史蒂夫打了个招呼。
在那之后，我觉得我认识他了。每次在园区见到他，我都会挥手致意，我想他根本不知道我是谁，但他会一脸困惑地看着我，然后也挥手回礼。

---

### [00:41:12] Lenny

**English:**
"She's so friendly. Who's this person?"

**中文翻译:**
“她真友好。这人是谁啊？”

---

### [00:41:14] Camille Hearst

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:41:15] Lenny

**English:**
Do you still remember how you would've described what you do? I have a feeling it's seared in your head, but if not, then never mind.

**中文翻译:**
你还记得你会如何描述你的工作吗？我感觉这已经刻在你脑子里了，如果没有，那也没关系。

---

### [00:41:21] Camille Hearst

**English:**
Oh, my statement, if he had asked me where [inaudible 00:41:23].

**中文翻译:**
噢，如果他问我，我的陈述会是……[听不清]。

---

### [00:41:23] Lenny

**English:**
Yeah, exactly.

**中文翻译:**
对，没错。

---

### [00:41:24] Camille Hearst

**English:**
Well, yeah, I was lucky because one of the things that I did he would actually know exactly what it is which is I would manage press rooms whenever there was an iTunes launch. So this is very much grunt work.
But when there would be a press event for one of the new iTunes 6 launch or whatever, they would have interviews with Walter Isaacson or I don't know if Kara Swisher was working back then, but whoever the journalist and Steve would have a room set up with an iMac computer with an iTunes library full of track. There would be whatever the new iPod was synced to that computer and all of the track. And after every interview, everything would have to be reset.
Also, the library was crafted so he would give feedback for months on the content of the library because he would do demos. And so he wanted to know, "Make sure all my favorite tracks are in there, my favorite Beatles records, my favorite Bob Dylan records, and who's this artist? Let me check them out. Okay, they don't cross the bar. Oh, what's this song? Oh, I love this song. Oh, add this." So he was very involved in the entire presentation and someone had to go do all that.
So who better than the fresh out of masters of engineering in Stanford graduate student to go do all of the grunt work of making library? But those are the kinds of details that he paid attention to. And so I would've just told him that I did product marketing and one of my main responsibilities was fixing the press room for him and he would've been like, "Oh, okay."

**中文翻译:**
嗯，是的，我很幸运，因为我做的一件事他肯定非常清楚，那就是每当有 iTunes 发布会时，我会负责管理新闻发布室。这基本上是非常琐碎的苦差事。
当有 iTunes 6 或其他版本的发布会时，会有像沃尔特·艾萨克森（Walter Isaacson）或者卡拉·斯威舍（Kara Swisher，我不确定她当时在不在职）这样的记者来采访。史蒂夫会准备一个房间，里面有一台 iMac，上面装满了曲目的 iTunes 库。还会有当时最新的 iPod 与那台电脑同步，包含所有曲目。每次采访结束后，所有东西都必须重置。
此外，那个曲库是精心打造的，他会花几个月时间对曲库内容提出反馈，因为他要亲自做演示。他会要求：“确保我最喜欢的曲目都在里面，我最喜欢的披头士唱片、鲍勃·迪伦唱片。这个艺术家是谁？让我听听。好吧，他们不够格。噢，这首歌是什么？我喜欢这首歌，把它加进去。”所以他深度参与了整个演示的每一个细节，而必须有人去完成这些工作。
那么，还有谁比一个刚从斯坦福大学工程硕士毕业的研究生更适合去做这些整理曲库的苦差事呢？但这些正是他所关注的细节。所以我会直接告诉他，我负责产品市场，我的主要职责之一就是为他整理新闻发布室，他大概会说：“噢，好吧。”

---

### [00:43:01] Lenny

**English:**
You mentioned that your title is product marketing manager and there was a recent kind of a hubbub on Twitter where Brian Chesky at Airbnb shared that they shifted the role of product manager to essentially the Apple model. And I'm curious what your perspective is on that approach to product, the Apple kind of way versus a traditional product manager?

**中文翻译:**
你提到你的头衔是产品市场经理（PMM），最近 Twitter 上有一阵骚动，Airbnb 的 Brian Chesky 分享说他们将产品经理的角色基本上转变为“苹果模式”。我很想知道你对这种产品方法的看法，即苹果模式与传统产品经理模式的区别？

---

### [00:43:21] Camille Hearst

**English:**
They have done this very intentionally from what I've seen. I know they hired Hiroki actually from Apple-

**中文翻译:**
据我观察，他们这样做是非常有针对性的。我知道他们实际上从苹果挖走了 Hiroki——

---

### [00:43:29] Lenny

**English:**
Yeah. A lot of Apple people.

**中文翻译:**
是的，挖了很多苹果的人。

---

### [00:43:31] Camille Hearst

**English:**
Yeah. And actually one of the new leaders they've hired, I don't know if you know Judson Coplan, dear friend of mine, we interned that same summer at Apple and he worked there for 15 years before heading over to Airbnb.
But yeah, the Apple construct, it's much more of design and engineering led organizations, craftspeople I would say more so than strategy people. So that was one of the stark differences I saw in my transition from Apple to Google. There are a lot more like people from Coca-Cola and McKinsey and Bain at Google. I don't think any of those people even existed at Apple.
And it was very much like, "Let's 3D chess our way into what our next move is going to be." Whereas at Apple it was, "Let's tinker and let's craft and let's build and let's see what feels right." There are different approaches. As a result, the approach to product management was quite different.
So I think it makes sense. Brian Chesky's background is a designer so it probably resonates a bit more within the Apple way.
And then in terms of what it means for product managers on an individual level, so again, there weren't product managers, the closest thing would've been CPMs, technical program managers who help manage the sprints and manage the schedule and listing out what features would happen.
I spent a lot of my time with the incredibly talented design team and if I had ideas of product features or... We would think months ahead of time, like what's the anchor story or what are the three key messages for the launch of iTunes 10 or whatever and we might have ideas for new features that would go in that.
But because we had that moment in time, we knew well ahead we were planning for and you were working on the messaging and working on the consumer positioning again while in advance of anything actually being live or built. That was what framed what features you wanted to build and what problems you would put on the table to be solved as opposed to as clear cut metric you're trying to drive forward which is how product management has evolved in another capacity.

**中文翻译:**
是的。实际上他们雇佣的一位新领导，我不知道你是否认识 Judson Coplan，他是我的好朋友，我们同年夏天在苹果实习，他在那里工作了 15 年才去 Airbnb。
苹果的结构更像是设计和工程驱动的组织，我会说他们更多是“手艺人”而非“战略家”。这是我从苹果跳槽到谷歌时看到的显著差异之一。谷歌有很多来自可口可乐、麦肯锡和贝恩的人，我觉得这类人在苹果根本不存在。
在谷歌，感觉非常像是在下“3D 国际象棋”，推演下一步该怎么走。而在苹果，则是“让我们捣鼓捣鼓，精雕细琢，把它造出来，看看感觉对不对”。这是不同的方法。因此，产品管理的方法也大不相同。
所以我认为这很合理。Brian Chesky 的背景是设计师，所以苹果模式可能更能引起他的共鸣。
至于这对个人层面的产品经理意味着什么，再次强调，苹果当时没有产品经理，最接近的角色是 CPM（技术项目经理），他们负责管理冲刺（sprints）、管理进度并列出要实现的功能。
我当时花了很多时间与才华横溢的设计团队在一起。如果我有关于产品功能的想法……我们会提前几个月思考，比如 iTunes 10 发布的核心故事是什么，或者三个关键信息是什么，我们可能会针对这些想法提出新功能。
因为我们有明确的时间节点，我们很早就知道在为什么做计划，在任何东西上线或建成之前，你就在研究信息传递和消费者定位。这决定了你想构建什么功能，以及你想解决什么问题，而不是像现在产品经理演变出的那样，仅仅是为了推动某个明确的指标。

---

### [00:45:52] Lenny

**English:**
And that's how it works at most companies.

**中文翻译:**
而大多数公司现在就是这么运作的。

---

### [00:45:52] Camille Hearst

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### [00:45:54] Lenny

**English:**
I want to come back actually to the creator economy stuff. I feel like you've worked in the creator economy longer than most anyone, and so I wanted to use our time to spend a little more time there. What about on the platform side? If someone were thinking about starting a company to cater to creators, to build a new platform maybe for creators to make a living, do you have any advice for them? Where do you think maybe there's opportunity? Where do you think it's like, "No, probably you don't want to spend time here?"

**中文翻译:**
我想回到创作者经济的话题。我觉得你在这个领域工作的时间比大多数人都长，所以我想多花点时间聊聊这个。从平台的角度来看，如果有人想创办一家服务于创作者的公司，或者建立一个新的平台让创作者谋生，你对他们有什么建议吗？你认为哪里可能有机会？哪里又是“不，你可能不想在这里浪费时间”的地方？

---

### [00:46:24] Camille Hearst

**English:**
I think with any company, solving a real problem is the most important thing. So creators have lots of challenges and things that can be solved. Some painful things are more acutely felt than others.
I think at the core, every creator needs two things. They need to grow an audience and they need to get paid so that they can make a living. And in some ways, I do think that growing an audience is more important because with that audience, it opens up opportunities in ways that you can monetize.
But there are all kinds of other things like we're talking about financing, health insurance, the list goes on, things we face as human beings, trying to be freelancers in the world often apply equally to people who are creative for a living.
And then there are unique things about the creator space like the spurts of energy, the spurts of creative flow that maybe don't apply in a salary job or an hourly job.
So there are lots of problems out there still to be solved for creators. I don't think that this space is nearly solved, done, stick a fork in it. So my advice would be to look at the problems that exist and pick a real one and go for it.

**中文翻译:**
我认为对于任何公司来说，解决真实的问题都是最重要的。创作者面临很多挑战，有很多事情可以去解决。有些痛点比其他的更强烈。
我认为核心在于，每个创作者都需要两样东西：增长受众和获得报酬以维持生计。在某种程度上，我认为增长受众更重要，因为有了受众，就会开启各种变现的机会。
但还有各种其他事情，比如我们讨论过的融资、医疗保险等等，这些我们作为人类在世界上尝试做自由职业者时面临的问题，同样适用于以创意为生的人。
此外，创作者领域还有一些独特之处，比如能量的爆发期、创意流的爆发期，这些在拿月薪或时薪的工作中可能并不适用。
所以，创作者领域仍有很多问题有待解决。我不认为这个领域已经完全被开发完了。所以我的建议是：观察现有的问题，挑选一个真实的痛点，然后全力以赴。

---

### [00:47:47] Lenny

**English:**
Wise advice.
Have you seen this podcaster, Bobbi, I forget her last name, she rocketed up to the fourth biggest podcast in America with a few episodes of her podcast, she interviews Drake and a few comedians. Have you seen this person?

**中文翻译:**
明智的建议。
你见过那个叫 Bobbi 的播客主吗？我忘了她的姓。她的播客只出了几集就飙升到全美第四大播客，她采访了 Drake 和一些喜剧演员。你见过这个人吗？

---

### [00:48:05] Camille Hearst

**English:**
I feel like I should, but as we said at the beginning, I'm such a music head, I don't listen to any podcast.

**中文翻译:**
我觉得我应该听说过，但就像我们开头说的，我是个纯粹的音乐迷，我不听任何播客。

---

### [00:48:11] Lenny

**English:**
The reason I thought of her is I was watching a clip of her on an interview show and she hasn't made any money from this even though she's got the hottest podcast in America right now, and we're going to link to her in the show notes, but she's hilarious.

**中文翻译:**
我想到她的原因是，我在一个访谈节目中看到她的片段，尽管她现在拥有全美最火的播客，但她还没从中赚到钱。我们会在节目笔记中附上她的链接，她真的非常搞笑。

---

### [00:48:25] Camille Hearst

**English:**
Amazing.

**中文翻译:**
太神奇了。

---

### [00:48:25] Lenny

**English:**
There's something about her that just is really fun to watch. But okay, no podcast for you right now. We'll get you on a podcast. You're on the podcast.

**中文翻译:**
她身上有一种特质，看她的节目真的很有趣。不过好吧，你现在不听播客。我们会让你上播客的。你现在就在播客里。

---

### [00:48:32] Camille Hearst

**English:**
I'm on a podcast now.

**中文翻译:**
我现在就在播客里。

---

### [00:48:34] Lenny

**English:**
There we go.
You've mentioned your parents and I was reading your Wikipedia page and the way your parents are described on there is radical Buddhist artists technologists. I'm curious what that means maybe and then also just is there a memory or moment of growing up that highlights that aspect of them?

**中文翻译:**
这就对了。
你提到了你的父母，我读了你的维基百科页面，上面对你父母的描述是“激进的佛教徒、艺术家、技术专家”。我很想知道这具体意味着什么，以及在你成长的过程中，有没有什么记忆或瞬间能体现他们这一面的？

---

### [00:48:56] Camille Hearst

**English:**
What's funny about this is I had no idea how to Wikipedia page until you sent that.

**中文翻译:**
有趣的是，在你发给我之前，我根本不知道我有维基百科页面。

---

### [00:48:56] Lenny

**English:**
What?

**中文翻译:**
什么？

---

### [00:48:56] Camille Hearst

**English:**
I don't know where it came from.

**中文翻译:**
我不知道那是哪来的。

---

### [00:48:56] Lenny

**English:**
Oh my God. Who made this?

**中文翻译:**
天哪。谁做的？

---

### [00:48:56] Camille Hearst

**English:**
Exactly.

**中文翻译:**
就是说啊。

---

### [00:48:56] Lenny

**English:**
That's amazing.

**中文翻译:**
太不可思议了。

---

### [00:49:08] Camille Hearst

**English:**
Like, "What? I'm on Wikipedia?" So that was funny.

**中文翻译:**
就像，“什么？我上维基百科了？”这挺逗的。

---

### [00:49:08] Lenny

**English:**
That's crazy.

**中文翻译:**
太疯狂了。

---

### [00:49:13] Camille Hearst

**English:**
Yeah.
So let's see. I grew up in San Francisco in the eighties and nineties. My parents started practicing Buddhism on the East Coast in the seventies. And my dad was, I mentioned he's a drummer and a musician, and he also had a studio. We had this closet under the stairs that he turned into a production studio and he was an artist.
He worked for the city. My mom worked for the city, didn't have a ton of money growing up, and so a lot of the computer equipment came from the street. He would find... Somebody put a PC out... He was building PCs before the gamers were doing it. And I remember he would come home with boxes and boards and chips and would literally go get a book from the library or the store and would figure out how to assemble these computers, keyboards that were broken. He would just fix them. Probably should have been a mechanical engineer, super talented at this stuff.
But basically he had this entire production studio with drum machines and all the equipment. And I was his helper. So I would help him solder stuff together and tinker and actually put these computers together. So that's probably... I don't know where that quote came from. I'll have to go click the link of what the reference is from, but that's some of the background there.
And the other thing that happened back in San Francisco in the eighties and nineties, we used to host Buddhist meetings in our house and back then there was a lot of what was called street propagation like the Hare Krishna used to be up and down Haight Street right around the corner for me.
The Nation of Islam, which my brother joined for a period of time, would be selling Final Calls and bean pie brothers on the corners.

**中文翻译:**
是的。
让我想想。我在八九十年代的旧金山长大。我父母七十年代在东海岸开始信奉佛教。我父亲，正如我提到的，是个鼓手和音乐家，他还有一个工作室。我们楼梯下面有个壁橱，他把它改造成了制作工作室，他是个艺术家。
他为市政府工作，我母亲也为市政府工作，我成长过程中家里钱并不多，所以很多电脑设备都是从街上捡来的。他会发现……有人把电脑扔在外面……他在游戏玩家还没开始组装电脑之前就在组装电脑了。我记得他会带着盒子、电路板和芯片回家，真的会去图书馆或书店买本书，研究如何组装这些电脑，修好坏掉的键盘。他本该成为一名机械工程师，他在这些方面极具天赋。
基本上他拥有一个完整的制作工作室，有鼓机和所有设备。我是他的小助手。我会帮他焊接东西、捣鼓零件，亲手把这些电脑组装起来。所以这可能就是……我不知道那段描述是从哪引用的，我得去点开链接看看出处，但这就是一些背景。
八九十年代在旧金山发生的另一件事是，我们经常在家里举办佛教聚会。那时候有很多所谓的“街头传教”，比如哈瑞奎师那（Hare Krishna）信徒经常在我家转角的黑特街（Haight Street）走来走去。
还有伊斯兰国度（Nation of Islam），我哥哥曾加入过一段时间，他们会在街角卖《最后的呼唤》（Final Calls）报纸和豆派。

---

### [00:51:09] Lenny

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:51:10] Camille Hearst

**English:**
So The Final Call is the newspaper at the time for the Nation of Islam.
And so it was just a different era, completely different from today, and us practicing Nichiren Buddhism, we had pamphlet that said, "Nam myoho renge kyo," on them, and I would stand on the steps of our house and... We had a gate. So I would stand behind the gate and I'm probably seven or eight years old, just ask people walking by, "Hey, if you're a nam myoho renge kyo, here's a pamphlet. Learn a little more. We're having a meeting at our house."
I'd laugh with my mom now. She's like, "I can't believe we're doing that." It seems totally crazy now but at the time, it was just, again, coming off of the seventies, it was a very different era.
If you've ever seen What's Love Got To Do With It, Tina Turner's probably... Who recently passed away, probably one of the more famous, more well-known practitioners of Nichiren Buddhism and she actually started practicing in the same kind of era, seventies and eighties... Or seventies probably.
So that's what that means. And those are a couple memories that illustrate that moment. But you can see, music, technology, helping creators get paid, it's certainly influenced everything about how I am today.

**中文翻译:**
《最后的呼唤》是当时伊斯兰国度的报纸。
那是一个完全不同的时代，与今天截然不同。我们信奉日莲正宗佛教，我们有印着“南无妙法莲华经”（Nam myoho renge kyo）的小册子。我会站在我家门口的台阶上……我们家有个大门，我就站在门后，大概七八岁大，问路过的人：“嘿，如果你也念‘南无妙法莲华经’，这有一本小册子。多了解一下，我们家正在开会。”
我现在常和妈妈一起笑这件事。她说：“我不敢相信我们以前竟然那样做。”现在看来完全不可思议，但在当时，承接七十年代的余波，那是一个非常不同的时代。
如果你看过电影《爱是什么》（What's Love Got To Do With It），最近去世的蒂娜·特纳（Tina Turner）可能是最著名的日莲正宗信徒之一，她实际上也是在那个时代（七八十年代，或者可能是七十年代）开始修行的。
所以这就是那些描述的含义。这些记忆说明了那个时刻。但你可以看到，音乐、技术、帮助创作者获得报酬，这些确实影响了我今天的一切。

---

### [00:52:20] Lenny

**English:**
That was a perfect description of your parents based on those stories. And it feels inevitable that you would've ended up doing what you're doing now. Product, technology, music, artists, creators. So that's amazing.
I'm going to ask one more question before we get to our very exciting lightning round, and the question is just around frameworks. Is there just a favorite framework or process or system or approach to building product or teams that you come back to and/or to share often that you think might be useful to listeners?

**中文翻译:**
根据这些故事，对你父母的描述简直太贴切了。感觉你最终从事现在的工作是必然的：产品、技术、音乐、艺术家、创作者。这太棒了。
在进入激动人心的闪电轮问答之前，我还要问一个问题，是关于框架的。有没有什么你经常使用或分享的、关于构建产品或团队的框架、流程、系统或方法，是你认为对听众有用的？

---

### [00:52:51] Camille Hearst

**English:**
I have this great manager in my experience at Hailo who turned me on to Marty Cagan who I since befriended and learned a ton from. And I just love the way that-

**中文翻译:**
我在 Hailo 工作时遇到过一位非常棒的经理，他向我推荐了马蒂·卡根（Marty Cagan），后来我与马蒂成了朋友，并从他那里学到了很多。我非常喜欢那种——

---

### [00:52:51] Lenny

**English:**
Really?

**中文翻译:**
真的吗？

---

### [00:53:03] Camille Hearst

**English:**
Yeah, he's awesome. Actually, I should ask him about early days at eBay because I think he was there probably one of the people who got off the ground.
But one of the things that I learned and that we really emphasized during that time is this idea of having dual track agile going where you're doing discovery and delivery simultaneously and doing it in a way that's not waterfall.
It's not like, "All right, the designers are going to go over here and tinker for months, and then once we've figured it out, we'll lob it over the wall to the coders and cross our fingers and hope everything works." But rather having this continuous cycle of essentially de-risking your assumption and getting to a point where you're able to do that with speed so that you can chart your way to new paths and to innovation by constantly figuring out where the errors are in your thinking or where things that you didn't expect to happen were going to happen.
So I think everyone knows an impact effort or risk reward two by two and can map out different opportunities and things you might do on that two by two.
But one of my favorite takeaways from that is that from this way of working around this dual track agile de-risking your riskiest ideas first approach is a concept of taking the things in the top, the biggest swing and actually prioritizing those first in terms of product discovery and figuring out what can you do to start de-risking because if you constantly put those off in favor of the lower risk or more predictable smaller swings, how are you ever going to truly innovate and get to the next level.
It's a less safe choice. So it's someone that as a leader, you are in the hot seat and you can take accountability. So if some of these things don't pan out, it's on you and not on your team and give your team permission to fail and try things and de-risk those risky assumptions and get them to a point where they become low risk and they become predictable and you can just put them in the delivery column and execute them.

**中文翻译:**
是的，他很棒。实际上，我应该问问他关于 eBay 早期的事，因为我觉得他可能是当时让平台起步的人之一。
我学到的并一直强调的一点是“双轨敏捷”（dual track agile）的概念，即同时进行“发现”（discovery）和“交付”（delivery），而且不是以瀑布流的方式进行。
它不是说：“好吧，设计师先去琢磨几个月，等我们想清楚了，再把方案扔给程序员，然后祈祷一切顺利。”而是建立一个持续的循环，本质上是不断排除假设中的风险，并快速迭代，这样你就能通过不断发现思维中的错误或预料之外的情况，为新路径和创新指明方向。
我想大家都知道“影响-努力”或“风险-回报”的四象限图（two by two），并能在上面标出不同的机会。
但我最喜欢的一个心得是，在这种双轨敏捷、优先排除高风险想法的方法中，有一个概念是：拿走象限顶端那些“大动作”，在产品发现阶段优先处理它们，弄清楚如何开始去风险。因为如果你为了追求低风险或更可预测的“小动作”而不断推迟这些大动作，你永远无法真正创新并达到下一个高度。
这是一个不那么安全的选择。作为领导者，你处于风口浪尖，需要承担责任。如果有些尝试没成功，责任在你而不在团队。要允许团队失败和尝试，去排除那些高风险假设，直到它们变成低风险、可预测的，然后你就可以把它们放入交付栏并执行。

---

### [00:55:18] Lenny

**English:**
It reminds me of this piece of advice that people call eat the frog which is first thing in the morning eat the frog which essentially is do the hardest thing first and then there's the day becomes easier.

**中文翻译:**
这让我想起一条建议，人们称之为“吃掉那只青蛙”（eat the frog），意思就是早起第一件事就是吃掉那只青蛙，本质上就是先做最难的事，然后这一天剩下的时间就会变得轻松。

---

### [00:55:30] Camille Hearst

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:55:30] Lenny

**English:**
I don't know why it's eat a frog, I don't know where that comes from.

**中文翻译:**
我不知道为什么是吃青蛙，不知道这个说法从哪来的。

---

### [00:55:34] Camille Hearst

**English:**
I don't know either. I like draw the owl. That's one of my favorite values, the Twilio ones.

**中文翻译:**
我也不知道。我喜欢“画猫画虎”（draw the owl，意指直接上手做）。那是 Twilio 的价值观之一，也是我最喜欢的。

---

### [00:55:39] Lenny

**English:**
Say more. I would say more. What is that?

**中文翻译:**
多说一点。那是什么意思？

---

### [00:55:44] Camille Hearst

**English:**
Companies have their values. One of them is draw the owl. It's really draw the effing owl and the meme is how do you draw an owl and you draw some circles and then you draw a fucking owl. So it's like just do it. At some point, you got to just figure it out and figure out how to do it.
Excuse my language, but it's funnier when you say what the value actually is which is sometimes you got to just go for it. You're not going to know the exact path to get there and maybe you won't have de-risked everything but you start with some circles and then you get it done.

**中文翻译:**
公司都有自己的价值观。其中一个是“画猫画虎”。原话其实是“画那只该死的猫头鹰”。那个梗是：如何画一只猫头鹰？你先画几个圆圈，然后你就画出了一只该死的猫头鹰。所以它的意思就是“尽管去做”。在某个时刻，你必须自己摸索出路，想办法把它做成。
原谅我的粗口，但当你说明这个价值观的真实含义时，它会更有趣：有时你必须放手一搏。你不会知道到达那里的确切路径，也许你还没排除所有风险，但你先画几个圆圈，然后把它搞定。

---

### [00:56:27] Lenny

**English:**
I love it. Cursing is very loud on this podcast, so I'm glad you went there.
And with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
我喜欢这个。这个播客对粗口很包容，所以我很高兴你提到了。
那么，我们进入了非常激动人心的闪电轮问答。准备好了吗？

---

### [00:56:36] Camille Hearst

**English:**
I hope so. I didn't prepare this. I thought I'd figured out on the spot.

**中文翻译:**
希望如此。我没准备，我想现场发挥。

---

### [00:56:40] Lenny

**English:**
Great. Perfect.
What are two or three books that you recommended most to other people?

**中文翻译:**
太棒了，完美。
你向别人推荐最多的两三本书是什么？

---

### [00:56:46] Camille Hearst

**English:**
Three-Body Problem, A Wrinkle in Time, and Octavia Butler's Kindred.

**中文翻译:**
《三体》（Three-Body Problem）、《时间的皱折》（A Wrinkle in Time）和奥克塔维亚·巴特勒的《血缘》（Kindred）。

---

### [00:56:53] Lenny

**English:**
Three-Body Problem's come up a number of times recently and there's a show coming out actually based on the book.

**中文翻译:**
《三体》最近被提到了好几次，而且根据这本书改编的剧集也要上映了。

---

### [00:56:58] Camille Hearst

**English:**
I'm excited. Yeah.

**中文翻译:**
我很期待。是的。

---

### [00:56:59] Lenny

**English:**
I'm so excited. I've been watching Foundation which is also another series I've been excited to see, but it's like, I don't know what's going on. It's so complicated.

**中文翻译:**
我也很期待。我一直在看《基地》（Foundation），那也是我一直很期待的系列，但感觉……我看不懂在讲什么，太复杂了。

---

### [00:57:07] Camille Hearst

**English:**
How is it? I've been waiting...

**中文翻译:**
拍得怎么样？我一直在等……

---

### [00:57:08] Lenny

**English:**
Eh.

**中文翻译:**
额，一般般。

---

### [00:57:08] Camille Hearst

**English:**
So I'm a huge sci-fi head. I watched Battlestar Galactica. Classic. [inaudible 00:57:16] and so I've been waiting to see what happens with Foundation because I just don't have that kind of commitment in me these days.

**中文翻译:**
我是个超级科幻迷。我看过《太空堡垒卡拉狄加》（Battlestar Galactica），那是经典。[听不清] 所以我一直在观望《基地》的情况，因为我最近没那么多精力去追长剧。

---

### [00:57:23] Lenny

**English:**
Yeah. I don't know what to think of it. It's beautiful and there's a lot of interesting pieces but it just goes out... I think they're making a lot of stuff up. I don't know if you've read Silo. Have you read Silo?

**中文翻译:**
是啊。我不知道该怎么评价。画面很美，有很多有趣的部分，但它偏离了……我觉得他们编造了很多内容。不知道你读过《羊毛战记》（Silo）吗？

---

### [00:57:33] Camille Hearst

**English:**
No. But I saw the preview for the show. Another one I'm going to [inaudible 00:57:36] season two.

**中文翻译:**
没读过。但我看了剧版的预告。那是另一个我要[听不清]第二季的。

---

### [00:57:37] Lenny

**English:**
That's a good one to read because in the show... They're just making up stories. I don't know what they're doing. There's... Ninety percent of it, they just totally invent for the show and then there's a little bit that's connected to the story so I don't know what's going on.

**中文翻译:**
那本书很值得一读，因为在剧里……他们就在瞎编故事。我不知道他们在干嘛。百分之九十的内容都是为剧集凭空捏造的，只有一点点和原著故事有关，所以我搞不懂是怎么回事。

---

### [00:57:49] Camille Hearst

**English:**
Okay. Cool. I didn't even know it was a book. I'll read it.

**中文翻译:**
好吧，酷。我甚至不知道那是本书。我会去读的。

---

### [00:57:51] Lenny

**English:**
Oh, yeah. It's really good. There's three of them, but the first one's the only good one, so I found.

**中文翻译:**
噢，是的。一共有三本，但我发现只有第一本好看。

---

### [00:57:54] Camille Hearst

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:57:55] Lenny

**English:**
Anyway, moving on. Speaking of this topic actually, any favorite recent movies or TV shows that you've really enjoyed?

**中文翻译:**
总之，继续。说到这个话题，最近有什么你非常喜欢的电影或电视节目吗？

---

### [00:58:02] Camille Hearst

**English:**
I've been watching Hijack over the last week with Idris Elba. So that's been fun. Got a couple episodes left there.
And then movies, I'm a huge Chris Nolan fan. So I haven't seen Oppenheimer yet, but can't wait to see it. Most of his movies I'm confused by, but the visuals are just so stunning if you let it go.

**中文翻译:**
过去一周我一直在看伊德瑞斯·艾尔巴（Idris Elba）主演的《劫机七小时》（Hijack）。挺有意思的，还剩几集。
电影方面，我是克里斯托弗·诺兰（Chris Nolan）的超级粉丝。我还没看《奥本海默》（Oppenheimer），但迫不及待想看。他的大多数电影都让我感到困惑，但如果你不去纠结逻辑，视觉效果真的非常震撼。

---

### [00:58:24] Lenny

**English:**
Yeah. I'm excited to see it too. I've not seen it either. Have a new child and it's harder to see movies [inaudible 00:58:30].

**中文翻译:**
是的，我也很期待。我也还没看。刚有了孩子，看电影变得更难了[听不清]。

---

### [00:58:30] Camille Hearst

**English:**
Oh, another good one. Shadow and Bone on Netflix.

**中文翻译:**
噢，还有一个不错的。Netflix 上的《太阳召唤》（Shadow and Bone）。

---

### [00:58:34] Lenny

**English:**
Shadow and Bone?

**中文翻译:**
《太阳召唤》？

---

### [00:58:35] Camille Hearst

**English:**
Way better than the book I have to say. Well, I read one series, the Six of Crows. This is my young adult sci-fi fantasy streak. Again, coming to the forth. But the show is incredible. It is so good. So if you're into-

**中文翻译:**
我必须说，剧比书好看多了。我读过其中一个系列《乌鸦六人组》（Six of Crows）。这是我的青少年科幻奇幻情结。又来了。但这部剧真的很棒，非常精彩。所以如果你喜欢——

---

### [00:58:35] Lenny

**English:**
Really? Never heard that.

**中文翻译:**
真的吗？从没听说过。

---

### [00:58:48] Camille Hearst

**English:**
... this kind of vibe, go for it.

**中文翻译:**
……这种风格，去看看吧。

---

### [00:58:51] Lenny

**English:**
Okay. I'm going to check that out.
What is a favorite interview question that you like to ask people when you're interviewing them?

**中文翻译:**
好的，我会去看看。
在面试别人时，你最喜欢问的问题是什么？

---

### [00:58:58] Camille Hearst

**English:**
I like to ask people to tell me about something they're really proud of that they accomplished and take me through the process and talk to me about why they're proud of it. I find you can learn so much about a person's motivations, about their work ethic, about what they care about, what good looks like to them, and I think those are all really important things to understand about a person if you're going to work closely with them.

**中文翻译:**
我喜欢让人们谈谈他们引以为豪的一项成就，带我了解整个过程，并告诉我为什么以此为荣。我发现通过这个问题，你可以了解到很多关于一个人的动机、职业道德、他们真正在乎什么，以及他们心目中“优秀”的标准。如果你要和某人密切合作，我认为这些都是了解一个人的非常重要的方面。

---

### [00:59:23] Lenny

**English:**
What is a favorite life motto that you just really like to share or often come back to either in work or in life?

**中文翻译:**
在工作或生活中，你最喜欢分享或经常回想的人生格言是什么？

---

### [00:59:31] Camille Hearst

**English:**
Yeah. So there's one which is actually a Japanese proverb. I took Japanese in high school and college but this phrase is a frog in a well cannot know the ocean. And so the idea is to push yourself to expand your limits and your horizons and get out of the well so that you can experience the ocean.

**中文翻译:**
是的。有一句其实是日本谚语。我在高中和大学学过日语，这句话是“井底之蛙不知大海”（井の中の蛙大海を知らず）。它的意思是鼓励自己突破极限，开阔视野，跳出那口井，去体验大海。

---

### [00:59:31] Lenny

**English:**
I love that.

**中文翻译:**
我喜欢这句。

---

### [00:59:55] Camille Hearst

**English:**
I got a better one, sorry.

**中文翻译:**
我还有一个更好的，抱歉。

---

### [00:59:57] Lenny

**English:**
Okay, great. Go.

**中文翻译:**
好啊，请讲。

---

### [00:59:58] Camille Hearst

**English:**
Another one.

**中文翻译:**
另一个。

---

### [00:59:58] Lenny

**English:**
Sure. Tell me.

**中文翻译:**
当然，请说。

---

### [01:00:00] Camille Hearst

**English:**
I learned this one from someone at Patreon because someone was posting this around the streets of San Francisco. It's become more known recently. Apparently, it's a Chinese proverb. I don't know if it's true or not but it is that the best time to plant a tree was 20 years ago, the second best time is now. So this idea that don't delay, maybe you missed the prime opportunity but waiting any longer certainly isn't going to help.

**中文翻译:**
这是我从 Patreon 的一位同事那里学到的，因为当时有人在旧金山街头张贴这句话。最近它变得更出名了。显然这是一句中国谚语。我不知道是不是真的，但它是这样说的：“种一棵树最好的时间是 20 年前，其次是现在。”所以它的核心思想是不要拖延，也许你错过了最佳时机，但再等下去肯定没好处。

---

### [01:00:28] Lenny

**English:**
I heard that one actually I was at the park in San Francisco and there was this piano thing, I think it was called, it's a botanical garden and people play piano all throughout once a year. And there's a guy that was just playing incredibly well and I left and he left around the same time and I was standing next to him. I'm like, "Man, I wish I studied piano when I was younger." And he's like, "The best time to have studied piano is 10 years ago. The second best time is to start now."

**中文翻译:**
我确实听过这句。当时我在旧金山的一个公园里，那里有一个钢琴活动，好像是在植物园，每年一次，人们到处弹钢琴。有个哥们弹得特别棒，我离开时他也刚好离开，我站在他旁边说：“伙计，我真希望我年轻时学过钢琴。”他说：“学钢琴最好的时间是 10 年前，其次是现在开始。”

---

### [01:00:51] Camille Hearst

**English:**
Yep, he's right.

**中文翻译:**
没错，他说得对。

---

### [01:00:53] Lenny

**English:**
And I couldn't get off the hook there. He is like, "You're right. And you're still not going to do it I guess."

**中文翻译:**
我当时无言以对。他就像在说：“你说得对，但我猜你还是不会去做的。”

---

### [01:00:59] Lenny

**English:**
Final question, who's a favorite artist right now? Who are you liking?

**中文翻译:**
最后一个问题，你现在最喜欢的艺术家是谁？你最近在听谁的歌？

---

### [01:01:05] Camille Hearst

**English:**
Ooh. So I've been for probably a good three years now really into Afrobeat and right now there's this artist called Rema, R-E-M-A, who I first heard a couple years ago, he's got this track called Dumebi. But he has a song out right now that is, my opinion, song of the summer called Calm Down. I think Ariana Grande, is it, came over and did a verse on it? But I've just been listening to Rema Radio, Calm Down radio on Spotify and tons of Afrobeats artists. So that's the vibe I'm on right now.

**中文翻译:**
噢。大概三年来我一直非常迷恋非洲节拍（Afrobeat）。现在有一位叫 Rema 的艺术家，我几年前第一次听他的歌，他有一首叫《Dumebi》的曲子。但他现在有一首歌，在我看来是“夏季之歌”，叫《Calm Down》。我想是赛琳娜·戈麦斯（Selena Gomez，Camille 误记为 Ariana Grande）参与了合唱？我一直在 Spotify 上听 Rema 电台和《Calm Down》电台，还有很多非洲节拍艺术家的歌。这就是我现在的音乐品味。

---

### [01:01:42] Lenny

**English:**
I love it. I actually... Once someone suggested some music at the end of a podcast and I was just like, "Hey, we're going to end the podcast with that tune." And it turned out we did that and then YouTube shut us down because it's copyrighted and so I'm not going to offer. Never going to do that again, so we're just ending with regular music but we'll link-

**中文翻译:**
我很喜欢。实际上……有一次有人在播客结束时建议放段音乐，我说：“嘿，我们就用那首曲子结束播客吧。”结果我们放了之后，YouTube 就把我们封了，因为有版权。所以我现在不提议放歌了。再也不干那种事了，所以我们还是用常规音乐结束，但我们会附上链接——

---

### [01:01:59] Camille Hearst

**English:**
[inaudible 01:01:59] it's hard.

**中文翻译:**
[听不清] 版权确实很麻烦。

---

### [01:02:00] Lenny

**English:**
I know. It's so tough. Come on. It's just like a few seconds. Give us a break.

**中文翻译:**
我知道。太难了。拜托，就几秒钟而已，放过我们吧。

---

### [01:02:06] Camille Hearst

**English:**
You should have 30 seconds for your play. Right?

**中文翻译:**
你应该有 30 秒的播放额度，对吧？

---

### [01:02:06] Lenny

**English:**
I don't know. Maybe we'll-

**中文翻译:**
我不知道。也许我们会——

---

### [01:02:07] Camille Hearst

**English:**
Don't ask me, I'm not a lawyer.

**中文翻译:**
别问我，我不是律师。

---

### [01:02:10] Lenny

**English:**
We'll send you the bill.

**中文翻译:**
我们会把账单寄给你的。

---

### [01:02:11] Camille Hearst

**English:**
Yeah.

**中文翻译:**
哈哈，好啊。

---

### [01:02:12] Lenny

**English:**
Camille, this was amazing. I think we're living the creator economy here. I really appreciate you making time for this.
Two final questions. Where can folks find you online if they want to reach out and maybe ask any additional questions? And then how can listeners be useful to you?

**中文翻译:**
Camille，这次对话太棒了。我觉得我们就在践行创作者经济。非常感谢你抽时间参加节目。
最后两个问题：如果大家想联系你或者问更多问题，可以在哪里找到你？以及，听众可以为你做些什么？

---

### [01:02:24] Camille Hearst

**English:**
I used to be real big on Twitter but that ship has sailed. I'm still on there. You can find me-

**中文翻译:**
我以前经常玩 Twitter，但那段时光已经过去了。不过我还在上面。你可以找到我——

---

### [01:02:30] Lenny

**English:**
It's X now.

**中文翻译:**
现在叫 X 了。

---

### [01:02:31] Camille Hearst

**English:**
Yes, on X. Camillionz is my handle, C-A-M-I-L-L-I-O-N-Z. Also on Threads these days, trying that out, seeing if that sticks. So probably LinkedIn. You could find me on LinkedIn. I don't think anyone ever promotes that.

**中文翻译:**
是的，在 X 上。我的账号是 Camillionz（C-A-M-I-L-L-I-O-N-Z）。最近也在玩 Threads，尝试一下，看看能不能坚持下去。还有 LinkedIn。你可以在 LinkedIn 上找到我，我觉得好像没人宣传这个。

---

### [01:02:31] Lenny

**English:**
They do. Most people actually.

**中文翻译:**
不，他们会。实际上大多数人都会。

---

### [01:02:48] Camille Hearst

**English:**
Do they? Yeah?

**中文翻译:**
是吗？好吧。

---

### [01:02:48] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:02:52] Camille Hearst

**English:**
Okay.
And how can listeners be useful to me? Hey, go support your favorite creator. Find out, go to the show, find out if they have a Patreon. I would love to see more and more people feeling like they are patrons of the arts.

**中文翻译:**
好的。
听众能为我做些什么？嘿，去支持你最喜欢的创作者吧。去了解一下，去看看他们的节目，看看他们是否有 Patreon。我希望看到越来越多的人觉得自己是艺术的赞助人。

---

### [01:03:08] Lenny

**English:**
Amazing. Maybe buy some merch.

**中文翻译:**
太棒了。也许再买点周边。

---

### [01:03:09] Camille Hearst

**English:**
Buy some merch. Yeah.

**中文翻译:**
买点周边，没错。

---

### [01:03:12] Lenny

**English:**
Camille, thank you again for being here.

**中文翻译:**
Camille，再次感谢你的到来。

---

### [01:03:13] Camille Hearst

**English:**
Thanks, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### [01:03:15] Lenny

**English:**
Bye, everyone.
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客 App 上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。