# Camille Ricketts - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Camille Ricketts.

---

### [00:00:00] Camille Ricketts

**English:**
The way that you think about product market fit, you have to think about content market fit. So even though content feels like it's running adjacent to the actual product that you're putting out there, you still have to think about who is my audience? Who is the audience that I really want to have? Who is the audience that is going to be drawn to this most? Who are they? What is it that they really need in their lives? Even abstracting content from it at all. What is it that they need to get promoted? What is it that they need to avoid failure? What is it that causes them a great deal of anxiety in the day-to-day of their lives or their work? And can you create some type of content product that is going to address this for them?

**中文翻译:**
就像你思考“产品市场契合度”（Product Market Fit）一样，你也必须思考“内容市场契合度”（Content Market Fit）。虽然内容看起来像是与你推出的实际产品并行运行的，但你仍然需要思考：我的受众是谁？我真正想要的受众是谁？谁最容易被这些内容吸引？他们是什么样的人？他们在生活中真正需要什么？甚至完全抛开内容本身去思考：他们需要什么来获得晋升？他们需要什么来避免失败？在日常生活或工作中，什么让他们感到极度焦虑？你是否能创造出某种“内容产品”来为他们解决这些问题？

---

### [00:00:38] Lenny

**English:**
Welcome to Lenny's podcast. I'm Lenny and my goal here is to help you get better at the craft of building and growing products. I interview world class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful companies. Today my guest is Camille Ricketts. Camille was the first marketing hire at Notion and longtime head of marketing at Notion. Prior to that, she was head of content and marketing at First Round Capital, where amongst many other things, she launched the First Round Review, which holds a very special place in my heart because a guest post in the First Round Review essentially helped me launch my now career of newsletter and now podcast. Camille also did content marketing at Kiva and also comms and PR at early Tesla where she sat right next to Elon Musk for about a year and she shares some really fun stories about that.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的能力。我采访世界级的产品领导者和增长专家，从他们建立和发展当今最成功公司的艰辛经验中学习。今天的嘉宾是 Camille Ricketts。Camille 是 Notion 的第一位营销员工，并长期担任 Notion 的营销负责人。在此之前，她是 First Round Capital 的内容和营销负责人，在那里她创办了《First Round Review》，这份刊物在我心中有着非常特殊的地位，因为在《First Round Review》上发表的一篇客座文章，基本上开启了我现在的时事通讯（Newsletter）和播客事业。Camille 还曾在 Kiva 负责内容营销，并在早期特斯拉负责传播与公关，在那里她曾在埃隆·马斯克（Elon Musk）身边坐了大约一年，她分享了一些关于那段经历的趣事。

---

### [00:01:26] Lenny (Continued)

**English:**
In this episode, we focus on two areas that Camille was very early in and has tremendous insights around. One, community led growth. What it actually is, when it's something you should invest in, how to do it well. All based on her experience building Notion's early community, which was a huge part of Notion's early success. We also talk about content marketing. When it's worth investing in, how to do it well, and all kinds of tips for building a content marketing machine. It was a total blast chatting with Camille and I am really excited for you to learn from her. With that, I bring you Camille Rickets right after we hear a word from our wonderful sponsors.

**中文翻译:**
在本期节目中，我们将重点讨论 Camille 涉足非常早且拥有深刻见解的两个领域。第一，社区驱动型增长（Community-led growth）。它究竟是什么，什么时候应该投入，以及如何做好它。这些都基于她建立 Notion 早期社区的经验，而这正是 Notion 早期成功的关键部分。我们还将讨论内容营销：什么时候值得投入，如何做好，以及建立内容营销机器的各种技巧。与 Camille 的交谈非常愉快，我非常期待你们能从她身上学到东西。在听完我们优秀的赞助商广告后，我们将正式请出 Camille Ricketts。

---

### [00:02:02] Lenny (Sponsor: Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like Netlify, Contentful, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to wasted time building internal tools or trying to run your experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved about our experimentation platform was being able to easily slice results by device, by country, and by user stage. Eppo does all that and more. Delivering results quickly, avoiding annoying prolonged analytics cycles, and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic clickthrough metrics, and instead you to North Star metrics like activation, retention, subscriptions and payments. And Eppo supports tests on the front end, the back end, email marketing, and even machine learning clients. Check out Eppo, geteppo.com, get E-P-P-O.com and 10X your experiment velocity. Hey, Ashley, head of marketing at Flatfile. How many B2B SaaS companies would you estimate need to import CSV files from their customers?

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 前员工为现代增长团队打造的下一代 AB 测试平台。Netlify、Contentful 和 Cameo 等公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能与现代增长团队的技术栈无缝集成。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具运行实验。当我在 Airbnb 时，我最喜欢我们的实验平台的一点是，能够轻松地按设备、国家和用户阶段切分结果。Eppo 实现了这一切，甚至更多。它能快速交付结果，避免烦人的漫长分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基础的点击率指标，转而关注激活、留存、订阅和支付等北极星指标。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。访问 geteppo.com (G-E-T-E-P-P-O.com)，让你的实验速度提升 10 倍。嘿，Ashley（Flatfile 营销负责人），你估计有多少 B2B SaaS 公司需要从客户那里导入 CSV 文件？

---

### [00:03:21] Ashley (Sponsor: Flatfile)

**English:**
At least 40%.

**中文翻译:**
至少 40%。

---

### [00:03:23] Lenny

**English:**
And how many of them screw that up and what happens when they do?

**中文翻译:**
其中有多少公司把这件事搞砸了？搞砸后会发生什么？

---

### [00:03:26] Ashley

**English:**
Well, based on our data, about a third of people will consider switching to another company after just one bad experience during onboarding. So if your CSV importer doesn't work right, which is super common considering customer files are chock full of unexpected data and formatting, they'll leave.

**中文翻译:**
根据我们的数据，大约三分之一的人在入职引导（onboarding）过程中只要经历一次糟糕的体验，就会考虑更换公司。因此，如果你的 CSV 导入器运行不正常（考虑到客户文件充满了意想不到的数据和格式，这非常常见），他们就会流失。

---

### [00:03:45] Lenny

**English:**
I am 0% surprised to hear that. I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing long-term retention. Getting people to your aha moment more quickly and reliably is so incredibly important.

**中文翻译:**
听到这个我一点也不意外。我一直认为，改进引导流程是提高注册转化率和增加长期留存率的最高杠杆机会之一。让用户更快速、更可靠地达到“Aha Moment”（惊喜时刻）是极其重要的。

---

### [00:04:00] Ashley

**English:**
Totally. It's incredible to see how our customers like Square, Spotify and Zuora are able to grow their businesses on top of Flatfile. It's because flawless data onboarding acts like a catalyst to get them and their customers where they need to go faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zuora 这样的客户如何在 Flatfile 的基础上发展业务，真是令人惊叹。这是因为完美的数据引导就像催化剂，能让他们和他们的客户更快地达到目标。

---

### [00:04:17] Lenny

**English:**
If you'd like to learn more or get started, check out Flatfile and flatfile.com/lenny. Camille, welcome to the podcast.

**中文翻译:**
如果你想了解更多或开始使用，请访问 Flatfile 官网 flatfile.com/lenny。Camille，欢迎来到播客。

---

### [00:04:29] Camille Ricketts

**English:**
Hello there. Thank you so much for having me.

**中文翻译:**
你好。非常感谢邀请我。

---

### [00:04:32] Lenny

**English:**
Absolutely, my pleasure. You have such a fascinating background working at so many world-class companies with so many fascinating people. Could you just take a minute to talk about some of the wonderful things you've done in your career just to set a little context for folks?

**中文翻译:**
这是我的荣幸。你在这么多世界级公司工作过，接触过这么多迷人的人，背景非常精彩。你能花一分钟谈谈你职业生涯中做过的一些精彩事情吗？好让大家了解一下背景。

---

### [00:04:47] Camille Ricketts

**English:**
Yeah. Well thank you for characterizing them as wonderful. I feel like it's been a quite circuitous path, but definitely has taken me to some interesting places. I started off as a journalist at the Wall Street Journal and then found my way into communications and marketing at Tesla Motors where part of my responsibility there was to sit to Elon's right and make sure he had all the data he needed at his fingertips when talking to the press, which was deep end of the pool on the PR learning. And then after that, found my way to First Round Capital where I was really fortunate to be at the ground floor of First Round Review, if anyone out there watching this is familiar with those pieces. Was there for about five years. Loved that team. Really incredible folks. And then they had invested in Notion really early on, and so I was able to meet Ivan Zhao as a result of that and him and Simon, and they gave me the opportunity to join as the first marketing hire at Notion. And that's what I was doing up until recently.

**中文翻译:**
好的，谢谢你用“精彩”来形容它们。我觉得我的职业道路相当曲折，但确实带我去了很多有趣的地方。我最初在《华尔街日报》担任记者，后来进入特斯拉汽车公司负责传播和营销。当时我的职责之一是坐在埃隆（马斯克）的右侧，确保他在与媒体交谈时能随手拿到所需的所有数据，这对我来说是公关学习的“深水区”。之后，我去了 First Round Capital，非常幸运地参与创办了《First Round Review》（如果观众里有人熟悉那些文章的话）。我在那里待了大约五年，非常喜欢那个团队，都是些了不起的人。后来，他们很早就投资了 Notion，我也因此结识了 Ivan Zhao（赵伊）和 Simon，他们给了我作为 Notion 第一位营销员工加入的机会。这就是我直到最近一直在做的事情。

---

### [00:05:59] Lenny

**English:**
I love that Elon tidbit. I like that it was on his right. His right hand person. What was that like? And is there something that you learned working alongside Elon, sitting next to Elon, about operating, working that maybe you've taken to other places you worked at?

**中文翻译:**
我喜欢关于埃隆的那个小细节。坐在他的右边，就像是他的得力助手。那是种什么样的体验？在埃隆身边工作、坐在他旁边，你有没有学到什么关于运营或工作的经验，是你后来带到其他工作岗位上的？

---

### [00:05:59] Camille Ricketts

**English:**
I mean, it was a long time ago, so I'll caveat that. This was before Model S came out even. So a lot of my work was, and this was a great opportunity, but driving around in the Roadster and talking to journalists and letting reporters ride in the car, which was very seductive and I think maybe just a little unfair from a PR standpoint. But in terms of what I learned, that was really the first job that I had that was necessitating just being incredibly on point with all the information. So making sure that I knew everything that could possibly come up in a conversation, being incredibly well-versed in just the topics at hand, I think that served me really well. I just have to be really, really, really quick and on it. And then the other thing that Elon I think is very talented at or definitely at the time really made an impression on me was painting an emotional picture of the vision that he was really going after and being able to convey the emotional quality of the mission to the people he talked to. So definitely at the time about the electric vehicle revolution and then space travel, I think he just knew how to make people feel about it that really enlisted a lot of hearts and minds and that is something that I've taken with me for sure.

**中文翻译:**
那是很久以前的事了，我得先说明一下。那甚至是在 Model S 发布之前。所以我的很多工作（这是一个很好的机会）是开着 Roadster 跑车到处跑，与记者交谈，让记者试乘，这非常有诱惑力，从公关的角度来看甚至有点“不公平”。但就我学到的东西而言，那确实是我第一份需要对所有信息都极其精准掌握的工作。确保我知道谈话中可能出现的任何问题，对当下的主题了如指掌，这让我受益匪浅。我必须反应极其迅速。另一件事是，我认为埃隆非常有天赋，或者说当时给我留下了深刻印象的，是他能为他追求的愿景描绘出一幅充满情感色彩的蓝图，并能向谈话对象传达这种使命感。无论是当时的电动汽车革命还是太空旅行，他都知道如何让人们产生共鸣，从而赢得人心。这绝对是我一直带在身上的东西。

---

### [00:07:09] Lenny

**English:**
Would you say that was the most stressful place you've worked or have you found more stress post Elon?

**中文翻译:**
你会说那是你工作过压力最大的地方吗？还是在离开埃隆之后遇到了更大的压力？

---

### [00:07:15] Camille Ricketts

**English:**
I think that that was the place where you just needed to be so on your game. Game face every single day. Which is a wonderful skill to learn. And then I think there were other moments in my career where just the stakes might have been a little bit higher. Certainly at Notion every day felt like we're building this thing together and we're in this very special moment. So yeah, I think there was a mix there.

**中文翻译:**
我觉得那是你必须时刻保持最佳状态的地方，每天都要全神贯注。这是一项很棒的技能。但在我职业生涯的其他时刻，赌注可能更高。当然，在 Notion 的每一天都感觉我们是在共同创造这个东西，处于一个非常特殊的时刻。所以，我觉得是两者的结合。

---

### [00:07:39] Lenny

**English:**
Speaking of Notion, I think you mentioned this and if not, you were the first marketing hire at Notion. Is that right?

**中文翻译:**
说到 Notion，我想你提到过，你是 Notion 的第一位营销员工，对吗？

---

### [00:07:44] Camille Ricketts

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:07:45] Lenny

**English:**
What employee number was that?

**中文翻译:**
你是第几号员工？

---

### [00:07:47] Camille Ricketts

**English:**
I was number 11.

**中文翻译:**
我是 11 号。

---

### [00:07:48] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:07:49] Camille Ricketts

**English:**
Yeah. So it was really a small squad of folks at the time.

**中文翻译:**
是的，当时真的只是一个小团队。

---

### [00:07:53] Lenny

**English:**
And how big are they now, roughly would you say?

**中文翻译:**
你觉得他们现在大概有多少人？

---

### [00:07:55] Camille Ricketts

**English:**
The last I heard, I think that they were around 400. Maybe a little over 400.

**中文翻译:**
我最后听到的是大约 400 人，可能稍微多一点。

---

### [00:07:59] Lenny

**English:**
Amazing. And I think they're worth ... I don't know. Last valuation was like $10 billion. So there's been quite the journey. Must have been quite the adventure being at Notion during this time. What's maybe the most tangible memory of working at Notion in the early days? What was it like early day Notion?

**中文翻译:**
太神奇了。我想他们的估值……我不知道，上次估值好像是 100 亿美元。这是一段了不起的旅程。这段时间在 Notion 工作一定是一场大冒险。关于 Notion 早期工作，你最真切的记忆是什么？早期的 Notion 是什么样的？

---

### [00:08:15] Camille Ricketts

**English:**
I think a lot about just what the environment felt like. This was the first very small startup that I had worked for. When I left First Round, I really wanted that experience. And the first office that I worked in was really just like a home. It literally had an apartment on top of this loft space and it just felt like we were a group of people who lived there together during the day, but it had that kind of home spun really warm quality. So we all took our shoes off. There was beautiful furnishings and rugs and we would all just sit around and drink tea and work together on these couches. So it really had that feeling to it. And then there were little quirks. I like to reminisce with my colleagues who were there at the time that we didn't have a great HVAC system. So during the summer it was really hot and then in the winter it was really cold and we would have these big industrial fans and at the time we were like, "Oh, this is really bizarre." But now it's one of our favorite memories to talk about. Or for a while we didn't have overhead lighting, so me and my colleagues who were there working really late at night, it would just get darker and darker and darker. And one of my favorite folks there actually had a headlamp that she would switch on at a certain point in the evening. So that's the stuff that really comes up for me. We were all working really hard and in this thing together, but it's that team familial quality that stands out to me.

**中文翻译:**
我经常想到那里的环境氛围。那是我工作过的第一家规模非常小的初创公司。离开 First Round 时，我非常渴望这种体验。我工作的第一个办公室真的就像一个家。它实际上是在一个阁楼空间上面有一个公寓，感觉就像我们是一群白天住在一起的人，有一种朴实且温暖的特质。我们都脱掉鞋子，那里有漂亮的家具和地毯，我们大家就围坐在一起喝茶，在沙发上一起工作。就是那种感觉。还有一些小怪癖。我喜欢和当时的同事回忆，那时我们的空调系统不太好。所以夏天非常热，冬天非常冷，我们会用那种大型工业风扇，当时我们觉得“天哪，这太奇怪了”。但现在这成了我们最喜欢聊的回忆之一。还有一段时间我们没有顶灯，所以我和同事们加班到深夜时，天色会越来越暗。我最喜欢的一位同事甚至准备了一个头灯，到了晚上某个时刻她就会打开。这些就是我脑海中浮现的画面。我们都在努力工作，同舟共济，那种像家人一样的团队特质最令我难忘。

---

### [00:09:35] Lenny

**English:**
I love how some of these early moments where it feels like, what the hell are we doing? We have to wear headlamps? It's super hot. When you're in it, you're like, this isn't maybe how our startup should be going. And it feels really painful and hard. But looking back, it's always the best memories, those hardships.

**中文翻译:**
我喜欢这些早期的瞬间，当时可能会想：我们到底在干什么？还得戴头灯？天还这么热。身处其中时，你会觉得：初创公司不应该是这样的吧。感觉非常痛苦和艰难。但回过头来看，那些艰辛往往是最好的回忆。

---

### [00:09:52] Camille Ricketts

**English:**
It truly is. And the moments that we were there late at night really trying to get something done before a big launch the next day, that's where our hearts lie, I think, to a large extent. That crew that was there.

**中文翻译:**
确实如此。那些深夜留在办公室，为了第二天的大型发布而拼命赶工的时刻，我觉得在很大程度上就是我们的心之所属。就是当时在那里的那群人。

---

### [00:10:04] Lenny

**English:**
On that note, and when you're talking about stress working with Elon, you talked about Notion had a different kind of stress. What's maybe the most stressful memory you have of working at Notion? Whatever you can share.

**中文翻译:**
说到这儿，你提到过和埃隆一起工作时的压力，也说过 Notion 有另一种压力。你在 Notion 工作中最有压力的记忆是什么？任何可以分享的都可以。

---

### [00:10:14] Camille Ricketts

**English:**
This is something that has long since been rectified, but the first day that we came back from break in 2021 ... We had all been sort of away for the holidays. We reassemble. I think it's January 3rd, 2021 perhaps. Had a massive outage that day that took down, not just us but also a lot of our peer companies. And so it was literally all hands on deck. We're suddenly seeing all of these people on Twitter pop up, on the Reddit pop up being like, "Oh my gosh. What am I going to do?" And it really reinforced for us how central Notion had become to so many people. So on one hand it was kind of this amazing moment of realization of how vital this thing we were building was all the time, which adds to the stress in the moment, but also your motivation overall. And then we also saw on Twitter, and this is part of why community is such a core focus of mine, but people being like, "They're trying really hard to get it back up. Give them a break." Or like, "Sending hugs to the Notion team. We know you've got this." And we really appreciated that and that was just a very heartwarming aspect of it. But that day was definitely a scramble and we wanted to be as communicative as possible. So my team was really central to making sure that everybody knew what was going on, what the efforts were being made to fix it, time horizon, all of that. So they've long since hired the best infrastructure people I think in the industry and refactored the database and everything. So it's not an issue anymore, but certainly that was a moment of stress at the time.

**中文翻译:**
这件事早已解决了，但在 2021 年假期结束后的第一天……我们刚休完假回来。我想大概是 2021 年 1 月 3 日。那天发生了大规模宕机，不仅影响了我们，还影响了许多同行公司。当时真的是全员出动。我们突然看到 Twitter 和 Reddit 上到处都是人说：“天哪，我该怎么办？”这让我们深刻意识到 Notion 对这么多人来说已经变得多么核心。所以一方面，这是一个惊人的时刻，让我们意识到我们一直在构建的东西是多么重要，这增加了当时的压力，但也增强了整体动力。我们在 Twitter 上也看到（这也是为什么社区是我核心关注点的原因之一），人们会说：“他们正在努力恢复，给他们一点时间。”或者“给 Notion 团队送去拥抱，我们知道你们能行。”我们非常感激，那是非常暖心的一面。但那天确实是一场混战，我们希望尽可能保持沟通透明。所以我的团队在确保每个人都知道发生了什么、正在做哪些修复努力、时间表等方面起到了核心作用。从那以后，他们聘请了业内最好的基础设施人才，重构了数据库等等。所以现在这不再是问题了，但当时确实是一个压力巨大的时刻。

---

### [00:11:50] Lenny

**English:**
It's interesting looking at those times. When you're in it, you're like, "We are going to die. We're down. People will stop using Notion. We're in big trouble." When really people always come back if it's an awesome product. I think of last things down for a week, JIRA or Confluent, and people come back if it's an awesome product.

**中文翻译:**
回顾那些时刻很有趣。身处其中时，你会觉得：“我们要完蛋了。服务挂了，人们会停止使用 Notion，我们麻烦大了。”但实际上，如果产品足够出色，人们总是会回来的。我想起像 JIRA 或 Confluent 宕机一周的情况，只要产品好，用户还是会回来。

---

### [00:12:07] Camille Ricketts

**English:**
I think that's a good tactical learning and hopefully a takeaway for folks who maybe will experience that moment is that truly there's more resilience built into the system than you might think.

**中文翻译:**
我认为这是一个很好的战术教训，希望能给那些可能经历这种时刻的人一些启发：系统内置的韧性其实比你想象的要强。

---

### [00:12:16] Lenny

**English:**
So speaking of community, you talked about just how important that was during this time and then just in general. I was doing research on you and things that you've done over your career to prep for this podcast and I found there's two areas that you've led the charge on and we're ahead of the curve on and in part help innovate. One is community led growth and two is content marketing in a big way. And so I want to focus a lot of our chat on these two areas. Community led growth, it feels like a very buzzy topic on Twitter. Everyone's always talking about how the future of growth is community. You've got to build a community. You got to be community led and all these things. And so I want to try to make this concept concrete and help people understand should they invest in community. How can community help you? When does it make sense to you? When does it not make sense to invest? And so maybe just as a first question, just what is community led growth? What does that actually mean as a concept?

**中文翻译:**
说到社区，你谈到了它在那段时间以及通常情况下的重要性。为了准备这期播客，我对你的职业生涯做了研究，发现有两个领域是你带头冲锋、走在时代前列并参与创新的。一个是社区驱动型增长（Community-led growth），另一个是深度内容营销。所以我想把我们的谈话重点放在这两个领域。社区驱动型增长在 Twitter 上似乎是一个非常热门的话题。每个人都在谈论增长的未来是社区，你必须建立社区，必须由社区驱动等等。我想尝试让这个概念变得具体，帮助人们理解是否应该投资社区。社区如何帮助你？什么时候有意义？什么时候不值得投资？所以第一个问题，什么是社区驱动型增长？作为一个概念，它到底意味着什么？

---

### [00:13:09] Camille Ricketts

**English:**
Yeah. I think it has become quite buzzy and it's certainly aspirational for a lot of product led growth companies and even those that are maybe a little bit outside of the product led growth orbit. And we're seeing all of these startups I think also come out that are about community and how to enhance the effects. In terms of how I think about what it actually is, it's when your community helps you achieve such ubiquity and such name recognition that it actually allows you to start moving upmarket into the enterprise. And I know that might be very specific to enterprise oriented companies, but that's how we defined it at Notion was the fact that so many people were talking about this, sharing what they had built about it, honestly starting businesses of their own around it to formalize the relationship with teams that I think it de-risked Notion as a choice for a lot of companies just because they had heard about it through so many channels. They had seen it on social media, they've heard about it on a podcast, their friend told them about it, they saw a billboard. All of that lended itself to larger and larger companies and teams buying more and more seats. So I think that's the power that the community had for us. And I see that also being analogous to what companies like Figma have been able to achieve.

**中文翻译:**
是的。我认为它确实变得非常热门，对于很多产品驱动型增长（PLG）公司，甚至是一些 PLG 轨道之外的公司来说，这都是一种向往。我们也看到很多关于社区以及如何增强社区效应的初创公司出现。关于我如何理解它的本质，我认为是：当你的社区帮助你实现了极高的普及度和知名度，以至于它实际上允许你开始向高端市场（即企业级市场）进军。我知道这可能对面向企业的公司非常具体，但在 Notion，我们是这样定义的：有这么多人在谈论它，分享他们基于它构建的东西，甚至围绕它建立自己的业务，以正式化与团队的关系，这降低了许多公司选择 Notion 的风险。仅仅是因为他们通过太多渠道听说过它：在社交媒体上看到过，在播客上听到过，朋友告诉过他们，或者看到了广告牌。所有这些都促使越来越大的公司和团队购买越来越多的席位。我认为这就是社区带给我们的力量。我也看到像 Figma 这样的公司也取得了类似的成就。

---

### [00:14:21] Lenny

**English:**
It sounds like a lot of the way you're describing it is basically awareness. Brand awareness is what you found to be maybe the most useful element of this community that you built around Notion.

**中文翻译:**
听起来你描述的方式很大程度上就是“知名度”。品牌知名度是你发现的、围绕 Notion 建立的这个社区中最有用的元素。

---

### [00:14:31] Camille Ricketts

**English:**
I love using the word discovery because I think that that is even a little bit like a step further than awareness where true discovery is when you have intent to find out more. You've heard about it so many times or you've been intrigued by something that someone has told you to the extent that you're actually going to take the step of now learning about it. And that's where we really wanted to play and to emphasize our work.

**中文翻译:**
我更喜欢用“发现”（discovery）这个词，因为我觉得它比“知名度”更进一步。真正的“发现”是指你有意图去了解更多。你已经听过很多次了，或者被别人告诉你的某些事情所吸引，以至于你真的打算采取行动去学习它。这就是我们真正想要发力并强调工作的地方。

---

### [00:14:59] Lenny

**English:**
Got it. So it sounded like the KPI/OKR of your team was get more people aware and excited to explore Notion.

**中文翻译:**
明白了。所以听起来你们团队的 KPI/OKR 就是让更多人知道并兴奋地去探索 Notion。

---

### [00:15:08] Camille Ricketts

**English:**
Yeah. And maybe this is a helpful tactical point. I think when people think about acquisition or discovery or brand awareness or brand in general, they're like what collection of metrics are actually going to give us insight into this? And the one that I found to be the most instructive was net new visitors to the Notion website. So month over month, how many new people who had never been there before were motivated enough to come and actually learn about the product. And that was really the responsibility of the brand team and the folks that worked with me on community and content and all of the awareness campaigns that we were putting out into the field was about getting more new people interested.

**中文翻译:**
是的。这可能是一个有用的战术点。我认为当人们思考获客、发现、品牌知名度或整体品牌时，他们会想：到底哪些指标能让我们洞察这些？我发现最有指导意义的一个指标是“Notion 网站的净新增访客数”。也就是说，每个月有多少以前从未访问过的人，有足够的动力来到网站并实际了解产品。这正是品牌团队以及与我一起负责社区、内容和所有知名度活动的同事们的职责——让更多新用户产生兴趣。

---

### [00:15:49] Lenny

**English:**
So that begs to the question, did you have any clever ways of attributing that new traffic to stuff your team did versus the SEO team or other teams?

**中文翻译:**
那么问题来了，你有没有什么聪明的方法，能将这些新流量归因于你们团队所做的工作，而不是 SEO 团队或其他团队的工作？

---

### [00:15:58] Camille Ricketts

**English:**
In particular I'll call out the influencer marketing efforts that were really being run by this incredible woman, Lexi Barnhorn, where they were incredibly measurable. Where we were like, okay, well we're sponsoring people for this amount, these creators across these platforms and we know that people came from that content directly to the Notion website. So we were able to draw really tight connections. So I think that some types of content lend themselves to that. And then also with community, there's certain things you can do around helping your community members report on how many people are attending, et cetera, to give you that sense.

**中文翻译:**
我特别要提一下由了不起的 Lexi Barnhorn 负责的红人营销（influencer marketing）工作，这些工作是非常可衡量的。我们会想：好吧，我们以这个金额赞助这些平台上的创作者，我们知道人们直接从那些内容来到了 Notion 网站。所以我们能够建立非常紧密的联系。我认为某些类型的内容非常适合这种归因。此外，对于社区，你也可以做一些事情，比如帮助社区成员报告有多少人参加了活动等等，从而让你对效果有所感知。

---

### [00:16:36] Lenny

**English:**
So you may be already answering this question, but I'm curious what efforts had the most impact to achieve these goals that you had of creating more awareness and discovery motivation and things like that. What actually worked?

**中文翻译:**
你可能已经回答了这个问题，但我很好奇，为了实现增加知名度和发现动力等目标，哪些努力的影响最大？到底什么才是真正有效的？

---

### [00:16:48] Camille Ricketts

**English:**
So I'd say that the community efforts that were very big for us we're the ambassadors. Also making sure that people were hosting in-person events. This really took off in 2019. Obviously we paused for 2020, 2021, but now I just spent time with Notion's head of community, Ben Lang, who truly is the mastermind and genius behind so much of this and he says that they're back up to 30 in-person events a month around the world. So that really helped on the international scale of spreading ubiquity and ended up lending itself to relationships with Station F in France, which is the biggest startup campus in Paris. So really helping us work our way into those types of networks and then supporting those people to also start their own businesses and derive whatever reward they were looking for themselves. So we really wanted to align our goals with theirs. A lot of those folks actually started revenue generating businesses as consultants or course makers or influencers. Some of them just wanted to build their own platforms online. So all of our efforts there are around building guides or counseling people one-on-one or making it easier for them to actually achieve those goals for themselves was also a big part of this growth. And then like I said, influencers. This was something that Ben started exploring in 2019 and we were so pleasantly overwhelmed with the amount of traction and traffic that was driven by working with some of these influencers. And now that program has exploded into a multi-channel effort that's huge for Notion.

**中文翻译:**
我会说，对我们来说非常重大的社区努力是“大使计划”（ambassadors）。此外，还包括确保人们举办线下活动。这在 2019 年真正起飞。显然我们在 2020 年和 2021 年暂停了，但最近我刚和 Notion 的社区负责人 Ben Lang 交流过，他真的是这一切背后的策划者和天才，他说他们现在全球每月恢复到了 30 场线下活动。这在国际范围内极大地帮助了普及，并促成了与法国 Station F（巴黎最大的初创企业园区）的合作。这确实帮助我们打入了这些网络，然后支持这些人创办自己的业务，并获得他们想要的任何回报。我们非常希望将我们的目标与他们的目标对齐。这些人中有很多实际上创办了盈利性业务，比如担任顾问、课程制作人或红人。有些人只是想建立自己的在线平台。因此，我们所有的努力都围绕着编写指南、进行一对一咨询，或者让他们更容易实现自己的目标，这也是增长的重要组成部分。还有我提到的红人营销。这是 Ben 在 2019 年开始探索的，我们对通过与这些红人合作带来的巨大牵引力和流量感到非常惊喜。现在那个项目已经发展成为一个多渠道的庞大工程，对 Notion 至关重要。

---

### [00:18:24] Lenny

**English:**
Awesome. The influencers makes a lot of sense. I want to learn more about this ambassador program and what that was about with events and maybe just broadly, I imagine a lot of founders might be listening and they're like, "Yeah, this all sounds awesome, but how do you know if it's doing anything?" Events. That would be great, but how much is it worth investing? How much time and attention does it take? How do we know if this is actually ROI positive? Is there anything you learn there about just ... Is it a founder must believe in this as a thing that is probably going to work sort of thing? Or is there something you found to convince people like, yes, this is how you can know it's working?

**中文翻译:**
太棒了。红人营销很有道理。我想多了解一下这个大使计划，以及那些活动是怎么回事。广义上讲，我猜很多创始人可能在听，他们会想：“是的，这听起来很棒，但你怎么知道它是否有效？”活动固然好，但值得投入多少？需要多少时间和精力？我们如何知道这是否真的有正向的投资回报率（ROI）？关于这一点你学到了什么……是创始人必须坚信这行得通吗？还是你发现了什么可以向人们证明“是的，这就是判断它是否有效的方法”？

---

### [00:18:58] Camille Ricketts

**English:**
That's a great question. I think that we were really fortunate that Ivan saw the inherent value in community from the very beginning and was deeply supportive. And actually one of my number one recommendations for anybody who suspects the community could be a big growth driver is to not make metrics the be all end all at the very beginning. So we didn't necessarily start measuring things very concretely until last year with community. Mostly because we had already seen so much organic scale that we saw being tied to our community efforts in some way in terms of where we were geographically expanding, how people were reporting that they had discovered us whenever we surveyed them. So that type of motion. And I think for any company that is seeing this type of just organic fervor, one of the worst things you can do is say, let's cut this off at the knees if it's not generating ROI.

**中文翻译:**
这是一个好问题。我认为我们非常幸运，Ivan 从一开始就看到了社区的内在价值，并给予了深度支持。事实上，对于任何怀疑社区可能成为重大增长驱动力的人，我的首要建议之一是：在最开始不要把指标当作衡量一切的唯一标准。直到去年，我们才开始对社区进行非常具体的衡量。主要是因为我们已经看到了如此多的有机增长，并且我们认为这在某种程度上与我们的社区努力有关——比如我们在哪些地理区域扩张，以及我们在调查用户时，他们是如何报告发现我们的。就是这种势头。我认为对于任何看到这种有机热情的公司来说，最糟糕的做法之一就是因为没有产生即时的 ROI 就把它扼杀在摇篮里。

---

### [00:19:52] Lenny

**English:**
I imagine internally there's just like obviously this is good. We may not be able to measure it, but it feels like this is very good for Notion. It feels like especially for a prosumer product like Notion, it makes a lot of sense because it's driven by people using it and then they bring it into the company, like you said. Maybe it's less ROI positive or just one enterprise product. Do you have any thoughts there? Is this a great strategy for prosumer enterprise products more so than more enterprise-y?

**中文翻译:**
我猜在公司内部，大家会觉得“显然这是好事”。我们可能无法精确衡量，但感觉这对 Notion 非常有利。感觉特别是对于像 Notion 这样的“生产型消费者”（prosumer）产品，这非常有意义，因为它是由个人使用驱动的，然后像你说的，他们把产品带进公司。也许对于纯企业级产品来说，ROI 没那么高。你对此有什么看法？这是否更适合“生产型消费者”企业产品，而不是纯粹的传统企业级产品？

---

### [00:20:19] Camille Ricketts

**English:**
Definitely I think if you have a long sales cycle or a high price point where there has to be many, many, many touchpoints in order to get somebody to decide to buy, I'm not sure that community should be the number one thing that you invest in. Certainly for freemium products, I think for a lot of them, especially if they have what I'm going to call the atomic unit of sharing, which I will define out, it becomes a no-brainer. I think that community lends itself particularly well if you have something that your product creates that people want to share because it exhibits something about themselves. So at Notion it was templates or even people just creating their own workspaces and being really excited to show them off. So Notion really benefited from being a creative product, but the same is true of Figma or Canva or any of these where showing people what it is that you've created is an aspirational thing to do. Because you are showing that you are really well versed in how to use the products, extremely organized. You're self expressing in some way. So if your product does have that element to it, I think that community is a great investment.

**中文翻译:**
确实，我认为如果你有一个漫长的销售周期或高昂的价格，需要经过无数个接触点才能让某人决定购买，我不确定社区是否应该是你首选的投资项目。当然，对于免费增值（freemium）产品，我认为对其中很多产品来说，特别是如果它们拥有我所说的“分享的原子单位”（我稍后会定义），这简直是不二之选。我认为，如果你的产品能创造出人们想要分享的东西，因为这能展示他们自己，那么社区就特别适用。在 Notion，这就是模板，甚至是人们创建自己的工作区并兴奋地展示它们。Notion 确实受益于它是一款创意产品，Figma、Canva 或任何类似产品也是如此——向人们展示你创造的东西是一件令人向往的事情。因为你在展示你非常精通如何使用这些产品，非常有条理，你在以某种方式表达自我。所以，如果你的产品具有这种元素，我认为社区是一项伟大的投资。

---

### [00:21:34] Lenny

**English:**
You touched on this point, and I don't think people realize this, but you can make a lot of money creating templates on Notion, right? That's a whole ecosystem. Can you talk about that? Because I don't think a lot of people know this.

**中文翻译:**
你提到了这一点，我想很多人还没意识到，在 Notion 上制作模板是可以赚很多钱的，对吧？那是一个完整的生态系统。你能谈谈这个吗？因为我觉得很多人还不知道。

---

### [00:21:45] Camille Ricketts

**English:**
Yeah. This is one of the reasons that I would advise any of the companies that feel like they fall into this category start early. Because you need to nurture all of these different routes that people in your community can take. Certainly early on I think that the people that we initially recruited in the ambassadors didn't see themselves doing maybe even close to a million dollars in business around helping other teams succeed with the product or selling templates. I remember really early on, probably mid 2021 we heard of one creator who had made $35,000 in four months selling one template and that was a very common story then from that point forward. And helping them do that, actually creating the guide material and the networks and also the connections between the people who are running similar businesses who could help each other, that all became really fundamental. But to your point about, oh is this actually related to the enterprise motion for Notion? So many companies now of many sizes are relying on the consultants that first came up through our community and some of those consultants are now employing dozens of other people.

**中文翻译:**
是的。这就是为什么我会建议任何属于这一类的公司尽早开始的原因之一。因为你需要培育社区成员可以采取的所有这些不同路径。当然，在早期，我想我们最初招募的大使们可能没预见到自己会围绕帮助其他团队使用产品或销售模板，做出接近百万美元的业务。我记得很早以前，大概是 2021 年中期，我们听说一位创作者在四个月内通过销售一个模板赚了 3.5 万美元，从那以后这类故事就非常普遍了。帮助他们实现这一目标，实际编写指南材料、建立网络，以及在经营类似业务的人之间建立联系以便互助，这些都变得非常基础。但回到你关于“这是否真的与 Notion 的企业级业务有关”的问题：现在许多不同规模的公司都在依赖最初从我们社区成长起来的顾问，而其中一些顾问现在已经雇佣了数十名员工。

---

### [00:22:53] Lenny

**English:**
That's incredible. There's no better way to motivate someone to evangelize Notion than have their income rely on Notion.

**中文翻译:**
太不可思议了。没有什么比让一个人的收入依赖于 Notion 更能激励他去宣传 Notion 了。

---

### [00:23:00] Camille Ricketts

**English:**
And it's also just inspiring for us, honestly. There's so many people who started off with not very many followers and now they are celebrities within this ecosystem.

**中文翻译:**
老实说，这对我们来说也非常鼓舞人心。有这么多起初粉丝并不多的人，现在成了这个生态系统中的名人。

---

### [00:23:12] Lenny

**English:**
So maybe coming back to the ambassador program, that's separate from this selling Notion templates ecosystem. What is the ambassador program?

**中文翻译:**
那么回到大使计划，它与销售 Notion 模板的生态系统是分开的吗？大使计划到底是什么？

---

### [00:23:19] Camille Ricketts

**English:**
They're actually quite blended because the folks who are excited about Notion, it takes a lot of forms. Sometimes they want to host events, sometimes they want to build templates. So we would actually have channels inside of our Slack instance for the ambassadors that had these areas of focus based on what people really were passionate about or wanted to do and they were like a force multiplying flywheel for each other. Because a lot of folks would enter the ambassadors program and then I'm happy to talk about champions as well, which is a little bit different, and then discover what it would mean for them to build templates and it became motivating for that reason. So on the champions side of things, and this is maybe speaking a little bit more to the enterprise as well, we wondered if the same DNA that existed among consumers for the most part in the ambassadors could work for folks who were inside of our customer companies. And so we launched another community, another Slack instance for folks who were the most passionate or the most avid users of Notion inside of our customer companies, which has become just a wonderful channel for customer success to be more communicative with those companies, make sure that things are sticking or obstacles are being overcome. And that's been designed very specifically that way and it has been really, really valuable over time.

**中文翻译:**
它们实际上是相当融合的，因为对 Notion 感到兴奋的人会有很多表现形式。有时他们想举办活动，有时他们想制作模板。所以我们实际上在 Slack 的大使频道中设置了不同的关注领域，基于人们真正热衷或想做的事情，他们就像彼此的“力量倍增飞轮”。因为很多人加入大使计划后（我也很乐意谈谈“拥护者”计划，那是有点不同的），会发现制作模板对他们意味着什么，并因此产生动力。至于“拥护者”（champions）方面，这可能更多地涉及企业端，我们想知道大使计划中大部分存在于消费者中的基因，是否也适用于我们客户公司内部的人员。因此，我们为客户公司内部最热情或最资深的 Notion 用户推出了另一个社区、另一个 Slack 实例。这已成为客户成功团队与这些公司进行更多沟通、确保产品落地或克服障碍的绝佳渠道。它是专门为此设计的，随着时间的推移，它变得非常非常有价值。

---

### [00:24:35] Lenny

**English:**
Okay. So let me try to understand this. Champions are basically the most active users of Notion. You put them in a Slack and help them become even more excited and make sure they're happy. Ambassador. I still don't totally understand what is an ambassador? Is that someone you're paying to help promote Notion? What does that actually mean when you're an ambassador?

**中文翻译:**
好的，让我试着理解一下。“拥护者”基本上是 Notion 最活跃的用户。你把他们放在一个 Slack 里，帮助他们变得更兴奋，并确保他们满意。“大使”呢？我还是不太明白什么是大使？是你付钱请他们帮忙推广 Notion 的人吗？当你是大使时，这到底意味着什么？

---

### [00:24:52] Camille Ricketts

**English:**
They're people who are really just passionate about the product. So it's not transactional. They're people who love building with Notion. They love sharing what they've built in order to help others. And they really just want it to be a bigger part of their lives. And I think that one of the points about community is that it's not just a one-to-one conversation with us. The big draw over time, maybe people joined because they would get early access to features. We would get their feedback. That became really important for our product team or because we would offer AMAs with some of our folks internally. But over time it was really because they were forming these bonds with each other and learning so much from each other that most of the time someone would come in and say, I'm struggling with this or I don't quite know how to use this and it would be another member of the community that would help them more immediately. So it really allowed them to form these dense networks of friendships that I think became just a positive part of people's lives.

**中文翻译:**
他们其实只是对产品充满热情的人。所以这不是交易性的。他们是喜欢用 Notion 构建东西的人。他们喜欢分享自己的成果以帮助他人。他们真心希望 Notion 成为他们生活中更重要的一部分。我认为社区的一个关键点在于，它不仅仅是与我们的一对一对话。随着时间的推移，最初人们加入可能是因为可以提前体验新功能，我们会收集他们的反馈，这对我们的产品团队非常重要；或者是因为我们会提供与内部员工的 AMA（问我任何事）环节。但久而久之，真正吸引他们的是他们彼此之间建立了联系，并从对方身上学到了很多东西。大多数时候，如果有人进来反映“我正为此苦恼”或“我不太清楚怎么用这个”，社区里的其他成员会更迅速地提供帮助。所以这让他们形成了紧密的友谊网络，我认为这成了人们生活中积极的一部分。

---

### [00:25:51] Lenny

**English:**
What I'm taking away from this partly is you identify a group of people that are interested in Notion, excited about Notion and then just lean in to support them. There's people that are buying Notion and that are power users, help them be better power users. Influencers that are kind of excited about Notion, pay them to promote Notion. Then the ambassadors that are people just passionate about Notion, help them be more passionate. And then the people making templates, help them be successful. Is that roughly how you think about it? Just identify something that's working and make it more effective?

**中文翻译:**
我从中学到的是，你识别出一群对 Notion 感兴趣、感到兴奋的人，然后全力支持他们。对于购买 Notion 的重度用户，帮助他们成为更好的重度用户；对于对 Notion 感兴趣的红人，付钱让他们推广；对于那些纯粹热爱 Notion 的大使，帮助他们保持热情；对于制作模板的人，帮助他们获得成功。大概就是这样吗？识别出有效的东西，然后让它更有效？

---

### [00:26:21] Camille Ricketts

**English:**
I think if it doesn't sound too reductive, yes. I would also say that one of the things that I think Ben was best at is not putting a one size fits all experience on any of this. I think that some communities get built where people are like, okay, well we have this community and it's going to be this and this and this, or these are the types of programs we're going to offer or these are the types of interactions we're going to have. As opposed to I think a lot of listening of the people who are actually participating. Really early on one of the things that Ben did that I thought was really amazing was he'd spend a ton of time just on Zoom having conversations, one-on-one conversations, semi small group conversations just saying, "Why are you here? Why do you like participating in this? What is it that would make it better?" And really helping our entire team follow their lead. I would recommend highly not necessarily coming in with preconceived notions about what a community needs to look like.

**中文翻译:**
如果听起来不至于太简略的话，是的。我还想说，我认为 Ben 最擅长的一点是，不把“一刀切”的体验强加在任何事情上。有些社区建立时，人们会想：好吧，我们有这个社区，它将包含这个、那个和那个，或者我们将提供这些类型的项目，或者我们将进行这些类型的互动。而 Ben 做了大量的倾听，听取那些实际参与者的意见。很早以前，Ben 做了一件我认为非常了不起的事，他花了大量时间在 Zoom 上进行一对一或半小组对话，只是问：“你为什么在这里？你为什么喜欢参与这个？什么能让它变得更好？”并真正帮助我们整个团队跟随他们的引导。我强烈建议不要带着对社区“应该长什么样”的先入为主的观念去开始。

---

### [00:27:21] Lenny

**English:**
You touched on this point, that if the founder believes in the power of community, this becomes so much easier. A lot of founders are like, "Nah. That's a waste of time." Do you think founders are convincible that building community and investing in community is worth it? Have you seen that effective where a founder just comes into it being like, "Nah, I don't think this is worth our time," and then they get convinced later? Or is it just like, "Nah, forget it. Don't even try."?

**中文翻译:**
你提到了这一点，如果创始人相信社区的力量，事情就会变得容易得多。很多创始人会觉得：“不，那是浪费时间。”你认为创始人是可以被说服去相信建立和投资社区是值得的吗？你有没有见过这样的案例：创始人一开始觉得“不，我不觉得这值得花时间”，后来被说服了？还是说“算了，别白费力气了”？

---

### [00:27:45] Camille Ricketts

**English:**
I mean I've talked to a lot of different people who come at this with different impressions and everybody knows more about their company than I do, but I do think that if ubiquity or just the sheer word of mouth engine is something that is going to be valuable for your company over time, I would really urge people to sit down and really think carefully what is going to be more conducive to our long-term success? Is it going to be that ubiquity or is it going to be revenue now? And I think if we look at a lot of the companies that have been just wildly successful from the start, they're people who have pushed off maybe monetizing every little thing if it's going to really put a damper on that type of enthusiasm and momentum that people have to share it at what it is they're doing. Because there's always opportunity I think later once you have that big tide of people who are not just excited but also legitimizing what it is that you do every single day, that gets mobilized in a lot of different directions and you have a lot more options then.

**中文翻译:**
我曾与许多对此有不同印象的人交谈过，每个人都比我更了解自己的公司。但我确实认为，如果普及度或纯粹的口碑引擎对你的公司长期发展有价值，我会敦促人们坐下来仔细思考：什么更有利于我们的长期成功？是那种普及度，还是眼前的收入？如果我们观察许多从一开始就大获成功的公司，会发现他们往往推迟了对每一件小事的变现，如果变现会抑制人们分享的热情和动力的话。因为我认为以后总会有机会，一旦你拥有了庞大的人群，他们不仅感到兴奋，而且每天都在认可你所做的事情，这种力量可以被动员到很多不同的方向，到那时你会有更多的选择。

---

### [00:28:47] Lenny

**English:**
What's interesting about Notion is you have high LTVs when you sell to larger companies, but the initial users are often just regular folks. And so I think it's a unique place where you have cash to spend on making it ubiquitous and getting the word out through all these community efforts because it'll pay off. And a lot of companies probably don't have that advantage. So would it feel right to say that this is really effective for product led, growthy, freemium products most? Is that a good way to think about it?

**中文翻译:**
Notion 有趣的地方在于，当你卖给大公司时，LTV（客户终身价值）很高，但最初的用户往往只是普通人。所以我觉得这是一个独特的地方，你有资金投入到普及化中，通过这些社区努力来传播口碑，因为这最终会得到回报。很多公司可能没有这个优势。那么，说这种策略对产品驱动型、增长型、免费增值类产品最有效，是否正确？这是一种好的思考方式吗？

---

### [00:29:20] Camille Ricketts

**English:**
Yeah. Or I think if organic growth is something that you see being really beneficial or if organic growth happens to be something you really have to crack because you don't always have everything you need for paid growth from either a resourcing standpoint, team standpoint, really figuring out how to get that organic flywheel going can serve you well. It becomes this buttress for any paid growth you explore in the future.

**中文翻译:**
是的。或者我认为，如果你认为有机增长非常有益，或者如果你必须攻克有机增长（因为从资源或团队的角度来看，你并不总是拥有付费增长所需的一切），那么弄清楚如何启动有机飞轮会对你大有裨益。它会成为你未来探索任何付费增长的坚实后盾。

---

### [00:29:47] Lenny (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta. Helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential, SOC 2 can either open the door for bigger and better deals or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table. Beginning a SOC 2 report can be a huge burden, especially for startups. It's time consuming, tedious and expensive. Enter Vanta. Over 3000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months. Less than a third of the time that it usually takes. For a limited time Lenny's podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny. That's V-A-N-T-A.com/lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
本期节目由 Vanta 赞助。Vanta 帮助你简化安全合规流程，加速业务增长。如果你的业务在云端存储数据，你很可能已经被问到或将被问到 SOC 2 合规性。SOC 2 是证明你的公司采取了适当安全措施来保护客户数据的一种方式，它能建立客户和合作伙伴（特别是那些有严格安全要求的客户）的信任。此外，如果你想向企业销售产品，证明安全性至关重要。SOC 2 既可以为你打开更大、更好交易的大门，也可能让你的业务停滞不前。如果你没有 SOC 2，很有可能你连谈判桌都上不了。获取 SOC 2 报告可能是一个巨大的负担，尤其是对初创公司而言，既耗时、乏味又昂贵。Vanta 应运而生。超过 3000 家快速增长的公司使用 Vanta 自动完成高达 90% 的 SOC 2 相关工作。Vanta 可以在几周内（而不是几个月）让你做好安全审计准备，时间不到通常所需的三分之一。在限定时间内，Lenny 播客的听众可以享受 1000 美元的 Vanta 优惠。只需访问 vanta.com/lenny (V-A-N-T-A.com/lenny) 了解更多信息并领取折扣。今天就开始吧。

---

### [00:31:04] Lenny

**English:**
What other companies come to mind when you think about companies that effectively did community led growth, did community well and grew in large part because of community?

**中文翻译:**
当你想到那些有效地实施了社区驱动型增长、把社区做得很好，并且很大程度上依靠社区实现增长的公司时，你还会想到哪些公司？

---

### [00:31:14] Camille Ricketts

**English:**
I've mentioned Figma a couple times here so I don't want to beleaguer the point, but they're certainly a team that I've looked up to through my entire experience at Notion. We were kind of sibling companies in a way. Huge kudos to Claire Butler over there who I knew led all of those efforts and we would trade a lot of knowledge back and forth, which was so lovely to have that relationship. But they did an amazing job I think in a similar vein to Notion of saying, okay, people are really excited to create these things and then put them out there on the internet. So how can we just fuel that particular motion out there? The other example I'll give, which is a little bit of a different tack is Stripe. And when Stripe launched Stripe Atlas, not necessarily core to the initial product line that Stripe was known for and what had been foundational for them, but allowed them to build this community among probably their core demographic at the time, which was founders and startups that were growing through the stages to mid-market, they were able to cultivate this huge audience of founders around giving advice and providing them with resources to actually get started and do that zero to one journey. So while it was adjacent to maybe what the company's core mission was, it allowed them to actually create community among their customer base because they were like, "We're knowledgeable. We can share these things with you that we know are core to your journey." So I would encourage anyone who's thinking about community that way to be like, "Oh, maybe it doesn't have to be around our product. So specifically. What other knowledge or resourcing can we offer to the people who we do want using our product that's going to be really instrumental for them and can we convene them around that idea?"

**中文翻译:**
我已经提过几次 Figma 了，所以不想再赘述，但他们在我在 Notion 的整个经历中确实是我一直仰慕的团队。在某种程度上，我们像是兄弟公司。非常感谢那里的 Claire Butler，我知道她领导了所有这些工作，我们经常互相交流知识，拥有这种关系非常棒。我认为他们做得非常出色，与 Notion 类似：既然人们非常兴奋地创造这些东西并发布到网上，我们如何才能助推这种特定的势头？另一个例子是 Stripe，它的策略略有不同。当 Stripe 推出 Stripe Atlas 时，这并不一定是 Stripe 当时核心产品线的一部分，但它允许他们在当时的核心受众（即处于成长阶段到中型市场的创始人和初创公司）中建立社区。他们能够围绕提供建议和资源，培养庞大的创始人受众，帮助他们真正开始并完成从 0 到 1 的旅程。虽然这与公司的核心使命可能只是相邻关系，但它允许他们在客户群中建立社区，因为他们表现出：“我们很专业，我们可以与你们分享这些对你们的旅程至关重要的东西。”所以我鼓励任何思考社区的人想一想：“也许社区不一定要紧紧围绕我们的产品。我们还能为那些我们希望使用我们产品的人提供哪些对他们至关重要的知识或资源？我们能否围绕这个想法把他们聚集起来？”

---

### [00:32:54] Lenny

**English:**
I'm noticing a strong correlation between legendary generational companies, Figma, Stripe, Notion and community efforts and building community. That's interesting.

**中文翻译:**
我注意到在那些传奇的、代际性的公司（如 Figma、Stripe、Notion）与社区努力和社区建设之间存在着强烈的相关性。这很有趣。

---

### [00:33:05] Camille Ricketts

**English:**
Yes. I'm a big proponent. At the same time I don't think that community is right for every company. I think that there is definitely an analysis to run on that. But hopefully this is helpful for those who can identify that those are attributes they have.

**中文翻译:**
是的，我是坚定的支持者。但同时，我不认为社区适合每一家公司。我认为绝对需要对此进行分析。但希望这对那些能识别出自己具备这些属性的人有所帮助。

---

### [00:33:19] Lenny

**English:**
To pull on a thread there, what are maybe thoughts for when it probably doesn't make sense to invest a lot of efforts into building a community around your product? We talked a little bit about high-end enterprise products. Is there anything else that just like, man, it's probably not worth your time?

**中文翻译:**
顺着这个话题，你认为在什么情况下，投入大量精力围绕产品建立社区可能没有意义？我们谈到了一点高端企业级产品。还有什么情况会让你觉得“伙计，这可能不值得你花时间”？

---

### [00:33:34] Camille Ricketts

**English:**
Like I said, if it's more of a sales led culture that you have, which is definitely true of products that are a little bit pricier or that require longer contracts, so understanding that. But I do think the community takes on different forms and I think when you hear the word community, you think of a big forum of some type, whether it's a Slack instance or something else where people are chatting away all day long. And I don't think it has to be that. That's not the only representation of it. So if you think about what is going to be right for you at any given time, I actually created this two by two matrix, which maybe I'll share with you after this. And on the axis you have, whether you have hit product market fit or if you're still exploring product market set and then whether you're strongly enterprise or strongly consumer. And based on where you land in that two by two matrix, there's a form of community or a community related initiative that could be right for you. So just to give you an example of maybe an extremely different form factor from Notion, let's say that you're still on your way to product market fit and you're a strongly enterprise oriented product. I think that you have the opportunity to do customer advisory boards, which is really convening even smaller circles of ideal fit users and making sure that they are connected to each other as well as you, and then incentivize to provide you with feedback. Understanding that they're really on the ground floor of this journey with you and that they're going to be able to have influence over whatever you do in the future. Those folks can end up growing into your biggest evangelists and I've seen that happen a number of times and I would still consider that community even though maybe that is not what comes to mind for folks.

**中文翻译:**
正如我所说，如果你更多的是销售驱动型文化（这对于价格较高或需要长期合同的产品来说确实如此），那么要理解这一点。但我确实认为社区有不同的形式。当你听到“社区”这个词时，你可能会想到某种大型论坛，无论是 Slack 还是其他什么，人们整天在那里聊天。我不认为必须是那样，那不是唯一的表现形式。所以如果你思考在任何特定时间什么适合你，我实际上创建了一个 2x2 矩阵，稍后我可以分享给你。坐标轴分别是：你是否达到了产品市场契合度（PMF），以及你是强企业导向还是强消费者导向。根据你在这个矩阵中的位置，会有一种适合你的社区形式或社区相关举措。举个与 Notion 完全不同的例子：假设你还在寻找 PMF 的路上，且是一个强企业导向的产品。我认为你有机会建立“客户顾问委员会”（Customer Advisory Boards），这实际上是召集更小范围的理想匹配用户，确保他们彼此之间以及与你建立联系，并激励他们提供反馈。让他们明白他们正与你一起处于这段旅程的起点，并且他们将能够影响你未来的行动。这些人最终可能成长为你最大的福音传道者（evangelists），我见过很多次这种情况，我仍然认为那是社区，尽管人们可能不会首先想到它。

---

### [00:35:20] Lenny

**English:**
Well I imagine that becomes the seed of a community that you eventually build. Let's definitely link to this in the show notes. Can you give maybe a couple more examples of this grid? So that was pre-product market fit and then what was the other?

**中文翻译:**
我猜那会成为你最终建立的社区的种子。我们一定要在节目笔记中附上这个链接。你能再举几个这个矩阵的例子吗？刚才那个是 PMF 之前，另一个维度是什么？

---

### [00:35:32] Camille Ricketts

**English:**
Strongly enterprise.

**中文翻译:**
强企业导向。

---

### [00:35:33] Lenny

**English:**
Enterprise. Okay, cool. Yeah, what are a couple other of the elements of this grid?

**中文翻译:**
企业导向。好的，酷。矩阵中还有哪些其他元素？

---

### [00:35:37] Camille Ricketts

**English:**
So if you're strongly enterprise and you have product market fit, let's say, this is something that Notion has really benefited from, but really emphasizing the champions in the consultants communities. So the folks who, like I said, may be inside of our customers who really get it, really get your value, really are excited to help you land and expand perhaps inside of their companies, making sure that they have a place to gather and a place to feel like they are more connected with your team than the average person gets to be. That they are special and that they have access. And then on the consultant side, like I said, just making it really easy, removing friction, helping promote the folks who want to be out there, helping you succeed with more customers. Like Salesforce. I know that this is a golden oldie of an example, but if you talk to anybody who was really early at Salesforce, they really went into this where they saw people emerging who wanted to help other companies. This layer of people who didn't work at Salesforce but saw the opportunity to help other companies actually succeed with it, implement it, grow with it, and that's become a massive part of Salesforce's model. And so if you're in that quadrant, figuring out how to start moving people in your customer base into those categories.

**中文翻译:**
如果你是强企业导向且已经达到了 PMF，这是 Notion 真正受益的地方，那就是强调“拥护者”和“顾问”社区。正如我所说，这些人可能在我们的客户内部，他们真正理解产品的价值，非常兴奋地帮助你在他们公司内部实现“落地与扩张”（land and expand）。确保他们有一个聚集的地方，让他们觉得比普通人更贴近你的团队，让他们感到自己很特别并拥有专属权限。在顾问方面，就像我说的，要让事情变得非常简单，消除摩擦，帮助推广那些愿意在外面帮助你赢得更多客户的人。就像 Salesforce，我知道这是一个经典的老例子，但如果你和任何 Salesforce 的早期员工交谈，他们真的投入了大量精力，因为他们看到有人涌现出来想帮助其他公司。这层人不在 Salesforce 工作，但看到了帮助其他公司成功使用、实施并随之成长的机会，这已成为 Salesforce 模式的重要组成部分。所以如果你在这个象限，就要弄清楚如何开始将你的客户群引导到这些类别中。

---

### [00:37:00] Lenny

**English:**
This is awesome. Maybe let's do one more of this grid and then we'll leave one for people to click into and check it out.

**中文翻译:**
太棒了。也许我们再讲一个象限，然后留一个让大家点击链接去查看。

---

### [00:37:04] Camille Ricketts

**English:**
I'll talk about Notion's quadrant, which is the one that I would put up and to the right, which is you have product market fit and you're maybe a little bit closer to the consumer side of the spectrum. Obviously Notion runs the full gamut, but I would say especially early on I think that that's where we saw things take root and that's where I think ambassadors and influencers really take off. Individuals who are going to be extremely vocal, extremely excited, and where you're going to see more of this wildfire spread, at least trying the product, using the product, understanding what the product is. So if you can try to fuel that type of motion if you're in that quadrant, that's helpful.

**中文翻译:**
我来说说 Notion 的象限，也就是我会放在右上角的那个：你已经达到了 PMF，并且可能更接近光谱的消费者端。显然 Notion 涵盖了全光谱，但我会说，特别是在早期，我们看到事物在那里生根发芽，那也是大使和红人真正发挥作用的地方。那些极其敢于发声、极其兴奋的个人，你会看到这种像野火一样的传播，至少让人们尝试产品、使用产品、了解产品是什么。所以如果你在这个象限，尝试助推这种势头会非常有帮助。

---

### [00:37:43] Lenny

**English:**
I want to come back to this ambassador program real quick because it feels like something that a lot of people talk about and can do and especially in this quadrant of product market fit and consumer. How does this work? Is it you select, here's 100 ambassadors we're going to pick because we think they're awesome and they're great examples of people using, say, Notion and then we're just going to provide them with all the help they need to be successful with Notion. How do you think about creating an ambassador program?

**中文翻译:**
我想快速回到大使计划，因为这似乎是很多人都在谈论且可以做的事情，特别是在 PMF 和消费者这个象限。它是如何运作的？是你们挑选 100 个大使，因为觉得他们很棒，是使用 Notion 的典范，然后为他们提供成功使用 Notion 所需的所有帮助吗？你如何构思创建一个大使计划？

---

### [00:38:10] Camille Ricketts

**English:**
I actually think it's pretty analogous to when you're thinking about positioning your company because I think the best first step for any positioning exercise is to think who are our best fit customers? And it's not necessarily who we wish they would be, but it's actually the hard cold reality of who they actually are. Where it's like these are the people that seem to be really getting it. They're paying us more, they're talking about it just organically. So really figuring out everything about who they are and making sure that those are the people that you're actually inviting in early. So the initial base of the ambassadors program which started back in 2019 was just 20 people and they were the 20 people who we happened to see be the most vocal already across Twitter and a couple of other social media platforms because they had that shared quality of wanting to be really vocal and expressive about their experience with the product. So that would be my advice for how to get one of these rolling.

**中文翻译:**
我实际上认为这与思考公司定位非常相似。因为我认为任何定位练习的最佳第一步都是思考：谁是我们最匹配的客户？这不一定是“我们希望他们是谁”，而是“他们实际上是谁”的冷酷现实。也就是那些似乎真正理解产品的人：他们付给我们更多钱，他们正在有机地谈论它。所以要真正弄清楚他们是谁，并确保他们就是你早期邀请的人。2019 年启动的大使计划初始成员只有 20 人，他们正是我们碰巧在 Twitter 和其他社交平台上看到的最敢于发声的人，因为他们都有一个共同特质：想要大声表达他们对产品的使用体验。这就是我关于如何启动这类计划的建议。

---

### [00:39:13] Lenny

**English:**
And then what do you do for them?

**中文翻译:**
然后你为他们做些什么？

---

### [00:39:13] Camille Ricketts

**English:**
Definitely making sure that there's enough incentive built in, right? Because like we said, it's not meant to be a transactional relationship, but we want them to feel like they are having a special experience, that they are connected with the company in a unique way. And it was so interesting to us how giving them the preview of features was so motivating to them and being able to use them and then give us feedback and feel really heard by the product team. So that was a big area of focus and I know that that still is and it's become even more of a robust conversation between the community and the team at Notion itself. And then also we would do these very special experiences where Ivan or Akshay or Simon or MLM who's the head of engineering there would be available for these conversations where they would answer questions and it would feel like a very proprietary space. I think that that was really interesting to people. And of course the things that you would suspect around subsidizing events. Making sure that people felt that they were actually supported by us to throw these events. And then also promoting their work. So if you look back at the social media channels, so much of the focus is on putting the creations of the people we were working with front and center as opposed to talking about just what the company was up to.

**中文翻译:**
肯定要确保内置了足够的激励，对吧？因为正如我们所说，这不应该是交易关系，但我们希望他们觉得自己在享受特殊的体验，以独特的方式与公司联系在一起。让我们感到非常有趣的是，给他们提供功能预览对他们来说是多么大的动力，让他们能够使用这些功能并提供反馈，并感到产品团队真正听取了他们的意见。这一直是重点，而且我知道现在依然如此，社区与 Notion 团队之间的对话变得更加稳健。此外，我们还会举办一些非常特别的活动，Ivan、Akshay、Simon 或工程负责人 MLM 会参与对话，回答问题，感觉就像一个非常私密的专属空间。我认为这对人们非常有吸引力。当然，还有你预料到的补贴活动，确保人们感到他们在举办这些活动时得到了我们的实际支持。最后是推广他们的作品。如果你回顾我们的社交媒体频道，你会发现很大一部分重点是把我们合作者的创作放在中心位置，而不是仅仅谈论公司在做什么。

---

### [00:40:36] Lenny

**English:**
Have you ever written about just how to design an ambassador program or has anyone written about how Notion did this? Because this is really interesting.

**中文翻译:**
你有没有写过关于如何设计大使计划的文章，或者有没有人写过 Notion 是如何做到的？因为这真的很有趣。

---

### [00:40:42] Camille Ricketts

**English:**
I don't know if anything has been written or went into all of this detail, but it was truly one of the more magical and I think still is one of the more magical parts of this entire endeavor. And now that team is three people. So Ben who's still there doing amazing things, Francisco who joined us in 2021. Or sorry at the end of 2020. And then Emma. And they are just all day every day talking to people around the whole world. The international component of this is also just completely wild to see.

**中文翻译:**
我不知道是否有人写过这么详细的内容，但这确实是整个事业中最神奇的部分之一，而且我认为现在依然如此。现在那个团队有三个人：Ben 还在那里做着了不起的事情，Francisco 是 2020 年底加入的，还有 Emma。他们每天都在与世界各地的人交谈。看到其中的国际化成分也让人感到非常震撼。

---

### [00:41:18] Lenny

**English:**
This could be a future First Round Review post, which we'll talk a bit about.

**中文翻译:**
这可以成为未来《First Round Review》的一篇文章，我们稍后会谈到。

---

### [00:41:21] Camille Ricketts

**English:**
Yes. Perhaps.

**中文翻译:**
是的，也许吧。

---

### [00:41:24] Lenny

**English:**
Last question about this segment. Say someone is convinced they want to start investing in community and we talked about this two by two, but maybe just broadly if you had to boil it down to two or three pieces of advice for founders, for teams thinking about investing in community led growth and community in general, what would be some of those pieces of advice?

**中文翻译:**
关于这个环节的最后一个问题。假设有人被说服了，想要开始投资社区，我们谈到了这个 2x2 矩阵，但如果让你概括成两三条建议，给那些考虑投资社区驱动型增长和广义社区的创始人或团队，你会给什么建议？

---

### [00:41:44] Camille Ricketts

**English:**
I don't know if you want to link to this in the show notes as well, but I actually put together some commandments for community builders.

**中文翻译:**
我不知道你是否也想在节目笔记中链接这个，但我实际上为社区建设者总结了一些“诫命”。

---

### [00:41:50] Lenny

**English:**
Ooh. Absolutely.

**中文翻译:**
噢，当然要。

---

### [00:41:51] Camille Ricketts

**English:**
Some alliteration. So the thing that I think were very defining for us early on, I already mentioned something about this, but not trying to hit a number early on. So don't dilute the impact of what it is that you're trying to do in order to show growth. I think that that's very important to protect yourself early on. So making sure that you are learning what individuals really want out of this and making them feel like they're very seen and very heard. That was a big area of focus and I think it's what kept people really engaged and coming back and feeling like this was a secondary family for them. And then one of the things that was most interesting to us that once we started sharing what was going on in the community with folks at Notion. So we would do this during all Hands meetings or on Slack, Ben would post these really incredible updates of just all of the activities of people in the community and what they were up to every month. And it was just so inspiring for everybody inside the company that I think it all rallied us to do even more, I guess, day to day and really understand who it was we were building for.

**中文翻译:**
一些押韵的建议。我认为早期对我们非常有定义意义的一点（我已经提到过）是：不要在早期试图追求某个数字。不要为了展示增长而稀释你正在做的事情的影响力。我认为在早期保护好自己非常重要。确保你正在了解个人真正想要什么，并让他们感到自己被看到、被听到了。这是一个重点，我认为正是这一点让人们保持高度参与并不断回来，感觉这里就像他们的第二个家。另一件让我们觉得最有趣的事情是，一旦我们开始与 Notion 的同事分享社区里发生的事情——比如在全员大会上或在 Slack 上，Ben 会发布非常精彩的月度更新，展示社区成员的所有活动和动态。这对公司内部的每个人都是巨大的鼓舞，我认为它激励了我们每天做得更多，并真正理解我们是在为谁而构建。

---

### [00:43:00] Lenny

**English:**
Is there any other commandments you would add for if you already have a community going? If you have something bubbling for things you should do to keep it healthy and consistently good and growing?

**中文翻译:**
如果已经有一个社区在运行了，你还会增加什么诫命吗？如果已经有一些苗头了，应该做些什么来保持它的健康、持续优秀和增长？

---

### [00:43:12] Camille Ricketts

**English:**
Yeah. I mean this is going to be a little contrarian perhaps, and I mean this is just one data point for me, but not growing it so big so fast. One thing that we actually thought about pretty carefully was what a rate of healthy growth would be. So there actually is an application process for joining the ambassadors. It's a very light application process and it really is just so that we know how many people are interested in this. And then they're inducted around ... I think at the time it was 20 people at a time every month. So that it wouldn't feel like all of a sudden this had changed in terms of how the interactions were feeling, but rather gave everybody time to welcome the new people in and get to know them. And one of Ben and I's favorite things ever about working at Notion I think was when we would induct new people into the ambassadors and they would introduce themselves and say, "Hey, I am from Venezuela and here's the ways in which notion has changed my life."

**中文翻译:**
是的。这可能有点反直觉，这只是我的一个观点：不要让它长得太快、太大。我们实际上非常仔细地思考过什么是健康的增长率。所以加入大使计划实际上有一个申请流程。这是一个非常简单的流程，主要是为了让我们知道有多少人感兴趣。然后他们会被分批引入……我想当时是每月 20 人。这样就不会让人觉得互动氛围突然变了，而是给了每个人时间去欢迎新人并了解他们。我和 Ben 在 Notion 工作最喜欢的时刻之一，就是当我们把新人引入大使计划时，他们会自我介绍说：“嘿，我来自委内瑞拉，这是 Notion 改变我生活的方式。”

---

### [00:43:12] Lenny

**English:**
That's awesome.

**中文翻译:**
太棒了。

---

### [00:44:11] Camille Ricketts

**English:**
"I'm from Hong Kong and here's how it's changed my life." And all of that was just so fulfilling. That would be the number one thing I would say is give your community time to actually grow in what feels like an organic fashion as well. Because I think ironically, and then I'll stop rambling about this, but if you grow to something like, oh we have 5,000 ambassadors, which feels really good to say on a website, the conversation is actually very muted. I think because people feel like they're speaking to an auditorium whenever they say anything. I think it's because you don't really have a sense of who else is there with you. So helping to defray those concerns I think is a good course of action.

**中文翻译:**
“我来自香港，这是它如何改变了我的生活。”所有这些都让人非常有成就感。我要说的第一点是：给你的社区时间，让它以一种感觉有机的方式成长。因为讽刺的是（说完这个我就不啰嗦了），如果你增长到比如 5000 个大使，在网站上说出来感觉很好，但实际的对话会变得非常沉寂。我认为这是因为人们觉得每当他们说话时，就像是在对着一个大礼堂演讲。你不再能感觉到谁在和你在一起。所以，帮助消除这些顾虑是一个好的做法。

---

### [00:44:57] Lenny

**English:**
I've seen the same thing with the growth rate being really important with my newsletter Slack community. I think most listeners probably know this, but if you're a paid newsletter subscriber, you get access to the Slack community. There's about 10,000 people in there. And I find the filter of people that are willing to pay for content like a newsletter is a really good filter for awesome people. And so it ends up slowing growth in a really healthy way and then just creating this filter of the people that really want to self-improve and value the sort of thing join, and it becomes a really amazing group of people.

**中文翻译:**
我在我的时事通讯 Slack 社区也看到了同样的情况，增长率非常重要。我想大多数听众可能都知道，如果你是付费订阅者，就可以加入 Slack 社区。那里大约有 1 万人。我发现，愿意为时事通讯这类内容付费的人，本身就是对优秀人才的一个很好的筛选。所以它最终以一种非常健康的方式减缓了增长，并创造了一个筛选机制，让那些真正想要自我提升、重视这类事物的人加入，从而形成了一个非常了不起的群体。

---

### [00:45:31] Camille Ricketts

**English:**
Yeah. It feels like such a ... I don't know. There's an emotional quality to it I think when that's the case. And all of those people end up being so incredibly impactful. The last point I'll make about community at Notion is that a lot of those people, and we actually ended up launching I think a channel for folks who wanted to do this in particular, but run communities external to Notion's actual owned communities. So you end up with Facebook groups that have ... I think Notion in Vietnam has like 250,000 members. Or the subreddit, which I now know has 210,000 people in the Notion subreddit. And those are all run and moderated by community members who just love running their own communities.

**中文翻译:**
是的。感觉就像……我不知道，当情况是这样时，它有一种情感特质。所有这些人最终都变得非常有影响力。关于 Notion 社区我要说的最后一点是，很多人（我们最终甚至为想做这件事的人专门开设了一个频道）在 Notion 官方拥有的社区之外运行社区。所以你会看到拥有 25 万成员的越南 Notion Facebook 小组，或者现在拥有 21 万人的 Notion Subreddit。这些全部由那些热爱运行自己社区的成员来管理和主持。

---

### [00:46:14] Lenny

**English:**
I feel like you've achieved your OKRs of ubiquity of Notion.

**中文翻译:**
我觉得你已经实现了 Notion 普及化的 OKR。

---

### [00:46:19] Camille Ricketts

**English:**
Yes. It was always a value at Notion to make sure that we were reaching as many people as possible.

**中文翻译:**
是的。确保我们触达尽可能多的人一直是 Notion 的价值观。

---

### [00:46:26] Lenny

**English:**
It's working. One tactical question. Where does the own community of Notion live? Is it a Slack? Is it an online thing you've built yourself?

**中文翻译:**
它奏效了。一个战术性问题：Notion 自己的社区在哪里？是在 Slack 上吗？还是你们自己构建的在线平台？

---

### [00:46:34] Camille Ricketts

**English:**
It is in Slack. And the thinking there, and it still is, was that we really just wanted to be in the course of people's everyday lives. We didn't want to be this other destination that you would have to make a point to going to every day.

**中文翻译:**
在 Slack 上。当时的考虑（现在依然如此）是，我们真心希望融入人们的日常生活。我们不想成为另一个你每天必须特意去访问的目的地。

---

### [00:46:45] Lenny

**English:**
That's exactly how I thought about it with my newsletter Slack community. PMs and founders, they're already in Slack all day. And just that badge, being on the app telling them there's something to check is such a powerful feature versus download a whole new app or go to a whole new website, you're never going to go there. It has to be 10 times better to pull you to a whole new site and change your habits.

**中文翻译:**
这正是我对我的时事通讯 Slack 社区的看法。产品经理和创始人整天都在 Slack 里。那个应用图标上的红点提醒他们有东西要查看，这是一个非常强大的功能。相比之下，下载一个全新的应用或去一个全新的网站，你永远不会去。必须好上 10 倍才能把你拉到一个全新的网站并改变你的习惯。

---

### [00:47:05] Camille Ricketts

**English:**
I absolutely agree.

**中文翻译:**
我完全同意。

---

### [00:47:07] Lenny

**English:**
I'm glad we're all on Slack. Slack's so underrated. I feel like people hate on Slack all the time, but it's such a good product.

**中文翻译:**
我很高兴我们都在 Slack 上。Slack 被严重低估了。我觉得人们总是在吐槽 Slack，但它真的是个好产品。

---

### [00:47:14] Camille Ricketts

**English:**
We all love it. It's just becomes something we take for granted in the background there.

**中文翻译:**
我们都爱它。它只是成了我们在后台习以为常的东西。

---

### [00:47:17] Lenny

**English:**
Yeah, exactly. Okay. This is a good time to shift to our second topic, which is around content and content marketing. So you started the First Round Review at First Round?

**中文翻译:**
没错。好的，现在是转向第二个话题的好时机，即内容和内容营销。你在 First Round 创办了《First Round Review》？

---

### [00:47:26] Camille Ricketts

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:47:27] Lenny

**English:**
I don't know if you know this, but First Round Review was a big part of my early trajectory with this newsletter life. I did a guest post in the First Round Review and that was-

**中文翻译:**
我不知道你是否知道，但在我开启时事通讯生涯的早期轨迹中，《First Round Review》占据了很大一部分。我在上面发过一篇客座文章，那是——

---

### [00:47:37] Camille Ricketts

**English:**
I remember this.

**中文翻译:**
我记得这件事。

---

### [00:47:38] Lenny

**English:**
That was a huge deal for me. That was my first 500 subscribers to my newsletter.

**中文翻译:**
那对我来说是一件大事。那为我的时事通讯带来了最初的 500 个订阅者。

---

### [00:47:42] Camille Ricketts

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:47:44] Lenny

**English:**
Then I did another guest post down the road, but that was not as important. It was a big part of my early path down this life. And so thank you for creating that platform. I was very honored to be involved.

**中文翻译:**
后来我又发了一篇，但那篇没那么重要了。它是我早期职业生涯的重要组成部分。所以，感谢你创建了那个平台。我很荣幸能参与其中。

---

### [00:47:57] Camille Ricketts

**English:**
That's fantastic to hear and exactly what we wanted to have happen. Just extraordinary operators being given a platform and then using it to do whatever it is that they wanted to do. That was part of the dream always.

**中文翻译:**
听到这个太棒了，这正是我们希望看到的。让非凡的运营者获得一个平台，然后利用它去做他们想做的任何事情。这一直是梦想的一部分。

---

### [00:48:10] Lenny

**English:**
It's working.

**中文翻译:**
它奏效了。

---

### [00:48:11] Camille Ricketts

**English:**
Yeah. I'm thrilled because now people are learning so much from you.

**中文翻译:**
是的。我很激动，因为现在人们从你身上学到了这么多。

---

### [00:48:14] Lenny

**English:**
Yeah. It's an inspiration for where when I started too, just I wish I could be as good as the First Round Review and the stuff just keeps coming and coming. It's amazing. And I know other folks run it now. I don't know if they want to be named. They like to be behind the scenes.

**中文翻译:**
是的。当我开始时，它也是我的灵感来源，我当时想：我希望我能做得像《First Round Review》一样好。而且内容源源不断，太神奇了。我知道现在有其他人在负责，我不知道他们是否想被提及，他们喜欢在幕后。

---

### [00:48:27] Camille Ricketts

**English:**
They do, but I'm going to shout out them anyway because they do such an extraordinary job. I mean, Jessi Craige Shikman over there has been doing this now for longer than I did and she is absolutely incredible and her team is extraordinary and I don't miss it every single time it comes out.

**中文翻译:**
他们确实如此，但我还是要公开赞扬他们，因为他们做得太出色了。我是说，那里的 Jessi Craige Shikman 做这件事的时间已经比我长了，她绝对不可思议，她的团队也非常出色，每一期内容我都不会错过。

---

### [00:48:44] Lenny

**English:**
Yeah. I tried to thank her my post. She's like, "Don't mention that. I'm behind the scenes."

**中文翻译:**
是的。我曾在我的文章里试着感谢她，她说：“别提那个，我在幕后。”

---

### [00:48:44] Camille Ricketts

**English:**
Maybe I'll ask her.

**中文翻译:**
也许我会问问她。

---

### [00:48:53] Lenny

**English:**
We have to give her some cred somehow.

**中文翻译:**
我们总得想办法给她一些认可。

---

### [00:48:56] Camille Ricketts

**English:**
Yeah, absolutely. She deserves it.

**中文翻译:**
是的，绝对的。她当之无愧。

---

### [00:48:58] Lenny

**English:**
So kind of zooming out, content marketing, maybe just to give some examples of just what are some of the most impactful things you've been a part of that come from creating content? Whether it's Notion, First Round, anywhere else, what are some examples?

**中文翻译:**
那么放大来看，内容营销，你能举一些例子吗？在你参与过的事情中，有哪些是通过创造内容产生的最具影响力的成果？无论是 Notion、First Round 还是其他地方。

---

### [00:49:11] Camille Ricketts

**English:**
Yeah, I'll give a few examples. Obviously First Round is a huge example and so I'd be remiss in not going into some detail there. And truly that was a team effort from the very beginning. I joined in 2013 and again, I was just so fortunate to work with a leader who believed in it from the very beginning. Josh Kopelman, who's the partner there who was just a massive supporter of mine. Phin Barnes on the partnership team. But then particularly Brett Burson who was running the platform team, which is where all of these value added services lived. So it was me and an events person and the talent person and Brett just gave us all of the runway and all of the belief and support that we needed. And he was really bullish on content and really helped from the beginning, connecting me with incredible interview subjects. Because this whole thing, the only reason I think it survived and did as well as it did is that we were able to land a few really big names at the very beginning. And then of course that helps you down the road whenever you're trying to convince anyone else to do it because you say so and so and so and so have already been featured. So that was I think just a big point of confidence and also tactically, for anyone out there thinking about it, if they can leverage whatever connections they have in that vein.

**中文翻译:**
好的，我举几个例子。显然 First Round 是一个巨大的例子，如果不详细说一下就是我的失职。这从一开始就是团队努力的结果。我 2013 年加入，再次强调，我非常幸运能与一位从一开始就相信这件事的领导者合作。Josh Kopelman 是那里的合伙人，他一直非常支持我。还有合伙团队的 Phin Barnes。但特别要提的是负责平台团队的 Brett Burson，所有的增值服务都在那个团队。当时只有我、一个负责活动的人和一个负责人力资源的人，Brett 给了我们所需的全部空间、信任和支持。他非常看好内容，从一开始就帮我联系了非常棒的采访对象。因为我认为这件事之所以能生存下来并取得成功，唯一的理由就是我们在最开始就搞定了一些非常有影响力的大人物。当然，这在以后你想说服其他人参与时会很有帮助，因为你可以说某某和某某已经上过我们的节目了。我认为那是信心的重要来源，而且从战术上讲，对于任何考虑做内容的人来说，如果能利用这方面的任何关系，都会非常有帮助。

---

### [00:50:27] Lenny

**English:**
I was at dinner with Brett yesterday.

**中文翻译:**
我昨天刚和 Brett 一起吃过晚饭。

---

### [00:50:29] Camille Ricketts

**English:**
Oh my god. What a guy, right?

**中文翻译:**
噢天哪。他很棒，对吧？

---

### [00:50:31] Lenny

**English:**
First Round event. What a guy. That guy's amazing. I'm a huge fan. He's built an incredible platform and program at First Round.

**中文翻译:**
是在 First Round 的活动上。他太棒了，我是他的超级粉丝。他在 First Round 建立了一个不可思议的平台和项目。

---

### [00:50:39] Camille Ricketts

**English:**
And he's one of the people that I've learned the most from, certainly. But more specific to your question around what the content program was able to do there, certainly discovery of First Round. I think prior to that it was a very successful VC fund, but I think we got in front of all kinds of people, particularly in non-traditional geographies or non-traditional founder types or all of that. People who are inside large companies like Google, Apple, Amazon, whenever we would look at our list of subscribers, we had an disproportionate number of email addresses within those companies that were clearly curious about the startup experience. And I think First Round Review was helpful in moving them more toward that mindset and then them obviously understanding that First Round would be a great first stop for them.

**中文翻译:**
他确实是我学到东西最多的人之一。回到你关于内容项目在那里的作用的问题：首先是让更多人发现了 First Round。我认为在那之前它已经是一个非常成功的风投基金，但内容让我们接触到了各种各样的人，特别是那些非传统地理区域或非传统类型的创始人。还有像谷歌、苹果、亚马逊这样大公司内部的人，每当我们查看订阅名单时，会发现这些公司内部的邮箱地址比例高得惊人，他们显然对初创企业的经历感到好奇。我认为《First Round Review》帮助他们转向了那种思维方式，并让他们明白 First Round 会是他们创业的第一站。

---

### [00:51:23] Lenny

**English:**
What would you say is key to content being valuable? So you're talking about the First Round Review became really effective for people learning about First Round, working with First Round, discovery of First Round, but it's not just with content you just write some stuff and it works. It doesn't work that way. What have you learned about just what do you have to get right? You mentioned have names people recognize. Is there anything else you've learned over the years of just like, here's what we need to get right if you're trying to use content as a way to create discovery and awareness of your stuff?

**中文翻译:**
你认为内容具有价值的关键是什么？你提到《First Round Review》在让人们了解、合作和发现 First Round 方面非常有效，但内容并不是随便写点东西就能奏效的。你学到了哪些必须做对的事情？你提到了要有知名度高的名字。这些年来你还学到了什么？如果你想利用内容来创造发现和知名度，有哪些核心要素？

---

### [00:51:54] Camille Ricketts

**English:**
This is something that I think we chatted about briefly, but the way that you think about product market fit, you have to think about content market fit. So even though content feels like it's running adjacent to the actual product that you're putting out there, you still have to think about who is my audience? Who is the audience that I really want to have? Who is the audience that is going to be drawn to this most? Who are they? What is it that they really need in their lives? Even abstracting content from it at all. What is it that they need to get promoted? What is it that they need to avoid failure? What is it that causes them a great deal of anxiety in the day-to-day of their lives or their work? And can you create some type of content product that is going to address this for them and is actually going to have that value? So I think approaching content the way that you would a product in a lot of ways is very instructive way to sort of start hashing out your strategy. Starting with your audience, understanding their big needs. You've heard this, I'm sure, and most of your audience has, but there's the vitamin versus painkiller dichotomy. And painkillers always win. So can your content be a painkiller? Can it help people out of situations that are causing them a lot of pain? Can it help people stop being so confused or can it make them even feel less alone in their experience? That was a big one for First Round Review is helping operators share failures or suboptimal situations in the spirit of helping many other people feel like that was normalized and that the experiences they were having weren't as dire as maybe they had thought.

**中文翻译:**
这是我们简短聊过的话题：就像你思考产品市场契合度一样，你也必须思考“内容市场契合度”。虽然内容看起来与实际产品并行，但你仍需思考：我的受众是谁？我真正想要的受众是谁？谁最容易被吸引？他们是什么样的人？他们在生活中真正需要什么？甚至完全抛开内容去想：他们需要什么来获得晋升？需要什么来避免失败？在日常工作生活中，什么让他们感到极度焦虑？你是否能创造出某种内容产品来解决这些问题，并真正产生价值？所以我认为，像对待产品一样对待内容，在很多方面都是制定策略的极佳方式。从受众开始，了解他们的核心需求。你肯定听过，大多数听众也听过“维生素 vs 止痛药”的二分法。止痛药总是胜出。那么你的内容能成为止痛药吗？它能帮助人们摆脱痛苦的境地吗？能帮助人们不再困惑，或者让他们在经历中感到不再孤单吗？《First Round Review》的一个重点就是帮助运营者分享失败或不理想的情况，本着帮助更多人感到这些是正常的，让他们觉得自己的处境也许并没有想象中那么糟糕。

---

### [00:53:27] Lenny

**English:**
I love that. It connects so much with the way I think about writing. I use the jobs to be done framework a little bit here where I'm just like, what job am I doing when I'm writing a post? And you tell me if this makes sense to you, but I feel like there's four jobs to be done of a newsletter. Either how people make money. There's newsletters, here's how to invest, here's how to buy Bitcoin and win. How people make money. Entertain people. There's a lot of funny things, memes and cartoons and things like that. How people get better at their work or life, which is the category we're in. And then inform people. Like news.

**中文翻译:**
我喜欢这个观点。这与我思考写作的方式非常契合。我在这里稍微借用了“待办任务”（Jobs to be Done）框架，我会想：当我写一篇文章时，我是在完成什么任务？你看看这是否有道理，我觉得时事通讯有四个核心任务：一是教人如何赚钱（比如投资建议、如何买比特币获利）；二是娱乐大众（比如搞笑内容、表情包、漫画）；三是教人如何在工作或生活中变得更好（这就是我们所在的类别）；四是告知信息（比如新闻）。

---

### [00:54:02] Camille Ricketts

**English:**
Yes. What they didn't know before. Yeah.

**中文翻译:**
是的，告诉他们以前不知道的事情。

---

### [00:54:05] Lenny

**English:**
And it feels like you got to do really well. You got to pick which bucket you're in. And let me know if you can think of any others because these are the four that I always come back to. And then pick your bucket and then it's be the best at that thing in your category. The way I think about it.

**中文翻译:**
感觉你必须做得非常好。你得选好自己在哪个桶里。如果你能想到其他的，请告诉我，因为这是我经常想到的四个。选好你的桶，然后努力成为该类别中做得最好的。这就是我的想法。

---

### [00:54:18] Camille Ricketts

**English:**
I love that listing out of those and also the acknowledgement that there are emotional jobs to be done. That there are not just utilitarian jobs to be done. It's not just, you didn't know this before and now you do, but it's like you felt this way before and now you don't or you do. And I think that that's underestimated. So I love that you called out entertaining people because we're all working in an industry where it's wonderful to interact with some of that sparkle and levity. So I love that approach.

**中文翻译:**
我喜欢你列出的这些，也喜欢你承认存在“情感任务”。不仅仅是功利性的任务（比如“你以前不知道，现在知道了”），还有情感上的（比如“你以前有这种感觉，现在没有了，或者有了”）。我认为这一点被低估了。所以我很喜欢你提到娱乐大众，因为我们都在这个行业工作，能接触到一些闪光点和轻松的内容是很棒的。我非常认同这种方法。

---

### [00:54:45] Lenny

**English:**
And something else that goes unsaid I think in the way you talked about this is just putting in the time to make it really high quality. If you look at a First Round post, how much time would you say goes into in the typical First Round Review post?

**中文翻译:**
还有一点我觉得在你刚才的谈话中没明说，那就是投入时间来保证高质量。如果你看一篇《First Round Review》的文章，你觉得典型的一篇文章需要投入多少时间？

---

### [00:54:58] Camille Ricketts

**English:**
Oh gosh. Here's where I'm going to shout out my writing partner at First Round, Sean Young, who was there with me for most of my time there and he and I would always, always talk about this. But it would take eight hours to just write the thing. And that's after you had done all of the prep work of making sure that your interviewee was feeling really anchored and understanding a topic that you were both really excited about and making sure you were mining all of the tactical gems from that conversation. And then you would start writing and that would be another eight hours. I don't know if that's your experience, but certainly was ours.

**中文翻译:**
噢天哪。这里我要公开赞扬我在 First Round 的写作搭档 Sean Young，他在我大部分时间里都和我在一起，我们总是讨论这个问题。仅仅写出那篇文章就需要 8 个小时。而这还是在你完成了所有准备工作之后——包括确保受访者感到放松、确定一个双方都兴奋的主题，并确保从对话中挖掘出所有的战术精华。然后开始写作，又是 8 个小时。我不知道你的经验如何，但我们当时确实是这样。

---

### [00:55:31] Lenny

**English:**
Yeah, very similar. I don't tie myself, but I feel like the median time to write a post for me is about 10 hours.

**中文翻译:**
是的，非常相似。我没有给自己计时，但我感觉我写一篇文章的中位时间大约是 10 小时。

---

### [00:55:37] Camille Ricketts

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:55:37] Lenny

**English:**
And that's I think the key that a lot of people don't think about. One is they don't have the time, and two, they don't realize they should spend this much time because the bar's so high for content on the internet as we all know. There's so much stuff out there. And so to get above that noise you have to really make it really good and that just takes time. And I find this really strong correlation between the time it takes me to write a post and how well it does. It's very highly correlated. And the advantage folks like say the First Round Review have and I have is I do this and there's a team doing this. And so people that are doing this on the side, it's much harder because they don't have that time.

**中文翻译:**
我认为这是很多人没想到的关键。一是他们没有时间，二是他们没意识到应该花这么多时间，因为正如我们所知，互联网内容的门槛已经非常高了。外面的东西太多了。为了脱颖而出，你必须把它做得非常好，而这需要时间。我发现我写文章所花的时间与文章的表现之间存在极强的相关性。像《First Round Review》和我这样的优势在于，这是我的全职工作，而且有团队在做。对于那些兼职做这件事的人来说，这要困难得多，因为他们没有那个时间。

---

### [00:56:14] Camille Ricketts

**English:**
It is. I end up admiring those people a lot where I'm like, how are you doing this?

**中文翻译:**
确实。我非常钦佩那些人，我会想：你是怎么做到的？

---

### [00:56:18] Lenny

**English:**
Yeah. They're sacrificing something.

**中文翻译:**
是的，他们牺牲了一些东西。

---

### [00:56:19] Camille Ricketts

**English:**
Yeah. But truly, it's a very shared experience with you. And I think that a lot of that was making connections between the information that you had available from these interviews. So not just straight here's what this person said, but how can you draw connections between those things, connect the dots, pull out bigger themes. All of that is really where I think a lot of the time went.

**中文翻译:**
是的。但这确实是与你共有的体验。我认为很多时间都花在了将采访中获得的信息建立联系上。不仅仅是直接记录“这个人说了什么”，而是如何将这些点连接起来，提炼出更大的主题。我认为大部分时间都花在了这上面。

---

### [00:56:43] Lenny

**English:**
So you said you had this content market fit questionnaire that you talked through. You're going to send me a link that we can point people to check it out, right?

**中文翻译:**
你提到过你有一个“内容市场契合度”调查问卷。你会发给我一个链接，好让大家去查看，对吧？

---

### [00:56:51] Camille Ricketts

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:56:51] Lenny

**English:**
Okay, awesome.

**中文翻译:**
太好了。

---

### [00:56:52] Camille Ricketts

**English:**
Absolutely. A lot of it is about getting to know your audience to an almost beleaguered degree.

**中文翻译:**
没问题。其中很大一部分是关于如何深入了解你的受众，甚至到了“纠缠不休”的程度。

---

### [00:56:57] Lenny

**English:**
Which is basically what job will you do for them, like you said. And so that makes sense. Maybe a couple more questions. Something that I've noticed a lot, and this is related to content and just PR and stuff like that. I've noticed a lot of people on Twitter and founders are trying to pitch this idea that you don't need to think about comms and press and PR as much because now you can go direct. You can have a newsletter, you can write, you can tweet, you can LinkedIn. Do you feel like that is where the future is going for founder press and comms and things like that or do you think you still need to have a really strong comms, press, PR org within your company?

**中文翻译:**
这基本上就是你说的“你为他们完成什么任务”。这很有道理。还有几个问题。我注意到很多（这与内容、公关之类有关），Twitter 上很多人和创始人都试图推销这样一种观点：你不需要过多考虑传播、媒体和公关，因为现在你可以直接面对受众。你可以有自己的时事通讯，可以写作，可以发推，可以发 LinkedIn。你觉得这就是创始人媒体和传播的未来趋势吗？还是你认为公司内部仍然需要一个非常强大的传播、媒体和公关组织？

---

### [00:57:36] Camille Ricketts

**English:**
That's a great question because I think that there's been just a lot of change in this space over the last five years and certainly very strong opinions from all over the ecosystem. I'm a big believer in comms. And I don't just say that because I used to be a journalist or I used to work in comms. But I think that there are very few and far between incredible megaphones for what it is that you or your company is doing where you get to reach such a breadth of people with that stamp of credibility and notice. How do you get somebody to say, "Hey, this is really something you should pay attention to."? Obviously I support all of the owned media efforts that are really working and bubbling up. And like I said, influencer I think is going to be a massive shift in how we discover things, but maintaining a wonderful relationship with the press, being straightforward, being that brand that is going to be accessible, I really think that that pays off. And just to give you one example, David Pierce, who I think is one of the best working journalists in tech today, he's at The Verge now. He was covering personal tech for the Wall Street Journal early on at Notion and published a story that said this is the one work-life productivity app that you'll ever need. And that was Notion's big break. Truly, if you look back at the graphs, that made a demonstrable difference. And I've seen that happen time and time again. And one of my other efforts at First Round was helping companies in the portfolio figure out how to DIY comm strategies. And I saw this again and again that the companies that did get stories that really told their mission, it made a big difference for just discovery awareness. The number of people who wanted to be involved with them as candidates, as investors, as customers.

**中文翻译:**
这是一个很好的问题，因为在过去的五年里，这个领域发生了很大变化，整个生态系统中肯定存在非常强烈的不同观点。我是传播学的坚定信徒。我这么说不仅仅是因为我曾是记者或从事过传播工作。但我认为，能为你或你的公司所做的事情提供巨大扩音器的机会寥寥无几，让你能以那种公信力和关注度触及如此广泛的人群。如何让别人说：“嘿，这确实是你应该关注的东西”？显然，我支持所有正在发挥作用的自媒体努力。正如我所说，红人营销将是我们发现事物的巨大转变，但与媒体保持良好的关系、保持坦诚、做一个易于接触的品牌，我真的认为这是有回报的。举个例子：David Pierce，我认为他是当今科技界最优秀的在职记者之一，他现在在 The Verge。在 Notion 早期，他在《华尔街日报》报道个人科技，并发表了一篇报道说“这是你唯一需要的办公生活生产力应用”。那是 Notion 的重大突破。真的，如果你回头看图表，那产生了显著的差异。我一次又一次地看到这种情况发生。我在 First Round 的另一项工作是帮助投资组合中的公司弄清楚如何 DIY 传播策略。我反复看到，那些真正讲好自己使命故事的公司，在发现度和知名度上都有了巨大的提升。无论是想加入他们的应聘者、投资者还是客户的数量都增加了。

---

### [00:59:29] Lenny

**English:**
This gives me a new post idea of just what are the big breaks of companies? What was the moment where they started taking off? Note to self?

**中文翻译:**
这给了我一个新的写作灵感：公司的重大突破是什么？他们开始腾飞的时刻是什么？记在心里。

---

### [00:59:36] Camille Ricketts

**English:**
Yes. The other big thing for the Notion was product hunts. I want to give them-

**中文翻译:**
是的。Notion 的另一个重大突破是 Product Hunt。我想给他们——

---

### [00:59:40] Lenny

**English:**
Oh, okay. So posting on Product Hunt, that was a big deal for Notion.

**中文翻译:**
噢，好的。所以在 Product Hunt 上发布对 Notion 来说是一件大事。

---

### [00:59:44] Camille Ricketts

**English:**
It was. And it remains a big deal. If you go on Product Hunt and you type in Notion, you'll see just how many templates have been able to get noted because of Product Hunt.

**中文翻译:**
是的，而且现在依然很重要。如果你去 Product Hunt 搜索 Notion，你会看到有多少模板因为 Product Hunt 而受到关注。

---

### [00:59:54] Lenny

**English:**
So it's the templates being posted, but then also the launch of Notion on Product Hunt?

**中文翻译:**
所以不仅是模板的发布，还有 Notion 本身在 Product Hunt 上的发布？

---

### [00:59:58] Camille Ricketts

**English:**
Yes. And Notion 2.0. And then whenever we would have a major productized launch.

**中文翻译:**
是的。还有 Notion 2.0，以及每当我们有重大的产品化发布时。

---

### [01:00:05] Lenny

**English:**
Wow, that's awesome. Man, Product Hunt just keeps kicking.

**中文翻译:**
哇，太棒了。伙计，Product Hunt 依然充满活力。

---

### [01:00:07] Camille Ricketts

**English:**
Notion AI very recently for them, which couldn't be more exciting.

**中文翻译:**
最近还有 Notion AI 的发布，非常令人兴奋。

---

### [01:00:11] Lenny

**English:**
I have access to that. I've been playing around. It's awesome. Maybe a last question along these lines is thinking about the founders that you've worked with. So on the one hand you have Elon who is very direct on Twitter to his audience, and then Ivan feels much less so and more under the radar and doesn't love tweeting a lot. And then First Round Review somewhere in the middle. Do you have any thoughts on how much a founder should invest in, say, tweeting and going and communicating direct to folk? Or is it more just whatever the founder is, their personality, just go with that?

**中文翻译:**
我有那个权限，一直在试用，非常棒。关于这方面的最后一个问题，是关于你合作过的创始人。一方面，埃隆在 Twitter 上与受众非常直接地交流；另一方面，Ivan 感觉低调得多，不喜欢发推。First Round Review 介于两者之间。你对于创始人应该在发推和直接与人沟通上投入多少精力有什么看法？还是说这取决于创始人的性格，顺其自然就好？

---

### [01:00:41] Camille Ricketts

**English:**
I really do think it's about personality and what feels authentic. I think that so much of a founder's strength comes from leaning into where they know that they love to work, what they know about themselves. And I think that one of the biggest mistakes you can make on social media is giving yourself a quota that you have to hit and say, I have to say X number of scintillating things every week on these platforms. We've just seen so much more traction, even from the main Notion accounts when we're a little bit more reserved and we wait until we have something to say that has value.

**中文翻译:**
我真的认为这取决于性格以及什么感觉是真实的。我认为创始人的很多力量来自于专注于他们热爱的工作领域和对自我的认知。我认为在社交媒体上能犯的最大错误之一就是给自己设定配额，说“我每周必须在这些平台上说出多少句精彩的话”。我们发现，即使是 Notion 的官方账号，当我们稍微克制一点，等到有真正有价值的话要说时，反而能获得更多的关注。

---

### [01:01:12] Lenny

**English:**
Awesome. Any last closing thoughts before we get to our very exciting lightning round?

**中文翻译:**
太棒了。在进入我们非常令人兴奋的闪电轮环节之前，还有什么最后的总结吗？

---

### [01:01:19] Camille Ricketts

**English:**
Closing thoughts. No, this was a wonderful conversation. Thank you so much for letting me share. Truly, I also want to make sure I'm giving a lot of credit away from all the people that I mentioned throughout. It was all just a major team effort and I've gotten very, very lucky to work with the best people.

**中文翻译:**
总结的话，没有了，这是一次美妙的对话。非常感谢让我分享。真的，我也想确保把功劳归于我提到的所有人。这完全是一个重大的团队努力，我非常非常幸运能与最优秀的人共事。

---

### [01:01:32] Lenny

**English:**
Awesome. We'll try to link to all of the people you mentioned in our show notes. We try to do that every time. So it'll be a long show notes. And we're not done yet. We've reached our very exciting lightning round. I am going to ask you six questions real quick. Whatever comes to mind, we'll go through it pretty fast. That sound good?

**中文翻译:**
太棒了。我们会尝试在节目笔记中链接你提到的所有人。我们每次都这样做，所以笔记会很长。我们还没结束，现在进入闪电轮环节。我会快速问你六个问题，想到什么就说什么，我们会进行得很快。准备好了吗？

---

### [01:01:48] Camille Ricketts

**English:**
Yeah. We'll see how it goes.

**中文翻译:**
好的，看看表现如何。

---

### [01:01:50] Lenny

**English:**
Let's go. No pressure. What are two to three books that you recommend most, that you've recommended most to other people?

**中文翻译:**
开始吧，没压力。你最推荐、或者向别人推荐最多的两三本书是什么？

---

### [01:01:57] Camille Ricketts

**English:**
Obviously Awesome by April Dunford. If you're looking to position your company, I don't know if you've read it, but it is a step-by-step guide. It's like 100 pages long.

**中文翻译:**
April Dunford 的《显然很棒》（Obviously Awesome）。如果你正在寻找公司定位，我不知道你读过没，它是一本分步指南，只有 100 页左右。

---

### [01:02:05] Lenny

**English:**
I've read it. She's done a guest post on my newsletter. She's been on the podcast. So all over it.

**中文翻译:**
我读过。她在我的时事通讯上发过客座文章，也上过这个播客。非常熟悉。

---

### [01:02:11] Camille Ricketts

**English:**
Oh, fantastic. She's incredible. Yes. Oh gosh. I'm going to have a hard time coming up with two other books that have had that sizable of an impact.

**中文翻译:**
噢，太棒了。她很了不起。是的。噢天哪，我很难再想出另外两本有如此大影响力的书了。

---

### [01:02:19] Lenny

**English:**
We can keep it to one too. It's all good.

**中文翻译:**
一本也可以，没关系。

---

### [01:02:21] Camille Ricketts

**English:**
Can we keep it to one?

**中文翻译:**
可以只说一本吗？

---

### [01:02:22] Lenny

**English:**
Yes. Just the one. All you need. What's a favorite other podcast that you listen to other than the one you're on currently?

**中文翻译:**
可以。就这一本，足够了。除了你现在参加的这个，你最喜欢的其他播客是什么？

---

### [01:02:30] Camille Ricketts

**English:**
I mean, I love your podcast.

**中文翻译:**
我是说，我喜欢你的播客。

---

### [01:02:31] Lenny

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:02:32] Camille Ricketts

**English:**
Harry Stubbings never ceases to amaze me. We've gone on at Notion a couple times and I just really appreciate his approach to mining a lot of incredible information and unexpected stuff.

**中文翻译:**
Harry Stubbings 总是让我感到惊讶。我们在 Notion 时上过几次他的节目，我非常欣赏他挖掘大量不可思议的信息和意想不到的内容的方式。

---

### [01:02:46] Lenny

**English:**
Harry Stubbings is the godfather of this podcast because I did his podcast and at the end of it privately he's like, "Lenny, you need to do a podcast, you idiot. Why are you not doing a podcast?" And that got me over the hump and look at us now. So yeah, huge shout out to Harry.

**中文翻译:**
Harry Stubbings 是这个播客的教父，因为我上过他的节目，结束时他私下对我说：“Lenny，你这个笨蛋，你应该做一个播客。你为什么不做播客？”这让我跨过了那道坎，看看现在的我们。所以，向 Harry 致敬。

---

### [01:03:00] Camille Ricketts

**English:**
I love all of these connections that exists. That's wonderful.

**中文翻译:**
我喜欢这些存在的联系。太棒了。

---

### [01:03:02] Lenny

**English:**
Yeah. Next question. Favorite recent movie or TV show that you've loved?

**中文翻译:**
是的。下一个问题：最近喜欢的电影或电视剧？

---

### [01:03:08] Camille Ricketts

**English:**
Oh gosh. Recent. I went to go see Tar, which I know is going to be not everybody's cup of tea, but it was just incredible to watch this performance from Kate Blanchett. She learned German. She learned how to be a credible conductor of a major symphony orchestra. If you want to see a bravura performance, that's the one to see. And then recent television show I'm watching Fleischman is in Trouble. I love the book and I just think that the detail and texture of that show is super well done.

**中文翻译:**
噢天哪，最近的。我去看过《塔尔》（Tar），我知道这不一定适合每个人的口味，但看凯特·布兰切特的表演简直不可思议。她学了德语，学会了如何成为一名可信的大型交响乐团指挥。如果你想看一场精湛的表演，就看这部。最近看的电视剧是《弗莱斯曼有麻烦了》（Fleishman is in Trouble）。我喜欢原著，我觉得那部剧的细节和质感做得非常好。

---

### [01:03:37] Lenny

**English:**
Awesome. My wife and I have been watching that and it's awesome. Last episode was less exciting, so I'm curious where it all goes, but I'm watching.

**中文翻译:**
太棒了。我和我妻子一直在看，非常棒。上一集没那么精彩，所以我很好奇结局如何，但我一直在追。

---

### [01:03:44] Camille Ricketts

**English:**
Agreeing. But every time Claire Danes is on screen, I'm riveted. Yeah.

**中文翻译:**
同意。但每当克莱尔·丹尼斯出现在屏幕上，我就被吸引住了。

---

### [01:03:50] Lenny

**English:**
Favorite interview question that you like to ask folks, either when you're interviewing at a place, hiring, anything that comes to mind.

**中文翻译:**
你最喜欢的面试问题是什么？无论是你去面试还是招聘别人。

---

### [01:03:56] Camille Ricketts

**English:**
Yeah. The one thing that was really helpful, because we used to do this thing at First Round Review where we would explore topics and be like, how do we get to a topics that's going to be unique or new knowledge or whatever it was. And it was, what is one thing that you think that led to your success that nobody else in your peer set has done? What was something that you did on a lark or that you were like, this is a big bet, or this isn't probably going to work, or it's a mistake that it even turned out this way, but it ended up being great. What is that one thing that was unusually conceived that you want to share with people?

**中文翻译:**
是的。有一件事非常有用，因为我们以前在《First Round Review》会探索主题，思考如何获得独特或新颖的知识。那个问题是：“你认为导致你成功的哪一件事是你的同行中没有人做过的？”有什么事是你心血来潮做的，或者是你觉得“这是一个巨大的赌注”或“这可能行不通”，甚至是阴差阳错发生的，但最终结果却非常好？那件构思奇特、你想与人分享的事情是什么？

---

### [01:04:24] Lenny

**English:**
I love that question. I almost want to answer it, but let's move on. What are five SaaS products that you use or have used other than notion that you found to be really good other than maybe Slack, which everyone always mentions.

**中文翻译:**
我喜欢这个问题。我甚至想回答一下，但我们继续。除了 Notion 和大家总提到的 Slack，你使用过或正在使用的、觉得非常棒的五个 SaaS 产品是什么？

---

### [01:04:39] Camille Ricketts

**English:**
I mean, I'm in love with Notion. The other thing, the other great love of my life right now is Arc, The Browser Company.

**中文翻译:**
我是说，我深爱 Notion。目前我生活中的另一个挚爱是 Arc（浏览器公司）。

---

### [01:04:44] Lenny

**English:**
Oh my God, I love Arc. I just switched to it. I love it.

**中文翻译:**
噢天哪，我也爱 Arc。我刚换成它，非常喜欢。

---

### [01:04:47] Camille Ricketts

**English:**
Yeah. It was something that I tried and within an hour I've made it my default browser and I just think it's beautiful and delightful in one of those intangible ways that a lot of these products are

**中文翻译:**
是的。我试了一下，不到一小时就把它设为了默认浏览器。我觉得它非常漂亮，而且有一种难以言喻的愉悦感，就像很多这类优秀产品一样。

---

### [01:04:58] Lenny

**English:**
Same. Yes. Cool. Oh, there's more. Yeah.

**中文翻译:**
同感。是的，酷。还有吗？

---

### [01:05:00] Camille Ricketts

**English:**
I already talked about Figma. I love Figma. I actually use it in my day to day life, which is one of the best parts of it is that folks who are not necessarily designers or highly technical can also get a lot out of it. Superhuman. Couldn't live my life without Superhuman. Whenever I have to go back into Gmail to set an autoresponder or whatever, I'm like, ugh, my eyes. So couldn't live without that. Gosh, I'm on sabbatical, so I don't know how many other SaaS products I'm actually using day to day so I'm going to keep it at three.

**中文翻译:**
我已经说过 Figma 了。我爱 Figma。我实际上在日常生活中也用它，它最棒的一点是，即使不是设计师或技术高手也能从中获益。还有 Superhuman，没有它我简直没法生活。每当我不得不回到 Gmail 去设置自动回复之类的，我就会觉得“呃，我的眼睛”。所以离不开它。天哪，我正在休假，所以我不知道日常还在用多少其他 SaaS 产品，就先说这三个吧。

---

### [01:05:29] Lenny

**English:**
All right. Yeah. Use less SaaS products during your sabbatical. It's a good philosophy.

**中文翻译:**
好吧。休假期间少用 SaaS 产品，这是一个很好的哲学。

---

### [01:05:33] Camille Ricketts

**English:**
Yeah. I don't know if that was your experience, but just is. Oh, the other one I'll shout out, even though this is like a sneaky Notion plug is Kron. So if anybody isn't using the Kron calendar, which is now part of Notion as some folks might know, it is in fact the best calendar product on the market.

**中文翻译:**
是的。噢，我还要再提一个，虽然这有点像在给 Notion 打广告，那就是 Kron。如果有人还没用过 Kron 日历（现在已经是 Notion 的一部分了），它确实是市场上最好的日历产品。

---

### [01:05:47] Lenny

**English:**
Sneaky, sneaky. Last question. What's a favorite read or course or just anything you'd recommend for people to level up their community building skills to build a community, run a community? What would you point people to?

**中文翻译:**
真狡猾。最后一个问题：你最喜欢的读物、课程或任何推荐，可以帮助人们提升社区建设技能、建立或运营社区？你会向人们推荐什么？

---

### [01:06:01] Camille Ricketts

**English:**
I'm not aware of any courses that are necessarily offered. Ben Lang has done a number of AMAs or interviews, so if you want to just Google Ben Lang and the word community or Notion, you're going to find just a lot of incredible insight. And his experience has been, I think ... In terms of community people operating in tech, Ben is top level, so find whatever he's said.

**中文翻译:**
我不知道有什么专门的课程。Ben Lang 做过很多 AMA 或采访，所以如果你去 Google 搜索“Ben Lang”加上“community”或“Notion”，你会发现很多不可思议的见解。我认为在科技行业的社区运营人员中，Ben 是顶级的，所以去找找他说过的话。

---

### [01:06:27] Lenny

**English:**
Awesome. We will find it. We will link to it. Camille, I just met you an hour ago, but I feel like I've known you forever. This was amazing.

**中文翻译:**
太棒了。我们会找到并链接它的。Camille，我一小时前才认识你，但感觉像认识了很久。这太棒了。

---

### [01:06:34] Camille Ricketts

**English:**
Likewise. Thank you.

**中文翻译:**
我也是。谢谢。

---

### [01:06:35] Lenny

**English:**
Thank you so much for making time for this. Two last questions. Where can folks find you online if they want to reach out, learn more? You're on sabbatical now, and so maybe share what you're thinking about next and what you could be ... I don't know. And I guess this is the second question. How can listeners be useful to you?

**中文翻译:**
非常感谢你抽时间参加。最后两个问题：如果大家想联系你或了解更多，可以在哪里找到你？你现在正在休假，也许可以分享一下你接下来的打算。还有，听众能为你提供什么帮助？

---

### [01:06:49] Camille Ricketts

**English:**
Thank you for that. You can find me on Twitter. I'm just @CamilleRicketts. Super straightforward. Still sticking with it. And in terms of where I'm at in my life, I'm just interested in meeting as many fascinating new people and learning about things as possible. I've started going to these Founders You Should Know events for anybody who's interested about FYSK, and just meeting as many cool people who are building just incredible concepts. It's inspiring every time, and I just want my whole life to look like that. So get in touch if you're building something and think I could be helpful.

**中文翻译:**
谢谢。你可以在 Twitter 上找到我，账号是 @CamilleRicketts，非常直接。至于我目前的生活状态，我只是想尽可能多地结识迷人的新人并学习新事物。我开始参加“你应该认识的创始人”（Founders You Should Know，简称 FYSK）活动，结识了很多正在构建不可思议概念的酷人。每次都深受启发，我希望我的生活一直如此。所以，如果你正在构建什么东西并认为我可以提供帮助，请联系我。

---

### [01:07:21] Lenny

**English:**
Amazing. Camille, thank you so much for being here.

**中文翻译:**
太棒了。Camille，非常感谢你能来。

---

### [01:07:24] Camille Ricketts

**English:**
Thank you so much. This was wonderful.

**中文翻译:**
非常感谢。这次谈话很愉快。

---

### [01:07:27] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。