# Carilu Dietrich - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Carilu Dietrich.

---

### [00:00:00] [Carilu Dietrich]

**English:**
In order to get hypergrowth, you have to have organic, inbound, and viral word of mouth. You can't pay enough to grow at those rates and have a viable company. The biggest thing is an amazing product that people love to use, right? I mean ChatGPT is the most hypergrowth product that we've seen in history potentially, because people are so excited to use it and it's working in interesting ways.
And then I think the third thing is really riding the lightning, I would call it. Hypergrowth companies go through the stages of growth that would take other companies five years or 10 years, right? They're going from 10 to 50, they're going from 50 to 100, they're going from 100 to 200. They're jumping. And so they really need to keep hiring 2X and 3X leaders who have seen the next stage of growth, because it's going to be here before you know it.

**中文翻译:**
为了实现高速增长（Hypergrowth），你必须拥有有机增长、入境营销（Inbound）和病毒式的口碑。你不可能通过砸钱买到这种增长速度，同时还能维持公司的生存。最核心的一点是拥有一款人们爱不释手的产品，对吧？我的意思是，ChatGPT 可能是我们历史上见过的增长最快的产品，因为人们非常兴奋地去使用它，而且它以一种非常有趣的方式在运作。
我认为第三点是“驾驭闪电”（Riding the lightning）。高速增长的公司所经历的成长阶段，其他公司可能需要 5 年或 10 年才能完成。他们从 10 跨越到 50，从 50 到 100，从 100 到 200。他们在跳跃式前进。因此，他们真的需要不断聘请那些经历过下一阶段增长的“2倍速”或“3倍速”领导者，因为那个阶段转眼就会到来。

---

### [00:00:55] [Lenny]

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard work, experiences building and growing today's most successful products.
Today my guest is Carilu Dietrich. Carilu is a former CMO and has advised the CEOs and CMOs of hypergrowth B2B companies like Segment, Miro, 1Password, Bill.com, Productboard, Sprout Social, Weights & Biases, and most notably was head of marketing at Atlassian through their IPO.
In today's episode, we cover what hypergrowth companies have in common, how to make big changes to your growth strategy to unlock new channels of growth, why COs don't trust CMOs, and why most CMOs get fired. Also, why most CPOs get fired. Plus, the benefits of waiting a long time to hire your first salesperson, bundling strategy, and a ton of incredibly insightful career advice. A huge thank you to Elena Verna for suggesting Carilu for the podcast. And with that, I bring you Carilu Dietrich after a short word from our sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们构建和增长当今最成功产品的辛勤工作与实战经验。
今天的嘉宾是 Carilu Dietrich。Carilu 曾任首席营销官（CMO），并为 Segment、Miro、1Password、Bill.com、Productboard、Sprout Social、Weights & Biases 等高速增长的 B2B 公司的 CEO 和 CMO 提供咨询。最著名的是，她在 Atlassian 整个 IPO 期间担任营销负责人。
在今天的节目中，我们将探讨高速增长公司的共同点、如何对增长策略做出重大调整以解锁新的增长渠道、为什么 CEO 不信任 CMO，以及为什么大多数 CMO 会被解雇。此外，我们还会聊到为什么大多数 CPO（首席产品官）也会被解雇。还有，推迟招聘第一名销售人员的好处、捆绑销售策略，以及大量极具洞察力的职业建议。非常感谢 Elena Verna 推荐 Carilu 参加本期播客。在听完赞助商的简短介绍后，我们将为您带来 Carilu Dietrich 的访谈。

---

### [00:01:56] [Lenny]

**English:**
This episode is brought to you by Rows.com. The world runs on spreadsheets. You probably have a tab open with a spreadsheet right now, but the spreadsheet product you're using today was designed decades ago, and it shows. They live in silos away from your business data. They weren't made to be used on a phone. And if you want to do even the simplest automation, you have to figure out complex scripts that are nightmare to maintain.
Rows is different. It combines a modern spreadsheet editor, data integrations with APIs and your business tools, and a slick sharing experience that turns any spreadsheet into a beautiful interactive website that you'll be proud to share. If you're writing a report on a growth experiment, you can use Rows to your analysis on data straight from BigQuery or Snowflake. If you're deep diving on marketing, you can import reports straight from Google Analytics, Facebook Ads, or Twitter. Or if you're working with sales, you can natively plug Stripe, Salesforce, or HubSpot directly into rows. And when you're done, you can share your work as a beautiful spreadsheet that's easy to read, and embed charts, tables, and calculators into Notion, Confluence, or anywhere on the web. I've already moved some of my favorite spreadsheet templates to Rows. Go to rows.com/lenny to check them out. That's rows.com/lenny.

**中文翻译:**
本期节目由 Rows.com 赞助。世界在电子表格上运行。你现在可能就打开了一个电子表格标签页，但你今天使用的电子表格产品是几十年前设计的，这显而易见。它们与你的业务数据隔绝，存在于孤岛中。它们不是为手机设计的。如果你想做最简单的自动化，你必须搞清楚复杂的脚本，而这些脚本的维护简直是噩梦。
Rows 则不同。它结合了现代电子表格编辑器、与 API 及业务工具的数据集成，以及流畅的共享体验，能将任何电子表格变成一个你会自豪地分享的美观交互式网站。如果你正在撰写增长实验报告，你可以使用 Rows 直接对来自 BigQuery 或 Snowflake 的数据进行分析。如果你在深挖营销数据，可以直接从 Google Analytics、Facebook Ads 或 Twitter 导入报告。或者如果你在做销售工作，可以直接将 Stripe、Salesforce 或 HubSpot 原生接入 Rows。完成后，你可以将工作成果分享为易于阅读的美观表格，并将图表、表格和计算器嵌入到 Notion、Confluence 或网页的任何地方。我已经把我最喜欢的一些电子表格模板移到了 Rows。访问 rows.com/lenny 查看，即 rows.com/lenny。

---

### [00:03:08] [Lenny]

**English:**
This episode is brought to you by Braintrust, where the world's most innovative companies go to find talent fast so that they can innovate faster. Let's be honest, it's a lot of work to build a company. And if you want to stay ahead of the game, you need to be able to hire the right talent quickly and confidently. Braintrust is the first decentralized talent network where you can find, hire, and manage high quality contractors in engineering, design, and product, for a fraction of the cost of agencies.
Brain Trust charges a flat rate of only 10%, unlike agency fees of up to 70%. So you can make your budget go four times further. Plus, they're the only network that takes 0% of what the talent makes, so they're able to attract and retain the world's best tech talent. Take it from DoorDash, Airbnb, Plaid, and hundreds of other high growth startups that have shaved their hiring process for months to weeks at less than a quarter of the cost by hiring through Braintrust's network of 20,000 high quality vetted candidates ready to work. Whether you're looking to fill in gaps, upskill your staff, or build a team for that dream project that finally got funded, contact Braintrust and you'll get matched with three candidates in just 48 hours. Visit usebraintrust.com/lenny or find them in my show notes for today's episode. That's used usebraintrust.com/lenny, for when you need talent yesterday.

**中文翻译:**
本期节目由 Braintrust 赞助。全球最具创新精神的公司都在这里快速寻找人才，以便更快地进行创新。坦白说，创建一家公司需要做大量工作。如果你想保持领先，你需要能够快速且自信地聘请到合适的人才。Braintrust 是第一个去中心化的人才网络，你可以在这里找到、聘用并管理工程、设计和产品领域的高质量承包商，而成本仅为传统中介机构的一小部分。
Braintrust 仅收取 10% 的固定费率，而不像中介机构那样收取高达 70% 的费用。因此，你可以让你的预算发挥四倍的作用。此外，他们是唯一一个不从人才收入中抽成的网络，因此他们能够吸引并留住世界上最顶尖的科技人才。DoorDash、Airbnb、Plaid 以及数百家其他高速增长的初创公司都通过 Braintrust 拥有 20,000 名高质量、经过审核且随时待命的候选人网络，将招聘流程从数月缩短至数周，且成本不到四分之一。无论你是想填补空缺、提升员工技能，还是为那个终于获得资金的梦想项目组建团队，联系 Braintrust，你将在 48 小时内匹配到三名候选人。访问 usebraintrust.com/lenny 或在今天的节目笔记中找到他们。当你急需人才时，请访问 usebraintrust.com/lenny。

---

### [00:04:31] [Lenny]

**English:**
Carilu, welcome to the podcast.

**中文翻译:**
Carilu，欢迎来到播客。

---

### [00:04:33] [Carilu Dietrich]

**English:**
Thanks, Lenny. Happy to be here.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。

---

### [00:04:35] [Lenny]

**English:**
You've had this incredible career. You worked at all these incredible companies. I'd love to just dissect what you have found to be most important and effective in building a career long term, just broadly. And then specifically if you're trying to get to an executive role someday, what have you found to be some more important habits, behaviors, tactics, lessons?

**中文翻译:**
你拥有如此精彩的职业生涯，在这么多优秀的公司工作过。我想从宏观上剖析一下，你认为长期职业发展中最重要、最有效的是什么？具体来说，如果某人想在未来晋升到高管职位，你发现有哪些重要的习惯、行为、策略或教训？

---

### [00:04:55] [Carilu Dietrich]

**English:**
I'll start by saying that everyone has their own calculus about the trade-offs they want to make on pursuing their career and the sacrifices they might need to make versus the other things in their life, their family, their hobbies, their passions. And so I think the executive track isn't for everyone because there are a lot of trade-offs.
Because I think that some of the most important aspects of getting to the executive suite are working harder, learning more, pushing yourself, taking on more responsibilities and opportunities, maybe even in the white space, that aren't your job or aren't in your regular time.
When I was young in my career, I decided I wanted to be a CMO. And at the job where I had decided I wanted to be the CMO, I worked two hours later than everyone else on the team. And I had this thought in my brain that two hours every day for five years would get me how many more years of experience than someone else? And I could do that when I was young, and I didn't have kids, and I was willing to make those sacrifices.
But you look at a lot of the top CMOs and they have sacrificed a lot of things to read all of the books. And again, if I go back to that first job, I was a PR manager, and we went through a tough phase and we lost a ahead of product right before the major launch of a major product. So I volunteered to moonlight in the product department and run the beta, and do release engineering. And taking on other responsibilities gave me insights into other departments that made me more successful, early in my career and later on.
And the same thing happens as you're growing, right? If a department head leaves and you can spend extra time doing your own job and being the interim for this other function, you can really show the top executives that you have the appetite and the skill to take on more responsibility.
So I think learning as much as you can about your expertise, working really hard, and taking on more responsibilities, and having a great attitude and a strategic mind are probably what I think helps people get to the C-suite on the personal level. And then I have another set of five things that are what specific ways do you need to train your mind?

**中文翻译:**
首先我想说，每个人对于追求事业所愿意做的权衡，以及相对于生活中的其他事物（家庭、爱好、激情）所需要做的牺牲，都有自己的考量。因此，我认为高管之路并不适合所有人，因为这涉及很多取舍。
因为我认为进入高管层最重要的几个方面是：工作更努力、学习更多、逼自己一把、承担更多的责任和机会，甚至是在那些不属于你职责范围或常规时间的“空白地带”寻找机会。
在我职业生涯早期，我决定要成为一名 CMO。在那个我立志成为 CMO 的岗位上，我每天比团队里的其他人晚下班两小时。我脑子里有个念头：每天多干两小时，坚持五年，我会比别人多出多少年的经验？年轻时我可以这样做，当时没有孩子，我愿意做出这些牺牲。
但你看很多顶尖的 CMO，他们为了读完所有的书牺牲了很多。再回到那第一份工作，我当时是公关经理，我们经历了一个艰难阶段，就在一个重大产品发布前夕，产品负责人离职了。于是我自愿去产品部门“兼职”，负责 Beta 测试和发布工程。承担这些额外职责让我对其他部门有了深刻见解，这让我在职业生涯早期和后期都更加成功。
随着你的成长，同样的事情也会发生，对吧？如果某个部门主管离职了，而你能额外花时间在做好本职工作的同时兼任该职能，你就能向高层展示你有承担更多责任的胃口和能力。
所以，我认为在个人层面，尽可能多地学习专业知识、刻苦工作、承担更多责任、保持良好的态度和战略思维，是帮助人们进入 C-suite（高管层）的关键。除此之外，我还有另外五点关于如何训练思维的具体建议。

---

### [00:07:15] [Lenny]

**English:**
I know there's this backlash against working really hard that happened for a while, but I'm on the same boat as you have of success will come from working really hard. And sometimes that sucks, but that's usually how it goes.

**中文翻译:**
我知道有一段时间人们对“拼命工作”有一种抵触情绪，但我和你持相同观点：成功源于刻苦工作。有时这确实很辛苦，但通常情况就是这样。

---

### [00:07:27] [Carilu Dietrich]

**English:**
I think there's ebbs and flows in your life. You're going to have a baby here soon, congratulations. Thank you. And so maybe you take your foot off the gas for a little bit. But really, there's no shortcuts. There's no shortcuts to knowing a lot.
One of the people I admire most is Tomasz Tunguz, who was with Redpoint and now started his own VC firm. And I was talking to him about his blog and he was like, "I'd just wake up 5:00 or 6:00 AM every morning and write three to four blogs a week for 10 years." Damn. That is self-discipline and insight and drive. So yeah, no shortcuts. I think. You look at Denise Persson at Snowflake, and she's worked really hard to get there.
So the five things I think you need to do to get to the C-suite that are not personal side are you need to think about how your responsibilities tie to revenue. You need to think and talk in the terms of the CEO and the board. And that can be tricky when you're junior because you don't have exposure to it. But getting a strong handle on finance, and how the finances of the business work, and how the revenue of the business works.
I went on a tour of the Tesla factory with my daughter's field trip a couple weeks ago. And the guy who was giving us the tour was like, "So I delivered and stocked all these different parts at the plant and then I would take a list. And after work every night, I'd go to each part of the plant and try to figure out what they were working on and what the challenges and opportunities were. And that's how I moved up."
So it's just understanding how the whole thing works together. Because if you want to be in the C-suite, it's a job about how the system works. So I really encourage tours of duty between different departments. I told you about my tour of duty and product. I thought CMOs had to do every function, so I took a tour of duty in every function in marketing, but really getting a sense for other departments.
The next thing is the relationships. So building really strong relationships with people by doing good work and helping them. And then the last thing I think is the quality of the companies you work for. So your career and your ability to transcend, which is really moving faster than other people to get bigger jobs, is fairly dependent on the momentum of your company.
So I was a leader at Oracle for five years, and my team grew from five to seven over five years. And I was a leader at Atlassian for four years, and my team grew from 15 to 100. And so if you pick the right company with the right momentum, you have a better chance of getting higher level experiences and accelerated career growth.
And then I guess one little footnote. If you pick great companies, great people work for those companies, and go out and work at other companies and also give you opportunities. So I ended up at Atlassian kind of in a stroke of good luck because I had worked for Jay Simons, the president, at two companies before. So the quality of the first company, Plumtree, really helped propel my whole career.

**中文翻译:**
我认为生活中会有起伏。你很快就要有宝宝了，恭喜你。谢谢。所以也许你会暂时松一松油门。但说真的，没有捷径。想要博学多才没有捷径。
我最钦佩的人之一是 Tomasz Tunguz，他曾任职于 Redpoint，现在创办了自己的风投公司。我曾和他聊起他的博客，他说：“我过去 10 年里每天早上 5、6 点起床，每周写三到四篇博客。”天哪，那是极强的自律、洞察力和驱动力。所以是的，没有捷径。你看 Snowflake 的 Denise Persson，她也是靠非常努力的工作才达到今天的高度。
除了个人层面，我认为进入 C-suite 还需要做这五件事：首先，你需要思考你的职责如何与收入挂钩。你需要用 CEO 和董事会的语言去思考和交流。当你还是初级员工时这很难，因为你接触不到。但要努力掌握财务知识，了解业务财务是如何运作的，收入是如何产生的。
几周前我带女儿去特斯拉工厂参观。带我们参观的人说：“我当时在工厂负责运送和存放各种零件，每天下班后，我会拿着清单去工厂的各个区域，试图弄清楚他们在做什么，面临什么挑战和机会。我就是这样晋升的。”
所以，关键在于理解整个系统是如何协同工作的。如果你想进入 C-suite，那是一份关于系统运作的工作。因此，我非常鼓励在不同部门之间进行“轮岗”（Tours of duty）。我告诉过你我在产品部门的轮岗经历。我当时认为 CMO 必须了解每一个职能，所以我轮换了营销部门的每一个岗位，但真正重要的是对其他部门有感觉。
接下来是人际关系。通过出色的工作和帮助他人来建立牢固的关系。最后一点我认为是所服务公司的质量。你的职业生涯和“超越”能力（即比别人更快获得更高职位的潜力）在很大程度上取决于公司的势能（Momentum）。
我在甲骨文（Oracle）做了五年领导，我的团队从 5 人增长到 7 人。而我在 Atlassian 做了四年领导，团队从 15 人增长到 100 人。所以，如果你选对了具有正确势能的公司，你就有更好的机会获得高层经验并加速职业成长。
最后补充一点：如果你选择了优秀的公司，优秀的人才也会在那里工作，他们以后去其他公司也会为你提供机会。我之所以能去 Atlassian，某种程度上是运气好，因为我之前在两家公司都曾为当时的总裁 Jay Simons 工作过。所以第一家公司 Plumtree 的质量真的推动了我整个职业生涯。

---

### [00:10:40] [Lenny]

**English:**
There's so many things I want to double click on there. The last piece, it's the advice I always give people when they're early in their career is to go find a company that's going to do super well. That one experience is going to transform your entire career. Having the logo on your resume, the people you meet, the experience you get financially. But that begs the question, how do you find that? How do you pick a company? I think in your advising today, you join later where it's a little more obvious. "Okay, they're doing great." Do you have any advice or lessons about how to identify earlier where to go work and how to be lucky in that pick?

**中文翻译:**
这里有很多我想深入探讨的点。关于最后一点，我总是建议职业生涯早期的人去找一家发展前景极好的公司。那一段经历会改变你的整个职业生涯。简历上的公司 Logo、你遇到的人、你获得的财务回报。但问题是，如何找到这样的公司？如何挑选公司？我想在你现在的咨询工作中，你加入时公司已经比较成熟，表现已经很明显了。你有没有什么建议或教训，教大家如何更早地识别出值得加入的公司，并在这场选择中获得好运？

---

### [00:11:16] [Carilu Dietrich]

**English:**
Isn't that the billion-dollar question? So I worked for-

**中文翻译:**
这不就是那个价值十亿美元的问题吗？我曾为……

---

### [00:11:20] [Lenny]

**English:**
For investing too.

**中文翻译:**
对投资来说也是。

---

### [00:11:20] [Carilu Dietrich]

**English:**
Yeah. I worked at Atlassian, which was phenomenal. Then I worked for Classy, which was a company that helped nonprofits raise money.

**中文翻译:**
是的。我在 Atlassian 工作过，那段经历非常棒。后来我在 Classy 工作，那是一家帮助非营利组织筹款的公司。

---

### [00:11:29] [Lenny]

**English:**
I've used that product.

**中文翻译:**
我用过那个产品。

---

### [00:11:31] [Carilu Dietrich]

**English:**
Thank you. And we were acquired by GoFundMe. And it was fine, but it was no Atlassian. And then I spent the next five years trying to figure out, how do you pick your next Atlassian? So my advice would be for people earlier in their careers, it's easy to pick the winners if you go work for a big company that's a winner. I would love to work for Tesla, or AWS. Or right this second, I would die kill for a job at OpenAI. You know some of the big companies that are successful... Salesforce has totally been a career maker to so many top executives.
Early in your career, working for big name high momentum companies. I think you can't wimp out. You've got to want it and go for it. And maybe you apply year after year, and you meet people, and you try for it early in your company.
Later in your career, I think what you just said, picking later stage versus earlier stage gives you a better view of their momentum. I actually have a Post-it note, got it here, about what I look for. 10 parts of what would evaluate to see-

**中文翻译:**
谢谢。后来我们被 GoFundMe 收购了。那段经历还不错，但远不及 Atlassian。接下来的五年里，我一直在思考：如何挑选你的下一个 Atlassian？对于职业生涯早期的人，我的建议是：如果你去一家已经是赢家的大公司工作，挑选赢家就很容易。我很想去特斯拉或 AWS 工作。或者就在这一秒，我愿意为了 OpenAI 的一份工作拼命。你知道那些成功的大公司……Salesforce 绝对成就了许多顶尖高管的职业生涯。
在职业生涯早期，去那些名气大、势头猛的公司工作。我认为你不能退缩，你必须渴望它并去争取。也许你一年又一年地申请，去结识那里的人，在公司早期就去尝试。
在职业生涯后期，就像你刚才说的，选择后期阶段而非早期阶段的公司能让你更清楚地看到它们的势能。我其实有一张便利贴，就在这儿，上面写着我关注的指标。评估一家公司是否优秀的 10 个维度……

---

### [00:12:35] [Lenny]

**English:**
You just have that Post-it note around?

**中文翻译:**
你就随身带着那张便利贴？

---

### [00:12:37] [Carilu Dietrich]

**English:**
I do. It's one of five Post-it notes on my board.

**中文翻译:**
是的，这是我板子上的五张便利贴之一。

---

### [00:12:37] [Lenny]

**English:**
I want to hear what the rest are too. But keep going.

**中文翻译:**
我也想听听其他的写了什么。不过请继续。

---

### [00:12:44] [Carilu Dietrich]

**English:**
I have to look at it for advisory. I only take eight to 10 clients. I'm always full. And so it has to be a phenomenal company. So how do I know if it's a phenomenal company? Here's my list. Rule of 40, which is your profitability and your costs together. The quality of the investors. Are they really top tier investors? Are they mid tier or some you've never heard of? Investors do a lot of due diligence, but you also want to look at their most recent rounds, because they could have phenomenal early stage and have slowed down. I think the later the size, the more reliable, because they've just made it farther.
Their Net Promoter Score or their customer satisfaction. Do people really rapidly love this product or is it like meh? Their net dollar retention, which is, how fast is their revenue growing? And I should have it on my Post-it note, but Snowflake was the benchmark. I think they were growing at 142%.

**中文翻译:**
做咨询时我得看着它。我只接 8 到 10 个客户，名额总是满的。所以那必须是一家非凡的公司。我怎么知道它是否非凡？这是我的清单：
1. **40原则（Rule of 40）**：即增长率和利润率之和。
2. **投资者的质量**：他们是顶级投资者吗？还是中游，或者你从未听说过的？投资者会做大量尽职调查，但你也要看他们最近几轮的表现，因为有些公司早期表现惊人但后来放缓了。我认为规模越大越可靠，因为他们走得更远。
3. **净推荐值（NPS）或客户满意度**：人们是真的疯狂热爱这款产品，还是觉得一般般？
4. **净金额留存率（NDR）**：这代表收入增长有多快。我便利贴上应该写着，Snowflake 曾是基准，我记得他们的 NDR 增长率曾达到 142%。

---

### [00:13:44] [Lenny]

**English:**
I think at one point it was 180, whatever.

**中文翻译:**
我记得一度达到过 180%，不管怎样。

---

### [00:13:46] [Carilu Dietrich]

**English:**
Yeah. That sounds right. 180, 165. Net dollar retention, if you have a customer and they just renew at the same dollar rate, it would be 100. So 180 is almost doubling just their customers. So they didn't even need new customers, almost doubled their business. A phenomenal net dollar retention means it's a really strong healthy business.
I looked at their growth rate last year, their burn rate, are they going to run out of money? And then ideally, are they number one in their market? Do they have a Forrester or a Gartner Magic Quadrant? People tell you if they're number one.
And then the last thing is I look at their Glassdoor. Is it just a bad place to work and where people unhappy? Because they don't actually survive as long as companies where people are happier.

**中文翻译:**
是的，听起来没错。180，165。净金额留存率（NDR）如果是 100，意味着老客户续约金额没变。所以 180 意味着仅靠老客户就几乎实现了翻倍。他们甚至不需要新客户，业务就翻了一番。惊人的 NDR 意味着业务非常强劲健康。
5. **去年的增长率**。
6. **烧钱率（Burn rate）**：他们会耗尽资金吗？
7. **市场地位**：理想情况下，他们是市场第一吗？他们是否进入了 Forrester 或 Gartner 的魔力象限？人们会告诉你他们是不是第一。
8. **Glassdoor 评价**：最后我会看 Glassdoor。那里是不是一个工作环境很差、员工不开心的地方？因为员工不快乐的公司通常活得不如那些员工快乐的公司长久。

---

### [00:14:34] [Lenny]

**English:**
I love this list. You should turn it into a blog post, and there's another idea for you. Can you share what the other Post-its are around you? Even broadly.

**中文翻译:**
我太喜欢这个清单了。你应该把它写成博客文章，这是给你的另一个建议。你能分享一下你周围其他便利贴的内容吗？大概说说也行。

---

### [00:14:41] [Carilu Dietrich]

**English:**
I can. One says, "More Yoda, less Wonder Woman," which basically is ask better questions. The second one was-

**中文翻译:**
可以。一张写着：“多学尤达（Yoda），少学神奇女侠（Wonder Woman）”，基本上就是说要提出更好的问题。第二张是……

---

### [00:14:51] [Lenny]

**English:**
Ask them backwards too.

**中文翻译:**
还要倒着问。

---

### [00:14:52] [Carilu Dietrich]

**English:**
Yeah, right? Ask them backwards. Which is funny, because the other Yoda thing I have up Is... Here wait. "Do or do not. There is no try." Backwards. I have another one that says, "Hell yes or no." When opportunities come to you and you're like, "Should I do this or should I not do this?" You only have so much time in your life. And so if it's not something that really excites you and gives you energy, it's tough to be the best at it. And so hell yes or no.
And then the last one is, "Worrying is wasted energy," because I think we live in this economic pressure cooker, and there's a lot of fear and uncertainty. But we just need to take that fear and uncertainty and thank it for giving us urgency. And then make the list of what can we control now and what should we do next.

**中文翻译:**
没错，倒着问。这很有趣，因为我贴的另一条尤达名言是……等一下，“做，或者不做。没有‘试一试’。” 还有一张写着：“要么‘太棒了，必须做’（Hell yes），要么‘不做’（No）。” 当机会找上门，你纠结“该不该做”时，记住你的生命有限。如果某件事不能让你真正兴奋并带给你能量，你很难把它做到极致。所以，要么全力以赴，要么干脆拒绝。
最后一张是：“担忧是浪费能量。” 因为我认为我们生活在一个经济高压锅里，充满了恐惧和不确定性。但我们需要接纳这种恐惧和不确定性，感谢它带给我们的紧迫感。然后列出清单：现在我们能控制什么，下一步该做什么。

---

### [00:15:50] [Lenny]

**English:**
That's actually a perfect segue to my next question. And by the way, that was amazing. I'm glad that I asked about your Post-its. That's a whole life philosophy right there in Post-its.

**中文翻译:**
这正好引出了我的下一个问题。顺便说一下，刚才那段太棒了。很高兴我问了便利贴的事，那简直是贴在纸上的整个人生哲学。

---

### [00:15:59] [Lenny]

**English:**
Okay. So the question is around, I don't know if we're technically in a recession, but maybe we're on the verge of recession. The market's not great. And a lot of people are being laid off, or have been laid off, or are worried about being laid off, or just graduating college and looking for jobs. And I'm curious if you have advice for people trying to find a job in this market or just generally trying to accelerate their career. What is your advice for just how to deal with this environment while also trying to advance your career?

**中文翻译:**
好的。问题是关于现状的，我不知道技术上我们是否处于衰退，但也许正处于边缘。市场不太好。很多人正在被裁员，或者已经失业，或者担心被裁，还有刚毕业正在找工作的大学生。我很想知道，对于在这个市场环境下找工作，或者只是想加速职业发展的人，你有什么建议？在应对这种环境的同时，如何继续推进职业生涯？

---

### [00:16:32] [Carilu Dietrich]

**English:**
I'd like to take in two parts. One is if you're unemployed and one is you're in a job. So if you're unemployed, it's tough. It's a tough time. There's a lot of supply. And so I think you just really need endurance and grit. And the sticker worrying is wasted energy, because you will get another job. It's just going to be a little bit more of a bumpy ride than some other years.
The best executives I know have had down periods in their careers, where they were out of work for a while, where they were fired by a CEO, who this or that. And what they have in common is endurance. They're just back in the ring. So I think it's important to not lose endurance.
It's also important not to settle on a crappy job or a crappy company. Each job you have prepares you for the next job, and each logo you have prepares you for the next job.
So I'd spent a lot of my career trying to also chase waves. My first job in college, I was in nonprofit, and then I wrote a book on the giving programs of the top 50 tech companies. And I realized that tech companies had a bunch of money in 1999, and were giving it away to charities. And I wanted to go into tech, because that's where the growth and money was. And I thought I could give it back to the world and good, but I could be inside the bubble.
And then within tech, I moved my way to B2B. And within B2B, I moved my way to SaaS. And within SaaS, I've moved my way into dev tools, and collaboration, and now AI.
There's this book called The Millionaire Next Door, which talks about how the very best antique store makes one or 2% profit. And the very worst oil and gas company makes 35% profit. And we know that some of the worst software companies make 65% profit.
So picking your industry will propel your career, and picking the right company will propel your career, and then doing a good job will propel your career. So I think there's no magic bullet to getting a job. But working your network, sticking with it, and continuing to grow your skills are the three most important things.

**中文翻译:**
我想分两部分来谈：失业状态和在职状态。如果你失业了，这确实很难。现在是艰难时期，人才供应过剩。所以我认为你真的需要耐力和毅力。记住那张贴纸：“担忧是浪费能量”，因为你终究会找到另一份工作，只是过程比往年更坎坷一些。
我认识的最优秀的高管都经历过职业生涯的低谷期，比如失业一段时间，或者被 CEO 解雇等等。他们的共同点是耐力，他们总能重返赛场。所以，保持耐力至关重要。
同样重要的是，不要委身于一份糟糕的工作或一家糟糕的公司。你拥有的每一份工作都在为下一份做准备，简历上的每一个公司 Logo 也是如此。
在我的职业生涯中，我也花了很多精力去“追逐浪潮”。大学毕业后的第一份工作是在非营利机构，后来我写了一本关于前 50 强科技公司捐赠计划的书。我意识到在 1999 年，科技公司非常有钱，并且在向慈善机构捐款。我想进入科技行业，因为那是增长和金钱所在的地方。我想我可以回馈世界，但我也想身处那个“泡沫”内部。
在科技行业内部，我转向了 B2B。在 B2B 内部，我转向了 SaaS。在 SaaS 内部，我转向了开发者工具、协作工具，现在则是 AI。
有一本书叫《邻家的百万富翁》（The Millionaire Next Door），书中提到最好的古董店利润只有 1% 或 2%，而最差的石油天然气公司利润也有 35%。我们知道，一些最差的软件公司利润率也有 65%。
所以，选择行业会推动你的职业生涯，选择对的公司会推动你的职业生涯，然后做好工作也会推动你的职业生涯。我认为找工作没有灵丹妙药，但经营人脉、坚持不懈和持续提升技能是最重要的三件事。

---

### [00:18:43] [Lenny]

**English:**
Big part of this conclusion is don't feel like your career needs to slow down in this period.

**中文翻译:**
这个结论的一个重要部分是：不要觉得你的职业生涯在这个时期必须慢下来。

---

### [00:18:49] [Carilu Dietrich]

**English:**
And I think if you're in a job, some of my greatest career growth came in the economic downturns. In the 2000s, in the 2008. Because other people take their foot off the gas, and you can put your foot down. If you're willing to learn more, hit yourself into new roles or new responsibilities that no one's covering at your company. When they don't hire tons of people for everything, there's lots of open projects where you can raise your hand and grow. You just can't be as focused on title and salary right now. You're kind of building up value that you'll be able to monetize on the other end of this recession or downturn.

**中文翻译:**
我认为如果你在职，我职业生涯中一些最大的成长其实发生在经济低迷时期，比如 2000 年和 2008 年。因为当别人松开油门时，你可以踩下油门。如果你愿意学习更多，主动承担公司里没人负责的新角色或新职责。当公司不再为每件事都大举招聘时，会有很多开放的项目，你可以举手参与并成长。只是现在你不能太纠结于头衔和薪水。你是在积累价值，等这次衰退或低迷结束后，你就能将其变现。

---

### [00:19:26] [Lenny]

**English:**
Let's segue to chatting about growth. And I thought it'd be fun to start with your story of running some very expensive ad campaigns. I know the founders are always kind of flirting with this idea of buying a bunch of billboards, running TV ads, maybe subway ads and bus ads. And you've done a lot of that and you've spent a lot of money doing that, and particularly non-digital advertising. And so I'm curious what you've learned from your experience and approach to this sort of marketing spend.

**中文翻译:**
让我们转到增长的话题。我想从你运营一些昂贵广告活动的经历开始，这应该很有趣。我知道创始人总是在考虑买一堆广告牌、投放电视广告，或者地铁和公交广告。你做过很多这类尝试，花了很多钱，特别是非数字广告。我很想知道你从这些营销支出中学习到了什么经验和方法。

---

### [00:19:53] [Carilu Dietrich]

**English:**
Yes. I've spent hundreds of millions of dollars on it actually. I ran global awareness advertising for Oracle, and did all of the airports, and the front page of the Wall Street Journal, on the back page of The Economist, and take over in the middle of Salesforce in downtown San Francisco. And we did the Ironman movie sponsorships, and the sports teams and arena sponsorships.

**中文翻译:**
是的，实际上我在这方面花了数亿美元。我曾负责甲骨文（Oracle）的全球品牌知名度广告，投放了所有机场、 《华尔街日报》头版、《经济学人》封底，还在旧金山市中心 Salesforce 大楼中间搞过包楼广告。我们还赞助过《钢铁侠》电影，以及各种运动队和体育场馆。

---

### [00:20:16] [Lenny]

**English:**
That sounds very expensive.

**中文翻译:**
听起来非常昂贵。

---

### [00:20:17] [Carilu Dietrich]

**English:**
Super expensive. And then Atlassian to a lesser degree, we spent several million dollars on different awareness campaigns to get chat noticed, or to associate Jira with the Atlassian brand. Advertising is sexy and super expensive for the benefits. It's a multi-year benefit of awareness. People have to see things many times, and it has to really resonate with them.
So my advice to founders is that the most important thing is the quality of your product. Oracle spent a ton of money, and people still didn't like us in a lot of ways because they had poor experiences with the salespeople, or they didn't like Larry, or the product had kind of languished since it had been acquired by the company. So your product has to really be fantastic. And then also to do good brand advertising, it has to be sustained over a long period of time.
So Oracle had the front page of the Wall Street Journal, back page of The Economist, this boring advertising template with the red bar, but it made it memorable. We would do market tests, and two or three or 10 times more people would recognize the Oracle brand without the logo, because of the consistency versus SAP or or IBM.
So you really need to be thoughtful about spending consistently over a longer period of time, and a smaller amount on a fewer number of things can be really effective. So Snowflake, for instance, has always gotten credit for doing a billboard on 101, and people think they do lots of advertising. But for many years, it was only the billboard on 101. It was just sustained and strategic.

**中文翻译:**
超级贵。在 Atlassian 规模稍小一些，我们花了数百万美元做各种知名度活动，为了让大家注意到我们的聊天工具，或者将 Jira 与 Atlassian 品牌联系起来。广告很诱人，但相对于收益来说极其昂贵。知名度是一种跨越多年的收益。人们必须多次看到它，而且它必须真正引起共鸣。
所以我给创始人的建议是：最重要的是产品质量。甲骨文花了很多钱，但人们在很多方面还是不喜欢我们，因为他们对销售人员的体验很差，或者不喜欢 Larry（甲骨文创始人），或者产品在被收购后就停滞不前了。所以你的产品必须非常出色。此外，要做好的品牌广告，必须长期坚持。
甲骨文在《华尔街日报》头版和《经济学人》封底投放的那种带有红色条纹的枯燥广告模板，反而让人印象深刻。我们做过市场测试，由于这种一致性，在不看 Logo 的情况下，识别出甲骨文品牌的人数是 SAP 或 IBM 的两倍、三倍甚至十倍。
所以你真的需要考虑长期持续的投入，在少数几件事上投入较少的金额反而会非常有效。例如 Snowflake，人们总觉得他们做了很多广告，因为他们在 101 公路上立了广告牌。但多年来，他们其实只有那块 101 公路上的广告牌。那只是持久且具有战略性的。

---

### [00:21:59] [Lenny]

**English:**
So I guess two things that I take away from that is one, you can spend a lot of money, and if your product's not actually incredible, it's not really going to do much. And correct me if I'm wrong. And then two is sometimes, just one very targeted spend is worth a lot more than just blanketing a bunch of ads.

**中文翻译:**
我想我学到了两点：第一，你可以花很多钱，但如果你的产品不够出色，广告其实起不到什么作用。如果我说错了请纠正我。第二，有时一次非常有针对性的投入比铺天盖地的广告更有价值。

---

### [00:22:16] [Carilu Dietrich]

**English:**
Absolutely. I was telling you a story that at Atlassian, we did a big advertising campaign on our HipChat product, which was head-to-head with Slack, and it was an Office Space spoof with Bill Lumbergh. But the product had some uptime issues, and some feature issues, and Slack pulled ahead, and the advertising wasn't what would've made it or broken the product. It's really the product experience, and the advertising just amplifies.

**中文翻译:**
完全正确。我曾给你讲过一个故事，在 Atlassian 时，我们为 HipChat 产品做了一个大型广告活动，当时正与 Slack 正面交锋。那是一个模仿电影《上班一条虫》（Office Space）中 Bill Lumbergh 的恶搞广告。但产品当时有一些运行时间（Uptime）问题和功能问题，Slack 趁机领先了。广告并不能决定产品的成败，真正起决定作用的是产品体验，广告只是起放大作用。

---

### [00:22:42] [Lenny]

**English:**
I think you also shared with me this HipChat ad, that's maybe my favorite billboard ever. And I don't even know why looking back, but it made me laugh so hard. Back in the day, it was this meme of some early meme stick figure guy saying, "Why you no use HipChat?" Looking back I'm like, "Okay. I don't know how funny." But I think in the moment that was a really popular meme, and it really stuck with me.

**中文翻译:**
我想你也跟我分享过那个 HipChat 广告，那可能是我最喜欢的广告牌了。回想起来我甚至不知道为什么，但它当时让我笑得不行。那时候用的是一个早期表情包，一个简笔画小人说：“你为什么不用 HipChat？”（Why you no use HipChat?）。现在看可能觉得没那么好笑，但在当时那是非常流行的梗，让我印象深刻。

---

### [00:23:04] [Carilu Dietrich]

**English:**
Well if you think about the best advertising, it's something that has a little twist of humor, or personality, or truth that sticks in your brain. So yes, that was a successful advertising. And kudos to my team, because of course I don't write it myself as the head of marketing. But yeah.
And some of my other favorite ads are also others that highlight the customer. So New Relic did an advertising campaign around data nerds. When data nerds were not really popular, they were still nerds. And they had these tattoos that said nerd life, and they featured customers on billboards talking about cool data nerds. And some of those campaigns that really stand out have something that's funny, unexpected, and then true to the product.

**中文翻译:**
如果你想想那些最好的广告，它们通常带有一点幽默感、个性或能刻在你脑海里的真相。所以是的，那是一个成功的广告。这要归功于我的团队，作为营销负责人，我当然不会亲自写文案。
我其他一些喜欢的广告是那些突出客户的。比如 New Relic 曾做过一个关于“数据宅”（Data Nerds）的广告活动。当时数据宅还不像现在这么流行，他们还是纯粹的宅男。他们有印着“宅生活”（Nerd Life）的纹身，广告牌上展示着客户在谈论酷酷的数据宅。那些真正脱颖而出的活动通常都有一些有趣、出人意料且符合产品特质的东西。

---

### [00:23:54] [Lenny]

**English:**
I remember those, one of the ads featured, our CTO at Airbnb, Mike Curtis, and everyone was very excited to see his face on the Billboards.

**中文翻译:**
我记得那些广告，其中一个主角是我们 Airbnb 的 CTO Mike Curtis，当时大家看到他的脸出现在广告牌上都非常兴奋。

---

### [00:24:02] [Carilu Dietrich]

**English:**
Yeah, Salesforce has done a great job with those over the years too, really highlighting the customers.

**中文翻译:**
是的，Salesforce 多年来在这方面也做得很好，非常注重突出客户。

---

### [00:24:06] [Lenny]

**English:**
So zooming out a little bit, you specialize working with companies that are going through hypergrowth. And you've worked with companies like Miro, Segment, Bill.com, which I don't know if people know is just a massive, massive business. And also 1Password.
And on the topic of 1Password, interestingly I didn't realize how big and how fast 1Password has been growing. And just last week I saw this report from Okta where they have all this interesting data about which products people are using, and they put out this report showing which products you're getting the most new customers. And then on a different axis, which companies are getting the most users per new customer.
And there's this six companies in this quadrant. Figma, Miro, Snowflake, Sentry, HubSpot, and 1Password, which blew my mind. And interestingly, you work with two of them. And so all that to say, what have you noticed about what is most in common with companies that are going through hypergrowth? What is most in common in terms of what has contributed to them being that successful?

**中文翻译:**
稍微拉远一点看，你擅长与处于高速增长期的公司合作。你合作过的公司包括 Miro、Segment、Bill.com（我不知道大家是否知道这是一家规模巨大的公司）以及 1Password。
说到 1Password，有趣的是我之前没意识到它增长得有多大、多快。就在上周，我看到了 Okta 的一份报告，里面有很多关于人们正在使用哪些产品的有趣数据。报告显示了哪些产品获得的新客户最多，而在另一个轴上，显示了哪些公司每个新客户带来的用户数最多。
在这个象限里有六家公司：Figma、Miro、Snowflake、Sentry、HubSpot 和 1Password，这让我大吃一惊。有趣的是，你与其中两家都有合作。所以我想问，你注意到这些处于高速增长的公司最显著的共同点是什么？是什么促成了他们如此成功？

---

### [00:25:08] [Carilu Dietrich]

**English:**
The biggest thing is an amazing product that people love to use. I mean ChatGPT is the most hypergrowth product that we've seen in history potentially, because people are so excited to use it and it's working in interesting ways. So Miro, whiteboards were the number one most uploaded asset in Jira forever. Because people all get together and they write their ideas on a whiteboard, and then they need to remember it and iterate on it. And that bringing that concept to life just hit a cord that people wanted to use. And when one person uses it, another person uses it.
1Password similarly, I've been a 1Password user for more than 10 years. We used it at Atlassian, as a corporate. And then they have the family plan. So I used it at home and then my dad got elderly, so I had a family that I was the administrator for, and then I go into different companies and you bring it with you.
And one of the other companies I advise is Productboard. And I became an advisor of Productboard because 1Password's CPO had it in another company, brought it into 1Password, rolled it out company-wide to get alignment and visibility on the product roadmap.
So in order to get hypergrowth, you have to have organic, inbound, and viral word of mouth. You can't pay enough to grow at those rates and have a viable company, especially in this economic efficiency market. So has to be an amazing product, has to have some viral activity. So we just talked about Miro or Atlassian. You could have an individual person use it and then they say, "Hey, I'm going to present at this meeting with Miro, come join me on my board. I've got these confluence pages we'd set up as a wiki about these engineering topics, and I want your team to collaborate on them." So those natural points where your users are selling to other people is way more efficient than having sales people that have to sell to other people.
And then I think the third thing is really riding the lightning, I would call it. So hypergrowth companies go through the stages of growth that would take other companies five years or 10 years. They're going from 10 to 50, they're going from 50 to 100, they're going from 100 to 200, they're jumping. And so they really need to keep hiring 2X and 3X leaders who have seen the next stage of growth. And then the people inside can be homegrown talent, but it's tricky to keep up.
So my whole business is based on people who are trying to be homegrown leaders, but don't know what the next stage of growth looked like. And so a lot of hypergrowth companies hire ahead, hire advisors. Leaders need to really think about mentors and friendships of people who know what great looks like at the next scale, because it's going to be here before you know it. And so I would say those things. Amazing product, viral movement, and company that can ride the lightning.

**中文翻译:**
最重要的一点是拥有一款人们爱不释手的产品。ChatGPT 可能是历史上增长最快的产品，因为人们非常兴奋地去使用它。以 Miro 为例，白纸黑字的白板照片曾一直是 Jira 中上传量第一的资产。因为人们聚在一起在白板上写下想法，然后需要记录并迭代。Miro 将这个概念数字化，正好击中了人们的需求。当一个人开始用，另一个人也会跟着用。
1Password 也是如此，我已经用了 10 多年了。我们在 Atlassian 公司层面使用它。后来他们推出了家庭计划，我在家里也用。当我父亲年迈时，我成了家庭管理员。然后我换到不同的公司，也会把它带过去。
我咨询的另一家公司是 Productboard。我之所以成为他们的顾问，是因为 1Password 的 CPO 在前一家公司用过它，然后把它带到了 1Password，并在全公司推广，以实现产品路线图的一致性和可见性。
因此，为了实现高速增长，你必须拥有有机增长、入境营销和病毒式口碑。在当今注重经济效率的市场中，你不可能靠砸钱买到这种增速并维持公司生存。所以，必须有惊艳的产品，必须有病毒式传播。就像 Miro 或 Atlassian，一个员工用了，然后说：“嘿，我要用 Miro 开会，来加入我的白板。”或者“我建了一些关于工程主题的 Confluence 维基页面，我想让你们团队一起协作。”这种用户自发向他人推销的自然节点，比雇佣销售人员去推销要高效得多。
第三点我称之为“驾驭闪电”。高速增长的公司经历的成长阶段极快，从 10 到 50，从 50 到 100，他们在跳跃。因此，他们需要不断聘请那些见过下一阶段增长规模的“2倍速”或“3倍速”领导者。公司内部的人可以是本土培养的，但要跟上这种节奏很难。
我的整个业务就是基于那些试图成为本土领导者、但不知道下一阶段增长是什么样的人。所以很多高速增长的公司会提前招聘，聘请顾问。领导者需要寻找那些知道“下一规模的优秀标准”是什么的人做导师或朋友，因为那个阶段转眼就到。总结一下就是：惊艳的产品、病毒式传播，以及能够驾驭闪电的公司。

---

### [00:28:15] [Lenny]

**English:**
I imagine founders listening to this that don't have insane virality or huge word of mouth are like, "Is there no path to being a really successful company?" And then I think about companies that did succeed with other channels, like say paid or SEO. And so I guess the question for you is, do you need to grow in this environment, I guess, primarily through word of mouth, organic reality, growth engines? Or do you still see opportunity for companies to grow other ways, say paid, or SEO, or sales eventually?

**中文翻译:**
我想那些没有疯狂病毒式传播或巨大口碑的创始人听了会想：“难道我们就没有成为成功公司的路径了吗？”我会想到那些通过其他渠道成功的公司，比如付费广告或 SEO。所以我想问，在当前环境下，是否必须主要通过口碑、有机传播和增长引擎来增长？你是否仍然看到公司通过其他方式（如付费、SEO 或最终通过销售）增长的机会？

---

### [00:28:51] [Carilu Dietrich]

**English:**
For sure. All of the things are important. I think what I wanted to say first as you were talking was that it's easy to look at a company after they've been viral and be like, "That's amazing." I would like to start a newsletter. I have. It's carilu.com. Lenny has a newsletter. How can I ever grow like Lenny's virality? But Lenny started with one blog, and then another, and the consistency.
And when I look back at Atlassian, people would be like, "It must have been so easy to go from 100 to 500 million." And it never felt easy. It was a slog to do exactly what you're talking about. New features, listen to customers, strong SEO. Actually SEO was the number one marketing motion that we used, and SEM. We spent probably between 15 and 25% of our leads from paid search marketing at the time. Now I have a ton of customers that are pretty deep into account-based marketing.
Getting to virality and getting the hypergrowth is not a magic bullet. It's consistency, customer obsession, incremental improvements across all parts of the business. So I think founders just need to double down on having a product that's differentiated and does something that their customers really love. And each incremental step is a step forward.

**中文翻译:**
当然，所有这些都很重要。我想先说的是，人们很容易在一家公司走红后感叹“太神奇了”。我也想办个时事通讯（Newsletter），我已经办了，叫 carilu.com。Lenny 也有。我怎么可能像 Lenny 那样有病毒式增长？但 Lenny 也是从第一篇博客开始，然后是第二篇，靠的是坚持。
回想 Atlassian，人们会说：“从 1 亿增长到 5 亿一定很容易。”但其实一点也不容易。那是一场苦战，做的正是你提到的那些事：开发新功能、倾听客户、做强大的 SEO。实际上，SEO 曾是我们排名第一的营销手段，还有 SEM（搜索引擎营销）。当时我们大约 15% 到 25% 的线索来自付费搜索。现在我有很多客户深耕于基于账户的营销（ABM）。
实现病毒式传播和高速增长没有灵丹妙药。它靠的是一致性、对客户的痴迷，以及业务各环节的持续改进。所以，创始人只需要加倍努力，打造一个差异化的、客户真正喜爱的产品。每一步微小的改进都是向前迈进。

---

### [00:30:16] [Lenny]

**English:**
This episode is brought to you by Coda. You've heard me talk about how Coda is the doc that brings it all together and how can help your team run smoother and be more efficient. I know this firsthand because Coda does that for me. I use Coda every day to wrangle my newsletter content calendar, my interview notes for podcast, and to coordinate my sponsors.
More recently, I actually wrote a whole post on how Coda's product team operates, and within that post they shared a dozen templates that they use internally to run their product team. Including managing the roadmap, their OKR process, getting internal feedback, and essentially their whole product development process is done within Coda.
If your team's work is spread out across different documents and spreadsheets and a stack of workflow tools, that's why you need Coda. Coda puts data in one centralized location regardless of format, eliminating roadblocks that can slow your team down. Coda allows your team to operate on the same information and collaborate in one place. Take advantage of the special limited time offer just for startups. Plan up today at Coda.io/lenny and get a $1,000 startup credit on your first statement. That's Coda.io/lenny to sign up and get a startup credit of $1,000. Coda.io/lenny.

**中文翻译:**
本期节目由 Coda 赞助。你听我多次提到 Coda 是一款能将一切整合在一起的文档工具，它能帮助你的团队运行得更顺畅、更高效。我有切身体会，因为 Coda 就在为我服务。我每天都用 Coda 来管理我的 Newsletter 内容日历、播客采访笔记以及协调赞助商。
最近，我写了一篇关于 Coda 产品团队如何运作的文章，他们在文中分享了十几个内部使用的模板，包括管理路线图、OKR 流程、获取内部反馈，基本上他们整个产品开发流程都是在 Coda 中完成的。
如果你的团队工作分散在不同的文档、电子表格和一堆工作流工具中，那么你正需要 Coda。Coda 将数据集中在一个地方，无论格式如何，消除了可能拖慢团队进度的障碍。Coda 让你的团队基于相同的信息在同一个地方协作。现在有专门针对初创公司的限时优惠：立即访问 Coda.io/lenny 注册，首张账单可获得 1000 美元的初创公司抵扣额度。即 Coda.io/lenny。

---

### [00:31:32] [Lenny]

**English:**
Say that you as a company are seeing word of mouth in some virality, and you want to think about accelerating that, leaning into word of mouth. Obviously you want everyone to be talking about how awesome you are sharing with their friends. Is there anything that you've seen as a good way to lean into word of mouth and accelerate it?

**中文翻译:**
假设一家公司已经看到了一些口碑和病毒式传播，想要加速这一过程，进一步利用口碑。显然，你希望每个人都在谈论你有多棒，并分享给朋友。你有没有见过什么好的方法可以利用并加速这种口碑传播？

---

### [00:31:49] [Carilu Dietrich]

**English:**
I think there's two or three things. One is really empowering the people in your company to be thought leaders. So early days, Atlassian's founders were on all the developer boards. And in fact, I remember, we were maybe 150 million or 200 million, and Scott Farquhar the CEO was still participating and going back and forth in different dev forums when I was like, "I don't know, should we elevate your status? Should we have evangelists and engineers that do this?"
And we did, right? And look, one of my clients now is Weights & Biases, the ML ops company helping lots of different AI companies with their ML models. And they have really thoughtful technical people who know more and write more on the blog and engage with their community. And that creates a word of mouth, because they're providing both a product and concepts and learning. That's one of the HubSpot secrets was all of their really thoughtful, helpful content, certifications for marketers.
So I think going back to summarize, word of mouth can be driven by thought leadership, which is hiring the right people to really be deeply engaged as super experts. Having a really strong content strategy that's either in communities that already exist, online communities, open source communities.
And then third I would say building your own community. So no one sells your product better than your own happy customers. And if I go way back to the very beginning of my career, I worked on a marketing team where I owned demand gen just for net new prospects, and a peer owned demand gen just for existing customer upsell. And we would have different field events.
And the existing customer ones were smaller than if we'd invited the prospects and had more buzz. And the prospect ones were very salesy. Whereas if we brought them together and you had customers talking to each other and prospects listening, everyone had a better time.
So Atlassian, one of our secrets was this amazing user group community where we just paid for beer and a pizza, and we'd facilitate local in-city leaders, and people would meet up and talk about our products, and talk about development generally, and grow their careers and grow their network. So I think those are the three. The right people, the right content, and the right communities.

**中文翻译:**
我认为有两三点。第一是赋能公司员工成为思想领袖（Thought leaders）。在早期，Atlassian 的创始人活跃在所有的开发者论坛上。事实上我记得，当我们规模达到 1.5 亿或 2 亿时，CEO Scott Farquhar 仍在各种开发论坛上参与讨论。我当时在想：“我是不是该提升一下你的身份？我们是不是该让布道师和工程师来做这些？”
后来我们确实这么做了。看，我现在的一个客户 Weights & Biases（一家 ML Ops 公司），他们有很多非常有想法的技术人员，他们在博客上写深度文章并与社区互动。这创造了口碑，因为他们不仅提供产品，还提供概念和学习资源。这也是 HubSpot 的秘诀之一：提供大量深刻、有帮助的内容和针对营销人员的认证。
总结一下，口碑可以通过以下方式驱动：1. **思想领导力**，即聘请对领域有深度参与的超级专家；2. **强大的内容策略**，深入现有的在线社区或开源社区；3. **建立自己的社区**。没有人比满意的老客户更能推销你的产品。在我职业生涯初期，我负责针对新潜在客户的需求挖掘，而同事负责老客户的增购。我们举办活动时发现，如果只请老客户，规模较小；如果只请潜在客户，推销味太重。但如果把他们聚在一起，让老客户互相交流，潜在客户在旁边听，效果反而最好。
Atlassian 的秘诀之一就是惊人的用户组社区。我们只负责买单啤酒和披萨，由当地城市的领袖组织，大家聚在一起聊产品、聊开发、拓展人脉。所以就是这三点：对的人、对的内容、对的社区。

---

### [00:34:11] [Lenny]

**English:**
As you were talking, I was reminded, I was just chatting with the founder of Gusto about their journey early on. And he said that for the first 200 customers, he sat there with them running payroll, watching how they react every step of the payroll process and how they feel at every moment. And that was a big part of what helped them build the product that people actually continue using, and love, and stick with. And if it wasn't in person, it was on a phone call. And it's like the epitome of doing things don't scale, just like for hundreds of new customers watching them use your product. Pretty wild.

**中文翻译:**
听你说话时我想起，我刚和 Gusto 的创始人聊过他们的早期历程。他说前 200 个客户，他都是坐在他们旁边看着他们跑工资单，观察他们在每一个步骤的反应和感受。这是帮助他们打造出让人爱不释手、持续使用的产品的关键。如果不能面对面，就通过电话。这简直是“做那些无法规模化的事”（Doing things that don't scale）的典范——亲自观察几百个新客户使用你的产品。太疯狂了。

---

### [00:34:44] [Carilu Dietrich]

**English:**
I mean that's the secret. That's the secret sauce. And I've heard some early stage startup advisors say that you should build processes that don't scale first. Because when you're in the super early stage seed A under 10 million, you've really got to go deep at that stage.
And in fact, I see that that's one of the problems that companies experience as they get much bigger, when product managers can't meet with customers, or they get limited customers, or maybe they can only meet with a junior user, only the administrator, and not lots of the users. So that insight into the daily struggles and experience of your customers, it's harder to get as you get bigger I think.

**中文翻译:**
这就是秘诀，这就是核心所在。我听过一些早期创业顾问说，你应该先建立无法规模化的流程。因为当你处于种子轮、A 轮、营收低于 1000 万的超早期阶段时，你必须深入进去。
事实上，我发现这是公司变大后遇到的问题之一：产品经理见不到客户，或者只能见到极少数客户，或者只能见到初级用户或管理员，而见不到大量的一线用户。随着公司规模扩大，获取关于客户日常痛点和体验的洞察会变得越来越难。

---

### [00:35:28] [Lenny]

**English:**
I want to drill into Atlassian. You've brought them up a couple times. You were at Atlassian for a long time. You were there from early days of growth to IPO. And one of the most interesting elements of Atlassian and something that comes up a lot on this podcast is product led growth.
And Atlassian I think is one of the most classic examples of a product led growth company. And from what I understand, y'all waited a long time to hire your first salesperson. So my question is what did you learn from that experience about when is the right time to start leaning into sales and hiring sales, and what are the trade-offs of waiting longer or doing it earlier?

**中文翻译:**
我想深入聊聊 Atlassian。你提到了他们好几次。你在 Atlassian 待了很长时间，从早期增长一直到 IPO。Atlassian 最有趣的元素之一，也是本播客经常提到的话题，就是“产品驱动增长”（PLG）。
我认为 Atlassian 是 PLG 公司最经典的案例之一。据我所知，你们等了很久才聘请第一名销售人员。所以我的问题是，从那段经历中，你学到了什么时候才是开始转向销售和招聘销售的正确时机？晚聘或早聘的权衡是什么？

---

### [00:36:04] [Carilu Dietrich]

**English:**
Atlassian was a super unique company at a super unique point in time, because the founders never took outside money except for one late stage financing to buy out some early employees, to give some liquidity. So we never had VCs or private equity that had a voting share that was significant, that could overrule the founders.
So the founders were going through this experiment that turned out to be really successful, where they took all the money they would've spent on a sales org and plowed it into engineering and product. I'm going to pull up a slide here that tells the Atlassian story about the ratio of the sales and marketing to the product and engineering.

**中文翻译:**
Atlassian 是一家处于非常独特时间点的非常独特的公司。因为创始人从未拿过外部资金，除了后期为了给早期员工提供流动性而进行的一轮融资。所以我们从未有过拥有重大投票权、能否决创始人的风投或私募股权。
因此，创始人进行了一场后来证明非常成功的实验：他们把本该花在销售组织上的所有钱，都投入到了工程和产品中。我这里有一张幻灯片，讲述了 Atlassian 关于销售营销支出与产品工程支出比例的故事。

---

### [00:36:46] [Lenny]

**English:**
Amazing. And by the way, check this out on YouTube if you're listening to this and check out this slide.

**中文翻译:**
太棒了。顺便说一下，如果你在听音频，可以去 YouTube 看看这张幻灯片。

---

### [00:36:53] [Carilu Dietrich]

**English:**
So this is a representative sample of what we did in Atlassian's history, and what ratios still exist today, even several years later. Where we spend way less on sales and marketing. Marketing spent less than other marketers. And also we had almost no sales org, or a sales org that was really focused on renewals, or now an assisting sales org that's focused more on enterprise. But relative to other companies, a much smaller, much more efficient sales org. And we took all that money and put it into product. So here we're spending two times, three times as many dollars in R&D as many other companies that we'd benchmark against to make a product that really sold itself.

**中文翻译:**
这是 Atlassian 历史上做法的一个代表性样本，甚至在几年后的今天，这种比例依然存在。我们在销售和营销上的支出远低于同行。营销支出比其他营销人员少，而且我们几乎没有销售组织，或者说销售组织主要关注续约，现在则是有一些辅助销售组织关注企业级客户。但相对于其他公司，我们的销售组织规模更小、效率更高。我们把省下的钱全部投入到产品中。在这里，我们的研发（R&D）投入是基准公司的两倍甚至三倍，目的是打造一款真正能“自我推销”的产品。

---

### [00:37:37] [Lenny]

**English:**
It's interesting. So I'm looking at the slide. And again if you're listening, check this on YouTube because it's pretty crazy. This slide of bar chart of spend in sales and marketing and R&D, and Atlassian is the very lowest amount of spend in sales and marketing, and the highest spend in product. And it's interesting that it's from 2020, so it's not even in the early days. It's like still today basically.

**中文翻译:**
很有趣。我正在看这张幻灯片。再提醒一下听众，去 YouTube 看，这太疯狂了。这张柱状图显示了销售营销与研发的支出，Atlassian 在销售营销上的支出最低，而在产品上的支出最高。有趣的是这是 2020 年的数据，所以甚至不是早期，基本上现在也是这样。

---

### [00:37:59] [Carilu Dietrich]

**English:**
Right. I'm going to close this down and keep telling you a little bit more about it. There's some unique things that people can take now and incorporate. So the real strategy in sales, sales is the most expensive vehicle, right? Expensive people that spend a lot of time. So the Atlassian model was to sell only to people who were already customers really. If several people or a couple groups had purchased, we'd help them with their renewals. And now in the later incarnations of our sales orgs at Atlassian, it helps a lot more with larger enterprise companies who need enterprise deals, or does more cross-sell and upsell, but doesn't really do prospecting. Net new prospecting is a really expensive way to get new customers.
So we see different trends coming now with companies, because almost no one can do pure product led growth. Because your investors want to see accelerated growth, and most people believe that adding an SDR or adding an AE will add a predictable amount of revenue. And so it's difficult because product led growth and sales have to coexist.
But the whole transition in marketing that's happening to account-based marketing and intent-based signals is trying to do some of what we were doing at Atlassian, only to engage salespeople with customers that are actually likely to buy. And if you look at other hyper-growth companies, Airtable, Miro, both of those I know from the inside have had strategies where the salespeople really only engage after some threshold has been hit of number of users that have already been paying for the product on their credit card. But sometimes it's a high number of 20, 40 people at an account have to be engaged before a salesperson engages.

**中文翻译:**
没错。我关掉幻灯片继续说。有一些独特的点是大家现在可以借鉴的。销售是最昂贵的手段，对吧？昂贵的人才花费大量的时间。Atlassian 的模式是只向已经是客户的人销售。如果几个人或几个小组已经购买了，我们就帮他们续约。在 Atlassian 销售组织的后期演变中，它更多是帮助需要企业级合同的大型公司，或者做更多的交叉销售和增购，但它并不真正做“拓客”（Prospecting）。寻找全新的潜在客户是获取新客户的一种非常昂贵的方式。
现在我们看到公司出现了不同的趋势，因为几乎没有人能做纯粹的 PLG。因为你的投资者想要看到加速增长，而大多数人相信增加一名 SDR（销售开发代表）或 AE（客户经理）会带来可预测的收入。所以这很难，因为 PLG 和销售必须共存。
但目前营销领域向 ABM（基于账户的营销）和意向信号（Intent-based signals）的转型，其实就是在尝试做我们当年在 Atlassian 做的事：只让销售人员去接触那些真正有购买意向的客户。如果你看其他高速增长的公司，比如 Airtable 和 Miro，据我所知，他们的策略是销售人员只有在达到某个阈值（比如已经有 20、40 个用户在用信用卡付费）后才会介入。

---

### [00:39:54] [Lenny]

**English:**
Based on that, what is it you recommend to founders these days that maybe are product led and just self-service oriented. Do you kind of take this experience and wait as long as you can to hire your first salesperson? I know it's very specific to the situation, but what kind of advice do you generally give?

**中文翻译:**
基于此，你对现在那些可能是产品驱动、以自助服务为主的创始人有什么建议？你会建议他们借鉴这段经验，尽可能晚地招聘第一名销售吗？我知道这取决于具体情况，但你通常会给什么样的建议？

---

### [00:40:12] [Carilu Dietrich]

**English:**
You and I are both like Elena Verna who was just on your podcast earlier this month. Product led growth depends so much on your product and your buying market. There's some buying markets that are less likely to use salespeople, and you need to go in from the beginning. HR might be one, right? Whereas a lot of the hyper-growth companies in the dev tool space can use product led growth because developers both hate sales people, and really love to research themselves. So you see things taking off because people engage and kind of self sell.
So I would recommend, get closer to their customers and read the signals. If your product is good enough, the people can get time to value in a couple of days instead of weeks or months. You can have a product led growth motion. If your product needs to be put in context, and customized, and assisted, sales teams sometimes are expensive services arms to cover over product issues and help customers buy it until it's fixed. Or if you're in a market where your buyer just really doesn't buy online with research and a demo, then you need to have salespeople. But I would say try not to hire too fast and too far ahead in sales and inside sales, because it seems like it's going to add revenue, but it actually is a huge cost and a huge drain on the business if the product isn't getting that kind of resonance.

**中文翻译:**
你我都很认同本月早些时候上过你节目的 Elena Verna 的观点。PLG 在很大程度上取决于你的产品和购买市场。有些市场不太可能不用销售，你从一开始就需要销售，比如 HR 领域。而开发者工具领域的很多高速增长公司可以使用 PLG，因为开发者既讨厌销售，又非常喜欢自己研究。所以你会看到产品因为用户自发参与和“自我推销”而起飞。
所以我建议，要贴近客户并读取信号。如果你的产品足够好，用户能在几天内而不是几周或几个月内获得价值（Time to value），你就可以采用 PLG 模式。如果你的产品需要结合上下文、定制化和辅助，销售团队有时会变成昂贵的“服务部门”，用来掩盖产品问题并帮助客户购买，直到产品修好。或者如果你所在的市场，买家根本不通过在线研究和演示来购买，那你必须有销售。但我会说，尽量不要在销售和内部销售上招聘得太快、太超前，因为看起来它会增加收入，但如果产品没有引起那种共鸣，它实际上是巨大的成本和对业务的消耗。

---

### [00:41:47] [Lenny]

**English:**
I just had a conversation with the founder of Retool for this series that I'm working on, and he basically found the same thing you found where they thought it could be a product led experience where you're building internal tools using their product, but it turned out nobody really understood how to do it themselves and it took a lot of handholding to make it work. So they became sales led from the beginning, even though it feels like a tool that has a lot of potential to be product led and self-service.

**中文翻译:**
我刚为了我正在做的系列访谈和 Retool 的创始人聊过。他发现的情况和你说的基本一致：他们本以为这可以是一个 PLG 体验，用户自己用产品构建内部工具，但结果发现没人真正懂得怎么自己动手，需要大量的“手把手”指导才能跑通。所以他们从一开始就变成了销售驱动，尽管这看起来像是一个很有潜力做 PLG 和自助服务的工具。

---

### [00:42:11] [Carilu Dietrich]

**English:**
I think the other hybrid I'm starting to see is people who turn their SDR, sales development reps, into sales engineers, researchers. So instead of having a salesperson who's like, "Would you like to have a meeting with another salesperson?" The first touch for customers that are maybe kicking the tires or trying a product led growth is a person who can help guide them on the path. And I like this hybrid nature because basically it extends product led growth, but helps people in this case where you're talking, where the product itself isn't so intuitive that you can get all the way to the buy itself.

**中文翻译:**
我开始看到的另一种混合模式是，人们将 SDR（销售开发代表）转变为销售工程师或研究员。与其让销售问：“你想和另一位销售开会吗？”，不如让那些正在“观望”或尝试 PLG 的客户接触到一个能引导他们走通路径的人。我喜欢这种混合模式，因为它本质上延伸了 PLG，但在你提到的那种产品不够直观、无法完全靠用户自行购买的情况下，它能提供帮助。

---

### [00:42:51] [Lenny]

**English:**
It also sounds more fun to talk to a sales engineer than a salesperson.

**中文翻译:**
而且和销售工程师聊天听起来比和销售聊天更有趣。

---

### [00:42:56] [Carilu Dietrich]

**English:**
I know. I always wanted to be a sales engineer. I was a salesperson, and I crushed on the sales. Engineering team who knew everything and could draw all the architectures.

**中文翻译:**
我知道。我一直想当销售工程师。我曾是一名销售，但我非常崇拜销售工程团队，他们无所不知，能画出所有的架构图。

---

### [00:43:03] [Lenny]

**English:**
Oh wow, I didn't know that. A couple more questions around this stuff. So you've worked with a lot of different companies. And you kind of come in and help them figure out ways to grow faster, unlock growth opportunities. What do you find often gets most in the way of making big changes to the way they approach growth and approach different growth channels? And maybe on the flip side, what do you find is most essential to making big changes at a company around how they think about growth?

**中文翻译:**
噢哇，我以前不知道这个。关于这些还有几个问题。你和很多不同的公司合作过，帮助他们找到更快增长的方法，解锁增长机会。你发现通常是什么阻碍了他们对增长方式和增长渠道做出重大改变？反过来说，你认为在改变公司对增长的思考方式时，最核心的要素是什么？

---

### [00:43:30] [Carilu Dietrich]

**English:**
The big growth levers are pretty consistent across companies. You start with one product, and you have a couple choices on how the go-to-market works. Product leg growth or sales assisted. You get a little bit bigger and you add an incremental product, or you start to add new segments. You're going to focus on a vertical like finance, or you're going to go global, or you're going to add new sales channels like a partner channel.
And what I've seen with the big growth levers is that it can't ever be an individual department's goal without being a cross company strategy goal, if it's really going to make a difference.
So you've talked about it in your newsletter and on your podcast, but growth isn't just like a person in the engineering team that hacks by themselves. It really has to be funded and thoughtfully constructed so that there's the right content and experience, and product features, and virality features a customer to continue to drive growth.
And similarly, lots of companies right now are trying to move upmarket because the economy has created so much pressure in S&B that they're going to try to move to enterprise, or they've trying not to sell as much just to tech companies because tech companies are under pressure and so they want to move to different parts.
Sometimes the marketers get blamed or sales gets blamed, we don't have enough leads. But really it's a company strategy problem where the company hasn't decided, "Hey, we're going to all move in this direction and if we're going to sell the enterprise, marketing's going to bring in leads, products going to have a roadmap, and some meaningful features to enterprise. The customer research is going to start thinking about them. We're going to hire some customer support people who know how enterprises work. We're going to hire some salespeople who sell differently to enterprises than S&B." The big growth levers are strategy problems, not individual departmental problems.

**中文翻译:**
主要的增长杠杆在不同公司之间其实非常一致。你从一个产品开始，选择一种进入市场（GTM）的方式：PLG 或是销售辅助。当你变大一点，你会增加新产品，或者增加新细分市场。你可能会专注于金融等垂直领域，或者走向全球，或者增加合作伙伴等新销售渠道。
我观察到的是，如果这些增长杠杆真的要发挥作用，它们绝不能仅仅是某个部门的目标，而必须是全公司的战略目标。
你在 Newsletter 和播客中也提过，增长不只是工程团队里某个人在那儿瞎搞。它必须获得资金支持并经过周密构建，确保有正确的内容、体验、产品功能和病毒式功能，从而持续驱动增长。
同样，现在很多公司都在尝试向高端市场（Upmarket）转型，因为经济压力让中小企业（SMB）市场很难做，所以他们想转向企业级（Enterprise）。或者他们不想只卖给科技公司，因为科技公司压力也很大。
有时营销人员或销售人员会被指责“线索不够”。但实际上这是一个公司战略问题：公司没有决定“我们要全员向这个方向移动”。如果我们卖给企业级，营销要带来线索，产品要有路线图和针对企业的功能，客户研究要开始考虑他们，我们要雇佣懂企业运作的客服，雇佣销售方式不同于 SMB 的销售。大的增长杠杆是战略问题，而不是单一部门的问题。

---

### [00:45:26] [Lenny]

**English:**
And what do you find needs to happen for that to change? Is that like CEO needs to be like, "Here's what we're doing, everyone get on board," or something else?

**中文翻译:**
你认为要改变这种状况需要发生什么？是需要 CEO 站出来说“这就是我们要做的，大家跟上”，还是别的什么？

---

### [00:45:35] [Carilu Dietrich]

**English:**
I think it can come either way in the C-suite, right? So my job, I advise hypergrowth CEOs and CMOs of companies, 30 million to 500 million. Often if I'm advising a 30 to 100 million company, the more junior marketer with a CEO who's often a first time founder, who doesn't necessarily know if the marketer's good or not. Hasn't done run marketing before, doesn't know if they should trust what the marketers saying.
So often the marketer is saying," Hey, we're having problems because the company's not delivering on this promise you want us to sell." And sometimes the CEO doesn't know if they can trust it, a judgment. And so in that case, someone like me who's an advisor comes in and is like, "That's right, it's not a marketing problem, it's company strategy problem. Let's have an offsite and build some OKRs where we all go after enterprise and we win it together."
You'll see at bigger companies or when a new CMO comes in with more senior or seasoned, they'll have the social capital to push back into the executive suite. Or a new head of engineering who will say, "Look, I know you want to move ahead faster, but we actually have to catch up on this technical debt." And they'll push back and get that strategic space that they need. So it can either come from the CEO or it can come from the C-suite really coming together to solve those problems, instead of pushing them under the rug.

**中文翻译:**
我认为在高管层中，这两种方式都可以。我的工作是为营收在 3000 万到 5 亿之间的公司 CEO 和 CMO 提供咨询。通常当我咨询 3000 万到 1 亿规模的公司时，营销负责人可能相对资历较浅，而 CEO 往往是第一次创业。CEO 不一定知道这个营销负责人行不行，因为他以前没管过营销，不知道是否该信任营销负责人的话。
所以营销负责人经常会说：“嘿，我们遇到问题了，因为公司没有兑现你让我们去推销的承诺。”有时 CEO 不知道是否该信任这个判断。在这种情况下，像我这样的顾问介入并说：“没错，这不是营销问题，这是公司战略问题。让我们开个团建会（Offsite），制定一些 OKR，大家一起攻克企业级市场。”
在更大的公司，或者当一位更资深、更有经验的新 CMO 加入时，他们会有足够的社交资本向高管层施压。或者一位新的工程主管会说：“听着，我知道你想快点推进，但我们必须先解决技术债。”他们会争取到必要的战略空间。所以，这既可以来自 CEO，也可以来自高管层真正团结起来解决问题，而不是把问题掩盖起来。

---

### [00:47:01] [Lenny]

**English:**
You touched on this nuance that a lot of times, there's not a lot of trust between the marketing head and the CEO. And I'm curious what you find helps build that trust.

**中文翻译:**
你提到了一个微妙的细节：很多时候营销负责人和 CEO 之间缺乏信任。我很想知道你发现什么有助于建立这种信任。

---

### [00:47:13] [Carilu Dietrich]

**English:**
There's a couple things that are really critical for senior marketers, and I actually have a blog coming up based on a podcast I've recorded about why CMOs mostly get fired. And the issues are generally one, that the CMO isn't focused enough on the revenue. So some CMOs get focused more on the pipeline or the awareness, and the CEO doesn't feel like they really have a partner in driving the revenue. Or they don't feel like the CMO really has a handle on what will drive the revenue.
Marketing's tough because it's a big spend category, and lots of the spend doesn't convert in quarter. Some of it doesn't convert in year. Advertising campaigns, some take multiple quarters.
So it's really important for CMOs to have a handle on the metrics, a solid prediction of what growth levers they can use, and to be able to talk in the terms of the CEO and the board.
And I think that that's the biggest gap that I generally see. And then of course, there's a whole bunch of table stake stuff. They have to be running their business well. They have to be a good leader that people want to work for. They have to hire a great team that elevates them and the company, they have to be thoughtful and strategic about the market space that the company's in. They're not just working the levers in the factory. They're thinking, "What new markets should we enter? What new growth areas should we employ?" Like we just talked about. "What new companies should we acquire?" They also need to be thinking ahead. And I think being good on metrics, good on strategy, and good on market helps CMOs spar with CEOs in a way that builds trust.

**中文翻译:**
对于资深营销人员来说，有几件事至关重要。我最近根据录制的播客写了一篇博客，主题是“为什么大多数 CMO 会被解雇”。问题通常在于：第一，CMO 对收入的关注不够。有些 CMO 过于关注销售漏斗（Pipeline）或知名度，而 CEO 觉得在驱动收入方面没有得到真正的伙伴支持，或者觉得 CMO 根本不知道什么能驱动收入。
营销很难，因为它是一个巨大的支出类别，而且很多支出不会在当季转化，有些甚至不会在当年转化。广告活动有时需要好几个季度才能见效。
因此，CMO 必须掌握数据指标，对可用的增长杠杆有可靠的预测，并且能够用 CEO 和董事会的语言进行交流。
我认为这是我见过的最大鸿沟。当然，还有一些“入场券”级别的基本要求：他们必须管理好自己的业务；必须是员工愿意追随的好领导；必须聘请能提升自己和公司的优秀团队；必须对公司所处的市场空间有深思熟虑的战略。他们不只是在工厂里拉杠杆的人，他们要思考：“我们应该进入哪些新市场？应该采用哪些新增长领域？”就像我们刚才聊的，“我们应该收购哪些新公司？”他们需要有前瞻性。我认为精通指标、精通战略、精通市场，能让 CMO 在与 CEO 的博弈中建立信任。

---

### [00:49:00] [Lenny]

**English:**
It's interesting that you say, that blog post you titled Why Most CMOs Get Fired, and it connects with something. Casey Winters noted, that most CPOs also get fired chief product officers. I forget the quote, but it's something like, "The most you can help for is a couple swings at the bat before you get fired as a CPO." Why do you think this is so common for these chief C-suite roles to startups to not work out?

**中文翻译:**
很有意思，你那篇博客叫《为什么大多数 CMO 会被解雇》，这让我想起 Casey Winters 提到过，大多数 CPO（首席产品官）也会被解雇。我忘了原话，但大概是：“作为 CPO，在你被解雇前，你最多只能指望有几次挥棒的机会。”你认为为什么初创公司的这些 C-suite 职位如此普遍地以失败告终？

---

### [00:49:26] [Carilu Dietrich]

**English:**
They're incredibly hard jobs. The chief product officer and the chief marketing officer are both strategy jobs with difficult to measure results because some of them are direct and some of them are indirect. And I think both of them get swept up when a company's not performing well too. If company's not performing well, you can kind of swap out the head of product, and the next one will be more strategic and deliver faster.
And in fact, I've worked in one of the roles, the CFO was really after my chief product officer, and ultimately got him fired because he wanted to move everything offshore, and develop faster, and he didn't want to re-platform, and he didn't want to deal with the technical debt. And the CFO was sure that it was the CPO's fault, and then they got rid of the CPO, and the CFO tried his plan and it didn't work. And then you bring someone in who's like, "No, that guy had the right plane."
So both of them are tough jobs. And they require a high bar of excellence, a high connection of trust, and then I think just endurance to keep going and find the next role where you're really a fit and the company really has momentum.

**中文翻译:**
因为这些工作极其困难。CPO 和 CMO 都是战略性职位，结果很难衡量，因为有些是直接的，有些是间接的。而且我认为当公司表现不佳时，这两个职位首当其冲。如果公司表现不好，你可以换掉产品负责人，寄希望于下一个更有战略眼光、交付更快。
事实上，我曾经历过这样的情况：CFO 一直针对我的 CPO，最终让他被解雇了。因为 CFO 想把所有业务外包到海外以加快开发，他不想重新构建平台，也不想处理技术债。CFO 坚信那是 CPO 的错，于是他们赶走了 CPO。结果 CFO 尝试了自己的计划，却失败了。然后你再请来一个人，他说：“不，之前那个人才是对的。”
所以这两个都是苦差事。它们需要极高的卓越标准、极深的信任纽带，以及坚持下去的耐力，直到找到下一个真正契合且具有势能的公司。

---

### [00:50:36] [Lenny]

**English:**
It also reminds me, I was just talking to, I think it was Canva. Where their first engineering hire is now their CTO still, and their first marketing hire is their CMO still. So it does work out on occasion.

**中文翻译:**
这也让我想起，我刚和 Canva 聊过。他们的第一名工程员工现在还是 CTO，第一名营销员工现在还是 CMO。所以偶尔也会有圆满结局。

---

### [00:50:48] [Carilu Dietrich]

**English:**
It works out on occasion. And in fact, I've been playing around with a 10 part series about those CMOs in the CMO world, because there's about 10 to 15 CMOs who have started when it's really small and grown all the way. And they're the ones we really want to learn from. And I know a lot of them and really admire their work, and have learned so much.

**中文翻译:**
偶尔会成功。事实上，我一直在构思一个关于营销界这些 CMO 的 10 集系列，因为大约有 10 到 15 位 CMO 是从公司很小时加入并一路陪跑壮大的。他们才是我们真正想学习的对象。我认识其中的很多人，非常钦佩他们的工作，也学到了很多。

---

### [00:51:09] [Lenny]

**English:**
You should absolutely do that. That sounds very cool. You talked about how you work with companies from 30 million to 500 million. What is it about that stage that's unique, and what happens after 500 million, and what's the difference before say 30 million? I know it's not an exact number, but how do you think about that range?

**中文翻译:**
你绝对应该做那个系列，听起来很酷。你提到你合作的公司营收在 3000 万到 5 亿之间。这个阶段有什么独特之处？5 亿之后会发生什么？3000 万之前又有什么不同？我知道这不是个精确数字，但你是如何看待这个区间的？

---

### [00:51:24] [Carilu Dietrich]

**English:**
No, it's not an exact number. My bottom number is because there's this early stage of product market fit where the founder and the company are trying to figure out who their real ideal customer profile is, and can they sell to them consistently?
I've worked for some early stage startups where we've tried lots of different things, but they're not repeatable. You can't scale it. "This product works for this. This product works for this too and it works for this," but those are all kind of unique cases studies. And so my skill is in helping people scale.
And so if they've already found product market fit and they've gotten some funding or they're bootstrapped, but have enough funding to really be trying to build out marketing in a marketing team, that's when I know what each stage looks like. So I know what $30 million great teams look like, and 50 million, and 100, and 150 million, 200 million. My ride at Atlassian was from about 100 to 500.
And then over 500, the act of going public, being an early stage public company, I know what that all looks like. And then beyond that, there's public company consultants I think more, that do more specific things. I more help the CMO and CEO structure for the next stage of growth, because they're going through it so fast, they haven't hired someone yet who's already seen.

**中文翻译:**
是的，这不是个精确数字。我设定的下限是因为在 3000 万之前，通常处于寻找“产品市场契合点”（PMF）的早期阶段，创始人和公司还在摸索谁才是真正的理想客户画像（ICP），以及是否能持续向他们销售。
我曾为一些早期初创公司工作，我们尝试了很多不同的东西，但它们不可重复，无法规模化。比如“这个产品对这个有用，对那个也有用”，但这些都是孤立的案例。而我的专长是帮助人们规模化。
所以，如果他们已经找到了 PMF，获得了一些融资或者是自给自足（Bootstrapped）但有足够的资金来建立营销团队，那就是我介入的时候。我知道每个阶段是什么样的：3000 万、5000 万、1 亿、2 亿规模的优秀团队长什么样。我在 Atlassian 的经历是从 1 亿到 5 亿。
超过 5 亿后，涉及上市、成为早期上市公司，我也了解这些。再往后，更多是上市公司顾问在做更具体的事。我更多是帮助 CMO 和 CEO 为下一阶段的增长构建架构，因为他们增长太快了，还没来得及聘请那些“见过世面”的人。

---

### [00:52:51] [Lenny]

**English:**
Got it. One very nuanced question I want to ask you is about bundling. So there's HipChat and Slack kind of ate their lunch, not necessarily through bundling, but there's Slack. And then Slack, I don't know if it's true, but it feels like Microsoft Teams is eating their lunch with bundling. And I'm curious, what do you think of bundling as a strategy to win long-term? And also, how do you compete against say, a Microsoft that may one day bundle your product for free, and you might be in big trouble?

**中文翻译:**
明白了。我想问一个非常微妙的问题，关于“捆绑销售”（Bundling）。HipChat 被 Slack 抢了生意，不一定是靠捆绑。但现在 Slack 似乎正被 Microsoft Teams 通过捆绑销售抢走生意。我很想知道，你如何看待捆绑销售作为长期获胜的策略？此外，如何与微软这样的巨头竞争？如果有一天他们把你的产品免费捆绑销售，你可能就麻烦大了。

---

### [00:53:22] [Carilu Dietrich]

**English:**
I think it's two separate questions, so let me take them separately. The first is, what do I think about bundling? So small and medium-sized companies will go from being a single product company to a multi-product company in order to progress. Because you need a diversified financial model, because you need to be able to sell new products into your customer base who should already be friendly to you if they like your products. And because you need to really expand your total addressable market to get to be $1 billion or $2 billion company. But I believe in bundling is a growth strategy.
Specifically for product led growth companies, bundling is not a great land strategy. So at Atlassian, we had a number of products and experimented with different bundled lands. And it really slowed down the product led growth motion. So we ended up going back to land with a single product, high velocity, single person uses it quickly starts to get value, and then come in with other things.
So from that perspective, product led growth bundling is not very effective. Bundling for a sales led motion is pretty effective when you're at the right stage of growth.
And then as far as the question of competing against Microsoft, there's these two parts of the philosophies. A best of breed and an all in one. An Oracle was an all in one, and Microsoft is an all in one. You can buy all the things and your CFO can get a discount by spending a whole bunch of money on a bunch of things. But in the all-in one, some of the pieces aren't as good as the best of breed.
And so Slack for a long time was the best of breed. People were willing to pay more because they thought it was markedly better than the other instant messaging options.
But there's shifts between best of breed and all in one in economic wins. So right now, CFOs are putting the squeeze. Is Slack really that much better than Microsoft if the Microsoft one is free with all of our other purchases? It's tough. It's tough to go head-to-head with a powerful, big investing, all-in-one competitor. The only way to win is to be the best and have a product that's so much better, that it's worth the extra money.

**中文翻译:**
这是两个独立的问题，我分开回答。首先，关于捆绑销售：中小规模公司为了进步，会从单一产品公司转向多产品公司。因为你需要多元化的财务模型，需要向已经认可你的老客户销售新产品，也需要扩大总可寻址市场（TAM）以成为 10 亿或 20 亿美金的公司。所以我相信捆绑销售是一种增长策略。
但具体到 PLG 公司，捆绑销售并不是一个好的“切入”（Land）策略。在 Atlassian，我们尝试过用捆绑包切入，结果大大减缓了 PLG 的势头。所以我们最终回到了用单一产品切入的模式：高速度、单人使用、快速获益，然后再引入其他产品。
所以从这个角度看，PLG 的捆绑销售不太有效。而对于销售驱动（Sales-led）的模式，在合适的增长阶段，捆绑销售非常有效。
至于竞争微软的问题，这涉及两种哲学：“最佳组合”（Best of breed）和“全能套装”（All-in-one）。甲骨文和微软都是全能套装。你可以买下所有东西，CFO 也能因为大批量采购获得折扣。但在全能套装中，某些组件肯定不如“最佳组合”里的产品好。
Slack 长期以来就是“最佳组合”的代表。人们愿意付更多钱，因为觉得它明显优于其他即时通讯工具。
但在经济低迷时期，天平会向“全能套装”倾斜。现在 CFO 们在收紧开支：如果微软的工具随其他采购免费赠送，Slack 真的值得我们额外花那么多钱吗？与一个财大气粗、全方位投入的全能型对手正面交锋非常困难。唯一的获胜之道就是做到极致，让产品好到让客户觉得多花钱也值得。

---

### [00:55:37] [Lenny]

**English:**
Interesting. So essentially in a tough environment, bundling is most effective almost. And then this other interesting point about [inaudible 00:55:47], you want to stay focused on one specific pain point. What is it that Atlassian tried to do that they tried to pitch all your planning products in one suite? Is that kind of what we-

**中文翻译:**
很有趣。所以本质上在艰难环境下，捆绑销售几乎是最有效的。另一个有趣的观点是，你要专注于一个特定的痛点。Atlassian 当时是尝试把所有的规划产品作为一个套件来推销吗？

---

### [00:55:59] [Carilu Dietrich]

**English:**
Well, Jira was the issue tracking. And then we also had Confluence, which was the Wiki page. So let's say there was a business bundle that could have been HipChat, Confluence and Jira. Or there were developer combinations that could have been Jira, Bitbucket, and maybe Confluence too for an engineering team.
Basically, if you have to evaluate multiple products to purchase something, it's not a fast and easy online self-service buy. Because you're like, "Do I need all three products? Can I break them apart? Do they all work? Are each of them best of breed?" Whereas if you're like, "I need issue tracking, I'm going to buy Jira, this looks good. I've tried it out, I'm ready to go." That can happen in seven days. Whereas if you add in multiple products, it takes more days and just leads to fewer conversions.

**中文翻译:**
是的。Jira 是问题追踪，Confluence 是维基页面。假设有一个业务捆绑包包含 HipChat、Confluence 和 Jira；或者针对工程团队的 Jira、Bitbucket 和 Confluence 组合。
基本上，如果你在购买时需要评估多个产品，那就不是一个快速简单的在线自助购买了。因为你会想：“我真的需要这三个吗？能拆开买吗？它们都好用吗？每一个都是顶尖的吗？”而如果你只是想：“我需要问题追踪，我要买 Jira，这个看起来不错，我试过了，下单。”这可能在 7 天内完成。一旦加入多个产品，决策时间就会拉长，转化率就会下降。

---

### [00:56:52] [Lenny]

**English:**
That makes absolute sense. I can see someone thinking the complete opposite and then now realizing how we see. I see why this isn't working.

**中文翻译:**
这完全说得通。我能想象有人会想当然地认为应该捆绑，现在才明白为什么行不通。

---

### [00:56:58] [Carilu Dietrich]

**English:**
You should always test it. Right? I mean, the secret to product led growth is can you test it? And so we tested everything. We tried bundles. We didn't try bundles. We tried different things in the bundles. We tried different days. Data led insights are better than anything any pundits would say on a podcast.

**中文翻译:**
你应该永远去测试，对吧？PLG 的秘诀就是测试。我们测试了一切：尝试捆绑，不尝试捆绑，尝试捆绑包里的不同组合，尝试不同的时间。数据驱动的洞察比任何专家在播客里说的话都管用。

---

### [00:57:17] [Lenny]

**English:**
Amazing. Well with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
太棒了。那么，我们进入了非常令人兴奋的闪电问答环节。准备好了吗？

---

### [00:57:22] [Carilu Dietrich]

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [00:57:23] [Lenny]

**English:**
Okay. What are two or three books that you recommended most to other people?

**中文翻译:**
好的。你向别人推荐最多的两三本书是什么？

---

### [00:57:28] [Carilu Dietrich]

**English:**
The number one book is a life book called Tao Te Ching, the Stephen Mitchell translation. And the Tao Te Ching is a philosophy about the flow of life. And I love it. I've carried the Pocket Guide with me for 25 years.
The second one is business focused. Never Split the Difference, which is a great book about negotiating written by a former CIA hostage negotiator, which also helps me with negotiations at work and with my children. So that's a great book.

**中文翻译:**
第一本是关于人生的书，叫《道德经》（Tao Te Ching），我推荐 Stephen Mitchell 的译本。它是一种关于生命流动的哲学。我非常喜欢它，随身携带它的口袋指南已经 25 年了。
第二本是关于商业的，《掌控谈话》（Never Split the Difference）。这是一本由前 FBI 人质谈判专家写的关于谈判的杰作，它不仅在工作中帮我谈判，在对付我的孩子时也很有用。那是一本很棒的书。

---

### [00:57:58] [Lenny]

**English:**
Actually, I've been trying to read that book on audio. What's something you've taken away from me? Because the stories are so interesting and I'm always like, "What should I actually do in my day-to-day life?" What stuck with you?

**中文翻译:**
实际上，我一直在听这本书的音频版。你从中获得了什么启发？因为里面的故事太精彩了，但我总在想：“在日常生活中我到底该怎么做？”什么让你印象最深？

---

### [00:58:08] [Carilu Dietrich]

**English:**
It's kind of the obvious thing that I wasn't good at. It's that you just really want to put yourself so deeply in the shoes of the other person, that you can figure out what make the win for both of you, right? Basically he says, "You can't win the negotiation by strong arming what you want. You really get to get to a win-win," which is probably every negotiation book ever. But he texturizes it so much. So I just felt like I was really able to... In my last office, we moved last year. I actually had the CliffNotes of his book printed out and posted on my wall because he had a series of questions to help you get deeper and deeper into the mindset behind people.
And connected, but not connected the book How To Win Friends and Influence People, that's the 1932 bestseller, is basically that. People don't want to hear about you. They want you to be thinking about them. And then you can make friends with them, or you can negotiate with them, or you can get your hostage back.

**中文翻译:**
那是我以前不擅长的一点：你真的需要深度换位思考，弄清楚什么能让双方共赢。基本上他说：“你不能靠强行索取你想要的东西来赢得谈判，你必须达成双赢。”这可能是每本谈判书都会说的，但他描述得非常具体。在我的旧办公室（我们去年搬家了），我甚至把这本书的要点打印出来贴在墙上，因为他有一系列问题能帮你深入了解对方的心理。
还有一本相关的书是《人性的弱点》（How To Win Friends and Influence People），那是 1932 年的畅销书，核心也是：人们不想听你的事，他们希望你考虑他们的事。这样你就能交到朋友，或者完成谈判，或者救回你的人质。

---

### [00:59:08] [Lenny]

**English:**
I read How to Win Friends and Influence People when I was very young. And specifically, the chapters about there's no better sound in the world to someone than their name. Carilu.

**中文翻译:**
我很年轻时就读过《人性的弱点》。特别是那一章：对一个人来说，世界上最好听的声音莫过于他自己的名字。Carilu。

---

### [00:59:19] [Carilu Dietrich]

**English:**
It's true. Thank you. You said it correctly.

**中文翻译:**
是真的。谢谢，你读得很准。

---

### [00:59:22] [Lenny]

**English:**
Okay, moving on. Favorite recent movie or TV show?

**中文翻译:**
好的，继续。最近最喜欢的电影或电视节目？

---

### [00:59:26] [Carilu Dietrich]

**English:**
My favorite movie is Everything Everywhere All at Once. It's basically a sci-fi about all the different ways your life could turn out if you made different choices. And it was really a mind bender that made me think about all the different ways tiny decisions have changed my life, but then also an appreciation for the life that you have. At the end, it doesn't ruin the story, but she has this love of what she has, even though it's not as good or as different as some of the other options.

**中文翻译:**
我最喜欢的电影是《瞬息全宇宙》（Everything Everywhere All at Once）。它基本上是一部科幻片，讲述了如果你做出不同的选择，你的生活会有多少种可能。它非常烧脑，让我思考微小的决定如何改变了我的生活，同时也让我更加珍惜现有的生活。在结尾（不剧透），她对现有的生活充满了爱，尽管它可能不如其他选项那么完美或不同。

---

### [00:59:26] [Lenny]

**English:**
I love it.

**中文翻译:**
我喜欢这部电影。

---

### [00:59:58] [Carilu Dietrich]

**English:**
So I bought this poster. I don't think you can see it on the bath, but it says, "Gratitude turns what we have into enough."

**中文翻译:**
所以我买了这张海报，你可能看不清，上面写着：“感恩能让现有的变得足够。”

---

### [01:00:07] [Lenny]

**English:**
Very Buddhist.

**中文翻译:**
非常有禅意。

---

### [01:00:08] [Carilu Dietrich]

**English:**
I like it. Read the Tao Te Ching.

**中文翻译:**
我喜欢这种感觉。去读读《道德经》吧。

---

### [01:00:10] [Lenny]

**English:**
Not a Post-it, but art. Another teaching from Carilu. I think this needs to be a second newsletter of yours. Life advice.

**中文翻译:**
不是便利贴，而是艺术品。Carilu 的又一教诲。我觉得这应该成为你的第二个 Newsletter：人生建议。

---

### [01:00:20] [Carilu Dietrich]

**English:**
Which is funny. I've been thinking about that one. It would be called The Tao of Hypergrowth.

**中文翻译:**
很有趣，我确实考虑过。它会叫《高速增长之道》（The Tao of Hypergrowth）。

---

### [01:00:25] [Lenny]

**English:**
Oh my God. I love that.

**中文翻译:**
天哪，我太喜欢这个名字了。

---

### [01:00:26] [Carilu Dietrich]

**English:**
And actually, I was thinking about doing it and taking actual clips from the Tao Te Ching, and doing textural analysis about how it applies to our. I've been thinking about this actual podcast for a while because I used to want to do the... I mean blog, the Tao of Parenthood. Because basically parenting, you try to control and fix all the things you didn't do right in your life. But actually, it's the act of providing freedom that lets them go out and explore and then come back to your way of being. So, I don't know. The Tao Te Ching, I love it.

**中文翻译:**
实际上，我考虑过引用《道德经》的原文，并进行文本分析，看看它如何应用于我们的领域。我也想过写一个博客叫《育儿之道》（The Tao of Parenthood）。因为育儿本质上是你试图控制并修正自己人生中没做对的事，但实际上，提供自由让他们去探索，然后回归自我，才是真谛。总之，《道德经》，我真的很爱它。

---

### [01:00:58] [Lenny]

**English:**
I see so many opportunities. You got to stop what you're doing. Just write all these things.

**中文翻译:**
我看到了这么多机会。你得停下手头的事，把这些都写下来。

---

### [01:01:02] [Carilu Dietrich]

**English:**
I know. But I love the hypergrowth customers, clients.

**中文翻译:**
我知道，但我太爱那些高速增长的客户了。

---

### [01:01:06] [Lenny]

**English:**
All right. Next question. What is a favorite interview question that you like to ask?

**中文翻译:**
好的。下一题。你最喜欢问的面试问题是什么？

---

### [01:01:11] [Carilu Dietrich]

**English:**
So this is a little heavy, but it actually is my favorite. It's, "How many people have you fired? And tell me about each of the experiences." So the reason I ask this question is because generally, I'm managing teams of managers. And generally, I need people who have managed many people for a longer period of time. Or even if they're junior managers, how long and how many people they've managed is indicated by how many people they've fired. Because if you've never fired anyone, then you haven't managed very many people for very long, unfortunately.
Firing people is the hardest part of a leader's career. So how they talk about it, their compassion, and their need to drive the business, and the circumstances, "Was it layoffs? How did that work? Did you have to performance manage someone out? How did it work? Did you just have to restructure the team because of business goals? How did it work?" Gives you a lot of insight into their experience and their humanity in a way that they're not prepared for. So you really get the real story, and get a sense for what they would be like as a leader under a lot of pressure and difficult situations.

**中文翻译:**
这个问题有点沉重，但确实是我最喜欢的。它是：“你解雇过多少人？请告诉我每一次的经历。” 我问这个的原因是，我通常在管理“经理人的经理”。我需要那些长期管理过很多人的人。即使是初级经理，他们管理了多久、管理了多少人，通常可以通过他们解雇过多少人来体现。因为如果你从未解雇过任何人，不幸的是，说明你管理的人还不够多，时间也不够长。
解雇员工是领导者职业生涯中最难的部分。通过他们如何谈论这件事、他们的同情心、他们驱动业务的需求以及当时的情况（是裁员吗？怎么操作的？是绩效管理劝退吗？是业务调整导致的重组吗？），你可以深入了解他们的经验和人性，而这些是他们无法提前准备的。你能听到真实的故事，并感受到他们在巨大压力和困难局面下会是怎样的领导者。

---

### [01:02:17] [Lenny]

**English:**
I've never heard that one before and I love it. Reminds me of a episode with Matt Mochary where we talk about how to lay people off really successfully and elegantly.

**中文翻译:**
我以前从未听过这个问题，我太喜欢了。这让我想起和 Matt Mochary 的那一集，我们聊过如何成功且体面地裁员。

---

### [01:02:26] [Carilu Dietrich]

**English:**
It's a hard.

**中文翻译:**
这很难。

---

### [01:02:27] [Lenny]

**English:**
Yeah. Next question. What's a favorite product that you've recently discovered that you love?

**中文翻译:**
是的。下一题。你最近发现并喜爱的产品是什么？

---

### [01:02:34] [Carilu Dietrich]

**English:**
So I follow my favorite products to the companies that I advise. I love 1Password. I've got my 85-year-old grandfather and all of my family and friends set up on it. I love the cross-platform nature.
I love Miro and whiteboards. I joined Productboard because of this cross-company alignment and views into what's coming up on the roadmap, which is really the most important thing for the company. Momentum, as we talked about, having a great product and a great product strategy.
And then I'm dabbling in all the AI things. I want to be excellent in AI visualization and art. I'm experimenting with Midjourney, but still kind of flailing. I've hired my 13-year old as my strategic advisor. And yeah, I'd love to work for OpenAI and ChatGPT. It's really interesting.

**中文翻译:**
我会追随我喜爱的产品去咨询那些公司。我爱 1Password，我让我 85 岁的祖父以及所有的亲友都用上了它。我喜欢它的跨平台特性。
我爱 Miro 和它的白板。我加入 Productboard 是因为它可以实现跨公司的一致性，并能洞察产品路线图，这对于公司的势能至关重要。
此外，我也在涉猎所有的 AI 领域。我想在 AI 视觉和艺术方面做得出色。我正在尝试 Midjourney，但还在摸索中。我聘请了我 13 岁的孩子担任我的战略顾问。是的，我很想为 OpenAI 和 ChatGPT 工作，那真的很有趣。

---

### [01:03:23] [Lenny]

**English:**
What's something relatively minor that you've changed in the way a product is built or just the company operates, that has led to tremendous impact on their ability to execute?

**中文翻译:**
在产品构建或公司运作方式上，你做过什么相对微小但对执行力产生巨大影响的改变？

---

### [01:03:33] [Carilu Dietrich]

**English:**
On the product side, one of the concepts that I really like is the Amazon concept around writing the press release at the beginning of a product ideation. So one of the issues between marketing and product is the product will work so hard on something, and there'll be lots of different features, that it won't really be a theme that the marketing team can talk about. And then someone hands it to marketing and says, "Make this marketable." One of my mentors had this comment, "It's a bag of doorknobs." What do I do with this bag of doorknobs? Who wants to buy a bag of doorknobs? They want to buy the door and the concept.
So I like this idea of writing a press release. Start with the end in mind, and then negotiate. Is this good enough? Will this really resonate? Or is this really what we're trying to build? Or is this really the outcome we're trying to get with the product? So I've heard about Amazon do it. We experimented with it at Classy. I haven't done it at mass scale, but I love the concept.

**中文翻译:**
在产品方面，我非常喜欢亚马逊的一个概念：在产品构思之初就撰写“新闻稿”（Press Release）。营销和产品之间的一个常见问题是，产品团队辛苦开发了很多功能，但没有一个营销团队可以拿来宣传的主题。然后有人把东西扔给营销说：“把它卖出去。”我的一位导师曾评价这叫“一袋门把手”。我拿这一袋门把手能干嘛？谁想买一袋门把手？人们想买的是门和门背后的概念。
所以我喜欢写新闻稿这个主意。以终为始，然后进行博弈：这足够好吗？真的能引起共鸣吗？这真的是我们要造的东西吗？这真的是我们想要的产品结果吗？我听说亚马逊是这么做的，我们在 Classy 也尝试过。我还没大规模推广过，但我非常认同这个理念。

---

### [01:04:31] [Lenny]

**English:**
Final question. I know you're a meditator. We've talked a little bit about your Buddhist nature. What's one tip for people that have been trying to meditate and just can't make it happen? What's your one tip for helping people meditate more often?

**中文翻译:**
最后一个问题。我知道你练习冥想，我们也聊过你性格中带有禅意的一面。对于那些尝试冥想却一直无法进入状态的人，你有什么建议？如何帮助人们更频繁地冥想？

---

### [01:04:44] [Carilu Dietrich]

**English:**
So I'm a cheater because I was groomed to meditate. I don't remember how early, but I remember that the first meditations my mom had me listen to was a rainbow butterfly as we fell asleep when I was in kindergarten.
So I've been meditating my whole life, with mixed success. And the real secret is just that there's no right way, that there's no wrong way. That it's just making the time to be present, and breathe, and sense, and be here now.
And so I use guided meditations mostly, because I'm not the best at quieting my own mind. I'm thrifty. So I use some free meditations. I use Tara Brach, who's a great meditator, who has short and long concept meditations.
And I like this old one called Meditation Oasis, which actually isn't in publishing anymore, but it's still a podcast. And I re-listen to all theirs over and over. So stick with it is the secret to meditation, and any benefits you get from being present in meditation, hopefully carry over to be being present in life.

**中文翻译:**
在这方面我有点“作弊”，因为我从小就被培养冥想。我不记得具体多早，但我记得幼儿园时，我妈妈让我听着“彩虹蝴蝶”的冥想入睡。
所以我一辈子都在冥想，效果时好时坏。真正的秘诀是：冥想没有正确或错误的方法。它只是花时间让自己处于当下，呼吸、感知，并“此时此刻”地存在。
我主要使用引导式冥想，因为我不擅长让自己的大脑安静下来。我很节俭，所以用一些免费资源。我推荐 Tara Brach，她是一位伟大的冥想导师，有长短不一的主题冥想。
我还喜欢一个叫《Meditation Oasis》的老节目，虽然它不再更新了，但播客还在。我会反复听。所以，坚持下去就是冥想的秘诀。你在冥想中获得的“活在当下”的好处，希望能延伸到你的现实生活中。

---

### [01:05:51] [Lenny]

**English:**
My whole body just relaxed as you were talking through all that. So you have a skill. Carilu, this was amazing. We learned how to grow products, how to live better lives, how to become more mindful. Two final questions. Where can folks find you online if they want to learn more, reach out? And/or how can listeners be useful to you?

**中文翻译:**
听你说话时，我全身都放松了。你确实有一套。Carilu，这期节目太棒了。我们学习了如何增长产品、如何过更好的生活、如何变得更具正念。最后两个问题：如果大家想了解更多或联系你，可以在哪里找到你？以及，听众可以为你提供什么帮助？

---

### [01:06:09] [Carilu Dietrich]

**English:**
Follow me on LinkedIn, or I have a new blog carilu.com on Substack. Thanks to Lenny for the inspiration. And I still have one more advisory slot open, and I'd love to work with more AI companies. I just joined Weights & Biases in the ML op space. But if you know of other great scale up AI companies, I'd love to help junior marketing executives or first time founders see what the next stage of growth looks like and get there.

**中文翻译:**
可以在 LinkedIn 上关注我，或者访问我在 Substack 上的新博客 carilu.com。感谢 Lenny 提供的灵感。我目前还有一个咨询名额，我很想与更多的 AI 公司合作。我刚加入了 ML Ops 领域的 Weights & Biases。如果你知道其他优秀的、处于规模化阶段的 AI 公司，我很乐意帮助他们的初级营销高管或初次创业的创始人预见下一阶段的增长并达成目标。

---

### [01:06:39] [Lenny]

**English:**
Amazing. And again, if they are interested in that, how do they reach out to you?

**中文翻译:**
太好了。如果他们感兴趣，该如何联系你？

---

### [01:06:43] [Carilu Dietrich]

**English:**
On LinkedIn or through carilu.com.

**中文翻译:**
通过 LinkedIn 或者 carilu.com。

---

### [01:06:47] [Lenny]

**English:**
Amazing. Carilu, thank you again so much for making time and for being here.

**中文翻译:**
太棒了。Carilu，再次感谢你抽时间来到这里。

---

### [01:06:50] [Carilu Dietrich]

**English:**
Thanks for having me, Lenny.

**中文翻译:**
谢谢你的邀请，Lenny。

---

### [01:06:51] [Lenny]

**English:**
Bye everyone.

**中文翻译:**
大家再见。

---

### [01:06:51] [Carilu Dietrich]

**English:**
Bye.

**中文翻译:**
再见。

---

### [01:06:55] [Lenny]

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。