# Carole Robin - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Carole Robin.

---

### [00:00:00] Lenny Rachitsky

**English:**
Many people told you your class at Stanford made them feel like their entire college tuition was worth it.

**中文翻译:**
很多人告诉你，他们在斯坦福上的这门课让他们觉得整笔大学学费都值了。

---

### [00:00:05] Carole Robin

**English:**
Even more rewarding for me are the, "I'm pretty sure your class just saved my marriage."

**中文翻译:**
对我来说，更有成就感的是听到那些话：“我很确定你的课刚刚挽救了我的婚姻。”

---

### [00:00:11] Lenny Rachitsky

**English:**
I want to talk about how to give feedback well.

**中文翻译:**
我想谈谈如何更好地提供反馈。

---

### [00:00:12] Carole Robin

**English:**
I feel that you don't care and I feel you're being insensitive are not feelings, and that's where we make our biggest mistakes when it comes to feedback.

**中文翻译:**
“我觉得你不在乎”和“我觉得你太不敏感了”并不是感受。这就是我们在提供反馈时犯下的最大错误。

---

### [00:00:19] Lenny Rachitsky

**English:**
How do you avoid people getting defensive?

**中文翻译:**
你如何避免人们产生防御心理？

---

### [00:00:22] Carole Robin

**English:**
Questions that start with what, when, where, how. Stay away from why.

**中文翻译:**
提问要以“什么”、“什么时候”、“在哪里”、“如何”开头。远离“为什么”。

---

### [00:00:25] Lenny Rachitsky

**English:**
I think it might be helpful to talk about this concept that you call the three realities.

**中文翻译:**
我想聊聊你提到的那个被称为“三个现实”的概念，这应该会很有帮助。

---

### [00:00:28] Carole Robin

**English:**
We don't understand that we are only privy to two out of the three, so I know what's going on for me and I know what I did. I have no idea what happened on your end.

**中文翻译:**
我们不明白自己只能了解三者中的两个：我知道我这边发生了什么，我知道我做了什么。但我完全不知道你那边发生了什么。

---

### [00:00:37] Lenny Rachitsky

**English:**
That's a really profound point that anger is a secondary emotion. Really what's going on is you're afraid or you're hurt.

**中文翻译:**
“愤怒是一种次生情绪”是一个非常深刻的观点。实际上发生的是你感到恐惧或受到了伤害。

---

### [00:00:43] Carole Robin

**English:**
What a disservice to not help people understand that anger is a distancing emotion and there are other emotions that are connecting.

**中文翻译:**
如果不让人们理解愤怒是一种“疏远型情绪”，而其他情绪是“连接型情绪”，那真是太遗憾了。

---

### [00:00:54] Lenny Rachitsky

**English:**
Today my guest is Carole Robin. For over 20 years, Carole taught the legendary course at Stanford's Graduate School of Business, nicknamed Touchy Feely technically called Interpersonal Dynamics, which helps people learn how to build strong relationships and become much more effective leaders. She then went on to start a non-profit called Leaders in Tech, which brings these same lessons to leaders of high-tech growth companies, and she also wrote an incredibly impactful book called Connect, which distills all the key insights and lessons from her decades running this course. I've had so many friends go through the Stanford course or the Leaders in Tech program, and every single one of them was transformed in terms of how they relate to other people, how they communicate, and how they lead. In my conversation with Carole, we talk about why we're often trapped in mental models that we formed when we were younger and how they now limit us and limit our potential and our ways of seeing world.

**中文翻译:**
今天的嘉宾是 Carole Robin。20 多年来，Carole 一直在斯坦福大学商学院教授一门传奇课程，绰号叫“感性课”（Touchy Feely），正式名称是“人际动力学”。这门课旨在帮助人们学习如何建立牢固的人际关系，并成为更高效的领导者。随后，她创办了一家名为 Leaders in Tech 的非营利组织，将这些课程带给高科技成长型公司的领导者。她还写了一本极具影响力的书《连接》（Connect），汇集了她数十年教学中的核心见解和教训。我有许多朋友参加过斯坦福的课程或 Leaders in Tech 项目，他们在处理人际关系、沟通和领导方式方面都发生了蜕变。在与 Carole 的交谈中，我们探讨了为什么我们经常被年轻时形成的“心智模型”所困，以及这些模型现在如何限制了我们、限制了我们的潜力和看待世界的方式。

---

### [00:01:49] Lenny Rachitsky (Continued)

**English:**
Why disclosing 15% more than you naturally feel comfortable will make you a more effective leader? Why there are actually three realities around us at all times and how that insight changes the way you relate to people. We also get into how to give feedback to anyone about anything, why vulnerability is so essential to great leadership, how to build exceptional relationships, and why they're so important and so much more. This is a very special and very unique episode and I am so excited to bring it to you. With that, I bring you Carole Robin. After a short word from our sponsors, and if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. This episode is brought to you by Eppo. Eppo is a next generation A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams.

**中文翻译:**
为什么比你自然感到舒适的程度多透露 15% 的信息会让你成为更高效的领导者？为什么我们周围始终存在“三个现实”，以及这一见解如何改变你与人交往的方式。我们还深入探讨了如何就任何事情向任何人提供反馈，为什么“脆弱感”对卓越的领导力至关重要，如何建立卓越的人际关系，以及它们为何如此重要等等。这是一个非常特别且独特的章节，我很高兴能把它带给大家。下面，让我们欢迎 Carole Robin。在听完赞助商的简短介绍后，如果你喜欢这个播客，请不要忘记在您最喜欢的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最佳方式，也对本播客有巨大帮助。本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。

---

### [00:02:43] Lenny Rachitsky (Continued)

**English:**
Companies like Twitch, Miro, ClickUp and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and for understanding the performance of new features. And Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does. When I was at Airbnb, one of the things that I left most was our experimentation platform where I could set up experiments, easily, troubleshoot issues, and analyze performance all on my own. EPO does all that and more with advanced statistical methods that can help you shave weeks off experiment time and accessible UI for diving deeper into performance and out-of-the-box reporting that helps you avoid annoying prolonged analytics cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the A/B testing flywheel. Eppo powers experimentation across every use case, including product growth, machine learning, monetization, and email marketing.

**中文翻译:**
Twitch、Miro、ClickUp 和 DraftKings 等公司都依赖 Eppo 来支持他们的实验。实验对于推动增长和了解新功能的表现越来越重要。Eppo 能够帮助你提高实验速度，同时解锁其他商业工具无法提供的严谨深度分析。当我在 Airbnb 时，我最怀念的东西之一就是我们的实验平台，在那里我可以独立设置实验、轻松排除故障并分析性能。Eppo 实现了这一切，甚至更多，它拥有先进的统计方法，可以帮你缩短数周的实验时间，还有易用的 UI 用于深入研究性能，以及开箱即用的报告，帮你避免烦人且漫长的分析周期。Eppo 还让你能轻松与团队分享实验见解，为 A/B 测试飞轮激发新灵感。Eppo 支持各种场景的实验，包括产品增长、机器学习、商业化和邮件营销。

---

### [00:03:40] Lenny Rachitsky (Continued)

**English:**
Check out Eppo at geteppo.com/lenny and 10X your experiment velocity. That's geteppo.com/lenny. Let me tell you about CommandBar. If you're like me and most users I've built product for you probably find those little in-product pop-ups, really annoying, want to take a tour? Check out this new feature, and these Pop-ups are becoming less and less effective since most users don't read what they say. They just want to close them as soon as possible, but every product builder knows that users need help to learn the ins and outs of your product. We use so many products every day and we can't possibly know the ins and outs of everyone. CommandBar is an AI-powered toolkit for product growth, marketing and customer teams to help users get the most out of your product without annoying them.

**中文翻译:**
请访问 geteppo.com/lenny 查看 Eppo，让你的实验速度提升 10 倍。地址是 geteppo.com/lenny。接下来我再聊聊 CommandBar。如果你像我以及我曾为其开发产品的多数用户一样，你可能会觉得产品内部的那些小弹窗非常烦人——“想参观一下吗？”、“看看这个新功能”。这些弹窗正变得越来越低效，因为大多数用户根本不看内容，只想尽快关掉它们。但每个产品开发者都知道，用户需要帮助才能了解产品的方方面面。我们每天使用这么多产品，不可能了解每一个产品的细节。CommandBar 是一个由 AI 驱动的工具包，专为产品增长、营销和客户团队设计，旨在帮助用户充分利用你的产品，同时不让他们感到厌烦。

---

### [00:04:25] Lenny Rachitsky (Continued)

**English:**
They use AI to get closer to user intent, so they have search and chat products that let users describe what they're trying to do in their own words and then see personalized results like customer walkthroughs or actions, and they do pop-ups too, but their nudges are based on in-product behaviors like confusion or intent classification, which makes them much less annoying and much more impactful. This works for web apps, mobile apps and websites, and they work with industry-leading companies like Gusto, Freshworks, HashiCorp and LaunchDarkly. Over 15 million end-users have interacted with CommandBar. To try out CommandBar you can sign up at commandbar.com/lenny and you can unlock an extra 1,000 AI responses per month for any plan. That's commandbar.com/lenny. Carole, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
他们利用 AI 来更贴近用户意图，因此他们拥有搜索和聊天产品，让用户可以用自己的语言描述他们想做的事情，然后看到个性化的结果，比如客户演示或操作建议。他们也做弹窗，但他们的“微调”（nudges）是基于产品内行为的，比如用户困惑或意图分类，这使得它们不那么烦人，且更具影响力。这适用于 Web 应用、移动应用和网站。他们与 Gusto、Freshworks、HashiCorp 和 LaunchDarkly 等行业领先公司合作。已有超过 1500 万终端用户与 CommandBar 进行了交互。要试用 CommandBar，你可以在 commandbar.com/lenny 注册，任何方案都可以每月额外解锁 1000 条 AI 回复。地址是 commandbar.com/lenny。Carole，非常感谢你能来。欢迎来到本播客。

---

### [00:05:19] Carole Robin

**English:**
Thank you so much for having me, Lenny. I'm delighted to be here.

**中文翻译:**
非常感谢你邀请我，Lenny。很高兴来到这里。

---

### [00:05:22] Lenny Rachitsky

**English:**
I've heard from so many people over the years how much you and your course have impacted their life, both friends of mine, and also people when I shared on Twitter that you were coming on the podcast, so many people left comments just like, "Oh my God, that course and Carole's changed my life in so many ways." So I am really excited to have you here. I'm really honored to have you here.

**中文翻译:**
这些年来，我听很多人说过你和你的课程对他们的生活产生了多么大的影响，其中既有我的朋友，也有当我在 Twitter 上分享你要来参加播客时留言的网友。很多人评论说：“天哪，那门课和 Carole 在很多方面改变了我的生活。”所以，我真的很高兴你能来。我很荣幸能邀请到你。

---

### [00:05:23] Carole Robin

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:05:43] Lenny Rachitsky

**English:**
I wanted to start with when we were preparing for this podcast, you shared this quote with me. You told me that "I was put on this planet to help people learn that it's possible to learn how to build and develop robust, meaningful relationships." What are robust, meaningful relationships and why are they important to you? Why are they important to people?

**中文翻译:**
我想从我们准备这次播客时你分享给我的一句话开始。你告诉我：“我来到这个星球是为了帮助人们了解到，学习如何建立和发展稳固且有意义的人际关系是可能的。”什么是稳固且有意义的人际关系？为什么它们对你很重要？为什么它们对人们很重要？

---

### [00:06:05] Carole Robin

**English:**
I think that most people experience a richer, fuller, more meaningful life when they have at least some high quality relationships or maybe put the other way. If you have none, it's unlikely you're going to experience quite as rich and full a life. So I often talk about relationships exist on a continuum. At one end of the continuum is contact and no connection, or we could also say dysfunction. And by the way, contact no connection. Those are thousands of Facebook friends. Those are not relationships and those are not friends in my vocabulary. At the other end of the continuum is what my co-author David Bradford and I came to call exceptional, and exceptional relationships have a particular set of characteristics that I can get into if you want to. But before I even do that, we're not suggesting, and I'm not suggesting that everybody needs to turn every one of their relationships into something exceptional.

**中文翻译:**
我认为，当人们拥有至少一些高质量的人际关系时，他们会体验到更丰富、更充实、更有意义的生活。或者换句话说，如果你一个都没有，你不太可能体验到那么丰富和充实的生活。所以我经常说，人际关系存在于一个连续的光谱上。光谱的一端是“有接触但无连接”，或者我们也可以说是“功能失调”。顺便说一下，“有接触无连接”指的就是那成千上万个 Facebook 好友。在我的词汇库里，那些不是人际关系，也不是朋友。在光谱的另一端，是我和合著者 David Bradford 所称的“卓越关系”。卓越关系有一套特定的特征，如果你愿意，我可以深入探讨。但在那之前，我们并不是建议，我也不是建议每个人都需要把他们的每一段关系都变成卓越关系。

---

### [00:07:05] Carole Robin (Continued)

**English:**
That would be, first of all, impractical, second of all, unnecessary. But it turns out that the skills you need to move along that continuum actually take you from contact and no connection and dysfunction to at least functional and robust. And then once you've acquired those skills, then you can decide whether or not you want to take a few of those relationships a lot farther, take them all the way to exceptional, but at least you've gained what you need to know in order to get to functional and robust. And I believe if we had a critical mass of human beings on this planet who had those skills and knew how to get to at least robust and functional, we wouldn't just have more functional teams and organizations, we'd have stronger communities, we'd have more functional schools. We might, in my wildest dreams, even have a more functional government. And so that's my life's mission.

**中文翻译:**
首先，那是不切实际的；其次，也没必要。但事实证明，你在这一光谱上移动所需的技能，实际上能带你从“有接触无连接”和“功能失调”走向至少“功能健全且稳固”。一旦你掌握了这些技能，你就可以决定是否要将其中几段关系推向更远，达到“卓越”的程度。但至少，你已经获得了达到“功能健全且稳固”所需的知识。我相信，如果这个星球上有足够多的人掌握了这些技能，知道如何至少达到稳固和功能健全的水平，我们不仅会有更高效的团队和组织，还会有更强大的社区、更完善的学校。在我最大胆的梦想中，甚至会有一个更高效的政府。这就是我的人生使命。

---

### [00:08:03] Lenny Rachitsky

**English:**
Hopefully this episode is going to actually do exactly that, help people build from-

**中文翻译:**
希望这一集节目能起到这样的作用，帮助人们建立——

---

### [00:08:07] Carole Robin

**English:**
From your mouth to God's ears.

**中文翻译:**
借你吉言（直译：从你口中传到上帝耳中）。

---

### [00:08:10] Lenny Rachitsky

**English:**
To give people a little more motivation to really dig in and pay deep attention to this. What are some of the benefits you've seen from people moving further along the spectrum, building more robust relationships and more exceptional relationships?

**中文翻译:**
为了让大家更有动力去深入研究并关注这一点，你能分享一下，当你看到人们在关系光谱上更进一步，建立起更稳固、更卓越的关系时，他们获得了哪些好处吗？

---

### [00:08:23] Carole Robin

**English:**
Obviously, I taught a course for many, many years at Stanford Business School, and it was the Stanford Business School, by the way. It wasn't hidden away somewhere in the psychology department. And that's because the premise of the course is that people do business with people not ideas, not products, not machines, not tactics, strategies, not even money, they do business with people. So you better get the people part right if you really want to succeed. And that interpersonal competence is a determinant of both personal and professional success. So, to your question, I've lost track of how many hundreds of emails and calls and visits I've had from former students who come to tell me I just became a CEO. I'm pretty sure I owe it all to you. I just raised my third round. I'm pretty sure I owe it all to you.

**中文翻译:**
显然，我在斯坦福商学院教了很多年课。顺便提一下，那是在商学院，而不是藏在心理学系的某个角落。这是因为这门课的前提是：人们是和“人”做生意，而不是和想法、产品、机器、战术、策略，甚至不是和金钱做生意。所以如果你真的想成功，最好把“人”的部分处理好。人际交往能力是个人和职业成功的决定因素。所以，回到你的问题，我已经记不清收到过多少前学生的邮件、电话和拜访了。他们来告诉我：“我刚当上 CEO，我很确定这全归功于你。”“我刚完成了第三轮融资，我很确定这全归功于你。”

---

### [00:09:20] Carole Robin (Continued)

**English:**
I just figured out how my co-founder and I are going to navigate this very difficult situation we're in. Thank you for everything you taught me, and those are exceedingly satisfying. And I'll tell you, even more rewarding for me are the, "I'm pretty sure your class just saved my marriage." I just reconciled my relationship with my brother who I hadn't talked to for two years because he voted for X and I voted for Y. We don't need to get into who X and Y are. And now I get thank you for finally writing a book because my VP of product didn't go to Stanford and doesn't understand what I'm talking about. So at least I bought them a book and now I've got more and more folks sending people to Leaders in Tech, which we can talk about later, which is the nonprofit I started after I left Stanford, so that more and more people can learn this from more than just a book.

**中文翻译:**
“我刚刚弄清楚了我和合伙人该如何度过眼前的难关。谢谢你教给我的一切。”这些反馈让我感到无比满足。而且我告诉你，对我来说更有成就感的是：“我很确定你的课挽救了我的婚姻。”“我刚刚和两年没说话的哥哥和解了，因为他投了 X 的票，而我投了 Y 的票。”（我们不需要讨论 X 和 Y 是谁）。现在我也收到感谢信，说谢谢我终于写了这本书，因为“我的产品副总裁没上过斯坦福，听不懂我在说什么，所以我至少给他们买了一本书”。现在有越来越多的人把员工送到 Leaders in Tech（我们稍后可以聊聊这个，这是我离开斯坦福后创办的非营利组织），这样更多的人就能通过书本以外的方式学习这些内容。

---

### [00:10:19] Lenny Rachitsky

**English:**
Amazing. And I think what I love, you also shared this point that many people told you that that one class at Stanford Business School at GSB was made them feel like their entire college tuition was worth it from that one class, which is so surprising because it's called Touchy Feely, it has nothing to do specifically with business.

**中文翻译:**
太棒了。我非常喜欢你分享的一点：很多人告诉你，斯坦福商学院（GSB）的那一门课就让他们觉得整笔大学学费都值了。这非常令人惊讶，因为这门课绰号叫“感性课”（Touchy Feely），听起来似乎与商业没有直接关系。

---

### [00:10:38] Carole Robin

**English:**
Except of course it has everything to do with business.

**中文翻译:**
当然，除了它其实与商业息息相关。

---

### [00:10:41] Lenny Rachitsky

**English:**
So to follow that thread, can you just talk about what this class is trying to do, what the goal of this class is and what actually goes on in this class? And again, people call this class Touchy Feely. I think it's technically called Interpersonal Dynamics.

**中文翻译:**
顺着这个话题，你能谈谈这门课到底是做什么的吗？它的目标是什么？课堂上到底发生了什么？再强调一下，人们叫它“感性课”，但正式名称应该是“人际动力学”。

---

### [00:10:57] Carole Robin

**English:**
That's correct.

**中文翻译:**
没错。

---

### [00:10:58] Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:10:58] Carole Robin

**English:**
That's correct. Yeah.

**中文翻译:**
没错，是的。

---

### [00:11:00] Lenny Rachitsky

**English:**
Yeah. What is this class all about? Help people understand what goes on here.

**中文翻译:**
这门课到底是关于什么的？请帮大家理解一下这里面发生了什么。

---

### [00:11:03] Carole Robin

**English:**
Well, first of all, it's a quarter long class at a really fundamental level we've already really talked about what goes on there. People learn how to be more interpersonally competent or how to connect with other people in more functional ways. And what I mean by connect is learn how I need to show up in order for you to trust me, in order for you to feel closer to me, in order for you to want to spend more time with me in a leadership. By the way, this is part of the leadership curriculum I taught, in a leadership sense that makes you more likely to want to follow me because in the end, that's the question leaders should ask themselves, "Why should somebody follow me?" And you know what? You could study other leaders. Why did somebody follow Steve Jobs? Why did somebody follow Ursula at Xerox? Why did some people follow Sheryl Sandberg or why should somebody follow me? Because I'm not any of those people. So the question I ask my students to sit in and now my Leaders in Tech participants to sit in is why should somebody follow you?

**中文翻译:**
首先，这是一个学期长的课程。在最基础的层面上，我们已经谈过它的内容了。人们学习如何提高人际交往能力，或者如何以更有效的方式与他人建立连接。我所说的“连接”，是指学习我需要以什么样的姿态出现，才能让你信任我，让你感到与我更亲近，让你愿意花更多时间和我在一起。顺便说一下，这是我教授的领导力课程的一部分。从领导力的角度来看，这会让你更愿意追随我，因为归根结底，领导者应该问自己的问题是：“别人为什么要追随我？”你可以研究其他领导者：为什么有人追随史蒂夫·乔布斯？为什么有人追随施乐的 Ursula？为什么有人追随谢丽尔·桑德伯格？但别人为什么要追随“我”呢？因为我不是他们中的任何一个。所以我让我的学生以及现在的 Leaders in Tech 参与者思考的问题是：别人为什么要追随你？

---

### [00:12:18] Carole Robin (Continued)

**English:**
Now, there are lots of reasons why people might follow you. You've got a great vision that's very inspiring. You have a product that they want to bring into the world. They think they may make a lot of money if they hitch their wagon to you. Those are all good reasons. But if you want to build a sustainable long-term legacy, then you probably want to think about showing up in a way that other people come to see you as a referent figure, somebody in their life that they say, "When I grow up, I want to be more like that." And that is a form of power. There's a lot of research that supports this, referent power. You're a referent figure, and then people are much likely to be open to your influence, and open to working harder, and open to doing some of the things that you believe are going to make you great as a whole organization.

**中文翻译:**
人们追随你的理由有很多。你可能有一个非常鼓舞人心的宏伟愿景；你有一个他们想推向世界的产品；他们觉得如果跟着你干，可能会赚大钱。这些都是很好的理由。但如果你想建立一份可持续的长期事业，那么你可能需要考虑以一种让别人把你视为“参照人物”（referent figure）的方式出现——成为他们生命中那种让他们感叹“等我长大了，我也想成为那样的人”的人。这是一种权力形式。有很多研究支持这一点，即“参照权力”（referent power）。当你成为一个参照人物时，人们就更有可能接受你的影响，更愿意努力工作，更愿意去做那些你认为能让整个组织变得伟大的事情。

---

### [00:13:27] Lenny Rachitsky

**English:**
The class is quite unusual in that there's not just a bunch of lectures and talks, there's a lot of experiential pieces where you have to do quite uncomfortable things in order to learn how to do this well. Can you share an example or two of some of the things you put people through, whatever you're able to share?

**中文翻译:**
这门课非常特别，因为它不只是有一堆讲座和谈话，还有很多体验式的环节，你必须做一些相当令人不适的事情，才能学会如何把这件事做好。你能分享一两个你让学生经历的例子吗？只要是方便分享的都可以。

---

### [00:13:45] Carole Robin

**English:**
Sure. I mean, I think that we don't learn to be... And I don't learn how to connect with you by reading about it in a book, which by the way is why it took us four years to write our book because at the end of every chapter there's a, here are things you can go do with what you just learned in the reading. And likewise in the class, the lectures are scaffolding on which you can hang your experience. But most of the learning happens in these small groups called T groups. The T stands for training, not therapy. And sometimes people think they sound like therapy, and they sometimes even experience them as feeling a little bit like therapy, but that's not what they are. We call them training groups. And what happens in that group is that there's 12 participants and two facilitators, and they are, for example, given a task, I might pair two students up and say, okay, you've got 10 minutes.

**中文翻译:**
当然。我的意思是，我们无法通过看书来学会如何与人连接。顺便说一下，这也是为什么我们花了四年时间才写完那本书，因为在每一章的结尾都有一个“你可以利用刚学到的内容去做的事情”。同样在课堂上，讲座只是一个脚手架，让你把经验挂在上面。但大部分学习发生在被称为“T 小组”（T groups）的小组中。T 代表训练（Training），而不是治疗（Therapy）。有时人们觉得它们听起来像心理治疗，甚至有时体验起来也有一点像，但它们并不是。我们称之为训练小组。小组里有 12 名参与者和两名引导员。例如，他们会被分配一个任务，我可能会把两个学生配成一对，然后说：好了，你们有 10 分钟时间。

---

### [00:14:51] Carole Robin (Continued)

**English:**
Allow the other person to get to know you. And that's the only instruction I give. Okay, so now you and I look at each other and we're like, "I don't know what the heck that's supposed to mean." And then maybe I share something about myself or maybe I ask you a question or who knows what I do with that, and then who knows what you do with that? So after 10 minutes, then I stop them and I say, okay, so take a moment and recognize that you just had a bunch of choices that you actually probably never even think about. You had a choice whether you began by sharing something or you waited for the other person to be in. You had a choice whether you began with a question, which was a nice, safe place to be, or whether you began with a disclosure.

**中文翻译:**
“让对方了解你。”这是我给出的唯一指令。好了，现在你和我面面相觑，心里想：“我到底该怎么做？”然后也许我分享了一些关于我自己的事，或者我问了你一个问题，谁知道我会怎么做，谁又知道你会怎么回应？10 分钟后，我叫停他们，然后说：好了，花点时间意识到，你刚才做了一系列你可能从未思考过的选择。你选择了是先分享一些东西，还是等待对方先开始。你选择了是以一个问题开始（这是一个安全的选择），还是以一次自我表露（disclosure）开始。

---

### [00:15:40] Carole Robin (Continued)

**English:**
Then you had choices with regard to how you responded to what your partner did. And the whole course is about having interactions and then having the guidance and the space and the time and the focus to unpack what just happened. So now do you want to have a more conversation with this person or less? Are you intrigued or are you like, "Can I just get paired up with somebody else?" But now we get to talk about it. And then I put them into a second conversation and I say, okay, now having learned that, by the way, one of the ways we build relationships is through disclosure, through allowing ourselves to become more known. So that's a little mini lecture. And then I say, okay, now go back into your pair and see whether or not you want to make some new choices.

**中文翻译:**
然后，关于如何回应对方的行为，你也做了选择。整个课程的核心就是进行互动，然后在引导下，利用空间、时间和专注力来“拆解”刚才发生的事情。那么现在，你是想和这个人多聊聊，还是少聊聊？你是感到好奇，还是在想“我能不能换个人组队？”现在我们可以讨论这些了。接着，我让他们进行第二次对话，我会说：好了，既然学到了这一点——顺便说一下，建立关系的方法之一就是通过自我表露，通过让自己被更多地了解。这是一个微型讲座。然后我说：现在回到你的小组，看看你是否想做出一些新的选择。

---

### [00:16:33] Carole Robin (Continued)

**English:**
And then of course, that's all I always say, confidentiality is a very important aspect of all this work. So in the pair conversations, in the group conversations, I call them the Vegas Rule. What happens if Vegas stays in Vegas. And so I don't ask for any specifics, but I'll ask them for, was there a qualitative difference between the first and second conversation? And they inevitably say, "Oh my God. The first conversation is the conversation I have in the bar all the time with somebody." And the second conversation was a little more uncomfortable, but I sure feel a lot more known, and I think I know my partner a little bit more and now they've had a little taste of what it's going to be like.

**中文翻译:**
当然，我总是强调，保密是这项工作中非常重要的一环。所以在两人对话和小组对话中，我称之为“拉斯维加斯规则”（Vegas Rule）：发生在拉斯维加斯的事就留在拉斯维加斯。因此我不询问任何细节，但我会问他们：第一次和第二次对话之间是否存在质的区别？他们不可避免地会说：“天哪，第一次对话就像我平时在酒吧里和人聊天一样。而第二次对话虽然有点不舒服，但我确实感觉自己被了解得更多了，我也觉得我更了解我的搭档了。”现在，他们已经初步体验到这门课的滋味了。

---

### [00:17:18] Lenny Rachitsky

**English:**
Amazing example. So what I want to do with the rest of our chat is basically go through many of the lessons and insights and lectures that you give in this course. Obviously, they're not going to be able to practice the way they would practice in a class. But before we get in there, let's actually talk about, so there's this course at Stanford, and you also now have a program called Leaders in Tech where anyone can participate. They don't have to be going to Stanford Business School. Talk about what this is and how people can participate if they want to go deeper on the stuff we're going to talk about.

**中文翻译:**
非常棒的例子。在接下来的聊天中，我想做的是梳理你在课程中教授的许多教训、见解和讲座。显然，听众无法像在课堂上那样练习。但在开始之前，我们先聊聊这个：斯坦福有这门课，而你现在还有一个叫 Leaders in Tech 的项目，任何人都可以参加，不一定要上斯坦福商学院。请谈谈这是什么，如果人们想深入研究我们要讨论的内容，该如何参与？

---

### [00:17:47] Carole Robin

**English:**
So Leaders in Tech is a nonprofit that two of my co-founders and I started, I guess in January of 2018. We started it with a program called The Fellows Program, which is a 10-month program that starts with a four-day retreat that's like Touchy Feely on steroids because Touchy Feely is a quarter long class, and then it continues on a monthly basis for a day or half a day a month to get the rest of what we might call Carole Robin curriculum because I also taught a course called High Performance Leadership. I also called Taught Leadership Coaching and Mentoring. So there were other things besides Touchy Feely. Then what happened was that our fellows who went through our first couple of cohorts said, because the Fellows Program is open to founders, either current or previous founders or co-founders of a company that has not gone public.

**中文翻译:**
Leaders in Tech 是我和两位联合创始人创办的非营利组织，大概是在 2018 年 1 月。我们从一个叫“研究员项目”（Fellows Program）的项目开始，这是一个为期 10 个月的项目，以一个为期四天的静修营开始，那就像是“加强版”的感性课，因为感性课是一个学期的课。然后每月继续进行一天或半天的活动，学习我所谓的“Carole Robin 课程体系”的其余部分，因为我还教过一门叫“高绩效领导力”的课，还有“领导力教练与指导”。所以除了感性课，还有其他内容。后来发生的事情是，参加过前几届项目的研究员们说——因为研究员项目是面向未上市公司的创始人、前创始人或联合创始人的。

---

### [00:18:51] Carole Robin (Continued)

**English:**
And what we're trying to do is we're trying to influence the cultures of the future of Facebook's and Google's of the world, not the current ones. And so that program has a more limited number of people that can apply to it. However, one of the things that happened was we got a lot of people who said, but I'm not a founder and I still want that. And we also had fellows who went through the program that said, what about my people, my chief people officer, my VP of engineering? So then we'd started just a four-day version of the Touchy Feely, which anybody could apply to. I mean, actually not anybody. You do have to be a manager of some kind, and you do have to be in tech for now.

**中文翻译:**
我们试图影响的是未来的 Facebook 和 Google 的文化，而不是现在的这些。所以那个项目的申请人数比较有限。然而，后来发生的一件事是，很多人说：“但我不是创始人，我也想要那个项目。”还有参加过项目的研究员问：“那我的员工呢？我的首席人力官、我的工程副总裁呢？”于是我们开始举办一个为期四天的“感性课”精简版，任何人都可以申请。我是说，其实也不是任何人，你必须是某种级别的管理者，而且目前必须是在科技行业。

---

### [00:19:37] Carole Robin (Continued)

**English:**
So that's where people get the real on the ground experience. They all get a copy of the book, and of course, if you don't want to go through the program or it's not the right time or you want to start somewhere else, you can start with the book. But if you just buy the book and you read it and you put it back on your shelf, you're not going to learn anything. Don't waste your money. If you're going to buy the book, buy at least one other copy and give it to somebody with whom you actually want to develop a stronger relationship and read it together and do the activities at the end of every book, and then you start to get a taste of what it's like to go through the course.

**中文翻译:**
那是人们获得实战经验的地方。他们都会得到一本书。当然，如果你不想参加项目，或者时机不对，或者想从别处开始，你可以从书开始。但如果你只是买了书，读完后放回书架，你什么也学不到。别浪费钱。如果你要买这本书，至少再买一本送给那个你想与其建立更牢固关系的人，一起阅读，并完成每章末尾的活动，然后你就能开始体会到上这门课是什么感觉了。

---

### [00:20:18] Lenny Rachitsky

**English:**
So just to close the loop there, how do people learn more and apply and join this program?

**中文翻译:**
为了完成这个闭环，人们如何了解更多信息、申请并加入这个项目？

---

### [00:20:21] Carole Robin

**English:**
Www.leadersintech.org.

**中文翻译:**
网址是 www.leadersintech.org。

---

### [00:20:25] Lenny Rachitsky

**English:**
Awesome. And around the time this episode comes out, there's a deadline roughly around that time?

**中文翻译:**
太棒了。在这一集播出的时候，是不是正好有一个截止日期？

---

### [00:20:31] Carole Robin

**English:**
There is. Around when this episode comes out. So we do these four-day retreats all year, so there's no deadline to apply for that, but if you're interested in the ten-month program that starts with the four-day retreat and then has all that additional stuff, then deadline for that is May one. Actually, it might even how many days? It might be April. I don't remember how many days there are in April, but it's either the last day of April or May one.

**中文翻译:**
是的，就在这一集播出前后。我们全年都会举办这种为期四天的静修营，所以那个没有申请截止日期。但如果你对那个为期 10 个月、包含四天静修营及后续所有内容的完整项目感兴趣，截止日期是 5 月 1 日。实际上，可能是……4 月有多少天？我不记得 4 月有多少天了，但要么是 4 月的最后一天，要么是 5 月 1 日。

---

### [00:21:00] Lenny Rachitsky

**English:**
April 30th.

**中文翻译:**
4 月 30 日。

---

### [00:21:01] Carole Robin

**English:**
Yeah, there you go. So it's probably April 30th. So check it out. You have to be nominated in order to apply. Don't let that stop you. If you look at it all and you decide you want to apply, just apply and say, Carole, I listened to Carole Robin on this podcast, you told me to apply.

**中文翻译:**
对，就是那天。所以可能是 4 月 30 日。去看看吧。你需要获得提名才能申请。但别让这难住你。如果你了解完决定申请，就直接申请并注明：“Carole，我听了你的播客，是你让我申请的。”

---

### [00:21:23] Lenny Rachitsky

**English:**
Okay, great.

**中文翻译:**
好的，太棒了。

---

### [00:21:25] Carole Robin

**English:**
Don't waste time trying to find somebody to nominate you.

**中文翻译:**
别浪费时间去找人提名你了。

---

### [00:21:27] Lenny Rachitsky

**English:**
How amazing. Okay. Or you're going to be flooded with applications.

**中文翻译:**
太给力了。好吧，否则你的申请表会被塞满的。

---

### [00:21:31] Carole Robin

**English:**
Again, from your mouth to God's ears.

**中文翻译:**
再次借你吉言。

---

### [00:21:35] Lenny Rachitsky

**English:**
Okay, so let's get into a lot of the stuff that you teach. So you mentioned progressive disclosure, so that might be a good place to start. What's the lesson there? What is it that people get wrong? Why is that important?

**中文翻译:**
好了，让我们深入探讨你教授的内容。你提到了“渐进式表露”（progressive disclosure），这可能是一个很好的切入点。这方面的教训是什么？人们通常哪里做错了？为什么这很重要？

---

### [00:21:46] Carole Robin

**English:**
So first of all, when we disclose, we make ourselves more vulnerable, and vulnerability and disclosure tend to be reciprocal. If I hold my cards really close, you're going to hold your cards even closer. So one of the things to learn to do is to experiment. And what works with one person isn't going to work without somebody else necessarily because every relationship is its own fabulously interesting and always unfolding dynamic is to experiment with allowing myself to be a little bit more known, and then seeing what happens and whether or not you reciprocate. Now, a really important concept we teach that you and I have talked about before is called the 15% rule. And what that is that we all have a comfort zone. Imagine a circle in the middle called the comfort zone, this picture's in the book, and that we don't think twice about what we say, and then there is a danger zone, which is a circle way on the outside.

**中文翻译:**
首先，当我们进行自我表露时，我们会让自己变得更脆弱，而脆弱感和表露往往是相互的。如果我把底牌捂得很严，你也会把底牌捂得更严。所以要学习的一件事就是去实验。对一个人有效的方法不一定对另一个人有效，因为每段关系都有其独特、有趣且不断发展的动态。实验的方法是让自己被了解得更多一点，然后观察会发生什么，以及你是否会给予回报。现在，我们教授的一个非常重要的概念（你和我之前谈过）叫做“15% 规则”。它是指我们都有一个“舒适区”。想象中间有一个圆圈叫舒适区（书里有这张图），在那里我们说话不假思索；然后最外面有一个圆圈是“危险区”。

---

### [00:22:57] Carole Robin (Continued)

**English:**
So these are concentric circles if you're not watching the video, and I never in a million years say that or tell you that, but there's this really important circle in the middle, which is called the learning zone. In academia, they have to have fancy words for very easy concepts, it's called the zone of proximal development. But basically it means that's where you learn. And you have to step outside your comfort zone in order to learn anything, and especially in order to create a deeper connection with somebody. However, my students used to say, "But Carole, the minute I step outside my comfort zone, how do I know I'm not in my danger zone?" I hear this learning zone, but how do I know I didn't go too far? So we came up with the 15% rule. So step a little bit outside your comfort zone. If you step a little bit outside your comfort zone, you're very unlikely to freak yourself or the other person out.

**中文翻译:**
如果你没看视频，可以想象这是一组同心圆。危险区里的事我一辈子都不会说。但在两者之间有一个非常重要的圆圈，叫做“学习区”。在学术界，他们喜欢给简单的概念起华丽的名字，叫“近侧发展区间”（zone of proximal development）。但基本上，它指的就是你学习的地方。你必须走出舒适区才能学到东西，尤其是为了与某人建立更深层的连接。然而，我的学生过去常说：“但是 Carole，我一走出舒适区，怎么知道自己是不是进了危险区？我听说了学习区，但我怎么知道自己没走太远？”于是我们想出了“15% 规则”。也就是走出舒适区一点点。如果你只走出一点点，你不太可能吓到自己或对方。

---

### [00:23:53] Carole Robin (Continued)

**English:**
But you'll know, you'll feel it a little bit, you'll be like, okay, I feel just a little uncomfortable saying this, but I think I'm going to try. And then depending on how you respond, then we settle into a new comfort zone, a slightly larger circle, which is our comfort zone with each other. Then we can go 15% beyond that, and that's how we learn and grow and deepen our relationship. The same thing by the way applies to feedback when we get into that later. So we have to step outside our comfort zone in order to deepen and strengthen relationships.

**中文翻译:**
但你会知道，你会有一点感觉，你会想：好吧，说出这些让我感到有一点点不舒服，但我打算试一试。然后根据你的反应，我们会进入一个新的舒适区，一个稍微大一点的圆圈，也就是我们彼此之间的舒适区。接着我们可以再往外走 15%，这就是我们学习、成长和加深关系的方式。顺便说一下，这同样适用于我们稍后会谈到的反馈。所以，为了加深和加强关系，我们必须走出舒适区。

---

### [00:24:27] Lenny Rachitsky

**English:**
What are some examples of stepping outside your comfort zone, disclosing what is it that you find people maybe aren't disclosing enough of or areas they should disclose? Is it challenges they're having in their life?

**中文翻译:**
走出舒适区、进行自我表露有哪些例子？你发现人们可能在哪些方面表露得不够，或者哪些领域是他们应该表露的？是他们生活中遇到的挑战吗？

---

### [00:24:38] Carole Robin

**English:**
Well, of course, context matters. It depends on who I'm talking to. And by the way, disclosure, I want to underscore a concept that we also very much teach, which is appropriate disclosure. If I'm the VP of marketing and I get up in front of the troops and I say, "Well, third month in a row we've lost share and I have no idea what's happening or why or what to do about it, and I'm feeling pretty crappy about myself, I'm not even sure I should be your VP of marketing." That might be vulnerable and disclosure, but it is not appropriate Vulnerability and that it's not what we're talking about. The flip side of that is that I get up in front of the troops and I pretend nothing is happening. That doesn't build my credibility either. So I can get up and say, okay, probably no secret to most of you, that's the third month in a row, we've lost share.

**中文翻译:**
当然，语境很重要。这取决于我在和谁说话。顺便说一下，关于自我表露，我想强调一个我们也经常讲授的概念，即“适度表露”。如果我是营销副总裁，我站在下属面前说：“嗯，我们已经连续三个月丢失市场份额了，我完全不知道发生了什么，也不知道为什么，更不知道该怎么办。我感觉自己糟透了，我甚至不确定自己是否该当这个营销副总裁。”这可能是展现了脆弱和表露，但这不是“适度的脆弱”，也不是我们要讨论的内容。反过来说，如果我站在大家面前假装什么都没发生，那也不会建立我的公信力。所以我可以站起来说：好吧，对你们大多数人来说这可能不是秘密，这是我们连续第三个月丢失份额了。

---

### [00:25:39] Carole Robin (Continued)

**English:**
And man, I wish I could stand up here and tell you I know exactly what's happening and I know exactly what we should do about it, but I don't, and I have never needed you all more. Now, who would you rather follow? So I think in business, and for a very long time, leaders were socialized to, first of all, leave all feelings in the parking lot. I've got an anecdote I often tell about my very first job, which I'm happy to tell you if you want. And there's no place for vulnerability or for sharing feelings. Are you kidding, feelings in the workplace? Now, I ask you, how do you inspire anybody with no feelings? How do you motivate anybody with no feelings? How do you become seen as a real person with no feelings? Why should somebody who is a robot who is robotic follow you? And the answer to that sometimes in the valley especially is because they're going to follow you for a while because you've got a really great idea. And the minute they've got another choice, man, they are out of there.

**中文翻译:**
“伙计们，我真希望我能站在这里告诉你们，我确切地知道发生了什么，也确切地知道我们该怎么做，但我不知道。我从未像现在这样需要你们大家。”现在，你更愿意追随哪种人？我认为在商界，长期以来领导者受到的教育是：首先，把所有情绪都留在停车场。我经常讲一个关于我第一份工作的轶事，如果你想听我很乐意分享。在职场中没有脆弱感或分享感受的空间。开什么玩笑，在工作场所谈感受？现在我问你，没有情感你怎么激励别人？没有情感你怎么调动别人的积极性？没有情感你怎么让别人觉得你是一个真实的人？为什么有人要追随一个像机器人一样的人？在硅谷，这个问题的答案有时是：他们会追随你一段时间，因为你有一个很棒的想法。但一旦他们有了别的选择，天哪，他们会立刻走人。

---

### [00:26:50] Lenny Rachitsky

**English:**
And so a lot of this connects to this broad piece of advice you always give people is just and focus on vulnerability. You spend a lot of time teaching people just the power vulnerability, which is not intuitive. A lot of people try to move away from showing vulnerability. There's this quote I saw somewhere that "A willingness to be vulnerable makes you not less influential as a leader." Can you just talk about why that is?

**中文翻译:**
所以这很多都和你经常给人们的一个宽泛建议有关，那就是关注“脆弱感”。你花了很多时间教人们脆弱的力量，这并不直观。很多人试图避免表现出脆弱。我在哪里看到过一句话：“愿意表现出脆弱并不会降低你作为领导者的影响力。”你能谈谈为什么吗？

---

### [00:27:15] Carole Robin

**English:**
Yeah, you asked me whether or not I held any contrarian views and I said, yeah, that's one of them. I actually think that a leader who is willing to be appropriately vulnerable is a stronger leader. And so I'll give you this short example of what happened to me because it encompasses a lot of what we've been talking about. So in 1975, I went to work for the largest industrial automation company in the world as the first woman in a non-clerical job. I was a sales engineer, and yes, I am old, but the dinosaurs were not roaming the earth. And the first thing I learned was you leave feelings in the parking lot, whatever you do, you never talk about your feelings or express feelings in the workplace. It's unprofessional. I was like, okay. I got pretty good at it. In fact, I got very good at it.

**中文翻译:**
是的，你问我是否有任何非主流的观点，我说过，这就是其中之一。我实际上认为，一个愿意表现出适度脆弱的领导者是一个更强大的领导者。我给你举个发生在我身上的简短例子，因为它涵盖了我们一直在讨论的很多内容。1975 年，我进入全球最大的工业自动化公司工作，是第一位从事非文职工作的女性。我当时是一名销售工程师。是的，我年纪大了，但那时候恐龙还没在地球上乱跑。我学到的第一件事就是：把情绪留在停车场。无论你做什么，永远不要在工作场所谈论你的感受或表达情绪。那是不专业的。我想，好吧。我变得很擅长这一点。事实上，我变得非常擅长。

---

### [00:28:13] Carole Robin (Continued)

**English:**
Ironic, given that I eventually became known as the queen of putty-feely at Stanford. But at the time, I got very good at it. I'm not a career academic. I've had six different careers. And 10 years later I'm at an off-site and I've been promoted many times, I'm now running a $50 million region. I've got a half a dozen guys that work for me. And yes, ladies, if you're listening, I did finally fix that, but at that point, I still hadn't quite fixed it. And we're sitting there and I had an idea, it doesn't matter what it was, but I got a little excited about it and I got crickets and I got a little more excited and I got crickets. I was like, "Come on you guys, this could be really cool. Why can't you see how cool this could be?" And one of my guys leans in, looks at me and says, "Carole, is that like water in the corner of your eye? Oh my God, are you going to cry?" And then he says, "Are you human after all?"

**中文翻译:**
讽刺的是，我后来在斯坦福被称为“感性课女王”。但在当时，我很擅长隐藏情绪。我不是职业学者，我从事过六种不同的职业。10 年后，我在参加一次团建（off-site），那时我已经晋升多次，管理着一个年营收 5000 万美元的区域。我有六个男下属。是的，女士们，如果你在听，我最终确实解决了性别比例问题，但那时还没完全解决。我们坐在那里，我有一个想法，具体是什么不重要，但我有点兴奋，结果大家没反应；我更兴奋了一点，大家还是没反应。我说：“拜托，伙计们，这真的很酷。你们怎么看不出来这有多酷呢？”其中一个下属凑过来看着我说：“Carole，你眼角那是泪水吗？天哪，你要哭了吗？”然后他说：“原来你也是人类啊？”

---

### [00:29:09] Carole Robin (Continued)

**English:**
Are you human after all? And then I burst out crying and I tore up our agenda and I said, "You don't think I'm human?" I don't think there is anything more important for us to spend our off-site talking about than that. And we spent the next two days talking about who we were, why we were there, what we wanted, what was important to us, how we could help each other. To this day, I believe that was the day I became a leader. To this day I know for a fact any of them would follow me anywhere.

**中文翻译:**
“原来你也是人类啊？”接着我放声大哭，撕掉了我们的议程，我说：“你们觉得我不是人吗？”我觉得没有什么比讨论这件事对我们的团建更重要的了。接下来的两天，我们都在讨论我们是谁、为什么在这里、我们想要什么、什么对我们重要、我们如何互相帮助。直到今天，我相信那一天才是我真正成为领导者的日子。直到今天，我确信他们中的任何一个都愿意跟随我到天涯海角。

---

### [00:29:40] Lenny Rachitsky

**English:**
To help people build this muscle and start to practice this to try 15% disclosure, try to be a little more vulnerable. Is there any other examples or just tidbits you can share of like, here's something you should start doing more and more?

**中文翻译:**
为了帮助人们锻炼这种能力并开始练习 15% 的表露，尝试变得更脆弱一点。你还有什么其他的例子或小贴士可以分享吗？比如“这是你应该开始越来越多去做的事情”？

---

### [00:29:54] Carole Robin

**English:**
Let's start with you can start admitting mistakes, especially when everybody knows you made one, you actually lose a lot more credibility by ignoring it. And you can start again 15% by experimenting with sharing what's going on for you, particularly with regard to feelings a little bit more often. So there's a recent course is called Touchy-Feely emphasis on the feely and not the touchy. And that's because so much of our ability to develop this competence comes down to the appropriate use of feelings. That's why a vocabulary of feelings, how sad is it? We had to develop a vocabulary feelings because that's how hard it is for people to even access what they're feeling. So there's a vocabulary feelings in the syllabus, in the course, in the appendix of the book. Every member, every person who ever goes through a leaders in tech program gets it. And it starts with allowing yourself to be known, not just in terms of facts and... Feelings give meaning to facts.

**中文翻译:**
让我们从承认错误开始，尤其是当大家都知道你犯了错的时候，忽视它反而会让你失去更多的公信力。你可以再次尝试 15% 规则，实验性地分享你正在经历的事情，尤其是更频繁地分享感受。最近这门课被称为“感性课”，重点在于“感性”（feely）而不是“接触”（touchy）。这是因为我们培养这种能力的大部分关键在于对情感的适度运用。这就是为什么需要“情感词汇表”。多么悲哀啊，我们竟然必须开发一套情感词汇表，因为人们甚至很难感知到自己的感受。所以在教学大纲、课程和书的附录中都有情感词汇表。每个参加 Leaders in Tech 项目的人都会得到它。它始于让自己被了解，不仅是事实层面的……情感赋予了事实意义。

---

### [00:31:12] Carole Robin (Continued)

**English:**
Let me give you another example. If I tell you I went ziplining, well, that's interesting. Maybe you learned something about me. Maybe you start to make up all sorts of interesting stories about me. But if I tell you I went ziplining and I was terrified, but I went because I felt coerced by my family and I didn't want to be left alone back and then miss out. Well, you learned a lot more about me, didn't you? One of my most satisfying moments at the very first Leaders in Tech retreat we ever did was of a former student of mine who had taken Touchy Feely 15 years before, and who said, based on everything I learned 15 years ago from Carole, I couldn't imagine what I would learn if I came back. So I'm back. And he said, but Carole or no Carole, I will not sit around for four days talking about how we're all crushing it. I will leave.

**中文翻译:**
再举个例子。如果我告诉你我去玩了高空滑索，嗯，那很有趣。也许你了解了我的一些事，也许你开始编造关于我的各种有趣故事。但如果我告诉你，我去玩滑索时吓坏了，但我还是去了，因为我觉得被家人强迫了，我不想一个人留在后面错过大家。那么，你对我的了解是不是多得多了？在我们的第一次 Leaders in Tech 静修营中，我最满足的时刻之一是，我的一位 15 年前上过感性课的前学生说，基于他 15 年前从 Carole 那里学到的一切，他无法想象如果再回来能学到什么，所以他回来了。他说：“不管有没有 Carole，我都不会坐在这里四天听大家吹嘘我们有多成功。如果是那样，我会走人。”

---

### [00:32:15] Carole Robin (Continued)

**English:**
I was like, "Oh," I was so proud. And now there are times when a leader does have to stand up and say, yeah, we're crushing it. So another really, really important thing that people don't understand is that all of this is very nuanced and very context dependent, and most people unanswered Tell me what to do when X happens. Well, did X happen with this person or this person? What relationship do you have with them in the first place? Are there 20 people in the room of 250? Is this being recorded? There's just so many different things. Who's going to have access to it? There's so many things that you have to consider, and especially today, I know I'm old and this will sound predictable, but I am not a social media fan. I think it has done more to destroy strong relationships and to destroy people's ability to even learn or think about what it takes to have a great relationship.

**中文翻译:**
我当时想：“噢，”我太自豪了。当然，有时领导者确实需要站出来说：“是的，我们干得很棒。”所以，人们不理解的另一件非常非常重要的事情是，所有这些都非常微妙，且高度依赖语境。大多数人会问：“告诉我当 X 发生时该怎么办。”那么，X 是发生在这个人还是那个人身上？你们原本是什么关系？房间里是有 20 个人还是 250 个人？是否在录音？有太多不同的因素了。谁会有权限看到？你必须考虑这么多事情。尤其是今天，我知道我老了，这话听起来很老套，但我不是社交媒体的粉丝。我认为它在破坏牢固关系、破坏人们学习或思考如何建立良好关系的能力方面，负有很大责任。

---

### [00:33:26] Carole Robin (Continued)

**English:**
Anyway, we could do a whole podcast on that. I have a former Leaders in Tech fellow who sent me this fantastic, here's another great example, sent me an email and maybe he called me, I don't remember. It doesn't matter. He said, "So I had my all-hands meetings are every Monday morning, on Friday, I found out we had missed a major deadline on a product release, and I spent the entire weekend just furious, pissed off, wanting to fire a lot of them," and he said, "And then on Sunday afternoon, I remembered part of what you taught us was that anger is often a secondary emotion and often under anger is either fear or hurt. And then I realized, oh yeah, I'm actually feeling pretty scared here, that nobody is as worried about this as I am."

**中文翻译:**
总之，我们可以就此做一个专题播客。我有一位前 Leaders in Tech 的研究员给我发了一封精彩的邮件，或者他给我打了电话，我不记得了，这不重要。他说：“我每周一早上都有全员会议。周五我发现我们错过了一个重要的产品发布截止日期，整个周末我都在愤怒、生气，想开除很多人。”他说：“然后到周日下午，我记起你教过我们，愤怒通常是一种次生情绪，愤怒之下通常是恐惧或伤害。然后我意识到，噢，是的，我其实感到很害怕，害怕没有人像我一样担心这件事。”

---

### [00:34:24] Carole Robin (Continued)

**English:**
And so he said, "So on Monday morning, instead of getting up and blasting them all as I was prepared to do, I got up and I said, so, gang, I am deeply worried and afraid that I'm the only person here who is as concerned about this missed deadline as I am and what it's going to mean to our customers." And he said, "I have never had my troops rally to fix something faster." So appropriate use of feelings is something most people don't know how to do. They don't even know how to access the feeling. I told this particular anecdote about anger being a secondary emotion at a very big workshop a number of months ago, and a woman walked up to me and said, "Wow, thank you so much. I've never understood that my husband Carries so much fear and so much hurt because he only ever leads with anger. It never even occurred to me something else might be going on." And anger is a distancing emotion, whereas hurt, fear, sadness, loneliness, happiness, joy are all connecting emotions. So those are kinds of things people learn when they come through our programs.

**中文翻译:**
于是他说：“所以周一早上，我没有像准备好的那样站起来痛骂他们，而是站起来说：‘伙计们，我深感忧虑和恐惧，我担心这里只有我一个人在为错过截止日期以及它对客户意味着什么而感到担忧。’”他说：“我从未见过我的团队如此迅速地集结起来解决问题。”所以，适度地运用情感是大多数人不知道如何去做的事情。他们甚至不知道如何感知这种情感。几个月前，我在一个大型研讨会上讲了这个关于“愤怒是次生情绪”的轶事，一位女士走过来对我说：“哇，太感谢你了。我从未理解过我丈夫承受着这么多的恐惧和伤害，因为他总是表现出愤怒。我从未想过可能还有别的事情在发生。”愤怒是一种疏远型情绪，而伤害、恐惧、悲伤、孤独、幸福、喜悦都是连接型情绪。这些就是人们在我们的项目中会学到的东西。

---

### [00:35:47] Lenny Rachitsky

**English:**
Oh, man, you're blowing my mind already. I can see why marriages are saved by a lot of these things you teach. That's a really profound point you're just making there that anger is a secondary emotion. Really what's going on is you're afraid or you're hurt. Is there anything more you can add there because this feels very important?

**中文翻译:**
噢，天哪，你已经让我大开眼界了。我明白为什么你教的这些东西能挽救婚姻了。你刚才说的“愤怒是一种次生情绪”真的是一个非常深刻的观点。实际上发生的是你感到恐惧或受伤。关于这一点你还能多说一些吗？因为这感觉非常重要。

---

### [00:36:06] Carole Robin

**English:**
That is normally what's going on, except we've all been socialized not to be vulnerable, especially in business and naming any of those other things makes us feel vulnerable. So somehow being angry doesn't make us feel vulnerable. That's the okay emotion, as long as you express it in an appropriate way, but it's a distancing emotion. What a disservice to everybody in business. What a disservice to professional learning, to not help people understand that anger is a distancing emotion and that there are other emotions that are appropriate and that are connecting.

**中文翻译:**
通常情况确实如此，只是我们都被社会化了，被教导不要表现出脆弱，尤其是在商界。说出其他任何一种情绪都会让我们感到脆弱。所以不知为何，表现出愤怒不会让我们感到脆弱。只要你以适当的方式表达，愤怒就是“被允许”的情绪，但它是一种疏远型情绪。如果不帮助人们理解愤怒是疏远型的，而其他情绪是适度且连接型的，那对商界的每一个人、对职业学习来说都是一种损失。

---

### [00:36:46] Lenny Rachitsky

**English:**
This connects so beautifully to your first point we talked about of being vulnerable and disclosing more and how I completely see how if you were just to share, I'm afraid of this, how that brings people closer to you and feels like they will trust you more versus you not sharing that.

**中文翻译:**
这与我们讨论的第一点——表现脆弱和更多表露——完美地联系在了一起。我完全能理解，如果你只是分享“我对此感到害怕”，这会如何拉近人们与你的距离，让他们觉得更信任你，而不是选择不分享。

---

### [00:37:03] Carole Robin

**English:**
Right. It connects to something else. You and I talked about one of the biggest gifts I think people get out of taking Touchy Feely or going through the Leaders in Tech program or even reading the book is that they learn that they hold some mental models, some beliefs and assumptions. If I do this, that will happen, or if I don't do this, this will happen. And those are beliefs and assumptions that we develop very early in our careers like I did. Whatever you do, you leave your feelings in the parking lot. And it served me really well initially. If I'd burst out crying two months into the job, I'd have never ended up running a $50 million region and then it over served me, and then it cost me because I never had a reason to update it.

**中文翻译:**
对。它还联系到了另一件事。你和我谈过，我认为人们从感性课、Leaders in Tech 项目甚至阅读这本书中获得的最大礼物之一，就是他们意识到自己持有某些“心智模型”、某些信念和假设。比如“如果我做了这个，那个就会发生”，或者“如果我不做这个，这个就会发生”。这些信念和假设是我们职业生涯早期形成的，就像我一样：“无论你做什么，把情绪留在停车场。”最初这对我很有帮助。如果我在工作两个月后就大哭，我永远不可能管理一个 5000 万美元的区域。但后来它“服务过度”了，让我付出了代价，因为我从未有过更新它的理由。

---

### [00:37:56] Carole Robin (Continued)

**English:**
Because I never realized I was paying a cost for continuing to hold that belief that drove my behaviors. And mental models, then we developed them very early and they're grooved and we need new experiences in order to even believe that they're maybe subject to testing. Gee, I will forever be grateful to this fellow who said, "Oh my God, are you human after all?" I was like, how did this ever happen that I became seen as not human? Again, we go back to some of the stuff we talked about earlier, which is that leaders, if a leader doesn't show up with a willingness to update their mental models and their beliefs, they're certainly not going to inspire anybody else to do that.

**中文翻译:**
因为我从未意识到，继续持有那种驱动我行为的信念是需要付出代价的。心智模型在我们很小的时候就形成了，而且根深蒂固，我们需要新的体验才能相信它们也许是可以被挑战的。天哪，我永远感激那位说“天哪，原来你也是人类啊”的同事。我想，我怎么会变成一个被视为“非人类”的人呢？再次回到我们之前谈过的内容：如果一个领导者不表现出更新心智模型和信念的意愿，他们肯定无法激励其他人也这样做。

---

### [00:38:59] Lenny Rachitsky

**English:**
I'm glad you got here because this is exactly where I was going to go next, is this mental model challenge we run into where we develop these mental models early on and then they end up hurting us later in life. Are there common mental models people have that hurt them as they grow? Or is it very particular independent on people's experience?

**中文翻译:**
我很高兴你谈到了这里，因为这正是我接下来想聊的：我们面临的心智模型挑战——我们在早期形成这些模型，结果它们在以后的生活中伤害了我们。人们在成长过程中有哪些常见的、会伤害他们的心智模型？还是说这非常特殊，取决于个人的经历？

---

### [00:39:17] Carole Robin

**English:**
I mean, there are some that are pretty tried and true. I mean, the first one is, if I tell you more about me, you'll take advantage of me. Or if I am vulnerable with you or disclosing, you'll think I'm weak. And inevitably, somebody has had a time in their life where that has been true, and maybe it was true a lot, but then they decide that's the only outcome that's ever possible as opposed to part of growing up and becoming more mature is differentiating and being more discretionary in who we open up to and how we open up to them. It's like I have a colleague who often says, we have to think about these things as dials, not switches. It's not an all or I don't tell you everything or nothing. I don't share every single feeling I've got or none. It's a dial and you move it at 15% rate.

**中文翻译:**
我是说，有一些是相当普遍的。第一个是：“如果我告诉你更多关于我的事，你会利用我。”或者“如果我对你表现出脆弱或表露心声，你会认为我很软弱。”不可避免地，每个人的生命中都曾有过这样的时刻，也许还发生过很多次，于是他们认定那是唯一可能的结果。然而，成长和变得成熟的一部分，就是学会区分并更有选择性地决定向谁敞开心扉、如何敞开心扉。就像我的一位同事常说的，我们必须把这些事情看作“旋钮”而不是“开关”。不是“全有或全无”，不是“我要么告诉你一切，要么什么都不说”。不是“我要么分享每一个感受，要么一个都不分享”。它是一个旋钮，你可以以 15% 的速度拨动它。

---

### [00:40:22] Carole Robin (Continued)

**English:**
Another mental model people hold, and this becomes a huge learning for people who go through our programs, is people think if I give you feedback, it's going to ruin the relationship. It's going to weaken the relationship. Whoa, that's really common. Even though everybody's always wanting, I want more feedback, I want to know how it can be better, but everybody believes that giving feedback is going to create a problem. And that's because most people have in fact been on the receiving end of feedback poorly given or they've given feedback in a not very good way. They've stepped in piles of doodoo, yes. And it does not mean feedback ruins relationships. It means feedback the way you've always seen it done or done. It ruins relationships pretty important. And then one of the things that we arm people with, I think one of the most powerful pieces of learning that people get is learning how to give feedback in a way that is going to build relationships as opposed to, and it's going to build a relationship.

**中文翻译:**
人们持有的另一个心智模型（这对参加我们项目的人来说是一个巨大的收获）是：人们认为“如果我给你反馈，会破坏我们的关系，会削弱我们的关系”。哇，这太普遍了。尽管每个人总是说“我想要更多反馈，我想知道如何变得更好”，但每个人都相信给反馈会制造问题。这是因为大多数人实际上都曾是糟糕反馈的接收者，或者他们曾以不太好的方式给出反馈。他们踩过坑，是的。但这并不意味着反馈会破坏关系。它意味着“你一直以来看到或做出的那种反馈方式”会破坏关系。这一点非常重要。我们武装人们的武器之一，我认为人们获得的最强大的学习成果之一，就是学习如何以一种能够建立关系的方式来提供反馈。

---

### [00:41:29] Carole Robin (Continued)

**English:**
If you see that my reason for wanting to give it to you is that I'm invested in you and in us it's similarly, we hold mental models about expressing what we call pinches, which are just those little things that people do. Then we're just like, eh, I'm not going to make a big deal out of it. I'm not going to say anything, but mental model is, eh, it's a small thing. The problem is, if I'm doing something that's mildly irritating and you don't tell me, then what am I going to do?

**中文翻译:**
如果你看到我之所以想给你反馈，是因为我在乎你、在乎我们的关系。同样地，我们对于表达所谓的“摩擦”（pinches）也持有心智模型——那些人们做的小事。然后我们会想：“唉，我不想小题大做，我什么都不说。”心智模型是：“唉，这是件小事。”问题是，如果我做了一些让你稍微有点恼火的事而你不告诉我，那我接下来会怎么做？

---

### [00:42:01] Lenny Rachitsky

**English:**
You're doing it.

**中文翻译:**
你会继续做。

---

### [00:42:01] Carole Robin

**English:**
And then are you going to get less irritated or more irritated?

**中文翻译:**
然后你会变得不那么恼火，还是更恼火？

---

### [00:42:02] Lenny Rachitsky

**English:**
More irritated.

**中文翻译:**
更恼火。

---

### [00:42:04] Carole Robin

**English:**
Yeah. Now, if I get less irritated or it doesn't change, then you're right. I shouldn't say anything. But if I have the wherewithal to notice, this is why we talk about two antenna, which I'll come back to notice that I'm getting more and more activated, more and more irritated, then it's really important for me to say something. And by the way, address it while it's still small and then it won't get big. That's why we call it talk about a pinch before it becomes a crunch, and then it becomes a much bigger deal. But most of the time we say it's not worth it. So I always tell students, okay, substitute the pronoun, substitute the word it for I, you, we. I'm not worth it, you're not worth it. We're not worth it. And then ask yourself again whether it's worth raising.

**中文翻译:**
是的。如果我不那么恼火了，或者情况没变化，那你是对的，我不该说什么。但如果我有能力注意到——这就是为什么我们谈论“两根天线”（我稍后会回到这一点）——注意到我变得越来越激动、越来越恼火，那么对我来说说点什么就很重要了。顺便说一下，要在事情还小的时候处理它，这样它就不会变大。这就是为什么我们说要在“摩擦”（pinch）变成“崩盘”（crunch）之前谈论它，否则它会变成大麻烦。但大多数时候我们会说“不值得”（it's not worth it）。所以我总是告诉学生：好吧，把代词“它”（it）替换成“我”、“你”或“我们”。“我不值得”、“你不值得”、“我们不值得”。然后再问问自己，这件事是否值得提出来。

---

### [00:42:56] Lenny Rachitsky

**English:**
This episode is brought to you by the a16z Podcast. Every week on this podcast, you get to hear from product leaders and growth experts from some of the world's most impactful companies, whether it's Airbnb, Slack, Figma, or Stripe. But what will the next wave of companies look like? One firm might have a clue, and recent Horowitz invested in all four of the companies I just mentioned and their flagship podcast, the a16z Podcast features conversations with the very founders and technologists shaping our future. Recent episodes feature folks like Marc Andreessen, longtime builders like Adam D'Angelo from Quora and Mark Pincus from Zynga, even some voices from the government like the CIA's first-ever chief technology officer, Nand Mulchandani. From drones to DNA to deep learning, you can eavesdrop on the future with the a16z Podcast. I want to talk about how to give feedback well, but I think it might be helpful to talk about this concept that you call the three realities and the net, because I think that sets up a lot of this.

**中文翻译:**
本集节目由 a16z Podcast 赞助。每周在这个播客中，你都能听到来自全球最具影响力公司的产品领导者和增长专家的分享，无论是 Airbnb、Slack、Figma 还是 Stripe。但下一波公司会是什么样子？有一家公司可能知道线索，Andreessen Horowitz 投资了我刚才提到的所有四家公司，他们的旗舰播客 a16z Podcast 邀请了正在塑造我们未来的创始人和技术专家进行对话。最近的剧集邀请了 Marc Andreessen、Quora 的 Adam D'Angelo 和 Zynga 的 Mark Pincus 等资深建设者，甚至还有来自政府的声音，比如 CIA 首任首席技术官 Nand Mulchandani。从无人机到 DNA 再到深度学习，你可以通过 a16z Podcast 偷听未来。我想谈谈如何更好地提供反馈，但我认为聊聊你所谓的“三个现实”和“网”的概念可能会很有帮助，因为我觉得这为很多内容奠定了基础。

---

### [00:44:00] Carole Robin

**English:**
Yeah. And in fact, it is fundamental to giving feedback.

**中文翻译:**
是的。事实上，它是提供反馈的基础。

---

### [00:44:03] Lenny Rachitsky

**English:**
Well, awesome.

**中文翻译:**
太棒了。

---

### [00:44:04] Carole Robin

**English:**
So they're very related. You were right on the money. And you know what, let me just take a moment and talk. I mentioned the two antennae, and this is in the book, but we're all equipped with two antennae. One is tracking what's going on for me, my internal antenna. The other one is trying to pick up signals on what might be going on for you. And first of all, recognizing those two antennae exist. Second of all, learning how to hone our ability to pick up subtler and subtler signals make us more interpersonally competent. That's also why I'm a big believer in meditation and awareness. So, anyway, if we now fast-forward to your question about how to give feedback well, which has to do with understanding the three realities. It starts with in any exchange between two people, there are three realities. There is my intent, how I see the world, my background, my history, there is what I do or say or don't do, verbal or nonverbal.

**中文翻译:**
所以它们是非常相关的。你说的很对。你知道吗，让我花点时间谈谈。我提到了“两根天线”，书里也有，我们每个人都配备了两根天线。一根是追踪我自身的情况，即我的“内部天线”；另一根是试图捕捉你那边可能发生的情况的信号。首先，要意识到这两根天线的存在。其次，学习如何磨练我们捕捉越来越微妙信号的能力，这会让我们的人际交往能力更强。这也是为什么我非常相信冥想和觉察。总之，如果我们现在快进到你关于如何提供反馈的问题，这与理解“三个现实”有关。它始于：在两个人的任何交流中，都存在三个现实。第一个是我的意图、我看世界的方式、我的背景和历史。第二个是我所做的、所说的或没做的，包括言语和非言语行为。

---

### [00:45:09] Carole Robin (Continued)

**English:**
So my reality is reality number one, my behavior, verbal or nonverbal is reality number two. And whatever happens on your end is reality. Number three, the impact of what I've said or done, how you see things, your background. So there's these three distinct realities. And the trouble we get into when we don't recognize that those three realities exist is we don't understand that we are only privy to two out of the three. So I know what's going on for me, and I know what I did. I have no idea what happened on your end. You know what I did and how it impacted you. So your two are... The only one we share is the one in the middle in common, the behaviors right now, we draw a metaphorical net between reality number one and reality number two to help people understand. And anybody who's ever taken Touchy Feely in no matter which context knows the saying, "Stay on your side of the net."

**中文翻译:**
所以，我的现实是现实一；我的行为（言语或非言语）是现实二；而你那边发生的任何事情都是现实三——即我所说或所做的产生的影响、你看待事物的方式、你的背景。所以存在这三个截然不同的现实。当我们没有意识到这三个现实存在时，麻烦就来了：我们不明白自己只能了解其中的两个。我知道我这边发生了什么，我知道我做了什么，但我完全不知道你那边发生了什么。你知道我做了什么以及它对你产生了什么影响。所以你的两个现实是……我们唯一共享的是中间那个共同的行为。现在，我们在现实一和现实二之间画一张隐喻的“网”，以帮助人们理解。任何上过感性课的人，无论在什么背景下，都知道这句话：“留在你这半边的网内。”

---

### [00:46:28] Carole Robin (Continued)

**English:**
Meaning stick with the two realities you know because we get in trouble the minute we start thinking we know the other person's reality. Right? So I've told this anecdote many times, it might even be in the book, but I come home... I'm sorry, my husband comes home after a very long day in the valley. He was an executive. I've got two little kids, infant and a 2-year-old. I've been waiting for him to come home. I come running into the front room. In those days, by the way, we still had newspapers. He's reading the newspaper and I say, "Oh my God. Oh my God, you're home. I can't wait until I tell you what happened tonight. I can't believe what happened. Why are we living in Palo Alto, Jesus Christ? I don't want to raise kids in Palo Alto. It's a terrible town. I wish that new nursery school, it hasn't even opened. It's already closed. Oh my God."

**中文翻译:**
意思是只谈论你了解的那两个现实，因为一旦我们开始认为自己了解对方的现实，我们就会陷入麻烦。对吧？我讲过很多次这个轶事，书里可能也有。我回到家……对不起，是我丈夫在硅谷忙碌了一整天后回到家。他当时是一名高管。我有两个小孩，一个婴儿和一个两岁的孩子。我一直在等他回家。我跑进前屋。顺便说一下，那时候我们还有报纸。他正在看报纸，我说：“天哪，天哪，你回来了。我等不及要告诉你今晚发生了什么。我简直不敢相信。我们为什么要住在帕洛阿尔托（Palo Alto）？天哪，我不想在帕洛阿尔托养孩子。这是一个糟糕的小镇。我希望那家新托儿所……它还没开门就关门了。天哪。”

---

### [00:47:18] Carole Robin (Continued)

**English:**
And then he says, "mm-hmm, great. "So then I say, you're not listening. And by the way, people have been taught iMessages, I feel that you're not listening is exactly the same thing, it doesn't have a single feeling word in it. I don't know whether he was listening or not. I'm over the net. I'm in his court unless I'm in his head. I don't know whether he was listening or not. But then he says, yeah, I was listening. You're all worked up. You went to that new nursery school. Actually it's more like this. Yeah, you're all worked up and you went to that new nursery school hasn't even opened. You're all worked up. Now I get a little bit more activated and I say, "How can you not care?" First of all, he didn't say, I don't care, did he? I don't know whether he cares or not. And by the way, "How can you be so insensitive?"

**中文翻译:**
然后他说：“嗯，太好了。”于是我说：“你没在听。”顺便说一下，人们被教导过“我信息”（iMessages），但“我觉得你没在听”其实是一回事，它里面没有一个关于感受的词。我不知道他是否在听。我越过了网。除非我在他脑子里，否则我就是在他的半场。我不知道他是否在听。但他接着说：“是的，我在听。你太激动了。你去了那家新托儿所。”实际上更像是这样：“是的，你太激动了，你去了那家还没开门的新托儿所。你太激动了。”现在我变得更激动了，我说：“你怎么能不在乎呢？”首先，他没说他不在乎，对吧？我不知道他在不在乎。顺便说一下，“你怎么能这么不敏感？”

---

### [00:48:13] Carole Robin (Continued)

**English:**
And I feel that you don't care and I feel you're being insensitive are not feelings. They're attributions and imputed motives, and that's where we make our biggest mistakes when it comes to feedback. And what that does is it makes the other person defensive. So calling my husband insensitive is the most insensitive thing in the world because he's one of the most sensitive people on the planet. So it wasn't until I learned to stay on my side of the net and say, so when I speak and I'm all worked up about something and the only thing I get back from you are either a grunt or an affectless repetition of what I just said, that's reality number two, anybody watching the video would say, that's what happened, I don't feel heard. He can't say, yeah, you do. And when I don't feel heard, I feel hurt and I feel distanced.

**中文翻译:**
“我觉得你不在乎”和“我觉得你很不敏感”都不是感受。它们是归因和推测动机，这就是我们在反馈时犯的最大错误。这样做会让对方产生防御心理。说我丈夫不敏感是世界上最不敏感的事，因为他是这个星球上最敏感的人之一。直到我学会留在自己这半边的网内，并说：“所以，当我说话且非常激动时，我从你那里得到的唯一回应要么是哼一声，要么是毫无感情地重复我刚才说的话（这是现实二，任何看视频的人都会说这就是事实），我感到自己没被倾听。”他不能反驳说“不，你感觉到了”。而当我感到没被倾听时，我感到受伤，感到被疏远。

---

### [00:49:11] Carole Robin (Continued)

**English:**
And the reason I'm telling you that is because I can't be here for you in the way I want to be when I feel that way. So the formula is when you do insert behavior, I feel pull out the vocabulary of feelings and I'm telling you this because, or I'm hoping the outcome of you knowing this is. And so then what happened is he said, "Well, if you want my undivided attention, then you've got to give me some time to unwind when I get home." What a reasonable request. I said, "Well, how much time do you need?" He said, "I don't know, half an hour." "I was like, half an hour?" I've been counting the minutes. How about five minutes? We settled on 15. And by the way, that is the purpose of feedback. When it's constructive feedback, move into a problem-solving conversation, don't change the other person. Move into behaviors that will work better for both of you.

**中文翻译:**
“我告诉你这些的原因是，当我产生那种感觉时，我无法以我想要的方式陪伴你。”所以公式是：当你做[插入行为]时，我感到[拿出情感词汇表]，我告诉你这些是因为[或者我希望你了解这些后的结果是]。然后发生的是他说：“好吧，如果你想要我全神贯注，那你得让我在回家后有一点放松的时间。”多么合理的请求。我说：“好吧，你需要多少时间？”他说：“我不知道，半小时吧。”我心想：“半小时？”我一直在数着分钟等他。五分钟行吗？最后我们定在 15 分钟。顺便说一下，这就是反馈的目的。当它是建设性反馈时，转向解决问题的对话，而不是改变对方。转向对双方都更有效的行为。

---

### [00:50:14] Lenny Rachitsky

**English:**
Amazing. And this structure, so the structure you just shared, and this is similar to nonviolent communication structure?

**中文翻译:**
太棒了。这个结构，也就是你刚才分享的结构，和“非暴力沟通”的结构很像吗？

---

### [00:50:14] Carole Robin

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:50:21] Lenny Rachitsky

**English:**
Okay, cool.

**中文翻译:**
好的，酷。

---

### [00:50:21] Carole Robin

**English:**
It is.

**中文翻译:**
确实如此。

---

### [00:50:22] Lenny Rachitsky

**English:**
So there's books people can read on this-

**中文翻译:**
所以人们可以读一些这方面的书——

---

### [00:50:23] Carole Robin

**English:**
Right. Ours came before, but that's okay.

**中文翻译:**
对。我们的书出得更早，但没关系。

---

### [00:50:26] Lenny Rachitsky

**English:**
Oh, wow. Okay. Good to know.

**中文翻译:**
噢，哇。好的，了解了。

---

### [00:50:30] Carole Robin

**English:**
I will say anything that spreads the word and anything that helps people learn how to engage with each other in ways that build relationship, I'm all for.

**中文翻译:**
我想说，任何能传播这些理念、任何能帮助人们学习如何以建立关系的方式相互交往的东西，我都全力支持。

---

### [00:50:42] Lenny Rachitsky

**English:**
I love that attitude. Okay, so the structure again is just when you do some behavior, I feel an emotion. By the way, is there a flyer or handout? I think the book has these of just emotions. Okay, cool. And feelings.

**中文翻译:**
我喜欢这种态度。好的，所以结构再次强调一下，就是：当你做某个行为时，我感到某种情绪。顺便问一下，有没有传单或讲义？我想书里应该有这些关于情绪和感受的内容。好的，酷。

---

### [00:50:58] Carole Robin

**English:**
The vocabulary of feelings is an appendix in the book.

**中文翻译:**
情感词汇表是书中的一个附录。

---

### [00:51:01] Lenny Rachitsky

**English:**
Okay, great.

**中文翻译:**
好的，太棒了。

---

### [00:51:02] Carole Robin

**English:**
As is the formula.

**中文翻译:**
公式也是。

---

### [00:51:04] Lenny Rachitsky

**English:**
Amazing. Okay, great. So by the book, if you want to get really good at this stuff, is there anything online we can point people to, or?

**中文翻译:**
太好了。好的。所以如果想精通这些，就去买书。网上有什么我们可以向大家推荐的资源吗？

---

### [00:51:10] Carole Robin

**English:**
We got a picture of the... I'll send you a couple of slides.

**中文翻译:**
我们有一张……我会发给你几张幻灯片。

---

### [00:51:14] Lenny Rachitsky

**English:**
Perfect.

**中文翻译:**
完美。

---

### [00:51:16] Carole Robin

**English:**
And then you can just say, here are the slides.

**中文翻译:**
然后你就可以直接说：“这是幻灯片。”

---

### [00:51:17] Lenny Rachitsky

**English:**
Amazing. So we'll link to that in the show notes. And as you talk through all of these lessons and pieces of advice, it makes so much sense why this is something you need to do. Because I imagine what's happening in the class here is you do this with someone and then you hear the reality and it often surprises you. Right?

**中文翻译:**
太棒了。我们会把链接放在节目介绍里。当你讲解这些教训和建议时，为什么必须这样做就变得非常有道理了。因为我能想象课堂上发生的事情：你和某人进行这种练习，然后你听到了对方的现实，这通常会让你感到惊讶。对吗？

---

### [00:51:36] Carole Robin

**English:**
Exactly. Because often we say it takes two to know one, I don't know what impact I'm having on you until you tell me. And I have to be willing to be a little vulnerable to ask. And if we go back to that first activity that you asked me to describe way at the beginning, then we put them back in pairs and we say, okay, now that you've learned a little bit about feedback, tell your partner what they did that made it easier for you to disclose more and be more willing to be more vulnerable and/or what they did that made it a little harder. And right there in the moment, you learned something about yourself that you might never have known. Somebody says, you looked away as I was talking, you might not have even known you did that. You looked at your watch. And I love this.

**中文翻译:**
没错。因为我们常说“旁观者清”（直译：需要两个人才能了解一个人），除非你告诉我，否则我不知道我对你产生了什么影响。而且我必须愿意表现出一点脆弱去询问。回到你一开始让我描述的第一个活动，我们让他们重新配对并说：好了，既然你们已经学到了一点关于反馈的知识，告诉你的搭档，他们做了什么让你更容易表露更多、更愿意表现脆弱，或者他们做了什么让这变得有点困难。就在那一刻，你学到了关于你自己的、你可能从未知道的事情。有人会说：“我说话时你把脸转过去了。”你可能甚至不知道自己那样做了。“你看了看表。”我非常喜欢这个例子。

---

### [00:52:34] Carole Robin (Continued)

**English:**
One of my greatest moments when I was teaching was that I asked a question. I was teaching in a big lecture hall at the law school, and they didn't have any clocks on the wall. And I asked a question and a student began answering, and I just glanced at my watch just because I was trying to figure out where I was in terms of when I had to wrap up. And he walked up to me after class and he said, "Professor, I felt disrespected when you looked at your watch while I was answering," I hugged him. Well, first I asked him if it was okay, "Is it okay if I hug you?" And then I hugged him.

**中文翻译:**
我教学中最伟大的时刻之一是，我提了一个问题。当时我在法学院的一个大讲堂上课，墙上没有钟。我提问后，一个学生开始回答，我只是瞥了一眼手表，因为我想看看进度，确定什么时候该结束。课后他走到我面前说：“教授，当我在回答时你低头看表，我感到不被尊重。”我拥抱了他。好吧，我先问了他是否可以，“我可以拥抱你吗？”然后我拥抱了他。

---

### [00:53:12] Lenny Rachitsky

**English:**
And I love how so much of this is like, we never get this feedback in real life. No one ever tells us this thing you did is distracting them, annoying them, making them feel like they're not being heard.

**中文翻译:**
我非常喜欢这一点，因为在现实生活中，我们永远得不到这种反馈。没有人会告诉我们，你做的这件事分散了他们的注意力、让他们恼火，或者让他们觉得没被倾听。

---

### [00:53:22] Carole Robin

**English:**
And then guess what? Then he leaves and then somebody says, how was that? He says, oh, she's really disrespectful. And then pretty soon nobody's ever even been there. But my reputation is that I don't respect students. That's how stuff gets out of control.

**中文翻译:**
然后你猜怎么着？他离开后，有人问：“那门课怎么样？”他说：“噢，她真的很不尊重人。”很快，甚至没去过现场的人也会这么传。于是我的名声就变成了“我不尊重学生”。事情就是这样失控的。

---

### [00:53:36] Lenny Rachitsky

**English:**
Yeah. And you wish people would tell you, right? Everybody wants this, but it's so hard and uncomfortable to tell anyone negative feedback.

**中文翻译:**
是的。你希望人们能告诉你，对吧？每个人都想要这个，但向别人提供负面反馈是如此困难且令人不适。

---

### [00:53:45] Carole Robin

**English:**
Which by the way, I never used the word negative when it comes to feedback.

**中文翻译:**
顺便说一下，在谈到反馈时，我从不使用“负面”这个词。

---

### [00:53:48] Lenny Rachitsky

**English:**
Okay. Okay.

**中文翻译:**
好的，好的。

---

### [00:53:50] Carole Robin

**English:**
So feedback is either constructive or complimentary. Constructive feedback is there's something you're doing that is problematic, and the purpose of it is let's move to a problem solving conversation like with Andy and me. The purpose of complimentary feedback is, wow, that's the third time you've handed in that report early and completely, and you even went above and beyond and did this and this. I can't tell you how much I appreciate that, how lucky I feel that you work for me. And if I'm telling you this, because if there's ever something that you want that we're not giving you, I want to make sure you know that I want to talk about it. By the way, same formula. Now compare that to nice job, thanks, right? All feedback is data. So all feedback is positive. More data is always better than less data.

**中文翻译:**
反馈要么是“建设性的”（constructive），要么是“赞赏性的”（complimentary）。建设性反馈是指你做的某些事情存在问题，其目的是转向解决问题的对话，就像我和 Andy 那样。赞赏性反馈的目的是：“哇，这是你第三次提前且完整地提交报告了，你甚至做得超出了预期，完成了这个和那个。我无法告诉你我有多感激，我觉得你能为我工作真是太幸运了。我告诉你这些是因为，如果你有什么想要而我们没能提供给你的，我希望你知道我想和你谈谈。”顺便说一下，公式是一样的。现在把这与“干得好，谢谢”对比一下，对吧？所有反馈都是数据。所以所有反馈都是积极的。数据多总比数据少好。

---

### [00:54:46] Lenny Rachitsky

**English:**
I agree. That's a great lesson there. To maybe make this even more practical for listeners that are maybe working on a product and say they have to give feedback in a product design or to a colleague who did something wrong. Is there an example that you could share of just in the workplace.

**中文翻译:**
我同意。这是一个很好的教训。为了让这对比方说正在开发产品的听众更具实践意义，比如他们必须对产品设计提供反馈，或者对做错事的同事提供反馈。你能分享一个职场中的例子吗？

---

### [00:55:03] Carole Robin

**English:**
I'm glad you asked that, because first of all, we're not talking about performance feedback and we're not necessarily talking about feedback on a task. What we're talking about is interpersonal feedback. And the reason it's so important is that if you don't take care of that, then that other feedback becomes unresolved. When you leave the interpersonal stuff unresolved, then the other feedback doesn't go well because the real problem is that I'm still pissed off that you never answered my phone call. So now I'm going to make it all about how this feature really is never going to work. Here's an example. Somebody walks into... A manager or a team leader or whatever, walks into a room meeting, starts a meeting by say, so I want to make sure we hear from everybody. I want to make sure that we have a very full conversation.

**中文翻译:**
我很高兴你问这个问题。因为首先，我们讨论的不是绩效反馈，也不一定是关于任务的反馈。我们讨论的是“人际反馈”。它之所以如此重要，是因为如果你不处理好人际部分，那么其他反馈就会变得悬而未决。当你让人际问题悬而未决时，其他反馈就不会顺利，因为真正的问题是“我还在为你没接我电话而生气”。所以现在我会把一切都归咎于“这个功能根本行不通”。举个例子：某人走进……一个经理或团队领导走进会议室，开始会议时说：“我想确保听到每个人的声音。我想确保我们进行一次非常充分的对话。”

---

### [00:55:58] Carole Robin (Continued)

**English:**
I want to talk about X. And now let's say that I start to say something and before I have finished, he says, yeah, and the other thing we should talk about is blah, blah. And then a little later a similar thing happens. I start to suggest that there's another way to look at this and he turns back to somebody else, what somebody else had said and never says anything in response to what I just said. And I'm being very specific here, very behaviorally specific. And then after a while, what happens to me is I feel less and less inclined to offer up anything. Now, maybe he doesn't care, but if he cares because he started by think he wanted to hear from everybody, then I'm not being very caring if I don't tell him what the impact was of his behavior. So I don't call him out in the middle of the meeting because I don't want to embarrass him, but I might go to his office later and say, "So, John, do you have a few minutes?" I have an observation.

**中文翻译:**
“我想谈谈 X。”现在假设我开始说话，还没说完，他就说：“对，我们还应该谈谈别的，等等。”过了一会儿，类似的事情又发生了。我开始建议有另一种看待问题的方式，而他却转向另一个人，谈论那个人说过的话，对我刚才说的话没有任何回应。我在这里说得非常具体，非常针对行为。过了一会儿，我发生的变化是，我越来越不想提供任何意见了。现在，也许他不在乎，但如果他在乎（因为他一开始说想听取每个人的意见），那么如果我不告诉他他的行为产生了什么影响，我就太不体贴了。所以我不会在会议中间指责他，因为我不想让他难堪，但我可能会稍后去他的办公室说：“约翰，你有几分钟时间吗？我有一个观察。”

---

### [00:57:07] Carole Robin (Continued)

**English:**
I've got something that I experienced that you might want to know. "Sure, Carole." So when I started to say x, you did y. When I started to say z, you did it. I said, and when that you started the meeting by saying you want to hear from everybody. When that happened, I felt less and less... I felt shut down, and I felt less and less inclined to offer up my opinion. Maybe that's okay, but I wondered whether you knew that that was the impact. And I'm telling you, because as far as I am concerned, in that meeting, you did not accomplish your stated desire. Your desired outcome was to hear from everybody. And after a while, I just gave up trying to give you my...

**中文翻译:**
“我经历了一些事情，你可能想知道。”“当然可以，Carole。”“所以，当我开始说 X 时，你做了 Y。当我开始说 Z 时，你又做了那个。我说，你开始会议时说想听取每个人的意见。但当那些情况发生时，我感到越来越……我感到被压制了，我越来越不想提供我的意见。也许这没关系，但我不知道你是否意识到这就是产生的影响。我告诉你这些是因为，在我看来，在那次会议中，你没有实现你宣称的目标。你的预期结果是听取每个人的意见，但过了一会儿，我直接放弃了尝试给你提供我的……”

---

### [00:57:52] Lenny Rachitsky

**English:**
Well, it's like you need to solve these pinches as you described early, because all of this comes back to these are relationships, they matter because that's the way we get everything done. And if you just ignore these things, your relationship's going to be hurt. You're not going to be able to accomplish the things you want to accomplish. It's almost like something you need to do even though it feels hard.

**中文翻译:**
这就像你早些时候描述的，你需要解决这些“摩擦”，因为这一切都归结为：这些是人际关系，它们很重要，因为那是我们完成所有工作的方式。如果你只是忽视这些事情，你的关系就会受损。你将无法完成你想完成的事情。这几乎是你必须要做的事情，尽管它感觉很难。

---

### [00:58:14] Carole Robin

**English:**
Absolutely. And that's why I say that feedback builds relationships because by the way, if I'm doing something that I'm, I wish I hadn't done, it's not that I'm going to be like, "Oh yeah, I'm so glad I did that." But if I recognize that it would've been easier for you not to say anything because it would've been more comfortable, but because you cared about me, you actually said something to me, that talk about something that builds relationship.

**中文翻译:**
绝对正确。这就是为什么我说反馈能建立关系。顺便说一下，如果我做了一些我希望自己没做过的事，我不会想“噢耶，我真高兴我做了那件事”。但如果我意识到，对你来说保持沉默会更容易、更舒服，但因为你在乎我，你实际上对我说了些什么，这才是真正建立关系的行为。

---

### [00:58:45] Lenny Rachitsky

**English:**
Coming back to the antenna as you described feels like one of the most important skills you teach people is to build this antenna both of yourself, which is you could to think is easier, but maybe often not, but also understanding how the other person feels. And you have this concept of the art of inquiry and how powerful that is. Can you just talk about what that is?

**中文翻译:**
回到你描述的“天线”，感觉你教给人们的最重要的技能之一就是建立这两根天线：一根是对自己的（你可能觉得这更容易，但往往并非如此），另一根是理解对方的感受。你还有一个关于“探询的艺术”（art of inquiry）的概念，以及它有多么强大。你能谈谈那是什么吗？

---

### [00:59:06] Carole Robin

**English:**
Oh, yeah. I'm glad you brought that up, because inquiry is a fundamental component of strong interpersonal relationships for a couple of reasons. And first of all, let's stop and note, inquiry comes the root of the word inquiry is quest. Quest means to be in search of and not knowing what you're going to find, not the way most people think about questions and inquiries. Most of the time people ask a question to confirm a hypothesis. "Don't you think you're just trying to discredit John by doing that?" That's not inquiry. "Don't you think you'd just be better off letting that go?" That's not inquiry. And by the way, another thing to note in artful inquiry, first of all, you have to suspend judgment. You cannot be curious if you've already decided you know what's going on someone else. You can always go back to being judgmental, but you got to suspend it long enough to see if there's something for you to learn.

**中文翻译:**
噢，是的。我很高兴你提到这个，因为出于几个原因，“探询”是牢固人际关系的基本组成部分。首先，让我们停下来注意一下，“探询”（inquiry）一词的词根是“探索”（quest）。探索意味着去寻找，且不知道会发现什么，这与大多数人看待问题和探询的方式不同。大多数时候，人们提问是为了证实一个假设。“你不觉得你这样做只是为了诋毁约翰吗？”那不是探询。“你不觉得放手会更好吗？”那也不是探询。顺便说一下，在巧妙的探询中，另一件要注意的事是：首先，你必须暂停评判。如果你已经认定自己知道别人在想什么，你就无法保持好奇心。你随时可以回到评判的状态，但你必须暂停足够长的时间，看看是否有值得你学习的东西。

---

### [01:00:12] Carole Robin (Continued)

**English:**
And then the way you ask the question matters, questions that can be answered with yes or no are typically limiting questions and aren't going to be very productive. Questions that start with why, why did you do that? Are going to make me defensive? Or worse, why are you crying? Well, is that going to make me want to tell you more about why I am upset or why are you upset? Right away I'm going to go into, "Oh no, I'm not upset. It's not a big deal." Or I'm going to go into a place that's not necessarily very productive because this reminds me of how my mother always scolded me. Neither one is going to be very productive. So questions that start with what? What's this about? What's going on? Where is this manifesting? When did you see this happen last? How might we go about unpacking what's going on? Where is this happening most? When, where, how, stay away from why. And it's a whole art.

**中文翻译:**
其次，你提问的方式很重要。可以用“是”或“否”回答的问题通常是限制性问题，不会很有成效。以“为什么”开头的问题，比如“你为什么那样做？”，会让我产生防御心理。或者更糟，“你为什么哭？”这会让我更想告诉你我为什么难过吗？或者“你为什么不高兴？”我会立刻进入防御状态：“噢不，我没有不高兴，没什么大不了的。”或者我会进入一个不一定很有成效的状态，因为这让我想起我母亲总是责备我的样子。这两种情况都不会很有成效。所以，要问以“什么”开头的问题：“这是关于什么的？”、“发生了什么？”、“这表现在哪里？”、“你上次看到这种情况是什么时候？”、“我们该如何拆解正在发生的事情？”、“这种情况最常发生在哪里？”。用“什么时候”、“在哪里”、“如何”，远离“为什么”。这是一门完整的艺术。

---

### [01:01:14] Lenny Rachitsky

**English:**
Something else you teach people and you're big on is that people can actually change themselves. I think a lot of people might feel like, I'm just not good at this. I'm not good at giving feedback. I'm not good at maybe asking questions. I'm just like, I don't know. Talk about what you found about the change people see and why it's actually possible and how.

**中文翻译:**
你教给人们的另一件事，也是你非常坚持的一点，就是人们实际上是可以改变自己的。我想很多人可能会觉得：“我就是不擅长这个。我不擅长给反馈。我不擅长提问。我就是这样，没办法。”请谈谈你发现的人们所经历的改变，为什么这实际上是可能的，以及如何实现。

---

### [01:01:35] Carole Robin

**English:**
Well, for starters, to any of your listeners, one of my very favorite authors is Carol Dweck who wrote a book called Mindset and you put a word yet at the end of any of those, I don't know how yet, I'm not like that yet, changes the meaning of the whole thing. And by the way, talk about updating a mental model, instant update of a mental model. And the other thing that I'll say is we are all capable of changing our behavior. We cannot change our personality. We are born wired with personalities. I am very outgoing and extroverted as might come as a shock to all of you. And you know what? When I overdo it, I suck all the oxygen out of the room and one of the behaviors I had to learn, and it takes discipline to engage in was zipping it a little more so that others could speak up more.

**中文翻译:**
首先，对你的听众们说，我最喜欢的作者之一是 Carol Dweck，她写了一本叫《终身成长》（Mindset）的书。你在刚才那些话的末尾加一个词“还”（yet）——“我还不知道怎么做”、“我还不是那样的人”——整个意思就变了。顺便说一下，谈到更新心智模型，这就是瞬间更新。我想说的另一件事是，我们都有能力改变自己的行为。我们无法改变性格，性格是天生的。我非常外向，这可能会让你们所有人感到震惊。但你知道吗？当我做得过头时，我会吸干房间里所有的氧气（指话太多让别人没法说）。我必须学习的一种行为（这需要自律）就是多闭一会儿嘴，好让别人能多说一点。

---

### [01:02:40] Carole Robin (Continued)

**English:**
And my incentive was that I actually really wanted to learn more about what was going on for them and I wasn't going to learn anything unless I shut up long enough for them to tell me. So behavior is something we all have control over. Now when I give somebody feedback and they tell me, well, I can't do that. If I've asked them to change a behavior, then I'll say, I'm sorry, I don't think I can accept I can't. I will accept I don't want to or I don't have it, but I don't have to accept I can't. So I'd just like you to own the fact that it's a choice that you're making.

**中文翻译:**
我的动力在于，我真的很想更多地了解他们那边发生了什么，而除非我闭嘴足够长的时间让他们告诉我，否则我什么也学不到。所以，行为是我们每个人都可以控制的。现在，当我给某人反馈而他们告诉我“好吧，我做不到”时，如果我要求他们改变的是一种行为，我会说：“抱歉，我想我不能接受‘做不到’。我可以接受‘我不想做’或‘我还没掌握’，但我不需要接受‘做不到’。所以我只是希望你承认，这是你正在做出的一个选择。”

---

### [01:03:25] Lenny Rachitsky

**English:**
Kind of along those lines, something, I don't know if this is from your book, but I saw somewhere you said that it's possible to say almost anything to almost anyone if you have the necessary skills. How do people build these skills? I know we talked about a lot of this through the structure focusing on your side of the net, but just how do you avoid people getting defensive?

**中文翻译:**
顺着这个思路，我不知道这是不是出自你的书，但我看到你在某个地方说过：如果你具备必要的技能，几乎可以对任何人说任何话。人们如何培养这些技能？我知道我们通过“关注你这半边的网”的结构讨论了很多，但究竟如何避免人们产生防御心理呢？

---

### [01:03:43] Carole Robin

**English:**
First of all, let's make sure that we point out that what we're doing here is we're shifting probabilities of success, we're not guaranteeing anything. And let's say that you do your best and you stay on your side of the net and you give somebody feedback and they go bonkers and they call you all kinds of names and they write... Now there's an opportunity to learn something else that everybody learns in these programs, which is called repair. How do you repair when something goes sideways? Because no matter how good you are, no matter how skilled you get, no matter what your intent was, sometimes it won't work. And then you've got to know how to repair. And that's why, remember I told you that our facilitators have a unique set of skills? And that's because they have to allow messes to happen otherwise nobody's going to learn how to repair. And repair often goes back to some of what we've already talked about. Let's start with I come in the kitchen, my husband's struggling. I say to him, "Can I help you with that?" He says, "Don't tell me what to do."

**中文翻译:**
首先，我们要明确一点：我们在这里做的是提高成功的概率，而不是保证任何结果。假设你尽了最大努力，留在你这半边的网内，给某人反馈，结果他们发疯了，对你百般辱骂，还写信……现在，这就是学习另一件事的机会，每个人在这些项目中都会学到，那就是“修复”（repair）。当事情搞砸时，你如何修复？因为无论你多么优秀，无论你多么熟练，无论你的意图是什么，有时它就是行不通。那时你就必须知道如何修复。这就是为什么，记得我告诉过你我们的引导员有一套独特的技能吗？那是因为他们必须允许混乱发生，否则没有人能学会如何修复。修复通常会回到我们已经讨论过的一些内容。举个例子：我走进厨房，我丈夫正忙得不可开交。我对他说：“我能帮你吗？”他说：“别告诉我该怎么做。”

---

### [01:05:04] Carole Robin (Continued)

**English:**
I'm sure none of your listeners can relate to this story. And I say, instead of, "I wasn't trying to tell you what to do, I was just trying to be helpful. What a kind of way to respond to my offering help is that?" I say, "What did you hear me say?" One of the most powerful things you can do when somebody responds in a way that feels very unexpected and out of whack with what you just said is go back to, "What did you hear me say?" Because nine times out of 10 what they heard is not what you said. He said, "I heard you say I didn't know what I was doing." Now, by the way, it didn't matter. That's not what I said. And I didn't say, that's not what I said. I said, "Wow, really glad I asked, because now that I understand that that's what you heard, I understand why you reacted the way you did." And I said, "Let me try it again."

**中文翻译:**
我相信你的听众里肯定没人经历过这种事（讽刺）。我没有说：“我没想告诉你该怎么做，我只是想帮忙。你对我提供的帮助就是这种反应吗？”而是说：“你听到我说了什么？”当某人的反应非常出乎意料、与你刚才说的话完全不符时，你能做的最强大的事情之一就是回到：“你听到我说了什么？”因为十有八九，他们听到的并不是你所说的。他说：“我听到你说我不知道自己在做什么。”顺便说一下，这不重要，那不是我说的。但我没有说“那不是我说的”，我说：“哇，真高兴我问了，因为既然我知道了你听到的是那个意思，我就理解你为什么会有那样的反应了。”然后我说：“让我再试一次。”

---

### [01:06:04] Carole Robin (Continued)

**English:**
One of the ways that I show somebody that I love them is I offer to help and what would you like me to do if in a situation like this when I see you struggling? He says, "Wait for me to ask." And that was 25 years ago, and that has served us very well because we've been married 37 years, 39 years. And if we go back to feedback, you give somebody feedback, they get super defensive. By the way, net jumping invites net jumping, so they're likely to net jump too. And by the way, the minute you label somebody or you're over the net. In fact you sent me something that was really interesting that I wanted to find here because you said "Nobody is born with genes for being rude or self-involved." Well, guess what?

**中文翻译:**
“我向某人表达爱意的方式之一就是提供帮助。在这种情况下，当我看到你忙不过来时，你希望我怎么做？”他说：“等我开口求助。”那是 25 年前的事了，这对我们很有帮助，因为我们已经结婚 37 年、39 年了。回到反馈，你给某人反馈，他们变得非常有防御性。顺便说一下，“越网”会招致“越网”，所以他们也很可能会越过网来。顺便说一下，一旦你给某人贴标签，你就越网了。事实上，你发给我的一些东西非常有趣，我想在这里找出来，因为你说过：“没有人天生就有粗鲁或自私的基因。”那么，你猜怎么着？

---

### [01:06:56] Carole Robin (Continued)

**English:**
Rude and self-involved are labels that is not behaviorally specific. So calling somebody rude or self-involved is just going to make them defensive. But saying, I was interrupted three times, and I'm telling you this because you said you wanted to hear my opinion and I just thought you should know that I was put off by being interrupted, much less likely to incite defensiveness.

**中文翻译:**
“粗鲁”和“自私”是标签，不是具体的行为描述。所以称某人粗鲁或自私只会让他们产生防御心理。但如果说：“我被打断了三次。我告诉你这些是因为你说过想听我的意见，我只是觉得你应该知道，被打断让我感到很不舒服。”这样做引起防御的可能性要小得多。

---

### [01:07:34] Lenny Rachitsky

**English:**
Absolutely. Just hearing what actually happened, staying on your side of the net.

**中文翻译:**
绝对正确。只是陈述实际发生的事情，留在你这半边的网内。

---

### [01:07:38] Carole Robin

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:07:39] Lenny Rachitsky

**English:**
So again, this always comes back to I could see this being so effective doing this in a class versus just listening to us and like, okay, I'm going to start staying in my side of the net and I'm going to prepare relationships. Are there any other examples of exercises you do in the class that might be helpful to people just to hear how you learn some of these things?

**中文翻译:**
所以，这又回到了原点：我能看出在课堂上练习这些是多么有效，而不是仅仅听我们说“好吧，我要开始留在网的这一边，我要修复关系”。还有其他课堂练习的例子吗？也许对大家了解如何学习这些东西会有帮助。

---

### [01:07:57] Carole Robin

**English:**
Every chapter in the book has a section at the end called Deepen Your Learning and those deep in your learning sections, every single one of them has a suggested activity, something you can go do, and some of those come from some of the things we do in the classroom. So that's one place to start in terms of trying to find very tactical and practical ways of applying some of this. The other thing that we often do, I often do in leaders in Tech, I used to do this less at Stanford because they did a lot of this in their T groups and they were actually in real time with each other putting everything they were learning to use. But sometimes with my execs in Leaders in Tech, I will, for example, put them in a trio and I will say to you, so Lenny, I want you to think of somebody who you would like to give feedback to and I want you to tell me what's the behavior they're engaging in?

**中文翻译:**
书中的每一章末尾都有一个叫“深化学习”的板块。在这些深化学习板块中，每一个都有建议的活动，你可以去尝试，其中一些就源自我们在课堂上做的事情。所以，如果你想寻找非常战术化和实用的应用方法，这是一个开始的地方。另一件我们经常做的事（我经常在 Leaders in Tech 中做，以前在斯坦福做得少一些，因为他们在 T 小组中做了很多，而且他们是实时地将所学付诸实践），有时我会让 Leaders in Tech 的高管们三人一组，我会对你说：“Lenny，我想让你想一个你想给反馈的人，告诉我他们有什么样的行为？”

---

### [01:09:04] Carole Robin (Continued)

**English:**
How does it make you feel? What would be behind you wanting to tell them? What would be your desired outcome to the conversation? Then I become you, you become your difficult person because you know them and I don't, and we role play because you've now told me what you need, what you want, what's going on for you, and then you have to play your difficult person as well as you can. The third person's usually the observer who pinch hits and says, "Carole, I think that was over the net." "Carole, I don't think that was a behavior." And by the way, we say, I feel insert feeling, nine times out of 10 people say, I feel that, or I feel like, I feel that you don't care is not a feeling.

**中文翻译:**
“那让你感觉如何？你为什么要告诉他们？你希望对话达到什么结果？”然后我扮演你，你扮演那个“难搞的人”，因为你了解他们而我不了解。我们进行角色扮演，因为你已经告诉了我你的需求、你的愿望以及你正在经历的事情，然后你必须尽力扮演那个难搞的人。第三个人通常是观察员，他会随时介入说：“Carole，我觉得那句话越网了。”“Carole，我觉得那不是一个行为描述。”顺便说一下，当我们说“我感到[插入感受]”时，十有八九人们会说“我觉得……”（I feel that）或“我感觉像是……”（I feel like）。“我觉得你不在乎”并不是一种感受。

---

### [01:09:56] Carole Robin (Continued)

**English:**
I feel like it doesn't matter, is not a feeling. I feel that you're not committed is not a feeling. In fact, they're all over the net. You're almost guaranteed to be over the net when you start I feel and put in like or that, guaranteed. Very easy hack. I feel pull up vocabulary feeling, you can't say grammatically correctly. I feel that sad or I feel that angry, or I feel that irritated or I feel like disappointed, doesn't work.

**中文翻译:**
“我感觉这不重要”不是感受。“我觉得你不够投入”也不是感受。事实上，这些都越网了。当你以“我感到”开头，后面跟着“像是”或“……（从句）”时，你几乎肯定越网了，百分之百。一个非常简单的窍门：说“我感到”，然后直接接情感词汇。在语法上，你不能说“我感到那个悲伤”或“我感到那个愤怒”，或者“我感到那个恼火”，或者“我感觉像是失望”，这行不通。

---

### [01:10:28] Lenny Rachitsky

**English:**
This is amazing marriage advice going to, I need to remember these things.

**中文翻译:**
这真是太棒的婚姻建议了，我得记住这些。

---

### [01:10:34] Carole Robin

**English:**
Yeah. Many married couples have bought the book together and read it together actually, which is cool.

**中文翻译:**
是的。实际上很多夫妇一起买书并一起阅读，这很酷。

---

### [01:10:41] Lenny Rachitsky

**English:**
There's a few other things I want to touch on that I love. One is a tip that you share. You call it advise hinders relationships.

**中文翻译:**
还有几件我非常喜欢的事情想聊聊。其中一个是你的建议，你称之为“建议会阻碍关系”。

---

### [01:10:49] Carole Robin

**English:**
Oh, I'm really glad you asked me about that because two things, a couple of things. First of all, leaders often believe this is another mental model that they have to have all the answers, and that is actually a pretty, it's not a very productive mental model or belief because first of all, puts a huge amount of pressure on the leader. Now suddenly I always have to know and what happens when I don't know. Second of all, I believe a leader's job is to ensure the best answer is found. It doesn't matter whether it comes from me or anywhere else in the organization. It also allows for the possibility that somebody else may have a better answer than me. And a really, really good solution has been squelched and never surfaced because people are afraid to say, well, I see it a little differently. What if we did this?

**中文翻译:**
噢，我很高兴你问这个，因为有两点，或者说几点。首先，领导者通常相信（这是另一个心智模型）他们必须拥有所有答案。这实际上是一个不太高效的心智模型或信念，因为首先，它给领导者带来了巨大的压力——突然之间我必须无所不知，而当我不知道时该怎么办？其次，我认为领导者的职责是确保找到“最佳答案”。这个答案是来自我，还是来自组织中的其他任何地方，这并不重要。它还允许了别人可能拥有比我更好的答案的可能性。很多非常棒的解决方案被压制了，从未浮出水面，因为人们害怕说：“嗯，我的看法有点不同。如果我们这样做会怎样？”

---

### [01:11:50] Carole Robin (Continued)

**English:**
We had a or disaster as a result of that. The other thing about advice is that it creates even bigger power differentials between people. So if you're the leader or you're in the higher power position to start with, then giving me advice is only going to make me feel even lower power as opposed to, well, let's think about this together. Let's be thought partners. Often when we give advice, it's a good thing to stop yourself and ask yourself, "Who am I doing this for? Am I doing this for me so that I can puff myself up with everything I know or am I doing it for you because this is really going to help you and make you better?"

**中文翻译:**
我们曾因此遭受过灾难。关于建议的另一件事是，它会在人与人之间制造更大的“权力差距”。如果你是领导者，或者你本来就处于权力较高的位置，那么给我建议只会让我感到权力更低，而不是“好吧，让我们一起思考，让我们成为思想伙伴”。通常当我们给出建议时，最好停下来问问自己：“我这样做是为了谁？是为了我自己，好让我用我所知道的一切来抬高自己？还是为了你，因为这真的能帮助你并让你变得更好？”

---

### [01:12:34] Carole Robin (Continued)

**English:**
Nine times out of 10, being a thought partner as you explore the various options and coming to your own solution is both going to help you develop more, and then you're not going to have to come ask me again if the only time you ever learn is when you come ask me and you don't go through any of the work or figuring out how I got to that answer, well, then I've just made more work for myself.

**中文翻译:**
十有八九，在你探索各种选项并得出自己的解决方案时做一个“思想伙伴”，既能帮助你获得更多成长，也能让你以后不必再来问我。如果你唯一的学习机会就是来问我，而不经历任何思考过程或弄清楚我是如何得出答案的，那么我只是在给自己增加工作量。

---

### [01:13:03] Lenny Rachitsky

**English:**
There's this great Harvard Business Review post I just read about monkeys on your back. Have you heard of this?

**中文翻译:**
我刚读过一篇很棒的《哈佛商业评论》文章，讲的是“背上的猴子”。你听说过吗？

---

### [01:13:09] Carole Robin

**English:**
Yes.

**中文翻译:**
听说过。

---

### [01:13:09] Lenny Rachitsky

**English:**
Yeah. Where basically as a manager, people are always trying to put monkeys on your back to have you solve their problem, and your job as a manager is to keep the monkeys on their own backs and help them.

**中文翻译:**
是的。基本上作为经理，人们总是试图把“猴子”放到你的背上，让你帮他们解决问题。而你作为经理的职责是让猴子留在他们自己的背上，并提供协助。

---

### [01:13:19] Carole Robin

**English:**
Yes, and I'm glad you brought that up because people then have become so used to the quick shortcut is you'll just give me the answer. First of all, you have enabled powerlessness. You certainly haven't helped them learn and grow. If you at all think your job as a manager is to at least sometimes do that, and sometimes people will say, "Can't you just give me the answer?" And then I always just say, I could and here's why I'm not going to because I don't think that'll serve you because that's not my job. My job isn't just to give you the answers. My job is to turn you into somebody who eventually will just know what the right answer is.

**中文翻译:**
是的，我很高兴你提到这个。因为人们已经习惯了走捷径，觉得“你直接给我答案就行了”。首先，你助长了对方的无能感。你肯定没有帮助他们学习和成长。如果你认为作为经理，你的职责至少有时是提供答案，那么有时人们会说：“你就不能直接告诉我答案吗？”然后我总是会说：“我可以，但我不会这样做，因为我认为这对你没有好处，因为那不是我的工作。我的工作不只是给你答案，我的工作是把你变成一个最终能自己知道正确答案的人。”

---

### [01:14:03] Lenny Rachitsky

**English:**
But just give me the answer. Does this apply to friendships also? I know often people come to you as a friend, I need some advice on this. Does this apply as well? Often try not to give advice, or is it a different dynamic there?

**中文翻译:**
“但就直接给我答案吧。”这在友谊中也适用吗？我知道通常人们会作为朋友来找你：“我需要一些这方面的建议。”这是否也适用？通常也要尽量不给建议吗？还是说那里的动态不同？

---

### [01:14:20] Carole Robin

**English:**
Well, some of the same power differential can happen. I think chapter four in the book is about two guys who were good friends and one of them is always trying to give advice to the other one. First of all, it can be annoying if you didn't ask for it. So I certainly wouldn't give advice unless somebody asked for it, and I might not immediately jump to the advice, I might want to explore. What have you already thought about? How have you already approached it? Where are you stuck? I might ask more questions before I immediately go into advice because by the way, nine times out of 10, you end up giving advice on something that's not really what the person was worried about or wondering about. So first go to inquiry. You can always come back to advice.

**中文翻译:**
嗯，同样的权力差距也可能发生。我想书中的第四章讲的就是两个好朋友，其中一个总是试图给另一个建议。首先，如果你没要求建议，这可能会让人很烦。所以我肯定不会给建议，除非有人要求。而且我也不会立刻跳到建议上，我可能会想先探索一下：“你已经考虑过什么了？”、“你已经尝试过什么方法了？”、“你卡在哪里了？”在直接给出建议之前，我可能会问更多问题。因为顺便说一下，十有八九，你最后给出的建议并不是那个人真正担心或疑惑的事情。所以，先进行探询。你随时可以再回到建议上。

---

### [01:15:21] Lenny Rachitsky

**English:**
I find that every time I try to resist or I make myself resist giving advice and instead ask more questions, every single time, I realized, okay, I had no idea what they were actually looking for or what was going on, but it's hard to do. I'm just like, here, I just want to tell you, here's the thing.

**中文翻译:**
我发现，每次我试图克制或强迫自己不去给建议，而是问更多问题时，每一次我都会意识到：“好吧，我根本不知道他们到底在寻找什么，或者到底发生了什么。”但这很难做到。我总是想：“拿去吧，我只想告诉你，事情是这样的。”

---

### [01:15:39] Carole Robin

**English:**
Totally. Because you know what? It's another mental model. I serve you best by just giving you advice when you ask for it, that's the loving, caring thing to do. Well, it's a mental model. Try testing it and seeing whether or not it really turns out to still be valid.

**中文翻译:**
完全理解。因为你知道吗？那是另一个心智模型：“当你向我求助时，我直接给你建议是对你最好的帮助，那是充满爱和关怀的表现。”嗯，这只是一个心智模型。试着测试一下它，看看它是否真的依然有效。

---

### [01:15:58] Lenny Rachitsky

**English:**
And so maybe the more correct mental model is how would you describe it that it's often better to help the person figure it out, or is it that you just often don't actually understand what's going on?

**中文翻译:**
所以也许更正确的心智模型是……你会如何描述它？是“帮助对方自己弄清楚通常更好”，还是“你通常其实并不了解到底发生了什么”？

---

### [01:16:09] Carole Robin

**English:**
The best thing to do first go to inquiry. Because by the way, I also, as you might imagine, I tend to err very much on the side of transparency, and so I'll say, man, I got all kinds of things going on in my head about what I think would be great for you to do, and I'm going to resist that because I, first of all may or may not hit the mark, so I'd really like to understand more. And second of all, I wonder if in the end be even more fruitful if we explore different things together.

**中文翻译:**
最好的做法是先进行探询。因为顺便说一下，正如你能想象的，我倾向于非常透明。所以我会说：“伙计，我脑子里有很多关于我认为你该怎么做的想法，但我打算克制住。因为首先，我的想法可能并不准，所以我真的很想了解更多。其次，我在想，如果我们一起探索不同的可能性，最终是否会更有成效。”

---

### [01:16:46] Lenny Rachitsky

**English:**
Just a few more questions. One is, so we have this segment on the podcast that I call Failure Corner, where people share failure in their career and what they learn from it, and you have a really constructive way of thinking about failure with this great acronym. Can you talk about that?

**中文翻译:**
最后还有几个问题。一个是，我们播客有一个环节叫“失败角落”，人们分享职业生涯中的失败以及从中吸取的教训。你有一种非常建设性的看待失败的方式，还有一个很棒的缩写词。你能谈谈吗？

---

### [01:17:02] Carole Robin

**English:**
The acronym is A-F-O-G, another F-ing... I don't know your audience well enough. Don't want to offend anybody.

**中文翻译:**
这个缩写词是 A-F-O-G，也就是“另一个该死的……”（another F-ing...）。我不太了解你的听众，不想冒犯任何人。

---

### [01:17:11] Lenny Rachitsky

**English:**
Go for it. If you feel like-

**中文翻译:**
说吧。如果你觉得——

---

### [01:17:12] Carole Robin

**English:**
Another Fucking Opportunity for Growth. Every student who ever took a class from me, every client who I have ever coached, every participant who's ever gone through Leaders in Tech knows that acronym because my question, when something has gone wrong or a person has experienced a failure, my first question is always, so what did you learn? Because there's always a lesson, and then usually what follows is, yeah, you just had an AFOG. And as a person who's had a lot of AFOGs throughout my life, it puts it in perspective. I like the perspective that it offers, so it's not the end of the world. Sometimes AFOGs are more painful than others. Some AFOGs take longer to recover from than others. Most of the time they're recoverable, particularly if I've invested the energy in really unpacking what there was for me to be to learn.

**中文翻译:**
“又一个该死的成长机会”（Another Fucking Opportunity for Growth）。每一个上过我课的学生、每一个我指导过的客户、每一个参加过 Leaders in Tech 的人，都知道这个缩写词。因为当事情出错或某人经历失败时，我的第一个问题总是：“那么，你学到了什么？”因为总会有教训。然后通常接着会说：“是的，你刚刚经历了一个 AFOG。”作为一个一生中经历过很多 AFOG 的人，它能让你换个角度看问题。我喜欢它提供的视角，所以这不是世界末日。有时 AFOG 比其他的更痛苦，有些 AFOG 需要更长的时间来恢复。大多数时候它们是可以恢复的，特别是如果我投入精力去真正拆解其中值得我学习的东西。

---

### [01:18:27] Lenny Rachitsky

**English:**
Yeah. So the advice here is when something goes wrong, when you fail, think of it as another fucking opportunity for growth, AFOG.

**中文翻译:**
是的。所以这里的建议是：当事情出错、当你失败时，把它看作“又一个该死的成长机会”，AFOG。

---

### [01:18:27] Carole Robin

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:18:27] Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:18:35] Carole Robin

**English:**
That's exactly right.

**中文翻译:**
完全正确。

---

### [01:18:37] Lenny Rachitsky

**English:**
To even go full circle to where we started building exceptional relationships, building robust relationships. In the book, you have this checklist of just how to build an exceptional relationship. I know you don't have all this in your head, whatever.

**中文翻译:**
让我们回到最初的话题：建立卓越的关系、建立稳固的关系。在书里，你有一个关于如何建立卓越关系的清单。我知道你可能没法全部背下来，没关系。

---

### [01:18:49] Carole Robin

**English:**
Actually I probably do.

**中文翻译:**
实际上，我可能记得。

---

### [01:18:50] Lenny Rachitsky

**English:**
You probably do. What's on this list of just things you can do to build exceptional relationships?

**中文翻译:**
你可能真的记得。这个清单上关于建立卓越关系的事情有哪些？

---

### [01:18:57] Carole Robin

**English:**
Well, you can go back to the fact that there are six characteristics of exceptional relationships, and actually those are the characteristics that are present as a relationship is moving down this continuum that we've talked about. And the more each of these exists, the farther down the continuum you are. So the first one is I'm better known by you, and of course there's skills involved in how do I allow myself to be known. The second one is, I know you better and there's skills involved in getting to know you better. We've talked about many of them. The third one is we trust that our disclosures won't be used against us. The fourth one is we can be honest with each other. That's where all the feedback comes in. The fifth one is we know how to resolve conflict productively, and the sixth one is we are committed to each other's learning and growth. And when all six of those are present to varying degrees, you've moved farther down the continuum.

**中文翻译:**
嗯，你可以回到卓越关系的六个特征。实际上，这些特征是随着关系在我们讨论的光谱上移动而出现的。这些特征存在的程度越高，你在光谱上走得就越远。第一：我被你了解得更多（当然，这涉及如何让自己被了解的技能）。第二：我更了解你（这涉及更好地了解你的技能，我们讨论过很多）。第三：我们信任彼此的表露不会被用来对付自己。第四：我们可以对彼此诚实（这就是所有反馈发挥作用的地方）。第五：我们知道如何富有成效地解决冲突。第六：我们致力于彼此的学习和成长。当这六个特征在不同程度上都具备时，你就已经在光谱上走得很远了。

---

### [01:20:00] Lenny Rachitsky

**English:**
You wrote somewhere that you know your relationship has become exceptional when you and the other person don't have to hide important parts of yourself and can deal with major issues even if it feels scary.

**中文翻译:**
你在某个地方写过：当你和对方不需要隐藏自己重要的部分，并且即使感到害怕也能处理重大问题时，你就知道你们的关系已经变得卓越了。

---

### [01:20:10] Carole Robin

**English:**
Yep. I did write that somewhere and I stand by that.

**中文翻译:**
是的。我确实写过，而且我坚持这个观点。

---

### [01:20:15] Lenny Rachitsky

**English:**
If you zoom out from all of your work and teachings, are there any overarching themes that continue to come up that you think are important for people to take away from this conversation?

**中文翻译:**
如果你从你所有的工作和教学中抽离出来看，有没有什么贯穿始终的主题是不断出现的，且你认为对人们从这次对话中汲取营养非常重要的？

---

### [01:20:28] Carole Robin

**English:**
Well, for starters, we're all works in progress, which means every relationship in your life is a work in progress. Because if I'm a work in progress and you're a work in progress, then by default so is our relationship. And so remembering that what worked with you two years ago may or may not work for you now because we're different people. So I think that's a biggie. I think stopping and becoming aware of what are the mental models that are driving these choices that I'm making, every behavior has in front of it a choice. If we stop long enough to become aware of it and in front of every choice, there's some belief. So I try to march myself back from the result to the behavior, to the choice, to the mental model that drove it or the skill or lack of skill.

**中文翻译:**
首先，我们都是“半成品”（works in progress），这意味着你生命中的每一段关系也都是半成品。因为如果我是半成品，你也是半成品，那么默认情况下我们的关系也是。所以要记住，两年前对你有效的方法，现在可能对你无效，因为我们都变了。我认为这是一个重点。其次，停下来并意识到是什么样的心智模型在驱动我做出的这些选择。每一种行为背后都有一个选择。如果我们停下来足够长的时间去觉察它，就会发现每一个选择背后都有某种信念。所以我试着让自己从结果倒推到行为，再到选择，最后到驱动它的心智模型，或者是技能（或缺乏技能）。

---

### [01:21:36] Lenny Rachitsky

**English:**
Something that we didn't talk about at the beginning of this because it might distract people, but you've been dealing with Long COVID for almost two years at this point. Where are you at with it? How are things going and is there anything you've learned from this unexpected part of your life?

**中文翻译:**
有一件事我们一开始没谈，因为怕分散大家的注意力，但你目前已经与“长新冠”（Long COVID）抗争了近两年。你现在的状况如何？情况怎么样？从这段意外的人生经历中你学到了什么吗？

---

### [01:21:54] Carole Robin

**English:**
It's given me an opportunity to live a lot of what I teach. So I always taught in my leadership classes that the worst thing a leader can do is make an organization too dependent on them. If you care about building a sustainable long-term organization and a legacy, then it behooves you not to make the organization very dependent on you. So over the last 20 months, I have slowly and surely given more and more of my responsibilities to more and more members of the team to the point where hot off the press, I'm about to become only an advisor and step out of really all of my operational duties probably by the end of this year. Now, there was a point at which I was like, and oh my God, what happens if I get better suddenly? Because people do get better, and one of my very wise children said, "Mom, I'm pretty sure that if you suddenly get a lot better, they'll be happy to give you lots of stuff to do." So, anyway, that's one of probably the biggest lessons, and also it goes with a lesson around acceptance and accept.

**中文翻译:**
它给了我一个机会去践行我所教的很多东西。我总是在领导力课程中讲，领导者能做的最糟糕的事就是让组织过度依赖自己。如果你在乎建立一个可持续的长期组织和一份事业，那么你就应该避免让组织非常依赖你。所以在过去的 20 个月里，我缓慢而坚定地将越来越多的职责交给了越来越多的团队成员。最新的消息是，到今年年底，我可能将只担任顾问，并退出几乎所有的运营职责。曾几何时，我想：“天哪，如果我突然康复了怎么办？”因为人们确实会康复。我一个非常聪明的孩子说：“妈，我很确定如果你突然好转了，他们会很乐意给你安排很多事情做的。”总之，这可能是最大的教训之一，它也伴随着关于“接纳”的教训。

---

### [01:23:25] Carole Robin (Continued)

**English:**
I wrote a LinkedIn, I think a LinkedIn, not a blog paper, one of those LinkedIn things. If you go to my website, you can look at things I've written, I think it was called Long COVID and Acceptance or something like that. But it's about how acceptance is not resignation, and it's about having an opportunity to rethink a lot of things and reframe beliefs. And I think the last thing I'll say about it is that it has made me a much more empathetic person, and I think one of the really interesting and important things to learn and have always continued to learn in doing the interpersonal dynamics work we do is you never know what's going on for someone else.

**中文翻译:**
我写了一篇 LinkedIn 文章，不是博客论文，就是那种 LinkedIn 动态。如果你去我的网站，可以看到我写的东西，我想题目叫《长新冠与接纳》之类的。它是关于“接纳”不等于“放弃/无奈接受”，它是关于拥有一个重新思考很多事情、重塑信念的机会。关于这一点我想说的最后一件事是，它让我变成了一个更有同理心的人。我认为，在我们所做的人际动力学工作中，最有趣且最重要的一点（也是我一直在学习的）就是：你永远不知道别人正在经历什么。

---

### [01:24:26] Carole Robin (Continued)

**English:**
And one of the worst things we can do is assume we know what's going on for someone else, and it's really easy to get really... I think I said this before we even got online, which is in the absence of data, people make shit up. So if you don't want people to make shit up about you, you're better off disclosing more because then you'll have more control over your self-definition, not less. People like to make sense of things. They will connect dots however way they want to unless you help them connect them the way you want them to. Another case for self-disclosure.

**中文翻译:**
我们能做的最糟糕的事情之一就是假设我们知道别人在经历什么。这很容易变得……我想我在我们上线之前就说过：在缺乏数据的情况下，人们会瞎编。所以，如果你不想让别人瞎编关于你的事，你最好多表露一些，因为那样你对“自我定义”的控制权会更多，而不是更少。人们喜欢把事情合理化，他们会按照自己的意愿把点连成线，除非你帮助他们按照你想要的方式去连接。这是支持自我表露的又一个理由。

---

### [01:25:04] Lenny Rachitsky

**English:**
Well, Carole, I'm incredibly thankful that you made time for this. I know it's not the easiest thing to do these things.

**中文翻译:**
好了，Carole，我非常感谢你能抽出时间。我知道做这些事并不容易。

---

### [01:25:10] Carole Robin

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:25:11] Lenny Rachitsky

**English:**
To remind people where to find Leaders in Tech and how to apply, tell them the website and who it's for specifically, so the right people go there. And then finally, just how can listeners be useful to you as a final question?

**中文翻译:**
为了提醒大家在哪里可以找到 Leaders in Tech 以及如何申请，请告诉他们网址以及它具体是面向谁的，好让合适的人去申请。最后，作为一个结束问题，听众们能为你做些什么？

---

### [01:25:23] Carole Robin

**English:**
I'm on LinkedIn. You won't be able to just connect with me. I've got one of those things where you can't just connect. You need my email address so you can put my email address in the notes. Anybody's more than welcome... But if you connect with me, please don't try to sell me anything. The only reason it's set up that way is that too many people were trying to sell me too many things and I got exasperated. That's the only reason they wanted to connect. So I'm just going to trust that you'll reach out to me because you want to connect with me because you're interested in my work and that you'll also know and be sensitive to the fact that I have Long COVID. So my capacity to respond to messages and emails is definitely impacted. I used to be one of those you could count on me to always respond. By the way, another learning. It turns out everybody didn't write me off just because I couldn't respond to them right away.

**中文翻译:**
我在 LinkedIn 上。你不能直接加我好友，我设置了权限。你需要我的电子邮箱地址，所以你可以把我的邮箱放在介绍里。非常欢迎任何人……但如果你联系我，请不要试图向我推销任何东西。我之所以这样设置，是因为有太多人试图向我推销太多东西，让我感到很恼火。那是他们想建立联系的唯一原因。所以我相信你会联系我是因为你想和我建立连接，因为你对我的工作感兴趣。同时，我也希望你能了解并体谅我有长新冠的事实。所以我回复消息和邮件的能力确实受到了影响。我以前是那种你可以指望我总是秒回的人。顺便说一下，这是另一个收获：事实证明，大家并不会仅仅因为我没能立即回复就放弃我。

---

### [01:26:14] Lenny Rachitsky

**English:**
That is a really great learning. Okay. And then the website for people that may want to apply and the applications are still open basically by the time this is leadersintech.org?

**中文翻译:**
这真是一个很棒的收获。好的。那么对于想要申请的人，网址是 leadersintech.org，而且在节目播出时申请基本上还是开放的，对吗？

---

### [01:26:23] Carole Robin

**English:**
Right.

**中文翻译:**
对。

---

### [01:26:24] Lenny Rachitsky

**English:**
Amazing. Carole, you are wonderful. Thank you so much for making time for this. Thank you for being here.

**中文翻译:**
太棒了。Carole，你太出色了。非常感谢你抽出时间。谢谢你能来。

---

### [01:26:32] Carole Robin

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:26:33] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众找到本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。