# Casey Winters_ - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Casey Winters.

---

### [00:00:00] Casey Winters

**English:**
Every new person on the product team is acting like they work at Google and have these infinite resources and infinite time to make sure everything is perfect. It became such this focus on the right way of doing product management that no one's taken any risk. I felt like, oh, am I responsible for this? I've created a bunch of frameworks on Reforge. I'm onboarding these new PMs. Is this my fault? At Reforge, we're building frameworks that are tools in a toolkit. You pull them out when relevant. They're not a coloring book to stay inside the lines of.

**中文翻译:**
产品团队里的每个新人都表现得好像他们在谷歌工作一样，拥有无限的资源和无限的时间来确保每件事都尽善尽美。大家变得如此专注于“正确的产品管理方式”，以至于没有人愿意承担任何风险。我觉得，噢，我对此有责任吗？我在 Reforge 上创建了一堆框架，我还在引导这些新入职的产品经理。这是我的错吗？在 Reforge，我们构建的框架是工具箱里的工具。你在相关的时候把它们拿出来用，而不是一本让你必须在线条内涂色的填色本。

---

### [00:00:41] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today, my guest is Casey Winters. Casey was one of the first ever guests on the podcast, and the first to make a return appearance. He's a legend in the growth and product community, having worked with or advised companies like Pinterest, Reddit, Canva, Airbnb, Tinder, Thumbtack, Grubhub, and many more. He recently led product at Eventbrite for just about three years, and recently returned to full-time advising, and he's exploring new opportunities.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，从他们构建和增长当今最成功产品的辛苦经验中学习。今天，我的嘉宾是 Casey Winters。Casey 是本播客最早的嘉宾之一，也是第一位返场嘉宾。他是增长和产品界的传奇人物，曾任职于或咨询过 Pinterest、Reddit、Canva、Airbnb、Tinder、Thumbtack、Grubhub 等众多公司。他最近在 Eventbrite 担任了约三年的产品负责人，最近又回到了全职顾问的状态，并正在探索新的机会。

---

### [00:01:17] Lenny

**English:**
In our chat, we cover something he calls the zero interest rate phenomenon product manager and how to avoid that, what he's found works best when interviewing product managers, what impact he expects from GPT-4 on the role of product management, when to trust your instincts versus your team's insights and instincts, what are all the different kinds of network effects, and how do you effectively leverage them? Plus a great story about what Grubhub missed that let DoorDash and Uber eat their lunch. I always learn so much from chatting with Casey, and I am 100% sure you will learn a lot from this episode. With that, I bring you Casey Winters, after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们讨论了他所谓的“零利率现象产品经理”（ZIRP PM）以及如何避免成为这样的人；他在面试产品经理时发现的最有效方法；他预期的 GPT-4 对产品管理角色的影响；何时该信任你的直觉，何时该信任团队的洞察和直觉；各种不同类型的网络效应以及如何有效地利用它们。此外，还有一个关于 Grubhub 错失了什么，导致 DoorDash 和 Uber 抢走他们市场份额的精彩故事。每次和 Casey 聊天我都能学到很多，我百分之百确定你也会从这一集中受益匪浅。在听完赞助商的简短介绍后，让我们欢迎 Casey Winters。

---

### [00:01:56] Lenny (Sponsorships)

**English:**
This episode is brought to you by Amplitude... [and] Eppo... [Details omitted for brevity as per standard transcript practice, but the core message is: Amplitude for analytics and Eppo for A/B testing].

**中文翻译:**
本期节目由 Amplitude 赞助……以及 Eppo 赞助…… [Amplitude 提供数据分析服务，Eppo 是由 Airbnb 校友构建的新一代 A/B 测试平台]。

---

### [00:03:37] Lenny

**English:**
Casey, welcome back to the podcast.

**中文翻译:**
Casey，欢迎回到播客。

---

### [00:03:39] Casey Winters

**English:**
Thanks, Lenny. Great to be here.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。

---

### [00:03:41] Lenny

**English:**
You are the first ever return guest to my podcast. How does that feel?

**中文翻译:**
你是本播客有史以来第一位返场嘉宾。感觉如何？

---

### [00:03:46] Casey Winters

**English:**
I feel honored, perhaps a bit unworthy, but I'll go with it.

**中文翻译:**
我感到很荣幸，也许有点受宠若惊，但我接受这个荣誉。

---

### [00:03:52] Lenny

**English:**
Well, you're both worthy and I'm honored as well. Thanks for joining me again. I have a lot of stuff that I want to chat about, but first of all, I'm just curious, what are you up to these days? I know you left Eventbrite as CPO, I know you're doing a few advisorships with startups, but how are you spending your days, and what do you think is next for Casey Winters?

**中文翻译:**
你当之无愧，我也感到很荣幸。感谢再次加入。我有很多想聊的话题，但首先，我很好奇你最近在忙什么？我知道你卸任了 Eventbrite 的首席产品官（CPO），也知道你在为几家初创公司做顾问，但你现在每天是怎么度过的？你觉得 Casey Winters 的下一步会是什么？

---

### [00:04:10] Casey Winters

**English:**
I'm still spending some time with Whatnot and Eventbrite as advisors. I stepped back from the CPO of Eventbrite in October, but still working on some long-term marketplace strategy stuff, some growth strategy stuff. I'm on the board of a company called Beek, which is like Netflix for audio in Latin America, and I'm doing some angel investing in marketplaces in what I call tech debt as a service, which is what are startups that are building out things that were hard for my teams in the past to build or maintain inside previous companies? The other thing I'm working on is revamping the product strategy program for Reforge. I got some things keeping me busy, but definitely not as busy as I was last year.

**中文翻译:**
我仍然作为顾问在 Whatnot 和 Eventbrite 花一些时间。我去年 10 月卸任了 Eventbrite 的 CPO，但仍在处理一些长期的市场策略和增长策略工作。我还在一家名为 Beek 的公司董事会任职，它就像是拉丁美洲音频版的 Netflix。此外，我还在对市场类公司进行天使投资，投资方向是我所谓的“技术债即服务”（tech debt as a service），即那些正在构建过去我的团队在以前公司里很难构建或维护的东西的初创公司。另一件事是重新修订 Reforge 的产品策略课程。我手头有些事在忙，但肯定没有去年那么忙。

---

### [00:04:53] Lenny

**English:**
This is like a rare, free agent Case Winters time. Should people reach out if they're interested in maybe working with you? What's your advice for people listening?

**中文翻译:**
这就像是罕见的“自由球员”时期的 Casey Winters。如果人们有兴趣和你合作，应该联系你吗？你对听众有什么建议？

---

### [00:05:00] Casey Winters

**English:**
Yeah. I always love seeing how I can help companies. Everyone should err on the side of reaching out and seeing if I have time to help, if there's something they think I can help with. I love talking to startups, so yeah, absolutely. I can't promise anything, but yeah, I just love talking to people about this stuff.

**中文翻译:**
是的。我一直很乐意看我能如何帮助公司。大家尽管联系我，看看我是否有时间帮忙，或者是否有他们认为我可以提供帮助的地方。我喜欢和初创公司交流，所以，当然可以。我不能保证任何事，但我确实喜欢和人们讨论这些东西。

---

### [00:05:19] Lenny

**English:**
Awesome. We'll point people to how to get in touch with you at the end of the episode, and it'll be in the show notes too. Talking about the CPO role, you're at Eventbrite. You're a CPO. It reminds me of a post you wrote about how hard the CPO role is. There's some quotes that I recall in your post about how, one, if you ever ask a CPO, chief product officer how they're doing, no one's ever going to say, "I'm crushing it right now."

**中文翻译:**
太棒了。我们会在节目最后告诉大家如何联系你，也会放在节目介绍里。谈到 CPO 这个角色，你在 Eventbrite 担任过 CPO。这让我想起你写过的一篇关于 CPO 角色有多难的文章。我记得你文章里有一些引用，比如，如果你问一个 CPO（首席产品官）最近怎么样，没有人会说：“我现在的表现简直无敌了。”

---

### [00:05:41] Casey Winters

**English:**
Yeah.

**中文翻译:**
没错。

---

### [00:05:41] Lenny

**English:**
Then there's this other quote about how you basically, as a CPO, just try to put some points on the board before you inevitably get fired. Why is that? Why do you find that, and do you still believe that to be true after leaving that role?

**中文翻译:**
还有另一句话，大意是作为 CPO，你基本上只是在不可避免地被解雇之前，努力在记分板上多拿几分。为什么会这样？你为什么会有这种感觉？离开那个职位后，你还相信这是真的吗？

---

### [00:05:53] Casey Winters

**English:**
Yeah, I would say I still believe those things I said. It was funny. A product leader who will remain nameless emailed me when I hit year three at Eventbrite, and they said, "Congrats. You didn't get fired after two years. What's your secret?" I think it's very hard to keep product-market fit as a CPO within a company for a long time. The needs of the business shift over time, and of course, we all have different strengths and weaknesses in our game. No one's perfect at everything. In general, as an executive, it's just impossible to do everything perfectly, and any little misstep, mistake, or something you just missed can blow up in a major way.

**中文翻译:**
是的，我想说我仍然相信我说的那些话。很有趣，一位不愿透露姓名的产品领导者在我入职 Eventbrite 三周年时给我发邮件说：“恭喜你，两年后还没被开除，你的秘诀是什么？”我认为作为 CPO，在一家公司长期保持“产品与市场契合”（PMF）是非常困难的。业务需求随时间变化，当然，我们每个人都有自己的长处和短处。没有人能在所有事情上都完美。总的来说，作为一名高管，想要完美地做好每一件事是不可能的，任何微小的失误、错误或疏忽都可能引发巨大的危机。

---

### [00:06:33] Casey Winters

**English:**
Frequently, CEOs have visions that can change and get misaligned with the product leader. Also, with leadership roles, you don't get put on a PIP. If a CEO loses confidence, it's over immediately. Nothing like that happened at Eventbrite. I started to see that the areas of leverage for a product leader were just less in my wheelhouse over time. I just talked to my boss about it, and we worked out something where I continue to advise on the things that I'm uniquely good at, and find other people who are better at some of these other things that were maybe more important at the time.

**中文翻译:**
CEO 的愿景经常会发生变化，并与产品领导者产生分歧。而且，在高管职位上，你不会被列入 PIP（绩效改进计划）。如果 CEO 失去信心，一切就立刻结束了。在 Eventbrite 并没有发生这样的事。我开始意识到，随着时间的推移，产品领导者能够发挥杠杆作用的领域逐渐超出了我的擅长范围。我就此与我的老板进行了沟通，我们达成了一项方案：我继续就我独特擅长的事情提供建议，并寻找其他更擅长当时可能更重要的事情的人。

---

### [00:07:09] Casey Winters

**English:**
Yeah, I'd say it's a really hard role, or a really challenging role. It can be a lot of fun. I learned a lot from doing it, but yeah, I still believe, and I think I've still yet to hear someone say they've really crushed it.

**中文翻译:**
是的，我会说这是一个非常艰难的角色，或者说非常有挑战性的角色。它可以很有趣，我从中也学到了很多，但我仍然相信那句话，而且我想我至今还没听过有人说他们真的“大获全胜”了。

---

### [00:07:26] Lenny

**English:**
Is there anything that you learned from that experience to have survived in that role for three years? I imagine you have a lot of skills and you were very valuable to the company, but I don't know, for someone in that's role maybe right now, just like, "Here's something that I did that maybe you should do."

**中文翻译:**
在那段经历中，为了在这个职位上生存三年，你学到了什么吗？我想你有很多技能，对公司非常有价值，但对于现在可能正处于那个职位的人，你有没有什么建议，比如“这是我做过的一件事，也许你也该试试”？

---

### [00:07:40] Casey Winters

**English:**
The first one I can think of is a big change from being a product leader to a CPO or something equivalent is you're actually a company exec first and a product exec second. I think some mistakes I made early that I corrected successfully is you want to show that you are caring and paying attention to the overall business first before just taking care of your own product designers, product managers, researchers, whoever. That's advice I found myself doling out to other product leaders a lot more now that I've gone through it. You have to not only truly care, but create the perception that you care about sales, about marketing, about legal, et cetera. Because first and foremost, you're expected to lead the business at that level, so I think that's something that I think is really important.

**中文翻译:**
我能想到的第一点是，从产品负责人转变为 CPO 或类似职位的重大变化在于：你首先是公司高管，其次才是产品高管。我认为我早期犯过并成功纠正的一些错误是，在只顾着照顾你自己的产品设计师、产品经理、研究员等之前，你首先要表现出你关心并关注整体业务。这是我在经历过之后，现在经常给其他产品领导者的建议。你不仅要真心关心，还要让别人感觉到你关心销售、营销、法务等等。因为在这个层面上，你首先被期望的是领导业务，所以我认为这一点非常重要。

---

### [00:08:35] Casey Winters

**English:**
I think something else is really trying to diagnose, without as much bias as possible, where are the strengths and weaknesses of your team? Where are the strengths and weaknesses of your product? Lay that out with your peers and say, "Here's where we are. Here's where I think we need to go. Here's the timeline on which I'm going to work to get us there." Because I think product's such a confusing discipline for people who aren't in it, like a sales leader, many CEOs, a marketing leader, that they don't necessarily know what great looks like.

**中文翻译:**
我认为另一件事是，尽可能不带偏见地去诊断：你团队的优缺点在哪里？你产品的优缺点在哪里？把这些展示给你的同僚看，并说：“这是我们的现状。这是我认为我们需要达到的目标。这是我带领大家达到目标的计划时间表。”因为我认为对于非产品专业的人来说，比如销售主管、许多 CEO、营销主管，产品是一个非常令人困惑的学科，他们不一定知道“优秀”长什么样。

---

### [00:09:14] Casey Winters

**English:**
The things they know about great leadership, they don't know if you know those things, so you have to make it really clear, "Yeah, I know our OKRs are not as quantitative as they should be yet. That's because this team isn't ready for X, Y, and Z. This is where we're going to get them to, but it's going to take some time." One of the things we did at Eventbrite that I thought was really helpful is, when you go public, you tend to rotate over your executive team and get public company execs versus startup execs. A few of us were new, and it's just like, "Hey, let's do a deep dive on product. Let's do a deep dive on customer support. Where's it at right now? What do you feel like your job is? What do you feel like are the issues you're facing? Where do you want to take it over the next three to five years? Then, let's talk about it."

**中文翻译:**
他们了解优秀领导力的特质，但他们不知道你是否也具备这些特质，所以你必须明确表示：“是的，我知道我们的 OKR 还没有达到应有的量化程度。那是因为这个团队还没准备好应对 X、Y 和 Z。这是我们要带他们去的目标，但这需要一些时间。”我们在 Eventbrite 做过的一件我认为非常有帮助的事是，当公司上市时，你往往会轮换高管团队，引入上市公司高管而非初创公司高管。我们中有几个人是新来的，我们就说：“嘿，让我们对产品进行深度剖析。对客户支持进行深度剖析。现状如何？你觉得你的工作是什么？你觉得面临的问题是什么？未来三到五年你想把它带向何方？然后，我们来讨论一下。”

---

### [00:09:57] Casey Winters

**English:**
Just forcing you to write it all down is really helpful, but then it forces you to explain it. It helps the rest of the executive team get better company execs because now they really understand product a lot more deeply, or understand finance a lot more deeply, whatever the function is.

**中文翻译:**
强迫你把这些都写下来非常有帮助，因为它会迫使你去解释它。这有助于其他高管成为更好的公司管理者，因为现在他们对产品有了更深刻的理解，或者对财务有了更深刻的理解，无论是什么职能。

---

### [00:10:15] Lenny

**English:**
Speaking of gaps and opportunities for people in the company to level up, you've been highlighting this trend that I thought was really interesting, something you call the zero interest rate phenomenon product manager. Can you talk about what that is and what you've been noticing?

**中文翻译:**
说到公司内部人员提升的差距和机会，你一直在强调一个我觉得非常有趣的趋势，你称之为“零利率现象产品经理”（ZIRP PM）。你能谈谈那是什么以及你观察到了什么吗？

---

### [00:10:33] Casey Winters

**English:**
Yeah, sure thing. This is something I started noticing while managing PMs and product designers at Eventbrite, and it's now coming up with Whatnot as I help them hire new PMs, is the environment in which a lot of product managers have come up is very distorted from when you and I started doing this kind of work. I think we used to always describe PMs as this gang of misfits. We all started in all different functions. We all had different strengths and weaknesses, and the PM team gained as a whole from that diversity of skills and previous experiences.

**中文翻译:**
好的。这是我在 Eventbrite 管理产品经理和产品设计师时开始注意到的，现在我在帮助 Whatnot 招聘新产品经理时也发现了这一点。很多产品经理成长的环境与你我刚开始做这项工作时相比已经非常扭曲了。我想我们过去总是把产品经理描述为一群“怪咖”（misfits）。我们都来自不同的职能部门，都有不同的优缺点，而产品团队作为一个整体，从这种技能和过往经验的多样性中获益。

---

### [00:11:12] Casey Winters

**English:**
What I noticed is, when we started doing product reviews at Eventbrite, if there was any sort of uncertainty in a problem or a solution, the product manager, instead of shipping to learn, would talk about all this research they have to do to really learn the problems, really learn the solution. My feedback would be like, no, user research is a scarce resource. We have to reserve it for the areas that have extreme uncertainty and high leverage for getting to certain, so if you're redesigning the login page for Eventbrite, you don't need to use that resource to learn what to do. Just go see what FANG and the top unicorns did. They probably did a good job, and even if they didn't, all of our customers also use those products, so they're going to be familiar with us copying any approach that they've taken.

**中文翻译:**
我注意到的是，当我们在 Eventbrite 开始进行产品评审时，如果问题或解决方案中存在任何不确定性，产品经理不是通过“发布来学习”（ship to learn），而是大谈特谈他们必须做多少研究才能真正了解问题和解决方案。我的反馈通常是：不，用户研究是稀缺资源。我们必须把它留给那些具有极端不确定性且对确定性有高杠杆作用的领域。所以，如果你在重新设计 Eventbrite 的登录页面，你不需要动用那个资源去研究该怎么做。直接去看 FANG（大厂）和顶级独角兽是怎么做的就行了。他们可能做得很好，即使做得不好，我们的所有客户也都在使用那些产品，所以他们会对我们模仿那些做法感到熟悉。

---

### [00:12:05] Casey Winters

**English:**
I think we sort of forgot in the industry that many times, the fastest way to learn is to ship, so that if you actually get them to skip research and just go look at competitors, another thing I was noticing is I'd get a list of options other companies have done, but there would be no analysis of why those companies chose different options and what's most applicable for us. It got me thinking, okay, every new person on the product team is acting like they work at Google and have these infinite resources and infinite time to make sure everything is perfect. It became such this focus on the right way of doing product management that no one's taken any risk.

**中文翻译:**
我认为业界有点忘了，很多时候最快的学习方式就是发布。如果你让他们跳过研究直接去看竞争对手，我注意到的另一件事是，我会得到一份其他公司做法的选项列表，但没有任何分析说明为什么那些公司选择了不同的选项，以及哪些最适合我们。这让我开始思考，好吧，产品团队里的每个新人都表现得像在谷歌工作，拥有无限的资源和时间来确保一切完美。大家变得如此专注于“正确的产品管理方式”，以至于没有人愿意承担风险。

---

### [00:12:54] Casey Winters

**English:**
I felt like, oh, am I responsible for this? I've created a bunch of frameworks on Reforge. I'm onboarding these new PMs. Is this my fault? At Reforge, we're building frameworks that are tools in a toolkit. You pull them out when relevant. They're not a coloring book to stay inside the lines of. At one point, I got so fed up, I wrote an internal blog post, and I called it On Best Practices and Breakfast Rituals. I talked about how there were these articles about the morning habits of the most successful people, and if you try to do all those things, it'd take you like six hours every morning.

**中文翻译:**
我觉得，噢，我有责任吗？我在 Reforge 上创建了一堆框架，我还在引导这些新入职的产品经理。这是我的错吗？在 Reforge，我们构建的框架是工具箱里的工具。你在相关的时候把它们拿出来用，而不是一本让你必须在线条内涂色的填色本。有一次我实在受够了，写了一篇内部博客，题目叫《论最佳实践与早餐仪式》。我谈到那些关于最成功人士早晨习惯的文章，如果你尝试做完所有那些事，每天早上要花六个小时。

---

### [00:14:02] Casey Winters

**English:**
I adopted this thing into a public blog post that's on my blog now, but now that I've had some time outside of Eventbrite, I feel like I at least partially missed the mark on what's really going on. I see this with Whatnot, because one of the things I'm helping them with is interviewing, I see PMs again, which I haven't done in a while. It's fascinating interviewing a PM or managers early in their career because Whatnot is a startup, and you know better than most of us as a former founder of one, startups typically require us to wear lots of hats. You have to write SQL. You have to talk directly to customers. You have to prep marketing and sales. Most importantly, you have to make a lot of decisions under uncertainty, which you wouldn't necessarily expect a PM to do at, say, a Google, but it all boils down to using your brain in different ways.

**中文翻译:**
我把这篇文章改写成了公开博客。但现在我离开 Eventbrite 一段时间后，我觉得我至少部分地没看清到底发生了什么。我在 Whatnot 身上看到了这一点，因为我正在帮他们面试，我又开始接触产品经理了，我已经很久没这么做了。面试职业生涯早期的产品经理或经理非常有趣，因为 Whatnot 是一家初创公司，而你作为前创始人比我们大多数人都清楚，初创公司通常要求我们身兼数职。你得写 SQL，得直接和客户沟通，得准备营销和销售。最重要的是，你必须在不确定的情况下做出很多决定，而在谷歌这样的公司，你可能不指望产品经理会这么做。但这归根结底是以不同的方式动脑筋。

---

### [00:14:54] Casey Winters

**English:**
Lisa, who's on our legal team, she called Eventbrite a public startup because the pandemic basically erased her business and we had to build it back from scratch. Now that I'm doing these interviews, and whether they come from a small startup, a unicorn, or a public company, they all sort of look the same because there's been so much funding to all these companies. Every company's been acting like they're Google with Google margins, meaning a lot of engineering support, a lot of design support, a lot of research support, lots of analysts around them.

**中文翻译:**
我们法务团队的 Lisa 把 Eventbrite 称为“上市的初创公司”，因为疫情基本上抹去了她的业务，我们不得不从头开始重建。现在我在做这些面试，无论他们来自小型初创公司、独角兽还是上市公司，他们看起来都差不多，因为这些公司都拿到了太多的融资。每家公司都表现得像谷歌一样，拥有谷歌级别的利润率，这意味着有大量的工程支持、设计支持、研究支持，周围还有一大堆分析师。

---

### [00:15:22] Casey Winters

**English:**
They actually seem pretty ill-prepared for a real startup, or even a public company with some uncertainty around it like Eventbrite, so you start getting these weird responses in the interview process. You ask them to solve a problem and they'd say things like, "I can't even begin to come up with solutions until I see all the data and talk to customers." I'm like, "Yeah, I get that's something you would normally do if you took the job, but you don't have the data. You can't talk to customers. Make a decision now. What would you do? I want to see how creative you are. I want to see how much you're intuiting about the real problem and solution," and they can't really answer. Then my follow-up, which I don't ask, but what I really want to ask is like, "When's the last time you used your brain versus followed a process someone else designed at your company?" Because I want the former, not the latter.

**中文翻译:**
他们实际上似乎对真正的初创公司，甚至是对像 Eventbrite 这样存在不确定性的上市公司准备不足。所以你在面试过程中会得到一些奇怪的回答。你让他们解决一个问题，他们会说：“在看到所有数据并与客户交谈之前，我甚至无法开始想解决方案。”我会说：“是的，我明白如果你入职了通常会这么做，但现在你没有数据，也不能和客户交谈。现在就做决定，你会怎么做？我想看看你有多大的创造力，我想看看你对真实问题和解决方案有多少直觉。”而他们真的答不上来。然后我的追问——我没问出口，但我真的很想问的是：“你上一次动脑筋而不是遵循公司里别人设计的流程是什么时候？”因为我想要的是前者，而不是后者。

---

### [00:16:09] Lenny

**English:**
Wow. Amazing. There's a lot of things I want to dig into here. I was going to ask why you call it zero interest rate phenomenon, but I think what I'm hearing is it's when interest rates are zero, everyone's got a lot of money, things are going great. Everyone looks like they're killing it, successful. Everyone thinks they've got it all figured out, and then when that goes away, it's like, "Oh, shit. Maybe not so."

**中文翻译:**
哇，太棒了。这里有很多我想深入探讨的东西。我本想问你为什么称之为“零利率现象”，但我听出来的意思是，当利率为零时，每个人都有很多钱，一切都很顺利。每个人看起来都做得非常出色、非常成功。每个人都觉得自己已经搞定了一切，而当那种环境消失时，就像是，“噢，糟糕，也许并非如此。”

---

### [00:16:27] Casey Winters

**English:**
Then also, I think zero interest rates allowed every startup to operate like it was a public company with billions of dollars. That's going to go away over the next five years, and it sort of takes us back to what product management used to be like, which was you didn't have all these resources around. You didn't have all this time to figure it out because if you don't figure it out now and make it work, you may run out of funding, right?

**中文翻译:**
而且，我认为零利率让每家初创公司都能像拥有数十亿美元的上市公司一样运作。这种情况在未来五年内将会消失，这在某种程度上把我们带回了产品管理以前的样子：你周围没有这么多资源，你没有这么多时间去慢慢摸索，因为如果你现在不搞清楚并让它奏效，你的资金可能就会耗尽，对吧？

---

### [00:16:51] Lenny

**English:**
Yeah. Like a very concrete thing that's changed as a lot of research teams have been laid off because they grew really large and companies found, "Maybe we need don't need the ..." Like, "Of all the things we can cut, it's probably an area we can cut."

**中文翻译:**
是的。一个非常具体的例子是，很多研究团队被裁掉了，因为他们变得非常庞大，而公司发现，“也许我们不需要……”就像，“在所有可以削减的开支中，这可能是我们可以削减的一个领域。”

---

### [00:17:02] Casey Winters

**English:**
Yeah, for sure.

**中文翻译:**
是的，没错。

---

### [00:17:04] Lenny

**English:**
There's probably PMs listening to this wondering, "Shoot, am I one of these? Am I just following a bunch of frameworks?" What's your advice for someone that may fear that, "Oh, shoot. This is maybe who I am and I don't want to necessarily be this"? What could they maybe do?

**中文翻译:**
可能有正在听这个节目的产品经理在想：“糟糕，我是这种人吗？我只是在遵循一堆框架吗？”对于那些可能担心“噢，糟糕，这可能就是我，但我不想成为这样的人”的人，你有什么建议？他们可以做些什么？

---

### [00:17:17] Casey Winters

**English:**
I always advise going to companies where you can learn quickly and try things. I think it's certainly okay to learn a bunch of frameworks. There's a reason I've invested a ton of time in Reforge because I think it actually really does help people to see how other people build things in a way that they can scale it to their other companies, but you have to understand that the job is not to follow the process. The job is not to learn every framework possible. The job is to figure out how to add value to customers that translates into value to the business. Just reorient your North Star, if you've gotten away from that.

**中文翻译:**
我总是建议去那些能让你快速学习和尝试新事物的公司。我认为学习一堆框架当然没问题。我在 Reforge 投入大量时间是有原因的，因为我认为它确实能帮助人们了解别人是如何构建东西的，从而让他们能将其扩展到其他公司。但你必须明白，你的工作不是遵循流程，也不是学习所有可能的框架。你的工作是找出如何为客户创造价值，并将其转化为业务价值。如果你偏离了这一点，请重新调整你的“北极星指标”。

---

### [00:17:53] Casey Winters

**English:**
When I joined Eventbrite, there was this team that didn't ship anything in a quarter. I went to the designer who I knew, and I know that he likes to get stuff out there and likes to get feedback. I was like, "Dude, you didn't ship anything. How could you have gone the entire quarter, not shipped any of your designs and felt that that was okay? If you didn't feel it was okay, why did you censor yourself? Come to me. Tell me why this team is not letting you ship. There's just no way you can get better as a designer. There's no way you can have the impact on the company. There's no way you can have an impact on our users." Those are some things that come to mind to that question.

**中文翻译:**
当我加入 Eventbrite 时，有一个团队在一个季度内什么都没发布。我去找了那个我认识的设计师，我知道他喜欢把东西发布出去并获取反馈。我说：“伙计，你什么都没发布。你怎么能度过整个季度，一个设计都没发布，还觉得这没问题？如果你觉得有问题，为什么要自我审查？来找我，告诉我为什么这个团队不让你发布。这样你根本无法成为更好的设计师，无法对公司产生影响，也无法对我们的用户产生影响。”这些是我针对那个问题想到的一些事情。

---

### [00:18:36] Lenny

**English:**
If you're a PM on a team that maybe isn't shipping, maybe is overusing research, do you have any advice of just like when it makes sense to invest in research? Say you have the resources, is there a rule of thumb you have of like, "Okay. Let's actually spend the time on this verse not"?

**中文翻译:**
如果你是一个不发布产品、可能过度使用研究的团队里的产品经理，你对于什么时候投入研究才有意义有什么建议吗？假设你有资源，你有没有什么准则，比如“好吧，我们确实应该在这件事上花时间，而不是那件事”？

---

### [00:18:51] Casey Winters

**English:**
I think about it a little bit, depending on the type of job you have and the types of customers you have. The more scale you have tends to be you have less sophisticated customers because you're generally like a consumer thing where the customers are rational. They're not experts. That's generally where you just try things. You measure the impact they have, and you only really bring in research when the impact seems confusing, but you can run experiments. You can get data really easily, so bias towards getting stuff out there and seeing what users respond to.

**中文翻译:**
我会根据你的工作类型和客户类型来考虑。规模越大，客户往往越不那么“资深”，因为你通常面对的是消费者，他们是理性的，但不是专家。在这种情况下，通常就是去尝试。你衡量它们产生的影响，只有当影响看起来令人困惑时，才真正引入研究。但你可以运行实验，可以很容易地获得数据，所以要倾向于把东西发布出去，看看用户的反应。

---

### [00:19:30] Lenny

**English:**
In consumer product.

**中文翻译:**
在消费级产品中。

---

### [00:19:31] Casey Winters

**English:**
Right. If you're super enterprise, it's the opposite. Each customer, first off, is sophisticated and tend to be rational. They're paying you like six figures or more, and you could talk to the customers and sales, who knows the customers really well directly, and they tell you want they want. They tell you what they're willing to pay for. You build it. They pay you. Bing, bang, boom. It's not, obviously, as simple as that, but you're basically doing the research directly with the customer and with the sales team, and translating that into things that are strategic to the business.

**中文翻译:**
对。如果你做的是超级企业级产品，情况就恰恰相反。首先，每个客户都很资深，而且往往很理性。他们付给你六位数甚至更多的钱，你可以直接与客户和非常了解客户的销售人员交谈，他们会告诉你他们想要什么，告诉你他们愿意为什么付钱。你构建它，他们付钱。搞定。显然没那么简单，但你基本上是直接与客户和销售团队一起做研究，并将其转化为对业务具有战略意义的东西。

---

### [00:20:02] Casey Winters

**English:**
I would say those are the two extremes probably most people are familiar with, but we now have a lot of companies in the middle, where they have more customers. Those customers are more sophisticated. They're consumers. They're maybe employees at companies, or they're small businesses. That's where you have to be more nuanced. This, of course, is where Eventbrite was on, "Hey, when do I really lean in on research? When do I lean in on data? When do I pay attention to internal feedback?"

**中文翻译:**
我会说这是大多数人熟悉的两个极端，但现在我们有很多处于中间地带的公司，他们有更多的客户。这些客户更资深一些。他们是消费者，也可能是公司的员工，或者是小企业。这就是你需要更细致的地方。当然，这也是 Eventbrite 所处的阶段：“嘿，我什么时候该真正依赖研究？什么时候该依赖数据？什么时候该关注内部反馈？”

---

### [00:20:29] Casey Winters

**English:**
For Eventbrite, we really tried to focus research on the B2B side of Eventbrite, where the problems seemed big, but not well-defined enough. Or that problem's well-defined, but we just really don't feel like we have the right solution yet. If research is going to be a scarce resource inside the company, which I think it will in most places, you have to figure out where it's a high-leverage area, which means either really big problem, we don't understand it well enough, or we know the problem's big. We understand it well, but we're just not sure if our solution's going to, in any way, hit the mark.

**中文翻译:**
对于 Eventbrite，我们确实尝试将研究重点放在 B2B 端，那里的问题看起来很大，但定义不够清晰。或者问题定义清晰了，但我们觉得还没有找到合适的解决方案。如果研究在公司内部是一种稀缺资源（我认为在大多数地方都是如此），你就必须找出哪里是高杠杆领域，这意味着要么问题很大且我们了解不够，要么我们知道问题很大且了解充分，但只是不确定我们的解决方案是否能奏效。

---

### [00:21:06] Lenny

**English:**
Makes me think about some of the best researchers I've worked with, and they often tell me like, "We don't need to do research on this. We have enough information. We have other things we should be doing."

**中文翻译:**
这让我想起我合作过的一些最优秀的研究员，他们经常告诉我：“我们不需要针对这个做研究。我们已经有足够的信息了。我们还有其他该做的事。”

---

### [00:21:13] Casey Winters

**English:**
I love it when they say that. Yes.

**中文翻译:**
我最喜欢他们这么说了。是的。

---

### [00:21:15] Lenny

**English:**
Yeah. This would have been a really good segue to another topic I want to talk about, which is around gut instincts versus team expertise, which we're going to get to, but I have a couple more questions along these lines. You talked about interviewing PMs at Whatnot. Can you actually describe Whatnot? Just because you mentioned it a couple times, just so people know what we're talking about here.

**中文翻译:**
是的。这本可以很好地引出我想聊的另一个话题，即直觉与团队专业知识的博弈，我们稍后会谈到。但我还有几个关于这方面的问题。你提到了在 Whatnot 面试产品经理。你能描述一下 Whatnot 吗？因为你提到了几次，好让大家知道我们在聊什么。

---

### [00:21:33] Casey Winters

**English:**
Oh, sure. Whatnot's a livestreaming marketplace, mostly focused on the collectibles market. Sellers, whether it's like baseball cards, or women's handbags, or sneakers, they'll go live on video and show you the products they have that they're selling. People that are watching the stream can engage with the sellers and bid on different items, so kind of like Twitch meets eBay would be a good way to describe it.

**中文翻译:**
噢，当然。Whatnot 是一个直播电商平台，主要专注于收藏品市场。卖家，无论是卖棒球卡、女式手提包还是运动鞋，都会进行视频直播，向你展示他们正在出售的产品。观看直播的人可以与卖家互动并对不同物品进行竞价，所以用“Twitch 遇见 eBay”来描述它会很贴切。

---

### [00:21:54] Lenny

**English:**
Awesome, awesome. I'll just mention, I'm a tiny angel investor in that company.

**中文翻译:**
太棒了。顺便提一下，我是那家公司的一个微型天使投资人。

---

### [00:21:56] Casey Winters

**English:**
Oh, that's why you brought it up. Okay, I get it.

**中文翻译:**
噢，这就是你提起它的原因。好吧，我懂了。

---

### [00:22:00] Lenny

**English:**
Yeah, I just wanted to make sure people understood what this word was because it's like a fun word, Whatnot. What I wanted to actually get to is you said you were interviewing a lot of project managers for them. What is your approach to interviewing PMs? What do you find is a really good signal for someone that's going to be successful?

**中文翻译:**
是的，我只是想确保大家明白这个词是什么意思，因为 Whatnot 是个挺有趣的词。我真正想聊的是，你说你在帮他们面试很多产品经理。你面试产品经理的方法是什么？你认为什么是预示一个人会成功的良好信号？

---

### [00:22:35] Casey Winters

**English:**
I feel like the whole thing's gotten so performative. It's like interviewing is handing out Oscars based on who's prepared the best tell me about a time response, versus actually assessing who can do the job we're hiring for. It's like most PMs are better PM interviewers than PMs now. There's this quote from a movie called The Way of the Gun. I don't know if you've ever seen it. Benicio del Toro says in it, it's like, "These days, they want to be criminals more than they want to commit crime." I think about that quote a lot when it comes to interviewing.

**中文翻译:**
我觉得现在的面试已经变得非常有表演性质。面试就像是根据谁准备的“请讲讲你曾经……”类回答最好来颁发奥斯卡奖，而不是真正评估谁能胜任我们要招聘的工作。现在的产品经理似乎更擅长面试，而不是做产品。电影《绑架迷案》（The Way of the Gun）里有一句台词，不知道你有没有看过。贝尼西奥·德尔·托罗在里面说：“如今，人们想当罪犯的欲望胜过想去犯罪的欲望。”在面试这件事上，我经常想起这句话。

---

### [00:23:10] Casey Winters

**English:**
I would say I'm a bit contrarian here in my approach. I don't ask about your work history. I don't care about your perfectly practiced answers. I'm going to give you real scenarios that I expect from the role. I want to hear how you'd approach them. If you can't come up with a few reasonable ideas, figure out how to test them quickly without analyst support or research, I'm just not interested. I'm not saying this is a perfect approach. Interviewing is a very lossy format, but the more I can see them do the job we're hiring for with questions, whether it's a presentation, a prompt, that gets me the most comfortable that they know the job they're signing up for, that they've shown in a practice scenario they can do it, and they actually enjoyed it in some way.

**中文翻译:**
在面试方法上，我有点反传统。我不问你的工作经历，我不在乎你练习得完美的答案。我会给你一些我期望这个角色能处理的真实场景。我想听听你会如何处理它们。如果你不能提出几个合理的想法，想出如何在没有分析师支持或研究的情况下快速测试它们，我就不感兴趣。我不是说这是一个完美的方法，面试本身就是一个信息损耗很大的形式，但如果我能通过提问、演示或提示看到他们做我们要招聘的工作，这会让我最放心，证明他们知道自己应聘的是什么工作，证明他们在模拟场景中展示了能力，并且他们确实在某种程度上乐在其中。

---

### [00:23:29] Lenny

**English:**
Are there red flags you look for in these interviews? One is maybe you said of like, "I can't even begin to answer this without research and data." Is there anything else?

**中文翻译:**
你在这些面试中会留意什么危险信号（red flags）吗？其中一个可能是你刚才说的，“没有研究和数据我甚至无法开始回答”。还有别的吗？

---

### [00:23:36] Casey Winters

**English:**
Some things I pay attention to is if they're talking about solutions that are going to take a long time to get signal from, whether it's months and months of engineering time before you actually see the impact on users or the business, I think that's always great. If they're not factoring in the amount of time it will take, in general, is not a good sign, and not thinking a bit more holistically about the types of metrics they expect to improve versus track to make sure they haven't gone down. Those are some things that I pay a lot of attention to.

**中文翻译:**
我会注意的一些事情是，如果他们谈论的解决方案需要很长时间才能获得反馈信号，比如需要数月的工程时间才能看到对用户或业务的影响，我认为这总是一个问题。如果他们没有考虑到所需的时间，通常不是一个好迹象。此外，如果没有更全面地思考他们期望改进的指标类型，以及为了确保指标没有下降而需要跟踪的指标，这些也是我会重点关注的地方。

---

### [00:24:41] Lenny

**English:**
Another thought is there's this meme that GPT-4, or 5, or 6, or 10 is going to replace product managers, and anytime some new feature comes out, people will put out these videos of, "Oh, look. They're doing all the PM's jobs." What's your take on the future of PM in AI, if any?

**中文翻译:**
另一个想法是，现在有一种说法（meme）认为 GPT-4、5、6 甚至 10 将取代产品经理。每当有新功能发布，人们就会发布视频说：“噢，看，它们把产品经理的工作全做了。”你对 AI 时代产品经理的未来有什么看法？

---

### [00:25:10] Casey Winters

**English:**
Well, I think if you thought the PM job was just filling in the latest Reforge or Shreyas framework, and then getting that automatic FANG promotion every year and a half, then yeah, you're going to get replaced by AI. I think the real PM job is the least likely to get replaced over time because you need real subject matter expertise. You need to be trading off a lot of different types of things, and making good decisions for the company and for your customers.

**中文翻译:**
嗯，我想如果你认为产品经理的工作只是填写最新的 Reforge 或 Shreyas 框架，然后每隔一年半自动获得大厂晋升，那么是的，你会被 AI 取代。我认为真正的产品经理工作是随着时间的推移最不容易被取代的，因为你需要真正的领域专业知识。你需要权衡许多不同类型的事情，并为公司和客户做出正确的决策。

---

### [00:25:10] Casey Winters

**English:**
In terms of using AI now as a PM, I'd actually be cautious in the current iteration of the cycle for PMs. It's a tool that's trained on sounding smart rather than always necessarily being smart. I was at Eventbrite the other day, and someone was telling me how they were loving the new Notion AI integration. She asked me if I used it. I said, "No." She's like, "Ah, you totally need to. Hey, go ask it your bio. It's really cool." I said, "All right. Let's just do it on your screen," so she did and my bio said I started my career at Google, and worked on Google Trends, and a bunch of other products, none of which happened. It was just complete nonsense.

**中文翻译:**
至于现在作为产品经理使用 AI，在当前的迭代周期中我实际上会比较谨慎。它是一个被训练得“听起来很聪明”而不是“总是真的聪明”的工具。前几天我在 Eventbrite，有人告诉我她非常喜欢 Notion AI 的新集成。她问我有没有用过，我说没有。她说：“啊，你一定要试试。嘿，去问问它你的个人简介，真的很酷。”我说：“好吧，就在你的屏幕上试试吧。”结果我的简介说我的职业生涯始于谷歌，负责过 Google Trends 和一堆其他产品，而这些都没发生过。完全是胡说八道。

---

### [00:26:28] Casey Winters

**English:**
I think where I'm more inclined for PMs to try to get leverage out of something like GPT-4 is a lot of the tedious work that's maybe not their specialty to begin with. If you're not great at Excel or Google Sheets and you need to model something, you can ask it to format something. That'll probably be perfect, or how to get some Zapier integration to work. It probably knows how to do that really well. I think, at this point, it's a pretty good no-code to low-code tool. It's obviously going to become a lot more than that, but for a lot of these other use cases that people are touting, there's a decent chance, confidently tells you the wrong thing, and that would scare me as a PM.

**中文翻译:**
我认为我更倾向于让产品经理从 GPT-4 这种工具中获得杠杆作用的地方，是处理很多原本就不是他们专长的乏味工作。如果你不擅长 Excel 或 Google Sheets，但需要建立一个模型，你可以让它帮你格式化，那可能会很完美；或者如何让某些 Zapier 集成运行起来，它可能非常擅长。我认为目前它是一个非常好的无代码到低代码工具。显然它会变得远不止于此，但对于人们吹捧的许多其他用例，它很有可能自信满满地告诉你错误的事情，作为产品经理，这会让我感到害怕。

---

### [00:28:26] Lenny

**English:**
You also wrote this really interesting post on founder intuition versus team expertise. There's a lot to it, and I think it's a really interesting topic because it's this classic discussion that startups have. How much should a founder trust their gut, and how much should it be top-down, "Here's what we should be doing" versus the team, bottom-up, figure out what to build? I'd love to spend a little time here. Maybe just to start broadly, what is this? You came up with a framework of how to think about when founder intuition should overrule, say, team expertise, and how that change over time, so maybe just talk about that.

**中文翻译:**
你还写过一篇关于“创始人直觉与团队专业知识”的非常有趣的文章。内容很多，我认为这是一个非常有趣的话题，因为这是初创公司经常讨论的经典问题：创始人应该在多大程度上相信自己的直觉？应该是自上而下的“这就是我们该做的”，还是应该由团队自下而上地找出要构建什么？我想在这里花点时间。也许先从大处着眼，这是什么？你提出了一个框架，关于何时创始人直觉应该否决团队专业知识，以及这如何随时间变化，能谈谈这个吗？

---

### [00:29:17] Casey Winters

**English:**
Yeah. If founders are lucky/good enough to find product-market fit, they've usually built up all this intuition about their customers, about their product, and their business that are really hard to explain to others and may even be subconscious. When they start to hire people, these people will come in with a lot of excitement, ideas, maybe even really relevant experience, especially senior leaders. I've seen some founders are like, "Cool. I need to let these experts start to own these areas and get out of the geek house." I think that's actually the opposite of what you want, because none of these people know the business as well as you get it. You actually need to direct them until they show you they've really got it and are making better decisions than you would.

**中文翻译:**
是的。如果创始人足够幸运或足够优秀，找到了“产品与市场契合”（PMF），他们通常已经建立了关于客户、产品和业务的所有直觉，这些直觉很难向他人解释，甚至可能是潜意识的。当他们开始招人时，这些人会带着极大的热情、想法，甚至是非常相关的经验进来，尤其是高级领导者。我见过一些创始人会想：“太好了，我需要让这些专家开始接管这些领域，让我从琐事中抽身。”我认为这实际上与你想要的效果相反，因为这些人中没有一个像你一样了解业务。你实际上需要指导他们，直到他们向你证明他们真的掌握了，并且能做出比你更好的决定。

---

### [00:30:27] Lenny

**English:**
Interesting. You're saying, as a founder, the heuristic should be if you feel confident about a decision, generally, you should be clear, like, "Hey, I think I know what we need to be doing here," and don't just make people feel better, necessarily, by just saying, "Okay. You tell us what you want to do." Then on the flip side, as an employee at the company, if you feel really confident about something, make it clear to the founder like, "I really think this is the right move." Is there anything more you want to add there?

**中文翻译:**
有趣。你是说，作为创始人，启发式的方法应该是：如果你对某个决定有信心，通常你应该明确表达，比如“嘿，我觉得我知道我们该做什么”，而不仅仅是为了让员工感觉更好而说“好吧，你告诉我们你想做什么”。反过来说，作为公司员工，如果你对某件事非常有信心，也要向创始人明确表达：“我真的认为这是正确的举动。”关于这一点你还有什么想补充的吗？

---

### [00:31:26] Casey Winters

**English:**
If you're lucky enough to scale a company, there's just more and more things going on that all will reach the founder in some way, but it means more breadth and less depth on any particular issue, and the reverse is true for people you hire. They're able to get really deep into things that maybe you were really deep into two years ago but you just can't stay deep in anymore. I built this chart on, or I guess I should say table on the different phases of a startup. When you're finding product-market fit, everything goes through the founders. You cannot outsource that.

**中文翻译:**
如果你足够幸运能把公司规模做大，就会有越来越多、各种各样的事情以某种方式传到创始人那里，但这意味着对任何特定问题的广度增加了，深度却减少了。而你雇佣的人恰恰相反，他们能够深入研究那些你两年前可能研究得很深、但现在无法再深入的事情。我针对初创公司的不同阶段制作了一个图表，或者说表格。当你寻找“产品与市场契合”时，所有事情都要经过创始人，你无法将其外包。

---

### [00:32:39] Casey Winters

**English:**
Then when you start scaling the company because you found product-market fit, it's the first time that founders run into this classic problem of what got you here won't get you there. What got you to product-market fit was iterating on product and doing things that don't scale. Guess what? You found a product that works. Don't do that anymore. Make it scale. Don't come up with new products. You found the one that works. The reason I came up with this framework originally is when I was at Grubhub, we were scaling pretty nicely and fairly organically. I think Mike and Matt, the founders, had intuited these phases of building a company pretty well, but we acquired a competitor and I saw how that company we acquired operated. Even though they were largely in the same phase as us, they still operated like they were founding the company. Everything was going through the founder. Intuitively, I was like, "Oh, this is why we're acquiring you, and not the other way around."

**中文翻译:**
然后，当你因为找到了 PMF 而开始扩大公司规模时，创始人会第一次遇到这个经典问题：过去成就你的东西，现在可能限制你。让你达到 PMF 的是不断迭代产品和做一些无法规模化的事情。猜猜怎么着？你已经找到了一个有效的产品。别再那样做了，让它规模化。别再想新产品了，你已经找到了那个有效的产品。我最初提出这个框架的原因是，当我在 Grubhub 时，我们规模化得很好，而且相当自然。我认为创始人 Mike 和 Matt 很好地凭直觉把握了构建公司的这些阶段。但我们收购了一个竞争对手，我看到了那家被收购公司的运作方式。尽管他们基本上和我们处于同一阶段，但他们仍然像刚创立公司时那样运作，所有事情都要经过创始人。直觉告诉我：“噢，这就是为什么是我们收购你们，而不是反过来。”

---

### [00:34:22] Lenny

**English:**
Any advice for either as a employee at a company with a founder like that or leader, of just how to push back and help the founder understand, "Maybe you should let go and trust people to make decisions"?

**中文翻译:**
对于在这种创始人手下工作的员工或领导者，你有什么建议吗？关于如何回击并帮助创始人理解：“也许你应该放手，信任别人来做决定”？

---

### [00:34:40] Casey Winters

**English:**
I think the first thing is you have to understand that it's their company, not yours, and the founders have impossible jobs. They're not going to scale perfectly with the needs of the company. It's just something's going to be off. It may be because there's a whole lot of hubris by being the one of a thousand startups that made it, or they just have personal styles, but they can run the company any way they want. I think it's sometimes surprising when founders actually want to run things suboptimally. I think we've seen examples where founders just want to build cool shit versus focusing on what customers want, or they're too obsessed with the design. They're always rebranding, redesigning things in ways that confuse customers.

**中文翻译:**
我认为首先你必须明白，那是他们的公司，不是你的，创始人的工作极其艰难。他们不可能完美地随着公司的需求而同步成长，总会有一些偏差。这可能是因为作为千分之一成功的初创公司而产生的巨大傲慢，或者仅仅是个人风格，但他们可以按自己想要的方式经营公司。我认为有时令人惊讶的是，创始人实际上想以非最优的方式运行。我们见过一些例子，创始人只想做“酷的东西”，而不是专注于客户的需求，或者他们对设计过于痴迷，总是以让客户困惑的方式重新进行品牌定位和重新设计。

---

### [00:36:25] Casey Winters

**English:**
I remember when I joined Pinterest, I was just coming off 100X increase in user growth from Grubhub. I was ready to drive the same sort of impact at Pinterest, but no one knew who I was. I didn't come from Facebook or Google like most of the other people, or Pinterest. No one gave a shit about Chicago startups at the time, so when they didn't trust my proposals, I just went and talked to the heads of growth at all the startups they did respect. I talked to Dropbox, I talked to Facebook. When they said all the same things I was saying but I said that they said it, not me, that was, sadly, more convincing. I didn't care because I still got what I wanted out of it, which is to do the right thing to grow the company.

**中文翻译:**
我记得当我加入 Pinterest 时，我刚在 Grubhub 实现了 100 倍的用户增长。我准备在 Pinterest 产生同样的影响力，但没人知道我是谁。我不像大多数其他人那样来自 Facebook 或谷歌，也不来自 Pinterest 内部。当时没人关心芝加哥的初创公司。所以当他们不信任我的提议时，我就去和所有他们尊重的初创公司的增长负责人交谈。我找了 Dropbox，找了 Facebook。当他们说了和我一样的话，而我转述说是他们说的而不是我说的时，可悲的是，这更有说服力。但我不在乎，因为我仍然得到了我想要的结果，那就是做正确的事来让公司增长。

---

### [00:37:25] Casey Winters

**English:**
When I was at Grubhub, one of the ideas one of the founders came up with was to build an app for delivery drivers. At the time, restaurants had their own delivery drivers. They did not work for us. We wanted to build an app for the delivery drivers so you could see where the food was along the way, so you could know if it's five minutes away, whatever. Domino's was the first to have done this at the time, and we thought that would make a bunch of sense. I was just like, "How am I supposed to convince the delivery driver, who doesn't have a relationship with us, to download the app from Grubhub, to actually turn it on, to create anxiety for the consumer of they maybe didn't take the right turn or, whatever?" I was like, "I don't think this makes sense. No one's going to use it," and Mike and Matt overruled me and pushed us to do it.

**中文翻译:**
当我在 Grubhub 时，创始人提出的一个想法是为外卖员开发一个 App。当时，餐厅有自己的外卖员，他们不为我们工作。我们想为外卖员开发一个 App，这样你就能看到食物在路上的位置，知道它是不是还有五分钟就到。当时达美乐（Domino's）是第一个这么做的，我们觉得这很有意义。我当时想：“我该如何说服一个与我们没有关系的外卖员去下载 Grubhub 的 App，并真的打开它？这会不会让消费者感到焦虑，比如看到外卖员可能没转对弯之类的？”我说：“我觉得这没意义，没人会用的。”但 Mike 和 Matt 否决了我的意见，坚持让我们去做。

---

### [00:38:10] Casey Winters

**English:**
In the long run, it ended up being quite necessary because of the innovations around DoorDash, and Postmates, and later, Uber Eats having their own delivery network and us needing to counter that. That's, of course, a key piece of technology that needs to have parity with those new services. That was an area where perhaps, they were thinking a little bit more longer term than I was, and I was not able to get where they were going on the longer-term time horizon of how this would be actually ultimately adopted and useful.

**中文翻译:**
从长远来看，这最终变得非常必要，因为 DoorDash、Postmates 以及后来的 Uber Eats 都在创新，拥有了自己的配送网络，我们需要对此进行反击。这当然是一项关键技术，需要与那些新服务保持对等。在那个领域，也许他们比我考虑得更长远，而我当时没能理解他们在更长的时间跨度上，关于这项技术最终将如何被采用并发挥作用的构想。

---

### [00:40:21] Lenny

**English:**
Okay. Shifting to our last topic that I was excited to chat about is around network effects, and marketplaces, and SaaS, and how those things connect. I feel like you have the clearest way of thinking about and explaining network effects, so maybe just to start, can you just simply explain what is a network effect and then the different types of network effects that exist?

**中文翻译:**
好的。转向我非常想聊的最后一个话题，即关于网络效应、市场平台和 SaaS，以及这些事物是如何联系在一起的。我觉得你对网络效应的思考和解释是最清晰的。所以，也许先从简单的开始，你能简单解释一下什么是网络效应，以及存在哪些不同类型的网络效应吗？

---

### [00:40:33] Casey Winters

**English:**
Yeah. No pressure after you say that. Yeah, so at it's core, a network effect is when a product or a business gets better with more users or customers using it. There's three types that I tend to focus on. The first and probably the most well-known is called direct network effects. That's when every additional user makes the product better for all the existing users. When someone joins WhatsApp, other people can talk to them that wouldn't be able to talk to them before, and that makes WhatsApp valuable, more valuable for everyone.

**中文翻译:**
好的，你这么说我压力很大。网络效应的核心是：当一个产品或业务随着更多用户或客户的使用而变得更好。我通常关注三种类型。第一种，可能也是最广为人知的，叫“直接网络效应”。即每增加一个用户，都会让产品对所有现有用户变得更好。当有人加入 WhatsApp 时，其他人就能和以前无法联系的人交谈，这让 WhatsApp 对每个人都变得更有价值。

---

### [00:40:55] Casey Winters

**English:**
Then there are cross-side network effects where there's two distinct types of users, and adding an additional user on one side of the network makes it more valuable for all the types of users on the other side of the network and vice-versa. When a restaurant joins Grubhub, it creates more selection for users to order food, and when more users start ordering more food, Grubhub becomes more attractive for restaurants to join so they can make more money from delivery orders.

**中文翻译:**
然后是“双边网络效应”（cross-side network effects），即存在两种不同类型的用户，在网络的一侧增加一个用户，会使网络对另一侧的所有用户更有价值，反之亦然。当一家餐厅加入 Grubhub 时，它为用户订餐提供了更多选择；而当更多用户开始订购更多食物时，Grubhub 对餐厅加入就变得更有吸引力，因为他们可以从外卖订单中赚更多钱。

---

### [00:41:21] Casey Winters

**English:**
The last network effect I focus on is data network effects. That's when the quality or cost of something improves as more data is collected through the product. When you say content to Pinterest, to a board, it gives Pinterest signal on the quality of that content, its relevance to other pieces of content, since they're shared to the same board, and more signal on your preferences. This allows Pinterest to better recommend more content to you as well as to other people who look like you and share similar interests.

**中文翻译:**
我关注的最后一种是“数据网络效应”。即随着通过产品收集到更多数据，某样东西的质量或成本得到改善。当你把内容保存到 Pinterest 的画板上时，它会给 Pinterest 提供关于该内容质量的信号，以及它与其他内容的相关性（因为它们被分享到了同一个画板），还有更多关于你偏好的信号。这使得 Pinterest 能更好地向你以及像你一样、有相似兴趣的人推荐更多内容。

---

### [00:42:58] Casey Winters

**English:**
I agree. I think they're a great form of defensibility, first off. Do they make sense for every business? No, but in a lot of cases, in order for you to evolve properly and continue to grow, they can become a necessity.

**中文翻译:**
我同意。首先，我认为它们是一种极好的防御形式。它们对每项业务都有意义吗？不，但在很多情况下，为了让你正常进化并持续增长，它们会变成一种必然。

---

### [00:44:35] Casey Winters

**English:**
Sure. It's a great question. I think people do mistake any form of network effect as this perfect form of defensibility. They're the best form of defensibility, but that doesn't mean they're immune to disruption. I think the main way this happens with cross-side network effects that we typically talk about for marketplaces is when a disruptor dramatically expands selection. I want to be clear, I left Grubhub at the end of 2013 before said lunch was eaten, so what I'm communicating is more like public knowledge of watching these amazing companies compete, rather than being inside the fire at the time.

**中文翻译:**
当然。这是一个很好的问题。我认为人们确实误以为任何形式的网络效应都是完美的防御形式。它们是最好的防御形式，但这并不意味着它们对颠覆免疫。我认为对于我们通常讨论的市场平台的双边网络效应，发生这种情况的主要方式是当一个颠覆者极大地扩展了选择范围。我想澄清一下，我在 2013 年底离开了 Grubhub，也就是在所谓的“饭碗被抢”之前。所以我传达的更多是观察这些优秀公司竞争的公开知识，而不是当时身处风暴中心。

---

### [00:45:11] Casey Winters

**English:**
But one important thing to remember is Grubhub was an asset-light marketplace model. Restaurants did their own delivery through their own delivery drivers that they hired. I wrote this post for Andreessen Horowitz a few years ago about supply strategies and marketplaces, so in that you really need to be comprehensive or have exclusive inventory, and Grubhub strived to be comprehensive. We'd show every restaurant that delivered to you, even if we didn't work with them directly for online ordering. What happened about a year before I left Grubhub was that these competitors started to raise their seed rounds or series As to build delivery networks.

**中文翻译:**
但要记住的一件重要事情是，Grubhub 曾是一个“轻资产”的市场模式。餐厅通过他们雇佣的自己的外卖员进行配送。几年前我为 Andreessen Horowitz 写过一篇关于市场平台供应策略的文章，在那里面你真的需要做到全面或者拥有独家库存，而 Grubhub 努力做到全面。我们会显示每家为你配送的餐厅，即使我们没有直接与他们合作进行在线订餐。在我离开 Grubhub 前大约一年，这些竞争对手开始筹集种子轮或 A 轮融资来建立配送网络。

---

### [00:46:18] Casey Winters

**English:**
On the one hand, you have Grubhub, this extremely high-margin business, and these businesses coming up are actually negative-margin businesses. At least they were for a long time. In 2013, Grubhub acquired Seamless, its closest competitor at the time. Seamless still had a lead on Grubhub in New York, partially because it had this corporate program where law firms, and banks, and consultants got lunch stipends you had to redeem by ordering the food through Seamless. Grubhub operated in these dense cities and suburbs like in New York because those were really places that had restaurants that had delivery.

**中文翻译:**
一方面，你有 Grubhub 这个利润率极高的业务，而这些新兴业务实际上是负利润业务，至少在很长一段时间内是这样。2013 年，Grubhub 收购了当时最接近的竞争对手 Seamless。Seamless 在纽约仍然领先于 Grubhub，部分原因是它有一个企业计划，律师事务所、银行和咨询公司的员工有午餐补贴，必须通过 Seamless 订餐才能兑现。Grubhub 在纽约等人口稠密的城市和郊区运营，因为那些地方确实有提供配送服务的餐厅。

---

### [00:46:58] Casey Winters

**English:**
DoorDash, when it started, operated in less dense suburbs and worked with restaurants that had never done delivery before, and they would provide the delivery drivers themselves. This allowed DoorDash to grow without much competition in the early days. These companies also took some real gambles. One of the things they did is they delivered from restaurants they didn't have an agreement with, and that caused controversy and lawsuits. What it meant is when these companies did launch in the cities to go after Grubhub, it felt like DoorDash, and Postmates, and Uber had dramatically larger selection of restaurants to choose from, and Grubhub was definitely no longer near comprehensive.

**中文翻译:**
DoorDash 刚开始时在人口密度较低的郊区运营，并与从未做过外卖的餐厅合作，由他们自己提供外卖员。这使得 DoorDash 在早期没有太多竞争的情况下得以增长。这些公司也冒了一些真正的风险。他们做的一件事是从没有达成协议的餐厅配送，这引发了争议和诉讼。这意味着当这些公司进军城市挑战 Grubhub 时，感觉 DoorDash、Postmates 和 Uber 拥有大得多的餐厅选择范围，而 Grubhub 绝对不再接近“全面”了。

---

### [00:48:14] Casey Winters

**English:**
What Grubhub assumed is that these businesses were just structurally unprofitable, and that VCs would stop subsidizing them eventually. Of course, that didn't happen. They kept raising more money. DoorDash eventually raised multiple billions of dollars in this market. Part of what they used that money for was to lock up agreements with national chains, which Grubhub never worked with. It was always like the local mom and pops, and promotions and discounts on the demand side. All of this is happening, and then the pandemic hits, and all of those negative margins turned positive for DoorDash for the first time, if I understand things correctly.

**中文翻译:**
Grubhub 当时的假设是，这些业务在结构上就是不盈利的，风投最终会停止补贴。当然，这并没有发生。他们继续筹集更多的钱。DoorDash 最终在这个市场上筹集了数十亿美元。他们把这些钱的一部分用于锁定与全国连锁店的协议，而 Grubhub 从未与这些连锁店合作过（Grubhub 总是关注当地的小店），并在需求端进行促销和折扣。所有这些都在发生，然后疫情爆发了，如果我没理解错的话，DoorDash 的所有负利润第一次转正了。

---

### [00:49:24] Casey Winters

**English:**
Look, I'll admit Grubhub made some mistakes, but I think it would have been extremely hard for Grubhub to come out on top here. Let's say in 2014 after you IPO, you do actually think what DoorDash, Postmates, and Uber are doing are smart. What do you do? Go to investors that you promised high growth and high profits and say you need to raise more money in debt to compete with negative-margin upstarts in a way that will destroy all that potential profit you mentioned? The stock would drop 90%. A lot of your employees would leave because their stock is now worthless. On top of that, building a delivery network is a heavy operations play that matches none of your core competencies, so to me, that feels like a death sentence.

**中文翻译:**
听着，我承认 Grubhub 犯了一些错误，但我认为 Grubhub 很难在这场竞争中胜出。假设在 2014 年 IPO 之后，你真的认为 DoorDash、Postmates 和 Uber 的做法是明智的。你会怎么做？去告诉那些你承诺过高增长和高利润的投资者，说你需要通过举债筹集更多资金，以一种会摧毁你提到的所有潜在利润的方式，去与负利润的新兴公司竞争？股价会下跌 90%。很多员工会离开，因为他们的股票现在一文不值。最重要的是，建立配送网络是一个重运营的博弈，与你的核心竞争力完全不匹配。所以对我来说，那感觉就像是死刑判决。

---

### [00:50:10] Casey Winters

**English:**
I think the only play here was to buy DoorDash as early as possible, and let DoorDash and their operationally-heavy culture eat Grubhub from the inside out. I think Grubhub probably could have acquired them multiple times. For whatever reason, it never happened. It would have seemed pretty risky had Grubhub done that. Investors probably would have hated it, but it would have been their Netflix moment, where Netflix bet it all on streaming and they bet right. This is all incredibly easy to say in hindsight.

**中文翻译:**
我认为这里唯一的出路是尽早收购 DoorDash，让 DoorDash 及其重运营的文化从内部吞噬 Grubhub。我认为 Grubhub 本可以多次收购他们。由于某种原因，这从未发生。如果 Grubhub 真的那么做了，看起来会非常冒险，投资者可能会讨厌它，但这本可以成为他们的“Netflix 时刻”——Netflix 把赌注全部押在流媒体上，而且赌赢了。事后看来，说这些都非常容易。

---

### [00:50:43] Casey Winters

**English:**
I think what I've learned now that I'm more senior in my career is during existential threats, it's like when Nassim Taleb says, "The only rational reaction is overreaction." Unless you have a real viable reason to assume otherwise, you got to assume the disruptor is right and base your strategy on them playing an optimal game. Whereas, I think Grubhub assumed the disruptor was wrong and that it would all play out eventually in their favor, and it clearly didn't.

**中文翻译:**
我想我现在职业生涯更资深了，学到的是在面临生存威胁时，就像纳西姆·塔勒布（Nassim Taleb）所说的：“唯一理性的反应就是过度反应。”除非你有真正可行的理由假设并非如此，否则你必须假设颠覆者是正确的，并基于他们正在进行最优博弈来制定你的策略。而我认为 Grubhub 当时假设颠覆者是错误的，认为一切最终都会朝着有利于他们的方向发展，但显然事实并非如此。

---

### [00:55:11] Casey Winters

**English:**
The canonical example that a lot of these founders use is OpenTable. That always felt really unfulfilling to me because it's very old at this point. Probably the younger people listening to the podcast are like, "What's OpenTable?" I think that business has incredibly underperformed the market it operated in. It had a good exit. It sold for $2.6 billion, I think, to Booking.com, but Booking subsequently wrote that value down below a billion, so that's not really the outcome I think we're looking for, traditionally, in marketplaces.

**中文翻译:**
很多创始人使用的典型例子是 OpenTable。这对我来说总是感觉不够有说服力，因为它现在已经非常老旧了。听这个播客的年轻人可能会问：“OpenTable 是什么？”我认为那项业务的表现远低于它所在的市场。它有一个不错的退出，我想是以 26 亿美元卖给了 Booking.com，但 Booking 随后将该价值减记至 10 亿美元以下。所以这并不是我们传统上在市场平台业务中寻找的结果。

---

### [00:57:05] Casey Winters

**English:**
Look, this is definitely the strategy we are working on with Eventbrite, where we started with something that was more SaaS-like, enabling easy payments and certain tools to make event creators' business more efficient, and we're layering in more of the traditional marketplace value prop of demand, driving more ticket sales for these event creators. I would say it's got a ways to go to be working really well. What does working really well look like? It's when the marketplace model unlocks those cross-side network effects that make it easier to grow.

**中文翻译:**
听着，这绝对是我们正在 Eventbrite 实施的策略。我们从更像 SaaS 的东西开始，提供便捷的支付和某些工具，让活动创作者的业务更高效。然后我们正在加入更多传统的市场平台价值主张，即需求端，为这些活动创作者带来更多门票销售。我会说要达到非常理想的效果还有很长的路要走。什么叫“非常理想”？就是当市场模式解锁了那些让增长变得更容易的双边网络效应时。

---

### [00:59:24] Casey Winters

**English:**
Yeah. I think that's right. I think, I don't know when it was. Just maybe like 2015 or whatever. A bunch of investors started writing about SaaS to marketplace transitions, and that's the transition Eventbrite's going through. It's going to work, but it's hard. It's not replicable for a lot of other SaaS businesses. You need to have a direct relationship with your customers' customers, first off. Those customers need to have needs beyond that single supplier. Usually, it's like a discovery value prop for other suppliers, and you need to build this totally new skill set to build tools for your customer's customer, who is very different from your current customer.

**中文翻译:**
是的，我认为没错。我想大概是在 2015 年左右，一群投资者开始撰写关于“从 SaaS 到市场平台”转型的文章，这正是 Eventbrite 正在经历的转型。它会奏效，但很难。对于很多其他 SaaS 业务来说，这是不可复制的。首先，你需要与你客户的客户建立直接关系。其次，那些客户需要有超出单一供应商的需求。通常，这就像是针对其他供应商的“发现”价值主张。而且你需要建立一套全新的技能组合，为你客户的客户构建工具，而他们与你当前的客户非常不同。

---

### [01:00:20] Casey Winters

**English:**
Whereas, marketplace is that added SaaS component. It's a customer acquisition tool like Faire, or a workflow, or a retention tool to increase retention or reduce disintermediation. I think you'll see that be a lot more common approach and much more replicable.

**中文翻译:**
反之，市场平台增加 SaaS 组件，它是一个像 Faire 那样的客户获取工具，或者是一个工作流、留存工具，用来增加留存或减少“去中介化”（跳单）。我认为你会看到这成为一种更普遍且更具可复制性的方法。

---

### [01:06:07] Lenny

**English:**
You often tell me how they're incredibly hard to build into thriving businesses. Can you just talk about why consumer subscription startups are so hard and products are so hard?

**中文翻译:**
你经常告诉我，要把消费级订阅业务做成蓬勃发展的企业是多么困难。你能谈谈为什么消费级订阅初创公司和产品这么难做吗？

---

### [01:06:18] Casey Winters

**English:**
I feel like we're making this quite a downer podcast, Lenny, but... people need to hear the truth. I think in order to understand these businesses, you have to start with, why do investors like B2B SaaS? Why do they like B2B subscription? I think the way most people respond to that question, they say like, "Oh, predictable revenue, right?" It's like, ah, sure. That's cool and all, but I think that's actually not the most important. I'd argue there's two great attributes of B2B SaaS. One is that businesses are more predictable in how well they're routine. They're rational. You can understand who are good versus bad businesses for your product, as well as which ones are going to grow versus go out of business.

**中文翻译:**
我觉得我们把这期播客做得有点沉重了，Lenny，但是……人们需要听到真相。我认为为了理解这些业务，你必须首先思考：为什么投资者喜欢 B2B SaaS？为什么他们喜欢 B2B 订阅？我想大多数人回答这个问题时会说：“噢，收入可预测，对吧？”这当然很酷，但我认为这其实不是最重要的。我认为 B2B SaaS 有两个伟大的属性。第一，企业在日常运作中更具可预测性。他们是理性的。你可以了解哪些企业适合你的产品，哪些不适合，以及哪些会增长，哪些会倒闭。

---

### [01:06:53] Casey Winters

**English:**
More importantly, the second thing that's great about B2B SaaS is net dollar retention. What is net dollar retention if you don't work at SaaS? Well, as a SaaS company, some of your customers are going to churn. Some of your customers are going to stay. Normally, normally outside of potentially current macroeconomic conditions with all the layoffs, when customers do stick around, they tend to spend more. Either they buy more seats if you're a seat-based model, or they use the product more if you're a usage model. The SaaS company just makes more money in year two, year three, et cetera.

**中文翻译:**
更重要的是，B2B SaaS 的第二个优点是“净金额留存”（Net Dollar Retention, NDR）。如果你不在 SaaS 行业工作，什么是净金额留存？作为一家 SaaS 公司，你的一些客户会流失，一些会留下来。通常情况下（排除目前裁员潮等宏观经济状况），当客户留下来时，他们往往会花更多的钱。如果你是按席位计费的模式，他们会购买更多席位；如果你是按使用量计费的模式，他们会更多地使用产品。SaaS 公司在第二年、第三年等会赚到更多的钱。

---

### [01:07:27] Casey Winters

**English:**
Consumer subscription just doesn't have any of these benefits. Consumers are way less predictable. They tend to retain worse than businesses, and they also don't have net dollar retention characteristics. If the user retains paying you in year two, you probably making the same amount that you made from them in year one, not more. What that means is you need higher user-based retention than B2B SaaS businesses with more unpredictable users, and it's a lot higher than, I think, founders tend to think. We're talking annual retention that needs to be north of 60, perhaps even 70%.

**中文翻译:**
消费级订阅完全没有这些优势。消费者的可预测性要低得多，他们的留存率往往比企业差，而且他们也不具备净金额留存的特征。如果用户在第二年继续付钱给你，你赚到的钱可能和第一年一样，而不是更多。这意味着与 B2B SaaS 业务相比，你需要更高的基于用户的留存率，而且面对的是更不可预测的用户。我认为这个比例比创始人想象的要高得多。我们说的是年留存率需要超过 60%，甚至 70%。

---

### [01:08:04] Casey Winters

**English:**
You look at who's actually been able to do that at scale, and it's a really small list. Netflix in the U.S., Amazon Prime, Spotify, Duolingo, I think, is emerging as one of these players that's making it work. When you look at how they do it, they're either doing it with massive OPEX and economies of scale, or through a network effect, or some other bespoke growth loop that's not that easy to replicate.

**中文翻译:**
你看看谁真正能在大规模上做到这一点，名单非常短。美国的 Netflix、Amazon Prime、Spotify，我认为 Duolingo 正在成为其中一员。当你观察他们是如何做到的，他们要么是依靠巨大的运营支出（OPEX）和规模经济，要么是通过网络效应，或者其他不容易复制的定制增长循环。

---

### [01:13:15] Lenny (Lightning Round)

**English:**
Well, we've reached our very exciting lightening round. I'm just going to dive right in. What are two or three books that you've most recommended to other people?

**中文翻译:**
好了，我们进入了非常激动人心的闪电问答环节。我直接开始了。你向别人推荐最多的两三本书是什么？

---

### [01:13:23] Casey Winters

**English:**
Definitely The Goal by Eliyahu Goldratt, which explains how my brain works, pretty well. Thinking, Fast and Slow by Danny Kahneman... Then the third is a book called Profit from the Core by Chris Zook.

**中文翻译:**
绝对有艾利·高德拉特（Eliyahu Goldratt）的《目标》（The Goal），它很好地解释了我的大脑是如何运作的。丹尼尔·卡尼曼（Danny Kahneman）的《思考，快与慢》……第三本是克里斯·祖克（Chris Zook）的《回归核心》（Profit from the Core）。

---

### [01:14:11] Lenny

**English:**
Favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视节目？

---

### [01:14:11] Casey Winters

**English:**
Well, Party Down just came back... Other things like The Last of Us is great... Severance is great. Station Eleven is great... Movies... I did rewatch Kicking and Screaming from the '90s.

**中文翻译:**
嗯，《派对之后》（Party Down）刚回归……其他的像《最后生还者》（The Last of Us）很棒……《人生切割术》（Severance）很棒，《十一号站》（Station Eleven）也很棒……电影方面……我重温了 90 年代的《踢踢笑笑》（Kicking and Screaming）。

---

### [01:15:21] Casey Winters

**English:**
I preach cross-functional teams and alignment pretty aggressively... Something we started doing more recently at both Eventbrite and Whatnot is just designating the person on the cross-functional team who drives the project. At Eventbrite, we call it the driver. At Whatnot, we call it the DRI, directly responsible individual. Once that person makes the call, it's disagree and commit time.

**中文翻译:**
我非常积极地倡导跨职能团队和目标对齐……我们最近在 Eventbrite 和 Whatnot 开始做的一件事是，明确指定跨职能团队中负责推动项目的人。在 Eventbrite，我们称之为“驾驶员”（driver）；在 Whatnot，我们称之为 DRI（直接责任人）。一旦那个人做了决定，就是“保留意见并执行”（disagree and commit）的时候了。

---

### [01:16:50] Casey Winters

**English:**
I blog not near as frequently as you at caseyaccidental.com. You can find me on Twitter @onecaseman. Yeah, just pay it forward. Help your companies build better products and better businesses. That's all I care about.

**中文翻译:**
我的博客更新频率远不如你，网址是 caseyaccidental.com。你可以在 Twitter 上通过 @onecaseman 找到我。是的，把这份经验传递下去。帮助你的公司构建更好的产品和更好的业务，这就是我关心的全部。

---

### [01:17:15] Lenny

**English:**
Casey, thank you so much for being here... Hopefully, you'll be back for a third time someday. Thank you again. Really appreciate it.

**中文翻译:**
Casey，非常感谢你能来……希望有一天你能第三次返场。再次感谢，非常感激。

---

### [01:17:15] Casey Winters

**English:**
Yeah. Thanks for having me. Hopefully, they don't get sick of me by then.

**中文翻译:**
是的，谢谢邀请我。希望到时候大家还没听腻我的话。