# Chandra Janakiraman - 双语对照

# Lenny's Podcast: Chandra Janakiraman - An Operator's Guide to Strategy
## 嘉宾：Chandra Janakiraman —— 策略执行者指南

---

### [00:00:00] Chandra Janakiraman

**English:**
I started noticing that there was a certain mystique and aura about product strategy. There was this perception that some people were intrinsically really good at strategy and others were not. It was almost as if there was a strategy gene you needed to be born with to be good at it.

**中文翻译:**
我开始注意到，产品策略（Product Strategy）似乎带有一种神秘感和光环。人们普遍认为，有些人天生就擅长策略，而有些人则不然。就好像你必须拥有某种“策略基因”才能做好这件事一样。

---

### [00:00:16] Lenny Rachitsky

**English:**
Say someone's sitting down, okay, I'm going to start developing a strategy for our product. Where do you begin? What does this process look like?

**中文翻译:**
假设有人坐下来想：“好吧，我要开始为我们的产品制定策略了。” 那么该从哪里开始呢？这个过程具体是怎样的？

---

### [00:00:23] Chandra Janakiraman

**English:**
In terms of what product strategy is? There is a smallest flavor of it which focuses on solving problems, they're called present forward, and it typically operates in a two-year horizon. We use a five-stage process to get there and it takes about eight to 12 weeks. The reason I think this process works is there is a ton of alignment built in. It goes back to human psychology of just something that comes from you, feels a lot more familiar and easy to accept.

**中文翻译:**
关于什么是产品策略？它有一种“小写 s”的版本，侧重于解决问题，被称为“立足当下，展望未来”（present forward），通常运作周期为两年。我们使用一个五阶段的流程来实现它，大约需要 8 到 12 周。我认为这个流程之所以有效，是因为其中内置了大量的共识达成（alignment）环节。这涉及人类心理学：如果某样东西是你参与创造的，你会觉得它更亲切、更容易接受。

---

### [00:00:49] Lenny Rachitsky

**English:**
Let's talk about big S strategy. When should you approach strategy this way?

**中文翻译:**
那我们来谈谈“大写 S”战略（Big S Strategy）。什么时候应该采用这种方式来制定战略？

---

### [00:00:53] Chandra Janakiraman

**English:**
There's this interesting quote by Elon Musk, which is—

**中文翻译:**
埃隆·马斯克（Elon Musk）有一句很有趣的名言——

---

### [00:00:56] Elon Musk

**English:**
"Life's got to be about more than just solving problems."

**中文翻译:**
“生活不能仅仅是为了解决问题。”

---

### [00:00:58] Chandra Janakiraman

**English:**
I think this is true of every sort of company. There needs to be an aspirational and cool component to strategy. What does the product look like in five to 10 years? Why is the world better in 10 years? And what is the most exciting version of that view?

**中文翻译:**
我认为这对任何类型的公司都适用。战略中需要包含令人向往且酷炫的成分。产品在 5 到 10 年后会是什么样子？为什么 10 年后的世界会变得更好？那个愿景中最令人兴奋的版本是什么？

---

### [00:01:15] Lenny Rachitsky

**English:**
Today my guest is Chandra Janakiraman. Chandra is chief product officer and executive vice president at VRChat. He was a product leader at Meta, chief product officer at Headspace, a GM at Zynga, and a senior PM at Amazon. And the way this podcast episode happened was an avid podcast listener, Karthik Suresh, told me about Chandra at a community meetup. And when I connected with Chandra, it was clear that I needed to get him on the podcast.

**中文翻译:**
今天的嘉宾是 Chandra Janakiraman。Chandra 是 VRChat 的首席产品官（CPO）兼执行副总裁。他曾是 Meta 的产品负责人、Headspace 的首席产品官、Zynga 的总经理以及亚马逊的高级产品经理。这期节目的契机是，一位热心听众 Karthik Suresh 在一次社区聚会上向我推荐了 Chandra。当我联系上 Chandra 时，我立刻意识到必须邀请他来参加播客。

(00:01:40):
**English:**
Chandra is a student of strategy and has spent his career developing what he calls an operator's guide to strategy, which essentially pulls together the best ideas from Good Strategy, Bad Strategy, Playing to Win, Michael Porter and others to create a very clear, reliable and easy-to-follow five-step process to develop a great strategy and a set of next steps for your product and company. After hearing Chandra walk through this in our conversation, I'm basically going to now point everyone who wants to get better at strategy to this episode and Chandra's method. Strategy is at the heart of every great product and team and business, and it's also the source of so much pain if you do it badly. This episode is meant to help you avoid that. A big thank you to Karthik for making this connection. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that, I bring you Chandra Janakiraman.

**中文翻译:**
Chandra 是一位策略研究者，他在职业生涯中开发了一套他称之为“策略执行者指南”的方法。这套方法融合了《好战略，坏战略》、《玩转胜算》（Playing to Win）、迈克尔·波特（Michael Porter）等人的精华思想，创造了一个非常清晰、可靠且易于遵循的五步流程，用于为你的产品和公司制定卓越的策略及后续步骤。在听完 Chandra 的讲解后，我现在基本上会向每一个想提升策略能力的人推荐这一集和 Chandra 的方法。策略是每个伟大产品、团队和业务的核心，如果做得不好，它也是痛苦的根源。本期节目旨在帮助你避免这些坑。非常感谢 Karthik 的引荐。如果你喜欢这个播客，别忘了在订阅并关注。这是避免错过后续节目的最好方式，也对我们很有帮助。下面，让我们欢迎 Chandra Janakiraman。

---

### [00:02:39] Lenny Rachitsky (Sponsorship)

**English:**
This episode is brought to you by Eppo. Eppo is a next-generation A-B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams... [Ad content omitted for brevity in summary but translated below if required].

**中文翻译:**
本期节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依赖 Eppo 来驱动他们的实验。实验对于推动增长和了解新功能表现越来越重要，Eppo 帮助你提高实验速度，同时解锁严谨的深度分析。

---

### [00:03:57] Lenny Rachitsky (Sponsorship)

**English:**
This episode is brought to you by Airtable ProductCentral, the unified system that brings your entire product org together in one place... [Ad content omitted for brevity].

**中文翻译:**
本期节目由 Airtable ProductCentral 赞助。这是一个将整个产品组织聚集在一起的统一系统。如果你像大多数产品领导者一样，厌倦了在各种工具之间不断切换上下文，那么 Airtable 在与世界级产品公司合作数十年后构建了 ProductCentral。你可以将其视为整个产品组织的“任务控制中心”。

---

### [00:04:51] Lenny Rachitsky

**English:**
Chandra, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Chandra，非常感谢你能来，欢迎来到播客。

---

### [00:04:55] Chandra Janakiraman

**English:**
Pleasure to be here, Lenny.

**中文翻译:**
很高兴来到这里，Lenny。

---

### [00:04:57] Lenny Rachitsky

**English:**
I want to share actually the context and how this conversation happened. I was at a meetup of my readership, of my community and someone came up to me and they're like, "Lenny, you need to get this guy Chandra on your podcast. He's the most amazing playbook for developing a strategy." He's gone through it with you at a company he worked at with you once, and he's just like, "People need to learn this because it's so good." And to me, if someone can get better at strategy, it feels like it just makes so much of the way the company operates and the way that people work better. So we chatted, we met, I was like, "I completely agree. We definitely need to get you on this podcast to share your approach to the strategy." So we made this happen, and so we're here. So again, thank you for doing this and sharing.

**中文翻译:**
我想分享一下这次对话的背景。当时我在我的读者社区聚会上，有人走过来对我说：“Lenny，你一定要请 Chandra 上你的节目。他有一套极其出色的制定策略的剧本（playbook）。” 他曾和你一起在某家公司共事并应用过这套方法，他说：“大家需要学习这个，因为它太棒了。” 对我来说，如果有人能提升策略能力，整个公司的运作方式和员工的工作状态都会变得更好。所以我们聊了聊，见了面，我觉得：“我完全同意，我们一定要请你来分享你的策略方法。” 于是就有了这次对话。再次感谢你的分享。

---

### [00:05:37] Chandra Janakiraman

**English:**
Thank you. Thank you, Lenny.

**中文翻译:**
谢谢，谢谢你，Lenny。

---

### [00:05:39] Lenny Rachitsky

**English:**
First of all, I wanted to ask just you're very passionate about strategy and developing a way to consistently create great strategies. What got you so interested in this stuff in the first place? What kind of sparked your interest in this area?

**中文翻译:**
首先我想问，你对策略以及如何持续制定出色的策略非常有热情。最初是什么让你对这方面产生如此浓厚的兴趣？是什么激发了你在这个领域的探索？

---

### [00:05:53] Chandra Janakiraman

**English:**
Yeah, yeah, it's a very interesting story. It goes back all the way 10 years ago, but I remember it vividly like it happened yesterday. And I was a relatively new VP of product at Headspace, and we had this amazing company vision and mission that the founders had laid out, and I had come in and established goals for the team in terms of our key metrics, and we had a very buttoned up roadmap in my mind that fed into that company mission and vision. And I was feeling pretty good about how things were shaping up.

**中文翻译:**
是的，这是一个非常有趣的故事。这要追溯到 10 年前，但我记忆犹新，仿佛就发生在昨天。当时我是 Headspace 新上任的产品副总裁，创始人已经制定了宏伟的公司愿景和使命。我进来后，根据关键指标为团队设定了目标，并且在我看来，我们有一份非常严密的路线图（roadmap），完美契合公司的使命和愿景。当时我对进展感觉非常良好。

(00:06:37):
**English:**
And on a particular Monday, the founder, CEO pulled me aside, and in his usual disarming style, he sort of made a short but profound statement. He said that, "Hey, CJ, I'm hearing that a lot of people don't really understand why we are working on what we are working on," and that was it. That was really the extent of what he shared. And it was a little bit of a bubble bursting moment for me because we obviously had spent a lot of time building the plan and I was feeling relatively good about the plan.

**中文翻译:**
但在某个周一，创始人兼 CEO 把我拉到一边，用他那种一贯平易近人的风格，说了一句简短但深刻的话。他说：“嘿，CJ，我听说很多人其实并不理解我们为什么要做的这些工作。” 就这一句话，这就是他分享的全部内容。对我来说，这简直是一个“幻灭时刻”，因为我们显然花了很多时间制定计划，而且我原本对这个计划感觉相当不错。

(00:07:21):
**English:**
And so I spoke to a few people. I sort of wanted to understand it a little bit deeper, like, "Hey, what's happening?" And he was right. He was right. A lot of people didn't really understand why we were working on the things we were working on, and it led to some soul-searching. And basically I was lucky because there was actually a board member of Headspace who had a product background, kind of knew what good looked like, and I came to the conclusion, "Hey, we needed a strategy for Headspace."

**中文翻译:**
于是我找了几个人聊了聊，想深入了解一下：“嘿，到底发生了什么？” 结果发现他是对的。很多人确实不明白我们工作的意义。这引发了我的一些反思。幸运的是，Headspace 的一位董事会成员有产品背景，知道什么是好的产品实践。我得出了结论：“我们需要为 Headspace 制定一套策略。”

(00:07:56):
**English:**
So with extensive work with her, with the board person, we built the first written product strategy for Headspace. And that, and the subsequent actions on the product led to a complete re-imagination of the product. And basically we were able to create a new product, we call it the Next Generation Headspace, which on one hand it could support a comprehensive library of content, not just meditation, but non-meditation content as well. It had the sort of home experience where everything was incredibly personalized for the individuals, and there were several motivational elements built into the whole product experience. And it was very transformational for the company and the product because it changed the product from being a meditation app to a broader health and wellness service and really put the company on a different trajectory. It led to my promotion to the first CPO at Headspace.

**中文翻译:**
通过与那位董事会成员的大量合作，我们制定了 Headspace 的第一份书面产品策略。那次策略制定以及随后的产品行动，导致了产品的彻底重构。我们创造了一个新产品，称之为“下一代 Headspace”。一方面，它支持更全面的内容库，不仅有冥想，还有非冥想内容；另一方面，它拥有极其个性化的主页体验，并在整个产品体验中融入了多种激励元素。这对公司和产品来说都是转型性的，因为它让产品从一个单纯的冥想 App 变成了一个更广泛的健康服务，真正让公司走上了不同的发展轨道。这也促使我被提拔为 Headspace 的首任 CPO。

(00:09:07):
**English:**
And most interestingly, I had a chance to, while going through it almost in a sort of out of body way, observed the process of like, okay, how did we put this thing together? And what actually went into it? What really started as almost a personal crisis moment of finding this need to create a strategy for a product and a company led to a bigger sort of quest for me, which is I started noticing that there was a certain mystique and aura about product strategy, and there was this perception that some people were intrinsically really good at strategy and others were not. And it was almost as if there was a strategy gene that you needed to be born with to be good at it. And that bothered me a lot, and I sort of wanted to ask myself, is it possible to break that divide between the haves and the have-nots and make this capability widely accessible through a procedural approach. And I have news for you. The answer is yes, anybody can build product strategy through a clear understanding of what it is and through a friendly and repeatable playbook.

**中文翻译:**
最有趣的是，在经历这个过程时，我仿佛以一种“灵魂出窍”的方式观察了整个流程：我们是如何把这些东西整合在一起的？到底投入了什么？最初这只是一个发现产品和公司需要策略的个人危机时刻，但后来演变成了我更大的追求。我开始注意到产品策略带有一种神秘感，人们认为有些人天生擅长，有些人则不然，仿佛需要某种“策略基因”。这让我很困扰，我想问自己：是否可能打破这种“有基因”和“没基因”之间的鸿沟，通过一种程序化的方法让这种能力变得普及？我有好消息告诉你：答案是肯定的。任何人只要清晰地理解什么是策略，并通过一套友好且可重复的剧本，都能构建出产品策略。

---

### [00:10:29] Lenny Rachitsky

**English:**
Amazing. That's exactly what I want to do here. The point you made about the why, I think everyone listening to this that's been in product for long enough has heard that of just, "Your team doesn't understand why we're doing this." I've heard that a number of times, as much as you think you're killing it, there's always that, you forget sometimes to do that or you aren't doing it great. And I love that basically the solution to that is the strategy solves that problem of helping people connect the dots and understand why this is the roadmap, why this is the strategy. Okay, so before we get into it, just one more context question, what's just the best way to think about what you're about to share and also who's it for? Who needs to hear this briefly?

**中文翻译:**
太棒了。这正是我想在这里探讨的。你提到的关于“为什么（why）”的那一点，我想任何在产品领域待得够久的人都听过这样的话：“你的团队不理解我们为什么要这么做。” 我也听过很多次。无论你觉得自己做得多出色，总会有这种时刻，有时你会忘记解释，或者解释得不够好。我非常喜欢你说的，策略就是解决这个问题的方案，它帮助人们串联起所有的点，理解为什么这是路线图，为什么这是策略。在我们深入探讨之前，还有一个背景问题：对于你即将分享的内容，最好的理解方式是什么？它是为谁准备的？谁最需要听这些？

---

### [00:11:11] Chandra Janakiraman

**English:**
So the way to think about this, the substance is that this is not a new framework or theory that I'm going to be talking about. There are plenty of excellent materials on strategy from ancient texts like The Art of War from Sun Tzu, all of Michael Porter's work, Good Strategy Bad Strategy by Richard Rumelt, who's been on your podcast, Playing to Win Lafley and Roger Martin. So there's a ton of extensively researched and well-founded materials out there. So the way I would think about this is, it's more of an operator's interpretation of all the stuff that's out there and are able to package it into something that's friendly and repeatable, particularly for product people who think they are weak at strategy or perhaps have received such feedback.

**中文翻译:**
关于如何看待这些内容，实质上我并不是要讲一套全新的框架或理论。关于策略，已经有很多优秀的材料了，从古代的《孙子兵法》，到迈克尔·波特的著作，再到理查德·鲁梅尔特（Richard Rumelt，他也上过你的播客）的《好战略，坏战略》，以及拉弗利和罗杰·马丁的《玩转胜算》。市面上已经有大量研究透彻、基础扎实的材料。所以我认为，这更像是一个“执行者”对现有知识的解读，并将其打包成一套友好且可重复的东西，特别是针对那些觉得自己策略能力弱，或者收到过此类反馈的产品人。

(00:12:05):
**English:**
And just in terms of the battle-tested nature of it, I personally use this playbook about five to six times tweaking and optimizing it each time based on what I thought worked, what people thought worked and didn't work, including several times at Meta and usually leading to strong results, both for me achieving senior leadership alignment as well as driving business results for the company.

**中文翻译:**
就其实战性而言，我个人已经使用这套剧本大约五到六次了，每次都会根据实际效果以及大家的反馈进行微调和优化。包括在 Meta 的几次应用，通常都能带来显著的成果，既帮我达成了与高层领导的共识，也为公司驱动了业务增长。

---

### [00:12:49] Lenny Rachitsky

**English:**
Okay, I'm getting more and more excited. Let's get into it, let's get into this playbook. People hear this word strategy a lot. They're told be more strategic, build a better strategy. What's the simplest way to understand what is a strategy?

**中文翻译:**
太好了，我越来越兴奋了。让我们开始深入探讨这套剧本吧。人们经常听到“策略”这个词，被要求“更有策略性”、“制定更好的策略”。那么，理解“什么是策略”最简单的方式是什么？

---

### [00:12:49] Chandra Janakiraman

**English:**
Yeah, let's start with some basic definitions, which is as you asked, what is product strategy? And if you think back to the Headspace example, this sort of comes to life as well. So product strategy, strategy sits between the mission and vision and the plan. It could be at the company level or at the team level, but it's usually sitting between the mission and vision and the plan. And the plan, you can call the plan the roadmap, which is basically an ordered list of things that you want to get done and the mission and vision is basically sort of the purpose of existence, what does it look like when you achieve your purpose of existence? So it sits between the two and it forces choice to deploy scarce resources to generate maximum impact.

**中文翻译:**
好，我们先从一些基本定义开始。正如你所问，什么是产品策略？回想一下 Headspace 的例子，这个定义就变得鲜活了。产品策略位于“使命与愿景”和“计划”之间。它可以在公司层面，也可以在团队层面。所谓的“计划”，你可以称之为路线图，基本上就是你想完成的事情的有序列表；而“使命与愿景”基本上是存在的意义，以及当你实现这个意义时世界的样子。策略就介于两者之间，它强制你做出选择，以部署稀缺资源来产生最大的影响力。

(00:13:40):
**English:**
And I want to borrow an analogy from the world of physics. There is this concept called resonance, and the concept of resonance is really interesting, and it's actually very close to the concept of strategy. So the concept of resonance works as follows, when you apply a certain frequency to an object and you get pretty close to its natural frequency, you see a disproportionate increase in the amplitude of how that object vibrates. And so it's very interesting, if you apply any other frequency, there's very little effect on the object, but if you get close to its natural frequency, there's this exponential increase in the vibration of the product. So this concept of resonance is interesting.

**中文翻译:**
我想借用物理学中的一个类比。有一个概念叫“共振”（resonance），共振的概念非常有趣，实际上它与策略的概念非常接近。共振的原理是：当你对一个物体施加特定频率，且该频率非常接近其固有频率时，你会看到该物体振动的振幅（amplitude）出现不成比例的巨大增长。这很有趣，如果你施加任何其他频率，对物体几乎没有影响；但如果你接近它的固有频率，产品的振动就会呈指数级增长。所以共振这个概念很有启发性。

(00:14:27):
**English:**
So the way to think about it in the context of strategy is, it is selecting that frequency to achieve resonance between the product and the market. And so when you get close to that frequency, you should see tremendous impact in terms of the product landing well in the market. And so that's how I would think about it. It sits between mission, vision and the plan. It forces choice to deploy scarce resources to generate maximum impact, so using resonance as a sort of an example, and it ideally includes three components. The first is a handful of areas to focus on and I call these strategic pillars and then a whole bunch of areas that are explicitly not the focus. And the third component is why. So why are the focus areas, A, B and C? Why are these whole bunch of areas not the focus? And that's the three components. That's really it in terms of product strategy.

**中文翻译:**
在策略的语境下，你可以这样理解：策略就是选择那个频率，以实现产品与市场之间的“共振”。当你接近那个频率时，你会看到产品在市场上取得巨大的成功。这就是我的看法。它介于使命愿景与计划之间，强制做出选择以部署稀缺资源产生最大影响。理想情况下，它包含三个组成部分：第一，少数几个重点关注领域，我称之为“战略支柱”（strategic pillars）；第二，一大堆明确不作为重点的领域；第三，原因（Why）——为什么 A、B、C 是重点？为什么其他那些不是？这就是产品策略的全部。

---

### [00:15:32] Lenny Rachitsky

**English:**
I love it. And I love the things we aren't doing as a core part of this, that comes up a lot on this podcast of being clear is what we're not going to do. We know these could be things we could do, but we're deciding we're not doing these things. Okay, so let's just talk through how you go about developing a strategy using this method. Say someone's sitting down, "Okay, I'm going to start developing a strategy for our product." Where do you begin? What does this process look like? Let's start talking through it.

**中文翻译:**
我太喜欢这个定义了。特别是把“我们不打算做的事”作为核心部分，这在我的播客中经常被提到——明确什么是不做的非常重要。我们知道这些事可以做，但我们决定不做。好，那我们来聊聊如何使用这种方法开发策略。假设有人坐下来想：“好，我要开始为我们的产品制定策略了。” 从哪里开始？流程是怎样的？

---

### [00:15:59] Chandra Janakiraman

**English:**
So I sort of want to first explain this concept called smallest strategy, and I'll sort of talk about what that is and how it's different from another kind. But the basic sort of strategic process I would say takes about eight to 12 weeks long. It's something that I think people often underestimate how long it takes and eventually end up taking a lot more time. But when they start off, they think, "Oh, I could probably stand this up in a couple of weeks," but usually through iteration it actually ends up taking 8 to 12 weeks anyway. So it's good to start with setting clear expectations that it takes about eight to 12 weeks. And the way to justify the ROI on that is typically a strategy like this can be leveraged for about a couple of years. So relative to that sort of payback period, I think the investment is relatively small. So it's pretty healthy from that sense to manage expectations and say that that's how long it's going to take.

**中文翻译:**
我想先解释一下“小写 s 策略”（smallest strategy）的概念，以及它与另一种策略的区别。基本的策略制定流程大约需要 8 到 12 周。我认为人们经常低估这需要多长时间，最后反而花了更多时间。刚开始时，他们会想：“噢，我大概两周就能搞定。” 但通常经过反复迭代，最终还是要花 8 到 12 周。所以，最好一开始就设定清晰的预期。证明这 8 到 12 周投资回报率（ROI）的方法是：这样一套策略通常可以沿用大约两年。相对于两年的回报期，我认为这几个月的投入是相对较小的。所以，管理好预期，明确需要这么长时间，是非常健康的。

(00:17:00):
**English:**
So within that period, there are five phases. There's the preparation phase, there's a strategy sprint, the design sprint, the document writing and the rollout. And those are the five phases, which I'll explain how one would go through. And basically each of them has a certain sort of time recommendation. For example, the preparation phase I would say is probably about four weeks. The strategy sprint is up to about one week. The design sprint is another one week, document writing maybe one to two weeks, and the rollout is maybe two to three weeks. So that's how you get to that range of eight to 12 weeks.

**中文翻译:**
在这段时间里，分为五个阶段：准备阶段（Preparation）、策略冲刺（Strategy Sprint）、设计冲刺（Design Sprint）、文档撰写（Document Writing）和发布推广（Rollout）。这就是那五个阶段，我会解释如何进行。每个阶段都有建议的时间：准备阶段大约 4 周；策略冲刺最多 1 周；设计冲刺 1 周；文档撰写 1 到 2 周；发布推广 2 到 3 周。加起来就是 8 到 12 周。

---

### [00:17:40] Lenny Rachitsky

**English:**
Essentially it's like a quarter of work to get to a final great strategy. And of these five phases, the biggest bucket is preparation, which to me sounds like it's not like a full-time team thing. It's starting to gather data and user research-

**中文翻译:**
基本上就是花一个季度的工作时间来制定一个伟大的策略。在这五个阶段中，占比最大的是准备阶段。在我听来，这似乎不是一个全职团队在做的事，而是开始收集数据和用户研究……

---

### [00:17:56] Chandra Janakiraman

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:17:57] Lenny Rachitsky

**English:**
As you talk through this, I'm curious just how much of the team is involved in each of these steps. But I think it's an important point, if you want a really good winning strategy, you need to give a time. You can't just say, "In a month or a week, we need to develop a strategy, go figure it out, write this document." Great. Cool. So let's talk about step one preparation.

**中文翻译:**
在你讲解的过程中，我很好奇团队中有多少人参与了这些步骤。但我认为重要的一点是，如果你想要一个真正能赢的策略，你必须给它时间。你不能只是说：“一个月或一周内，我们需要制定一个策略，去搞定它，写出文档。” 很好，那我们来谈谈第一步：准备阶段。

---

### [00:18:14] Chandra Janakiraman

**English:**
That's correct, Lenny. And I think you, if I forget, remind me that sometimes there is pressure. There's just business pressure, like the CEO might still want a strategy in two weeks, how do you respond to that? And I think we can find some clever shortcuts there, but I think to the extent possible, the leader should push for [inaudible] to make something really great.

**中文翻译:**
没错，Lenny。如果我忘了，请提醒我，有时会有压力，比如业务压力，CEO 可能还是想要在两周内看到策略。你该如何应对？我认为可以有一些聪明的捷径，但尽可能地，领导者应该争取时间来做出真正伟大的东西。

---

### [00:18:40] Lenny Rachitsky

**English:**
And I think part of it is that as a leader, you can start on this before... you know this is coming, so you should get started before it's even asked for.

**中文翻译:**
我认为作为领导者，你可以在……你知道这件事要来之前就开始。你应该在别人要求之前就开始准备。

---

### [00:18:48] Chandra Janakiraman

**English:**
That's correct.

**中文翻译:**
没错。

---

### [00:18:49] Lenny Rachitsky

**English:**
Yeah, awesome. Okay, let's get into it.

**中文翻译:**
太棒了，开始吧。

---

### [00:18:51] Chandra Janakiraman

**English:**
So I think you sort of touched on this in terms of the preparation phase being the longest phase, but also not being sort of like a full-time thing. So that's absolutely right. So the preparation phase is really... The way to start this, which is a little different from other approaches I've seen from people is to actually form a strategy working group. This is an important concept. So the strategy working group is sort of a small team. It typically consists of engineering, product design and data at a minimum. And in certain cases, there's a luxury to have other functions like product marketing, user research, that's also part of the strategy working group. But the minimum quorum, I would recommend is engineering, product design and data because design in some ways represents both sort of product design and user research. So you do get the voice of the user from that perspective. And typically the PM is driving the strategy working group and the process, but that working group is actually the team that's going to collaboratively create the strategy doc.

**中文翻译:**
你刚才提到准备阶段是最长的，但不是全职工作，这完全正确。准备阶段的开始方式与我见过的其他方法略有不同，那就是：组建一个“策略工作组”（strategy working group）。这是一个重要的概念。策略工作组是一个小团队，通常至少由工程、产品设计和数据人员组成。在某些情况下，如果有条件，还可以加入产品市场（PMM）、用户研究（UXR）等职能。但我建议的最低人数是工程、设计和数据，因为设计在某种程度上代表了产品设计和用户研究，你能从那个角度听到用户的声音。通常由 PM 驱动这个工作组和流程，但这个工作组才是共同创建策略文档的团队。

(00:19:59):
**English:**
And so in the preparation phase, there's usually a kickoff meeting where the PM pulls the team together, talks about the purpose of the process, lays out the different phases, and gives everybody a feel for what's going to happen in the next 8 to 12 weeks. And basically then creates a list of very discrete action items and deliverables for each of the stakeholders in the working group. So specifically, there's an action item around aggregating all the behavioral insights that the team might have around the product. And usually this is a combination of previous analysis that the team has run on the data side and potentially also feature launches and how they have done. So all kind of analytical analysis.

**中文翻译:**
在准备阶段，通常会有一个启动会议（kickoff meeting），PM 召集团队，讨论流程的目的，展示不同的阶段，让大家对未来 8 到 12 周将发生的事情有个概念。然后，为工作组中的每个利益相关者创建一份非常具体的行动项和交付物清单。具体来说，有一个行动项是汇总团队掌握的所有关于产品的“行为洞察”（behavioral insights）。这通常是数据端之前的分析，以及可能的功能发布及其表现的结合。

(00:20:50):
**English:**
The ask is really to create a meta analysis of all of the analysis. So the data person on the strategy working group has to scan the historical archives at the company and sort of synthesize and condense that into a very sort of digestible macro themes and learnings about users. So that's sort of one preparation phase item.

**中文翻译:**
要求是创建一个“分析的元分析”（meta analysis of all analysis）。因此，工作组中的数据人员必须扫描公司的历史档案，将其综合并浓缩成非常易于理解的宏观主题和关于用户的学习心得。这是准备阶段的一个项目。

(00:21:16):
**English:**
The second is UXR insight. So again, there's probably a lot of soft hard signals about users, not just based on research that's run by user researchers, but also potentially from the customer service team, social channels, and basically a meta analysis of all of that into one very actionable and synthesized deck on all the insights on users. That's usually led by the design person and with support from their research team. And that's sort of the second action item.

**中文翻译:**
第二个是 UXR（用户体验研究）洞察。同样，关于用户可能有很多软硬信号，不仅基于研究员的研究，还可能来自客服团队、社交渠道。基本上是将所有这些进行元分析，形成一份关于用户洞察的、非常具有行动导向的综合 PPT。这通常由设计人员主导，研究团队提供支持。

(00:21:53):
**English:**
The third action item is leadership interviews. So I sort of have this fun story of the fruit with leadership strategy reviews, which I want to share. So imagine, this is sort of how sometimes strategy reviews go, which is you bring a fruit to the reviewer and say, "Hey, here's a mango, what do you think?" And the reviewer says, "I actually don't like mangoes." And you're like, "Oh," you're sort of sad. You take it back, you bring an apple and you show, "Hey, what do you think of an apple?" And then the leader says, "I actually stopped eating apples last year." And so you're disappointed again. You go back, you bring a banana. "I hated bananas since I was a kid." And so it's a bit of a silly caricature of reviews, but there's a bit of grain of truth there, which is, imagine how frustrating that is for both the reviewer and the person who's reviewing.

**中文翻译:**
第三个行动项是“领导层访谈”。我有一个关于领导层策略评审的有趣故事，叫“水果的故事”。想象一下，有时策略评审是这样的：你拿一个水果给评审人说：“嘿，这是一个芒果，你觉得怎么样？” 评审人说：“我其实不喜欢芒果。” 你就很沮丧。你拿回去，又拿了一个苹果问：“你觉得苹果怎么样？” 领导说：“我去年开始就不吃苹果了。” 你又失望了。你回去拿了根香蕉，他说：“我从小就讨厌香蕉。” 这虽然是对评审的一种滑稽讽刺，但其中包含了一些真理：想象一下这对评审人和被评审人来说是多么令人沮丧。

(00:22:54):
**English:**
And so it could be made so much better if you just engage with your leaders before you actually build a strategy. It's amazing how few people actually do that. And so the fruit story tells you, hey, imagine if you just asked the reviewer, "Do you even like fruits?" How much better the experience would've been for both parties. And so leadership interviews are a very important part of a strategy formulation process. So you can divide and conquer, there's several leaders, like you assign different leaders to different people on the strategy working group and each of them sort talks to that leader. And there are a few questions that I would recommend asking, and it's basically, what does success feel like for the leader? What does failure look like? What is the measure of success? What are principles to keep in mind while going through this process?

**中文翻译:**
如果你在真正制定策略之前就与领导沟通，情况会好得多。令人惊讶的是，很少有人真的这么做。水果的故事告诉我们：想象一下，如果你先问评审人“你喜欢吃水果吗？”，双方的体验会好多少。因此，领导层访谈是策略制定过程中非常重要的一部分。你可以分而治之，将不同的领导分配给工作组的不同成员去沟通。我建议问几个问题：对领导来说，成功是什么感觉？失败是什么样子？成功的衡量标准是什么？在这个过程中需要记住哪些原则？

---

### [00:23:51] Lenny Rachitsky

**English:**
And these are centered around the product that you're working on?

**中文翻译:**
这些问题是围绕你正在做的产品展开的吗？

---

### [00:23:55] Chandra Janakiraman

**English:**
Exactly.

**中文翻译:**
正是。

---

### [00:24:03] Chandra Janakiraman

**English:**
That's right, yeah. And also I think ask them for their favorite or better ideas. It's actually what I've found through this process is a lot of leaders have these better ideas, they just feel shy to share it because they don't want their teams to think of them as micromanage-y. They want their teams to figure out the answer themselves, but then when you ask them, they actually have a pet idea always. And so asking them just takes the mystery out of it. And it also gives them a creative avenue. So some people feel nervous about engaging senior leaders in these conversations in the sense that, hey, is it a waste of their time? What I've found is the exact opposite, senior leaders are, they welcome this because one, it's actually a more fun conversation for them than the other meetings that they have in their day because they're getting a little bit of their creative juices going, and they actually feel happy that somebody actually asked them what they're feeling and thinking about. And so it's actually very, very positive energy when you ask leaders just what they want. And it's also not a sign of weakness. It's actually a sign of strength and humility to ask your leaders what you want. And so keeping that fruit story in mind, I want to just say that this is a very, very positive thing, a very powerful thing.

**中文翻译:**
没错。而且我认为还要问问他们最喜欢或更好的想法。我发现很多领导其实都有一些“压箱底”的好主意，只是不好意思分享，因为他们不想让团队觉得自己在微观管理（micromanage）。他们希望团队自己找到答案，但当你问他们时，他们总会有一个心仪的想法。所以，问他们可以消除神秘感，也给了他们一个发挥创意的渠道。有些人担心找高层聊这些会浪费他们的时间，但我发现恰恰相反，高层很欢迎这种沟通。首先，这比他们一整天参加的其他会议更有趣，因为这能激发他们的创意；其次，他们很高兴有人真的关心他们的想法。所以，直接问领导想要什么是正能量的体现，这不是软弱，而是力量和谦逊的表现。记住那个水果的故事，这非常有威力。

(00:25:26):
**English:**
The next area is competitive analysis. So if there is a product marketing person, they can do it for you. If there isn't, the PM should do it themselves. And basically the idea is you try to understand who are the comparables or the competitors in the space, and you sort of build a little bit of a head-to-head and sort a stack chart of where's everybody going and what are of the angles of investment for different people based on the explicit signals, which is what are they releasing? You don't really know what their strategies are, but you can kind of tell when you look at the features they're putting out that, oh, they seem to be focusing on this particular area. And so that's sort of competitive analysis.

**中文翻译:**
下一个领域是“竞品分析”。如果有产品市场人员，可以让他们做；如果没有，PM 应该亲自做。基本上就是了解该领域的同类产品或竞争对手，建立一个对比图表，看看大家都在往哪里走，根据他们发布的显性信号（即发布的功能）来判断他们的投资角度。你虽然不知道他们的具体策略，但通过他们推出的功能，你可以看出他们似乎在关注某个特定领域。

(00:26:33):
**English:**
And bigger companies, there's also another important input, which is adjacent roadmaps. Are the teams adjacent to you and what are they investing in? Because oftentimes that can have a rub-off effect on your team, and if you're not aligning with other key teams, it's going to be important. So adjacent roadmaps and a summary of that. And last but not least, is what I call user observation. So I like the strategy working group to actually either interview a user or watch a video and report key learnings. And the idea is not to action those insights, it's really to build empathy. When you get somebody in the room with a user, it just changes their mind, it softens them a little bit. It gets them out of their own preconceived notions of what to build, what the strategy should be and it humanizes the whole process. That I think is the purpose, but you still give them the homework of writing down what they learned because it's a little bit of a forcing function.

**中文翻译:**
在大型公司，还有一个重要的输入，即“相邻路线图”。你旁边的团队在投资什么？因为这往往会对你的团队产生溢出效应。如果你不与其他关键团队保持一致，就会出问题。最后但同样重要的是我称之为“用户观察”的环节。我喜欢让策略工作组的成员亲自访谈用户或观看视频，并报告核心心得。目的不是为了立刻执行这些洞察，而是为了建立同理心。当团队成员与用户待在一个房间里时，这会改变他们的想法，让他们变得柔软一些，摆脱对“该建什么”或“策略该是什么”的固有成见，让整个过程更具人性化。这就是目的，但你还是要给他们布置作业，让他们写下所学到的东西，这是一种强制性的思考。

(00:27:16):
**English:**
The output of all of this is what I call the comprehensive preparation readout. It is a single master deck where you sort of have the behavioral insights meta analysis, you have the UXR insights meta analysis, you have a download of the leadership interviews, you have the competitive stack charts, you have the adjacent roadmaps, and you have a section on user observations. It's a lot of work, but to your point, it can be done in parallel with your day jobs. You can multitask, and that's why you take about four weeks to do that. That sort of concludes the preparation phase. You get the deck, and that rolls into the strategy sprint, which is the next phase. I want to pause and see if you have any questions.

**中文翻译:**
所有这些工作的产出就是我所说的“综合准备报告”（comprehensive preparation readout）。这是一份主 PPT，包含行为洞察元分析、UXR 洞察元分析、领导层访谈记录、竞品对比图、相邻路线图以及用户观察部分。工作量很大，但正如你所说，这可以与日常工作并行。你可以多任务处理，这就是为什么需要大约四周的时间。准备阶段到此结束，你拿到这份 PPT，然后进入下一阶段：策略冲刺。我想停一下，看看你有没有什么问题。

---

### [00:28:06] Lenny Rachitsky

**English:**
Yeah, I have a million questions, but I'm going to keep myself contained. Just to quickly summarize. Basically you kick off, we're going to start developing strategy for this product, and you were going to touch on this, but it may help just to talk about this right now. I know you have big S Strategy, small S strategy. This process, what's an example of the level of product scale that this process is for? Because I know you have another approach for a larger scale of a product, basically for a company. What's the best way to think about small S strategy, which is what we're going through?

**中文翻译:**
我有无数个问题，但我先克制一下。简单总结一下：基本上你启动了，我们要为这个产品开发策略。你刚才提到了，但现在谈谈可能更有帮助：我知道你有“大写 S”和“小写 s”策略。这个流程适用于什么规模的产品？因为我知道你对更大规模的产品（比如整个公司）有另一种方法。我们正在讨论的“小写 s 策略”，最好的理解方式是什么？

---

### [00:28:37] Chandra Janakiraman

**English:**
Yeah, I think it's a good question, Lenny. I would say that the process works well at sort of a growth stage company or in a vertical within sort of a larger company. I think it scales pretty well. The main difference between this small S and big S is the time horizon aspect and the aspirational component, which we'll get to.

**中文翻译:**
好问题，Lenny。我会说这个流程在成长型公司或大公司内部的一个垂直领域运作得很好。它的扩展性不错。小写 s 和大写 S 之间的主要区别在于“时间跨度”和“愿景成分”，我们稍后会谈到。

---

### [00:29:02] Lenny Rachitsky

**English:**
Okay, so this is a process you can use for entire company strategy of not a large company, not a massively, and then also just a product within a company?

**中文翻译:**
所以这是一个可以用于非巨型公司的整体公司策略，也可以用于公司内部某个产品的流程？

---

### [00:29:11] Chandra Janakiraman

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:29:11] Lenny Rachitsky

**English:**
Okay, perfect. Okay. Hey, we're kicking off strategy for this thing. Let's say VR Chat 2.0. You have this kickoff meeting with your working group. You assign action items and there's six things you ask everyone to do. Gather all the behavioral insights, all the user research insights that you've had, leadership interviews, interview people, ask what they want and see what they're hoping for, what success looks like, competitive analysis, adjacent roadmaps across other teams and user observations, just like watch users, see what's happening. You assign each of these tasks to different people in this working group. You set a deadline. We have to present this in say, four weeks. People go work on it. You meet ongoing as it's coming together, and then the output is a deck that you share. Do you share this deck with just that working group, or who do you share this deck with and read it out to?

**中文翻译:**
太好了。假设我们要为 VRChat 2.0 启动策略。你召开了工作组启动会，分配了六项任务：收集行为洞察、用户研究洞察、进行领导层访谈（问他们想要什么、成功是什么样子）、竞品分析、相邻团队路线图以及用户观察。你把这些任务分配给不同的人，设定四周后的截止日期。大家开始工作，期间不断开会汇总，最后产出一份 PPT。这份 PPT 是只在工作组内分享，还是会向其他人汇报？

---

### [00:30:02] Chandra Janakiraman

**English:**
Yeah. The deck is an output of the first phase, and then it flows into the second phase, which is a strategy sprint. You don't share the deck with anybody yet.

**中文翻译:**
这份 PPT 是第一阶段的产出，然后它会进入第二阶段：策略冲刺。目前还不向其他人分享。

---

### [00:30:10] Lenny Rachitsky

**English:**
Got it. This is our secret.

**中文翻译:**
明白了，这是我们的秘密。

---

### [00:30:11] Chandra Janakiraman

**English:**
In the strategy sprint, it's like a key thing. Yeah.

**中文翻译:**
在策略冲刺中，它是关键输入。

---

### [00:30:13] Lenny Rachitsky

**English:**
Awesome. I love how very concrete and actionable this is with time boxes and action items and the exact output you're looking for. I love this. Okay, cool. Basically what you're trying to do here is gather all of the input that will inform the strategy. It's giving yourself time to do this, because if you think about it, the output is determined by the quality of your input. I love, it feels like a core component of this method is spend time creating, gathering all the input, all the best input, actually spend time there. Don't just make it a half-assed last minute thing. Okay. Amazing. Okay, let's talk about step two, which is the strategy sprint.

**中文翻译:**
太棒了。我喜欢这种非常具体、可操作的方法，有时间限制、行动项和明确的产出。基本上你在这里做的是收集所有将影响策略的输入。给自己时间去做这件事，因为产出的质量取决于输入的质量。我非常认同这一点：花时间去创造和收集最好的输入。不要只是在最后一刻草草了事。好，那我们来谈谈第二步：策略冲刺。

---

### [00:30:52] Chandra Janakiraman

**English:**
Yeah, so the strategy sprint is the heart of the process. This is sort of where you make the decision. If you recall, the definition of strategy is it forces choice to deploy resources into a few areas for maximum impact. The core of strategy is really picking those areas and the areas you're not going invest in. That happens in the strategy sprint, so really it's the heart of the process. Typically, it's like a three to five day process. The first day is the share out date. Everybody has done some great work. They go in, they share what they've collected, what they've sort of learned. It brings everybody in the working group to the same state of understanding, the same state of consciousness on the state of the union. That's a great process where what I encourage people to do is write down things that you are, as you're listening, write down things that you find are problems for our users, things that are coming in the way of our growth and things that are sort of suboptimal for the business.

**中文翻译:**
策略冲刺是整个流程的核心。这是你做决定的地方。如果你还记得策略的定义：强制做出选择，将资源投入少数领域以产生最大影响。策略的核心就是挑选这些领域，以及决定哪些领域不投资。这发生在策略冲刺中。通常这是一个 3 到 5 天的过程。第一天是“分享日”。大家展示之前收集和学到的东西。这让工作组的每个人对现状达成共识。在这个过程中，我鼓励大家在听的时候记下：你认为哪些是用户的问题？哪些阻碍了我们的增长？哪些对业务来说是不理想的？

(00:32:05):
**English:**
People take a lot of notes during that time and the people who are presenting are sharing everything they've learned. That's really day one. It's just absorbing a ton of information and writing down a ton of notes so people can kind of understand where all the problems are. It's a very problems focused process, and that's an important point. I'll get back to it when we talk about big S, which is different. Once people have that common awareness, shared knowledge of all the problems, day two is literally the most important day in the entire 8 to 12 weeks because that's where you actually make the choice. The way to flow through it, it's actually really important to flow through it correctly. The first step is really generating a whole bunch of problems, because people have been taking notes the previous day.

**中文翻译:**
大家会记很多笔记，演示者会分享他们学到的一切。这就是第一天：吸收大量信息并记录笔记，以便大家了解问题所在。这是一个非常关注“问题”的过程，这一点很重要，谈到大写 S 战略时会有所不同。一旦大家对所有问题有了共同的认知，第二天就是整个 8 到 12 周中最重要的一天，因为你要在这一天做出选择。正确地推进流程非常重要。第一步是产生一大堆问题，因为大家前一天已经记了笔记。

(00:32:59):
**English:**
You start the day with, "Hey, let's collect everybody's thoughts on what the problems are that are holding us back." It's a free flowing session. Everybody throws out their observations on what's holding us back, and you just capture all of that in a Google Sheets, for example. Over even an hour, you start to see these patterns emerging of like, there's these clusters of problems that are really holding us back. The next step is you do a joint clustering of related problems and you create these potentially, typically in my experience, I've seen about 10 to 15 clusters form of very related problems. The beauty of it is each of those bigger cluster, you actually know what the sub problems are within that cluster because you sort of generated it very organically.

**中文翻译:**
你以“嘿，让我们收集一下大家认为阻碍我们发展的问题”开始这一天。这是一个自由讨论环节。每个人都抛出他们的观察，你把这些记录在 Google 表格里。哪怕只过一个小时，你就会看到模式开始出现：有些问题是成簇出现的。下一步是共同对相关问题进行“聚类”（clustering）。根据我的经验，通常会形成 10 到 15 个相关问题的集群。妙处在于，对于每个大集群，你都清楚其中的子问题是什么，因为它们是自然生成的。

(00:33:55):
**English:**
Then you have, let's say 10 to 15 clusters. What you then do is you, because remember, because it started as a problem generation exercise, each of the clusters also has a name that is a problem, and so the next step is to flip it into an opportunity framing. Let me give you a couple of examples. Let's say there's a bunch of problems around people don't really know where to find different things in our product, and they don't really know where to go, where to find a certain feature or a certain experience. There's let's say a lot of problems in that area, so difficulty finding things becomes the cluster, the problem cluster and discovery becomes the opportunity sort of framing of it. It's sort of the more positive framing of it.

**中文翻译:**
假设你有 10 到 15 个集群。接下来你要做的是——记住，因为这是从“产生问题”开始的，每个集群的名字都是一个问题——所以下一步是将其转化为“机会框架”（opportunity framing）。举个例子：假设有一堆问题是关于用户不知道在产品中哪里可以找到东西，或者不知道去哪里找某个功能。那么“寻找困难”就是问题集群，而“发现性”（Discovery）就是它的机会框架。这是一种更积极的表述方式。

(00:34:46):
**English:**
Another example could be that people get a lot of content that they don't like. They see a lot of stuff that they don't like, and so they disengage with the product. The opportunity framing of that would be relevance. It's basically stuff that really matters to me. Maybe if it's a social product, then maybe people are finding it difficult to find friends and they are lonely because of that. The opportunity framing would be social connection. Flipping all of those problem clusters into positive framing and opportunity framing is the next step. Then you're in a great spot because now all you have to do is you have to down select from those 10 to 15 opportunity areas into ideally three, maybe five, but I would recommend three because it creates more clarity and focus. The way to do that is really sort of ranking them on, I would say four or five key dimensions or criteria, and the first is expected impact.

**中文翻译:**
另一个例子：人们收到了很多他们不喜欢的内容，导致他们不再使用产品。那么机会框架就是“相关性”（Relevance），即真正对用户重要的东西。如果是社交产品，人们觉得很难交到朋友，感到孤独，那么机会框架就是“社交连接”（Social Connection）。将所有问题集群转化为积极的机会框架是下一步。然后你就处于一个很好的位置，因为现在你只需要从这 10 到 15 个机会领域中筛选出理想的 3 个（也许 5 个，但我建议 3 个，因为这能带来更清晰的焦点）。筛选的方法是根据四个或五个关键维度进行排名。第一个是“预期影响”（Expected Impact）。

(00:35:56):
**English:**
Let's say you actually tackle that area. What is the expected impact to whatever matters to you as a company, as a business, as a product? The second dimension is certainty of impact. Certainty of impact is basically how concrete is the evidence that this is a problem? Sometimes you have really hard data, sometimes you have more anecdotal evidence, and so the confidence really depends on how big the problem's sizing and frequency is. Expected impact, certainty of impact. The third one is also very important, which is clarity of levers. Do you actually have an idea of how you would solve it? If you don't, it's going to be really difficult to move the needle on it because you should kind of know that, okay, I can imagine these solutions could actually move the needle. I can actually launch this sort of nudge system that can help people find things. I can recommend people. I can recommend friends so that people can form friends quicker on the platform. You should have a sense of how you would solve that particular space. Is there clarity on levers? That's the third dimension.

**中文翻译:**
假设你真的解决了那个领域，对公司、业务或产品最重要的指标会有什么预期影响？第二个维度是“影响的确定性”（Certainty of Impact），即证明这是一个问题的证据有多具体？有时你有硬数据，有时只有轶事证据。信心取决于问题的规模和频率。第三个非常重要，即“杠杆的清晰度”（Clarity of Levers）。你真的知道该如何解决它吗？如果你不知道，就很难取得进展。你应该能想象出一些解决方案，比如推出某种引导系统帮助用户找东西，或者推荐好友。你应该对如何解决那个特定领域有感觉。这就是第三个维度。

(00:37:08):
**English:**
The fourth dimension is super important, which is are the levers unique and differentiated to that particular team or company? Which is that if another team or company could build it better than this particular team or company, then it's probably not that differentiated. It's probably going to be pretty generic once you launch it. It's a combination of sort of like, is there a lot of impact here? How confident are we of the problem? Do we have a sense of the solutions? And basically, are we the team or company that has the capabilities and the skills to uniquely build it where other teams cannot? Once you have that, and sometimes what happens is you don't have too much data, and so it's okay to have qualitative scores on this like high, medium, low, T-shirt scores, whatever that is. The key is you're doing it together as a strategy working group, and you're debating the scores and you're reasoning why it should be higher versus lower. There's a ton of alignment and collision that's happening when you're doing that, which is very healthy for the eventual outcome. Once you do that, basically you can do a simple sort of addition of the scores and a sort, and what you have is basically the top three and you have the remaining 7 or 12 that are basically not the focus. That's the core of the process, is getting those opportunity areas and getting to a shared sense of how do we prioritize them and why?

**中文翻译:**
第四个维度超级重要：这些杠杆对该团队或公司来说是否具有“唯一性和差异化”？如果其他团队或公司能比你们做得更好，那么它可能就不具备差异化，发布后会显得很平庸。所以这是综合考量：影响大吗？对问题的信心足吗？对解决方案有感觉吗？最重要的是，我们是否拥有独特的能力和技能来构建它，而其他团队做不到？一旦你有了这些，即使没有太多数据，也可以使用定性评分（如高、中、低）。关键是策略工作组一起做这件事，辩论分数，解释为什么高或低。在这个过程中会发生大量的共识达成和观点碰撞，这对最终结果非常健康。完成后，简单加分排序，你就得到了前三名，剩下的 7 到 12 个就是明确不作为重点的。这就是流程的核心：确定机会领域，并对如何排序以及为什么排序达成共识。

---

### [00:38:51] Lenny Rachitsky

**English:**
Okay, and this is all done in a week. I know there's more to it. There's a couple more items that help you move from what you just said to the next step, but I love that this is the core of the biggest element of the process, and you do it in a week and you're only able to do it in a week because of the work you did ahead of time. Again, highlighting the importance of that prep step. Just to share what you've shared so far, and then we'll finish the strategy sprint step. It's basically do the share out so everyone's on the same page about all the information that, all the inputs essentially. Enumerate all the problems, like individual small problems and then cluster them into 10 to 15 problem clusters. Flip it from here's the problem to here's an opportunity we have. Rank them based on, basically there's these four attributes you shared, which I'll actually, I wrote these down. Impact potential, confidence that it will have the impact, clarity of levers and are they differentiated unique levers? Is there something different from what other folks are doing? Those are ways to rank these ideas and problem clusters. You essentially come up with, here's three bets basically we potentially should take. Okay, and then I think that's where you stopped. Is that right?

**中文翻译:**
好，这些都在一周内完成。我知道还有后续，但我很喜欢这是流程中最核心的部分。你能在一周内完成，是因为你提前做了准备工作。再次强调了准备步骤的重要性。总结一下你目前分享的：分享信息让大家达成共识；列举所有小问题并聚类成 10 到 15 个集群；将问题转化为机会；根据四个属性（潜力影响、信心、杠杆清晰度、差异化杠杆）进行排名。最后选出三个我们要投的“赌注”。到这里没错吧？

---

### [00:40:03] Chandra Janakiraman

**English:**
That's totally right, Lenny. Those three that are at the top of that pile are basically our strategic pillars. We've sort of gotten our strategic pillars and they basically hold up the strategy. That's why they're called strategic pillars. The idea is once you have the strategic pillars, we basically translate that into a few how might we's? Let's say it's a relevance thing. How might we find the best content for a particular user? How might we surface it in the right place? There's a few how might we's, and the how might we's are basically intended to help the next phase of the process, which is the design sprint. You generate these areas, these strategic pillars, you generate the how might we's. How might we's are typically pretty straightforward. Once you have the strategic pillars, it takes probably an hour to generate some how might we's for each of them, maybe two or three for each strategic pillar, and then you're done with that stage.

**中文翻译:**
完全正确，Lenny。排在最前面的那三个就是我们的“战略支柱”。它们支撑着整个策略。一旦有了战略支柱，我们就把它们转化为几个“我们该如何”（How Might We，简称 HMW）的问题。比如关于相关性：我们该如何为特定用户找到最好的内容？我们该如何将其展示在正确的地方？这些 HMW 问题旨在帮助下一阶段：设计冲刺。一旦有了战略支柱，生成 HMW 通常很快，每个支柱大概花一小时生成两三个，这一阶段就完成了。

---

### [00:41:00] Lenny Rachitsky

**English:**
I just want to highlight real quick, this phrasing is really important. I used exactly the same phrasing. I had a PM that I worked with and his name was Andrew Chen, but not the Andrew Chen people know about, that's an investor, who had this concept of fertile questions that create ideas and spark ideas and solutions. This phrase, "How might we", is actually really powerful as a way to come up with ideas to solve problems. It's just like, how might we increase discoverability in our app? How might we improve relevance? There's something magical about that phrasing that it opens up your mind to, how might we? Let's think about it. Versus like, how do we improve discovery? That's a different, your brain works differently hearing this. That is a really powerful phrasing. Just wanted to highlight that.

**中文翻译:**
我想快速强调一下，“我们该如何”（How Might We）这个措辞非常重要。我曾和一位叫 Andrew Chen 的 PM 共事过（不是那位著名的投资人），他有一个“肥沃的问题”的概念，能激发创意和解决方案。“我们该如何”这种问法在解决问题时非常有威力。比如“我们该如何增加 App 的可发现性？” 这种问法有一种魔力，它能打开你的思维，让你去思考可能性。相比之下，“我们如何改进发现功能？” 听起来大脑的反应是不同的。我想特别指出这一点。

---

### [00:41:47] Chandra Janakiraman

**English:**
Yeah, that's awesome. It's also something that designers are familiar with, Lenny, so it flows really well into sort of a design sprint.

**中文翻译:**
是的，太棒了。这也是设计师们非常熟悉的语言，所以它能非常顺畅地过渡到设计冲刺阶段。

---

### [00:41:56] Lenny Rachitsky

**English:**
Okay, so you have these how might we'd. You have three pillars, maybe three or four or five how might we's to solve these opportunities/problems, and then what happens after that?

**中文翻译:**
好，你有了这些 HMW 问题，有了三个支柱，每个支柱有三到五个 HMW 来解决这些机会/问题。接下来呢？

---

### [00:42:06] Chandra Janakiraman

**English:**
Exactly. Then the third day is it's good to start fresh. The team's accomplished a lot. This is the first two days, yeah. The second day is particularly intense on the team, so it's good to give them a break, because it's a lot of really mental sort of wrestling, and so give the team a bit of a break. Then the third day is when people are a little bit refreshed, we get to winning aspiration. Winning aspiration is super interesting because it's a very creative exercise. You basically imagine in two years, because that's the typical time horizon of a smaller strategy, is like 18 months to 24 months. This is what I tell the team. Imagine two years there's a newspaper, there's a journalist that covers this work, and there's a newspaper article that comes out. I want you to imagine the progress on all these strategic pillars and what the headline of that newspaper article looks like. It's called a newspaper headline approach.

**中文翻译:**
没错。第三天最好有个全新的开始。团队已经完成了很多工作。前两天非常辛苦，特别是第二天，团队进行了大量的脑力博弈，所以给他们一点休息时间。第三天，当大家恢复精力后，我们进入“胜出抱负”（Winning Aspiration）环节。这非常有趣，因为这是一个极具创意的练习。你想象两年后（因为小写 s 策略的典型时间跨度是 18 到 24 个月），我告诉团队：想象两年后，有一家报纸，有一位记者报道了我们的工作，出了一篇报道。我希望你们想象一下这些战略支柱取得进展后，报纸的头条新闻会是什么样子。这被称为“报纸头条法”。

(00:43:09):
**English:**
Basically, everybody generates a newspaper headline in parallel. It's interesting because you often see there's these common themes that sort of form when people generate these headlines. The forcing function with the headline is also that it has to be somewhat simple and plain speak. It's not too technical. You have to get to a more simple layperson's language and you have to get to the key benefit that ultimately, the impact it has on the world. Those kinds of themes come up often. Then you do a little bit, you put them all into a blender, you put all of those headlines from the team into a blender, and you mash them together and create the winning aspiration, which is ultimately what does progress on the strategy look like in a couple of years time? That comes from the working group, it's not like one person writing.

**中文翻译:**
基本上，每个人都会并行生成一个报纸头条。有趣的是，你会发现大家生成的头条往往有共同的主题。头条的强制性要求是它必须简单易懂，不能太技术化。你必须使用外行也能听懂的语言，并直指最终给世界带来的核心利益。这些主题经常出现。然后你把团队所有的头条放进“搅拌机”里，把它们融合在一起，创造出“胜出抱负”——即两年后策略取得进展时的样子。这是由工作组共同完成的，而不是某个人独自撰写的。

---

### [00:44:09] Lenny Rachitsky

**English:**
What's an example of an aspiration that you've come up with on a project you worked on, a winning aspiration?

**中文翻译:**
你能举个例子吗？在你参与过的项目中，什么样的描述算是一个“胜出抱负”？

---

### [00:44:14] Chandra Janakiraman

**English:**
We did this process for the privacy team when I was at Meta. Really the strategic pillars were around a lot of features that we would build, but the winning aspiration was really like, could we move consumer trust? The newspaper headline is something like, "Facebook has moved the needle on consumer trust by investing in these areas." That's how you create the bigger impact.

**中文翻译:**
我在 Meta 时为隐私团队做过这个流程。战略支柱围绕着我们要构建的功能，但胜出抱负是：我们能否提升消费者的信任？报纸头条大概是：“Facebook 通过在这些领域的投资，显著提升了消费者的信任度。” 这就是你创造更大影响力的方式。

---

### [00:44:47] Lenny Rachitsky

**English:**
That's a great example. Obviously this is similar to the PR Amazon method and what I love about your approach, as you said early on, is you're just pulling together all of these awesome ideas from all these different methods of strategy work to a very methodical step-by-step process. Taking all the best ideas into, and as you described, an operator's playbook for doing this. I love that. Okay. When you say blender, by the way, I was thinking as you were talking, put them into a blender, what I'm inferring is you just take everyone's headlines and you come up with one that kind of covers the gamut of all three pillars being successful.

**中文翻译:**
这是一个很好的例子。显然这与亚马逊的 PR/FAQ 方法类似。我喜欢你的方法的一点是，正如你开头所说，你把各种策略方法的精华整合进了一个非常有条理的、循序渐进的流程中。这就是你所说的“执行者剧本”。关于“搅拌机”，我的理解是你把大家的头条拿过来，合成一个能涵盖所有三个支柱成功后的愿景。

---

### [00:45:20] Chandra Janakiraman

**English:**
That's exactly right. More tactically what I typically do is I put them all on a slide and start, it's almost like a word cloud, and then you start to see these common words. Then you converge those words as the key elements of the final winning aspiration. Then you try to create a nice statement out of that. It also symbolically, everybody sees their own statement on the deck, and that's how you get to the final model.

**中文翻译:**
完全正确。在战术上，我通常把它们都放在一张幻灯片上，就像词云一样，你会看到共同的词汇。然后把这些词作为最终胜出抱负的关键元素，并以此写出一个漂亮的陈述。象征性地，每个人都能在 PPT 上看到自己的影子，这就是最终模型的形成过程。

---

### [00:45:46] Lenny Rachitsky

**English:**
Awesome. I feel like AI could help with that now.

**中文翻译:**
太棒了。我觉得现在 AI 可以帮上忙。

---

### [00:45:46] Chandra Janakiraman

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:45:48] Lenny Rachitsky

**English:**
Just put in all your headline ideas and it comes up with some suggestions. Okay, cool. Is that the end of the sprint or is there more to the sprint?

**中文翻译:**
把所有头条想法丢进去，它就能给出建议。好，冲刺到这里就结束了吗？还是还有后续？

---

### [00:45:55] Chandra Janakiraman

**English:**
That's it for the sprint.

**中文翻译:**
冲刺部分就到此为止。

---

### [00:45:57] Lenny Rachitsky

**English:**
Okay. At the end of the sprint, what do you have? What are the outputs?

**中文翻译:**
好。在冲刺结束时，你手里有什么？产出是什么？

---

### [00:46:00] Chandra Janakiraman

**English:**
Yeah, this is a great progress on strategy because now we have the three strategic pillars. We have the how might we associate it with the strategic pillars. You also have the why. Why did you get to those three strategic pillars and what are you not focused on and what are the reasons for it? You also have the winning aspiration. It's great progress. The team's done a great job. I think now we sort of move on to the design sprint.

**中文翻译:**
这是策略上的重大进展：现在我们有了三个战略支柱，有了与支柱相关的 HMW 问题。你还有了“为什么”——为什么选择这三个支柱，哪些不是重点，原因是什么。你还有了胜出抱负。这是巨大的进步，团队做得很好。接下来我们进入设计冲刺。

---

### [00:46:30] Lenny Rachitsky

**English:**
In your experience, how often are these three the correct three that you end up going with versus you learn something over the course of the rest of the sprint and adjust?

**中文翻译:**
根据你的经验，这三个最终被证明是正确的概率有多大？你会不会在后续过程中学到新东西并进行调整？

---

### [00:46:38] Chandra Janakiraman

**English:**
It's a very good question. We'll speak about an example that I had in Meta where typically during the strategy sprint, you don't change it once you go through the strategy sprint, but eventually there are a lot of signals you get through execution where you sort of have to course correct. We'll talk about one very interesting example of how that sort of changed things here.

**中文翻译:**
问得好。我会讲一个我在 Meta 的例子。通常在策略冲刺期间，一旦确定就不会更改，但最终在执行过程中你会收到很多信号，迫使你修正航向。我们会聊到一个非常有趣的例子，说明情况是如何发生变化的。

---

### [00:47:01] Lenny Rachitsky

**English:**
Awesome. Okay. Basically, you've developed your strategy at this point, and in your experience it ends up being... Until you hit the market and test, you don't really know what's going on. But there's kind of an implication that in your experience doing this, I think you said five or six times, it has been correct and as good as doing it any other approach.

**中文翻译:**
太棒了。基本上到这一步你已经制定了策略。根据你的经验，在进入市场测试之前，你无法真正知道结果。但暗示的意思是，在你做过的五六次尝试中，这种方法得出的结果是正确的，且不亚于任何其他方法。

---

### [00:47:21] Chandra Janakiraman

**English:**
I would say it's not sort of an empirical study, obviously because of the small sample size, but I would say that it's really opened people's eyes and it's led to really good alignment and eventually good results. Even when it has not, it has led to good organizational buy-in on why and how we are approaching things.

**中文翻译:**
由于样本量较小，这显然不是一项实证研究。但我会说，它确实让人们眼前一亮，带来了极好的共识达成，并最终取得了良好的结果。即使结果不如预期，它也让组织内部对“为什么”和“如何做”达成了高度认同。

---

### [00:47:42] Lenny Rachitsky

**English:**
This reminds me of, Tomer Cohen was on the podcast, he's CPO of LinkedIn and he has this phrase that always says he says, which is, "We may be wrong, but we're not confused." I love that a core part of this is everyone is completely on the same page, not from the beginning, but once you start this process of here's all the inputs, here's step by step we are working together on narrowing down, so at least everyone understands the why. Which is what sparked your interest in this in the first place, everyone understanding. I know there's a whole rollout at the end too to solve that. Okay, cool, so we have the sprint. We have basically the three pillars that you're going to invest in, this headline of what it might look like if you're to launch and some solution ideas with how might we's. What comes next?

**中文翻译:**
这让我想起 LinkedIn 的 CPO Tomer Cohen 在播客里说过的一句话：“我们可能会错，但我们并不困惑。” 我喜欢这种核心部分：每个人都完全步调一致。不是从一开始就一致，而是通过这个过程——从输入到一步步缩小范围——至少每个人都理解了“为什么”。这正是最初激发你兴趣的原因。好，冲刺结束了，我们有了三个支柱、头条愿景和 HMW 方案。接下来是什么？

---

### [00:48:26] Chandra Janakiraman

**English:**
Yeah. The next phase is the design sprint, and the design sprint can be led by the design person who's in the strategy working group. If you remember, there's engineering, product design and data, so the design person can lead it and the PM can sort of take a bit of a backseat during this process. The input to the design sprint is sort of the three strategic pillars and the how might we's associated with it. The goal of the design sprint is not to sort of come up with these are the features we should build. That's not the purpose of the design sprint. The design sprint is to generate a lot of illustrative concepts that bring the strategy to life because a picture is worth a thousand words. Oftentimes, even though you might have the right words in your strategy doc, people might still scratch their head like, "What do you exactly mean? What are you going to build?" The illustrative concepts really sort of give people something to latch onto, "Oh, okay, I get it. This is what you're going to build at the end of the day with this strategy."

**中文翻译:**
下一阶段是“设计冲刺”。设计冲刺可以由工作组中的设计负责人主导。PM 在这个过程中可以退居二线。设计冲刺的输入是那三个战略支柱和相关的 HMW 问题。设计冲刺的目标不是确定“我们要构建哪些功能”，那不是它的目的。它的目的是生成大量的“说明性概念”（illustrative concepts），让策略变得鲜活，因为百闻不如一见。通常即使策略文档写得很完美，人们还是会纳闷：“你到底是什么意思？你要建什么？” 说明性概念能让人们有所依凭：“噢，我明白了，这就是你们最终要通过这个策略实现的东西。”

(00:49:25):
**English:**
The more generative, the better. Then there's the ability to, sometimes if you do the Google Ventures design sprint, you can even test some of it with users and get a little bit of sharpening of things. The goal here is not to build feature-ready designs, it's more to generate concepts. Once you have that, basically the design sprint, and there's different flavors of design sprints, which I won't go into. You can lean on your design lead to decide what's the appropriate way, but the input and the output is what needs to be very emphasized. The input needs to be the strategic pillars. The output needs to be a ton of illustrative concepts to explain each strategic pillar. You could almost have a section where you talk about each strategic pillar and insert those concepts in that section. That's the idea.

**中文翻译:**
越具生成性越好。如果你采用 Google Ventures 的设计冲刺方法，你甚至可以找用户测试，进一步打磨。这里的目标不是做出可以直接开发的设计稿，而是生成概念。你可以依靠你的设计负责人来决定具体方式，但必须强调输入和产出：输入是战略支柱，产出是解释每个支柱的大量说明性概念。你可以在文档中讨论每个支柱时插入这些概念图。这就是核心思路。

---

### [00:50:16] Lenny Rachitsky

**English:**
We're going to go through a couple examples to make this very real. You mentioned the design sprint method, which we had the authors on the podcast. They actually didn't go through the design sprint method. They have another book called Make Time that's about productivity. We also had their colleague from Google Ventures that designed a bullseye sprint, which is also an interesting sprint. It's a new thing that helps you figure out your ICP and who to focus your product on and how that informs your product.

**中文翻译:**
我们会通过几个例子让它变得更真实。你提到了设计冲刺方法，我们也请过该书的作者上节目。他们其实没细讲设计冲刺，而是讲了另一本关于生产力的书《创造时间》（Make Time）。我们还请过他们在 Google Ventures 的同事，他设计了“靶心冲刺”（bullseye sprint），这能帮你确定理想客户画像（ICP）以及产品重点。

---

### [00:51:00] Lenny Rachitsky

**English:**
The input is here's the three things we're going to invest in, say discovery, relevance, privacy. The output is here's concepts of what this could look like to get people's minds going. Is it just a bunch of mocks basically in a deck at this point?

**中文翻译:**
所以输入是我们要投资的三件事（比如发现、相关性、隐私），产出是让人们脑洞大开的概念图。到这一步，产出基本上就是 PPT 里的一堆原型图（mocks）吗？

---

### [00:51:00] Chandra Janakiraman

**English:**
That's correct. Yeah.

**中文翻译:**
没错。

---

### [00:51:01] Lenny Rachitsky

**English:**
Okay, cool. Okay, amazing. That's a week. That's another sprint. PM could maybe take a little bit of a break. And designers take the lead. The engineers are kind of inputs and thought partners in this, I imagine.

**中文翻译:**
好，又是一周。这是另一个冲刺。PM 可以稍微休息一下，设计师主导。我猜工程师在其中扮演输入者和思考伙伴的角色。

---

### [00:51:13] Chandra Janakiraman

**English:**
They're optional. Yeah.

**中文翻译:**
他们是可选的。

---

### [00:51:15] Lenny Rachitsky

**English:**
Optional, but yeah, ideally they're involved because you want all the best ideas in there. Okay, cool. What comes next?

**中文翻译:**
可选，但理想情况下应该参与，因为你想要最好的点子。好，下一步呢？

---

### [00:51:21] Chandra Janakiraman

**English:**
Then the next step is the document writing. This is sort of a solo activity that the PM should take on, but the great news is the PM is not starting from scratch. There's so much great stuff to write. If you remember, there's a ton of user insights, a ton of behavioral insights, a ton of competitive analysis. There's the three strategic pillars, how might we's, winning aspiration. There's a whole bunch of illustrative concepts. Oftentimes, product leads have this sort of creator's block. That is solved here completely because you have a ton of great material. I have to tell you, it doesn't make the job easier. You still have to weave together a good story. That's why I think it takes a week or two. I think it's really about combining, connecting and editing at this point and telling a cohesive story from all those components, but I think the building blocks are really solid and defensible.

**中文翻译:**
下一步是“文档撰写”。这通常是 PM 独立完成的任务。好消息是 PM 并非从零开始，已经有太多素材可以写了：用户洞察、行为洞察、竞品分析、三个战略支柱、HMW 问题、胜出抱负，还有一堆说明性概念。通常产品负责人会有“创作瓶颈”，但在这里完全解决了，因为你有大量素材。不过，这并不意味着工作变简单了，你仍需编织一个好故事。这就是为什么需要一两周时间。现在的重点是组合、连接和编辑，将所有组件讲成一个连贯的故事。这些构建块非常扎实且经得起推敲。

---

### [00:52:17] Lenny Rachitsky

**English:**
Is there a template or kind of sections you like to include in your strategy doc? As someone sits down and is trying to write this out, what do you want to see there as headings?

**中文翻译:**
有没有你喜欢的模板或章节？当有人坐下来写这份文档时，你希望看到哪些标题？

---

### [00:52:26] Chandra Janakiraman

**English:**
I think you could almost take the building blocks as a little bit of a steer for the template. You start with the broader context where you talk about what the leaders kind of want from this overall effort. Then you get into key insights and analysis where you have user insights, behavioral insights, competitive analysis. Then you get into the strategic pillars and you explain them. You also explain why. In the appendix, you include the full table that you generated on day two of your strategy sprint. You include the full table in the appendix, including the criteria. That's going to be really important because most people are going to ask, "Why did you pick these?" That's basically sort of the defensibility.

**中文翻译:**
你可以直接把之前的构建块作为模板的引导。首先是“宏观背景”，谈谈领导层对这项工作的期望。然后是“关键洞察与分析”，包括用户、行为和竞品分析。接着是“战略支柱”及其解释，还要解释“为什么”。在附录中，放入你在策略冲刺第二天生成的完整表格，包括评分标准。这非常重要，因为大多数人会问：“为什么选这些？” 这就是你的防御依据。

(00:53:17):
**English:**
Then you have the winning aspiration that's very bold. It's a big part of the heart of the deck, and you sort of embed the illustrative concepts into the actual each of the strategic pillars so that it flows well. Then finally, you end with some kind of alignment questions like, "Hey, do these feel right? Are there things we are missing?" So that it creates that framework for alignment in the subsequent meetings.

**中文翻译:**
然后是那个非常大胆的“胜出抱负”。它是 PPT 的核心部分。你把说明性概念嵌入到每个战略支柱中，使其流程顺畅。最后，以一些“共识达成问题”结束，比如：“这些感觉对吗？我们遗漏了什么吗？” 这样就为后续会议的共识达成奠定了框架。

---

### [00:53:45] Lenny Rachitsky (Sponsorship)

**English:**
I'm excited to chat with Christina Gilbert, the founder of OneSchema... [Ad content omitted for brevity].

**中文翻译:**
[OneSchema 广告内容：介绍 CSV 导入工具 OneSchema，帮助产品团队处理复杂的 ERP 系统数据导入。]

---

### [00:55:17] Lenny Rachitsky

**English:**
I pulled up Playing to Win, which I know you also pull ideas from, and actually Roger Martin was on the podcast talking about this stuff. And one way I think about it as you're describing a way to break up your strategy doc, is he has these five questions that you ask. The first is actually what's your winning aspiration? So I love that you're pulling that in. This is one approach your doc would be. What's your winning aspiration? Where will you play? What market are you going after? How will you win? What capabilities must be in place for you to win? And then what management systems are required? We'll link to this framework just in case people want that as a crutch in their thinking strategy, but is there anything that we could link folks to that describe how you like to think about this doc? And if not, it'd be cool if you make a template that folks could borrow.

**中文翻译:**
我翻出了《玩转胜算》，我知道你也从中汲取了灵感。罗杰·马丁也上过我的播客。关于如何拆解策略文档，他提出了五个问题：1. 你的胜出抱负是什么？（我很高兴你引入了这一点） 2. 你将在哪里竞争？（目标市场） 3. 你将如何取胜？ 4. 必须具备哪些能力？ 5. 需要什么样的管理系统？我们会链接这个框架供大家参考。关于你的文档思路，有没有什么可以链接的资源？如果没有，如果你能做一个模板供大家借用就太酷了。

---

### [00:56:00] Chandra Janakiraman

**English:**
I'm happy to share of the flowchart of the process and the template as well.

**中文翻译:**
我很乐意分享流程图和模板。

---

### [00:56:05] Lenny Rachitsky

**English:**
Awesome. Okay. So this is how long of a process, this writing of the document?

**中文翻译:**
太好了。写文档这个过程需要多长时间？

---

### [00:56:10] Chandra Janakiraman

**English:**
It's about one to two weeks, and I think it's mostly solo work and hopefully by the end of it there's a very tight doc, and that's what we use to roll out.

**中文翻译:**
大约一到两周。主要是独立工作，希望最后能产出一份非常严密的文档，用于后续的发布推广。

---

### [00:56:21] Lenny Rachitsky

**English:**
And by solo work, I imagine you're looping in this working team to get their feedback as you're pulling it together, or is it just you sit there in a room and then...

**中文翻译:**
你说的独立工作，我猜你还是会找工作组获取反馈，还是说你就一个人坐在房间里写？

---

### [00:56:27] Chandra Janakiraman

**English:**
I would minimize pulling them in, because they've all contributed so much to the process already. So, I would say that at the end of it, obviously, once you have a draft, it's good to share with them, but I wouldn't tap their cycles too much at this point, because they've given a lot already.

**中文翻译:**
我会尽量减少找他们的次数，因为他们在之前的流程中已经贡献了很多。一旦有了草案，分享给他们是好事，但我不会在此时占用他们太多精力。

---

### [00:56:48] Lenny Rachitsky

**English:**
I see. Okay. And how many pages do you see this doc being, roughly? What's a heuristic?

**中文翻译:**
明白了。这份文档大概有多少页？有没有什么经验法则？

---

### [00:56:52] Chandra Janakiraman

**English:**
It's not too long. I would say probably three or four pages and then an appendix has a lot of additional... Like, the table I spoke about and a lot of additional maybe illustrative concepts. Maybe you can only use a few illustrative concepts in the main section so that there could be others there. I think usually there's a desire from leaders to say, "Okay, what are we building next?" And it's important not to include a roadmap as part of a strategy doc, because a strategy doc is meant to be separate from the roadmap. It's meant to be a companion to your roadmap. And even though there's interest, maybe sometimes you can include a illustrative roadmap in the appendix, but I would try to keep it clean and try to keep it focused on just the strategy.

**中文翻译:**
不会太长。大概三四页正文，附录里放很多额外内容，比如我提到的表格和更多的说明性概念。正文里可能只放几个核心概念图。通常领导们会急着问：“好，我们接下来建什么？” 但重要的是，不要把路线图包含在策略文档中。策略文档应该独立于路线图，它是路线图的伴侣。即使大家很感兴趣，你也可以在附录里放一个示意性的路线图，但我会尽量保持文档简洁，专注于策略本身。

---

### [00:57:40] Lenny Rachitsky

**English:**
So at this point you basically developed your strategy, the next step, I think you call rollout, where you just start actually rolling this out, so let's talk about that. But it's important to note how many weeks in this is. This is like six-ish weeks of work and you've got a strategy for your company/product?

**中文翻译:**
到这一步，你基本上已经制定好了策略。下一步你称之为“发布推广”（Rollout），即真正开始推行它。我们来聊聊这个。值得注意的是，到这一步大概已经过了六周左右，你就为公司或产品制定好了策略？

---

### [00:57:58] Chandra Janakiraman

**English:**
That's exactly right. So I think you're probably in the last two to three weeks of the process, and pretty important final step is the rollout, and I would start with what I call gatekeepers. And these are people who are absolutely... You have to get their one-on-one alignment and blessing on this before it moves forward. And it's probably not too many, probably two or three people. So I would pre-flight it with them and get their alignment.

**中文翻译:**
完全正确。现在进入了流程的最后两三周。非常关键的最后一步是发布推广。我会从我称之为“把关人”（gatekeepers）的人开始。这些人是你必须在推进之前获得他们一对一认可和祝福的人。人数通常不多，大概两三个。我会先和他们沟通（pre-flight），达成共识。

---

### [00:58:28] Lenny Rachitsky

**English:**
So these are one-on-one meetings with these gatekeepers?

**中文翻译:**
所以是和这些把关人进行一对一会议？

---

### [00:58:29] Chandra Janakiraman

**English:**
These are one-on-one meetings. Exactly. And then there's a larger group of what I call key stakeholders, people who are impacted by it, different functional leaders, et cetera. And that can be done either async or through a group review. And then there's probably a rolling of list of team roadshows. There's different ways to do this, but the one that I feel is most effective is the roadshow where you have about eight to 10 people in each session, so people feel more comfortable to ask questions and it's more conversational.

**中文翻译:**
没错，是一对一会议。然后是更大范围的“关键利益相关者”，即受此影响的人、不同职能的领导等。这可以通过异步方式或小组评审来完成。接着可能是团队“路演”（roadshows）。有很多方法，但我认为最有效的是路演，每场约 8 到 10 人，这样大家提问会更自在，更有对话感。

(00:59:06):
**English:**
So the purpose of this stage is to land it. It's not to seek too much feedback, so it's a delicate balance. At the same time, you don't want to appear just being too inflexible. So it's a very delicate balance. When people ask questions, you can clarify it, and you can add clarifications to the doc, but I wouldn't change... The most important thing, three strategic pillars, I wouldn't change that. I would defend it using the framework, but if people are like, "there's really good arguments about the criteria that led to your ranking," then it's okay to reconsider it. I've not seeing it happen in my five to six attempts, but it's possible, theoretically possible.

**中文翻译:**
这一阶段的目的是让策略“落地”，而不是寻求大量反馈，所以这是一个微妙的平衡。同时，你也不想显得太死板。当人们提问时，你可以澄清，并在文档中添加说明。但我不会改变最核心的东西——那三个战略支柱。我会用框架来捍卫它们。但如果有人对导致排名的标准提出了非常有力的反驳，那么重新考虑也是可以的。在我做过的五六次尝试中还没发生过这种情况，但理论上是可能的。

---

### [01:00:29] Chandra Janakiraman

**English:**
The the more attuned PMs who understand organizational dynamics, probably keep the manager pretty in sync through the process. I think, definitely, the manager becomes a person who you interview as part of the leadership interviews, so you know what the manager's looking for from the effort. And then once you get to the strategic pillars on day two of the strategy sprint, you probably want to just quickly pre-flight it with the manager and say, "Hey, look, this is how it's trending, and these are the things we are probably not going to do" and any issues with that. And then eventually you actually want your manager to support you in some of these bigger meetings, so you enlist their help. So I would say that it's probably each individual style, but I would keep them pretty aligned through the process. But you don't have to be too heavy, just be super light.

**中文翻译:**
那些对组织动态敏感的 PM 通常会在整个过程中让他们的经理保持同步。经理肯定是你“领导层访谈”的对象之一，所以你知道经理的期望。在策略冲刺第二天确定战略支柱后，你应该快速找经理沟通一下：“嘿，目前的趋势是这样的，这些是我们打算不做的，你觉得有问题吗？” 最终你希望经理在大型会议上支持你，所以要争取他们的帮助。这取决于个人风格，但我建议在过程中保持一致，不需要太沉重，保持轻量级沟通即可。

---

### [01:01:42] Chandra Janakiraman

**English:**
So I actually don't recommend thinking about resources in the strategy phase, because what you're saying is, "these are the areas of focus" and the resourcing question becomes more relevant from a road mapping standpoint. Because then you say, "Okay, what percentage of our engineering do we put on strategic pillar A, versus B, versus C? And what are the specific things we build?" So it becomes a road-mapping question as opposed to a strategy question.

**中文翻译:**
我其实不建议在策略阶段考虑资源问题。因为策略说的是“这些是重点领域”，而资源分配问题在路线图阶段更相关。到那时你会说：“好，我们要把百分之多少的工程力量投入到支柱 A、B 或 C？具体要建什么？” 所以这是一个路线图问题，而不是策略问题。

---

### [01:02:25] Lenny Rachitsky

**English:**
Cool. Let's go through a couple examples where you actually move into this to make this even more real. I know there's a couple companies you were thinking about sharing, strategies you worked on.

**中文翻译:**
好。让我们通过几个实际例子让它更真实。我知道你想分享几家公司的策略案例。

---

### [01:02:46] Chandra Janakiraman

**English:**
So the reason I think this process works, the first is because there is a ton of alignment built in within team alignment and leadership alignment built in. And it's not seen as, "Oh, this PM went off and wrote this strategy doc and I don't agree with most of it." And part of this is actually very... It goes back to human psychology of just something that comes from you, feels a lot more familiar and easy to accept. So this doc is actually not from the PM, the PM is facilitating it, but it's actually from the strategy working group. And the strategy working group are the leads of the team. And so it's actually... And the leadership inputs have been baked in, so it's actually very team representative.

**中文翻译:**
我认为这个流程之所以有效，首先是因为它内置了大量的共识达成（团队内部和领导层）。它不会被看作是“哦，这个 PM 自己跑去写了份策略文档，我大部分都不认同”。这涉及人类心理学：如果是你参与创造的东西，你会觉得更熟悉、更容易接受。所以这份文档其实不是 PM 的，PM 只是协调者，它实际上属于策略工作组。工作组由团队负责人组成，且融入了领导层的意见，因此它非常有团队代表性。

(01:03:43):
**English:**
The second is there's just better results. You get to better problem articulation, you get a better strategic pillar, because there's just more minds on it than if it was just a product lead. And the third thing is you have clearly defensible criteria and outputs, and if you want to change it, like I said, you have to go back to the criteria and the scoring and then say, "Okay, why do we believe this has to be changed?" And even a change is easy to justify once you do that. So it creates a lot of benefits, but ultimately, and we'll get to this a little bit more, it has to be tested with execution, and that's the most important thing.

**中文翻译:**
其次，结果会更好。你会得到更清晰的问题表述和更好的战略支柱，因为集思广益总比单打独斗强。第三，你有清晰的、可辩护的标准和产出。如果要修改，你必须回到标准和评分，解释为什么要改。这样做之后，即使是修改也变得容易证明其合理性。它带来了很多好处，但最终（我们稍后会详谈），它必须通过执行来测试，这是最重要的。

---

### [01:04:45] Chandra Janakiraman (Zynga Example)

**English:**
so the first example I wanted to talk about is at Zynga. I was at Zynga a very long time ago, and this was the heyday of social gaming on Facebook. The thing that I was extremely impressed about Zynga was the strategic clarity and strategic encoding at the company. And this was not attributable to me, by the way, this was already there when I got there as a entry-level PM, but the kind of strategic clarity there was really, really impressive and it was very evident and observable from all the games.

**中文翻译:**
我想讲的第一个例子是在 Zynga。那是很久以前，Facebook 社交游戏的鼎盛时期。Zynga 让我印象极其深刻的是其策略的清晰度和在公司内部的“编码”程度。顺便说一下，这不归功于我，我作为初级 PM 进去时它就已经存在了。那种策略清晰度令人赞叹，在所有游戏中都清晰可见。

(01:05:22):
**English:**
So if you look at all the games, there were three elements that were very common across all the games. The first was viral game loops. There's these game loops that just required you to have a social and active social network to be successful and play, and it was very tightly and fictionally integrated into the core of the gameplay. That was the first one. The second one was there was this idea of paying to complete things. So you're not paying to skip a whole experience, what you're paying is just to complete it. So what happens then is different people, depending on how much time they have, complete different percentages of a progression task, or a part of the gameplay, and you only had to pay the rest to get through the experience. And it was this interesting experience where people put a lot of investment into it, and they didn't mind paying for the last 20% or 30%, which was very interesting, because it created this market for different elasticity of spend, different times that people had in their lives. And it was very, very clever.

**中文翻译:**
如果你看当时所有的游戏，有三个共同元素。第一是“病毒式游戏循环”（viral game loops）。这些循环要求你必须拥有活跃的社交网络才能成功玩下去，它与核心玩法结合得非常紧密。第二是“付费完成”（paying to complete）的概念。你不是付费跳过整个体验，而是付费完成它。不同的人根据时间多寡完成不同比例的任务，最后只需支付剩余部分即可。这很有趣，因为人们已经投入了很多，不介意为最后 20% 或 30% 买单。这为不同消费弹性和时间成本的人群创造了市场，非常聪明。

(01:06:38):
**English:**
And then the third was network. So all of Zynga games had this cross-promotional component at the top of the game and they would promote other games, and it's like the Zynga network was the most important thing, and not an individual game. And those were the three in our parlance now strategic pillars, and there were non-focus areas. It wasn't like... The focus wasn't on high-fidelity graphics, it wasn't on complex game mechanics, and this was extremely clear and hard-coded into the company culture and operations.

**中文翻译:**
第三是“网络”（network）。所有 Zynga 游戏顶部都有交叉推广组件，推广其他游戏。Zynga 网络才是最重要的，而不是单个游戏。这就是我们现在所说的三个战略支柱。同时也有非重点领域：重点不在于高保真图形，也不在于复杂的游戏机制。这在公司文化和运营中被极其清晰地“硬编码”了。

---

### [01:11:37] Chandra Janakiraman (Meta Example)

**English:**
At Meta there's this fascinating example, which I think illustrates a different point, which is... Basically I was standing up the product strategy for a couple of product growth teams in Reality Labs, Oculus, which was coming up with the Quest II at the time. This is a standalone headset, and then Portal, which was our video conferencing product. And we stood up these teams to go after product growth, which is basically driving hardware sales through software features. And we went through this process that I just described. We stood up strategic pillars, and the strategic pillars were fairly similar for both Portal, which is our video conferencing product, and Oculus.

**中文翻译:**
在 Meta 有一个迷人的例子，说明了另一个观点。当时我正在为 Reality Labs 的几个产品增长团队制定策略，包括当时的 Oculus（正在研发 Quest 2）和 Portal（我们的视频会议产品）。这些团队的目标是通过软件功能驱动硬件销售。我们采用了我刚才描述的流程，为 Portal 和 Oculus 建立了战略支柱，而且两者的支柱非常相似。

(01:13:01):
**English:**
And about 18 months into it, they actually had very different outcomes. So on one hand the Oculus effort was incredibly successful, and we graduated it into the VR division at Meta, and till today it continues to be an incredibly successful effort. The Portal effort actually didn't move the needle as much as we wanted to, and we sunset it, and we basically redeployed that team to other initiatives. And that's super interesting. Basically it was like the same strategy process. We got the nearly identical strategic pillars, but eventually completely different outcomes. And I think that that illustrates the most important point about strategy, which is intrinsically strategy has no business value. It's basically a document with a few words. And I think it starts accumulating value as you generate business impact and results. And that happens when you actually test strategy with execution.

**中文翻译:**
大约 18 个月后，它们的结果截然不同。一方面，Oculus 非常成功，并并入了 Meta 的 VR 部门，至今仍非常成功。而 Portal 的表现未达预期，最终我们停止了这个项目，并将团队重新部署。这非常有趣：同样的策略流程，几乎相同的战略支柱，最终结果却完全不同。我认为这说明了关于策略最重要的一点：策略本身没有商业价值，它只是一份写着几个字的文档。只有当你产生业务影响和结果时，它才开始积累价值。而这发生在当你用执行去测试策略的时候。

---

### [01:16:06] Chandra Janakiraman (Big S Strategy)

**English:**
So everything we've spoken about so far is what I would call small S, and it's very problem focused. It's basically what I call present forward. It's like you have something, you have a product out there, it has a bunch of problems. How do we make it better for... What are the areas we tackle for maximum impact? Typically led by product managers. And there's this interesting quote by Elon Musk, which is, "Life has to be about more than just solving problems." And he says it in the context of the aspiration to become a multi-planetary species, but I think this is true of every company, big or small. And there needs to be an aspirational and cool component to strategy. And I call this big-S strategy.

**中文翻译:**
到目前为止我们讨论的都是“小写 s 策略”，它是以问题为导向的，即“立足当下，展望未来”。你有一个产品，它有一堆问题，我们该解决哪些领域以获得最大影响？这通常由 PM 主导。埃隆·马斯克说过：“生活不能仅仅是为了解决问题。” 他是在谈论成为多行星物种的抱负时说的，但我认为这对任何公司都适用。战略中需要有令人向往、酷炫的成分。我称之为“大写 S 战略”。

(01:17:41):
**English:**
The approach is a bit different from small S. And you start with the company mission and vision, and there is a little bit of groundwork that is done on long-term cultural trends, social trends, competitive trends, technological trends, and those are all the backdrop to trigger ideas. And what you do with that backdrop is you, again, do these leadership interviews, but with a different goal of generating long-term futures. And some of the questions you can ask during these interviews are "What does a day in the life of a user look like in five years? What does the product look like in five to 10 years? Why is the world better in 10 years? And what is the most exciting version of that view?" And basically take all of that input and cluster it into I would say, three cohesive holes.

**中文翻译:**
大写 S 的方法与小写 s 不同。你从公司的使命和愿景开始，对长期的文化、社会、竞争和技术趋势做一些基础研究，这些是激发创意的背景。在这些背景下，你再次进行领导层访谈，但目标不同：是为了生成“长期的未来”。你可以问：“五年后用户的一天是什么样的？” “十年后产品是什么样子？” “为什么十年后的世界会更好？” 然后将这些输入聚类成三个连贯的整体。

(01:18:45):
**English:**
And once you generate those distinct futures, you actually generate prototypes with learning goals. And think of these prototypes as concept cars. And the automobile industry uses this notion of concept cars. Concept cars, the interesting thing about concept cars is they're never commercialized. They're often produced for inspiration, and to potentially take some part of them, like maybe a technology or a feature, and that is brought into mainstream production. So think of these prototypes as these concept cars that really drive inspiration and potentially give you some small nuggets that you can run with. And then you start doing research with them with potential users, you answer key questions, and you uncover certain elements that resonate with people.

**中文翻译:**
一旦生成了这些不同的未来愿景，你就要根据学习目标制作“原型”。把这些原型想象成“概念车”。汽车行业经常使用概念车的概念：它们从不商业化，而是为了激发灵感，并可能将其中的某项技术或功能引入主流生产。所以，把这些原型看作驱动灵感的概念车。然后你开始找潜在用户进行研究，回答关键问题，发现能引起人们共鸣的元素。

---

### [01:27:24] Chandra Janakiraman (AI in Strategy)

**English:**
So right away, I think the basic idea is everybody should be using assistance in the strategy formulation process with the basic tools that we have. And there are two ways to get AI to assist you in the strategy formulation process. The first is to support the preparation phase in terms of research. And this could be competitive analysis and, for example, you could do trend analysis from a vast library of competitors' release notes. And you can sort of say, "Okay, what are the themes of investment of a competitor's release notes?" Or you could do a reviews analysis of a competitor product and sort of understand what's resonating for users, what's not.

**中文翻译:**
我认为最基本的想法是，每个人都应该在策略制定过程中使用 AI 工具。有两种方式：第一是在准备阶段支持研究。比如竞品分析，你可以让 AI 分析竞争对手大量的发布日志（release notes），总结他们的投资主题；或者分析竞品的用户评论，了解哪些引起了共鸣，哪些没有。

(01:29:12):
**English:**
The second one is in this idea called generating mock strategies. And I know Claire Rowe at your summit spoke about this, and I think this is absolutely right and should be a critical input into the strategy process, which is asking these tools for a mock strategy. And I call this a mock strategy because it's kind of almost the answer but not quite the answer. What I've found is that its biggest strength is also somewhat its weakness, which is these mock strategies tend to be pretty comprehensive and extensive, and there's an investment recommendation in a vast number of areas. So basically, if you remember, the core of strategy is really to be very targeted and to be very focused. So these mock strategies become an interesting input and the burden is still on the team to down-select into the most important areas for investment.

**中文翻译:**
第二种方式是生成“模拟策略”（mock strategies）。让 AI 提供一份模拟策略。我称之为模拟策略，因为它几乎是答案，但又不完全是。我发现 AI 的最大优点也是它的缺点：模拟策略往往非常全面且广泛，建议在大量领域进行投资。但如果你记得策略的核心，那就是要非常有针对性和专注。所以模拟策略是一个有趣的输入，但筛选出最重要投资领域的重担仍然在团队身上。

---

### [01:38:43] Lenny Rachitsky (Lightning Round)

**English:**
Let's do it. First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
开始吧。第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:38:47] Chandra Janakiraman

**English:**
Yeah, I love books on creativity and innovation, Lenny, and some of my classic favorites are Walt Disney's biography. And there's several out there, but I think the one that I like the most is the Triumph of the American Imagination. The other classic is Ed Catmull's Creativity Inc, and it talks about all the negative forces that eat away at creativity in an organization. And then there's this probably less popular book, but really good one from Tom Kelly of IDEO, which is The Ten Faces of Innovation.

**中文翻译:**
我喜欢关于创意和创新的书。经典之作包括华特·迪士尼的传记，我最喜欢的是《美国想象力的胜利》（Triumph of the American Imagination）。另一本经典是皮克斯创始人艾德·卡特姆的《创意公司》（Creativity Inc），它讲述了组织中侵蚀创意的负面力量。还有一本可能没那么出名但很棒的书，是 IDEO 的 Tom Kelly 写的《创新的 10 个面孔》（The Ten Faces of Innovation）。

---

### [01:46:02] Chandra Janakiraman (Closing)

**English:**
A reasonable choice would be LinkedIn to reach me, and I really, like you and I discussed earlier, I'd be really happy if this creates that kind of ripple effect of successes, both for individuals and for products. And I want everybody to think of this, the stuff I shared as a bit of an open source model. So test some of the concepts, modify it, remix it, and share what worked or did not. And ultimately, that's what makes it all interesting is the community owns it ultimately, and it doesn't belong to one individual. That's what would make me super happy.

**中文翻译:**
可以通过 LinkedIn 联系我。正如我们之前讨论的，如果这能为个人和产品创造成功的“涟漪效应”，我会非常高兴。我希望大家把这些内容看作是一个“开源模型”。去测试这些概念，修改它们，重新组合，并分享哪些有效，哪些无效。最终，让社区共同拥有它，而不是属于某个人，这才是最有趣的，也会让我非常开心。

---

### [01:46:57] Lenny Rachitsky

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app... See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。下期节目再见。