# Chip Conley - 双语对照

# Lenny's Podcast: Chip Conley - Bilingual Transcript

---

### [00:00:00] Lenny Rachitsky

**English:**
Let's paint a picture of just what it was like to join Airbnb in your fifties.

**中文翻译:**
让我们来描绘一下，在你五十多岁时加入 Airbnb 是一种什么样的体验。

---

### [00:00:04] Chip Conley

**English:**
I was mentoring Brian, but he was also my boss. I was 52, the average age was 26. I had to be both wise and curious, and often the dumbest person in the room.

**中文翻译:**
我当时在指导 Brian（Airbnb 创始人），但他同时也是我的老板。我那时 52 岁，而公司的平均年龄是 26 岁。我必须同时保持智慧和好奇心，而且经常要甘愿做房间里“最笨”的那个人。

---

### [00:00:14] Lenny Rachitsky

**English:**
It's great to be in founder mode. It's not as great to be working for someone in founder mode.

**中文翻译:**
处于“创始人模式”（Founder Mode）感觉很棒，但为处于这种模式下的人工作就没那么美妙了。

---

### [00:00:18] Chip Conley

**English:**
Brian assumed everybody else was going to work at the same pace and duration. His point of view is like, "Hey, we're having a meeting in the office tonight at 10 o'clock. Be there."

**中文翻译:**
Brian 假设其他所有人都会以同样的节奏和时长工作。他的观点就像是：“嘿，我们今晚 10 点在办公室开会，准时参加。”

---

### [00:00:28] Lenny Rachitsky

**English:**
Everyone's talking about, "We got to make the product better. We got to optimize this button, and improve conversion."

**中文翻译:**
每个人都在谈论：“我们必须把产品做得更好。我们要优化这个按钮，提高转化率。”

---

### [00:00:32] Chip Conley

**English:**
Isn't the product the homes and the apartments? Jobot said, "Nope. Product in the tech industry is something different." I just said, "Listen, let's get some older people who are hosts in here."

**中文翻译:**
难道产品不是那些住宅和公寓吗？Jobot（Joe Gebbia）说：“不，科技行业的产品是另一回事。”我当时就说：“听着，让我们找一些年纪大一点的房东进来聊聊。”

---

### [00:00:41] Lenny Rachitsky

**English:**
This whole story is a really good example of the value of having folks that are older.

**中文翻译:**
整个故事是体现年长员工价值的一个绝佳例子。

---

### [00:00:45] Chip Conley

**English:**
When you have older brains connecting the dots, younger team members being really fast and focused, it's brilliant, and people won't notice your wrinkles as much as they'll notice your energy.

**中文翻译:**
当你让年长的大脑负责“连接点滴”（串联全局），让年轻的团队成员保持高效和专注时，这种组合非常精彩。人们不会太在意你的皱纹，他们更在意的是你的活力。

---

### [00:00:55] Lenny Rachitsky

**English:**
The Airbnb experienced led you to starting something called the Modern Elder Academy.

**中文翻译:**
在 Airbnb 的经历促使你创办了一个名为“现代长者学院”（Modern Elder Academy）的机构。

---

### [00:00:59] Chip Conley

**English:**
If you think about the caterpillar to butterfly journey, midlife is the chrysalis. Midlife is not crisis. I'm happier today at 64 than I was at 47 when I was going through my flatline experience.

**中文翻译:**
如果你思考一下从毛毛虫到蝴蝶的旅程，中年就是那个“蛹”的阶段。中年不是危机，而是蜕变。我今年 64 岁，比我 47 岁经历人生低谷时要快乐得多。

---

### [00:01:09] Lenny Rachitsky

**English:**
Well, let's back up a little bit, this near death experience. Today, my guest is Chip Conley. Chip is one of the most extraordinary and interesting people that you'll ever meet. He was a founding member of the board of Burning Man. He was on the board of the Esalen Institute in Big Sur. At 26, he started a hotel chain called Joie de Vivre, which went on to become the second-largest boutique hotel chain in the US.

**中文翻译:**
好，让我们先退回一点，聊聊那个濒死体验。今天我的嘉宾是 Chip Conley。Chip 是你所能见到的最非凡、最有趣的人之一。他是火人节（Burning Man）董事会的创始成员，曾任大瑟尔伊莎兰学院（Esalen Institute）的董事。26 岁时，他创办了名为 Joie de Vivre 的酒店连锁品牌，后来发展成为美国第二大精品酒店连锁。

---

### [00:01:32] Lenny Rachitsky

**English:**
After selling it, Brian Chesky personally recruited Chip to join Airbnb to help Brian and the company transform from a fast-growing startup to the world's most valuable hospitality brand. After leaving Airbnb where he was known as the Modern Elder, chip started the Modern Elder Academy, now known as MEA, the world's first midlife wisdom school, with large sprawling, beautiful campuses in Baja and Santa Fe. He's also written seven books, given a TED Talk, and is just a genuinely interesting and amazing human and friend.

**中文翻译:**
在出售公司后，Brian Chesky 亲自招募 Chip 加入 Airbnb，帮助 Brian 和公司从一家快速增长的初创企业转型为全球最有价值的款待业品牌。离开 Airbnb 后（他在那里被称为“现代长者”），Chip 创办了现代长者学院（现简称为 MEA），这是世界上第一所中年智慧学校，在巴哈和圣达菲拥有广阔而美丽的校园。他还写过七本书，做过 TED 演讲，是一个真正有趣、了不起的人，也是我的好朋友。

---

### [00:02:01] Lenny Rachitsky

**English:**
In our conversation, we explore how to be successful in tech as you age, what he's learned working with and for Brian Chesky, including a lot of real talk, how to build a great culture at your company, his near-death experience, and how it changed the trajectory of his life, and so much more. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube.

**中文翻译:**
在我们的对话中，我们探讨了随着年龄增长如何在科技界取得成功，他在与 Brian Chesky 共事期间学到的东西（包括很多大实话），如何建立优秀的公司文化，他的濒死体验以及它是如何改变他的人生轨迹的，等等。如果你喜欢这个播客，别忘了在您常用的播客应用或 YouTube 上订阅和关注。

---

### [00:02:22] Lenny Rachitsky

**English:**
Also, if you become an annual subscriber of my newsletter, you get a year free of a bunch of incredible products, including Replit, Lovable, Bolt, NNN, Linear Superhuman, Descript, Wispr Flow, Gamma Perplexity, Warp Granola, Magic Patterns, Raycast, JetPRD, Mobbin and more. Check it out at LennysNewsletter.com and click bundle. With that, I bring you Chip Conley. This episode is brought to you by Great Question: the all-in-one UX research platform loved by teams at Brex, Canva, Intuit, and more.

**中文翻译:**
此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你将免费获得一年的一系列不可思议的产品，包括 Replit, Lovable, Bolt 等等。请访问 LennysNewsletter.com 并点击 bundle 查看。现在，让我们欢迎 Chip Conley。本集节目由 Great Question 赞助：这是一款深受 Brex、Canva、Intuit 等团队喜爱的全方位用户体验（UX）研究平台。

---

### [00:02:51] Lenny Rachitsky

**English:**
One of the most common things I hear from PMs and founders that I talk to is, "I know I should be speaking to customers more, but I just don't have the time or the tools." That's exactly the gap Great Question fills. Great Question makes it easy for anyone on your team, not just researchers, to recruit participants, run interviews, send surveys, test prototypes, and then share it all with powerful video clips. It's everything you need to put your customers at the center of your product decisions.

**中文翻译:**
我从 PM 和创始人那里听到的最常见的一句话是：“我知道我应该多和客户交流，但我就是没有时间或工具。”这正是 Great Question 填补的空白。它让团队中的任何人（不仅仅是研究员）都能轻松招募参与者、进行访谈、发送调查、测试原型，并分享带有强大视频剪辑的见解。它是让你将客户置于产品决策中心所需的一切。

---

### [00:03:15] Lenny Rachitsky

**English:**
With a prompt as simple as, "Why did users choose us over competitors?" Great Question not only reveals what your customers have already shared, but it also makes it incredibly easy to ask them in the moment for fresh insights from the right segment. Picture this: your roadmaps clear, your team's aligned, you're shipping with confidence, and you're building exactly what your customers need. Head to greatquestion.com/Lenny to get started. This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast.

**中文翻译:**
只需输入一个简单的提示，比如“为什么用户选择我们而不是竞争对手？”，Great Question 不仅能揭示客户已经分享的内容，还能让你非常容易地即时向特定细分市场的客户获取新鲜见解。想象一下：你的路线图清晰，团队步调一致，你充满信心地发布产品，并且你正在构建的正是客户所需要的。访问 greatquestion.com/Lenny 开始使用。本集节目由 Vanta 赞助。在确保公司拥有顶尖安全实践方面，事情往往会迅速变得复杂。

---

### [00:03:48] Lenny Rachitsky

**English:**
Now, you can assess risk, secure the trust of your customers, and automate compliance for SOC 2, ISO 27,001, HIPAA, and more with a single platform, Vanta. Vanta's market leading trust management platform helps you continuously monitor compliance, alongside reporting and tracking risks. Plus, you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews.

**中文翻译:**
现在，你可以通过 Vanta 这一个平台来评估风险、赢得客户信任，并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险。此外，你还可以通过 Vanta AI 完成安全问卷，从而节省数小时的时间。加入全球数千家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的公司行列吧。

---

### [00:04:22] Lenny Rachitsky

**English:**
Get $1,000 off Vanta when you go to Vanta.com/Lenny. That's Vanta.com/Lenny. Chip, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
访问 Vanta.com/Lenny 即可享受 1000 美元的折扣。Chip，非常感谢你能来到这里，欢迎来到本播客。

---

### [00:04:38] Chip Conley

**English:**
Oh, my god, Lenny, I sort of feel like I'm your father who's so proud of his son. My son has done so well, and I like to talk about, tell all my friends about you.

**中文翻译:**
噢，天哪，Lenny，我感觉自己就像是一个为儿子感到无比自豪的父亲。我的儿子做得太棒了，我喜欢向我所有的朋友夸奖你。

---

### [00:04:49] Lenny Rachitsky

**English:**
Wow, I am honored. I'm happy that I'm making you proud, Chip, and I feel the same in reverse. We got to work together for many years at Airbnb. I got to learn a ton from you. I'm really excited that more people are going to get to learn from you from this conversation. I'm thinking that the way that we break up this conversation is kind of break it up into three parts, which are kind of the three arcs of your career. The three parts are your early career, building Joie de Vivre, your time at Airbnb, where we got to work together, and then talking through what you're working on now, the Modern Elder Academy.

**中文翻译:**
哇，我深感荣幸。我很高兴能让你感到自豪，Chip，我对你也有同样的感觉。我们在 Airbnb 共事多年，我从你身上学到了很多。我非常激动，更多的人将通过这次对话向你学习。我想我们可以把这次谈话分成三个部分，这对应你职业生涯的三个阶段：早期创业建立 Joie de Vivre，我们在 Airbnb 共事的时期，以及你现在正在做的现代长者学院（MEA）。

---

### [00:05:22] Lenny Rachitsky

**English:**
I actually want to start with the middle chapter. I'm going to talk about Airbnb where we got to work together. Let's paint a picture of just what it was like for you to join Airbnb in your fifties surrounded by a bunch of 20 something, 30 somethings reporting to Brian Chesky, who is, I don't know, in his thirties. What was that like?

**中文翻译:**
我其实想从中间那个章节开始。我想聊聊我们在 Airbnb 共事的那段时光。让我们描绘一下，你五十多岁加入 Airbnb，周围全是一群二十多岁、三十多岁的小伙子，还要向当时只有三十来岁的 Brian Chesky 汇报，那是什么感觉？

---

### [00:05:41] Chip Conley

**English:**
Yeah, I wasn't planning on doing this. I got a call from a woman named Natalie Tucci who worked at Airbnb, and said, "Brian Chesky and I've been talking about having you come in and give a talk. Are you open to that?" I was like, "Well, what is Airbnb?" This was 13 years ago, I think it was the end of 2012. Then Brian called me and said, "Listen, we really want you to come in." I came in and gave a talk about innovation and hospitality.

**中文翻译:**
是的，我原本没打算这么做。我接到一个叫 Natalie Tucci 的女人的电话，她在 Airbnb 工作，她说：“Brian Chesky 和我一直在讨论请你来做个演讲，你感兴趣吗？”我当时心想：“呃，Airbnb 是什么？”那是 13 年前的事了，我想是 2012 年底。然后 Brian 给我打电话说：“听着，我们真的很希望你来。”于是我去了，做了一个关于款待业创新的演讲。

---

### [00:06:14] Chip Conley

**English:**
I think I didn't realize it was sort of a dress rehearsal for Brian to see whether the younger crowd there, I was 52, the average age was 26, would feel good about an old geezer like me with a bricks and mortar boutique hotel background, talking about the industry that Airbnb was disrupting. As it turns out, people liked me. Brian said, "I want you to come in and work 15 hours a week as a consultant. I want you to be my in-house mentor for both me, and Joe and Nate." I said, "Okay, 15 hours a week is great," and then within three weeks, it was 15 hours a day.

**中文翻译:**
我想我当时没意识到那其实是 Brian 的一次“彩排”，他想看看那里的年轻人（我 52 岁，平均年龄 26 岁）是否会对像我这样有着传统精品酒店背景的“老家伙”产生好感，毕竟我谈论的是 Airbnb 正在颠覆的行业。结果证明，大家挺喜欢我的。Brian 说：“我想请你来当顾问，每周工作 15 小时。我想让你成为我和 Joe、Nate 的内部导师。”我说：“好啊，每周 15 小时挺好的。”结果不到三周，就变成了每天 15 小时。

---

### [00:07:00] Chip Conley

**English:**
I was saying to Brian, "You're actually not paying me anything." He gave me a little bit of stock that would vest in six months and I said, "I don't know that this deal's working for me. It seems like the company needs to be a little more than you said." He said, "Yeah, I got you. I just wanted you to get in here and see what you could do." Long story short is I ended up going full-time. It was hard at first, Lenny, because I didn't understand the tech lingo. I didn't have any background. I was 52. I'd never worked in a tech company before.

**中文翻译:**
我对 Brian 说：“你其实根本没付我薪水。”他给了我一点六个月后行权的股票，我说：“我不确定这笔交易对我划算。看起来公司需要的投入比你说的要多得多。”他说：“是的，我明白。我只是想让你先进来，看看你能做些什么。”长话短说，我最终转成了全职。刚开始很难，Lenny，因为我不懂科技术语。我没有任何背景。我 52 岁了，以前从未在科技公司工作过。

---

### [00:07:42] Chip Conley

**English:**
I was mentoring Brian on leadership, but he was also my boss. I was the head of global hospitality and strategy, which meant initially, I was in charge of all the hosts in the world. Over time, that meant a lot more things too. I was involved in many parts of the business, definitely not the technical parts, but I think the hardest thing for me was just that initially, when people were talking about product, and Jobot said, "I'm the chief product officer," and I'm like, "Well, isn't the product the homes and the apartments?" Jobot said, "No, product in the tech industry is something different."

**中文翻译:**
我在领导力方面指导 Brian，但他也是我的老板。我是全球款待与策略主管，这意味着最初我负责全球所有的房东。随着时间的推移，这也意味着更多的事情。我参与了业务的许多部分，当然不包括技术部分。但我认为对我来说最难的事情是，最初当人们谈论“产品”时，Jobot 说“我是首席产品官”，我心想：“难道产品不是那些住宅和公寓吗？”Jobot 说：“不，科技行业的产品是另一回事。”

---

### [00:08:23] Chip Conley

**English:**
I had to be both wise and curious, and often the dumbest person in the room. It required me to have a certain amount of humility as well as to be reporting to a guy 21 years younger than me, Brian.

**中文翻译:**
我必须同时保持智慧和好奇心，而且经常是房间里最笨的人。这要求我保持一定程度的谦逊，毕竟我要向一个比我小 21 岁的家伙（Brian）汇报。

---

### [00:08:36] Lenny Rachitsky

**English:**
That actually, the point you're making there about what is the product I asked Laura Hughes, formerly Laura Modi, what to talk to you about, who we got to work together. She's the CEO of Bobbie now. You worked closely with her at Airbnb. She said this was the thing that stuck with her most about working with you is coming in and everyone's talking about, "We got to make the product better. We got to optimize this button and improve conversion, and product, product, product."

**中文翻译:**
关于“什么是产品”这一点，我问过 Laura Hughes（原名 Laura Modi），她是现在 Bobbie 的 CEO，我们曾一起共事。你当时在 Airbnb 和她合作紧密。她说，和你共事最让她印象深刻的一点就是，当所有人都在谈论“我们要改进产品、优化按钮、提高转化率，产品产品产品”时。

---

### [00:08:59] Lenny Rachitsky

**English:**
You're just like, "What is the product? I thought the product of Airbnb was the hosts, and the experiences, and the trips." I think that shows the value of someone like you coming in with different experience, and also older, and helping us communicate differently to hosts who also don't understand.

**中文翻译:**
你却会问：“什么是产品？我以为 Airbnb 的产品是房东、体验和旅程。”我认为这体现了像你这样拥有不同经验且年长的人加入的价值，你帮助我们以不同的方式与那些同样不理解科技术语的房东进行沟通。

---

### [00:09:15] Chip Conley

**English:**
Well, there's an interesting thing also, Lenny, and you notice the difference in age between our hosts and our guests was probably about 10 years maybe. Over time, it actually got higher, because we started actually reaching out more aggressively to boomers and Gen Xers to be hosts. You had, I remember at one point, and again, let's get into a product talk here, I remember at one point, there was a conversation that was going on about taking Airbnb so it was mobile only.

**中文翻译:**
Lenny，还有一件有趣的事，你可能注意到我们的房东和房客之间的年龄差距大概是 10 岁左右。随着时间的推移，这个差距实际上变大了，因为我们开始更积极地接触婴儿潮一代和 X 世代来当房东。我记得有一次（我们再聊聊产品话题），当时有一个关于让 Airbnb 变成“仅限移动端”（mobile only）的讨论。

---

### [00:09:47] Chip Conley

**English:**
Partly because back in the day, the two sharing economy darlings were Uber and Airbnb. Of course, Uber was pretty much a mobile only app. Airbnb started as non-mobile and then went mobile. Then it was like, "Oh, wouldn't it be interesting if everything was mobile?" At some point, I just said, "Listen, let's get some older people who are hosts in here to see how well they will be versed in managing their listing purely on mobile."

**中文翻译:**
部分原因是当时共享经济的两大宠儿是 Uber 和 Airbnb。当然，Uber 几乎是一个纯移动端的应用。Airbnb 最初不是移动端的，后来才有了移动端。然后大家就想：“噢，如果一切都变成移动端，不是很有趣吗？”在某个时刻，我直接说：“听着，让我们找一些年纪大的房东进来，看看他们纯粹在手机上管理房源会有多熟练。”

---

### [00:10:18] Chip Conley

**English:**
There were times where I was a voice for older users, in this case, hosts, that was helpful to guys and women in their twenties who were the engineers and designers and product managers. I always liked working with you. I want to just compliment Lenny for a minute.

**中文翻译:**
有些时候，我充当了年长用户（在这种情况下是房东）的代言人，这对那些二十多岁的工程师、设计师和产品经理非常有帮助。我一直很喜欢和你一起工作。我想花一分钟夸奖一下 Lenny。

---

### [00:10:40] Lenny Rachitsky

**English:**
Oh, how sweet is that?

**中文翻译:**
噢，这太贴心了。

---

### [00:10:41] Chip Conley

**English:**
We did a lot of different things together, and what I appreciated was you had a humility to you that was different than a lot of the other product managers. There's other product managers, I'm not going to mention their names, and some of these product managers were very good. There were other product managers though who I found it sometimes hard to work with, because they expected me to know as much as they did.

**中文翻译:**
我们一起做过很多不同的事情，我非常欣赏你身上那种与其他许多产品经理不同的谦逊。还有其他一些产品经理——我不打算点名——其中一些非常优秀。但也有一些产品经理让我觉得很难共事，因为他们期望我像他们一样懂行。

---

### [00:11:07] Chip Conley

**English:**
I guess it would be, if the opposite side of that would be an older manager expecting a younger manager to have as much emotional intelligence, because emotional intelligence on average is something we get better at as we get older. I think the key for me to work in that environment and make it work was to not pretend to know things I didn't know, it was to have a sense of humor and humility in how I operated, and it was to show respect and hope that I got it in return. I don't know if you felt that way, Lenny. That's the kind of environment I tried to embody there.

**中文翻译:**
我想，如果反过来，一个年长的经理期望年轻经理拥有同样高的情商，那也是不公平的，因为情商通常是随着年龄增长而提高的。我认为我在那个环境下工作并取得成效的关键在于：不假装懂我不懂的东西，在做事时保持幽默感和谦逊，并表现出尊重，同时也希望得到回报。我不知道你是否也有同感，Lenny。那是我试图在公司里营造的环境。

---

### [00:11:45] Lenny Rachitsky

**English:**
Absolutely. There's a couple of threads there I want to follow. One is just working for Brian. A lot of people talk about founder mode, and the power of founder mode, it's so great. That's how we-

**中文翻译:**
绝对有同感。我想顺着几个思路聊聊。一个是为 Brian 工作。很多人谈论“创始人模式”及其威力，说它非常棒。那是我们——

---

### [00:11:55] Chip Conley

**English:**
Guess who-

**中文翻译:**
猜猜是谁——

---

### [00:11:57] Lenny Rachitsky

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:11:57] Chip Conley

**English:**
... populated that recently, that was Brian.

**中文翻译:**
……最近让这个词火起来的，正是 Brian。

---

### [00:12:01] Lenny Rachitsky

**English:**
Exactly. It's great to be in founder mode. It's not as great to be working for someone in founder mode. Often a very challenging place to be.

**中文翻译:**
没错。处于创始人模式很棒，但为处于创始人模式的人工作就没那么美妙了。那通常是一个非常有挑战性的处境。

---

### [00:12:07] Chip Conley

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:12:07] Lenny Rachitsky

**English:**
You reported to Brian. Also, you were just your own boss basically your entire career. You never really had to report to someone before. Also, he was in his thirties, you're in your fifties. What was it like working for Brian? The more real you can be, the better, because a lot of people always talk about here, it's like, "It was wonderful, I learned so much." Just like what was that experience? What did you learn from working for someone like Brian?

**中文翻译:**
你向 Brian 汇报。而且，你职业生涯的大部分时间基本上都是自己的老板，以前从未真正向别人汇报过。此外，他才三十多岁，你已经五十多岁了。为 Brian 工作是什么感觉？你越真实越好，因为很多人在这里总是说“太棒了，我学到了很多”。那段经历到底是怎么样的？从 Brian 这样的人身上你学到了什么？

---

### [00:12:30] Chip Conley

**English:**
Well, let's start with the fact that I would never have gone to work for Airbnb if I didn't believe in Brian, because quite frankly, when Brian approached me and we started talking about it, I was like, I wasn't sure I liked the business model all that well as a hotelier. I had to believe in something beyond the business model, because I wasn't sure that the business model would work. Although soon after joining, I saw the numbers. I was like, "Wow, this is working pretty well."

**中文翻译:**
首先，如果我不相信 Brian，我绝不会去 Airbnb 工作。坦白说，当 Brian 找我谈这件事时，作为一个酒店经营者，我不确定自己是否喜欢这种商业模式。我必须相信商业模式之外的一些东西，因为我不确定这种模式是否行得通。虽然加入后不久我看到了数据，心想：“哇，这运行得相当不错。”

---

### [00:12:56] Chip Conley

**English:**
I believed in Brian because the thing that Brian showed up with initially was just a curiosity and an appetite for learning. I remember back in 2011, when the big debacle happened with the apartment getting trashed by a guest. Brian decided he was going to go to find George Tenet, the former head of the CIA. Brian would go to experts and say to the expert, "I don't know what the hell I'm doing." He did that with me when it came to hospitality. I appreciated that a guy who had a lot of hubris, and Brian definitely has a lot of hubris, could also have the humility to say, "I want to learn more about this."

**中文翻译:**
我相信 Brian，是因为他最初展现出的是一种好奇心和对学习的渴望。我记得 2011 年，当时发生了一起严重的公寓被房客捣毁的事件。Brian 决定去找前中情局局长 George Tenet。Brian 会去找专家，并对专家说：“我真不知道自己在搞什么鬼。”在款待业方面，他也对我这么做了。我很欣赏一个非常有傲气的人（Brian 确实很有傲气）也能有谦逊的态度说：“我想多了解一下这个领域。”

---

### [00:13:42] Chip Conley

**English:**
It's sort of a growth mindset. What was hard with Brian is, I'd say, three things. Number one is Brian assumed everybody else was going to work at the same pace and duration, and he still has this issue. The beautiful thing about Brian is he's been very honest in the last couple of years on podcasts about his workaholism, and about the fact that the way he lives his life is not like other people. Back when I joined, his point of view is like, "Hey, we're having a meeting in the office tonight at 10 o'clock, be there."

**中文翻译:**
这是一种成长型思维。但和 Brian 共事难的地方，我认为有三点。第一，Brian 假设其他所有人都会以同样的节奏和时长工作，他现在仍然有这个问题。Brian 难能可贵的一点是，过去几年他在播客中非常诚实地谈到了他的工作狂倾向，以及他生活方式与常人的不同。我刚加入时，他的观点就是：“嘿，我们今晚 10 点在办公室开会，准时参加。”

---

### [00:14:20] Chip Conley

**English:**
It's like, "Really? No, I don't think so." I think the fact that Brian assumed everybody else was as one-dimensional in their focus as him was at times a problem, especially for a guy like me who was, I was in a stage in my career where I have a lot of interests. That was one. Number two is Brian admires and admired back then, Steve Jobs so much that there was a sense that as a guy who came from the product world, from the Rhode Island School of Design, he knew better than anybody else.

**中文翻译:**
我心想：“真的吗？不，我不这么认为。”我认为 Brian 假设其他所有人都像他一样专注点如此单一，这有时是个问题，尤其是对于像我这样处于职业生涯后期、有很多兴趣爱好的人来说。这是其一。第二，Brian 非常崇拜乔布斯（Steve Jobs），以至于有一种感觉，作为一个出身于产品界、来自罗德岛设计学院的人，他比任何人都懂。

---

### [00:15:05] Chip Conley

**English:**
There was this, one of the challenges for a CEO sometimes, and this was my experience in my 24 years of running Joie de Vivre, my boutique hotel company, is it feels good when you feel needed. To come into a room and sort of see something, and then point out the things that are wrong makes you feel good. If you don't have emotional intelligence, that process can really piss people off or demotivate people. In Brian's case, I didn't have to deal with that too much, because he didn't understand, when I was starting, it was really, I was in charge of the hosts around the world.

**中文翻译:**
有时候 CEO 面临的挑战之一（这也是我经营精品酒店公司 24 年的经验）是，当你感到被需要时，感觉会很好。走进一个房间，看到一些东西，然后指出哪里错了，这会让你感觉良好。但如果你缺乏情商，这个过程真的会惹恼别人或打击别人的积极性。在 Brian 的案例中，我不需要过多处理这个问题，因为在我刚开始工作时，他并不太懂我负责的领域——我负责全球的房东。

---

### [00:15:45] Chip Conley

**English:**
Quite frankly, the idea of what's the psychology of the host? What's a host entrepreneur like? I went on a world tour to 20 different cities, and went and talked to hosts. I think I came back from that with a little bit of credibility with Brian to say like, "Hey, yes, our data science team and the quality folks who are doing qualitative interviews, they're getting something out of this." I actually went into the homes of these hosts all around the world, and I think I was lucky because Brian did less of that than he did with other people.

**中文翻译:**
坦白说，房东的心理是什么？房东创业者是什么样的？我进行了一次全球巡访，去了 20 个不同的城市，与房东交谈。我想我带回来的东西在 Brian 那里赢得了一点信誉，我可以告诉他：“嘿，是的，我们的数据科学团队和做定性访谈的质量人员确实从中有所收获。”我真的走进了世界各地这些房东的家里，我想我很幸运，因为 Brian 在这方面对我干预较少。

---

### [00:16:19] Chip Conley

**English:**
For the product team, my God, a product meeting with Brian would keep people up the night before, not just because they were actually working all night long to get prepared, but also they knew they would work all night long, because they probably wouldn't sleep in anticipation for this. That was another issue, I'd say. I'd say the other thing that, and in each of these cases, I think Brian's getting better. Just like Steve Jobs got better over time when he left and then he came back, he was much better when he came back, from all the people I've talked with who worked with him.

**中文翻译:**
但对于产品团队来说，天哪，和 Brian 开一次产品会能让大家前一天晚上都睡不着觉，不仅是因为他们真的在通宵准备，还因为他们知道自己会通宵工作，因为在焦虑的期待中根本睡不着。这是另一个问题。我想说的第三点是——在这些方面，我认为 Brian 都在变好。就像乔布斯随着时间的推移也在进步一样，当他离开又回来后，他变得好多了，这是我从所有与他共事过的人那里听到的。

---

### [00:16:53] Chip Conley

**English:**
I'd say the third thing for Brian was the sense that adding a zero to something in terms of expectations, or thinking you're going to set a deadline that is unreasonable is necessary. If you don't do that, there's almost an underlying message that people won't kick ass on their own. There was a sense that Brian had that he had to maybe create ridiculous goals, because even if we hit half of that goal, it was very encouraging. What he missed in that was the fact that when you miss a goal, and when you have someone who has power over you setting the goal, or encouraging a particular goal, you're setting people up for a lot of stress.

**中文翻译:**
我想 Brian 的第三点是，他认为在期望值上加个零，或者设定一个不合理的截止日期是必要的。如果你不这样做，似乎就传达了一种潜在信息：人们不会自觉地拼命工作。Brian 觉得他必须设定一些荒谬的目标，因为即使我们只完成了一半，那也非常令人振奋。但他忽略的是，当你没能达成目标，尤其是当一个对你有权力的人设定或鼓励某个特定目标时，你会给员工带来巨大的压力。

---

### [00:17:51] Chip Conley

**English:**
At the end of the day, I think Brian is a generational leader as a millennial, and I think he deserves a lot of credit. Airbnb is as successful as it is, partly because of Brian's leadership. I would not have been there without him. Having said that, I had to hold my tongue in meetings sometimes when I saw how he was operating, because I wouldn't have done it that way. I think over time, I hope I had a little bit of influence on him in terms of how to apply some emotional intelligence to leading people.

**中文翻译:**
归根结底，我认为 Brian 作为千禧一代是一个划时代的领导者，他值得很多赞誉。Airbnb 如此成功，部分归功于 Brian 的领导。没有他，我也不会在那里。话虽如此，有时在会议上看到他的运作方式，我不得不保持沉默，因为我不会那样做。我想随着时间的推移，我希望我在如何运用情商领导他人方面对他产生了一点影响。

---

### [00:18:28] Lenny Rachitsky

**English:**
For people in this position, a lot of people work for founders, especially now that founder mode is a thing. Every founder is just like, "I'm the founder, you got to do what I tell you. It's founder mode. Again, this is how we win. We're in founder mode." You shared really good insight of building credibility as a really good lever to work better with someone like that. Is there anything else you just think as tactics to be effective with founders in founder mode?

**中文翻译:**
对于处于这种位置的人来说，很多人都在为创始人工作，尤其是现在“创始人模式”成了一个热门话题。每个创始人都在说：“我是创始人，你得听我的。这是创始人模式。再说一次，这就是我们赢的方式。我们正处于创始人模式。”你分享了建立信誉是与这类人更好合作的一个很好的杠杆。关于如何与处于创始人模式下的创始人有效沟通，你还有什么战术建议吗？

---

### [00:18:53] Chip Conley

**English:**
Knowing what I know now, I would say, "Lenny, let's do a little pep talk, you and me before the meeting." I want you to start the meeting with the following as you present and Brian's in the room. "Brian, let's talk about what we're trying to accomplish here. Let's get really clear," and you probably did this, but, "let's get really clear on what both, what's the intention of this iteration that we're doing on the product? What defines success, and what do I want to get accomplished in this meeting?"

**中文翻译:**
根据我现在的经验，我会说：“Lenny，开会前咱俩先私下沟通一下。”我希望你在 Brian 也在场的会议开始时这样说：“Brian，让我们谈谈我们在这里试图完成什么。让我们明确一下，”你可能已经这么做了，但是，“让我们明确这次产品迭代的意图是什么？成功的定义是什么？以及我希望在这次会议中达成什么目标？”

---

### [00:19:25] Chip Conley

**English:**
You start with that, because that actually helps to make sure there's alignment. Frankly, if there's not alignment, you might as well not have the meeting. Let's spend the rest of this meeting talking about alignment. That's what I would do, because that's something you can come back to over and over again during the rest of the meeting when Brian or the founder, whomever it is, is beating you up on something, saying like, "Well, let me tell you why it looks like that or why we're doing that." It goes back to that, the three principles or the three key goals we're trying to do with this product update. Yeah, so try to set alignment on the front end.

**中文翻译:**
你以这个开始，因为这有助于确保大家步调一致。坦白说，如果没有达成共识，那这会还不如不开。让我们把剩下的会议时间用来讨论共识。这就是我会做的，因为当 Brian 或创始人（不管是谁）在会议剩下的时间里就某件事责难你时，你可以反复回到这一点，说：“让我告诉你为什么它看起来是那样的，或者我们为什么要那样做。”这又回到了我们这次产品更新试图实现的三个原则或三个关键目标。所以，尽量在开始时就设定好共识。

---

### [00:20:06] Lenny Rachitsky

**English:**
That's an important tip for anyone working with anyone, even. I love just that that works especially well here. Then just going back to the credibility piece, what you shared there is you went on this world tour, not something everyone can do, but just getting really close to your customers, and using that as a, "Hey, I actually know what I'm talking about. You actually should listen to me even though you're the founder."

**中文翻译:**
这对任何与他人合作的人来说都是一个重要的建议。我非常喜欢这一点，它在这里尤其有效。回到信誉的问题，你分享了你进行了全球巡访，虽然不是每个人都能做到，但这种深入接触客户的做法可以作为一种筹码：“嘿，我真的知道我在说什么。即使你是创始人，你也应该听听我的意见。”

---

### [00:20:27] Chip Conley

**English:**
Yeah, I think the other thing is PowerPoint or whatever tool you're using, just be careful about being overly reliant upon it, especially when you have a combustible founder who may take you off path, such that your deck in its current order makes no sense at all. I always wanted to really limit the deck as much as possible, because I didn't know where the meeting was going to go. I wanted the decks helpful at the start, at the very start, to just set principles, set goals. Yeah.

**中文翻译:**
是的，我认为另一件事是 PowerPoint 或你使用的任何工具，要小心不要过度依赖它。特别是当你面对一个“易燃易爆炸”的创始人时，他可能会把你带偏，导致你按顺序准备的幻灯片完全派不上用场。我总是尽量精简幻灯片，因为我不知道会议会往哪个方向发展。我希望幻灯片只在开始时起作用，用来设定原则和目标。

---

### [00:21:09] Lenny Rachitsky

**English:**
This whole story of you joining Airbnb in your fifties is a really good example of intergenerational collaboration, something that you're big on, just the value of having folks that are older working at tech companies. Maybe just talk about that broadly, and then we segue into other elements of your career.

**中文翻译:**
你五十多岁加入 Airbnb 的整个故事是代际协作的一个绝佳例子，这也是你非常看重的一点，即年长员工在科技公司工作的价值。也许可以泛泛地谈谈这个话题，然后我们再转入你职业生涯的其他部分。

---

### [00:21:28] Chip Conley

**English:**
I wrote a book called Wisdom at Work: the Making of a Modern Elder after my Airbnb experience. I did a lot of research. I was like, "Wow, so why do we have less intergenerational collaboration in the workplace, especially in Silicon Valley than we could use?" I started interviewing people, then I started talking to brain scientists, neuroscientists, and realized that a younger brain has fluid intelligence, tends to be fast and focused, really good at problem solving, very good at linearity in terms of looking at things.

**中文翻译:**
在 Airbnb 的经历之后，我写了一本书叫《智慧在工作：现代长者的养成》（Wisdom at Work: the Making of a Modern Elder）。我做了很多研究。我心想：“哇，为什么我们在职场中，特别是在硅谷，代际协作比我们需要的要少得多？”我开始采访一些人，然后开始与大脑科学家、神经科学家交谈，并意识到年轻的大脑拥有“流体智力”（fluid intelligence），往往反应迅速且专注，非常擅长解决问题，在看待事物方面非常有线性逻辑。

---

### [00:21:59] Chip Conley

**English:**
As you get older, the brain shrinks a little bit and you have crystallized intelligence. In crystallized intelligence, what's going on is you're going from left brain to right brain more adeptly. There's a little bit less focus, a little more holistic thinking, systemic thinking, connecting the dots. You can imagine that on a team when you have older brains connecting the dots, thinking broadly, peripherally, younger team members being really fast and focused, and being able to think linearly how to get things done, that combination can either be successful or not.

**中文翻译:**
随着年龄增长，大脑会稍微萎缩，你会拥有“晶体智力”（crystallized intelligence）。在晶体智力中，你能够更熟练地在左脑和右脑之间切换。专注力可能会稍微下降，但会有更多的整体思维、系统思维和连接点滴的能力。你可以想象，在一个团队中，当你有年长的大脑负责连接点滴、进行广泛的外围思考，而年轻的团队成员反应迅速、专注，并能线性地思考如何完成任务时，这种组合要么非常成功，要么完全不行。

---

### [00:22:36] Chip Conley

**English:**
When it's successful. It's brilliant. I think Laura, Laura Modi, Laura Hughes Modi, who was my director of hospitality, but also we worked in so many different capacities with her in the company, I loved working with her because her brain worked different than my brain. That's the opportunity is when you realize that diversity on a team, there's lots of kinds of diversity, but when it comes to brain diversity, not just with neuro diverse people but age diverse people, you get a benefit, an effective benefit that is not as noticeable, quite frankly, in some other diversities.

**中文翻译:**
当它成功时，它是非常精彩的。我想到了 Laura Modi，她曾是我的款待业务总监，我们在公司里以很多不同的身份合作过。我喜欢和她一起工作，因为她的大脑运作方式和我的完全不同。这就是机会所在，当你意识到团队的多样性时——多样性有很多种，但说到大脑的多样性，不仅是神经多样性，还有年龄多样性——你会获得一种非常有效的益处，坦白说，这种益处在其他一些多样性中并不那么明显。

---

### [00:23:16] Chip Conley

**English:**
I found that over and over was really helpful. Part of my job sometimes was to find the blind spot. Again, if you are very focused, one of the things I said to Brian early on was, "I've seen the business plan. Now, I know the goals of how big we want to be in three years." This was very early in my tenure. I said, "But what we really have done, everything we're trying to do is to have no regulations and pay no occupancy tax." Now, hotels pay a bed tax, occupancy tax, we're not paying it, and we're trying to do everything we can not to pay it.

**中文翻译:**
我发现这种互补一再发挥作用。有时我的工作的一部分就是发现盲点。再说一次，如果你非常专注，我早期对 Brian 说过的一句话是：“我看过商业计划书了。现在我知道我们三年后想做多大的目标。”这是在我任职初期。我说：“但我们真正做的是，我们试图做的一切都是为了规避监管和不交占用税（occupancy tax）。”现在酒店要交床位税、占用税，而我们没交，并且正想尽办法不交。

---

### [00:23:51] Chip Conley

**English:**
Knowing that, so for our listeners and viewers to know this, this is something that a guest pays. It's not the host who pays it, the guest pays it. It's part of the bill. If you go and stay in a hotel, there's a big, big tax part of the bill, but it made us more affordable by not having to have our guests pay taxes. Long story short is I said to Brian, "If we're as big as we're going to be three years from now, I promise you we're going to be regulated. I promise you we're going to be paying occupancy taxes. Let's take some proactive steps toward building a strategy for how we're going to be regulated."

**中文翻译:**
为了让听众和观众明白，这种税是由房客支付的，而不是房东。它是账单的一部分。如果你去住酒店，账单中很大一部分是税，但不让房客交税让我们更有价格优势。长话短说，我对 Brian 说：“如果我们三年后真的做到了那么大，我向你保证我们会被监管。我向你保证我们会开始交占用税。让我们采取一些主动措施，制定一套应对监管的策略。”

---

### [00:24:28] Chip Conley

**English:**
That has consistently been Airbnb's biggest challenge is regulation in municipal markets all around the world. If we'd started a little earlier, maybe in New York, maybe in New York, it wouldn't have gotten to the point where it has been toxic in New York for the last dozen years ever since I was there. There's a few other markets in the world where it was like that. I would just say the value in having some age diversity, even when you have an older person reporting to a younger person, is it can be collaborative.

**中文翻译:**
这一直是 Airbnb 最大的挑战：全球各城市市场的监管问题。如果我们早点开始，也许在纽约，情况就不会恶化到过去十几年那种“有毒”的程度。世界上还有其他几个市场也是如此。我想说的是，拥有年龄多样性的价值在于，即使是年长者向年轻人汇报，也可以是非常协作的。

---

### [00:25:02] Chip Conley

**English:**
There was a guy named John Q. Smith, an engineer who I think you probably remember him at Airbnb. This is a guy who looked younger than he was, and he was a little bit nervous about telling people his age. The thing that was great about John is over time, he was not necessarily going to be the best coder at Airbnb. There was a whole new collection of coders coming in every month, but he became a great manager.

**中文翻译:**
有一个叫 John Q. Smith 的工程师，我想你可能记得他在 Airbnb 的样子。这个家伙看起来比实际年龄年轻，他对自己告诉别人真实年龄有点紧张。John 很棒的一点是，随着时间的推移，他未必是 Airbnb 最好的程序员——毕竟每个月都有大批新的程序员进来——但他成了一个伟大的管理者。

---

### [00:25:32] Chip Conley

**English:**
The beautiful thing about moving from the individual contributor to the manager, the person who can actually bring out the best in a bunch of younger people, who may be better technically than he or she is, but they know how to elevate talent. I call this invisible productivity. It's productivity in which you make everybody else around you better. That's something I tried to do with my teams at Airbnb. Ultimately, I had six different teams, five hospitality and five other teams reporting to me. I did my best to just be the kind of person who wasn't solving all the problems, but I was trying to elevate.

**中文翻译:**
从个人贡献者转变为管理者的美妙之处在于，这个人能够激发出一群年轻人的最佳状态，尽管这些年轻人在技术上可能比他更强，但他知道如何提升人才。我称之为“隐形生产力”。这是一种让你周围的所有人都变得更好的生产力。这也是我在 Airbnb 带领团队时试图做的事情。最终，我有六个不同的团队向我汇报。我尽力做一个不只是解决所有问题的人，而是努力去提升他人。

---

### [00:26:11] Chip Conley

**English:**
There's a woman named Lisa Dubost who is at Airbnb, and she, one day, the HR department was reporting to me at one point, and she was running HR. She was 25 and had no background in HR at all. One day she came in to me and she just said, "Chip, you are my confidant." Lisa has a French accent and fluent in French. She said confidant in just the right way. I said, "Oh, well thank you, Lisa." I said to her, "You haven't given me any juicy details yet. A confidant is someone who has the secrets."

**中文翻译:**
Airbnb 有个叫 Lisa Dubost 的女性，有一段时间 HR 部门向我汇报，而她负责 HR。她当时 25 岁，完全没有 HR 背景。有一天她来找我，说：“Chip，你是我的 confidant（知己/亲信）。”Lisa 带着法国口音，法语流利。她用那种恰到好处的方式说了这个词。我说：“噢，谢谢你，Lisa。”我对她说：“但你还没告诉我任何劲爆的细节呢。知己通常是掌握秘密的人。”

---

### [00:26:42] Chip Conley

**English:**
She said to me, "No, in my part of France, a confidant is somebody who gives you confidence." It was like, "Oh, well, maybe that's what a mentor can be is a confidant, someone who gives you confidence and helps by asking questions, helps you as the younger mentee find your roadmap to success."

**中文翻译:**
她对我说：“不，在我的家乡法国，知己（confidant）是那个给你信心（confidence）的人。”我当时想：“噢，也许这就是导师的意义——一个给你信心的人，通过提问来帮助你，帮助你这个年轻的受导者找到通往成功的路线图。”

---

### [00:27:05] Lenny Rachitsky

**English:**
You're sharing a lot of really good examples of the value of older folks being within tech companies. Let me just ask you this, how real is ageism in tech? I ask because a lot of people that are hiring are probably thinking, no, no, I'm not biased. I'm going to hire the best person. If they're someone in their fifties, I'll hire them. No problem. It doesn't feel like it actually works out that way often. Just how real of a problem is this? What do you see?

**中文翻译:**
你分享了很多关于年长者在科技公司价值的极佳例子。我想问你：科技行业的年龄歧视（ageism）到底有多严重？我之所以这么问，是因为很多招聘人员可能会想：“不，不，我没有偏见。我会雇佣最优秀的人。如果他们五十多岁，我也会雇佣。没问题。”但现实中似乎并非总是如此。这个问题到底有多真实？你观察到了什么？

---

### [00:27:27] Chip Conley

**English:**
Yeah, it's clearly a problem. I'd say it's maybe a little bit less of a problem than it was a dozen years ago, because I think a dozen years ago, it was almost a blind spot. In Airbnb, we had a group called Wisdom at Airbnb. It was an employee resource group for people 40 and older. There are lots of these kinds of groups that didn't exist a dozen years ago in all kinds of tech companies, which is good, because it means that there's a voice and a way to congregate with a bunch of people who are older.

**中文翻译:**
是的，这显然是个问题。我会说它可能比十二年前稍微好一点，因为我认为十二年前这几乎是一个盲点。在 Airbnb，我们有一个叫“Airbnb 智慧”的组织。这是一个针对 40 岁及以上员工的资源小组。现在很多科技公司都有这类小组，这在十二年前是不存在的。这是好事，因为这意味着年长者有了发声的渠道和聚集的方式。

---

### [00:28:00] Chip Conley

**English:**
Ultimately, we had these senior nomads come in and be like the voice of the customer for 10 weeks at Airbnb. It was the Wisdom at Airbnb older employee group that really actually pushed for this with Brian. The challenge is, in a world in which the smartest new people, especially when it comes to technical skills and engineering, are coming in with a whole new set of skills that an older person doesn't have, the older person is both expensive and may be perceived as slow. In the era of AI, it's a whole new ballgame.

**中文翻译:**
最终，我们让这些“资深游牧者”来到 Airbnb，作为客户的代言人待了 10 周。正是“Airbnb 智慧”小组向 Brian 极力促成了这件事。挑战在于，在这个世界上，最聪明的新人（特别是在技术技能和工程方面）带着年长者不具备的一整套新技能进来，而年长者既昂贵又可能被认为反应迟钝。在 AI 时代，这又是一个全新的局面。

---

### [00:28:42] Chip Conley

**English:**
The question, I think, will be if what AI cannot do is the human wisdom piece, artificial intelligence and human wisdom might be the balance beams here. Is it possible that older managers who have a little more emotional intelligence, a little more pattern recognition, a little bit more wisdom, can be a value to a company? The jury's still out. There's a New York Times article that just came out about the question of is AI going to wipe out older people's jobs or younger people's jobs? I think the answer is both, but the question is how bad is it for both of them?

**中文翻译:**
我认为问题在于，如果 AI 无法做到的是“人类智慧”这一块，那么人工智能和人类智慧可能会成为这里的平衡木。拥有更高情商、更强模式识别能力和更多智慧的年长管理者，是否能为公司创造价值？目前尚无定论。《纽约时报》刚发表了一篇文章，讨论 AI 是会抹杀老年人的工作还是年轻人的工作。我认为答案是两者都会，但问题是对两者的影响程度有多深？

---

### [00:29:29] Chip Conley

**English:**
I think what I would say to an older person, and when I say older, I mean like 45 or older, if you've done well financially and you're doing okay, the question you might ask yourself is, are you open, as I ultimately was with Brian in my fourth year at Airbnb? I took a substantial pay cut. I think it went down to 40% or 50% time, and my stock, my options were dropped to that level, my salaries dropped to that level, because I didn't want to work full time anymore. There are a lot of people who can be valuable in a company who have some institutional wisdom, some process knowledge of how to get things done in this organization.

**中文翻译:**
我想对年长者（我指的是 45 岁及以上的人）说的是，如果你财务状况良好，你可能会问自己：你是否愿意像我在 Airbnb 第四年对 Brian 那样？我大幅削减了薪水。我想我的工作时间降到了 40% 或 50%，我的股票、期权和薪水也降到了那个水平，因为我不想再全职工作了。公司里有很多非常有价值的人，他们拥有机构智慧，拥有关于如何在这个组织中把事情办成的流程知识。

---

### [00:30:08] Chip Conley

**English:**
In tech companies, that's really important. Airbnb, one of the biggest challenges that Airbnb has always been, how do I get shit done around here? Process knowledge allows you to understand, how do you deal with an org chart and get things done partly because you understand the motivations of different groups? That is something you build over time. Long story short is I just think that older people might look at their workload and say, "I'm willing to take a 20% or a 40% pay cut to go to 80% or 60% time," and the company is going to get their money's worth in that.

**中文翻译:**
在科技公司，这非常重要。Airbnb 最大的挑战之一一直是：我该如何在这里把事情办成？流程知识让你了解如何处理组织架构图并完成任务，部分原因是你理解不同群体的动机。这是随着时间积累出来的。长话短说，我认为年长者可以审视自己的工作量并说：“我愿意降薪 20% 或 40%，转为 80% 或 60% 的工作时间。”公司也会因此觉得物有所值。

---

### [00:30:49] Lenny Rachitsky

**English:**
That's a really interesting point, that if you're older and you're maybe less connected to the most cutting edge ways of building and coding, AI makes that a lot easier in many ways where you start to just talk to it. You don't even need to understand what's happening underneath.

**中文翻译:**
这是一个非常有趣的观点。如果你年纪较大，可能不太熟悉最前沿的构建和编码方式，AI 在很多方面让这变得容易多了，你只需要和它对话。你甚至不需要理解底层发生了什么。

---

### [00:31:05] Lenny Rachitsky

**English:**
There's a lot of listeners who are older in tech, there's a lot of listeners who are approaching midlife, let's say, worried about what happens to their career. When you look at people you've worked with and had at your academy, which we'll talk about, who continue to thrive and continue to have a really healthy career in tech, what do they do differently? What do they have in common that other folks you think should work on and focus on?

**中文翻译:**
有很多听众是科技界的年长者，也有很多听众正步入中年，他们担心自己的职业生涯会发生什么。当你观察那些你共事过的人，或者参加过你的学院（我们稍后会聊到）的人，那些在科技界持续蓬勃发展并拥有健康职业生涯的人，他们有什么不同之处？他们有什么共同点是其他你应该努力和关注的？

---

### [00:31:28] Chip Conley

**English:**
I think this idea being a mentor and a mentor and an intern, there's just the voracious appetite for curiosity. When I talk to someone who's a midlife and wants to be in the tech world or already is, the thing I say is, "Show up with curiosity and a passionate engagement for what you do, and people won't necessarily notice your wrinkles as much as they'll notice your energy." Energy has two parts to it. Energy is, they notice that you are not just sort of resting on your laurels, you have physical energy in how you do your job.

**中文翻译:**
我认为这种既当导师又当实习生的想法，本质上是对好奇心的贪婪渴望。当我与一个想进入或已经在科技界的中年人交谈时，我会说：“带着好奇心和对所做之事的满腔热情出现，人们就不会那么在意你的皱纹，而会注意到你的活力。”活力包含两个部分。一是他们注意到你不仅仅是在吃老本，你在工作中表现出了充沛的体力。

---

### [00:32:04] Chip Conley

**English:**
When people are like that, they're sort of timeless. They're age fluid, as I say. We talk about gender fluidity. Well, there could be age fluidity. They're not defined by their age. The other part of energy that's important is being positive. That's sort of more energetic, a little bit more California energetic. There's a sense of when someone's got good energy, you're drawn to them. It's about showing up with the kind of energy of someone 10 or 20 years younger than you, and then showing up with positive energy.

**中文翻译:**
当人们处于这种状态时，他们就像是永恒的。我称之为“年龄流动性”（age fluid）。我们谈论性别流动性，其实也可以有年龄流动性。他们不被年龄所定义。活力的另一部分是保持积极。这更像是一种能量场，有点像加州式的活力。当某人拥有良好的能量时，你会不由自主地被吸引。这关乎于以比你年轻 10 或 20 岁的人那样的活力出现，并带着正能量。

---

### [00:32:38] Chip Conley

**English:**
I think one of the things that would say I did well at, there's lots of things I didn't do well at Airbnb, but in terms of what I did well is I was very approachable. Over the course of time, the number of mentees I had, the number of people who just wanted to have coffee with me or tea, the number of people who just said, "Thank you for being in that meeting, you just sort of gave it a positive feeling," was really important.

**中文翻译:**
我认为我在 Airbnb 做得好的一点（虽然有很多事我做得不好）是，我非常平易近人。随着时间的推移，我带过的受导者数量，那些只想和我喝杯咖啡或茶的人的数量，以及那些说“谢谢你参加那个会议，你给会议带来了一种积极的氛围”的人的数量，都非常重要。

---

### [00:33:04] Chip Conley

**English:**
My energy, both the positive energy part, and then also the fact that yeah, I could work 60 and 70 hours a week, and I could travel around the world as the Secretary of State of the company, which is what Brian called me a couple times on stage. The fact that I could do that meant that no one was looking at me and saying, "Let's get rid of the old fogey." Well, maybe some people the board, but I wasn't aware of them. I just think show up with that passionate engagement, that curiosity, that energy, the ability to be both the learner and the teacher, with respect for people that are younger than you, and you're going to probably do pretty well.

**中文翻译:**
我的活力，包括正能量部分，以及我每周能工作 60 到 70 小时、能像公司的“国务卿”（Brian 曾在台上几次这样称呼我）一样环球旅行的事实。我能做到这些，意味着没有人会看着我说：“让我们把这个老古董赶走吧。”好吧，也许董事会里有人这么想，但我没察觉到。我只是觉得，带着满腔热情、好奇心、活力，以及既能当学生又能当老师的能力出现，并尊重比你年轻的人，你大概率会做得很好。

---

### [00:33:44] Lenny Rachitsky

**English:**
Today's episode is brought to you by Coda. I personally use Coda every single day to manage my podcast and also to manage my community. It's where I put the questions that I plan to ask every guest that's coming on the podcast. It's where I put my community resources, it's how I manage my workflows. Here's how Coda can help you. Imagine starting a project at work, and your vision is clear, you know exactly who's doing what and where to find the data that you need to do your part.

**中文翻译:**
今天的节目由 Coda 赞助。我个人每天都使用 Coda 来管理我的播客和社区。我会把计划问每位嘉宾的问题放在那里，还有我的社区资源和工作流管理。Coda 是这样帮助你的：想象你在工作中启动一个项目，你的愿景清晰，你确切知道谁在做什么，以及在哪里可以找到完成任务所需的数据。

---

### [00:34:11] Lenny Rachitsky

**English:**
In fact, you don't have to waste time searching for anything because everything your team needs from project trackers and OKRs, to documents and spreadsheets, lives in one tab all in Coda. With Coda's collaborative all in one workspace, you get the flexibility of docs, the structure of spreadsheets, the power of applications, and the intelligence of AI, all in one easy to organize tab. Like I mentioned earlier, I use Coda every single day. More than 50,000 teams trust Coda to keep them more aligned and focused.

**中文翻译:**
事实上，你不需要浪费时间寻找任何东西，因为团队需要的一切——从项目跟踪器和 OKR 到文档和表格——都存在于 Coda 的一个标签页中。通过 Coda 的全方位协作工作区，你可以在一个易于组织的标签页中获得文档的灵活性、表格的结构、应用程序的功能以及 AI 的智能。正如我之前提到的，我每天都用 Coda。超过 5 万个团队信任 Coda，让他们保持步调一致和专注。

---

### [00:34:40] Lenny Rachitsky

**English:**
If you're a startup team looking to increase alignment and agility, Coda can help you move from planning to execution in record time to try for yourself, go to coda.io/Lenny today, and get six months free of the team plan for startups. That's C-O-D-A dot I-O slash Lenny to get started for free, and get six months of the team plan. Coda.io/Lenny.

**中文翻译:**
如果你是一个希望提高一致性和敏捷性的初创团队，Coda 可以帮助你以创纪录的速度从计划转向执行。亲自尝试一下，今天访问 coda.io/Lenny，即可免费获得六个月的初创公司团队计划。

---

### [00:35:03] Lenny Rachitsky

**English:**
Interestingly, curiosity comes up a lot when I ask AI-forward people, what are they focusing on helping their kids learn most? Curiosity is the most common way to describe. At every stage of life, curiosity is something to cultivate. I want to go to the flip side of companies looking to hire. It feels like there's this untapped supply of awesome people that companies with ageism and tech aren't finding and hiring. To help hiring managers and companies take advantage of this, what's something you suggest they do? How do they shift their mindset or maybe shift the way they hire that might help them find these people?

**中文翻译:**
有趣的是，当我问那些走在 AI 前沿的人，他们最注重帮助孩子学习什么时，“好奇心”是最常见的回答。在人生的每个阶段，好奇心都是需要培养的。我想转向另一面：那些寻求招聘的公司。感觉在科技界存在年龄歧视的公司，错过了一大批尚未被发掘的优秀人才。为了帮助招聘经理和公司利用这一点，你有什么建议？他们应该如何转变观念，或者改变招聘方式，从而找到这些人？

---

### [00:35:39] Chip Conley

**English:**
I think we're moving into, there's a book that David Epstein wrote called Range, and the whole premise of range is that we are moving out of the era of the specialists and into the era of the generalists. I think AI is just accelerating this. As we are more reliant upon AI, and AI can be exceptional at technical skills and solutions really expeditiously, I think generalists, people who can think broadly, become all the more important. I think that what I would say to someone in HR or recruiting is beyond what I already said before, is the person passionate?

**中文翻译:**
我认为我们正在进入一个新时代。David Epstein 写过一本书叫《范围》（Range），其核心前提是我们正在走出专家时代，进入通才时代。我认为 AI 正在加速这一进程。随着我们越来越依赖 AI，而 AI 在技术技能和快速解决问题方面表现卓越，我认为通才——那些能够进行广阔思考的人——变得愈发重要。我想对 HR 或招聘人员说的是，除了我之前提到的，还要看这个人是否有激情？

---

### [00:36:23] Chip Conley

**English:**
Are they curious? Are they a learner? Do they have good energy? I would also say, are they a generalist when they're a problem solver? I actually think that's going to be an increasingly important part of how effective companies think broadly. I think that's a key one. I think also, this idea of how do you create intergenerational collaboration in the form of mutual mentorships? One of the things I loved at Airbnb, there were a few people I did this with, where I had something to teach them and they had something to teach me.

**中文翻译:**
他们好奇吗？他们是学习者吗？他们有良好的活力吗？我还会问，他们在解决问题时是否具备通才思维？我真的认为，这将成为高效公司进行全局思考的一个日益重要的部分。我认为这是一个关键点。此外，还有如何通过“互助导师制”建立代际协作？我在 Airbnb 非常喜欢的一点是，我与几个人建立了这种关系，我有东西教他们，他们也有东西教我。

---

### [00:37:02] Chip Conley

**English:**
A good example, my iPhone, so there's 97% of the utility of my iPhone that I probably don't use and don't know how to use. This was back in, let's say, 2013, 2014. There were people who knew iPhone or Google Suites back then. I'd never used a Google Doc back then when I joined Airbnb. There were people who could teach me something technical, and then they wanted to learn something from me, which would be like, "How do you want a great meeting," or, "How do you give a great employee review?" There are a lot of managers who've never been a manager before.

**中文翻译:**
举个好例子，我的 iPhone，大概有 97% 的功能我可能都没用过，也不知道怎么用。那是 2013、2014 年左右。当时有人精通 iPhone 或 Google 套件。我加入 Airbnb 时从未用过 Google Doc。有些人可以教我技术性的东西，而他们想从我这里学到的是：“如何主持一场精彩的会议？”或者“如何进行出色的员工评估？”有很多管理者以前从未当过经理。

---

### [00:37:45] Chip Conley

**English:**
How do you disperse people like me in the organization so that there's usually not enough time for these young managers to come to some training session on how to do a good employee review. You sort of have to do it out there in the field. It's like apprenticeship back in the trades. You're an electrician apprentice, not because you're watching some video on it, you're out there in the field, doing it. That's a huge value in a younger company when you have some older people who have not been vested with the responsibility of managing those younger people.

**中文翻译:**
你如何将像我这样的人分散在组织中？因为这些年轻经理通常没有足够的时间去参加关于如何做员工评估的培训课程。你必须在实战中学习。这就像传统行业的学徒制。你成为电工学徒，不是因为你看视频，而是因为你在现场动手做。在一家年轻的公司里，如果你有一些年长者，他们不一定承担管理年轻人的责任，但他们就在那里提供支持，这就是巨大的价值。

---

### [00:38:23] Chip Conley

**English:**
They may actually be reporting to someone younger than them, but they're there to actually be support. In some ways, I think that was part of the unexpected value that I was able to offer to Airbnb and to Brian specifically, because there are a ton of people in Airbnb who were not even in my departments who would come to me and say, "I'm having a problem. How do I solve this? Can we spend lunch together?" I almost always said yes.

**中文翻译:**
他们实际上可能向比他们年轻的人汇报，但他们的存在是为了提供支持。在某种程度上，我认为这是我能为 Airbnb，特别是为 Brian 提供的意想不到的价值的一部分。因为 Airbnb 有很多人甚至不在我的部门，他们会来找我说：“我遇到了一个问题，该怎么解决？我们能一起吃个午饭吗？”我几乎总是答应。

---

### [00:38:53] Lenny Rachitsky

**English:**
I think the reason people did that in many ways is you just have a very unique aura of wisdom, and it's hard to replicate that, Chip.

**中文翻译:**
我认为人们之所以这么做，在很大程度上是因为你拥有一种非常独特的智慧光环，Chip，那是很难复制的。

---

### [00:39:04] Chip Conley

**English:**
Yes, and it all comes back to the curiosity. If I was just the older elder, dispensing wisdom, people would've gotten bored very quickly. I think the fact, yeah, I was on the board of Burning Man, that's cool. I show up as someone who feels younger than I am. I'm turning 65 this year. The bottom line is I think people lost track of my age, partly because I lost track of my age.

**中文翻译:**
是的，但这都归结为好奇心。如果我只是一个倚老卖老、到处传授智慧的长者，人们很快就会厌烦。我想事实是，是的，我是火人节的董事，这很酷。我表现得比实际年龄更年轻。我今年要 64 岁了。归根结底，我认为人们忘记了我的年龄，部分原因是我自己也忘记了我的年龄。

---

### [00:39:38] Lenny Rachitsky

**English:**
That's such good advice on the front end to be successful as a person kind of getting older in tech is curiosity, positive energy, the way you talked about it, passionate, engagement, is that the term?

**中文翻译:**
对于在科技界逐渐变老的人来说，这真是非常好的建议：保持好奇心、正能量，以及你提到的“充满热情的投入”（passionate engagement），是这个词吗？

---

### [00:39:52] Chip Conley

**English:**
Yep.

**中文翻译:**
是的。

---

### [00:39:53] Lenny Rachitsky

**English:**
Then on the other side is hire generalists. This actually comes up a lot in the AI conversations, just exactly as you said, the power of generalists reminds me, I'm going to this gym now, and the lady there is just like, "I love AI so much, because I'm just such a big picture person, and I am so bad at just getting, thinking about the details, and AI solves all that for me." It's like, "Here, here's what I want to do. I'll do this, move my house to here, here." It's like, "Here's what you need to do, step one, two, three, four, five."

**中文翻译:**
另一方面是雇佣通才。这在 AI 的讨论中经常出现，正如你所说，通才的力量让我想起我最近去的一家健身房，那里的女士说：“我太爱 AI 了，因为我是一个看大局的人，我非常不擅长处理细节，而 AI 帮我解决了所有这些问题。”就像是：“我想做这个，把房子搬到这里。”AI 就会说：“这是你需要做的第一、二、三、四、五步。”

---

### [00:40:18] Chip Conley

**English:**
It is remarkable. Since the time I've known you, how fast it has become dominant in our lives. Yeah, I think one of the last thing I'd say is, look, I'm privileged. For those of you who are listening or watching this and you're saying, "Well, Chip, you were 52 years old and they came to you. That doesn't happen to me. I'm not in that position." The thing I would say is, you're right, but I could have been plucked and brought in and partly as Brian's boy, people would've rejected me, because if I didn't show up the right way, it wouldn't have worked well.

**中文翻译:**
这确实很了不起。自从我认识你以来，AI 占据我们生活的速度太快了。我想说的最后一件事是，听着，我是享有特权的。对于那些正在听或看节目的人，你可能会说：“Chip，你 52 岁时是他们主动找上门的。这种事不会发生在我身上，我没处在那个位置。”我想说的是，你是对的，但我即使被选入并作为 Brian 的亲信带进来，如果我表现得不对，人们也会排斥我，事情也不会进展顺利。

---

### [00:41:00] Chip Conley

**English:**
There are lots of people who Brian brought into the company who didn't work well. I think the key is how do you get the foot in the door? At the end of the day, those second and third order of degrees of separation in terms of networking are still essential. The most important thing is to be able to articulate what you have accomplished in a new way that a recruiter says, "Wow." I really tell people I would love to see a resume.

**中文翻译:**
Brian 带进公司的很多人其实表现并不好。我认为关键在于你如何迈进那道门？归根结底，人脉网络中的二度、三度关联仍然至关重要。最重要的是能够以一种让招聘人员惊叹“哇”的新方式来阐述你的成就。我经常告诉人们，我很想看到一份不一样的简历。

---

### [00:41:41] Chip Conley

**English:**
First of all, the question that I think it was, who was it? Someone asked it, I don't remember if it was Cheryl Sandberg or someone else asked her, who said, "What's the biggest problem you're dealing with here, and how can I help you?" That's a great line. Number two is what I love to see is not so much what roles you've had, what bullet points do you have of your things you've learned? Give me, in a paragraph, a thorny problem you faced. What was the problem, and what skills you used to actually accomplish it, and what was the result of that?

**中文翻译:**
首先，我记得有一个问题——我不记得是谢丽尔·桑德伯格（Sheryl Sandberg）还是别人问的——她说：“你在这里处理的最棘手的问题是什么，我能如何帮你？”这是一句很棒的话。第二，我喜欢看到的不是你担任过什么职位，而是你学到了什么的要点。用一段话告诉我你面临的一个棘手问题。问题是什么，你用了什么技能去解决它，结果如何？

---

### [00:42:22] Chip Conley

**English:**
I would love to see a resume like that. The older you are, the more you can actually have a resume like that. Then you can use that as the conversation piece when you're doing interviews.

**中文翻译:**
我很想看到那样的简历。你年纪越大，就越能写出那样的简历。然后你可以在面试时把它作为谈资。

---

### [00:42:34] Lenny Rachitsky

**English:**
I love that. I love that we're getting into interview advice and resume advice.

**中文翻译:**
我喜欢这个。我喜欢我们聊到了面试建议和简历建议。

---

### [00:42:37] Chip Conley

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:42:38] Lenny Rachitsky

**English:**
Speaking of thorny problems, and also why Brian decided to reach out to you, I want to go back to the beginning of your career.

**中文翻译:**
说到棘手的问题，以及为什么 Brian 决定联系你，我想回到你职业生涯的起点。

---

### [00:42:45] Chip Conley

**English:**
Yes.

**中文翻译:**
好的。

---

### [00:42:46] Lenny Rachitsky

**English:**
Right out of business-

**中文翻译:**
刚从商学院——

---

### [00:42:47] Chip Conley

**English:**
You're good at this, by the way. You're good at this.

**中文翻译:**
顺便说一下，你很擅长主持。

---

### [00:42:49] Lenny Rachitsky

**English:**
I was thinking ahead. Okay, so you're in business school, you left business school, you're like, "Maybe I should start a hotel." Something that rarely works out usually probably leads to a lot of money lost and a lot of frustration and just like, "Okay, what have I done with my life?" Worked out for you.

**中文翻译:**
我一直在思考接下来的话题。好，你在商学院，毕业后你想：“也许我该开家酒店。”这种事很少能成功，通常会导致损失惨重、倍感挫折，然后感叹：“天哪，我这辈子都干了些什么？”但你成功了。

---

### [00:43:07] Lenny Rachitsky

**English:**
Ended up building the second largest boutique hotel chain in the world, Joie de Vivre, beloved. I loved every single experience I've had as Joie de Vivre. When you sold it, I was like, "That is so sad." Talk about just that story. I know this could go on for hours, but what's the-

**中文翻译:**
你最终建立了世界上第二大精品酒店连锁品牌 Joie de Vivre，深受喜爱。我非常喜欢在 Joie de Vivre 的每一次体验。当你卖掉它时，我觉得“太遗憾了”。聊聊那个故事吧。我知道这能聊上好几个小时，但重点是——

---

### [00:43:21] Chip Conley

**English:**
Yeah, I'll be brief.

**中文翻译:**
好的，我会简短点。

---

### [00:43:23] Chip Conley

**English:**
26 years old, couple of years out of Stanford Business School, working for a commercial real estate developer. I was bored silly. I wanted to do something more creative. Bill Graham, famous concert promoter, said to me, because I had gotten to know him, "What San Francisco really needs is a rock and roll hotel." I decided to start looking to find a broken down motel hotel that I could turn into a rock and roll hotel.

**中文翻译:**
26 岁，从斯坦福商学院毕业几年，为一家商业房地产开发商工作。我当时无聊透顶。我想做一些更有创意的事情。著名的音乐会推广人 Bill Graham 因为我认识他，对我打趣说：“旧金山真正需要的是一家摇滚酒店。”于是我决定开始寻找一家破旧的汽车旅馆，把它改造成摇滚酒店。

---

### [00:43:46] Chip Conley

**English:**
I found something in the Tenderloin, and turned it into the Phoenix, which became a famous rock and roll hotel that I have owned for 39 years now. Long story short is that was how I started Joie de Vivre, the company. We grew to 52 hotels around California, became the second largest, as you said, in the world in terms of the number of hotels, boutique hotels that we operated. I loved it till I hated it. In my late forties, I hated it, didn't want to do it anymore. The great recession came along and it was just kicking my ass.

**中文翻译:**
我在 Tenderloin 区找到了一个地方，把它变成了 Phoenix 酒店，它后来成了一家著名的摇滚酒店，我已经拥有它 39 年了。长话短说，这就是我创办 Joie de Vivre 公司的经过。我们在加州发展到了 52 家酒店，正如你所说，按经营的精品酒店数量计算，成为了世界第二大。我曾深爱它，直到我开始厌倦。在我四十多岁快五十岁时，我讨厌这份工作，不想再做了。大衰退（2008年金融危机）随之而来，把我折磨得够呛。

---

### [00:44:23] Chip Conley

**English:**
I really went through a bit of what I now call a midlife chrysalis, but a midlife crisis, where I just wanted to change everything. I got through it. I had an NDE, I had a near-death experience where I had an allergic reaction to an antibiotic and I died. From that point forward, I realized every day is a gift and a bonus, and I decided to sell my company at the bottom of the great recession. That's really how I created this space in my life to be able to join Airbnb.

**中文翻译:**
我经历了一段我现称之为“中年蜕变期”（midlife chrysalis）的阶段，但当时就是“中年危机”，我只想改变一切。我挺过来了。我经历了一次 NDE，也就是濒死体验，当时我对一种抗生素产生了过敏反应，我“死”了过去。从那时起，我意识到每一天都是礼物和奖赏，我决定在大衰退的谷底卖掉我的公司。这正是由于我为生命腾出了空间，才得以加入 Airbnb。

---

### [00:44:58] Lenny Rachitsky

**English:**
Well, let's back up a little bit. This near-death experience, share more there. What happened there?

**中文翻译:**
好，让我们退回一点。关于这次濒死体验，多分享一些。当时发生了什么？

---

### [00:45:04] Chip Conley

**English:**
Yeah, so I write books. I've written seven or eight books, and I had written a book called Peak: How Great Companies Get Their Mojo from Maslow. It was a book that Brian really liked, and part of the reason he wanted to reach out to me. I was on a book tour, I had a broken ankle. I broke my ankle at a bachelor party playing baseball. I ended up with a cut on my leg and the cut on my leg had fertilizer in it and went septic. I was on a very strong antibiotic and I died.

**中文翻译:**
是的，我写书。我已经写了七八本书，其中一本叫《高峰：伟大公司如何从马斯洛那里获得魔力》（Peak）。Brian 非常喜欢这本书，这也是他想联系我的部分原因。当时我正在进行新书巡回宣传，脚踝骨折了。我在一个单身派对上打棒球弄断了脚踝。结果腿上有一个伤口，伤口里沾了化肥，导致了败血症。我服用了一种强效抗生素，然后我“死”了。

---

### [00:45:39] Chip Conley

**English:**
I went flatlined from the allergic reaction to the antibiotic. I saw, it happened nine times over 90 minutes, I kept dying, kept flatlining, yeah. Ended up in the hospital for three days. They finally said, "Listen, it's an allergic reaction, we believe." They thought it was a heart attack, a bunch of stuff, stroke, et cetera. No, it was the allergic reaction. I saw birds. I saw all this beautiful stuff. We don't have time to go into it.

**中文翻译:**
因为对抗生素的过敏反应，我的心跳停止了（平线）。在 90 分钟内发生了 9 次，我不断地死去，心电图不断变平。我在医院住了三天。他们最后说：“听着，我们相信这是过敏反应。”他们起初以为是心脏病发作、中风之类的。不，就是过敏。我看到了鸟，看到了所有这些美好的事物。我们没时间细说了。

---

### [00:46:10] Lenny Rachitsky

**English:**
You did? What?

**中文翻译:**
你真的看到了？看到了什么？

---

### [00:46:11] Chip Conley

**English:**
I did. You want to hear this? Yeah, I saw this beautiful stuff.

**中文翻译:**
我看到了。你想听吗？是的，我看到了非常美好的景象。

---

### [00:46:13] Lenny Rachitsky

**English:**
Let's do it.

**中文翻译:**
讲讲看。

---

### [00:46:15] Chip Conley

**English:**
I think there's a hotel in San Francisco called the Vitale that I built across the street from the ferry building, and it's still there, but it's no longer called the Vitale. In that hotel, there were these slippers in every guest room. One slipper said slow, the other slipper said down. I was wearing these slippers in my flatline thing, flying in the air in a 40-foot tall living room in the Alps, surrounded by birds that were tweeting and chirping at me.

**中文翻译:**
我在旧金山渡轮大厦对面建了一家叫 Vitale 的酒店，它现在还在，但改名了。在那家酒店的每个客房里都有拖鞋。一只拖鞋上写着“Slow”（慢），另一只写着“Down”（下来）。在我心跳停止的幻象中，我穿着这些拖鞋，在阿尔卑斯山一个 40 英尺高的客厅里飞翔，周围全是鸟儿在对我鸣叫。

---

### [00:46:50] Chip Conley

**English:**
I understood bird talk. I understand exactly what they were saying. They kept telling me, "If you slow down, you will see beauty and you will see awe." There was a bunch of other things, but let me just limit it to that and just say, and then the birds would say, "It's time to go." The birds would go out the big window into the mountains, and I would try to follow them. Right as I would get to the window, all of a sudden, I'd come back to life.

**中文翻译:**
我能听懂鸟语。我完全明白它们在说什么。它们一直告诉我：“如果你慢下来，你就会看到美，看到敬畏。”还有很多其他细节，但我先说这么多。然后鸟儿会说：“该走了。”鸟儿飞出大窗户飞向群山，我也试图跟随它们。就在我到达窗边时，突然间，我苏醒了过来。

---

### [00:47:20] Lenny Rachitsky

**English:**
Holy shit. I love that there was a message inside of this experience. I don't know how many people experienced that. Clearly, this led to a big life change. It's interesting that a lot of times, you need something like that. You've been doing this for how many years at that point? Running Joie de Vivre?

**中文翻译:**
我的天。我喜欢这个经历中包含的信息。我不知道有多少人有过这种体验。显然，这导致了巨大的生活转变。有趣的是，很多时候你需要这样的契机。在那之前你做了多少年？经营 Joie de Vivre？

---

### [00:47:38] Chip Conley

**English:**
At that point, I'd been running Joie de Vivre for 22 years.

**中文翻译:**
到那时为止，我已经经营 Joie de Vivre 22 年了。

---

### [00:47:39] Lenny Rachitsky

**English:**
22 years. It's interesting that you need something like that a lot of times. Otherwise, it just momentum just keeps carrying you forward.

**中文翻译:**
22 年。很多时候你确实需要那样的冲击，否则惯性会一直推着你往前走。

---

### [00:47:46] Chip Conley

**English:**
Within two years, I'd sold it, and I had the chance to move on.

**中文翻译:**
两年内，我就把它卖了，并有机会开启新篇章。

---

### [00:47:52] Lenny Rachitsky

**English:**
With building Joie de Vivre, something you've written about a number of times is just the way you built it is a really unique approach to building a business. Specifically, there's a huge focus on culture, which also came out at Airbnb. Talk about just why you see culture as such an important part of how you build a business like tangibly. A lot of people talk about culture, warm, fuzzy stuff, but you think about it very tangibly.

**中文翻译:**
关于建立 Joie de Vivre，你多次写到你建立它的方式是一种非常独特的商业构建方法。具体来说，你非常注重文化，这在 Airbnb 时期也有所体现。谈谈为什么你认为文化是构建业务如此重要的一部分，要具体一点。很多人谈论文化时总觉得是些温馨虚幻的东西，但你的思考非常务实。

---

### [00:48:15] Chip Conley

**English:**
Culture is what happens around here when the boss is not around. The more distributed a company, the more culture is important. The boss is around in a traditional bricks and mortar workplace where everybody shows up at eight and leaves at six, and we all see each other. In my company, in Joie de Vivre, we had 52 hotels, and 25 restaurants, and four spas, and it was distributed. I couldn't be in all those places all the time.

**中文翻译:**
文化就是当老板不在场时，这里发生的事情。公司越分散，文化就越重要。在传统的实体办公场所，老板就在身边，大家 8 点上班 6 点下班，互相都能看见。但在我的公司 Joie de Vivre，我们有 52 家酒店、25 家餐厅和 4 个水疗中心，它是分散的。我不可能时刻出现在所有地方。

---

### [00:48:52] Chip Conley

**English:**
Similarly, with Airbnb, Airbnb had offices around the world and it was a global company. The more distributed you are, of course, in the remote work world we live in, the more culture is important, and more difficult. When you're remote, there's these few cues you have about how we do things around here. They're usually in a digital, virtual format, which is why it's all the more important for you to have in-person gatherings of a team more often if you are virtual.

**中文翻译:**
同样，Airbnb 在世界各地都有办公室，是一家全球性公司。你越分散（当然，在我们生活的远程办公世界中更是如此），文化就越重要，也越困难。当你远程办公时，关于“我们在这里如何做事”的线索非常少。它们通常是以数字、虚拟的形式存在的，这就是为什么如果你是虚拟团队，更频繁地进行线下聚会就显得尤为重要。

---

### [00:49:27] Chip Conley

**English:**
At the end of the day, the reason the culture is important is because it actually helps, it helps guide people in terms of making decisions, but it's also a magnet for the right kind of people. Oracle has a different culture than Apple, which has a different culture than Facebook. You can choose the place you're going to work based upon the culture. There are people who can be very good at what they do, but if they're in the wrong culture, they're in the wrong kind of environment, and they're not willing to shift to fit that culture.

**中文翻译:**
归根结底，文化之所以重要，是因为它能引导人们做出决策，同时它也是吸引合适人才的磁铁。甲骨文（Oracle）的文化与苹果不同，苹果又与 Facebook 不同。你可以根据文化选择工作地点。有些人可能非常擅长自己的工作，但如果他们处于错误的文化中，处于错误的环境中，且不愿改变以适应那种文化，他们就无法发挥。

---

### [00:50:01] Chip Conley

**English:**
We saw it at Airbnb all over and over again. In fact, Airbnb saw it, I think when with Amazon people. Apple people have resonated pretty well at Airbnb, Amazon people, less so. Those are two different cultures, Amazon and Apple. Therefore, understanding a culture before you even actually take the job is one of the more important decisions you need to make is like, "Is this culture a culture that I can live with and maybe influence?" There's language about culture fit.

**中文翻译:**
我们在 Airbnb 一次又一次地看到这种情况。事实上，我认为 Airbnb 在对待来自亚马逊的人时就发现了这一点。苹果的人在 Airbnb 产生了很多共鸣，而亚马逊的人则较少。亚马逊和苹果是两种截然不同的文化。因此，在接受工作之前了解文化是你需要做的最重要的决定之一，比如：“这种文化是我能接受并可能产生影响的吗？”现在有关于“文化契合度”（culture fit）的说法。

---

### [00:50:37] Chip Conley

**English:**
I like to say culture add, because culture fit to me can actually be quite negative toward somebody who is the aberration. You have to fit in. Especially if this is a demographic thing, a person of color, a gay person, a person in a wheelchair, so you have to fit in. A culture add suggests that actually having some diversity on the team is helpful, because it actually adds to the culture. You still have to be able to get along in that culture. Culture is an intangible. That's the problem with it is it's hard to measure, but you see its value and you understand whether it's working based upon employee pulse reports and things like that.

**中文翻译:**
我更喜欢说“文化增益”（culture add），因为对我来说，“文化契合”对于那些与众不同的人来说可能非常负面。你必须“融入”。特别是如果涉及到人口统计学特征，比如有色人种、同性恋者或坐轮椅的人，你必须融入。而“文化增益”意味着团队中的多样性是有益的，因为它实际上丰富了文化。你仍然需要能在那种文化中相处。文化是无形的，这就是它的难点——难以衡量，但你可以通过员工满意度调查之类的方式看到它的价值并了解它是否在发挥作用。

---

### [00:51:24] Lenny Rachitsky

**English:**
You talk about having to understand the culture is such a key part of having success at a company. Do you have any advice for just how to understand the culture for someone interviewing? I don't know. You came in, you work part-time, it's easier to experience it all. Any tips there for, "Okay, this is for me, it's not for me?"

**中文翻译:**
你提到理解文化是在公司取得成功的关键。对于正在面试的人，你有什么建议去了解公司的文化吗？你当时是兼职加入的，更容易体验到一切。有没有什么技巧可以判断“这适合我”或“这不适合我”？

---

### [00:51:39] Chip Conley

**English:**
When you're interviewing, you're also interviewing them. When you're interviewing, it's not about you having to prove yourself. It's also for them to actually prove themselves as a company, and also try to understand if there is some alignment in the company. The kind of questions I would ask as someone who's being interviewed would be, what are three to five adjectives that define this culture? What's the biggest problem in this culture, in terms of something that's just endemic or baked in across the organization?

**中文翻译:**
当你面试时，你也在面试他们。面试不仅仅是证明你自己，也是让他们证明自己作为一家公司的价值，并尝试了解公司内部是否步调一致。作为面试者，我会问的问题包括：用三到五个形容词来定义这种文化？这种文化中最大的问题是什么，即那些在整个组织中根深蒂固或普遍存在的问题？

---

### [00:52:14] Chip Conley

**English:**
Is it ever going to get fixed? How could I come in and maybe help that? Which frankly, at a very junior level, you're not going to be able to help it except for in very minor ways. If you're a senior person, you might be able to help it. Those are the kind of questions I'd want to know. Frankly, if I'm asking that same question about what are the adjectives to multiple people, am I hearing the same thing over and over again? If I'm not, is that because there's not alignment? Is that because different departments have different flavors?

**中文翻译:**
这个问题会被解决吗？我进来后能如何提供帮助？坦白说，如果你是初级职位，你可能帮不上什么大忙。但如果你是资深人士，你也许能有所作为。这些都是我想知道的问题。坦白说，如果我向不同的人问同一个关于“形容词”的问题，我听到的是重复的内容吗？如果不是，是因为缺乏共识吗？还是因为不同部门有不同的风格？

---

### [00:52:48] Chip Conley

**English:**
You could have a culture within a department that's very different than the overall corporate culture. The corporate culture certainly has an enormous oppressive influence, but you can be in a culture, a really great culture of a team or a department, in an overall company culture that's not good. In the long run, that oppressive company culture is either going to have to evolv,e or your department, you may lose people.

**中文翻译:**
一个部门内部的文化可能与整体公司文化大相径庭。公司文化当然有着巨大的压倒性影响，但你可能身处一个非常棒的团队或部门文化中，而整体公司文化却很糟糕。从长远来看，这种压抑的公司文化要么必须进化，要么你的部门可能会流失人才。

---

### [00:53:23] Lenny Rachitsky

**English:**
When I reflect back on the impact you had at Airbnb, one of the funny things I think about is triangles showing up a lot on decks, and specifically rooted in Maslow's hierarchy, just like everything's this Maslow hierarchy metaphor.

**中文翻译:**
当我回想你在 Airbnb 的影响力时，我想到的一件趣事是幻灯片里经常出现三角形，特别是根植于马斯洛需求层次理论的三角形，好像一切都可以用马斯洛层次来比喻。

---

### [00:53:41] Chip Conley

**English:**
True.

**中文翻译:**
确实如此。

---

### [00:53:43] Lenny Rachitsky

**English:**
This one, I don't know, specific piece of this is you have this kind of model you think about for how to help employees be successful at a company. It's kind of rooted in your Peak book philosophy. Maybe just talk about that, and then if there's anything else you want to expand on with this power of thinking through the Maslow hierarchy.

**中文翻译:**
关于这一点，你有一个关于如何帮助员工在公司取得成功的模型。它根植于你的《高峰》（Peak）一书的哲学。也许可以聊聊那个模型，以及关于马斯洛层次思考力量的其他延伸。

---

### [00:54:01] Chip Conley

**English:**
Maslow's hierarchy, basically five levels. Later in life, he had a seven and an eight level model, but at the base is the kind of physical, water, food, air, and you move up to self-actualization at the top. To use this model as a hierarchy of needs for employees, customers, and investors is what the Peak model is about. The Peak, my book. The employee model is really simple. It's money or compensation at the base, recognition in the middle, and meaning at the top.

**中文翻译:**
马斯洛需求层次理论基本上分为五个层级。晚年他提出了七层和八层的模型。底层是生理需求，如水、食物、空气，顶层是自我实现。将这个模型作为员工、客户和投资者的需求层次，就是《高峰》模型的核心。员工模型非常简单：底层是金钱或薪酬，中间是认可，顶层是意义。

---

### [00:54:39] Chip Conley

**English:**
Now, there are some industries and some kinds of jobs in which money is 90% of the pyramid. Just because of the base doesn't mean it's not the dominant part of the pyramid, but the differentiation often is in recognition and meaning. In nonprofits, usually the money piece of it's rather thin. The recognition's this, and meaning's huge. Understanding how do you create an organization, and I gave a TED Talk in 2010 about this topic as well, how do you measure the intangibles of meaning and how do you create an environment where people feel a sense of meaning?

**中文翻译:**
在某些行业和某些工作中，金钱可能占据了金字塔的 90%。底层并不意味着它不是金字塔的主导部分，但差异化往往体现在认可和意义上。在非营利组织中，金钱部分通常很薄，认可度适中，而意义则巨大。了解如何创建一个组织（我在 2010 年也就此做过 TED 演讲），如何衡量“意义”这种无形的东西，以及如何创造一个让人们感到有意义的环境？

---

### [00:55:18] Chip Conley

**English:**
The customer pyramid, briefly, I'll just say that one, is meeting expectations is the base, meeting desires is in the middle, and then meeting unrecognized needs. I think one of the things that we did at Airbnb about a year after I joined, and when Jonathan Goldenhall was joining, is we really tried to ask ourselves, "Are we in the home sharing business, or are we in some kind of business that is even bigger and broader than that?" Ultimately, we came up with the idea that we were in the belong anywhere business.

**中文翻译:**
简短说一下客户金字塔：底层是满足期望，中间是满足欲望，顶层是满足未被察觉的需求。我想我们在我加入 Airbnb 大约一年后（当时 Jonathan Goldenhall 刚加入）做的一件事是，我们努力问自己：“我们是在做房屋共享业务，还是在做某种更宏大、更广泛的业务？”最终，我们提出了一个想法：我们是在做“四海为家”（belong anywhere）的业务。

---

### [00:55:49] Chip Conley

**English:**
Airbnb was not in home sharing, we were in belonging anywhere. Once you have that down, that was sort of the unrecognized need at the top of the pyramid. Then that becomes an organizing principle for how do you teach your hosts to create a sense of belonging? How does our marketing and advertising play up the belonging piece, especially and the everywhere piece, because hotels are not everywhere, but homes are? I would just say that this model, the idea of hierarchies is, I think, very helpful. Yeah, my book Peak has been around for 18 years, but I still am asked to give 20 or 30 speeches a year on it.

**中文翻译:**
Airbnb 不仅仅是房屋共享，我们是关于归属感。一旦确定了这一点，它就成了金字塔顶端未被察觉的需求。然后，这成为了一个组织原则：你如何教房东创造归属感？我们的营销和广告如何突出“归属感”和“无处不在”，因为酒店不是无处不在的，但家是。我想说，这种层次结构的想法非常有帮助。是的，我的《高峰》一书已经出版 18 年了，但我每年仍被邀请就此做 20 到 30 场演讲。

---

### [00:56:30] Lenny Rachitsky

**English:**
Oh, man. This pyramid of comp, recognition, meaning is really interesting, especially these days, because with all this AI researcher poaching, there's all this talk of just like, "Will people just go work wherever they get the most money, or is there a mission and meaning to the work they're doing that will keep them not taking a hundred million dollars offer?" Seems to be happening in a lot of cases, which shows you the power of meaning.

**中文翻译:**
噢，天哪。这个关于薪酬、认可和意义的金字塔真的很有趣，尤其是最近，随着 AI 研究人员的疯狂挖角，大家都在讨论：“人们会仅仅为了钱去工作吗？还是说工作的使命和意义能让他们拒绝一亿美元的邀约？”在很多情况下，后者确实发生了，这向你展示了意义的力量。

---

### [00:56:55] Chip Conley

**English:**
Yeah. If you know you're working for a toxic company, at some point, your conscience kicks in. Whether it's toxic in terms of the purpose of the company, toxic in terms of the leadership or the culture, life is too short.

**中文翻译:**
是的。如果你知道自己是在为一家有毒的公司工作，在某个时刻，你的良知会觉醒。无论是公司目标有毒，还是领导层或文化有毒，生命都太短暂了。

---

### [00:57:10] Lenny Rachitsky

**English:**
Okay. You've had two major shifts in your career. You started the hotel chain, then you went to Airbnb. Most recently, the Airbnb experience, I imagine, led you to starting something called the Modern Elder Academy. Talk about what is the Modern Elder Academy?

**中文翻译:**
好。你的职业生涯经历了两次重大转变。你创办了酒店连锁，然后去了 Airbnb。最近，我猜是 Airbnb 的经历促使你创办了“现代长者学院”。聊聊什么是现代长者学院？

---

### [00:57:28] Chip Conley

**English:**
Yeah, what is going on with that Modern Elder Academy? The Modern Elder Academy. There was a couple times where I was called the Modern Elder at Airbnb, and then I was told that a Modern Elder is someone who's as curious as they are wise. Jonathan Mildenhall, who is the chief marketing officer at Airbnb, used to call me the Modern Elder as well, and he said, "If you ever create a school, Modern Elder would be a good name."

**中文翻译:**
是的，现代长者学院是怎么回事？在 Airbnb 时，有几次我被称为“现代长者”，然后有人告诉我，现代长者是那些既有智慧又充满好奇心的人。Airbnb 的首席营销官 Jonathan Mildenhall 也常叫我现代长者，他说：“如果你以后办学校，‘现代长者’会是个好名字。”

---

### [00:58:27] Chip Conley

**English:**
We now call it MEA because elder is a fraught word on some level, it makes you sound elderly. What I really wanted to create was a place where people could come and do a workshop, they're five day workshops in Baja on the beach, or in Santa Fe on a big four square mile horse ranch, and reimagine and repurpose yourself, and navigate transitions.

**中文翻译:**
我们现在称之为 MEA，因为“长者”（elder）这个词在某种程度上有些沉重，让你听起来像个老人。我真正想创建的是一个让人们可以来参加工作坊的地方。我们在巴哈的海滩或圣达菲一个四平方英里的马场举办为期五天的工作坊，让人们重新想象、重新定位自己，并引导他们度过转型期。

---

### [00:58:52] Chip Conley

**English:**
We go through so many transitions in the middle of our life, let's say between, I define midlife as 35 to 75, guys. It's a very long life stage. We go through a lot of transitions. We are constantly evolving our purpose. We're building our wisdom. We have knowledge management tools out there, but we're the wisdom management tools. We're the tools that help us to get wiser over time, and then we need to reframe our relationship with getting older. Becca Levy has shown at Yale that when you shift your mindset on aging from a negative to a positive, you get seven and a half years of additional life, which is more life than any other biohack that's being done right now.

**中文翻译:**
我们在中年时期会经历很多转型，我将中年定义为 35 到 75 岁。这是一个非常漫长的人生阶段。我们不断演变自己的目标，积累智慧。市面上有很多知识管理工具，但我们是“智慧管理工具”。我们是帮助人们随着时间变得更睿智的工具。我们需要重构与变老的关系。耶鲁大学的 Becca Levy 研究表明，当你将对衰老的看法从消极转为积极时，你的寿命会增加 7.5 年，这比目前任何其他生物黑客技术（biohack）带来的寿命延长都要多。

---

### [00:59:08] Chip Conley

**English:**
That's what we do, and we have 7,000 grads from 60 countries, and 56 regional chapters around the world. It's a bit of a movement, and I teach. I teach some of the workshops, and we have all kinds of famous people who come and teach. For me, creating the world's first midlife wisdom school just feels like the natural next thing for me to do. I love hospitality, so it's a very upscale kind of experience, but we have scholarships. I love retreat centers. I was on the board of the Esalen Institute in Big Sur for 10 years. I love wellness.

**中文翻译:**
这就是我们所做的。我们有来自 60 个国家的 7000 名毕业生，在全球有 56 个地区分会。这有点像一场运动。我亲自授课，也会请各种名人来教课。对我来说，创办世界上第一所中年智慧学校感觉是顺理成章的事情。我热爱款待业，所以这是一种非常高端的体验，但我们也提供奖学金。我热爱静修中心，曾在伊莎兰学院董事会任职 10 年。我热爱健康产业。

---

### [00:59:45] Chip Conley

**English:**
I've owned the Kabuki Springs and Spa for 28 years, which is the largest spa in San Francisco, and I love education. My book, Wisdom at Work: The Making of a Modern Elder, gave me a curriculum in which we've expanded quite a bit with Harvard, Yale, Stanford, and UC, Berkeley professors helping us create a curriculum around midlife. That's how MEA came about.

**中文翻译:**
我拥有 Kabuki Springs and Spa 已经 28 年了，那是旧金山最大的水疗中心。我也热爱教育。我的书《智慧在工作》为我提供了一套课程大纲，后来在哈佛、耶鲁、斯坦福和伯克利教授的帮助下，我们将其扩展成了围绕中年的完整课程。这就是 MEA 的由来。

---

### [01:00:14] Lenny Rachitsky

**English:**
To your point, I forget who said, I think you said Jonathan has said this was a natural next step for you, I completely agree. It's like, looking back, this is the obvious thing you should be doing right now.

**中文翻译:**
就你所说的，我不记得是谁说的了，好像是你提到 Jonathan 说过这是你自然而然的下一步，我完全同意。回过头看，这显然是你现在最该做的事情。

---

### [01:00:22] Chip Conley

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:00:23] Lenny Rachitsky

**English:**
Also, I'm learning more things about you. I didn't know you were involved with the Kabuki Spa. I think Esalen and I knew, you just keep getting more interested.

**中文翻译:**
而且，我学到了更多关于你的事。我以前不知道你还参与了 Kabuki 水疗中心。伊莎兰学院我倒是知道。你真是越来越让人感兴趣了。

---

### [01:00:31] Chip Conley

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:00:32] Lenny Rachitsky

**English:**
There's a couple threads here I want to actually follow. This point you made about shifting your mindset to aging as a positive thing helps you live longer. That's such a powerful point. Can you just speak more to that, just what does that look like?

**中文翻译:**
我想顺着几个思路聊聊。你提到的关于将对衰老的看法转变为积极态度能让你活得更久，这真是一个非常有力的观点。你能多谈谈吗？那具体是什么样的？

---

### [01:00:43] Chip Conley

**English:**
Yeah, there's lots of data points. I'll talk about two. One is this Becca Levy study, which has been going on for 15 to 20 years. If you sort of buy into the ageism of American society or Hallmark cards, when you get a card at age 40, 50, or beyond, there's a belief that life gets worse as you get older. If you can survive your midlife crisis, all you have to look forward to is disease, decrepitude, and death. The bottom line is there's a lot of things that get better with age. I wrote a book called Learning to Love Midlife.

**中文翻译:**
是的，有很多数据支持。我讲两点。一是 Becca Levy 的研究，已经持续了 15 到 20 年。如果你认同美国社会的年龄歧视，或者那些贺卡上的调侃，当你收到 40 岁、50 岁的贺卡时，总有一种“年纪越大生活越糟”的信念。好像如果你能挺过中年危机，剩下的就只有疾病、衰老和死亡了。但事实是，很多事情会随着年龄增长而变好。我写了一本书叫《学会热爱中年》（Learning to Love Midlife）。

---

### [01:01:20] Chip Conley

**English:**
The subtitle says it all: 12 Reasons Why Life Gets Better with Age. What I really wanted to do with that book, which is really, it summarizes the MEA curriculum, I wanted to write a book that sort of helped people to see the upside of aging, the unexpected pleasures of aging. They had a pro-aging, not just an anti-aging point of view. When you actually have a pro-aging point of view and you see the upside of aging, you take better care of yourself, both your mind and your body. You actually are willing to learn and try new things.

**中文翻译:**
副标题说明了一切：生活随年龄增长而变好的 12 个理由。我写这本书（它总结了 MEA 的课程）的初衷是想帮助人们看到变好的那一面，那些意想不到的快乐。拥有一种“亲老”（pro-aging）而非仅仅“抗衰老”（anti-aging）的观点。当你拥有这种观点并看到变老的益处时，你会更好地照顾自己的身心。你实际上会更愿意学习和尝试新事物。

---

### [01:01:51] Chip Conley

**English:**
One of my favorite MEA questions is, 10 years from now, what will you regret if you don't learn it or do it now? It's a powerful question, really important question as we get older. When you're young, you've got all of your life left ahead of you. When I moved to Baja part-time in Mexico at age 56, I had a mindset which was, "I'm too old to learn Spanish. I'm too old to learn to surf," but when I said, "10 years from now, what will I regret if I don't learn it or it now?" I said, "Well, 10 years from now, I might still be living in Baja. I should learn Spanish, I should learn how to surf because we're right next to a surf break."

**中文翻译:**
我最喜欢的 MEA 问题之一是：十年后，如果你现在不学或不做某件事，你会后悔吗？这是一个非常有力量的问题，随着我们变老，它变得尤为重要。当你年轻时，你觉得未来还有大把时间。当我 56 岁搬到墨西哥巴哈兼职居住时，我的心态是：“我太老了，学不会西班牙语了。我太老了，学不会冲浪了。”但当我问自己那个问题时，我想：“十年后我可能还住在巴哈，我应该学西班牙语，应该学冲浪，因为我们就住在浪点旁边。”

---

### [01:02:29] Chip Conley

**English:**
I did. What I believe is that anticipated regret is a form of wisdom, and it's a catalyst for taking action. That's one data point. The other data point is something called the U-curve of happiness, and it's been around for 20 years, and it shows the following. It has changed in the last couple of years because young adults are unhappy like never before. A 20 or a 22-year-old, really unhappy, 24-year-old, really unhappy.

**中文翻译:**
我确实去做了。我相信“预见性的后悔”是一种智慧，它是采取行动的催化剂。这是第一个数据点。第二个数据点是所谓的“幸福感 U 型曲线”，它已经存在 20 年了。过去几年情况有所变化，因为现在的年轻人前所未有地不快乐。20 岁、22 岁、24 岁的人，真的很不快乐。

---

### [01:02:58] Chip Conley

**English:**
Historically, the way it was is you were happy from 18 to 23 or 24, and then around 23 or 24, you start to see a long, slow decline in life satisfaction that actually bottoms out between 45 and 50. I'm sorry to tell you that, Lenny, since you're 44, but your mileage may vary.

**中文翻译:**
从历史上看，你从 18 岁到 23、24 岁是快乐的，然后从 24 岁左右开始，生活满意度会出现漫长而缓慢的下降，并在 45 到 50 岁之间触底。Lenny，我很抱歉告诉你这个，因为你现在 44 岁，但每个人的情况可能不同。

---

### [01:03:17] Lenny Rachitsky

**English:**
You're saying I'm the least happy I'll ever be. That's only upside. That's great. Yeah.

**中文翻译:**
你是说我现在正处于人生最不快乐的阶段。那意味着以后全是上坡路，太棒了。

---

### [01:03:21] Chip Conley

**English:**
Well, here's the part that's weird is that before this research was done, and it's global research across all demographics, what they found was starting around age 50 or 52, you get happier, so that you're happier in your fifties than your forties, sixties, fifties, seventies, happier than sixties, and the women in their eighties, happier than seventies. Wow. It's partly because we are in around 45 to 50, doing this thing called the midlife unraveling, what Brené Brown calls the midlife unraveling.

**中文翻译:**
奇怪的地方在于，这项针对全球所有人口统计数据的研究发现，从 50 或 52 岁左右开始，你会变得更快乐。所以你 50 多岁比 40 多岁快乐，60 多岁比 50 多岁快乐，70 多岁比 60 多岁快乐，80 多岁的女性甚至比 70 多岁时更快乐。哇。部分原因是我们在 45 到 50 岁左右经历所谓的“中年拆解”（midlife unraveling），这是布琳·布朗（Brené Brown）提出的词。

---

### [01:03:55] Chip Conley

**English:**
You're unraveling your expectations, what you define as success, your definition of what a beautiful body looks like, and you're liberated into freedom in your fifties and beyond. I can say that, yeah, I'm happier today at 64 than I was at 47 when I was going through my flatline experience, and not wanting to run my company anymore.

**中文翻译:**
你正在拆解你的期望，拆解你对成功的定义，拆解你对完美身材的定义，然后在 50 岁及以后获得自由。我可以肯定地说，我 64 岁的今天比我 47 岁经历人生低谷、不想再经营公司时要快乐得多。

---

### [01:04:19] Lenny Rachitsky

**English:**
You used this term earlier, the midlife chrysalis, was that what it was?

**中文翻译:**
你之前用过一个词，“中年蜕变期”（midlife chrysalis），是这个吗？

---

### [01:04:22] Chip Conley

**English:**
Chrysalis. Chrysalis, yeah.

**中文翻译:**
Chrysalis（蛹/蜕变期），是的。

---

### [01:04:23] Lenny Rachitsky

**English:**
Chrysalis. What is that? Is that kind of along the same lines?

**中文翻译:**
那是什么意思？也是类似的含义吗？

---

### [01:04:27] Chip Conley

**English:**
If you think about the caterpillar to butterfly journey, midlife is the chrysalis. It's that cocoon in which all of the change is happening. At the time, when you're going through it, it's like, "Oh, shit. My life is liquefying in front of myself." On the other side of it, there's a metamorphosis that happens.

**中文翻译:**
如果你思考从毛毛虫到蝴蝶的旅程，中年就是那个“蛹”。那是所有变化发生的茧。当你身处其中时，你会觉得：“噢，该死，我的生活正在我面前液化。”但在茧的另一端，会发生一场蜕变。

---

### [01:04:48] Chip Conley

**English:**
I like to use the language, in fact, I have a podcast called The Midlife Chrysalis, because I want to help change the dialogue around midlife, so that the number one word attached to midlife is not crisis, but in fact, it's maybe chrysalis, and the idea that life is meant to be transformative during that era.

**中文翻译:**
我喜欢用这个词，事实上我有一个播客就叫《中年蜕变期》，因为我想改变关于中年的对话，让人们提到中年时想到的第一个词不再是“危机”，而是“蜕变”，即生命在那个时代注定是要转型的。

---

### [01:05:09] Lenny Rachitsky

**English:**
That is actually very empowering. I am sort of going through that, not necessarily in this intense way yet, but that might be coming. You said there's a bunch of upsides to getting older. It might be helpful just to share a couple of those things for folks that are like, "Oh, wow, I didn't realize that."

**中文翻译:**
这确实非常给人力量。我似乎也正在经历这个过程，虽然还没那么剧烈，但可能快了。你说变老有很多好处。分享几个具体的好处可能会对那些还没意识到这一点的人很有帮助。

---

### [01:05:23] Chip Conley

**English:**
Emotional intelligence grows with age. Our wisdom can grow with age, although we know 70-year-olds who are not as wise as 30-year-olds, so it's a matter of what you do with your life experience. I define wisdom as metabolized experience, mindfully shared for the common good. What else gets better with age? You learn how to edit. You have no more Fs left to give, no more fucks left to give. That is absolutely true, especially for women as they age.

**中文翻译:**
情商随年龄增长。智慧也可以随年龄增长，尽管我们也见过 70 岁的人不如 30 岁的人睿智，所以这取决于你如何处理你的生活经验。我将智慧定义为“代谢后的经验，为了共同利益而用心地分享”。还有什么会变好？你学会了“编辑”生活。你不再在意那些琐事（no more fucks left to give）。这绝对是真的，尤其是对步入老年的女性。

---

### [01:06:01] Chip Conley

**English:**
You are more spiritually curious. The list is long, and so there are a lot of things that, actually, another one that I love is you're not compartmentalized. When you're younger, you're compartmentalized. As you grow older, you are growing whole, and that means you're alchemizing curiosity and wisdom, introvert, extrovert, masculine, feminine, gravitas, depth, and levity, lightness. The people who I really admire who are 85 years old, they're so present and they're so whole. They are just who they are.

**中文翻译:**
你在精神上会更有好奇心。清单很长。还有一个我非常喜欢的点是：你不再是“碎片化”的。年轻时，你的生活是分块的。随着年龄增长，你变得完整，这意味着你将好奇心与智慧、内向与外向、阳刚与阴柔、庄重与轻盈融合在一起。我真正钦佩的那些 85 岁的人，他们非常有存在感，非常完整。他们就是他们自己。

---

### [01:06:25] Lenny Rachitsky

**English:**
There's a quote I found from you along these lines, the societal narrative on aging is just don't do it.

**中文翻译:**
我找到一句你关于这方面的名言：社会对衰老的叙事就是——别去变老。

---

### [01:06:31] Chip Conley

**English:**
Fantastic. Yeah. We sort of say we don't want to age, but we do want to live. Quite frankly, aging and living are the same thing, as are aging and growing.

**中文翻译:**
太棒了。是的。我们嘴上说不想变老，但我们又想活着。坦白说，变老和生活是同一回事，变老和成长也是。

---

### [01:06:44] Lenny Rachitsky

**English:**
Coming back to MEA, just for folks that are interested, curious about this, who's this for, would you say? Who should seriously look into this program?

**中文翻译:**
回到 MEA，对于那些感兴趣、好奇的人，你会说这是为谁准备的？谁应该认真考虑参加这个项目？

---

### [01:06:52] Chip Conley

**English:**
MEA is really, the people who tend to come to MEA are in the midst of a transition. It could be selling their company, leaving a job, getting divorced, having kids, becoming an empty nester, taking care of parents till they're passing away, having a health diagnosis that's scary. Average age is 54, and it's people of all walks of life. It's not just the tech industry, but it's very popular in the tech industry. It's people who are looking to maybe do a reframe of their purpose, and maybe even a reinvention of their career.

**中文翻译:**
MEA 主要是为那些处于转型期的人准备的。可能是卖掉公司、离职、离婚、生孩子、成为空巢老人、照顾年迈的父母直到他们去世，或者是收到了可怕的健康诊断。平均年龄是 54 岁，来自各行各业。不仅仅是科技行业，虽然它在科技界非常受欢迎。它是为那些想要重新定义目标，甚至重塑职业生涯的人准备的。

---

### [01:07:29] Chip Conley

**English:**
Yeah, the two campuses are just gorgeous. It's been called the Four Seasons meets Blue Zones meets the Esalen Institute, which I like. We have online programs too, and so you don't have to come to either of our campuses in Mexico, or on the beach, or in New Mexico. You can actually do it online.

**中文翻译:**
是的，那两个校园非常美。它被形容为“四季酒店遇见蓝色地带（长寿区）再遇见伊莎兰学院”，我很喜欢这个说法。我们也有在线课程，所以你不必非得去墨西哥的海滩或新墨西哥州的校园，你可以在线参加。

---

### [01:07:54] Lenny Rachitsky

**English:**
Those three, yeah, that's the tagline. That's your tagline right there. Esalen meets Blue Zones, meets what was the first one?

**中文翻译:**
这三个词，没错，这就是你的品牌口号。伊莎兰遇见蓝色地带，遇见……第一个是什么来着？

---

### [01:08:00] Chip Conley

**English:**
The Four Seasons.

**中文翻译:**
四季酒店。

---

### [01:08:01] Lenny Rachitsky

**English:**
The Four Seasons.

**中文翻译:**
四季酒店。

---

### [01:08:02] Chip Conley

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:08:03] Lenny Rachitsky

**English:**
Nailed it. Okay. I'm going to zoom out and take us to a recurring segment on this podcast. I want to see if this goes anywhere, AI Corner, and with AI Corner, ask guests, what's a way that you've found AI useful in your work or in your life, any kind of trick you've learned, any workflow, anything you've found useful?

**中文翻译:**
太贴切了。好，我要切换一下话题，进入我们播客的一个固定环节：AI 角。我想问问嘉宾，你发现 AI 在你的工作或生活中有哪些用处？有没有学到什么技巧、工作流，或者任何你觉得有用的东西？

---

### [01:08:23] Chip Conley

**English:**
Yeah, I have a daily blog. It's called Wisdom Well, and it's on the MEA website. When I'm looking for inspiration, AI does it for me, and ultimately, it gives me a first draft. That's good enough for me then to say, "Okay." There's times when I'm missing the inspiration. I tend to write really well in the morning.

**中文翻译:**
是的，我有一个每日博客，叫《智慧之井》（Wisdom Well），发布在 MEA 网站上。当我寻找灵感时，AI 会帮我，它会给我一个初稿。这对我来说已经足够了。有时候我缺乏灵感，我通常在早上写得最好。

---

### [01:08:47] Chip Conley

**English:**
If it's any other time of the day, I do not like writing creatively. If I have a deadline for tomorrow and it's five o'clock in the afternoon, it's like, "Okay, ChatGPT. I'm on my way to you." I tend to use ChatGPT the most because I don't know, I like Claude as well, but yeah.

**中文翻译:**
如果是在一天的其他时间，我不喜欢进行创意写作。如果我明天有个截止日期，而现在是下午五点，我就会说：“好吧，ChatGPT，我来找你了。”我用 ChatGPT 最多，虽然我也挺喜欢 Claude。

---

### [01:09:03] Lenny Rachitsky

**English:**
Okay, awesome. I was going to ask which tool you use. What's your workflow there? Is it you use voice mode? Do you just type out, "Here's what I'm thinking about, write me a little drop blog post?"

**中文翻译:**
太棒了。我正想问你用哪个工具。你的工作流是怎样的？是用语音模式吗？还是直接打字说：“这是我的想法，帮我写篇短博文”？

---

### [01:09:12] Chip Conley

**English:**
The good news is that at this point, it knows me well enough and my blogs, and I've actually, it knows my weird sense of humor, so it's able to ape me pretty well. I'll just say, "I need a 250 word post on," like today, today's post was a post that ChatGPT helped me with it. I said, "I believe that there's a refrain that needs to happen with the soul. We tend to say, 'I have a soul, or I don't have a soul,' but what if my soul has me? What if in fact, my job is just to be this vehicle for my soul to go to the next lifetime?"

**中文翻译:**
好消息是，到目前为止，它已经足够了解我和我的博客风格，它甚至了解我古怪的幽默感，所以它能模仿得很好。我会说：“我需要一篇 250 字的文章关于……”比如今天的文章就是 ChatGPT 帮我的。我说：“我相信灵魂需要一种重构。我们倾向于说‘我有一个灵魂’，但如果其实是‘灵魂拥有我’呢？如果我的工作只是作为灵魂通往下一世的载体呢？”

---

### [01:09:56] Chip Conley

**English:**
My job is to be this steward of the soul. I said, "Write me something around that." It was just a weird idea. Of course, not all my blog posts are so new age, and I like that. I write a lot on leadership, but that was one that within 30 seconds, I had a 250 word blog post that I then adapted, and there you go.

**中文翻译:**
我的工作是做灵魂的管家。我说：“围绕这个写点东西。”这只是个奇怪的想法。当然，并不是我所有的博文都这么“新纪元”（new age），我也写很多关于领导力的内容。但那一次，30 秒内我就得到了一篇 250 字的博文，然后我稍作修改，搞定。

---

### [01:10:19] Lenny Rachitsky

**English:**
Amazing. Chip, we've covered a lot of ground. We've gone through your entire life. Maybe actually just the tip of the iceberg. With that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
太神奇了。Chip，我们聊了很多。我们回顾了你的一生，虽然可能只是冰山一角。现在，我们进入了非常令人兴奋的闪电问答环节。我有五个问题，准备好了吗？

---

### [01:10:31] Chip Conley

**English:**
Yes. Let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [01:10:32] Lenny Rachitsky

**English:**
First question, what are two or three books that you find yourself recommending most to other people?

**中文翻译:**
第一个问题：你最常向别人推荐的两三本书是什么？

---

### [01:10:38] Chip Conley

**English:**
My favorite book of all time, Man's Search for Meaning, Viktor Frankl in a concentration camp in World War II. When someone's going through a hard time in their life, I say, "Read that book. You'll realize it's not so bad, what you're going through." It also really speaks to this idea of despair equals suffering, minus meaning. I wrote a book called Emotional Equations that was a New York Times bestseller that spoke to this idea that what if you could take all of your emotions and turn them into equations?

**中文翻译:**
我历来最喜欢的书是维克多·弗兰克尔（Viktor Frankl）的《活出生命的意义》，讲述他在二战集中营的经历。当有人生活艰难时，我会说：“读读这本书，你会意识到你所经历的并没那么糟。”它还提到了一个观点：绝望 = 痛苦 - 意义。我写过一本叫《情绪等式》（Emotional Equations）的书，是《纽约时报》畅销书，探讨了如果你能把所有情绪变成等式会怎样。

---

### [01:11:04] Chip Conley

**English:**
Very engineering-minded of me. That's one. I love any book by Liz Gilbert, sort of the opposite. Elizabeth Gilbert wrote Eat, Pray, Love. Her book, she's on faculty at MEA. She teaches here. Big Magic is just a beautiful book about sort of how do you get in the flow to allow the genie to come through you. Her Ted Talk in 2009 was about the fact that genius is not about being the genius yourself. It's about being the receptacle for the genie to come through you.

**中文翻译:**
这很有工程师思维。这是第一本。我也喜欢 Liz Gilbert 的任何书，风格截然不同。她写了《美食、祈祷和恋爱》。她是 MEA 的教员，在这里授课。《大魔力》（Big Magic）是一本关于如何进入心流、让灵感穿透你的美妙书籍。她在 2009 年的 TED 演讲中提到，天才（genius）不是指你本人是天才，而是指你作为承载灵感的容器。

---

### [01:11:44] Lenny Rachitsky

**English:**
I want to come back to this equation you shared. I was going to get to it, but I didn't, so this is a good opportunity to. There's a couple that are really interesting to me. This is, you wrote about these in a book. You have a bunch of these equations about living a happier life. The one you shared is despair equals suffering, minus meaning.

**中文翻译:**
我想回到你分享的那个等式。我本来想聊这个的，现在是个好机会。有几个等式我非常感兴趣。你在书里写过一系列关于更快乐生活的等式。你刚才分享的是：绝望 = 痛苦 - 意义。

---

### [01:12:00] Lenny Rachitsky

**English:**
The implication there is if you want less despair, increase the meaning.

**中文翻译:**
这意味着如果你想减少绝望，就要增加意义。

---

### [01:12:05] Chip Conley

**English:**
That's right.

**中文翻译:**
没错。

---

### [01:12:05] Lenny Rachitsky

**English:**
Or reduce the suffering.

**中文翻译:**
或者减少痛苦。

---

### [01:12:06] Chip Conley

**English:**
Suffering, Buddhist philosophy, the first noble truth of Buddhism is that suffering is ever-present. If suffering's a constant and you have two variables, using some algebra, I guess, you know that if you have more meaning, you have less suffering. That's that one.

**中文翻译:**
痛苦，在佛教哲学中，第一圣谛就是苦谛，即痛苦无处不在。如果痛苦是一个常数，而你有两个变量，用代数逻辑来说，如果你有更多的意义，你的绝望感就会减少。就是这样。

---

### [01:12:25] Lenny Rachitsky

**English:**
The other one that I love is anxiety equals uncertainty times powerlessness. Maybe talk about that one briefly.

**中文翻译:**
另一个我非常喜欢的是：焦虑 = 不确定性 × 无力感。能简短聊聊这个吗？

---

### [01:12:32] Chip Conley

**English:**
98% of anxiety comes from two sources. One is what you don't know, and number two is what you can't control or influence, and based upon social science. You can create an anxiety balance sheet and create four columns. First column is what is it you do know about the thing that's making you anxious? The second column is, what is it you don't know? The third column is what is it you can control or influence? The fourth column is what is it you can't control or influence?

**中文翻译:**
根据社会科学，98% 的焦虑来自两个源头：一是你不知道的事，二是你无法控制或影响的事。你可以创建一个“焦虑资产负债表”，分四列。第一列：关于让你焦虑的事，你知道什么？第二列：你不知道什么？第三列：你能控制或影响什么？第四列：你不能控制或影响什么？

---

### [01:13:01] Chip Conley

**English:**
When you take free-floating anxiety and put it into an equation, it actually makes it more tangible, and you often are less anxious as a result.

**中文翻译:**
当你把那些飘忽不定的焦虑放进一个等式里，它就变得具体了，结果往往是你不再那么焦虑了。

---

### [01:13:11] Lenny Rachitsky

**English:**
Boom. Okay, so if you're feeling anxious right now, this is an exercise you can do and you'll feel less anxious in like five minutes is what I'm hearing.

**中文翻译:**
太棒了。所以如果你现在感到焦虑，这就是你可以做的练习，五分钟内你就会感觉好些。

---

### [01:13:19] Chip Conley

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:13:19] Lenny Rachitsky

**English:**
Okay, excellent. Very, very good nugget of advice. Okay, let's keep going with the lightning round. Come back from our tangent. Do you have a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
太好了，非常有用的建议。让我们继续闪电问答。最近有没有什么你非常喜欢的电影或电视剧？

---

### [01:13:29] Chip Conley

**English:**
Ted Lasso is, I'm a sucker for that show. When it comes to movies, I'm a total movie buff. We have an annual MEA Film Festival at our Santa Fe campus. I would say that the film that I'm most excited about that is coming out that most people have never heard of, it's called I'll Push You. It's the story of two guys, one of whom is in a degenerative health condition and in a wheelchair, and his best friend pushes him the 500 miles of the Camino de Santiago, and it's the relationship they build along that way.

**中文翻译:**
《泰德·拉索》（Ted Lasso），我超级迷这部剧。说到电影，我是个十足的影迷。我们在圣达菲校园每年都有 MEA 电影节。我最期待的一部即将上映、但大多数人没听过的电影叫《我推你》（I'll Push You）。讲的是两个男人的故事，其中一个患有退行性疾病坐轮椅，他的好朋友推着他走完了 500 英里的圣雅各之路，以及他们沿途建立的情谊。

---

### [01:14:08] Lenny Rachitsky

**English:**
Amazing. Very deep cut. Do you have a favorite product that you recently discovered that you really love?

**中文翻译:**
太棒了，很冷门但很有深度的推荐。你最近有没有发现什么特别喜欢的产物？

---

### [01:14:17] Chip Conley

**English:**
Yes. Hair growing material. No. Do you know Viori shorts? I sound like Scott Galloway because he advertises this, but Viori shorts are like, I just love them. They're just breathe and they're comfortable.

**中文翻译:**
有的，生发剂。开玩笑的。你知道 Vuori 短裤吗？我听起来像 Scott Galloway，因为他总给这个打广告，但我真的很喜欢 Vuori 短裤。它们透气且舒服。

---

### [01:14:33] Lenny Rachitsky

**English:**
I'm wearing Viori joggers right now. The one downside of Viori, not to make anyone mad, is they're kind of plasticky if you look at the material. I'm trying to like, I don't know, but I do love, there's nothing better. That's the problem. Anything else like this that is all cotton.

**中文翻译:**
我现在就穿着 Vuori 的慢跑裤。Vuori 唯一的缺点（不想惹恼任何人）是材质感觉有点像塑料。我试着去喜欢它，但确实没有比它更舒服的了。这就是问题所在。

---

### [01:14:50] Lenny Rachitsky

**English:**
I'm a fan. I have many Viori, I don't know if they're called joggers, just, I don't know, weekenders or something. Anyway, love you, Viori. Do you have a favorite life motto that you often come back to and find really useful in work or in life? I imagine you have many, but is there one that comes to mind?

**中文翻译:**
我是它的粉丝。我有很多 Vuori 的裤子。总之，爱你，Vuori。你有没有什么经常想起、且在工作或生活中非常有用的座右铭？我想你肯定有很多，但现在脑海里浮现的是哪一个？

---

### [01:15:07] Chip Conley

**English:**
My favorite one right now is your painful life lessons are the raw material for your future wisdom. The premise of that is that wisdom often comes through the school of hard knocks. When you're in the midst of a really challenging time, you are developing your future wisdom that's going to be valuable to you.

**中文翻译:**
我现在最喜欢的一句是：你痛苦的人生教训是你未来智慧的原材料。其前提是智慧往往来自艰苦的磨练。当你处于极具挑战性的时期时，你正在开发对未来非常有价值的智慧。

---

### [01:15:28] Lenny Rachitsky

**English:**
Okay, final question. You were on the board of Burning Man, or you still are?

**中文翻译:**
好，最后一个问题。你曾是火人节的董事，还是现在依然是？

---

### [01:15:28] Chip Conley

**English:**
I was.

**中文翻译:**
曾经是。

---

### [01:15:28] Lenny Rachitsky

**English:**
Was.

**中文翻译:**
曾经是。

---

### [01:15:34] Chip Conley

**English:**
I helped found the board of Burning Man. Yeah.

**中文翻译:**
我参与创立了火人节董事会。

---

### [01:15:36] Lenny Rachitsky

**English:**
Okay. No big deal. I don't know if you know this, I got married at Burning Man. We had an unofficial wedding there on bicycles, so it's really meaningful to us. I've been there four or five times. What's something about Burning Man that maybe people don't know, some inside story or a really unexpected piece of the journey? I may imagine there's a lot, but what comes to mind?

**中文翻译:**
好，没什么大不了的（笑）。我不知道你是否知道，我是在火人节结婚的。我们在那里举行了一个骑自行车的非正式婚礼，所以它对我们意义重大。我去过四五次。关于火人节，有没有什么人们可能不知道的内幕故事，或者旅程中意想不到的部分？我想肯定有很多，但你现在想到的是什么？

---

### [01:15:55] Chip Conley

**English:**
I would say the best not well-known thing about Burning Man is that Burning Man own owns a place called Fly Ranch. Fly Ranch is about 10 miles from Burning Man. Now, when you go to the Burn, the event around Labor Day, you cannot go over there. It's locked off. It's 3,400 acres. If you look at Fly Ranch, FlyRanch.org, I think it might even be, or it's on the Burning Man site, Fly Ranch is the opposite of Burning Man. Burning Man is this alkaline desert.

**中文翻译:**
我想说，火人节最不为人知的好去处是它拥有一个叫“飞翔牧场”（Fly Ranch）的地方。它距离火人节举办地约 10 英里。当你去参加劳动节期间的火人节活动时，你是不能去那里的，那里是封锁的。它占地 3400 英亩。飞翔牧场与火人节截然相反。火人节是在碱性沙漠中。

---

### [01:16:29] Chip Conley

**English:**
There's no living life there at all. It's very masculine. Fly Ranch is porous, and lots of desert grasses, and hot springs, and hot pools, and birds, and wild horses, and it's one of my favorite hot springs places in the world. Just check it out, and you can go there when it's not during the event. It's quite beautiful.

**中文翻译:**
那里几乎没有生命迹象，非常阳刚。而飞翔牧场则充满生机，有很多沙漠草、温泉、热水池、鸟类和野马，它是我世界上最喜欢的温泉胜地之一。去看看吧，非活动期间你可以去那里，非常漂亮。

---

### [01:16:57] Lenny Rachitsky

**English:**
It feels like it might've inspired MEA in many ways.

**中文翻译:**
感觉它在很多方面启发了 MEA。

---

### [01:17:00] Chip Conley

**English:**
It did, yes.

**中文翻译:**
确实如此。

---

### [01:17:03] Lenny Rachitsky

**English:**
Chip, two final questions. Where can folks find you online, and how can listeners be useful to you?

**中文翻译:**
Chip，最后两个问题。大家可以在哪里找到你？听众能为你做些什么？

---

### [01:17:08] Chip Conley

**English:**
Online, MEAWisdom.com is the website for MEA. My website is ChipConley.com, C-O-N-L-E-Y, and I'm on LinkedIn. That's really, from a social media perspective, the thing that I do the most. I actually take my daily blogs and put them on LinkedIn. Then what your community can do, just come say hi, come check me out. If wisdom's interesting to you, and I think wisdom should be interesting to everybody here, on the MEA website, at the very bottom footer, you'll see a bunch of free resources.

**中文翻译:**
在线上，MEA 的网站是 MEAWisdom.com。我的个人网站是 ChipConley.com。我也在 LinkedIn 上，从社交媒体的角度来看，那是我最活跃的地方。我会把每日博客发在 LinkedIn 上。至于听众能做什么，来打个招呼，关注我。如果你对智慧感兴趣（我认为这里的每个人都应该感兴趣），在 MEA 网站的最底部，你会看到很多免费资源。

---

### [01:17:43] Chip Conley

**English:**
One of them is called Why Successful Leaders Value Wisdom. It is a free resource, and there's also a free resource down there called The Anatomy of a Transition. Those two free resources, understanding how to build your TQ, your transitional intelligence, and understanding how to develop wisdom are two, to my mind, two of the most important modern skills that we can have.

**中文翻译:**
其中一个叫《为什么成功的领导者看重智慧》，是免费的。还有一个叫《转型的剖析》。这两个资源——理解如何建立你的 TQ（转型商/转型智力）以及如何培养智慧——在我看来，是现代人最重要的两项技能。

---

### [01:18:05] Lenny Rachitsky

**English:**
It's funny when you say you're on LinkedIn. It doesn't resonate with me. Chip Conley on LinkedIn, posting on LinkedIn, something about...

**中文翻译:**
你说你在 LinkedIn 上，这让我觉得有点违和。Chip Conley 在 LinkedIn 上发帖，总觉得……

---

### [01:18:13] Chip Conley

**English:**
I don't know. Why? Because I'm a little too Burning Man?

**中文翻译:**
我不知道，为什么？因为我太“火人节”风格了吗？

---

### [01:18:15] Lenny Rachitsky

**English:**
You're just, yeah, exactly. It feels like that's not your vibe, but I love that you do it, because that's where the people are.

**中文翻译:**
是的，没错。感觉那不是你的风格，但我很高兴你这么做，因为那是人们聚集的地方。

---

### [01:18:21] Chip Conley

**English:**
Oh, I put wild, weird stuff up on LinkedIn, and thank God somebody's doing that.

**中文翻译:**
噢，我在 LinkedIn 上发一些狂野、奇怪的东西，谢天谢地总得有人这么做。

---

### [01:18:28] Lenny Rachitsky

**English:**
For some reason, I don't see it. I need to fix that. Chip, this was incredible. Everything I was hoping it'd be, thank you so much for being here and for sharing-

**中文翻译:**
出于某种原因我没刷到，我得去关注一下。Chip，这次谈话太棒了。完全符合我的期待，非常感谢你来到这里并分享——

---

### [01:18:34] Lenny Rachitsky

**English:**
... your wisdom.

**中文翻译:**
……你的智慧。

---

### [01:18:35] Chip Conley

**English:**
I am so proud as I go back, like have your proud Papa who just loves to see you in your element, and I just want to make sure everybody knows the following. Lenny was so good to work with. Whenever you were assigned to a project as a PM, I appreciated it because I just knew that we were going to have great conversations. You're just an interesting dude.

**中文翻译:**
我感到非常自豪，就像你的老爸一样，喜欢看到你在自己的领域发光发热。我想让每个人都知道：Lenny 是一个非常棒的合作伙伴。每当你作为 PM 被分配到一个项目时，我都很高兴，因为我知道我们将会有精彩的对话。你是个非常有趣的人。

---

### [01:19:00] Lenny Rachitsky

**English:**
Well, I appreciate that, Chip. That's going to be the beginning of this whole episode. We're just going to put that up front. Just kidding. That was awesome, Chip. Really appreciate it.

**中文翻译:**
我很感激，Chip。我要把这段放在整集节目的开头。开玩笑的。这太棒了，Chip，真心感谢。

---

### [01:19:01] Chip Conley

**English:**
Thanks.

**中文翻译:**
谢谢。

---

### [01:19:08] Lenny Rachitsky

**English:**
Thanks everyone for listening. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at LennysPodcast.com. See you in the next episode.

**中文翻译:**
感谢大家的收听。再见。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众找到我们。你可以在 LennysPodcast.com 找到所有往期节目或了解更多信息。下期节目见。