# Christian Idiodi - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Christian Idiodi.

---

### [00:00:00] Christian Idiodi

**English:**
I try to explain to people that the real essence of this job is that you wake up on behalf of someone else to solve a problem for them, and you have to do it well enough that they give you something back in return. That's kind of the real essence of it, and that's, I always call it a certificate of appreciation. And it could be in the form of revenue, engagement, loyalty, reference, all of those things. And that's the real essence of this job. If it's not fun, you're probably not doing it right. If it's not hard, you're probably also not doing it right.

**中文翻译:**
我总是试着向人们解释，这份工作的真正本质是：你代表他人醒来，去为他们解决问题，而且你必须做得足够好，好到他们愿意给你一些回报。这就是它的核心本质，我常称之为“认可证书”。这种回报可以是收入、参与度、忠诚度、推荐，或者是所有这些东西。这就是这份工作的真谛。如果它不让你感到有趣，你可能做得不对；如果它不让你感到艰难，你可能也做得不对。

---

### [00:00:35] Lenny

**English:**
Today, my guest is Christian Idiodi. Christian is a partner at Silicon Valley Product Group, alongside Marty Cagan, who when he introduced us, called Christian the most interesting man in the world. After meeting him, I tend to agree. After a long career in product, Christian now spends his time working closely with companies, big and small, implementing and improving their discipline of product management. In our conversation, we discuss why the product management field is so often disliked and what you can do to avoid becoming a product manager people don't want on their team. We spend a lot of time on coaching, how to get better at coaching your reports, how to get better coaching from your manager, and some really clever tactics for building trust with leaders within your company. Also, Christian shares his one favorite go-to method, out of all of the discovery methods out there, for figuring out what to build.

**中文翻译:**
今天的嘉宾是 Christian Idiodi。Christian 是硅谷产品集团（SVPG）的合伙人，与 Marty Cagan 共事。Marty 在介绍我们认识时，称 Christian 是“世界上最有趣的人”。在见到他之后，我也倾向于认同这一点。在经历了长期的产品职业生涯后，Christian 现在致力于与大大小小的公司密切合作，实施并改进他们的产品管理规范。在我们的对话中，我们讨论了为什么产品管理领域经常不受待见，以及你可以做些什么来避免成为那种团队不欢迎的产品经理。我们花了很多时间讨论“教练辅导”（Coaching），包括如何更好地辅导你的下属，如何从你的经理那里获得更好的辅导，以及一些在公司内部与领导建立信任的巧妙策略。此外，Christian 还分享了在所有产品探索（Discovery）方法中，他最推崇的、用于确定该构建什么产品的方法。

---

### [00:01:23] Lenny

**English:**
Also, we spend some time on the great work that he's doing at Silicon Valley Product Group. He's been doing a lot of great work on the product management field in Africa to help product builders and founders build great companies. That and so much more Christian is awesome. With that, I bring you Christian Idiodi, after a short word from our sponsors.

**中文翻译:**
此外，我们还花了一些时间讨论他在硅谷产品集团所做的卓越工作。他在非洲的产品管理领域做了大量工作，帮助那里的产品开发者和创始人建立伟大的公司。除此之外还有很多精彩内容，Christian 真的很棒。在听完赞助商的简短介绍后，让我们欢迎 Christian Idiodi。

---

### [00:01:38] Lenny (Sponsor: Jira Product Discovery)

**English:**
You fell in love with building products for a reason. But sometimes the day-to-day reality is a little different than you imagined. Instead of dreaming up big ideas, talking to customers and crafting a strategy, you're drowning and spreadsheets and roadmap updates, and you're spending your days basically putting out fires. A better way is possible. Introducing Jira Product Discovery, the new prioritization and roadmapping tool built for product teams by Atlassian. With Jira Product Discovery, you can gather all your product ideas and insights in one place and prioritize confidently, finally replacing those endless spreadsheets. Create and share custom product roadmaps with any stakeholder in seconds. And it's all built on Jira, where your engineering team's already working. So true collaboration is finally possible. Great products are built by great teams, not just engineers. Sales, support, leadership, even Greg from finance, anyone that you want can contribute ideas, feedback, and insights in Jira Product Discovery for free. No catch. And it's only $10 a month for you. Say goodbye to your spreadsheets and the never-ending alignment efforts. The old way of doing product management is over. Rediscover what's possible with Jira Product Discovery. Try for free at Atlassian.com/lenny.

**中文翻译:**
你爱上构建产品是有原因的。但有时日常现实与你的想象大相径庭。你没有在构思伟大的创意、与客户交谈或制定战略，而是淹没在电子表格和路线图更新中，整天都在“救火”。其实有更好的方法。向您介绍 Jira Product Discovery，这是由 Atlassian 为产品团队打造的全新优先级排序和路线图工具。通过 Jira Product Discovery，您可以将所有产品创意和洞察集中在一处，并自信地确定优先级，最终取代那些没完没了的电子表格。只需几秒钟即可与任何利益相关者创建并共享自定义产品路线图。它完全构建在 Jira 之上，而这正是您的工程团队已经在使用的平台。因此，真正的协作终于成为可能。伟大的产品是由伟大的团队打造的，而不仅仅是工程师。销售、支持、领导层，甚至是财务部的 Greg，任何你想要的人都可以免费在 Jira Product Discovery 中贡献创意、反馈和洞察。没有套路。对你来说每月只需 10 美元。告别电子表格和永无止境的对齐工作。旧的产品管理方式已经结束。通过 Jira Product Discovery 重新发现无限可能。请访问 Atlassian.com/lenny 免费试用。

---

### [00:02:59] Lenny (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Calm, Quora and Modern Treasury trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs and get ready for audits in weeks, not months. By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA and many more, Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time, Lenny's podcast listeners get $1,000 off Vanta. Go to Vanta.com/Lenny to learn more and to claim your discounts. Get started today. Christian, thank you so much for being here and welcome to the podcast.

**中文翻译:**
本期节目由 Vanta 为您带来，Vanta 帮助您简化安全合规流程，加速业务增长。成千上万家快速成长的公司，如 Gusto、Calm、Quora 和 Modern Treasury，都信任 Vanta 来帮助构建、扩展、管理和展示其安全合规计划，并在几周而非几个月内做好审计准备。通过提供最受青睐的安全和隐私框架（如 SOC 2、ISO 27001、GDPR、HIPAA 等），Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5000 家快速成长的公司使用 Vanta 自动完成 SOC 2 及其他框架高达 90% 的工作。在限定时间内，Lenny 的播客听众可享受 Vanta 1000 美元的优惠。访问 Vanta.com/Lenny 了解更多信息并领取折扣。今天就开始吧。Christian，非常感谢你能来到这里，欢迎参加我们的播客。

---

### [00:04:03] Christian Idiodi

**English:**
Thank you for having me, Lenny. It's a joy to be here.

**中文翻译:**
谢谢你邀请我，Lenny。很高兴来到这里。

---

### [00:04:06] Lenny

**English:**
It's a joy to have you here. So Marty Cagan introduced us, a colleague of yours at Silicon Valley Product Group. And the way he described you is he considers you the most interesting man in the world. Did you know that that's how he thinks about you?

**中文翻译:**
很高兴你能来。Marty Cagan 介绍了我们认识，他是你在硅谷产品集团的同事。他形容你是“世界上最有趣的人”。你知道他是这么看你的吗？

---

### [00:04:18] Christian Idiodi

**English:**
I didn't. I consider him one of the most interesting people in the world too.

**中文翻译:**
我不知道。我也认为他是世界上最有趣的人之一。

---

### [00:04:22] Lenny

**English:**
You guys are so kind to each other. I wanted to start with this trend I've been noticing in product management and the perception of product management. It feels like, I don't know if this is new or if it's always been around, but it feels like there's this trend of people just not liking product managers. There's trend of founders feeling like they should wait a long time to hire their first product manager. There's a lot of teams that wish they didn't have a product manager in their team. We don't have this person telling us what to do. I'm curious just why you think there's often this dislike of product managers. And then for PMs listening, do you have any advice for just how to not become a product manager people don't like and don't want on their team?

**中文翻译:**
你们对彼此评价真高。我想从我在产品管理领域观察到的一个趋势以及人们对产品管理的看法开始。感觉——我不知道这是新现象还是由来已久——似乎有一种人们就是不喜欢产品经理的趋势。创始人倾向于认为应该等很久才雇佣第一个产品经理。很多团队甚至希望自己团队里没有产品经理，这样就没人告诉他们该做什么。我很好奇，为什么你认为产品经理经常招人烦？对于正在收听节目的产品经理们，你有什么建议，教他们如何避免成为那种别人不喜欢的、不想留在团队里的产品经理？

---

### [00:04:59] Christian Idiodi

**English:**
I think most people don't like product managers often because they haven't experienced good product managers. The core of product management is competency-based, meaning there is someone in an organization that represents the customer the best, that has a deep knowledge of the customers and your users, that has a deep knowledge of your data, your industry, your business and the product itself. And because of this competence, you kind of trust them to make decisions because if you have a problem that says, say we want more customers, it makes a lot of sense to go to the person that is an expert in customers to say, "Help me solve this problem." What you see happening in many organizations is that there is kind of this misperception displaced influence and mistrust because of the poor competency, meaning I feel I know more about the business or I know more about the customer or the data. And so why should I not tell you what to do?

**中文翻译:**
我认为大多数人不喜欢产品经理，通常是因为他们还没见过优秀的产品经理。产品管理的核心是基于能力的（competency-based），这意味着组织中需要有人最能代表客户，对客户和用户有深刻理解，对数据、行业、业务以及产品本身了如指掌。正是因为这种能力，你才会信任他们去做决策。因为如果你有一个问题，比如“我们想要更多客户”，那么去找一个客户专家说“帮我解决这个问题”是非常合乎逻辑的。但在许多组织中，你看到的是一种误解、错位的影响力和不信任，这源于能力的匮乏。也就是说，我觉得我比你更懂业务、更懂客户或数据，那我凭什么不直接告诉你该怎么做呢？

---

### [00:06:03] Christian Idiodi

**English:**
And I think people fail to understand that this role is, it's a team spot. They are part of a team of people working together to discover a solution we're building and in a way that works for our company. And so I think when I think through the companies I've worked with, where I see this discipline really eroded is where there is just not a competent level of product management. The way I describe it to a CEO, I'll ask him, "Tell me who you trust in your company to make a decision on what markets we go to, what things we do." And they always have some senior leader, some VP, some person. And I say, "Why? Oh, Bob has been here a long time. He knows everybody. Everybody loves him and trusts him. He understands our business." And I often say to him, I say, "Well, Bob said put up manager." And it's often interesting to executives when I try to explain that way. I say that's the competent level that we're talking about here. Imagine if you had Bob's on every team. Imagine how much you can accomplish. So one, I don't really think it's... I often say it's not the hate for product management, it's a hate for the understanding of what they have experienced in product management, which are people that are not able to deliver results that help them meet the outcomes they want.

**中文翻译:**
我认为人们没能理解这个角色其实是一项“团队运动”。他们是团队的一员，共同探索我们正在构建的解决方案，并确保其符合公司的利益。所以当我回顾合作过的公司时，我发现产品管理这一职能真正被削弱的地方，往往是缺乏胜任水平的产品管理。我通常会这样向 CEO 描述：我会问他，“告诉我，在你的公司里，你信任谁来决定我们要进入哪个市场、要做哪些事情？”他们总会提到某个资深领导、某个副总裁或某个人。我会问，“为什么？”他们会说，“哦，Bob 在这里很久了，他认识所有人，大家都喜欢并信任他，他懂我们的业务。”我经常对他说，“其实 Bob 就是一个产品经理。”当我这样解释时，高管们通常会觉得很有趣。我说，这就是我们所说的胜任水平。想象一下，如果每个团队都有一个 Bob，你能成就多少大事？所以，我不认为这是对产品管理的仇恨，而是对他们所经历过的“产品管理”的厌恶——即那些无法交付成果、无法帮助他们实现目标的人。

---

### [00:07:23] Christian Idiodi

**English:**
So if I were advising product managers, I often say, look, when we see sales or executive driven product management where we see these alternatives to product management, it's not a cultural knock or a leadership knock, it's really on the individual and the discipline has to elevate itself to a place that it earns the right to make a decision on what we do.

**中文翻译:**
所以如果我要给产品经理建议，我会说，当我们看到销售驱动或高管驱动的产品管理，或者看到产品管理的替代方案时，这并不是文化或领导层的问题，这实际上取决于个人。这个职能必须提升到这样一个高度：它能够赢得决定“我们该做什么”的权利。

---

### [00:07:45] Lenny

**English:**
I have exactly the same perspective. When people say they don't like product managers, exactly what I tell them is, you just haven't worked with a great product manager. A great PM makes everything easier for you. If you want to be a PM, people would hate to lose on their team. I would never want to lose Christian on my team as a PM. Is there something they could do maybe or change to become that person?

**中文翻译:**
我的观点完全一致。当人们说他们不喜欢产品经理时，我告诉他们的正是：你只是还没和优秀的产品经理合作过。一个优秀的 PM 会让你的工作变得更轻松。如果你想成为那种团队舍不得失去的 PM——比如我绝不想失去 Christian 这样的 PM——他们可以做些什么或者改变什么来成为那样的人？

---

### [00:08:06] Christian Idiodi

**English:**
Well, I was just joking with someone earlier. I said, "I've only seen great product managers come out of two places. One, either a series of massive failure in their career or experiences that have been bad or from learning from great product leaders." The reality of this kind of role, it's kind of like if you have all kinds of... maybe you're like on a sport, like a quarterback on a team, you need to practice product management to be good at product management. You're not going to get mastery by avoiding some of these elements. And we've kind of clearly defined what you need to represent to a company for them to trust you. So there is this period of humility that I challenge all product managers to have, this period of learning, recognizing what you do not know.

**中文翻译:**
我刚才还在和人开玩笑。我说，“我只见过优秀的产品经理从两个地方产生：要么是职业生涯中经历过一系列巨大的失败或糟糕的体验，要么是向优秀的产品领导者学习。”这种角色的现实情况是，就像你在体育运动中一样，比如团队里的四分卫，你需要通过实践产品管理来变得擅长产品管理。你不可能通过逃避这些要素来获得精通。我们已经清楚地定义了你需要向公司展示什么才能赢得信任。因此，我挑战所有产品经理都要经历一段“谦逊期”，一段学习期，去承认自己不知道的东西。

---

### [00:09:35] Christian Idiodi

**English:**
And what you do not have is the trust of an organization or even in yourself that you know the customer, the business or the data better than anybody else. What you need to do is quickly try to accelerate that. You're going to find the loudest, most influential person in your organization, the person that everybody knows, knows everything, is in every meeting and stuff, and you're going to ask them to teach you. You're going to challenge them. And if they don't have the time to teach you, you're going to volunteer to help them. I'm going to intern for you. You're going to get permission from your manager and say, "Look, I want to spend time with Lenny. He's the head of sales, he's the head of operations and stuff. I just want to learn from him." Now, what you're doing is you're extending that person's trust to yourself. You're also building a relationship with that person. But more importantly, you're learning what is driving that person's influence, which is their competence in the business or the customer.

**中文翻译:**
你现在缺乏的是组织对你的信任，甚至是你对自己“比任何人都更了解客户、业务或数据”的信心。你需要做的是迅速加速这个过程。去找到组织中最有话语权、最有影响力的人，那个大家都知道他无所不知、参加所有会议的人，请他教你。去挑战他们。如果他们没时间教你，你就自愿去帮他们。说“我来给你当实习生”。去征得你经理的同意，说：“我想花点时间跟着 Lenny，他是销售主管，也是运营主管，我只想向他学习。”现在，你所做的是将那个人的信任延伸到你自己身上。你也在与那个人建立关系。但更重要的是，你正在学习是什么驱动了那个人的影响力，即他们在业务或客户方面的胜任能力。

---

### [00:09:51] Christian Idiodi

**English:**
After you've done that, you have to keep doing discovery because what's going to be different now is that person knows they've taught you everything that they know, but everybody now sees you learning every single day. So at some point, people will recognize that you might have more insights and more data than anybody else, and they will only know this because they've seen you learn from the best and they've seen you continuing to learn. So I always practically advise product managers in this kind of scenario, build relationships with people. You earn their trust by asking them to do two things. One, you're either going to teach me or I'm going to help you. And you're going to build relationships there, gain experience with them. You've got to immerse yourself in the deeper understanding of the business and the data.

**中文翻译:**
做完这些之后，你必须继续进行产品探索（Discovery）。因为现在情况不同了，那个人知道他已经把所知的一切都教给了你，而大家现在看到你每天都在学习。因此，在某个时刻，人们会意识到你可能比任何人都拥有更多的洞察和数据，而他们之所以知道这一点，是因为他们亲眼看到你向最优秀的人学习，并看到你持续不断地进步。所以我总是务实地建议处于这种情境下的产品经理：与人建立关系。通过要求他们做两件事来赢得信任：要么你教我，要么我帮你。在那里建立关系，积累经验。你必须让自己沉浸在对业务和数据的深度理解中。

---

### [00:10:38] Lenny

**English:**
Wow, there's a lot there. Because this is awesome. This is exactly, I think what people want to hear is how do you become better and how do you become more trusted and respected? So things you're recommending to PMs that want to become better, less disliked, more successful. I just took some notes as you were talking. One is there's a sense of becoming more full stack in the company, like understand the business, not just there's your one product and here's your one goal. And then this idea of just be always learning, which is both you are learning things and also people see that you're learning and see that you really care about a lot of the parts of the business that maybe you wouldn't naturally be inclined to understand. And that also helps you build relationships. And also just this really important point of if you know more than anyone else, people will innately trust you and respect you and want you on the team because you happen to have a lot of answers.

**中文翻译:**
哇，信息量很大。这太棒了。我觉得这正是人们想听到的：如何变得更好，如何变得更受信任和尊重？你给那些想变得更优秀、更受欢迎、更成功的 PM 提了建议。在你说话时我做了一些笔记：第一是要在公司里变得更“全栈”，比如理解整个业务，而不仅仅是盯着你那一个产品和那一个目标。第二是“终身学习”的理念，这不仅意味着你在学东西，也意味着让别人看到你在学习，看到你真正关心业务中那些你可能本不会去关注的部分，这也有助于建立关系。最后是非常重要的一点：如果你比任何人都懂得多，人们会自然而然地信任和尊重你，并希望你在团队中，因为你恰好掌握了很多答案。

---

### [00:11:25] Christian Idiodi

**English:**
Yes.

**中文翻译:**
没错。

---

### [00:11:26] Lenny

**English:**
Awesome. Kind of on a similar thread, something that Silicon Valley product group has is a really good definition of what a product manager's job is. And I thought it'd be cool just to spend a little time here. There's these four attributes you guys like to share. Can you just talk about that, as a little foundational?

**中文翻译:**
太棒了。顺着这个思路，硅谷产品集团对产品经理的工作有一个非常好的定义。我想花点时间聊聊这个。你们经常分享四个属性，能作为基础知识讲讲吗？

---

### [00:11:40] Christian Idiodi

**English:**
I kind of mentioned before, a product manager is in a team sport, so they work as part of a team to uncover a solution, what to build. And every time you solve a problem, there's inherent risk involved. There's the risk of will people buy this or will they choose it or will they choose to use it, which is all a value type of risk. There's the risk of can they use it, which is a usability type of risk. The risk that we can build it to have the skills to build it or the time to build this, that's a feasibility risk. And the risk of it working for our business, which is a viability risk.

**中文翻译:**
我之前提到过，产品经理参与的是一项团队运动，所以他们作为团队的一员来发掘解决方案，决定构建什么。每当你解决一个问题时，都存在内在风险。包括：人们会买吗？他们会选择它吗？或者他们会选择使用它吗？这都是“价值风险”（Value risk）。还有他们会用吗？这是“易用性风险”（Usability risk）。我们能造出来吗？我们是否有技术能力或时间去建造？这是“可行性风险”（Feasibility risk）。以及它是否符合我们的业务利益？这是“商业可行性风险”（Viability risk）。

---

### [00:12:14] Christian Idiodi

**English:**
I cannot call out the product manager's competency. It's really to try to drive the first and the last one, which is value and viability. A solution worth building, something people will buy, choose or use, and one that works for our business, which is at the core of what product teams do, solve a problem in a way customers will love and a way that works for our business. It's why the product manager gets all the rap of, if everything goes great, a great team effort, if everything goes wrong, they blame the product manager. It's because people hold them accountable to results. Nobody wants to work on something nobody wanted in the first place and your job is to ensure that we are working on something people want in the first place.

**中文翻译:**
我必须强调产品经理的能力。其核心是驱动第一项和最后一项，即“价值”和“商业可行性”。一个值得构建的解决方案，必须是人们会购买、选择或使用的，并且必须符合我们的业务利益。这就是产品团队的核心工作：以客户喜爱的方式和符合业务利益的方式解决问题。这就是为什么产品经理总是处于这种境地：如果一切顺利，那是团队的功劳；如果出了问题，大家就责怪产品经理。这是因为人们要求他们对结果负责。没人想去开发一个从一开始就没人想要的东西，而你的工作就是确保我们正在开发的东西是人们真正想要的。

---

### [00:12:49] Christian Idiodi

**English:**
And it is such an amazing role. I try to explain to people that the real essence of this job is that you wake up on behalf of someone else to solve a problem for them. And what an amazing job. There's just no greater... I cannot think of a better discipline with such inherent permission to solve problems on behalf of someone. And you have to do it well enough that they give you something back in return. That's the real essence of it, and that's the, I always call it a certificate of appreciation. And it could be in the form of revenue, engagement, loyalty, reference, all of those things. And that's the real essence of this job. If it's not fun, you're probably not doing it right. If it's not hard, you're probably also not doing it right.

**中文翻译:**
这是一个非常了不起的角色。我试着向人们解释，这份工作的真谛在于：你代表他人醒来，为他们解决问题。这是多么棒的一份工作啊。没有比这更伟大的了……我想不出还有哪个学科拥有这种与生俱来的、代表他人解决问题的许可。而且你必须做得足够好，好到他们愿意给你回报。这就是它的真谛，我常称之为“认可证书”。它可以是收入、参与度、忠诚度、推荐等形式。这就是这份工作的本质。如果它不有趣，你可能做错了；如果它不艰难，你可能也做错了。

---

### [00:13:51] Lenny

**English:**
Wow, I love that frame of reference of you're giving something to customers and your success is measured by do they give something back in return, which is basically do they pay for your product? Such a beautiful way to think about that. Oh, man. Okay. So just to summarize these four elements, there's value, usability, viability, feasibility to understand if the product they're building hits all these attributes.

**中文翻译:**
哇，我非常喜欢这个参考框架：你为客户提供东西，而你的成功取决于他们是否给你回报，这基本上就是指他们是否为你的产品买单。这种思考方式太美妙了。天呐。好的，总结一下这四个要素：价值（Value）、易用性（Usability）、商业可行性（Viability）、技术可行性（Feasibility），以此来了解所构建的产品是否具备这些属性。

---

### [00:14:15] Christian Idiodi

**English:**
That's right. You're trying to uncover a solution and you know you've solved the problem when you get those two things, something customers love, they give you something back, and our business can support it in some ways. And I'm calling out, these are the different risks in our kind of taxonomy, how we call the things you have to tackle. And it's a team sport, and so there are these four risks of should we build it, will people use it, will people buy it, will our customers support it or our business support it? And you're trying to answer those questions with a designer and a product engineer.

**中文翻译:**
没错。你正在发掘一个解决方案，当你实现这两点时，你就知道你解决了问题：一是客户喜爱并给予回报，二是我们的业务能够以某种方式支持它。我所说的是我们分类法中的不同风险，也就是你必须应对的事情。这是一项团队运动，所以存在这四个风险：我们该造它吗？人们会用吗？人们会买吗？我们的客户或业务能支持它吗？你需要与设计师和产品工程师共同回答这些问题。

---

### [00:14:52] Lenny

**English:**
Of these four, so value, usability, viability, feasibility, where do you think most new PMs fail most or should spend more time?

**中文翻译:**
在这四个要素中——价值、易用性、商业可行性、技术可行性——你认为大多数新 PM 最容易在哪里失败，或者应该在哪个方面花更多时间？

---

### [00:15:00] Christian Idiodi

**English:**
Oh my goodness, value. Value is probably, it is the most important and the most overlooked. And the big driver for that is often because of the operating model of teams. Teams are often given roadmaps of projects and features to go build and deliver. If that's the case, you actually really don't need a product manager because they're going to assume value. If the boss told me to build this, I cannot say, "Should we build this? Is this the right thing to build? Is there a better option? Is this what people will buy?" You just assume it's valuable.

**中文翻译:**
天呐，绝对是“价值”。价值可能是最重要但也最容易被忽视的。这背后的主要驱动因素通常是团队的运作模式。团队通常被给予一份包含项目和功能的路线图去构建和交付。如果是这种情况，你其实根本不需要产品经理，因为他们会“预设价值”。如果老板让我造这个，我不能问：“我们该造这个吗？这是正确的东西吗？有更好的选择吗？人们会买吗？”你只是假设它是价值的。

---

### [00:15:57] Christian Idiodi

**English:**
So value is often the hardest thing to solve and must be overlooked. We often see bad patterns where companies will say, "Yes, we ran a test, with 300 users and they all scored it 84% or 90%. They love it." In that way. I said, "Well, just because somebody can use your product doesn't mean that they will buy it. Just because they can use it doesn't mean they will choose it. Just because they can use it doesn't mean that they will actually use it." And what people say is often different from what they do. And our job is to actually solve the problem, which is what core value is, in a meaningful way. And often overlooked because we check the box on our own item. So the most important, because that's to the point of the certificate of appreciation, what you get in return, that's the ultimate outcome. Really, value.

**中文翻译:**
所以价值往往是最难解决的，也最容易被忽视。我们经常看到一些糟糕的模式，公司会说：“是的，我们对 300 名用户进行了测试，他们的评分都在 84% 或 90% 以上。他们很喜欢。”对此我会说：“仅仅因为有人‘会用’你的产品，并不意味着他们会‘买’它。仅仅因为他们会用，并不意味着他们会‘选择’它。仅仅因为他们会用，并不意味着他们‘真的会去用’。”人们所说的往往与他们所做的不同。我们的工作是以一种有意义的方式真正解决问题，这才是核心价值所在。但由于我们只是在完成任务清单，这一点经常被忽视。所以价值是最重要的，因为它是“认可证书”的关键，是你获得的回报，是最终的结果。

---

### [00:16:55] Lenny

**English:**
You once gave a talk along these lines around discovery, and it was this talk of here's all of the things you can do to help understand what to build to make something valuable. There's a billion frameworks for every step of the discovery process, press releases, story mapping, opportunity solution, trees, fake door tests, all these things. And you're like, if we had to pick one thing, if there's one process or approach that you recommend most, your answer was essentially finding some number of reference customers to work with and helping them and working with them to design the product. Do you still see that as the one, if you had to pick one approach to figure out what to build? And if so, you just talk about how you recommend going about that.

**中文翻译:**
你曾经做过一个关于产品探索（Discovery）的演讲，提到了为了理解如何构建有价值的东西，你可以做的所有事情。在探索过程的每一步都有无数的框架：新闻稿、故事映射、机会解决方案树、虚假门测试（Fake door tests）等等。而你当时说，如果必须选一个，如果你最推荐一个流程或方法，你的答案基本上是：寻找一定数量的“标杆客户”（Reference Customers），与他们合作，帮助他们并与他们共同设计产品。如果你现在必须选一个方法来确定该构建什么，你仍然认为这是首选吗？如果是的话，请谈谈你建议如何实施。

---

### [00:17:35] Christian Idiodi

**English:**
The holy grail of product walk is really a reference customer. This is somebody that has used your solution or your product, loves it enough to tell people about it. I kind of described the work of the product team is to solve problems in a way that customers love and a way that works for our business. The ultimate definition for me today of the love that somebody has for our product is they're willing to put their reputation on the line by telling people about it.

**中文翻译:**
产品工作的“圣杯”确实是标杆客户。这是指那些使用了你的解决方案或产品，并且非常喜爱它，以至于愿意告诉别人的人。我之前描述过，产品团队的工作是以客户喜爱且符合业务利益的方式解决问题。对我来说，今天一个人对产品“喜爱”的终极定义是：他们愿意以自己的名誉担保，向他人推荐这个产品。

---

### [00:18:39] Christian Idiodi

**English:**
And for me, if we think about you do a lot of interviews with founders and entrepreneurs and you're going to have people that they find a market with an idea and they jump in. But if you think at the core of some of these founder-inspired businesses where the founder will say, "Well, I had a problem and it was their problem and they focused on solving the problem and then they got their friends on it." And so it's almost like this idea that if they were their own first reference customer. They were so close to the problem, immersed in the environment of the problem, solved it in a compelling way enough where it was like, there are more people like me.

**中文翻译:**
对我来说，如果你去采访很多创始人和企业家，你会发现有些人是带着一个想法进入市场的。但如果你看那些由创始人灵感驱动的业务核心，创始人会说：“我有过一个问题，那是他们的问题，他们专注于解决那个问题，然后让他们的朋友也用上了。”这就像是他们自己就是第一个标杆客户。他们离问题非常近，沉浸在问题的环境中，并以一种足够令人信服的方式解决了它，以至于发现“还有更多像我一样的人”。

---

### [00:19:39] Christian Idiodi

**English:**
And it is like if I said to you, "Lenny, let's go to a steakhouse. Find me a new steakhouse around you." You might go online and Google and you see a steakhouse with one review. How do you feel about that? I don't know. Maybe other people don't want to try this. You see two reviews, you're like, maybe it's the chef and their spouse or something. The question is how many positive reviews would you have to see to jump and say, "Let's go try this one." There are some things inherent in, if you look at Geoffrey Moore's adoption curve and those kinds of models in here, most people don't want to be the first to try things. But you are likely to try things if other people that look like you have accepted it or defined it as good.

**中文翻译:**
这就像如果我对你说：“Lenny，我们去吃牛排吧。帮我找一家你附近新开的牛排馆。”你可能会上网搜索，看到一家只有一条评论的牛排馆。你感觉如何？我不知道，也许别人不想尝试。如果你看到两条评论，你会想，也许是厨师和他配偶写的。问题是，你需要看到多少条好评才会跳起来说：“走，去试试这家。”这其中有一些内在的逻辑，如果你看杰弗里·摩尔（Geoffrey Moore）的采用曲线（Adoption curve）之类的模型，大多数人不想成为第一个尝试的人。但如果其他和你类似的人已经接受了它或定义它为“好”，你就更有可能去尝试。

---

### [00:20:39] Christian Idiodi

**English:**
And so the whole essence for me of this technique is to create those first people, those reference customers. If you think about how companies make the shift to becoming sales-led or operations-led, almost all companies start product-led. The product is first. You kind of build something and it's like, yeah, it's going, let's hire salespeople and marketing people and operational people to do it. What's really happening is that the product team created the first customers. And now a group of people have to capture the value that was created.

**中文翻译:**
所以对我来说，这种技术的本质就是创造第一批人，即那些标杆客户。如果你思考公司如何转型为销售驱动或运营驱动，你会发现几乎所有公司最初都是产品驱动的。产品第一。你造出了一些东西，它运行得不错，然后雇佣销售、市场和运营人员来推广。实际发生的是，产品团队创造了第一批客户，现在一群人需要去捕捉已经创造出来的价值。

---

### [00:20:44] Christian Idiodi

**English:**
So what's happening here is that it is constantly the job of product teams. The reason they lose influence is because salespeople are having to sell a product. You see? So they're like forcing back, "I need this and I need this." But if you came to me and said, "I want to buy steak," and I say, "Let me show you 20 people that look like you that recommend this steakhouse," my job as a salesperson is very easy. I'm just like, "Hey, you should eat here. Everybody that loves steak, they all eat here." So product teams feel, at this contract to an organization when they don't create powerful reference customers. So it's by far my favorite technique.

**中文翻译:**
所以这里的情况是，这始终是产品团队的工作。他们失去影响力的原因是销售人员不得不费力去“推销”产品。你看，销售会反过来逼产品：“我需要这个功能，我需要那个功能。”但如果你来找我说“我想买牛排”，而我说“让我给你看 20 个和你一样的人，他们都推荐这家牛排馆”，那我作为销售的工作就非常简单了。我只需要说：“嘿，你应该在这儿吃，所有爱吃牛排的人都在这儿吃。”如果产品团队不能创造出强大的标杆客户，他们在组织中就会感到这种契约上的无力感。所以到目前为止，这是我最喜欢的技术。

---

### [00:21:36] Christian Idiodi

**English:**
And the way this technique works is you want to discover and deliver and develop who has the problem, the customer. I want to discover who has the problem. At the same time, discover and deliver a solution to this problem. The idea here is that if you really want to solve a problem, you need to get out of your building. Go spend time with someone that has the problem and don't leave until you solve the problem. People talk about why we had such a record time to the Covid vaccine. Sure, technology has improved, our research has improved. But if you think about it, we had the highest number of volunteers for vaccination in the history of any vaccine in the history of time. Why? Did we have to look for someone with Covid? No, they were literally all around us. The research was immersed in the environment of the problem.

**中文翻译:**
这种技术的运作方式是：你想要发现、交付并培养那些有问题的客户。我想发现谁有问题，同时发现并交付解决这个问题的方案。这里的核心理念是，如果你真的想解决一个问题，你需要“走出办公室”。去花时间陪陪那些有问题的人，直到你解决了问题再离开。人们谈论为什么新冠疫苗的研发速度创下了纪录。当然，技术进步了，研究水平提高了。但如果你仔细想想，我们拥有历史上任何疫苗研发过程中数量最多的接种志愿者。为什么？我们需要到处去找新冠患者吗？不，他们就在我们身边。研究工作完全沉浸在问题的环境中。

---

### [00:22:15] Christian Idiodi

**English:**
They could study... and so this is often what I call, it's almost like a pressure-cooked discovery in some ways. If you truly, truly want to solve a problem, get out of your building, get out of the assumptions, get out of your opinions. Immerse yourself, find someone who has the problem, stick with them until you discover a solution for this problem. And you're going to do that. The part of why I love this technique, the two biggest reasons I think, the first is if I cannot find a certain number of people that have this problem, my goodness, it might not be a problem, but solve it. I have never had a product failure using this technique. If I were to credit... goodness, I think last count, I'm up to like 205 products I have worked on or participated in creating in my career. And I tried to build a new product every year from scratch. It's kind of a crazy thing about me. My friends know what I want for my bad day is a problem worth solving. And I like to go from idea to revenue, and the setup, and I test all of these techniques in this way. And everybody knows my favorite technique is if we find a problem worth solving, we need to uncover a solution for B2B, I want six to eight references, for B2C, I want maybe 15 to 25 references as an indication that we've achieved product market fit.

**中文翻译:**
他们可以进行研究……所以这通常被我称为，在某种程度上就像是“压力锅式”的探索。如果你真的、真的想解决一个问题，走出办公室，抛弃假设，抛弃成见。让自己沉浸其中，找到那个有问题的人，跟着他们，直到你发现解决这个问题的方案。你必须这样做。我之所以喜欢这种技术，有两个最大的原因：第一，如果我找不到一定数量的有这个问题的人，天哪，那这可能根本不是一个值得解决的问题。使用这种技术，我从未经历过产品失败。如果我要算一下……天哪，我想上次统计时，我职业生涯中参与或主导创造的产品已经达到了 205 个。我尝试每年从零开始构建一个新产品。这是我比较疯狂的一点。我的朋友们知道，在我糟糕的日子里，我想要的是一个值得解决的问题。我喜欢从创意走到收入，并在这个过程中测试所有这些技术。大家都知道我最喜欢的技术是：如果我们发现了一个值得解决的问题，我们需要发掘一个解决方案——对于 B2B，我需要 6 到 8 个标杆客户；对于 B2C，我可能需要 15 到 25 个标杆客户，以此作为我们实现“产品市场匹配”（Product-Market Fit）的指标。

---

### [00:23:15] Lenny

**English:**
Just to be clear, you said you still work, you build products yourself and you practice this and you've built... okay, what's like every recent product that you've built? I didn't know this.

**中文翻译:**
澄清一下，你说你现在还在工作，自己构建产品并实践这些方法，而且你已经构建了……好吧，你最近构建的产品都有哪些？我以前不知道这个。

---

### [00:23:25] Christian Idiodi

**English:**
So I do a lot of work in Africa now. WorkNigeria is like a job board that helps people. We do kind of a job board HR replacement and advisory too as well. I'm actually working on another app around the NDA and protecting high-asset individuals in some ways. So kind of every year, I find a problem like that worth solving and I practice doing the work of discovery with a team of people.

**中文翻译:**
我现在在非洲做了很多工作。WorkNigeria 就像一个帮助人们找工作的招聘板。我们也做类似 HR 替代方案和咨询的工作。实际上我还在开发另一个关于 NDA（保密协议）和保护高资产人士的应用程序。所以基本上每年我都会找一个这样值得解决的问题，并带领团队实践产品探索工作。

---

### [00:24:03] Lenny

**English:**
Okay, amazing. So just to summarize some of these points, which are really great and I've never heard it described this way before. So basically, a really effective way to understand how to build something people actually want and solve real problems is this idea of pick reference customers. And I really like this word reference, which is not just they're going to help you build a thing, but they're also become a reference to future customers because they end up loving it because you built it for them and they love it. Your advice is find six to eight in B2B space, 15 to 25 in B2C. And the reason there's a number here is if you find just one or two, you never know, they might be just the one or two that have this really weird problem that no one else has. And I think that's usually the flaw in this approach is you end up building it for a small number of people and nobody else really wants it. And it sounds like in your experience, this is a good kind of number where probably a lot of more people will have this problem.

**中文翻译:**
好的，太棒了。总结一下这些观点，它们非常精彩，我以前从未听过这样的描述。基本上，理解如何构建人们真正想要的东西并解决实际问题的一个非常有效的方法就是：选择“标杆客户”。我很喜欢“标杆”（Reference）这个词，这不仅意味着他们会帮你构建产品，而且他们还会成为未来客户的参考，因为你为他们量身定制，他们最终会爱上它。你的建议是在 B2B 领域找 6 到 8 个，在 B2C 领域找 15 到 25 个。之所以有这个数字，是因为如果你只找一两个，你永远不知道他们是否只是那一两个有着没人遇到的怪异问题的人。我认为这种方法通常的缺陷在于，你最终只为极少数人构建了产品，而其他人并不想要。听起来根据你的经验，这是一个很好的数字区间，能确保可能有更多人面临同样的问题。

---

### [00:24:53] Christian Idiodi

**English:**
Yeah. There've been studies to validate some of these numbers. I think early, IBM, kind of struggled selling those supercomputers. And if you're buying a million dollar computer, someone says, "Hey, do you want to buy?" And you're like, "I don't know. Is there anybody else that has bought it? Shall I be the first?" And there was this common question of what would it take for you to buy it? And someone says, "Hey, if I see five or six people that look like me already have this, then I feel confident making the argument to my company, we should jump on it." And it's like, so how do I create the first five to six? And you can see a lot of the validation on B2C in some of the things you might see in the App Store on Yelp or those places. My idea here is if you found a steakhouse with 25 5-star reviews, you are likely to adopt this.

**中文翻译:**
是的。已经有一些研究验证了这些数字。我想早期 IBM 在销售超级计算机时遇到过困难。如果你要买一台价值百万美元的电脑，有人问：“嘿，你想买吗？”你会想：“我不知道。还有别人买过吗？我该做第一个吗？”当时有一个普遍的问题：怎样你才愿意买？有人说：“嘿，如果我看到五六个和我类似的人已经拥有了它，那我就有信心向公司提议我们也买一台。”那么，我该如何创造出这前五六个客户呢？在 B2C 领域，你可以在 App Store 或 Yelp 等地方看到很多验证。我的想法是，如果你发现一家牛排馆有 25 条五星好评，你很可能会去尝试。

---

### [00:25:41] Christian Idiodi

**English:**
So in every app I have ever put on the App Store, on the day I launch the app in the app store, they are 25 5-star reviews. I will never launch an app and be like, "Let's hope Lenny loves it. Let's see who the first person." On the very first day of launching the app, there are 25... so I will know I am not ready until I have achieved 25 people that have told me, worked with me and said, "I am now ready to put my reputation the line." Sometimes I might need to work with 30 people or 50 people because the output is 25 reference customers. Because if Lenny is like, "I don't love it enough" or "I don't feel comfortable," I'm not going to customize for Lenny. I'm going to find my single target market, talk to more people. If I get 25, I have achieved product market fit.

**中文翻译:**
所以我放到 App Store 上的每一个应用，在发布当天，都会有 25 条五星好评。我绝不会发布一个应用然后想：“希望 Lenny 会喜欢，看看谁是第一个用户。”在发布的第一天，就有 25 个……所以我知道，直到我有 25 个人告诉我、与我合作并说“我现在准备好用我的名誉担保了”，我才算准备好。有时我可能需要与 30 人或 50 人合作，因为最终产出是 25 个标杆客户。因为如果 Lenny 说“我不够喜欢”或“我觉得不舒服”，我不会为了 Lenny 去定制。我会寻找我的单一目标市场，与更多人交谈。如果我得到了 25 个，我就实现了产品市场匹配。

---

### [00:26:29] Lenny

**English:**
So interesting. It basically kicks in this word of mouth flywheel that everyone's always looking for is how do I get people to talk about it. Build it for them, solve their problems, tell them that it exists. You mentioned a bit about how you understand if it's actually, let's call a product market fit, if you have product market fit with these people that you ask them if they're going to leave you a 5-star review for example. I guess what do you consider this is good, I got one more person that's really happy with this? What tells you it's got product market fit with a person?

**中文翻译:**
太有意思了。这基本上启动了每个人都在寻找的“口碑飞轮”：如何让人们谈论它。为他们构建，解决他们的问题，告诉他们产品的存在。你提到了一点关于如何理解是否实现了产品市场匹配，比如你问他们是否愿意给你留五星好评。我想知道，你如何衡量“这很好，我又多了一个对产品非常满意的人”？什么迹象告诉你产品与某个人实现了匹配？

---

### [00:26:55] Christian Idiodi

**English:**
If I were thinking about how I will do this, pick a problem to solve, first of all, I have to know who I'm solving the problem for. And in some indication and I want to validate that this is actually a problem you do have. And I'm looking for a certain type of person. These early adopters in our world are broken up to technologists and evangelists. Technologists could be, "I love the new iPhone 16 is coming out and it's going to have five cameras and I write an article in some tech review board. Super fast, super sleek, all good design." You just love new technology. You always jump on new technology. And evangelist could be someone that says, "Oh my, I look great with the iPhone 15, it has three cameras. I will look phenomenal with the iPhone 16, so I'm going to go stand in line at the Apple Store for three hours or overnight because I just can't wait to get my hands on the Apple 16."

**中文翻译:**
如果我考虑如何做这件事，首先选一个要解决的问题，我必须知道我在为谁解决问题。并且我想要验证这确实是你面临的问题。我正在寻找特定类型的人。在我们的世界里，这些早期采用者分为“技术专家”（Technologists）和“布道者”（Evangelists）。技术专家可能是：“我喜欢即将推出的 iPhone 16，它会有五个摄像头，我要在技术评论板上写篇文章。超快、超薄、设计精良。”你就是热爱新技术，总是第一时间尝试。而布道者可能是那种说：“天哪，我用 iPhone 15 看起来很棒，它有三个摄像头。用 iPhone 16 我会看起来更非凡，所以我要去苹果店排队三小时甚至过夜，因为我等不及要拿到它了。”

---

### [00:27:53] Christian Idiodi

**English:**
They may feel a little irrational, but those are the kind of people you're looking for, people that believe they have a problem. So it's like you will try any steakhouse, in my example. You're just like, "I love steak. I don't care if there are reviews or not. I'll try it." And what I'm trying to do here is I'm saying, okay, Lenny loves steak, he wants to try a steakhouse. And I'm good to say, "Lenny, I'm trying to build the best steakhouse here. If I create a menu that you absolutely love, are you willing to tell people about it?" That could be a video testimonial, write a review, stuff like that. And it's okay Lenny, if you don't love the first iteration of it and stuff like that, I want to hear your feedback. I want you to work with me in ensuring that I build the best steakhouse here. And that's kind of the idea.

**中文翻译:**
他们可能看起来有点不理智，但这就是你要找的人——那些坚信自己有问题需要解决的人。就像在我的例子中，你会尝试任何牛排馆。你只是觉得：“我爱牛排，我不在乎有没有评论，我会去试。”我在这里要做的是说：“好吧，Lenny 爱牛排，他想尝试牛排馆。”我会说：“Lenny，我正努力在这里打造最好的牛排馆。如果我设计了一份你绝对喜爱的菜单，你愿意告诉别人吗？”这可以是视频证言、写评论之类的。Lenny，如果你不喜欢第一个版本也没关系，我想听听你的反馈。我希望你和我一起工作，确保我在这里建成最好的牛排馆。这就是核心思想。

---

### [00:28:37] Christian Idiodi

**English:**
So I'm going to work with 25 people that look like you and I'm going to keep tweaking, in this sense iterating on the product and the menu until Lenny's like, "My goodness, this is the best steakhouse in the world." It is like I'm just going to write about it and when I get 25 people that have all, it's not the steakhouse, they love it enough. Because this is where you really get the shift in value. Because if I say, "Lenny, go write me a review, a five-star review." You're like, "I don't know if I feel comfortable about." You say, "Why not?" You see, I'm really going to get deeper feedback because people will say or do anything just to avoid hurting our feelings or for us to get out of their face. So they'll be like, "Yeah, yeah, yeah, I'll give you a five-star review." But when I say do it, you're like, "Well, I have this hesitation." Why? That's really where great discovery comes. But it's hard to in a silo. You have to be immersed with the person that has the problem. So product market fit is when you iterate it in this discovery, you've discovered and delivered something so meaningful that these customers that are your target customers, are willing to put their reputation on the line and be a reference. That's my indication.

**中文翻译:**
所以我会和 25 个像你这样的人合作，不断调整、迭代产品和菜单，直到 Lenny 说：“天哪，这是世界上最好的牛排馆。”然后他就会去写评论。当我得到 25 个这样的人时，不仅仅是牛排馆本身，而是他们足够喜爱它。因为这才是价值发生转变的地方。如果我只是说：“Lenny，去给我写个五星好评。”你会觉得：“我不知道我是否觉得自在。”我会问：“为什么不呢？”你看，我真的会得到更深层的反馈，因为人们有时会为了不伤我们的感情或为了让我们赶紧走开而随口答应。他们会说：“行行行，我会给你五星好评。”但当我真的让你做时，你会说：“嗯，我还有点犹豫。”为什么？这才是伟大探索的来源。但这很难在孤立的环境中完成，你必须沉浸在有问题的人身边。所以产品市场匹配是指：在探索过程中，你发现并交付了非常有意义的东西，以至于你的目标客户愿意以名誉担保并成为标杆。这就是我的指标。

---

### [00:29:49] Lenny

**English:**
I imagine though, Christian, so charismatic, comes to me and says, "Hey Lenny, would you leave me a five star review for this product. I'm working on this, I'm trying to figure out if people want it." I would be like, "Yeah, of course. I'll leave you a five-star review." What do you do to kind of avoid that, just like I just want to be nice, like I don't care, I'll leave a five-star review.

**中文翻译:**
但我能想象，Christian 这么有魅力，跑来对我说：“嘿 Lenny，你能给这个产品留个五星好评吗？我正在开发它，想看看人们是否想要。”我肯定会说：“没问题，当然，我会留五星好评。”你如何避免这种情况——即我只是想表现得友好，或者我根本不在乎，所以随手留个好评？

---

### [00:30:06] Christian Idiodi

**English:**
You. It's part of why I need 25 in B2C. And don't get me wrong, if I can convince 25 people in there, I may have a marketing product and a charismatic marketing products. If that's all I needed to do was a good message and charisma to get people on it. The good benefits of this is that you can tackle risk very early because you can involve many other parts of your organization, marketing, sales, legal, finance. People often ask me how do I come up with the marketing spiel or the description? I'm like, "I don't make that up." If I ask Lenny, "What do you feel about this product?" And he says, "Well, it's cool and it's very sleek and very nice." The marketing department will say, "We don't like those terms. We want to call it comprehensive." And when you go out to sell your product, people are going to be disappointed because the expectations are created by what's on the box.

**中文翻译:**
这就是为什么在 B2C 领域我需要 25 个人的原因。别误会，如果我能说服 25 个人，我可能拥有一个营销型产品或一个充满魅力的营销产品。如果只需要好的信息和个人魅力就能让人买账的话。这种方法的好处是你可以非常早地应对风险，因为你可以让组织的其他部门参与进来：市场、销售、法务、财务。人们经常问我如何构思营销话术或描述？我说：“我不是编出来的。”如果我问 Lenny：“你觉得这个产品怎么样？”他说：“嗯，它很酷，非常流畅，非常好。”市场部可能会说：“我们不喜欢这些词，我们想称之为‘全方位的’。”但当你出去销售产品时，人们会感到失望，因为预期是由包装盒上的文字创造的。

---

### [00:31:04] Christian Idiodi

**English:**
I only market exactly what customers tell me. I have never been surprised about what customers will say when I release a product because in this technique I already get their feedback. And so I'm going to put exactly what Lenny said on the box. "Hey, this product's cool and sleek and easy to use." I've only launched a product that says super fast but difficult to read because the technology team said there was no way to change the font on something and it was just going to be difficult to read. And you know what everybody did when they got the product? "Oh my goodness, it is super [fast]. All right, it is also difficult to read." It matched their expectations in some ways. So what I do here is I learn how to sell the product with this technique, I learn how to market the product because I have real people, that we're not making assumptions. What's the best way to market this? How much Lenny? How would you find this? Does this language resonate with you? Does this properly describe the menu? See? So that's kind of what you're doing when you use a technique like this. It feels heavy to people, but that's kind of part of the practice of it. If you do this a whole lot, you get really comfortable at involving, you're working with your customers to solve it. But for me, the fact that you will not have a product failure because you have a natural pivot out, meaning if I can't find 25 people that love steak, why in the world am I building a steakhouse? So if you don't find enough people that love this problem and are willing to help you, just be like, this is not a problem worth solving. But more importantly, you really start to get... is the fastest part to product market fit, the clearest definition for me because I know when my product is ready, when I've dotted those I's and crossed those T's, in that way.

**中文翻译:**
我只根据客户告诉我的内容进行营销。发布产品时，我从未对客户的评价感到惊讶，因为通过这种技术，我已经得到了他们的反馈。所以我会把 Lenny 说的话原封不动地印在盒子上：“嘿，这个产品很酷、很流畅、易于使用。”我曾经发布过一个产品，描述是“速度极快但难以阅读”，因为技术团队说没办法更改字体，阅读起来确实会很困难。你知道大家拿到产品后怎么说吗？“天哪，它确实超快。好吧，它也确实很难读。”这在某种程度上符合了他们的预期。所以我在这里做的是通过这种技术学习如何销售产品，学习如何营销产品，因为我有真实的人，我们不是在做假设。营销这个产品的最佳方式是什么？Lenny，你愿意付多少钱？你会怎么找到它？这种语言能引起你的共鸣吗？这是否准确描述了菜单？你看，这就是你使用这种技术时所做的。人们会觉得这很沉重，但这正是实践的一部分。如果你经常这样做，你会非常习惯于让客户参与进来共同解决问题。但对我来说，最关键的是你不会经历产品失败，因为你有一个自然的“退出点”——也就是说，如果我找不到 25 个爱吃牛排的人，我到底为什么要开牛排馆？所以如果你找不到足够多热爱这个问题并愿意帮助你的人，那就直接承认：这不是一个值得解决的问题。更重要的是，你真的开始获得……这是通往产品市场匹配最快的路径，对我来说也是最清晰的定义，因为我知道产品什么时候准备好了，什么时候所有的细节都处理妥当了。

---

### [00:32:49] Lenny

**English:**
I think your point there, recruiting is itself a huge signal, is really important. Can you find people that have this problem and care enough about this problem that they're going to talk to you and spend time exploring this thing that doesn't exist yet. I think that's super interesting. And then I think another key part of this is it's one solution that solves many people's problems. And it can't be a bunch of different things for a bunch of different people.

**中文翻译:**
我认为你提到的那一点非常重要：招募本身就是一个巨大的信号。你是否能找到面临这个问题并足够关心这个问题的人，以至于他们愿意和你交谈，并花时间探索这个还不存在的东西。我觉得这超级有趣。而且我认为另一个关键部分是：这是一个能解决许多人问题的单一解决方案。它不能是为不同的人准备的一堆乱七八糟的东西。

---

### [00:33:10] Christian Idiodi

**English:**
That's right, that's right. If one person says, "I don't want this," wants this, another person wants this, you don't do it. That's how you know you do the minimum. All 25 have to want the same thing. If one person's out, you just don't do it at all. And the reason that's powerful is because if I come to you and I say, "Hey, it's missing this feature." I say, "Well yeah, 25 people that look like you that are very happy without it." You see? That's how if you think about what you do in a review, you see the five stars and you instantly like, "Oh, that's good enough." But if you have a question, what do you do, you cannot double click on the review to read. And that's how people get convinced. There's this social influence of like, "Well, Lenny's cool, he likes the steakhouse. I should like it. He's fine with this not being there so I should be fine with it." So your references are super powerful in more than any company, in influencing consumers on what they should choose or not choose.

**中文翻译:**
没错，没错。如果一个人说“我不想要这个”，另一个人说“我想要那个”，你就不要做。这就是你如何确定做“最小化”功能的方法。所有 25 个人必须想要同样的东西。如果有一个人不想要，你就根本不要做。这种力量之所以强大，是因为如果我来找你，你说“嘿，它缺这个功能”，我会说：“嗯，是的，但有 25 个和你一样的人，没有这个功能他们也过得很开心。”你看？就像你看评论时，看到五星好评，你会立刻觉得“哦，这已经足够好了”。如果你有疑问，你没办法双击评论去深究。人们就是这样被说服的。这有一种社会影响力：“既然 Lenny 很酷，他喜欢这家牛排馆，那我也应该喜欢。他觉得缺这个没关系，那我也应该觉得没关系。”所以你的标杆客户在影响消费者选择方面，比任何公司宣传都更有力。

---

### [00:34:06] Lenny

**English:**
Basically, Stripe builds new products exactly this way. They find new customers that have a problem and they work with very small number of customers to build a product for them, and that's how a lot of their new product... I think Rippling works like this too. So I think this is a really good lesson for everyone listening, if they're trying to build something new. Is there an example that comes to mind that would be, I don't know, interesting to talk through, of something you built that you worked through this process?

**中文翻译:**
基本上，Stripe 就是这样开发新产品的。他们找到有新问题的客户，与极少数客户合作开发产品，这就是他们很多新产品的来源……我想 Rippling 也是这样运作的。所以对于正在收听、想要开发新东西的每个人来说，这都是非常好的一课。你脑海中有什么有趣的例子吗？关于你通过这个流程构建的某个产品？

---

### [00:34:30] Christian Idiodi

**English:**
Oh, boy. I tell the example of solving a problem when I was at a staffing company, Snagajob. They do hourly jobs and help people find their best job or an hourly job and I actually get a call here from the head of Global staffing at Starbucks. Now, he called me, you can see the benefit of this technique, because I'm the person he calls when he has problems. I've used this technique with him at a previous company. He didn't even know I was at a new company. And he calls me up and he says, "Christian, I have a problem." I said, "Well, don't we all have problems?" He said, well, "We just bought a bakery in the San Francisco Bay Area. And as we're doing the paperwork to kind of take over this company or this acquisition, we realized that close to 800 of the employees may be undocumented workers."

**中文翻译:**
噢，天呐。我举个例子，那是我在一家名为 Snagajob 的招聘公司工作时解决的一个问题。他们做小时工招聘，帮助人们找到最合适的工作。我接到了星巴克全球招聘负责人的电话。他之所以打电话给我——你可以看到这种技术的益处——是因为每当他有问题时，他都会找我。我在之前的公司就和他用过这种技术。他甚至不知道我已经换了公司。他打电话来说：“Christian，我有个问题。”我说：“嗯，谁没点问题呢？”他说：“我们刚在旧金山湾区买了一家面包店。在办理接管或收购手续时，我们发现近 800 名员工可能是无证劳工。”

---

### [00:35:22] Christian Idiodi

**English:**
And I said, "Wow, that does sound like a problem." He's like, "Yeah, imagine if this breaks out in the news and all of that. But more importantly, we still need to get all their paperwork. So all these people are going to quit and we'll have a new bakery without employees." And my first question to him as a product guy is like, "Wow, would you give me a million dollars to solve this problem?" And it's like, "No, seriously?" I was like, "300,000." I'm throwing out numbers. He's like, "Maybe." I said, "Wow, you have my attention." I go to my CEO, I tell him to call. I grab a designer and an engineer. I just say, "Hey look, I would love to work on a little project with you all if you have some time." I kind of debrief them on the call. Now the first thing I have to do is to try to define the problem, identify problems. What really is the problem going on?

**中文翻译:**
我说：“哇，这听起来确实是个大问题。”他说：“是啊，想象一下如果这上了新闻会怎样。但更重要的是，我们仍然需要补齐所有手续。所以这些人都会辞职，我们将拥有一家没有员工的新面包店。”作为产品人，我的第一个问题是：“哇，你愿意给我一百万美元来解决这个问题吗？”他说：“不，说认真的。”我说：“三十万？”我随口报了个数字。他说：“也许吧。”我说：“哇，你成功引起了我的注意。”我去找我的 CEO，告诉他这个电话。我找来一名设计师和一名工程师。我只是说：“嘿，听着，如果你们有时间，我想和你们一起做一个小项目。”我向他们简要介绍了情况。现在我必须做的第一件事是尝试定义问题，识别问题。到底发生了什么问题？

---

### [00:36:08] Christian Idiodi

**English:**
Yeah, we're breaking it down, we're talking through this. We say, well, at the end of the day, Starbucks needs to hire like 800 people quickly because we can't fix getting everybody's paperwork. But they're going to lose these people and they need to hire those quickly. And I say, well, who else has this problem? We're trying to throw out guesses. I'm like, "What are we talking about? Let's go out." Everybody jumps in my car and we start driving around and this is where we're doing our product work from. We're talking in the car, just out of the building. We see a new construction site for a new McDonald's coming soon and we're curious. We're like, well, "Let's go find out." We start talking to people on sites. Fortunately, the operations director is on site and we ask him, we say, tell us about opening up a new McDonald's.

**中文翻译:**
是的，我们正在分解问题，深入讨论。我们说，归根结底，星巴克需要迅速招聘约 800 人，因为我们无法解决所有人的手续问题。但他们会失去这些人，所以需要快速补员。我问，还有谁面临这个问题？我们试着猜测。我说：“光说有什么用？走，出去看看。”大家跳进我的车，我们开始四处转悠，这就是我们开展产品工作的方式。我们在车里聊天，走出办公室。我们看到一个即将开业的新麦当劳施工现场，我们很好奇。我们说：“走，去打听一下。”我们开始和现场的人聊天。幸运的是，运营总监就在现场，我们问他：“跟我们说说新开一家麦当劳的情况吧。”

---

### [00:36:54] Christian Idiodi

**English:**
He says, "Well, do you know we need like 120 people on opening day?" We're like, "Whoo, for McDonald's? Really, 120 people?" He's like, "Yeah, do you know that most of the people in this industry don't show up to work on the very first day, and every day we're in construction, we're losing money. So the second the bathrooms, the restrooms, are done, we want to open up." We're like, "Wow, we didn't think about this, new construction, a new store opening." They need to hire lots of people quickly. So I said, "Thank you very much." I gave him my business card, he gave me his. We jumped back in the car. We just kept driving. We went to the mall. We started talking to people there. We talked to a manager at Macy's and she said, "Oh look, we hire 20,000 people in the holiday season."

**中文翻译:**
他说：“嗯，你知道开业那天我们需要大约 120 人吗？”我们惊呼：“哇，一家麦当劳要 120 人？”他说：“是啊，你知道这个行业的大多数人第一天根本不来上班吗？而且施工每多一天，我们就在亏钱。所以只要洗手间一完工，我们就想立刻开业。”我们想：“哇，我们没考虑到这一点，新建筑、新店开张。”他们需要迅速招聘大量人员。所以我说：“非常感谢。”我给了他我的名片，他也给了我他的。我们跳回车里继续开。我们去了商场，开始和那里的人聊天。我们和梅西百货（Macy's）的一位经理交谈，她说：“哦，看，我们在假日季节要雇佣 2 万人。”

---

### [00:37:36] Christian Idiodi

**English:**
We're like, "Macy's." Yeah, it's like nights, weekend, shipping, stuff like this. We started hiring in the summer because of how painful it is. Now, all we're doing here is just validating that this is a real problem, like other people will have the problem. So we go back to the office, we're brainstorming, like, "How will someone even go about solving this problem?" We're thinking this was like, we're not really sure, but McDonald's guy was very desperate. I said, " I have his business card." We start throwing some ideas. So I called the McDonald's person and I said, "Look, you just met with us." He's like, "Yeah. We would love to help you solve the problem." He said, "Well, what do you have in mind?" I said, "We've been talking. What if we just sent you some people to interview. And if you like them, you'll hire them."

**中文翻译:**
我们惊叹：“梅西百货！”是的，包括夜班、周末、物流之类的。因为招聘太痛苦了，他们从夏天就开始招人。现在，我们所做的一切只是为了验证这是一个真实的问题，即其他人也会遇到这个问题。于是我们回到办公室开始头脑风暴：“到底该怎么解决这个问题？”我们当时不太确定，但那个麦当劳的人非常绝望。我说：“我有他的名片。”我们开始提出一些想法。于是我给麦当劳那个人打电话说：“听着，你刚见过我们。”他说：“是的。我们很乐意帮你解决问题。”他问：“你有什么想法？”我说：“我们讨论过了。如果我们直接送一些人去面试，如果你喜欢他们，你就录用他们，怎么样？”

---

### [00:38:18] Christian Idiodi

**English:**
He said, "That seems fairly easy." He's like, "How do I pay for this?" And we took a swag like, "Maybe you pay us for everybody that you hire." He was like, "Oh, I don't see much risk to that. This is great." I'm like, "Oh, okay." We have no sense of what to do. We are literally Googling, how do people find a job at McDonald's? We go to colleges, we are sticking up flyers. We are putting ads in the newspaper back then, we are looking at different techniques to try to get people into a funnel and interest by posting on Craigslist or things like that. At the end of the week, we get about 40 people that are interested to come to the interview. We're like, that feels good for our first try. We call the manager up and we say, "Look, on Monday we will send you 40 people to interview. This is great."

**中文翻译:**
他说：“这听起来挺简单的。”他问：“我该怎么付钱？”我们随口报了一个方案：“也许你为每一个录用的人付钱给我们。”他说：“噢，我觉得这没什么风险，太棒了。”我想：“噢，好吧。”我们其实根本不知道该怎么做。我们真的在谷歌搜索：人们怎么在麦当劳找工作？我们去大学贴传单。当时我们还在报纸上登广告，尝试各种技术把人们拉进漏斗，比如在 Craigslist 上发帖。到周末，我们大约有 40 个有兴趣参加面试的人。我们觉得第一次尝试效果不错。我们给经理打电话说：“听着，周一我们会送 40 个人去面试。这太棒了。”

---

### [00:39:05] Christian Idiodi

**English:**
Monday I take my designer, my engineer, we are on site with the manager. At nine o'clock, we expect three people to show up for interviews. Nobody shows up. 10 o'clock, another three, one person shows up. We got to the end of the day, less than 20 people show up. This man only has four or five people. We are like, "We suck this. This is terrible." We go to the manager, " Let's go and apologize for wasting your day and stuff." He starts to laugh. We're like, "What's going on?" He said, "Look, I forgot to tell you. Folks in this industry don't even show up to interviews. We are McDonald's, we pay minimum wage. People will leave us for 25 more cents an hour. They will leave us for a job that is one block closer to their house or less than a mile closer to their home."

**中文翻译:**
周一，我带着设计师和工程师和经理一起在现场。九点钟，我们预计有三个人来面试，结果没人来。十点钟，又有三个名额，只来了一个人。到了一天结束时，只有不到 20 人出现。这个经理只招到了四五个人。我们想：“我们搞砸了，这太糟糕了。”我们去找经理说：“我们想为你浪费了一整天道个歉。”他却开始大笑。我们问：“怎么了？”他说：“听着，我忘了告诉你们。这个行业的人甚至都不来参加面试。我们是麦当劳，付的是最低工资。人们会为了每小时多赚 25 美分而离开我们。他们会为了离家近一个街区或近不到一英里的工作而离开我们。”

---

### [00:39:54] Christian Idiodi

**English:**
Now, the engineer is with us and he's thinking about it. It's like, this is really interesting. About half of the people showed up. He hired one in five. If you really want to solve this problem, playing the laws of averages, we probably need to send this man close to 200 people. We need to go bigger. So we are storming the office, we called the McDonald's guy again. I was like, "Can we try again next Monday?" And he's like, "Do I only pay for the people I hire?" We're like, "Sure." It's like, "Oh, go ahead and kill yourself on this." It's a pain. We've been trying all kinds of things for years.

**中文翻译:**
当时工程师和我们在一起，他在思考。他说：“这很有趣。大约一半的人来了，他录用了五分之一。如果你真的想解决这个问题，根据平均律，我们可能需要给这个人送去近 200 人。我们需要扩大规模。”于是我们冲回办公室，再次给麦当劳那个人打电话。我说：“下周一能再试一次吗？”他问：“我还是只为录用的人付钱吗？”我们说：“当然。”他说：“噢，那你们尽管去折腾吧。”这确实是个痛点，他们多年来尝试了各种方法。

---

### [00:40:26] Christian Idiodi

**English:**
Now, we start doubling down our efforts. We start calling back all the people that didn't show up for interviews like, "What's going on? Did you get lost? Don't you want a job? What's wrong with you?" We start figuring out what portals worked well for us the last time, what wasted our money, what was the cost to acquire a person. And we spend a week doubling our efforts on those channels. We probably have about 120, 130 people on the list. The Sunday beforehand, we start calling them up like, "Please show up. Don't embarrass us. Don't you want the job? Do you need that address? Should I call you a reminder, set your alarm." We're trying all the techniques to try to get more people. There we go the next day and at the end of the day he has about forty-five to 50 people. He comes to us, he shakes our hand. He's like, "Whoa, the quality was excellent. All my recruiters were engaged. The day was smooth," [inaudible 01:41:17] how successful we are.

**中文翻译:**
现在，我们开始加倍努力。我们开始给所有没来面试的人回电话：“怎么回事？你迷路了吗？你不想找工作吗？你怎么了？”我们开始分析上次哪些渠道效果好，哪些浪费了钱，获客成本是多少。我们花了一周时间在这些渠道上加倍投入。名单上大约有 120、130 人。周日那天，我们开始给他们打电话：“请一定要来，别让我们难堪。你不想找工作吗？需要地址吗？要我给你打提醒电话吗？定好闹钟了吗？”我们尝试了所有能想到的办法来增加到场人数。第二天我们去了，到了一天结束时，他招到了大约 45 到 50 人。他走过来和我们握手，说：“哇，质量太棒了。我所有的招聘人员都很有干劲。这一天过得很顺畅。”他感叹我们是多么成功。

---

### [00:41:18] Christian Idiodi

**English:**
He's like, "I want to use you for every new McDonald's I open in the area." Now, I don't know I have a product. I just know I was able to help one person at McDonald's. But I feel like I have enough learning. So I called up my friend at Starbucks and I said, "Hey, man, remember the problem we talked the about?" He's like, "Yeah. I would love to help you solve it." He said, "Oh, okay. What do you have in mind?" I said, "Well, I think we need to send you about 3000 people to interview." He said, "3000 people? I told you I only need 800." I said, in this industry, most people don't show up for interviews, right? He said, "Oh my goodness. You know our industry well. I like this. I'm going to take this up, I think we'll give you this contract."

**中文翻译:**
他说：“我想在这一地区每开一家新麦当劳都用你们的服务。”当时我并不知道我已经有了一个产品，我只知道我帮到了麦当劳的一个人。但我感觉我已经学到了足够多的东西。于是我给星巴克的朋友打电话说：“嘿，伙计，还记得我们讨论过的问题吗？”他说：“记得。我很乐意让你帮我解决。”他问：“噢，好吧，你有什么想法？”我说：“嗯，我想我们需要送大约 3000 人去面试。”他说：“3000 人？我告诉你我只需要 800 人。”我说：“在这个行业，大多数人都不来面试，对吧？”他说：“天哪，你太了解我们的行业了。我喜欢这个方案，我会上报，我想我们会把合同给你们。”

---

### [00:42:15] Christian Idiodi

**English:**
I take my designer, my engineer, we go to San Francisco. We're out there recruiting because this is where it was based. We have to get a whole hotel, hire people. We are working all the channels we knew, working in the area. Remember, we don't have any software, no technology. The designer, we're doing this manually, Excel spreadsheets, phones, emails, in that way. In one week, Starbucks hired 784 people. I get an email the next Monday morning from the contact at Starbucks. He copied Howard Schultz, then CEO of Starbucks. The email read, "These guys just saved our butts." I sent it to my CEO, but then I said, "You know what?" I only know now I can help on McDonald's and a Starbucks, but that doesn't mean I have a product.

**中文翻译:**
我带着设计师和工程师去了旧金山。我们在那里进行招聘，因为那是面包店所在地。我们不得不包下一整家酒店，雇佣人员。我们动用了所有已知的渠道，在当地开展工作。记住，当时我们没有任何软件，没有任何技术。设计师和我都是手动操作：Excel 表格、电话、邮件。在一周内，星巴克雇佣了 784 人。下周一早上，我收到了星巴克联系人的邮件，他抄送给了当时的星巴克 CEO 霍华德·舒尔茨（Howard Schultz）。邮件写道：“这些家伙救了我们的命。”我把邮件发给了我的 CEO，但我当时说：“你知道吗？我现在只知道我能帮到麦当劳和星巴克，但这并不意味着我有一个产品。”

---

### [00:43:00] Christian Idiodi

**English:**
But I now have enough of problem definition. I reached out to the head of marketing, the head of sales. I said, "Tell us who has this problem you've come across," because we need to work with more people to try to uncover a solution that is scalable, maintainable, reliable, and works for our business. Weirdly enough, the next opportunity we had was the Los Angeles International Airport. They were opening up a new terminal and they said, "We need 200 people to manage all the stores in the new terminal." And we were like, "200 people? We just hired close to 800. We got this." We go to LA for the briefing with the staffing group and they tell us the people that work at an international airport have to match the demographics of the travelers.

**中文翻译:**
但我现在对问题有了足够的定义。我联系了市场主管和销售主管，说：“告诉我们你们遇到的还有谁面临这个问题”，因为我们需要与更多人合作，尝试发掘一个可扩展、可维护、可靠且符合我们业务利益的解决方案。奇怪的是，我们的下一个机会是洛杉矶国际机场。他们要开一个新的航站楼，说：“我们需要 200 人来管理新航站楼里的所有商店。”我们想：“200 人？我们刚招了近 800 人，这事儿稳了。”我们去洛杉矶参加招聘小组的简报会，他们告诉我们：在国际机场工作的人必须与旅客的人口统计特征相匹配。

---

### [00:43:49] Christian Idiodi

**English:**
We say, "Say what? Yeah, we have 13% Chinese-speaking travelers, we need 13% Chinese-speaking employees." We say, "Sorry? We've got 5% Korean speaking." I mean my team is in LA, we're in Chinatown. We are speaking, trying to recruit people to come and work in an airport. If we expect 10 people to show up, only one person shows up. We start calling job seekers up like, "What's going on?" They say, "Do you know what it means to work at an airport?" First, I wake up at five o'clock, I drive to the employee parking lot. I get into a bus. Then I go through security. There was not like TSA pre-check back then. Then if I want to break, I go to security again and then you pay me minimum wage. It took us close to three months to staff this. We had to negotiate with the union to raise the price to like $15 an hour to attract people. When we come back from that, you know what we're saying, that is not our customer. Never again. We are never doing airports. That's a pain.

**中文翻译:**
我们说：“你说什么？是的，我们有 13% 的讲中文的旅客，所以我们需要 13% 讲中文的员工。”我们说：“不好意思？我们还有 5% 讲韩语的。”我的团队在洛杉矶，我们在唐人街，试着招募人们去机场工作。如果我们预计有 10 个人来，结果只来了一个。我们开始给求职者打电话：“怎么回事？”他们说：“你知道在机场工作意味着什么吗？首先，我五点起床，开车去员工停车场，坐大巴，然后过安检——那时候还没有 TSA 预检。如果我想休息，还得再过一次安检，而你只付我最低工资。”我们花了近三个月才招满人。我们不得不与工会谈判，将时薪提高到 15 美元左右以吸引人才。当我们回来时，我们说：“那不是我们的客户。再也不干了，我们再也不接机场的活儿了，太痛苦了。”

---

### [00:44:24] Christian Idiodi

**English:**
Around this time, it was the holiday season, so we reached out to the person at Macy's. We told them about our work with McDonald's. They say, "Oh, we'll try this." We started working with them. You can imagine through this, the engineer is thinking, how can I use technology to improve this? I always tell this to people, I never wrote a requirements document, I never wrote a story. So the designer is thinking, how can we improve the end-to-end experience? Okay, we need a recruiter experience, a job seeker experience. We had a funnel. We need to build a scheduling tool so that they can scale the interview. Oh, what about notification? Maybe text message. We can send them a map so that they can know how to get to the... I mean, all of these things, because they were involved from the very beginning in defining the problem, they were immersed in the solution to the problem. It takes us about eight and a half, almost nine months to build this. When we launched this product in its first 90 days, it booked $32 million in sales.

**中文翻译:**
大约在这个时候，正值假日季节，所以我们联系了梅西百货的那个人。我们告诉了他们我们与麦当劳的合作。他们说：“噢，我们要试试这个。”我们开始与他们合作。你可以想象，在这个过程中，工程师在想：我如何利用技术来改进这个流程？我总是告诉人们，我从未写过需求文档，从未写过用户故事。设计师在想：我们如何改进端到端的体验？好吧，我们需要招聘者体验、求职者体验。我们有一个漏斗。我们需要建立一个排程工具，以便他们可以大规模面试。噢，通知怎么办？也许可以用短信。我们可以给他们发地图，让他们知道怎么去……我的意思是，所有这些事情，因为他们从一开始就参与了问题的定义，他们沉浸在问题的解决方案中。我们花了大约八个半月，快九个月的时间来构建这个产品。当我们发布这个产品时，在最初的 90 天里，它就预订了 3200 万美元的销售额。

---

### [00:45:22] Christian Idiodi

**English:**
Why? Because you got McDonald's probably until today using this product to open up every new store. Well, Starbucks went to the global contract. We say, " Well, we've only done discovery in the US so I only know where it works in this market." And we started finding, if you look at NASCAR, some of these big sporting events, they have to bring a lot of people together very quickly for a short amount of time. And this is the same kind of product they use to do that high volume hiring in a short amount of time. If you think about it, I was discovering who had the problem and developing the customers that have the problem. At the same time, I was discovering and delivering a solution to that problem.

**中文翻译:**
为什么？因为麦当劳可能直到今天还在使用这个产品来开设每一家新店。星巴克签了全球合同。我们说：“嗯，我们只在美国做了探索，所以我只知道它在这个市场有效。”我们开始发现，如果你看 NASCAR 赛车或一些大型体育赛事，他们必须在短时间内迅速召集大量人员。这就是他们用来在短时间内进行大规模招聘的那种产品。如果你仔细想想，我当时正在发现谁有问题，并培养那些有问题的客户。与此同时，我正在发现并交付解决该问题的方案。

---

### [00:46:01] Lenny

**English:**
That's insane. You said you made thirty-something million dollars the first year of launching this thing.

**中文翻译:**
太疯狂了。你说发布第一年就赚了三千多万美元。

---

### [00:46:06] Christian Idiodi

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:46:06] Lenny

**English:**
That's unreal. I love how this is the epitome of doing things that don't scale. You going hiring McDonald's employees and then Starbucks employees. Then airport employees. Wow.

**中文翻译:**
不可思议。我喜欢这个例子，它简直是“做那些无法规模化的事情”（doing things that don't scale）的缩影。你亲自去招聘麦当劳员工，然后是星巴克员工，接着是机场员工。哇。

---

### [00:46:18] Christian Idiodi

**English:**
You do things that don't scale and then you do things that do scale. And it's so powerful when you discover how to do things that don't scale, when you actually know. Because it's the power of technology is just the beauty of what it can do at scale.

**中文翻译:**
你先做那些无法规模化的事情，然后再做可以规模化的事情。当你发现如何做那些无法规模化的事情时，当你真正了解了情况，那是极其强大的。因为技术的威力就在于它在大规模运作时的美妙之处。

---

### [00:46:34] Lenny

**English:**
And to that point, it's easier said... a lot of people talk about doing things that don't scale. Many people don't actually do anything like that. They're like, "Nah, let someone else figure that out, or let's just actually think about the future of this versus just doing it and solving and finding problems." I love that also, you didn't do any of these other, the things we talked about. There's no fake door test, there's no opportunity solution trees. There's no user interview. You're talking to people. It wasn't like a user research interview, come sit down, ask questions.

**中文翻译:**
说到这一点，说起来容易……很多人都在谈论“做无法规模化的事情”，但很多人实际上并没有去做。他们会想：“不，让别人去搞清楚吧，或者让我们直接思考未来的规划，而不是亲自动手去解决和发现问题。”我也很喜欢这一点：你没有做我们谈到的任何其他事情。没有虚假门测试，没有机会解决方案树，没有正式的用户访谈。你只是在和人聊天。那不像是一场用户研究访谈——请坐下，我来问问题。

---

### [00:47:00] Christian Idiodi

**English:**
I said, there's nothing better in learning how to solve a problem than trying to solve the problem. You will get all the answers, the research, the failure, the mistakes, all the evidence. You know the difference between what people say, this is what they do. You'll validate and test. Because at the end of the day, what is statistically relevant? Solving the problem is the clearest indication that we've solved the problem and that we know how to solve the problem then. And so yeah, very powerful technique.

**中文翻译:**
我说过，学习如何解决问题的最好方法就是尝试去解决它。你会得到所有的答案、研究、失败、错误和所有的证据。你会知道人们所说的和他们所做的之间的区别。你会去验证和测试。因为归根结底，什么是统计学上的相关性？解决问题就是我们已经解决问题、并且知道如何解决问题的最清晰迹象。所以，是的，这是非常强大的技术。

---

### [00:47:30] Lenny

**English:**
And I love that you didn't really know exactly where this was going to lead. It was just kind of this exploratory, let's see if there's something here. And you just kept following this like, huh, there's a problem. It looks like we found a way to solve it. Let's just see where else this can take us. Amazing.

**中文翻译:**
我喜欢你当时并不确切知道这会走向何方。这只是一种探索性的尝试：让我们看看这里是否有机会。然后你就一直顺着这个思路走下去：咦，这里有个问题，看来我们找到了解决方法，让我们看看这还能带我们去哪里。太棒了。

---

### [00:47:44] Lenny (Sponsor: Teal)

**English:**
This time of year is prime for career reflection and setting goals for professional growth. I always like to spend this time reflecting on what I accomplished the previous year, what I hope to accomplish the next year, and whether this is the year I look for a new opportunity. That's where today's sponsor, Teal comes in. Teal provides you with the tools to run an amazing job search. With an AI-powered resume builder, job tracker, cover letter generator, and Chrome extension that integrates with over 40 job boards, Teal is the all-in-one platform you need to run a more streamlined and efficient job search and stand out in this competitive market. There's a reason nearly 1 million people have trusted Teal to run their job search. If you're thinking of making a change in the new year, leverage Teal to grow your career on your own terms. Get started for free at tealhq.com/lenny.

**中文翻译:**
每年的这个时候都是职业反思和设定职业成长目标的黄金时期。我总是喜欢花时间反思去年取得了什么成就，明年希望实现什么，以及今年是否是寻找新机会的一年。这就是今天的赞助商 Teal 大显身手的地方。Teal 为您提供进行出色求职所需的工具。凭借 AI 驱动的简历生成器、职位追踪器、求职信生成器以及集成了 40 多个招聘板块的 Chrome 扩展程序，Teal 是您进行更精简、更高效求职并在竞争激烈的市场中脱颖而出所需的一站式平台。近 100 万人信任 Teal 来进行求职是有原因的。如果您正考虑在新的一年做出改变，请利用 Teal 以您自己的方式发展事业。在 tealhq.com/lenny 免费开始。

---

### [00:48:34] Lenny

**English:**
I want to shift to a different topic. You spend a lot of time helping product leaders get better at coaching, get better at building relationships, get better at building trust with their teammates. Marty Cagan actually shared this quote with me when he joined, he said that you can build trust with executives and product leaders faster than anyone else he knows, and the people you coach adore him like some kind of rock star. He's literally on speed dial for several of the CEOs of the largest companies in the world. Okay, so let me just ask you, what's your secret to being a great coach, and how can people listening become better coaches to their reports, maybe colleagues?

**中文翻译:**
我想转到一个不同的课题。你花了很多时间帮助产品领导者提高教练辅导能力，更好地建立关系，更好地与团队成员建立信任。Marty Cagan 在加入时曾跟我分享过一句话，他说你与高管和产品领导者建立信任的速度比他认识的任何人都快，而且你辅导过的人都像崇拜摇滚明星一样崇拜你。你简直就在世界上几家最大公司的 CEO 的快捷拨号名单上。好吧，让我问问你，成为一名优秀教练的秘诀是什么？听众如何才能更好地辅导他们的下属，甚至是同事？

---

### [00:49:12] Christian Idiodi

**English:**
This topic is probably near and dear to my heart because, I mean, there are many ways that I think our corporate structures have failed in creating high performance and stability in people, and I think one of them is actually encro of leadership. And by leadership, the key component I often point to is coaching. This idea of what truly is the job of a leader. And I tell people, yeah, it's context and culture at the highest level like, why are we here? Where are we going? How do we organize ourselves to get there? What's important? Just kinds of things and the environment in which we do it, but there's a people element because you recognize that you want an outcome and you need people working together to that outcome.

**中文翻译:**
这个话题对我来说非常亲切，因为我认为我们的企业结构在创造高绩效和员工稳定性方面有很多失败之处，其中之一就是领导力的缺失。说到领导力，我经常指出的关键组成部分就是“教练辅导”（Coaching）。即领导者的真正工作是什么。我告诉人们，在最高层面上，它是背景和文化，比如：我们为什么在这里？我们要去哪里？我们如何组织起来实现目标？什么是重要的？诸如此类的事情以及我们工作的环境。但其中有一个人的因素，因为你意识到你想要一个结果，而你需要人们共同努力来实现这个结果。

---

### [00:50:15] Christian Idiodi

**English:**
So I now have to staff those people and I have to hire and train them and equip them and then appoint them to what those things are. But many of those things are one-off, meaning I create a vision, I create a strategy. I hire a person. There's something that is every day and that's coaching, that's like the day job of managers. And if I think about high performing teams in the world, and you can pick sports is one of those, artists, they have coaches and managers like it's an everyday thing. And the idea is that when I explain this to people, I say doing product management is a product manager's job, but getting better at product management is the manager's job, is the coach's job. And people tend to misunderstand how that dynamic works.

**中文翻译:**
所以我现在必须配置这些人员，雇佣、培训并武装他们，然后指派他们去做这些事。但其中很多事情都是一次性的，比如我制定愿景、制定战略、雇佣一个人。但有一件事是每天都要做的，那就是教练辅导，这就像是经理的日常工作。如果我想到世界上高绩效的团队，你可以选体育团队或艺术家，他们都有教练和经纪人，这是一种日常的存在。当我向人们解释这一点时，我会说：做产品管理是产品经理的工作，但“变得更擅长产品管理”是经理的工作，是教练的工作。人们往往误解了这种动态关系。

---

### [00:50:57] Christian Idiodi

**English:**
You see, if you are playing a game, you're in the game. The coaches are on the sideline watching you play the game and getting you better at playing the game. Your job may be to kick or pass the ball and you need a competence level, but somebody's job is every day looking for ways for you to be better at your job. The number one reason most people don't give good coaching is because they've never experienced good coaching themselves. And most people can only give to other people what has been given to them, what experiences they've seen.

**中文翻译:**
你看，如果你在比赛，你就在场上。教练在场边看着你比赛，让你在比赛中表现得更好。你的工作可能是踢球或传球，你需要一定的能力水平，但某个人的工作是每天寻找让你在工作中表现得更好的方法。大多数人不擅长辅导的首要原因，是因为他们自己从未体验过优秀的辅导。大多数人只能把别人给予他们的东西、或者他们见过的经验再给予他人。

---

### [00:51:36] Christian Idiodi

**English:**
I was in an executive meeting with a CEO and he gets up in a meeting and he just starts screaming and cursing at everybody, just throwing up And I said, "Whoa, whoa." I said, "Can we talk outside?" They pick him outside. I was like, "First of all, I don't even think I can work with you anymore given this environment you're creating, but I need to understand why you are talking to your team like that." And he says to me, he says, "Christian, well my boss used to scream at me like this. And look at me, I'm now a CEO, I got it, I understand it. They are grownups, they can understand it too."

**中文翻译:**
我曾参加过一个 CEO 的高管会议，他在会上突然站起来，开始对所有人大声尖叫、咒骂，简直是在发泄。我说：“喔，喔，我们能去外面谈谈吗？”我们把他带到外面。我说：“首先，考虑到你创造的这种环境，我觉得我没法再和你合作了，但我需要理解你为什么要那样对你的团队说话。”他对我说：“Christian，我以前的老板就是这样对我尖叫的。你看我，我现在是 CEO 了，我挺过来了，我理解。他们都是成年人，他们也能理解。”

---

### [00:52:05] Christian Idiodi

**English:**
And I said, "Well, tell me what you're trying to communicate." And he explains it to me and stuff and I said, "Is it okay if I show you an alternative way of communicating that?" He says, "What do you mean?" I said, "Well is it first of all safe for me to do this with the team?" So I go back to the team and I say, "Look, I'm going to try to say what the CEO was trying to say again. He's giving me permission for you to speak freely and candidly, I want your honest opinion as to what was more effective and why." And I took a stab at kind of representing what he was trying to say and I asked the team and it's like, yeah, it's the same thing kind of message, but when he tells us this stuff we just go do it. We get it, we go do it. But the way you described it right now to us, I can think of four other things I need to do. I even understand some other things that may be missing that we need to now go tackle.

**中文翻译:**
我说：“好吧，告诉我你想要传达什么。”他向我解释了一番，我说：“如果我向你展示另一种沟通方式，可以吗？”他问：“你什么意思？”我说：“首先，我这样做对团队来说安全吗？”于是我回到团队中说：“听着，我要试着重新表达一下 CEO 刚才想说的话。他允许你们自由、坦诚地发言，我想听听你们的真实意见，哪种方式更有效，为什么。”我试着转述了他的意思，然后问团队，他们说：“是的，信息是一样的，但当他那样告诉我们时，我们只是机械地去做。我们明白了，然后去做。但按照你刚才描述的方式，我能想到另外四件我需要做的事。我甚至理解了可能遗漏的其他一些事情，我们现在需要去解决。”

---

### [00:52:57] Christian Idiodi

**English:**
And the CEO is kind of really taken aback and it's kind of in some ways he has never seen an alternative. And he's never seen if an alternative be effective. Most people need to see something then they need to do it before they can even teach it, in some ways. Now I'm saying this all because I need to make a very strong argument for people understanding coaching. And in some ways I probably did not know that I was probably good at coaching. I coached my kids in soccer for eight years and we always won the championship, my boys team and I had long waiting list of people and I thought I had a fundamental flaw in understanding it because when my kids were all four years old, when you have the kids run around the soccer field just kicking the ball any way, my team always had plays, they all have strategy.

**中文翻译:**
CEO 感到非常震惊，在某种程度上，他从未见过替代方案，也从未见过替代方案是否有效。大多数人需要先看到某件事，然后亲自动手做，最后才能去教别人。我说这些是因为我需要有力地论证人们理解教练辅导的重要性。在某种程度上，我以前可能并不知道自己擅长辅导。我教我孩子踢足球教了八年，我的男孩子队总是赢得冠军，还有很长的候补名单。我曾以为我在理解上有一个根本性的缺陷，因为当我的孩子都只有四岁时，当别的孩子只是在足球场上乱跑乱踢时，我的团队总是有战术，总是有策略。

---

### [00:53:49] Christian Idiodi

**English:**
So winning games like 10 to zero, other kids, I thought I'm like, maybe I was born in another country. I didn't know you were just meant to let them play. And I was really coaching kids and I was treating four-year-olds like adults. We're watching video, watching tape, having real... [inaudible 00:54:05] But it was so funny when you see them execute on the field. But I've kind of always had this mentality about the truest forms like companies cannot care for people, people care for people. And the representation of what is acceptable in an environment or what we do is by the leaders. Now there's some different dynamic to why that's not happening with how we promote people and the whole poor structure around that. But fundamentally, trust is a key part of doing this.

**中文翻译:**
所以我们经常以 10 比 0 赢球。我想，也许我出生在另一个国家，我不知道四岁的孩子应该只是让他们玩。我当时真的在辅导孩子，把四岁的小孩当成大人对待。我们看比赛录像，分析录像，进行真正的……但看到他们在场上执行战术时真的很有趣。我一直有一种心态：公司无法关心人，只有人能关心人。而环境中什么是可以接受的，或者我们该做什么，是由领导者体现的。现在，由于我们晋升人员的方式以及围绕它的糟糕结构，情况并非总是如此。但从根本上说，信任是其中的关键部分。

---

### [00:54:50] Christian Idiodi

**English:**
And I think when I tell these people, I say, "Look, most people don't know that you know something until they test you." We do it a whole lot in our environment. I ask you a question, I see how you answer and it's like I might ask you what's one plus one? It's two and now I know that one plus one is two. I don't care when you learned it. I need you to know that it's two to do my work. So it happens in everyday environment and what people fail to do is to do the learning so they get the question wrong and they lose trust. And trust is based on competence and character, there are other values like communication and concern and care, but most corporate environments, it's a competency thing. That's why you see so many companies accept people with bad communication, bad care, because they're very good at their job. So if you can demonstrate competence, you will earn some trust, at least the trust of competence from people.

**中文翻译:**
我告诉这些人：“听着，大多数人在测试你之前，并不知道你懂某些东西。”我们在环境中经常这样做。我问你一个问题，看你如何回答，就像我问你一加一等于几？你说等于二，现在我知道你懂一加一等于二了。我不在乎你是什么时候学的，我只需要你知道它等于二，这样我才能开展工作。这发生在日常环境中，而人们失败的地方在于没有去学习，所以他们答错了问题，失去了信任。信任基于能力（Competence）和品格（Character），虽然还有沟通、关怀等价值，但在大多数企业环境中，它首先是一个能力问题。这就是为什么你看到很多公司接受沟通差、不关心人的人，因为他们工作能力极强。所以如果你能证明自己的能力，你就会赢得一些信任，至少是人们对你能力的信任。

---

### [00:55:44] Christian Idiodi

**English:**
So I kind of explained to people a whole lot that the real core of their job at first is to learn, to seek to understand before they are understood, to know what you don't know. That humility and ego only last a small minute. The most powerful way I have found to get trust with many people is to have them accountable for an outcome of mine, which is to know. So if I wanted to accelerate trust with Lenny, I will ask Lenny to teach me. And I see this like an emotional intelligence, black belt technique here, but many environments, if you get into environment, it's very quickly for you to identify the power in that environment. Who is influential? Who has loudest voice and all? And there's something behind why they're powerful. Yes it is title, but if you think about why someone is called a CEO, it's because there's some competence that made someone give them the title, they are great at growing businesses, they have a good stride, whatever it is.

**中文翻译:**
所以我经常向人们解释，他们工作的核心首先是学习，在被理解之前先寻求理解，去了解你所不知道的东西。谦逊和自大都只是一瞬间的事。我发现与许多人建立信任的最有力方式，是让他们对我的一个结果负责——即让我“学会”。所以如果我想加速与 Lenny 建立信任，我会请 Lenny 教我。我认为这是一种情商上的“黑带级”技术。在许多环境中，当你进入其中，你会很快识别出谁拥有权力。谁有影响力？谁的声音最大？他们之所以强大是有原因的。是的，有头衔的原因，但如果你想想为什么某人被称为 CEO，那是因为某种能力让别人给了他这个头衔——他们擅长发展业务，他们有很好的节奏，无论是什么。

---

### [00:56:51] Christian Idiodi

**English:**
So what you do to build trust is you want that person to trust you. Okay. But the only way that person will know that they trust you is if they test you. And unfortunately many environments they do that publicly. I'm in a meeting, I ask Lenny a question. He bumps a presentation like, oh, product managers are useless. That person doesn't know anything. So here's what I do when I want to build trust, if Lenny's a new hire in my company, I take Lenny to the loudest, most influential person in the company. And I say, "Look, I just hired Lenny. Super rockstar, did all of this. But he knows nothing about that business, nothing about how we work and stuff. I will love for you to teach him some things." Now he may be like, "I'm super busy, I'm involved."

**中文翻译:**
所以为了建立信任，你希望那个人信任你。好的。但那个人知道他信任你的唯一方式就是测试你。不幸的是，在许多环境中，这种测试是公开进行的。我在开会，我问 Lenny 一个问题，他搞砸了演示，大家就会想：噢，产品经理没用，那个人什么都不懂。所以当我想要建立信任时，我会这样做：如果 Lenny 是我公司的新员工，我会带他去找公司里最有权势、最有影响力的人。我会说：“听着，我刚雇了 Lenny。超级明星，做过这些那些。但他对业务一窍不通，对我们的工作方式也一无所知。我希望你能教他一些东西。”那个人可能会说：“我超级忙，我有很多事。”

---

### [00:57:36] Christian Idiodi

**English:**
I say, "Look, Lenny should just hang with you. I've played his calendar for the whole week. He's just got to sit in meetings you are, quiet, observe, just by observing you, he will be a rockstar. No stress, nothing to give." Now it's impossible for this leader to sit with you for a whole week without saying things like, "So Lenny, where are you from? What do you do? Tell me about yourself." What have I now done? I forced a relationship between a very powerful, trustworthy, influential person and somebody else that doesn't have it. If you are walking around the company with this person, what is everybody going to say? Oh my goodness, you're friends with that person. I want to know Lenny because we can never get him to agree on it. So if I know Lenny, I'll be close with it. Lenny is more accessible, he's new, but how did Lenny break in? I'm extending somebody else's trust to you.

**中文翻译:**
我会说：“听着，让 Lenny 跟着你就行。我已经清空了他整周的日程。他只需要坐在你参加的会议里，保持安静，观察。仅仅通过观察你，他就能成为明星。没压力，不需要你付出什么。”现在，这位领导者不可能让你在他身边坐一整周而不说类似这样的话：“那么 Lenny，你从哪儿来？你是做什么的？跟我说说你自己。”我现在做了什么？我强行在一位非常有权势、值得信赖、有影响力的人和另一位不具备这些特质的人之间建立了联系。如果你和这个人一起在公司里走动，大家会怎么说？“天哪，你和那个人是朋友。”“我想认识 Lenny，因为我们从来没法让那位大佬同意某事，如果我认识 Lenny，我就能接近他。”Lenny 更有亲和力，他是新人，但 Lenny 是怎么打入内部的？我正在把别人的信任延伸到你身上。

---

### [00:58:44] Christian Idiodi

**English:**
Now by also making that person share in the accountability of training you or teaching you, in some ways, I am now making them accountable for your growth. It's impossible two months from now for that person to say, "Oh, Lenny doesn't do anything." Why? Because it makes them a bad teacher. So they're always going to be friendly, be like, "Oh yeah, Lenny, let's have a conversation. Don't do it like this in this way." They will prep you because it makes them look bad if you're not competent. Now, this technique accelerates relationships and trust. It's the help me teach me type of technique. It also allows them to observe the dynamics within the company, but it accelerates relationships because it's impossible for you to be in a meeting with a leader all the time without the person saying something like, "Oh yeah, hey folks, let me introduce you to Lenny." Now that person is now the one introducing you to more connections within the company. Fastest way to build is, now feels like it's a expense but this is the job of a coach. You are designing a very specific playbook to help people achieve the outcomes reward and that's by getting them competent at their job and then their potential where they need to go next.

**中文翻译:**
现在，通过让那个人分担培训或教导你的责任，在某种程度上，我让他们对你的成长负有责任。两个月后，那个人不可能说“噢，Lenny 什么都不干”。为什么？因为那会显得他是个糟糕的老师。所以他们总是会表现得很友好，会说：“噢，是的，Lenny，我们聊聊。别这样做，要那样做。”他们会为你做准备，因为如果你不称职，会让他们显得很没面子。这种技术加速了关系和信任的建立。这是一种“帮帮我，教教我”式的技术。它还允许新员工观察公司内部的动态，并加速关系的建立，因为你不可能一直和领导一起开会而他不介绍你：“噢，对了，各位，让我向你们介绍一下 Lenny。”现在，那个人成了为你介绍公司更多人脉的人。这是建立关系最快的方法，虽然现在看起来像是一种投入，但这正是教练的工作。你正在设计一个非常具体的剧本，帮助人们实现目标，方法是让他们胜任工作，然后挖掘他们下一步发展的潜力。

---

### [00:59:45] Lenny

**English:**
That are some Jedi ninja tricks right there. I love that. I've never heard this advice before. Makes so much sense and it's so easy to implement.

**中文翻译:**
这简直是绝地武士级别的忍者神技。我太喜欢了。我以前从未听过这种建议。非常有道理，而且非常容易实施。

---

### [00:59:54] Lenny

**English:**
Amazing. For someone that maybe doesn't have a Christian around as a coach or a manager that isn't at this level, what advice do you give people that are looking for a coach or someone that could help them along these lines to learn to build trust and learn to just generally improve?

**中文翻译:**
太棒了。对于那些身边没有 Christian 这样的教练，或者经理水平还没到这个层次的人，你对那些正在寻找教练或能帮助他们建立信任、全面提升的人有什么建议？

---

### [01:00:09] Christian Idiodi

**English:**
Boy, like I say with everything, you don't get mastery by avoidance. And one of the things that good coaches do that when I say corporations fail companies is they don't create space for practice. I see people complain to me about people all the time, oh this person is not good. They presented this, it was terrible. And I ask them, "What did they do at practice?" They say, "What do you mean?" I say, "When they were practicing this, what did they do?" Say, "Well, they didn't practice. I told them to prepare this." I say, "Think about what happens at practice. Any practice of any sport, any game. You can stop. You can make corrections, you can give feedback. What you do at practice, you do in the game. Product management is a one time, game time kind of role. So when do people practice?"

**中文翻译:**
天呐，就像我常说的，你不能通过逃避来获得精通。优秀教练会做的一件事——而我认为企业在这方面失败了——就是他们没有创造练习的空间。我经常听到人们向我抱怨某人：“噢，这个人不行，他的演示糟透了。”我会问他们：“他们在练习时是怎么做的？”他们会问：“你什么意思？”我说：“当他们在练习这个演示时，他们做了什么？”他们说：“嗯，他们没练习，我只是让他们准备一下。”我说：“想想练习时会发生什么。任何运动、任何比赛的练习。你可以停下来，可以纠正，可以给反馈。你在练习中做什么，你在比赛中就做什么。产品管理是一种‘一次性、即时比赛’的角色。那么，人们什么时候练习呢？”

---

### [01:00:57] Christian Idiodi

**English:**
And so what I tell people in the absence of getting good coaching, you need to find practice arenas. It's kind of like if you are learning a new sport or basketball, you kind go to the gym. It's a practice arena. You can play and shoot around and let maybe some people have pickup games that you join and stuff like this in some ways. And so I always advise product managers like, you need to join a lot of pickup games, which they are low barriers to entry, low evaluation reward, loan risk type of thing. Go volunteer at a non-profit working with the team, go volunteer in your community event or church or whatever you go to, go party. But now what am I trying to do with these things? Find places where people do collaborative problem solving. That is what you're doing as a product team.

**中文翻译:**
所以我告诉人们，在没有得到优秀辅导的情况下，你需要寻找“练习场”。就像如果你在学一项新运动或打篮球，你会去体育馆。那是练习场。你可以随便投投篮，或者加入一些业余比赛（pickup games）之类的。所以我总是建议产品经理：你需要参加很多这种“业余比赛”，即那些门槛低、评价奖励低、风险低的事情。去非营利组织当志愿者与团队合作，去社区活动、教堂或任何你去的地方当志愿者，去参加聚会。但我做这些是为了什么？是为了寻找人们进行“协作式问题解决”的地方。这正是你作为产品团队所做的事情。

---

### [01:01:50] Christian Idiodi

**English:**
It's more likely in a high performance environment you'll find a good coach. You'll find somebody out there but what you're also doing is you're observing other people play. Most people learn a lot of skills by, you watch TV like, oh I like that move. And then you go to the gym and you practice that move, you see what you do? So it's like you're seeing then you're doing it in some ways. So you need to see good product work so that you can do good product work so that you can teach good product work. So if you don't have the benefit of having a good coach directly, you've got to find environments where you see good coaching happening and a good indication of good coaching is actually good outcomes over and over again. Winning teams, winning performances, great products, great products come from great product teams. They probably have good leaders or a good leader within a bad culture.

**中文翻译:**
在高绩效环境中，你更有可能找到好教练。你会找到那样的人，但你同时也在观察别人如何“比赛”。大多数人学习技能的方式是：你在电视上看到，噢，我喜欢那个动作。然后你去体育馆练习那个动作，你看你做了什么？所以这就像是你先看，然后以某种方式去做。你需要看到优秀的产品工作，这样你才能做出优秀的产品工作，进而教导优秀的产品工作。所以如果你没有直接获得好教练的福气，你就必须去寻找能看到优秀辅导发生的环境。优秀辅导的一个良好迹象就是反复出现的好结果。获胜的团队、获胜的表现、伟大的产品——伟大的产品源于伟大的产品团队。他们可能有好的领导者，或者在糟糕的文化中有一个好的领导者。

---

### [01:02:45] Lenny

**English:**
So essentially it's get a bunch of reps in is a big part of this advice. Just get reps in and I think what you just said is such an important part of it is collaborative problem solving is the key thing to look for. I was going to ask you how you recommend people get into product management. I imagine this is a very similar answer, it's just find opportunities to collaboratively problem solve.

**中文翻译:**
所以本质上，这个建议很大一部分是“增加练习次数”（get reps in）。就是多练。我认为你刚才说的非常重要的一点是：寻找“协作式问题解决”的机会。我本想问你如何建议人们进入产品管理领域，我想答案应该非常相似，就是寻找协作解决问题的机会。

---

### [01:03:04] Christian Idiodi

**English:**
That's right. And I differentiate that because there are all those guys that are the, I know I like to change a light bulb or they can walk individually or thinker and stuff and I kind of differentiate that problem solving from the people that are very good at working with other people to solve a problem. And there are so many of those pockets, you're getting reps. You've heard those who that just tell you stories of them working problem and I can see how they will help me. They know how to use data, they know how to use insights. They're not afraid of talking to people. How are you going to get those reps? Because you come into my company I ask you a question like, oh, I really don't know where do I find? But if you've done the problem solve with a team, sometimes you may not even know how to get the answer, but you know who to go to get the answer. That's a gift too.

**中文翻译:**
没错。我之所以区分这一点，是因为有些人擅长独自换灯泡，或者喜欢独立工作、思考。我把这种问题解决与那些非常擅长与他人合作解决问题的人区分开来。有很多这样的角落可以让你练习。你听过那些人讲述他们解决问题的故事，我能看出他们会如何帮助我。他们知道如何使用数据，知道如何使用洞察。他们不害怕与人交谈。你打算怎么获得这些练习机会？因为如果你来到我的公司，我问你一个问题，你说：“噢，我真的不知道去哪儿找答案。”但如果你曾与团队一起解决过问题，有时你可能甚至不知道如何得到答案，但你知道该去找谁得到答案。这也是一种天赋。

---

### [01:03:52] Lenny

**English:**
I love that so much of your advice comes back to being the person that knows the most or has learned the most or even looking like they're spending the time to learn the most, which makes so much sense. The people you want to entrust are the people that happen to have the answers.

**中文翻译:**
我非常喜欢你的建议，很多都回到了这一点：成为那个知道最多、学到最多，或者至少看起来在花时间学习最多的人。这非常有道理。你想要托付的人，正是那些恰好掌握答案的人。

---

### [01:04:05] Christian Idiodi

**English:**
I try.

**中文翻译:**
我努力做到这一点。

---

### [01:04:06] Lenny

**English:**
And each person will know. Yeah, it just makes sense. Something else you talk about is people getting promoted too early. Leaders getting promoted too early, not doing well, they end up blaming others when really they were not actually ready for this new position. Can you talk about why you think that happens and then just how maybe as that person that might be in that position right now feeling like, oh, shit, maybe it's not my fault.

**中文翻译:**
每个人都会知道。是的，这很有道理。你谈到的另一件事是人们晋升太快。领导者晋升太早，表现不佳，最后归咎于他人，而实际上他们并没有为这个新职位做好准备。你能谈谈为什么你认为会发生这种情况吗？以及对于那些现在可能正处于这种境地、感觉“噢，该死，也许这不是我的错”的人，你有什么建议？

---

### [01:04:31] Christian Idiodi

**English:**
I don't know how to make an appeal to corporations on this one. It's a similar appeal in the light of coaching too as well. Most people are promoted to a point of incompetency or so, but I kind describe the dynamic this way. It's kind of like Lenny is a fantastic engineer. If you think about it, he wins engineer of the year awards. If you go to the office, his picture is on the wall, everybody knows him. He's feeling good. But it's like one year, two years, maybe eight years in Lenny's feeling like, am I really growing in my career? Am I really challenged in my career? He looks at the engineering career ladder. The next role from his senior engineer role is engineering manager. The leadership team, HR, they look at the same thing. That's true. We love Lenny. We don't want to lose Lenny, we need to promote him.

**中文翻译:**
我不知道该如何就此向企业发出呼吁。在教练辅导方面也有类似的呼吁。大多数人被晋升到了他们不胜任的程度（彼得原理），我这样描述这种动态：比如 Lenny 是一名出色的工程师。他赢得了年度工程师奖，照片挂在办公室墙上，人人都认识他。他感觉很好。但过了一年、两年，也许八年后，Lenny 觉得：我的职业生涯真的在成长吗？我真的面临挑战吗？他看了看工程职业阶梯，高级工程师之后的下一个角色是工程经理。领导团队和 HR 也看到了同样的东西：没错，我们爱 Lenny，我们不想失去他，我们需要晋升他。

---

### [01:05:20] Christian Idiodi

**English:**
And the next step is engineering manager or product manager, manager, however, I want to use the rule here. And so, we do what? We promote Lenny. It feels good at the moment. Yeah! Congratulations on your promotion. He posts a nice post. We are like, "Yeah, we're going to keep Lenny there for long time now because he's promoted." Now, Lenny has never been a manager in his whole life. He's never interviewed people, fired people, didn't even coach people or had done any of those things directly. After a couple of months, Lenny starts to recognize an interesting pattern. Nobody's clapping for him at company meetings anymore. And sure they've taken down his picture from the world because he's no longer an engineer, he's a manager. So somebody else is now the engineer of the year, they are clapping for him in meetings. He's like, he doesn't feel recognized or seen anymore. He's just a guy now behind the scenes and that kind of thing.

**中文翻译:**
下一步是工程经理或产品经理主管，不管是什么。于是，我们做了什么？我们晋升了 Lenny。那一刻感觉很好。耶！祝贺你晋升。他发了一条很棒的动态。我们想：“太好了，现在 Lenny 会在这里待很长时间了，因为他升职了。”然而，Lenny 这辈子从未当过经理。他从未面试过人，从未解雇过人，甚至从未直接辅导过人。几个月后，Lenny 开始发现一个有趣的现象：公司会议上再也没人为他鼓掌了。当然，他的照片也从墙上撤下来了，因为他不再是工程师，而是经理。现在别人成了年度工程师，大家在会上为那个人鼓掌。他觉得不再被认可或关注了，他现在只是一个幕后的人。

---

### [01:06:10] Christian Idiodi

**English:**
Then in a couple of weeks go by, then they have a big engineering problem. And you know what Lenny does? He jumps in and he solves the problem. Lenny did not recognize that his job has changed. His job is no longer to solve the problem directly, but to get a team of other people good at solving problems. This is because you're a great engineer but not a good manager. This story or this dynamic I've told is probably the most common origin story of what people see or deem as micromanagement. In many cases here, this individual knows how to do engineering. They don't know how to do engineering management. They don't see the shift in their dynamic being changed. We see back patterns where it's like the second you become a manager or a leader, you cannot say things like, I don't know. I'm not sure, I need help. Who told us those things? But it's like such an expectation that our leaders must have the answers, must know the right things, must do the right things.

**中文翻译:**
几周后，出现了一个重大的工程问题。你知道 Lenny 做了什么吗？他冲上去解决了问题。Lenny 没有意识到他的工作已经变了。他的工作不再是直接解决问题，而是让团队中的其他人变得擅长解决问题。这是因为你是一名伟大的工程师，但不是一名好的经理。我讲的这个故事或这种动态，可能是人们所见或认为的“微观管理”（Micromanagement）最常见的起源。在这种情况下，这个人知道如何做工程，但不知道如何做工程管理。他们没有看到自己角色的转变。我们看到一种模式：一旦你成为经理或领导者，你就不能说“我不知道”、“我不确定”或“我需要帮助”。谁告诉我们这些的？但似乎有一种预期，即领导者必须掌握答案，必须知道正确的事，必须做正确的事。

---

### [01:07:17] Christian Idiodi

**English:**
And so what do we see people do? Rather than Lenny asks for help, he goes to Google and searches how to do an interview, how to write a review. Are you seeing? He reads different articles like this one looks cool and then he does it and nobody dies. Nothing breaks so he thinks there's a good framework and a good pattern. And we have this dysfunctional culture of everybody doing different things, whatever works for anybody and that is the cycle that repeats itself. Now, a person that works for Lenny sees that he used this framework and thinks it must be a good framework, my boss did it, and you see how that cycle repeats itself? Because Lenny didn't actually get coached to be a manager. If you ask anybody that works with me, if come to me and say, "Oh, I need to get promoted to be a director." You know what I say? I say, "Go be a director. You don't need a title. Let me tell you what a director does. And you're going to work with me over the next couple of months to do those things because I am promoting you to do the job, not to learn the job."

**中文翻译:**
所以我们看到人们怎么做？Lenny 不去寻求帮助，而是去谷歌搜索如何进行面试，如何写绩效评估。你看到了吗？他读了各种文章，觉得这个看起来不错，然后照做了，结果没人死，也没出大乱子，所以他觉得这是一个好的框架和模式。于是我们就有这种功能失调的文化：每个人都在做不同的事，只要对自己有效就行，这个循环不断重复。现在，为 Lenny 工作的人看到他使用了这个框架，就认为这一定是个好框架，因为“我老板就是这么做的”。你看这个循环是如何重复的？因为 Lenny 实际上并没有接受过如何当经理的辅导。如果你问任何跟我工作的人，如果你来找我说：“噢，我需要晋升为总监。”你知道我会说什么吗？我会说：“去当总监吧。你不需要头衔。让我告诉你总监是做什么的，接下来的几个月里你要和我一起做这些事，因为我晋升你是为了让你‘做’这份工作，而不是让你‘学’这份工作。”

---

### [01:08:52] Christian Idiodi

**English:**
You see where it falls apart in promotions? We promote people and it's like you're now a VP, do VP things. And you're like, I have never done VP things before, but I cannot tell people I've never done VP things because it makes me look incompetent, but I see the job description. I should do some VP things. What did my last VP do? Those things and those. How you say? But the best place to learn how to be a VP is when you're not a VP because that's where you practice being a VP. That's where you get feedback on because then when you become a VP, you have done those things before. It's like why is the first time you've done an interview when you're now a VP? Come in and do an interview with me, observe me do an interview, ask questions, see what works, get feedback. That's why I love those group product manager roles because those are actually meant to be designed as ways for people to make a decision if they want to be a manager or they want to just stay in the discipline, but people use them as why would you give somebody four direct reports if no evidence, they can manage one? So what I do is I give you one, you might tell me, I hate people. That's okay, we can talk about that. But it's like, let me give you four and you're just going to practice the bad behavior on four. So this is what often happens in company. We promote them into incompetence. It's not their fault because we are not coaching them. What we need to do is create a safe environment for people to practice leadership before they become leaders, before we promote them.

**中文翻译:**
你看到晋升在哪里出问题了吗？我们晋升某人，然后说：“你现在是副总裁（VP）了，去做副总裁该做的事吧。”而你会想：“我以前从未做过副总裁的事，但我不能告诉别人我没做过，因为那会显得我不称职。但我看到了职位描述，我应该做点副总裁的事。我上一任副总裁做了什么？那些事和这些事。”但学习如何当副总裁的最佳时机是在你“还不是”副总裁的时候，因为那是你练习当副总裁的地方。那是你获得反馈的地方，这样当你真正成为副总裁时，你已经做过那些事了。为什么你第一次面试别人是在你当上副总裁之后？来和我一起面试，观察我如何面试，提问，看看什么有效，获取反馈。这就是为什么我喜欢“小组产品经理”（Group Product Manager）这个角色，因为它们的设计初衷是让人们决定是想当经理还是只想留在专业领域。但人们却把它当成——如果没有证据表明某人能管好一个人，你为什么要给他四个下属？所以我做的是先给你一个下属，你可能会告诉我：“我讨厌管人。”没关系，我们可以谈谈。但如果我直接给你四个，你就会在四个人身上练习你的错误行为。所以这就是公司里经常发生的事：我们将人们晋升到不称职的境地。这不是他们的错，因为我们没有辅导他们。我们需要做的是在人们成为领导者之前、在晋升之前，为他们创造一个练习领导力的安全环境。

---

### [01:10:10] Lenny

**English:**
I love this idea of just doing VP things. I just picture someone walking around and, I'm doing VP things.

**中文翻译:**
我喜欢“做副总裁该做的事”这个想法。我脑海中浮现出一个人走来走去说：“我正在做副总裁该做的事。”

---

### [01:10:14] Christian Idiodi

**English:**
I'm doing VP things. All the time, I see them live, but what's a VP thing?

**中文翻译:**
我正在做副总裁该做的事。我经常亲眼见到，但到底什么是副总裁该做的事？

---

### [01:10:19] Lenny

**English:**
I'm doing VP things. I think another added benefit of doing these things before you say you're VP is that is the best way to get promoted to a VP is you are already doing the job.

**中文翻译:**
我正在做副总裁该做的事。我认为在你正式成为副总裁之前做这些事的另一个额外好处是：这是晋升为副总裁的最佳途径，因为你已经在做这份工作了。

---

### [01:10:28] Christian Idiodi

**English:**
That's right. And nobody bites you on it. You see that? And you're not even surprised by it and it's very safe because when you're not in the job, you can make mistakes and nobody blames you. He's not a VP, look at him trying to do VP things. You see? But the second you're a VP, there's so much leverage in the role that your mistake is serious because it impacts everybody. But when you're not, it's like you get coverage, you get protection, nobody's as mad at you. It's like, yeah, he was just trying to take a stab at it. Let's coach him on that. But what is the best time to know those things? It's before you're in it. Before you're in it.

**中文翻译:**
没错。而且没人会因此攻击你。你看到了吗？你甚至不会对此感到惊讶，而且这非常安全，因为当你还没在这个职位上时，你可以犯错，没人会责怪你。大家会说：“他不是副总裁，看他在尝试做副总裁的事。”你看？但一旦你成了副总裁，这个角色的杠杆作用如此之大，以至于你的错误会变得非常严重，因为它影响到每一个人。但当你还不是的时候，你就像有了一层保护罩，没人会那么生你的气。大家会觉得：“是的，他只是在尝试一下，让我们在这方面辅导他。”那么，了解这些事情的最佳时机是什么时候？是在你进入那个职位之前。

---

### [01:11:06] Lenny

**English:**
To give companies and leaders something to do with this advice, you talk about helping them train and practice before they do this. How did you do that? I don't know, is it work with Silicon Valley Product Group to help train and coach?

**中文翻译:**
为了让公司和领导者能落实这些建议，你谈到了在他们正式上任前帮助他们培训和练习。你是怎么做的？是与硅谷产品集团合作进行培训和辅导吗？

---

### [01:11:18] Christian Idiodi

**English:**
There are many great product coaches out there. There are many leadership coaches out there. I think there's some recognition. People have to have the humility and the self-awareness to recognize that there are opportunities for them to get better as a leader and product management, you need to see or experience, good leadership, you need the reps of good leadership and we do it in everyway. You probably talk to people about strategy and what did they do? They outsource it all the time. Tell somebody else to do it, and that cycle feeds itself because you never do it. You only know how to outsource it. You never learn how to do it. You see? And so many people outsource, oh, go get a mentor, go take a training class, and they'll think that they're outsourcing coaching in that way.

**中文翻译:**
外面有很多优秀的产品教练，也有很多领导力教练。我认为这需要一种认知。人们必须有谦逊和自我意识去承认，作为领导者和产品管理者，他们有提升的空间。你需要看到或体验优秀的领导力，你需要优秀领导力的练习次数，我们在各方面都这样做。你可能和人们谈论战略，他们做了什么？他们总是外包出去。让别人去做，这个循环就会自我维持，因为你从未亲自动手。你只知道如何外包，从未学会如何去做。你看？很多人外包辅导，比如找个导师、上个培训班，他们认为这就是外包教练辅导。

---

### [01:12:02] Christian Idiodi

**English:**
Go take a communication class." I'm like, "Okay." They come back from the class, and they punch you in the face. I'm like, "Why did you punch me?" "The class taught me to punch you in the face. You paid money for me to learn how to punch you in the face." I say, go to the communication class with the employee because they're going to need to practice the communication. You learn what they're learning. Both of you now will practice it together, so that they can get better at communication. A communication class doesn't get you better at communication. Communicating better is an indication that you're better at communication. You need to practice it. And I need to create a safe place for you to practice, I need to give you feedback that you're communicating better. These are all patterns in coaching that many leaders just don't have these tools and techniques to do it. I do teach a lot of leaders how to coach. I do a lot of people work with leaders. There's not a singular product problem. People here me say, "All problems are people problems." There's not a singular problem that I have not seen coaching address.

**中文翻译:**
“去上个沟通课吧。”我说：“好吧。”他们上完课回来，给了你一拳。我问：“你为什么打我？”“课上教我打你脸。你付钱让我学会怎么打你脸。”我说，你应该和员工一起去上沟通课，因为他们需要练习沟通。你了解他们在学什么，你们两个现在一起练习，这样他们才能在沟通上变得更好。沟通课不会让你变得更擅长沟通，沟通得更好才是你更擅长沟通的迹象。你需要练习。我需要为你创造一个安全的练习场所，我需要给你反馈，告诉你你沟通得更好了。这些都是教练辅导的模式，而许多领导者根本没有这些工具和技术。我确实教很多领导者如何进行辅导。我与领导者做了很多关于人的工作。没有单纯的产品问题。人们听我说过：“所有的问题都是人的问题。”我还没见过教练辅导解决不了的问题。

---

### [01:13:04] Lenny

**English:**
What I hear is essentially the biggest burden is on the manager to be a great coach to their reports, and for a manager to get good at this, essentially a coach is a really good method. Bring someone in that could work with you one-on-one on a lot of these things. Awesome. That's very actionable, very solvable. Everyone's always going to ask, "How do I find an awesome coach?" Difficult, I guess. I don't know. What do you tell people to go find a coach? Is there anything you could recommend, just how to go find a coach?

**中文翻译:**
我听到的本质上是：经理肩负着成为下属优秀教练的最大重担。而为了让经理变得擅长此道，请一个教练是一个非常好的方法。请一个能就这些事情与你进行一对一合作的人。太棒了，这非常具有操作性，是可以解决的。大家总会问：“我该如何找到一个出色的教练？”我想这很难。我不知道，你告诉人们怎么去找教练？有什么推荐的方法吗？

---

### [01:13:30] Christian Idiodi

**English:**
You've got to find people that have generated good outcomes. People are always like, "How do you find a good consultant?" I get people teaching people a lot that haven't done the job. Don't get me wrong. If you look at American football teams, there are some coaches that have played the game before, and you feel good that they can coach you. And there are also some coaches that have not played the game, but if you look at the pedigree, they've learned from good coaches, they've worked under good coaches. Same thing with product. I say there are only two parts. A good coach is someone that has played the game before and has generated good outcomes, and the second is that they've learned from good product coaches. You want to find people with a strong pedigree. You see [someone], and you, "Oh, you worked at Amazon this year," or "You worked at this company," or "You worked at Stripe. [You got] good results. How did you do that?" "Oh, my environment was great. The culture was great." "Who taught you? Who coached you?" Do pick-up games with the people that they coached. They will tell you what patterns their coach told them. How do you do that? My coach told me to do this, and you're going to learn from them. I say, "Oh." Important things.

**中文翻译:**
你必须找那些创造过好结果的人。人们总是问：“如何找到好的顾问？”我看到很多没做过这份工作的人在教别人。别误会，如果你看美式橄榄球队，有些教练以前打过球，你会觉得他们能教你。也有些教练没打过球，但如果你看他们的资历（pedigree），他们向优秀的教练学习过，在优秀的教练手下工作过。产品也是一样。我说只有两部分：一个好的教练是以前“打过比赛”并创造过好结果的人；第二是他们向优秀的产品教练学习过。你想找那些有强大背景的人。你看到某人，会说：“噢，你今年在亚马逊工作过，”或者“你在那家公司工作过，”或者“你在 Stripe 工作过，取得了很好的结果。你是怎么做到的？”“噢，我的环境很好，文化很好。”“谁教你的？谁辅导你的？”去和他们辅导过的人玩玩“业余比赛”。他们会告诉你他们的教练教了他们什么模式。你是怎么做的？我的教练教我这样做。你会从他们身上学到东西。我说：“噢，这些很重要。”

---

### [01:14:37] Lenny

**English:**
Amazing. Okay. Final area I want to spend a little time on is the work you do in Africa. Marty said that you're the foremost expert in introducing product and technology into world's developing countries. I know you spend a lot of time in Africa specifically. Can you just talk about the work you do there and also just maybe the opportunities and challenges you run into when you're working with folks there?

**中文翻译:**
太棒了。好的，我想花点时间讨论的最后一个领域是你在非洲的工作。Marty 说你是将产品和技术引入世界发展中国家的顶级专家。我知道你特别在非洲花了很多时间。你能谈谈你在那里的工作吗？以及你在与那里的人合作时遇到的机遇和挑战？

---

### [01:14:56] Christian Idiodi

**English:**
Yeah. I have an African background, and my family is there, and I used to have this false notion that the things we've done in North America or Europe or Asia, the problems we've solved, have been solved in these markets. I remember talking to someone in Africa years ago, and he said to me, "Oh." I said, "You just got a new job. Where did you find a job?" He's like, "Oh, I found it in a newspaper." I said, "A newspaper? What do you mean found a job?" I remember participating in solving that exact problem in 1998. I was working with the team to solve that, and I had this false assumption that because I solved it here, of course it's solved everywhere.

**中文翻译:**
是的。我有非洲背景，我的家人在那儿。我以前曾有一种错误的观念，认为我们在北美、欧洲或亚洲做过的事情、解决过的问题，在这些市场也已经解决了。我记得几年前在非洲和某人聊天，他说：“噢。”我问：“你刚找了份新工作，在哪儿找的？”他说：“噢，我在报纸上找的。”我说：“报纸？你说找工作是什么意思？”我记得我在 1998 年就参与解决了那个问题，当时我和团队一起解决它。我曾有一种错误的假设，认为既然我在这里解决了，那在任何地方肯定都解决了。

---

### [01:15:40] Christian Idiodi

**English:**
I started to see patterns like this in Africa where just two things were trending. One, so many, the poor use of technology and enabling technologies to solve problems. And two, the difficulty in actually solving problems in these markets, in these emerging markets. And one of the things we take for granted, I always tell people the government is probably the biggest public private product platform in the world. In all countries, they all have this public... Because they provide the infrastructure and the architecture that is enabling for people. Imagine if you were trying to code and you didn't have power. Now you're thinking there are markets where you have to solve the problem of getting power before you then getting access to a computer and then getting access to the right type of software to be able to code something. Look at all the different things. You have to solve many problems just before you can start to solve the problem in a meaningful way. This is a very big reflection of the dynamic in Africa.

**中文翻译:**
我开始在非洲看到类似的模式，主要有两个趋势：第一，技术和赋能技术在解决问题方面的应用非常糟糕。第二，在这些新兴市场中实际解决问题的难度极大。我们理所当然认为的一件事——我总是告诉人们，政府可能是世界上最大的公私合营产品平台。在所有国家，他们都提供这种公共……因为他们提供了赋能于人的基础设施和架构。想象一下，如果你想写代码但没有电。现在你考虑到有些市场，你必须先解决供电问题，然后才能接触到电脑，然后才能接触到合适的软件来写代码。看看所有这些不同的事情。在你开始以有意义的方式解决问题之前，你必须先解决许多其他问题。这非常真实地反映了非洲的动态。

---

### [01:16:44] Christian Idiodi

**English:**
The second pattern of what we see is because of this challenge, I see two things. One, people make a lot of money on a problem than from solving the problem. There's this whole society that people are very good at walking around problems. "We've got an electricity problem, we'll just buy generators." "We've got a road problem, we're going to buy bigger cars." I was talk at a conference, and I was driving up to it, and I saw a Tesla with a portable generator at the back of it. They'll stop and charge the Tesla, and they keep going on the road. In some ways, that's a whole society, but it's never been a society that didn't have creative people. Just an amazing, tremendous amount of talent. It's a very young population. I talk to people all the time. I say, "Look." Someone told me, "Well, Africa, seven of the eight most underdeveloped places in the world are in Africa."

**中文翻译:**
我们看到的第二个模式是，由于这种挑战，我看到了两件事：第一，人们从“问题”本身赚的钱比从“解决问题”赚的钱还多。整个社会的人都非常擅长绕过问题。“我们有电力问题，我们就买发电机。”“我们有道路问题，我们就买更大的车。”我有一次去参加会议，在路上看到一辆特斯拉，后面拖着一个便携式发电机。他们会停下来给特斯拉充电，然后继续上路。在某种程度上，这就是整个社会的缩影。但这个社会从来不缺乏有创造力的人。那里有惊人的、海量的人才。那是一个非常年轻的人口群体。我经常和人们聊天，我说：“看。”有人告诉我：“嗯，非洲，世界上八个最不发达的地方有七个在非洲。”

---

### [01:17:41] Christian Idiodi

**English:**
And I said, "Well." They were talking about the discovery of the internet. Less than 30% of Africa has discovered the internet. And I tell them, "Wow. And we created seven Unicorns from that. Imagine if 50%, 75% discovered the internet. We need to understand the opportunities, the youngest population, the fastest growing, some of the fastest growing economies in these markets. Some of the problems are so basic, and the opportunities are so huge. So I had to kill all these assumptions. One, that I needed permission to come to solve problems there, and two, that we didn't have the means to equip and educate people. We don't have a talent problem or a resource problem. The biggest opportunity I've found is to really empower a continent with enabling technology and the mindset and the skills to be able to leverage technology in solving problems.

**中文翻译:**
我说：“好吧。”他们谈论互联网的普及。非洲只有不到 30% 的人接触过互联网。我告诉他们：“哇，即便如此，我们还是从中创造了七家独角兽公司。想象一下，如果 50% 或 75% 的人接触了互联网会怎样。我们需要理解其中的机遇：最年轻的人口、增长最快的经济体。有些问题非常基础，而机遇却如此巨大。所以我必须打破所有这些假设：第一，我不需要获得许可才能去那里解决问题；第二，我们并非没有手段去武装和教育人们。我们没有人才问题，也没有资源问题。我发现最大的机遇是真正用赋能技术、思维方式和技能来武装这个大陆，使他们能够利用技术解决问题。”

---

### [01:18:40] Christian Idiodi

**English:**
This led to me starting a nonprofit in Africa, the Innovate Africa Foundation, and we are committed to this education of people on the continent, this enablement with technology. We did our first conference last year, the Inspire Africa Conference. It just blew my mind. I'm so humbled when I could see a thousand people from 31 different countries in Africa come with a hunger and an eagerness to learn how to do product work. And it's not cheap by any means for them to do that. What moved me the most is looking at the future generation. We had a 13-year-old and an 11-year-old in the workshop. The 11-year-old was a robotics engineer. The 13-year-old was a CEO of a small startup that keeps healthcare records, a leader. And I'm like, "If I can help these people learn how to do product well, this is the whole generation for Africa. This is the future of people that want to leverage technology in a meaningful way." So I spend a lot of my time in Africa, coaching, advising and teaching teams how to use technology, how to do product, how to organize themselves as product teams, how to solve problems, and really to create a boldness within the continent for them to go after problems and solve them, than walk around the problems or make money on them.

**中文翻译:**
这促使我在非洲成立了一个非营利组织——“创新非洲基金会”（Innovate Africa Foundation），我们致力于非洲大陆的人才教育和技术赋能。去年我们举办了第一届会议——“启发非洲会议”（Inspire Africa Conference）。这让我大受震撼。看到来自非洲 31 个不同国家的 1000 人带着对学习产品工作的饥渴和渴望而来，我感到非常谦卑。对他们来说，参加这个会议绝不便宜。最让我感动的是看到下一代。我们的工作坊里有一个 13 岁的孩子和一个 11 岁的孩子。那个 11 岁的孩子是一名机器人工程师，13 岁的孩子是一家保存医疗记录的小型初创公司的 CEO，一个领导者。我想：“如果我能帮助这些人学会如何做好产品，这就是非洲的整整一代人。这是那些想要以有意义的方式利用技术的人的未来。”所以我花了很多时间在非洲，辅导、建议并教授团队如何使用技术、如何做产品、如何组建产品团队、如何解决问题，并真正激发非洲大陆内部的一种胆识，让他们去直面并解决问题，而不是绕着问题走或利用问题赚钱。

---

### [01:20:03] Lenny

**English:**
If people want to learn more about this, maybe support the work you're doing, what's the best way to find out more?

**中文翻译:**
如果人们想了解更多信息，或者支持你正在做的工作，最好的途径是什么？

---

### [01:20:09] Christian Idiodi

**English:**
You can visit the nonprofit website. It's innovateafricafoundation.org. You can follow our work on SVPG or the inspireafricaconference.com. I know I will be doing a lot more next year. In January, I am going to be launching a fund, the Paid Africa Fund, and I want it to be a fund funded by the product community for Africa. It's an angel investment fund. One of the problems I recognize is that so many of the startups, they are not ready for institutional investment, and they are forced into it in some ways. They say people are giving up a lot of equity when they just need cashflow. And so I really want to focus on a fund for the community to enable people to get product market fit in those markets. That'll be launching in January. I'll probably do an announcement about it. I'm excited about that work and to really try to promote more of product-centric thinking on the continent.

**中文翻译:**
你可以访问非营利组织的网站：innovateafricafoundation.org。你可以在 SVPG 或 inspireafricaconference.com 上关注我们的工作。我知道明年我会做更多事情。明年一月，我将启动一个基金——“Paid Africa Fund”，我希望这是一个由产品社区为非洲资助的基金。这是一个天使投资基金。我意识到的一个问题是，许多初创公司还没准备好接受机构投资，但在某种程度上被逼无奈。他们说人们在只需要现金流的时候放弃了大量股权。所以我真的想专注于一个社区基金，让人们在这些市场中实现产品市场匹配。该基金将于一月启动，我可能会发布相关公告。我对这项工作感到兴奋，并致力于在非洲大陆推广更多以产品为中心的思维。

---

### [01:21:06] Lenny

**English:**
Amazing. You should call this fun reference customers or something along those lines, if the goal is to help them find product market [fit]-

**中文翻译:**
太棒了。如果目标是帮助他们找到产品市场匹配，你应该把这个基金叫做“标杆客户”基金之类的。

---

### [01:21:12] Christian Idiodi

**English:**
That's right. They'll be learning a lot of that.

**中文翻译:**
没错，他们会学到很多相关知识。

---

### [01:21:15] Lenny

**English:**
Christian, is there anything else you wanted to share or leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
Christian，在进入我们非常精彩的闪电轮问答之前，你还有什么想分享或留给听众的吗？

---

### [01:21:21] Christian Idiodi

**English:**
I've always made an appeal to the product community to really have a sense of what they do beyond the job of a products team or product manager. And I always try to encourage people to see that: at the very core of what you do is really solving a problem. And that's creating... When you do that, create value in the world, you're making a dent in the world. People that participate in trying to make things better or trying to solve problems, and we should not shy from that definition of our job. It might feel like a fluffy one. It might feel too lightweight and not meaningful, but I think when people take to heart that that's really what the essence of products is or product work is, they bring to work a different passion, they bring to work a different sense of empathy, they bring to work a different sense of customer centricity. And all of those things lead to good outcomes.

**中文翻译:**
我一直向产品社区呼吁，要真正意识到他们在产品团队或产品经理的工作之外所做的事情。我总是鼓励人们看到：你所做工作的核心其实是解决问题。当你这样做时，你就在世界上创造了价值，你在世界上留下了印记。参与让事情变得更好或尝试解决问题的人，不应回避对自己工作的这种定义。这听起来可能有点虚，可能觉得太轻飘飘、没意义，但我认为当人们打心底里认同这就是产品或产品工作的本质时，他们会带着不同的激情去工作，带着不同的同理心去工作，带着不同的以客户为中心的意识去工作。而所有这些都会带来好的结果。

---

### [01:22:21] Christian Idiodi

**English:**
I always make that appeal to product people as like, "Yeah, all the frameworks, techniques, all the stuff, just think truly about what you're trying to do. You're trying to care enough about a problem to solve it on someone's behalf and do it so well that it give us something every time."

**中文翻译:**
我总是对产品人发出这样的呼吁：“是的，所有的框架、技术、所有的东西，只要真正思考你想要做什么。你正在努力足够关心一个问题，以便代表某人解决它，并做得非常好，以至于每次都能给我们带来回报。”

---

### [01:22:37] Lenny

**English:**
I really love that last point of just that's how you know if you've built something people care about. They give you something in return, and one of those things could be actually telling other people about it.

**中文翻译:**
我非常喜欢最后一点：这就是你如何知道你是否构建了人们关心的东西。他们会给你回报，而其中一种回报可能就是告诉别人。

---

### [01:22:44] Christian Idiodi

**English:**
That's right.

**中文翻译:**
没错。

---

### [01:22:46] Lenny

**English:**
To your point about reference customers.

**中文翻译:**
正如你提到的标杆客户。

---

### [01:22:46] Christian Idiodi

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:22:47] Lenny

**English:**
Amazing. Well, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
太棒了。那么，我们进入了非常精彩的闪电轮问答。准备好了吗？

---

### [01:22:52] Christian Idiodi

**English:**
I don't have a choice.

**中文翻译:**
我没得选。

---

### [01:22:54] Lenny

**English:**
Nope. What are two or three books that you've recommended most to other people?

**中文翻译:**
没错。你向别人推荐最多的两三本书是什么？

---

### [01:22:59] Christian Idiodi

**English:**
Oh boy. In this discipline, probably all of our books: Inspired, Empowered, and we are coming up with one in March, Transformed.

**中文翻译:**
噢，天呐。在这个领域，可能是我们所有的书：《启示录》（Inspired）、《赋能》（Empowered），还有我们即将在三月出版的《转型》（Transformed）。

---

### [01:23:08] Lenny

**English:**
I see that tee shirt there. I see the promo happening.

**中文翻译:**
我看到你穿的那件 T 恤了。我看到宣传正在进行。

---

### [01:23:10] Christian Idiodi

**English:**
Yes, it's happening. It's happening. But it's really a reflection of so many decades of love and passion for product work. And I have not found, I always told Maddie that you write the books after have gone through the failure. It's like, "I've failed at leadership, now there's a book on it. I've failed at product, now there's a book on it." And it reflects really the heart of good product work. I love Ben [Horowitz]'s The Hard Thing About Hard Things. There's some books that really describe the mindset and culture that good product work is done in. I always recommend those to people.

**中文翻译:**
是的，正在进行中。但这确实反映了数十年来对产品工作的热爱和激情。我发现——我总是告诉 Marty——你是在经历失败之后才写书的。就像是：“我在领导力上失败了，现在有了一本关于它的书。我在产品上失败了，现在有了一本关于它的书。”它反映了优秀产品工作的核心。我喜欢本·霍罗维茨（Ben Horowitz）的《创业维艰》（The Hard Thing About Hard Things）。有些书真正描述了开展优秀产品工作所需的思维方式和文化，我总是向人们推荐这些书。

---

### [01:23:43] Lenny

**English:**
Just on this topic of Transformed while we're on it, when is it coming out, and can you give just an elevator pitch for the book just so people know what it'll be about?

**中文翻译:**
既然谈到了《转型》（Transformed），它什么时候出版？你能给这本书做一个“电梯演讲”吗？好让大家知道它是关于什么的。

---

### [01:23:49] Christian Idiodi

**English:**
Transformed is coming out March next year. Oh God, just three months. Some people should have gotten shipping dates on their books if you pre-ordered it now. But it really talks about how to move to the product model or the product operating model, which is really this set of beliefs and principles that the best companies work in. We share stories of companies that have transformed into this that are not your traditional born-digital or born-tech companies that have made this transition. We tell stories of what companies can do. If it's anything, it's an appeal that there is a better way of working and solving problems and that companies can work in this way regardless of where you are in the journey.

**中文翻译:**
《转型》将于明年三月出版。天呐，只有三个月了。如果你现在预订，有些人应该已经收到了发货日期。它主要讲述如何转向“产品模式”或“产品运作模式”，这实际上是顶尖公司遵循的一套信念和原则。我们分享了一些成功转型的公司故事，它们并非传统的原生数字化或原生科技公司。我们讲述了公司可以做些什么。如果说它有什么意义，那就是它呼吁人们相信有一种更好的工作和解决问题的方式，无论你处于旅程的哪个阶段，公司都可以以这种方式运作。

---

### [01:24:32] Lenny

**English:**
All right. We'll have to have you back once the book comes out to get more people aware of what is happening. Amazing. Okay, I'll keep going. Favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
好的。等书出版后，我们一定要再请你回来，让更多人了解情况。太棒了。好的，继续。最近你非常喜欢的电影或电视剧是什么？

---

### [01:24:41] Christian Idiodi

**English:**
I jumped on the Succession bandwagon, and I enjoyed, and I used to love Billions too as well. I love good writing, really just intellectual media writing business. And so probably Succession and Billions would be two.

**中文翻译:**
我跟风看了《继承之战》（Succession），非常喜欢。以前我也很喜欢《亿万》（Billions）。我喜欢优秀的剧本，尤其是那种关于商业的、有智力含量的媒体写作。所以《继承之战》和《亿万》是我的两部首选。

---

### [01:24:57] Lenny

**English:**
Do you have a favorite interview question that you like to ask when you're interviewing candidates?

**中文翻译:**
在面试候选人时，你有没有最喜欢的面试问题？

---

### [01:25:02] Christian Idiodi

**English:**
Well, I always give them a problem to solve. That is probably my favorite question, and it's not a traditional problem. I probably will see something like, "Hey Lenny, I have a friend. He's been legally deaf or hearing impaired his whole life, and he just got a new job that requires him to wake up significantly earlier than he normally does. And as you can imagine, traditional alarm clocks will not do it, will not solve the problem. And I would love to give that problem to you. Walk me through how you go about tackling this or solving this."

**中文翻译:**
嗯，我总是给他们一个要解决的问题。这可能是我最喜欢的问题，而且它不是传统的问题。我可能会说：“嘿 Lenny，我有一个朋友。他天生失聪或有听力障碍，他刚找了一份新工作，要求他比平时早起很多。你可以想象，传统的闹钟对他不起作用，无法解决问题。我想把这个问题交给你，请向我展示你将如何应对或解决这个问题。”

---

### [01:25:38] Christian Idiodi

**English:**
For me, I like that question because it gives me a sense of how you think. It gives me a sense of how you solve problems. It gives me a sense of how you know what you do not know and how you go about knowing the things you need to know, what you need to solve a problem. There's no magical right or wrong answer. I do a lot of people that say, "I have no clue what to do. I'm more curious and because I want to now know what you do, but you don't have a clue." Or people that jump straight to solutions, are more engineering-centric. People that jump straight to... I can get a sense of who you are when I give you a problem that requires you to do some thinking.

**中文翻译:**
对我来说，我喜欢这个问题，因为它能让我了解你的思维方式。它让我了解你如何解决问题。它让我了解你如何识别自己不知道的东西，以及你如何去获取解决问题所需的知识。没有绝对的标准答案。我遇到过很多人说：“我完全不知道该怎么办。”我会更感兴趣，因为我想知道当你毫无头绪时会怎么做。或者有些人直接跳到解决方案，更偏向工程思维。当我给你一个需要思考的问题时，我能感觉到你是一个什么样的人。

---

### [01:26:15] Lenny

**English:**
And you're doing this live in an interview? It's not like, "Go home and think about this, and then-

**中文翻译:**
你是在面试现场问这个吗？不是那种“回家思考一下，然后——”

---

### [01:26:20] Christian Idiodi

**English:**
Oh, I'm doing this live in an interview.

**中文翻译:**
噢，我是在面试现场问的。

---

### [01:26:20] Lenny

**English:**
Live, okay. And then what's a sign that they're on the right track? What do you look for that's like, "Yes, this is what I want to see"?

**中文翻译:**
现场问，好的。那么，他们走在正确轨道上的迹象是什么？你寻找的“没错，这就是我想看到的”是什么？

---

### [01:26:26] Christian Idiodi

**English:**
Remember, when I think about what makes a good product manager, I look about collaborative problem solving. There are people that feel like, I'm just going to solve the whole thing myself. This is what we should do. We should do it like no evidence, no data, no kind of stuff in there. It's very interesting. But people that are saying, "You know what? I would need probably work an engineer and designer. We might need to put [inaudible 01:26:46]." I look for intellectual curiosity in some ways, people that have proven questions in your head. People that are very quick to see things [inaudible 01:26:54] people. I will talk to 20 of them. I say, "How you going to do that? Do you know sign language?" And they're like, "Oh, how am I going to talk to them?" There are people that are like, "I'm going to need a lot of help to try to figure this out. I don't know a lot about your friend, but I know..." Some people have frameworks they run to. It exposes that, if they're married to one way of working.

**中文翻译:**
记住，当我思考什么是优秀的产品经理时，我关注的是“协作式问题解决”。有些人觉得，我要靠自己解决所有问题。他们会说：“这就是我们该做的，我们应该这样做”，但没有任何证据、数据或类似的东西。这很有趣。但那些说“你知道吗？我可能需要和工程师、设计师合作。我们可能需要……”的人，我寻找的是某种程度上的求知欲，那些脑子里有经过验证的问题的人。那些能迅速洞察事物的人。我会和 20 个这样的人交谈。我会问：“你打算怎么做？你会手语吗？”他们会想：“噢，我该怎么和他们交流？”有些人会说：“我需要很多帮助来弄清楚这件事。我不了解你的朋友，但我知道……”有些人会求助于框架，这会暴露他们是否固守于某种工作方式。

---

### [01:27:14] Christian Idiodi

**English:**
It's more about knowing what you can't know. I'm looking for empathy, humility in some sense. It is a competence thing because most of I can teach, I can coach a lot of things, but that arrogance, that ego, those kinds of things, those "I walk alone," those things are very, very challenging and disruptive to a team culture.

**中文翻译:**
这更多是关于了解你无法知道的事情。我在寻找同理心，以及某种程度上的谦逊。这是一种能力问题，因为大多数东西我可以教，我可以辅导很多事情，但那种傲慢、自大、那种“我独来独往”的性格，对团队文化是非常具有挑战性和破坏性的。

---

### [01:27:35] Lenny

**English:**
Do you have a favorite product that you've recently discovered that you really like? Either an app or something physical? Anything that's like, "Oh, this is really cool"?

**中文翻译:**
你最近有没有发现什么特别喜欢的产品？无论是应用还是实物？任何让你觉得“噢，这太酷了”的东西。

---

### [01:27:43] Christian Idiodi

**English:**
My eldest son is into sports. He loves all kinds of sports stuff, sports apps, all of those kinds of things, and he got me on this app called Real, like real sports. It's really cool. It shows scores of different games, but it's really driven by social influence. So all of your Twitter posts will get there like, "Oh my God, [inaudible 01:28:07]." It's almost like real time more than real time. You're getting real time with reactions of people around you and your communities. It's a very different way of checking on a score than I've ever seen, and I thought it was just really, really thoughtful in how... I want to share reaction to touchdown with 50 people around the world that will care about my favorite team just got a touchdown, and you'll all share reactions at the same time. And the first person that saw it, you can see it. It's very simple. This is like scores for games, but these days I don't check my scores anywhere else but on it.

**中文翻译:**
我的大儿子很喜欢体育。他喜欢各种体育用品、体育应用之类的，他让我用了一个叫“Real”的应用，就像真实体育。它非常酷，显示不同比赛的比分，但它实际上是由社交影响力驱动的。所以你所有的推特帖子都会出现在那里，比如“噢，我的天呐”。这几乎比实时还要实时。你会实时看到周围人和社区的反应。这是一种我从未见过的查分方式，我觉得它在……方面非常周到。我想和世界上 50 个关心我最爱球队的人分享达阵的反应，大家会同时分享反应。第一个看到的人，你也能看到。它非常简单，就是比赛比分，但现在我除了它，不在任何其他地方查比分。

---

### [01:28:45] Lenny

**English:**
Do you have a favorite life motto that you often repeat to yourself, share with friends, either in work or in life, that you find useful?

**中文翻译:**
你有没有最喜欢的人生格言，经常对自己说，或者在工作或生活中与朋友分享，且觉得很有用的？

---

### [01:28:52] Christian Idiodi

**English:**
Wow, boy. I've said a lot in this talk about companies don't care about about you, people care about you. It's never too late to be what you want to be. But early on, my father would always tell me, "Show up. Show up, and you're ahead of 80% of the people in the free world. Show up on time, and you're ahead of 85% of the people in the free world. Show up on time with a plan, and you're ahead of 90% of the people in the free world. And if somehow you have the guts to put that plan to action with a smile, then you probably will have a great chance of success. And if you do that over and over again, every aspect of your life, it can at least lead to successful outcomes." And I think that's a lot of some mental definition for me every day.

**中文翻译:**
哇，天呐。我在这次谈话中说了很多，比如公司不关心你，只有人关心你。想成为你想成为的人，永远都不晚。但在我很小的时候，我父亲总是告诉我：“到场（Show up）。只要你到场，你就领先了自由世界 80% 的人。准时到场，你就领先了 85% 的人。带着计划准时到场，你就领先了 90% 的人。如果你有胆量带着微笑将计划付诸行动，那么你很有可能获得成功。如果你在生活的方方面面反复这样做，它至少能带来成功的结果。”我认为这对我来说是每天的一种心理准则。

---

### [01:29:37] Lenny

**English:**
Amazing. I love that. Final question: as maybe the most interesting man in the world, is there anything people may not know about you or would be surprised to hear about?

**中文翻译:**
太棒了，我喜欢这个。最后一个问题：作为“世界上最有趣的人”，有没有什么大家可能不知道、或者听了会感到惊讶的事？

---

### [01:29:48] Christian Idiodi

**English:**
Wow. I hope there are no surprises about me in that kind of case in that way, but I went to a gifted and talented school. I was out of my house at 12, and I went to kind of boarding school, and I've never been back home since then, so I've kind of been on my own. But we are kind of in the middle of nowhere, probably eight miles from any form of civilization and stuff in the middle of the jungle. No potable water, no electricity. So you kind of had to get water yourself, generate your own power. Probably the most interesting time in my life to shape my worldview, surviving at 12 to 16 on my own in the middle of the jungle. Very intriguing part of my life.

**中文翻译:**
哇。我希望我没什么让人惊讶的事，但我曾在一所天才学校就读。我 12 岁就离开了家，去了一所寄宿学校，从那以后就再也没回过家，所以我基本上是自立的。但我们当时在荒郊野外，距离任何形式的文明社会大概有八英里，就在丛林中间。没有饮用水，没有电。所以你必须自己取水，自己发电。那可能是我人生中最有趣的时光，塑造了我的世界观——12 岁到 16 岁独自在丛林中生存。这是我人生中非常迷人的一部分。

---

### [01:30:40] Lenny

**English:**
Very different from your life these days. Actually, one more question. I think you're the fourth... You're from Nigeria, right? Your family's from Nigeria?

**中文翻译:**
这和你现在的生活大不相同。实际上，还有一个问题。我想你是第四位……你来自尼日利亚，对吧？你的家人来自尼日利亚？

---

### [01:30:47] Christian Idiodi

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:30:47] Lenny

**English:**
You're the fourth Nigerian guest on this podcast, I realized. And I always like to ask, what's your favorite Nigerian food slash which food should people seek out if they were to try to find some good Nigerian food?

**中文翻译:**
我意识到你是本播客的第四位尼日利亚嘉宾。我总喜欢问，你最喜欢的尼日利亚食物是什么？或者如果人们想找点好吃的尼日利亚菜，应该尝试什么？

---

### [01:30:59] Christian Idiodi

**English:**
My favorite Nigerian is super-duper cultural and native. It's like starch and [Banga] soup. You can't really find that anywhere, it got to come from mom's cooking. Marty Cagan has tried it. He came to my hometown, my parents' house and had it. But if you are discovering Nigerian food, [Jollof] is a variation of rice, which everybody has, jollof rice, and yes people, I'm going to say this: jollof rice, Nigerian jollof is better than Ghanaian jollof. It's a war, but it's okay. We already claim victory, and we'll move on. But start with jollof rice is elementary, but then you have to try [Amala] like a pounded yam with a soup. There are many different variations of that. And you get a pounded yam, like pounded cassava, and you eat that with a soup, and you will love it.

**中文翻译:**
我最喜欢的尼日利亚菜是非常具有文化特色和本土气息的。那是淀粉配 Banga 汤。你在任何地方都找不到正宗的，必须是我妈妈做的。Marty Cagan 尝过，他去过我的家乡，在我父母家吃过。但如果你是初次尝试尼日利亚食物，Jollof 是一种米饭的变体，每个人都吃 Jollof 米饭。而且各位，我要说：尼日利亚的 Jollof 米饭比加纳的好吃。这是一场“战争”，但没关系，我们已经宣布胜利并继续前进了。从 Jollof 米饭开始是基础，然后你必须尝试 Amala，就像捣碎的山药配汤。那有很多不同的变体。你会得到捣碎的山药或木薯，配着汤吃，你会爱上它的。

---

### [01:31:45] Lenny

**English:**
Some controversy over here, competition for who's got the best rice. Amazing. Christian, I am now a huge fan of yours. I'm so happy we did this. Thank you so much for making time for this. Two final questions: where can folks find you online if they want to reach out, and how can listeners be useful to you?

**中文翻译:**
这里有点争议啊，关于谁的米饭最好吃的竞争。太棒了。Christian，我现在成了你的超级粉丝。我很高兴我们做了这次访谈。非常感谢你抽时间参加。最后两个问题：如果大家想联系你，可以在哪里找到你？听众可以如何帮到你？

---

### [01:32:00] Christian Idiodi

**English:**
You can find me on LinkedIn as well. You can reach out to us on our websites svpg.com. I tell people the best fit to be useful to us is to do good work using these principles and all the things we teach people over and over again. We care about outcomes, we care about good product work in the world. I would love your support with the work I'm doing in Africa. I've always reached out to the product community around the world to help developing countries and communities. So please follow our work, please support our work in Africa in building a product community.

**中文翻译:**
你可以在 LinkedIn 上找到我。你也可以通过我们的网站 svpg.com 联系我们。我告诉人们，对我们最有用的方式就是运用这些原则和我们反复教授的东西去做优秀的工作。我们关心结果，关心世界上优秀的产品工作。我希望大家能支持我在非洲的工作。我一直向全球产品社区寻求帮助，以支持发展中国家和社区。所以请关注我们的工作，支持我们在非洲建立产品社区。

---

### [01:32:35] Lenny

**English:**
And what is the website for that again? Specifically the nonprofit you started?

**中文翻译:**
那个网站再报一下？特别是你创办的那个非营利组织。

---

### [01:32:38] Christian Idiodi

**English:**
Innovateafricafoundation.org.

**中文翻译:**
innovateafricafoundation.org。

---

### [01:32:41] Lenny

**English:**
Amazing. Christian, thank you so much for being here.

**中文翻译:**
太棒了。Christian，非常感谢你能来。

---

### [01:32:44] Christian Idiodi

**English:**
Thank you for having me, Lenny. Such a pleasure.

**中文翻译:**
谢谢你邀请我，Lenny。非常荣幸。

---

### [01:32:46] Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。