# Christina Wodtke - 双语对照

# Lenny's Podcast: Christina Wodtke - 深度解析 OKR 与产品领导力

---

### [00:00:00] Christina Wodtke

**English:**
... people do not value celebrations enough. I've had CEOs who said, "Well, it was the middle of the quarter, so we didn't start OKRs, but we did start Friday celebrations and oh my God, things are already changing. Things are already getting better." The simple act of getting together and saying, "What was the most awesome thing that happened to you this week? What's the most awesome thing that happened in marketing? What's the most awesome thing that design did this week?" It makes people feel like they're part of something really special, and it's super exciting.

**中文翻译:**
……人们对“庆祝”的价值重视不够。我遇到过一些 CEO，他们说：“当时正值季度中期，所以我们还没开始推行 OKR，但我们开始了‘周五庆祝活动’。天哪，情况已经开始发生变化了，一切都在好转。” 这种简单的聚在一起并询问：“这周发生在你身上最棒的事情是什么？市场部最出色的成果是什么？设计团队这周做了什么了不起的事？”的行为，会让员工觉得自己是某个特别事业的一份子，这非常令人振奋。

---

### [00:00:30] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Christina Wodtke. Christina is a multi-time author, speaker, and lecturer at Stanford where she teaches product management, game design, and a few other topics. She also consults with companies on their product development processes, and in particular, their OKR process. Before getting into teaching and consulting, she was a product leader at LinkedIn, MySpace, Zynga, and Yahoo, as well as a founder of three different companies, plus an online magazine called Boxes and Arrows. In our conversation, we go deep into OKRs. What is the atomic unit of an OKR? What might be broken about your OKR process? Why you may want to roll out OKRs or change how you approach them.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Christina Wodtke。Christina 是一位多产作家、演讲家，也是斯坦福大学的讲师，教授产品管理、游戏设计等课程。她还为企业的业务开发流程提供咨询，特别是 OKR（目标与关键结果）流程。在从事教学和咨询之前，她曾在 LinkedIn、MySpace、Zynga 和 Yahoo 担任产品领导者，还是三家公司的创始人，并创办了在线杂志《Boxes and Arrows》。在今天的对话中，我们将深入探讨 OKR。OKR 的原子单位是什么？你的 OKR 流程可能出了什么问题？为什么你可能想要推行 OKR 或改变现有的方法？

---

### [00:01:20] Lenny

**English:**
Also, how the best companies leverage OKRs, the most common root causes of OKRs going wrong, the elements of a healthy OKR cadence, how OKRs fit with mission, vision, strategy, and roadmaps. We also touch on the skill of storytelling. And she also shares her most contrarian perspective on what new product managers should be focusing on. Christina is a wealth of knowledge and super interesting and fun, and I know you'll learn a lot from her. With that, I bring you Christina Wodtke, after a short word from our select sponsors.

**中文翻译:**
此外，我们还会讨论优秀的公司如何利用 OKR、OKR 出错最常见的根本原因、健康的 OKR 节奏包含哪些要素，以及 OKR 如何与使命、愿景、战略和路线图相契合。我们还会触及“讲故事”的技巧。她还将分享关于新任产品经理应该关注什么的逆向观点。Christina 知识渊博，而且非常风趣幽默，我相信你们会从她身上学到很多。在听完赞助商的简短介绍后，让我们正式欢迎 Christina Wodtke。

---

### [00:01:45] Lenny (Sponsor: Miro)

**English:**
Today's episode is brought to you by Miro, an online collaborative whiteboard that's designed specifically for teams like yours. I have a quick request, head on over to my Miro board at miro.com/lenny and let me know which guests you'd want me to have on this year. I've already gotten a bunch of great suggestions, which you'll see when you go there, so just keep it coming. And while you're on the Miro board, I encourage you to play around with the tool. It's a great shared space to capture ideas, get feedback, and collaborate with your colleagues on anything that you're working on.

**中文翻译:**
本期节目由 Miro 赞助播出。Miro 是一款专为团队设计的在线协作白板。我有一个小请求，请访问我的 Miro 画板 miro.com/lenny，告诉我你希望我今年邀请哪些嘉宾。我已经收到了很多很棒的建议，你可以在那里看到，请继续向我提议。当你访问 Miro 画板时，我鼓励你试用一下这个工具。它是一个极佳的共享空间，可以捕捉灵感、获取反馈，并与同事就任何工作项目进行协作。

---

### [00:02:22] Lenny (Sponsor: Miro)

**English:**
For example, with Miro, you can plan out next quarter's entire product strategy. You can start by brainstorming, using sticky notes, library actions, a voting tool, even an estimation app to scope out your team's prints. Then your whole distributed team can come together around wireframes, draw ideas with a pen tool, and then put full mocks right into the Miro board, and with one of Miro's ready-made templates, you can go from discovery and research to product roadmaps to customer journey flows to final mocks, all in Miro. Head on over to miro.com/lenny to leave your suggestions. That's M-I-R-O .com/lenny.

**中文翻译:**
例如，利用 Miro，你可以规划下个季度的整个产品战略。你可以从头脑风暴开始，使用便签、库操作、投票工具，甚至是用估算应用来确定团队冲刺的范围。然后，你的整个分布式团队可以围绕线框图聚在一起，用画笔工具勾勒创意，直接在 Miro 画板上放入完整的原型图。借助 Miro 现成的模板，你可以完成从探索研究到产品路线图、客户旅程图再到最终原型的全过程。请访问 miro.com/lenny 留下你的建议。

---

### [00:02:58] Lenny (Sponsor: Dovetail)

**English:**
This episode is brought to you by Dovetail, the customer insights platform for teams that gets you from data to insights fast, no matter the method. There's so much customer data to get through, from user interviews to NPS, sales calls, usability tests, support tickets, app reviews. It's a lot, and you know that if you're building something, hidden in that data are the insights that will lead you to building better products, and that's where Dovetail can help. Dovetail allows you to quickly analyze customer data from any source and transform it into evidence-based insights that your whole team can access. If you're a product manager who needs insights to motivate your team, a designer validating your next pick feature or a researcher who needs to analyze fast, Dovetail is the collaborative insight platform your whole team can use. Go to dovetailapp.com/lenny to get started today for free. That's dovetailapp.com/lenny. Christina, welcome to the podcast.

**中文翻译:**
本期节目由 Dovetail 赞助。Dovetail 是一个为团队打造的客户洞察平台，无论采用何种方法，都能帮你快速从数据中提取洞察。需要处理的客户数据非常多，从用户访谈到 NPS（净推荐值）、销售电话、可用性测试、支持工单、应用评论。数据量巨大，而你知道，如果你在构建产品，那些能引导你做出更好产品的洞察就隐藏在这些数据中。这就是 Dovetail 的用武之地。Dovetail 允许你快速分析来自任何来源的客户数据，并将其转化为整个团队都能访问的、基于证据的洞察。如果你是需要洞察来激励团队的产品经理，或是正在验证下一个功能的设计师，亦或是需要快速分析的研究员，Dovetail 都是你整个团队可以使用的协作洞察平台。立即访问 dovetailapp.com/lenny 免费开始使用。Christina，欢迎来到播客。

---

### [00:03:55] Christina Wodtke

**English:**
Thanks, Lenny. I'm really excited to be here. I've been hearing about you forever. It's so cool to be here in person.

**中文翻译:**
谢谢，Lenny。我很高兴能来到这里。我早就听说过你了，能见到本人真是太酷了。

---

### [00:04:00] Lenny

**English:**
I'm more excited for you to be on the podcast. I kind of see you as the queen of OKRs. I don't know if you like that title or not, but in my mind that's where you sit currently, and partly because from what I can tell, you've done more to help people with OKRs and understand OKRs and fix their OKR process than most anyone else I know. As I'm sure you know, a lot of people just don't like OKRs, are kind of anti-OKR and have had bad experiences with OKRs. And what I want to try to do with our chat today is to try to change people's mind, who are maybe anti-OKR and to help people optimize their OKR process if they're having an okay time with OKRs. How does that sound?

**中文翻译:**
我更兴奋你能来参加节目。我把你视为“OKR 女王”。我不知道你是否喜欢这个头衔，但在我心中，你目前就处于这个位置。部分原因在于，据我所知，你在帮助人们理解 OKR、修复 OKR 流程方面所做的工作比我认识的任何人都多。正如你所知，很多人并不喜欢 OKR，甚至有点反感 OKR，因为他们有过糟糕的体验。我今天想通过我们的聊天尝试改变那些反对者的想法，并帮助那些觉得 OKR 还行的人进一步优化他们的流程。你觉得怎么样？

---

### [00:04:39] Christina Wodtke

**English:**
That sounds just fine, although I have to say in the tech industry, it's a little too easy to be clean. Maybe when I'm a emperor for life, that might be my title.

**中文翻译:**
听起来不错。不过我得说，在科技行业，获得这种头衔（女王）似乎有点太容易了。也许等我成了“终身皇帝”，那才应该是我的头衔。

---

### [00:04:48] Lenny

**English:**
That might be by the end of this podcast, we will crown you emperor for life.

**中文翻译:**
也许到本期播客结束时，我们就会加冕你为终身皇帝。

---

### [00:04:52] Christina Wodtke

**English:**
Excellent.

**中文翻译:**
太棒了。

---

### [00:04:54] Lenny

**English:**
Okay. That'll be our goal. So, as maybe a first question, I want to give people kind of this confidence that OKRs can lead to great product, great success. What can you share, just to give people a sense of, "Here's how many companies who are having a great time with OKRs, here's the impact OKRs can have on your company if you roll it out or make it more optimal."

**中文翻译:**
好，这就是我们的目标。作为第一个问题，我想给听众一些信心，让他们相信 OKR 能够带来优秀的产品和巨大的成功。你能分享一下，让大家感受到“有多少公司在 OKR 的帮助下表现出色”，以及“如果你推行或优化 OKR，它能给公司带来多大的影响”吗？

---

### [00:05:15] Christina Wodtke

**English:**
I've seen so many companies do extremely well with it, and I would say that not all companies will be successful, period. Companies are really successful with it are companies that... I think I can swear a little, they have their shit together.

**中文翻译:**
我见过太多公司通过 OKR 取得了极大的成功。但我也要说，并非所有公司都能成功，事实就是这样。那些真正成功的公司，通常是那些……我想我可以爆句粗口，是那些“把事情理顺了（have their shit together）”的公司。

---

### [00:05:27] Lenny

**English:**
Absolutely. 100%.

**中文翻译:**
没错，百分之百同意。

---

### [00:05:29] Christina Wodtke

**English:**
And the first step is, get your shit together. They have strategy, they have empowered teams, they have psychological safety, and then the OKRs are that extra layer that supercharges them. So, I say OKRs are more of a vitamin, they're not a medicine. So, if you take OKRs and you're like, "Oh, this will fix everything that's wrong with you." No, that's not going to happen. It's just going to reveal everything that's wrong with your company. But if you've done the hard work of getting your company to be strong, it's amazing how well it works. It works really well with startups. It works really well with multidisciplinary product teams. I've seen it over and over. I don't really have permission to talk about all my clients, but I have one client that I'm just working with right now, and it's a purpose built company. So, in other words, they exist in order to make the lives of their customers better, healthier, wellness.

**中文翻译:**
第一步就是把基础打好。这些公司有战略，有获得赋能的团队，有心理安全感，而 OKR 则是为他们提供额外动力的那一层“超级增压器”。所以我常说 OKR 更像是一种维生素，而不是药物。如果你觉得“噢，OKR 能治好公司所有的毛病”，那是不可能的。它只会揭示你公司存在的所有问题。但如果你已经努力让公司变得强大，OKR 的效果会好得惊人。它在初创公司和跨学科产品团队中表现尤为出色。我见过无数次这样的案例。虽然我不能透露所有客户的名字，但我现在正合作的一家客户是一家“使命驱动型”公司。换句话说，他们存在的意义就是让客户的生活更美好、更健康。

---

### [00:06:20] Christina Wodtke

**English:**
And so, they used OKRs to really create this amazing focus on, what does it mean to make everybody's life healthier? And one thing that came out of applying OKRs was this wonderful idea, they're bringing robots into their warehouses, not to replace their humans, they're keeping all the humans, but to reduce the amount of back problems their humans have. So, the humans are doing much more complex tasks, thinking about inventory and how to be more efficient. And the robots are doing the heavy lifting. They've been growing and growing like crazy. And the OKRs are this very simple way of allowing you to focus on what actually matters and making sure you don't forget in the chaos of everyday life. So, if you know what you're trying to do, then the OKRs just help that happen. It aligns the company. And I think they're a lot like dieting advice, in that they say, "Eat less and exercise more." Well, that's really simple. It's worked for me. I've lost 25 pounds doing eat less and exercise more. But wow, it's hard. It's really hard to do. And I think about OKRs that way. You have to just stay with it and be strong and committed, and that will help.

**中文翻译:**
他们利用 OKR 建立了一种惊人的专注力，去思考“让每个人的生活更健康意味着什么？”。应用 OKR 的一个成果是这个绝妙的创意：他们在仓库中引入机器人，不是为了取代人工（他们保留了所有员工），而是为了减少员工背部受伤的问题。这样，人类可以从事更复杂的任务，比如思考库存管理和提高效率，而机器人负责重体力活。这家公司一直在疯狂增长。OKR 是一种非常简单的方法，让你专注于真正重要的事情，并确保你在日常生活的混乱中不会忘记初衷。如果你知道自己想做什么，OKR 就能助你一臂之力。它能让全公司达成一致。我觉得 OKR 很像减肥建议：“少吃多运动”。这听起来很简单，对我也有用，我通过这种方式减掉了 25 磅。但哇，这真的很难坚持。OKR 也是如此，你必须坚持下去，保持强大和投入，它才会起作用。

---

### [00:07:36] Lenny

**English:**
There's a number of things I want to follow up on in what you said.

**中文翻译:**
你刚才说的话里有很多我想深入探讨的点。

---

### [00:07:39] Christina Wodtke

**English:**
Sure.

**中文翻译:**
当然可以。

---

### [00:07:39] Lenny

**English:**
So, I'll start with, you talked about the benefits of OKR. If you had to just boil down, here's what OKRs can do for you as a company, as an organization, what would that be? What's just the main benefit of OKRs at your company?

**中文翻译:**
那我们先从 OKR 的益处开始。如果你必须总结一下 OKR 能为公司或组织做些什么，那会是什么？在公司推行 OKR 的核心益处是什么？

---

### [00:07:51] Christina Wodtke

**English:**
The main benefit is that there's a lot of concrete action through a OKR that you don't always get from strategy. Strategy tends to be a little longer, a little more Muji Muji. And then when you get the OKR, you say, "This quarter is what we're actually going to be doing, and these are the numbers we're actually going to be pushing further." So, that's really good. It creates a cadence of progress, which is incredibly valuable. It creates alignment. There's no question what the single most important thing to do in the company is, assuming you're doing radical focus and you don't have 20 OKRs every quarter. Ugh, don't like to think about that. And last of all, the thing that I don't see a lot of people talking about that I think is really amazing, is because an OKR focuses you for one quarter and at the end of the quarter you grade your OKRs.

**中文翻译:**
核心益处在于，OKR 能带来战略往往无法提供的“具体行动”。战略通常比较长远，甚至有点“玄学（Muji Muji，指模糊不清）”。而当你有了 OKR，你会说：“这个季度我们实际要做的是这些，我们要推进的具体数字是这些。”这非常好。它创造了一种“进度的节奏”，这极具价值。它还能带来一致性。假设你做到了“极致专注（radical focus）”，而不是每个季度搞 20 个 OKR（呃，我都不敢想那种场景），那么公司里最重要的那一件事是什么，将毫无疑问。最后一点，也是我没见多少人提起但我觉得非常了不起的一点：因为 OKR 让你专注于一个季度，而在季度末你会给 OKR 打分。

---

### [00:08:40] Christina Wodtke

**English:**
How well did we do? What got in our way? It creates this learning cycle. So, then you can take that information and say, "Next quarter, what should we try next?" And I think the time is the thing that a lot of leaders really struggle to think about. But if you've been really focusing on say, retention for one quarter, two quarters, and then you go over and say, "Okay, let's work on acquisition." You don't forget all the things you learned about retention. No, you're just building knowledge and building knowledge and building knowledge, which means your company will constantly get smarter and more effective.

**中文翻译:**
我们会反思：我们做得怎么样？什么阻碍了我们？这创造了一个“学习循环”。然后你可以利用这些信息决定：“下个季度，我们接下来该尝试什么？”我认为“时间维度”是很多领导者难以把握的。但如果你已经专注研究了比如“留存率”一两个季度，然后转去研究“获客”，你并不会忘记关于留存的经验。不，你是在不断积累知识，这意味着你的公司会变得越来越聪明、越来越高效。

---

### [00:09:13] Lenny

**English:**
I love this. So, just to summarize, the main benefits are focuses you, lines, creates a cadence and creates a learning cycle. And maybe a simple way to think about it is, it's like a plug-and-play product development process. You don't have to invent everything from scratch. There's this thing that exists. I know it's not the whole piece of it, but yeah, maybe... You're nodding and I'm curious, when I say that, what comes to mind?

**中文翻译:**
太棒了。总结一下，核心益处是：让你专注、达成一致、创造节奏以及建立学习循环。也许一个简单的理解方式是：它就像一个“即插即用”的产品开发流程。你不需要从零开始发明一切，它是一套现成的体系。我知道它不是全部，但……我看你在点头，我想知道当我这么说时，你脑子里想到了什么？

---

### [00:09:36] Christina Wodtke

**English:**
Yeah, I guess you have to have a product development process, because obviously otherwise you're just running around chickens with your heads cut off, but it keeps you from making the same stupid mistake over and over and over again, which has been a goal in my life. My motto is, "Make new mistakes." So, by having this focus on really important things, not to spread yourself too thin, like the famous peanut butter memo from Yahoo, which I guess was long ago enough, not everybody remembers it. But companies have a tendency to try to do everything all at this exact moment. And so, everybody's working with 1% on this, 1% on that and 1% on the other. And instead you use the OKRs and say, "Okay, this is the big rock we're going to move. This is the big thing that's going to happen this quarter, and you can fiddle around with all the other stuff if you want, but this one has to move."

**中文翻译:**
是的，你确实需要一个产品开发流程，否则你就像无头苍蝇一样乱撞。但 OKR 能防止你一遍又一遍地犯同样的愚蠢错误，这一直是我的人生目标。我的座右铭是：“犯点新错误”。通过专注于真正重要的事情，而不是像雅虎著名的“花生酱备忘录（peanut butter memo，指资源像抹花生酱一样摊得太薄）”那样分散精力（我猜那已经是很久以前的事了，不是每个人都记得）。公司往往倾向于在同一时刻尝试做所有事情，结果每个人都在这个项目上花 1% 的精力，在那个项目上花 1%。相反，你使用 OKR 并宣布：“好，这是我们要搬动的大石头。这是本季度要发生的大事，其他的琐事你可以随便弄弄，但这一件必须推进。”

---

### [00:10:27] Christina Wodtke

**English:**
And then the next quarter, the next thing gets moved and so on. And it just accelerates the speed of your accomplishments so much. It's kind of mind-blowing. I've actually been running my life for the last eight, 10 years on OKRs as well because I'm ADHD and I'm all over the place. And so, looking at my OKRs every single Monday and saying, "Well, am I going to work on a book? Am I going to work on my teaching? Am I going to work... Where do I want to put that attention?" It changes me personally, just like it changes my clients.

**中文翻译:**
然后下个季度，再搬动下一块石头，以此类推。这会极大地加速你取得成就的速度，简直令人惊叹。实际上，在过去的八到十年里，我也一直在用 OKR 管理我的生活，因为我有 ADHD（多动症），思维很跳跃。所以，每周一查看我的 OKR，问自己：“我是要写书？还是要准备教学？我该把注意力放在哪？”这改变了我个人，就像它改变了我的客户一样。

---

### [00:11:00] Lenny

**English:**
What's an example of your personal care? You said writing a book maybe could be one?

**中文翻译:**
能举个你个人 OKR 的例子吗？你提到写书可能是一个？

---

### [00:11:03] Christina Wodtke

**English:**
Well, I wish, but no, it's actually been health. One of the great things about managing my OKRs for so long is I discovered this pattern, which is that anytime things get busy, I just stop taking care of myself completely. And that's really bad because if I'm healthy, I can be there for my kid, I can be there for my students, I can be there for my colleagues. So, this quarter's been about setting up habits of well-being and like I said, I've been really pleased at how it's been going.

**中文翻译:**
我也希望是写书，但实际上是健康。长期管理个人 OKR 的一个好处是，我发现了一个模式：每当工作变忙，我就会完全停止照顾自己。这很糟糕，因为只有我健康，我才能陪伴孩子、学生和同事。所以这个季度的目标是建立健康的生活习惯。正如我所说，我对目前的进展非常满意。

---

### [00:11:30] Lenny

**English:**
Amazing. I haven't heard that before. What would you say is kind of the atomic unit of an OKR? So, people talk about, "We're doing OKRs, we're not doing OKRs". What's the line between we have goals and a plan, and we're actually doing OKRs as a concept?

**中文翻译:**
太棒了，我以前没听过这种用法。你认为 OKR 的“原子单位”是什么？人们常说“我们在做 OKR”或“我们没做 OKR”。那么，“拥有目标和计划”与“真正践行 OKR 理念”之间的界限在哪里？

---

### [00:11:44] Christina Wodtke

**English:**
Gosh, what is the atomic unit? That's a really lovely question. I would say, "What am I doing this week to get closer to our goals?" If you could answer that question, you could give up all the OKR stuff, but if you just asked the question, "What are we doing this week to get closer to our strategic goals, our longer term goals?" That is the very heart of it, because there's the tomorrow problem, like my kid will do his homework tomorrow, and tomorrow never comes. It's always tomorrow, tomorrow, tomorrow. So, what are we doing right now? And I find that it's really useful to tie it into temporal landmarks.

**中文翻译:**
天哪，原子单位是什么？这真是个好问题。我会说，它是：“我这周要做什么来接近我们的目标？”如果你能回答这个问题，你甚至可以抛弃所有 OKR 的繁文缛节。但如果你只是问：“我们这周要做什么来接近我们的战略目标或长期目标？”这就是核心所在。因为存在“明天问题”，就像我孩子总说“我明天做作业”，但明天永远不会到来。永远是明天、明天、明天。所以，我们现在在做什么？我发现将它与“时间地标（temporal landmarks）”结合起来非常有用。

---

### [00:12:21] Christina Wodtke

**English:**
By that I mean that there are things like birthdays or New Year's or Mondays or quarters that are already built into the world. And so, we piggyback onto them and we say, "Okay, it's Q1, boom, we're going to stop. We're going to take a breath, we're going to look at everything and we're going to say, 'What do we actually have to do?'" Raising your head above the noise is really vital. "And then this quarter, remember we have a mission over here and we have a vision and we have a strategy. Okay, this quarter's all about, what?" And you move towards that.

**中文翻译:**
我指的是像生日、新年、周一或季度这样已经存在于世界运行规律中的节点。我们利用这些节点说：“好，现在是第一季度，停一下，喘口气，审视一切，然后问：‘我们到底必须做什么？’”从噪音中抬起头来至关重要。“然后这个季度，记住我们有使命、愿景和战略。好，这个季度的重点是什么？”然后朝着那个方向努力。

---

### [00:12:52] Christina Wodtke

**English:**
I know there's a lot of talk about outcomes and I think that's absolutely right. It's really critical to think about outcomes because that gives you flexibility on how to attack the problem. But the biggest question is, why? Why do we get up in the morning? What are we trying to actually do? Are we making a difference at all? And if you can say, "This week I'm going to do this," and then at the end of the week you say, "Oh, that worked or that didn't work," and you can try something new or keep going. That's just invaluable.

**中文翻译:**
我知道现在有很多关于“结果（outcomes）”的讨论，我认为这完全正确。思考结果至关重要，因为这让你在解决问题的方法上具有灵活性。但最大的问题是：为什么？我们早上为什么要起床？我们到底想做什么？我们真的在改变世界吗？如果你能说：“这周我要做这件事”，然后在周末说：“噢，这起作用了”或“没起作用”，接着你可以尝试新方法或继续前进。这才是无价的。

---

### [00:13:18] Lenny

**English:**
That is really interesting that your answer wasn't like its outcome or some key results and 70% of success is goal, that there's something more fundamental, which is just being very clear on what you should be doing next week and we should be focusing on now. And that translates into what kind of the OKR process ends up being.

**中文翻译:**
这很有趣，你的答案不是“结果”或“某些关键结果”或者“达成 70% 就算成功”，而是更基础的东西：清楚地知道下周该做什么，以及现在该关注什么。这最终转化成了 OKR 流程的本质。

---

### [00:13:34] Christina Wodtke

**English:**
Oh, yeah. Can I tell you a little story?

**中文翻译:**
噢，是的。我能给你讲个小故事吗？

---

### [00:13:37] Lenny

**English:**
Absolutely.

**中文翻译:**
当然可以。

---

### [00:13:37] Christina Wodtke

**English:**
So, this is personal OKRs, but it works for everything else. It's always easier to talk about personal OKRs because I don't have to do an NDA with myself, so I apologize. But I've had this accountability group with these three women for at least five years, and every Monday we send our OKRs to each other, and I do it the way I do it in the book. Another woman, she had the getting things done approach where it was like, "How percentage did I make and what am I trying to do?" And exactly, super detailed.

**中文翻译:**
这是关于个人 OKR 的，但也适用于其他任何事情。谈论个人 OKR 总是更容易，因为我不需要和自己签保密协议（NDA），所以抱歉。我和另外三个女性组成了一个“互助问责小组”，至少有五年了。每周一我们都会互相发送 OKR，我按照书里的方法做。另一个女性采用的是 GTD（Getting Things Done）的方法，比如“我完成了百分之几，我正尝试做什么”，非常详细。

---

### [00:14:06] Christina Wodtke

**English:**
And then another woman was like, "Ah, I don't know. I guess I'm trying to think about... What am I trying to think about? Oh, maybe I should think about if I have to get out of product management or not." Well, now the woman who was very precise has kind of disappeared. I think it was just something that she couldn't keep up that level of diligence. While the woman who was hand-waving, she actually has gone from a product manager to a consultant to a life coach, and she's making so much money, and she is so damn happy, and she has a new house. And so, I really do think that the heart of everything is answering that question.

**中文翻译:**
还有一位女性则是这种风格：“啊，我不知道。我想我正在考虑……我在考虑什么来着？噢，也许我该考虑一下是否要离开产品管理岗位。”结果，那位非常精确的女性现在基本消失了，我想她可能无法维持那种程度的勤奋。而那位当初“随性而为”的女性，实际上已经从产品经理转型为顾问，再到人生教练，她现在赚了很多钱，非常快乐，还买了新房子。所以我真的认为，一切的核心就是回答那个问题。

---

### [00:14:44] Lenny

**English:**
And what is that question?

**中文翻译:**
那个问题是什么？

---

### [00:14:46] Christina Wodtke

**English:**
What am I doing this week to get to the outcome I really want? Her outcome was to not worry about money and be joyful with what she was doing. And she got that just by every Monday saying, "What the fuck am I doing here? What am I trying to do again?" And it worked.

**中文翻译:**
“我这周要做什么，才能达到我真正想要的结果？”她的结果是不再为钱担心，并在工作中获得快乐。她通过每周一问自己：“我到底在干嘛？我到底想达成什么目标？”最终实现了这一点。这确实奏效了。

---

### [00:15:03] Lenny

**English:**
That is a really cool framework. So, the question you ask yourself every week is, "What am I doing today that's helping me get closer to my outcomes?" Is that the word to use outcome?

**中文翻译:**
这框架太酷了。所以你每周问自己的问题是：“我今天做的哪件事能帮我更接近我的‘结果’？”是用“结果（outcome）”这个词吗？

---

### [00:15:12] Christina Wodtke

**English:**
Yeah, yeah, exactly. And it is an outcome. In her case, it was not worrying about money, having a house, having joy in her work. I think a lot of us get caught up in, do I want to be a writer? Do I want to be this thing? When the reality is, we just want to be satisfied and happy. And with a business, it's the same thing. We get caught up in this or that little details, but you need to go back and say, "What was our mission?" I mean, think about it. How often do companies ever talk about their mission? It's like they set it, they forget it, it's super vague, it's useless.

**中文翻译:**
对，没错。这就是一个结果。对她来说，结果就是不愁钱、有房子、工作愉快。我觉得我们很多人都纠结于“我想当作家吗？”或“我想成为某种身份吗？”，而现实是，我们只是想获得满足和快乐。对于企业来说也是一样。我们纠结于各种细节，但你需要回到原点问：“我们的使命是什么？”想想看，公司多久谈论一次使命？通常是设定后就忘了，而且非常模糊，毫无用处。

---

### [00:15:42] Christina Wodtke

**English:**
Instead, it's good to think, "Okay, when we started this company or when we changed this company or grew this company," or whatever you want to go to, there's always these various points in time. "Why? What did we think would work? And let's go back to that moment of meaning and reconnect with it and then make it real in the activities we take every week." And I like every week rather than every day. Because the reality is we still have to do progress reviews and we still have to do accounting and whatnot, but if we just push a little bit each week, over time amazing things happen.

**中文翻译:**
相反，最好去思考：“好，当我们创办这家公司，或者转型、扩张时，”无论处于哪个阶段，总会有这些时间点。“为什么？我们当时认为什么会奏效？让我们回到那个有意义的时刻，重新建立联系，然后将其落实到每周的活动中。”我更喜欢“每周”而不是“每天”。因为现实中我们还需要做进度审查、财务核算等等，但如果我们每周都能推进一点点，随着时间的推移，奇迹就会发生。

---

### [00:16:15] Lenny

**English:**
So, I want to drill into some of these things, of just how mission, vision, roadmap and OKRs kind of fit together, just to be pretty tactical. So, as a PM say, or founder, what is the process you recommend for working through mission, vision, and then OKRs, and then roadmap?

**中文翻译:**
我想深入探讨一下使命（mission）、愿景（vision）、路线图（roadmap）和 OKR 是如何结合在一起的，我们聊得具体一点。作为产品经理或创始人，你推荐的流程是怎样的？如何处理使命、愿景，然后是 OKR，最后是路线图？

---

### [00:16:33] Christina Wodtke

**English:**
I think it's really important to have a mission, and people get freaked out because they think the mission's forever. And so, they make them super vague so they can do anything. But instead, if you think about it, if the mission lasts for five years, what would you like to see happen in five years? And it might be, "We're going to bring amazing games that delight our users and we're proud to ship into the world." That could be a mission. And it's like, "Okay, I could do that over the next five years." And then, there'll be a point where you probably want to change again. So, you're bringing, what does it mean? What does it mean to be proud? What does it mean to delight people? Really talk about that and get into the nitty-gritty. And then out of that would come your strategy, which is this is going to be our year of exploration, if you have enough money for such a thing.

**中文翻译:**
我认为拥有使命非常重要。人们感到害怕是因为他们觉得使命是永恒的，所以他们把它写得极其模糊，以便什么都能往里装。但相反，如果你认为使命只持续五年，你希望五年后看到什么发生？比如：“我们要带来让用户愉悦、让我们自豪地推向世界的精彩游戏。”这可以是一个使命。你会觉得：“好，接下来的五年我可以为此努力。”然后，可能会有一个点你想再次改变。所以，你要思考：这意味着什么？“自豪”意味着什么？“让用户愉悦”意味着什么？深入探讨这些细节。接着，战略就会由此产生，比如“今年将是我们的探索之年”（如果你有足够的资金支持的话）。

---

### [00:17:18] Christina Wodtke

**English:**
Or this is going to be our year of making our current games a little bit better. I'm in a very game mindset today because I was talking to a client. So, you get into that. Okay, now we have this sort of idea of what we're doing with our year. Now, let's talk about the quarter. And you can use OKRs for the year, but the quarter is where they have the most impact, I believe. Spotify talked about doing quarterly performance reviews because it's long enough to get something done and short enough to not forget what you did. And I think that sums it up perfectly for OKRs as well. So, once you know where you're trying to be, and once you know what you want to do with your year, you can say, "What are the things we want to see happen across these four quarters?"

**中文翻译:**
或者“今年我们将致力于让现有的游戏变得更好”。我今天满脑子都是游戏，因为刚和一位客户聊过。好，现在我们对这一年要做什么有了大致的想法。接下来谈谈季度。你可以设定年度 OKR，但我认为季度 OKR 的影响力最大。Spotify 曾谈到进行季度绩效评估，因为这段时间长到足以完成一些事情，又短到不会让你忘记自己做了什么。我认为这同样完美总结了 OKR。所以，一旦你知道了目标所在，知道了年度计划，你就可以问：“在这四个季度里，我们希望看到什么发生？”

---

### [00:18:01] Christina Wodtke

**English:**
I call it sort of a half-built strategy because too much strategy ties you down and too little strategy, you're too responsive to everything. So, you say, "Okay." Let's say you're building a new game. So, Q1 is about figuring out what it is and what's going to be interesting to users. And then Q2 is going to be about getting some early prototypes out and validating those concepts. And Q3 is about building extensive, and Q4 is about marketing and throwing it out, something like that. And you could venture them into your outcomes. A lot of people who are very venture driven don't understand outcomes, objectives, excuse me, objectives, outcomes, potato, potato.

**中文翻译:**
我称之为“半成品战略”，因为战略太多会束缚你，战略太少又会让你对任何事都疲于应付。所以你会说：“好，假设我们要开发一款新游戏。”第一季度是弄清楚它是什么，以及用户会对什么感兴趣。第二季度是推出早期原型并验证这些概念。第三季度是进行大规模开发，第四季度是市场推广和发布。你可以把这些转化为你的“结果”。很多受风险投资驱动的人不理解“结果（outcomes）”和“目标（objectives）”的区别，抱歉，其实它们大同小异（potato, potato）。

---

### [00:18:39] Christina Wodtke

**English:**
It's really something inspiring. Q1, we have a vision for this game that will drive us forward. I don't know, I'm making stuff up, which just means it's going to be imperfect. Although I do warn people not to get too caught up in wordsmithing. We can spend hours doing that. And then, you get to ask my favorite question, how do we know? I love, how do we know? That's how you get to outcomes. So, what does it mean to have a vision for a product we believe will be successful and meet our mission, whatnot? Well, what would it be? How are we going to figure this out? So, something about user testing, probably. Maybe we do a landing page, see how many people are excited by the concept. Maybe we do some technical builds to see if it's actually buildable. What are the sort of things that would tell us, yes, please go forward? We might be excited about VR. Well, how do we know that VR would be profitable for us?

**中文翻译:**
目标应该是鼓舞人心的。比如第一季度：“我们对这款游戏有一个能推动我们前进的愿景。”我是在瞎编，所以肯定不完美。但我确实警告过人们不要太纠结于文字推敲，那会耗费数小时。然后，你可以问我最喜欢的问题：“我们如何知道（how do we know）？”我太爱这个问题了。这就是你推导“结果”的方法。拥有一个我们相信会成功并符合使命的产品愿景意味着什么？那会是什么样子？我们如何弄清楚？可能涉及用户测试。也许我们做一个落地页，看看有多少人对这个概念感到兴奋。也许我们做一些技术构建，看看它是否可行。哪些信息会告诉我们“是的，请继续推进”？我们可能对 VR 很兴奋，但我们如何知道 VR 对我们来说是有利可图的？

---

### [00:19:35] Christina Wodtke

**English:**
So, once we answer those three, how would we know, then we can know that by March we have the results we need. And we're always going to try to think about the best possible future, the whole moonshot thing, which I'm a fan of, but the reality is, the reason we do that estimating is so we get good at estimating. Everybody sucks at estimating when you first start, and a lot of people think it's like black magic or something you're born with. But no, it's a learned skill. You practice estimating, you get good at estimating, you get better and better and better. And being good at estimating is incredibly valuable as a business skill. So, there's your OKRs, right? And then for Q2, we don't know how Q1 is going to go, so we're just going to leave the objective there, but we're not going to get into the nitty-gritty OKRs. Key results cause a lot of arguing among the team, takes forever to track them down, just wait and see how Q1 goes. And that way you have enough play within your strategy to react to new information.

**中文翻译:**
一旦我们回答了那三个“我们如何知道”，我们就能确定到三月份时我们是否得到了想要的结果。我们总是尝试思考最好的未来，也就是所谓的“登月计划（moonshot）”，我是这一套的粉丝。但现实是，我们进行估算的目的是为了“擅长估算”。刚开始时，每个人的估算都很烂，很多人觉得这像黑魔法或是天赋。不，这是一项习得的技能。你练习估算，就会变得擅长，然后越来越好。擅长估算是一项极具价值的商业技能。这就是你的 OKR，对吧？至于第二季度，我们还不知道第一季度进展如何，所以我们只保留一个目标（Objective），而不去纠结具体的 OKR 细节。关键结果（Key Results）往往会引发团队争论，追踪它们也要花很长时间，所以先看看第一季度的情况。这样你的战略就有足够的空间来应对新信息。

---

### [00:20:32] Lenny

**English:**
The question you talked about of, how do we know? That's to decide the objective or the key results?

**中文翻译:**
你提到的那个问题“我们如何知道？”，是为了确定目标（Objective）还是关键结果（Key Results）？

---

### [00:20:39] Christina Wodtke

**English:**
Key results, yeah.

**中文翻译:**
是关键结果。

---

### [00:20:40] Lenny

**English:**
Okay, got it. You're saying objective. Okay, cool.

**中文翻译:**
好，明白了。你刚才说了目标，好，没关系。

---

### [00:20:42] Christina Wodtke

**English:**
Objective. My bad. I didn't signal when I turned. No.

**中文翻译:**
目标。我的错，我转弯时没打信号灯。不。

---

### [00:20:49] Lenny

**English:**
Oh, okay, cool. That makes sense.

**中文翻译:**
噢，好，没关系。这说得通。

---

### [00:20:49] Christina Wodtke

**English:**
Objective is that vision for the quarter. This is what we're we're driving towards in this quarter. And then the key results, you answered the question, how do we know we succeeded?

**中文翻译:**
目标是该季度的愿景。这是我们本季度努力的方向。而关键结果，则是回答“我们如何知道自己成功了？”这个问题。

---

### [00:20:58] Lenny

**English:**
And so, what was the tip you gave of turning strategy into the objective? How do you translate from strategy to deciding your objective for the core?

**中文翻译:**
那你刚才给出的关于将战略转化为目标的建议是什么？你如何从战略转化为决定该季度的核心目标？

---

### [00:21:06] Christina Wodtke

**English:**
Oh, that sits between mission and OKRs. So, strategy, I've been really shocked lately. I've discovered that lots of companies don't seem to have any strategy whatsoever, which just blows my mind. So, if you think about strategy as a strongly held hypothesis about a way to win in the market and fulfill our vision, then you can say, "Well, our mission is this, or vision..." I kind of use them interchangeably because I think they are kind of interchangeable, and I'm not going to get in semantics in the bitty bits, but the strategy is really important because it says, "We think we're fulfilling our mission of connecting people, by what?"

**中文翻译:**
噢，战略介于使命和 OKR 之间。关于战略，我最近真的很震惊。我发现很多公司似乎根本没有任何战略，这让我大开眼界。如果你把战略看作是一个“关于如何在市场中获胜并实现愿景的坚定假设”，那么你可以说：“好，我们的使命是这个，愿景是……”我倾向于把它们混用，因为我觉得它们在某种程度上是可以互换的，我不想在细枝末节的语义上纠结。但战略非常重要，因为它说明了：“我们认为我们通过‘什么方式’来实现连接人们的使命？”

---

### [00:21:55] Christina Wodtke

**English:**
I think that there are a lot of good product strategy pieces out there, but businesses have a lot of questions to answer. Are we going to ship physical products? Are we going to ship digital products? Are we going to be a service? Are we going to do a subscription? Strategy answers those questions. They say, "We're going to have a game. It's going to be an Apple Arcade. We have a hypothesis that's actually going to help us. We're going to build in there and build our customer base there in order to get name recognition, which we can then use on other platforms." That's the sort of strategic stuff. And then we're like, "Oh great, you have a vision. What are we doing? What does that actually mean for us this year, this quarter, and then eventually this week?"

**中文翻译:**
我认为市面上有很多优秀的产品战略文章，但企业有很多问题需要回答。我们要交付实体产品吗？我们要交付数字产品吗？我们要提供服务吗？我们要搞订阅制吗？战略回答了这些问题。战略会说：“我们要开发一款游戏，放在 Apple Arcade 上。我们的假设是这会对我们有帮助。我们要在那里建立客户群以获得知名度，然后我们可以将其利用到其他平台上。”这就是战略层面的东西。然后我们会说：“太棒了，你有愿景了。那我们要做什么？这对我们今年、这个季度，以及最终这周意味着什么？”

---

### [00:22:39] Lenny

**English:**
For the actual OKRs you end up with, is it as simple as just with the template of an OKR, is it just objective three-ish key results? Is there anything more to it that you recommend folks use?

**中文翻译:**
对于最终形成的 OKR，是否就像 OKR 模板那样简单：一个目标加上三个左右的关键结果？你还推荐大家使用其他什么元素吗？

---

### [00:22:51] Christina Wodtke

**English:**
No. Simple things give you a lot more room to fiddle. And I feel like every time I see people make really complicated methodologies, they get way too caught up in the rules and they don't think about, what are we actually trying to do? So, simple is better.

**中文翻译:**
不。简单的东西给你留下了更多的调整空间。我觉得每次看到人们制定非常复杂的方法论时，他们都会深陷于规则之中，而不再思考“我们到底想做什么”。所以，简单更好。

---

### [00:23:04] Lenny

**English:**
And what's your rule of thumb for number of key results?

**中文翻译:**
关于关键结果的数量，你的经验法则是什么？

---

### [00:23:06] Christina Wodtke

**English:**
I like three. I think about it as triangulating. I always like something that's really hardcore numbers. I like something that's a little squishier, like a quality, make sure you don't forget about it. And I usually like something that involves a dollar sign, but it's really going to be specific to what objective you're trying to do. Launch a new product. Well, you probably want to make a certain amount of money, well you want a certain amount of reach, and then you want that delight thing. And then when you get into the delight thing, you can say, "Well, is it going to be Metacritic? Is it going to be a survey? Is it going to be NPS?" You know, could figure out what one makes the most sense for you.

**中文翻译:**
我喜欢三个。我把它看作是“三角定位”。我总是喜欢一个硬核的数字指标；一个稍微“软”一点的指标，比如质量，确保你不会忽视它；通常我还喜欢一个涉及金额（美元符号）的指标。但这确实取决于你试图实现的目标。比如发布新产品：你可能想赚一定数额的钱，想要一定的触达率，然后想要那种“愉悦感”。当你深入研究愉悦感时，你可以问：“是用 Metacritic 评分？是问卷调查？还是 NPS？”你可以找出对你最有意义的那一个。

---

### [00:23:45] Lenny

**English:**
That's an interesting topic. Is there anything you find there to measure customer happiness, satisfaction, delight? What have you seen work best for that sort of squishy stuff?

**中文翻译:**
这是个有趣的话题。在衡量客户幸福感、满意度、愉悦感方面，你有什么发现吗？对于这种“软性”的东西，你觉得什么最有效？

---

### [00:23:53] Christina Wodtke

**English:**
I know there's a big backlash against NPS. I think it's okay. It's really funny because you can be insanely successful with a game that people feel yucky to play, and you can be incredibly successful with a product people hate using. Zoom, for example. How many times have you heard Zoom get cussed out? So, the question is, why would I care about that if I'm making money? And I would say the answer is, would you like to keep making money? It's always about retention.

**中文翻译:**
我知道现在有很多人反对 NPS。我觉得它还行。很有趣的是，你可以通过一款让人玩起来感觉很糟的游戏获得疯狂的成功，也可以通过一个人们讨厌使用的产品获得巨大的成功。比如 Zoom，你听过多少次人们咒骂 Zoom？所以问题是，如果我能赚钱，我为什么要关心这个？我的回答是：你想一直赚钱吗？这始终关乎留存率。

---

### [00:24:23] Lenny

**English:**
Right.

**中文翻译:**
对。

---

### [00:24:24] Christina Wodtke

**English:**
So, anytime you can get strong retention signals, I think those are good signals to get. So, that comes out of qualitative research. There's nothing better. So, if you don't have a qualitative researcher on your team, I think you should get one. You need somebody who knows how to separate what people say and what they do, and what the truth is in that. And then use that to apply to your strategic decisions, so that happy users sell your product for you, right? Happy users stay with your product. Happy users are willing to type an email telling you when you're messing up. I mean, you want committed users. They're just so important.

**中文翻译:**
所以，任何时候只要你能获得强烈的留存信号，我认为那都是值得获取的好信号。这源于定性研究，没有比这更好的了。如果你的团队中没有定性研究员，我认为你应该招一个。你需要有人知道如何区分人们“说的”和“做的”，以及其中的真相是什么。然后将这些应用到你的战略决策中，这样快乐的用户就会为你推销产品，对吧？快乐的用户会留下来，快乐的用户甚至愿意写邮件告诉你哪里搞砸了。我是说，你需要忠实用户，他们太重要了。

---

### [00:24:58] Lenny

**English:**
One final question around the actual OKR document. What do you find are the most one or two common mistakes people make when writing out the objective or the key result in deciding on what to go with?

**中文翻译:**
关于 OKR 文档的最后一个问题。你发现人们在撰写目标或关键结果，以及决定采用哪些内容时，最常见的一两个错误是什么？

---

### [00:25:09] Christina Wodtke

**English:**
Objectives, people make them so fluffy that they don't have any meaning. They really should be a proper goal. We're doing this because we want to see this happen, it matters. We want to delight our customers. Sometimes people make them too fluffy and sometimes they make them too boring. It's like, "Oh, we're going to ship this thing." That doesn't inspire anybody. Your objectives should make you, when your alarm goes off and you wake up, you go, "Oh yeah, I'm changing the world today, or I'm doing something really cool." It shouldn't be like, snooze. So, I think an objective should be motivating but not ridiculous.

**中文翻译:**
关于目标（Objectives），人们常把它写得太虚（fluffy），以至于没有任何意义。它应该是一个真正的目标：我们做这件事是因为我们想看到这件事发生，这很重要。比如“我们要让客户感到愉悦”。有时人们把它写得太虚，有时又太无聊，比如“噢，我们要发布这个东西”。这无法激励任何人。你的目标应该让你在闹钟响起起床时想：“噢耶，我今天要去改变世界，或者去做些酷毙了的事。”而不应该是想按掉闹钟继续睡。所以，我认为目标应该是激励人心的，但不能荒谬。

---

### [00:25:42] Christina Wodtke

**English:**
And then the key results, it's always going to be tasks. I mean, people put tasks in there all the time, and it can be tricky. Sometimes it feels like a task, like you have to get past a product review, so it's going to have a binary. They either said yes or no. But when you think about it, it is an outcome because it's really hard to get a product review group to say okay to anything. So, making sure that you have real outcomes that let you move forward, I think that's the biggest mistake people make in OKRs.

**中文翻译:**
至于关键结果（Key Results），最常见的错误是把它写成“任务”。我是说，人们总是把任务放进去，这有时很微妙。有时它看起来像任务，比如“通过产品评审”，这是一个二元的结果（要么过，要么不过）。但仔细想想，它其实是一个“结果”，因为让产品评审小组对任何事情点头都很难。所以，确保你拥有能让你前进的真正“结果”，我认为这是人们在 OKR 中犯的最大错误。

---

### [00:26:13] Lenny

**English:**
Yeah. I know you shared a few examples of just that came top-of-mind, but just is there any examples you can think of just, here's a really good example of an outcome? And I think your results are a lot easier, just move this metric 10% or hit-

**中文翻译:**
是的。我知道你刚才分享了几个随口想到的例子，但你还能想到什么“真正好的结果示例”吗？我觉得量化结果更容易，比如“将此指标提升 10%”或者达成……

---

### [00:26:25] Christina Wodtke

**English:**
Let's try to keep it fairly concrete. You're a online magazine selling interior design ideas. So, what are you trying to do? You're trying to get strong leads out to your advertisers, and that's really important, and you're doing it because you believe that people deserve to have homes that are warm and wonderful. You have this mission, and you want to make money while you do it. So, your strategy is going to be about connecting human beings with the brands that will suit their lifestyle. Okay, that's great. And then we get to the nitty-gritty, well, what does that actually mean? Are we going to really work on recommendations passionately? Are we going to really create various markets and throw down advertising where we think these people are? That's when your strategy comes into play because you're making all these interesting choices. So, let's say we're going to double down on recommendations, which has a lot of presuppositions.

**中文翻译:**
让我们试着具体一点。假设你经营一家销售室内设计创意的在线杂志。你想做什么？你想为广告商提供高质量的销售线索（leads），这很重要。你这样做是因为你相信人们值得拥有温馨美好的家。你有这个使命，同时你想赚钱。所以你的战略是：将人类与适合他们生活方式的品牌连接起来。好，这很棒。然后进入细节：这到底意味着什么？我们要充满激情地研究推荐算法吗？我们要开辟不同的市场，并在我们认为目标人群所在的地方投放广告吗？这就是战略发挥作用的时候，因为你在做各种有趣的决策。假设我们决定在“推荐”上加倍投入，这包含了很多前提。

---

### [00:27:23] Christina Wodtke

**English:**
We have to get people to like, we have to understand their patterns of behavior, and that's when we can start to go to OKRs. We can say, "Okay, so we have this online magazine, let's really work to get as many people being members rather than browsers as possible, so that we can start understanding what they like." And that's what Q1 could be really about, is starting to collect profiles of people's passions, and that sounds kind of exciting. "Okay, great. We're going to do that. We're going to create a profile of people's passions. Awesome." So, how would we know we were successful? "Oh, gosh. Well, we probably need a bunch of people to do it, but do we really need everybody? Maybe 30% of our audience flips over, and maybe that's right, maybe that's wrong." If you don't know, you just set it and you'll know by the end of Q3, whether you were stupid or not, it's fine, move on.

**中文翻译:**
我们必须让人们产生“喜欢”，必须理解他们的行为模式，这时我们就可以开始制定 OKR 了。我们可以说：“好，我们有这家在线杂志，让我们努力让尽可能多的人成为会员而不是游客，这样我们就能开始了解他们的喜好。”这就是第一季度的核心：开始收集人们兴趣爱好的画像（profiles），这听起来挺让人兴奋的。“好，太棒了，我们就这么干，我们要建立用户兴趣画像。太酷了。”那么，我们如何知道自己成功了？“噢天哪，我们可能需要很多人参与，但真的需要所有人吗？也许 30% 的受众转化过来就行，也许这个数字对，也许不对。”如果你不知道，就先设定一个，到第三季度末你就知道自己当初是不是傻了，没关系，继续前进。

---

### [00:28:12] Christina Wodtke

**English:**
Okay, that's great. Okay, how many things should people do what with? So, they bookmark, favorite, like... How about like? Okay, so maybe they're going to like a certain number of products each week. Let's go for weekly active users. So, they're going to like three things and present it. Okay, so now we've got a couple of numbers that are pretty good. How do we know they're actually kind of liking it? Maybe you decide to do some panels, and we're going to measure using a customer panel, bring them in, have them talk to us, and we're going to do that at the end of every two weeks to hear how it's working and understand more about it.

**中文翻译:**
好，这很棒。那么，人们应该做多少操作？书签、收藏、点赞……点赞怎么样？好，也许他们每周会点赞一定数量的产品。让我们关注“周活跃用户（WAU）”。他们会点赞三样东西。好，现在我们有几个不错的数字了。我们如何知道他们是真的喜欢？也许你决定做一些用户访谈小组（panels），邀请客户过来和我们聊聊，每两周做一次，听听反馈，加深理解。

---

### [00:28:54] Christina Wodtke

**English:**
Okay, now we have some OKRs. With key results, I always recommend spending 10 minutes brainstorming every single way you could possibly measure that outcome. Because with brainstorms, you always think of all the obvious stuff first and then you have no ideas and you're just sitting there with your post notes going, "How long is 10 minutes anyway?" And then you start getting the weird ideas. And often out of those weird ideas are really good insights. So, I recommend some pretty long brainstormings on the key results, but the objective is sort of a manifestation of the strategy at a one quarter level.

**中文翻译:**
好，现在我们有了一些 OKR。关于关键结果，我总是建议花 10 分钟头脑风暴所有可能的衡量该结果的方法。因为在头脑风暴中，你总是先想到显而易见的东西，然后就没主意了，只能盯着便签想：“10 分钟怎么还没到？”接着，你会开始产生一些奇怪的想法。而往往正是这些奇怪的想法中蕴含着极佳的洞察。所以我建议在关键结果上进行较长时间的头脑风暴，而目标则是战略在季度层面的体现。

---

### [00:29:26] Lenny

**English:**
Amazing. That was an awesome example. You talked a bit earlier about how OKRs end up being... or sorry, key results end up being tasks for a lot of people. And this reminds me, we had the CPO of Figma on this podcast, and he told the story of how they moved away from OKRs at one point because they found themselves sitting in these meetings reviewing these large spreadsheets of hundreds of tasks-

**中文翻译:**
太棒了，这个例子非常好。你之前提到 OKR 最终变成了……抱歉，是关键结果对很多人来说变成了“任务”。这让我想起 Figma 的 CPO 曾在这个播客上讲过，他们一度放弃了 OKR，因为他们发现自己坐在会议室里，审查着包含数百个任务的巨大电子表格——

---

### [00:29:49] Christina Wodtke

**English:**
Oh, god. Yeah.

**中文翻译:**
噢，天哪。是的。

---

### [00:29:50] Lenny

**English:**
... that were basically just tasks for ICs that they're working on, and they kind of lost sight of why does any of this matter? What are you even trying to do as a company? So, they moved away from OKRs and then they came back to them actually later and fixing some of these issues. So, maybe just as a question, what do you think is a sign that your OKR process is busted and that you need to spend some time improving and rethinking the way it works?

**中文翻译:**
……那些基本上只是个人贡献者（IC）正在做的任务，他们有点看不清为什么这些事情重要，甚至看不清公司到底想做什么。所以他们放弃了 OKR，后来又重新启用并修复了这些问题。所以我想问，你认为 OKR 流程“坏掉了”、需要花时间改进和反思的迹象是什么？

---

### [00:30:13] Christina Wodtke

**English:**
I think if those meetings are boring, that's a great example. One of the other benefits, which I didn't bring up about OKRs is that they scale really well. One of the biggest problems founders struggle with is they don't scale very well, but if you can set a good OKR and get people to work on it, then you don't have to decide all those little IC tasks. You don't want to be drug down with that. You got a job. CEOs got to figure out what's coming up down the line, not fiddling over everybody's tasks. So, you set the OKRs and then you ask in the meeting, "What are the top three initiatives that you're doing towards them?" Or two or five, whatever. It's going to vary a little bit, but you want to keep it small. You only want to look at the most important stuff and just trust your people to take care of everything else.

**中文翻译:**
我认为如果会议变得无聊，就是一个典型的迹象。OKR 的另一个我还没提到的好处是它的扩展性（scale）非常好。创始人面临的最大问题之一就是他们自己很难扩展，但如果你能设定好的 OKR 并让大家执行，你就不必去决定那些细小的 IC 任务。你不想被那些琐事拖累。你有自己的工作。CEO 应该思考未来的规划，而不是纠结于每个人的任务。所以，你设定 OKR，然后在会议上问：“为了达成这些目标，你们正在做的前三大举措（initiatives）是什么？”或者是两个、五个，随你。这会有所不同，但你要保持精简。你只想关注最重要的事，并信任你的员工会处理好其他一切。

---

### [00:30:58] Christina Wodtke

**English:**
And then you can say, "Well, why do you think that's important? What do you think that's going to do?" Or, "I've been seeing that for weeks. Are you going to try something else anytime soon?" It's all about those conversations about, is our current strategy, not just at the company level, but at each departmental level, are these strategies working? Are they moving us forward, towards our goals? And so, looking through OKRs, I tell people, "When you first start, it might take a half hour, but after that it should just take 10 minutes." It's like, "I think that's stupid. We should talk about that." Or, "No, it looks fine, looks essentially correct, let's move on. Anybody got anything?" And then you can get into whatever else you do, if it's a metrics review situation or if it's talking about a new deal, the rest of the agenda.

**中文翻译:**
然后你可以问：“你为什么觉得这很重要？你觉得这会产生什么效果？”或者：“这件事我已经看了好几周了，你打算什么时候尝试点别的？”这一切都关乎对话：我们目前的战略（不仅是公司层面，还有部门层面）是否奏效？它们是否在推动我们向目标前进？所以，在审查 OKR 时，我告诉人们：“刚开始可能需要半小时，但之后应该只需要 10 分钟。”比如：“我觉得这很蠢，我们得谈谈。”或者：“不，看起来不错，基本正确，继续。还有人有事吗？”然后你可以进入议程的其他部分，无论是指标回顾还是讨论新交易。

---

### [00:31:43] Christina Wodtke

**English:**
But that constant checking in is like touching a lucky stone in your pocket. It reminds you, "Oh yeah, there's this thing, there's this thing." And that rhythm... I'm a teacher, I'm really into learning theory. So, there's a really big concept which is about repetition and retrieval practice. So, retrieval practice means that I put a fact in your brain and I keep asking you to go back and get it again. Qualitative research is really useful for understanding the psychology of your users.

**中文翻译:**
这种不断的检查就像摸着口袋里的幸运石。它提醒你：“噢对，还有这件事，还有那件事。”这种节奏……我是一名教师，我对学习理论非常感兴趣。有一个很重要的概念叫“重复”和“提取练习（retrieval practice）”。提取练习意味着我把一个事实放入你的大脑，然后不断要求你回去再次提取它。定性研究对于理解用户的心理非常有用。

---

### [00:32:15] Christina Wodtke

**English:**
I'll say, "Well, how do we understand the psychology of users?" And you'd be like, "Oh, I heard this." Okay, I bring it up. Well, it's the same thing in these weekly meetings, you're practicing retrieving what your OKRs are, and after a while they're just in that long-term memory and you don't have to struggle to think about them and you've got them. And anytime you make a decision and you're in a big rush, you don't want to go through a bunch of paper to try to find what were our OKRs? You just go, "Boo, this is what we should do. I know what we're trying to do and I know how to make a decision about that."

**中文翻译:**
我会问：“我们如何理解用户的心理？”你会说：“噢，我听到了这个。”好，我把它提出来。在每周会议中也是一样，你在练习提取你的 OKR 是什么。一段时间后，它们就进入了你的长期记忆，你不需要费劲去想，你就掌握了它们。任何时候当你需要匆忙做决定时，你不需要翻阅一堆文件去找“我们的 OKR 是什么？”，你直接就能反应过来：“砰，这就是我们该做的。我知道我们的目标，我知道该如何据此做决定。”

---

### [00:32:44] Lenny

**English:**
So, what I'm hearing is, a lot of this comes back to, if the meeting is not interesting and boring, change the way you run the meeting. Don't go through everything. Maybe just pick the things that are most interesting and focus on that. You don't have to review every single key result.

**中文翻译:**
所以我听到的是，很多问题归结为：如果会议没意思、很无聊，那就改变开会的方式。不要过每一项内容。也许只挑选最有趣的事情并专注于此。你不需要审查每一个关键结果。

---

### [00:32:57] Christina Wodtke

**English:**
Keep the meeting level at the right place. I'm sorry, I wandered off in a different direction. I get really nerdy around learning theory.

**中文翻译:**
把会议维持在正确的层级上。抱歉，我扯远了。一谈到学习理论我就容易变书呆子。

---

### [00:33:03] Lenny

**English:**
No, I love it. I love learning how to learn. Feel free to share more as things come up. Okay. So, I don't know. I'm trying to think. Figma, I imagine they probably thought they could change this meeting, but I think maybe there's a more deep-rooted issue. And this is kind of where my next question is going to go, is what do you think are just the root issues of OKRs going wrong?

**中文翻译:**
不，我喜欢这个。我喜欢学习“如何学习”。想到什么尽管分享。好，我在想，Figma 当时可能也想过改变会议形式，但我认为可能存在更深层次的问题。这正是我下一个问题的方向：你认为 OKR 出错的根本原因是什么？

---

### [00:33:24] Christina Wodtke

**English:**
Oh, my god.

**中文翻译:**
噢，天哪。

---

### [00:33:25] Lenny

**English:**
Maybe that's a symptom of the meeting, they're really boring, but yeah.

**中文翻译:**
也许会议无聊只是一个症状，但是……

---

### [00:33:27] Christina Wodtke

**English:**
Well, the symptom, it's really wrong. Yeah, it means that you're in the weeds, man. You're fiddling with the little tiny bits. You got to let go of those. You have to trust your people. So, if we do the five why's, okay, why don't you trust your people? Is it you or are you hiring horribly? Okay, if you're hiring horribly, why are you hiring horribly? Is it because you can't find the right people? Is it because you're rushing through it? You have to keep chasing it down. OKRs are a great diagnostic tool because they tell you something's broken. So, if your OKRs are going sideways, something's broken deeper. There's also the problem with psychological safety. You need your teams to be able to say, "This isn't working. We're doing something else." Instead of just saying, "This isn't working, tell us how to fix it."

**中文翻译:**
那个症状确实说明出大问题了。这意味着你深陷琐事之中，伙计。你在纠结那些细枝末节。你必须放手，必须信任你的员工。如果我们用“五个为什么”来分析：好，你为什么不信任员工？是你自己的问题，还是你招人的眼光太差？好，如果你招人很差，为什么？是因为找不到合适的人，还是因为招得太匆忙？你必须不断追问下去。OKR 是一个极佳的诊断工具，因为它能告诉你哪里出了问题。如果你的 OKR 跑偏了，说明深层有东西坏了。还有心理安全感的问题。你需要你的团队能够说：“这行不通，我们要换个法子。”而不是只说：“这行不通，告诉我们怎么修。”

---

### [00:34:13] Christina Wodtke

**English:**
People are coming to you and saying, "How do we fix this problem?" Something's broken in the company. You're doing something wrong as a leader. You have to think about, if somebody doesn't know what to do and you're like, "Well, I have a strategy. I told you what my strategy is." And they don't know how to make decisions, it means something's wrong with the strategy or you aren't being clear, because the conversation always has two people. There's an old joke that I think about a lot, which is, if during the day you meet one asshole, he's probably an asshole. But if all day long you meet nobody but assholes, you might be the asshole. And I think that's very true. If your entire company's confused, you might be the asshole. You have to think about, how can I get more clear? If people are constantly bringing you little things, it's not because they're scared, it's because you're scary.

**中文翻译:**
如果人们总是跑来问你：“我们怎么解决这个问题？”，那说明公司内部出了问题。作为领导者，你肯定做错了什么。你得想，如果有人不知道该做什么，而你却说：“我有战略啊，我告诉过你我的战略是什么。”如果他们还是不知道如何做决定，那就意味着战略有问题，或者你表达得不清楚，因为沟通是双向的。我常想起一个老笑话：如果你一天中遇到一个混蛋，那他可能是混蛋；但如果你整天遇到的全是混蛋，那你可能才是那个混蛋。我觉得这很真实。如果整个公司都感到困惑，你可能就是那个“混蛋”。你得思考：我如何能表达得更清晰？如果人们不断拿小事来烦你，不是因为他们胆小，而是因为你太吓人了。

---

### [00:35:01] Christina Wodtke

**English:**
So, a lot of times your OKRs breaking are speaking to something else happening, and if your OKR process isn't working, then you have to step back and go, "Okay, how far deep do I have to go before I figure out what's wrong with my management team?" And it could be the CEO, but it could actually be some weird group dynamics, and you've got to focus on that. I really love Patrick Lencioni. Five Dysfunctions of a Team is his most famous book, and I would recommend that if you like the fable style book. But it's the same thing. You got to fix things at the top, you got to do your own work, and then everything else runs a little better.

**中文翻译:**
所以，很多时候 OKR 的崩溃反映了其他问题的发生。如果 OKR 流程不奏效，你就得退一步想：“好，我得深挖到什么程度才能发现管理团队出了什么问题？”可能是 CEO 的问题，也可能是某种奇怪的团队动态，你必须关注这一点。我很喜欢 Patrick Lencioni，他最著名的书是《团队协作的五种障碍》（Five Dysfunctions of a Team），如果你喜欢寓言风格的书，我推荐读读。道理是一样的：你得从顶层解决问题，做好你该做的工作，然后其他一切才会运转得顺畅一点。

---

### [00:35:40] Lenny (Sponsor: Writer)

**English:**
This episode is brought to you by writer. How much hype have you been hearing about generative AI? So much. But how do you take it from a shiny toy to an actual business tool that helps you do your actual job? Writer is an enterprise grade generative AI platform built specifically for the needs of businesses, and already widely deployed at world-class brands like Uber, Spotify, HubSpot, and UiPath. With Writer, you can break through content bottlenecks across your organization, from marketing webpages to sales emails and product messages, to creating high quality on-brand content at scale. And unlike other AI applications, Writers' training happens securely on your data and your style and brand guidelines that you provide specific to your organization. The result is that you get consistent content in your brand voice at scale. Get AI that your people will love. For a limited time, listeners to Lenny's Podcast can get 20% off if they go to writer.com/lenny, that's writer.com/lenny.

**中文翻译:**
本期节目由 Writer 赞助。你听到了多少关于生成式 AI 的炒作？非常多。但你如何将它从一个闪亮的玩具变成一个能帮你完成实际工作的商业工具呢？Writer 是一个专为企业需求打造的企业级生成式 AI 平台，已被 Uber、Spotify、HubSpot 和 UiPath 等世界级品牌广泛部署。借助 Writer，你可以突破整个组织的内容瓶颈，从营销网页到销售邮件和产品信息，大规模创建高质量、符合品牌调性的内容。与其他 AI 应用不同，Writer 的训练是在你的数据以及你为组织提供的风格和品牌指南上安全进行的。结果是，你可以大规模获得符合品牌语调的一致内容。获得员工喜爱的 AI。在限定时间内，Lenny 播客的听众访问 writer.com/lenny 即可享受 20% 的折扣。

---

### [00:36:57] Lenny

**English:**
If you think back to what most often is the issue, in your experience, is it something at the top? Is it a middle manager doing something wrong? Is it just misunderstanding how to use OKRs? What do you think is usually the issue with OKRs not working well?

**中文翻译:**
回想一下，根据你的经验，最常见的问题是什么？是顶层的问题？是中层管理人员做错了什么？还是仅仅是对如何使用 OKR 的误解？你认为 OKR 运行不畅通常是因为什么？

---

### [00:37:32] Christina Wodtke

**English:**
I can repeat everything I said, but instead I'll just say speed. People read, measure what matters. They get their panties in a bunch, they get really excited. They're just going to do OKRs for everybody, but they didn't really read the whole thing. You kind of skimmed it and you don't really understand how it works, and so you just implement it. Or you ask your head of HR to implement it, and it gets implemented and everybody's really happy and then they're really sad and then they spit it out. And then you say, "Okay, OKRs don't work." I mean, that's what I see over and over again. Nobody calls me for advice when they are thinking about OKRs. They call me for advice when they've done it in sales, every damn time.

**中文翻译:**
我可以重复我刚才说的一切，但我想强调的是“速度”。人们读了《量入为出》（Measure What Matters，又译《衡量关键指标》），然后变得非常激动。他们打算给每个人都搞 OKR，但其实并没读透。只是走马观花地看了看，并不真正理解它是如何运作的，然后就直接推行。或者让 HR 负责人去推行，推行后大家先是很开心，然后很痛苦，最后把它唾弃掉。接着你会说：“好吧，OKR 没用。”这就是我反复看到的场景。没人会在“考虑”做 OKR 时找我咨询，他们总是在搞砸了之后才来找我，每次都是这样。

---

### [00:38:13] Christina Wodtke

**English:**
I think it's... What is it, the illusion of knowledge? If I asked you right now, how does a bicycle work, or how does a pen work? You'd be like, "I know how that works." And if you tried to write it out, you couldn't. Well, I couldn't. How does a ballpoint pen work? Okay, there's a spring and there's some ink. I'm not sure. So, really thinking about, how would OKRs work throughout the company, is valuable. So, because you don't have time as a leader, what you should do is just give my book to your best team and say, "We're thinking about OKRs. Can you guys see if it works?" And then three months later, check in with them. "What did you figure out, guys?" Okay.

**中文翻译:**
我认为这是一种……怎么说呢，“知识的错觉”？如果我现在问你，自行车是怎么工作的，或者圆珠笔是怎么工作的？你会说：“我知道啊。”但如果你试着写出来，你可能写不出来。反正我写不出来。圆珠笔怎么工作的？好吧，有个弹簧，有些墨水，我不确定。所以，真正思考 OKR 在整个公司如何运作是非常有价值的。作为领导者，如果你没时间，你应该做的是把我的书交给你的“最强团队”，然后说：“我们正在考虑 OKR，你们能试试看它是否奏效吗？”三个月后，去问问他们：“伙计们，你们发现了什么？”

---

### [00:38:44] Christina Wodtke

**English:**
Because the best team always wants to be better. I love piloting with the best team, but they're still very imbued in your culture, so they'll figure out where OKRs in your culture don't fit. They'll figure out where it's helpful and then they can give it back to you and you have a template, and then you can take it to two more teams, and then you can take it to two more teams. And maybe you adopt it with your management team, little bit by little bit. That's how I tell people to start with OKRs. Just figure out your best multidisciplinary team team and say, "You guys start and let us know."

**中文翻译:**
因为最优秀的团队总是想变得更好。我喜欢在最强团队中进行试点，但他们仍然深受公司文化的影响，所以他们会发现 OKR 在你的文化中哪些地方不契合。他们会发现哪里有用，然后反馈给你，你就得到了一个模板。接着你可以把它推广到另外两个团队，再推广到更多团队。也许最后你会在管理层也采用它，一点一点来。这就是我告诉人们开始 OKR 的方式：找一个最棒的跨学科团队，说：“你们先开始，然后告诉我们结果。”

---

### [00:38:54] Lenny

**English:**
This might be a good time to talk a little bit more about your book for folks that are actually planning to roll out OKRs or trying to fix their OKRs. Can you just talk about what it is, how to find it, what it's called, anything else.

**中文翻译:**
现在可能是进一步介绍你那本书的好时机，适合那些正计划推行 OKR 或尝试修复 OKR 的人。你能聊聊那本书吗？叫什么名字，怎么找到它，还有其他信息吗？

---

### [00:39:27] Christina Wodtke

**English:**
Yeah, it's called Radical Focus. I could have called it Guide to OKRs, but I think what's really important is to learn how to focus on the most important things and make them happen. It is a business fable, as they call it, where I tell a story about two startup founders and their struggle to find focus and how OKRs help them. And then the second half, it's the second edition that's out now, it's gotten twice as big because I started working with big companies as well as startups and had to work through, what does it mean when you have a larger company and what struggles they follow?

**中文翻译:**
是的，书名叫《极致专注》（Radical Focus）。我本可以叫它《OKR 指南》，但我认为真正重要的是学习如何专注于最重要的事情并实现它们。这是一本所谓的“商业寓言”，我讲了两个初创公司创始人努力寻找专注力，以及 OKR 如何帮助他们的故事。现在的第二版内容增加了一倍，因为我开始与大公司以及初创公司合作，必须解决大公司在推行时会遇到什么问题以及面临哪些挑战。

---

### [00:39:57] Christina Wodtke

**English:**
And so, I think the first part's nice because it's fun to read stories, but I think what's really good about is what you notice, which is when I talk you through this company trying to figure out what their OKRs were, everything became a lot more clear. And I think that's one of the powers of stories, is seeing an example. And then the rest of it is really like you could almost open it to any page and look at your problem, go, "Oh my problem's with strategy or my problem's with tasks versus outcomes." And you could flip around and figure out, what's the piece I need to solve?

**中文翻译:**
我认为第一部分很棒，因为读故事很有趣。但我觉得真正好的一点是，当你看到我描述这家公司如何努力确定他们的 OKR 时，一切都变得清晰多了。我认为这就是故事的力量：看到一个具体的例子。剩下的部分就像工具书，你几乎可以翻到任何一页，对照你的问题，比如“噢，我的问题出在战略上”或者“我的问题出在任务与结果的混淆上”。你可以翻阅并找出你需要解决的那部分。

---

### [00:40:01] Lenny

**English:**
And folks can find it on Amazon if they search for Radical Focus?

**中文翻译:**
大家在亚马逊搜索《Radical Focus》就能找到吗？

---

### [00:40:01] Christina Wodtke

**English:**
It's everywhere, baby.

**中文翻译:**
到处都有，宝贝。

---

### [00:40:05] Lenny

**English:**
Wow. Which one's your most favorite language it's been translated into?

**中文翻译:**
哇。在所有翻译版本中，你最喜欢哪种语言？

---

### [00:40:08] Christina Wodtke

**English:**
Well, Chinese, because it sells like crazy because apparently some Chinese actress said she loved it and then it's been selling bigger there than anywhere else.

**中文翻译:**
嗯，中文版。因为它卖得疯快，显然是因为某位中国女演员说她很喜欢这本书，然后它在那里的销量就超过了其他任何地方。

---

### [00:40:17] Lenny

**English:**
So, Chinese actresses using OKRs, what is going on?

**中文翻译:**
中国女演员也在用 OKR？这世界怎么了？

---

### [00:40:21] Christina Wodtke

**English:**
Mind blown. Once again, life is always more surprising than anything you can imagine.

**中文翻译:**
大开眼界。再次证明，生活总是比你能想象到的任何事情都更令人惊讶。

---

### [00:40:25] Lenny

**English:**
I have more questions I want to ask you about OKRs, but you were talking about storytelling and fables and things like that. So, you also wrote a book about, not that we're going to go through all your books, but you wrote a book about drawing and the power of drawing, and also you just believe in storytelling as a really powerful tool. So, I'd love to hear just your take on why storytelling is so powerful and why skilled drawing is so important for product leaders at the [inaudible 00:40:48].

**中文翻译:**
关于 OKR 我还有更多问题想问，但你刚才提到了讲故事和寓言。你还写过一本关于绘画及其力量的书（我们不会过完你所有的书），而且你坚信讲故事是一个非常强大的工具。我很想听听你对“为什么讲故事如此强大”以及“为什么熟练的绘画对产品领导者如此重要”的看法。

---

### [00:40:48] Christina Wodtke

**English:**
I think there are some things that are fundamentally human that are built into our genes. Storytelling's one. If all of human history was a clock, we started writing things down at 11:00 PM, so most of human history has been an oral tradition where we told each other stories to help pass on knowledge. And so, don't get anywhere near the big kitty with the great big teeth because you will die, or don't eat those red berries because my grandfather threw up for three days and then croaked. But we tell them better than that. Longer stories tend to have more conflicts and they tend to be seen as having more information. So, if you use storytelling, you're talking to the most ancient part of the human brain and you will get attention, you'll get comprehension and you'll get retention. The teacher's Holy Trinity, right?. So, I love stories. They work well, they catch people's attention.

**中文翻译:**
我认为有些东西是人类天生就刻在基因里的，讲故事就是其中之一。如果把人类历史比作一个时钟，我们直到晚上 11 点才开始发明文字。所以人类历史的大部分时间都是口头传统，我们通过讲故事来传递知识。比如：“别靠近那只有大牙齿的大猫，否则你会死”或者“别吃那些红浆果，因为我爷爷吃了吐了三天然后就断气了”。但我们讲得比这更精彩。长故事往往有更多冲突，也被认为包含更多信息。所以，如果你使用讲故事的方式，你是在与人类大脑最古老的部分对话，你会获得注意力、理解力和记忆力。这就是教师的“神圣三位一体”，对吧？所以我爱故事，它们效果极佳，能抓住人们的注意力。

---

### [00:41:38] Christina Wodtke

**English:**
And one thing I read that kind of blew my mind was, they said that if you tell people a bunch of facts, they'll forget most of them, especially those that don't fit into their current mental model of how the world works. But if you tell them a story that's full of facts, they will remember it. And if you look at TED, everybody loves a TED Talk. They're mostly all just stories, and facts sprinkled inside those stories. So, I think stories are very powerful. I think images are very powerful. Words are very abstract. If I say the word chair, what pops into your brain? Was it a big easy chair? Was it a hard wooden chair? We use these words as if everybody knows what we're talking about, but people don't.

**中文翻译:**
我读到过一件让我大开眼界的事：如果你告诉人们一堆事实，他们会忘掉大部分，尤其是那些不符合他们现有世界观（心智模型）的事实。但如果你给他们讲一个充满事实的故事，他们就会记住。看看 TED 演讲，大家都爱看，它们大多只是故事，而事实则点缀在故事之中。所以我认为故事非常强大，图像也同样强大。文字是非常抽象的。如果我说“椅子”这个词，你脑子里会出现什么？是一把大安乐椅？还是一把硬木椅？我们使用这些词，好像大家都知道我们在说什么，但其实不然。

---

### [00:42:22] Christina Wodtke

**English:**
So, in my time in industry, because I was at, what, Yahoo, LinkedIn, Zynga, MySpace, stuff like that, I just found if I got on the whiteboard and drew really badly, and I think it's almost important to draw badly, make some marks, make some squares. Somebody else will go, "No, no, no, it doesn't work that way. Give me this pen," and start doing it. And it gets you so fast to a shared vision of what's going on. I know designers spend all this time making wireframes and I'm like, that's the lamest use of time ever. Just get some whiteboards, go into the room with your engineers and start making some marks together and that just works better.

**中文翻译:**
在我的职业生涯中，无论是在 Yahoo、LinkedIn、Zynga 还是 MySpace，我发现如果我走到白板前画得很烂（我觉得画得烂反而很重要），随便画几笔、画几个方块，别人就会说：“不不不，不是那样的，笔给我，”然后开始画。这能让你非常快地达成共识。我知道设计师花大量时间制作线框图，我觉得那是对时间最差劲的利用。直接找块白板，和工程师进屋一起画几笔，效果要好得多。

---

### [00:42:56] Christina Wodtke

**English:**
And I found that for some reason in America, people seem to think that you have to be one of the chosen few and born a drawer. But it's like anything, it's like playing piano, you just got to practice a little bit. So, the book mostly just has some really simple things you can draw, and then it tells you how to use them in business. So, I wanted to make something that was even simpler than Back of the Napkin, which is an awesome book, but gets pretty intense, pretty quickly.

**中文翻译:**
我发现不知为何在美国，人们似乎认为你必须是天选之子、天生就会画画。但其实这和任何事情一样，就像弹钢琴，你只需要练习一下。所以我的那本书里主要是一些非常简单的、你可以画出来的东西，然后告诉你如何在商业中使用它们。我想做一些比《餐巾纸背后的战略》（Back of the Napkin）更简单的东西，那本书很棒，但很快就会变得很深奥。

---

### [00:43:22] Lenny

**English:**
With the storytelling piece, I feel like most people are like, "Yes, I know storytelling is powerful." But they don't know how to do it. Is there one tip you could share? Just how to get a little bit better at storytelling or integrate storytelling into your work as a product leader or founder?

**中文翻译:**
关于讲故事，我觉得大多数人都会说：“是的，我知道讲故事很强大。”但他们不知道该怎么做。你能分享一个建议吗？如何稍微提高讲故事的能力，或者如何将讲故事融入到产品领导者或创始人的工作中？

---

### [00:43:37] Christina Wodtke

**English:**
If you say one tip, you're really holding me down. I would say-

**中文翻译:**
如果你只让我说一个建议，那真是难倒我了。我会说——

---

### [00:43:41] Lenny

**English:**
You could do two tips if that makes it easier.

**中文翻译:**
如果你觉得容易点，可以说两个。

---

### [00:43:43] Christina Wodtke

**English:**
... when you finish telling a story, if you're telling it to someone you can trust, say, "What's something I could have done to make the story better?" You're going to find out, do I just blather on forever, or do I not give enough details? I mean, if you're only going to do one thing, get feedback, is always the answer. The second tip would be structurally there's a beginning, middle, and end. Intrigue people with a hook, a mystery. That's the beginning, right? A mystery, a secret, a surprise. The middle is, you can tell them a little bit about it. That's where you get your message in. If you're trying to pitch something, sneak your product in, whatever. And the end is always going to be success and celebration because you're trying to get people excited about your story or remember this information. So, just a basic structure in your head really, can kind of make a big difference.

**中文翻译:**
……当你讲完一个故事，如果是讲给信任的人听，问问：“我该怎么做才能让这个故事更好？”你会发现，我是不是废话太多，还是细节不够？我的意思是，如果你只能做一件事，答案永远是“获取反馈”。第二个建议是结构：要有开头、中间和结尾。用一个“钩子（hook）”或悬念吸引大家，这就是开头，对吧？一个谜团、一个秘密或一个惊喜。中间部分，你可以详细展开，这就是你传达信息的地方。如果你在做推介（pitch），就把你的产品塞进去。结尾永远应该是成功和庆祝，因为你想让人们对你的故事感到兴奋，或者记住这些信息。脑子里有一个基本的结构，真的会大不相同。

---

### [00:44:29] Lenny

**English:**
Yeah, I love that. That's such a actionable, straightforward tactic for getting better, just ask people, "How could this have been a better story?" Great idea. Your second piece made me think about the Minto Pyramid. Do you know much about, do you work with that at all? The Minto Pyramid principle?

**中文翻译:**
是的，我喜欢这个。这是一个非常具有操作性且直接的进步策略：直接问别人“这个故事怎么能讲得更好？”好主意。你的第二个建议让我想到了“明托金字塔原理（Minto Pyramid）”。你了解这个吗？或者你在工作中使用它吗？

---

### [00:44:45] Christina Wodtke

**English:**
I had a Minto binge for a little while, but I moved onto other stuff. I do.

**中文翻译:**
我曾经痴迷过一段时间明托原理，但后来转向其他东西了。我了解。

---

### [00:44:45] Lenny

**English:**
I think it was a triangle.

**中文翻译:**
我想它是一个三角形。

---

### [00:44:45] Christina Wodtke

**English:**
Yes, but I can't recount it to you. I do remember it.

**中文翻译:**
是的，但我现在没法给你复述。我确实记得它。

---

### [00:44:54] Lenny

**English:**
I was just going to ask because it's kind of the reverse concept, which is, you start with the conclusion and then you kind of share how you got there.

**中文翻译:**
我只是想问，因为它有点像反向的概念，即：你先从结论开始，然后再分享你是如何得出结论的。

---

### [00:45:01] Christina Wodtke

**English:**
I think that's a good one. I mean, if you think about what's the job of a hook, a hook just gets you excited. So, how do you get people excited? You can start with a conclusion. There's going to be success. Oh, tell me more. I want to be successful. It could be a mystery. Ooh, what's happening there? I want to be part of that. It could be a secret. Something happened and I'm not going to tell anybody else, but I'm going to tell you. There's so many ways to hook people in, but they're all doing the same job because you want people to actually listen to you and not pretend and nod. So, I think you can do it backwards as well. But I bet even when Barbara Minto did it, she probably opened with a success and ended with a success, I would bet good money, to remind people that there's a happy ending and the story's worth following.

**中文翻译:**
我认为那是个好方法。如果你思考“钩子”的作用，它就是让你兴奋。那么如何让人兴奋？你可以从结论开始：“这将会成功。”噢，多跟我说说，我也想成功。它也可以是一个谜团：“噢，那里发生了什么？我想参与其中。”也可以是一个秘密：“发生了一件事，我不会告诉别人，但我会告诉你。”有很多方法可以吸引人，但它们的作用是一样的，因为你希望人们真正听你说话，而不是假装点头。所以我觉得反过来讲也可以。但我敢打赌，即使是芭芭拉·明托（Barbara Minto），她可能也是以成功开场并以成功结尾，我敢打赌，这是为了提醒人们故事有一个美好的结局，值得听下去。

---

### [00:45:42] Lenny

**English:**
That's a really interesting perspective because to me, there were opposites of build tension and you reveal the answer. The Minto approach is start with the answer. Here's what we're going to do and here's why, and here's all the work I did to get there. Your point is, that's also really interesting. You're like, "Oh wow. I don't know how you got to that."

**中文翻译:**
这真是一个有趣的视角。因为对我来说，它们是相反的：一个是建立张力然后揭晓答案；明托的方法则是先给答案——“这就是我们要做的，原因如下，这是我为此所做的工作”。你的观点也很有趣，你会觉得：“哇，我不知道你是怎么得出那个结论的。”

---

### [00:45:56] Christina Wodtke

**English:**
There's so many ways to tell a story. Just don't bore your users.

**中文翻译:**
讲故事的方法有很多种。只要别让你的听众感到无聊就行。

---

### [00:46:00] Lenny

**English:**
Great advice. Okay, I want to come back to a couple more OKR questions. It could be less fun than the story maybe, but hopefully more useful. I want to just get your take on what is the cadence of a healthy OKR process? What are the ceremonies and meetings and emails that are involved? I know you have this kind of weekly status email practice. Do you recommend... How do you describe the system of an OKR process?

**中文翻译:**
很棒的建议。好，我想回到几个关于 OKR 的问题。可能没讲故事那么有趣，但希望能更有用。我想听听你对“健康的 OKR 节奏”的看法。涉及哪些仪式、会议和邮件？我知道你有一种“每周状态邮件”的做法。你推荐……你会如何描述 OKR 流程的系统？

---

### [00:46:23] Christina Wodtke

**English:**
Oh my gosh, I'm glad you asked because I think the cadence is probably the single most valuable piece of it. So, every Monday, because Monday is a great temporal landmark, look at your week, and you go, "Okay, what am I going to do to move the ball forward?" And it could be an email to your boss, it could be an email to your accountability group, could be an email out to your team, could be standing there like standup. I mean, it's very easy. OKR rituals were built on agile rituals. So, there's a lot of connections there, which is great.

**中文翻译:**
噢天哪，我很高兴你问这个，因为我认为“节奏”可能是 OKR 中最有价值的部分。每周一，因为周一是一个绝佳的时间地标，审视你的一周，然后想：“好，我要做什么来推进工作？”这可以是一封发给老板的邮件，发给互助小组的邮件，发给团队的邮件，也可以是像站会（standup）一样站在那里说。这非常简单。OKR 的仪式是建立在敏捷（Agile）仪式之上的，所以两者有很多联系，这很棒。

---

### [00:46:52] Christina Wodtke

**English:**
So, you just, Mondays you commit and Fridays you celebrate. People do not value celebrations enough. I've had CEOs who said, "Well, it was the middle of the quarter, so we didn't start OKRs, but we did start Friday celebrations. And oh my God, things are already changing. Things are already getting better." The simple act of getting together and saying, "What was the most awesome thing that happened to you this week? What's the most awesome thing that happened in marketing? What's the most awesome thing that design did this week?" It makes people feel like they're part of something really special and it's super exciting.

**中文翻译:**
所以，你只需要：周一承诺，周五庆祝。人们对庆祝的价值重视不够。我遇到过一些 CEO 说：“虽然是季度中期没法开始 OKR，但我们开始了‘周五庆祝’。天哪，情况已经在变好，事情已经在改善。”这种聚在一起问“这周发生在你身上最棒的事是什么？市场部最棒的事是什么？设计部最棒的事是什么？”的简单行为，会让员工觉得自己是特别事业的一份子，这非常令人振奋。

---

### [00:47:25] Christina Wodtke

**English:**
So, you have these [inaudible 00:47:26] bookends and I think if you only do that, you're probably in good shape. I think status emails, I hated them so profoundly for most of my life. I had this huge team at MySpace and my project manager would gather everybody's status emails and put them together into this giant status email that I had to send to my boss. And I was so busy, I just sent it forward figuring it was fine. And then I read it and there was this really bad thing in my status email that should not have happened.

**中文翻译:**
所以，你有这些“时间节点”，我觉得如果你只做这两件事，情况就会很不错。关于状态邮件，我大半辈子都深恶痛绝。我在 MySpace 时有一个庞大的团队，我的项目经理会收集每个人的状态邮件，汇总成一封巨大的状态邮件发给我，我再发给老板。我当时太忙了，直接转发了，觉得没问题。结果后来我读了一下，发现里面有一件非常糟糕、本不该发生的事。

---

### [00:47:51] Christina Wodtke

**English:**
I was like, "Fuck." And I waited to hear back from my boss, and nothing. Apparently he wasn't reading them either. So, I was like, "What's the point of the stupid thing?" And then when I was at Zynga, we were using OKRs and they were really short. They were like, "What's your confidence level on your key results? What did you do last week? And what are you doing next week?" And the last week, next week is great because it allows you to start noting down what stops you from getting shit done. And that, I got to say, there's so much learning in that. I tried to do this, but what? Did I get sick? Did somebody get mad at me? Did somebody not want to work with me? Do we not have this critical database? The whole, I tried to do this last week and I failed, learning goes through the roof.

**中文翻译:**
我当时想：“操。”我等着老板的回信，结果什么也没等到。显然他也没看。所以我当时想：“这愚蠢的东西有什么意义？”后来我在 Zynga 时，我们使用 OKR，它们非常简短。内容大概是：“你对达成关键结果的信心水平是多少？你上周做了什么？你下周要做什么？”这种“上周/下周”的模式非常棒，因为它让你开始记录是什么阻碍了你完成工作。我得说，这里面有太多的学习机会。我尝试做这个，但是怎么了？我生病了吗？有人生我气了吗？有人不想和我合作吗？我们是不是缺少关键数据库？这种“我上周尝试做这个但失败了”的学习价值极高。

---

### [00:48:38] Christina Wodtke

**English:**
And that rhythm of just having three P1s, you can't have more than three P1s. You can have as many P2s as you want and P3s if you really think you should, but you can scam it... scam it. You can skim it, right? Go through it really quickly. And we would all send them to emails. You could subscribe to email lists, which meant I could read the status emails of most of the company, and I would know what was going on and I could quickly see who should I go over and talk to, and who should I make a connection with? So, those emails were invaluable. I think a lot of my clients are doing it in Slack now instead. And that works really well, if you have this place where you're putting your status in and people will quickly go, skim, skim, skim, skim. "Oh, okay. I got to talk to that guy." So, it's hyper valuable.

**中文翻译:**
那种节奏就是只设定三个 P1（最高优先级），你不能有超过三个 P1。你可以有任意数量的 P2，如果你觉得有必要也可以有 P3，但你可以快速浏览（skim）。我们都会发邮件。你可以订阅邮件列表，这意味着我可以阅读全公司大部分人的状态邮件，了解进展，并快速发现我应该去找谁谈谈，或者应该和谁建立联系。所以那些邮件是无价的。我想现在很多客户改用 Slack 来做了。这也很有效，如果你有一个地方放状态，大家可以快速扫视，“噢，好，我得找那家伙聊聊”。这极具价值。

---

### [00:49:20] Lenny

**English:**
If you assume others, the OKR doc, you're like, "Here's our outcomes for the quarter. Here's our three key results." You make that plan once a quarter. You have any recommendation how long to spend on planning your OKR?

**中文翻译:**
假设 OKR 文档是这样的：“这是我们本季度的结果，这是我们的三个关键结果。”你每季度制定一次计划。关于花多少时间制定 OKR，你有什么建议吗？

---

### [00:49:32] Christina Wodtke

**English:**
My goal is always as little as possible. Time you're planning is not the time you're shipping, and the best is the enemy of the good. So, in an ideal world, you would grade your OKRs week at the end of the quarter, maybe second to the last week of the quarter, depending on it. If it takes you a whole week to set OKRs, which I hope it doesn't, but who knows. And then the very last week you set your OKRs for the next quarter and that's it.

**中文翻译:**
我的目标永远是越少越好。你花在计划上的时间就不是花在交付上的时间，“完美是优秀的敌人”。在理想情况下，你会在季度末给 OKR 打分，也许是倒数第二周，视情况而定。如果设定 OKR 要花整整一周（我希望不要，但谁知道呢），那么在最后一周设定下季度的 OKR，就这样。

---

### [00:49:58] Lenny

**English:**
Cool.

**中文翻译:**
酷。

---

### [00:49:59] Christina Wodtke

**English:**
Boom. If you can do it at in a... usually you can do it in four days total, unless you have a very hierarchal, huge deep bench. And even then, I have something, I'm going to share this with you because I don't think many people talk about this. The approval process will kill you. I've seen it happen over and over again. I was working with one of my clients and we came up with this different kind of approval process that's working really well, is that basically instead of having your boss approve it, you write your OKRs, you get three... I'm a big fan of the rule of three, because I'm a storyteller, but you could do less or more, I guess, teams that work with you enough to know what you're up to, to look them over and they just look them over, 24 hour turnaround.

**中文翻译:**
搞定。通常总共四天就能完成，除非你的公司等级森严、规模庞大。即便如此，我还有个法子，我想和你分享，因为我觉得没多少人谈论这个：审批流程会害死你。我见过无数次这种情况。我曾和一位客户合作，我们想出了一种不同的审批流程，效果非常好：基本上不是让你的老板审批，而是你写好 OKR 后，找三个（我是“三原则”的粉丝，因为我是讲故事的人，当然你也可以多点或少点）对你的工作足够了解的团队来审阅。他们只需看一遍，24 小时内反馈。

---

### [00:50:43] Christina Wodtke

**English:**
They say, "This looks right, but I don't think this is possible." They give you that feedback and you're done. That's it. That's the entire approval process, and it's so fast and it works so well. And that means you might have to say no to somebody if they're asking you to do more than... if you had 10 teams asking you to look over their OKRs, you have to say no. You want to keep it down to a reasonable number, but if you do one a day, it could be done in a week.

**中文翻译:**
他们会说：“这看起来是对的，但我觉得这不可能实现。”他们给你反馈，然后就结束了。这就是全部的审批流程，非常快，效果非常好。这意味着如果有人要求你做更多，你可能得拒绝——如果有 10 个团队让你看他们的 OKR，你必须拒绝。你要把它维持在一个合理的数量，但如果你每天看一个，一周就能搞定。

---

### [00:51:09] Lenny

**English:**
I'm thinking about companies the size of Airbnb when I left, trying to do it that quickly. And it's hard to imagine, partly because there's top level strategy that has to align with individual team roadmaps and dependencies, and platform teams and things like that. So, I imagine it's hard to do as the company's scales. I like the drive to make it a week and be done.

**中文翻译:**
我在想我离开时的 Airbnb 那种规模的公司，尝试这么快完成。这很难想象，部分原因是顶层战略必须与各个团队的路线图、依赖关系、平台团队等保持一致。所以我猜随着公司规模扩大，这很难做到。但我喜欢“一周搞定”这种劲头。

---

### [00:51:29] Christina Wodtke

**English:**
Well, I mean, who really has to approve it and what does it cost you if you get it wrong? And so, if tech looked at it, if somebody from strategy looked at it, if somebody from sales looked at it, whatever, the right people looked at it, you're probably fine. And if you're not right, you'll figure it out over the quarter and do better next quarter. We have to let go or we will get mired down in all this crap.

**中文翻译:**
我是说，到底谁必须审批？如果你搞错了，代价是什么？所以，如果技术部门看了，战略部门的人看了，销售部门的人看了，只要对的人看了，大概就没问题。如果你错了，你会在这个季度中发现，并在下个季度做得更好。我们必须学会放手，否则就会陷入这些琐碎的泥潭中。

---

### [00:51:57] Lenny

**English:**
I love that. I went off track, but just to kind of put a ribbon on the concept of OKRs, you have this document with your object, your outcomes, your key results, and then your recommendation is do a weekly email. And is the idea everyone on the team sends this weekly email or Slacks to the rest of the team?

**中文翻译:**
我喜欢这个。我有点跑题了，但为了给 OKR 这个概念收个尾：你有一份包含目标、结果、关键结果的文档，然后你建议发每周邮件。那么，是团队里的每个人都给团队其他成员发这封每周邮件或 Slack 吗？

---

### [00:52:15] Christina Wodtke

**English:**
To the rest of the company if you can.

**中文翻译:**
如果可以的话，发给全公司。

---

### [00:52:18] Lenny

**English:**
Wow. Okay. [inaudible 00:52:19].

**中文翻译:**
哇，好吧。

---

### [00:52:19] Christina Wodtke

**English:**
That's the thing, is Google, even as a huge company, everybody's OKRs and their weekly updates are on their intranet. You can look stuff up, so why not?

**中文翻译:**
这就是关键，即使是像谷歌这样庞大的公司，每个人的 OKR 和每周更新都在内网上。你可以查到任何东西，所以为什么不呢？

---

### [00:52:28] Lenny

**English:**
Got it. And we'll link to a template that you have on your blog post. And also I think in the book, I imagine you have this template of what it is, but essentially it's your confidence level of hitting your OKR, what you did last week, what you're going to do next week.

**中文翻译:**
明白了。我们会链接到你博客文章里的模板。我想书里也有这个模板，本质上就是：你对达成 OKR 的信心水平、你上周做了什么、你下周打算做什么。

---

### [00:52:40] Christina Wodtke

**English:**
And then a few notes if you need to.

**中文翻译:**
如果需要的话，再加上几条备注。

---

### [00:52:42] Lenny

**English:**
Does this replace stand-ups in your experience?

**中文翻译:**
根据你的经验，这会取代站会吗？

---

### [00:52:45] Christina Wodtke

**English:**
It could. I never try to tell engineering how to get their shit done, but if they felt like it was doing the same job, then they could combine them.

**中文翻译:**
有可能。我从不尝试告诉工程团队该怎么干活，但如果他们觉得这起到了同样的作用，他们可以把两者结合起来。

---

### [00:52:56] Lenny

**English:**
Cool. Okay, great. And is there anything else? Is this the whole OKR process, in your experience?

**中文翻译:**
酷，太好了。还有别的吗？根据你的经验，这就是 OKR 流程的全貌了吗？

---

### [00:53:01] Christina Wodtke

**English:**
The only other thing I would bring up is thinking about the word grading. So, a lot of people think about trying to make something really numerical, like 0.08, I got 80% of the way there, but a lot of times they're qualitative. So, how do you think about that getting approved by the product committee? So, it doesn't matter. It really doesn't matter. Don't get fussy. Don't try to make it really precise. Just go ahead and say, "Ah, hand wave, hand wave, 80%." What matters is, why 80%? Really focus on the learning. So, we almost got there. Well, if we would've gotten there, if we got two more days, that's fine. We basically got there. We knew what we were doing. If we didn't, if we were really far away, what went wrong?

**中文翻译:**
我唯一想提的另一件事是关于“打分（grading）”。很多人想把它变得非常数字化，比如 0.8，我完成了 80%。但很多时候它是定性的。比如，你如何考虑通过产品委员会的审批？其实这不重要，真的不重要。别太挑剔，别试图把它弄得极其精确。直接说：“啊，大概齐，80%。”重要的是：为什么是 80%？真正专注于学习。比如，我们差一点就达成了，如果我们再多两天就能达成，那没关系，我们基本做到了，我们知道自己在做什么。如果我们差得很远，那哪里出错了？

---

### [00:53:44] Christina Wodtke

**English:**
It's all about the retrospectives. Make sure your grading is secondary to retrospective, is the biggest thing I would say, because that's what's going to be valuable. And you could spend so many hours trying to come up with some fake measurement system that never is quite accurate and just wastes everybody's time when you could just be faster. I'm just obsessed with speed. You may have noticed that.

**中文翻译:**
一切都在于“复盘（retrospectives）”。我想说的最重要的一点是，确保打分服从于复盘，因为复盘才是价值所在。你可以花好几个小时去想出一套虚假的衡量系统，但它永远不会完全准确，只会浪费大家的时间，而你本可以更快。我只是对速度很着迷，你可能已经注意到了。

---

### [00:54:03] Lenny

**English:**
I thought it was 70%, is that 80% is success? Is that the rule of thumb for OKRs?

**中文翻译:**
我以为是 70%，难道 80% 才算成功？这是 OKR 的经验法则吗？

---

### [00:54:07] Christina Wodtke

**English:**
It's about 70%. Some people do 80%, some people do 0.075, I don't know. My feeling is, a good goal is one that makes you feel somewhat uncomfortable but not doomed. You're like, "Woo, that's kind of good, that's going to be tricky. Okay, let's go for it." That's about where I like to land with a key result.

**中文翻译:**
大约是 70%。有人定 80%，有人定 0.75，我不知道。我的感觉是，一个好的目标应该是让你感到有些不舒服，但又不至于感到绝望。你会觉得：“喔，这挺有挑战的，会很难办。好，让我们试试。”这就是我希望关键结果达到的状态。

---

### [00:54:29] Lenny

**English:**
I had a newsletter post with Lane Shackleton from Coda, and he made this point that OKRs were created by Google, which is the most incredible business model in history. They just print money, and for them it's okay not to hit their goals, like 70% of goal is fine, it'll be fine, we're making so much money. And so, his perspective for most companies, it doesn't make sense to set the goal to be like 70% of this goal you set is a success. Do you have a perspective on that?

**中文翻译:**
我曾和 Coda 的 Lane Shackleton 合作过一篇通讯文章，他指出 OKR 是由谷歌创造的，而谷歌拥有历史上最不可思议的商业模式。他们简直是在印钱，所以对他们来说，没达成目标也没关系，达成 70% 就行，反正我们赚了这么多钱。所以他的观点是，对于大多数公司来说，把“达成 70% 就算成功”作为目标设定是没有意义的。你对此有什么看法？

---

### [00:54:57] Christina Wodtke

**English:**
I think you'll never know what you're capable of unless you try to do something that you're not sure you can do.

**中文翻译:**
我认为，除非你尝试去做一些你不确定自己能否做到的事情，否则你永远不会知道自己的潜力有多大。

---

### [00:55:01] Lenny

**English:**
I agree. I find setting more ambitious goals than you think you can immediately achieve actually really pushes you to achieve them.

**中文翻译:**
我同意。我发现设定比你认为能立即实现的更具雄心的目标，实际上会真正推动你去实现它们。

---

### [00:55:08] Christina Wodtke

**English:**
And the literature agrees. There's a lot of literature that shows ambitious goals are actually quite motivating unless you feel you're doomed, at which point then they're demotivating.

**中文翻译:**
相关文献也支持这一点。有很多研究表明，雄心勃勃的目标实际上非常有激励作用，除非你觉得注定失败，那时它们才会产生负面激励。

---

### [00:55:16] Lenny

**English:**
I've seen that too. Okay, two more OKR questions. One is, I noted this from before so I'm just going to come back to it. There's a balance with key results of, as you've talked about, being very precise and metrics-driven and focused. And then there's, you talked a bit about sometimes it's okay for them to be a little fuzzy, like quality and delight, and those latter ones are harder to measure, it's hard to keep people accountable. Do you have any advice for just how to find that right balance of, this is what will keep you accountable, and this is how we drive the business forward, and this is how we know you're doing a good job, versus here's a general thing that we think is success and it's fine. Do your best.

**中文翻译:**
我也见过这种情况。好，还有两个关于 OKR 的问题。一个是，我记下了之前的点，现在想绕回来。关键结果之间存在一种平衡：正如你所说，一方面要非常精确、指标驱动且专注；另一方面，你也提到有时它们可以稍微模糊一点，比如质量和愉悦感。而后者更难衡量，也更难让人们承担责任。你对于如何找到这种平衡有什么建议吗？即：这部分是用来问责、推动业务增长、衡量工作表现的；而那部分是我们认为的成功愿景，尽力而为就好。

---

### [00:55:57] Christina Wodtke

**English:**
Yeah. One of the most common arguments I have with my friends is I think everything can be measured to a certain degree. Not precisely necessarily, but you can get enough of a swag to be useful. So, by trying to measure things, you'll start learning how to measure things. So, you maybe try NPS and you're like, "Wow, this is not actually accurate, or weird, or not." There's a lot of stuff we don't know until we try them. And of course, my background is in lean and agile and design and they're all iterative. They're all about, let's try something and then learn something and then do something. Which is why I'm so fanatically iterative. So, I think that when you got these fuzzy things, you just got to start trying out ways to measure it and trust the team to be able to figure out whether it's working or not.

**中文翻译:**
是的。我和朋友们最常争论的一点是：我认为任何事情在某种程度上都是可以衡量的。不一定非要精确，但你可以得到一个足够有用的估算值（swag）。通过尝试衡量，你会开始学习如何衡量。比如你尝试 NPS，然后发现：“哇，这其实不准确，或者很奇怪。”有很多东西不试是不知道的。当然，我的背景是精益（Lean）、敏捷（Agile）和设计，这些都是迭代的。核心都是：尝试一些东西，学习一些东西，然后做一些东西。这就是为什么我如此痴迷于迭代。所以，我认为当你遇到这些模糊的事情时，你只需要开始尝试各种衡量方法，并信任团队能够判断它是否奏效。

---

### [00:56:46] Christina Wodtke

**English:**
Revenue, it's easy. This is what we're making now, this is what we could be making. Or you're not making anything now, so you can look up some numbers from public companies or whatnot. That's easy. DAU, it's easy. Acquisition numbers, it's easy. But when it comes to will people stay, do people actually like this? That's harder, but it's not impossible. There's a lot of user researchers who have worked hard to figure out how to measure it.

**中文翻译:**
收入很容易衡量：这是我们现在的收入，这是我们可能的收入。或者你现在还没收入，你可以查查上市公司的数字。这很简单。日活（DAU）很容易，获客数字也很容易。但当涉及到“人们会留下来吗？”“人们真的喜欢这个吗？”时，就比较难了，但并非不可能。有很多用户研究员一直在努力研究如何衡量这些。

---

### [00:57:15] Christina Wodtke

**English:**
So, you can either buy the obvious off-the-rack package like an NPS, or you can dig a little harder and figure out what would be meaningful to your company. And I think there's a desire not to do things that are hard and take a little bit longer, but that's where you're going to get the super value. That's how you become the next Netflix or Amazon or whatnot. So, you really got to say, "How will we know about our product and what are the approaches are out there and which one makes sense for us?"

**中文翻译:**
所以，你既可以购买像 NPS 这样显而易见的现成方案，也可以深入挖掘，找出对你公司有意义的指标。我认为人们往往不想做那些困难且耗时较长的事情，但那才是产生巨大价值的地方。那是你成为下一个 Netflix 或亚马逊的方式。所以你真的得问：“我们如何了解我们的产品？市面上有什么方法？哪种适合我们？”

---

### [00:57:47] Lenny

**English:**
Final OKR-related question. Say someone's listening to this and they're like, "Wow, this is awesome. I want to do this at our company, we have a focus problem, we have alignment problems, we need to be more clear about what we're working on." Other than buying your book and reading it and sharing with everyone, what would you recommend would be the first few steps to work along that journey to rolling out an OKR process at the company?

**中文翻译:**
最后一个关于 OKR 的问题。假设有人听了这期节目，觉得：“哇，太棒了，我想在公司推行这个。我们有专注力问题，有一致性问题，我们需要更清楚自己在做什么。”除了买你的书读并分享给所有人之外，你建议在公司推行 OKR 流程的第一步应该是什么？

---

### [00:58:09] Christina Wodtke

**English:**
I hate to say this, but there are a lot of consultants that have popped out of nowhere and it's kind of terrifying because so many of them really, really suck and they're just like, "Oh, OKR sounds like SMART goals or whatever, I'll just use that." Or it's hot, and so I'm going to figure it out by reading some articles. And so, I would ask for references. I think that's a good one.

**中文翻译:**
我不想这么说，但现在冒出了很多顾问，这挺可怕的，因为其中很多人真的很烂。他们觉得：“噢，OKR 听起来就像 SMART 目标之类的，我就用那个吧。”或者觉得这个话题很火，就读几篇文章现学现卖。所以，我会建议查看他们的过往案例（references）。我觉得这是一个好方法。

---

### [00:58:33] Lenny

**English:**
So, your advice is find someone to come in and help you figure out how to do this well and find the right person.

**中文翻译:**
所以你的建议是找人来帮忙，弄清楚如何做好，并找到对的人。

---

### [00:58:40] Christina Wodtke

**English:**
Yeah, I guess I think that finding someone to coach you is really high value, but I also think it would be okay if you just read a book or read a bunch of blog posts and start experimenting. It's not rocket science. You just listened to this podcast, listen to it again. Take lots of notes, Google around, see if you can learn a little more about some of the concepts that you didn't fully understand or you want to know more about. And then just run a tiny pilot and say, "Okay, what does this mean for us?" You don't even have to call them OKRs. You can just try, "We're going to do a outcome focus this quarter and let's see where it takes us." But just try it because that's where you learn stuff. And try it at a small, safe level where you don't think it's going to hurt too many things.

**中文翻译:**
是的，我认为找人指导非常有价值。但我也觉得，如果你只是读一本书或一堆博客文章并开始实验，也没问题。这又不是造火箭。你刚听了这期播客，可以再听一遍。多做笔记，去谷歌搜搜，看看能不能进一步了解那些你不完全理解或想深入了解的概念。然后进行一个小规模试点，问问：“这对我们意味着什么？”你甚至不需要称之为 OKR。你可以尝试：“这个季度我们要关注‘结果’，看看会发生什么。”只要去尝试就行，因为那是你学习的地方。在一个小规模、安全的层面上尝试，这样就不会造成太大的破坏。

---

### [00:59:25] Lenny

**English:**
And you said to start with a high performing team.

**中文翻译:**
你还说过要从一个高绩效团队开始。

---

### [00:59:27] Christina Wodtke

**English:**
Oh, yes.

**中文翻译:**
噢，是的。

---

### [00:59:28] Lenny

**English:**
[inaudible 00:59:28] point.

**中文翻译:**
这一点很重要。

---

### [00:59:28] Christina Wodtke

**English:**
Because they're smart, they're capable, and if anybody's going to figure out how to make it work, they will. If you try to fix a bad team with OKRs, you'll make everybody hate OKRs and make the bad team worse. So, just don't do that. It's not a medicine, but that high preferring team, they're going to be the ones who go, "Oh, well, okay, our stand-up's like this, so we should add this to standup. And then instead of emails, let's just have a brag channel on our..." I've seen people do the coolest stuff with OKRs, totally changing what I recommend, doing wonderful things with it, just because they're smart and they messed with it till it worked.

**中文翻译:**
因为他们聪明、有能力。如果有人能弄清楚如何让它奏效，那一定是他们。如果你试图用 OKR 来修复一个糟糕的团队，你会让每个人都讨厌 OKR，并让那个糟糕的团队变得更糟。所以，千万别那么做。它不是药。但那个高绩效团队，他们会说：“噢，好吧，我们的站会是这样的，所以我们应该把这个加入站会。然后不用邮件，我们在 Slack 上开个‘夸夸频道’……”我见过人们用 OKR 做出最酷的事情，完全改变了我的建议，做出了奇妙的成果，仅仅是因为他们聪明，并且不断折腾直到它奏效。

---

### [01:00:03] Lenny

**English:**
Awesome. Final question in topic. You teach product management at Stanford. What's maybe a surprising or contrarian opinion about how to learn to do product management, how to get into product management, how to do product management, from your experience teaching young PMs?

**中文翻译:**
太棒了。最后一个话题。你在斯坦福教授产品管理。根据你教年轻产品经理（PM）的经验，关于如何学习产品管理、如何入行、如何做产品管理，你有什么令人惊讶或逆向的观点吗？

---

### [01:00:22] Christina Wodtke

**English:**
I taught it and a bunch of students who thought they were going to be product managers realized that they wanted to be interaction designers and not product managers at all. I think one of the things that might be off with a lot of the product management education and conferences is, it's good that they take a lot from UX and it is important to be people-centered, but the reality is the product manager serves the business. That's their role. Teresa Torres talks about the product trio, right? Trio.

**中文翻译:**
我教过这门课，结果一堆原本想当产品经理的学生意识到，他们其实想当交互设计师，根本不想当产品经理。我认为现在的很多产品管理教育和会议可能跑偏的一点是：借鉴用户体验（UX）是好事，以人为本也很重要，但现实是，产品经理是为“业务”服务的。这就是他们的角色。Teresa Torres 谈到过“产品三人组（product trio）”，对吧？三人组。

---

### [01:00:52] Lenny

**English:**
Trio.

**中文翻译:**
三人组。

---

### [01:00:53] Christina Wodtke

**English:**
Trio. She's talking about business and user experience and technology. So, if product's over here messing with the user experience or products over there, messing with engineering, who's taking care of the business? And I think it's absolutely critical product managers, they say they're the mini CEO, but that just means they want to be in charge and nobody's in charge. It's all about working together as a team. So, they need to understand business models, they need to understand how to do a target market, and what is a target market, why is that target market the right one to go after, and how is it going to grow, and what are the trends that are going on that's going to change the business?

**中文翻译:**
三人组。她谈论的是业务、用户体验和技术。所以，如果产品经理在这边纠结用户体验，或者在那边纠结工程实现，谁来管业务？我认为绝对关键的一点是，产品经理常说自己是“小 CEO”，但这往往意味着他们想掌权，而实际上没人能完全掌权，一切在于团队协作。所以，他们需要理解商业模式，需要理解如何确定目标市场，什么是目标市场，为什么那个目标市场是正确的选择，它将如何增长，以及有哪些趋势会改变业务？

---

### [01:01:29] Christina Wodtke

**English:**
Product managers need to serve the business and it's not a bad thing. If you have a company, it needs to survive and all money is, is oxygen, it lets the company keep going, unless people are being greedy assholes, which definitely happens. But it's okay to care about the health and well-being of the company's ability to make money and feed itself. And don't do anything unethical, but really focus on these questions. And if you don't know business models, if you can't talk about why you might want to do a subscription or if you want to just do one-off sales, if you don't understand why you know have all these in-app purchases in your mobile devices, go learn it. I'm really shocked at how many product managers are just smart people who care about users and just showed up and said, "Yes, I will be a product manager." So, no, business is a real thing. It has a long history of knowledge and understanding, and go do that.

**中文翻译:**
产品经理需要为业务服务，这并不是坏事。如果你有一家公司，它需要生存，而钱就是氧气，它让公司继续运转（除非人们是贪婪的混蛋，这种情况确实存在）。关心公司赚钱和自给自足的能力是完全正当的。在不做任何违背伦理的事情的前提下，真正关注这些问题。如果你不懂商业模式，如果你说不清楚为什么要搞订阅制还是单次销售，如果你不理解移动设备里为什么有这么多应用内购买，那就去学。我很惊讶竟然有这么多产品经理只是聪明、关心用户，然后就跑来说：“是的，我要当产品经理。”不，商业是一门真正的学问，有着悠久的知识和理解积累，去学习它。

---

### [01:02:30] Lenny

**English:**
What I'm hearing is, maybe product sense is overrated in your experience.

**中文翻译:**
我听到的是，根据你的经验，也许“产品感（product sense）”被高估了。

---

### [01:02:34] Christina Wodtke

**English:**
Ain't none of them yet old enough to have product sense. I mean, seriously. Product sense is intuition, intuition is compressed experience, compressed experience comes from having lots of experience. And if you're young and you don't have a lot of experience, the smartest thing you could do is learn. You've got to learn what models work and why they work, and just intuition is overvalued and under-exists.

**中文翻译:**
他们中还没人年纪大到能拥有真正的“产品感”。我是认真的。产品感是直觉，直觉是压缩的经验，而压缩的经验来自于大量的实践。如果你还年轻，没有太多经验，你能做的最聪明的事就是学习。你必须学习哪些模型有效，为什么有效。直觉被高估了，而且它其实并不普遍存在。

---

### [01:03:01] Lenny

**English:**
Imagine that's kind of freeing to a lot of people listening, where they're like, "Man, I just don't know if I have product sense. How do I learn product?" All this. Yeah, don't worry about it is what you're saying. Any other advice for just people thinking about getting into product or trying to get into product other... Many can't get to Stanford and learn product from someone like you. What else would you suggest they do to try to help them get into a product management role? What other activities or areas they should spend time, in your experience?

**中文翻译:**
我想这对很多听众来说是一种解脱，他们可能会想：“天哪，我不知道自己有没有产品感，我该怎么学产品？”等等。你是在说，别担心这个。对于那些想入行或正尝试入行的人，你还有什么建议吗？很多人没法去斯坦福听你讲课。根据你的经验，你还会建议他们做哪些活动或在哪些领域花时间，以帮助他们获得产品管理职位？

---

### [01:03:30] Christina Wodtke

**English:**
I think I agree with my friend Ken Norton on this, in that you shouldn't probably start in product. Go be an engineer or be a designer, work, get to know businesses. And I got into product from, well, I was a developer and then I was a designer, and both of those gave me a lot of knowledge. But when I moved into product, it came out of my startup where I had to learn business, and I absolutely had to learn business or else I wasn't surviving. So, I would say work for a company that's small enough that you can poke into the corners and learn from other people, and learn and then do stuff.

**中文翻译:**
在这个问题上，我同意我朋友 Ken Norton 的观点：你可能不应该从产品岗位开始。先去当工程师或设计师，去工作，去了解业务。我进入产品领域之前，先做了开发人员，然后做了设计师，这两者都给了我很多知识。当我转向产品时，是因为我创办了自己的公司，我必须学习商业，否则我就活不下去。所以，我会建议去一家足够小的公司工作，这样你可以接触到各个角落，向别人学习，边学边做。

---

### [01:04:11] Christina Wodtke

**English:**
I don't know, it's funny because I'm at Stanford, which is all fancy with a degree and stuff and I'm like, "No, no, no, just read up, go hang out with people, get a job, figure it out." Because that's very much how I did it. And I think that if people want to get into product, I'd ask, "Why? Why do you want to be in product? Do you want to be in charge?" I learned that nobody's in charge. No matter what you do, you have to use your influence, you have to use your people skills.

**中文翻译:**
这很有趣，因为我在斯坦福，那里到处是光鲜的学位之类的，但我却说：“不不不，多读书，多和人交流，找份工作，自己摸索。”因为我就是这么过来的。如果有人想进产品领域，我会问：“为什么？你为什么想做产品？你想掌权吗？”我学到的是，没人能真正掌权。无论你做什么，你都必须运用你的影响力，运用你的人际交往技巧。

---

### [01:04:34] Christina Wodtke

**English:**
Are you willing to work on your interpersonal dynamics? Because if you can't fire someone, if you can't tell somebody their behavior is interfering with the ability to get things done, don't be a product manager. If you can't solve the fight between two of your coworkers, don't be a product manager. If you can't go out and talk to somebody in a Starbucks line and say, "Hey, we're working on this new thing, what do you think?" Don't be a product manager. You got to have hustle. You got to talk to people. You got to always have your eye on the bottom line.

**中文翻译:**
你愿意处理复杂的人际动态吗？如果你不敢开除某人，如果你不敢告诉某人他的行为干扰了工作进度，那就别当产品经理。如果你不能解决两个同事之间的争吵，别当产品经理。如果你不敢在星巴克排队时跟人搭讪说：“嘿，我们正在做一个新东西，你觉得怎么样？”，别当产品经理。你必须有拼劲（hustle），必须与人交流，必须时刻盯着盈亏底线（bottom line）。

---

### [01:05:00] Christina Wodtke

**English:**
Maybe you don't want to be a product manager. Maybe it's much more fun to leave work every day at 6:00 and be a designer and think about how all the systems work and how and where the error message is going to come in, and is blue the right color, all the combinations of that, that's fun. Or you really want to be an engineer and solve puzzles all day. Product manager is probably the worst job unless you love talking to everybody and connecting them and stepping into the mess.

**中文翻译:**
也许你并不想当产品经理。也许每天 6 点下班，当个设计师，思考系统如何运作、错误信息该在哪出现、蓝色是否合适，这些组合更有趣。或者你真的想当个工程师，整天解决难题。除非你热爱与所有人交谈、连接他们并踏入混乱之中，否则产品经理可能是最糟糕的工作。

---

### [01:05:24] Lenny

**English:**
I definitely agree. There's not enough talk about how painful and hard the PM role is and how thankless it often is.

**中文翻译:**
我绝对同意。关于产品经理这个角色有多痛苦、多艰难、多费力不讨好，目前的讨论还不够多。

---

### [01:05:29] Christina Wodtke

**English:**
And I love it, but I love everything. I fell in love with the web and I haven't stopped, even though it's now mostly on phones and stuff. It's an exciting space. But yeah, you got to step up and do the hard stuff.

**中文翻译:**
但我爱这份工作，我热爱一切。我爱上了互联网，至今未减，尽管现在它主要是在手机上。这是一个令人兴奋的领域。但是，是的，你必须挺身而出，去做那些困难的事情。

---

### [01:05:42] Lenny

**English:**
That is an awesome way to end it. And with that, we've reached our very exciting lightning round where I just have six quick questions. I don't know if you know they are, so let's just go through them and see how it goes. Are you ready?

**中文翻译:**
这是一个完美的结尾。接下来进入我们非常刺激的闪电轮环节，我有六个简短的问题。我不知道你是否知道这些问题，让我们直接开始吧。准备好了吗？

---

### [01:05:53] Christina Wodtke

**English:**
I love it.

**中文翻译:**
我准备好了。

---

### [01:05:54] Lenny

**English:**
What are two or three books that you recommend most to other people?

**中文翻译:**
你最推荐给别人的两三本书是什么？

---

### [01:05:59] Christina Wodtke

**English:**
The Fearless Organization. I think that book on psychological safety is the bomb. It's so, so, so good. For fiction, I loved The Overstory. It's about trees, and it's mind-blowing and so good. I'm going to leave it at that. Less is better.

**中文翻译:**
《无畏的组织》（The Fearless Organization）。我认为那本关于心理安全感的书简直太棒了，非常非常出色。小说方面，我喜欢《树冠之歌》（The Overstory）。它是关于树木的，非常震撼，写得极好。就这两本吧，少即是多。

---

### [01:06:17] Lenny

**English:**
I tried reading The Overstory and it's very long, but beautiful.

**中文翻译:**
我试过读《树冠之歌》，它非常长，但很美。

---

### [01:06:20] Christina Wodtke

**English:**
It's a lot like Cloud Atlas. If you liked Cloud Atlas, you'll like The Overstory.

**中文翻译:**
它很像《云图》（Cloud Atlas）。如果你喜欢《云图》，你就会喜欢《树冠之歌》。

---

### [01:06:24] Lenny

**English:**
I think I watched that movie.

**中文翻译:**
我想我看过那部电影。

---

### [01:06:25] Christina Wodtke

**English:**
No, a terrible movie. Only read the book.

**中文翻译:**
不，那电影拍得很烂。一定要读原著。

---

### [01:06:28] Lenny

**English:**
I agree. Speaking of movies, what's a favorite recent movie or TV show?

**中文翻译:**
我同意。说到电影，最近最喜欢的电影或电视节目是什么？

---

### [01:06:33] Christina Wodtke

**English:**
We just saw Wakanda Forever and it's a very different movie than Black Panther, and my kid and I spent quite a bit of time talking about it and what it meant and it was a lot deeper than I expected. And I'm very passionate about the Mayan people because I live in Belize part of the year, and I don't know, the Mayans are just the OGs of everything, invented zero, writing. They're just so amazing.

**中文翻译:**
我们刚看了《黑豹2：瓦坎达万岁》（Wakanda Forever），它和第一部很不一样。我和孩子花了不少时间讨论它及其背后的含义，它比我预想的要深刻得多。我对玛雅文化非常痴迷，因为我一年中有一部分时间住在伯利兹。玛雅人简直是万物的鼻祖（OGs），发明了零，发明了文字。他们太神奇了。

---

### [01:06:56] Lenny

**English:**
Love it. Next question, favorite interview question that you like to ask when you're interviewing people.

**中文翻译:**
太棒了。下一个问题，你在面试别人时最喜欢问的问题是什么？

---

### [01:07:01] Christina Wodtke

**English:**
What questions should I have asked you? I've been using that one forever, whether I am interviewing somebody or being interviewed, because the person is an expert in themselves. And if you say, "What question should I have asked you?" A lot of times they'll be like, "Oof." They'll be knocked off-base and then they'll give you a really honest answer.

**中文翻译:**
“我本该问你什么问题？”我一直用这个问题，无论是我面试别人还是被面试。因为每个人都是研究自己的专家。如果你问：“我本该问你什么问题？”，很多时候他们会愣一下，然后会给你一个非常诚实的回答。

---

### [01:07:20] Lenny

**English:**
What are five SaaS products or tools that you just love and use constantly?

**中文翻译:**
你非常喜爱并经常使用的五个 SaaS 产品或工具是什么？

---

### [01:07:24] Christina Wodtke

**English:**
Oh, I hate all technology. That's what the problem is, if you've been a product manager and a designer, all you can see is the flaws. But I would say I like Zoom better than you might think. It's terrible, but it's better than everything else. Slack, when I saw it, I was like, "This is not going to get rid of email. This is just going to be another channel of nonsense." And that showed up. But I do use it. God knows, I use it.

**中文翻译:**
噢，我讨厌所有的技术产品。这就是问题所在，如果你当过产品经理和设计师，你看到的就全是缺陷。但我得说，我比你想象中更喜欢 Zoom。它虽然糟糕，但比其他所有同类产品都好。至于 Slack，我第一次看到它时想：“这不会取代邮件，这只会变成另一个充满废话的渠道。”事实也确实如此。但我确实在用它，天知道我用得有多频繁。

---

### [01:07:48] Christina Wodtke

**English:**
The Google Suites, I got to say the Google Suite is pretty amazing. Most people think that the students who go to Stanford are all rich, but 70% of them have huge amounts of financial aid. And so, I'm always looking for things that are free and won't cost too much for these students. So many of them are first generation, the first student who's gone in their family here. So, having the Google Suite and being able to have free slides, free docs, everything interconnected, Drive is sort of a gift. So, I've got to say I love those.

**中文翻译:**
还有 Google Workspace（原 Google Suite），我得说它非常了不起。大多数人认为斯坦福的学生都很富有，但其实 70% 的学生都有大量的助学金。所以我一直在寻找免费且不会给学生增加负担的东西。他们中很多人是家族里的第一代大学生。所以，拥有 Google Workspace，能免费使用幻灯片、文档，且一切互联，Google Drive 简直是一份礼物。所以我得说我爱这些。

---

### [01:08:20] Lenny

**English:**
Cool. I didn't expect the question to go in that direction, but I love it. Two more questions. What's something relatively minor that you've seen a company you've worked with change in their product development process that's had a tremendous impact on their ability to execute and ship crates?

**中文翻译:**
酷。我没预料到回答会往这个方向走，但我很喜欢。还有两个问题。你有没有见过哪家公司在产品开发流程中做了一个相对较小的改变，却对他们的执行力和交付能力产生了巨大的影响？

---

### [01:08:35] Christina Wodtke

**English:**
I will never forget when people stopped sitting with their disciplines and started sitting with their teams. I think that we in tech want everything to be tech and be remote and everything, blah, blah, blah. And there are definitely jobs that are wonderful remote, but if you're trying to innovate, there's nothing like getting the product trio to sit together, and preferably with walls. Walls are really underrated. If you can just give them a war room where they can put stuff on the wall, or I hate to say it, cubicles, I'd rather see offices, but if you can give people walls, it becomes part of your memory. And then you're not using your short-term memory to remember stuff. You're using it to think, and so the war room becomes a living memory so you can make connections. I mean, it's one of the hardest things I have to teach my students too, is that some things are just better done analog and that's okay.

**中文翻译:**
我永远不会忘记，当人们不再按职能部门坐在一起，而是按项目团队坐在一起时发生的改变。我认为科技界的人希望一切都技术化、远程化等等。确实有些工作非常适合远程，但如果你想创新，没有什么比让“产品三人组”坐在一起更好的了，最好还有墙。墙的作用被严重低估了。如果你能给他们一个“作战室（war room）”，让他们把东西贴在墙上。我不喜欢隔间，我更希望看到办公室，但如果你能给人们墙壁，那些内容就会变成你记忆的一部分。这样你就不用动用短期记忆去记东西，而是用它来思考。作战室变成了活的记忆，让你能建立联系。这也是我教学生时最难的一点：有些事情用模拟（非数字）的方式做效果更好，这没关系。

---

### [01:09:27] Lenny

**English:**
Reminds me of a story I just heard from a friend where there was a team sitting next to a data science team and they were one table apart. They're right next to each other. And the data team just had a lot of concerns with what that team was building. They didn't believe in what they're doing and they're just like, "Why are we wasting these resources on this thing?" And the head of data science put one of the data people on the team and had them sit just one table over with the team and everything changed. They're just like, "Okay, let's do this. This is great. We're going to build some awesome products."

**中文翻译:**
这让我想起我刚从朋友那听到的一个故事：有一个团队坐在数据科学团队旁边，只隔一张桌子。数据团队对那个团队正在构建的东西有很多疑虑，他们不相信那个项目，觉得“为什么要在这个东西上浪费资源？”后来数据科学负责人把一名数据人员派到那个团队里，让他挪了一张桌子坐过去，结果一切都变了。他们变得非常有干劲：“好，干吧，这太棒了，我们要做出很牛的产品。”

---

### [01:09:55] Christina Wodtke

**English:**
We're human.

**中文翻译:**
因为我们是人类。

---

### [01:09:56] Lenny

**English:**
Just that one move.

**中文翻译:**
就那一个小小的举动。

---

### [01:09:58] Christina Wodtke

**English:**
We are human. We are social. Yeah, and I think moving people around every year or so, everybody hates it. Nobody wants to change desks, but do it to them anyway. It always makes things better.

**中文翻译:**
我们是人类，我们是社交动物。是的，我认为大约每年调整一下座位，虽然大家都讨厌，没人想换桌子，但还是要做。这总能让事情变得更好。

---

### [01:10:07] Lenny

**English:**
Final question. What's a company that you think has a really strong and effective product culture? If you can name one, if not, that's okay too.

**中文翻译:**
最后一个问题。你认为哪家公司拥有非常强大且有效的产品文化？如果你能说出一个名字的话，不能也没关系。

---

### [01:10:14] Christina Wodtke

**English:**
Well, I think of all my clients, the best cultures all seem to be very small companies working in strange little corners of the world. They're not the big, sexy guys. Everybody's there because they want to make dog food or they want to make this kind of financial software, and they're amazing. I think we treat scale like it's a virtue when it's merely a tactic, and it might be a bad tactic as well. So yeah, I think there's something really sweet around 250 people working on something that everybody agrees is important.

**中文翻译:**
在我的所有客户中，最好的文化似乎都存在于那些在世界偏僻角落工作的小公司里。他们不是那些光鲜亮丽的大厂。每个人都在那里是因为他们想做狗粮，或者想做某种财务软件，他们非常了不起。我认为我们把“规模”当成了一种美德，而它其实仅仅是一种策略，甚至可能是一种糟糕的策略。所以，我觉得大约 250 人一起为一个大家都认为重要的事情而努力，那种感觉非常棒。

---

### [01:10:49] Lenny

**English:**
Christina, I honor you as emperor for life of OKRs.

**中文翻译:**
Christina，我正式加冕你为 OKR 的终身皇帝。

---

### [01:10:54] Christina Wodtke

**English:**
Woo.

**中文翻译:**
喔！

---

### [01:10:54] Lenny

**English:**
You've achieved it. I'm very proud of you. I think we've made a big dent in how people perceive OKRs and will utilize OKRs.

**中文翻译:**
你实至名归。我为你感到骄傲。我想我们已经很大程度上改变了人们对 OKR 的看法以及使用 OKR 的方式。

---

### [01:10:54] Christina Wodtke

**English:**
I hope so.

**中文翻译:**
希望如此。

---

### [01:11:03] Lenny

**English:**
Thank you so much for being here. Two final questions. Where can folks find you online if they want to learn more, reach out? And how can listeners be useful to you?

**中文翻译:**
非常感谢你能来。最后两个问题：如果大家想了解更多或联系你，可以在哪里找到你？以及，听众们能为你做些什么？

---

### [01:11:10] Christina Wodtke

**English:**
If they want to learn more, I've been blogging at eleganthack.com, like a hack writer since 2000. It's where I've dumped my thoughts for a long time, so it's always a good place if you want to go spelunking about anything. If you want to attempt to hire me, cwodtke.com is not a bad place to go. I say attempt because I teach, and so I don't have a lot of time. But you know what users could do? Users could slow down. I just wish everybody would take a deep breath and think about, "Okay, we're going to adopt this thing. Let's read up on it. Let's think about it. Oh, we're going to build this new product? Let's do a literature review, let's do a competitive analysis. Let's see what's been done. Let's learn from the past."

**中文翻译:**
如果想了解更多，我从 2000 年起就在 eleganthack.com 写博客。长期以来我都在那里倾倒我的想法，所以如果你想深入探索任何话题，那里是个好地方。如果你想尝试雇佣我，可以去 cwodtke.com。我说“尝试”是因为我在教书，时间不多。但你知道听众能做什么吗？听众可以“慢下来”。我希望每个人都能深呼吸并思考：“好，我们要采用这个东西，让我们先读读相关资料，思考一下。噢，我们要开发这个新产品？让我们先做个文献综述，做个竞品分析，看看前人都做了什么，从过去中学习。”

---

### [01:11:55] Christina Wodtke

**English:**
I think if you could slow down, you'll end up going a lot faster. So, I would encourage people, if you're in a panic and you're in a tizzy, and I know the economics bad and the world's on fire, but just take some deep breaths before you do anything and just ask yourself, "What's a good way to do it? What's a good way for me to move forward?" I think I would like to encourage that.

**中文翻译:**
我认为如果你能慢下来，最终你会走得更快。所以我想鼓励大家，如果你感到恐慌或焦虑（我知道经济形势不好，世界也乱糟糟的），但在做任何事之前，先深呼吸，问问自己：“什么是好的做法？我该如何更好地前进？”这就是我想鼓励大家的。

---

### [01:12:16] Lenny

**English:**
A beautiful way to end it, but I also want to make sure you plug your books. Just say the titles of your books and where people can find them, and then we'll [inaudible 01:12:24].

**中文翻译:**
非常完美的结尾。但我还想确保你宣传一下你的书。请说出书名以及大家可以在哪里找到它们。

---

### [01:12:23] Christina Wodtke

**English:**
Radical Focus. Get the second edition. The Team That Managed Itself. And Pencil Me In. Those are my three books that are out there right now. You can get them pretty much anywhere I do believe, but definitely, I mean Amazon. Amazon rules us all, so they're definitely there.

**中文翻译:**
《极致专注》（Radical Focus），记得买第二版；《自我管理的团队》（The Team That Managed Itself）；还有《画出你的创意》（Pencil Me In）。这就是我目前出版的三本书。我想在任何地方都能买到，当然，亚马逊统治着我们所有人，所以那里肯定有。

---

### [01:12:40] Lenny

**English:**
Amazing. Christina, again, thank you for being here. We'll all go slow down right now.

**中文翻译:**
太棒了。Christina，再次感谢你的到来。我们现在就去“慢下来”。

---

### [01:12:44] Christina Wodtke

**English:**
Thank you so much for having me here, Lenny, and sharing your audience with me. It's been an honor.

**中文翻译:**
非常感谢你邀请我，Lenny，让我能与你的听众交流。这是我的荣幸。

---

### [01:12:47] Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。