# Christopher Lochhead - 双语对照

# Lenny's Podcast: Christopher Lochhead - Category Design
## 莱尼对话克里斯托弗·洛克海德：品类设计之道

---

### (00:00:00) Christopher Lochhead

**English:**
The point being, now is the greatest time in history to be a creator, to be an entrepreneur, to be a marketer. I've been a marketer for my entire adult life. It's never been greater than it is right now. And so here's the big thing that I would share. If you are somebody for whom you want to make an exponential difference, you want to innovate, you want to create new value where there wasn't, you want to have a legendary career where you could look back on your career and go, you know what? I was part of this and that, and I was on this team, now's the greatest time in history. And what I would say to you is, the future needs you.

**中文翻译:**
我想说的是，现在是历史上成为创作者、创业者和营销人员最好的时代。我成年后的整个职业生涯都在做营销，现在的环境比以往任何时候都要好。所以我想分享的核心观点是：如果你想创造指数级的差异，如果你想创新，想在虚无中创造新价值，想拥有一个传奇的职业生涯，让你在回首往事时能说：“你知道吗？我参与了那个项目，我是那个团队的一员”，那么现在就是历史上最好的时机。我想对你说的是：未来需要你。

---

### (00:00:35) Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products.
(00:00:43):
Today my guest is Christopher Lochhead. Christopher is a 13-time number one bestselling co-author, including books like Play Bigger and Niche Down. He's also a popular podcaster, co-creator of the excellent Substack Category Pirates, and is best known as the Godfather of Category Design. He's also an advisor to over 50 venture-backed startups, and a former three-time public company CMO.
(00:01:07):
In our conversation, we dig deep into all things category design, including what exactly is category design? Why, in order to build a legendary business, it's so essential to build your own category versus trying to become the best in an existing category. Also, how to actually go about creating your own category. A ton of examples of companies that did this well and didn't do this well, what we could learn from them. Plus a ton of practical frameworks, including something Chris calls The "Better" Trap. Also, why he thinks product market fit is a very dangerous idea. Chris is such a character and I had such a blast speaking with Chris. With that, I bring you Christopher Lochhead after a short word from our sponsors.

**中文翻译:**
欢迎来到莱尼的播客（Lenny's Podcast）。在这里，我会采访世界级的跨国产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中积累的宝贵经验。
(00:00:43):
今天的嘉宾是克里斯托弗·洛克海德（Christopher Lochhead）。克里斯托弗是 13 本榜单第一畅销书的合著者，其中包括《玩大点》（Play Bigger）和《垂直深耕》（Niche Down）。他也是一位广受欢迎的播客主持人，优秀的 Substack 专栏《品类海盗》（Category Pirates）的联合创始人，并以“品类设计教父”的称号闻名。他还是 50 多家风投支持的初创公司的顾问，并曾三次担任上市公司的首席营销官（CMO）。
(00:01:07):
在我们的对话中，我们将深入探讨品类设计的所有细节，包括：究竟什么是品类设计？为什么为了建立一家传奇企业，建立自己的品类（而非试图在现有品类中做到最好）是如此重要？此外，如何实际去创建一个属于自己的品类？我们会讨论大量做得好与不好的公司案例，以及我们可以从中学习什么。此外，还有许多实用的框架，包括克里斯称之为“更好陷阱”（The Better Trap）的理论。还有，为什么他认为“产品市场匹配”（Product Market Fit）是一个非常危险的想法。克里斯是一个非常有性格的人，和他聊天非常愉快。在听完赞助商的简短介绍后，让我们开始与克里斯托弗·洛克海德的对话。

---

### (00:01:48) Advertisement (Mixpanel & Vanta)

**English:**
This episode is brought to you by Mixpanel. Get deep insights into what your users are doing at every stage of the funnel, at a fair price that scales as you grow. Mixpanel gives you quick answers about your users from awareness, to acquisition, through retention. And by capturing website activity, ad data, and multi-touch attribution, right in Mixpanel, you can improve every aspect of the full user funnel. Powered by first-party behavioral data instead of third-party cookies, Mixpanel's built to be more powerful and easier to use than Google Analytics. Explore plans for teams of every size and see what Mixpanel can do for you at mixpanel.com/friends/lenny. And while you're at it, they're also hiring. So check it out at mixpanel.com/friends/lenny.
(00:02:36):
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Cora, and Modern Treasury, trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs and get ready for audits in weeks, not months. By offering the most in-demand security and privacy frameworks, such as SOC2, ISO 27001, GDPR, HIPAA, and many more. Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC2 and these other frameworks. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny. That's vanta.com/lenny to learn more and to claim your discounts. Get started today.

**中文翻译:**
本期节目由 Mixpanel 赞助。以公平且随增长扩展的价格，深入洞察用户在漏斗每个阶段的行为。Mixpanel 为您提供从认知、获取到留存的用户快速解答。通过在 Mixpanel 中直接捕获网站活动、广告数据和多触点归因，您可以优化完整用户漏斗的各个方面。Mixpanel 由第一方行为数据驱动，而非第三方 Cookie，其设计比 Google Analytics 更强大且更易用。请访问 mixpanel.com/friends/lenny 探索适合各种规模团队的方案。顺便提一下，他们也在招聘，请查看该网址。
(00:02:36):
本期节目由 Vanta 赞助，帮助您简化安全合规流程以加速增长。数千家快速增长的公司（如 Gusto、Cora 和 Modern Treasury）信任 Vanta，帮助他们构建、扩展、管理和展示其安全合规计划，并在数周而非数月内完成审计准备。通过提供最热门的安全和隐私框架，如 SOC2、ISO 27001、GDPR、HIPAA 等，Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5000 家快速增长的公司使用 Vanta 自动化处理 SOC2 等框架中高达 90% 的工作。在限定时间内，莱尼播客的听众可享受 1000 美元的 Vanta 优惠。请访问 vanta.com/lenny 了解更多信息并领取折扣。今天就开始吧。

---

### (00:03:37) Lenny

**English:**
Christopher, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
克里斯托弗，非常感谢你能来。欢迎来到我的播客。

---

### (00:03:41) Christopher Lochhead

**English:**
Lenny, it is my absolute joy. And let me say in case my ADHD brain forgets, I love all things Lenny. You're doing a great job, buddy. I'm honored to be here. And there's so many people in the entrepreneur startup marketing world who are scam artists, shysters, pieces of shit, idiotic hustle porn stars yelling stupidities. There's a lot of idiocy in the world in which you travel and I travel, and you, sir, stand out. You are making a difference. The conversations you're driving, the content you're creating. You're fucking awesome, Lenny, and I'm really stoked to be here with you.

**中文翻译:**
莱尼，这是我绝对的荣幸。趁我这多动症（ADHD）大脑还没忘，我得说，我喜欢关于莱尼的一切。伙计，你做得太棒了。我很荣幸能来到这里。在创业、初创公司和营销界，有太多骗子、江湖郎中、烂人，还有那些大喊大叫、兜售成功学毒鸡汤（hustle porn stars）的白痴。在你我所处的这个圈子里，有很多愚蠢的事情，而你，先生，脱颖而出。你正在创造改变。你推动的对话，你创作的内容，莱尼，你真他妈的太棒了，我非常激动能和你在一起。

---

### (00:04:27) Lenny

**English:**
Damn, what an intro to my own podcast. I'm bad at accepting compliments. I'm just going to accept that and I appreciate that, man.

**中文翻译:**
哇，这真是我播客有史以来最震撼的开场白。我不擅长接受赞美，但我会试着接受，非常感谢，伙计。

---

### (00:04:34) Christopher Lochhead

**English:**
No, you need to get it. You are a beacon in an ocean of crapola. You are incredible.

**中文翻译:**
不，你必须接受。你是这片垃圾海洋中的一座灯塔。你太不可思议了。

---

### (00:04:42) Lenny

**English:**
Well, enough about me. I really appreciate it. I was preparing for our conversation and usually what I try to do when I prepare for conversations is I read everything the person has written and it was very challenging with you. You have two podcasts, you have at least six books. There's probably more I missed. You have a newsletter, you tweet a lot. There's probably a lot of other stuff I didn't get to. And so you made my job very difficult preparing for this podcast, but also very worthwhile. So I'm excited to begin.

**中文翻译:**
好了，别光说我了。非常感谢。我在准备我们的对话时，通常会尝试读完对方写过的所有东西，但对你来说这太难了。你有两个播客，至少六本书，可能还有我漏掉的。你有新闻通讯，发很多推文，可能还有很多我没接触到的东西。所以你让我的准备工作变得非常困难，但也非常有价值。我很兴奋能开始。

---

### (00:05:07) Christopher Lochhead

**English:**
I apologize for that.

**中文翻译:**
为此我深表歉意。

---

### (00:05:09) Lenny

**English:**
The other thing I noticed as I was browsing your website, and it was hilarious because you have all these testimonials of your book and podcast and you have a lot of negative reviews, like "Off-putting, or, "Very disappointing," or, "Absolute crap." I'm curious why you chose to do that as your website testimonial wall.

**中文翻译:**
我在浏览你的网站时还注意到另一件事，非常搞笑，因为你放了很多关于你的书和播客的推荐语，但其中有很多负面评价，比如“令人反感”、“非常失望”或者“简直是垃圾”。我很想知道，你为什么选择把这些放在网站的推荐墙上？

---

### (00:05:29) Christopher Lochhead

**English:**
Well, and I believe, I'd have to check with Steve Osler, the founder and publisher of Podcast Magazine, but I believe I'm the only podcaster in history to run a full page ad in Podcast Magazine with just negative quotes in it.
(00:05:44):
So a couple reasons. Number one, can we all just have a sense of humor about this stuff? So it's my way, and the name of our team, yet we're sort of a company, but we're more of a band, is Category Pirates. I mean, clearly if you're called Category Pirates, you're probably trying to have a little bit of fun with this stuff. And so part of it is just trying to have a sense of humor with people.
(00:06:10):
The second piece of it is, for a lot of entrepreneurs, marketers, creators, innovators of any kind, we live in this fear that when we launch our thing, whatever our thing is, that we will be criticized by the world and that we will be made fun of. And if you've ever authored a book or done a podcast or done anything, built a product, a software product, built any kind of a product that you feel is part of you, and most innovators, creators, software developers, artists, of course entrepreneurs, feel that way because they put themselves into this stuff. And when somebody criticizes us, many of us are devastated. And I have been in the past too. I'm a person just like anybody else.
(00:06:55):
And what I realized is, fuck them. Anybody who's trying to do anything exponential, anybody who's trying to break and take new ground, anybody who's trying to radically innovate, anybody who's trying to design and dominate new categories of the way we live, work and play, gets criticized. Picasso was called stupid. The Beatles were called terrible. Elvis was called terrible. I just wrote recently a little bit about hip-hop. I was listening to Rick Rubin on Barry Weiss's podcast, excellent episode. Excellent. She does a great job with him. And he was talking about how ridiculed hip-hop was in the beginning and it got banned. And it's the number one category of music in America today.
(00:07:38):
Anyway, so that's also part of it, is to just sort of say, "Hey, look, this is some of the shit people have said about our work and my work, and I'm going to just put it on display, because this is going to happen to all of us."
(00:07:50):
And then I guess, Lenny, the third reason is in the creator world, broadly, there's a lot of people who are breaking their arms patting themselves on the back. And look, I understand why we have to tell people about why they should pay attention to us, and so we use our credentials or our awards or our downloads or our books, I understand that, and I do a little bit of that too. However, come on, let's just not take ourselves so seriously.

**中文翻译:**
嗯，我相信——我得跟《播客杂志》（Podcast Magazine）的创始人兼出版人史蒂夫·奥斯勒确认一下——但我相信我是历史上唯一一个在《播客杂志》上刊登整页广告，且广告里全是负面评价的播客主。
(00:05:44):
原因有几个。第一，我们能不能对这些事保持一点幽默感？这是我的方式，我们团队的名字——虽然我们算是一家公司，但更像是一个乐队——叫“品类海盗”（Category Pirates）。我的意思是，如果你叫这个名字，你显然是想找点乐子。所以，一部分原因就是想展现幽默感。
(00:06:10):
第二点是，对于很多创业者、营销人员、创作者和各种创新者来说，我们生活在一种恐惧中：当我们发布自己的东西时，无论那是什么，都会受到世界的批评和嘲笑。如果你写过书、做过播客、开发过软件产品，或者创造过任何你觉得是自己一部分的东西——大多数创新者、开发者、艺术家和创业者都会有这种感觉，因为他们把心血都倾注进去了——当有人批评我们时，很多人会感到崩溃。我过去也是这样，我也是个普通人。
(00:06:55):
但我意识到，去他妈的。任何试图做指数级事情的人，任何试图开辟新领域的人，任何试图激进创新的人，任何试图设计并主导我们生活、工作和娱乐新品类的人，都会受到批评。毕加索曾被说是愚蠢的，披头士曾被说是糟糕的，猫王也曾被说是糟糕的。我最近刚写了一点关于嘻哈的东西。我在听巴里·魏斯的播客采访里克·鲁宾，那一集非常棒。他谈到嘻哈在刚开始时是如何被嘲笑甚至被禁的，而现在它是美国排名第一的音乐品类。
(00:07:38):
总之，这也是为了表达：“嘿，看，这是人们对我们作品的一些烂评价，我就把它展示出来，因为这种事会发生在我们所有人身上。”
(00:07:50):
莱尼，第三个原因是在创作者的世界里，有太多人在拼命地自我吹捧。我理解为什么我们要告诉别人为什么要关注我们，所以我们会展示资历、奖项、下载量或书籍，我也做一点。但是，拜托，我们别把自己看得太重了。

---

### (00:08:17) Lenny

**English:**
Amazing. I could definitely use more of that skill of not taking negative feedback as seriously. And I love the idea of just embracing it and showing people what people don't like.

**中文翻译:**
太棒了。我确实需要学习这种不把负面反馈当回事的技能。我非常喜欢这种拥抱负面评价并向人们展示别人不喜欢什么的做法。

---

### (00:08:27) Christopher Lochhead

**English:**
Why not? I mean, look, you're incredibly successful and if somebody says something negative about you, okay, great. Fuck them. They're not your people.

**中文翻译:**
为什么不呢？你看，你非常成功，如果有人对你说三道四，好吧，太棒了。去他妈的，他们不是你的受众。

---

### (00:08:39) Lenny

**English:**
Fuck them. There we go.

**中文翻译:**
去他妈的。这就对了。

---

### (00:08:40) Christopher Lochhead

**English:**
I didn't know who you were until Substack, and I saw your logo, the fiery logo, and there was something endearing about your logo. And the other thing that's great about you, from a radical differentiation marketing perspective is, you call yourself Lenny. And when I talk about you, I don't know your fucking last name. I mean, I sort of know it, but I don't really, you know what I mean?

**中文翻译:**
在 Substack 之前我并不认识你，但我看到了你的 Logo，那个火焰 Logo，它有一种亲和力。从激进差异化营销的角度来看，你最棒的一点是你自称“莱尼”。当我谈论你时，我甚至不知道你他妈姓什么。我的意思是，我大概知道，但并不真切，你懂我意思吗？

---

### (00:09:04) Lenny

**English:**
Yeah. It's hard to pronounce.

**中文翻译:**
是的，我的姓很难发音。

---

### (00:09:04) Christopher Lochhead

**English:**
Actually, I was at the gym this morning and I was telling my buddy that we were doing this, and I said, "Oh, I'm going on Lenny's Podcast." He says, "Lenny who?" And I said, "It begins with an R. I don't know. Everybody just calls him Lenny." And so the fact that you are yourself, you don't play a character, you're not a douche, you're just a person trying to be successful in the world and help others, right?
(00:09:28):
That's a very powerful thing. And I think one of the things that is insidious about influencers, hustle porn stars, part of the business model is creating the perception of superiority, right? The reason Grant Cardone and Tai Lopez and all these douchebags pose in front of planes and all this garbage is they want you, the Kardashians are the queens of this, they want you to look at them and go, "Oh, wow, don't I wish that I was them."
(00:10:03):
And so these folks are in the create and monetize envy business, and you're the opposite of that. And I think the legendary educators in the native digital world are the opposite of that. Anybody who's creating separation, anybody who's putting themselves above, anybody for whom there must be, "I must be the leader, and you must be the follower," that's the business model of a massive amount of people in the native digital world, and we reject that. And I know you do.

**中文翻译:**
事实上，我今天早上在健身房告诉我的哥们我们要录节目，我说：“哦，我要去参加莱尼的播客。”他问：“哪个莱尼？”我说：“姓是以 R 开头的，我不知道，大家都叫他莱尼。”所以，你就是你自己，你不演戏，你不装腔作势，你只是一个努力在世界上取得成功并帮助他人的人，对吧？
(00:09:28):
这是一种非常强大的力量。我认为那些网红、成功学毒鸡汤明星最阴险的一点是，他们的商业模式的一部分是创造一种“优越感”。Grant Cardone、Tai Lopez 还有那些混蛋之所以在私人飞机前摆拍，是因为他们想让你——卡戴珊家族是这方面的女王——看着他们想：“哇，我真希望我是他们。”
(00:10:03):
所以这些人做的是“创造并变现嫉妒”的生意，而你恰恰相反。我认为数字原住民世界里的传奇教育者都是相反的。任何制造隔阂、凌驾于他人之上、坚持“我必须是领导者，你必须是追随者”的人，都是数字世界中大量人的商业模式，而我们拒绝这种模式。我知道你也拒绝。

---

### (00:10:34) Lenny

**English:**
Absolutely. We've already gotten way off track, but I love it. I'll just say one thing and then we'll get back on track. The reason I called my newsletter, Lenny's Newsletter is because that was the default recommendation Substack gave me when I signed up. They're just like, "Call it this." And I'm like, "Okay," because I don't know, I didn't have no plans to actually be doing this long term. And then it just stuck. And then I brainstormed for weeks. I'm like, "I need a real name on this thing." And I just couldn't think of anything that I liked. So I'm just like, "All right, I'll just roll with it." And then when the podcast launched, I tried so many ways to call it something else so that it would push the whole naming in a different direction, it wasn't about me, but I couldn't think of anything better. So I'm just rolling with it at this point.

**中文翻译:**
绝对的。我们已经完全跑题了，但我很喜欢。我再说一件事，然后我们就回到正轨。我把我的新闻通讯叫做“莱尼的新闻通讯”（Lenny's Newsletter），是因为我注册 Substack 时那是他们的默认建议。他们说：“就叫这个吧。”我说：“好吧”，因为当时我并没打算长期做下去。结果这个名字就固定下来了。后来我头脑风暴了好几周，想给它起个“正式”的名字，但我实在想不出喜欢的。所以我说：“好吧，就这样吧。”播客上线时，我也尝试过各种名字，想让它不那么以我为中心，但我还是想不出更好的。所以现在我就顺其自然了。

---

### (00:11:12) Christopher Lochhead

**English:**
Well, and the interesting thing is, even though the branding of the shit has your name in, it's not about you. That's the irony, right? Meghan Markle gets canceled. Why? Because it's about her, and it turns out she's infinitely uninteresting. I've consumed enough of your content to know that the cool thing is, yeah, it's called Lenny, but it's actually, you are not trying to impress all of us with how awesome you are in front of a fucking plane or a bunch of scantily clad people, or I don't know what.

**中文翻译:**
有趣的是，尽管品牌名字里有你的名字，但内容并不是关于你的。这就是讽刺之处，对吧？梅根·马克尔被抵制，为什么？因为一切都围绕着她，而事实证明她极其无趣。我看了足够多你的内容，知道最酷的一点是，虽然它叫“莱尼”，但实际上你并没有试图在私人飞机前或一群穿着暴露的人面前向我们炫耀你有多牛。

---

### (00:11:54) Lenny

**English:**
It's true. Well, I'm enjoying this podcast. You're very kind to me. Let's talk about the meat of what I want to chat about, which is your bread and butter category creation. It goes without saying you're a big fan of creating your own category versus what most people try to do, which is try to compete in an existing category. So just to kind of lay a little foundation, can you just explain what this actually means, this idea of category creation for people that have heard this idea in this term, but don't really know what it means.

**中文翻译:**
确实如此。我很享受这次对话，你对我太客气了。让我们谈谈我想聊的核心内容，也就是你的拿手好戏——“品类创造”（Category Creation）。不用说，你是创建自己品类的坚定拥护者，而不是像大多数人那样在现有品类中竞争。为了打好基础，你能为那些听过这个词但不太明白其含义的人解释一下，品类创造到底意味着什么吗？

---

### (00:12:23) Christopher Lochhead

**English:**
It turns out that in business, most people, and in life for that matter, make a unquestioned, unconsidered, undialogued, unthought of decision that they don't know they made. And the decision they make is, "What I'm going to do, is I am going to compete in a market with demand, with a better product/service/brand, maybe a better business model, maybe a better set of growth hacking ideas that I learned on the Lenny Podcast. And when the world gets my better, the world will beat a path to my door."
(00:13:16):
And if you go onto Amazon right now, Lenny, there's roughly a hundred thousand marketing books, and I think I'd have to double check, but I think there's about 60,000 or 80,000 business strategy books. And of course, me and my collaborators, we haven't read all of them, but like you and like many of us in business, we've read many of the tomes, the Bibles out there, and there's an interesting thing about virtually all of them. That's what they're about. It's about how to compete and win.
(00:13:53):
Well, here's the aha. Nobody legendary ever did that. Not a one. We all know who Bob Marley is. We don't know who the 17th greatest reggae musician or band in the world is. We all know who Pablo Picasso is. We don't know who the fifth greatest cubist artist is. And so wherever you look in life, whether it's in the business world, people who drive social change, artists, creators of any kind, the people that we tend to admire the most are the people who broke and took new ground. And the aha here is the category makes the product, the category makes the brand, the category makes the company.
(00:14:51):
So I'll give you the data and then I'll fully answer your question. So here's the data. We did an analysis for our first book where we studied every venture-backed tech company in the US from 2000 to 2015. And we asked a question that, to the best of our knowledge, had never been asked before. And we went to Stanford and we asked a bunch of professors this question, and they said, "We don't know this. You're going to have to do it yourselves." So we did, and incidentally had it peer reviewed and published in the HBR. And if you've ever gotten data published in the HBR, then you know what it's like to have a journalistic proctology exam.
(00:15:32):
Anyway, here's the net of it. In tech market categories, on average, one company earns two-thirds, 76% to be exact, of the total value created as measured by market cap and or valuation. So not market share, which is important, market cap as measured by the value of all the companies in the category. So you take a category, you add all the companys' value together, and you say, "What percent goes to the leader, the category, queen or king? And what percent goes to everybody else?" One company, two-thirds of the economics.
(00:16:12):
So the aha here, Lenny, is when we make the unquestioned, unconsidered, undialogued decision that we didn't know that we made, to compete, we have unwittingly said, "We're going to fight for the 24%." And it's the distinction or delta between create demand and capture demand. So we prefer the term category design, and I can explain why design instead of creation, we don't have anything against creation, but creation creates a confusion in people's mind. When people hear category creation, because most people in business, most people in tech, are strongly oriented to product, what they think you said is first to ship a product that has X features.
(00:17:08):
So when most people say category creation, that's what they think. They say, "They [inaudible 00:17:16] category, Myspace did." Or if you've been around for a little while longer, "GeoCities did." And so category creation, category design, does not equal first to ship a product with a set of features. So what does it equal? Here's the aha. Just like you can design a product, just like you can design a company culture or business model, you can actually design a market.
(00:17:46):
And in so doing, you create a new distinction in value for people that didn't exist before. I'll give you a simple example. If I could own any product in the world right now, I think I'd probably want to own Purell. And there's a great thing about the company that makes Purell. The company's been around for a very, very long time, and they're owned by the original family that created the company. Their original problem that they were solving is, it was a husband and wife team, and they were working in a factory. This was 80 plus years ago. The company, by the way, is called Gojo Industries. Gojo. And Gojo is a portmanteau, putting their two names together. I think it was, maybe it was Gloria and Joseph, or I'd have to double check the husband and wife names, you'll excuse me, but the company's called Gojo Industries, and I think the granddaughter runs it today, if I'm not mistaken.
(00:18:54):
Anyway, so the gal, the wife said, "This bar soap is disgusting. It's full of crapola, it's hairy, it's full of man nastiness." So the solution to washing your hands called a bar of soap was a disgusting, inappropriate solution for her. So she reimagined the problem, not as, "How do I wash my hands," but as, "How do I wash my hands without a disgusting bar soap?" And Gojo Industries created a whole new category called liquid soap. And in most restaurants, most corporate bathrooms, most airport bathrooms, if you start paying attention, you'll see the Gojo logo on the squeezy thing that you pull when you go to get the soap. So unlike most innovators and entrepreneurs, who get obsessed with the solution, and I understand why, we all love our shit, we all love our product. If you want to talk to me about our shit, I want to talk all about it.
(00:20:05):
We could do a 12-hour deep dive on all your content and how you built the newsletter, and you'd love it. It'd be great. We all do. If you're a creator of any kind, entrepreneur, innovator of any kind, you love the thing you're creating, of course. However, Gojo focused on the problem, not just the solution. So they stay obsessed with the problem, and then they ask a different question, which is, "How do I wash my hands in the absence of water?" And of course, the answer to that question is a new category, [inaudible 00:20:44] hand sanitizer. And the dominant brand, of course is Purell.
(00:20:49):
And so the aha here is the company that designs the space and gets it to tip at scale. And when I say designs the space, what I mean is specifically gets a meaningful percentage of the world to agree with their definition of a problem set, which then leads to their definition of a solution set. The company that does that at any kind of scale, wins. And so the number one question for any entrepreneur or any creator at all is, "Do I want to compete for 24% of an existing market category? Or do I want to create my own where if I can execute, I will earn two-thirds of the economics?" That's the decision that most entrepreneurs make, that they don't know that they made. And at its heart, category design is about the most radical kind of differentiation.
(00:21:52):
So most companies actively seek comparison. If you go to, well, if go to many software company's website right now on their homepage, you'll see a Gartner report or a Forrester report on their homepage. You'll see ads and/or content that say, "Here are three competitors and a list of features," and there'll be 25 features, "And then there's us," and there'll be 125 features. And they're actively inviting comparison. You even hear it in ads. If you listen to what marketers say, Lenny, we say the stupidest shit. Don't take our word for it. Anyway. And so the legendary innovators over time, they did not compare their innovation to the past. They broke and took new ground. They wanted to be irreplaceable. They wanted to be so much value in the minds of customers that not only were the switching costs horrible, switch to what?

**中文翻译:**
事实证明，在商业中，大多数人（其实在生活中也一样）做出了一个未经质疑、未经深思、未经对话、未经考虑的决定，而他们甚至不知道自己做出了这个决定。这个决定就是：“我要做的，是在一个有需求的市场中，用更好的产品/服务/品牌去竞争，也许是用更好的商业模式，或者是我在莱尼播客上学到的更好的增长黑客点子。当世界看到我更优秀的产品时，人们自然会踏破我的门槛。”
(00:13:16):
莱尼，如果你现在去亚马逊，大约有 10 万本营销书籍，我可能得核实一下，但大概有 6 万到 8 万本商业战略书籍。当然，我和我的合作伙伴没读过所有的书，但像你和许多商界人士一样，我们读过很多大部头和“圣经”。几乎所有这些书都有一个有趣的共同点：它们都在讲如何竞争并获胜。
(00:13:53):
关键点来了：没有任何传奇人物是这么做的。一个都没有。我们都知道鲍勃·马利是谁，但我们不知道世界上排名第 17 的雷鬼音乐家或乐队是谁。我们都知道毕加索是谁，但不知道排名第 5 的立体主义艺术家是谁。无论你观察生活的哪个领域，无论是商界、推动社会变革的人、艺术家还是任何形式的创作者，我们最钦佩的人往往是那些打破常规、开辟新领域的人。这里的核心逻辑是：品类成就产品，品类成就品牌，品类成就公司。
(00:14:51):
我先给你看数据，然后再完整回答你的问题。数据如下：我们在写第一本书时做了一项分析，研究了 2000 年到 2015 年间美国所有获得风投支持的科技公司。我们提出了一个据我们所知从未有人问过的问题。我们去斯坦福问了一群教授，他们说：“我们不知道，你们得自己做。”于是我们做了，顺便提一下，这项研究经过了同行评审并发表在《哈佛商业评论》（HBR）上。如果你曾在 HBR 发表过数据，你就知道那简直像经历了一场新闻界的“直肠镜检查”。
(00:15:32):
总之，结论是：在科技市场品类中，平均而言，一家公司赚取了总价值（以市值或估值衡量）的三分之二，准确地说是 76%。注意，不是市场份额（虽然那也很重要），而是市值——即该品类中所有公司价值的总和。你把一个品类的所有公司价值加在一起，看看领头羊（品类之王或女王）占多少百分比，其他人占多少。结果是：一家公司拿走了三分之二的经济收益。
(00:16:12):
所以，莱尼，关键在于：当我们做出那个无意识的竞争决定时，我们就不知不觉地选择了去争夺剩下的 24%。这就是“创造需求”和“捕捉需求”之间的区别。所以我们更喜欢“品类设计”（Category Design）这个词，我可以解释为什么用“设计”而不是“创造”。我们不反对“创造”，但“创造”在人们脑中会产生混淆。当人们听到“品类创造”时，因为大多数科技圈的人都是产品导向的，他们会以为你是指“第一个发布具有 X 功能的产品”。
(00:17:08):
所以大多数人提到品类创造时，他们会说：“Myspace 创造了品类”，或者如果你年纪大一点，“GeoCities 创造了品类”。但品类创造/设计并不等于第一个发布某种功能的产品。那它等于什么？就像你可以设计产品、设计公司文化或商业模式一样，你实际上可以设计一个市场。
(00:17:46):
通过这样做，你为人们创造了一种以前不存在的新价值区分。举个简单的例子：如果我现在能拥有世界上任何一个产品，我可能想拥有 Purell（普瑞来，免洗洗手液品牌）。生产 Purell 的公司非常了不起。这家公司存在很久了，由创始人家族持有。他们最初解决的问题是——那是一对在工厂工作的夫妇，那是 80 多年前的事了。这家公司叫 Gojo Industries。Gojo 是一个合成词，把他们两个人的名字拼在了一起。我想是 Gloria 和 Joseph，如果我记错了请原谅，但公司叫 Gojo，现在好像是孙女在打理。
(00:18:54):
总之，那位妻子说：“这种肥皂块太恶心了。上面全是脏东西、毛发，充满了男人的污垢。”所以，对她来说，用肥皂块洗手是一个恶心且不合适的解决方案。于是她重新定义了问题，不是“我如何洗手”，而是“我如何在没有恶心肥皂块的情况下洗手？”Gojo 创造了一个全新的品类：液体肥皂。在大多数餐厅、公司厕所、机场厕所，如果你留意，你会看到那个挤肥皂的装置上有 Gojo 的 Logo。所以，不像大多数痴迷于“解决方案”的创新者和创业者（我理解，我们都爱自己的产品，如果你想聊我的产品，我能聊个没完）。
(00:20:05):
我们可以花 12 小时深入探讨你的内容和你如何建立新闻通讯，你会喜欢的，这很棒。我们都这样。如果你是创作者或创业者，你当然爱你的作品。然而，Gojo 关注的是问题，而不只是解决方案。他们一直痴迷于那个问题，然后提出了一个不同的问题：“我如何在没有水的情况下洗手？”答案当然是一个新品类：免洗洗手液。而主导品牌当然是 Purell。
(00:20:49):
所以，关键在于：设计这个空间并使其大规模爆发的公司会获胜。我所说的“设计空间”，具体是指让世界上相当比例的人认同你对“问题集”的定义，从而引导他们认同你对“解决方案集”的定义。任何能大规模做到这一点的公司都会赢。因此，对于任何创业者或创作者来说，头号问题是：“我是想去竞争一个现有品类中 24% 的份额，还是想创造一个属于自己的品类，如果我执行得好，就能赚取三分之二的收益？”这是大多数创业者在无意识中做出的决定。从本质上讲，品类设计关乎最彻底的差异化。
(00:21:52):
大多数公司都在主动寻求比较。如果你现在去很多软件公司的官网首页，你会看到 Gartner 或 Forrester 的报告。你会看到广告或内容说：“这是三个竞争对手的功能列表，有 25 个功能，而我们有 125 个功能。”他们在主动邀请比较。你甚至在广告里也能听到。如果你听营销人员说的话，莱尼，我们说的话简直蠢透了。总之，随着时间的推移，传奇的创新者不会将他们的创新与过去进行比较。他们打破常规，开辟新领域。他们想要变得不可替代。他们希望在客户心中创造如此巨大的价值，以至于切换成本高得离谱——因为根本没得换。

---

### (00:23:07) Lenny

**English:**
To follow this thread a little bit, companies that you're pretty familiar with, maybe just a rapid fire sharing of their category to give people a concrete sense of what does it even mean to have a category?

**中文翻译:**
顺着这个思路，能不能快速分享几个你熟悉的公司的品类案例，让大家对“拥有一个品类”到底意味着什么有一个具体的概念？

---

### (00:23:21) Christopher Lochhead

**English:**
Okay, let's go.

**中文翻译:**
好，开始吧。

---

### (00:23:22) Lenny

**English:**
It's becoming obvious that they basically all came up with a different category that they wanted to win. And so Gong comes up as an example. I don't know if you know about Gong. I think they-

**中文翻译:**
显而易见，它们基本上都提出了一个自己想要赢下的不同品类。比如 Gong 这个例子，我不知道你是否了解 Gong，我想他们——

---

### (00:23:32) Christopher Lochhead

**English:**
I do.

**中文翻译:**
我了解。

---

### (00:23:33) Lenny

**English:**
So it's basically like sales analytics is what they pitch, is like, this is the first thing you can ever do to understand how your sales team is doing. Is there anything you know more about their approach?

**中文翻译:**
他们推销的基本上是“销售分析”（Sales Analytics），就像是说：这是你第一次能真正了解销售团队表现的工具。关于他们的方法，你还知道更多吗？

---

### (00:23:43) Christopher Lochhead

**English:**
Yeah, I know the space very, very well, and they did something incredibly smart. So they were a little later in the space than some others. And so there were a whole bunch of companies in today which you could broadly refer to as the revenue space, right? In the spirit of full disclosure, I'm familiar with Clari. I'm good friends with Andy. I know the team. I've done some work with them. So all disclosure. Clari, and a handful of others, in the beginning started to create the space that ultimately became RevOps (Revenue Operations). And the interesting thing that Gong did, very smart, was as RevOps started to emerge, they were smart enough to realize that revenue was going to be a big new important space. That CRM didn't actually do it. That ERP didn't actually do it. BI didn't actually do it. And so there was this sort of emerging set of thinking around, "We need a different approach to revenue."
(00:24:44):
They were smart enough to realize that if they went for the whole enchilada, it's not credible from a startup that you're going to go build, that you're going to show up and say, "We have a suite that's equivalent to that of SAP, just for this other area." So they picked off a very tight part of a broader emerging category, and they executed incredibly, and they dominated that part. But here's the mistake they made. In all new mega categories, they start like this. This is exactly what happened in CRM. I could walk you through the history if it matters, but there were companies in support, there were companies in help desk, there were companies in sales, there were companies in marketing, and there were a whole bunch of sub-niches underneath that. There was a point in time in the Salesforce automation category, when that was a standalone category, that some of the hottest companies in that category were sales configurator companies, a further down niche.
(00:25:44):
And so as these mega spaces emerge over time, no one company can fulfill the needs of a customer. And so there's all these niches. The mistake that Gong made, as well as the vast majority of others in that space, is they stayed in their micro niche. So the strategy in the beginning that was genius and exactly what you should do as a startup, all of a sudden, when they didn't expand and set the agenda, the design for the big category, they got fucked. Because now they're niched. And there's a big learning in this Lenny, which is, if you're a company that's already up and running and you're winning, and let's say you're becoming the category queen in your space, every entrepreneur, every CEO, faces a fascinating moment. If they become successful in the first five years or so, which is they realize their biggest barrier to growth going forward, is their current category, because you can only be as big and successful as your market category.
(00:27:02):
And so you have to continuously expand the vision for the category and continuously build on that. And if you don't, and somebody else frames, claims, and names, the bigger agenda, as has been the case, and look, I'm biased, as has been the case with Clari, Clari's crushing everybody in this space right now, and the Gongs and all the other players are now in this horrible position, which is they basically only have two choices. One, they can stay in their niche, which is what most players do, and they argue best of breed "Oh, well, we're the best revenue carbodingulator. And you could go buy an end-to-end revenue platform. But if you do that, you won't get the best functionality in the carbodingulator space. So buy our revenue carbodingulator." That doesn't work. Microsoft proved it over 30 years ago, and we can talk about that if you want.

**中文翻译:**
是的，我非常了解这个领域，他们做了一件极其聪明的事。他们进入这个领域比其他一些公司稍晚。当时有一大堆公司处于今天我们可以广义称为“收入空间”（Revenue Space）的领域。基于信息披露原则，我非常熟悉 Clari，我和 Andy 是好朋友，我认识他们的团队，也和他们合作过。Clari 和其他几家公司最初开始创造后来被称为 RevOps（收入运营）的空间。Gong 做得非常聪明的一点是，随着 RevOps 开始兴起，他们敏锐地意识到“收入”将成为一个新的重要领域。CRM 没能解决这个问题，ERP 没能解决，BI 也没能解决。于是出现了一种新兴思潮：“我们需要一种不同的收入管理方法。”
(00:24:44):
他们很聪明，意识到如果作为一个初创公司直接去挑战整个领域，说“我们有一套相当于 SAP 的套件，只是针对这个新领域”，那是不可信的。所以他们从一个更广泛的新兴品类中切出了一个非常精准的部分，执行力惊人，并主导了那个部分。但他们犯了一个错误。所有新的超级品类（Mega Categories）都是这样开始的。CRM 的发展史也是如此——如果有必要我可以带你回顾历史——当时有做支持的公司、做服务台的公司、做销售的公司、做营销的公司，下面还有一堆细分领域。在“销售力量自动化”（Salesforce Automation）还是一个独立品类的时候，那个品类里最火的公司竟然是做“销售配置器”的公司，那是更深层的细分。
(00:25:44):
随着这些超级空间随时间推移而出现，没有一家公司能满足客户的所有需求，于是就有了这些细分领域。Gong 以及该领域绝大多数公司犯的错误是，他们一直停留在自己的微观细分领域。最初那个天才的、初创公司必做的策略，突然间因为他们没有扩展并设定大品类的议程和设计，让他们陷入了困境。因为现在他们被局限在细分市场里了。莱尼，这里有一个重要的教训：如果你是一家已经步入正轨并正在获胜的公司，比如你正在成为该领域的品类女王，每个创业者和 CEO 都会面临一个迷人的时刻。如果他们在前五年左右获得成功，他们会意识到未来增长的最大障碍就是他们当前的品类，因为你的规模和成功程度只能取决于你所在的市场品类。
(00:27:02):
所以你必须不断扩大品类的愿景并持续构建。如果你不这样做，而别人“定义、命名并占领”（Frames, Claims, and Names）了更大的议程——就像 Clari 所做的那样（当然我有偏见），Clari 现在在这个领域碾压所有人——那么 Gong 和其他所有玩家就会陷入这种糟糕的境地，基本上只有两个选择：第一，留在细分市场，这是大多数玩家的做法，他们争辩说自己是“同类最佳”（Best of Breed），说：“哦，我们是最好的收入组件。你可以去买一个端到端的收入平台，但那样你就得不到我们这种顶级的组件功能。所以买我们的吧。”这行不通。微软在 30 多年前就证明了这一点，如果你想聊，我们可以深入探讨。

---

### (00:28:00) Christopher Lochhead

**English:**
Microsoft proved it over 30 years ago, and we can talk about that if you want. You either stay in your niche and get diminished over time, or you uplevel and you go to play for the whole enchilada. The problem is for them and all the others in this space who didn't do that, if they were to do it today, well over a year after Clari did, they're just a Clari copycat. And so basically you either go compete with Clari for who can be the category king, or you stay in your niche and get diminished over time. And if you're going to go compete with the company that is laying down the category design that's picking up the most momentum for the overall market, you better know how to do a fifth dan black belt category wars.

**中文翻译:**
微软在 30 多年前就证明了这一点。你要么留在细分市场并随着时间的推移而萎缩，要么提升层次去争夺整个市场。对他们和该领域所有没这么做的人来说，问题在于，如果他们今天才开始做（在 Clari 已经做了一年多之后），他们就只是 Clari 的模仿者。所以基本上，你要么去和 Clari 竞争谁才是品类之王，要么留在细分市场慢慢消亡。如果你打算去挑战那家已经制定了品类设计并赢得了市场最大势头的公司，你最好懂得如何进行“黑带五段”级别的品类战争。

---

### (00:28:58) Lenny

**English:**
Following that thread, there's a bunch of threads I'd love to follow, but something I definitely wanted to touch on is, in this concept of the better trap, which is where most people go, where they try to be the better solution in an existing category. And just to reinforce that point, what have you seen? What have you learned about just why that is often, and maybe always the wrong approach?

**中文翻译:**
顺着这个思路，我想探讨的东西很多，但我特别想触及的是“更好陷阱”（The Better Trap）这个概念。大多数人都会掉进这个陷阱，试图在现有品类中做一个“更好”的解决方案。为了强化这一点，你观察到了什么？关于为什么这通常（甚至总是）错误的方法，你学到了什么？

---

### (00:29:19) Christopher Lochhead

**English:**
Let's take a very current example, Threads. We just wrote about this. When Threads came out, and I can show you all the headlines if you want to see them, New York Times, nevermind tech... All these places. Twitter killer, Twitter killer, Twitter killer, Twitter killer. And at the time there's all this discussion of Musk and Zuck having a UFC cage fight. And so there's all this buildup into the launch of Threads and there's all this supposed Twitter hate, and, quote, unquote, "Everybody's leaving Twitter." All right. So Threads comes out. What happens? Threads surpasses GPT as the fastest growing app ever.
(00:30:08):
Now the headlines, Lenny, are coming. This is it. Zuck's a genius. It's incredible. And by the way, this sits inside one of the newer stupid axioms in Silicon Valley. So this is a side note, but when somebody says something in Silicon Valley that enough people think, "Yes, that's smart." They just parrot it. They don't actually think about it. There's a current thinking in Silicon Valley, and this was real loud as Threads was coming out, this was the reason why Threads was the Twitter killer. What you need, Lenny, is brand and distribution. That's what you need, especially distribution. I would assert to you that Threads had the greatest distribution advantage of any new piece of software ever launched. If there's another one that has a greater distribution advantage, I'd like to know what it is.

**中文翻译:**
让我们举一个非常近期的例子：Threads。我们刚写过这个。当 Threads 发布时，我可以给你看所有的头条新闻——《纽约时报》、科技媒体……到处都是。“推特杀手，推特杀手，推特杀手”。当时大家都在讨论马斯克和扎克伯格要进行 UFC 笼斗。Threads 发布前有大量的造势，还有所谓的“大家都在恨推特”、“所有人都在离开推特”。好，Threads 发布了。发生了什么？Threads 超越了 ChatGPT，成为历史上增长最快的应用。
(00:30:08):
莱尼，头条新闻接踵而至：“就是它了，扎克伯格是个天才，太不可思议了。”顺便说一下，这涉及硅谷最新的一个愚蠢公理。这是个题外话，但在硅谷，当有人说了一句让足够多的人觉得“对，这很聪明”的话时，大家就会像鹦鹉学舌一样重复，而不去思考。硅谷当时有一种思潮，在 Threads 发布时声音特别大，解释为什么 Threads 是推特杀手：莱尼，你需要的是“品牌和分发”。这就是你需要的，尤其是分发。我敢断言，Threads 拥有历史上任何新软件发布时都不曾有过的巨大分发优势。如果还有分发优势更大的，我很想知道是什么。

---

### (00:31:11) Lenny

**English:**
No, that seems right. Seems right.

**中文翻译:**
不，这听起来没错。确实如此。

---

### (00:31:14) Christopher Lochhead

**English:**
Massive distribution, incredible, easy up and on, incredible. Free product, not even freemium, free. Awesome. And Facebook Meta, you tell me, one of the 10 most powerful brands in tech?

**中文翻译:**
巨大的分发量，不可思议，极其容易上手。免费产品，甚至不是“免费增值”，而是完全免费。太棒了。还有 Facebook Meta，你告诉我，它是科技界最强大的 10 个品牌之一吗？

---

### (00:31:32) Lenny

**English:**
Absolutely.

**中文翻译:**
绝对是。

---

### (00:31:33) Christopher Lochhead

**English:**
How many users does Facebook have today, Lenny, do you know?

**中文翻译:**
莱尼，你知道 Facebook 现在有多少用户吗？

---

### (00:31:35) Lenny

**English:**
Over a billion? Might be more.

**中文翻译:**
超过 10 亿？可能更多。

---

### (00:31:37) Christopher Lochhead

**English:**
How many billion person apps have there been in the history of apps?

**中文翻译:**
在应用历史上，有多少个拥有 10 亿用户的应用？

---

### (00:31:42) Lenny

**English:**
None.

**中文翻译:**
没有。

---

### (00:31:43) Christopher Lochhead

**English:**
Right.

**中文翻译:**
没错。

---

### (00:31:43) Lenny

**English:**
I think.

**中文翻译:**
我想是的。

---

### (00:31:44) Christopher Lochhead

**English:**
Legendary brand, the greatest distribution advantage in history. What happened? It cratered. It's gone. It's still there, but nobody's there.

**中文翻译:**
传奇品牌，历史上最大的分发优势。结果呢？它崩了。它完了。它虽然还在，但没人用了。

---

### (00:31:59) Lenny

**English:**
They're launching the [inaudible 00:32:00] soon so they have another shot.

**中文翻译:**
他们很快要发布[听不清]，所以还有一次机会。

---

### (00:32:02) Christopher Lochhead

**English:**
Oh yeah. Now why, why did that happen? Why did one of the richest people in the history of the world, who's potentially one of the smartest people in the history of entrepreneurship in tech, fail so miserably when the entire world said he was going to "kill," quote, unquote, Twitter? And after the initial, quote, "success" of Threads everybody said that's exactly what was going to happen. And now all those experts are surprisingly quiet. The legendary Kevin Maney said that category design is a new lens on business. It's a different lens. It's sits next to the product lens, it sits next to the competition lens, but it is equally important. So here's what happened with Threads.
(00:32:54):
They attacked an existing, well-known, well understood, incredibly well-defined problem with a direct copy. They even were celebrating that it was Twitter, just better. They said virtually those words. So known existing problem with a known existing solution that was, quote, unquote, "better" and integrated with the rest of the Meta shit. Quote, "Everybody checked it out and everybody went away." Why? Here's the aha.
(00:33:33):
Problems create categories, and you either have to A, solve a new problem, or B, reframe, name and claim an existing problem in a, I'm going to use these words on purpose, very different way. And if you reframe the existing problem such that people see it in a different way, that's when they'll be open to a new solution. But the mistake is the impasses is on the wrong [inaudible 00:34:11]. The impasses is on the product. Because we live in a world where just like the availability of oxygen, we believe the best product wins. Zuckerberg is going to blow in excess of a billion dollars on Threads and it will fail. It already has failed. Because you can't take an existing problem with an existing solution, launch exactly the same shit, tell the world it's better and have the world embrace it. Because the problem makes the solution the other way around.

**中文翻译:**
哦是的。但为什么？为什么会发生这种事？为什么这个世界上最富有的人之一，可能是科技创业史上最聪明的人之一，在全世界都说他要“杀死”推特时，却失败得如此惨烈？在 Threads 最初所谓的“成功”之后，每个人都说这正是将要发生的事。而现在，所有那些专家都出奇地安静。传奇人物凯文·梅尼（Kevin Maney）曾说，品类设计是审视商业的一个新视角。它是一个不同的视角，与产品视角、竞争视角并列，但同样重要。Threads 的情况是这样的：
(00:32:54):
他们用一个直接的复制品去攻击一个现有的、众所周知的、被充分理解且定义极其明确的问题。他们甚至在庆祝这就是推特，只是“更好”。他们几乎就是这么说的。所以，针对一个已知的现有问题，提供一个已知的现有解决方案，并宣称它“更好”，且与 Meta 的其他东西集成。结果是：“每个人都去看了看，然后每个人都离开了。”为什么？关键点来了：
(00:33:33):
问题创造品类。你要么 A，解决一个新问题；要么 B，以一种（我故意用这个词）“非常不同”的方式重新定义、命名并占领一个现有问题。如果你重新定义了现有问题，让人们以不同的方式看待它，那时他们才会对新解决方案持开放态度。但错误在于，重点放错了地方。重点放在了产品上。因为我们生活在一个像相信氧气存在一样相信“最好的产品会赢”的世界。扎克伯格将在 Threads 上挥霍超过 10 亿美元，而它会失败。它已经失败了。因为你不能拿着一个现有的问题和现有的解决方案，发布完全一样的东西，告诉世界它更好，并指望世界拥抱它。因为是问题成就了解决方案，而不是反过来。

---

### (00:34:51) Lenny

**English:**
So classic advice along these lines is, if you're, say, 10 times better than the existing product, you have a good chance at getting people to care and having success. Is there a line of just like it's the same thing but 10 times better? Or do you have to, in your experience, reframe? And I want to talk about that.

**中文翻译:**
这方面的经典建议是：如果你比现有产品好 10 倍，你就有很大机会让人们关注并获得成功。在你的经验中，是否存在“同样的东西但好 10 倍就能赢”的界限？还是说你必须重新定义？我想聊聊这个。

---

### (00:35:07) Christopher Lochhead

**English:**
Let's just look at the evidence. We could agree that Jeff Bezos is not a dumb person, yes?

**中文翻译:**
让我们看看证据。我们可以同意杰夫·贝佐斯不是个笨蛋，对吧？

---

### (00:35:14) Lenny

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:35:16) Christopher Lochhead

**English:**
Do you have an Amazon Fire phone?

**中文翻译:**
你有亚马逊的 Fire Phone 手机吗？

---

### (00:35:19) Lenny

**English:**
I don't.

**中文翻译:**
我没有。

---

### (00:35:20) Christopher Lochhead

**English:**
Neither do I. Why not?

**中文翻译:**
我也没有。为什么没有？

---

### (00:35:24) Lenny

**English:**
I'm very happy with my iPhone.

**中文翻译:**
我对我的 iPhone 非常满意。

---

### (00:35:27) Christopher Lochhead

**English:**
And so, Bezos launched a better product and nobody bought it. And the reason nobody bought it is the problem. And therefore the solution that you think you're solving with your iPhone is solved with your iPhone. When was the last time you enjoyed a Red Bull Cola?

**中文翻译:**
所以，贝佐斯发布了一个更好的产品，但没人买。没人买的原因在于“问题”。你认为你用 iPhone 解决的问题，已经被 iPhone 解决了。你上一次喝红牛可乐（Red Bull Cola）是什么时候？

---

### (00:35:48) Lenny

**English:**
Not once.

**中文翻译:**
一次也没喝过。

---

### (00:35:50) Christopher Lochhead

**English:**
Red Bull made exactly the same mistake that Zuck just made with threads. What Red Bull believed was, "We built one of the greatest brands in the world." Which they have, but they didn't understand why. The category made the brand not the other way around. Energy Drink made the category, so they go, "Great, we can put our brand on anything and it'll sell. So let's make Cola." They lost a bazillion dollars. It's reported that Microsoft lost somewhere between 400 and a billion dollars in Microsoft Stores. Did you ever go to a Microsoft store, Lenny?

**中文翻译:**
红牛犯了和扎克伯格在 Threads 上一模一样的错误。红牛认为：“我们建立了世界上最伟大的品牌之一。”他们确实做到了，但他们不明白为什么。是品类成就了品牌，而不是反过来。“能量饮料”成就了这个品类，所以他们想：“太好了，我们可以把品牌贴在任何东西上，它都会好卖。那我们做可乐吧。”结果他们亏了天文数字。据报道，微软在微软零售店（Microsoft Stores）上亏损了 4 亿到 10 亿美元。莱尼，你去过微软零售店吗？

---

### (00:36:28) Lenny

**English:**
I walked by them in the mall and I don't think I've ever entered.

**中文翻译:**
我在商场里路过过，但我好像从来没进去过。

---

### (00:36:32) Christopher Lochhead

**English:**
Well, they look exactly... If you remember, they look exactly like an Apple Store. And Ballmer famously told the team, when the Apple Stores took off, he famously told the team, "Go to the Apple Stores, study everything they're doing and let's copy it exactly." Google that shit, it's out there. Well, it didn't work. Why? Because you can't attack an incumbent category queen unless you frame, name and claim a new or different problem. Because when the existing problem is well understood and the existing solution is well understood, there's no need for a new solution. Even if people, quote, unquote, "hate Twitter," didn't do anything to Twitter, and now Zuck's going to have to write off probably over a billion dollars on Threads. And the funny thing is, Lenny, this just keeps happening over and over and over. Venture capitalists in the next five years will blow at least half a trillion dollars in the AI space alone, on me too, demand chasing existing category competing startups that have a 10x better product, no one cares.
(00:38:02):
And look, we're all going to sit here and watch them do it. And we, category pirates, and those of us in the category design world will say, "Told you." And they're just going to keep doing it. More importantly, because the big companies in many cases can afford to continue to fail and make this mistake. The tragedy in this is how many legendary innovative products never got to see the light of day because the inventor, the creator, the entrepreneur, believed in the product, but didn't know that every solution has to fit into a problem of value for people. And so their innovation went nowhere.

**中文翻译:**
嗯，它们看起来完全……如果你记得的话，它们看起来和苹果零售店一模一样。鲍尔默在苹果零售店大获成功时曾对团队说了一句名言：“去苹果店，研究他们做的一切，然后完全照抄。”你可以去搜一下，这是公开的。结果呢，没用。为什么？因为除非你定义、命名并占领一个新问题或不同的问题，否则你无法攻击现有的品类女王。因为当现有的问题和现有的解决方案都被充分理解时，就不需要新的解决方案了。即使人们口头上说“讨厌推特”，那也没对推特造成实质伤害，而现在扎克伯格可能得在 Threads 上核销超过 10 亿美元。有趣的是，莱尼，这种事一直在反复发生。在未来五年里，风险投资家仅在 AI 领域就会挥霍至少 5000 亿美元，投在那些“我也是”（me too）、追逐需求、在现有品类中竞争、号称产品好 10 倍的初创公司上，但没人关心。
(00:38:02):
看吧，我们都会坐在这里看着他们这么做。而我们这些“品类海盗”和品类设计界的人会说：“早告诉过你了。”但他们还是会继续。更重要的是，大公司在很多情况下亏得起，能继续犯这种错。这里的悲剧在于，有多少传奇的创新产品从未见过天日，因为发明者、创作者、创业者只相信产品，却不知道每一个解决方案都必须契合一个对人们有价值的问题。于是，他们的创新无疾而终。

---

### (00:38:51) Lenny

**English:**
Let's talk about how to actually go about designing a category. You've used this phrase a few times, and that may be the best lens to approach it. If not, we can go at it from a different direction. But this idea of framing, naming, and claiming, how do you do that? What's that process like?

**中文翻译:**
让我们谈谈如何实际去设计一个品类。你多次提到过这个短语，这可能是切入的最佳视角。如果不是，我们可以从另一个方向切入。但关于“定义、命名和占领”（Framing, Naming, and Claiming）这个想法，具体怎么做？那个过程是怎样的？

---

### (00:39:08) Christopher Lochhead

**English:**
Great question. It starts somewhere where most people don't want to start, and that is, the first law of category design is thinking about thinking is the most important kind of thinking. Thinking about thinking is the most important kind of thinking. If you're going to think about thinking, we have to define thinking. Now, the minute I start down this path, there's a meaningful percentage of people whose eyes rolling, going, "Here comes some bullshit," right? "Just tell me how to do the SEO, Lenny. Where's the SEO? Or where's the..." Whatever the tactical thing is.
(00:39:47):
So the first thing we have to do is break down thinking. Roger Martin is considered to be the greatest management thinker, or certainly one of them alive today. We were lucky enough to have him on the podcast when his most recent book came out, which if I'm remembering correctly, is called the New Way to think. People call him the new Peter Drucker. And he describes it as effectively as anyone I've ever heard. And at a high level, and this is me paraphrasing, so give me some license, but he's the source. At a high level there's two kinds of thinking, reflective and reflexive. And now, this is my editorializing. What most people think is reflective thinking is actually reflexive thinking. What's reflex versus reflective? Reflex is simple. You go for an annual checkup, yes?

**中文翻译:**
好问题。它始于一个大多数人不想开始的地方，那就是：品类设计的第一条法则——“思考‘思考本身’是最重要的一种思考”。如果你要思考“思考本身”，我们就必须定义什么是思考。现在，我一走这条路，肯定有相当一部分人会翻白眼说：“又在扯淡了，对吧？”“莱尼，直接告诉我怎么做 SEO 吧。SEO 在哪？或者那个战术性的东西在哪？”
(00:39:47):
所以我们首先要做的是分解“思考”。罗杰·马丁（Roger Martin）被认为是当今最伟大的管理思想家之一。我们很幸运在他最近的新书《思考的新方式》（The New Way to Think）出版时邀请他上了播客。人们称他为“新彼得·德鲁克”。他对此的描述比我听过的任何人都有效。在高层次上（这是我的转述，请允许我发挥一下，但他才是源头），思考有两种：反思性思考（Reflective）和反应性思考（Reflexive）。现在，这是我的评论：大多数人认为的反思性思考，实际上只是反应性思考。什么是“反应”与“反思”的区别？反应很简单。你会去做年度体检，对吧？

---

### (00:40:41) Lenny

**English:**
I should be.

**中文翻译:**
我应该去。

---

### (00:40:43) Christopher Lochhead

**English:**
Have you ever had a doctor whack your knee with the little pink?

**中文翻译:**
医生有没有用那个粉色的小锤子敲过你的膝盖？

---

### (00:40:46) Lenny

**English:**
Yeah.

**中文翻译:**
有的。

---

### (00:40:46) Christopher Lochhead

**English:**
And your knee goes whoop.

**中文翻译:**
然后你的膝盖就“砰”地跳一下。

---

### (00:40:49) Lenny

**English:**
I do [inaudible 00:40:49] .

**中文翻译:**
我会[听不清]。

---

### (00:40:50) Christopher Lochhead

**English:**
And she's testing your reflexes. And that's an involuntary thing, when you're sitting on the doctor's table and your legs are hanging like a little kid and she goes whack, your leg just does this twitch, right? So that's a reflex. And reflexive thinking is very, very powerful. You have a driver's license, I'm guessing.

**中文翻译:**
她在测试你的反射（Reflexes）。那是一种无意识的行为，当你坐在医生的诊疗台上，腿像小孩一样悬空，她一敲，你的腿就会抽动一下，对吧？这就是反射。而“反应性思考”非常强大。我猜你有驾照。

---

### (00:41:11) Lenny

**English:**
I do.

**中文翻译:**
我有。

---

### (00:41:12) Christopher Lochhead

**English:**
And when was the last time you were in a vehicle, driving?

**中文翻译:**
你上一次开车是什么时候？

---

### (00:41:15) Lenny

**English:**
Yesterday.

**中文翻译:**
昨天。

---

### (00:41:17) Christopher Lochhead

**English:**
And if you're out on the road driving and somebody cuts you off, what are you likely to do?

**中文翻译:**
如果你在路上开车，有人突然别你的车，你可能会怎么做？

---

### (00:41:25) Lenny

**English:**
I get a little upset and then I keep driving.

**中文翻译:**
我会有点生气，然后继续开。

---

### (00:41:29) Christopher Lochhead

**English:**
But I would assert, Lenny, you do something before you get upset.

**中文翻译:**
但我敢断言，莱尼，在你生气之前，你会先做一件事。

---

### (00:41:31) Lenny

**English:**
I guess I try to avoid hitting this car.

**中文翻译:**
我想我会尽量避免撞上那辆车。

---

### (00:41:34) Christopher Lochhead

**English:**
Yes. And maybe you swerve, maybe you hit the brakes, maybe you do both. My point is this, the car cuts you off and we instantly, no thinking, react in order to save our lives, not damage our vehicles, not hurt anybody else. We didn't think about that. We literally just reacted. That's the way people think about most things. I say to you, Lenny, let's talk about guns and abortion and immigration rights in America.

**中文翻译:**
是的。也许你会猛打方向盘，也许你会踩刹车，或者两者兼而有之。我的观点是：车子别过来，我们瞬间——不假思索地——做出反应，为了保命、为了不撞坏车、为了不伤到别人。我们没有思考，我们只是在反应。这就是人们思考大多数事情的方式。莱尼，我对你说：让我们谈谈美国的枪支、堕胎和移民权利。

---

### (00:42:14) Lenny

**English:**
No, thanks.

**中文翻译:**
不，谢谢。

---

### (00:42:15) Christopher Lochhead

**English:**
Now you have opinions about those things, right?

**中文翻译:**
你对这些事情是有看法的，对吧？

---

### (00:42:17) Lenny

**English:**
I do.

**中文翻译:**
我有。

---

### (00:42:18) Christopher Lochhead

**English:**
As do I. Most people don't challenge their own thinking. Most people say, "Now, why do I only think what I think about abortion? Where did I learn that? What do I really think about abortion? What do others think about abortion? Are there smart people in the world that I admire who are more educated and experienced in this field that have meaningfully different opinions than my own? There are. Why is that?" Et cetera, et cetera, et cetera. We don't fucking do that, we say our opinion on abortion is the opinion on abortion. And in the United States of America in the political domain we say, "And anybody who thinks differently is trying to kill America." That's not thinking. So reflexive thinking is, what do I really think? Why do I think that? And in the business world, most people unconsciously assume the future is a continuation of the past. That's not what legendary entrepreneurs do. Legendary entrepreneurs don't just think they know the future is going to be different, because they're designing that different future. And the problem they're focused on matters to them so much that the fact that the problem continues to persist makes them batshit crazy. RJ... Is it RJ or JR? I can't remember now... The founder of Rivian, obviously Musk at Tesla, these guys are obsessed. It drives them insane. They don't understand why we're not all in EVs already.
(00:44:12):
And so my friend Mike Maples, the legendary venture capitalist from Floodgate, says, "The greatest entrepreneurs are visitors from the future telling us how it's going to be." And the reason many of them are so irascible is because the fact that the present is not already at the future that they see makes them insane. And so the point being legendary entrepreneurs and creators make the future different. They literally are in the design different futures business. Can I tell you a story?

**中文翻译:**
我也一样。但大多数人不会挑战自己的思维。大多数人不会问：“为什么我对堕胎只有这种看法？我是从哪学到的？我到底是怎么想的？别人是怎么想的？世界上有没有我钦佩的、在该领域更有学识和经验的人，持有与我截然不同的观点？有的。那是为什么？”等等。我们他妈的根本不这么做，我们只会说：“我对堕胎的看法就是唯一的真理。”在美国政治领域，我们会说：“任何想法不同的人都在试图毁灭美国。”那不叫思考。所以“反思性思考”是：我到底在想什么？我为什么这么想？在商业世界里，大多数人潜意识里认为未来是过去的延续。传奇创业者不这么做。传奇创业者不仅认为未来会不同，他们还在设计那个不同的未来。他们关注的问题对他们来说太重要了，以至于那个问题依然存在这件事让他们抓狂。Rivian 的创始人 RJ（还是 JR？我忘了）、特斯拉的马斯克，这些人都是偏执狂。这让他们发疯。他们不明白为什么我们现在还没全部开上电动车。
(00:44:12):
我的朋友、来自 Floodgate 的传奇风投家迈克·梅普尔斯（Mike Maples）说：“最伟大的创业者是来自未来的访客，告诉我们未来会是什么样子。”他们中许多人之所以如此暴躁，是因为现实还没达到他们所预见的未来，这让他们发狂。所以，重点是：传奇创业者和创作者让未来变得不同。他们实际上是在做“设计不同未来”的生意。我能给你讲个故事吗？

---

### (00:44:46) Lenny

**English:**
Please.

**中文翻译:**
请讲。

---

### (00:44:50) Christopher Lochhead

**English:**
We're friends, and we've done some work with the guys who created Lomi. And Lomi is the first kitchen appliance in 20 years to earn a spot on the kitchen counter. A, it's one of the fastest growing new consumer items in the last 20 years. And B, if you think about your kitchen counter, do you have a toaster?

**中文翻译:**
我们和创造 Lomi 的那帮人是朋友，也合作过。Lomi 是 20 年来第一款在厨房台面上赢得一席之地的厨房电器。第一，它是过去 20 年里增长最快的新消费品之一。第二，想想你的厨房台面，你有烤面包机吗？

---

### (00:45:19) Lenny

**English:**
Yep.

**中文翻译:**
有的。

---

### (00:45:21) Christopher Lochhead

**English:**
Coffee maker?

**中文翻译:**
咖啡机呢？

---

### (00:45:22) Lenny

**English:**
Yeah, I don't drink too much coffee, but we do have one.

**中文翻译:**
有的，我不怎么喝咖啡，但确实有一个。

---

### (00:45:25) Christopher Lochhead

**English:**
Any other devices on the kitchen counter?

**中文翻译:**
台面上还有别的设备吗？

---

### (00:45:27) Lenny

**English:**
We got a rice cooker and the rest is hidden away.

**中文翻译:**
有个电饭煲，剩下的都收起来了。

---

### (00:45:33) Christopher Lochhead

**English:**
Perfect. So what's Lomi? Lomi is the category designer of the smart home composter. Imagine a device that's one and a half or twice the size of a good size toaster. And what Lomi does is you take your food scraps, and it turns out that depending on whose numbers you want to believe, in America, we throw away somewhere between 40 to 60% of our food. And it turns out that food garbage, food waste is some of the most damaging to the environment. So what does Lomi do? You take your food scraps, you dump it into Lomi, you fill that shit up, Lomi's got a button on the front, you press that button, and what used to take three to six months to compost gets composted in three to six hours.
(00:46:29):
And even, this is weird, it smells good to me. Lomi did not say that, "we're better garbage, that we're different garbage, that we're better recycling." What they said was, "We are a different way of solving this huge problem." And they use both personal motivation, nobody likes throwing out garbage, nobody likes a big mess in their kitchen, et cetera, and an altruistic vision, which is... And oh by the way, if we do this, we will do something that governments heretofore have not been able to do, which is take a massive amount of environment hurting gases out of the atmosphere. And it turns out because of global climate change that we're creating more and more sand and we have dirt traces. Lomi dirt has been shown to be amongst the most nutrient rich dirt in the world. Here is a company with a breakthrough technology that truly makes a difference in the world with a business model that allows them to build a highly profitable high growth business.
(00:47:48):
And the way they got there was by designing a new category and showing the world why, by making room in your tight kitchen for this new device, you'll make a difference for your family and the world. And if all they had done was what, by way of example, Dean Kamen did when he launched the Segway, which is, isn't this cool? Nothing would've happened. So my point is, the Lomi guys designed a product, a company, and a new market category. They created demand out of nothing for, I think the average price is around 400 bucks. The sum total of the market for smart home composters when they launched was fucking zero. And their vision for the new category was so compelling, Jay-Z was one of their first investors.

**中文翻译:**
完美。那么 Lomi 是什么？Lomi 是“智能家用堆肥机”（Smart Home Composter）这一品类的设计者。想象一个比普通烤面包机大一两倍的设备。Lomi 的作用是处理你的食物残渣。据统计，美国人会扔掉 40% 到 60% 的食物。而事实证明，厨余垃圾是对环境破坏最严重的因素之一。Lomi 怎么做？你把厨余垃圾倒进 Lomi，装满它，按一下前面的按钮，原本需要 3 到 6 个月才能完成的堆肥，在 3 到 6 个小时内就完成了。
(00:46:29):
甚至——这听起来很怪——我觉得它闻起来还挺香。Lomi 并没有说“我们是更好的垃圾处理方式”或“我们是更好的回收方式”。他们说的是：“我们是解决这个巨大问题的另一种方式。”他们结合了个人动机（没人喜欢倒垃圾，没人喜欢厨房乱糟糟）和利他愿景（顺便说一下，如果我们这样做，我们将完成政府迄今无法完成的任务，即从大气中清除大量有害气体）。而且由于全球气候变化，土壤流失严重，而 Lomi 产生的土被证明是世界上营养最丰富的土壤之一。这是一家拥有突破性技术、真正改变世界、且拥有高增长高利润商业模式的公司。
(00:47:48):
他们成功的秘诀在于设计了一个新品类，并向世界展示：为什么在你狭小的厨房里为这个新设备腾出空间，能为你家人和世界带来改变。如果他们只是像狄恩·卡门（Dean Kamen）发布 Segway（平衡车）时那样说“这玩意儿酷不酷？”，那什么都不会发生。所以我的观点是，Lomi 的团队设计了一个产品、一家公司和一个新的市场品类。他们凭空创造了需求，平均售价约 400 美元。在他们发布之前，智能家用堆肥机的市场规模他妈的是零。而他们对新品类的愿景如此诱人，以至于 Jay-Z 成了他们的首批投资者之一。

---

### (00:48:53) Lenny

**English:**
I have their site up. Thinking about this framework of, frame it, name it, claim it, they framed the problem in this unique way of... Is it the framing of the problem or framing of a solution? The framing step, best way to think about that.

**中文翻译:**
我正开着他们的网站。想到“定义、命名、占领”这个框架，他们以这种独特的方式定义了问题……是定义问题还是定义解决方案？关于“定义”（Framing）这一步，最好的思考方式是什么？

---

### (00:49:09) Christopher Lochhead

**English:**
There's something in category design called languaging, which is the strategic use of language to change thinking. And a mistake that a lot of entrepreneurs make is they use old language to describe their new thing. And we can't use so much new language that nobody knows what the fuck we're talking about, so we have to meet the category where it is and bring them forward, but we have to create new language. Can I share with you one of my favorite, most recent, favorite category design stories in this regard?

**中文翻译:**
品类设计中有一个概念叫“语言化”（Languaging），即战略性地使用语言来改变思维。很多创业者犯的错误是使用旧语言来描述他们的新事物。我们不能使用太多新词以至于没人听得懂我们在说什么，所以我们必须在现有品类的基础上引导人们前进，但我们必须创造新语言。关于这一点，我能分享一个我最近最喜欢的品类设计故事吗？

---

### (00:49:42) Lenny

**English:**
Please.

**中文翻译:**
请讲。

---

### (00:49:44) Christopher Lochhead

**English:**
You've been on an elevator, yes?

**中文翻译:**
你坐过电梯吧？

---

### (00:49:45) Lenny

**English:**
Yes.

**中文翻译:**
坐过。

---

### (00:49:47) Christopher Lochhead

**English:**
Have you ever looked at the floor and seen a logo on the floor of the elevator?

**中文翻译:**
你有没有低头看过电梯地板上的 Logo？

---

### (00:49:53) Lenny

**English:**
I can't recall. I imagine it.

**中文翻译:**
我不记得了，但我能想象到。

---

### (00:49:55) Christopher Lochhead

**English:**
Well, if you do, you'll more than likely see this name, Otis. Otis Elevator. Most people don't know why Otis is the category queen of elevators. Well, here's why. Elisha Otis invented the elevator. Now, pre-Elisha, there were no skyscrapers. Because how could you get to the top floor? How could you build the top floor, et cetera, et cetera, et cetera. So when he creates the elevator, there's no known problem for it to solve. So he demonstrates it, people think it's cool. He shows it at like fares and shit. Because the big problem with prior elevators was they would crash. And so he built this safety system to catch them if the wiring would crash. And the category name, he actually used, Lenny, he called it the safety elevator to address the current problem in the space, which is... I don't know. People still went, "That's interesting, but why do I need a safety elevator?" It's a solution with no problem.
(00:51:14):
So what does he do? Languaging. And in category design, one of the breakthroughs is this thing called a point of view, which helps you frame, claim and name a problem and educate the world on why they should move from the way it is to, we call them frotos, from to, a new and different way. So Elisha has to make the market, there's zero demand. It's what many of our smart VC friends call a zero billion market, which is what you want. So what does Elisha call it? The vertical... Railway

**中文翻译:**
如果你看了，你很有可能会看到这个名字：Otis（奥的斯）。奥的斯电梯。大多数人不知道为什么奥的斯是电梯界的品类女王。原因如下：伊莱沙·奥的斯（Elisha Otis）发明了电梯。在奥的斯之前，没有摩天大楼。因为你怎么上顶层？你怎么建造顶层？等等。所以当他发明电梯时，并没有一个已知的问题需要解决。他展示了它，人们觉得很酷。他在博览会上展示。因为之前的电梯最大的问题是会坠毁，所以他建立了一个安全系统，如果钢索断裂就能卡住电梯。莱尼，他最初使用的品类名称叫“安全电梯”（Safety Elevator），以解决当时的问题。但人们还是会说：“很有趣，但我为什么需要安全电梯？”这是一个没有问题的解决方案。
(00:51:14):
那他做了什么？语言化。在品类设计中，一个突破点是所谓的“观点”（Point of View, POV），它帮助你定义、占领并命名一个问题，并教育世界为什么要从现状转变到（我们称之为 Froto，即 From-To）一种全新的、不同的方式。奥的斯必须创造市场，当时需求为零。这就是我们聪明的风投朋友所说的“零亿市场”（Zero Billion Market），而这正是你想要的。那么奥的斯把它称为什么？“垂直……铁路”（Vertical Railway）。

---

### (00:51:57) Lenny

**English:**
Beautiful.

**中文翻译:**
太妙了。

---

### (00:51:59) Christopher Lochhead

**English:**
And people understand what a railway does. It moves people and shit this way. And he said, "Great, we've now got a vertical elevator that moves people and shit this way." And if you have a vertical elevator-

**中文翻译:**
人们明白铁路是做什么的：它横向移动人和货物。他说：“太好了，我们现在有了垂直电梯，可以纵向移动人和货物。”如果你有了垂直电梯——

---

### (00:52:11) Lenny

**English:**
Vertical railway.

**中文翻译:**
垂直铁路。

---

### (00:52:12) Christopher Lochhead

**English:**
A vertical railway, thank you. You can have a new category of building. This is no different than anybody today, for example, in the technology space, who's building a new part of the technology stack for AI. So if you've got a new important security layer for AI that enables a new highly secure AI application. From a languaging perspective, if you just use existing languaging, you'll be like Elisha in the beginning where people go, "That's really cool, man. Fucking A, didn't think that was technically possible. Wow. It's like you've broken gravity, dude, incredible. Don't know why we'd ever need this. See you." And he goes, "Wait a minute, wait a minute. What if it was a vertical railway?" "Well, what could we do with a vertical railway?"
(00:53:09):
This is why thinking matters. The way you think about the problem, the way you frame claim and name the problem. One of the core tenets, Lenny, in category design is listen to the words. Listen to the words. And when you listen to the words, you will hear things that you don't normally. And so he created new languaging, what in category design is called a point of view, to frame, claim and name a problem, which is, how do I move up and down versus across land? And in so doing the aperture of people's minds created what you could think of as new mental scaffolding for a whole new kind of innovation. And thanks to Elisha Otis, we have tall buildings.

**中文翻译:**
垂直铁路，谢谢纠正。你可以拥有一种新品类的建筑。这与今天科技领域的人没有区别，比如有人在为 AI 构建新的技术栈。如果你有一个新的 AI 安全层，可以实现高度安全的 AI 应用。从语言化的角度来看，如果你只使用现有的语言，你就会像最初的奥的斯一样，人们会说：“那真的很酷，伙计。真他妈牛，没想到技术上能实现。哇，你就像打破了重力，太不可思议了。但我不知道为什么需要这玩意儿。再见。”然后他说：“等一下，等一下。如果它是一条‘垂直铁路’呢？”“哦，那我们能用垂直铁路做什么？”
(00:53:09):
这就是为什么思考很重要。你思考问题的方式，你定义、占领并命名问题的方式。莱尼，品类设计的核心原则之一是：倾听词语。倾听词语。当你倾听词语时，你会听到平时听不到的东西。于是他创造了新的语言，即品类设计中所说的“观点”（POV），来定义、占领并命名一个问题：我如何上下移动，而不是在地面横向移动？通过这样做，人们思维的孔径被打开了，为一种全新的创新创造了新的“心理支架”。多亏了伊莱沙·奥的斯，我们才有了高楼大厦。

---

### (00:54:01) Lenny

**English:**
I really like this idea of languaging. Are there any other examples come to mind, awesome examples of languaging in action that worked out?

**中文翻译:**
我非常喜欢“语言化”这个想法。还有其他成功的语言化案例吗？

---

### (00:54:07) Christopher Lochhead

**English:**
I got a bazillion of them. Another one of my favorites. When Starbucks first starts a coffee is 10 cents. You sit there and you go, "We can't make money at 10 cents." That doesn't make sense, right? Unit economics don't work for what we're trying to get done. If the ASP in the industry is 10 cents, we want to have an ASP of three bucks. Fuck. Well, here's the aha. It's very hard to charge three bucks for a thing that everybody currently pays a quarter for, if you call it the same thing.
(00:54:50):
So they create new languaging, they teach, they literally teach consumers new language. That's why you and I walk into Starbucks and say, "I'd like a double grande latte, please." 25 years ago, that was not languaging that you and I used. And they use it as a mechanism for radical differentiation and radical value/price differentiation. And they made up the fucking word. It sounds kind of Italian, vente. But the truth is, by the way, it's a milkshake, but that's a whole other conversation. They're the number one milk seller in the country. They're a milk company, not a coffee company. But that's, again, a whole other conversation. The point being, if you want to charge three bucks for something that heretofore has been 10 cents or a quarter, change the language. And you know it's Starbucks language. Where I live, there's a shit ton of new hipster independent coffee shop type places. Where they paint the Mona Lisa in your latte before-
(00:56:00):
... where they paint the Mona Lisa in your latte before they give it to you and all that shit. If you walk into one of those hipster places and ask for a double grande latte, the super hipster gal or guy behind the counter with the nose ring and shit is going to give you a bit of a grizzle, because you are using Starbucks languaging in their location, and that's the other breakthrough. This is really important in the technology industry, the company that creates the languaging for the category wins.
(00:56:39):
Oh, you see that today, OpenAI. Not that long ago you did not hear the term large language model. Correct?

**中文翻译:**
我有无数个案例。另一个我最喜欢的：星巴克刚开始时，一杯咖啡卖 10 美分。你坐在那想：“10 美分我们赚不到钱。”这不合理，对吧？单位经济效益（Unit Economics）无法支撑我们的目标。如果行业平均售价（ASP）是 10 美分，而我们想要 3 美元。天哪。关键点来了：如果一个东西大家平时都只付 25 美分，而你还叫它同样的名字，你很难收 3 美元。
(00:54:50):
所以他们创造了新的语言，他们教——字面意义上的教——消费者新语言。这就是为什么你我走进星巴克会说：“请给我一杯双份大杯拿铁（Double Grande Latte）。”25 年前，这可不是你我会用的语言。他们利用这一点作为激进差异化和激进价值/价格差异化的机制。他们还编造了那个词，听起来像意大利语的 Venti。但事实是，顺便说一下，那其实是奶昔，但那是另一个话题了。他们是全国最大的牛奶销售商，他们是一家牛奶公司，不是咖啡公司。但再说一次，那是另一个话题。重点是：如果你想为一个以前卖 10 美分或 25 美分的东西收 3 美元，那就改变语言。而且你知道那是星巴克的语言。在我住的地方，有很多时髦的独立咖啡店，他们在拿铁上给你画个蒙娜丽莎。
(00:56:00):
如果你走进那些时髦的小店，点一杯“双份大杯拿铁”，柜台后面那个戴着鼻环的时髦店员会给你个白眼，因为你在他们的地盘使用了星巴克的语言。这就是另一个突破点。这在科技行业非常重要：谁创造了品类的语言，谁就赢了。
(00:56:39):
哦，看看今天的 OpenAI。不久前你还没听过“大语言模型”（LLM）这个词，对吧？

---

### (00:56:51) Lenny

**English:**
Correct.

**中文翻译:**
没错。

---

### (00:56:52) Christopher Lochhead

**English:**
That was not a term we were talking about.

**中文翻译:**
那不是我们当时讨论的词。

---

### (00:56:53) Lenny

**English:**
That's right.

**中文翻译:**
是的。

---

### (00:56:56) Christopher Lochhead

**English:**
And today the entire industry is talking about LLMs. Here's another thing that they created, training data. Well, those of us who've been around for a long time, we understand what data is. We know what a database is, we know what data in motion is, we know what data at rest is. We know what structured data is, we know what unstructured data is, et cetera, et cetera, et cetera.
(00:57:19):
I'm not a data expert by any stretch, but I've been in the industry for 37 years, I know some about shit data. We'd never heard the term training data, and I'm still frankly looking for a breakthrough in languaging to describe it to people, because I think when most people realize the difference between data/content and training data, there's a massive breakthrough that can occur there. The languaging is still not sufficient, but we're getting there.
(00:57:53):
New languaging creates new thinking, and a demarcation point in language creates a demarcation point in thinking, which can create a demarcation point in perceived value, and she, who changes and or creates net new value perceptions wins.

**中文翻译:**
而今天整个行业都在谈论 LLM。他们还创造了另一个词：“训练数据”（Training Data）。我们这些在圈子里混了很久的人，明白什么是数据。我们知道数据库，知道动态数据、静态数据、结构化数据、非结构化数据等等。
(00:57:19):
我绝不是数据专家，但我入行 37 年了，我对数据还是略知一二的。我们以前从未听过“训练数据”这个词。坦白说，我仍在寻找一种语言上的突破来向人们描述它，因为我认为当大多数人意识到“数据/内容”与“训练数据”之间的区别时，会产生巨大的突破。目前的语言化还不够充分，但我们正在接近。
(00:57:53):
新语言创造新思维，语言的分水岭创造了思维的分水岭，进而创造了感知价值的分水岭。谁改变或创造了纯新增的价值感知，谁就赢了。

---

### (00:58:19) Advertisement (Round)

**English:**
This episode is brought to you by Round. Round is the private network built by tech leaders for tech leaders. Round combines the best of coaching, learning, and authentic relationships to help you identify where you want to go and accelerate your path to get there, which is why their wait list tops thousands of tech execs. Round is on a mission to shape the future of technology and its impact on society. Leading in tech is uniquely challenging, and doing it well is easiest when surrounded by leaders who understand your day-to-day experiences. When we're meeting and building relationships with the right people, we're more likely to learn, find new opportunities, be dynamic in our thinking and achieve our goals. Building and managing your network doesn't have to feel like networking. Join Round to surround yourself with leaders from tech's most innovative companies, build relationships, be inspired, take action. Visit round.tech/apply and use promo code Lenny to skip the wait list. That's round.tech/apply.

**中文翻译:**
本期节目由 Round 赞助。Round 是由科技领袖为科技领袖建立的私人网络。Round 结合了顶尖的教练指导、学习和真实的社交关系，帮助您确定目标并加速实现路径，这就是为什么他们的候补名单上有数千名科技高管。Round 的使命是塑造科技的未来及其对社会的影响。在科技领域领导极具挑战性，当身边都是理解你日常经历的领导者时，你会做得更轻松。当我们与合适的人建立联系时，我们更有可能学习、发现新机会、保持思维活跃并实现目标。建立和管理你的网络不一定非得像在“搞社交”。加入 Round，与来自科技界最具创新精神公司的领导者为伍，建立关系，获得启发，采取行动。访问 round.tech/apply 并使用优惠码 Lenny 即可跳过候补名单。

---

### (00:59:20) Lenny

**English:**
I think you've made a very compelling case for why people should design a new category. To give people one more tactical tool for coming up with and figuring out the category they want to go after and framing it and even naming it, you mentioned this idea of having a point of view. Maybe that's the best way to approach this question, or maybe there's another framework of just how can people best think through and spend time thinking about what this new category they should be creating ends up being?

**中文翻译:**
我想你已经非常有说服力地解释了为什么人们应该设计一个新品类。为了给人们提供一个更具战术性的工具，来构思和确定他们想要追求的品类，并对其进行定义和命名，你提到了“拥有一个观点”（Point of View）的想法。这也许是探讨这个问题的最佳方式，或者是否还有其他框架，能让人们更好地思考并花时间去琢磨他们应该创建的新品类到底是什么？

---

### (00:59:51) Christopher Lochhead

**English:**
Great question, Lenny. Two things, at least. First, spend more time on the problem than the solution. There's a very early stage, security startup I'm working with right now in the AI space that's doing absolutely mind-boggling things, and the founders have incredible backgrounds with large transaction systems and deep security, just an incredible company.
(01:00:21):
I had a call yesterday with the founder and some folks on the product team just getting an update on where they're at and this and that and the other, and we're sort of starting to want to talk to people externally. We've raised a seed round, VCs are coming, they're very ... Anyway, we're sort of slowly starting to want to come into the world and begin to have a conversation.
(01:00:46):
The founder CEO sends me a text yesterday and says, "I'd like you to, if you're open to it, have a call with so-and-so. He's a very important person, knows a lot about our space, blah blah. Known him for a long time," dah, dah, dah, dah, dah. Great. I said, "It sounds wonderful, but why? What's the purpose of my conversation with so-and-so?" The founder literally said to me, "I would love it if you would be willing to invest some time in listening to some of our customers to hear from their perspective what the problem is and what the solution could be, not just from me and our team."
(01:01:27):
That is a founder who's obsessed with the problem. That's the first piece. The second piece of advice I'll give you, I mentioned Mike Maples, he's got a very powerful way of framing this. He calls it backcasting as distinct from forecasting. You're nodding your head, you're familiar with this.

**中文翻译:**
好问题，莱尼。至少有两点。第一，花更多时间在“问题”上，而不是“解决方案”上。我目前正在与一家 AI 领域的早期安全初创公司合作，他们正在做一些绝对令人惊叹的事情。创始人拥有大型交易系统和深度安全的背景，这是一家不可思议的公司。
(01:00:21):
我昨天和创始人以及产品团队的一些人通了电话，了解一下进度。我们已经筹集了种子轮，风投们都来了。总之，我们正慢慢准备向外界发声，开始对话。
(01:00:46):
创始人兼 CEO 昨天给我发短信说：“如果你愿意，我想请你和某某通个电话。他是个非常重要的人物，对我们的领域非常了解，认识很久了等等。”我说：“听起来不错，但为什么？我和他谈话的目的是什么？”创始人直接对我说：“我希望你能花点时间听听我们的一些客户是怎么说的，从他们的角度听听问题是什么，解决方案可能是什么，而不仅仅是听我和我们团队的说法。”
(01:01:27):
这就是一个痴迷于问题的创始人。这是第一点。我要给你的第二条建议是，我提到过迈克·梅普尔斯（Mike Maples），他有一种非常强大的定义方式。他称之为“逆向预测”（Backcasting），以区别于“预测”（Forecasting）。你在点头，看来你很熟悉。

---

### (01:01:54) Lenny

**English:**
Yeah, I've read this in length in the show notes, it's amazing.

**中文翻译:**
是的，我在节目笔记里详细读过，非常棒。

---

### (01:01:56) Christopher Lochhead

**English:**
Yeah. Here's the idea. What most people do is you and I are entrepreneurs, we have this idea for a product, this problem we can solve. We think we're going to be bazillionaires, we think we're going to help a lot of people, we think we're going to have a lot of fun, and so we have at it. And whether we realize it or not, the mental scaffolding we use goes like this: Lenny and Christopher are sitting here now, we have these big dreams. We think, let's say, five years out into the future, "What do we want to do? Oh [inaudible 01:02:32]. Why don't we go through all the dreams? Great." Then we ask ourselves, most of this is subconscious and then it shows up in business plans and other things, "What do we need to do to get from here to there?" Have you ever done any backcountry hiking, Lenny?

**中文翻译:**
是的。核心思想是这样的：大多数人（比如你和我作为创业者）有一个产品点子，一个我们可以解决的问题。我们觉得自己会成为亿万富翁，会帮助很多人，会很有趣，于是我们就开始干了。无论我们是否意识到，我们使用的心理支架是这样的：莱尼和克里斯托弗现在坐在这里，我们有远大的梦想。我们想，假设五年后，“我们想做什么？哦[听不清]。让我们过一遍所有的梦想。太棒了。”然后我们问自己（大部分是潜意识的，然后体现在商业计划书里）：“我们需要做什么才能从‘现在’到达‘那里’？”莱尼，你做过野外徒步吗？

---

### (01:02:52) Lenny

**English:**
Yeah, I have.

**中文翻译:**
是的，做过。

---

### (01:03:00) Christopher Lochhead

**English:**
And we'd know where we were coming out, right?

**中文翻译:**
我们会知道从哪儿出来，对吧？

---

### (01:03:02) Lenny

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### (01:03:04) Christopher Lochhead

**English:**
And we'd have way points along the way, yes?

**中文翻译:**
沿途会有路标，对吧？

---

### (01:03:06) Lenny

**English:**
Yeah, probably.

**中文翻译:**
是的，大概会有。

---

### (01:03:09) Christopher Lochhead

**English:**
Because we knew we were going to be out four days or six days or whatever, we would try to plan our food appropriately.

**中文翻译:**
因为我们知道要在外面待四天或六天，我们会相应地计划食物。

---

### (01:03:14) Lenny

**English:**
Absolutely.

**中文翻译:**
绝对的。

---

### (01:03:14) Christopher Lochhead

**English:**
And the whole plan would be predicated on "We're going to start here and we're going to end here," and what do we need to do to get from where we start to where we end, yes?

**中文翻译:**
整个计划都基于“我们要从这里开始，到那里结束”，以及“我们需要做什么才能从起点到达终点”，对吧？

---

### (01:03:25) Lenny

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### (01:03:26) Christopher Lochhead

**English:**
Now, when going on a backcountry hike, that's a very smart fucking thing to do, because if you've ever been on a backcountry hike and you're four days in only to realize you don't have enough food, that's an experience you don't want to recreate. Okay, turns out that while that's highly effective for a hike, it is intergalactic disaster for a startup. Here's why. Your point of reference is everything. Thinking about thinking is the most important kind of thinking.
(01:03:59):
When we do it that way, mentally we are standing in the present, which is an extension of the past, and we're saying, "What do we need to do to go from this present to the different future we want, and what are the obstacles in the way?" Here's the mental scaffolding. That's forecasting, here's backcasting.
(01:04:26):
We do an exercise, we abandon everything. In category design you get taught to what's called reject the premise, so I reject everything about the way that it is, all of it. You and I now envision this future five years out and everything's gone incredibly, it's exceeded our expectations. We make that true in our minds. We write out, we brainstorm out "What's it going to be like? What kind of technology are we selling? What are we doing for customers? How big's our company? How many people will hire?" Da, da, da, da, da, da, da, da. Then we say, "Okay, standing in that future, five years out, looking back to the present, what did we do to make this different future happen?" That's category design. That's how you unshackle yourself from the past. See, one of the biggest disservices in our industry is this word disrupt. "Oh, [inaudible 01:05:26] we're going to go disrupt the engineering industry." Nah. Well, if you're disrupting something, by definition, your reference point is the something. And when your reference point is an existing thing, your reference point is the past. If we want to be able to think in unconstrained ways about a radically different future, the more we drag the past forward, the worse off we are. What reject the premise teaches us is let's forget everything we know and start fresh. My friend, a legendary designer, John Bielenberg, does this course on innovation and design with kids in university. He does this multi-week exercise and the objective of the exercise, Lenny, is design a bicycle. That's the objective. And there's only one design point. It cannot be rideable.
(01:06:25):
And the reason John makes him do that, his philosophy, he calls it thinking wrong. That's his version, if you will, of reject the premise. The reason for it is when you take away the premise, it must be rideable, you open up the aperture for legendary new thinking, radically different possibilities, radically different futures. This is the mistake that many, many entrepreneurs make, is whether they realize it or not, what they're doing is incremental better and they're fighting for market share, fighting for existing demand with something that's incrementally better. And the reality is that's why most entrepreneurs fail. Now, you could fail doing it exponentially different, it sounds medically insane to say "What you want is a zero billion dollars market." However, as crazy as it sounds, it's the only thing that leads to meaningful success. And the proof is in the data.

**中文翻译:**
现在，对于野外徒步来说，这他妈的是个非常聪明的做法，因为如果你在徒步四天后才发现食物不够，那种体验你绝不想再来一次。好，事实证明，虽然这对徒步非常有效，但对初创公司来说却是“星际级”的灾难。原因如下：你的参考点决定了一切。思考“思考本身”是最重要的一种思考。
(01:03:59):
当我们用那种方式思考时，我们在心理上站在“现在”（它是过去的延伸），然后问：“我们需要做什么才能从这个‘现在’到达我们想要的‘不同未来’？障碍是什么？”这就是心理支架。那是“预测”，而下面是“逆向预测”。
(01:04:26):
我们做一个练习，抛弃一切。在品类设计中，你会学到所谓的“拒绝前提”（Reject the Premise）。我拒绝关于现状的一切，全部拒绝。你和我现在构思五年后的未来，一切都进展得不可思议，超出了我们的预期。我们在脑海中将其变为现实。我们写下来，头脑风暴：“那会是什么样子？我们在卖什么样的技术？我们在为客户做什么？公司多大？雇了多少人？”等等。然后我们说：“好，站在五年后的未来，回望现在，我们做了什么才让这个不同的未来发生？”这就是品类设计。这就是你如何摆脱过去的枷锁。看，我们行业最大的误导之一就是“颠覆”（Disrupt）这个词。“哦，我们要去颠覆工程行业。”不。如果你在颠覆某样东西，根据定义，你的参考点就是那个东西。而当你的参考点是一个现有的东西时，你的参考点就是过去。如果我们想要不受约束地思考一个彻底不同的未来，我们把过去拖得越久，情况就越糟。“拒绝前提”教给我们的是：忘掉我们所知道的一切，重新开始。我的朋友、传奇设计师约翰·比伦伯格（John Bielenberg）在大学里给孩子们开了一门关于创新和设计的课。他做了一个为期数周的练习，目标是：设计一辆自行车。这就是目标。但只有一个设计要点：它必须是“不可骑行”的。
(01:06:25):
约翰之所以让他们这么做，是因为他的哲学——他称之为“错误思考”（Thinking Wrong）。如果你愿意，这就是他版本的“拒绝前提”。原因在于，当你拿掉“必须可骑行”这个前提时，你就打开了通往传奇新思维、彻底不同的可能性和彻底不同未来的孔径。这就是许多创业者犯的错误：无论他们是否意识到，他们所做的只是“渐进式的更好”，他们在用渐进式更好的东西争夺市场份额和现有需求。现实情况是，这就是大多数创业者失败的原因。当然，做“指数级的不同”也可能失败，说“你想要的是一个零亿美金的市场”听起来像精神错乱。然而，尽管听起来很疯狂，但这却是通往重大成功的唯一途径。数据证明了这一点。

---

### (01:07:34) Lenny

**English:**
Yeah. You talk about this in your writing, that on the surface it feels very hard and expensive to design a category, build a category, convince everyone this is a new problem. But your point is there's no other option really if you want to build a large business. Is that right?

**中文翻译:**
是的。你在文章中提到过，表面上看，设计一个品类、建立一个品类、说服所有人这是一个新问题，似乎非常困难且昂贵。但你的观点是，如果你想建立一家大型企业，实际上别无选择。对吗？

---

### (01:07:49) Christopher Lochhead

**English:**
Correct. And the other thing is people say, "Oh, it's really expensive and it takes an amount of time." As compared to what? You've lived a lot of your life in the product world, yes? As have I. Well, if you ask smart VCs, if you ask Brian Roberts at Venrock, the number one healthcare tech investor in the world, I believe he says it's eight to 10 years for a product to really have some maturity and be really stable. And I don't know whether he's right or not, but he's a super smart guy. We know how long does it take to create a legendary culture, how long does it take to get a legendary innovative business model to really hum. "Ah, it's mainly hard." Well, so is building a product, so is building a company, so is raising VC, so is doing sales, so is doing marketing, so is doing HR. If you want to be easy, go work at the fucking DMV. That's point A.
(01:08:53):
Point B is the reality, Lenny, when you look at it, the vast majority of innovation comes from startups. People say, "Only big companies can do this." Listen, my collaborator partner Eddie Yoon, is the Obiwan Kenobi of category design in the Global 2000 Arena and particularly on the consumer side. And he will tell you that most of these major companies... And he's worked for, you name a big food company, you name a big beverage company, he's worked for many of them. They fail miserably. The reality is six people with a small investment from a rich uncle can stand something up that has the potential to be worth $3 trillion dollars. That's what Apple is.
(01:09:52):
And I sat there with Don Valentine and asked him about why he signed the check to Steve and Steve, and he said it was the stupidest use case he ever saw. The use case was a stay-at-home mom, keeping track of her recipes on the Apple personal computer. This is the stupidest use case ever. However, Don could see the potential in the category and in the guy's willingness to go get after it. And so for a VC, if you're going to raise money, the VCs who invest in early stage mass potential companies are the ones who see your different future.

**中文翻译:**
没错。另一件事是人们会说：“哦，这真的很贵，而且需要很长时间。”那要看跟什么比。你职业生涯的大部分时间都在产品界，对吧？我也一样。如果你去问聪明的风投，比如 Venrock 的布莱恩·罗伯茨（Brian Roberts），他是全球头号医疗科技投资人，我相信他说过，一个产品要真正成熟并稳定需要 8 到 10 年。我不知道他是否正确，但他是个超级聪明的人。我们知道建立传奇文化需要多久，让传奇的创新商业模式真正运转起来需要多久。“啊，这太难了。”好吧，开发产品很难，建立公司很难，融资很难，做销售、营销、HR 都很难。如果你想轻松，那就去他妈的车管所（DMV）上班。这是第一点。
(01:08:53):
第二点是现实，莱尼，当你观察时，绝大多数创新都来自初创公司。人们说：“只有大公司才能做这个。”听着，我的合作伙伴艾迪·尹（Eddie Yoon）是全球 2000 强领域（尤其是消费端）品类设计的“奥比旺·肯诺比”。他会告诉你，大多数大公司——他为你能叫得出名字的大型食品、饮料公司都工作过——都失败得很惨。现实情况是，六个人拿着有钱叔叔的一点小钱，就能建立起一个有潜力价值 3 万亿美元的东西。那就是苹果。
(01:09:52):
我曾和唐·瓦伦丁（Don Valentine，红杉资本创始人）坐在一起，问他为什么要给两个史蒂夫（乔布斯和沃兹尼亚克）签支票，他说那是他见过的最愚蠢的使用场景：一个全职妈妈在苹果个人电脑上记录她的食谱。这是史上最蠢的场景。然而，唐能看到这个品类的潜力，以及这两个人去追求它的决心。所以对于风投来说，如果你要融资，那些投资早期、具有巨大潜力公司的风投，正是那些能看到你所描述的“不同未来”的人。

---

### (01:10:40) Lenny

**English:**
Along those lines, I had this note that you had this quote around product market fit and it's this hot take that product market fit is a very dangerous idea. I'd love for you to speak to that, because I think most people are in the opposite camp that it's the only thing that matters. Why do you think it's such a dangerous idea?

**中文翻译:**
顺着这个话题，我记下了你关于“产品市场匹配”（Product Market Fit, PMF）的一段话。这是一个很犀利的观点，即 PMF 是一个非常危险的想法。我很想听听你的看法，因为我想大多数人都站在对立面，认为它是唯一重要的事情。为什么你认为它如此危险？

---

### (01:11:01) Christopher Lochhead

**English:**
There's a bunch of these product myths. Product led growth is another one, but let's go to product market fit. And God bless Mark Andreessen, he's the guy that framed it. And Kevin just wrote a really super thoughtful piece on why it's backwards, and I'm happy to send that to you if you want. Kevin Maney, genius. Here's the aha, again, category design principles. Listen to the words, product, market, fit. Product market fit. Now, let's think, what there is for me to do is find a way to fit my product into a market.
(01:11:48):
Pretty simple way to determine or to distill product market fit. And what product market fit has come to mean is, we're a brew pub, you and I want to start a craft beer place like everybody else on the West Coast, and we're going to make a bunch of samples and shit, and we're going to feed those samples to our friends and to our ideal customer profile that I learned from Lenny. And if enough people amongst my friend group and my ideal customer group say, "That's a yummy IPA, I like it," then we're going to build it. And then if people start buying that IPA, we have, and these are the words people use, "achieved product market fit."
(01:12:43):
Okay, well, Threads achieved product market fit faster than any product in the history of the world. Here's the aha, categories make products not the other way around. What you want is you want to design a market category for your product, not fit your product into a market category. And the problem is, our industry, like many others, but the tech industry, is full of product bigots, because they really, really, really, really, really believe, like they believe in the availability of oxygen, the best product wins. They really believe it. And they believe what marketing's job is, "Could you put a demo on our website and get a demo? Can we get a viral video that's a demo? Because once people see how much better, faster, cheaper, smaller, bigger, whatever our thing is, they're going to buy it," and they don't. What they buy is a new insight around a problem/opportunity that requires a different solution. That's what they buy. Here's another simple example. This is the one I hear right now a lot, "What we need now the story, we need a story brand. The number one thing you can do in marketing as a startup founder is to share your startup founder journey. Share your journey." This is all the shit we're hearing. We've been hearing this for a while. Well, guess what? No one gives a fuck about your journey. They really don't. You know what they care about? Themselves. Their problems, their needs, their opportunities. For our book, Snow Leopard, we did the first ever comprehensive data science research ever done using Nielsen data to study nonfiction books. And we know that because what Nielsen told us, and we had to sign an NDA that would choke a horse in terms of what we can say and can't say about the data. But one of the things we wanted to understand is what categories of business books sold and which categories didn't and why. We can get into all that if you want, but here's the aha. Guess what the number one category of business books, nonfiction books is by a mile.

**中文翻译:**
有很多关于产品的迷思。“产品驱动增长”（PLG）是另一个，但让我们先谈 PMF。上帝保佑马克·安德森（Marc Andreessen），他是定义这个词的人。凯文最近写了一篇非常有深度的文章，解释了为什么这个概念是本末倒置的，如果你想要我可以发给你。凯文·梅尼是个天才。关键点来了，再次回到品类设计原则：倾听词语——产品（Product）、市场（Market）、匹配（Fit）。产品市场匹配。现在，让我们思考一下：我要做的是找到一种方法，把我的产品“塞进”一个市场里。
(01:11:48):
这是一个非常简单的定义 PMF 的方式。PMF 现在的含义变成了：我们开了一家小酒馆，你我想像西海岸的其他所有人一样开一家精酿啤酒厂，我们会做一堆样品，把这些样品给我们的朋友和从莱尼那里学到的“理想客户画像”（ICP）喝。如果我的朋友圈和理想客户群中有足够多的人说：“这 IPA 很好喝，我喜欢”，那我们就开始酿。如果人们开始买这种 IPA，我们就（用大家的话说）“实现了产品市场匹配”。
(01:12:43):
好，Threads 实现 PMF 的速度比历史上任何产品都快。关键点来了：是品类成就了产品，而不是反过来。你想要的是为你的产品“设计”一个市场品类，而不是把你的产品“塞进”一个市场品类。问题在于，我们的行业（尤其是科技行业）充满了“产品偏执狂”，因为他们真的、真的、真的相信——就像相信氧气存在一样——最好的产品会赢。他们深信不疑。他们认为营销的工作就是：“能不能在网站上放个演示？能不能拍个病毒式的演示视频？因为一旦人们看到我们的东西有多好、多快、多便宜、多小、多大，他们就会买。”但人们不买。人们买的是针对某个问题/机会的新见解，而这个见解需要一个不同的解决方案。这才是他们买的东西。再举个简单的例子，这是我现在经常听到的：“我们现在需要故事，我们需要一个故事品牌。作为初创公司创始人，你在营销中能做的头等大事就是分享你的创业历程。分享你的旅程。”这就是我们听到的废话。我们听了很久了。但猜猜怎么着？没人他妈的关心你的旅程。真的不关心。你知道他们关心什么吗？他们自己。他们的问题、他们的需求、他们的机会。为了写《雪豹》（Snow Leopard）这本书，我们利用尼尔森（Nielsen）的数据对非虚构类书籍进行了有史以来第一次全面的数据科学研究。尼尔森告诉我们的数据让我们签了一份厚得能噎死马的保密协议。但我们想了解的是，哪些品类的商业书畅销，哪些不畅销，以及为什么。如果你想听我们可以深入聊，但关键点来了：猜猜商业书、非虚构类书籍中排名第一的品类是什么？而且是遥遥领先。

---

### (01:15:13) Lenny

**English:**
Oh my god. Sales? Marketing, marketing-sales. No.

**中文翻译:**
天哪。销售？营销？营销加销售？不对。

---

### (01:15:19) Christopher Lochhead

**English:**
Personal growth.

**中文翻译:**
个人成长。

---

### (01:15:20) Lenny

**English:**
Okay, that makes sense. Self-help.

**中文翻译:**
好吧，这说得通。成功学/自助手册。

---

### (01:15:22) Christopher Lochhead

**English:**
Self-help. And number two, personal finance. Biographies are way down on the list. The point being, no one cares about our product. No one cares that it's 25 mega flips faster, cheaper, whatever, they don't care. You know what they care about? Them, their needs, their wants, their problems. And categories are about customers and their wants, needs, problems and opportunities. Branding and marketing is about our product. And the greatest innovators in the world don't stop at innovating a product or technology. They design a new innovative market category where they standalone.

**中文翻译:**
自助手册。第二名是个人理财。传记类排得很后。重点是：没人关心我们的产品。没人关心它是不是快了 25 倍、便宜了多少，他们不在乎。你知道他们在乎什么吗？他们自己，他们的需求、欲望和问题。品类关乎客户及其欲望、需求、问题和机会。品牌和营销关乎我们的产品。世界上最伟大的创新者不会止步于创新产品或技术，他们会设计一个全新的、创新的市场品类，让自己独树一帜。

---

### (01:16:12) Lenny

**English:**
We're definitely going along, which I expected. And we've actually gone through most of the questions I had, but I have just a few more to close out the conversation. One is positioning. That's something you hear a lot about. How do you think about positioning versus categorying? Are they essentially the same thing? Is positioning just a way to phrase and describe your category? How should people think about that?

**中文翻译:**
我们聊得很深入，这在我的预料之中。实际上我已经问完了大部分问题，但在结束对话前我还有几个问题。一个是“定位”（Positioning）。这是大家经常听到的词。你如何看待定位与品类化（Categorying）的关系？它们本质上是一回事吗？定位只是表达和描述品类的一种方式吗？人们应该如何思考这个问题？

---

### (01:16:32) Christopher Lochhead

**English:**
What positioning today has become is essentially how do I tell a story about my shit in a unique way, in a compelling way? That's really what people mean when they say positioning. The parts they never stop to consider, again, listen to the words positioning as it relates to what? Because you, again, listen to the words and fucking think, "You position against competitors." How do we position against the competitors? That's a phrase people use. The question is, what are you positioning against? And the answer to that question almost all of the time is competition. If you're doing positioning in that context, you just decided you're fighting for 24% of the demand designed by somebody else. And we think in the tech space where one company earns two thirds of the economics, if that's your starting point, you fuck yourself from the start. To put it simply, positioning in the modern context is for losers. That is to say people who are fighting over the 24%. That's positioning.

**中文翻译:**
今天的“定位”本质上已经变成了：我如何以一种独特、引人入胜的方式讲述关于我产品的破事？这就是人们说定位时的真实含义。他们从未停下来思考的部分是——再次倾听词语——定位是相对于什么的？因为，再次倾听词语并他妈的思考一下：“你是相对于竞争对手进行定位。”“我们如何针对竞争对手进行定位？”这是人们常用的短语。问题是，你在针对什么定位？答案几乎总是“竞争”。如果你在那种语境下做定位，你就已经决定了去争夺由别人设计的、剩下的 24% 的需求。我们认为在科技领域，一家公司赚取了三分之二的收益，如果那是你的起点，你从一开始就把自己搞砸了。简单来说，在现代语境下，定位是给失败者准备的。也就是说，是给那些争夺 24% 份额的人准备的。这就是定位。

---

### (01:18:15) Lenny

**English:**
I love it. Getting spicy over here.

**中文翻译:**
我喜欢这个观点，火药味越来越浓了。

---

### (01:18:17) Christopher Lochhead

**English:**
Well, it's factually correct. People go, "Oh, [inaudible 01:18:21]." Okay, so you mean to tell me that in tech one company doesn't take two thirds of the economics? Okay, believe that. And you can believe gravity doesn't exist. It does, but you can believe that Bigfoots are installing misters on 5G towers to make us all sick, if you want. You can believe anything you want, it doesn't make it true. What's true is one company wins and everybody else gets fucked. That's what's true. Look at any space you want. You want to go back to your list? We can go through the list. Positioning has become sort of category design for the cowards. It's like, "Well, I know that we could really be as radical as to create our own space, so let's just see if we can carve off our little niche over here." Okay, great.

**中文翻译:**
嗯，这是事实。人们会说：“哦，[听不清]。”好吧，所以你是想告诉我，在科技界不是一家公司拿走三分之二的收益吗？行，你尽管信吧。你也可以相信重力不存在。它确实存在，但如果你愿意，你也可以相信大脚怪正在 5G 塔上安装喷雾器让我们生病。你可以相信任何你想相信的东西，但这并不代表它是真的。事实是：一家公司赢，其他人全完蛋。这就是事实。看看你想要的任何领域。想回到你的列表吗？我们可以过一遍。定位已经变成了某种“胆小鬼的品类设计”。就像是说：“好吧，我知道我们可以激进到创造自己的空间，但让我们看看能不能在这里切出一块我们的小细分市场。”行吧，祝你好运。

---

### (01:19:20) Lenny

**English:**
A big part of positioning, just to expand on this a little bit, is differentiation. Differentiating yourself. People always talk about the importance of differentiation. Do you see that as the same potential pitfall, or how do you think about differentiation?

**中文翻译:**
定位的一个重要部分（稍微展开一下）是差异化。让自己与众不同。人们总是在谈论差异化的重要性。你认为这也是一个潜在的陷阱吗？或者你如何看待差异化？

---

### (01:19:34) Christopher Lochhead

**English:**
Okay, this is really, really powerful. In category design, we don't compete, period, full stop at the brand to brand or product to product level. Category designers do compete, but not against a product, not against a company, not against a brand. Category designers compete against the status quo. Let me be specific. There's a category called cycling. You look like you might be a biker, Lenny, are you?

**中文翻译:**
好，这非常非常关键。在品类设计中，我们不竞争，句号，到此为止——不在品牌对品牌或产品对产品的层面上竞争。品类设计者确实竞争，但不是针对产品、公司或品牌。品类设计者竞争的对象是“现状”（Status Quo）。让我具体说明一下。有一个品类叫“骑行”。莱尼，你看起来像个骑行爱好者，你是吗？

---

### (01:20:09) Lenny

**English:**
Very casually, mostly an e-bike.

**中文翻译:**
很业余，主要是骑电助力自行车。

---

### (01:20:13) Christopher Lochhead

**English:**
Those are really fun.

**中文翻译:**
那玩意儿确实很有趣。

---

### (01:20:14) Lenny

**English:**
They're so fun. Mountain bike. Yeah.

**中文翻译:**
太好玩了。山地车，是的。

---

### (01:20:16) Christopher Lochhead

**English:**
But you've been on a mountain bike. You've been on a road bike, you've gone out with friends, done this, right?

**中文翻译:**
但你骑过山地车，骑过公路车，和朋友一起出去骑过，对吧？

---

### (01:20:20) Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### (01:20:21) Christopher Lochhead

**English:**
Anybody who bikes on any kind of regular basis has been in an accident. And if you bike on a real regular basis, you've been in an accident with a vehicle that was not caused by you. That's true for every person I know that rides a bike on any regular basis, myself included. All of a sudden a new category shows up, and that new category is called indoor biking classes. And the category designer is a company called spinning.
(01:20:53):
And they say, "Hey, biking's great. It's an incredible source of exercise, but you don't want to get killed doing it, so come take a class." And what they're doing when they do that, they're competing category to category, not brand or product to brand. And that's a strategy that's called damming the demand. What does a dam do? There's a bunch of water running in the direction, a dam takes that water, stops it and moves it, does something to it. Interrupts it and changes it. Here's what spinning does. They say, "Why risk your life on a bike when you can take a wonderful class and not have to worry about it and get your exercise?" What dam the demand, Lenny, is you thought you wanted this, but what you really need is that.
(01:21:52):
Then what happens? The next iteration in that space comes from Peloton. Again, when Peloton launches, they don't say, "Hey, our bikes are better than spinning bikes. Our bikes are 12 mega flips, faster, cheaper." They don't do any of that shit. They don't shit on spinning, they don't attack spinning, they don't attack road biking, they don't do any of that stuff. They say, "Why drive to the gym when you could do it at home?" They dam the demand for spinning, they don't compete against it. And they reframe the problem called "How do I get a great workout in a group environment without getting killed?" And they achieve that massive success.
(01:22:41):
And I can give you many other examples. The mistake is competing directly product to product. The enemy is the status quo. That is to say the way it is now. If you go back to Lomi, the enemy, the way it is now, the status quo, is a nasty garbage in your kitchen that stinks and smells and gets all over the floor that you have to drag to the green bin and then the squirrels and the fucking raccoons eat it. That's the personal upset. And the environmental one is, we're destroying the planet. No, by the way, rather than destroy the planet, why not create this super awesome compost dirt? In category design, we call that a from to a Frodo. Category designers are leading the world from the way it is to a new and different way. They're not saying, "My carbide ingulator is better than their carbide ingulator."
(01:23:32):
Here's a simple example. This is another reason the word disrupt doesn't work. Les Paul is the innovator of the electric guitar. Today most guitar players have an electric guitar and an acoustic guitar. Matter of fact, most guitar players have more than one, very few guitar players, some, but very few said, "Oh, now that the electric guitar is invented, fuck the acoustic guitar." Very, very rare. The net new category called electric...

**中文翻译:**
任何经常骑车的人都出过事故。如果你经常骑，你肯定出过不是由你引起的机动车事故。我认识的每一个经常骑车的人都是这样，包括我自己。突然间，一个新品类出现了，叫“室内骑行课”（Indoor Biking Classes）。品类设计者是一家叫 Spinning 的公司。
(01:20:53):
他们说：“嘿，骑行很棒，是极好的锻炼方式，但你不想在骑行时丢了性命，所以来上课吧。”他们这么做时，是在进行“品类对品类”的竞争，而不是品牌或产品对品牌的竞争。这种策略被称为“拦截需求”（Damming the Demand）。大坝（Dam）是做什么的？有一股水流向某个方向，大坝截住水，改变它的流向。这就是 Spinning 所做的。他们说：“既然你可以上一堂精彩的课，不用担心安全就能锻炼，为什么要冒生命危险去骑车呢？”莱尼，“拦截需求”就是：你以为你想要这个，但你真正需要的是那个。
(01:21:52):
然后发生了什么？该领域的下一次迭代来自 Peloton。同样，当 Peloton 发布时，他们没说：“嘿，我们的动感单车比 Spinning 的好，我们的车快 12 倍、更便宜。”他们没干那种烂事。他们没羞辱 Spinning，没攻击 Spinning，也没攻击公路骑行。他们说：“既然你可以在家练，为什么要开车去健身房？”他们拦截了对 Spinning 的需求，而不是与其竞争。他们重新定义了问题：“我如何在不丢命的情况下，在集体氛围中获得极好的锻炼？”于是他们获得了巨大的成功。
(01:22:41):
我还能举出很多例子。错误在于直接进行产品对产品的竞争。敌人是“现状”，也就是现在的样子。回到 Lomi，敌人（现状）是你厨房里臭气熏天、弄得满地都是、你还得拖到绿色垃圾桶里、然后松鼠和浣熊还会来偷吃的恶心厨余垃圾。这是个人层面的烦恼。环境层面则是：我们在毁灭地球。顺便说一下，与其毁灭地球，为什么不创造这种超级棒的堆肥土呢？在品类设计中，我们称之为“从 A 到 B”（Frodo）。品类设计者正引领世界从现状走向一种全新的、不同的方式。他们不是在说：“我的组件比他们的组件好。”
(01:23:32):
举个简单的例子，这也是为什么“颠覆”这个词行不通的另一个原因。莱斯·保罗（Les Paul）是电吉他的创新者。今天大多数吉他手既有电吉他也有原声吉他。事实上，大多数吉他手不止有一把。很少有吉他手会说：“哦，既然电吉他发明了，去他妈的原声吉他吧。”非常罕见。这个叫“电吉他”的纯新品类……

---

### (01:24:00) Christopher Lochhead

**English:**
So the net new category called electric guitar as opposed to the prior category, acoustic guitar, actually increases the overall guitar TAM (Total Addressable Market). Doesn't disrupt shit. So in that case, you're actually creating net new demand. In the Peloton example, you're both creating that new demand and you're getting your start. And this is where I think a lot of the discussion that you have and a lot of your work, Lenny, around growth, is really powerful, because what's really going on when growth works is effective digital damning of demand. That's what's really going on, when it works.

**中文翻译:**
所以，相对于之前的“原声吉他”品类，这个叫“电吉他”的纯新品类实际上增加了吉他的整体市场规模（TAM）。它什么也没颠覆。在这种情况下，你实际上是在创造纯新增需求。在 Peloton 的例子中，你既创造了新需求，又开启了自己的事业。这就是我认为你所讨论的很多内容，以及莱尼你在增长方面的很多工作非常强大的原因，因为当增长奏效时，其本质就是有效的“数字需求拦截”。当它奏效时，这就是真相。

---

### (01:24:41) Lenny

**English:**
I think somewhere maybe wrote this, "Damn the TAM" is an awesome phrase. If you haven't, you should use that. Damning the TAM, increasing the TAM. So you have a number of books you put out. I'm going to link to all these. Play Bigger, I think, was your first, Niche Down is the other. And your newest book, I believe is your newest book, is the 22 Laws of Category Design. So maybe just as a last question, can you just share a few of these laws, maybe two or three of your favorite laws from the book just to give people a sense of the book?

**中文翻译:**
我想可能有人写过，“拦截市场规模”（Damn the TAM）是个很棒的短语。如果你还没用过，你应该用。拦截 TAM，增加 TAM。你出版了很多书，我会把链接都放上去。《玩大点》（Play Bigger）应该是第一本，《垂直深耕》（Niche Down）是另一本。你最新的书应该是《品类设计的 22 条法则》（The 22 Laws of Category Design）。作为最后一个问题，你能分享其中的几条法则吗？也许是你最喜欢的两三条，让大家对这本书有个概念。

---

### (01:25:09) Christopher Lochhead

**English:**
I think we talked about law number one, which, in a lot of ways, is probably the most important. Another one to think about is something we call the magic triangle, which we've touched on, but maybe not explicitly, which is, in order to build a legendary company, you've got to get product, company, and category right at the right time. And so some people hear the category design discussion and they think it's somehow pejorative to product as if product doesn't matter. The reason for category design is because we love the products. Products fail because they don't get category designed. So I think the aha of the magic triangle is product, company, and category are equal in importance, and so getting that right I think is very powerful.
(01:26:05):
I'm just riffing off the top of my head. I don't have it in front of me. Another example is lightning strikes versus peanut butter. So what most marketers do is they take their marketing budget for the year, they quarterize it, and maybe there's slight variance in the quarters, but essentially it's a similar amount of spend. And they do campaigns. And they do "keep the lights on" and maybe they launch a product and maybe they have a big push around the product. And they're trying to drive the funnel and they're trying to deliver sales or deliver leads, B2B, doesn't matter. And that's what they do. And what they don't realize, Lenny, is that approach, that peanut butter approach, is predicated on almost 100-year-old mental scaffolding and marketing called reach and frequency. And what reach and frequency was about, which was, I want to get my shit in front of the most amount of people the most often possible.
(01:27:07):
And if you listen to a lot of the shysters and hustle porn stars, the Gary VDs, and this is of the world, "You got to release 400 pieces of content today on every platform." All this stupidity. That's just a reswizzle of reach and frequency from over 50 years ago in the new medium. Well, it turns out reach and frequency doesn't work. Because the number of marketing messages we get is massive, they're experts who say we get up to 60,000 a day, whether it's logos on coffee cups or ads on the internet and everything in between. And so it's virtually impossible to stand out in a reach and frequency mode. Now I'm not saying you shouldn't be doing keep the lights on marketing. Of course you need to do keep the lights on marketing. But, here's what the lightning strike model and category design teaches us. I'd rather matter for one week a year than be irrelevant for the rest of the year.
(01:28:07):
And so what we did, candidly Lenny, was we ripped off Hollywood's model for launching movies. We said, "What if you did that as a software company? What if you launched a thing, be it a product or something else, the way Hollywood launches a movie?" And so what a lightning strike is about is getting very, very clear, if you go back to your ICP thing, "Who's our ideal customer? Where is that customer? Where does she hang out?" Ideally, in the digital world first. One of your recent episodes, I was listening to the Growth Hacker Gala, how she went on to Reddit and stuff. That's a well-known strategy and I love that strategy. Go hang out where they are, put something provocative and engaging in front of them, and matter in that moment. So the idea of a lightning strike is, if you are in our target audience for that day or that two days, we are going to be all over you.
(01:29:09):
We're going to be undeniable. And so we put a disproportionate amount of our effort, if we're in B2B, probably one to two lightning strikes a year. If we're in B2C, two to three. One a quarter if you're a really big company. It's hard to pull off one a quarter if you're a smaller company. And much more than that, if not a lightning strike, it starts to blur back into peanut butter. But, that is a very powerful concept. On the execution side for marketers, that's different. The other thing I'd say and probably should have started here, so I'm a three-time public company CMO. I've advised over 50 venture-backed companies in category design and marketing. Guess what I've never seen in a marketing plan ever?

**中文翻译:**
我想我们已经讨论过第一条法则了，在很多方面它可能是最重要的。另一个值得思考的是我们称之为“黄金三角”（Magic Triangle）的概念，我们提到过，但可能没明确说明：为了建立一家传奇公司，你必须在正确的时间把“产品”、“公司”和“品类”都做对。有些人听到品类设计的讨论，会觉得这在某种程度上贬低了产品，好像产品不重要。其实品类设计的原因正是因为我们热爱产品。产品之所以失败，是因为它们没有经过品类设计。所以“黄金三角”的关键在于：产品、公司和品类同等重要，把这三者结合好非常强大。
(01:26:05):
我只是凭记忆在说，书不在手边。另一个例子是“闪电战”（Lightning Strikes）对比“抹花生酱”（Peanut Butter）。大多数营销人员的做法是：拿出一年的营销预算，按季度分配，虽然各季度可能略有差异，但基本上支出金额差不多。他们做活动，做“维持现状”的营销，偶尔发布产品或进行大促。他们试图驱动漏斗，交付销售额或线索（B2B 也是如此）。这就是他们的做法。莱尼，他们没意识到，这种“抹花生酱”式的方法（平铺直叙）是基于近 100 年前的营销心理支架，即“触达与频率”（Reach and Frequency）。触达与频率的核心是：我想尽可能频繁地把我的东西展示在尽可能多的人面前。
(01:27:07):
如果你听那些骗子和成功学明星（比如 Gary Vaynerchuk 之流）的话：“你今天必须在每个平台上发布 400 条内容。”全是这种蠢话。这只是把 50 多年前的“触达与频率”在新媒体上重新包装了一下。事实证明，触达与频率行不通。因为我们收到的营销信息量巨大，有专家说每天高达 6 万条，从咖啡杯上的 Logo 到互联网广告。在触达与频率模式下，脱颖而出几乎是不可能的。我不是说你不该做维持现状的营销，当然需要。但是，品类设计中的“闪电战”模型教给我们的是：我宁愿在一年中重要那么一周，也不愿在剩下的一年里都无足轻重。
(01:28:07):
坦白说，莱尼，我们借鉴了好莱坞发布电影的模式。我们想：“如果一家软件公司也这么做呢？如果像好莱坞发布电影那样发布一个产品或其他东西呢？”所以“闪电战”的核心是：非常清晰地确定（回到你的 ICP 理论）“谁是我们的理想客户？那个客户在哪？她在哪儿出没？”理想情况下，首先是数字世界。在你最近的一集里，我听了增长黑客 Gala 的分享，讲她如何去 Reddit 之类的地方。那是一个著名的策略，我很喜欢。去他们所在的地方，在他们面前放一些挑衅性的、引人入胜的东西，并在那一刻产生影响力。所以闪电战的想法是：如果你在那一两天属于我们的目标受众，我们将无处不在。
(01:29:09):
我们将是不可忽视的。因此，我们会投入不成比例的精力。如果是 B2B，一年大概做一到两次闪电战；如果是 B2C，两到三次。如果你是大公司，每季度一次。小公司很难做到每季度一次。如果频率再高，就不叫闪电战了，又会变回“抹花生酱”。这是一个非常强大的概念。在营销执行端，这很不一样。另一件事我可能应该先说：我曾三次担任上市公司的 CMO，为 50 多家风投支持的公司提供过品类设计和营销咨询。猜猜我从未在营销计划中见过什么？

---

### (01:29:59) Lenny

**English:**
What's that?

**中文翻译:**
是什么？

---

### (01:30:00) Christopher Lochhead

**English:**
Word of mouth. This boggles our minds, those of us in category design, because WOM is was and always will be the most powerful form of marketing. And in the native digital world, WOM can spread in a way that was never possible on the analog world for all the reasons we all understand. So if you take the concept of a lightning strike, then you take the concept of a category point of view that is all about frame naming and claiming a problem. And then there's one other concept I'll introduce.
(01:30:32):
It sits next to your ideal customer profile. It's what in category design we call super consumers. So it turns out that in most categories, roughly eight to 10% of the buyers are responsible for the vast majority of the profits. And more importantly, they are the zeitgeist. They are the thought leaders in the industry. They are the customers, the users, the purveyors of whatever the thing is that others look up to as being the ones to admire, the ones to aspire to, the best practices, et cetera, et cetera. That's a super consumer. Okay. So in category design, when you understand who your supers are, i.e. your ideal customer profile, you understand where they are primarily in the native digital world, how do we go hang out? And remind me what that gal's name was? I thought she was awesome.

**中文翻译:**
口碑（Word of Mouth, WOM）。这让我们这些搞品类设计的人感到不可思议，因为口碑过去是、现在是、将来也永远是最强大的营销形式。在数字原住民世界，口碑传播的方式是模拟世界永远无法企及的，原因大家都懂。所以，如果你结合了“闪电战”的概念，再加上“品类观点”（POV）——即定义、命名并占领一个问题。然后我再介绍另一个概念。
(01:30:32):
它与你的“理想客户画像”并列。在品类设计中，我们称之为“超级消费者”（Super Consumers）。事实证明，在大多数品类中，大约 8% 到 10% 的买家贡献了绝大部分利润。更重要的是，他们是时代精神的代表，是行业的思想领袖。他们是那些被他人仰望、向往、视为最佳实践标杆的客户、用户或传播者。这就是超级消费者。所以，在品类设计中，当你了解了谁是你的“超级用户”（即你的 ICP），了解了他们在数字世界的主要出没地，我们该如何去融入他们？顺便提醒我一下，那个女孩叫什么名字？我觉得她太棒了。

---

### (01:31:23) Lenny

**English:**
Meltem. Meltem Kuran Berkowitz.

**中文翻译:**
梅尔滕（Meltem）。梅尔滕·库兰·伯科维茨。

---

### (01:31:23) Christopher Lochhead

**English:**
Melson?

**中文翻译:**
梅尔森？

---

### (01:31:26) Lenny

**English:**
Meltem. M-E-L-T-E-M.

**中文翻译:**
梅尔滕。M-E-L-T-E-M。

---

### (01:31:29) Christopher Lochhead

**English:**
What a name. That's a great name. Anyway, I thought Meltem was awesome. She's absolutely on point. So we know who our ideal customer, aka super consumers are. We know where they hang out in the native digital world. We have a radically compelling different point of view about framing, claiming, and naming a problem that, if we do effectively, we'll resonate with them. That's why we spend time crafting that POV. So we evangelize the problem. We participate in a native digital community where they already are. And we do it from the perspective of not a marketer, not a seller, an educator. We're teaching people about a new and different way to think about an existing problem or a problem they hadn't thought of, that when they have an aha moment, because we articulate it well with our point of view, they go, "Oh, tell me more about that problem."
(01:32:21):
Right? As they do that, we take an education standpoint, mental framework to it. We open them up, we participate, and sooner or later somebody says, "Huh, tell me again what you do." And bam, away that we go. And here's the aha. When you understand supers, you understand the targeting, you understand a radically different point of view, reframing the problem, presenting a radically different solution. Well guess what? It's the ultimate growth engine. And you can grow for a very small amount of money. You could send email to 300 people and drive a breakthrough in sales.
(01:33:05):
Why? Because when you take this approach, you're not just driving near-term revenue, very, very important, you are driving WOM. A big part of why you want to have a point of view that can be articulated very quickly is marketing's job is to put the right words in the right mouths and to get that WOM to scale. And so when we have a category POV, that's about them, not us. Remember, brands are about us. Categories are about customers. We care about what they care about. And so when you have a powerful category POV, that drives WOM. And then when you do that in the native digital world, you get a tremendous amount of uplift from native digital viral WOM. And category design is the only business strategy whose primary execution focus starts with WOM.

**中文翻译:**
好名字。总之，我觉得梅尔滕太棒了，她的观点非常精准。所以，我们知道了理想客户（即超级消费者）是谁，知道他们在数字世界的出没地。我们有一个极具说服力的、不同的观点来定义、占领并命名一个问题，如果我们做得有效，就会引起他们的共鸣。这就是为什么我们要花时间打磨 POV。我们宣扬这个问题，参与到他们所在的数字社区中。我们不是以营销者或销售者的身份，而是以教育者的身份参与。我们教人们一种新的、不同的方式去思考现有问题或他们未曾想到的问题。当他们因为我们清晰的 POV 而产生“原来如此”的时刻时，他们会说：“哦，再多跟我讲讲那个问题。”
(01:32:21):
对吧？当他们这么做时，我们采取教育的立场和心理框架。我们启发他们，我们参与其中，迟早会有人问：“嘿，再跟我说说你是做什么的？”然后，砰，我们就开始了。关键点来了：当你理解了超级用户，理解了目标定位，理解了彻底不同的观点，重新定义了问题，并提出了彻底不同的解决方案——猜猜怎么着？这就是终极增长引擎。你可以用很少的钱实现增长。你可以给 300 个人发邮件，就能推动销售突破。
(01:33:05):
为什么？因为当你采取这种方法时，你不仅在驱动短期收入（这非常重要），你还在驱动口碑（WOM）。你之所以需要一个能快速表达的观点，很大一部分原因是营销的工作就是“把正确的话放进正确的嘴里”，并让口碑规模化。所以当我们有一个品类 POV 时，它是关于“他们”的，而不是关于“我们”的。记住，品牌关乎我们，品类关乎客户。我们关心他们关心的事。当你有一个强大的品类 POV 时，它会驱动口碑。当你在数字世界这样做时，你会从数字病毒式口碑中获得巨大的提升。品类设计是唯一一个将主要执行重点放在口碑上的商业战略。

---

### (01:34:06) Lenny

**English:**
What an awesome way to wrap up our conversation. It's basically a very tight go-to-market strategy is what you just shared. For folks that want to dig further, I'll just share a few of the places they could learn more. And then Neil, at the end, I'll ask you where to point people. But, you have an awesome Substack category, pirates. That's substack.com. You have your books, which I think maybe the best way to, I guess you tell me, is to find them as go to your last name. com, lochhead.com, L-O-C-H-head.com. Is that right?

**中文翻译:**
这真是总结我们对话的绝佳方式。你刚才分享的基本上是一个非常严密的“进入市场”（GTM）策略。对于想深入研究的人，我会分享几个可以了解更多的地方。最后我会问你该把大家引向哪里。你有很棒的 Substack 专栏《品类海盗》（Category Pirates）。还有你的书，我想找到它们最好的方式是去你的姓氏网站 lochhead.com，对吗？

---

### (01:34:34) Christopher Lochhead

**English:**
Yeah. And of course you can go to categorypirates.com.

**中文翻译:**
是的，当然也可以去 categorypirates.com。

---

### (01:34:36) Lenny

**English:**
Okay. Even easier. Amazing. So we have the lightning round coming up. Is there anything else you want to share as closing words or advice before we get to a very exciting lightning round?

**中文翻译:**
好的，更简单了。太棒了。接下来是闪电轮问答。在开始激动人心的闪电轮之前，你还有什么结束语或建议想分享吗？

---

### (01:34:47) Christopher Lochhead

**English:**
Yes, I do.

**中文翻译:**
有的。

---

### (01:34:48) Lenny

**English:**
Okay. Let's do it.

**中文翻译:**
好，开始吧。

---

### (01:34:51) Christopher Lochhead

**English:**
So I'm 55 years old, Lenny. I started my first company when I was 18. I got thrown out of school. I don't have a GED. And I've been in the tech industry the whole time. And the first thing I would share is anything's possible. Don't listen to anybody who shits on you. I've a chat on as much as you could possibly imagine. I have four or five different learning differences. ADHD, dyslexia, dyscalculia, blah, blah, blah, blah, blah. I was told I couldn't read. I was certainly told I couldn't write. I've written 14 number one fucking bestsellers, et cetera, et cetera. And so my point is, if you are somebody for whom you want to spend your professional time working on the exponential different as opposed to the incremental better, which I got to believe is a meaningful percentage of the people who consume your shit, if you want to work on the incremental better, incremental better is important.
(01:35:52):
I want the Boeing engineers working on the incremental better. I don't want the air traffic control system that's the exponential different. No. And a lot of incremental improvement over time can be exponential. So if you're a product manager and you're running a highly successful product with a massive install base, and you're looking at your next rev, and you're trying to figure out of the 472 features that you could build. What are the 26 that really matter? And you want to go talk to your customers to find out what those incremental improvements are and to stack rank them into all that good. PRD, MRD, IUD, all that shit. There's a big place in the world for all of that. It's incredibly important. That's not category design. So with that said, I think, Lenny, we are at the greatest time in history for our industry.
(01:36:48):
I think all the indicators show that the amount of innovation that is going to happen in the next five years will eclipse the amount of innovation that happened in the last 20 years. It's accelerating. AI is insanely exciting, dangerous, concerning. Do we need to focus on the downside? Do we need to be smart? Do we need to be thoughtful? Do we need to learn? Do we need to work with regulators and legislators? Absolutely. Could it go horribly? Oh, sure. But, that's always true. AI feels a little bit different, but it's always true. And for the record, the Luddites are always wrong. The point being now is the greatest time in history to be a creator, to be an entrepreneur, to be a marketer. I've been a marketer for my entire adult life. It's never been greater than it is right now. And so here's the big thing that I would share.
(01:37:43):
If you are somebody for whom you want to make an exponential difference, you want to innovate, you want to create new value where there wasn't, you want to have a legendary career where you can look back on your career and go, "You know what? I was part of this and that. And I was on this team." Now is the greatest time in history. And what I would say to you is the future needs you. Most people are not working on the exponential different.
(01:38:14):
And so the future of our world requires that the innovative people, that the entrepreneurial people stand up, take advantage of these incredible technologies. And a lot of people, particularly in my age group, Lenny, shit on millennials, Gen Z, what are lovingly referred to as native digitals. Absolutely not. I'm inspired by them. And I think the next generation of our entrepreneurs will be our greatest generation of entrepreneurs. So my point is, now's the time. The future needs you. Don't listen to any of the bullshit. I don't care what the boo birds say. Absolutely, go for it because there's never been a greater time to design and dominate new categories of innovation than right now.

**中文翻译:**
莱尼，我今年 55 岁了。我 18 岁创办了第一家公司。我被学校开除，没有高中学历证书（GED）。我一直待在科技行业。我想分享的第一件事是：一切皆有可能。别听那些羞辱你的人。我受过的羞辱超乎你的想象。我有四五种不同的学习障碍：多动症（ADHD）、阅读障碍、计算障碍等等。曾有人告诉我我不会阅读，更有人说我不会写作。结果我写了 14 本他妈的榜单第一畅销书。所以我的观点是：如果你想把职业生涯花在追求“指数级的不同”而不是“渐进式的更好”上（我相信你的听众中有很大一部分是这样的人），那么请坚持下去。虽然渐进式的更好也很重要。
(01:35:52):
我希望波音的工程师在做渐进式的改进，我不希望空中交通管制系统搞什么“指数级的不同”。不。而且随着时间的推移，大量的渐进式改进也可以变成指数级的。所以，如果你是一名产品经理，负责一个拥有庞大安装群的成功产品，你在考虑下一个版本，试图从 472 个可能的功能中找出真正重要的 26 个，你想去和客户聊聊，找出那些改进并进行优先级排序——PRD、MRD 那些玩意儿——世界上有很多地方需要这些，这极其重要。但这不叫品类设计。话虽如此，莱尼，我认为我们正处于行业历史上最好的时代。
(01:36:48):
我认为所有迹象都表明，未来五年发生的创新将超过过去 20 年的总和。它正在加速。AI 极其令人兴奋，同时也危险、令人担忧。我们需要关注负面影响吗？需要聪明、深思熟虑、不断学习吗？需要与监管机构和立法者合作吗？绝对需要。事情会变糟吗？哦，当然。但这永远是事实。AI 感觉有点不同，但道理是一样的。顺便说一句，卢德分子（反对技术进步的人）永远是错的。重点是，现在是历史上成为创作者、创业者和营销人员最好的时代。我成年后的整个职业生涯都在做营销，现在的环境比以往任何时候都要好。所以我想分享的核心观点是：
(01:37:43):
如果你想创造指数级的差异，如果你想创新，想在虚无中创造新价值，想拥有一个传奇的职业生涯，让你在回首往事时能说：“你知道吗？我参与了那个项目，我是那个团队的一员”，那么现在就是历史上最好的时机。我想对你说的是：未来需要你。大多数人并没有在追求“指数级的不同”。
(01:38:14):
所以我们世界的未来需要创新的人、有创业精神的人站出来，利用这些不可思议的技术。莱尼，很多我这个年纪的人会羞辱千禧一代、Z 世代（即所谓的数字原住民）。绝对不该这样。我被他们激励着。我认为下一代创业者将是我们最伟大的一代创业者。所以我的观点是：现在就是时候。未来需要你。别听那些废话，我不在乎那些唱衰的人怎么说。绝对要放手去做，因为现在正是设计并主导新品类创新的最好时机。

---

### (01:39:02) Lenny

**English:**
I love that message. You're just passion and energy for creating and inspiring comes through really clearly in all your writing. And so I love hearing it in person. With that, we've reached our very exciting lightning round. What are two or three books you've recommended most to other people?

**中文翻译:**
我喜欢这段话。你对创作和激励的热情与能量在你的文字中体现得淋漓尽致，能亲耳听到真是太棒了。至此，我们进入了激动人心的闪电轮问答。你向别人推荐最多的两三本书是什么？

---

### (01:39:22) Christopher Lochhead

**English:**
Richard Bach, Illusions. And then in terms of business books, I'll share with you one, because I know people recommend all the same shit. I'll share with you one that I think it may still be in print, but if not, it's easy to get. Mark McCormack's What They Don't Teach You At The Harvard Business School. So on the personal side, Richard Bach, Illusions. And for one that you may not have heard of Mark McCormack, What They Don't Teach You At The Harvard Business School.

**中文翻译:**
理查德·巴赫（Richard Bach）的《幻象》（Illusions）。至于商业书，我分享一本，因为我知道大家推荐的都差不多。我分享一本可能还在印，或者很容易买到的：马克·麦考马克（Mark McCormack）的《哈佛商学院不教你的经营策略》（What They Don't Teach You At The Harvard Business School）。所以，个人成长类是《幻象》，商业类是你可能没听过的《哈佛商学院不教你的经营策略》。

---

### (01:39:55) Lenny

**English:**
What is a favorite recent movie or TV show that you really enjoyed?

**中文翻译:**
最近有什么你非常喜欢的电影或电视剧吗？

---

### (01:39:59) Christopher Lochhead

**English:**
Oh, right now we're watching Designing Anna or Inventing Anna or whatever that's called. So that's been fascinating to watch. I think it's been incredibly well done.

**中文翻译:**
哦，我们现在在看《创造安娜》（Inventing Anna）。非常精彩，我觉得拍得非常好。

---

### (01:40:10) Lenny

**English:**
What a wild story, that one. What is a favorite interview question you like to ask candidates when you're hiring people?

**中文翻译:**
那确实是个疯狂的故事。你在招聘面试时最喜欢问候选人的问题是什么？

---

### (01:40:18) Christopher Lochhead

**English:**
So there's actually two. And I'll start with the second most important interview question, which I think is the most important question. But in a job interview setting, for me it's the second most important. And that is, it there anything else? And you know this as a podcaster. I end every single one of my podcasts with, is there anything else? And the interesting thing about that question, you can spend three hours with somebody talking about very important shit. You can think you got all the detail. You could have asked all the questions about the technical architecture and the campaign and the distribution and I don't know what.
(01:40:56):
And at the very end you say, "Hey, Susan, before we wrap, is there anything else?" And often, Lenny, the most important thing for that person to communicate comes out then. It happens so often, it's bizarre. I use that in medical situations. Family member is in the hospital going for an operation. "Okay, doc, tell me." I tell you all the shit. Is there anything else? I will tell you that eight times out of 10, the most important thing about the surgery with your loved one will come after that question. I will even use it during a conversation as we transition from various different points.
(01:41:37):
So in an interview situation, maybe you're asking somebody about their background. You might say, "Well, is there anything else about your background you think I should know?" It's the most powerful open question. But in an job interview situation, it's my second favorite. My first favorite is, so Lenny, are you legendary?

**中文翻译:**
实际上有两个。我先说第二重要的面试问题，虽然我认为它是最重要的问题，但在面试场景下排第二。那就是：“还有别的吗？”（Is there anything else?）作为播客主你也知道，我每期播客结束都会问：“还有别的吗？”这个问题的有趣之处在于，你可以和某人聊三个小时非常重要的事，你以为掌握了所有细节，问遍了技术架构、活动、分发等等。
(01:40:56):
但在最后你说：“嘿，苏珊，在我们结束前，还有别的吗？”莱尼，通常那个人最想传达的最重要的信息会在此时流露出来。这种情况发生得太频繁了，简直不可思议。我在医疗场合也用这个。家人在医院要做手术，“好了，医生，告诉我吧。”医生说完了一切。我问：“还有别的吗？”我会告诉你，十次有八次，关于你爱人手术最关键的信息会在这个问题之后出现。我甚至在谈话的不同阶段转换时也会用它。
(01:41:37):
所以在面试中，你可能在问某人的背景，你可以说：“关于你的背景，还有什么你觉得我应该知道的吗？”这是最强大的开放式问题。但在面试中，这是我的第二爱。我的第一爱是：“那么莱尼，你称得上‘传奇’吗？”

---

### (01:42:01) Lenny

**English:**
You want me to answer that?

**中文翻译:**
你想让我回答吗？

---

### (01:42:03) Christopher Lochhead

**English:**
You can if you like or not.

**中文翻译:**
你想答就答，不想答也行。

---

### (01:42:05) Lenny

**English:**
No.

**中文翻译:**
不答。

---

### (01:42:06) Christopher Lochhead

**English:**
But, the answer to that question...

**中文翻译:**
但是，那个问题的答案……

---

### (01:42:08) Lenny

**English:**
What are you looking for?

**中文翻译:**
你在寻找什么样的答案？

---

### (01:42:09) Christopher Lochhead

**English:**
... Is always radically illustrative. I'm not looking for anything. I'm looking for your answer. Some people will say, "Yes." And they'll tell you why. Some people will say, "Well, that's a big word." Whatever they're going to say. But, it is a purposely provocative question with one of, I think, the most powerful words in the English language, because I want to get a read on that person and how they respond to a purposely provocative question about themselves.

**中文翻译:**
……总是极具启发性。我没在寻找特定的东西，我在寻找“你的”答案。有些人会说“是的”，并告诉你原因。有些人会说“呃，这个词太重了”。无论他们说什么，这都是一个故意带有挑衅性的问题，使用了英语中最强大的词汇之一，因为我想了解那个人，看他们如何应对一个关于他们自己的挑衅性问题。

---

### (01:42:42) Lenny

**English:**
Amazing. Okay, just a couple more questions. What's a favorite life motto that you like to repeat yourself or share with other people?

**中文翻译:**
太棒了。好，最后两个问题。你最喜欢的、经常对自己重复或分享给别人的座右铭是什么？

---

### (01:42:50) Christopher Lochhead

**English:**
If you're lucky enough to make it to the top of a mountain, throw down a fucking rope. And for me on that, Lenny, I'm somebody who has had and continues to have a radical amount of love and support in my life. When I was young, I started with nothing and I got thrown out of school. And I didn't know until I was 21 because when I was young, learning differences weren't a thing. And by the way, the way most of the world and education system deals with learning differences is completely fucked. But, that's a different conversation. It's definitely improved, but it is nowhere near what it needs to be. And so I just think that we should never be held back by those views of others. And so we need to be unencumbered.

**中文翻译:**
如果你有幸登上了山顶，他妈的扔下一根绳子（去帮别人）。莱尼，对我来说，我是一个在生活中获得过并将继续获得巨大爱与支持的人。我年轻时白手起家，被学校开除。直到 21 岁我才知道自己有学习障碍，因为我小时候还没这个概念。顺便说一下，世界上大多数教育系统处理学习障碍的方式简直是一团糟。那是另一个话题了。虽然有所改善，但还远远不够。所以我认为我们永远不该被他人的眼光束缚，我们需要轻装上阵。

---

### (01:43:42) Lenny

**English:**
I love it. Final question. It's a dumb question. Maybe to lead to something fun. You're a category pirate. Do you have a favorite real pirate?

**中文翻译:**
我喜欢这个。最后一个问题，是个傻问题，也许能引出有趣的话题。你是“品类海盗”，你有最喜欢的真实海盗吗？

---

### (01:43:51) Christopher Lochhead

**English:**
I have actually a lot of favorite pirates. I'll tell you about one of them. His name is Tony Etherington, but virtually nobody calls him Tony. Virtually everybody calls him Doris. And Doris is a legendary surfer and surf explorer from the Gold Coast of Australia. And I went on my first ever boat tour, surf adventure in Indonesia with Tony.
(01:44:22):
There's a horrible story I'm thinking of telling you. Anyway, you haven't been with a real pirate until you've been in stormy seas at night with Doris smoking cigarettes, drinking Jack Daniels in the bridge thinking maybe we're going to die, but this guy's probably not going to let that happen. And so Doris Etherington would be one of my top pirates of all time. And he's got the voice. And he's got the attitude. When I was having problems surfing, he would say to me, "All right, sit you down mate." Always smoking a cigarette. He's like, "I'd smoke long if we could have ciggyed up now." He goes, "You paddle out, wait for the biggest wave, lean into it, and get right up on it."
(01:45:21):
And so in our world, get right up on it is has become an expression for go for it. So I think we can all heed the words of Doris and get right up on it.

**中文翻译:**
我其实有很多喜欢的海盗。我给你讲其中一个。他叫托尼·埃瑟林顿（Tony Etherington），但几乎没人叫他托尼，大家都叫他多丽丝（Doris）。多丽丝是来自澳大利亚黄金海岸的传奇冲浪者和冲浪探险家。我人生中第一次去印度尼西亚的乘船冲浪探险就是和托尼一起去的。
(01:44:22):
我正在想一个要不要告诉你的恐怖故事。总之，除非你曾在深夜的暴风雨海面上，看着多丽丝在驾驶室里抽着烟、喝着杰克丹尼，心里想着“我们可能要死了”，但又觉得这家伙大概不会让这种事发生，否则你就不算见过真正的海盗。多丽丝·埃瑟林顿是我心目中永远的顶级海盗。他有那种嗓音，有那种态度。当我冲浪遇到困难时，他会说：“好了，坐下，伙计。”总是叼着烟。他说：“你划出去，等最大的浪，靠过去，然后‘直接冲上去’（get right up on it）。”
(01:45:21):
所以在我们的世界里，“直接冲上去”已经成了“放手去做”的代名词。我想我们都可以听从多丽丝的话，直接冲上去。

---

### (01:45:36) Lenny

**English:**
I love that this question led to something fun and interesting. Chris, thank you so much for being here. This conversation was entertaining, insightful, spicy, fun, funny, everything I hoped it would be. Two final questions. Where can folks find you online if they want to learn more and keep reading? And then two, how can listeners be useful to you?

**中文翻译:**
我很高兴这个问题引出了这么有趣的话题。克里斯，非常感谢你能来。这次对话充满娱乐性、洞察力、火药味、趣味和幽默，完全符合我的预期。最后两个问题：如果大家想了解更多并继续阅读，可以在哪里找到你？第二，听众可以为你做些什么？

---

### (01:45:54) Christopher Lochhead

**English:**
Probably categorypirates.com is the simplest spot to go. And how listeners can be useful to me?

**中文翻译:**
最简单的地方应该是 categorypirates.com。至于听众能为我做什么？

---

### (01:46:03) Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### (01:46:04) Christopher Lochhead

**English:**
It's what we talked about a moment ago. The future needs you. And the future needs the people who have the courage to make a difference, because the people who are different are the ones who have made the biggest difference. Every time. And we live in a world where we are rewarded for our sameness, for fitting in. Our education system teaches us what we're trying to do is find our place in the world. And listen, some of us do. I know people who wanted to be a vet from the time they were kids, and that's the path they chose. And they became vets. And they love it. And they're wonderful people. And they have great careers. And they make a giant difference. And they've always known. And fucking a. And so if you are somebody for whom you have found your place in the world, congratulations. That's awesome. And we also know, particularly in the innovator, entrepreneur, creator, marketer world, many of us, there was no place.
(01:47:13):
And so my hope is that you either find your place or if you realize there's no place for you, that you further realize that you can make your place in the world. And fundamentally, that's what category design is about. It's about making a distinct, unique place in the world for yourself, for your product, and for your company. Because the people who are different make the biggest difference. And so the great thing that people can do for me is to go into the world and make a different place for themself in a way that delivers massive value to others.

**中文翻译:**
就是我们刚才谈到的：未来需要你。未来需要那些有勇气创造不同的人，因为那些与众不同的人才是创造最大不同的人。每一次都是如此。我们生活在一个奖励“雷同”和“合群”的世界。我们的教育系统教导我们去寻找自己在世界上的位置。听着，有些人确实找到了。我认识一些从小就想当兽医的人，他们选择了那条路，成了兽医，他们热爱这份工作，他们是了不起的人，事业有成，创造了巨大影响，而且他们一直都知道自己要什么。这太棒了。但我们也知道，特别是在创新者、创业者、创作者和营销者的世界里，我们中的许多人并没有现成的位置。
(01:47:13):
所以我的希望是，你要么找到你的位置，要么如果你意识到没有属于你的位置，那就进一步意识到你可以“创造”自己在世界上的位置。从根本上说，这就是品类设计的意义：为你自己、为你的产品、为你的公司在世界上创造一个独特的、独一无二的位置。因为与众不同的人创造最大的不同。所以，人们能为我做的最好的事，就是走进世界，以一种为他人提供巨大价值的方式，为自己创造一个不同的位置。

---

### (01:48:00) Lenny

**English:**
Beautiful. Chris, thank you again so much for being here.

**中文翻译:**
太美好了。克里斯，再次感谢你能来。

---

### (01:48:04) Christopher Lochhead

**English:**
Lenny, bless you. I love all things, Lenny. Thank you.

**中文翻译:**
莱尼，祝福你。我喜欢关于莱尼的一切。谢谢。

---

### (01:48:07) Lenny

**English:**
Thanks Chris. Bye everyone.
(01:48:11):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast. com. See you in the next episode.

**中文翻译:**
谢谢克里斯。大家再见。
(01:48:11):
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。