# Christopher Miller - 双语对照

# Lenny's Podcast: Chris Miller (HubSpot VP of Product, Growth & AI) - Bilingual Transcript

---

### [00:00:00] [Chris Miller]

**English:**
... The actual really small initial growth team. We really had an aggressive mentality, an aggressive approach, and what that looked like was at the time, a very small percentage of, I think HubSpot's subscription revenue would be described as self-service, so we approached the team who owned it and we were like, "Are you all working on this?" They were like, "Nah, we're working on a bunch of other stuff." We were like, "Can we take this?" They were like, "Sure, if you want it." And so, we took it and immediately blew it up, and so that attitude of saying that every problem is our problem and radical accountability and ownership mentality helped us find opportunities that maybe the business wasn't explicitly asking us to solve, but we were able to triangulate why it might be important for the business for us to solve it. When you do that, we look hungry, so let's keep feeding us, right?

**中文翻译:**
……那是最初规模非常小的增长团队。我们当时的心态和方法都非常激进。具体来说，当时 HubSpot 的订阅收入中只有极小一部分可以被称为“自助服务”（self-service）。于是我们找到负责那一块的团队问：“你们在搞这个吗？”他们说：“没，我们正忙着处理一堆别的事呢。”我们又问：“那能交给我们负责吗？”他们回答：“当然，如果你想要的话就拿去吧。”于是我们接手了，并立即让它实现了爆发式增长。那种“所有问题都是我们的问题”的态度，以及极度的问责制和主人翁意识，帮助我们发现了一些业务部门可能并没有明确要求我们去解决的机会，但我们能够通过多方分析，推导出为什么解决这些问题对公司至关重要。当你这样做时，公司会觉得我们很有“饥饿感”，所以就会不断给我们投喂更多的任务，对吧？

---

### [00:00:48] [Lenny]

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard win experiences building and growing today's most successful products. Today, my guest is Chris Miller. Chris is VP of product for growth and AI at HubSpot. Chris started as an ICPM at HubSpot where he helped create their early growth team and as you'll hear, shifted HubSpot towards one of the most successful product-led growth businesses in history. Seven years later, he leads both their growth and AI teams and advises founders on product-like growth and growth strategy in general.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，从他们构建和增长当今最成功产品的艰辛经验中学习。今天的嘉宾是 Chris Miller。Chris 是 HubSpot 负责增长和人工智能（AI）的产品副总裁。Chris 最初是以一名 IC（个人贡献者）产品经理的身份加入 HubSpot 的，在那里他协助创建了早期的增长团队。正如你将听到的，他推动 HubSpot 转型为历史上最成功的产品驱动增长（PLG）企业之一。七年后，他同时领导着增长和 AI 团队，并为创始人提供关于产品驱动增长和整体增长策略的建议。

---

### [00:01:20] [Lenny]

**English:**
In our wide-ranging conversation, we cover what it takes to become a successful product leader in tech, what skills the most successful PMs need to build, how to find mentors, why you need to scrape your knees as an early PM. Also, a lot of great stories and insights about what HubSpot figured out about growth across content, sales product, market segments, and growth loops. I so enjoyed this conversation and we could have gone for another hour if I didn't cut myself off, and so I'm really excited for you to listen to this conversation. With that, I bring you Chris Miller after a short word from our sponsors.

**中文翻译:**
在我们广泛的交谈中，我们探讨了成为科技行业成功产品领导者所需的素质、最成功的 PM 需要培养哪些技能、如何寻找导师，以及为什么作为初级 PM 你需要“磕磕碰碰”（经历失败）。此外，还有许多关于 HubSpot 在内容、销售产品、细分市场和增长循环（growth loops）方面的精彩故事和见解。我非常享受这次对话，如果不是我强行打断，我们还能再聊一个小时。我非常期待大家能听到这段对话。在听完赞助商的简短介绍后，我们将请出 Chris Miller。

---

### [00:01:54] [Lenny]

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Comm, Quora, and Modern Treasury trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs and get ready for audits in weeks, not months. By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA, and many more. Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time Lenny's podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny, that's V-A-N-T-A.com/lenny to learn more and to claim your discounts. Get started today.

**中文翻译:**
本期节目由 Vanta 赞助。Vanta 帮助您简化安全合规流程，从而加速业务增长。数千家快速成长的公司，如 Gusto、Comm、Quora 和 Modern Treasury，都信任 Vanta 来帮助构建、扩展、管理和展示其安全合规计划，并在数周而非数月内为审计做好准备。通过提供最受青睐的安全和隐私框架，如 SOC 2、ISO 27001、GDPR、HIPAA 等，Vanta 帮助公司获取加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5,000 家快速成长的公司使用 Vanta 自动完成 SOC 2 及其他框架高达 90% 的工作。在限定时间内，Lenny 播客的听众可享受 Vanta 1,000 美元的优惠。请访问 vanta.com/lenny（即 V-A-N-T-A.com/lenny）了解更多信息并领取折扣。今天就开始吧。

---

### [00:02:52] [Lenny]

**English:**
This episode is brought to you by Sidebar. Are you looking to land your next big career move or start your own thing? One of the most effective ways to create a big leap in your career and something that worked really well for me a few years ago is to create a personal board of directors, a trusted peer group where you can discuss challenges you're having, get career advice, and just kind of gut check how you're thinking about your work, your career, and your life. This has been a big trajectory changer for me, but it's hard to build this trusted group. With Sidebar, senior leaders are matched with highly vetted private supportive peer groups to lean on for unbiased opinions, diverse perspectives, and raw feedback.

**中文翻译:**
本期节目由 Sidebar 赞助。您是否正在寻求职业生涯的下一次重大跨越，或者准备自主创业？实现职业飞跃最有效的方法之一，也是几年前对我非常有用的方法，就是建立一个“个人董事会”——一个值得信赖的同行群体。在这里，你可以讨论面临的挑战，获取职业建议，并对你对工作、事业和生活的思考进行直觉检查。这对我来说是一个巨大的轨迹改变者，但建立这样一个受信任的群体很难。通过 Sidebar，资深领导者可以与经过严格审核的、私密的、相互支持的同行群体匹配，从而获得公正的意见、多元的视角和原始的反馈。

---

### [00:03:31] [Lenny]

**English:**
Everyone has their own zone of genius, so together we're better prepared to navigate professional pitfalls, leading to more responsibility, faster promotions, and bigger impact. Guided by world-class programming and facilitation, Sidebar enables you to get focused, tactical feedback at every step of your journey. If you're a listener of this podcast, you're likely already driven and committed to growth. A Sidebar personal board of directors is the missing piece to catalyze that journey. Why spend a decade finding your people when you can meet them at Sidebar today? Jump the growing wait list of thousands of leaders from top tech companies by visiting sidebar.com/lenny to learn more, that's sidebar.com/lenny. Chris, thank you so much for being here and welcome to the podcast.

**中文翻译:**
每个人都有自己的天才领域，因此聚在一起，我们能更好地应对职业陷阱，从而承担更多责任、获得更快晋升并产生更大影响。在世界级项目和引导的指导下，Sidebar 让您在旅程的每一步都能获得专注且具战术性的反馈。如果您是本播客的听众，您可能已经充满动力并致力于成长。Sidebar 的个人董事会就是催化这一旅程的最后一块拼图。既然今天就能在 Sidebar 遇到志同道合的人，何必再花十年去寻找呢？访问 sidebar.com/lenny 即可跳过数千名来自顶级科技公司领导者的候补名单，了解更多信息。Chris，非常感谢你能来到这里，欢迎来到本播客。

---

### [00:04:19] [Chris Miller]

**English:**
I'm so excited to be on the podcast. Thank you, Lenny, for having me. This will be a lot of fun.

**中文翻译:**
我非常激动能参加这个播客。谢谢你，Lenny，邀请我。这一定会很有趣。

---

### [00:04:24] [Lenny]

**English:**
A huge thank you to Kyle Poyer for introducing us. I've heard so many great things about you from so many great people, and so I'm really excited to be chatting and I wanted to start with your very unique role that you're in now at HubSpot and it feels like it might be a sign of things to come for product leaders. Your title as far as I can tell is VP of product of growth and AI. Can you just talk about what that is and how growth and AI relate in the context of HubSpot?

**中文翻译:**
非常感谢 Kyle Poyer 为我们牵线搭桥。我从很多优秀的人那里听到了关于你的很多赞誉，所以我非常期待这次聊天。我想从你目前在 HubSpot 担任的非常独特的职位开始，这似乎预示着产品领导者未来的发展方向。据我所知，你的头衔是增长与 AI 产品副总裁。你能谈谈这个职位具体是做什么的，以及在 HubSpot 的背景下，增长和 AI 是如何关联的吗？

---

### [00:04:54] [Chris Miller]

**English:**
I've been leading PLG at HubSpot for several years now, and I recently took on the AI leadership role. It's a special place to be in and that I get to help lead HubSpot in terms of how we should be thinking about building the foundational technology to create AI-powered experiences and then also lead the strategy of how we leverage those experiences to help that B2B business builder be way more successful using our platform than they might've been in years past. So, it's a really cool intersection point between those two things. There's a lot we can do there.

**中文翻译:**
我在 HubSpot 领导 PLG（产品驱动增长）已经好几年了，最近又承担了 AI 方面的领导职责。这是一个非常特殊的位置，我既要协助领导 HubSpot 思考如何构建基础技术以创造 AI 驱动的体验，又要领导如何利用这些体验来帮助 B2B 业务构建者在我们的平台上取得比过去几年更大的成功。所以，这是这两者之间一个非常酷的交汇点，我们大有可为。

---

### [00:05:33] [Lenny]

**English:**
One thing I took away from what you just shared is that you are given these two teams to lead, which aren't necessarily connected, but I think it tells me that you're doing a great job at HubSpot and I'm going to try to pierce through your modesty and I'm curious, what is it that you think you've done really well or been successful at that got the leaders at HubSpot to decide to give you this other team that feels like an incredibly important initiative in this time of AI?

**中文翻译:**
从你刚才的分享中我体会到一点，你被委以重任去领导这两个未必直接相关的团队，这说明你在 HubSpot 做得非常出色。我想抛开你的谦虚问一下：你认为自己在哪方面做得特别好，或者取得了哪些成功，才让 HubSpot 的领导层决定把这个在 AI 时代显得极其重要的另一支团队也交给你？

---

### [00:05:58] [Chris Miller]

**English:**
So when I joined HubSpot in 2016, it was definitely an element of timing that really worked in my favor. It was maybe like a year or so after HubSpot had launched their free CRM, which was a big strategic play for them and for us, excuse me, at the time, and it was meant to be disruptive, but I don't think that there was a fully formed perspective on what was going to happen after that. How are we actually going to get leverage and enterprise value out of this sort of big, enormous piece of free software we just put into the universe? And I think the pedigree of product manager at HubSpot at that time was also a bit different. There were folks who maybe started their time at HubSpot in support, and so intimately familiar with the product and with customers. Some of these people had closed thousands of support tickets and my background was a bit different.

**中文翻译:**
我 2016 年加入 HubSpot 时，时机确实对我非常有利。当时距离 HubSpot 发布免费 CRM 大约过了一年左右，那对当时的他们——抱歉，是对当时的我们——来说是一项重大的战略举措，旨在颠覆市场。但我认为当时对于之后会发生什么还没有一个完全成熟的看法。我们究竟该如何从这个刚刚推向世界的庞大免费软件中获得杠杆效应和企业价值？而且，我认为当时 HubSpot 产品经理的背景也有些不同。有些人可能是从客服支持部门开始在 HubSpot 的职业生涯的，因此他们对产品和客户非常熟悉，有些人甚至处理过数千张支持工单。而我的背景则有些不同。

---

### [00:06:57] [Chris Miller]

**English:**
I was actually less of a feature PM and I was sort of more of a growth PM in my DNA, and so I sort of looked at this through a completely different lens and I guess I understood that what we were trying to actually do was product-led growth, but we didn't really have the shared vocabulary to call it that. And so I think to answer your question, I think I was just willing to take some risks and really push for the things that I believed made sense even though maybe based on the titles that I had at the time, I wasn't sort of inherently given a seat at the table and really pushed my away into some of these conversations and then was eventually invited to them. And so, just always had an interest in driving a strategy that was a click or two higher than maybe what my immediate team was focused on and was always curious about how other parts of the business functioned.

**中文翻译:**
我其实不太像是一个负责具体功能的 PM，我的基因里更像是一个增长型 PM。所以我从一个完全不同的视角来看待这件事。我想我当时意识到我们实际上在尝试做的是“产品驱动增长”，只是我们当时还没有统一的词汇来这么称呼它。所以，回答你的问题，我认为我只是愿意承担一些风险，并努力推动那些我认为有意义的事情，尽管根据我当时的头衔，我并没有被赋予参与决策的席位。我努力挤进了一些对话中，最终被邀请参与其中。我一直对推动比我直接团队关注点更高一两层的战略感兴趣，并且总是对业务的其他部分如何运作感到好奇。

---

### [00:07:51] [Chris Miller]

**English:**
I used to spend a lot of time sitting on the sales floor, just going into the other buildings and talking to other folks, working on different parts of the business, and that's part of maybe the serendipity that I miss about being in person, which is that you might just discover something from having a casual conversation with someone at the water cooler. You're like, "Oh, that's an interesting problem. I think my team can help with that," so you absorb a bunch of context around how pieces of the business are connected and you can start to really widen your aperture in terms of the size of opportunities that might be in front of you that maybe you would've missed if you would've been so heads down on execution work. And so, if I had to guess how people might talk about that, if I wasn't in the room, maybe they would cite that, but it's tough to say.

**中文翻译:**
我以前常花大量时间待在销售部，或者去其他办公楼和负责不同业务的人聊天。这就是我怀念实地办公的原因之一——那种“不期而遇的惊喜”（serendipity）。你可能只是在饮水机旁和人闲聊，就能发现一些东西。你会想：“噢，那是个有趣的问题，我觉得我的团队能帮上忙。”这样你就吸收了大量关于业务各环节如何连接的背景信息，你可以开始拓宽视野，看到那些如果你只顾埋头执行工作可能会错过的巨大机会。所以，如果要我猜别人在我不在场时会怎么评价我，也许他们会提到这一点，但很难说准。

---

### [00:08:34] [Lenny]

**English:**
Hard to do those serendipitous watercolor chats in these remote hybrid times, huh?

**中文翻译:**
在现在这种远程和混合办公的时代，很难再有那种饮水机旁的偶遇闲聊了，对吧？

---

### [00:08:39] [Chris Miller]

**English:**
Yeah, everything's so scheduled and tightly scheduled and you're bouncing from Zoom to Zoom and obviously HubSpot has embraced hybrid and there's a ton of benefit to it. In fact, I was a new dad when I came back to work and my son wasn't in daycare, and so it was so cool to just be able to pop out in between meetings and play with him for a few minutes just to go back and you don't get that when you're in the office all day. So definitely a lot of upside, but certainly you got to be a little bit more creative in terms of that serendipitous knowledge sharing, the osmosis learning, and just context sharing that happens more organically when everybody's sharing the same physical space.

**中文翻译:**
是的，一切都被安排得满满当当，你不停地在各个 Zoom 会议之间切换。显然 HubSpot 已经拥抱了混合办公，这有很多好处。事实上，我刚回公司上班时是个新手爸爸，我儿子还没上托儿所，所以能在会议间隙溜出去陪他玩几分钟再回来工作，这种感觉太棒了，如果你整天待在办公室是做不到这一点的。所以确实有很多好处，但在那种偶然的知识分享、潜移默化的学习以及背景信息共享方面，你必须更有创意，因为当大家共享同一个物理空间时，这些事情会发生得更自然。

---

### [00:09:17] [Lenny]

**English:**
You talked about how some of your early success was taking risks and being in meetings maybe you shouldn't be in. Is there an example or a story that comes to mind of doing that where you kind of took a risk early kind of in being a PM at HubSpot and/ or something that worked out really well, surprisingly?

**中文翻译:**
你提到你早期的一些成功源于承担风险和参加一些你本不该参加的会议。你能想到一个具体的例子或故事吗？比如你在 HubSpot 担任 PM 早期承担了某种风险，或者某件事出人意料地进展得非常顺利？

---

### [00:09:33] [Chris Miller]

**English:**
This is a funny story. For anybody at HubSpot listening, I apologize in retrospect for this, but-

**中文翻译:**
这是一个有趣的故事。如果 HubSpot 有人在听，我为当年的行为事后致歉，但是——

---

### [00:09:40] [Lenny]

**English:**
I'm excited for this.

**中文翻译:**
我很期待听这个。

---

### [00:09:41] [Chris Miller]

**English:**
There was a time where we were having a lot of debates around pricing and packaging, and we'll get into this, but our go-to-market model and sort of where we play in the addressable market created some complexity in the sense of we're serving different parts of the market simultaneously with the connected unified platform. And so, how do you think about packaging and go-to-market? And we were trying to just figure out how to simplify, simplify, simplify. And at the time I was an IC, individual contributing PM, so who am I to have a point of view on pricing and packaging? But the person I was working with, my designer, her name's Mariah Moscato, she's in product now, she's excellent, we were part of a triad and we both had a similar school of thought in terms of what the pricing packaging could be.

**中文翻译:**
有段时间我们对定价和包装（pricing and packaging）有很多争论。我们稍后会详细讨论，但我们的进入市场（GTM）模式以及我们在目标市场中的定位确实带来了一些复杂性，因为我们通过一个互联统一的平台同时服务于市场的不同部分。那么，你该如何考虑包装和进入市场呢？我们当时正试图弄清楚如何简化、简化、再简化。当时我只是一名 IC（个人贡献者）产品经理，我哪有资格对定价和包装发表意见？但我的合作伙伴，我的设计师 Mariah Moscato（她现在也在产品部门，非常优秀），我们当时是一个三人小组的成员，我们对定价包装应该是什么样子有着相似的想法。

---

### [00:10:33] [Chris Miller]

**English:**
And we were over in Dublin where we have our European headquarters and there was a party happening at the Guinness sort of storehouse, and I don't know that we were exactly on the guest list, but we figured out a way to get into the party and we ran into the COO at the time and out of the blue I think he had asked us what we thought about pricing and packaging and it was sort of one of those funny you should ask moments. And so, we ended up kind of pitching in the midst of pints being sort of handed every which way you could turn this vision for a completely different way we might approach pricing and packaging, and he was pretty intrigued and he said, "Why don't you come to the next executive meeting and pitch us on it?"

**中文翻译:**
当时我们在都柏林，那是我们的欧洲总部所在地。在健力士黑啤仓库（Guinness Storehouse）有一场派对，我不确定我们是否在受邀名单上，但我们想办法混了进去。我们遇到了当时的 COO，他突然问我们对定价和包装有什么看法，这简直就是那种“你问得正是时候”的时刻。于是，在周围到处都在递啤酒的情况下，我们向他推销了一个关于定价和包装的全新愿景。他非常感兴趣，并说：“你们为什么不来参加下一次高管会议，向我们推销一下这个想法呢？”

---

### [00:11:22] [Chris Miller]

**English:**
I think that meeting was maybe a couple of weeks away and so we looked at each other and we were like, "Uh-oh," not exactly what we expected in terms of, I think people welcoming maybe a contrarian point of view at that moment in time. And so, we sort of were invited into this meeting with folks that we generally don't get to spend a lot of time with to pitch this thing that swam a little bit upstream and we ultimately didn't go full steam ahead down that path. I think a lot of elements of what we pitched have made their way over time into HubSpot's pricing and packaging, but it certainly I think opened the door for us and for me, speaking for myself, certainly for me to be welcomed back into that room in the future and to be able to contribute ideas towards important decisions.

**中文翻译:**
我记得那次会议大概在两周后。我们面面相觑，心想：“糟糕。”这并不是我们预料到的，因为我不觉得当时的人们会欢迎这种相反的观点。于是，我们被邀请参加这个会议，和那些平时根本见不到的高管们一起，去推销这个有点“逆流而上”的想法。最终我们并没有完全按照那个路径走下去，但我认为我们推销的很多元素随着时间的推移已经融入了 HubSpot 的定价和包装中。但这确实为我们打开了大门，对我个人而言，这让我以后能被欢迎回到那个房间，并能为重大决策贡献想法。

---

### [00:12:09] [Lenny]

**English:**
I love that. It's another example of serendipity and just running into people. Also, I think it's a really good example of just how important it's for PMs to be proactive and think ahead and not just rely on people coming to you, asking you for your advice and getting invited to rooms. I feel like so much of success in the product leadership role is just suggesting great ideas, being ahead of where people are and having the answers. You have the answer right there in the moment because you did the work ahead of time. Is that something you find as well that ends up being really important?

**中文翻译:**
我太喜欢这个故事了。这是另一个关于“不期而遇”和偶遇他人的例子。而且，我认为这很好地证明了 PM 主动出击和超前思考是多么重要，而不是仅仅依赖别人来找你、征求你的建议或邀请你进入会议室。我觉得产品领导角色的成功很大程度上在于提出伟大的想法、走在大家前面并拥有答案。你之所以能在那个时刻给出答案，是因为你提前做了功课。你也觉得这一点最终非常重要吗？

---

### [00:12:42] [Chris Miller]

**English:**
Yeah, one of the traits that I look for in PMs that I hire onto my teams, and also when I think back to the people that I've learned a lot from working with over the years, one of the common behaviors or traits is relentless curiosity, this insatiable desire to understand things and a lack of fear in admitting when they don't understand things and being uncompromising and getting the answers so that they do understand. And I think if you can bring that to the table, it's much easier to have an outsized impact on whatever or you're a part of or whatever mission you're working on or whatever team you may be a member of.

**中文翻译:**
是的，在我招聘 PM 时，以及回顾多年来我从合作伙伴身上学到的东西时，我寻找的一个共同特质就是“持续的好奇心”（relentless curiosity）——一种对理解事物的永不满足的渴望，不害怕承认自己不懂，并且在寻求答案以达到理解的过程中绝不妥协。我认为如果你具备这一点，就更容易在你参与的任何事情、任何使命或任何团队中产生巨大的影响力。

---

### [00:13:30] [Lenny]

**English:**
Are there any other traits on that list of traits you look for that you think are really important that maybe other people don't focus on?

**中文翻译:**
在你寻找的特质清单中，还有哪些你认为非常重要，但其他人可能不太关注的特质吗？

---

### [00:13:37] [Chris Miller]

**English:**
Yeah, relentless curiosity is probably my number one. My number two would probably be resilience, specifically if you're working in growth. I think if you're doing growth, right, if you're doing product-led growth the right way, then you're trying to balance the science and sort of taking a somewhat hygienic approach to validating assumptions and hypotheses with being really ambitious and really pushing for the things that are going to have massive impact for your customers at the end of the day. And when you're doing that, you're going to fail more than you're going to be successful along the way. And if you're not resilient, that can be really demotivating. I think there's a stat that some growth person put out there years ago, which is that on average only 20 to 30% of experiments of growth team runs might be successful. So, that means 70 to 80% of the time you're, you're not putting numbers on the board and you're extracting learnings hopefully that you can apply to the future.

**中文翻译:**
是的，持续的好奇心可能是我的第一位。第二位可能是“韧性”（resilience），特别是如果你在做增长工作。我认为如果你在正确地做增长，以正确的方式做产品驱动增长，那么你就是在平衡科学性（即采用某种规范的方法来验证假设）与雄心壮志（即真正推动那些最终能为客户产生巨大影响的事情）。在这个过程中，你的失败会多于成功。如果你没有韧性，这会让你非常沮丧。我记得几年前有增长专家给出一个数据：增长团队进行的实验平均只有 20% 到 30% 能成功。这意味着 70% 到 80% 的时间你都没有取得亮眼的成绩，你只是在提取教训，希望以后能用得上。

---

### [00:14:43] [Chris Miller]

**English:**
But I think if you're not resilient, what I've seen happen is you end up sort of grasping for a win, which can sometimes look like making bets that are too small and too insignificant to matter. If your sort of primary modality of product-led growth work is experiment-driven product development and you're hitting more than like 30, 40% of the time, you're thinking too small. And so, that resiliency piece is certainly important in my mind. I think coachability is another one in the sense that I still think that the sort of subcategory of growth product management is still fledgling compared to PMs working on platform features. And so, even when I'm interviewing folks, I'm not necessarily looking for 10 years of experience doing PLG. I think that's mostly an unreasonable ask, but it can certainly be taught and even if you do have some experience doing PLG work, it's important to know that what that work is going to look like is going to potentially vary in a meaningful way from shop to shop.

**中文翻译:**
但我认为如果你没有韧性，我看到的情况是你会变得急于求成，这有时表现为下注太小、太微不足道。如果你做产品驱动增长的主要模式是实验驱动的产品开发，而你的成功率超过了 30% 或 40%，那说明你的格局太小了。所以，在我看来，韧性非常重要。我认为“可教练性”（coachability）是另一个重点，因为我仍然觉得增长产品管理这个子类别与负责平台功能的 PM 相比还处于起步阶段。所以，即使我在面试时，也不一定要求对方有 10 年的 PLG 经验，我觉得这通常是不合理的要求。但这是可以教的，即使你确实有一些 PLG 经验，也要知道不同公司的 PLG 工作方式可能会有很大差异。

---

### [00:15:49] [Chris Miller]

**English:**
And so, being coachable and adaptable to whatever the context is of the business or problem space that you're working on I think is an important trait that I look for in PMs, and then creativity is so important too. Valuing simple solutions to really hard problems, I think if building the next super sophisticated widget is the thing that gets you out of bed in the morning, growth might not be for you, I think the best growth product leaders and growth minds that I've worked with over the years or have had the privilege of learning from over the years, I think the thing that I noticed about them is they're almost ambivalent to the solution and certainly ambivalent to how complex a solution may or may not be. And taking little to no pleasure or pride in the complexity of a solution so long that it delivers the outcome that the business and your customers need, I think is a really cool trait, and I kind categorize that under creativity.

**中文翻译:**
因此，能够接受指导并适应所处的业务背景或问题空间，是我在 PM 身上寻找的重要特质。此外，创造力也非常重要。重视用简单的方案解决极难的问题——我认为，如果每天让你起床的动力是构建下一个超级复杂的组件，那么增长工作可能不适合你。多年来我合作过或有幸请教过的最优秀的增长产品领导者和增长人才，我注意到他们对具体的解决方案几乎持中立态度，当然对方案的复杂程度也持中立态度。只要能交付业务和客户所需的结果，他们就不会从方案的复杂性中获得快感或自豪感。我认为这是一个非常酷的特质，我将其归类为创造力。

---

### [00:16:53] [Lenny]

**English:**
You mentioned this phrase, relentless curiosity, and it made me think about a story I read about you where the way you got into product management was you were at some startup and the founder was just like, "I've read that the cure to all our problems is going to be hiring product manager," and you heard that and you googled, what is product management, and then you asked them, "Can I do that?" And that's how you got into the role. So first of all, is that true? And second of all, what's your advice to people trying to get into product management and any lessons from that experience?

**中文翻译:**
你提到了“持续的好奇心”这个词，这让我想起我读过的一个关于你的故事：你进入产品管理领域是因为当时你在一家初创公司，创始人说：“我读到解决我们所有问题的良方就是雇一个产品经理。”你听到后就去谷歌搜索“什么是产品管理”，然后问他们：“我能做那个吗？”你就这样进入了这个角色。首先，这是真的吗？其次，你对想要进入产品管理领域的人有什么建议，从那次经历中有哪些教训？

---

### [00:17:22] [Chris Miller]

**English:**
So first, yes, that is 100% true. That is how I stumbled into product management. So, I appreciate all the folks who took a shot on me back then, but this was at a time where I would say product management even as a function was definitely not ubiquitous across tech. There was, at least in the world that I was in, a lot more of a standard waterfall approach to building product with a lot of middle layers and engineering managers and really no one who had the job of owning the problem from a customer's point of view. And so, there wasn't a ton of content out there. There weren't even a ton of people in the city at the time that I could really talk to sort of learn, and so a lot of what I did was scrape my knees through the first years and a lot of painful trial and error.

**中文翻译:**
首先，是的，这百分之百是真的。我就是这样误打误撞进入产品管理的。所以我很感谢当时愿意在我身上赌一把的人。但在那个时候，产品管理作为一个职能部门在科技界远未普及。至少在我所处的环境中，更多的是标准的瀑布式开发方法，有很多中间层和工程经理，但确实没有人负责从客户的角度出发去主导问题。所以当时并没有太多的相关内容，甚至在那个城市里也没有多少人可以让我去请教学习。所以我最初几年的大部分经历都是在“磕磕碰碰”（scrape my knees）中度过的，经历了许多痛苦的试错。

---

### [00:18:08] [Chris Miller]

**English:**
And then eventually I think there's a lot more energy and an interest around the trade craft and the function, and so I think it's much easier today for someone to learn the fundamentals of product management without necessarily needing to do it via trial by fire. My advice to folks who are interested in breaking into product management specifically is focus on a few things. One, focus on structure. I think there's usually a lower barrier to entry to do product management at a smaller shop, which they might not have as much access to the best talent out there, but I think what you may often give up in those instances is structure to your own sort of professional development and formal training and education and potentially even the opportunity to work for people who are truly battle tested and have seen the movie several times and can actually wisdom share because truthfully, it looks different in every company, and so it is one of those functions.

**中文翻译:**
后来，我认为人们对这项手艺和职能有了更多的精力和兴趣。所以今天的人学习产品管理的基础知识要容易得多，不一定非要通过“战火洗礼”来学习。我对那些想进入产品管理领域的人的建议是关注几点。第一，关注结构。我认为在小公司做产品经理的门槛通常较低，他们可能接触不到最顶尖的人才，但我认为在这种情况下，你往往会牺牲掉职业发展的结构性、正式的培训和教育，甚至可能失去与那些真正久经沙场、阅历丰富且能分享智慧的人共事的机会。因为说实话，产品管理在每家公司看起来都不一样。

---

### [00:19:13] [Chris Miller]

**English:**
I do believe that taking a truly academic approach towards upskilling has fairly diminishing returns because it's tough to field curveballs in a classroom. And so, choosing where you want to break in is almost as important as choosing that you want to break in the first place. Thinking about who you're going to be reporting to, thinking about what's the track record of success for people at that company, breaking into product management, trying to think five years in advance and work backwards, I think are all sort of important thought exercises along the way. I would also say that if you're already at a shop where you are working at a different function and you're sort of product curious, go talk to the PMs, literally I say go reach out to a PM and ask how you can make their day easier.

**中文翻译:**
我确实认为，采取纯学术的方式来提升技能，其边际收益是递减的，因为在教室里很难应对现实中的突发状况（curveballs）。所以，选择在哪里切入几乎和决定要切入一样重要。考虑你将向谁汇报，考虑那家公司的人在进入产品管理后的成功记录，尝试提前五年思考并倒推，我认为这些都是非常重要的思维练习。我还想说，如果你已经在一家公司工作，但处于不同的职能部门，并且对产品感兴趣，那就去和 PM 聊聊。我真的建议你去联系一位 PM，问问你能如何让他们的一天变得更轻松。

---

### [00:20:01] [Chris Miller]

**English:**
Figure out what you can do in your spare time that they can offload to you and do a little bit of volunteer labor, even if that's just shadowing because I think just getting that context and understanding the sort of rhythm of how a team ideates and defines problems and prioritizes and ship software is the experience that's going to be the most important because a lot of product management is also managing personalities and figuring out how people want to work with you and figuring out how you work for them. And so, just getting that hands-on experience or at least direct sight-line into the day-to-day of a team is really important because the extent to which you can understand their problem space and understand the things that keep them up at night, you can be valuable, and then at the very least, what you get out of it is hopefully an advocate or a sponsor at the end of the day who is willing to gamble some professional and political capital on you to get your foot into the door even though you might not have any formal experience on your resume.

**中文翻译:**
弄清楚你在业余时间能做些什么来分担他们的工作，做一点志愿者工作，哪怕只是跟着学习（shadowing）。因为我认为，获取背景信息并理解团队如何构思、定义问题、确定优先级和交付软件的节奏，才是最重要的经验。产品管理很大程度上也是在管理人际关系，弄清楚别人想如何与你合作，以及你如何为他们服务。所以，获得这种亲身实践的经验，或者至少能直接观察团队的日常工作是非常重要的。因为你越能理解他们的问题空间和那些让他们彻夜难眠的事情，你就越有价值。至少，你最终有望获得一位支持者或赞助人，他们愿意为你赌上一些职业和政治资本，让你入门，即使你的简历上没有任何正式经验。

---

### [00:21:04] [Lenny]

**English:**
There's so much stuff that super resonates there. One is that I always think of the bare minimum job of a PM is just to be useful to people on the team and help them do better work. If you do that alone, people-

**中文翻译:**
这里有很多东西让我产生共鸣。第一，我一直认为 PM 最起码的工作就是对团队成员有用，帮助他们做得更好。如果你能做到这一点，大家就会——

---

### [00:21:15] [Chris Miller]

**English:**
Bring the donuts, right?

**中文翻译:**
“带甜甜圈来”，对吧？（意指做些让大家开心的琐事）

---

### [00:21:16] [Lenny]

**English:**
Bring the donuts, exactly.

**中文翻译:**
没错，带甜甜圈。

---

### [00:21:19] [Chris Miller]

**English:**
I must be old, I don't know that anybody uses bringing the donuts now anymore.

**中文翻译:**
我肯定老了，我不知道现在还有没有人用“带甜甜圈”这个说法。

---

### [00:21:22] [Lenny]

**English:**
No, we had Ken on the podcast, we talked about it. We asked, what is the digital version of that when everyone's working remote? I think that's something that even if you're a brand new PM you come across soon enough. And then the other piece there, I really love this metaphor of scraping your knees because I find that to be so important to becoming a PM is you think you could just read these things, take some courses and you got this, and you're not going to mess up, but I find that messing up is so important in helping to learn to do the job because like you said, there's relationships and people and changing plans and leaders, and it's just like you're not going to get it right and you learn how to deal with all these things by messing it up.

**中文翻译:**
不，我们之前请 Ken 上播客时也聊过这个。我们问，当大家都远程办公时，这个词的数字版是什么？我觉得即使你是一个全新的 PM，很快也会遇到这种情况。另外一点，我非常喜欢“磕磕碰碰”（scraping your knees）这个比喻，因为我发现这对成为 PM 至关重要。你可能觉得只要读读这些东西、上上课就能搞定，不会出错，但我发现犯错对于学习如何胜任这份工作非常重要。因为正如你所说，这里涉及人际关系、人员变动、计划变更和领导层，你不可能一开始就做对，你是通过搞砸事情来学习如何处理这些问题的。

---

### [00:22:01] [Lenny]

**English:**
So, I super agree with that, and even though you said it's easier not to learn to be a PM, it's still I think important to scrape your knees a number of times for you to actually learn to do the job. Along those lines, what did you find was most helpful to you to learn the craft of product management in the first few years? What do you think back to like, "Oh, that was really helpful," other than just doing it messing up, sometimes getting it right?"

**中文翻译:**
所以我非常同意这一点。尽管你说现在学习成为 PM 变得更容易了，但我认为为了真正学会这份工作，经历几次“磕碰”仍然很重要。顺着这个思路，你觉得在最初几年里，对你学习产品管理这门手艺最有帮助的是什么？除了亲自动手、搞砸事情、偶尔做对之外，还有什么让你回想起来觉得“噢，那真的很有帮助”？

---

### [00:22:27] [Chris Miller]

**English:**
So, my first product management job/mission was working on a B2B2C product, and there's a lot of unique challenges that came with that. Our customer was not the end user of our product. We sold into institutions who then white labeled our product and then resold it to the end customer. And so at the end of the day, our customers own the relationship with the end user and not us, and so-

**中文翻译:**
我的第一份产品管理工作/任务是负责一个 B2B2C 产品，这带来了很多独特的挑战。我们的客户并不是产品的最终用户。我们把产品卖给机构，他们对产品进行贴牌（white label），然后转售给最终客户。所以归根结底，是我们的客户拥有与最终用户的关系，而不是我们，所以——

---

### [00:23:00] [Chris Miller]

**English:**
... own the relationship with the end user and not us. And so, the challenges that that created were that there was a lot of distance between us and the voice of the end user. And we ended up building a lot of things to satisfy the buyer and the customer, but not necessarily the end user. And that's challenging because you don't necessarily know whether you're building something to get a contract signed, or you're building something that's going to delight the person using it at the end of the day, or provide magical value. And so, I think I probably shipped a lot of bad product those years, if I'm being completely honest. I don't know that I would look back at what I shipped back then or what we shipped back then, and say they were the best possible solutions or best possible product.

**中文翻译:**
……拥有与最终用户关系的是他们，而不是我们。这带来的挑战是，我们与最终用户的声音之间有很大的距离。我们最终构建了很多东西来满足买家和客户，但不一定是最终用户。这很有挑战性，因为你并不确定你构建的东西是为了签下合同，还是为了最终让使用者感到愉悦，或者提供神奇的价值。所以，说实话，我觉得那几年我交付了很多糟糕的产品。回顾我当时交付的东西，或者我们当时交付的东西，我不敢说它们是最好的解决方案或最好的产品。

---

### [00:23:47] [Chris Miller]

**English:**
It wasn't until I got my second product management job where it really was an inflection point, where I was like, "Oh, got it. This is what this is supposed to look and feel like."

**中文翻译:**
直到我换了第二份产品管理工作，那才真正是一个转折点，让我感叹：“噢，明白了。这才是它该有的样子和感觉。”

---

### [00:23:57] [Lenny]

**English:**
Where was that? Was that with Keeper?

**中文翻译:**
那是在哪儿？是在 Keeper 吗？

---

### [00:23:59] [Chris Miller]

**English:**
I was working at a fitness technology company, and the person who really I would say changed my entire paradigm of what product management is supposed to be, someone I know you know, Fareed Mosavat, who I believe was on the pod-

**中文翻译:**
我当时在一家健身科技公司工作。那个真正改变了我对产品管理认知的范式的人，我知道你也认识，Fareed Mosavat，我相信他上过你的播客——

---

### [00:24:17] [Lenny]

**English:**
Ooh. Absolutely.

**中文翻译:**
噢，绝对上过。

---

### [00:24:17] [Chris Miller]

**English:**
... last October. Shout out to Fareed if you're listening. Fareed is a good friend and mentor, and he really helped me level up. And what was interesting about those years is it was the first time I'd really gotten to work on a product where it was a freemium B2C run-tracking app. And so, we spent a lot of time talking to users directly, and a lot of guerrilla user research techniques. Literally, sometimes going outside and just talking to runners in passing to understand what were the challenges in finding motivation, and why do they choose running assistance, running applications in the first place? And so, just that having that deep connection to the customer and not feeling like you're being kept at arms' distance was eyeopening. I was like, "Oh, I didn't know that it could be like this."

**中文翻译:**
……就在去年十月。如果 Fareed 在听的话，向他致敬。Fareed 是我的好朋友和导师，他真的帮我提升了一个档次。那几年有趣的地方在于，那是我第一次真正负责一个产品——一个免费增值模式（freemium）的 B2C 跑步追踪应用。所以，我们花了大量时间直接与用户交流，使用了许多“游击式”用户调研技巧。字面意义上的，有时就是走到户外，和路过的跑者聊天，了解他们在寻找动力方面有哪些挑战，以及他们最初为什么选择跑步辅助应用。那种与客户建立深度联系、不被拒之门外的感觉让我大开眼界。我当时想：“噢，我以前不知道原来还可以这样。”

---

### [00:25:12] [Chris Miller]

**English:**
And then, the second thing that we had at our disposal that changed the game for me was access to a huge user data set. And so, having data at scale to drive decisions, being able to know that if we make a change, we can prove causation from a business impact standpoint or a customer delight or engagement standpoint. And so, it was almost like I didn't realize I was blind until... Or you didn't realize you weren't seeing in color. It's like that scene in The Wizard of Oz where they land on Oz, and all of a sudden, everything's in Technicolor. And you're like, "Oh, my gosh, I can actually make informed decisions about what I'm shipping."

**中文翻译:**
然后，我们拥有的第二件改变我职业生涯的东西是：接触庞大的用户数据集。拥有大规模数据来驱动决策，能够知道如果我们做一个改动，我们可以从业务影响、客户愉悦度或参与度的角度证明因果关系。这就像我以前没意识到自己是盲人，或者没意识到自己看的是黑白世界。就像《绿野仙踪》里的那个场景，他们降落在奥兹国，突然间一切都变成了彩色。你会惊叹：“天哪，我竟然真的可以根据信息来决定我交付的产品。”

---

### [00:25:56] [Chris Miller]

**English:**
And having a level of rigor around that and really being forced to articulate a hypothesis and have a point of view on what the outcomes might be before you actually build something, were all sort of, I would say, behaviors and just philosophy around product discipline that I learned from Fareed and that group of folks that I worked with closely during those years. And that was, I think the... I consider that to be when I really became a product manager.

**中文翻译:**
对数据保持严谨，在真正构建东西之前被迫清晰地阐述假设，并对可能的结果有自己的见解——这些都是我从 Fareed 以及那几年紧密合作的那群人身上学到的产品纪律方面的行为和哲学。我认为，那才是我真正成为一名产品经理的时刻。

---

### [00:26:30] [Lenny]

**English:**
There are two things I want to highlight there that, again, super resonate. One is just whenever I talk to customers, I'm like, "Why don't I do this more often?" Because every time it's like, "Wow, I had no idea how big of a problem that was. Why don't I do this all the time?" And then, you don't again. And then, you do it months later and you're like, "Oh, my god, I learned so much again." And so, I think if you're listening and you're just like... Maybe just go talk to a customer today.

**中文翻译:**
我想强调两点，再次让我产生了强烈的共鸣。第一，每当我与客户交谈时，我都会想：“我为什么不经常这么做呢？”因为每次都会感叹：“哇，我竟然不知道那个问题有那么严重。我为什么不一直这么做？”然后，你又没坚持。几个月后你再做一次，又会感叹：“天哪，我又学到了这么多。”所以，如果你正在听这个播客，也许今天就去和一位客户聊聊吧。

---

### [00:26:55] [Chris Miller]

**English:**
Talk to customers, and we also learned a lot from talking to people who we wanted to be customers but were not, right? And people who had either broken up with our product or evaluated it and never fell in love with it in the first place. And so, I think every PM struggles with time management and it feels like you need 60 hours in a day to get through your weekly checklist, or 60 hours in a week, excuse me. But finding time to just talk to people. Even today, I have a lot of friends who are entrepreneurs or small business owners, and some use HubSpot, some don't. But I usually tend to really enjoy my conversations with people who decided not to use HubSpot and to really try to unpack what drove that decision.

**中文翻译:**
去和客户聊聊，我们也从那些我们希望他们成为客户但他们不是的人身上学到了很多，对吧？还有那些已经弃用我们产品的人，或者评估过但从未爱上我们产品的人。我认为每个 PM 都在与时间管理作斗争，感觉每天需要 60 个小时才能完成每周的清单——抱歉，是每周 60 个小时。但要找时间去和人聊天。即使在今天，我有很多创业者或小企业主朋友，有些用 HubSpot，有些不用。但我通常非常喜欢与那些决定不使用 HubSpot 的人交谈，并真正尝试拆解是什么促使了那个决定。

---

### [00:27:40] [Chris Miller]

**English:**
Was it as calculated, as I think sometimes we can all maybe assume that some of these decisions are? And then you often learn that they're sometimes kind of emotional, really instinctual and visceral and maybe connected to brands more than they even connected to product. And there's a lot of things that I think when you're in the proverbial digital conference room with your team, trying to understand what makes your users tick, you're just like, "We're actually just..." We're illogical humans at the end of the day at our core, and that all rides on decisions people make in the day-to-day. And it doesn't change, necessarily, when they're engaging with your product. As much as we love it to be perfect science, so that we can moneyball the system, if you will.

**中文翻译:**
那个决定是否像我们有时假设的那样经过深思熟虑？然后你经常会发现，它们有时是感性的、本能的、发自内心的，甚至与品牌的联系比与产品的联系更紧密。我觉得很多时候，当你和团队在所谓的数字会议室里试图理解用户的动机时，你会发现：“我们本质上其实是……”归根结底，我们是不合逻辑的人类，一切都取决于人们日常做出的决定。当他们使用你的产品时，这一点未必会改变。尽管我们希望它是一门完美的科学，这样我们就可以像《点球成金》（Moneyball）那样操控系统。

---

### [00:28:23] [Lenny]

**English:**
It reminds me of a story where we were doing some user research on a booking feature with an Airbnb. And we went to Paris to do these really in-depth user research studies. We were behind one-way mirrors and all that stuff. And we were trying to figure out why hosts weren't connecting Facebook to their account. This is like, I don't know, five, six years ago. Because it gave them so much access to where their friends are traveling and reviews and all these things. And especially, in France, they were just like, "I don't trust Facebook." And this was before it became a big thing in the US. They're just like, "I don't trust... I don't want them to have any of my data." "But look at all this power you get." They're like, "No, I don't care. I don't trust it." And-

**中文翻译:**
这让我想起一个故事，当时我们在 Airbnb 做关于预订功能的用户调研。我们去巴黎做了非常深入的研究，躲在单向玻璃后面观察。我们试图弄清楚为什么房东不把 Facebook 账号关联到他们的账户。这大概是五六年前的事。因为关联后他们可以方便地看到朋友去哪儿旅行、评价等等。但在法国，他们特别反感：“我不信任 Facebook。”这还是在 Facebook 的隐私问题在美国闹大之前。他们就说：“我不信任……我不想让他们拥有我的任何数据。”我们说：“但你看你能获得这么多功能。”他们说：“不，我不在乎，我不信任它。”而且——

---

### [00:28:59] [Chris Miller]

**English:**
Yeah, that's why talking to customers is so... You could have all the usage data in the world, that's going to tell you what's actually happening in your product, but it doesn't tell you why. It will never explain the why behind a behavior that you can track through events firing. And so, that's why that sort of proximity to the customer and directing that sort of relentless curiosity towards the qualitative stuff is so, so important because you just learn things that are just sometimes really unintuitive or are blind spots because we're often not the people we're building product for.

**中文翻译:**
没错，这就是为什么与客户交谈如此重要。你可以拥有世界上所有的使用数据，那能告诉你产品中实际发生了什么，但它不能告诉你“为什么”。它永远无法解释你通过埋点事件追踪到的行为背后的原因。所以，与客户保持亲近，并将那种持续的好奇心转向定性研究（qualitative stuff）是非常非常重要的，因为你会学到一些有时非常反直觉的东西，或者是我们的盲点，因为我们通常并不是我们所构建产品的目标受众。

---

### [00:29:35] [Lenny]

**English:**
Absolutely. I want to shift talking about HubSpot the business, but one more last thing I wanted to highlight from what you just shared, which is a really good insight is you shared that your biggest inflection in your career was a manager, Fareed in this case, who helped you learn the craft and develop your skills, and that's the exact experience I had too. Just one specific manager changed everything for me. And that feels like a recurring theme to a lot of people, just having one person that really spends the time to help you learn and correct you when you're making mistakes and all that. So, if folks are wondering maybe why am I not learning enough or why is my care stagnating? See if you can just find... Easier said than done, but oftentimes it just takes one person to change everything.

**中文翻译:**
绝对正确。我想转而谈谈 HubSpot 的业务，但在那之前，我想强调一下你刚才分享的一个非常好的见解：你提到职业生涯中最大的转折点是一位经理（在这个例子中是 Fareed），他帮助你学习手艺并提升技能。我的经历也完全一样，就是某一位特定的经理改变了我的一切。这似乎是很多人的共同主题——只要有一个人真正花时间帮助你学习，并在你犯错时纠正你。所以，如果有人在想“为什么我学不到足够的东西”或者“为什么我的职业生涯停滞不前”，看看你是否能找到……说起来容易做起来难，但通常只需要一个人就能改变一切。

---

### [00:30:15] [Chris Miller]

**English:**
It gets into sort of a conversation about the difference between a manager and a mentor, versus a sponsor and an advocate. Mentors are great, don't get me wrong. I have a ton of people that I would consider to be mentors, but when I think about the people in my life, who... The time that they donated to me, the time that they volunteered to me and for me, calling them mentors, I think sells what they were very short. And I would actually describe those folks as being sponsors and advocates, people who were willing to put up capital, whether that's professional, social capital to bet on you.

**中文翻译:**
这涉及到关于经理、导师（mentor）与赞助人（sponsor）、倡导者（advocate）之间区别的讨论。导师很棒，别误会，我有很多人可以称之为导师。但当我想到我生命中的那些人……他们为我投入的时间，为我自愿付出的精力，称他们为导师我觉得太轻描淡写了。我实际上会将这些人描述为赞助人和倡导者，他们愿意投入资本——无论是职业资本还是社交资本——来在你身上下注。

---

### [00:30:56] [Chris Miller]

**English:**
I mean, truth be told, when I interviewed with Fareed that first time, I think back to the interview and I think I bombed it. I actually don't think I would've hired me back then. And I remember the answers I gave to some of those questions, and I think they were good, but I don't think they were certainly great. And I imagine that there was something in there where the decision maker, who was Fareed said, "I think I can make something out of this." And I think being willing to invest in someone and finding people who are willing to invest in you is what really matters. And finding people who are willing to, again, put something up for you, whether that be whatever kind of capital it is. When I think about true gasoline on the career fire, it's finding mentors, but it's also finding sponsors and advocates.

**中文翻译:**
说实话，回想起第一次和 Fareed 面试时，我觉得我搞砸了。如果我是当时的面试官，我可能都不会雇佣我自己。我记得我对某些问题的回答，我觉得还行，但绝对谈不上出色。我想当时作为决策者的 Fareed 一定是看到了某些东西，心想：“我觉得我可以把这个人培养出来。”我认为愿意投资于某人，以及找到愿意投资于你的人，才是真正关键的。找到那些愿意为你付出的人，无论是什么样的资本。当我想到职业生涯真正的“助燃剂”时，那是寻找导师，但更是寻找赞助人和倡导者。

---

### [00:31:48] [Lenny]

**English:**
Is there anything that you think you did right to help find mentors and sponsors and advocates for people that are thinking about, "Hey, I need this. How do I help myself in the same way?" Is there something you did that helped people get excited to help you?

**中文翻译:**
对于那些在想“嘿，我需要这个，我该如何帮助自己”的人，你觉得你做对了什么来帮助自己找到导师、赞助人和倡导者？你做了什么让别人兴奋地想要帮助你？

---

### [00:32:02] [Chris Miller]

**English:**
Something I think I certainly continue to work on, but really, putting ego aside and embracing not knowing stuff and embracing not being good at stuff, and not feeling self-conscious about that and letting the desire to be the best at something or at least be great at something overpower the fear of being inadequate at something. And I played sports growing up, and so I like being coached. I can take hard feedback, and I like it because if I get better feedback than the people I'm competing against, I think I can beat them over time if I work hard enough.

**中文翻译:**
这是我一直在努力做的事情，那就是放下自尊，拥抱“不知道”和“不擅长”，不要因此感到局促不安。让想要在某方面做到最好或至少做到优秀的渴望，压倒对表现不足的恐惧。我从小参加体育运动，所以我喜欢接受指导。我可以接受严厉的反馈，而且我喜欢它，因为如果我能比竞争对手获得更好的反馈，只要我足够努力，随着时间的推移我就能击败他们。

---

### [00:32:42] [Chris Miller]

**English:**
And so, I think just taking that mentality with me into product management, I think has helped me build bridges with people who don't owe me anything, right? People who don't necessarily need to be invested in me at all, but who might get delight out of it somehow. And I don't know exactly how that works and the calculus that goes on in folks' brains, but at least what's within my control is how I can show up in the context of those relationships and really embrace even the hardest, ugliest feedback and hope that I can extract something from it that'll make me better at the end of the day.

**中文翻译:**
所以，带着这种心态进入产品管理领域，帮助我与那些并不欠我什么的人建立了桥梁，对吧？那些完全没必要投资我，但可能从中获得某种乐趣的人。我不知道这背后的逻辑是什么，也不知道人们脑子里是怎么算的，但至少我能控制的是我在这些关系中的表现——真正拥抱哪怕是最严厉、最难听的反馈，并希望我能从中提取出一些东西，最终让我变得更好。

---

### [00:33:22] [Lenny]

**English:**
I love that advice. Makes me think about Jules Walter's advice, which I've referenced many times on this podcast now, where his tip is when people are giving you feedback, just be like, "Thank you so much for that feedback," even though you're melting inside and just completely disagree with what they're telling you.

**中文翻译:**
我非常喜欢这个建议。这让我想起 Jules Walter 的建议，我已经在播客里引用过很多次了。他的秘诀是，当别人给你反馈时，哪怕你内心在崩溃，或者完全不同意他们的说法，也要说：“非常感谢你的反馈。”

---

### [00:33:40] [Chris Miller]

**English:**
Yeah, shout out to Jules. Jules is also someone who has been generous with me in the past in terms of giving time when I've needed help with stuff. Also, a great episode you did with Jules.

**中文翻译:**
是的，向 Jules 致敬。Jules 过去在我需要帮助时也非常慷慨地给予了我时间。你和 Jules 做的那期节目也很棒。

---

### [00:33:51] [Lenny]

**English:**
So, many people have said what you just said about Jules, about how helpful he is been to them. So, clearly, a class act to that guy, maybe we'll have to bring him back.

**中文翻译:**
很多人都说过你刚才对 Jules 的评价，说他给了他们多大的帮助。显然，那家伙是个典范，也许我们得再请他回来。

---

### [00:33:59] [Chris Miller]

**English:**
Would love that.

**中文翻译:**
我很期待。

---

### [00:34:00] [Lenny]

**English:**
Yeah. V2 Jules. So, let's shift to HubSpot the business, which is a pretty incredible success story. From what my notes, it's worth something like $30 billion now as a business. It's been around for 17 years. Still growing, I think, something like 30% year over year. And most interestingly, Okta put out this really interesting report recently where they looked at their data of what tools people are using to authenticate with, and they showed that basically HubSpot is maybe the fifth fastest-growing software product in the world. I don't know if it's true, but feels true because all the other companies make sense there. So, you don't have to confirm or deny this, but clearly things are going great at HubSpot. I'm curious just what makes HubSpot so special and unique and successful that's specifically unique to HubSpot versus other companies?

**中文翻译:**
是的，Jules 第二季。现在让我们转向 HubSpot 这家公司，这是一个相当惊人的成功故事。根据我的笔记，它现在的市值大约是 300 亿美元。它已经成立 17 年了，目前仍保持着约 30% 的年增长率。最有趣的是，Okta 最近发布了一份非常有趣的报告，他们查看了人们使用哪些工具进行身份验证的数据，结果显示 HubSpot 基本上是全球增长第五快的软件产品。我不知道这是否属实，但感觉是真的，因为名单上的其他公司都很合理。所以，你不需要确认或否认这一点，但显然 HubSpot 的发展非常顺利。我很好奇，是什么让 HubSpot 如此特别、独特且成功，特别是那些 HubSpot 独有而其他公司不具备的特质？

---

### [00:34:51] [Chris Miller]

**English:**
There's a lot in there. I can speak to the things that have resonated most deeply with me in my time there. The first is legitimate customer obsession. It's not marketing, it's legitimate, right? I've witnessed fierce and passionate debates internally that the root of what the people in the debate were really trying to unpack was what was the best thing for the customer. And so, really having that be central to our dogma and how we think about the business and why the company exists in the first place, really walking the walk there is something that I don't know that that's true everywhere.

**中文翻译:**
这涉及很多方面。我可以谈谈在 HubSpot 期间让我产生最深共鸣的几点。第一是真正的“客户痴迷”（customer obsession）。这不是营销口号，而是实实在在的，对吧？我见证过内部激烈而充满激情的辩论，辩论的核心其实是大家都在试图弄清楚什么对客户才是最好的。所以，真正将这一点作为我们的信条核心，作为我们思考业务和公司存在意义的基石，并真正付诸实践，我不确定在其他地方是否也是如此。

---

### [00:35:39] [Chris Miller]

**English:**
I mean, I've certainly worked at places where that hasn't been true, and there's a lot of factors that can lead to those trade-off decisions at times. Like is this the right thing for the business, the right thing for the customer? Being really challenging. I think just sort of having that customer centricity really baked into the DNA of the company makes those decisions, maybe not easier, but at least you can have more conviction around the why behind the decision at the end of the day. Another thing that I think makes HubSpot-

**中文翻译:**
我的意思是，我确实在一些并非如此的地方工作过。有时有很多因素会导致权衡决策，比如：这对业务是正确的吗？这对客户是正确的吗？这非常具有挑战性。我认为，将这种“以客户为中心”的思想真正融入公司的 DNA，会让这些决策——也许不是变得更容易，但至少你最终会对决策背后的原因更有信心。我认为让 HubSpot 成功的另一件事是——

---

### [00:36:07] [Lenny]

**English:**
Before you actually move on to the next one, I want to spend a little time on this one because I think people hear this and they're like, "Yes, okay, we're going to be customer obsessed." And then, you have to make these hard decisions. Look at this experiment, it's going to grow our revenue 1%, but it's not really going to make the customer's life easier. How do you actually make this real? And there may be an example where you have to trade off growth versus we need to make sure the customer is getting what they need or making the customer happy to make it a little more real even.

**中文翻译:**
在你继续讲下一个点之前，我想在这个点上多花点时间。因为我觉得人们听到这个会说：“好，我们要做到客户痴迷。”但随后你就必须做出艰难的决定。比如：看这个实验，它能让我们的收入增长 1%，但并不会真正让客户的生活变得更轻松。你如何让这种理念落地？也许有一个例子，你必须在增长与确保客户获得所需或让客户满意之间做权衡，这样能让这个话题更具体一些。

---

### [00:36:34] [Chris Miller]

**English:**
One, I think that's a really fantastic, maybe not counterpoint, but thing to call out. My point of view here is that oftentimes it's a function of what's the time horizon that the company uses as their sort of baseline for assessing decisions? And typically, when you're making decisions that could be described as hostile towards your customers, but a net positive for the business, you're probably not thinking long-term enough, right? Because there's no possible way, unless you have completely cornered a market and there is no competition whatsoever, that you could continually be hostile towards your customers and grow, right? At some point, that's going to catch up.

**中文翻译:**
首先，我认为这是一个非常棒的切入点。我的观点是，这通常取决于公司评估决策时所采用的时间跨度。通常情况下，当你做出那些对客户不友好但对业务有净收益的决策时，你可能考虑得不够长远，对吧？因为除非你完全垄断了市场且没有任何竞争，否则你不可能在持续对客户不友好的情况下还能保持增长。在某个时间点，这总会让你付出代价。

---

### [00:37:25] [Chris Miller]

**English:**
And so, oftentimes I think it's the tension of what do we need to do in the short term to survive? Versus long-term, where are we going? What's the path that we're actually charting? Is I think the true tension. But if you're making decisions that might have lasting impact that are customer hostile, I think that's a really dangerous path to kind of go down. And so, having, I think, the discipline or the bravery or the courage, whatever, to I think focus on not necessarily tomorrow or the day after, and really think about two, three, four years from now, what are the outcomes we're trying to drive and what are the decisions we need to make in the interim that are going to lead to that outcome? If you stick to that sort of framework, or first principle is a better way to describe it, then I think you'll often end up arriving at the conclusion that doing the thing that's right for customers at the end of the day is the right decision.

**中文翻译:**
所以，我认为真正的张力在于：短期内我们需要做什么来生存？与长期来看我们要去哪里？我们实际规划的路径是什么？但如果你做出的决策具有持久影响且对客户不友好，我认为那是一条非常危险的道路。因此，我认为需要具备纪律、胆量或勇气，不去关注明天或后天，而是真正思考两三年、甚至四年后我们想要达成的结果，以及在此期间我们需要做出哪些决策来导向那个结果。如果你坚持这种框架，或者更准确地说是“第一性原理”，那么你通常会得出结论：归根结底，做对客户正确的事才是正确的决定。

---

### [00:38:24] [Lenny]

**English:**
Is there something in the way you operate that helps you systemize that in your experiment plan or product specs or experiment results? Or is there a story of something where you just shipped something that shows this customer obsession to make it even more concrete for listeners?

**中文翻译:**
在你的运作方式中，有没有什么东西能帮助你在实验计划、产品规格或实验结果中将其系统化？或者有没有一个故事，关于你们交付的某个产品体现了这种“客户痴迷”，好让听众有更具体的感受？

---

### [00:38:42] [Chris Miller]

**English:**
There's definitely structure you could put around customer centricity. And I think a lot of it for growth at HubSpot and the teams that I lead, it's around forcing specificity of language. So, for example, you look at a lot of standard documentation for features or experiments, whatever, and one of the first things, it's like outline the problem. I don't know that we even talk about problems without a qualifier. Are we talking about a business problem? Are we talking about a customer problem? Are we talking about an efficiency problem? Describe the nature of the problem and parse it out. Because generally speaking, if there's a business problem, you might do the thought exercise of asking, "Well, why hasn't that problem solved itself? What's the actual customer problem that is leading to the downstream negative thing that's happening to the business?"

**中文翻译:**
确实可以围绕“以客户为中心”建立一些结构。我认为在 HubSpot 的增长工作中，以及在我领导的团队中，很大程度上是关于强制使用精确的语言。例如，你看很多关于功能或实验的标准文档，第一项通常是“概述问题”。我不确定我们是否会在没有限定词的情况下讨论问题。我们是在谈论业务问题吗？客户问题吗？还是效率问题？描述问题的本质并将其拆解。因为通常来说，如果存在业务问题，你可能会做一个思维练习，问：“为什么这个问题没有自我解决？究竟是什么样的客户问题导致了业务下游出现的负面情况？”

---

### [00:39:34] [Chris Miller]

**English:**
And if we can actually create some daylight between those two things conceptually, we can avoid making the mistake of trying to solve a business problem in a way that leads to a bad outcome for the customer at the end of the day. And I think, also, creating a system that makes it easy for PMs to call out assumptions that they might be making. So, if we do this, what would you predict to be some of the sort of derivative downstream things? And if we can call those things out and just keep asking why, why, why, to sort of justify some of the direction you want to go in and then keep asking in what, what, what, in terms of what's the sort of true blast radius and domino effect of these decisions is the approach that we take at HubSpot, in my teams at least.

**中文翻译:**
如果我们能在概念上将这两者区分开来，我们就能避免犯错——即试图以一种最终导致客户体验变差的方式来解决业务问题。此外，我认为还要建立一个系统，让 PM 能够轻松地指出他们可能做出的假设。比如：如果我们这样做，你预测会有哪些衍生的下游影响？如果我们能指出这些，并不断追问“为什么、为什么、为什么”来证明你想走的方向是正确的，然后不断追问“什么、什么、什么”来明确这些决策的真实影响范围和多米诺骨牌效应。这就是我们在 HubSpot，至少在我的团队中采取的方法。

---

### [00:40:23] [Lenny]

**English:**
Awesome. Okay. So, I cut you off in this one bullet point so far. So, let's keep going.

**中文翻译:**
太棒了。好，到目前为止我只让你讲了一个要点。我们继续吧。

---

### [00:40:29] [Chris Miller]

**English:**
Yeah. So we're talking about the things that make HubSpot special. So, customer obsession is definitely one. I think where we play in the market, too. Being a company that has been comfortable staying in the mid-market, SMB mid-market space, and resisting the temptation to try to crawl up into enterprise software, I think makes us special. And one of the things that's actually really straightforward, which is that a lot of enterprise software companies, a lot of your revenue is tied up in a small subset of customers. And I think what can happen there is if those customers decide that they want you to build something and they're willing to threaten their business over it, then you'll end up building it. And is that necessarily the thing that is going to serve all your customers best? Probably not. Are you going to end up having to build and maintain bespoke software for one customer? Probably.

**中文翻译:**
好的。我们正在讨论让 HubSpot 特别的地方。客户痴迷肯定是其中之一。我认为我们在市场中的定位也是一点。作为一家安于留在中端市场、中小企业（SMB）中端市场，并抵制住向大型企业软件领域攀升诱惑的公司，我认为这让我们很特别。有一件事其实很直白：很多企业软件公司的大部分收入都集中在少数几个大客户身上。在这种情况下，如果这些客户决定让你开发某个功能，并以此威胁要撤资，你最终就不得不开发它。但这一定是能最好地服务于所有客户的东西吗？未必。你最终是否不得不为一个客户开发和维护定制软件？很有可能。

---

### [00:41:21] [Chris Miller]

**English:**
And don't get me wrong, I think there's a lot of product folks out there who enjoy that modality of work, I'm not one of them. And so, by playing in the mid-market, it means our revenue is distributed more evenly across our entire install base, which means that there's no single customer who can hold us hostage, really. But what that does is with great power comes great responsibility. I think what that does is the forcing function of ensuring that the decisions that we make are a net benefit for the largest swath of customers possible. And I think it really is the guiding light behind some of our decisions around connected experience and usability and user experience. And so, playing in the mid-market, I think affords us to be able to do that. So, I think that's another thing that makes us special for a company of our size.

**中文翻译:**
别误会，我知道有很多产品人喜欢那种工作模式，但我不是其中之一。通过深耕中端市场，这意味着我们的收入更均匀地分布在整个安装基数中，这意味着没有任何一个客户能真正要挟我们。但这带来的结果是：能力越大，责任越大。我认为这产生了一种强制机制，确保我们做出的决策能让尽可能广泛的客户群体受益。我认为这确实是我们关于互联体验、易用性和用户体验决策背后的指路明灯。所以，在中端市场竞争让我们有能力做到这一点。对于我们这种规模的公司来说，这是另一个让我们特别的地方。

---

### [00:42:10] [Chris Miller]

**English:**
Culture is another one. And I won't get into the culture code. I think a lot of folks have probably read it. If not, go check it out.

**中文翻译:**
文化是另一个点。我就不详细讲《文化法典》（Culture Code）了，我想很多人可能已经读过了。如果没有，去看看吧。

---

### [00:42:18] [Lenny]

**English:**
I don't know if people have heard of that. What is that?

**中文翻译:**
我不确定大家是否听说过。那是什么？

---

### [00:42:20] [Chris Miller]

**English:**
Yeah. Dharmesh, our co-founder, one of our fearless leaders, Dharmesh, one of the things he most famously did early on is he published the HubSpot culture code externally. You can Google it and find it anywhere. I think a lot of companies sort of replicated that over the years, but by being really open and transparent about the culture both internally and externally, I think one, it internally creates alignment and it gives everyone something to point to to enforce why did we choose to work with each other the way that we work with each other. I think it also helps in attracting the right type of candidates because we put it out there, we're sort of really open about it. If you don't like that culture, chances are you probably won't be super excited to work here. But if that's something that you're craving, and I think a lot of quality people crave a lot of the things that are sort of codified in our culture. Humility, empathy, adaptability, remarkability, transparency are sort of all things that I think people take quite seriously.

**中文翻译:**
是的。我们的联合创始人、无畏的领导者之一 Dharmesh，他早期最出名的一件事就是对外发布了 HubSpot 的《文化法典》。你可以谷歌搜索，到处都能找到。我想这些年来很多公司都效仿了这种做法。通过对内对外保持文化的公开透明，我认为首先它在内部创造了共识，让每个人都有据可依，明确我们为什么要以这种方式合作。其次，它也有助于吸引合适的候选人，因为我们把它摆在明面上。如果你不喜欢这种文化，你可能就不会想来这里工作。但如果你渴望这种文化——我认为很多优秀的人都渴望我们法典中明确的那些东西：谦逊（Humility）、同理心（Empathy）、适应力（Adaptability）、卓越（Remarkability）、透明（Transparency），这些都是大家非常看重的特质。

---

### [00:43:19] [Chris Miller]

**English:**
And so, being really open and honest about that. And being willing to sort of pressure test it on a regular basis, like is this still a company we want to be? We are growing really fast. What has changed? What conditions are still able to be supported with the culture we have codified today? What amendments might we need to make in terms of who we want to represent ourselves to be to our customers and how do we want to work with each other? And investing in that, hiring really good people that can help us scale that I think is something that makes HubSpot really special.

**中文翻译:**
所以，要对此保持真正的开放和诚实。并且愿意定期对其进行“压力测试”，比如：这还是我们想要成为的公司吗？我们增长得非常快，发生了什么变化？我们今天成文的文化还能支持哪些条件？在向客户展示我们的形象以及我们彼此合作的方式方面，我们需要做哪些修正？投资于此，并雇佣能帮助我们扩展这种文化的优秀人才，我认为这是让 HubSpot 真正特别的地方。

---

### [00:43:52] [Lenny]

**English:**
Amazing. I'm reading the culture code on the side here, and there's these little quotes that are really sweet. I really like this one, "Solve for the customer, not just their happiness, but also their success."

**中文翻译:**
太棒了。我正在旁边读《文化法典》，里面有一些非常贴心的小语录。我很喜欢这一条：“为客户解决问题，不仅是为了他们的快乐，更是为了他们的成功。”

---

### [00:44:04] [Chris Miller]

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:44:05] [Lenny]

**English:**
Wise.

**中文翻译:**
很有智慧。

---

### [00:44:07] [Lenny]

**English:**
This episode is brought to you by Merge. Every product manager knows how slow product development can get when developers have to build and maintain integrations with other platforms. Merge's Unified API can fully remove this blocker from your roadmap. With one API, your team can add over 180 HR, accounting, ATS, ticketing, CRM, file storage and marketing automation integrations into your product. You can get your first integration into production in a matter of days, and save countless weeks building custom integrations, letting you get back to building your core product. Merge's integration speed up the product development process for customers like Ramp, [inaudible 00:44:47], and many other fast-growing and established companies, allowing them to test their features at scale without having to worry about a never-ending integrations roadmap. Save your engineers countless hours, hit your growth targets and expedite your sales cycle by making integration offerings your competitive advantage with Merge. Visit merge.dev/lenny to get started, and integrate up to three customers for free.

**中文翻译:**
本期节目由 Merge 赞助。每位产品经理都知道，当开发人员必须构建和维护与其他平台的集成时，产品开发速度会变得多么缓慢。Merge 的统一 API 可以完全从您的路线图中移除这一障碍。通过一个 API，您的团队可以为您的产品添加超过 180 种人力资源（HR）、会计、招聘（ATS）、票务、CRM、文件存储和营销自动化集成。您可以在几天内将第一个集成投入生产，节省数周构建自定义集成的时间，让您重新专注于构建核心产品。Merge 的集成为 Ramp 等客户以及许多其他快速成长和成熟的公司加速了产品开发过程，使他们能够大规模测试功能，而无需担心永无止境的集成路线图。通过 Merge 将集成服务转化为您的竞争优势，为您的工程师节省无数小时，达成增长目标并缩短销售周期。访问 merge.dev/lenny 开始使用，并免费集成多达三个客户。

---

### [00:45:10] [Lenny]

**English:**
Is there anything really fun about the culture, like a fun thing that you all do that's a quirky HubSpot ritual?

**中文翻译:**
关于文化，有没有什么特别有趣的事情，比如你们会做的一些搞怪的 HubSpot 仪式？

---

### [00:45:17] [Chris Miller]

**English:**
Yeah, there's a ton, but I think there's definitely a very legitimate school of thought around how culture can both contribute to inclusion, but also, be a headwind to inclusion. I think a lot of the things that I might associate with HubSpot culture are very much rooted in a specific period of HubSpot, right? It was probably a pre-pandemic period. It was probably a period where we were all working in the same physical space. And so, there's a lot of inside jokes. And sometimes the things are rooted in very specific quirks of specific individuals who may not even be at the company anymore. And so, if you're someone who's joined the company in the past two or three years and that flies over your head-

**中文翻译:**
是的，有很多。但我认为确实有一种非常合理的观点，即文化既能促进包容性，也可能成为包容性的阻碍。我认为很多我联想到的 HubSpot 文化都深深植根于 HubSpot 的某个特定时期，对吧？那可能是大流行之前的时期，大家都在同一个物理空间工作。所以有很多内部梗。有时这些东西源于某些特定个人的怪癖，而这些人甚至可能已经不在公司了。所以，如果你是过去两三年加入公司的，那些梗你可能根本听不懂——

---

### [00:46:00] [Chris Miller]

**English:**
The company in the past two or three years, and that flies over your head. I think we have to ask ourselves, "What's the value of continuing to embrace these things?" And so I think what we've been doing over the years is taking inventory of the things that might have been considered part of HubSpot legacy culture and really trying to again, pressure test it. Does this continue to serve us today? And if not, we should be really comfortable of letting it go.

**中文翻译:**
……如果你是这两三年进来的，那些东西你可能完全没概念。我认为我们必须问自己：“继续保留这些东西的价值是什么？”所以这些年来我们一直在盘点那些可能被视为 HubSpot 遗产文化的东西，并再次尝试对其进行压力测试。这在今天还能继续为我们服务吗？如果不能，我们就应该坦然地放手。

---

### [00:46:24] [Chris Miller]

**English:**
But one of the things that I think is super dope that we do is we do this thing called PEER Week, which was something that popped up during the pandemic and the TLDR is that it's like an event for product and engineering; where travel changed with the pandemic and people don't get to see each other in person as much, but there's a couple of weeks in the summer in June where we fly everybody in either if you're in North America, we fly you to Cambridge. If you were in Europe somewhere, then we fly you to Dublin and we spend a week together.

**中文翻译:**
但我认为我们做的一件超级酷的事情是“PEER Week”。这是在大流行期间出现的，简单来说（TLDR），这是一个面向产品和工程团队的活动。大流行改变了差旅方式，大家见面的机会变少了。但在六月的夏天，会有那么几周，我们会把所有人接过来——如果你在北美，就飞到剑桥（马萨诸塞州）；如果你在欧洲，就飞到都柏林。我们会在一起待上一周。

---

### [00:46:56] [Chris Miller]

**English:**
There's not a ton of focus on just classic productivity. There's a ton of focus on building connections and safety and just getting to know people and who they are as human beings, but also, damn I forgot how much I missed whiteboarding. It's actually being able to get in a room with a physical whiteboard of people and work on some stuff. And so this is, I think the second year in a row, or second or third I don't remember, pandemic years have really fogged the brain... That we've done it. And it's one of the things I look most forward to every year is getting everybody in the same city to just hang out.

**中文翻译:**
我们并不太关注传统的生产力，而是非常关注建立联系、安全感，以及了解大家作为“人”的一面。而且，天哪，我都忘了我有多怀念白板讨论了。能和大家一起待在有物理白板的房间里研究东西，感觉太棒了。我想这已经是我们连续第二年，或者是第三年做了——大流行那几年的记忆有点模糊了。这是我每年最期待的事情之一：让大家聚在同一个城市，一起共度时光。

---

### [00:47:27] [Lenny]

**English:**
I love it. I keep peeking at these highlights and they're really interesting. So we're going to link to this culture code also in the show notes if you want to check it out. But anyway, let's focus on how HubSpot grows. And there's kind of two parts, in my mind there's just like, how did it start and what worked really well. You're actually on the inaugural team, I believe, of HubSpot's growth team and things worked out. Well done. I'm curious maybe just to start what you think you did so right, early on in the history of HubSpot to help it grow into the behemoth it has become. What was kind of the early success elements that were key?

**中文翻译:**
太棒了。我一直在偷看这些文化亮点，真的很有趣。我们会把《文化法典》的链接放在节目介绍里，感兴趣的可以去看看。言归正传，让我们关注 HubSpot 是如何增长的。在我看来，这分为两部分：它是如何开始的，以及什么方法奏效了。我相信你当时就在 HubSpot 增长团队的创始成员名单里，而且结果非常成功。干得漂亮。我很好奇，在 HubSpot 早期，你认为你们做对了什么，才帮助它成长为今天这样的巨头？早期的关键成功要素是什么？

---

### [00:48:31] [Chris Miller]

**English:**
I would say the early years of doing freemium. And for the record, there's definitely an iteration of the growth team before I joined that, you know really like Brian Balfour was the person who I would say injected that first dose of PLG DNA into HubSpot. So shout out to Brian. I want to make sure he gets the credit that he's owed.

**中文翻译:**
我会说是早期推行免费增值模式（freemium）。顺便说明一下，在我加入之前，增长团队肯定已经有过迭代了。Brian Balfour 是那个为 HubSpot 注入第一剂 PLG（产品驱动增长）基因的人。所以向 Brian 致敬，我要确保他得到应有的赞誉。

---

### [00:48:26] [Lenny]

**English:**
Yeah, we're going to have him on the podcast at some point. It's in the works.

**中文翻译:**
是的，我们打算在某个时候请他上播客，正在筹划中。

---

### [00:48:29] [Chris Miller]

**English:**
Yeah, he's a legend. Brian's great.

**中文翻译:**
是的，他是个传奇。Brian 很棒。

---

### [00:48:30] [Lenny]

**English:**
Absolute legend.

**中文翻译:**
绝对的传奇。

---

### [00:48:31] [Chris Miller]

**English:**
And so after Brian had left HubSpot, it was a bit start and stop. And so when I joined and we sort of took another stab at it, I think there were a few things we did. One, in the beginning is we really had an aggressive mentality, an aggressive approach I think. And by we, I mean the team, the actual really small initial growth team. We tried not to be pedantic about where we were spending our time. And so we sort of tossed our mission and charter out of the window. We said, cool, maybe on paper we were, I think the sales tool, activation team. It was a very boutique mission and remit compared to I think a lot of the other teams at HubSpot's missions and remit at the time.

**中文翻译:**
在 Brian 离开 HubSpot 后，增长工作曾一度断断续续。当我加入并再次尝试时，我认为我们做了几件事。第一，在开始阶段，我们确实拥有一种激进的心态和方法。我说的“我们”是指那个最初规模非常小的增长团队。我们尽量不拘泥于把时间花在哪里，甚至把原本的使命和章程抛到了脑后。我们说，好吧，虽然名义上我们是“销售工具激活团队”，与当时 HubSpot 其他团队的使命相比，这是一个非常小众的任务和职权范围。

---

### [00:49:21] [Chris Miller]

**English:**
But even though that's what we were supposed to be working on paper, we were sort of like, if we find something that looks like an opportunity and no one else in the business is thinking about it, we're just going to try to fix it. We're going to ask for forgiveness rather than permission and start to call some plays.

**中文翻译:**
但尽管纸面上那是我们的工作，我们当时的想法是：如果我们发现了一个看起来像机会的东西，而公司里没人在考虑它，我们就直接去尝试解决它。我们会采取“先斩后奏”的策略，开始制定并执行一些方案。

---

### [00:49:38] [Chris Miller]

**English:**
And what that looked like was at the time, a very small percentage of, I think HubSpot's subscription revenue would be described as self-service, like people putting in their credit card and buying something. It was predominantly product driven leads like PQLs. And so we were literally sending everything to the sales team, which it was running revenue, but certainly opportunities for efficiency because it was the first time we'd really had a product at a price point that could be transactional and not a highly considered purchase. And so we were thinking about this and we were like, "Well, how does this work? Is there even a pricing page in the product that people could actually buy something?"And we found it, but it had been neglected. It was sort of like, I think no one was sort of committing any code to that repository.

**中文翻译:**
具体情况是这样的：当时 HubSpot 的订阅收入中，只有极小一部分可以被称为“自助服务”（即人们直接刷信用卡购买）。大部分是产品驱动的线索，比如 PQL（产品合格线索）。所以我们当时几乎把所有东西都推给销售团队。虽然这能产生收入，但肯定有提升效率的空间，因为那是我们第一次拥有一个价格点足以支持直接交易、而不需要经过深思熟虑购买过程的产品。于是我们开始思考：“这到底是怎么运作的？产品里有没有一个定价页面能让人们直接购买？”我们找到了那个页面，但它一直被忽视，似乎没人往那个代码库提交过代码。

---

### [00:50:31] [Chris Miller]

**English:**
So we approached a team who owned it and we were like, "Are y'all working on this? Is this an active development?" And they were like, "Nah, we're working on a bunch of other stuff." We were like, "Can we take this?" And they were like, "Sure, if you want it, take it. It's one less code base for us to maintain." And so we took it and immediately blew it up. We redesigned the whole thing focused on discoverability, how are people getting to this page, focusing on desirability, like how are we talking about the value props of the things that we're wanting to sell to customers to help them grow better. And then thinking about doability or usability, how do we actually just remove the friction that's standing in the way?

**中文翻译:**
于是我们找到负责那个页面的团队问：“你们在搞这个吗？还在开发吗？”他们说：“没，我们忙着别的一堆事呢。”我们问：“那能交给我们吗？”他们说：“当然，如果你想要就拿去吧，我们还能少维护一个代码库。”于是我们接手了，并立即让它大变样。我们重新设计了整个流程，专注于“可发现性”（人们如何找到这个页面）、“渴望度”（我们如何描述产品的价值主张以帮助客户更好地增长），以及“可行性”或“易用性”（我们如何消除阻碍购买的摩擦）。

---

### [00:51:10] [Chris Miller]

**English:**
And so we did a mad dash towards this outcome we wanted to drive, and when we released it worked. It was actually a step function change in the way that the physics of the business and the funnel really looked. And I think that was probably a catalyst moment of everyone saying, "Oh wow, there might actually be something here." And so that attitude of saying that every problem is our problem and being willing to really take a mentality of like, I think radical accountability and ownership mentality helped us find opportunities that maybe the business wasn't explicitly asking us to solve, but we were able to triangulate why it might be important for the business for us to solve it.

**中文翻译:**
我们朝着想要推动的结果一路狂奔，发布后效果非常好。它实际上让业务逻辑和漏斗模型发生了阶梯式的变化。我认为那是一个催化剂时刻，让大家惊叹：“哇，这里面真的大有文章。”那种“所有问题都是我们的问题”的态度，以及极度的问责制和主人翁意识，帮助我们发现了一些业务部门可能并没有明确要求我们去解决的机会，但我们能够通过多方分析，推导出为什么解决这些问题对公司至关重要。

---

### [00:51:54] [Chris Miller]

**English:**
And when you do that, I think the business, a business may get more comfortable putting more on your plate. Right? And so it's like we look hungry, so let's keep feeding us. And so over time our remit expands and there's other things that we think are opportunities to gain leverage for the business or deliver a delight to our customers in a more efficient way, and honestly in a way that they probably expected to engage with us at that point in time. It was quite odd that there were so many humans involved in every stage of the customer journey and some of our customers just like, "I just want to be able to try the thing and buy it if I want to be. I really don't want to be forced into a sales engagement." And so it was really kind of meeting the expectations of the modern software buyer in many ways.

**中文翻译:**
当你这样做时，公司会更放心地把更多任务交给你，对吧？就像是我们看起来很饥渴，所以他们就不断投喂。随着时间的推移，我们的职权范围不断扩大，我们发现了其他可以为业务提供杠杆或以更高效的方式为客户提供愉悦体验的机会。坦率地说，那种方式也是当时客户期望与我们互动的方式。在客户旅程的每个阶段都有这么多人工参与，这其实挺奇怪的，有些客户会觉得：“我只想试用一下，如果想要就买。我真的不想被迫卷入销售洽谈。”所以，这在很多方面其实是满足了现代软件买家的期望。

---

### [00:52:41] [Lenny]

**English:**
It sounds incredibly important. Basically your team turned HubSpot into a very product led growth business, which feels very important in the history of HubSpot's growth. Would you consider what was there before where it was the beginnings of self-service, but they had to talk to a salesperson? Would you consider that product led?

**中文翻译:**
这听起来极其重要。基本上，你的团队将 HubSpot 转型为一家非常典型的产品驱动增长（PLG）企业，这在 HubSpot 的增长史上显得至关重要。你会认为在你们接手之前，那种虽然有了自助服务的雏形但仍需与销售人员交谈的模式是“产品驱动”的吗？

---

### [00:52:59] [Chris Miller]

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:53:00] [Lenny]

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:53:00] [Chris Miller]

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:53:00] [Lenny]

**English:**
And so how would you describe what the shift was in terms of the way the sales motion and growth motion changed?

**中文翻译:**
那么，你会如何描述销售模式和增长模式发生的变化？

---

### [00:53:07] [Chris Miller]

**English:**
The go-to-market motions that we were working on definitely fit under, I think the broad umbrella of PLG, but I don't think the culture of the company was necessarily explicit about being a PLG company. I don't think that's the way we talked about who HubSpot was and trust me, there were a bunch of other factors in here. I definitely, I won't say that our team were the sole driving force behind that shift in our strategy and approach, but certainly the data that we were able to collect and the experiments we were able to run and the insights we were able to surface and the research we were able to synthesize... It gave us conviction to double down on it for sure. And that was definitely maybe the beginning of that inflection point for the company, but there was certainly a lot of other things that led to us wanting to become more product led.

**中文翻译:**
我们当时正在进行的进入市场（GTM）动作确实属于 PLG 的大范畴，但我认为当时公司的文化未必明确自己是一家 PLG 公司。我不认为那是我们当时描述 HubSpot 的方式。相信我，这里面还有很多其他因素。我绝不会说我们的团队是战略和方法转变的唯一驱动力，但我们收集的数据、进行的实验、发现的洞察以及综合的研究，确实给了我们加倍投入的信心。那绝对是公司转折点的开始，但肯定还有很多其他因素促使我们想要变得更加以产品为驱动。

---

### [00:54:01] [Chris Miller]

**English:**
Again, I think about it, I think any company is probably searching for ways to operate more efficiently. And if your revenue is so tied to go-to-market headcount, it gets really hard to scale the bigger you get. And so I think there's an innate desire to want to be more non-linear in our growth. And I think us arriving at the right place at the right time created sort of alignment around what the path forward could look like. If we want to live in that world, how might we get there? And I think that's where we really fit into the equation. It's like, "Oh, we invest in this team. If we invest in the type of work this team is doing, that's how we're going to build efficiencies over time." And it's also, we like that because it's in line with what our customers are already expecting from us.

**中文翻译:**
再次强调，我认为任何公司可能都在寻找更高效运作的方法。如果你的收入与销售人员的数量紧密挂钩，那么规模越大，扩展就越难。所以我认为公司内部有一种天生的渴望，希望实现更非线性的增长。我认为我们在正确的时间出现在正确的地点，促成了关于未来路径的共识。如果我们想进入那个世界，该如何到达？我认为这就是我们发挥作用的地方。就像是：“噢，我们投资这个团队。如果我们投资这个团队正在做的工作，随着时间的推移，我们就能建立起效率。”而且，我们也喜欢这种方式，因为它符合客户对我们的期望。

---

### [00:54:47] [Lenny]

**English:**
And it sounds like you weren't like, "We need to be more product led." It was more just how do we get the sales process more efficient and the motion of growth more efficient and that emerged out of that.

**中文翻译:**
听起来你们当时并不是在喊“我们需要变得更以产品为驱动”，而更多是在想“我们如何让销售流程和增长动作更高效”，然后 PLG 就自然而然地从中产生了。

---

### [00:54:58] [Chris Miller]

**English:**
Yeah, I mean, don't get me wrong. We were definitely like, we need to be more product led. And I think that's actually the nuance here. You asked would I consider what we were doing product led growth? And I think the answer is absolutely, but that's because a fallacy that people, a lot of, I think maybe early stage founders or folks who are unfamiliar with chronic growth or maybe only know about it from an academic point of view, maybe fall into the trap of is assuming that in order to be a PLG company you can use that interchangeably with being a fully self-service business or fully self-service go-to market.

**中文翻译:**
是的，我的意思是，别误会，我们当时确实觉得需要更以产品为驱动。我认为这里的细微差别在于：你问我是否认为我们当时做的是产品驱动增长，我的回答是肯定的。但很多初创公司创始人或不熟悉增长的人，或者只从学术角度了解它的人，可能会陷入一个误区，认为“PLG 公司”等同于“完全自助服务的业务”或“完全自助服务的进入市场模式”。

---

### [00:55:34] [Chris Miller]

**English:**
I don't actually think that those things are one and the same. I think that most companies, at least the larger, more successful ones that have done amazing things and are cornering their market or category, that we would consider to be PLG companies have a bunch of humans working on really important things on their go to market, and it's more of a hybrid motion. And I think it's less about, again, being sort of myopic about your approach to PLG and having it being really rooted in principles that are, I think very kind of academic or conceptual in nature.

**中文翻译:**
我实际上并不认为这两者是一回事。我认为大多数公司，至少是那些做出了惊人成绩、垄断了市场或类别的成功大公司，虽然我们认为它们是 PLG 公司，但它们其实有很多员工在负责进入市场中非常重要的事情，这更多是一种混合模式。我认为，不应该对 PLG 的方法过于短视，也不应该仅仅将其植根于那些非常学术或概念性的原则。

---

### [00:56:08] [Chris Miller]

**English:**
But more sort of being pragmatic and saying, "Okay, cool. Who is our customer? What is the product that we sell? How are our customers used to buying this thing? How would they prefer to buy it in the future that they would like to live in? What's the packaging of our products? How do our customers decide? Is it a top down decision or a bottoms up decision? How complex are our building and subscription terms is something that's going to be pretty transactional or something that's going to be fairly considered? How comfortable is our target market with the technology in our category? Are we competing against non-consumption? Are we competing against competitors in the same category?"

**中文翻译:**
而应该更务实一些，问问：“好吧，我们的客户是谁？我们卖的是什么产品？客户习惯如何购买这种东西？在他们向往的未来，他们更倾向于如何购买？我们产品的包装是怎样的？客户如何做决定？是自上而下的决策还是自下而上的决策？我们的计费和订阅条款有多复杂？是纯交易性的还是需要深思熟虑的？我们的目标市场对我们这一类别的技术接受度如何？我们是在与‘不消费’竞争，还是在与同类别的竞争对手竞争？”

---

### [00:56:48] [Chris Miller]

**English:**
And if you actually answer those questions, and I think it may be obvious where I'm going with this, but based on the answer to those questions, the conditions on the ground might lend themselves to be more favorable to product-led growth and be more favorable to self-service, right? It's why there are companies that the value prop is just so... Like you don't need a person to sell you Loom. I use Loom and it's so intuitive that I can just decide on my own whether I want to buy it. You don't need a person to teach you how to use even Slack to some example. Like Slack is extremely intuitive. Right? Like you could throw someone in Slack and use a product in a similar paradigm and it can probably figure out the basics on their own.

**中文翻译:**
如果你真的回答了这些问题——我想你应该明白我的意思了——根据这些答案，实际情况可能会更有利于产品驱动增长，也更有利于自助服务，对吧？这就是为什么有些公司的价值主张非常直观……比如你不需要别人向你推销 Loom。我用 Loom，它非常直观，我可以自己决定是否购买。你也不需要别人教你如何使用 Slack。Slack 极其直观，对吧？你可以把某人丢进 Slack 或类似模式的产品中，他们可能自己就能摸索出基本用法。

---

### [00:57:25] [Chris Miller]

**English:**
There are certain products that don't necessarily check those boxes. And so I think what you can do is kind of take a more modular approach to PLG, and it's like based on how a customer in the best case scenario might go from zero to one when it comes to activation and onboarding, do we need to have a human involved in that process at all? Or as a backstop? If the answer is yes, then maybe figure out ways to have humans involved where your cost structure is durable or at least defensible. If that's not the case, then go take a PLG approach to it.

**中文翻译:**
有些产品并不一定符合这些条件。所以我认为你可以对 PLG 采取一种更模块化的方法。比如，根据客户在激活和入职（onboarding）过程中从 0 到 1 的最佳路径，我们是否需要人工参与？或者是否需要人工提供支持（backstop）？如果答案是肯定的，那么就想办法在你的成本结构可持续或至少可辩护的地方引入人工。如果不是这种情况，那就采取 PLG 的方法。

---

### [00:57:59] [Chris Miller]

**English:**
And so across our entire business, we've never taken a very pure, everything here for this line of business or this product line is going to be self-service without being able to defend and contextualize why across the entire customer journey this makes sense. And so yeah, we have customers who come in through the product led front door and kick the tires on the product on their own and activate on the product on their own. But then when it comes time to buy the product, they want to talk to somebody and there's legitimate reasons why, right? There are maybe IT and security concerns that they need to get somebody on the phone for. Maybe they're coming for a platform where data migration is a huge fear they have, and that's not something that's easy to do in a self-service environment yet. I think that's going to change over time. But today it's still kind of painful when you're doing rip and replaces.

**中文翻译:**
所以在我们的整个业务中，我们从未采取过那种极端的做法，即某个业务线或产品线必须完全自助服务，而不去论证为什么在整个客户旅程中这样做是合理的。所以，是的，我们有客户通过产品驱动的“前门”进来，自己试用产品并激活。但到了购买产品的时候，他们想找人聊聊，这有正当理由，对吧？可能存在 IT 和安全方面的顾虑，需要通过电话沟通。或者他们来自另一个平台，对数据迁移感到非常恐惧，而这在自助服务环境中目前还不易实现。我认为随着时间的推移这会改变，但在今天，进行“推倒重来”（rip and replace）式的迁移仍然挺痛苦的。

---

### [00:58:48] [Chris Miller]

**English:**
And so to try to brute force that into a sort of self-service motion for every customer writ large would be solving for your business' desires, not necessarily solving for the customer at the end of the day. But we also sell into different segments of customers that are maybe digital natives but not familiar with products in our category. And maybe they're coming from not a competing product, but they're coming from a more rudimentary system like spreadsheets. I mean, I've seen customers using post-it notes to manage their.

**中文翻译:**
因此，如果试图强行将这种流程转变为面向所有客户的自助服务模式，那是在满足你公司的愿望，而不是真正为客户解决问题。但我们也向不同的客户群体销售，他们可能是数字原住民，但不熟悉我们这一类别的产品。也许他们不是来自竞争产品，而是来自更原始的系统，比如电子表格。我的意思是，我甚至见过客户用便利贴来管理他们的……

---

### [00:59:25] [Lenny]

**English:**
[inaudible 00:59:25].

**中文翻译:**
（听不清）

---

### [00:59:25] [Chris Miller]

**English:**
The deal pipeline, the real old school way, and that was sort of their locus of control for their sales team. Right? And so there are use cases like that if you're a smaller team, you kind of have an acute understanding of the pain points that are like today's buyers that you need to put out. You don't have to deal with the burden of a huge data migration. And the person who is going to be in the CRM day in and day out is also the person who gets to make the final call on what CRM they're going to use. There's a ton of those customers that we never talk to in person, right? And that's awesome too. And so being comfortable with things not necessarily fitting into clean boxes and having conviction that a modular approach or a more hybrid approach is actually the way to optimize for the customer and the business at the end of the day is something that I think we embraced really early on.

**中文翻译:**
……交易管线，那种非常老派的方式，那是他们销售团队的控制核心，对吧？对于这样的小团队，你对他们当下的痛点有敏锐的理解。你不需要处理庞大的数据迁移负担。而且那个每天都要使用 CRM 的人，通常也是最终决定使用哪个 CRM 的人。有很多这样的客户，我们从未与他们面谈过，这也很棒。所以，接受事物不一定能整齐地归类，并坚信模块化或混合模式才是最终优化客户体验和业务效益的方法，这是我们很早就接受的理念。

---

### [01:00:17] [Chris Miller]

**English:**
One of the first metrics that I had was activation rate, but it was also how much demand am I sending to the sales team? And there was no turf war about that, right? It's like, oh, that's net positive for if people are able to get helped and a lot of the questions that they have cannot be answered with the product today, we should absolutely be proud to connect them with one of our awesome people in sales who can be like, help see if the solutions we offer are a good fit for them. And there are instances where people just don't want to talk to somebody, and our job is to make sure that there's a friction-free way for them to make that decision on their own.

**中文翻译:**
我最初的指标之一是激活率，但同时也包括我向销售团队输送了多少需求。这之间没有地盘之争，对吧？如果人们能得到帮助，而他们很多问题目前无法通过产品本身得到解答，那么我们绝对应该自豪地将他们引荐给优秀的销售同事，由销售来判断我们的方案是否适合他们。当然，也有一些情况人们就是不想和人说话，我们的工作就是确保他们有一种无摩擦的方式来独立做出决定。

---

### [01:00:48] [Lenny]

**English:**
Amazing. I think on the one hand, this could be a whole podcast is just talking about your PLG learnings, knowing... It feels like HubSpot is one of the biggest success stories of transitioning more and more into PLG, at least at that point. Even though you're saying it was PLG early on, it feels like a huge shift to the business. So I really like this framework you just shared of if you're trying to become more product led, just think about the zero to one from visit to activation and when does someone really have to talk to someone and how do we help them not have to talk to people in that moment? So either in that direction or just broadly, if someone was trying to explore how do we become more product led, what are the first couple steps and dives you would recommend they do to help them down that road?

**中文翻译:**
太棒了。我觉得光是谈论你的 PLG 心得就能做一整期播客。HubSpot 似乎是向 PLG 转型最成功的案例之一。尽管你说早期就是 PLG，但对业务来说这确实是一个巨大的转变。我很喜欢你刚才分享的框架：如果你想变得更以产品为驱动，就思考从访问到激活的 0 到 1 过程，思考什么时候人们真的必须找人聊聊，以及我们如何帮助他们在那个时刻不需要找人。顺着这个方向或者更广泛地说，如果有人想探索如何变得更以产品为驱动，你会推荐他们先做哪几步或进行哪些深入研究？

---

### [01:01:34] [Chris Miller]

**English:**
First I would ask, why do you want to be product led? What assumptions are you making in terms of why being product led are going to be net positive for the business or for your customers? And I might even ask them to define what product-led means to them that we can get on the same page of what we're even talking about.

**中文翻译:**
首先我会问：你为什么要变得以产品为驱动？你基于什么假设认为 PLG 会对业务或客户产生净收益？我甚至可能会要求他们定义一下“产品驱动”对他们意味着什么，这样我们才能在同一个频道上讨论。

---

### [01:01:52] [Lenny]

**English:**
How would you define it? Do you have a rough, an answer to that? Just so people get a sense of what it probably means.

**中文翻译:**
你会如何定义它？你有一个大致的答案吗？好让大家对它的含义有个概念。

---

### [01:01:58] [Chris Miller]

**English:**
Yeah. At the highest level, it's like taking a go-to-market approach where your product job is to grow revenue and you use humans as a backstop and not the other way around.

**中文翻译:**
是的。在最高层面上，它就像是一种进入市场的方法，其中产品的职责是增长收入，而你将人工用作支持（backstop），而不是反过来。

---

### [01:02:08] [Lenny]

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [01:02:09] [Chris Miller]

**English:**
And I think the key thing is that humans can be a backstop. There are moments where it's going to make sense for humans to be a backstop. One example that is I think is really normal, a hardship circumstance where a customer needs to end their relationship, right? Like every SaaS company deals with this. Some take a fully automated approach, but most usually have some sort of escalation path that will result in a human having to resolve this. It doesn't make them any less product led. I think every company at its core is having some humans behind the scenes interface with customers on things related to go-to-market. But I think once defining that and getting on the same page about that, I think you can learn a lot. And by the way, these are the normal conversations that I have with founders all the time. I'm actually an operator in residence at OpenView, and so I speak to a lot of their poor [inaudible 01:03:01], and this is usually the conversation that we end up having.

**中文翻译:**
我认为关键在于人工可以作为支持。在某些时刻，人工介入是有意义的。一个很常见的例子是：当客户需要终止合同这种困难情况时。每家 SaaS 公司都会遇到这种情况。有些公司采取完全自动化的方式，但大多数通常会有某种升级路径，最终需要人工来解决。这并不会让它们变得不那么“产品驱动”。我认为每家公司的核心都是有一些人在幕后就进入市场相关事务与客户沟通。一旦定义了这一点并达成共识，你就能学到很多。顺便说一下，这些是我经常与创始人进行的常规对话。我实际上是 OpenView 的入驻运营专家（Operator in Residence），所以我经常与他们的被投公司交流，这通常就是我们最终讨论的话题。

---

### [01:03:03] [Chris Miller]

**English:**
And I think what's always interesting is how different the sort of array of answers are when you ask that question. Some are like, oh, it's about top of the funnel demand. We want to be more product led because we want more leads, we want more signups. You're like, "Oh, okay." And that's a very defensible reason. There's a lot of data that shows that freemium products attract a lot more top of the funnel demand than sales led go-to-market products do. Right? Some, it might be a matter of constrained resources. We absolutely need to be more product led in the stage of the company because we simply cannot hire an army of implementation specialists and folks on the customer success outside of the house to help every single customer at scale, which is generally a byproduct of having a really large top of the funnel. And then there are others that are, it's about revenue efficiency.

**中文翻译:**
我觉得有趣的是，当你问这个问题时，得到的答案是多么五花八门。有些人会说：“噢，是为了漏斗顶端的需求。我们想变得更以产品为驱动，因为我们想要更多线索和注册。”你会觉得：“噢，好吧。”这是一个非常合理的理由。有很多数据表明，免费增值产品比销售驱动的产品能吸引更多的漏斗顶端需求。对吧？对另一些人来说，这可能是资源受限的问题：“在公司目前的阶段，我们绝对需要更以产品为驱动，因为我们根本雇不起一大群实施专家和客户成功人员来大规模地帮助每一个客户。”这通常是拥有巨大漏斗顶端流量后的副产品。还有一些人是为了收入效率。

---

### [01:04:34] [Lenny]

**English:**
Awesome. Maybe a couple more questions along these lines and then I just have a couple more questions I definitely want to ask. When someone is trying to go in the direction of product led growth, A.K.A. more self-service, and I guess maybe let me just ask, is that sort of how you think about the equivalency of those two?

**中文翻译:**
太棒了。关于这方面我再问几个问题，然后我还有几个一定要问的问题。当有人试图朝着产品驱动增长（即更多的自助服务）方向发展时——顺便问一下，你是否认为这两者是等价的？

---

### [01:04:50] [Chris Miller]

**English:**
Sure.

**中文翻译:**
可以这么说。

---

### [01:04:50] [Lenny]

**English:**
Okay. What are maybe the most common mistakes they make that aren't as obvious?

**中文翻译:**
好的。那么他们最常犯的、可能不那么明显的错误有哪些？

---

### [01:04:55] [Chris Miller]

**English:**
I mean, the number one mistake is hiring a head of growth, giving them no resources and expecting them to pull rabbit out of their hat. I feel like every PLG veteran has some joke that they tell about the poor head of growth who has no tooling, no engineering cycles, no designer, no access to data, and then are handed a really scary big number and told to go move it. I think that's a common mistake that has stood the test of time.

**中文翻译:**
我的意思是，头号错误就是雇了一个增长负责人，却不给他们任何资源，还指望他们能变出魔术来。我觉得每个 PLG 老兵都有类似的笑话：那个可怜的增长负责人没有工具、没有工程排期、没有设计师、接触不到数据，然后被塞了一个吓人的大目标，被要求去完成它。我认为这是一个经久不衰的常见错误。

---

### [01:05:28] [Chris Miller]

**English:**
Another one is expecting really quick turnaround and thinking of it the same way you might think about hiring a sales, an incremental sales headcount, which is that you're expecting near term liquidity from that investment, but when you're doing PLG at its core, it's still R&D. You're still sort of planting seeds with the hope that over time this is going to play out in the form of durable pie efficient growth. But if you're expecting, you put a team on something and then you want that team to sort of have outsize impact, and sure there's going to be low hanging fruit, but I think just not having the patience to see the investment through and cutting bait too early is another, I think mistake some companies make.

**中文翻译:**
另一个错误是期望极快的见效，并像增加销售人头一样看待它——即期望这项投资能带来短期变现。但当你做 PLG 时，其核心仍然是研发（R&D）。你是在播种，希望随着时间的推移，这能转化为持久且高效的增长。如果你指望派一个团队去做某件事，然后就想让他们产生巨大的影响——当然会有一些“低垂的果实”可以摘——但我认为，缺乏耐心去完成投资并过早放弃，是另一些公司常犯的错误。

---

### [01:06:20] [Chris Miller]

**English:**
And then I also think that bad data hygiene is the other one. So not having taken a beat to properly instrument their product, messy data, no real self-service way for people to access that data. Like having analyst bottlenecks can be a terrible position to be in. And so eating your veggies, getting your house in order from a data standpoint, I think is a crucial first step because if you can't actually measure what's happening, then like why?

**中文翻译:**
此外，我认为糟糕的数据卫生（data hygiene）是另一个问题。没有花时间对产品进行正确的埋点，数据混乱，没有真正的自助方式让大家获取数据。比如分析师成为瓶颈，这会让你陷入非常糟糕的境地。所以，“吃掉你的蔬菜”（意指做基础但枯燥的工作），从数据角度把家里打理好，我认为是至关重要的第一步。因为如果你无法实际衡量发生了什么，那做这些又是为了什么呢？

---

### [01:06:54] [Chris Miller]

**English:**
And then maybe the last one is people giving up because they don't have enough data, right? They're like, we can't do PLG because we don't have this massive data set the way that HubSpot has or the way the Airbnb has. And it's like you can still do PLG, you just need to use different data. The way we think about data is that quant data is just another form of data. The same way experiment results are just another data point. You can learn a ton from just talking to customers. Like qual research is super-duper important, and so if you don't have data to tell you exactly what every single person is doing in your product in aggregate, you can still talk to 10 customers and probably get a clear sense of what's happening and why it's happening. That you wouldn't even get from the quant data.

**中文翻译:**
最后一个可能是人们因为没有足够的数据而放弃。他们会说：“我们做不了 PLG，因为我们没有像 HubSpot 或 Airbnb 那样庞大的数据集。”但其实你仍然可以做 PLG，你只需要使用不同的数据。我们对数据的看法是：定量数据（quant data）只是数据的一种形式，就像实验结果只是一个数据点一样。你通过与客户交谈就能学到很多东西。定性研究（qual research）极其重要。所以，如果你没有数据能告诉你每个用户在产品中的总体行为，你仍然可以找 10 个客户聊聊，很可能就能清楚地了解发生了什么以及为什么发生。这些信息你甚至无法从定量数据中获得。

---

### [01:07:33] [Chris Miller]

**English:**
So people getting demotivated or companies getting demotivated because they think they're too early to do PLG, you can still do PLG. PLG at its core is just having your product sell the value prop of what your business does, and you can still deliver on that without being able to stand up a very robust and sophisticated experimentation practice.

**中文翻译:**
所以，那些因为觉得自己还处于早期而无法做 PLG 的人或公司，不要灰心，你仍然可以做。PLG 的核心只是让你的产品去推销你业务的价值主张，即使你还没有建立起非常稳健和复杂的实验体系，你仍然可以实现这一点。

---

### [01:07:53] [Lenny]

**English:**
Kind of along those lines, but going even broader. Without disclosing trade secrets of how HubSpot works, how would you describe the loop of growth of HubSpot? In the words of, you mentioned Brian Belfor and Fareed, what is the growth loop of HubSpot either now or recently? Just a simple way to think about how HubSpot grows.

**中文翻译:**
顺着这个思路，我们再扩展一下。在不泄露 HubSpot 商业机密的前提下，你会如何描述 HubSpot 的增长循环（growth loop）？用你提到的 Brian Balfour 和 Fareed 的话来说，HubSpot 现在或最近的增长循环是什么？有没有一种简单的方式来理解 HubSpot 是如何增长的？

---

### [01:08:12] [Chris Miller]

**English:**
Our loops are less tactical. In fact, if I'm being brutally honest, I think loops are kind of hard to achieve in B2B SaaS. I think there's some examples of that, but I think some of the best loops come from UGC, user generated content. I think a lot of B2C community focused platforms can do loops really well. I think if it's B2B SaaS, it's hard to find things that get loopy. And it is me going, I think all my Reforge [inaudible 01:08:40] are going to be upset that I said that. But I think that's the truth.

**中文翻译:**
我们的循环没那么具战术性。事实上，坦白说，我认为在 B2B SaaS 领域很难实现循环。虽然有一些例子，但我认为最好的循环来自于 UGC（用户生成内容）。很多以社区为核心的 B2C 平台可以把循环做得很好。但在 B2B SaaS 领域，很难找到能形成闭环的东西。我说这话可能会让我在 Reforge 的同事们不高兴，但我觉得这就是事实。

---

### [01:08:42] [Chris Miller]

**English:**
When I think about the flywheel of HubSpot, I think it's more of a macro flywheel. And just to kind of lean into our own lingo, it's really attracting gage and delight. And so, one of the principles that guides our thinking and our strategy is give value before you extract value. And I think that was at the core...

**中文翻译:**
当我想到 HubSpot 的飞轮时，我认为它更多是一个宏观飞轮。用我们自己的术语来说，就是“吸引、互动、愉悦”（Attract, Engage, Delight）。指导我们思考和战略的原则之一是：在获取价值之前先提供价值。我认为那是核心……

---

### [01:09:00] [Chris Miller]

**English:**
Give value before you extract value, and I think that was at the core of inbound marketing at its inception, that outbound marketing was asking for something from customers or prospects before giving anything. And so at its core it's like, okay, yeah, if you give a little for free, people who are interested in sort of hearing the rest of how that album sounds are going to come and stick around for more. And so in our pre PLG days, it was content marketing and white papers and listicles and eBooks and things that people had to download that were really filling the top of the funnel. And that is just taking another form with PLG.

**中文翻译:**
在获取价值之前先提供价值。我认为这是“入境营销”（Inbound Marketing）诞生之初的核心——传统的“出境营销”（Outbound Marketing）是在提供任何东西之前先向客户或潜在客户索取。所以其核心逻辑是：如果你免费提供一点东西，那些对“整张专辑听起来如何”感兴趣的人就会过来并留下来。在我们的前 PLG 时代，是内容营销、白皮书、列表文章、电子书以及人们需要下载的东西在填充漏斗顶端。而现在，PLG 只是让它换了一种形式。

---

### [01:09:39] [Chris Miller]

**English:**
And so we intentionally put out a lot of free software. And the idea is that this software is not sort of gimmicky. It's not designed to run out of value on day one. It's actually designed so that our smallest customers can get some value out of it in a sustainable way. But if they're engaging with it deeply enough, they're going to run into the limits of what that value is. And if we've done our jobs and delivered what we believe we were supposed to deliver, then the decision to purchase becomes a no-brainer.

**中文翻译:**
所以我们有意识地发布了很多免费软件。我们的理念是，这些软件不是噱头，不是第一天用完就没价值了。它的设计初衷是让最小的客户也能以可持续的方式从中获得价值。但如果他们使用得足够深入，就会触及这些价值的上限。如果我们尽到了职责，交付了我们认为应该交付的东西，那么购买决策就会变得顺理成章。

---

### [01:10:10] [Chris Miller]

**English:**
And if they're delighted with the experience of being a customer, they're going to become advocates, and they're going to become promoters, and they're going to tell their peers. Because what we also know is that a lot of small business owners and even medium-sized business owners take a lot of guidance from their community of peers. And sometimes that's a digital community, sometimes that's not. And so anytime we win an advocate through delivering an excellent customer experience, they bring more people into the top of the funnel. And so it's a really honest, and I would say an honest macro loop in the sense, but that's the way we think about our flywheel.

**中文翻译:**
如果他们对作为客户的体验感到愉悦，他们就会成为倡导者和推广者，并告诉他们的同行。因为我们也知道，很多小企业主甚至中型企业主会从他们的同行社区中获得很多指导。有时是数字社区，有时不是。所以，每当我们通过提供卓越的客户体验赢得一位倡导者时，他们就会把更多的人带入漏斗顶端。所以这是一种非常真诚的宏观循环，这就是我们思考飞轮的方式。

---

### [01:10:50] [Lenny]

**English:**
Oh man, this could be a whole other hour of a podcast just diving into this stuff. This is so good. You shared this interesting story that I wasn't aware of. So HubSpot's kind of known for content and SEO. You search for anything and there's always a HubSpot article about it. And so is what you're sharing here, essentially that was a big part of the early days, SEO, free content that drove people to the site and the product wasn't free, is what I'm hearing. And then it shifted to now it's a free product that anyone can use and that's what drives the top of funnel.

**中文翻译:**
天哪，深入探讨这些东西又能聊一个小时。这太棒了。你分享了一个我之前不知道的有趣故事。HubSpot 以内容和 SEO 著称，你搜任何东西总能看到 HubSpot 的文章。所以你刚才分享的意思是，早期很大一部分是靠 SEO 和免费内容把人吸引到网站，但当时产品是不免费的。然后现在转变为提供一个任何人都可以使用的免费产品，这成了驱动漏斗顶端的主力。

---

### [01:11:21] [Chris Miller]

**English:**
Yes, correct.

**中文翻译:**
是的，没错。

---

### [01:11:22] [Lenny]

**English:**
Amazing.

**中文翻译:**
太神奇了。

---

### [01:11:23] [Chris Miller]

**English:**
I can't give a specific number, but a large percentage of our revenue flows through the product. And it's not necessarily maybe where people ultimately purchased, but that's their sort of first conversion event with us. They were in the product, they liked what they saw, they spoke to somebody, and then eventually became a customer. And that is now a pretty robust top of the funnel for the company.

**中文翻译:**
我不能给出一个具体的数字，但我们很大一部分收入是流经产品的。这不一定是人们最终购买的地方，但那是他们与我们的第一次转化事件。他们在产品中，喜欢他们看到的东西，然后与某人交谈，最终成为客户。这现在已经成为公司非常稳健的漏斗顶端。

---

### [01:11:45] [Lenny]

**English:**
So I think this is a really interesting story of just starting with one growth channel of SEO essentially, content marketing and then shifting to something else. Is there any lessons from that experience for people trying to kickstart their growth of SEO versus this freemium approach? Is there anything there that just like this worked really well for us and you should probably try this, or SEO kind of runs out in this specific type of business?

**中文翻译:**
我认为这是一个非常有趣的故事：从 SEO（本质上是内容营销）这一种增长渠道开始，然后转向其他渠道。对于那些试图启动增长的人来说，关于 SEO 与这种免费增值模式的对比，有什么经验教训吗？有没有什么东西是“这对我们非常有效，你也应该试试”，或者“在特定类型的业务中，SEO 最终会遇到瓶颈”？

---

### [01:12:10] [Chris Miller]

**English:**
I'll admit I'm definitely not an SEO expert. I've been fortunate to work with some of the best marketers in the world who I think are bonafide legends at this point in terms of what they've been able to achieve at HubSpot and building that lead and signup machine. What I will say is being really aggressive about experimenting with new channels is so important, and diversifying your channel mix is so important because things can change overnight and that might disrupt your entire funnel. Like a Google algorithm change can have a massive impact. If you're reliant on app store optimization, a change in Apple's algorithm might have a massive impact. What we're seeing with generative AI, I think there's a lot of people losing sleep at night because it's unclear how this is going to impact SEO writ large. If that's what fuels your entire business is being on Google search result page, then what's going to happen in this new sort of world we're about to enter?

**中文翻译:**
我承认我绝对不是 SEO 专家。我很幸运能与世界上一些最优秀的营销人员合作，他们在 HubSpot 所取得的成就以及建立的那套线索和注册机器方面，绝对是传奇人物。我想说的是，积极尝试新渠道非常重要，渠道组合的多样化也极其重要，因为情况可能在一夜之间发生变化，从而破坏你的整个漏斗。比如谷歌算法的一次调整就可能产生巨大影响。如果你依赖应用商店优化（ASO），苹果算法的改变也可能有巨大影响。至于我们现在看到的生成式 AI，我想很多人都彻夜难眠，因为目前还不清楚这将如何影响整体 SEO。如果你的整个业务都靠出现在谷歌搜索结果页来驱动，那么在我们即将进入的这个新世界里会发生什么？

---

### [01:13:15] [Chris Miller]

**English:**
And so I think to the extent that you can not have your funnel be relying on a single or a couple of channels is really important. We're always testing new channels. One of the channels that we're spending some time experimenting with is this concept of microapps. And it's actually not a new concept for HubSpot. One of the first microapps you ever built was a... Maybe Dharmesh built this, the original one, but it was called Website Grader. And it was you put in your domain, and it crawled your site, and then gave you a set of recommendations for how you would optimize your site. And it was free. It was definitely a one trick pony. But what it did was it created an interesting conversation, which is like, okay, cool, now that you have this information, what are you going to do about it? And one of the things you could do is you could become a HubSpot customer and you can use our product to fix a lot of this stuff.

**中文翻译:**
所以我认为，尽可能不让你的漏斗依赖于单一或少数几个渠道是非常重要的。我们一直在测试新渠道。我们目前正在花时间实验的一个渠道是“微应用”（microapps）的概念。这其实对 HubSpot 来说不是新概念。我们最早构建的微应用之一是——可能是 Dharmesh 构建的最初版——叫做 Website Grader（网站评分器）。你输入你的域名，它会爬取你的网站，然后给你一套如何优化网站的建议。它是免费的，功能很单一。但它创造了一个有趣的对话契机：“太棒了，现在你有了这些信息，你打算怎么办？”其中一个选择就是成为 HubSpot 的客户，使用我们的产品来修复这些问题。

---

### [01:14:06] [Chris Miller]

**English:**
And that worked for us. It worked really, really well. And so we've done that play a few times and it's something that we'll probably continue to do. We have a bunch of these microapps. We have a brand kit generator, we have an email signature generator. We've experimented with a Build My Persona generator. There's a couple of ones that I can't talk about right now, but we'll learn a little bit about in a few weeks at Inbound. But yeah, microapps are an exciting new channel for us. And some will be successes, some will flop, and we'll probably sunset them. But being willing to fail in the pursuit of finding new distribution channels is also really important.

**中文翻译:**
那对我们非常有效，效果非常好。所以我们后来又玩了几次这种套路，并且可能会继续做下去。我们有一堆这样的微应用：品牌包生成器、邮件签名生成器，我们还实验过“构建我的画像”生成器。还有几个我现在不能说的，几周后的 Inbound 大会上大家会了解到。总之，微应用对我们来说是一个令人兴奋的新渠道。有些会成功，有些会失败，失败的我们就会关掉。但在寻找新分发渠道的过程中愿意接受失败，也是非常重要的。

---

### [01:14:44] [Lenny]

**English:**
That's an awesome insight. Is there a place people can go to find these microapps that you all have built?

**中文翻译:**
非常有见地。大家可以去哪里找到你们构建的这些微应用吗？

---

### [01:14:49] [Chris Miller]

**English:**
There will be soon.

**中文翻译:**
很快就会有了。

---

### [01:14:50] [Lenny]

**English:**
Oh, mysterious. I also noticed Dharmesh tweeting about some AI projects he's working on. Is that related to these microapps? Or is that just him on his own time just doing fun stuff?

**中文翻译:**
噢，真神秘。我也注意到 Dharmesh 在推特上发了一些他正在做的 AI 项目。那和这些微应用有关吗？还是只是他业余时间做的趣事？

---

### [01:15:00] [Chris Miller]

**English:**
Very related to microapps. I would say ChatSpot is actually, and for those who don't know what ChatSpot is, ChatSpot is a bit of an AI copilot that Dharmesh built that has sort of been very positively received by both HubSpot customers and non-HubSpot customers alike. And so that's something that we're, wearing my AI hat, spending a lot of time thinking about, sort of what direction do we want to go in the ChatSpot.

**中文翻译:**
和微应用非常有关系。我想说 ChatSpot 实际上就是——对于那些不知道 ChatSpot 的人来说，它是 Dharmesh 构建的一个 AI 副驾驶（copilot），受到了 HubSpot 客户和非客户的一致好评。所以作为负责 AI 的人，我正花大量时间思考 ChatSpot 的发展方向。

---

### [01:15:26] [Chris Miller]

**English:**
But again, it was something that we put out in the universe to see what happens. And now it's like, oh, we're getting an interesting amount of signups every month. Who would've guessed that? I don't think that... That definitely wasn't on the roadmap a year ago. And I think being a 17-year-old SaaS company that can still operate with that sense of urgency and pace helps a lot to why wait to get consensus on a decision when we can put something out there and then see what happens and see what the data says.

**中文翻译:**
但同样，这是我们推向世界看看会发生什么的东西。现在发现，每个月都有相当可观的注册量。谁能想到呢？一年前这绝对不在路线图上。我认为作为一家拥有 17 年历史的 SaaS 公司，仍然能以这种紧迫感和节奏运作，对我们帮助很大——既然我们可以直接发布产品看看结果和数据，为什么要等着达成共识再做决定呢？

---

### [01:15:58] [Lenny]

**English:**
Yeah, I was just going to say that it feels like it's such a win-win-win, including it's just a release for people on the team that have been there for a long time just to work on something totally different and new and just launch a new product.

**中文翻译:**
是的，我正想说这感觉是一个多赢的局面，包括对于那些在团队待了很久的人来说，这也是一种释放——可以去研究完全不同、全新的东西，并发布一个新产品。

---

### [01:16:08] [Chris Miller]

**English:**
Yeah, 100%.

**中文翻译:**
是的，百分之百。

---

### [01:16:10] [Lenny]

**English:**
I love that. Is there anything that just significantly accelerated growth in the last, I don't know, number of years that was like, wow, this really changed the game.

**中文翻译:**
我喜欢这个。在过去几年里，有没有什么事情显著加速了增长，让你觉得“哇，这真的改变了游戏规则”？

---

### [01:16:14] [Chris Miller]

**English:**
Covid. Covid was obviously challenging and awful on so many levels, but it was scary. It was super scary. We were all terrified. We didn't know what it meant for our jobs. My own sister, who also works at HubSpot now, she at the time was transitioning into hospitality and was two months into her job when she got furloughed because of Covid. So who knew what the world was going to look like and how it was going to impact businesses?

**中文翻译:**
新冠疫情。疫情在很多层面上显然是极具挑战且糟糕的，但它当时确实很吓人，超级吓人。我们都很恐惧，不知道这对我们的工作意味着什么。我亲妹妹（她现在也在 HubSpot 工作）当时正转型进入酒店业，刚工作两个月就因为疫情被停职了。所以当时谁知道世界会变成什么样，会对企业产生什么影响？

---

### [01:17:14] [Chris Miller]

**English:**
I think we were prepared for the worst, and we actually caught a bit of the Covid tailwind and a lot of other businesses did, because companies who never had to think about digital marketing all of a sudden had to, and it was urgent. It was a burning need for them to figure out how they were going to weather the storm. And I think one of the things that HubSpot did, and this is one of the sort of phrases we use internally, is never waste a good crisis.

**中文翻译:**
我想我们当时做好了最坏的打算，但实际上我们和很多其他企业一样，赶上了一点疫情的“顺风车”。因为那些从未考虑过数字营销的公司突然间不得不考虑了，而且非常紧迫。他们急需弄清楚如何度过难关。我认为 HubSpot 做对的一件事——这也是我们内部常说的一句话——就是“永远不要浪费一场危机”。

---

### [01:17:14] [Chris Miller]

**English:**
And so, one of the things we leaned into was sort of goodwill pricing, and we lowered the price on some of our tools and created some temporary leniency around certain things. And just the removal of that friction ended up being a really interesting tailwind for the business and specifically for the business that I run, which is our starter business, our free and starter business, we really accelerated growth during that period, which was not... I think if you would've looked at my Bingo card in March of 2020, I don't know that I had that on the Bingo card.

**中文翻译:**
所以，我们采取的行动之一是推行“善意定价”，降低了一些工具的价格，并在某些方面提供了临时的宽限。这种摩擦的消除最终成为了业务的一个非常有趣的助推力。特别是对于我负责的业务——我们的免费和入门级（Starter）业务——在那段时期增长显著加速。如果看我 2020 年 3 月的计划表，我绝对没预料到会发生这种事。

---

### [01:17:50] [Lenny]

**English:**
I'm looking at the stock price in another window here and I could see what happened. That went great, and even it came down with the whole market, but it's coming right back up. With that, we reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
我在另一个窗口看股价，我能看到发生了什么。表现非常棒，即使随大盘下跌过，但现在又涨回来了。至此，我们进入了非常令人兴奋的闪电问答环节。我有六个问题要问你，准备好了吗？

---

### [01:18:04] [Chris Miller]

**English:**
Yeah.

**中文翻译:**
准备好了。

---

### [01:18:06] [Lenny]

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:18:10] [Chris Miller]

**English:**
Truthfully, I don't read a ton of books. Got a one and a half year old. I also probably didn't read a ton of books before, but it's a nice excuse to have. That's why I don't have time to read today. But when I think of books that I think about a lot still, there's a book called Everybody Lies, and it's a book... I believe the guy who wrote it was a data scientist at Google. And part of the message is that everybody's a data scientist and really trying to democratize the idea of using data in your everyday lives to make decisions and demystifying the idea of data science.

**中文翻译:**
说实话，我不怎么读书。我有个一岁半的孩子，而且我以前可能也不怎么读书，但现在这成了一个很好的借口，解释我为什么没时间读书。但如果想到那些我至今仍经常思考的书，有一本叫《人人都在说谎》（Everybody Lies）。我相信作者曾是谷歌的数据科学家。书中的部分信息是“人人都是数据科学家”，它试图将日常生活中使用数据做决策的想法大众化，并揭开数据科学的神秘面纱。

---

### [01:19:15] [Chris Miller]

**English:**
But the way he kind of does this is through comparing Google search data and what we know people to be actively looking for answers for, with sort of qualitative survey data. And people lie on surveys all the time for a variety of different reasons, but no one lies to Google because it's transactional. If I lie to Google, I'm not going to get what I want. And so it kind of really explores what it means to tell the truth and how honest we are with ourselves and with the internet. And so I really love that book.

**中文翻译:**
他通过将谷歌搜索数据（我们知道人们在积极寻找答案的东西）与定性调查数据进行对比来实现这一点。人们出于各种原因经常在调查中撒谎，但没有人会对谷歌撒谎，因为那是交易性的。如果我对谷歌撒谎，我就得不到我想要的东西。所以它深入探讨了说实话意味着什么，以及我们对自己和互联网有多诚实。我非常喜欢那本书。

---

### [01:19:15] [Chris Miller]

**English:**
The other book I really love is Chop Wood Carry Water, which it's like a parable about a young boy who wants to become a samurai. But the sort of message of the book is about falling in love with the process, especially the most mundane parts of a process of becoming great at something. And that's something I... It's a good reminder about patience, humility, and sort of taking things one step at a time. And I often reference Chop Wood Carry Water a lot.

**中文翻译:**
另一本我非常喜欢的书是《劈柴担水》（Chop Wood Carry Water）。这是一个关于一个小男孩想成为武士的寓言。书的主旨是让你爱上过程，尤其是成为卓越之人的过程中最枯燥乏味的部分。这对我来说是一个很好的提醒，关于耐心、谦逊以及一步一个脚印。我经常引用这本书。

---

### [01:19:47] [Lenny]

**English:**
Reminds me of The Score Takes Care of Itself, I think is the name of the book.

**中文翻译:**
这让我想起一本书，名字好像叫《分数自会照顾好自己》（The Score Takes Care of Itself）。

---

### [01:19:51] [Chris Miller]

**English:**
Yeah, yeah, I've heard of it.

**中文翻译:**
是的，我听说过。

---

### [01:19:53] [Lenny]

**English:**
Bill Walsh. Amazing. Okay. What's a favorite recent movie or TV show?

**中文翻译:**
Bill Walsh 写的。太棒了。好，最近最喜欢的电影或电视节目是什么？

---

### [01:19:57] [Chris Miller]

**English:**
Oh, man. On Amazon Prime, I'm a Virgo, and it's a Boots Riley show. Boots Riley directed Sorry to Bother You. It just blew my mind. It's super surreal and funny and dark and it stars Jharrel Jerome, who I think he played one of the characters in the Netflix Central Park Five. I think he won a couple of awards for that too. And that was a show I watched recently where I had no expectations going into it other than I knew it was a Boots Riley show and was just enthralled. It touches on... It is a really cheeky way of touching on a lot of really important topics, but often hard to talk about topics and themes, and it's kind of delightful to get through it. So, I'm a Virgo. I just binged Barry from season one through four. Henry Winkler was spectacular. And then just came off of Succession, too. The theme here is I really dark comedies. Yeah, really, really dark comedies are kind of my thing.

**中文翻译:**
噢，天哪。Amazon Prime 上的《我是处女座》（I'm a Virgo），那是 Boots Riley 的剧。Boots Riley 导演过《抱歉打扰》。这部剧让我大开眼界，超级超现实、幽默且黑暗。主演是 Jharrel Jerome，他演过 Netflix 的《中央公园五人案》，还因此得过奖。我最近看这部剧时没抱什么期望，只知道是 Boots Riley 的作品，结果完全被迷住了。它以一种非常戏谑的方式探讨了很多非常重要但通常难以启齿的话题和主题，看完感觉很愉悦。除了《我是处女座》，我还一口气看完了《巴瑞》（Barry）的一到四季，Henry Winkler 的表演太精彩了。还有刚看完的《继承之战》（Succession）。我的主题就是黑色喜剧，非常非常黑的那种。

---

### [01:21:00] [Lenny]

**English:**
And that first one was called I Am a Virgo, because I thought you were just saying you're a Virgo.

**中文翻译:**
第一部叫《我是处女座》，我还以为你只是在说你的星座是处女座呢。

---

### [01:21:04] [Chris Miller]

**English:**
No, no. The name of the show is called I'm a Virgo. Yeah.

**中文翻译:**
不不，剧名就叫《我是处女座》。

---

### [01:21:07] [Lenny]

**English:**
Amazing. I will check that out. Okay. What's a favorite interview question you like to ask candidates?

**中文翻译:**
太棒了，我会去看看。好，你最喜欢问应聘者的面试问题是什么？

---

### [01:21:12] [Chris Miller]

**English:**
I think it depends on what level of role that they're interviewing for. I don't really interview as many frontline PMs anymore, but I used to really like doing case study questions and really random ones too. I'd be like, "Tell me how many people crossed the Longfellow Bridge in a week." And I could not care less what the actual number they arrived at was, but it's more for me to observe what's the array of data points that they can kind of start to collect in their mind to inform their calculus, and how close can they get to ballpark, and what's their defense behind their thinking. And then just the process of watching people's brains move in those moments is... You learn a lot about how they might operate as a product manager I think in those scenarios.

**中文翻译:**
我认为这取决于他们面试的职位级别。我现在不太面试一线 PM 了，但我以前非常喜欢问案例分析题，而且是非常随机的那种。我会问：“告诉我一周内有多少人穿过朗费罗桥（Longfellow Bridge）。”我一点也不在乎他们得出的具体数字，我更想观察的是他们脑子里能收集到哪些数据点来辅助计算，他们能多接近估算值，以及他们如何为自己的思路辩护。在那个时刻观察人们大脑运转的过程……我认为在那种场景下，你能学到很多关于他们作为产品经理如何运作的信息。

---

### [01:22:23] [Chris Miller]

**English:**
I try not to overdo them, because I do think there's a lot of inherent bias in some of those types of questions. And so trying to think of things that are really relatable to anybody who might be looking to work on a team that I'm leading is I think a requirement there. But I would say the other question I really like to ask is, if the people that you most recently worked with were in a room and you weren't there, how would they talk about you? One, it's because sometimes I will reach out and get references, and so the extent to which that might actually be part of the interview process is very legitimate, but also I think it is usually very clear whether the person is taking an honest and introspective and self-aware approach to answering that question.

**中文翻译:**
我尽量不过度使用这些题，因为我觉得这类问题存在很多固有偏见。所以，想出一些与任何想加入我团队的人都相关的问题是基本要求。但我最喜欢问的另一个问题是：“如果你最近合作过的人都在一个房间里，而你不在场，他们会如何评价你？”首先，因为我有时会去做背景调查，所以这作为面试的一部分是非常合理的。其次，我认为通常能很清楚地看出一个人在回答这个问题时是否诚实、有反思精神且具备自我意识。

---

### [01:23:17] [Chris Miller]

**English:**
And I like to see people being really self-aware, because I don't think anybody ever comes in any situation perfect. I have a lot of rough edges to my personality that I think people have just learned to deal with over the years, but I try to be self-aware about them at the... If I can do nothing else, if I can't change them, at least recognize them and do what I can to mitigate the blast radius. And so I think just getting a sense of the EQ of a candidate and their self-awareness is really important for me because at the end of the day, if you're in product, you can be the smartest person in the room, but if people don't want to work with you, you're probably not going to go very far.

**中文翻译:**
我喜欢看到人们非常有自我意识，因为我不认为有人在任何情况下都是完美的。我的性格中也有很多棱角，我想这些年来大家已经学会了如何应对，但我努力保持自我意识……如果我做不了别的，如果我改不了它们，至少要识别它们，并尽我所能减轻其负面影响（blast radius）。所以，了解候选人的情商和自我意识对我来说非常重要，因为归根结底，如果你做产品，你可以是房间里最聪明的人，但如果大家不想和你共事，你可能走不了多远。

---

### [01:23:32] [Lenny]

**English:**
Do you have a favorite life motto that you come back to or you share with other people?

**中文翻译:**
你有没有什么最喜欢的人生格言，是你经常回想或分享给别人的？

---

### [01:23:38] [Chris Miller]

**English:**
The details matter.

**中文翻译:**
细节至关重要。

---

### [01:23:39] [Lenny]

**English:**
And that's both in work and life, I imagine?

**中文翻译:**
我想这在工作和生活中都适用吧？

---

### [01:23:41] [Chris Miller]

**English:**
Yeah, the details matter. The details matter. I read a cool interview with the product leadership team at Stripe, and one of the things they talk about is for their product managers, they want you to have taste. And it was a really kind of controversial thing to say because it was like, "Oh, that is so subjective. Who gets to decide what taste is?" Maybe that's even biased to some extent.

**中文翻译:**
是的，细节至关重要。我读过一篇对 Stripe 产品领导团队的精彩采访，他们提到的一点是，他们希望产品经理拥有“品味”（taste）。这其实是一个挺有争议的说法，因为大家会觉得：“噢，那太主观了。谁来决定什么是品味？”甚至在某种程度上可能存在偏见。

---

### [01:24:07] [Chris Miller]

**English:**
And I think they had a super defensible answer about how they define taste, and taste in their opinion was to be so interested in something, it doesn't matter what that thing is, where you can go deep enough in it to have a strong set of informed opinions. And that's how they defined it. And they were almost ambivalent to what that thing that was, what the subject was. But having taste, having something that you were passionate about, that you have spent enough time learning and understanding and appreciating and critiquing and being frustrated with that you have a point of view that is potentially even polarizing is taste. Riding the fence is usually not taste. And so when I think about the details matter, that's almost like a nod to taste. Obsess over the details of something, whether that be art, music, product, film, whatever. I care a lot about that.

**中文翻译:**
但我认为他们对“品味”的定义非常有说服力。在他们看来，品味就是对某件事物（无论是什么）产生极大的兴趣，并能深入研究到足以形成一套强有力的、有理有据的见解。这就是他们的定义。他们几乎不在乎那个事物或主题是什么。但拥有品味，意味着你对某件事充满激情，你花了足够的时间去学习、理解、欣赏、批判，甚至为此感到沮丧，以至于你拥有一个甚至可能具有两极分化倾向的观点。当“墙头草”通常不是品味。所以当我想到“细节至关重要”时，这几乎是对品味的一种认可。痴迷于某件事的细节，无论是艺术、音乐、产品、电影还是其他任何东西。我非常看重这一点。

---

### [01:25:11] [Lenny]

**English:**
I love that. And that comes back to a lot of the things we've talked about of talking to customers, looking the data, actually having the firsthand information on what people need and what people want from your product.

**中文翻译:**
我喜欢这个观点。这又回到了我们讨论过的很多话题：与客户交谈、查看数据，真正掌握关于人们对你产品需求的第一手信息。

---

### [01:25:22] [Chris Miller]

**English:**
Yeah, absolutely.

**中文翻译:**
是的，绝对如此。

---

### [01:25:24] [Lenny]

**English:**
Okay. I'm just going to ask two more, and I'll let you go. What is a favorite product that you've recently discovered that you love?

**中文翻译:**
好，我最后再问两个问题就放你走。你最近发现并喜爱的产品是什么？

---

### [01:25:30] [Chris Miller]

**English:**
I fell in love with golf right before the pandemic, but the pandemic really is when I lost my mind and was obsessed with golf. It was one of the few safe things that you could do outside that was social and less dangerous than getting a drink with your buddy at the bar. That's the joke. It's like men invented golf so they could go on walks with each other, and that's essentially what kind of drove the interest in golf. And I also was horrible at it when I first started.

**中文翻译:**
我在疫情前爱上了高尔夫，但真正让我疯狂痴迷是在疫情期间。那是少数几种你可以在户外进行的、具有社交性且比去酒吧和哥们儿喝酒更安全的活动。有个笑话是：男人发明高尔夫是为了能一起散步。这基本上就是我产生兴趣的原因。而且我刚开始打得烂透了。

---

### [01:25:59] [Chris Miller]

**English:**
And so I think also as you get older and maybe you get more established in your career, or I've been in a product-led growth sort of lane for a while. You almost forget what it's like to be really bad at something until you have a kid and then everything's new and you're failing every day. But golf was a refreshing, consistent experience of frustration and inadequacy and just really embracing that and just waiting in it for a while knowing that it's just going to take cycles and time to get better and better. It was something I got really addicted to, and so I tried to play golf whenever I can, and most recently I bought a Garmin watch, and that thing is just magical. You roll up to the first tee box, you look at your watch, it knows exactly where you are, which golf course. Sometimes it'll even tell you which tees you're at, because in golf sometimes you're further back and sometimes you're further ahead, and it tracks your swings, it tells you distances.

**中文翻译:**
我想，随着年龄增长，或者职业生涯变得更稳固，或者像我已经在 PLG 领域待了很久，你几乎会忘记“对某件事一窍不通”是什么感觉，直到你有了孩子，一切都是新的，你每天都在失败。但高尔夫是一种令人清新的、持续的挫败感和无能感体验。你要真正拥抱这种感觉，沉浸其中，知道这需要时间和周期才能变得越来越好。我对此非常上瘾，只要有空就去打球。最近我买了一块 Garmin 手表，那东西简直太神奇了。你走到第一个发球台，看一眼手表，它就知道你在哪个球场。有时它甚至能告诉你你在哪个发球台，因为它能追踪你的挥杆并告诉你距离。

---

### [01:26:57] [Lenny]

**English:**
That's insane.

**中文翻译:**
太疯狂了。

---

### [01:26:57] [Chris Miller]

**English:**
It reads the greens for you.

**中文翻译:**
它还能帮你读果岭。

---

### [01:26:58] [Lenny]

**English:**
Wow. I just want to play golf just to use that watch.

**中文翻译:**
哇，我为了用那块表都想去打高尔夫了。

---

### [01:27:01] [Chris Miller]

**English:**
Oh my gosh, some of the guys that I golf with, a couple of them had one recently and I just was enthralled by it and I literally went home and ordered it that same day. And it's been the coolest product or gadget that I bought in a while.

**中文翻译:**
噢天哪，和我一起打球的几个人最近买了一块，我完全被迷住了，当天回家就下单了。这是我最近买过的最酷的产品或小玩意儿。

---

### [01:27:15] [Lenny]

**English:**
Damn. I love it. And I was also thinking as you were talking about getting into golf connects back to your relentless curiosity and resilience that you look for in people that you hire. So clearly you have it yourself. Final question, I believe you have a dog named Ferney, which is short for Fernet.

**中文翻译:**
太棒了。我刚才还在想，你爱上高尔夫这件事正好呼应了你在招聘时看重的“持续的好奇心”和“韧性”。显然你自己就具备这些特质。最后一个问题，我相信你有一条叫 Ferney 的狗，那是 Fernet（苦味利口酒）的缩写。

---

### [01:27:31] [Chris Miller]

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:27:31] [Lenny]

**English:**
Okay. So on that note, what is your favorite current cocktail, if it's not just a shot of Fernet?

**中文翻译:**
好，既然如此，你目前最喜欢的鸡尾酒是什么？如果不仅仅是一小杯 Fernet 的话。

---

### [01:27:36] [Chris Miller]

**English:**
The nightcap is always a shot of Fernet. Sometimes you might mix a little Coca-Cola with that. I think, where do they do that? Is that Spain?

**中文翻译:**
睡前酒总是一小杯 Fernet。有时你可能会往里兑点可口可乐。我想想，哪儿的人这么喝？是西班牙吗？

---

### [01:27:46] [Lenny]

**English:**
I have not heard of that.

**中文翻译:**
我还没听说过这种喝法。

---

### [01:27:47] [Chris Miller]

**English:**
Or Argentina. I don't know. It's definitely a country that that's a thing. My wife has been really into really high quality margaritas, made at home, and we're big into Aperol Spritz in the summer, so I would say that that's usually what dominates the happy hour rotation these days.

**中文翻译:**
或者是阿根廷。我不知道，反正肯定有个国家流行这么喝。我妻子最近迷上了在家做高品质的玛格丽特（Margaritas），而夏天我们非常喜欢 Aperol Spritz。所以我会说，这些就是目前占据我们欢乐时光的主角。

---

### [01:28:06] [Lenny]

**English:**
I just had an Aperol. Is it Aperol? Aperol Spritz, right?

**中文翻译:**
我刚喝过 Aperol。是叫 Aperol 吗？Aperol Spritz，对吧？

---

### [01:28:09] [Chris Miller]

**English:**
Yeah. I'm not good at pronunciation. It's probably one of those two.

**中文翻译:**
是的。我不擅长发音，大概就是其中一个。

---

### [01:28:12] [Lenny]

**English:**
I just had that for the first time. It's amazing. That's going to be my new go-to.

**中文翻译:**
我最近第一次喝，太棒了。那将成为我的新宠。

---

### [01:28:16] [Chris Miller]

**English:**
You had an Aperol Spritz for the first time recently?

**中文翻译:**
你最近才第一次喝 Aperol Spritz？

---

### [01:28:18] [Lenny]

**English:**
Yes. I didn't know what that was.

**中文翻译:**
是的，我以前不知道那是什么。

---

### [01:28:21] [Chris Miller]

**English:**
That was like the zeitgeist a couple summers ago and then there, oh man. There's the other one too. The Negroni Sbagliatos are having a moment too. It's like a Negroni with Prosecco. I forget.

**中文翻译:**
那是前几个夏天的流行风向标。噢天哪，还有另一个。Negroni Sbagliato 最近也很火，就像是把金酒换成普罗塞克起泡酒的内格罗尼。我记不清了。

---

### [01:28:36] [Lenny]

**English:**
Ooh, that sounds amazing. There's so much knowledge to be gained in this podcast episode. Chris, this was incredible. Thank you so much for being here. Two final questions. Where can folks find you online if they want to reach out and maybe ask you a question or two. And two, how can listeners be useful to you?

**中文翻译:**
噢，听起来很棒。这期播客里能学到的知识太多了。Chris，这太精彩了，非常感谢你能来。最后两个问题：如果大家想联系你或者问一两个问题，可以在哪里找到你？第二，听众可以如何帮到你？

---

### [01:28:52] [Chris Miller]

**English:**
You can connect with me on LinkedIn. Shoot me a message. Christopher Miller. There's a lot of Christopher Millers. I'm the one that looks like me, works for HubSpot. I have a Twitter. I don't spend ton of time... X. I have an X account, but I don't spend a lot of time on the app, formerly known as the bird app, but I'm on Instagram @millsyjoeyoung, which is a nod to one of my favorite old monster films, Mighty Joe Young. And so yeah, I'm on Instagram a bunch, too. That's where you can find me.

**中文翻译:**
你可以在 LinkedIn 上联系我，给我发消息。搜 Christopher Miller，有很多同名的，我是长得像我、在 HubSpot 工作的那个。我有推特……也就是 X 账号，但我不太花时间在那个以前叫小鸟的应用上。我在 Instagram 上的账号是 @millsyjoeyoung，这是致敬我最喜欢的老怪兽电影《巨猩乔扬》（Mighty Joe Young）。所以是的，我也经常上 Instagram。你可以在这些地方找到我。

---

### [01:29:20] [Lenny]

**English:**
Then I know two other things that you wanted to share. One is that you advise on PLG and things like that, so maybe talk about that real briefly. And then also you're hiring at HubSpot, or can people know about that?

**中文翻译:**
我还知道你想分享另外两件事。一是你提供关于 PLG 等方面的咨询，可以简要谈谈。二是你正在 HubSpot 招聘，大家可以了解一下吗？

---

### [01:29:31] [Chris Miller]

**English:**
I definitely do a bit of angel investing and advising companies on the side, and I really enjoy it. I think there's something really cool and awesome about getting to see fresh problems all the time and not necessarily being so laser focused on the sort of categories or verticals or target customers that you're dealing with for 40 plus hours a week. And so it's kind of refreshing to spend time with founders who are working on products in different categories and having different challenges at different stages of growth and being able to figure out how I can be a resource to them. And so if you're looking for, if that sounds interesting to you, you're a founder or head of product out there, definitely reach out and maybe opportunities for us to collaborate and maybe that can be a resource.

**中文翻译:**
我确实在业余时间做一些天使投资和公司咨询，我非常享受。我觉得能不断看到新鲜的问题是一件非常酷的事情，而不必总是盯着你每周工作 40 多个小时所面对的那些类别、垂直领域或目标客户。所以，与那些在不同领域开发产品、在不同增长阶段面临不同挑战的创始人交流，并弄清楚我如何能成为他们的资源，这让我感到很有活力。所以，如果你是创始人或产品负责人，觉得这听起来很有趣，一定要联系我，也许我们有合作的机会。

---

### [01:30:21] [Lenny]

**English:**
Cool. And then on the hiring front, any specific roles you want people to know about that you might be hiring?

**中文翻译:**
太好了。关于招聘，你有什么具体的职位想让大家知道吗？

---

### [01:30:25] [Chris Miller]

**English:**
There'll definitely be more roles opening up in the fall, but I think most immediately I'll be looking for a group product manager to work on the AI platform team that I'm leading.

**中文翻译:**
秋天肯定会有更多职位开放，但目前最紧迫的是，我正在为我领导的 AI 平台团队寻找一名 GPM（集团产品经理）。

---

### [01:30:35] [Lenny]

**English:**
What a role.

**中文翻译:**
真是个好职位。

---

### [01:30:37] [Chris Miller]

**English:**
Yeah, it's a great role with a fantastic team and a space that might be a little important these days. And so if you go to the HubSpot job site, that role should be there by the time this podcast is live. That role should definitely be up there.

**中文翻译:**
是的，这是一个很棒的职位，有一支优秀的团队，而且这个领域在当下非常重要。所以如果你去 HubSpot 的招聘网站，在这个播客上线时，那个职位应该已经在上面了。

---

### [01:30:50] [Lenny]

**English:**
Amazing. Chris, thank you again for being here.

**中文翻译:**
太棒了。Chris，再次感谢你的到来。

---

### [01:30:53] [Chris Miller]

**English:**
Lenny, pleasure. Thank you for having me. This has been amazing.

**中文翻译:**
Lenny，我的荣幸。谢谢你邀请我，这次交流太棒了。

---

### [01:30:56] [Lenny]

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。