# Claire Butler - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Claire Butler from Figma.

---

### [00:00:00] Claire Butler

**English:**
We had Coda. They were our first user, and they were based in Palo Alto. Dylan and I drove down and demoed the product to them, and they were the first ones. Their designer, Jeremy was like, "Yes, we'll take this on full time." And I remember we were both like, "What? Really? You will?" That was the first person who said yes to us. And so, we were so excited. This was a huge milestone. We were just so stoked. And then we got back to the office, and I think Dylan gets a text from Jeremy being like, "Oh yeah, I tried to share this with Philippe, my engineer, and he can't get the file to open, so I guess we can't use it." And we're like, "What is it? What happened?" Finally got someone. And I remember Dylan was like, "Everybody drop everything. We have to fix this."

**中文翻译:**
我们当时有 Coda 这个客户。他们是我们的第一个用户，总部在帕罗奥图（Palo Alto）。我和 Dylan 开车过去给他们演示了产品，他们是第一批用户。他们的设计师 Jeremy 说：“好，我们会全职使用这个工具。” 我记得当时我们俩的反应都是：“什么？真的吗？你们真的会用？” 那是第一个对我们说“好”的人。所以我们非常兴奋。这是一个巨大的里程碑，我们简直乐坏了。结果等我们回到办公室，Dylan 收到 Jeremy 发来的一条短信，说：“哦对了，我试着把这个分享给我的工程师 Philippe，但他打不开文件，所以我想我们没法用了。” 我们当时就懵了：“怎么回事？发生什么了？” 好不容易才争取到一个客户。我记得 Dylan 当时说：“所有人放下手头的一切工作，我们必须解决这个问题。”

---

### [00:00:37] Claire Butler

**English:**
And after some looking at the servers and things, they were like, "Nothing's wrong." And then they realized there's a problem with Philippe's MacBook. And Evan down only had a car, so Dylan had to drive Evan down to Palo Alto to fix the MacBook of Philippe just to get them to use the product.

**中文翻译:**
在检查了服务器之类的一通操作后，大家觉得“没问题啊”。然后他们意识到是 Philippe 的 MacBook 出了问题。当时只有 Evan 有车，所以 Dylan 不得不载着 Evan 赶到帕罗奥图去修 Philippe 的电脑，仅仅是为了让他们能用上我们的产品。

---

### [00:00:55] Lenny

**English:**
Welcome to Lenny's podcast, where I interview world-class product leaders and growth experts to learn from their hard one experiences building and growing today's most successful products. Today my guest is Claire Butler. Claire started at Figma while they were still in stealth as their 10th employee and their first ever marketing hire. She led their original launch and go-to-market and also their branding and positioning and messaging work. And eight years in, she continues to lead their go-to-market and bottom-up growth motion along with community events, social advocacy, and Figma for education teams.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的跨国产品负责人和增长专家，学习他们在打造和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Claire Butler。Claire 在 Figma 还处于隐身模式（stealth mode）时就加入了，是公司的第 10 号员工，也是第一位营销人员。她领导了 Figma 最初的发布和进入市场（GTM）策略，以及品牌塑造、定位和信息传递工作。加入八年后，她依然在领导公司的进入市场策略和自下而上（bottom-up）的增长引擎，同时还负责社区活动、社交倡导以及 Figma 教育团队。

---

### [00:01:26] Lenny

**English:**
In our conversation, we get the first ever in-depth glimpse into how Figma grew and continues to grow. Claire shares her two-part go-to-market strategy, which involves getting ICs at a company to love you and then enabling them to spread the product within the organization. She shares tons of amazing stories and examples and lessons from how the Figma team executed the strategy and how you can apply it to your own product. This is an incredible episode with so many gold nuggets of wisdom. You'll probably want to listen to it more than once. With that, I bring you Claire Butler after a short word from our sponsors. 

**中文翻译:**
在我们的对话中，我们将首次深入了解 Figma 是如何成长并持续壮大的。Claire 分享了她的两步走市场策略：首先让公司的个人贡献者（ICs）爱上你的产品，然后赋能他们让产品在组织内部传播。她分享了大量精彩的故事、案例和教训，讲述了 Figma 团队如何执行这一策略，以及你如何将其应用到自己的产品中。这是一个非常精彩的章节，充满了智慧的金句。你可能想多听几遍。在听完赞助商的简短介绍后，让我们欢迎 Claire Butler。

---

### [00:02:05] Lenny (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Calm, Quora, and Modern Treasury trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs and get ready for audits in weeks, not months. By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27001, GDPR, HIPAA, and many more, Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 best growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time, Lenny's podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny. That's V-A-N-T-A.com/lenny to learn more and to claim your discounts. Get started today. 

**中文翻译:**
本期节目由 Vanta 赞助。Vanta 帮助你简化安全合规流程，加速业务增长。数千家快速成长的公司，如 Gusto、Calm、Quora 和 Modern Treasury，都信任 Vanta 来帮助他们构建、扩展、管理和展示其安全合规计划，并在几周而非几个月内完成审计准备。通过提供最热门的安全和隐私框架（如 SOC 2、ISO 27001、GDPR、HIPAA 等），Vanta 帮助公司获取加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5000 家优秀企业使用 Vanta 自动完成 SOC 2 等框架高达 90% 的工作。在限定时间内，Lenny 播客的听众可享受 1000 美元的优惠。访问 vanta.com/lenny 了解更多信息并领取折扣。今天就开始吧。

---

### [00:03:15] Lenny (Sponsor: Mixpanel)

**English:**
This episode is brought to you by Mixpanel. Get deep insights into what your users are doing at every stage of the funnel at a fair price that scales as you grow. Mixpanel gives you quick answers about your users from awareness to acquisition through retention, and by capturing website activity, ad data and multitouch attribution right in Mixpanel, you can improve every aspect of the full user funnel. Powered by first party behavioral data instead of third-party cookies, Mixpanel is built to be more powerful and easier to use than Google Analytics. Explore plans for teams of every size and see what Mixpanel can do for you at mixpanel.com/friends/lenny. And while you're at it, they're also hiring. So check it out at mixpanel.com/friends/lenny.

**中文翻译:**
本期节目由 Mixpanel 赞助。以随业务增长而扩展的公平价格，深入洞察用户在漏斗每个阶段的行为。Mixpanel 为你提供关于用户的快速解答，从认知、获取到留存。通过在 Mixpanel 中直接捕获网站活动、广告数据和多触点归因，你可以优化用户漏斗的方方面面。Mixpanel 由第一方行为数据而非第三方 Cookie 驱动，比 Google Analytics 更强大且更易用。在 mixpanel.com/friends/lenny 探索适合各种规模团队的方案。顺便提一下，他们也在招聘，请访问 mixpanel.com/friends/lenny 查看。

---

### [00:03:50] Lenny

**English:**
Claire, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Claire，非常感谢你能来。欢迎来到我们的播客。

---

### [00:03:54] Claire Butler

**English:**
Thanks, Lenny. I'm excited to be here.

**中文翻译:**
谢谢，Lenny。很高兴能来到这里。

---

### [00:03:56] Lenny

**English:**
You've been on my wishlist of guests for a long time, and so I'm really excited to be finally chatting. You were the 10th employee at Figma, which is now worth tens of billions of dollars depending on which valuation you look at, and probably thousands of employees. I don't even know, but many, many. And you joined before the product even launched. And so, I have a million questions I want to ask about how Figma grew and all the things that went into it. I'm curious what it was like to be early days at Figma. Is there a memory that comes to mind that's zany, funny, fun, tangible of just what it was like to work at Figma in the early days?

**中文翻译:**
你一直在我的嘉宾愿望清单上，所以今天终于能聊上我真的很兴奋。你是 Figma 的第 10 号员工，现在 Figma 的估值根据不同的标准已经达到数百亿美元了，员工可能也有几千人了。我甚至不确定具体数字，但肯定非常多。你在产品发布之前就加入了。所以我有一肚子的问题想问关于 Figma 是如何增长的，以及背后的点点滴滴。我很想知道 Figma 早期是什么样子的。有没有什么让你印象深刻的、搞怪的、有趣的或者很具体的记忆，能体现早期在 Figma 工作的感觉？

---

### [00:04:33] Claire Butler

**English:**
Yeah, totally. No, that's a good question. We were right downtown on New Montgomery and Minna, and I think the thing that sticks out to me is actually two competing stories that talk about just how much at that time you'd oscillate between these really high-level strategic decisions and then total current work. So my first day at Figma, I come into the office and we're going through some stuff. There's like 10 of us in the office, we're chatting, and I look at some of the plans, some of the things they're working on, and I see that they were actually had some branding and positioning and things that the products, Figma, was going to be named Summit, that was the name. 

**中文翻译:**
有的，当然。这是个好问题。我们当时就在市中心的 New Montgomery 和 Minna 街角。让我印象最深的是两个截然不同的故事，它们说明了当时你如何在极高层的战略决策和极其琐碎的日常工作之间来回切换。我入职 Figma 的第一天，走进办公室，大家正在处理一些事情。办公室里大概只有 10 个人，大家在聊天。我看了看一些计划和正在开发的东西，发现他们其实已经做了一些品牌和定位工作，当时产品的名字打算叫“Summit”（巅峰）。

---

### [00:05:15] Claire Butler

**English:**
So the company was going to be Figma, and then the product suite, the product design tool was going to be Summit with the idea that eventually we'll have other tools and that could be like mountaintop or I don't know what the rule, they had a whole thing around the different things that could be for the future product set. And I remember my first day, I had an immediate reaction of like, " We cannot make this thing Summit. That's not going to work. We can't have two brands. Summit's not ownable, we can't build equity and multiple things. That's just never going to work. We kind of have to just stick with one." And I think Figma is ownable and makes sense and we should just go with Figma. So we kind of should probably kill the Summit thing. 

**中文翻译:**
当时公司的名字叫 Figma，但产品套件，也就是那个设计工具，打算叫 Summit。想法是以后我们会有其他工具，名字可能叫“山顶”之类的，我也不太清楚具体的命名规则，反正他们对未来的产品系列有一整套设想。我记得第一天，我的直觉反应就是：“我们不能叫它 Summit。这行不通。我们不能同时拥有两个品牌。Summit 这个词没有辨识度（not ownable），我们无法在多个品牌上建立资产。这永远行不通。我们必须坚持用一个名字。” 我觉得 Figma 更有辨识度，也更合理，我们就该叫 Figma。所以我们可能得把 Summit 这个名字毙掉。

---

### [00:05:55] Claire Butler

**English:**
And Dylan said to me, he was like, "Oh, that's interesting. How about you make a presentation and present it to everyone tomorrow?" And so I did that. I was like, "Oh, okay, I guess this is what I'm doing the rest of the day." So I went and made a little presentation about how we couldn't build all this equity in two places and all of the things, and then the next day we decided to kill that name. And so we went with Figma for the name of the product instead of Summit. And that's how fast things moved, right? And how much you just ran with it and how to ownership. 

**中文翻译:**
Dylan 对我说：“哦，有点意思。要不你做一个演示文稿，明天给所有人讲讲？” 于是我就照做了。我心想：“好吧，看来我今天剩下的时间就干这个了。” 我去做了一个简短的演示，解释为什么我们不能在两个地方分散品牌资产等等。第二天，我们就决定弃用那个名字。于是产品名字就定为了 Figma，而不是 Summit。这就是当时的速度，对吧？你得快速行动并承担起责任。

---

### [00:06:25] Claire Butler

**English:**
I compare that to the first meetup we had, which was probably just 10 people in the office, honestly. But I remember I was in charge of that, so I had to get all the food and everything there, and I just Instacarted some things and ordered some pizza, but I'd forgotten ice. And so I had to go walk down to the nearest corner store, which was three blocks away or something, and get ice. And I got four bags. And I remember I was walking down the street down probably third street with three bags of ice and it was really heavy. And I remember thinking, "This is so hard. This is so heavy. I can't carry all this ice." And it's just like that... I did that too probably the next week. And so, I think it was just this oscillation between like, "Oh, we're making these high level strategic decisions and someone else has to go by the ice." So that's what it was like at Figma in the early days.

**中文翻译:**
我把这件事和我们举办的第一次见面会（meetup）做对比，说实话，当时办公室里可能也就 10 个人。但我记得我负责那次活动，所以我得准备所有的食物。我用 Instacart 买了一些东西，订了披萨，但我忘了买冰块。所以我不得不走到三个街区外最近的便利店去买冰。我买了四袋。我记得我走在街上，大概是第三街，拎着三袋冰，非常沉。我当时想：“这太难了，太重了，我拎不动这么多冰。” 结果下周我可能还在干这种事。所以，我觉得早期在 Figma 的生活就是在“制定高层战略决策”和“亲自去买冰块”之间来回切换。

---

### [00:06:59] Lenny

**English:**
That's incredible. That's almost a metaphor. Someone's got to go carry the ice.

**中文翻译:**
太不可思议了。这简直是个隐喻：总得有人去搬冰块。

---

### [00:07:04] Claire Butler

**English:**
Almost got to the ice for the meetup. Yep.

**中文翻译:**
为了见面会必须得有人去买冰。没错。

---

### [00:07:06] Lenny

**English:**
That's so interesting about Summit, I had no idea that was...

**中文翻译:**
关于 Summit 的故事太有意思了，我完全不知道还有这回事……

---

### [00:07:09] Claire Butler

**English:**
That wasn't a good name. So if you liked that better, I'm sorry because I killed that.

**中文翻译:**
那不是个好名字。如果你觉得那个更好听，那我很抱歉，因为是我把它毙掉的。

---

### [00:07:13] Lenny

**English:**
Who could like it better now that everyone loves Figma and that's just what it is? Do you think Figma would've been as successful with that name, looking back?

**中文翻译:**
现在大家都这么爱 Figma，谁还会觉得那个名字好呢？回过头来看，你觉得如果用那个名字，Figma 还会这么成功吗？

---

### [00:07:21] Claire Butler

**English:**
I think we probably would've changed it later. I think we just saved ourselves some time and without having to change it.

**中文翻译:**
我觉得我们以后肯定还是会改名的。我们只是省去了以后的麻烦，提前把它改了。

---

### [00:07:27] Lenny

**English:**
And then how many days or weeks into your tenure was that happening?

**中文翻译:**
那是你入职几天还是几周后发生的事？

---

### [00:07:32] Claire Butler

**English:**
The name change or...

**中文翻译:**
你是说改名的事，还是……

---

### [00:07:32] Lenny

**English:**
Yeah.

**中文翻译:**
对。

---

### [00:07:34] Claire Butler

**English:**
The first day. No, that was literally my first day.

**中文翻译:**
第一天。不夸张，真的是我入职第一天。

---

### [00:07:36] Lenny

**English:**
The first day.

**中文翻译:**
第一天。

---

### [00:07:36] Claire Butler

**English:**
No, no, no. That was my first day and my second day. Not even kidding. My first day, I made the recommendation, the second day, give the presentation and the decision was made.

**中文翻译:**
不不不，那是我的第一天和第二天。没开玩笑。第一天我提出建议，第二天做演示，然后决定就定下来了。

---

### [00:07:45] Lenny

**English:**
Wow. I was going to ask you what the most stressful memory of early days Figma was. I'm guessing it's the same story.

**中文翻译:**
哇。我本来想问你早期在 Figma 最压力的记忆是什么。我猜可能就是这个故事。

---

### [00:07:50] Claire Butler

**English:**
It's not actually. So I think the most stressful thing, I was thinking about this, was when we launched out of stealth. So I come into Figma, I had lots of experience. I'd been in another startup before that, I launched stuff, but I was still kind of junior. I had done these things, but I didn't have a ton of cycles, and I never ran the whole thing from like, okay, messaging and positioning. This was a forcing function for us to do our messaging and positioning. And I remember there was more than one day where we locked ourselves in a conference room and I made Dylan and Sho at the time have this positioning up on the big screen and made them agree on it word for word. We'd just never done that before. But then I'd also never run PR press and all of a sudden, I had to run press and PR.

**中文翻译:**
其实不是。我想了想，最压力的事情是我们结束隐身模式正式发布的时候。我加入 Figma 时虽然有些经验，之前在另一家初创公司待过，也发布过产品，但我当时还算资历较浅。我做过这些事，但经验还不够丰富，而且我从未从头开始负责过整个流程，比如信息传递（messaging）和定位（positioning）。这次发布迫使我们必须完成定位工作。我记得不止一天，我们把自己锁在会议室里，我让 Dylan 和当时的 Sho 把定位方案投在大屏幕上，逼着他们逐字逐句达成一致。我们以前从未这样做过。而且我也从未负责过公关（PR），突然之间，我得去跑媒体和公关了。

---

### [00:08:36] Claire Butler

**English:**
And I think the hardest part there and the most stressful part was I didn't have anyone to talk to. It was just me. And I didn't at the time have enough cycles to have the confidence that the decisions I was making were the right ones. And so it was hard not to second guess myself sometimes in that position. And I think that's some of the hardest times of being at a startup, especially when you're the only marketer, the only go-to-market person is, you don't have anyone to talk to, to like got check stuff with. And so it does take this immense confidence in yourself, but that's stressful when you don't have the cycles. And so that was very stressful for me for sure.

**中文翻译:**
我觉得最难、压力最大的部分是当时没有人可以商量。只有我一个人。当时我还没有足够的实战经验来确信自己的决定是正确的。所以在那个位置上，很难不偶尔怀疑自己。我觉得这是在初创公司最艰难的时刻之一，尤其是当你作为唯一的营销人员、唯一的市场负责人时，你没有人可以交流，没有人帮你把关。这确实需要极大的自信，但当你经验不足时，这会让你压力倍增。对我来说，那段时间确实非常煎熬。

---

### [00:09:12] Lenny

**English:**
How did you overcome that? Did you find people to work with and run ideas by? Did you just do it and figure it out?

**中文翻译:**
你是怎么克服的？是找了人合作、请教想法，还是就硬着头皮边做边学？

---

### [00:09:19] Claire Butler

**English:**
I mean, I had Dylan, but we just did it, right? Especially in those early days. I remember there were a couple of freak out moments where I would try to get our VCs to help us. I remember Greylock was helpful at least over there, but ultimately, they help a lot, but they don't know your business as intimately as you do. So at the end of the day, that's something Dylan's really good at is trusting his intuition and gut. And so, he was helpful on the decision making, but then also you just got to go for it. And I think that that's something that I learned at that time that's helped me throughout the rest of my career is building that confidence or that trust in yourself because it wasn't something that I necessarily immediately had.

**中文翻译:**
我有 Dylan，但基本上就是硬干，对吧？特别是在早期。我记得有几次崩溃的瞬间，我试着找我们的风投（VC）帮忙。我记得 Greylock 给了不少帮助，但归根结底，他们虽然帮了很多忙，却不像你这样了解自己的业务。所以到头来，Dylan 非常擅长的一点就是相信他的直觉。他在决策上很有帮助，但你也必须放手一搏。我想那是我当时学到的东西，并受益终生，那就是建立对自己的信心和信任，因为这并不是我天生就有的。

---

### [00:10:00] Lenny

**English:**
Next question I wanted to get into briefly is, you joined Figma really early, became one of the most successful, loved companies in history. What did you see early on that convinced you that Figma was the company to join and ask? Because a lot of people today are looking for places to join and trying to decide what to do. Clearly, you made a good choice. What did you see?

**中文翻译:**
接下来的问题我想简短聊聊：你很早就加入了 Figma，它现在成了历史上最成功、最受喜爱的公司之一。早期你看到了什么，让你确信 Figma 就是你应该加入的公司？因为现在很多人都在寻找加入的机会，试图决定该做什么。显然，你做了一个明智的选择。你当时看到了什么？

---

### [00:10:14] Claire Butler

**English:**
So I had been another startup before Figma, a little bit bigger. I think I joined at Series B and then got through on acquisition. And I had a sense that I wanted to do something early. And I'd already made that decision that I wanted to go early stage. So I'll take that decision making part out. But then from there, I was talking to a couple different companies, and when I went to Figma, there were three areas that stood out the most to me. The first was, it logically made sense. And I know maybe that sounds basic, but I was talking to just a drone company or a SaaS tech, like ad tech company, and I just didn't get it, honestly, it didn't intuitively make sense to me or I didn't understand the technology or something. 

**中文翻译:**
在加入 Figma 之前，我在另一家初创公司待过，规模稍微大一点。我是在 B 轮加入的，后来公司被收购了。我当时有一种感觉，我想做一些更早期的项目。我已经决定要走早期创业这条路了，所以这一部分的决策就不多说了。从那以后，我接触了几家不同的公司。当我接触 Figma 时，有三个方面最吸引我。第一，逻辑上说得通。我知道这听起来很基础，但我当时聊过一家无人机公司，还有一家广告技术类的 SaaS 公司，说实话，我就是听不懂，直觉上觉得不合理，或者我不理解那个技术。

---

### [00:11:06] Claire Butler

**English:**
But at Figma, the basic premise immediately logically clicked for me like, "Oh yeah, I use Google Docs, I use Asana, I use all these online tools. That's so weird. That design's not online. Why isn't it?" And as a marketer, I'd worked with designers and sent feedback and emails, and that's really inefficient. And it made a ton of sense to me that yes, that should be online and collaborative. So that was the first thing that I was like check the box. 

**中文翻译:**
但在 Figma，那个基本的逻辑前提立刻就让我开窍了：“哦对啊，我用 Google Docs，用 Asana，用所有这些在线工具。太奇怪了，为什么设计不在云端？为什么还没实现？” 作为一个营销人员，我曾和设计师合作，通过邮件发送反馈，那效率极低。对我来说，设计应该在线化、协作化，这太有道理了。所以这是第一点，我心里打了个勾。

---

### [00:11:30] Claire Butler

**English:**
And the next one was, I knew people who believed in it. So I got introduced to Dylan via Index. They were an investor at the last company I was at, and Danny Rimer specifically. And my old boss, Greg Smearon, who was an EIR there. And I trusted them a lot and they invested in it. I also met John Lilly. I didn't know who he was. I had to Google him, but he seemed really smart. And when they Googled in, he was very impressive, and he believed in it. So that was great.

**中文翻译:**
第二点是，我认识一些相信这个项目的人。我是通过 Index Ventures 被介绍给 Dylan 的，Index 是我上一家公司的投资者，特别是 Danny Rimer。还有我的前老板 Greg Smearon，他当时在那儿做 EIR（入驻企业家）。我非常信任他们，而他们投资了 Figma。我还见到了 John Lilly。当时我不知道他是谁，还得去搜一下，但他看起来非常聪明。搜完之后发现他履历惊人，而且他也相信这个项目。所以这很棒。

---

### [00:11:55] Claire Butler

**English:**
And then I think the third thing was, I remember when I was trying to decide, Dylan really didn't take no for answer. He's very persuasive. And I remember he'd calling me and text me and then I'd have all these concerns or things and he would just pick them apart one by one of reasons why they weren't real concerns or things to get over them. And so I think that that was the third thing is, that's just who he was and that's how he is with everything. And so, if that's how with me, that's how he is with any obstacle that he has. And so, when I looked at that, I was just like, "All right, let's give this a go." And I didn't know. I didn't know. I had no idea it would be as big as it is today. So some of it was luck too, for sure. But those are the three things of how I made my decision.

**中文翻译:**
第三点是，我记得在我犹豫不决时，Dylan 真的不接受拒绝。他非常有说服力。我记得他给我打电话、发短信，当我提出各种顾虑时，他会一个接一个地拆解，告诉我为什么这些不是真正的顾虑，或者该如何克服。我觉得这就是他的性格，他对待任何事情都是这样。如果他对我如此，那他对待任何障碍也会如此。所以看到这一点，我想：“好吧，那就试试吧。” 当时我并不知道，完全没想过它会发展到今天这么大规模。当然，运气也占了一部分。但这就是我做决定的三个核心理由。

---

### [00:12:24] Lenny

**English:**
So what I took away there is, one, you just believe in idea, obviously. Make sure you actually think this could be really big, two is some social proof people you trust really believe in it. In this case, it was really smart investors, they knew. And then the third is, it sounds like you were also just impressed with Dylan.

**中文翻译:**
所以我总结一下：第一，你显然相信这个点子，确信它能做大；第二，社交证明，你信任的人也深信不疑，在这个案例中是那些聪明的投资者；第三，听起来你也被 Dylan 本人折服了。

---

### [00:12:40] Claire Butler

**English:**
Yeah, totally. I believed in him.

**中文翻译:**
是的，完全正确。我相信他。

---

### [00:12:42] Lenny

**English:**
So you joined Figma before it even launched, it was still in stealth. You joined as the first go-to-market hire. You helped launch Figma, you continue to lead go-to market at Figma. And so this is a good segue to where I want to spend most of our conversation. I essentially want to try to unpack what worked to build Figma into the business that it is today from beginning to even now. You're also there for eight years. So you saw a lot of what worked and didn't work. And so let's start with the beginnings of Figma and the go-to-market motion that you developed and how you actually implemented it. So maybe to start, if you could just talk about just what is a bottom up go-to-market motion? And then you also shared somewhere that Figma has a very unique bottom-up go-to-market motion. So maybe just those two areas, just broadly, what is bottom-up go- to-market motion, and then two, what is unique about Figma's approach?

**中文翻译:**
你在 Figma 发布前就加入了，当时还在隐身期。你是第一位市场负责人。你帮助发布了 Figma，并一直领导着 Figma 的市场工作。这是一个很好的切入点，我想把大部分时间花在这里。我本质上想拆解一下，从开始到现在，是什么促使 Figma 成长为今天的规模。你在那里待了八年，见证了许多成功和失败。所以让我们从 Figma 的初期开始，聊聊你开发的进入市场（GTM）模式以及你是如何执行的。首先，你能聊聊什么是“自下而上”（bottom-up）的市场模式吗？你曾在某处提到 Figma 有一种非常独特的自下而上模式。所以，请泛泛地讲讲：第一，什么是自下而上的市场模式？第二，Figma 的方法有什么独特之处？

---

### [00:13:33] Claire Butler

**English:**
I've reflected back to get to some of these answers. I think in the moment, so much of what we were doing was influenced by gut, by trying to connect with people, listening to them. But when I look back is when I'm like, "Oh, this is a repeatable motion." So when I look back at it, I would say that if I were to define and think about how I define our go-to-market motion, and we've said it, we've called it a lot of things over time. We called it product-led, we called it community-led. The way I think about it now is this bottoms-up motion, that really is focused on ICs. So it's all focused on like, "Okay, so you have this core audience." For us it was designers and they're largely individual contributors, so they're people who are practitioners who are using your tool. For us, it's like eight hours a day.

**中文翻译:**
为了回答这些问题，我做了很多反思。我觉得在当时，我们的很多行为是受直觉驱动的，是试图与人建立联系、倾听他们的声音。但当我回过头看时，我才意识到：“哦，这是一个可复制的模式。” 所以回想起来，如果让我定义我们的市场模式——虽然我们过去给它起过很多名字，比如产品驱动（product-led）、社区驱动（community-led）——我现在认为它是一种“自下而上”的模式，核心聚焦于个人贡献者（ICs）。也就是说，它专注于：“好，你有一个核心受众。” 对我们来说就是设计师，他们大多是个人贡献者，是使用工具的从业者。对我们来说，他们每天可能要用八小时。

---

### [00:14:17] Claire Butler

**English:**
If you're a designer, you're in it all the time. And they love you, and you build this relationship with them within the product, but it's beyond the product, right? It's also believing what the product can be in the company and the brand. And they love you so much that they're willing to put their social capital and themselves in the line and spread the product throughout whatever their communities are. And the one that's connected the most to revenue is companies. And so that's where the revenue model really clicks in is you have all these individual contributors who love you, but then they also work at these big companies and these big orgs, and they become these internal champions who spearhead adoption within their organizations and eventually turn into large amounts of revenue. 

**中文翻译:**
如果你是设计师，你会一直待在工具里。他们爱你的产品，你在产品内部与他们建立联系，但这种联系又超越了产品本身，对吧？这还涉及到相信产品在公司和品牌中的潜力。他们非常爱你，以至于愿意投入自己的社交资本，在他们的各种社区中传播这个产品。而与收入关联最紧密的就是公司。这就是收入模型真正发挥作用的地方：你拥有所有这些热爱你的个人贡献者，而他们又在这些大公司和大型组织工作，他们成为了内部的“拥护者”（champions），带头在组织内部推广使用，最终转化为巨额收入。

---

### [00:15:05] Claire Butler

**English:**
And I think of that as our bottoms-up motion. And that's different from tops-down. And a lot of SaaS is tops-down where you go straight to a VP or an executive buyer, they then agree to buying a tool and then that goes down to their organization. I think with technical tools especially, this becomes really important. The practitioners have to love it. And also, sometimes I wondered as an executive care, you know what I mean, what tools people are using? And so for Figma, what that looks like and why this is so efficient of a go-to-market motion for us is, we actually didn't have a sales team for the first three years. So all of our revenue, it was paid, but it was all self-serve. 

**中文翻译:**
这就是我所理解的自下而上模式。它与“自上而下”（tops-down）不同。很多 SaaS 公司是自上而下的，你直接去找副总裁或高管买家，他们同意购买工具，然后推行到整个组织。我觉得对于技术性工具来说，这一点尤为重要。从业者必须喜欢它。而且，有时我也在想，高管真的在乎员工在用什么工具吗？所以对于 Figma 来说，这种模式之所以如此高效，是因为我们在前三年甚至没有销售团队。我们所有的收入虽然是付费的，但全是自助服务（self-serve）。

---

### [00:15:45] Claire Butler

**English:**
And so we'd work with these. We weren't worried about things. I mean, you cared about security, but all of the org features that people need and want when you're working with procurement, we were just focused on technical features for users mostly. And then the individual contributor or maybe the manager would just put them on their credit card. That was the way that things grew. And so there was no sales team for a long time. We did have one eventually, and I'll talk about what that looked like. But then the second thing was, once we did have a sales team, and even up until now, so much of our revenue and our sales and our MQLs, our marketing qualified leads come from our free tier. 

**中文翻译:**
我们当时并不担心那些……我是说，你当然关心安全，但那些在和采购部门打交道时需要的组织级功能，我们当时并没太关注，我们主要关注用户的技术功能。然后个人贡献者或者经理直接刷信用卡付费。这就是增长的方式。所以很长一段时间都没有销售团队。后来我们确实建立了一个，我待会会聊聊那是怎么样的。第二点是，一旦我们有了销售团队，甚至直到现在，我们很大一部分收入、销售额和 MQL（营销合格线索）都来自我们的免费层级。

---

### [00:16:25] Claire Butler

**English:**
So it's people, they're using it, maybe they use it for free. We have a very robust free tier. Maybe they use it for pro, which is on your credit card. And then once it's widespread and they've gained the confidence, then they're ready to bring in sales work with procurement. And they actually come to us and they're like, "Hey, I work at this company. I really want to get my whole company to use it, but security's not letting me. Can you help me unblock it with them?" We didn't spend that much money, any money really programmatically on paid or programmatic marketing because all of our leads for sales would come in through a form on our website, which was current users either free or pro wanting to upgrade. 

**中文翻译:**
人们在使用它，也许是免费使用——我们有一个非常强大的免费层级。也许他们用的是专业版（Pro），那是刷信用卡的。一旦产品普及开来，他们有了信心，就准备好引入销售并与采购部门对接了。他们甚至会主动找我们说：“嘿，我在某某公司工作，我很想让全公司都用这个，但安全部门不放行。你们能帮我搞定他们吗？” 我们并没有在付费广告或程序化营销上花太多钱，因为我们所有的销售线索都来自网站上的表单，也就是那些想要升级的免费或专业版现有用户。

---

### [00:17:05] Claire Butler

**English:**
And at that point, it's a very different sales conversation to unblock someone or to just help them implement Figma when they've already have an internal champion who's bought in, and they're really the one leading and driving the sale within their organization. So I think that that's made us really efficient as like this is a really efficient model and has really powered so much of our growth over time.

**中文翻译:**
到了那个阶段，销售对话就完全不同了，你只是在帮他们扫清障碍，或者帮他们实施部署。因为他们内部已经有了一个完全认可产品的“拥护者”，而那个人才是真正领导和推动组织内部销售的人。所以我认为这让我们非常高效，这是一个极其高效的模型，支撑了我们这么多年来的大部分增长。

---

### [00:17:14] Lenny

**English:**
Somebody listening to this that has a saying, B2B SaaS companies like, "Oh, okay, I just need to get people to love my product and it's going to be great." And so I want to unpack that just like what you did because it wasn't obviously an accident that people loved Figma. But before we get there, you talked about that there's a unique approach to the way you did bottom up. What do you see as what the typical bottom-up go-to-market motion is that other companies try to play that you think Figma did differently? Is it this obsession with ICs on teams or is there some other element of it?

**中文翻译:**
听这段话的人，如果是做 B2B SaaS 公司的，可能会想：“哦，好吧，我只需要让人们爱上我的产品，一切就会变好。” 我想拆解一下你是怎么做的，因为人们爱上 Figma 显然不是偶然。但在那之前，你提到你们做自下而上模式的方法很独特。你认为其他公司尝试的典型自下而上模式是什么样的，而 Figma 有什么不同？是因为对团队中个人贡献者（ICs）的痴迷，还是有其他因素？

---

### [00:17:43] Claire Butler

**English:**
I think there are other people who do bottoms-up and who do it well. I think for us it's unique because the individual contributor spends so much time in the tool, and it's so important to them. I think about things that we focus on where it might take one click off of someone's workflow, and that seems like a really small update. You have to click one time instead of twice to do something. When you're a designer and you're in a tool eight hours a day, saving that one click is huge. And so I think the obsession with quality and with craft within the editor for us, for Figma, is maybe the difference. 

**中文翻译:**
我觉得也有其他人做自下而上模式，而且做得很好。我认为对我们来说，独特之处在于个人贡献者在工具中花费的时间非常长，而且工具对他们至关重要。我会想到我们关注的一些细节，比如在某个工作流中减少一次点击，这看起来是个微小的更新——你只需要点一次而不是两次。但如果你是设计师，每天在工具里待八小时，节省那一次点击就是巨大的进步。所以我觉得，对编辑器内部质量和工艺（craft）的痴迷，可能是 Figma 的不同之处。

---

### [00:18:25] Claire Butler

**English:**
And I think about other go-to-market tools that maybe focus so much on the collaboration side or the product-led of the expansion. And that is a huge part segue, don't get me wrong, but the tool itself, the editor, that's where it all starts and that's what these people love. And then the collaboration is like, yes, it's the thing that's like our differentiator, but it's actually like you stay for the collaboration. You don't want to talk about it or learn about it. Nobody wants talk about collaboration. You just want it to work, right? You care about the tool and that the tool's working well. And so I think that maybe that's the difference is the obsession with the tool itself.

**中文翻译:**
我也想到其他一些市场工具，它们可能过于关注协作方面或产品驱动的扩张。别误会，那确实是很大一部分，但工具本身，也就是那个编辑器，才是所有一切的起点，也是用户热爱的核心。协作确实是我们的差异化优势，但实际上，你是为了协作而留下来。你并不想整天谈论协作或学习协作，没人想聊协作，你只想让它好用，对吧？你关心的是工具，以及工具是否运行良好。所以我觉得，区别可能在于对工具本身的痴迷。

---

### [00:18:52] Lenny

**English:**
Awesome. Yeah, something I learned recently is that multiplayer wasn't even a part of Figma at launch, a year later.

**中文翻译:**
太棒了。是的，我最近了解到，多人协作功能（multiplayer）在 Figma 发布时甚至还不存在，那是整整一年后才有的。

---

### [00:18:58] Claire Butler

**English:**
I know. We can talk about that, and we want to know making a decision of when to go to self because we almost didn't because it didn't have multiplayer.

**中文翻译:**
我知道。我们可以聊聊这个，关于决定何时结束隐身状态的决策，因为当时差点就没发，就是因为还没做多人协作。

---

### [00:19:04] Lenny

**English:**
Oh yeah, let's talk about that.

**中文翻译:**
噢，那咱们聊聊这个。

---

### [00:19:05] Claire Butler

**English:**
Yeah, that was a poor differentiator and we can't not have it, but then we did anyway.

**中文翻译:**
是啊，那是核心差异化功能，我们不能没有它，但结果我们还是在没有它的情况下发布了。

---

### [00:19:10] Lenny

**English:**
Yeah, let's take a tangent there actually. Just that decision to go from stealth. So Figma was in stealth three years or four years before...

**中文翻译:**
好，咱们展开聊聊。关于结束隐身状态的决定。Figma 在那之前隐身了三年还是四年？

---

### [00:19:17] Claire Butler

**English:**
Gosh, three, I guess. I think is 2012 that they started, and then we launched in at the end of 2015. So between around there, yeah, around three or four.

**中文翻译:**
天哪，我想是三年。我想他们是 2012 年开始的，然后我们在 2015 年底发布。所以大概是三到四年之间。

---

### [00:19:27] Lenny

**English:**
Cool. And then you joined right before they launched. We're going to come back to what we were talking about, but just what did you see about that decision of now's the time to launch?

**中文翻译:**
酷。你在发布前夕加入。我们会回到刚才的话题，但先说说，你对“现在就是发布时机”这个决定是怎么看的？

---

### [00:19:34] Claire Butler

**English:**
Yeah, I think it was a couple things. So I think the first thing is that the team had been building quietly by themselves in isolation for three years. And that's hard. I think that that was a very real part of the decision to get out of stealth was that people had been building for such a long time. We needed momentum. We needed to have a milestone that we were working towards. We could have just kept building it quiet for a long time more, but it was very demotivating. So that was a very big part of this. So there was a desire holistically to get out of stealth. But we didn't want to do it until we knew it'd at least be successful. 

**中文翻译:**
我觉得有几点原因。首先，团队已经独自闭门造车三年了。这很难熬。我认为决定结束隐身状态的一个非常现实的原因是，大家已经开发了太久。我们需要动力，需要一个努力的目标里程碑。我们可以继续闭门造车更久，但这非常打击士气。所以这是很大一部分原因，大家普遍渴望走出去。但我们不想在不确定是否会成功的情况下贸然行动。

---

### [00:20:15] Claire Butler

**English:**
But that was a key thing for me. I was working on that messaging, positioning that I was telling you, like we would have this. I still have the doc actually where I was like, projected on the screen and Dylan and Sean and I picked apart every word of it and sharing with a link and multiplayer is the biggest thing. That's the core differentiator. It's really funny. I remember Ivan from Notion's early days, he stopped by and was chatting, and he's like, "Wait, you can't launch with that multiplayer." And I was like, "I know." So I was like, everybody was like, that was the core thing.

**中文翻译:**
但对我来说，关键在于我之前提到的信息传递和定位工作。我手里还有那份文档，当时投在大屏幕上，Dylan、Sean 和我逐字推敲。当时觉得“通过链接分享”和“多人协作”是最大的卖点，是核心差异化。很有趣的是，我记得 Notion 早期的 Ivan 过来串门聊天，他说：“等等，你们不能在没有多人协作的情况下发布。” 我说：“我知道。” 每个人都觉得那是核心。

---

### [00:20:36] Claire Butler

**English:**
But the idea was that we wanted to get out of stealth. We talked to Evan, our CTO, and knew it would take about another year for him to build it. And for me it was like, "Well, is there enough here to get people excited to start and to get users, get more feedback?" Because Evan was kind of building multiplayer. I don't know enough about the engineering if he was doing it on his own or not, but he was the key person doing it. But there are a lot of other things too that were being built or could be built through that year. And we wanted to get more feedback from people and to start really get started.

**中文翻译:**
但我们的想法是想结束隐身。我们和 CTO Evan 聊过，知道他还需要大约一年时间才能做出来。对我来说，问题在于：“现有的东西是否足以让人们感到兴奋并开始使用，从而获取更多反馈？” 因为 Evan 正在开发多人协作，我不确定工程细节上他是不是一个人在战斗，但他确实是核心人物。但在那一年里，还有很多其他东西正在开发或可以开发。我们想获得更多人的反馈，想真正开始运作。

---

### [00:21:05] Claire Butler

**English:**
And so to me, the things that I wanted to see before just deciding like, "Okay, so we don't have our key feature. Can we still launch, or is there enough fear for people to get excited?" At least my first three months, especially before we get going for the launch with the product, and probably even after that, I would just go around with Dylan and pilot or demo Figma to companies. That was a lot of what we did. So we'd go to these companies and we'd show them Figma and we'd get their feedback, and I would be driving around in Palo Alto, around the city doing that with Dylan. And sometimes people didn't care. They were just like, "What is this? I don't want to design online," things like that.

**中文翻译:**
所以对我来说，在决定“好吧，虽然没有核心功能，我们还能发布吗？现有的东西够让人兴奋吗？”之前，我想看到一些东西。至少在我入职的前三个月，特别是在产品发布前，甚至在那之后，我经常和 Dylan 一起去各家公司做试点或演示。那是我们当时的主要工作。我们去这些公司展示 Figma，收集反馈。我载着 Dylan 在帕罗奥图城里转悠。有时人们根本不在乎，他们会说：“这是什么鬼？我不想在网上做设计，”之类的话。

---

### [00:21:47] Claire Butler

**English:**
But what we wanted to see, what I wanted to see was that designers were excited when they saw the tool. And once we got enough features, and I saw this pretty quickly actually when I joined Figma, is that the people that we showed it to were really interested in it and cared about it. And I remember after Vector Networks came out, after some of our other core features, there were enough things where people, I remember, they would take the laptop out of Dylan's hands when he would start showing it because they wanted to play with it. And to me, when I started seeing designers do that, even if I wasn't sure if they'd use it as a team, even if I wasn't sure if they'd buy it, we weren't selling it yet. They wanted to try it and they were excited about it.

**中文翻译:**
但我们想看到的是——或者说我想看到的是——设计师看到这个工具时会感到兴奋。一旦我们有了足够的功能，我很快就发现（其实我刚加入 Figma 没多久就发现了），我们展示过的人都对它非常感兴趣，非常在意。我记得在矢量网络（Vector Networks）和其他一些核心功能推出后，功能已经足够丰富了。我记得有些人甚至会从 Dylan 手里抢过笔记本电脑，因为他们想亲自动手玩玩。对我来说，当我看到设计师开始这么做时，即使我不确定他们是否会以团队形式使用，不确定他们是否会买（当时还没开始卖），但他们想尝试，他们很兴奋。

---

### [00:22:28] Claire Butler

**English:**
And that kind of emotion, no reaction of wanting to play with it in these demos was really what gave me confidence that we were ready to launch. And we had a couple teams, small numbers, and happened to talk about metrics and how hard it is to deal with metrics of this size, but very small numbers. But we had teams who were using it full-time. So we knew that some people were using it full-time and people who weren't were really excited to try and were very impressed with the technical feat of it all and interested. And to me that was enough confidence that like, "Okay, it's worth it. Let's get out of stealth."

**中文翻译:**
那种在演示中想要亲自动手的冲动和反应，真正给了我信心，让我们觉得准备好发布了。我们当时有一些团队在使用，数量很少——说到指标，处理这种规模的指标很难，因为基数太小了。但确实有团队在全职使用它。所以我们知道有人在全职用，而那些没在用的人也非常想尝试，对这项技术成就印象深刻并感兴趣。对我来说，这已经足够让我有信心说：“好吧，值得一试，让我们结束隐身吧。”

---

### [00:23:02] Lenny

**English:**
That story of the potential customer pulling the laptop from Dylan is such a good metaphor for product market fit, which people describe as you feel pull. Someone's literally pulling it from your hands. You talked about metrics that you maybe could share. What could you share there?

**中文翻译:**
潜在客户从 Dylan 手里抢过笔记本电脑的故事，简直是产品市场匹配（PMF）的绝佳隐喻。人们常说 PMF 就是你能感觉到“拉力”，有人真的从你手里把东西抢走。你提到了一些可以分享的指标，能具体说说吗？

---

### [00:23:19] Claire Butler

**English:**
At these early days, especially with bottoms-up and with all these things... And people ask me all the time, "How do you measure things in an early stage situation?" And I maybe have a controversial point of view here. I don't think you can, from a metrics side. Your numbers are so small. One of the quotes I always like to say, and I say this now too, when we're doing stuff, because we're launching new products and it comes up a lot, is you can't optimize your way to product market fit. I don't care at the early stages if something's optimized by 5% from an email.

**中文翻译:**
在早期，尤其是做自下而上模式时……人们总问我：“在早期阶段你怎么衡量各项指标？” 我可能有一个比较有争议的观点：我认为从指标层面是无法衡量的。因为你的基数太小了。我常说的一句话（现在做新产品发布时也常说），就是：你无法通过“优化”来获得产品市场匹配。在早期阶段，我根本不在乎一封邮件的转化率是否优化了 5%。

---

### [00:23:50] Claire Butler

**English:**
That doesn't fundamentally tell me if something's working or not, so I think metrics are really hard and signal is actually way more important. Can you get a couple people who love it, not a slight improvement of a conversion of a landing page. And so I think that metrics are really hard in that way. They can help you, but when the numbers are so small, you have to, again, trust yourself a lot more and have more intuition, but then also find more signal of the things that are working, whether it's anecdotal, talking to people, examples, and that becomes much more useful than hard metrics are sometimes.

**中文翻译:**
那并不能从根本上告诉我这件事行不行得通。所以我认为指标很难衡量，而“信号”（signal）其实重要得多。你能不能找到几个真正爱它的人，而不是纠结于落地页转化率的一点点提升。所以我觉得在这种情况下指标很难办。它们能提供帮助，但当数字很小时，你必须再次更多地信任自己，依靠直觉，同时寻找更多证明事情行得通的信号——无论是轶事、与人交谈还是具体的例子。有时这些比硬生生的指标有用得多。

---

### [00:24:26] Lenny

**English:**
I'm working on a post around product market fit and a step-by-step somewhat of our guide to help people down this path. The way you described it is the way I'm thinking about it, is step one, get one company to use your product.

**中文翻译:**
我正在写一篇关于产品市场匹配的文章，算是一个帮助人们走通这条路的步骤指南。你描述的方式正是我所想的：第一步，让一家公司使用你的产品。

---

### [00:24:37] Claire Butler

**English:**
Yes.

**中文翻译:**
没错。

---

### [00:24:38] Lenny

**English:**
Step two...

**中文翻译:**
第二步……

---

### [00:24:38] Claire Butler

**English:**
What do they want? That was step one, and then that's not easy. That's not easy.

**中文翻译:**
他们想要什么？那是第一步，而且这并不容易。一点也不容易。

---

### [00:24:42] Lenny

**English:**
Right. And then it's like, get them to continue using your product.

**中文翻译:**
对。然后是，让他们持续使用你的产品。

---

### [00:24:42] Claire Butler

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:24:46] Lenny

**English:**
And then it's get two companies to use your product.

**中文翻译:**
接着是让两家公司使用你的产品。

---

### [00:24:46] Claire Butler

**English:**
Yes, exactly.

**中文翻译:**
没错，正是如此。

---

### [00:24:49] Lenny

**English:**
And then get someone to pay for your product. Yeah, so there's all these major milestones. Along those same lines, I saw an interview with Dylan talking about product market fit, and he had this interesting quote about how he realized first that they had product market fit a year later, which is when Microsoft, I think, was like, "Take our money. We want to pay for Figma." And he's like, "OK, maybe this is going to work." Does that sound about right?

**中文翻译:**
然后是让某人为此付费。是的，有很多重大的里程碑。顺着这个思路，我看过一个 Dylan 谈论产品市场匹配的采访，他有一段很有趣的话，说他第一次意识到他们达到了 PMF 是在一年后，当时微软（我想是微软）说：“拿走我们的钱，我们要给 Figma 付费。” 他当时想：“好吧，也许这真的行得通。” 听起来是这样吗？

---

### [00:25:11] Claire Butler

**English:**
Well, it's interesting, and that goes up to the bottoms-up model that we could talk about. I think the difference, if you think about a company like Microsoft and what this looks like, this is just a really good example of this bottoms-up motion in market. Here's a funny story that I want to add. Our first meeting with Microsoft actually came, and this is the scrappiness of working in an early stage startup, because I slid into the DMs of my friend's ex-boyfriend. That's how we got our first meeting with Microsoft.

**中文翻译:**
这很有趣，这正好涉及到了我们可以聊的自下而上模型。如果你想想微软这样的公司，这就是自下而上模式在市场中的一个绝佳案例。我想补充一个有趣的故事。我们与微软的第一次会面其实是这样来的——这就是早期初创公司的草根精神（scrappiness）——我私信了我朋友的前男友。这就是我们获得微软第一次会面的方式。

---

### [00:25:41] Lenny

**English:**
Well done.

**中文翻译:**
干得漂亮。

---

### [00:25:41] Claire Butler

**English:**
I know, I know. I saw that they had signed up for Figma, and I was like, "Wait a minute. I think I know this person." And that's how we chatted with them and first got feedback from them, so that's just a funny anecdote.

**中文翻译:**
我知道，我知道。我看到他们注册了 Figma，我想：“等一下，我好像认识这个人。” 于是我们就这样聊上了，并第一次从他们那里获得了反馈。这只是个有趣的轶事。

---

### [00:25:53] Lenny

**English:**
This could be a new strategy if everyone's going to try to...

**中文翻译:**
如果大家都尝试这种策略，这可能会成为一种新战术……

---

### [00:25:55] Claire Butler

**English:**
You literally do whatever. Uber driver, shared Lyfts, we can talk more about that. But yeah, you got to do whatever you can to get early people to try your product out and get really scrappy. But for Microsoft, over time, we would have, I think it was... What was the team that got acquired that we went into Microsoft? I'll have to remember the name, but it was a small team within Microsoft and they were... Xamarin, it was Xamarin. They were to ones who were using Figma first, and we saw that, so they were that patient zero at Microsoft. And then we had, slowly over time, more pockets within Microsoft using the tool.

**中文翻译:**
你真的得无所不用其极。Uber 司机、拼车，我们可以多聊聊这些。但没错，你必须尽一切努力让早期用户尝试你的产品，表现得非常拼。对于微软，随着时间的推移，我们有了……我想想是哪个被收购的团队让我们进入了微软？我得回想一下名字，是微软内部的一个小团队……Xamarin，对，是 Xamarin。他们是微软第一批使用 Figma 的人，我们注意到了这一点，所以他们是微软的“零号病人”。然后慢慢地，微软内部有越来越多的部门开始使用这个工具。

---

### [00:26:28] Claire Butler

**English:**
But again, we've never gone through Microsoft procurement, Microsoft security. It just started popping up throughout the organization. And we have these really cool Node graphs that show this too, where you'd have these little pockets of people and then it would jump to another, like they'd have one more collaborator and then jump from another pocket. There were these really cool maps of how that spread within the organization. And eventually, we got to the point where that was a very comprehensive Node graph that had this massive thing of all of these people from Microsoft using the product.

**中文翻译:**
但再说一次，我们从未走过微软的采购流程或安全审核。它就是开始在整个组织中四处冒头。我们有一些非常酷的节点图（Node graphs）也展示了这一点：你会看到一小簇人，然后它会跳到另一簇，比如他们增加了一个协作者，然后就跳到了另一个部门。这些地图展示了产品如何在组织内部传播，非常酷。最终，我们得到了一个非常详尽的节点图，显示微软有海量的人在使用这个产品。

---

### [00:26:55] Claire Butler

**English:**
But still, it was only on credit cards. I don't think we even had an enterprise product at this point, and so there was no salesperson for them to talk to. And Microsoft was like, "Wait a minute. We need to organize this. We need security. We need account management. We need procurement involved." And I think that that's what it was. They wanted to pay for it and they wanted us to have this enterprise product, because they had these requirements and they wanted to have a better control over it, because it was just popping up within the organization without their control. And so that's probably a good example of what that looked like as this bottoms in motion just spread to a really large organization.

**中文翻译:**
但即便如此，当时也只是刷信用卡付费。我想当时我们甚至还没有企业版产品，所以他们也没有销售人员可以对接。微软那边说：“等一下，我们需要规范化管理。我们需要安全保障，需要账户管理，需要采购部门介入。” 我觉得情况就是这样：他们想付钱，并希望我们提供企业版产品，因为他们有这些需求，并且希望能更好地控制它，因为产品在组织内部自发蔓延，已经脱离了他们的控制。这可能就是自下而上模式传播到超大型组织的一个很好的例子。

---

### [00:27:34] Lenny

**English:**
This Node graph thing, is that a tool you built that's showing, helping you visualize within a company how it's all clustering? Or what is that?

**中文翻译:**
这个节点图，是你们自己开发的工具吗？用来可视化公司内部的集群情况？那到底是什么？

---

### [00:27:41] Claire Butler

**English:**
Well, our data science team built it. I don't know if it's like... Yes, I'm sure it's an internal tool. I just remember there was a website in Node or something that we would use, and you could type it in an organization's name. You still could do this. It's within our data analytics system. You type in the name of an organization and it just pulls up everybody. And it shows, because Figma spreads through new users, but also gen one, gen two, these people invite people. And you can see these Node graphs of how somebody started Figma, maybe at the center, and then they invited someone else, and then it shows how that spread.

**中文翻译:**
是我们数据科学团队做的。我不确定它是不是……是的，我肯定它是一个内部工具。我只记得有一个用 Node 之类的写的网站，我们可以使用，你可以输入一个组织的名字。现在依然可以这么做，它就在我们的数据分析系统里。你输入一个组织的名字，它就会把所有人拉出来。它展示了 Figma 是如何通过新用户传播的，还有第一代、第二代用户，这些人又邀请了其他人。你可以看到这些节点图，显示某人开始使用 Figma（可能在中心），然后他们邀请了别人，接着展示了这种传播路径。

---

### [00:28:16] Claire Butler

**English:**
And so you get these clusters, and you can see the clusters are teams, but then you can see someone invited someone in a different org to a file and then that started a new center of a cluster. They're really interesting. And you can pull up, you can type in any org, any org at Figma and see what that Node graph looks like. But they're super interesting to see how those spread.

**中文翻译:**
于是你就得到了这些集群，你可以看到集群就是团队，但接着你会看到有人邀请了另一个部门的人查看文件，然后那就成了一个新集群的中心。这非常有趣。你可以输入任何组织，在 Figma 系统里查看那个组织的节点图。观察它们如何传播真的超级有意思。

---

### [00:28:37] Lenny

**English:**
That is super cool. And I imagine that also informs how you go to market by figuring out who spreads to who and who's often...

**中文翻译:**
太酷了。我猜这也能为你们的市场策略提供参考，通过弄清楚谁传播给了谁，以及谁经常是……

---

### [00:28:44] Claire Butler

**English:**
Totally, and that's when these internal champions, that's what the key is. And that's maybe the takeaway of how important these internal champions are, because you just need someone to land there and then them maybe passing it up. You could hover over and see this person's at the center of this Node graph and all of these people that spread from this one person at the company. And that, I think, was the unlock to be like, "Oh yeah, these internal champions, they're really the key to all of this."

**中文翻译:**
完全正确，这就是内部拥护者的关键所在。这也许就是结论：内部拥护者极其重要。你只需要有人在那里“着陆”，然后他们可能会向上推荐。你可以把鼠标悬停在上面，看到某人处于节点图的中心，公司里所有这些人都是从这一个人开始扩散的。我觉得这就是那个“顿悟”时刻：哦，原来这些内部拥护者才是这一切的关键。

---

### [00:29:12] Lenny

**English:**
I remember it spreading at Airbnb early on. I think Airbnb was one of the early customers and it was just one designer, a few designers starting to spread to the product managers. I was just a member on the team being like, "Goddamn it, we just switched to Sketch. Are we going to switch again to a new product?"

**中文翻译:**
我记得早期它在 Airbnb 传播的情况。我想 Airbnb 是早期客户之一，起初只是一个设计师、几个设计师，然后开始传播到产品经理。我当时只是团队的一员，心想：“该死的，我们才刚换成 Sketch，难道又要换成新产品吗？”

---

### [00:29:25] Claire Butler

**English:**
That was the hardest thing to feel like I don't want to switch twice. That was definitely something we had to get over.

**中文翻译:**
那是最大的阻碍——用户不想在短时间内切换两次工具。那绝对是我们必须克服的难题。

---

### [00:29:29] Lenny

**English:**
But it happened for good reasons. OK, one last thing that you mentioned that I wanted to follow up on. You said something about shared Lyfts, and maybe that's a funny story of some sort.

**中文翻译:**
但它的发生是有充分理由的。好，关于你提到的最后一件事我想追问一下。你提到了拼车（shared Lyfts），那是不是有什么有趣的故事？

---

### [00:29:38] Claire Butler

**English:**
Oh, I don't know specifically. Actually, Dylan specifically is such a hustler, especially in those early days. And he would just, really anyone that he would meet, he would talk about Figma with them. I don't remember who it was, but there was definitely a situation where he met someone in a Lyft and then they became one of our users. He used every angle he could to try to get introduced to new designers, especially in his pre-launch days where we didn't have as many connections to just get people to try it out and get more feedback.

**中文翻译:**
噢，具体的我不太清楚。实际上，Dylan 本人就是一个超级拼命三郎（hustler），尤其是在早期。他真的会和遇到的每一个人聊 Figma。我不记得具体是谁了，但肯定有一次他在拼车时遇到一个人，然后那人成了我们的用户。他利用一切可能的角度去结识新设计师，特别是在发布前，我们没有那么多关系网，只能想尽办法让人尝试并获取反馈。

---

### [00:30:06] Lenny

**English:**
OK, let's get back on track. We were talking about the go-to-market motion that you executed and modeled at Figma. There's two steps, right? Step one is get ICs to love you, and then step two is help it spread from that person, right?

**中文翻译:**
好，回到正题。我们刚才在聊你在 Figma 执行并建模的市场模式。分为两步，对吧？第一步是让个人贡献者（ICs）爱上你，第二步是帮助产品从那个人开始传播，对吗？

---

### [00:30:21] Claire Butler

**English:**
Yep, yep.

**中文翻译:**
没错。

---

### [00:30:23] Lenny

**English:**
OK, cool. So, let's start with step one.

**中文翻译:**
好，那我们从第一步开始。

---

### [00:30:25] Claire Butler

**English:**
OK, cool.

**中文翻译:**
好的。

---

### [00:30:25] Lenny

**English:**
Like I said, obviously, it'd be awesome if somebody loved your product at a company. What did you actually do to make that happen in the early days?

**中文翻译:**
就像我说的，如果公司里有人爱你的产品，那当然很棒。但在早期，你们具体做了什么来实现这一点？

---

### [00:30:31] Claire Butler

**English:**
Yeah. It's really interesting when you think about the early days too, because you're like, "All right. We don't exist." How do you get them to love you when literally, they've never heard of you before? Also, like you were saying, in your situation, "Oh, I used Sketch. I was maybe in Photoshop before that, something else. I just made the switch over to this new tool. We finally got it working. I really don't want to move tools again." You have that inherent thing against it there. Especially I thought about this, and I think there are four main areas that we focused on to make this start, to get it going, and then we kind of still do this stuff today.

**中文翻译:**
是的。回想早期真的很有趣，因为你会想：“好吧，我们根本不存在。” 当人们甚至从未听说过你时，你如何让他们爱上你？而且，就像你刚才说的，“哦，我用 Sketch，在那之前可能用 Photoshop 或别的。我刚换到这个新工具，好不容易跑通了，我真的不想再换工具了。” 这种天生的抵触情绪是存在的。我思考过这个问题，我认为我们专注于四个主要领域来启动并推进这件事，而且我们今天基本上还在做这些事。

---

### [00:31:05] Claire Butler

**English:**
The first thing is all about credibility. I think in the early days especially, credibility is so important in establishing that initial credibility, again, especially with a technical audience like designers. The second is actually building the product with your users. And I know you had Sho on your podcast and he talked a lot about this too, just the customer obsession that we have the care of, especially that editor tool.

**中文翻译:**
第一点是公信力（credibility）。我认为特别是在早期，建立初始公信力非常重要，尤其是面对设计师这种技术型受众。第二点是真正与用户一起打造产品。我知道你采访过 Sho，他也聊了很多，就是我们对客户的痴迷，以及对产品的打磨，尤其是那个编辑器工具。

---

### [00:31:28] Claire Butler

**English:**
The third is finding a place where you can, in a way, that you can build this relationship over time. Maybe that's specifically through a channel where they don't have to come to you, because they don't really care about you yet and they're probably not going to convert right away or start using you right away, so how do you get them to stick with you over time? So, find out the channel where you can do that and then continue to build that relationship with them. And then the four is just being extremely transparent and honest to build that relationship with people. I know those all sound really fuzzy, so maybe we can go into them specifically.

**中文翻译:**
第三点是找到一个可以长期建立这种关系的地方。也许是通过某个渠道，让他们不需要主动找你，因为他们还不关心你，可能也不会立刻转化或开始使用。那么你如何让他们长期关注你？所以，找到那个渠道，然后持续与他们建立关系。第四点就是保持极度的透明和诚实，以此与人们建立联系。我知道这些听起来都很虚，所以我们可以具体展开聊聊。

---

### [00:32:04] Lenny

**English:**
Absolutely. I was going to ask.

**中文翻译:**
当然，我正想问呢。

---

### [00:32:04] Claire Butler

**English:**
Because they sound really fuzzy when you talk about them. A lot of this stuff is hard like that, where you're like, "Oh, that just sounds like buzzwords." I can give you some examples of these four things, so maybe it helps to give some color to it.

**中文翻译:**
因为说起来确实很虚。很多这类事情就是这样，听起来像是一堆流行语（buzzwords）。我可以给你们举一些关于这四点的例子，也许能让它更生动一点。

---

### [00:32:13] Lenny

**English:**
Great.

**中文翻译:**
太好了。

---

### [00:32:14] Claire Butler

**English:**
Let's start with the first one, credibility. OK. I was the first marketer at Figma. I think one of the things I learned right away, very quickly was that designers don't want to hear from marketers. They don't want to be marketed to and they have an extremely high bullshit meter. You use a word like efficiency, collaboration, all of those buzzwords, and they're just like, "I don't want to hear this." Traditional product marketing kind of stuff just doesn't work. They wanted to hear technical features. They wanted to understand how technical features work. They want to hear, "How am I going to use this?" And then they'll see the benefits, but they don't want to hear from marketers and they don't want to be marketed to.

**中文翻译:**
先从第一点“公信力”开始。我是 Figma 的第一个营销人员。我很快学到的一件事就是：设计师不想听营销人员说话。他们不想被推销，而且他们对“废话”的辨识度极高（high bullshit meter）。如果你用“效率”、“协作”这类流行语，他们会觉得：“我不想听这些。” 传统的产品营销那一套根本行不通。他们想听的是技术功能，想理解技术功能是如何运作的。他们想听：“我该怎么用这个？” 然后他们会自己发现好处，但他们不想听营销人员白活，也不想被营销。

---

### [00:32:55] Claire Butler

**English:**
And so I think especially with our audience in the early days, one of the things that I did was really try to not market. And that's so funny as a marketer to say that, but that was really core to build authenticity with people. And so the way that we did that in the early days was what we had was the tool, and that's pretty much what we had, and we had a design team and we had an engineering team. We did some cool stuff in the tool. First of all, the tool itself was a technical feat. It was the first time it used video game technology, WebGL. Evan's a prodigy. The fact that he got a design tool to work on the internet was just amazing, and so there was a lot of engineering interest there, credibility building of, "How did you get this to work?"

**中文翻译:**
所以我觉得，特别是在早期面对我们的受众时，我做的一件事就是尽量“不去营销”。作为一个营销人员说这话挺逗的，但那是与人建立真实感（authenticity）的核心。早期我们的做法是：我们只有这个工具，基本上就这些，还有一个设计团队和一个工程团队。我们在工具里做了一些很酷的东西。首先，工具本身就是一项技术壮举。它是第一次使用游戏技术 WebGL。Evan 是个天才，他能让设计工具在浏览器里跑起来简直不可思议，所以工程界对此非常感兴趣，这建立了公信力：“你们是怎么做到的？”

---

### [00:33:40] Claire Butler

**English:**
I got him to make technical content and that, I think, went to number one on Hacker News, that people were just interested in him. And then we had a design team, and our design team was our target audience. And so we talked a lot about how we chose to build features, all the things that went into it. And so many of the primitives of design tools have been like that forever, and so we changed the stuff. One of them would be how we did grids or how we did vector networks, and we'd go into these really deep details of how we chose to make those product decisions, all the craft decisions that went into it.

**中文翻译:**
我让他写了一些技术内容，我想那在 Hacker News 上排到了第一名，人们对他非常感兴趣。然后我们有一个设计团队，而我们的设计团队本身就是我们的目标受众。所以我们聊了很多关于我们如何选择开发某些功能，以及背后的点滴。设计工具的很多基础元素（primitives）多年来一直没变，而我们改变了它们。其中之一是我们如何处理网格（grids）或矢量网络（vector networks），我们会深入探讨为什么做出这些产品决策，以及背后的工艺细节。

---

### [00:34:08] Claire Butler

**English:**
I remember one of my bars were deciding if something would hit this or not, if they would be interested was, "Did I understand it?" You know what I mean? And if I understood it, it was probably too basic, or if I could have written it myself, it was probably too basic. I remember we did one on grids in the early days, and we went really deep on Joseph Muller Brockmann and his influence on grids. And now, I very much know who Joseph Muller Brockmann is because I work with designers, but at the time, I had to Google it. I was like, "Who is this?" But that was one of my bars for if something would be good enough for our technical content, was if I could have written it, it's not good enough. And so that was key for us in building credibility, because we had this design team.

**中文翻译:**
我记得我衡量内容是否能打动受众、他们是否感兴趣的一个标准是：“我能听懂吗？” 你明白我的意思吗？如果我能听懂，那可能太基础了；或者如果我也能写出来，那肯定太基础了。我记得早期我们写过一篇关于网格的文章，深入探讨了约瑟夫·米勒-布罗克曼（Joseph Muller Brockmann）及其对网格的影响。现在我当然知道他是谁，因为我和设计师一起工作，但当时我得去搜一下：“这人是谁？” 但这就是我衡量技术内容是否达标的标准之一：如果我也能写出来，那就不够好。这对我们建立公信力至关重要，因为我们有这个设计团队。

---

### [00:34:47] Claire Butler

**English:**
And then when six months after we launched, I actually got to hire someone to do marketing with me, the first person I hired was actually a designer advocate. So it was not a marketer, it was someone who was a designer. The designers and the engineers that I was trying to get to help me with stuff also had to design and build the product, so they didn't have a ton of time. But this designer advocate was working full-time with me on this stuff, and he came from our user base. He was one of the very few people in the early days who just loved the product and was very passionate about it. And that became his full-time job was to represent, to meet with users, talk to them, to write content and create content, and to bring that back to the product, and that was what he did.

**中文翻译:**
发布六个月后，我终于可以招人和我一起做营销了。我招的第一个人其实是一个“设计师布道师”（designer advocate）。他不是营销人员，而是一个设计师。我之前试着找来帮忙的设计师和工程师还得设计和开发产品，他们没那么多时间。但这位设计师布道师是全职和我一起做这些事的，他来自我们的用户群。他是早期极少数热爱这个产品并充满激情的人之一。他的全职工作就是代表公司去见用户、与他们交流、撰写和创作内容，并将反馈带回产品团队。这就是他的工作。

---

### [00:35:32] Claire Butler

**English:**
And that designer advocacy positions actually scaled with Figma, and we still have it today. It's extreme. I think it's the magic dust, we call it, that we sprinkle on go-to-market to make a lot of our go-to-market function work. But yeah, we didn't focus on marketing, or traditional marketing. We're very focused on the technical aspects.

**中文翻译:**
设计师布道师这个职位实际上随着 Figma 的规模扩大而保留了下来，直到今天我们还有这个团队。这非常关键。我们称之为“魔法粉末”，把它撒在市场策略上，让我们的很多市场功能得以运转。但没错，我们不关注营销，或者说传统营销。我们非常关注技术层面。

---

### [00:35:50] Lenny

**English:**
There's so many little lessons there. The designer advocate hire reminds me of something that Datadog did, where they hired engineers to write their blog posts.

**中文翻译:**
这里面有很多小教训。招募设计师布道师让我想起了 Datadog 的做法，他们招募工程师来写博客文章。

---

### [00:35:59] Claire Butler

**English:**
That's a great idea. Yes, exactly what we did. Yes.

**中文翻译:**
那是个好主意。是的，我们做的正是这个。没错。

---

### [00:36:03] Lenny

**English:**
So, ways you build credibility, just kind of mirroring back what you just shared, one is writing content. Basically, putting out blog posts that designers would be like, "Oh, wow. This is really interesting," and start to feel like, "Oh, Figma keeps coming up in these really interesting pieces of content."

**中文翻译:**
所以，建立公信力的方法，总结一下你刚才分享的：第一是撰写内容。基本上就是发布那些让设计师觉得“噢，哇，这真有意思”的博客文章，让他们开始觉得“噢，Figma 总是出现在这些非常有趣的内容里”。

---

### [00:36:15] Claire Butler

**English:**
Yeah, even if they were using it, and I think that that was important. When we launched, people wanted to test it because it was cool and see what it is, but then they bounced. They're like, "All right. This isn't advanced enough. I'll come back later." Which is why we're give them reasons to come back, being like, "Oh, yeah, but the pen tools always worked like this, but we did it like that. You should test that out." And so we kept giving them these nuggets of reasons to come back in. Remember, this was also before multiplayer, and so we couldn't collaborate, so it was use the tools to do these things. That really helps people come back into the tool and spend a little bit more time in it.

**中文翻译:**
是的，即使他们已经在用了，我觉得这也很重要。我们发布时，人们因为觉得酷想测试一下，看看是什么，但接着他们就流失了。他们会觉得：“好吧，这还不够高级，我以后再来。” 这就是为什么我们要给他们回来的理由，比如：“哦，对了，钢笔工具以前一直是那样用的，但我们是这样做的，你应该试试。” 我们不断给他们这些“小甜头”作为回来的理由。记住，当时还没有多人协作，所以无法协作，只能用工具做这些事。这确实有助于人们回到工具中并多花一点时间。

---

### [00:36:49] Lenny

**English:**
How many posts would you say you put out in that first six months, just to give people a sense of here's how much? It's probably not a ton, right? It's probably some few really good ones.

**中文翻译:**
在那前六个月里，你大概发布了多少篇文章？给听众一个直观的概念。应该不是很多吧？可能就是几篇非常高质量的。

---

### [00:36:57] Claire Butler

**English:**
They took a long time. Also, I had to work with an engineer or a designer to do every single one. Maybe 10 at most. But those ones that went out, we tried to get on Hacker News. We tried to get on Designer News at the time. Twitter, we can jump into that, but it was also extremely big for us. And so it was more about quality than it was about quantity.

**中文翻译:**
写这些文章花了很长时间。而且，每一篇我都得和工程师或设计师合作。最多也就 10 篇。但发布的那些，我们都试着上 Hacker News，或者当时的 Designer News。还有 Twitter，我们可以待会细聊，那对我们来说也非常重要。所以，这更多是关于质量，而不是数量。

---

### [00:37:19] Lenny

**English:**
Awesome. OK, so one is put out great content. People are like, "Oh, wow. Figma's got some new ideas and maybe I should pay attention." The other is having someone that's that function actually talk to them.

**中文翻译:**
太棒了。所以第一点是发布优质内容，让人们觉得“噢，哇，Figma 有一些新想法，也许我该关注一下”。另一点是让负责该职能的人真正去和他们交流。

---

### [00:37:28] Claire Butler

**English:**
Yes. That was when we started accelerating this much, much more is when we brought in that designer advocate to help us with this full-time.

**中文翻译:**
是的。当我们引入那位全职的设计师布道师来帮我们处理这些事时，我们的进度开始大大加快。

---

### [00:37:35] Lenny

**English:**
Cool. OK. Let's move to the next one, which I think is building with your customers.

**中文翻译:**
酷。好，我们进入下一个，我想是“与客户一起打造产品”。

---

### [00:37:39] Claire Butler

**English:**
That one, I know you talked to Sho, he talked a lot about this, this idea of customer obsession and of building with your customers. And it also goes back to that whole decision that we talked about earlier, about when to come out of stealth. You can only build so much with your customers when you're in stealth, because you don't have that many that know about you. But especially, even in the early days when we only had a couple people, we really did listen. And back to also what you were saying earlier about those steps to product market fit, get one person to use it. That's really what we were focused on, especially in the very, very early days.

**中文翻译:**
关于这一点，我知道你和 Sho 聊过，他谈了很多关于“客户痴迷”以及与客户共同构建的想法。这也回到了我们之前讨论的关于何时结束隐身状态的决定。当你处于隐身状态时，你能与客户共同构建的东西有限，因为知道你的人并不多。但特别是在早期，即使我们只有几个人，我们也真的在倾听。回到你之前提到的产品市场匹配的步骤：让一个人使用它。这正是我们当时关注的，尤其是在非常非常早期的阶段。

---

### [00:38:10] Claire Butler

**English:**
I remember the first one, I think I've told this story before, but was that we had Coda. They were our first user and they were based in Palo Alto. Dylan and I drove down and demoed the product to them, and they were the first ones. Their designer, Jeremy, was like, "Yes, we'll take this on full-time." And I remember, we were both like, "What? Really? You will?" That was the first person who said yes to us, and so we were so excited. This was a huge milestone. We went to Oren's Hummus in Palo Alto on the way back to the office to bring some back for the team to celebrate. We were just so stoked.

**中文翻译:**
我记得第一个客户，我想我以前讲过这个故事，就是 Coda。他们是我们的第一个用户，总部在帕罗奥图。我和 Dylan 开车过去给他们演示产品，他们是第一批。他们的设计师 Jeremy 说：“好，我们会全职使用。” 我记得当时我们俩的反应都是：“什么？真的吗？你们真的会用？” 那是第一个对我们说“好”的人，所以我们非常兴奋。这是一个巨大的里程碑。回办公室的路上，我们去了帕罗奥图的 Oren's Hummus 餐厅，带了一些吃的回去给团队庆祝。我们当时简直乐疯了。

---

### [00:38:41] Claire Butler

**English:**
And then we got back to the office, and I think Dylan gets a text from Jeremy being like, "Oh, yeah. I tried to share this with Philippe, my engineer, and he can't get the file to open, so I guess he can't use it." And we're like, "What is it? What happened? We finally got someone." And I remember Dylan was like, "Everybody drop everything. We have to fix this." And after some looking at the servers and things, they were like, "Nothing's wrong," and then they realized it was a problem with Philippe's MacBook. Evan down only had a car, so Dylan had to drive Evan down to Palo Alto to fix the MacBook of Philippe just to get them to use the product.

**中文翻译:**
结果我们刚回到办公室，Dylan 就收到 Jeremy 的短信说：“哦，对了。我试着把这个分享给我的工程师 Philippe，但他打不开文件，所以我想他没法用了。” 我们当时心想：“怎么回事？发生什么了？我们好不容易才争取到一个客户。” 我记得 Dylan 当时说：“所有人放下手头的一切，我们必须解决这个问题。” 检查完服务器后，大家觉得没问题，然后才发现是 Philippe 的 MacBook 出了问题。当时只有 Evan 有车，所以 Dylan 必须载着 Evan 赶到帕罗奥图去修 Philippe 的电脑，仅仅是为了让他们能用上产品。

---

### [00:39:17] Claire Butler

**English:**
But the building with people, the way that we did that was largely through just each person. We really cared and listened to their feedback, especially when there were only a few people. One way we did that was, I remember we implemented Intercom back in the early days, and there were so few users and so few of us that everybody was on Intercom all day too. And so we'd get a chat and I would jump in sometimes. Dylan would jump in, an engineer would jump in. And he'd open up a chat with people and they'd actually debug the product with us live. They'd be like, "I have this bug," and this engineer would be like, "Let me QA it right now."

**中文翻译:**
至于“与人共同构建”，我们主要是通过关注每一个人来实现的。我们非常在意并倾听他们的反馈，尤其是当用户还很少的时候。我记得早期我们安装了 Intercom，因为用户很少，我们人也少，所以大家整天都挂在 Intercom 上。我们会收到聊天请求，有时我会跳进去，Dylan 会跳进去，工程师也会跳进去。他会和用户开启对话，他们实际上是在和我们实时调试产品。用户会说：“我遇到了这个 Bug，”工程师会说：“让我现在就测试一下。”

---

### [00:40:02] Claire Butler

**English:**
And so those are just examples of in the early days, what that looks like, and that just scales a lot over time as you're growing and you're talking to more people. That advocate ended up helping us a ton when they came on board, because some of this stuff, I mean, none of this stuff scales. Your engineers can't do support forever. In the early days, that becomes really important. But when we brought that advocate in, their whole job was talking to users, getting them to try to use the product, but then taking their feedback back when it wasn't something that wasn't working.

**中文翻译:**
这些只是早期情况的一些例子，随着你的成长和接触更多的人，这种情况会不断扩展。当那位布道师加入后，他帮了我们大忙，因为这些事情——我是说，这些事情都无法规模化。你的工程师不可能永远做客服。但在早期，这变得非常重要。当我们引入布道师后，他的全部工作就是与用户交谈，引导他们尝试使用产品，然后在产品出问题时将反馈带回来。

---

### [00:40:34] Claire Butler

**English:**
That helped us scale a lot, so that became really essential, and then telling people, "Oh, we fixed this." It made them feel more ownership of the tool too, being like, "Oh, yeah. I asked them to do this. They did it." That's just another way where you just build a strong relationship with people, because they feel very invested in your journey with you.

**中文翻译:**
这极大地帮助了我们扩展，所以这变得非常关键。然后告诉用户：“噢，我们修复了这个。” 这也让他们对工具有了更多的归属感，觉得：“噢，没错，我让他们做这个，他们真的做了。” 这只是另一种与人建立牢固关系的方式，因为他们觉得自己在和你一起参与这段旅程。

---

### [00:40:54] Lenny

**English:**
Which goes back to building credibility.

**中文翻译:**
这又回到了建立公信力上。

---

### [00:40:55] Claire Butler

**English:**
Absolutely, absolutely.

**中文翻译:**
完全正确，绝对是。

---

### [00:40:57] Lenny

**English:**
There's so many important lessons there. You talked about scaling this, but interestingly, this is very much doing things that don't scale; driving to their office, fixing their wifi on their laptop.

**中文翻译:**
这里面有很多重要的教训。你谈到了扩展，但有趣的是，这其实是非常典型的“做那些无法规模化的事”：开车去他们的办公室，修理他们笔记本电脑上的 Wi-Fi。

---

### [00:41:08] Claire Butler

**English:**
Early days, nothing scales in the early days. You just have to do it anyway.

**中文翻译:**
早期阶段，没有任何事情是可以规模化的。你无论如何都得去做。

---

### [00:41:10] Lenny

**English:**
Just as a tangent, we're talking about getting people to love your product initially. Why is love so important? That's a really high bar, and I imagine you have an interesting insight on just why it needs to be that level of appreciation.

**中文翻译:**
顺便插一句，我们聊的是最初让人们爱上你的产品。为什么“爱”如此重要？这是一个非常高的标准，我想你对于为什么需要达到这种程度的喜爱一定有有趣的见解。

---

### [00:41:23] Claire Butler

**English:**
Yeah, and it doesn't have to be over time. These are all things that maybe they just use it first or they're interested, but by the time you're getting to the organization level, or I'm spreading this to my other spheres of influence, like my community, people I know, you're kind of putting yourself on the line. You're taking a risk when you're doing that, especially if it's your job. You're bringing other people in, and you're not going to do that unless you really believe in something. And so just using it isn't enough to get someone over that stage of going from just a user to a champion. And so I think it is this love thing becomes important, because you just don't get the scalability and spread of someone doing this for you unless they have that level of passion.

**中文翻译:**
是的，而且这种喜爱不一定是一蹴而就的。这些事情可能开始只是他们先试用一下或者感兴趣，但当你上升到组织层面，或者我向我的其他影响力范围（比如我的社区、我认识的人）传播时，你其实是在拿自己的名誉做担保。当你这么做时，你是在承担风险，尤其是如果这关乎你的工作。你在引入其他人，除非你真的相信某样东西，否则你不会这么做。所以，仅仅“使用”不足以让一个人从普通用户转变为“拥护者”。因此，我认为这种“爱”变得至关重要，因为除非他们有那种程度的热情，否则你无法获得那种由他人为你带来的规模化和传播力。

---

### [00:42:09] Lenny

**English:**
That's an awesome lesson. I hope people are taking that in. You shared this story of Coda and Sho. Actually, he wasn't on a podcast. He wrote a newsletter and he shared all this stuff.

**中文翻译:**
这是一个很棒的教训。我希望大家能听进去。你分享了 Coda 和 Sho 的故事。实际上，他没上过播客，他是写了一份时事通讯（newsletter）分享了这些内容。

---

### [00:42:18] Claire Butler

**English:**
I read it. Yes, yes, yes.

**中文翻译:**
我读过。是的，没错。

---

### [00:42:19] Lenny

**English:**
Yeah. People often confuse the two. They assume it's kind of the same thing. But he talked about how when he joined Figma, this happened. Dylan's like, "We need to fix this problem." He's like, "They're not even paying us. Who is this? We have real things to build. Why do we have to hop on this bug?" And then later, he realized why that was so important, and that was a big lesson he learned from Dylan of just this needs to be taken really seriously. If someone's trying to use your product, help them actually be successful.

**中文翻译:**
是的，人们经常把这两者搞混，以为是一回事。但他提到他加入 Figma 时发生了这件事。Dylan 说：“我们需要解决这个问题。” 他当时想：“他们甚至都没付钱。这谁啊？我们还有正经事要开发呢，为什么要纠结这个 Bug？” 后来他才意识到为什么这如此重要，那是他从 Dylan 那里学到的重要一课：必须极其严肃地对待这件事。如果有人尝试使用你的产品，就要帮助他们真正获得成功。

---

### [00:42:45] Lenny (Sponsor: AssemblyAI)

**English:**
Today's episode is brought to you by AssemblyAI. If you're looking to build AI-powered features in your audio and video products, then you need to know about AssemblyAI, which makes it easy to transcribe and understand speech at scale. What I love about AssemblyAI is you can use their simple API to access the latest AI breakthroughs from top-tier research labs. Product teams at startups and enterprises are using AssemblyAI to automatically transcribe and summarize phone calls and virtual meetings, detect topics in podcasts, pinpoint when sensitive content is spoken, and lots more. All of AssemblyAI's models which are accessed through their API are production-ready. Visit assemblyai.com/lenny to try their API for free and start testing their models with their no-code playground. That's assemblyai.com/lenny.

**中文翻译:**
本期节目由 AssemblyAI 赞助。如果你想在音频和视频产品中构建 AI 驱动的功能，那么你需要了解 AssemblyAI。它能让你轻松实现大规模的语音转录和理解。我喜欢 AssemblyAI 的一点是，你可以通过他们简单的 API 访问顶级研究实验室的最新 AI 突破。初创公司和企业的团队正在使用 AssemblyAI 自动转录和总结电话及虚拟会议、检测播客主题、精准定位敏感内容等等。AssemblyAI 所有通过 API 访问的模型都是生产就绪的。访问 assemblyai.com/lenny 免费试用他们的 API，并在无代码游乐场中测试他们的模型。

---

### [00:44:02] Lenny

**English:**
So, coming back to this go-to-market model that we're talking about, we're still talking about get ICs at a company to love you. Step one was build credibility. Step two, I don't know if these are steps or just things you do in some sequence or not, step two is build with your users. What come next?

**中文翻译:**
回到我们正在讨论的市场模式，我们还在聊“让公司的个人贡献者爱上你”。第一步是建立公信力。第二步（我不知道这些是按顺序的步骤还是同时做的事情），第二步是与用户共同构建。接下来是什么？

---

### [00:44:20] Claire Butler

**English:**
Oh, the next one is, this can take time. I think that's a big one. And also in the early days, they're not going to necessarily use you right away, and so it might take time. And then also, when you do get a couple of people who start to use your product, they're going to also start wondering what other people think about your product. And when you're the only marketing hire, and this is something marketers ask me a lot when they're the only marketer in an organization is, "How do you focus and prioritize, because there's so many things you could do? How do you decide what to do?" And so the thing that I think about a lot in this early phase, in thinking about ICs is, "How do you get to them, and where can you go where they already are as opposed to making them come to you?"

**中文翻译:**
噢，下一个是：这可能需要时间。我觉得这是很重要的一点。而且在早期，他们不一定会立刻使用你的产品，所以可能需要时间。此外，当你真的有几个人开始使用你的产品时，他们也会开始好奇其他人是怎么看你的产品的。当你作为唯一的营销人员时（很多在组织里单打独斗的营销人员常问我：“有那么多事情可以做，你如何聚焦和排优先级？你如何决定做什么？”），我在这个早期阶段考虑个人贡献者时，想得最多的是：“你如何触达他们？你如何去到他们已经在的地方，而不是强迫他们来找你？”

---

### [00:45:00] Claire Butler

**English:**
Because I'm a firm believer, I think now, we have spaces where people can come to us, but in the early days especially, they're not going to come to your space. They don't know you. They don't care about you. They don't want to go to your Slack channel or something. You have to go to them. And so for us, Dylan really identified immediately that Twitter was the place where that existed, and that had nothing to do with us specifically. The design community existed on Twitter way before we did, and that's something that they just did on their own and that grew over time. They had this large network on Twitter of influencers, and that's also how people learned about things.

**中文翻译:**
因为我坚信一点（虽然现在我们有了让人们主动找我们的空间），但在早期，他们是不会主动来你的地盘的。他们不认识你，不在乎你，也不想加入你的 Slack 频道之类的。你必须主动去找他们。对我们来说，Dylan 立即意识到 Twitter 就是那个地方，这与我们本身无关。设计社区在 Twitter 上存在的时间比我们久得多，那是他们自发形成的，并随着时间推移而壮大。他们在 Twitter 上有一个庞大的影响力网络，人们也是通过那里了解新事物的。

---

### [00:45:38] Claire Butler

**English:**
Also, design's changing all the time, and so people would share best practices, things that they were doing, resources, and that just became kind of a home for designers. So, we really went all in on Twitter. That really became a key, our channel that we focused on, and really only focused on one. That was it, and we got pretty advanced on how we did this. Dylan is also a great engineer, if you don't know that about him, or a scrappy engineer who could figure things out. And he had this idea and he built this tool or this scraper where he identified a couple influencers in the design community. People he thought were people he wanted to learn from and to talk to. 

**中文翻译:**
此外，设计一直在变化，所以人们会分享最佳实践、他们正在做的事情、资源，那里就成了设计师的家。所以，我们真的全身心投入到了 Twitter 上。那成了我们的关键渠道，而且我们真的只专注于这一个。就是它了。我们在操作方式上也相当先进。Dylan 也是一名优秀的工程师（如果你还不了解他的话），或者说是一个能解决问题的实干型工程师。他有一个想法，并开发了一个工具或爬虫，识别了设计社区中的几位影响力人物。那些他认为值得学习和交流的人。

---

### [00:46:51] Claire Butler

**English:**
And he inputted them into this scraper thing that he made. And then back to this, another node graph, he figured out who followed them and who followed those people and also the influence that these people had over other people, and made this massive node graph of these pockets of different topics of design. And when he looked at it, you'd see a cluster. So you'd have the cluster of iconographers, graphic designers, product managers, and you'd see them all there and you'd see who the influencers were in those areas. And what we did is we found who were most influential to start.

**中文翻译:**
他把这些人输入到他做的爬虫里。然后又回到了节点图：他弄清楚了谁关注了他们，谁又关注了那些人，以及这些人对他人的影响力，并制作了这个巨大的节点图，展示了不同设计主题的小圈子。当你观察它时，你会看到一个个集群。比如图标设计师集群、平面设计师集群、产品经理集群，你能看到他们都在哪，以及这些领域的意见领袖是谁。我们所做的就是找到那些最初最有影响力的人。

---

### [00:47:20] Claire Butler

**English:**
And that was another source, back to using whatever you can to get people to try your products. That's who we asked for feedback in the early days too. Just DMed them. We were like, hey, Raji, we'd love feedback, your feedback on Figma. And that was one of the ways we got to people, but that's also people who we followed, people who we tried to build this connection with on Twitter in the early days. And that's also where we pushed out that technical content that I was talking about. And then we tried to just drive and spur a conversation about these things. First it was our launches, but then later it was this technical content or whatever it was that we were producing so that we could go to people instead of making them come to us just in their feed. And that became super important to us. 

**中文翻译:**
那是另一个来源——回到“利用一切手段让人们尝试你的产品”。在早期，我们也向这些人征求反馈。直接私信他们。我们会说：“嘿，Raji，我们很想听听你对 Figma 的反馈。” 这是我们触达用户的方式之一。这些人也是我们在早期试图在 Twitter 上建立联系的对象。我们也是在那里发布我提到的那些技术内容的。然后我们试着围绕这些内容发起和推动对话。起初是关于我们的发布，后来是关于技术内容或我们制作的任何东西，这样我们就能直接出现在他们的信息流里，而不是等他们来找我们。这对我们来说变得极其重要。

---

### [00:48:00] Claire Butler

**English:**
We'd also interact with people. So Dylan has a huge presence, and especially in the early days and now even has a huge presence talking to users, we all did show too our engineering team. And so it wasn't just the brand handle, it was the people. And I think that that's really important to put a personal face behind things, connect with people, answer questions for people, live there. And over time, we just built this very engaged group of people on Twitter with Figma. And that's still a huge place for us where the design community lives and where we get a lot from our users too. And I think the focus on that, and I think why it's so important is it allows people to passively follow you over time without having to invest in you, within the tool. 

**中文翻译:**
我们还会与人互动。Dylan 很有影响力，尤其是在早期，甚至现在他也经常和用户交流。我们的工程团队也是如此。所以这不仅仅是一个品牌账号，而是具体的人。我认为为品牌赋予人格化形象非常重要——与人建立联系、回答问题、活跃在社区里。随着时间的推移，我们在 Twitter 上围绕 Figma 建立了一个非常活跃的群体。那里至今仍是设计社区聚集的地方，也是我们获取大量用户反馈的地方。我认为专注于此之所以重要，是因为它允许人们随着时间的推移被动地关注你，而不需要在工具内部投入太多。

---

### [00:48:24] Lenny

**English:**
That Twitter graph story is so legendary. I think Dylan even shared the code online. I'm going to try to find that tweet.

**中文翻译:**
那个 Twitter 关系图的故事太传奇了。我想 Dylan 甚至在网上分享过代码。我会试着找找那条推文。

---

### [00:48:30] Claire Butler

**English:**
Yeah, it's so good. We still use it. We used it again when we were launching another product, we were like, oh, can we go pull that Twitter graph for another audience? I don't know if we ended up using, how much we ended up using it, but I definitely looked at it and I was like, oh, this is so interesting to see for developers or whatever it was that we were looking at.

**中文翻译:**
是的，它非常好用。我们现在还在用。当我们发布另一个产品时，我们想：“噢，我们能为另一群受众拉一下那个 Twitter 关系图吗？” 我不确定最后用了多少，但我肯定看过它，我觉得观察开发者或其他受众的分布非常有趣。

---

### [00:48:46] Lenny

**English:**
And also what you just mentioned is really interesting that he wasn't using it to go sell people on the product. It was first get feedback on the product, which ends up selling them.

**中文翻译:**
而且你刚才提到的那点很有意思：他并不是用它来向人们推销产品。首先是获取产品反馈，而这最终促成了销售。

---

### [00:48:54] Claire Butler

**English:**
Oh no, we never heard sold the product. It was always about feedback. And I think that that's so key to all of this is all about feedback.

**中文翻译:**
噢不，我们从不硬推销产品。始终是关于反馈。我认为这是所有这一切的关键：一切都围绕着反馈。

---

### [00:49:02] Lenny

**English:**
Awesome. There's so many lessons here. There's a fourth bullet I think, around building relationships with users.

**中文翻译:**
太棒了。这里有很多教训。我想还有第四点，关于与用户建立关系。

---

### [00:49:08] Claire Butler

**English:**
Oh, just transparency and authenticity. So I think that that really comes into when you get to the scale part, I'm talking about early days, being transparent with your users, and a lot of that does come down to the stuff we talked about too, about downtime, about what that looks like. And we just did that naturally with people one-on-one in those early days. But I think where it gets harder, and we stuck with it because it's in our DNA and how we act, is when you get to scale and you have to still do that stuff with a lot of people who care and who do these things with you. But I think it's just so important that you are honest and also you don't hide behind the brand. That you're human and authentic and transparent with people. 

**中文翻译:**
噢，就是透明度和真实感。我认为当你进入规模化阶段时，这一点尤为重要。我刚才说的是早期，要对用户透明，这很大程度上也涉及到我们讨论过的内容，比如宕机（downtime）以及如何处理。在早期，我们只是自然地与用户进行一对一交流。但我觉得难点在于，当你规模扩大后，你仍然需要对大量关心你、与你同行的人做这些事。我们坚持了下来，因为这是我们的基因。我认为诚实非常重要，不要躲在品牌后面。要像个真实的人一样，真诚、透明地对待大家。

---

### [00:49:52] Lenny

**English:**
So let's chat about that. Just... So this is about getting started. How do you do this at scale? Or does it change completely? Do you continue doing this in a different way? How do you approach it as the company grows?

**中文翻译:**
那我们聊聊这个。刚才说的是起步阶段。在规模化阶段你怎么做？是完全变了，还是以不同的方式继续？随着公司成长，你如何处理这些？

---

### [00:50:02] Claire Butler

**English:**
You just totally still do it, right? I think that that's just so important, that's how it stays, right? In the early days you do this stuff and you kind of get the flywheel going. You get these people, you have these people who love you, but today that's still how Figma spreads the most, right? We're going into new markets, we're going into new places, we're launching a new tool, and that becomes so important to how we still drive adoption. And so some of those things, the tactics, look a little bit different, but the themes are still the same and what that looks like at scale. 

**中文翻译:**
你完全还在继续做，对吧？我认为这非常重要，这就是它能维持下去的原因。在早期你做这些事，让飞轮转起来。你拥有了这些热爱你的人。而今天，这依然是 Figma 传播最广的方式。我们进入新市场、新领域，发布新工具，这对于我们如何推动采用依然至关重要。所以其中一些战术看起来可能略有不同，但主题和规模化后的样子依然是一致的。

---

### [00:50:30] Claire Butler

**English:**
A couple of just examples of that are those advocates, right? That's I think a huge one. When I was a marketer that advocate was just my partner. He gut-checked everything that I did. He'd be like, no, that's too thirsty here. You're using a fluff word again. You know what I mean? Also, he was how we pitched the company. He was the people we talked to, he'd go to lunch at Etsy or whatever and just get feedback on things. And that function has really grown with Figma. So now that's a whole team at Figma, it's a large team and it's scaled with us with every product that we launch. 

**中文翻译:**
举几个例子，比如那些布道师。我觉得这是个大招。当我还是唯一的营销人员时，那位布道师就是我的搭档。他会帮我把关所有事情。他会说：“不，这里显得太急功近利（thirsty）了。你又在用空洞的词了。” 你懂我意思吗？此外，他也是我们推介公司的方式。他是我们交流的对象，他会去 Etsy 之类的公司吃午饭，收集反馈。这个职能随着 Figma 的成长而壮大。现在 Figma 有一个完整的团队，一个庞大的团队，并随着我们发布的每一个产品而扩展。

---

### [00:51:15] Claire Butler

**English:**
So now we have developer advocates, FigJam advocates, and regionally. So we go into a new region and they're part of the landing team. We're in Japan, we need to find the Japan, now we have two of them, it's the Japan designer advocate because it's just so core to how we do things and we've scaled that. So I think on the credibility side, I think that those advocates and scaling those advocates are the magic dust that, I always call them the magic dust, that make sure that we are able to build those relationships and stay authentic around everything we do.

**中文翻译:**
所以现在我们有了开发者布道师、FigJam 布道师，还有按地区划分的。当我们进入一个新地区，他们就是落地团队的一部分。我们在日本，就需要找日本的布道师——现在我们有两个日本设计师布道师，因为这正是我们做事的核心，我们已经将其规模化了。所以在公信力方面，我认为这些布道师以及他们的规模化就是“魔法粉末”。我总是这么称呼他们，他们确保我们能够建立这些关系，并在所做的一切中保持真实。

---

### [00:52:10] Lenny

**English:**
And these advocates, again, they're just, their background is designer, and then they end up being an advocate designer?

**中文翻译:**
这些布道师，他们的背景是设计师，然后最终成为了设计师布道师？

---

### [00:52:15] Claire Butler

**English:**
It's now developer, FigJam person. But they're passionate that... Their profile is, they're passionate users who oftentimes they find us more than we find them, right? You couldn't just post this job online and go source for it. It's like this will emerge from the community and then they love it so much and they know the product so well. They're technical experts. But yes, they were, for the designer ones, they were all previously product designers.

**中文翻译:**
现在也有开发者、FigJam 专家。但他们的共同点是充满激情……他们的画像是：充满热情的用户，通常是他们找到我们，而不是我们去找他们。你不能只是在网上发个招聘广告然后去搜人。这更像是从社区中涌现出来的，他们非常热爱产品，对产品了如指掌。他们是技术专家。但没错，对于设计师布道师来说，他们之前都是产品设计师。

---

### [00:52:53] Claire Butler

**English:**
One of the ways that we've done that and still continue to focus on things that people care about that's so related to the craft of quality is through we do quality weeks with engineering. And then we decided a couple years ago, we had this idea where we were like, oh, what if we package all of those quality updates up into one thing and launch them together and we could even show the tweet or the forum request that spurred us to do this. And that was where our idea of little big updates came, which is a launch that we do every year. 

**中文翻译:**
我们过去和现在一直坚持关注人们在意的事情（这与对质量的追求密切相关）的方法之一，是与工程团队一起开展“质量周”（quality weeks）。几年前我们决定，嘿，如果我们把所有这些质量更新打包在一起发布呢？我们甚至可以展示是哪条推文或论坛请求促使我们这么做的。这就是“小而大的更新”（Little Big Updates）这个想法的由来，这是我们每年都会进行的一次发布。

---

### [00:53:37] Claire Butler

**English:**
Figma, they come from these quality weeks with engineering, that's where the engineers can just go and look at Twitter, talk to our support team, get all these small things that annoy people to fix them, and they just fix them all and they get so many done. And then we launch them all together. And that's one of our most popular launches that we do because people are like, yes, I care about this. This improves my quality of life every single day. Back to that discussion of two clicks versus one click and things like that, they're that small, but we still do it. And I love that little big updates when I think, Airbnb did something like that too, with the a hundred updates thing on their website.

**中文翻译:**
这些更新源自与工程团队的质量周。工程师们会去刷 Twitter，和客服团队沟通，找出所有那些让用户烦恼的小问题并修复它们。他们能修复非常多。然后我们统一发布。这是我们最受欢迎的发布活动之一，因为用户会觉得：“没错，我在乎这个。这改善了我每天的生活质量。” 回到之前说的两次点击变一次点击之类的小事，虽然很小，但我们依然在做。我非常喜欢“小而大的更新”，我想 Airbnb 也在他们的网站上做过类似“100 项更新”的事情。

---

### [00:53:49] Lenny

**English:**
Airbnb has shifted fully to that, which is only big launches, just wait twice a year and launch a bunch of stuff. That's exactly, that's fully how they operate.

**中文翻译:**
Airbnb 已经完全转向这种模式了，即只做大型发布，每年两次，集中发布一大堆东西。这正是他们现在的运作方式。

---

### [00:54:07] Lenny

**English:**
That's got to be so satisfying.

**中文翻译:**
那一定非常有成就感。

---

### [00:54:08] Claire Butler

**English:**
Yeah, exactly. And in the marketing even, we'll pull examples like, oh yeah, that for one, the person who said that. So that one's big. And then on the transparency side, I think where this gets hard at scale is all of a sudden you have a lot of people who care about your products. And I think it's really easy as a brand because you are a brand at this point, as you're getting bigger to be like, oh, I can hide behind my handle or the Figma handle, or do I really have to say something about this? 

**中文翻译:**
没错。甚至在营销中，我们会列举例子，比如：“噢对了，这就是为了那位提出建议的用户做的。” 所以这很有意义。在透明度方面，我认为规模化后的难点在于，突然之间有很多人关心你的产品。作为一个品牌，随着规模变大，很容易产生这种想法：“噢，我可以躲在我的账号或 Figma 官方账号后面，我真的必须对此发表意见吗？”

---

### [00:54:40] Claire Butler

**English:**
And so just two examples of things like that where you just, we've chosen to be transparent when we didn't have to be or you might not, or downtime. Downtime is always a big deal. And I remember there was a specific instance, I think it was last year, maybe two years ago, where there was this issue with these servers and an AWS cluster went down and we didn't know what was going on. And so we had downtime multiple times in a week and people were pissed, right? Things were not going well. 

**中文翻译:**
这里有两个例子，说明我们选择了保持透明，即使我们本可以不这么做。比如宕机。宕机永远是件大事。我记得有一个具体的例子，大概是去年或前年，服务器出了问题，一个 AWS 集群挂了，我们当时不知道发生了什么。结果那一周宕机了好几次，用户都气炸了，对吧？情况非常糟糕。

---

### [00:55:15] Claire Butler

**English:**
Again, back on Twitter, we built... The double-edged sword of Twitter is you build this strong communication channel with your users and they communicate right back to you if they're not happy. So it's inundating us. And I remember we did a public postmortem and we always do that. If something happens or something goes wrong, we're like, yeah, that was bad. Here's what happened and here's the technical reason and here's how we fixed it. And then we tweeted that and promoted it and took just full accountability for it. And we always choose to make those choices when they're hard. 

**中文翻译:**
再说回 Twitter，Twitter 是一把双刃剑：你建立了一个与用户沟通的强大渠道，如果他们不高兴，他们也会立刻反馈给你。当时反馈如潮水般涌来。我记得我们做了一次公开的复盘（postmortem），我们总是这么做。如果出了事或出了错，我们会说：“是的，这很糟糕。发生了什么，技术原因是什么，我们是如何修复的。” 然后我们发推文推广它，承担全部责任。当面临艰难选择时，我们总是选择透明。

---

### [00:55:52] Claire Butler

**English:**
And I think the hardest example, and back to your question of the most stressful days at Figma, the true most stressful day Figma, for me, was the day that we announced the acquisition. That was probably one of the harder moments of my career, where... My brand is social, that's my job, is running social. And all of a sudden you have this onslaught on social and you have to figure out what to do. And I remember the way that we announced it was we just retweeted Dylan. That was all that we had said.

**中文翻译:**
我认为最难的例子，回到你问的在 Figma 最压力的日子，对我来说，真正的最压力的一天是我们宣布被收购的那天。那可能是我职业生涯中最艰难的时刻之一。我的品牌阵地是社交媒体，我的工作就是运营社交媒体。突然之间，社交媒体上爆发了猛烈的抨击，你必须想出对策。我记得我们宣布的方式只是转发了 Dylan 的推文，那是我们当时说的全部。

---

### [00:56:07] Claire Butler

**English:**
Raji on our team, I remember I was talking to him about it and he was like, "We've got to talk to our users. We just have to talk to them directly. We have to show we're the same company. We just have to not hide behind the brand." And he was totally right. And so I remember we decided that day that the next day we just had to have an open public forum where we could talk directly with our users and let them ask us any questions. And so we'd held the Twitter space the next day with Dylan and Sho and Raji and Tom, and we just had it open and people could ask us anything they wanted and we were able to be just really honest and transparent with them about everything that we could.

**中文翻译:**
我们团队的 Raji，我记得当时和他聊这件事，他说：“我们必须和用户谈谈。我们必须直接和他们谈。我们必须展示我们还是原来的那家公司。我们绝对不能躲在品牌后面。” 他完全正确。所以我记得那天我们决定，第二天必须举办一个公开论坛，直接与用户交流，让他们问任何问题。于是第二天我们和 Dylan、Sho、Raji 以及 Tom 一起举办了 Twitter Space，全程开放，人们可以问任何想问的问题，我们尽可能诚实、透明地回答了一切。

---

### [00:56:44] Claire Butler

**English:**
And I think that that is just a really good example of how even when it's really, really, really, really hard, you still have to just be transparent. And I think that that's when the tide started to turn of people giving us a chance to prove that everything would be great, even when it's the highest stakes and the hardest thing of still listening to people, maintaining that connection and not hiding behind the brand.

**中文翻译:**
我认为这是一个非常好的例子，说明即使在极其艰难的时刻，你仍然必须保持透明。我想正是从那时起，局势开始扭转，人们愿意给我们一个机会去证明一切都会变好。即使在赌注最高、最困难的时候，依然要倾听用户的声音，维持那种联系，而不是躲在品牌后面。

---

### [00:57:06] Lenny

**English:**
It feels like transparency is core to the values of Figma. Have you codified your values and is that one of them and is there anything there?

**中文翻译:**
感觉透明度是 Figma 核心价值观的一部分。你们有没有把价值观成文？透明度是其中之一吗？

---

### [00:57:18] Claire Butler

**English:**
Interesting. We have codified our values. It isn't explicitly listed out, which is interesting, but I think of it as our value, especially with our users. We think about our values a lot as have fun with it, build community, love your craft, and all of those definitely come through, play, but maybe that should be one because I think it's so core to how we make decisions and our framework of when we have a decision which way we're going to go.

**中文翻译:**
很有意思。我们确实把价值观成文了。虽然透明度没有被明确列出来，这挺有趣的，但我认为它是我们的价值观，尤其是对待用户时。我们经常提到的价值观包括：享受乐趣（have fun with it）、建立社区（build community）、热爱你的工艺（love your craft），这些都贯穿其中。但也许透明度也该列进去，因为它确实是我们决策的核心，是我们决定朝哪个方向走时的基本框架。

---

### [00:57:43] Lenny

**English:**
And also we mentioned Sho a couple of times, but on Twitter, he is always asking people, what do you need in the editor? Here's what's going great.

**中文翻译:**
我们也提到了好几次 Sho，他在 Twitter 上总是问大家：你们在编辑器里还需要什么？哪些地方用得爽？

---

### [00:57:49] Claire Butler

**English:**
Absolutely. It's still how we get so much feedback is talking to people directly and Kris will come on when people have bugs and just respond to them. He's our CTO. People are just actively on there, listening to people, fixing bugs, responding.

**中文翻译:**
没错。直到现在，直接与人交流依然是我们获取大量反馈的方式。当用户遇到 Bug 时，我们的 CTO Kris 也会亲自上线回复。大家都在那里非常活跃，倾听用户、修复 Bug、做出回应。

---

### [00:58:06] Lenny

**English:**
I want to shift to kind of the second step of the go-to-market motion, but before I do that, I have a couple of things I wanted to touch on briefly. One is you haven't mentioned Config, this conference that you ran, which is a good example I think, of scaling a lot of the things you're talking about. It used to be Twitter, social graph, find people on Twitter. Now it's like this epic conference that I think people just love. I was on Twitter the days of Config, and it's just my whole feed was just like, oh my god, Config is the best thing. So many talks and so many people.

**中文翻译:**
我想转到市场模式的第二步，但在那之前，有几件事我想简短提一下。一是你还没提到 Config，就是你负责的那个大会。我认为它是把你提到的很多事情规模化的一个好例子。以前是 Twitter、社交图谱、在 Twitter 上找人。现在它变成了一个大家都热爱的史诗级大会。Config 举办的那几天我也在刷 Twitter，我的整个信息流全是：“天哪，Config 太棒了。” 那么多演讲，那么多人。

---

### [00:58:34] Claire Butler

**English:**
Config is such a good example. I remember, I can happily talk about Config. The way that we do Config, I think... I'd never run a conference before, maybe that's probably part of it. And I brought somebody on who had, but she and I were both sitting together and being like, OK, so we're doing a conference. How do we get the content for this conference? What do we do? And we didn't know. And so we just decided, oh, so much of what we do is listen to our users. Let's put out this call for proposals and see what they want to talk about. 

**中文翻译:**
Config 确实是个好例子。我很乐意聊聊 Config。关于举办 Config 的方式……我以前从未办过大会，这可能也是原因之一。我招了一个有经验的人，但我和她坐在一起时都在想：“好吧，我们要办个大会。内容从哪来？我们该做什么？” 我们当时也不知道。于是我们决定：“噢，既然我们一直在倾听用户，那就发布一个提案征集（CFP），看看他们想聊什么。”

---

### [00:59:20] Claire Butler

**English:**
And through that process, we build these relationships with these speakers, our advocates help them shape their talks. And then I think that we do produce really strong technical content through that process and through Config. And we're also able to, with these people that we work with, help them grow their own profiles and that also helps them stay more connected to us, helps them become thought leaders in their own right. And so I think we're able to just draw so many different people who are the practitioners and the ICs because we're not just putting thought leadership out there. We're talking directly to how to use the tool and the things that individual contributors are still dealing with.

**中文翻译:**
通过那个过程，我们与演讲者建立了联系，我们的布道师帮助他们打磨演讲内容。我认为通过这个过程和 Config，我们确实产出了非常扎实的技术内容。同时，我们也能帮助这些合作伙伴提升个人知名度，这也有助于他们与我们保持更紧密的联系，帮助他们成为各自领域的思想领袖。因此，我们能够吸引这么多从业者和个人贡献者，因为我们不只是在传播空洞的思想领导力，我们是在直接讨论如何使用工具，以及个人贡献者正在面临的实际问题。

---

### [01:00:04] Lenny

**English:**
I remember seeing a tweet about it where someone filmed being inside of and they're like, it's a rock concert, it's not a conference.

**中文翻译:**
我记得看到过一条推文，有人拍了现场视频说：“这哪是大会，这简直是摇滚音乐会。”

---

### [01:00:10] Claire Butler

**English:**
Oh, that too. We also just have fun. That's another big part of it as well. I remember literally saying, how can I make this more fun? So that was a big part of it.

**中文翻译:**
噢，那也是。我们也只是想玩得开心。那是另一个重要部分。我记得我当时真的在想：“我怎么能让这事儿变得更有趣？” 所以那是很大一部分原因。

---

### [01:00:21] Lenny

**English:**
Sounds like another value. OK. Let's talk about step two of this go-to-market motion that you've developed, which I think if I were to just simply describe it as help people spread it within the organization. Is that right?

**中文翻译:**
听起来又是另一项价值观。好，让我们聊聊你开发的市场模式的第二步。如果让我简单描述，就是“帮助人们在组织内部传播产品”。对吗？

---

### [01:00:34] Claire Butler

**English:**
Yep. All right, so again, I've got four things here and I'll list them out and then we can go through them. The first is make it easy to try the tool and to share it without a lot of gates so that you can do this. The second is those DAs. I want to talk about how those DAs work in our sales process. The third is finding the operational thing that allows you to scale. For us that's design systems. And then the last one was still about maintaining and growing that connection with those internal champions over time. 

**中文翻译:**
没错。好，这里我也有四点，我先列出来，然后我们逐一讨论。第一，让工具易于尝试和分享，不要设置太多门槛。第二，是那些设计师布道师（DAs），我想聊聊他们在我们销售流程中是如何发挥作用的。第三，找到能让你规模化的运营抓手，对我们来说就是“设计系统”（design systems）。最后一点依然是关于长期维护并加强与那些内部拥护者的联系。

---

### [01:01:32] Claire Butler

**English:**
All right, cool. So the first one's making it, the products easy to try and share. So we talked about this a little bit, but if you go to figma.com today, it's very easy to sign up for a free account. I have a free account myself on my personal side for designing my house. But you just go and you can try the tool. And I think that's so important for us to allow someone to use it over time for a long time until they have confidence enough to be able to want to spread it within their organizations. 

**中文翻译:**
好。第一点是让产品易于尝试和分享。我们稍微聊过这个，但如果你今天访问 figma.com，注册免费账户非常容易。我个人也有一个免费账户，用来设计我的房子。你直接去就能试用。我认为允许用户长期使用非常重要，直到他们有足够的信心并愿意在组织内部传播它。

---

### [01:02:05] Claire Butler

**English:**
But then it's also pretty easy to create a free team and share stuff with your organization. In the early days, you could just share a link and that was it, and you could use the tool and everything was free. Once we implemented pricing, which was about two years after we launched, we had this thing called a starter team. And this is actually something that was switched. So initially the way that it worked was our starter team was that you could have unlimited files but only collaborate with two or three people, and that was the starter team and you wanted to add more people to collaborate with, and then you hit the paywall. 

**中文翻译:**
此外，创建一个免费团队并与组织分享内容也很容易。在早期，你只需分享一个链接就行了，工具可以随便用，一切都是免费的。发布大约两年后，我们开始实施定价，我们推出了一个叫“入门团队”（starter team）的东西。这其实经历了一次调整。最初的规则是：你可以拥有无限的文件，但只能与两三个人协作，这就是入门团队；如果你想增加更多协作者，就会触发付费墙。

---

### [01:02:45] Claire Butler

**English:**
We realized that wait a minute, that's hurting us. And so we switched it and now it's like you can have something like three files, but unlimited collaborators. And that was huge for us. And that's a place where you can see it in the metrics very clearly, where it's like, oh, this is really easy for people now to share before they have to start paying. This is huge. And so then you get people to start using it for free with their teams and the teams get confidence in it before then they all have to start uploading it to their procurement team or whoever it is to start paying for it. 

**中文翻译:**
我们意识到，等一下，这在伤害我们的增长。于是我们做了调整，现在变成了：你可以拥有大约三个文件，但协作者数量不限。这对我们来说意义重大。在指标上可以非常清晰地看到这一点：人们在付费之前分享变得非常容易。这太关键了。这样人们就可以先和团队一起免费使用，团队建立起信心，然后才需要找采购部门或相关负责人去付钱。

---

### [01:03:24] Lenny

**English:**
That's such a good and important topic that I want to pull a thread on a little bit. So what you discovered there is you don't want to get in the way of the growth engine of the product. If it's going to grow through people spreading it, you don't want to cut it off at three. That seems like a monumental decision that changed everything. Any sense of just how you came about to realizing that? Or was it just obvious, OK, of course we need to change this?

**中文翻译:**
这是一个非常棒且重要的话题，我想深入探讨一下。你发现的是：你不想阻碍产品的增长引擎。如果产品是通过人们的传播来增长的，你就不想在“3 个人”这个门槛上把它掐断。这似乎是一个改变一切的重大决定。你是怎么意识到这一点的？还是说这显而易见，我们当然得改？

---

### [01:03:45] Claire Butler

**English:**
Well, I think it was intuitive and it was more about the change management process of how to do that when people... At this point people were using the tool and using that starter tier and setting people or what that looks like. And for a long time you could also get around that and just collaborate with people in drafts and just share a link too. And we wanted to shut that down. So it was a bigger decision on just change management, but I think we intuitively knew it and it was much more about to the change management of how to make that happen.

**中文翻译:**
我觉得这是一种直觉，更多是关于如何实施这种变更管理（change management）。当时人们已经在用这个工具和入门层级了。很长一段时间里，你也可以通过在“草稿箱”（drafts）里协作并分享链接来绕过限制。我们想堵住这个漏洞。所以这更多是一个关于变更管理的重大决策，但我认为我们直觉上是知道的，重点在于如何落地。

---

### [01:04:13] Lenny

**English:**
Is there anything else you learned about what should be in free and paywall versus what should be in freemium? Just broad thoughts.

**中文翻译:**
关于哪些该免费、哪些该设付费墙，或者关于免费增值（freemium）模式，你还有什么心得吗？

---

### [01:04:21] Claire Butler

**English:**
Well, I think the other interesting thing is too, and I think I said this, but so much of ours is, so we have a couple tiers. We have a free tier and then we have a pro tier, and then we have our org tier. And the free tier, free tier includes this free starter team. And so you can just do that, go to figma.com, and go do that. Pro is all enter credit card, and then org is you talk to sales. Org and enterprise, you talk to sales. And so I think the other key thing here is we get a lot of upsells to org from pro. And so it's also a thought of what you put in org versus pro. 

**中文翻译:**
我觉得另一个有趣的点是（我可能提过），我们有几个层级：免费版、专业版（Pro），然后是组织版（Org）。免费版包含那个免费的入门团队。专业版是直接刷信用卡，组织版和企业版则需要联系销售。这里另一个关键点是，我们有很多从专业版升级到组织版的增购。所以，在组织版和专业版之间如何分配功能也是需要思考的。

---

### [01:05:11] Claire Butler

**English:**
So that's the other decision because pro is also relatively inexpensive, so that grows a lot too really quickly and it's still very important to us, but still most of our marketing qualified leads that are sales leads likely come from pro or from free. And so it's the decisions that we think about are like, OK, what do you want to sell on? And to go from free to pro, it has to be pretty natural because you don't have any people involved. And then when you go from pro to org or enterprise, it's more about the organization and the scale. And that's where that design systems conversation comes in that we could talk about. 

**中文翻译:**
专业版相对便宜，所以增长也很快，对我们依然非常重要。但大多数销售线索（MQL）还是来自专业版或免费版。我们思考的决策是：你想靠什么来卖？从免费到专业版的转化必须非常自然，因为没有人工干预。而从专业版到组织版或企业版，则更多关乎组织管理和规模化。这就是我们要聊的“设计系统”发挥作用的地方。

---

### [01:05:51] Lenny

**English:**
The other really important nuance in the way that you structured pricing, it's unlimited viewers, but it's just editors that you charge for.

**中文翻译:**
你们定价结构中另一个非常重要的细微差别是：查看者（viewers）是不限量的，你们只对编辑者（editors）收费。

---

### [01:05:56] Claire Butler

**English:**
Yes. So true. So many people, especially if you're a designer and you're working with our product manager, you can comment and so much of this is to yes, you can spread it and you can use Figma for free for a really long time because you can just comment on the tool. It also gets us through many more places with the organization and helps us be more useful to more people because yeah, viewers are free.

**中文翻译:**
没错，正是如此。很多人，特别是如果你是设计师，正在和产品经理合作，他们可以评论。这让你能把 Figma 传播开来，并且可以免费使用很长时间，因为仅仅评论是不收费的。这也让我们能渗透进组织的更多角落，对更多人产生价值，因为查看者是免费的。

---

### [01:06:21] Lenny

**English:**
How often do you revisit the packaging and pricing at this point? And do you have any advice there?

**中文翻译:**
你们现在多久重新审视一次功能打包和定价？对此有什么建议吗？

---

### [01:06:32] Claire Butler

**English:**
Yeah, I mean it's interesting because the product's still growing. We just launched variables and dev mode back in at Config this year, and that influenced pricing and packaging and still is, right? And so FigJam too. And so I would say the core foundations aren't something we revisit a lot, but we're continually adding new features and we have to think about what tiers should they go in, what does that look like? So those things influence that all the time.

**中文翻译:**
这很有趣，因为产品还在成长。我们今年在 Config 大会上刚发布了变量（variables）和开发模式（dev mode），这影响了定价和打包，目前还在调整中。FigJam 也是如此。我想说，核心基础我们不会经常改动，但我们会不断添加新功能，必须考虑它们该放入哪个层级，以及呈现方式。所以这些因素一直在产生影响。

---

### [01:07:33] Lenny

**English:**
OK. Let's talk about designer advocates. Talk about that.

**中文翻译:**
好。让我们聊聊设计师布道师。展开讲讲。

---

### [01:07:39] Claire Butler

**English:**
Yeah, so I just think these DAs, so sorry, I keep calling them DAs because that's what we call them internally. Advocates are just so special and such a big part of Figma. And like I said, it took us so long to start charging or bring in a sales team. And when we first hired our first salesperson and our first sales rep was the same day that our next designer advocate started. Eventually the first designer advocate left and did something else. And we brought in another designer advocate and he started on the first day that the sales team started. 

**中文翻译:**
是的，我觉得这些 DAs（抱歉，我习惯叫他们 DA，因为我们内部这么叫）非常特别，是 Figma 的重要组成部分。就像我说的，我们花了很长时间才开始收费或建立销售团队。当我们招募第一位销售人员时，同一天，我们的下一位设计师布道师也入职了。最初的那位布道师后来离开了，我们招了另一位，他入职的第一天正好也是销售团队成立的第一天。

---

### [01:08:27] Claire Butler

**English:**
And Tom, who is still here today and is leading that team, Tom Lowry, he was a passionate Figma user, but he was a passionate Figma user who brought Figma to his organization. But the first one, we were so early, he didn't have an organization to bring it to, he just loved the product. But Tom, he was the internal champion at his company, who got his company to adopt Figma. So, when he joined Figma, that was really the mindset that he brought to this, was also like, "How do you use this as a team?"

**中文翻译:**
Tom Lowry 至今还在公司并领导着那个团队。他曾是一个狂热的 Figma 用户，而且他把 Figma 带进了他的公司。第一位布道师加入时我们还太早，他还没机会把产品带进什么组织，他只是单纯热爱产品。但 Tom 不同，他是他公司的内部拥护者，促使公司采用了 Figma。所以当他加入 Figma 时，他带来的是这种心态：“作为一个团队，你该如何使用它？”

---

### [01:08:42] Claire Butler

**English:**
And why I think this is so special, and was so foundational that they started together, is that they would go talk to users together, and they would bring him into the sales process. But he was never a salesperson. Never had a quota, doesn't live on the sales team. Technical expert who has such a deep passion, and a deep, deep, deep, deep understanding of the tool, that he would come in and just help explain the product to other designers. 

**中文翻译:**
我认为最特别、最基础的一点是他们（销售和布道师）是一起起步的。他们会一起去见用户，销售会把他带入销售流程。但他从来不是销售人员，没有业绩指标（quota），也不属于销售团队。他是一个技术专家，对工具有着极深的热情和理解，他会进来向其他设计师解释产品。

---

### [01:09:21] Claire Butler

**English:**
And it goes back to that same theme that I talked about earlier with marketing, where I realized that I would never have the credibility with designers that a designer has. Same is true with sales. They're never going to know the product as well as a designer will. So, Tom being there, and Tom being able to be like, "Oh, I understand exactly what you're talking about, and what your problems are. Here's how this works." Or "Here's where you're blocked," or "Here's an idea or best practice how to use this." 

**中文翻译:**
这又回到了我之前提到的营销主题：我意识到，我永远无法像设计师那样在设计师群体中拥有公信力。销售也是如此，销售永远不会像设计师那样了解产品。所以 Tom 在场，他能说：“噢，我完全明白你在说什么，也知道你的痛点在哪。这里是它的运作方式，”或者“这里是你卡壳的地方，”或者“这里有一个关于如何使用它的最佳实践。”

---

### [01:09:51] Claire Butler

**English:**
That just became so powerful and so useful for them and for the sales team, that they ended up calling it the Tom Factor. So, it wasn't necessarily a structured process at the beginning. They'd just like, "Hey Tom, can you come help talk to this company with us, or help show them how this works?" But then they called him the Tom Factor because he was so powerful, and their deals were so much more likely to close if he joined the calls. 

**中文翻译:**
这对销售团队来说变得非常强大且有用，以至于他们最后称之为“Tom 因子”（Tom Factor）。起初这并不是一个标准流程，销售只是会说：“嘿 Tom，你能来帮我们和这家公司聊聊吗，或者展示一下它是怎么运作的？” 后来他们叫他“Tom 因子”，因为他太厉害了，只要他参加会议，成交的可能性就会大大增加。

---

### [01:10:15] Claire Butler

**English:**
But it wasn't his full-time job either. He also is connected to the products. Because he's this special person who was a designer, was a user of the product, and then talks to hundreds of customers. So, he has the best way of synthesizing product feedback, and then bringing it back to the product team because he has all of that context. So, I think that that role is just so special, and it's something that we've actually chosen to scale because it's just so valuable. In the same way it's valuable for marketing, it's valuable for sales.

**中文翻译:**
但这也不是他的全部工作。他也与产品团队紧密相连。因为他是一个特殊的人：他曾是设计师，是产品的深度用户，现在又在和成百上千的客户交流。所以，他最擅长综合产品反馈并带回给产品团队，因为他掌握了所有的背景信息。我认为这个角色非常特殊，我们选择将其规模化，因为它太有价值了。就像它对营销有价值一样，它对销售也同样有价值。

---

### [01:10:54] Lenny

**English:**
Who does this team report to?

**中文翻译:**
这个团队向谁汇报？

---

### [01:10:54] Claire Butler

**English:**
Me.

**中文翻译:**
向我汇报。

---

### [01:11:06] Claire Butler

**English:**
Let's talk about design systems. Let's say you're a designer and you're designing an app, and you need a button. Rather than going in and making a new button every single time, you need a library of the button ... with the color, the spacing, the padding, all that stuff already predefined. Maybe it's tied to code, maybe it's not. But you just want to pull that in. And then, maybe there's someone on the design system, and maybe there's a brand designer or someone who's like, "Oh, we changed this from this font to that font." That you know that, and it just updates everywhere. 

**中文翻译:**
让我们聊聊设计系统。假设你是一个设计师，正在设计一个 App，你需要一个按钮。你不需要每次都重新做一个按钮，你需要一个按钮库……颜色、间距、边距（padding），所有这些都已经预定义好了。也许它与代码关联，也许没有。你只需要把它拉进来。然后，如果设计系统团队的人，或者是品牌设计师说：“噢，我们把这个字体改了。” 你知道后，它就会在所有地方自动更新。

---

### [01:11:54] Claire Butler

**English:**
And it's a huge efficiency. If you have hundreds of designers in an organization, they're all making buttons, they're going to be slightly different. And then engineering's like, "Wait. What padding do I use?" It's very inefficient. So, a lot of organizations use these design systems, and they become very advanced over time. But Figma did not have design systems in the early days. Or if we did, they ended up having them at the file level. But you couldn't share them with other people.

**中文翻译:**
这是巨大的效率提升。如果一个组织有几百个设计师，每个人都在做按钮，那按钮会各不相同。然后工程团队会问：“等等，我该用哪个边距？” 这非常低效。所以很多组织使用这些设计系统，并随着时间推移变得非常先进。但 Figma 早期并没有设计系统。或者即使有，也只是在文件层级的，你无法与他人分享。

---

### [01:12:25] Claire Butler

**English:**
So, that was a huge blocker for us for a really long time, was these big companies were like, "Oh, yeah. This is cool, but I need a design system. How else am I supposed to work with engineering?” Because this is so big in engineering, too. Because when you're able to identify all of these different buttons and these components in advance, you could tie them to code. And then it's easier for them because they don't have to inspect it every time. So, it's way better for everybody. It was our biggest blocker. But then we decided, "No, we're going to focus on this." 

**中文翻译:**
所以很长一段时间内，这对我们来说是一个巨大的阻碍。大公司会说：“噢，是的，这很酷，但我需要设计系统。否则我怎么和工程团队协作？” 因为这对工程团队也至关重要。如果你能预先确定所有这些不同的按钮和组件，你就可以将它们与代码关联。这样对工程师来说更容易，因为他们不需要每次都去检查参数。这对每个人都更好。这曾是我们最大的阻碍，但后来我们决定：“不，我们要专注于此。”

---

### [01:13:03] Claire Butler

**English:**
And then they started building out more features from it. And then we just started really leaning into the technical aspects of how companies use and scale design systems. Because, while design systems are so important, it's also very hard to get an organization to do it. But we really leaned into the content, into the features, into eventually showing how people do it in Figma. Both at the beginning level, but then at the very advanced level, to really lean into that. And then, that also went into marketing. That was ... We have DesignSystems.com, it's a Figma property. We had a whole conference around it in the fall called Schema, where we just bring in these advanced design systems practitioners and they just show you how're they're working. 

**中文翻译:**
然后他们开始围绕它开发更多功能。我们开始深入研究公司如何使用和扩展设计系统的技术层面。因为虽然设计系统很重要，但让一个组织真正实施起来却很难。我们投入了大量精力在内容、功能上，最终展示了人们如何在 Figma 中实现它——从初级水平到非常高级的水平。这也延伸到了营销中。我们拥有 DesignSystems.com，这是 Figma 的资产。我们在秋季举办了一个专门的会议叫 Schema，邀请那些资深的设计系统从业者来展示他们的工作方式。

---

### [01:14:30] Claire Butler

**English:**
And that's so important, too, because design systems are one of the main reasons you upgrade from pro to org or enterprise, is you're at this phase where you're getting more organized. You're more advanced, you're a bigger company, so that's one of our big gating features for upgrade, so that became just the key thing we leaned in on. And that's bottoms up specific, because the people making the design systems are not like the VP, still. The next phase of bottoms up are the ICs, and then the design systems people. 

**中文翻译:**
这也非常重要，因为设计系统是用户从专业版升级到组织版或企业版的主要原因之一。当你进入这个阶段，说明你变得更有组织性、更先进、规模更大，所以这成了我们升级的核心门槛功能，也是我们重点发力的地方。这依然符合自下而上模式，因为构建设计系统的人通常不是副总裁，而是个人贡献者，然后是专门负责设计系统的人。

---

### [01:14:58] Lenny

**English:**
I love just that lesson of the thing that is blocking you from being adopted, see if you can turn that into an advantage.

**中文翻译:**
我喜欢这个教训：看看能不能把阻碍你被采用的因素转化为你的优势。

---

### [01:15:25] Claire Butler

**English:**
That's what I was talking about with the IC. An IC has to get a lot of value out of this on their own. And I think it has to be technical. Or, that's a hypothesis that I have. It's certainly easier if it's a technical product. They get a lot farther, because people want to talk much more about the product. They care so much about the craft, and they want to spend a lot of time learning and understanding it. And I think that's true with designers, that's true with engineers. 

**中文翻译:**
这就是我谈论个人贡献者（IC）的原因。IC 必须能独自从产品中获得巨大价值。而且我认为产品必须具有技术含量——这是我的一个假设。如果是一个技术性产品，确实会容易得多。它们能走得更远，因为人们更愿意谈论产品本身。他们非常在意工艺，愿意花大量时间去学习和理解。设计师是这样，工程师也是这样。

---

### [01:16:12] Lenny

**English:**
Coming back to the strategy of helping Figma spread within an organization, I think you mentioned there's one more item around champions?

**中文翻译:**
回到帮助 Figma 在组织内部传播的策略，我想你提到过关于“拥护者”还有最后一点？

---

### [01:16:20] Claire Butler

**English:**
Oh, yeah. Just the last thing there is, you have to keep that relationship going with those champions forever. Because they don't go away. And sometimes they get mad at you, too. I remember, there's one. I think it was at one of our companies, one of our bigger companies. And he was upset about something, and he tweeted it. And then we immediately had to go talk to him and understand what he wanted, and what was wrong. They don't go away. 

**中文翻译:**
噢，是的。最后一点是，你必须永远维持与那些拥护者的关系。因为他们不会消失。有时他们也会对你发火。我记得有一个人，是在我们的一家大客户公司。他对某件事很不满，发了推文。我们必须立刻去和他沟通，了解他的诉求以及出了什么问题。他们一直都在。

---

### [01:17:11] Claire Butler

**English:**
But we have more direct control over things like, "Oh, you're going to speak at one of our events. We're going to amplify you on social. We're going to promote you and make you a thought leader.” And it works really well for everyone. Because these people also have the deep technical expertise to show other people, "Here's how I've built my design systems. Here's how I do this." And people who want to learn from them. And we have the platform to be able to amplify them. So, I think a lot about, "Yeah, how can we help these people grow in their own careers, and get something out of this, too, beyond just the level of the tool?"

**中文翻译:**
但我们可以更直接地控制一些事情，比如：“噢，你来参加我们的活动做演讲吧。我们会在社交媒体上宣传你。我们会推广你，让你成为思想领袖。” 这对大家都有好处。因为这些人拥有深厚的技术专长，可以向别人展示：“我是如何构建设计系统的，我是如何操作的。” 人们也想向他们学习。而我们拥有可以放大他们影响力的平台。所以我会想：“是的，我们如何帮助这些人在职业生涯中成长，让他们除了使用工具之外，还能从中获得其他收益？”

---

### [01:18:02] Claire Butler

**English:**
Yeah. I think the key thing is that you have to keep doing it. One of the things that I feel like, at my role now at Figma, that I think a lot about, is how I can keep advocating for this stuff when we are starting to implement more top down motion, and having to really prove ROI. Or thinking about, "How do you scale the sales team?" And all those things. So, a lot of what I'm doing, too, is thinking like, "OK. How do we keep this going and keep this model successful as the company is still growing?" 

**中文翻译:**
是的。我认为关键在于你必须坚持做下去。在我现在的职位上，我思考很多的是：当我们开始实施更多自上而下的模式，并且必须真正证明投资回报率（ROI），或者考虑“如何扩大销售团队”时，我该如何继续倡导这些做法？所以，我做的很多工作也是在思考：“好，随着公司不断壮大，我们如何让这种模式持续成功？”

---

### [01:19:14] Lenny

**English:**
Is this a fit for everyone, this sort of approach? Let's say every B2B SaaS company, what are maybe prerequisites for who should apply this sort of approach and this motion?

**中文翻译:**
这种方法适合所有人吗？假设是所有的 B2B SaaS 公司，应用这种模式的前提条件是什么？

---

### [01:19:25] Claire Butler

**English:**
I thought about this a lot myself, actually. Because Figma also has new products. So, I think to myself, "Oh, can I replicate this?" Like FigJam. FigJam's one of those examples. And Dev Mode, all of a sudden we're working with developers. So, I've thought about this a lot. And I don't know if there's like, "Oh, you have to have this, or you have to have that." But I think there's certainly things that make it easier. 

**中文翻译:**
实际上我自己也经常思考这个问题。因为 Figma 也有新产品。我会想：“噢，我能复制这个模式吗？” 比如 FigJam 就是一个例子。还有开发模式，突然之间我们要和开发者打交道了。所以我考虑了很多。我不确定是否必须具备某些特定条件，但肯定有一些因素会让它变得更容易。

---

### [01:19:50] Claire Butler

**English:**
Within the market, I already mentioned it. But I think it really helps if people are technical. And you have this technical audience of people who really care about the craft, and they get a lot of value out of the tool by themselves. Because that just allows them to really learn something and really build confidence in something, before they have to spread it or start collaborating. And it gives you something to talk about with them that's not collaboration. Because, like I said, no one wants to talk about collaboration. 

**中文翻译:**
在市场方面，我提到过，如果受众是技术型的，会有很大帮助。如果你面对的是一群非常在意工艺的技术受众，而且他们能独自从工具中获得巨大价值，那就太好了。因为这让他们在开始传播或协作之前，能真正学到东西并建立信心。这给了你除了“协作”之外可以和他们聊的话题。因为就像我说的，没人想聊协作。

---

### [01:20:55] Claire Butler

**English:**
Another thing that helps is that you have a community that exists within the target audience already. We had that with designers. Yes, we grew it a lot, and have grown with it a lot. But like I said, that Twitter community, that existed without us. That was there before we were there. So, it made it a lot easier for us to get started, because we didn't have to make something to bring people to us. We had a distribution channel already in place that we could work through. 

**中文翻译:**
另一个有利因素是目标受众中已经存在一个社区。设计师群体就是这样。是的，我们极大地扩展了它，并与之共同成长。但就像我说的，那个 Twitter 社区在我们出现之前就存在了。这让我们起步容易得多，因为我们不需要凭空创造一个东西来吸引人。我们已经有一个现成的分发渠道可以利用。

---

### [01:21:54] Claire Butler

**English:**
One of my favorite stories there is that when we launched Designer News, which was a popular forum back in the day, the first response was, "If this is the future of design, I'm changing careers." Because designers do not want to be collaborative. There was this process where people were like, "Oh, no. I want to do my work on my own, and then present when I'm ready." It was a massive shift in getting them to think in a different way to do this. 

**中文翻译:**
我最喜欢的一个故事是，当我们登上当时的流行论坛 Designer News 时，第一个回复是：“如果这就是设计的未来，我要改行了。” 因为设计师当时并不想协作。当时人们的想法是：“噢不，我想自己独立完成工作，准备好了再展示。” 让他们转变思维方式是一个巨大的挑战。

---

### [01:22:57] Claire Butler

**English:**
The most important thing there is that you have an executive and a leader who believes in this. I did not start this; Dylan started this. He was the core person who believed in this, and who drove a lot of this. And he continues to. And he's built this up to be a culture of our team. And since he believes in it, he's able to help bring more people on board and make everyone believe in it. And then, I think the other thing is, through that, is that thing that we were talking about earlier with metrics. I think so much of this is people being like, " That doesn't scale. How do you measure this?” 

**中文翻译:**
最重要的一点是，你必须有一个相信这一点的执行官和领导者。这不是我发起的，是 Dylan 发起的。他是相信这一点并推动这一切的核心人物。他至今仍在坚持，并将其建立为我们团队的文化。正因为他相信，他才能吸引更多人加入并让大家也相信。另外一点就是我们之前聊到的指标问题。很多人会说：“这无法规模化，你怎么衡量它？”

---

### [01:23:43] Claire Butler

**English:**
And yes, we are working on all those things. But it's not immediately clear. The metrics don't immediately show you if something's working or not. It goes back to signal over metrics. And I think that that's so important. And having leaders who believe in that, too, who are able to trust their own intuitions and their own guts, is so important. 

**中文翻译:**
是的，我们正在努力解决这些问题。但这并不是立竿见影的。指标不会立刻告诉你某件事是否奏效。这又回到了“信号优于指标”的论点。我认为这非常重要。拥有相信这一点、并能信任自己直觉和胆识的领导者，至关重要。

---

### [01:24:28] Lenny

**English:**
So, the idea here, basically, is step one, make individual contributors at a company love your product. Step two is get them to help spread you within the company. And to get people to love your product, the four keys that you shared is: Build credibility for your product, build a product with your users, focus where you can connect with your users, one to many. In your case, it was Twitter. And build a relationship with users so that they can start to trust you. And transparency is a big part of that. 

**中文翻译:**
所以，这里的核心思路基本上是：第一步，让公司的个人贡献者爱上你的产品。第二步，让他们帮助你在公司内部传播。为了让人们爱上你的产品，你分享了四个关键点：为产品建立公信力、与用户共同构建产品、专注于能与用户建立一对多联系的地方（在你们的案例中是 Twitter）、以及与用户建立关系以赢得信任，其中透明度是重要的一环。

---

### [01:25:25] Lenny

**English:**
And then step two is help them spread that product within the organization. And what you found was really important there. One is make it easy to share the product and try it for free. Two is designer advocates being involved in the sales process, have the Tom Factor. Find and target the operating thing that spreads adoption. In this case, I think it was design systems, you mentioned mostly. And then the final piece is shine a light on champions, and help them be successful. Make it help them in their career.

**中文翻译:**
然后第二步是帮助他们在组织内部传播产品。你发现其中重要的地方在于：第一，让产品易于分享和免费尝试。第二，让设计师布道师参与销售流程，发挥“Tom 因子”的作用。第三，找到并针对能推动采用的运营抓手（在你们的案例中主要是设计系统）。最后一点是关注拥护者，帮助他们获得成功，让产品助力他们的职业生涯。

---

### [01:25:35] Claire Butler (Lightning Round: Books)

**English:**
I recommend management books to lots of people. Radical Candor and Dare to Lead, to be honest, are the ones I recommend the most. Because I do a lot of coaching new managers and helping them learn how to manage. And those are the first two I start with, because they're so good.

**中文翻译:**
我向很多人推荐管理类书籍。老实说，我推荐最多的是《彻底坦率》（Radical Candor）和《勇于领导》（Dare to Lead）。因为我经常辅导新经理，帮助他们学习如何管理。这两本书是我的首选，因为它们太棒了。

---

### [01:26:02] Claire Butler (Lightning Round: TV Show)

**English:**
I just watched 100 Foot Wave on HBO. And I watched it because I'm going to Portugal next week, and that's the place where they have the biggest waves in the world. And it was just really interesting to learn all about this, Nazare and Portugal, and all the waves and the surfing culture that's grown there. 

**中文翻译:**
我刚看了 HBO 的《百尺巨浪》（100 Foot Wave）。我看它是因为我下周要去葡萄牙，那里有世界上最高的浪。了解葡萄牙的纳扎雷（Nazare）、那里的巨浪以及兴起的冲浪文化，真的非常有趣。

---

### [01:26:48] Claire Butler (Lightning Round: Product)

**English:**
Okay. You might cut this because it's a little promotional, but FigJam. In the last couple of months, especially, I've spent a lot of time having to create strategies and files and explanations, and I've spent in meetings. And I spend all of my day in FigJam, literally, all of my day. And I work with Figma. I use the product. And I was using Figma for a long time. But FigJam for me, in my role, literally use it every single day. And now I cannot imagine living without it. It replaces so many different tools for me.

**中文翻译:**
好吧，你可能会剪掉这段，因为有点像打广告，但确实是 FigJam。特别是在过去的几个月里，我花了大量时间制定战略、创建文件和解释说明，还要开会。我整天都待在 FigJam 里，真的是整天。我在 Figma 工作，我使用这个产品。我用 Figma 很久了，但对我现在的角色来说，FigJam 是每天必用的。现在我无法想象没有它的生活，它为我替代了太多不同的工具。

---

### [01:27:39] Claire Butler (Lightning Round: Motto)

**English:**
I recently got, or not recently, in the last maybe five years, got this motto of consistent pressure over time as being more of my motto. And taking some of the pressure off of having to do things immediately, or get to a certain place too fast. I'm just much more in this mode of like, "You're not going to get everything done. It's a startup. But career, whatever, it's not going to happen immediately." You just have to keep working at it, and not giving up. And having that grit to keep going and keep pushing over time, is way more important than any immediate accomplishments.

**中文翻译:**
最近，或者说在过去的五年里，我把“长期持续的压力”（consistent pressure over time）作为我的座右铭。这减轻了我必须立即完成某事或过快达到某个目标的压力。我现在更多处于这种状态：“你不可能完成所有事情，毕竟这是初创公司。无论是职业生涯还是其他，都不会一蹴而就。” 你只需要坚持努力，不放弃。这种长期坚持、不断推进的韧性（grit），比任何眼前的成就都重要得多。

---

### [01:28:46] Claire Butler (Lightning Round: Figma Use Case)

**English:**
I think I mentioned this a little bit, but I use it for home renovation, FigJam especially. I renovated a house with my partner, and we're doing another one right now. And I couldn't do renovations without it. I copy and paste. I start with Pinterest, get ideas. But then I pull them all to the mood board on FigJam. And then I circle things, and this helps me communicate with my partner. I'll send it to him and get comments from him on stuff, links. So, yes. We also will draw out rooms and model things up, and have them on the iPad. Yep. Interior design and home renovations on FigJam.

**中文翻译:**
我想我稍微提过，我用它来做房屋装修，特别是 FigJam。我和我的伴侣装修了一套房子，现在正在装修另一套。没有它我简直没法装修。我会从 Pinterest 开始找灵感，然后把它们全部拉到 FigJam 的情绪板（mood board）上。我会圈出重点，这有助于我和伴侣沟通。我会发给他，听取他的意见，放上链接。是的，我们还会画出房间布局并建模，然后在 iPad 上查看。没错，在 FigJam 上做室内设计和房屋装修。

---

### [01:29:37] Claire Butler (Outro)

**English:**
I guess Twitter. I'm not active, per se, but that's probably ... I don't look at LinkedIn, so Twitter. That'd definitely be the place. Just Claire T. Butler there. And then, helpful to me, you can tell me your feedback on FigJam and Dev Mode. That would be really helpful to me. And then I guess the other thing is parenting tips with work. I'm a little nervous about that. I love my job, love my career. And I'm going to be a mom soon, and need to figure out how to make that work. So, I want to hear how other people have done that.

**中文翻译:**
我想是 Twitter。我本身不算活跃，但我基本不看 LinkedIn，所以 Twitter 肯定是找我的地方，账号是 Claire T. Butler。至于对我有什么帮助，你可以告诉我你对 FigJam 和开发模式的反馈，那对我很有用。另外就是关于平衡工作和育儿的建议。我对此有点紧张。我热爱我的工作和事业，但我很快就要当妈妈了，需要弄清楚如何平衡。所以我想听听别人是怎么做的。

---

### [01:31:02] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅。同时，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。