# Claire Hughes Johnson - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Claire Hughes Johnson.

---

### [00:00:00] Claire Hughes Johnson

**English:**
What I say to people at Stripe... In our onboarding, I used to run a session. I was like, "If you're not sure who the decision maker is, one, it's probably you. And I'd rather you act that way than not because you're going to like slow the whole company down. Follow a process and get it done, and don't forget to actually make a decision. And if you don't know who the decision maker is and you're worried it's not, you just ask. Don't get stuck." Too many people get stuck and it makes your work terrible, right? What do we all care about? Progress, impact, momentum. If anything I would say about advice to people generally is be a force for positive momentum and it will be actually a real career maker.

**中文翻译:**
我在 Stripe 对员工常说的话是……在我们的入职培训中，我以前经常主持一个环节。我会说：“如果你不确定谁是决策者，那么第一，那个人很可能就是你。我宁愿你表现得像个决策者，也不愿你畏首畏尾，因为那样会拖慢整个公司的进度。遵循流程，把事情办好，别忘了最后要真正做出决定。如果你不知道谁是决策者，又担心不是自己，那就直接问。不要卡在那里。” 太多人因为犹豫而停滞不前，这会让工作变得一团糟，对吧？我们大家在乎的是什么？是进展、影响力和势头。如果让我给大众提一点建议，那就是：成为推动积极势头的力量，这真的会成就你的职业生涯。

---

### [00:00:50] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today, my guest is Claire Hughes Johnson. Claire was most recently chief operating officer at Stripe for the past seven years, where she helped scale them from a small startup to the legendary company that it is today. Before that, she spent about 10 years at Google where she was VP of self-driving cars, VP of global online sales, director of sales and ops for Gmail, YouTube, Google Apps, and AdWords. Before that, she was in politics. She's also on the board of HubSpot and the Atlantic. And this week, she's releasing an incredible book called Scaling People, which in my opinion should be and likely will be on every founder's bookshelf. In our conversation, we dig into many of the meaty topics that her book covers, including building your operational cadence, defining your company and personal operating principles, your company's operating system.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天，我的嘉宾是 Claire Hughes Johnson。Claire 在过去七年里担任 Stripe 的首席运营官（COO），帮助公司从一家小型初创企业成长为今天的传奇公司。在此之前，她在 Google 工作了约 10 年，曾担任自动驾驶汽车副总裁、全球在线销售副总裁，以及 Gmail、YouTube、Google Apps 和 AdWords 的销售与运营总监。更早之前，她还涉足过政治领域。她目前还是 HubSpot 和《大西洋月刊》的董事会成员。本周，她发布了一本非常棒的新书，名为《Scaling People》（暂译：规模化人才管理），在我看来，这本书应该、也很有可能出现在每一位创始人的书架上。在我们的交谈中，我们深入探讨了书中涵盖的许多实质性话题，包括建立运营节奏、定义公司和个人的运营原则，以及公司的操作系统。

---

### [00:01:46] Lenny

**English:**
Also, tons of tactical advice around saying things that you cannot say, building self-awareness, distinguishing management from leadership, so much more. I say this a couple times in our conversation. If you enjoyed my newsletter and podcast and the fact that it's very tactical and full of templates and frameworks, you'll love Claire's book, and you'll love learning from Claire. I had such a good time chatting with Claire, and I know you'll learn a lot from this conversation. With that, I bring you Claire Hughes Johnson after a short word from our wonderful sponsors.

**中文翻译:**
此外，还有大量关于“说出你认为不能说的话”、建立自我意识、区分管理与领导力等方面的战术性建议。我在对话中多次提到：如果你喜欢我的邮件通讯和播客，喜欢那种充满实操性、模板和框架的内容，那么你一定会爱上 Claire 的书，也会喜欢向她学习。和 Claire 聊天非常愉快，我知道你们会从这次对话中获益匪浅。在听完我们优秀赞助商的简短广告后，让我们正式欢迎 Claire Hughes Johnson。

---

### [00:02:19] Lenny (Sponsor - Linear)

**English:**
This episode is brought to you by Linear. Let's be honest, the issue tracker that you're using today isn't very helpful. Why is it that it always seems to be working against you instead of working for you? Why does it feel like such a chore to use? Well, Linear is different. It's incredibly fast, beautifully designed, and it comes with powerful workflows that streamline your entire product development process, from issue tracking all the way to managing product roadmaps. Linear is designed for the way modern software teams work. What users love about linear are the powerful keyboard shortcuts, efficient GitHub integrations, cycles that actually create progress, and built-in project updates that keep everyone in sync. In short, it just works. Linear is the default tool of choice among startups, and it powers a wide range of large established companies such as Vercel, Retool, and Cash App. See for yourself why product teams describe using linear as magical. Visit linear.app/lenny to try Linear for free with your team, and get 25% off when you upgrade. That's linear.app/lenny.

**中文翻译:**
本期节目由 Linear 赞助。说实话，你现在用的问题追踪工具可能并不好用。为什么它总是感觉在跟你作对，而不是在帮你？为什么用起来像是在干苦力活？Linear 则完全不同。它速度极快，设计精美，并配有强大的工作流，可以简化从问题追踪到产品路线图管理的整个开发过程。Linear 是为现代软件团队的工作方式而设计的。用户最喜欢 Linear 的地方在于其强大的键盘快捷键、高效的 GitHub 集成、能真正推动进展的周期（Cycles）管理，以及让所有人保持同步的内置项目更新功能。简而言之，它就是好用。Linear 是初创公司的首选工具，也为 Vercel、Retool 和 Cash App 等大型成熟公司提供动力。亲自去看看为什么产品团队会用“神奇”来形容 Linear。访问 linear.app/lenny 免费试用，升级时可享受 25% 的折扣。

---

### [00:03:27] Lenny (Sponsor - Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or are you going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data, and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table. Getting a SOC 2 report can be a huge burden, especially for startups. It's time consuming, tedious, and expensive. Enter Vanta. Over 3000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time, Lenny's podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny. That's vanta.com/lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
本期节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。如果你的业务在云端存储数据，那么你很可能已经被问到或即将被问到 SOC 2 合规性。SOC 2 是证明公司已采取适当安全措施保护客户数据的一种方式，能赢得客户和合作伙伴的信任，尤其是那些有严格安全要求的客户。此外，如果你想向企业级客户销售产品，证明安全性至关重要。SOC 2 既能为你开启大额订单的大门，也可能让你的业务停滞不前。如果没有 SOC 2，你很可能连谈判桌都上不去。获取 SOC 2 报告可能是一个巨大的负担，尤其是对初创公司而言，既耗时、繁琐又昂贵。Vanta 应运而生。超过 3000 家快速增长的公司使用 Vanta 自动完成高达 90% 的 SOC 2 相关工作。Vanta 能让你在几周内（而不是几个月）做好安全审计准备，时间不到通常所需的三分之一。在限定时间内，Lenny 播客的听众可享受 1000 美元的优惠。只需访问 vanta.com/lenny 即可了解更多并领取折扣。

---

### [00:04:47] Lenny

**English:**
Claire, welcome to the podcast.

**中文翻译:**
Claire，欢迎来到我们的播客。

---

### [00:04:49] Claire Hughes Johnson

**English:**
Thank you, Lenny.

**中文翻译:**
谢谢你，Lenny。

---

### [00:04:51] Lenny

**English:**
So you wrote this book. It's called Scaling People. It's coming out this week. I actually read a preview copy, and it's incredible. Everyone listening to this should buy it, especially if you're a fan of this podcast. It's full of frameworks and templates and guides and all these things that I try to do with my newsletter and podcast. And so if you like what I do, you're going to love this book. And I can't imagine how much work it must have taken to write a book like this. So my first question just how relieved are you that you're done with this book and you can move on with your life?

**中文翻译:**
你写了这本书，叫《Scaling People》，本周就要出版了。我读了预览版，写得太棒了。听这期节目的每个人都应该买一本，尤其是如果你是这个播客的粉丝。书中充满了框架、模板和指南，这些正是我在邮件通讯和播客中努力呈现的内容。所以如果你喜欢我的风格，你一定会爱上这本书。我无法想象写这样一本书需要付出多少心血。所以我的第一个问题是：写完这本书，你现在有多轻松？终于可以继续过自己的生活了。

---

### [00:05:21] Claire Hughes Johnson

**English:**
I am so relieved, Lenny. Writing this book was not my idea. Patrick and John Collison, Stripe's co-founders, really sort of pushed me into it. And I'm glad they did. I will admit that, as I am with most things they pushed me into, but it was a lot more work than I thought it would be, and it's very rewarding to have it done. Of course, though I've been re-looking at it and realizing there are things I want to add information or tweak what I originally said, but maybe we'll have to do a second edition. We'll see.

**中文翻译:**
我太轻松了，Lenny。写这本书其实不是我的主意。Stripe 的联合创始人 Patrick 和 John Collison 真的算是“逼”着我写的。我很庆幸他们这么做了，就像他们推着我做的绝大多数事情一样，我最终都会感到庆幸。但工作量确实比我想象的要大得多，完成它非常有成就感。当然，我现在重新翻看时，会发现有些地方我想补充信息，或者调整一下最初的说法，但也许我们要等第二版了，到时候再看吧。

---

### [00:05:55] Lenny

**English:**
That's the benefit of a newsletter. I can just edit things and they're immediately live.

**中文翻译:**
这就是写邮件通讯的好处，我可以随时修改，然后立即生效。

---

### [00:05:59] Claire Hughes Johnson

**English:**
Yes.

**中文翻译:**
没错。

---

### [00:06:01] Lenny

**English:**
I want to talk about John and Patrick a little bit. But before that, something I wanted to ask is I find that when I write stuff, I am able to better understand and crystallize my own thinking. And I'm curious, having written this book, what is it that you were able to better understand and crystallize in your own thinking through that process?

**中文翻译:**
我想聊聊 John 和 Patrick。但在那之前，我想问的是，我发现当我写东西时，我能更好地理解并固化（crystallize）自己的想法。我很好奇，在写这本书的过程中，你通过这个过程更好地理解或固化了哪些你自己的思考？

---

### [00:06:20] Claire Hughes Johnson

**English:**
It's true, and it's funny, because if you asked me, I would've said I crystallize more by talking and speaking. But whenever I do write something down, I'm glad I did. So I probably do more crystallizing by writing than I would admit, but maybe I'm just lazy and I just like to talk. There's a part of the book, I think it's toward the end of the third chapter, which is about hiring, and that's a really long chapter. Turns out I had a lot to say about hiring and hiring leaders and processes and what you need want to set up. And as I got toward the end of the chapter, I found myself saying to the reader... You maybe have read this and thought, is she for real? You need to do all this work? You need to put all of this in? And I had to say, well, look... I started the chapter saying, if you believe that talent is everything, then your hiring process is everything.

**中文翻译:**
确实如此。很有趣，因为如果你问我，我会说我更多是通过交谈和演讲来理清思路的。但每当我写下一些东西时，我都会庆幸自己写了。所以我通过写作固化的思考可能比我愿意承认的要多，也许我只是懒，喜欢说话。书中有一部分，大概在第三章末尾，是关于招聘的，那一章非常长。事实证明，关于招聘、招聘领导者、流程以及你需要建立的机制，我有很多话要说。当我写到那一章末尾时，我发现自己在对读者说……你读到这里可能会想：她是认真的吗？真的需要做这么多工作吗？需要投入这么多精力吗？我不得不说，听着……我在这一章开头就说了，如果你相信人才就是一切，那么你的招聘流程就是一切。

---

### [00:07:11] Claire Hughes Johnson

**English:**
And so yes, you do need to put that work in. But I think, Lenny, to your point, when you see all the templates and the frameworks and the examples and the advice from my career... And I was at Google for almost 11 years, I joined Google when it was about 1800 people pre IPO and left when it was about 60,000. I had eight different jobs while I was there. And then joining Stripe when it was about 160 people, and now we're over 7,000 people. Yeah, I have a lot of examples, but really what's crystallized is how much work it is to build, to build a company. You know this. And I hope this book is a bit of a shortcut, but there are no shortcuts. I hope it will accelerate people's knowledge so that they can get down to work with our product and with our customers.

**中文翻译:**
所以，是的，你确实需要投入这些工作。但是 Lenny，正如你所说，当你看到所有的模板、框架、案例以及我职业生涯中的建议时……我在 Google 待了将近 11 年，加入时公司大约 1800 人（IPO 前），离开时大约 6 万人，期间我换了 8 个不同的岗位。然后加入 Stripe 时大约 160 人，现在已经超过 7000 人了。是的，我有很多案例，但真正固化下来的认知是：创办并建立一家公司需要付出巨大的努力。你也知道这一点。我希望这本书能成为一种捷径，但实际上并没有真正的捷径。我希望它能加速人们获取知识的过程，这样他们就能全身心地投入到产品和客户工作中去。

---

### [00:07:58] Lenny

**English:**
There's a story you share at the end of the book, I think it's in acknowledgements, about how people went and took John Collison out for dinner and were just picking his brain, and "How did you scale Stripe? How did you build this amazing machine of a company?" And he often came back from these dinners, and he's just like, "Claire, they just want to talk to you. You did all these things, not me." And it sounds like that kind of encouraged you to write things down, and then led to this book. One, is that true? And then two, I'm curious, what else did you learn from John and Patrick Collison that have stuck with you? I imagine there's a lot, but kind of what stands out?

**中文翻译:**
你在书末（好像是致谢部分）分享了一个故事，说人们请 John Collison 吃饭，向他请教：“你是如何规模化 Stripe 的？你是如何打造出这样一个神奇的公司机器的？”他经常从这些饭局回来后对你说：“Claire，他们其实想找你聊。这些事都是你做的，不是我。”听起来这像是鼓励你把东西写下来，并最终促成了这本书。第一，这是真的吗？第二，我很想知道，你从 John 和 Patrick Collison 身上还学到了哪些让你记忆深刻的东西？我想肯定有很多，但哪些最突出？

---

### [00:08:31] Claire Hughes Johnson

**English:**
Yeah, no, absolutely. I think it is true that at Stripe, we're fortunate where we have so many users, customers who are themselves founders or interesting companies growing up around the world, whether at scale like Amazon or scaling. I've spent time with Discord and Toast and all kinds of interesting companies that are growing up around us. And a lot of their questions are not necessarily about Stripe's products always. They're really about, "Well, how do you guys do this thing?" Or "We're having this challenge. Are you having this challenge?" And John, yeah, would often come back from trips. He would travel more, and he is often probably meets with more customers than anyone in the Stripe leadership team, maybe other than our sales leaders. And they would ask about scaling, and he would joke. He's like, "We need Claire in a box." So I think the book is Claire in a box, I guess.

**中文翻译:**
是的，绝对是真的。在 Stripe，我们很幸运拥有这么多用户和客户，他们本身就是创始人，或者是世界各地正在成长的有趣公司，无论是像亚马逊那样规模巨大的，还是正在扩张中的。我曾与 Discord、Toast 以及我们周围各种有趣的成长型公司交流过。他们的很多问题并不总是关于 Stripe 的产品，而是关于：“你们是怎么处理这件事的？”或者“我们遇到了这个挑战，你们也遇到了吗？”John 经常出差回来，他出差很多，见过的客户可能比 Stripe 领导团队中的任何人都多（除了销售主管）。他们会问起规模化的问题，他就会开玩笑说：“我们需要一个‘盒子里的 Claire’（意指便携版的 Claire）。”所以我想，这本书就是那个“盒子里的 Claire”吧。

---

### [00:09:23] Claire Hughes Johnson

**English:**
But Patrick also would have that same experience. And when I contributed a chapter to Elad Gil's High Growth Handbook, even though if you look at High Growth Handbook, which I also really do recommend not just because I'm in it, I'm probably the least, I don't know, celebrity participant in his chapters, and my chapter got a lot of traction because I think it was very specific. It was very tactical. And Elad actually helped me to realize, look, examples and details and frameworks, my working with Claire document is in there, is like... He said it's catnip. And I think that is also what inspired Patrick to push me to do basically a longer version of that chapter that I did with Elad. But I've learned a lot from both of them. I used to think that I was... My parents are teachers, Lenny. I used to think I was very curious, and I'm a learner and I'll seek out information.

**中文翻译:**
Patrick 也有同样的经历。当我为 Elad Gil 的《High Growth Handbook》（高增长手册）贡献一个章节时——我也非常推荐这本书，不只是因为我参与了，虽然在那些章节中我可能是最没名气的参与者——但我的那一章反响很大，因为我觉得它非常具体、非常有实操性。Elad 帮我意识到，案例、细节和框架（比如我那份《与 Claire 共事》的文档就在里面）就像是……他说那是“猫薄荷”（让人上瘾）。我想这也是启发 Patrick 推动我写一本长篇著作的原因，基本上就是我和 Elad 合作那一章的扩充版。我从他们两人身上学到了很多。我以前觉得……Lenny，我的父母都是老师，所以我一直觉得自己很有好奇心，是个学习者，会主动寻找信息。

---

### [00:10:21] Claire Hughes Johnson

**English:**
And I grew up in a very educatory environment, right? Well, once I met the Collisons, the two of them are huge sponges, seeking out knowledge constantly. But also, anytime we were confronted with anything, even things I felt I'd done before, that I had the experience and we were going to build it, they were like, "Well, who have you talked to?" Or "What have you read?" And it was really good. I don't think I made enough phone calls in my earlier career and asked people's advice and asked for help and found the person who did that thing five years ago and found out what they learned. And I think that's probably my biggest lesson from working with both of them, is how much it pays to seek out knowledge from others because we're all just learning all the time.

**中文翻译:**
我在一个非常有教育氛围的环境中长大，对吧？但当我遇到 Collison 兄弟后，发现他们简直是巨大的海绵，不断地吸收知识。而且，每当我们面临任何事情时，即使是我觉得以前做过、有经验、可以直接上手的事情，他们都会问：“你跟谁聊过这件事？”或者“你读过什么相关的资料？”这真的很好。我觉得在我职业生涯早期，我打的咨询电话不够多，没有足够多地征求别人的建议、寻求帮助，没有去找那个五年前做过这件事的人，问问他们学到了什么。我想这可能是我与他们共事中学到的最大教训：向他人寻求知识是多么值得，因为我们所有人其实一直都在学习。

---

### [00:11:11] Lenny

**English:**
Is there a story or example of that comes to mind that was really beneficial where you actually ended up follow that advice and reached out to someone, talked to someone, and that changed the way you think, changed the way you operate?

**中文翻译:**
有没有什么故事或例子让你印象深刻？就是你最终听从了建议，联系了某人并进行了交谈，从而改变了你的思维方式或运作方式？

---

### [00:11:21] Claire Hughes Johnson

**English:**
There are two things that just jumped into my mind. The first one is early on at Stripe... When I joined, we were about 160 people. I started bringing in some leaders. We were building out go to market, we were starting to stabilize our support operations, building out recruiting and HR, all the things. We were really growing. And it became very apparent that we needed to put in some kind of job structure. Levels and ladders is what you would call it, which is there are different levels of pay, and they have to do with your experience and your impact and their expectations of those different levels, right? There's an engineering ladder. And this stuff is probably making some people listening like their skin start to crawl because it's never fun or easy to define all that, and it's not perfect. You're immediately getting into something that feels pretty suboptimal, but it is worse to have nothing because it starts to feel very unfair in the environment, especially if you have to start to change up compensation and reward or reward systems, right?

**中文翻译:**
我脑子里立刻跳出两件事。第一件是在 Stripe 早期……我加入时大约 160 人。我开始引入一些领导者，我们正在建立市场进入策略，稳定支持运营，建立招聘和人力资源体系，所有这些。我们增长非常快。当时变得非常明显的是，我们需要建立某种职位结构，也就是所谓的“职级与晋升阶梯”（Levels and Ladders），即不同的薪酬等级，这与你的经验、影响力和对不同等级的期望挂钩，对吧？比如工程师职级。听众里可能有人听到这些会觉得头皮发麻，因为定义这些东西从来都不好玩也不容易，而且永远不完美。你一旦开始做，就会觉得这方案不够理想，但什么都没有反而更糟，因为环境会开始让人觉得不公平，尤其是当你需要调整薪酬和奖励制度时。

---

### [00:12:24] Claire Hughes Johnson

**English:**
So I realized, oh my gosh, we're going to have to put this in place. We didn't know HR people, so I basically ran a project. And the first thing I did though, thanks to Patrick and John, is I talked to Square, I talked to Airbnb, and I talked to two or three other companies. But those two conversations, I'm not going to say who said this, but one of them, the person said, "Oh, that's a blood bath." They were not encouraging about what we were about to go through. And another one said, "You know what? I'm so impressed that you're doing that so early. We waited too long." And actually, that's what a lot of my book. It's about is when should you start to think about this thing that you might need, right? And it's sooner than you think. And so putting in levels of ladders felt like ripping the off, honestly, but I was glad. One company I talked to waited until they were like 800 people, and it was apparently not fun because people don't like to be... Who likes to be categorized?

**中文翻译:**
所以我意识到，天哪，我们必须把这个建立起来。当时我们不认识什么 HR 专家，所以我基本上是自己带这个项目。多亏了 Patrick 和 John，我做的第一件事就是去咨询 Square、Airbnb 以及其他两三家公司。在那两场对话中（我不说是谁说的），其中一个人说：“噢，那简直是一场血战。”他们对我们即将经历的事情并不乐观。而另一个人说：“你知道吗？我很佩服你们这么早就开始做这件事。我们等得太久了。”事实上，我书中的很多内容都在讨论：你什么时候该开始考虑你可能需要的这些机制？答案通常比你想象的要早。老实说，建立职级阶梯感觉就像在撕掉创口贴一样痛苦，但我很庆幸我们做了。我聊过的一家公司等到 800 人才开始做，显然过程非常不愉快，因为没人喜欢被……谁喜欢被归类呢？

---

### [00:13:26] Lenny

**English:**
Yeah, and put it at a level that maybe they're not happy with, right? They're like, "Oh, I thought I was a lot more senior than that."

**中文翻译:**
是啊，而且还被定在一个他们可能不满意的级别，对吧？他们会想：“噢，我以为我比这资深得多。”

---

### [00:13:32] Claire Hughes Johnson

**English:**
Yep. Yeah, exactly. It's not easy. It's a form of change challenging. And I would not say we did it perfectly, but I'm glad we did it. I think that example was definitely one of them. Another was like we were really... We wanted to roll out 24/7 support in multiple channels, email, phone, chat in multiple languages and getting from where we were to where we wanted to be as quickly as possible. Not many companies have done at the scale, because Stripe has millions of customers. We're B2B, but we're B2B at a very high scale, which actually Google was as well. And so that was beneficial to me coming into the Stripe environment because I'd done parts of that for Google. And again, that's an example of something I thought I knew how to do, sort of, but we certainly didn't do it perfectly, and it's certainly different when you're talking about payments.

**中文翻译:**
没错。这不容易，是一种变革挑战。我不会说我们做得完美，但我很高兴我们做了。这个例子绝对是其中之一。另一个例子是，我们当时非常想在多个渠道（邮件、电话、聊天）推出多种语言的 24/7 全天候支持，并尽可能快地实现目标。没有多少公司能做到这种规模，因为 Stripe 有数百万客户。我们是 B2B，但是是超大规模的 B2B，Google 其实也是这样。所以进入 Stripe 环境对我很有利，因为我在 Google 做过类似的工作。这又是一个例子：我以为自己知道怎么做，但我们肯定没做到完美，而且涉及到支付领域时，情况完全不同。

---

### [00:14:24] Claire Hughes Johnson

**English:**
That's people's money. That is a business'... If they don't know how to contact you and they have a problem, that is a huge issue. And so I did seek out a lot of advice. And I would say... Did anything change dramatically what we did? I think if anything, the advice pushed me to go faster on some of my intuitions about, for example, using vendors and outsourcing parts of the model. And I realized we're not going to scale all this internally, especially not at the speed that we're going, but it's hard to start to use outside sort of contractors if you haven't filled figured out all your tools and processes. So that balance was sort of freaking me out, but you just got to push through it.

**中文翻译:**
那是人们的钱。那是企业的命脉……如果他们出了问题却不知道怎么联系你，那就是巨大的问题。所以我寻求了很多建议。我会说……有什么建议戏剧性地改变了我们的做法吗？我觉得如果有的话，那些建议促使我在某些直觉上行动得更快，比如使用供应商和外包部分业务模式。我意识到我们不可能全部靠内部规模化，尤其是以我们当时的速度，但如果你还没理顺所有的工具和流程，就很难开始使用外部承包商。所以那种平衡感一度让我很抓狂，但你必须挺过去。

---

### [00:15:15] Lenny

**English:**
There's a couple directions I want to go, but I'll go in an unexpected direction. At Stripe, you're kind of infamous for your titles. When I created this career ladder document.

**中文翻译:**
我想聊几个方向，但先选一个出人意料的。在 Stripe，你们的头衔（titles）其实挺出名的。当我看到职业阶梯文档时……

---

### [00:15:24] Claire Hughes Johnson

**English:**
[inaudible 00:15:24].

**中文翻译:**
（听不清）

---

### [00:15:24] Lenny

**English:**
Yeah, it's like everyone's product manager. They're like a VP of product potential and it's like product manager. What's the rationale behind that? I guess, and what's the benefit of that? But, we don't have to go too far down the road. I'm just curious.

**中文翻译:**
是啊，就像每个人都只是“产品经理”。哪怕他们有副总裁（VP）的潜质，头衔也只是“产品经理”。这背后的逻辑是什么？这样做有什么好处？我们不用深挖，我只是好奇。

---

### [00:15:37] Claire Hughes Johnson

**English:**
So this is something that Patrick and I actually really agreed on without a lot of discussion, which is not always the case. It has to do with a combination of optionality as you scale and grow, and also culture, right? And the minute you start titling a lot, you're signaling hierarchy and authority. And the culture piece to Stripe still today, which is I think we could use more, at least more overt trappings of structure because it can get confusing. And I'll be the first to tell you that, and I admit that this might have carried on too far. But early on, at Stripe, there's a real belief. It's not a particularly hierarchical company. And if you're the person who has the knowledge, you are the expert on the thing, you better be, one, in the room helping make the decision, and two, driving, helping to drive the decision. And I don't care how senior you are, right? And that was the cultural signal that was important, which was about mutual ownership, and also expertise not sitting in hierarchy.

**中文翻译:**
这是我和 Patrick 在没有太多讨论的情况下就达成高度一致的事情，这并不常见。这涉及到规模化过程中的“选择权”（optionality）和“文化”的结合。一旦你开始给很多头衔，你就在释放等级制度和权威的信号。Stripe 的文化直到今天依然如此——虽然我觉得我们可以多一点明显的结构装饰，因为有时会让人困惑，我承认这一点，甚至承认我们可能做得有点过头了。但在 Stripe 早期，有一种坚定的信念：这不是一家等级森严的公司。如果你是掌握知识的人，你是某个领域的专家，那么你最好：第一，在现场参与决策；第二，推动决策。我不管你资历有多深。这就是我们要释放的重要文化信号：共同所有权，以及专业知识不应屈居于等级制度之下。

---

### [00:16:43] Claire Hughes Johnson

**English:**
And then the optionality thing is probably a little more obvious, which is don't make somebody the CMO, or even the head of marketing, if you're marketing team is two people, right? Yeah, you might make the right choice, but two years later, your marketing team's probably going to be more than two people, say it's 20. And are you going to have to layer somebody or have too many titles? And then someone feels like they're losing something, right? It goes back to the levels and ladder saying, but it's worse because you've given something, and then you're sort of taking it away, and that's just not... Organizationally, you want more flexibility. Honestly, I'll say my final thing, which is I have a little bit of a knit where you meet a company. I get what's happened, which is in order to hire this person, they had to sort of say, "I'll make you the VP of sales or the VP of this," but the company's like 25 people and there's seven VPs.

**中文翻译:**
关于“选择权”这一点可能更显而易见：如果你的营销团队只有两个人，就不要封某人为 CMO 甚至营销负责人，对吧？也许你现在选对了人，但两年后，你的营销团队可能有 20 人。到时候你是要在上面再加一层领导，还是给出一堆头衔？然后有人会觉得他们失去了什么。这又回到了职级阶梯的问题，但情况更糟，因为你先给了人家东西，然后又变相拿走，这在组织上不可取。你想要更多的灵活性。老实说，我最后想说的一点是，我有时会遇到一些公司，我明白发生了什么——为了招到某人，他们不得不承诺“我让你当销售副总裁或某某副总裁”，但公司一共才 25 个人，却有 7 个副总裁。

---

### [00:17:40] Lenny

**English:**
If you're a customer or you're evaluating it, you're kind of like, "Really?" It's a little incongruous with the scale. So we kind of more flexible. We had a lot of growth, head of this or growth lead. I know you're all about growth, Lenny. Well, we definitely took growth and find that very broadly. But the other thing I've said to people internally... Sorry, you can really get me going on this one. I bet you didn't think that. If you are a stripe and you're going out into the market, actually it speaks to the same thing, which is you're going and trying to sell to a customer who's a lot bigger than you. I'm not saying make up a title. Don't say you're the VP of sales, but you can be creative about how you represent your scope because you probably have really big scope because you're one of the only people helping to sell the product. And that will help you because a lot of more established mature companies are trying to do that hierarchy match, where "Well, bring your SVP because my SVP is coming to the meeting."

**中文翻译:**
如果你是客户或者正在评估这家公司，你会觉得：“真的吗？”这和规模太不相称了。所以我们更灵活一些。我们有很多“增长负责人”或“增长主管”。Lenny，我知道你很关注增长。我们对增长的定义非常广泛。但我对内部员工说的另一件事是……抱歉，聊到这个我就停不下来，你肯定没想到。如果你在 Stripe 工作并走向市场，其实道理是一样的：你去向一个比你大得多的客户推销。我不是说要捏造头衔，不要自称销售副总裁，但你可以创造性地描述你的职责范围，因为你可能确实职责重大，因为你是仅有的几个推销产品的人之一。这会对你有帮助，因为很多成熟的大公司喜欢搞“等级对等”，比如“请带上你们的高级副总裁（SVP），因为我们的 SVP 也会参加会议”。

---

### [00:18:42] Claire Hughes Johnson

**English:**
And we could be like, we don't really have that. It just gives you a little more selling flexibility too.

**中文翻译:**
我们可以说，我们其实没这种头衔。这在销售上也给了你更多的灵活性。

---

### [00:18:48] Lenny

**English:**
I like that. I like combo where you can just say something that fits in this situation, even though that's not your technical title.

**中文翻译:**
我喜欢这种做法。这种组合让你能根据情况说出合适的描述，即使那不是你的正式技术头衔。

---

### [00:18:53] Claire Hughes Johnson

**English:**
Yes, you can say, "Oh yeah, I actually am in charge of optimization for our payments product." I'm sure you are. I'm sure that's what you do.

**中文翻译:**
是的，你可以说：“噢，是的，我实际上负责我们支付产品的优化工作。”我相信你确实在做这些。

---

### [00:19:01] Lenny

**English:**
Coming back to something you talked about with the career ladder, and I had a question around this, you talked about how oftentimes people do it too late, and I'm curious why it's so important to think about the stuff that you wrote about in this book so early in your company's life cycle. I think in the book you mentioned that it's oftentimes as important to get your operational structure and cultural structures in place incorrect as finding product market fit or finding your first few customers, which I think would surprised a lot of people. Can you talk about why you found that to be so important?

**中文翻译:**
回到你提到的职业阶梯，我有个相关的问题。你说人们往往做得太晚了。我很想知道，为什么在公司生命周期的早期就考虑你书中写的这些东西如此重要？你在书中提到，建立正确的运营结构和文化结构，往往与找到产品市场契合点（PMF）或找到前几个客户同样重要，我觉得这会让很多人感到惊讶。你能谈谈为什么你觉得这如此重要吗？

---

### [00:19:35] Claire Hughes Johnson

**English:**
Not only can I talk about it, I wrote a whole book about it, so let's try to restrain me. But here's what I would say. Obviously product market fit is the most important. And what I do say in the book is focus on that and don't get too far. My book is definitely not zero to one. It's more like maybe 0.5 to 1.5 or one to two. Because I do think when you're smaller and focused on product market fit and finding your user and getting that traction, that shapes a lot of how you work and your goals and who you hire, and that all makes sense. I think the thing that happens though is, one, some companies don't quite realize they're hitting it and they start to get behind on actually building the company part. Because guess what?

**中文翻译:**
我不光能谈，我还写了一整本书，所以得控制一下我的表达欲。但我想说的是：显然，产品市场契合点是最重要的。我在书中也说了，要专注于此，不要跑得太偏。我的书绝对不是讲“从 0 到 1”的，更像是“从 0.5 到 1.5”或者“从 1 到 2”。因为我认为当你规模较小、专注于 PMF、寻找用户并获得增长势头时，这会塑造你的工作方式、目标和招聘对象，这都是合理的。但问题在于：第一，有些公司没意识到自己已经达到了那个点，于是他们在“建立公司”这一部分开始落后了。因为你猜怎么着？

---

### [00:20:23] Claire Hughes Johnson

**English:**
It turns out product market fit is just the product, and that is not a company, and that will not scale, to point. You see these companies that sort of fall over and there's sort of a bad article about them, and often it's not the product, it's the fact that they didn't actually build the company very well, and that started to harm, in fact harm the product and harm the mission. You have this vision, you're going to solve this problem with this product. And all of a sudden you can't solve it because you didn't scale the org properly. You didn't keep the cultural fabric strong as you grew, right? And so that's why I think it's so important. And so let's say you are hitting traction, and hopefully you do notice it. Because I think a lot of founders, you're kind of paranoid.

**中文翻译:**
事实证明，产品市场契合点仅仅关乎产品，而产品并不等于公司，产品本身是无法规模化的。你会看到有些公司倒下了，媒体上出现了一些负面报道，通常出问题的不是产品，而是因为他们没有真正把公司建设好，这开始损害产品，甚至损害了使命。你有一个愿景，想用这个产品解决这个问题，但突然之间你解决不了了，因为你没有正确地扩展组织规模，没有在增长过程中保持文化纽带的牢固。这就是为什么我认为这如此重要。假设你获得了增长势头，希望你能察觉到。因为我觉得很多创始人其实挺偏执的。

---

### [00:21:08] Claire Hughes Johnson

**English:**
Like Stripe, I don't think Patrick and John fully embraced that they needed to start scaling maybe until I showed up, and that was part of hiring me. I was like, yeah, this is it. It's happening. It's not just look at the numbers. It's like look at the inbound support demand, look at the inbound sales leads. I just did the math, and I was like, this company should be probably twice the number of people it is right now, which of course freaked everybody out, but it was very obvious to me because I was coming in outside with that perspective. But more importantly, not just scaling things like sales and support... And as you probably know, if you work in payments, you've got a lot of other functions that are very important around risk and compliance and you name it, or the machine learning models and that help you do those things.

**中文翻译:**
拿 Stripe 来说，我觉得 Patrick 和 John 也许直到我出现才完全接受他们需要开始规模化了，这也是招募我的原因之一。我当时觉得，没错，就是现在，时机到了。不只是看财务数字，还要看涌入的支持需求，看涌入的销售线索。我算了一下账，觉得这家公司的人数应该是现在的两倍，这当然把大家都吓坏了，但对我这个带着外部视角进来的人来说，这是显而易见的。但更重要的是，不只是扩展销售和支持……如你所知，如果你从事支付行业，你还有很多其他非常重要的职能，比如风险控制、合规等等，或者是帮助你完成这些工作的机器学习模型。

---

### [00:21:55] Claire Hughes Johnson

**English:**
But for the sort of structures and operating processes that I talk about in the book, I do have this analogy which I think you picked up on to building a house, which is you have the supporting beam. Say it's a post and beam structure. You need the posts and the beams, and then you're going to have to do the mechanicals, right? There's going to have to be some amount of wiring in order for you. I don't know if you have your solar panels, but you got to bring in the heat, you got to bring in the cooling and plumbing, and then you have foundational stuff that you have to build or the whole structure will fall over. And I think of putting in the posts and beams and the mechanicals and the foundation as actually essential to scale. Because if you do those things well, you build them in such a way. This is almost like a Russian doll kind of thing, but you build them so that they're replicable, right?

**中文翻译:**
至于我在书中提到的结构和运营流程，我有一个类比，我想你也注意到了，就是“盖房子”。你有支撑梁，比如柱梁结构。你需要柱子和梁，然后你需要安装机电设备（mechanicals），对吧？你需要布线。我不知道你有没有太阳能电池板，但你得供暖、制冷、铺设管道，还有你必须打好的地基，否则整个结构都会倒塌。我认为安装柱梁、机电和地基对于规模化至关重要。因为如果你把这些做好了，你构建它们的方式——这有点像俄罗斯套娃——会让它们变得可复制。

---

### [00:22:49] Claire Hughes Johnson

**English:**
So the way that you do goals as a company can start at the company level, and this is how OKRs were so beautiful for Google and they can replicate down to the individual. And the same common structure allows that to happen at really different levels of scale. And that's what you're looking for, is what are these common things? We do not a lot of them, by the way. You don't want to mandate a lot, you don't want to put too much structure in place, but enough that everyone can play with it up and down what I would think of as the stack of the company. And if you don't start putting those things in early, people will just invent those things. And then you'll have... Picture a house that got added on to 17 times and it's not even two years old. It looks not super stable. And then you're going to find yourself having to do a tear down, which I think we've all seen companies do that.

**中文翻译:**
所以，你设定公司目标的方式可以从公司层面开始，这就是为什么 OKR 对 Google 如此有效，因为它们可以一直复制到个人层面。同样的通用结构允许这种情况在完全不同的规模水平上发生。这就是你要找的东西：这些通用的东西是什么？顺便说一下，我们做得并不多。你不想强制执行太多东西，不想建立太多的结构，但要足够让每个人都能在公司的“技术栈”中上下灵活运用。如果你不早点建立这些东西，人们就会自己发明。然后你就会看到……想象一个加盖了 17 次的房子，它甚至还不到两岁，看起来非常不稳定。然后你会发现自己不得不推倒重建，我想我们都见过有些公司经历过这种事。

---

### [00:23:40] Lenny

**English:**
I definitely want to get into that house structure and all the components of it. But before we get there, if you're a early stage founder just looking for product market fit, maybe the skipping ahead a little bit, but which elements do you think are the most important that they need to do now? Because they're going to read your book, which gives them so much advice on all the things you can do.

**中文翻译:**
我非常想深入探讨那个房子结构及其所有组成部分。但在那之前，如果你是一个处于早期阶段、正在寻找 PMF 的创始人，也许这有点超前，但你认为哪些元素是他们现在最需要做的？因为他们会读你的书，书中给了他们那么多关于可以做的事情的建议。

---

### [00:24:01] Claire Hughes Johnson

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:24:02] Lenny

**English:**
If you have to pick a couple things that you have to nail when you're just starting out before product market fit, what do you think is most important?

**中文翻译:**
如果你必须选出几件在刚开始、还没达到 PMF 之前必须搞定的事情，你认为最重要的是什么？

---

### [00:24:08] Claire Hughes Johnson

**English:**
I think really that early, keeping it very simple and being focused on that goal of product market, which is like what is the problem you're trying to solve? What's your vision? Everything you have to do for an investor pitch deck matters not just for the investors. By the way, people forget this. A lot of the story you tell to investors, early ones especially is the story you should be telling internally to anybody you hire. Why do we exist? What problem are we trying to solve? What early customers have we attracted, and what's their feedback. That's what you mostly need, but you need to remember to share it and don't just use it for fundraising, or don't just use it for a board meeting or an investor meeting. Use it internally. And I think you can get pretty far actually with that core content. As you start to...

**中文翻译:**
我认为在那么早期，要保持极度简单，专注于 PMF 的目标，也就是：你要解决什么问题？你的愿景是什么？你为投资者演示文稿（pitch deck）所做的一切，不仅对投资者重要。顺便说一下，人们常忘了这一点：你告诉投资者的故事，尤其是早期投资者的故事，正是你应该对内部招聘的任何人讲的故事。我们为什么存在？我们要解决什么问题？我们吸引了哪些早期客户，他们的反馈是什么？这就是你最需要的，但你要记得分享它，不要只在融资、董事会会议或投资者会议上用。要在内部使用它。我觉得有了这些核心内容，你其实可以走得很远。当你开始……

---

### [00:24:56] Claire Hughes Johnson

**English:**
The first thing you're probably putting in place is a little bit of hiring process, and I think that's going to matter sooner than you think. Don't just be tempted to hire people in your friends. Think about what you need, what capabilities you need to build even pre PMF, right? And so as I said, there's a chapter about that, but I think some of the simplest versions of it is how do we evaluate talent? What kind of talent are we looking for? Where do we go look for talent, figure that out, and sort of train people a bit internally on interviewing. I think interviewing is not a skill that comes naturally. People think it does. It does not. And there's really basic easy tips and tricks you can find even on the interwebs about interviewing. And I really recommend... And my book has examples of rubrics, questions you can use. How do you really get at... Because it's hard to really evaluate someone in 30 minutes or 45 minutes.

**中文翻译:**
你可能首先要建立的是一点点招聘流程，我认为这比你想象的要早。不要只是禁不住诱惑去招你的朋友。想想你需要什么，即使在 PMF 之前你需要建立什么样的能力，对吧？正如我所说，书中有一章专门讲这个，但我认为最简单的版本是：我们如何评估人才？我们在寻找什么样的人才？我们去哪里寻找人才？搞清楚这些，然后在内部对员工进行一点面试培训。我认为面试不是一种天生的技能。人们以为是，其实不是。你甚至可以在网上找到一些关于面试的非常基础、简单的技巧。我非常推荐……我的书里有评估表（rubrics）的例子，还有你可以使用的面试问题。你如何真正深入了解一个人……因为在 30 或 45 分钟内真正评估一个人是很难的。

---

### [00:25:49] Claire Hughes Johnson

**English:**
So I think interviewing some of your fun fundamental early investor kind of content you need. But then when you start to get some traction, then you're showing to codify and actually document what I call more foundational content. Because if you're pre-product market fit, you're probably small enough that you just can tell everybody all the things. You don't have to send them the packet or have them sit in the onboarding. But the minute that you're starting to get any kind of hiring speed, you're going to want to document it more and you're going to want to start to put some very lightweight processes of how you get things done in place, because again, you're trying to replicate velocity. It's easy when you're all in one room and everyone knows like, "Oh, this is the most important thing to get done today," hack, hack and hacking away. But then pretty quickly, that is not going to be the case.

**中文翻译:**
所以我认为面试技巧和你那些基础的早期投资者内容是你需要的。但当你开始获得一些增长势头时，你就需要开始编撰并记录我所说的“更基础的内容”。因为如果你还没达到 PMF，你可能规模很小，可以直接口头告诉所有人所有事。你不需要给他们发资料包，也不需要让他们参加正式入职培训。但一旦你开始有一定的招聘速度，你就需要更多地记录下来，并开始建立一些非常轻量化的办事流程，因为你是在试图复制“速度”。当大家都在一个房间里，每个人都知道“噢，这是今天最重要的事情”，然后埋头苦干时，这很容易。但很快，情况就不再是这样了。

---

### [00:26:38] Lenny

**English:**
I definitely want to go one layer deeper on that, but there's this area I wanted to get to before we dive into some of the weeds around that, which is I found it really interesting that you started your book with this idea of personal operating principles versus here's how the company should work. It starts with here's how you should think about yourself. So I want to go... There's four of them... But before I get into them, can you just describe what is the idea of a personal operating principle and why is that important?

**中文翻译:**
我肯定想再深入探讨一下，但在深入细节之前，我想聊聊另一个领域。我发现很有趣的是，你的书是以“个人运营原则”开篇的，而不是“公司应该如何运作”。它始于“你应该如何思考你自己”。所以我想聊聊……书里有四个原则……但在深入之前，你能描述一下什么是“个人运营原则”，以及为什么它很重要吗？

---

### [00:27:02] Claire Hughes Johnson

**English:**
Remember the book is about two things, company building and company structures, and all that, replicating all that good step and management. So the other thing that the book is really about is management tactical guides to... It would be easy to build companies if there weren't humans involved, right? But there's humans and they're complicated, and I'm complicated and you're complicated. And there are things that motivate us. There are things that demotivate us. They're not the same things, though Lenny and I, I think you and I have some things in common, but point is the book starts with you. And I think a lot of people think management starts with the team, or even the company. And actually, I think founders make this mistake. Founders think, well, it starts with my product. And yeah, but it actually starts with you. And so the book starts with sort of my belief system, which is self-awareness, which is the first operating principle. Self-awareness to build mutual awareness is actually the most fundamental thing you need to crack if you're going to succeed at company building or management, in my opinion.

**中文翻译:**
记住，这本书关乎两件事：公司建设和公司结构，以及复制那些好的步骤和管理。所以这本书的另一个核心是关于管理的战术指南……如果没有人参与，建立公司会很容易，对吧？但人是复杂的，我很复杂，你也很复杂。有些事情会激励我们，有些事情会让我们泄气。这些事情因人而异，虽然 Lenny，我觉得你和我有一些共同点，但重点是，这本书是从“你”开始的。我认为很多人觉得管理是从团队甚至公司开始的。实际上，我认为创始人常犯这个错误。创始人觉得，管理是从我的产品开始的。没错，但它实际上是从你开始的。所以这本书从我的信仰体系开始，也就是“自我意识”，这是第一个运营原则。在我看来，通过自我意识来建立“相互意识”，是你想要在公司建设或管理上取得成功必须攻克的最根本的东西。

---

### [00:28:08] Claire Hughes Johnson

**English:**
But I would say I'm one of those people who has strong opinions that are pretty loosely held. This one is a strong opinion strongly held, which is the more that you can seek feedback, seek to understand your motivators, your strengths, your blind spots, your tendencies, and take that on board and expose it to others, you're going to be a much more effective company builder and manager. So it starts with you. And those operating principles that I articulate are sort of mine, but they're also foundational to the content of the whole book. I do think authentic leaders tend to have their own, right? Lenny, you probably have a few that you... You maybe have not articulated them all out loud, but I do have mine and they're in the book, but I think you would also find that some of them you could adopt. If you were looking for were some to start to use as a leader, I would hope that I've put forward a couple that might be useful.

**中文翻译:**
但我会说，我是那种“持有强烈观点但并不固执己见”的人。但唯独这一条，是我“强烈持有且坚信”的观点：你越是能寻求反馈，寻求理解你的动力、优势、盲点和倾向，并接纳它们并向他人展示，你就越能成为一名有效的公司建设者和管理者。所以，一切始于你。我阐述的那些运营原则算是我个人的，但它们也是全书内容的基础。我认为真实的领导者往往都有自己的原则，对吧？Lenny，你可能也有几个……你可能还没把它们大声说出来，但我有我的，它们都在书里。我觉得你也会发现其中一些是可以采纳的。如果你正在寻找一些作为领导者可以开始使用的原则，我希望我提出的这几个会对你有用。

---

### [00:29:04] Lenny

**English:**
I want to talk about these four, but while you're on that topic, what are ways to help crystallize your own operating principles? What advice would you give people to do this? Because to your point, people probably have them in their head, but they haven't really written them out.

**中文翻译:**
我想聊聊这四个原则，但既然谈到这儿了，有什么方法可以帮助人们固化自己的运营原则？你会给人们什么建议？因为正如你所说，人们脑子里可能有这些想法，但还没真正写下来。

---

### [00:29:17] Claire Hughes Johnson

**English:**
That's right, they haven't. The book has an exercise that I recommend in it that's a little bit more about crystallizing your personal values, but that's kind of the place you want to start. And it's essentially there's a whole menu, and you can find these online, of say 70 or 80 different values. And by values, I mean family, ambition, impact competition. People value education. People value different things differently, by the way. And there's no judgment. You might value being a very competitive person and I might value collaboration above competitiveness, and that's fine. We probably would both be very effective in a team for different reasons, right? So basically if you take a list of values and you say, okay, if I had to pick 10 of these that matter to me, then if I had to pick five of them, and then you really force yourself if I had to only pick three of them...

**中文翻译:**
没错，他们还没写。书中有一个我推荐的练习，更多是关于固化你的“个人价值观”的，那是你该开始的地方。基本上有一个清单（你可以在网上找到），列出了大约 70 或 80 种不同的价值观。我所说的价值观是指：家庭、抱负、影响力、竞争。有人看重教育。顺便说一下，不同的人对不同事物的价值排序不同，这没有对错之分。你可能看重做一个极具竞争心的人，而我可能看重协作胜过竞争，这没问题。出于不同的原因，我们可能在团队中都非常有效，对吧？所以基本上，如果你拿出一份价值观清单，说：好吧，如果我必须选出 10 个对我重要的，然后选出 5 个，最后强迫自己只选出 3 个……

---

### [00:30:09] Claire Hughes Johnson

**English:**
And it's actually good to have this in a dialogue with someone that you work with or well, and you sort of had to explain, well, why? Why, when I'm really pushed, do I have to hold on to say education or learning as a value? Or why do I have to hold on to integrity as a value? And I tell a story in the book about a manager I worked with where transparency was a very important value to him. And the thing is you usually have a story behind that value, right? And in the book, I use the name Eli for him. Eli ends up sharing this story at this offsite that we had. And the transparency value actually was a little bit problematic to manage because Eli would tell everyone everything, including his team, even when we weren't finished with the plan, right? But Eli got up and told a story of being younger, like seven or eight, and realizing his mother was very sick, and no one really told him what was going on.

**中文翻译:**
实际上，最好是与你共事的人或了解你的人进行对话，你必须解释：为什么？为什么当我被逼到绝境时，我必须坚持“教育”或“学习”作为价值观？或者为什么我必须坚持“诚信”作为价值观？我在书里讲了一个和我共事过的经理的故事，对他来说，“透明度”是一个非常重要的价值观。问题是，每个价值观背后通常都有一个故事，对吧？在书里我叫他 Eli。Eli 在我们的一次团建（offsite）中分享了这个故事。其实“透明度”这个价值观在管理上有点麻烦，因为 Eli 会把所有事情告诉所有人，包括他的团队，甚至在我们的计划还没定稿时就说了。但 Eli 站起来讲了一个故事：他七八岁的时候，意识到母亲病得很重，但没人告诉他到底发生了什么。

---

### [00:31:07] Claire Hughes Johnson

**English:**
And then unfortunately watching the process of her dying and then being taken out to lunch by his stepfather and told, "Your mother is gone." And okay, well, your whole worldview kind of explodes when you hear that, and you're like, oh, okay, this transparency thing is really real. This was a formative experience for him and it has changed how he operates, and it will probably have changed it for his whole life. And if you can get to that point on your own, of telling yourself, what was the story? What was the thing that made this so important to me? Then you're starting to be in a mode of self-discovery and then you're starting to document, okay, if these are my three top values, and here's why. And then I think what you want to look for are my, what I would call my work style tendencies? And so you get your values, and then you sort of go on a... I'm sorry, I could go on about [inaudible 00:32:08]. I warned you. I wrote a book about this.

**中文翻译:**
不幸的是，他看着母亲去世，然后继父带他去吃午饭，告诉他：“你妈妈走了。”当你听到这个消息时，你的整个世界观都会崩塌，你会觉得：噢，好吧，这种“透明度”真的很重要。这对他来说是一次塑造性的经历，改变了他的运作方式，而且可能会改变他的一生。如果你能自己达到那个点，问问自己：那个故事是什么？是什么让这件事对我如此重要？那么你就开始进入自我发现模式，然后开始记录：好吧，如果这是我的三个核心价值观，原因如下。接着，我认为你要寻找的是我所说的“工作风格倾向”。你确定了价值观，然后你开始……抱歉，我可以一直讲下去（听不清）。我警告过你，我为此写了一本书。

---

### [00:32:09] Claire Hughes Johnson

**English:**
But basically, all these work style assessments, Myers-Briggs, DISC, Enneagram, you name it. And by the way, I would take all of them because I find that very good. I mean some of it's just data. You're just taking on data. But a lot of them come down to are you introverted or extroverted? Are you more introverted or extroverted? Where are you on that continuum? And are you more task, if you kind of picture a horizontal and a vertical, are you more task or people oriented? And so I would take your values, and then I would plot yourself. Am I a more extroverted task-oriented person, which means you're kind of a director, get what done kind of person? Or am I a more extroverted people-oriented person, which might mean actually you're probably great at being very charismatic and building some followership and maybe selling a vision? A lot of salespeople are very extroverted people oriented people.

**中文翻译:**
但基本上，所有的工作风格评估，比如 Myers-Briggs (MBTI)、DISC、九型人格等等。顺便说一下，我会把这些全测一遍，因为我觉得很有用。我的意思是，其中一部分只是数据，你只是在收集数据。但很多评估归结起来就是：你是内向还是外向？你在那个连续光谱的哪个位置？你是更偏向任务还是更偏向人？如果你想象一个横轴和纵轴，我会拿你的价值观，然后给自己定位。我是一个更外向、任务导向的人吗？这意味着你可能是一个“指挥型”、以结果为导向的人。还是我是一个更外向、人际导向的人？这可能意味着你非常有魅力，擅长建立追随者，或者擅长推销愿景。很多销售人员都是非常外向、人际导向的人。

---

### [00:33:03] Claire Hughes Johnson

**English:**
And then you start to see, okay, if this is my sort of tendency in my default and this is my value system, what are the ways that I operate that really make up who I am and becomes almost a belief system. And my operating principles in the book, one is to build self-awareness, to build mutual awareness. Another one is say the thing you think you cannot say. I think that I've come to believe that often your biggest strength, one, is also your weakness, but two, is something that you don't know is a big strength because it's almost like breathing. For me, saying something actually fairly openly and directly but in a non-threatening way is a thing I do. John Collison actually once said to me, he's like, "It's so interesting when you give feedback, that can be actually pretty brutal, I leave feeling really optimistic."

**中文翻译:**
然后你开始明白：好吧，如果这是我的默认倾向，这是我的价值体系，那么我运作的方式是如何构成“我是谁”的，并几乎成为一种信仰体系。我在书中的运营原则，一个是“建立自我意识以建立相互意识”。另一个是“说出你认为不能说的话”。我逐渐相信，通常你最大的优势，第一，也是你的弱点；第二，是你自己意识不到的巨大优势，因为它就像呼吸一样自然。对我来说，以一种相当公开、直接但没有威胁感的方式说出某些事情，就是我擅长的事。John Collison 曾经对我说：“很有趣，当你给反馈时，内容可能相当残酷，但我离开时却感觉非常乐观。”

---

### [00:34:02] Claire Hughes Johnson

**English:**
But I don't mean to be brutal, but I think I can sort of unpack and say this thing, like here's my observation, here's going on, and it's not judgmental, it's not threatening, it's actually opening up an opportunity for people. So say the thing you think you cannot say. You would actually find that more of us can do that. And then I come back to distinguish between being a leader and a manager, which is something early in my career, I did not do well, Lenny.

**中文翻译:**
我并不是想表现得残酷，但我认为我可以拆解并说出这件事，比如“这是我的观察，这是正在发生的情况”，它不带评判性，没有威胁感，实际上是为人们开启了一个机会。所以，说出你认为不能说的话。你会发现我们中更多的人其实可以做到这一点。然后我再回到“区分领导者和管理者”，这是我职业生涯早期做得不好的地方，Lenny。

---

### [00:34:30] Lenny

**English:**
Before we get to that one actually, just to briefly ask you a follow up question, because I love that you're getting through all four here. This is great. But I was going to ask, is there something.. So clearly, you're really good at saying the thing you cannot say, and I love that. Many people are not good at this.

**中文翻译:**
在聊那个原则之前，我想简短地追问一个问题，因为我很高兴你正在梳理这四个原则。这太棒了。但我想问，有没有什么……显然，你非常擅长说出那些“不能说的话”，我很喜欢这一点。但很多人并不擅长。

---

### [00:34:45] Lenny

**English:**
Do you have any tactical advice for someone that is not good at this for how to actually say something uncomfortable?

**中文翻译:**
对于那些不擅长此道的人，你有什么战术性的建议，教他们如何说出那些令人不舒服的话吗？

---

### [00:34:51] Claire Hughes Johnson

**English:**
I think the main thing is, and Fred Kaufman has this in his book, Conscious Business, this concept of a left hand... He calls it the left hand column, which is you're in a dialogue with me or you're watching a meeting happen, and you've got a running commentary in your head. And honestly, some of that stuff is pretty harsh, right? You do not want to open your mouth and just say that thing. But what Fred says is, learn how to detoxify the left-hand column. I would say think about a way to say that thing that you think you can't say. You've filtered yourself out, which I don't like. And I want you to think, okay, can I? And I think that the... Here are the tricks, a couple of them. One is, ask a question. Right? A question is not threatening. By the way, the question could even be, is there something we're not talking about? It feels like to me... And then you own.

**中文翻译:**
我认为最核心的一点是——Fred Kaufman 在他的书《Conscious Business》（清醒的企业）中提到了这个概念——“左手栏”（left hand column）。就是当你和我对话或者观察会议进行时，你脑子里会有一段实时评论。老实说，有些评论相当刻薄，对吧？你不想张嘴就说出那些话。但 Fred 说的是，要学会如何“排毒”你的左手栏。我会建议你想一种方式来说出你认为不能说的话。你把自己过滤掉了，我不喜欢这样。我希望你想想：好吧，我能说吗？这里有几个技巧：第一，提问。对吧？提问是没有威胁感的。顺便说一下，这个问题甚至可以是：“是不是有什么事情我们还没聊到？我感觉……”然后你要“认领”（own）这个观点。

---

### [00:35:47] Claire Hughes Johnson

**English:**
So the next trick is you own it. This is your observation, this is your perception. This is not a judgment. I am not saying, "Lenny, I think you really botched that interview." That's not useful. If I said, "Lenny, you know what? I wonder if you missed an opportunity in that interview. Did you feel like you missed an area that..." And then you're kind of curious. You're like, "What do you mean?" And I'm like, "Well, I'm kind of looking at this with you, and I'm standing next to you and I'm observing it." Right? That's less threatening. So one, ask a question. Two, make an observation that you own. So if I said, "I feel like there's something we're not talking about, and I wonder..." Oh, I own it. "I wonder if it's the fact that these two teams both seem to have the exact same project."

**中文翻译:**
所以下一个技巧是“认领它”。这是你的观察，这是你的感知，这不是评判。我不是在说：“Lenny，我觉得你把那次面试搞砸了。”那没用。如果我说：“Lenny，你知道吗？我在想你是不是在那次面试中错过了一个机会。你觉得你是不是漏掉了一个领域……”然后你就会产生好奇心，你会问：“你什么意思？”我会说：“嗯，我是在和你一起看这件事，我站在你身边观察它。”对吧？这样威胁感就小了。所以：1. 提问；2. 认领你的观察。比如我说：“我觉得有些事情我们没谈到，我在想……”噢，我认领了，“我在想是不是因为这两个团队似乎都在做同一个项目。”

---

### [00:36:32] Claire Hughes Johnson

**English:**
I talk in the book about a meeting I was in where it was very clear that we had two teams in conflict, and no one was saying the thing that was really pretty bad. I was like, this is pretty bad. We have two teams that seem like they both own a piece of work and are in conflict with one another. But I would say if you do those two things, ask a question, own the observation yourself, don't pass a judgment, you will get way farther than you would've ever thought sharing. And by the way, that sharing, one, there's probably other people who just haven't, can't get it out of their head, and you have ar opened up a door that a lot of others can probably walk through. You're not alone.

**中文翻译:**
我在书里讲过一次会议，当时很明显有两个团队在冲突，但没人说出那个非常糟糕的真相。我觉得这太糟了：两个团队似乎都认为自己拥有某项工作，并且彼此冲突。但我想说，如果你做这两件事——提问、认领观察、不加评判——你分享的效果会比你想象的好得多。顺便说一下，这种分享，第一，可能其他人脑子里也有同样的想法只是没说出来，你打开了一扇门，让很多人也能走进来。你并不孤单。

---

### [00:37:12] Lenny

**English:**
You have this framework, I think you call it being explorer, not a lecturer. Is that what you just described? Is that how you describe it?

**中文翻译:**
你有一个框架，我想你称之为“做探索者，而不是讲课者”。这就是你刚才描述的吗？你是这样定义的吗？

---

### [00:37:18] Claire Hughes Johnson

**English:**
It is. And to me, what I just talked about was more of a meeting or a conversation scenario, but I think that this... I'm glad you brought that up. I think this is actually a very fundamental management framework of mine, which is in a one-to-one interaction, your job as the manager... First of all, too many people think your job as the manager is to be the expert and tell people what to do. No, actually, your job is to enable people to be their very damn best on your team. And you have to create an environment and a context and provide them information, and then you need to provide them a form of coaching. Now, again, I think people start think coaching is lecturing, like let me coach you how to make this Excel model. And sometimes they do. Sometimes someone comes to you and says, "Can you exactly show me how to do this thing?"

**中文翻译:**
是的。对我来说，我刚才谈到的更多是会议或对话场景，但我很高兴你提到了这一点。我认为这实际上是我一个非常基础的管理框架，即在 1 对 1 的互动中，你作为经理的职责……首先，太多人认为经理的职责是当专家并告诉别人该怎么做。不，实际上，你的职责是让团队中的人发挥出他们最好的水平。你必须创造一个环境和语境，为他们提供信息，然后你需要为他们提供某种形式的辅导（coaching）。现在，人们又开始觉得辅导就是讲课，比如“让我教你如何制作这个 Excel 模型”。有时确实如此，有时有人会来找你说：“你能准确地向我展示如何做这件事吗？”

---

### [00:38:05] Claire Hughes Johnson

**English:**
Fine. But most of management is actually exploring with someone. It is being curious. It is saying, "I have seen this pattern of your work. Have you seen this pattern? Is there something..." I have a whole other framework which is about hypothesis based coaching. I think intuition as a word gets kind of a bad rap, and I kind of get why, look, especially if you work with a lot of engineers, which I do. It's not particularly always data driven, but guess what a scientific hypothesis is? It's a well-informed piece of intuition. And I think too many managers wait until they have a million pieces of data to make an observation to someone about an area for improvement. Instead, I would say take some data, form a hypothesis, and then explore it with the person. Because if you're well intended, which I think any good manager is, I'm bringing up this thing because I'm trying to help you see it and tell me if it's true so that we can both help make it more effective, better.

**中文翻译:**
那没问题。但管理的大部分工作实际上是与某人一起“探索”。是保持好奇心。是说：“我看到了你工作中的这种模式，你注意到了吗？是不是有什么……”我有另一个完整的框架，叫“基于假设的辅导”。我认为“直觉”这个词名声不太好，我明白为什么，尤其是如果你像我一样和很多工程师共事。直觉并不总是数据驱动的，但你猜科学假设是什么？它是一种基于充分信息的直觉。我认为太多的经理会等到掌握了一百万条数据后，才向某人提出关于改进领域的观察。相反，我会说：拿一些数据，形成一个假设，然后与那个人一起探索。因为如果你是出于好意（我认为任何好的经理都是如此），我提出这件事是因为我想帮你看到它，并告诉我它是否属实，这样我们就能共同让它变得更有效、更好。

---

### [00:39:11] Claire Hughes Johnson

**English:**
One very light example could be, "I felt like in that meeting... How did you feel that presentation went?" And the person sort of says, "It's fine. I think I got through the material." You say, "Yeah, I felt like you were maybe a little bit nervous. I'm just exploring. Were you..." And by the way, the person could say, "Oh, no, no. No, no, no, no." And then you could back off, or you could say, "Oh, well, maybe it was just me, but I noticed some physical. Your leg was shaking a little bit, your voice, you were kind of repeating yourself." And they're going like, "What?" And you're all you're doing is holding up a mirror... And you have to own it. You have to say, "My experience of you in that meeting was that you seemed nervous to me. Maybe you were not, but actually maybe this is just a physical coaching thing."

**中文翻译:**
一个很简单的例子可能是：“我觉得在那次会议上……你觉得那次演示怎么样？”对方可能会说：“挺好的，我觉得我把内容都讲完了。”你会说：“是的，我觉得你可能有一点点紧张。我只是在探索，你当时……”顺便说一下，对方可能会说：“噢，不，不，一点也不。”然后你可以退一步，或者你可以说：“噢，那可能只是我的感觉，但我注意到一些肢体动作，你的腿有点抖，你的声音，你好像在重复自己。”他们会惊讶：“什么？”而你所做的只是举起一面镜子……而且你必须认领它。你必须说：“在那次会议中，我对你的感受是你看起来很紧张。也许你并不紧张，但实际上这可能只是一个关于肢体表现的辅导点。”

---

### [00:40:04] Claire Hughes Johnson

**English:**
Have you ever had that? I have a few people on my teams who do this weird thing. This is pre virtual world, but when they're sort of getting it uncomfortable in a meeting, they put back their chair up off the table, sort of exit the circle. And that is a very physically big statement. And they had no idea, Lenny. They had no idea. I'm just watching the meeting, and I'm like, oh my gosh, you're like four feet from the rest of the group because you do not like this topic. And what I need to explore with you is how do you vocalize that instead of physically exiting the room or exiting the circle? These are just examples. Sorry, I could keep going. But I really think that that attitude of exploration and mutual sort of collaborative, let's discover some things about you...

**中文翻译:**
你遇到过这种情况吗？我团队里有几个人会做这种奇怪的事。这是在虚拟办公时代之前，当他们在会议中感到不舒服时，他们会把椅子从桌边往后挪，有点像退出那个圈子。这在肢体语言上是一个非常强烈的信号。Lenny，他们自己完全没意识到。我只是在观察会议，心想：天哪，你离大家有四英尺远，因为你不喜欢这个话题。我需要和你探讨的是：你如何用语言表达出来，而不是在身体上退出房间或退出圈子？这些只是例子。抱歉，我可以一直讲下去。但我真的认为，那种探索的态度和相互协作的精神——让我们一起发现关于你的一些事情……

---

### [00:40:54] Claire Hughes Johnson

**English:**
And by the way, it can be mutual. They can go right back at you and say, "Well, I observe this." Great. Great. I've interviewed a lot of people for the book, different leaders and managers from lots of different fields, but one of them was Reid Hoffman, who's a more typical. But Reid, we were talking about the other operating principle, which is management versus leadership. And Reid was pretty honest. He's like, "Look, I'm more of a leader. I'm not a manager." He's like, "I'm not a great manager." And then he told me the story. He's like, he had in his first company that he was building, he had a guy that he'd hired who was more operational. And Reid was sort of making an observation to him about something they should do, and the guy goes to him, "Reid, I wouldn't hire you to manage McDonald's."

**中文翻译:**
顺便说一下，这可以是相互的。他们也可以反过来对你说：“嗯，我观察到了这一点。”太棒了。为了写这本书，我采访了很多人，来自不同领域的不同领导者和管理者，其中一位是 Reid Hoffman。Reid 很典型。我们当时在聊另一个运营原则，即管理与领导力的区别。Reid 非常坦诚，他说：“看，我更像是一个领导者，我不是一个管理者。”他说：“我不是一个优秀的管理者。”然后他给我讲了个故事：在他创办的第一家公司里，他雇了一个更偏向运营的人。Reid 当时向他提出一个关于该做什么的观察，那个人对他说：“Reid，我连麦当劳都不会雇你去管理。”

---

### [00:41:42] Claire Hughes Johnson

**English:**
And Reid was like, "Okay, good. So tell me what we need to do so we can fix this thing." But what actually Reid's operating principle, interestingly when unearthed that whole thing, was that he prides... It's very important to him to create an environment of open feedback. He said, what I love about that story, yeah, it's funny and embarrassing, but actually that guy was comfortable saying to me, "I wouldn't trust you to manage a McDonald." And I think that actually I found inspiring because I don't think everybody who founded a company or who's managing someone has created an environment with how much trust in it, right? And that's how Reid thinks he gets a lot of stuff done, is people just come right back at him with the feedback.

**中文翻译:**
Reid 的反应是：“好吧，很好。那告诉我我们需要做什么来解决这件事。”但 Reid 的运营原则中，有趣的是深挖这件事后发现，他引以为傲的是……对他来说，创造一个开放反馈的环境非常重要。他说，我喜欢这个故事的地方在于，虽然它又好笑又尴尬，但实际上那个人能很自然地对我说“我不信任你去管理麦当劳”。我觉得这很受启发，因为我不认为每个创办公司或管理别人的人都创造了如此高信任度的环境，对吧？这就是 Reid 认为他能完成很多事情的原因：人们会直接把反馈抛回给他。

---

### [00:42:26] Lenny (Sponsor - Dovetail)

**English:**
This episode is brought to you by Dovetail, the customer insights platform for teams that gets you from data to insights fast, no matter the method. There's so much customer data to get through from user interviews to NPS, sales calls, usability tests, support tickets, app reviews. It's a lot. And you know that if you're building something, hidden in that data are the insights that will lead you to building better products. And that's where Dovetail can help. Dovetail allows you to quickly analyze customer and data from any source and transform it into evidence-based insights that your whole team can access. If you're a product manager who needs insights to motivate your team, a designer validating your next pick feature, or a researcher who needs to analyze fast, Dovetail is the collaborative insights platform your whole team can use. Go to dovetailapp.com/lenny to get started today for free. That's dovetailapp.com/lenny.

**中文翻译:**
本期节目由 Dovetail 赞助。Dovetail 是一个为团队打造的客户洞察平台，无论采用何种方法，都能帮你快速从数据中获取洞察。从用户访谈到 NPS、销售电话、可用性测试、支持工单、应用评论，有海量的客户数据需要处理。你知道，如果你在构建产品，这些数据中隐藏着能引导你打造更好产品的洞察。这就是 Dovetail 的用武之地。Dovetail 允许你快速分析来自任何渠道的客户数据，并将其转化为整个团队都能访问的、基于证据的洞察。如果你是需要洞察来激励团队的产品经理，是需要验证下一个功能的设​​计师，或者是需要快速分析的研究员，Dovetail 都是你整个团队可以使用的协作洞察平台。访问 dovetailapp.com/lenny 免费开始使用。

---

### [00:43:19] Lenny

**English:**
So we've done three of the operating principles that you personally use, which I love. I love that you're going to going through [inaudible 00:43:25]

**中文翻译:**
我们已经聊了你个人使用的三个运营原则，我很喜欢。我喜欢你正在梳理这些（听不清）。

---

### [00:43:24] Claire Hughes Johnson

**English:**
Distinguish management and leadership is the third one, yep.

**中文翻译:**
区分管理和领导力是第三个，没错。

---

### [00:43:28] Lenny

**English:**
And then just to summarize real quick, the second one was to say the thing that you cannot say. The first one was-

**中文翻译:**
快速总结一下，第二个是“说出你认为不能说的话”。第一个是——

---

### [00:43:34] Claire Hughes Johnson

**English:**
Say the thing you think you cannot say, yeah.

**中文翻译:**
说出你认为不能说的话，是的。

---

### [00:43:36] Lenny

**English:**
And then first, build self-awareness to build mutual awareness.

**中文翻译:**
第一个是，建立自我意识以建立相互意识。

---

### [00:43:39] Claire Hughes Johnson

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:43:41] Lenny

**English:**
And what's cool is you're sharing all these amazing stories and tactics. In the book, you actually have templates to do each of these things for yourself. So a lot of this is pointers too. If you actually want to do this, go check out the book and you can actually do this. It's not just in a bunch of high level stuff. And then the fourth is-

**中文翻译:**
酷的是你分享了所有这些精彩的故事和战术。在书里，你实际上提供了模板，让读者可以为自己实践这些原则。所以这不仅是建议，如果你真的想做，去看看书，你真的可以付诸行动。这不只是一堆高大上的理论。那么第四个是——

---

### [00:43:57] Claire Hughes Johnson

**English:**
Come back to the operating system.

**中文翻译:**
回归操作系统。

---

### [00:44:01] Lenny

**English:**
Let's talk about it.

**中文翻译:**
聊聊这个吧。

---

### [00:44:02] Claire Hughes Johnson

**English:**
So this one is, sort of like I was talking about, touchstone documents that you might create for your company. This is our operating principles, our values. This is my touchstone, which is I think that especially high growth environments, but every environment you operate in can get really chaotic, and there's a lot of ambiguity. There's a lot of stuff you don't know, and it's kind of easy to get paralyzed or to sort of give into the chaos. And you're like, oh my gosh, I don't know what this day is going to bring. I'm just going to randomly assign some stuff, and I'm just going to get through it. And all you're doing in a lot of those moments is creating more chaos. And I think a really important role of definitely managers, but some leaders too is to create a stability when there doesn't feel like there's a lot that's stable.

**中文翻译:**
这一个原则，有点像我之前提到的你为公司创建的“试金石文档”（touchstone documents）。这是我们的运营原则，我们的价值观。这是我的试金石：我认为特别是在高增长环境下，其实在你运作的任何环境下，事情都可能变得非常混乱，充满模糊性。有很多你不知道的事情，很容易让人陷入瘫痪或者向混乱屈服。你会觉得：天哪，我不知道今天会发生什么，我就随便分派点活儿，混过去算了。在很多这种时刻，你所做的只是制造更多的混乱。我认为经理（当然也包括一些领导者）的一个非常重要的角色是：在感觉没有什么东西是稳定的时候，创造一种稳定性。

---

### [00:44:52] Claire Hughes Johnson

**English:**
And where stability comes from is in ritual and in common practices that you share. So we set quarterly goals or monthly goals. And that's a ritual, and that's a thing we do, and it's actually a source of stability. And yeah, it feels like a process. It might feel like a way of managing, but it also has a cadence to it. And I think one of the things that happened is you picture yourself sort of spinning out of control. You think, how do I come back to this is the order I do things, this is how I get decisions made, this is how we make plans, this is how we make decisions. Those touchstones are not processes to run the thing. If they're done well, they're stabilizing because they're a common way of approaching that everybody has, so they can at least hold onto that even when all the other stuff is going haywire.

**中文翻译:**
稳定感来自于仪式感和你们共享的通用惯例。比如我们设定季度目标或月度目标。这是一种仪式，是我们做的一件事，它实际上是稳定感的来源。是的，它看起来像一个流程，可能感觉像一种管理方式，但它也有自己的节奏（cadence）。我认为当你觉得自己快要失控时，你会想：我该如何回到“这是我做事的顺序”、“这是我做决策的方式”、“这是我们制定计划的方式”？这些试金石不是用来运行某件事的流程。如果做得好，它们具有稳定作用，因为它们是每个人都拥有的通用处理方式，所以即使其他所有事情都乱套了，他们至少还能抓住这些东西。

---

### [00:45:45] Claire Hughes Johnson

**English:**
You've got a customer churning, and you've got a big launch happening the next day, like, oh my God, oh my God. Come back. What's our launch? How do we launch products? We have a way of doing that. We do not need to spin out of control and reinvent the wheel here, right? And that's a stabilizing thing. And the other thing on come back to the operating system for me was, as my career scaled, as I went from a individual contributor, to managing a small team, to managing a bigger team, to managing multiple teams, to managing managers, you get it, I realized actually, and I started to have multiple functions. So I was context switching between... At Google, there was a point where I had some product people, industrial design operations, really BD, really different functions. Actually, how I fundamentally ran them at the bare bones, at the house architecture level was the same.

**中文翻译:**
比如你有一个大客户流失了，而第二天又有一个重大发布，你会想：天哪，天哪。冷静，回到系统。我们的发布流程是什么？我们如何发布产品？我们有一套方法。我们不需要失控，也不需要在这里重新发明轮子，对吧？这就是一种稳定机制。对我来说，“回归操作系统”的另一层含义是，随着我职业生涯的扩展——从个人贡献者到管理小团队，再到大团队、多个团队、管理经理们——我意识到，当我开始负责多个职能时，我需要在不同背景间切换。在 Google 的某个阶段，我手下有产品人员、工业设计运营、商务拓展（BD），职能完全不同。但实际上，我在最基础的层面、在“房屋架构”层面运行它们的方式是一样的。

---

### [00:46:38] Claire Hughes Johnson

**English:**
And that gave me a stability as a leader where I would dive into a meeting. I'd be like, all right, let's look at the metrics that matter. We all had... We had them for every team. Let's look at the goals we set. And that also helps you stabilize when your contact switching between seven different projects or seven different teams. And so I wouldn't say it's the operating principle that I talk about the most, but I think if you were like, "What's your sort of... How do you scale yourself?" I would say, "Well, I actually have a common operating system like a computer, and that is how I maintain a sense of stability."

**中文翻译:**
这给了我作为领导者的稳定性，让我进入会议时能迅速进入状态。我会说：好吧，让我们看看核心指标。我们每个团队都有这些指标。让我们看看我们设定的目标。当你需要在七个不同的项目或七个不同的团队之间切换时，这也能帮你保持稳定。所以我不会说这是我谈论最多的运营原则，但如果你问：“你如何规模化你自己？”我会说：“嗯，我实际上有一套像计算机一样的通用操作系统，这就是我保持稳定感的方式。”

---

### [00:47:17] Lenny

**English:**
Perfect segue to the next kind of broad area I want to spend time on, which is this house metaphor and the three components of it that you talked about. And this is like the core of the book. Can you talk about again, the three kind of pillars of this house structure? And then let's just go through each of these things.

**中文翻译:**
这完美地过渡到了我想聊的下一个大领域，也就是你提到的那个“房子”类比及其三个组成部分。这是书的核心内容。你能再谈谈这个房子结构的三个支柱吗？然后我们逐一梳理。

---

### [00:47:33] Claire Hughes Johnson

**English:**
Yeah, it's definitely, the beginning of the book is about company building, and the company structure chapter is all about the sort of supporting beams, the mechanicals, and then the foundational stuff. And interestingly, it's sort of, well, I guess when you build a house, you build the foundation first. So one is the founding documents that you might create, which I'm happy to talk about. And then another are the supporting structures, which are some of the ways you do things we talked, like quarterly business reviews or OKRs, or how you use planning to create a structure that everyone... And then the mechanicals are what I might call the operating cadence, which is essentially the rhythm of how you work, right? The calendar, the year that we all experience tends to dictate a little bit how we work. Mondays feel different than Sundays, right? Well, companies have that same kind of a cadence, which is often also calendar driven, but also can be event driven.

**中文翻译:**
是的，书的开头是关于公司建设的，而“公司结构”那一章全是关于支撑梁、机电设备和地基的。有趣的是，当你盖房子时，你先打地基。所以第一部分是你可能创建的“创始文档”（founding documents），我很乐意聊聊这个。第二部分是“支撑结构”，也就是我们谈到的一些做事方式，比如季度业务回顾（QBR）或 OKR，或者你如何通过计划来创建一个结构，让每个人……第三部分是“机电设备”，我称之为“运营节奏”（operating cadence），本质上是你工作的节奏。我们经历的日历和年份往往决定了我们的工作方式。周一的感觉和周日不同，对吧？公司也有同样的节奏，通常也是由日历驱动的，但也可能是由事件驱动的。

---

### [00:48:28] Claire Hughes Johnson

**English:**
We've talked often at Stripe about how our customer event, which we have called Stripe Sessions, is as important internally as it is for the customers because it's a forcing function for our cadence, how we plan our products, what we want to have achieved by that point, what we want to demonstrate. And that's true for a lot of companies, but we actually use it in our thinking about our cadence of the year. And actually, we've built this other event that I usually help run, which is an internal event that happens generally about six months before that, which is great because you can demo the stuff you think you want to demo internally. You sort of create a cadence of we're going to push ourselves to do some crazy wild stuff, internally demonstrate it, and then see if we can externalize it by the time we hit the customer event.

**中文翻译:**
在 Stripe，我们经常谈论我们的客户大会（Stripe Sessions）对内部和对客户同样重要，因为它是一个驱动我们节奏的“强制函数”：我们如何规划产品，到那时我们想实现什么，我们想展示什么。很多公司都是这样，但我们实际上把它融入到了对年度节奏的思考中。实际上，我们还创建了另一个我通常协助运行的活动，那是一个内部活动，通常在客户大会前六个月举行。这很棒，因为你可以在内部演示你想演示的东西。你创造了一种节奏：我们要逼自己做一些疯狂大胆的事情，在内部演示，然后看看在客户大会到来时能否将其推向外部。

---

### [00:49:16] Claire Hughes Johnson

**English:**
But that is a cadence. Quarterly business reviews are part of your cadence, et cetera. So that's the fundamental, but really while I'm trying to do is say, one, I don't think this stuff is super hard. You know this. It's kind of hard work. It's just putting it in place, and then actually using it. I think where a lot of leadership teams go wrong, especially of young companies, is they experiment with different vehicles to try this stuff. And then they either don't actually follow them or they throw them out the window after they haven't tried it for very long, and it creates a lot of chaos. So I would say do very few things consistently and try to do them well, and then see if they're working for you, and then once a year, maybe think about a revision. But don't keep throwing out new things you heard that other companies do. And it turns into a weird grab bag of operating stuff. You're nodding because you've seen this too lot.

**中文翻译:**
这就是节奏。季度业务回顾也是节奏的一部分，等等。这是基础，但我真正想表达的是：第一，我不觉得这些东西超级难。你也知道，这只是辛苦活儿。关键是把它建立起来，然后真正去使用它。我认为很多领导团队（尤其是年轻公司的）出错的地方在于，他们尝试用不同的工具来做这些事，然后要么不真正遵守，要么尝试没多久就扔出窗外，这制造了大量的混乱。所以我会说：坚持做极少数的事情，并努力做好，看看它们是否对你有用，然后每年考虑修订一次。但不要一直抛出你听到的其他公司在做的新花样。否则它会变成一个奇怪的运营大杂烩。你在点头，因为你也见过太多这种情况了。

---

### [00:50:16] Lenny

**English:**
Yeah, I think a problem I've seen is people think there's going to be this perfect system and process that's going to not have any flaws, and they're always like, "Oh, it's not perfect. We got to optimize it further." And what I find is it's always just like, this is the best one you can come up with at the time. This is the best idea you have now. There's going to be flaws. Just work around those flaws. But just know there's never going to be the one thing that works.

**中文翻译:**
是的，我看到的一个问题是，人们认为会有一个完美的系统和流程，没有任何缺陷，他们总是说：“噢，它不完美，我们要进一步优化。”而我发现，情况总是：这是你当时能想到的最好的方案，是你现在最好的主意。它肯定会有缺陷，绕过这些缺陷就行了。但要明白，永远不会有一个万能的完美方案。

---

### [00:50:35] Claire Hughes Johnson

**English:**
There is no one. There's no perfect org structure, there's no perfect operating approach, there's no perfect, yeah, performance and management and level system. But having one and committing to it is good. And don't let the perfect be the enemy of the good.

**中文翻译:**
没有唯一的方案。没有完美的组织结构，没有完美的运营方法，也没有完美的绩效管理和职级体系。但拥有一个并致力于执行它是好事。不要让“完美”成为“优秀”的敌人。

---

### [00:50:50] Lenny

**English:**
There's another, you mentioned that I thought it'd be fun to talk about, that it's often chaotic at a company. I imagine people think about Stripe from the outset, like, oh, they've got it all figured out, so smooth, just runs like a machine. And I think people look at other successful companies and they're like, man, things are so crazy at our company. This isn't normal. But I think, you tell me if I'm wrong, most places are crazy and chaotic internally for a long time and often, right?

**中文翻译:**
你提到的另一件事我觉得很有趣，就是公司内部通常很混乱。我猜人们从外部看 Stripe，会觉得：噢，他们把一切都搞定了，非常顺滑，像机器一样运转。人们看其他成功的公司时也会想：天哪，我们公司太疯狂了，这不正常。但我觉得（如果我说错了请纠正我），大多数地方内部在很长一段时间内、在很多时候都是疯狂且混乱的，对吧？

---

### [00:51:15] Claire Hughes Johnson

**English:**
Yeah. There are different kinds of chaos, but it's so true. What is that? There's like a saying. Don't ever believe your best press or your worst press. It's never as bad as whatever someone's saying it is never as good. It's just normal is not pretty. It's a lot. And that is true. It's happening everywhere. I used to have a friend who was building a company. We would see each other. We both were from the Boston area, and it's a long story, but we'd end up on the same flight off in Rhode Island, coming back to Boston occasionally for stuff, for family. And we'd be in getting yelled at by the passengers because we'd be in the aisle of the airplane comparing notes about stuff that was broken.

**中文翻译:**
是的。混乱有很多种，但确实如此。有句俗话怎么说来着？永远不要相信关于你最好或最坏的报道。情况永远没有别人说的那么糟，也永远没有别人说的那么好。常态往往并不漂亮，事情非常多。这是事实，到处都在发生。我以前有个朋友在创业，我们经常见面。我们都来自波士顿地区，说来话长，我们偶尔会坐同一班飞机从罗德岛回波士顿处理家事。我们常在飞机过道里交流哪些东西搞砸了，结果被其他乘客吼，因为我们挡路了。

---

### [00:52:02] Claire Hughes Johnson

**English:**
And we had this expression, it was like, oh, and then I picked up the rock, and under that rock were some really ugly, creepy crawlies. But that's just like the way it is, is it's never perfect. But I guess I would go back to what I just said about having some stabilizing ways of doing things because that can create, I don't know, I'm not trying for a perception that the thing runs a machine, but more of a, that is a well run thing, right? And how do you create that perception? Because you adhere to some ways of running things and that are consistent, and it feels better even to the outside, even if there's a lot of chaotic stuff going on.

**中文翻译:**
我们有个说法：噢，我掀开了一块石头，石头下面全是些丑陋、令人毛骨悚然的小虫子。但事实就是这样，永远不完美。但我还是想回到我刚才说的，要有一些稳定的做事方式，因为那可以创造出——我不是在追求“像机器一样运转”的观感，而是一种“这是一件运作良好的事情”的感觉，对吧？你如何创造这种观感？因为你坚持了一些一致的运行方式，即使内部有很多混乱的事情，外部感觉也会好一些。

---

### [00:52:45] Lenny

**English:**
Coming back to the founding documents, could you just talk about what are in this group of founding documents? And I think even more interestingly, what's a sign that you should invest more time in this area as a startup?

**中文翻译:**
回到创始文档，你能谈谈这组创始文档里都有什么吗？而且我觉得更有趣的是，对于初创公司来说，什么信号表明你应该在这个领域投入更多时间？

---

### [00:52:55] Claire Hughes Johnson

**English:**
Yeah. Very classic stuff is in here, nothing that you haven't seen or examples of. So one is I think it's good to have a mission. When I joined Stripe, we did not. It came to be apparent that to increase the GDP of the internet was probably the mission, because people kept repeating that back to us, and Patrick had written it on some website copy early on. But it was interesting that candidates and customers kind of grabbed it. It was very Stripe because it's a little bit intellectual and pointy headed and aspirational, but also it is... The GDP does involve economic progress, which we're all about, right? We're building infrastructure for commerce and payments for not just the internet actually. But anyway, point is have a mission, or at least the beginning of what's your one line of what you're seeking to accomplish.

**中文翻译:**
是的。这里面都是非常经典的东西，没有什么你没见过或没听过的例子。第一，我认为拥有一个“使命”很好。我加入 Stripe 时，我们还没有正式的使命。后来变得很明显，“增加互联网的 GDP”可能就是我们的使命，因为人们不断向我们重复这句话，而 Patrick 早期在一些网站文案里写过。有趣的是，应聘者和客户都抓住了这一点。这非常符合 Stripe 的风格，因为它带点知识分子气息，有点尖锐且充满抱负，但同时……GDP 确实涉及经济进步，而这正是我们的核心，对吧？我们正在为商业和支付构建基础设施，实际上不仅限于互联网。但无论如何，重点是要有一个使命，或者至少是关于你想要实现的目标的一句话雏形。

---

### [00:53:47] Claire Hughes Johnson

**English:**
And then I'm a big fan of writing sort of what we Stripe called our long-term goals, which were just not our short distance, but our longer distance, like why did we exist? And so the mission is one line, so you need a little more meat behind that, right? And actually, I think if you looked at our long-term goals, which by the way I thought would be a three to five year goal, I would say they're still relevant today. But one of Stripe's long term goals is to advance the state of the art and developer tools, which would not be something that everybody, especially every customer of would initially call out. But when you think about it... Lenny, you just did it. You think about it for a minute, you're like, yeah, the API and the docs and a lot of stuff that we've open sourced, Stripe cares.

**中文翻译:**
然后，我非常推崇写下 Stripe 所说的“长期目标”，这些不是短期目标，而是更长远的目标，比如：我们为什么存在？使命只有一句话，所以你需要更多的实质内容来支撑它，对吧？实际上，如果你看我们的长期目标（顺便说一下，我原以为那是三到五年的目标），我会说它们在今天依然适用。Stripe 的长期目标之一是“推进开发者工具的尖端水平”，这可能不是每个人（尤其是每个客户）最初会想到的。但当你思考一下……Lenny，你刚才就在思考。你思考片刻就会觉得：是的，API、文档以及我们开源的很多东西，Stripe 确实很在乎。

---

### [00:54:38] Claire Hughes Johnson

**English:**
Our forever user is fundamentally a developer. It's the person who's integrating Stripe, right? By the way, simple integration, complex integration, anywhere in between, we really care about their experience, and we care that the tools are excellent, because how are you going to increase the GDP of the internet if you don't advance the state of the art of developer tools? Right? Anyway, point is articulating that, because until I said that to you and I could talk about it with you and say you came to work at Stripe, you might not understand why we invested in certain things or why it meant so much to us in terms of our user experience and the mission. So articulate those things. And some of them might be a little bit aspirational, but they should feel at least real enough that you can have that conversation about... You look at anyone who works in a company, what they choose to do all day with their time should be guided by things like, what are we trying to accomplish?

**中文翻译:**
我们永远的用户从根本上说是开发者。是那个集成 Stripe 的人，对吧？顺便说一下，无论是简单的集成还是复杂的集成，我们都非常关心他们的体验，我们关心工具是否卓越。因为如果你不推进开发者工具的尖端水平，你又如何增加互联网的 GDP 呢？对吧？总之，重点是阐明这一点。因为在我告诉你之前，或者在你来 Stripe 工作之前，你可能不理解为什么我们要投资某些东西，或者为什么用户体验和使命对我们如此重要。所以要阐明这些事情。其中一些可能带点抱负色彩，但它们至少应该感觉足够真实，让你能进行那样的对话……你看任何在公司工作的人，他们一整天如何分配时间，都应该受到“我们要实现什么目标”这类事情的引导。

---

### [00:55:35] Claire Hughes Johnson

**English:**
What are our long-term goals? So if they don't know them, how are they going to make the right choices? So that's one. And then another is a lot of companies write company values, or at Stripe, we wrote operating principles. I think you had [inaudible 00:55:50] on, and she talked about these, and we even sort of took a version of ours and put them out for candidates so that they could evaluate, do I want to join this company, because I kind of want to know what it's like to work there? And I think that's really valuable to do because not every company is right for every candidate, and the more you can mutually match the better. But having some operating principles matters. I think you can go farther than that, but that's where I would sort of start, is those three things.

**中文翻译:**
我们的长期目标是什么？如果他们不知道，他们怎么能做出正确的选择？这是第一点。第二点是，很多公司会写公司价值观，而在 Stripe，我们写的是“运营原则”。我想你之前采访过（听不清），她谈到了这些。我们甚至拿出了一个版本给应聘者看，这样他们就可以评估：我想加入这家公司吗？我想知道在那里工作是什么样的。我认为这样做非常有价值，因为不是每家公司都适合每个应聘者，双方越匹配越好。拥有一些运营原则很重要。我认为你可以做得更深入，但那三件事是我开始的地方。

---

### [00:56:17] Lenny

**English:**
Awesome, I like the simplicity of this.

**中文翻译:**
太棒了，我喜欢这种简洁性。

---

### [00:56:21] Claire Hughes Johnson

**English:**
How you know is people are asking you. Especially new hires are asking you a lot of questions about what's important, or "Why do we do it this way?" You said it yourself at the beginning. Doesn't writing something down, crystallize it? Time to write it down and crystallize it for everybody who works there.

**中文翻译:**
你如何知道该写了？就是当人们开始问你问题时。尤其是新员工会问你很多关于什么重要，或者“我们为什么要这样做”的问题。你一开始就说了，写下来不就能固化思考吗？是时候写下来，为在那里的每位员工固化这些认知了。

---

### [00:56:40] Lenny

**English:**
And just to summarize you as a mission, your operating principle/values. What was the third one?

**中文翻译:**
总结一下：使命、运营原则/价值观。第三个是什么来着？

---

### [00:56:45] Claire Hughes Johnson

**English:**
Yep. Long-term goals.

**中文翻译:**
是的，长期目标。

---

### [00:56:47] Lenny

**English:**
Long-term goals.

**中文翻译:**
长期目标。

---

### [00:56:48] Claire Hughes Johnson

**English:**
And sort of more details on why you exist. What are you really trying to accomplish?

**中文翻译:**
以及关于你们为什么存在的更多细节。你们到底想实现什么？

---

### [00:56:52] Lenny

**English:**
Interesting. And then are those numbers in your experience, or is that a story of what [inaudible 00:56:57]?

**中文翻译:**
很有趣。根据你的经验，那些是具体的数字，还是关于（听不清）的故事？

---

### [00:57:00] Claire Hughes Johnson

**English:**
Those are a little bit more, I think headlines. And I think your shorter term goals have numbers against them, right? So if you looked at your long-term goal, which might be... Another one of Stripe's is about accelerating globalization, and if you thought about what would that require, that would require us to be in a lot of markets. That would require us to have users and customers in a lot of market, and also to eliminate friction across borders. So those things, which is a very high friction thing, unfortunately in payments, and moving money, which it shouldn't be if you want to advance globalization, accelerate it, right? And so that can then become numerical goals and short term goals.

**中文翻译:**
我认为那些更像是“大标题”。而你的短期目标则会有具体的数字，对吧？如果你看你的长期目标，比如……Stripe 的另一个目标是“加速全球化”。如果你思考这需要什么，那就需要我们进入很多市场，需要我们在很多市场拥有用户和客户，还需要消除跨境摩擦。这些事情（不幸的是，在支付和资金流动中摩擦非常大，如果你想推进并加速全球化，就不应该这样，对吧？）就可以转化为数字化的目标和短期目标。

---

### [00:57:41] Lenny

**English:**
Basically objectives, and then-

**中文翻译:**
基本上就是目标（Objectives），然后——

---

### [00:57:43] Claire Hughes Johnson

**English:**
Yeah, it's sort of the longer term objective, and then the key results part is early is shorter term. But actually, if you're having trouble writing your company goals, actually zooming way out and being like, "If we're going to meet this mission, what do we have to accomplish in the long term?" You can then walk back from that and be like, "Oh yeah, every goal we ever have probably fits in these three to five buckets." Bam. And then you write your short term goals actually more easily because there's always going to be one about, say, international expansion. There's always going to be one about additional products because we're trying to do X, and you can't do it with one product, or whatever. You can imagine the example.

**中文翻译:**
是的，这有点像长期目标，而“关键结果”（Key Results）部分则是早期的、短期的。但实际上，如果你在写公司目标时遇到困难，可以试着把视野拉远，想一想：“如果要实现这个使命，我们长期需要完成什么？”然后你可以倒推回来：“噢，没错，我们所有的目标可能都属于这三到五个范畴。”砰！然后你写短期目标就容易多了，因为总会有一个关于（比如）国际扩张的目标，总会有一个关于增加产品的目标，因为你想实现 X，而靠一个产品做不到，等等。你可以想象这些例子。

---

### [00:58:22] Lenny

**English:**
Awesome. I know your book has a actual examples of a lot of this stuff.

**中文翻译:**
太棒了。我知道你的书里有很多这些东西的实际案例。

---

### [00:58:25] Claire Hughes Johnson

**English:**
It does. It does.

**中文翻译:**
是的，确实有。

---

### [00:58:26] Lenny

**English:**
So again, pointer to that. Okay, so that's the founding documents. The next piece is operating system. Maybe we go there, just what fits into an operating system for a company? What are the components of that?

**中文翻译:**
再次向大家推荐。好，那是创始文档。下一部分是“操作系统”。也许我们可以聊聊那个，公司的操作系统里都包含什么？它的组成部分有哪些？

---

### [00:58:38] Claire Hughes Johnson

**English:**
I think a lot of the components we've sort of touched on, which is do you have some sort of goals? This is now goes back what we were just talking about. For Stripe, we have an annual set of numeric targets that we put together, we have a system of goals or OKRs, objectives and key results, but sort of like what is your structure for setting milestones that you want to achieve, whether they're numeric or more like a binary, we got this thing launched, we didn't? And then QBR, so quarterly business reviews. How do we review parts of the business? What is the cadence? Well, first, what is the form by which we do that? Which would be this... I share examples in the book of this might be the template you fill out if you're a team and your reporting on how it's going and versus your strategy and your goal.

**中文翻译:**
我想很多组成部分我们已经触及到了，比如：你是否有某种目标？这又回到了我们刚才谈论的话题。在 Stripe，我们有一套年度数字指标，有一套目标系统或 OKR（目标与关键结果），也就是你设定想要实现的里程碑的结构，无论它们是数字化的，还是二元对立的（比如“这个东西发布了”或“没发布”）。然后是 QBR，即季度业务回顾。我们如何回顾业务的各个部分？节奏是怎样的？首先，我们以什么形式进行？这会是……我在书里分享了一些例子，比如如果你是一个团队，正在汇报进展、战略和目标，你可能需要填写的模板。

---

### [00:59:24] Claire Hughes Johnson

**English:**
And then there's also getting into metrics and dashboards. What are things that you look at internally to measure progress, the input metrics and the output metrics? And I give some examples of that. And then mostly, I think there are other... As I said, there could be less frequent forms you use, like a user event or a launch, a way of launching products, et cetera, but it's really simple. It's mostly goals and how do you review the business. Planning. I talk a lot about planning, which is. You said this earlier, and you and I think both agree, which is there no perfect process to plan for the next year or the next two years, but you still need to fight your way through having something, especially after a certain stage. And every COO I meet with, we sort of ring our hands together.

**中文翻译:**
接着是指标和仪表盘。你在内部看什么来衡量进展？投入指标（input metrics）和产出指标（output metrics）是什么？我举了一些例子。然后，我认为还有其他……正如我所说，可能会有一些频率较低的形式，比如用户大会或发布会、产品发布流程等等，但其实很简单，主要是目标和业务回顾。还有计划。我花了很多篇幅讲计划。你之前说过，我想我们都同意：没有完美的流程来规划下一年或下两年，但你仍然需要努力建立一套机制，尤其是在达到一定阶段后。我见过的每一位 COO，我们都会一起为此发愁。

---

### [01:00:11] Claire Hughes Johnson

**English:**
We're like, oh, planning and everyone hates us, too burdensome, but you still got to keep trying. You got to do it. And so we talk about planning processes and what they might look like and how you set them up. And then that's how you'd use goals and QBR to measure against the plan, right? So those are some of the operating systems. And then the cadence is just how often do you do these things? Actually, one of our big lessons, I think companies that are moving quickly and that are younger tend to resist some of the calendar based cadences of more mature companies because they seem slow. You're like, really? You're going to just achieve that goal in three months? Or are you artificially restricting yourself to some lowest common denominator of time? And so I get that fear, and I would say your cadence doesn't have to be one quarter or one six month, or even 12 months.

**中文翻译:**
我们会说：噢，计划，大家都讨厌我们，觉得负担太重，但你还是得继续尝试，你必须做。所以我们讨论了计划流程，它们可能是什么样的，以及如何建立它们。然后你就可以利用目标和 QBR 来衡量计划的执行情况，对吧？这就是操作系统的一些内容。而“节奏”就是你做这些事情的频率。实际上，我们的一个重要教训是：我认为那些发展迅速、较年轻的公司往往会抵制成熟公司那种基于日历的节奏，因为那看起来很慢。你会觉得：真的吗？你打算花三个月才实现那个目标？或者你是在人为地把自己限制在某种时间的“最小公分母”里？我理解那种恐惧，我想说，你的节奏不一定要是一个季度、六个月甚至 12 个月。

---

### [01:01:08] Claire Hughes Johnson

**English:**
Stripe, we did sort of six month processes for a while. So instead of a year, we did it in six months. Still, there were things that took, by the way, a year or longer, but I think that play around with the timeframe and don't feel restricted by what other companies do. But one of our lessons on the QBR was sometimes those quarterly, because that stands for quarterly, those quarterly business reviews were too infrequent, especially for new product areas. They we're still in development. They were still getting a lot of feedback, launching a lot. And so we just said, okay, they're not quarterly anymore. They're like every six week business reviews. Fine, change your cadence. The point is to have one, because then it's predictable for teams. They know what they're marching toward, they know when they're going to be reporting out, and they can set their goals in a way that makes sense to make progress in that timeframe.

**中文翻译:**
在 Stripe，我们有一段时间实行的是六个月的流程。所以我们不是以年为单位，而是以六个月为单位。顺便说一下，仍然有些事情需要一年或更长时间，但我认为可以灵活调整时间框架，不要觉得被其他公司的做法限制住了。我们在 QBR 上学到的一个教训是：有时那些“季度”业务回顾（既然叫季度）频率太低了，尤其是对于新产品领域。它们还在开发中，还在接收大量反馈，频繁发布。所以我们就说：好吧，它们不再是季度的了，而是每六周一次的业务回顾。没问题，改变你的节奏。重点是要有一个节奏，因为这样对团队来说是可预测的。他们知道自己在朝什么方向努力，知道什么时候要汇报，并且可以以一种合理的方式设定目标，以便在那个时间框架内取得进展。

---

### [01:02:02] Lenny

**English:**
One quick question there. What's a sign that your cadence is off? What's a flag that we should go shorter or longer?

**中文翻译:**
这里有一个简短的问题。什么信号表明你的节奏不对？什么标志提醒我们应该缩短或延长周期？

---

### [01:02:10] Claire Hughes Johnson

**English:**
Well, everyone usually complains about these things, but I think if the... One, nothing, like you said, it's probably too fast if not enough progress is being made in between whatever your review or your reporting function is, and it's probably too slow if the content you're reviewing seems stale. And you're like, "Well, we knew this," or "We already did that thing," or "Yeah, we already had the meeting where we talked about that." That's another thing that's interesting, is some companies will have a pretty frequent metrics review cadence, and then an infrequent strategy review cadence. And what happens is the metrics review becomes the strategy review because you're not talking about the strategy often enough. And so you're talking about it through the data, and so then by the time you get to the strategy review, you're like, we already had this meeting. And that's just a sign that some things are just off. And to me, it's about timeliness and freshness of the content, but also that there's actually new content. If there's not new content, you're creating work for people. By the way, give them time to work.

**中文翻译:**
嗯，大家通常都会抱怨这些事。但我认为：第一，正如你所说，如果在两次回顾或汇报之间没有取得足够的进展，那可能太快了；如果回顾的内容看起来陈旧，那可能太慢了。你会觉得：“嗯，我们早就知道了”，或者“我们已经做完那件事了”，或者“是的，我们已经开会讨论过那个了”。另一件有趣的事是，有些公司会有非常频繁的指标回顾节奏，但战略回顾节奏却很稀疏。结果就是指标回顾变成了战略回顾，因为你们讨论战略的次数不够多。于是你们通过数据来讨论战略，等到了真正的战略回顾会时，你们会觉得：我们已经开过这个会了。这只是某些环节脱节的信号。对我来说，关键在于内容的及时性和新鲜度，以及是否真的有新内容。如果没有新内容，你就是在给人们制造无用功。顺便说一下，要给他们留出工作的时间。

---

### [01:03:12] Claire Hughes Johnson

**English:**
And so I think don't fool yourself that thinking, having more frequent checks on things is going to actually make things run faster. I would say that the opposite can be true. And so be very wary of actually slowing velocity down by creating overhead. One thing we try to do at Stripe is if we're looking at metrics, let's just look at your dashboard live. Let's not create a special presentation. I actually just share your screen please on your dashboard, right? Which is a good discipline, because one, that means you have to have a really good dashboard that's real time, that's web accessible. No one had to pull or massage the data. That's a good sign. But it's also, you're not wasting people's time prepping all that information, which happened even... By the way, at Stripe, even when we put that in place, we still ended up with versions of that problem.

**中文翻译:**
所以我觉得不要自欺欺人地认为增加检查频率就能让事情跑得更快。我会说情况可能恰恰相反。所以要非常警惕因为制造管理开销（overhead）而导致速度变慢。在 Stripe 我们尝试做的一件事是：如果要看指标，我们就直接看你的实时仪表盘。不要专门做 PPT。请直接分享你的仪表盘屏幕，对吧？这是一种很好的约束，因为第一，这意味着你必须有一个非常好的、实时的、可以通过网页访问的仪表盘，没人需要去手动拉取或加工数据，这是一个好迹象。第二，你不会浪费大家的时间去准备那些信息。顺便说一下，在 Stripe，即使我们实施了这一套，最终还是会遇到各种变相的类似问题。

---

### [01:04:04] Lenny

**English:**
Yeah, [inaudible 01:04:05] I think mentioned that. I think there's a term for it, data something, where you randomly get chosen every week and someone has to present your data.

**中文翻译:**
是的，我想（听不清）提到过。好像有个术语，叫“数据什么什么”，就是每周随机抽选，被抽到的人必须展示数据。

---

### [01:04:04] Claire Hughes Johnson

**English:**
The metrics review meeting, yes.

**中文翻译:**
指标回顾会议，没错。

---

### [01:04:10] Lenny

**English:**
And it's like the next day, you're going to have to share your meetings and [inaudible 01:04:12]

**中文翻译:**
就像第二天你就得分享你的会议和（听不清）。

---

### [01:04:12] Claire Hughes Johnson

**English:**
Yes. We called it the spin the wheel, the spin wheel on who gets to present. But that has a logic in it, which is then you're not working. So just prepare it.

**中文翻译:**
是的。我们称之为“转轮盘”，转到谁谁就来演示。但这背后有一个逻辑：如果你不演示，你就不在工作。所以，准备好就行。

---

### [01:04:26] Lenny

**English:**
Right. That's awesome. I love that policy. There's so much more I want to chat about. There's chapters on hiring, self-development, personal development, all these things.

**中文翻译:**
对。太棒了，我喜欢这个政策。我还有很多想聊的。书里还有关于招聘、自我发展、个人成长等章节。

---

### [01:04:34] Claire Hughes Johnson

**English:**
Team development. Yep.

**中文翻译:**
团队发展，没错。

---

### [01:04:36] Lenny

**English:**
What was that?

**中文翻译:**
你说什么？

---

### [01:04:36] Claire Hughes Johnson

**English:**
There's a, yeah, intentional. There's a team building.

**中文翻译:**
是的，有意识的团队建设。

---

### [01:04:40] Lenny

**English:**
Team building.

**中文翻译:**
团队建设。

---

### [01:04:40] Claire Hughes Johnson

**English:**
And performance management.

**中文翻译:**
还有绩效管理。

---

### [01:04:41] Lenny

**English:**
Yeah. Okay, so we could go through all that stuff. Instead, I want to talk about the COO role broadly.

**中文翻译:**
好。我们可以把那些都过一遍。但我想泛泛地聊聊 COO 这个角色。

---

### [01:04:47] Claire Hughes Johnson

**English:**
Yes.

**中文翻译:**
好的。

---

### [01:04:48] Lenny

**English:**
I asked on Twitter, preparing for this chat, what people wanted me to ask you about it. And most of the questions ended up being about the COO role and things like that. So I just have a few questions lined up here for you.

**中文翻译:**
为了准备这次谈话，我在 Twitter 上问大家想让我问你什么。结果大多数问题都集中在 COO 角色之类的事情上。所以我为你准备了几个问题。

---

### [01:04:48] Claire Hughes Johnson

**English:**
Sure.

**中文翻译:**
没问题。

---

### [01:04:58] Lenny

**English:**
Okay. So Amir [inaudible 01:05:04], with little accent at the end there, he asked just at what point do companies need a COO, and how would you judge if someone is a fantastic COO?

**中文翻译:**
好。Amir（听不清）问：公司在什么时候需要 COO？你如何判断一个人是否是出色的 COO？

---

### [01:05:12] Claire Hughes Johnson

**English:**
Oh yeah. Well, I would first say most companies, if you looked at the universe of all companies, do not have a COO. I think it's fewer than 20%. It's definitely fewer than 30. And I think that's something to know, that I don't think it's an automatic role to have or hire. And I think you see it in more prevalently in earlier stage or high growth companies. You also, by the way, see it in certain business models. I actually think Apple was an interesting version of this, where Steve Jobs was oriented in terms of product and design, but also that Apple has... It's very intense to manufacture software and hardware that then works together. I learned that when I worked on self-driving cars at Google, and you need a very intensely operational, detailed manufacturing, hit the marks, hit the timelines person. So I think some businesses that have a very deeply operational, say a manufacturing component, that role might be more prevalent.

**中文翻译:**
噢，好的。首先我想说，如果你看全球所有的公司，大多数公司其实都没有 COO。我想比例不到 20%，肯定不到 30%。我觉得这一点需要了解：我不认为这是一个必须设立或招聘的职位。我认为在早期阶段或高增长公司中，这个职位更常见。顺便说一下，在某些商业模式中也能看到。我觉得苹果是一个有趣的例子：乔布斯专注于产品和设计，但苹果……制造能协同工作的软件和硬件是非常密集的。我在 Google 做自动驾驶汽车时学到了这一点：你需要一个极度关注运营、细节制造、能达成指标并按时交付的人。所以我觉得一些具有深度运营（比如制造环节）的业务，这个角色可能会更普遍。

---

### [01:06:19] Claire Hughes Johnson

**English:**
But point is, it's not an automatic. I think it's useful in a high growth... In an environment where you're having... Think about the founder/CEO of a company that is achieving product market fit and also having to build a company, and hire all the leaders. That is a lot because you are building the product and the business, you are building the company, and you are building all the people, bringing them all in. And that is where I think a COO type of role can give you leverage, which is... Essentially, it's a layer that takes some of those functions and helps build them with you and on your behalf, and also in some cases, bring some experience in maybe there's a particular function like go to market that needs to be built. And I think that's where you see it come up. What I've said to some people recently is I'm a little worried, just like there's a mythical founder, that there's some mythical silver bullet COO hire that everyone's like, "I will just find that person."

**中文翻译:**
但重点是，这并不是自动设立的。我认为在高增长环境下它很有用……想象一下，一个创始人/CEO 既要实现 PMF，又要建立公司，还要招聘所有的领导者。这工作量太大了，因为你既在构建产品和业务，又在构建公司，还在构建人才队伍，把他们都招进来。这就是我认为 COO 类型的角色能给你带来杠杆作用的地方……本质上，它是一个层级，承担了其中一些职能，并协助你或代表你来构建它们。在某些情况下，它还能带来经验，比如需要建立像“市场进入”这样的特定职能。我认为这就是这个角色出现的原因。我最近对一些人说，我有点担心，就像存在“神话般的创始人”一样，现在也存在某种“神话般的万灵丹 COO”，大家都觉得“我只要找到那个人就行了”。

---

### [01:07:20] Claire Hughes Johnson

**English:**
And first of all, we're all human beings. I'm not perfect. I certainly did some things well when I joined Stripe, and other things not as well, and I'm working on my self-awareness of what those things are. But I would say one lower risk strategy could be to bring in, say, a head of business operations or a role that's sort of COO like and try a couple of functions with someone and see if they scale with the company and with the role, and then maybe you decide they're a COO. I mean, I mentioned Stripe's business operations team. You could hire a business ops leader and sort of say, "Hey, build this team to help be the Swiss Army knife to help scale the company, and then maybe that turns into more." Or there's some CFOs that are quite operational. They could take on more scope sometimes.

**中文翻译:**
首先，我们都是凡人。我不完美。我加入 Stripe 时，有些事情做得很好，有些则不然，我也在努力提高对这些事情的自我意识。但我会说，一个风险较低的策略是：先引入一个（比如）业务运营负责人（Head of Business Operations）或类似 COO 的角色，让某人尝试负责几个职能，看看他们是否能随公司和职位的成长而成长，然后你再决定他们是否是 COO。我提到过 Stripe 的业务运营团队。你可以雇一个业务运营领导者，对他说：“嘿，建立这个团队，成为帮助公司规模化的‘瑞士军刀’，以后也许会发展成更多职能。”或者有些 CFO 非常偏向运营，他们有时也可以承担更多职责。

---

### [01:08:11] Claire Hughes Johnson

**English:**
But I think there are other paths to getting that leverage, and there are also ways to de-risk the hire because you could end up searching forever, right? And I worry that it's become too much of a panacea in people's minds, like somehow they're going to find... And people will call me, and they'll be like, "I just need to find you." And I'm like, "One, I may not be right for your company, but two, that was a lot of work, and I think we actually, in the end, maybe got pretty lucky." How would you know someone is fantastic? Someone said something very smart to me, which was... I was in a meeting. It was me and Patrick. So Patrick is the co-founder and CEO of Stripe. And they said that having just the right amount of tension in our relationship was how you knew it was working for the company.

**中文翻译:**
我认为获得这种杠杆作用还有其他路径，也有降低招聘风险的方法，否则你可能会找上一辈子，对吧？我担心这在人们心中已经变成了一种万能药，觉得总能找到……有人会打电话给我说：“我只需要找到像你这样的人。”我会说：“第一，我不一定适合你的公司；第二，那需要大量的工作，而且我觉得我们最终其实可能挺幸运的。”你如何知道一个人是否出色？有人曾对我说了句非常聪明的话……当时我在开会，只有我和 Patrick（Stripe 的联合创始人兼 CEO）。他们说，我们的关系中保持着“恰到好处的张力”，这就是你知道这种关系对公司有效的方式。

---

### [01:09:03] Claire Hughes Johnson

**English:**
And it gave us both a little bit of pause, but we ended up having quite a good conversation after that meeting, which is there has to be mutual understanding and trust and an ability for Patrick to say, "Hey, can you go do this thing?" And then believing, I will do it at the level of quality and intensity and intentionality that he would like. But there also has to be some friction, where I would maybe say, "No, I'm not going to prioritize that. I don't think that's important for the company," or I'm going to give you feedback that I don't think we're doing this well, or he's giving me feedback. The customer experience is suffering. All your scale stuff is degrading this thing, right? So fantastic is not all hunky dory. Fantastic COO is just the right amount of friction intention with forward momentum and mutual trust, because then the whole is greater than the sum of its parts, right? That's what you're looking for.

**中文翻译:**
这话让我们俩都愣了一下，但会后我们进行了一次非常好的谈话：我们之间必须有相互的理解和信任，Patrick 能够说“嘿，你能去做这件事吗？”，并且相信我会以他期望的质量、强度和意图去完成。但同时也必须有一些摩擦，我会说：“不，我不打算优先处理那件事，我觉得那对公司不重要。”或者我会给他反馈说我觉得我们这件事做得不好，或者他给我反馈说客户体验在下降，你搞的那些规模化的东西正在损害这件事，对吧？所以，“出色”并不意味着一切都顺风顺水。出色的 COO 是在保持前进势头和相互信任的同时，拥有恰到好处的摩擦和张力，因为这样整体才会大于部分之和，对吧？这就是你所追求的。

---

### [01:10:03] Lenny

**English:**
I was actually going to say, I've worked with some founders, and they have this concept that they hire a COO, and they would just solve all these cultural issues they're having these relationship issues. And sounds like that's exactly what you're saying, is that that is not often the solution to some of these deeper issues.

**中文翻译:**
我其实正想说，我曾与一些创始人共事，他们有一种观念：只要雇一个 COO，就能解决他们面临的所有文化问题或人际关系问题。听起来你说的正是这个意思：COO 通常不是解决这些深层问题的方案。

---

### [01:10:18] Claire Hughes Johnson

**English:**
Well, that would be the other problem, is actually believing... I was getting recruited, Lenny, and people would... Essentially, I felt like the founders were saying to me, "I'm going to give you all of the things I don't like doing as your job." And I was like, even if I'm by the way not qualify to do all those things, number one. And two is sometimes that list would be quite long, and that would make me nervous. I was like, "Do you really not running a company actually? Is that what's going on here?" And really, I think they weren't confronting elements of their work that needed to evolve and change. And what I loved about joining Stripe was... I think people also think, "I'm just going to hand all this stuff to this person and..." I'd love to say I took all this off of the Collisons plate, and Billy and John and the other people who were there at the time, and no, we actually were more collaboratively worked together, and I think it helped...

**中文翻译:**
那是另一个问题，就是真的相信……Lenny，当我被猎头招募时，我感觉创始人基本上是在对我说：“我要把我所有不喜欢做的事情都交给你作为你的工作。”我的反应是：第一，顺便说一下，我不一定有资格做所有那些事；第二，有时那个清单会非常长，这让我很紧张。我会想：“你是不是其实不想经营公司？到底是怎么回事？”实际上，我认为他们没有正视自己工作中需要进化和改变的部分。我喜欢加入 Stripe 的一点是……我认为人们还觉得“我只要把这些东西都扔给这个人就行了”，我很想说我把 Collison 兄弟、Billy、John 以及当时其他人的负担都卸下来了，但其实不是，我们实际上是更紧密地协作，我认为这很有帮助……

---

### [01:11:18] Claire Hughes Johnson

**English:**
Well, one, you don't feel as isolated because you're in a team, but also there's more joint work than people realize, I think at least in the companies I'd like to work for.

**中文翻译:**
嗯，第一，你不会感到那么孤立，因为你在一个团队里；第二，共同完成的工作比人们意识到的要多，至少在我愿意效力的公司里是这样的。

---

### [01:11:30] Lenny

**English:**
For the final 10-ish minutes we have together, and you have to run-

**中文翻译:**
在我们最后大约 10 分钟的时间里，你待会儿还得赶时间——

---

### [01:11:33] Claire Hughes Johnson

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:11:34] Lenny

**English:**
... I was thinking I could go through just a rapid fire set of tactical questions and see maybe one piece of advice you would share with someone that's maybe struggling with this thing.

**中文翻译:**
……我想我可以快速过一遍一系列战术性问题，看看你是否能给那些正在为此挣扎的人分享一条建议。

---

### [01:11:44] Claire Hughes Johnson

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:11:45] Lenny

**English:**
And the first is from a also Twitter person, Manuel [inaudible 01:11:52]. And he just had a question around, as you're scaling, keeping alignment strong is challenging. What would be something you'd recommend to someone that's scaling quickly and trying to keep people aligned?

**中文翻译:**
第一个问题来自 Twitter 上的 Manuel（听不清）。他的问题是：在规模化过程中，保持高度一致（alignment）非常具有挑战性。对于那些正在快速扩张并试图保持人员步调一致的人，你有什么建议？

---

### [01:12:02] Claire Hughes Johnson

**English:**
Well, a lot of what we talked about, having common codified documents of what we believe in, how we work, and then using communication practices very intelligently. Never think that one communication, meaning an email or an all hands, reaches the audience. You have to be smart about how you communicate.

**中文翻译:**
嗯，很多我们已经聊过了：拥有通用的、成文的文档来阐述我们的信念和工作方式，然后非常聪明地运用沟通实践。永远不要认为一次沟通（比如一封邮件或一次全员大会）就能传达到位。你必须在沟通方式上动脑筋。

---

### [01:12:23] Lenny

**English:**
Awesome. Amazing. On a different podcast, we talked about how the leaders are often the repeater in chief, just having to repeat the same thing again and again.

**中文翻译:**
太棒了。在另一个播客中，我们谈到领导者通常是“首席重复官”，必须一遍又一遍地重复同样的事情。

---

### [01:12:30] Claire Hughes Johnson

**English:**
Yes. And just like a marketer, use different channels. Some people read emails, some people watch videos, some people attend the meeting. Repeat.

**中文翻译:**
是的。就像营销人员一样，使用不同的渠道。有些人读邮件，有些人看视频，有些人参加会议。不断重复。

---

### [01:12:40] Lenny

**English:**
Love it. That'll be our clip to take away from this. I was watching an interview with you, and you talked about the value of offsites for creating cohesion within a team. Can you just talk about why offsites are so important to a company and a team?

**中文翻译:**
太喜欢这个了。这将是我们这期节目的精华片段。我看过你的一个采访，你谈到了团建（offsites）对于建立团队凝聚力的价值。你能谈谈为什么团建对公司和团队如此重要吗？

---

### [01:12:53] Claire Hughes Johnson

**English:**
I think offsite is really a vehicle. The concept is the following, which is when you yank people out of their day-to-day routine, you create space, and also you imprint memory. And so if you say, "We're going to do a very different thing with your time today or the next two days, we're not going to do our emails, we're not going to do our regular meetings, we are going to sit and work together, we're going to brainstorm," you're basically activating new parts of their brain, and then you're also having a group experience that cements a belief system usually, or a set of plans. And it also helps bring people along. We formed this thing together, it's not effective if I say, "I locked myself in a room for three hours, and then I came out and here's the plan." You want to lock yourselves as a group, as a team in a room for three hours. How do you do that? And so that's why I think it's valuable. It's just out of time, in a way. You're taking it out of your day-to-day time, and I can't not found a good substitute for that.

**中文翻译:**
我认为团建实际上是一种载体。其理念是：当你把人们从日常琐事中“拽”出来时，你创造了空间，同时也刻下了记忆。如果你说：“今天或接下来的两天，我们要用一种完全不同的方式分配时间，我们不回邮件，不开常规会议，我们要坐在一起工作，一起头脑风暴”，你基本上是在激活他们大脑的新部分。然后你们会有一种集体体验，这通常会巩固一种信仰体系或一套计划。这也有助于让大家参与进来。我们共同构思了这件事，这比我说“我把自己关在房间里三小时，出来后这就是计划”要有效得多。你想让大家作为一个整体、一个团队关在房间里三小时。你该怎么做？这就是我认为它有价值的原因。在某种程度上，它是“跳出时间”的。你把它从日常时间中抽离出来，我还没发现有什么好的替代方案。

---

### [01:13:56] Lenny

**English:**
On a different topic, one of the most common questions I get from product managers and just founders that I haven't tackled yet, and I'm curious what your take is, is around just keeping the company updated on what's happening broadly.

**中文翻译:**
换个话题。我从产品经理和创始人那里收到的最常见、但我还没处理过的问题之一是：如何让全公司了解大局动态。我很想听听你的看法。

---

### [01:14:07] Lenny

**English:**
What have you found works for just keeping people informed on what's happening across the company and-

**中文翻译:**
你发现哪些方法能有效地让人们了解公司各处发生的事情？

---

### [01:14:12] Claire Hughes Johnson

**English:**
Having really smart communication practices is something that I think a lot of companies don't invest in early, and it's partly because it feels like extraneous, but it's a lot of time. If you're going to communicate well, you have to invest in your intranet site and what's on it. Ideally, everyone logs in and sees information on the homepage of your company internally. Do you have a newsletter? Do you have founders do like a message or a quick video, whether that's on Slack or email. There's a lot of smart tools. You can learn a lot from social media in some ways, but you actually need a strategy for it, and you need a set of people who help make sure it happens so that again, it creates stability and cadence. And if I want to find information about X, this is where I go. And I think there's also that if you do it well, it can replicate down to teams, which is, oh, we have our weekly snippet stock that everybody can see the important news or whatever it is.

**中文翻译:**
我认为很多公司早期都没有投资于“聪明的沟通实践”，部分原因是觉得那是多余的，但其实它很耗时。如果你想沟通顺畅，你必须投资于内网（intranet）及其内容。理想情况下，每个人登录后都能在公司内网主页上看到信息。你有邮件通讯吗？创始人会发布消息或短视频吗（无论是在 Slack 还是邮件上）？有很多聪明的工具。在某些方面你可以向社交媒体学习，但你实际上需要一个策略，需要一组人来确保它发生，从而再次创造稳定性和节奏。如果我想找关于 X 的信息，我就去这里。我认为如果你做得好，它可以复制到各个团队，比如：“噢，我们有每周简报文档，每个人都能看到重要新闻”之类的。

---

### [01:15:09] Claire Hughes Johnson

**English:**
But you need to create those things because they'll start to spring up, but then you'll have a million of them, and you won't be able to point people to the core messages. But it is not a thing to be taken lightly. And I think having someone who really not focuses on internal marketing, I'm talking about just good, "Here's what's important. Here's what you need to know." Sales teams actually do this really well, because they have to, because they have to keep the sellers up to date on the product and up to date on how to pitch it. And so it actually is worth talking to smart sort of sales leaders who've scaled and saying, what do you do that keeps everyone on the same page

**中文翻译:**
但你需要主动创建这些机制，否则它们会自发产生，然后你会拥有成千上万个渠道，却无法引导人们关注核心信息。这绝不是一件可以轻视的事。我认为需要有人专注于此——不是那种内部营销，而是真正的：“这是重要的事，这是你需要知道的事。”销售团队其实在这方面做得很好，因为他们必须这样做，必须让销售人员了解最新的产品动态和推销方式。所以，去和那些经历过规模化的聪明销售领导者聊聊是很值得的，问问他们是怎么让所有人保持步调一致的。

---

### [01:15:48] Lenny

**English:**
As you're talking, I realized [inaudible 01:15:49], who we mentioned a couple times, she left Retool, and she's working at a startup that has trying to solve this problem, I think it's called. It

**中文翻译:**
听你说话时，我意识到我们提到过几次的（听不清），她离开了 Retool，现在在一家初创公司工作，正试图解决这个问题。

---

### [01:15:56] Claire Hughes Johnson

**English:**
Is a lot about what they're working on. And it's because it is, again, an unsung thing that is critical and that I don't think people naturally come to.

**中文翻译:**
这正是他们正在努力的方向。因为这又是一件被低估但至关重要的事情，而且我认为人们不会自然而然地想到它。

---

### [01:16:03] Lenny

**English:**
Next question, what are one to two, or maybe three things that people can do to run more effective meetings? I say give this masterclass on running more effective meetings. And just to boil down, what are a couple things people could probably change?

**中文翻译:**
下一个问题：人们可以做哪两三件事来提高会议效率？就像是关于高效会议的“大师课”。归纳一下，人们可以改变哪几点？

---

### [01:16:16] Claire Hughes Johnson

**English:**
I do have a video on YouTube about running an effective meeting, but I think the number one thing is the work of a meeting is not calling the meeting. Calling a meeting is easy. In fact, that is a problem. The barrier is very low, and it should be higher. What you really want to know... People need to know why are we meeting, and what is the point, what's the objective of this meeting? Is it to make a decision? Is it to share information? Who needs to be here? One of my favorite things to say is make the thing that's implicit explicit. Too many meetings are implicitly about something and not explicit enough. And I'm like, "No, no, no. I want to know why I'm here. Are we making the decision? Who's making the decision? And how?" Even better, you say, "Does anyone not need to be here? Because we'll just send you a note afterwards about what happened? Right? Make it more efficient, but be really explicit about the point of the meeting, and really do some inquiry on whether it's important, whether it's needed.

**中文翻译:**
我在 YouTube 上确实有一个关于高效会议的视频。但我认为最重要的一点是：会议的工作不是“发起会议”。发起会议很容易，事实上，这正是问题所在。门槛太低了，应该提高。你真正想知道的是……人们需要知道我们为什么要开会？重点是什么？会议的目标是什么？是为了做决定？还是为了分享信息？谁必须到场？我最喜欢说的一句话是：“把隐含的事情显性化”。太多的会议只是隐含地关于某事，而不够明确。我会说：“不，不，不。我想知道我为什么在这里。我们要不要做决定？谁来做决定？怎么做？”更好的是，你会问：“有没有人不需要在这里？因为会后我们会发一份纪要告诉你发生了什么。”对吧？让它更高效，但要对会议的目的非常明确，并真正探究它是否重要、是否必要。

---

### [01:17:17] Lenny

**English:**
Maybe a final question is around decision making. So product managers who are, a lot of the audience of this podcast, have to, one, make a lot of decisions, get people to alignment, but they also don't classically have authority over anyone. What advice do you have for aligning and decision making?

**中文翻译:**
最后一个问题可能是关于决策的。产品经理（本播客的大部分听众）必须做很多决定，让大家达成一致，但他们通常对任何人都没有行政权威。对于达成一致和做决策，你有什么建议？

---

### [01:17:34] Claire Hughes Johnson

**English:**
I love product management, so much accountability. So little authority. Such a hard job.

**中文翻译:**
我喜欢产品管理，责任重大，权力微小。真是个苦差事。

---

### [01:17:39] Lenny

**English:**
What a fun [inaudible 01:17:41].

**中文翻译:**
多么有趣的（听不清）。

---

### [01:17:41] Claire Hughes Johnson

**English:**
Everyone's like, "I want to be a product manager." I'm like, man, that is one of the hardest jobs in tech.

**中文翻译:**
每个人都说“我想当产品经理”，我心想：伙计，那是科技界最难的工作之一。

---

### [01:17:45] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:17:46] Claire Hughes Johnson

**English:**
But anyway, how do you get people to a decision?

**中文翻译:**
但不管怎样，你如何让人们达成决策？

---

### [01:17:48] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:17:50] Claire Hughes Johnson

**English:**
Actually, it's exactly... And I mentioned in my book, Gokul's SPADE Framework, which you can look up. He has a coda on it. But actually, it's the same thing that I said about meetings, which is making it very explicit, that there is a decision to be made, who is making the decision, the criteria by which the decision's going to be made, who will be informed. There's all these models. There's racy and radar, and there's a million different decision models. Just pick one, make it explicit, explain that's what's happening, and get people through it. Follow the model and do it. And by the way, you can always have an asterisk, which is if we want to revisit this decision, this is what we do. But I think too many teams get paralyzed because they're afraid, like, well, maybe they're not the decision maker, or maybe... When I say to people at Stripe in our onboarding, I used to run a session, I was like, if you're not sure who the decision maker is, one, it's probably you, and I'd rather you act that way than not because you're going to slow the whole company down.

**中文翻译:**
实际上，这正是我在书里提到的 Gokul 的 SPADE 框架（你可以去查一下，他对此有详细说明）。其实这和我说的会议是一回事：要非常明确。明确有一个决定要做，明确谁是决策者，明确决策的标准，明确谁会被告知。有很多模型，比如 RACI、RADAR，还有成千上万种决策模型。选一个，把它显性化，解释清楚正在发生什么，然后带大家走完流程。遵循模型去做。顺便说一下，你总是可以加个备注：如果我们想重新审视这个决定，我们会怎么做。但我认为太多的团队陷入瘫痪是因为害怕，比如担心自己不是决策者，或者……我在 Stripe 的入职培训中常说：“如果你不确定谁是决策者，第一，那很可能就是你。我宁愿你表现得像个决策者，也不愿你畏首畏尾，因为那样会拖慢整个公司的进度。”

---

### [01:18:52] Claire Hughes Johnson

**English:**
But really, I think the other thing is, in the book, I talk about this framework that Bezos uses, type one, type two decisions. Is it high impact? Is it irreversible? Is it not? Really evaluate, what kind of decision is this? How hard is it? And then follow a process and get it done. And don't forget to actually make a decision. And if you don't know who the decision maker is and you're worried it's not you, just ask. Don't get stuck. Too many people get stuck, and it makes your work terrible, right? What do we all care about? Progress, impact, momentum. If anything I would say about advice to people generally is be a force for positive momentum, and it will be actually a real career maker.

**中文翻译:**
但实际上，我认为另一件事是——我在书里谈到了贝佐斯使用的框架：第一类和第二类决策。它是高影响力的吗？它是不可逆的吗？还是可逆的？真正评估一下：这是哪种决策？难度有多大？然后遵循流程把它搞定。别忘了最后要真正做出决定。如果你不知道谁是决策者，又担心不是自己，那就直接问。不要卡在那里。太多人卡住了，这让工作变得一团糟，对吧？我们大家在乎的是什么？是进展、影响力和势头。如果让我给大众提一点建议，那就是：成为推动积极势头的力量，这真的会成就你的职业生涯。

---

### [01:19:41] Lenny

**English:**
I love that. Maybe we'll make that the title of this interview. With that, Claire, I know you have to run. Anyone listening, you got to buy this book. Like I've said at the beginning, if you like my newsletter, it's exactly my newsletter, but as a book about operations.

**中文翻译:**
我喜欢这个。也许我们会把这句话作为这次采访的标题。Claire，我知道你得赶时间了。听众朋友们，一定要买这本书。正如我开头所说，如果你喜欢我的邮件通讯，这本书简直就是运营版的邮件通讯。

---

### [01:19:54] Claire Hughes Johnson

**English:**
Thank you. Scaling People.

**中文翻译:**
谢谢。书名是《Scaling People》。

---

### [01:19:56] Lenny

**English:**
Scaling People. Is there a website they can go to to check it out on Amazon, or is there-

**中文翻译:**
《Scaling People》。有没有什么网站可以查看，或者在亚马逊上……

---

### [01:20:00] Claire Hughes Johnson

**English:**
They can go to press.stripe.com/scaling-people.

**中文翻译:**
可以访问 press.stripe.com/scaling-people。

---

### [01:20:00] Lenny

**English:**
Amazing.

**中文翻译:**
太棒了。

---

### [01:20:06] Claire Hughes Johnson

**English:**
Or Amazon. Just search scaling people on Amazon.

**中文翻译:**
或者在亚马逊上直接搜索“Scaling People”。

---

### [01:20:08] Lenny

**English:**
Cool.

**中文翻译:**
好的。

---

### [01:20:09] Claire Hughes Johnson

**English:**
But thank you, Lenny. I appreciate it.

**中文翻译:**
谢谢你，Lenny。非常感谢。

---

### [01:20:12] Lenny

**English:**
Absolutely. Just two final questions. Where can folks find you if they want to maybe ask you questions, follow up, reach out? And then two, any other way people can be helpful to you, other than maybe pre-ordering the book?

**中文翻译:**
没问题。最后两个问题：如果大家想问你问题、后续跟进或联系你，可以在哪里找到你？第二，除了预订这本书，大家还有什么可以帮到你的吗？

---

### [01:20:20] Claire Hughes Johnson

**English:**
Well, definitely pre-ordering the book and giving me feedback on that. I guess Twitter is probably the best place to find me. I'm @chughesjohnson on Twitter. But honestly, I do hope you'll consume the book in some form and interact with it because the goal is to make it useful. We talked about this, Lenny, your podcast for my book is just trying to be of use, and I hope it is a positive force for positive momentum. And I really appreciate the opportunity.

**中文翻译:**
嗯，当然是预订这本书并给我反馈。我想 Twitter 可能是找我最好的地方，我的账号是 @chughesjohnson。但老实说，我真的希望你能以某种形式阅读这本书并与之互动，因为我的目标是让它发挥作用。Lenny，我们聊过这个，你的播客和我的书一样，都只是想提供帮助。我希望它能成为推动积极势头的积极力量。非常感谢这次机会。

---

### [01:20:49] Lenny

**English:**
Absolutely. Thanks for making time for this.

**中文翻译:**
当然。感谢你抽时间参加。

---

### [01:20:53] Claire Hughes Johnson

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:20:53] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。