# Crystal W - 双语对照

# Lenny's Podcast: Crystal Widjaja (Bilingual Transcript)

---

### [00:00:00] Crystal Widjaja

**English:**
I felt like it was a problem that was very solvable. And we ended up renting a stadium to just hire 60,000 drivers in a couple of weeks. So I think looking back, it was certainly a risk. When I got there it was in a house and I realized I've probably made a huge mistake, but we were growing very quickly already, even at that small scale of 4,000 orders per day.

**中文翻译:**
我觉得那是一个非常可解的问题。我们最终租下了一个体育场，在短短几周内就雇佣了 6 万名司机。所以回想起来，这确实是一次冒险。当我刚到那里时，公司还在一间民宅里办公，我意识到自己可能犯了一个巨大的错误，但即便是在每天只有 4000 个订单的小规模阶段，我们当时已经增长得非常快了。

---

### [00:00:29] Lenny

**English:**
Crystal Widjaja has been leading product and growth teams at some of the largest consumer businesses in Southeast Asia, including Kumu, where she's currently the chief product officer, and Gojek where she built and led the growth team through the early years of what is now the largest super app in Southeast Asia. To put this in context, Gojek completes more rights per day than Lyft and more food deliveries than GrubHub, Uber Eats and DoorDash combined, and it's the number one mobile wallet in Indonesia and Southeast Asia. In my opinion, American startups have a lot to learn from startups in Asia and Crystal has been at the ground floor of some of the biggest successes there.

**中文翻译:**
Crystal Widjaja 一直在东南亚一些最大的消费类企业领导产品和增长团队，包括她目前担任首席产品官的 Kumu，以及 Gojek。在 Gojek，她建立并领导了增长团队，度过了其早期阶段，如今 Gojek 已成为东南亚最大的超级应用（Super App）。为了让大家了解其规模，Gojek 每天完成的打车订单比 Lyft 还多，外卖订单量比 GrubHub、Uber Eats 和 DoorDash 的总和还要多，而且它还是印度尼西亚和东南亚排名第一的移动钱包。在我看来，美国初创公司有很多值得向亚洲初创公司学习的地方，而 Crystal 亲历了那里一些最成功案例的初创阶段。

---

### [00:01:06] Lenny

**English:**
In our conversation, we covered the biggest growth unlocks that Crystal has seen across the companies she's worked at, what growth investments usually pay off and which often don't, we dig into growth models, a bunch of tips for accelerating growth, why most analytics efforts fail in how to avoid that, how to hire and structure your growth team, and we also talk about the nonprofit that Crystal started that aims to help young women get into STEM called Generation Girl. Crystal is such a star, and I hope that you enjoy this episode as much as I did. And with that, I bring you Crystal Widjaja. If you're setting up your analytics stack, but you're not using Amplitude, what are you doing? Amplitude is the number one most popular analytic solution in the world used by both big companies like Shopify, Instacart, and Atlassian, and also most tech startups.

**中文翻译:**
在我们的对话中，我们讨论了 Crystal 在她工作过的公司中见证过的最大增长突破点、哪些增长投资通常会有回报而哪些往往没有。我们深入探讨了增长模型、一系列加速增长的技巧、为什么大多数数据分析工作会失败以及如何避免失败、如何招聘和构建你的增长团队。我们还聊到了 Crystal 发起的非营利组织 Generation Girl，旨在帮助年轻女性进入 STEM（科学、技术、工程、数学）领域。Crystal 表现得非常出色，我希望你们能像我一样喜欢这一集。下面，让我们欢迎 Crystal Widjaja。如果你正在搭建分析技术栈却没用 Amplitude，你在想什么呢？Amplitude 是全球最受欢迎的分析解决方案，不仅被 Shopify、Instacart 和 Atlassian 等大公司使用，也是大多数科技初创公司的首选。

---

### [00:01:59] Lenny

**English:**
Amplitude has everything you need, including a powerful and fully self-service analytics product, an experimentation platform, and even an integrated customer data platform to help you understand your users like never before. Give your teams self-service product data to understand your users, drive conversions and increase engagement, growth, and revenue. Get your vanity metrics, trust your data, work smarter and grow your business. Try Amplitude for free. Just visit amplitude.com to get started. Hey, Ashley, head of marketing at Flatfile. How many B2B SaaS companies would you estimate need to import CSV files from their customers?

**中文翻译:**
Amplitude 拥有你所需的一切，包括强大且完全自助式的分析产品、实验平台，甚至还有一个集成的客户数据平台，帮助你以前所未有的方式了解用户。为你的团队提供自助式产品数据，以洞察用户、推动转化并提高参与度、增长和收入。告别虚荣指标，信任你的数据，更聪明地工作并发展业务。免费试用 Amplitude，访问 amplitude.com 即可开始。嘿，Ashley（Flatfile 营销负责人），你估计有多少 B2B SaaS 公司需要从客户那里导入 CSV 文件？

---

### [00:02:40] Ashley

**English:**
At least 40%?

**中文翻译:**
至少 40% 吧？

---

### [00:02:40] Lenny

**English:**
And how many of them screw that up, and what happens when they do?

**中文翻译:**
那其中有多少公司把这件事搞砸了？搞砸后会发生什么？

---

### [00:02:43] Ashley

**English:**
Well, based on our data about a third of people will consider switching to another company after just one bad experience during onboarding. So if your CSV importer doesn't work right, which is super common, considering customer files are chalked full of unexpected data and formatting, they'll leave.

**中文翻译:**
嗯，根据我们的数据，大约三分之一的人在入职引导（onboarding）过程中只要经历一次糟糕的体验，就会考虑更换服务商。所以，如果你的 CSV 导入工具运行不正常（这非常普遍，因为客户文件充满了各种意想不到的数据和格式），他们就会流失。

---

### [00:03:02] Lenny

**English:**
I am zero percent surprised to hear that. I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing longterm retention, getting people to your aha moment more quickly and reliably is so incredibly important.

**中文翻译:**
听到这个我一点也不意外。我一直认为，优化入职引导是提高注册转化率和增加长期留存率的最高杠杆机会之一。让用户更快速、更可靠地体验到“顿悟时刻”（aha moment）是极其重要的。

---

### [00:03:17] Ashley

**English:**
Totally. It's incredible to see how our customers like Square, Spotify and Zora are able to grow their businesses on top of Flatfile. It's because flawless data onboarding acts like a catalyst to get them and their customers where they need to go, faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zora 这样的客户如何在 Flatfile 的基础上发展业务，真是令人惊叹。这是因为完美的数据入职引导就像催化剂，能让他们和他们的客户更快地达到目标。

---

### [00:03:34] Lenny

**English:**
If you'd like to learn more or get started, check out Flatfile at flatfile.com/lenny. Crystal, thank you so much for being here. I've read a bunch of your stuff online. We've exchanged a bunch of emails and tweets, but this is the first time that we're actually chatting for real, and so I'm really excited to, yeah I'm excited to learn from you and for folks to learn about you.

**中文翻译:**
如果你想了解更多或开始使用，请访问 flatfile.com/lenny 查看 Flatfile。Crystal，非常感谢你能来。我在网上读过很多你写的文章，我们也交流过很多邮件和推文，但这是我们第一次真正面对面交谈。我非常兴奋能向你学习，也让大家更了解你。

---

### [00:03:56] Crystal Widjaja

**English:**
We may have crossed paths on Clubhouse and the audio forums or on the Twitterverse. So it's really cool to see you.

**中文翻译:**
我们可能在 Clubhouse、音频论坛或者 Twitter 上有过交集。所以见到你真的很酷。

---

### [00:04:04] Lenny

**English:**
Wow. I just remembered that. That is so right. I think we were talking about Reforge and Eppo. Is that right?

**中文翻译:**
哇，我想起来了。没错。我记得我们当时在聊 Reforge 和 Eppo，对吧？

---

### [00:04:11] Crystal Widjaja

**English:**
Yes, that's right. Good times.

**中文翻译:**
是的，没错。那段时光很美好。

---

### [00:04:11] Lenny

**English:**
Oh my God. Clubhouse days.

**中文翻译:**
天哪，Clubhouse 的日子。

---

### [00:04:13] Crystal Widjaja

**English:**
The days when club does was a thing. They have a thing too, to learn about exponential decay.

**中文翻译:**
那是 Clubhouse 还很火的时候。他们也让我们见识到了什么是“指数级衰减”（exponential decay）。

---

### [00:04:18] Lenny

**English:**
Oh man. Okay. Maybe we'll get to that. And we're going to be chatting a lot about consumer growth and a bunch of stuff along those lines. But before you get into that, you have a fairly unusual path and also geography as compared to many of my other guests. And so just to set a little context, could you just walk us through your career path and journey from, I think as an investment banker initially, and then currently as chief product officer at Kumu and then living in Singapore also? So yeah, tell us all about your path.

**中文翻译:**
噢伙计。好吧，也许我们稍后会聊到那个。我们将深入探讨消费端增长以及相关的话题。但在那之前，与我的许多其他嘉宾相比，你的职业路径和地理位置都相当不寻常。为了让大家了解背景，你能带我们回顾一下你的职业生涯吗？我记得你最初是做投资银行的，现在是 Kumu 的首席产品官，而且还住在新加坡？所以，请跟我们聊聊你的经历。

---

### [00:04:45] Crystal Widjaja

**English:**
Yeah. I think my path was certainly a nonstandard one. While I grew up in San Jose, the Bay Area, you could see companies like Lyft emerging around the year that I was graduating college. But really it was how do I graduate college as quickly as possible because this is very boring. So I took a Poli Sci major. I am not a math or a computer science major. I didn't know what a consultant was because I was just trying to get out of college. I didn't realize people start looking for jobs before they'd graduate. So the last two weeks of school I was looking on Craigslist, because I was like, "Craigslist is how everyone gets a job." I'm a first generation American student, so my parents could not help me at all with like, "You should look into this company called McKinsey," or, "Here are all of the life paths that you have ahead of you." So I ended up taking an investment banking research job.

**中文翻译:**
是的，我的路径确实是非标准的。虽然我在湾区的圣何塞长大，在我大学毕业前后，像 Lyft 这样的公司正在兴起。但当时我满脑子想的都是如何尽快大学毕业，因为学校太无聊了。所以我选了政治学专业。我不是数学或计算机科学专业的。我甚至不知道顾问（consultant）是做什么的，因为我只想赶紧离开学校。我没意识到大家在毕业前就开始找工作了。所以在学校的最后两周，我在 Craigslist 上找工作，因为我觉得“大家都是通过 Craigslist 找工作的”。我是第一代美国大学生，所以我父母完全没法帮我，比如建议我“你应该去看看麦肯锡”或者“你面前有哪些职业道路”。所以我最终做了一份投资银行研究的工作。

---

### [00:05:46] Crystal Widjaja

**English:**
And my job there was to figure out how to call startups and analyze their potential for VC financing or M&A advisory. And I barely knew what those words meant at the time. I ended up owning a huge Excel database of 130,000 rows, 60 plus columns. And because again, I am very impatient, I was like, "This is a terrible experience. How would I create a customer database?" And so I ended up Google fooling all of the work needed to build a MySQL database, I presented a plan, and investment banking, surprise, surprise, is not very tech forward. So they looked at my plans and they're like, "What is this MySQL thing? Isn't that super expensive? What is open source?" So I ended up leaving that job because I realized that if I wanted to get into something more tech, it would probably not be at a investment bank. So I did took the investment banking strategies that I had learned there and applied the same pattern matching to companies in Southeast Asia.

**中文翻译:**
我当时的工作是给初创公司打电话，分析他们进行风险投资（VC）融资或并购（M&A）咨询的潜力。当时我几乎不懂这些词是什么意思。我最后管理着一个巨大的 Excel 数据库，有 13 万行和 60 多列。因为我很没耐心，我觉得“这体验太糟糕了，我该怎么创建一个客户数据库呢？”于是我通过 Google 自学了构建 MySQL 数据库所需的所有工作，并提交了一个方案。结果不出所料，投资银行业在技术上非常落后。他们看着我的方案问：“这个 MySQL 是什么东西？是不是超级贵？什么是开源？”于是我辞职了，因为我意识到如果我想进入科技领域，投行肯定不是久留之地。所以我利用在投行学到的策略，对东南亚的公司进行了同样的模式匹配分析。

---

### [00:06:55] Crystal Widjaja

**English:**
So my family originally is from Indonesia. I thought I have a kind of safety net, I must speak Indonesian really well just by birth, so maybe that's a great country for me to look at. So I took the approach of let's find a company that makes a lot of sense, that I feel I resonate with. And I literally cold called emails some companies. So Gojek being on that list. I literally emailed someone after Googling HR at Gojek and said, "I'm willing to move to Indonesia, take a bet on me." And they actually did. So I got extremely lucky. Five years fly by insanely fast. I went through building out the data team from scratch. When you have all of the data, you know how much fraud you have in the system. So then I ended up building out the fraud and risk team, picked up performance marketing, and then it was like, okay, now we're ready to grow. So you have all of this data now take on growth.

**中文翻译:**
我的家人原本来自印度尼西亚。我想我有一个“安全网”，我天生印尼语应该说得很好，所以也许那是一个值得关注的好地方。我采取的方法是：找一家逻辑通顺、让我有共鸣的公司。我真的给一些公司发了冷启动邮件（cold emails）。Gojek 就在那个名单上。我在 Google 上搜了“Gojek HR”，然后直接发邮件说：“我愿意搬到印尼，请在我身上赌一把。”他们居然真的答应了。所以我非常幸运。五年的时间飞逝而过。我经历了从零开始组建数据团队的过程。当你拥有了所有数据，你就会知道系统中有多少欺诈行为。于是我接着组建了反欺诈和风险团队，接手了效果营销（performance marketing），然后大家觉得，好吧，现在我们准备好增长了。既然你掌握了所有数据，那就接手增长工作吧。

---

### [00:07:55] Lenny

**English:**
Got it. You were very modest about Gojek and the success of that company, and also Kumu where you work now. So just to set a little context for folks that aren't familiar with these companies, can you share how big they are and how big of a deal they are in Southeast Asia?

**中文翻译:**
明白了。你对 Gojek 的成功以及你现在工作的 Kumu 都表现得很谦虚。为了给那些不熟悉这些公司的听众提供一些背景，你能分享一下它们的规模以及它们在东南亚的影响力吗？

---

### [00:08:11] Crystal Widjaja

**English:**
Yeah. They are pretty massive. So Gojek is now called GoTo, they just merged with the largest eCommerce platform in Indonesia. So across Southeast Asia, we had about 170 million users. Southeast Asia has scale. If you ever wanted to work at scale, you would go to Southeast Asia. We had 20 plus different services from transportation to food, shopping, medicine delivery, bill pay, movie tickets. So it was like all of the startups in America in one app, all being built at the same time with the same user base. And so everything was tremendously layered, because you could fill all of these opportunity gaps in the market where a single app would probably not be as sustainable.

**中文翻译:**
是的，它们规模非常庞大。Gojek 现在叫 GoTo，它们刚刚与印尼最大的电子商务平台合并。在整个东南亚，我们拥有约 1.7 亿用户。东南亚拥有巨大的规模效应。如果你想体验大规模业务，就去东南亚。我们提供 20 多种不同的服务，从交通到餐饮、购物、药品配送、账单支付、电影票。这就像是把美国所有的初创公司都塞进了一个应用里，针对同一批用户群同时构建。因此，一切都是高度分层的，因为你可以填补市场中所有的机会空白，而在那里，单一功能的 App 可能没那么容易生存。

---

### [00:09:00] Crystal Widjaja

**English:**
So Gojek is massive across Indonesia, Singapore, Thailand, Vietnam. And then Kumu is kind of a super app for social. So Gojek was very transactional. It was like, "Here's a job to be done. I want to pay for something and someone delivers it to me." And with Kumu, it's more so of a, "I want to do clubhouse, Zoom, Google Hangouts gather around all in one app." So we cover social feeds, audio, video, multi seats. There's a ton of different use cases that we serve on Kumu. And Kumu is primarily in the Philippines, but ranks top 10 and a bunch of countries as a top grossing mobile app.

**中文翻译:**
Gojek 在印尼、新加坡、泰国、越南都非常庞大。而 Kumu 则有点像社交领域的超级应用。Gojek 非常偏向交易型，就像是“我有一个任务要完成，我付钱，然后有人帮我送到”。而 Kumu 更多是“我想在一个 App 里同时拥有 Clubhouse、Zoom、Google Hangouts 的功能”。所以我们涵盖了社交动态、音频、视频、多席位互动。我们在 Kumu 上服务于大量不同的用例。Kumu 主要在菲律宾，但在许多国家都是收入排名前十的移动应用。

---

### [00:09:40] Lenny

**English:**
So with Kumu you joined when they're already doing fairly well. But Gojek, as you said, you joined very early. What did you see in that company that helped you decide to join such a risky, early stage company? For folks that are maybe thinking about joining a startup, what kind of things did you take away of what to look for?

**中文翻译:**
你加入 Kumu 时他们已经发展得相当不错了。但正如你所说，你加入 Gojek 时非常早。你在那家公司看到了什么，让你决定加入这样一家风险巨大的初创公司？对于那些可能正在考虑加入初创公司的人来说，你认为应该寻找什么样的特质？

---

### [00:09:58] Crystal Widjaja

**English:**
Honestly, it's probably a lot of luck. But also at that age I realized I have very little to lose. So with Gojek I think I felt like it was the right company because I was able to really clearly understand the value prop. Traffic in Indonesia is crazy. It takes you two hours to go 20 kilometers. So of course you want to take a motorcycle taxi to beat that traffic. Of course, you don't want to go out and get food and then have to come back this long pathway of two hours. So I think taking that Warren Buffet approach, I knew that the product made sense. The market made sense as well. So drivers, there were already a thing, but it was very hard to connect them to the consumer.

**中文翻译:**
老实说，很大程度上是运气。但同时在那个年纪，我意识到我没什么可失去的。对于 Gojek，我觉得它是对的公司，因为我能非常清晰地理解它的价值主张（value prop）。印尼的交通非常疯狂，走 20 公里要花两个小时。所以你当然想坐摩托出租车来避开拥堵。你当然不想出门买个饭再花两个小时回来。所以采用沃伦·巴菲特的那种分析方法，我知道这个产品是合理的，市场也是合理的。当时已经有司机这个群体了，但很难将他们与消费者连接起来。

---

### [00:10:42] Crystal Widjaja

**English:**
It was painful to haggle prices. There were lots of restaurants scattered across Indonesia. So the value prop and the market made sense and the channel by which you would do it through this mobile app made a little bit less sense at the time because most drivers didn't have a mobile app, but I felt like it was a problem that was very solvable. And we ended up renting a stadium to just hire 60,000 drivers in a couple of weeks. So I think looking back, it was certainly a risk when I got there, it was in a house and I realized I've probably made a huge mistake. But we were growing very quickly already, even at that small scale of 4,000 orders per day.

**中文翻译:**
当时讨价还价很痛苦，印尼各地散布着大量的餐馆。所以价值主张和市场都是合理的，虽然当时通过移动应用这个渠道看起来不太合理（因为大多数司机没有智能手机），但我觉得这是一个非常可解的问题。我们最终租下了一个体育场，在几周内雇佣了 6 万名司机。回想起来，这确实是一次冒险。当我刚到公司时，它还在一间民宅里，我当时想我可能犯了个大错。但即便在每天只有 4000 单的小规模下，我们已经在飞速增长了。

---

### [00:11:26] Lenny

**English:**
I want to spend a lot of time talking about what you learned, driving growth at these companies. But one quick question. So, Gojek's the super app where you do a lot of stuff in one app. Do you have any insights into why a super app hasn't emerged in the US?

**中文翻译:**
我想花很多时间聊聊你在这些公司推动增长的经验。但先问一个简短的问题：Gojek 是一个可以在一个 App 里做很多事情的超级应用。你对于为什么美国还没有出现超级应用有什么见解吗？

---

### [00:11:40] Crystal Widjaja

**English:**
Yeah. I think the sentimentality of a conglomerate is very different in Southeast Asia. So we've grown up with a specific conglomerate owning, not just the mall that you go to, but also the apartment building that you live in, and the school that you go to. And so they're very well integrated and there's this sense of trust in a conglomerate. Whereas in America we already shy away from, does Google know too much about me? There's also, I think, the second aspect of it, which is that in Asia, we've kind of leapfrogged to the computer era. So everyone has a phone, but you may not even have a computer in the entire household. And so when your phone is full, are you going to delete a photo of your kid or are you going to delete this app? You're probably going to delete the app. So for anyone to really survive, it has to be part of this super app concept.

**中文翻译:**
是的。我认为东南亚对“大财团/综合企业”（conglomerate）的情感非常不同。我们从小到大习惯了某个特定的财团不仅拥有你去逛的商场，还拥有你住的公寓楼和你上的学校。所以它们整合得非常好，人们对大财团有一种信任感。而在美国，人们会回避这种事，比如担心“Google 是不是对我了解太多了？”。我认为还有第二个方面，那就是在亚洲，我们某种程度上是直接跨越到了移动互联网时代。每个人都有手机，但整个家庭可能连一台电脑都没有。所以当你的手机内存满了，你是会删掉孩子的照片，还是删掉这个 App？你很可能会删掉 App。所以为了生存，应用必须成为这种超级应用概念的一部分。

---

### [00:12:34] Lenny

**English:**
Oh wow. I've never thought of it that way. That you don't have a lot of space on your phone and so you want one app to do a lot of things.

**中文翻译:**
噢哇。我从未从这个角度想过。因为手机空间有限，所以你希望一个 App 能做很多事。

---

### [00:12:40] Lenny

**English:**
That's right. So there's a decision factor that you don't really have in the US because the cloud storage and device capacity there is a little bit bigger.

**中文翻译:**
没错。所以这是一种在美国不太存在的决策因素，因为美国的云存储和设备容量通常更大一些。

---

### [00:12:50] Lenny

**English:**
Interesting. So in the US you can have different apps to be... Basically a super app doesn't have to be the best at everything. The fact that it does enough and everything good enough. Wow, it's fascinating.

**中文翻译:**
有趣。所以在应用中你可以拥有不同的 App 来……基本上，超级应用不需要在每件事上都做到最好。只要它能做足够多的事，且每件事都做得足够好就行。哇，这太迷人了。

---

### [00:12:59] Crystal Widjaja

**English:**
You just need to get the job done.

**中文翻译:**
你只需要能把活儿干了就行。

---

### [00:13:02] Lenny

**English:**
Amazing. Okay. That's super interesting. Okay. So transitioning a bit to growth and things you've learned along the way. So you talked about how, I think Gojek, you said hired tens of thousands of drivers really quickly. Are there things that startups in Asia do that you think companies in the US should do and can learn from in terms of growth?

**中文翻译:**
太棒了。这超级有趣。好，现在转到增长话题以及你一路走来学到的东西。你提到 Gojek 很快就雇佣了数万名司机。你认为亚洲初创公司做的哪些事情是美国公司应该做且可以借鉴的增长经验？

---

### [00:13:22] Crystal Widjaja

**English:**
Yeah, so we did crazy things. If someone told you, in the US, that they were going to rent out a stadium, pre-load a bunch of mobile devices, market that drivers should come here in mass for a job fair. They're going to give them a phone and send them on their way, some people would say, "No. That's crazy. Won't we get in trouble." And to an extent, maybe that's true. So maybe there are some limitations there, but this concept of doing things that are somewhat crazy, but validate a point, doing stuff that don't scale, especially I think is really the bread and butter of what we did at Gojek. We were insanely scrappy.

**中文翻译:**
是的，我们做过一些疯狂的事。如果在美国有人告诉你，他们要租下一个体育场，预装一堆移动设备，宣传让司机们大规模来参加招聘会，然后发给他们手机就让他们上路，有些人会说：“不，这太疯狂了，我们会惹麻烦的。”在某种程度上，这可能是真的。所以可能存在一些限制，但这种做一些看似疯狂但能验证观点的事情，尤其是“做那些无法规模化（don't scale）的事”，我认为这正是我们在 Gojek 成功的核心。我们当时极其地“接地气”且不拘一格（scrappy）。

---

### [00:14:02] Crystal Widjaja

**English:**
We would do things as simple as wanting to test a subscription feature, which was just released in Singapore a couple weeks ago. We ended up saying, "We have this voucher system that we can distribute vouchers in the back end. We obviously know our driver's phone numbers. Why don't we just add them to a WhatsApp group?" We'll add a hundred drivers randomly to a WhatsApp group. We'll tell them, "Every time you are on a ride with a customer, try to sell them this pitch. You are the only driver who can sell a subscription package. Have the customer give you $10. Text us when they say yes. Someone will be sitting by this phone all day, every day.

**中文翻译:**
我们会做一些很简单的事情，比如想测试订阅功能（这个功能几周前刚在新加坡发布）。我们当时想：“我们有一个可以在后台发放代金券的系统，我们也知道司机的电话号码。为什么不直接把他们拉进一个 WhatsApp 群组呢？”我们随机把 100 名司机拉进群，告诉他们：“每次你载客时，试着跟他们推销：你是唯一能卖订阅包的司机。让客户给你 10 美元现金。如果他们答应了，就发短信告诉我们。我们会有人整天守在电话旁。”

---

### [00:14:46] Crystal Widjaja

**English:**
We'll look up the customer that you were on a ride with in the backend, we'll give them the vouchers in the back end, and then we'll deduct $10 from your balance." It works. It's really this Wizard of Oz experience. We don't have to build anything. I coordinated with a bunch of interns and we were able to validate some of the value prop and conversion rates that we would expect in a subscription service. When we wanted to do a new onboarding screen, but turns out we have lots of engineering work to do, we took a screenshot of the screen as is, and we just had our designer put what the onboarding flow might look like if we had to overlay it on top of the screen.

**中文翻译:**
“我们会在后台查找到你正在载的那个客户，把代金券发给他们，然后从你的余额里扣掉 10 美元。”这行得通。这真的是一种“绿野仙踪”（Wizard of Oz）式的体验（注：指前端看起来是自动的，后台其实是人工操作）。我们不需要开发任何东西。我协调了一群实习生，我们就这样验证了订阅服务预期的价值主张和转化率。当我们想做一个新的引导页面，但发现工程量很大时，我们就截了一张现有页面的图，让设计师把引导流程覆盖在上面。

---

### [00:15:27] Crystal Widjaja

**English:**
And we just sent that as an in-app message. And then eventually I think finding stuff that does scale intuitively. We knew that we were sending out lots of fake features through things like Typeform surveys. Things like a personality quiz can be very easily done through Typeform. And we realized that if we built in the in-app webpage and we made it easier for us to do a website deployment on our backend side, we wouldn't have to wait for a mobile app release to test some of these new features out that could be done on web. So it's really just like, what is the user experience that we want to create? How do we manifest that as quickly as possible? Let's just try that first.

**中文翻译:**
我们直接把它作为应用内消息发送。最终，我们会找到那些直观上可以规模化的东西。我们知道我们通过 Typeform 调查发送了很多“假功能”。比如性格测试可以通过 Typeform 轻松完成。我们意识到，如果我们构建一个应用内网页，并让后台部署网页变得更容易，我们就不用为了测试一些可以在 Web 上实现的新功能而等待 App 发布新版本。所以这其实就是：我们想创造什么样的用户体验？我们如何以最快的方式呈现它？先试了再说。

---

### [00:16:13] Lenny

**English:**
Going back to the stadium example. I know you said that you hired a stadium full of people, I didn't realize it was actually a stadium that you-

**中文翻译:**
回到体育场的例子。我知道你说过雇了一体育场的人，但我没意识到那是你们真的租了一个……

---

### [00:16:19] Crystal Widjaja

**English:**
That it was literally a stadium that we rented, like a football field, a couple football fields if I'm not wrong. It was long lines, boxes of phones and SIM cards. So it was a lot of just doing really hard work to get to that scale.

**中文翻译:**
那是我们实实在在租下来的体育场，像是一个足球场，如果我没记错的话是好几个足球场。现场排着长队，到处是一箱箱的手机和 SIM 卡。为了达到那个规模，真的做了很多艰苦的工作。

---

### [00:16:35] Lenny

**English:**
Wow. I know you do a lot of advising too. Do you advise startups to be more scrappy and do things that don't scale? I imagine because in the US the culture is a little different.

**中文翻译:**
哇。我知道你也做很多咨询工作。你会建议初创公司更“接地气”一点，去做那些无法规模化的事吗？我猜美国的文化可能有点不同。

---

### [00:16:45] Crystal Widjaja

**English:**
The only thing better than knowing... If you have data of what your customers are doing, that is the best data you could ever get. And so if you don't have a tested hypothesis, if you can't think of a way to run an experiment, then honestly that idea is pretty useless. Maybe it makes sense to the market, to the model, but you could have weird consumer sentiments. Not everyone is a rational actor. Testing the actual experience and seeing how people respond to it, that's the best possible data.

**中文翻译:**
唯一比“知道”更好的事情是……如果你有关于客户正在做什么的数据，那是你能得到的最好的数据。所以如果你没有经过验证的假设，如果你想不出运行实验的方法，那么坦白说，那个想法就没什么用。也许它在市场或模型上讲得通，但消费者的情绪可能很奇怪。并非每个人都是理性人。测试真实的体验并观察人们的反应，这才是最好的数据。

---

### [00:17:21] Lenny

**English:**
Pulling that thread a little bit, for startups, experiments are often hard because there's just not enough data and enough users. How do you think startups should approach that? Can you run experiments when you're really, really early?

**中文翻译:**
顺着这个话题，对于初创公司来说，实验通常很难，因为没有足够的数据和用户。你认为初创公司应该如何应对？在非常早期的时候可以运行实验吗？

---

### [00:17:32] Crystal Widjaja

**English:**
You should. Even if you have a sample size of 30, the data you get back, generally, does not change but its precision will. So mathematically speaking, you're going to get the same level of trends, but the precision at which you understand those trends will become more deep if you have more data. But the underlying information that you're getting out of that won't be very different at larger scales. So what's better than having 30 data points? Certainly having 100. But what's better than having zero is definitely 30.

**中文翻译:**
你应该做。即使样本量只有 30，你得到的数据趋势通常不会改变，改变的只是精度。从数学上讲，你会得到相同水平的趋势，但如果你有更多数据，你对这些趋势的理解精度会更高。但在更大规模下，你从中获得的基础信息不会有太大差异。所以，什么比 30 个数据点更好？当然是 100 个。但什么比 0 更好？绝对是 30 个。

---

### [00:18:10] Lenny

**English:**
Fascinating. So contrarian. Running experiments at 30 people. I love that.

**中文翻译:**
太迷人了。这很反直觉。在 30 个人身上做实验，我喜欢这个观点。

---

### [00:18:14] Crystal Widjaja

**English:**
You have to. Every idea is so cheap at that scale. You could do things that don't scale dramatically better with 30 people than at 100 if you're testing.

**中文翻译:**
你必须这么做。在那个规模下，每个想法的成本都很低。在 30 个人的规模下，你做那些“无法规模化”的测试效果要比 100 个人时好得多。

---

### [00:18:29] Lenny

**English:**
Just to pull on that a little bit, when you're running an experiment with 30 people, what do you look for? You're looking for 20 of them to do something, a large percentage of that group does something?

**中文翻译:**
再深入一点，当你对 30 个人做实验时，你观察什么？你是看其中是否有 20 个人做了某事，或者看很大比例的人是否做了某事？

---

### [00:18:39] Crystal Widjaja

**English:**
So everyone wants to go on retention. They want to see that users are doing this thing, and they want to get from step zero to 100 really quickly, but they don't realize that users make decisions based on succeeding events. So what's one step before the user makes that decision? What are the things that they have to do, the things that have to be done? So we're always looking for what is a specific reason that this user might have converted? For things like GoFood it would be things like when does a user try a new merchant if what people are ordering right now or just food that they already trust and know. If you need to have trust in order to purchase food from a merchant, how do we generate that trust? So we actually hacked it by connecting people's Facebook connect login.

**中文翻译:**
大家都盯着留存率。他们想看到用户在做某件事，想快速从 0 走到 100，但他们没意识到用户是基于后续事件做决定的。那么，在用户做决定之前的那一步是什么？他们必须做什么？我们一直在寻找：这个用户转化的具体原因是什么？以 GoFood 为例，如果人们现在只点他们信任和熟悉的食物，那么用户什么时候会尝试新商家？如果你需要信任才能从商家那里买吃的，我们如何产生这种信任？所以我们通过连接用户的 Facebook 登录信息做了一个“黑客式”的尝试。

---

### [00:19:33] Crystal Widjaja

**English:**
So we had already had permission to look at who they had connected with on Facebook. We actually looked at the food that their friends had purchased and used that as a data set of, "Hey, here's food that Lenny purchased and liked. Maybe you would like it too." And so that was one way to hack the trust factor. And we did find that when we told people, "This friend purchased from this merchant," you would be twice as likely to purchase from a brand new restaurant then users who did not have this feature. And that increases GMV, that eventually gets you to the conversion rate that you wanted, but it solved a different problem. Before how do I convert, it was how do I solve for trust? How do I break the barrier of facilitating that decision making process, that aha moment, by fixing the setup moment, which was trust?

**中文翻译:**
我们已经获得了查看他们 Facebook 好友的权限。我们查看了他们朋友买过的食物，并以此作为数据集：“嘿，这是 Lenny 买过且喜欢的食物，也许你也会喜欢。”这是破解信任因素的一种方法。我们发现，当我们告诉用户“这位朋友从这个商家买过”时，他们购买新餐厅食物的可能性是不使用该功能的用户的两倍。这增加了 GMV，最终让你达到了想要的转化率，但它解决的是另一个问题。在考虑“如何转化”之前，先考虑“如何解决信任”。我如何通过修复“信任”这个前置环节，来打破决策过程中的障碍，从而实现那个“顿悟时刻”？

---

### [00:20:31] Lenny

**English:**
And that's just a general rule of thumb you have. Don't use retention as a goal. I know you wrote about this somewhere. Is that a rough rule of thumb you use?

**中文翻译:**
这是你的一条通用法则吗？不要把留存作为目标。我知道你在哪里写过这个。这是你常用的一条经验法则吗？

---

### [00:20:41] Crystal Widjaja

**English:**
I think a lot of people thought that I had meant retention sucks, don't care about it at all. But in reality it was really when you think about retention, that's just not specific enough. So there is this mental model that I use from made to stick where they'll tell you like, "Lenny, think of everything in the world that is orange." And you're like, "An orange. What else?" And then if you change that structure with sandbox to think of everything orange that's in a construction site, then you really start to realize and grasp at concrete concepts, and can actually action on them in real life.

**中文翻译:**
我想很多人误以为我的意思是“留存很烂，完全不用管”。但实际上，我的意思是当你思考留存时，它不够具体。我使用《粘性》（Made to Stick）里的一种心智模型：如果我对你说“Lenny，想想世界上所有橙色的东西”，你会想到“橙子，还有呢？”但如果你把范围缩小到“想想建筑工地上所有橙色的东西”，你就能立刻想到具体的概念，并能在现实生活中采取行动。

---

### [00:21:32] Lenny

**English:**
Got it. Speaking of retention, where have you found products and companies have the most success increasing retention?

**中文翻译:**
明白了。说到留存，你发现产品和公司在哪些方面最能成功地提高留存？

---

### [00:21:32] Crystal Widjaja

**English:**
It's usually the step right before conversion. So if they aren't sure why the user opens the app or they aren't sure why the user got to this checkout page, it's often some copy or the path has been ineffective in some way. I'd like to see founders think about the user psych model that Darius Contractor often talks about. So you need some momentum in that user journey to get them over the hump of some of these very painful user processes like typing in a credit card. That's a lot of work. How do you lower that friction? And being able to sequence the right steps effectively and just moving around screens actually can do a lot.

**中文翻译:**
通常是转化前的最后一步。如果他们不确定用户为什么打开 App，或者不确定用户为什么进入结算页面，通常是因为文案或者路径在某些方面失效了。我希望创始人能思考 Darius Contractor 经常提到的“用户心理模型”。在用户旅程中，你需要一些动力来帮助他们跨过那些痛苦的过程，比如输入信用卡信息。那很麻烦。你如何降低这种摩擦？能够有效地排列步骤顺序，甚至只是调整一下屏幕显示的先后，其实就能起到很大作用。

---

### [00:22:44] Lenny

**English:**
Going even deeper there. So the companies you've worked at, the companies you've advised, you're on the boards of a couple companies I noticed, what have you found to be really good uses of time in terms of growth investments, things that often work? And then a second question, what do you find is rarely successful or people invest a lot of time and ends up not being really useful for growth?

**中文翻译:**
再深入一点。在你工作过、咨询过以及担任董事的公司中，你发现哪些增长投资是非常值得花时间的，也就是经常奏效的？第二个问题是，你发现哪些事情很少成功，或者人们投入了大量时间却对增长没什么用？

---

### [00:22:44] Crystal Widjaja

**English:**
Yeah. I think I see a lot of founders grasping at straws. So there'll be this brand new feature that does something different from what people are already doing on our app, like this will make things work. But they don't have any Wizard of Oz test, they haven't proven that people want to do that, they don't have any data of users currently trying to do that. And that's a sign of why this, instead of literally anything else that you could be doing. I do find if you have a lot of people landing on a webpage or an app and then not doing anything, then it's probably copy.

**中文翻译:**
是的。我看到很多创始人在“病急乱投医”。他们会做一个全新的功能，做一些与用户目前在 App 上所做的完全不同的事情，觉得“这肯定行”。但他们没有做过任何“绿野仙踪”测试，没有证明人们想做那件事，也没有任何数据表明用户目前正尝试做那件事。这就是一个信号：为什么要在这个功能上浪费时间，而不是做其他任何事？我确实发现，如果很多人访问了网页或 App 却什么都不做，那很可能是文案的问题。

---

### [00:23:25] Crystal Widjaja

**English:**
They haven't even experienced the product, it's clearly not the product that's wrong. So how can you change the copy and resonate with the pain point rather than the solution you are offering so that users understand how to fit themselves into the use case? So copy is a big one if I see conversion rates aren't landing between app launch to some first action. But if there is conversion and they're just not as frequent, I try to look at what the most painfully long conversion events are. So users who eventually check out or eventually completed the aha moment, what are the user paths, and what is the longest one that seems like it's the most painful? Are there enough people trying to do that?

**中文翻译:**
他们甚至还没体验产品，所以显然不是产品本身的问题。那么，你如何修改文案，使其与痛点产生共鸣，而不是只推销你提供的解决方案，从而让用户明白自己如何代入这个用例？所以，如果我看到从 App 启动到第一个动作之间的转化率很低，文案就是一个大问题。但如果有转化，只是频率不高，我会试着寻找那些最痛苦、最漫长的转化事件。对于那些最终结账或完成“顿悟时刻”的用户，他们的路径是什么？哪条路径最长、看起来最痛苦？是否有足够多的人在尝试走那条路？

---

### [00:24:13] Crystal Widjaja

**English:**
And how do we shorten that cycle? So for Kumu things like users wanted to sign up and find their friends on Kumu. And so they were using search frequently, search was underutilized API, it was slow. We sped that up. Conversion rates go from 60% to 90% over the course of a few weeks of just optimizing that and putting more content there. So looking at where are people doing things and then failing, you already know this percent of people would convert if you fixed this, that's a definite potential win. So we try to layer these definite wins with crazy bets of brand new feature with no data. At least run an experiment if you can. But I always try to layer in these sure wins.

**中文翻译:**
我们如何缩短那个周期？以 Kumu 为例，用户想注册并在 Kumu 上找到朋友。他们频繁使用搜索，但搜索 API 没被充分利用，速度很慢。我们提高了速度。仅仅通过优化搜索并放入更多内容，转化率在几周内就从 60% 提高到了 90%。所以，观察人们在哪里操作然后失败了，你就能预判：如果修复了这里，这部分人就会转化。这是一个确定的潜在胜利。所以我们尝试将这些“确定的胜利”与那些没有数据的“疯狂赌注”（新功能）结合起来。如果可以的话，至少跑个实验。但我总是试着加入这些稳赢的策略。

---

### [00:25:01] Lenny

**English:**
When you talk about conversion being good and bad, do you have a rule of thumb or of a mental model of here's a rough range of this is good and we should not really spend a lot of time on this and this is bad and we should optimize?

**中文翻译:**
当你谈到转化率的好坏时，你有没有什么经验法则或心智模型？比如一个粗略的范围：这个数值算好，我们不该花太多时间；那个数值算差，我们需要优化？

---

### [00:25:14] Crystal Widjaja

**English:**
So assuming that the frequency is correct, so you have a weekly frequency, if users are coming back, if it's a free product, 60%. It has to be at least 60%. If it's a free product, we go over a week. If it's a paid product, I usually look at that more as maybe 20 to 30%.

**中文翻译:**
假设频率是正确的，比如是周频。如果用户会回来，对于免费产品，留存率应该是 60%。至少要达到 60%。如果是免费产品，我们看周留存。如果是付费产品，我通常认为 20% 到 30% 左右。

---

### [00:25:32] Lenny

**English:**
And this is retention, people coming back the next week?

**中文翻译:**
这是指留存率，即下周回来的用户比例？

---

### [00:25:34] Crystal Widjaja

**English:**
Exactly. Coming back in the second week or month or whenever your frequency ratio is. And this is at scale. So if you are much smaller, your friends and family that better be near close to 80% no matter what, because if you can't even convince the people who care about you to use the product, it probably isn't going to solve the job for anyone else.

**中文翻译:**
没错。在第二周、第二个月或者任何符合你产品频率的周期回来。这是在大规模情况下的标准。如果你规模还很小，你的朋友和家人的留存率最好接近 80%，因为如果你连关心你的人都说服不了去使用产品，它可能也解决不了其他人的问题。

---

### [00:25:56] Lenny

**English:**
Very handy. Very concrete numbers. And then your point is that when you're a startup, it's only going to go down because your early adopters that are more excited and they'll be more excited by coming back. So you want to start really high.

**中文翻译:**
非常实用，非常具体的数字。你的观点是，当你还是初创公司时，这个数字只会往下掉，因为早期采用者通常更兴奋，更愿意回来。所以你得从一个非常高的起点开始。

---

### [00:26:10] Crystal Widjaja

**English:**
Don't make the same mistake that Netflix and Spotify have made, which I guess is when they've launched, they've started international expansion and they see this very small percentage of users start to sign up for Spotify or Netflix. There are very few people though in Southeast Asia or internationally that have the types of credit cards that Spotify or Netflix would accept. And so when they launch in these markets and they see a ton of uptick in the first week, they're like, "This is only going to get better." When in reality it's like you just pulled forward everyone who could have possibly subscribed to you, now you're going to have to work a lot harder to get everyone else.

**中文翻译:**
不要犯 Netflix 和 Spotify 犯过的错误。我想是在他们刚开始国际扩张时，看到只有很小比例的用户开始注册。但在东南亚或国际市场上，拥有 Spotify 或 Netflix 接受的那种信用卡的人非常少。所以当他们在这些市场推出，看到第一周有大量增长时，他们会觉得“情况只会越来越好”。但现实是，你只是提前收割了所有可能订阅你的人，接下来你得花更大的力气去争取其他人。

---

### [00:26:47] Lenny

**English:**
The 60% number. So you're saying it's then every week, 60% of the previous week come back, roughly. Is it just a rule of thumb?

**中文翻译:**
关于 60% 这个数字。你是说每周大约有上周 60% 的人回来？这只是个经验法则吗？

---

### [00:26:54] Crystal Widjaja

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:26:55] Lenny

**English:**
Is that how you think about it versus say cohort retention? Is that just because it's easier is just a simple rule of thumb?

**中文翻译:**
你是这样思考的吗？而不是看同类群组留存（cohort retention）？是因为这样更简单，只是个简单的经验法则吗？

---

### [00:27:01] Crystal Widjaja

**English:**
Am actually thinking of it as cohorts. So 60% should be your week one, and then it should flatten. I think I usually give teams two to three weeks or frequency periods to see things flatten, but it better flatten around 60% for a free product. That's actually what we saw at Gojek. Early days it was like 60, 70% retention rates because people were using this product that really solved a huge problem for them. And I think that's when I knew we were going to be fine. If people keep coming back, the product just needs to work.

**中文翻译:**
我其实是把它看作同类群组。第一周留存应该是 60%，然后趋于平缓。我通常给团队两到三周或几个频率周期来观察数据是否平稳，但对于免费产品，最好平稳在 60% 左右。这正是我们在 Gojek 看到的。早期留存率在 60% 到 70% 之间，因为人们使用的这个产品确实解决了他们的巨大痛点。我想那是我就知道我们会成功的。如果人们一直回来，产品只要能正常运行就行。

---

### [00:27:36] Lenny

**English:**
Wow. So week one, 40% of people drop off week two and beyond basically nobody drops off is what you look for.

**中文翻译:**
哇。所以第一周有 40% 的人流失，从第二周开始基本上没人流失，这就是你追求的目标。

---

### [00:27:42] Crystal Widjaja

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:27:43] Lenny

**English:**
Wow. What a high bar. But I like that, because-

**中文翻译:**
哇，门槛真高。但我喜欢这个，因为……

---

### [00:27:47] Crystal Widjaja

**English:**
Yeah, well Gojek is a decacorn.

**中文翻译:**
是啊，毕竟 Gojek 是个“十角兽”（估值超百亿美元的公司）。

---

### [00:27:50] Lenny

**English:**
Okay. There we go. If you want to be a decacorn, there's your new benchmark. Amazing. Okay. There's a bunch of other stuff I want to dig into. One is just data modeling and thinking about growth strategy as a founder. So say a startup is just trying to think about, how do we drive growth, where do we invest, do you have a framework or a process? I know this might be a really big question, but just for founders to think about how their growth works, what their drivers might be, how would a founder approach that problem?

**中文翻译:**
好吧，明白了。如果你想成为十角兽，这就是你的新基准。太棒了。好，还有很多其他东西我想深入探讨。一个是数据建模以及作为创始人如何思考增长策略。假设一家初创公司正在思考：我们如何推动增长？我们该投资哪里？你有没有一个框架或流程？我知道这可能是一个很大的问题，但对于创始人来说，如何思考增长的运作方式、驱动因素是什么？创始人该如何着手解决这个问题？

---

### [00:28:20] Crystal Widjaja

**English:**
For sure. So I thought that this was not an obvious process. It wasn't an explicit process until I worked with Reforge to build my data four PMs program. Got to get that plug there.

**中文翻译:**
当然。我以前觉得这不是一个显而易见的流程。直到我和 Reforge 合作开发了“面向产品经理的数据”课程，它才变成一个明确的流程。顺便打个广告。

---

### [00:28:34] Lenny

**English:**
Go Reforge.

**中文翻译:**
Reforge 加油。

---

### [00:28:35] Crystal Widjaja

**English:**
I basically talked with the Reforge folks about here's what I would do in all of these scenarios. And they're like, "Oh, so you mean you're doing this step one, step two?" And I was like, "Yes, actually. How did you figure that out?" So I don't really think in-frame works, this is just a logical process to me. But I think what I've figured out is, it's step one, you have constraints. Similar to our sandbox example of everything in the world that's orange versus everything in a construction site, you have to think about the physics of the current market, the product, the model and the channels that you're using. So to use Gojek as an example, it would be market of Indonesia.

**中文翻译:**
我基本上是和 Reforge 的人聊了聊我在各种场景下会怎么做。他们说：“噢，所以你的意思是你在做第一步、第二步？”我说：“是的，确实。你们是怎么发现的？”所以我并不真的在“框架”里思考，这对我来说只是一个逻辑过程。但我总结出来的是：第一步，明确约束条件。就像我们之前说的沙盒例子（世界上所有橙色的东西 vs 建筑工地上橙色的东西），你必须考虑当前市场、产品、模型和所用渠道的“物理定律”。以 Gojek 为例，那就是印尼市场。

---

### [00:29:16] Crystal Widjaja

**English:**
Here are the consumers in this market, the driver's side supply side in this market. Here is the product, mobile app. We're able to connect drivers and consumers. There is a allocation that we create model. We charge per order, channel. We are able to do this through push notifications or in acquiring new users. It might be through Facebook ads, or, and this was a really big insight for us, it's the real world. There was a physical conception of a driver in a jacket driving around the city who was marketing Gojek for us. And word of mouth actually was primarily driven by, "I saw a driver on the street, so I knew Gojek was here."

**中文翻译:**
这个市场的消费者是怎样的，司机供应端是怎样的。产品是移动 App，我们能连接司机和消费者。我们创建了一个分配模型。我们按订单收费。渠道方面，我们可以通过推送通知或获取新用户。可能是通过 Facebook 广告，或者——这对我们来说是一个巨大的洞察——现实世界。穿着夹克在城市里穿梭的司机本身就是 Gojek 的移动广告。口碑传播其实主要是由“我在街上看到了司机，所以我知道 Gojek 在这里”驱动的。

---

### [00:29:58] Crystal Widjaja

**English:**
And that actually was a huge driver of all of Gojek's growth as it expanded to new cities. So step one is, what are the physics? Step two is when you think about loops and growth funnels and the quantitative inputs to each loop, does that fit into these physics or do you have to change four or five different things? So we were very careful about changing too many parameters and making too many bets on too many variables going our way. So we would always change one small thing at a time and make sure that it fit into the model.

**中文翻译:**
这实际上是 Gojek 扩张到新城市时所有增长的巨大驱动力。所以第一步是：物理定律是什么？第二步是：当你思考循环（loops）、增长漏斗以及每个循环的量化输入时，它们是否符合这些物理定律？还是说你必须改变四五个不同的环节？我们非常小心，不轻易改变太多参数，也不在太多变量上押注。我们总是每次只改动一小点，并确保它符合模型。

---

### [00:30:38] Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like Netlify, Contentful and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern growth team stack. This leads to waste of time building internal tools or trying to run your experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved about our experimentation platform was being able to easily slice results by device, by country and by user stage.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 AB 测试平台。Netlify、Contentful 和 Cameo 等公司都依赖 Eppo 来支持他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能很好地集成到现代增长团队的技术栈中。这导致人们要么浪费时间构建内部工具，要么试图通过笨重的营销工具来运行实验。当我在 Airbnb 时，我最喜欢我们的实验平台的一点是，它能轻松地按设备、国家和用户阶段对结果进行切片分析。

---

### [00:31:16] Lenny

**English:**
Eppo does all that and more. Delivering results quickly, avoiding annoying prolonged analytics cycles and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic clickthrough metrics and instead uses our north star metrics like activation, retention, subscriptions and payments. Eppo supports test on the front end, the back end, email marketing and even machine learning clients. Check out Eppo at geteppo.com. Geteppo.com and 10 X your experiment velocity. So step one, just to cover this, is figure out how you're growing. In Gojek's case, it was partly real world, people just seeing Gojek riding around.

**中文翻译:**
Eppo 能做到这一切甚至更多。它能快速交付结果，避免烦人且漫长的分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基础的点击率指标，转而使用激活、留存、订阅和支付等北极星指标。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。访问 geteppo.com 查看 Eppo。Geteppo.com，让你的实验速度提升 10 倍。所以第一步，总结一下，就是弄清楚你是如何增长的。在 Gojek 的案例中，部分原因是现实世界，人们看到 Gojek 在街上跑。

---

### [00:31:58] Crystal Widjaja

**English:**
I think it's both figure out how you're growing and also the elements that you have at your disposal. What are the levers that you have that maybe you've never tried using? When we looked at our model this way, we actually realized we had underutilized the driver's capacity to drive our growth. Pun definitely intended. So in looking at the model this way, we had thought through what is our goal. We want GoPay to be much bigger than it really is. It's a E-wallet service, users are able to get access to this digital balance. How do we drive adoption? And so when we looked at the lever of we have a driver, we actually created an incentive model. So we built a very small service that would check when a driver got allocated to a customer, again, the product and the model, we would then check in the database, has this customer ever used our GoPay product before?

**中文翻译:**
我认为既要弄清楚你是如何增长的，也要弄清楚你手头有哪些可用的元素。你有哪些可能从未尝试过的杠杆？当我们这样审视我们的模型时，我们意识到我们低估了司机驱动（drive）我们增长的能力——这里绝对是一语双关。通过这种方式审视模型，我们思考了我们的目标：我们希望 GoPay 变得比现在大得多。它是一个电子钱包服务，用户可以获得数字余额。我们如何推动采用？当我们审视“我们拥有司机”这个杠杆时，我们创建了一个激励模型。我们构建了一个非常小的服务，当司机被分配给客户时（再次回到产品和模型），我们会检查数据库：这个客户以前用过我们的 GoPay 产品吗？

---

### [00:32:59] Crystal Widjaja

**English:**
Did they have a digital balance? And if the answer was no, we would message the driver immediately, "Hey, this customer hasn't done a GoPay top up before. If you get them to give you cash and we deposit it into their virtual wallet, we'll give you extra money." So using them as the salesperson. You wouldn't believe how great of a salesperson someone can be when you were literally trapped in a car with them going somewhere. And so you have this captive audience, captive attention, you have someone who has the incentive to cross pay or cross sell someone into GoPay. And customers were able to feel the benefit because the driver was explaining it to them directly. There was no change to the physics, it was a lever usage.

**中文翻译:**
他们有数字余额吗？如果答案是否定的，我们会立即给司机发消息：“嘿，这个客户以前没充值过 GoPay。如果你能让他们给你现金，然后我们把钱存入他们的虚拟钱包，我们就给你额外的奖励。”也就是把司机当作销售员。你无法想象，当你和某人一起被困在车里去某个地方时，那个人能成为多么出色的销售。你拥有了“被困住”的受众和注意力，还有一个有动力进行交叉销售的人。客户能感受到好处，因为司机直接向他们解释。物理定律没有改变，这只是对杠杆的使用。

---

### [00:33:49] Lenny

**English:**
What a devious strategy.

**中文翻译:**
真是个“狡猾”的策略。

---

### [00:33:49] Crystal Widjaja

**English:**
It was huge. It was 60% of acquisition once we released that.

**中文翻译:**
效果巨大。一旦我们发布了这个功能，它贡献了 60% 的获客。

---

### [00:33:55] Lenny

**English:**
Oh my God. So for thinking through your potential levers and physics of your growth, do you think about it bottoms up, here's all the things that are going on and here's areas we can invest? Or do you have a menu of options top down of here's the 10 things it could be, it's looking like for Gojek it's these four and let's focus on that?

**中文翻译:**
天哪。那么在思考潜在杠杆和增长的物理定律时，你是自下而上地思考（列出所有正在发生的事和可以投资的领域），还是自上而下地有一个选项清单（比如可能有 10 件事，对 Gojek 来说看起来是这 4 件，然后重点关注它们）？

---

### [00:34:15] Crystal Widjaja

**English:**
Yeah. I think you always have to start from the fact that we are not wizards. It's very hard to move the physics of a universe when you are trying these new things. So start with what currently works and currently exists and where you think the biggest constraint is or the best lever is, and then fix that one piece because the entire universe isn't exploding. The world isn't changing so dramatically that your physics change. So I think rooted in reality is very important.

**中文翻译:**
是的。我认为你必须从“我们不是巫师”这个事实出发。当你尝试新事物时，很难改变宇宙的物理定律。所以，从目前有效的东西和现有的东西开始，找到你认为最大的约束点或最好的杠杆，然后修复那一部分，因为整个宇宙并没有爆炸。世界并没有剧烈变化到让你的物理定律失效。所以我觉得立足现实非常重要。

---

### [00:34:50] Lenny

**English:**
Got it. Okay. So it's see what's working, find the constraints. And then step two is basically what can you do to the product to optimize the funnel/loop to make it go even faster?

**中文翻译:**
明白了。所以是看什么有效，找到约束。然后第二步基本上就是：你能对产品做些什么来优化漏斗或循环，让它跑得更快？

---

### [00:35:00] Crystal Widjaja

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:35:01] Lenny

**English:**
Love that. Maybe as another example, if something comes to mind, with Kumu, how do you think of Kumu through this lens?

**中文翻译:**
太棒了。如果能想到另一个例子的话，比如 Kumu，你如何通过这个视角来看待 Kumu？

---

### [00:35:08] Crystal Widjaja

**English:**
Yeah. I'm always very hesitant to talk about Kumu, because there's so much competition right now and we are on the cusp of some very interesting things. But I think for Kumu, it's actually very complex because there's a lot of human emotion that is involved. With Gojek you knew if you got the job done. You made a transaction. With Kumu, how do you know if a consumer made a friend, felt like they had a genuine friendship? So you almost have to create more friction to identify users who really got past that barrier and aren't explicit with the activity that they did. So we have features that tell us if a user is really searching for this job to be done, if they really want to be part of a community, how do they fill out this?

**中文翻译:**
是的。我总是很犹豫要不要谈论 Kumu，因为现在的竞争非常激烈，而且我们正处于一些非常有趣的事情的边缘。但我认为对于 Kumu 来说，情况其实非常复杂，因为涉及很多人的情感。在 Gojek，你知道任务是否完成，你完成了一笔交易。但在 Kumu，你如何知道消费者是否交到了朋友，是否感受到了真挚的友谊？所以你几乎必须创造更多的“摩擦”来识别那些真正跨越了障碍、但没有明确表达其活动的用户。所以我们有一些功能可以告诉我们用户是否真的在寻找这个目标，他们是否真的想成为社区的一部分，他们是如何填写的？

---

### [00:35:57] Crystal Widjaja

**English:**
Do they fill out the form? Do they fill out a questionnaire of many questions? Do they go through this friction just to get access to a community? So we almost create this artificial friction to help differentiate how deeply a user wants something or needs something. And if the user doesn't fill out that questionnaire, maybe they're actually looking for something else. They were looking for entertainment. They were looking for content or short form content. And so creating almost like hand razor approaches for a user to say, "I wanted this thing." We leave a lot of breadcrumbs in the app to be able to identify those paths.

**中文翻译:**
他们填表了吗？他们填写了很多问题的问卷吗？他们是否愿意经历这些摩擦仅仅为了进入一个社区？所以我们几乎是创造了这种人为的摩擦，来帮助区分用户对某样东西的需求深度。如果用户不填问卷，也许他们其实在找别的东西。他们在找娱乐，在找内容或短视频。所以我们创造了类似“举手示意”的方法，让用户表达“我想要这个”。我们在 App 中留下了很多“面包屑”（痕迹），以便识别这些路径。

---

### [00:36:38] Lenny

**English:**
Awesome. While we're on the topic of these two companies, just maybe for inspiration to founders who are thinking of ways to drive growth, what were a couple of the bigger unlocks growth wise for these two companies or even any other company that you've worked with that's interesting?

**中文翻译:**
太棒了。既然聊到了这两家公司，为了给那些正在思考增长方法的创始人一些灵感，这两家公司（或者你合作过的其他公司）在增长方面有哪些重大的突破点？

---

### [00:36:52] Crystal Widjaja

**English:**
Yeah. Definitely, in the early days it was copy. So I think if your product does something that's not super familiar, you have to tie it to something that is. So I talked about using drivers to sell GoPay. Before that, one thing that we did was to actually take someone's virtual account number and put it onto a picture of a credit card. You know what a credit card is, that's familiar to you. A lot of people didn't know what a digital wallet was. And so when they looked at this like, "Oh, okay. I have this virtual thing that acts like a credit card. It works like my debit account." Then they understood the concept a lot better.

**中文翻译:**
是的。绝对的，早期是文案。我认为如果你的产品做了一些大家不太熟悉的事情，你必须把它和熟悉的东西联系起来。我刚才提到了让司机推销 GoPay。在那之前，我们做的一件事是把用户的虚拟账号放在一张信用卡的图片上。你知道什么是信用卡，那是你熟悉的。很多人不知道什么是数字钱包。所以当他们看到这个时，会想：“噢，好吧，我有一个像信用卡一样的虚拟东西，它的用法像我的借记卡账户。”然后他们就能更好地理解这个概念了。

---

### [00:37:33] Crystal Widjaja

**English:**
And we actually saw top ups increase based on us, literally just sending that picture with someone's virtual account number there. So they could go to an ATM and they would just type in the card number as they would a regular debit account. And they realized that they could top up through that channel. Because that was something that was pretty interesting to us, with just how do we tie the familiarity loop back into the consumer mental model of the product and drive acquisition that way?

**中文翻译:**
我们确实看到充值量增加了，仅仅是因为我们发送了那张带有虚拟账号的图片。这样他们就可以去 ATM 机，像使用普通借记卡账户一样输入卡号。他们意识到可以通过那个渠道充值。这对我们来说非常有趣：我们如何将“熟悉感循环”带回到消费者对产品的心智模型中，并以此推动获客？

---

### [00:38:02] Lenny

**English:**
And that was at Gojek?

**中文翻译:**
那是在 Gojek 做的？

---

### [00:38:02] Crystal Widjaja

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:38:04] Lenny

**English:**
Is there anything else maybe, since you don't want to talk too much about Kumu, any other advisorships or companies, examples of something that ended up working really well to help them accelerate growth?

**中文翻译:**
还有其他的吗？既然你不想多谈 Kumu，在你其他的咨询项目或公司中，有没有什么最终效果非常好、帮助他们加速增长的例子？

---

### [00:38:14] Crystal Widjaja

**English:**
Things that have worked really well. So for one of the companies I work with, AB&B, they run a lot of their D2C brands in South America and globally. So one of the features that we were looking at was how do we ensure that subscriptions don't actually become a canceling point for a user. So in the app you could cancel or you could resume your subscription, but you couldn't pause it. So when we looked at the cancellation reasons and we saw that their number one reason was, I still have too much fear, we actually decided, well, let's just add a pause button then.

**中文翻译:**
效果非常好的事情……我合作过的一家公司 AB&B（注：此处可能指百威英博 AB InBev），他们在南美和全球经营很多 D2C 品牌。我们当时研究的一个功能是：如何确保订阅不会成为用户的“取消点”。在 App 中，你可以取消或恢复订阅，但不能暂停。当我们查看取消原因时，发现排名第一的原因是“我还有太多库存（怕喝不完）”，于是我们决定，好吧，那就加一个暂停按钮。

---

### [00:38:58] Crystal Widjaja

**English:**
Because canceling the subscription is a permanent solution to having too much fear. How do you make a temporary solution that solves the actual problem? Adding in a pause button actually helped alleviate a lot of the churn that was becoming very hard to reacquire back. So that was one fix where we looked at the, again, physics of the model. We're not going to create new changes to the product or create one time buys or reactivation emails. We'll just solve the problem at that small constraint where everyone drops off.

**中文翻译:**
因为取消订阅是对“库存太多”这种担忧的一种永久性解决方案。你如何提供一个解决实际问题的临时方案？加入暂停按钮实际上缓解了大量的流失，而这些流失的用户原本是很难重新获取的。这就是一个修复方案，我们再次审视了模型的物理定律。我们不打算对产品做大的改动，也不打算搞一次性购买或重新激活邮件。我们只是在那个大家都会流失的小约束点上解决了问题。

---

### [00:39:35] Lenny

**English:**
Wait, so can you order beer as subscription? Is that a thing? Is this a consumer product or is this-

**中文翻译:**
等等，所以你可以订阅啤酒？有这种事吗？这是一个消费级产品还是……

---

### [00:39:40] Crystal Widjaja

**English:**
It was a thing, yeah.

**中文翻译:**
是的，确实有。

---

### [00:39:43] Lenny

**English:**
Cool. Okay. This also reminds me, at Airbnb, this was actually one of the biggest wins, is adding a snooze feature to your listing. Exactly the same thing. Yeah. All right there we go. Awesome. Tip for folks that have churn problems, snooze/pause. I want to shift a little bit to a post that you wrote that maybe is one of your more popular posts you wrote on the Reforge blog called Why Most Analytics Efforts Fail. And I'd love to hear your broad overview of why do most analytics efforts fail and then how do teams avoid this? Maybe what are two to three things they can do?

**中文翻译:**
酷。好吧。这也让我想起在 Airbnb，最大的胜利之一其实是给房源列表增加了“休眠”（snooze）功能。完全是一回事。没错。太棒了。给有流失问题的人一个建议：休眠/暂停。我想转到一个话题，关于你在 Reforge 博客上写的一篇可能最受欢迎的文章，叫《为什么大多数数据分析工作都会失败》。我很想听听你对“为什么大多数分析工作会失败”的概括，以及团队如何避免这种情况？也许可以分享两到三件他们可以做的事？

---

### [00:40:18] Crystal Widjaja

**English:**
Yeah, I'm actually pretty surprised at how much noise that has generated because I guess it came from a place of frustration where I kept telling people like, "You are doing this wrong. Here's how you should probably be doing it." But I think it resonated a lot with folks because they recognize all of those symptoms, but they weren't sure why it was happening. So to say, oh, this is the thing, instrumentation is what's wrong, I think it's a very actionable thing. It's probably one of the most solvable problems out there. It just takes some time and mental model shifts to do it well. So a lot of people look at tracking data as how do I track my OKR? How do I know if I'm going up or down? But they don't use it to track or identify insights. So I will use the example of using Twitter for "news" when in reality they're actually using Twitter for entertainment.

**中文翻译:**
是的，我也很惊讶这篇文章引起了这么大的反响。我想这源于一种挫败感，因为我一直告诉人们：“你们做错了，应该这样写。”我认为它引起了很多人的共鸣，因为他们认出了所有的症状，但不确定原因。所以，指出“埋点/数据采集（instrumentation）出了问题”是一件非常具有可操作性的事情。这可能是最容易解决的问题之一，只需要一些时间和心智模型的转变就能做好。很多人把追踪数据看作是“我如何追踪我的 OKR？”“我怎么知道指标是涨了还是跌了？”但他们不利用它来追踪或识别洞察（insights）。我举个例子：有人说用 Twitter 是为了看“新闻”，但实际上他们是在用 Twitter 娱乐。

---

### [00:41:17] Lenny

**English:**
Do not treat metric gathering as entertainment. It's not there for you to be like, "Oh, that's interesting, how novel," and then not act on it. So real news is information that changes what you do in the real world. And if you don't change what you're doing, what you are doing is just getting entertainment. So let's use that as the premise. The next step in instrumentation is to look at the fact that measurements do not equate to insights. A measurement would be an observation. It's a data point in your database. So the example being power users do four times more bookings, is an all observed fact because your transactional database obviously says that is the case, but it's on an insight because it doesn't have context. It doesn't give you information that lets you act on it and better understand the problem.

**中文翻译:**
不要把指标收集当作娱乐。它不是为了让你感叹“噢，真有趣，真新颖”，然后却不采取行动。真正的新闻是能改变你在现实世界中行为的信息。如果你不改变你的行为，你所做的就只是在娱乐。让我们以此为前提。埋点的下一步是看清一个事实：测量（measurements）不等于洞察（insights）。测量是一种观察，是数据库里的一个数据点。例如，“核心用户（power users）的预订量是普通用户的四倍”，这是一个观察到的事实，因为你的交易数据库显然是这么显示的。但这不是洞察，因为它没有上下文。它没有提供让你采取行动或更好理解问题的信息。

---

### [00:42:11] Crystal Widjaja

**English:**
So another example would be if I see my girlfriend hanging out with a guy I don't know, that is an observed fact that you see in the real world. Your hypothesis could be that your girlfriend is cheating on you, but the insight, the actual fact might be that she's not cheating on you, it's her cousin. And now your insight is, I am paranoid and I need to change my behavior to be less crazy. So the insight will provide value when you have this, why answered? Why is this person doing this thing? Here's why. And then you are going to act differently. So for our purposes, if we look at a GoFood user will transact and is more likely to use a voucher, that's a fact, that's an observation, but it's not an insight. An insight would be something like GoFood users who are power users are more likely to use a free shipping discount on a high GMV basket versus non-power users.

**中文翻译:**
另一个例子是：如果我看到我女朋友和一个我不认识的男人在一起，这是现实世界中的一个观察事实。你的假设可能是你女朋友出轨了，但洞察（实际事实）可能是她没出轨，那是她表哥。现在你的洞察是：我太偏执了，我需要改变我的行为，别那么疯狂。所以，当你回答了“为什么”时，洞察才会产生价值。为什么这个人要做这件事？原因在这。然后你会采取不同的行动。对我们来说，如果我们看到“GoFood 用户会进行交易且更有可能使用代金券”，这是一个事实，一个观察，但不是洞察。洞察应该是：“GoFood 的核心用户在高 GMV 订单中比非核心用户更有可能使用免运费折扣。”

---

### [00:43:22] Crystal Widjaja

**English:**
And that actually tells you how to change your marketing approach. It tells you in what circumstances does someone do this. When it's a high GMV basket, give power users the ability to get a free discount, but do not do this for non-powered users because they won't convert any better than they normally would. So, that helps you change your marketing spend. It helps you understand the decision points of power users versus non-power users. The insight is instrumenting properties into an event so that you can segment who is doing what behavior and make some hypotheses on that observation. Test that hypothesis, and then you get some causal representation of whether or not that hypothesis was right.

**中文翻译:**
这实际上告诉了你如何改变营销方式。它告诉你某人在什么情况下会这样做。当订单金额（GMV）很高时，给核心用户提供免费折扣，但不要给非核心用户，因为他们的转化率不会因此有任何提升。所以，这能帮你改变营销支出。它帮你理解核心用户与非核心用户的决策点。洞察就是将属性（properties）埋入事件中，这样你就可以细分谁在做什么行为，并基于观察提出假设。测试该假设，然后你就能得到该假设是否正确的因果关系。

---

### [00:44:10] Lenny

**English:**
So it sounds like a lot of the root of the issue is setting up the wrong metrics, the wrong... I guess there's the tracking element of just capturing the right information. And then also just not focusing on insights versus just having a bunch of information.

**中文翻译:**
所以听起来问题的根源在于设置了错误的指标，错误的……我想还有追踪环节，即是否捕捉到了正确的信息。此外就是没有专注于洞察，而只是拥有一堆信息。

---

### [00:44:24] Crystal Widjaja

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:44:24] Lenny

**English:**
What are signs that you're doing this? Say someone's going to go load up their dashboard and they're like, "Am I failing or not?" What should they be looking for?

**中文翻译:**
有哪些迹象表明你正在犯错？假设有人打开他们的仪表盘想：“我到底做得好不好？”他们应该看什么？

---

### [00:44:33] Crystal Widjaja

**English:**
So I already know if a team is good at instrumentation or not just by looking at the instrumentation spec. The symptom of a bad data tracking approach is you have a ton of rows with a ton of events, but every event has one property or no property being tracked. So an example with Gojek would be when a user lands on the map to select a drop off point, the event would be drop off or map loaded, let's say. And the properties there should be things like how many drivers do they see on the screen? What is the pickup location? What city is it in? What latitude and longitude is it? Is there surge pricing? What is the current minimum fare? Do they have a voucher code?

**中文翻译:**
我只要看一眼埋点规范（instrumentation spec），就能知道一个团队是否擅长埋点。数据追踪做得很差的症状是：你有成千上万行数据和大量事件，但每个事件只追踪了一个属性，甚至没有属性。以 Gojek 为例，当用户进入地图选择下车点时，事件可能是“选择下车点”或“地图已加载”。这里的属性应该包括：屏幕上显示了多少个司机？上车地点在哪？在哪个城市？经纬度是多少？是否有动态调价（surge pricing）？当前的最低运费是多少？他们有代金券代码吗？

---

### [00:45:28] Crystal Widjaja

**English:**
All of these characteristics of the experience and the context that can help you look at hey, when a user only sees two drivers on the screen, they're much less likely to convert than a user who sees five drivers on a screen. Now we can look at in what cities and in what latitude and longitudes do we mostly only see two drivers versus five drivers. Being able to do the second layer approach of the why and not just stop at, "That's weird. When you have two drivers you are less likely to book." But then you never ask why. That drives me crazy. Or the inability to even know that there were only two drivers on the screen. You're missing so much context of the user's experience that you're unable to make assumptions about why the user didn't convert.

**中文翻译:**
所有这些体验和上下文的特征可以帮你发现：嘿，当用户在屏幕上只看到两个司机时，他们的转化率远低于看到五个司机的用户。现在我们可以查看在哪些城市、哪些经纬度下，我们大多只能看到两个司机而不是五个。要能够进行第二层的“为什么”分析，而不是停留在“真奇怪，只有两个司机时预订率较低”。如果你从不问为什么，那会让我抓狂。或者你根本不知道当时屏幕上只有两个司机。你丢失了太多的用户体验上下文，以至于无法对用户为什么不转化做出假设。

---

### [00:46:15] Lenny

**English:**
I love this. Maybe your course is probably going to be the answer, but for folks that want to figure out how to do this taxonomy and events well, how do they go about doing that?

**中文翻译:**
我喜欢这个。也许你的课程就是答案，但对于那些想弄清楚如何做好这种分类（taxonomy）和事件埋点的人来说，他们该怎么做？

---

### [00:46:26] Crystal Widjaja

**English:**
So I think it's important to just go through examples. Yes, every product is different, but everyone has the same signup flow for the most part. So look at the signup flow examples that I have in the blog post or in, I believe Amplitude actually has a pretty good long-winded documentation on this, on how to do a event tracking. But it's really a matter of sitting down and thinking really deeply. If I were to press this button, why would I and why would I not? And am I tracking that in my user properties? So it's really just sitting down and mapping out the experience.

**中文翻译:**
我认为看例子很重要。是的，每个产品都不同，但大多数产品的注册流程是大同小异的。所以可以看看我在博客文章里给出的注册流程示例，或者我相信 Amplitude 也有非常详尽的关于如何进行事件追踪的文档。但这其实是一个坐下来深入思考的过程：如果我要按这个按钮，我为什么会按，为什么不会按？我在用户属性里追踪这些了吗？所以这真的只是坐下来，把整个体验梳理一遍。

---

### [00:47:05] Lenny

**English:**
Speaking of Amplitude and other data tools, do you have a default recommended metrics stack for our founders just to start with and maybe a few other things as they evolve?

**中文翻译:**
说到 Amplitude 和其他数据工具，你有没有一个推荐给创始人的默认指标技术栈？先从什么开始，随着发展再增加什么？

---

### [00:47:14] Crystal Widjaja

**English:**
That really depends on how early they are. So if they have a single data warehouse with all of their transactional data, usually I say, you can probably get by with Google Data Studio. It's free usually with whatever you're using. If not Metabase has a great open source free tool. If you have someone who can write SQL or if you have multiple databases, then Metabase is great. If you need in app mobile device event tracking, I usually recommend CleverTap because Mixpanel has unfortunately failed me a lot. And Amplitude doesn't have the CRM components that I would need all in one space.

**中文翻译:**
这完全取决于他们处于什么阶段。如果他们只有一个包含所有交易数据的数据仓库，通常我说用 Google Data Studio 就能应付。如果你正在使用的服务通常都免费提供。如果没有，Metabase 是一个很棒的开源免费工具。如果你有会写 SQL 的人，或者有多个数据库，Metabase 非常好。如果你需要应用内移动设备事件追踪，我通常推荐 CleverTap，因为 Mixpanel 遗憾地让我失望过很多次。而 Amplitude 并没有我需要的、集成在一个空间里的 CRM 组件。

---

### [00:47:51] Crystal Widjaja

**English:**
If I am much bigger and I need more analytics juice, maybe Amplitude makes sense on top of this, or something that helps me pipe data into more dashboards and do less ETL for me. Then I would get into Segment. And then once you get into experimentation, obviously I have to shout out to Eppo. I think they've really instrumented a lot of the dashboards that I would've normally had to do in experimentation projects. So I usually look at something like Eppo to just automate the decision making flow.

**中文翻译:**
如果规模大得多，需要更强的分析能力，也许在这些基础上加个 Amplitude 是合理的，或者用一些能帮我把数据导入更多仪表盘、减少 ETL（提取、转换、加载）工作的工具。那时我会开始用 Segment。一旦涉及到实验，显然我得推荐 Eppo。我认为他们确实把很多我平时在实验项目中必须手动做的仪表盘都自动化了。所以我通常会看 Eppo 之类的工具来自动化决策流程。

---

### [00:48:21] Lenny

**English:**
Awesome. I think we're both small investors in Eppo, big fans, a little bit of bias, but yeah's it's an excellent Airbnb team that built it, so it's cool. Shifting a bit from metrics and data to just growth teams in general, maybe first question is just, how do you recommend companies set up a growth team in the early days and then over time?

**中文翻译:**
太棒了。我想我们都是 Eppo 的小投资人，也是铁杆粉丝，可能有点偏见，但它确实是由优秀的 Airbnb 团队打造的，非常酷。从指标和数据转向增长团队的话题，第一个问题是：你建议公司在早期以及随着时间推移如何组建增长团队？

---

### [00:48:44] Crystal Widjaja

**English:**
Yeah. So I can talk about how growth was set up at Gojek as an example, which I think is probably the best practice. So we didn't really know what growth was at that time, but we knew there were obvious gaps to fill. So because we had grown so quickly, the core product team was still making the core product features. As simple as phone number masking. That wasn't a thing yet. You had access to your driver's phone number. It's probably not a great thing. It's probably part of the core functionality and we need to fill that gap. At the same time, growth was still necessary because you had all of these users trying to use a product that aren't quite getting there.

**中文翻译:**
好的。我可以以 Gojek 的增长团队组建为例，我认为这可能是最佳实践。当时我们并不真正了解什么是“增长”，但我们知道有明显的空白需要填补。因为我们增长太快了，核心产品团队还在开发核心功能。比如简单的“电话号码脱敏”，当时还没有。你能直接看到司机的电话号码，这可能不太好。这本应是核心功能的一部分，我们需要填补这个空白。与此同时，增长仍然是必要的，因为有这么多用户尝试使用产品却没能成功。

---

### [00:49:25] Crystal Widjaja

**English:**
So things like figuring out what SMS provider we should use to send the OTP to this user who is signing up from this telco provider. That was a growth objective that isn't necessarily core feature work, but was a gap to fill given the onboarding and SMS success delivery rates. Things like telling the driver if this was a brand new customer, because at this point in time, drivers had taken thousands of rides and they assumed every single customer knew how Gojek worked, when maybe they didn't. And so we knew that the protocol was that a power user would know they would make an order and they would just wait. They would wait somewhere, they would keep an eye out for a driver and then they would get on the motorcycle and go.

**中文翻译:**
比如，确定我们应该使用哪个短信供应商来给某个特定运营商的用户发送验证码（OTP）。这是一个增长目标，不一定是核心功能开发，但考虑到入职引导和短信发送成功率，这是一个需要填补的空白。还有像告诉司机这是否是一个全新客户，因为当时司机已经接过几千单了，他们假设每个客户都知道 Gojek 是怎么运作的，但事实可能并非如此。我们知道老用户的习惯是下单后就在某处等着，留意司机的动向，然后上摩托车出发。

---

### [00:50:13] Crystal Widjaja

**English:**
But for a brand new user, are you supposed to walk to the driver? Are you supposed to find them? It's unclear to this brand new, uneducated new user how to use the product. And so first time user experience could have been a terrible one where they went and walked off and then the driver came to the pickup point and they couldn't find them. So it was all of these small acquisition, adoption and engagement use cases that growth was filling the gap on. And eventually we embedded our growth, I would say product managers at the time, into these teams and they ended up synthesizing what growth was as a full-time role. Eventually becoming PMs who own specific parts of the product stack.

**中文翻译:**
但对于新用户来说，你是该走向司机吗？你该去哪找他们？对于这个未经引导的新用户来说，如何使用产品并不清晰。所以第一次用户体验可能会很糟糕：用户走开了，司机到了接送点却找不到人。所以增长团队填补的是所有这些关于获客、采用和参与度的小用例空白。最终，我们将当时的增长产品经理嵌入到这些团队中，他们最终总结出了增长作为一个全职角色的定义。最后，他们成为了负责产品栈特定部分的 PM。

---

### [00:50:58] Lenny

**English:**
So in your experience, and I hear this a lot, is your first growth person shouldn't just come in and figure out what to work on. You should understand here's where we need growth help, let's find somebody to tackle it, versus come help us figure out what to do to drive growth. Is that how you've seen it?

**中文翻译:**
所以根据你的经验（我也经常听到这种说法），你的第一个增长人员不应该只是进来然后自己琢磨该做什么。你应该先明白“这里我们需要增长方面的帮助，找个人来解决它”，而不是“来帮我们想想该怎么做才能增长”。你是这么看的吗？

---

### [00:51:11] Crystal Widjaja

**English:**
Exactly. I think it's just setting the bar too high to expect someone to come in and model everything. Again, there are physics in place it's very hard to move everything. So it's really about having someone who already has all of this data knows where the biggest gaps are. Doesn't have to start from scratch and figure this out and then just picks some small space to work on that they know is workable.

**中文翻译:**
没错。我认为期望一个人进来就能把所有事情建模，这把标准定得太高了。再说一次，物理定律就在那里，很难撼动一切。所以关键在于找一个已经掌握了所有数据、知道最大空白在哪里的人。他不需要从零开始摸索，只需要挑选一个他知道可以操作的小领域开始工作。

---

### [00:51:38] Lenny

**English:**
Do you have strong opinions about growth being integrated? The way that you described where growth PM basically has a cross functional team basically is the PM versus a separate growth team that's off to the side.

**中文翻译:**
对于增长团队应该是集成式的（像你描述的那样，增长 PM 拥有一个跨职能团队），还是一个独立的、在旁边的增长团队，你有什么强烈的看法吗？

---

### [00:51:50] Crystal Widjaja

**English:**
Yeah. I think it can work as a separate growth team to the side if the company is truly head over heels, tripping on insane product market fit, if there's insane, product market fit and you are really scrambling to do core feature stacks, then maybe a growth team to come and be clean up is fine. We're the cleanup crew. We pick up the pieces that were left behind, we connect the dots. You forgot to plug this in, we'll plug it in for you. But we were a team of lots of stats heavy people. So a lot of my team were statistics graduates. We cared a lot about looking at numbers and odds and probabilities because it really is a numbers game at that scale. You could work on anything and everything would probably do something. But what was the thing that would make the most impact now and unlock us for the future.

**中文翻译:**
是的。我认为如果公司正处于疯狂的“产品市场匹配”（PMF）阶段，忙于构建核心功能栈，那么一个独立的增长团队作为“清理小组”是可以的。我们就是清理小组，捡起被遗忘的碎片，连接各个环节。你忘了插这个插件，我们帮你插上。但我们是一个由大量精通统计学的人组成的团队。我团队里的很多人都是统计学毕业生。我们非常看重数字、赔率和概率，因为在那个规模下，这真的是一场数字游戏。你可以做任何事，每件事可能都有点效果。但关键是：现在做什么影响最大，并能为未来铺路。

---

### [00:52:44] Lenny

**English:**
I was going to ask you folks to look for when they're hiring an early growth person, is that what you find, just stats, data kind of person?

**中文翻译:**
我正想问招聘早期增长人员时该看重什么，你觉得就是这种精通统计和数据的人吗？

---

### [00:52:49] Crystal Widjaja

**English:**
You have to have someone who knows how to run the numbers. If you're looking at ratios of conversion rates, but you don't realize that this ratio is of a much smaller base size, you're going to make the wrong decision. So someone who is intuitively good at statistics, they know how to do sampling appropriately. They know what selection bias is. The worst possible thing is to have a growth person who thinks they are doing the right thing and is measuring things wrong and then focusing on the wrong areas.

**中文翻译:**
你必须找一个知道如何处理数据的人。如果你只看转化率，却没意识到这个比例的基数非常小，你就会做出错误的决定。所以要找一个直觉上擅长统计的人，他们知道如何正确抽样，知道什么是选择性偏差。最糟糕的情况是，一个增长人员自以为在做正确的事，结果测量方法错了，然后把精力集中在错误的领域。

---

### [00:53:24] Lenny

**English:**
Do you find that it's often easier or better to hire a young up and coming person or find someone that's got a bunch of experience for your first growth hire?

**中文翻译:**
你觉得第一个增长员工是招一个年轻有潜力的人更容易/更好，还是找一个经验丰富的人？

---

### [00:53:34] Crystal Widjaja

**English:**
I would hire someone who is willing to take intro to statistics course. And it doesn't matter if they've had the experience to go wild or not. I think it really is, can they focus on the right opportunity rather than the most flashy thing? And I think both profiles can come under that.

**中文翻译:**
我会雇佣一个愿意去上统计学入门课的人。他们是否有大干一场的经验并不重要。我认为关键在于：他们能否专注于正确的机会，而不是最花哨的东西？我觉得这两种背景的人都有可能做到这一点。

---

### [00:53:54] Lenny

**English:**
Got it. And then what do you do in a hiring process for someone like this? What kind of things do you suggest founders look for?

**中文翻译:**
明白了。那么在招聘这类人的过程中你会怎么做？你建议创始人寻找什么样的特质？

---

### [00:54:01] Crystal Widjaja

**English:**
Yeah. I actually look for that first principle bias. So I'll give people case studies of here's what we see, how do you know that this is true? And then I have them set up an experiment design. I want to see that they are sampling randomly. Not that they're like, "I'm going to build this feature and launch it, and of course it's going to work." I want to see that they're taking a measured deliberate approach to considering why someone might do this or what tools are available. A growth team can go terribly wrong when they just try to onboard a bunch of brand new tools that don't integrate well and it takes six months to integrate fully, and then they get nothing done for six months. Everything in growth is an opportunity cost of time, trade off with what you could have been doing to the product in that time.

**中文翻译:**
是的。我其实会寻找那种“第一性原理”的偏好。我会给应聘者案例分析：这是我们看到的情况，你如何证明这是真的？然后让他们设计一个实验。我想看到他们是在进行随机抽样，而不是说“我要做这个功能并发布它，它肯定会奏效”。我想看到他们采取一种审慎、深思熟虑的方法来考虑用户为什么会这样做，或者有哪些可用工具。如果增长团队只顾着引入一堆集成困难的新工具，花六个月才集成好，结果这半年啥也没干，那就会出大问题。增长中的一切都是时间的沉没成本，是你在这段时间内本可以对产品所做改进的权衡。

---

### [00:54:50] Crystal Widjaja

**English:**
So we biased towards really quick hacky things. Like in the early days of Gojek growth, I think our first real growth experiment, we were actually still the data team at this time, was to connect a quick Python script to the Twilio API that we had access to. And we SMSd a bunch of drivers through a CSV that we uploaded that said like, "Hey, your acceptance rate is really low. You're not supposed to do that. Please accept all the rides that you are getting." And that actually increased acceptance rates by 2% across the board. And when we looked deeper into that data, it did even more so for brand new drivers. And so we then worked with the data driver onboarding team so that they could better facilitate the onboarding experience for their drivers.

**中文翻译:**
所以我们倾向于做非常快速、走捷径（hacky）的事情。比如在 Gojek 增长的早期，我想我们的第一个真正的增长实验（当时我们名义上还是数据团队）是将一个简单的 Python 脚本连接到我们可以使用的 Twilio API。我们通过上传 CSV 文件给一群司机发短信，内容大概是：“嘿，你的接单率很低，不该这样。请接受你收到的所有订单。”这实际上让整体接单率提高了 2%。当我们深入研究数据时，发现对新司机的效果更好。于是我们随后与司机入职团队合作，以便他们能更好地优化司机的入职体验。

---

### [00:55:38] Lenny

**English:**
For the interview question that you described, an experiment design question, do you give that as a project where they have time to work on it or is it a live thing?

**中文翻译:**
对于你描述的面试题（实验设计题），你是把它作为一个有时间完成的项目布置下去，还是现场面试？

---

### [00:55:46] Crystal Widjaja

**English:**
Yes. Yeah. I don't think live works really well for these case studies. I want to see people put in the time and the work to do something to the best of their ability. And of course we ask them like, "Hey, you have five days. We expect you to spend probably four hours on this, so if you don't have four hours within these five days, let us know." So we're pretty careful about giving them the appropriate amount of time to do it at the level of quality that we would've expected if they were to work here full-time. So give them those four hours, we want to see do they Google. If they can't figure it out right now, let's see them Google it. We'll ask them what approaches they took, how did they figure this out. And we like to hear people say that they literally had to Google this and read a bunch of white papers. I do that as well.

**中文翻译:**
是的。我不认为现场面试对这类案例分析很有效。我想看到人们投入时间和精力，尽其所能地完成。当然我们会问：“嘿，你有五天时间。我们预计你可能需要花四个小时，如果你这五天里抽不出四个小时，请告诉我们。”所以我们很谨慎地给他们足够的时间，以达到如果他们全职在这里工作我们所期望的质量水平。给他们那四个小时，我们想看他们是否会去 Google。如果他们现在想不出来，就看他们怎么搜。我们会问他们采取了什么方法，是怎么弄明白的。我们喜欢听到人们说他们确实去 Google 了，还读了一堆白皮书。我自己也会这么做。

---

### [00:56:39] Lenny

**English:**
For people trying to design one of these for themselves, do you have a question that you've retired that you could share or something that would help somebody design their own prompt?

**中文翻译:**
对于那些想为自己设计这类题目的人，你有没有什么已经不再使用的题目可以分享，或者能帮助别人设计自己的面试题？

---

### [00:56:49] Crystal Widjaja

**English:**
Yeah. I can give you a template after this call.

**中文翻译:**
好的，通话结束后我可以给你一个模板。

---

### [00:56:51] Lenny

**English:**
Amazing. We'll include that in the show notes. Easy peasy. Amazing. Okay. A last topic that I wanted to cover is a very cool thing that you were involved in. It's a nonprofit that you started called Generation Girl. And I think the mission is to help women and young girls get into STEM. So I'd love to hear about this program, how you got into it, what it's all about, and then also just how listeners can help support what you're doing.

**中文翻译:**
太棒了。我们会把它放在节目介绍里。简单明了。好，我想聊的最后一个话题是你参与的一件非常酷的事情。那是你发起的一个名为 Generation Girl 的非营利组织。我想它的使命是帮助女性和年轻女孩进入 STEM 领域。我很想听听这个项目，你是如何参与其中的，它是关于什么的，以及听众可以如何支持你们。

---

### [00:57:15] Crystal Widjaja

**English:**
Absolutely. Yes. Generation Girl is very near and dear to my heart. So I co-founded this with a couple of amazing women who were also at Gojek, but are now full-time at Generation Girl. So this really stemmed from us repeatedly getting annoying comments about working in STEM. So things like, "You can't possibly be the engineer on this project. You look like you like makeup and stuff." And we were like, "Yes, I absolutely love makeup, but I also am badass at writing SWIFT code, so step aside." So having experienced a lot of the misrepresentation of what an engineer should look like or should like, I think we really look to Legally Blonde, is one of my favorite movies that represents you can take the powers that you have, whether you like engineering or design or data, and you can be whoever you want and still kick ass at it.

**中文翻译:**
当然。是的，Generation Girl 对我来说非常重要。我是和几位同样在 Gojek 工作过的优秀女性共同创立的，她们现在全职在 Generation Girl 工作。这源于我们反复听到关于在 STEM 领域工作的烦人评论。比如：“你不可能这个项目的工程师，你看上去像是喜欢化妆之类的人。”我们的反应是：“是的，我绝对喜欢化妆，但我写 Swift 代码也牛得不行，所以让开。”因为经历了很多关于工程师“应该长什么样”或“应该喜欢什么”的偏见，我觉得我们有点像《律政俏佳人》（Legally Blonde）——那是我最喜欢的电影之一，它代表了你可以利用你的能力，无论你喜欢工程、设计还是数据，你可以成为你想成为的任何人，并且依然表现出色。

---

### [00:58:14] Crystal Widjaja

**English:**
So a lot of the women that we support, we're actually happy if they go into one of our classes and they say, "Actually, I don't like engineering." That's great. That's agency and empowerment that they got to make that decision for themselves without any cultural biases or social pressure telling them that they should feel this way. And so we offer free classes for girls 12 to 17. We have college classes. We partner with teachers about how to teach STEM topics, especially in areas where they don't have laptops for every student. How do you teach how to use Figma and things like that? So people can definitely support us and reach out to us. We have a PayPal on our website, take a look.

**中文翻译:**
对于我们支持的很多女性，如果她们上完课后说“其实我不喜欢工程”，我们反而很高兴。这很好。这说明她们拥有了自主权和力量，可以为自己做决定，而没有文化偏见或社会压力告诉她们“应该”怎么想。我们为 12 到 17 岁的女孩提供免费课程，也有大学课程。我们与教师合作，教他们如何教授 STEM 课题，特别是在那些并非每个学生都有笔记本电脑的地区。你如何教他们使用 Figma 之类的工具？所以大家绝对可以支持我们并联系我们。我们的网站上有 PayPal 链接，可以去看看。

---

### [00:58:59] Lenny

**English:**
Can you share some of the impact that you've seen from this? Are there numbers you can share or anything that you can share around what the organizations have done.

**中文翻译:**
你能分享一下你所看到的成果吗？有没有什么数字或者组织所做的事情可以分享？

---

### [00:59:05] Crystal Widjaja

**English:**
So we've already had several thousand students go through Generation Girl, summer clubs and programs and classes. So we have an event every week. We have a full summer club that's every single day for two weeks, every summer and every winter. We have partnerships with some of the biggest tech companies in Indonesia, where we partner students with engineers and they work on projects together. And most recently we're part of the MIT solve program with our new initiative Class. So Class, we're creating a free to use site for teachers.

**中文翻译:**
已经有几千名学生参加过 Generation Girl 的夏令营、项目和课程。我们每周都有活动。每年夏天和冬天都有为期两周、每天进行的夏令营。我们与印尼一些最大的科技公司合作，让学生与工程师结对共同完成项目。最近，我们的新计划 Class 加入了 MIT Solve 项目。通过 Class，我们正在为教师创建一个免费使用的网站。

---

### [00:59:40] Crystal Widjaja

**English:**
So right now we have partnered with a handful of universities in Indonesia, both in rural and city of Jakarta where teachers can now have the knowledge and material to explain newer concepts that maybe they're less familiar with, because startup world changes rapidly, how you develop changes rapidly. So this is one thing that we are most excited about because every teacher impacts thousands of students a year. And being able to teach the teachers and give them the resources that they need is something that's really important.

**中文翻译:**
目前我们已经与印尼的几所大学合作，包括农村地区和雅加达市区。教师们现在可以获得知识和材料，去解释那些他们可能不太熟悉的新概念，因为初创世界变化很快，开发方式变化也很快。这是我们最兴奋的一件事，因为每位教师每年都会影响成千上万的学生。能够培训教师并为他们提供所需的资源是非常重要的。

---

### [01:00:11] Lenny

**English:**
That's incredible. It's currently just in Southeast Asia, is that right?

**中文翻译:**
太不可思议了。目前只在东南亚开展，对吗？

---

### [01:00:15] Crystal Widjaja

**English:**
Only in Indonesia, because frankly, this is where everyone needs the most support. Globally STEM is not well received or welcoming at all to women. I think it's gotten worse over the past few decades. Below 18% of college graduates are women in computer science. So we're really trying to reach the youngest generation because that's when you are told or informed that computer science is for specific types of people.

**中文翻译:**
目前只在印尼，因为坦白说，这里的人最需要支持。在全球范围内，STEM 领域对女性并不友好。我认为在过去的几十年里情况反而变糟了。计算机科学专业的大学毕业生中，女性比例不足 18%。所以我们真的在努力接触最年轻的一代，因为那是你被告知或被暗示“计算机科学是给特定类型的人学的”的时候。

---

### [01:00:46] Lenny

**English:**
It's really sad to hear that it's heading in the wrong direction. What do you think is contributing to that?

**中文翻译:**
听到情况在往错误的方向发展真的很令人难过。你认为是什么导致了这种现象？

---

### [01:00:52] Crystal Widjaja

**English:**
I think there is still a lot of this mental model of what a computer scientist is able to do and how much support they're given. So it's been shown in studies that at the youngest generation middle school, high school, you are more likely to be given introductory STEM classes as a male than as a female. So women just aren't targeted for STEM at that younger age. And so when they enter the high school or college classes for computer science, they're way behind. And that does not feel good. No one likes to be the worst in the class. And so it's more likely that you'll drop out. We've seen studies at Carnegie Mellon that actually would create introductory computer science classes before the college class starts. And for the women who did join those classes, they actually graduated at similar rates as their male counterparts. So it's really setting them up for success.

**中文翻译:**
我认为关于“计算机科学家能做什么”以及他们能获得多少支持，仍然存在很多固有的心智模型。研究表明，在初中、高中这一代，男性比女性更有可能获得 STEM 入门课程。所以女性在年轻时并没有被作为 STEM 的目标群体。因此，当她们进入高中或大学的计算机科学课程时，已经落后了一大截。那种感觉并不好，没人喜欢当班里的差生。所以你更有可能退学。我们看过卡内基梅隆大学的研究，他们实际上在大学课程开始前开设了计算机科学入门课。对于参加了这些课程的女性，她们的毕业率实际上与男性相当。所以这真的是在为她们的成功铺路。

---

### [01:01:52] Lenny

**English:**
If folks want to help. You said that there's a PayPal page. Is there any other sort of action people can take?

**中文翻译:**
如果大家想帮忙，你提到有一个 PayPal 页面。还有其他人们可以采取的行动吗？

---

### [01:01:58] Crystal Widjaja

**English:**
Yes. Enterprise software. We love to teach iOS development, licensed software. We have hundreds of students a year, so let us know.

**中文翻译:**
有的。企业软件。我们喜欢教 iOS 开发，需要授权软件。我们每年有数百名学生，所以请联系我们。

---

### [01:02:07] Lenny

**English:**
Awesome. And they can reach you on generationgirl.com?

**中文翻译:**
太棒了。他们可以在 generationgirl.com 找到你吗？

---

### [01:02:10] Crystal Widjaja

**English:**
Generationgirl.org.

**中文翻译:**
是 generationgirl.org。

---

### [01:02:12] Lenny

**English:**
Crystal, thank you so much for being here. I've taken enough of your time. Two last quick questions. Where can folks find you online if they want to reach out? And then other than the Generation Girl chat we just had, is there any other way folks can be helpful to you?

**中文翻译:**
Crystal，非常感谢你能来。耽误了你不少时间。最后两个简短的问题：如果大家想联系你，可以在哪里找到你？除了刚才聊到的 Generation Girl，还有什么其他方式大家可以帮到你吗？

---

### [01:02:25] Crystal Widjaja

**English:**
Yes. Please find me at crystalwidjaja.com. You can reach out to me and my email is there. Listeners, please do instrumentation correctly. Please don't track your KPIs. Please track your user journeys and experiences. We'll have much funner things to talk about if you do that.

**中文翻译:**
好的。请访问 crystalwidjaja.com 找到我，那里有我的联系方式和邮箱。各位听众，请务必正确地进行埋点。请不要只追踪你的 KPI，请追踪你的用户旅程和体验。如果你这样做，我们以后会有更多有趣的话题可以聊。

---

### [01:02:43] Lenny

**English:**
Amazing PSA. Thank you so much, Crystal.

**中文翻译:**
非常有意义的公益宣告。非常感谢你，Crystal。

---

### [01:02:46] Crystal Widjaja

**English:**
Thanks Lenny. This was a blast.

**中文翻译:**
谢谢 Lenny。聊得很开心。

---

### [01:02:48] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得这一集有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。我们下期再见。