# Dalton Caldwell - 双语对照

# Lenny's Podcast: Dalton Caldwell (Y Combinator) - Bilingual Transcript

---

### [00:00:00] Dalton Caldwell

**English:**
Seeing everything people apply to YC with. People all have the same idea.

**中文翻译:**
看到大家申请 YC 的所有项目，我发现人们的想法其实都大同小异。

---

### [00:00:04] Lenny Rachitsky

**English:**
One of these themes is simple, pragmatic advice. Sell shit, make money.

**中文翻译:**
其中一个主题是简单、务实的建议：卖出产品，赚到钱。

---

### [00:00:07] Dalton Caldwell

**English:**
One of my mantras is just don't die. Being coached and being reminded of the fundamentals and basics puts you in the right mindset.

**中文翻译:**
我的座右铭之一就是“别死掉”。接受指导并被提醒那些最基本、最核心的原则，能让你保持正确的心态。

---

### [00:00:15] Lenny Rachitsky

**English:**
You have this concept of tarpit ideas.

**中文翻译:**
你提出了一个“焦油坑想法”（tarpit ideas）的概念。

---

### [00:00:17] Dalton Caldwell

**English:**
Seems like an unsolved problem. You'll get all this positive feedback from the world and people have been starting that startup since the '90s.

**中文翻译:**
这看起来像是个未解决的问题，你会得到外界各种积极的反馈，但实际上从 90 年代起就一直有人在尝试这类创业项目。

---

### [00:00:23] Lenny Rachitsky

**English:**
Recently you put out a request for startups, 20 categories of ideas and the YC wants to fund.

**中文翻译:**
最近你发布了一份“初创公司征集令”（Request for Startups），列出了 YC 想要资助的 20 类创意。

---

### [00:00:28] Dalton Caldwell

**English:**
We're trying to mix up some of the information diet about what kind of ideas people might be contemplating they are currently.

**中文翻译:**
我们试图改变一下人们目前正在思考的创意类型，丰富一下大家的“信息食谱”。

---

### [00:00:33] Lenny Rachitsky

**English:**
A lot of people say you're the king of the pivot.

**中文翻译:**
很多人说你是“转型之王”（king of the pivot）。

---

### [00:00:36] Dalton Caldwell

**English:**
A good pivot is like going home. It's warmer, it's closer to something that you're an expert at.

**中文翻译:**
一次好的转型就像是回家。它更温暖，也更接近你所擅长的领域。

---

### [00:00:41] Lenny Rachitsky

**English:**
Are there other patterns you find across startups that do well?

**中文翻译:**
在那些表现出色的初创公司中，你还发现了其他什么模式吗？

---

### [00:00:43] Dalton Caldwell

**English:**
There's a lot of founders that come this close to it, all being over and through sheer will just keep it going.

**中文翻译:**
有很多创始人曾离彻底失败仅一步之遥，但凭借顽强的意志力，他们硬是撑了下去。

---

### [00:00:54] Lenny Rachitsky

**English:**
Today my guest is Dalton Caldwell. Dalton is managing director and group partner at Y Combinator where he's worked for over 10 years across 21 different YC batches, including working closely in the earliest days of Instacart, Retool, Brex, Deel, DoorDash, Webflow, Replit, Amplitude, Whatnot, Razorpay and 20 other Unicorns. Prior to Y Combinator, Dalton was the co-founder and CEO of imeem, which was acquired by Myspace, and Co-founder and CEO of App.net, which was an early ads-free competitor to Twitter. Dalton has seen and worked with more startups than nearly any human alive and in our conversation we get incredibly tactical and deep on the startup journey. Why it all comes down to simply not losing hope and not letting your startup die. What to do when your startup is struggling and how to know when it is time to give up. What makes a great pivot and signs it's time to pivot. How to actually talk to customers.
(00:01:50):
Why every single startup goes through a point where they feel like all hope is lost. Why investors say no to startups. What most often leads to startups failing. Why you need to avoid over-delegating early on. Plus startup ideas that you should avoid. And also 20 ideas Dalton is looking to fund. Also so many great stories and lessons. This episode is action packed. With that, I bring you Dalton Caldwell after a short word from our sponsors. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. This episode is brought to you by Eppo. Eppo is a next generation A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams. Companies like Twitch, Miro, ClickUp and DraftKings rely on Eppo to power their experiments.
(00:02:45):
Experimentation is increasingly essential for driving growth and for understanding the performance of new features. And Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does. When I was at Airbnb, one of the things that I loved most was our experimentation platform where I could set up experiments easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more with advanced statistical methods that can help you shape weeks off experiment time and accessible UI for diving deeper into performance and out-of-the-box reporting that helps you avoid annoying, prolonged analytic cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the A/B testing flywheel. Eppo powers experimentation across every use case, including product, growth, machine learning, monetization, and email marketing. Check out Eppo at geteppo.com/Lenny and 10X your experiment velocity. That's get E-P-P-O dot com slash Lenny.
(00:03:46):
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast. Now, you can assess risk, secure the trust of your customers and automate compliance for SOC 2, ISO 27001, HIPAA and more with a single platform, Vanta. Vanta's market-leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risks. Plus, you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to vanta.com/Lenny. That's V-A-N-TA dot com slash Lenny. Dalton, thank you so much for being here and welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Dalton Caldwell。Dalton 是 Y Combinator (YC) 的董事总经理兼集团合伙人。他在 YC 工作了 10 多年，参与了 21 个不同的 YC 批次，并在 Instacart、Retool、Brex、Deel、DoorDash、Webflow、Replit、Amplitude、Whatnot、Razorpay 以及其他 20 多家独角兽公司的初创期与他们紧密合作。在加入 YC 之前，Dalton 是 imeem 的联合创始人兼 CEO（该公司被 Myspace 收购），也是 App.net 的联合创始人兼 CEO（Twitter 早期的无广告竞争对手）。Dalton 见过并合作过的初创公司可能比世界上任何人都多。在我们的对话中，我们将深入探讨创业旅程中极具战术性的细节。为什么一切最终都归结为不放弃希望，不让你的公司死掉。当你的公司陷入困境时该怎么办，以及如何知道什么时候该放弃。什么是成功的转型，以及转型的信号。如何真正地与客户交谈。
(00:01:50):
为什么每一家初创公司都会经历一个感到绝望的时刻。为什么投资者会对初创公司说“不”。什么最常导致创业失败。为什么你需要避免在早期过度授权。此外，还有你应该避开的创业想法，以及 Dalton 想要资助的 20 个创意。还有许多精彩的故事和教训。这一集干货满满。在听完赞助商的简短介绍后，我们将迎来 Dalton Caldwell。如果你喜欢这个播客，别忘了在应用或 YouTube 上订阅。这是避免错过未来节目的最好方式，也对我们帮助巨大。本集由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依赖 Eppo 来进行实验。
(00:02:45):
实验对于推动增长和了解新功能的表现越来越重要。Eppo 能帮助你提高实验速度，同时实现其他商业工具无法提供的严谨深度分析。当我在 Airbnb 时，我最喜欢的东西之一就是我们的实验平台，我可以自己轻松设置实验、排除故障并分析结果。Eppo 不仅能做到这些，还拥有先进的统计方法，可以缩短数周的实验时间，并提供易用的 UI 和开箱即用的报告，帮你避免烦人的分析周期。Eppo 还能让你轻松与团队分享实验见解，激发 A/B 测试飞轮的新想法。Eppo 支持各种场景的实验，包括产品、增长、机器学习、变现和邮件营销。访问 geteppo.com/Lenny，让你的实验速度提升 10 倍。
(00:03:46):
本集还由 Vanta 赞助。要确保公司拥有顶级的安全实践，事情很快就会变得复杂。现在，你可以通过 Vanta 这一个平台来评估风险、赢得客户信任并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，并报告和跟踪风险。此外，你还可以通过 Vanta AI 自动填写安全调查问卷，节省数小时时间。加入全球数千家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的公司吧。访问 vanta.com/Lenny 即可享受 1000 美元的优惠。Dalton，非常感谢你能来，欢迎来到播客。

---

### [00:04:45] Dalton Caldwell

**English:**
Yeah. Thanks so much, Lenny. I'm really excited to talk to you today. It's been great.

**中文翻译:**
好的。非常感谢，Lenny。今天能和你聊天我非常兴奋。这太棒了。

---

### [00:04:48] Lenny Rachitsky

**English:**
So to prep for this podcast interview, I asked a bunch of founders that worked with you during YC what advice you shared with them along the journey that was most transformative to the way they think about product, the way they think about building their startup, the way they operate. And there's a bunch of themes that emerged and I'm going to touch on a number of these themes. One of these themes is just how often you get to very simple pragmatic advice and how much of your message is just sell shit, make money, don't run out of money. Why do you think founders need to hear this advice, which is seemingly simple and obvious?

**中文翻译:**
为了准备这次采访，我询问了一群在 YC 期间与你合作过的创始人，问他们在创业过程中，你给出的哪些建议对他们思考产品、构建公司和运营方式最具启发性。我总结出了一些主题，接下来我会一一探讨。其中一个主题就是你经常给出非常简单务实的建议，你的核心信息往往就是：卖出东西，赚到钱，别让钱花光。你为什么认为创始人需要听到这些看似简单显而易见的建议呢？

---

### [00:05:22] Dalton Caldwell

**English:**
Have you ever seen in NBA basketball or college basketball where they have the coach mic'd up and it shows what they're actually saying in the huddle? You ever listen to what they actually are saying? They're like, "Okay, we need to really focus and get the ball and win this game." If you actually listen to what the greatest, smartest, most successful athletes are talking about, if you listen to what Tiger Woods is saying to his caddy, it all sounds like pretty mundane stuff. It's not like what Tiger Woods is talking about with his caddy is some impossible to decipher jargon. It's like, "Yeah, you really need to keep your head down on this one." It's things like that. And I think the reason this is true is that even if you're in the best in the world, being coached and being reminded of the fundamentals and basics is what puts you in the right mindset and that you already know everything, right? You're at the top of your game if you make it to the elite levels of being a startup founder or basically doing anything that's really hard psychologically.
(00:06:33):
And so yeah, one of my mantras is just don't die. Just keep your startup going. Just keep going. And I say that over and over again and honestly, that is often what people tell me is the most impactful thing I said. It's not that I said some Ninja 5D chess mood that they never would've thought of before. It's just the constant affirmation that continuing to keep going and doing high quality reps is the game.

**中文翻译:**
你有没有看过 NBA 或大学篮球赛，教练身上带着麦克风，镜头展示他们在暂停围成一圈时说的话？你听过他们到底在说什么吗？他们会说：“好，我们需要集中注意力，抢到球，赢下这场比赛。”如果你去听那些最伟大、最聪明、最成功的运动员在聊什么，比如泰格·伍兹对他的球童说的话，听起来都很平淡。伍兹和球童聊的并不是什么深奥难懂的术语，而是像“这一杆你真的得低头盯着球”之类的话。我认为之所以如此，是因为即使你是世界上最顶尖的人，接受指导并被提醒那些基本功和基础知识，才能让你进入正确的状态。其实你已经知道了一切，对吧？如果你能达到初创公司创始人这种精英级别，或者从事任何心理压力极大的工作，你已经处于巅峰状态了。
(00:06:33):
所以，我的座右铭之一就是“别死掉”。让你的公司活下去，继续前进。我一遍又一遍地重复这句话。老实说，人们经常告诉我，这是我说过的最有影响力的话。并不是因为我出了什么他们从未想过的“忍者级五维象棋”奇招，而仅仅是不断地肯定：坚持下去，保持高质量的重复练习，这就是游戏的本质。

---

### [00:07:04] Lenny Rachitsky

**English:**
I know that you'd give a talk that's exactly called that, How Not To Die. Just to pull on this thread a little bit more, what is the general advice you share there for people that also don't want to die?

**中文翻译:**
我知道你做过一个专门的演讲，题目就叫《如何不死》。顺着这个话题再深入一点，对于那些也不想让公司倒闭的人，你通常会分享哪些建议？

---

### [00:07:14] Dalton Caldwell

**English:**
The way to summarize that is if you look at all the startup stories that we have at YC and all the companies we funded over all the years, the underlying theme is that rationally the founder should have given up at some point. And so again, let's talk about Airbnb, obviously something you know a lot about. They probably should have shut down three or four times before they got into YC. It objectively wasn't working. They were basically ruining their lives, they were disappointing their parents, everything was wrong and it was a purely irrational act for the founders of Airbnb to keep working on their goofy startup. And again, that's just one story. If you look across the portfolio of YC and non-YC companies, there has to be this irrational intention to keep going even when the world tells you it's not working and you feel completely defeated. And you likely have to go through this many times and have these near-death experiences. And then you get lucky and then you look like an overnight success. Right?
(00:08:26):
And so that is the theme that is a summary and I provide lots of data and lots of stories there, but this is one of those things that the longer I have this job, the more I really, really believe this is true.

**中文翻译:**
可以这样总结：如果你观察 YC 所有的创业故事和我们多年来资助的所有公司，你会发现一个潜在的主题——从理性角度看，创始人在某个时刻本该放弃的。我们再聊聊 Airbnb，你肯定很了解。在进入 YC 之前，他们可能本该倒闭三四次了。客观上讲，当时根本行不通。他们基本上是在毁掉自己的生活，让父母失望，一切都糟透了。Airbnb 的创始人坚持做那个“愚蠢”的创业项目，纯粹是一种非理性的行为。而这只是其中一个故事。如果你看 YC 和非 YC 公司的投资组合，你会发现必须有一种“非理性的意图”去坚持，即使全世界都告诉你这行不通，即使你感到彻底挫败。你可能得经历很多次这种“濒死体验”。然后你运气爆发，看起来就像一夜成名。对吧？
(00:08:26):
这就是核心主题。我提供了很多数据和故事来佐证。我做这份工作越久，就越坚信这是真理。

---

### [00:08:39] Lenny Rachitsky

**English:**
What's your advice on the flip side of that where there's a lot of startups, especially these days that are just super struggling, have been added for a while, there are mental health challenges, they'd be very sad if they had to shut this thing down, but often it's probably the right move? What's your advice to folks on deciding, okay, actually does make sense to give up in this case?

**中文翻译:**
那反过来说呢？现在有很多初创公司正处于极度挣扎中，已经坚持了一段时间，面临心理健康挑战，如果关门大吉他们会非常难过，但往往这才是正确的选择。对于那些正在纠结“现在放弃是否合理”的人，你有什么建议？

---

### [00:09:01] Dalton Caldwell

**English:**
I think this is a nuanced question and it's hard for me to say something on a podcast that'll actually be useful to people, but here's a couple of thoughts. One, are you still having fun? Do you still enjoy doing what you're doing? Do you enjoy spending time with your co-founders? Is this actually a fun thing you're doing? And if the answer there is yes, I would tend to lean on the keep going. And then if it's more of, wow, this is actually profoundly affecting me a negative way and my relationships with people in my life and I don't really want to work with my co-founder anymore and things like that, then I would lean on the probably don't do it anymore. Something that a lot of the folks that turn it around have in common is they actually do love their customers and they love their product.
(00:09:51):
And again, in the Airbnb story, again, you know it really well, but they really liked Airbnb and they liked working with each other and they liked the first host that they met and they knew all their names. You know what I'm saying? They loved their startup even though it was going bad. And so that's to me a signal to keep going is that you really, really love what you're doing and the people you're doing it with and you love your customers and you love the problem. Versus where you're just like, "Yeah, I could care less about any of those things. I'm just having a bad time." Harder to be encouraging in that situation. And this is a fixable situation. You can make it more like the thing you love, can't you?

**中文翻译:**
这是一个很微妙的问题，很难在播客里给出一个对所有人都通用的建议，但我有几点想法。第一，你还觉得有趣吗？你还喜欢你正在做的事情吗？你喜欢和合伙人待在一起吗？这真的是一件让你开心的事吗？如果答案是肯定的，我会倾向于建议你坚持下去。但如果情况是，这件事已经严重负面地影响了你的生活、你的人际关系，你甚至不想再和合伙人共事了，那么我会倾向于建议你别做了。很多反败为胜的人都有一个共同点：他们真的热爱他们的客户，热爱他们的产品。
(00:09:51):
回到 Airbnb 的故事，他们真的很喜欢 Airbnb，喜欢彼此合作，喜欢他们遇到的第一批房东，甚至记得所有人的名字。你明白我的意思吗？即使情况糟糕，他们依然热爱自己的公司。所以对我来说，坚持下去的信号是你真的热爱你所做的事、你的团队、你的客户以及你正在解决的问题。反之，如果你觉得“我根本不在乎这些，我只是过得很痛苦”，那就很难鼓励你继续了。而且这种情况是可以修复的，你可以把它变得更像你热爱的事物，不是吗？

---

### [00:10:34] Lenny Rachitsky

**English:**
Yeah. This is actually very practical and great advice. This is something people can sense, "Okay, am I actually enjoying this? Do I want to keep doing this?" Versus, "Man, such a drag that I have to keep running this startup." Is there anything you could say to folks that are just like, "I can't stop because it'll feel like I failed"?

**中文翻译:**
是的，这确实是非常务实且棒的建议。这是人们可以感知的：“我真的享受其中吗？我想继续吗？”而不是“天哪，继续经营这家公司简直是种折磨。”对于那些觉得“我不能停下来，因为那意味着我失败了”的人，你有什么想说的吗？

---

### [00:10:50] Dalton Caldwell

**English:**
If it's really going poorly or if you're having a really bad time, it's no big deal. No one will remember that you shut down your company probably in 10 years or 20 years time. As long as you have integrity, as long as you're an honest person, as long as you handle yourself well through good times and bad, people will remember you fondly. We have such a short life. There's only so many years we get to have our careers, doing something that makes you miserable and the only reason you're doing it is to avoid losing face and you know in your heart is not going to work, I don't know, that seems like a pretty big opportunity cost on literally your life. Right?

**中文翻译:**
如果情况真的很糟，或者你过得很痛苦，那也没什么大不了的。10 年或 20 年后，没人会记得你关掉了一家公司。只要你为人正直、诚实，无论顺境逆境都能处理好自己，人们就会怀念你。人生苦短，职业生涯也就那么些年。如果做一件让你痛苦的事，仅仅是为了面子，而你内心深处知道它行不通，我觉得这对你的人生来说是巨大的机会成本。对吧？

---

### [00:11:30] Lenny Rachitsky

**English:**
Yeah, that's exactly what I tell founders all the time. Life is short. There's no need to force yourself to work on this. And I really like your point of just, is it still enjoyable? Do you like working with your founders? Following this thread of the struggle training a little bit more, one of the founders that worked with you during YC, his name is Danny Alberson, shared a story how during one of the batches of YC, one of the founders raised his hand and asked you, "What is wrong with our batch? Everyone is struggling, nobody is doing well. What have we done wrong?" And you shared a story about Brex that made everyone feel a little better. Does that ring a bell and if so, can you share that?

**中文翻译:**
没错，我也经常这样告诉创始人。人生苦短，没必要强迫自己。我很喜欢你提到的“是否依然享受”和“是否喜欢合伙人”这两点。顺着这个“挣扎”的话题，一位在 YC 期间与你合作过的创始人 Danny Alberson 分享了一个故事：在某一届 YC 中，有个创始人举手问你：“我们这一届是怎么了？每个人都在挣扎，没人做得好。我们做错什么了吗？”然后你分享了一个关于 Brex 的故事，让大家感觉好多了。你还记得吗？能分享一下吗？

---

### [00:12:08] Dalton Caldwell

**English:**
That definitely happened and I think the story is the story of the Winter-17 batch. And in the Winter-17 batch, I funded something like, I don't know, 35, 40 companies in my group. So we subset them into groups. So it wasn't a lot of companies and I knew all of them really well. And founders can't help but compare themselves with other founders all the time about who's doing well and who's not doing well. And there was this one company in my group, this batch, it was called Vyond, that was their name at the time and it was a VR headset thing from these Stanford dropouts. And they basically showed up to group office hours and were just ashamed and they're like, "Our idea is horrible. We might want to shut our company down. This is really embarrassing." I had to beg them to not give up basically. And if you would've asked people in the batch what the worst company was, I think they would've said this one. Again, not because they were bad people but the founders themselves seemed despondent about how it was going.
(00:13:13):
And then funnily enough, this is in the story too, there was another startup also in my group called Cashew, which was this P2P Venmo, excuse me, in the UK and it was going really poorly also and not growing. And so if you just took this snapshot in time in the middle of the batch of who is definitely not doing well, it would clearly have been this Vyond company and this Cashew company. And so to cut to the chase, Vyond changed their idea and got really excited about it and renamed to Brex and this was Brex, which is like a decacorn. And Cashew changed their idea and renamed to something called Retool. And so out of my 35 companies, the ones that objectively seemed the worst in terms of everything is going bad, were by far, in retrospect, the most successful companies in that group.

**中文翻译:**
确实有这么回事，那是 2017 年冬季班（W17）。在那一届，我负责的小组里大约有 35 到 40 家公司。我们会把公司分成小组，所以我对他们每个人都很了解。创始人总是忍不住拿自己和别人比较，看谁做得好，谁做得差。我组里有一家公司当时叫 Vyond，是由几个斯坦福退学生做的 VR 头显项目。他们来参加小组办公时间（office hours）时垂头丧气，觉得非常丢脸，说：“我们的创意太烂了，我们想关门了，这太尴尬了。”我基本上是求着他们不要放弃。如果你当时问那一届的人哪家公司最差，我想大家都会说是这一家。倒不是因为他们人不好，而是创始人自己对现状感到绝望。
(00:13:13):
有趣的是，我组里还有另一家叫 Cashew 的初创公司，做的是英国版的 P2P 转账（类似 Venmo），当时也做得很烂，完全没有增长。所以，如果你在课程中期看一眼谁最不行，那显然就是 Vyond 和 Cashew。结果呢？Vyond 改变了主意，找到了兴奋点，改名为 Brex——也就是现在的超级独角兽 Brex。而 Cashew 也转型了，改名为 Retool。所以，在我那 35 家公司里，当时看起来最糟糕、最不顺的公司，回过头看，反而是那一组中最成功的。

---

### [00:14:08] Lenny Rachitsky

**English:**
Wow. Wait, so you're saying Brex was a VR headset company?

**中文翻译:**
哇。等等，你是说 Brex 最初是一家做 VR 头显的公司？

---

### [00:14:14] Dalton Caldwell

**English:**
They thought it was really high-tech. They want to do a really high-tech startup, and so they're like, "We're going to build a new VR headset." And yeah, they were good programmers, but they just didn't know anything about optics or the things you might want to be an expert in to build a headset.

**中文翻译:**
他们当时想做一个技术含量极高的创业项目，所以决定造一个新的 VR 头显。虽然他们是很棒的程序员，但对光学或制造头显所需的专业知识一窍不通。

---

### [00:14:26] Lenny Rachitsky

**English:**
Wow, that's an amazing story. It's a great segue to just another theme that emerged from talking to founders about advice that you've shared. A lot of people tell me you are the king of the pivot of helping people figure out how to pivot. I'm curious just what you've seen makes a good pivot.

**中文翻译:**
哇，这故事太精彩了。这正好引出了另一个主题。很多创始人都跟我说你是“转型之王”，特别擅长帮人找到转型方向。我很想知道，在你看来，什么是成功的转型？

---

### [00:14:45] Dalton Caldwell

**English:**
Usually a successful pivot gets warmer instead of colder from what you're an expert at and somehow builds on what you learned on the prior idea. Right? And so in the case of Brex, it was they had worked on a FinTech company in Brazil when they were younger, and so I'm like, "You need to work more on the thing all about and not the thing nothing about." And that was what worked for them. In the case of Retool, it was the same thing. They had built similar internal tools both at their internships as well as for Cashew. They had all these dashboards they built to operate their Venmo competitor. And so they knew a lot about what to build in the case of postprod, pivoting and through idea, they knew a lot about analytics and had strong opinions about it. And so it was much closer than what the original idea is.
(00:15:41):
In the case of Zip, Rujul knows a lot about a lot of things and he knew a lot about the crazy picture and process at Airbnb because he worked there. A good pivot is like going home. It's warmer, it's closer to something that you... And it never occurred to you that this thing you know all about would be a good idea or maybe you consciously are like, "I don't want to work on this because burnt out on it." Sometimes someone has to get over this barrier they have on why they don't want to work on a certain idea.

**中文翻译:**
通常，成功的转型是变得“更热”而不是“更冷”——也就是说，它更接近你擅长的领域，并且在某种程度上建立在你从前一个创意中学到的东西之上。以 Brex 为例，他们年轻时在巴西做过金融科技公司，所以我告诉他们：“你们应该做你们了如指掌的事，而不是一窍不通的事。”这奏效了。Retool 也是一样，他们在实习期间以及为 Cashew 开发产品时，都做过类似的内部工具。为了运营那个转账应用，他们开发了很多仪表盘。所以他们非常清楚该构建什么。
(00:15:41):
再看 Zip，创始人 Rujul 博学多才，而且因为曾在 Airbnb 工作，他非常了解那里复杂的流程。一次好的转型就像是回家。它更温暖，更接近你熟悉的东西。有时候你可能从未想过你熟悉的东西会是个好主意，或者你主观上觉得“我不想做这个，因为我已经做腻了”。有时候，人们需要克服这种心理障碍，去接受那个真正合适的想法。

---

### [00:16:18] Lenny Rachitsky

**English:**
These are amazing. I like how modest you are. I'm like, "Oh, here's a big idea." And then you just give very tactical items to look for. So essentially a good pivot in your experience is you're getting closer, warmer towards something you have actual experience in, and two, it builds on something you've done. Can be essentially the core idea of a pivot, right? Where you're...

**中文翻译:**
太棒了。我喜欢你的谦逊。我本以为你会抛出一个宏大的理论，结果你给出了非常具体的战术点。所以根据你的经验，成功的转型本质上是：第一，更接近你拥有实际经验的领域；第二，建立在你已经做过的事情之上。这基本上就是转型的核心逻辑，对吧？

---

### [00:16:38] Dalton Caldwell

**English:**
In the example of Segment, which is obviously a really big successful company, they started with something to tell your professor you were confused in class. It was software that they sold to universities. And then they ended up pivoting to something like a mixed panel competitor after two years and it's because they learned about how analytics works running their first idea, okay? And then no one wanted to adopt their mixed panel competitor. And so they were like, "We should make this JavaScript thing that you embed on your website that can send events to multiple endpoints at the same time so that way people would be willing to try our mixed panel competitor side by side with mixed panels to show that it's better." And then they were like, "Oh yeah, no one actually wants that. They just want this JavaScript to send events to different locations." And so there's no way those founders could have started with the final idea. You get what I mean?
(00:17:30):
There was no universe where they would've made up the idea for Segment because they didn't know anything about how analytics worked, but because they were grinding for multiple years and became experts on these things is a side effect of their earlier ideas. They ended up with really good unique insights.

**中文翻译:**
以 Segment 为例，这是一家非常成功的公司。他们最初做的是一个让学生在课堂上告诉教授自己听不懂的软件，卖给大学。两年后，他们转型做类似 Mixpanel 的竞争对手，因为在运行第一个项目时，他们学会了数据分析是怎么回事。结果没人想用他们的分析工具。于是他们想：“我们应该写一段嵌入网站的 JavaScript 代码，可以同时把事件发送到多个终端。这样人们就愿意把我们的工具和 Mixpanel 并排试用，从而发现我们的更好。”最后他们发现：“噢，其实没人想要那个分析工具，他们只想要这段能把数据发送到不同地方的 JavaScript 代码。”这些创始人不可能一开始就想到最终的创意。你明白我的意思吗？
(00:17:30):
在任何平行宇宙里，他们都不可能凭空想出 Segment 的点子，因为他们当时根本不懂分析。但因为他们磨练了几年，作为早期创意的“副作用”，他们成了这方面的专家。最终，他们获得了非常独特且深刻的见解。

---

### [00:17:45] Lenny Rachitsky

**English:**
I think that's a really important point there is you don't need to necessarily have that experience before you start the company, could come from trying to build the company.

**中文翻译:**
我觉得这一点非常重要：你不一定非要在创业前就拥有那些经验，经验也可以在创业的过程中积累。

---

### [00:17:51] Dalton Caldwell

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:17:53] Lenny Rachitsky

**English:**
A big question people are always wondering is, should I pivot? Is this the time to pivot? Should I keep trying this idea? What's your advice there of just, okay, now you should really be thinking about something else?

**中文翻译:**
人们经常纠结的一个大问题是：我该转型吗？现在是转型的时机吗？我该继续坚持这个想法吗？关于“什么时候该真正考虑换个方向”，你有什么建议？

---

### [00:18:02] Dalton Caldwell

**English:**
Again, this is one of those where I like to give very bespoke nuanced advice on a case by case basis to the folks in YC. But again, just to give you a preview of how I would think about it, I would look at how many more ideas the founder has on how to make it grow. If it's not going well and you're out of ideas, that is usually a good time to pivot. But when you have half a dozen or a dozen really good growth ideas that you haven't tried yet, try them. Right? Hey, give it a shot. Again, in the Airbnb story, right? They tried all sorts of stuff including cereal and conventions. They had a bunch of zany ideas on growth and they didn't run out of them. And so I think when there's still gas in the tank on an idea that might be a reason to stay the course. And when literally the founder is like, "Yeah, I don't know, I guess maybe we should pay influencers or something." When that's the kind of ideas they're coming up with, that might be a better sign to pivot.

**中文翻译:**
同样，在 YC 我喜欢根据具体情况给出非常定制化的建议。但总的来说，我会看创始人还有多少关于增长的点子。如果情况不妙且你已经无计可施，那通常是转型的时机。但如果你还有六个甚至十几个还没试过的增长好主意，那就去试试。嘿，给它个机会。回到 Airbnb 的故事，他们尝试了各种方法，包括卖麦片和利用大型会议。他们有很多疯狂的增长点子，而且层出不穷。所以我觉得，如果一个想法还有“油”，那就值得坚持。而如果创始人已经沦落到说“额，我不知道，也许我们该找网红带货吧”这种地步，那可能就是转型的信号了。

---

### [00:19:03] Lenny Rachitsky

**English:**
That is incredibly helpful. Coming back to Zip real quick, they went through I think six different pivots before they landed on this idea that is now a billion-dollar business. Is there anything from that specific journey that you find really interesting? Because they went in so many different directions like accounting, marketplaces and-

**中文翻译:**
这非常有帮助。快速回到 Zip 的例子，他们在最终确定这个价值十亿美元的创意之前，经历了大约六次不同的转型。在那个过程中，有什么让你觉得特别有趣的吗？因为他们尝试过很多方向，比如会计、平台等等。

---

### [00:19:18] Dalton Caldwell

**English:**
Yeah. I think in the example of the Zip founders, they were both such great experts and I knew Rujul really well. He actually worked with me at YC as a visiting partner. And so I was really close to Rujul and he had done this marketplace called FlightCar when he was younger, which was raised a series B, it didn't work out, but it was a really cool company. And I had a lot of confidence in his competence on running a business and executing fast and just having great instincts. He really knows the fundamentals and the problem was they weren't as clear on what market to go into, is still with me. And so I actually suggested to do something in their case, again, this is very bespoke, but my suggestion was to start by looking at what companies are publicly traded and/or owned by private equity that are large and that also are hated by their customers, and to try to intentionally find where there's a knowable big market within incumbent combined with the software is horrible.
(00:20:29):
And they did that. They basically found out about all this procurement software and what the state of the art was and that was the prompt. Again, maybe he told you this, that was basically the process.

**中文翻译:**
是的。Zip 的创始人都非常专业，我非常了解 Rujul，他曾在 YC 担任过访问合伙人。他年轻时做过一个叫 FlightCar 的租车平台，融到了 B 轮，虽然最后没成，但那是一家很酷的公司。我对他运营业务、快速执行的能力以及直觉非常有信心。他非常懂基本功，问题在于他们当时不确定该进入哪个市场。所以我给他们的建议是（这也是非常定制化的）：先去看那些规模巨大、已上市或被私募股权持有的公司，且这些公司被客户所“痛恨”。尝试去寻找一个既有的庞大市场，那里有老牌巨头，但他们的软件做得烂透了。
(00:20:29):
他们照做了。他们发现了采购软件这个领域，了解了现状。这就是那个启发点。也许他跟你提过，这就是基本过程。

---

### [00:20:41] Lenny Rachitsky

**English:**
He did tell me that. I love that example and piece of advice so much. I don't know why more people don't do this. Basically find a large incumbent with very low NPS and try to disrupt them. So straightforward.

**中文翻译:**
他确实跟我说过。我太喜欢这个例子和建议了。我不明白为什么没有更多的人这么做。基本上就是找一个 NPS（净推荐值）极低的大型老牌公司，然后去颠覆它。太直接了。

---

### [00:20:54] Dalton Caldwell

**English:**
Yeah, I mean, I can't promise that works for everyone, but again, in the very bespoke situation with Rujul, it worked really well because he actually knew exactly once he locked in on that prompt, oh man, he ran a masterclass. They did an A-plus job, was really good.

**中文翻译:**
是的，我不能保证这对每个人都有效，但在 Rujul 的案例中效果极佳。一旦他锁定了那个方向，天哪，他简直是在表演大师课。他们做得非常出色。

---

### [00:21:12] Lenny Rachitsky

**English:**
Also Lou, his co-founder, credit to him too.

**中文翻译:**
还有他的合伙人 Lou，他也功不可没。

---

### [00:21:14] Dalton Caldwell

**English:**
Of course. Sorry. Yeah. We got to give Lou the shout-out. Lou did an amazing job. I just didn't know Lou as well before he did YC. But you're right, we got to give Lou the credit.

**中文翻译:**
当然。抱歉，是的，我们必须提到 Lou。Lou 做得非常棒。只是在 YC 之前我不像了解 Rujul 那样了解他。但你是对的，Lou 功不可没。

---

### [00:21:22] Lenny Rachitsky

**English:**
I was watching your chat with Michael Seibel talking about pivots and either you or he used this phrase of you want to move towards the mountains in the desert to find the gold of a new startup idea versus the middle of the city. You're unlikely to find gold in the middle of San Francisco. Is there anything along those lines that you can share?

**中文翻译:**
我看了你和 Michael Seibel 讨论转型的视频，你们中有人用了一个比喻：你应该去沙漠中的大山里寻找创业创意的“金矿”，而不是在城市中心。你不太可能在旧金山市中心找到金矿。关于这一点，你有什么可以分享的吗？

---

### [00:21:41] Dalton Caldwell

**English:**
Yeah, I think maybe this pertains into what we see from applications and interviews, which is from where I sit seeing everything people apply to YC with and what they interview with and whatnot. People all have the same idea. Basically imagine this, imagine your information consumption where you're listening to the same podcast, wink, wink, you're reading the same people on Twitter, you're reading the same blog post. Basically you have the same information diet of all these other founders and you're friends with all the same people. Does it seem surprising then that you would all end up with similar startup ideas or similar philosophies on what makes a good startup idea? Of course you are. So this is the metaphor on cities is that if you just are following the same principles and have the same information flow into your brain, you're going to come up with the same ideas with everybody else.
(00:22:37):
And so the prompt here is to try to go more off the beaten path either from your personal experience, like in the case of Brex and Retool or Whatnot. There was no one else trying to build marketplaces for Funko Pops. Go deeper in your own personal interests or experience to find something that just your exact peer wouldn't come up with in exactly the same way. And again, the Zip example, I don't think other people were trying to build wonky procurement software. That was not an idea that we saw much of. And so again, the prompt to people is try to mix up what your information diet is or what areas of expertise you have and mine that well, versus just having all the same thoughts as everybody else. And so again, let me give you one more example.
(00:23:24):
A few years ago, startups around trucking were super new and fresh because no one was doing them and they worked really well and then it became completely conventional wisdom to do trucking related startups. I'm not trying to diss anyone, but you'll see things that become fashionable really quickly because someone found success in this unfashionable space and then it becomes fashionable.

**中文翻译:**
是的，这与我们在申请和面试中看到的情况有关。从我的角度看，大家申请 YC 的点子都大同小异。想象一下：你听着同样的播客（眨眨眼），关注着 Twitter 上同样的人，读着同样的博客文章。基本上，你和其他创始人的“信息食谱”是一样的，朋友圈也重叠。那么，你们最终产生相似的创业想法或相似的价值观，这奇怪吗？一点也不。这就是“城市”的比喻：如果你遵循同样的原则，大脑接收同样的信息流，你就会想出和别人一样的点子。
(00:22:37):
所以，这里的建议是尝试走一些“人迹罕至”的路。要么来自你的个人经验，比如 Brex、Retool 或 Whatnot（当时没人想为 Funko Pop 玩偶做交易平台）。深入挖掘你个人的兴趣或经验，去寻找那些你的同龄人不会以同样方式想到的东西。再看 Zip 的例子，我不认为当时有其他人在尝试做那种复杂的采购软件。那不是一个常见的点子。所以，我的建议是：尝试改变你的信息来源，或者深挖你的专业领域，而不是人云亦云。再举个例子：几年前，关于卡车运输的初创公司非常新鲜，因为没人做，效果也很好。但很快，做卡车相关的创业就成了“常识”。我不是在贬低谁，但你会发现有些东西会迅速变得流行，仅仅是因为有人在某个曾经冷门的领域取得了成功。

---

### [00:23:45] Lenny Rachitsky

**English:**
This is a good segue to something I definitely want to spend time on, which is you have this concept of tarpit ideas, which are essentially ideas people all gravitate towards and get stuck in and either pivot into and then can't pivot out of or try to pivot out of. And essentially it's just consistently bad startup ideas that people continue to try to start. Can you just talk about this and then what is examples of just bad startup ideas that people should stop trying to start?

**中文翻译:**
这正好引出了我非常想聊的一个话题，就是你提出的“焦油坑想法”（tarpit ideas）。这些想法吸引了所有人，但大家进去后就陷住了，要么转型进去出不来，要么想转出来却很难。本质上，这些是人们不断尝试却一直失败的创业点子。你能聊聊这个吗？有哪些是人们应该停止尝试的“烂点子”？

---

### [00:24:10] Dalton Caldwell

**English:**
For people that are familiar with this terminology from us, sometimes they get defensive and don't get what we were saying. By definition it is only a tarpit if it seems like it's not. If it's just a regular idea that is hard, that is not a tarpit. The weird aspect of what we call a tarpit idea is an idea that a lot of people come up with and then it seems like an unsolved problem and you get lots of positive feedback for. Right? And you have a really good set of arguments that it's a really good startup idea. And that's different than a bad startup idea. Do you get what I'm trying to say? A bad startup idea is, I don't know, something that is obviously bad or something where you just can't get any positive feedback on. But some of the most common tarpit would be something like building an app to coordinate with your friends to decide where to go out at night or where to meet up with people, which is really, it's coming from a good place. It's a good idea.
(00:25:10):
If you ask your friends, "Hey, would you like an app for us to coordinate to hang out more so we can be friends?" They're like, "Yeah, I would love that." You'll get all this positive feedback from the world. And man, people have been starting that startup since the '90s and so you can validate it. Part of being a true tarpit is that you can get good initial validation. Do you get what I mean? And so anyway. And honestly I worked on tarpit ideas myself as a founder, which is a music discovery. This is something I did in my first startup. Music startups are hard and trying to be like, "Oh, we're going to fix music discovery." This was classic things where you can get lots of positive feedback and even get users to work on those things, but there are aspects of it that make it a very hard idea. So does that make sense?

**中文翻译:**
熟悉我们这个术语的人有时会产生防御心理，没明白我们的意思。根据定义，只有当一个想法“看起来不像坑”时，它才是焦油坑。如果只是一个单纯很难实现的普通想法，那不是焦油坑。焦油坑的诡异之处在于：很多人都能想到它，它看起来像个未解决的痛点，而且你会得到很多正面反馈。你会有一整套逻辑来证明这是个伟大的创意。这和“烂点子”不同。烂点子是那种显而易见行不通，或者没人给你正面反馈的东西。最常见的焦油坑比如：做一个帮朋友协调晚上去哪儿玩或在哪儿见面的 App。出发点很好，也是个好主意。
(00:25:10):
如果你问朋友：“嘿，你想要个 App 帮我们多聚聚吗？”他们肯定会说：“太棒了，我想要。”你会得到全世界的正面反馈。但是，天哪，从 90 年代起就有人在做这个了。焦油坑的一部分特征就是你能得到很好的初步验证。你明白我的意思吗？老实说，我自己当创始人时也做过焦油坑项目，就是“音乐发现”（music discovery）。这是我第一家公司做的。音乐类创业很难，试图“解决音乐发现问题”是典型的焦油坑，你能得到很多反馈甚至用户，但有些本质因素让它极难成功。这能理解吗？

---

### [00:25:59] Lenny Rachitsky

**English:**
Absolutely. I'm also guilty of this. I had this startup called Localmind that allowed you to talk to people, check-in in various locations around the city, on Foursquare and Google back in the day and asked them, "How's it going?" And everyone when they used it, they're like, "Holy shit, this is the most incredible thing I've ever seen. I could see what's happening at this bar that I'm about to go to." And then they never use it again.

**中文翻译:**
完全理解。我也犯过这种错。我以前有个叫 Localmind 的初创公司，让你能和在城市各个地点签到（当时用 Foursquare 和 Google）的人聊天，问他们“那边怎么样？”大家用的时候都惊呼：“天哪，这是我见过最不可思议的东西，我能看到我要去的酒吧现在是什么情况。”然后，他们就再也不用了。

---

### [00:26:19] Dalton Caldwell

**English:**
Do you remember when Foursquare clones was all anyone worked on for-

**中文翻译:**
你还记得当时所有人都在做 Foursquare 的克隆版吗？

---

### [00:26:21] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
记得。

---

### [00:26:21] Dalton Caldwell

**English:**
Years?

**中文翻译:**
持续了好几年。

---

### [00:26:22] Lenny Rachitsky

**English:**
They told us Foursquare is going to own this. There's no way this idea you're building is going to be its own thing. And now, yeah, Foursquare is a B2B business.

**中文翻译:**
当时人们告诉我们 Foursquare 会统治这个领域，你做的这个东西不可能独立存在。而现在，Foursquare 已经变成了一家 B2B 公司。

---

### [00:26:30] Dalton Caldwell

**English:**
Yeah. And all the Foursquare clones, if they didn't pivot out of doing what they're doing, wouldn't have worked. So anyway, that's a tarpit, is just something that's super appealing and a lot of people do it. And then you can get validation and that's why is a tarpit, is it draws you in and you get stuck because it seems like it's a good idea and you get all this positive feedback.

**中文翻译:**
是的。所有的 Foursquare 克隆版，如果当时不转型，都不可能成功。总之，这就是焦油坑：它极具吸引力，很多人在做，而且你能得到验证。它把你吸进去，让你陷在里面，因为它看起来像个好主意，而且反馈极佳。

---

### [00:26:50] Lenny Rachitsky

**English:**
Along these lines, I was talking to a founder recently and she's asking me, "What causes an investor to say no to you when you're trying to raise money from them?" And I know every investor has a very different perspective on what turns them off to a startup, but is there anything that you find is just like, here, if you do these things, investors will say no.

**中文翻译:**
顺着这个话题，我最近和一位创始人聊天，她问我：“当你尝试融资时，是什么导致投资者对你说‘不’？”我知道每个投资者对初创公司的反感点都不同，但你有没有发现一些通用的规律？比如，如果你做了这些事，投资者肯定会拒绝。

---

### [00:27:09] Dalton Caldwell

**English:**
Maybe my best advice here is for founders to put themselves in the shoes of investors and just imagine what their life is like and how if you are in their shoes you would make decisions. And so given this framework, a lot of investors just don't make that many investments and as per what we talked about earlier, life is short. And so there's lots of things that an investor that in their hearts thinks it is pretty good and they're like, "Oh, I like this person and I like their pitch, but I only am going to do a few investments. And so even though I really like a lot about this, I'm going to say no." And I often think that founders think that there's some secret truth that's being held from them on why someone says no or they want more feedback. "I need feedback." That's like, well, the feedback is we didn't want to invest and it really is just that.
(00:28:05):
And so I think if you put yourself in the shoes of an investor of like, "Hey, I only could do a few of these a year, I have very limited budget." They're really just trying to pick the things that they're either personally most excited about or things that they think can be truly phenomenally big in some way. Or again, I know you do investments too, so it's that you only get so many shots as an investor. And so anything that doesn't seem like this is the one, this is the one I want to do is a no. And that that's actually why they're saying no versus, "Oh, you had a bad zoom setup or something. Oh, we didn't like what color your shirt was. We said no." I don't think that's how this actually works.

**中文翻译:**
我最好的建议是创始人应该换位思考，想象一下投资者的生活，以及如果你是他们，你会如何做决定。在这个框架下，很多投资者其实每年投的项目并不多。正如我们之前说的，人生苦短。所以很多时候，投资者内心可能觉得这个项目挺好，他们会想：“我喜欢这个人，也喜欢他们的演讲，但我每年只投几个项目。所以尽管我很喜欢这个，我还是要说不。”创始人往往觉得背后有什么不可告人的秘密，或者想要更多反馈。其实反馈就是“我们不想投”，仅此而已。
(00:28:05):
所以，如果你站在投资者的角度：“嘿，我一年只能投几个，预算有限。”他们真的只是在挑选那些让他们个人最兴奋，或者他们认为能做得极其巨大的项目。Lenny，我知道你也做投资，投资者出手的机会是有限的。所以，任何看起来不像是“就是它了”的项目，都会被拒绝。这才是他们说不的真正原因，而不是因为“你的 Zoom 背景不好看”或者“我们不喜欢你衬衫的颜色”。实际情况并非如此。

---

### [00:28:50] Lenny Rachitsky

**English:**
I think that's such a good piece of advice that it's not necessarily they don't believe in what you're doing, it's they have better options and they're waiting for something that hits the higher bar because they have a lot of options.

**中文翻译:**
我觉得这个建议太棒了。不一定是他们不相信你，而是他们有更好的选择，他们在等待那个门槛更高的项目，因为他们的选择太多了。

---

### [00:29:00] Dalton Caldwell

**English:**
Yeah. Because again, if you ask someone or put yourself in the investor's shoes, wouldn't you be making decisions the same way? Usually founders are like, "Yeah." If you do that exercise, a lot of this starts to make way more sense.

**中文翻译:**
是的。因为如果你换位思考，你难道不会做同样的决定吗？通常创始人会说：“是的。”一旦做了这个思想实验，很多事情就变得合理多了。

---

### [00:29:14] Lenny Rachitsky

**English:**
Specifically when you're evaluating startups. I wasn't going to go into this, but I think it might be interesting, is market size. How do you think about the importance of large TAM as an investor YC?

**中文翻译:**
具体到评估初创公司时，我本不想聊这个，但我觉得可能很有趣，那就是市场规模。作为 YC 的投资者，你如何看待大 TAM（总可寻址市场）的重要性？

---

### [00:29:25] Dalton Caldwell

**English:**
I think it really depends on what stage you're investing at and it's absolutely critical the later stage you get. Right? If you're going to invest in a very high valuation, it is really important. The earlier you go, the less it matters. And some of the most phenomenally good startups, if you were really pedantic about it, the TAM would be tiny. The TAM of Uber would be nothing, right? The TAM of Airbnb would've been nothing. TI funded Razorpay, which is I think the largest payment processor in India, and the TAM of that was tiny because no one was using credit cards in 2015 in India. So you had to believe that the size of the credit card industry in India would 100X. Well, guess what happened? You know what I'm saying? So I'm not saying that having a large market someday doesn't matter, of course it does eventually. But trying to be super pedantic about market size when it's a pre-seed company or someone applying to YC, it's just not something I'd put a lot of thought.
(00:30:34):
And again, Whatnot. What's the TAM of the collectible Funko Pop industry? I don't know. I don't think it's that big, man. I don't know if you did that analysis when you invested, but I think is pretty small, but I wasn't worried about it. That was the last thing I was worried about.

**中文翻译:**
我认为这取决于投资阶段。越往后期，TAM 越关键。如果你要以极高的估值投资，它非常重要。但越早期，它就越不重要。一些极其成功的初创公司，如果你当时非要较真，它们的 TAM 简直微不足道。Uber 当时的 TAM 几乎为零，对吧？Airbnb 也是。我资助了 Razorpay（印度最大的支付处理商），2015 年印度的 TAM 很小，因为当时没人用信用卡。你必须相信印度的信用卡行业会增长 100 倍。结果呢？你懂的。我不是说大市场不重要，最终肯定重要。但在种子前轮或申请 YC 阶段，过分纠结市场规模是我最不看重的事。
(00:30:34):
再看 Whatnot。Funko Pop 收藏品行业的 TAM 有多大？我不知道，我觉得没多大。Lenny，我不知道你投资时有没有做过这个分析，但我认为它很小，但我一点也不担心。那是我最不担心的事。

---

### [00:30:49] Lenny Rachitsky

**English:**
It makes so much sense that at YC you don't think about it that much because of, as you said, many startups pivot anyway. So if you like the team-

**中文翻译:**
这很有道理，在 YC 你们不太考虑这个，因为正如你所说，很多公司反正都会转型。所以如果你看好团队——

---

### [00:30:57] Dalton Caldwell

**English:**
Yeah. And I'm not saying it's not important, it's not... And the things I'm worried about is like, hey, how do you get users? Hey, how do you grow? Things like that. Are you making something people want? Those are the things I'm really worried about as opposed to, ooh, I ran an Excel model and I'm worried this might not be a big enough TAM. That's not the top of my list.

**中文翻译:**
是的。我不是说它不重要，只是……我更担心的是：嘿，你怎么获取用户？你怎么增长？你做的是人们想要的东西吗？这些才是我真正担心的，而不是跑个 Excel 模型然后担心 TAM 不够大。那不在我的优先事项前列。

---

### [00:31:15] Lenny Rachitsky

**English:**
I think it's important to acknowledge that a lot of investors are very... YC I think is unique in a lot of ways where you invest very early and you help people through this journey. A lot of investors are very focused on TAM, so you may find you're getting turned down because they don't think there's a big enough market for you to build a big business, right?

**中文翻译:**
我觉得有必要承认，很多投资者……YC 在很多方面是独特的，你们投得非常早，并陪伴他们成长。但很多投资者确实非常关注 TAM，所以你可能会因为他们觉得市场不够大而遭到拒绝，对吧？

---

### [00:31:32] Dalton Caldwell

**English:**
Yeah. Or that you're asking them to believe a crazy leap of faith that, again, they could say, "Well, it's theoretically possible you'll be able to sell more than Funko Pops, and I understand that that is your pitch, but I have other opportunities that are less risky." You know what I'm saying? A lot of founders make the argument that the TAM is big, and you can say, "Wow, that's a really interesting argument and I'm not going to argue with you about it, but no, I'm not going to..." And so again, it's hard to get someone to engage in a debate about TAM even if you have some proof points. Ultimately, a lot of investors just don't like that risk. Fair enough.

**中文翻译:**
是的。或者你要求他们进行一次疯狂的“信念飞跃”。他们会说：“理论上你确实可能卖出除了 Funko Pops 以外的东西，我理解你的说辞，但我有其他风险更小的机会。”你懂我的意思吗？很多创始人争辩说 TAM 很大，投资者会说：“哇，很有趣的观点，我不想跟你争论，但我还是不投。”所以，即使你有证据，也很难让投资者参与关于 TAM 的辩论。最终，很多投资者只是不喜欢那种风险。这很公平。

---

### [00:32:15] Lenny Rachitsky

**English:**
Fair enough. Going in a slightly different direction. So someone else that worked with you, another Lenny, Lenny Bogdonoff who started a company called Milk, and then he was head of growth at OpenAI for a bit. He asked me to ask you about things product leaders and startups should watch out for. Does that ring a bell?

**中文翻译:**
明白了。换个方向。另一位曾与你合作过的 Lenny（Lenny Bogdonoff，Milk 的创始人，曾任 OpenAI 增长负责人）让我问问你，产品领导者和初创公司应该警惕哪些事情？你有印象吗？

---

### [00:32:35] Dalton Caldwell

**English:**
I don't remember the specific office hours, but I understand the question and I of course remember Lenny. I think that the advice that he's referencing here is just how important it is to not overdelegate and for the founders to stay close to things, as well as watch out for the trap of hiring super senior people with fancy resumes, really early in a startup. I think that's what he's referencing there. And again, this is definitely one of those very basic things that we find ourselves repeating a lot where they're like, "Yeah, yeah, I get it. Don't overdelegate. We get it, Dalton." And then two years later they're like, "Wow, we overdelegated. We need to go clean that up." So that is probably the best product advice. And the folks that are really great at product, the founders that are always deeply in the weeds on product and still care a lot and are still talking to customers, no matter how late stage it gets, again, I'm sure you experienced this in Airbnb culture, but you can't delegate caring about your users and you can't delegate caring that the product is great. That is so critical.

**中文翻译:**
我不记得具体的办公时间了，但我明白这个问题，我也记得 Lenny。我想他指的是：不要过度授权，创始人要亲力亲为，以及要警惕在创业极早期就雇佣那些简历光鲜的高管。我想这就是他指的内容。同样，这是我们经常重复的基本原则之一。创始人们会说：“行行行，我知道了，别过度授权。”结果两年后他们会跑来说：“哇，我们授权过度了，现在得去收拾烂摊子。”这可能是最好的产品建议。那些真正擅长产品的人，那些无论公司发展到什么阶段都依然深入细节、关注产品并与客户交谈的创始人，才是最棒的。我相信你在 Airbnb 的文化中也感受到了：你不能把“关心用户”授权出去，你也不能把“确保产品卓越”授权出去。这太关键了。

---

### [00:33:36] Lenny Rachitsky

**English:**
To make this even more real, what is it that you see them do? It's they hire a PM too early, they hire a senior salesperson too early, what are the-

**中文翻译:**
为了更具体一点，你看到他们具体做了什么？是太早雇佣产品经理（PM），还是太早雇佣资深销售？

---

### [00:33:43] Dalton Caldwell

**English:**
Yeah, I think that you get pushed often by investors to hire executives or to scale the team or you raise all this money, you got to spend it, you got to show you're serious about growth and building a world-class organization, whatever, stuff like that. And so you end up with super nice people with super shiny resumes from big tech companies. "Oh wow, they did this amazing thing at Google." And then they hire them and then you wake up one day and you're like, "Oh wow, everything went wrong." It's not really anyone's fault, it's just that you took your eye off the ball and this is what happens to first-time founders a lot.

**中文翻译:**
是的。投资者经常会催促你雇佣高管或扩大团队，或者你融了一大笔钱必须得花掉，以此证明你对增长和建立世界级组织是认真的。于是你找来了一些简历极其漂亮、来自大厂的人。“哇，他在 Google 做过这么了不起的事。”然后你雇了他们，结果某天醒来发现：“天哪，全乱套了。”这不一定是任何人的错，只是你不再关注核心细节了。这在第一次创业的创始人身上经常发生。

---

### [00:34:24] Lenny Rachitsky

**English:**
How do you as a founder then have time to do all these things? Is there any guidance you give just like don't overdelegate, don't over hire? But also, you have 24 hours in a day? Is it just find the time, prioritize well, or is there more to it?

**中文翻译:**
作为创始人，你哪有时间做所有这些事？除了“不要过度授权”和“不要过度招聘”之外，你还有什么指导吗？毕竟一天只有 24 小时。是仅仅靠挤时间、做好优先级排序，还是有别的窍门？

---

### [00:34:39] Dalton Caldwell

**English:**
I think if you just care a lot about your customers and you care a lot about the product, your instincts are pretty good on what to spend time on. And so for example, spending tons and tons of time hanging out with investors and networking, it's probably the thing that I would be cutting. You know what I'm saying? It's what we talked about earlier. If you really love what you're doing, no one needs to tell you how to reprioritize your time. Your intuition will be correct on what you should be spending all your time on, which is being obsessed with product.

**中文翻译:**
我认为如果你真的非常关心客户和产品，你的直觉会告诉你该把时间花在哪儿。比如，花大量时间跟投资者混在一起或搞社交，可能就是我首先会砍掉的事。你懂我的意思吗？就像我们之前说的，如果你真的热爱你所做的事，没人需要教你如何重新分配时间。你的直觉会引导你把时间花在最该花的地方——也就是痴迷于产品。

---

### [00:35:12] Lenny Rachitsky

**English:**
I love that advice. This episode is brought to you by Coda and I mean that literally. I use Coda every day to help me plan each episode of this very podcast. It's where I keep my content calendar, my guest research, and also the questions that I plan to ask each guest. Also, during the recording itself, I have a Coda page up to remind myself what I want to talk about. Coda is an all-in-one platform that combines the best of documents, spreadsheets, and apps to help you and your team get more done. Now is the perfect time to get started with Coda, especially its extensive planning capabilities. With Coda, you can stay aligned and ship faster by managing your planning cycles in one location. You can set and measure OKRs with full visibility across teams and stakeholders. You can map dependencies, create progress visualizations, and identify risk areas.
(00:36:02):
Plus, you can access hundreds of pressure-tested templates for everything from roadmap strategy to final decision-making to PRDs. If you want a platform that empowers your team to strategize, plan and track goals together, you can get started with Coda today for free. And if you want to see for yourself why product teams at high-growth companies like Pinterest, Figma and Qualtrics run on Coda, take advantage of this special limited-time offer just for startups. Head over to Coda.io/Lenny to sign up and get $1,000 in credit. That's C-O-D-A dot I-O slash Lenny to sign up and get $1,000 in credit. Coda dot I-O slash Lenny. Okay, so one of your current colleagues, not former colleagues, Gustav, was on the podcast previously. His episode is, I think, the fourth most popular episode of all time currently, so no pressure.

**中文翻译:**
我喜欢这个建议。本集由 Coda 赞助，我是认真的。我每天都用 Coda 来规划播客的每一集。我在那里管理内容日历、嘉宾研究以及我计划问每个嘉宾的问题。在录音过程中，我也会打开 Coda 页面提醒自己要聊的内容。Coda 是一个多合一平台，结合了文档、表格和应用的优点，帮你和团队提高效率。现在是开始使用 Coda 的最佳时机，尤其是它强大的规划功能。通过 Coda，你可以在一个地方管理规划周期，保持步调一致并加快交付。你可以设定并衡量 OKR，让团队和利益相关者拥有完整的可见性。你可以映射依赖关系、创建进度可视化并识别风险区域。
(00:36:02):
此外，你还可以访问数百个经过实战测试的模板，涵盖从路线图策略到最终决策再到 PRD 的方方面面。如果你想要一个能让团队共同制定策略、规划并跟踪目标的平台，今天就可以免费开始使用 Coda。如果你想亲眼看看为什么 Pinterest、Figma 和 Qualtrics 等高增长公司的产品团队都在使用 Coda，请抓住这个专门针对初创公司的限时优惠。访问 Coda.io/Lenny 注册即可获得 1000 美元的抵扣额度。好了，你现在的同事（不是前同事）Gustav 之前也上过这个播客。他的那一集目前是历史上第四受欢迎的，所以别有压力。

---

### [00:36:54] Dalton Caldwell

**English:**
Oh, Cool. Okay. I don't know if I can feed with that. All right.

**中文翻译:**
噢，酷。好吧。我不知道我能不能超过他。行吧。

---

### [00:36:56] Lenny Rachitsky

**English:**
I think you can. So I asked him what is often the most common reason a startup fails? And his answer was they don't talk to customers, they don't find product market fit. They nothing else matters if they can't do that. And so his advice is talk to customers more often. So two questions here. First of all, just is there anything else you would add to why do startups fail? I know we talked about some of these already, but just what comes to mind there?

**中文翻译:**
我觉得你可以。我问过他初创公司失败最常见的原因是什么？他的回答是：他们不与客户交谈，找不到产品市场匹配（PMF）。如果做不到这一点，其他一切都不重要。所以他的建议是更频繁地与客户交谈。我有两个问题：首先，关于“初创公司为什么失败”，你还有什么要补充的吗？我知道我们已经聊了一些，但还有什么想到的吗？

---

### [00:37:23] Dalton Caldwell

**English:**
I completely agree with what Gustav said, but to look at this from a different frame, I think is that the founders lose hope. And when you and your heart is like, "Yeah, we're failing." I can see it when I'm meeting with a founder, when they resign themselves that they're failing versus. First is when like, "We got one more move in us. We got one more try." You can see in their eyes when they feel like there's more ideas or there's some last ditch Hail Mary thing. It doesn't always work, but it's almost like you have to not accept that you're going to fail. And as long as you don't accept that that's going to happen, there's usually a lot more moves you can try to save the company. Maybe it's to get profitable, maybe it's to do some other zany thing, maybe it's to launch a new product.
(00:38:17):
And so it's pretty rare, I would argue, that the cause of death is that they had lots of firepower and they were feeling really positive and they just ran out of money. That's actually more rare than founders think. It's much more common that they still have some money left. I'm not saying a lot, but some money and they're just like, "Yeah, I'm done. I'm out of ideas. I don't want to do this anymore." And again, fair enough. But do you get what I'm saying? I think founders are afraid that they're going to run out of money and that's why they're going to shut down. And it's way more common that their idea doesn't work and they have a big fight with their co-founder, and then they can't agree on what to work on, and then they just like, "I don't want to do this anymore." And they shut down. That is the most common cause of death, is something that sounds like that story.

**中文翻译:**
我完全同意 Gustav 的说法。但从另一个角度看，我认为原因是创始人失去了希望。当你内心觉得“是的，我们要失败了”时，我能看出来。当我见到创始人时，我能看出他们是已经认命了，还是觉得“我们还有一招，我们还能再试一次”。你可以从他们的眼神中看到，他们是否觉得还有新点子，或者还有最后一搏的机会。这并不总是奏效，但你几乎必须拒绝接受失败。只要你不接受失败，通常就还有很多招数可以尝试去挽救公司。也许是实现盈利，也许是做些疯狂的事，也许是发布新产品。
(00:38:17):
我认为，很少有公司是因为弹药充足、心态积极却突然没钱了而倒闭的。这比创始人想象的要少见得多。更常见的情况是，他们手里还有点钱（不多，但还有），然后他们觉得：“算了，我累了，我没主意了，我不想再做了。”这也很正常。但你明白我的意思吗？创始人害怕没钱导致倒闭，但实际上更常见的是：创意行不通，和合伙人大吵一架，无法就工作内容达成一致，然后觉得“我不想干了”，于是关门。这才是最常见的死因，听起来就像那个故事。

---

### [00:38:59] Lenny Rachitsky

**English:**
That is so interesting. And again, this comes back to your core advice. Don't die. Just don't die. We talked about this already of just sometimes it's actually okay to die. And I guess just to refresh that lesson is if you're not having fun anymore, maybe it's okay-

**中文翻译:**
太有意思了。这又回到了你的核心建议：别死掉。只要不死就行。我们之前也聊过，有时候“死掉”其实也没关系。我想重温一下那个教训：如果你不再觉得有趣了，也许放弃也是可以的——

---

### [00:39:16] Dalton Caldwell

**English:**
Yeah, you're out of ideas. You're like, "I'm done." If in your heart that you're done, you don't have to keep going through the motions. No one benefits.

**中文翻译:**
是的，如果你没主意了，心里觉得“我干完了”。如果你内心已经放弃了，就没必要再敷衍了事。这对谁都没好处。

---

### [00:39:23] Lenny Rachitsky

**English:**
And you've also seen enough cases now, you've shared a few of these where all hope was potentially lost, but they kept going and then they turned into a huge success story. And I think most people don't see those examples. I guess is there anything you can share just how often that happens, how often you see that turn around?

**中文翻译:**
你也见过很多案例，你刚才分享了几个，那些原本看似毫无希望的公司坚持了下来，最后大获成功。我想大多数人没见过这些例子。你能分享一下这种情况发生的频率吗？你经常看到这种反转吗？

---

### [00:39:41] Dalton Caldwell

**English:**
I would argue that if we define it as the company had a near death experience where it was going poorly and the founders seriously wondered if it was all going to be over, a hundred percent of the time people go through that where the founder's like, "Yeah, I guess we're done. I guess we should pack it in." And at least you feel that way at some point in your startup journey, man, everyone goes through that. And again, there's gradations, people that actually truly got down to very, very hard situations. It's still a high percentage, maybe 50%. I mean, you can ask founders, there's a lot of founders that come this close to it all being over and through sheer will just keep it going.

**中文翻译:**
我认为，如果我们把“濒死体验”定义为：公司经营不善，创始人严肃地怀疑是否一切都要结束了，那么 100% 的创业者都会经历这个阶段。在创业旅程的某个时刻，你肯定会觉得“我想我们要完蛋了，该散伙了”。每个人都会经历。当然，程度有所不同，有些人确实陷入了极其艰难的境地。即便如此，比例依然很高，大概有 50%。你可以去问问创始人，有很多创始人曾离彻底完蛋只有一线之隔，全凭意志力撑了下来。

---

### [00:40:21] Lenny Rachitsky

**English:**
That is really empowering, I imagine, for many founders hearing this of just knowing every single founder goes through, okay, I think it's actually over. Following on this real quick, the advice that Gustav shared, which is about talking to customers. I'm just going to keep trying to pull wisdom out of your head. Do you have any advice for just how to effectively talk to customers? We're always hearing, "Talk to customers. Build things they want." Easier said than done. You get a lot of asks. You get one customer asking for a lot of stuff. There's a big company that's like, "Build this thing, we'll pay a million dollars." Just do you have general guidance of just what to pay attention to and what to build versus avoid?

**中文翻译:**
这对很多正在听节目的创始人来说非常有力量，让他们知道原来每个创始人都经历过“我觉得真的完了”的时刻。快速跟进一下 Gustav 关于“与客户交谈”的建议。我打算继续挖掘你的智慧。关于如何有效地与客户交谈，你有什么建议吗？我们总听到“与客户交谈，做他们想要的东西”，但知易行难。你会收到很多需求，某个客户可能想要一大堆东西，或者有个大公司说“做这个，我们付一百万”。你有什么通用的指导，告诉大家该关注什么、该构建什么，以及该避开什么吗？

---

### [00:40:57] Dalton Caldwell

**English:**
Yeah, I think when I talked to aspiring founders about this a lot, they're like, "Yeah, yeah, yeah, I talked to customers. We get it. Cool." And I'm like, "Cool. Well, how many customers do you talk to?" And they're like, "Well." And they get really quiet. And so I think this is one of those things like, hey, you should have a healthy diet and exercise every day or whatever, where people know it and that doesn't mean they do it. And so I think to start with, you have to get out in the world and talk to people in person. And you can't just hide behind your keyboard and call that talking to customers. Right? I think a lot of folks, the inclinations are to build a landing page and buy some Instagram ads and try to get people to sign up for something. And again, maybe that's something, but I think a lot of the reason people do that is they're just shy and they don't want to put themselves out there because it's a little awkward to go talk to people.
(00:41:49):
And you have to set yourself up to go out in the physical world, get people to meet with you, get them to take you seriously, show them a product you're building. And so again, it'd be very tactical here. You can do a self-assessment. In the past month, how many in-person physical meetings have I had with potential customers? Maybe you've done a lot, I don't know, listener, maybe you have, but it's shocking how many companies I talk to, they're like, "Well, we're focused on raising our pre-seed round before we talk to customers." Things like that. And again, I think the core, core thing going on is just social anxiety and looking stupid. And I think you just got to get past that. You just got to start doing it until it doesn't feel bad anymore. Think about how stupid the Airbnb founders must have felt. They were like, "Hey, you should rent out your house and I'm going to come and sleep in your house, and here's an airbag."
(00:42:51):
The whole thing is a little awkward, right? So you got power through the awkwardness of talking to people, and once you start doing it's actually fun. And so once you get used to overcoming this awkwardness, I think people do much better at talking to customers.

**中文翻译:**
是的。当我和有抱负的创始人聊这个时，他们总说：“知道知道，跟客户交谈嘛，我们懂。”我会问：“酷，那你跟多少个客户聊过？”然后他们就沉默了。我觉得这就像“健康饮食和每天运动”一样，大家都知道，但不代表大家会去做。首先，你必须走进现实世界，面对面地和人交谈。你不能躲在键盘后面，然后管那叫“与客户交谈”。很多人倾向于做一个落地页，买点 Instagram 广告，尝试让人注册。这也许有点用，但我认为很多人这么做是因为害羞，不想把自己推出去，因为去跟陌生人说话有点尴尬。
(00:41:49):
你必须强迫自己进入物理世界，约人见面，让他们认真对待你，向他们展示你正在构建的产品。这里有个非常战术性的建议：你可以做一个自我评估。在过去的一个月里，我与潜在客户进行了多少次面对面的物理会议？也许你做了很多，我不知道，但让我震惊的是，我聊过的很多公司会说：“噢，我们正专注于在跟客户交谈前先融到种子前轮。”诸如此类。我认为核心障碍其实是社交焦虑和怕丢脸。你必须克服这一点，不断尝试，直到不再觉得难受。想想 Airbnb 的创始人当时得有多尴尬。他们说：“嘿，你应该把房子租出来，我要去你家睡觉，这儿有个气垫床。”
(00:42:51):
整件事都很尴尬，对吧？所以你必须熬过这种尴尬。一旦你开始做了，其实很有趣。一旦你习惯了克服这种尴尬，你在与客户交谈方面就会做得好得多。

---

### [00:43:08] Lenny Rachitsky

**English:**
When someone does this self-evaluation, is there a heuristic that tells you this is enough? What do you look for? Is there a number? How many per week? How many per month?

**中文翻译:**
当有人做这种自我评估时，有没有什么启发式的标准能告诉他们“这已经足够了”？你关注什么？有一个具体的数字吗？每周多少次？每月多少次？

---

### [00:43:17] Dalton Caldwell

**English:**
Yeah, I don't know if I know a good number. I think it's look at your calendar and there should be 20 or 30% of your time that the calendar says something like customer meeting, customer call, meeting with who, meeting with this person. And when the calendar is not that or it's all... Again, what you're actually doing is just buying ads to try to validate your idea, I don't think that's talking to customers. I think that's something else.

**中文翻译:**
我不知道有没有一个完美的数字。我觉得你应该看你的日历，应该有 20% 到 30% 的时间标注着“客户会议”、“客户电话”、“与某某见面”。如果日历上没有这些，或者全是……再说一遍，如果你只是在买广告来验证想法，我不认为那是与客户交谈。那是别的东西。

---

### [00:43:46] Lenny Rachitsky

**English:**
That's an awesome heuristic. So roughly fifth of your time at least should be talking to customers.

**中文翻译:**
这是一个很棒的标准。所以至少五分之一的时间应该花在与客户交谈上。

---

### [00:43:51] Dalton Caldwell

**English:**
Yeah. And again, it depends on the idea space you're working on. Some are more, some are less. So yeah, it should be a fair amount of time. And nothing substitutes for an actual conversation versus just staring at analytics dashboards.

**中文翻译:**
是的。当然，这取决于你所处的领域。有的多一点，有的少一点。总之，应该占据相当一部分时间。没有什么能替代真正的对话，盯着数据分析仪表盘是不行的。

---

### [00:44:02] Lenny Rachitsky

**English:**
Makes so much sense. So the Airbnb is a classic example of they went to New York and talked to their host and things like that. Is there another startup that comes to mind that did this really well, that found just a really cool way and hustle to talk to customers?

**中文翻译:**
很有道理。Airbnb 是个经典例子，他们去纽约和房东聊天。你还能想到其他做得特别好的初创公司吗？那些通过很酷的方式或拼劲去与客户交谈的公司？

---

### [00:44:14] Dalton Caldwell

**English:**
Well, again, some of the companies we talked about, I mean, for Brex, they were just talking to other people in their batch and that worked extremely well. Same with Retool is they just sold it inside of the YC network. I think with Zip, they were just beasts at getting companies on calls with them to ask them about procurement. And I think they had way more than 20% of their time. When you looked at their calendars, oh man, they were talking to customers a lot to build their first product and pre-selling it before they built it. Same with PostHog I guess that's a different go to market. They launched this open source thing to start with and their calendars are filled with people that were trying to implement the first open source version of PostHog or were so excited about it.
(00:44:59):
And people on Hacker News were excited about it and they had this huge influx of people that were excited that PostHog existed and had lots of feedback and web reports. It wasn't always positive, but they never lacked for people that wanted to talk to them once they launched that, which was very helpful.

**中文翻译:**
我们之前提到的一些公司就是。比如 Brex，他们当时就在和同届的其他公司聊天，效果极好。Retool 也是，他们直接在 YC 网络内部销售。至于 Zip，他们简直是“约谈怪兽”，疯狂约公司开会询问采购流程。我想他们花的时间远超 20%。看他们的日历，天哪，为了打造第一个产品，他们一直在和客户沟通，甚至在产品做出来之前就开始预售了。PostHog 也是，虽然他们的进入市场策略不同。他们先发布了开源版本，日历上排满了想要部署 PostHog 开源版或对此感到兴奋的人。
(00:44:59):
Hacker News 上的人也很兴奋，大量的人涌入，对 PostHog 的存在感到激动，并提供了大量反馈和报告。反馈并不总是正面的，但自从发布后，他们从不缺愿意跟他们交流的人，这非常有帮助。

---

### [00:45:17] Lenny Rachitsky

**English:**
On Zip, I actually have a lot of their story in one of my series on how to build a B2B startup. And what they did actually, as you know, is they just called, DMed people on LinkedIn and ask them for advice on, "Hey, we're trying to understand how you enjoy your current procurement products." And then they ended up being early beta testers. And I think they did hundreds of these. They just-

**中文翻译:**
关于 Zip，我在“如何构建 B2B 初创公司”系列文章中写了很多他们的故事。正如你所知，他们当时就是直接打电话、在 LinkedIn 上发私信请教建议：“嘿，我们想了解一下你对目前的采购产品有什么看法。”然后这些人成了早期的测试用户。我想他们做了几百次这样的尝试。他们只是——

---

### [00:45:38] Dalton Caldwell

**English:**
Oh, yeah, no, it was a numbers game. They were just grinding at this. And so yeah, that was very good.

**中文翻译:**
噢，是的，那是一场概率游戏。他们一直在死磕。所以，那做得非常好。

---

### [00:45:43] Lenny Rachitsky

**English:**
The other classic YC stories, the Collison Collision, I think it's called or the-

**中文翻译:**
另一个经典的 YC 故事是“Collison 碰撞”（Collison Collision），还是叫——

---

### [00:45:47] Dalton Caldwell

**English:**
Collison Install.

**中文翻译:**
Collison 安装（Collison Install）。

---

### [00:45:49] Lenny Rachitsky

**English:**
Oh, Collison Install. Okay. Can you tell that story briefly?

**中文翻译:**
噢，Collison 安装。好的。能简短讲讲那个故事吗？

---

### [00:45:53] Dalton Caldwell

**English:**
The Collison Install is what often happens with customers, is that they say, "Yes, I want you buy your product." And then they do not implement it, they just go quiet. There's no implementation and this is very bad if you're selling software to someone. If they never implement it, they're going to churn. You basically failed on the one yard line, okay? And so they developed this tactic to be like, "Oh, well, I'm at the neighborhood, I'll drop by your office to help you implement Stripe and just create..." Again, it was a little awkward like we talked about earlier, but you would be like, "Yeah. I'm in the neighborhood. How about I drop by?" And then they would show up and they'd be like, "Cool, cool. Can pull up your text editor?" "Oh yeah, cool. All right." "Hey, can I drive? Can I have the keyboard?"
(00:46:43):
And they would just install Stripe into the customer's website, smiling, being charming guys. And they'd be like, "Oh, that's cool. Okay. Well, can we roll out the website now?" And they basically would not go away until you finish the implementation of Stripe. And again, it was actually helpful because they were doing all this white glove service to get it implemented. That was very effective. And I think the takeaway from that story is even when you get a yes, you're not actually done with sales. You have to finish the last mile to get the thing implemented. And they were very good at that.

**中文翻译:**
“Collison 安装”针对的是客户中常见的一种情况：他们说“好，我想买你的产品”，然后就没下文了，根本不去部署。如果你是卖软件的，这非常糟糕。如果他们不部署，就会流失。你基本上是在临门一脚时失败了。于是他们开发了一种战术：“噢，我正好在附近，我顺便去你办公室帮你部署 Stripe 吧。”就像我们之前说的，这有点尴尬，但你会说：“对，我正好在附近，我能过去吗？”然后他们就真的出现了，说：“酷，能打开你的代码编辑器吗？”“噢好的。”“嘿，能让我来操作吗？键盘给我。”
(00:46:43):
他们会微笑着、很有魅力地直接帮客户把 Stripe 安装到网站上。然后说：“噢太棒了。好了，我们现在能上线网站了吗？”基本上，除非你完成了 Stripe 的部署，否则他们绝不离开。这其实很有帮助，因为他们提供了这种“白手套”式的上门安装服务。这非常有效。这个故事的启示是：即使客户说了“好”，销售也没有结束。你必须完成最后一公里，让产品真正跑起来。他们非常擅长这一点。

---

### [00:47:18] Lenny Rachitsky

**English:**
That was an incredible story. And now they're, I don't know, a hundred billion in business and that's how it all begins.

**中文翻译:**
那真是个不可思议的故事。现在他们是一家千亿规模的公司了，而一切就是这样开始的。

---

### [00:47:24] Dalton Caldwell

**English:**
Yeah. I was an early Stripe customer at my startup and yeah, Patrick would... We used Google Talk at the time. Patrick would be sending me messages on a weekly basis just checking in. And so again, it's funny how successful these folks get, but yeah, Patrick was very hands-on with all of his customers and was extremely available. I can say that because I was one of them. Yeah.

**中文翻译:**
是的。我创业时是 Stripe 的早期客户。Patrick 当时会……我们那时用 Google Talk，他每周都会给我发消息询问情况。看到这些人现在这么成功很有趣，但 Patrick 当时确实对所有客户都亲力亲为，随时待命。我可以证明这一点，因为我就是其中之一。

---

### [00:47:47] Lenny Rachitsky

**English:**
I'm sure he had social anxiety going through all that. That wasn't a comfortable thing to do, just keep pushing people to install your software and deploy.

**中文翻译:**
我敢肯定他在做这些事时也有社交焦虑。一直催促别人安装软件和部署，这绝对不是件舒服的事。

---

### [00:47:54] Dalton Caldwell

**English:**
Oh, surely not. If you want your startup to work, this is just what you got to do. Comes with the territory.

**中文翻译:**
噢，肯定不舒服。但如果你想让公司成功，这就是你必须做的。这是创业的一部分。

---

### [00:48:01] Lenny Rachitsky

**English:**
This is going to be just a way broad question and I don't know if you'll have an answer, but just are there other just patterns you find across startups that do well? This is maybe the $64 million question of just founders and what they do that ends up leading to success.

**中文翻译:**
这是一个非常宽泛的问题，我不知道你是否有答案：在那些表现出色的初创公司中，你还发现了其他模式吗？这可能是那个价值连城的终极问题：创始人做了什么最终导致了成功？

---

### [00:48:15] Dalton Caldwell

**English:**
I don't think personality types matter as much. I've seen very quiet people, very extroverted people. You name it. I've seen all sorts of personality types. So for me personally, I don't think there's a personality type that people should copy and be like, "I need to be like this person. I need to be Steve Jobs. I need to be Elon." I don't really believe in that because there's just so much variation. Tony from DoorDash is so different than a lot of folks, and Rujul is so different and Grant from Whatnot. These are all very, very different people. Patrick is a different kind of person. Ryan from Flexport. These are just very different personality types. But the thing that I would argue folks that build really big companies have in common is they just really want it and they really believe in themselves and they really believe they can make it work. And that they're somehow deep in their internal psyche, there's something that's like, "I'm the one and I won't accept this not working."
(00:49:26):
And even though objectively there's all this data coming in, this isn't working, this is bad. My employees want to quit, my executives want to quit. Whatever it is. Somewhere deep down in there, they're like, "Oh yeah, I'm going to make this work. This company is going to be big." And they just believe. And it's almost like that internal gravitational force inside of them is so large, it warps the world to bend to that will. And people start to believe it because they believe it so much and they convince their employees to believe in and they convince everyone around them that this is going to happen for them. And so again, this is not a personality trait. I'm arguing this is a core belief.

**中文翻译:**
我不认为性格类型有多重要。我见过非常安静的人，也见过非常外向的人。各种性格都有。所以对我个人来说，我不认为人们应该去模仿某种特定的性格，比如“我得像乔布斯”或“我得像马斯克”。我不信那一套，因为差异太大了。DoorDash 的 Tony、Zip 的 Rujul、Whatnot 的 Grant，他们都非常不同。Stripe 的 Patrick、Flexport 的 Ryan，性格迥异。但我认为，那些建立伟大公司的人的共同点是：他们真的非常渴望成功，他们深信自己，深信自己能做成。在他们的内心深处，有一种信念：“我就是那个人，我绝不接受失败。”
(00:49:26):
即使客观数据表明这行不通，情况很糟，员工想辞职，高管想走人。在内心深处，他们依然觉得：“不，我会搞定的，这家公司会做大。”他们就是相信。这种内在的引力场如此强大，以至于扭曲了现实，让世界屈服于他们的意志。因为他们如此坚信，周围的人、员工也会开始相信。所以，这不关乎性格，这是一种核心信念。

---

### [00:50:10] Lenny Rachitsky

**English:**
So interesting. And it connects so much to what we've been talking about. Just don't die. Don't lose hope in what you're working on. A founder hearing this might feel like, "Man, I don't know if I'm so convinced this is going to work." In your experience, how much of this is internally, they're so certain and convinced versus externally, they need to show this confidence?

**中文翻译:**
太有意思了。这和我们聊的“别死掉”、“别失去希望”紧密相连。一个创始人听到这些可能会想：“天哪，我不知道我是否真的那么确信这能成。”根据你的经验，这种确信有多少是内在的真实感受，有多少是外在表现出来的自信？

---

### [00:50:31] Dalton Caldwell

**English:**
Well, I think it's internally they're convinced. Yeah, I'm not sure it's external. But, and this is the big but, no one has this at the early stages when they don't have a good idea and they don't have customers and it's objectively not working. And so again, I know a lot of founders are like, "Well, I don't feel that way. Oh no, maybe I'm an imposter and I shouldn't do a startup." Well, of course you don't feel that way if you haven't talked to any customers and haven't built a product. But what usually happens is you pivot to a good idea where you start with a good idea that you care about and customers you care about and you launch it. And the better the product does, the more obsessed you get with your own company.
(00:51:12):
I think in the case of Stripe, I don't want to tell Patrick's story for him, but I recall him saying at some point he wasn't as sure that Stripe was going to work until they were a year or two in. And then once it started working and then they really believed in it. But it wasn't like he woke up one day and like, "Stripe is the thing. It's going to work." I think you build conviction and you have this network effect virtual cycle where you get work conviction. The more customers reflect back to you and data reflects back to you that you're on the right track.

**中文翻译:**
我认为是内在的。我不确定外在表现是否重要。但是（这是一个很大的转折），在早期阶段，当你没有好点子、没有客户、客观上行不通时，没人会有这种确信。所以我知道很多创始人会想：“我没这种感觉，糟了，也许我是个冒牌货，我不该创业。”如果你还没跟客户聊过，还没做出产品，你当然不会有这种感觉。通常发生的情况是：你转型到了一个好点子，或者你从一个你关心的好点子和客户开始，然后发布。产品表现越好，你就越痴迷于自己的公司。
(00:51:12):
以 Stripe 为例，我不想替 Patrick 讲他的故事，但我记得他曾说过，直到做了一两年后，他才确信 Stripe 能成。一旦它开始运转，他们才真正相信。并不是说他某天醒来就觉得“Stripe 就是那个天选之子，肯定能成”。我认为信念是逐渐建立的，这是一个正向循环：客户的反馈和数据证明你在正确的轨道上，从而增强了你的信念。

---

### [00:51:45] Lenny Rachitsky

**English:**
This is exactly what Scott Belsky shared in our episode when I asked him when to pivot is, do you have more conviction this is going to work or less conviction over time? And so I like that connection we just made there. Okay, so we've talked about all these way startups fail, bad ideas, tarpit ideas. I want to go to the flip side and talk about good startup ideas. So recently you put out a request for startups, which is essentially 20 categories of ideas that you want to fund, that YC wants to fund. Can you share some of these ideas that you're excited about? And basically you're looking to fund and looking for founders to work on.

**中文翻译:**
这正是 Scott Belsky 在我们那一集里分享的，当我问他什么时候该转型时，他说：“随着时间的推移，你的信念是增强了还是减弱了？”我喜欢这个关联。好了，我们聊了失败、烂点子、焦油坑。我想聊聊反面：好的创业点子。最近你发布了一份“初创公司征集令”，列出了 YC 想要资助的 20 类创意。你能分享一些让你兴奋的想法吗？

---

### [00:52:21] Dalton Caldwell

**English:**
Yeah. And so we put out the request for startups just to inspire people to maybe apply with ideas that aren't the ones that we always see. It's not prescriptive like we will only fund ideas on this list. It is not that at all. Remember what I talked about earlier with information diet? We're trying to mix up some of the information diet about what kind of ideas people might be contemplating. There aren't currently. And so a couple of the ones that we put out there, I made one about ERPs which is enterprise resource planning software. And I did that because I get so few applications on that and they're usually pretty good. And I just would love to see more people look at that and learn about what the ERPs are, just because it's so rare that people apply with that. And now I have a feeling we're going to see a lot more applications working on that. And so it worked as intended, which is to introduce this idea space to founders that didn't even know what an ERP was. Now they'll go learn about it.
(00:53:16):
Another one is we'd like to fund open source companies. And so that's one of the RFSs where if more people apply to YC with open ideas, I think we'd be pretty excited about that. Maybe founders didn't realize that that would be something we want to fund. Same with space companies. Yeah, we've had a lot of success with space companies. Several of the folks that are actually going to space right now that aren't SpaceX or YC companies. And so I think sometimes founders feel like those ideas are too bold and ambitious, but no, I'd love if more people apply with space companies. And so think about it that way, where we're trying to put out of idea spaces that perhaps someone subconsciously filtered out as what might be a good startup idea. And hopefully that creates a new set of startup ideation for the person.

**中文翻译:**
是的。我们发布这个征集令是为了启发人们，让他们不要总是申请那些我们看腻了的点子。这并不是强制性的，不是说“我们只投名单上的点子”。绝对不是。还记得我之前说的“信息食谱”吗？我们想改变一下人们思考的创意类型。比如，我写了一个关于 ERP（企业资源计划软件）的。之所以写这个，是因为我收到的这类申请太少了，但通常质量都很高。我希望更多人去了解 ERP 是什么，因为很少有人申请这个。现在我觉得我们会看到更多这方面的申请。这达到了目的：向那些甚至不知道 ERP 是什么的创始人介绍这个领域，现在他们会去学习了。
(00:53:16):
另一个是开源公司。如果更多人带着开源创意申请 YC，我们会非常兴奋。也许创始人没意识到我们也想投这个。还有太空公司。我们在太空领域取得了很多成功，现在有几家正在往太空发东西的公司（除了 SpaceX）就是 YC 出来的。有时创始人觉得这些想法太宏大、太野心勃勃了，但其实不，我希望看到更多太空公司的申请。所以，我们是想把那些可能被人们潜意识里过滤掉的领域重新摆出来。希望能激发出一套全新的创业构思。

---

### [00:54:08] Lenny Rachitsky

**English:**
And we're going to link to this page in the show notes for folks that want to explore. I'll give a couple more real quick. A way to end cancer, no big deal. Spatial computing, new defense technology, bringing manufacturing back to America. So a lot of hard science, deep tech stuff, which is maybe a new... I don't know. I imagine you guys have invested this in the past, but it feels like trend.

**中文翻译:**
我们会在节目介绍里附上链接。我再快速列举几个：终结癌症的方法（小事一桩）、空间计算、新型国防技术、将制造业带回美国。很多硬科学和深科技的东西。这感觉像是个新趋势……虽然我知道你们过去也投过，但现在感觉更明显了。

---

### [00:54:30] Dalton Caldwell

**English:**
We totally have, right? So these aren't like, "Oh, we've never invested in these before." It's more of like, "Hey, it'd be cool if we saw more applications along these lines." It would be nice because it currently feels a little bit under... There could be more startups working on this stuff.

**中文翻译:**
我们确实投过。所以这并不是说“我们以前从未投过”，而是说“如果能看到更多这方面的申请就太酷了”。因为目前感觉这些领域还有很大的空间，应该有更多初创公司在这些方面努力。

---

### [00:54:46] Lenny Rachitsky

**English:**
Yeah, instead of the tarpit ideas. A couple more real quick, better enterprise glue.

**中文翻译:**
是的，而不是那些焦油坑想法。再来几个：更好的“企业胶水”（enterprise glue）。

---

### [00:54:51] Dalton Caldwell

**English:**
Yeah, I like that idea.

**中文翻译:**
是的，我喜欢这个点子。

---

### [00:54:53] Lenny Rachitsky

**English:**
Say more about that. What does that look like?

**中文翻译:**
多聊聊这个，那是什么样的？

---

### [00:54:55] Dalton Caldwell

**English:**
The software to connect all these business systems is usually pretty brittle and janky, and there's been lots of good startups founded to solve this problem. I think there's still a lot more room for improvement and likely LLMs will improve. We'll probably be able to create better and better glue so all sorts of software systems can talk to each other. And so again, very broad idea. But yeah, I think we'll see a lot of very successful companies where that's the kernel of the idea they start with.

**中文翻译:**
连接各种业务系统的软件通常非常脆弱且难用。虽然已经有很多优秀的初创公司在解决这个问题，但我认为仍有巨大的改进空间。随着大语言模型（LLM）的发展，我们可能会创造出越来越好的“胶水”，让各种软件系统能够顺畅对话。这是一个很宽泛的想法，但我认为我们会看到很多成功的公司以此为核心创意起步。

---

### [00:55:20] Lenny Rachitsky

**English:**
Awesome. One last one. Small fine tune models as an alternative to gigantic generic ones. Yeah. Sweet. And so we'll include this link in the show notes and folks can click on each of these and there's a lot more explanation of what it is you're thinking about there. Awesome. Okay, just a couple more questions.

**中文翻译:**
太棒了。最后一个：用小型微调模型替代巨大的通用模型。好的。我们会把链接放在节目介绍里，大家可以点击查看详细解释。好了，最后还有几个问题。

---

### [00:55:37] Dalton Caldwell

**English:**
Yeah.

**中文翻译:**
好的。

---

### [00:55:39] Lenny Rachitsky

**English:**
One is just your background. So from what I've read, in the early 2000s, you were basically hanging out with some of the biggest success stories of today. Folks like Zuck and Reid Hoffman, Sam Altman, Elon, Sean Parker. This is before they really became anyone and they all became very successful. I'm curious just looking back at that, what you've noticed is consistent across these folks that ended up being really successful over time.

**中文翻译:**
一个是关于你的背景。据我所知，在 2000 年代初期，你基本上是和当今最成功的一群人混在一起：扎克伯格、Reid Hoffman、Sam Altman、马斯克、Sean Parker。那是他们成名之前的事。回过头看，你觉得这些最终大获成功的人身上有什么共同点？

---

### [00:56:06] Dalton Caldwell

**English:**
Back in 2003, being in Silicon Valley and being interested in startups, it was a really small space. There just weren't that many people that were into this stuff. And so I remember I cold emailed Reid Hoffman when LinkedIn was 12 employees and he just responded and he's like, "Oh, let's have lunch." He was just a guy and everyone else that was doing, I guess you could call it social networking, that was the people that I knew. There was a few conferences you would go to and there'd be 30 people there. It reminds me of stories about the Homebrew Computer Club. I'm not saying this is as cool. But when I read stories about what it was like when the Homebrew Computer Club existed, it was a very small number of people that all knew each other that were real weirdo outsiders that were into this stuff, okay? And so that's what in the post.com boom Bay Area startup scene, that's legitimately what it felt like.
(00:57:03):
And so I didn't think a lot about the personality traits of these people. Again, they were all pretty different people, but what they had in common is the folks that are now the really big names just had a lot of staying power. Right? So when I met Sam, he had dropped out of Stanford to work on Loot, which is hilariously a way to find people around you to hang out with. An interesting theme here, huh? He was cool. He was this really young guy and he just did that. It wasn't huge. And then he got into other stuff and ended up working at YC, ended up getting involved in hard tech and has now reinvented himself as the big mind behind AI, which again, awesome. But if I think about who he was back in the day, yeah, he was a 23-year-old working on a thing for feature phones to find friends in your neighborhood.
(00:57:58):
Their customer was Boost Mobile. I bet you could go find the commercials for Loot that Boost Mobile put out on YouTube. Those are actually pretty funny. Have you seen those commercials?

**中文翻译:**
在 2003 年，身处硅谷并对创业感兴趣，那是一个非常小的圈子。当时没多少人对这些感兴趣。我记得当 LinkedIn 只有 12 名员工时，我给 Reid Hoffman 发了一封冷邮件，他直接回了：“噢，一起吃午饭吧。”他当时只是个普通人。我认识的其他人也都在做所谓的“社交网络”。当时你去参加一些会议，现场也就 30 个人。这让我想起“自制计算机俱乐部”（Homebrew Computer Club）的故事。我不是说我们当时有那么酷，但那种感觉很像：一小群互相认识的“怪咖”局外人聚在一起搞这些东西。在互联网泡沫破裂后的湾区创业圈，真实情况就是那样。
(00:57:03):
所以我当时没怎么想过这些人的性格特征。他们都很不一样，但共同点是：那些现在的大人物都有极强的“持久力”。当我见到 Sam Altman 时，他刚从斯坦福退学去做 Loopt——搞笑的是，那也是一个寻找周围朋友聚会的应用。有趣的主题，对吧？他很酷，是个年轻人。那个项目做得不算大。后来他尝试了别的东西，去了 YC 工作，开始涉足硬科技，现在成了 AI 领域的领军人物。但回想当年，他只是个 23 岁的年轻人，在为功能手机开发一个寻找附近好友的工具。
(00:57:58):
他们的客户是 Boost Mobile。我打赌你能在 YouTube 上找到 Boost Mobile 为 Loopt 拍的广告，非常搞笑。你看过吗？

---

### [00:58:06] Lenny Rachitsky

**English:**
No, but I'm going to go check them out.

**中文翻译:**
没看过，但我打算去搜搜看。

---

### [00:58:07] Dalton Caldwell

**English:**
Anyway, it's pretty funny. So yeah, that's the real story. And then, yeah, I remember I was in downtown Palo Alto at the time, and some of the folks I was friends with were friends with Sean Parker, and this was actually before Sean Parker went to Facebook. He was part of Napster. And so one of my friends was like, "Oh, we need to get my friend a ride to the airport." And so I ended up giving Sean Parker a ride to the Oakland Airport. And again, what was he like? I don't know. He just basically sat in the back seat on the phone the whole time. But again, my point is I wasn't like, "Wow, these are going to be really big successful people that one day will be important in the world." It just felt like a bunch of nerds that really liked the internet and computers, doing things that they were interested in and were just obsessed with this.
(00:58:57):
They weren't like, "Gee, should I move to New York?" Or, "Maybe I should go to law school." It was people that were very bought in to staying working on internet companies. And so you'll see these folks just reinvent themselves multiple eras, right? Okay, like Reid Hoffman, he worked at PayPal, right? And then he did LinkedIn and then he was a VC. He's had all these different eras where it's the same person, but it's almost like a different figure, right?

**中文翻译:**
总之，挺有意思的。这就是真实的故事。我还记得当时我在帕罗奥图市中心，我的一些朋友认识 Sean Parker，那是他去 Facebook 之前的事。他当时是 Napster 的成员。我一个朋友说：“噢，我得送个朋友去机场。”结果我开车送 Sean Parker 去了奥克兰机场。他当时什么样？我不知道，他基本上全程坐在后座打电话。我的重点是，我当时并没觉得“哇，这些人将来会成为改变世界的大人物”。当时感觉就是一群热爱互联网和电脑的宅男，在做自己感兴趣的事，并且对此非常痴迷。
(00:58:57):
他们不会想“哎呀，我是不是该搬到纽约？”或者“我是不是该去读法学院？”他们是全身心投入到互联网行业的人。你会看到这些人经历了多个时代的自我重塑。比如 Reid Hoffman，他先在 PayPal 工作，然后创办了 LinkedIn，接着成了风投家。他经历了不同的阶段，虽然是同一个人，但身份完全不同。

---

### [00:59:28] Lenny Rachitsky

**English:**
There's a lot of interesting lessons there. One is that your career is long and you'll have the opportunity to do many things and you can continue to shift. In my example, this is my fourth career, I realized. I was an engineer, then a founder, then a product manager, now whatever this job is. And I think that's really common. I think the other, again, is the personality types point, which I didn't comment on, but I think it's so important that you can be super introverted and be super successful. You can be super extroverted and be very successful. And I think the key there is use your skills and strengths to achieve the same things. You don't have to be the amazing presenter on Steve Jobs type stage. You can do the same thing in a different way. And then the other point there is, again, coming back to you just need to be really excited and enjoy the work you're doing because that'll drive you forward and make you be successful. So I like that the story is a summary of so many of the things you've shared so far.
(01:00:21):
There's other two other fun stories, maybe pick one. The other one is you sold your startup to MySpace and your job was basically to save MySpace. And then the other is you're the reason Andreessen Horowitz missed out on Instagram and couldn't invest. So which of those would you want to share?

**中文翻译:**
这里有很多有趣的启示。第一，职业生涯很长，你有机会做很多事，并且可以不断转型。以我为例，我意识到这是我的第四份职业了：我当过工程师、创始人、产品经理，现在在做这份工作。我觉得这很普遍。第二，还是性格类型的问题，虽然我刚才没评论，但我认为这很重要：你可以非常内向且成功，也可以非常外向且成功。关键是利用你的技能和优势去达成目标。你不必非得成为乔布斯那种舞台演讲大师，你可以用不同的方式做到同样的事。第三，还是回到那一点：你需要对自己所做的事感到兴奋和享受，因为那是驱动你前进并走向成功的动力。我喜欢这个故事，它总结了你之前分享的很多观点。
(01:00:21):
还有两个有趣的故事，选一个讲吧。一个是：你把初创公司卖给了 MySpace，而你的工作基本上是去“拯救”MySpace。另一个是：你是 Andreessen Horowitz（a16z）错过投资 Instagram 的原因。你想分享哪一个？

---

### [01:00:41] Dalton Caldwell

**English:**
Well, it's the same story. And the way that it's the same story is my second company... Basically, I sold my first company to MySpace. It was the music company that I worked on. And they recruited a new CEO who was formerly the COO of Facebook called Owen Van Natta. So again, hilariously part of the same little circle of people. And Owen was like, "Okay, we need to fix MySpace. Rupert Murdoch's got the juice. He wants me to fix it. We're going to do it. So come up with some ideas." And the best idea that I could come up with at the time was doing something around mobile photo sharing, something like Twitter, but for photos. And I figured with MySpace's user base, that would work pretty well. This was in 2010, so it was right as the App Store was getting big, and I had a lot of success in the App Store with imeem. It was one of the top downloaded music apps. And so I was like, "Wow, the App Store was really good." And I was really into apps being the thing.
(01:01:40):
And at this time, Facebook was a little early on. They were trying to do cross-platform mobile apps, if you recall. And their apps were not great. This was, again, ancient history. So that was my plan. And then immediately Owen Van Natta was fired, and so I didn't even really get onboarded. And so I just left. I think I worked in MySpace for a month because the person that acquired my company got fired and I think the whole word chart got fired. I didn't even know who to talk to. It was really great. It was a great experience. You know what I'm saying? I wasn't really sure who my point of contact was at that point. I don't think they knew either. It was just a mess.

**中文翻译:**
其实这是同一个故事。我的第二家公司……基本上，我把第一家公司（一家音乐公司）卖给了 MySpace。他们招了一个新 CEO，叫 Owen Van Natta，他以前是 Facebook 的 COO。搞笑吧，又是同一个圈子的人。Owen 说：“好，我们需要修复 MySpace。鲁伯特·默多克给了支持，他想让我搞定。我们要大干一场，想点主意吧。”我当时能想到的最好主意是做移动端照片分享，类似照片版的 Twitter。我觉得利用 MySpace 的用户群，这会很有效。那是 2010 年，App Store 刚开始壮大，我的 imeem 在 App Store 取得了巨大成功，是下载量最高的音乐应用之一。所以我当时觉得 App Store 前途无量，我非常看好 App。
(01:01:40):
当时 Facebook 还没反应过来，如果你还记得，他们当时在尝试做跨平台的移动应用，体验很差。这都是陈年往事了。这就是我的计划。结果 Owen Van Natta 很快就被解雇了，我甚至还没正式入职。于是我也走了。我在 MySpace 大概只待了一个月，因为收购我公司的人被开了，整个组织架构都乱了。我甚至不知道该找谁说话。那是一段很棒的经历（讽刺地），你懂我的意思吗？我当时完全不知道我的对接人是谁，我想他们自己也不知道。简直一团糟。

---

### [01:02:16] Lenny Rachitsky

**English:**
Just message Tom.

**中文翻译:**
直接给 Tom 发消息啊（MySpace 创始人）。

---

### [01:02:19] Dalton Caldwell

**English:**
No, no. He was long gone. Seriously. I know you're kidding. But no, literally, I don't know who was left at that point. Tom was long gone. And so I was like, "Well, I should just do a new startup and I should work on something like what I was thinking about." And I ended up starting the company and quickly was able to raise an angel around because people remembered my company from the first one. And the major investor we had was Andreessen Horowitz. This is one of their first board seat investments, like Marc Andreessen was on my board. And again, I have my own set of stories about that, but it was interesting experience and we launched it in... I think we got half a million or a million users. You can go find tech print articles about it. We launched on Android and iOS and it was mobile photo sharing, and actually it was growing pretty well. Okay?
(01:03:11):
And then what happened is there was another portfolio company called Bourbon, which was originally a ForceWare clone that was built by these two guys. And they decided to pivot out of that and into what... Which was pretty similar to my thing. Again, fair enough, that's just how this works. And they did something smart. Again, this is just me talking, I don't know what their version of the story is. But what I think they did that was smart is if you looked on the paid app store charts, the number one app was Hipstamatic and Hipstamatic cost money. And what do we know about what people want? They want things that are free that cost money, right? And so they basically built a pretty legitimate knockoff of the Hipstamatic filters, combining it with a social graph, and they launched it and it pretty quickly took off. So of course this is Instagram, right? And so it took off really quickly and that was a wild experience for me to be like, "Oh, this seems familiar."
(01:04:07):
And basically because Andreessen Horowitz had invested in my company, was on the board, even though they were investors in Instagram, that was a conflict and they didn't do the deal. And then for whatever reason, this became a big source of Silicon Valley gossip, which was like, "Wow, I can't believe this happened." And so it was just a really weird experience for me as a founder to be right in the middle of something that became culturally so important.

**中文翻译:**
不不，他早就走了。说真的，我知道你在开玩笑，但当时真的不知道还剩下谁。Tom 早就离开了。于是我想：“好吧，我应该自己再创一次业，做我之前想的那个东西。”我创办了公司，很快就融到了天使轮，因为大家还记得我第一家公司。我们主要的投资者是 a16z。这是他们最早的董事会席位投资之一，Marc Andreessen 就在我的董事会里。关于那个我有很多故事，那是一段有趣的经历。我们发布了产品，大概获得了 50 万到 100 万用户。你现在还能搜到相关的科技报道。我们在 Android 和 iOS 上发布，做移动照片分享，增长得其实挺不错。
(01:03:11):
结果发生了什么呢？a16z 投的另一家公司叫 Burbn，最初是两个小伙子做的 Foursquare 克隆版。他们决定转型，做出来的东西……和我的非常像。这很公平，创业就是这样。他们做了一件聪明的事（这只是我的看法，我不知道他们的版本）：当时付费应用榜单的第一名是 Hipstamatic，它是要花钱的。而我们知道人们想要什么？他们想要免费的付费级产品。于是他们基本上做了一个非常正宗的 Hipstamatic 滤镜仿品，并结合了社交图谱。他们发布了，然后迅速走红。没错，那就是 Instagram。它起飞得非常快，对我来说那是一段疯狂的经历：“噢，这看起来很眼熟。”
(01:04:07):
基本上，因为 a16z 已经投了我的公司并占有董事会席位，尽管他们也是 Instagram 的早期投资者，但存在竞争冲突，所以他们没能跟进 Instagram 后来的融资。出于某种原因，这成了硅谷的一大八卦：“哇，真不敢相信发生了这种事。”作为一名创始人，身处这样一个后来具有巨大文化影响力的事件中心，感觉真的很奇妙。

---

### [01:04:37] Lenny Rachitsky

**English:**
I imagine there's a bullseye in your back from a16z for a little bit.

**中文翻译:**
我猜 a16z 当时可能有点“记恨”你。

---

### [01:04:42] Dalton Caldwell

**English:**
Oh, I don't actually think they care. I don't think they held it against me because what did I do wrong?

**中文翻译:**
噢，我不觉得他们在乎。我不觉得他们会怪我，因为我做错了什么呢？

---

### [01:04:50] Lenny Rachitsky

**English:**
It's true.

**中文翻译:**
也是。

---

### [01:04:50] Dalton Caldwell

**English:**
I started a company. You know what I'm saying? Obviously there was some frustration, but I was guy who had a company that they invested in. I don't know. I didn't feel didn't much higher for them. I think this is just how life works.

**中文翻译:**
我只是创办了一家公司。你懂我的意思吗？显然会有一些挫败感，但我只是他们投资的一家公司的创始人。我没觉得他们对我有什么敌意。我觉得生活就是这样。

---

### [01:05:06] Lenny Rachitsky

**English:**
Yeah. I wonder if they changed their conflict policies after that at all.

**中文翻译:**
是的。我好奇在那之后他们有没有修改关于利益冲突的政策。

---

### [01:05:10] Dalton Caldwell

**English:**
I don't think so. I think this has happened multiple other times, but those aren't my stories to tell.

**中文翻译:**
我觉得没有。我想这种事后来还发生过多次，但那不是我的故事，我就不讲了。

---

### [01:05:17] Lenny Rachitsky

**English:**
And by the way, I don't know if you mentioned the name of your startup, it was called PicPlz, right?

**中文翻译:**
顺便提一下，我不知道你刚才有没有提到你那家公司的名字，是叫 PicPlz，对吧？

---

### [01:05:21] Dalton Caldwell

**English:**
Yeah, it's called PicPlz. Yeah.

**中文翻译:**
是的，叫 PicPlz。

---

### [01:05:21] Lenny Rachitsky

**English:**
Great. Okay. So for the final phase before we get to very exciting lighting round, I have these two segments, recurring segments. I have failure corner and contrarian corner. We can do both or we can pick one or the other. Failure corner, share a story of a time in your career where you failed and when you learned from that experience. Contrarian corner, what's something you believe that most other people don't believe?

**中文翻译:**
太好了。在进入激动人心的闪电轮之前，我们有两个固定环节：“失败角落”和“非主流观点角落”。我们可以都做，也可以选一个。“失败角落”是分享你职业生涯中的一次失败经历以及学到的教训。“非主流观点角落”是分享一个你深信不疑但大多数人并不认同的观点。

---

### [01:05:45] Dalton Caldwell

**English:**
Yeah, I think for contrarian corner, I know where I would start and I think it's relevant for your listener. I think this is relevant to this and you could argue this isn't contrary, but here's what I think. I think growth and growth hacking and doing all this analytics, A/B testing stuff, is a total waste of time for very early startups. And that one of the weird things about having lots of startup advice on the internet, again, this is one of the reasons we started making videos at YC, is a lot of the advice was catered towards later stage companies. Like, "Oh, here's how you set up your board and here's how you motivate your sales team." It was all aimed at series A, series B founders, and not for seed stage founders. The problem was seed stage founders would consume all the later stage advice and get really confused.
(01:06:35):
And so the anti-pattern I see is there are lots of founders that are very familiar with your awesome work, which again, I really recommend, I like it. But when you have no customers and you're reading Lenny's guides on how to set up split testing and how you did growth at Airbnb, oh man, that is so dumb. That is so not helpful. And so you see this inclination away from getting a first customer, getting one customer and talking to that person, and instead they have all this really complex growth hacking theory. I think this also happens if you worked in big tech where your product already has scale. And so if you work at Facebook and your job is to launch new little features, yeah, of course you should make heavy use of analytics and A/B testing and split testing and feature flags. Yeah, yeah, yeah, makes sense. But when you have no users, what are you doing? So do you think that's contrary? What do you think? I'm just trying to argue this advice applied to a startup that's too early is actively not helpful.

**中文翻译:**
关于“非主流观点”，我想从一个对你的听众很有意义的点开始。你可能会争辩说这并不非主流，但我认为：对于极早期的初创公司来说，所谓的增长、增长黑客、数据分析、A/B 测试这些东西，完全是在浪费时间。互联网上有大量的创业建议（这也是我们在 YC 开始拍视频的原因之一），但很多建议是针对后期公司的。比如“如何组建董事会”、“如何激励销售团队”，这些都是针对 A 轮、B 轮创始人的，而不是种子轮。问题是，种子轮创始人吸收了所有这些后期建议，结果变得非常困惑。
(01:06:35):
我看到的一种反模式是：很多创始人非常熟悉你（Lenny）的优秀作品（我真的很推荐，我也很喜欢）。但当你一个客户都没有时，你却在读 Lenny 关于如何设置拆分测试、Airbnb 当时是如何做增长的指南，天哪，那太蠢了。那一点帮助都没有。你会看到人们不再关注如何获取第一个客户、如何与那一个客户交谈，而是沉迷于复杂的增长黑客理论。如果你在大厂工作过，这种情况更容易发生，因为那里的产品已经有规模了。如果你在 Facebook 工作，你的工作是发布小功能，那你当然应该大量使用分析、A/B 测试和功能开关。但当你没有用户时，你在干什么？你觉得这算非主流观点吗？我只是想说，把这些建议应用到太早期的公司身上，实际上是有害无益的。

---

### [01:07:38] Lenny Rachitsky

**English:**
I think it's contrarian for many people. 100%. I also 100% agree with it. It makes me feel like I need to, at the top of my post, share here's who this is for. If you're earlier than this, ignore it. If you're later than this, ignore it.

**中文翻译:**
我觉得对很多人来说这确实很非主流。我 100% 同意。这让我觉得我应该在文章开头注明：这是给谁看的。如果你还没到这个阶段，请忽略；如果你已经过了这个阶段，也请忽略。

---

### [01:07:49] Dalton Caldwell

**English:**
I mean, again, I'm not saying you do anything wrong, but imagine if the OG Airbnb founders took all of your current advice and applied it when they had four users and they knew their names and they were trying to run complicated growth hacking split testings.

**中文翻译:**
我不是说你做得不对，但想象一下，如果 Airbnb 的创始人在只有 4 个用户、且知道他们名字的时候，就拿你现在的建议去搞复杂的增长黑客拆分测试，那会是什么样。

---

### [01:08:03] Lenny Rachitsky

**English:**
Yeah. Maybe just to clarify when you talk about growth hacking. So obviously when you're starting something, say a consumer app, you need to get a bunch of users somehow. What's your sense of just when you say don't do this sort of thing, but this is okay? What falls in those buckets?

**中文翻译:**
是的。也许可以澄清一下你说的“增长黑客”。显然，当你开始做一个消费级应用时，你确实需要以某种方式获取用户。在你看来，哪些事是不该做的，哪些是可以做的？

---

### [01:08:20] Dalton Caldwell

**English:**
I think it depends on the idea. I think in the case of Whatnot, it was consumer app and they needed to get users. But they were very intellectually honest on the metrics for how you get a marketplace off the ground. And they didn't just go dump all their money into Instagram ads. They effectively knew they needed to focus on buyers and on the buy side and build momentum on the buy side. They really understood marketplaces. And so for consumer, I think it's having a sophisticated view of how you get the consumer company off the ground. I think if you look at the Facebook story, them getting a hundred percent penetration on the Harvard campus first instead of launching overall. Again, good strategy, would recommend that strategy. So again, the way to extrapolate that is know what your comps are of what companies you... Or type is, and then look at what they did on the zero to one and ignore what they do today. Right?
(01:09:20):
Don't pay attention to what Facebook does today if you're a brand new startup founder, pay attention to Facebook when they were getting their first thousand users. What were those tactics?

**中文翻译:**
我认为这取决于创意。以 Whatnot 为例，它是消费级应用，需要用户。但他们对如何启动一个平台市场的指标非常诚实。他们没有把钱全砸在 Instagram 广告上。他们清楚地知道需要专注于买家端，在买家端建立势头。他们非常懂平台市场。所以对于消费级产品，关键是对于如何启动公司有一套成熟的见解。看看 Facebook 的故事，他们先在哈佛校园实现了 100% 的渗透，而不是直接全网发布。这是个好策略，我推荐这种策略。所以，推而广之的方法是：找到你的对标公司，看他们在“从 0 到 1”阶段做了什么，忽略他们今天在做什么。对吧？
(01:09:20):
如果你是一个全新的创始人，不要关注 Facebook 今天在做什么，去关注 Facebook 获取前 1000 个用户时用了什么战术。

---

### [01:09:28] Lenny Rachitsky

**English:**
I feel like this should be its own episode where we just go into how to get your first thousand users. I know there's a video actually we'll link to that Gustav made with YC's advice on how to get your users. Did you want to visit failure corner or not? Or shall we move on?

**中文翻译:**
我觉得这可以单独做一集，专门讲如何获取前 1000 个用户。我知道 Gustav 拍过一个关于 YC 建议如何获取用户的视频，我们会附上链接。你想聊聊“失败角落”吗？还是我们继续？

---

### [01:09:43] Dalton Caldwell

**English:**
I failed at tons of stuff. As an investor, I make lots of bad investments as well as good ones. I think in my startups I pivoted a lot and a lot of things I did didn't work out. And so again, I just gave you a specific story with PicPlz, right? You just heard a specific story there. I guess what I learned is that you just can't let it get to you too much and you got to keep going. And that if you keep going, no one really remembers those as much and it doesn't really define you. Fear of failure shouldn't dominate all of your thoughts. And instead you should use your energy and positivity to keep trying to do good work, right? Because back in the day, if I would've been like, "Well, I guess startups aren't for me, I guess tech isn't for me." I wouldn't have had a career doing any of this stuff. I wouldn't be working at YC, I wouldn't be advising companies, right?
(01:10:36):
So I always had to have in my life a lot of optimism and energy and use that energy and motor to keep me going. And it served me really well, right? Even if lots of stuff I tried didn't work and continue to not work. Again, obvious stuff I know, but yeah, that doesn't mean it's not true, even though it's obvious.

**中文翻译:**
我失败过无数次。作为投资者，我投过很多烂项目，也投过好项目。在创业时，我转型过很多次，很多尝试都失败了。刚才我讲了 PicPlz 的故事，那就是一个具体的例子。我学到的是：你不能让失败过度打击你，你必须继续前进。如果你坚持下去，没人会记得那些失败，失败并不能定义你。对失败的恐惧不应占据你的全部思绪。相反，你应该利用你的能量和积极性继续尝试做出好的工作。因为如果当年我觉得“哎呀，看来创业不适合我，科技圈不适合我”，我就不会有现在的职业生涯，不会在 YC 工作，也不会为公司提供建议。
(01:10:36):
所以我的人生中总是充满乐观和能量，并利用这种能量作为驱动力。这对我很有帮助。即使我尝试的很多东西都没成，或者现在依然没成。我知道这些道理很显而易见，但显而易见并不代表它不是真理。

---

### [01:10:58] Lenny Rachitsky

**English:**
I feel like that's a recurring theme here and I love that it's another version of just how not to die. There's the startup itself that shouldn't die, and then there's your just drive and motivation to keep going and try new things when things don't work out. I love all the recurring themes and messages for people here. Dalton, is there anything else you want to leave listeners with before we get to a very exciting lightning round?

**中文翻译:**
我觉得这是今天的一个反复出现的主题，我喜欢这个版本的“如何不死”。不仅是公司不该死掉，你的动力和尝试新事物的积极性也不该死掉。我喜欢这些反复出现的信息。Dalton，在进入闪电轮之前，你还有什么想留给听众的吗？

---

### [01:11:20] Dalton Caldwell

**English:**
Yeah, I guess the final thought is if someone wants to do a startup and doesn't know where to start, just to give you permission to talk to potential customers and try to pre-sell something before you write code and have those conversations. I think so many folks don't know where to begin on starting a startup, and my tactical advice is start doing customer validation first versus building a PowerPoint deck, versus trying to raise money versus all these other things. I think a lot of people don't use that strategy, and basically if you find people that are really excited and you do line up customers, that is a great green light that it is time to do a startup, right? That can get you down the path. So yeah, I think that's my final advice.

**中文翻译:**
是的，最后的想法是：如果有人想创业但不知道从哪儿开始，我想“批准”你去和潜在客户交谈，在写代码之前尝试预售一些东西。很多人不知道创业的第一步该做什么，我的战术建议是：先做客户验证，而不是做 PPT、尝试融资或做其他事。很多人不用这个策略。基本上，如果你发现人们真的很兴奋，并且你已经排好了客户，那就是创业的绝佳信号。这能带你走上正轨。这就是我最后的建议。

---

### [01:12:09] Lenny Rachitsky

**English:**
And then with that, when does the building come in? Is it build it while you're talking, build it before you... It depends on basically-

**中文翻译:**
那么，什么时候开始构建产品呢？是边聊边做，还是在……这取决于——

---

### [01:12:15] Dalton Caldwell

**English:**
Build it once you have some conviction and then you're like, "Oh, I think I would have a customer. I think that at least one person would use this thing I want to build. At least one."

**中文翻译:**
一旦你有了信念，觉得“噢，我想我会有一个客户，我想至少会有一个人使用我要做的这个东西”，那就开始做。至少有一个人就行。

---

### [01:12:23] Lenny Rachitsky

**English:**
I love it. I love the simplicity and pragmatism of all of your advice. Dalton, welcome to the very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
太棒了。我喜欢你所有建议中的简单和务实。Dalton，欢迎来到激动人心的闪电轮。我有 6 个问题，准备好了吗？

---

### [01:12:33] Dalton Caldwell

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### [01:12:34] Lenny Rachitsky

**English:**
What are two or three books that you recommend most to other people?

**中文翻译:**
你最推荐给别人的两三本书是什么？

---

### [01:12:38] Dalton Caldwell

**English:**
I think a lot of founders are afraid of doing sales and they don't know how to do sales, and they think they need these really experienced sales coaches and they need all this training, and I'll be like, "Well, go on to Amazon and find the most popular sales books like Getting to Yes that everyone reads, and just read those and that'll get you 80% of the way there." You know what I'm saying? They want to hire someone for millions of dollars to give them sales coaching. I'm like, "Well, have you read these really basic sales books?" And they're like, "No." And so I think that's a low cost way to go on Amazon, Getting to Yes and a few other of the top sellers, I forget the names, and just read those, and that is your crash course on how to be great at sales.

**中文翻译:**
我觉得很多创始人害怕做销售，也不知道怎么做。他们觉得需要资深的销售教练和大量培训。我会说：“去亚马逊找那些最畅销的销售书籍，比如每个人都读过的《谈判力》（Getting to Yes），读完这些你就能掌握 80% 了。”你懂我的意思吗？他们想花几百万请人做销售辅导，我会问：“你读过这些最基础的销售书吗？”他们说：“没有。”所以我觉得去亚马逊买本《谈判力》和另外几本畅销书是成本最低的方式，那是你成为销售高手的速成课。

---

### [01:13:16] Lenny Rachitsky

**English:**
Awesome. There's also this book called Founding Sales that I imagine you're familiar with. Pete Kazanjy was on the podcast talking about that and that's something I always recommend because it's just like, "How founders can do sales."

**中文翻译:**
太棒了。还有一本叫《Founding Sales》的书，我想你应该熟悉。Pete Kazanjy 曾在播客里聊过，我也一直推荐，因为它讲的就是“创始人如何做销售”。

---

### [01:13:26] Dalton Caldwell

**English:**
Start there.

**中文翻译:**
从那儿开始。

---

### [01:13:26] Lenny Rachitsky

**English:**
Start there. Great. We'll link to that. Do you have a favorite recent movie or TV show that you really enjoyed?

**中文翻译:**
从那儿开始，太好了。我们会附上链接。你最近有什么非常喜欢的电影或电视剧吗？

---

### [01:13:33] Dalton Caldwell

**English:**
This may be warping what you're asking for, but I like to watch old shows a lot, and so I keep rewatching The Sopranos and the Wire, and it always is different to me every time and things like that. I think here's a silly answer. I've been really enjoying watching old episodes of Columbo, which was a television show from the '70s and '80s. I don't know why, I don't even know if this is destructive, but for some reason, I'm really into that right now. It's very old episodes of Columbo.

**中文翻译:**
这可能不是你想要的答案，但我喜欢看老剧。我会反复看《黑道家族》（The Sopranos）和《火线》（The Wire），每次看都有新感受。这里有个很傻的答案：我最近非常喜欢看老版的《神探可伦坡》（Columbo），那是 70、80 年代的剧。我不知道为什么，甚至不知道这算不算浪费时间，但出于某种原因，我现在非常迷这个。

---

### [01:13:59] Lenny Rachitsky

**English:**
You're an old soul, Dalton.

**中文翻译:**
Dalton，你有个老灵魂。

---

### [01:14:01] Dalton Caldwell

**English:**
I guess. I don't know. It just feels like a time machine to a different time when I watch these things.

**中文翻译:**
也许吧。我不知道。看这些东西感觉就像坐上了通往另一个时代的时光机。

---

### [01:14:06] Lenny Rachitsky

**English:**
Definitely, maybe one of the most unique answers yet.

**中文翻译:**
确实，这可能是目前最独特的答案之一。

---

### [01:14:10] Dalton Caldwell

**English:**
Fair enough.

**中文翻译:**
好吧。

---

### [01:14:11] Lenny Rachitsky

**English:**
Columbo.

**中文翻译:**
《神探可伦坡》。

---

### [01:14:12] Dalton Caldwell

**English:**
Well, again, I guess I'm not trying to give you an answer where I sound super clever-

**中文翻译:**
好吧，我不是想给出一个听起来很聪明的答案——

---

### [01:14:15] Lenny Rachitsky

**English:**
No, I love this.

**中文翻译:**
不，我喜欢这个答案。

---

### [01:14:16] Dalton Caldwell

**English:**
I'm telling you the real answer. So that's actually what I'm watching.

**中文翻译:**
我告诉你的是真实答案。我确实在看这个。

---

### [01:14:19] Lenny Rachitsky

**English:**
It does actually sound very sophisticated and clever. Do you have a favorite interview question that you like to ask, I guess founders in this context?

**中文翻译:**
这听起来其实很深奥、很聪明。你有什么最喜欢的面试问题吗？在这个语境下应该是问创始人的。

---

### [01:14:28] Dalton Caldwell

**English:**
I don't really believe in trick questions, and I think I just start with, "Hey, so tell me about what you're working on." Or, "What have you learned since you started?" Again, none of these are trick questions, but I think you can get the most honest and interesting answers by asking the most straightforward basic things and having that be a blank slate for their answers to draw on. You know what I'm saying? So I like the most simple prompts and let them take the conversation where they want to go.

**中文翻译:**
我不相信脑筋急转弯。我通常会以“嘿，跟我说说你正在做的事”或者“自从开始创业以来，你学到了什么？”开始。这些都不是陷阱题，但我认为通过问最直接、最基本的问题，并给他们留白，你能得到最诚实、最有趣的回答。你懂我的意思吗？我喜欢最简单的提示，让他们主导对话的方向。

---

### [01:14:56] Lenny Rachitsky

**English:**
I know this probably is a very big question, but just what do you look for in their answer that gives you a sense of this is a good or bad answer?

**中文翻译:**
这可能是一个很大的问题，但你从他们的回答中寻找什么，来判断这是一个好回答还是坏回答？

---

### [01:15:05] Dalton Caldwell

**English:**
For YC interviews?

**中文翻译:**
指 YC 面试吗？

---

### [01:15:05] Lenny Rachitsky

**English:**
Yeah. And I know this is its own podcast episode.

**中文翻译:**
是的。我知道这又可以单独做一集。

---

### [01:15:08] Dalton Caldwell

**English:**
I think evidence that they actually have thought about it. As per I said earlier, that they've done research, that they have opinions, that they care about it. Right? Sometimes when people answer questions, you can just tell that it's really superficial, and they haven't put much care or soul into their answers.

**中文翻译:**
我认为是“他们确实思考过”的证据。正如我之前说的，他们做过研究，有自己的见解，并且真的在乎。有时人们回答问题时，你能感觉到非常肤浅，他们没有在答案中投入太多的心思或灵魂。

---

### [01:15:31] Lenny Rachitsky

**English:**
Awesome. Do you have a favorite product that you've recently discovered that you really like?

**中文翻译:**
太棒了。你最近有没有发现什么非常喜欢的电子产品或应用？

---

### [01:15:35] Dalton Caldwell

**English:**
I like my Oura ring and my Apple Watch and all that good stuff. I've been a fan. There's a YC clinic called SiPhox, S-I-P-H-O-X, I just sign up for, and they do at-home blood testing. And basically I'm trying to sync that at-home blood testing thing into all my other devices. I don't know. I really enjoy all the stuff that Apple and other startups are working on and YC companies are working on around personal health. And so yeah, those are products I'm into.

**中文翻译:**
我喜欢我的 Oura 戒指和 Apple Watch。我一直很迷这些。有一家叫 SiPhox 的 YC 公司，我刚注册了，他们做居家血液检测。我正尝试把居家血检的数据同步到我所有的设备上。我非常喜欢 Apple 以及其他初创公司（包括 YC 公司）在个人健康领域所做的努力。这些是我感兴趣的产品。

---

### [01:16:05] Lenny Rachitsky

**English:**
SiPhox. Okay. And wait, then you do a needle and stuff and you take your own blood?

**中文翻译:**
SiPhox。等等，那你得用针扎自己取血吗？

---

### [01:16:09] Dalton Caldwell

**English:**
It's this little tiny needle. It doesn't hurt at all. It takes a few drops of blood and you do it at home and you mail it in and then it has all these blood tests. It's actually really cool. Yeah. It was one of those cases where I saw it and then I later was like, "Oh, wait, that's a YC company." Basically, I became a customer and was pleasantly surprised that it's a YC company.

**中文翻译:**
是一根非常小的针，一点也不疼。取几滴血，在家完成，然后寄回去，就能得到各种血液检测报告。真的很酷。我是先成了他们的客户，后来才发现：“噢等等，这是一家 YC 公司。”

---

### [01:16:35] Lenny Rachitsky

**English:**
And I think I found it. So it's S-I-P-H-O-X health dot com.

**中文翻译:**
我想我找到了，是 siphoxhealth.com。

---

### [01:16:38] Dalton Caldwell

**English:**
Yeah, it really rolls off the tongue, right? Yeah, that's the name of it.

**中文翻译:**
是的，名字挺顺口的，对吧？就是那个。

---

### [01:16:41] Lenny Rachitsky

**English:**
Very cool. Okay, I see the little needle. Okay, great. Go SiPhox. Okay, two more questions. Do you have a favorite life motto that you often come back to, find useful in work or in life, share with friends?

**中文翻译:**
很酷。我看到那根小针了。太棒了，加油 SiPhox。最后两个问题。你有没有什么经常想起的、觉得对工作或生活很有用的座右铭？

---

### [01:16:55] Dalton Caldwell

**English:**
Just check in with yourself that you're having fun and that you enjoy what you're doing. And if you don't, you should probably make a change, whatever that is. And again, if you're a founder, you're in control, right? You can change your own company. But I think a lot of people go through life and they don't ask themselves this question, am I having fun? Am I enjoying? Do I value what I'spending my time on? And I think that you just can go back to this over and over and over again as a good prompt on how to decide what to do with your life.

**中文翻译:**
经常问问自己：我是否觉得有趣？我是否享受我正在做的事？如果不是，你可能应该做出改变，无论那是什么。再说一次，如果你是创始人，你拥有控制权，对吧？你可以改变你的公司。但我觉得很多人在生活中从不问自己这个问题：我开心吗？我享受吗？我花时间做的这些事有价值吗？我认为这是一个很好的提示，可以反复用来决定如何度过你的一生。

---

### [01:17:29] Lenny Rachitsky

**English:**
Easier said than done to change that in many cases, but it always starts with realizing, okay, this isn't actually what I-

**中文翻译:**
很多时候改变起来知易行难，但一切都始于意识到：“好吧，这其实不是我想要的——”

---

### [01:17:35] Dalton Caldwell

**English:**
Yeah, and bidding to yourself. Yeah, I'm not really enjoying this, and then trying to be like, "Well, how can I fix it?" Having that conversation with yourself.

**中文翻译:**
是的，对自己诚实。承认“我并不享受这个”，然后尝试去想“我该如何修复它？”与自己进行这样的对话。

---

### [01:17:42] Lenny Rachitsky

**English:**
Yeah. It reminds me of a Steve Jobs quote where you wake up day after day, it's okay to wake up some days being like, "I don't want to be doing this." But if it's every day and continues to happen, then that's a sign you should change it.

**中文翻译:**
是的。这让我想起乔布斯的一句话：如果你日复一日地醒来，偶尔觉得“我不想做这个”没关系，但如果每天都这样，且持续发生，那就是你该做出改变的信号了。

---

### [01:17:53] Dalton Caldwell

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:17:54] Lenny Rachitsky

**English:**
Final question. You and Michael Seibel have been doing this incredible podcast together. If somebody wanted to check out the podcast and dive in, is there an episode that you love most that you think they could start with?

**中文翻译:**
最后一个问题。你和 Michael Seibel 一直在合作一个非常棒的播客。如果有人想去听听，你最喜欢哪一集？你觉得他们可以从哪一集开始？

---

### [01:18:05] Dalton Caldwell

**English:**
It depends. Some of the episodes are more for folks that already have a startup and they're dealing with problems. I don't know. Some of the episodes about investors or things like that. It's very clear that the audience for those is current startup founders. And there's a lot that are just more life advice, how to make decisions and think about. And those have strangely become very popular and gotten a lot of views with non-startup founders, which is a pleasant surprise. And so I'd recommend those for folks in the audience that are not currently startup founders. I don't know. Life tips from top founders, I think is a good-

**中文翻译:**
这取决于听众。有些集数是专门给已经创业并面临问题的创始人的，比如关于投资者的话题。很明显，那些受众是现任创始人。还有很多集是关于人生建议、如何做决定和思考方式的。奇怪的是，这些集数在非创始人中非常受欢迎，播放量很高，这让我们感到惊喜。所以我会向非创始人的听众推荐这些。比如《顶级创始人的生活建议》（Life tips from top founders）就很不错。

---

### [01:18:41] Lenny Rachitsky

**English:**
Oh, from billionaires? Is it that one?

**中文翻译:**
噢，是关于亿万富翁的那集吗？

---

### [01:18:43] Dalton Caldwell

**English:**
Yeah, yeah. I think that was pretty popular. So what I'd be looking for is diagnose, am I a current founder and I have founder problems? Or am I just looking for general philosophy type questions? And I really like those philosophy ones. We have one for high school students, the audience is, here's advice for high school students that are interested in startups. Here's some tips that you should be thinking about. Again, pretty narrow target audience, but I love that episode because we're really trying to speak directly to that audience and I think it's pretty good advice.

**中文翻译:**
对，对。那一集很受欢迎。所以我会建议听众先自我诊断：我是面临问题的创始人吗？还是我只是想听听普适的哲学问题？我个人非常喜欢哲学类的。我们还有一集是专门给高中生的，给那些对创业感兴趣的高中生提建议。虽然受众很窄，但我很喜欢那一集，因为我们是在直接与那个群体对话，而且我觉得建议很中肯。

---

### [01:19:13] Lenny Rachitsky

**English:**
Dalton, you are wonderful. Thank you for sharing so much wisdom. This is action packed. I'm really excited for founders to listen to this. I think it's going to make a big dent in a lot of people's lives. Two final questions. Where can folks find you online if they want to reach out and follow up on some of this? And how can listeners be useful to you?

**中文翻译:**
Dalton，你太棒了。感谢你分享这么多智慧。这一集干货满满。我非常期待创始人们能听到这些，我相信这会改变很多人的生活。最后两个问题：如果大家想联系你或关注后续，可以在哪里找到你？听众能为你做些什么？

---

### [01:19:27] Dalton Caldwell

**English:**
I am on Twitter/X.com and Dalton.C is my username. And also my LinkedIn is pretty good. It's pretty popular. I don't know. Just search for my name on LinkedIn. And yeah, I'd love to see you all there. And then how can folks be helpful? I mean, honestly, it's just great when folks want to apply to YC and do a startup. And so feel free to dive into other videos and apply to YC. And something that's really special about my job is I get the privilege of getting to fund companies that they already know me from videos and they're shocked that I'm exactly the same as... Effectively, they're like, "Wow, you're just that guy from the videos I've been watching, and it's so cool that you're just exactly like you seem in the videos." And so basically, yeah, if people like what I have to say and they like the videos and apply to YC, I would love to fund their companies.

**中文翻译:**
我在 Twitter (X.com) 上，用户名是 Dalton.C。我的 LinkedIn 也挺活跃的，直接搜我名字就行。我很乐意在那里见到大家。至于大家能帮我什么？老实说，如果大家愿意申请 YC 并开始创业，那就太棒了。所以请随意观看我们的其他视频并申请 YC。我工作中一个很特别的地方是，我有幸资助那些通过视频认识我的公司，他们见到我时会很惊讶：“哇，你就是视频里那个人，你本人和视频里一模一样，太酷了。”所以，如果大家喜欢我的观点，喜欢我们的视频，那就申请 YC 吧，我很乐意资助你们的公司。

---

### [01:20:21] Lenny Rachitsky

**English:**
Dalton, thank you so much for being here.

**中文翻译:**
Dalton，非常感谢你能来。

---

### [01:20:24] Dalton Caldwell

**English:**
Sure thing. Thanks so much, Lenny. Appreciate it.

**中文翻译:**
没问题。非常感谢，Lenny。很愉快。

---

### [01:20:26] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众找到我们。你可以在 Lennyspodcast.com 找到所有往期节目或了解更多信息。下期见。