# Dan Hockenmaier - 双语对照

This is the complete bilingual transcript for **Lenny's Podcast** featuring **Dan Hockenmaier**.

---

### [00:00:00] Dan Hockenmaier

**English:**
One lesson I learned the hard way a bunch of times on this is that if you think about running a marketplace, you're basically like a gardener. You have to have a very light touch. If you're building a SaaS business, you're a construction worker, you're building the product and the features and selling it, and it's this very linear thing. For a marketplace, you're like messing with this ecosystem that you don't actually really understand how it works. And sometimes you might do something over here which drives this long-term effect two months later, and then you're going to be pulling your hair out two months later trying to figure out what you did over here that made that thing happen. So I think that the main advice is like to tread lightly. When you're messing with the core incentives or mechanisms of a marketplace, be very careful, particularly if you've got something that's working on playing with those variables.

**中文翻译:**
关于这一点，我多次通过惨痛的教训学到的一个道理是：如果你在经营一个撮合市场（Marketplace），你基本上就像个园丁。你必须动作非常轻柔。如果你在建立一个 SaaS 业务，你就像个建筑工人，你在构建产品和功能并进行销售，这是一个非常线性的过程。而对于撮合市场，你就像是在干预一个你其实并不真正了解其运作方式的生态系统。有时你可能在这里做了一件事，却在两个月后引发了长期的连锁反应，然后两个月后你会抓狂地试图弄清楚你当初在这里做了什么导致了那件事的发生。所以，我认为核心建议是“谨慎行事”。当你触动撮合市场的核心激励措施或机制时，要非常小心，特别是当你已经有一套行之有效的变量在运作时。

---

### [00:00:45] Lenny

**English:**
Welcome to Lenny's podcast. I'm Lenny and my goal here is to help you get better at the craft of building and growing products. I interview world class product leaders and growth experts to learn from their hard won experiences building and scaling today's most successful companies. Today my guest is Dan Hockenmaier. I venture to say that Dan has worked on more marketplace startups than anyone else in the world, including helping scale Thumbtack in the early days, currently working at Faire where he is head of strategy and analytics and, through his consulting business, Basis One, where he's helped dozens of startups figure out their growth models and growth strategies.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的技能。我采访世界级的产品领导者和增长专家，从他们构建和扩展当今最成功公司的宝贵经验中学习。今天的嘉宾是 Dan Hockenmaier。我敢说 Dan 参与过的撮合市场初创公司比世界上任何人都多，包括在早期帮助 Thumbtack 扩大规模，目前在 Faire 担任战略与分析主管，并通过他的咨询公司 Basis One 帮助数十家初创公司理清了他们的增长模型和增长策略。

---

### [00:01:20] Lenny

**English:**
Dan hasn't shared a ton of his insights and experiences publicly, so I was really excited to chat with him and to dig into all the things that go into building a marketplace business along with coming up with your growth model. This episode gets very deep into the weeds and so, if you're working on a growth strategy or you're building a marketplace business, this episode is for you. So with that, I bring you Dan Hockenmaier.

**中文翻译:**
Dan 并没有在公开场合分享过太多的见解和经验，所以我非常兴奋能与他聊天，深入探讨构建撮合市场业务的所有细节，以及如何制定增长模型。本集内容会深入到非常底层的细节，所以如果你正在制定增长策略或构建撮合市场业务，这一集就是为你准备的。那么，下面请出 Dan Hockenmaier。

---

### [00:01:45] Lenny

**English:**
I'm excited to chat with my friend, John Cutler, from Podcast Sponsor Amplitude. Hey John.

**中文翻译:**
很高兴能与我的朋友，来自播客赞助商 Amplitude 的 John Cutler 聊天。嘿，John。

---

### [00:01:49] John Cutler

**English:**
Hey Lenny. Excited to be here.

**中文翻译:**
嘿，Lenny。很高兴来到这里。

---

### [00:01:51] Lenny

**English:**
John, give us a behind the scenes at Amplitude. When most people think of Amplitude, they think of product analytics, but now you're getting into experimentation and even just launched a CDP. What's the thought process there?

**中文翻译:**
John，给我们讲讲 Amplitude 的幕后故事吧。大多数人想到 Amplitude 时，想到的是产品分析，但现在你们开始涉足实验平台，甚至刚刚推出了 CDP（客户数据平台）。这背后的思考过程是怎样的？

---

### [00:02:02] John Cutler

**English:**
Well, we've always thought of Amplitude as being about supporting the full product loop, think collect data, inform [inaudible 00:02:08] ship experiments and learn. That's the heart of growth to us. So the big aha was seen how many customers were using Amplitude to analyze experiments, use segments for outreach and send data to other destinations. Experiment and CDP came out of listening to and observing our customers.

**中文翻译:**
嗯，我们一直认为 Amplitude 的核心是支持完整的产品闭环：收集数据、提供信息、发布实验并学习。对我们来说，这就是增长的核心。所以，当我们看到有多少客户在使用 Amplitude 来分析实验、使用细分群体进行外展以及将数据发送到其他目的地时，我们有了重大的发现。实验平台和 CDP 的诞生正是源于对客户的倾听和观察。

---

### [00:02:23] Lenny

**English:**
Supporting growth and learning has always been Amplitude's core focus, right?

**中文翻译:**
支持增长和学习一直是 Amplitude 的核心关注点，对吧？

---

### [00:02:27] John Cutler

**English:**
Yeah. So Amplitude tries to meet customers where they are. We just launched starter templates and have a great scholarship program for startups. There's never been a more important time for growth.

**中文翻译:**
是的。所以 Amplitude 努力满足客户的需求。我们刚刚推出了入门模板，并为初创公司提供了一项很棒的奖学金计划。对于增长来说，现在是前所未有的重要时刻。

---

### [00:02:36] Lenny

**English:**
Absolutely agree. Thanks for joining us, John, and head to amplitude.com to get started.

**中文翻译:**
完全同意。谢谢你的加入，John。请访问 amplitude.com 开始体验。

---

### [00:02:43] Lenny

**English:**
Hey, Ashley, head of marketing and flat file. How many B2B SaaS companies would you estimate need to import CSV files from their customers?

**中文翻译:**
嘿，Ashley，Flatfile 的营销主管。你估计有多少 B2B SaaS 公司需要从他们的客户那里导入 CSV 文件？

---

### [00:02:51] Ashley

**English:**
At least 40%.

**中文翻译:**
至少 40%。

---

### [00:02:52] Lenny

**English:**
And how many of them screw that up and what happens when they do?

**中文翻译:**
其中有多少公司把这件事搞砸了？搞砸后会发生什么？

---

### [00:02:56] Ashley

**English:**
Well, based on our data, about a third of people will consider switching to another company after just one bad experience during onboarding. So if your CSV importer doesn't work right, which is super common considering customer files are chock full of unexpected data and formatting, they'll leave.

**中文翻译:**
嗯，根据我们的数据，大约三分之一的人在入驻（onboarding）过程中只要经历一次糟糕的体验，就会考虑更换公司。因此，如果你的 CSV 导入器运行不正常（考虑到客户文件充满了意想不到的数据和格式，这非常普遍），他们就会流失。

---

### [00:03:15] Lenny

**English:**
I am 0% surprised to hear that. I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing long-term retention. Getting people to your aha moment more quickly and reliably is so incredibly important.

**中文翻译:**
听到这个我一点也不惊讶。我一直认为，改善入驻流程是提高注册转化率和增加长期留存率的最高杠杆机会之一。让用户更快速、更可靠地达到“Aha Moment”（惊喜时刻）是极其重要的。

---

### [00:03:30] Ashley

**English:**
Totally. It's incredible to see how our customers like Square, Spotify and Zuora are able to grow their businesses on top of flat file, this because flawless data onboarding acts like a catalyst to get them and their customers where they need to go faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zuora 这样的客户如何在 Flatfile 的基础上发展业务，真是令人难以置信。这是因为完美的数据入驻就像催化剂一样，让他们和他们的客户能更快地达到目标。

---

### [00:03:47] Lenny

**English:**
If you'd like to learn more or get started, check out Flatfile at flatfile.com/lenny.

**中文翻译:**
如果你想了解更多信息或开始使用，请访问 flatfile.com/lenny 查看 Flatfile。

---

### [00:03:56] Lenny

**English:**
Dan Hockenmaier, welcome to the podcast.

**中文翻译:**
Dan Hockenmaier，欢迎来到播客。

---

### [00:03:59] Dan Hockenmaier

**English:**
It's great to be here.

**中文翻译:**
很高兴来到这里。

---

### [00:04:01] Lenny

**English:**
It's great to have you here. So we are actual real life friends and we've collaborated on a number of writing projects, including the race car growth framework and a whole thing on consumer growth strategy. But there's a couple topics that we've never actually dug deep into and that you haven't written about. So I'm really excited to dig into two specific things in our chat today.

**中文翻译:**
很高兴你能来。我们是现实生活中的好朋友，合作过很多写作项目，包括“赛车增长框架”（race car growth framework）和一整套关于消费者增长策略的内容。但有两个话题我们从未真正深入探讨过，你也没有写过。所以我非常兴奋能在今天的聊天中深入探讨这两个具体的事情。

---

### [00:04:23] Lenny

**English:**
One is growth models and two is just marketplace growth strategy and all things around marketplace growth. But before we get into all that, can you just give us a 55 second background on all of the wonderful things that you've done in your career?

**中文翻译:**
一是增长模型，二是撮合市场增长策略以及围绕撮合市场增长的所有事情。但在我们深入探讨这些之前，你能用 55 秒的时间介绍一下你职业生涯中做过的那些精彩事情吗？

---

### [00:04:36] Dan Hockenmaier

**English:**
Yeah, absolutely. So I feel very fortunate being able to work on a bunch of consumer and marketplace businesses for a long time. I started in consulting at BCG and then in private equity. I don't think I learned much about how to actually run a business at those places, but I did learn a lot about how to think about them. I think my real education on this began at Thumbtack. So I joined when there were about 30 people and we just had to figure it out. I was there for a little over three years and we more than 10Xed the business in that time.

**中文翻译:**
好的，没问题。我觉得非常幸运，能够长期从事许多消费者和撮合市场业务。我的职业生涯始于波士顿咨询（BCG），然后进入了私募股权行业。我不认为我在那些地方学到了多少关于如何实际运营业务的知识，但我确实学到了很多关于如何思考业务的知识。我认为我在这方面真正的教育始于 Thumbtack。我在公司大约只有 30 人的时候加入，我们必须自己摸索。我在那里待了三年多，期间我们的业务增长了 10 倍以上。

---

### [00:05:02] Dan Hockenmaier

**English:**
From there I built a strategy consulting firm where we worked with a bunch of the top gross stage marketplaces on a range of topics, and ultimately that firm was acquired by Faire where I am today. So I lead the strategy analytics team at Faire. I think this is probably the most fun I've ever had in my career. It's just the incredible mix of the team. The business is really strong and I love the customers we're serving. So it's a marketplace connecting local retailers and independent brands, and I just think that's a really fun group of customers to build for.

**中文翻译:**
从那以后，我建立了一家战略咨询公司，我们与许多顶尖的增长阶段撮合市场合作，探讨各种话题。最终，那家公司被我目前所在的 Faire 收购了。现在我在 Faire 领导战略分析团队。我认为这可能是我职业生涯中最快乐的时光。团队的组合非常棒，业务非常强劲，而且我非常喜欢我们服务的客户。Faire 是一个连接本地零售商和独立品牌的撮合市场，我认为为这样一群客户构建产品非常有趣。

---

### [00:05:31] Lenny

**English:**
Awesome. And we're going to chat a bit about the stuff that you do there and marketplaces. But before we get into marketplaces, I wanted to start with our first topic, which is around growth models. So people may have heard this term, this general idea. Just to set the stage, can you just describe what is a growth model and why is it useful to think about your business through the lens of a growth model?

**中文翻译:**
太棒了。我们将聊聊你在那里的工作以及撮合市场。但在进入撮合市场话题之前，我想从第一个话题开始，即增长模型。人们可能听说过这个词，或者这个通用概念。为了做个铺垫，你能描述一下什么是增长模型，以及为什么从增长模型的角度思考业务是有用的吗？

---

### [00:05:54] Dan Hockenmaier

**English:**
So I think it's useful in many contexts. If I apply it to the current work that I'm doing, the strategy analytics team at Faire does a bunch of work to help our other teams make better decisions. So we're typically diving really deep into a bunch of topics across the business. I think it's really easy to make that work kind of go off the rails or go too deep unless you have a conceptual understanding of how the whole business that it comes together. And that's how I think about a growth model, so the analytical representation of how the business grows and it's typically built in a spreadsheet which has a really nice feature of being very hard to fake. You can talk about a business conceptually, but when you actually have to get it to line up and link in a model, it's very hard to not force yourself to understand how the business works. So I think it's very valuable for that.

**中文翻译:**
我认为它在很多场景下都很有用。以我目前的工作为例，Faire 的战略分析团队做了大量工作来帮助其他团队做出更好的决策。我们通常会深入探讨业务中的许多话题。我认为，除非你对整个业务如何整合在一起有一个概念性的理解，否则这些工作很容易偏离轨道或钻得太深。这就是我对增长模型的看法：它是业务增长方式的分析性呈现，通常建立在电子表格中，电子表格有一个很好的特点，就是很难造假。你可以抽象地谈论业务，但当你必须在模型中将其对齐并链接起来时，你很难不强迫自己去理解业务的运作方式。所以我认为它在这方面非常有价值。

---

### [00:06:37] Dan Hockenmaier

**English:**
I think 50% of the value you get from it is simply building the model. It forces you to understand it and then you get this artifact which you can use to understand how to weigh different opportunities or understand the benefit of working on different things. I think importantly it is not a forecasting tool, so it's not going to replace what your finance team is building to project the business. In fact, often the output can be highly variable because you're playing with lots of these assumptions, but it is a great tool for kind of opportunity assessment for the business.

**中文翻译:**
我认为你从中获得的 50% 的价值仅仅来自于构建模型的过程。它强迫你去理解业务，然后你会得到这个“产物”，你可以用它来衡量不同的机会，或者理解做不同事情的收益。我认为重要的一点是，它不是一个预测工具，所以它不会取代财务团队为预测业务而构建的模型。事实上，输出结果往往具有高度的可变性，因为你在处理大量的假设，但它确实是进行业务机会评估的绝佳工具。

---

### [00:07:05] Lenny

**English:**
Awesome. So maybe a simple way to think about it, just summarizing, is it's essentially a formula for your business that often lives in Excel that kind of summarizes and puts together all the things that can drive your business. Is that a simple way [inaudible 00:07:19]?

**中文翻译:**
太棒了。所以，总结一下，一个简单的理解方式是：它本质上是你业务的一个公式，通常存在于 Excel 中，它总结并整合了所有可以驱动你业务的因素。这样理解对吗？

---

### [00:07:18] Dan Hockenmaier

**English:**
Yeah. That's exactly right.

**中文翻译:**
是的，完全正确。

---

### [00:07:20] Lenny

**English:**
Sweet. So we're going to go through examples of these growth models and how you've thought about this in actual potential formulas for companies. But first, just broadly, how would someone approach figuring this out for themselves? How would you build a growth model for your own business?

**中文翻译:**
太好了。我们将通过这些增长模型的例子，看看你是如何在公司的实际潜在公式中思考这个问题的。但首先，从广义上讲，一个人该如何为自己理清这个问题？你会如何为自己的业务建立增长模型？

---

### [00:07:35] Dan Hockenmaier

**English:**
So if you think about some of the basic building blocks and probably the simplest use case would be a SaaS business, there's really three components that you need to build for that. One is to understand your acquisition channels. Are you looking at paid marketing or sales or viral kind of customer referrals? And for each of those you have some different assumptions around traffic or spend or conversion rate, those kind of things. So that's the first section. Second would be retention. So at what rate are these customers activating? And then have some kind of basic monthly retention curve. So how long are they staying around? What's the survival rate in each of these? And those kind of stack over time. And then you have monetization. So in the simplest example, they might be paying you some monthly or annual fee and so that translates in monetization.

**中文翻译:**
如果你思考一些基础构建模块，最简单的案例可能是 SaaS 业务，你真的只需要构建三个组件。第一是了解你的获客渠道（Acquisition Channels）。你是看付费营销、销售还是病毒式的客户推荐？对于每一个渠道，你都有关于流量、支出或转化率等不同的假设。这是第一部分。第二是留存（Retention）。这些客户的激活率是多少？然后有一个基础的月度留存曲线。他们会留存多久？每个阶段的存活率是多少？这些会随着时间的推移而堆叠。第三是变现（Monetization）。在最简单的例子中，他们可能会支付月费或年费，这就转化成了变现。

---

### [00:08:13] Dan Hockenmaier

**English:**
So actually if you're modeling a relatively simple SaaS business, those are the only core building blocks you need and you add a lot more complexity on it based on your kind of individual business that you're building. If you then are trying to build this for more of a transactional business, you need to layer on the way that your current kind of retained customers start to transact. So how many transactions per month? What's the AOV? And then you're also going to typically need to build unit economics because those businesses often have higher costs. And so you're going to be thinking about cogs or other major costs that you build into it.

**中文翻译:**
所以实际上，如果你在为一个相对简单的 SaaS 业务建模，这些就是你需要的核心模块，然后你根据所构建的具体业务增加复杂性。如果你试图为交易型业务建模，你需要叠加现有留存客户开始交易的方式。比如每月有多少次交易？客单价（AOV）是多少？然后你通常还需要构建单位经济效益（Unit Economics），因为这些业务通常有更高的成本。所以你会考虑销货成本（COGS）或其他你纳入其中的主要成本。

---

### [00:08:39] Dan Hockenmaier

**English:**
And then one click beyond that would be to build this for marketplace business. So now what we've talked about is mostly modeling like the demand side of a business. So now you'd also need to think about supply acquisition and retention and how these two sides interact. So as we add supply, what's going to happen to demand? But those are the basic pieces. I think you can start pretty linear like acquiring customers, they're activating, retaining and generating contribution margin typically would be the output. But where it gets really interesting is we start making it non-linear. So the most basic example of this would be virality. Your existing customers are referring new customers and those go on to refer new customers. Based on that coefficient, it has a lot to do with how fast your business grows.

**中文翻译:**
再进一步就是为撮合市场业务建模。到目前为止，我们谈论的主要是对业务的需求侧进行建模。现在你还需要考虑供给侧的获取和留存，以及这两侧是如何互动的。比如当我们增加供给时，需求会发生什么变化？这些是基本组成部分。你可以从非常线性的方式开始，比如获取客户、激活、留存，通常输出的是边际贡献（Contribution Margin）。但真正有趣的地方在于我们开始引入非线性因素。最基础的例子就是病毒式传播（Virality）。你的现有客户推荐新客户，新客户再推荐更多新客户。基于这个系数，它与你业务增长的速度密切相关。

---

### [00:09:17] Dan Hockenmaier

**English:**
And similarly with paid marketing, as you generate contribution margin, you can reinvest that and grow and actually if you link those two up explicitly, it makes it really clear why thinking about something like payback period is a much better measure of paid marketing performance than LTV to CAC because the speed at which you get enough money back to then go acquire another customer has much more bearing on how fast your business can grow than just the raw kind of [inaudible 00:09:39]. This is where it gets really interesting where you get some variables to play with.

**中文翻译:**
付费营销也是如此，当你产生边际贡献时，你可以将其重新投入并实现增长。如果你明确地将这两者联系起来，就会非常清楚为什么考虑“回本周期”（Payback Period）是比“LTV/CAC 比率”更好的付费营销衡量指标。因为你收回足够资金再去获取另一个客户的速度，比单纯的数值比例对业务增长速度的影响要大得多。这就是有趣的地方，你可以开始调整这些变量。

---

### [00:09:43] Lenny

**English:**
Okay. So let's unpack a bit of the stuff you just talked about. There's a whole decade of knowledge that you just I think collapsed into a couple of minutes. So just to spend a little more time there. So the core three kind of variables to a SaaS business, if you're thinking about the growth model of a SaaS business, for example, you said acquisition channels, where's traffic coming from, and that's essentially how much traffic are you getting, how is it converting and things like that.

**中文翻译:**
好的。让我们拆解一下你刚才说的内容。你刚才把整整十年的知识浓缩到了几分钟里。所以我们再多花点时间。对于 SaaS 业务，如果你在思考其增长模型，核心的三个变量是：获客渠道（流量来源，本质上是你获得了多少流量、转化率如何等等）。

---

### [00:10:07] Dan Hockenmaier

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:10:07] Lenny

**English:**
And then there's retention and then there's monetization and multiplying all that together you end up with here's how much revenue you're making as a business. Is that roughly how to think about it?

**中文翻译:**
然后是留存，接着是变现，把所有这些相乘，你最终就能得出作为一家公司你赚了多少钱。大致是这样理解吗？

---

### [00:10:14] Dan Hockenmaier

**English:**
Yeah, it's roughly right. And those three building blocks are true for here in most businesses. Most of what we're talking about is then nuance on top of that that makes the business unique.

**中文翻译:**
是的，大致正确。这三个构建模块适用于大多数业务。我们讨论的大部分内容都是在此基础上的细微差别，正是这些差别让业务变得独特。

---

### [00:10:22] Lenny

**English:**
Cool. So if someone was just starting the spreadsheet for their SaaS business, and we'll talk about even more examples, but if someone was like, "Here, I'm going to try to figure out my growth model," it's create a row for acquisition channels and traffic you're getting, then a row for roughly your retention rate and then how much you're making per customer. Very high level, is that to think about this?

**中文翻译:**
酷。所以如果有人刚刚开始为他们的 SaaS 业务制作电子表格（我们稍后会讨论更多例子），如果有人说“我要试着理清我的增长模型”，那就是为获客渠道和流量创建一行，然后为大致的留存率创建一行，再为每个客户赚多少钱创建一行。从非常宏观的角度来看，是这样思考的吗？

---

### [00:10:42] Dan Hockenmaier

**English:**
Yeah, exactly.

**中文翻译:**
是的，正是如此。

---

### [00:10:43] Lenny

**English:**
Okay, sweet. And then marketplaces, I think you said that it's transaction over time and average order value. So it's like how many people are buying stuff, how much are they paying each time? And then unit economics per transaction, how much they're making profit per [inaudible 00:10:58].

**中文翻译:**
好的，太棒了。然后是撮合市场，我想你刚才说的是随时间推移的交易量和平均订单价值（客单价）。也就是有多少人在买东西，他们每次付多少钱？然后是每笔交易的单位经济效益，每笔交易赚多少利润。

---

### [00:10:57] Dan Hockenmaier

**English:**
Yeah, exactly. And the critical distinction there is for a SaaS business, your marginal costs are often very low. And so it's not an important part to model. But for transactional business, you typically have very high cost or something else that you need to model so [inaudible 00:11:09].

**中文翻译:**
是的，没错。关键的区别在于，对于 SaaS 业务，你的边际成本通常非常低，因此它不是建模的重要部分。但对于交易型业务，你通常有非常高的成本或其他需要建模的东西。

---

### [00:11:08] Lenny

**English:**
Right, because you're just taking a cut and you're not selling software. And then the acquisition channels, retention, monetization, marketplace have those three things just broadly and then plus these additional two elements.

**中文翻译:**
对，因为你只是在抽成，而不是在卖软件。那么获客渠道、留存、变现，撮合市场广义上也包含这三样，再加上这两个额外的元素。

---

### [00:11:19] Dan Hockenmaier

**English:**
Yeah. I think one warning I would give ... so I built these for many businesses. I built them for Thumbtack, at Faire. Many of the companies I worked with, at my consulting firm, they break down in a few places. As soon as you start stacking assumptions, you're highly sensitive to how many assumptions do you have to make and do you know how to make that assumption. And marketplaces kind of create complexity on both of those because for the first piece you're modeling both sides of the business. There's a lot of assumptions. And second, there's a few pieces which are very hard to understand how they work. So the interaction between supply and demand is a big one. Take Amazon as an example. There's a category manager at Amazon who's running their pets business and he decides that he wants to go add a bunch more pet supply to the business. So he's going to go find pet food brands, pet toy brands. Those businesses will generate a bunch of revenue on the Amazon marketplace.

**中文翻译:**
是的。我想给出一个警告……我为很多公司建立过这些模型，比如 Thumbtack、Faire。在我咨询公司合作过的许多公司中，这些模型在某些地方会失效。一旦你开始堆叠假设，你就会对需要做多少假设以及你是否知道如何做这些假设变得高度敏感。撮合市场在两方面都增加了复杂性：首先，你要对业务的双侧进行建模，这涉及大量假设；其次，有些部分非常难以理解其运作方式。供给和需求之间的互动就是一个大难题。以亚马逊为例，亚马逊有一位负责宠物业务的类目经理，他决定要为业务增加大量的宠物用品供应。于是他去找宠物食品品牌、宠物玩具品牌。这些业务会在亚马逊市场上产生大量收入。

---

### [00:12:03] Dan Hockenmaier

**English:**
But how much of that was actually incremental? Maybe there's a bunch of existing pet supply that customers would've bought anyway. And does having a bunch more supply create a happier customer who retains longer and drives those cohorts up? These things are very hard to decide, something we've spent a lot of time thinking about in various marketplace businesses. And so if you're not careful, you can have a junk in, junk out problem with marketplaces. So the thing that I have gravitated to more as I've done more of this is one very basic high level conceptual model, so that's like the building blocks you talked about, which as simply as possible describes how the whole system works. And so you start to get a feel for which levers are important.

**中文翻译:**
但其中有多少实际上是增量（Incremental）的？也许已经有很多现有的宠物用品，客户本来就会买。增加更多供应是否会让客户更满意、留存更久并提升这些留存群组（Cohorts）的表现？这些事情很难确定，这是我们在各种撮合市场业务中花了很多时间思考的问题。所以如果你不小心，撮合市场模型就会出现“垃圾进，垃圾出”（Junk in, junk out）的问题。因此，随着我做得越来越多，我更倾向于建立一个非常基础的高层概念模型，也就是你提到的那些构建模块，尽可能简单地描述整个系统是如何运作的。这样你就能开始感觉到哪些杠杆是重要的。

---

### [00:12:39] Dan Hockenmaier

**English:**
And then for each area of the business, so each product pod, each go to market team, they should have their own kind of mini model which describes the piece of the business they're working on. So that team typically has a north star and they should know what are all the inputs that drive that and a little model to articulate how that works. And you'll never kind of stitch this up into one master thing. I think that's a very difficult task. But you have the dual benefit of understanding how the business works broadly and then understanding if you zoom in on this piece, what are the levers i need to be pulling to move my metric.

**中文翻译:**
然后对于业务的每个领域，比如每个产品小组（Pod）、每个市场进入（GTM）团队，他们都应该有自己的微型模型，描述他们负责的那部分业务。那个团队通常有一个北极星指标，他们应该知道驱动该指标的所有输入因素，并有一个小模型来阐明其运作方式。你永远无法将这些缝合成一个巨大的主模型，我认为那是一项非常困难的任务。但这样做有双重好处：既能从宏观上理解业务运作，又能理解如果你放大到这个局部，需要拉动哪些杠杆来提升你的指标。

---

### [00:13:07] Lenny

**English:**
To make that last point a little more concrete, what's an example of that? What's a team that would have their little model? I imagine every team has their own understanding of how the lever works, but what's an example?

**中文翻译:**
为了让最后一点更具体，能举个例子吗？什么样的团队会有他们的小模型？我想每个团队对自己负责的杠杆如何运作都有自己的理解，但能举个具体的例子吗？

---

### [00:13:17] Dan Hockenmaier

**English:**
I think there's probably two core archetypes for this. So if you have something that's more like a growth team, it's a little bit simpler. They're typically managing some kind of funnel and they can understand do I want to work on driving more traffic, more conversion, more retention. Typically, that's a somewhat linear relationship.

**中文翻译:**
我认为这大概有两种核心原型。如果你有一个更像增长团队的部门，那就简单一些。他们通常管理某种漏斗，他们可以理解：我是想致力于引入更多流量、提高转化率还是提高留存率。通常情况下，这是一种某种程度上的线性关系。

---

### [00:13:32] Dan Hockenmaier

**English:**
But then you have all these teams that are really managing some tension in the business, which is totally different than a funnel. So say if you have a marketplace quality team, what they care about is driving some standard for quality for the suppliers on a marketplace, but there's not a linear kind of relationship between working on that kind of problem. So if I let on a bunch of new supply to a marketplace, probably the first thing that happens is our GMV or our revenue goes up because we have all these new suppliers which can transact demand, but if those are on average lower quality, it's going to degrade the kind of customer experience and reduce retention over time. And so the model that they're trying to build is how to manage that tension.

**中文翻译:**
但你还有很多团队实际上是在管理业务中的某种“张力”（Tension），这与漏斗完全不同。比如，如果你有一个撮合市场质量团队，他们关心的是为市场上的供应商制定某种质量标准，但处理这类问题并没有线性关系。如果我允许大量新供应进入市场，可能发生的第一件事是我们的 GMV 或收入增加了，因为我们有了所有这些可以满足需求的新供应商；但如果这些供应商平均质量较低，随着时间的推移，它会降低客户体验并减少留存。所以他们试图构建的模型是如何管理这种张力。

---

### [00:14:08] Dan Hockenmaier

**English:**
Similarly in a FinTech business or many marketplaces now have FinTech elements, you're often underwriting the transaction. That team is thinking about the tension between extending more credit and driving higher spend versus defaults on the other side, like what's the contribution margin maximizing point at which we could offer credit. And so their models are going to look pretty different than what a growth team is managing.

**中文翻译:**
同样，在金融科技业务中，或者现在许多具有金融科技元素的撮合市场中，你通常在为交易提供承销。那个团队思考的是扩大信用额度以驱动更高支出与另一侧的违约风险之间的张力，比如我们可以提供信用的边际贡献最大化点在哪里。因此，他们的模型看起来会与增长团队管理的模型非常不同。

---

### [00:14:29] Lenny

**English:**
Got it. So you mentioned this idea of archetypes and I was going to ask you when you think about developing a growth model for a company and with Basis One, the company that you ran before Faire, you basically developed these things for startups and how many companies would you say you helped through this process and helped develop growth models for just to [inaudible 00:14:47]?

**中文翻译:**
明白了。你提到了原型的概念，我正想问你，当你考虑为一家公司开发增长模型时——在 Basis One（你在 Faire 之前经营的公司），你基本上就是为初创公司开发这些东西——你大概帮助了多少家公司完成这个过程并开发了增长模型？

---

### [00:14:47] Dan Hockenmaier

**English:**
We probably built 20 or 30 these in my time at Basis One.

**中文翻译:**
在 Basis One 期间，我们大概建立了 20 到 30 个这样的模型。

---

### [00:14:49] Lenny

**English:**
Awesome. It's probably more than anyone out there. So I think that the context to set. You've had more experience doing this than maybe anyone else out there, but we won't compare.

**中文翻译:**
太棒了。这可能比任何人都多。我认为这是个很好的背景设定。你在这方面的经验可能比其他任何人都丰富，不过我们就不做比较了。

---

### [00:14:58] Lenny

**English:**
Are there archetypes/templates/tools that you have found useful to think about, I'm coming in fresh to think about the growth model for a company. What have you found helpful to get started to lay the groundwork?

**中文翻译:**
有没有你觉得有用的原型、模板或工具？如果我是一个新手，想要思考一家公司的增长模型，你觉得哪些东西有助于开始打基础？

---

### [00:15:11] Dan Hockenmaier

**English:**
One thing I'll say is going back to 50% of the value being figuring it out, that actually negates the value of templates in some way. You kind of want to build it up for yourself from first principles to understand how the business works. So the more painful the process of building it is, probably the more you're learning. But I do think there's been a lot written on this that you can find online and I think the building blocks I talked about are a useful starting place for how to put these together. I also think Reforge, which is a product in growth school, which we both know has done I think probably the most work to build this into a discipline. And so if you want to go really deep on this, my top recommendation would be to start with Reforge.

**中文翻译:**
我想说的一点是，回到刚才说的“50% 的价值在于理清过程”，这在某种程度上否定了模板的价值。你更应该从第一性原理出发，为自己构建模型，以理解业务是如何运作的。构建过程越痛苦，你学到的可能就越多。但我确实认为网上有很多关于这方面的文章，我提到的那些构建模块是开始整合这些内容的一个有用起点。我还认为 Reforge（我们都知道的一家产品和增长学校）在将这套内容体系化方面做得最多。所以如果你想深入研究，我的首要建议是从 Reforge 开始。

---

### [00:15:45] Lenny

**English:**
Okay. So getting even more concrete, you've built a lot of these growth models. What's an actual example of growth model you've built and more specifically what have you learned from the experience of building that growth model at either, I guess, I was going to say a fictional company but let's go with a real company?

**中文翻译:**
好的。更具体一点，你建立过很多增长模型。你能举一个你建立的增长模型的实际例子吗？更具体地说，通过在一家公司（我本想说虚构的公司，但还是用真实的公司吧）建立增长模型的经验，你学到了什么？

---

### [00:16:00] Dan Hockenmaier

**English:**
One of the immediate things that you see when you build these is that your growth is much more sensitive to customer retention than you can ever intuit because there's a lot of interaction between having a healthy retained customer base and everything else you care about, which is the rate at which they're referring new customers, generating content, generating contribution margin. And so it quickly makes it clear that actually getting a smaller percentage gain on retention is often much more valuable than making a bigger change in some other area. And as a result you may be misallocating your product and growth resources in a pretty significant way.

**中文翻译:**
当你建立这些模型时，你会立刻发现：你的增长对客户留存的敏感度远超你的直觉。因为健康的留存客户群与你关心的所有其他事情之间存在大量互动，比如他们推荐新客户的速率、生成内容的速率、产生边际贡献的速率。因此，模型很快就会清晰地显示，在留存率上获得较小百分比的提升，往往比在其他领域做出巨大改变更有价值。结果就是，你可能会发现自己之前在产品和增长资源的分配上存在严重的偏差。

---

### [00:16:35] Lenny

**English:**
So your point there is really important that the more you work on this stuff, the more you will learn what actually is movable and the expected ROI on investments. For founders that are just getting started on this sort of stuff, do you have any just general advice or guidance on okay, retention is probably going to be very hard to move, don't expect that metric even though it's your point that it's often the biggest lever? Any just general guidance of here's where you probably will see impact, maybe you should now count on a ton. How do you think about that?

**中文翻译:**
所以你的观点非常重要：你在这方面做得越多，你就越能了解哪些指标是真正可以撼动的，以及投资的预期投资回报率（ROI）。对于刚开始接触这些东西的创始人，你有什么通用的建议或指导吗？比如，留存率可能非常难提升，尽管它是最大的杠杆，但不要指望能轻易改变它？有没有什么通用的指导，告诉他们哪里可能会看到影响，哪里不应该寄予厚望？你怎么看？

---

### [00:17:04] Dan Hockenmaier

**English:**
I think one tactical piece of advice, I think the best way to start this is to find a smart analyst or smart finance person often is the right type of person to partner with and just start building it. So you may have some intuition around this for the core operating model the business is running. This is a little bit different. You need to start building in more variables but I would start there and start iterating on the model. And I think this process of where you have leverage to move it is very hard to intuit. So I think you just have to start and there's a feedback loop between what kind of gains the team is putting up and how that impacts your model and over the course of multiple quarters of iterating on this, you build much more intuition for what works.

**中文翻译:**
我认为一个战术性的建议是：开始这件事最好的方式是找一个聪明的分析师或聪明的财务人员（通常是合适的合作伙伴），然后直接开始构建。你可能对业务运行的核心运营模型有一些直觉，但这有点不同。你需要开始引入更多变量，但我建议从那里开始并不断迭代模型。我认为，哪里有杠杆可以撬动指标是非常难凭直觉判断的。所以你必须开始做，团队取得的进展与模型受到的影响之间会形成一个反馈闭环。经过几个季度的迭代，你会对什么有效建立起更强的直觉。

---

### [00:17:41] Lenny

**English:**
Awesome. So say that somebody has been listening to this episode, maybe they've heard it, they've listened to it three times now and they're just like, "Hey, I got a model that kind of feels like the beginnings of something." What do you do once you have a growth model? How does it actually inform what you do as a startup?

**中文翻译:**
太棒了。假设有人一直在听这一集，也许已经听了三遍了，他们心想：“嘿，我有一个感觉像是雏形的模型了。”一旦你有了增长模型，接下来该做什么？它如何实际指导你作为一家初创公司的行动？

---

### [00:17:56] Dan Hockenmaier

**English:**
It's very helpful input into a quarterly or annual planning process. It depends a little bit on the stage of the company, but say you're at the stage where you have maybe 10 or 20 product pods which are allocated across various parts of the business and you're going through annual planning. Often you want to do a zero based accounting exercise where we say we want to from the ground up decide how those people should spend their time and there's some kind of pod allocation exercise where we're deciding which places those go to. The most difficult thing about making that kind of effort is developing a common currency by which you can trade off their efforts. So this team is saying they can move this metric by X and this team is moving this metric by Y. I have no way to make those two things comparable. The growth model is the function that lets you do that.

**中文翻译:**
它是季度或年度规划过程中非常有用的输入。这在一定程度上取决于公司的阶段，但假设你处于这样一个阶段：你有 10 到 20 个产品小组分布在业务的各个部分，而你正在进行年度规划。通常你想做一个“零基预算法”式的练习，即从零开始决定这些人应该如何分配时间，并进行某种小组分配练习。这种努力最困难的地方在于开发一种“通用货币”，通过它你可以权衡他们的努力。比如，这个团队说他们可以将指标提升 X，而那个团队说他们可以将指标提升 Y。我没有办法让这两件事具有可比性。增长模型就是让你实现这一点的函数。

---

### [00:18:36] Dan Hockenmaier

**English:**
And so you can have this analyst or this finance person we talked about who is operating this model work with the product managers to run those scenarios through this model and generate it into a common currency. So now we have a spreadsheet that says these are the things we could work on. This is roughly how it will impact our short or long-term growth. Now you have the ability to make much better kind of allocation decisions. So that would be at the most macro level. And I think the more micro one is for an individual product pod, I have this north star goal, which levers should I be pulling? They should be using their mini models to make that assessment. If you look at the strategy doc for a product group or team, I think that having a model like this should be a core part of that because that way they can articulate what it is they actually [inaudible 00:19:18].

**中文翻译:**
因此，你可以让刚才提到的那位操作模型的分析师或财务人员与产品经理合作，将这些场景放入模型中运行，并将其转化为通用货币。现在我们有了一个电子表格，上面写着：这些是我们可以做的事情，这大致会如何影响我们的短期或长期增长。现在你就有能力做出更好的分配决策了。这是在最宏观的层面。在更微观的层面，对于一个独立的产品小组，我有这个北极星目标，我应该拉动哪些杠杆？他们应该使用他们的微型模型来进行评估。如果你看一个产品组或团队的战略文档，我认为拥有这样一个模型应该是其中的核心部分，因为这样他们才能清晰地阐述他们实际在做什么。

---

### [00:19:18] Lenny

**English:**
Have you found a model doing this exercise, coming up with a growth model for a company or a startup you've worked with, radically shifted the way they think? Is there an example that comes to mind of, "Oh wow, we came up with this," and they're like they didn't even know this was a huge lever and that changed the way they approached growth.

**中文翻译:**
你是否发现，在为你合作过的公司或初创公司建立增长模型的过程中，有哪个模型彻底改变了他们的思维方式？有没有哪个例子让你想到：“噢，哇，我们做出了这个模型”，然后他们发现自己甚至不知道这是一个巨大的杠杆，从而改变了他们实现增长的方式。

---

### [00:19:32] Dan Hockenmaier

**English:**
I mean the first time this was very eye-opening to me and probably the first one I built was the one we built at Thumbtack in partnership with our finance team, and it made it so immediately obvious that we were exceptionally sensitive to the repeat rate of new customers. If you think about Thumbtack, we offered a thousand categories. This is a local services marketplace for people to hire electricians or plumbers or wedding planners. Almost all the traffic came from a very targeted SEM or SEO on a specific thing. So they hired [inaudible 00:20:01].

**中文翻译:**
我是说，第一次让我大开眼界的是我在 Thumbtack 与财务团队合作建立的第一个模型。它立刻让我们明白，我们对新客户的“复购率”（Repeat Rate）异常敏感。想想 Thumbtack，我们提供一千个类目。这是一个本地服务市场，人们可以在这里雇佣电工、水管工或婚礼策划师。几乎所有的流量都来自针对特定事物的非常精准的 SEM（搜索引擎营销）或 SEO（搜索引擎优化）。

---

### [00:20:01] Dan Hockenmaier

**English:**
Initially, it was very hard for us to then go upsell you into something else, but the rate at which we did that made all the difference because it radically changed the LTV of that customer, which then fed back into how much we could go pay to acquire new customers. And so we had a team that was primarily focused on optimizing that initial flow. So SEO and conversion rate. We shipped hundreds of experiments to increase our conversion rate. We had done much less on the life cycle piece like how do we cross sell you into these other things. Building this model helped us internalize that we needed to shift a bunch of resources from top of funnel to deeper in the stack and that ultimately let us build a much better customer journey.

**中文翻译:**
最初，我们很难向你追加销售（Upsell）其他服务，但我们做到这一点的比率决定了一切，因为它彻底改变了该客户的 LTV（终身价值），进而反馈到我们可以花多少钱去获取新客户。当时我们有一个团队主要负责优化初始流程，即 SEO 和转化率。我们发布了数百个实验来提高转化率。但在生命周期管理方面做得很少，比如如何将你交叉销售（Cross-sell）到其他服务中。建立这个模型帮助我们意识到，我们需要将大量资源从漏斗顶部转移到漏斗深处，这最终让我们构建了更好的客户旅程。

---

### [00:20:36] Lenny

**English:**
Awesome. Your point about retention being one of the biggest levers reminds me at Airbnb there's like a data dive once where a data scientist found that same conclusion. "Man, if we move retention by 1%, we're going to hit all our goals." And we tried and it was just very hard. And I'm curious, how often do you find that you can actually meaningfully move retention or is there anything that you've found to be effective in increasing retention for many of the companies that you've worked at?

**中文翻译:**
太棒了。你关于留存是最大杠杆之一的观点让我想起在 Airbnb，有一次数据科学家进行数据挖掘时也得出了同样的结论：“天哪，如果我们能把留存率提高 1%，我们就能实现所有目标。”我们尝试了，但真的非常困难。我很好奇，你发现实际能显著提升留存率的情况有多频繁？或者在你合作过的许多公司中，有没有发现什么能有效增加留存的方法？

---

### [00:21:04] Dan Hockenmaier

**English:**
Retention is a tough measure to work on because it is the culmination of the entire product experience. Whether people come back or not has to do with everything that they experienced along the way. And so I think that the primary advice is actually if you were trying to remove a retention style metric, rarely should you go right to the source and send them more email or push notification or something like that. It's really actually about understanding what is the customer experience and what matters to them. And in a marketplace context, it's often depth of supply or the interaction they have with supply. So you actually should be working more on core product levers than you are on, call it, growth product levers to move retention. So it's a deep understanding of that customer journey and where you actually have the opportunity to improve it.

**中文翻译:**
留存是一个很难处理的指标，因为它是整个产品体验的终极体现。人们是否回来，与他们沿途经历的一切都有关。所以我认为首要建议是：如果你想提升留存类指标，很少应该直接从源头入手，比如给他们发更多邮件或推送通知之类的。实际上，这关乎理解客户体验以及对他们来说什么才是重要的。在撮合市场的背景下，这通常是供应的深度或他们与供应方的互动。所以，为了提升留存，你实际上应该更多地关注核心产品杠杆，而不是所谓的增长产品杠杆。这需要对客户旅程有深刻的理解，并找到你真正有机会改进的地方。

---

### [00:21:43] Lenny

**English:**
If you can share any idea or any example comes to mind, what's one of the biggest successes you've seen in increasing retention?

**中文翻译:**
如果你能分享的话，有没有什么想法或例子让你想到：你见过的增加留存最成功的案例之一是什么？

---

### [00:21:49] Dan Hockenmaier

**English:**
Very often I think the biggest wins in retention come from inflecting the early user experience. So if you're at three, six, twelve months out, usually a customer has formed a pretty strong opinion about whether or not they like this product and they have a pretty good understanding of it. But in that very first experience, you have a lot of opportunity to teach them about why this is a valuable product and kind of prove to them that it's valuable. So the experiments that have been most effective have been typically focused on very early life cycle, and one really valuable lens is to look for variability in that experience. So for the first week or month, which customers are having a bad experience but shouldn't be.

**中文翻译:**
通常我认为，留存方面最大的胜利来自于改变早期用户体验。如果你观察三个月、六个月或十二个月后的情况，通常客户已经对是否喜欢这个产品形成了非常强烈的看法，并且对它有了相当好的理解。但在最初的体验中，你有很多机会教他们为什么这是一个有价值的产品，并向他们证明它的价值。因此，最有效的实验通常集中在非常早期的生命周期，一个非常有价值的视角是寻找体验中的“变异性”（Variability）。也就是说，在第一周或第一个月，哪些客户经历了本不该有的糟糕体验。

---

### [00:22:27] Dan Hockenmaier

**English:**
So if you take Lyft or Uber, for example, an Uber driver signs up for the service. Some of them just by luck of the draw are going to make a pretty bad hourly rate because a customer canceled on them or they were just in a low density area, and there was some problem with their experience. That driver doesn't know that's not how it works. They might think, "I just make $3 an hour on this platform," and they're never going to come back. And so if you can target streamlining that experience or homogenizing that experience, it's typically very helpful. This is why you see both of those companies dueling it out to guarantee the highest first first week or first month earning. What they're trying to do is prove to you that this is what the experience is going to be like longer term, and you pull up all those below average first experiences to average and drive much better retention curves going forward.

**中文翻译:**
以 Lyft 或 Uber 为例，一名 Uber 司机注册了服务。其中一些人可能仅仅因为运气不好，时薪非常低，因为有客户取消了订单，或者他们恰好在一个低密度区域，他们的体验出了问题。那个司机不知道实际情况并非总是如此。他们可能会想：“在这个平台上我每小时才赚 3 美元”，然后他们就再也不回来了。所以，如果你能有针对性地简化这种体验或使其标准化，通常会非常有帮助。这就是为什么你会看到这两家公司都在竞争，以保证最高的首周或首月收入。他们试图向你证明，长期来看体验就是这样的，你把所有那些低于平均水平的首次体验拉升到平均水平，从而驱动未来更好的留存曲线。

---

### [00:23:12] Lenny

**English:**
Amazing. Such a great example and story. It makes me think about this work that I imagine every company ends up doing, which is what are leading indicators of future retention. I'm curious if you've had success doing that. I find there's always these obvious things that you can't do much about to increase retention down the road and there's always this idea of building some ML model that's like anticipating retention based on some behaviors that someone takes. Have you had any experience, any success with those sorts of investments?

**中文翻译:**
太棒了。真是个极好的例子和故事。这让我想起我猜每家公司最终都会做的工作，即寻找未来留存的领先指标（Leading Indicators）。我很好奇你在这方面是否取得过成功。我发现总有一些显而易见的事情是你无法改变的，无法以此增加未来的留存；而且总有人想建立某种机器学习（ML）模型，根据某人的某些行为来预测留存。你在这些投资方面有经验或成功案例吗？

---

### [00:23:41] Dan Hockenmaier

**English:**
I think one of the most common analytical failure modes is this pattern, which is our best users do X, so why can't we make other users do that same thing and then drive future attention. It almost never works that way because there's something unique about that customer and their experience which is driving it. And so these correlational exercises, I put very little weight in because I've rarely been able to move Bucket B into the better Bucket A, for example. So I think it's much more about understanding where the real drivers of value are, how to create that really good first round experience to prove to them.

**中文翻译:**
我认为最常见的分析失败模式之一就是这种模式：我们最好的用户做了 X，所以为什么我们不能让其他用户也做同样的事，从而驱动未来的留存。这几乎行不通，因为那个客户及其体验中存在一些独特的东西在驱动着这种行为。因此，我不太看重这些相关性练习，因为我很少能成功地将 B 组用户转变为更好的 A 组用户。所以我认为，更多的是要理解真正的价值驱动因素在哪里，以及如何创造那种非常棒的第一轮体验来向他们证明价值。

---

### [00:24:12] Lenny

**English:**
Awesome. And it's interesting that onboarding comes up a lot on these conversations, just the power of onboarding and how much effect that has down the road.

**中文翻译:**
太棒了。有趣的是，在这些对话中经常提到入驻（Onboarding），入驻的力量以及它对未来的巨大影响。

---

### [00:24:20] Lenny

**English:**
To your point, people often want to increase retention by focusing on people about to turn and this is a great reminder that your biggest lever is early on when they're just experiencing for the first time.

**中文翻译:**
正如你所说，人们通常想通过关注即将流失的人来增加留存，而这是一个很好的提醒：你最大的杠杆是在早期，当他们刚刚开始第一次体验时。

---

### [00:24:30] Dan Hockenmaier

**English:**
So yeah, the flip side is absolutely true, right? Working on early user experience is highly impactful. You often see product teams say we should work on resurrection because we have this huge pool of users that is churned out. If we get just 1% of those people back, it's going to be such a big lift. The problem is that pool of users is the group of people who has tried the product and decided they don't want to use it and so it's very hard to convince them otherwise. It's usually much higher leverage to focus on new users and, as a result, typically you want to wait to spin up resurrection efforts until you've exhausted some of these earlier funnel efforts.

**中文翻译:**
是的，反面也绝对正确。致力于早期用户体验是非常有影响力的。你经常看到产品团队说我们应该致力于“召回”（Resurrection），因为我们有庞大的已流失用户池。如果我们能让其中 1% 的人回来，那将是一个巨大的提升。问题是，那个用户池里的人是已经尝试过产品并决定不想使用它的人，所以很难说服他们改变主意。通常关注新用户的杠杆作用要高得多，因此，通常你想等到耗尽了早期漏斗的努力后，再开始启动召回工作。

---

### [00:25:02] Lenny

**English:**
So I want to transition a bit to talking about marketplaces. I honestly can't think of anyone that's worked on more marketplace companies than you. Maybe Jeff Jordan at a16z who's invested in Airbnb and worked at eBay and OpenTable and these companies. But I feel you have so much insight into how to grow and run a marketplace and so I'm really excited to dig in to stuff here.

**中文翻译:**
所以我想转而谈谈撮合市场（Marketplaces）。老实说，我想不出有谁比你参与过的撮合市场公司更多了。也许 a16z 的 Jeff Jordan 算一个，他投资了 Airbnb，并在 eBay 和 OpenTable 等公司工作过。但我感觉你对如何增长和运营撮合市场有非常深刻的见解，所以我非常兴奋能在这里深入探讨。

---

### [00:25:23] Lenny

**English:**
My first question, just why are you excited about marketplaces? What gets you continuously interested in working on marketplaces and why are they such interesting and good businesses?

**中文翻译:**
我的第一个问题是，你为什么对撮合市场感到兴奋？是什么让你持续对从事撮合市场工作感兴趣？为什么它们是如此有趣且优秀的业务？

---

### [00:25:32] Dan Hockenmaier

**English:**
Why is a marketplace a good business? The first thing is it's like a perfect fit for the venture model, which is why everybody's so interested in them, right? They're very hard to get started, super capital intensive to get started, but once they're rolling, they're very hard to stop. You get this kind of compounding defensibility and gains that makes them very hard to stop. And, as a result, as a marketplace grows, you see these crazy things in the metrics which you don't see for most other businesses. So typically, as you acquire more and more customers, you're acquiring the marginally good fit customer over time and your CACs go up, your LTVs go down, it gets harder and harder.

**中文翻译:**
为什么撮合市场是好业务？首先，它与风险投资模型完美契合，这就是为什么大家都对它感兴趣，对吧？它们很难起步，起步阶段极其耗费资金，但一旦运转起来，就很难停止。你会获得这种复合的防御性和收益，使它们极难被撼动。结果就是，随着撮合市场的增长，你会看到指标中出现一些在大多数其他业务中看不到的疯狂现象。通常情况下，随着你获取越来越多的客户，你获取的是随时间推移匹配度逐渐降低的边际客户，你的获客成本（CAC）会上升，终身价值（LTV）会下降，业务变得越来越难。

---

### [00:26:08] Dan Hockenmaier

**English:**
Marketplace is actually the inverse. The supply liquidity is improving, the experience is improving. So often actually as you see later cohorts in marketplaces, CAC goes down, LTV goes up. You see this crazy inversion where the business gets better and better over time. And so that's I think one of the reasons they're such great businesses. I think to your question on why they're fun to work on, I think everything is just harder. Every question is more complex and so that's made them I think really fun to work on for me.

**中文翻译:**
撮合市场实际上恰恰相反。供应流动性在改善，体验在改善。所以通常在撮合市场中，你会看到后期的留存群组中，CAC 在下降，LTV 在上升。你会看到这种疯狂的反转，业务随着时间的推移变得越来越好。我认为这就是它们成为如此优秀业务的原因之一。至于你问为什么从事这类工作很有趣，我认为是因为一切都更难。每个问题都更复杂，这让我觉得从事这类工作非常有趣。

---

### [00:26:37] Lenny

**English:**
And that's interesting coming back to your first point about marketplaces are hard to start, but once they're started they become cheaper to grow and you build moats and work effects. It feels like you as a advisor and person that works on marketplaces, the same thing happens. The fact that you've worked at so many marketplaces makes it more interesting and fun I imagine because you've seen so much of this and so many people haven't experienced this, and so there's almost a Dan Hockenmaier network effect.

**中文翻译:**
这很有趣，回到你说的第一点：撮合市场起步难，但一旦起步，增长成本就会降低，并且你会建立护城河和网络效应。感觉作为一名顾问和从事撮合市场工作的人，同样的事情也发生在你身上。你参与过这么多撮合市场，这让工作变得更有趣，因为你见识过太多这样的情况，而很多人都没有经历过，所以几乎形成了一种“Dan Hockenmaier 网络效应”。

---

### [00:27:02] Dan Hockenmaier

**English:**
I appreciate that. I mean I think there's a few folks in this community who've worked with a bunch of marketplace, and you start to see the same topics over and over. So it's really fun to riff with that group on these topics.

**中文翻译:**
谢谢。我的意思是，在这个圈子里有几个人参与过很多撮合市场，你会开始反复看到相同的话题。所以和那群人一起探讨这些话题真的很有趣。

---

### [00:27:12] Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing platform built by Airbnb alums for modern growth teams. Companies like Netlify, Contentful and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern growth team stack. This leads to waste of time building internal tools or trying to run your experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved about our experimentation platform was being able to easily slice results by device, by country, and by user stage.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 A/B 测试平台。像 Netlify、Contentful 和 Cameo 这样的公司都依靠 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有能与现代增长团队技术栈集成的商业工具。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具运行实验。当我在 Airbnb 时，我最喜欢我们的实验平台的一点是，能够轻松地按设备、国家和用户阶段对结果进行切片分析。

---

### [00:27:49] Lenny

**English:**
Eppo does all that and more delivering results quickly, avoiding annoying prolonged analytics cycles and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic click through metrics and instead use your north star metrics like activation, retention, subscriptions and payments. And Eppo supports tests on the front end, the back end, email marketing and even machine learning clients. Check out Eppo at geteppo.com, geteppo.com and 10X your experiment velocity.

**中文翻译:**
Eppo 能做到这一切甚至更多，它能快速交付结果，避免恼人的漫长分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基础的点击率指标，转而使用你的北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。请访问 geteppo.com 查看 Eppo，让你的实验速度提升 10 倍。

---

### [00:28:22] Lenny

**English:**
Okay, so we're thinking about marketplaces. One of the biggest questions people ask about marketplaces is how do you know if they're going well? What are health metrics? What are KPIs that you find are most helpful to think about when evaluating the health of a marketplace?

**中文翻译:**
好了，我们来思考一下撮合市场。关于撮合市场，人们问得最多的问题之一是：你如何知道它们运行良好？什么是健康指标？在评估撮合市场的健康状况时，你认为哪些 KPI（关键绩效指标）最有帮助？

---

### [00:28:36] Dan Hockenmaier

**English:**
I can give you a couple of pretty obvious ones or basic ones and a couple that are a little bit more nuanced. So that in that first bucket, certainly you need to look at some measure of GMV or transactions. You need something that brings together both the supply and demand side to make sure it's working and that's typically your ultimate north star of which everything else ladders up to.

**中文翻译:**
我可以给你几个非常显而易见或基础的指标，以及几个更细致的指标。在第一类中，当然你需要看 GMV（商品交易总额）或交易量的某种衡量标准。你需要一个能将供给侧和需求侧结合在一起的指标，以确保其正常运作，这通常是你的终极北极星指标，其他所有指标都向其靠拢。

---

### [00:28:54] Dan Hockenmaier

**English:**
I think the second would be a deep understanding of unit economics because the dynamic I talked about where they're hard to get started means that most marketplace in the early days have pretty poor or maybe even negative unit economics. Instacart famously was losing the money on every order. Uber was losing money on every drive. And so I think understanding that and the components that lead up to it is a very important part of understanding your marketable. So those would be the two kind of obvious ones.

**中文翻译:**
我认为第二个是对单位经济效益（Unit Economics）的深刻理解。因为我提到的那种起步难的动态意味着大多数撮合市场在早期阶段的单位经济效益相当差，甚至可能是负的。著名的例子是 Instacart 曾经在每笔订单上都亏钱，Uber 曾经在每次行程中都亏钱。因此，我认为理解这一点以及导致它的组成部分是理解你的撮合市场的一个非常重要的部分。这是两个显而易见的指标。

---

### [00:29:19] Dan Hockenmaier

**English:**
I think other two that I would look at beyond that, number one is liquidity. And this is a really broad term that people define in a bunch of different ways. The definition I would give is how reliable is the marketplace? If the consumer is looking for something or supplier is looking to sell something, how often can they do that thing that they're trying to do? And ideally you want to express this metric in the form of a dimension or a type of product experience that a customer really cares about. So for Uber or Lyft, wait time is a classic example. As you add more supply, the average wait time for a customer goes down and there's some magic moment around four or five minutes where it really clicks and is now just a much better service than calling a traditional taxi or something else.

**中文翻译:**
除此之外，我还会看另外两个指标。第一是流动性（Liquidity）。这是一个非常宽泛的术语，人们有各种定义。我给出的定义是：这个撮合市场有多可靠？如果消费者在寻找某样东西，或者供应商想卖某样东西，他们能成功做到这件事的频率是多少？理想情况下，你想以客户真正关心的维度或产品体验形式来表达这个指标。对于 Uber 或 Lyft，等待时间是一个经典例子。随着你增加更多供应，客户的平均等待时间会下降，在四到五分钟左右会有一个“神奇时刻”，服务会突然变得顺畅，比叫传统出租车或其他方式好得多。

---

### [00:30:01] Dan Hockenmaier

**English:**
For a commerce market, typically it's some form of conversion rate or search to fail metrics. So if I go look for this thing on Amazon, how often can I find it and convert? And so by articulating what the customer cares about and where this threshold is, you can tell when you have a liquid marketplace and essentially until you have a liquid marketplace, really nothing else matters. So this should be the primary thing you're focused on defining and then building towards, and this is why you hear a lot of advice to marketplaces to basically cut scope down to a specific geography or a specific category so you can focus on generating liquidity in that area before you can then scale it elsewhere. So this is the number one, I think, metric for a marketplace.

**中文翻译:**
对于电商市场，通常是某种形式的转化率或“搜索失败率”指标。如果我在亚马逊上寻找某样东西，我能找到并转化的频率是多少？通过明确客户关心什么以及阈值在哪里，你可以判断你是否拥有一个具有流动性的市场。本质上，在你拥有流动性之前，其他一切都不重要。所以这应该是你关注、定义并努力实现的首要任务。这就是为什么你经常听到给撮合市场的建议是：基本上要把范围缩小到特定的地理区域或特定的类目，这样你就可以专注于在该领域产生流动性，然后再扩展到其他地方。所以我认为这是撮合市场的头号指标。

---

### [00:30:41] Dan Hockenmaier

**English:**
And the last one I'll give is share of wallet. So this is effectively for your buyer, how much of their total spend are you getting on your marketplaces versus the alternatives. For your seller, how much of the business that they're doing is you versus others? So for Uber drivers, if they spend X amount of hours driving per week, how much are you getting versus Lyft or Door Dash or something else? For a retailer on Faire, if they're buying to stock their store, how much of the product on their shelf came from Faire versus from somewhere else? These are very important metrics for us to understand.

**中文翻译:**
最后一个指标是钱包份额（Share of Wallet）。这实际上是指对于你的买家，他们在你的市场上花费的总额相对于其他替代方案是多少。对于你的卖家，他们所做的业务中有多少是通过你完成的，相对于其他平台是多少？对于 Uber 司机，如果他们每周花 X 小时开车，你在其中占多少，相对于 Lyft 或 DoorDash 等平台是多少？对于 Faire 上的零售商，如果他们进货来填充店面，他们货架上的产品有多少来自 Faire，有多少来自其他地方？这些是我们必须理解的非常重要的指标。

---

### [00:31:11] Dan Hockenmaier

**English:**
One, for the obvious reason that as it goes up, your LTVs go up and you have a much better business. But probably more importantly than that, the higher it is, the less likely a customer is to multi-tenant, meaning use another marketplace or another service. And ideally you want that customer to commit to using just this marketplace and the higher share of wallet is the more likely that is. But I will say that it's very hard typically to get this to happen on both sides of the marketplace simultaneously. So often you have to pick your leverage point, which one do you think you can actually drive very high share of wallet on.

**中文翻译:**
原因之一显而易见：随着该指标上升，你的 LTV 会上升，业务会变得更好。但可能更重要的一点是，该指标越高，客户就越不可能“多平台使用”（Multi-tenanting），即使用另一个市场或服务。理想情况下，你希望客户承诺只使用这一个市场，而钱包份额越高，这种可能性就越大。但我必须说，通常很难让市场的双侧同时实现这一点。所以你通常必须选择你的杠杆点，即你认为你真正能驱动哪一侧产生极高的钱包份额。

---

### [00:31:41] Lenny

**English:**
Awesome. Okay. So just to summarize, the metrics that you find to be most helpful in tracking marketplace health, there's these two that are just general business health metrics, GMV and unit economics. Then I think what's most unique to marketplaces, which is liquidity and essentially it's just like how often are people having a good time on both sides of the marketplace? And I love the way you broke it up like for Uber it would be how quickly do you get a car. For most marketplaces, it's just like what percentage of the time do you get something that you want, fill rate basically. And then share a wallet, which to me feels like ... even again going back to the first kind of bucket of just broadly this business going well, do you think about that separately versus just business growth and how much we're making, do you feel like share of wallet is a different category of metric?

**中文翻译:**
太棒了。好的，总结一下，你认为对追踪撮合市场健康状况最有帮助的指标有：两个通用的业务健康指标，即 GMV 和单位经济效益。然后是撮合市场最独特的指标，即流动性，本质上就是市场双侧的用户获得良好体验的频率。我喜欢你拆解它的方式，比如对于 Uber 来说就是你多久能打到车；对于大多数市场来说，就是你有多大比例的时间能得到你想要的东西，基本上就是满足率（Fill Rate）。然后是钱包份额，对我来说这感觉……再次回到第一类广义的业务运行良好的指标，你会把它与业务增长和盈利额分开考虑吗？你觉得钱包份额属于不同类别的指标吗？

---

### [00:32:30] Dan Hockenmaier

**English:**
I do think share of wallet is different for this reason. If you could tell me we could grow GMV 10% by getting 10% more customers or by getting 10% more of our current customers' wallet, I would take the latter because you now have a deeper relationship with them, which tells you something more about the future retention and defensibility of the marketplace. So I think it's basically a measure of depth rather than breadth. And I will take depth every time in a marketplace.

**中文翻译:**
我确实认为钱包份额是不同的，原因如下：如果你告诉我，我们可以通过增加 10% 的客户来增长 10% 的 GMV，或者通过从现有客户的钱包中多拿 10% 来增长 10% 的 GMV，我会选择后者。因为你现在与他们建立了更深层次的关系，这能告诉你更多关于市场未来留存和防御性的信息。所以我认为它基本上是衡量深度而非广度。在撮合市场中，我每次都会选择深度。

---

### [00:32:57] Lenny

**English:**
Awesome. You worked on consumer and B2B marketplaces and so I'm curious, do you find share of wallet is important on both types of marketplaces or is it a lot more important in B2B?

**中文翻译:**
太棒了。你从事过消费者和 B2B 撮合市场的工作，所以我很好奇，你觉得钱包份额在这两类市场中都重要吗？还是在 B2B 中更重要？

---

### [00:33:06] Dan Hockenmaier

**English:**
So you typically have some form of business on the supply side of a marketplace. Maybe it's a pseudo business that's effectively a consumer, but you can almost always measure some form of share of wallet on the supply side of a marketplace no matter what. On the consumer side, if you're a B2B marketplace, you typically have a cleaner share of wallet metric, but it's not always the case for consumer businesses.

**中文翻译:**
通常在撮合市场的供给侧会有某种形式的业务。也许它是一个伪业务，本质上是消费者，但无论如何，你几乎总是可以在供给侧衡量某种形式的钱包份额。在需求侧，如果你是一个 B2B 市场，你通常会有一个更清晰的钱包份额指标，但对于消费者业务来说并不总是如此。

---

### [00:33:25] Lenny

**English:**
Sweet. And again, just to clarify share of wallet, it's essentially percentage of spend in, say, a problem space that they're giving to you. So for Faire, it'd be like the retailers, what percentage of their vendors come through Faire?

**中文翻译:**
太好了。再次澄清一下钱包份额，它本质上是他们在某个问题领域（比如进货）中花在你这里的支出百分比。对于 Faire 来说，就像零售商的供应商中有百分之几是通过 Faire 找到的？

---

### [00:33:39] Dan Hockenmaier

**English:**
Exactly. If you look at their shelf in their store, what percentage of that shelf came from Faire versus something else?

**中文翻译:**
没错。如果你看他们店里的货架，货架上百分之几的产品来自 Faire，百分之几来自其他渠道？

---

### [00:33:45] Lenny

**English:**
Awesome. Another constant question marketplace founders have is whether they should focus on supply or demand. And I know it's never black and white, but do you have any general advice on where to focus?

**中文翻译:**
太棒了。撮合市场创始人经常遇到的另一个问题是，他们应该关注供给还是需求。我知道这从来不是非黑即白的，但你对关注点在哪里有什么通用的建议吗？

---

### [00:34:00] Dan Hockenmaier

**English:**
Yeah. I mean the answer is obviously both to some extent. I think you can't ignore either side. I do think though that on average when you hear advice about where to focus, people over rotate on supply and actually are under focused on demand. And I think there's a couple of reasons for this. One is supply is disproportionately important early on because it is the product. Until you have enough supply, you don't have anything and so you do have to focus on it to a high degree early on. And two is often the supply side of marketplace is using the product more deeply. There's more product surface area and you need more product resources on the supply side.

**中文翻译:**
是的。我的意思是，答案显然在某种程度上是两者兼顾。我认为你不能忽视任何一方。不过，我确实认为，平均而言，当你听到关于关注点的建议时，人们往往过度倾向于供给，而实际上对需求的关注不足。我认为原因有几点。一是供给在早期阶段异常重要，因为它就是产品本身。在你拥有足够的供给之前，你一无所有，所以你在早期确实必须高度关注它。二是撮合市场的供给侧通常对产品的使用更深。供给侧有更多的产品表面积，你需要更多的产品资源投入到供给侧。

---

### [00:34:35] Dan Hockenmaier

**English:**
However, I think this tricks people into thinking that that's the optimization function or you think you should think more about supply. I think ultimately demand is the only thing that matters. If you are successful at aggregating the demand in your industry, you will have the winning marketplace. Because if you go to a supplier, a restaurant or an electrician or a driver and say, "I have this customer for you that I can give to you at a rate that's going to make you money," they're always going to say yes. And so demand is the currency. And so when you think about trade-offs or how to optimize a business, I think taking the perspective of the customer or the demand side is always the right one.

**中文翻译:**
然而，我认为这误导了人们，让他们以为那是优化函数，或者认为应该更多地考虑供给。我认为最终需求才是唯一重要的事情。如果你能成功聚合行业内的需求，你就会成为获胜的撮合市场。因为如果你去找一个供应商（餐厅、电工或司机）说：“我这里有一个客户可以介绍给你，而且价格能让你赚钱”，他们总是会答应的。所以需求才是硬通货。因此，当你考虑权衡或如何优化业务时，我认为从客户或需求侧的角度出发永远是正确的。

---

### [00:35:11] Lenny

**English:**
I think there's a really important nuance here, and there's actually a little mini Twitter debate with Bill Gurley I think a while ago where he made the same point that in the end, the most important thing you got to get right is aggregate all the demand. You need to become the place people come to transact in that space. But oftentimes the way you do that is acquire supply that is hard to acquire. And so would you agree with that? Often it's just, yes, prioritize the customer experience, but that may be you need to spend most of your time acquiring supply so that they're happy.

**中文翻译:**
我认为这里有一个非常重要的细微差别。不久前在 Twitter 上与 Bill Gurley 有过一场小辩论，他也提出了同样的观点：最终，你必须做对的最重要的事情是聚合所有需求。你需要成为人们在该领域进行交易的首选之地。但通常情况下，实现这一目标的方法是获取那些难以获取的供应。你同意这一点吗？通常情况下，是的，优先考虑客户体验，但这可能意味着你需要花费大部分时间来获取供应，以便让客户满意。

---

### [00:35:40] Dan Hockenmaier

**English:**
Absolutely. And the culmination of those two points is you only should acquire supply to the extent you understand how it impacts demand. So, for example, if we go back to this liquidity metric, there is some point for a market for Uber where you don't want more supply because you're no longer reducing wait times or doing something that improves the customer experience in a meaningful way. And similarly to the kind of pet store example on Amazon, there's some amount of supply where you're probably no longer incrementally improving the pet buyer's experience and so it's probably not worth investing those dollars. So supply is critically important, but it has to be framed from what is the customer benefit that I'm driving.

**中文翻译:**
绝对同意。这两点的结合点在于：你获取供应的程度，应该取决于你对它如何影响需求的理解。例如，回到流动性指标，对于 Uber 这样的市场，在某个点上你就不再需要更多供应了，因为你不再能缩短等待时间，或者做一些能显著改善客户体验的事情。同样，在亚马逊的宠物店例子中，当供应达到一定量后，你可能不再能递增地改善宠物买家的体验，因此可能不值得再投入资金。所以供应至关重要，但必须从“我正在驱动什么样的客户利益”这个框架出发。

---

### [00:36:17] Lenny

**English:**
And another way to put that is what's the biggest constraint to your marketplace's growth, right?

**中文翻译:**
另一种说法是，你的撮合市场增长的最大约束是什么，对吧？

---

### [00:36:21] Dan Hockenmaier

**English:**
Right.

**中文翻译:**
对。

---

### [00:36:22] Lenny

**English:**
While we're on that topic, do you have any just rough heuristic that you use to understand which side is most constrained? This may be a big question that isn't answerable in a short answer, but any thoughts there?

**中文翻译:**
既然谈到这个话题，你有没有什么粗略的启发式方法（Heuristic），用来理解哪一侧受到的约束最大？这可能是一个大问题，无法用简短的回答来解决，但有什么想法吗？

---

### [00:36:35] Dan Hockenmaier

**English:**
One is I've actually become less and less focused on pure marketplace balance metrics. They're important to monitor, so ratio of buyers to sellers, some of these other things. But actually the thing that matters is can you write an ROI equation for acquiring supply and demand which fully internalizes the marketplace dynamic. So what I mean by this is if you're acquiring a new customer, you need to include the CAC of acquiring that customer, but also the CAC of acquiring the supply for that customer to purchase, which is based on some ratio between the two.

**中文翻译:**
一是实际上我越来越不关注纯粹的市场平衡指标了。监控买卖双方的比例等指标固然重要，但真正重要的是，你是否能写出一个获取供给和需求的 ROI（投资回报率）等式，并能完全内化市场的动态。我的意思是，如果你在获取一个新客户，你需要包含获取该客户的 CAC，但也需要包含获取供该客户购买的供应的 CAC，这基于两者之间的某种比例。

---

### [00:37:09] Dan Hockenmaier

**English:**
And similarly on the supply side, that business can't make a sale unless you also acquire the customer to transact with them. And so if you have dual-sided ROI equations which are appropriately capturing this dynamic, actually I think you can somewhat ignore marketplace balance and just push your acquisition all the way out to the payback period that you're comfortable with on either side. I think the one exception to this would be are there externalities which you can't capture in this equation. So for example, if you have too little demand for Uber drivers, at some point do they just become disillusioned with the service, switch to Lyft, talk badly about it on social media. You do have to look out for extreme low supply or demand scenarios. But generally my view is build really strong ROI models that account for this and then just push to your threshold.

**中文翻译:**
同样在供给侧，除非你也获取了与之交易的客户，否则那笔业务无法成交。所以，如果你有能恰当捕捉这种动态的双侧 ROI 等式，实际上我认为你可以在某种程度上忽略市场平衡，只需将你的获客推向你在任何一侧都能接受的回本周期。我认为唯一的例外是是否存在你无法在等式中捕捉到的“外部性”。例如，如果 Uber 司机的需求太少，在某个点上他们是否会由于对服务感到失望而转向 Lyft，或者在社交媒体上发表负面言论。你确实需要警惕极端低供应或低需求的场景。但总的来说，我的观点是建立非常强大的 ROI 模型来考虑这一点，然后只需推向你的阈值即可。

---

### [00:37:57] Lenny

**English:**
I like the sound of these ROI models. Do you have any guidance for folks to come up with these models in some way? Or is that a whole master class of its own?

**中文翻译:**
我喜欢这些 ROI 模型。你对人们如何制定这些模型有什么指导吗？还是说这本身就是一门大师课？

---

### [00:38:06] Dan Hockenmaier

**English:**
So there's a lot of nuance by business, but the basic formulation is CAC for the side you're focused on. So let's take Uber again, as an example. CAC to acquire a rider and then an additional amount of CAC loaded on for the supply, the drivers that you're acquiring, times the ratio of drivers to supply you're acquiring at that time. So basically, do I need one driver for every 10 passengers? We then take the CAC of that passenger times 10% of a driver. That gives you CAC and then you compare that to the LTV of the customer, and that allows you to calculate payback period.

**中文翻译:**
不同业务有很多细微差别，但基本公式是你关注那一侧的 CAC。再以 Uber 为例：获取一名乘客的 CAC，再加上分摊到供应侧（即你获取的司机）的额外 CAC，乘以当时你获取的司机与乘客的比例。基本上就是，我每 10 名乘客需要一名司机吗？然后我们将该乘客的 CAC 加上 10% 的司机 CAC。这得出了总 CAC，然后你将其与客户的 LTV 进行比较，从而计算出回本周期。

---

### [00:38:44] Dan Hockenmaier

**English:**
Now there's a lot of nuance when you get into an actual marketplace because often they're referring other sides of the marketplace or other things are happening. But that's the basic formulation.

**中文翻译:**
当然，当你进入实际的市场时，会有很多细微差别，因为通常他们会推荐市场的另一侧，或者发生其他事情。但这就是基本的公式。

---

### [00:38:53] Lenny

**English:**
Wow. Okay. We should do an actual master class on this formula concoction.

**中文翻译:**
哇。好的。我们应该专门开一门关于这个公式调配的大师课。

---

### [00:38:57] Lenny

**English:**
A question I wanted to cover also is I find that for early stage marketplaces, founders sometimes over focus on the theory of marketplaces and how all this stuff that people have put out, including yourself and others, about just how to think about marketplace, all the complexity there. But I find that oftentimes it's simpler just to think of a marketplace like 90 something percent of your success is going to be the same things that any business will have to deal with, growth and profit and retention, all these things. And then there's these additional layers that make a marketplace more complicated. And so just to double click on that last piece, what have you found to be most different about working on a marketplace business versus non-marketplace business?

**中文翻译:**
我还想讨论一个问题：我发现对于早期撮合市场，创始人有时会过度关注撮合市场理论，以及包括你在内的很多人发布的关于如何思考撮合市场及其复杂性的内容。但我发现，通常情况下，把撮合市场想得简单点更好——你 90% 以上的成功将取决于任何业务都必须处理的相同事情：增长、利润和留存等等。然后才是让撮合市场变得更复杂的额外层面。所以，针对最后一点，你发现从事撮合市场业务与非撮合市场业务最大的不同是什么？

---

### [00:39:43] Dan Hockenmaier

**English:**
Yeah, it's a good question. So I think that effectively every decision you make in a marketplace has a second order consequence that you need to think through and maybe third and fourth order consequences at that. Take something like pricing. It's like this is a pretty complicated topic no matter what, but if you're looking at a SaaS business and you're trying to figure out how to price your subscription, theoretically you can draw a curve which says, "As my price goes up, fewer are going to convert," and so just find the optimal point on that curve where we're managing the tangent between more customers versus more revenue per customer.

**中文翻译:**
是的，这是个好问题。我认为，实际上你在撮合市场中做出的每一个决定都有你需要考虑的二阶后果，甚至可能是三阶和四阶后果。以定价为例。无论如何这都是一个相当复杂的话题，但如果你看的是 SaaS 业务，并试图弄清楚如何为订阅定价，理论上你可以画一条曲线，上面写着：“随着价格上涨，转化的人会减少”，所以只需在那条曲线上找到一个最优点，在更多客户与每个客户更多收入之间找到平衡。

---

### [00:40:15] Dan Hockenmaier

**English:**
But if you take a marketplace, typically you're charging commission on the supply side and their sensitivity to that commission is much harder to understand because, theoretically, if they can transact at a rate that makes them money, they'll sign up all the way to that highest possible commission you could charge. The more you charge, the more you can fund benefits for your customers. So if Amazon charges a higher commission, they can fund more returns and faster shipping for their customers. And so what's the right balance between charging more and maybe kind of discouraging supply from signing up to giving more benefits to demand and encouraging them to sign up?

**中文翻译:**
但如果你看撮合市场，通常你是在供给侧收取佣金，而他们对佣金的敏感度要难理解得多。因为理论上，如果他们能以赚钱的速率进行交易，他们会一直注册，直到你收取的最高可能佣金。你收取的费用越多，你就能为客户提供更多的福利。如果亚马逊收取更高的佣金，他们就可以为客户提供更多的退货服务和更快的物流。那么，在收取更多费用（这可能会阻碍供应方注册）与给需求方提供更多福利（并鼓励他们注册）之间，正确的平衡点在哪里？

---

### [00:40:52] Dan Hockenmaier

**English:**
So it's very hard to model that kind of relationship. There's not a simple curve that describes it and so many decisions follow this same pattern. And one lesson I've learned the hard way a bunch of times on this is that if you think about running a marketplace, you're basically a gardener. You have to have a very light touch. If you're building a SaaS business, you're a construction worker, you're building the product and the features and selling it, and it's this very linear thing. For a marketplace, you're messing with this ecosystem that you don't actually really understand how it works. Sometimes you might do something over here which drives this long-term effect two months later and then you're going to be pulling your hair out two months later trying to figure out what you did over here that made that thing happen.

**中文翻译:**
所以很难对这种关系进行建模。没有一条简单的曲线可以描述它，而且很多决策都遵循这种模式。关于这一点，我多次通过惨痛教训学到的一个道理是：如果你在经营一个撮合市场，你基本上就是一个园丁。你必须动作非常轻柔。如果你在建立一个 SaaS 业务，你就是一个建筑工人，你在构建产品和功能并进行销售，这是一个非常线性的过程。而对于撮合市场，你是在干预一个你其实并不真正了解其运作方式的生态系统。有时你可能在这里做了一件事，却在两个月后引发了长期的连锁反应，然后两个月后你会抓狂地试图弄清楚你当初在这里做了什么导致了那件事的发生。

---

### [00:41:30] Dan Hockenmaier

**English:**
And so I think that the main advice is to tread lightly. When you're messing with the core incentives or mechanisms of a marketplace, be very careful, particularly if you got something that's working on playing with those variables.

**中文翻译:**
所以我认为核心建议是谨慎行事。当你触动撮合市场的核心激励措施或机制时，要非常小心，特别是当你已经有一套行之有效的变量在运作时。

---

### [00:41:42] Lenny

**English:**
I love that metaphor and your point about pricing reminds me ... Your colleague at Faire, Carla Pellicano, she led the pricing recommendations team at Airbnb. It was a team of, I don't know, probably a hundred people that were just dedicated to pricing, figuring out what prices to recommend to hosts, how to get them to adopt these recommendations, building a model to actually come up with the recommendations. And so to your point, pricing is such a complex beast and especially in a marketplace.

**中文翻译:**
我喜欢这个比喻。你关于定价的观点让我想起……你在 Faire 的同事 Carla Pellicano，她曾领导 Airbnb 的定价建议团队。那是一个大概有一百人的团队，专门负责定价，研究该向房东推荐什么价格，如何让他们采纳这些建议，并建立模型来实际生成这些建议。所以正如你所说，定价是一个如此复杂的怪兽，尤其是在撮合市场中。

---

### [00:42:09] Dan Hockenmaier

**English:**
Absolutely. And in general, Carla's been such an incredible force in growing our team and helping us think more rigorously about marketplaces. This is one of the things I mentioned at the start that makes Faire so fun is we've got a lot of people like this that are just so fun to riff with on marketplace problems.

**中文翻译:**
绝对是。总的来说，Carla 在壮大我们的团队和帮助我们更严谨地思考撮合市场方面发挥了不可思议的作用。这就是我开头提到的让 Faire 如此有趣的原因之一：我们有很多这样的人，和他们一起探讨撮合市场问题非常有趣。

---

### [00:42:23] Lenny

**English:**
There's so many ex-Airbnb people at Faire. It seems to be a magnet for the Airbnb alumni. So whatever you're doing, keep that up.

**中文翻译:**
Faire 有这么多前 Airbnb 的员工。它似乎成了 Airbnb 校友的磁铁。所以无论你们在做什么，请继续保持。

---

### [00:42:30] Lenny

**English:**
Another topic that I wanted to chat about is expanding marketplaces and just the idea of thinking about where you expand to with new markets, new verticals, and then also horizontal versus vertical marketplaces. But first, how do you think about the idea of expanding your marketplace once you've got a foothold in a specific area?

**中文翻译:**
我想聊的另一个话题是扩展撮合市场，以及思考向新市场、新垂直领域扩展的想法，还有水平市场与垂直市场的对比。但首先，一旦你在特定领域站稳了脚跟，你如何看待扩展撮合市场的想法？

---

### [00:42:48] Dan Hockenmaier

**English:**
I've been fortunate to work on marketplaces that are in these massive, massive industries, which is actually true for a lot of marketplaces because they tend to have winner take all dynamics in really big markets. And so you get these really huge [inaudible 00:42:59].

**中文翻译:**
我很幸运能参与那些处于巨大行业的撮合市场，这实际上对很多撮合市场来说都是如此，因为它们往往在巨大的市场中具有“赢家通吃”的动态。所以你会得到这些非常巨大的……

---

### [00:42:59] Dan Hockenmaier

**English:**
So the local services industry for Thumbtack or the global wholesale industry for Faire, these are meaningful percentages of global GDP. They're huge markets and, as a result, they're really frustrating to work on and also really fun to work on because you have this thing where there's 10 big opportunities that are just one click away from your core business and they all seem really good ideas to do. So how do you actually prioritize between doing those different things? And one thing I've learned here is that actually beyond a certain point, TAM or the size of the market actually matters very little because these are all big enough that they would dramatically inflect the curve of the business if you make them work.

**中文翻译:**
比如 Thumbtack 所处的本地服务行业，或者 Faire 所处的全球批发行业，这些都占全球 GDP 的很大比例。它们是巨大的市场，因此，从事这些工作既令人沮丧又非常有趣，因为你会发现有 10 个巨大的机会距离你的核心业务仅一步之遥，而且看起来都是非常棒的主意。那么，你实际上如何在做这些不同的事情之间确定优先级呢？我在这里学到的一点是，实际上超过一定程度后，TAM（总可寻址市场）或市场规模其实并不重要，因为这些市场都足够大，只要你做成了，它们都会极大地改变业务的增长曲线。

---

### [00:43:35] Dan Hockenmaier

**English:**
It's much more relevant to focus on a couple things. One is how adjacent is that to the business as a proxy for can we actually go get it? So if you think about Instacart's setup options, it makes much more sense for them to expand into convenience stores which they have than into traditional retailers because the convenience store looks much more like their current model. The high frequency, shipping speed matters a lot, fulfillment speed matters a lot. And so it's much more likely their current model's going to work there than trying to expand into something else. And that's the right prioritization function for them to think about versus as retail is a slightly bigger market that could be in stores.

**中文翻译:**
更相关的做法是关注几件事。一是该领域与现有业务的“邻近度”（Adjacency），以此作为我们是否能真正拿下的指标。如果你考虑 Instacart 的设置选项，对他们来说，扩展到便利店（他们已经这么做了）比扩展到传统零售商更有意义，因为便利店看起来更像他们目前的模式：高频、配送速度至关重要、履约速度至关重要。因此，他们目前的模式更有可能在那里奏效，而不是尝试扩展到其他领域。这就是他们应该考虑的正确优先级函数，而不是仅仅因为零售是一个稍大一点的市场。

---

### [00:44:09] Dan Hockenmaier

**English:**
And the second thing is are there places that you can accentuate your network effect by expanding into new markets. And what I mean by that is are there places where you can use the same supplier or a consumer has demand for multiple things and so it makes your marketplace stronger versus trying to spin up a new network. So for Uber, it makes all the sense in the world to have Uber Eats because, one, they're the same drivers in many cases, but two, the customer wants rides and meals. And so you automatically have this built-in supply base where if they try to do something that was one click further away from this, it would be much less important to them. And so I think that's the way to prioritize new bets.

**中文翻译:**
第二件事是，是否存在一些地方，你可以通过扩展到新市场来增强你的网络效应。我的意思是，在这些地方你可以使用相同的供应商，或者消费者对多种事物都有需求，从而让你的撮合市场变得更强大，而不是尝试建立一个全新的网络。对于 Uber 来说，拥有 Uber Eats 是非常有意义的，因为：第一，在很多情况下是同一批司机；第二，客户既需要乘车也需要用餐。所以你自动拥有了这个内置的供应基础，如果他们尝试做一些离这更远的事情，对他们来说重要性就会低得多。所以我认为这就是为新赌注确定优先级的方法。

---

### [00:44:46] Lenny

**English:**
That is such an interesting point that basically if you're thinking about the upside of a marketplace, think less about just the total TAM of all the adjacent marketplace opportunities in the markets around them and more about how easily it'll be for you to expand into them even if they're smaller.

**中文翻译:**
这真是一个非常有趣的观点：基本上，如果你在考虑撮合市场的上行空间，少去想周围市场中所有相邻机会的总 TAM，多去想你扩展到这些领域有多容易，即使它们规模较小。

---

### [00:45:01] Dan Hockenmaier

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:45:02] Lenny

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:45:04] Dan Hockenmaier

**English:**
There's one other lesson here which I've learned a few times, which is that product is the thing that matters when expanding. So because of this dynamic we talked about where liquidity is so important and there's a race to get there, like the first person, the liquidity wins, you often see this arms race where people will spend a huge amount of money on go to market and incentives to bootstrap the market. And that is an important part of the strategy because it actually does matter who drives liquidity faster.

**中文翻译:**
这里还有另一个我多次学到的教训：在扩展时，产品才是最重要的。因为我们谈到的流动性至关重要，而且存在一场争夺流动性的竞赛（谁先获得流动性谁就赢了），你经常会看到这种军备竞赛，人们会在市场进入（GTM）和激励措施上投入巨资来启动市场。这是战略的重要组成部分，因为谁能更快驱动流动性确实很重要。

---

### [00:45:33] Dan Hockenmaier

**English:**
But I've learned over and over and over that that's actually not the main thing. It's who can deliver an incredible end-to-end customer experience first, even if for a smaller number of customers. Because that's what creates the flame where actually customers are really loving it, retained, talking about it, and you can then expand from there. So the other big learning from expanding a marketplace is don't let go to market get too far ahead of product. You need to keep those two pieces in lockstep as you're expanding.

**中文翻译:**
但我一次又一次地学到，那其实不是最主要的。最主要的是谁能率先提供令人难以置信的端到端客户体验，即使只是针对少数客户。因为这才是点燃火苗的关键——客户真正喜欢它、留存下来、谈论它，然后你就可以以此为基础进行扩展。所以扩展撮合市场的另一个重要教训是：不要让市场进入（GTM）跑得比产品太远。在扩展时，你需要让这两部分保持同步。

---

### [00:46:01] Lenny

**English:**
This touches on a really common piece of advice for marketplaces, which is don't focus on GMV and growth rates and just expansion early on, but instead focus on getting a flywheel going even if it's small, to show that you can make people happy and you can give people what they're looking for. Is there anything you can add there or talk about?

**中文翻译:**
这触及了撮合市场一个非常普遍的建议：早期不要关注 GMV、增长率和扩张，而要专注于让飞轮转动起来，即使它很小，也要证明你能让人们感到快乐，并能给人们提供他们想要的东西。关于这一点你有什么补充或想说的吗？

---

### [00:46:20] Dan Hockenmaier

**English:**
Yeah, I think that's exactly right. And the reason this is the right advice is because everything else follows proving you have a good customer experience. Even if you have a very few customers, if your cohorts look really good, they're retaining or even kind of like the classic smiling curve where you see more in engagement later in the life cycle than you do earlier, that's the thing that gives the company conviction to invest resources against it. That's the reason that VCs are going to want to invest rather than a bunch of low quality GMV in a market.

**中文翻译:**
是的，我认为这完全正确。之所以这是正确的建议，是因为证明你拥有良好的客户体验后，其他一切都会随之而来。即使你只有很少的客户，如果你的留存群组看起来非常好，他们正在留存，甚至出现了经典的“微笑曲线”（即生命周期后期的参与度高于早期），这就会给公司信心去投入资源。这也是风投（VC）想要投资的原因，而不是看市场中一堆低质量的 GMV。

---

### [00:46:49] Lenny

**English:**
Awesome. Speaking of VCs, investing and expanding marketplaces, something that I've noticed is a lot of marketplaces try to find a SaaS business to build on top of their marketplace and find some kind of recurring revenue component and then, in reverse, a lot of SaaS businesses look for how do we add a marketplace to what we're doing. I'm curious how often you find that this actually works out and what do you have to get right to add this other type of business model on top of something that's working.

**中文翻译:**
太棒了。说到风投、投资和扩展撮合市场，我注意到的一件事是，很多撮合市场试图在他们的市场之上建立 SaaS 业务，寻找某种经常性收入组件；反之，很多 SaaS 业务也在寻找如何在我们正在做的事情中增加一个撮合市场。我很好奇你发现这种情况实际成功的频率有多高？要在已经运作良好的业务之上增加另一种类型的业务模型，你必须做对什么？

---

### [00:47:17] Dan Hockenmaier

**English:**
So broadly, I will say I think it's easier for a marketplace to go SaaS than it is the other direction and the reason for that is two things. One is it's a new capability to generate demand, which is fundamentally what a marketplace has to do, and it's a higher value activity. This is why the effective commission of a marketplace, often 10, 15, 20% is much higher than the effective commission of a SaaS business in the 2% to 3% range. So you're just doing much more of the value chain in the marketplace. And second is the marketplace by definition starts with relationships on both sides. But the SaaS business does not have any relationships with the demand side customer. And so they have to acquire a whole new type of demand to make this work.

**中文翻译:**
总的来说，我认为撮合市场转向 SaaS 比反向操作更容易，原因有两点。一是产生需求是一种新的能力，这基本上是撮合市场必须做的，而且是一种更高价值的活动。这就是为什么撮合市场的有效佣金（通常是 10%、15%、20%）远高于 SaaS 业务 2% 到 3% 范围内的有效佣金。所以你在撮合市场中承担了更多的价值链。二是撮合市场根据定义在双侧都有关系。但 SaaS 业务与需求侧客户没有任何关系。因此，他们必须获取一种全新的需求类型才能让这套方案奏效。

---

### [00:47:58] Dan Hockenmaier

**English:**
It's not to say it can't work. There's actually a classic kind of SaaS bootstrap to marketplace playbook. This is what OpenTable did. I think we've actually seen some new examples of companies doing this. One in the healthcare space is Solve. They built some interesting products for healthcare clinics that they're now bootstrapping into marketplace. And so I think it's possible, but I think it's very difficult. And then for a marketplace, the lens you should take is much less about how to drive more monetization, but just how do we create a much better experience for our customers because there's some painful thing that they're doing today that we can build for them instead. And so how do we better integrate with the way that they're running their back office or accounting systems is a classic example of where you can make it much better.

**中文翻译:**
这并不是说它行不通。实际上有一个经典的“SaaS 引导至撮合市场”的剧本。OpenTable 就是这么做的。我想我们实际上已经看到了一些公司这样做的最新例子。医疗保健领域的一个例子是 Solve。他们为医疗诊所构建了一些有趣的产品，现在正将其引导至撮合市场。所以我认为这是可能的，但我认为非常困难。对于撮合市场来说，你应该采取的视角不应该是如何驱动更多变现，而应该是：我们如何为客户创造更好的体验，因为他们今天正在做的一些痛苦的事情，我们可以为他们构建产品来替代。比如，我们如何更好地与他们运行后台或会计系统的方式集成，这就是一个可以做得更好的经典例子。

---

### [00:48:42] Dan Hockenmaier

**English:**
In the process, you're often making their lives easier, but you're also making your product much stickier. Your retention will go up as a result of this. And so I think if you take the lens of what's the customer pain we're solving, you'll be much more effective than how do we get a few more points of margin out of this customer.

**中文翻译:**
在这个过程中，你通常会让他们的生活变得更轻松，但你也会让你的产品变得更有粘性。你的留存率会因此上升。所以我认为，如果你从“我们正在解决什么客户痛点”的角度出发，会比“我们如何从这个客户身上多榨取几个点的利润”有效得多。

---

### [00:48:57] Lenny

**English:**
If a founder was coming to you and they're like, "Hey Dan, we are a marketplace and we're thinking about adding a SaaS product on top, would you, one, try to discourage them from that? And if, two, that doesn't work, what would you suggest that they focus on most?

**中文翻译:**
如果一个创始人来找你，说：“嘿 Dan，我们是一个撮合市场，我们正考虑在上面增加一个 SaaS 产品”，你会：第一，试图劝阻他们吗？第二，如果劝阻不成，你会建议他们最关注什么？

---

### [00:49:12] Dan Hockenmaier

**English:**
I mean I think the first thing is looking at those core metrics we talked about, do they have a really liquid high performance marketplace first. That has to be the optimization function. And before you're there, I don't think you should be thinking about some of these expansion levers.

**中文翻译:**
我的意思是，我认为第一件事是看我们谈到的那些核心指标，他们是否首先拥有一个真正具有流动性、高性能的撮合市场。这必须是优化函数。在你达到那个目标之前，我不认为你应该考虑这些扩展杠杆。

---

### [00:49:27] Dan Hockenmaier

**English:**
The second would be show me the customer problem or the reason it's so hard to engage with this marketplace today that we need to build a deep set of tools or products for this customer to solve. And if both of those things are true, then I think maybe it's quite interesting. But I think more often than not, it's better to focus on the core marketplace.

**中文翻译:**
第二件事是，向我展示客户的问题，或者展示为什么今天参与这个市场如此困难，以至于我们需要为这个客户构建一套深度的工具或产品来解决。如果这两点都成立，那么我认为这可能非常有趣。但通常情况下，专注于核心撮合市场会更好。

---

### [00:49:46] Lenny

**English:**
Awesome. Another common question that marketplace founders have is should I go vertical or should I go horizontal? So thinking about eBay as an example, they are very horizontal. You could buy anything you want on eBay. And then there's all these spinoffs that emerged, just classic cars, eBay for classic cars, eBay for guitars. And I'm curious if you have any advice there for either an early stage founder trying to decide should I go horizontal or vertical and/or where do you find the biggest opportunities to slice off a piece of a successful horizontal marketplace?

**中文翻译:**
太棒了。撮合市场创始人常问的另一个问题是：我应该走垂直路线还是水平路线？以 eBay 为例，他们非常水平，你可以在 eBay 上买到任何你想要的东西。然后出现了所有这些衍生平台，比如专门卖老爷车的、专门卖吉他的。我很好奇你对试图决定走水平还是垂直路线的早期创始人有什么建议？以及你认为从成功的水平市场中切下一块蛋糕的最大机会在哪里？

---

### [00:50:18] Dan Hockenmaier

**English:**
Yeah, absolutely. And in that eBay example, there are now a few quite successful examples of this like [inaudible 00:50:23] and StockX are two where they carved out the sneaker category and the key insight was you couldn't trust the inventory you were getting on eBay. So there's a lot of work you need to do to verify, and those businesses just did it much better than eBay. Broadly though, I think that we over hyped the idea of unbundling. So I think every six months I'm seeing an article where somebody wrote, "This is the unbundling of Reddit, the unbundling of LinkedIn, the unbundling of Facebook." We're going to take all those blue links that you saw on another site and they're all going to become new businesses. And very rarely that thesis plays out. I think the core logical error in the argument for unbundling is that they over focus on one type of improvement, which is user experience and they under focus on the things that make scale businesses have better economics.

**中文翻译:**
是的，当然。在 eBay 的例子中，现在有一些非常成功的案例，比如 StockX，他们切入了运动鞋类别，核心见解是你无法信任在 eBay 上买到的库存。所以你需要做大量的验证工作，而这些业务做得比 eBay 好得多。但总的来说，我认为我们过度炒作了“解构”（Unbundling）的概念。我想每隔六个月我就会看到一篇文章写道：“这是对 Reddit 的解构、对 LinkedIn 的解构、对 Facebook 的解构。”我们要把你在另一个网站上看到的所有蓝色链接都变成新的业务。但这种论调极少能成真。我认为解构论点中的核心逻辑错误在于，他们过度关注一种改进（即用户体验），而忽视了让规模化业务拥有更好经济效益的因素。

---

### [00:51:07] Dan Hockenmaier

**English:**
And so to unpack that, if you look at UX, like if you built a LinkedIn just for construction workers or just for architects or just for investment bankers, you could definitely build some set of features that group liked better than the core LinkedIn experience. But then you have to weigh that against all of the benefits of being broader. And so the two big pieces of where you get benefits from scale are in your customer LTV and then I think the network effect you can build. So if you go back to that Thumbtack example, we had a spreadsheet which tracked hundreds of verticalized competitors where somebody would try to pick off the electricians category, the wedding category, the lessons category, and very few of them got traction for the simple reason that we could upsell customers into a thousand things.

**中文翻译:**
拆解一下，如果你看用户体验（UX），比如你为建筑工人、建筑师或投资银行家建立一个专门的 LinkedIn，你肯定能构建一套让该群体比核心 LinkedIn 体验更喜欢的功能。但随后你必须权衡这与更广泛平台带来的所有好处。规模带来的两大好处在于客户 LTV，以及你可以建立的网络效应。回到 Thumbtack 的例子，我们有一个电子表格，追踪了数百个垂直化的竞争对手，有人试图抢占电工类别、婚礼类别、课程类别，但其中很少有人能获得动力，原因很简单：我们可以向客户追加销售一千种东西。

---

### [00:51:48] Dan Hockenmaier

**English:**
And so our customer LTV was always higher and we would always win when we were bidding against those other customers on SEM keywords that were relevant to that category. So it becomes very hard to compete if you're picking off this kind of narrow thing unless you find something which that sub-segment is itself very high frequency or very high dollar value. So Airbnb's an example. They unbundled from Craigslist because they picked off this massive high frequency, high dollar value category [inaudible 00:52:16] but there's not that many of those examples.

**中文翻译:**
因此，我们的客户 LTV 总是更高，当我们在与该类别相关的 SEM 关键词上与那些竞争对手竞价时，我们总是会赢。所以，如果你只是切入这种狭窄的领域，竞争会变得非常困难，除非你发现该细分市场本身具有非常高的频率或非常高的价值。Airbnb 就是一个例子，他们从 Craigslist 中解构出来，因为他们切入了这个巨大的、高价值的类别，但这样的例子并不多。

---

### [00:52:18] Dan Hockenmaier

**English:**
And then I think the other source of benefit would be the network effect. So if you go back to LinkedIn, for example, I think actually there's an opportunity and we see some successful businesses picking off now blue collar work. So there's a company called Workrise. I think they used to be called Rigup where they're basically building like a LinkedIn but for blue collar work. And that works really well because it's a huge segment and it's somewhat self-contained.

**中文翻译:**
我认为另一个利益来源是网络效应。以 LinkedIn 为例，我认为实际上存在机会，我们看到一些成功的业务正在切入蓝领工作领域。有一家公司叫 Workrise（以前叫 Rigup），他们基本上是在为蓝领工作建立类似 LinkedIn 的平台。这运行得非常好，因为这是一个巨大的细分市场，而且在某种程度上是自成一体的。

---

### [00:52:39] Dan Hockenmaier

**English:**
But for most other things there's a lot of fluidity between the employers and the employees in terms of who wants to transact with one another. And so if you're an investment banker, you don't really want to be on the LinkedIn investment banker because you're probably in the future going to want some other job. So you want to be in the biggest network that's relevant to you and so this is why you can complain about LinkedIn's UI all day, but they have a very strong place in the market because of that network effect. So broadly, I think there are some pretty interesting examples, places where you can unbundle but they're rarer than people think.

**中文翻译:**
但对于大多数其他事情，雇主和雇员之间在交易意愿方面有很大的流动性。如果你是一名投资银行家，你并不真的想待在一个专门针对投资银行家的 LinkedIn 上，因为你将来可能想要其他工作。所以你想待在与你相关的最大的网络中，这就是为什么你可以整天抱怨 LinkedIn 的 UI，但由于网络效应，他们在市场上占有非常稳固的地位。所以总的来说，我认为有一些非常有趣的解构例子，但它们比人们想象的要少。

---

### [00:53:10] Lenny

**English:**
That is amazing. There's so much value in what you just shared. So one takeaway I have here is you have an opportunity to unbundle/split off into a vertical marketplace potentially if there's high order value and high frequency. And the third piece is there's almost a self-contained network that doesn't benefit significantly from the rest of the network. For example, I love the Rigup example, like I doubt oil rig operators are on LinkedIn and when something comes around that's like, "Oh, all my buddies are on this thing, I'm going to be on there," you don't need the rest of LinkedIn.

**中文翻译:**
太棒了。你刚才分享的内容非常有价值。我的一个收获是：如果你想解构或拆分出一个垂直市场，潜在的机会在于高订单价值和高频率。第三点是，它几乎是一个自成一体的网络，不会从网络的其余部分获得显著收益。例如，我喜欢 Rigup 的例子，我怀疑石油钻井平台的操作员是否在 LinkedIn 上，当出现一个类似“噢，我所有的哥们都在这上面，我也要加入”的东西时，你就不需要 LinkedIn 的其余部分了。

---

### [00:53:40] Lenny

**English:**
The first piece, though, is interesting. So Airbnb I wouldn't say is high frequency. I'd say it's just very large high order value. And so I wonder if you just need one or the other really in a big way. Really high order value or really high frequency?

**中文翻译:**
不过第一点很有趣。Airbnb 我不会说它是高频的，我会说它只是非常巨大的高订单价值。所以我在想，你是否只需要其中一个达到极致即可？极高的订单价值或者极高的频率？

---

### [00:53:51] Dan Hockenmaier

**English:**
This is a good point. Probably what you're solving for is customer LTV and you can get that in multiple places. There's not that many things which are both high frequency and high dollar value so you can do both. I do think if you go to a place that is low frequency, it comes with all kinds of new challenges because, without frequency, customers forget about you. And so what is the hook to get them to come back? Do you have to reacquire traffic? It creates a whole other set of problems. But if you can get it right like in the Airbnb case, it can work really well.

**中文翻译:**
这是一个很好的观点。可能你真正要解决的是客户 LTV，而你可以从多个地方获得它。并没有那么多东西既是高频又是高价值的，所以你可以兼顾。我确实认为，如果你进入一个低频领域，它会带来各种新挑战，因为没有频率，客户就会忘记你。那么吸引他们回来的钩子是什么？你是否必须重新获取流量？这会产生一系列其他问题。但如果你能像 Airbnb 那样做对，它就能运行得非常好。

---

### [00:54:17] Lenny

**English:**
Yeah, Thumbtack is a classic example of how often you need a plumber. And even with the thousands of services that you all had, from what I understand, it's still a struggle to get people to come back often. And remember Thumbtack when they had, "Oh, they have an electrician. Oh yeah, Thumbtack."

**中文翻译:**
是的，Thumbtack 是一个经典例子，说明你多久需要一次水管工。即使你们拥有一千种服务，据我所知，让人们经常回来仍然很困难。让人们在需要电工时想起：“噢，他们有电工。噢对，Thumbtack。”

---

### [00:54:30] Dan Hockenmaier

**English:**
That's right. Initially, it was very difficult. I mean the average person hires eight or ten new professionals a year, the average homeowner. And so that's decently high frequency, but it's not food delivery or a ride sharing or something like that.

**中文翻译:**
没错。最初非常困难。我的意思是，平均每个房主每年会雇佣 8 到 10 名新的专业人士。这算是不错的高频了，但它不像外卖或打车那样。

---

### [00:54:42] Lenny

**English:**
Coming back to Faire, so Faire is one of the maybe few really successful B2B marketplaces and it's always felt like there's this gap in B2B marketplaces. You always feel like there should be many more. Like why are there so many consumer marketplaces but so few B2B, and I'm curious what's your take there. Do you think there's a rising trend to B2B marketplaces? Do you think this is always going to be a smaller collection? What's your feeling?

**中文翻译:**
回到 Faire，Faire 可能是少数几个真正成功的 B2B 撮合市场之一，而且总感觉 B2B 撮合市场存在缺口。你总觉得应该有更多。比如为什么有这么多消费者市场，却只有这么少 B2B 市场？我很想知道你的看法。你认为 B2B 撮合市场会有上升趋势吗？你认为这永远只会是一个较小的群体吗？你的感觉如何？

---

### [00:55:07] Dan Hockenmaier

**English:**
So I do think we'll see more of them. Part of the reason we've seen fewer is there are fewer potential founders who understand B2B problems because most of them are consumers and so the consumer use cases are more obvious. So if you take Faire, for example, when I met the founders, which is probably five years ago now, I immediately understood what they were talking about, but only because I had run an e-commerce business in the past and I had the experience of dealing with a hundred suppliers and line sheets and PDFs going back and forth and pricing not being right and just how painful it is to be a retail buyer. And they had a solution which was much better and that clicked.

**中文翻译:**
我确实认为我们会看到更多。我们看到较少的部分原因是，理解 B2B 问题的潜在创始人较少，因为大多数人都是消费者，所以消费者的使用场景更显而易见。以 Faire 为例，当我在大概五年前见到创始人时，我立刻理解了他们在说什么，但这仅仅是因为我过去经营过电商业务，我有过与一百个供应商打交道、处理来回传送的报价单和 PDF、价格不对以及作为零售买家是多么痛苦的经历。他们有一个好得多的解决方案，这让我产生了共鸣。

---

### [00:55:44] Dan Hockenmaier

**English:**
But had I had the same conversation five or 10 years ago with the team at Convoy like I don't know anything about trucking, I probably wouldn't have understood why that business was going to work. And so I think there's partly that. Just the discovery process takes longer for that reason. But I think the reason we won't see a huge explosion in this area is that B2B also comes with something else, which is much lower fragmentation in many cases and you need fragmentation for a good marketplace. The more concentrated either side of your market is, the more leverage they have, the less likely they are to need you and the less likely they are to be willing to pay a high commission.

**中文翻译:**
但如果我在 5 年或 10 年前与 Convoy 团队进行同样的对话，由于我对卡车运输一窍不通，我可能无法理解为什么那项业务会成功。所以我认为部分原因是这个——发现过程因此变得更长。但我认为我们不会在这个领域看到巨大爆发的原因是，B2B 还伴随着另一件事，即在许多情况下“碎片化”（Fragmentation）程度要低得多，而一个好的撮合市场需要碎片化。你市场的任何一侧越集中，他们的杠杆作用就越大，他们就越不需要你，也就越不愿意支付高额佣金。

---

### [00:56:20] Lenny

**English:**
You made that point to me once when we were talking about marketplaces years ago, and that's so stuck with me that when evaluating marketplaces in B2B especially, usually the reason it's not going to work is just it's not fragmented enough. And just to double click there, can you explain what that means? What does fragmentation mean in a marketplace context? And then are there any examples of really low fragmentation of this will never work as a marketplace? And then here it's really high and this is why it's working?

**中文翻译:**
几年前我们谈论撮合市场时，你也向我提到过这一点，这让我印象深刻：在评估 B2B 撮合市场时，通常它行不通的原因就是不够碎片化。能详细解释一下吗？在撮合市场的语境下，碎片化意味着什么？有没有什么极低碎片化的例子，说明这永远无法作为撮合市场运作？以及哪里碎片化很高，所以它能成功？

---

### [00:56:45] Dan Hockenmaier

**English:**
Fragmentation is basically just a measure of how many total businesses are there in the space relative to the transaction volume in that space. And if you took the top 5% of suppliers in the space, what percentage of the total volume are they doing? And the higher that percentage is, the less fragmented you are. The challenge that creates for a marketplace is if there's 10 companies in a space that are doing 80% of the volume, it's very important for me to have a relationship with those 10 companies. But those 10 companies are also big enough to have their own sales teams, have their own internal operations. They just need less from a marketplace and, as a result, they're going to be willing to pay less. And you're also probably going to see many more problems with disintermediation, which is when the supplier and the customer go around the marketplace because they can just transact themselves.

**中文翻译:**
碎片化基本上就是衡量该领域内企业总数相对于该领域交易量的指标。如果你取该领域前 5% 的供应商，他们占据了总交易量的百分之几？这个百分比越高，碎片化程度就越低。这给撮合市场带来的挑战是：如果一个领域有 10 家公司占据了 80% 的交易量，那么与这 10 家公司建立关系对我来说非常重要。但这 10 家公司也足够大，拥有自己的销售团队和内部运营。他们对撮合市场的需求较少，因此愿意支付的费用也较少。而且你可能还会看到更多的“去中介化”（Disintermediation）问题，即供应商和客户绕过市场，因为他们可以直接进行交易。

---

### [00:57:27] Dan Hockenmaier

**English:**
One principle to use here is how many total dollars are attached to each transaction in the marketplace. When it goes above a certain amount, it becomes much more attractive to figure out how to go around the marketplace. With ride sharing, for example, the absolute dollars of commission on a ride is $2 or $3. Is it worth it for the driver to figure out how to call the passenger two minutes in advance, go around Uber and pick them up? Maybe. You probably see some of that happening, but usually not.

**中文翻译:**
这里可以使用的一个原则是：市场中每笔交易涉及的总金额是多少。当金额超过一定数值时，想办法绕过市场就会变得非常有吸引力。例如，在打车服务中，一趟行程的绝对佣金金额是 2 或 3 美元。司机值得为了这几块钱去想办法提前两分钟给乘客打电话、绕过 Uber 去接他们吗？也许吧，你可能会看到一些这样的情况，但通常不会。

---

### [00:57:55] Dan Hockenmaier

**English:**
But now take there's a bunch of people in the kind of material space within B2B marketplaces, you have manufacturers of say beauty products who need to source aerosol cans and all the inputs into making beauty products. There's not that many of these big suppliers and each of their transactions may be tens of thousands of dollars, hundreds of thousands of dollars, millions of dollars. The commission you would charge on that order is too high because a supplier would rather just pick up the phone and call this person and save those tens of thousands of dollars. And so you just run into these kind of fundamental problems where a marketplace doesn't work anymore.

**中文翻译:**
但现在看看 B2B 撮合市场中原材料领域的一群人，比如美容产品制造商需要采购气雾罐和制造美容产品的所有投入品。这些大供应商并不多，而且他们的每笔交易可能是几万、几十万甚至几百万美元。你在那笔订单上收取的佣金太高了，因为供应商宁愿拿起电话打给那个人，从而省下那几万美元。所以你就会遇到这些根本性的问题，导致撮合市场无法运作。

---

### [00:58:29] Lenny

**English:**
That makes sense. Basically, how much value are you bringing to this market? And if it's not enough where you can charge anything meaningful to run a business is just not going to work. And so that's a really good way of framing it.

**中文翻译:**
这很有道理。基本上就是：你为这个市场带来了多少价值？如果价值不足以让你收取有意义的费用来维持业务运行，那就行不通。这是一个非常好的表述方式。

---

### [00:58:41] Lenny

**English:**
Final question around marketplaces and, broadly, and I'll let you go. You've spent a lot of time on marketplaces. You've seen their evolution. You've worked on this maybe for the past decade. Where do you see the future of marketplaces going?

**中文翻译:**
关于撮合市场和广义业务的最后一个问题，问完我就让你走。你在撮合市场领域投入了大量时间，见证了它们的演变，可能在过去十年里一直从事这项工作。你认为撮合市场的未来会走向何方？

---

### [00:58:54] Dan Hockenmaier

**English:**
I actually wrote a blog post on this where we charted the commission that a marketplace charges and the year they were founded. And if you put those on the x and y axis, there's this very clear up into the right trend. Newer marketplaces are charging higher commissions and they're doing more work to justify those commissions. So broadly the evolution looks like kind of Marketplace 1.0, which is all they're doing is aggregating demand. So that's Zillow and Home Advisor. They're basically like lead gen and their commission rate is often pretty low. It's like 5%, maybe 10%.

**中文翻译:**
我实际上写过一篇关于这个的博客文章，我们绘制了撮合市场收取的佣金与它们成立年份的图表。如果你把这些放在 X 轴和 Y 轴上，会看到一个非常清晰的向右上方增长的趋势。较新的撮合市场收取的佣金更高，而且他们为了证明这些佣金的合理性做了更多工作。总的来说，演变过程看起来像是“撮合市场 1.0”，他们所做的只是聚合需求。比如 Zillow 和 Home Advisor，他们基本上就像线索生成（Lead Gen），佣金率通常很低，大概是 5%，也许是 10%。

---

### [00:59:24] Dan Hockenmaier

**English:**
Then you have a managed marketplace like Airbnb or Etsy, which did something really fundamental on top of that, which is generated trust. So they deadhead supply ... You could probably tell me more about what Airbnb did in this space, but they made it a safe transaction and there's a lot of work it takes to make that transaction trustworthy and safe and so they charge a higher commission as a result.

**中文翻译:**
然后是像 Airbnb 或 Etsy 这样的“托管型撮合市场”（Managed Marketplace），他们在聚合需求的基础上做了一些非常基础的事情，即建立信任。他们……你可能比我更了解 Airbnb 在这方面做了什么，但他们让交易变得安全，为了让交易变得值得信赖和安全，需要做大量工作，因此他们收取的佣金更高。

---

### [00:59:48] Dan Hockenmaier

**English:**
There's then one click beyond that which, for lack of a better term, you could call it a heavily managed marketplace, but now they're typically doing some work in the value chain, which is distinct from just aggregating demand. So DoorDash and Instacart own logistics. They took over logistics and, as a result, DoorDash did a much better job than the previous model of Seamless of being able to bring on a lot more restaurants and make it much more reliable for the customer. As a result, they could charge more to the restaurant. Similarly, Faire, we actually underwrite the transaction. We take the risk. If that transaction falls through or the retailer defaults, Faire eats that. And so we are playing a much more fundamental place in that transaction.

**中文翻译:**
再进一步，由于缺乏更好的术语，你可以称之为“重度托管型撮合市场”，但现在他们通常在价值链中承担了一些工作，这与单纯聚合需求不同。比如 DoorDash 和 Instacart 拥有物流。他们接管了物流，结果 DoorDash 比之前的 Seamless 模式做得好得多，能够引入更多餐厅，并让客户感到更可靠。因此，他们可以向餐厅收取更多费用。同样，在 Faire，我们实际上为交易提供承销。我们承担风险。如果交易失败或零售商违约，Faire 会承担损失。因此，我们在交易中扮演了更基础的角色。

---

### [01:00:25] Dan Hockenmaier

**English:**
But as you play this out, what happens at the end of this continuum? Ultimately, you're charging a hundred percent commission and you're not a marketplace anymore. So I think, as we think about the future of marketplaces, one important question is which marketplaces are going to tend towards evolving out of the marketplace model altogether and which will stay in marketplace mode in equilibrium? And you see these examples already like people talk about Opendoor as a marketplace, but it's not. It's an e-commerce website which has the highest price points you can imagine because you're buying houses, but there's no supplier on the other side. They've already bought the house so it's just e-commerce. And I think many marketplaces will go that way. And I think the variable to me that matters in deciding which case you're going to have, whether they consolidate or not, is how much creativity there is in the space. So how much do you need the supplier to be coming up with interesting new things for your customers to buy.

**中文翻译:**
但随着这种趋势的发展，这个连续体的终点是什么？最终，你收取 100% 的佣金，你就不再是一个撮合市场了。所以，当我们思考撮合市场的未来时，一个重要的问题是：哪些市场会趋向于完全脱离撮合市场模型，而哪些会在平衡状态下保持撮合市场模式？你已经看到了这些例子，比如人们谈论 Opendoor 是一个撮合市场，但它不是。它是一个电子商务网站，拥有你能想象到的最高价位，因为你在买房子，但另一侧没有供应商。他们已经买下了房子，所以它只是电子商务。我认为许多撮合市场都会走向那条路。我认为决定你会属于哪种情况（是否整合）的关键变量是该领域的“创造力”程度。也就是说，你有多大程度需要供应商为你的客户提供有趣的新东西。

---

### [01:01:18] Dan Hockenmaier

**English:**
What the customer cares about is actually commoditization. They want the same experience every time. Then you're ultimately going to evolve away from marketplaces I think. With ride sharing, basically what I want is a clean car that shows up on time and gets me there every time. So as soon as autonomous vehicles arrive, we're going to fully consolidate that industry and it's not going to be marketplace model any more. On the other end, you have Etsy and Amazon. I think Faire's in this bucket. Steam, the video game marketplace, is in this bucket where the thing you care about is suppliers bringing you amazing creative new things. And that's something that big companies are really bad at doing. So they need the marketplace suppliers to supply this. And so I think those businesses stay in marketplace mode longer term.

**中文翻译:**
如果客户关心的实际上是“商品化”（Commoditization），即他们每次都想要相同的体验，那么我认为你最终会脱离撮合市场。对于打车服务，我基本上想要的是一辆准时出现、干净的汽车，并且每次都能把我送到目的地。所以一旦自动驾驶汽车出现，我们将完全整合该行业，它将不再是撮合市场模式。在另一端，你有 Etsy 和亚马逊。我认为 Faire 也在这一类。Steam（视频游戏市场）也在这一类，你关心的是供应商为你带来令人惊叹的、有创意的新东西。而这是大公司非常不擅长做的事情。所以他们需要市场供应商来提供这些。因此，我认为这些业务会长期保持撮合市场模式。

---

### [01:02:02] Dan Hockenmaier

**English:**
And then the middle, I don't exactly know how to call what happens in food delivery. You do want some standardization elements, but you also want the local restaurants and so does DoorDash win or the Cloud Kitchen model win? I think it's a little bit harder to understand, but I do think that's kind of the variable that's determining where the future of marketplaces are going.

**中文翻译:**
至于中间地带，我不太清楚如何定义外卖行业发生的事情。你确实想要一些标准化的元素，但你也想要当地的餐厅，那么是 DoorDash 会赢，还是云厨房（Cloud Kitchen）模式会赢？我认为这有点难理解，但我确实认为这就是决定撮合市场未来走向的变量。

---

### [01:02:19] Lenny

**English:**
It's interesting to think about this event horizon for when a marketplace is no longer a marketplace. Is a simple way to think about that being when you own the supply, you're no longer a marketplace. When you don't own the supply, you are. Is that how you think about that?

**中文翻译:**
思考撮合市场不再是撮合市场的“事件视界”很有趣。一个简单的理解方式是：当你拥有供应时，你就不再是撮合市场；当你没有拥有供应时，你就是。你是这样想的吗？

---

### [01:02:34] Dan Hockenmaier

**English:**
Yeah, that's a good mental [inaudible 01:02:37]. Perhaps another way to say owning a supply is when there's no longer a direct transaction between supply and demand. That's what Opendoor took out, for example. You're not transacting with the home seller. You're transacting with Open Door and so that's, in my mind, no longer a marketplace because you also eliminate some of the marketplace mechanics we were talking about a bit.

**中文翻译:**
是的，这是一个很好的思路。也许“拥有供应”的另一种说法是：当供给和需求之间不再有直接交易时。例如，这就是 Opendoor 消除的东西。你不是在与卖房者交易，你是在与 Opendoor 交易，所以在我的心目中，那不再是一个撮合市场，因为你也消除了一些我们刚才谈到的市场机制。

---

### [01:02:55] Lenny

**English:**
Awesome. Dan, this has been incredible. I feel like we've achieved our goal of getting really deep into the weeds on growth models and marketplaces. Two final questions for you.

**中文翻译:**
太棒了。Dan，这太不可思议了。我觉得我们实现了深入探讨增长模型和撮合市场的目标。最后有两个问题问你。

---

### [01:03:06] Lenny

**English:**
Where can folks find you online if they want to learn more, reach out and how can listeners be useful to you?

**中文翻译:**
如果人们想了解更多信息或联系你，可以在哪里找到你？听众可以为你提供什么帮助？

---

### [01:03:11] Dan Hockenmaier

**English:**
Yeah, so I'm on Twitter at Dan Hockenmaier and then LinkedIn. People should feel free to reach out. I think the most useful thing is we're always growing our team at Faire. And so for folks who are interested in this space, I would love to connect with them.

**中文翻译:**
好的，我在 Twitter 上的账号是 Dan Hockenmaier，还有 LinkedIn。欢迎大家随时联系。我认为最有用的事情是，我们在 Faire 一直在壮大团队。所以对于对这个领域感兴趣的人，我很乐意与他们建立联系。

---

### [01:03:26] Lenny

**English:**
Where do they go to learn more and apply for Faire?

**中文翻译:**
他们去哪里了解更多信息并申请 Faire 的职位？

---

### [01:03:29] Dan Hockenmaier

**English:**
Just faire.com or faire.com/careers.

**中文翻译:**
只需访问 faire.com 或 faire.com/careers。

---

### [01:03:32] Lenny

**English:**
And that's Faire with an "e" at the end?

**中文翻译:**
是末尾带“e”的 Faire 吗？

---

### [01:03:34] Dan Hockenmaier

**English:**
That's correct, yes.

**中文翻译:**
没错，是的。

---

### [01:03:36] Lenny

**English:**
Awesome. All right, Dan, thank you for being here.

**中文翻译:**
太棒了。好了，Dan，谢谢你能来。

---

### [01:03:38] Dan Hockenmaier

**English:**
Thank you so much for the time.

**中文翻译:**
非常感谢你抽出的时间。

---

### [01:03:41] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得这些内容有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目再见。