# Daniel Lereya - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Daniel Lereya, CPTO at Monday.com.

---

### (00:00:00) Daniel Lereya

**English:**
... 8:00 PM basically for me is someone that is relentless until he gets this impact, until he validates that this impact is in place. In some cases, doing the biggest impact is not developing another feature, it's about making the current value more accessible.

**中文翻译:**
……对我来说，（优秀的 PM）基本上就是那种在产生影响力、在验证这种影响力确实发挥作用之前，绝不罢休的人。在某些情况下，产生最大影响力的做法并不是开发另一个新功能，而是让现有的价值变得更容易获取。

---

### (00:00:15) Lenny Rachitsky

**English:**
You've been at this for eight years, you said there's 250,000 customers at this point. What would you say is the most counterintuitive thing you've learned through this journey of building Monday?

**中文翻译:**
你在这个岗位上已经八年了，你说目前已经有 25 万名客户。在构建 Monday 的这段旅程中，你学到的最反直觉的事情是什么？

---

### (00:00:25) Daniel Lereya

**English:**
We really have an approach of very radical transparency about everything. Before we went public, we actually shared every bit of information with our employees. Instead of demoralizing people, I think that this is something that gives them a sense of deep partnership. We really want everyone's brains in the challenge, and not just one centralized brain and a lot of working hands.

**中文翻译:**
我们对一切事物都采取一种非常激进的透明化管理方式。在上市之前，我们实际上向员工分享了每一条信息。我认为这不仅没有挫伤士气，反而给了他们一种深度的伙伴感。我们真心希望每个人的大脑都能参与到挑战中，而不仅仅是一个集权式的大脑和一堆只管干活的手。

---

### (00:00:48) Lenny Rachitsky

**English:**
You basically realized that your competitors were shipping a lot faster than you were, that made you shift the way you think about product and the way you operate.

**中文翻译:**
你基本上意识到你的竞争对手发布产品的速度比你们快得多，这让你转变了对产品的思考方式以及运营方式。

---

### (00:00:58) Daniel Lereya

**English:**
Some of our competitors did something that we can only imagine. We said, "Okay. We need to treat it differently." We received a gift from our competitors. They showed us that it's possible. Use your competition, know it, and take it, and set ambitious goals, and believe in yourself, and you can do amazing things.

**中文翻译:**
我们的一些竞争对手做到了我们只能想象的事情。我们当时想：“好吧，我们需要换种方式对待这件事。”我们从竞争对手那里收到了一份“礼物”。他们向我们展示了这是可能的。利用你的竞争对手，了解它，接受它，设定宏大的目标，相信你自己，你就能做出惊人的成就。

---

### (00:01:14) Lenny Rachitsky

**English:**
Today, my guest is Daniel Lereya. Daniel's currently chief product and technology officer at Monday.com. He joined when they were just around 40 employees. And, a few years in, Daniel and the exec team realized that their competitors were able to move a lot faster than they were and ship a lot more often than they were, and that's spurred a transformation in how they build and operate their teams. Very few companies are able to transform like this, and even fewer recognize that something is wrong. In our conversation, Daniel shares a bunch of very specific insights and suggestions into how to go about making change or even recognizing that something is wrong. Daniel shares moments when it felt like everything was going to crumble. Why it's important to know that the skills that got you to where you're today aren't the skills that are going to take you to the next level. Why it's so important to orient all your teams around impact and so much more.

**中文翻译:**
今天的嘉宾是 Daniel Lereya。Daniel 目前是 Monday.com 的首席产品和技术官（CPTO）。他在公司只有 40 名员工左右时加入。几年后，Daniel 和执行团队意识到，他们的竞争对手能够比他们行动快得多，发布产品的频率也高得多，这促使他们对团队的构建和运营方式进行了转型。很少有公司能完成这样的转型，甚至很少有公司能意识到出了问题。在我们的对话中，Daniel 分享了许多关于如何进行变革、甚至如何识别问题的具体见解和建议。Daniel 分享了那些感觉一切都要崩溃的时刻。为什么意识到“让你达到今天成就的技能，并不一定是带你进入下一阶段的技能”如此重要。为什么让所有团队都以“影响力”为导向至关重要，以及更多精彩内容。

---

### (00:02:04) Lenny Rachitsky (Ads)

**English:**
(00:02:04): If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a year free of paid accounts at Superhuman, Linear, Notion, Granola, and Perplexity Pro. Check it out at lennysnewsletter.com and click Bundle. With that, I bring you, Daniel Lereya. This episode is brought to you by Enterpret. Enterpret unifies all your customer interactions, from Gong calls, to Zendesk tickets, to Twitter threads, to App Store reviews, and makes it available for analysis. It's trusted by leading product orgs like Canva, Notion, Loom, Linear, Monday.com, and Strava to bring the voice of the customer into the product development process, helping you build best-in-class products faster.

**中文翻译:**
(00:02:04): 如果你喜欢这个播客，别忘了在你的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你可以免费获得 Superhuman、Linear、Notion、Granola 和 Perplexity Pro 的一年付费账号。请访问 lennysnewsletter.com 并点击 Bundle 查看。现在，让我们欢迎 Daniel Lereya。本集由 Enterpret 赞助。Enterpret 统一了你所有的客户互动，从 Gong 通话、Zendesk 工单到 Twitter 线程和 App Store 评论，并使其可供分析。它深受 Canva、Notion、Loom、Linear、Monday.com 和 Strava 等领先产品组织的信任，将客户的声音引入产品开发过程，帮助你更快地构建一流产品。

---

### (00:02:47) Lenny Rachitsky (Ads continued)

**English:**
(00:02:47): What makes Enterpret special is its ability to build and update customer-specific AI models that provide the most granular and accurate insights into your business, connect customer insights to revenue and operational data in your CRM or data warehouse to map the business impact of each customer need and prioritize confidently, and empower your entire team to easily take action on use cases, like win-loss analysis, critical bug detection, and identifying drivers of churn, with Enterpret's AI systems wisdom. Looking to automate your feedback loops and prioritize your roadmap with confidence like Notion, Canva, and Linear? Visit E-N-T-E-R-P-R-E-T.com/lenny to connect with the team and to get two free months when you sign up for an annual plan. This is a limited time offer that's enterpret.com/lenny.

**中文翻译:**
(00:02:47): Enterpret 的特别之处在于它能够构建和更新针对特定客户的 AI 模型，为你的业务提供最细致、最准确的洞察；将客户洞察与 CRM 或数据仓库中的收入和运营数据联系起来，以映射每个客户需求的业务影响并自信地确定优先级；并利用 Enterpret 的 AI 系统智慧，赋能你的整个团队轻松针对赢单/丢单分析、关键漏洞检测和识别流失驱动因素等用例采取行动。想要像 Notion、Canva 和 Linear 一样自动化你的反馈循环并自信地规划路线图吗？访问 enterpret.com/lenny 联系团队，并在注册年度计划时获得两个月的免费试用。这是限时优惠，网址是 enterpret.com/lenny。

---

### (00:03:34) Lenny Rachitsky (Ads continued)

**English:**
(00:03:34): This episode is brought to you by Airtable Product Central, the unified system that brings your entire product organization together in one place. No more scattered tools, no more misaligned teams. If you're like most product leaders, you're tired of constant context switching between tools. That's why Airtable built Product Central after decades of working with world-class product companies. Think of it as mission control for your entire product organization. Unlike Rigid Point Solutions, Product Central powers everything, from resourcing, to voice of customer, to road mapping, to launch execution. And because it's built on Airtable's no-code platform, you can customize every workflow to match exactly how your team works. No limitations, no compromises. Ready to see it in action? Head to airtable.com/lenny to book a demo. That's airtable.com/lenny.

**中文翻译:**
(00:03:34): 本集由 Airtable Product Central 赞助，这是一个将你的整个产品组织聚集在一起的统一系统。不再有分散的工具，不再有步调不一的团队。如果你和大多数产品领导者一样，你已经厌倦了在工具之间不断的上下文切换。这就是为什么 Airtable 在与世界级产品公司合作数十年后构建了 Product Central。把它想象成你整个产品组织的“任务控制中心”。与僵化的单一解决方案不同，Product Central 支持从资源配置、客户声音到路线图制定、发布执行的一切工作。由于它构建在 Airtable 的无代码平台上，你可以自定义每个工作流，以完全匹配你团队的工作方式。没有限制，没有妥协。准备好看看它的实际效果了吗？前往 airtable.com/lenny 预约演示。网址是 airtable.com/lenny。

---

### (00:04:28) Lenny Rachitsky

**English:**
Daniel, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Daniel，非常感谢你能来到这里，欢迎参加我们的播客。

---

### (00:04:32) Daniel Lereya

**English:**
Thank you so much for having me.

**中文翻译:**
非常感谢邀请我。

---

### (00:04:34) Lenny Rachitsky

**English:**
We're going to get into the story of Monday. We're going to talk about your journey over the last eight years, building and scaling this company, and all the things you've learned along the way. But I want to start with a very specific moment that you shared with me, where you basically realized that your competitors were shipping a lot faster than you were, able to get stuff out a lot more quickly and more often than you guys, and that made you shift the way you think about product and the way you operate. Can you talk about that moment, and that lesson, and what you took away from that?

**中文翻译:**
我们将深入探讨 Monday 的故事。我们会聊聊你过去八年建立和扩展这家公司的历程，以及你一路上学到的所有东西。但我首先想从你跟我分享的一个非常具体的时刻开始：在那一刻，你基本上意识到你的竞争对手发布产品的速度比你们快得多，能够比你们更迅速、更频繁地推出新东西，这让你转变了对产品的思考方式和运营方式。你能谈谈那个时刻、那个教训，以及你从中得到了什么吗？

---

### (00:05:06) Daniel Lereya

**English:**
Yeah. Well, you take me a while back. I think it was when we were relatively a small team. I think we were something around 30 people. And, including engineers, and product, and everyone, it's actually that back in the days we did so many things. And, actually, we had an amazing, amazing execution. We had a weekly update. We would share everything that we did with the company and it was always super long and super... We had so many different things. And, we really felt good about ourselves at that point, to be honest, about the execution.

**中文翻译:**
好的。这得追溯到一段时间以前了。我想那是我们团队还相对较小的时候，大约只有 30 人左右。包括工程师、产品人员和所有人，实际上那时候我们做了很多事情。而且，说实话，我们当时的执行力非常惊人。我们每周都有一次更新，会向全公司分享我们所做的一切，内容总是非常长，非常……我们做了太多不同的事情。老实说，在那一点上，我们对自己的执行力感觉非常好。

---

### (00:05:49) Daniel Lereya (continued)

**English:**
(00:05:49): And then, I remember, one day, coming to the office and just looking on one of our competitors, and at Monday we have one of the main things that we have in the product is our boards. It's the heart and soul of the product. And, you can think about it as a table, and it has different column types, data types that you can capture within the board and work with. And, back then, we had five of these. And, I was actually coding the sixth one, to be honest. And, each and every one of these took us four months to develop together with defining the product and everything. And, this morning, we actually saw that one of our main competitors back then has actually launched 30 new columns.

**中文翻译:**
(00:05:49): 然后我记得有一天，我来到办公室，看了看我们的一个竞争对手。在 Monday，我们产品最核心的东西之一就是“看板”（Boards）。它是产品的核心和灵魂。你可以把它想象成一个表格，它有不同的“列”（Column）类型，也就是你可以在看板中捕获并处理的不同数据类型。当时，我们只有 5 种这样的列类型。老实说，我当时正在写第 6 种的代码。而每一种列类型，从定义产品到开发完成，都要花我们 4 个月的时间。结果那天早上，我们看到当时的一个主要竞争对手竟然一口气推出了 30 种新列。

---

### (00:06:39) Lenny Rachitsky

**English:**
30?

**中文翻译:**
30 种？

---

### (00:06:40) Daniel Lereya

**English:**
Yeah. And, we said, "Okay..." At first, we didn't really know what to do. And, we thought about it and I remember that we said, "Okay, we're going to take even some time out of the office. So back then, Roy and Eran, which are the founders, and also together with me and Tal, which was one of the main tech leads in Monday for a long time, and few others, we went outside the office and we said, "Listen, we need to do things differently. Something doesn't make sense." And, I remember back then that for me this realization of, understanding that we're doing so much, but suddenly, some of our competitors did something that we can only imagine, and actually transform the product, because it's a different platform, if you think about it. It was really hard. Personally, first of all, admitting that although you worked like crazy, you didn't do something that really transformed the product.

**中文翻译:**
是的。我们当时想：“好吧……”起初，我们真的不知道该怎么办。我们思考了一下，我记得我们说：“好吧，我们要抽点时间离开办公室去讨论一下。”于是当时，创始合伙人 Roy 和 Eran，还有我和 Tal（他长期担任 Monday 的主要技术负责人之一），以及其他几个人，我们走出办公室说：“听着，我们需要换种方式做事。有些地方不对劲。”我记得当时对我来说，那种意识非常强烈：我们觉得自己做了这么多，但突然间，竞争对手做了一些我们只能想象的事情，并且实际上改变了产品的形态——如果你仔细想想，那已经是一个完全不同的平台了。这真的很难受。首先，从个人层面承认，尽管你拼命工作，但你并没有做出真正让产品产生质变的东西。

---

### (00:07:51) Daniel Lereya (continued)

**English:**
(00:07:51): Because, I remember back then, when we did a conversation, we said, "Okay. We're doing so much. What is the most meaningful thing that we did over the last three months?" And suddenly, the answer was, "There's so many things." But it wasn't something specific. And after acknowledging that, it's a very hard thing personally, especially when you walk so hard and you put your entire heart in what you do, we said, "Okay. Now, we need to treat it differently. We received a gift from our competitors, they showed us that it's possible. Now, we need to think how. And in order to do that, we need to think differently." Because we said, "Okay. If we're going to add 25 more, multiply it by four months, we're a small team, we are lost. Okay, we can't make it." So we said, "Okay, we need to take upon ourselves an ambitious goal, like 25 columns in one month." And this is the goal that we took upon ourselves.

**中文翻译:**
(00:07:51): 因为我记得当时我们交流时问：“好吧，我们做了这么多。过去三个月我们做的最有意义的一件事是什么？”突然间，答案变成了“有很多事”，但没有一件是具体的。在承认了这一点后——这在个人情感上很难接受，尤其是当你工作如此努力、全身心投入时——我们说：“好吧，现在我们需要换个思路。我们收到了竞争对手的一份礼物，他们向我们展示了这是可能的。现在我们需要思考如何做到。为了做到这一点，我们需要换个思考方式。”因为我们算了一下：“好吧，如果我们要再增加 25 种列，每种花 4 个月，我们这个小团队就完蛋了，根本做不到。”所以我们说：“好吧，我们需要给自己定一个宏大的目标，比如一个月内完成 25 种列。”这就是我们给自己设定的目标。

---

### (00:08:59) Daniel Lereya (continued)

**English:**
(00:08:59): And, I think that the fact that our competitors did it, it didn't give us the excuse of saying, "It's not possible." So in a way, it was the biggest favor that we can ask for. And, long story short, month and a half afterwards, we had 30 columns in Monday. And, we did it by thinking totally different. And by the way, afterwards, we did it over and over again. So if you think about Monday, it's basically a platform for work and you have different building blocks, columns is one of them, but we did the same deal exactly with dashboards and widgets, and then with automations, and so on. So I think this was so transformative, because, A, we understood that you need to constantly think, especially at these phases, how would you transform completely the product in the next three months?

**中文翻译:**
(00:08:59): 而且我认为，竞争对手已经做到了这一事实，让我们没有借口说“这不可能”。所以从某种程度上说，这是我们能得到的最大帮助。长话短说，一个半月后，Monday 就有了 30 种列。我们是通过完全不同的思维方式做到的。顺便说一句，在那之后，我们一次又一次地这样做。如果你把 Monday 看作一个工作平台，它有不同的构建块，“列”是其中之一，但我们在仪表盘（Dashboards）、小组件（Widgets）、自动化（Automations）等方面也采取了完全相同的做法。所以我认为这具有极大的变革性，因为：第一，我们明白你需要不断思考，尤其是在这些阶段，你如何在接下来的三个月里彻底改变产品？

---

### (00:09:55) Daniel Lereya (continued)

**English:**
(00:09:55): And if you can't answer that and you say, "Listen, I'm doing so much." But you can't point this exact thing, you have a focus problem in my eyes. And second is that put ambitious goals, it'll make you think differently. And, we really love now to do it even when we don't know it's possible and it actually works for us time after time. And, let's think about it. The team that was there suddenly became invincible, because it's such an amazing, amazing experience that you have a goal that you don't know how you're going to do it and you succeed, and then it makes you feel that everything is possible.

**中文翻译:**
(00:09:55): 如果你无法回答这个问题，只是说“听着，我做了很多工作”，但你指不出那件具体的事，那么在我看来，你存在专注力问题。第二，设定宏大的目标，它会迫使你换个角度思考。现在我们非常喜欢这样做，即使我们不知道是否可能，而事实证明这对我们一次又一次奏效。想想看，当时的团队突然变得无坚不摧，因为那种体验太棒了：你有一个不知道该如何实现的目标，但你成功了，这会让你觉得一切皆有可能。

---

### (00:10:40) Lenny Rachitsky

**English:**
There's so much here. And, I have so many threads I want to follow on. One is just, there's this metaphor of the four-minute mile, where no one thought it was possible, and then someone did it, and then everyone started beating that record. So I like that this is highlighting, there's just so much power in seeing somebody else accomplish something you thought was impossible, and that unlocks the way you think. And, I love that you saw it as a gift. A lot of companies do this, they're in this place and they're like, "No way." It's like when the iPhone launch like, "No one needs that. There's no keyboard." And a lot of people deny that it's a thing they should be paying attention to. I love that you saw it as like, "Okay, we need to move. Things have changed. We're not doing things. We're not going to be competitive long-term."

**中文翻译:**
这里的信息量太大了。我有很多想深入探讨的线索。一个是“四分钟一英里”的隐喻：以前没人认为这可能，直到有人做到了，然后每个人都开始打破那个记录。所以我很喜欢这一点，它强调了看到别人完成你认为不可能的事情时所蕴含的巨大力量，这会开启你的思维。我也很喜欢你把它看作一份“礼物”。很多公司在面对这种情况时会说“不可能”，就像 iPhone 发布时，有人说“没人需要那个，它没有键盘”。很多人会否认那是他们应该关注的事情。我喜欢你当时的反应：“好吧，我们需要行动。情况变了。我们现在的做法长期来看没有竞争力。”

---

### (00:11:23) Daniel Lereya

**English:**
I think it's also very much about focus. And I think that it's very hard to get to very good execution, but it doesn't guarantee that you are working in the right way. And many times, in my eyes, simple questions can provide the most and the deepest insights about your work. And I think that, for us, the fact that we managed to leverage it, as you said, and see it as a gift is one of the most important things. Use your competition, know it, use it to your advantage, and take it, and set ambitious goals, and believe in yourself, and you can do amazing things.

**中文翻译:**
我认为这在很大程度上也关乎专注。我觉得达到极佳的执行力很难，但执行力强并不保证你的工作方式是正确的。在我看来，很多时候，简单的问题能为你的工作提供最丰富、最深刻的洞见。我认为对我们来说，正如你所说，能够利用这一点并将其视为礼物是最重要的事情之一。利用你的竞争对手，了解它，将其转化为你的优势，设定宏大的目标，相信自己，你就能成就惊人的事业。

---

### (00:12:00) Lenny Rachitsky

**English:**
Another, I think, piece a lot of people are probably resonating with here is starting a company that's small, growing, things are going great, and then all of a sudden, things start to slow down. And, in some cases, you don't realize that they've slowed down. And, that's what happened in your case. Sounds like in a lot of cases, the founder's like, "What the hell's going on? Why is it taking three or four weeks to ship one of..." Whatever you call them. And so, is there anything... By the way, what was the scale of the company at this point?

**中文翻译:**
我想很多人可能会产生共鸣的另一点是：创办一家小公司，不断成长，一切都很顺利，然后突然间，速度开始慢了下来。在某些情况下，你甚至没有意识到速度变慢了。这就是你们当时的情况。听起来在很多情况下，创始人会问：“到底发生了什么？为什么发布一个……（不管你们怎么称呼它）要花三四周时间？”所以，有没有什么……顺便问一下，当时公司的规模有多大？

---

### (00:12:26) Daniel Lereya

**English:**
It's a good question. If I'm not mistaken, it was around 2018 back then, it's safe to assume 150, 200 people in the company. But, we were relatively small.

**中文翻译:**
好问题。如果我没记错的话，那是 2018 年左右，可以假设公司大概有 150 到 200 人。但相对而言，我们还算小。

---

### (00:12:43) Lenny Rachitsky

**English:**
I recently had Ryan Singer on the podcast who created the Shape Up method from Basecamp, and that's his piece of advice too is around 50 to 100 people things start to really change, and slow down, and that's where a lot of companies start to go sideways. So that resonates. That's really interesting. And by the way, these columns you're describing, just to make it clear, this is a new data, new format of column, it's a new data format that you're building. It's not like, just add another column to some database.

**中文翻译:**
我最近邀请了 Basecamp 的 Shape Up 方法创始人 Ryan Singer 来参加播客，他的建议也是：在 50 到 100 人左右时，情况会开始发生真正的变化并变慢，那是很多公司开始走下坡路的地方。所以这很有共鸣，非常有趣。顺便说一下，你描述的这些“列”，为了明确起见，这是一种新的数据格式、新的列形式，是你们正在构建的一种新数据格式。这不像是在某个数据库里随便加一列那么简单。

---

### (00:13:10) Daniel Lereya

**English:**
Yeah. So actually, exactly. It's a new column, but it's a whole product around it. If you think about it, for instance, you have a column that dates, so it's pretty straightforward, but you can also have formula column, which is more complicated and has more complex product around it. I think, one of the best benefits for us as platform is that suddenly when we set the goal of adding so many different columns, we actually stopped for the first time and say, "What is the column like?" And we also organized all the product architecture around it. And, these things sounds really trivial in retrospect, but we really define, "Okay, each column need to have specific capabilities. It should be able to export it to Excel. It should be able to be filtered and sorted." And so many different other things. But basically, we defined what is it, and then create an infrastructure for all these shared things, making the work of adding a new column just thinking about the specific product that you want to provide with each one of these columns.

**中文翻译:**
是的，完全正确。它是一个新的列，但围绕它是一个完整的产品。想想看，比如你有一个日期列，这很直接；但你也可以有一个公式列，这就复杂得多，围绕它有更复杂的产品逻辑。我认为作为平台，对我们最大的好处之一是，当我们设定增加这么多不同列的目标时，我们第一次停下来思考：“一个‘列’到底应该是什么样的？”我们还围绕它重新组织了所有的产品架构。这些事回想起来可能觉得微不足道，但我们当时真正定义了：“好吧，每个列都需要具备特定的功能。它应该能导出到 Excel，应该能被过滤和排序。”还有很多其他功能。但基本上，我们定义了它是什么，然后为所有这些共享功能创建了基础设施，使得增加一个新列的工作变成了只需思考你想通过该列提供的具体产品价值。

---

### (00:14:19) Daniel Lereya (continued)

**English:**
(00:14:19): And the story about it is actually even more interesting. The way we actually achieved it is that we said, "Okay. In two weeks, we're going to have a hackathon, in which, each one of our developers is going to take one column and implement it in one day." And, if you think about it, from four months to one day, it's mind-blowing. And, back then, I remember, people said, "How can it be?" But then, I told you about build an infrastructure, he sent it to me. I did a column at night, just to see how it works. And, on the day that we did the columns, everyone knew what they're going to do, what they're trying to solve, and we just did it. And, two weeks afterwards it was in production, which was amazing.

**中文翻译:**
(00:14:19): 关于这件事的故事其实更有趣。我们实现它的方式是：我们说，“好吧，两周后我们要举办一场黑客松，每个开发人员都要在一天内实现一个列。”想想看，从 4 个月缩短到 1 天，这简直令人难以置信。我记得当时有人问：“这怎么可能？”但后来，我提到了构建基础设施，负责人把它发给了我。我晚上试着做了一个列，看看它是如何运作的。到了黑客松那天，每个人都知道自己要做什么、要解决什么问题，我们就那样完成了。两周后，这些功能就上线了，太不可思议了。

---

### (00:15:11) Lenny Rachitsky

**English:**
What we want to do here is help people avoid these moments where they're almost too late and realizing that things have slowed down. So I think really another important lesson here is the power of ambition and thinking crazily big. A lot of people think that when you ask your team when need to build 25 columns in a month or whatever it was, people would be burned out or feeling super depressed. But really, people get excited. There's all this opportunity to think really differently. It reminds me at our Airbnb, Brian Chesky was very famous for you give him a goal, "Here's our goal for the year." And he's like, "What it would take to 10X this goal?" Just like, "What would it take to do that?" And he's always pushing you to think a lot bigger, because your first reaction's like, "No, no, no. Leave us alone?" But then, you realize, if you really think big, it changes everything about how you approach the problem as you described, where instead of... Like in a day. What would it take to build this in a day?

**中文翻译:**
我们在这里想做的，是帮助人们避免那些“意识到速度变慢时已经太晚”的时刻。所以我认为这里另一个重要的教训是雄心壮志和“疯狂思考”的力量。很多人认为，当你要求团队在一个月内构建 25 个列时，人们会精疲力竭或感到极度沮丧。但实际上，人们会感到兴奋。这提供了完全不同思考方式的机会。这让我想起在 Airbnb 时，Brian Chesky 非常出名的一点是：你给他一个目标，说“这是我们今年的目标”，他会问“要把这个目标扩大 10 倍需要怎么做？”他总是推着你往更宏大的方向思考。虽然你的第一反应可能是“不不不，放过我们吧”，但随后你会意识到，如果你真的往大了想，它会改变你处理问题的一切方式，就像你描述的那样——比如，要在一天内构建这个功能需要什么？

---

### (00:16:05) Daniel Lereya

**English:**
Yeah. And I think, by the way, this is something which is really important about setting ambitious goals. If you set a different goal, "I want to reduce it from four months to three months." So many times, this translates in people's heads to, "I want you to work harder. I want you to work longer hours." And, this is not a message here. It's about working smarter. And I think that many times when we talk about speed of execution, there's fake speed, which means, trying to do the same work by skipping stages or not doing the high quality that you want, but there's the real speed, and speed of organizations, and speed of execution. Many times, it's about doing things right. It's about understanding, A, what is going to move the needle? And work only on that. Not working in a lot of things that you tend to invent when you're trying to solve a problem.

**中文翻译:**
是的。顺便说一句，我认为设定宏大目标有一点非常重要。如果你设定一个不同的目标，比如“我想把时间从 4 个月缩短到 3 个月”，很多时候，这在人们脑子里会转化为“我希望你工作更努力，加班更久”。但这并不是我们要传达的信息。我们要的是“更聪明地工作”。我认为很多时候当我们谈论执行速度时，存在“虚假速度”，即试图通过跳过阶段或降低质量来完成同样的工作；但也有“真实速度”，即组织的速度和执行的速度。很多时候，它是关于把事情做对。它是关于理解：第一，什么能真正产生影响（move the needle）？然后只做那件事。而不是在你试图解决问题时，去做一大堆你自己臆想出来的东西。

---

### (00:17:01) Daniel Lereya (continued)

**English:**
(00:17:01): And B, is about, as you said, thinking differently. And I think that for the goals, this is why we really wanted the goal that you really understand from the first minute that if you work the same way, you cannot achieve it, even if you sleep in the office. So you need to change dramatically how you think. And, the advanced phase of it is that today we're doing it on things that we didn't see others doing. And, we have the confidence, because we have the experience of trusting ourselves that this is an exercise for us that will make us actually think about different solutions.

**中文翻译:**
(00:17:01): 第二，正如你所说，是关于换位思考。我认为对于目标来说，这就是为什么我们想要一个让你从第一分钟就明白“如果你按老套路工作，即使睡在办公室也无法实现”的目标。所以你需要戏剧性地改变你的思考方式。现在我们已经进入了高级阶段，即使在没有看到别人做过的事情上，我们也敢于这样做。我们有信心，因为我们有信任自己的经验，知道这是一种练习，能让我们真正去思考不同的解决方案。

---

### (00:17:45) Lenny Rachitsky

**English:**
I know another element of this that is really important to you that you have shifted the way you all operate is focusing on impact. There was a lot of focus on just building a lot of stuff and you realize there's a lot of power in thinking from perspective of how do we have the most impact? Talk about that.

**中文翻译:**
我知道对你来说另一个非常重要的元素，也是你们转变运营方式的关键，就是专注于“影响力”（Impact）。以前你们可能专注于构建很多东西，但后来你意识到，从“我们如何产生最大影响力”的角度思考具有巨大的力量。谈谈这个吧。

---

### (00:18:00) Daniel Lereya

**English:**
This is the core and the main thing that we also measure our teams, and this is how I see a great PM. So a great PM basically for me is someone that is relentless until he gets this impact, and until he validates that this impact is in place. And, for us, it really changed how we think about things. It really changed how we set goals for our teams. So in many ways PM in Monday, first and foremost, is responsible for creating the shared understanding on what would be impactful for our customers. Okay? It's not about the solution and what we are going to build. It's about, what's the problem, what's the opportunity. And second, how we will know that we moved the needle. And without these two things, you can build so many different things, and it's songs for the door. Such huge part of what I build was never used by users the way I fought it was going to use.

**中文翻译:**
这是核心，也是我们衡量团队的主要指标，这也是我衡量一个优秀 PM 的标准。对我来说，一个优秀的 PM 基本上就是那种在产生这种影响力、并验证这种影响力确实到位之前，绝不罢休的人。对我们来说，这确实改变了我们思考问题的方式，也改变了我们为团队设定目标的方式。所以在很多方面，Monday 的 PM 首先要负责对“什么对我们的客户有影响力”建立共识。明白吗？重点不在于解决方案或我们要构建什么，而在于问题是什么，机会在哪里。其次，我们如何知道我们产生了实际影响？如果没有这两点，你可以构建很多不同的东西，但那都是无用功。我构建的很大一部分东西，用户从来没有按照我预想的方式去使用。

---

### (00:19:02) Daniel Lereya (continued)

**English:**
(00:19:02): So I think that, for me, having this understanding of what we want to change for our customers and also how we know we did it is a huge, huge part of the PM. And, for us, it means that we pay a lot of time in setting goals, in making sure that we really understand both, again, the opportunity, but not only that, but how we'll see and we'll know for sure that we move the needle. In many ways, it changes the conversation. So PMs and the teams, many times, spending a lot of time at the problem area, before they think about the solution. The solution is not the case anymore. There are so many different solutions. And, once you do that and you have these goals, suddenly, it reduces also a lot of the discussions that you have about the different solutions, because everyone knows that everything is going to be tested in real life. So they make everyone treat it differently.

**中文翻译:**
(00:19:02): 所以我认为，对我来说，理解我们想为客户改变什么，以及我们如何知道我们做到了，是 PM 工作中非常非常重要的一部分。对我们来说，这意味着我们要花大量时间设定目标，确保我们真正理解机会所在，不仅如此，还要确定我们如何观察并确信我们产生了影响。在很多方面，这改变了对话的方式。PM 和团队很多时候会在问题区域花大量时间，然后才去思考解决方案。解决方案不再是重点，因为解决方案有很多种。一旦你有了这些目标，突然间，关于不同解决方案的讨论也会减少，因为大家都知道一切都会在现实中接受测试。这让每个人对待工作的方式都不同了。

---

### (00:20:05) Daniel Lereya (continued)

**English:**
(00:20:05): And also, in that way, it makes you think much more holistically, which I also think is something that is very special at Monday, is that, we give our teams real life goals as much as we can. And then, in some cases, doing the biggest impact is not developing another feature. It's about making the current value more accessible. It's about connecting better the go-to market motion that you have. It's about understanding how your customers are going to learn what you built and use it. And, this realization is something that we try very hard to stay on it. And, it's hard, because people tend to build things. We all love to build things. And, when you start to build things, you get excited, and suddenly, you lose track of why you are doing it, and why do you need to change.

**中文翻译:**
(00:20:05): 此外，这种方式让你思考得更加全面，这也是我认为 Monday 非常特别的一点：我们尽可能给团队设定现实生活中的目标。在某些情况下，产生最大影响力并不是开发另一个功能，而是让现有的价值更容易获取，或者是更好地连接你的市场推广（GTM）动作，或者是理解客户将如何学习并使用你构建的东西。我们非常努力地坚持这种认知。这很难，因为人们倾向于构建东西，我们都喜欢创造。当你开始构建时，你会感到兴奋，然后突然间，你就忘了你为什么要这么做，以及为什么需要改变。

---

### (00:21:04) Daniel Lereya (continued)

**English:**
(00:21:04): And, I think that in that sense, this is the most important part about this point of impact. And, this is also how we measure ourselves, so we can work extremely hard. It doesn't mean that we're successful, it doesn't mean that we're doing our work right. And, it's not only for the PMs, it's for the entire team. So the entire team succeeds or fail together, based on the value that we bring to our customers. And we have a lot of different ways in order to make sure that we stay honest to this principle.

**中文翻译:**
(00:21:04): 我认为从这个意义上说，这是关于“影响力”最核心的部分。这也是我们衡量自己的方式：我们可以工作得极其努力，但这并不意味着我们成功了，也不意味着我们的工作方式是对的。这不仅针对 PM，而是针对整个团队。整个团队根据我们为客户带来的价值共同成败。我们有很多不同的方法来确保我们忠于这一原则。

---

### (00:21:37) Lenny Rachitsky

**English:**
There's a lot of people listening to this that work at, say, modern tech companies, very high growth tech companies that are just like, "Duh, this is how you should work." A lot of people hearing this are like, "I don't really understand. What am I doing wrong? What am I missing?" Maybe. What's a sign that you're not oriented around impact?

**中文翻译:**
很多听众可能在现代科技公司、高增长科技公司工作，他们会觉得“废话，本来就该这么工作”。但也有很多人听了会想：“我不太明白。我做错了什么？我漏掉了什么？”也许，有什么迹象表明你并没有以“影响力”为导向？

---

### (00:21:56) Daniel Lereya

**English:**
I think, the most obvious sign for me is that you are building something without the aim or without the initial aim of what it changed for your users and how you are going to measure it. So in my eyes, it's many times the fact that you don't have a goal or the goal is like... Many times, for me, a smell for that is that I hear people use the word, "We're going to enhance..." "We're going to augment..." "We're going to extend value, and this, and this, and this." No, it's not enough. What is it going to change for users and how you are going to see it that it actually happened? And then, you start asking yourself all the questions, right? Because, once you have a goal that you're committed to, suddenly, you think about the target audience, because you need big enough target audience, for instance, in order to get to your goals. You need to make sure that what you build actually going to touch all of these people.

**中文翻译:**
我认为对我来说最明显的迹象是，你在构建某个东西时，没有明确的目标，或者没有预设它会为用户改变什么，以及你将如何衡量它。在我看来，很多时候是因为你没有目标，或者目标太虚。对我来说，一种典型的“异味”是听到人们说：“我们要增强……”“我们要扩大……”“我们要延伸价值，以及这个那个。”不，这还不够。它到底会为用户改变什么？你如何观察到这种改变确实发生了？然后，你会开始问自己所有相关的问题，对吧？因为一旦你有了承诺的目标，你突然就会考虑目标受众，因为为了达到目标，你需要足够大的受众群体。你需要确保你构建的东西确实能触达所有这些人。

---

### (00:22:58) Daniel Lereya (continued)

**English:**
(00:22:58): And I can share just a recent example. And, these things sound trivial and maybe an example would help resonate with that, because I know many people are thinking like that. And, we have a very interesting offering that we just introduced with AI, it's called AI Blocks. Okay? And basically, it means that with no-code, you can integrate blocks which contain AI actions within your existing workflows. And, 70% of Monday's customers are non-tech. And for them, this makes AI accessible for them and has a huge, huge value. And we started building these blocks and we listed to customers and we measured discoverability, and adoption, and retention, and so on. And, something that we do in order to stay connected to the numbers. So each team at Monday has, what we call, the daily numbers update. So think about it like a message that the team is building with all the numbers-

**中文翻译:**
(00:22:58): 我可以分享一个最近的例子。这些事听起来可能微不足道，但例子可能有助于产生共鸣。我们最近推出了一个非常有趣的 AI 产品，叫做 AI Blocks。基本上，它意味着通过无代码方式，你可以将包含 AI 动作的模块集成到现有的工作流中。Monday 70% 的客户是非技术人员，对他们来说，这让 AI 变得触手可及，具有巨大的价值。我们开始构建这些模块，听取客户意见，并衡量可发现性、采用率、留存率等等。为了保持对数据的敏感，Monday 的每个团队都有所谓的“每日数据更新”。把它想象成团队汇总所有关键数据的一条消息——

---

### (00:24:00) Daniel Lereya (continued)

**English:**
(00:24:00): ... a message that the team is building with all the numbers that they care about, because we really want people to live these numbers. So, for AI, for instance, for the AI blocks, it was the AI actions. So we had the AI actions, how many accounts are we using these AI actions, and so on, and so on. And we got amazing responses from our customers. We see great success of them getting value from the AI actions. We use a Slack channel in which one of our internal systems, [inaudible 00:24:36], is sending us this messages every day, and then we have conversations about it, okay? And one day, we saw, we noticed that the amount of accounts that are using AI is super, super low comparing to the entire population that we have. And we have 250,000 paying companies that use Monday, and we saw only few thousands there.

**中文翻译:**
(00:24:00): ……团队会汇总他们关心的所有数据，因为我们真心希望大家能“活在数据中”。例如，对于 AI Blocks，关键指标就是 AI 动作。我们会看有多少账户在使用这些 AI 动作等等。我们收到了客户非常棒的反响，看到他们通过 AI 动作获得了价值。我们有一个 Slack 频道，我们的一个内部系统每天会向我们发送这些消息，然后我们会对此进行讨论。有一天，我们注意到使用 AI 的账户数量相对于我们的总用户群来说非常非常低。我们有 25 万家付费公司在使用 Monday，但当时只有几千家在使用 AI。

---

### (00:25:48) Daniel Lereya (continued)

**English:**
(00:25:48): And until this point, everyone in a very good feeling that we are making an amazing product, we get really good feedback, we are building great value, we're adding value, but we sat down and say, "Okay, why it's only this and this?" Then someone say, "Yeah, since AI is new, we need to do change of the terms of service for customers before we are opening it to them," and this is planned in the next quarter, or something like that. And said, "What? No, we need to do it now. We need to now open it for everyone because this is actually what would be the most impactful thing to do." And then the team went and sat with legal, and sent with everyone. And with two weeks time, it was open to 98% of Monday customers. And I think, in that sense, this is a very good example because we could have continued building value, and it's great, but the impact wouldn't be the impact that we were aiming for, and this is a very important point.

**中文翻译:**
(00:25:48): 在那之前，每个人的感觉都很好，觉得我们在做一个很棒的产品，反馈很好，我们在创造价值。但我们坐下来问：“好吧，为什么只有这么点人用？”然后有人说：“哦，因为 AI 是新事物，在向客户开放之前，我们需要更改服务条款，这计划在下个季度完成。”我们说：“什么？不，我们现在就得做。我们现在就得向所有人开放，因为这才是目前最有影响力的事情。”于是团队去找法务，找所有人协调。两周之内，它就向 98% 的 Monday 客户开放了。我认为这是一个非常好的例子，因为我们可以继续构建新功能、创造价值，这很好，但那样产生的产出并不是我们追求的那个量级的产出，这一点非常重要。

---

### (00:26:46) Daniel Lereya (continued)

**English:**
(00:26:46): I think, in that sense, staying really connected to your teams... to your numbers. Sorry, this is something that I really feel strongly about. I feel that you need to get your numbers and push. You need to live by them. For me, it's so exciting to see a conversation that says, "Oh, wow, today, there were a lot of new accounts that are using what I'm building. Let's see why it happens." And this kind of things that I see the conversation about, it's amazing. And also, in this case, seeing the AI actions go, it's like you want to dive it and push it forward. And in many ways, they feel that this is a very good example on where you can actually build a lot of value. You can walk really fast, you can deliver a lot of features, but the problem lays in other place in order to get the impact that you want.

**中文翻译:**
(00:26:46): 我觉得从这个意义上说，保持与你的数据紧密联系——抱歉，这是我非常有感触的一点。我觉得你需要掌握你的数据并以此推动工作。你需要依数据而生。对我来说，看到这样的对话非常令人兴奋：“哇，今天有很多新账户在使用我构建的功能，让我们看看为什么。”看到这种围绕数据的讨论，感觉太棒了。在这种情况下，看到 AI 动作的数据增长，你会想要深入研究并推动它。在很多方面，这是一个很好的例子，说明你实际上可以创造很多价值：你可以行动很快，交付很多功能，但为了获得你想要的影响力，问题可能出在其他地方。

---

### (00:27:08) Lenny Rachitsky

**English:**
Yeah. There's so much joy in watching your number go up. So, just to close the loop here, to help people see if they're impact-driven, working from a perspective of how do we drive the most impact, one simple way of thinking about it is you're working backwards from a goal that is going to drive business growth and revenue, basically, in the end. If you're working backwards from a number, and a metric, and a goal, and then thinking through what are the levers that will most move this metric, that's a sign you're thinking by impact, versus, "Let's just keep shipping features that the sales team wants."

**中文翻译:**
是的，看着数据上升确实很有成就感。所以，为了总结一下，帮助人们判断自己是否是以“影响力”为导向，从“我们如何产生最大影响力”的角度出发，一个简单的思考方式是：你是否在从一个最终能推动业务增长和收入的目标倒推。如果你是从一个数字、一个指标、一个目标倒推，然后思考哪些杠杆最能推动这个指标，那就是你以影响力为导向的迹象；而不是“让我们继续发布销售团队想要的功能”。

---

### (00:27:43) Daniel Lereya

**English:**
Yeah. And I think another thing for me, it's an exercise that I really encourage everyone to do. For me, it was after the columns hackathon and everything that we talked about, I said, "Okay, each quarter..." and this is when we were much smaller, but it can be each month, it can be each two weeks, but how do I imagine the company and the product is going to be different and better for our customers in a quarter from now? And from that, walk it backwards.

**中文翻译:**
是的。我认为对我来说还有另一件事，是我非常鼓励大家去做的一个练习。对我来说，是在“列”黑客松以及我们谈到的一切之后，我说：“好吧，每个季度……”（这是在我们规模还小的时候，现在可以是每个月或每两周）我会问：“我如何想象一个季度后，公司和产品会变得如何不同，如何为客户提供更好的服务？”然后从那里开始倒推。

---

### (00:28:17) Daniel Lereya (continued)

**English:**
(00:28:17): But if you are just saying, "We'll have better security. We'll have better performance. We'll have less bugs. We'll have more enhancements to," I don't know, "this and this feature," it's not enough. You need to constantly build value, which is pivotal to your customers. And if you don't do it and if it's hard for you to answer about this question, it's a very good sign that you are not impact-driven. And I love to do it also with teams and individuals like, "What are the things that you are most proud of that you did in the last three months?" And if it takes you a lot of time to think, you are not very focused and you are definitely not maximizing the impact that you want due to that, in my eyes.

**中文翻译:**
(00:28:17): 但如果你只是说，“我们将有更好的安全性，更好的性能，更少的 Bug，对某某功能有更多增强”，这还不够。你需要不断构建对客户至关重要的价值。如果你做不到这一点，或者你很难回答这个问题，那就说明你不是以影响力为导向的。我也喜欢对团队和个人做这个练习：“过去三个月里，你做的最让你自豪的事情是什么？”如果你需要花很长时间去想，那么在我看来，你不够专注，而且你肯定没有因此最大化你想要的影响力。

---

### (00:29:01) Lenny Rachitsky

**English:**
I like that exercise as a, versus waiting for your competitors to do something and then realizing we're way behind, it's forcing yourself every quarter to think about this. So do you do this as you have a meeting or something on your calendar, or how do you actually operationalize this?

**中文翻译:**
我喜欢这个练习，它不是等着竞争对手做了什么才意识到自己落后了，而是强迫自己每个季度都去思考。那么，你是通过会议还是在日历上安排时间来做这件事？你具体是如何将其付诸实践的？

---

### (00:29:17) Daniel Lereya

**English:**
Today, we are under the builders organization, which is the engineering, product management, product design. We are 700 people. So, we have a lot of different ways and methodologies to do it in different levels, but I'll give you an example from the company level and from the team level maybe, because these are the most interesting ones. So, we just recently had our yearly kickoff. Each and every year, we do a yearly kickoff for our company, and one of the most exciting sessions, obviously, is what we are going to do with our product as a product company. And I really like to have a slide in which I write and I just share it, " When I'm going to stand here in a year from now, what is going to be different for our customers?" And this is on the company level.

**中文翻译:**
现在，我们在“建设者组织”（Builders Organization）下，包括工程、产品管理和产品设计，共有 700 人。所以，我们有很多不同的方式和方法在不同层级执行，但我可以给你举一个公司层面和团队层面的例子，因为这些是最有趣的。我们最近刚举行了年度启动会（Yearly Kickoff）。每年我们都会为公司举行年度启动会，显然最令人兴奋的环节之一就是作为一家产品公司，我们将如何处理我们的产品。我非常喜欢准备一张幻灯片，上面写着并分享：“当我一年后站在这里时，我们的客户会有什么不同？”这是在公司层面的。

---

### (00:30:08) Daniel Lereya (continued)

**English:**
(00:30:08): And I have one slide, and it talks about our offering and it talks about the value that they are getting in a way that, next year, I want to... each year to start my presentation with the slide from last year and see where we are. And in this level, it can be something like, "Our CRM continues with a very strong momentum and becomes a product suite when we give much more robust value to our customers." This can be an example with an additional product of CRM marketing, I would just say.

**中文翻译:**
(00:30:08): 我有一张幻灯片，讲述我们的产品以及客户获得的价值。我希望每年开始演讲时，先展示去年的那张幻灯片，看看我们走到了哪里。在这个层面上，内容可能是：“我们的 CRM 继续保持强劲势头，并成为一个产品套件，为客户提供更强大的价值。”比如，增加一个 CRM 营销产品。

---

### (00:30:42) Daniel Lereya (continued)

**English:**
(00:30:42): But on a team level, what we did, and maybe I'll take an example from the early days, we really love to do, each and every two weeks, I told you we would write an update for the entire company about what we did, and the way we did it is that each and every one of our team members actually write out his highlights and then we would share it with the company. And this exercise really made us sit every two weeks and think on individual level, but also on a team level. And every one of our team members used to read these updates and say, "Dan, we had a good two weeks," or, "We had a bad two weeks," "We did a lot of impact," or, "We did not enough impact." So I really encourage to create these points in time where you sit down and you force yourself to understand whether what you did is what you thought you are going to achieve or not.

**中文翻译:**
(00:30:42): 但在团队层面，我举个早期的例子。我们非常喜欢每两周写一次全公司更新，汇报我们做了什么。做法是每个团队成员写下自己的亮点，然后我们分享给全公司。这个练习促使我们每两周坐下来，从个人和团队层面进行思考。每个团队成员都会读这些更新并说：“Dan，这两周我们表现不错，”或者“这两周不太行”，“我们产生了很多影响力，”或者“影响力不够”。所以我非常鼓励建立这些时间节点，坐下来强迫自己去理解：你所做的是否达到了你预期的目标。

---

### (00:31:46) Lenny Rachitsky

**English:**
That's great. I really like the slide idea. It's basically there's all this power and just working backwards from something in the future, however you come up with it. So, it's just like, in a year, we're going to have... There's just working backwards from a goal, working backwards from a big vision. I think those are such good exercises. Obviously, Amazon's famous Working Backwards. There's a whole book called Working Backwards from their PR approach. Okay, I want to go in a slightly different direction. I want to zoom out a little bit. So you've been at this for eight years, building Monday. You said there is 250,000 customers at this point. What's the revenue scale? Give people a couple stats to give them a sense of just how large this company has gotten.

**中文翻译:**
太棒了。我很喜欢那个幻灯片的点子。这基本上就是从未来的某个点倒推的力量，无论你是如何想出那个点的。就像是，“一年后，我们将拥有……”这就是从目标倒推，从大愿景倒推。我认为这些都是非常好的练习。显然，亚马逊的“逆向工作法”（Working Backwards）非常有名，还有一整本书专门讲他们从公关稿开始倒推的方法。好，我想换个方向，稍微放大一点视角。你在 Monday 已经八年了。你说现在有 25 万名客户。收入规模是多少？给听众几个数据，让他们感受一下这家公司现在有多大。

---

### (00:32:24) Daniel Lereya

**English:**
We recently announced that we cost the 1 billion in ARR, and we are serving, as I said, 250,000 customers across the globe from virtually any industry that you can think about, more than 200 different business verticals. It could be both tech and non-tech-savvy customers. The vast majority of our customers are non-tech, from a customer that is building airplanes and cruise ships, all the way to real estate, construction, finance, tech, and everything you can basically think of. Just for reference, in a single [inaudible 00:33:06], when I joined Monday eight and a half years ago, back then, we were called the Pulse. We had around 4 million in ARR, and we scaled from there to 1 billion. And from around 30, 40 people in the company to 2,500 right now.

**中文翻译:**
我们最近宣布 ARR（年度经常性收入）突破了 10 亿美元。正如我所说，我们为全球 25 万名客户提供服务，涵盖了几乎你能想到的任何行业，超过 200 个不同的业务垂直领域。客户既有技术型的，也有非技术型的。绝大多数客户是非技术型的，从制造飞机和邮轮的客户，到房地产、建筑、金融、科技，基本上你能想到的一切。仅供参考，八年半前我加入 Monday 时（那时我们还叫 Pulse），我们的 ARR 只有 400 万美元左右，然后我们从那里扩展到了 10 亿。公司人数也从 30、40 人增加到了现在的 2500 人。

---

### (00:33:29) Lenny Rachitsky

**English:**
Awesome. When you talk about the product you're building, to a lot of people, it's like, "Oh, it's like project management software, all this column. What's the big deal?" But I had Drew Houston on the podcast, and he made this really interesting point when he talks to people working at SpaceX, who are launching rockets to Mars, and he talked about people building ships. If you really boil down what are they doing day-to-day, they're sitting in tools like Monday, putting together tasks, and doing to-dos, and sharing documents. This is what the world runs on. So it's important to have that perspective. With that, putting that aside for a second, I think very few people have seen what you've seen, seeing a company scale this way. Also, the transformation you just shared of just almost shipping too much and being slow to like, "Okay, let's rework things to shipping 25 columns in a month," and all these things. Very few people have seen this, so there's a lot to learn from this journey that you've been on. So I have a bunch of questions in a bunch of different ways of approaching some of your biggest lessons from this journey. The first is, let me just ask you this question, what would you say is the most counterintuitive thing you've learned about building product and leading teams through this journey of building Monday?

**中文翻译:**
太棒了。当你谈论你正在构建的产品时，对很多人来说，它可能只是“哦，就像项目管理软件，这些列。有什么大不了的？”但我曾邀请 Dropbox 的 Drew Houston 参加播客，他提出了一个非常有趣的观点：当他与 SpaceX 那些向火星发射火箭的人交谈时，或者谈到造船的人，如果你真正归纳他们每天在做什么，他们其实是坐在像 Monday 这样的工具前，整理任务、做待办事项、分享文档。这就是世界运转的方式。所以拥有这种视角很重要。撇开这一点不谈，我认为很少有人见过你所见过的景象——看到一家公司以这种方式扩展。还有你刚才分享的转型：从几乎发布太多但速度缓慢，转变为“好吧，让我们重新梳理，一个月发布 25 个列”。很少有人经历过这些，所以从你的这段旅程中有很多值得学习的地方。我有一系列问题，想从不同角度探讨你这段旅程中最大的教训。首先，我想问：在构建 Monday 和领导团队的过程中，你学到的最反直觉的事情是什么？

---

### (00:34:39) Daniel Lereya

**English:**
Maybe, first of all, it's about something that we really care about, which is transparency. Let me tell you a story. I sat down for dinner at my family, and many different members of my family are entrepreneurs, so working as an executive in tech companies and so on. And back in the days, we as Monday, before we went public, we actually shared every bit of information with our employees. You would get into our office and you would see a dashboard with how many paying accounts do you have, how many people have churned today, how many signups do we have, and so many different things. Even if you came for an interview, you would see these numbers.

**中文翻译:**
也许首先是我们非常看重的一点：透明度。让我给你讲个故事。有一次我和家人坐下来吃晚饭，我家里很多人都是企业家，或者是科技公司的高管等等。在 Monday 上市之前，我们实际上向员工分享了每一条信息。你走进我们的办公室，就会看到一个仪表盘，上面显示我们有多少付费账户、今天有多少人流失、有多少注册用户，以及许多其他信息。即使你是来面试的，你也会看到这些数字。

---

### (00:35:27) Daniel Lereya (continued)

**English:**
(00:35:27): And I remember sitting in this dinner and everyone would tell me, "Listen, you are making a mistake. How can you do it when things go south? You'll demoralize the team and people will get upset about it." And I think this is, for me, one of the most important things. When you hire and you have such a talented team, we want to share with them everything, and the reason for that is that, "Dan, you are working on every challenge together." And instead of demoralizing people, I think that, for the right people and the people that are working at Monday, this is something that gives them a sense of deep partnership. And as a leader, there were many situations in my professional life that I knew some bit of information and I felt all the way on my shoulders, and I love to call it the dark side of the moon. You're there alone, right? You are coming to the office. There's nothing more demoralizing or depressing as a leader that you feel awful because something that you know and you're coming to the office and everything is great and everyone are happy.

**中文翻译:**
(00:35:27): 我记得在那次晚餐中，每个人都对我说：“听着，你犯了个错误。如果情况变糟了怎么办？你会挫伤团队士气，大家会因此感到不安。”但我认为，对我来说，这是最重要的事情之一。当你雇佣了如此优秀的团队时，我们想与他们分享一切，原因在于：“我们是在共同应对每一个挑战。”我认为，对于合适的人以及在 Monday 工作的人来说，这不仅没有挫伤士气，反而给了他们一种深度的伙伴感。作为一名领导者，在我的职业生涯中，有很多次我知道某些信息，感觉所有的重担都在我一个人肩上，我喜欢称之为“月球的背面”。你独自在那里，对吧？你来到办公室，作为领导者，没有什么比这更让人沮丧或压抑的了：你因为知道某些事而感觉糟糕透顶，但你来到办公室，发现一切看起来都很棒，每个人都很开心。

---

### (00:36:47) Daniel Lereya (continued)

**English:**
(00:36:47): And I think, in Monday, we really wanted to do it differently and we really have an approach of very radical transparency about everything, and this actually makes everyone part of what we are doing. And in a way, we like to say, "We really want everyone's brains in the challenge and not just one centralized brain and a lot of working hands." And I can share examples when, for instance, suddenly, people would come up to the office. We have dashboards, of course, everywhere in the office. Each team has its own dashboards. We have our company dashboards for metrics and so on. And I remember cases in which someone said, "Listen, what happened to the conversion?" And think how powerful it is when you have everyone at the company looking at these things. And many of the things that we discovered, many of the things that we saw as challenges and problems is things that people saw due to this transparency.

**中文翻译:**
(00:36:47): 我认为在 Monday，我们真的想换种做法，我们对一切都采取了非常激进的透明化方式，这实际上让每个人都成为了我们事业的一部分。在某种程度上，我们喜欢说：“我们真心希望每个人的大脑都能参与挑战，而不仅仅是一个集权式的大脑和一堆只管干活的手。”我可以举些例子，比如突然间有人来到办公室——当然，我们办公室到处都是仪表盘，每个团队都有自己的仪表盘，我们还有公司的指标仪表盘等等。我记得有些案例，有人问：“听着，转化率怎么了？”想想看，当全公司的人都在关注这些事情时，那是多么强大。我们发现的许多事情，我们看到的许多挑战和问题，都是因为这种透明度才被大家看到的。

---

### (00:37:48) Daniel Lereya (continued)

**English:**
(00:37:48): So I think that maybe the counterintuitive part is that don't be afraid to share the information. It's exactly the other way around. And I can probably share that, even today as a public company, we really share everything that we can. And also, if you are a product manager at Monday, you are signing a 10b5 program for selling your stocks, meaning that we found a way to make everyone still see the data because we think this is the most important part. And I think this is one thing that I really believe in and really changed how we work, and also how people are feeling about being partners in building Monday and not just working at the company.

**中文翻译:**
(00:37:48): 所以我认为，反直觉的部分可能是：不要害怕分享信息。事实恰恰相反。我可以分享的是，即使在今天作为一家上市公司，我们仍然尽可能分享一切。而且，如果你是 Monday 的产品经理，你会签署一份 10b5-1 计划（内幕交易预设交易计划）来出售你的股票，这意味着我们找到了一种方法，让每个人仍然能看到数据，因为我们认为这是最重要的部分。这是我深信不疑的一点，它确实改变了我们的工作方式，也改变了人们对成为构建 Monday 的合作伙伴（而不仅仅是在公司工作）的感觉。

---

### (00:38:37) Lenny Rachitsky

**English:**
Is that thing they sign that's just like auto sell stocks? So they're not selling based on information, based on announcements that's coming. Okay, got it. So every PM basically has to automatically, "Can't decide, I'm going to sell my stock tomorrow because this number is tanking."

**中文翻译:**
他们签署的那个东西是自动出售股票吗？这样他们就不是根据信息或即将发布的公告来出售股票了。明白了。所以每个 PM 基本上都必须自动执行，“不能因为看到这个数据在暴跌，就决定明天卖掉股票”。

---

### (00:38:51) Daniel Lereya

**English:**
Exactly, yeah. We want to give people a choice. But usually, we really feel that, in most cases, you really need to know this information in order to do your work.

**中文翻译:**
没错。我们想给人们选择权。但通常我们觉得，在大多数情况下，你确实需要了解这些信息才能做好工作。

---

### (00:39:02) Lenny Rachitsky

**English:**
That's so interesting. And I think people even prefer just dollar cost average sell. It's like makes life easier, not having to try to time all these things.

**中文翻译:**
这太有趣了。我想人们甚至更喜欢定期定额出售。这让生活变得更简单，不用去尝试择时。

---

### (00:39:11) Daniel Lereya

**English:**
I definitely think so, yeah.

**中文翻译:**
我绝对也是这么想的。

---

### (00:39:14) Lenny Rachitsky

**English:**
That's really interesting. And that's just product managers, or how far does that all go?

**中文翻译:**
这很有趣。这只是针对产品经理吗，还是范围更广？

---

### (00:39:19) Daniel Lereya

**English:**
No. So, basically, when we became public, I remember still one of the conversations that we had with the bankers and the lawyers about, "Listen, guys, things would need to change. You cannot have a dashboard. We follow your financials at the entrance of the building. It doesn't make sense as a public company." And we understood it, but we didn't want to let go of what we cared about because we really believe this is one of the main drivers to the business, having this transparency and having this shared brains mode. So, we tried to think about ways in order to do it.

**中文翻译:**
不。基本上，当我们上市时，我还记得与银行家和律师的一次对话，他们说：“听着，伙计们，情况需要改变。你们不能在建筑入口处放一个显示财务状况的仪表盘。作为一家上市公司，这不合规。”我们理解这一点，但我们不想放弃我们看重的东西，因为我们坚信这种透明度和“共享大脑”模式是业务的主要驱动力之一。所以，我们尝试思考实现它的方法。

---

### (00:39:59) Daniel Lereya (continued)

**English:**
(00:39:59): So, now, if I'll fast-forward, we're almost four years public, and we have an internal app called Monday Morning. And in Monday Morning, you have two parts, part A and part B. Part A is for every company employee, contains a lot about engagement and a lot of data that can be shared with everyone, and part B is confidential and it's by role, okay? So it's the company management, but I think the important point is that we see product management as something that got to have these numbers. So we thought about it really hard, and it's a lot of logistics to do so many plans, 10b5 plans, but I think it's worth it, yeah.

**中文翻译:**
(00:39:59): 所以现在，快进到今天，我们已经上市快四年了，我们有一个名为“Monday Morning”的内部应用。在 Monday Morning 中有两个部分：A 部分和 B 部分。A 部分面向每位公司员工，包含大量关于参与度和可以与所有人分享的数据；B 部分是机密的，按角色划分。B 部分面向公司管理层，但关键点在于，我们认为产品管理岗位必须掌握这些数据。所以我们认真思考了这个问题，虽然制定这么多 10b5 计划涉及很多后勤工作，但我认为这是值得的。

---

### (00:40:45) Lenny Rachitsky

**English:**
This is so interesting. A lot of companies talk about transparency, and you guys are... I think radical transparency is a good way to describe this because I've never heard of a company doing this where you have to sign this-

**中文翻译:**
这太有意思了。很多公司都在谈论透明度，而你们……我认为“激进的透明度”是描述这种做法的好词，因为我从未听说过有哪家公司会要求员工签署这个——

---

### (00:40:57) Daniel Lereya

**English:**
They didn't hear about it as well, apparently. And yeah, it took time to get to these solutions.

**中文翻译:**
显然，他们（律师和银行家）也没听说过。是的，找到这些解决方案花了不少时间。

---

### (00:41:05) Lenny Rachitsky

**English:**
That's so funny. So, for people that are listening to this, they're like, "Hey, maybe we should explore this." What's one thing you'd suggest that they could do to start moving down this road? And the benefit, again, is you... I guess maybe, again, remind people of the benefits of doing this, because it sounds like a lot of work and risk.

**中文翻译:**
太搞笑了。所以，对于正在听这个播客并觉得“嘿，也许我们也该探索一下”的人，你有什么建议可以让他们开始尝试这条路吗？另外，我想请你再次提醒大家这样做的好处，因为这听起来工作量很大且有风险。

---

### (00:41:20) Daniel Lereya

**English:**
So I think that, as a young startup, it's actually not such a hard work. When we were very small back in the days, we had the daily numbers concept that we now have for the teams, we had the daily numbers for the company, how much paying accounts, how many upgraded, downgrade, and so on daily, and you saw people reacting to it on a daily basis. So this is something that you can do in virtually one hour, and it changes how people see their role within the company, focus everyone to the company's KPIs because everyone understand what you care about, and so on. So this is one thing that you can do extremely fast, and I don't see any disadvantage, aside from the fact that people are afraid. Many time, you are afraid. And I can share, it's so much... It's even a bigger lift that you don't need to think, "Can I share it? Can I don't share it?" You just let it go and everything would be okay. And I can share from my experience that we shared everything.

**中文翻译:**
我认为，对于一家年轻的初创公司来说，这其实并不难。当我们还很小的时候，我们就有了现在团队中使用的“每日数据”概念。我们有公司的每日数据：每天有多少付费账户、多少升级、多少降级等等，你会看到大家每天对此做出反应。这基本上是一小时内就能搞定的事情，但它改变了人们对自己在公司中角色的看法，让每个人都专注于公司的 KPI，因为大家都明白你关心什么。这是你可以极速完成的一件事，除了人们会感到害怕之外，我看不出有什么缺点。很多时候，你只是害怕。我可以分享的是，当你不需要去想“我能不能分享这个？我该不该分享那个？”时，这反而是一种更大的解脱。你只需顺其自然，一切都会好起来的。根据我的经验，我们分享了一切。

---

### (00:42:23) Daniel Lereya (continued)

**English:**
(00:42:23): And the second thing which is really practical, it's the office dashboards. We really believe in it. So, you buy a TV, you put it on the wall, you start a conversation due to it, "What do we want to show on this TV?" And when we were a smaller startup and we sat all in one office space, we had our company goals dashboard, and it also had... We programmed it to have sounds on meaningful events. So, when you had, for instance, new paying account, you had the almost Simpson saying the same with the, "$1 million, I'll become a millionaire," or something like that. For new signup, you add the tick, and so on. So, suddenly, everyone are living it. It becomes part of the cadence of the company. So these are just two ideas to make it super easy, and the change happens immediately.

**中文翻译:**
(00:42:23): 第二件非常实用的事是办公室仪表盘。我们深信这一点。买台电视，挂在墙上，围绕它开始对话：“我们想在这台电视上显示什么？”当我们还是小初创公司、大家坐在一起办公时，我们有公司目标仪表盘，我们还给它编程，让它在发生重大事件时发出声音。比如，当有新的付费账户时，你会听到类似辛普森说“100 万美元，我要成百万富翁了”之类的声音；对于新注册，会有“嘀嗒”声等等。突然间，每个人都沉浸其中。它成为了公司节奏的一部分。这两个主意非常容易实现，而且改变立竿见影。

---

### (00:43:18) Lenny Rachitsky

**English:**
I love how that connects back to the whole point about impact. People all lining around here is what we're trying to drive. If the Simpson sound is going off, that's a sign that this matters, and it's something we should be driving up.

**中文翻译:**
我喜欢这与“影响力”这一点的联系。大家都在关注我们试图推动的目标。如果辛普森的声音响了，那就说明这件事很重要，是我们应该推动增长的事情。

---

### (00:43:29) Daniel Lereya

**English:**
And it creates such a partnership. I remember reaching to the first time where we had $1 million collection in one month, breaking the record of new paying accounts for one day, everyone are living. But in many companies, only the management or the founders are feeling. And I think that, in that sense, you already feel that you have a great power because everyone around is the same things, and it makes conversations different because everyone understands what matters to you at that point.

**中文翻译:**
这创造了一种伙伴关系。我记得我们第一次单月收款达到 100 万美元，或者打破单日新付费账户记录时，每个人都在欢呼。但在很多公司，只有管理层或创始人能感受到这些。我认为从这个意义上说，你会感到一种巨大的力量，因为周围的每个人都在关注同样的事情，这让对话变得不同，因为大家都明白在那一刻什么对你最重要。

---

### (00:43:57) Lenny Rachitsky

**English:**
This is awesome, really cool counterintuitive lesson. I feel like a whole podcast could be done on how to do this effectively. I want to move on, but I guess if people want to start implementing this at the company, let's just say they should go talk to you, and you could give them a bunch of advice.

**中文翻译:**
这太棒了，非常酷的反直觉教训。我觉得可以专门做一期播客来讨论如何有效地做到这一点。我想继续往下聊，但我想如果人们想在公司开始实施这个，他们应该去找你聊聊，你可以给他们很多建议。

---

### (00:44:10) Daniel Lereya

**English:**
I would love to.

**中文翻译:**
我很乐意。

---

### (00:44:11) Lenny Rachitsky (Ads)

**English:**
This episode is brought to you by Vanta, and I am very excited to have Christina Cacioppo, CEO and co-founder of Vanta, joining me for this very short conversation. Christina, great to be here. Big fan of the podcast and the newsletter. Vanta is a longtime sponsor of the show. But for some of our newer listeners, what does Vanta do and who is it for?

**中文翻译:**
本集由 Vanta 赞助，我非常高兴邀请到 Vanta 的首席执行官兼联合创始人 Christina Cacioppo 参加这段简短的对话。Christina 说：“很高兴来到这里，我是播客和时事通讯的忠实粉丝。”Vanta 是本节目的长期赞助商。但对于一些新听众，Vanta 是做什么的，它是为谁服务的？

---

### (00:44:30) Christina Cacioppo (Ads)

**English:**
Sure. So we started Vanta in 2018 focused on founders, helping them start to build out their security programs and get credit for all of that hard security work with compliance certifications, like SOC 2 or ISO 27001. Today, we currently help over 9,000 companies, including some startup household names, like Atlassian RAMP and LangChain, start and scale their security programs, and ultimately build trust by automating compliance, centralizing GRC, and accelerating security reviews.

**中文翻译:**
好的。我们在 2018 年创立了 Vanta，专注于创始人，帮助他们开始建立安全计划，并通过 SOC 2 或 ISO 27001 等合规认证，让他们辛苦的安全工作得到认可。今天，我们帮助超过 9000 家公司，包括 Atlassian、RAMP 和 LangChain 等知名初创公司，启动并扩展其安全计划，最终通过自动化合规、集中化 GRC（治理、风险与合规）和加速安全审查来建立信任。

---

### (00:45:01) Lenny Rachitsky (Ads)

**English:**
That is awesome. I know from experience that these things take a lot of time and a lot of resources, and nobody wants to spend time doing this.

**中文翻译:**
太棒了。根据经验我知道，这些事情需要花费大量时间和资源，而且没人想把时间花在这上面。

---

### (00:45:08) Christina Cacioppo (Ads)

**English:**
That is very much our experience before the company, and to some extent, during it, but the idea is, with automation, with AI, with software, we are helping customers build trust with prospects and customers in an efficient way. And our joke, we started this compliance company so you don't have to.

**中文翻译:**
这正是我们在创立公司之前，甚至在某种程度上在公司运营期间的经历。但我们的理念是，通过自动化、AI 和软件，我们正在帮助客户以高效的方式与潜在客户和现有客户建立信任。我们的笑话是：我们开了这家合规公司，这样你就不用开了。

---

### (00:45:25) Lenny Rachitsky (Ads)

**English:**
We appreciate you for doing that, and you have a special discount for listeners. They can get $1,000 off Vanta at vanta.com/lenny, that's V-A-N-T-A.com/lenny for $1,000 off Vanta. Thanks for that, Christina.

**中文翻译:**
感谢你们所做的一切。你们为听众提供了特别优惠：在 vanta.com/lenny 可以获得 1000 美元的优惠。感谢你，Christina。

---

### (00:45:39) Christina Cacioppo (Ads)

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### (00:45:41) Lenny Rachitsky

**English:**
Any other big counterintuitive lessons from the journey that you think would be fun to share?

**中文翻译:**
这段旅程中还有什么其他重大的反直觉教训，你觉得分享出来会很有趣吗？

---

### (00:45:45) Daniel Lereya

**English:**
One thing I really love about what we do in Monday is that we really love to take risks, not for the sake of it, but we are not afraid to do bold moves. And many times, when you want to do bold moves, you have a lot of concerns, especially when you start to be successful, because you are afraid that you are going to break everything that you built until now. And for me, one of the most pivotal moments in the company life is when we decided that, back in the days, as you said, we were a platform, but we had a go-to market of project management tool and we said, "Listen, people are doing so many different things on top of Monday. They are building a CRM of Monday and they are building a software for managing their dev cycles, and they are building so many different things," and we took a strategic decision to become a multi-product company which is built on top of this platform. And we actually did something which is really counterintuitive.

**中文翻译:**
在 Monday，我非常喜欢的一点是我们非常喜欢冒险，不是为了冒险而冒险，而是我们不害怕采取大胆的行动。很多时候，当你想要采取大胆行动时，你会有很多顾虑，尤其是当你开始成功时，因为你害怕会破坏你迄今为止建立的一切。对我来说，公司生命中最关键的时刻之一是当我们决定转型时。正如你所说，过去我们是一个平台，但我们的市场定位是项目管理工具。我们发现：“听着，人们在 Monday 之上做了这么多不同的事情。他们在 Monday 上构建 CRM，构建管理开发周期的软件，构建各种各样的东西。”于是我们做出了一个战略决策：成为一家建立在这个平台之上的“多产品”公司。我们实际上做了一些非常反直觉的事情。

---

### (00:46:46) Daniel Lereya (continued)

**English:**
(00:46:46): The first thought that comes to mind, at least for me, is, "Why maybe not just launch a new product, do it relatively on the side, gradually understand if it's successful? And if it would be successful, double click on it." But we actually did it in a very different way. We actually announced five different new products simultaneously on the same time, and we had so many... I can't stress enough how hard it is to think about it. Because I remember when we talked about and doing it, people say, "What? But we are going to confuse our current users and it's going to have conversion. And how are we going to do the marketing now when we have so many different go-to markets? And the sales, they don't know how to navigate people to different... And what about pricing?" So many different concerns, but we decided to do it because we really want to create a pivotal leap.

**中文翻译:**
(00:46:46): 至少对我来说，脑海中浮现的第一个念头是：“为什么不先发布一个新产品，在侧面尝试一下，逐渐了解它是否成功？如果成功了，再加大投入。”但我们实际上采取了完全不同的方式。我们同时宣布了五个不同的新产品。我无法强调这在思考上有多难。因为我记得当我们讨论这样做时，人们说：“什么？但这会混淆我们现有的用户，会影响转化率。当我们有这么多不同的市场定位时，我们现在该如何做营销？销售人员不知道如何引导人们去不同的产品……定价怎么办？”有这么多不同的顾虑，但我们决定这样做，因为我们真的想实现一个关键的跨越。

---

### (00:47:46) Daniel Lereya (continued)

**English:**
(00:47:46): And I think that, in that sense, fast-forward to this day, part of these products were really successful. For instance, Monday sale CRM is going faster than Monday back in the days, when it's amazing to see it, and-

**中文翻译:**
(00:47:46): 我认为从这个意义上说，快进到今天，这些产品中的一部分非常成功。例如，Monday Sales CRM 的增长速度甚至超过了当年的 Monday，看到这一点非常令人惊叹，而且——

---

### (00:48:00) Daniel Lereya (continued)

**English:**
(00:48:00): ... and some of them we understood that they don't need to be separate products and we collapse them back to the main product. But the point is, is that we managed to learn and to change both internally at the company, how the perception of everyone around what we are building, but also externally. This move changed dramatically the competitive landscape that we live in. And, I think there was a lot of friction. Many people at the company were having a lot of friction with it. It was really, really hard. But looking back it's such, I'm so happy with this move and the fact that we did it like that because just imagine what would happen if we would choose one of them and it wasn't the successful products. And our conclusion can be that multi product won't work for us.

**中文翻译:**
(00:48:00): ……其中一些产品我们后来意识到它们不需要作为独立产品存在，于是我们将它们合并回了主产品。但重点是，我们成功地在公司内部学习并改变了大家对我们所构建事物的看法，在外部也是如此。这一举动极大地改变了我们所处的竞争格局。我认为当时有很多摩擦，公司里的很多人对此感到非常抵触。这真的非常、非常困难。但回过头来看，我非常庆幸这个决定以及我们执行它的方式，因为想象一下，如果我们只选择其中一个，而它恰好不是那个成功的产品，我们的结论可能就会是“多产品策略对我们行不通”。

---

### (00:48:52) Daniel Lereya (continued)

**English:**
(00:48:52): We really managed to transform the company in a very short amount of time and also to create new reality. And I think that people need to remember that and I'm constantly reminding it to myself. And I think this is something that we are constantly working with each other in order to make sure that we remember that not taking bold risks, not making bold moves, it's a risk for itself. Okay? And many times people want the inertia, people want just the incremental value. But if you want to do leaps many times you need to let go of things that were successful for you in the past. And this is very counterintuitive and we did a lot of mental models to help us cope with it.

**中文翻译:**
(00:48:52): 我们真的在很短的时间内实现了公司的转型，并创造了新的现实。我认为人们需要记住这一点，我也在不断提醒自己。我认为这是我们不断相互配合的一点，以确保我们记住：不冒大胆的风险、不采取大胆的行动，这本身就是一种风险。明白吗？很多时候人们想要惯性，人们只想要增量价值。但如果你想实现跨越，很多时候你需要放下过去让你成功的东西。这非常反直觉，我们做了很多心理模型来帮助我们应对这一点。

---

### (00:49:38) Daniel Lereya (continued)

**English:**
(00:49:38): So I remember that when we were small and we had for instance 20,000 paying customers, so we said, "Listen, but most of Monday's customers are not customers of Monday, yet. So we need to think about them, as well." And this is something that really helps you because many times you need to do things that affect the current success that you have. But I think this is another very, very important thing that I am constantly reminding to myself.

**中文翻译:**
(00:49:38): 我记得当我们规模还小，比如只有 2 万名付费客户时，我们说：“听着，但 Monday 的大多数潜在客户还不是 Monday 的客户。所以我们也需要考虑他们。”这确实很有帮助，因为很多时候你需要做一些会影响当前成功的事情。我认为这是另一件非常、非常重要的事情，我一直在提醒自己。

---

### (00:50:07) Lenny Rachitsky

**English:**
There's kind of this other recurring theme that I'm noticing of just thinking big and taking leaps. And I love this point you made of not doing that is actually a big risk. Not taking a risk is a big risk. That's a really powerful point. And it's innately scary to do something risky. And so, I love the push here of just take more risks because it's so easy. And this comes back again to the beginning of the conversation where we're just building things the way they've always been built. And looking back and what have we even done? What have we done over this year of hard work and tons of features?

**中文翻译:**
我注意到这里有另一个反复出现的主题，就是“往大处想”和“实现跨越”。我非常喜欢你提到的那一点：不这样做实际上是一个巨大的风险。不承担风险本身就是巨大的风险。这是一个非常有力的观点。做有风险的事情天生就是可怕的。所以我很喜欢这里的推动力——去承担更多风险。这又回到了我们对话的开始：如果我们只是按部就班地构建东西，回头看时会问：“我们到底做了什么？在这一年的辛苦工作和海量功能中，我们到底成就了什么？”

---

### (00:50:39) Lenny Rachitsky (continued)

**English:**
(00:50:39): I think a lot of companies get in that place where they're just like, "What are we?" Like in our B and B, I had this exact, Brian is constant like, "What are we even shipping all these billions of experiments that are moving the numbers? What are we even doing? I don't know anything that we ship that's really exciting." And so, I think this is a really good reminder and push to just think bigger and you need to take big leaps. So, love that. Is there any other big counterintuitive lessons before we move in a different direction?

**中文翻译:**
(00:50:39): 我认为很多公司都会陷入这种境地，他们会问：“我们到底在做什么？”就像在 Airbnb，Brian Chesky 经常会说：“我们发布的这数十亿个改变数据的实验到底有什么意义？我们到底在做什么？我没看到我们发布的任何东西是真正令人兴奋的。”所以，我认为这是一个非常好的提醒和推动，去思考得更宏大，你需要实现大的跨越。太棒了。在我们转向另一个方向之前，还有什么重大的反直觉教训吗？

---

### (00:51:06) Daniel Lereya

**English:**
I really believe that many time, like spending more time on working on something will not yield to better results or to better products. And I think that many times we, as people, that are building products for others get to a point where the feedback that we want to get in the bottom of our heart is like, " Wow, what an amazing product you have built." And I think this is a very bad feedback to get for initial things that you are doing. Because it means that, I feel that in many ways, the point in which you make real people use your product is really scary. Because you suddenly put your work out there and then in order to actually, and you are afraid that they will say, "Listen, it's a lousy product, it's not a good product." But actually we really encourage people to get really fast production, to put traps for themselves that is called by time and not by effort.

**中文翻译:**
我深信，很多时候在某件事上花费更多时间并不会带来更好的结果或更好的产品。我认为很多时候，作为为他人构建产品的人，我们内心深处最想听到的反馈是：“哇，你做出了一个多么惊人的产品。”但我认为，对于你正在做的初始阶段的事情来说，这是一个非常糟糕的反馈。因为这意味着——我觉得在很多方面，让真实的人使用你的产品是非常可怕的。因为你突然把你的作品公之于众，你害怕他们会说：“听着，这是一个糟糕的产品，一点也不好。”但实际上，我们非常鼓励人们快速投入生产，为自己设置“陷阱”，这种陷阱是以“时间”而非“努力程度”来定义的。

---

### (00:52:29) Daniel Lereya (continued)

**English:**
(00:52:29): And we do it all from good reasons. We want people to like what we build, we want them to get value. But, for me, this is a very important point that many times using, like the setting traps mechanism of saying, "Listen, we have three weeks, let's think about it." And [inaudible 00:52:51] by time, it makes you extremely focused. And this is very important because we really want to get feedback from customers that say, "Yeah, listen, this is on the direction. I'm still missing this and this and this. And also we really love the fact of this is not a good product."

**中文翻译:**
(00:52:29): 我们这样做都是出于好意。我们希望人们喜欢我们构建的东西，希望他们获得价值。但对我来说，这是一个非常重要的点：很多时候使用这种“设置陷阱”的机制，比如“听着，我们只有三周时间，让我们来思考一下”。通过时间来限制，会让你变得极其专注。这非常重要，因为我们真心希望从客户那里得到反馈，他们会说：“是的，方向是对的，但我还缺这个、这个和那个。而且我们也喜欢‘这还不是一个好产品’这个事实。”

---

### (00:53:11) Daniel Lereya (continued)

**English:**
(00:53:11): And I can give you a recent example. Even when now we work with big customers and, of course, there are different ways to implement what I said than you are a small startup. But we are building a new offering of enterprise work management. Think about it like a way of managing projects. It's a huge, huge scale. Thousands of projects like tens of thousands of employees and so on. So, I really love using the deadline trap and it makes you focused, it makes you sharper in thinking. And, we just had a recent example with the offering I was telling you about of enterprise work management, managing project at scale. And this is an enterprise product. So you have all the reasons in the world to say, "No, I can't release it, yet. I need more time. I need to do more things. They won't use it. They need this and this and this."

**中文翻译:**
(00:53:11): 我可以给你举个最近的例子。即使现在我们与大客户合作，当然，实施我所说的方法与小初创公司有所不同。但我们正在构建一个新的企业级工作管理产品。把它想象成一种管理项目的方式，规模非常巨大，涉及数千个项目、数万名员工等等。我非常喜欢使用“截止日期陷阱”，它让你专注，让你的思维更敏锐。我们最近在那个企业级工作管理产品上就有个例子。这是一个企业级产品，你有一万个理由说：“不，我还不能发布。我需要更多时间。我需要做更多事情。他们不会用的，他们还需要这个、那个和那个。”

---

### (00:53:58) Daniel Lereya (continued)

**English:**
(00:53:58): And I think that we actually released the first alpha version to them. And we got a feedback of, "Listen guys, this is premature. We need more comprehensive value." But we got exactly the feedback of what, and this is priceless. And my response to the teams is, "Well done. I think you did an amazing job in releasing it and making sure." Because many times, being so afraid of releasing it and thinking, "If I just have 1, 2, 3 more weeks, I will build a better product." I think it's not true.

**中文翻译:**
(00:53:58): 但我们实际上向他们发布了第一个 Alpha 版本。我们得到的反馈是：“听着伙计们，这太不成熟了，我们需要更全面的价值。”但我们准确地得到了“需要什么”的反馈，这是无价的。我对团队的回应是：“做得好。我认为你们在发布并确保反馈方面做得非常出色。”因为很多时候，由于害怕发布而认为“如果我再多花一两三周，我就能做出更好的产品”，我认为这不是真的。

---

### (00:54:34) Lenny Rachitsky

**English:**
This such good advice. It resonates so much with recent other conversations I've had. So, just to clarify what you're saying, basically, you have a time box. When you say traps, it's basically a set amount of time. We're going to spend three weeks on this feature and if we don't hit the three weeks, we just cut scope, essentially. Is that the idea?

**中文翻译:**
这是非常好的建议。这与我最近的其他对话非常有共鸣。所以，为了澄清一下你的意思，基本上你有一个“时间盒”（Time Box）。当你提到“陷阱”时，基本上是指一段固定的时间。比如我们要在这个功能上花三周时间，如果我们没能在三周内完成，我们基本上就削减范围。是这个意思吗？

---

### (00:54:51) Daniel Lereya

**English:**
I think, yeah, it's like this is the basic version of it. But now, for us, we really want and we really love doing it as an exercise for ourself. For instance, let's say, now as a public company we say, "Listen, we're working on something. We want to announce it on the next earning. And put a trap for ourselves." Why? Because, again, it makes you sharp. It makes you super focused about things. And I think that in many ways this results in a much better product because you are not building things that you invented. You are staying really true to what your users needs, the real core of the value.

**中文翻译:**
是的，这是它的基础版本。但现在对我们来说，我们非常喜欢把它作为一种自我练习。例如，作为一家上市公司，我们会说：“听着，我们正在做某件事，我们想在下一次财报电话会议上宣布它。让我们给自己设个陷阱。”为什么？因为，再次强调，它让你保持敏锐，让你对事情超级专注。我认为在很多方面，这会带来更好的产品，因为你不是在构建你自己臆想出来的东西，而是真正忠于用户的需求，忠于价值的核心。

---

### (00:55:32) Daniel Lereya (continued)

**English:**
(00:55:32): And, it's really funny to see the dynamics of teams when they are planning from the bottom up. So, it starts with something that like let's say you've done everything great. Okay, you have the opportunity, you understand, you have the KPIs, everything is in place, but now you're starting to plan it. And, suddenly, people are raising concerns and issues. And it becomes a sport to say what can go wrong and like being fear- driven. And then you tend to protect yourself and adding more content and more content. And then when you see what happens, it's actually, it's going to be shipped in two years.

**中文翻译:**
(00:55:32): 看到团队自下而上规划时的动态真的很有趣。假设你之前的一切都做得很好：你找到了机会，你理解了需求，你有 KPI，一切就绪，但现在你开始规划了。突然间，人们开始提出顾虑和问题。指出可能出什么问题变成了一种“运动”，大家变得由恐惧驱动。然后你倾向于保护自己，不断增加内容、增加内容。最后你发现，这个东西居然要两年后才能发布。

---

### (00:56:11) Daniel Lereya (continued)

**English:**
(00:56:11): And then we say, "Okay, no. Okay, we have earnings in two months. What can we ship to this earnings? And let's put a tab." And then you suddenly see the conversation changes. First of all, it makes everyone really focused on what's the core of the value. And it removes all the theoretical discussions that people have and things like that. And, the results are amazing. And you need to remember when you do it, you need to continue afterwards like according to feedbacks and not let it go just but what you did in the first version. But, in many ways, I really love the fact that the first version get the feedback, which is not everything is perfect because if this is the feedback, it means that we built too much and probably it's not focused product enough. And when you build a lot of features, this can be like a death by a thousand cuts because in each corner of the product you add more than you need.

**中文翻译:**
(00:56:11): 然后我们会说：“好吧，不行。两个月后我们有财报。这次财报我们能发布什么？让我们设个限。”然后你会突然看到对话发生了变化。首先，它让每个人都真正专注于价值的核心。它消除了人们所有的理论讨论之类的东西。结果是惊人的。你需要记住，当你这样做时，你之后需要根据反馈继续迭代，而不仅仅是停留在第一个版本。但在很多方面，我非常喜欢第一个版本得到的反馈不是“一切都很完美”，因为如果反馈是完美的，那就意味着我们构建了太多东西，产品可能不够聚焦。当你构建大量功能时，这可能会导致“千刀万剐”式的失败，因为在产品的每个角落，你都添加了超出需求的东西。

---

### (00:57:08) Lenny Rachitsky

**English:**
Yeah, there's so much here that connects the other conversation we just had. We had Gaurav Misra, he's the CEO of Captions and he made this point that if people aren't complaining about your product, you want to see people complaining because that means they care. There's something there that they care about. If you're not hearing any complaints, they could care less about what you're building and that's a bad sign.

**中文翻译:**
是的，这里有很多内容与我之前的另一场对话相呼应。Captions 的 CEO Gaurav Misra 曾提出一个观点：如果人们不抱怨你的产品，那才是问题；你应该希望看到人们抱怨，因为那意味着他们在乎。那里有他们在乎的东西。如果你听不到任何抱怨，说明他们根本不在乎你构建的东西，那是一个糟糕的信号。

---

### (00:57:27) Daniel Lereya

**English:**
I really loved it. Yeah.

**中文翻译:**
我非常喜欢这个观点。是的。

---

### (00:57:29) Lenny Rachitsky

**English:**
Their company actually goes to the extreme of what you're describing. Every engineer ships a marketable feature every week. That's their pace.

**中文翻译:**
他们的公司实际上把你描述的情况做到了极致。每个工程师每周都会发布一个可销售的功能。那是他们的节奏。

---

### (00:57:38) Daniel Lereya

**English:**
I really connected to it. And by the way, about user feedback, I think it's really nice because many times people associate, like they only measure themselves by user feedback and a specific point. And I think this is also maybe something that is counterintuitive. Not every customer feedback is the feedback that will drive you to the end result of the best product out there. There are many aspects to it. I can share just one example about us. We, as a, in the beginning of the company, we, for instance, didn't want to have a free trial. And part of it is that we really wanted to hear feedback about our product only from people that the product means something to them. The best proxy for that is that they are paying because it means they get real value. And you know, in that sense it helped us at the beginning to stay super focused about separating the wheat from the shaft with the customer's feedback. So I think it's a super important point and we need to take customer feedback in context.

**中文翻译:**
我非常有共鸣。顺便说一下，关于用户反馈，我觉得很有意思，因为很多时候人们只在特定点通过用户反馈来衡量自己。我认为这可能也是反直觉的一点：并非所有的客户反馈都能引导你做出最好的产品。这涉及很多方面。我可以举一个我们的例子。在公司成立初期，我们不想提供免费试用。部分原因是我们真的只想听取那些对产品有真正需求的人的反馈。最好的代理指标就是他们愿意付费，因为这意味着他们获得了真正的价值。你知道，从这个意义上说，它在初期帮助我们保持超级专注，从客户反馈中去粗取精。所以我认为这是一个非常重要的点，我们需要结合上下文来看待客户反馈。

---

### (00:58:51) Lenny Rachitsky

**English:**
The other really interesting point here that you're making is this idea of, we had, I think I mentioned this already, Ryan Singer, he's the creator of this method, Shape Up, which is very centered around appetites over deadlines. There's so many, everyone listening to this has probably gone through an exercise where like, "Let's redo our landing page." And it's like, "Yeah, it'll probably have some impact. Let's spend some time on this." It ends up taking six months. And everyone's like, "Why did we spend six months redoing this freaking landing page? I would've given it three weeks and then moved on." And the way to do that is you just commit upfront, "We will spend three weeks on this. We'll get as much done as we can in three weeks and then we'll move on." People talk about this very hard to actually do so I love that's how you actually approach some of these bigger features you work on. Do you guys practice Shape Up by any chance or this is just a thing you do?

**中文翻译:**
你提到的另一个非常有趣的观点是——我想我已经提过 Ryan Singer 了，他是 Shape Up 方法的创始人，该方法的核心是“胃口”（Appetite）优于“截止日期”。听这个播客的每个人可能都经历过这样的练习，比如“让我们重新设计落地页”。大家会说：“是的，这可能会产生一些影响，让我们花点时间做这个。”结果花了六个月。然后每个人都问：“为什么我们要花六个月重新设计这个该死的落地页？我本来只想给它三周时间，然后就继续做别的。”做到这一点的方法是你预先承诺：“我们将在这个项目上花三周时间。三周内能做多少就做多少，然后我们就结束。”人们常说这很难真正做到，所以我很喜欢你处理大功能的方式。你们是在实践 Shape Up 吗，还是这只是你们自己的做法？

---

### (00:59:38) Daniel Lereya

**English:**
No, actually, I wasn't that familiar with it, but I definitely going to check it out. Yeah.

**中文翻译:**
不，实际上我对它不太熟悉，但我肯定会去了解一下。是的。

---

### (00:59:42) Lenny Rachitsky

**English:**
Okay, cool. Yeah, it's a whole method. And I think the episode right before this is actually that episode. Okay. Let me go in a different direction and kind of keep extracting lessons from this journey because that was a really fruitful place to go. So let me ask you this question. What's one thing that you wish you'd known before stepping into the role that you're in today?

**中文翻译:**
好的，酷。是的，这是一套完整的方法。我想这集之前的上一集正好就是关于那个的。好，让我换个方向，继续从这段旅程中提取教训，因为刚才的讨论非常有收获。让我问你这个问题：在你担任今天的角色之前，有什么是你希望自己早点知道的？

---

### (01:00:00) Daniel Lereya

**English:**
This is an interesting question. I think there are many aspects to it and maybe if I'll take the personal aspects. So I've been in charge of the product and technology from since I joined the company. But with that, my role has changed, I think, dozens of times. I feel I'm very fortunate to work in one company but actually work in dozens of different companies. Think about the scale that we talked about. Each point is a different, it's actually a different company and a different role and a different challenge. And I think that something that maybe is counterintuitive personally, for me, was that in many of the phases that we undergrowed with, I felt that what got me to this phase is not necessarily what's going to make me successful in the next phase.

**中文翻译:**
这是一个有趣的问题。我认为它有很多方面，也许我可以从个人层面来谈。自从加入公司以来，我一直负责产品和技术。但随之而来的是，我的角色已经改变了，我想，有几十次了。我觉得自己非常幸运，虽然在一家公司工作，但实际上经历了数十家不同的公司。想想我们谈到的规模，每一个节点都是一家不同的公司，一个不同的角色，一个不同的挑战。我认为对我个人来说，有些反直觉的事情是：在我们经历的许多阶段中，我感觉到，让我达到当前阶段的因素，并不一定是让我在下一阶段成功的因素。

---

### (01:00:55) Daniel Lereya (continued)

**English:**
(01:00:55): And if I want to be even more blunt, there will personally times when suddenly I saw how my biggest strength, for instance like, mastering all the details and having everything in my head knowing exactly what's happening on every corner of what we do. This was probably something that gave a lot of value when we were small. But, as we got bigger, I think it suddenly created even the damage continuing to do the same thing. And in many ways, it takes time to do this realization. And I think that a good advice that I would love to have is that don't be afraid again to let go of things that you think are superpowers.

**中文翻译:**
(01:00:55): 如果我想说得更直白一点，我个人曾经历过这样的时刻：我突然发现我最大的优势——比如，掌控所有细节，脑子里装着一切，确切知道我们工作的每个角落发生了什么——这在我们规模还小时可能非常有价值。但随着我们变大，我认为继续这样做反而突然造成了损害。在很多方面，意识到这一点需要时间。我认为我希望得到的一个好建议是：不要害怕放下那些你认为是“超能力”的东西。

---

### (01:01:47) Daniel Lereya (continued)

**English:**
(01:01:47): Many times your superpowers that brought you to this point and made you successful, many times you think that if you let it go you won't be successful and it's frightening. But, I really feel that you need to constantly evaluate what your current role is actually, is actually what is the role? And what is needed in order to be successful in it and not continue with the inertia? And this is something that I wish someone has told me. Yeah. It took me time in many cases, you know? Many cases I did it too late.

**中文翻译:**
(01:01:47): 很多时候，那些带你走到今天并让你成功的超能力，会让你觉得如果放手了你就不会成功，这很可怕。但我真的觉得，你需要不断评估你当前的角色到底是什么？为了在这个角色中取得成功需要什么，而不是继续保持惯性？这是我希望有人能告诉我的。是的，在很多情况下我花了不少时间才明白，你知道吗？很多时候我明白得太晚了。

---

### (01:02:21) Lenny Rachitsky

**English:**
Is there anything that helped you realize this or get good at this? Is it like coaching? Is it just doing it and surviving and failing and be like, "Oh, I see."

**中文翻译:**
有什么东西帮助你意识到这一点或擅长于此吗？是教练指导吗？还是仅仅通过实践、生存和失败，然后感叹“哦，我明白了”？

---

### (01:02:29) Daniel Lereya

**English:**
I think all of the above. I think that one sign for that, for me, was that in many cases I felt I'm doing a very good job. But then people, it can be like, I'll give you an example. Okay? For instance, doing a company like Leadership QBRs. Okay, quarterly business reviews. So, when we just started it with it very early, I would actually tell about everything. And I remember one meeting that I went out of the meeting and I say, "Wow, I really managed to convey everything and explain everything in a very articulated way." And one of my colleagues in the core leadership team said, "Well, I didn't understand anything. What is the bottom line of all of this?"

**中文翻译:**
我想以上皆有。对我来说，一个迹象是：在很多情况下，我觉得自己做得非常好。但随后人们——我可以给你举个例子。比如，做领导层的 QBR（季度业务回顾）。当我们很早就开始做这个时，我会讲述一切细节。我记得有一次会议，我走出会场时想：“哇，我真的成功传达了一切，并以非常清晰的方式解释了一切。”结果核心领导团队的一位同事说：“额，我什么也没听懂。这一切的底线（结论）到底是什么？”

---

### (01:03:43) Daniel Lereya (continued)

**English:**
(01:03:43): And it was like you suddenly realize that what you thought is good is not necessarily what the other people needs from you at this point. And after understanding that, I went and ask, "What would be beneficial for you?" He said, "Listen, I want to keep in my head the three most meaningful things that you are currently facing with. I don't want to hear everything." And it's hard. But, this was the point for me that I realized that I need to change. And I need to change something and the requirements are different. At the beginning I tried to say, "But, listen, it's important that you know you are sticking to it." Right? But we need to let it go sometimes and think from the beginning.

**中文翻译:**
(01:03:43): 就像你突然意识到，你认为好的东西，并不一定是别人此时此刻需要你提供的。在理解了这一点后，我去问：“对你来说什么是有益的？”他说：“听着，我只想在脑子里记住你目前面临的三件最有意义的事情。我不想听所有的细节。”这很难。但那一刻我意识到我需要改变，要求已经不同了。起初我还想辩解：“但是，听着，让你知道这些很重要……”对吧？但有时我们需要放手，从头开始思考。

---

### (01:04:22) Lenny Rachitsky

**English:**
There's this phrase that someone shared on this podcast once where, as you rise in your career, you often go from the person that is pitching leaders on something to the person being pitched. And that's a really weird place to move from, having to learn how to give great feedback, delegate, let go of things. And I love that this is a good example of that. Since we're getting a little vulnerable and open about stuff, I want to try this question. You've done a lot of podcasts, you've done a lot of interviews, you've been all over the place. Is there anything you haven't shared anywhere else that might be helpful to share here about the journey you've been on?

**中文翻译:**
曾有人在这个播客上分享过一句话：随着职业生涯的晋升，你经常会从那个向领导推销（pitch）想法的人，变成那个被推销的人。这是一个非常奇妙的转变，你必须学习如何给出极好的反馈、如何授权、如何放手。我喜欢这个例子。既然我们开始聊到一些感性和开放的话题，我想尝试这个问题：你参加过很多播客，做过很多采访，去过很多地方。关于你所经历的这段旅程，有什么是你从未在其他地方分享过、但在这里分享可能会有帮助的吗？

---

### (01:04:58) Daniel Lereya

**English:**
Yeah, so, maybe continuing with the same point. It's a crazy journey and it's a crazy personal journey. If you think about it, I remember Roy once said, "If someone would've interviewed me to a public company of, like I would say $10 billion in market cap and managing 2,500 employees, I'm not sure that I would interview myself and get myself to the job." And, for me, there were a lot of moments and it's constantly happening. You know, when things are going sideways and things doesn't work, and you see so many things are breaking down. You can be on the same day super happy and suddenly on the lowest point there is.

**中文翻译:**
是的，也许可以接着刚才那点说。这是一段疯狂的旅程，也是一段疯狂的个人旅程。想想看，我记得 Roy 曾经说过：“如果有人面试我去管理一家市值 100 亿美元、拥有 2500 名员工的上市公司，我不确定我是否会面试通过并得到这份工作。”对我来说，有很多这样的时刻，而且一直在发生。你知道，当事情进展不顺、行不通，你看到这么多东西在崩溃时。你可能在同一天里感到超级开心，然后突然跌入谷底。

---

### (01:05:49) Daniel Lereya (continued)

**English:**
(01:05:49): And I can show you, no. Many times I've asked myself whether I'm the right person to lead it, whether we need someone that is coming with all the experience to this phase. And I remember talked to that day with Ron. He tell me, he told me something, "Listen, first of all, as the one who built it, no one would be able to do it like you." And I think it's an important thing to remember when times are tough. I really believe that if you have the passion, and if you have the will, and if you are willing to do the hard work in order to constantly adjust and evolve and to be vulnerable and also to say about yourself, "I didn't understand something. Now, I need to learn it and I need to deal things differently."

**中文翻译:**
(01:05:49): 我可以告诉你，很多次我都在问自己，我是否是领导它的合适人选，我们是否需要一个在这个阶段拥有丰富经验的人。我记得那天和 Ron 谈过，他告诉我一件事：“听着，首先，作为构建它的人，没有人能像你一样做到这一点。”我认为在困难时期记住这一点很重要。我深信，如果你有激情，有意志，并且愿意为了不断调整和进化而付出艰辛努力，愿意展现脆弱，并对自己说“我不懂某些东西，现在我需要学习它，我需要换种方式处理事情”。

---

### (01:06:44) Daniel Lereya (continued)

**English:**
(01:06:44): It's a very important point if you want to do this kind of a journey. And it's hard. And something I can share, I can reassure everyone that are listening to us, if you are feeling it, you are not the only one. Everyone are feeling it from once in a while. Be confident about yourself. Be vulnerable in order to learn and to evolve. And I really love to do a mental exercise of saying, like we said about the product. So, let's say I'm Daniel of next six months. How do I want to look back on these six months? And what do I want to say about myself that I learned that I evolved? And this helped you get out from the state of everything is okay, I am good. And it makes you want to learn and want to evolve.

**中文翻译:**
(01:06:44): 如果你想开启这样的旅程，这一点非常重要。这很难。我可以分享的是，我可以向所有正在听我们说话的人保证，如果你有这种感觉，你不是唯一的一个。每个人都会偶尔有这种感觉。要对自己有信心。要展现脆弱，以便学习和进化。我非常喜欢做一个心理练习，就像我们谈论产品一样。比如，假设我是六个月后的 Daniel。我希望如何回顾这六个月？我希望对自己说我学到了什么、进化了什么？这能帮助你摆脱“一切都好，我很棒”的现状，让你渴望学习和进化。

---

### (01:07:37) Daniel Lereya (continued)

**English:**
(01:07:37): And also staying doing mode. I don't believe in, I think one thing that really characterized me is that it can be very difficult and very challenging time. But on the next day, I'm already bouncing back with energy. And in order to come and do things and win it. And there are a lot of things that we, as leaders, needs to do in order to help ourselves to keep this mental state. So, I like to run. I like to do things that are unrelated to work in order to get back to my center. But then quickly bounce back and to really believe in myself, in the team around me. So this, yeah, this is something maybe very personal, but I am pretty sure I'm not the only one feeling it.

**中文翻译:**
(01:07:37): 还要保持“行动模式”。我不相信停滞不前。我认为我的一个特点是，即使是非常困难和具有挑战性的时期，第二天我也能充满能量地反弹回来，去处理事情并赢得胜利。作为领导者，我们需要做很多事情来帮助自己保持这种心态。比如，我喜欢跑步，喜欢做一些与工作无关的事情来找回自我中心。然后迅速反弹，真正相信自己，相信周围的团队。所以，是的，这可能非常私人，但我很确定我不是唯一一个有这种感觉的人。

---

### (01:08:37) Lenny Rachitsky

**English:**
I appreciate you sharing that. There's a post that I did a long time ago with a coach and it was about imposter syndrome. And she made this really powerful point that you are actually an imposter in the role you're in. You've never done this before. Most people are imposters in their role. They've never been a chief product officer. In a lot of cases they've never led teams this large. And first of all just realize that you actually are. And second of all, that's okay and most people are like you said. And then third of all, this advice you shared about how to work through that is really powerful. Just like know many people feel this way. Work hard, I think, is a really important part of this. Just like know there's another day and that you can bounce back.

**中文翻译:**
我很感谢你分享这些。很久以前我和一位教练写过一篇关于“冒充者综合征”（Imposter Syndrome）的文章。她提出了一个非常有力的观点：在你所处的角色中，你其实确实是个“冒充者”，因为你以前从未做过这件事。大多数人在他们的角色中都是冒充者。他们从未当过首席产品官，在很多情况下也从未领导过这么大的团队。首先，要意识到你确实是第一次。其次，这没关系，大多数人都像你说的这样。第三，你分享的关于如何克服这一点的建议非常有力：只要知道很多人都有这种感觉。我认为努力工作是其中非常重要的一部分。只要知道还有明天，你可以反弹回来。

---

### (01:09:21) Daniel Lereya

**English:**
Remember that everyone are people. No one is born to be in the world that he's currently at. And another thing that in Monday we're scaling so fast. So even people that are coming with experience and I had the chance to see it over and over again, because we're going so fast, each one of us will get to a point, which is the first time he's doing it sooner or later. So, experience matters and we have a lot of people that are coming and bringing experience from the outside. But also remember that and remember that everyone are people and no one was born in a position.

**中文翻译:**
记住，每个人都是普通人。没有人天生就注定处于他现在的地位。另一件事是，在 Monday 我们扩展得太快了。所以即使是带着经验来的人（我有机会一次又一次地看到这一点），因为我们跑得太快，我们每个人迟早都会遇到“第一次做某事”的时刻。所以，经验固然重要，我们也确实有很多从外部带来经验的人，但也要记住，每个人都是普通人，没有人是天生就坐在某个位置上的。

---

### (01:10:02) Lenny Rachitsky

**English:**
Yeah. And in companies like yours, people have described it as every six months you have a new job.

**中文翻译:**
是的。在像你们这样的公司里，人们形容为每六个月你就换了一份新工作。

---

### (01:10:09) Daniel Lereya

**English:**
Exactly. Exactly.

**中文翻译:**
没错，完全正确。

---

### (01:10:11) Lenny Rachitsky

**English:**
Cheryl Sandberg once did a talk that I was at where people are complaining. It was just like, "So much is changing, we're growing. The culture is not as strong as it was, and there's just like things not working. Our processes are no, hiring is hard." And she's just like, "This is the problems you want because you're growing very fast and that's very good. Versus, if you were not growing, it'd be much more painful and hard. So, be thankful this is the problems you're facing."

**中文翻译:**
谢丽尔·桑德伯格（Sheryl Sandberg）曾经做过一次演讲，当时我也在场，大家都在抱怨。比如，“变化太快了，我们在增长。文化不像以前那么强了，有些东西就是行不通。我们的流程跟不上，招聘很难。”她就说：“这些正是你想要的问题，因为这意味着你增长得非常快，这非常好。反之，如果你不增长，那会痛苦和艰难得多。所以，要庆幸你面临的是这些问题。”

---

### (01:10:39) Daniel Lereya

**English:**
I couldn't agree more.

**中文翻译:**
我再同意不过了。

---

### (01:10:42) Lenny Rachitsky

**English:**
You talked about things breaking along the way and things you had to deal with. Is there an example of something? I love these stories of just maybe a moment of crisis along the journey where you thought like, "Okay, things are going to fall apart. This is over. See you, everyone."

**中文翻译:**
你谈到了旅途中出现的问题以及你必须处理的事情。有没有什么例子？我喜欢这些故事，也许是旅途中的某个危机时刻，让你觉得“好吧，一切都要完蛋了，结束了，大家再见吧”。

---

### (01:10:54) Daniel Lereya

**English:**
Yeah. To be honest, we have so many. But, again, this is the problems that you are lucky to have. But, yeah, maybe I'll give you an example. I remember this day that someone from our customer success team has approached me and say, "Listen, Daniel, we have a spike in performance issues in the board." And again, our boards is this table of think about it like of data. And on each time we add new functionality and we make the platform more mature, people are taking it to the extreme. So, if you look back eight years ago, so this kind of tables usually had like, let's say, five columns and 100 rows. And if you look about it today, it's like hundreds of columns, tens of thousands of rows.

**中文翻译:**
说实话，我们有很多这样的时刻。但再次强调，这些是你很幸运能拥有的问题。不过，我可以给你举个例子。我记得有一天，客户成功团队的人找到我说：“听着，Daniel，我们的看板出现了性能问题的激增。”再次说明，我们的看板就像是一个数据表。每当我们增加新功能、让平台更成熟时，人们就会把它用到极致。如果你回看八年前，这种表通常只有 5 列和 100 行。但如果你看今天，它有数百列和数万行。

---

### (01:11:45) Daniel Lereya (continued)

**English:**
(01:11:45): And so, performance is always a challenge and struggle in making sure that everything works smoothly. And this is also a value to us. We really believe that performance is the number one feature that makes people use your system. So, we came to me-

**中文翻译:**
(01:11:45): 因此，性能始终是一个挑战，我们需要努力确保一切运行顺畅。这对我们来说也是一种价值。我们深信性能是让人们使用你系统的头号功能。所以，他来找我——

---

### (01:12:00) Daniel Lereya (continued)

**English:**
(01:12:00): System. He came to me, and I remember that suddenly seeing the spike in the tickets, it's super hard, right? You say, wow, it's something super hard. You don't necessarily have a magic wand of fixing it immediately. And what we did, we actually, again, connected everyone to it. The first thing they did was taking disc golf to everyone in the team and showing and thinking together what we can do. And we did a lot of things and we worked really hard and we managed to make this situation better. And then time passed by and you are continuing, and then it happened again. And I can share that on the third time I said, "Okay, we had enough. We need to think totally different in a different way."

**中文翻译:**
(01:12:00): 他来找我，我记得突然看到工单激增，这非常难受，对吧？你会觉得，哇，这太难了。你并不一定有立即修复它的魔杖。我们所做的实际上是再次让每个人都参与进来。他们做的第一件事就是把这个问题展示给团队里的每个人，共同思考我们能做什么。我们做了很多事情，工作非常努力，成功改善了局面。但随着时间推移，你继续前进，然后它又发生了。我可以分享的是，到第三次时我说：“好吧，我们受够了。我们需要用完全不同的方式来思考。”

---

### (01:13:19) Daniel Lereya (continued)

**English:**
(01:13:19): And back in the days, this is where I think many of our core long-term projects have born. The signature one would be MondayDB. It's a name we use for an underlying data infrastructure that we've been building in the last three years or so. Think about a very small team and a very small startup. I remember the day that we said, listen, we need few of our most talented people that are now not going to contribute features anymore. We are putting them on a separate place, and let's think and solve this problem while thinking about 100X.

**中文翻译:**
(01:13:19): 在那时候，我认为我们的许多核心长期项目诞生了。最具代表性的就是 MondayDB。这是我们过去三年左右一直在构建的底层数据基础设施的名称。想象一下一个非常小的团队和一家非常小的初创公司。我记得那天我们说，听着，我们需要几个最顶尖的人才，他们从现在起不再负责开发新功能了。我们要把他们抽调出来，让他们在思考 100 倍增长的同时，思考并解决这个问题。

---

### (01:14:27) Daniel Lereya (continued)

**English:**
(01:14:27): And it really, in many ways, so different from what we talked about in so many other of the examples, right? And I think now we said, listen, instead of being fixing an issue, we want this to be our competitive edge. We have a very unique product architecture where everyone can build their own schemas of the table. And it's a crazy thing in terms of technology behind it. We want to do something that will not only solve the problem, but also will serve us as a competitive edge. And we took a huge risk because we took a lot of people and put them aside for that, or not a lot of people, but the very talented people.

**中文翻译:**
(01:14:27): 在很多方面，这与我们之前谈到的许多例子都非常不同，对吧？我想我们当时说，听着，与其只是修复一个问题，我们希望这成为我们的竞争优势。我们有一个非常独特的产品架构，每个人都可以构建自己的表格模式（Schema）。从背后的技术角度来看，这简直是件疯狂的事情。我们想做一些不仅能解决问题，还能作为我们竞争优势的事情。我们承担了巨大的风险，因为我们抽调了很多人（或者说虽然人不多，但都是最顶尖的人才）专门去做这件事。

---

### (01:15:39) Lenny Rachitsky

**English:**
There's a couple other stories of crisis I'm thinking back to, and they all seem to be a database started reaching capacity and we are about to fall apart 'cause their growth was too fast. That's an interesting lesson for people to hear, just try to anticipate this a little more. And sounds like that's what you realized is let's think a 100X from now, not just a couple years from now. It reminds me of, so Brian Johnson, he's this dude that's trying to live forever or as long as he can and he makes this really interesting point that I promise connects to what you're talking about, which is he's like, okay, what is your goal? He asked everyone, what's your life goal? And so they're like, oh, I want to do this and this and that. To accomplish that, the base goal you're not even thinking about is you need to not die. And that's actually the number one goal everyone should have, don't die. And I feel like that's infrastructure in companies is you have all these metrics and goals, but really the goal underneath that is your infrastructure needs to scale. It makes sense why this is outside of, okay, we have all these metrics and goals, this is-

**中文翻译:**
我回想起其他几个危机故事，似乎都是数据库开始达到容量极限，因为增长太快，系统快要崩溃了。这对听众来说是一个有趣的教训：试着多预见一点。听起来你意识到的正是：让我们思考 100 倍后的情况，而不仅仅是几年后的情况。这让我想起 Brian Johnson（那个试图长生不老的人），他提出了一个非常有趣的观点，我保证这与你所说的有关。他问每个人：“你的生活目标是什么？”大家会说：“哦，我想做这个、那个。”他说，要实现这些，你甚至没想到的基础目标是“别死”。这实际上是每个人都应该有的头号目标：别死。我觉得公司的基础设施也是如此：你有一大堆指标和目标，但底层的真正目标是你的基础设施需要能够扩展。这解释了为什么这超出了“我们有一堆指标和目标”的范畴，这是——

---

### (01:16:39) Daniel Lereya

**English:**
Yeah. Not necessarily treating it as a tax or as a risk, but rather for our offering as a platform, this is actually now one of our core advantages. It's super important as well, that value to customers comes in different ways, shapes and forms. And you need to think about the experience and not only about... And many times the general experience start with things that are reliable, performant, that you can count on them and suddenly you even use them differently because they're fast. I think this is another important aspect to it.

**中文翻译:**
是的。不要把它仅仅看作一种“税收”或风险，相反，对于我们作为一个平台的产品来说，这实际上现在成了我们的核心优势之一。同样非常重要的一点是，给客户带来的价值有不同的方式和形式。你需要考虑体验，而不仅仅是……很多时候，整体体验始于可靠、高性能、值得信赖的东西，突然之间，你甚至会因为它们运行飞快而以不同的方式使用它们。我认为这是另一个重要的方面。

---

### (01:17:16) Lenny Rachitsky

**English:**
That's such a good point. When you have a problem, something that's slowing you down or might crumble the company, just not flipping it from how do we just put the bandaid here? How do we turn this into a strategic advantage if we really invest the time? I like that a lot. Okay. To start to close out our conversation, I'm going to take us to AI Corner, which is a recurring segment I try to get to more and more with this podcast. And the question is, what's an example of you using AI tools in your day-to-day work to do better work, to do faster work that you think might be helpful to other folks?

**中文翻译:**
说得太好了。当你遇到问题，某些东西拖慢了你的速度或可能让公司崩溃时，不要只是想“我们怎么打个补丁？”而是想“如果我们真的投入时间，如何把它转化为战略优势？”我很喜欢这一点。好，在结束我们的对话之前，我带大家进入“AI 角落”，这是我尝试在播客中越来越多加入的固定环节。问题是：你能举一个你在日常工作中利用 AI 工具来做得更好、更快的例子吗？你认为这可能对其他人有帮助。

---

### (01:17:50) Daniel Lereya

**English:**
Maybe I start with a personal one. It's not about work, but I think it really shows that for me, it was a moment of really saying this has so much potential in it. I actually prepared myself for a marathon and unfortunately I got injured in my knee. Yeah. I went to do an MRI scan and I finished the scan and they gave me this disc with the results and then they said, "Listen, you need to schedule a doctor appointment five days from now." Okay. I said, I took it, put it in ChatGPT and ask for the results, an explanation of line by line, what does it mean. And then I of course went to the doctor and said, these are the results. But I think for me, this is something that I was really happy about using it and it also opens my mind a lot because I think that if you think about it from the product perspective, and this is how we think about AI in Monday, the technology is amazing, you can do so much with it, but there's still the part of productizing it because every person that I talked with him about this example, with enthusiasm he said, "How did you think about putting your MRI there?"

**中文翻译:**
也许我先从一个私人的例子开始。这与工作无关，但我认为它确实展示了对我来说，那一刻我意识到这有多大的潜力。我当时正在准备马拉松，不幸的是膝盖受伤了。我去做了 MRI 扫描，扫描结束后他们给了我一张存有结果的光盘，然后说：“听着，你需要预约五天后的医生门诊。”好吧，我把结果拿出来，放进 ChatGPT，让它逐行解释这些结果是什么意思。当然，后来我还是去了医生那里，医生也确认了结果。但对我来说，我很高兴能这样使用它，这也极大地开阔了我的思维。因为如果你从产品的角度思考（这也是我们在 Monday 思考 AI 的方式），技术是惊人的，你可以用它做很多事，但仍然存在“产品化”的部分。因为每一个我满怀热情聊起这个例子的人都会问：“你是怎么想到把 MRI 结果放进去的？”

---

### (01:19:15) Daniel Lereya (continued)

**English:**
(01:19:15): And I said, "I don't know, I just did." But this is all creating products that actually allow people to leverage this technology. And more on the work side, I use it a lot. I think for me, one recent example I would say is we really worked hard towards determining the pricing for AI offering that I was mentioning earlier. And just in two hours I managed to get the full perspective on what everyone else are doing. And we have analysts and we have product managers, but the fact that I was independent and managed to get the initial thoughts and all the information in just a bit, it was mind-blowing. I use it a lot in order to understand things that are very extensive, what the competitors are doing, what is the history of this and that. And I think it helped me a lot in that sense.

**中文翻译:**
(01:19:15): 我说：“我不知道，我就是这么做了。”但这就是创造那些真正让人们能够利用这项技术的产品。在工作方面，我也经常使用它。我想最近的一个例子是，我们为了确定我之前提到的 AI 产品的定价付出了很多努力。仅仅花了两个小时，我就掌握了其他所有人都在做什么的全面视角。虽然我们有分析师和产品经理，但事实上，我能够独立地在短时间内获得初步想法和所有信息，这太令人震撼了。我经常用它来理解非常广泛的事物，比如竞争对手在做什么，某件事的历史背景等等。我认为在这方面它对我帮助很大。

---

### (01:20:16) Lenny Rachitsky

**English:**
These are awesome examples. And is this all ChatGPT?Is that the tool of choice?

**中文翻译:**
这些例子太棒了。这些都是用 ChatGPT 吗？它是你的首选工具吗？

---

### (01:20:22) Daniel Lereya

**English:**
It's hard. I have my own periods right now, it's changing from one week to another. These two actually were with ChatGPT. Yeah.

**中文翻译:**
很难说。我现在有自己的周期，每周都在变。这两个例子确实是用 ChatGPT 完成的。

---

### (01:20:32) Lenny Rachitsky

**English:**
Very cool. The first example, my wife does all the time, my mother-in was in the hospital and we're waiting for the doctor to show up and she just put the chart in ChatGPT and is like, what's the problem? And it's exactly what he told us. And it feels like we're in a world now where an engineer without, say Cursor or one of these tools, that's not possible anymore. And it feels now with going to doctors, it's like if you don't do this and see what it says, you're missing out on a big gap. There's this New York Times story, I don't know if you've seen where they actually compared a doctor's analysis versus a doctor plus ChatGPT plus just ChatGPT. And guess what was the best, most accurate diagnosis?

**中文翻译:**
非常酷。第一个例子，我妻子经常这么做。我岳母住院时，我们在等医生出现，她就把病历放进 ChatGPT 问：“问题是什么？”结果它说的和医生告诉我们的一模一样。感觉我们现在处在一个这样的世界：一个工程师如果没有 Cursor 或类似的工具，简直无法工作。现在看医生也是一样，如果你不这样做看看它怎么说，你就错过了一个巨大的信息差。《纽约时报》有个报道，不知道你有没有看过，他们对比了医生的分析、医生加 ChatGPT，以及纯 ChatGPT。猜猜哪个是最好、最准确的诊断？

---

### (01:21:17) Daniel Lereya

**English:**
Yeah, I want to say ChatGPT.

**中文翻译:**
是的，我想说是 ChatGPT。

---

### (01:21:21) Lenny Rachitsky

**English:**
That's exactly what it was. Not even a doctor with ChatGPT.

**中文翻译:**
没错，就是它。甚至不是“医生加 ChatGPT”。

---

### (01:21:25) Daniel Lereya

**English:**
I'll tell you a story about it. In the MRI, I did it because I wanted to go skiing and I didn't know if I can do it or not. I asked ChatGPT and he said all the recommendations and what I need to do and so on. And then when I was at the doctor, I asked him the same question, can I do ski? He said, "I don't know, I never ski." It's not only about getting the information straight away and getting accuracy, it's the fact that you can continue and deep dive with it. And this is something that also when I was in the pricing, it's not only the bit of information, but the fact that you can continue and continue and continue. It's definitely super impressive

**中文翻译:**
我给你讲个关于它的故事。关于 MRI，我之所以做是因为我想去滑雪，但我不知道能不能去。我问了 ChatGPT，它给出了所有的建议和我需要做的事情等等。然后当我在医生那里时，我问了同样的问题：“我能滑雪吗？”医生说：“我不知道，我从不滑雪。”这不仅仅是立即获得信息和准确性的问题，而是你可以继续与它深入探讨。就像我在做定价调研时一样，不仅是那一点信息，而是你可以不断地追问下去。这绝对令人印象深刻。

---

### (01:22:06) Lenny Rachitsky

**English:**
And it doesn't get annoyed, it doesn't get bored and it's very supportive. Yeah,

**中文翻译:**
而且它不会烦，不会无聊，还非常支持你。是的。

---

### (01:22:08) Daniel Lereya

**English:**
Yeah. It's always with good intent, or not, but yeah.

**中文翻译:**
是的。它总是带着善意（或者看起来是），确实如此。

---

### (01:22:12) Lenny Rachitsky

**English:**
So kind. Amazing. Okay. Well Daniel, we've covered a lot of ground. This was extremely fun. Before we get to a very exciting lightning round, is there anything else that you wanted to share? Any other nuggets of wisdom you want to leave listeners with?

**中文翻译:**
太友善了。太棒了。好，Daniel，我们聊了很多内容，这非常有趣。在我们进入激动人心的闪电轮提问之前，你还有什么想分享的吗？还有什么想留给听众的智慧锦囊吗？

---

### (01:22:25) Daniel Lereya

**English:**
I think that in many ways, the things that we managed to achieve in Monday is due to the great people and culture that we have. And on early days, we used to take it for granted in a way, not the people but the culture, the fact that everyone understand, the fact that everyone are practicing it. And then you say, okay, culture is something that you can put your fingers on. But now as we scale, I really see how this is what actually drives everything forward. Maybe just to say on a personal note that a huge part of how I see my role is about the people and also about how we work together and what kind of an environment we want to build to ourselves. And we talked a lot about it during the episode, but I really feel that I can't underestimate on how meaningful it is and how grateful I am that I'm working with such talented people and doing what I love.

**中文翻译:**
我认为在很多方面，我们在 Monday 取得的成就归功于我们优秀的员工和文化。在早期，我们某种程度上认为这是理所当然的——不是指人，而是指文化，那种每个人都理解并践行它的事实。你会觉得文化是摸得着的东西。但现在随着我们的扩展，我真正看到了这才是推动一切前进的动力。也许从个人角度来说，我对自己角色的很大一部分理解是关于人，关于我们如何合作，以及我们想为自己建立什么样的环境。我们在这一集中聊了很多，但我真的觉得，我无法低估这有多么有意义，我也非常感激能与这么多才华横溢的人一起工作，做我热爱的事情。

---

### (01:23:30) Lenny Rachitsky

**English:**
That's awesome. I bet we could do a whole other episode on just culture and what you've learned. Building a culture, what the culture is like in Monday, but we got to get to our very exciting lightning round. Daniel, are you ready?

**中文翻译:**
太棒了。我敢打赌我们可以专门做一集关于文化和你所学到的东西：如何建立文化，Monday 的文化是什么样的。但我们现在必须进入激动人心的闪电轮。Daniel，准备好了吗？

---

### (01:23:41) Daniel Lereya

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### (01:23:42) Lenny Rachitsky

**English:**
All right. I've got five questions for you. First question is, what are two or three books that you find yourself recommending most to other people?

**中文翻译:**
好的。我有五个问题。第一个问题是：你最常向别人推荐的两三本书是什么？

---

### (01:23:49) Daniel Lereya

**English:**
The first one I would say is the No Rules Rules book by Netflix. Back in the days we used even the slides, but I think we took a lot of inspiration out of it. And I think that although we have different cultures, many of the things around execution, like excellent people and so on are things that I can really resonate with. And this is something that we really like to give people away after talking about our culture and so on to get inspiration also from other cultures. And another maybe on a different aspect is a book that actually Roy, our co-CEO has given to me, its name is Nonviolent Communication. And it's about effective ways of communication and understanding the people and their needs and how to communicate in a way that actually promotes an effective communication. And what I liked about this book is mainly we love to talk a lot and after we both read the book, our way of talking changed. It's very practical. I also like to give it away to our leadership and people within the team because they think it has real value in it.

**中文翻译:**
第一本我想说是 Netflix 的《不拘一格》（No Rules Rules）。以前我们甚至用过他们的幻灯片，我想我们从中获得了很多灵感。我认为虽然我们的文化不同，但关于执行力、优秀人才等很多方面都能引起我的共鸣。在谈论完我们的文化后，我们非常喜欢把这本书送给别人，让他们也从其他文化中获得灵感。另一本可能属于不同领域，是我们的联席 CEO Roy 送给我的一本书，书名是《非暴力沟通》（Nonviolent Communication）。它是关于有效的沟通方式，理解人们及其需求，以及如何以一种真正促进有效沟通的方式进行交流。我喜欢这本书的原因主要是我们都很爱说话，在我们都读了这本书后，我们交谈的方式发生了改变。它非常实用。我也喜欢把它送给我们的领导层和团队成员，因为我认为它具有真正的价值。

---

### (01:25:16) Lenny Rachitsky

**English:**
I'm trying to remember the framework of Nonviolent communication is like, I observed you speaking too much in this meeting and that made me feel like I wasn't listened to something like that, right? I forget the [inaudible 01:25:29].

**中文翻译:**
我试着回想一下非暴力沟通的框架，是不是类似：“我观察到你在这次会议中说话太多，这让我觉得我没有被倾听”，诸如此类的？我忘了具体的……

---

### (01:25:28) Daniel Lereya

**English:**
You shouldn't be judgmental. You just need to say facts and talk about how you feel and act. Yeah.

**中文翻译:**
你不应该带有评判性。你只需要陈述事实，并谈论你的感受和行为。是的。

---

### (01:25:35) Lenny Rachitsky

**English:**
And I know I'm joking about it, but it's actually really powerful. And we had Carol Robin on the podcast who created this program at Stanford called Touchy Feely, which is similar to this whole approach to talking. And by the way, I love the combination of Israeli directness and nonviolent communication. I want to see that in action.

**中文翻译:**
我知道我在开玩笑，但它实际上非常强大。我们曾邀请过 Carol Robin 参加播客，她在斯坦福创建了一个叫“Touchy Feely”的项目，与这种沟通方式非常相似。顺便说一句，我很喜欢“以色列式的直率”与“非暴力沟通”的结合。我很想看看那在实际中是如何运作的。

---

### (01:25:55) Daniel Lereya

**English:**
Yeah, definitely.

**中文翻译:**
是的，绝对值得一看。

---

### (01:25:58) Lenny Rachitsky

**English:**
Okay, next question. Do you have a favorite recent movie or TV show that you really enjoyed?

**中文翻译:**
好，下一个问题。你最近有没有特别喜欢的电影或电视剧？

---

### (01:26:04) Daniel Lereya

**English:**
To be honest, I don't watch TV so much. I get bored really fast and going back to other things. But when I do watch TV, so many times it's in order to clear my head. It's not that exciting things. Maybe a different thing that I'm doing is playing on the PlayStation with my son. FIFA just to vent out. Yeah. And in terms of series, maybe one thing that pops up is the Formula. I really liked it. Formula One, Netflix. Drive to Survive.

**中文翻译:**
老实说，我不怎么看电视。我很快就会觉得无聊，然后去干别的。但当我确实看电视时，很多时候是为了清空大脑，不是什么特别令人兴奋的东西。也许我做的另一件事是和儿子一起玩 PlayStation。玩 FIFA 来发泄一下。至于剧集，也许脑子里蹦出来的一个是《一级方程式》（Formula One），我很喜欢。Netflix 的《极速求生》（Drive to Survive）。

---

### (01:26:42) Lenny Rachitsky

**English:**
Drive to Survive, exactly. Yeah. I really loved seeing the dynamics and everything behind. It looks like something simple of driving cars, but you see that there's so much into it. It's also really interesting and opens your mind to watch.

**中文翻译:**
没错，《极速求生》。是的，我非常喜欢看背后的动态和一切。它看起来只是简单的赛车，但你会发现其中包含这么多东西。观看它也非常有趣，能开阔思维。

---

### (01:27:00) Lenny Rachitsky

**English:**
Yeah. I haven't started the new season yet. I wonder if it's great.

**中文翻译:**
是的。我还没开始看新的一季。不知道棒不棒。

---

### (01:27:02) Daniel Lereya

**English:**
Likewise. Yeah.

**中文翻译:**
我也一样。

---

### (01:27:06) Lenny Rachitsky

**English:**
Okay, next question. Do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
好，下一个问题。你最近有没有发现什么特别喜欢的、让你爱不释手的产品？

---

### (01:27:11) Daniel Lereya

**English:**
I don't want to fall into all the AI trap in terms of products. Maybe I will say something, which is not so recent, but a product that I love. I really like to take pictures. And one product that I really love is Google Photos. I think that they managed to create something which takes the technology edge, but to a place where myself as a human really can connect to it and get a lot of value for it. I'm a really heavy user of that. Yeah.

**中文翻译:**
在产品方面，我不想掉进 AI 的圈套里。也许我会说一个不是最近才发现、但我非常喜欢的产品。我很喜欢拍照，我非常喜欢的一个产品是 Google Photos。我认为他们成功地创造了一些东西，既利用了技术优势，又让作为一个普通人的我能够真正与之产生共鸣并从中获得巨大价值。我是它的重度用户。

---

### (01:27:47) Lenny Rachitsky

**English:**
Yeah. That is a magical product that I think people under appreciate.

**中文翻译:**
是的。那是一个神奇的产品，我认为人们低估了它。

---

### (01:27:51) Daniel Lereya

**English:**
Yeah.

**中文翻译:**
是的。

---

### (01:27:52) Lenny Rachitsky

**English:**
Next question. Do you have a favorite life motto that you often come back to, find useful and work your own life?

**中文翻译:**
下一个问题。你有没有什么常用的人生格言，觉得对你的工作和生活很有帮助？

---

### (01:27:58) Daniel Lereya

**English:**
Stay positive. I think being positive, seeing the good things is a huge, huge power and it's a huge driver and it allows you to give energy to the people around you and it's contagious. I really love staying positive, making sure that we keep being optimistic. And it doesn't mean that you need to let go of the problems and don't see the problems, but also think about always look forward and always think how you can take the current situation and make it better. And I learned with the way that it's really more fun and actually bring better results this way.

**中文翻译:**
保持积极。我认为保持积极、看到好的一面是一种巨大的力量，也是一种巨大的驱动力，它让你能把能量传递给周围的人，而且这种能量是会传染的。我非常喜欢保持积极，确保我们一直保持乐观。这并不意味着你需要忽视问题或看不见问题，而是要始终向前看，始终思考如何利用现状并让它变得更好。我一路上学到的是，这种方式真的更有趣，而且实际上能带来更好的结果。

---

### (01:28:44) Lenny Rachitsky

**English:**
I'm 1,000% aligned with that. Final question. I know you were in the army at one point in your life. Is there anything that you learned from that experience that helps you build better products?

**中文翻译:**
我百分之百赞同。最后一个问题。我知道你人生中曾有过一段从军经历。在那段经历中，有没有什么学到的东西能帮助你构建更好的产品？

---

### (01:28:55) Daniel Lereya

**English:**
The funny thing is that I think that like many things that I did in the Army, I was actually commanding of a very big group of people in the Army. And I think it's not about building products, but more about building teams and building this sense of purpose, sense of shared belonging. And I think that in that way many things are quite similar to, it might be counterintuitive, but many things are quite similar. And from that, many of the things of being together, although it's a hierarchical environment is something that I take with me and a lot of practical ways to lead a big organization, I would say.

**中文翻译:**
有趣的是，我在军队里做了很多事情，实际上我当时指挥着一大群人。我认为这与构建产品无关，而更多是关于建立团队，建立使命感和共同归属感。我认为在这些方面，很多事情其实是非常相似的——虽然这听起来可能有些反直觉。从中我学到了很多关于团队协作的东西，尽管那是一个等级森严的环境，但我带走了一些领导大型组织的实用方法。

---

### (01:29:46) Lenny Rachitsky

**English:**
Daniel, this was awesome. You're awesome. So much stuff that we went through. So many golden nuggets. I think that we're going to help a lot of people with building products, building teams, scaling, surviving, all these scaling challenges that keep coming up in these conversations. Two final questions. Where can folks find you online if they want to reach out, maybe talk about being more transparent, and then how can listeners be useful to you?

**中文翻译:**
Daniel，这太棒了。你太出色了。我们聊了这么多内容，有这么多金句。我想我们会帮助很多人构建产品、建立团队、扩展规模、在危机中生存，以及应对对话中不断出现的这些扩展挑战。最后两个问题：如果大家想联系你，或者想聊聊如何变得更透明，可以在哪里找到你？另外，听众可以如何帮到你？

---

### (01:30:09) Daniel Lereya

**English:**
Online, I think that two main ways is by LinkedIn, I would say. And second is podcasts. I am guessing in a lot of podcasts and I think that this is a cool way to share things, full stories and full practical examples. And in terms of listeners being useful to me, so first of all, in many ways they already are useful to me. I really love your podcast and I'm getting a lot of insights from others and this is something I really love. Many of people that probably listening were also contributing to that. Thank you for that. And I really hope with that, that this episode would also be meaningful to people and that they will take value out of it. And if they are, it would be amazing to hear about it. I remember someone that sent me a picture of his new dashboard in the office and what did he do with that. And add additional ideas of what you can do that we actually took also here on Monday. If you do something, even if it's small, let me know. It's super fun to hear and also interesting.

**中文翻译:**
在线上，我想主要有两种方式：一是 LinkedIn；二是播客。我参加了很多播客，我认为这是一种分享完整故事和实际案例的酷方式。至于听众如何帮到我，首先，在很多方面他们已经帮到我了。我非常喜欢你的播客，我从其他人那里获得了很多见解，这是我非常喜欢的。很多正在听这个播客的人可能也为此做出了贡献，谢谢你们。我真心希望这一集对大家也有意义，大家能从中获得价值。如果确实有帮助，能听到反馈就太棒了。我记得有人给我发了一张他办公室新仪表盘的照片，并告诉我他用它做了什么，还提供了一些我们可以做的额外想法，我们实际上在 Monday 也采纳了。如果你做了什么，哪怕是很小的一件事，也请告诉我。听到这些非常有趣。

---

### (01:31:24) Lenny Rachitsky

**English:**
All right. There's the call to action. If you implement some of Daniel's advice, especially put up new dashboards or monitors in your office, please send photos. Go for LinkedIn, it sounds like, is the best medium. Daniel, thank you so much for being here.

**中文翻译:**
好的，这就是行动号召。如果你采纳了 Daniel 的建议，特别是在办公室里安装了新的仪表盘或显示器，请发送照片。LinkedIn 似乎是最好的媒介。Daniel，非常感谢你能来到这里。

---

### (01:31:37) Daniel Lereya

**English:**
Thank you very much, Lenny. It was a pleasure.

**中文翻译:**
非常感谢，Lenny。这是我的荣幸。

---

### (01:31:40) Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast. com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。