# David Placek - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring David Placek, founder of Lexicon Branding.

---

### [00:00:00] David Placek

**English:**
Your brand name, nothing's going to be used more often or for longer than that name. Design will change, messaging will change, products will change, but that name is there.

**中文翻译:**
你的品牌名称，没有任何东西会比它被使用得更频繁或更持久。设计会变，信息传递会变，产品也会变，但那个名字会一直都在。

---

### [00:00:09] Lenny Rachitsky

**English:**
What's a name that you came up with that you had to fight super hard for, that the client just hated?

**中文翻译:**
有没有哪个名字是你提出来的，但你必须拼命争取，而客户起初非常讨厌它？

---

### [00:00:14] David Placek

**English:**
When we presented Sonos, it was rejected because it's not entertainment-like. We argued about that because I said, "This is outside looking in, but I don't see you as an entertainment company." Humans do like to be comfortable. Part of our job here is to help people to give the confidence going bigger and being uncomfortable.

**中文翻译:**
当我们提交 Sonos 这个名字时，它被拒绝了，因为客户觉得它不像是一个娱乐品牌。我们为此争论不休，因为我说：“这是从外部视角来看的，我不认为你们是一家娱乐公司。”人类确实喜欢舒适感。而我们工作的一部分，就是帮助人们建立信心，去追求更宏大的目标，并接受那种“不舒适感”。

---

### [00:00:32] Lenny Rachitsky

**English:**
There's a quote that I found of yours, "If your team is comfortable with the name, chances are you don't have the name yet."

**中文翻译:**
我发现你有一句名言：“如果你的团队对这个名字感到很舒服，那很可能说明你还没找到那个对的名字。”

---

### [00:00:37] David Placek

**English:**
We look for polarization. We look for tension in a team arguing about these things. Polarization is a sign of strength in the word. Most clients, they come to a naming project absolutely believing with full confidence that they're going to know it when they see it, and the truth is it almost never happens.

**中文翻译:**
我们追求的是两极分化。我们寻找团队在争论这些事情时产生的张力。两极分化是这个词具有力量的标志。大多数客户在开始命名项目时，都满怀信心地认为自己“一看到它就会知道就是它了”，但事实是，这种情况几乎从未发生过。

---

### [00:00:57] Lenny Rachitsky

**English:**
Most people listening to this are founders, a lot of PMs on product teams. Let's say they have a couple of weeks, got to come up with a name. What should they do?
(00:01:05):
Today, my guest is David Placek. David is the founder of Lexicon Branding, which pioneered the field of brand naming, and invented a few names that you may have heard of including Powerbook, Pentium, Blackberry, Swiffer, the Impossible Burger. Also, Vercel, Windsurf, CapCut, and Azure. In our conversation, David opens up about the very specific process that he and his team go through to find winning names, including a simple exercise that you can do with you and your team to help you find the right name in just a few weeks. We also talk about why a great name is worth spending your time on, why you won't know a great name when you see it, and why you need to feel uncomfortable about the name first. Also, why big team brainstorms don't ever lead to great names. The stories behind names like Pentium, and Sonos, and Vercel, and Windsurf. Also, such interesting insights about the feeling and energy of every letter of the alphabet and so much more.

**中文翻译:**
听这个节目的多半是创始人，或者是产品团队的 PM（产品经理）。假设他们只有几周时间，必须想出一个名字，他们该怎么办？
(00:01:05):
今天的嘉宾是 David Placek。David 是 Lexicon Branding 的创始人，该公司开创了品牌命名领域的先河，并发明了一些你可能听说过的名字，包括 Powerbook、Pentium（奔腾）、Blackberry（黑莓）、Swiffer、Impossible Burger（不可能汉堡）。还有 Vercel、Windsurf、CapCut（剪映海外版）和 Azure（微软云）。在我们的对话中，David 公开了他和他的团队为寻找获胜名称而经历的非常具体的流程，包括一个你可以和团队一起做的简单练习，帮助你在短短几周内找到合适的名字。我们还讨论了为什么一个好名字值得你花时间，为什么你不会在看到好名字的第一眼就认出它，以及为什么你首先需要对这个名字感到不舒服。此外，还有为什么大型团队头脑风暴永远不会产生伟大的名字。Pentium、Sonos、Vercel 和 Windsurf 等名字背后的故事。还有关于字母表中每个字母的感觉和能量的有趣见解，以及更多内容。

---

### [00:01:56] Lenny Rachitsky

**English:**
This episode is designed for anyone trying to figure out a name for their product or company, and also just for anyone that's interested in hearing the stories of how some of the most iconic names came to be. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. And if you become a paid subscriber of my newsletter, you get a year free of a bunch of amazing products including Bolt, Linear, Superhuman, Notion, Perplexity, Granola and more. Check it out at lennysnewsletter.com and click bundle. With that, I bring you David Placek.

**中文翻译:**
本期节目是为任何想要为自己的产品或公司确定名称的人准备的，也适合任何有兴趣听听那些最具标志性的名字是如何诞生的人。如果你喜欢这个播客，别忘了在你不常用的播客应用或 YouTube 上订阅和关注。如果你成为我时事通讯（newsletter）的付费订阅者，你可以免费获得一年的一系列神奇产品，包括 Bolt、Linear、Superhuman、Notion、Perplexity、Granola 等。请访问 lennysnewsletter.com 并点击 bundle 查看。下面，让我们欢迎 David Placek。

---

### [00:02:27] Lenny Rachitsky (Ad Break: WorkOS)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point, your customers will start asking for enterprise features like SAML authentication and skim provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know like Vercel, Webflow, and Loom. WorkOS also recently acquired Warrant, the fine-grain authorization service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube. This enables fast authorization checks at enormous scale while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on, skim, or user management, you should consider WorkOS. It's a drop-in replacement for Auth0 and supports up to 1 million monthly active users for free. Check it out at workos.com to learn more. That's workos.com.

**中文翻译:**
本期节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，在某个阶段，你的客户会开始要求企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让你快速且无痛地为应用添加企业级功能。他们的 API 易于理解，因此你可以快速交付并回到其他功能的开发中。今天，数百家公司已经由 WorkOS 提供支持，包括你可能知道的 Vercel、Webflow 和 Loom。WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于名为 Zanzibar 的突破性授权系统，该系统最初是为 Google 设计的，用于支持 Google Docs 和 YouTube。这使得在巨大规模下进行快速授权检查成为可能，同时保持了可以适应最复杂用例的灵活模型。如果你目前正寻求构建基于角色的访问控制（RBAC）或其他企业功能，如单点登录（SSO）、SCIM 或用户管理，你应该考虑 WorkOS。它是 Auth0 的即插即用替代方案，并免费支持多达 100 万月活跃用户。访问 workos.com 了解更多信息。

---

### [00:03:45] Lenny Rachitsky (Ad Break: Stripe)

**English:**
Last year, 1.3% of the global GDP flowed through Stripe. That's over $1.4 trillion. And driving that huge number are the millions of businesses growing more rapidly with Stripe. For industry leaders like Forbes, Atlassian, OpenAI, and Toyota, Stripe isn't just financial software. It's a powerful partner that simplifies how they move money, making it as seamless and borderless as the internet itself. For example, Hertz boosted its online payment authorization rates by 4% after migrating to Stripe. And imagine seeing a 23% lift in revenue like Forbes did just six months after switching to Stripe for subscription management. Stripe has been leveraging AI for the last decade to make its product better at growing revenue for all businesses, from smarter checkouts to fraud prevention and beyond. Join the ranks of over half of the Fortune 100 companies that trust Stripe to drive change. Learn more at stripe.com.

**中文翻译:**
去年，全球 GDP 的 1.3% 流经 Stripe。这超过了 1.4 万亿美元。推动这一巨大数字的是数百万家通过 Stripe 快速增长的企业。对于 Forbes、Atlassian、OpenAI 和 Toyota 等行业领导者来说，Stripe 不仅仅是财务软件。它是一个强大的合作伙伴，简化了他们转移资金的方式，使其像互联网本身一样无缝且无国界。例如，Hertz 在迁移到 Stripe 后，其在线支付授权率提高了 4%。想象一下，像 Forbes 那样，在切换到 Stripe 进行订阅管理仅六个月后，收入就增长了 23%。在过去的十年里，Stripe 一直在利用 AI 使其产品更好地为所有企业增加收入，从更智能的结账到欺诈预防等等。加入超过一半的信任 Stripe 推动变革的财富 100 强公司的行列。在 stripe.com 了解更多信息。

---

### [00:04:48] Lenny Rachitsky

**English:**
David, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
David，非常感谢你能来到这里，欢迎参加我们的播客。

---

### [00:04:53] David Placek

**English:**
Thank you. I'm excited about today and looking forward to the conversation.

**中文翻译:**
谢谢。我对今天感到很兴奋，非常期待我们的对话。

---

### [00:04:58] Lenny Rachitsky

**English:**
Me, too. These are actually my favorite kinds of conversations because this topic is so outside of my wheelhouse, and I know I'm just going to learn a ton. Also, this is just something that every founder and product builder has to think about at some point, and they have no idea what they're doing. And then, their name becomes so core to their identity. It's hardly the word they say more than any other word. And I feel like I've never heard advice on how to do this well. So, I'm really excited for this conversation.
(00:05:25):
I'm going to just dive into a question. And the question is just what's a name that you came up with, and your team came up with, that you had to fight super hard for that the client just hated, and you ended up winning. And now, it's just such an obviously awesome name that everyone loves.

**中文翻译:**
我也是。这实际上是我最喜欢的对话类型，因为这个话题完全超出了我的专业领域，我知道我会学到很多东西。此外，这是每个创始人和产品构建者在某个时刻都必须思考的问题，而他们往往不知道自己在做什么。然后，他们的名字变得如此核心，成为他们身份的一部分。这几乎是他们说得比任何其他词都多的词。我觉得我从未听过关于如何做好这件事的建议。所以，我非常期待这次对话。
(00:05:25):
我直接切入一个问题。这个问题就是：有没有哪个名字是你和你的团队想出来的，你必须非常努力地去争取，而客户起初非常讨厌，但最终你赢了。而现在，它已经成为一个显而易见的、人人都爱的绝佳名字。

---

### [00:05:40] David Placek

**English:**
The story I like to tell is a story of Sonos. One, a great client team. I worked with all the founders. But at the time, they were stuck on being in a brand name that put them in the entertainment business. And so when we presented Sonos, which has many qualities to it, it was rejected because it doesn't have enough emotion to it. It's not entertainment-like. And we argued about that because I said, "This is outside looking in, but I don't see you as an entertainment company. You make speakers that allow for the flow of entertainment through these things. And Sonos is about sound." But it had a particular quality. It's called a palindrome, which really means that you can flip it and it means the same thing. In the case of Sonos, you could also turn it upside down and it was essentially the same.

**中文翻译:**
我喜欢讲的故事是 Sonos 的故事。首先，那是一个非常棒的客户团队，我和所有的创始人都合作过。但当时，他们执着于要一个能让他们进入“娱乐行业”的品牌名称。所以当我们提交 Sonos 时（它有很多优秀的品质），它被拒绝了，理由是它没有足够的感染力，不像娱乐品牌。我们为此争论，因为我说：“这是从外部视角看的，我不认为你们是一家娱乐公司。你们制造扬声器，让娱乐内容通过这些设备流动。而 Sonos 与声音（sound）有关。” 但它有一个特殊的品质，它是一个“回文”（palindrome），这意味着你正着读倒着读都一样。在 Sonos 的案例中，你甚至把它倒过来放，它基本上看起来也是一样的。

---

### [00:06:47] David Placek

**English:**
And so that got them thinking about this, but they were still has... So I left that meeting in Santa Barbara, and I came back and they were still struggling with it. And I got on a plane, didn't even bill them for this, went back down to Santa Barbara and met with them again and said, "I really believe in this name and I think it's the right for you." And at a certain point, one of the founders, Bob MacFarlane, who's just a wonderful client. I could see him thinking, and he said, "You know? We're trying to name this for ourselves, and what we really should be doing is naming it for the marketplace and the customers. And I think Sonos now is the right name. And I felt really good about that." He later wrote me a note about how I help to do that, and we use it sometimes in credentials presentations because it's such a nice note.
(00:07:45):
But Sonos is something I'm so glad that I had this internal energy to, "I got to go down there and make a bid for this." I don't do that often, by the way, but I felt very strongly about Sonos.

**中文翻译:**
这让他们开始思考，但他们仍然犹豫不决……于是我离开了在圣巴巴拉的那次会议，回来后发现他们还在纠结。于是我又上了一架飞机，甚至没给他们开账单，再次飞回圣巴巴拉与他们见面，并说：“我真的相信这个名字，我认为它对你们来说是正确的。” 在某个时刻，其中一位创始人 Bob MacFarlane（他是一位非常棒的客户），我能看到他在思考，然后他说：“你知道吗？我们一直在试图为我们自己命名，而我们真正应该做的，是为市场和客户命名。我现在认为 Sonos 是正确的名字。” 我对此感到非常欣慰。他后来还给我写了一张便条，感谢我如何帮助他们实现这一目标，我们有时会在公司介绍中使用它，因为那是一封非常感人的信。
(00:07:45):
但 Sonos 是我非常庆幸自己当时有那种内在动力去争取的，“我必须去那里为它争取一下”。顺便说一句，我不经常这样做，但我对 Sonos 的感觉非常强烈。

---

### [00:07:58] Lenny Rachitsky

**English:**
I love Sonos. I love the name. I have many Sonos products. How often does this happen where the client is just, "No, this is not the name. We have this bigger vision, we have a whole other idea of it." And then you convince them.

**中文翻译:**
我爱 Sonos。我喜欢这个名字。我有很多 Sonos 的产品。这种情况经常发生吗？就是客户说：“不，这不是那个名字。我们有更宏大的愿景，我们有完全不同的想法。” 然后你最终说服了他们。

---

### [00:08:07] David Placek

**English:**
Well, it happens all of the time. And it's a little bit bidirectional, right? Most clients, and I can understand this, they come to a naming project absolutely believing, with full confidence, that they're going to know it when they see it. And the truth is, it almost never happens. I think this year we'll hit 4,000 projects that we've completed.
(00:08:37):
And it's interesting, we'll tell people in a very polite way, "You're not going to know when you see it." But I know they don't believe me. And even when... You could see them thinking that, "You know what? He was right. I really have to think about this. I have to process it." And part of that, part of why clients don't like the bolder names, the more imaginative names that we present is they are looking for comfort. And that's the opposite that what you want to do. And part of our job here is to help people to give the confidence that going bolder, and bigger, and being uncomfortable. I use the expression, "There is no power in comfort, not in the marketplace."

**中文翻译:**
嗯，这种情况一直都在发生。这有点像是双向的，对吧？大多数客户——我也能理解这一点——他们在开始命名项目时，满怀信心地认为，只要一看到那个名字，他们就能认出来。但事实是，这几乎从未发生过。我想今年我们将完成第 4000 个项目。
(00:08:37):
有趣的是，我们会非常礼貌地告诉人们：“你看到它的时候是不会立刻知道的。” 但我知道他们不相信我。甚至当……你能看到他们在想：“你知道吗？他是对的。我真的得好好想想，我得消化一下。” 其中的一部分原因，也是客户不喜欢我们提出的那些更大胆、更有想象力的名字的原因，是因为他们在寻找“舒适感”。而这恰恰是你最不该做的。我们工作的一部分就是帮助人们建立信心，去变得更大胆、更宏大，并接受不舒适感。我常说一句话：“舒适感中没有力量，至少在市场上没有。”

---

### [00:09:27] Lenny Rachitsky

**English:**
Wow. There's so much here already. So this idea of you're not going to know it when you see it is something that people come in with thinking like, "Once I see it, it'll be obvious." Just why is that almost never the case? Is it because the name has to be something that is uncomfortable?

**中文翻译:**
哇。这里面已经有很多信息量了。所以这种“你看到它时不会立刻知道”的想法，是人们进来时普遍持有的，他们觉得“一旦我看到它，它就会很明显”。为什么事实几乎从未如此？是因为那个名字必须是让人感到“不舒服”的吗？

---

### [00:09:43] David Placek

**English:**
There's a lot of psychology to this, which ironically, I never even took a psychology class in college or graduate school. But the first element is humans do like to be comfortable. And one of the mechanisms of comfort is if something's been successful before, then I feel like I can approve it or select it. This is why movies like Harry Potter or even novels like Jack London's Call of the Wild get rejected so many times. I think Harry Potter was rejected 16 or 18 times, and Jack London's book even more than that. I mean, think about it. He's pitching a book and they say, "What are you talking about here? You're saying a dog becomes a wolf? I've never heard of anything like that." So, we really do have to help people think about, "It's not about the past. You're actually creating the future." And we really talk to people and emphasize the idea, "This isn't a name you're creating. We're creating an experience for you. We're going to work together."

**中文翻译:**
这涉及到很多心理学，讽刺的是，我在大学或研究生院甚至没上过心理学课。但第一个要素是人类确实喜欢舒适。舒适的机制之一是：如果某件事以前成功过，那么我觉得我可以批准或选择它。这就是为什么像《哈利·波特》这样的电影，甚至像杰克·伦敦的《荒野的呼唤》这样的小说会被拒绝这么多次。我想《哈利·波特》被拒绝了 16 或 18 次，杰克·伦敦的书甚至更多。我的意思是，想想看，他推销一本书，人家说：“你在说什么？你说一只狗变成了一只狼？我从来没听说过这种事。” 所以，我们真的必须帮助人们思考：“这与过去无关。你实际上是在创造未来。” 我们真的会与人们交谈并强调这个想法：“这不是你在创造一个名字。我们是在为你创造一种体验。我们要一起合作。”

---

### [00:10:54] David Placek

**English:**
And our conversations always start with, "Talk to us about how you behave now and how you want to behave in the future," as opposed to, "Tell me about your positioning, tell me about your values, tell me about your mission." That's really kind of old thinking. It's very traditional, and that did work 25 or 30 years ago. But this is a far more complex, interconnected world, a digital world now that stuff just doesn't create... It doesn't create names like Sonos or some of our other credentials that we probably will talk about today.

**中文翻译:**
我们的对话总是以“告诉我们你们现在的行为方式以及你们未来希望如何表现”开始，而不是“告诉我你们的定位，告诉我你们的价值观，告诉我你们的使命”。那真的是一种老旧的思维。它非常传统，在 25 或 30 年前确实有效。但现在这是一个复杂得多、互联程度更高、数字化的世界，那些东西已经无法创造出……无法创造出像 Sonos 或我们今天可能会谈到的其他成功案例那样的名字了。

---

### [00:11:34] Lenny Rachitsky

**English:**
Yeah, we're going to talk about just the process you guys go through, so stay tuned for that. But before we get to that, is there's another story you can share that shows this idea of being bold?

**中文翻译:**
是的，我们稍后会讨论你们的具体流程，请大家保持关注。但在那之前，你还能分享另一个体现这种“大胆”理念的故事吗？

---

### [00:11:44] David Placek

**English:**
I'll talk about Microsoft's Azure. So when Microsoft came to us, they were pretty much stuck. And Microsoft does... And in many ways, to their credit, a lot of things don't need to be named. They don't need trademarks. They don't need brand names. They need descriptors. And so they came to us to develop a name that started or ended with cloud. Made sense to them because it was a cloud service. And our reaction was, "If you do that, you've going to be in an ocean of other cloud this, cloud that. And you have an opportunity as Microsoft here to really emerge as a leader in this." And so, there was a discussion about, "Okay, we'll take a look at those, but we'd like to see some cloud names." Which is easy to do, by the way.

**中文翻译:**
我来说说微软的 Azure（蔚蓝）。当微软找到我们时，他们基本上陷入了僵局。微软确实……在很多方面，值得称赞的是，很多东西其实不需要命名。它们不需要商标，不需要品牌名称，它们只需要描述词。所以他们来找我们，想开发一个以“Cloud”（云）开头或结尾的名字。对他们来说这很合理，因为那是云服务。而我们的反应是：“如果你这样做，你就会淹没在‘云这个’、‘云那个’的汪洋大海中。作为微软，你有一个机会在这里真正脱颖而出，成为领导者。” 于是我们讨论说：“好吧，我们会考虑那些，但我们也想看看一些非‘云’的名字。” 顺便说一句，起“云”字辈的名字很容易。

---

### [00:12:42] David Placek

**English:**
So, we did that. And along the way, we came up with this word azure, which is another word for blue. And so there was a link to clouds, blue sky clouds, things like that, but we really presented it based on its linguistic qualities. It's a noisy word, that Z in there. It starts with an A, and it ends in a nice smooth flow. So, we really strive to do create names that are balanced. And in a very busy competitive world, having a strong signal, which is generated by noise is a good thing.
(00:13:27):
The reaction wasn't good. One of the clients said, "That's just a dumb idea." Remarks like that. At this point, after these four decades, it just rolls off my back like water off a duck is what my grandmother would say. But I think along the way, as we talked about it, they began to warm up to this. And now of course it's, I don't know, a $100 billion brand or something like that. But that's an example of, "I haven't seen that before. I'm very comfortable with cloud. Cloud is what it is. We're describing it." But that's a statement. And I think that... Well, I don't think I know that's what I said in one of the presentations is, "You don't want to make a statement here. You want to start a story." And Azure is going to behave differently in the marketplace than Cloud Pro, which is I think one of the names that we presented to them on the other site at their request.

**中文翻译:**
所以，我们那样做了。在这个过程中，我们想到了 Azure 这个词，它是“蓝色”的另一种说法。所以它与云、蓝天白云有联系，但我们真正推销它是因为它的语言学特质。这是一个有“噪音”的词，里面那个 Z 发音。它以 A 开头，以平滑的流动结束。我们努力创造平衡的名字。在一个非常繁忙、竞争激烈的世界里，拥有一个由“噪音”产生的强信号是一件好事。
(00:13:27):
当时的反应并不好。其中一位客户说：“那真是个愚蠢的主意。” 诸如此类的评论。在经历了这四十年后，这些话对我来说就像我祖母说的“鸭子背上的水”一样，顺着就流走了（指不在意）。但我认为在沟通过程中，随着我们的讨论，他们开始接受这个名字。现在，它当然已经是一个价值千亿美元的品牌了。但这是一个典型的例子：“我以前没见过这个。我对‘Cloud’很熟悉，云就是云，我们在描述它。” 但那只是一个陈述。而我认为……不，我知道我在其中一次演示中说过：“你不想在这里做一个陈述，你想开始一个故事。” Azure 在市场上的表现将与 Cloud Pro 完全不同——我想 Cloud Pro 是我们应他们要求提供的备选名字之一。

---

### [00:14:49] Lenny Rachitsky

**English:**
I'm glad they went with Azure. Let me actually ask this question. I know you're biased, but just how important is a great name? If you had a better name than a product that was better than you, does that make a big difference? Just anything you can share there to help people see this is the power of a great name.

**中文翻译:**
我很庆幸他们选择了 Azure。让我问这个问题：我知道你可能有偏见，但一个伟大的名字到底有多重要？如果你有一个比竞争对手更好的名字，即使对方的产品比你好一点，这会产生很大影响吗？你能分享一些东西来帮助人们理解伟大名字的力量吗？

---

### [00:14:53] David Placek

**English:**
Let's look just at the reality of this. Your brand name, whether it's a product name or a company name, nothing's going to be used more often or for longer than that name. Design will change, messaging will change, products will change, but that name is there. So, I like to talk about this idea of cumulative advantage. Over time, as people buy more and more of the product, they see it more often, that their bond between you and that brand, or them and the brand I should say, becomes stronger and stronger. So you want that name to stick in their mind to be distinctive, because distinctiveness is what creates that cumulative advantage.
(00:15:35):
The second thing is this notion of what I call asymmetric advantage. It makes perfect sense, and most clients agree with this when we say this is that even before you launch this brand, why not start with an advantage in the marketplace? And you won't get an advantage if you're descriptive. If you are Cloud Pro and there's 10 other cloud services, you're not going to stand out in the marketplace. You won't have the ability to create necessarily that cumulative advantage in the marketplace.
(00:16:09):
So, those are my two reasons why names are, I think, done right. And we do talk about our mission is not creating good names. A lot of people can do that. Our mission is to create the right name for clients, because the right name does deliver asymmetric advantage and cumulative advantage for you. And that, for us, has almost unlimited value.

**中文翻译:**
让我们看看现实情况。你的品牌名称，无论是产品名还是公司名，没有任何东西会比它被使用得更频繁或更持久。设计会变，信息会变，产品会变，但名字就在那里。所以，我喜欢谈论“累积优势”（cumulative advantage）这个概念。随着时间的推移，随着人们购买越来越多的产品，他们更频繁地看到它，他们与品牌之间的纽带会变得越来越强。所以你希望那个名字能留在他们的脑海中，具有独特性，因为独特性正是创造累积优势的原因。
(00:15:35):
第二点是我所说的“非对称优势”（asymmetric advantage）。这很有道理，当我们说即使在发布品牌之前，为什么不先在市场上获得优势呢？大多数客户都同意这一点。如果你只是描述性的，你不会获得优势。如果你叫 Cloud Pro，而市场上有 10 个其他的云服务，你不会脱颖而出。你将无法在市场上创造那种必要的累积优势。
(00:16:09):
所以，这是我认为名字起得好的两个原因。我们常说我们的使命不是创造“好名字”，很多人都能做到。我们的使命是为客户创造“正确的名字”，因为正确的名字确实能为你带来非对称优势和累积优势。而这，对我们来说，具有几乎无限的价值。

---

### [00:16:41] Lenny Rachitsky

**English:**
This is a great answer. Essentially what you're saying is it's not going to necessarily make or break you, but it gives you an advantage. A great name gives you an advantage, especially if you're just getting started. You need every advantage you can get.

**中文翻译:**
这是一个很好的回答。本质上你是在说，名字不一定会决定你的成败，但它会给你带来优势。一个伟大的名字会给你带来优势，特别是如果你刚刚起步。你需要你能得到的每一个优势。

---

### [00:16:54] David Placek

**English:**
Exactly. And this is maybe a little bit off a tangent, but one of the best books on marketing I've ever read, which is not a book on marketing, and you may have read it along the way in college if you studied any Greek or classics. It's called the Melian Dialogues. And it's a dialogue... It'll take anybody listening to this maybe 25 minutes to read it. Between the Athenians and the government of Melos, the Athenians had decided that they needed that island. And they went and approached them very nice way, that, "We want to take over the island. Nothing will change. You'll be taxed a little bit, but we'll protect you." And the Athenians had thought every aspect about how to take that island before. So by the time they got there, they had created asymmetric advantage in terms of ships, and men, and all of this other stuff.
(00:17:57):
By the way, in the book, there's no mention of marketing or brand strategy or any of these things, but if you read it, you begin to see that it's marketing, really, is about a symmetric advantage. And so, why not start from the very beginning with an advantage? That's the value of a name.

**中文翻译:**
没错。这可能有点跑题，但我读过的最好的营销书籍之一，其实并不是一本关于营销的书，如果你在大学学过希腊语或古典文学，你可能读过。它叫《米洛斯对话》（Melian Dialogues）。这是一个对话……听众读完它可能只需要 25 分钟。它是雅典人和米洛斯政府之间的对话。雅典人决定他们需要那个岛。他们以一种非常友好的方式接触他们，说：“我们想接管这个岛。什么都不会改变。你们会被征一点税，但我们会保护你们。” 雅典人之前已经考虑过夺取该岛的每一个方面。所以当他们到达那里时，他们在船只、人员和所有其他方面都已经创造了非对称优势。
(00:17:57):
顺便说一句，书中没有提到营销或品牌战略或任何这些东西，但如果你读了它，你就会开始看到营销本质上就是关于非对称优势。那么，为什么不从一开始就带着优势出发呢？这就是名字的价值。

---

### [00:18:12] Lenny Rachitsky

**English:**
Let's dive into the actual process you guys go through, and I want to read a quote that Guillermo Rauch shared when I asked him about what it was like working with you. He's the CEO and co-founder of Vercel, which you guys worked with. I definitely want to hear that story, by the way. So he said, "Before David, the ability to name something was like charisma. You either have it or you don't. It was so surreal to watch his team distill it down to a science."
(00:18:35):
So let me just ask you, what does that science look like? What are the steps to coming up with an amazing name for your product or company that you guys go through?

**中文翻译:**
让我们深入探讨一下你们经历的实际流程。我想读一段 Guillermo Rauch 在我问他与你合作的感受时分享的话。他是 Vercel 的 CEO 兼联合创始人，你们曾与他合作过。顺便说一句，我绝对想听听那个故事。他说：“在遇到 David 之前，命名某物的能力就像魅力一样，要么有，要么没有。看着他的团队将其提炼成一门科学，感觉非常超现实。”
(00:18:35):
所以让我问你，那门“科学”是什么样子的？你们为产品或公司想出一个惊人名字的步骤是什么？

---

### [00:18:42] David Placek

**English:**
That's very nice of Guillermo. He is a very impressive innovator in this category and we greatly enjoyed working with him. Well, our process is real. I break it down in three steps. First, we have to identify, then we invent, and then we implement. It's just three things. It's not rocket science, but it's a combination of creativity and discipline. And obviously, talented people and experience in these things. So, let's just go through those things. In the first section of identify, it's really trying to find out from the client, let's talk about behavior. So, how are you behaving now and how do you want to behave in the future? That behavior is bidirectional. In other words, the marketplace behaves towards a Vercel, that's the name we created for Guillermo. And they behave towards the marketplace. And that's an important point because everything... Buildings are bidirectional. Look at a building, you behave differently towards a temple than you or a church versus a Holiday Inn in terms of how that architecture states. So, we focus on that. Behavior is closely aligned for us with experience. How do you want the experience of this brand?

**中文翻译:**
Guillermo 太客气了。他是这个领域非常令人印象深刻的创新者，我们非常喜欢与他合作。嗯，我们的流程是实实在在的。我把它分为三个步骤。首先，我们必须“识别”（Identify），然后我们“发明”（Invent），最后我们“执行”（Implement）。就这三件事。这不是什么高深莫测的科学，而是创造力和纪律的结合。当然，还有人才和经验。让我们逐一来看。在第一阶段“识别”中，主要是试图从客户那里了解：让我们谈谈行为。你现在的行为方式是怎样的，你未来想如何表现？这种行为是双向的。换句话说，市场对 Vercel（这是我们为 Guillermo 创造的名字）的行为，以及 Vercel 对市场的行为。这是一个重点，因为一切……建筑都是双向的。看一座建筑，你对寺庙或教堂的行为方式与对假日酒店（Holiday Inn）的行为方式是不同的，这取决于建筑的表达。所以，我们专注于此。对我们来说，行为与体验紧密相连。你希望这个品牌的体验是怎样的？

---

### [00:20:11] David Placek

**English:**
Now, when we listen to those things, we begin to think about rhythm of the name. So something like Dasani has a lot of rhythm to it, right? It's kind of calming. And so, we'll begin to extract things from that discussion on experience. We will then, also, as part of this first phase, look at the competition. We call that developing a landscape. And we're looking for what are the words... What are the brand names, first, and then what language are they using in this space? Because we have to be distinctive. If a brand name isn't distinctive, you lose. Then, you're imitating. And that's a form of suicide. That's a famous quote from some... I think the president of P&G 50 years ago or something like that. So, that's that first phase which allows us to create what we call a creative framework. And we don't even use the word objectives here because that gets too logical.

**中文翻译:**
当我们倾听这些内容时，我们开始思考名字的节奏。比如 Dasani（达萨尼水）就很有节奏感，对吧？它有一种平静的感觉。所以，我们会从关于体验的讨论中提取元素。然后，作为第一阶段的一部分，我们还会观察竞争对手。我们称之为“开发图景”（developing a landscape）。我们寻找的是……首先是品牌名称，然后是他们在这一领域使用的语言。因为我们必须具有独特性。如果一个品牌名称没有独特性，你就输了。那样你就是在模仿，而模仿是一种自杀。这是 50 年前宝洁公司某位总裁的名言。所以，第一阶段让我们能够创建一个我们称之为“创意框架”的东西。我们在这里甚至不使用“目标”（objectives）这个词，因为那太逻辑化了。

---

### [00:21:16] David Placek

**English:**
Actually, framework for us is a metaphor for a window for us, and our teams, and our linguists to travel through. To open things up so that we're not coming back with a narrow list of names. We're coming back with names that have depth, and breadth, and have different experiences and personalities to them. And clients will sign off on that. And then, we get going. So now, we're moved to the invent stage.
(00:21:44):
And in the invent stage, we do really two things. You can look at this as two layers of our process. I think the second layer is probably what makes us quite unique in the marketplace. It's the result of millions of dollars of R&D on our part. So the first thing is, no surprise to anyone, we work with creative individuals. And we don't use... This will be contrary. We don't use large brainstorming sections. I did. When I first started the company, I used freelancers, I used large brainstorming groups. And along the way through some analysis, we really discovered that that was not really working for us. That actually, the names were coming from employees and from small groups. And so we've moved our process to, at least, two or three small teams of two people.

**中文翻译:**
实际上，框架对我们来说是一个隐喻，它是我们、我们的团队和语言学家可以穿过的一扇窗户。为了打开局面，这样我们带回来的就不是一份狭窄的名字列表。我们带回来的名字具有深度、广度，并且具有不同的体验和个性。客户会签署认可。然后，我们就开始行动。现在，我们进入“发明”阶段。
(00:21:44):
在发明阶段，我们主要做两件事。你可以将其视为我们流程的两个层面。我认为第二层可能是让我们在市场上独一无二的原因。这是我们投入数百万美元研发的结果。第一件事，大家都不意外，我们与创意人才合作。但我们不使用……这可能有点反直觉，我们不使用大型头脑风暴会议。我以前用过。刚创办公司时，我用自由职业者，用大型头脑风暴小组。但在分析过程中，我们发现那对我们并不奏效。实际上，名字来自于员工和小组。所以我们将流程改为至少两到三个由两人组成的小组。

---

### [00:22:41] David Placek

**English:**
And each of those teams... So let's say on significant projects, we always use three teams. And each team gets a different briefing. One team knows everything about the project but the other teams don't. If we're working for Microsoft, the second team thinks they're working for Apple. I mean, they know it's disguised. We're not keeping this from anyone. And then the third team, we take it out of computers, and they might be naming a bicycle or a car or something like that. What we're trying to do is open up the coffers of creativity for this. And so when people are working on what they know is not the real assignment, they are now free to make all kinds of mistakes. And so, most of our names have come out of the second or third team because they're-

**中文翻译:**
每个团队……假设在重大项目中，我们总是使用三个团队。每个团队都会得到不同的简报。一个团队了解项目的所有信息，但其他团队不了解。如果我们是在为微软工作，第二个团队会以为他们在为苹果工作。我的意思是，他们知道这是伪装的，我们并没有瞒着任何人。然后第三个团队，我们把任务从计算机领域移开，他们可能是在为一辆自行车或一辆汽车命名。我们试图做的是打开创意的宝库。所以当人们在做他们知道不是真实任务的工作时，他们可以自由地犯各种错误。因此，我们的大多数名字都来自第二个或第三个团队，因为他们——

---

### [00:23:29] Lenny Rachitsky

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:23:29] David Placek

**English:**
Yeah. I think the process, at some point, I will hopefully write either a good article on this or maybe even a book. But this process would work for, I think, a lot of things. I know it would. All right now, what's that second layer that I talked about? Well, we have made significant investments in this area of linguistics and cognitive science, and it's in two ways. One, building proprietary knowledge. So we know through research that we funded, an extensive amount about an area in language called or linguistics called the sound symbolism. So, what are the sounds of the 26 letters of the alphabet and what do they do? How do they evoke things? Well, it turns out that each of those letters sends out a signal that creates a certain sort of vibration, if you will, or experience.

**中文翻译:**
是的。我想这个流程，在未来的某个时候，我希望能写一篇好文章或者甚至出一本书。但我认为这个流程适用于很多事情。我知道它行得通。好了，我刚才提到的第二层是什么？我们在语言学和认知科学领域进行了大量投资，主要体现在两个方面。第一，建立专有知识。通过我们资助的研究，我们对语言学中一个叫“语音象征”（sound symbolism）的领域有了深入了解。也就是说，字母表中 26 个字母的声音是什么，它们起什么作用？它们如何唤起联想？事实证明，每一个字母都会发出一个信号，创造出某种振动，或者说体验。

---

### [00:24:31] David Placek

**English:**
Now, there's been research on that over the years but there were some gaps, and we decided to fill this. And over the years, we've had a very good relationship with Stanford University, with their Department of Linguistics. We've hired linguists from MIT, from Berkeley. We have a linguistic internship here. I actually just ran this number, preparing for this discussion. We have employed, over four decades now, 253 linguists. Most of them PhDs, some of them contracts, some of them actual employees. That's a lot of intellectual knowledge. So we really have, what I call, a linguistic engine here. And then we now have an operating network of... I just checked on this figure yesterday. We have 108 linguists in 76 countries that help us. Some of them do creative work, others will do just the analysis of names for us. So now, we have that creative framework, we have creative teams working on this.

**中文翻译:**
多年来一直有相关的研究，但存在一些空白，我们决定填补这些空白。多年来，我们与斯坦福大学语言学系保持着非常良好的关系。我们从麻省理工学院、伯克利大学聘请语言学家。我们这里有语言学实习项目。为了这次讨论，我刚刚统计了一下数字：在过去的四十年里，我们雇佣了 253 名语言学家。其中大多数是博士，有些是合同工，有些是正式员工。这是大量的知识储备。所以我们这里真的有一个我称之为“语言引擎”的东西。我们现在还有一个运行网络……我昨天刚查过数据，我们在 76 个国家拥有 108 名语言学家协助我们。他们中有些人做创意工作，另一些人则专门为我们进行名字分析。所以现在，我们有了创意框架，有了创意团队在工作。

---

### [00:25:39] David Placek

**English:**
Now, we're tapping into databases that have over 18,000 small word units, technically called morphemes. So, we also can tap in from a sound standpoint. What are the sounds of reliability? What are the sounds of aliveness? And so with Sonos, by the way, we wanted things that are somewhat noisy. And so S is a noisy letter, like a Z or even a V. And so, you begin to set priorities about what letters we're going to use. And that work from that, we call it an engineering layer floats up into the creative teams. And so, it's a mixture of things at a certain point in time.
(00:26:27):
All right. Now, what happens to all that? At a certain point, usually 3 to 4 weeks into this, we might have 2 or 3,000 ideas. I say ideas because they're not all solutions, they're not all workable. They may be just beginning ideas, concepts. And we sift through those. And now one of the major challenges that we face, and certainly our clients face, is the need to clear a trademark for it to be not in conflict with a marketplace that is... We're almost reaching a tipping point in terms of difficulty of clearing names here. And so we have paralegals here, and we have a trademark attorney, and we'll analyze those names. That gets us to a much smaller set. And then, we'll do our linguistic work with our linguists, and we end up with a set of names to show our clients.

**中文翻译:**
现在，我们正在利用拥有超过 18,000 个小词单元（技术上称为“词素”，morphemes）的数据库。所以，我们也可以从声音的角度切入。代表“可靠性”的声音是什么？代表“生命力”的声音是什么？顺便说一句，对于 Sonos，我们想要一些带有“噪音”的东西。S 是一个有噪音的字母，就像 Z 甚至 V 一样。所以，你开始设定我们要使用哪些字母的优先级。这项工作——我们称之为“工程层”——会浮现并传递给创意团队。所以在特定的时间点，它是多种元素的混合。
(00:26:27):
好了，接下来会发生什么？在某个时间点，通常是项目开始 3 到 4 周后，我们可能会有 2000 或 3000 个想法。我说“想法”是因为它们并不全是解决方案，也不全可行。它们可能只是初步的想法、概念。我们筛选这些想法。现在我们面临的主要挑战之一，当然也是我们的客户面临的，是需要进行商标清理，以确保它与市场不冲突……在清理名字的难度方面，我们几乎快达到一个临界点了。所以我们这里有法律助理，有商标律师，我们会分析这些名字。这让我们得到一个更小的集合。然后，我们会与语言学家一起进行语言学工作，最后得到一组名字展示给客户。

---

### [00:27:22] David Placek

**English:**
We'll do this twice with most assignments. Sometimes, we'll do just one time depending on timing and budget. But we really try to get two cycles here, partly because humans love to compare. If you're looking for a house, you don't just look at the first house and say, "Okay, let's sign us up." You look and you learn that we don't need a swimming pool, but we do need a view. It's the same with names. And so, we get feedback from our clients. And sometimes, that's a co-creative process where a client will come up with a word or a solution and we'll then run that through our screening mechanisms for them. And that's really the process. The final phase is implementing.

**中文翻译:**
大多数任务我们会进行两次这样的循环。有时根据时间和预算只做一次。但我们真的努力进行两个周期，部分原因是人类喜欢比较。如果你在找房子，你不会只看第一间房就说：“好，签合同吧。” 你会看，然后了解到我们不需要游泳池，但我们需要景观。名字也是一样。所以，我们从客户那里获得反馈。有时，这是一个共同创造的过程，客户会想出一个词或一个方案，然后我们为他们运行筛选机制。这就是整个流程。最后的阶段是“执行”。

---

### [00:28:08] Lenny Rachitsky

**English:**
Let's actually pause at that because I would, so much, I want to talk about with the second step, but we'll get to the step three. They're just blowing my mind, all the things you guys do here. This is incredible. There's so many things here that are so unlike what I expected.
(00:28:23):
First of all, the creative folks that are actually coming up with these names, what's the background of these people? Who are these people?

**中文翻译:**
让我们先停一下，因为关于第二步我有太多想聊的了，不过我们稍后会谈第三步。你们在这里做的所有事情简直让我大开眼界。这太不可思议了。这里有很多事情和我预想的完全不同。
(00:28:23):
首先，那些实际想出这些名字的创意人员，他们的背景是什么？他们都是些什么样的人？

---

### [00:28:31] David Placek

**English:**
So, the fundamental quality is they're going to be curious and they're going to be hardworking. This is... And hopefully... And this is hard to screen for, but lower egos. This is unlike the advertising business which I came from, so I've six years at a large agency. Where a creative person or a copywriter can think about something and come in with 3 or 4 alternatives in terms of a headline or body copy. And that might be refined a little bit and maybe sent back to the drawing boards altogether, but it's a relatively simple process. And no disrespect intended there.

**中文翻译:**
最基本的素质是他们必须好奇且勤奋。而且希望——虽然这很难筛选——他们的自我意识（ego）要低一些。这与我出身的广告业不同，我在一家大机构待过六年。在那里，一个创意人员或文案可以思考一下，然后拿出 3 或 4 个标题或正文的备选方案。那可能会被稍微修改一下，或者可能被退回重做，但那是一个相对简单的过程。我并没有不尊重的意思。

---

### [00:29:19] David Placek

**English:**
Here, I can't just sit down and say, "Okay, we're naming a new car here. And so, I'm going to generate 100 names and you generate 100 names, and something will fall out." Those names will not... There's not enough in that list to clear through our screens. Of legal screens, our linguistic screens. And remember, we start with a creative framework and a criteria that the names need to meet. So, we're looking for people who can churn out a lot of work. And when that's rejected, they just keep going. So, we look for tenacious people. Now, we have... And we'll probably get to this later, but we have software here that helps people generate names. Not really... Maybe five years down the road, it'll actually spit out solutions, but now it's helping us to generate ideas and directions and what I... Sound symbolism, ideas, word unit, prefixes, suffixes, things like that. So, it's relatively easy for anyone that works here to develop a list of 2 or 300 names over a 3 or 4-day period.

**中文翻译:**
在这里，我不能只是坐下来，说：“好吧，我们要给一辆新车命名。我生成 100 个名字，你生成 100 个名字，然后总会掉出点什么来。” 那些名字不够……那份名单里的东西不足以通过我们的筛选。包括法律筛选、语言学筛选。记住，我们是从创意框架和名字需要满足的标准开始的。所以，我们在寻找能够产出大量工作的人。当这些被拒绝时，他们会继续前进。所以，我们寻找坚韧的人。现在，我们有……我们稍后可能会谈到这个，但我们这里有帮助人们生成名字的软件。并不是真的……也许五年后它能直接吐出解决方案，但现在它是在帮助我们生成想法、方向，以及我提到的语音象征、词单元、前缀、后缀之类的东西。所以，对于在这里工作的任何人来说，在 3 到 4 天内开发出一份包含 200 或 300 个名字的清单是相对容易的。

---

### [00:30:41] David Placek

**English:**
Where do we find these people? More who are writers from newspaper reporters because they have to work fast. Their stories get rejected. People who might have written a novel. We have hired people from agencies over the years. They work a little less effectively than others who have a speechwriter from... I wrote speeches in Washington. Those people have to work hard, crank out a lot of material, get rejected. Candidate says, "I don't like this, start over." Those are more resilient people. That's where they come from. It's not easy to find these people. It really isn't.

**中文翻译:**
我们在哪里找到这些人？更多的是报社记者的作家，因为他们必须工作迅速，他们的报道经常被拒绝。或者是写过小说的人。多年来我们也从广告公司招人，但他们的效率往往不如那些做过演讲撰稿人的人……我在华盛顿写过演讲稿。那些人必须努力工作，产出大量材料，然后被拒绝。候选人说：“我不喜欢这个，重写。” 那些人更有韧性。这就是他们的来源。找到这些人并不容易，真的不容易。

---

### [00:31:25] Lenny Rachitsky

**English:**
Let me just throw out here. I'm going to ask you after we go through this process, what people that don't have the resources and time to do this, what they should do to come up with a good name. I'm just going to let people know as they're listening because-
(00:31:36):
... I imagine many people are wondering, but let's not go there yet.

**中文翻译:**
我先提一下。在讨论完这个流程后，我会问你，对于那些没有资源和时间做这些的人，他们应该怎么做才能想出一个好名字。我只是想让听众知道，因为——
(00:31:36):
……我想很多人都在想这个问题，但我们先不谈那个。

---

### [00:31:38] David Placek

**English:**
Sure.

**中文翻译:**
好的。

---

### [00:31:39] Lenny Rachitsky

**English:**
How long does this process usually take? What's the ideal length the company should expect when they want to come up with an amazing name?

**中文翻译:**
这个过程通常需要多长时间？当一家公司想要想出一个惊人的名字时，理想的预期时长是多少？

---

### [00:31:44] David Placek

**English:**
For us, the ideal link is pretty short. It's eight weeks. For larger corporate projects where you have boards and a little more politicking to do, and a few more presentations, it's a three-month churn. And sometimes by the time they approve things and clear, it's a four-months process.

**中文翻译:**
对我们来说，理想的时长相当短，是八周。对于拥有董事会、需要更多政治博弈和更多演示的大型企业项目，通常需要三个月的反复。有时等到他们批准并清理完毕，就是一个四个月的过程。

---

### [00:32:05] Lenny Rachitsky

**English:**
Okay, cool. So eight weeks mostly if you're a big company with a lot of red tape. You have to work through then longer.
(00:32:11):
Okay, this point you made about three different teams with different almost context is so interesting. So say, let's use Windsurf as an example, which is an amazing name, killing it, that you guys helped come up with. So is the idea there, okay, here's we're naming this AI IDE. One of the team has told, "No, you're building a bicycle. Here's all the same brief, but it's a bicycle. And then another team, you're building a..." I don't know, lap. I don't know, something non-technical essentially, right?

**中文翻译:**
好的，酷。所以大部分是八周，如果你是一家官僚作风严重的大公司，你就得花更长时间。
(00:32:11):
好，你提到的关于三个不同团队、几乎不同背景的观点非常有趣。比方说，让我们以 Windsurf 为例，这是一个非常棒的名字，非常成功，是你们帮忙想出来的。所以那里的想法是：好吧，我们要给这个 AI IDE（集成开发环境）命名。其中一个团队被告知：“不，你们是在制造一辆自行车。这是同样的简报，但它是一辆自行车。” 然后另一个团队，你们在制造一个……我不知道，一个杯子。基本上是一些非技术性的东西，对吧？

---

### [00:32:42] David Placek

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:32:43] Lenny Rachitsky

**English:**
Like, a cup. Say more about that because that is amazing because. And you're finding that most of the best names come from the groups that aren't... Let's name an amazing AI IDE.

**中文翻译:**
比如一个杯子。多谈谈这个，因为这太神奇了。你发现大多数最好的名字都来自那些不是在想“让我们给一个了不起的 AI IDE 命名”的小组。

---

### [00:32:54] David Placek

**English:**
This is a good example. So in technology, there are some things that if someone hands you a new phone and you look at it and it's tangible and it's got a shape and color, things like that, easier to name. But the name of Windsurf, before it was Windsurf, was Codium. So, it's all about a type of code or a process for coding. That's intangible. And even though we do an awful lot of technology work, it is still hard for us to really get ahold of what that is. So our rule here is if there's something that is intangible like that, we have to make it tangible. And sometimes we do that not by giving a team, sometimes it's an individual, the assignment to create ideas for the brand itself, but to just dive into a particular context.

**中文翻译:**
这是一个很好的例子。在技术领域，有些东西——如果有人递给你一部新手机，你看着它，它是实实在在的，有形状和颜色，这类东西更容易命名。但在 Windsurf 叫 Windsurf 之前，它的名字是 Codium。所以，它完全是关于一种代码或一种编码过程。那是无形的。尽管我们做了大量的技术工作，但我们仍然很难真正把握那是什么。所以我们的规则是：如果某样东西是无形的，我们必须让它变得有形。有时我们这样做不是给一个团队（有时是一个人）为品牌本身创造想法的任务，而是让他们沉浸在一个特定的语境中。

---

### [00:33:49] David Placek

**English:**
And in this case with Windsurf, this is about flow about giving people that are coding something much more of a flow process, a smoother process, a more dynamic process. So in that case, One team was just given the task of we want to look at a list of all the things that can communicate either in a real word like flow or metaphorically or in a sport about that kind of dynamics. That kind of movement. And there was Windsurf sitting on a list. I mean, sometimes, this is really just that simple. Of course, you have to have the right framework and you have to give the right directions to someone. And Windsurf, for us and particularly for me, it checks all the boxes. It's a wonderful image, it's an experience. Literally, a physical experience. It's a compound, right? Two words put together. We know from the research we've invested in that compounds like Powerbook or Facebook are multipliers of associations because there's wind and there's circles around that, and then there's surf images around that. So 1 + 1 = 3, right?

**中文翻译:**
在 Windsurf 的案例中，这关乎“流动”（flow），关乎为编码人员提供更具流动性、更平滑、更动态的过程。所以在那种情况下，一个团队得到的任务是：我们想看一份清单，列出所有能传达“流动”这个词（无论是实词还是隐喻）或者在运动中体现这种动力学、这种运动的事物。Windsurf 就在那份清单上。我的意思是，有时事情就是这么简单。当然，你必须有正确的框架，必须给某人正确的方向。Windsurf 对我们，特别是我来说，符合所有要求。它是一个美妙的意象，它是一种体验。字面意思上，一种身体体验。它是一个复合词，对吧？两个词拼在一起。我们从投入的研究中得知，像 Powerbook 或 Facebook 这样的复合词是联想的乘数，因为有“风”（wind），周围有相关的圈子，然后有“冲浪”（surf）的意象。所以 1 + 1 = 3，对吧？

---

### [00:35:16] David Placek

**English:**
It's interesting that when we present compounds to clients, we often get the comment, "Well, it's a little bit long and it's a compound. I'd rather have a shorter single word." And then that's why we actually did research on just how effective our compounds so we could pass that information along. We passed that along to the team at that time. Codium, by the way, could not have been a more intelligent, nicer, more respectful team that we've worked with. I'm so glad for their success. But we explained to them about the multiplier effect of compounds. We showed them imagery that they could use. I mean, it's simple to execute on something like that. And so, that's how that came about. I'll stop there and see if you need more information or not.

**中文翻译:**
有趣的是，当我们向客户展示复合词时，经常会听到这样的评论：“嗯，它有点长，而且是个复合词。我更想要一个更短的单词。” 这就是为什么我们实际上对复合词的有效性进行了研究，以便我们可以传递这些信息。我们当时把这些信息传递给了那个团队。顺便说一句，Codium 团队是我们合作过的最聪明、最友善、最受人尊敬的团队。我为他们的成功感到高兴。但我们向他们解释了复合词的乘数效应。我们向他们展示了他们可以使用的意象。我的意思是，在这样的基础上执行是很简单的。这就是它的由来。我先停在这里，看看你是否需要更多信息。

---

### [00:36:11] Lenny Rachitsky

**English:**
Let me actually follow this through real quick. It's going to be kind of a tangent. You guys have been working with AI companies more and more recently, which is so interesting. What's different about naming AI products from traditional products, not AI, I guess?

**中文翻译:**
让我快速跟进一下。这可能有点跑题。你们最近越来越多地与 AI 公司合作，这非常有趣。给 AI 产品命名与给传统产品（非 AI 产品）命名有什么不同？

---

### [00:36:25] David Placek

**English:**
First off, we are working mostly with engineers, and engineers who haven't delved into the world of creativity and necessarily marketing. And that's their strength. And what we have to do is we have to balance their strength with our strength. So there's a little bit of a challenge there, but I think we deal pretty well with that. Secondly, this is the fastest moving progressing category I have ever experienced. And I have that perspective, right? I went through the early days of the internet and the World Wide Web, and that was moving pretty fast. But the internet compared to this looks like a daycare school or something like that. We're challenged by just keeping up with developments. Third thing, and this is the creative challenge here, is that engineers come to us wanting more sophisticated names where they are likely to end up with another Codium or an Anduril or an Anthropic.

**中文翻译:**
首先，我们主要是在和工程师打交道，而工程师通常没有深入研究过创意世界，也不一定懂营销。那是他们的强项。而我们必须做的是用我们的强项来平衡他们的强项。所以这有一点挑战，但我认为我们处理得很好。其次，这是我经历过的发展速度最快的类别。我有这种视角，对吧？我经历过互联网和万维网的早期阶段，那时发展得很快。但与此相比，当时的互联网看起来就像托儿所一样。仅仅是跟上发展步伐对我们来说就是一种挑战。第三点，也是创意上的挑战，是工程师来找我们时想要更“高级”的名字，结果他们很可能会得到另一个像 Codium、Anduril 或 Anthropic 这样的名字。

---

### [00:37:42] David Placek

**English:**
And when we saw this trend of that AI is going to take off, and it was an intuitive feeling on my part. I could have been wrong. I said, "Let's find out what's going on here." So both, not only who's developing the products, but how do people think about AI? And we did a series of research. I probably invested $20,000 or so. And we interviewed consumers in Europe, South Korea, just picked out one country in Asia, and in America, and developers in those three. And they really have different views. Developers are all totally positive on it. They see the future, they see a big future, not too concerned, some are, but most aren't. Consumers are skeptical, worried about it, worried about their jobs, see the hope in it, those types of things, but haven't got the handle on it.
(00:38:41):
So Codium is an example where we said, "We think what you're doing needs to be much more tangible, and something that people can grab onto, and much more natural as opposed to a Codium." And they listened to us. Very simple as that. And in this case, we were right. And by the way also, I have to say, there's some luck to this. Windsurf happened to be available and they sought right away, not exactly right away but it took about a week going back and forth to select it. So, let me stop there and see if that answers your question.

**中文翻译:**
当我们看到 AI 即将腾飞的趋势时（这是我的一种直觉，我也可能是错的），我说：“让我们看看这里发生了什么。” 所以不仅要看谁在开发产品，还要看人们如何看待 AI。我们做了一系列研究，我大概投入了 2 万美元左右。我们采访了欧洲、韩国（选了一个亚洲国家）和美国的消费者，以及这三个地区的开发者。他们的观点确实不同。开发者完全持积极态度，他们看到了未来，看到了宏大的前景，不太担心（有些人担心，但大多数不担心）。消费者则持怀疑态度，担心它，担心自己的工作，虽然也看到了希望，但还没有掌握它。
(00:38:41):
所以 Codium 是一个例子，我们说：“我们认为你们所做的事情需要更加有形，需要一些人们可以抓住的东西，需要更加自然，而不是像 Codium 这样。” 他们听取了我们的建议。就这么简单。在这种情况下，我们是对的。顺便说一句，我也必须说，这其中有一定的运气成分。Windsurf 刚好可用，他们立刻就看中了——也不是立刻，而是经过大约一周的反复讨论才选定。我就停在这里，看看这是否回答了你的问题。

---

### [00:39:23] Lenny Rachitsky

**English:**
Absolutely. And it feels like most AI companies end up having a different name for their product than their company. I've noticed this funny trend cursor was any sphere bold with stack is StackBlitz, Windsurf is Codium. Basically, everyone.
(00:39:37):
When does it make sense to change your name? Windsurf just officially changed their entire company name to Windsurf from Codium. It was just a product. So, let me just ask you that. When does it make sense? It feels like a huge deal and a very challenging thing to do.

**中文翻译:**
当然。而且感觉大多数 AI 公司最终的产品名称和公司名称都不一样。我注意到这个有趣的趋势：Cursor 以前叫别的，StackBlitz 以前叫别的，Windsurf 以前叫 Codium。基本上每个人都是这样。
(00:39:37):
什么时候更改名字是有意义的？Windsurf 刚刚正式将整个公司名称从 Codium 改为 Windsurf。它以前只是一个产品。所以，我想问你：什么时候改名是有意义的？这感觉是一件大事，也是一件非常有挑战性的事情。

---

### [00:39:48] David Placek

**English:**
It is challenging. And the larger you are and the more customer base you have, it becomes a significant project. So the first thing is you have to make an argument that it's worth the change. That we're going to be better off by changing our name. So, there's a couple situations where you want to change your name. First one is let's focus first on startups. Startups get going early, they get into Y Combinator or something like that, they're raising money. And they just need a name. And although they know what they're doing, and that may change by 10 or 15 degrees, it's almost like, "We just got to have a name." And that is the absolute expression I hear from when a startup calls and says, "We want to change your name. We started off a year and a half ago. We just needed a name for the documents, and so we chose X." And it's not a very good name. So, that's example number one.

**中文翻译:**
这确实很有挑战性。你规模越大，客户群越多，它就越是一个重大项目。所以第一件事是你必须论证这种改变是值得的，即通过改名我们会变得更好。有几种情况你会想要改名。第一种，我们先关注初创公司。初创公司起步早，进入 Y Combinator 之类的孵化器，正在融资。他们只需要一个名字。虽然他们知道自己在做什么，而且方向可能会发生 10 到 15 度的偏差，但当时的感觉就像是“我们必须得有个名字”。当我接到初创公司的电话说“我们要改名”时，我听到的绝对就是这种说法：“我们一年半前开始，当时只是为了文件需要一个名字，所以我们选了 X。” 而那通常不是一个很好的名字。这是第一个例子。

---

### [00:40:53] David Placek

**English:**
Number two is the company actually has pivoted. And so, the name that they have no longer really reflects who they are or who they're becoming, and which makes that name ineffective. And the third is that a company has merged and it is time now to create a new start and reflect to the marketplace that we're... We're new now, maybe bigger, but certainly we have more capabilities and we want you to know about it. And because of that, we're changing our to blank, which reflects those capabilities at some level.

**中文翻译:**
第二种情况是公司实际上发生了转型（pivot）。因此，他们现有的名字不再能真正反映他们是谁或他们将成为谁，这使得该名字失效了。第三种情况是公司合并了，现在是时候创造一个新的开始，并向市场反映我们……我们现在是全新的，可能规模更大，但肯定拥有更多能力，我们希望让你们知道。因此，我们将名字改为 [空白]，这在某种程度上反映了这些能力。

---

### [00:41:38] Lenny Rachitsky (Ad Break: OneSchema)

**English:**
I'm excited to have Andrew Luo joining us today. Andrew is CEO of OneSchema, one of our longtime podcast sponsors. Welcome, Andrew.
(00:41:45): Andrew Luo: Thanks for having me, Lenny. Great to be here.
(00:41:47): Lenny Rachitsky: So, what is new with OneSchema? I know that you work with some of my favorite companies like Ramp and Vanta and Watershed. I heard you guys launched a new data intake product that automates the hours of manual work that teams spent importing, and mapping, and integrating CSV in Excel files.
(00:42:03): Andrew Luo: Yes. So, we just launched the 2.0 of OneSchema FileFeeds. We've rebuilt it from the ground up with AI. We saw so many customers coming to us with teams of data engineers that struggled with the manual work required to clean messy spreadsheets. FileFeeds 2.0 allows non-technical teams to automate the process of transforming CSV in Excel files with just a simple prompt. We support all of the trickiest file integrations, SFTP, S3, and even email.
(00:42:29): Lenny Rachitsky: I can tell you that if my team had to build integrations like this, how nice would it be to take this off our roadmap and instead use something like OneSchema.
(00:42:37): Andrew Luo: Absolutely, Lenny. We've heard so many horror stories of outages from even just a single bad record in transactions, employee files, purchase orders, you name it. Debugging these issues is often like finding a needle in a haystack. OneSchema stops any bad data from entering your system and automatically validates your files, generating error reports with the exact issues in all bad files.
(00:42:58): Lenny Rachitsky: I know that importing incorrect data can cause all kinds of pain for your customers and quickly lose their trust. Andrew, thank you so much for joining me. If you want to learn more, head on over to oneschema.co, That's oneschema.co.

**中文翻译:**
很高兴今天有 Andrew Luo 加入我们。Andrew 是 OneSchema 的 CEO，也是我们长期的播客赞助商之一。欢迎你，Andrew。
(00:41:45): Andrew Luo: 谢谢邀请，Lenny。很高兴来到这里。
(00:41:47): Lenny Rachitsky: OneSchema 有什么新动态？我知道你们与我最喜欢的一些公司合作，如 Ramp、Vanta 和 Watershed。我听说你们推出了一个新的数据摄取产品，可以自动完成团队在导入、映射和集成 CSV 及 Excel 文件时花费的数小时手动工作。
(00:42:03): Andrew Luo: 是的。我们刚刚发布了 OneSchema FileFeeds 的 2.0 版本。我们利用 AI 从头开始重构了它。我们看到很多客户带着数据工程师团队来找我们，他们为清理杂乱的电子表格所需的手动工作而苦恼。FileFeeds 2.0 允许非技术团队只需通过简单的提示词，即可自动完成 CSV 和 Excel 文件的转换过程。我们支持所有最棘手的文集成方式，包括 SFTP、S3 甚至电子邮件。
(00:42:29): Lenny Rachitsky: 我可以告诉你，如果我的团队必须构建这样的集成，能把它从我们的路线图中拿掉，转而使用像 OneSchema 这样的东西，那该有多好。
(00:42:37): Andrew Luo: 绝对的，Lenny。我们听过太多关于停机的恐怖故事，甚至只是因为交易、员工文件、采购订单中的一条错误记录。调试这些问题通常就像大海捞针。OneSchema 阻止任何错误数据进入你的系统，并自动验证你的文件，生成包含所有错误文件中具体问题的错误报告。
(00:42:58): Lenny Rachitsky: 我知道导入错误的数据会给客户带来各种痛苦，并迅速失去他们的信任。Andrew，非常感谢你加入我。如果你想了解更多，请访问 oneschema.co。

---

### [00:43:12] Lenny Rachitsky

**English:**
I want to come back to this linguist piece, which I know is really unique to the way you guys operate, and it's so interesting. So you employed, you've said, over 250 linguists over the course of your business career. This linguist step, the way you described it is they're not coming up with names, they're more kind of like a filter for, "Here's all the names we've come up with. Here's the ones that are good linguistically." Is that right? Or is that team also suggesting names?

**中文翻译:**
我想回到语言学家这个环节，我知道这是你们运作方式中非常独特且有趣的一点。你说在你的职业生涯中雇佣了超过 250 名语言学家。这个语言学家步骤，按照你的描述，他们不是在想名字，而更像是一个过滤器，说：“这是我们想出的所有名字。这是语言学上表现良好的名字。” 是这样吗？还是说那个团队也会建议名字？

---

### [00:43:35] David Placek

**English:**
Yeah. Some of the people there, depending on the assignment, will actually help us create names, for sure. And so, we have linguists here. And in the network, we have linguists. And those linguists are contracts to us, not full-time employees. So, there's a little bit of both. But the preponderance of their work in our linguistic network is to evaluate names. Not only just does it mean something negative or positive, but are there cultural implications to it? Political implications? Or even things that a natural disaster that would've happened somewhere that no one here would know about. Even if we had, if.

**中文翻译:**
是的。其中的一些人，根据任务的不同，确实会帮助我们创造名字。我们这里有语言学家，在我们的网络中也有语言学家。那些语言学家是我们的合同工，不是全职员工。所以两者兼而有之。但他们在我们语言网络中的主要工作是评估名字。不仅是看它意味着负面还是正面，还包括是否有文化影响？政治影响？甚至是在某地发生过、而这里没人知道的自然灾害相关的事情。

---

### [00:44:21] David Placek

**English:**
This was in Italy, and there was a bridge or a flood that killed a lot of people. Someone that speaks Italian very well here, say at Berkeley University, but has lived here for 20 years, wouldn't know about that. And we don't want anything linguistically that would slow our clients down. And so, that's why we've invested in building this network. We have a woman that runs the network for it. So, it's not an insignificant facet of our business that we have to run and manage.

**中文翻译:**
比如在意大利，曾有一座桥倒塌或一场洪水导致很多人丧生。一个在这里（比如在伯克利大学）意大利语说得很好、但已经在这里住了 20 年的人，可能不知道那件事。我们不希望任何语言学上的东西拖累我们的客户。这就是为什么我们投资建立了这个网络。我们有一位专门负责运行这个网络的女士。所以，这是我们必须运行和管理的一个不容忽视的业务层面。

---

### [00:44:52] Lenny Rachitsky

**English:**
Is there a name you love that didn't pass the linguistic filter, that ended up being like, "Oh, shit. That's a really bad name in this culture"?

**中文翻译:**
有没有哪个你很喜欢的名字没能通过语言学筛选，结果发现“噢，该死，这个名字在某种文化里非常糟糕”？

---

### [00:45:00] David Placek

**English:**
It happens frequently where we will find something that isn't really terrible but it's worrisome to us. It's interesting cultures like Australian or people in Australia, they have a lot of interesting expressions. And so, we do find things that this sounds like it's a certain kind of shrimp and things like that, and we eliminate those things. And then we find things that have sort of sexual connotations, we eliminate those.
(00:45:39):
I would say it happens every third or fourth project we'll find something that we will eliminate and never show the client.

**中文翻译:**
这种情况经常发生，我们会发现一些虽然不是特别糟糕、但让我们担心的东西。有趣的文化，比如澳大利亚，那里的人有很多有趣的表达方式。所以，我们确实会发现一些听起来像某种虾之类的东西，我们会剔除这些。然后我们会发现一些带有性暗示的东西，我们也会剔除。
(00:45:39):
我想说，大概每三四个项目中，就会有一个我们会剔除并永远不会展示给客户的名字。

---

### [00:45:49] Lenny Rachitsky

**English:**
And something you love and you're like, "Okay, I guess we can show that one"?

**中文翻译:**
那有没有那种你很喜欢，然后心想“好吧，我想我们不能展示这一个”的情况？

---

### [00:45:52] David Placek

**English:**
That's true. That happens. It does.

**中文翻译:**
没错。确实会发生。

---

### [00:45:55] Lenny Rachitsky

**English:**
You also said this really interesting thing about how every letter of the alphabet has a vibrance in an experience. Can you give a few examples of that? I know you're not the person doing that work specifically, but just what are some letter feelings?

**中文翻译:**
你还说过一件非常有趣的事，就是字母表中的每个字母在体验中都有其活力。你能举几个例子吗？我知道你不是专门做那项工作的，但字母都有哪些感觉？

---

### [00:46:11] David Placek

**English:**
The work is from the linguist, but at this point, I'm pretty adept in it. So, let's look at... I'll start with the letter V because it is so illustrative of what this is about. V, from our research that we've done, is the most alive and vibrant sound in the English alphabet. And that's whether you were born in Rome or in Sausalito, California. So if you know that, if you know that as you go around the world, there are going to be some exceptions to it. It's going to have that vibrancy. Look at Corvette. They probably didn't know about V, but it's a perfect name for a car that's fast and has a big engine that roars. Think about Viagra, same idea. And there's been surprises to us. B, the sound of the letter B is one of the most reliable sounds in the English alphabet. That was one of our rationales, by the way, for Blackberry. Because that's another example of a client who thought we were... I mean, the founder actually said, "I thought the people at Lexicon were crazy," when they presented Blackberry.

**中文翻译:**
那项工作是由语言学家完成的，但到目前为止，我也相当精通了。让我们来看看……我先从字母 V 开始，因为它非常能说明问题。根据我们的研究，V 是英语字母表中“最鲜活、最充满活力”的声音。无论你出生在罗马还是加利福尼亚州的索萨利托，都是如此。所以如果你知道这一点，即使在世界各地会有一些例外，它依然具有那种活力。看看 Corvette（克尔维特跑车），他们当时可能不知道 V 的奥秘，但对于一辆速度极快、发动机轰鸣的汽车来说，这是一个完美的名字。想想 Viagra（万艾可/伟哥），也是同样的道理。还有一些让我们惊讶的发现：B，字母 B 的声音是英语字母表中最“可靠”的声音之一。顺便说一句，这也是我们为 Blackberry（黑莓）命名的理由之一。因为那是另一个例子，客户当时觉得我们……我的意思是，创始人实际上说过：“当他们提交 Blackberry 这个名字时，我觉得 Lexicon 的人都疯了。”

---

### [00:47:29] David Placek

**English:**
And we said, "Well, let's stop and look at some of the assets here. First off, black color's technology. Yes, not everybody knows the word berry, but we have those two Bs." We talked about the nature of a compound. And all of a sudden, people at least lean forward to consider it as opposed to rejecting it too fast. So, those are just two examples. I mentioned Z in Azure, that's noisy letter. X is fast and crisp as a sound. And of course, there's semantic value to all of these letters, too. X is about innovation from aircraft to computers. And so, you have to look at the semantics of it and the sound symbol of it.

**中文翻译:**
我们说：“好吧，让我们停下来看看这里的一些资产。首先，黑色代表技术。是的，不是每个人都知道 berry（莓果）这个词，但我们有两个 B。” 我们谈到了复合词的本质。突然之间，人们至少愿意倾听并考虑它，而不是太快拒绝。所以，这只是两个例子。我提到了 Azure 中的 Z，那是一个有噪音的字母。X 的声音快速而清脆。当然，所有这些字母也都有语义价值。X 代表创新，从飞机到计算机都是如此。所以，你必须观察它的语义和它的语音象征。

---

### [00:48:15] Lenny Rachitsky

**English:**
This is so fascinating. I could listen to this stuff all day. Just thinking about Vercel with the V, that very aligns with what they're trying to do. Just very strong, opinionated way of working. And Guillermo, he feels like a V person.

**中文翻译:**
这太迷人了。我可以听一整天。想想带 V 的 Vercel，这非常符合他们想做的事情。一种非常强大、有主见的工作方式。而 Guillermo，他感觉就像一个“V 型人”。

---

### [00:48:29] David Placek

**English:**
He is. And there's an example of a group that had a lot of confidence, and what their product is is very innovative. And so, we had permission there to create something new because Vercel is a coin solution., right? But notice that we put some very simple, easy to process things together there. Or ver, in this case. So we have in vino veritas, truth in wine, things like that. You have verde, green. So, very familiar. And then their cel, like accelerate, something which is really what they do. They accelerate a client's performance. So, that was a relatively easy name for us to present and we were excited about for them to grasp.
(00:49:26):
By the way, that's known as processing fluency, which is when you think about how the brain processes information. We're told by a number of cognitive science that our brains are a little bit on the lazy side. We don't like complex things. And so, we really strive to make all of our solutions relatively easy for the brain to process. So it wants, it leans in towards them as opposed to, "I'm too busy. I'm walking past that." Names that are complicated, it's a liability. And we really avoid that. But Vercel, perfect fluency.

**中文翻译:**
他是。那是一个非常有信心的团队，他们的产品非常创新。所以我们得到了许可去创造一些全新的东西，因为 Vercel 是一个“造词”方案，对吧？但请注意，我们将一些非常简单、易于处理的元素放在了一起。在这个案例中是“ver”。我们有“in vino veritas”（酒后吐真言），诸如此类。你有“verde”（绿色）。所以，非常熟悉。然后是“cel”，就像“accelerate”（加速），这正是他们所做的——他们加速客户的性能。所以，那是一个对我们来说相对容易展示的名字，我们也为他们能领会而感到兴奋。
(00:49:26):
顺便说一句，这被称为“加工流畅性”（processing fluency），即大脑处理信息的方式。许多认知科学家告诉我们，我们的大脑有点懒惰。我们不喜欢复杂的东西。因此，我们真的努力使我们所有的解决方案都相对容易让大脑处理。这样大脑就会想要它，向它倾斜，而不是想“我太忙了，我直接走过去”。复杂的的名字是一种负担。我们真的会避免这种情况。但 Vercel，具有完美的流畅性。

---

### [00:50:13] Lenny Rachitsky

**English:**
Okay, let's go back, actually, to the three steps. So we covered two, and it took us on a long tangent to dive into a lot of the stuff you shared with the second step, which you call invent. So, it's essentially the three steps are... Was it create? What would you call it? The step?

**中文翻译:**
好，让我们回到那三个步骤。我们已经讲了两个，虽然我们花了很多时间深入探讨你分享的第二步（你称之为“发明”）。所以本质上这三个步骤是……是“创造”吗？你管那一步叫什么？

---

### [00:50:26] David Placek

**English:**
Yeah, it's identify. Invent.

**中文翻译:**
是的，是“识别”、“发明”。

---

### [00:50:27] Lenny Rachitsky

**English:**
Identify.

**中文翻译:**
识别。

---

### [00:50:29] David Placek

**English:**
And I use the word invent with intention because it's more than creative. And then the final thing is implement. Now for us, we're not a design firm. We're really focused on brand names and the nomenclature that supports the name. But for us, implement is helping the client team, if they choose, for us to help them with the presentations as it goes up the chain. To help them write a longer rationale for why these names, if they're presenting three names to the president of their company or the CMO, why these names make a lot of sense, and to help them develop what we call prototypes. So we'll put the name on a baseball cap, on a T-shirt. We'll put the name in a mock-up ad in the Wall Street Journal. Something's very positive. Because of Procter & Gamble's new blank product. P&G shares, they gain 10% this year. So that executives can see that the lift that that name can have. That's our implementation phase for them.

**中文翻译:**
我有意使用“发明”这个词，因为它不仅仅是创意。最后一步是“执行”。对我们来说，我们不是一家设计公司。我们真正专注于品牌名称以及支持该名称的命名体系。但对我们来说，“执行”是帮助客户团队（如果他们选择的话），在向高层汇报时协助他们进行演示。帮助他们写出更详尽的理由，说明为什么这些名字（如果他们向公司总裁或 CMO 展示三个名字）非常有意义，并帮助他们开发我们所谓的“原型”。所以我们会把名字印在棒球帽上、T 恤上。我们会把名字放在《华尔街日报》的模拟广告中。一些非常正面的东西，比如“由于宝洁公司的新 [空白] 产品，宝洁股价今年上涨了 10%”。这样高管们就能看到那个名字能带来的提升。这就是我们为他们做的执行阶段。

---

### [00:51:44] David Placek

**English:**
And we also do consumer research or customer research at that stage, and we do that probably about 50% of the time on our projects where we're going out and we're really talking to their customers, and putting the names in a series of drills. Drills that make them not the marketing person for the day, but we're really making these customers feel that this is a new brand. And then, we're asking about expectations. We're seeing how these names fire their imagination. And that's the most important thing in research, not is the name popular, are they comfortable with it, does it fit to concept. If you're asking people is this fit to concept, you are inevitably always going to get a descriptive name.

**中文翻译:**
在那个阶段，我们还会进行消费者研究或客户研究，大概 50% 的项目会这样做。我们会走出去，真正与他们的客户交谈，并将名字放入一系列演练中。这些演练不是让他们充当一天的营销人员，而是让这些客户真正感觉到这是一个新品牌。然后，我们会询问期望。我们观察这些名字如何激发他们的想象力。这是研究中最重要的事情，而不是看这个名字是否受欢迎、他们是否感到舒服、它是否符合概念。如果你问人们“这是否符合概念”，你不可避免地总是会得到一个描述性的名字。

---

### [00:52:31] Lenny Rachitsky

**English:**
You make such a good point about how you need to arm the people working with you with ammo to win over other folks internally. Because if the person working with you is on board and the name is bold and not an obvious winner, I could see it being important to be like, "Here's what you should all show them to help them see the story, and the mock-ups, and all of that."

**中文翻译:**
你提出了一个非常好的观点，即你需要为与你合作的人提供“弹药”，以赢得内部其他人的支持。因为如果与你合作的人已经认同了，而那个名字很大胆且不是那种显而易见的赢家，我能看出提供“你应该向他们展示这些，以帮助他们看到故事、模型等等”是多么重要。

---

### [00:52:53] David Placek

**English:**
Yes. And what's really important is to help their management see this in the context of the marketplace and their customers. This is a very human thing, but people want their boss to be happy. They want to be okay with their boss. And so they're thinking about, "I don't know if my boss would like this." He's more conservative or she's more conservative. We try in a very diplomatic way to say, "This has nothing, really, in the end to do with your boss. It has to do with the marketplace."
(00:53:27):
Well, that's easy for me to say because I'm not working at a P&G or an Intel, but we really try to give that advice for it because it is about being successful in the marketplace. And so first of all, we try to separate the clients that we work with. We really want to work with clients that play to win, that want to win, not just want to not lose in a marketplace. And so, we try to encourage our direct clients to lead the process to really say, if a manager or a CMO or a president says, "Look, we're the team that's going to execute on this and we believe in this. We can make this work," they usually rally around it. They usually do. But if you're just taking names up to a manager and saying, "What do you think?" There's a different outcome offered.

**中文翻译:**
是的。真正重要的是帮助他们的管理层在市场和客户的背景下看待这个问题。这是人之常情，人们希望老板开心，希望和老板相处融洽。所以他们会想：“我不知道我老板会不会喜欢这个。” 他或她可能比较保守。我们尝试以一种非常外交的方式说：“这最终其实与你的老板无关，它与市场有关。”
(00:53:27):
嗯，这对我来说很容易说，因为我不在宝洁或英特尔工作，但我们真的努力给出这样的建议，因为这关乎在市场上取得成功。所以首先，我们尝试筛选我们合作的客户。我们真的想与那些“为了赢而战”的客户合作，他们想要赢，而不仅仅是想在市场上“不输”。因此，我们尝试鼓励我们的直接客户主导流程，真正去说——如果一位经理、CMO 或总裁说：“看，我们是负责执行这个项目的团队，我们相信这个名字。我们可以让它奏效，” 他们通常会团结起来支持它。他们通常会。但如果你只是把名字拿给经理问“你觉得怎么样？”，结果往往大不相同。

---

### [00:54:28] David Placek

**English:**
So, we like to be in that implementation phase because we have so much experience. And usually, credibility with people.

**中文翻译:**
所以，我们喜欢参与执行阶段，因为我们有丰富的经验，而且通常在人们心中有公信力。

---

### [00:54:37] Lenny Rachitsky

**English:**
And you said that you come up with 3 to 4,000 names. That's the top of the funnel?

**中文翻译:**
你刚才说你们会想出 3000 到 4000 个名字。那是漏斗的最顶端吗？

---

### [00:54:41] David Placek

**English:**
Yeah. And just to clarify that, it's ideas, directions. It's not-

**中文翻译:**
是的。澄清一下，那是想法、方向。并不是——

---

### [00:54:50] Lenny Rachitsky

**English:**
Complete ready-to-ship names.

**中文翻译:**
完全可以直接使用的名字。

---

### [00:54:51] David Placek

**English:**
Yeah, not ready-to-ship names at all.

**中文翻译:**
是的，完全不是可以直接使用的名字。

---

### [00:54:53] Lenny Rachitsky

**English:**
Got it.

**中文翻译:**
明白了。

---

### [00:54:54] David Placek

**English:**
This is a very inefficient process and a little chaotic. So in that list of 3,000 names is probably 250 potential diamonds that have to be fractured and examined.

**中文翻译:**
这是一个非常低效且有点混乱的过程。在那 3000 个名字的清单中，可能有 250 个潜在的钻石，需要被切割和检验。

---

### [00:55:10] Lenny Rachitsky

**English:**
I really want to see just a documentary of this process at some point. This is the closer we're going to get for now, but this is so interesting.
(00:55:17):
I want to ask about how you would approach this if you're just a startup that doesn't have the time or resource to do this. But before I do that, is there anything else around the process that you guys go through with clients that you think is important to share or they think might surprise people?

**中文翻译:**
我真的很想在某个时候看到这个过程的纪录片。目前这是我们能接触到的最接近的版本了，但这太有趣了。
(00:55:17):
我想问问，如果你只是一家没有时间或资源做这些的初创公司，你会如何处理这件事？但在那之前，关于你们与客户合作的流程，还有什么你认为重要或可能让人们感到惊讶的事情要分享吗？

---

### [00:55:30] David Placek

**English:**
I think we've covered it. I do.

**中文翻译:**
我想我们已经涵盖了。是的。

---

### [00:55:31] Lenny Rachitsky

**English:**
Okay, great. Awesome. Okay, so most people listening to this, there's a lot of founders, a lot of PMs on product teams. They're working on a new feature, they're about to launch a product, they got accepted into YC and they're about to launch a product. Then they have, I don't know, let's say they have a couple of weeks. We've got to come up with a name. What should they do?

**中文翻译:**
好的，太棒了。那么，听这个节目的多半是创始人，或者是产品团队的 PM。他们正在开发一个新功能，或者即将发布一个产品，或者刚被 YC 录取并准备发布产品。然后他们只有，我不知道，假设只有两周时间。必须想出一个名字。他们该怎么办？

---

### [00:55:50] David Placek

**English:**
So the first thing I do is to say, okay, let's forget about developing the name for right now. And I will have them, and I think this is a good exercise for anybody. We do it here internally when we think about our business. So I say, just... Because most of this now, because of COVID, is on video. And I will say, "Just draw a shape of a diamond on a piece of paper in front of you." And I said, "On the top of that diamond, put the word win. How do you define winning is really it?" I said, "Now on that other next corner of the diamond, what do you have to win? Write that down. On the bottom, what do you need to win? And then on that final angle on the left-hand side, what do you have to say to win?" Then I said, "Now, let's go all the way to that final thing of what do you have to say to win."

**中文翻译:**
所以我做的第一件事就是说：好吧，现在先忘掉起名字这件事。我会让他们做一个练习，我认为这对任何人都适用。我们内部思考业务时也会这样做。我会说，就在你面前的纸上画一个菱形（diamond）。我说：“在这个菱形的顶端，写上‘赢’（win）这个词。你如何定义‘赢’才是关键？” 我说：“现在在菱形的下一个角，写下‘你拥有什么可以赢？’（what do you have to win?）。在底部，写下‘你需要什么才能赢？’（what do you need to win?）。然后在左边的最后一个角，写下‘为了赢你必须说什么？’（what do you have to say to win?）。” 然后我说：“现在，让我们一直走到最后那个‘为了赢你必须说什么’的问题。”

---

### [00:56:49] David Placek

**English:**
And that's where you just get people thinking about, "Well, what we really have here is... And we're better than this." And then I'll just say, "Okay. Now, what you want to take that this really should be about experience and behavior. How do you want to behave in the marketplace? How do you want the marketplace to behave towards you? And what kind of experience are you creating?" And then they'll start talking a little bit. I'll say, "Now, you just need to probe on that. You need to keep going. You need to look at metaphors because this is about experience." And I'll just give them some of our examples that we've talked about, "Blackberry, it says to the marketplace, they're not like the other guys." Think of something like Google versus Infoseek, right? Google is an experience. Google says, "I don't know what these guys are going to do, but it's not this practical mundane Infoseek." And that's what attracts people.

**中文翻译:**
这就是你让人们开始思考的地方：“嗯，我们真正拥有的是……我们比这个更好。” 然后我会说：“好。现在，你要意识到这实际上应该是关于体验和行为的。你希望在市场上如何表现？你希望市场对你如何表现？你正在创造什么样的体验？” 然后他们会开始聊一点。我会说：“现在，你只需要深入挖掘。你需要继续前进。你需要寻找隐喻，因为这关乎体验。” 我会给他们举一些我们讨论过的例子，“Blackberry 向市场宣告，他们和别人不一样。” 想想 Google 对阵 Infoseek，对吧？Google 是一种体验。Google 传达的是：“我不知道这些家伙要做什么，但它绝不是这种实用、平庸的 Infoseek。” 这就是吸引人的地方。

---

### [00:57:54] David Placek

**English:**
And so I'll do a little coaching like that, and then that usually kind of sets them free. And they're now thinking about it not as a word, which has maybe limited value, but as creating an experience which has the potential for unlimited value.

**中文翻译:**
我会做一些这样的指导，然后这通常会让他们获得解放。他们现在不再把名字看作一个词（其价值可能有限），而是看作在创造一种具有无限价值潜力的体验。

---

### [00:58:12] Lenny Rachitsky

**English:**
Okay. Let me try to reflect this back for folks. So the advice is draw triangle. So, you're coming up with a name. Draw triangle. At the top, win. At the bottom-left, was it how do you win?

**中文翻译:**
好。让我试着为听众复述一下。建议是画一个三角形。所以，你要想一个名字。画个三角形。顶端是“赢”。左下角是“你如何赢”吗？

---

### [00:58:25] David Placek

**English:**
Yeah. So, the diamond is two triangles.

**中文翻译:**
是的。菱形其实是两个三角形。

---

### [00:58:27] Lenny Rachitsky

**English:**
Oh, diamond. Okay, I see. I have triangle in my mind.

**中文翻译:**
噢，菱形。好，我明白了。我脑子里想的是三角形。

---

### [00:58:28] David Placek

**English:**
I got you.

**中文翻译:**
我懂你。

---

### [00:58:30] Lenny Rachitsky

**English:**
Okay, got it. Diamond. Great.

**中文翻译:**
好，明白了。菱形。太棒了。

---

### [00:58:31] David Placek

**English:**
And so on that next angle there on the right side is, what do you have to win already? Right? Because they wouldn't be either in a Y Combinator or getting some seed money if they didn't have something to win. And often, people, startups don't appreciate how much they actually do have to win because they're so busy and so stressed on what they're doing. And then, what do they need to win? And then finally, what do you need to say? And then back up to defining what is winning to us? Which, by the way, we start with that question usually on an assignment that we've been awarded. And if we're in a room with five people, all five people have a different definition of what... Their definition of that company winning. And that's good to sort that out because we can move down different avenues from a creative standpoint.

**中文翻译:**
所以在右边的下一个角是：你已经拥有什么可以赢的资本？对吧？因为如果他们没有什么可以赢的东西，他们就不会进入 Y Combinator 或获得种子资金。初创公司的人往往意识不到他们实际上拥有多少赢的资本，因为他们太忙了，压力太大了。然后是，他们需要什么才能赢？最后是，你需要说什么？然后回到定义“对我们来说，赢是什么？” 顺便说一句，我们通常在接到任务后首先问这个问题。如果房间里有五个人，五个人对公司获胜的定义可能都不一样。理清这一点很好，因为我们可以从创意的角度走向不同的道路。

---

### [00:59:31] Lenny Rachitsky

**English:**
Let's just make sure people have these phrases because this is awesome. And I imagine many people are going to be taking notes and like, "Cool. I'm going to do this." I hope so say the four points of the diamond again just so folks can write it all down.

**中文翻译:**
让我们确保大家记下了这些短语，因为这太棒了。我想很多人都会记笔记，然后想“酷，我要试试这个”。希望如此，请再重复一遍菱形的四个点，好让大家记下来。

---

### [00:59:42] David Placek

**English:**
At the top of the diamond is just the word win, and underneath that is how do we define winning for us as a company. And that can start off being simple, like we want to be the dominant player here. But you really have to work at that. What does that really mean, right? The second on that right-hand tip there of the diamond is what do we have to win? What are we doing now that makes us a winner? Then we go down to the bottom of the diamond, and it's what do we need to win? There could be technical things there. People talk about talent and resources. Often there, they'll say, "We need a good name." We always correct that. It's not the good name, it's the right name.

**中文翻译:**
菱形的顶端就是“赢”这个词，下面是“我们作为一家公司如何定义赢”。这可以从简单的开始，比如“我们想成为这里的霸主”。但你真的得深入思考，那到底意味着什么？菱形右侧的第二个点是“我们拥有什么可以赢？” 我们现在做的什么事情让我们成为赢家？然后我们走到菱形的底部，即“我们需要什么才能赢？” 那里可能有一些技术性的东西。人们会谈论人才和资源。通常在那里，他们会说“我们需要一个好名字”。我们总是纠正这一点：不是“好名字”，而是“正确的名字”。

---

### [01:00:28] David Placek

**English:**
And then finally is what do we need to say? And that's where I say, that's where you want to spend some time in really thinking about all the things you need to say, that you can say or you would even like to say, which maybe right now you can't say. But you want to a name that actually is going to have the flexibility as to when you can say that, it still works. And that gets them into behavior and experience. And that usually launches a really a good discussion with founders internally.

**中文翻译:**
最后是“我们需要说什么？” 这就是我说你应该花时间真正思考的地方：所有你需要说的、你能说的、甚至是你想要说但也许现在还不能说的事情。你想要一个具有灵活性的名字，这样当你以后可以说那些话时，它依然有效。这会引导他们进入行为和体验的思考。这通常会在创始人内部引发一场非常好的讨论。

---

### [01:01:03] Lenny Rachitsky

**English:**
When you say you have to win though, what you're thinking about there is what is it that you have that will help you win? And then what is it you need to have this win?

**中文翻译:**
当你提到“拥有什么可以赢”时，你考虑的是你拥有的哪些东西会帮助你获胜？然后是你需要拥有什么才能获得这次胜利？

---

### [01:01:10] David Placek

**English:**
Yes, that's right. And all companies are in that same situation. They have a bunch of stuff, but they need... A P&G might say, "We need a good distributor."
(01:01:19): "Okay. All right, we'll put that on the list."
(01:01:24): And then you might say, "Well, we need in..." When it gets to what do we have to say, we have to say the right things so that a distributor is interested in us. And then you go down an avenue there. Well, what is that? And if you work at it, this is not a one-hour exercise, it may be an exercise repeated over the next 4 or 5 days.

**中文翻译:**
是的，没错。所有公司都处于同样的情况。他们有一堆东西，但他们需要……宝洁可能会说：“我们需要一个好的分销商。”
(01:01:19): “好的，把它列入清单。”
(01:01:24): 然后你可能会说：“嗯，我们需要在……” 当谈到“我们必须说什么”时，我们必须说正确的话，以便分销商对我们感兴趣。然后你就沿着这条路走下去。那是什么？如果你认真对待，这不是一个小时的练习，它可能是在接下来的 4 或 5 天里重复进行的练习。

---

### [01:01:49] Lenny Rachitsky

**English:**
Okay. So, you have this diamond. And then the idea is just sit and put names down in a Google Doc, let's say.

**中文翻译:**
好。所以，你有了这个菱形。然后想法就是坐下来，在 Google 文档里写下名字，对吧。

---

### [01:01:55] David Placek

**English:**
Yeah. And then you start. But there is this... And maybe, it's naivete. I guess, that's probably the best word for this is that, because I do hear this all of the time. "Hey, we've worked at this, we got a list of 200 names, but we don't think there's something there."
(01:02:19): And I'll say, "Well, 200 names is not enough. Get to 1,000, 1,500 names and directions. Don't evaluate them. Just generate names, and directions, and ideas, and then have a meeting. And don't evaluate but speculate." What could we do with this name? What's the potential here? There's a lot of overevaluation in our industry. It makes sense. We survive as humans because we figure out what's wrong with this picture. If I want to cross the street, is it safe to cross the street? What's going on? Those kinds of things. You have to counter that. You have to say, "Let's just suspend judgment for a while. And let's do an exercise here where we take these 10 names that we think might work and what are we going to do with it." Because it's how you execute.

**中文翻译:**
是的，然后你开始。但存在这样一种……也许是天真吧，我想这是最合适的词，因为我一直听到这种说法：“嘿，我们努力过了，我们列了 200 个名字，但我们觉得里面没有合适的。”
(01:02:19): 我会说：“嗯，200 个名字是不够的。要达到 1000、1500 个名字和方向。不要评估它们。只是生成名字、方向和想法，然后开个会。不要评估，而是去‘推测’（speculate）。” 我们可以用这个名字做什么？这里的潜力是什么？在我们的行业中存在大量的过度评估。这很有道理，人类之所以能生存，是因为我们能发现画面中哪里不对劲。如果我想过马路，过马路安全吗？发生了什么？诸如此类。你必须反其道而行之。你必须说：“让我们先暂停评判一段时间。让我们做一个练习，拿出这 10 个我们认为可能有效的名字，看看我们能用它们做什么。” 因为关键在于你如何执行。

---

### [01:03:21] David Placek

**English:**
Going back to windsurf, as we showed them pictures of people windsurfing and waves and things, if they said, "Ah, that just doesn't work for us at all. I'm very uncomfortable with." Well, then it's not their name. But they leaned into it, "Okay, I can see this. It's easy for us to execute. It's dynamic, it's different." So, that's why we build these prototypes for people. And that's what... I think the best advice I can give to whether it's a startup or someone starting a new cookie company, is it's not just a list of 200 names. It's 10 or 15 lists of 200 names. And it's thinking about what do we have to say here? What behavior? How do we want people to feel in the marketplace about us? I imagine with Google, people felt relief that it wasn't a descriptive name. That there was something new out there in the marketplace.

**中文翻译:**
回到 Windsurf，当我们向他们展示人们冲浪、海浪之类的图片时，如果他们说：“啊，这完全不适合我们，我感到很不舒服。” 那么，那就不是他们的名字。但他们投入其中，说：“好，我能看到这个。这对我们来说很容易执行。它很动感，很独特。” 所以，这就是为什么我们为人们构建这些原型。我认为我能给出的最好建议，无论是初创公司还是开饼干公司的人，就是：这不仅仅是一份 200 个名字的清单，而是 10 到 15 份 200 个名字的清单。并且要思考：我们在这里必须说什么？什么行为？我们希望市场对我们有什么感觉？我猜对于 Google，人们感到一种解脱，因为它不是一个描述性的名字。市场上出现了一些全新的东西。

---

### [01:04:20] Lenny Rachitsky

**English:**
Yeah. Infoseek, that's such a descriptive name now that I think about it.

**中文翻译:**
是的。Infoseek，现在想来那真是一个描述性的名字。

---

### [01:04:23] David Placek

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:04:24] Lenny Rachitsky

**English:**
Okay, so one more question along these lines. So say, you have a list of let's say 2,000 or 1,000 names. There's this tension between choosing something... Like, as a person that is doing them themselves. Your advice is choose something bold, not something descriptive. You won't know it when you see it. Very hard to do, obviously, when you're doing it by yourself. And you just advise for not losing sight of that piece. Just throwing out things that feel too scary, finding a name that's actually bold as you suggest.

**中文翻译:**
好，关于这一点我还有一个问题。假设你有一份 1000 或 2000 个名字的清单。在选择……比如作为一个自己动手的人，会有一种张力。你的建议是选择大胆的东西，而不是描述性的东西。你看到它时不会立刻知道。显然，当你自己做的时候，这很难做到。你只是建议不要忽视这一点吗？不要只是扔掉那些感觉太吓人的东西，而是像你建议的那样找一个真正大胆的名字。

---

### [01:04:55] David Placek

**English:**
First off, we disappear... Human psychology, humans only pay attention to what is new or what is different, I should say. So if you're looking at shoes and they're all black, black, black, black, and then the next pair of shoes is red, that's the first thing you focus on. And so, that usually gives people permission. They'll say, "Okay, I get that." So, look for what is really different between the names that you have on your list, but also what's different from what's out in the marketplace. Then you get a client like Microsoft saying, "Azure is different. There's going to be a lot of cloud stuff and..." There's a relevant point there, Azure is blue. And so, there's a slight logical connection that I think gave them more permission to move forward with it, frankly. But listen, this is not an easy task. I mean, that's why we're in this business, and why I felt we should be specialized because if you start doing design and/or advertising or other things, you can't have the intellectual engine.

**中文翻译:**
首先，我们会消失……人类心理学，人类只关注新的或不同的东西。所以如果你在看鞋子，它们全是黑的、黑的、黑的，然后下一双鞋是红色的，那是你首先关注的东西。这通常会给人们一种“许可”。他们会说：“好，我明白了。” 所以，寻找你清单上的名字之间真正不同的地方，也要寻找与市场上已有的东西不同的地方。然后你会遇到像微软这样的客户说：“Azure 是不同的。会有很多‘云’的东西，而且……” 这里有一个相关的点，Azure 是蓝色的。所以，有一种轻微的逻辑联系，坦率地说，我认为这给了他们更多推进这个名字的许可。但听着，这不是一项容易的任务。我的意思是，这就是为什么我们从事这个行业，以及为什么我觉得我们应该专业化，因为如果你开始做设计和/或广告或其他事情，你就无法拥有这种知识引擎。

---

### [01:06:16] David Placek

**English:**
You can't acquire the intellectual engine that we have. So I know it's difficult, but it can be done, and you just have to give yourself some time. But stop evaluating. Suspend judgment and speculate. That's my number one advice to people trying to do this on their own. Now, how can you get help? You can talk to your employees, but it's not so much, "What do you think of this name?" It's, "What do you think this name could do for us?" That's a much better question. If you go out and talk to friends who don't work for your company, there's a fun drill that I suggest. I said, "Listen, go out to them and say..." They'll know what you're doing. And say, "You know what? We just have a new competitor and their name is blank. What do you think about that?"

**中文翻译:**
你无法获得我们拥有的这种知识引擎。所以我知道这很难，但它是可以做到的，你只需要给自己一些时间。但停止评估。暂停评判并去推测。这是我对尝试自己动手的人的第一条建议。现在，你如何获得帮助？你可以和你的员工谈谈，但不要问“你觉得这个名字怎么样？”，而是问“你觉得这个名字能为我们做什么？” 这是一个好得多的问题。如果你去和不在你公司工作的朋友谈，我建议做一个有趣的演练。我说：“听着，去找他们说……” 他们会知道你在做什么。然后说：“你知道吗？我们刚出现了一个新竞争对手，他们的名字叫 [空白]。你觉得怎么样？”

---

### [01:07:10] David Placek

**English:**
What happens there is you're not asking them to give you an opinion to evaluate a name. You're asking them then what does that name do for you? The information you're getting is that name, they're telling you what that name does for them, how it helps them to imagine, which is a fundamental role of any name. Slight tangent, but I'm going to go to our kind of research. We do mostly quantitative research now, but for years, we did qualitative work. And we still do. But what we found in, we were always looking for the...
(01:07:49): I'll set it this way. We were always looking for this answer from consumers. If a consumer said, "I don't really know much about that new product, but I know that they're not like the other guys." That's when we knew we had a good name because they were... Now what happened there? I mean, the technical term that we use is that name will create a predisposition to consider this product because they're not like the other guys, as opposed to, "I already have something like that. I'm busy. I don't need another one of those things. I need something new and different, and hopefully better."

**中文翻译:**
这样做的好处是，你不是在要求他们提供评估名字的意见。你是在问他们：那个名字对你产生了什么影响？你获得的信息是，他们在告诉你那个名字对他们意味着什么，它是如何帮助他们想象的，而这是任何名字的基本作用。稍微跑个题，谈谈我们的研究。我们现在主要做定量研究，但多年来我们也做定性工作，现在依然在做。但我们发现，我们一直在寻找……
(01:07:49): 我这样说吧。我们一直在寻找消费者的这种回答。如果一个消费者说：“我不太了解那个新产品，但我知道他们和别人不一样。” 那时我们就知道我们得到了一个好名字，因为他们……现在发生了什么？我的意思是，我们使用的技术术语是，那个名字会创造一种“考虑该产品的倾向”，因为他们和别人不一样，而不是想“我已经有类似的东西了。我很忙。我不需要另一个那样的东西。我需要一些新的、不同的、希望是更好的东西”。

---

### [01:08:30] Lenny Rachitsky

**English:**
That's awesome. That's a good reminder. There's a quote that I found of yours that's exactly along these lines, "If your team is comfortable with the name, chances are you don't have the name yet."

**中文翻译:**
太棒了。这是一个很好的提醒。我发现你有一句话正是这个意思：“如果你的团队对这个名字感到很舒服，那很可能说明你还没找到那个对的名字。”

---

### [01:08:38] David Placek

**English:**
We look for polarization. We look for tension in a team about arguing about these things, because we think that polarization is a sign of strength in the word. And interesting story, the person who taught me that, honestly, was Andy Grove over the Pentium name, because... And I learned a lot from him. I always say this, I just was very fortunate to work with him on Pentium, and Xeon, and a few other things. But when we went to an executive committee to present Pentium... And by the way, internally, one of the names that... And makes sense here, descriptive, bunch of engineers, ProChip. "Hey, it's professional, it's premium, and it's chipped. So, it should be Prochip." So Andy had me give a presentation about the strengths of this thing, and he said, "Now, let me tell you why I think this is the right name."

**中文翻译:**
我们追求两极分化。我们寻找团队在争论这些事情时产生的张力，因为我们认为两极分化是这个词具有力量的标志。一个有趣的故事，老实说，教给我这一点的人是安迪·格鲁夫（Andy Grove），在讨论 Pentium（奔腾）这个名字的时候。我从他身上学到了很多。我总是这么说，我非常幸运能和他一起合作 Pentium、Xeon（至强）和其他一些项目。但当我们去执行委员会展示 Pentium 时……顺便说一句，内部当时有一个名字（在这里很有道理，描述性的，一群工程师想出来的）叫 ProChip。“嘿，它是专业的（professional），它是高端的（premium），而且它是芯片（chip）。所以它应该叫 ProChip。” 于是安迪让我做了一个关于这件产品优势的演示，然后他说：“现在，让我告诉你们为什么我认为这是正确的名字。”

---

### [01:09:56] David Placek

**English:**
He said, "Because I see the polarization here in it amongst people. There's this ProChip over here, there's the Pentium thing." He said, "That tells me there's energy for Pentium here." And he said, "That's why I think we should go with it." And I've never forgotten that. And so, we do look for that. And when we tell that story, people say, "You're right. There is... I mean, we are arguing about this, and there is an intensity with the name." And that's what you want. You don't want to go out in the marketplace, into this very competitive marketplace, regardless of the category, with something that doesn't have a level of boldness or intensity.

**中文翻译:**
他说：“因为我看到了人们对它的两极分化。这边有 ProChip，那边有 Pentium。” 他说：“这告诉我 Pentium 这里有能量。” 他说：“这就是为什么我认为我们应该选择它。” 我永远不会忘记那句话。所以，我们确实在寻找那种特质。当我们讲那个故事时，人们会说：“你是对的。确实……我的意思是，我们正在为此争论，这个名字确实有一种强度。” 而这正是你想要的。你不想带着一个缺乏大胆程度或强度的东西进入市场，进入这个无论什么类别都竞争极其激烈的市场。

---

### [01:10:33] Lenny Rachitsky

**English:**
That was an amazing story. Just again, so kind of a tip here is if half of your team or, I don't know, some percent of your team hates it, some percent of your team loves it, that's a good sign.

**中文翻译:**
这是一个精彩的故事。再次强调，这里的一个小技巧是：如果你的团队中有一半人（或者一定比例的人）讨厌它，而另一半人喜欢它，那是一个好兆头。

---

### [01:10:43] David Placek

**English:**
Yeah, it is. It is. Look for that polarization. That's what we look for.

**中文翻译:**
是的，没错。寻找那种两极分化。这就是我们追求的。

---

### [01:10:47] Lenny Rachitsky

**English:**
I also love this tip of asking people if, "Hey, our competitor just launched. They're called Windsurf." How your team reacts? If they're just like, "Oh, wow, that's a great name. I'm interested in that product." That's what you want to look for?

**中文翻译:**
我也很喜欢这个技巧，即问别人：“嘿，我们的竞争对手刚刚发布了，他们叫 Windsurf。” 看看你的团队反应如何？如果他们只是说：“噢，哇，那是个好名字。我对那个产品感兴趣。” 这就是你要寻找的反应吗？

---

### [01:10:59] David Placek

**English:**
Yes, exactly.

**中文翻译:**
是的，正是如此。

---

### [01:11:02] Lenny Rachitsky

**English:**
How important is the .com for the name you come up with? I imagine it's really hard to get these days. Just what do you think about domain name when you think about naming?

**中文翻译:**
对于你起的名字，.com 域名有多重要？我猜现在很难拿到了。当你考虑命名时，你对域名怎么看？

---

### [01:11:10] David Placek

**English:**
I am so glad you asked this question because at this point, it doesn't really matter at all. The .com or URL address has become an area code. And whether you're in 415 or 615, it doesn't really matter to people. And now with AI, SEO is going to be less important. And so, I just think the principle in play here is you got to get the right name first. And then if you can get the .com, sure, go ahead. But if you can't, there's ways around that. You can put a prefix in front of it or a little word in front of it or after it, or you go to .ai or something like that. But the principle in play is let's get the right name first.

**中文翻译:**
我很高兴你问这个问题，因为在目前这个阶段，它其实一点都不重要了。.com 或 URL 地址已经变成了一个“区号”。无论你是在 415 还是 615 区号，对人们来说都无所谓。现在有了 AI，SEO（搜索引擎优化）将变得不那么重要。所以，我认为这里的原则是：你必须先得到正确的名字。然后如果你能拿到 .com，当然好，去拿吧。但如果你拿不到，也有办法绕过去。你可以在它前面加个前缀，或者在前面或后面加个小词，或者用 .ai 之类的后缀。但核心原则是：先拿到正确的名字。

---

### [01:12:02] David Placek

**English:**
For those who really... And there are people who really get hung up on the .com, they tend to older by, the way. And have, in their mind, sort of the hotness of the internet and having a .com, which did make a difference 25 years ago. But it's 25 years now or 30, right? The good news is because they're less valuable, you can typically buy a URL if you negotiate the right way and have time for 15, 20, 25, $30,000. And we say, "Hey, if you can do that, have fun. I'd put the $30,000 into market."

**中文翻译:**
对于那些真的……顺便说一句，那些真的纠结于 .com 的人往往年纪较大。在他们的脑海中，还留着互联网热潮时期必须拥有 .com 的印象，这在 25 年前确实有影响。但现在已经是 25 年或 30 年后了，对吧？好消息是，因为它们没那么有价值了，如果你谈判得当且有时间，通常可以用 1.5 万、2 万、2.5 万或 3 万美元买到一个 URL。我们会说：“嘿，如果你能做到，那就去吧。但我宁愿把那 3 万美元投入市场推广。”

---

### [01:12:42] Lenny Rachitsky

**English:**
Awesome. That's reassuring. I imagine many founders are just like, "God dammit, there's no names available anymore." Let me zoom out and just ask you this question as a, maybe, a closing thought to our conversation.
(01:12:56): I'm going to just dive into a question. And the question is just what's a name that you came up with, and your team came up with, that you had to fight super hard for that the client just hated, and you ended up winning. And now, it's just such an obviously awesome name that everyone loves.

**中文翻译:**
太棒了。这让人宽心。我想很多创始人都会想：“该死，再也没有可用的名字了。” 让我放大视角，问你这个问题，作为我们对话的一个结语。
(01:12:56): 假设你正和某人一起坐电梯，我确信这经常发生在你身上，人家问：“嘿，David，我得想个名字。关于想出一个好名字，你最大的建议是什么？” 你的回答会是什么？

---

### [01:13:06] David Placek

**English:**
I'd go back to forget about the word, think about behavior and experience. And then the second thing from just a creative help, I'm a big believer in synchronicity. And we try to force synchronicity here, and I'll give you a couple examples of that. But this idea of connecting dots, two unrelated ideas together. And so I'll say, "Look, if someone says we make sailboats and I'm trying to..." I'm here in Sausalito. I guess, that's why I thought about that. And I am trying to create a new name for my company that builds sailboats.
(01:13:49): I would say forget about sailboats. I would go and pick out some magazines about hunting or flying magazines. And I would just look through those, get a notepad out, and put out words that you like. Things, expressions that you like. And then that synchronicity, I said, "I would bet you $5 that out of those two magazines, you will get a word that you never would've thought of, but somehow it would relate to sailing."

**中文翻译:**
我会回到那句话：忘掉那个词，思考行为和体验。第二点，从创意辅助的角度来看，我非常相信“共时性”（synchronicity）。我们在这里尝试强迫产生共时性，我给你举几个例子。就是这种“连接点”的想法，将两个不相关的想法联系在一起。所以我会说：“看，如果有人说我们制造帆船，而我正试图……” 我现在在索萨利托，我想这就是为什么我想到这个。我正试图为我制造帆船的公司起个新名字。
(01:13:49): 我会说，忘掉帆船。我会去挑一些关于狩猎的杂志或飞行杂志。我就翻翻那些杂志，拿个笔记本，写下你喜欢的词。你喜欢的事物、表达方式。然后那种共时性就会出现，我说：“我敢赌 5 美元，从那两本杂志中，你会得到一个你从未想过、但不知何故与航海相关的词。”

---

### [01:14:25] Lenny Rachitsky

**English:**
That connects very much to your story of how you have these different teams, and the teams that end up coming up with a winning name are the ones thinking about a very different version of that product.

**中文翻译:**
这与你讲的故事非常吻合，即你拥有这些不同的团队，而最终想出获胜名字的团队，往往是那些在思考该产品的完全不同版本的人。

---

### [01:14:35] David Placek

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:14:36] Lenny Rachitsky

**English:**
So interesting. Okay. David, this was everything I was hoping it'd be. I feel like we're going to help so many people. Is there anything that we haven't covered or that you want to leave listeners with as a final nugget or piece of advice or story before we get to our very exciting lightning round?

**中文翻译:**
太有趣了。好了，David，这正是我所希望的。我觉得我们会帮助到很多人。在我们进入非常令人兴奋的闪电轮（lightning round）之前，还有什么我们没涵盖的，或者你想留给听众的最后一点建议、忠告或故事吗？

---

### [01:14:55] David Placek

**English:**
I'm going to emphasize one point, I think, which is that I really would like the listeners to really begin to think about how valuable a brand name can be. That you're not just looking for a word, you're looking for this experience. And if you get it right, not just a good name but the right name, the value is almost unlimited. And so give yourself some time, give yourself a budget, give yourself the right resources to do that. Second thing is we try to really be helpful here, and so I am always happy to talk to people about where they are in a process and if we can help, or just give them a little bit of advice. And we schedule, we call them office hours here. We're judicious about it, but we are open to that. It's just playing a long-term game, so I'd like to leave that with the viewers also.

**中文翻译:**
我想强调一点，那就是我真的希望听众能开始思考品牌名称是多么有价值。你不仅仅是在寻找一个词，你是在寻找这种体验。如果你做对了，不仅是一个好名字，而且是一个正确的名字，其价值几乎是无限的。所以给自己一些时间，给自己一些预算，给自己合适的资源去做这件事。第二件事是，我们在这里真的努力提供帮助，所以我总是很乐意与人们谈论他们在流程中所处的位置，看看我们是否能提供帮助，或者只是给他们一点建议。我们在这里安排了所谓的“办公时间”（office hours）。我们对此很慎重，但我们持开放态度。这只是在玩一场长期游戏，所以我也想把这一点留给观众。

---

### [01:15:51] Lenny Rachitsky

**English:**
We're about to book out your office hours. I love that offer. I think a lot of people are going to take advantage of that. That is super cool.
(01:15:58): David, with that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
我们要把你的办公时间预订光了。我喜欢这个提议。我想很多人会利用这个机会。这超级酷。
(01:15:58): David，说到这，我们进入了非常令人兴奋的闪电轮。我有五个问题要问你。准备好了吗？

---

### [01:16:03] David Placek

**English:**
Yes, I'm ready.

**中文翻译:**
是的，准备好了。

---

### [01:16:05] Lenny Rachitsky

**English:**
There we go. What are 2 or 3 books that you find yourself recommending most to other people?

**中文翻译:**
开始。你最常向别人推荐的 2 到 3 本书是什么？

---

### [01:16:09] David Placek

**English:**
There's a book called Resilience, which was written by a former Navy SEAL that... And it's not about combat, it's just a tiny bit about being a SEAL. But it is about overcoming things and it's about tenacity. And I think everybody in the world, we all have challenges and things. And I do recommend that to people.
(01:16:31): Second book is Andrew Roberts latest book on Winston Churchill. Winston Churchill is, really, one of my heroes. He was one of the most unusual, provocative statesmen/politicians of the 20th century. And here's another person that talked about tenacity, and ups and downs, and stick with it. And so, I do like to recommend that. Some people just tipped their head and said, "Ah, I don't know." It seems like maybe a boring book, but those are two books that I [inaudible 01:17:02].

**中文翻译:**
有一本书叫《韧性》（Resilience），是由一名前海豹突击队队员写的……它不是关于战斗的，只有一小部分关于海豹突击队。它是关于克服困难和关于坚韧的。我认为世界上的每个人都会面临挑战。我向人们推荐这本书。
(01:16:31): 第二本书是 Andrew Roberts 关于温斯顿·丘吉尔的最新著作。温斯顿·丘吉尔真的是我的英雄之一。他是 20 世纪最不寻常、最具煽动性的政治家/政治人物之一。这是另一个谈论坚韧、起伏和坚持的人。所以我喜欢推荐这本书。有些人只是摇摇头说：“啊，我不知道。” 听起来可能是一本无聊的书，但这是我推荐的两本书。

---

### [01:17:02] Lenny Rachitsky

**English:**
Who would ever say that Churchill's story is boring? That's absurd.

**中文翻译:**
谁会说丘吉尔的故事无聊？那太荒谬了。

---

### [01:17:07] David Placek

**English:**
I think so. I agree. I agree It's absurd, yes.

**中文翻译:**
我也这么觉得。我同意，那很荒谬。

---

### [01:17:11] Lenny Rachitsky

**English:**
He's so fascinating. There's a recent documentary, I think, that really showed me the character. Incredible.
(01:17:18): Okay. What's a recent movie or TV show you've really enjoyed?

**中文翻译:**
他太迷人了。我想最近有一部纪录片真正向我展示了这个人物。不可思议。
(01:17:18): 好的。最近有什么你非常喜欢的电影或电视剧吗？

---

### [01:17:20] David Placek

**English:**
For me, it's the Yellowstone series. We're very fortunate as a family, we have some property in Montana. And-

**中文翻译:**
对我来说，是《黄石》（Yellowstone）系列。我们全家非常幸运，在蒙大拿州有一些房产。而且——

---

### [01:17:29] Lenny Rachitsky

**English:**
Oh, wow. You're living the life.

**中文翻译:**
噢，哇。你过着理想的生活。

---

### [01:17:31] David Placek

**English:**
Yeah, very... Listen, I can't tell you how fortunate I am. And I bought this property 28 years ago, so it was a lot cheaper then.
(01:17:40): In a snowstorm, and it just felt right. But I think particularly the 1883, the precursor to Yellowstone.

**中文翻译:**
是的，非常……听着，我无法告诉你我有多幸运。我是 28 年前买的这处房产，所以当时便宜得多。
(01:17:40): 在一场暴风雪中买下的，当时感觉很对。但我认为特别是《1883》，它是《黄石》的前传。

---

### [01:17:48] Lenny Rachitsky

**English:**
I was going to ask if you saw that because that was incredible.

**中文翻译:**
我正想问你有没有看那个，因为那部剧太棒了。

---

### [01:17:50] David Placek

**English:**
Yes. And then the after one, 1923, which is the post-war. 1883 really gives people a sense of what it took by those early Americans to build a life in a place like... A beautiful place but a hard, tough place like Montana. And it's just phenomenal. The person producing and writing those things is incredibly talented. Taylor Sheridan, I think, is his name.

**中文翻译:**
是的。然后是后传《1923》，那是战后的故事。《1883》真的让人们感受到早期美国人在像蒙大拿州这样一个美丽但艰苦、严酷的地方建立生活所付出的代价。这简直是现象级的。制作和编写这些作品的人非常有才华，我想他叫 Taylor Sheridan。

---

### [01:18:19] Lenny Rachitsky

**English:**
I love that in the story, Montana was the easy route almost from the journey they want on.

**中文翻译:**
我喜欢故事里的那个设定，蒙大拿州几乎是他们漫长旅程中相对容易的一段。

---

### [01:18:24] David Placek

**English:**
That's right. It's very, very true, yeah.

**中文翻译:**
没错。非常非常真实。

---

### [01:18:26] Lenny Rachitsky

**English:**
Oh, man. Yeah, you almost don't even need to watch Yellowstone. Just starting with 1883 totally works.

**中文翻译:**
噢，伙计。是的，你甚至几乎不需要看《黄石》。直接从《1883》开始看完全没问题。

---

### [01:18:32] David Placek

**English:**
Yeah. In fact, I recommend people. I say there's three. But if you really want the truth about the American West, it's 1883.

**中文翻译:**
是的。事实上，我向人们推荐。我说有三部，但如果你真的想了解美国西部的真相，那就是《1883》。

---

### [01:18:40] Lenny Rachitsky

**English:**
Yeah. I suggested that on this podcast a bunch, actually. So, I love that. That's where you went.
(01:18:45): Next question, do you have a favorite product that you have recently discovered that you really love? Maybe one you named, maybe not.

**中文翻译:**
是的。实际上我在这个播客里推荐过好几次。所以我很喜欢你提到了它。
(01:18:45): 下一个问题，你最近有没有发现什么非常喜欢的、心头好的产品？也许是你命名的，也许不是。

---

### [01:18:51] David Placek

**English:**
I didn't name it, although it's got a very good name to it. Our whole family, I have two daughters and my wife, we're all fly fishermen, and last summer I really... I bought this for myself, but I gave it to my wife. It was one of those things that was present for her, but I knew I was going to use it more. And it's a Hardy. It's an old British fly rod, but it's a beautiful rod. It's just perfect for the big rivers of Montana. So, that's my favorite purchase.

**中文翻译:**
我没给它命名，虽然它有一个非常好的名字。我们全家，我有两个女儿和我的妻子，都是飞钓（fly fishing）爱好者。去年夏天我真的……我给自己买了这个，但我把它送给了我妻子。那是那种送给她的礼物，但我知道我会用得更多。它是一个 Hardy。这是一个古老的英国飞钓竿，但它是一根非常漂亮的竿子。它非常适合蒙大拿州的大河。所以，这是我最喜欢的购买。

---

### [01:19:20] Lenny Rachitsky

**English:**
That's the first fly-fishing rod of the podcast. Excellent choice.
(01:19:24): Next question, do you have a favorite life motto that you often find yourself coming back to, sharing with friends or family?

**中文翻译:**
这是本播客出现的第一个飞钓竿。极佳的选择。
(01:19:24): 下一个问题，你有没有什么最喜欢的人生格言，是你经常会想起，或者与朋友家人分享的？

---

### [01:19:31] David Placek

**English:**
I do. And it's a little longer, so I wrote it. I have it written here somewhere, but it's the quote from T.E. Lawrence, Lawrence of Arabia, here. And if I can find it, I should be. I think it's a wonderful quote, so I think hopefully your viewers will like this. Here's what he said. He said that, "All men dream, but not equally. Those who dream by night in the dusty recesses of their minds wake in the day to find that it was vanity, but the dreamers of the day are dangerous men for they may act on their dreams with open eyes to make them possible."
(01:20:14): I read that years ago and it just hit me pretty hard, so yeah.

**中文翻译:**
有的。它有点长，所以我写了下来。我把它写在某个地方了，是 T.E. 劳伦斯（即“阿拉伯的劳伦斯”）的一段话。如果我能找到它……应该是。我认为这是一段精彩的引言，希望你的观众会喜欢。他是这样说的：“所有人都做梦，但梦境各异。那些在夜晚、在头脑尘封的角落里做梦的人，白天醒来发现那只是虚幻；但那些在白天做梦的人是危险的，因为他们睁着眼睛行事，使梦想成真。”
(01:20:14): 我多年前读到这段话，它深深地触动了我。

---

### [01:20:21] Lenny Rachitsky

**English:**
That is an amazing quote. It makes me think about the quote about the man in the arena.

**中文翻译:**
这是一段了不起的引言。它让我想起了关于“竞技场上的人”的那段名言。

---

### [01:20:25] David Placek

**English:**
Yes. Yeah, it's same idea. It's just a little different. And I also think Lawrence of Arabia is a fascinating person, what he did. So, inspiring in some ways.

**中文翻译:**
是的。是的，意思差不多，只是表达方式略有不同。我也认为阿拉伯的劳伦斯是一个迷人的人，他的所作所为在某些方面非常鼓舞人心。

---

### [01:20:38] Lenny Rachitsky

**English:**
An amazing movie.
(01:20:40): Okay, final question. Let me just try this. Is there a name that you didn't name that you're just like, "Wow, that was an amazing name. I wish I had come up with that name"?

**中文翻译:**
那是一部了不起的电影。
(01:20:40): 好的，最后一个问题。让我试着问这个：有没有哪个名字不是你起的，但你觉得“哇，那真是个了不起的名字，我真希望是我出的主意”？

---

### [01:20:49] David Placek

**English:**
I'll tell you there is one name, and it's DreamWorks. I think it's a wonderful name, and it's somewhat ironic that the entertainment industry in general has pretty mundane names. You have all of these talented people. And yet when you look at the names of production studios, movie houses, Comcast, things like that, it's very mundane. But here's DreamWorks, just like Sonos, check all the boxes. Compound dream. You expect something great from DreamWorks. They've created an experience, the experience of dreaming in a movie. I think it's a wonderful name. I wish I'd done it.

**中文翻译:**
我会告诉你有一个名字，那就是 DreamWorks（梦工厂）。我认为这是一个美妙的名字。有点讽刺的是，娱乐行业的名字通常都很平庸。你拥有所有这些才华横溢的人，然而当你观察制作工作室、电影公司、Comcast 之类的名字时，它们都非常平庸。但 DreamWorks 就像 Sonos 一样，符合所有要求。复合词“梦”（dream）。你期待从梦工厂得到伟大的作品。他们创造了一种体验，即在电影中做梦的体验。我认为这是一个绝佳的名字。我希望是我起的。

---

### [01:21:39] Lenny Rachitsky

**English:**
That's such a cool answer. David, thank you so much for doing this. This was incredible. I learned a ton as I imagined. I feel like a lot of people are going to have a much easier time thinking about approaching this topic.

**中文翻译:**
这是一个非常酷的回答。David，非常感谢你做这些。这太不可思议了。正如我预想的那样，我学到了很多。我觉得很多人在思考如何处理这个话题时会变得容易得多。

---

### [01:21:50] David Placek

**English:**
Well, I certainly hope so. I do. It's been very, very enjoyable, very thoughtful, and I have nothing but or respect for the way you do this and the talent that you have. So, very fortunate that we've come together. And we live in the same place, so maybe we can get together for a cup of coffee or something.

**中文翻译:**
嗯，我当然希望如此。确实。这次交流非常愉快，非常有深度，我对你主持节目的方式和你的才华充满敬意。所以，很高兴我们能聚在一起。而且我们住在同一个地方，也许我们可以一起喝杯咖啡什么的。

---

### [01:22:10] Lenny Rachitsky

**English:**
We do. Northern California for the win. Thank you so much for being here.

**中文翻译:**
是的。北加州万岁。非常感谢你能来。

---

### [01:22:14] David Placek

**English:**
You're very welcome.

**中文翻译:**
不客气。

---

### [01:22:16] Lenny Rachitsky

**English:**
Bye everyone.

**中文翻译:**
大家再见。

---

### [01:22:17] David Placek

**English:**
Take care.

**中文翻译:**
保重。

---

### [01:22:19] Lenny Rachitsky

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。