# Deb Liu - 双语对照

# Lenny's Podcast: Deb Liu (Full Bilingual Transcript)

---

### (00:00:00) Lenny Rachitsky

**English:**
You're VP of product at Facebook. You're director at eBay and PayPal. You're on the board of Intuit. You've been the CEO of Ancestry now for the past three and a half years. This is a career path that a lot of people dream of.

**中文翻译:**
你曾任 Facebook 的产品副总裁，担任过 eBay 和 PayPal 的总监，还是 Intuit 的董事会成员。过去三年半里，你一直担任 Ancestry 的首席执行官。这是许多人梦寐以求的职业路径。

---

### (00:00:11) Deb Liu

**English:**
Some of the best PMs I have ever worked with are terrible PMs for their career. They just drift from job to job. "Hey, should I take this role or this role? How do I think about this?" But if I said you had to write a spec for your career, what does success look like? How are you going to get there?

**中文翻译:**
我合作过的一些最优秀的产品经理（PM），在经营自己的职业生涯方面却表现得很糟糕。他们只是在不同的工作间漂泊。“嘿，我该接这个职位还是那个职位？我该怎么考虑这个？”但如果我说你必须为自己的职业生涯写一份规格说明书（Spec），成功是什么样子的？你打算如何实现它？

---

### (00:00:24) Lenny Rachitsky

**English:**
You wrote this awesome post about introverts and how hard it is to be successful as an introvert.

**中文翻译:**
你写过一篇关于内向者的精彩文章，讲述了作为一名内向者在职场中取得成功是多么困难。

---

### (00:00:28) Deb Liu

**English:**
The workplace is really favoring people who can speak up. It looks like self-promotion. I wouldn't want to do that because it's self-promotion. But instead, what if I called it educating about all the great work your team has been doing? Helping people see why your team should get more resources, you have to actually share what you do.

**中文翻译:**
职场确实更青睐那些敢于发声的人。这看起来像是自我推销。很多人会说：“我不想那样做，因为那是自我推销。”但换个角度，如果我把它称之为“让大家了解你团队所做的出色工作”呢？为了让别人明白为什么你的团队应该获得更多资源，你必须实际分享你所做的事情。

---

### (00:00:45) Lenny Rachitsky

**English:**
Is there something that you believe that you think most other people don't believe?

**中文翻译:**
有没有什么事情是你深信不疑，但大多数人却不认同的？

---

### (00:00:49) Deb Liu

**English:**
The most important career decision you make is who you marry. Is this person lifting you up or pushing you back? You will have a much more successful career if your home life is in balance. It's like a yin and a yang.

**中文翻译:**
你一生中最重要的职业决策是选择和谁结婚。这个人是在成就你，还是在拖累你？如果你的家庭生活处于平衡状态，你的职业生涯会成功得多。这就像阴阳调和一样。

---

### (00:01:03) Lenny Rachitsky

**English:**
Today, my guest is Deb Liu. Deb was VP of product at Facebook where she spent over 11 years and while they're created and led Facebook marketplace, which is now used by over 1 billion people monthly, she also led the development of Facebook's first mobile ad product for apps and its mobile ad network. Also built the company's games business and payments platform, including Facebook Pay.
(00:01:23):
Prior to Facebook, she was director at both PayPal and eBay. She's on the board of Intuit and for the past three and a half years, she's been the CEO of Ancestry. I actually generally have a rule of no CEOs on this podcast, but to me, Deb is a great exception because she's a product person at heart. In our conversation, Deb shares a ton of tactical career advice, including why resilience is so key to career success, how to PM your career like you PM your product, how to be successful in business as an introvert, what she's learned about building multiple billion dollars zero to one businesses within a large company like Facebook and so much more.
(00:01:59):
Deb is so full of wisdom and I'm really excited to share her insights with more people. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and helps the podcast tremendously. With that, I bring you Deb Liu.
(00:02:18):
Deb, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Deb Liu。Deb 曾在 Facebook 担任产品副总裁，在那里工作了 11 年多。期间，她创建并领导了 Facebook Marketplace（目前月活跃用户超过 10 亿）。她还领导开发了 Facebook 首个针对 App 的移动广告产品及其移动广告网络，并建立了公司的游戏业务和支付平台，包括 Facebook Pay。
(00:01:23):
在加入 Facebook 之前，她曾在 PayPal 和 eBay 担任总监。她是 Intuit 的董事会成员，过去三年半里一直担任 Ancestry 的 CEO。我通常有个原则，就是不邀请 CEO 上这个播客，但对我来说，Deb 是一个完美的例外，因为她骨子里是个产品人。在我们的对话中，Deb 分享了大量的实战职业建议，包括为什么韧性是职业成功的关键、如何像管理产品一样管理你的职业生涯、作为内向者如何在商业中取得成功、她在 Facebook 这样的大公司内部构建多个数十亿美元“从 0 到 1”业务的经验等等。
(00:01:59):
Deb 充满智慧，我非常激动能与更多人分享她的见解。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对我们帮助巨大。下面，让我们欢迎 Deb Liu。
(00:02:18):
Deb，非常感谢你能来。欢迎来到播客。

---

### (00:02:21) Deb Liu

**English:**
It's wonderful to be here, Lenny.

**中文翻译:**
很高兴来到这里，Lenny。

---

### (00:02:23) Lenny Rachitsky

**English:**
It's wonderful to have you here. You have had such an incredible career. You're VP of product at Facebook. You're director at eBay and PayPal. You're on the board of Intuit. You've been the CEO of Ancestry now for the past three and a half years. This is a career path that a lot of people dream of and honestly just like one of those roles is a dream for a lot of people. And so I wanted to start with just this question and I want to see where the conversation takes us. If you could give one specific piece of advice to someone that's looking to do well in their career or to do better in their career based on what has worked well for you, what would that be?

**中文翻译:**
很高兴你能来。你的职业生涯太不可思议了。Facebook 产品副总裁、eBay 和 PayPal 总监、Intuit 董事、Ancestry CEO。这是很多人梦寐以求的路径，坦白说，其中任何一个职位对很多人来说都是终极梦想。所以我想从这个问题开始，看看对话会引向何方：根据你的成功经验，如果你能给那些想要在职业生涯中表现出色或更进一步的人一条具体的建议，那会是什么？

---

### (00:03:02) Deb Liu

**English:**
Always be learning, and I tell this to everybody, so I often tell people, someone who's always learning is always going to exceed someone who's the expert today. You're going to find people... The one thing about school is that we go to school and there's such a thing as getting a hundred on the test, a perfect score on the SAT, graduating with a 4.0. Well, there's nothing like that in careers, right? We think it's actually a non-linear experience and there's always something better than you at speaking or presenting or strategy or execution. But if you're always learning, learning from the best, getting feedback, you're always going to get better every single day.
(00:03:35):
And that's what I have always held, which is each job I took, I didn't necessarily qualify for it. I wasn't necessarily the very best at it, and so it became the student of being better at that job. And once I mastered that, I was a student for something else, something else and something else. And so I always balanced learning and impact, which was you can have the most impact, the job you know the best, but then you stop learning. And if you're learning all the time, you're not necessarily having impact.
(00:04:00):
So how do you keep going back and forth and back and forth so that you're not going straight up a lot or you're actually laddering back and forth into different things where you're having an amazing time where you know everything and then you're the newbie again and learning new things, and you're incorporating what you used to know into what you're learning and the impact that you have today and so on and so forth.

**中文翻译:**
永远保持学习。我经常告诉大家，一个始终在学习的人，最终一定会超越那些仅仅是“今天的专家”的人。你会发现……学校教育的一点是，我们可以考 100 分，SAT 拿满分，以 4.0 的绩点毕业。但在职业生涯中，没有这种东西，对吧？职业生涯是非线性的，总有人在演讲、演示、战略或执行方面比你更强。但如果你一直在学习，向最优秀的人学习，获取反馈，你每一天都会变得更好。
(00:03:35):
这就是我一直坚持的理念：我接手的每一份工作，我不一定完全符合条件，也不一定是做得最好的，所以我把自己当成学生，去学习如何把那份工作做得更好。一旦我掌握了，我就再去学习别的东西，周而复始。我一直在平衡“学习”和“影响力”：在你最熟悉的工作中，你的影响力最大，但你停止了学习；如果你一直在学习新东西，你可能暂时没有影响力。
(00:04:00):
所以，你要如何在两者之间来回切换，而不是只追求直线晋升？实际上，你是在不同的事物间横向跨越，有时你游刃有余，有时你又是职场新人，学习新知识，并将过去的经验融入到当下的学习和影响力中，如此循环往复。

---

### (00:04:21) Lenny Rachitsky [Ad Break - Pendo]

**English:**
This episode is brought to you by Pendo, the only all-in-one product experience platform for any type of application. Tired of bouncing around multiple tools to uncover what's really happening inside your product? With all the tools you need in one simple to use platform, Pendo makes it easy to answer critical questions about how users are engaging with your product and then turn those insights into action.
(00:04:44):
Also, you can get your users to do what you actually want them to do. First, Pendo is built around product analytics, seeing what your users are actually doing in your apps so that you can optimize their experience. Next, Pendo lets you deploy in-app guides that lead users through the actions that matter most. Then Pendo integrates user feedback so that you can capture and analyze what people actually want. And the new thing in Pendo, session replays, a very cool way to visualize user sessions.
(00:05:12):
I'm not surprised at all that over 10,000 companies use it today. Visit pendo.io/lenny to create your free Pendo account today and start building better experiences across every corner of your product. PS, if you want to take your product-led knowhow a step further, check out Pendo lineup of free certification courses led by talk product experts and designed to help you grow and advance in your career. Learn more and experience the power of the Pendo platform today at pendo.io/lenny.

**中文翻译:**
本期节目由 Pendo 赞助。Pendo 是唯一一款适用于各类应用程序的全方位产品体验平台。厌倦了在多个工具之间跳来跳去，只为弄清楚产品内部到底发生了什么？Pendo 将你所需的所有工具整合在一个简单易用的平台中，让你轻松回答关于用户如何使用产品的关键问题，并将这些洞察转化为行动。
(00:04:44):
此外，你还可以引导用户完成你期望的操作。首先，Pendo 以产品分析为核心，观察用户在 App 中的实际行为，以便优化体验。其次，Pendo 允许你部署应用内指南，引导用户完成最重要的操作。接着，Pendo 整合了用户反馈，方便你收集和分析用户的真实需求。Pendo 最近还推出了“会话重播”（Session Replays），这是一种非常酷的可视化用户会话的方式。
(00:05:12):
目前有超过 1 万家公司在使用它，我一点也不意外。访问 pendo.io/lenny 立即创建免费账号，开始在产品的每个角落构建更好的体验。另外，如果你想进一步提升“产品驱动增长”（Product-led）的知识，可以查看 Pendo 由顶尖产品专家主讲的免费认证课程，旨在帮助你在职业生涯中成长。立即访问 pendo.io/lenny 体验 Pendo 平台的强大功能。

---

### (00:05:40) MUSIC

**English:**
Pendo.

**中文翻译:**
Pendo。

---

### (00:05:44) Lenny Rachitsky [Ad Break - WorkOS]

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point your customers will start asking for enterprise features like SAML authentication and skim provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know like Vercel, Webflow, and Loom. WorkOS also recently acquired warrant, the Fine Grained Authorization service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube.
(00:06:31):
This enables fast authorization checks at enormous scale while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on, skim or user management, you should consider WorkOS. It's a drop in replacement for auth zero and supports up to 1 million monthly active users for free. Check it out at workos.com to learn more. That's workos.com.

**中文翻译:**
本期节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，迟早会有客户要求提供企业级功能，如 SAML 身份验证和 SCIM 预配。这就是 WorkOS 的用武之地，它能让你快速、无痛地为应用添加企业级功能。他们的 API 易于理解，让你能快速交付并专注于构建其他功能。如今，已有数百家公司由 WorkOS 提供支持，包括你可能熟悉的 Vercel、Webflow 和 Loom。WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于名为 Zanzibar 的突破性授权系统，该系统最初是为 Google Docs 和 YouTube 设计的。
(00:06:31):
这使得在大规模环境下进行快速授权检查成为可能，同时保持了能够适应最复杂用例的灵活模型。如果你目前正寻求构建基于角色的访问控制（RBAC）或其他企业功能（如单点登录 SSO、SCIM 或用户管理），你应该考虑 WorkOS。它是 Auth0 的即插即用替代方案，并免费支持多达 100 万月活跃用户。访问 workos.com 了解更多信息。

---

### (00:07:03) Lenny Rachitsky

**English:**
You talked about you got into a new job maybe you weren't ready for and you had to learn on the job. So either maybe share story one of those experiences or just like how do you actually do this? So someone's listening, they're like, how do I learn? What am I learning?

**中文翻译:**
你提到过你进入了一份可能还没准备好的新工作，必须边做边学。能不能分享一个这样的经历，或者具体说说你是怎么做的？听众可能会想：我该怎么学？我该学什么？

---

### (00:07:14) Deb Liu

**English:**
We'll start with my career in tech. So I had worked in consulting before business school. I went to Stanford for business school, came out to California, didn't know that much about tech, but I really loved using eBay. So I interned there my first year in business school and then when it came to finding a job, I really wasn't sure what we wanted to do, but we wanted to move back to the East Coast. And so I wasn't looking and I couldn't find a job. I think it was really hard. It was 2002. And so I ran into Tim Wenzel and Catherine Wu. So Catherine Wu was from Airbnb as you might know her. And Tim Wenzel put together the PayPal Mafia. He was the recruiter for PayPal.
(00:07:51):
Went to this table and I said, "Absolutely love PayPal, use it all the time. I'm a big seller on eBay," and he's like, "Do you want a job?" I'm like, "No, I'm actually going back east. "And he's like, "Just come in and talk to us." And so I said, "Okay. Well, what kind of jobs do you have?" And he's like, "I have jobs in product and I have jobs in marketing." Now, I've taken marketing class obviously in business school, and I said, "I wonder what this other product job is."
(00:08:12):
So I look over at Catherine and I've seen her around Stanford before, so she was a year ahead of me and I said, "Well, what do you do?" She said, "Product." I'm like, "That sounds good. I'll do that." And that's actually how I fell into product management. Well, I actually, and I'm embarrassed to say faked my way through those interviews, because during the interviews they're like, "Well, what would you build?" And since I was an avid user of both products, I could really richly say, "Here's the product feedback I have. Here are the new products you should build. Here's my feedback on things that we should be doing differently."
(00:08:39):
And they said, "Congratulations." And they gave me the job. And embarrassingly I went to the first day of work and I said to Amy Clement, who was the VP of product at the time, and I said, "Okay, I literally have no idea what this product job is."
(00:08:54):
She showed me the ropes and she was so incredible. She actually showed me, she said, "All those ideas you had, all that energy you've had around building these things, we go do that. Let's go do it." And I said, "Well, how do you do that?" And she said, "Well, you write down what you want to build and you work with the engineers to do it." And I just remember thinking, "This is crazy. I have no idea what I'm doing."
(00:09:14):
It was such an incredible adventure though. Those first few years, I just learned so much about the craft of building, how to really think through product use cases, how to think through what customers wanted, not just the customer of one, myself, but really what true customers and customer cohorts wanted. And so it was really a time when I felt like I was really blossoming, but I didn't come in with mastery. I came with a curiosity and I think that's what made me a great product manager was that I didn't have a set way of doing things. There wasn't some playbook I was trying to play. There wasn't some framework, but instead I was willing to learn.

**中文翻译:**
从我的科技职业生涯开始说起吧。商学院之前我在咨询行业工作。后来我去了斯坦福读 MBA，来到加州，当时对科技并不太了解，但我非常喜欢用 eBay。研一我在那里实习，但毕业找工作时，我不确定想做什么，只想回东海岸。所以当时我没怎么找，也找不到工作，那是 2002 年，非常困难。后来我遇到了 Tim Wenzel 和 Catherine Wu（你可能知道 Catherine 后来去了 Airbnb）。Tim Wenzel 招募了后来的“PayPal 黑手党”，他是 PayPal 的招聘人员。
(00:07:51):
我走到摊位前说：“我超爱 PayPal，一直在用，我也是 eBay 的大卖家。”他问：“想要份工作吗？”我说：“不，我要回东部。”他说：“就来跟我们聊聊吧。”我问：“你们有什么职位？”他说：“产品和市场。”我在商学院上过市场营销课，但我心想：“那个‘产品’职位是干什么的？”
(00:08:12):
我看了看 Catherine，我在斯坦福见过她，她比我高一级。我问：“你是做什么的？”她说：“产品。”我说：“听起来不错，那我也做这个吧。”这就是我进入产品管理领域的契机。说实话，我很不好意思地承认，面试时我是“装”过去的。面试官问：“你会建什么？”因为我是这两个产品的资深用户，我可以滔滔不绝地说：“这是我的产品反馈，这是你们应该建的新产品，这是我认为应该改进的地方。”
(00:08:39):
他们说：“恭喜你。”然后给了我这份工作。尴尬的是，第一天上班，我对当时的产品副总裁 Amy Clement 说：“说实话，我完全不知道产品经理这份工作到底是干嘛的。”
(00:08:54):
她带我入门，她太棒了。她对我说：“你之前所有的那些想法，那些想造东西的劲头，我们现在就去实现它们。动手吧。”我问：“怎么做？”她说：“把你想要建的东西写下来，然后和工程师一起把它做出来。”我记得当时心想：“这太疯狂了，我根本不知道自己在干什么。”
(00:09:14):
但那是一段不可思议的冒险。头几年，我学到了很多关于“建造工艺”的知识：如何思考产品用例，如何思考客户需求（不仅仅是我个人的需求，而是真实客户群体的需求）。那是我感觉自己真正成长的时期。我进入这个行业时并不是大师，我带着好奇心而来。我认为这正是让我成为优秀 PM 的原因——我没有固定的套路，没有现成的剧本或框架，但我愿意学习。

---

### (00:09:46) Lenny Rachitsky

**English:**
So one takeaway might be from this, the phrase, fake it till you make it. Any thoughts on just how to... I imagine many people right now are like, "Oh, I'm trying to get a job as a pm. How do I do this? That sounds great. I'm going to pass this interview, figure out the job after I joined."

**中文翻译:**
所以这里的一个感悟可能是那句话：“边做边学，假装成功直到真正成功”（Fake it till you make it）。对于如何……我想现在很多人都在想：“我也想找份 PM 的工作，该怎么做？听起来不错，我先通过面试，入职后再去搞清楚工作内容。”你有什么看法？

---

### (00:10:02) Deb Liu

**English:**
Coming in with humbleness was really important, but during the interview process, actually, I didn't realize this, but they asked me questions as if I was a product manager, as if I knew what I was doing. I think when you have passion around a product or passion around a company or around a business model or around something, it shows. And so it's not necessarily faking the enthusiasm or faking the idea that you want to work there, but you don't have to know how to write this spec or PRD or briefings or anything like that. You don't know how to do customer research or do data analytics or read reports, but instead show your passion around the product itself, around the use case, around the customer.
(00:10:41):
Show who you are and why you care. I think sometimes people just say, "I want a product job." But you have to be able to fall in love with the problem. You have to fall in love, not with the product, but I said the problem, right? The use case. What problem are you trying to solve? And if you can do that, you can be a great product manager even without a lot of experience.

**中文翻译:**
保持谦逊非常重要。但在面试过程中，我当时没意识到，他们问我的问题其实是把我当成一个成熟的 PM 来看待的。我认为，当你对某个产品、公司或商业模式充满热情时，这种热情是藏不住的。所以，这并不是要伪造热情，你不需要一开始就知道怎么写 Spec、PRD 或简报，也不需要精通用户调研或数据分析。相反，你应该展示你对产品本身、对用例、对客户的热爱。
(00:10:41):
展示你是谁，以及你为什么在乎。我觉得有时候人们只是说“我想要一份产品工作”，但你必须能够“爱上问题”。不是爱上产品，而是爱上问题，对吧？也就是用例。你试图解决什么问题？如果你能做到这一点，即使没有太多经验，你也能成为一名优秀的产品经理。

---

### (00:11:00) Lenny Rachitsky

**English:**
That's an awesome piece of advice. So just lean into the passion. First of all, part of it is you have to be excited about the thing you're trying to work on or thinking about the company you're thinking about joining. Sounds like that's a prerequisite here. We have a podcast episode with Uri Levine who has a whole book called Fall in Love with the Problem, which is all about that same idea actually for startup founders.

**中文翻译:**
非常棒的建议。就是全身心投入到热情中。首先，你必须对自己要做的事情或准备加入的公司感到兴奋。听起来这是个先决条件。我们有一期播客采访了 Uri Levine，他写了一本书叫《爱上问题》（Fall in Love with the Problem），讲的也是同样的理念，不过是针对创业者的。

---

### (00:11:20) Deb Liu

**English:**
I'll have to read it.

**中文翻译:**
我得读读那本书。

---

### (00:11:20) Lenny Rachitsky

**English:**
Yeah, he always wears a shirt, fall in love with the problem, not the solution.

**中文翻译:**
是的，他总是穿着一件印有“爱上问题，而非解决方案”的 T 恤。

---

### (00:11:23) Deb Liu

**English:**
Yes, is absolutely the most important skill for a product leader.

**中文翻译:**
没错，这绝对是产品领导者最重要的技能。

---

### (00:11:27) Lenny Rachitsky

**English:**
Something else I've heard you talk about in terms of something that contributed to your success is being okay with failure and just bouncing back quickly versus avoiding failure. Is that something that you can come back to a lot?

**中文翻译:**
我还听你谈到过，促成你成功的另一个因素是“接受失败并迅速反弹”，而不是逃避失败。这是你经常思考的问题吗？

---

### (00:11:40) Deb Liu

**English:**
Well, here's what I noticed about everybody. I've coached a ton of people in my life. I have managed big teens and the people who are most successful are not the people who had no failures, who were lived charm lives, head up into the right careers and got promoted every cycle. The people who were most successful were the ones who actually through adversity, learned to turn stumbling blocks into stepping stones. They were the ones who got hard feedback and then came back stronger because now they learned what to do differently.
(00:12:09):
They were the ones who products failed, but they said, "You know what? I'm going to turn this failure into success. I'm going to take those lessons and make this company stronger." When you live a charmed product life, you always work on everything that's easy. You don't actually... Trees are strong because they bend in the wind, because they're tested, because it's cold, because it's windy, because there's conditions.
(00:12:31):
And that's how a tree goes grow strong and tall over many generations. And I think sometimes we think, "Oh yeah, I wish I lived a charm life." And that is not what we want. You want to have enough adversity that you learn to overcome so that you can build stronger over time and build resilience in your career.
(00:12:50):
I've seen that so much, which is the best product leaders I ever worked with are the ones that have the toughest stories, that had the hardest feedback, but also the ones who were able to bounce back quickly and make it happen.

**中文翻译:**
这是我观察到的普遍现象。我指导过很多人，管理过大型团队。最成功的人并不是那些从未失败、生活顺风顺水、职业生涯一路飙升、每个周期都晋升的人。最成功的人是那些在逆境中学会将绊脚石转化为垫脚石的人。他们收到严厉的反馈，然后变得更强大，因为他们学会了如何改进。
(00:12:09):
他们的产品可能失败过，但他们会说：“我要把这次失败转化为成功，吸取教训让公司更强大。”如果你在产品生涯中一直顺风顺水，你只会做容易的事。树木之所以强壮，是因为它们在风中弯曲，经受过严寒和狂风的考验。
(00:12:31):
这就是树木如何历经几代而长得高大强壮的原因。我觉得有时我们会想：“要是我的生活一帆风顺就好了。”但这并不是我们真正需要的。你需要足够的逆境来学会克服困难，这样你才能随着时间的推移变得更强大，并在职业生涯中建立韧性。
(00:12:50):
我见过太多这样的例子：我合作过的最优秀的产品领导者，往往是那些经历过最艰难的故事、收到过最刻薄的反馈，但也能迅速反弹并最终取得成功的人。

---

### (00:13:02) Lenny Rachitsky

**English:**
We have a segment on this podcast called Failure Corner where people share a failure they went through kind of along the same lines and something we learned from that experience. Is there an example of that from your career where a failure made you stronger?

**中文翻译:**
我们播客有一个叫“失败角落”的环节，大家会分享类似的失败经历以及从中吸取的教训。在你的职业生涯中，有没有哪个失败让你变得更强大的例子？

---

### (00:13:13) Deb Liu

**English:**
Yeah. I remember there was a job that I really wanted at Facebook and I'd been there for a long time. I had been leading different teams. I was a VP of product and then GM. There was one job that I never got to do, so I got to do all the jobs I wanted and Mark gave it to someone else. I told him at the time when he gave it to the first person who was amazing at it, I said, "If this job were open, I'd like to be considered for it."
(00:13:37):
The job opened up later, gave it to someone else. And I said to Mark, again, "I really wanted that job." And he said, "Not only will I not give you that job, you'll never have that job at this company."

**中文翻译:**
有的。我记得当时在 Facebook 有一个我非常想要的职位。我在那里待了很久，领导过不同的团队，做过产品副总裁，后来做了总经理。但有一个职位我一直没机会做。我做了几乎所有想做的职位，唯独那个职位，马克（扎克伯格）把它给了别人。当他第一次把那个职位给了一个非常出色的人时，我告诉他：“如果这个职位空出来，我希望能被考虑。”
(00:13:37):
后来那个职位真的空出来了，但他又给了别人。我再次对马克说：“我真的很想要那份工作。”他说：“我不仅不会把那份工作给你，你在这一辈子也别想在公司拿到那个职位。”

---

### (00:13:49) Lenny Rachitsky

**English:**
What?

**中文翻译:**
什么？

---

### (00:13:51) Deb Liu

**English:**
He didn't say it harshly. But he was giving me feedback about something which he did not see me in that role, in a role that I really wanted. And I had to decide each time like, "What do I do with this information?" This is my dream job. Actually, I decided I was going to turn the job I had and the job I wanted, and that's a choice. I could have said, you know what? I can't have that job. I could go do something else, but I didn't. I took the job I had with the team I had and I turned it into this thing that was going to be something we wanted.
(00:14:20):
And so I think sometimes it's not... I think that that experience was a very humbling experience because to be told no and then to say that this will never happen was really hard. But at the same time it was a reminder that you're not right for every job even if you think you are. And that you can take the raw materials of what you have and turn it into what you want.

**中文翻译:**
他说话的语气并不严厉。但他是在给我反馈：他认为我不适合那个角色，尽管那是我梦寐以求的。我必须决定如何处理这个信息。那是我的梦想职位。最终，我决定把我现有的工作变成我想要的那个样子，这是一种选择。我本可以说：“既然我拿不到那个职位，那我就走人。”但我没有。我带着现有的团队，把手头的工作做成了我们期望的样子。
(00:14:20):
所以我觉得，有时候……那次经历让我变得非常谦卑，因为被拒绝并被告知“永远不可能”是非常难受的。但同时，它也提醒我，即使你觉得自己合适，你也不一定适合每一份工作。你可以利用手头的原材料，把它们打造成你想要的样子。

---

### (00:14:40) Lenny Rachitsky

**English:**
Are you able to share what those jobs were that you wanted to get that you never got?

**中文翻译:**
你能分享一下那个你一直想得到却没得到的职位是什么吗？

---

### (00:14:44) Deb Liu

**English:**
I never actually shared it publicly, but it's something which I had always had a role where I did new things for the company and there was a role where it was running something which more of an existing business, but I had always been kind of the innovator, the new stuff person. I had taken over so many new things. And so maybe that wasn't the right thing at the right time for me, but it was something that was really incredible and a turning point for me.

**中文翻译:**
我从未公开分享过。但我一直以来的角色都是为公司开拓新业务，而那个职位是管理一个更成熟的现有业务。我一直被视为创新者、开拓者，接手过太多新项目。所以也许在那个时间点，那个职位对我来说并不合适。但那次经历对我来说非常不可思议，也是一个转折点。

---

### (00:15:08) Lenny Rachitsky

**English:**
Great segue to an area I wanted to spend some time on which is building zero to one stuff within a larger company. So from what I can tell you built 2 billion businesses within a large company, Facebook marketplace, and then the ads platform within Facebook and maybe more. I don't know, the payments stuff, the games. I don't know. Maybe there's billions of dollars there I don't even know about. And this is very rare and very hard, and it's something we talk a little bit on this podcast, just the skills to build something new.
(00:15:38):
I know with marketplace it was not something people believed in for a long time. It took a lot of work to convince people to actually give it a shot. So I guess the question here is just what have you found are key tactics to start something new and allow it to continue to exist and get to a place where people start to believe it? What has worked for you?

**中文翻译:**
这正好引出了我想深入探讨的话题：在大公司内部构建“从 0 到 1”的业务。据我所知，你在 Facebook 内部建立了两个价值数十亿美元的业务：Facebook Marketplace 和 Facebook 内部的广告平台，可能还有更多，比如支付、游戏。我不知道，也许还有我不知道的几十亿美元业务。这非常罕见且困难，也是我们播客经常讨论的话题——构建新事物的技能。
(00:15:38):
我知道 Marketplace 在很长一段时间内都不被人看好，你花了很多精力才说服大家去尝试。所以我想问：你发现启动新项目并让它生存下去、直到大家开始相信它的关键策略是什么？对你来说，什么样的方法最奏效？

---

### (00:15:57) Deb Liu

**English:**
So first, I didn't build the ads platform. I actually built the first direct response ad product company ever had. But we'll talk about how that led to why direct response is a vast majority of the ads revenue for the company. But one thing that it was really interesting is that I really saw my opportunity in Facebook to be somebody that zigged when other people zagged. There were amazing people who did a lot of the really core products working on feed, photos, videos.
(00:16:25):
I came in actually on the payments team and we worked on payments and eventually built games, which was the first billion dollar business. It was very successful. We worked with the likes of all the game companies that were on the Canvas games platform. And it was just an incredible opportunity to start from scratch and built something really cool. We built Facebook credits, which eventually became the Facebook payment system.
(00:16:47):
And then from there on I built the first direct response ads product. And again, leveraging the skills that we had, we had a lot of relationships with game companies because of my time and payments. And so we just said, "Hey look, what ad product do you want?" And they said, "Actually, your biggest challenge is the shift to mobile. Build us a mobile acquisition engine." And we said, "That's doable."
(00:17:09):
At the time the company was very brand oriented. Most of the ads... Actually almost all the ads on the platform were brand and we were not even on the ads team. So we actually worked on this team called the platform team. We said, "Okay, we'll build an ads product for the Facebook feed, the new mobile Facebook feed." And suddenly it became a billion dollar business within about 18 months, which was such an incredible journey.
(00:17:30):
We worked on the mobile advertising platform, so basically the mobile ads network. That was a great experience. And so each time I worked on something, it was just... The thing that you have to remember is the failure rate for something like this is very high. You start something and the amount of iteration... People think, "Oh yeah, it's easy." You start something and it's linear because you have all the resources of this company behind you. But actually everything in the company is like, "Let's do the most important thing."
(00:17:58):
These are seeds and we'll just let them... And so if you do that, you have to know that you don't get a lot of resources, you get a lot of attention. And I appreciated that because I think I work best when people aren't... There is not a lot of scrutiny. I think sometimes large companies, they say, "Well this innovation team," and then they check in on them way too much. They're like, "Week to week progress, where are you going? What's your strategy?" But so much as you know of building something new is the iteration process. It's the failing a lot.
(00:18:27):
We actually tested five or six versions of the ads product before we got it to take off and it took months, and then we were on the verge of death multiple times. In fact, I actually went back to run the payments team while I was working on that product because the team we had gathered still want to continue working on it, but I needed a second job back on the payments team because they asked me, "We don't think this thing is going to work. You should go run your old team again." And I thought, "Well, I will do both."
(00:18:52):
And so I did both for a while until it really took off. The thing that I think a lot of large companies don't realize is that you can love something to death. And so with every new product, I'd rather do it out of the limelight, do it with the minimal resources and have the freedom to fail because success and failure really is... In startups, failing fast is really important or succeeding fast.
(00:19:18):
It's the long slog that makes it really hard. In a company, you end up getting cut if you're the long slog product. And so being able to just say, "You know what? We're pruning this. We're doing the next thing, the next thing." And then having the time to iterate and grow is really critical.

**中文翻译:**
首先，我没有构建整个广告平台，我构建的是公司首个“直接响应”（Direct Response）广告产品。稍后我们可以聊聊它是如何演变成公司绝大部分广告收入来源的。有趣的是，我在 Facebook 看到的机遇是做那个“反其道而行之”的人。当时有很多牛人在做核心产品，比如 Feed、照片、视频。
(00:16:25):
我最初加入的是支付团队，后来建立了游戏业务，那是第一个价值 10 亿美元的业务，非常成功。我们与 Canvas 游戏平台上的所有游戏公司合作。那是一个从零开始构建酷炫事物的绝佳机会。我们建立了 Facebook Credits，它后来演变成了 Facebook 的支付系统。
(00:16:47):
之后，我构建了第一个直接响应广告产品。利用我在支付团队积累的游戏公司关系，我们问他们：“你们想要什么样的广告产品？”他们说：“你们最大的挑战是向移动端转型，给我们做一个移动端获客引擎吧。”我们说：“没问题。”
(00:17:09):
当时公司非常注重品牌广告，几乎所有广告都是品牌类的。我们甚至不在广告团队，而是在“平台团队”。我们说：“好吧，我们为新的移动端 Facebook Feed 开发一个广告产品。”结果在大约 18 个月内，它就变成了一个 10 亿美元的业务，那段旅程太不可思议了。
(00:17:30):
我们还做了移动广告平台，也就是移动广告网络。每次做新项目，你必须记住：这类事情的失败率极高。人们以为在大公司有资源支持，一切都是线性的、容易的。但实际上，公司里的每个人都在想：“我们要把资源投在最重要的核心业务上。”
(00:17:58):
这些新项目就像种子。如果你这样做，你必须明白你得不到太多资源，却会得到很多关注。我其实挺享受这种状态的，因为我觉得在没有太多审视的情况下工作效率最高。大公司有时会搞个“创新团队”，然后过度关注他们，每周问进度、问战略。但如你所知，构建新事物本质上是不断迭代和大量失败的过程。
(00:18:27):
在广告产品成功之前，我们测试了五六个版本，耗时数月，期间多次濒临夭折。事实上，我当时甚至回过头去兼任支付团队的负责人，因为公司觉得广告产品没戏，让我回去带老团队。我想：“那我就两个都干吧。”
(00:18:52):
我兼职了一段时间，直到广告产品真正爆发。大公司往往没意识到，过度的关注可能会“扼杀”创新。对于每一个新产品，我宁愿在聚光灯之外、用最少的资源去做，并拥有失败的自由。在创业公司，快速失败或快速成功很重要。
(00:19:18):
最难的是“长期的苦战”。在公司内部，如果你是一个长期没有起色的产品，最终会被砍掉。所以，能够果断地说“我们要修剪这个，尝试下一个”，并拥有迭代和成长的时间，这至关重要。

---

### (00:19:33) Lenny Rachitsky

**English:**
So as a leader trying to do this and create space for this, is there something you've learned about how to allow for, "Don't over scrutinize us, don't look at us too carefully. We don't want to be in the limelight. Don't put too many resources on this yet." Is it just like, "Hey, Mark. Here's what I think." I imagine it's not as easy as that. There's a lot of influence and that kind of work. Is there any tactics that you could share to create this sort of environment?

**中文翻译:**
作为一名试图为此创造空间的领导者，你学到了什么？如何让上层“不要过度审视我们，不要盯得太紧，我们不想出风头，先别投太多资源”？是直接跟马克说“嘿，马克，我是这么想的”吗？我猜没那么简单，肯定涉及很多影响力运作。你能分享一些创造这种环境的策略吗？

---

### (00:19:59) Deb Liu

**English:**
I think the most important part of the environment is really patience. And again, this is a portfolio strategy and I tell every PM who... I used to do a new hire PM class and I say, "Look, a lot of you are going to go into the core product and your job is to grow X by 3 to 5% every six months. Growing engagement or growing sessions or maybe growing video views or whatever your metric is, you're trying to grow something 5% and then you exceed expectations."
(00:20:27):
And I said, "And then a bunch of you are like, 'I want to do something new. I want to build something from scratch.'" And I said, "By the way, a very, very successful company for a new set of products has a 50% hit rate. So half of you are going to come back in a year and have a different job because that did not work out. Do you have the resilience to do that?" And I think somebody, you enter a large company... By the way, you can have an amazing career building core products because that is an incredible journey within... Because you learn so much about the mechanics of what that takes.
(00:20:59):
And yet at the same time, I found a lot of energy from doing something that someone hasn't done before. And so I really enjoyed the, "Hey, this thing could fail. Let's pivot. Let's try to figure out. Let's prune this. Let's try that." And not everything I did there succeeded, but a lot of the things that are the lasting products are once that gotten really big. And so for me it was a greater reward and it made a journey so much more interesting.
(00:21:24):
But for others, I think work on the core product, learn the skills. It is absolutely respectable as well. But if you choose to be the person who works on innovation new products, expect in a year, you might literally have nothing to show for it, but the lessons that you learned. And I think those lessons are really precious and we often underestimate that too.

**中文翻译:**
我认为这种环境最重要的部分是耐心。这其实是一种投资组合策略。我以前给新入职的 PM 上课时会说：“听着，你们中的大多数人会去做核心产品，你们的任务是每六个月让某个指标增长 3% 到 5%。无论是增长参与度、会话数还是视频观看量，你们的目标是增长 5%，然后超越预期。”
(00:20:27):
我接着说：“还有一部分人会说，‘我想做点新东西，我想从零开始。’顺便说一下，即使是非常成功的公司，新产品的成功率也只有 50%。这意味着你们中有一半人一年后会因为项目失败而换一份工作。你有这种韧性吗？”在大公司，构建核心产品也可以有很棒的职业生涯，因为你能学到很多运行机制。
(00:20:59):
但与此同时，我从做前人未做过的事情中获得了巨大的能量。我非常享受那种“嘿，这可能会失败，让我们转型，让我们修剪掉这个，尝试那个”的过程。并不是我做的每一件事都成功了，但很多留存下来的产品后来都变得非常庞大。对我来说，这种回报更大，旅程也更有趣。
(00:21:24):
但对于其他人，我认为在核心产品上磨练技能也是完全值得尊敬的。但如果你选择成为那个负责创新和新产品的人，就要做好一年后可能颗粒无收、只剩下教训的心理准备。我认为这些教训非常珍贵，而我们往往低估了它们的价值。

---

### (00:21:42) Lenny Rachitsky

**English:**
Along those lines, do you think it's a good career move to do a zero to one thing within a bigger company? Or is it often a bad idea? Do you have any advice there for folks?

**中文翻译:**
顺着这个话题，你认为在大公司内部做“从 0 到 1”的事情是一个好的职业选择吗？还是通常是个坏主意？你对大家有什么建议？

---

### (00:21:52) Deb Liu

**English:**
It depends. It depends on your personality in the company. So the one thing I realized about my role was that I did a lot of... I had five different careers at the company over 11 years. And so most people don't realize that when you work on new things, you're constantly adding to your portfolio, subtracting from it, growing things, pruning them. And so you could just work on so many cool things except everything has similar... It's like it rhymes, but it's not exactly the same.
(00:22:19):
So you learn the lessons of how to get things done, how to get resource, how to get support when the product is not working, how to not get prunes in the next culling. And those are really, really important skills. But I think for people who are just starting out of the career, it is a very high risk thing to do. So if you're very early in the career, I encourage people just learn the core skills first. You can learn the core skills when there's a lot of stability. This product is growing X percent, like 5%, and you're going to grow at 10. That's amazing.
(00:22:47):
That is because you are there, you're going to change your trajectory of the product, or this thing has a hundred thousand users, you're going to get it to 200,000. Those are the kinds of things that are going to be successful for you and you can put on your resume. But I think it reaches a point in your career where you have to decide, when am I going to take the big swing? Because the big swings are the things that you write your career stories about. They're not just, I moved this metric X, but I changed your trajectory in this way.
(00:23:17):
And so the big swings though have a lot of failures along the way. And so you have to understand you're making trade-offs in that. I encourage everybody to take some time, two, three years in their career when they're ready for the big swing, where if it doesn't work... If it works, you run the team, you run this amazing product. It doesn't work, you can always go back and go back to the core products.

**中文翻译:**
这取决于你的性格和所在的公司。我意识到在 Facebook 的 11 年里，我实际上经历了五段不同的职业生涯。大多数人没意识到，当你做新项目时，你是在不断地为你的投资组合增加或减少项目。你可以尝试很多酷炫的事情，虽然每个项目都不同，但它们之间有某种“韵律”，逻辑是相通的。
(00:22:19):
你会学到如何把事情办成，如何获取资源，如何在产品不顺时获得支持，以及如何在下一轮裁撤中保住项目。这些都是非常重要的技能。但对于刚开始职业生涯的人来说，这风险很高。如果你处于职业生涯早期，我建议先学习核心技能。在稳定的环境中学习核心技能更容易。比如一个产品本来增长 5%，你把它做到了 10%，这很了不起。
(00:22:47):
因为你的存在，你改变了产品的轨迹，或者把用户从 10 万做到了 20 万。这些都是可以写进简历的成功案例。但到了职业生涯的某个阶段，你必须决定：什么时候去“大干一场”（Take the big swing）？因为那些“大动作”才是你职业故事的华彩篇章。它们不仅仅是“我移动了某个指标”，而是“我以这种方式改变了轨迹”。
(00:23:17):
当然，大动作伴随着大量的失败。你必须明白这其中的权衡。我鼓励每个人在职业生涯中抽出两三年的时间，当你准备好大干一场时去尝试。如果成功了，你将领导一个团队和一款惊艳的产品；如果失败了，你总能回到核心产品线。

---

### (00:23:39) Lenny Rachitsky

**English:**
It's interesting how your strategy here is very similar to a product portfolio strategy where as a team should have a few big bets and then a lot of incremental stuff. And it reminds me about this awesome post called You Are in Control of Your Career. And the argument in your post is you should PM your career the way you PM your product. So there's a lot of synergy here. So maybe just diving into this post and advice around this, how should someone be PMing their career, the way they PM a product? What's your take there?

**中文翻译:**
很有趣，你的策略与产品组合策略非常相似：团队应该有一些“大赌注”，再加上大量的增量改进。这让我想起了你那篇很棒的文章《你掌控着自己的职业生涯》（You Are in Control of Your Career）。你在文章中的论点是：你应该像管理产品一样管理你的职业生涯。这其中有很多协同效应。所以，能否深入探讨一下这篇文章和相关建议：一个人应该如何像做产品经理一样经营自己的职业生涯？你的见解是什么？

---

### (00:24:05) Deb Liu

**English:**
By the way, for your PM audience, I want to say this, which is a lot of the greatest PMs are the worst PMs of their careers. They love products. They love the crafts. They love the customer research, the data. They have plans, they have timelines. And then when it comes to career, they have none of those things. They just drift from job to job. "Hey, should I take this role or this role? How do I think about this?" But if I said you had to write a spec for your career, what's in there? What are your milestones? What are the skills? What are the features that you want to have of your career? How are you going to get there? What does success look like?
(00:24:41):
You actually have metrics for your product, and yet you don't have metrics for your career. I coach a lot of people and when I coach them, I ask them, "Well, where do you want to see yourself in five years? Where do you want to go?" And half the people have no idea. I think that's really tragic because when you PM your career, it's about intentionality. But I'll tell you the story of my career and how I was the accidental PM and then eventually... I told you how I accidentally fell into PM, but also fell into so many of the things that happened in my PM career.
(00:25:10):
And if I had to go back, I would think much more deeply about what I want to accomplish. So I ended up at PayPal working for a guy named Dave Lee who reported to Amy Clement, and then he left. And so she offered me his role. I had only managed people for, I don't know, 15 seconds. I was two years out of business school and I was definitely not qualified to do his job. He was the director of product. I wasn't even a director and I was running the team for eBay.
(00:25:34):
So basically the PayPal part of eBay, which was basically half the company's revenues and profits. Totally unqualified. I ended up in this job and I do a good job. I ended up doing it for several years. I built up the team and we have a great relationship with eBay. Our team was very close and we were able to actually build something really lasting that worked really well. And then I had a baby. And so this happens in a lot of women's careers. I was turning 30, I had my son, and I had to leave for six months.
(00:26:08):
So I handed my product to my successor, Mike Woo and he ended up taking over. He did such a good job while I was gone, I didn't want to displace him when I got back. And so I thought, "Well, I'll go and look for another role." I couldn't really find a product role I liked, I mean, because there weren't that many product director roles. And so I ended up in corporate strategy. So I worked for the amazing Rajiv who was CEO at the time. He since passed and I wrote his speeches, worked on strategies, I worked on digital goods and charity, and ended up building that into a vertical for the company. So charity, social commerce and digital goods.
(00:26:40):
And I thought, "Okay, this is an interesting job." So I create the job, have a couple product managers, wasn't really sure where this was going, and then one day I was like, "You know what? I'm not feeling this. I have a child at home." I had gotten into what Cheryl Sandberg calls that kind of between kids situation where I was bored of my job.
(00:26:59):
I was working one of the VPs I worked with and I resigned. I said, "I'm leaving tech, just I'm going to stay home and maybe start something small." He convinced me to hold off and he said, I'll find you a job. He calls me a week later and he said, "Found you a job with Stephanie Tilenius leading the buyer experience at eBay product." And I said, "Oh, that sounds interesting." So I said, "Sure, as you notice, I do not have a plan. I'm just drifting. I'm so fortunate that I had amazing mentors who gave me opportunities, but end up working for Greg Fant and Stephanie Tilenius at eBay for two years.
(00:27:34):
I led the buyer experience. We did some really good work there. And then went on maternity leave again. And I get a call from a friend, my old engineering manager from PayPal, "Hey, I'm at Facebook. Do you want to come? You can't come into product. You need a CS degree for that, but we have a product marketing job open." I was like, "Sounds good." Drop into Facebook. And so again, no idea what I'm doing back in product marketing. So I spent a few years doing that. Eventually was invited into product and so on and so forth.
(00:28:02):
And each job that came along was organic, but also kind of accidental. I see that happen in a lot of careers, which is my story when you look back, looks great. It looks like it all worked out, but I had almost zero intentionality in any of these. And I think that had I had more agency and I thought about what I wanted, I could actually measure is this the thing that would get me further or not?
(00:28:24):
I ended up extremely lucky, but not everybody does. And so I think having a plan allows you to compare every decision. It's not like when you're offered an admission to college, we're looking at three different offers maybe with financial aid or not, and you can make a decision, "Oh, they're offering me this department, but I can't get into this department." This is how far it is from home. But jobs and roles or nothing like that. Someone calls you one day, "Hey, I'm at Facebook. Do you want to come? I'm actually on maternity leave." And he's like, "Just come talk to me." I'm like, "Why not."
(00:29:00):
And you end up dropping into different parts of your life and I think sometimes by saying, "Here's where I want to go and here's how I want to get there," you can have such a better career. And so I do encourage everybody to do this and to think about what does success look like in five years and how far am I from that and am I heading in the right direction?

**中文翻译:**
顺便说一下，我想对你的 PM 听众说：很多最优秀的 PM 恰恰是自己职业生涯最糟糕的 PM。他们热爱产品，热爱工艺，热爱用户调研和数据。他们有计划，有时间表。但一谈到职业生涯，这些全没了。他们只是在工作间漂泊。“嘿，我该接这个职位还是那个职位？我该怎么考虑？”但如果我说你得为职业生涯写份 Spec，里面会有什么？里程碑是什么？技能是什么？你希望职业生涯具备哪些“功能”？你打算如何实现？成功是什么样子的？
(00:24:41):
你为产品设定指标，却不为职业生涯设定指标。我指导过很多人，我会问：“你希望五年后的自己在哪里？你想去哪？”一半的人毫无头绪。我觉得这很悲哀，因为“经营职业生涯”的核心在于“目的性”（Intentionality）。我给你讲讲我的故事，我是如何成为一个“偶然的 PM”的。我之前说过我如何误打误撞进入产品领域，其实我职业生涯中的很多事都是偶然发生的。
(00:25:10):
如果能重来，我会更深入地思考我想成就什么。我当时在 PayPal 为 Dave Lee 工作，他向 Amy Clement 汇报。后来他离职了，Amy 把他的职位给了我。当时我管理人的经验大概只有 15 秒，刚从商学院毕业两年，完全不够格。他是产品总监，我连总监都不是，却要负责 eBay 的团队。
(00:25:34):
也就是 eBay 内部的 PayPal 部分，贡献了公司约一半的营收和利润。完全不够格。但我接手了，做得还不错。我做了几年，建立了团队，与 eBay 保持了良好的关系。我们团队很紧密，建立了一些持久且运行良好的东西。后来我怀孕了。这在很多女性的职业生涯中都会发生。我快 30 岁了，有了儿子，休了 6 个月假。
(00:26:08):
我把产品交给了继任者 Mike Woo。他做得太出色了，以至于我回来时不想取代他。于是我想：“那我就找个新职位吧。”但我找不到喜欢的产品职位，因为当时产品总监的职位并不多。最后我去了企业战略部，为当时的 CEO Rajiv 工作。他后来去世了。我为他写演讲稿，研究战略，负责数字商品和慈善业务，最后把它做成了公司的一个垂直领域。
(00:26:40):
我想：“好吧，这工作挺有意思。”我创造了这个职位，带了几个 PM，但不确定未来在哪。有一天我觉得：“我不喜欢这个，家里还有孩子。”我陷入了谢丽尔·桑德伯格所说的那种“孩子间歇期”，对工作感到厌倦。
(00:26:59):
我向一位副总裁辞职了。我说：“我要离开科技圈，回家待着，也许做点小生意。”他劝我等等，说帮我找份工作。一周后他打电话说：“在 eBay 帮你找了个职位，跟 Stephanie Tilenius 一起负责买家体验产品。”我说：“听起来不错。”如你所见，我完全没有计划，只是在漂泊。我很幸运有优秀的导师给我机会，我在 eBay 跟随 Greg Fant 和 Stephanie 工作了两年。
(00:27:34):
我负责买家体验，做了一些不错的工作。然后我又休产假了。我接到一个朋友的电话，他是我在 PayPal 时的工程经理：“嘿，我在 Facebook，你想来吗？你做不了产品，因为你没有计算机学位，但我们有个产品市场（PMM）的职位。”我说：“听起来不错。”于是我去了 Facebook。再次强调，我对产品市场一窍不通。我做了几年，最后被邀请转回产品岗，以此类推。
(00:28:02):
每一份工作都是有机发生的，但也带有偶然性。回顾过去，我的故事看起来很精彩，似乎一切顺理成章，但其实几乎没有任何目的性。我想，如果我当时更有主见，更清楚自己想要什么，我就能衡量每一项决策是否让我离目标更近。
(00:28:24):
我最终极其幸运，但并不是每个人都这么幸运。我认为有一个计划能让你对比每一项决策。这不像申请大学，你可以同时对比三个录取通知书和助学金，决定去哪个系、离家多远。工作机会通常是串行出现的。某天有人打电话给你：“嘿，我在 Facebook，来聊聊？”而你当时可能正在休产假。
(00:29:00):
你可能会因此进入人生不同的阶段。如果你能说“这是我想去的地方，这是我的路径”，你的职业生涯会好得多。所以我鼓励每个人都思考一下：五年后的成功是什么样子的？我离它还有多远？我是否走在正确的方向上？

---

### (00:29:20) Lenny Rachitsky

**English:**
What's interesting is I also had a similar path to you where I had zero plan or intention or goal and also just follow things and things worked out. I wonder how often that happens and I wonder if this idea of having intention and planning a roadmap is something you do if things aren't working out because maybe there's some good to not overthinking it and just following pull. I don't know.

**中文翻译:**
有趣的是，我的路径和你很像：完全没有计划、意图或目标，只是顺势而为，结果还不错。我想知道这种情况发生的频率有多高。我也在想，“有目的性地规划路线图”是不是在事情进展不顺时才需要做的事？也许“不过度思考、顺应吸引力”也有它的好处。我也不确定。

---

### (00:29:45) Deb Liu

**English:**
Well, I think the problem is this with you and me, Lenny, is that hindsight bias is a problem. We made it because we weren't intentional in a lot of ways, but for how many people, is that true? For how many people who aren't... You don't have a plan and you get there. I always tell people, if you are sure what your destination is, that's definitely where you're going to end up. But if you actually aim in the right direction, you can shape your learnings, you can shape your roles you take, you can shape your skills towards the place that you want to go.

**中文翻译:**
Lenny，我觉得你我之间的问题在于“事后聪明偏见”（Hindsight bias）。虽然我们在很多方面没有目的性也成功了，但对多少人来说这是普适的呢？有多少人没有计划也能达到目标？我常说，如果你确定了目的地，你最终一定会到达那里。但如果你能瞄准正确的方向，你就可以根据你想去的地方来塑造你的学习内容、选择的职位以及培养的技能。

---

### (00:30:16) Lenny Rachitsky

**English:**
When you talk about getting this offer from Facebook, usually those are like you have three days to decide.

**中文翻译:**
当你谈到拿到 Facebook 的录取通知时，通常只有三天的决定时间。

---

### (00:30:21) Deb Liu

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:30:22) Lenny Rachitsky

**English:**
And it feels like that's when the things you've done ahead of time of here's what I want would be most helpful.

**中文翻译:**
感觉在那样的时刻，如果你提前想清楚了“这就是我想要的”，那会非常有帮助。

---

### (00:30:29) Deb Liu

**English:**
Also, I think the thing about job opportunities in particular is they tend to come serially. It's only you presented these offers. It's like one role is so different from another and they often don't happen at the same time. They might say, "Well, you have to decide in two weeks." And then you say, "Well, there's this other company I'm talking to and you get a lot of pressure to say yes to this versus this."
(00:30:49):
And to really having a measuring stick is this getting me closer or further away from where I go? Can allow you to actually take serial decision making to a place where you're measuring against a long-term goal.

**中文翻译:**
而且，工作机会往往是接踵而至的，而不是同时摆在你面前。不同职位的差异可能非常大，而且通常不会同时出现。他们可能会说：“你必须在两周内决定。”而你可能会说：“我还在和另一家公司谈。”你会面临很大的压力。
(00:30:49):
如果你有一把“衡量尺”，问问自己：“这让我离目标更近了还是更远了？”这能让你在面对一系列决策时，始终对照着长期目标进行衡量。

---

### (00:31:01) Lenny Rachitsky

**English:**
I did a meditation retreat once and when you're meditating, there's this kind of guidance of don't try too hard, don't push yourself to go into a direction, "Oh, I'm not doing a good job. I need to get to this enlightened state." And instead their advice is just push your cart in a direction and think about that's the direction you want head, but you don't need to grasp on to here's where I need to land, here's where I need to go. And I wonder if just having a thought of here's where I want my career to go. I want to be on boards in the future. I want to start a company in the future. I want to become a designer in the future. At least start there maybe just like a direction that you're heading.

**中文翻译:**
我参加过一次冥想静修。冥想时有一种指导：不要太用力，不要强迫自己朝着某个方向走，不要想“哦，我做得不够好，我需要达到那种开悟的状态”。相反，他们的建议是：朝着一个方向推你的小车，想清楚那是你想去的方向，但不需要死死抓住“我必须降落在哪里”或“我必须去哪里”。我在想，如果只是有个念头：“这是我希望职业生涯发展的方向。未来我想进入董事会，或者我想创业，或者我想成为一名设计师。”至少从那里开始，确定一个大致的前进方向。

---

### (00:31:40) Deb Liu

**English:**
Yeah. There's a woman who I worked with in product and now she's the founder, very successful founder, and she said to me, "I want to join the board of this Fortune 100 company." She told me the company, and I said, "Okay, that's a lot." So she said, "How can I get there?" And I said, "First, it's probably going to take you 10 years because look at who's on the board. I happen to know a couple people on the board." And I said, "Why don't I introduce you to one of them? And they can tell you how to get there.
(00:32:04):
But the point is she knew where she wanted to go and she said, "I'm willing to take it first step today." And I said, "First, you've never been on a board. You were very successful, but this is not... There's so many steps before you get there. It's like before you go to Harvard, you have to graduate from elementary school to middle school. You have to take the SAT, you have to apply. I said, "Let's start from the first step and let's break this problem down."
(00:32:29):
But I love that she knew where she wanted to go and she's like, "Even if I don't make it there, I'll be happier having made this journey." And I love that for her. And I think she's still earlier in her career, she has so much time ahead of her, but it's really incredible to see her kind of on this path and to know that that's her dream, and that I can help her a little bit along the way.

**中文翻译:**
没错。我合作过的一位女性 PM，现在是一位非常成功的创始人。她对我说：“我想加入这家财富 100 强公司的董事会。”她告诉了我公司名字，我说：“哇，这目标不小。”她问：“我该怎么做？”我说：“首先，这可能需要 10 年时间，看看董事会成员都是谁。我刚好认识其中几位。”我说：“不如我介绍你认识其中一位，让他们告诉你如何达到那个位置。”
(00:32:04):
重点是，她知道自己想去哪，并且说：“我愿意从今天迈出第一步。”我说：“首先，你从未进过董事会。你很成功，但通往那里的步骤很多。就像上哈佛之前，你得先小学、中学毕业，考 SAT，然后申请。让我们从第一步开始，分解这个问题。”
(00:32:29):
但我很欣赏她明确自己的目标，她说：“即使最终没达到，我也会因为经历了这段旅程而更快乐。”我为她感到高兴。她还年轻，未来还有很多时间。看到她走在这条路上，知道那是她的梦想，并且我能一路上帮她一点忙，这种感觉真的很棒。

---

### (00:32:48) Lenny Rachitsky

**English:**
It also relates very much to your idea of thinking of your career like a PM thinks about their product where one of the tactics is to imagine the ideal scenario and work backwards from that versus incrementally what's the next thing? What's the next thing? So in this case, she was thinking, "Here's where I want to head. Okay, what's the next thing to get to that direction?" I love that.

**中文翻译:**
这也非常符合你“像 PM 思考产品一样思考职业生涯”的理念：其中一个策略是想象理想的场景，然后倒推回来，而不是仅仅增量地想“下一步是什么”。在这个例子中，她在想：“这是我想去的终点。好，为了朝那个方向走，下一步该做什么？”我喜欢这个思路。

---

### (00:33:07) Lenny Rachitsky [Ad Break - Webflow]

**English:**
This episode is brought to you by Webflow. We're all friends here, so let's be real for a second. We all know that your website shouldn't be a static asset. It should be a dynamic part of your strategy that drives conversions. That's business 101, but here's a number for you. 54% of leaders say web updates take too long. That's over half of you listening right now. That's where Webflow comes in. Their visual first platform allows you to build, launch, and optimize webpages fast. That means you can set ambitious business goals and your site can rise to the challenge. Learn how teams like Dropbox, IDEO, and Orangetheory trust Webflow to achieve their most ambitious goals today at webflow.com.

**中文翻译:**
本期节目由 Webflow 赞助。既然大家都是朋友，我们就说点实在的。我们都知道，网站不应该是一个静态资产，它应该是你驱动转化的动态战略的一部分。这是商业常识，但这里有个数据：54% 的领导者表示网站更新耗时太长。也就是说，正在听节目的观众中有一半以上面临这个问题。这就是 Webflow 的用武之地。他们的视觉优先平台让你能够快速构建、发布和优化网页。这意味着你可以设定宏大的商业目标，而你的网站能够应对挑战。访问 webflow.com，了解 Dropbox、IDEO 和 Orangetheory 等团队如何信任 Webflow 来实现他们最宏大的目标。

---

### (00:33:53) Lenny Rachitsky

**English:**
Okay, going a slightly different direction, I'd say the post that you've written that has most resonated with me was about introverts and how hard it is to be successful as an introvert, and that basically have to learn to be an extrovert as an introvert because in business extroverts are most valued. Can you just talk about of your insight, what you've seen around this and how and your advice to introverts like me about how to be successful in business, what you need to change?

**中文翻译:**
好，换个方向。你写的文章中让我最有共鸣的一篇是关于内向者的，讲的是作为内向者在职场成功有多难，以及内向者基本上必须学会表现得像个外向者，因为在商业世界中，外向者更受重视。你能谈谈你在这方面的见解吗？你观察到了什么？对于像我这样的内向者，你有什么关于如何在商业中取得成功、需要做出哪些改变的建议？

---

### (00:34:22) Deb Liu

**English:**
Well, first, I love the book, Quiet by Susan Cain. She talks about the power of introverts. Unfortunately, the world doesn't see the way the world the way she does. I wrote this post. It was the secret bias no one talks about, which is the workplace is really favoring people who can speak up. And I tell the story of somebody on my team who's just an amazing product manager, and yet every time she came up for promotion or calibration, people were like, "Oh, what does she do?" And it was because she was not good at broadcasting or explaining what she does.
(00:34:54):
I would take her to executive meetings and she was really bad at answering questions or talking. And so we would prep and prep and prep. I just knew her skills and I could see her every day moving the product forward. But for some reason people... Because your peers also have influence over people's ratings and their promotions, and I was constantly just trying to figure out how to get them to see her brilliance. I asked her once, I said, "I noticed that you never answer questions when we do these presentations." She's like, "Yeah, because I'm a processor. And by the time I process, I feel like the conversation has moved on."
(00:35:28):
And so I really feel like the world, it's not built for somebody like her who's a brilliant product leader, but people couldn't see it. And I realized that so much of what products and just general leadership is, is not just doing the work, but actually... It's not just having the product, it's having great product marketing to go with it. Let's call it that. Okay, so I've been in product and I've been product marketing. You make a light bulb, but you're selling light.
(00:35:53):
I really think about how that she was making amazing number of light bulbs. She was lighting up all the houses, but she was not marketing the light. And I think that was the thing that was really missing. Is that fair? Absolutely not. There are a lot of people who are born introverted. Is it fair that a product manager who isn't introverted, isn't extroverted is struggling with that? No, but that's the world we live in. And so it's one of those things where you get to choose what you do.
(00:36:21):
First, I think for the individual is realizing that you are your own best marketer. You have to actually share what you do. If a great product is out in the world, but no one is told about it, did it exist? And so one of the things that's very important is really to get that product marketing.
(00:36:39):
The second part is we should change our workplaces so everyone can be successful. And I think that that's a really important skill. As more introverts get into leadership, they need to actually change the world to make more space for people like them as well. So one of the things that I found was in my leadership teams over the last several years, we had this thing where we all vote, but we vote offline in a document and we put a number in and then we put our comments in.
(00:37:05):
And that way everyone has an equal voice in this document. And then when we talk about it, usually, of course the extroverts speak first, but everyone has a vote and we can actually see what people's point of views are. And I love that. I love that when there's something we used to do at Facebook is we used to go around in a circle and everybody would give their opinion in a meeting. I do that still today. I ask every single person as a business leader at this company, would you do this?
(00:37:30):
And even I joke with our chief legal officer, Greg, I say, "You are a business leader and the lawyer. You can't just say, well, legal advises X." I'm like, "But what would you do?" And so nobody can take a backseat to decision making. Everybody has a voice. So there's so many of these kind of bias interrupters, things that we can do to actually make the world easier for those who weren't speaking up and taking 80% of the air in the room. And I do think that we have to craft a workplace where everyone can be their best.

**中文翻译:**
首先，我非常喜欢苏珊·凯恩的《安静》（Quiet）。她谈到了内向者的力量。不幸的是，现实世界并不像她那样看待内向者。我写的那篇文章叫《无人谈论的秘密偏见》，即职场确实偏向那些敢于发声的人。我讲过我团队里一个人的故事，她是个非常出色的 PM，但每次到晋升或绩效校准（Calibration）时，大家都会问：“哦，她是干什么的？”这是因为她不擅长宣传或解释自己的工作。
(00:34:54):
我带她去参加高管会议，她很不擅长回答问题或发言。我们为此准备了又准备。我了解她的能力，我每天都能看到她在推动产品前进。但由于某种原因，其他人看不到。因为你的同事对你的评分和晋升也有影响力，我一直在想办法让他们看到她的才华。有一次我问她：“我注意到你在演示时从不回答问题。”她说：“是的，因为我是一个‘处理器’（Processor）。等我处理完信息，对话已经进行到下一个环节了。”
(00:35:28):
我觉得这个世界并不是为她这种天才产品领导者设计的，人们看不见她的光芒。我意识到，产品和领导力不仅仅是完成工作，还包括……不仅仅是拥有产品，还要有出色的“产品市场营销”（Product Marketing）。我既做过产品也做过市场。你制造了灯泡，但你卖的是光。
(00:35:53):
她制造了无数惊艳的灯泡，照亮了所有的房子，但她没有推销这些“光”。这就是缺失的部分。这公平吗？绝对不公平。很多人天生内向。一个内向的 PM 因此而挣扎公平吗？不公平，但这就是现实。所以你必须做出选择。
(00:36:21):
首先，个人要意识到你就是自己最好的营销员。你必须分享你所做的事情。如果一个伟大的产品问世了，但没人知道，它算存在过吗？所以，做好“产品市场营销”非常重要。
(00:36:39):
第二部分是，我们应该改变职场环境，让每个人都能成功。随着越来越多的内向者进入领导层，他们需要改变世界，为同类创造更多空间。过去几年在我的领导团队中，我们实行一种机制：大家在文档中离线投票，输入分数和评论。
(00:37:05):
这样每个人在文档中都有平等的发言权。当我们讨论时，虽然外向者通常先开口，但每个人的投票都在那里，我们可以看到所有人的观点。我非常喜欢这种方式。在 Facebook，我们以前会轮流发言，每个人都要表达意见。我今天依然这么做。作为公司的领导者，我会问每一个人：“你会怎么做？”
(00:37:30):
我甚至会跟我们的首席法务官 Greg 开玩笑：“你既是法务也是业务领导者。你不能只说‘法律建议是 X’，我想知道‘你会怎么做’？”没有人可以在决策中退缩，每个人都有声音。有很多这种“偏见阻断器”可以用来让那些不爱抢话的人更容易发声。我们必须打造一个让每个人都能发挥最佳水平的职场。

---

### (00:37:59) Lenny Rachitsky

**English:**
In the post, you also talk about as much as we want to change the way people run their companies and think. I love your advice of you also still have to learn how to speak up and act more extroverted even though it's not natural to you. Is that right?

**中文翻译:**
在文章中你也提到，尽管我们希望改变公司的运作和思维方式，但你给出的建议是：即使这并非你的天性，你仍然必须学会如何发声，表现得更外向一些。对吗？

---

### (00:38:14) Deb Liu

**English:**
I think we do a disservice when we say we're not good at speaking up because it's a skill like any other. And if I told you the difference between your product being successful and not being successful is you giving this presentation, they're going to kill your product if you don't sell this to the executives. You would figure out a way to stand in front of those executives and defend the freaking heck out of your product. But why aren't you doing that every day?
(00:38:35):
And I think sometimes we forget that not everything is as essential as they're going to cut your product if you can't convince them to keep it. But every day you're actually building credibility for your team, getting more resources, getting more people to talk about your product inside your company, getting more press for the product outside. All of those things combined into momentum for your product. And don't you want the best thing for your product and your customers?
(00:38:58):
So if you think about it that way, it's not, well, I'm uncomfortable. I hear this a lot where people say, "Well, you wouldn't understand. I'm an introvert." And I'm like, "So was I." But instead I just said, "Okay, this is a necessary skill and it's a learnable skill. You don't have to be comfortable with it. You don't have to love it, but you just have to do it."

**中文翻译:**
我认为，当我们说自己“不擅长发声”时，其实是在给自己帮倒忙，因为这和其他技能一样是可以习得的。如果我告诉你，你的产品能否成功，全看你这次演示做得好不好——如果你没能说服高管，他们就会砍掉你的产品。你一定会想方设法站在高管面前，拼了命地捍卫你的产品。但为什么你不能每天都这么做呢？
(00:38:35):
我觉得有时我们忘了，虽然不是每一件事都像“产品要被砍掉”那样紧迫，但你每天其实都在为团队建立信誉、争取资源、让更多同事讨论你的产品、争取外部媒体报道。所有这些加在一起，就是产品的势能。难道你不希望为你的产品和客户争取最好的结果吗？
(00:38:58):
所以如果你换个角度想，这就不是“我感觉不舒服”的问题了。我经常听到有人说：“你不明白，我是个内向的人。”我会回答：“我以前也是。”但我告诉自己：“这是一项必要的技能，而且是可以学会的。你不必感到舒服，也不必爱上它，但你必须去做。”

---

### (00:39:19) Lenny Rachitsky

**English:**
What about from another perspective of why people don't do this, which is it feels like self-promotion and it feels like icky like, "I'm just sitting around promoting myself. I don't want to be doing that." Anything there that helps people get over that piece?

**中文翻译:**
从另一个角度来看，人们不愿发声的原因是觉得这像是在自我推销，感觉很不舒服，比如：“我不想整天坐在那推销自己，那太恶心了。”有什么办法能帮大家克服这种心理吗？

---

### (00:39:31) Deb Liu

**English:**
Well, I just remember I was talking to this ERG group and I was asking about... There was an upcoming calibration and self reviews were due in a couple of days. And I said, "Well, what are you doing for your self-review?" And somebody raised their hand and said, "Well, I'm really bad at self-promotion. What advice would you have for me?" And I said, "If you think your self-review is self-promotion, you're just not going to do a great job at it."
(00:39:56):
What if I called it educating your manager about all the great work your team has been doing? What if I called it helping people see why your team should get more resources? Suddenly you're cracking open, you're changing the question right from, "Oh, I was self-promoting to actually I'm helping my team get more resources and support." And suddenly she was like, "Oh yeah, I never thought about it that way."
(00:40:22):
But I think often if you frame it one way, it looks like self-promotion. I wouldn't want to do that because of self-promotion. But at the same time, if it's education, what if I said, "I was talking to a PM who's really incredible. I've mentored him and sponsored him for a long time." And I said, "I don't understand why you don't have more of a voice. You've learned so much about the craft. You've done this at multiple companies." And he said exactly what you said which is I'm not really self-promoting.
(00:40:46):
And I said, "If you see it as self-promoting, you will never do it." And so let's talk about why you don't actually do this. And he said, "I've seen a lot of people who are really great on LinkedIn write these articles, but they have nothing to back it up." And I don't want to be like them. And I said, "Okay. Well, you read my blog, you follow me on LinkedIn, do you think I have nothing to black back it up?" And he's like, "No, of course not."
(00:41:07):
And I said, "Well, then why do you put yourself in his category instead of mine?" And I think it was just a moment where we just came to an understanding where he in his mind was like, "I don't want to be that person. It's an empty vessel that has no substance behind it." And I said, "Do you think the things I write have no substance?" But it was an interesting conversation because he had taken this mantle that it was self-promotion and that behind what if people think I'm nothing behind it?"
(00:41:32):
I'm like, "I know you have something behind this. I have been your manager. I have worked with you for many years, but you see how just reframing it has really changed his way of thinking about it." Still working on him. But I actually think he has so much to give and I think he has learned so much about the craft, and I wish that more product managers feel comfortable that they have something to give to the world.

**中文翻译:**
我记得有一次在员工资源小组（ERG）演讲，当时绩效校准快到了，自评（Self-review）几天后就要交。我问：“你们自评写得怎么样了？”有人举手说：“我不擅长自我推销，你有什么建议吗？”我说：“如果你把自评看作自我推销，你肯定写不好。”
(00:39:56):
如果我把它称之为“让你的经理了解你团队所做的出色工作”呢？如果我把它称之为“帮助大家理解为什么你的团队应该获得更多资源”呢？突然间，思路就打开了。你把问题从“我在推销自己”变成了“我在帮团队争取资源和支持”。她立刻反应过来：“哦，对啊，我从没这么想过。”
(00:40:22):
我觉得很多时候，如果你把它定性为自我推销，你就不想做。但如果它是“教育”呢？我曾辅导过一位非常优秀的 PM，我问他：“我不明白你为什么不更多地发声。你对这门手艺钻研得这么深，在多家公司都做过。”他说了和你一样的话：“我不想自我推销。”
(00:40:46):
我说：“如果你把它看作自我推销，你永远不会去做。让我们谈谈你为什么不做的真实原因。”他说：“我看到 LinkedIn 上很多人写文章，但其实肚子里没货，我不想成为那样的人。”我说：“好，你读我的博客，在 LinkedIn 上关注我，你觉得我肚子里没货吗？”他说：“当然不是。”
(00:41:07):
我说：“那你为什么把自己归入那一类，而不是我这一类呢？”那一刻我们达成了一种共识。在他脑子里，他不想成为那种“没有实质内容的空罐子”。我说：“你觉得我写的东西没有实质内容吗？”这是一次有趣的谈话，因为他给自己贴上了“自我推销”的标签，并且担心别人觉得他虚有其表。
(00:41:32):
我说：“我知道你有真才实学，我当过你的经理，和你共事多年。你看，仅仅是重新定义（Reframing）这件事，就改变了他的思维方式。”我还在继续引导他。我真心觉得他有很多东西可以贡献，他学到了很多关于产品工艺的知识。我希望更多的产品经理能感到自信，相信自己有东西可以贡献给世界。

---

### (00:41:53) Lenny Rachitsky

**English:**
I think what you're saying right now will resonate with a lot of people when they see people posting. I feel the still of just like, "I don't want to be this guy that's just posting nonsense on LinkedIn just to get likes," even though it's kind of what I do now full time. Hopefully it's not nonsense.

**中文翻译:**
我觉得你刚才说的话会让很多人产生共鸣。当人们看到别人发帖时，依然会有这种感觉：“我不想成为那种为了骗赞在 LinkedIn 上发废话的人。”尽管我现在全职在做这件事（笑），希望我发的不是废话。

---

### (00:42:08) Deb Liu

**English:**
But it is all substance. So, Lenny, we know the substance behind it.

**中文翻译:**
但你发的东西都是有实质内容的。Lenny，我们都知道背后的含金量。

---

### (00:42:11) Lenny Rachitsky

**English:**
I tried, but I think there's posting on LinkedIn, posting on Twitter. There's like an innate just doing this because I want to get attention when often... And the way I started this is just like things I've learned that I think are useful, I'm just going to put them out there. So just to double click a little bit, I think this is a really powerful point. What actually have you found helps people get over that? Is it someone like you and his corner being like, "You have really great stuff to share, you should actually do it. Don't be as worried as you are, as you think you might be." Is there anything else that works there?

**中文翻译:**
我尽力而为。但我认为在 LinkedIn 或 Twitter 上发帖，人们往往有一种本能的排斥，觉得是为了博关注。我开始做这件事的初衷只是：“这些是我学到的有用的东西，我想分享出来。”所以我想深入探讨一下，这是一个非常有力的观点。你发现到底什么能帮人们克服这种心理？是像你这样的人在旁边鼓励说“你有很棒的东西要分享，去做吧，别担心”？还有别的方法吗？

---

### (00:42:41) Deb Liu

**English:**
Actually what worked for me was I was working with Bos and I talk about our relationship in my book, but we made a contract when I started reporting to him. And Bos, for those of you don't know, is currently the CTO of Meta. At the time he was the head of ads and then our team moved into his team. And so I was reorged into his organization. And as I said we did not have the best relationship before that. And so we made a contract to work together and I had written like, "Here's how I want you to take care of my team. Here's how I want you to support our products." And I wrote them this long, my part of the commitment.
(00:43:13):
Then he wrote back, "Here's what I'm asking of you. I want you to write and publish something every month." I was like, "What are you talking about? Why would you say that?" He said, "You have so much to teach people. Just do it." I said, "I don't really have that much to say." And he's like, "Just trust me on this. You'll figure it out." His advice was write what you repeat. If you say something more than once, just write it down. And then the next time someone asks you, you can just hand them.
(00:43:40):
He has a great blog if you have read it. I just normally thinking that is a weird thing for your new manager to say after you had a lot of conflict together before that. But he took my contract, which was... By the way, he's like, "Oh, do you want to codify this in some way?" I'm like, "No, I just..." But every month from then on, I would literally just write something and it was my promise to him. And I did it faithfully and I published it internally. So I didn't publish it externally for a long time.
(00:44:04):
And then sometimes they would ask me if I want to publish it externally for the company and I would say yes. And so I did it for years. I reported to him for years. And then we switched managers. He moved over to Reality Labs and then I had a new manager and I continued and I continued this. Then I started doing a publicly, and then obviously I wrote a book. Because of him and his encouragement, it got me to a totally different place. And part of it was just the commitment. I now had accountability because I knew he was watching. I'm not actually sure if he was actually watching every month. But I felt the accountability to do this and I've done it every single month since.

**中文翻译:**
对我来说，真正起作用的是我和 Bos 的合作。我在书里写过我们的关系。Bos 现在是 Meta 的 CTO，当时他是广告业务负责人，我的团队被重组到了他的部门。如我所言，我们之前的关系并不好。所以我们签了一个合作“契约”。我写道：“我希望你如何照顾我的团队，如何支持我们的产品。”我写了很长一段我的承诺。
(00:43:13):
他回信说：“这是我对你的要求：我希望你每个月写点东西并发布出来。”我当时想：“你在说什么？为什么要我这么做？”他说：“你有很多东西可以教给别人，去做吧。”我说：“我没什么可说的。”他说：“相信我，你会找到话题的。”他的建议是：写下你重复说的话。如果你一件事说了不止一次，就把它写下来。下次有人问你，你直接把文章甩给他就行。
(00:43:40):
如果你读过他的博客，你会发现写得很棒。我当时觉得，对于一个之前有过冲突的新经理来说，这个要求很奇怪。但我接受了。从那以后，我每个月都会写点东西，这是我对他的承诺。我忠实地执行了，最初只在公司内部发布。
(00:44:04):
后来公司有时会问我是否愿意对外发布，我同意了。我坚持了很多年。后来他去了 Reality Labs，我换了经理，但我依然坚持。接着我开始公开写作，最后写了一本书。正是因为他的鼓励，我达到了一个完全不同的境界。部分原因在于这种“承诺”。我有了责任感，因为我知道他在看着（虽然我不确定他是不是每个月都看）。但我感到了这种责任，从那以后我每个月都写。

---

### (00:44:37) Lenny Rachitsky

**English:**
So it's interesting that that's another example of your manager giving you the space slash forcing you to share publicly being a really good lever to get someone over this fear.

**中文翻译:**
很有趣，这是另一个经理通过给予空间或“强迫”你公开分享，从而帮你克服恐惧的绝佳例子。

---

### (00:44:48) Deb Liu

**English:**
I think sometimes just doing it gets you over the hump. For example, my friend, Ami Vora. She writes an incredible blog. You have not read her Substack, you should. But she's an incredible writer. She'd write all these things internally and I said, "You should publish this externally." Now she does that and it's really great. And I think part of it was just seeing her just put it out there because she is one of the wisest career coaches that I have and managers that I have ever worked with. And so I'm like, "You have so much to say and to share."
(00:45:16):
So to see it out there, I feel like for years we all got the benefit of it because we knew her. But the world was not getting the benefit. So in some ways just having accountability. So we created a little accountability group to help each other write, and it was just a reminder, "Hey, did you do it?" And so I think it's sometimes what's necessary to get over that hump is either having someone forcing you, like your manager who you made a commitment to, or just having a friend to say, "Hey, by the way, where's this month's post?"
(00:45:41):
Those things matter because now you got over the hump of, "I have to do it." And now it's just about how good you're going to make it and how much time you're going to put into it.

**中文翻译:**
我觉得有时候“直接去做”就能帮你跨过那道坎。比如我的朋友 Ami Vora，她写博客非常棒。如果你没读过她的 Substack，一定要去读读。她是个了不起的作家。她以前只在内部写，我对她说：“你应该发到外面去。”现在她这么做了，反响很好。我觉得部分原因在于看到她把东西发出来，因为她是我合作过的最睿智的职业教练和经理之一。我想：“你有这么多真知灼见可以分享。”
(00:45:16):
看到她公开分享，我觉得很有意义。多年来只有我们这些认识她的人受益，而世界却没能受益。所以，某种程度上，建立“问责制”很有帮助。我们成立了一个互助小组，互相提醒：“嘿，你写了吗？”我觉得跨过那道坎有时需要一点外力，要么是经理的“强迫”，要么是朋友的提醒：“嘿，顺便问下，你这个月的文章呢？”
(00:45:41):
这些都很重要，因为一旦你跨过了“我必须做”这道坎，剩下的就只是如何把它写好、投入多少时间的问题了。

---

### (00:45:49) Lenny Rachitsky

**English:**
Awesome advice. And by the way, folks don't know we've had both Bos and Ami on the podcast in the past.

**中文翻译:**
很棒的建议。顺便提一下，听众们可能不知道，Bos 和 Ami 以前都上过我们的播客。

---

### (00:45:55) Deb Liu

**English:**
Aren't they both amazing?

**中文翻译:**
他们都很棒，不是吗？

---

### (00:45:56) Lenny Rachitsky

**English:**
Amazing. And Ami's episode is one of the most popular episodes. More popular than Bos, CTO of Meta.

**中文翻译:**
非常棒。Ami 那一集是最受欢迎的剧集之一，甚至比 Meta CTO Bos 那集还火。

---

### (00:45:56) Deb Liu

**English:**
I know.

**中文翻译:**
我知道。

---

### (00:45:56) Lenny Rachitsky

**English:**
Who would've thought?

**中文翻译:**
谁能想到呢？

---

### (00:46:06) Deb Liu

**English:**
She has a lot of coaching wisdom I think that everyone should hear.

**中文翻译:**
她有很多关于职场辅导的智慧，我觉得每个人都应该听听。

---

### (00:46:08) Lenny Rachitsky

**English:**
Yeah, she's amazing. She has a great Substack. We'll link to it again in the show notes. We'll link to your Substack as well.

**中文翻译:**
是的，她很棒。她的 Substack 也很精彩。我们会再次在节目介绍中附上链接，也会附上你的 Substack 链接。

---

### (00:46:13) Deb Liu

**English:**
Yeah, please do.

**中文翻译:**
好的，麻烦了。

---

### (00:46:15) Lenny Rachitsky

**English:**
Go Substack. I want to move in a slightly different direction. Talk about growth for a little bit. You have a really nice perspective on how to think about growth. I think a lot of people think of growth as like, "Here's a magic bullet. We're going to do this thing. It's going to go, "Wow, we're going to win." And your approach is, you talk about it, it's a game of inches. Growth is a game of inches. Can you talk about your perspective there?

**中文翻译:**
Substack 加油。我想换个话题，聊聊增长。你对增长的看法非常独到。我觉得很多人认为增长就是“灵丹妙药”：我们做这件事，然后“哇”的一声，我们就赢了。而你的方法是，你把它称之为“厘米级的游戏”（A game of inches，意为寸进）。增长是寸进的积累。能谈谈你的观点吗？

---

### (00:46:34) Deb Liu

**English:**
Yeah. Sometimes we think it's like what is the huge step function? But actually most companies are like... We call it points of growth, right? It's like if you can move things 1% a little bit faster every single week, think about the amount of growth you get at the end. And so it's not just, "Okay, what's going to get you the 3X? You can get to 3X 1% at a time, 5% at a time. Single digit growth. And sometimes it is the small things that matter the most. And so we think about product-led growth, it's really about finding the aha moments, the opportunities. And sometimes opportunities are things that seem really silly.
(00:47:10):
I heard the story at Facebook that one of the big things was just adding the, next to ads, they put the word create an ad, was one of the biggest growth drivers. And that was it just putting a link because people just didn't know how to get to the ads flow. It was things like that where you can actually bend the curve of choices that you make. Same thing, each of the growth teams I've ever worked on, it's like really the small things adding up. It is a list we used to work on payments growth and we had a list of a hundred things we were working on hypotheses.
(00:47:42):
And then we would pick and we would grow them by picking the first 10 and we would start working on them, the next 10, the next 10, and we would go through these sprint cycles. And the same thing when we were growing the ads product as well. Marketplace, each of them were just like, "What are the small things that add up to big things?" And I think sometimes we overthink it.
(00:48:00):
Instead, you probably have a hundred ideas. And by the way, it is absolutely okay if the 80% of them don't work. I tell people sometimes we overthink as product manager if we just had the perfect plan, the perfect battle plan, but instead imagine you're a team and you can ship, I don't know, let's say four things. But what if you're a team that can ship 20 things with the same with a 20% success. You get just as much output and yet you know what doesn't work also.
(00:48:30):
What if you can move it from 20% to 30%? Suddenly six things work, not just four things. And so in the same amount of time you have all the lessons of what didn't work, plus you're getting 50% more output. And so you thinking about growth as this engine of, it's a learning machine of what doesn't work, what you reiterate on, what you change, and you're constantly getting better and better and better.

**中文翻译:**
是的。有时我们总在想什么是巨大的“阶跃函数”（Step function，指爆发式增长）。但实际上，大多数公司都是靠我们所说的“增长点”积累起来的。如果你每周能让某件事快 1%，想想最后累积的增长量。所以，这不只是“什么能让你增长 3 倍”，你可以通过每次 1%、5% 的个位数增长最终达到 3 倍。有时，最微小的事情反而最重要。当我们谈论“产品驱动增长”（PLG）时，核心是寻找“Aha 时刻”和机会。有些机会看起来甚至很傻。
(00:47:10):
我听过一个 Facebook 的故事：当时最大的增长驱动力之一，仅仅是在广告旁边加了一个“创建广告”的链接。就这么简单，因为人们之前不知道怎么进入广告流程。就是这类事情能改变你决策的曲线。同样，我待过的每个增长团队，都是靠这些小事的累积。我们以前做支付增长时，有一份包含 100 个假设的清单。
(00:47:42):
我们会挑选前 10 个开始做，然后是下 10 个，不断进行冲刺周期（Sprint cycles）。在做广告产品和 Marketplace 时也是如此。重点是：“哪些小事加起来能变成大事？”我觉得有时我们想得太复杂了。
(00:48:00):
实际上，你可能有 100 个想法。顺便说一下，即使其中 80% 不起作用也完全没关系。我常告诉 PM，不要总想着制定完美的作战计划。想象一下，如果你的团队只能交付 4 件事；但如果你的团队能交付 20 件事，哪怕成功率只有 20%，你的产出是一样的，而且你还知道了哪些行不通。
(00:48:30):
如果你能把成功率从 20% 提高到 30%，突然间就有 6 件事成功了，而不是 4 件。在同样的时间里，你吸取了所有失败的教训，产出还增加了 50%。所以，要把增长看作一个引擎，一个关于“什么行不通、如何迭代、如何改变”的学习机器，这样你就会不断变得更好。

---

### (00:48:50) Lenny Rachitsky

**English:**
I think what you're saying will resonate with a lot of product people where there's always this like, "We're just doing a bunch of optimization, incremental work. Still sucks, boring. Let's take some big bets." And in my experience, and sounds like in your experience, a lot of the wins actually... And Facebook is famous for this, just relentlessly looking for ways to grow, optimize, optimize, optimize because that's where a lot of growth comes from.
(00:49:14):
At the same time, obviously you need to take some big bets and take some swings and look for step function changes. But I guess for someone that's just like... I don't know. Is there any advice on just creating that culture of like, "It's okay to optimize for a long time, there's a lot of opportunity optimizing"? Is there anything you've learned there or is it just bringing in a Deb and it has to be a top down?

**中文翻译:**
我觉得你的话会让很多产品人产生共鸣。大家总会抱怨：“我们只是在做一堆优化和增量工作，太无聊了，让我们来场豪赌吧。”但在我的经验中，听起来在你的经验中也是如此，很多胜利其实……Facebook 就以这种“不懈寻找增长点、不断优化再优化”而闻名，因为很多增长确实源于此。
(00:49:14):
当然，你也需要进行一些大赌注，寻找阶跃式的变化。但对于那些觉得优化很枯燥的人，你有什么建议来建立一种“长期优化也是可以的，优化中蕴含巨大机会”的文化吗？你在这方面学到了什么？还是说必须像你这样的人空降下来，从上到下推动？

---

### (00:49:32) Deb Liu

**English:**
I treat growth like, let's say, a product marketing team. It is an augmentation for a product that works. So if you have a core product that works, you have a team that's working on... So for us at Ancestry, it's like search and hints of the core. What is the mechanics? You want people to add people to their family tree. You want them to add stories, okay? There's teams that make sure that the uptime is good, that the hints are working, the search delivers results.
(00:49:57):
And you need those teams, you need those core teams kind of functioning. But growth is actually optimization on top. It is making it so that you get to the search flow faster. The hints are surfacing better, that people are accepting them, that if we put the button here versus here, that people are going to discover things faster. And so it's really taking the core engine and actually wrapping it around the user interface around the experience, around the flows so that people can get to it faster, they can have more satisfaction, they can have more impact. And that's what I see growth as. It's not the core product. It is the cherry on top, making that product more accessible and more usable and better every single day.

**中文翻译:**
我把增长看作是，比方说，一个产品市场团队。它是对一个已经奏效的产品的增强。如果你有一个核心产品，比如在 Ancestry，核心是搜索和提示（Hints）。机制是什么？你希望人们把亲属加入家谱，希望他们添加故事。有专门的团队负责确保系统运行稳定、提示功能正常、搜索结果准确。
(00:49:57):
你需要这些核心团队正常运作。但增长实际上是在此之上的优化：让用户更快进入搜索流程，让提示更精准地浮现，让人们更容易接受提示，或者通过调整按钮位置让人们更快发现功能。所以增长是提取核心引擎，并围绕用户界面、体验和流程进行包装，让用户能更快触达、更满意、产生更大影响。这就是我眼中的增长：它不是核心产品本身，它是锦上添花，让产品每天都变得更易用、更好用。

---

### (00:50:37) Lenny Rachitsky

**English:**
Along these lines, I think it surprised people to learn. There's at least a hundred people at our Airbnb just working on pricing, optimizing pricing recommendations. There's endless opportunity to just make all these core components of an experience better and better and better over time. Okay. Last thing I want to talk about, and this is completely unrelated to everything we've been talking about mostly, which is your 30, 60, 90-day plan.
(00:51:00):
So you wrote this post a while ago, just like, here's a great 30, 60, 90-day plan when you join a company. I've heard that many people use this. It's really effective for helping someone onboard and be successful. And I think it's mostly for execs or is this for just anyone joining a company?

**中文翻译:**
顺着这个思路，我想很多人会惊讶地发现，在 Airbnb 至少有 100 人专门负责定价，优化定价建议。随着时间的推移，不断改进这些核心体验组件的机会是无穷无尽的。好，最后我想聊聊一个与之前话题不太相关的内容：你的“30-60-90 天计划”。
(00:51:00):
你不久前写过一篇文章，分享了加入公司时的一套绝佳的 30-60-90 天计划。我听说很多人都在用，它对帮助新人入职并取得成功非常有效。我想问，这主要是针对高管的，还是适用于任何加入公司的人？

---

### (00:51:16) Deb Liu

**English:**
It's for anyone.

**中文翻译:**
适用于任何人。

---

### (00:51:17) Lenny Rachitsky

**English:**
Okay, anyone.

**中文翻译:**
好，任何人。

---

### (00:51:18) Deb Liu

**English:**
I created, it's actually when I joined Ancestry because I hadn't started a real new job in 11 years. And I thought, I'm going to be a student of how to land well. So I read a bunch of things, I read and I decided I was going to adapt all of those things into a summary and then I was going to try it real time in my blog.
(00:51:38):
So in my blog I write, "Here's what I'm going to do," and then I tell you what I did and how it worked and some things. And then I actually do a look back as to all the mistakes I made. And so I did this live. It was not planned quite as well as I would thought, but I put it together and I wrote the 30, 60, 90-day plan and I have a template. I always tell people it's focused on listening and learning first and then doing. So that's the crux of it, which is in those 90-days it's like you got to get used to the environment. You want to have some impact at the start. You want to have a couple quick wins, but you want to understand the lay of the land and you want to listen because you have something to contribute.
(00:52:19):
But if you don't understand the language, you don't understand the culture, you might actually make huge mistakes. And so for the first 30 days, I did a listening tour. I talked to over 60 people in 30 days and then I summarized a state of the union. Here's what I'm hearing, here are the challenges people feel like we're facing. Here's what people's wishlists are. And by the way, one person sent me a wishlist of five things and at that year, I think it took me till year two to finish his five things. And then I sent him a note. I said, "By the way, the first time we met, these five things you wanted to see, we just finished the last one."
(00:52:50):
And he's like, "I can't believe you remember." I took extensive notes and I summarized it. I think it's important because people want to hear that you hear them. And you don't have to be a manager or CEO to do that. I think people on teams often feel like there's no outlet for the things that they want to say. I encourage, especially product leaders, especially if you're joining an existing team, to listen really behind what people are saying and then offer to help them do one thing.
(00:53:17):
So especially when you're meeting with a new engineering team for the first time, actually ask them, what is one thing I can do to help you this week? I always say one thing, it's limited. This week, so getting 15 new headcount. Probably not going to happen. And it's like, how can I give back? And suddenly you're building a reciprocal relationship. And so a lot of this 30, 60, 90-day plan is really to help you find your footing and then to start having impact immediately.

**中文翻译:**
我创建这个计划是在加入 Ancestry 时，因为我已经 11 年没换过新工作了。我想，我要学习如何“平稳着陆”。于是我读了很多资料，决定把它们总结起来，并在我的博客上实时尝试。
(00:51:38):
我在博客里写下“我打算做什么”，然后记录我做了什么、效果如何。最后我还回顾了自己犯的所有错误。我是现场直播式地做这件事。虽然计划没我想象中那么完美，但我把它整理成了 30-60-90 天计划并提供了一个模板。我总是告诉大家，核心是“先倾听和学习，后行动”。在这 90 天里，你得适应环境。你希望一开始就有影响力，拿到一些“快速胜利”（Quick wins），但你必须先了解情况并倾听，因为你是有备而来的。
(00:52:19):
如果你不懂这里的语言和文化，你可能会犯大错。所以头 30 天，我做了一次“倾听之旅”。我在 30 天内和 60 多人聊了天，然后总结了一份“现状报告”：这是我听到的，这是大家认为我们面临的挑战，这是大家的愿望清单。顺便说一下，有个人给了我一份包含 5 件事的愿望清单，我大概花了两年时间才全部完成。完成后我给他发了条信息：“顺便说下，我们第一次见面时你提到的那 5 件事，我们刚刚完成了最后一件。”
(00:52:50):
他回道：“真不敢相信你还记得。”我做了大量的笔记并进行了总结。我认为这很重要，因为人们希望知道你听到了他们的声音。你不需要是经理或 CEO 才能这么做。团队成员往往觉得没有渠道表达想法。我鼓励大家，尤其是产品领导者，在加入现有团队时，要深入倾听人们话语背后的含义，然后主动提出帮他们做一件事。
(00:53:17):
特别是第一次见新的工程团队时，问问他们：“这周我能帮你做的一件事是什么？”我总是强调“一件事”，这是有限度的；强调“这周”，所以“增加 15 个名额”这种事就不太可能。这就是如何回馈团队。突然间，你就建立了一种互惠关系。所以，这个计划的核心是帮你站稳脚跟，然后立即开始产生影响。

---

### (00:53:43) Lenny Rachitsky

**English:**
Say you join a company and you're like, "I'm going to do 30 days listening," and then your boss is like, "No, we need to ship stuff. Get on it, ship this stuff." Is there any advice for trying to push back on that, create space for listening when there's deadlines, things aren't [inaudible 00:53:56]?

**中文翻译:**
假设你加入一家公司，你说“我要做 30 天倾听”，但你的老板说：“不，我们需要交付东西。赶紧动手，把这些发了。”对于这种压力，你有什么建议来回绝，或者在有截止日期的情况下为倾听创造空间？

---

### (00:53:57) Deb Liu

**English:**
I encourage everybody to get on the same page on this 30, 60, 90-day plan with their manager. So actually don't just keep it to yourself. Share it with as many people as you can. So I think it's very important that everyone sees what you're trying to accomplish and what your output is going to be. Because if you don't know the output, is success there? The second part is with your manager say, "Okay. I would like to carve 20% of my time listening and I'm happy to do this work 80% of the time." Therefore every morning from nine to 10, I want to talk to somebody in the organization.
(00:54:28):
Just make sure you say, "I will do a better job and have more impact if I have this time to make sure that I'm not accidentally making mistake or I don't get a chance, I'm asking something of somebody, but I've never met them." And to really carve out space because it's really important. Once you're in it, people give you the new person card for maybe a month or two and then suddenly it's all the problems are your problems.
(00:54:53):
But what if you don't know what the problems are? And so I always say diagnose before you treat. So make sure you understand so that you can help and deliver what your manager is actually expecting of you.

**中文翻译:**
我鼓励每个人都就这个 30-60-90 天计划与经理达成共识。不要把它藏在心里，尽可能多地分享给别人。让大家看到你试图实现的目标和预期的产出非常重要。因为如果没有明确的产出，何谈成功？第二部分是跟经理商量：“好，我想抽出 20% 的时间来倾听，剩下的 80% 时间我会全力投入工作。”比如每天早上 9 点到 10 点，我想和公司里的人聊聊。
(00:54:28):
一定要强调：“如果我有这段时间来确保不犯低级错误，或者在求人办事之前先认识一下对方，我能做得更好，影响力也更大。”一定要挤出这段空间，这非常重要。一旦你入职一两个月，“新人免死金牌”就失效了，所有的烂摊子都会变成你的问题。
(00:54:53):
但如果你连问题是什么都不知道呢？所以我常说“先诊断，后治疗”。确保你理解了现状，这样你才能真正帮上忙，并交付经理对你的期望。

---

### (00:55:04) Lenny Rachitsky

**English:**
I'm looking at your template. So just to share the bucket. So first 30 days learning focus, second 30 days is aligning on vision for the future, and the last 30 days of the 90 days is executing, setting up, actually starting to get stuff done. Awesome. Anything else along these lines of this?

**中文翻译:**
我正在看你的模板。简单分享一下这几个阶段：头 30 天以学习为中心；第二个 30 天是就未来愿景达成一致；最后 30 天是执行、搭建并真正开始出成果。太棒了。关于这方面还有什么要补充的吗？

---

### (00:55:23) Deb Liu

**English:**
The one thing about having a plan also is that you don't feel rushed to do something that you're not ready for because I do think sometimes you feel like you need to have impact. I always tell people, "Do something small, give back in some ways that people see you making." But when you actually reflect, one of the biggest things I could do was actually reflect back to the organization, "Here's what I heard from all of you. I'm listening, I hear this and here's what I want to do about it."
(00:55:53):
And then in aligning it's like, "Do we agree this is a set of problems we want to tackle?" And then an execution is like, "Do we agree that this is how we want to move forward?" And I think that is such an important part of building into a team. When you enter an organization, you're also entering a team and you're part of a dance that's going around. What role do you play? And people are dancing around you and if you actually make a mistake, you could trip other people up as well. So really finding your place in the dance is really important.

**中文翻译:**
有计划的另一个好处是，你不会因为还没准备好就急于求成。我觉得有时人们会觉得必须立刻产生影响力。我常说：“做点小事，以某种方式回馈，让大家看到你在努力。”但当你真正进行反馈时，我能做的最伟大的事情之一就是向组织反馈：“这是我从你们所有人那里听到的。我在倾听，我听到了这些，这是我打算做的。”
(00:55:53):
在“达成一致”阶段，就是问：“我们是否同意这是我们要解决的一系列问题？”在“执行”阶段则是：“我们是否同意这是我们要前进的方向？”我认为这是融入团队的重要部分。当你进入一个组织，你也是进入了一个团队，你成了正在进行的舞蹈的一部分。你扮演什么角色？大家都在你身边起舞，如果你跳错了步子，可能会把别人绊倒。所以，在舞蹈中找到自己的位置非常重要。

---

### (00:56:21) Lenny Rachitsky

**English:**
And as a PM, the way I always think about is people won't assume they should trust you. You're just this person that's coming in to tell them what to do and so much of your first month, two, three is building that trust with people so that they can actually feel comfortable listening to your guidance and not just like, "Oh my god. This person is getting in my way."

**中文翻译:**
作为 PM，我一直认为：人们不会理所当然地信任你。你只是个空降过来告诉他们该做什么的人。所以头一两个月的大部分工作是建立信任，让他们能放心地听从你的指导，而不是觉得“天哪，这家伙在挡我的路”。

---

### (00:56:40) Deb Liu

**English:**
And earning that trust, sometimes people really... You'd be really surprised, a lot of people feel like they're not heard and even just coming in and listening is a trust building exercise.

**中文翻译:**
赢得信任……有时你会惊讶地发现，很多人觉得自己没被倾听，仅仅是走过去倾听他们，本身就是一种建立信任的练习。

---

### (00:56:51) Lenny Rachitsky

**English:**
Such a good point. As we wrap up our conversation, just a couple more questions here. So first is I want to take us to Contrarian Corner, which is a segment on this podcast. And my question is there something that you believe that you think most other people don't believe? Something that you think is a contrarian perspective?

**中文翻译:**
说得太好了。在结束对话之前，还有几个问题。首先是我们的“非共识角落”（Contrarian Corner）环节。我的问题是：有没有什么事情是你相信，但大多数人不相信的？也就是你的非共识观点。

---

### (00:57:10) Deb Liu

**English:**
I don't know if this is a contrarian perspective, but I go to speak in a lot of universities. So I speak at Stanford and I'm going to speak at Duke. And I always tell people, especially young people, the most important career decision you make is who you marry. And it's not something we think that much about, especially I started dating... I met my husband when I was 18, my first weekend in college. Started dating when I was 19. We had no idea what our life was going to be like and yet every single day like this week we had our board meeting, I was in Utah the whole week. I come home and he's taking care of everything.
(00:57:43):
You will have a much more successful career if your home life is in balance. It's like a yin and a yang. If something is out of balance, it engulfs the other side. Both your job and your home life. And especially, we have three kids. Really balancing that is very hard over both of us having demanding careers. It's not something that's contrarian, but it's something which we don't think about at all when we make that decision. We think is this person fun to be with? Is this person somebody we see ourselves with? But my question is what is the impact of this relationship on your career?
(00:58:14):
Is this person lifting you up or pushing you back? Is this person someone who's going to be your greatest cheerleader or are they going to be the greatest weight on you? How do you think that that's going to manifest itself 20 years, 30 years from now? And I think it's just something I wish we thought about more and I encourage especially young people to think about that.

**中文翻译:**
我不确定这算不算非共识观点，但我经常去大学演讲，比如斯坦福和杜克。我总是告诉年轻人：你一生中最重要的职业决策是选择和谁结婚。我们平时不太考虑这个。我 18 岁上大学第一个周末就认识了我丈夫，19 岁开始约会。当时我们完全不知道未来生活会怎样。但现在，比如这周我在犹他州开了一整周董事会，回到家，他把一切都打理得井井有条。
(00:57:43):
如果你的家庭生活处于平衡状态，你的职业生涯会成功得多。这就像阴阳。如果一方失衡，就会吞噬另一方，无论是工作还是家庭。特别是我们有三个孩子，在两人都有高压工作的情况下，平衡是非常难的。这也许不是非共识，但我们在做决定时往往根本不考虑这一点。我们只考虑对方是否有趣，是否想在一起。但我的问题是：这段关系对你的职业生涯有什么影响？
(00:58:14):
这个人是在成就你，还是在拖累你？这个人会是你最大的拉拉队长，还是你最大的负担？你觉得 20 年、30 年后这会如何体现？我希望大家能多思考这个问题，尤其是年轻人。

---

### (00:58:33) Lenny Rachitsky

**English:**
Such a great point. What I want now is a guide for vetting these things when you're dating. Deb's guide to dating.

**中文翻译:**
非常有道理。我现在想要一份“约会时的背景调查指南”——Deb 的约会指南。

---

### (00:58:44) Deb Liu

**English:**
I need to write that. Although I've only really dated him, the one person, so maybe I am like the worst person to tell.

**中文翻译:**
我确实该写写。不过我这辈子其实只跟他一个人约会过，所以我可能是最没资格说这个的人（笑）。

---

### (00:58:49) Lenny Rachitsky

**English:**
But it worked, so you're maybe the best person and now you look back.

**中文翻译:**
但结果很成功啊，所以回顾过去，你也许是最有资格说的人。

---

### (00:58:49) Deb Liu

**English:**
That's right. That's right.

**中文翻译:**
没错，没错。

---

### (00:58:53) Lenny Rachitsky

**English:**
And here's the questions I asked that worked. That's so funny. Okay, so before we get to our very exciting lightning round, is there anything else that you think might be helpful to share, something you might want to leave listeners with? Any other nuggets of wisdom or advice?

**中文翻译:**
“这是我问过且奏效的问题”，太逗了。好，在进入激动人心的闪电轮问答之前，还有什么你想分享给听众的吗？还有什么智慧锦囊或建议吗？

---

### (00:59:08) Deb Liu

**English:**
Well, there's one quote which I share, I thought about when you were speaking earlier, which is about people who are resilient, which is life... This is a quote from Chuck Swindoll, he's a Christian writer I used to read a lot and it was, "Life is 10% what happens to you and 90% how you react to it." And I just looked him up recently and he actually published a book with that quote. He actually had that quote in a previous book from 20 years ago.
(00:59:34):
And I just think that's so important. You don't get to choose everything that happens in your life. So much is just, it just happens, but it's the people who choose a way forward to turn stumbling blocks and the stepping stones. As I said, "Somebody who actually says, 'you know what? I didn't get the job that I wanted and I'm just going to figure out another path,' those are the people who have the most successful and satisfying careers." They're thinking when other people are zagging vice versa. And I think that there are the ones who are the most resilient and happy in the long term.

**中文翻译:**
有一句话我想分享，刚才谈到韧性时我也想到了。这是 Chuck Swindoll（我以前常读的一位作家）说的：“生活 10% 取决于发生了什么，90% 取决于你如何应对。”我最近查了一下，他 20 年前就在书里写过这句话。
(00:59:34):
我觉得这太重要了。你无法选择生活中发生的一切，很多事就是发生了。但那些选择向前看、将绊脚石化为垫脚石的人，才是最终成功的人。正如我所说，那些说“虽然我没拿到想要的职位，但我会另辟蹊径”的人，往往拥有最成功、最满足的职业生涯。他们在别人随大流时独立思考。我认为他们是长期来看最有韧性、最快乐的人。

---

### (01:00:06) Lenny Rachitsky

**English:**
It's such a good circle back to one of your first pieces of advice of just most successful people are people that are resilient and don't avoid failure, but embrace it and find a way to turn that around. I think it's such an important point. It's so hard to do. I guess just, I don't know, just to follow this thread a little bit, is there anything that has helped you build that? Has that always been the way your mind worked? I imagine coaching helps this, helps people with this." Is there anything just like that?

**中文翻译:**
这很好地呼应了你最初的建议：最成功的人是那些有韧性、不逃避失败、反而拥抱失败并扭转局面的人。这非常重要，但也非常难做到。顺着这个思路，我想问：有什么东西帮你建立了这种心态吗？你天生就这么想吗？我猜职业辅导（Coaching）会有所帮助。

---

### (01:00:29) Deb Liu

**English:**
Coaching is incredible for that. We joke it's work therapy, but really I think it's... For a long time I saw failure as this catastrophic thing. I was one of those kids who's like, "You never got a B until..." Then I got to college and I was like, "Wow, this is harder than I thought." And so I got two B's in college and I'm like, "I'm never doing that again." But I was that kid who always got the A, who got the great scores. I just thought that my life would end if I got a B which by the way is super unhealthy.
(01:01:00):
And looking back, I realized that work is not like that at all. And every time I got bad feedback I'm like, "This is catastrophic." But if you look at feedback as an opportunity, then it's very different. It's like this is a gift. I would be crushed. Every time I get a review no matter what rating I got, I would read the things that people would say and I was like, "Oh my gosh, I'm a terrible person." And I had to really rethink that. And I think coaching, leadership coaching has really helped me through that to say, "No, how do you process this and how do you get to the other side?"
(01:01:33):
And that has been so transformative for me is to have that outlet to actually talk through. No, no, no. What they're saying is not that you're a bad product person, it's that you need to do a better job communicating or connecting. And I really struggled with that. I was very transactional. I was not a connector. I was not warm. I really struggled with relationships. And a lot of the feedback I received for many years is this relationship issue. And it took me a long time to realize that people aren't saying this because I'm a bad person or that they hate me, but because they want to connect.
(01:02:03):
I was actually making it hard. And I think sometimes we take things so personally that it becomes kind of this thing. It is your white whale. It's like the thing you're chasing, but then what if you say, "You know what, I don't need to do that. I don't need to chase that. Instead I need to figure out what's behind the feedback and what are they trying to say?" And then actually change yourself over a long period of time towards that.

**中文翻译:**
辅导确实非常有效。我们开玩笑说它是“职场心理治疗”。在很长一段时间里，我把失败看作是灾难性的。我是那种从小到大没拿过 B 的孩子，直到上了大学，我发现“哇，这比我想象的难多了”。我在大学拿了两个 B，当时我想“我再也不要这样了”。我习惯了拿 A，拿高分。我当时觉得拿个 B 人生就毁了，这其实非常不健康。
(01:01:00):
回过头看，我意识到工作完全不是那样的。以前每次收到负面反馈，我都觉得是灭顶之灾。但如果你把反馈看作机会，情况就完全不同了。它是一份礼物。以前无论绩效评级如何，只要看到别人的负面评价，我都会崩溃，觉得“天哪，我是个差劲的人”。我必须重新审视这一点。领导力辅导帮我度过了难关，教我如何处理这些信息并走向另一端。
(01:01:33):
这种转变对我来说是革命性的，它给了我一个出口去倾听：不，不，不，他们不是说你产品做得不好，而是说你需要在沟通或建立联系方面做得更好。我以前在这方面很挣扎，我做事非常“事务性”（Transactional），不擅长社交，也不够热情。多年来我收到的很多反馈都指向人际关系问题。我花了很久才意识到，人们这么说不是因为我人坏或者他们恨我，而是因为他们想建立联系。
(01:02:03):
其实是我把事情弄难了。有时我们把事情看得太重，以至于它成了你的“白鲸”（White Whale，指执念）。但如果你说：“我不需要追逐那个，我需要弄清楚反馈背后的含义，他们到底想表达什么？”然后长期针对性地改变自己。

---

### (01:02:26) Lenny Rachitsky

**English:**
I had similar challenges where I had this pretty real imposter syndrome for a while when I started doing well. And a coach was the key for me to help me get over that and see that if I made a mistake. Things wouldn't crumble. And that it's very normal to make mistakes. Nobody will-

**中文翻译:**
我有过类似的挑战。当我开始表现出色时，我有很严重的“冒名顶替综合征”（Imposter Syndrome）。教练是帮我克服这一点的关键，让我明白即使犯了错，天也不会塌下来，犯错是很正常的。没人会……

---

### (01:02:43) Deb Liu

**English:**
And by the way, I think perfectionism is a curse we place on ourselves. And it's a very dangerous thing, particularly for product leaders because product managers, you know things are going to go wrong. That's literally part of your job. And yet when we have perfectionism, it is a lack of trust in our ability to bounce back and our ability to actually adapt. But the more adaptable you are, the less you have to be perfect every single time.

**中文翻译:**
顺便说一下，我认为完美主义是我们强加给自己的诅咒。这非常危险，尤其是对产品领导者而言。因为作为 PM，你知道事情肯定会出错，这本身就是工作的一部分。当我们陷入完美主义时，其实是缺乏对自身反弹能力和适应能力的信任。你越能适应变化，就越不需要每次都追求完美。

---

### (01:03:09) Lenny Rachitsky

**English:**
Just to leave people with a tactical piece of advice, say they are like, "Oh man, I need a coach," do you have any advice for how to find a coach? How to explore that route?

**中文翻译:**
给听众一个实操建议：如果有人觉得“天哪，我需要一个教练”，你对如何寻找教练、如何开始有什么建议吗？

---

### (01:03:17) Deb Liu

**English:**
So I actually wrote an article, because one of the things I struggle with coaching is very expensive often, and not every company provides it. My husband actually works at a coaching company called Sounding Board to make it more accessible. But one of the things I encourage people to do is there are other ways to get coaches. I'm in a lean-in group and we are just like, we support each other. I'm in a coaching circle in YPO, so that's a group of CEOs. And I'm in a number of these coaching circles, which give you an opportunity to learn from each other and to get pure coaching. And I think that's a great place to start, especially early in your career when you're seeing the same people making the same mistakes.
(01:03:54):
I think as you get more senior, having an individual coach helps because the situations are so much more unique. But I do think that having that outlet, having a place to say, "Hey, is it me or is this situation not right? And how should I think through this?" That's so incredibly important.

**中文翻译:**
我写过一篇文章。辅导的一个难点是通常很贵，而且不是每家公司都提供。我丈夫在一家叫 Sounding Board 的辅导公司工作，致力于让辅导更普及。但我鼓励大家尝试其他方式。我参加了一个 Lean-in 小组，大家互相支持。我还参加了 YPO（青年总裁协会）的一个辅导圈子。这些圈子让你有机会互相学习，进行同伴辅导（Peer coaching）。我觉得这是一个很好的起点，尤其是职业生涯早期，你会发现大家都在犯同样的错误。
(01:03:54):
随着你职位的提升，一对一的教练会更有帮助，因为情况会变得更独特。但我认为拥有一个出口，一个可以问“嘿，是我的问题还是环境不对？我该怎么想？”的地方，是非常重要的。

---

### (01:04:10) Lenny Rachitsky

**English:**
I'm listening to this book, or reading a book called Listen right now that a previous guest recommended. It's a parenting book and it's about just the power of listening and how much that solves many problems with your challenges or with your child. When your child is having a problem just listening to them. There's a lot of power. This came from a coach that was on the podcast recently. [inaudible 01:04:31]

**中文翻译:**
我最近在听（或读）一本叫《倾听》（Listen）的书，是之前的一位嘉宾推荐的。这是一本育儿书，讲的是倾听的力量，以及它如何解决孩子面临的许多挑战。当孩子遇到问题时，仅仅是倾听就有巨大的力量。这是最近上过播客的一位教练推荐的。

---

### (01:04:30) Deb Liu

**English:**
Sounds great. I'll definitely, I'll read it or listen to it.

**中文翻译:**
听起来不错，我一定会去读读或听听。

---

### (01:04:34) Lenny Rachitsky

**English:**
I know it's weird. I'm like reading, it's called Listen. He's like, "This is the only parenting book you need really. It solves all the problems that we deal with." So anyway, that was an awesome final nugget that I'm glad we got there. With that though, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
我知道这挺怪的，我在读一本叫《倾听》的书。他说：“这是你唯一需要的育儿书，它能解决我们面临的所有问题。”总之，这是一个很棒的结尾锦囊。现在，我们进入激动人心的闪电轮问答。准备好了吗？

---

### (01:04:52) Deb Liu

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### (01:04:53) Lenny Rachitsky

**English:**
Let's do it. First question, what are two or three books that you've most recommended to other people?

**中文翻译:**
好。第一个问题：你向别人推荐最多的两三本书是什么？

---

### (01:04:59) Deb Liu

**English:**
So I love the book from Professor Jeffrey Pfeffer. I speak in his class now that I read it way before that, it's called Power: Who Has It and Why. I love the book. He actually has the more practical one, 7 Rules of Power, which came out more recently. And so it's a book that reminds us that power is not accidental, that people often get it for different reasons and how you should think about the playing field.
(01:05:23):
Another book is The Conversation, Dr. Livingston wrote that about race in America, and I just love that it's a very honest assessment of race in America. It's hard to have that conversation and I love that he uses a lot of facts and encourages people to open up and have conversations around it. And then the last one I would say is, well, Susan Cain's Quiet. I adore the book because I do have introverted kids. I myself am introverted and just to read the power of introverts as a reminder that we do have amazing people who don't communicate the same way.
(01:05:59):
I love that it's a tribute to the success of those. Even if our workplace is not adapted to it, I do think we need to adapt to it so that we can bring the best in everybody. But her book is a reminder that there's so much power even in silence.

**中文翻译:**
我非常喜欢 Jeffrey Pfeffer 教授的书，我现在常去他的课上演讲。那本书叫《权力：为什么有些人有，有些人没有》（Power: Who Has It and Why）。他最近还出了一本更实用的《权力的 7 条规则》。这本书提醒我们，权力并非偶然，人们获得权力的原因各异，你应该如何思考职场这个竞技场。
(01:05:23):
另一本是 Livingston 博士写的《对话》（The Conversation），关于美国的种族问题。我喜欢它对种族问题非常诚实的评估。这类对话很难进行，但他引用了大量事实，鼓励人们敞开心扉进行讨论。最后一本是苏珊·凯恩的《安静》。我非常爱这本书，因为我的孩子很内向，我自己也很内向。它提醒我们，那些沟通方式不同的人同样非常出色。
(01:05:59):
这本书是对内向者成功的致敬。即使职场环境尚未完全适应内向者，我们也需要去改变环境，发挥每个人的所长。她的书提醒我们，沉默中也蕴含着巨大的力量。

---

### (01:06:13) Lenny Rachitsky

**English:**
The first book you mentioned Jeffrey Pfeffer, he's been on the podcast. I think he may have mentioned you in our conversation or-

**中文翻译:**
你提到的 Jeffrey Pfeffer 教授也上过我们的播客。我想他在对话中可能提到过你，或者……

---

### (01:06:17) Deb Liu

**English:**
I love Professor Pfeffer.

**中文翻译:**
我非常敬重 Pfeffer 教授。

---

### (01:06:19) Lenny Rachitsky

**English:**
That was a fun conversation because I came into it very nervous for what his advice would be and then came up with it being like, "This is great. This is-"

**中文翻译:**
那次谈话很有趣，因为开始前我很紧张，不知道他会给出什么建议，但聊完后我觉得“太棒了”。

---

### (01:06:28) Deb Liu

**English:**
He is very wise,

**中文翻译:**
他非常有智慧。

---

### (01:06:29) Lenny Rachitsky

**English:**
He's very wise and just very, "I don't care what you think, I'm just going to tell you the reality of the world." Oh man. Okay. Next question. Do you have a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
他很睿智，而且非常直白：“我不在乎你怎么想，我只是告诉你世界的真相。”天哪。好，下一个问题：你最近有没有特别喜欢的电影或电视剧？

---

### (01:06:41) Deb Liu

**English:**
Okay. I know this is a fandom thing, but I love Fallout. So I played the game Fallout 4 last year, and then the show came out and it was amazing. And I know that video game movie annotations tend to be terrible, but it was so great and having played the game it was even better. Is that super nerdy?

**中文翻译:**
我知道这有点粉丝向，但我超爱《辐射》（Fallout）。我去年玩了《辐射 4》，后来剧集出来了，拍得太棒了。我知道游戏改编剧通常很烂，但这部真的很出色，玩过游戏后再看感觉更棒。这听起来是不是很宅？

---

### (01:07:06) Lenny Rachitsky

**English:**
No, I watched Fallout. I don't know anything about the game, but the show itself was really fun. Just I had no idea what I was even getting into. So no. Acceptable nerdy level. I don't know if you can get too nerdy on this show. Next question, do you have a favorite product you recently discovered that you just really like?

**中文翻译:**
不，我也看了《辐射》。我对游戏一窍不通，但剧集本身很有趣。我当时完全不知道自己在看什么。所以不，这属于可接受的“宅”度。在这个节目里，怎么宅都不过分。下一个问题：你最近有没有发现什么特别喜欢的产品？

---

### (01:07:26) Deb Liu

**English:**
Well, so actually what's really interesting is I never got into Twitter. I just couldn't figure it out. Recently I really got into Threads and I didn't think I would. I was like, "Well, just post some stuff on it," but really I just love... I could never figure out Twitter. You follow the wrong person and the whole thing, it's terrible. If somebody is posting too much or too little, but there's something about the Threads algorithm that's really worked. The first few months wasn't quite there, but I just feel like it's spot on and now I see the magic of it.

**中文翻译:**
有趣的是，我从未真正玩过 Twitter，我一直搞不懂它。但最近我迷上了 Threads，这出乎我的意料。我本来想“随便发点东西”，但我真的很喜欢。我以前玩不转 Twitter，关注错一个人整个 Feed 就毁了。但在 Threads 上，算法真的很有效。头几个月还没感觉，但现在我觉得它非常精准，我看到了它的魔力。

---

### (01:07:59) Lenny Rachitsky

**English:**
That's so interesting. I've seen some stats that it's bigger than X now slash Twitter and I wonder if that's true. I got to look that up, but I've seen more activity on Threads. So maybe I need to go back there. I spent some time around-

**中文翻译:**
很有趣。我看到一些数据说它现在的规模已经超过了 X（原 Twitter），不知道是不是真的。我得查查，但我在 Threads 上确实看到了更多活跃度。也许我该回去了。

---

### (01:08:10) Deb Liu

**English:**
Cheering from the sidelines that it's successful because I use it a lot now. And I guess I had never had a place for realtime news and it's not exactly meant to be newsy, but maybe it's just who I follow, but I love just seeing like, "Here's five headlines you probably missed." And I was like, "Oh." I know they're trying to downplay politics, but I just love that it feels like you get a glimpse of what's going on in the world in five minutes."

**中文翻译:**
我在场边为它的成功欢呼，因为我现在用得很多。我以前没有一个获取实时新闻的地方，虽然它不完全是新闻应用，但可能因为我关注的人，我喜欢看到类似“你可能错过的五个头条”这种内容。我知道他们在淡化政治，但我喜欢那种能在五分钟内洞察世界动态的感觉。

---

### (01:08:35) Lenny Rachitsky

**English:**
Okay. Two more questions. Do you have a favorite life motto that you often think about, come back to, share with friends or family find useful in work or in life?

**中文翻译:**
好，最后两个问题。你有没有什么人生格言是经常想起、并分享给亲友，且在工作生活中非常有用的？

---

### (01:08:42) Deb Liu

**English:**
Ooh, that's a good question. Well, actually, I would say that it's very similar to the Chuck Swindoll one about life. So we can use that.

**中文翻译:**
哦，好问题。其实，我想说的和刚才提到的 Chuck Swindoll 关于生活的那句很像。我们就用那个吧。

---

### (01:08:52) Lenny Rachitsky

**English:**
Great. That's what I imagined because you shared that one early on. And I imagine that was going to be your answer. Final question, you started Facebook Marketplace, you built it. Now, it has a billion users, more than that. What's the most interesting thing that you have bought or sold on Facebook Marketplace?

**中文翻译:**
太好了。我猜也是那个，因为你之前分享过。最后一个问题：你创建并建立了 Facebook Marketplace，现在它有超过 10 亿用户。你在上面买过或卖过最有趣的东西是什么？

---

### (01:09:07) Deb Liu

**English:**
The best thing I ever sold on there was I sold my minivan on it and in four days. I made my husband do it because I wanted him to test the product. We were selling our minivan and I'm like, "Just try Facebook Marketplace." He's like, "I don't know about this." And he's like, "There's too many people contacting me. I needed it to stop." So it worked really well for us. I think I have bought so many things on there. It's actually sort of embarrassing.
(01:09:30):
Recently, my daughter wanted the same desk as I had for her new room and they no longer sell it at Costco. And I found it for half the price from a woman who was moving and she's like, "Here," and I love it. So I bought probably way too many things on Facebook Marketplace actually. But it's a great thing. I actually use it as a great rental for kid stuff because you buy a kid's bike and then when they outgrow it, you sell it back.
(01:09:56):
And the rental fee is almost free and I don't have the store all of it. So I love every part of it. I still am an admin user and I send a lot of feedback back to that team still.

**中文翻译:**
我卖过最好的东西是我的面包车（Minivan），四天就卖掉了。我让我丈夫去卖，因为我想让他测试一下产品。我说：“试试 Marketplace 吧。”他一开始还犹豫，后来他说：“联系我的人太多了，快停下来！”所以效果非常好。我在上面买过太多东西了，说起来挺不好意思的。
(01:09:30):
最近，我女儿想要一张和我一模一样的书桌放进她的新房间，但 Costco 已经不卖了。我在上面找到了一个要搬家的女士，半价就买到了。我真的很喜欢它。我其实把它当作一种“儿童用品租赁服务”：买一辆童车，孩子长大了再卖掉。
(01:09:56):
这样“租金”几乎为零，我也不用囤一堆东西。我爱它的每一个部分。我现在依然是深度用户，并且经常给那个团队发反馈。

---

### (01:10:06) Lenny Rachitsky

**English:**
That's amazing. Deb, this was amazing. I'm so happy we made time for this. Thank you so much for coming on. Two final questions. Where can folks find you if they want to reach out, maybe read about stuff you're doing? Where's your Substack and anything else people can check out?

**中文翻译:**
太棒了。Deb，这次谈话太精彩了。很高兴我们能抽出时间聊聊。非常感谢你的到来。最后两个问题：如果大家想联系你或者阅读你的文章，可以在哪里找到你？你的 Substack 地址是什么？还有什么可以关注的？

---

### (01:10:18) Deb Liu

**English:**
Yeah, so debliu.substack if you want to look. I post probably about once a week. I'm on LinkedIn, I'm on Threads, so please do find me.

**中文翻译:**
好的，可以访问 debliu.substack.com。我大约每周发一篇。我也在 LinkedIn 和 Threads 上，欢迎关注。

---

### (01:10:27) Lenny Rachitsky

**English:**
And then the actual final question, how can listeners be useful to you?

**中文翻译:**
真正的最后一个问题：听众们能为你做些什么？

---

### (01:10:33) Deb Liu

**English:**
Well, I would just love to hear what you heard from today that resonated with you and what you're going to do with it.

**中文翻译:**
我非常想听听今天的对话中哪些内容引起了你的共鸣，以及你打算如何付诸行动。

---

### (01:10:37) Lenny Rachitsky

**English:**
And how would they share that LinkedIn or at Threads?

**中文翻译:**
他们应该在哪里分享？LinkedIn 还是 Threads？

---

### (01:10:41) Deb Liu

**English:**
I'm happy to read your comments or send it if you want to-

**中文翻译:**
我很乐意阅读你们的评论，或者你们可以直接发给我……

---

### (01:10:41) Lenny Rachitsky

**English:**
There we go.

**中文翻译:**
没问题。

---

### (01:10:43) Deb Liu

**English:**
... send it to me. If you've actually subscribed to my Substack, you can just reply to the first email and then I get it.

**中文翻译:**
……发给我。如果你订阅了我的 Substack，你可以直接回复邮件，我就能看到。

---

### (01:10:48) Lenny Rachitsky

**English:**
Awesome. But the easy way, as you said, are replying to YouTube comments. There we go. Get people to YouTube, click that subscribe button. Deb, thank you so much for being here and thank you.

**中文翻译:**
太棒了。当然最简单的方法是回复 YouTube 评论。大家快去 YouTube 点击订阅按钮。Deb，非常感谢你能来。

---

### (01:10:59) Deb Liu

**English:**
Thank you so much, Lenny. It's great.

**中文翻译:**
非常感谢，Lenny。很愉快。

---

### (01:11:00) Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。另外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。