# Dmitry Zlokazov - Lenny's Podcast

---

# Dmitry Zlokazov - Lenny's Podcast：揭秘 Revolut 的产品经理“梦工厂”

---

## 🎙️ 主持人介绍

**Lenny Rachitsky**
- **身份**: 前 Airbnb 产品负责人，全球顶尖产品管理专家。
- **背景**: 在 Airbnb 工作 7 年，见证了公司从初创到巨头的成长。
- **现状**: 运营全球排名第一的产品管理 Newsletter（Lenny's Newsletter）和播客，其内容被视为产品经理的“圣经”。
- **社交媒体**:
  - Twitter/X: [@lennysan](https://twitter.com/lennysan)
  - LinkedIn: [Lenny Rachitsky](https://www.linkedin.com/in/lennyrachitsky/)
  - Newsletter: [Lenny's Newsletter](https://www.lennysnewsletter.com/)

---

## 🎤 嘉宾介绍

**Dmitry Zlokazov**
- **身份**: Revolut 全球产品负责人 (Global Head of Product)。
- **职业经历**:
  - **Revolut**: 2021 年加入，从产品负责人晋升为全球产品负责人，管理零售业务及产品职能。
  - **McKinsey & Company**: 曾任副合伙人 (Associate Partner)，拥有深厚的战略咨询背景。
- **核心专长**: 极大规模下的产品架构设计、金融科技创新、高绩效产品团队建设。
- **社交媒体**:
  - LinkedIn: [Dmitry Zlokazov](https://www.linkedin.com/in/zlokazov/)

---

## 📝 内容概要

Revolut 被公认为全球培养顶级产品经理（PM）的三大“黄埔军校”之一（另外两家是 Palantir 和 Intercom）。在本期播客中，Dmitry 深入探讨了 Revolut 如何通过极度的**所有权（Ownership）**、**对原始智力的偏执**以及**创始人驱动的质量把控**，在 50 个国家打造出估值 450 亿美元的金融超级应用。这不仅是一次关于金融科技的分享，更是一本关于如何在高压、高成长环境下培养顶尖人才的实战手册。

---

## 🏷️ 核心话题

`产品所有权` `人才招聘` `金融科技` `极致UX` `组织架构` `执行力`

---

## 💡 核心论点

### 论点一：PM 即“局部 CEO”（Local CEO）

**核心观点**: 在 Revolut，产品经理被称为“产品所有者”（Product Owner, PO），他们对业务结果负有端到端的绝对责任。

- **组织架构**: PO 是跨职能团队（工程师、设计师、数据分析师）的直属经理（Line Manager），拥有行政管理权，而非仅仅是协调者。
- **三类 PO**: 划分为 UX PO（关注用户体验）、Tech PO（前工程师，关注底层架构）和 Data Science PO（前数据科学家，关注算法驱动的产品）。

> "If something is 99% done, it's closer to 0% rather than 100%." (如果一件事只完成了 99%，它更接近 0% 而非 100%。)
> — Dmitry Zlokazov

### 论点二：招聘偏好：原始智力 > 行业经验

**核心观点**: Revolut 倾向于招聘聪明、有饥饿感、有创业精神的年轻人，而非在成熟公司磨平了棱角的资深高管。

- **去经验化**: 资深人士往往带有思维定势，且缺乏“推倒重来”的动力。
- **理想画像**: 技术联合创始人（Tech Co-founder）或具有极强逻辑思维的咨询背景人才。
- **核心特质**: 极强的线性思维能力、对解决复杂问题的渴望、以及极高的执行效率。

### 论点三：永不妥协的“Wow”体验

**核心观点**: 在金融产品中，功能可以精简，但质量和美学绝不能打折。

- **创始人审核**: 尽管公司规模巨大，创始人 Nick 和 Vlad 仍会审核 100% 的上线屏幕。
- **消除不确定性**: 通过强制要求极致的 UX，排除掉“因为产品太烂导致没增长”的干扰项，从而更纯粹地验证商业假设。
- **深度钻研**: 领导层会挑选 7-10 个核心项目进行“剥洋葱式”的深度参与，甚至深入到代码层面。

---

## ✅ 数据验证结果

**验证项 1**: Revolut 的估值。
- 原文声称: Lenny 提到 600 亿美元，Dmitry 提到 450 亿美元。
- 验证结果: ✅ 确认。
- 来源: 2024 年 8 月，Revolut 完成了一次二级股票销售，估值为 **450 亿美元**。Lenny 提到的 600 亿可能是基于某些市场预期或内部估值。
- 可信度: ⭐⭐⭐

**验证项 2**: 用户规模。
- 原文声称: "Soon we'll be at 50 million customers."
- 验证结果: ✅ 确认。
- 来源: Revolut 在 2024 年 11 月正式宣布其全球用户数突破 **5000 万**。
- 可信度: ⭐⭐⭐

**验证项 3**: 员工人数。
- 原文声称: 约 6,000 到 7,000 人。
- 验证结果: ✅ 确认。
- 来源: 根据 LinkedIn 数据及公司官方招聘页面，其员工规模在 2024 年底确实处于这一区间。
- 可信度: ⭐⭐⭐

---

## 🎯 四维分类评估

### 🟢 高度正确（行业共识）

**观点 1**: 创始人对产品的深度参与是打造极致体验的关键（如 Apple, Airbnb, Revolut 均如此）。
- 验证依据: 乔布斯、布莱恩·切斯基等顶级创始人的共同特质。

**观点 2**: 招聘“饥饿感”强的年轻人能带来更高的 ROI。
- 验证依据: 早期 Stripe 和 Facebook 的人才策略。

### 🔵 当下可执行（明确步骤）

**建议 1**: 建立“局部 CEO”制度。
- 执行方法: 赋予产品经理对团队成员的绩效考核权和行政管理权，而不仅仅是项目管理权。

**建议 2**: 实施“深度钻研”审查。
- 执行方法: 管理层每周挑选 10% 的关键项目，不听 PPT 汇报，直接看设计稿和底层逻辑。

### 🟡 理智质疑（需验证）

**存疑点**: 创始人审核 100% 的屏幕在 7000 人规模下是否可持续？
- 质疑原因: 这可能导致决策瓶颈，或者审核流于形式。

### 🔴 需警惕（潜在风险）

**风险点**: 极度强调“原始智力”和“磨练（Grind）”的企业文化。
- 风险说明: 这种文化极易导致高离职率和员工倦怠（Burnout），虽然产出了顶尖人才，但组织稳定性面临挑战。

---

## 🔑 关键洞察

1. **所有权是最好的老师**: Revolut 成功的秘诀在于让 PM 承担真正的商业风险，这种“实战演习”让其校友在离开后极具竞争力。
2. **金融产品的“美学溢价”**: 在枯燥的银行领域，极致的流畅感和视觉设计本身就是一种强大的护城河。
3. **算法化流程**: 将复杂的业务（如在 50 个国家申请牌照）拆解为可复制的算法流程，是实现规模化增长的基础。
4. **99% = 0%**: 这种对交付质量的极端要求，迫使团队关注那些通常被忽略的“最后 1%”的细节。
5. **反经验主义**: 在快速变化的行业，学习能力和逻辑推演能力比过去的成功案例更重要。

---

## 🛠️ 提到的工具/资源

**工具 1**: **Manus**
- 说明: Dmitry 提到的 AI Agent 工具，他用它在几小时内完成了一个单词学习应用的开发。
- 链接: [Manus.ai](https://manus.ai/)

**推荐阅读**: **《The Hard Thing About Hard Things》** (硬核时刻)
- 说明: Dmitry 认为这是 PM 迈向 CEO 的必读书籍。
- 链接: [Amazon](https://www.amazon.com/Hard-Thing-About-Things-Building/dp/0062273205)

**推荐阅读**: **《Build》** (创造)
- 说明: Tony Fadell（iPod 之父）的作品，Dmitry 强烈推荐给所有“构建者”。
- 链接: [Amazon](https://www.amazon.com/Build-Unorthodox-Guide-Making-Things/dp/0063046068)

---

## 📋 行动建议

### 🚀 立即可做（今天）
- [ ] 检查你正在负责的项目：是否还有那“最后 1%”的细节没打磨？如果没完成，就当它还没开始。
- [ ] 尝试使用 Manus 或类似的 AI 工具进行一次“Vibe Coding”，体验 AI 驱动的开发效率。

### 📅 本周尝试
- [ ] 重新审视团队的招聘标准：我们是在招“有经验的人”，还是在招“聪明且饥饿的人”？
- [ ] 举行一次“深度钻研”会议：挑选一个项目，不看汇报，直接看最底层的逻辑和每一个交互屏幕。

### 🔍 深入探索
- [ ] 研究 Revolut 的“Joint Accounts”或“Wealth Protection”功能，分析其 UX 细节。

---

## ⭐ 评分

**知识价值**: 9.5/10
- 揭示了顶级独角兽公司最核心的人才和产品哲学。

**可执行性**: 8/10
- “局部 CEO”模式对组织架构有较高要求，但“99%=0%”的理念可立即应用。

**商业潜力**: 9/10
- 对于想要挑战传统行业的创业者具有极高的参考价值。

**投入产出比**: 10/10
- 1 小时的播客内容足以重塑一个产品团队的文化。

**综合评分**: **9.1/10**

---

## 📚 参考来源

- [Lenny's Podcast 官方网站](https://www.lennyspodcast.com/inside-revoluts-product-machine-dmitry-zlokazov-global-head-of-product/)
- [Revolut 官方新闻稿 (50M Users)](https://www.revolut.com/news/)
- [Dmitry Zlokazov LinkedIn 档案](https://www.linkedin.com/in/zlokazov/)

---
*来源*: Lenny's Podcast
*嘉宾*: Dmitry Zlokazov
*生成时间*: 2025-05-20