# Dmitry Zlokazov - 双语对照

# Lenny's Podcast: Dmitry Zlokazov (Global Head of Product at Revolut)
## Bilingual Transcript (English-Chinese) | 全程双语对照脚本

---

### [00:00:00] Dmitry Zlokazov

**English:**
Everyone is striving for talented, skillful, smart people. Revolut values way more raw intellect and this unquenched hunger to build things rather than experience.

**中文翻译:**
每个人都在争夺有才华、有技能、聪明的人。但相比于经验，Revolut 更看重原始的智力以及这种对创造事物的永不满足的渴望。

---

### [00:00:12] Lenny Rachitsky

**English:**
I hear one of the ways you approach early products differently is you guys invest a lot in actually making it good.

**中文翻译:**
我听说你们处理早期产品的一个不同之处在于，你们会投入大量精力真正把它做好。

---

### [00:00:18] Dmitry Zlokazov

**English:**
It's not getting traction. Is it because the underlying idea is wrong? Or maybe your product just sucks? By forcing everyone to build a product that people will love, we kind of cut out this part of uncertainty. We can cut down the product in terms of functionality to just most critical features, but we will never compromise on the quality and UX and the aesthetics.

**中文翻译:**
如果一个产品没有获得牵引力，是因为底层想法错了吗？还是说你的产品真的很烂？通过强制每个人都去打造一个人们会喜爱的产品，我们实际上排除了这种不确定性。我们可以在功能上精简到只剩最核心的部分，但我们绝不会在质量、用户体验（UX）和美学上妥协。

---

### [00:00:43] Lenny Rachitsky

**English:**
Is there anything that you've figured out about just how to set up new products for success?

**中文翻译:**
关于如何让新产品走向成功，你有什么心得吗？

---

### [00:00:48] Dmitry Zlokazov

**English:**
If something is 99% done, it's closer to 0% rather than 100%.

**中文翻译:**
如果一件事只完成了 99%，那么它更接近 0%，而不是 100%。

---

### [00:00:53] Lenny Rachitsky

**English:**
Today, my guest is Dmitry Zlokazov. Dmitry is global head of product at Revolut, which is a finance super app offering customer savings and checking accounts, crypto, investing, joint accounts, even mortgages. Not only was it last valued at over $60 billion, but in the research that I've been doing into which companies hire and incubate the best product managers, Revolut was right at the top alongside Palantir and Intercom. And so in our conversation, we dig into what Revolut has learned about producing and hiring great product leaders, including a focus on ownership, having people solve really painful and complex problems while making the experience wow and lovable by users. Also indexing towards hiring really smart and driven people early in their career versus people with a ton of experience in the space and so much more. If you're looking for a job that will accelerate your product career or want to help your product team level up, this episode is for you.

**中文翻译:**
今天的嘉宾是 Dmitry Zlokazov。Dmitry 是 Revolut 的全球产品负责人。Revolut 是一款金融超级应用，提供储蓄和支票账户、加密货币、投资、联名账户甚至抵押贷款。它最近的估值超过了 600 亿美元。在我对“哪些公司招聘和培养了最优秀的产品经理”的研究中，Revolut 与 Palantir 和 Intercom 一起名列前茅。在我们的对话中，我们将深入探讨 Revolut 在培养和招聘优秀产品领导者方面的经验，包括对所有权（Ownership）的关注，让员工解决极其痛苦和复杂的问题，同时打造让用户感到惊艳和喜爱的体验。此外，他们更倾向于招聘职业生涯早期、非常聪明且有驱动力的人，而不是在行业内拥有丰富经验的人。如果你正在寻找一份能加速产品职业生涯的工作，或者想帮助你的产品团队升级，这一集非常适合你。

---

### [00:01:48] Lenny Rachitsky

**English:**
If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become an annual subscriber of my newsletter, you get a year free of Linear, Superhuman, Notion, Perplexity, and Granola. Check it out at lennysnewsletter.com and click bundle. With that, I bring you Dmitry Zlokazov.

**中文翻译:**
如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你可以免费获得一年的 Linear、Superhuman、Notion、Perplexity 和 Granola。请访问 lennysnewsletter.com 并点击“bundle”查看。下面，让我们欢迎 Dmitry Zlokazov。

---

### [00:02:08] Lenny Rachitsky (Sponsor: Stripe)

**English:**
This entire episode is brought to you by Stripe. There's a reason that I've had more guests on this podcast from Stripe than any other company. It's because they hire the best people and they build incredible products. You probably know them for their payments platform, which powers my newsletter, and also companies like NVIDIA and Salesforce and Zoom and DoorDash. What you may not know is that they have several other products that can help accelerate your revenue, such as Stripe Billing, which powers billing for companies that you may have heard of. OpenAI, Anthropic, Figma, Atlassian, and over 300,000 other companies. Stripe Billing lets you bill and manage customers however you want from simple recurring billing to usage-based billing to sales-negotiated contracts.

**中文翻译:**
本集节目由 Stripe 赞助。我在这个播客中邀请的 Stripe 嘉宾比任何其他公司都多，这是有原因的：因为他们雇佣最优秀的人才并打造令人惊叹的产品。你可能知道他们的支付平台，它为我的时事通讯以及 NVIDIA、Salesforce、Zoom 和 DoorDash 等公司提供支持。你可能不知道的是，他们还有其他几款可以帮助加速收入增长的产品，比如 Stripe Billing，它为 OpenAI、Anthropic、Figma、Atlassian 等 30 多万家公司提供计费支持。Stripe Billing 让你能以任何想要的方式向客户收费和管理客户，从简单的定期计费到基于使用量的计费，再到销售协商的合同。

---

### [00:02:53] Lenny Rachitsky (Sponsor: Stripe Continued)

**English:**
There's also Stripe's Optimized Checkout suite, which is a plug-and-play super optimized payment flow that natively supports over 100 global dynamic payment methods. There's also a product called Link, which is an accelerated checkout experience built specifically to increase your checkout conversion. Every single one of the Forbes top 50 AI companies that have a product in the market today use Stripe to monetize it. Half of Fortune 100 companies use Stripe. $1.4 trillion flows through Stripe annually, which is equivalent to over 1% of global GDP. Use Stripe to handle all of your payment-related needs, billing, manage revenue operations, and launch or invent new business models. Learn more at stripe.com. Dmitry, thank you so much for being here and welcome to the podcast.

**中文翻译:**
还有 Stripe 的优化结账套件（Optimized Checkout suite），这是一个即插即用、高度优化的支付流程，原生支持 100 多种全球动态支付方式。还有一个名为 Link 的产品，它是专门为提高结账转化率而设计的加速结账体验。目前市场上《福布斯》排名前 50 的 AI 公司中，每一家都在使用 Stripe 进行变现。财富 100 强公司中有一半在使用 Stripe。每年有 1.4 万亿美元流经 Stripe，相当于全球 GDP 的 1% 以上。使用 Stripe 处理你所有的支付相关需求、计费、管理收入运营，以及启动或发明新的商业模式。更多信息请访问 stripe.com。Dmitry，非常感谢你能来，欢迎来到播客。

---

### [00:03:46] Dmitry Zlokazov

**English:**
Hi, Lenny. I'm happy to be here.

**中文翻译:**
嗨，Lenny。很高兴来到这里。

---

### [00:03:48] Lenny Rachitsky

**English:**
As you know, I've been doing a bunch of research into which companies hire and create the best product managers, and I've been triangulating this across a bunch of different data points. I've been looking at which companies alumni product managers get promoted most when they leave the company, become chief product officers at the highest rate when they leave the company, become the first PM at a startup, also start their own companies. And when I triangulate it across all these different data points, there's three companies that are kind of sat at the top, you guys, Revolut, Palantir, and Intercom.

**中文翻译:**
如你所知，我一直在研究哪些公司招聘和培养了最优秀的产品经理，并根据多个数据点进行了交叉验证。我观察了哪些公司的前产品经理在离职后晋升最快、成为首席产品官（CPO）的比例最高、成为初创公司的首位 PM，或者自己创业。当我综合这些数据点时，有三家公司脱颖而出：你们 Revolut、Palantir 和 Intercom。

---

### [00:04:21] Lenny Rachitsky

**English:**
Clearly you guys are doing something really special. I don't think a lot of people, especially in the US know a ton about Revolut, and so I'm really excited to have you here. I'm really excited to basically extract as much wisdom as I can from you about what you guys have figured out in helping in hiring and training product managers. So I want to actually start with giving people a slight understanding of what is Revolut. I think a lot of people in the US especially don't know much about it. So what's the simplest way to understand what you guys do?

**中文翻译:**
显然你们做了一些非常特别的事情。我想很多人，特别是在美国，对 Revolut 并不太了解，所以我很高兴你能来。我非常希望能从你这里汲取关于招聘和培训产品经理的智慧。所以我想先让大家简单了解一下 Revolut 是什么。我想很多美国人对它并不熟悉。那么，理解你们业务最简单的方式是什么？

---

### [00:04:49] Dmitry Zlokazov

**English:**
Revolut challenges banks in 50 different countries and it all started 10 years ago in London. So maybe let me give you a bit of a context, especially for someone based in the US, it's important to understand that European banking landscape is very diverse. In the US if you travel from state to state, things are different, but for example, you always pay in US dollars, right? In the UK you pay in British Pound. If you travel to mainland Europe, you will pay in Euro, but if you go to Switzerland, you'll pay in Swiss francs. If you go to Sweden, you'll pay in Swedish Krona and so on and so-and-so. Overall, there are 25 different currencies and every time you were traveling and paying in a different currency, banks were charging you exorbitant fees on top of terrible foreign exchange rates, and that's when Revolut launched as a multi-currency card and people loved it.

**中文翻译:**
Revolut 在 50 个不同的国家挑战传统银行，这一切都始于 10 年前的伦敦。让我给你提供一些背景信息，特别是对于美国的听众来说，理解欧洲银行业的格局非常多样化是很重要的。在美国，如果你跨州旅行，情况会有所不同，但你总是用美元支付，对吧？在英国，你用英镑支付。如果你去欧洲大陆，你用欧元支付；但如果你去瑞士，你要用瑞士法郎。如果你去瑞典，你要用瑞典克朗，以此类推。总共有 25 种不同的货币，每次你旅行并使用不同货币支付时，银行都会在糟糕的汇率基础上收取高昂的手续费。这就是 Revolut 作为多货币卡推出时的背景，人们非常喜欢它。

---

### [00:05:51] Dmitry Zlokazov

**English:**
They loved that Revolut was saving them 50 or 100 euros, but even more so they loved the transparency and simplicity of the product and that's why when we started rolling out more and more products based on those principles, they were quickly getting trust of people. They were quickly getting traction. So that's how P2P transfers appeared, and then frictionless crypto buying and withdrawal to a bank account appeared. And then more and more products created products, savings products and so on.

**中文翻译:**
人们喜欢 Revolut 能帮他们省下 50 或 100 欧元，但更重要的是，他们喜欢产品的透明度和简洁性。这就是为什么当我们开始基于这些原则推出越来越多产品时，它们很快就赢得了人们的信任并获得了牵引力。于是有了点对点（P2P）转账，接着是无缝的加密货币购买和提现到银行账户，然后是越来越多的信贷产品、储蓄产品等等。

---

### [00:06:27] Lenny Rachitsky

**English:**
Awesome. And then just to give people a few kind of scale of the company, how many employees are there roughly? I think the last valuation something around 60 billion. I don't know if you can even comment on that, but just what are some numbers real quick for people to understand the scale of the company at this point?

**中文翻译:**
太棒了。为了让大家对公司的规模有个概念，大概有多少员工？我想最近的估值大约是 600 亿美元。我不知道你是否方便评论，但能不能快速提供一些数字，让大家了解公司目前的规模？

---

### [00:06:40] Dmitry Zlokazov

**English:**
The headcount is not something we're trying to increase, to be honest. Actually Revolut tries to stay as lean as possible, but I think it's just that our appetite for growth is so big that I think we're currently at maybe 6 or 7,000 employees.

**中文翻译:**
老实说，增加员工人数并不是我们的目标。实际上，Revolut 试图保持尽可能精简的状态，但我想是因为我们对增长的胃口太大了，目前大约有 6000 到 7000 名员工。

---

### [00:06:58] Lenny Rachitsky

**English:**
Wow. Okay, cool. So let's get into what you've learned about building an amazing product team and also hiring an amazing product team. So first of all, you call your product managers product owners, and when we were chatting through initially it was like, "Oh, I see. It's just like a big scrum business," and they just have all these product owners who many times on this podcast people have talked about that's not actually a product manager, but that's not at all how you work. So in this context, product owner's an actual owner. Talk about just the story behind why you call your product managers, product owners.

**中文翻译:**
哇，好的。那我们来聊聊你在组建和招聘优秀产品团队方面的经验。首先，你们把产品经理称为“产品负责人”（Product Owners，简称 PO）。我们最初聊天时，我以为这只是那种大型的敏捷开发（Scrum）模式，有很多 PO，而在这个播客中，很多人曾提到 PO 并不等同于产品经理。但你们的情况完全不同。在你们这里，PO 是真正的“所有者”（Owner）。请讲讲为什么你们把产品经理称为产品负责人。

---

### [00:07:28] Dmitry Zlokazov

**English:**
Yeah, it's not a scrum term for us, it's just our take on emphasizing how ownership is important, really. So product owners are central to the company and its growth. They are end-to-end responsible for the product, for this part of the business, and for their customers to be happy. And for that, they do really everything. They run the teams, they define which roadmap we need to build to improve certain business metrics, and they also contribute to high-level company strategy, but then most importantly, they execute on it relentlessly and they are ultimate responsible for the product to be shipped and achieve results.

**中文翻译:**
是的，对我们来说，这并不是一个 Scrum 术语，而是我们强调“所有权”（Ownership）重要性的一种方式。产品负责人是公司及其增长的核心。他们对产品、这部分业务以及客户的满意度负有端到端的责任。为此，他们真的什么都做。他们管理团队，定义需要构建什么样的路线图来提升特定的业务指标，他们还参与公司高层战略的制定。但最重要的是，他们不懈地执行，并对产品的发布和结果负最终责任。

---

### [00:08:24] Lenny Rachitsky

**English:**
There's always this term of mini-CEO, PM as a mini-CEO, and it feels like in your context, that's actually what you try to do with your product team is they're essentially mini-CEOs. They have a lot of power. I think engineers, designers report to them. Is that right?

**中文翻译:**
人们常说 PM 是“迷你 CEO”，在你们的环境下，感觉你们确实是这样做的——他们本质上就是迷你 CEO。他们拥有很大的权力，工程师和设计师都向他们汇报，对吗？

---

### [00:08:35] Dmitry Zlokazov

**English:**
Yeah, correct. Well, I prefer to say local CEO.

**中文翻译:**
是的，没错。不过我更喜欢称之为“局部 CEO”（Local CEO）。

---

### [00:08:38] Lenny Rachitsky

**English:**
Local CEO. Okay, let's talk about that. Yeah, yeah.

**中文翻译:**
局部 CEO。好的，我们聊聊这个。

---

### [00:08:42] Dmitry Zlokazov

**English:**
Yeah, but that's true. So the way we operate, we have these fully cross-functional teams, meaning they're staffed with all necessary functions, engineers data, analysts, designers, operational managers and so on. And we also operate in metrics. So everyone has a line manager and a functional manager. So product owner is always the line manager for everyone on the team, meaning product owner defines what they need to do, but then functional managers, they define how these things are need to be built and essentially with the right level of quality and so on.

**中文翻译:**
是的，确实如此。我们的运作方式是拥有完全跨职能的团队，这意味着团队配备了所有必要的职能人员：工程师、数据分析师、设计师、运营经理等等。我们还采用矩阵式管理。每个人都有一个直线经理（Line Manager）和一个职能经理（Functional Manager）。产品负责人始终是团队中每个人的直线经理，这意味着 PO 定义了他们需要做什么；而职能经理则定义了这些东西应该如何构建，本质上是确保质量水平等等。

---

### [00:09:28] Lenny Rachitsky

**English:**
I love this because it's so fun just to learn about such different ways of operating. Another fact that I saw is that there's two types of product owners. There's kind of like a UX product owner, and then there's a different like technical product owner.

**中文翻译:**
我喜欢这个模式，了解这种完全不同的运作方式很有趣。我还看到一个事实，就是你们有两种类型的产品负责人：一种是 UX（用户体验）型 PO，另一种是技术型 PO。

---

### [00:09:41] Dmitry Zlokazov

**English:**
We actually have three.

**中文翻译:**
实际上我们有三种。

---

### [00:09:42] Lenny Rachitsky

**English:**
Three.

**中文翻译:**
三种。

---

### [00:09:43] Dmitry Zlokazov

**English:**
And the third type becomes increasingly more important. So the first type is UX product owners. Then there are technical product owners, and then there are data science product owners. So UX product owners are the ones who work on consumer facing part of the product. Usually they have a great taste for things and they understand what constitutes UX that will work and which things will not work. So they also have this expertise in the industry. Then tech product owners, they are the ones who delve deepest into details. Usually those are former engineers who grew into making decisions and driving business. And the data science product owners are usually former data scientists who decided to grow into management positions, but they're still very hands-on.

**中文翻译:**
第三种类型正变得越来越重要。第一种是 UX 产品负责人，第二种是技术产品负责人，第三种是数据科学产品负责人。UX PO 负责面向消费者的产品部分。通常他们有很好的品味，理解什么样的 UX 是有效的。他们也拥有行业专业知识。技术 PO 是那些钻研细节最深的人，通常是转型为决策者和业务驱动者的前工程师。数据科学 PO 通常是决定转向管理岗位的前数据科学家，但他们仍然非常注重实操。

---

### [00:10:55] Dmitry Zlokazov

**English:**
And you know what? There are way more things that are common to each of these three specializations. So what we see sometimes is people just shifting them because I would say that what defines the specialization is probably 5, 10, 15% while 85 to 90% is common to each one of them. And those things are, so first of all, being a great problem solver and have a great linear thinking, but also have a creative approach towards nonlinear problems. Then building this context for customer and building empathy towards customer and translating it into the team.

**中文翻译:**
而且你知道吗？这三种专业方向之间有很多共同点。我们有时会看到人们在这些角色之间转换，因为我认为定义专业方向的差异可能只占 5%、10% 或 15%，而 85% 到 90% 的能力是通用的。这些通用能力包括：首先，是一个优秀的决策者，拥有出色的线性思维，同时在面对非线性问题时能有创造性的方法。其次，是为客户构建背景信息，建立对客户的同理心，并将其传达给团队。

---

### [00:11:48] Dmitry Zlokazov

**English:**
Then going down to details very, very deep because in our domain there are no obvious things and you need to get to the root cause of the problem really, really deep to understand what will work and what will not work. And that means that you also need to be quite technical, even if you are an expert, you still need to often go as deep as sitting with engineers and reading code. And then I would also emphasize the importance of business acumen because we tend to measure and quantify product performance a lot. And you need to understand, okay, what things will we build that will drive eventually that business metric and that target?

**中文翻译:**
然后是深入到非常、非常细微的细节，因为在我们的领域没有显而易见的事情，你需要极其深入地挖掘问题的根本原因，才能理解什么行得通，什么行不通。这意味着你还需要具备相当的技术能力，即使你是个专家，你仍然需要经常深入到与工程师坐在一起看代码的程度。最后，我还想强调商业敏锐度的重要性，因为我们非常倾向于衡量和量化产品表现。你需要理解：我们要构建什么东西，才能最终驱动那个业务指标和目标？

---

### [00:12:41] Lenny Rachitsky

**English:**
So I love this idea of the product owners having to go really deep. I think a lot of people hearing this, they think they can go deep, go deep, really understand the details of what they're working on. I'm curious if there's an example that's illustrative of just what you actually mean here.

**中文翻译:**
我非常喜欢 PO 必须深入细节这个想法。我想很多听众听到这里会觉得自己也能深入细节，真正理解工作的每一个环节。我很好奇，有没有一个例子能说明你所说的“深入”到底意味着什么？

---

### [00:12:55] Dmitry Zlokazov

**English:**
For example, to provide the best possible product in every country of presence, we need to have necessary licenses. In Europe, it means that we need to launch local branches of our European bank, for example, a branch for France, a branch for Germany, or a branch for Italy. To launch a branch, you need to fully comply with all necessary regulation. You need to report necessary data on customers to various regulators and authorities. You need to register with local payment systems. And each of these things, they have a lot of projects nested within. We have a very lean team of just a few people who need to scope everything and do it at the scale of 50 countries. So the way we do it is we go very deep on example of each of these projects. For example, we launched a branch in Ireland, we launched a branch in Netherlands.

**中文翻译:**
例如，为了在每个业务覆盖的国家提供最好的产品，我们需要获得必要的牌照。在欧洲，这意味着我们需要开设欧洲银行的当地分行，比如法国分行、德国分行或意大利分行。要开设分行，你必须完全遵守所有必要的法规。你需要向各种监管机构和当局报告必要的客户数据。你需要注册当地的支付系统。而每一项工作下面都嵌套着大量的子项目。我们有一个非常精简的团队，只有几个人，他们需要规划所有事情，并在 50 个国家的规模上执行。我们的做法是深入研究每一个项目的实例。例如，我们在爱尔兰开设了分行，在荷兰开设了分行。

---

### [00:14:01] Dmitry Zlokazov

**English:**
Then we reverse engineered what was the best process to do it, and then we went back up on top level and we said, okay, but what's the ideal framework of doing it at scale? And then we formalized it into a process really like an algorithmic process with steps and quality gates and assay needs, what people do we need to hire and how soon do we need to start doing that before we want to launch a new country. Then, so it's not only going deep, but also being flexible and doing this switch between zooming in very deep and then raising on the level of helicopter view and then understanding, okay, so this seems very, very complex in details, but then when you zoom out, how can we simplify it and build a robust process around it, which is scalable? And that's something that we have to do a lot.

**中文翻译:**
然后我们逆向推导出执行该任务的最佳流程，接着回到顶层思考：在大规模推广时，理想的框架是什么？然后我们将其正式化为一个流程，就像一个带有步骤、质量关卡和评估需求的算法流程——我们需要雇佣什么样的人，在进入一个新国家之前多久需要开始准备。所以，这不仅是深入细节，还要保持灵活性，在“深度聚焦”和“直升机视角”之间切换。理解到：细节上这看起来非常复杂，但当你放大视角时，我们如何简化它并围绕它建立一个可扩展的稳健流程？这是我们必须经常做的事情。

---

### [00:15:05] Lenny Rachitsky

**English:**
As you're talking and we go through this chat, I'm keeping kind of track of what I think is most contributing to your alumni product owners, product managers becoming so successful. So a couple of things so far that I think are probably contributing to this is one is just having a lot of ownership over what they're building, which leads to building skills to start companies and become leaders at other companies. So these product owners that you have are just own a lot and are essentially GMs of whatever product they're working on. And then there's this depth and complexity where you have to really get good at understanding a problem really deeply. I imagine many of these people go on to work on something like that later, somewhere else because they've spent all this time, or they just get really good at dealing with complex many layered problems. So is there anything else just kind of along those lines as I say that you think is important?

**中文翻译:**
听你聊到现在，我一直在总结为什么你们的前产品负责人和产品经理离职后会如此成功。到目前为止，我认为有几点原因：一是拥有极大的所有权，这让他们培养了创业和在其他公司担任领导者的技能。你们的 PO 拥有很大的自主权，本质上是他们所负责产品的总经理（GM）。二是深度和复杂性，你必须非常擅长深入理解问题。我猜这些人以后去别的地方工作时，因为已经习惯了处理复杂的多层级问题，所以表现非常出色。除了这些，你觉得还有什么重要的因素吗？

---

### [00:15:54] Dmitry Zlokazov

**English:**
I would probably add an obsession with building wow product.

**中文翻译:**
我可能会加上一条：对打造“Wow”产品（令人惊叹的产品）的痴迷。

---

### [00:16:03] Lenny Rachitsky

**English:**
Wow. W-O-W?

**中文翻译:**
Wow。W-O-W？

---

### [00:16:04] Dmitry Zlokazov

**English:**
W-O-W.

**中文翻译:**
W-O-W。

---

### [00:16:06] Lenny Rachitsky

**English:**
Cool.

**中文翻译:**
酷。

---

### [00:16:08] Dmitry Zlokazov

**English:**
I think in FinTech overall, this is probably the most neglected part usually, but it's also a part that we at Revolut, we pay enormous attention to. So it's not only when you do a trade in the app or when you send money, it's very important for it to be very fast and cheap process for you so that you don't pay a lot of fees. But we also pay a lot of attention to look and feel of the app and how smooth it is and how frictionless the process. Not only we invest in reducing clicks and optimizing finals, but we also want people to feel that we really cared about them. We also want people to feel that we love our customers and we applied extra effort for the product to look great and feel great. And I hear this a lot from our customers, like the app is something they really love and it helps them solve their problems. It's at least one of the ingredients of the company's success.

**中文翻译:**
我认为在整个金融科技（FinTech）领域，这通常是最被忽视的部分，但在 Revolut，我们对此投入了巨大的关注。不仅是在应用中进行交易或汇款时，速度快、费用低很重要，我们也极其关注应用的观感、流畅度以及流程的无缝衔接。我们不仅投资于减少点击次数和优化漏斗，还希望用户感受到我们真的在乎他们。我们希望用户感受到我们热爱客户，并为了让产品看起来和用起来都很棒而付出了额外的努力。我经常从客户那里听到，他们真的很喜欢这个应用，它帮他们解决了问题。这是公司成功的要素之一。

---

### [00:17:22] Dmitry Zlokazov

**English:**
And I think people that work at Revolut, they built habit of paying attention to these small nuances, small details that make the product lovable. And then second is handling this context because it's a lot of details where you need to dive, but there are also a lot of dimensions where you need to dive into different details. And I think this ability to keep this large context in your mind and consider second order effects and view subjects from multiple angles, I think that this is also a very important skill that people usually train at Revolut.

**中文翻译:**
我认为在 Revolut 工作的人养成了一种习惯，即关注那些让产品变得可爱的细微差别和细节。其次是处理这种背景信息的能力，因为你需要深入很多细节，而且有很多维度需要你去钻研。我认为这种在脑海中保持宏大背景、考虑二阶效应并从多个角度观察事物的能力，也是人们在 Revolut 经常锻炼的一项非常重要的技能。

---

### [00:18:05] Lenny Rachitsky

**English:**
Okay, cool. So we have three bullet points on the ingredients of great product managers slash owners that you guys incubate. On this wow piece, which I love. How do you operationalize this sort of thing? I imagine a big part of it is hiring people that are really good at this and value building lovable products. Is there any way you kind of have a process around making sure the things you ship are wow and lovable?

**中文翻译:**
好的，太酷了。我们总结了你们培养优秀产品经理/负责人的三个要素。关于这个“Wow”的部分，我非常喜欢。你们是如何将其流程化的？我猜很大一部分在于招聘那些擅长此道并重视打造可爱产品的人。你们有没有什么流程来确保发布的东西是令人惊叹且受人喜爱的？

---

### [00:18:27] Dmitry Zlokazov

**English:**
Two things that you need to understand about how Revolut operates is that we operate in small lean teams that are tasked to build products and as I mentioned, and having end-to-end responsibility for products. And usually they're the ones who build it from zero and then they're growing and developing this product. And then another thing is that company is very flat and hierarchy is very flat. We still have our founders, Nick and Vlad, very hands-on going down to details for every product and every part of the business. And every week they have product reviews with every team giving an opportunity to every product owner present directly to CEO and CTO and show what increment has team achieved in the last week, but also get steering from founders, which is super valuable.

**中文翻译:**
关于 Revolut 的运作方式，你需要理解两点：一是我们以精简的小团队运作，负责构建产品并承担端到端的责任。通常他们是从零开始构建，然后不断发展和完善产品。二是我们公司非常扁平，层级极少。我们的创始人 Nick 和 Vlad 仍然非常亲力亲为，深入了解每个产品和业务的每个细节。每周他们都会与每个团队进行产品评审，让每个 PO 有机会直接向 CEO 和 CTO 演示团队上周取得的进展，并获得创始人的指导，这非常有价值。

---

### [00:19:31] Dmitry Zlokazov

**English:**
Essentially founders of the company, they still review a hundred percent of screens that are being shipped and everything that you will see in the app pass this review. And there are a lot of eyeballs that were scrutinizing this and thinking of all possible edge cases and nuances that we need to consider to make sure that every single customer will be happy in this product, in this flow.

**中文翻译:**
本质上，公司的创始人仍然会审查 100% 即将发布的屏幕界面，你在应用中看到的每一处都通过了这种审查。有很多双眼睛在仔细检查，思考所有可能的边缘情况和细节，以确保每个客户在这个产品、这个流程中都能感到满意。

---

### [00:20:02] Lenny Rachitsky

**English:**
That seems to be a consistent theme in products that are incredible is the founders are deeply involved in the experience and review everything. How many product owners are there at Revolut? Just to give people a sense by the way?

**中文翻译:**
这似乎是那些卓越产品的一个共同主题：创始人深度参与体验并审查一切。顺便问一下，Revolut 大约有多少名产品负责人？让大家有个概念。

---

### [00:20:15] Dmitry Zlokazov

**English:**
Oh, I'm afraid to say it's already more than 150 people, maybe 170.

**中文翻译:**
噢，我恐怕已经超过 150 人了，大概 170 人左右。

---

### [00:20:20] Lenny Rachitsky

**English:**
Cool. That's what I would expect. And then you said that there's kind of these three types, there's kind of like the eng type, the PM, traditional type, and there's the data product owner. When you hire the UX type of product owner today, is their previous role usually a product manager at another company?

**中文翻译:**
酷，这和我预想的差不多。你提到有三种类型：工程型、传统 PM 型和数据产品负责人。当你现在招聘 UX 型 PO 时，他们之前的职位通常是其他公司的产品经理吗？

---

### [00:20:36] Dmitry Zlokazov

**English:**
Yes, but I would say that not necessarily it's a very experienced product manager. Well maybe even it's way more important to have this hunger for building things and having the raw intellect. And we always try to find people with these intrinsic traits rather than hiring people who are very experienced but maybe are not super excited about building things.

**中文翻译:**
是的，但我想说不一定是非常资深的产品经理。甚至，拥有创造事物的渴望和原始智力要重要得多。我们总是试图寻找具有这些内在特质的人，而不是雇佣那些经验丰富但可能对创造事物不再感到兴奋的人。

---

### [00:21:13] Lenny Rachitsky

**English:**
What percentage of your product owners come from internal transfers from other functions?

**中文翻译:**
你们的产品负责人中有百分之几是从其他职能部门内部转岗过来的？

---

### [00:21:18] Dmitry Zlokazov

**English:**
It's a quite substantial part of product owners who eventually become very successful by the way. So it's like a positive self-select, so it means that someone already succeeded in another role. So it's a guaranteed culture match, it's a guaranteed domain knowledge, and then they simply grow. Usually it could be operations managers or engineers. They grow into someone who now manages the team and that's why it's a very successful path.

**中文翻译:**
很大一部分 PO 是通过内部转岗产生的，而且顺便说一下，他们最终都非常成功。这就像一种积极的自我筛选，意味着他们已经在另一个岗位上证明了自己。这保证了文化契合度和领域知识，然后他们只需成长即可。通常他们可能是运营经理或工程师，成长为管理团队的人，这就是为什么这是一条非常成功的路径。

---

### [00:21:53] Lenny Rachitsky

**English:**
So the other company on the list of top three companies that produce and hire the best PMs, according to the research I've done, Palantir. I just had someone that was at Palantir for a long time and we talked about exactly all the same questions. And interestingly so far we have kind of these three bullet points in terms of what product owners within Revolut get to do. There's a lot of ownership, there's a lot of depth and complexity, and there's a lot of focus on wow lovable products. So interestingly at Palantir also tons of ownership, also tons of depth and complexity. The other ingredient that I want to ask you about is they also have this concept of a forward deployed engineer where they put an engineer in the office of the company they're building the product from, they sit there building it for them with them.

**中文翻译:**
根据我的研究，培养和招聘最优秀 PM 的前三名公司中的另一家是 Palantir。我刚采访过一位在 Palantir 工作了很久的人，我们讨论了完全相同的问题。有趣的是，到目前为止，Revolut 的 PO 也有这三个特点：极大的所有权、极高的深度和复杂性，以及对“Wow”产品的关注。Palantir 同样强调所有权和深度。我想问你的另一个要素是，他们有“前线部署工程师”（Forward Deployed Engineer）的概念，即把工程师派驻到客户公司的办公室，在那里和客户一起构建产品。

---

### [00:22:36] Lenny Rachitsky

**English:**
And so there's a lot of skills built in terms of understanding customer problems, talking to customers, getting empathy building, things like that. Is there anything you guys do or focus on around just like talking to customers, the way you approach having your product owners work with customers, understand problems, things like that that might be helpful for people to hear?

**中文翻译:**
因此，他们在理解客户问题、与客户交流、建立同理心等方面培养了很多技能。你们在与客户交流、让 PO 接触客户、理解问题等方面有什么做法或重点吗？

---

### [00:22:56] Dmitry Zlokazov

**English:**
For us, it's a bit easy to reach out to customers simply because the customer base is so big, it's more than 50 million people and usually we ourselves are power users of the product. We receive our salary into Revolut and then we spend with Revolut, our friends the same. So it's like a no-brainer to talk to people continuously and even if you are not proactive in it, they will reach out. If you have a problem in the product, I guarantee that we know about it very, very soon. We've also built tools for product owners and designers to have an easy access to a panel of users via different tools so that they can just start an interviewing process or a survey or a test of different designs in a few clicks.

**中文翻译:**
对我们来说，接触客户相对容易，因为我们的客户群非常庞大，超过 5000 万人。而且通常我们自己就是产品的重度用户。我们的工资发到 Revolut 账户，然后用 Revolut 消费，我们的朋友也是如此。所以持续与人交流是很自然的事，即使你不主动，他们也会找上门。如果产品有问题，我保证我们很快就会知道。我们还为 PO 和设计师构建了工具，让他们可以通过各种工具轻松访问用户面板，只需点击几下即可开始访谈、调查或测试不同的设计。

---

### [00:23:52] Dmitry Zlokazov

**English:**
For me, it was very important to build this direct connection to customers because when you delegate such an important thing as customer research and collecting their feedback to someone, you will get a refined filtered version. You won't get these nuances of how people describe things, which emotions they feel like and so on, and where they think stuck. It's very easy to lose all those important bytes of information in this process. So I'm a strong believer that it's very important to have direct communication channel to customers.

**中文翻译:**
对我来说，建立与客户的直接联系非常重要。因为当你把客户研究和收集反馈这么重要的事情委托给别人时，你得到的是经过提炼和过滤的版本。你无法体会到人们描述事物时的细微差别、他们的情感，以及他们在哪里感到困惑。在这个过程中，很容易丢失所有这些重要的信息比特。所以我坚信，拥有与客户直接沟通的渠道至关重要。

---

### [00:24:32] Lenny Rachitsky

**English:**
As you describe this, it's funny how you guys are at the extreme opposite end of the spectrum from Palantir in terms of how easy it is for you to get feedback. They build stuff for the government and for Airbus where employees would never use a product like that or need a product like that. You guys are getting paid in Revolut using Revolut to pay for things and constantly in the product. And so I could see why there's less of a need for something like a forward deploy engineer. Okay, amazing. Let's talk about hiring then. Is there anything unique about how you approach hiring, sourcing, looking for people, what you look for in people that you think might be contributing to your alumni being so successful down the road?

**中文翻译:**
听你这么描述，很有趣的是，在获取反馈的难易程度上，你们和 Palantir 处于光谱的两端。他们为政府和空客（Airbus）构建产品，员工永远不会用到那种产品。而你们用 Revolut 领工资、消费，时刻都在使用产品。所以我能理解为什么你们不太需要“前线部署工程师”。太棒了。那我们聊聊招聘吧。在招聘、寻源、筛选人才方面，你们有什么独特之处吗？你认为哪些特质促成了你们的前员工在未来如此成功？

---

### [00:25:12] Dmitry Zlokazov

**English:**
I think everyone is striving for talented, skillful smart people and experienced people. Revolut values way more raw intellect and this unquenched hunger to build things rather than experience. So let me maybe bring an example. Imagine we saw this, you hire a great experienced professional with amazing regalia of achieving a lot of things, but then what I see in product, the adoption curve is usually longer than in other functions because product owners by definition are the ones who are the experts in that domain and in all those intricacies of how product is built and how it's used. So what we see from these professionals is they still take a lot of time to ramp up and sometimes they also take time to adapt to new culture or worse, they just rest on their laurels. But you already have super inflated expectations and usually their compensation is by the way, quite high and which adds up to these expectations. And I myself, after conducting maybe 400 or 500 interviews with product owners at Revolut, I also see this.

**中文翻译:**
我认为每个人都在追求有才华、有技能、聪明且经验丰富的人。但 Revolut 远比经验更看重原始智力和对创造事物的永不满足的渴望。举个例子：想象一下，你雇佣了一位经验丰富的专业人士，他拥有辉煌的成就背景。但在产品领域，我发现他们的适应曲线通常比其他职能部门更长。因为 PO 本质上必须是该领域以及产品构建和使用细节方面的专家。我们看到这些专业人士仍然需要很长时间才能上手，有时还需要时间适应新文化，更糟的是，他们可能会躺在功劳簿上。但你已经对他们有了极高的期望，而且通常他们的薪酬也很高，这进一步推高了期望。在 Revolut 进行了大约 400 到 500 场 PO 面试后，我也发现了这一点。

---

### [00:26:46] Dmitry Zlokazov

**English:**
Unfortunately, professionals with a lot of years of experience from established companies, they don't have this strong urge to change status quo, which by the way will require toil, tears, and sweat. And that's why even if a candidate doesn't have a lot of years of experience, but they love building things, they've done it, they worked with engineers maybe by the way, maybe in their own startup or one of the best profiles that I've seen is a tech co-founder. So I think that's probably the best way to boost career is to go and found something work in a startup, build things yourself or with a very small team, work in all different areas because in startup you have to work in all different areas. And then these kind of people, they really thrive at Revolut and even if they don't have a lot of years of experience, they actually attack a specific problem.

**中文翻译:**
不幸的是，来自成熟公司的资深专业人士往往没有那种改变现状的强烈冲动，而改变现状是需要辛劳、泪水和汗水的。这就是为什么即使候选人没有很多年的经验，但如果他们热爱创造事物，曾经亲手做过，比如和工程师一起工作过——顺便说一下，最好的背景之一就是技术联合创始人。我认为提升职业生涯最好的方式就是去创业，在初创公司工作，自己或带一个小团队构建东西，涉足所有领域，因为在初创公司你必须全能。这类人在 Revolut 非常吃香，即使他们经验不多，但他们能直击特定问题。

---

### [00:28:09] Dmitry Zlokazov

**English:**
They have a sense of what can cause customer pain, and they are very fast moving to solve it quickly and then that's how they get appreciation from everyone around. The team starts respecting these people because they solve some specific problem and then they take another problem, they solve it and then they take another and that's how they grow in the company.

**中文翻译:**
他们能感知到什么会导致客户痛苦，并且行动迅速，能很快解决问题，从而赢得周围人的赞赏。团队开始尊重这些人，因为他们解决了一个具体问题，接着又解决另一个，再接一个，这就是他们在公司成长的方式。

---

### [00:28:33] Lenny Rachitsky

**English:**
Essentially what I'm hearing is you hire kind of more junior or super high raw, intellect driven, passionate, how do you describe, hungry people? And this explains why so many people get promoted so much more that leave Revolut because they start their earlier in their career and you help them learn all these skills, ownership, depth, understanding, working in complex environments, building amazing products. So this all makes a lot of sense. Is there anything you figured out about where to find these people? Because this is the dream, hire amazingly smart people that are super driven that nobody knows about yet and then make them awesome. Have you found anything about where to source and find these folks?

**中文翻译:**
本质上我听到的是，你们雇佣的是相对资浅但原始智力极高、有驱动力、有激情、或者说“饥渴”的人？这解释了为什么这么多人在离开 Revolut 后能获得更大幅度的晋升，因为他们在职业生涯早期加入，而你们帮助他们学习了所有权、深度、理解力、在复杂环境下工作以及打造卓越产品等技能。这非常有道理。关于在哪里找到这些人，你有什么心得吗？因为这是每个人的梦想：雇佣那些极其聪明、驱动力强但还没出名的人，然后把他们变得很牛。你在寻源方面有什么发现吗？

---

### [00:29:14] Dmitry Zlokazov

**English:**
So the way we work, we have a weekly catch-ups with the recruitment team. So essentially they are also a team that runs in sprints. So every sprint we define what do we want to focus on, which areas, which companies. One of the great sources is actually looking into products and apps that we love ourselves. So if someone built a great product, then it's likely a high performer. So usually we provide some great products in specific areas that are more important for us to the sourcing team and they just try to source targeting those companies. It could be also different areas. It could be even schools, like good schools. And so it varies from sprint to sprint.

**中文翻译:**
我们的工作方式是每周与招聘团队沟通。本质上，招聘团队也是按冲刺（Sprint）运行的。每个冲刺阶段，我们会定义想要关注的重点、领域和公司。一个很好的来源是观察我们自己喜爱的产品和应用。如果有人打造了一个伟大的产品，那么他很可能是一个高效能人才。所以我们通常会向寻源团队提供一些对我们很重要的特定领域的优秀产品，他们就会针对这些公司进行挖掘。也可能是不同的领域，甚至是优秀的学校。这随每个冲刺阶段而变化。

---

### [00:30:06] Lenny Rachitsky

**English:**
That makes sense. Gokul had this really good piece of advice, I think it was on the podcast, if not he tweeted about it, where you look at there's successful companies, but then there's also what function in that company is the key to their success. And so you want to go like a company A for sales, company B for customer support, company C for design. And so it sounds like that's kind of the way you guys think about it a little bit. Yeah, very cool. Okay. I love how we're uncovering and we're uncovering this mystery.

**中文翻译:**
有道理。Gokul 曾给过一个很好的建议（我想是在播客里，或者他在推特上发过）：你看那些成功的公司，还要看哪种职能是该公司成功的关键。比如去 A 公司挖销售，去 B 公司挖客户支持，去 C 公司挖设计。听起来你们的想法有点类似。非常酷，我喜欢我们揭开这个谜团的过程。

---

### [00:30:33] Lenny Rachitsky (Sponsor: Stripe)

**English:**
This entire episode is brought to you by Stripe. Every single one of the Forbes top 50 AI companies that has a product in the market today uses Stripe to monetize it. $1.4 trillion flows through Stripe annually, which is equivalent to over 1% of the entire global GDP. And Stripe isn't just a payments platform. They also have a product called Stripe Billing, which powers billing for companies that you may have heard of, OpenAI, Anthropic, Figma, Atlassian, and over 300,000 other companies. Stripe Billing lets you bill and manage customers no matter your pricing model from simple recurring billing to usage-based billing to sales negotiated contracts. Collect and retain more revenue, automate revenue management workflows, and accept payments globally. Use Stripe to handle all of your payment related needs, including billing, revenue operations, checkout flows, or simply launching or inventing new business models. Learn all the ways that Stripe can grow revenue for your business at stripe.com.

**中文翻译:**
本集节目由 Stripe 赞助。目前市场上《福布斯》排名前 50 的 AI 公司中，每一家都在使用 Stripe 进行变现。每年有 1.4 万亿美元流经 Stripe，相当于全球 GDP 的 1% 以上。Stripe 不仅仅是一个支付平台，他们还有一个名为 Stripe Billing 的产品，为 OpenAI、Anthropic、Figma、Atlassian 等 30 多万家公司提供计费支持。无论你的定价模式是简单的定期计费、基于使用量的计费，还是销售协商的合同，Stripe Billing 都能让你轻松管理客户。收集并留存更多收入，自动化收入管理工作流，并接受全球付款。使用 Stripe 处理你所有的支付相关需求，包括计费、收入运营、结账流程，或者仅仅是启动或发明新的商业模式。在 stripe.com 了解 Stripe 为你业务增长提供的所有方式。

---

### [00:31:33] Lenny Rachitsky

**English:**
Let me go in a different direction and see if there's more to learn here. When it comes to running your teams, is there something that is kind of fairly contrarian in how you approach running the product team that is maybe not how other companies operate that you think is key to your success?

**中文翻译:**
让我们换个方向，看看还有什么值得学习的。在管理团队方面，你们管理产品团队的方式中，有没有什么比较“反直觉”的做法，是其他公司可能不会做的，但你认为这是你们成功的关键？

---

### [00:31:51] Dmitry Zlokazov

**English:**
I've changed in how I operate after I joined Revolut probably because Revolut is a founder-led company and probably it's because it's self-led, and also because my role is quite spread across many things. So my role at Revolut is leading product function across company, but also leading retail, which is a core part of Revolut business. And it's very easy to be spread thinly across all those domains and catching up with 50 or 70 projects that are being executed simultaneously, which would mean that you will just spend your entire week just catching up on statuses, not really adding value to anyone, but it's also scary to not do it because what if there are some things going wrong and you won't be able to stop it or steer in a better direction.

**中文翻译:**
加入 Revolut 后，我的运作方式发生了改变，可能是因为 Revolut 是创始人驱动的公司，也可能是因为它是自我驱动的，还因为我的职责非常广泛。我在 Revolut 负责全公司的产品职能，同时也领导零售业务，这是 Revolut 的核心部分。如果你同时跟进 50 或 70 个正在执行的项目，精力很容易被分散，这意味着你整周可能都在了解进度，而没有真正为任何人创造价值。但不这样做也很可怕，因为万一出了问题，你无法及时制止或引导到更好的方向。

---

### [00:32:57] Dmitry Zlokazov

**English:**
So I think that's why also a lot of managers, especially in senior positions, they kind of stay high level and they don't go very deep into details. But how we did differently at Revolut is to go very deep into details. We take maybe 7 or 10 projects which are most impactful for customers right now. And we go super deep into them, really, really deep sitting with engineers like reading code level and understanding, okay, how it's built exactly and what's the underlying issue. And you could think that, okay, but what about others? Let's say 50 or 60 items that are being executed. But the thing is that it actually, it's counterintuitive, but it works really well because first of all, teams, they talk to each other, there are formal and informal ways of communicating through meetups or just meeting in the office and they know which areas are being scrutinized right now and which team is being scrutinized.

**中文翻译:**
我想这就是为什么很多管理者，尤其是高层，往往只停留在宏观层面而不深入细节。但在 Revolut，我们的做法不同：我们会深入细节。我们会挑选 7 到 10 个目前对客户影响最大的项目，然后极其深入地参与进去，真的会和工程师坐在一起看代码，理解它是如何构建的，底层问题是什么。你可能会想：那剩下的 50 或 60 个项目怎么办？事实是，这虽然反直觉，但效果很好。因为首先，团队之间会交流，通过见面会或办公室偶遇等正式或非正式的方式，他们知道哪些领域和团队目前正在接受严格审查。

---

### [00:34:19] Dmitry Zlokazov

**English:**
And it also gives information on what are the current priorities in the company. But in addition, it's signaled to other teams that if they are not proactively executing things on the expected level, paying attention to all the details and being meticulous in all those details, especially in quality, they will be the ones that will be reviewed to a such deep level, next phase, next cycle. So as a result, it also builds a great discipline. And since Revolut is such a high concentration of very ambitious people who thrive for being best versions of themselves and grow, and it's very important for them to prove that they can deliver great things and build next great company. As a result, they do everything to operate autonomously. And when you start diving deep into details, you see that everything is fine, you see their modus operandi and you can understand, okay, if this team is on good track or not on good track. And if it's not on good track, it means that it probably will be one of your next areas as of focus.

**中文翻译:**
这传达了公司当前的优先级。此外，它向其他团队发出了信号：如果他们没有主动以预期的水平执行任务，没有关注所有细节并保持严谨（特别是在质量方面），那么在下一阶段或下一个周期，他们就会成为被深度审查的对象。结果，这建立了一种极好的纪律性。由于 Revolut 聚集了大量极具野心、渴望成长并成为最好自己的人，证明自己能交付伟大的成果对他们来说非常重要。因此，他们会竭尽全力自主运作。当你开始深入细节时，你会发现一切都很顺利，你会看到他们的运作模式，并能判断这个团队是否在正轨上。如果不在正轨上，它很可能就会成为你下一个关注的重点领域。

---

### [00:35:53] Lenny Rachitsky

**English:**
Okay. So what I'm hearing is you said there's 50 to 60 things kind of projects being built at once.

**中文翻译:**
好的。所以我听到的是，你说同时大约有 50 到 60 个项目在进行。

---

### [00:35:58] Dmitry Zlokazov

**English:**
Maybe closer to a hundred, actually.

**中文翻译:**
实际上可能接近 100 个。

---

### [00:35:59] Lenny Rachitsky

**English:**
Okay. Okay. So there's like a hundred things happening at any point like features being built, products being launched, and this is you and the founders choose 7 to 10 to focus on, or is it just you?

**中文翻译:**
好的。也就是说任何时候都有大约 100 件事在发生，比如功能开发、产品发布。是你和创始人一起挑选 7 到 10 个重点关注，还是只有你？

---

### [00:36:13] Dmitry Zlokazov

**English:**
No, it's just me.

**中文翻译:**
不，只有我。

---

### [00:36:15] Lenny Rachitsky

**English:**
Just you. Okay. And by the way, do you have a leadership team that you're a part of with a design lead or is it just you basically at the top?

**中文翻译:**
只有你。好的。顺便问一下，你是否属于一个包含设计负责人的领导团队，还是说基本上只有你在顶层负责？

---

### [00:36:22] Dmitry Zlokazov

**English:**
So the way it's structured, my responsibility is a product function. We also have a head of design function. It's also part of my team, but then all the other functions, they are separate like engineering and data function, and all of them report directly into a CEO.

**中文翻译:**
目前的架构是，我负责产品职能。我们也有设计负责人，也是我团队的一部分。但其他职能部门，如工程和数据，是独立的，他们直接向 CEO 汇报。

---

### [00:36:41] Lenny Rachitsky

**English:**
Got it. Okay. So out of a hundred things you choose, here's the 7 to 10 things I'm going to go deep on. These are the things that matter most to the business that if they don't go well, it'll have the most downside. And then you basically said you sit next to the engineers, you get really involved in every detail.

**中文翻译:**
明白了。所以从 100 件事中，你会选出 7 到 10 件深入参与。这些是对业务最重要的事，如果做不好，负面影响最大。然后你基本上会坐在工程师旁边，深度参与每一个细节。

---

### [00:36:59] Dmitry Zlokazov

**English:**
Yeah, correct.

**中文翻译:**
是的，没错。

---

### [00:37:00] Lenny Rachitsky

**English:**
Awesome. Okay. That is definitely counterintuitive. We had Brian Chesky in the podcast and the way he approached this problem is he just cut down how many things happen at Airbnb because he wants to be involved in everything. And so I think it's cool to hear a different approach where we can still do a lot of stuff, but I'm going to choose, I'm going to go deep on the things that matter most.

**中文翻译:**
太棒了。这确实很反直觉。Brian Chesky 曾上过这个播客，他处理这个问题的方法是大幅削减 Airbnb 同时进行的事务数量，因为他想参与每一件事。所以听到这种不同的方法很酷：我们可以同时做很多事，但我会选择在最重要的事上深入钻研。

---

### [00:37:21] Dmitry Zlokazov

**English:**
No, I think we'll never cut down things, it's just the appetite for growth and also entrepreneurial approach in the company is so high that we'll never allow ourselves to give up on some great opportunities, but also this approach is way more scalable. So while leadership and obviously founders themselves keep everyone accountable, go deep into details, it doesn't mean that they micromanage everyone. That's actually a very important thing. So the ideal position for any product owner is to be fully autonomous. And again, it doesn't mean that you will never be challenged, but if when you're challenged, you can show all the logic behind decisions you've made behind the roadmap. And even if metrics are not yet there, you will still let's say have this credit of trust to keep building things the way you want to build them. Eventually, yeah, you will be presenting the outputs of your activity on these weekly product reviews, but again, it's not a micromanagement either. It's more like, let's say a last line of control to make sure that what we're building all makes sense and that's value and is thoroughly thought in all details.

**中文翻译:**
不，我想我们永远不会削减事务。公司对增长的渴望和创业精神如此强烈，以至于我们绝不会允许自己放弃任何绝佳的机会。而且这种方法更具扩展性。虽然领导层和创始人会让每个人负责并深入细节，但这并不意味着他们在微观管理（Micromanage）每个人。这其实非常重要。对于任何 PO 来说，理想的状态是完全自主。这并不意味着你永远不会受到挑战，但当你受到挑战时，你能展示出决策和路线图背后的所有逻辑。即使指标还没达到预期，你仍然拥有“信任额度”，可以按照自己的方式继续构建。最终，你会在每周的产品评审中展示成果，但这也不是微观管理，更像是最后一道防线，确保我们构建的东西合乎逻辑、有价值，并且细节考虑周全。

---

### [00:38:48] Lenny Rachitsky

**English:**
And then you said still every screen that is shipped, the founders review at some point, so it's not like someone's shipping stuff without the founders seeing it in some form.

**中文翻译:**
你还提到，发布的每一个屏幕界面，创始人在某个阶段都会审查，所以不会出现有人在创始人完全不知情的情况下发布东西的情况。

---

### [00:38:56] Dmitry Zlokazov

**English:**
Yeah, yeah, exactly. They have a full overview over everything, but also it allows us to build so many things because there is actually little micromanagement. If founders had to be involved into everything, they had to cut things down. But by giving people autonomy, they actually boost company growth. And as a result, I think Revolut is a strong outlier in the industry in terms of how many products being shipped and how fast they shipped. Another thing here is what I mentioned previously is us investing heavily into platform so that every solution is scalable from the get go so that we don't have any custom solutions. And for example, take our credit team, they ship new products like loans or credit cards in the country literally every month. And it is just maybe 300 people. And I think that a credit division in an incumbent bank is maybe 2 or 3000 people building just credit products for a single country.

**中文翻译:**
是的，没错。他们对一切都有全局把握，但这反而让我们能做更多事，因为实际上的微观管理很少。如果创始人必须参与每一件事，他们就不得不削减项目。但通过赋予员工自主权，他们实际上促进了公司的增长。因此，我认为 Revolut 在产品发布数量和速度上是行业的异类。另一件事是我之前提到的，我们大力投资于平台，确保每个解决方案从一开始就是可扩展的，不搞定制化方案。以我们的信贷团队为例，他们几乎每个月都能在某个国家发布新产品，如贷款或信用卡。而这个团队只有大约 300 人。相比之下，传统银行的信贷部门可能有两三千人，却只为一个国家构建信贷产品。

---

### [00:40:28] Dmitry Zlokazov

**English:**
And our team is building it for 50 countries. And yeah, it's enabled through this approach with platforms which we build on top of small lean teams which are fully equipped with necessary functions and also have autonomy in defining what they're building and the flat hierarchy with everyone being accountable and founders having direct view of everyone and intervening if necessary.

**中文翻译:**
而我们的团队是在为 50 个国家构建。这得益于我们的平台化方法，以及配备了必要职能、拥有定义产品自主权的精简小团队，再加上扁平化的架构——每个人都负责，创始人能直接看到每个人的工作并在必要时介入。

---

### [00:41:07] Lenny Rachitsky

**English:**
I'm going to give people a list of the things you guys do. I didn't do this at the beginning because it would take too long, but you talk about all the products you're building and all the things that's going on. So I have a list here. It's probably incomplete, but just to give people a sense, so you guys have credit cards, debit cards, savings accounts, multi-currency accounts, domestic international transfers, joint accounts, minor accounts for less than 18 years old, stock trading, cryptocurrency purchasing, loans. Is there anything big I missed?

**中文翻译:**
我要给大家列一下你们做的事情。开头我没列，因为太长了。但既然你提到了这么多产品，我这里有一个清单，可能不完整，但能让大家有个概念：你们有信用卡、借记卡、储蓄账户、多货币账户、国内和国际转账、联名账户、18 岁以下未成年人账户、股票交易、加密货币购买、贷款。我漏掉了什么大项吗？

---

### [00:41:37] Dmitry Zlokazov

**English:**
I mean, some of those things are a huge by itself, let's say stock trading. It's not just stocks, it's also ETFs, bonds, and we're working on tax efficient accounts in different countries and crypto. We also allow staking crypto for example, we have on-ramp, off-ramp products, we have acquiring products. On credit, we have loans, we have a buy now per later product, we even launched mortgages. We launched first mortgages in Albania recently.

**中文翻译:**
我是说，其中一些项目本身就非常庞大。比如股票交易，不仅有股票，还有 ETF、债券，我们还在开发不同国家的税收优惠账户。加密货币方面，我们支持质押（Staking），有出入金（On-ramp/Off-ramp）产品，还有收单（Acquiring）产品。信贷方面，我们有贷款、“先买后付”（BNPL）产品，甚至还推出了抵押贷款。我们最近在阿尔巴尼亚推出了首批抵押贷款。

---

### [00:42:17] Lenny Rachitsky

**English:**
And then all of these across 50 different currencies and countries.

**中文翻译:**
而且所有这些都覆盖了 50 个不同的货币和国家。

---

### [00:42:21] Dmitry Zlokazov

**English:**
Yeah, 50 different jurisdictions each with its own regulation, with its own requirements.

**中文翻译:**
是的，50 个不同的司法管辖区，每个都有自己的法规和要求。

---

### [00:42:28] Lenny Rachitsky

**English:**
Oh, boy. It's a good example of Paul Graham has this concept of schlep blindness or schlepping where people want to avoid hard problems, but that's where the big opportunities are, solving really gnarly, painful problems. And that's basically what you guys did.

**中文翻译:**
天哪。这真是保罗·格雷厄姆（Paul Graham）提到的“苦差事盲点”（Schlep Blindness）的一个绝佳例子。人们往往想避开难题，但解决那些极其棘手、痛苦的问题正是巨大机会所在。这基本上就是你们所做的。

---

### [00:42:46] Dmitry Zlokazov

**English:**
Yeah, that's one of the things that excites me maybe the most at Revolut. The market is so big and there are still a lot of very inefficient players, and as a result, customers have a lot of problems that are unsolved. While we grow insanely and I think will soon be... When I joined, we had maybe just slightly north to 20 million customers. Now we are 50 million customers. Soon we'll be at 100 million customers. The degree of surrounding each customer with the ecosystem of our products extends a lot. So they become more and more people start using Revolut as their main bank account. They start receiving their salary into Revolut, holding their savings into Revolut because they love the product more. And so we can easily do another, I don't know, 2, 3X, 4X in customer base growth, but we can also do another 10X growth in how actively these people are using the product. So it's let's say what, 30, 40X to current, 45 billion valuation. Right? So it's a like a trillion-dollar company easily.

**中文翻译:**
是的，这也是在 Revolut 最让我兴奋的事情之一。市场如此巨大，仍然有很多效率极低的玩家，导致客户有很多问题未被解决。虽然我们增长疯狂——我加入时大约只有 2000 多万客户，现在是 5000 万，很快会达到 1 亿。我们用产品生态系统围绕每个客户的程度大大加深了。越来越多的人开始把 Revolut 当作主银行账户，把工资发到这里，把积蓄存在这里，因为他们更喜欢这个产品。所以我们的客户群可以再翻 2、3、4 倍，而活跃度还可以再翻 10 倍。相对于目前 450 亿美元的估值，这大概还有 30、40 倍的空间，对吧？所以这很容易成为一家万亿美元的公司。

---

### [00:44:13] Lenny Rachitsky

**English:**
And on that note, I mean what I'm hearing is it's still a good time to join. There's a massive upside. So I know you guys are hiring, we'll just note that real quick. You're hiring product owners and a bunch of other roles, I imagine?

**中文翻译:**
说到这，我听到的是现在仍然是加入的好时机，有巨大的上升空间。我知道你们正在招聘，顺便提一下，你们在招 PO 和很多其他职位，对吧？

---

### [00:44:24] Dmitry Zlokazov

**English:**
Yeah, yeah. Well, as someone who owns the product function, I'm especially interested in product owners obviously, but we hire a lot of roles. I think we have maybe 3 or 400 open positions currently.

**中文翻译:**
是的。作为负责产品职能的人，我显然对 PO 特别感兴趣，但我们也招很多职位。我想目前大约有 300 到 400 个空缺职位。

---

### [00:44:39] Lenny Rachitsky

**English:**
Oh my God. Okay. I want to talk a bit about new stuff that you work on. So new products that you decide to invest in. Is there anything that you've figured out about just how to set up new products for success? Because a lot of the stuff we've been talking about is staying on top of stuff that you're iterating on and making better. What have you learned about just helping new products succeed?

**中文翻译:**
天哪。好的。我想聊聊你们做的新东西，也就是你们决定投资的新产品。关于如何让新产品走向成功，你有什么心得吗？因为我们之前聊的大多是如何迭代和改进现有产品。在帮助新产品成功方面，你学到了什么？

---

### [00:45:02] Dmitry Zlokazov

**English:**
Yeah, so we launched quite a few products that you actually maybe wouldn't expect from a bank starting with crypto that was insanely successful, but also non-financial services like booking a hotel through Revolut app, our loyalty program, rev points, which is sort of disrupting European market where people don't get great benefits from spending with card. In the US you can easily get, like what? 2% cashback with a credit card or in some sort of point. In Europe they don't have it. And we are actually the first to build a program on card spend rewarding people with really meaningful or monetary rewards. In the manner that I described. We understood, okay, what's the recipe of this success to then scale it and reproduce? So we built a new bets framework and essentially everyone can come up with a new idea. It could be a product owner, but it could be anyone, and they need to show some key important things which you usually can expect from a startup like market is there, business case is there.

**中文翻译:**
是的，我们推出了不少你可能不会指望银行去做产品。从极其成功的加密货币开始，到非金融服务，比如通过 Revolut 预订酒店，还有我们的忠诚度计划 RevPoints。这在某种程度上颠覆了欧洲市场，因为在欧洲，刷卡消费通常没有太多福利。在美国，你很容易通过信用卡获得 2% 的返现或积分，但在欧洲没有。我们是第一个建立这种刷卡奖励计划的公司，为人们提供真正有意义的或货币化的奖励。通过这种方式，我们理解了成功的秘诀，然后进行扩展和复制。所以我们建立了一个新的“押注框架”（Bets Framework），基本上每个人都可以提出新想法。可以是 PO，也可以是任何人，他们需要展示一些初创公司通常具备的关键要素，比如市场存在、商业案例成立。

---

### [00:46:15] Dmitry Zlokazov

**English:**
We know that we can do it way better than competitors leverage and for example, some things that we have obviously some concepts of product and then what customer problem we're solving and so on. And there is very little bureaucracy, again, thanks to having founder hands-on, we can easily get a green light on anything, start launching it quickly. What we do is assemble same lean team with just a few people to build first version and then iterate and iterate. And the main thing here is to build first version very quickly to get feedback, but then not scale it before you polish the product. But then after we make sure that all metrics are fine, retention is great, we start scaling it. And the good news is that it can be instantly multiplied by our 50 million customer base and get great traction. So for example, one of the products that you mentioned, joint accounts essentially an account that you could have with a significant other one was one of the recently launched feature and it grew significantly and now it has over a million active users.

**中文翻译:**
我们要证明我们能比竞争对手做得更好，利用我们已有的优势，明确产品概念以及我们要解决的客户问题等等。这里几乎没有官僚主义，再次感谢创始人的亲力亲为，我们可以轻松获得任何项目的绿灯并快速启动。我们的做法是组建一个只有几个人的精简团队来构建第一版，然后不断迭代。核心是快速构建第一版以获取反馈，但在产品完善之前不要大规模推广。一旦我们确认所有指标正常、留存率很好，我们就开始规模化。好消息是，它可以立即通过我们 5000 万的客户群进行放大，并获得巨大的牵引力。例如你提到的联名账户，这是最近推出的功能，增长非常快，现在已经有超过 100 万活跃用户。

---

### [00:47:33] Lenny Rachitsky

**English:**
I hear one of the ways you kind of approach these early products differently is you guys invest a lot in actually making it good and not just like a scrappy MVP. Does that ring a bell? Does that resonate?

**中文翻译:**
我听说你们处理早期产品的一个不同点是，你们会投入大量精力真正把它做好，而不仅仅是一个简陋的 MVP（最小可行性产品）。这听起来熟悉吗？

---

### [00:47:45] Dmitry Zlokazov

**English:**
Indeed, that's what I may be meant by keeping your first version narrowed down to a small user base. But even in this case, we still make sure that the product is well. So no one is excluded from this requirement of building a super polished product. It takes time, but it pays off. The thing is that when you launch a scrappy version and it's not getting traction, how do you know? Is it because the underlying idea is wrong or maybe your product just sucks and you need to improve it? So by forcing everyone to build a product that people will love by building a wow product, we kind of cut out this part of uncertainty. So bottom line, we can cut down the product in terms of functionality to just most critical features, but we will never compromise on the quality and UX and the aesthetics.

**中文翻译:**
确实如此，这就是我所说的将第一版限制在小用户群的意思。但即便如此，我们仍确保产品质量极佳。没有人能免除“打造高度打磨的产品”这一要求。这需要时间，但值得。问题在于，当你发布一个简陋版本且没有获得牵引力时，你怎么知道原因？是因为底层想法错了，还是因为你的产品太烂需要改进？通过强制每个人都去打造一个人们会喜爱的“Wow”产品，我们排除了这种不确定性。所以底线是：我们可以在功能上精简到最核心的部分，但绝不会在质量、UX 和美学上妥协。

---

### [00:48:56] Lenny Rachitsky

**English:**
An interesting advantage you guys have that I'm realizing as you talk is most of the stuff you launch is stuff that is clearly something people will want because it's stuff that they get other places, but they get the advantages of it being integrated into all the other features and products you have. So it's like a cryptocurrency product. It's kind of like, okay, yeah, people would love a great cryptocurrency product built into this or joint accounts. So there's almost like a benefit of just like, okay, the people will want this, now let's just make it work really well with everything else we got and not hurt. You almost don't need to be the best at every product, although it sounds like you still try to be the best.

**中文翻译:**
我意识到你们有一个有趣的优势：你们发布的大多数东西显然都是人们想要的，因为他们在别处也能用到，但在你们这里，优势在于它与所有其他功能和产品集成在一起。比如加密货币产品，人们当然想要一个内置的优秀加密货币产品，或者联名账户。所以这几乎有一种天然优势：人们肯定想要这个，我们只需让它与现有的一切完美配合即可。你几乎不需要在每个单项产品上都做到世界第一，尽管听起来你们仍然在努力做到最好。

---

### [00:49:35] Dmitry Zlokazov

**English:**
But we must be the best. Yeah, a hundred percent.

**中文翻译:**
但我们必须做到最好。是的，百分之百。

---

### [00:49:37] Lenny Rachitsky

**English:**
But there's also, if you don't have the best joint account, but all the other stuff is awesome, people are like, "All right, it's fine. It just makes my life easier." But tell me what I might be missing because-

**中文翻译:**
但也有可能，如果你没有最好的联名账户，但其他东西都很棒，人们会觉得：“行吧，没关系，它让我的生活更方便了。”但告诉我我可能漏掉了什么，因为——

---

### [00:49:46] Dmitry Zlokazov

**English:**
So I think there are those kind of table stakes that we're building that anyone would expect from a bank. For example, savings account, right? It's just a basic thing that if a bank is not providing savings account, you wouldn't even consider it. But then we make sure that our rates are very competitive, if not the best. Then we make sure that there is no bad UX. Some banks, for example, they don't allow you to withdraw instantly and there are delays or they don't pay interest on daily basis. We will never do that. We will allow you if you want to move money out, you will be able to do it. You won't lose any interest. And interest is being paid daily and this is a fully flexible product. And then on top of it, what I would call maybe some delighters is we will allow you to open the savings account in many currencies.

**中文翻译:**
我认为我们构建的东西中，有一些是“入场券”（Table Stakes），即任何人对银行的预期。比如储蓄账户，如果一家银行不提供储蓄账户，你根本不会考虑它。但我们会确保我们的利率非常有竞争力，甚至就是最好的。然后我们确保没有糟糕的 UX。例如，有些银行不允许即时提现，会有延迟，或者不按日计息。我们绝不会那样做。如果你想把钱转走，随时可以转，不会损失利息。利息按日支付，这是一个完全灵活的产品。在此基础上，还有一些我称之为“令人愉悦的功能”（Delighters），比如我们允许你开设多种货币的储蓄账户。

---

### [00:50:49] Dmitry Zlokazov

**English:**
So we want to add different currencies because now interest rates are going down, so people might find it valuable to open a savings account in, for example, I know in Europe, Swedish Krona interest rates are higher than Europe, but it could be even something like Brazilian Real with 12% interest rate versus 2 or 3% on euros. And then as the cherry on top, there is this all that in an amazing, you have very smooth, you can set custom wallpapers, you can set goals, you can automate a spare change towards your savings and all those features. So there is an underlying basic fundamental layer that where you need to be just on par with competition, but then there are a lot of things on top that just make people love your product way more. And obviously there are a lot of synergies in between those things. So yeah, thinking of crypto, you can just receive crypto on your wallet and then you can just instantly convert it to cash on your account or just spend it with your card. How amazing can it be? Just buy a coffee with Ethereum.

**中文翻译:**
我们想增加不同的货币，因为现在利率在下降，人们可能会发现开设其他货币的储蓄账户很有价值。比如在欧洲，瑞典克朗的利率比欧元高；甚至可以是巴西雷亚尔，利率 12%，而欧元只有 2% 或 3%。最后作为锦上添花，这一切都封装在极佳的体验中：非常流畅，可以设置自定义壁纸、设置目标、自动将零钱存入储蓄等等。所以，底层是基础层，你必须与竞争对手持平；但顶层有很多东西能让人们更爱你的产品。显然，这些产品之间有很多协同效应。比如加密货币，你可以在钱包里接收加密货币，然后立即兑换成账户里的现金，或者直接刷卡消费。这多神奇啊？直接用以太坊买咖啡。

---

### [00:52:09] Lenny Rachitsky

**English:**
I love that. Okay, let me take this opportunity to try to summarize what I've learned from you so far in terms of what you guys have figured out about creating incredible product leaders. They go on to do wonderful things and basically one of the top three most successful companies at this. So there's kind of these two buckets as I talked to you and the Palantir guy, there's kind of like the hiring piece and then there's what you do to help incubate this kind of forge for incredible product leaders. So in what you do internally, kind of the four bullet points I've got here is give people a lot of ownership. They're essentially GMs of the product, the feature.

**中文翻译:**
我喜欢这个。好的，让我趁机总结一下到目前为止我从你这里学到的关于培养优秀产品领导者的经验。他们离职后表现卓越，你们基本上是这方面最成功的前三名公司之一。正如我和 Palantir 的人聊过的那样，这可以分为两个维度：一是招聘，二是你们如何内部孵化和锤炼这些领导者。在内部做法上，我总结了四点：第一，赋予极大的所有权，他们本质上是产品或功能的总经理。

---

### [00:52:46] Lenny Rachitsky

**English:**
There's a lot of focus on depth and complexity and getting really good at solving really gnarly problems. And then there's a focus on building wow products, amazing lovable products that have a very high bar. And then there's kind of a subtle point that I think is probably impactful here is just working closely with detail-obsessed founders or product leaders like you and learning from you all and just seeing the value and impact of being super detail oriented. On that bucket, is there anything else that you think is super core that I missed before we get to hiring?

**中文翻译:**
第二，关注深度和复杂性，擅长解决极其棘手的问题。第三，关注打造“Wow”产品，即高门槛、令人喜爱且惊艳的产品。第四，一个微妙但可能很有影响力的点，就是与像你这样痴迷细节的创始人或产品领导者密切合作，向你们学习，并亲眼看到极度关注细节所带来的价值和影响。在这一维度，进入招聘话题之前，你觉得我还有什么漏掉的核心点吗？

---

### [00:53:21] Dmitry Zlokazov

**English:**
Yeah, I would just maybe highlight the aspect of this going deep into details. There are two main streams. First is let's say being technical, understanding how underlying systems work, but second is also building empathy towards customers. Understand the possible contexts and making sure that your product will satisfy each one of them.

**中文翻译:**
是的，我想强调一下“深入细节”的两个主要流派。第一是技术层面，理解底层系统是如何运作的；第二是建立对客户的同理心，理解可能的各种场景，并确保你的产品能满足每一个场景。

---

### [00:53:46] Lenny Rachitsky

**English:**
That's a great point. So it's actually understanding the bare metal of what is happening and how it's possible, and then making the experience as simple and wowable as possible.

**中文翻译:**
这点很好。也就是既要理解底层硬件/系统的运作原理，又要让体验尽可能简单且令人惊叹。

---

### [00:53:56] Dmitry Zlokazov

**English:**
There is also a third aspect, but it's a boring one and it's complying with all possible regulations and making sure that your product will satisfy the regulator, but it's also an important part of the job.

**中文翻译:**
还有第三个方面，虽然比较枯燥，那就是遵守所有可能的法规，确保你的产品能让监管机构满意，这也是工作中很重要的一部分。

---

### [00:54:13] Lenny Rachitsky

**English:**
What I get from that is just building patience with all-

**中文翻译:**
我从中体会到的是，要培养对所有这些事情的耐心——

---

### [00:54:18] Dmitry Zlokazov

**English:**
I would say it's actually being able to unblock your team and that sometimes require product owners to steam roll changes because it also means that you could easily get stuck with a lot of people just looking into each other and thinking, "Okay, can they approve it? Can they not approve it?" We try to innovate on it. We try to automate as many things as possible. We use even AI models for that, but it also requires a product owner to be able to get things done, just getting people down to consensus and understanding how your stakeholders, how to get them to the necessary decision and then blocking UTM so that eventually the value is shipped to customers.

**中文翻译:**
我想说，这实际上是关于如何为团队扫清障碍。有时这要求 PO 强力推进变革，因为你很容易陷入僵局——一大堆人面面相觑，想着：“好吧，他们能批准吗？不能批准吗？”我们试图在这方面创新，尽可能自动化。我们甚至为此使用 AI 模型。但这也要求 PO 具备“搞定事情”的能力，让大家达成共识，理解如何引导利益相关者做出必要决策，从而扫清障碍，最终将价值交付给客户。

---

### [00:55:10] Lenny Rachitsky

**English:**
Awesome. Essentially it's just getting done, plowing through blockers, dealing with many stakeholders.

**中文翻译:**
太棒了。本质上就是搞定事情，冲破障碍，处理众多的利益相关者。

---

### [00:55:18] Dmitry Zlokazov

**English:**
Yeah. That's always the most important.

**中文翻译:**
是的，这永远是最重要的。

---

### [00:55:20] Lenny Rachitsky

**English:**
Okay. That's a great addition. I could see why that would be really helpful for folks that are trying to get ahead in their career. And then on the hiring piece, what you look for is raw intellect, drive hunger, passion essentially. Those are the first two. And then interestingly, non-senior, not people with a ton of experience in the problem space, more so focusing on intellect and hunger. Is there anything else in that bucket that you think is important that leads to people being really successful?

**中文翻译:**
好的，这是一个很好的补充。我能理解为什么这对那些想要在职业生涯中更进一步的人很有帮助。关于招聘，你们看重的是原始智力、驱动力、饥渴感和激情。这是前两点。有趣的是，你们不倾向于招资深人士或在相关领域有大量经验的人，而是更关注智力和饥渴感。在这一维度，你觉得还有什么重要的因素能让人们最终获得成功？

---

### [00:55:49] Dmitry Zlokazov

**English:**
Most importantly, it's again, getting things done, getting your hands dirty, and great product owners are very hands-on. They don't think of themselves as managers who just give tasks to people and wait them to complete it. They just go and get things done and they understand that most important things they will likely have to do themselves, and they understand that there needs to be relentless focus on execution, and if something is 99% done, it's closer to 0% rather than 100%.

**中文翻译:**
最重要的是，再次强调，是搞定事情、亲力亲为。优秀的 PO 是非常注重实操的。他们不认为自己只是分配任务并等待完成的管理者。他们会亲自去把事情做成，他们明白最重要的事可能必须亲自动手。他们理解必须不懈地关注执行。如果一件事完成了 99%，它其实更接近 0%，而不是 100%。

---

### [00:56:29] Lenny Rachitsky

**English:**
Whoa, say more there. Is the kind of insight there is just things seem like they're 99% done, but they're actually very far from being done?

**中文翻译:**
哇，多讲讲这个。这里的洞察是说，事情看起来完成了 99%，但实际上离真正完成还很远吗？

---

### [00:56:38] Dmitry Zlokazov

**English:**
Sometimes the product is built, but then product owners are the ones who also make sure that, for example, customer care team or sales and marketing team are using it to a full extent because without it, it could be just another useless feature, and no one knows about it.

**中文翻译:**
有时产品已经构建好了，但 PO 还需要确保，比如客服团队或销售营销团队正在充分利用它。因为如果没有这些，它可能只是另一个没人知道的无用功能。

---

### [00:56:57] Lenny Rachitsky

**English:**
That is super cool. I like that mentality. Let me ask you something completely different. What's kind of the story of you landing at Revolut? I know you had to move your family. It was a whole adventure.

**中文翻译:**
这太酷了，我喜欢这种心态。让我问你一个完全不同的问题。你加入 Revolut 的故事是怎样的？我知道你不得不搬家，带着家人，那是一次大冒险。

---

### [00:57:08] Dmitry Zlokazov

**English:**
My journey into Revolut actually coincided with me moving to the UK, so it was a completely new environment for myself. It's a huge stress load for the brain as well. And it's not only about using the other side of the lane on the road in the UK, but also it's a lot of things, for example, in the industry, some concepts that I've never heard about, and actually I've never worked at FinTech before, so I also changed the industry. So it was a complete turnaround for me and for my career, but I was very determined and excited about it because everyone who I've been talking to, they were saying Revolut is like it's top talent is at Revolut, all best product people are at Revolut, and I really wanted to be part of this great team.

**中文翻译:**
我加入 Revolut 的旅程正好赶上我搬到英国，所以对我来说是一个全新的环境。这对大脑来说也是巨大的压力。不仅是要适应英国靠左行驶，还有很多事情，比如行业内一些我从未听过的概念。实际上我以前从未在金融科技领域工作过，所以我还跨了行。这对我个人和职业生涯来说都是彻底的转变。但我非常坚定且兴奋，因为我交谈过的每个人都说 Revolut 聚集了顶尖人才，最好的产品人都在 Revolut，我真的很想成为这个优秀团队的一员。

---

### [00:58:11] Dmitry Zlokazov

**English:**
Eventually it actually appeared to be advantageous for me because I also had this fresh view on things and even in the Revolut app, which is actually way, way better than other banks products. But even there I found some things that for me, because of this lack of context, they were not intuitive and I worked hard with the team to change that.

**中文翻译:**
最终，这对我来说反而成了一种优势，因为我拥有了全新的视角。即使在 Revolut 的应用中（它已经比其他银行的产品好得多），我仍然发现了一些因为我缺乏背景知识而觉得不直观的地方，于是我和团队一起努力改变了这些。

---

### [00:58:43] Lenny Rachitsky

**English:**
Okay, great. I'm going to take us to recurring segment of the podcast. I'm going to take us to Fail Corner. So in Fail Corner, the idea here is people come on this podcast, they share all these stories of success, everything's always going great, but in reality, things don't often go great, and there's a lot of things that don't go right. Is there a story you could share where things went wrong in your career, where you failed with a product you were building or a moment in your career where things were looking really bad?

**中文翻译:**
太好了。现在进入播客的固定环节：“失败角落”（Fail Corner）。在这个环节，嘉宾们通常会分享成功的故事，一切看起来都很顺利，但现实中并非如此，总有很多事情会出错。你能分享一个职业生涯中出错的故事吗？比如你构建的产品失败了，或者职业生涯中某个非常糟糕的时刻？

---

### [00:59:11] Dmitry Zlokazov

**English:**
I think the most spectacular failures is probably were on the earliest stage of my career, which I studied back at university and maybe in my second year of university I started building some things, different startups, and one of them was actually a product that makes me proud even now because it was like what, 15 years ago? So 2010, meaning still no one really had even iPhones back then and me and my friends, we started building a website that allows people to buy tickets to the cinema so that they can skip the line so they don't need to come in advance to select best seats and they can just buy a ticket online and go to the seats directly. Something that today seems as a commodity. Back then no one had it.

**中文翻译:**
我想最惨痛的失败可能发生在我职业生涯的最早期。我在大学二年级时就开始创业，做过不同的项目。其中一个产品即使现在也让我感到自豪，那是大约 15 年前，也就是 2010 年。那时候还没什么人用 iPhone，我和朋友们开始建立一个网站，让人们可以在线购买电影票，这样他们就可以跳过排队，不需要提前去选座，直接买票入座。这在今天看来是理所当然的事，但当时没人做。

---

### [01:00:15] Dmitry Zlokazov

**English:**
People were using pieces of paper and we built an end-to-end system because not only we needed to build a website, but we also needed to build hardware to scan those tickets, for example. And to have these tickets in digital format, we needed to hack SMS standard because again, people didn't have smartphones. They had these Nokias and we were sending images, QR codes inside an SMS, which is like a hack of the standards in a way. And then we were scanning those things with our own devices and we built our own devices with scanners, and we actually created these beautiful devices made from stainless steel, which looked really nice inside the cinema halls.

**中文翻译:**
当时人们还在用纸质票。我们构建了一个端到端系统，不仅要建网站，还要构建扫描票据的硬件。为了实现数字票据，我们不得不“黑”掉短信（SMS）标准，因为人们当时没有智能手机，用的是诺基亚。我们尝试在短信里发送图像和二维码，这在某种程度上是对标准的破解。然后我们用自己制造的设备进行扫描。我们用不锈钢制造了这些漂亮的扫描设备，放在电影院大厅里看起来非常酷。

---

### [01:01:12] Dmitry Zlokazov

**English:**
And I remember how I was excited about it with my friends. We were like, "What an amazing thing." It's like, look, we are bringing future here, but we actually spent all our investment on this hardware and we were expecting that everyone will just rush into using our system. But it was a very low share of customers who started buying tickets online because people were not ready for it, which was growing quite slowly. And eventually we had to close it because we simply ran out of money because we spent all of it on this hardware without any proven business model. So something that currently looks like an obvious mistake back then, we were just enjoying building a product that we would love to use ourselves, which I think is the right principle, but it also was a very painful lesson. You need to stay lean, you need to validate things before you scale them. You need to think way more about the run rate of your business. So there were a lot of painful lessons for me. Since then, I also try to avoid working with hardware.

**中文翻译:**
我记得当时我和朋友们有多兴奋，我们觉得：“太神奇了，我们在把未来带到现实。”但实际上我们把所有的投资都花在了这些硬件上，并期待每个人都会涌向我们的系统。然而，只有极少数客户开始在线买票，因为人们还没准备好，增长非常缓慢。最终我们不得不关闭它，因为钱花光了——我们把钱全砸在了硬件上，却没有经过验证的商业模式。现在看来这显然是个错误，但当时我们只是沉浸在打造一个自己想用的产品的乐趣中。虽然我认为这个原则是对的，但这也是一个惨痛的教训：你需要保持精简，在规模化之前验证想法，你需要更多地考虑业务的现金流（Run rate）。那次经历给了我很多痛苦的教训。从那以后，我也尽量避免接触硬件。

---

### [01:02:27] Lenny Rachitsky

**English:**
I was just going to say that's a common challenge for startups trying to get right into hardware, although I wouldn't be surprised now if Revolut launches something another product, and this is a new product line of Revolut now that you've had that experience.

**中文翻译:**
我正想说，直接涉足硬件是初创公司的常见挑战。不过，如果 Revolut 现在利用你的经验推出新的硬件产品线，我也不会感到惊讶。

---

### [01:02:42] Dmitry Zlokazov

**English:**
We launched a POS terminals required.

**中文翻译:**
我们确实推出了 POS 终端。

---

### [01:02:48] Lenny Rachitsky

**English:**
All right, there we go. Dmitry, before we get to our very exciting lightning round, is there anything else that we haven't touched on that you think might be really helpful for listeners to hear? Maybe a last wisdom nugget that you haven't already shared, or even just something to kind of double down on that you've already shared?

**中文翻译:**
果然如此。Dmitry，在进入精彩的闪电轮提问之前，还有什么我们没聊到、但你认为对听众有帮助的吗？也许是最后一点智慧锦囊，或者是你想再次强调的内容？

---

### [01:03:04] Dmitry Zlokazov

**English:**
No, I think that it was an amazing chat and thanks, Lenny. We covered a lot of different topics. I would just maybe summarize that if you're excited to build certain things, never hesitate to do it. The best way to do it is probably your own startup, and it also what will give you the steepest possible learning curve, but then if you want to join a company, try to choose the one that has the highest entrepreneurial spirit and that will allow you to work as closer to a mode of a founder as you possibly can.

**中文翻译:**
不，我觉得这次聊天非常棒，谢谢 Lenny。我们涵盖了很多话题。我想总结一下：如果你对创造某些东西感到兴奋，永远不要犹豫。最好的方式可能是自己创业，这会给你带来最陡峭的成长曲线。但如果你想加入一家公司，尽量选择那家创业精神最强、能让你尽可能接近创始人模式工作的公司。

---

### [01:03:44] Lenny Rachitsky

**English:**
That's a recurring theme in these conversations I'm having with companies that produce the PMs that have the steepest career trajectory. And so that advice is exactly what I'm taking away from this too, assuming you want your career to accelerate really quickly after you go work at this company. Okay, Dmitry, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
在我与那些培养出职业轨迹最陡峭 PM 的公司交流时，这是一个反复出现的主题。如果你希望在加入一家公司后职业生涯能飞速发展，这个建议正是我所领悟到的。好了，Dmitry，现在进入精彩的闪电轮。准备好了吗？

---

### [01:04:06] Dmitry Zlokazov

**English:**
Yes. Let's go.

**中文翻译:**
准备好了，开始吧。

---

### [01:04:08] Lenny Rachitsky

**English:**
Here we go. Okay. First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
第一题：你向别人推荐最多的两三本书是什么？

---

### [01:04:15] Dmitry Zlokazov

**English:**
The Hard Thing About Hard Things by Ben Horowitz. Actually read it quite some time ago, but I found myself recommending it to other product managers most often. It's actually illustrative that to be a great product manager, someone needs to strive to being a great CEO. And besides this book emphasizes the importance of building systematic solutions and scalable solutions, which is critical for scaling a company. Also being honest on how important it is to grind stuff. And then second book is, I read it more recently, Build by Tony Fadell. I was really inspired by this one, especially given how I appreciate how it's not easy to build hardware and what Tony was describing there is just super exciting and inspiring. And also I think that there are different archetypes of product managers. There are people who tend to disrupt things more. Personally I think about myself as a builder, so Tony's principles that he highlighted in the book that they resonate with me a lot.

**中文翻译:**
第一本是本·霍罗威茨（Ben Horowitz）的《创业维艰》（The Hard Thing About Hard Things）。虽然读了很久了，但我发现自己最常向其他 PM 推荐它。它说明了要成为一名优秀的产品经理，必须努力成为一名优秀的 CEO。此外，这本书强调了构建系统化和可扩展解决方案的重要性，这对于公司规模化至关重要。它还诚实地讲述了“磨练”的重要性。第二本是我最近读的，托尼·法德尔（Tony Fadell）的《创造》（Build）。我深受启发，尤其是考虑到我深知制造硬件的不易，托尼在书中的描述非常令人兴奋和鼓舞。我认为产品经理有不同的原型，有些人倾向于颠覆，而我个人认为自己是一个“建造者”，所以托尼在书中强调的原则让我非常有共鸣。

---

### [01:05:44] Lenny Rachitsky

**English:**
I'm trying to get Tony on the podcast. If anyone listening knows Tony Fadell and can nudge him, "Hey, say yes to Lenny," that'd be great. I've been in touch with his team, but he's not doing podcasts right now, but I'm trying to get him on. Okay, moving on. Do you have a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
我正试着邀请托尼上节目。如果听众里有人认识他，请帮我推一把：“嘿，答应 Lenny 吧。”我一直和他的团队保持联系，但他目前不接播客，但我会继续努力。下一题：最近有没有什么喜欢的电影或电视节目？

---

### [01:05:58] Dmitry Zlokazov

**English:**
I think the last movie I watched was Oppenheimer and I really liked it. I always love watching biopics. I think they give kind of a perspective and let you think about things in perspective.

**中文翻译:**
我最近看的一部电影是《奥本海默》（Oppenheimer），我很喜欢。我一直喜欢看传记片，我觉得它们能提供一种视角，让你深入思考。

---

### [01:06:17] Lenny Rachitsky

**English:**
Is there a favorite product you recently discovered that you really love?

**中文翻译:**
最近有没有发现什么特别喜欢的电子产品或应用？

---

### [01:06:20] Dmitry Zlokazov

**English:**
Manus is a great thing.

**中文翻译:**
Manus 非常棒。

---

### [01:06:23] Lenny Rachitsky

**English:**
The AI agent?

**中文翻译:**
那个 AI 智能体？

---

### [01:06:24] Dmitry Zlokazov

**English:**
Yeah. Yeah. It's just like I was super impressed how... I was mesmerized. It's so autonomous and smooth, and I just spent a few hours vibe coding and I created this JavaScript app that sends me a rare English word every day to learn and remember, and it worked, and I was just amazed.

**中文翻译:**
是的。我印象非常深刻……简直着迷了。它非常自主且流畅。我花了几个小时进行“氛围编程”（Vibe Coding），创建了一个 JavaScript 应用，每天给我发送一个罕见的英语单词让我学习和记忆。它成功运行了，我感到非常惊讶。

---

### [01:06:54] Lenny Rachitsky

**English:**
What's a word you learned?

**中文翻译:**
你学到了哪个词？

---

### [01:06:56] Dmitry Zlokazov

**English:**
Ineffable. It was the yesterday's word.

**中文翻译:**
Ineffable（妙不可言的/不可言喻的）。那是昨天的单词。

---

### [01:06:59] Lenny Rachitsky

**English:**
I love that. It's still going. That's great. Do you have a favorite life motto that you often come back to, you find useful in work or in life?

**中文翻译:**
太棒了。你有没有什么常用的人生格言，觉得在工作或生活中很有用？

---

### [01:07:07] Dmitry Zlokazov

**English:**
I love this phrase. I think Eisenhower said it, "Plans are worthless, but planning is everything." It's like we often say how important it is to be flexible and agile and adjust to change in circumstances, but it doesn't allow us to actually not have a plan at all. It's important for us to remember that we always need to think many steps ahead and while being flexible, we also need to think things thoroughly.

**中文翻译:**
我喜欢这句话，我想是艾森豪威尔说的：“计划是无用的，但计划的过程（Planning）才是一切。”我们常说灵活、敏捷和适应变化很重要，但这并不意味着可以完全没有计划。重要的是要记住，我们总是需要提前思考很多步，在保持灵活的同时，也要深思熟虑。

---

### [01:07:43] Lenny Rachitsky

**English:**
Final question. For folks that are maybe checking out Revolut for the first time that want to play with it or already users. What's the most underrated feature? What's something that you think people should check out maybe they're not aware of, or even just like a UX, I don't know, animation, something fun that people may not know about?

**中文翻译:**
最后一个问题。对于那些第一次尝试 Revolut 或已经是用户的听众，你觉得最被低估的功能是什么？有什么是人们可能没注意到、但值得一试的？或者是一个有趣的 UX 动画？

---

### [01:07:58] Dmitry Zlokazov

**English:**
The thing that is not yet widely used, but I really loved it, is what we call a wealth protection. So if you go to settings, you can enable a limit for any transfers outside of Revolut. If you want to do a transfer above this limit, you'll have to do a selfie check, which is our proprietary technology. We do a video selfie here. It allows us to make sure that it's you, no one else is doing the transfer, and it's actually almost as smooth as face ID and the way the team built it is really great. I'm really proud of those guys.

**中文翻译:**
一个目前还没被广泛使用但我非常喜欢的功能是“财富保护”（Wealth Protection）。如果你进入设置，可以为任何转出 Revolut 的操作设置限额。如果你想进行超过限额的转账，必须进行自拍验证。这是我们的专利技术，需要进行视频自拍。这能确保是你本人在操作，而不是别人。它的体验几乎和 Face ID 一样流畅，团队做得非常棒，我为他们感到骄傲。

---

### [01:08:38] Lenny Rachitsky

**English:**
Dmitry, you guys are doing something very special. I really appreciate you spending so much time with me chatting through all the things you guys have figured out. I think this is going to help a lot of different companies level up the way they think about product and for people to join Revolut that want to experience this and accelerate their career. So thank you for being here. Two final questions. Where can folks find you if they want to reach out and how can listeners be useful to you?

**中文翻译:**
Dmitry，你们正在做一些非常特别的事情。非常感谢你花这么多时间和我分享你们的心得。我想这会帮助很多公司提升对产品的思考，也会吸引更多想加速职业发展的人加入 Revolut。谢谢你的到来。最后两个问题：如果大家想联系你，可以在哪里找到你？听众能为你做些什么？

---

### [01:08:59] Dmitry Zlokazov

**English:**
I think the best way is to find me on LinkedIn and yeah, I would be happy to receive a note from anyone on how we can improve the product and any feedback on the product. And also if you know someone who can be a great fit to Revolut after you've listened to what I've told, then yeah, I would be grateful for that as well.

**中文翻译:**
我想最好的方式是在 LinkedIn 上找我。我很乐意收到关于如何改进产品或任何产品反馈的建议。另外，如果你听完我的分享后，觉得身边有非常适合 Revolut 的人才，我也将不胜感激。

---

### [01:09:26] Lenny Rachitsky

**English:**
Awesome. You're about to get a flood of applications. Get prepared. Dmitry, thank you.

**中文翻译:**
太棒了。你可能要收到一大波申请了，做好准备。Dmitry，谢谢你。

---

### [01:09:32] Dmitry Zlokazov

**English:**
Yeah, Lenny, thanks a lot. It was amazing time. Thank you very much.

**中文翻译:**
谢谢 Lenny，这段时间很愉快。非常感谢。

---

### [01:09:35] Lenny Rachitsky

**English:**
Same. Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
我也是。大家再见。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。另外，请考虑给我们评分或留下评论，这能帮助更多听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。