# Donna Lichaw - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Donna Lichaw.

---

### [00:00:00] Donna Lichaw

**English:**
When superheroes discover what their superpowers actually are, they wreak havoc and they make a mess, and it's uncomfortable. And even Superman tries to get rid of his superpowers. It's hard to know what you're really great at.

**中文翻译:**
当超级英雄发现他们真正的超能力时，他们往往会造成破坏，搞得一团糟，而且过程非常令人不适。甚至连超人都曾试图摆脱他的超能力。想要知道自己真正擅长什么其实很难。

---

### [00:00:13] Lenny

**English:**
How does somebody identify their superpowers, their strengths?

**中文翻译:**
一个人该如何识别自己的超能力和优势呢？

---

### [00:00:17] Donna Lichaw

**English:**
Pull your superpowers out of your stories from your past, your present, and then eventually figure out how to apply them and transpose them to your future.

**中文翻译:**
从你过去和现在的经历（故事）中挖掘出你的超能力，然后最终弄清楚如何应用它们，并将它们迁移到你的未来。

---

### [00:00:27] Lenny

**English:**
The person's story; this is central to becoming a better leader.

**中文翻译:**
个人的故事；这是成为一名更优秀领导者的核心。

---

### [00:00:31] Donna Lichaw

**English:**
The most effective stories are the ones that we tell ourselves. They may or may not be true; our brain doesn't know the difference. Once you can really understand that, you may as well leverage it to be that hero.

**中文翻译:**
最有效的故事是我们讲给自己的那些。它们可能是真的，也可能不是；我们的大脑分辨不出其中的区别。一旦你真正理解了这一点，你大可以利用它让自己成为那个英雄。

---

### [00:00:46] Lenny

**English:**
Today my guest is Donna Lichaw. Donna is an executive coach, speaker and bestselling author. She helps founders, CEOs and executive teams level up their leadership skills and scale their impact while staying true to their mission, their purpose and themselves. Donna has worked with leaders at companies like Google, Disney, Twitter, Microsoft and Adobe, and she's also the author of the book, The Leader's Journey, which is what we spend our time on.

**中文翻译:**
今天的嘉宾是 Donna Lichaw。Donna 是一位高管教练、演讲家和畅销书作家。她帮助创始人、CEO 和高管团队提升领导技能并扩大影响力，同时让他们能够忠于自己的使命、目标和自我。Donna 曾与谷歌、迪士尼、推特、微软和 Adobe 等公司的领导者合作，她也是《领导者的旅程》（The Leader's Journey）一书的作者，这也是我们今天讨论的重点。

**(00:01:12):**
**English:**
In our conversation, we talk about why the story that we tell ourselves has so much impact on our success and failure, why knowing your superpowers and also your kryptonite is so important to your career and how to identify these two things, how to reframe your feelings of imposter syndrome and actually use it as an advantage, how to identify your life goals even if you have no idea what they might be, plus a ton of examples from her coaching practice of people unlocking their career using her frameworks and how they went about doing this and so much more. If you enjoy this podcast, don't forget to subscribe and follow this podcast on your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes, and it helps the podcast tremendously. With that, I bring you Donna Lichaw after a short word from our sponsors.

**中文翻译:**
在对话中，我们讨论了为什么我们讲给自己的故事对成败有如此大的影响；为什么了解你的“超能力”以及你的“氪石”（弱点）对职业生涯至关重要，以及如何识别这两者；如何重构你的“冒充者综合征”并将其转化为优势；即使你现在毫无头绪，该如何确定人生目标；此外还有大量来自她教练实践的案例，讲述人们如何利用她的框架开启职业生涯新局面。如果你喜欢这个播客，请不要忘记在应用或 YouTube 上订阅。这是避免错过后续节目的最好方式，也对我们很有帮助。在赞助商广告之后，让我们欢迎 Donna Lichaw。

---

### [00:02:01] Lenny (Sponsor Message)

**English:**
Today's episode is brought to you by OneSchema, the embeddable CSV importer for SaaS... [Ad content omitted for brevity but follows the same pattern if required]

**中文翻译:**
本集节目由 OneSchema 赞助，它是为 SaaS 提供的可嵌入式 CSV 导入工具……（此处为 OneSchema 广告内容，主要介绍其处理杂乱 CSV 数据的功能，为播客听众提供 1000 美元折扣）。

---

### [00:03:07] Lenny (Sponsor Message)

**English:**
Let me tell you about our product called Sendbird, the all-in-one communications API platform... [Ad content omitted for brevity]

**中文翻译:**
让我向你介绍 Sendbird，这是一个全方位的通信 API 平台……（此处为 Sendbird 广告内容，介绍其在应用内通信、AI 聊天机器人等方面的功能）。

---

### [00:04:29] Donna Lichaw

**English:**
Thanks, Lenny. It's exciting to be here.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。

---

### [00:04:31] Lenny

**English:**
We connected through a former colleague of mine who could not stop raving about how much value she got from working with you. Also, you have a new book app right here that I have, The Leader's journey, and so I thought it would be awesome to bring you on and share your wisdom with a wider audience.

**中文翻译:**
我们是通过我的一位前同事联系上的，她对我赞不绝口，说从你那里受益匪浅。而且，你出了一本新书《领导者的旅程》，我就在我手里，所以我认为邀请你来向更广泛的听众分享你的智慧是非常棒的主意。

---

### [00:04:50] Donna Lichaw

**English:**
Love the podcast. My clients love your stuff and newsletter, everything.

**中文翻译:**
我很喜欢这个播客。我的客户也很喜欢你的内容和时事通讯，以及所有的一切。

---

### [00:04:54] Lenny

**English:**
[inaudible 00:04:54].

**中文翻译:**
（不清晰）。

---

### [00:04:54] Donna Lichaw

**English:**
Very excited to be here.

**中文翻译:**
非常兴奋能来到这里。

---

### [00:04:55] Lenny

**English:**
Amazing. And congrats on the book, by the way.

**中文翻译:**
太棒了。顺便祝贺你的新书出版。

---

### [00:04:58] Donna Lichaw

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:05:00] Lenny

**English:**
You actually were a product manager in a previous life. You're also a designer in a previous life. These days you're an executive coach. Just briefly, I'm curious what pulled you from product management design and the things you did before this life into executive coaching. And maybe another way to ask this question is what's your origin story? And this is a little foreshadowing to the stuff we're going to be talking about later.

**中文翻译:**
你以前其实做过产品经理，也做过设计师。现在你是一名高管教练。简单来说，我很想知道是什么把你从产品管理、设计以及之前的工作中吸引到了高管教练这个领域？或者换种问法，你的“起源故事”是什么？这也算是为我们稍后要讨论的内容做个铺垫。

---

### [00:05:25] Donna Lichaw

**English:**
Actually, it's funny, like all origin stories, there were actually multiple episodes, multiple moments that led me to an epiphany, but the biggest aha moment was when I was working several years ago, almost a decade ago at this point, with an executive team in Silicon Valley. And we were at a leadership retreat, and we were supposed to... At the time, I was a program on effective product leadership, how to be a great product leader, product executive. And the biggest thing that companies wanted at the time and teams wanted was their teams to be better storytellers. And it's still something we hear today, which is, "To be a great product leader or leader in general in any industry is you got to be a great storyteller." And so at the time, I was teaching and facilitating storytelling workshops and exploring that with teams. And it was a few people on this team specifically who I so appreciate their honesty and candor here, which is what this giant tech company is known for, very blunt people working there. And they pulled me aside halfway through the offsite, and they were just like, "Honestly, storytelling is not going to fix our problems. This is silly."

**中文翻译:**
事实上，很有趣，就像所有的起源故事一样，其实是有多个片段、多个时刻引导我走向顿悟的。但最大的“啊哈时刻”发生在几年前，现在算起来快十年了，当时我正与硅谷的一个高管团队合作。我们在参加一个领导力静修营，当时我负责一个关于有效产品领导力的项目，教大家如何成为优秀的产品领导者或高管。当时公司和团队最想要的是让他们的团队成员成为更好的“讲故事的人”。直到今天我们仍能听到这种说法：“要在任何行业成为一名优秀的产品领导者或通用领导者，你必须是一个讲故事的高手。”所以当时我正在主持讲故事工作坊。这个团队中有几个人非常诚实坦率（这也是那家科技巨头的文化，员工说话很直接），他们在团建中途把我拉到一边说：“老实说，讲故事解决不了我们的问题。这太傻了。”

**(00:06:56):**
**English:**
And what they were able to tell me is that their leaders wanted them to be more effective by having greater influence. And these are terms that we throw around all the time. Be more influential and be a better leader, whatever that means. And what was happening on the ground with these executives was that they were all fighting. I'd hear, "Oh, the head of engineering is such a jerk," or, "This person won't listen to me," or, "My team is demotivated. And I get it, but they need to step up and work more." And there was just a lot of conflict going on here and there that storytelling wouldn't fix. When that happens, and I talk about this in the book a bunch, no one wants to hear your stories. You have to actually be able to connect with people and to work with people and feel good as a leader in order to really step up and lead. I didn't have an answer for this team at the time, and I left this offsite just honestly feeling terrible and not knowing what to do about it except telling them, "I think you got to go work with a coach because this is beyond my pay grade."

**中文翻译:**
他们告诉我，他们的领导希望他们通过拥有更大的影响力来变得更有效率。这些都是我们经常挂在嘴边的词：更有影响力、成为更好的领导者，不管那到底意味着什么。但这些高管实际面临的情况是，他们一直在内斗。我会听到：“工程主管真是个混蛋，”或者“这个人不听我的，”或者“我的团队没有动力。我理解，但他们需要振作起来多干活。”到处都是冲突，而讲故事解决不了这些。当这种情况发生时（我在书里也多次提到），没人想听你的故事。你必须能够真正与人建立联系、与人合作，并且作为领导者感觉良好，才能真正站出来领导。当时我给不了这个团队答案，离开时我感觉糟透了，不知道该怎么办，只能告诉他们：“我觉得你们得去找个教练，因为这超出了我的能力范围。”

**(00:08:05):**
**English:**
But when I left that day, I just couldn't stop thinking about this team because I had a hunch that stories were still a part of something but not what they needed. Telling stories was not the answer, and so I ended up spending what now is the next decade figuring out, all right, how do you become an effective leader? And of course because I can't do anything lightly, once I went down that path, I ended up switching up my entire business. And now that's all I do is help people be better, more effective, confident leaders who really make the impact that they want to make.

**中文翻译:**
但我离开那天，脑子里一直停不下来想这个团队，因为我有一种直觉：故事仍然是某些东西的一部分，但不是他们表现出来的这种需求。向别人“讲故事”不是答案。于是我花了接下来的十年时间去弄清楚：好吧，你到底如何成为一名有效的领导者？当然，因为我做事从不马虎，一旦走上这条路，我最终改变了我的整个业务方向。现在我所做的一切就是帮助人们成为更好、更有效、更自信的领导者，真正产生他们想要的影响力。

---

### [00:08:39] Lenny

**English:**
Along those same lines, what's interesting is you actually found that this idea of storytelling was actually much more effective in your coaching practice. Instead of helping them figure out the story of the product, it's the story of the person. And so transitioning into the meat of your approach to coaching, I think you call it story-driven leadership. Essentially, your finding is that story and the person's story is extremely important and powerful in helping them level up as a leader and also seeing them as the hero of their story. I guess just with that foundation, can you just talk about why that is so powerful, the idea of figuring out your own story and why you need to be the hero of your own story and just what all this means?

**中文翻译:**
顺着这个思路，有趣的是你发现“讲故事”这个概念在你的教练实践中其实更有效。不是帮他们构思产品的故事，而是构思“人”的故事。进入你教练方法的核心，我想你称之为“故事驱动的领导力”。本质上，你的发现是：故事，尤其是个人的故事，在帮助他们提升领导力、让他们把自己视为故事中的英雄方面，是非常重要且强大的。基于这个基础，你能谈谈为什么理清自己的故事如此强大吗？为什么我们需要成为自己故事中的英雄？这一切意味着什么？

---

### [00:09:21] Donna Lichaw

**English:**
We all as humans want to be the hero of our own story. It's how we live our lives, it's how we make choices, it's how we understand the world around us, and it's how we communicate back to the world. With leadership, it's much the same, which is we have a mission that we want to accomplish. No matter how big or small, it's something; we're driven to do something. If you're a leader, you want to be a leader. You have to be taking yourself and you have to be taking people somewhere.

**中文翻译:**
作为人类，我们都想成为自己故事中的英雄。这是我们生活的方式，是我们做选择的方式，是我们理解周围世界的方式，也是我们向世界传达信息的方式。对于领导力来说，情况大同小异：我们都有想要完成的使命。无论大小，总有目标；我们被驱动去做某事。如果你是一名领导者，你想成为领导者，你就必须带着你自己，也带着其他人走向某个地方。

**(00:09:55):**
**English:**
We also have obstacles, so that's a part of any great story. There are challenges. It shouldn't be easy. It shouldn't be so hard that you fail, that's a tragedy, but there are challenges, and it makes life more exciting. You don't do it alone. It's rare that a story just has a single individual. It happens, but that's not most of life. And there are other elements that I ended up uncovering when I looked deeper into what makes the most effective leaders effective, and the biggest thing is stories that we tell people, it's like the tip of the iceberg. And if anything, it even doesn't matter, I've worked with a lot of folks who their teams say, "Stop it with the storytelling. Stop talking at us." And they don't want any of that.

**中文翻译:**
我们也会遇到障碍，这是任何伟大故事的一部分。会有挑战。它不应该是容易的。它不应该难到让你失败（那是悲剧），但挑战让生活更精彩。你不是一个人在战斗。故事里很少只有一个个体。虽然有这种情况，但那不是生活的大部分。当我深入研究是什么让最高效的领导者变得高效时，我发现了其他元素。最重要的一点是：我们讲给别人的故事只是冰山一角。甚至在某些情况下，这根本不重要。我合作过很多人，他们的团队会说：“别再讲故事了，别再对着我们说教了。”他们根本不想要那些。

**(00:10:43):**
**English:**
But the most effective stories are the ones that we experience as we live life and that we tell ourselves as well because we have the ability by saying things like, "Oh, I'll never succeed," or, "Oh, she'll never go for it," or, "He's such a jerk." Or whatever the stories are, these are all stories. And they may or may not be true, they're usually not true, but our brain doesn't know the difference. It's the most powerful ability our brain has is to understand and see stories everywhere. And so once you can really understand that, you may as well leverage it to be that hero in your life. And even as I say it out loud, it sounds so cheesy, but it's true. This is neuroscience and psychology. We just want to be the heroes, and that's what our focus is.

**中文翻译:**
但最有效的故事是我们生活中的经历，以及我们“讲给自己听”的故事。因为我们有能力通过说“哦，我永远不会成功”或“她永远不会同意”或“他真是个混蛋”来构建叙事。无论是什么，这些都是故事。它们可能是真的，也可能不是（通常不是真的），但我们的大脑分不清区别。大脑最强大的能力就是理解并在各处看到故事。一旦你真正理解了这一点，你大可以利用它成为你生活中的英雄。虽然大声说出来听起来很俗气，但这是事实。这是神经科学和心理学。我们只想成为英雄，这就是我们的重点。

---

### [00:11:36] Lenny

**English:**
I want to delve deeper into that idea there. People listening to this might feel like, "Okay, cool, let me think about the story of my life. This sounds like a fun thing I could do." But I think your point is this is central to becoming a better leader, figuring out the story of you and that changing in your perspective on yourself and giving you more... Unblocking you I think is a big part of it. Can you just talk about more just the power and why this is so important? Because it not just like, "Cool, I'll sit around and think about, oh, here's my story. I was born here, I did this thing." Why is this so important to do?

**中文翻译:**
我想深入探讨一下。听众可能会觉得：“好吧，酷，让我思考一下我的人生故事。这听起来是件有趣的事。”但我认为你的观点是，理清“你的故事”是成为更好领导者的核心，这会改变你对自己的看法，并给你更多……我认为“解除自我屏蔽”是其中的重要部分。你能多谈谈这种力量以及为什么它如此重要吗？因为它不仅仅是“酷，我坐下来想想，哦，这是我的故事，我出生在这里，我做了那件事”。为什么做这件事如此重要？

---

### [00:12:12] Donna Lichaw

**English:**
And it's a little antithetical in a way because it goes against what a lot of us believe, especially if we have I'll say product backgrounds or just business backgrounds or tech backgrounds or anything where we've built things for people. For years, we've had this idea that we build companies in a user-centered way where, all right, build for the customer first and all else will follow. And there's some truth to that on the one hand. And I used to think leadership was the same, which is, well, it's not about you as a leader, it's about who are you bringing along on your journey? And how do they need to be heroes? So how do you enable everyone you work with and everyone you want to follow you to join you and feel amazing with it? That's the user-centered approach where it's not about you, it's about who you're bringing with you and the impact you want to make.

**中文翻译:**
在某种程度上，这有点反直觉，因为它违背了我们许多人的信念，特别是如果我们有产品背景、商业背景或技术背景，或者任何为他人构建事物的背景。多年来，我们一直秉持“以用户为中心”的理念：先为客户构建，其他一切都会随之而来。一方面，这确实有道理。我以前也认为领导力是一样的，即：领导力与你个人无关，而在于你带谁一起上路？他们如何成为英雄？你如何赋能与你共事的每个人，让想追随你的人加入你并感到棒极了？这就是以用户为中心的方法，核心不是你，而是你带领的人和你想要产生的影响。

**(00:13:13):**
**English:**
But what I learned is that it doesn't work that way. And you need to flip that, which is when you start with you first at the center of the equation, and then I'm going to do... Everything for me is a diagram. I'm thinking of concentric circles. Ken Blanchard has a great model for this where you start with you, it's the inner circle, then you are able to lead yourself, then you can lead others. It extends to one-on-one relationships. Then once you've got that, you're able to lead groups, teams, and then outward towards the business.

**中文翻译:**
但我学到的是，现实并非如此。你需要反转过来：当你把“你”放在等式的中心开始。对我来说，一切都是图表，我想到的是同心圆。肯·布兰查德（Ken Blanchard）有一个很好的模型：从你开始，这是内圆，然后你能够领导自己，接着你才能领导他人。这延伸到一对一的关系。一旦你掌握了这一点，你就能领导小组、团队，然后向外扩展到整个业务。

**(00:14:00):**
**English:**
When you figure that out and you come from the inside out, it's much, much more powerful because it's not selfish like I would've thought years ago, but it's purposeful. You, as human, we all are driven by a mission, by purpose, by a reason for what we do. And when we're able to have that power us, it then empowers us to connect with others so that we can bring it to life. And especially in a business context, but this is the case in anything, communities and family, but especially in business. It has to start with you. You need fuel from somewhere. And if it comes from without, it's like an eggshell that's just ready to crack. It's not sustainable if it comes from outside.

**中文翻译:**
当你弄清楚这一点并由内而外地散发力量时，它会变得非常强大。这不像我多年前认为的那样是自私，而是“有目的性”的。作为人类，我们都被使命、目标和做事的理由所驱动。当我们能够拥有这种驱动力时，它就会赋予我们与他人建立联系的能力，从而将目标变为现实。特别是在商业环境中（其实在社区、家庭中也是如此），必须从你开始。你需要动力燃料。如果燃料来自外部，它就像一个随时会破裂的蛋壳。如果动力完全来自外部，那是不可持续的。

---

### [00:14:49] Lenny

**English:**
Can you give an example of someone you worked with that changed their story and what impact it had on their career to make this even more real?

**中文翻译:**
你能举个例子吗？比如你合作过的某个人改变了他们的故事，以及这对他们的职业生涯产生了什么影响，让这个概念更具体一些？

---

### [00:14:58] Donna Lichaw

**English:**
I can think of a CEO I worked with a few years ago who on the outside was so put together. He was the CEO of a billion-dollar company, successful, raised money like no one's business, was able to get people excited about what he was building, join him. And when we started working together, he had recently hired members of an executive team that were just superstars from Silicon Valley and just incredible. And they were so excited to work with him. He was so excited to work with them as well.

**中文翻译:**
我想起几年前合作过的一位 CEO，从外表看他非常完美。他是一家估值十亿美元公司的 CEO，非常成功，融资能力极强，能让人们对他正在构建的事物感到兴奋并加入他。当我们开始合作时，他刚聘请了几位高管团队成员，他们都是硅谷的超级明星，非常出色。他们很兴奋能和他共事，他也同样兴奋。

**(00:15:42):**
**English:**
But on the inside, the story he kept telling himself was he's too nice. Nobody listens to him was another story. "People don't take me seriously," was another story. And then there were what I call horror stories. This is not a scientific term by any means, but horror stories that he told himself were things like, "We're never going to make it," or, "They're never going to listen to me," or, "I'll never learn to be a real CEO. And the problem with stories like that is they end up taking over your identity, they shadow and cloud your every day and actions you take and interactions you have with people. And when you focus on them so much, they very well will become true. That's one example. I could tell you a little more about that, what we did about it.

**中文翻译:**
但在内心深处，他一直告诉自己的故事是：他“太友善了”。另一个故事是“没人听他的”。还有“人们不把我当回事”。然后还有我所谓的“恐怖故事”（这绝不是科学术语），他告诉自己的恐怖故事包括：“我们永远不会成功，”或者“他们永远不会听我的，”或者“我永远学不会如何成为一名真正的 CEO”。这类故事的问题在于，它们最终会占据你的身份认知，给你的每一天、你的行动以及你与人的互动蒙上阴影。当你如此关注它们时，它们很可能真的会变成现实。这是一个例子，我可以多讲讲我们是怎么处理的。

---

### [00:16:45] Lenny

**English:**
Yeah, that's exactly what I was going to ask. Yeah, if you could share what you did to help shift his story, and then also just how do people do this for themselves?

**中文翻译:**
是的，这正是我要问的。如果你能分享一下你做了什么来帮助他转变故事，以及人们如何为自己做这件事？

---

### [00:16:55] Donna Lichaw

**English:**
Perfect. In this case... And this is like everyone I work with. And this is absolutely something that everyone listening and everyone in the audience can absolutely do is take a data-driven approach to the stories that you tell yourself. For example, the story, "I'm too nice," it could be true, it could not be true. How did we get down to the bottom of that? In this case, what we did is I went out there and talked to his team. And this is something you can do for yourself as well. If you're extremely busy, you can have someone else do it for you. And I found out how people actually experienced him and his leadership. And I didn't hear he's too nice, I heard he is so heartfelt and so caring. And that's a really cool thing. How rare is that to hear about a CEO, especially a founder? Oftentimes you hear the opposite, which is not really true. Usually when founders are not nice people, they're insecurity's at play. But in this case, yeah, people were like, "We love him. He's wonderful. That's why he recruited us." And so great, all right, validated and a little debunked. Really nice, but not too nice. That was not a problem for anyone.

**中文翻译:**
太好了。在这个案例中……就像我合作过的所有人一样。这也是每一位听众绝对可以做到的：对你讲给自己的故事采取“数据驱动”的方法。例如，“我太友善了”这个故事，可能是真的，也可能不是。我们如何查明真相？在这种情况下，我去找了他的团队谈话。你也可以为自己做这件事，如果你太忙，可以请别人代劳。我了解了人们实际上是如何感受他和他的领导力的。我没听到有人说他“太友善”，我听到的是他“非常真诚且充满关怀”。这是一件很酷的事情。听到对一位 CEO，尤其是创始人的这种评价是多么罕见？通常你听到的是相反的评价。通常当创始人表现得不友善时，其实是自卑感在作祟。但在这种情况下，人们说：“我们爱他。他很棒。这就是他能招募到我们的原因。”所以，很好，验证了事实，也拆穿了那个负面故事。他确实很友善，但并非“太友善”。这对任何人来说都不是问题。

**(00:18:31):**
**English:**
Then we'd hear things like... Okay, one story he told himself was, "People don't take me seriously. They don't listen to me. What's going on? I need to command respect and they need to just do what I say." And I hear this all the time. I'm using this one example, but this could be anyone that I've worked with. And what we heard from people instead was it's not that they weren't listening to him, but when you're hiring super senior, whip smart executives to work for you, they don't want to be told what to do, they want to have a grand vision that they're excited about, they want maybe some goals to latch onto and help possibly with a strategy to get there, although probably they can got the strategy all on their own. And they want to then show you how they can help you and the business meet your goals and align towards that vision so that you can build the company that you want to build.

**中文翻译:**
然后我们听到……好吧，他告诉自己的一个故事是：“人们不把我当回事。他们不听我的。怎么回事？我需要赢得尊重，他们只需要按我说的做。”我经常听到这种话。虽然我用的是这个例子，但这可能是我合作过的任何人。而我们从员工那里听到的是：并不是他们不听他的，而是当你聘请超级资深、极其聪明的高管为你工作时，他们不想被告知该做什么。他们想要一个让他们兴奋的宏伟愿景，他们可能想要一些可以挂钩的目标，并可能在实现目标的策略上提供帮助（尽管他们可能自己就能搞定策略）。他们想向你展示他们如何帮助你和公司实现目标，并向那个愿景靠拢，这样你就能建立你想建立的公司。

**(00:19:35):**
**English:**
That story, "No one listens to me," it was the wrong story to be telling. What the actual story was is that people wanted him out of their business and wanted to feel empowered doing their C-level and super senior executive level work. "But we don't want him to be absent because when he does that, it doesn't work. And it's very frustrating when he just disappears for two weeks. So we need him involved, but want him to give us problems to solve. Give us a vision, give us problems to solve and let us do it for you."

**中文翻译:**
所以“没人听我的”这个故事是错误的叙事。真实的故事是：人们希望他不要插手具体业务，希望在做 C 级和资深高管工作时感到被赋能。“但我们不希望他缺席，因为当他缺席时，事情就乱套了。当他突然消失两周时，非常令人沮丧。所以我们需要他参与，但希望他给我们‘问题’去解决。给我们愿景，给我们问题，让我们为你完成它。”

**(00:20:10):**
**English:**
And so they were able to write a better ending of that story together. It was exactly like user research of any kind or customer discovery, which is you find out what could be possible from your customers and then ideally you co-create a better ending together. If you're building products or services, that's how you do it. If you're a leader, you do it by showing up and helping others do what they need to do in a way that feels good for you and that aligns with how you want to be doing things.

**中文翻译:**
于是，他们能够共同为那个故事写下一个更好的结局。这完全就像任何形式的用户研究或客户发现：你从客户那里了解可能性，然后理想情况下，你们共同创造一个更好的结局。如果你在构建产品或服务，你就是这么做的。如果你是一名领导者，你通过出现并以一种让你感觉良好、且符合你做事方式的方法来帮助他人完成他们需要做的事情。

**(00:20:44):**
**English:**
And so this is one example, but I find using real research and data and actually talking to people is most effective. There are other ways to take best guesses, and I'll use the product metaphor again, which is you can try things and experiment and then see how it works and not talk to your users, but you should probably talk to your customers, in other words, your colleagues and everyone who works for you, and really find out what is the true story and what is possible.

**中文翻译:**
这只是一个例子，但我发现使用真实的研究、数据并实际与人交谈是最有效的。当然还有其他做“最佳猜测”的方法，我再用一下产品比喻：你可以尝试和实验，看看效果如何，而不去和用户交谈，但你最好还是和你的“客户”谈谈——换句话说，就是你的同事和为你工作的每个人——真正找出真实的故事是什么，以及什么是可能的。

---

### [00:21:19] Lenny

**English:**
There's all these stories that people believe about themselves, and to your point, many of them are not true when you actually look at the data, you talk to your customers, AKA your colleagues. I imagine many are actually true or there are feedback you get that is like, "You are not clear enough about stuff," there's things that you actually hear from other people. Does this approach help there as well? Or is there a different tactic for something's actually, okay, you are actually too nice. It's not just a story in your head?

**中文翻译:**
人们对自己有很多信念，正如你所说，当你查看数据、与“客户”（即同事）交谈时，其中许多都不是真的。但我猜想，有些可能确实是真的，或者你会收到反馈说“你对事情交代得不够清楚”，这些是你确实从别人那里听到的。这种方法在这些情况下也有帮助吗？或者对于那些“确实是真的”的事情（比如你确实太友善了，而不仅仅是你脑子里的故事），是否有不同的策略？

---

### [00:21:48] Donna Lichaw

**English:**
Absolutely. There are times when the stories that we tell ourselves are true. And when we go out and find out what's possible, it is something that we're doing that needs to change or isn't working. And so one example is, and this comes up sometimes as well, one executive who I worked with once kept getting this feedback that she was too quiet. And when we went out and got feedback, it was true. People were like, "She needs to speak up more." And this is becoming a problem because she was so quiet that her team thought she was not interested in them. And she would just sit back in meetings, not say anything, and they were like, "God, she sucks. This is the worst boss ever. I don't even want to be at this meeting. And why is she here? Why am I here?" And it really was detrimental to them all working together.

**中文翻译:**
绝对有。有时候我们讲给自己的故事是真的。当我们去了解可能性时，发现确实是我们正在做的某些事情需要改变，或者某些事情行不通。举个例子，这有时也会发生：我合作过的一位高管一直收到反馈说她“太安静了”。当我们去收集反馈时，发现这是真的。人们说：“她需要多发言。”这成了一个问题，因为她太安静了，以至于她的团队认为她对他们不感兴趣。她在会议上只是坐着，什么也不说，团队成员会想：“天哪，她真差劲。这是有史以来最糟糕的老板。我甚至不想参加这个会议。她为什么在这？我为什么在这？”这确实损害了他们的协作。

**(00:22:57):**
**English:**
And then she was frustrated because she was always wondering, well, why are they not performing? They're not stepping up. And so it was frustrating all along. And it was true, as far as they saw it, her not speaking up was the problem. But when we got down to the bottom of what was really going on for her and not speaking up at these meetings is she was just listening. Her processing style was she had to listen, and then maybe a few hours later she'd have thoughts. And so even though the team said, "We do want her to participate," what they really needed to know was it didn't have to do with speaking or not speaking, what they really needed from her was to know that she was listening to them and that she actually heard them and was going to do something about it, and that she was quiet in these meetings, she was not checked out. And so simple solution for that, she could start trying to yell more and talk over people and be obnoxious, but nobody wants that either, and so she just started communicating with them more about, "Hey, this is my style. I'm a little slower. I often need a couple hours to really process things. I'm here, and I want you to know that."

**中文翻译:**
而她也很沮丧，因为她总在想：为什么他们表现不好？他们没有进步。所以双方一直都很沮丧。在团队看来，她不发言确实是问题所在。但当我们深入探究她为什么在会议上不发言时，发现她只是在倾听。她的处理风格是必须先听，可能几个小时后才会有想法。所以，尽管团队说“我们确实希望她参与”，但他们真正需要知道的并不是她“说不说话”，而是需要知道她正在听他们说话，她确实听进去了并会采取行动，她在会议上安静并不代表她“心不在焉”。所以简单的解决方案是：她可以尝试多喊叫、打断别人、变得招人烦，但没人想要那样。于是她开始更多地与他们沟通：“嘿，这是我的风格。我反应慢一点。我通常需要几个小时来真正处理事情。我在这里听着，我想让你们知道这一点。”

**(00:24:12):**
**English:**
The irony of establishing those lines of communication with your team when they're not getting what they need is that you often end up doing the thing that you've been trying to do but failing to do anyway. Because she ended up talking more with her team just in communicating with them about her style, and then they started communicating their styles with her and with each other. And this is something that, it's not in the book, but you might've heard of this idea of a personal OS that a lot of us like to have, which is, "Hey, these are my work styles. This is how I process, this is how I do things. These are great ways to work with me, and here's how I'd love to work with you." And they ended up doing a lot of that, and worked out really well. But it was true, she was not speaking up, and it was having a detrimental effect. But the answer was not talking more, it actually was listening more and just having a better relationship with people.

**中文翻译:**
讽刺的是，当你与团队建立沟通渠道（当他们没有得到所需的东西时）时，你最终往往做到了你一直想做但没做成的事。因为为了沟通她的风格，她最终和团队谈得更多了，然后他们也开始向她以及彼此沟通各自的风格。这在书里没写，但你可能听说过“个人操作系统”（Personal OS）的概念，很多人喜欢这个：“嘿，这是我的工作风格。这是我处理信息的方式，这是我做事的方式。这些是与我合作的好方法，这是我希望与你们合作的方式。”他们最终做了很多这样的尝试，效果非常好。所以，虽然她确实不怎么发言并产生了负面影响，但答案不是“多说话”，而是“更好地倾听”并与人建立更好的关系。

---

### [00:25:09] Lenny

**English:**
That's an awesome example. By the way, on the personal OS, an another term for that I've heard is README, like your own personal README file.

**中文翻译:**
这是一个很棒的例子。顺便说一下，关于“个人操作系统”，我听过的另一个术语是“README”，就像你个人的 README 文件一样。

---

### [00:25:15] Donna Lichaw

**English:**
Oh, I like that too.

**中文翻译:**
哦，我也喜欢那个说法。

---

### [00:25:17] Lenny

**English:**
Yeah, isn't that great? It sounds like there's these two buckets, it's probably more buckets, but one is a story of yourself that is not true that you can disprove by looking at data, talking to people, and then there's almost a story people have about you that they don't quite get what's going on. And then you could change their story by communicating, "Here's what I'm really doing. I'm actually just listening and I'm actually really deeply paying attention."

**中文翻译:**
是的，很棒吧？听起来主要有两个范畴（可能更多）：一个是关于你自己的不真实的故事，你可以通过查看数据、与人交谈来证伪；另一个是别人对你的看法（故事），他们不太明白发生了什么，然后你可以通过沟通来改变他们的看法：“这就是我真正在做的。我其实只是在倾听，而且我真的在深度关注。”

**(00:25:41):**
**English:**
If we pick an example, say imposter syndrome, which comes up a lot on this podcast where people feel like, "I am an imposter in this role. I have no idea what I'm doing. It's all going to crumble if I mess up." Say someone has that in their head, everyone can tell I am an imposter and it'll all crumble. How would you recommend someone that this is real or not to understand is this a story in my head or is this real? And what do people actually think? Do you go talk to people? How do you recommend people go about that?

**中文翻译:**
如果我们举个例子，比如“冒充者综合征”，这在播客中经常出现，人们觉得：“我担任这个角色是个冒牌货。我根本不知道自己在做什么。如果我搞砸了，一切都会崩溃。”假设有人脑子里有这种想法：每个人都能看出我是个冒牌货，一切都会完蛋。你会如何建议某人去判断这是真是假？去理解这是我脑子里的故事还是现实？人们到底是怎么想的？你去和人谈谈吗？你建议人们怎么做？

---

### [00:26:15] Donna Lichaw

**English:**
Certain stories we tell ourselves are actually quite functional and do not necessarily need to be rewritten. Imposter syndrome for an example, if you're going around saying, "I feel like I'm an imposter. I can't believe I'm doing this," you can try to fake it till you make it, you can try to... I always think of... I'm totally dating myself here, but Stuart Smalley in Saturday Night Live in the '80s and '90s, he would look in a mirror and do his affirmations and say, "I'm smart, and I'm whatever." And Doug-

**中文翻译:**
我们讲给自己的某些故事实际上是很有“功能性”的，不一定需要重写。以冒充者综合征为例，如果你到处说“我觉得自己是个冒牌货，我不敢相信我在做这件事”，你可以尝试“弄假直到成真”（fake it till you make it），你可以尝试……我总是想到（这暴露了我的年龄）80、90 年代《周六夜现场》里的 Stuart Smalley，他会对着镜子做自我肯定，说“我很聪明，我很……”

---

### [00:27:00] Lenny

**English:**
I'm good enough, I'm strong enough, and gosh darn it, people like me or love me.

**中文翻译:**
“我足够好，我足够强大，而且该死的，人们喜欢我或爱我。”

---

### [00:27:08] Donna Lichaw

**English:**
There you go. It's like you could do that, and it's all very mechanical, and there's ways to prop yourself up, but what if you took a counter-intuitive approach and looked at that story, I'm an imposter, and instead asked, "Okay, that's a good story. How is that serving you?" Imposter syndrome, it's something everyone has at one point or another. When we default to these behaviors of, "Oh God, I'm an imposter. Okay," over and over and over again, I know it doesn't feel good, but we default to that because it's serving us in one way, otherwise it wouldn't become a habit. And I always think of habits as an itch. If you have an itch, you scratch it, you feel better. There's a reason why we scratch itches; it feels better. If you do it too much, it hurts.

**中文翻译:**
没错。你可以那样做，但这非常机械。虽然有办法支撑自己，但如果你采取一种反直觉的方法，审视“我是个冒牌货”这个故事，转而问：“好吧，这是个不错的故事。它对你有什么好处（它是如何为你服务的）？”冒充者综合征是每个人在某个时刻都会有的感觉。当我们一遍又一遍地陷入“天哪，我是个冒牌货”这种行为模式时，我知道这感觉不好，但我们之所以陷入其中，是因为它在某种程度上对我们有用，否则它不会变成一种习惯。我总是把习惯比作发痒。如果你觉得痒，你就去抓，抓了就舒服了。我们抓痒是有原因的：它让你感觉好点。但如果你抓得太厉害，就会疼。

**(00:28:09):**
**English:**
And something like that, telling detrimental stories, have that impact. But when you can intercept them at just the right time and say, "Okay, what if that is true? How does it serve me to constantly say, 'I'm an imposter whenever anything gets hard?'" One co-founder I worked with a while back, she did this whenever things got too hard. And then she was convinced, and founders have this a lot, "Who am I to be running this company? And what am I doing here? And oh my God, I can't be doing this." But when we looked at how that habit of calling herself an imposter served her, what she realized is that every time it kicked in, she worked harder. And it just meant she was hitting some kind of a growth edge. When she would jump into action, she would learn something new, she would read 20 books, she would go out, take a class, she would listen to podcasts and on and on. And she would get better at this new thing, it was fun for her, and then she would feel less like an imposter over time, so it was a very functional thing for her.

**中文翻译:**
讲述有害的故事也会产生类似的影响。但当你能在恰当的时机拦截它们并说：“好吧，如果那是真的呢？每当事情变得困难时，不断说‘我是个冒牌货’对我有什么好处？”我之前合作过的一位联合创始人，每当事情变得太难时她就会这么做。她深信不疑（创始人经常这样）：“我凭什么经营这家公司？我在这里做什么？天哪，我做不来。”但当我们审视“自称冒牌货”这个习惯如何为她服务时，她意识到：每当这种感觉袭来，她就会工作得更努力。这仅仅意味着她触碰到了某种“成长边缘”。当她投入行动时，她会学习新东西，读 20 本书，去上课，听播客等等。她会在新事物上变得更擅长，这对她来说很有趣，随着时间的推移，她的冒充感就会减轻。所以，这对她来说是非常有用的。

**(00:29:32):**
**English:**
The problem is when she did that too much... I work with a lot of women who this is the case for. She often did way much work. And so she took on emotional labor for other people. She did 10 times as much work as she needed to do, actual work. In her role, she was playing COO and CFO and CEO. And it's just like she didn't need to be doing all of that. And so on a spectrum of it's actually helpful, give yourself a pat on the back for jumping into imposter zone every time things get hard to the other side of the spectrum, which is, okay, but when it's too much, you burn out. You're doing way too much work for other people. You're falling into these unfortunate conventional gender roles that doing extra work you don't need to, so you want to find a happy medium. But I think that the trick is, with imposter syndrome, to not deny it, to embrace it as much as you can, but not embrace it so much that it ends up holding you back. Yes, functional. Even things that we think are bad for us are actually good.

**中文翻译:**
问题在于当她做得太过火时……我合作过的很多女性都有这种情况。她经常做过量的工作。她承担了别人的情绪劳动。她做了 10 倍于她实际需要做的工作。在她的角色中，她同时扮演着 COO、CFO 和 CEO。她其实不需要做所有这些。所以，在“实际有帮助”（每当困难时进入冒充者状态并激励自己）到另一端“过度劳累”（导致职业倦怠、为别人做太多工作、陷入不必要的传统性别角色）之间，你需要找到一个平衡点。我认为处理冒充者综合征的诀窍不是否认它，而是尽可能地拥抱它，但不要拥抱到让它阻碍你前进的程度。是的，它是有功能的。甚至我们认为对自己有害的事情，实际上也可能有好处。

---

### [00:30:49] Lenny

**English:**
I love that advice. It's so much easier to just, okay, yep, it's true. Maybe I am an imposter, but here's how he can maybe help me while I feel this. And this actually reminds me of another coach who did a guest post on my newsletter a long time ago, and her advice is, "Yeah, you probably are an imposter. You're in a role you've never done before. And that's pretty normal, and that's okay. And here's how you should approach it."

**中文翻译:**
我喜欢这个建议。承认“好吧，是的，是真的，也许我确实是个冒牌货，但在这种感觉下，它能如何帮助我”要容易得多。这让我想起很久以前在我时事通讯上发过客座文章的另一位教练，她的建议是：“是的，你可能确实是个冒牌货。你正处于一个从未担任过的角色中。这很正常，没关系。你应该这样对待它。”

---

### [00:31:12] Donna Lichaw

**English:**
Yeah. Especially in tech where half of the roles we have are all made up. You're probably the first person ever to have your role anyway, whether you founded the company or you're doing something else at your company. Yeah, it's a great thing. Embrace it.

**中文翻译:**
是的。特别是在科技行业，我们有一半的角色都是编造出来的。无论你是创立了公司还是在公司做别的事情，你很可能是有史以来第一个担任该角色的人。所以，这是一件好事。拥抱它。

---

### [00:31:28] Lenny

**English:**
The takeaway advice there is essentially ask yourself, "Okay, this may be how I feel. How is it helping me?" And don't try to push it down and convince yourself that you're not necessarily an imposter, but how is this feeling helping you?

**中文翻译:**
这里的核心建议本质上是问自己：“好吧，这可能就是我的感受。它对我有什么帮助？”不要试图压抑它或说服自己你不是冒牌货，而是去想这种感觉如何帮助你？

---

### [00:31:42] Donna Lichaw

**English:**
How is it serving you? I have a whole chapter on kryptonite in the book, which is... It's what I call kryptonite. And I use superhero metaphors pretty heavily in the book because I'm I guess a grown child and I like comics and superhero stories. And so are my clients, so I think because I work in tech, I get to do this. But I liken it to kryptonite, which is the things that we think harm us, actually when we look at how they serve us, they can serve a function. Like kryptonite for Superman, it's how people are able to operate on him. They use a little kryptonite so they could get in there and do some surgery and then get out. It serves a function, but when it's too much that can be detrimental. Yeah, how does it serve you? It's a question that it's so important and so, so powerful.

**中文翻译:**
它是如何为你服务的？我在书里专门有一章讲“氪石”……这就是我所谓的氪石。我在书里大量使用了超级英雄的比喻，因为我想我还是个没长大的孩子，我喜欢漫画和超级英雄故事。我的客户也是如此，我想因为我在科技行业工作，我可以这么做。我把它比作氪石，即那些我们认为会伤害我们的东西，实际上当我们审视它们如何为我们服务时，它们可以发挥作用。就像超人的氪石，那是人们能够对他进行手术的方式。他们使用一点点氪石，这样就能进入他的身体做手术然后退出。它有其功能，但如果太多就会有害。是的，“它如何为你服务？”这是一个非常重要且极其强大的问题。

---

### [00:32:37] Lenny

**English:**
What are some examples of other types of kryptonite that you find leaders have? And how do you find that it ends up maybe serving them and being useful?

**中文翻译:**
你发现领导者还有哪些其他类型的“氪石”例子？你又是如何发现它们最终可能为他们服务并变得有用的？

---

### [00:32:45] Donna Lichaw

**English:**
They're the kinds that you should avoid and can avoid. For example, scheduling things is my kryptonite, but I do meetings for a living. And I love being in meetings, strangely, and so not scheduling is not an option, but there are ways around it. I automate everything. And some people hire assistants. And there are ways to do it. That's the kind that you're better off avoiding. There's nothing that serves me about having to schedule things or my inability to schedule things properly. How is that serving me? You know what? I don't care. It doesn't matter. Just the kind that you need to avoid.

**中文翻译:**
有些氪石是你应该且能够避开的。例如，安排日程是我的氪石，但我靠开会谋生。奇怪的是，我喜欢开会，所以不安排日程是不可能的，但有办法绕过它。我把一切都自动化了。有些人会雇助理。有很多方法。这是那种你最好避开的弱点。必须安排日程或我无法妥善安排日程这件事对我没有任何好处。这怎么为我服务？你知道吗？我不在乎。这不重要。这就是你需要避开的那种。

**(00:33:30):**
**English:**
Or you could say toxic people or people who just don't add anything to your life. There are kinds of just like, "All right, done. Moving on." But then there are the kinds that it's usually on the inner kryptonite side where you can look at, "Okay, well how does this serve me?" And so wide swath of people example is dyslexia. I work with a lot of founders, CEOs and senior executives who are dyslexic. It's very, very, very common, especially for CEOs. You could say, "Well, that's kryptonite, having to read things or do things with text." And it can feel like that to a lot of people, yet when you look at the science of something like dyslexia, it's not so much an impairment, it just means that your brain is operating at a different level in a different way than most people.

**中文翻译:**
或者你可以说是“有毒”的人，或者那些对你的生活没有任何贡献的人。有些事情就是“好吧，结束了，继续前进”。但还有一些通常属于“内在氪石”的范畴，你可以审视：“好吧，这对我有什么好处？”一个涉及面很广的例子是阅读障碍（dyslexia）。我与许多患有阅读障碍的创始人、CEO 和高级管理人员合作。这非常非常普遍，尤其是对 CEO 而言。你可以说：“那是氪石，必须阅读或处理文字。”对很多人来说确实如此，但当你审视阅读障碍的科学原理时，它与其说是一种缺陷，不如说意味着你的大脑在以一种与大多数人不同的水平和方式运作。

**(00:34:42):**
**English:**
Same thing with ADHD. And you could extend it to autism and ton of other things as well. But when you're dyslexic, you're thinking spatially, you're thinking big, you're thinking visually, you're not... Yes, you mix up letters or you're struggling with big blocks of text; that's fine. If you're founding a company, you're not in documents all day long anyway probably, so that ability to think big and spatially and visually is probably how you created your company in the first place, or if you work at a large corporation, how you catapulted into executive leadership that way because you're a visionary and you do all these things.

**中文翻译:**
ADHD（多动症）也是如此。你还可以将其扩展到自闭症和许多其他方面。当你患有阅读障碍时，你是在进行空间思考、宏观思考、视觉思考，你不是……是的，你会混淆字母或难以处理大段文字；这没关系。如果你正在创办一家公司，你可能反正也不会整天埋头于文档中，所以那种宏观思考、空间思考和视觉思考的能力，可能正是你最初创立公司的原因；或者如果你在一家大公司工作，你正是通过这种方式跃升到高管层的，因为你是一个有远见的人。

**(00:35:23):**
**English:**
I think kryptonite, the inner kind of kryptonite, that's how I like to think of it, which is you think it makes you weak, but when you can look at how it serves you, it's often not the case. It could be something that is often classified as a disorder like dyslexia, ADHD, and it could be quirks like the one earlier, "I'm too quiet." Well, no, she was just a really good listener. She just didn't realize that she had a poker face on when she was listening. And no one knew she was listening. Everything, just look at how it serves you. It's the kind you need to avoid, the kind of kryptonite that you need to really look at and embrace. And once you embrace it, just like with the superheroes, it becomes ideally something that's useful in small doses like Superman, or it could be something more like Hulk, which is you could say his kryptonite is his anger, but that's also his superpower. And he can't get rid of it, or if he does, he becomes Mark Ruffalo being really boring like in the latest Avenger movies and he is all meditating.

**中文翻译:**
我认为“内在氪石”是你认为让你变得虚弱的东西，但当你审视它如何为你服务时，情况往往并非如此。它可能是通常被归类为障碍的东西，如阅读障碍、ADHD；也可能是怪癖，比如之前的例子“我太安静了”。不，她只是一个非常好的倾听者。她只是没意识到自己在倾听时面无表情，没人知道她在听。一切，只需看它如何为你服务。有些氪石需要避开，有些则需要真正审视并拥抱。一旦你拥抱了它，就像超级英雄一样，它在理想情况下会变成像超人那样小剂量使用的有用工具；或者它可能更像绿巨人，你可以说他的氪石是愤怒，但那也是他的超能力。他无法摆脱它，如果摆脱了，他就会变成像最近几部《复仇者联盟》电影里马克·鲁法洛那样无聊，整天在冥想。

---

### [00:36:31] Lenny

**English:**
Just moping around.

**中文翻译:**
只是在垂头丧气。

---

### [00:36:32] Donna Lichaw

**English:**
Yeah, I don't know what the point of that is. Yeah, that's how I see Kryptonite. It's actually a really, really amazing, amazing tool that we can all leverage.

**中文翻译:**
是的，我不知道那有什么意义。这就是我看待“氪石”的方式。它实际上是一个非常、非常神奇的工具，我们都可以利用它。

---

### [00:36:41] Lenny

**English:**
The flip side of kryptonite is a superpower. And I definitely want to spend time here. I'm a big believer in this, you are too, of just how important it is to lean into your strengths and identify what you're better at than most people and use that as your way of getting ahead versus trying to, say, just remove these kryptonite/things you're not good.

**中文翻译:**
氪石的另一面就是“超能力”。我绝对想在这里多花点时间。我对此深信不疑，你也是：发挥自己的优势，识别出你比大多数人做得更好的地方，并以此作为你领先的方式，而不是仅仅试图消除这些“氪石”或你不擅长的事情，这非常重要。

**(00:37:06):**
**English:**
For me, it was really a big deal. I actually worked with a coach while I was working. And this was in the biggest step changes for me is just realizing I'll never be amazing at X, Y, Z, but it turns out I'm really good at these things, and so let me just use those things to achieve the things I'm trying to do. As one example, I'm never going to be an amazing public speaker. I hate that stuff. Even though I do this podcast, it's not my strength. And it turns out I much prefer writing and sitting there and thinking, and that's what led to this newsletter. I started doing the thing that was pulling me and was easier for me and ends up being really successful because that's another way of achieving the same thing, it turns out. Here's the question. Why is it so important to think about your superpowers? How do you identify your superpowers? And just how do you think about this area?

**中文翻译:**
对我来说，这确实是一件大事。我工作时曾与一位教练合作。对我来说最大的转变就是意识到：我永远不会在某些方面（X, Y, Z）变得出色，但事实证明我非常擅长这些事情，所以让我利用这些优势来实现我的目标。举个例子，我永远不会成为一名出色的公共演讲者。我讨厌那玩意。虽然我做这个播客，但那不是我的强项。事实证明，我更喜欢写作、坐在那里思考，这就是这份时事通讯的由来。我开始做那些吸引我、对我来说更容易的事情，结果非常成功，因为事实证明那是实现同一目标的另一种方式。问题是：为什么思考你的“超能力”如此重要？你如何识别你的超能力？你如何看待这个领域？

---

### [00:37:53] Donna Lichaw

**English:**
On the one hand, there's so many studies that show that when we play to our strengths, we're much more effective than when we try to fix what's broken. It's a waste of energy to fix what's broken for the most part. But when you can amplify your strengths and figure out how to use them productively so that you can fulfill your purpose, meet your goals, do what you need to do in life and bring others along with you, it's just that you're such a bigger impact that way.

**中文翻译:**
一方面，有太多的研究表明，当我们发挥优势时，效率要比试图修复缺陷时高得多。在大多数情况下，修复缺陷是浪费精力。但当你能放大你的优势，并弄清楚如何高效地利用它们来实现你的目标、完成你在生活中需要做的事情并带领他人一起前进时，你产生的影响力会大得多。

**(00:38:31):**
**English:**
I'm going to give you an example. And it's funny that we're here talking about this because a while back, I remember we first met over email. I was thinking of resurrecting my newsletter. And I hate writing. And I've written two books; I hate writing. But more than hating writing, I hate email. I hate sending emails, reading emails. I really struggle with it. But yet I have this newsletter that people love and people were begging me to send more of over the years. And at the time, I was like, "Oh, maybe I'll dusted off." And I remember emailing you about this and asking if we could have a call because I had questions about newsletters. And your answer was, "No, no, no, no, no. No calls."

**中文翻译:**
我给你举个例子。很有趣，我们在这里谈论这个，因为不久前，我记得我们第一次通过邮件联系。当时我在考虑重启我的时事通讯。我讨厌写作。我写过两本书，但我讨厌写作。但比讨厌写作更甚的是，我讨厌电子邮件。我讨厌发邮件、读邮件。我真的很挣扎。然而，我有一份人们喜欢的时事通讯，多年来人们一直求我多发一些。当时我想：“哦，也许我该重新启动它。”我记得给你发邮件问能不能通个电话，因为我对时事通讯有疑问。你的回答是：“不，不，不，不，不。不打电话。”

---

### [00:39:23] Lenny

**English:**
I don't know if it was that. I don't know if it was that.

**中文翻译:**
我不确定是不是那样说的。我不确定。

---

### [00:39:23] Donna Lichaw

**English:**
Something like-

**中文翻译:**
大概是……

---

### [00:39:28] Lenny

**English:**
It was just I prefer to avoid calls whenever I can.

**中文翻译:**
只是我尽可能避免打电话。

---

### [00:39:31] Donna Lichaw

**English:**
Yes, there you go, "Prefer to avoid calls whenever I can." It was very polite, right?

**中文翻译:**
是的，就是那句，“尽可能避免打电话”。非常有礼貌，对吧？

---

### [00:39:32] Lenny

**English:**
Okay, yeah.

**中文翻译:**
好吧，是的。

---

### [00:39:35] Donna Lichaw

**English:**
But it was, "Happy to answer any questions you have. Can you shoot me an email?" I don't remember if this was my answer, but I think my answer to me was, "No, no emails. I can't give you my questions written. Maybe if I can record them for you, I'll think about it." And I think in the end, the irony is I ended up resurrecting the email list a while later, and now I do send occasional newsletters that I actually like writing and people enjoy. But I knew, okay, it'll take me like five hours to write down my questions for you over email; and I knew that was not right for me. You knew having a meeting was not right for you. That was fine. That was great because in the end, it was easier for me to write an entire book than to write that email to you. It probably was faster to write my book than it would've been to write the email to you. And in the end, here we were having that first conversation, which is really fun, but it's in a way that feels good to both of us. Play to your strengths and good things happen. I could get better at writing emails, but you know what? Not worth my time. And you could have more meetings, and not worth your time either.

**中文翻译:**
但当时你说：“很乐意回答你的任何问题。你能给我发封邮件吗？”我不记得我当时是怎么回的了，但我对自己说：“不，不发邮件。我没法把问题写下来。也许我可以录音发给你，我会考虑的。”讽刺的是，最后我还是在一段时间后重启了邮件列表，现在我偶尔会发一些我真正喜欢写、人们也喜欢读的时事通讯。但我当时知道，要把问题写在邮件里发给你可能要花我五个小时；我知道那不适合我。而你知道开会不适合你。这很好。这太棒了，因为最终，对我来说写一整本书比给你写那封邮件更容易。写书可能比写那封邮件还快。最后，我们在这里进行了第一次对话，非常有趣，而且是以一种让我们双方都感觉良好的方式进行的。发挥你的优势，好事就会发生。我可以练习写更好的邮件，但你知道吗？不值得花那个时间。你也可以开更多的会，但那也不值得你花时间。

---

### [00:40:55] Lenny (Sponsor Message)

**English:**
Let me tell you about a product called Sprig. Next-gen product teams like Figma and Notion rely on Sprig... [Ad content omitted]

**中文翻译:**
让我向你介绍 Sprig。像 Figma 和 Notion 这样的下一代产品团队都依赖 Sprig……（此处为 Sprig 广告内容，介绍其 AI 驱动的产品体验洞察平台，为听众提供 10% 的折扣）。

---

### [00:42:15] Lenny

**English:**
Is there an example you can think of someone that you work with where identifying their strength and then leaning into that made a big impact on them?

**中文翻译:**
你能想到一个你合作过的例子吗？识别出他们的优势并加以利用，对他们产生了重大影响？

---

### [00:42:15] Donna Lichaw

**English:**
Gosh, I see this all the time. I especially see this with founder CEOs because there's this very heavy misconception that when you are again catapulted into some kind of senior leadership position, that you're supposed to be a certain way and you're supposed to be loud and opinionated and controlling and tell people what to do, but I've worked with some amazing CEOs who are just incredible listeners instead. And it's the same thing, which is they embrace what works for them and they don't try to be what they're supposed to be. Well, they have to learn that.

**中文翻译:**
天哪，我一直看到这种情况。我特别是在创始人 CEO 身上看到这一点，因为存在一种严重的误解：当你被推上高级领导职位时，你应该表现出某种特定的样子——你应该大声说话、固执己见、有控制欲并告诉别人该做什么。但我合作过一些非常出色的 CEO，他们反而是极佳的倾听者。道理是一样的：他们拥抱适合自己的方式，而不去强求成为“应该”成为的样子。当然，他们必须学会这一点。

**(00:43:01):**
**English:**
Bob Iger as an example from Disney. I haven't met him. I know people who've met him. And I just always hear, "Such a sweet person. So nice and such a great listener." You can control the world and do it in your way. And so yeah, I see this all the time, any of your strengths, they operate again on that continuum with kryptonite. But if you can figure out how to leverage them and really be comfortable with them, cool things happen, cool things happen.

**中文翻译:**
以迪士尼的鲍勃·艾格（Bob Iger）为例。我没见过他，但我认识见过他的人。我总是听到：“真是个温柔的人。人很好，而且是个伟大的倾听者。”你可以掌控世界，并以你自己的方式去做。所以是的，我一直看到这种情况，你的任何优势都与“氪石”处于同一个连续体上。但如果你能弄清楚如何利用它们并真正适应它们，酷的事情就会发生。

---

### [00:43:31] Lenny

**English:**
The big unlock for me was realizing that you can achieve all the same things using different strengths. You can be an amazing CEO being very loud, charismatic visionary. You could also be great CEO, being very quiet and thoughtful and deliberative and working in small teams versus like, "Hey everyone, listen to what I have to say."

**中文翻译:**
对我来说，最大的启发是意识到：你可以利用不同的优势实现同样的目标。你可以是一个大声、有魅力、有远见的出色 CEO；你也可以是一个非常安静、深思熟虑、审慎、在小团队中工作的优秀 CEO，而不是那种喊着“嘿，大家听我说”的人。

---

### [00:43:52] Donna Lichaw

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:43:53] Lenny

**English:**
Okay, how does somebody identify their superpowers, their strengths? I know there's some tests they could take. Very tactically, what do you recommend people do? What do you send them to figure out here's what I'm really good at?

**中文翻译:**
那么，一个人该如何识别自己的超能力和优势呢？我知道有一些测试可以做。从战术层面讲，你建议人们怎么做？你让他们通过什么方式来弄清楚“这就是我真正擅长的”？

---

### [00:44:04] Donna Lichaw

**English:**
There are tests out there. I have personally not found them as helpful, but some people love them. And so if you've ever taken a StrengthsFinder test or there's a V-I-A character strengths test I think it's called. Those are the two most popular. And you can just take a multiple choice quiz and it'll tell you what your top five strengths or characteristics are. And I don't find it useful because if I just get a list of things, I will never remember what the list is. And it also has no context for me, and so what I do and what I find works better for my clients as well is to pull your superpowers out of your stories from your past and your present, and then eventually figure out how to apply them and transpose them to your future.

**中文翻译:**
市面上确实有一些测试。我个人觉得它们没那么有帮助，但有些人很喜欢。比如 StrengthsFinder（优势识别器）或者 VIA 性格优势测试。这是最流行的两个。你可以做一个多选题测验，它会告诉你前五项优势或特征。我觉得这没用，因为如果我只得到一份清单，我永远记不住清单上有什么。而且它对我来说没有语境。所以我所做的，以及我发现对我的客户更有效的方法，是从你过去和现在的“故事”中提取超能力，然后最终弄清楚如何应用它们并将它们迁移到未来。

**(00:44:58):**
**English:**
But if you look at your peak experiences from life, from work, but especially from life... Because even if you want to be a better leader in a work context, there's a difference between work and life. It's very blurry, so you're better off not separating them. But if you look at your peak experiences from your past, I would go back to when you were a kid, what's something you did when you were a kid, like a project you worked on or something you were a part of that completely, totally lit you up and that you were so excited about? And I would then look at something from your more recent past. What's a project or something you worked on in the last maybe 10 years that just jazzed you up and you were just so excited to do? And then I would also look at just how did you get into your line of work, the thing that you're doing now? What's that meandering path?

**中文翻译:**
如果你审视生活中、工作中（尤其是生活中）的“巅峰体验”……因为即使你想在工作语境下成为更好的领导者，工作和生活之间的界限也是模糊的，所以你最好不要把它们分开。审视你过去的巅峰体验，我会追溯到你小时候：你小时候做过什么事，比如一个项目或你参与的一件事，让你完全被点燃、让你如此兴奋？然后我会看你近期过去的事情：在过去大约 10 年里，有什么项目或事情让你感到振奋、让你非常兴奋去做？接着我还会看你是如何进入现在的行业的？那条曲折的路径是怎样的？

**(00:45:59):**
**English:**
And when you can look at these three stories as moments in time and you can lay them on top of one another, what you see at key moments is your superpowers popping through. And they're the things that empower you to make an impact, they are the things that do make an impact. And so an example I'll give you is one of... God, another executive I worked with a while ago, she kept being told in this dreaded 360 reviews at her company, they were obsessed with... This is another big, big tech company. They were obsessed with superpowers at this company. And so she would get these 260 reviews from her team telling her what her superpowers were. And so they kept saying, "Attention to detail." And she was like, "What on earth? I hate details. That's my kryptonite. I cannot deal with details," yet they kept telling her, "Wow, you're so great. You have this attention to detail." And then they kept giving her more detail-oriented stuff to do. And she's like, "I should be doing strategy and high level stuff. What is happening here?"

**中文翻译:**
当你把这三个故事视为时间点并将它们重叠在一起时，你会看到在关键时刻，你的超能力会显现出来。它们是赋予你产生影响力的东西，也是真正产生影响力的东西。我给你举个例子：我之前合作过的一位高管，在公司那令人畏惧的 360 度评估中，人们一直告诉她……那是另一家大型科技公司，他们对“超能力”非常痴迷。她收到的评估报告里，团队告诉她她的超能力是“关注细节”。她心想：“搞什么？我讨厌细节。那是我的氪石。我处理不了细节。”然而他们一直告诉她：“哇，你太棒了，你非常关注细节。”然后他们不断给她更多细节导向的工作。她想：“我应该做战略和高层工作。这到底是怎么回事？”

**(00:47:22):**
**English:**
And she could say, "My strength is strategy." And I hear that all the time. "I'm a strategist." What is that? It doesn't even mean anything. That's not a superpower. I don't know, that means nothing. But when we looked at her past and her stories, what we were able to pull out is that she was really great at connecting things together, connecting themes, connecting pieces, trends and connecting people; connecting ideas together, and then connecting people to ideas. That's when she was happiest and that's when she was most effective.

**中文翻译:**
她可能会说：“我的优势是战略。”我经常听到这种话，“我是个战略家”。那是什么？那甚至没有任何意义。那不是超能力。但当我们审视她的过去和故事时，我们发现她真正擅长的是“连接”：把事物连接在一起，连接主题、连接碎片、连接趋势，以及连接人；把想法连接在一起，然后把人连接到想法上。那是她最快乐的时候，也是她最高效的时候。

**(00:48:04):**
**English:**
And so eventually, that being a connector, it was a superpower, one of her superpowers. It also became part of her identity. And then over time, she was able to shed the great attention to detail thing as she just started embracing that ability to connect. And it made her much more effective at her job in the end. Yeah, look to your past and you can pull out key moments and see what your superpowers are.

**中文翻译:**
所以最终，“作为一个连接者”成了她的超能力之一。这也成了她身份的一部分。随着时间的推移，当她开始拥抱这种连接能力时，她能够摆脱那个“擅长细节”的标签。这最终让她在工作中变得更加高效。是的，回顾你的过去，你可以提取关键时刻，看看你的超能力是什么。

---

### [00:48:30] Lenny

**English:**
We'll link to these tests that you recommended just for people to explore. I took a couple of them, and they were actually really useful to me, so I think if nothing else, it's a good little context to have while you do this other exercise. And I don't know if I got this right, but one is think about peak experiences in your life, including childhood or mostly adult life, do you recommend?

**中文翻译:**
我们会链接到你推荐的那些测试，供大家探索。我做过几个，对我确实很有用。所以我想，即使没别的，在做你说的那个练习时，这些测试结果也是很好的参考背景。我不确定我理解得对不对：一个是思考人生中的巅峰体验，包括童年还是主要是成年生活？你推荐哪个？

---

### [00:48:50] Donna Lichaw

**English:**
Yeah, I would go back as far as you can. Definitely childhood, childhood.

**中文翻译:**
是的，我会建议尽可能追溯得远一些。绝对要包括童年，童年。

---

### [00:48:55] Lenny

**English:**
And peak meaning amazing, happy experiences? Is that what we should look for?

**中文翻译:**
“巅峰”意味着神奇、快乐的经历吗？那是我们应该寻找的吗？

---

### [00:48:59] Donna Lichaw

**English:**
It doesn't have to be happy or sad, it's just you were at your best. It lit you up. And so for example... I have a few, but... Well, no, let me ask. Enough about me, so other people can hear this in action, when was the time when you were younger or a kid or anytime in the past when you were just at your best, really lit up doing something that just fueled you?

**中文翻译:**
不一定是快乐或悲伤，只要是“你处于最佳状态”的时候。它点燃了你。例如……我有几个例子，但……不，让我问问你。别总说我了，让听众听听实际操作：在你年轻、小时候或过去的任何时候，什么时候你处于最佳状态，做某件事让你感到被点燃、充满动力？

---

### [00:49:31] Lenny

**English:**
To me, I guess I think of not necessarily an specific example, but just accomplishing things always gets me energized. I did this hard thing. Selling my startup, that was a peak experience. There's one.

**中文翻译:**
对我来说，我想到的不一定是一个具体的例子，但“完成任务”总是让我充满能量。我做成了这件难事。卖掉我的创业公司，那是一个巅峰体验。这是一个。

---

### [00:49:48] Donna Lichaw

**English:**
Selling your startup.

**中文翻译:**
卖掉你的创业公司。

---

### [00:49:50] Lenny

**English:**
Yeah. And starting the startup.

**中文翻译:**
是的。还有创办那家公司。

---

### [00:49:53] Donna Lichaw

**English:**
And starting the startup. What compelled you to start the startup?

**中文翻译:**
还有创办公司。是什么驱使你创办那家公司的？

---

### [00:49:59] Lenny

**English:**
I always had this goal of I want to start a company, which is a terrible reason to start a company, but I had a goal I wanted to start a company. I had set this goal, in two years I'm going to leave this job and start a company. And two years later, that's exactly what I did.

**中文翻译:**
我一直有这个目标：我想创办一家公司。虽然这可能是创办公司的一个糟糕理由，但我确实有这个目标。我设定了目标：两年后我要辞职去创业。两年后，我确实这么做了。

---

### [00:50:13] Donna Lichaw

**English:**
What was it about starting a company that made that something that you were so interested in doing?

**中文翻译:**
关于“创办公司”，是什么让你如此感兴趣？

---

### [00:50:19] Lenny

**English:**
I wanted to prove to myself that I could do it, I think is the core of it. I keep reading about startups. All these people are doing interesting things. I want to just see if I can pull this off.

**中文翻译:**
我想向自己证明我能做到，我想这是核心。我一直在读关于创业的故事。所有人都在做有趣的事。我只想看看我能不能搞定。

---

### [00:50:30] Donna Lichaw

**English:**
Okay. You wanted to just see if you could pull it off.

**中文翻译:**
好。你只是想看看你能不能搞定。

---

### [00:50:33] Lenny

**English:**
Yeah. And I also felt like I had the skills to do this compared to other folks that were starting companies and trying their hand at a startup.

**中文翻译:**
是的。而且我觉得与其他创业的人相比，我有能力做到这一点。

---

### [00:50:47] Donna Lichaw

**English:**
You wanted to do it because you wanted to see if you could do it and you thought you could do it.

**中文翻译:**
你想做是因为你想看看自己能不能做成，而且你认为自己能做成。

---

### [00:50:47] Lenny

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:50:48] Donna Lichaw

**English:**
What's so cool when you do this exercise, if we were to do it, we are not going to do it now, it'd take a little while. But if you were to unpack enough of those stories, even if you can't go far back to your childhood, because sometimes you don't have those memories. If you could unpack at least three of those scenarios, you would find themes. For example, it could be that one of your superpowers is doing things because you can do them. And that's really cool when applied in the right ways. You said you did the exercise. I'm curious to know what you came up with.

**中文翻译:**
做这个练习最酷的地方在于（如果我们现在做的话会花点时间），如果你能拆解足够多的故事，即使你记不清童年了也没关系。如果你能拆解至少三个场景，你就会发现主题。例如，你的超能力之一可能是“因为我能做，所以我就去做”。如果应用得当，这非常酷。你说你做过这个练习，我很想知道你得出了什么结论。

---

### [00:51:35] Lenny

**English:**
What I'm thinking about as you talk about this is I was very shy my entire childhood, and I think people didn't expect me to achieve big things because I was always just this nerdy, shy guy. I think there's always this chip on my shoulder of I'm going to show people what I could do. I want to show that I'm capable of more. I think there's a lot of that there.

**中文翻译:**
当你谈到这个时，我想起我整个童年都非常害羞。我想人们并不指望我能成就大事，因为我一直只是那个书呆子气、害羞的家伙。我想我心里总憋着一股劲：我要向人们展示我能做什么。我想证明我有更大的能力。我想这其中有很多这样的成分。

---

### [00:51:55] Donna Lichaw

**English:**
When you can look at that in context, what you could see is you could see how it's helped you through life, even if it came from adversity. I'm sure you can also see times when that has not served you and when over indexing on, "I'm going to do it just because I can do it," has actually done a disservice to you. And so that's how you end up using them, which is you really look at, all right, from here to where I now want to go, how can I use this? And what do I need to watch out for if I'm going to over index and use this too much? Yeah.

**中文翻译:**
当你把这放在语境中看时，你会发现它如何帮助你度过人生，即使它源于逆境。我相信你也能看到这种心态“没能为你服务”的时候，即当你过度沉迷于“仅仅因为我能做我就要做”时，实际上反而害了你。这就是你最终利用它们的方式：你审视，好吧，从现在到我想去的地方，我该如何利用这一点？如果我过度使用它，我需要注意什么？

**(00:52:40):**
**English:**
Another blanket example that I'll give is problem solving, this keen ability to solve problems. I work with a lot of high achieving especially founder CEOs who are amazing at solving problems. And that's how they got to where they are. It's usually why you start a company. Well, for the rest of us, you do it because you want to see if you can do it. Otherwise, it's just to solve a problem. But when you're a super senior executive, at some point you can't be solving problems for everyone. And if you're just in the weeds solving problems all day, that's when you're not doing your real job and you're going to be the whole team and your whole company nuts. And so you have to figure out, okay, if this keen ability to solve problems is a superpower, how do you apply it differently?

**中文翻译:**
我再举一个普遍的例子：解决问题，即这种敏锐的解决问题的能力。我与许多事业有成的创始人 CEO 合作，他们非常擅长解决问题。这就是他们取得成就的原因。这通常也是创办公司的原因。好吧，对我们其他人来说，你创业是因为你想看看自己能不能做到；否则，就是为了解决一个问题。但当你成为一名高级管理人员时，在某种程度上你不能为每个人解决问题。如果你整天埋头于琐事中解决问题，那你就是在不务正业，你会让整个团队和公司发疯。所以你必须弄清楚：如果这种敏锐的解决问题能力是超能力，你该如何以不同的方式应用它？

---

### [00:53:37] Lenny

**English:**
Yep. That super resonates. A lot of times, you just are interested in the problem. It's like a puzzle and pulls you in. And that gets you in trouble.

**中文翻译:**
是的，这非常有共鸣。很多时候，你只是对问题感兴趣。它就像一个谜题吸引着你，而这会让你陷入麻烦。

---

### [00:53:46] Donna Lichaw

**English:**
It can.

**中文翻译:**
确实会。

---

### [00:53:46] Lenny

**English:**
To answer your question, what these tests told me my number one strength was adaptability, that I could just adapt to situations, which has pros and cons, but I super resonates. I find that I could just fit into things and adapt.

**中文翻译:**
回答你的问题，那些测试告诉我，我的头号优势是“适应能力”，即我能适应各种情况。这有优有劣，但我非常有共鸣。我发现我能很快融入并适应。

---

### [00:54:00] Donna Lichaw

**English:**
And it's a perfect example. And, as you see, it has its pros and cons.

**中文翻译:**
这是一个完美的例子。而且如你所见，它有利有弊。

---

### [00:54:06] Lenny

**English:**
Again, just for people to think about, because I really think this is such an important topic and it makes me want to write a newsletter post about this, just how powerful it is to identify, here's the things I'm very strong at and why it's important to double down on those versus think about solving your weaknesses. Your advice here is maybe take these quizzes that'll give you a sense of maybe your superpowers, and then think about your peak life experiences when you're the most yourself I think is how you describe it.

**中文翻译:**
再次强调，让大家思考一下，因为我真的认为这是一个非常重要的课题，这让我想写一篇关于这个的时事通讯：识别出你非常擅长的事情是多么强大，以及为什么加倍发挥这些优势比试图弥补弱点更重要。你的建议是：也许去做做这些测验，让你对自己的超能力有个概念，然后思考你人生中的巅峰体验——也就是你“最像你自己”的时候，我想你是这么描述的。

---

### [00:54:34] Donna Lichaw

**English:**
When you're at your best.

**中文翻译:**
当你处于最佳状态时。

---

### [00:54:34] Lenny

**English:**
At your best.

**中文翻译:**
最佳状态。

---

### [00:54:38] Donna Lichaw

**English:**
At your best. Yep.

**中文翻译:**
处于最佳状态。是的。

---

### [00:54:38] Lenny

**English:**
And there's an element of also when you're energized, which came up a few times on this podcast. Look for things that give you energy because there's something there.

**中文翻译:**
还有一个因素是“当你精力充沛时”，这在播客中提到过几次。寻找那些能给你能量的事情，因为那里一定隐藏着什么。

---

### [00:54:46] Donna Lichaw

**English:**
Yes. Yep. Because then if you subscribe to... I'm sure your audience is familiar with this idea of managing your energy, not your time, which is great for managers, great for anybody, this will help you do that. If you're using your superpowers, you will have more energy. If you use them too much, then it's going to detract. But you want to be doing more of that, more of what lights you up, more of what you love, and figuring out how to manage the rest, whether it's outsourcing or sometimes fixing. But, I don't know, we're all grown adults. It probably is a matter of outsourcing or getting help or supplementing. We don't have to fix everything.

**中文翻译:**
是的。因为如果你认同……我相信你的听众熟悉“管理能量而非时间”这个理念，这对管理者和任何人都很有用，而这（识别超能力）会帮助你做到这一点。如果你在使用超能力，你会更有能量。如果你过度使用，则会产生负面影响。但你想要做更多那样的事，更多能点燃你的事，更多你热爱的事，并弄清楚如何处理剩下的事情——无论是外包还是偶尔修复。但是，我们都是成年人了，这可能更多是关于外包、寻求帮助或补充。我们不必修复一切。

---

### [00:55:32] Lenny

**English:**
There's this guy that we'll link to in the show notes, but another executive coach, Matt Mochary, who we had on the podcast who is just like a walkthrough of how to do an energy audit on your day so that you can identify what gives you energy. And this is actually exactly what led me to this path. When I left my job, I specifically paid close attention to what gives me energy after a meeting I had, after a call, after things I did in the day, and what zaps me of energy? And I just decided I will do more of the things that are giving me energy. And that ended up being this newsletter and eventually this podcast, so it really works.

**中文翻译:**
我们会把这个人的链接放在节目笔记里，他是另一位高管教练 Matt Mochary，他曾上过我们的节目，讲解了如何对你的一天进行“能量审计”，以便识别什么能给你能量。这正是引导我走上这条路的原因。当我离职时，我特别留意：开完会、打完电话或做完一天的事情后，什么让我精力充沛？什么耗尽了我的精力？我决定多做那些能给我能量的事。结果就是这份时事通讯，最终还有了这个播客。所以这真的很管用。

---

### [00:56:06] Donna Lichaw

**English:**
There you go. And I know Matt Mochary works similar to me with a lot of founder CEOs where you have to do that. You have to do that because chances are you're exhausted, you're burnt out; you are spending your energy in the wrong places. And so it applies to anybody, but especially when you are leveling up in leadership and doing something new and hitting that growth edge, you got to be doing it. It's just, yeah, you'll run yourself into the ground otherwise.

**中文翻译:**
没错。我知道 Matt Mochary 和我一样，与很多创始人 CEO 合作，你必须这么做。你必须这么做，因为你很可能已经精疲力竭、职业倦怠了；你把精力花在了错误的地方。这适用于任何人，尤其是当你提升领导力、尝试新事物并触及成长边缘时，你必须这么做。否则，你会把自己累垮的。

---

### [00:56:39] Lenny

**English:**
I imagine many people listening to this or feeling like, I wish I could not be in these dumb meetings that I'm in all the time and these stupid reviews. And there's a lot of stuff you have no control over that also are very energy zapping. What advice would you give to people thinking that?

**中文翻译:**
我想很多听众会有这种感觉：我希望我不用参加这些整天没完没了的愚蠢会议和评估。有很多你无法控制的事情也非常消耗能量。你会给有这种想法的人什么建议？

---

### [00:56:55] Donna Lichaw

**English:**
Well, okay, let me qualify this with this is why I'm not a career coach, by the way. I don't help people navigate how to change jobs or leave jobs because I think if you're spending most of your time in your day doing things that are zapping your energy and you hate things you're doing in your job, maybe you're not in the right job. I don't know, if I was a career coach, I would just tell everyone, "Oh yeah, quit your job. I don't know what you're doing there." But there's a lot of truth to that, which is if there are things that you can control energy wise, great. Manage your energy, not your time. If there's really nothing you could do about it and it's the context and it's the situation, then your next best thing is trying to figure out how to change the context or the situation. I'm pretty ruthless there, I think. This is what I still bring from product management, I'm ruthless when it comes to prioritizing things. And so-

**中文翻译:**
好吧，顺便说一下，这就是为什么我不是一名职业规划教练。我不帮助人们导航如何换工作或离职，因为我认为如果你一天中大部分时间都在做消耗能量的事情，并且讨厌你的工作内容，也许你根本没找对工作。如果我是职业教练，我会告诉所有人：“哦，辞职吧，我不知道你在那儿干嘛。”但这其中确实有道理：如果有些事情是你可以在能量层面控制的，那太好了，管理能量而非时间。如果真的无能为力，那是环境和情况使然，那么你接下来的最佳选择就是尝试弄清楚如何改变环境或情况。我想在这方面我挺无情的。这是我从产品管理中保留下来的习惯：在优先级排序方面，我非常冷酷无情。所以……

---

### [00:57:58] Lenny

**English:**
I love it. This is prioritization.

**中文翻译:**
我喜欢。这就是优先级排序。

---

### [00:58:00] Donna Lichaw

**English:**
Yeah. There you go.

**中文翻译:**
是的，没错。

---

### [00:58:02] Lenny

**English:**
This reminds me of a Steve Jobs quote that I love of... His advice is just, "If you wake up every morning and you're feeling dread for the thing you're doing, it's okay to wake up sometimes and feeling that and feel like, ah, I'm not excited about this day, but if it keeps happening over and over and over and over, that's a sign that maybe you should make a change."

**中文翻译:**
这让我想起我非常喜欢的一句史蒂夫·乔布斯的名言……他的建议是：“如果你每天早上醒来都对要做的事情感到恐惧，偶尔这样没关系，但如果这种情况日复一日、年复一年地发生，那就是一个信号，说明也许你应该做出改变了。”

---

### [00:58:21] Donna Lichaw

**English:**
Yeah. I think there's something there. And actually, to bring this back to kryptonite, if it's something little, like let's say Zoom fatigue for example, I know it became definitely a topic when the pandemic hit a bunch of years ago, but I've been working remotely for, God, years, years, and even pre-pandemic. And I'm in meetings all day long. I love it. I love working with my clients. And they're all over the world, so we can't always travel to be with them. We do sometimes. They can't always travel to be with me. But the video's the next best thing, but it can be exhausting. And so does that mean I'm not just never going to have video calls ever? No, because I love what I do, and so I've discovered little hacks for that. One, which is don't schedule too many meetings a day. Great. Do lots of active stuff in between gym walks, whatever, try to get in-person social time, no meeting days.

**中文翻译:**
是的，很有道理。实际上，回到“氪石”的话题，如果是一些小事，比如 Zoom 疲劳，我知道这在几年前疫情爆发时成了一个热门话题。但我已经远程工作很多年了，甚至在疫情之前就是。我整天都在开会。我喜欢开会，喜欢和我的客户合作。他们遍布世界各地，我们不能总是飞过去见他们。视频是次优选择，但确实会让人精疲力竭。这是否意味着我永远不再进行视频通话了？不，因为我热爱我的工作。所以我发现了一些小窍门：第一，一天不要安排太多的会议。在会议之间做大量的活动，比如去健身房、散步，尝试获得面对面的社交时间，设定“无会议日”。

**(00:59:34):**
**English:**
And for during meetings, right here, I've got one of my squishies. There's the neurological thing with Zoom where we're just getting stimuli through our eyes and through our brains, but we're not getting physical stimuli, the same I would be getting if we were in a room together hanging out. Even having you just be on the other side of the room and we were chatting, it would be a very different physical experience that would close that circuitry for me and leave me more satisfied as opposed to on Zoom, my brain's on the lookout for something. And so I, a lot of my clients do this too, fidgets help ground me when I'm on Zoom calls. And it's like, okay, great. There are things you can manage, but yes, like that Steve Jobs quote or idea is if, God, if you really don't like and are getting energy sucked for most of what you're doing and it's constant, you got to change your situation.

**中文翻译:**
在会议期间，看，我手里有一个捏捏乐（squishy）。Zoom 有一个神经学上的问题：我们只通过眼睛和大脑接收刺激，但没有身体刺激，不像我们坐在同一个房间里聊天那样。即使你只是坐在房间的另一头和我聊天，那也是一种完全不同的身体体验，它能帮我闭合神经回路，让我感到更满足。而在 Zoom 上，我的大脑总是在寻找某种缺失的东西。所以我（我的很多客户也这么做）会用一些解压小玩具（fidgets）来帮我在 Zoom 通话时保持专注和脚踏实地。所以，有些事情是可以管理的。但是，就像乔布斯说的那样，如果你真的不喜欢你正在做的大部分事情，而且能量被持续吸走，你必须改变现状。

---

### [01:00:43] Lenny

**English:**
I really like that tip. That's very practical. And buy something that you can play with with your hands. I use this pen, actually, is what I'm playing with usually with these podcasts. I need something squishy maybe.

**中文翻译:**
我很喜欢这个建议。非常实用。买一些可以用手玩的东西。实际上，我做播客时通常在玩这支笔。也许我也需要一个捏捏乐。

---

### [01:00:51] Donna Lichaw

**English:**
Yeah. Well, there's-

**中文翻译:**
是的，其实……

---

### [01:00:52] Lenny

**English:**
If there's anything you recommend, let's link to it in a show notes.

**中文翻译:**
如果你有什么推荐的，我们把它放在节目笔记里。

---

### [01:00:56] Donna Lichaw

**English:**
Oh my God, I know, I know. One of my superpowers that's actually my kryptonite, but if I'm humorous about it, I'll call it a superpower is starting things that I don't finish. And so I think I have a picture of it somewhere on my website, a superhero supply kit that I prototyped a while back that has all these different types of fidgets and chocolate and all these things to get you through your meetings. And there are pointy fidgets that give you energy in the morning, and then there are squishy ones for the afternoon. And I've done way too much research. I should send you one at some point. I have a few boxes prototyped, and I never ended up doing anything with them, so I just send them to clients sometimes. But-

**中文翻译:**
天哪，我知道。我的超能力之一（其实也是我的氪石，但幽默点说我称之为超能力）就是“开了头却不收尾”。我想我网站上某处有一张照片，是我不久前设计的一个“超级英雄补给包”原型，里面有各种类型的解压玩具、巧克力和所有能帮你度过会议的东西。有带尖刺的玩具让你在早上保持活力，有软绵绵的让你在下午放松。我对此做了太多的研究。我应该找个时间寄给你一个。我做了几个原型盒子，但最后没能量产，所以我有时只是寄给客户。但是……

---

### [01:00:56] Lenny

**English:**
I'll take it.

**中文翻译:**
我要一个。

---

### [01:01:46] Donna Lichaw

**English:**
Good. I'll put that on my list of things I-

**中文翻译:**
好。我会把它列入我的清单……

---

### [01:01:49] Lenny

**English:**
[inaudible 01:01:49] finish.

**中文翻译:**
（不清晰）……完成它。

---

### [01:01:49] Donna Lichaw

**English:**
... need to do, just also my kryptonite.

**中文翻译:**
……需要做的事，这也是我的氪石。

---

### [01:01:51] Lenny

**English:**
Okay, there's just a couple more things I wanted to touch on and then I'll let you go. One is you have this interesting approach of using product frameworks that people know in their day-to-day building product to translate that to personal growth advice. And so in your book, you use that design thinking double diamond framework for helping people think about their own life and career. Is there a couple you could share that people can maybe think about and use of just here's something you know in product. Here's how you can actually use this in your life, in your career.

**中文翻译:**
好，还有几件事我想谈谈，然后就放你走。一个是，你有一种有趣的方法，就是利用人们在日常产品构建中熟悉的“产品框架”，将其转化为个人成长建议。在你的书里，你使用了设计思维的“双钻石模型”来帮助人们思考自己的人生和职业。你能分享一两个大家可以思考和使用的例子吗？比如“这是你在产品中知道的东西，这是你如何在生活和职业中实际使用它”。

---

### [01:02:23] Donna Lichaw

**English:**
I trained with Gestalt coaches and therapists when I moved into coaching. Gestalt psychology and Gestalt therapy, the idea is that... Well, it's a lot of what I talk about and especially in the book, this idea of when you want to create real lasting powerful change, you don't do it by forcing change to happen, you instead do it by embracing what is and what's working and then figuring out how to leverage that. And so it works for individual therapy, it works for coaching. It also works more broadly for organizational change and giant transformational development projects or initiatives or any kind of change. But one of the theoretical underpinnings there is when you do understand what's working and you start to get an idea of what's possible or something that you want to go try or do or create or make happen, you don't just go and change everything or do it all at once, you take one tiny step and run a little experiment to get data.

**中文翻译:**
当我转向教练领域时，我接受了格式塔（Gestalt）教练和治疗师的培训。格式塔心理学和疗法的核心理念是……这也是我在书里经常谈到的：当你想要创造真正持久且强大的改变时，你不是通过强迫改变发生，而是通过拥抱现状和正在起作用的东西，然后弄清楚如何利用它。这适用于个人治疗，也适用于教练。它也更广泛地适用于组织变革和巨大的转型发展项目。其中的一个理论基础是：当你理解了什么是有效的，并开始对可能性或你想尝试、创造、实现的事情有了想法时，你不要直接去改变一切或一次性完成，而是迈出一小步，进行一个小实验来获取数据。

**(01:03:41):**
**English:**
And so the way I work and the way I learned to work, at least through Gestalt coaching and Gestalt therapy, was you don't leave a session with me without having tried a little experiment first. The analogy there is we would call it an in the room experiment versus then get out of the building and do an experiment. And if you subscribe to, I guess I'm going to call it lean methodology. Although I feel like these names change all the time, and oh, that's so 10 years ago. And I don't care what anything's called, but the idea of experimenting and getting data and then using what you learn to make informed decisions on how to change things and then how to build things and how to make things even more successful, it works for the digital products that we build, it works for the businesses that we build, and it works for ourselves. And ideally, you do it for all the above. And so anything you think is true or you want to do, it's a hypothesis until you test it. And you go out, get data, and then you can do a bigger version, bigger version, bigger version. It works with human psychology and all the things we want to create and learn in life just as well as with products.

**中文翻译:**
所以我工作的方式，以及我学到的工作方式（至少通过格式塔教练和治疗），是你在结束与我的咨询环节之前，必须先尝试一个小实验。打个比方，我们称之为“室内实验”，然后再“走出大楼”去做实验。如果你认同精益方法论（Lean Methodology）——虽然我觉得这些名字总在变，什么“那是 10 年前的东西了”，我不在乎叫什么——但实验、获取数据、利用所学做出明智决策以改变事物、构建事物并让事物更成功的理念，既适用于我们构建的数字产品，也适用于我们建立的业务，同样适用于我们自己。理想情况下，你应该对以上所有都这么做。所以，任何你认为正确或想做的事，在测试之前都只是一个假设。你去实践，获取数据，然后做一个更大的版本，再大一点。这在人类心理学和我们在生活中想要创造和学习的所有事物上都同样有效，就像在产品上一样。

---

### [01:05:08] Lenny

**English:**
Is there an example of one of those little experiments you ran in a session?

**中文翻译:**
你能举个你在咨询环节中运行的小实验的例子吗？

---

### [01:05:10] Donna Lichaw

**English:**
Bring us back to the example of that one executive from earlier, to keep the continuity here, who thought she was too quiet and her team was complaining about her. And actually the irony, often when people come to me with things that they're embarrassed by, on the outside, she was actually quite loud. As a person, she was really loud and brash and all these things, it's just that in terms of her team, they didn't like how quiet she was in meetings. Especially that dissonance there was confusing to them because she was so loud and boisterous and energetic. But using that as an example, I remember when we first realized that the reason why she was so quiet in meetings is because she was spending a lot of time doing deep listening.

**中文翻译:**
回到之前那个高管的例子，为了保持连贯性：她认为自己太安静了，团队也在抱怨她。讽刺的是，通常当人们带着令他们尴尬的事情来找我时，从外表看，她其实挺大声的。作为一个个体，她很大声、傲慢，拥有所有这些特质，只是在团队看来，他们不喜欢她在会议上的沉默。特别是这种反差让他们感到困惑，因为她平时是那么大声、喧闹且精力充沛。但以此为例，我记得当我们第一次意识到她在会议上如此安静是因为她在进行“深度倾听”时。

**(01:06:04):**
**English:**
She started to chill out a little bit about it and stop beating herself up as much and started realizing, "Oh, that's a good thing. Why am I so insecure and getting so angry at myself for doing this all the time?" That's good. She started to chill out a little bit, but then the idea of a bigger experiment was in your next meeting later this afternoon, see what it feels like to sit there and just listen for an hour, just see what it feels like. And then see what you make of it, and then we'll figure out what to do about it. But just see what it feels like to listen and be in awe of, "Wow, I'm really listening."

**中文翻译:**
她开始对此放松了一些，不再那么责备自己，并意识到：“哦，那是件好事。为什么我这么没安全感，并因为一直这样做而对自己发火？”这很好。她开始放松了，然后一个更大实验的想法是：在今天下午的下一次会议中，看看坐在那里仅仅倾听一个小时是什么感觉。看看你的感受，然后我们再决定怎么办。只是去感受倾听的过程，并对自己感到惊叹：“哇，我真的在倾听。”

**(01:06:47):**
**English:**
And so that would been a get out of the building experiment. But the idea of doing that petrified her, because she's like, "I can't sit for a whole hour just being like, 'Yeah,' patting myself on the back. 'I'm a good listener. I'm a good listener. Look at me.' Or not even good or bad, but wow, I'm really listening." That's all I ever want from people is just this radical appreciation, this awe of, wow, I'm doing this. Everything changes when you figure that out.

**中文翻译:**
那本该是一个“走出大楼”的实验。但这个想法让她吓坏了，因为她说：“我没法坐整整一个小时，然后拍着自己的背说：‘我是个好的倾听者，看我。’甚至不是好坏的问题，而是：哇，我真的在听。”我从人们那里想要的只是这种“彻底的欣赏”，这种“哇，我正在做这件事”的敬畏感。当你弄清楚这一点时，一切都会改变。

**(01:07:17):**
**English:**
But we decided to run a little experiment because why waste a whole hour of her life when we could just do something in 30 seconds in the room right now? And so we tried a little role play of, all right, what would it be like to just sit here for 30 seconds? And I talked about I don't know what. And just listen to me. We're having a meeting. What does it feel like for 30 seconds to do that? And we did that. And her answer was, "That was terrifying. That was God awful. Oh my God, I have to do that for a whole hour?" And eventually over time, it got easier. It was very uncomfortable.

**中文翻译:**
但我们决定先做一个小实验，因为既然我们现在可以在房间里花 30 秒做点什么，为什么要浪费她生命中的一个小时呢？于是我们尝试了一个小角色扮演：好吧，在这里坐 30 秒会是什么样子？我随便说点什么，你就听着。我们在开会。做 30 秒这种事感觉如何？我们做了。她的回答是：“那太可怕了。太糟糕了。天哪，我要做整整一个小时吗？”最终随着时间的推移，事情变得容易了。虽然过程非常不舒服。

**(01:08:05):**
**English:**
This is where I'll bring up the whole superhero analogy. Again in superhero stories, when superheroes discover what their superpowers actually are, they don't just say, "Oh, thanks for this gift," and then run and save the world. Every superhero has a really hard time accepting, "Oh, this is my gift? Hell no." Or, "Wait, what do I do with this?" And they wreak havoc and they make a mess and it's uncomfortable. And even Superman tries to get rid of his superpowers often because he doesn't like being super. And so it's hard to know what you're really, really great at.

**中文翻译:**
这就是我要提到的超级英雄比喻。在超级英雄故事中，当英雄们发现自己真正的超能力时，他们不会只是说“哦，谢谢这份礼物”，然后跑去拯救世界。每个超级英雄都很难接受：“哦，这是我的天赋？见鬼，不要。”或者“等等，我该拿它怎么办？”他们会造成破坏，搞得一团糟，而且过程很不舒服。甚至连超人也经常试图摆脱他的超能力，因为他不喜欢变得“超级”。所以，了解你真正擅长什么是非常困难的。

**(01:08:45):**
**English:**
But when you can run little experiments that get bigger and bigger over time and really learn how to... Whether it's embracing your superpowers or anything. Let's say there's something you want to try, something scary. Or look at me with my superhero supply kit. And I was like, "I really want to build a gift box. Let me prototype that." Okay, fine. Five years later, have I done anything with it? No, but I built it. I saw what it's like. It felt good. And then as I got bigger with my experiment of thinking about how can I mass produce this? Where would I sell it? What about taxes? Oh, God. And not for me. And that's fine, so I give them away as gifts. But whether it's product or you or your business, small experiments, get data, go bigger, adjust, iterate, all of it. You will accomplish incredible things.

**中文翻译:**
但当你能运行小实验，并随着时间的推移让它们变得越来越大，真正学会如何……无论是拥抱你的超能力还是任何事情。假设有你想尝试的东西，一些可怕的东西。或者看看我那个超级英雄补给包。我想：“我真的很想做一个礼品盒。让我做个原型。”好吧，五年后，我用它做了什么吗？没有，但我把它做出来了。我看到了它是什么样子。感觉很好。然后随着实验变大，我开始想：我该如何量产？我在哪儿卖？税收怎么办？哦，天哪。那不适合我。这没关系，所以我把它们当作礼物送人。但无论是产品、你个人还是你的业务，小实验、获取数据、扩大规模、调整、迭代，所有这些。你会成就不可思议的事情。

---

### [01:09:39] Lenny

**English:**
And I think a lot of the power there is you feel like, "Wow, there's something new here I didn't expect. And this is a new interesting learning. Let me see where else this can go."

**中文翻译:**
我认为其中的很多力量在于你会觉得：“哇，这里有一些我没预料到的新东西。这是一个有趣的新学习。让我看看它还能往哪里发展。”

---

### [01:09:49] Donna Lichaw

**English:**
Yes. And I think the biggest difference that took me a long time for me to learn is that as opposed to product development, you're testing things not just how is it working and what are the numbers? Well, even with product, we're not just looking at numbers all the time, but when you're experimenting with yourself and with people you work with and with your teams and with your companies, you run it through three filters. And this is not my term, but I'll say head, heart, hands is what I like to think of, which is head, okay, how's this going? What are my thoughts? You might think, yeah, okay, I'm listening. That's fine. Okay, next. Emotionally, how is this going in your heart? Wow, I'm terrified. This feels awful, or this isn't so bad, or whatever it is. Or it might be, no, that's fine. I hear that a lot. "That was fine."

**中文翻译:**
是的。我认为我花了很长时间才学到的最大区别是：与产品开发不同，你测试的不仅仅是“它运行得如何”以及“数据是多少”。好吧，即使是产品，我们也不只是看数据。但当你对自己、同事、团队和公司进行实验时，你需要通过三个过滤器。这不是我的术语，但我喜欢称之为“头、心、手”（Head, Heart, Hands）。“头”：好吧，进展如何？我的想法是什么？你可能会想，是的，我在听，没问题。“心”：情感上，你心里感觉如何？哇，我吓坏了，这感觉糟透了；或者这还不算太糟。或者可能是，不，挺好的。我经常听到这种话，“挺好的”。

**(01:10:52):**
**English:**
But then how does it feel in your body? Our bodies are ultimately where we take in our stimuli and then store all of our experiences. And our body also tells us what next action we should take. And if you run an experiment and scan your body and it's like, "Yeah, that felt fine. And then how do you feel in your body? "Oh, numb." Well, that will tell you something.

**中文翻译:**
但接着是“手”（身体）：你的身体感觉如何？我们的身体最终是我们接收刺激并存储所有经验的地方。我们的身体也会告诉我们下一步该采取什么行动。如果你运行一个实验并扫描你的身体，如果你说“感觉挺好”，但身体的感觉是“哦，麻木了”。那这就能说明一些问题。

**(01:11:19):**
**English:**
Or I hear this all the time, "How do you feel?" "My hands are on fire." Or I was working with one client yesterday, and I think she said something like, "That was fine," and her whole face turned bright red. And then after a minute we were able to say, "Okay, what's going... Fine versus your face turned bright red. What happened there?" And then she realized, "Oh, I'm burning up. This is not okay." Yeah, run it through head, heart, hands. Life is like product thinking and it's also not. We have to go deeper and more broad with our experiences, and then we'll learn the most and be able to make the most informed, amazing decisions. And this is so cheesy, but live a good life and make an impact and be a great leader and do all the things you want to do that way.

**中文翻译:**
或者我经常听到：“你感觉如何？”“我的手像着火了一样。”昨天我正和一位客户合作，她说“挺好的”，但她的整张脸都变红了。一分钟后我们说：“好吧，发生了什么……你说‘挺好’，但你的脸通红。那是怎么回事？”然后她意识到：“哦，我感觉浑身发烫。这不太对劲。”是的，通过“头、心、手”来运行实验。生活既像产品思维，又不完全像。我们必须更深入、更广泛地体验，然后我们才能学到最多，并做出最明智、最棒的决定。虽然这听起来很俗气，但通过这种方式，你可以过上美好的生活，产生影响力，成为一名伟大的领导者，并做所有你想做的事。

---

### [01:12:17] Lenny

**English:**
Beautiful. The point you just made about how much of our thinking is driven by our body, we just had a whole episode on this a few episodes ago with Johnny Miller where we talk about the nervous system and how most of our neurons go up to our brain versus down from the brain and our body's telling our brain what we're feeling, so there's a lot. If you want to explore that as a listener, that's a great episode. We'll link to it in the show notes.

**中文翻译:**
太棒了。你刚才提到的关于我们的思维在多大程度上是由身体驱动的这一点，我们在几集前和 Johnny Miller 专门做了一期节目，讨论了神经系统，以及我们的大多数神经元是如何向上通往大脑，而不是从大脑向下传导的，我们的身体在告诉大脑我们的感受。如果你作为听众想探索这一点，那是很棒的一集。我们会把它链接在节目笔记里。

---

### [01:12:40] Donna Lichaw

**English:**
Okay, good, good.

**中文翻译:**
好的，太好了。

---

### [01:12:41] Lenny

**English:**
Okay, let me ask you a question that my colleague suggested. She gave me a few suggestions to ask you. And I imagine this is what worked for her in you two working together. Question she had is how as an executive coach do you help identify/bring out goals or wishes that people have in their subconscious but are unable to realize or articulate?

**中文翻译:**
好，让我问你一个我同事建议的问题。她给了我几个建议来问你。我猜这是你们合作时对她有效的方法。她的问题是：作为一名高管教练，你如何帮助识别或挖掘出人们潜意识中存在、但无法意识到或表达出来的目标或愿望？

---

### [01:13:06] Donna Lichaw

**English:**
Start with the ending. Come up with how you want things to turn out, and then work your way back. And start as far out as you want. It could be decades from now, it could be five years from now, it could be three years from now, it could be a year from now, it could be a quarter from now. It could do all the above. And really imagine. Close your eyes; imagine you're there. Engage all your senses. What do you hear? What do you smell? What do you see? Who do you see? What do you feel emotionally, physically? And what are you doing? What have you accomplished? What's amazing?

**中文翻译:**
从结局开始。构思你希望事情最终变成什么样，然后倒推。你可以从任意远的时间点开始：几十年后、五年后、三年后、一年后，甚至一个季度后。你可以全部尝试。真正去想象。闭上眼睛，想象你就在那里。动用你所有的感官：你听到了什么？闻到了什么？看到了什么？看到了谁？情感上和身体上感觉如何？你在做什么？你成就了什么？有什么了不起的事？

**(01:13:45):**
**English:**
And then if you've got something exciting, go back to the beginning and then imagine how you got there and just write that journey out. If you think of it as an experimental roadmap, then start thinking, all right, what's the first thing I need to learn to know if this is right? Work your way towards that and onwards.

**中文翻译:**
如果你发现了一些令人兴奋的事情，回到起点，然后想象你是如何到达那里的，并把那段旅程写下来。如果你把它看作一个“实验路线图”，那么开始思考：好吧，为了知道这是否正确，我需要学习的第一件事是什么？朝着那个方向努力，然后继续前进。

**(01:14:15):**
**English:**
If you do that and you're like, "I have no vision," which I remember is what happened in this case, you sit with it for longer. You can't write that journey if you don't have that ending. And so you sit with it for as long as you need until you get it, and then you create it. And again, it sounds so cheesy in a way. It's not like I'm subscribing to this anything you want in life, you just say it and accomplish it. I know life doesn't exist like that, but dream it, see it, and then start taking steps to get there. What you end up creating will very likely be very different than you ever imagined. But this is what's going to fuel you. We're human, we're visual creatures. And so yeah.

**中文翻译:**
如果你这么做了，却觉得“我没有愿景”（我记得在这个案例中就是这样），那你就多花点时间沉浸其中。如果你没有那个结局，你就无法写出那段旅程。所以你就坐在那里，需要多久就坐多久，直到你找到它，然后去创造它。再次强调，这听起来有点俗气。我并不是在宣扬“生活中你想要什么，只要说出来就能实现”。我知道生活不是那样的，但去梦想它，看见它，然后开始采取步骤去实现它。你最终创造出来的东西很可能与你想象的完全不同。但这正是为你提供动力燃料的东西。我们是人类，是视觉动物。所以，是的。

---

### [01:15:08] Lenny

**English:**
I was going to say this is a great tease for a part of your book we didn't get too much, so a good reason to go buy the book. Something I was going to say as you were talking is with this coach I worked with once, we did this exercise. And I was like, "Okay, five years or maybe 10 years, I'm not working anymore. Here's what I'm doing. I'm living here. Family." She's like, "Everyone in tech is like in five years they're not working anymore. They're just done, they're retired." Everybody's in that. That's their future, which is not obviously realistic, but it's hilarious.

**中文翻译:**
我想说，这对于你书中我们没怎么涉及的部分是一个很好的预告，也是去买书的一个好理由。当你说话时我想说的是，我曾经合作过的一位教练，我们也做过这个练习。我说：“好吧，5 年或 10 年后，我不再工作了。这就是我在做的：住在这里，和家人在一起。”她说：“科技行业的每个人都一样，都觉得 5 年后就不工作了，干完了，退休了。”每个人都这么想。那是他们的未来，显然不现实，但很有趣。

---

### [01:16:00] Donna Lichaw

**English:**
Yeah. I remember years ago, 10 years ago, I was like, "10 years from now, I'm definitely not working in tech, definitely not working in tech." And then here we are. But it's funny how things end up. But what matters is that you're clear on the impact that you want to make. And how you make it, who knows what'll end up being the case. And that you're doing it true to yourself.

**中文翻译:**
是的。我记得 10 年前，我说：“10 年后，我绝对不在科技行业工作，绝对不在。”结果我们现在就在这儿。事情的结局总是很有趣。但重要的是，你清楚自己想要产生什么样的影响。至于你如何实现它，谁知道最终会是什么情况呢。关键在于你是在忠于自我地去做。

---

### [01:16:23] Lenny

**English:**
And impact is another chapter in your book, which we also didn't get to, so there's a lot of context.

**中文翻译:**
“影响力”是你书中的另一章，我们也没谈到，所以书中还有很多内容。

---

### [01:16:27] Donna Lichaw

**English:**
So many teasers. Yes, go buy the book.

**中文翻译:**
这么多预告。是的，去买书吧。

---

### [01:16:29] Lenny

**English:**
So many teasers. Donna, is there anything you wanted to share or leave listeners with before we get to a very exciting lightning round?

**中文翻译:**
这么多预告。Donna，在进入非常精彩的闪电轮环节之前，你还有什么想分享或留给听众的吗？

---

### [01:16:36] Donna Lichaw

**English:**
No, no. It's been so delightful chatting with you. No, nothing else.

**中文翻译:**
没有了。和你聊天非常愉快。没有别的了。

---

### [01:16:44] Lenny

**English:**
Well, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
好，那么我们进入了非常精彩的闪电轮环节。准备好了吗？

---

### [01:16:47] Donna Lichaw

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [01:16:49] Lenny

**English:**
First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:16:55] Donna Lichaw

**English:**
Here's a funny thing is I used to have all these different books for different topics. I'm going to give you the worst answer, but it's true. All these different books for different topics. And similar to when I was working in product, I had all these different books and whatever. And then eventually I realized I need to write the book that I really want to recommend, and so I did that with my last book, The User's Journey, which is all about product development. This sounds so conceited, but I really believe it, I now recommend my book the most. And it combines all my favorite ideas, philosophies, books out there. And you can check out the bibliography to see all the 30, 50 books that you can read otherwise. But man, I sound like such a jerk.

**中文翻译:**
有趣的是，我以前针对不同的主题有各种不同的书。我要给你一个最糟糕的答案，但这是真的。针对不同主题有各种书。就像我做产品时一样，我有各种各样的书。但最终我意识到，我需要写一本我真正想推荐的书。所以我写了上一本书《用户的旅程》（The User's Journey），那是关于产品开发的。这听起来可能很自负，但我真的相信这一点：我现在推荐最多的是我自己的书。它结合了我所有喜欢的想法、哲学和市面上的书籍。你可以查看参考书目，看看那 30 到 50 本你也可以读的书。天哪，我听起来像个混蛋。

---

### [01:17:40] Lenny

**English:**
No, I get this because this is what my newsletter was originally is I'll just do my best to define an answer to this question I get often and put it together and make it really good so that I could send people, "Here's my best answer to this question." But every time I do that, they're like, "Oh, brother, just sending your own blog post to me. Just tell me an answer." I'm like, "But I've written the best version of it here. This is going to answer everything you're looking for." I go through the same pain. Okay, next question. Do you have a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
不，我理解。因为我的时事通讯最初就是这样的：我会尽力为我经常收到的问题定义一个答案，把它整理好，做得非常棒，这样我就可以发给别人说：“这是我对这个问题的最佳答案。”但每次我这么做，他们都会说：“噢，老兄，你只是把自己的博客文章发给我。直接告诉我答案就行。”我会说：“但我已经在这里写出了最好的版本。这会回答你想要的一切。”我也经历过同样的痛苦。好，下一个问题：你最近有特别喜欢的电影或电视节目吗？

---

### [01:18:15] Donna Lichaw

**English:**
A show I've been watching recently, and I feel funny saying this because the fourth season was on recently, and I didn't enjoy it as much, but the first few seasons were so much fun, was For All Mankind on Apple TV. Have you seen it? The-

**中文翻译:**
我最近一直在看的一部剧（说起来有点奇怪，因为第四季最近刚播，我没那么喜欢，但前几季非常有趣），是 Apple TV 上的《为全人类》（For All Mankind）。你看过吗？

---

### [01:18:32] Lenny

**English:**
Yeah, yeah.

**中文翻译:**
看过，看过。

---

### [01:18:34] Donna Lichaw

**English:**
It was so much fun. It was all like what if the space industry was in an alternate reality and the last few decades were different than what they were? That was very fun. And for work stuff, a lot of my clients love watching Ted Lasso for all the leadership stuff. And it's just such a sweet show. But yeah, For All Mankind is recent. That's really fun.

**中文翻译:**
非常有趣。它讲的是如果航天工业处于一个平行现实中，过去几十年与现实不同会怎样？非常有趣。至于工作方面，我的很多客户喜欢看《泰德·拉索》（Ted Lasso），为了学习里面的领导力内容。那真是一部温馨的剧。是的，《为全人类》是最近看的，很有趣。

---

### [01:19:00] Lenny

**English:**
Next question, do you have a favorite interview question that you like to ask? Usually this is meant for people interviewing candidates, but is there anything that comes to mind when I ask this question?

**中文翻译:**
下一个问题：你有没有最喜欢的面试问题？通常这是针对面试候选人的，但当我问这个问题时，你脑海中浮现了什么？

---

### [01:19:10] Donna Lichaw

**English:**
The question I always ask when I'm interviewing clients. Because if I'm not excited about what you you're doing, we're not going to work together. Yeah, I want to know what that is. And so imagine it's a few years out and you've had the best however long, year or three years of your life, what would you be telling me? And I like to add a twist to that, which is from Benjamin Zander in a book called The Art of Possibility, where with his students, he used to say, "Give yourself an A. If you could give yourself an A at the end of the semester, what would you be writing? Write the ending." And so I love doing that with clients, just seeing what could be possible that we could create if we work together?

**中文翻译:**
这是我面试客户时总会问的问题。因为如果我对你正在做的事情不感到兴奋，我们就不会合作。我想知道那是什么。所以：想象几年后，你度过了人生中最好的一段时光（一年或三年），你会告诉我什么？我喜欢加一个转折，这来自本杰明·赞德（Benjamin Zander）的《可能性的艺术》一书，他曾对学生说：“给自己一个 A。如果你能在学期末给自己一个 A，你会写些什么？写下结局。”我喜欢和客户一起做这件事，看看如果我们合作，我们可以创造出什么样的可能性？

**(01:20:10):**
**English:**
Same thing with job candidates, although it's reminding me, one of my first jobs I ever got out of college, this is in the early .com days, I remember my then who became my boss, he asked me that question when he was interviewing me, where I saw myself in five years. And I remember at the time, my answer was, "Not here, and hopefully making documentary films." And this is like a .com job, but in hindsight, I can't believe I answered it that way. I was like, "Yeah, I'm going to be doing something else in five years." And he loved it so much that he hired me on the spot. And we're still friends many decades later. Yeah, that's my favorite interview question all around.

**中文翻译:**
对求职者也是一样。这让我想起我大学毕业后的第一份工作，那是早期的互联网时代。我记得我后来的老板在面试我时问我：你认为五年后的自己在哪里？我记得当时的回答是：“不在这里，希望能拍纪录片。”这可是一份互联网公司的工作，现在回想起来，我真不敢相信我竟然那样回答。我说：“是的，五年后我会做别的事情。”结果他非常喜欢这个回答，当场就雇用了我。几十年后我们仍然是朋友。是的，这是我最喜欢的面试问题。

---

### [01:20:55] Lenny

**English:**
It's similar to question people often using product of just what is the ideal experience that... What's the perfect version of what we're building? And let's work backwards from that. Or what's like the 10 X version?

**中文翻译:**
这类似于人们在产品中经常问的问题：什么是理想的体验……我们正在构建的东西的完美版本是什么？然后让我们倒推。或者什么是 10 倍好的版本？

---

### [01:21:05] Donna Lichaw

**English:**
Exactly. Or if you want to add to that, if you could wave a magic wand, it's the same kind of thing. What could be possible?

**中文翻译:**
没错。或者如果你想加一点：“如果你能挥动魔法棒”，也是类似的意思。什么是可能的？

---

### [01:21:13] Lenny

**English:**
I love the leveraging of product thinking into coaching. I love it. Next question, do you have a favorite product that you've recently discovered that you love? Maybe you already mentioned the squishy thing. Maybe something else comes to mind.

**中文翻译:**
我喜欢将产品思维应用到教练中。太棒了。下一个问题：你最近有没有发现什么特别喜欢的产品？也许你已经提到了那个捏捏乐，还有别的吗？

---

### [01:21:28] Donna Lichaw

**English:**
My fidgets, all my fidgets. I have so many; many different kinds. They're so much fun. I'm sure I have a better answer somewhere. But yeah, I would say my fidgets.

**中文翻译:**
我的解压玩具，我所有的解压玩具。我有非常多，各种各样的。它们非常有趣。我相信我肯定还有更好的答案，但目前我会说是我的解压玩具。

---

### [01:21:38] Lenny

**English:**
Well, if you can point us to your favorites in links, that would be awesome. I'm sure people are curious what you've discovered.

**中文翻译:**
好，如果你能通过链接向我们展示你最喜欢的那些，那就太棒了。我相信大家很好奇你发现了什么。

---

### [01:21:44] Donna Lichaw

**English:**
Yes. I curate them. I will definitely do that.

**中文翻译:**
是的，我收集了它们。我一定会提供的。

---

### [01:21:48] Lenny

**English:**
How amazing. I'm going to [inaudible 01:21:48] that.

**中文翻译:**
太神奇了。我会（不清晰）那个。

---

### [01:21:47] Donna Lichaw

**English:**
Yep. And there's also the long one, the sticky monkey noodles. So many.

**中文翻译:**
是的。还有一个长长的，叫“粘粘猴面条”。非常多。

---

### [01:21:48] Lenny

**English:**
Beautiful, purple.

**中文翻译:**
漂亮的紫色。

---

### [01:21:52] Donna Lichaw

**English:**
So many.

**中文翻译:**
非常多。

---

### [01:21:53] Lenny

**English:**
Amazing. Do you have a favorite life motto that you often find yourself coming back to sharing with friends or family, either in work or in life?

**中文翻译:**
太棒了。你有没有最喜欢的人生格言，是你经常在工作或生活中与朋友或家人分享的？

---

### [01:22:04] Donna Lichaw

**English:**
It's a phrase that I got from one of my mentors, and I teach it to all my clients, which is... Her catchphrase is, "Isn't that interesting?" And I have it as a sticky note, a physical sticky note on my computer monitor to remind me, which what it reminds me to do is get into what Gestalt folks call an optimistic stance. And I'm a chronic, serious, acute pessimist. Anyone who knows me, I'm cranky, but I love this reminder to be in this optimistic stance. Again, not that Stuart Smalley, "Wow, everything's great. Woohoo," but it's a kind of radical appreciation. Not isn't this good or bad, but wow, I just stubbed my toe and it really hurts. Isn't that interesting? Let me feel that throbbing toe. Or, wow, someone on my team just talked over me in a meeting 20 times in the last hour.

**中文翻译:**
这是我从一位导师那里学到的一句话，我也教给我所有的客户。她的口头禅是：“这难道不有趣吗？”（Isn't that interesting?）我把它写在便利贴上，贴在我的电脑显示器上提醒自己。它提醒我进入格式塔学派所说的“乐观姿态”。我是一个长期的、严重的、急性悲观主义者。认识我的人都知道我脾气不好，但我喜欢这个提醒，让我保持乐观姿态。再次强调，不是那种“哇，一切都太棒了，呜呼”式的乐观，而是一种“彻底的欣赏”。不是判断好坏，而是：哇，我刚踢到了脚趾，真的很疼。这难道不有趣吗？让我感受一下脚趾的跳痛。或者：哇，我团队里的某个人在过去一小时的会议中打断了我 20 次。

**(01:23:14):**
**English:**
Actually, this happened with a client recently. I was there at an executive team meeting, and someone kept talking over the CEO over and over and over again. And often when that happens, you bark right back or you get angry or you get quiet or whatever it is, but when you can really fully appreciate, isn't that interesting? My shoulders are really tensing up right now. Wow. Whatever's going on. You often have more informed... Not often. You will always have more informed, mindful actions that you can take or not take. You can't pay me to meditate or anything or do yoga, but mindfulness, yeah, if you could just think to yourself, isn't that interesting? anytime something extreme happens in life, you will be shocked at what you learn and at what you do accordingly.

**中文翻译:**
实际上，最近在一位客户那里就发生了这种事。我当时在参加一个高管团队会议，有人不停地打断 CEO。通常当这种情况发生时，你会反击、生气或保持沉默，但当你能真正充分欣赏时：“这难道不有趣吗？我的肩膀现在真的很紧张。哇。”无论发生了什么。你通常会有更明智的……不，是“总是”会有更明智、更有意识的行动（或不行动）。你没法付钱让我去冥想或练瑜伽，但正念——是的，如果你能在生活中发生极端事情时对自己说“这难道不有趣吗？”，你会对自己学到的东西以及随之而来的行动感到震惊。

---

### [01:24:10] Lenny

**English:**
Very Buddhist, non-judgmental awareness.

**中文翻译:**
非常有禅意，不带评判的觉察。

---

### [01:24:13] Donna Lichaw

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:24:13] Lenny

**English:**
Similar.

**中文翻译:**
很相似。

---

### [01:24:14] Donna Lichaw

**English:**
It's exactly that.

**中文翻译:**
正是如此。

---

### [01:24:15] Lenny

**English:**
Not deciding it's good or bad.

**中文翻译:**
不去判定它是好是坏。

---

### [01:24:16] Donna Lichaw

**English:**
Yep.

**中文翻译:**
是的。

---

### [01:24:17] Lenny

**English:**
Final question. I'm surprised you haven't used any Dolly Parton quotes in this conversation. Clearly in your book, you're a big fan.

**中文翻译:**
最后一个问题。我很惊讶你在这次对话中没有引用多莉·帕顿（Dolly Parton）的名言。显然在你的书里，你是她的超级粉丝。

---

### [01:24:25] Donna Lichaw

**English:**
That's right.

**中文翻译:**
没错。

---

### [01:24:25] Lenny

**English:**
I'm curious, what's a wisdom or quote that comes to mind that you think of from Dolly Parton that might be helpful?

**中文翻译:**
我很想知道，多莉·帕顿的哪句智慧之言或名言是你认为可能有帮助的？

---

### [01:24:34] Donna Lichaw

**English:**
Yes, and thank you for reminding me, because that was originally what I was going to say, which is one of my... There's so many Dolly quotes. And I think all my favorites are in my book, of course, but one of my favorites is, "Find out who you are and do it on purpose." That's amazing. Another one, "You don't like the..." I guess my two favorites. "You don't like the path you're walking on, pave a new path." What more in life do you need than that? There's all, yeah, Buddhist and Gestalt and mindfulness or whatever, but you could just do what Dolly does and you'll be all good.

**中文翻译:**
是的，谢谢你提醒我，因为那原本是我打算说的。多莉的名言太多了，我想我最喜欢的都在书里。其中一句是：“找出你是谁，然后有目的地去做。”这太棒了。另一句，我想是我最喜欢的两句之一：“如果你不喜欢你正在走的这条路，那就铺一条新路。”生活中你还需要比这更多的东西吗？虽然有禅宗、格式塔、正念等等，但你只要像多莉那样做，你就会过得很好。

---

### [01:25:14] Lenny

**English:**
Donna, thank you so much for being here. Two final questions. Where can folks find you if they want to reach out, maybe work with you? And how can listeners be useful to you?

**中文翻译:**
Donna，非常感谢你来到这里。最后两个问题：如果大家想联系你，或者想和你合作，可以在哪里找到你？听众可以为你提供什么帮助？

---

### [01:25:25] Donna Lichaw

**English:**
Great questions, as always. The best way to find me is through my website, donnalichaw.com. And that'll be in the show notes as well. And reach out to me for a conversation. One of my superpowers that's also my kryptonite is accessibility. I'm that author who will always email you back, even though I hate emailing, always email you back within a day if you send me an email about the book. Same thing about working together. I always make time. Or even just conversation, I make time for any conversations with interesting people if it is exciting to both of us to make it happen. Find me on my website, donnalichaw.com. I've also got tons of free stuff there that you can download as well. Everything that we talked about today, a lot of the things that we talked about today are available there to play with as well.

**中文翻译:**
一如既往的好问题。找到我最好的方式是通过我的网站 donnalichaw.com，链接也会放在节目笔记里。欢迎联系我进行交流。我的超能力之一（同时也是我的氪石）就是“易接近性”。我是那种即使讨厌发邮件也一定会回你邮件的作者，如果你给我发关于书的邮件，我通常会在一天内回复。关于合作也是一样，我总会抽出时间。或者仅仅是聊天，如果对我们双方来说都很兴奋，我会为任何与有趣的人的对话腾出时间。在 donnalichaw.com 上找我，那里还有很多免费资料可以下载。我们今天谈论的很多内容，在那里都有可以实践的工具。

---

### [01:26:21] Lenny

**English:**
Amazing. I think we're going to create a lot more superheroes with origin stories, superpowers, kryptonites, missions, impact, all the things you've written about in your book. Donna, thank you so much for being here.

**中文翻译:**
太棒了。我想我们会创造出更多的超级英雄，拥有各自的起源故事、超能力、氪石、使命和影响力，也就是你在书中所写的所有这些。Donna，非常感谢你能来。

---

### [01:26:35] Donna Lichaw

**English:**
Thank you, Lenny. This was a treat.

**中文翻译:**
谢谢你，Lenny。这是一次愉快的经历。

---

### [01:26:37] Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众找到我们。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。